// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Hebrew (`he`).
class AppLocalizationsHe extends AppLocalizations {
  AppLocalizationsHe([String locale = 'he']) : super(locale);

  @override
  String get enterYourEmailAddress => 'הכנס את כתובת הדוא״ל שלך';

  @override
  String get enterYourNewEmailAddress => 'Enter your new email address';

  @override
  String get accountWelcomeBack => 'ברוך שובך!';

  @override
  String get emailAlreadyRegistered => 'Email already registered.';

  @override
  String get emailNotRegistered => 'Email not registered.';

  @override
  String get email => 'דוא\"ל';

  @override
  String get cancel => 'בטל';

  @override
  String get verify => 'אמת';

  @override
  String get invalidEmailAddress => 'כתובת דוא״ל לא תקינה';

  @override
  String get enterValidEmail => 'אנא הכנס כתובת דוא\"ל חוקית.';

  @override
  String get deleteAccount => 'מחק חשבון';

  @override
  String get deleteAccountWarning =>
      'This will delete your Ente Auth, Ente Photos and Ente Locker account.';

  @override
  String get askDeleteReason =>
      'מה הסיבה העיקרית שבגללה אתה מוחק את החשבון שלך?';

  @override
  String get deleteAccountFeedbackPrompt =>
      'אנחנו מצטערים לראות שאתה עוזב. אנא תחלוק את המשוב שלך כדי לעזור לנו להשתפר.';

  @override
  String get feedback => 'משוב';

  @override
  String get kindlyHelpUsWithThisInformation => 'אנא עזור לנו עם המידע הזה';

  @override
  String get confirmDeletePrompt =>
      'Yes, I want to permanently delete this account and its data across all apps.';

  @override
  String get confirmAccountDeletion => 'אשר את מחיקת החשבון';

  @override
  String get deleteAccountPermanentlyButton => 'מחק את החשבון לצמיתות';

  @override
  String get yourAccountHasBeenDeleted => 'החשבון שלך נמחק';

  @override
  String get selectReason => 'בחר סיבה';

  @override
  String get deleteReason1 => 'חסר מאפיין מרכזי שאני צריך';

  @override
  String get deleteReason2 =>
      'היישומון או מאפיין מסוים לא מתנהג כמו שאני חושב שהוא צריך';

  @override
  String get deleteReason3 => 'מצאתי שירות אחר שאני יותר מחבב';

  @override
  String get deleteReason4 => 'הסיבה שלי לא כלולה';

  @override
  String get sendEmail => 'שלח דוא\"ל';

  @override
  String get deleteRequestSLAText => 'הבקשה שלך תועבד תוך 72 שעות.';

  @override
  String get deleteEmailRequest =>
      'אנא תשלח דוא\"ל ל<warning>account-deletion@ente.io</warning> מהכתובת דוא\"ל שנרשמת איתה.';

  @override
  String get entePhotosPerm =>
      'Ente <i>צריך הרשאות על מנת </i> לשמור את התמונות שלך';

  @override
  String get ok => 'אוקיי';

  @override
  String get createAccount => 'צור חשבון';

  @override
  String get createNewAccount => 'צור חשבון חדש';

  @override
  String get password => 'סיסמא';

  @override
  String get confirmPassword => 'אמת סיסמא';

  @override
  String get activeSessions => 'חיבורים פעילים';

  @override
  String get ocrProcessingOverlayMessage => 'Detecting text...';

  @override
  String get ocrLoadingIndicatorLabel => 'Detecting Text';

  @override
  String get ocrSelectionHint =>
      'Swipe or double tap to select just what you need';

  @override
  String get ocrNoTextDetected => 'No text detected';

  @override
  String get ocrRetryButtonLabel => 'Retry';

  @override
  String get ocrModelsNetworkRequiredError =>
      'Network connection required to download OCR models on first use';

  @override
  String get ocrModelsPrepareFailed => 'Could not prepare OCR models';

  @override
  String get ocrImageNotFoundError => 'Image file not found';

  @override
  String get ocrImageDecodeFailedError => 'Could not read image file';

  @override
  String get ocrGenericDetectError => 'Could not detect text in image';

  @override
  String get oops => 'אופס';

  @override
  String get somethingWentWrongPleaseTryAgain => 'משהו השתבש, אנא נסה שנית';

  @override
  String get thisWillLogYouOutOfThisDevice => 'זה ינתק אותך במכשיר זה!';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice =>
      'זה ינתק אותך מהמכשיר הבא:';

  @override
  String get terminateSession => 'סיים חיבור?';

  @override
  String get terminate => 'סיים';

  @override
  String get thisDevice => 'מכשיר זה';

  @override
  String get recoverButton => 'שחזר';

  @override
  String get recoverySuccessful => 'השחזור עבר בהצלחה!';

  @override
  String get decrypting => 'מפענח...';

  @override
  String get incorrectRecoveryKeyTitle => 'מפתח שחזור שגוי';

  @override
  String get incorrectRecoveryKeyBody => 'המפתח שחזור שהזנת שגוי';

  @override
  String get forgotPassword => 'שכחתי סיסמה';

  @override
  String get enterYourRecoveryKey => 'הזן את מפתח השחזור שלך';

  @override
  String get noRecoveryKey => 'אין מפתח שחזור?';

  @override
  String get sorry => 'מצטער';

  @override
  String get noRecoveryKeyNoDecryption =>
      'בשל טבע הפרוטוקול של ההצפנת קצה-אל-קצה שלנו, אין אפשרות לפענח את הנתונים שלך בלי הסיסמה או מפתח השחזור שלך';

  @override
  String get verifyEmail => 'אימות דוא\"ל';

  @override
  String get toResetVerifyEmail =>
      'כדי לאפס את הסיסמא שלך, אנא אמת את האימייל שלך קודם.';

  @override
  String get checkInboxAndSpamFolder =>
      'אנא בדוק את תיבת הדואר שלך (והספאם) כדי להשלים את האימות';

  @override
  String get tapToEnterCode => 'הקש כדי להזין את הקוד';

  @override
  String get resendEmail => 'שלח דוא\"ל מחדש';

  @override
  String weHaveSendEmailTo({required String email}) {
    return 'שלחנו דוא\"ל ל<green>$email</green>';
  }

  @override
  String get setPasswordTitle => 'הגדר סיסמא';

  @override
  String get changePasswordTitle => 'שנה סיסמה';

  @override
  String get resetPasswordTitle => 'איפוס סיסמה';

  @override
  String get encryptionKeys => 'מפתחות ההצפנה';

  @override
  String get passwordWarning =>
      'אנחנו לא שומרים את הסיסמא הזו, לכן אם אתה שוכח אותה, <underline>אנחנו לא יכולים לפענח את המידע שלך</underline>';

  @override
  String get enterPasswordToEncrypt => 'הזן סיסמא כדי שנוכל לפענח את המידע שלך';

  @override
  String get enterNewPasswordToEncrypt =>
      'הזן סיסמא חדשה שנוכל להשתמש בה כדי להצפין את המידע שלך';

  @override
  String get weakStrength => 'חלשה';

  @override
  String get strongStrength => 'חזקה';

  @override
  String get moderateStrength => 'מתונה';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'חוזק הסיסמא: $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully => 'הססמה הוחלפה בהצלחה';

  @override
  String get generatingEncryptionKeys => 'יוצר מפתחות הצפנה...';

  @override
  String get pleaseWait => 'אנא המתן...';

  @override
  String get continueLabel => 'המשך';

  @override
  String get insecureDevice => 'מכשיר בלתי מאובטח';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'אנחנו מצטערים, לא הצלחנו ליצור מפתחות מאובטחים על מכשיר זה.\n\nאנא הירשם ממכשיר אחר.';

  @override
  String get howItWorks => 'איך זה עובד';

  @override
  String get encryption => 'הצפנה';

  @override
  String get ackPasswordLostWarning =>
      'אני מבין שאם אאבד את הסיסמא, אני עלול לאבד את המידע שלי מכיוון שהמידע שלי <underline>מוצפן מקצה אל קצה</underline>.';

  @override
  String get privacyPolicyTitle => 'מדיניות פרטיות';

  @override
  String get termsOfServicesTitle => 'תנאים';

  @override
  String get signUpTerms =>
      'אני מסכים ל<u-terms>תנאי שירות</u-terms> ול<u-policy>מדיניות הפרטיות</u-policy>';

  @override
  String get logInLabel => 'התחבר';

  @override
  String get loginTerms =>
      'על ידי לחיצה על התחברות, אני מסכים ל<u-terms>תנאי שירות</u-terms> ול<u-policy>מדיניות הפרטיות</u-policy>';

  @override
  String get changeEmail => 'שנה דוא\"ל';

  @override
  String get enterYourPassword => 'הכנס סיסמא';

  @override
  String get welcomeBack => 'ברוך שובך!';

  @override
  String get contactSupport => 'צור קשר עם התמיכה';

  @override
  String get locationPickerTip =>
      'You can also add a location centered on a photo from the photo\'s info screen';

  @override
  String get incorrectPasswordTitle => 'סיסמא לא נכונה';

  @override
  String get pleaseTryAgain => 'אנא נסה שנית';

  @override
  String get recreatePasswordTitle => 'צור סיסמא מחדש';

  @override
  String get useRecoveryKey => 'השתמש במפתח שחזור';

  @override
  String get recreatePasswordBody =>
      'המכשיר הנוכחי אינו חזק מספיק כדי לאמת את הסיסמא שלך, אבל אנחנו יכולים ליצור בצורה שתעבוד עם כל המכשירים.\n\nאנא התחבר בעזרת המפתח שחזור שלך וצור מחדש את הסיסמא שלך (אתה יכול להשתמש באותה אחת אם אתה רוצה).';

  @override
  String get verifyPassword => 'אמת סיסמא';

  @override
  String get recoveryKey => 'מפתח שחזור';

  @override
  String get recoveryKeyOnForgotPassword =>
      'אם אתה שוכח את הסיסמא שלך, הדרך היחידה שתוכל לשחזר את המידע שלך היא עם המפתח הזה.';

  @override
  String get recoveryKeySaveDescription =>
      'אנחנו לא מאחסנים את המפתח הזה, אנא שמור את המפתח 24 מילים הזה במקום בטוח.';

  @override
  String get doThisLater => 'מאוחר יותר';

  @override
  String get saveKey => 'שמור מפתח';

  @override
  String get recoveryKeyCopiedToClipboard => 'מפתח השחזור הועתק ללוח';

  @override
  String get recoverAccount => 'שחזר חשבון';

  @override
  String get recover => 'שחזר';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'אנא תשלח דוא\"ל ל$supportEmail מהכתובת דוא\"ל שנרשמת איתה';
  }

  @override
  String get twofactorSetup => 'אימות דו-שלבי';

  @override
  String get enterCode => 'הזן קוד';

  @override
  String get scanCode => 'סרוק קוד';

  @override
  String get codeCopiedToClipboard => 'הקוד הועתק ללוח';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      'תעתיק ותדביק את הקוד הזה\nלאפליקציית האימות שלך';

  @override
  String get tapToCopy => 'הקש כדי להעתיק';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      'סרוק את הברקוד הזה\nבעזרת אפליקציית האימות שלך';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      'הכנס את הקוד בעל 6 ספרות מתוך\nאפליקציית האימות שלך';

  @override
  String get confirm => 'אשר';

  @override
  String get setupComplete => 'ההתקנה הושלמה';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready =>
      'שמור את מפתח השחזור שלך אם לא שמרת כבר';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      'זה יכול לשמש לשחזור החשבון שלך במקרה ותאבד את הגורם השני';

  @override
  String get twofactorAuthenticationPageTitle => 'אימות דו-גורמי';

  @override
  String get lostDevice => 'איבדת את המכשיר?';

  @override
  String get verifyingRecoveryKey => 'מוודא את מפתח השחזור...';

  @override
  String get recoveryKeyVerified => 'מפתח השחזור אומת';

  @override
  String get recoveryKeySuccessBody =>
      'נהדר! מפתח השחזור תקין. אנחנו מודים לך על האימות.\n\nאנא תזכור לגבות את מפתח השחזור שלך באופן בטוח.';

  @override
  String get invalidRecoveryKey =>
      'מפתח השחזור שהזמנת אינו תקין. אנא וודא שהוא מכיל 24 מילים, ותבדוק את האיות של כל אחת.\n\nאם הכנסת קוד שחזור ישן, וודא שהוא בעל 64 אותיות, ותבדוק כל אחת מהן.';

  @override
  String get invalidKey => 'מפתח לא חוקי';

  @override
  String get tryAgain => 'נסה שוב';

  @override
  String get viewRecoveryKey => 'צפה במפתח השחזור';

  @override
  String get confirmRecoveryKey => 'אמת את מפתח השחזור';

  @override
  String get recoveryKeyVerifyReason =>
      'Your recovery key is the only way to recover your photos if you forget your password. You can find your recovery key in Settings > Account.\n\nPlease enter your recovery key here to verify that you have saved it correctly.';

  @override
  String get confirmYourRecoveryKey => 'אמת את מפתח השחזור';

  @override
  String get addViewer => 'הוסף צופה';

  @override
  String get addCollaborator => 'הוסף משתף פעולה';

  @override
  String get admin => 'Admin';

  @override
  String get admins => 'Admins';

  @override
  String get addAdmin => 'Add admin';

  @override
  String get addMoreAdmins => 'Add more admins';

  @override
  String get adminsAndCollaboratorsCanAddPhotosDescription =>
      'Admins and collaborators can add photos. Admins can also manage photos & participants.';

  @override
  String get addANewEmail => 'הוסף דוא\"ל חדש';

  @override
  String get orPickAnExistingOne => 'או בחר באחד קיים';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'משתפי פעולה יכולים להוסיף תמונות וסרטונים לאלבום המשותף.';

  @override
  String get enterEmail => 'הזן דוא\"ל';

  @override
  String get albumOwner => 'בעלים';

  @override
  String get you => 'אתה';

  @override
  String get collaborator => 'משתף פעולה';

  @override
  String get addMore => 'הוסף עוד';

  @override
  String get viewer => 'צפיין';

  @override
  String get remove => 'הסר';

  @override
  String get removeParticipant => 'הסר משתתף';

  @override
  String get manage => 'נהל';

  @override
  String get addedAs => 'הוסף בתור';

  @override
  String get changePermissions => 'שנה הרשאה?';

  @override
  String get yesConvertToViewer => 'כן, המר לצפיין';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return '$user לא יוכל להוסיף עוד תמונות לאלבום זה\n\nהם עדיין יכולו להסיר תמונות קיימות שנוספו על ידיהם';
  }

  @override
  String get allowAddingPhotos => 'אפשר הוספת תמונות';

  @override
  String get allowJoiningAlbum => 'Allow joining album';

  @override
  String get allowAddPhotosDescription =>
      'בנוסף אפשר לאנשים עם הלינק להוסיף תמונות לאלבום המשותף.';

  @override
  String get passwordLock => 'נעילת סיסמא';

  @override
  String get canNotOpenTitle => 'Cannot open this album';

  @override
  String get canNotOpenBody => 'Sorry, this album cannot be opened in the app.';

  @override
  String get disableDownloadWarningTitle => 'שים לב';

  @override
  String get disableDownloadWarningBody =>
      'צופים יכולים עדיין לקחת צילומי מסך או לשמור עותק של התמונות שלך בעזרת כלים חיצוניים';

  @override
  String get allowDownloads => 'אפשר הורדות';

  @override
  String get linkDeviceLimit => 'מגבלת כמות מכשירים';

  @override
  String get noDeviceLimit => 'אין';

  @override
  String get albumLayout => 'Album layout';

  @override
  String get layoutGrouped => 'Grouped';

  @override
  String get layoutContinuous => 'Continuous';

  @override
  String get layoutTrip => 'Trip';

  @override
  String get preview => 'Preview';

  @override
  String get linkExpiry => 'תאריך תפוגה ללינק';

  @override
  String get linkExpired => 'פג תוקף';

  @override
  String get linkEnabled => 'מאופשר';

  @override
  String get linkNeverExpires => 'לעולם לא';

  @override
  String get expiredLinkInfo =>
      'פג תוקף הקישור. אנא בחר בתאריך תפוגה חדש או השבת את תאריך התפוגה של הקישור.';

  @override
  String get setAPassword => 'הגדר סיסמה';

  @override
  String get lockButtonLabel => 'נעל';

  @override
  String get enterPassword => 'הזן את הסיסמה';

  @override
  String get removeLink => 'הסרת קישור';

  @override
  String get manageLink => 'ניהול קישור';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'תוקף הקישור יפוג ב-$expiryTime';
  }

  @override
  String get albumUpdated => 'האלבום עודכן';

  @override
  String get never => 'לעולם לא';

  @override
  String get custom => 'מותאם אישית';

  @override
  String get after1Hour => 'אחרי שעה 1';

  @override
  String get after1Day => 'אחרי יום 1';

  @override
  String get after1Week => 'אחרי שבוע 1';

  @override
  String get after1Month => 'אחרי חודש 1';

  @override
  String get after1Year => 'אחרי שנה 1';

  @override
  String get manageParticipants => 'נהל';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count משתתפים',
      two: '2 משתתפים',
      one: '1 משתתף',
      zero: 'אין משתתפים',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'צור קישור על מנת לאפשר לאנשים להוסיף ולצפות בתמונות באלבום ששיתפת בלי צורך באפליקציית ente או חשבון. נהדר לאיסוף תמונות של אירועים.';

  @override
  String get collectPhotos => 'אסוף תמונות';

  @override
  String get collaborativeLink => 'קישור לשיתוף פעולה';

  @override
  String get shareWithNonenteUsers => 'שתף עם משתמשים שהם לא של ente';

  @override
  String get createPublicLink => 'צור קישור ציבורי';

  @override
  String get sendLink => 'שלח קישור';

  @override
  String get qrCode => 'QR Code';

  @override
  String get sendQrCode => 'Send QR code';

  @override
  String get copyLink => 'העתק קישור';

  @override
  String get copyEmbedHtml => 'Copy embed HTML';

  @override
  String get linkHasExpired => 'הקישור פג תוקף';

  @override
  String get publicLinkEnabled => 'לינק ציבורי אופשר';

  @override
  String get shareALink => 'שתף קישור';

  @override
  String get sharedAlbumSectionDescription =>
      'צור אלבומים הניתנים לשיתוף ושיתוף פעולה עם משתמשי ente אחרים, כולל משתמשים בתוכניות החינמיות.';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: 'שותף עם $numberOfPeople אנשים',
      two: 'שותף עם 2 אנשים',
      one: 'שותף עם איש 1',
      zero: 'שתף עם אנשים ספציפיים',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId => 'זה מזהה האימות שלך';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'מי שמשתף איתך אלבומים יוכל לראות את אותו המזהה במכשיר שלהם.';

  @override
  String get howToViewShareeVerificationID =>
      'אנא בקש מהם ללחוץ לחיצה ארוכה על הכתובת אימייל שלהם בעמוד ההגדרות, וודא שהמזההים בשני המכשירים תואמים.';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'זה מזהה האימות של $email';
  }

  @override
  String get verificationId => 'מזהה אימות';

  @override
  String verifyEmailID({required Object email}) {
    return 'אמת $email';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return 'לא נמצא חשבון ente ל-$email.\n\nשלח להם הזמנה על מנת לשתף תמונות.';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return 'הנה מזהה האימות שלי: $verificationID עבור ente.io.';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'היי, תוכל לוודא שזה מזהה האימות שלך של ente.io: $verificationID';
  }

  @override
  String get somethingWentWrong => 'משהו השתבש';

  @override
  String get sendInvite => 'שלח הזמנה';

  @override
  String get shareTextRecommendUsingEnte =>
      'הורד את ente על מנת שנוכל לשתף תמונות וסרטונים באיכות המקור באופן קל\n\nhttps://ente.io';

  @override
  String get done => 'בוצע';

  @override
  String get applyCodeTitle => 'החל קוד';

  @override
  String get enterCodeDescription =>
      'הכנס את הקוד שנמסר לך מחברך בשביל לקבל מקום אחסון בחינם עבורך ועבורו';

  @override
  String get apply => 'החל';

  @override
  String get failedToApplyCode => 'נכשל בהחלת הקוד';

  @override
  String get enterReferralCode => 'הזן קוד הפניה';

  @override
  String get codeAppliedPageTitle => 'הקוד הוחל';

  @override
  String get changeYourReferralCode => 'Change your referral code';

  @override
  String get change => 'Change';

  @override
  String get unavailableReferralCode => 'Sorry, this code is unavailable.';

  @override
  String get codeChangeLimitReached =>
      'Sorry, you\'ve reached the limit of code changes.';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'Please contact $familyAdminEmail to change your code.';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB';
  }

  @override
  String get claimed => 'נתבע';

  @override
  String get details => 'פרטים';

  @override
  String get claimMore => 'תבע עוד!';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return 'הם גם יקבלו $storageAmountInGB GB';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB כל פעם שמישהו נרשם עבור תוכנית בתשלום ומחיל את הקוד שלך';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'Ente referral code: $referralCode \n\nApply it in Settings → General → Referrals to get $referralStorageInGB GB free after you signup for a paid plan\n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => 'תבע מקום אחסון בחינם';

  @override
  String get inviteYourFriends => 'הזמן את חברייך';

  @override
  String get failedToFetchReferralDetails =>
      'אחזור פרטי ההפניה נכשל. אנא נסה שוב מאוחר יותר.';

  @override
  String get referralStep1 => '1. תמסור את הקוד הזה לחברייך';

  @override
  String get referralStep2 => '2. הם נרשמים עבור תוכנית בתשלום';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. שניכים מקבלים $storageInGB GB* בחינם';
  }

  @override
  String get referralsAreCurrentlyPaused => 'הפניות כרגע מושהות';

  @override
  String get youCanAtMaxDoubleYourStorage =>
      '* אתה יכול במקסימום להכפיל את מקום האחסון שלך';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true': 'קיבלת $storageAmountInGb GB עד כה',
      'false': 'קיבלת $storageAmountInGb GB עד כה',
      'other': 'קיבלת $storageAmountInGb GB עד כה!',
    });
    return '$_temp0';
  }

  @override
  String get faq => 'שאלות נפוצות';

  @override
  String get help => 'Help';

  @override
  String get oopsSomethingWentWrong => 'אופס, משהו השתבש';

  @override
  String get peopleUsingYourCode => 'אנשים משתמשים בקוד שלך';

  @override
  String get eligible => 'זכאי';

  @override
  String get total => 'סך הכל';

  @override
  String get codeUsedByYou => 'הקוד שומש על ידיך';

  @override
  String get freeStorageClaimed => 'מקום אחסון בחינם נתבע';

  @override
  String get freeStorageUsable => 'מקום אחסון שמיש';

  @override
  String get usableReferralStorageInfo =>
      'כמות האחסון השמישה שלך מוגבלת בתוכנית הנוכחית. אחסון עודף יהפוך שוב לשמיש אחרי שתשדרג את התוכנית שלך.';

  @override
  String get removeFromAlbumTitle => 'הסר מהאלבום?';

  @override
  String get removeFromAlbum => 'הסר מהאלבום';

  @override
  String get itemsWillBeRemovedFromAlbum => 'הפריטים שנבחרו יוסרו מהאלבום הזה';

  @override
  String get removeShareItemsWarning =>
      'Selected photos will not be accessible to any viewer of this album, except the photo owners.';

  @override
  String get addingToFavorites => 'מוסיף למועדפים...';

  @override
  String get removingFromFavorites => 'מסיר מהמועדפים...';

  @override
  String get sorryCouldNotAddToFavorites => 'סליחה, לא ניתן להוסיף למועדפים!';

  @override
  String get sorryCouldNotRemoveFromFavorites =>
      'סליחה, לא ניתן להסיר מהמועדפים!';

  @override
  String get subscribeToEnableSharing =>
      'You need an active paid subscription to enable sharing.';

  @override
  String get subscribeToChangeLinkSetting =>
      'You need a paid subscription to change this link setting.';

  @override
  String get subscribe => 'הרשם';

  @override
  String get canOnlyRemoveFilesOwnedByYou => 'יכול להסיר רק קבצים שבבעלותך';

  @override
  String get deleteSharedAlbum => 'מחק את האלבום המשותף?';

  @override
  String get deleteAlbum => 'מחק אלבום';

  @override
  String get deleteAlbumDialog =>
      'גם להסיר תמונות (וסרטונים) שנמצאים באלבום הזה מ<bold>כל</bold> שאר האלבומים שהם שייכים אליהם?';

  @override
  String get deleteSharedAlbumDialogBody =>
      'האלבום הזה יימחק עבור כולם\n\nאתה תאבד גישה לתמונות משותפות באלבום הזה שבבעלות של אחרים';

  @override
  String get yesRemove => 'כן, הסר';

  @override
  String get creatingLink => 'יוצר קישור...';

  @override
  String get removeWithQuestionMark => 'הסר?';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return '$userEmail יוסר מהאלבום המשותף הזה\n\nגם תמונות שנוספו על ידיהם יוסרו מהאלבום';
  }

  @override
  String get keepPhotos => 'השאר תמונות';

  @override
  String get deletePhotos => 'מחק תמונות';

  @override
  String get inviteToEnte => 'Invite to Ente';

  @override
  String get removePublicLink => 'הסר לינק ציבורי';

  @override
  String disableLinkMessage({required Object albumName}) {
    return 'זה יסיר את הלינק הפומבי שדרכו ניתן לגשת ל\"$albumName\".';
  }

  @override
  String get sharing => 'משתף...';

  @override
  String get youCannotShareWithYourself => 'אתה לא יכול לשתף עם עצמך';

  @override
  String get archive => 'שמירה בארכיון';

  @override
  String get createAlbumActionHint =>
      'לחץ לחיצה ארוכה על מנת לבחור תמונות ולחץ על + על מנת ליצור אלבום';

  @override
  String get importing => 'מייבא....';

  @override
  String get failedToLoadAlbums => 'נכשל בטעינת האלבומים';

  @override
  String get hidden => 'מוסתר';

  @override
  String get authToViewYourHiddenFiles =>
      'אנא התאמת על מנת לראות את הקבצים החבויים שלך';

  @override
  String get authToViewTrashedFiles =>
      'Please authenticate to view your trashed files';

  @override
  String get trash => 'אשפה';

  @override
  String get uncategorized => 'ללא קטגוריה';

  @override
  String get videoSmallCase => 'וידאו';

  @override
  String get photoSmallCase => 'תמונה';

  @override
  String get singleFileDeleteHighlight => 'זה יימחק מכל האלבומים.';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return 'This $fileType is in both Ente and your device.';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return 'This $fileType will be deleted from Ente.';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return '$fileType יימחק מהמכשיר שלך.';
  }

  @override
  String get deleteFromEnte => 'Delete from Ente';

  @override
  String get yesDelete => 'כן, מחק';

  @override
  String get movedToTrash => 'הועבר לאשפה';

  @override
  String get deleteFromDevice => 'מחק מהמכשיר';

  @override
  String get deleteFromBoth => 'מחק משניהם';

  @override
  String get newAlbum => 'אלבום חדש';

  @override
  String get albums => 'אלבומים';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount memories',
      one: '$formattedCount memory',
      zero: 'no memories',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return '$count נבחרו';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return '$count נבחרו ($yourCount שלך)';
  }

  @override
  String get advancedSettings => 'מתקדם';

  @override
  String get photoGridSize => 'גודל לוח של התמונה';

  @override
  String get manageDeviceStorage => 'Manage device cache';

  @override
  String get manageDeviceStorageDesc => 'Review and clear local cache storage.';

  @override
  String get machineLearning => 'Machine learning';

  @override
  String get mlConsent => 'Enable machine learning';

  @override
  String get mlConsentTitle => 'Enable machine learning?';

  @override
  String get mlConsentDescription =>
      'If you enable machine learning, Ente will extract information like face geometry from files, including those shared with you.\n\nThis will happen on your device, and any generated biometric information will be end-to-end encrypted.';

  @override
  String get mlConsentPrivacy =>
      'Please click here for more details about this feature in our privacy policy';

  @override
  String get mlConsentConfirmation =>
      'I understand, and wish to enable machine learning';

  @override
  String get magicSearch => 'Magic search';

  @override
  String get discover => 'Discover';

  @override
  String get discover_identity => 'Identity';

  @override
  String get discover_screenshots => 'Screenshots';

  @override
  String get discover_receipts => 'Receipts';

  @override
  String get discover_notes => 'Notes';

  @override
  String get discover_memes => 'Memes';

  @override
  String get discover_visiting_cards => 'Visiting Cards';

  @override
  String get discover_babies => 'Babies';

  @override
  String get discover_pets => 'Pets';

  @override
  String get discover_selfies => 'Selfies';

  @override
  String get discover_wallpapers => 'Wallpapers';

  @override
  String get discover_food => 'Food';

  @override
  String get discover_celebrations => 'Celebrations';

  @override
  String get discover_sunset => 'Sunset';

  @override
  String get discover_hills => 'Hills';

  @override
  String get discover_greenery => 'Greenery';

  @override
  String get mlIndexingDescription =>
      'Please note that machine learning will result in a higher bandwidth and battery usage until all items are indexed. Consider using the desktop app for faster indexing, all results will be synced automatically.';

  @override
  String get loadingModel => 'Downloading models...';

  @override
  String get waitingForWifi => 'Waiting for WiFi...';

  @override
  String get status => 'Status';

  @override
  String get indexedItems => 'Indexed items';

  @override
  String get pendingItems => 'Pending items';

  @override
  String get clearIndexes => 'Clear indexes';

  @override
  String get selectFoldersForBackup => 'בחר תיקיות לגיבוי';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      'התיקיות שנבחרו יוצפנו ויגובו';

  @override
  String get unselectAll => 'בטל בחירה של הכל';

  @override
  String get selectAll => 'בחר הכל';

  @override
  String get skip => 'דלג';

  @override
  String get updatingFolderSelection => 'מעדכן את בחירת התיקיות...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count פריטים',
      many: '$count פריטים',
      two: '$count פריטים',
      one: '$count פריט',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'מחק $count פריטים',
      two: 'מחק $count פריטים',
      one: 'מחק $count פריט',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count קבצים, כל אחד $formattedSize';
  }

  @override
  String get showMemories => 'הצג זכרונות';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'לפני $count שנים',
      many: 'לפני $count שנים',
      two: 'לפני $count שנים',
      one: 'לפני $count שנה',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'הגדרות גיבוי';

  @override
  String get backupStatus => 'Backup status';

  @override
  String get backupStatusDescription =>
      'Items that have been backed up will show up here';

  @override
  String get backupOverMobileData => 'גבה על רשת סלולרית';

  @override
  String get backupVideos => 'גבה סרטונים';

  @override
  String get disableAutoLock => 'השבת נעילה אוטומטית';

  @override
  String get deviceLockExplanation =>
      'Disable the device screen lock when Ente is in the foreground and there is a backup in progress. This is normally not needed, but may help big uploads and initial imports of large libraries complete faster.';

  @override
  String get about => 'אודות';

  @override
  String get weAreOpenSource => 'הקוד שלנו פתוח!';

  @override
  String get privacy => 'פרטיות';

  @override
  String get terms => 'תנאים';

  @override
  String get checkForUpdates => 'בדוק עדכונים';

  @override
  String get checkStatus => 'Check status';

  @override
  String get checking => 'בודק...';

  @override
  String get youAreOnTheLatestVersion => 'אתה על הגרסא הכי עדכנית';

  @override
  String get account => 'חשבון';

  @override
  String get manageSubscription => 'נהל מנוי';

  @override
  String get authToChangeYourEmail =>
      'אנא אנא התאמת על מנת לשנות את הדוא\"ל שלך';

  @override
  String get changePassword => 'שנה סיסמה';

  @override
  String get authToChangeYourPassword => 'אנא התאמת על מנת לשנות את הסיסמא שלך';

  @override
  String get emailVerificationToggle => 'אימות מייל';

  @override
  String get authToChangeEmailVerificationSetting =>
      'אנא התאמת על מנת לשנות את הדוא\"ל שלך';

  @override
  String get exportYourData => 'ייצוא הנתונים שלך';

  @override
  String get logout => 'התנתק';

  @override
  String get authToInitiateAccountDeletion =>
      'אנא התאמת על מנת להתחיל את מחיקת החשבון שלך';

  @override
  String get areYouSureYouWantToLogout => 'אתה בטוח שאתה רוצה להתנתק?';

  @override
  String get yesLogout => 'כן, התנתק';

  @override
  String get aNewVersionOfEnteIsAvailable =>
      'A new version of Ente is available.';

  @override
  String get update => 'עדכן';

  @override
  String get installManually => 'התקן באופן ידני';

  @override
  String get criticalUpdateAvailable => 'עדכון חשוב זמין';

  @override
  String get updateAvailable => 'עדכון זמין';

  @override
  String get ignoreUpdate => 'התעלם';

  @override
  String get downloading => 'מוריד...';

  @override
  String get cannotDeleteSharedFiles => 'לא ניתן למחוק את הקבצים המשותפים';

  @override
  String get theDownloadCouldNotBeCompleted => 'לא ניתן להשלים את ההורדה';

  @override
  String get retry => 'נסה שוב';

  @override
  String get backedUpFolders => 'תיקיות שגובו';

  @override
  String get backup => 'גיבוי';

  @override
  String get freeUpDeviceSpace => 'פנה אחסון במכשיר';

  @override
  String get freeUpDeviceSpaceDesc =>
      'Save space on your device by clearing files that have been already backed up.';

  @override
  String get allClear => '✨ הכל נוקה';

  @override
  String get noDeviceThatCanBeDeleted =>
      'אין לך קבצים במכשיר הזה שניתן למחוק אותם';

  @override
  String get removeDuplicates => 'הסר כפילויות';

  @override
  String get removeDuplicatesDesc =>
      'Review and remove files that are exact duplicates.';

  @override
  String get viewLargeFiles => 'Large files';

  @override
  String get viewLargeFilesDesc =>
      'View files that are consuming the most amount of storage.';

  @override
  String get noDuplicates => '✨ אין כפילויות';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared =>
      'You don\'t have any duplicate files that can be cleared';

  @override
  String get success => 'הצלחה';

  @override
  String get rateUs => 'דרג אותנו';

  @override
  String get remindToEmptyDeviceTrash =>
      'גם נקה \"נמחק לאחרונה\" מ-\"הגדרות\" -> \"אחסון\" על מנת לקבל המקום אחסון שהתפנה';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return 'הצלחת לפנות $storageSaved!';
  }

  @override
  String get remindToEmptyEnteTrash =>
      'גם נקה את ה-\"אשפה\" שלך על מנת לקבל את המקום אחסון שהתפנה';

  @override
  String get sparkleSuccess => '✨ הצלחה';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count duplicate files',
      one: '$count duplicate file',
    );
    return 'You have cleaned up $_temp0, saving ($storageSaved!)';
  }

  @override
  String get familyPlans => 'תוכניות משפחה';

  @override
  String get referrals => 'הפניות';

  @override
  String get notifications => 'התראות';

  @override
  String get sharedPhotoNotifications => 'אלבומים משותפים חדשים';

  @override
  String get sharedPhotoNotificationsExplanation =>
      'קבל התראות כשמישהו מוסיף תמונה לאלבום משותף שאתה חלק ממנו';

  @override
  String get advanced => 'מתקדם';

  @override
  String get general => 'כללי';

  @override
  String get security => 'אבטחה';

  @override
  String get authToViewYourRecoveryKey =>
      'אנא התאמת על מנת לראות את מפתח השחזור שלך';

  @override
  String get twofactor => 'דו-גורמי';

  @override
  String get authToConfigureTwofactorAuthentication =>
      'אנא התאמת כדי להגדיר את האימות הדו-גורמי';

  @override
  String get lockscreen => 'מסך נעילה';

  @override
  String get authToChangeLockscreenSetting =>
      'אנא התאמת כדי לשנות את הגדרות מסך הנעילה';

  @override
  String get viewActiveSessions => 'צפה בחיבורים פעילים';

  @override
  String get authToViewYourActiveSessions =>
      'אנא התאמת על מנת לראות את החיבורים הפעילים שלך';

  @override
  String get disableTwofactor => 'השבת דו-גורמי';

  @override
  String get confirm2FADisable =>
      'האם אתה בטוח שאתה רוצה להשבית את האימות הדו-גורמי?';

  @override
  String get no => 'לא';

  @override
  String get yes => 'כן';

  @override
  String get social => 'חברתי';

  @override
  String rateUsOnStore({required Object storeName}) {
    return 'דרג אותנו ב-$storeName';
  }

  @override
  String get blog => 'בלוג';

  @override
  String get merchandise => 'סחורה';

  @override
  String get twitter => 'Twitter';

  @override
  String get mastodon => 'Mastodon';

  @override
  String get matrix => 'Matrix';

  @override
  String get discord => 'Discord';

  @override
  String get reddit => 'Reddit';

  @override
  String get yourStorageDetailsCouldNotBeFetched =>
      'לא ניתן לאחזר את פרטי מקום האחסון';

  @override
  String get reportABug => 'דווח על באג';

  @override
  String get reportBug => 'דווח על באג';

  @override
  String get suggestFeatures => 'הציעו מאפיינים';

  @override
  String get support => 'תמיכה';

  @override
  String get theme => 'ערכת נושא';

  @override
  String get lightTheme => 'בהיר';

  @override
  String get darkTheme => 'כהה';

  @override
  String get systemTheme => 'מערכת';

  @override
  String get freeTrial => 'ניסיון חינמי';

  @override
  String get selectYourPlan => 'בחר תוכנית';

  @override
  String get enteSubscriptionPitch =>
      'Ente preserves your memories, so they\'re always available to you, even if you lose your device.';

  @override
  String get enteSubscriptionShareWithFamily =>
      'אפשר להוסיף גם את המשפחה שלך לתוכנית.';

  @override
  String get currentUsageIs => 'השימוש במקום האחסון כרגע הוא ';

  @override
  String get faqs => 'שאלות נפוצות';

  @override
  String renewsOn({required Object endDate}) {
    return 'Subscription renews on $endDate';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return 'ניסיון חינם בתוקף עד ל-$endDate';
  }

  @override
  String validTill({required Object endDate}) {
    return 'Valid till $endDate';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return 'Your $storageAmount add-on is valid till $endDate';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return 'Free trial valid till $endDate.\nYou can choose a paid plan afterwards.';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'המנוי שלך יבוטל ב-$endDate';
  }

  @override
  String get subscription => 'מנוי';

  @override
  String get paymentDetails => 'פרטי תשלום';

  @override
  String get manageFamily => 'נהל משפחה';

  @override
  String contactToManageSubscription({required Object provider}) {
    return 'אנא צור איתנו קשר ב-support@ente.io על מנת לנהל את המנוי $provider.';
  }

  @override
  String get renewSubscription => 'חדש מנוי';

  @override
  String get cancelSubscription => 'בטל מנוי';

  @override
  String get areYouSureYouWantToRenew => 'אתה בטוח שאתה רוצה לחדש?';

  @override
  String get yesRenew => 'כן, חדש';

  @override
  String get areYouSureYouWantToCancel => 'אתה בטוח שאתה רוצה לבטל?';

  @override
  String get yesCancel => 'כן, בטל';

  @override
  String get failedToRenew => 'החידוש נכשל';

  @override
  String get failedToCancel => 'הביטול נכשל';

  @override
  String get twoMonthsFreeOnYearlyPlans => 'חודשיים בחינם בתוכניות שנתיות';

  @override
  String get monthly => 'חודשי';

  @override
  String get yearly => 'שנתי';

  @override
  String get confirmPlanChange => 'אשר שינוי תוכנית';

  @override
  String get areYouSureYouWantToChangeYourPlan =>
      'אתה בטוח שאתה רוצה לשנות את התוכנית שלך?';

  @override
  String get youCannotDowngradeToThisPlan => 'אתה לא יכול לשנמך לתוכנית הזו';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'אנא בטל את המנוי הקיים מ-$paymentProvider קודם';
  }

  @override
  String get optionalAsShortAsYouLike => 'אופציונלי, קצר ככל שתרצה...';

  @override
  String get send => 'שלח';

  @override
  String get askCancelReason => 'המנוי שלך בוטל. תרצה לשתף את הסיבה?';

  @override
  String get thankYouForSubscribing => 'תודה שנרשמת!';

  @override
  String get yourPurchaseWasSuccessful => 'התשלום שלך עבר בהצלחה';

  @override
  String get yourPlanWasSuccessfullyUpgraded => 'התוכנית שלך שודרגה בהצלחה';

  @override
  String get yourPlanWasSuccessfullyDowngraded => 'התוכנית שלך שונמכה בהצלחה';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully => 'המנוי שלך עודכן בהצלחה';

  @override
  String get googlePlayId => 'Google Play ID';

  @override
  String get appleId => 'Apple ID';

  @override
  String get playstoreSubscription => 'מנוי PlayStore';

  @override
  String get appstoreSubscription => 'מנוי AppStore';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return 'Your $id is already linked to another Ente account.\nIf you would like to use your $id with this account, please contact our support\'\'';
  }

  @override
  String get visitWebToManage =>
      'אנא בקר ב-web.ente.io על מנת לנהל את המנוי שלך';

  @override
  String get couldNotUpdateSubscription => 'לא ניתן לעדכן את המנוי';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      'אנא צור קשר עם support@ente.io ואנחנו נשמח לעזור!';

  @override
  String get paymentFailed => 'התשלום נכשל';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return 'אנא דבר עם התמיכה של $providerName אם אתה חוייבת';
  }

  @override
  String get continueOnFreeTrial => 'המשך עם ניסיון חינמי';

  @override
  String get areYouSureYouWantToExit => 'האם אתה בטוח שברצונך לצאת?';

  @override
  String get thankYou => 'תודה';

  @override
  String get failedToVerifyPaymentStatus => 'נכשל באימות סטטוס התשלום';

  @override
  String get pleaseWaitForSometimeBeforeRetrying =>
      'אנא חכה מעט לפני שאתה מנסה שוב';

  @override
  String get paymentFailedMessage =>
      'Unfortunately your payment failed. Please contact support and we\'ll help you out!';

  @override
  String get youAreOnAFamilyPlan => 'אתה על תוכנית משפחתית!';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'אנא צור קשר עם <green>$familyAdminEmail</green> על מנת לנהל את המנוי שלך';
  }

  @override
  String get leaveFamily => 'עזוב משפחה';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily =>
      'אתה בטוח שאתה רוצה לעזוב את התוכנית המשפתחית?';

  @override
  String get leave => 'עזוב';

  @override
  String get rateTheApp => 'דרג את האפליקציה';

  @override
  String get startBackup => 'התחל גיבוי';

  @override
  String get noPhotosAreBeingBackedUpRightNow =>
      'אף תמונה אינה נמצאת בתהליך גיבוי כרגע';

  @override
  String get preserveMore => 'שמור עוד';

  @override
  String get grantFullAccessPrompt =>
      'נא לתת גישה לכל התמונות בתוך ההגדרות של הטלפון';

  @override
  String get allowPermTitle => 'Allow access to photos';

  @override
  String get allowPermBody =>
      'Please allow access to your photos from Settings so Ente can display and backup your library.';

  @override
  String get openSettings => 'פתח הגדרות';

  @override
  String get selectMorePhotos => 'בחר תמונות נוספות';

  @override
  String get existingUser => 'משתמש קיים';

  @override
  String get privateBackups => 'גיבויים פרטיים';

  @override
  String get forYourMemories => 'עבור הזכורונות שלך';

  @override
  String get endtoendEncryptedByDefault => 'מוצפן מקצה אל קצה כברירת מחדל';

  @override
  String get safelyStored => 'נשמר באופן בטוח';

  @override
  String get atAFalloutShelter => 'במקלט גרעיני';

  @override
  String get designedToOutlive => 'עוצב על מנת לשרוד';

  @override
  String get available => 'זמין';

  @override
  String get everywhere => 'בכל מקום';

  @override
  String get androidIosWebDesktop => 'Android, iOS, דפדפן, שולחן עבודה';

  @override
  String get mobileWebDesktop => 'פלאפון, דפדפן, שולחן עבודה';

  @override
  String get newToEnte => 'New to Ente';

  @override
  String get pleaseLoginAgain => 'אנא התחבר שוב';

  @override
  String get autoLogoutMessage =>
      'Due to technical glitch, you have been logged out. Our apologies for the inconvenience.';

  @override
  String get yourSubscriptionHasExpired => 'פג תוקף המנוי שלך';

  @override
  String get storageLimitExceeded => 'גבול מקום האחסון נחרג';

  @override
  String get upgrade => 'שדרג';

  @override
  String get raiseTicket => 'צור ticket';

  @override
  String get backupFailed => 'הגיבוי נכשל';

  @override
  String get sorryBackupFailedDesc =>
      'Sorry, we could not backup this file right now, we will retry later.';

  @override
  String get couldNotBackUpTryLater =>
      'לא יכולנו לגבות את המידע שלך.\nאנא נסה שוב מאוחר יותר.';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      'Ente can encrypt and preserve files only if you grant access to them';

  @override
  String get pleaseGrantPermissions => 'נא הענק את ההרשאות';

  @override
  String get grantPermission => 'הענק הרשאה';

  @override
  String get privateSharing => 'שיתוף פרטי';

  @override
  String get shareOnlyWithThePeopleYouWant => 'שתף רק אם אנשים שאתה בוחר';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      'Use public links for people not on Ente';

  @override
  String get allowPeopleToAddPhotos => 'תן לאנשים להוסיף תמונות';

  @override
  String get shareAnAlbumNow => 'שתף אלבום עכשיו';

  @override
  String get collectEventPhotos => 'אסף תמונות מאירוע';

  @override
  String get sessionExpired => 'פג תוקף החיבור';

  @override
  String get loggingOut => 'מתנתק...';

  @override
  String get onDevice => 'על המכשיר';

  @override
  String get onEnte => 'ב<branding>אנטע</branding>';

  @override
  String get name => 'שם';

  @override
  String get newest => 'החדש ביותר';

  @override
  String get lastUpdated => 'עדכון אחרון';

  @override
  String get deleteEmptyAlbums => 'למחוק אלבומים ריקים';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => 'למחוק אלבומים ריקים?';

  @override
  String get deleteAlbumsDialogBody =>
      'זה ימחק את כל האלבומים הריקים. זה שימושי כשאתה רוצה להפחית את כמות האי סדר ברשימת האלבומים שלך.';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return 'מוחק $currentlyDeleting / $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return 'Processing $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => 'למחוק לצמיתות?';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou =>
      'ניתן אך ורק ליצור קישור לקבצים שאתה בבעולתם';

  @override
  String get publicLinkCreated => 'קישור ציבורי נוצר';

  @override
  String get youCanManageYourLinksInTheShareTab =>
      'אתה יכול לנהת את הקישורים שלך בלשונית שיתוף.';

  @override
  String get linkCopiedToClipboard => 'הקישור הועתק ללוח';

  @override
  String get restore => 'שחזר';

  @override
  String get moveToAlbum => 'הזז לאלבום';

  @override
  String get unhide => 'בטל הסתרה';

  @override
  String get unarchive => 'הוצאה מארכיון';

  @override
  String get favorite => 'מועדף';

  @override
  String get removeFromFavorite => 'Remove from favorites';

  @override
  String get shareLink => 'שתף קישור';

  @override
  String get createCollage => 'צור קולז';

  @override
  String get saveCollage => 'שמור קולז';

  @override
  String get collageSaved => 'הקולז נשמר לגלריה';

  @override
  String get collageLayout => 'פריסה';

  @override
  String get addToEnte => 'Add to Ente';

  @override
  String get addToAlbum => 'הוסף לאלבום';

  @override
  String get delete => 'מחק';

  @override
  String get hide => 'הסתר';

  @override
  String get share => 'שתף';

  @override
  String get unhideToAlbum => 'בטל הסתרה בחזרה לאלבום';

  @override
  String get restoreToAlbum => 'שחזר לאלבום';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Move items',
      one: 'Move item',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add items',
      one: 'Add item',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'צור או בחר אלבום';

  @override
  String get selectAlbum => 'בחר אלבום';

  @override
  String get searchByAlbumNameHint => 'שם האלבום';

  @override
  String get albumTitle => 'כותרת האלבום';

  @override
  String get enterAlbumName => 'הזן שם אלבום';

  @override
  String get restoringFiles => 'משחזר קבצים...';

  @override
  String get movingFilesToAlbum => 'מעביר קבצים לאלבום...';

  @override
  String get unhidingFilesToAlbum => 'מבטל הסתרת הקבצים לאלבום';

  @override
  String get canNotUploadToAlbumsOwnedByOthers =>
      'לא ניתן להעלות לאלבומים שבבעלות אחרים';

  @override
  String get uploadingFilesToAlbum => 'מעלה קבצים לאלבום...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return 'Added successfully to  $albumName';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return 'Moved successfully to $albumName';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'This album already has a collaborative link';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return 'Collaborative link created for $albumName';
  }

  @override
  String get askYourLovedOnesToShare => 'Ask your loved ones to share';

  @override
  String get invite => 'הזמן';

  @override
  String get shareYourFirstAlbum => 'שתף את האלבום הראשון שלך';

  @override
  String sharedWith({required Object emailIDs}) {
    return 'הושתף ע\"י $emailIDs';
  }

  @override
  String get sharedWithMe => 'שותף איתי';

  @override
  String get sharedByMe => 'שותף על ידי';

  @override
  String get doubleYourStorage => 'Double your storage';

  @override
  String get referFriendsAnd2xYourPlan => 'Refer friends and 2x your plan';

  @override
  String get shareAlbumHint =>
      'Open an album and tap the share button on the top right to share.';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      'Items show the number of days remaining before permanent deletion';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count days',
      one: '1 day',
      zero: 'Soon',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => 'מחק הכל';

  @override
  String get renameAlbum => 'Rename album';

  @override
  String get convertToAlbum => 'Convert to album';

  @override
  String get setCover => 'הגדר כרקע';

  @override
  String get sortAlbumsBy => 'מיין לפי';

  @override
  String get sortNewestFirst => 'Newest first';

  @override
  String get sortOldestFirst => 'הישן ביותר קודם';

  @override
  String get rename => 'שנה שם';

  @override
  String get leaveSharedAlbum => 'לעזוב את האלבום המשותף?';

  @override
  String get leaveAlbum => 'צא מהאלבום';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'Photos added by you will be removed from the album';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted =>
      'You\'ve no files in this album that can be deleted';

  @override
  String get youDontHaveAnyArchivedItems =>
      'You don\'t have any archived items.';

  @override
  String get ignoredFolderUploadReason =>
      'Some files in this album are ignored from upload because they had previously been deleted from Ente.';

  @override
  String get resetIgnoredFiles => 'Reset ignored files';

  @override
  String get deviceFilesAutoUploading =>
      'Files added to this device album will automatically get uploaded to Ente.';

  @override
  String get turnOnBackupForAutoUpload =>
      'Turn on backup to automatically upload files added to this device folder to Ente.';

  @override
  String get noHiddenPhotosOrVideos => 'No hidden photos or videos';

  @override
  String get toHideAPhotoOrVideo => 'To hide a photo or video';

  @override
  String get openTheItem => '• Open the item';

  @override
  String get clickOnTheOverflowMenu => '• Click on the overflow menu';

  @override
  String get click => '• לחץ';

  @override
  String get nothingToSeeHere => 'Nothing to see here! 👀';

  @override
  String get unarchiveAlbum => 'Unarchive album';

  @override
  String get archiveAlbum => 'Archive album';

  @override
  String get calculating => 'Calculating...';

  @override
  String get pleaseWaitDeletingAlbum => 'Please wait, deleting album';

  @override
  String get searchByExamples =>
      '• Album names (e.g. \"Camera\")\n• Types of files (e.g. \"Videos\", \".gif\")\n• Years and months (e.g. \"2022\", \"January\")\n• Holidays (e.g. \"Christmas\")\n• Photo descriptions (e.g. “#fun”)';

  @override
  String get youCanTrySearchingForADifferentQuery =>
      'You can try searching for a different query.';

  @override
  String get noResultsFound => 'No results found';

  @override
  String addedBy({required Object emailOrName}) {
    return 'Added by $emailOrName';
  }

  @override
  String get loadingExifData => 'Loading EXIF data...';

  @override
  String get viewAllExifData => 'View all EXIF data';

  @override
  String get noExifData => 'No EXIF data';

  @override
  String get thisImageHasNoExifData => 'This image has no exif data';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => 'אין תוצאות';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'We don\'t support editing photos and albums that you don\'t own yet';

  @override
  String get failedToFetchOriginalForEdit =>
      'Failed to fetch original for edit';

  @override
  String get close => 'סגור';

  @override
  String get setAs => 'הגדר בתור';

  @override
  String get fileSavedToGallery => 'הקובץ נשמר לגלריה';

  @override
  String get filesSavedToGallery => 'Files saved to gallery';

  @override
  String get fileFailedToSaveToGallery => 'נכשל בעת שמירת הקובץ לגלריה';

  @override
  String get download => 'הורד';

  @override
  String get pressAndHoldToPlayVideo => 'לחץ והחזק על מנת להריץ את הסרטון';

  @override
  String get pressAndHoldToPlayVideoDetailed =>
      'לחץ והחזק על התמונה על מנת להריץ את הסרטון';

  @override
  String get downloadFailed => 'ההורדה נכשלה';

  @override
  String get deduplicateFiles => 'הסר קבצים כפולים';

  @override
  String get deselectAll => 'בטל בחירה של הכל';

  @override
  String get reviewDeduplicateItems =>
      'אנא בחן והסר את הפריטים שאתה מאמין שהם כפלים.';

  @override
  String get clubByCaptureTime => 'קבץ לפי זמן הצילום';

  @override
  String get clubByFileName => 'קבץ לפי שם הקובץ';

  @override
  String get count => 'כמות';

  @override
  String get totalSize => 'גודל כולל';

  @override
  String get longpressOnAnItemToViewInFullscreen =>
      'לחץ לחיצה ארוכה על פריט על מנת לראות אותו במסך מלא';

  @override
  String get decryptingVideo => 'מפענח את הסרטון...';

  @override
  String get authToViewYourMemories => 'אנא אמת על מנת לצפות בזכרונות שלך';

  @override
  String get unlock => 'ביטול נעילה';

  @override
  String get freeUpSpace => 'פנה מקום';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'They can be deleted from the device to free up $formattedSize',
      one: 'It can be deleted from the device to free up $formattedSize',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber files',
      one: '1 file',
    );
    return '$_temp0 in this album has been backed up safely';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber files',
      one: '1 file',
    );
    return '$_temp0 on this device have been backed up safely';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'them',
      one: 'it',
    );
    return 'You can still access $_temp0 on Ente as long as you have an active subscription';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return 'Free up $sizeInMBorGB';
  }

  @override
  String get thisEmailIsAlreadyInUse => 'This email is already in use';

  @override
  String get incorrectCode => 'Incorrect code';

  @override
  String get authenticationFailedPleaseTryAgain =>
      'Authentication failed, please try again';

  @override
  String get verificationFailedPleaseTryAgain =>
      'Verification failed, please try again';

  @override
  String get authenticating => 'Authenticating...';

  @override
  String get authenticationSuccessful => 'Authentication successful!';

  @override
  String get incorrectRecoveryKey => 'Incorrect recovery key';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect =>
      'The recovery key you entered is incorrect';

  @override
  String get twofactorAuthenticationSuccessfullyReset =>
      'Two-factor authentication successfully reset';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered =>
      'Please verify the code you have entered';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      'Please contact support if the problem persists';

  @override
  String get twofactorAuthenticationHasBeenDisabled =>
      'Two-factor authentication has been disabled';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect =>
      'Sorry, the code you\'ve entered is incorrect';

  @override
  String get yourVerificationCodeHasExpired =>
      'Your verification code has expired';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'Email changed to $newEmail';
  }

  @override
  String get verifying => 'Verifying...';

  @override
  String get disablingTwofactorAuthentication =>
      'Disabling two-factor authentication...';

  @override
  String get allMemoriesPreserved => 'כל הזכרונות נשמרו';

  @override
  String get loadingGallery => 'Loading gallery...';

  @override
  String get syncing => 'מסנכרן...';

  @override
  String get encryptingBackup => 'Encrypting backup...';

  @override
  String get syncStopped => 'Sync stopped';

  @override
  String syncProgress({required String completed, required String total}) {
    return '$completed/$total זכרונות נשמרו';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return 'Preserving $count memories...';
  }

  @override
  String get uploadingSingleMemory => 'Preserving 1 memory...';

  @override
  String get archiving => 'Archiving...';

  @override
  String get unarchiving => 'Unarchiving...';

  @override
  String get successfullyArchived => 'Successfully archived';

  @override
  String get successfullyUnarchived => 'Successfully unarchived';

  @override
  String get renameFile => 'שנה שם הקובץ';

  @override
  String get enterFileName => 'Enter file name';

  @override
  String get filesDeleted => 'Files deleted';

  @override
  String get selectedFilesAreNotOnEnte => 'Selected files are not on Ente';

  @override
  String get thisActionCannotBeUndone => 'This action cannot be undone';

  @override
  String get emptyTrash => 'Empty trash?';

  @override
  String get permDeleteWarning =>
      'All items in trash will be permanently deleted\n\nThis action cannot be undone';

  @override
  String get empty => 'ריק';

  @override
  String get couldNotFreeUpSpace => 'Could not free up space';

  @override
  String get permanentlyDeleteFromDevice => 'Permanently delete from device?';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      'Some of the files you are trying to delete are only available on your device and cannot be recovered if deleted';

  @override
  String get theyWillBeDeletedFromAllAlbums =>
      'They will be deleted from all albums.';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'Some items are in both Ente and your device.';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      'Selected items will be deleted from all albums and moved to trash.';

  @override
  String get theseItemsWillBeDeletedFromYourDevice =>
      'These items will be deleted from your device.';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      'It looks like something went wrong. Please retry after some time. If the error persists, please contact our support team.';

  @override
  String get error => 'שגיאה';

  @override
  String get tempErrorContactSupportIfPersists =>
      'It looks like something went wrong. Please retry after some time. If the error persists, please contact our support team.';

  @override
  String get networkHostLookUpErr =>
      'Unable to connect to Ente, please check your network settings and contact support if the error persists.';

  @override
  String get networkConnectionRefusedErr =>
      'Unable to connect to Ente, please retry after sometime. If the error persists, please contact support.';

  @override
  String get cachedData => 'נתונים מוטמנים';

  @override
  String get clearCaches => 'Clear caches';

  @override
  String get remoteImages => 'Remote images';

  @override
  String get remoteVideos => 'Remote videos';

  @override
  String get remoteThumbnails => 'Remote thumbnails';

  @override
  String get pendingSync => 'Pending sync';

  @override
  String get localGallery => 'Local gallery';

  @override
  String get todaysLogs => 'Today\'s logs';

  @override
  String get viewLogs => 'צפייה בלוגים';

  @override
  String get logsDialogBody =>
      'This will send across logs to help us debug your issue. Please note that file names will be included to help track issues with specific files.';

  @override
  String get preparingLogs => 'מכין לוגים...';

  @override
  String get emailYourLogs => 'Email your logs';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'Please send the logs to \n$toEmail';
  }

  @override
  String get copyEmailAddress => 'Copy email address';

  @override
  String get exportLogs => 'ייצוא לוגים';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return 'Please email us at $toEmail';
  }

  @override
  String get dismiss => 'התעלם';

  @override
  String get didYouKnow => 'Did you know?';

  @override
  String get loadingMessage => 'Loading your photos...';

  @override
  String get loadMessage1 => 'You can share your subscription with your family';

  @override
  String get loadMessage2 =>
      'We have preserved over 200 million memories so far';

  @override
  String get loadMessage3 =>
      'We keep 3 copies of your data, one in an underground fallout shelter';

  @override
  String get loadMessage4 => 'All our apps are open source';

  @override
  String get loadMessage5 =>
      'Our source code and cryptography have been externally audited';

  @override
  String get loadMessage6 =>
      'You can share links to your albums with your loved ones';

  @override
  String get loadMessage7 =>
      'Our mobile apps run in the background to encrypt and backup any new photos you click';

  @override
  String get loadMessage8 => 'web.ente.io has a slick uploader';

  @override
  String get loadMessage9 =>
      'We use Xchacha20Poly1305 to safely encrypt your data';

  @override
  String get photoDescriptions => 'Photo descriptions';

  @override
  String get fileTypesAndNames => 'File types and names';

  @override
  String get location => 'מקום';

  @override
  String get moments => 'Moments';

  @override
  String get searchFaceEmptySection =>
      'People will be shown here once indexing is done';

  @override
  String get searchDatesEmptySection => 'Search by a date, month or year';

  @override
  String get searchLocationEmptySection =>
      'Group photos that are taken within some radius of a photo';

  @override
  String get searchPeopleEmptySection =>
      'Invite people, and you\'ll see all photos shared by them here';

  @override
  String get searchAlbumsEmptySection => 'Albums';

  @override
  String get searchFileTypesAndNamesEmptySection => 'File types and names';

  @override
  String get searchCaptionEmptySection =>
      'Add descriptions like \"#trip\" in photo info to quickly find them here';

  @override
  String get language => 'שפה';

  @override
  String get selectLanguage => 'Select Language';

  @override
  String get locationName => 'Location name';

  @override
  String get addLocation => 'Add location';

  @override
  String get groupNearbyPhotos => 'Group nearby photos';

  @override
  String get kiloMeterUnit => 'ק\"מ';

  @override
  String get addLocationButton => 'הוסף';

  @override
  String get radius => 'רדיוס';

  @override
  String get locationTagFeatureDescription =>
      'A location tag groups all photos that were taken within some radius of a photo';

  @override
  String get galleryMemoryLimitInfo => 'Up to 1000 memories shown in gallery';

  @override
  String get save => 'שמור';

  @override
  String get centerPoint => 'Center point';

  @override
  String get pickCenterPoint => 'Pick center point';

  @override
  String get useSelectedPhoto => 'Use selected photo';

  @override
  String get resetToDefault => 'Reset to default';

  @override
  String get edit => 'ערוך';

  @override
  String get deleteLocation => 'Delete location';

  @override
  String get rotateLeft => 'סובב שמאלה';

  @override
  String get flip => 'הפוך';

  @override
  String get rotateRight => 'Rotate right';

  @override
  String get saveCopy => 'שמירת עותק';

  @override
  String get light => 'אור';

  @override
  String get color => 'צבע';

  @override
  String get yesDiscardChanges => 'Yes, discard changes';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade =>
      'Do you want to discard the edits you have made?';

  @override
  String get saving => 'שומר...';

  @override
  String get editsSaved => 'Edits saved';

  @override
  String get oopsCouldNotSaveEdits => 'Oops, could not save edits';

  @override
  String get distanceInKMUnit => 'ק\"מ';

  @override
  String get dayToday => 'היום';

  @override
  String get dayYesterday => 'אתמול';

  @override
  String get storage => 'אחסון';

  @override
  String get usedSpace => 'מקום בשימוש';

  @override
  String get storageBreakupFamily => 'משפחה';

  @override
  String get storageBreakupYou => 'אתה';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return '$usedAmount $usedStorageUnit of $totalAmount $totalStorageUnit used';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return '$freeAmount $storageUnit free';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'Version: $versionValue';
  }

  @override
  String get verifyIDLabel => 'אמת';

  @override
  String get fileInfoAddDescHint => 'Add a description...';

  @override
  String get editLocationTagTitle => 'Edit location';

  @override
  String get setLabel => 'הגדר';

  @override
  String get setRadius => 'הגדר רדיוס';

  @override
  String get familyPlanPortalTitle => 'משפחה';

  @override
  String get familyPlanOverview =>
      'Add 5 family members to your existing plan without paying extra.\n\nEach member gets their own private space, and cannot see each other\'s files unless they\'re shared.\n\nFamily plans are available to customers who have a paid Ente subscription.\n\nSubscribe now to get started!';

  @override
  String get androidBiometricHint => 'Verify identity';

  @override
  String get androidBiometricNotRecognized => 'Not recognized. Try again.';

  @override
  String get androidBiometricSuccess => 'הצלחה';

  @override
  String get androidCancelButton => 'בטל';

  @override
  String get androidSignInTitle => 'Authentication required';

  @override
  String get androidBiometricRequiredTitle => 'Biometric required';

  @override
  String get androidDeviceCredentialsRequiredTitle =>
      'Device credentials required';

  @override
  String get androidDeviceCredentialsSetupDescription =>
      'Device credentials required';

  @override
  String get goToSettings => 'Go to settings';

  @override
  String get androidGoToSettingsDescription =>
      'Biometric authentication is not set up on your device. Go to \'Settings > Security\' to add biometric authentication.';

  @override
  String get iOSLockOut =>
      'Biometric authentication is disabled. Please lock and unlock your screen to enable it.';

  @override
  String get iOSGoToSettingsDescription =>
      'Biometric authentication is not set up on your device. Please either enable Touch ID or Face ID on your phone.';

  @override
  String get iOSOkButton => 'אישור';

  @override
  String get openstreetmapContributors => 'OpenStreetMap contributors';

  @override
  String get hostedAtOsmFrance => 'Hosted at OSM France';

  @override
  String get map => 'מפה';

  @override
  String get maps => 'מפות';

  @override
  String get mapsPrivacyNotice =>
      'Approximate coordinates will be sent to privacy conscious third parties like OpenStreetMap to show the map and location.';

  @override
  String get enableMaps => 'Enable Maps';

  @override
  String get quickLinks => 'Quick links';

  @override
  String get selectItemsToAdd => 'Select items to add';

  @override
  String get addSelected => 'Add selected';

  @override
  String get addFromDevice => 'Add from device';

  @override
  String get addPhotos => 'הוסף תמונות';

  @override
  String get noPhotosFoundHere => 'No photos found here';

  @override
  String get zoomOutToSeePhotos => 'Zoom out to see photos';

  @override
  String get noImagesWithLocation => 'No images with location';

  @override
  String get unpinAlbum => 'Unpin album';

  @override
  String get pinAlbum => 'Pin album';

  @override
  String get pin => 'Pin';

  @override
  String get pinPerson => 'Pin person';

  @override
  String get pinToTop => 'Pin to top';

  @override
  String get unpin => 'Unpin';

  @override
  String get unpinPerson => 'Unpin person';

  @override
  String get visibility => 'Visibility';

  @override
  String get hideFromMemories => 'Hide from memories';

  @override
  String get showInMemories => 'Show in memories';

  @override
  String get create => 'צור';

  @override
  String get viewAll => 'הצג הכל';

  @override
  String get nothingSharedWithYouYet => 'Nothing shared with you yet';

  @override
  String get noAlbumsSharedByYouYet => 'No albums shared by you yet';

  @override
  String get sharedWithYou => 'Shared with you';

  @override
  String get sharedByYou => 'Shared by you';

  @override
  String get inviteYourFriendsToEnte => 'Invite your friends to Ente';

  @override
  String get failedToDownloadVideo => 'Failed to download video';

  @override
  String get hiding => 'מחביא...';

  @override
  String get unhiding => 'Unhiding...';

  @override
  String get successfullyHid => 'Successfully hid';

  @override
  String get successfullyUnhid => 'Successfully unhid';

  @override
  String get crashReporting => 'Crash reporting';

  @override
  String get resumableUploads => 'Resumable uploads';

  @override
  String get addToHiddenAlbum => 'Add to hidden album';

  @override
  String get moveToHiddenAlbum => 'Move to hidden album';

  @override
  String get fileTypes => 'File types';

  @override
  String get deleteConfirmDialogBody =>
      'This account is linked to other Ente apps, if you use any. Your uploaded data, across all Ente apps, will be scheduled for deletion, and your account will be permanently deleted.';

  @override
  String get hearUsWhereTitle => 'How did you hear about Ente? (optional)';

  @override
  String get hearUsExplanation =>
      'We don\'t track app installs. It\'d help if you told us where you found us!';

  @override
  String get viewAddOnButton => 'View add-ons';

  @override
  String get addOns => 'Add-ons';

  @override
  String get addOnPageSubtitle => 'Details of add-ons';

  @override
  String get yourMap => 'Your map';

  @override
  String get modifyYourQueryOrTrySearchingFor =>
      'Modify your query, or try searching for';

  @override
  String get blackFridaySale => 'Black Friday Sale';

  @override
  String get upto50OffUntil4thDec => 'Upto 50% off, until 4th Dec.';

  @override
  String get photos => 'Photos';

  @override
  String get videos => 'Videos';

  @override
  String get livePhotos => 'Live Photos';

  @override
  String get searchHint1 => 'Fast, on-device search';

  @override
  String get searchHint2 => 'Photo dates, descriptions';

  @override
  String get searchHint3 => 'Albums, file names, and types';

  @override
  String get searchHint4 => 'Location';

  @override
  String get searchHint5 => 'Coming soon: Faces & magic search ✨';

  @override
  String get addYourPhotosNow => 'Add your photos now';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count results found',
      one: '$count result found',
    );
    return '$_temp0';
  }

  @override
  String get faces => 'Faces';

  @override
  String get people => 'People';

  @override
  String get contents => 'Contents';

  @override
  String get addNew => 'Add new';

  @override
  String get contacts => 'Contacts';

  @override
  String get noInternetConnection => 'No internet connection';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'Please check your internet connection and try again.';

  @override
  String get signOutFromOtherDevices => 'Sign out from other devices';

  @override
  String get signOutOtherBody =>
      'If you think someone might know your password, you can force all other devices using your account to sign out.';

  @override
  String get signOutOtherDevices => 'Sign out other devices';

  @override
  String get doNotSignOut => 'Do not sign out';

  @override
  String get editLocation => 'Edit location';

  @override
  String get selectALocation => 'Select a location';

  @override
  String get selectALocationFirst => 'Select a location first';

  @override
  String get changeLocationOfSelectedItems =>
      'Change location of selected items?';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte =>
      'Edits to location will only be seen within Ente';

  @override
  String get cleanUncategorized => 'Clean Uncategorized';

  @override
  String get cleanUncategorizedDescription =>
      'Remove all files from Uncategorized that are present in other albums';

  @override
  String get waitingForVerification => 'Waiting for verification...';

  @override
  String get passkey => 'Passkey';

  @override
  String get passkeyAuthTitle => 'Passkey verification';

  @override
  String get loginWithTOTP => 'Login with TOTP';

  @override
  String get passKeyPendingVerification => 'Verification is still pending';

  @override
  String get loginSessionExpired => 'Session expired';

  @override
  String get loginSessionExpiredDetails =>
      'Your session has expired. Please login again.';

  @override
  String get verifyPasskey => 'Verify passkey';

  @override
  String get playOnTv => 'Play album on TV';

  @override
  String get pair => 'Pair';

  @override
  String get deviceNotFound => 'Device not found';

  @override
  String get castInstruction =>
      'Visit cast.ente.io on the device you want to pair.\n\nEnter the code below to play the album on your TV.';

  @override
  String get deviceCodeHint => 'Enter the code';

  @override
  String get joinDiscord => 'Join Discord';

  @override
  String get locations => 'Locations';

  @override
  String get addAName => 'Add a name';

  @override
  String get findThemQuickly => 'Find them quickly';

  @override
  String get findPeopleByName => 'Find people quickly by name';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add viewers',
      one: 'Add viewer',
      zero: 'Add viewer',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add collaborators',
      one: 'Add collaborator',
      zero: 'Add collaborator',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      'Long press an email to verify end to end encryption.';

  @override
  String get developerSettingsWarning =>
      'Are you sure that you want to modify Developer settings?';

  @override
  String get developerSettings => 'Developer settings';

  @override
  String get serverEndpoint => 'Server endpoint';

  @override
  String get invalidEndpoint => 'Invalid endpoint';

  @override
  String get invalidEndpointMessage =>
      'Sorry, the endpoint you entered is invalid. Please enter a valid endpoint and try again.';

  @override
  String get endpointUpdatedMessage => 'Endpoint updated successfully';

  @override
  String customEndpoint({required Object endpoint}) {
    return 'Connected to $endpoint';
  }

  @override
  String get createCollaborativeLink => 'Create collaborative link';

  @override
  String get search => 'Search';

  @override
  String get enterPersonName => 'Enter person name';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'This email is already linked to $name.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return 'View $name to unlink';
  }

  @override
  String get enterName => 'Enter name';

  @override
  String get savePerson => 'Save person';

  @override
  String get editPerson => 'Edit person';

  @override
  String get mergedPhotos => 'Merged photos';

  @override
  String get orMergeWithExistingPerson => 'Or merge with existing';

  @override
  String get enterDateOfBirth => 'Birthday (optional)';

  @override
  String get birthday => 'Birthday';

  @override
  String get removePersonLabel => 'Remove person label';

  @override
  String get removePersonTag => 'Remove person tag';

  @override
  String get areYouSureRemoveThisPersonTag =>
      'Are you sure you want to remove this person tag?';

  @override
  String get autoPairDesc =>
      'Auto pair works only with devices that support Chromecast.';

  @override
  String get manualPairDesc =>
      'Pair with PIN works with any screen you wish to view your album on.';

  @override
  String get connectToDevice => 'Connect to device';

  @override
  String get autoCastDialogBody => 'You\'ll see available Cast devices here.';

  @override
  String get autoCastiOSPermission =>
      'Make sure Local Network permissions are turned on for the Ente Photos app, in Settings.';

  @override
  String get noDeviceFound => 'No device found';

  @override
  String get stopCastingTitle => 'Stop casting';

  @override
  String get stopCastingBody => 'Do you want to stop casting?';

  @override
  String get castIPMismatchTitle => 'Failed to cast album';

  @override
  String get castIPMismatchBody =>
      'Please make sure you are on the same network as the TV.';

  @override
  String get pairingComplete => 'Pairing complete';

  @override
  String get savingEdits => 'Saving edits...';

  @override
  String get autoPair => 'Auto pair';

  @override
  String get pairWithPin => 'Pair with PIN';

  @override
  String get faceRecognition => 'Face recognition';

  @override
  String get foundFaces => 'Found faces';

  @override
  String get clusteringProgress => 'Clustering progress';

  @override
  String get trim => 'Trim';

  @override
  String get crop => 'Crop';

  @override
  String get rotate => 'Rotate';

  @override
  String get left => 'Left';

  @override
  String get right => 'Right';

  @override
  String get whatsNew => 'What\'s new';

  @override
  String get reviewSuggestions => 'Review suggestions';

  @override
  String get review => 'Review';

  @override
  String get useAsCover => 'Use as cover';

  @override
  String notPersonLabel({required String name}) {
    return 'Not $name?';
  }

  @override
  String get enable => 'Enable';

  @override
  String get enabled => 'Enabled';

  @override
  String get moreDetails => 'More details';

  @override
  String get enableMLIndexingDesc =>
      'Ente supports on-device machine learning for face recognition, magic search and other advanced search features';

  @override
  String get magicSearchHint =>
      'Magic search allows to search photos by their contents, e.g. \'flower\', \'red car\', \'identity documents\'';

  @override
  String get panorama => 'Panorama';

  @override
  String get reenterPassword => 'Re-enter password';

  @override
  String get reenterPin => 'Re-enter PIN';

  @override
  String get deviceLock => 'Device lock';

  @override
  String get pinLock => 'PIN lock';

  @override
  String get next => 'Next';

  @override
  String get setNewPassword => 'Set new password';

  @override
  String get enterPin => 'Enter PIN';

  @override
  String get setNewPin => 'Set new PIN';

  @override
  String get appLock => 'App lock';

  @override
  String get noSystemLockFound => 'No system lock found';

  @override
  String get tapToUnlock => 'Tap to unlock';

  @override
  String get tooManyIncorrectAttempts => 'Too many incorrect attempts';

  @override
  String get videoInfo => 'Video Info';

  @override
  String get autoLock => 'Auto lock';

  @override
  String get immediately => 'Immediately';

  @override
  String get autoLockFeatureDescription =>
      'Time after which the app locks after being put in the background';

  @override
  String get hideContent => 'Hide content';

  @override
  String get hideContentDescriptionAndroid =>
      'Hides app content in the app switcher and disables screenshots';

  @override
  String get hideContentDescriptionIos =>
      'Hides app content in the app switcher';

  @override
  String get passwordStrengthInfo =>
      'Password strength is calculated considering the length of the password, used characters, and whether or not the password appears in the top 10,000 most used passwords';

  @override
  String get noQuickLinksSelected => 'No quick links selected';

  @override
  String get pleaseSelectQuickLinksToRemove =>
      'Please select quick links to remove';

  @override
  String get removePublicLinks => 'Remove public links';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      'This will remove public links of all selected quick links.';

  @override
  String get guestView => 'Guest view';

  @override
  String get guestViewEnablePreSteps =>
      'To enable guest view, please setup device passcode or screen lock in your system settings.';

  @override
  String get nameTheAlbum => 'Name the album';

  @override
  String get collectPhotosDescription =>
      'Create a link where your friends can upload photos in original quality.';

  @override
  String get collect => 'Collect';

  @override
  String get appLockDescriptions =>
      'Choose between your device\'s default lock screen and a custom lock screen with a PIN or password.';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'To enable app lock, please setup device passcode or screen lock in your system settings.';

  @override
  String get authToViewPasskey => 'Please authenticate to view your passkey';

  @override
  String get loopVideoOn => 'Disable looping';

  @override
  String get loopVideoOff => 'Enable looping';

  @override
  String get localSyncErrorMessage =>
      'Looks like something went wrong since local photos sync is taking more time than expected. Please reach out to our support team';

  @override
  String get showPerson => 'Show person';

  @override
  String get sort => 'Sort';

  @override
  String get mostRecent => 'Most recent';

  @override
  String get mostRelevant => 'Most relevant';

  @override
  String get loadingYourPhotos => 'Loading your photos...';

  @override
  String processingImport({required Object folderName}) {
    return 'Processing $folderName...';
  }

  @override
  String get personName => 'Person name';

  @override
  String get addPerson => 'Add person';

  @override
  String get addToPerson => 'Add to person';

  @override
  String get pleaseNamePersonInPeopleSectionFirst =>
      'Please name a person in the People section first';

  @override
  String get onlyUploadedFilesCanBeAddedToPerson =>
      'Only uploaded files can be added to a person';

  @override
  String get noFacesDetectedTapToAdd => 'No faces detected, tap to add.';

  @override
  String addedFilesToPerson({required int count, required String personName}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count files to $personName',
      one: 'Added 1 file to $personName',
    );
    return '$_temp0';
  }

  @override
  String filesAlreadyLinkedToPerson({
    required int count,
    required String personName,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count files are already linked to $personName',
      one: '1 file is already linked to $personName',
    );
    return '$_temp0';
  }

  @override
  String get addNewPerson => 'Add new person';

  @override
  String get addNameOrMerge => 'Add name or merge';

  @override
  String get mergeWithExisting => 'Merge with existing';

  @override
  String get newPerson => 'New person';

  @override
  String get addName => 'Add name';

  @override
  String get add => 'Add';

  @override
  String extraPhotosFoundFor({required String text}) {
    return 'Extra photos found for $text';
  }

  @override
  String get extraPhotosFound => 'Extra photos found';

  @override
  String get configuration => 'Configuration';

  @override
  String get localIndexing => 'Local indexing';

  @override
  String get processed => 'Processed';

  @override
  String get resetPerson => 'Remove';

  @override
  String get areYouSureYouWantToResetThisPerson =>
      'Are you sure you want to reset this person?';

  @override
  String get allPersonGroupingWillReset =>
      'All groupings for this person will be reset, and you will lose all suggestions made for this person';

  @override
  String get yesResetPerson => 'Yes, reset person';

  @override
  String get onlyThem => 'Only them';

  @override
  String get checkingModels => 'Checking models...';

  @override
  String get enableMachineLearningBanner =>
      'Enable machine learning for magic search and face recognition';

  @override
  String get searchDiscoverEmptySection =>
      'Images will be shown here once processing and syncing is complete';

  @override
  String get searchPersonsEmptySection =>
      'People will be shown here once processing and syncing is complete';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count viewers',
      one: 'Added 1 viewer',
      zero: 'Added 0 viewers',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count collaborators',
      one: 'Added 1 collaborator',
      zero: 'Added 0 collaborator',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured => 'Account is already configured.';

  @override
  String get sessionIdMismatch => 'Session ID mismatch';

  @override
  String get failedToFetchActiveSessions => 'Failed to fetch active sessions';

  @override
  String get failedToRefreshStripeSubscription =>
      'Failed to refresh subscription';

  @override
  String get failedToPlayVideo => 'Failed to play video';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return 'Upload is ignored due to $ignoreReason';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'Type of gallery $galleryType is not supported for rename';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'Tap to upload, upload is currently ignored due to $ignoreReason';
  }

  @override
  String get tapToUpload => 'Tap to upload';

  @override
  String get info => 'Info';

  @override
  String get addFiles => 'Add Files';

  @override
  String get castAlbum => 'Cast album';

  @override
  String get imageNotAnalyzed => 'Image not analyzed';

  @override
  String get noFacesFound => 'No faces found';

  @override
  String get fileNotUploadedYet => 'File not uploaded yet';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return 'No suggestions for $personName';
  }

  @override
  String get month => 'month';

  @override
  String get yearShort => 'yr';

  @override
  String get currentlyRunning => 'currently running';

  @override
  String get ignored => 'ignored';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count photos',
      one: '1 photo',
      zero: '0 photos',
    );
    return '$_temp0';
  }

  @override
  String get file => 'File';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'Sections length mismatch: $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'Select mail app';

  @override
  String get selectAllShort => 'All';

  @override
  String get selectCoverPhoto => 'Select cover photo';

  @override
  String get newLocation => 'New location';

  @override
  String get faceNotClusteredYet =>
      'Face not clustered yet, please come back later';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'The link you are trying to access has expired.';

  @override
  String get openFile => 'Open file';

  @override
  String get backupFile => 'Backup file';

  @override
  String get openAlbumInBrowser => 'Open album in browser';

  @override
  String get openAlbumInBrowserTitle =>
      'Please use the web app to add photos to this album';

  @override
  String get allow => 'Allow';

  @override
  String get allowAppToOpenSharedAlbumLinks =>
      'Allow app to open shared album links';

  @override
  String get seePublicAlbumLinksInApp => 'See public album links in app';

  @override
  String get emergencyContacts => 'Emergency Contacts';

  @override
  String get acceptTrustInvite => 'Accept Invite';

  @override
  String get declineTrustInvite => 'Decline Invite';

  @override
  String get removeYourselfAsTrustedContact =>
      'Remove yourself as trusted contact';

  @override
  String get legacy => 'Legacy';

  @override
  String get legacyPageDesc =>
      'Legacy allows trusted contacts to access your account in your absence.';

  @override
  String get legacyPageDesc2 =>
      'Trusted contacts can initiate account recovery, and if not blocked within 30 days, reset your password and access your account.';

  @override
  String get legacyAccounts => 'Legacy accounts';

  @override
  String get trustedContacts => 'Trusted contacts';

  @override
  String get addTrustedContact => 'Add Trusted Contact';

  @override
  String get removeInvite => 'Remove invite';

  @override
  String get recoveryWarning =>
      'A trusted contact is trying to access your account';

  @override
  String get rejectRecovery => 'Reject recovery';

  @override
  String get recoveryInitiated => 'Recovery initiated';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return 'You can access the account after $days days. A notification will be sent to $email.';
  }

  @override
  String get cancelAccountRecovery => 'Cancel recovery';

  @override
  String get recoveryAccount => 'Recover account';

  @override
  String get cancelAccountRecoveryBody =>
      'Are you sure you want to cancel recovery?';

  @override
  String get startAccountRecoveryTitle => 'Start recovery';

  @override
  String get whyAddTrustContact =>
      'Trusted contact can help in recovering your data.';

  @override
  String recoveryReady({required String email}) {
    return 'You can now recover $email\'s account by setting a new password.';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email is trying to recover your account.';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return 'You have been invited to be a legacy contact by $email.';
  }

  @override
  String get warning => 'Warning';

  @override
  String get proceed => 'Proceed';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return 'You are about to add $email as a trusted contact. They will be able to recover your account if you are absent for $numOfDays days.';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email has invited you to be a trusted contact';
  }

  @override
  String get authToManageLegacy =>
      'Please authenticate to manage your trusted contacts';

  @override
  String get hideSharedItemsFromHomeGallery =>
      'Hide shared items from home gallery';

  @override
  String get swipeToSelect => 'Swipe to select';

  @override
  String get gallery => 'Gallery';

  @override
  String get joinAlbum => 'Join album';

  @override
  String get joinAlbumSubtext => 'to view and add your photos';

  @override
  String get joinAlbumSubtextViewer => 'to add this to shared albums';

  @override
  String get join => 'Join';

  @override
  String get linkEmail => 'Link email';

  @override
  String get link => 'Link';

  @override
  String get noEnteAccountExclamation => 'No Ente account!';

  @override
  String get orPickFromYourContacts => 'or pick from your contacts';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return '$email does not have an Ente account.';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (Me)';
  }

  @override
  String get reassignMe => 'Reassign \"Me\"';

  @override
  String get me => 'Me';

  @override
  String get linkEmailToContactBannerCaption => 'for faster sharing';

  @override
  String get selectPersonToLink => 'Select person to link';

  @override
  String linkPersonToEmail({required String email}) {
    return 'Link person to $email';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return 'This will link $personName to $email';
  }

  @override
  String get selectYourFace => 'Select your face';

  @override
  String get reassigningLoading => 'Reassigning...';

  @override
  String reassignedToName({required String name}) {
    return 'Reassigned you to $name';
  }

  @override
  String get saveChangesBeforeLeavingQuestion => 'Save changes before leaving?';

  @override
  String get dontSave => 'Don\'t save';

  @override
  String get thisIsMeExclamation => 'This is me!';

  @override
  String get linkPerson => 'Link person';

  @override
  String get linkPersonCaption => 'for better sharing experience';

  @override
  String get videoStreaming => 'Streamable videos';

  @override
  String get processingVideos => 'Processing videos';

  @override
  String get streamDetails => 'Stream details';

  @override
  String get processing => 'Processing';

  @override
  String get queued => 'Queued';

  @override
  String get ineligible => 'Ineligible';

  @override
  String get failed => 'Failed';

  @override
  String get playStream => 'Play stream';

  @override
  String get playOriginal => 'Play original';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'Joining an album will make your email visible to its participants.';

  @override
  String get pleaseWaitThisWillTakeAWhile =>
      'Please wait, this will take a while.';

  @override
  String get editTime => 'Edit time';

  @override
  String get selectTime => 'Select time';

  @override
  String get selectDate => 'Select date';

  @override
  String get previous => 'Previous';

  @override
  String get selectOneDateAndTimeForAll => 'Select one date and time for all';

  @override
  String get selectStartOfRange => 'Select start of range';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      'This will make the date and time of all selected photos the same.';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'This is the first in the group. Other selected photos will automatically shift based on this new date';

  @override
  String get newRange => 'New range';

  @override
  String get selectOneDateAndTime => 'Select one date and time';

  @override
  String get moveSelectedPhotosToOneDate => 'Move selected photos to one date';

  @override
  String get shiftDatesAndTime => 'Shift dates and time';

  @override
  String get photosKeepRelativeTimeDifference =>
      'Photos keep relative time difference';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count photos',
      one: '1 photo',
      zero: 'No photos',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'App icon';

  @override
  String get notThisPerson => 'Not this person?';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      'Selected items will be removed from this person, but not deleted from your library.';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat through the years';
  }

  @override
  String get thisWeekThroughTheYears => 'This week through the years';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'This week, $count years ago',
      one: 'This week, $count year ago',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'You and $name';
  }

  @override
  String admiringThem({required Object name}) {
    return 'Admiring $name';
  }

  @override
  String embracingThem({required Object name}) {
    return 'Embracing $name';
  }

  @override
  String partyWithThem({required Object name}) {
    return 'Party with $name';
  }

  @override
  String hikingWithThem({required Object name}) {
    return 'Hiking with $name';
  }

  @override
  String feastingWithThem({required Object name}) {
    return 'Feasting with $name';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return 'Selfies with $name';
  }

  @override
  String posingWithThem({required Object name}) {
    return 'Posing with $name';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return 'Beautiful views with $name';
  }

  @override
  String sportsWithThem({required Object name}) {
    return 'Sports with $name';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return 'Road trip with $name';
  }

  @override
  String get spotlightOnYourself => 'Spotlight on yourself';

  @override
  String spotlightOnThem({required Object name}) {
    return 'Spotlight on $name';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$name is $age!';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name turning $age soon';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return 'Last time with $name';
  }

  @override
  String tripToLocation({required Object location}) {
    return 'Trip to $location';
  }

  @override
  String tripInYear({required Object year}) {
    return 'Trip in $year';
  }

  @override
  String get lastYearsTrip => 'Last year\'s trip';

  @override
  String get sunrise => 'On the horizon';

  @override
  String get mountains => 'Over the hills';

  @override
  String get greenery => 'The green life';

  @override
  String get beach => 'Sand and sea';

  @override
  String get city => 'In the city';

  @override
  String get moon => 'In the moonlight';

  @override
  String get onTheRoad => 'On the road again';

  @override
  String get food => 'Culinary delight';

  @override
  String get pets => 'Furry companions';

  @override
  String get curatedMemories => 'Curated memories';

  @override
  String get widgets => 'Widgets';

  @override
  String get memories => 'Memories';

  @override
  String get peopleWidgetDesc =>
      'Select the people you wish to see on your homescreen.';

  @override
  String get albumsWidgetDesc =>
      'Select the albums you wish to see on your homescreen.';

  @override
  String get memoriesWidgetDesc =>
      'Select the kind of memories you wish to see on your homescreen.';

  @override
  String get smartMemories => 'Smart memories';

  @override
  String get pastYearsMemories => 'Past years\' memories';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return 'Also delete the photos (and videos) present in these $count albums from <bold>all</bold> other albums they are part of?';
  }

  @override
  String get addParticipants => 'Add participants';

  @override
  String selectedAlbums({required Object count}) {
    return '$count selected';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'Action not supported on Favourites album';

  @override
  String get onThisDayMemories => 'On this day memories';

  @override
  String get onThisDay => 'On this day';

  @override
  String get lookBackOnYourMemories => 'Look back on your memories 🌄';

  @override
  String get newPhotosEmoji => ' new 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'Sorry, we had to pause your backups';

  @override
  String get clickToInstallOurBestVersionYet =>
      'Click to install our best version yet';

  @override
  String get onThisDayNotificationExplanation =>
      'Receive reminders about memories from this day in previous years.';

  @override
  String get addMemoriesWidgetPrompt =>
      'Add a memories widget to your homescreen and come back here to customize.';

  @override
  String get addAlbumWidgetPrompt =>
      'Add an album widget to your homescreen and come back here to customize.';

  @override
  String get addPeopleWidgetPrompt =>
      'Add a people widget to your homescreen and come back here to customize.';

  @override
  String get birthdayNotifications => 'Birthday notifications';

  @override
  String get receiveRemindersOnBirthdays =>
      'Receive reminders when it\'s someone\'s birthday. Tapping on the notification will take you to photos of the birthday person.';

  @override
  String get happyBirthday => 'Happy birthday! 🥳';

  @override
  String get birthdays => 'Birthdays';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return 'Wish $name a happy birthday! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      'Are you sure you want to remove this face from this person?';

  @override
  String get otherDetectedFaces => 'Other detected faces';

  @override
  String get areThey => 'Are they ';

  @override
  String get questionmark => '?';

  @override
  String get saveAsAnotherPerson => 'Save as another person';

  @override
  String get showLessFaces => 'Show less faces';

  @override
  String get showMoreFaces => 'Show more faces';

  @override
  String get ignore => 'Ignore';

  @override
  String get merge => 'Merge';

  @override
  String get reset => 'Reset';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      'Are you sure you want to ignore this person?';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      'Are you sure you want to ignore these persons?';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'The person groups will not be displayed in the people section anymore. Photos will remain untouched.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'The person will not be displayed in the people section anymore. Photos will remain untouched.';

  @override
  String get areYouSureYouWantToMergeThem =>
      'Are you sure you want to merge them?';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'All unnamed groups will be merged into the selected person. This can still be undone from the suggestions history overview of the person.';

  @override
  String get yesIgnore => 'Yes, ignore';

  @override
  String get same => 'Same';

  @override
  String get different => 'Different';

  @override
  String get sameperson => 'Same person?';

  @override
  String get indexingPausedStatusDescription =>
      'Indexing is paused. It will automatically resume when the device is ready. The device is considered ready when its battery level, battery health, and thermal status are within a healthy range.';

  @override
  String get thisWeek => 'This week';

  @override
  String get lastWeek => 'Last week';

  @override
  String get thisMonth => 'This month';

  @override
  String get thisYear => 'This year';

  @override
  String get groupBy => 'Group by';

  @override
  String get faceThumbnailGenerationFailed =>
      'Unable to generate face thumbnails';

  @override
  String get fileAnalysisFailed => 'Unable to analyze file';

  @override
  String get editAutoAddPeople => 'Edit auto-add people';

  @override
  String get autoAddPeople => 'Auto-add people';

  @override
  String get autoAddToAlbum => 'Auto-add to album';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      'Should the files related to the person that were previously selected in smart albums be removed?';

  @override
  String get addingPhotos => 'Adding photos';

  @override
  String get gettingReady => 'Getting ready';

  @override
  String get addSomePhotosDesc1 => 'Add some photos or pick ';

  @override
  String get addSomePhotosDesc2 => 'familiar faces';

  @override
  String get addSomePhotosDesc3 => '\nto begin with';

  @override
  String get ignorePerson => 'Ignore person';

  @override
  String get mixedGrouping => 'Mixed grouping?';

  @override
  String get analysis => 'Analysis';

  @override
  String get doesGroupContainMultiplePeople =>
      'Does this grouping contain multiple people?';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'We will automatically analyze the grouping to determine if there are multiple people present, and separate them out again. This may take a few seconds.';

  @override
  String get layout => 'Layout';

  @override
  String get day => 'Day';

  @override
  String get undo => 'Undo';

  @override
  String get redo => 'Redo';

  @override
  String get filter => 'Filter';

  @override
  String get adjust => 'Adjust';

  @override
  String get draw => 'Draw';

  @override
  String get sticker => 'Sticker';

  @override
  String get brushColor => 'Brush Color';

  @override
  String get font => 'Font';

  @override
  String get background => 'Background';

  @override
  String get align => 'Align';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added successfully to $count albums',
      one: 'Added successfully to 1 album',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => 'Videos processed';

  @override
  String get totalVideos => 'Total videos';

  @override
  String get skippedVideos => 'Skipped videos';

  @override
  String get videoStreamingDescriptionLine1 =>
      'Play videos instantly on any device.';

  @override
  String get videoStreamingDescriptionLine2 =>
      'Enable to process video streams on this device.';

  @override
  String get videoStreamingNote =>
      'Only videos from last 60 days and under 1 minute are processed on this device. For older/longer videos, enable streaming in the desktop app.';

  @override
  String get createStream => 'Create stream';

  @override
  String get recreateStream => 'Recreate stream';

  @override
  String get addedToStreamCreationQueue => 'Added to stream creation queue';

  @override
  String get addedToStreamRecreationQueue => 'Added to stream recreation queue';

  @override
  String get videoPreviewAlreadyExists => 'Video preview already exists';

  @override
  String get videoAlreadyInQueue => 'Video file already present in the queue';

  @override
  String get videoExportFailed => 'Video creation failed. Please try again.';

  @override
  String videoExportSuccess({required String path}) {
    return 'Video successfully created at $path';
  }

  @override
  String get addedToQueue => 'Added to queue';

  @override
  String get creatingStream => 'Creating stream';

  @override
  String get similarImages => 'Similar images';

  @override
  String get findSimilarImages => 'Find similar images';

  @override
  String get noSimilarImagesFound => 'No similar images found';

  @override
  String get yourPhotosLookUnique => 'Your photos look unique';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count groups found',
      one: '$count group found',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages => 'Review and remove similar images';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return 'Delete $count photos ($size)';
  }

  @override
  String get selectionOptions => 'Selection options';

  @override
  String selectExactWithCount({required int count}) {
    return 'Exactly similar ($count)';
  }

  @override
  String get selectExact => 'Select exact';

  @override
  String selectSimilarWithCount({required int count}) {
    return 'Mostly similar ($count)';
  }

  @override
  String get selectSimilar => 'Select similar';

  @override
  String selectAllWithCount({required int count}) {
    return 'All similarities ($count)';
  }

  @override
  String get selectSimilarImagesTitle => 'Select similar images';

  @override
  String get chooseSimilarImagesToSelect =>
      'Select images based on their visual similarity';

  @override
  String get clearSelection => 'Clear selection';

  @override
  String similarImagesCount({required int count}) {
    return '$count similar images';
  }

  @override
  String deleteWithCount({required int count}) {
    return 'Delete ($count)';
  }

  @override
  String get deleteFiles => 'Delete files';

  @override
  String get areYouSureDeleteFiles =>
      'Are you sure you want to delete these files?';

  @override
  String get greatJob => 'Great job!';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return 'You freed up $size of space';
  }

  @override
  String get size => 'Size';

  @override
  String get similarity => 'Similarity';

  @override
  String get analyzingPhotosLocally => 'Analyzing your photos locally...';

  @override
  String get lookingForVisualSimilarities =>
      'Looking for visual similarities...';

  @override
  String get comparingImageDetails => 'Comparing image details...';

  @override
  String get findingSimilarImages => 'Finding similar images...';

  @override
  String get almostDone => 'Almost done...';

  @override
  String get processingLocally => 'Processing locally';

  @override
  String get useMLToFindSimilarImages =>
      'Review and remove images that look similar to each other.';

  @override
  String get all => 'All';

  @override
  String get similar => 'Similar';

  @override
  String get identical => 'Identical';

  @override
  String get nothingHereTryAnotherFilter =>
      'Nothing here, try another filter! 👀';

  @override
  String get related => 'Related';

  @override
  String get hoorayyyy => 'Hoorayyyy!';

  @override
  String get nothingToTidyUpHere => 'Nothing to tidy up here';

  @override
  String get deletingDash => 'Deleting - ';

  @override
  String get cLTitle1 => 'Introducing Rituals';

  @override
  String get cLDesc1 =>
      'Planning resolutions for 2026? With Rituals, you can set a reminder on Ente Photos and track your progress by taking photos. Use it for workouts, eating habits, daily moments with loved ones—anything you want to make a habit.';

  @override
  String get cLTitle2 => 'Public links, now for everyone';

  @override
  String get cLDesc2 =>
      'All Ente users on the free plan can now create and share public links to photos and albums. To prevent abuse, links will have limits on how many people can view them.';

  @override
  String get cLTitle3 => 'Manually tag people';

  @override
  String get cLDesc3 =>
      'You can now tag people even when our on-device AI doesn\'t detect a face. Handy for pets, partially visible faces, or moments where someone isn\'t actually in the photo but should still be included.';

  @override
  String get cLTitle4 => 'And more';

  @override
  String get cLDesc4 =>
      'You can now pin shared albums. Album links are visible to collaborators and viewers to make sharing even easier. We\'ve fixed some iOS swiping bugs and updated the photo view, including a new favorite icon (making room for upcoming features).';

  @override
  String get closeBy => 'Close';

  @override
  String get peopleAutoAddDesc =>
      'Automatically add photos of the selected people to this album';

  @override
  String get festivities => 'Festive cheer';

  @override
  String get snowAdventures => 'Winter adventures';

  @override
  String get waterfalls => 'Chasing waterfalls';

  @override
  String get wildlife => 'Into the wild';

  @override
  String get flowers => 'Blooming beauties';

  @override
  String get nightLights => 'Neon nights';

  @override
  String get architecture => 'Design icons';

  @override
  String get autumnColors => 'Autumn splendor';

  @override
  String get desertDreams => 'Desert dreams';

  @override
  String get stargazing => 'Under the stars';

  @override
  String get lakeside => 'Lakeside calm';

  @override
  String get rainyDays => 'Rainy day feels';

  @override
  String get sportsAction => 'Game on';

  @override
  String get streetArt => 'Street art stories';

  @override
  String get familyMoments => 'Family time';

  @override
  String get fireworks => 'Firework finale';

  @override
  String get historicSites => 'Echoes of history';

  @override
  String get tropicalParadise => 'Tropical escapes';

  @override
  String get forestTrails => 'Forest strolls';

  @override
  String get citySunsets => 'City sunset glow';

  @override
  String get colorfulMarkets => 'Vibrant markets';

  @override
  String get cozyCafes => 'Cozy cafe corners';

  @override
  String get vintageVibes => 'Vintage vibes';

  @override
  String get aerialViews => 'Aerial perspectives';

  @override
  String get artisticPortraits => 'Artful portraits';

  @override
  String get streetFood => 'Street food bites';

  @override
  String get riverCruises => 'River cruise views';

  @override
  String get facesTimelineBannerTitle => 'Memory Lane';

  @override
  String facesTimelineBannerSubtitle({required String name}) {
    return 'See $name\'s photos across the years';
  }

  @override
  String get facesTimelineAppBarTitle => 'Memory lane';

  @override
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count years old',
      one: '$count year old',
    );
    return '$name was $_temp0';
  }

  @override
  String facesTimelineCaptionYearsAgo({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '# years ago',
      one: '# year ago',
    );
    return '$_temp0';
  }

  @override
  String get facesTimelineShareComingSoon => 'Video sharing coming soon';

  @override
  String get facesTimelinePlaybackPrevious => 'Previous';

  @override
  String get facesTimelinePlaybackNext => 'Next';

  @override
  String get facesTimelinePlaybackPlay => 'Play';

  @override
  String get facesTimelinePlaybackPause => 'Pause';

  @override
  String get facesTimelineUnavailable => 'Faces timeline is preparing...';

  @override
  String get playfulKids => 'Playful kids';

  @override
  String get coastalCliffs => 'Cliffs by the sea';

  @override
  String get ritualsTitle => 'Rituals';

  @override
  String get ritualAddTooltip => 'Add ritual';

  @override
  String get ritualActivityHeading => 'Activity';

  @override
  String get ritualDefaultHeatmapTitle => 'Take a photo every day';

  @override
  String get ritualUntitled => 'Untitled ritual';

  @override
  String get ritualShareUnavailable =>
      'Unable to share right now. Please try again.';

  @override
  String get ritualNotificationMessage => 'Take a photo now';

  @override
  String get ritualCameraNotFound => 'No camera found on this device.';

  @override
  String get ritualCameraStartError =>
      'Unable to start camera. Please check permissions.';

  @override
  String get ritualCaptureError => 'Unable to capture photo. Please try again.';

  @override
  String ritualPhotoLimit({required int maxPhotos}) {
    String _temp0 = intl.Intl.pluralLogic(
      maxPhotos,
      locale: localeName,
      other: '# photos.',
      one: '# photo.',
    );
    return 'You can add up to $_temp0';
  }

  @override
  String get ritualCaptureAtLeastOne => 'Capture at least one photo first.';

  @override
  String get ritualAlbumMissing =>
      'Ritual album missing. Edit the ritual to set an album.';

  @override
  String get ritualAddedToAlbum => 'Added to album';

  @override
  String ritualAddedToAlbumWithName({required String albumName}) {
    return 'Added to $albumName';
  }

  @override
  String ritualAddToAlbumFailure({required String error}) {
    return 'Couldn\'t add photos to the album: $error';
  }

  @override
  String get ritualBackToList => 'Back to rituals';

  @override
  String get ritualNoPhotosYet => 'No photos yet';

  @override
  String get ritualSetAlbumToLaunchCamera =>
      'Set an album for this ritual to launch the camera.';

  @override
  String get ritualDefaultCameraTitle => 'Take a photo';

  @override
  String get ritualBadgeMessage7 =>
      '7 days down! Consistency looks good on you. Keep going!';

  @override
  String get ritualBadgeMessage14 =>
      '14 days in! Your ritual is becoming a habit. Incredible!';

  @override
  String get ritualBadgeMessage30 =>
      '30 days in a row! Legendary consistency. Take a bow!';

  @override
  String get ritualBadgeMessageDefault => 'You\'re on a roll!';

  @override
  String get ritualBadgeNewTitle => 'New achievement';

  @override
  String get ritualBadgePreparing => 'Preparing...';

  @override
  String get ritualStreaksLabel => 'Streaks';

  @override
  String get ritualCreateYourOwn => 'Create your own ritual';

  @override
  String get ritualGetDailyReminders => 'Get daily reminders';

  @override
  String get ritualAlbumNotSet => 'Album not set';

  @override
  String get ritualOpenCameraTooltip => 'Open ritual camera';

  @override
  String get ritualEditorLabel => 'Ritual editor';

  @override
  String get ritualNew => 'Create new ritual';

  @override
  String get ritualCreateNewTitle => 'Create new ritual';

  @override
  String get ritualEdit => 'Edit ritual';

  @override
  String get ritualEnterPrompt => 'Enter your ritual';

  @override
  String get ritualEnterDescription => 'Please enter a description';

  @override
  String get ritualChooseDaysLabel => 'Choose days for ritual';

  @override
  String get ritualDayLabel => 'Day';

  @override
  String get ritualNotificationsOffHint =>
      'Notifications are off. Tap a day to turn them on.';

  @override
  String get ritualTimeLabel => 'Time';

  @override
  String get ritualAlbumLabel => 'Album';

  @override
  String get ritualSave => 'Save ritual';

  @override
  String get ritualCreateAction => 'Create ritual';

  @override
  String get ritualUpdate => 'Update ritual';

  @override
  String get ritualSelectAlbumTitle => 'Select album';

  @override
  String get ritualChooseAlbumLabel => 'Choose an album';

  @override
  String get ritualSendReminderLabel => 'Send reminder';

  @override
  String get ritualSearchOrCreate => 'Search or create new';

  @override
  String get ritualNoAlbumsYet => 'No albums yet';

  @override
  String get ritualNoMatchingAlbums => 'No matching albums';

  @override
  String ritualCreateAlbumWithName({required String albumName}) {
    return 'Create \"$albumName\"';
  }

  @override
  String get ritualCreateNew => 'Create new';

  @override
  String get ritualAlbumSelectionPlaceholder => 'Select album';

  @override
  String get ritualPickEmojiTitle => 'Pick an emoji';

  @override
  String get ritualCustomKeyboardLabel => 'Custom (keyboard)';

  @override
  String get ritualEmojiKeyboardHint => 'Press to open emoji keyboard';

  @override
  String get ritualEmojiUseAction => 'Use';

  @override
  String get ritualSearchEmpty =>
      'Build a ritual to keep your photo habit going.';
}
