// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for French (`fr`).
class AppLocalizationsFr extends AppLocalizations {
  AppLocalizationsFr([String locale = 'fr']) : super(locale);

  @override
  String get enterYourEmailAddress => 'Entrez votre adresse e-mail';

  @override
  String get enterYourNewEmailAddress => 'Entrez votre nouvelle adresse e-mail';

  @override
  String get accountWelcomeBack => 'Bon retour parmi nous !';

  @override
  String get emailAlreadyRegistered => 'Email déjà enregistré.';

  @override
  String get emailNotRegistered => 'E-mail non enregistré.';

  @override
  String get email => 'E-mail';

  @override
  String get cancel => 'Annuler';

  @override
  String get verify => 'Vérifier';

  @override
  String get invalidEmailAddress => 'Adresse e-mail invalide';

  @override
  String get enterValidEmail => 'Veuillez entrer une adresse email valide.';

  @override
  String get deleteAccount => 'Supprimer mon compte';

  @override
  String get deleteAccountWarning =>
      'Ceci supprimera votre compte Ente Auth, Ente Photos et Ente Locker.';

  @override
  String get askDeleteReason =>
      'Quelle est la principale raison pour laquelle vous supprimez votre compte ?';

  @override
  String get deleteAccountFeedbackPrompt =>
      'Nous sommes désolés de vous voir partir. N\'hésitez pas à partager vos commentaires pour nous aider à nous améliorer.';

  @override
  String get feedback => 'Commentaires';

  @override
  String get kindlyHelpUsWithThisInformation =>
      'Merci de nous aider avec cette information';

  @override
  String get confirmDeletePrompt =>
      'Oui, je veux supprimer définitivement ce compte et ses données dans toutes les applications.';

  @override
  String get confirmAccountDeletion => 'Confirmer la suppression du compte';

  @override
  String get deleteAccountPermanentlyButton =>
      'Supprimer définitivement le compte';

  @override
  String get yourAccountHasBeenDeleted => 'Votre compte a été supprimé';

  @override
  String get selectReason => 'Sélectionnez une raison';

  @override
  String get deleteReason1 => 'Il manque une fonction clé dont j\'ai besoin';

  @override
  String get deleteReason2 =>
      'L\'application ou une certaine fonctionnalité ne se comporte pas comme je pense qu\'elle devrait';

  @override
  String get deleteReason3 => 'J\'ai trouvé un autre service que je préfère';

  @override
  String get deleteReason4 => 'Ma raison n\'est pas listée';

  @override
  String get sendEmail => 'Envoyer un e-mail';

  @override
  String get deleteRequestSLAText =>
      'Votre demande sera traitée sous 72 heures.';

  @override
  String get deleteEmailRequest =>
      'Veuillez envoyer un e-mail à <warning>account-deletion@ente.io</warning> à partir de votre adresse e-mail enregistrée.';

  @override
  String get entePhotosPerm =>
      'Ente <i>a besoin d\'une autorisation pour</i> sauvegarder vos photos';

  @override
  String get ok => 'Ok';

  @override
  String get createAccount => 'Créer un compte';

  @override
  String get createNewAccount => 'Créer un nouveau compte';

  @override
  String get password => 'Mot de passe';

  @override
  String get confirmPassword => 'Confirmer le mot de passe';

  @override
  String get activeSessions => 'Sessions actives';

  @override
  String get ocrProcessingOverlayMessage => 'Détection du texte...';

  @override
  String get ocrLoadingIndicatorLabel => 'Détection du texte';

  @override
  String get ocrSelectionHint =>
      'Glissez ou appuyez deux fois pour sélectionner ce que vous avez besoin';

  @override
  String get ocrNoTextDetected => 'Aucun texte détecté';

  @override
  String get ocrRetryButtonLabel => 'Réessayer';

  @override
  String get ocrModelsNetworkRequiredError =>
      'Connexion réseau requise pour télécharger les modèles OCR lors de la première utilisation';

  @override
  String get ocrModelsPrepareFailed => 'Impossible de préparer les modèles OCR';

  @override
  String get ocrImageNotFoundError => 'Fichier image introuvable';

  @override
  String get ocrImageDecodeFailedError => 'Impossible de lire le fichier image';

  @override
  String get ocrGenericDetectError =>
      'Impossible de détecter le texte dans l\'image';

  @override
  String get oops => 'Oups';

  @override
  String get somethingWentWrongPleaseTryAgain =>
      'Quelque chose s\'est mal passé, veuillez recommencer';

  @override
  String get thisWillLogYouOutOfThisDevice =>
      'Cela vous déconnectera de cet appareil !';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice =>
      'Cela vous déconnectera de l\'appareil suivant :';

  @override
  String get terminateSession => 'Se déconnecter ?';

  @override
  String get terminate => 'Se déconnecter';

  @override
  String get thisDevice => 'Cet appareil';

  @override
  String get recoverButton => 'Restaurer';

  @override
  String get recoverySuccessful => 'Restauration réussie !';

  @override
  String get decrypting => 'Déchiffrement en cours...';

  @override
  String get incorrectRecoveryKeyTitle => 'Clé de secours non valide';

  @override
  String get incorrectRecoveryKeyBody =>
      'La clé de secours que vous avez entrée est incorrecte';

  @override
  String get forgotPassword => 'Mot de passe oublié';

  @override
  String get enterYourRecoveryKey => 'Entrez votre clé de récupération';

  @override
  String get noRecoveryKey => 'Aucune clé de récupération ?';

  @override
  String get sorry => 'Désolé';

  @override
  String get noRecoveryKeyNoDecryption =>
      'En raison de notre protocole de chiffrement de bout en bout, vos données ne peuvent pas être déchiffré sans votre mot de passe ou clé de récupération';

  @override
  String get verifyEmail => 'Vérifier l\'e-mail';

  @override
  String get toResetVerifyEmail =>
      'Pour réinitialiser votre mot de passe, vérifiez d\'abord votre email.';

  @override
  String get checkInboxAndSpamFolder =>
      'Consultez votre boîte de réception (et les indésirables) pour finaliser la vérification';

  @override
  String get tapToEnterCode => 'Appuyez pour saisir le code';

  @override
  String get resendEmail => 'Renvoyer l\'e-mail';

  @override
  String weHaveSendEmailTo({required String email}) {
    return 'Nous avons envoyé un e-mail à <green>$email</green>';
  }

  @override
  String get setPasswordTitle => 'Définir le mot de passe';

  @override
  String get changePasswordTitle => 'Modifier le mot de passe';

  @override
  String get resetPasswordTitle => 'Réinitialiser le mot de passe';

  @override
  String get encryptionKeys => 'Clés de chiffrement';

  @override
  String get passwordWarning =>
      'Nous ne stockons pas ce mot de passe, donc si vous l\'oubliez, <underline>nous ne pouvons pas déchiffrer vos données</underline>';

  @override
  String get enterPasswordToEncrypt =>
      'Entrez un mot de passe que nous pouvons utiliser pour chiffrer vos données';

  @override
  String get enterNewPasswordToEncrypt =>
      'Saisissez votre nouveau mot de passe qui sera utilisé pour chiffrer vos données';

  @override
  String get weakStrength => 'Securité Faible';

  @override
  String get strongStrength => 'Forte';

  @override
  String get moderateStrength => 'Moyen';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'Sécurité du mot de passe : $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully => 'Le mot de passe a été modifié';

  @override
  String get generatingEncryptionKeys =>
      'Génération des clés de chiffrement...';

  @override
  String get pleaseWait => 'Veuillez patienter...';

  @override
  String get continueLabel => 'Continuer';

  @override
  String get insecureDevice => 'Appareil non sécurisé';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'Désolé, nous n\'avons pas pu générer de clés sécurisées sur cet appareil.\n\nVeuillez vous inscrire depuis un autre appareil.';

  @override
  String get howItWorks => 'Comment cela fonctionne';

  @override
  String get encryption => 'Chiffrement';

  @override
  String get ackPasswordLostWarning =>
      'Je comprends que si je perds mon mot de passe, je perdrai mes données puisque mes données sont <underline>chiffrées de bout en bout</underline>.';

  @override
  String get privacyPolicyTitle => 'Politique de Confidentialité';

  @override
  String get termsOfServicesTitle => 'Conditions d\'utilisation';

  @override
  String get signUpTerms =>
      'J\'accepte les <u-terms>conditions d\'utilisation</u-terms> et la <u-policy>politique de confidentialité</u-policy>';

  @override
  String get logInLabel => 'Se connecter';

  @override
  String get loginTerms =>
      'En cliquant sur se connecter, j\'accepte les <u-terms>conditions d\'utilisation</u-terms> et la <u-policy>politique de confidentialité</u-policy>';

  @override
  String get changeEmail => 'Modifier l\'e-mail';

  @override
  String get enterYourPassword => 'Entrez votre mot de passe';

  @override
  String get welcomeBack => 'Bienvenue !';

  @override
  String get contactSupport => 'Contacter l\'assistance';

  @override
  String get locationPickerTip =>
      'Vous pouvez également ajouter un lieu centré à partir d\'une photo depuis l\'écran d\'information de la photo';

  @override
  String get incorrectPasswordTitle => 'Mot de passe incorrect';

  @override
  String get pleaseTryAgain => 'Veuillez réessayer';

  @override
  String get recreatePasswordTitle => 'Recréer le mot de passe';

  @override
  String get useRecoveryKey => 'Utiliser la clé de secours';

  @override
  String get recreatePasswordBody =>
      'L\'appareil actuel n\'est pas assez puissant pour vérifier votre mot de passe, mais nous pouvons le régénérer d\'une manière qui fonctionne avec tous les appareils.\n\nVeuillez vous connecter à l\'aide de votre clé de secours et régénérer votre mot de passe (vous pouvez réutiliser le même si vous le souhaitez).';

  @override
  String get verifyPassword => 'Vérifier le mot de passe';

  @override
  String get recoveryKey => 'Clé de secours';

  @override
  String get recoveryKeyOnForgotPassword =>
      'Si vous oubliez votre mot de passe, la seule façon de récupérer vos données sera grâce à cette clé.';

  @override
  String get recoveryKeySaveDescription =>
      'Nous ne la stockons pas, veuillez la conserver en lieu endroit sûr.';

  @override
  String get doThisLater => 'Plus tard';

  @override
  String get saveKey => 'Enregistrer la clé';

  @override
  String get recoveryKeyCopiedToClipboard =>
      'Clé de secours copiée dans le presse-papiers';

  @override
  String get recoverAccount => 'Récupérer un compte';

  @override
  String get recover => 'Récupérer';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'Veuillez envoyer un e-mail à $supportEmail depuis votre adresse enregistrée';
  }

  @override
  String get twofactorSetup =>
      'Configuration de l\'authentification à deux facteurs';

  @override
  String get enterCode => 'Entrer le code';

  @override
  String get scanCode => 'Scanner le code';

  @override
  String get codeCopiedToClipboard => 'Code copié dans le presse-papiers';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      'Copiez-collez ce code\ndans votre application d\'authentification';

  @override
  String get tapToCopy => 'taper pour copier';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      'Scannez ce code-barres avec\nvotre application d\'authentification';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      'Entrez le code à 6 chiffres de\nvotre application d\'authentification';

  @override
  String get confirm => 'Confirmer';

  @override
  String get setupComplete => 'Configuration terminée';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready =>
      'Enregistrez votre clé de récupération si vous ne l\'avez pas déjà fait';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      'Cela peut être utilisé pour récupérer votre compte si vous perdez votre deuxième facteur';

  @override
  String get twofactorAuthenticationPageTitle =>
      'Authentification à deux facteurs (A2F)';

  @override
  String get lostDevice => 'Appareil perdu ?';

  @override
  String get verifyingRecoveryKey =>
      'Vérification de la clé de récupération...';

  @override
  String get recoveryKeyVerified => 'Clé de récupération vérifiée';

  @override
  String get recoveryKeySuccessBody =>
      'Génial ! Votre clé de récupération est valide. Merci de votre vérification.\n\nN\'oubliez pas de garder votre clé de récupération sauvegardée.';

  @override
  String get invalidRecoveryKey =>
      'La clé de récupération que vous avez saisie n\'est pas valide. Veuillez vérifier qu\'elle contient 24 caractères et qu\'ils sont correctement orthographiés.\n\nSi vous avez saisi un ancien code de récupération, veuillez vérifier qu\'il contient 64 caractères et qu\'ils sont correctement orthographiés.';

  @override
  String get invalidKey => 'Clé invalide';

  @override
  String get tryAgain => 'Réessayer';

  @override
  String get viewRecoveryKey => 'Voir la clé de récupération';

  @override
  String get confirmRecoveryKey => 'Confirmer la clé de récupération';

  @override
  String get recoveryKeyVerifyReason =>
      'Votre clé de récupération est la seule façon de récupérer vos photos si vous oubliez votre mot de passe. Vous pouvez trouver votre clé de récupération dans Paramètres > Compte.\n\nVeuillez saisir votre clé de récupération ici pour vous assurer de l\'avoir enregistré correctement.';

  @override
  String get confirmYourRecoveryKey => 'Confirmer la clé de récupération';

  @override
  String get addViewer => 'Ajouter un observateur';

  @override
  String get addCollaborator => 'Ajouter un collaborateur';

  @override
  String get admin => 'Admin';

  @override
  String get admins => 'Admins';

  @override
  String get addAdmin => 'Add admin';

  @override
  String get addMoreAdmins => 'Add more admins';

  @override
  String get adminsAndCollaboratorsCanAddPhotosDescription =>
      'Admins and collaborators can add photos. Admins can also manage photos & participants.';

  @override
  String get addANewEmail => 'Ajouter un nouvel email';

  @override
  String get orPickAnExistingOne => 'Ou sélectionner un email existant';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'Les collaborateurs peuvent ajouter des photos et des vidéos à l\'album partagé.';

  @override
  String get enterEmail => 'Entrer un email';

  @override
  String get albumOwner => 'Propriétaire';

  @override
  String get you => 'Vous';

  @override
  String get collaborator => 'Collaborateur';

  @override
  String get addMore => 'Ajouter';

  @override
  String get viewer => 'Observateur';

  @override
  String get remove => 'Supprimer';

  @override
  String get removeParticipant => 'Supprimer le participant';

  @override
  String get manage => 'Gérer';

  @override
  String get addedAs => 'Ajouté comme';

  @override
  String get changePermissions => 'Modifier les permissions ?';

  @override
  String get yesConvertToViewer => 'Oui, convertir en observateur';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return '$user ne pourra pas ajouter plus de photos à cet album\n\nIl pourra toujours supprimer les photos existantes ajoutées par eux';
  }

  @override
  String get allowAddingPhotos => 'Autoriser l\'ajout de photos';

  @override
  String get allowJoiningAlbum => 'Autoriser l\'adhésion à l\'album';

  @override
  String get allowAddPhotosDescription =>
      'Autorisez les personnes ayant le lien à ajouter des photos dans l\'album partagé.';

  @override
  String get passwordLock => 'Verrouillage par mot de passe';

  @override
  String get canNotOpenTitle => 'Impossible d\'ouvrir cet album';

  @override
  String get canNotOpenBody =>
      'Désolé, cet album ne peut pas être ouvert dans l\'application.';

  @override
  String get disableDownloadWarningTitle => 'Veuillez remarquer';

  @override
  String get disableDownloadWarningBody =>
      'Les observateurs peuvent toujours prendre des captures d\'écran ou enregistrer une copie de vos photos en utilisant des outils externes';

  @override
  String get allowDownloads => 'Autoriser les téléchargements';

  @override
  String get linkDeviceLimit => 'Limite d\'appareil';

  @override
  String get noDeviceLimit => 'Aucune';

  @override
  String get albumLayout => 'Disposition de l\'album';

  @override
  String get layoutGrouped => 'Groupé';

  @override
  String get layoutContinuous => 'En continu';

  @override
  String get layoutTrip => 'Excursion';

  @override
  String get preview => 'Aperçu';

  @override
  String get linkExpiry => 'Expiration du lien';

  @override
  String get linkExpired => 'Expiré';

  @override
  String get linkEnabled => 'Activé';

  @override
  String get linkNeverExpires => 'Jamais';

  @override
  String get expiredLinkInfo =>
      'Ce lien a expiré. Veuillez sélectionner un nouveau délai d\'expiration ou désactiver l\'expiration du lien.';

  @override
  String get setAPassword => 'Définir un mot de passe';

  @override
  String get lockButtonLabel => 'Verrouiller';

  @override
  String get enterPassword => 'Saisissez le mot de passe';

  @override
  String get removeLink => 'Supprimer le lien';

  @override
  String get manageLink => 'Gérer le lien';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'Le lien expirera le $expiryTime';
  }

  @override
  String get albumUpdated => 'Album mis à jour';

  @override
  String get never => 'Jamais';

  @override
  String get custom => 'Personnaliser';

  @override
  String get after1Hour => 'Après 1 heure';

  @override
  String get after1Day => 'Après 1 jour';

  @override
  String get after1Week => 'Après 1 semaine';

  @override
  String get after1Month => 'Après 1 mois';

  @override
  String get after1Year => 'Après 1 an';

  @override
  String get manageParticipants => 'Gérer';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Participants',
      one: '1 Participant',
      zero: 'Aucun Participant',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'Créez un lien pour permettre aux personnes d\'ajouter et de voir des photos dans votre album partagé sans avoir besoin d\'une application Ente ou d\'un compte. Idéal pour récupérer des photos d\'événement.';

  @override
  String get collectPhotos => 'Récupérer les photos';

  @override
  String get collaborativeLink => 'Lien collaboratif';

  @override
  String get shareWithNonenteUsers => 'Partager avec des utilisateurs non-Ente';

  @override
  String get createPublicLink => 'Créer un lien public';

  @override
  String get sendLink => 'Envoyer le lien';

  @override
  String get qrCode => 'QR Code';

  @override
  String get sendQrCode => 'Envoyer le QR code';

  @override
  String get copyLink => 'Copier le lien';

  @override
  String get copyEmbedHtml => 'Copier le code HTML intégré';

  @override
  String get linkHasExpired => 'Le lien a expiré';

  @override
  String get publicLinkEnabled => 'Lien public activé';

  @override
  String get shareALink => 'Partager le lien';

  @override
  String get sharedAlbumSectionDescription =>
      'Créez des albums partagés et collaboratifs avec d\'autres utilisateurs de Ente, y compris des utilisateurs ayant des plans gratuits.';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: 'Partagé avec $numberOfPeople personnes',
      one: 'Partagé avec 1 personne',
      zero: 'Partagez avec des personnes spécifiques',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId => 'Ceci est votre ID de vérification';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'Quelqu\'un qui partage des albums avec vous devrait voir le même ID sur son appareil.';

  @override
  String get howToViewShareeVerificationID =>
      'Demandez-leur d\'appuyer longuement sur leur adresse email dans l\'écran des paramètres pour vérifier que les identifiants des deux appareils correspondent.';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'Ceci est l\'ID de vérification de $email';
  }

  @override
  String get verificationId => 'ID de vérification';

  @override
  String verifyEmailID({required Object email}) {
    return 'Vérifier $email';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return '$email n\'a pas de compte Ente.\n\nEnvoyez une invitation pour partager des photos.';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return 'Voici mon ID de vérification : $verificationID pour ente.io.';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'Hé, pouvez-vous confirmer qu\'il s\'agit de votre ID de vérification ente.io : $verificationID';
  }

  @override
  String get somethingWentWrong => 'Un problème est survenu';

  @override
  String get sendInvite => 'Envoyer Invitations';

  @override
  String get shareTextRecommendUsingEnte =>
      'Téléchargez Ente pour pouvoir facilement partager des photos et vidéos en qualité originale\n\nhttps://ente.io';

  @override
  String get done => 'Terminé';

  @override
  String get applyCodeTitle => 'Utiliser le code';

  @override
  String get enterCodeDescription =>
      'Entrez le code fourni par votre ami·e pour débloquer l\'espace de stockage gratuit';

  @override
  String get apply => 'Appliquer';

  @override
  String get failedToApplyCode => 'Impossible d\'appliquer le code';

  @override
  String get enterReferralCode => 'Code de parrainage';

  @override
  String get codeAppliedPageTitle => 'Code appliqué';

  @override
  String get changeYourReferralCode => 'Modifier votre code de parrainage';

  @override
  String get change => 'Modifier';

  @override
  String get unavailableReferralCode =>
      'Désolé, ce code n\'est pas disponible.';

  @override
  String get codeChangeLimitReached =>
      'Désolé, vous avez atteint la limite de changements de code.';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'Veuillez contacter $familyAdminEmail pour modifier votre code.';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB Go';
  }

  @override
  String get claimed => 'Obtenu';

  @override
  String get details => 'Détails';

  @override
  String get claimMore => 'Réclamez plus !';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return 'Ils obtiennent aussi $storageAmountInGB Go';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '$storageAmountInGB Go chaque fois que quelqu\'un s\'inscrit à une offre payante et applique votre code';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'Code de parrainage Ente : $referralCode \n\nValidez le dans Paramètres → Général → Références pour obtenir $referralStorageInGB Go gratuitement après votre inscription à un plan payant\n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => 'Obtenez du stockage gratuit';

  @override
  String get inviteYourFriends => 'Parrainez vos ami·e·s';

  @override
  String get failedToFetchReferralDetails =>
      'Impossible de récupérer les détails du parrainage. Veuillez réessayer plus tard.';

  @override
  String get referralStep1 => '1. Donnez ce code à vos ami·e·s';

  @override
  String get referralStep2 => '2. Ils souscrivent à une offre payante';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. Vous recevez tous les deux $storageInGB Go* gratuits';
  }

  @override
  String get referralsAreCurrentlyPaused =>
      'Les recommandations sont actuellement en pause';

  @override
  String get youCanAtMaxDoubleYourStorage =>
      '* Vous pouvez au maximum doubler votre espace de stockage';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true': 'Votre famille a obtenu $storageAmountInGb Go jusqu\'à présent',
      'false': 'Vous avez obtenu $storageAmountInGb Go jusqu\'à présent',
      'other': 'Vous avez obtenu $storageAmountInGb Go jusqu\'à présent !',
    });
    return '$_temp0';
  }

  @override
  String get faq => 'FAQ';

  @override
  String get help => 'Documentation';

  @override
  String get oopsSomethingWentWrong => 'Oups, une erreur est arrivée';

  @override
  String get peopleUsingYourCode => 'Filleul·e·s utilisant votre code';

  @override
  String get eligible => 'éligible';

  @override
  String get total => 'total';

  @override
  String get codeUsedByYou => 'Code utilisé par vous';

  @override
  String get freeStorageClaimed => 'Stockage gratuit obtenu';

  @override
  String get freeStorageUsable => 'Stockage gratuit disponible';

  @override
  String get usableReferralStorageInfo =>
      'Le stockage gratuit possible est limité par votre offre actuelle. Vous pouvez au maximum doubler votre espace de stockage gratuitement, le stockage supplémentaire deviendra donc automatiquement utilisable lorsque vous mettrez à niveau votre offre.';

  @override
  String get removeFromAlbumTitle => 'Retirer de l\'album ?';

  @override
  String get removeFromAlbum => 'Retirer de l\'album';

  @override
  String get itemsWillBeRemovedFromAlbum =>
      'Les éléments sélectionnés seront supprimés de cet album';

  @override
  String get removeShareItemsWarning =>
      'Les photos sélectionnées ne seront accessibles par aucun spectateur de cet album, à l\'exception des propriétaires de photos.';

  @override
  String get addingToFavorites => 'Ajout aux favoris...';

  @override
  String get removingFromFavorites => 'Suppression des favoris…';

  @override
  String get sorryCouldNotAddToFavorites =>
      'Désolé, impossible d\'ajouter aux favoris !';

  @override
  String get sorryCouldNotRemoveFromFavorites =>
      'Désolé, impossible de supprimer des favoris !';

  @override
  String get subscribeToEnableSharing =>
      'Vous avez besoin d\'un abonnement payant actif pour activer le partage.';

  @override
  String get subscribeToChangeLinkSetting =>
      'Vous avez besoin d\'un abonnement payant pour modifier le paramètre de ce lien.';

  @override
  String get subscribe => 'S\'abonner';

  @override
  String get canOnlyRemoveFilesOwnedByYou =>
      'Vous ne pouvez supprimer que les fichiers que vous possédez';

  @override
  String get deleteSharedAlbum => 'Supprimer l\'album partagé ?';

  @override
  String get deleteAlbum => 'Supprimer l\'album';

  @override
  String get deleteAlbumDialog =>
      'Supprimer aussi les photos (et vidéos) présentes dans cet album de <bold>tous</bold> les autres albums dont elles font partie ?';

  @override
  String get deleteSharedAlbumDialogBody =>
      'L\'album sera supprimé pour tout le monde\n\nVous perdrez l\'accès aux photos partagées dans cet album qui sont détenues par d\'autres personnes';

  @override
  String get yesRemove => 'Oui, supprimer';

  @override
  String get creatingLink => 'Création du lien...';

  @override
  String get removeWithQuestionMark => 'Enlever?';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return '$userEmail sera retiré de cet album partagé\n\nToutes les photos ajoutées par eux seront également retirées de l\'album';
  }

  @override
  String get keepPhotos => 'Conserver les photos';

  @override
  String get deletePhotos => 'Supprimer les photos';

  @override
  String get inviteToEnte => 'Inviter à rejoindre Ente';

  @override
  String get removePublicLink => 'Supprimer le lien public';

  @override
  String disableLinkMessage({required Object albumName}) {
    return 'Cela supprimera le lien public pour accéder à \"$albumName\".';
  }

  @override
  String get sharing => 'Partage...';

  @override
  String get youCannotShareWithYourself =>
      'Vous ne pouvez pas partager avec vous-même';

  @override
  String get archive => 'Archivée';

  @override
  String get createAlbumActionHint =>
      'Appuyez longuement pour sélectionner des photos et cliquez sur + pour créer un album';

  @override
  String get importing => 'Importation en cours...';

  @override
  String get failedToLoadAlbums => 'Impossible de charger les albums';

  @override
  String get hidden => 'Masqué';

  @override
  String get authToViewYourHiddenFiles =>
      'Veuillez vous authentifier pour voir vos fichiers cachés';

  @override
  String get authToViewTrashedFiles =>
      'Veuillez vous authentifier pour voir vos fichiers mis à la corbeille';

  @override
  String get trash => 'Corbeille';

  @override
  String get uncategorized => 'Aucune catégorie';

  @override
  String get videoSmallCase => 'vidéo';

  @override
  String get photoSmallCase => 'photo';

  @override
  String get singleFileDeleteHighlight =>
      'Elle sera supprimée de tous les albums.';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return 'Cette $fileType est à la fois sur ente et sur votre appareil.';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return 'Cette $fileType sera supprimée de l\'Ente.';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return 'Elle $fileType sera supprimée de votre appareil.';
  }

  @override
  String get deleteFromEnte => 'Supprimer de Ente';

  @override
  String get yesDelete => 'Oui, supprimer';

  @override
  String get movedToTrash => 'Déplacé dans la corbeille';

  @override
  String get deleteFromDevice => 'Supprimer de l\'appareil';

  @override
  String get deleteFromBoth => 'Supprimer des deux';

  @override
  String get newAlbum => 'Nouvel album';

  @override
  String get albums => 'Albums';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount souvenirs',
      one: '$formattedCount souvenir',
      zero: 'aucun souvenir',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return '$count sélectionné(s)';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return '$count sélectionné(s) ($yourCount à vous)';
  }

  @override
  String get advancedSettings => 'Avancé';

  @override
  String get photoGridSize => 'Taille de la grille photo';

  @override
  String get manageDeviceStorage => 'Gérer le cache de l\'appareil';

  @override
  String get manageDeviceStorageDesc => 'Examiner et vider le cache.';

  @override
  String get machineLearning => 'Apprentissage automatique (IA locale)';

  @override
  String get mlConsent => 'Activer l\'apprentissage automatique';

  @override
  String get mlConsentTitle => 'Activer l\'apprentissage automatique ?';

  @override
  String get mlConsentDescription =>
      'Si vous activez l\'apprentissage automatique Ente extraira des informations comme la géométrie des visages, y compris dans les photos partagées avec vous. \nCela se fera localement sur votre appareil et avec un chiffrement bout-en-bout de toutes les données biométriques générées.';

  @override
  String get mlConsentPrivacy =>
      'Veuillez cliquer ici pour plus de détails sur cette fonctionnalité dans notre politique de confidentialité';

  @override
  String get mlConsentConfirmation =>
      'Je comprends et je souhaite activer l\'apprentissage automatique';

  @override
  String get magicSearch => 'Recherche magique';

  @override
  String get discover => 'Découverte';

  @override
  String get discover_identity => 'Identité';

  @override
  String get discover_screenshots => 'Captures d\'écran ';

  @override
  String get discover_receipts => 'Recettes';

  @override
  String get discover_notes => 'Notes';

  @override
  String get discover_memes => 'Mèmes';

  @override
  String get discover_visiting_cards => 'Carte de Visite';

  @override
  String get discover_babies => 'Bébés';

  @override
  String get discover_pets => 'Animaux de compagnie';

  @override
  String get discover_selfies => 'Selfies';

  @override
  String get discover_wallpapers => 'Fonds d\'écran';

  @override
  String get discover_food => 'Alimentation';

  @override
  String get discover_celebrations => 'Fêtes';

  @override
  String get discover_sunset => 'Coucher du soleil';

  @override
  String get discover_hills => 'Montagnes';

  @override
  String get discover_greenery => 'Plantes';

  @override
  String get mlIndexingDescription =>
      'Veuillez noter que l\'apprentissage automatique entraînera une augmentation de l\'utilisation de la connexion Internet et de la batterie jusqu\'à ce que tous les souvenirs soient indexés. \nVous pouvez utiliser l\'application de bureau Ente pour accélérer cette étape, tous les résultats seront synchronisés.';

  @override
  String get loadingModel => 'Téléchargement des modèles...';

  @override
  String get waitingForWifi => 'En attente de connexion Wi-Fi...';

  @override
  String get status => 'État';

  @override
  String get indexedItems => 'Éléments indexés';

  @override
  String get pendingItems => 'Éléments en attente';

  @override
  String get clearIndexes => 'Effacer les index';

  @override
  String get selectFoldersForBackup => 'Dossiers à sauvegarder';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      'Les dossiers sélectionnés seront chiffrés et sauvegardés';

  @override
  String get unselectAll => 'Désélectionner tout';

  @override
  String get selectAll => 'Tout sélectionner';

  @override
  String get skip => 'Ignorer';

  @override
  String get updatingFolderSelection =>
      'Mise à jour de la sélection du dossier...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count objets',
      one: '$count objet',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Supprimer $count fichiers',
      one: 'Supprimer le fichier',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count fichiers, $formattedSize chacun';
  }

  @override
  String get showMemories => 'Afficher les souvenirs';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'il y a $count ans',
      one: 'il y a $count an',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'Paramètres de la sauvegarde';

  @override
  String get backupStatus => 'État de la sauvegarde';

  @override
  String get backupStatusDescription =>
      'Les éléments qui ont été sauvegardés apparaîtront ici';

  @override
  String get backupOverMobileData => 'Sauvegarder avec les données mobiles';

  @override
  String get backupVideos => 'Sauvegarde des vidéos';

  @override
  String get disableAutoLock => 'Désactiver le verrouillage automatique';

  @override
  String get deviceLockExplanation =>
      'Désactiver le verrouillage de l\'écran lorsque Ente est au premier plan et qu\'une sauvegarde est en cours. Ce n\'est normalement pas nécessaire mais cela peut faciliter les gros téléchargements et les premières importations de grandes bibliothèques.';

  @override
  String get about => 'À propos d\'Ente';

  @override
  String get weAreOpenSource => 'Nous sommes open source !';

  @override
  String get privacy => 'Politique de confidentialité';

  @override
  String get terms => 'Conditions';

  @override
  String get checkForUpdates => 'Vérifier les mises à jour';

  @override
  String get checkStatus => 'Vérifier le statut';

  @override
  String get checking => 'Vérification...';

  @override
  String get youAreOnTheLatestVersion => 'Vous êtes sur la dernière version';

  @override
  String get account => 'Compte';

  @override
  String get manageSubscription => 'Gérer l\'abonnement';

  @override
  String get authToChangeYourEmail =>
      'Authentifiez-vous pour modifier votre adresse email';

  @override
  String get changePassword => 'Modifier le mot de passe';

  @override
  String get authToChangeYourPassword =>
      'Veuillez vous authentifier pour modifier votre mot de passe';

  @override
  String get emailVerificationToggle =>
      'Authentification à deux facteurs par email';

  @override
  String get authToChangeEmailVerificationSetting =>
      'Authentifiez-vous pour modifier l\'authentification à deux facteurs par email';

  @override
  String get exportYourData => 'Exportez vos données';

  @override
  String get logout => 'Déconnexion';

  @override
  String get authToInitiateAccountDeletion =>
      'Veuillez vous authentifier pour débuter la suppression du compte';

  @override
  String get areYouSureYouWantToLogout =>
      'Voulez-vous vraiment vous déconnecter ?';

  @override
  String get yesLogout => 'Oui, se déconnecter';

  @override
  String get aNewVersionOfEnteIsAvailable =>
      'Une nouvelle version de Ente est disponible.';

  @override
  String get update => 'Mise à jour';

  @override
  String get installManually => 'Installation manuelle';

  @override
  String get criticalUpdateAvailable => 'Mise à jour critique disponible';

  @override
  String get updateAvailable => 'Une mise à jour est disponible';

  @override
  String get ignoreUpdate => 'Ignorer';

  @override
  String get downloading => 'Téléchargement en cours...';

  @override
  String get cannotDeleteSharedFiles =>
      'Les fichiers partagés ne peuvent pas être supprimés';

  @override
  String get theDownloadCouldNotBeCompleted =>
      'Le téléchargement n\'a pas pu être terminé';

  @override
  String get retry => 'Réessayer';

  @override
  String get backedUpFolders => 'Dossiers sauvegardés';

  @override
  String get backup => 'Sauvegarde';

  @override
  String get freeUpDeviceSpace => 'Libérer de l\'espace sur l\'appareil';

  @override
  String get freeUpDeviceSpaceDesc =>
      'Économisez de l\'espace sur votre appareil en effaçant les fichiers qui ont déjà été sauvegardés.';

  @override
  String get allClear => '✨ Tout est effacé';

  @override
  String get noDeviceThatCanBeDeleted =>
      'Vous n\'avez pas de fichiers sur cet appareil qui peuvent être supprimés';

  @override
  String get removeDuplicates => 'Supprimer les doublons';

  @override
  String get removeDuplicatesDesc =>
      'Examinez et supprimez les fichiers étant des doublons exacts.';

  @override
  String get viewLargeFiles => 'Fichiers volumineux';

  @override
  String get viewLargeFilesDesc =>
      'Affichez les fichiers qui consomment le plus de stockage.';

  @override
  String get noDuplicates => '✨ Aucun doublon';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared =>
      'Vous n\'avez aucun fichier dupliqué pouvant être nettoyé';

  @override
  String get success => 'Succès';

  @override
  String get rateUs => 'Évaluez-nous';

  @override
  String get remindToEmptyDeviceTrash =>
      'Également vide \"récemment supprimé\" de \"Paramètres\" -> \"Stockage\" pour réclamer l\'espace libéré';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return 'Vous avez libéré $storageSaved avec succès !';
  }

  @override
  String get remindToEmptyEnteTrash =>
      'Vide aussi votre \"Corbeille\" pour réclamer l\'espace libéré';

  @override
  String get sparkleSuccess => '✨ Succès';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count fichiers dupliqués',
      one: '$count fichier dupliqué',
    );
    return 'Vous avez nettoyé $_temp0, en libérant ($storageSaved!)';
  }

  @override
  String get familyPlans => 'Abonnements famille';

  @override
  String get referrals => 'Parrainages';

  @override
  String get notifications => 'Notifications';

  @override
  String get sharedPhotoNotifications => 'Nouvelles photos partagées';

  @override
  String get sharedPhotoNotificationsExplanation =>
      'Recevoir des notifications quand quelqu\'un·e ajoute une photo à un album partagé dont vous faites partie';

  @override
  String get advanced => 'Avancé';

  @override
  String get general => 'Général';

  @override
  String get security => 'Sécurité';

  @override
  String get authToViewYourRecoveryKey =>
      'Veuillez vous authentifier pour afficher votre clé de récupération';

  @override
  String get twofactor => 'Authentification à deux facteurs (A2F)';

  @override
  String get authToConfigureTwofactorAuthentication =>
      'Veuillez vous authentifier pour configurer l\'authentification à deux facteurs';

  @override
  String get lockscreen => 'Écran de verrouillage';

  @override
  String get authToChangeLockscreenSetting =>
      'Veuillez vous authentifier pour modifier les paramètres de l\'écran de verrouillage';

  @override
  String get viewActiveSessions => 'Afficher les connexions actives';

  @override
  String get authToViewYourActiveSessions =>
      'Authentifiez-vous pour voir les connexions actives';

  @override
  String get disableTwofactor =>
      'Désactiver l\'authentification à deux facteurs';

  @override
  String get confirm2FADisable =>
      'Voulez-vous vraiment désactiver l\'authentification à deux facteurs ?';

  @override
  String get no => 'Non';

  @override
  String get yes => 'Oui';

  @override
  String get social => 'Retrouvez nous';

  @override
  String rateUsOnStore({required Object storeName}) {
    return 'Laissez une note sur $storeName';
  }

  @override
  String get blog => 'Blog';

  @override
  String get merchandise => 'Boutique';

  @override
  String get twitter => 'Twitter';

  @override
  String get mastodon => 'Mastodon';

  @override
  String get matrix => 'Matrix';

  @override
  String get discord => 'Discord';

  @override
  String get reddit => 'Reddit';

  @override
  String get yourStorageDetailsCouldNotBeFetched =>
      'Vos informations de stockage n\'ont pas pu être récupérées';

  @override
  String get reportABug => 'Signaler un bogue';

  @override
  String get reportBug => 'Signaler un bogue';

  @override
  String get suggestFeatures => 'Suggérer une fonctionnalité';

  @override
  String get support => 'Support';

  @override
  String get theme => 'Thème';

  @override
  String get lightTheme => 'Clair';

  @override
  String get darkTheme => 'Sombre';

  @override
  String get systemTheme => 'Système';

  @override
  String get freeTrial => 'Essai gratuit';

  @override
  String get selectYourPlan => 'Sélectionner votre offre';

  @override
  String get enteSubscriptionPitch =>
      'Ente conserve vos souvenirs pour qu\'ils soient toujours disponible, même si vous perdez cet appareil.';

  @override
  String get enteSubscriptionShareWithFamily =>
      'Vous pouvez également ajouter votre famille à votre forfait.';

  @override
  String get currentUsageIs => 'L\'utilisation actuelle est de ';

  @override
  String get faqs => 'FAQ';

  @override
  String renewsOn({required Object endDate}) {
    return 'Renouvellement le $endDate';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return 'Essai gratuit valide jusqu’au $endDate';
  }

  @override
  String validTill({required Object endDate}) {
    return 'Valable jusqu\'au $endDate';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return 'Votre extension de $storageAmount est valable jusqu\'au $endDate';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return 'Essai gratuit valable jusqu\'à $endDate.\nVous pouvez choisir un plan payant par la suite.';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'Votre abonnement sera annulé le $endDate';
  }

  @override
  String get subscription => 'Abonnement';

  @override
  String get paymentDetails => 'Détails de paiement';

  @override
  String get manageFamily => 'Gérer la famille';

  @override
  String contactToManageSubscription({required Object provider}) {
    return 'Veuillez nous contacter à support@ente.io pour gérer votre abonnement $provider.';
  }

  @override
  String get renewSubscription => 'Renouveler l’abonnement';

  @override
  String get cancelSubscription => 'Annuler l\'abonnement';

  @override
  String get areYouSureYouWantToRenew =>
      'Êtes-vous sûr de vouloir renouveler ?';

  @override
  String get yesRenew => 'Oui, renouveler';

  @override
  String get areYouSureYouWantToCancel => 'Es-tu sûre de vouloir annuler?';

  @override
  String get yesCancel => 'Oui, annuler';

  @override
  String get failedToRenew => 'Échec du renouvellement';

  @override
  String get failedToCancel => 'Échec de l\'annulation';

  @override
  String get twoMonthsFreeOnYearlyPlans =>
      '2 mois gratuits sur les forfaits annuels';

  @override
  String get monthly => 'Mensuel';

  @override
  String get yearly => 'Annuel';

  @override
  String get confirmPlanChange => 'Confirmer le changement de l\'offre';

  @override
  String get areYouSureYouWantToChangeYourPlan =>
      'Êtes-vous certains de vouloir changer d\'offre ?';

  @override
  String get youCannotDowngradeToThisPlan =>
      'Vous ne pouvez pas rétrograder vers cette offre';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'Veuillez d\'abord annuler votre abonnement existant de $paymentProvider';
  }

  @override
  String get optionalAsShortAsYouLike =>
      'Optionnel, aussi court que vous le souhaitez...';

  @override
  String get send => 'Envoyer';

  @override
  String get askCancelReason =>
      'Votre abonnement a été annulé. Souhaitez-vous partager la raison ?';

  @override
  String get thankYouForSubscribing => 'Merci de vous être abonné !';

  @override
  String get yourPurchaseWasSuccessful =>
      'Votre achat a été effectué avec succès';

  @override
  String get yourPlanWasSuccessfullyUpgraded =>
      'Votre offre a été mise à jour avec succès';

  @override
  String get yourPlanWasSuccessfullyDowngraded =>
      'Votre plan a été rétrogradé avec succès';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully =>
      'Votre abonnement a été mis à jour avec succès';

  @override
  String get googlePlayId => 'Identifiant Google Play';

  @override
  String get appleId => 'Apple ID';

  @override
  String get playstoreSubscription => 'Abonnement au PlayStore';

  @override
  String get appstoreSubscription => 'Abonnement à l\'AppStore';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return 'Votre $id est déjà lié à un autre compte Ente.\nSi vous souhaitez utiliser votre $id avec ce compte, veuillez contacter notre support';
  }

  @override
  String get visitWebToManage =>
      'Vous pouvez gérer votre abonnement sur web.ente.io';

  @override
  String get couldNotUpdateSubscription =>
      'Impossible de mettre à jour l’abonnement';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      'Veuillez contacter support@ente.io et nous serons heureux de vous aider!';

  @override
  String get paymentFailed => 'Échec du paiement';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return 'Veuillez contacter le support $providerName si vous avez été facturé';
  }

  @override
  String get continueOnFreeTrial =>
      'Poursuivre avec la version d\'essai gratuite';

  @override
  String get areYouSureYouWantToExit => 'Êtes-vous sûr de vouloir quitter ?';

  @override
  String get thankYou => 'Merci';

  @override
  String get failedToVerifyPaymentStatus =>
      'Échec de la vérification du statut du paiement';

  @override
  String get pleaseWaitForSometimeBeforeRetrying =>
      'Veuillez attendre quelque temps avant de réessayer';

  @override
  String get paymentFailedMessage =>
      'Malheureusement votre paiement a échoué. Veuillez contacter le support et nous vous aiderons !';

  @override
  String get youAreOnAFamilyPlan => 'Vous êtes sur un plan familial !';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'Veuillez contacter <green>$familyAdminEmail</green> pour gérer votre abonnement';
  }

  @override
  String get leaveFamily => 'Quitter le plan familial';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily =>
      'Êtes-vous certains de vouloir quitter le plan familial?';

  @override
  String get leave => 'Quitter';

  @override
  String get rateTheApp => 'Évaluer l\'application';

  @override
  String get startBackup => 'Démarrer la sauvegarde';

  @override
  String get noPhotosAreBeingBackedUpRightNow =>
      'Aucune photo en cours de sauvegarde';

  @override
  String get preserveMore => 'Conserver plus';

  @override
  String get grantFullAccessPrompt =>
      'Veuillez autoriser l’accès à toutes les photos dans les paramètres';

  @override
  String get allowPermTitle => 'Autoriser l\'accès aux photos';

  @override
  String get allowPermBody =>
      'Veuillez autoriser dans les paramètres l\'accès à vos photos pour qu\'Ente puisse afficher et sauvegarder votre bibliothèque.';

  @override
  String get openSettings => 'Ouvrir les paramètres';

  @override
  String get selectMorePhotos => 'Sélectionner plus de photos';

  @override
  String get existingUser => 'Utilisateur existant';

  @override
  String get privateBackups => 'Sauvegardes privées';

  @override
  String get forYourMemories => 'pour vos souvenirs';

  @override
  String get endtoendEncryptedByDefault =>
      'Chiffrement de bout en bout par défaut';

  @override
  String get safelyStored => 'Stockage sécurisé';

  @override
  String get atAFalloutShelter => 'dans un abri antiatomique';

  @override
  String get designedToOutlive => 'Conçu pour survivre';

  @override
  String get available => 'Disponible';

  @override
  String get everywhere => 'partout';

  @override
  String get androidIosWebDesktop => 'Android, iOS, Web, Ordinateur';

  @override
  String get mobileWebDesktop => 'Mobile, Web, Ordinateur';

  @override
  String get newToEnte => 'Nouveau sur Ente';

  @override
  String get pleaseLoginAgain => 'Veuillez vous reconnecter';

  @override
  String get autoLogoutMessage =>
      'En raison d\'un problème technique, vous avez été déconnecté. Veuillez nous excuser pour le désagrément.';

  @override
  String get yourSubscriptionHasExpired => 'Votre abonnement a expiré';

  @override
  String get storageLimitExceeded => 'Limite de stockage atteinte';

  @override
  String get upgrade => 'Améliorer';

  @override
  String get raiseTicket => 'Créer un ticket';

  @override
  String get backupFailed => 'Échec de la sauvegarde';

  @override
  String get sorryBackupFailedDesc =>
      'Désolé, nous n\'avons pas pu sauvegarder ce fichier maintenant, nous allons réessayer plus tard.';

  @override
  String get couldNotBackUpTryLater =>
      'Nous n\'avons pas pu sauvegarder vos données.\nNous allons réessayer plus tard.';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      'Ente peut chiffrer et conserver des fichiers que si vous leur accordez l\'accès';

  @override
  String get pleaseGrantPermissions => 'Veuillez accorder la permission';

  @override
  String get grantPermission => 'Accorder la permission';

  @override
  String get privateSharing => 'Partage privé';

  @override
  String get shareOnlyWithThePeopleYouWant =>
      'Partagez uniquement avec les personnes que vous souhaitez';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      'Utilisez des liens publics pour les personnes qui ne sont pas sur Ente';

  @override
  String get allowPeopleToAddPhotos =>
      'Permettez à des personnes d\'ajouter des photos';

  @override
  String get shareAnAlbumNow => 'Partagez un album maintenant';

  @override
  String get collectEventPhotos => 'Collectez les photos d\'un événement';

  @override
  String get sessionExpired => 'Session expirée';

  @override
  String get loggingOut => 'Deconnexion...';

  @override
  String get onDevice => 'Sur votre appareil';

  @override
  String get onEnte => 'Sur <branding>Ente</branding>';

  @override
  String get name => 'Nom';

  @override
  String get newest => 'Le plus récent';

  @override
  String get lastUpdated => 'Dernière mise à jour';

  @override
  String get deleteEmptyAlbums => 'Supprimer les albums vides';

  @override
  String get deleteEmptyAlbumsWithQuestionMark =>
      'Supprimer les albums vides ?';

  @override
  String get deleteAlbumsDialogBody =>
      'Ceci supprimera tous les albums vides. Ceci est utile lorsque vous voulez réduire l\'encombrement dans votre liste d\'albums.';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return 'Suppression de $currentlyDeleting / $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return 'Traitement en cours $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => 'Supprimer définitivement';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou =>
      'Ne peut créer de lien que pour les fichiers que vous possédez';

  @override
  String get publicLinkCreated => 'Lien public créé';

  @override
  String get youCanManageYourLinksInTheShareTab =>
      'Vous pouvez gérer vos liens dans l\'onglet Partage.';

  @override
  String get linkCopiedToClipboard => 'Lien copié dans le presse-papiers';

  @override
  String get restore => 'Restaurer';

  @override
  String get moveToAlbum => 'Déplacer vers l\'album';

  @override
  String get unhide => 'Dévoiler';

  @override
  String get unarchive => 'Désarchiver';

  @override
  String get favorite => 'Favori';

  @override
  String get removeFromFavorite => 'Retirer des favoris';

  @override
  String get shareLink => 'Partager le lien';

  @override
  String get createCollage => 'Créez un collage';

  @override
  String get saveCollage => 'Enregistrer le collage';

  @override
  String get collageSaved => 'Collage sauvegardé dans la galerie';

  @override
  String get collageLayout => 'Disposition';

  @override
  String get addToEnte => 'Ajouter à Ente';

  @override
  String get addToAlbum => 'Ajouter à l\'album';

  @override
  String get delete => 'Supprimer';

  @override
  String get hide => 'Masquer';

  @override
  String get share => 'Partager';

  @override
  String get unhideToAlbum => 'Afficher dans l\'album';

  @override
  String get restoreToAlbum => 'Restaurer vers l\'album';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Déplacer des éléments',
      one: 'Déplacer un élément',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Ajouter des éléments',
      one: 'Ajouter un élément',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'Créez ou sélectionnez un album';

  @override
  String get selectAlbum => 'Sélectionner album';

  @override
  String get searchByAlbumNameHint => 'Nom de l\'album';

  @override
  String get albumTitle => 'Titre de l\'album';

  @override
  String get enterAlbumName => 'Saisir un nom d\'album';

  @override
  String get restoringFiles => 'Restauration des fichiers...';

  @override
  String get movingFilesToAlbum => 'Déplacement des fichiers vers l\'album...';

  @override
  String get unhidingFilesToAlbum => 'Démasquage des fichiers vers l\'album';

  @override
  String get canNotUploadToAlbumsOwnedByOthers =>
      'Impossible de télécharger dans les albums appartenant à d\'autres personnes';

  @override
  String get uploadingFilesToAlbum => 'Envoi des fichiers vers l\'album...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return 'Ajouté avec succès à  $albumName';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return 'Déplacé avec succès vers $albumName';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'Cet album a déjà un lien collaboratif';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return 'Lien collaboratif créé pour $albumName';
  }

  @override
  String get askYourLovedOnesToShare => 'Demandez à vos proches de partager';

  @override
  String get invite => 'Inviter';

  @override
  String get shareYourFirstAlbum => 'Partagez votre premier album';

  @override
  String sharedWith({required Object emailIDs}) {
    return 'Partagé avec $emailIDs';
  }

  @override
  String get sharedWithMe => 'Partagés avec moi';

  @override
  String get sharedByMe => 'Partagé par moi';

  @override
  String get doubleYourStorage => 'Doublez votre espace de stockage';

  @override
  String get referFriendsAnd2xYourPlan =>
      'Parrainez vos ami·e·s et doublez votre stockage';

  @override
  String get shareAlbumHint =>
      'Ouvrez un album et appuyez sur le bouton de partage en haut à droite pour le partager.';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      'Les éléments montrent le nombre de jours restants avant la suppression définitive';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count jours',
      one: '1 jour',
      zero: 'Bientôt',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => 'Tout Supprimer';

  @override
  String get renameAlbum => 'Renommer l\'album';

  @override
  String get convertToAlbum => 'Convertir en album';

  @override
  String get setCover => 'Définir la couverture';

  @override
  String get sortAlbumsBy => 'Trier par';

  @override
  String get sortNewestFirst => 'Plus récent en premier';

  @override
  String get sortOldestFirst => 'Plus ancien en premier';

  @override
  String get rename => 'Renommer';

  @override
  String get leaveSharedAlbum => 'Quitter l\'album partagé?';

  @override
  String get leaveAlbum => 'Quitter l\'album';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'Les photos ajoutées par vous seront retirées de l\'album';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted =>
      'Vous n\'avez pas de fichiers dans cet album qui peuvent être supprimés';

  @override
  String get youDontHaveAnyArchivedItems =>
      'Vous n\'avez aucun élément archivé.';

  @override
  String get ignoredFolderUploadReason =>
      'Certains fichiers de cet album sont ignorés parce qu\'ils avaient été précédemment supprimés de Ente.';

  @override
  String get resetIgnoredFiles => 'Réinitialiser les fichiers ignorés';

  @override
  String get deviceFilesAutoUploading =>
      'Les fichiers ajoutés à cet album seront automatiquement téléchargés sur Ente.';

  @override
  String get turnOnBackupForAutoUpload =>
      'Activez la sauvegarde pour charger automatiquement sur Ente les fichiers ajoutés à ce dossier de l\'appareil.';

  @override
  String get noHiddenPhotosOrVideos => 'Aucune photo ou vidéo masquée';

  @override
  String get toHideAPhotoOrVideo => 'Pour masquer une photo ou une vidéo:';

  @override
  String get openTheItem => '• Ouvrir l\'élément';

  @override
  String get clickOnTheOverflowMenu => '• Cliquez sur le menu de débordement';

  @override
  String get click => '• Cliquez sur';

  @override
  String get nothingToSeeHere => 'Il n\'y a encore rien à voir ici 👀';

  @override
  String get unarchiveAlbum => 'Désarchiver l\'album';

  @override
  String get archiveAlbum => 'Archiver l\'album';

  @override
  String get calculating => 'Calcul en cours...';

  @override
  String get pleaseWaitDeletingAlbum =>
      'Veuillez patienter, suppression de l\'album';

  @override
  String get searchByExamples =>
      '• Noms d\'albums (par exemple \"Caméra\")\n• Types de fichiers (par exemple \"Vidéos\", \".gif\")\n• Années et mois (par exemple \"2022\", \"Janvier\")\n• Vacances (par exemple \"Noël\")\n• Descriptions de photos (par exemple \"#fun\")';

  @override
  String get youCanTrySearchingForADifferentQuery =>
      'Vous pouvez essayer de rechercher une autre requête.';

  @override
  String get noResultsFound => 'Aucun résultat trouvé';

  @override
  String addedBy({required Object emailOrName}) {
    return 'Ajouté par $emailOrName';
  }

  @override
  String get loadingExifData => 'Chargement des données EXIF...';

  @override
  String get viewAllExifData => 'Visualiser toutes les données EXIF';

  @override
  String get noExifData => 'Aucune donnée EXIF';

  @override
  String get thisImageHasNoExifData => 'Cette image n\'a pas de données exif';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => 'Aucun résultat';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'Nous ne prenons pas en charge l\'édition des photos et des albums que vous ne possédez pas encore';

  @override
  String get failedToFetchOriginalForEdit =>
      'Impossible de récupérer l\'original pour l\'édition';

  @override
  String get close => 'Fermer';

  @override
  String get setAs => 'Définir comme';

  @override
  String get fileSavedToGallery => 'Fichier enregistré dans la galerie';

  @override
  String get filesSavedToGallery => 'Fichiers enregistrés dans la galerie';

  @override
  String get fileFailedToSaveToGallery =>
      'Échec de l\'enregistrement dans la galerie';

  @override
  String get download => 'Télécharger';

  @override
  String get pressAndHoldToPlayVideo =>
      'Appuyez et maintenez enfoncé pour lire la vidéo';

  @override
  String get pressAndHoldToPlayVideoDetailed =>
      'Maintenez appuyé sur l\'image pour lire la vidéo';

  @override
  String get downloadFailed => 'Échec du téléchargement';

  @override
  String get deduplicateFiles => 'Déduplication de fichiers';

  @override
  String get deselectAll => 'Tout déselectionner';

  @override
  String get reviewDeduplicateItems =>
      'Veuillez vérifier et supprimer les éléments que vous croyez dupliqués.';

  @override
  String get clubByCaptureTime => 'Grouper par durée';

  @override
  String get clubByFileName => 'Grouper par nom de fichier';

  @override
  String get count => 'Total';

  @override
  String get totalSize => 'Taille totale';

  @override
  String get longpressOnAnItemToViewInFullscreen =>
      'Appuyez longuement sur un élément pour le voir en plein écran';

  @override
  String get decryptingVideo => 'Déchiffrement de la vidéo...';

  @override
  String get authToViewYourMemories =>
      'Authentifiez-vous pour voir vos souvenirs';

  @override
  String get unlock => 'Déverrouiller';

  @override
  String get freeUpSpace => 'Libérer de l\'espace';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other:
          'Ils peuvent être supprimés de l\'appareil pour libérer $formattedSize',
      one: 'Il peut être supprimé de l\'appareil pour libérer $formattedSize',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other:
          '$formattedNumber fichiers dans cet album ont été sauvegardés en toute sécurité',
      one: '1 fichier dans cet album a été sauvegardé en toute sécurité',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other:
          '$formattedNumber fichiers sur cet appareil ont été sauvegardés en toute sécurité',
      one: '1 fichier sur cet appareil a été sauvegardé en toute sécurité',
    );
    return '$_temp0';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'les',
      one: 'l\'',
    );
    return 'Vous pouvez toujours $_temp0 accéder sur Ente tant que vous avez un abonnement actif';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return 'Libérer $sizeInMBorGB';
  }

  @override
  String get thisEmailIsAlreadyInUse => 'Cette adresse mail est déjà utilisé';

  @override
  String get incorrectCode => 'Code non valide';

  @override
  String get authenticationFailedPleaseTryAgain =>
      'L\'authentification a échouée, veuillez réessayer';

  @override
  String get verificationFailedPleaseTryAgain =>
      'La vérification a échouée, veuillez réessayer';

  @override
  String get authenticating => 'Authentification...';

  @override
  String get authenticationSuccessful => 'Authentification réussie!';

  @override
  String get incorrectRecoveryKey => 'Clé de récupération non valide';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect =>
      'La clé de récupération que vous avez entrée est incorrecte';

  @override
  String get twofactorAuthenticationSuccessfullyReset =>
      'L\'authentification à deux facteurs a été réinitialisée avec succès ';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered =>
      'Veuillez vérifier le code que vous avez entré';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      'Merci de contacter l\'assistance si cette erreur persiste';

  @override
  String get twofactorAuthenticationHasBeenDisabled =>
      'L\'authentification à deux facteurs a été désactivée';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect =>
      'Le code que vous avez saisi est incorrect';

  @override
  String get yourVerificationCodeHasExpired =>
      'Votre code de vérification a expiré';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'L\'email a été changé par $newEmail';
  }

  @override
  String get verifying => 'Validation en cours...';

  @override
  String get disablingTwofactorAuthentication =>
      'Désactivation de l\'authentification à deux facteurs...';

  @override
  String get allMemoriesPreserved => 'Tous les souvenirs sont sauvegardés';

  @override
  String get loadingGallery => 'Chargement de la galerie...';

  @override
  String get syncing => 'En cours de synchronisation...';

  @override
  String get encryptingBackup => 'Chiffrement de la sauvegarde...';

  @override
  String get syncStopped => 'Synchronisation arrêtée ?';

  @override
  String syncProgress({required String completed, required String total}) {
    return '$completed/$total souvenirs sauvegardés';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return 'Sauvegarde de $count souvenirs...';
  }

  @override
  String get uploadingSingleMemory => 'Sauvegarde d\'un souvenir...';

  @override
  String get archiving => 'Archivage en cours...';

  @override
  String get unarchiving => 'Désarchivage en cours...';

  @override
  String get successfullyArchived => 'Archivé avec succès';

  @override
  String get successfullyUnarchived => 'Désarchivé avec succès';

  @override
  String get renameFile => 'Renommer le fichier';

  @override
  String get enterFileName => 'Entrez le nom du fichier';

  @override
  String get filesDeleted => 'Fichiers supprimés';

  @override
  String get selectedFilesAreNotOnEnte =>
      'Les fichiers sélectionnés ne sont pas sur Ente';

  @override
  String get thisActionCannotBeUndone =>
      'Cette action ne peut pas être annulée';

  @override
  String get emptyTrash => 'Vider la corbeille ?';

  @override
  String get permDeleteWarning =>
      'Tous les éléments de la corbeille seront définitivement supprimés\n\nCette action ne peut pas être annulée';

  @override
  String get empty => 'Vider';

  @override
  String get couldNotFreeUpSpace => 'Impossible de libérer de l\'espace';

  @override
  String get permanentlyDeleteFromDevice =>
      'Supprimer définitivement de l\'appareil ?';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      'Certains des fichiers que vous essayez de supprimer ne sont disponibles que sur votre appareil et ne peuvent pas être récupérés s\'ils sont supprimés';

  @override
  String get theyWillBeDeletedFromAllAlbums =>
      'Ils seront supprimés de tous les albums.';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'Certains éléments sont à la fois sur Ente et votre appareil.';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      'Les éléments sélectionnés seront supprimés de tous les albums et déplacés dans la corbeille.';

  @override
  String get theseItemsWillBeDeletedFromYourDevice =>
      'Ces éléments seront supprimés de votre appareil.';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      'Il semble qu\'une erreur s\'est produite. Veuillez réessayer après un certain temps. Si l\'erreur persiste, veuillez contacter notre équipe d\'assistance.';

  @override
  String get error => 'Erreur';

  @override
  String get tempErrorContactSupportIfPersists =>
      'Il semble qu\'une erreur s\'est produite. Veuillez réessayer après un certain temps. Si l\'erreur persiste, veuillez contacter notre équipe d\'assistance.';

  @override
  String get networkHostLookUpErr =>
      'Impossible de se connecter à Ente, veuillez vérifier vos paramètres réseau et contacter le support si l\'erreur persiste.';

  @override
  String get networkConnectionRefusedErr =>
      'Impossible de se connecter à Ente, veuillez réessayer après un certain temps. Si l\'erreur persiste, veuillez contacter le support.';

  @override
  String get cachedData => 'Données mises en cache';

  @override
  String get clearCaches => 'Nettoyer le cache';

  @override
  String get remoteImages => 'Images distantes';

  @override
  String get remoteVideos => 'Vidéos distantes';

  @override
  String get remoteThumbnails => 'Miniatures distantes';

  @override
  String get pendingSync => 'Synchronisation en attente';

  @override
  String get localGallery => 'Galerie locale';

  @override
  String get todaysLogs => 'Journaux du jour';

  @override
  String get viewLogs => 'Afficher les journaux';

  @override
  String get logsDialogBody =>
      'Les journaux seront envoyés pour nous aider à déboguer votre problème. Les noms de fichiers seront inclus pour aider à identifier les problèmes.';

  @override
  String get preparingLogs => 'Préparation des journaux...';

  @override
  String get emailYourLogs => 'Envoyez vos journaux par email';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'Envoyez les logs à $toEmail';
  }

  @override
  String get copyEmailAddress => 'Copier l’adresse email';

  @override
  String get exportLogs => 'Exporter les logs';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return 'Merci de nous envoyer un email à $toEmail';
  }

  @override
  String get dismiss => 'Rejeter';

  @override
  String get didYouKnow => 'Le savais-tu ?';

  @override
  String get loadingMessage => 'Chargement de vos photos...';

  @override
  String get loadMessage1 =>
      'Vous pouvez partager votre abonnement avec votre famille';

  @override
  String get loadMessage2 =>
      'Nous avons préservé plus de 200 millions de souvenirs jusqu\'à présent';

  @override
  String get loadMessage3 =>
      'Nous conservons 3 copies de vos données, l\'une dans un abri anti-atomique';

  @override
  String get loadMessage4 => 'Toutes nos applications sont open source';

  @override
  String get loadMessage5 =>
      'Notre code source et notre cryptographie ont été audités en externe';

  @override
  String get loadMessage6 =>
      'Vous pouvez partager des liens vers vos albums avec vos proches';

  @override
  String get loadMessage7 =>
      'Nos applications mobiles s\'exécutent en arrière-plan pour chiffrer et sauvegarder automatiquement les nouvelles photos que vous prenez';

  @override
  String get loadMessage8 =>
      'web.ente.io dispose d\'un outil de téléchargement facile à utiliser';

  @override
  String get loadMessage9 =>
      'Nous utilisons Xchacha20Poly1305 pour chiffrer vos données en toute sécurité';

  @override
  String get photoDescriptions => 'Descriptions de la photo';

  @override
  String get fileTypesAndNames => 'Types et noms de fichiers';

  @override
  String get location => 'Lieu';

  @override
  String get moments => 'Souvenirs';

  @override
  String get searchFaceEmptySection =>
      'Les personnes seront affichées ici une fois l\'indexation terminée';

  @override
  String get searchDatesEmptySection => 'Recherche par date, mois ou année';

  @override
  String get searchLocationEmptySection =>
      'Grouper les photos qui sont prises dans un certain angle d\'une photo';

  @override
  String get searchPeopleEmptySection =>
      'Invitez quelqu\'un·e et vous verrez ici toutes les photos partagées';

  @override
  String get searchAlbumsEmptySection => 'Albums';

  @override
  String get searchFileTypesAndNamesEmptySection => 'Types et noms de fichiers';

  @override
  String get searchCaptionEmptySection =>
      'Ajoutez des descriptions comme \"#trip\" dans les infos photo pour les retrouver ici plus rapidement';

  @override
  String get language => 'Langue';

  @override
  String get selectLanguage => 'Sélectionnez une langue';

  @override
  String get locationName => 'Nom du lieu';

  @override
  String get addLocation => 'Ajouter la localisation';

  @override
  String get groupNearbyPhotos => 'Grouper les photos à proximité';

  @override
  String get kiloMeterUnit => 'km';

  @override
  String get addLocationButton => 'Ajouter';

  @override
  String get radius => 'Rayon';

  @override
  String get locationTagFeatureDescription =>
      'Un tag de lieu regroupe toutes les photos ayant été prises dans un certain rayon d\'une photo';

  @override
  String get galleryMemoryLimitInfo =>
      'Jusqu\'à 1000 souvenirs affichés dans la galerie';

  @override
  String get save => 'Sauvegarder';

  @override
  String get centerPoint => 'Point central';

  @override
  String get pickCenterPoint => 'Choisir le point central';

  @override
  String get useSelectedPhoto => 'Utiliser la photo sélectionnée';

  @override
  String get resetToDefault => 'Réinitialiser aux valeurs par défaut';

  @override
  String get edit => 'Éditer';

  @override
  String get deleteLocation => 'Supprimer la localisation';

  @override
  String get rotateLeft => 'Pivoter à gauche';

  @override
  String get flip => 'Retourner';

  @override
  String get rotateRight => 'Faire pivoter à droite';

  @override
  String get saveCopy => 'Enregistrer une copie';

  @override
  String get light => 'Clair';

  @override
  String get color => 'Couleur ';

  @override
  String get yesDiscardChanges => 'Oui, ignorer les modifications';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade =>
      'Voulez-vous annuler les modifications que vous avez faites ?';

  @override
  String get saving => 'Enregistrement...';

  @override
  String get editsSaved => 'Modification sauvegardée';

  @override
  String get oopsCouldNotSaveEdits =>
      'Oups, impossible d\'enregistrer les modifications';

  @override
  String get distanceInKMUnit => 'km';

  @override
  String get dayToday => 'Aujourd\'hui';

  @override
  String get dayYesterday => 'Hier';

  @override
  String get storage => 'Stockage';

  @override
  String get usedSpace => 'Stockage utilisé';

  @override
  String get storageBreakupFamily => 'Famille';

  @override
  String get storageBreakupYou => 'Vous';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return '$usedAmount $usedStorageUnit sur $totalAmount $totalStorageUnit utilisés';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return '$freeAmount $storageUnit libre';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'Version : $versionValue';
  }

  @override
  String get verifyIDLabel => 'Vérifier';

  @override
  String get fileInfoAddDescHint => 'Ajouter une description...';

  @override
  String get editLocationTagTitle => 'Modifier le lieu';

  @override
  String get setLabel => 'Définir';

  @override
  String get setRadius => 'Définir le rayon';

  @override
  String get familyPlanPortalTitle => 'Famille';

  @override
  String get familyPlanOverview =>
      'Ajoutez 5 membres de votre famille à votre abonnement existant sans payer de supplément.\n\nChaque membre dispose de son propre espace privé et ne peut pas voir les fichiers des autres membres, sauf s\'ils sont partagés.\n\nLes abonnement familiaux sont disponibles pour les clients qui ont un abonnement Ente payant.\n\nAbonnez-vous maintenant pour commencer !';

  @override
  String get androidBiometricHint => 'Vérifier l’identité';

  @override
  String get androidBiometricNotRecognized =>
      'Reconnaissance impossible. Réessayez.';

  @override
  String get androidBiometricSuccess => 'Succès';

  @override
  String get androidCancelButton => 'Annuler';

  @override
  String get androidSignInTitle => 'Authentification requise';

  @override
  String get androidBiometricRequiredTitle => 'Empreinte digitale requise';

  @override
  String get androidDeviceCredentialsRequiredTitle => 'Identifiants requis';

  @override
  String get androidDeviceCredentialsSetupDescription => 'Identifiants requis';

  @override
  String get goToSettings => 'Allez aux réglages';

  @override
  String get androidGoToSettingsDescription =>
      'L\'authentification biométrique n\'est pas configurée sur votre appareil. Allez dans \'Paramètres > Sécurité\' pour ajouter l\'authentification biométrique.';

  @override
  String get iOSLockOut =>
      'L\'authentification biométrique est désactivée. Veuillez verrouiller et déverrouiller votre écran pour l\'activer.';

  @override
  String get iOSGoToSettingsDescription =>
      'L\'authentification biométrique n\'est pas configurée sur votre appareil. Veuillez activer Touch ID ou Face ID sur votre téléphone.';

  @override
  String get iOSOkButton => 'Ok';

  @override
  String get openstreetmapContributors => 'Contributeurs d\'OpenStreetMap';

  @override
  String get hostedAtOsmFrance => 'Hébergé chez OSM France';

  @override
  String get map => 'Carte';

  @override
  String get maps => 'Carte';

  @override
  String get mapsPrivacyNotice =>
      'Les coordonnées approximatives seront envoyées à des tiers soucieux de la vie privée comme OpenStreetMap pour afficher la carte et le lieu.';

  @override
  String get enableMaps => 'Activer la carte';

  @override
  String get quickLinks => 'Liens rapides';

  @override
  String get selectItemsToAdd => 'Sélectionner les éléments à ajouter';

  @override
  String get addSelected => 'Ajouter la sélection';

  @override
  String get addFromDevice => 'Ajouter depuis l\'appareil';

  @override
  String get addPhotos => 'Ajouter des photos';

  @override
  String get noPhotosFoundHere => 'Aucune photo trouvée';

  @override
  String get zoomOutToSeePhotos => 'Zoom en arrière pour voir les photos';

  @override
  String get noImagesWithLocation => 'Aucune image avec localisation';

  @override
  String get unpinAlbum => 'Désépingler l\'album';

  @override
  String get pinAlbum => 'Épingler l\'album';

  @override
  String get pin => 'Épingler';

  @override
  String get pinPerson => 'Épingler une personne';

  @override
  String get pinToTop => 'Épingler en haut';

  @override
  String get unpin => 'Désépingler';

  @override
  String get unpinPerson => 'Désépingler une personne';

  @override
  String get visibility => 'Visibilité';

  @override
  String get hideFromMemories => 'Masquer des souvenirs';

  @override
  String get showInMemories => 'Afficher dans les souvenirs';

  @override
  String get create => 'Créer';

  @override
  String get viewAll => 'Tout afficher';

  @override
  String get nothingSharedWithYouYet =>
      'Rien n\'a encore été partagé avec vous';

  @override
  String get noAlbumsSharedByYouYet => 'Aucun album que vous avez partagé';

  @override
  String get sharedWithYou => 'Partagé avec vous';

  @override
  String get sharedByYou => 'Partagé par vous';

  @override
  String get inviteYourFriendsToEnte => 'Invitez vos ami·e·s sur Ente';

  @override
  String get failedToDownloadVideo => 'Échec du téléchargement de la vidéo';

  @override
  String get hiding => 'Masquage en cours...';

  @override
  String get unhiding => 'Démasquage en cours...';

  @override
  String get successfullyHid => 'Masquage réussi';

  @override
  String get successfullyUnhid => 'Masquage réussi';

  @override
  String get crashReporting => 'Rapport d\'erreur';

  @override
  String get resumableUploads => 'Reprise automatique des transferts';

  @override
  String get addToHiddenAlbum => 'Ajouter à un album masqué';

  @override
  String get moveToHiddenAlbum => 'Déplacer vers un album masqué';

  @override
  String get fileTypes => 'Types de fichiers';

  @override
  String get deleteConfirmDialogBody =>
      'Ce compte est lié à d\'autres applications Ente, si vous en utilisez une. Vos données téléchargées, dans toutes les applications ente, seront planifiées pour suppression, et votre compte sera définitivement supprimé.';

  @override
  String get hearUsWhereTitle =>
      'Comment avez-vous entendu parler de Ente? (facultatif)';

  @override
  String get hearUsExplanation =>
      'Nous ne suivons pas les installations d\'applications. Il serait utile que vous nous disiez comment vous nous avez trouvés !';

  @override
  String get viewAddOnButton => 'Afficher les modules complémentaires';

  @override
  String get addOns => 'Modules complémentaires';

  @override
  String get addOnPageSubtitle => 'Détails des modules complémentaires';

  @override
  String get yourMap => 'Votre carte';

  @override
  String get modifyYourQueryOrTrySearchingFor =>
      'Modifiez votre requête, ou essayez de rechercher';

  @override
  String get blackFridaySale => 'Offre Black Friday';

  @override
  String get upto50OffUntil4thDec =>
      'Jusqu\'à 50% de réduction, jusqu\'au 4ème déc.';

  @override
  String get photos => 'Photos';

  @override
  String get videos => 'Vidéos';

  @override
  String get livePhotos => 'Photos en direct';

  @override
  String get searchHint1 => 'Recherche rapide, sur l\'appareil';

  @override
  String get searchHint2 => 'Dates des photos, descriptions';

  @override
  String get searchHint3 => 'Albums, noms de fichiers et types';

  @override
  String get searchHint4 => 'Lieu';

  @override
  String get searchHint5 => 'Bientôt: Visages & recherche magique ✨';

  @override
  String get addYourPhotosNow => 'Ajoutez vos photos maintenant';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count résultats trouvés',
      one: '$count résultat trouvé',
    );
    return '$_temp0';
  }

  @override
  String get faces => 'Visages';

  @override
  String get people => 'Personnes';

  @override
  String get contents => 'Contenus';

  @override
  String get addNew => 'Ajouter un nouveau';

  @override
  String get contacts => 'Contacts';

  @override
  String get noInternetConnection => 'Aucune connexion internet';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'S\'il vous plaît, vérifiez votre connexion à internet et réessayez.';

  @override
  String get signOutFromOtherDevices => 'Se déconnecter d\'autres appareils';

  @override
  String get signOutOtherBody =>
      'Si vous pensez que quelqu\'un peut connaître votre mot de passe, vous pouvez forcer tous les autres appareils utilisant votre compte à se déconnecter.';

  @override
  String get signOutOtherDevices => 'Déconnecter les autres appareils';

  @override
  String get doNotSignOut => 'Ne pas se déconnecter';

  @override
  String get editLocation => 'Modifier le lieu';

  @override
  String get selectALocation => 'Sélectionnez un lieu';

  @override
  String get selectALocationFirst => 'Sélectionnez d\'abord un lieu';

  @override
  String get changeLocationOfSelectedItems =>
      'Changer la localisation des éléments sélectionnés ?';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte =>
      'Les modifications da localisation ne seront visibles que dans Ente';

  @override
  String get cleanUncategorized => 'Effacer les éléments non classés';

  @override
  String get cleanUncategorizedDescription =>
      'Supprimer tous les fichiers non-catégorisés étant présents dans d\'autres albums';

  @override
  String get waitingForVerification => 'En attente de vérification...';

  @override
  String get passkey =>
      'Authentification à deux facteurs avec une clé de sécurité';

  @override
  String get passkeyAuthTitle => 'Vérification de la clé de sécurité';

  @override
  String get loginWithTOTP => 'Se connecter avec TOTP';

  @override
  String get passKeyPendingVerification =>
      'La vérification est toujours en attente';

  @override
  String get loginSessionExpired => 'Session expirée';

  @override
  String get loginSessionExpiredDetails =>
      'Votre session a expiré. Veuillez vous reconnecter.';

  @override
  String get verifyPasskey => 'Vérifier la clé de sécurité';

  @override
  String get playOnTv => 'Lire l\'album sur la TV';

  @override
  String get pair => 'Associer';

  @override
  String get deviceNotFound => 'Appareil non trouvé';

  @override
  String get castInstruction =>
      'Visitez cast.ente.io sur l\'appareil que vous voulez associer.\n\nEntrez le code ci-dessous pour lire l\'album sur votre TV.';

  @override
  String get deviceCodeHint => 'Saisissez le code';

  @override
  String get joinDiscord => 'Rejoindre Discord';

  @override
  String get locations => 'Lieux';

  @override
  String get addAName => 'Ajouter un nom';

  @override
  String get findThemQuickly => 'Trouvez-les rapidement';

  @override
  String get findPeopleByName =>
      'Trouver des personnes rapidement par leur nom';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Ajouter des spectateurs',
      one: 'Ajouter une spectateur',
      zero: 'Ajouter un spectateur',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Ajouter des collaborateurs',
      one: 'Ajouter un collaborateur',
      zero: 'Ajouter un collaborateur',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      'Appuyez longuement sur un email pour vérifier le chiffrement de bout en bout.';

  @override
  String get developerSettingsWarning =>
      'Êtes-vous sûr de vouloir modifier les paramètres du développeur ?';

  @override
  String get developerSettings => 'Paramètres du développeur';

  @override
  String get serverEndpoint => 'Point de terminaison serveur';

  @override
  String get invalidEndpoint => 'Point de terminaison non valide';

  @override
  String get invalidEndpointMessage =>
      'Désolé, le point de terminaison que vous avez entré n\'est pas valide. Veuillez en entrer un valide puis réessayez.';

  @override
  String get endpointUpdatedMessage =>
      'Point de terminaison mis à jour avec succès';

  @override
  String customEndpoint({required Object endpoint}) {
    return 'Connecté à $endpoint';
  }

  @override
  String get createCollaborativeLink => 'Créer un lien collaboratif';

  @override
  String get search => 'Rechercher';

  @override
  String get enterPersonName => 'Entrez le nom d\'une personne';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'Cet e-mail est déjà lié à $name.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return 'Voir $name pour délier';
  }

  @override
  String get enterName => 'Saisir un nom';

  @override
  String get savePerson => 'Enregistrer la personne';

  @override
  String get editPerson => 'Modifier la personne';

  @override
  String get mergedPhotos => 'Photos fusionnées';

  @override
  String get orMergeWithExistingPerson =>
      'Ou fusionner avec une personne existante';

  @override
  String get enterDateOfBirth => 'Anniversaire (facultatif)';

  @override
  String get birthday => 'Anniversaire';

  @override
  String get removePersonLabel => 'Supprimer le libellé d\'une personne';

  @override
  String get removePersonTag => 'Supprimer le tag d\'une personne';

  @override
  String get areYouSureRemoveThisPersonTag =>
      'Voulez-vous vraiment supprimer le tag de cette personne ?';

  @override
  String get autoPairDesc =>
      'L\'appairage automatique ne fonctionne qu\'avec les appareils qui prennent en charge Chromecast.';

  @override
  String get manualPairDesc =>
      'L\'appairage avec le code PIN fonctionne avec n\'importe quel écran sur lequel vous souhaitez voir votre album.';

  @override
  String get connectToDevice => 'Connexion à l\'appareil';

  @override
  String get autoCastDialogBody =>
      'Vous verrez ici les appareils Cast disponibles.';

  @override
  String get autoCastiOSPermission =>
      'Assurez-vous que les autorisations de réseau local sont activées pour l\'application Ente Photos, dans les paramètres.';

  @override
  String get noDeviceFound => 'Aucun appareil trouvé';

  @override
  String get stopCastingTitle => 'Arrêter la diffusion';

  @override
  String get stopCastingBody => 'Voulez-vous arrêter la diffusion ?';

  @override
  String get castIPMismatchTitle => 'Échec de la diffusion de l\'album';

  @override
  String get castIPMismatchBody =>
      'Veuillez vous assurer que vous êtes sur le même réseau que la TV.';

  @override
  String get pairingComplete => 'Appairage terminé';

  @override
  String get savingEdits => 'Enregistrement des modifications...';

  @override
  String get autoPair => 'Appairage automatique';

  @override
  String get pairWithPin => 'Appairer avec le code PIN';

  @override
  String get faceRecognition => 'Reconnaissance faciale';

  @override
  String get foundFaces => 'Visages trouvés';

  @override
  String get clusteringProgress => 'Progression du regroupement';

  @override
  String get trim => 'Recadrer';

  @override
  String get crop => 'Rogner';

  @override
  String get rotate => 'Pivoter';

  @override
  String get left => 'Gauche';

  @override
  String get right => 'Droite';

  @override
  String get whatsNew => 'Nouveautés';

  @override
  String get reviewSuggestions => 'Examiner les suggestions';

  @override
  String get review => 'Suggestions';

  @override
  String get useAsCover => 'Utiliser comme couverture';

  @override
  String notPersonLabel({required String name}) {
    return 'Pas $name?';
  }

  @override
  String get enable => 'Activer';

  @override
  String get enabled => 'Activé';

  @override
  String get moreDetails => 'Plus de détails';

  @override
  String get enableMLIndexingDesc =>
      'Ente prend en charge l\'apprentissage automatique sur l\'appareil pour la reconnaissance des visages, la recherche magique et d\'autres fonctionnalités de recherche avancée';

  @override
  String get magicSearchHint =>
      'La recherche magique permet de rechercher des photos par leur contenu, par exemple \'fleur\', \'voiture rouge\', \'documents d\'identité\'';

  @override
  String get panorama => 'Panorama';

  @override
  String get reenterPassword => 'Ressaisir le mot de passe';

  @override
  String get reenterPin => 'Ressaisir le code PIN';

  @override
  String get deviceLock => 'Verrouillage par défaut de l\'appareil';

  @override
  String get pinLock => 'Verrouillage par code PIN';

  @override
  String get next => 'Suivant';

  @override
  String get setNewPassword => 'Définir un nouveau mot de passe';

  @override
  String get enterPin => 'Saisir le code PIN';

  @override
  String get setNewPin => 'Définir un nouveau code PIN';

  @override
  String get appLock => 'Verrouillage de l\'application';

  @override
  String get noSystemLockFound => 'Aucun verrou système trouvé';

  @override
  String get tapToUnlock => 'Appuyer pour déverrouiller';

  @override
  String get tooManyIncorrectAttempts => 'Trop de tentatives incorrectes';

  @override
  String get videoInfo => 'Informations vidéo';

  @override
  String get autoLock => 'Verrouillage automatique';

  @override
  String get immediately => 'Immédiatement';

  @override
  String get autoLockFeatureDescription =>
      'Délai après lequel l\'application se verrouille une fois qu\'elle est en arrière-plan';

  @override
  String get hideContent => 'Masquer le contenu';

  @override
  String get hideContentDescriptionAndroid =>
      'Masque le contenu de l\'application dans le sélecteur d\'applications et désactive les captures d\'écran';

  @override
  String get hideContentDescriptionIos =>
      'Masque le contenu de l\'application dans le sélecteur d\'application';

  @override
  String get passwordStrengthInfo =>
      'La force du mot de passe est calculée en tenant compte de la longueur du mot de passe, des caractères utilisés et du fait que le mot de passe figure ou non parmi les 10 000 mots de passe les plus utilisés';

  @override
  String get noQuickLinksSelected => 'Aucun lien rapide sélectionné';

  @override
  String get pleaseSelectQuickLinksToRemove =>
      'Veuillez sélectionner les liens rapides à supprimer';

  @override
  String get removePublicLinks => 'Supprimer les liens publics';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      'Ceci supprimera les liens publics de tous les liens rapides sélectionnés.';

  @override
  String get guestView => 'Vue invité';

  @override
  String get guestViewEnablePreSteps =>
      'Pour activer la vue invité, veuillez configurer le code d\'accès de l\'appareil ou le verrouillage de l\'écran dans les paramètres de votre système.';

  @override
  String get nameTheAlbum => 'Nommez l\'album';

  @override
  String get collectPhotosDescription =>
      'Créez un lien où vos amis peuvent ajouter des photos en qualité originale.';

  @override
  String get collect => 'Récupérer';

  @override
  String get appLockDescriptions =>
      'Choisissez entre l\'écran de verrouillage par défaut de votre appareil et un écran de verrouillage personnalisé avec un code PIN ou un mot de passe.';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'Pour activer le verrouillage de l\'application vous devez configurer le code d\'accès de l\'appareil ou le verrouillage de l\'écran dans les paramètres de votre système.';

  @override
  String get authToViewPasskey =>
      'Veuillez vous authentifier pour afficher votre clé de récupération';

  @override
  String get loopVideoOn => 'Désactiver la lecture en boucle';

  @override
  String get loopVideoOff => 'Activer la lecture en boucle';

  @override
  String get localSyncErrorMessage =>
      'Il semble que quelque chose s\'est mal passé car la synchronisation des photos locales prend plus de temps que prévu. Veuillez contacter notre équipe d\'assistance';

  @override
  String get showPerson => 'Montrer la personne';

  @override
  String get sort => 'Trier';

  @override
  String get mostRecent => 'Les plus récents';

  @override
  String get mostRelevant => 'Les plus pertinents';

  @override
  String get loadingYourPhotos => 'Chargement de vos photos...';

  @override
  String processingImport({required Object folderName}) {
    return 'Traitement de $folderName...';
  }

  @override
  String get personName => 'Nom de la personne';

  @override
  String get addPerson => 'Add person';

  @override
  String get addToPerson => 'Add to person';

  @override
  String get pleaseNamePersonInPeopleSectionFirst =>
      'Please name a person in the People section first';

  @override
  String get onlyUploadedFilesCanBeAddedToPerson =>
      'Only uploaded files can be added to a person';

  @override
  String get noFacesDetectedTapToAdd => 'No faces detected, tap to add.';

  @override
  String addedFilesToPerson({required int count, required String personName}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count files to $personName',
      one: 'Added 1 file to $personName',
    );
    return '$_temp0';
  }

  @override
  String filesAlreadyLinkedToPerson({
    required int count,
    required String personName,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count files are already linked to $personName',
      one: '1 file is already linked to $personName',
    );
    return '$_temp0';
  }

  @override
  String get addNewPerson => 'Ajouter une nouvelle personne';

  @override
  String get addNameOrMerge => 'Ajouter un nom ou fusionner';

  @override
  String get mergeWithExisting => 'Fusionner avec existant';

  @override
  String get newPerson => 'Nouvelle personne';

  @override
  String get addName => 'Ajouter un nom';

  @override
  String get add => 'Ajouter';

  @override
  String extraPhotosFoundFor({required String text}) {
    return 'Photos supplémentaires trouvées pour $text';
  }

  @override
  String get extraPhotosFound => 'Photos supplémentaires trouvées';

  @override
  String get configuration => 'Paramètres';

  @override
  String get localIndexing => 'Indexation locale';

  @override
  String get processed => 'Appris';

  @override
  String get resetPerson => 'Réinitialiser';

  @override
  String get areYouSureYouWantToResetThisPerson =>
      'Êtes-vous certain de vouloir réinitialiser cette personne ?';

  @override
  String get allPersonGroupingWillReset =>
      'Tous les groupements pour cette personne seront réinitialisés, et vous perdrez toutes les suggestions faites pour cette personne';

  @override
  String get yesResetPerson => 'Oui, réinitialiser la personne';

  @override
  String get onlyThem => 'Seulement eux';

  @override
  String get checkingModels => 'Vérification des modèles...';

  @override
  String get enableMachineLearningBanner =>
      'Activer l\'apprentissage automatique pour la reconnaissance des visages et la recherche magique';

  @override
  String get searchDiscoverEmptySection =>
      'Les images seront affichées ici une fois le traitement terminé';

  @override
  String get searchPersonsEmptySection =>
      'Les personnes seront affichées ici une fois le traitement terminé';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count spectateurs ajoutés',
      one: 'Un spectateur ajouté',
      zero: '0 spectateur ajouté',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count collaborateurs ajoutés',
      one: '1 collaborateur ajouté',
      zero: '0 collaborateur ajouté',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured => 'Le compte est déjà configuré.';

  @override
  String get sessionIdMismatch => 'Incompatibilité de l\'ID de session';

  @override
  String get failedToFetchActiveSessions =>
      'Impossible de récupérer les connexions actives';

  @override
  String get failedToRefreshStripeSubscription =>
      'Impossible de rafraîchir l\'abonnement';

  @override
  String get failedToPlayVideo => 'Impossible de lire la vidéo';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return 'L\'envoi est ignoré en raison de $ignoreReason';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'Les galeries de type \'$galleryType\' ne peuvent être renommées';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'Appuyer pour envoyer, l\'envoi est actuellement ignoré en raison de $ignoreReason';
  }

  @override
  String get tapToUpload => 'Appuyer pour envoyer';

  @override
  String get info => 'Info';

  @override
  String get addFiles => 'Ajouter des fichiers';

  @override
  String get castAlbum => 'Caster l\'album';

  @override
  String get imageNotAnalyzed => 'Image non analysée';

  @override
  String get noFacesFound => 'Aucun visage détecté';

  @override
  String get fileNotUploadedYet => 'Le fichier n\'a pas encore été envoyé';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return 'Aucune suggestion pour $personName';
  }

  @override
  String get month => 'mois';

  @override
  String get yearShort => 'an';

  @override
  String get currentlyRunning => 'en cours d\'exécution';

  @override
  String get ignored => 'ignoré';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count photos',
      one: '1 photo',
      zero: '0 photo',
    );
    return '$_temp0';
  }

  @override
  String get file => 'Fichier';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'Incompatibilité de longueur des sections : $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'Sélectionnez l\'application mail';

  @override
  String get selectAllShort => 'Tout';

  @override
  String get selectCoverPhoto => 'Sélectionnez la photo de couverture';

  @override
  String get newLocation => 'Nouvelle localisation';

  @override
  String get faceNotClusteredYet =>
      'Ce visage n\'a pas encore été regroupé, veuillez revenir plus tard';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'Le lien que vous essayez d\'accéder a expiré.';

  @override
  String get openFile => 'Ouvrir le fichier';

  @override
  String get backupFile => 'Sauvegarder le fichier';

  @override
  String get openAlbumInBrowser => 'Ouvrir l\'album dans le navigateur';

  @override
  String get openAlbumInBrowserTitle =>
      'Veuillez utiliser l\'application web pour ajouter des photos à cet album';

  @override
  String get allow => 'Autoriser';

  @override
  String get allowAppToOpenSharedAlbumLinks =>
      'Autoriser l\'application à ouvrir les liens d\'albums partagés';

  @override
  String get seePublicAlbumLinksInApp =>
      'Ouvrir les liens des albums publics dans l\'application';

  @override
  String get emergencyContacts => 'Contacts d\'urgence';

  @override
  String get acceptTrustInvite => 'Accepter l\'invitation';

  @override
  String get declineTrustInvite => 'Refuser l’invitation';

  @override
  String get removeYourselfAsTrustedContact =>
      'Retirez-vous comme contact de confiance';

  @override
  String get legacy => 'Héritage';

  @override
  String get legacyPageDesc =>
      'L\'héritage permet aux contacts de confiance d\'accéder à votre compte en votre absence.';

  @override
  String get legacyPageDesc2 =>
      'Ces contacts peuvent initier la récupération du compte et, s\'ils ne sont pas bloqués dans les 30 jours qui suivent, peuvent réinitialiser votre mot de passe et accéder à votre compte.';

  @override
  String get legacyAccounts => 'Comptes hérités';

  @override
  String get trustedContacts => 'Contacts de confiance';

  @override
  String get addTrustedContact => 'Ajouter un contact de confiance';

  @override
  String get removeInvite => 'Supprimer l’Invitation';

  @override
  String get recoveryWarning =>
      'Un contact de confiance tente d\'accéder à votre compte';

  @override
  String get rejectRecovery => 'Rejeter la récupération';

  @override
  String get recoveryInitiated => 'Récupération initiée';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return 'Vous pourrez accéder au compte d\'ici $days jours. Une notification sera envoyée à $email.';
  }

  @override
  String get cancelAccountRecovery => 'Annuler la récupération';

  @override
  String get recoveryAccount => 'Récupérer un compte';

  @override
  String get cancelAccountRecoveryBody =>
      'Êtes-vous sûr de vouloir annuler la récupération ?';

  @override
  String get startAccountRecoveryTitle => 'Démarrer la récupération';

  @override
  String get whyAddTrustContact =>
      'Un contact de confiance peut vous aider à récupérer vos données.';

  @override
  String recoveryReady({required String email}) {
    return 'Vous pouvez maintenant récupérer le compte de $email en définissant un nouveau mot de passe.';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email tente de récupérer votre compte.';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return 'Vous avez été invité(e) à être un(e) héritier(e) par $email.';
  }

  @override
  String get warning => 'Attention';

  @override
  String get proceed => 'Procéder';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return 'Vous êtes sur le point d\'ajouter $email en tant que contact sûr. Il pourra récupérer votre compte si vous êtes absent pendant $numOfDays jours.';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email vous a invité à être un contact de confiance';
  }

  @override
  String get authToManageLegacy =>
      'Veuillez vous authentifier pour gérer vos contacts de confiance';

  @override
  String get hideSharedItemsFromHomeGallery =>
      'Masquer les éléments partagés avec vous dans la galerie';

  @override
  String get swipeToSelect => 'Balayer pour sélectionner';

  @override
  String get gallery => 'Galerie';

  @override
  String get joinAlbum => 'Rejoindre l\'album';

  @override
  String get joinAlbumSubtext => 'pour afficher et ajouter vos photos';

  @override
  String get joinAlbumSubtextViewer => 'pour ajouter ceci aux albums partagés';

  @override
  String get join => 'Rejoindre';

  @override
  String get linkEmail => 'Lier l\'email';

  @override
  String get link => 'Lier';

  @override
  String get noEnteAccountExclamation => 'Aucun compte Ente !';

  @override
  String get orPickFromYourContacts => 'ou choisissez parmi vos contacts';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return '$email n\'a pas de compte Ente.';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (Moi)';
  }

  @override
  String get reassignMe => 'Réassigner \"Moi\"';

  @override
  String get me => 'Moi';

  @override
  String get linkEmailToContactBannerCaption => 'pour un partage plus rapide';

  @override
  String get selectPersonToLink => 'Sélectionnez la personne à associer';

  @override
  String linkPersonToEmail({required String email}) {
    return 'Associer la personne à $email';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return 'Cela va associer $personName à $email';
  }

  @override
  String get selectYourFace => 'Sélectionnez votre visage';

  @override
  String get reassigningLoading => 'Réassignation...';

  @override
  String reassignedToName({required String name}) {
    return 'Vous a réassigné à $name';
  }

  @override
  String get saveChangesBeforeLeavingQuestion =>
      'Enregistrer les modifications avant de quitter ?';

  @override
  String get dontSave => 'Ne pas enregistrer';

  @override
  String get thisIsMeExclamation => 'C\'est moi !';

  @override
  String get linkPerson => 'Lier la personne';

  @override
  String get linkPersonCaption => 'pour une meilleure expérience de partage';

  @override
  String get videoStreaming => 'Vidéos diffusables';

  @override
  String get processingVideos => 'Traitement des vidéos';

  @override
  String get streamDetails => 'Détails du stream';

  @override
  String get processing => 'Traitement en cours';

  @override
  String get queued => 'En file d\'attente';

  @override
  String get ineligible => 'Non compatible';

  @override
  String get failed => 'Échec';

  @override
  String get playStream => 'Lire le stream';

  @override
  String get playOriginal => 'Lire l\'original';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'Rejoindre un album rendra votre e-mail visible à ses participants.';

  @override
  String get pleaseWaitThisWillTakeAWhile =>
      'Veuillez patienter, cela prendra un peu de temps.';

  @override
  String get editTime => 'Modifier l\'heure';

  @override
  String get selectTime => 'Sélectionner l\'heure';

  @override
  String get selectDate => 'Sélectionner la date';

  @override
  String get previous => 'Précédent';

  @override
  String get selectOneDateAndTimeForAll =>
      'Sélectionnez une date et une heure pour tous';

  @override
  String get selectStartOfRange => 'Sélectionner le début de la plage';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      'Cela rendra la date et l\'heure identique à toutes les photos sélectionnées.';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'C\'est la première dans le groupe. Les autres photos sélectionnées se déplaceront automatiquement en fonction de cette nouvelle date';

  @override
  String get newRange => 'Nouvelle plage';

  @override
  String get selectOneDateAndTime => 'Sélectionner une date et une heure';

  @override
  String get moveSelectedPhotosToOneDate =>
      'Déplacer les photos sélectionnées vers une date';

  @override
  String get shiftDatesAndTime => 'Dates et heure de décalage';

  @override
  String get photosKeepRelativeTimeDifference =>
      'Les photos gardent une différence de temps relative';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count photos',
      one: '1 photo',
      zero: 'No photos',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'Icône de l\'appli';

  @override
  String get notThisPerson => 'Ce n\'est pas cette personne ?';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      'Les éléments sélectionnés seront retirés de cette personne, mais pas supprimés de votre bibliothèque.';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat au fil des années';
  }

  @override
  String get thisWeekThroughTheYears => 'Cette semaine au fil des années';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Cette semaine, $count il y a des années',
      one: 'Cette semaine, $count il y a l\'année',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'Vous et $name';
  }

  @override
  String admiringThem({required Object name}) {
    return 'Admirant $name';
  }

  @override
  String embracingThem({required Object name}) {
    return 'Embrasse $name';
  }

  @override
  String partyWithThem({required Object name}) {
    return 'En soirée avec $name';
  }

  @override
  String hikingWithThem({required Object name}) {
    return 'Randonnée avec $name';
  }

  @override
  String feastingWithThem({required Object name}) {
    return 'Fête avec $name';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return 'Selfies avec $name';
  }

  @override
  String posingWithThem({required Object name}) {
    return 'Pose avec $name';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return 'Magnifiques vues avec $name';
  }

  @override
  String sportsWithThem({required Object name}) {
    return 'Sports avec $name';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return 'En route avec $name';
  }

  @override
  String get spotlightOnYourself => 'Éclairage sur vous-même';

  @override
  String spotlightOnThem({required Object name}) {
    return 'Spotlight sur $name';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$name a $age!';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name aura bientôt $age';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return 'Dernière fois avec $name';
  }

  @override
  String tripToLocation({required Object location}) {
    return 'Voyage vers $location';
  }

  @override
  String tripInYear({required Object year}) {
    return 'Voyage en $year';
  }

  @override
  String get lastYearsTrip => 'Voyage de l\'an dernier';

  @override
  String get sunrise => 'À l\'horizon';

  @override
  String get mountains => 'Au-dessus des collines';

  @override
  String get greenery => 'La vie au vert';

  @override
  String get beach => 'Sable et mer';

  @override
  String get city => 'Dans la ville';

  @override
  String get moon => 'Au clair de lune';

  @override
  String get onTheRoad => 'De nouveau sur la route';

  @override
  String get food => 'Plaisir culinaire';

  @override
  String get pets => 'Compagnons à quatre pattes';

  @override
  String get curatedMemories => 'Souvenirs conservés';

  @override
  String get widgets => 'Widgets';

  @override
  String get memories => 'Souvenirs';

  @override
  String get peopleWidgetDesc =>
      'Sélectionnez les personnes que vous souhaitez voir sur votre écran d\'accueil.';

  @override
  String get albumsWidgetDesc =>
      'Sélectionnez les personnes que vous souhaitez voir sur votre écran d\'accueil.';

  @override
  String get memoriesWidgetDesc =>
      'Sélectionnez le type de souvenirs que vous souhaitez voir sur votre écran d\'accueil.';

  @override
  String get smartMemories => 'Souvenirs intelligents';

  @override
  String get pastYearsMemories => 'Souvenirs de ces dernières années';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return 'Supprimer aussi les photos (et les vidéos) présentes dans $count album(s) depuis <bold>tous les autres</bold> albums dont ils font partie ?';
  }

  @override
  String get addParticipants => 'Ajouter des participants';

  @override
  String selectedAlbums({required Object count}) {
    return '$count sélectionné(s)';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'Action non prise en charge sur l\'album des Favoris';

  @override
  String get onThisDayMemories => 'Souvenirs du jour';

  @override
  String get onThisDay => 'Ce jour-ci';

  @override
  String get lookBackOnYourMemories => 'Regarde tes souvenirs passés 🌄';

  @override
  String get newPhotosEmoji => ' nouveau 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'Désolé, nous avons dû mettre en pause vos sauvegardes';

  @override
  String get clickToInstallOurBestVersionYet =>
      'Cliquez pour installer notre meilleure version';

  @override
  String get onThisDayNotificationExplanation =>
      'Recevoir des rappels sur les souvenirs de cette journée des années précédentes.';

  @override
  String get addMemoriesWidgetPrompt =>
      'Ajoutez un widget des souvenirs à votre écran d\'accueil et revenez ici pour le personnaliser.';

  @override
  String get addAlbumWidgetPrompt =>
      'Ajoutez un widget d\'album à votre écran d\'accueil et revenez ici pour le personnaliser.';

  @override
  String get addPeopleWidgetPrompt =>
      'Ajoutez un widget des personnes à votre écran d\'accueil et revenez ici pour le personnaliser.';

  @override
  String get birthdayNotifications => 'Notifications d’anniversaire';

  @override
  String get receiveRemindersOnBirthdays =>
      'Recevoir des rappels quand c\'est l\'anniversaire de quelqu\'un. Appuyer sur la notification vous amènera à des photos de son anniversaire.';

  @override
  String get happyBirthday => 'Joyeux anniversaire ! 🥳';

  @override
  String get birthdays => 'Anniversaires';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return 'Souhaitez à $name un joyeux anniversaire ! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      'Êtes-vous sûr de vouloir retirer ce visage de cette personne ?';

  @override
  String get otherDetectedFaces => 'Autres visages détectés';

  @override
  String get areThey => 'S\'agit-il de ';

  @override
  String get questionmark => '?';

  @override
  String get saveAsAnotherPerson => 'Enregistrer comme une autre personne';

  @override
  String get showLessFaces => 'Afficher moins de visages';

  @override
  String get showMoreFaces => 'Afficher plus de visages';

  @override
  String get ignore => 'Ignorer';

  @override
  String get merge => 'Fusionner';

  @override
  String get reset => 'Réinitialiser';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      'Êtes-vous sûr de vouloir ignorer cette personne ?';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      'Êtes-vous sûr de vouloir ignorer ces personnes ?';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'Les groupes de personnes ne seront plus affichés dans la section personnes. Les photos resteront intactes.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'Les groupes de personnes ne seront plus affichés dans la section personnes. Les photos resteront intactes.';

  @override
  String get areYouSureYouWantToMergeThem =>
      'Êtes-vous sûr de vouloir les fusionner?';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'Tous les groupes sans nom seront fusionnés dans la personne sélectionnée. Cela peut toujours être annulé à partir de l\'historique des suggestions de la personne.';

  @override
  String get yesIgnore => 'Oui, ignorer';

  @override
  String get same => 'Identique';

  @override
  String get different => 'Différent(e)';

  @override
  String get sameperson => 'Même personne ?';

  @override
  String get indexingPausedStatusDescription =>
      'L\'indexation est en pause. Elle reprendra automatiquement lorsque l\'appareil sera prêt. Celui-ci est considéré comme prêt lorsque le niveau de batterie, sa santé et son état thermique sont dans une plage saine.';

  @override
  String get thisWeek => 'Cette semaine';

  @override
  String get lastWeek => 'La semaine dernière';

  @override
  String get thisMonth => 'Ce mois';

  @override
  String get thisYear => 'Cette année';

  @override
  String get groupBy => 'Grouper par';

  @override
  String get faceThumbnailGenerationFailed =>
      'Impossible de créer des miniatures de visage';

  @override
  String get fileAnalysisFailed => 'Impossible d\'analyser le fichier';

  @override
  String get editAutoAddPeople => 'Modifier les personnes auto-ajoutées';

  @override
  String get autoAddPeople => 'Ajouter automatiquement des personnes';

  @override
  String get autoAddToAlbum => 'Ajouter automatiquement à l\'album';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      'Les fichiers liés à la personne qui ont été précédemment sélectionnés dans les albums intelligents doivent-ils être supprimés ?';

  @override
  String get addingPhotos => 'Ajout des photos';

  @override
  String get gettingReady => 'Préparation';

  @override
  String get addSomePhotosDesc1 => 'Ajoutez quelques photos ou choisissez des ';

  @override
  String get addSomePhotosDesc2 => 'visages familiers';

  @override
  String get addSomePhotosDesc3 => '\npour commencer';

  @override
  String get ignorePerson => 'Ignorer la personne';

  @override
  String get mixedGrouping => 'Plusieurs personnes?';

  @override
  String get analysis => 'Analyse';

  @override
  String get doesGroupContainMultiplePeople =>
      'Ce groupement contient-il plusieurs personnes ?';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'Nous analyserons automatiquement le regroupement pour déterminer s\'il y a plusieurs personnes présentes et nous les séparerons à nouveau si tel est le cas. Cela peut prendre quelques secondes.';

  @override
  String get layout => 'Disposition';

  @override
  String get day => 'Jour';

  @override
  String get undo => 'Annuler';

  @override
  String get redo => 'Rétablir';

  @override
  String get filter => 'Filtres';

  @override
  String get adjust => 'Ajuster';

  @override
  String get draw => 'Dessiner';

  @override
  String get sticker => 'Autocollant';

  @override
  String get brushColor => 'Couleur du pinceau';

  @override
  String get font => 'Police';

  @override
  String get background => 'Arrière-plan';

  @override
  String get align => 'Aligner';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Ajouté avec succès à $count albums',
      one: 'Ajouté avec succès à 1 album',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => 'Vidéos traitées';

  @override
  String get totalVideos => 'Total de vidéos';

  @override
  String get skippedVideos => 'Vidéos ignorées';

  @override
  String get videoStreamingDescriptionLine1 =>
      'Lire instantanément des vidéos sur n\'importe quel appareil.';

  @override
  String get videoStreamingDescriptionLine2 =>
      'Activer pour traiter les flux vidéo sur cet appareil.';

  @override
  String get videoStreamingNote =>
      'Seules les vidéos des 60 derniers jours et de moins d\'une minute sont traitées sur cet appareil. Pour les vidéos plus anciennes/plus longues, activez le streaming dans l\'application pour ordinateur.';

  @override
  String get createStream => 'Créer le flux';

  @override
  String get recreateStream => 'Recréer le flux';

  @override
  String get addedToStreamCreationQueue =>
      'Ajouté à la file d\'attente de création de flux';

  @override
  String get addedToStreamRecreationQueue =>
      'Ajouté à la file d\'attente de re-création de flux';

  @override
  String get videoPreviewAlreadyExists => 'L\'aperçu vidéo existe déjà';

  @override
  String get videoAlreadyInQueue =>
      'Fichier vidéo déjà présent dans la file d\'attente';

  @override
  String get videoExportFailed =>
      'Échec de la création de la vidéo. Veuillez réessayer.';

  @override
  String videoExportSuccess({required String path}) {
    return 'Vidéo créée avec succès à $path';
  }

  @override
  String get addedToQueue => 'Ajouté à la file d\'attente';

  @override
  String get creatingStream => 'Création du flux';

  @override
  String get similarImages => 'Images similaires';

  @override
  String get findSimilarImages => 'Rechercher des images similaires';

  @override
  String get noSimilarImagesFound => 'Aucune image similaire trouvée';

  @override
  String get yourPhotosLookUnique => 'Vos photos semblent uniques';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count groupes trouvés',
      one: '$count groupe trouvé',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages =>
      'Examiner et supprimer les images similaires';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return 'Supprimer $count photos ($size)';
  }

  @override
  String get selectionOptions => 'Options de sélection';

  @override
  String selectExactWithCount({required int count}) {
    return 'Exactement similaire ($count)';
  }

  @override
  String get selectExact => 'Sélectionner exactement';

  @override
  String selectSimilarWithCount({required int count}) {
    return 'Plutôt similaire ($count)';
  }

  @override
  String get selectSimilar => 'Sélectionner à l\'identique';

  @override
  String selectAllWithCount({required int count}) {
    return 'Toutes les similarités ($count)';
  }

  @override
  String get selectSimilarImagesTitle => 'Sélectionner les images similaires';

  @override
  String get chooseSimilarImagesToSelect =>
      'Sélectionnez des images en fonction de leur similitude visuelle';

  @override
  String get clearSelection => 'Effacer la sélection';

  @override
  String similarImagesCount({required int count}) {
    return '$count images similaires';
  }

  @override
  String deleteWithCount({required int count}) {
    return 'Supprimer ($count)';
  }

  @override
  String get deleteFiles => 'Supprimer les fichiers';

  @override
  String get areYouSureDeleteFiles =>
      'Êtes-vous sûr de vouloir supprimer ces fichiers ?';

  @override
  String get greatJob => 'Excellent !';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return 'Vous avez libéré $size d\'espace';
  }

  @override
  String get size => 'Taille';

  @override
  String get similarity => 'Similitude';

  @override
  String get analyzingPhotosLocally => 'Analyse de vos photos en local ...';

  @override
  String get lookingForVisualSimilarities =>
      'Recherche de ressemblances visuelles...';

  @override
  String get comparingImageDetails => 'Comparaison des détails de l\'image...';

  @override
  String get findingSimilarImages => 'Recherche d\'images similaires...';

  @override
  String get almostDone => 'C\'est presque terminé...';

  @override
  String get processingLocally => 'Traitement local';

  @override
  String get useMLToFindSimilarImages =>
      'Examinez et supprimez les images qui se ressemblent entre elles.';

  @override
  String get all => 'Toutes';

  @override
  String get similar => 'Similaires';

  @override
  String get identical => 'Identiques';

  @override
  String get nothingHereTryAnotherFilter =>
      'Rien ici, essayez un autre filtre ! 👀';

  @override
  String get related => 'Liés';

  @override
  String get hoorayyyy => 'Houraaa !';

  @override
  String get nothingToTidyUpHere => 'Rien à nettoyer ici';

  @override
  String get deletingDash => 'Suppression - ';

  @override
  String get cLTitle1 => 'Présentation des Rituels';

  @override
  String get cLDesc1 =>
      'Vous préparez des résolutions pour 2026 ? Avec Rituels, vous pouvez définir un rappel sur Ente Photos et suivre vos progrès en prenant des photos. Utilisez-le pour les entraînements, les habitudes alimentaires, les moments quotidiens avec vos proches – tout ce que vous voulez transformer en habitude.';

  @override
  String get cLTitle2 => 'Liens publics, maintenant pour tous';

  @override
  String get cLDesc2 =>
      'Tous les utilisateurs Ente sur le plan gratuit peuvent désormais créer et partager des liens publics vers des photos et des albums. Pour prévenir les abus, les liens auront des limites sur le nombre de personnes pouvant les consulter.';

  @override
  String get cLTitle3 => 'Taguer manuellement des personnes';

  @override
  String get cLDesc3 =>
      'Vous pouvez maintenant taguer des personnes même quand notre IA embarquée ne détecte pas de visage. Pratique pour les animaux de compagnie, les visages partiellement visibles, ou les moments où quelqu\'un n\'est pas vraiment sur la photo mais devrait quand même y être inclus.';

  @override
  String get cLTitle4 => 'Et plus encore';

  @override
  String get cLDesc4 =>
      'Vous pouvez maintenant épingler des albums partagés. Les liens d\'albums sont visibles pour les collaborateurs et les spectateurs pour faciliter encore plus le partage. Nous avons corrigé quelques bugs de balayage iOS et mis à jour la vue photo, y compris une nouvelle icône de favori (préparant la place pour les fonctionnalités à venir).';

  @override
  String get closeBy => 'Similaire';

  @override
  String get peopleAutoAddDesc =>
      'Ajouter automatiquement les photos des personnes sélectionnées à cet album';

  @override
  String get festivities => 'Remerciements festifs';

  @override
  String get snowAdventures => 'Aventures d\'hiver';

  @override
  String get waterfalls => 'Chasse aux chutes d\'eau';

  @override
  String get wildlife => 'Dans la nature';

  @override
  String get flowers => 'Beautés florissantes';

  @override
  String get nightLights => 'Soirées néon';

  @override
  String get architecture => 'Icônes design';

  @override
  String get autumnColors => 'Splendeur de l\'Automne';

  @override
  String get desertDreams => 'Rêves désertiques';

  @override
  String get stargazing => 'Sous les étoiles';

  @override
  String get lakeside => 'Calme du lac';

  @override
  String get rainyDays => 'Sentiment de jour pluvieux';

  @override
  String get sportsAction => 'Partie active';

  @override
  String get streetArt => 'Histoires d\'art de la rue';

  @override
  String get familyMoments => 'Moment en famille';

  @override
  String get fireworks => 'Grand final de feux d\'artifices';

  @override
  String get historicSites => 'Échos de l\'histoire';

  @override
  String get tropicalParadise => 'Évasions tropicales';

  @override
  String get forestTrails => 'Promenades en forêt';

  @override
  String get citySunsets => 'Coucher du soleil en ville';

  @override
  String get colorfulMarkets => 'Marchés animés';

  @override
  String get cozyCafes => 'Coins de café confortables';

  @override
  String get vintageVibes => 'Vibes « vintage »';

  @override
  String get aerialViews => 'Perspectives aériennes';

  @override
  String get artisticPortraits => 'Portraits joyeux';

  @override
  String get streetFood => 'Bouchés de la bouffe';

  @override
  String get riverCruises => 'Vue sur le fleuve';

  @override
  String get facesTimelineBannerTitle => 'Souvenirs';

  @override
  String facesTimelineBannerSubtitle({required String name}) {
    return 'Voir les photos de ${name}au fil des années';
  }

  @override
  String get facesTimelineAppBarTitle => 'Souvenirs';

  @override
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ans',
      one: '$count an',
    );
    return '$name avait $_temp0';
  }

  @override
  String facesTimelineCaptionYearsAgo({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '# ans plus tôt',
      one: '# an plus tôt',
    );
    return '$_temp0';
  }

  @override
  String get facesTimelineShareComingSoon =>
      'Le partage de vidéos arrive bientôt';

  @override
  String get facesTimelinePlaybackPrevious => 'Précédent';

  @override
  String get facesTimelinePlaybackNext => 'Suivant';

  @override
  String get facesTimelinePlaybackPlay => 'Lecture';

  @override
  String get facesTimelinePlaybackPause => 'Pause';

  @override
  String get facesTimelineUnavailable =>
      'L\'historique des visages est en préparation...';

  @override
  String get playfulKids => 'Enfants amusants';

  @override
  String get coastalCliffs => 'Falaises au bord de mer';

  @override
  String get ritualsTitle => 'Routines';

  @override
  String get ritualAddTooltip => 'Ajouter une routine';

  @override
  String get ritualActivityHeading => 'Activité';

  @override
  String get ritualDefaultHeatmapTitle => 'Prendre une photo chaque jour';

  @override
  String get ritualUntitled => 'Routine sans titre';

  @override
  String get ritualShareUnavailable =>
      'Impossible de partager pour le moment. Veuillez réessayer.';

  @override
  String get ritualNotificationMessage => 'Prendre une photo maintenant';

  @override
  String get ritualCameraNotFound => 'Aucune caméra trouvée sur cet appareil.';

  @override
  String get ritualCameraStartError =>
      'Impossible de démarrer la caméra. Veuillez vérifier les autorisations.';

  @override
  String get ritualCaptureError =>
      'Impossible de prendre la photo. Veuillez réessayer.';

  @override
  String ritualPhotoLimit({required int maxPhotos}) {
    String _temp0 = intl.Intl.pluralLogic(
      maxPhotos,
      locale: localeName,
      other: '# photos.',
      one: '# photo.',
    );
    return 'Vous pouvez ajouter jusqu\'à $_temp0';
  }

  @override
  String get ritualCaptureAtLeastOne => 'Prenez au moins une photo d\'abord.';

  @override
  String get ritualAlbumMissing =>
      'Routine d\'album manquante. Modifiez-la pour définir un album.';

  @override
  String get ritualAddedToAlbum => 'Ajouté à l\'album';

  @override
  String ritualAddedToAlbumWithName({required String albumName}) {
    return 'Ajouté à $albumName';
  }

  @override
  String ritualAddToAlbumFailure({required String error}) {
    return 'Échec lors de l\'ajout des photos à l\'album : $error';
  }

  @override
  String get ritualBackToList => 'Retour aux routines';

  @override
  String get ritualNoPhotosYet => 'Aucune photo pour l\'instant';

  @override
  String get ritualSetAlbumToLaunchCamera =>
      'Définissez un album pour que cette routine lance la caméra.';

  @override
  String get ritualDefaultCameraTitle => 'Prendre une photo';

  @override
  String get ritualBadgeMessage7 =>
      '7 jours passé ! La régularité semble bonne pour vous. Continuez !';

  @override
  String get ritualBadgeMessage14 =>
      '14 jours plus tard ! Votre routine devient une habitude. Incroyable !';

  @override
  String get ritualBadgeMessage30 =>
      '30 jours de suite ! Régularité légendaire. Prends un arc !';

  @override
  String get ritualBadgeMessageDefault => 'Vous êtes bien parti !';

  @override
  String get ritualBadgeNewTitle => 'Nouveau succès';

  @override
  String get ritualBadgePreparing => 'Préparation...';

  @override
  String get ritualStreaksLabel => 'Séries';

  @override
  String get ritualCreateYourOwn => 'Créez votre propre routine';

  @override
  String get ritualGetDailyReminders => 'Recevez des rappels quotidiens';

  @override
  String get ritualAlbumNotSet => 'Album non configuré';

  @override
  String get ritualOpenCameraTooltip => 'Ouvrir la routine caméra';

  @override
  String get ritualEditorLabel => 'Éditeur de routine';

  @override
  String get ritualNew => 'Nouvelle routine';

  @override
  String get ritualCreateNewTitle => 'Create new ritual';

  @override
  String get ritualEdit => 'Modifier la routine';

  @override
  String get ritualEnterPrompt => 'Saisissez votre routine';

  @override
  String get ritualEnterDescription => 'Veuillez saisir une description';

  @override
  String get ritualChooseDaysLabel => 'Choose days for ritual';

  @override
  String get ritualDayLabel => 'Jour';

  @override
  String get ritualNotificationsOffHint =>
      'Les notifications sont désactivées. Appuyez sur un jour pour les activer.';

  @override
  String get ritualTimeLabel => 'Date et heure';

  @override
  String get ritualAlbumLabel => 'Album';

  @override
  String get ritualSave => 'Enregistrer la routine';

  @override
  String get ritualCreateAction => 'Create ritual';

  @override
  String get ritualUpdate => 'Mettre à jour la routine';

  @override
  String get ritualSelectAlbumTitle => 'Sélectionner un album';

  @override
  String get ritualChooseAlbumLabel => 'Choose an album';

  @override
  String get ritualSendReminderLabel => 'Send reminder';

  @override
  String get ritualSearchOrCreate => 'Rechercher ou créer un nouveau';

  @override
  String get ritualNoAlbumsYet => 'Pas encore d\'albums';

  @override
  String get ritualNoMatchingAlbums => 'Aucuns albums correspondants';

  @override
  String ritualCreateAlbumWithName({required String albumName}) {
    return 'Créer \"$albumName\"';
  }

  @override
  String get ritualCreateNew => 'Créer un nouveau';

  @override
  String get ritualAlbumSelectionPlaceholder => 'Sélectionner un album';

  @override
  String get ritualPickEmojiTitle => 'Choisir un émoji';

  @override
  String get ritualCustomKeyboardLabel => 'Personnalisé (clavier)';

  @override
  String get ritualEmojiKeyboardHint => 'Appuyez pour ouvrir le clavier emoji';

  @override
  String get ritualEmojiUseAction => 'Utiliser';

  @override
  String get ritualSearchEmpty =>
      'Construisez un rituel pour garder votre habitude de photographie.';
}
