// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Basque (`eu`).
class AppLocalizationsEu extends AppLocalizations {
  AppLocalizationsEu([String locale = 'eu']) : super(locale);

  @override
  String get enterYourEmailAddress => 'Sartu zure helbide elektronikoa';

  @override
  String get enterYourNewEmailAddress => 'Enter your new email address';

  @override
  String get accountWelcomeBack => 'Ongi etorri berriro!';

  @override
  String get emailAlreadyRegistered =>
      'Helbide hau badago erregistratuta lehendik.';

  @override
  String get emailNotRegistered => 'Helbide hau ez dago erregistratuta.';

  @override
  String get email => 'E-maila';

  @override
  String get cancel => 'Utzi';

  @override
  String get verify => 'Egiaztatu';

  @override
  String get invalidEmailAddress => 'Helbide hau ez da zuzena';

  @override
  String get enterValidEmail => 'Mesedez, sartu zuzena den helbidea.';

  @override
  String get deleteAccount => 'Ezabatu zure kontua';

  @override
  String get deleteAccountWarning =>
      'This will delete your Ente Auth, Ente Photos and Ente Locker account.';

  @override
  String get askDeleteReason =>
      'Zein da zure kontua ezabatzeko arrazoi nagusia?';

  @override
  String get deleteAccountFeedbackPrompt =>
      'Sentitzen dugu zu joateaz. Mesedez, utziguzu zure feedbacka hobetzen laguntzeko.';

  @override
  String get feedback => 'Feedbacka';

  @override
  String get kindlyHelpUsWithThisInformation =>
      'Mesedez, lagun gaitzazu informazio honekin';

  @override
  String get confirmDeletePrompt =>
      'Bai, betiko ezabatu nahi dut kontu hau eta berarekiko data aplikazio guztietan zehar.';

  @override
  String get confirmAccountDeletion => 'Baieztatu Kontu Ezabaketa';

  @override
  String get deleteAccountPermanentlyButton => 'Ezabatu Kontua Betiko';

  @override
  String get yourAccountHasBeenDeleted => 'Zure kontua ezabatua izan da';

  @override
  String get selectReason => 'Aukeratu arrazoia';

  @override
  String get deleteReason1 => 'Behar dudan ezaugarre nagusiren bat falta zaio';

  @override
  String get deleteReason2 =>
      'Aplikazioak edo ezaugarriren batek ez du funtzionatzen nik espero nuenez';

  @override
  String get deleteReason3 => 'Gustukoago dudan beste zerbitzu bat aurkitu dut';

  @override
  String get deleteReason4 => 'Nire arrazoia ez dago zerrendan';

  @override
  String get sendEmail => 'Bidali mezua';

  @override
  String get deleteRequestSLAText =>
      'Zure eskaera 72 ordutan prozesatua izango da.';

  @override
  String get deleteEmailRequest =>
      'Mesedez, bidali e-mail bat <warning>account-deletion@ente.io</warning> helbidea zure erregistatutako helbidetik.';

  @override
  String get entePhotosPerm =>
      'Ente-k <i>zure baimena behar du</i> zure argazkiak gordetzeko';

  @override
  String get ok => 'Ondo';

  @override
  String get createAccount => 'Sortu kontua';

  @override
  String get createNewAccount => 'Sortu kontu berria';

  @override
  String get password => 'Pasahitza';

  @override
  String get confirmPassword => 'Egiaztatu pasahitza';

  @override
  String get activeSessions => 'Saio aktiboak';

  @override
  String get ocrProcessingOverlayMessage => 'Detecting text...';

  @override
  String get ocrLoadingIndicatorLabel => 'Detecting Text';

  @override
  String get ocrSelectionHint =>
      'Swipe or double tap to select just what you need';

  @override
  String get ocrNoTextDetected => 'No text detected';

  @override
  String get ocrRetryButtonLabel => 'Retry';

  @override
  String get ocrModelsNetworkRequiredError =>
      'Network connection required to download OCR models on first use';

  @override
  String get ocrModelsPrepareFailed => 'Could not prepare OCR models';

  @override
  String get ocrImageNotFoundError => 'Image file not found';

  @override
  String get ocrImageDecodeFailedError => 'Could not read image file';

  @override
  String get ocrGenericDetectError => 'Could not detect text in image';

  @override
  String get oops => 'Ai!';

  @override
  String get somethingWentWrongPleaseTryAgain =>
      'Zerbait ez da ondo joan, mesedez, saiatu berriro';

  @override
  String get thisWillLogYouOutOfThisDevice =>
      'Hau egiteak gailu honetatik aterako zaitu!';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice =>
      'Hau egiteak hurrengo gailutik aterako zaitu:';

  @override
  String get terminateSession => 'Saioa bukatu?';

  @override
  String get terminate => 'Bukatu';

  @override
  String get thisDevice => 'Gailu hau';

  @override
  String get recoverButton => 'Berreskuratu';

  @override
  String get recoverySuccessful => 'Berreskurapen arrakastatsua!';

  @override
  String get decrypting => 'Deszifratzen...';

  @override
  String get incorrectRecoveryKeyTitle => 'Berreskuratze giltza ez da zuzena';

  @override
  String get incorrectRecoveryKeyBody =>
      'Sartu duzun berreskuratze giltza ez da zuzena';

  @override
  String get forgotPassword => 'Ahaztu pasahitza';

  @override
  String get enterYourRecoveryKey => 'Sartu zure berreskuratze giltza';

  @override
  String get noRecoveryKey => 'Berreskuratze giltzarik ez?';

  @override
  String get sorry => 'Barkatu';

  @override
  String get noRecoveryKeyNoDecryption =>
      'Gure puntutik-puntura zifratze protokoloa dela eta, zure data ezin da deszifratu zure pasahitza edo berreskuratze giltzarik gabe';

  @override
  String get verifyEmail => 'Egiaztatu e-maila';

  @override
  String get toResetVerifyEmail =>
      'Zure pasahitza berrezartzeko, mesedez egiaztatu zure e-maila lehenengoz.';

  @override
  String get checkInboxAndSpamFolder =>
      'Mesedez, aztertu zure inbox (eta spam) karpetak egiaztatzea osotzeko';

  @override
  String get tapToEnterCode => 'Klikatu kodea sartzeko';

  @override
  String get resendEmail => 'Birbidali e-maila';

  @override
  String weHaveSendEmailTo({required String email}) {
    return 'Mezua bidali dugu <green>$email</green> helbidera';
  }

  @override
  String get setPasswordTitle => 'Ezarri pasahitza';

  @override
  String get changePasswordTitle => 'Aldatu pasahitza';

  @override
  String get resetPasswordTitle => 'Berrezarri pasahitza';

  @override
  String get encryptionKeys => 'Zifratze giltzak';

  @override
  String get passwordWarning =>
      'Ezin dugu zure pasahitza gorde, beraz, ahazten baduzu, <underline>ezin dugu zure data deszifratu</underline>';

  @override
  String get enterPasswordToEncrypt =>
      'Sartu pasahitz bat, zure data deszifratu ahal izateko';

  @override
  String get enterNewPasswordToEncrypt =>
      'Sartu pasahitz berri bat, zure data zifratu ahal izateko';

  @override
  String get weakStrength => 'Ahula';

  @override
  String get strongStrength => 'Gogorra';

  @override
  String get moderateStrength => 'Ertaina';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'Pasahitzaren indarra: $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully => 'Pasahitza zuzenki aldatuta';

  @override
  String get generatingEncryptionKeys => 'Zifratze giltzak sortzen...';

  @override
  String get pleaseWait => 'Mesedez, itxaron...';

  @override
  String get continueLabel => 'Jarraitu';

  @override
  String get insecureDevice => 'Gailua ez da segurua';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'Tamalez, ezin dugu giltza segururik sortu gailu honetan. \n\nMesedez, eman izena beste gailu batetik.';

  @override
  String get howItWorks => 'Nola funtzionatzen duen';

  @override
  String get encryption => 'Zifratzea';

  @override
  String get ackPasswordLostWarning =>
      'Nire datuak <underline>puntutik puntura zifratuta</underline> daudenez, pasahitza ahaztuz gero nire datuak gal ditzakedala ulertzen dut.';

  @override
  String get privacyPolicyTitle => 'Pribatutasun Politikak';

  @override
  String get termsOfServicesTitle => 'Baldintzak';

  @override
  String get signUpTerms =>
      '<u-terms>Zerbitzu baldintzak</u-terms> eta <u-policy>pribatutasun politikak</u-policy> onartzen ditut';

  @override
  String get logInLabel => 'Sartu';

  @override
  String get loginTerms =>
      'Sartzeko klikatuz, <u-terms>zerbitzu baldintzak</u-terms> eta <u-policy>pribatutasun politikak</u-policy> onartzen ditut';

  @override
  String get changeEmail => 'Aldatu e-maila';

  @override
  String get enterYourPassword => 'Sartu zure pasahitza';

  @override
  String get welcomeBack => 'Ongi etorri berriro!';

  @override
  String get contactSupport => 'Kontaktatu laguntza';

  @override
  String get locationPickerTip =>
      'You can also add a location centered on a photo from the photo\'s info screen';

  @override
  String get incorrectPasswordTitle => 'Pasahitz okerra';

  @override
  String get pleaseTryAgain => 'Saiatu berriro, mesedez';

  @override
  String get recreatePasswordTitle => 'Berrezarri pasahitza';

  @override
  String get useRecoveryKey => 'Erabili berreskuratze giltza';

  @override
  String get recreatePasswordBody =>
      'Gailu hau ez da zure pasahitza egiaztatzeko bezain indartsua, baina gailu guztietan funtzionatzen duen modu batean birsortu ahal dugu. \n\nMesedez sartu zure berreskuratze giltza erabiliz eta birsortu zure pasahitza (aurreko berbera erabili ahal duzu nahi izanez gero).';

  @override
  String get verifyPassword => 'Egiaztatu pasahitza';

  @override
  String get recoveryKey => 'Berreskuratze giltza';

  @override
  String get recoveryKeyOnForgotPassword =>
      'Zure pasahitza ahazten baduzu, zure datuak berreskuratzeko modu bakarra gailu honen bidez izango da.';

  @override
  String get recoveryKeySaveDescription =>
      'Guk ez dugu gailu hau gordetzen; mesedez, gorde 24 hitzeko giltza hau lege seguru batean.';

  @override
  String get doThisLater => 'Egin hau geroago';

  @override
  String get saveKey => 'Gorde giltza';

  @override
  String get recoveryKeyCopiedToClipboard =>
      'Berreskuratze giltza arbelean kopiatu da';

  @override
  String get recoverAccount => 'Berreskuratu kontua';

  @override
  String get recover => 'Berreskuratu';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'Mesedez, bidali e-maila $supportEmail-era zure erregistratutako e-mail helbidetik';
  }

  @override
  String get twofactorSetup => 'Faktore biko ezarpena';

  @override
  String get enterCode => 'Sartu kodea';

  @override
  String get scanCode => 'Eskaneatu kodea';

  @override
  String get codeCopiedToClipboard => 'Kodea arbelean kopiatuta';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      'Kopiatu eta itsatsi kode hau zure autentifikazio aplikaziora';

  @override
  String get tapToCopy => 'jo kopiatzeko';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      'Eskaneatu barra kode hau zure autentifikazio aplikazioaz';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      'Sartu 6 digituko kodea zure autentifikazio aplikaziotik';

  @override
  String get confirm => 'Baieztatu';

  @override
  String get setupComplete => 'Prestaketa burututa';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready =>
      'Gorde zure berreskuratze giltza ez baduzu oraindik egin';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      'Hau zure kontua berreskuratzeko erabili ahal duzu, zure bigarren faktorea ahaztuz gero';

  @override
  String get twofactorAuthenticationPageTitle => 'Faktore biko autentifikatzea';

  @override
  String get lostDevice => 'Gailua galdu duzu?';

  @override
  String get verifyingRecoveryKey => 'Berreskuratze giltza egiaztatuz...';

  @override
  String get recoveryKeyVerified => 'Berreskuratze giltza egiaztatuta';

  @override
  String get recoveryKeySuccessBody =>
      'Primeran! Zure berreskuratze giltza zuzena da. Eskerrik asko egiaztatzeagatik.\n\nMesedez, gogoratu zure berreskuratze giltza leku seguruan gordetzea.';

  @override
  String get invalidRecoveryKey =>
      'Sartu duzun berreskuratze kodea ez da zuzena. Mesedez, ziurtatu 24 hitz duela, eta egiaztatu hitz bakoitzaren idazkera. \n\nBerreskuratze kode zaharren bat sartu baduzu, ziurtatu 64 karaktere duela, eta egiaztatu horietako bakoitza.';

  @override
  String get invalidKey => 'Kode okerra';

  @override
  String get tryAgain => 'Saiatu berriro';

  @override
  String get viewRecoveryKey => 'Ikusi berreskuratze kodea';

  @override
  String get confirmRecoveryKey => 'Egiaztatu berreskuratze kodea';

  @override
  String get recoveryKeyVerifyReason =>
      'Pasahitza ahazten baduzu, zure berreskuratze giltza argazkiak berreskuratzeko modu bakarra da. Berreskuratze giltza hemen aurkitu ahal duzu Ezarpenak > Kontua.\n\nMesedez sartu hemen zure berreskuratze giltza ondo gorde duzula egiaztatzeko.';

  @override
  String get confirmYourRecoveryKey => 'Egiaztatu zure berreskuratze giltza';

  @override
  String get addViewer => 'Gehitu ikuslea';

  @override
  String get addCollaborator => 'Gehitu laguntzailea';

  @override
  String get admin => 'Admin';

  @override
  String get admins => 'Admins';

  @override
  String get addAdmin => 'Add admin';

  @override
  String get addMoreAdmins => 'Add more admins';

  @override
  String get adminsAndCollaboratorsCanAddPhotosDescription =>
      'Admins and collaborators can add photos. Admins can also manage photos & participants.';

  @override
  String get addANewEmail => 'Gehitu e-mail berria';

  @override
  String get orPickAnExistingOne => 'Edo aukeratu lehengo bat';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'Laguntzaileek argazkiak eta bideoak gehitu ahal dituzte album partekatuan.';

  @override
  String get enterEmail => 'Sartu e-maila';

  @override
  String get albumOwner => 'Jabea';

  @override
  String get you => 'Zu';

  @override
  String get collaborator => 'Laguntzailea';

  @override
  String get addMore => 'Gehitu gehiago';

  @override
  String get viewer => 'Ikuslea';

  @override
  String get remove => 'Kendu';

  @override
  String get removeParticipant => 'Kendu parte hartzailea';

  @override
  String get manage => 'Kudeatu';

  @override
  String get addedAs => 'Honela gehituta:';

  @override
  String get changePermissions => 'Baimenak aldatu nahi?';

  @override
  String get yesConvertToViewer => 'Bai, egin ikusle';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return '$user-(e)k ezin izango du argazki gehiago gehitu album honetan \n\nBaina haiek gehitutako argazkiak kendu ahal izango dituzte';
  }

  @override
  String get allowAddingPhotos => 'Baimendu argazkiak gehitzea';

  @override
  String get allowJoiningAlbum => 'Allow joining album';

  @override
  String get allowAddPhotosDescription =>
      'Utzi esteka duen jendeari ere album partekatuan argazkiak gehitzen.';

  @override
  String get passwordLock => 'Pasahitza blokeoa';

  @override
  String get canNotOpenTitle => 'Ezin dut album hau ireki';

  @override
  String get canNotOpenBody =>
      'Sentitzen dugu, album hau ezin da aplikazioan ireki.';

  @override
  String get disableDownloadWarningTitle => 'Mesedez, ohartu';

  @override
  String get disableDownloadWarningBody =>
      'Ikusleek pantaila-irudiak atera ahal dituzte, edo kanpoko tresnen bidez zure argazkien kopiak gorde';

  @override
  String get allowDownloads => 'Baimendu jaitsierak';

  @override
  String get linkDeviceLimit => 'Gailu muga';

  @override
  String get noDeviceLimit => 'Bat ere ez';

  @override
  String get albumLayout => 'Album layout';

  @override
  String get layoutGrouped => 'Grouped';

  @override
  String get layoutContinuous => 'Continuous';

  @override
  String get layoutTrip => 'Trip';

  @override
  String get preview => 'Preview';

  @override
  String get linkExpiry => 'Estekaren epemuga';

  @override
  String get linkExpired => 'Iraungita';

  @override
  String get linkEnabled => 'Indarrean';

  @override
  String get linkNeverExpires => 'Inoiz ez';

  @override
  String get expiredLinkInfo =>
      'Esteka hau iraungi da. Mesedez, aukeratu beste epemuga bat edo deuseztatu estekaren epemuga.';

  @override
  String get setAPassword => 'Ezarri pasahitza';

  @override
  String get lockButtonLabel => 'Blokeatu';

  @override
  String get enterPassword => 'Sartu pasahitza';

  @override
  String get removeLink => 'Ezabatu esteka';

  @override
  String get manageLink => 'Kudeatu esteka';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'Esteka epe honetan iraungiko da: $expiryTime';
  }

  @override
  String get albumUpdated => 'Albuma eguneratuta';

  @override
  String get never => 'Inoiz ez';

  @override
  String get custom => 'Aukeran';

  @override
  String get after1Hour => 'Ordubete barru';

  @override
  String get after1Day => 'Egun bat barru';

  @override
  String get after1Week => 'Astebete barru';

  @override
  String get after1Month => 'Hilabete bat barru';

  @override
  String get after1Year => 'Urtebete barru';

  @override
  String get manageParticipants => 'Kudeatu';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Parte hartzaile',
      one: 'Parte hartzaile 1',
      zero: 'Parte hartzailerik ez',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'Sortu esteka bat beste pertsona batzuei zure album partekatuan arriskuak gehitu eta ikusten uzteko, naiz eta Ente aplikazio edo kontua ez izan. Oso egokia gertakizun bateko argazkiak biltzeko.';

  @override
  String get collectPhotos => 'Bildu argazkiak';

  @override
  String get collaborativeLink => 'Parte hartzeko esteka';

  @override
  String get shareWithNonenteUsers => 'Partekatu Ente erabiltzen ez dutenekin';

  @override
  String get createPublicLink => 'Sortu esteka publikoa';

  @override
  String get sendLink => 'Bidali esteka';

  @override
  String get qrCode => 'QR Code';

  @override
  String get sendQrCode => 'Send QR code';

  @override
  String get copyLink => 'Kopiatu esteka';

  @override
  String get copyEmbedHtml => 'Copy embed HTML';

  @override
  String get linkHasExpired => 'Esteka iraungi da';

  @override
  String get publicLinkEnabled => 'Esteka publikoa indarrean';

  @override
  String get shareALink => 'Partekatu esteka';

  @override
  String get sharedAlbumSectionDescription =>
      'Sortu partekatutako eta parte hartzeko albumak beste Ente erabiltzaileekin, debaldeko planak dituztenak barne.';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: 'Partekatu $numberOfPeople pertsonarekin',
      one: 'Partekatu pertsona batekin',
      zero: 'Partekatu pertsona zehatz batzuekin',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId => 'Hau da zure Egiaztatze IDa';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'Zurekin albumak partekatzen dituen norbaitek ID berbera ikusi beharko luke bere gailuan.';

  @override
  String get howToViewShareeVerificationID =>
      'Mesedez, eska iezaiozu ezarpenen landutako bere e-mail helbidean luze klikatzeko, eta egiaztatu gailu bietako IDak bat direla.';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'Hau da $email-(r)en Egiaztatze IDa';
  }

  @override
  String get verificationId => 'Egiaztatze IDa';

  @override
  String verifyEmailID({required Object email}) {
    return 'Egiaztatu $email';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return '$email-(e)k ez du Ente konturik. \n\nBidali gonbidapena argazkiak partekatzeko.';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return 'Hau da nire Egiaztatze IDa: $verificationID ente.io-rako.';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'Ei, baieztatu ahal duzu hau dela zure ente.io Egiaztatze IDa?: $verificationID';
  }

  @override
  String get somethingWentWrong => 'Zerbait oker joan da';

  @override
  String get sendInvite => 'Bidali gonbidapena';

  @override
  String get shareTextRecommendUsingEnte =>
      'Jaitsi Ente argazkiak eta bideoak jatorrizko kalitatean errez partekatu ahal izateko \n\nhttps://ente.io';

  @override
  String get done => 'Eginda';

  @override
  String get applyCodeTitle => 'Aplikatu kodea';

  @override
  String get enterCodeDescription =>
      'Sartu zure lagunak emandako kodea, biontzat debaldeko biltegiratzea lortzeko';

  @override
  String get apply => 'Aplikatu';

  @override
  String get failedToApplyCode => 'Akatsa kodea aplikatzean';

  @override
  String get enterReferralCode => 'Sartu erreferentzia kodea';

  @override
  String get codeAppliedPageTitle => 'Kodea aplikatuta';

  @override
  String get changeYourReferralCode => 'Aldatu zure erreferentzia kodea';

  @override
  String get change => 'Aldatu';

  @override
  String get unavailableReferralCode =>
      'Sentitzen dugu, kode hau ezin da erabili.';

  @override
  String get codeChangeLimitReached =>
      'Sentitzen dugu, zure kode aldaketa muga gainditu duzu.';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'Mesedez, jarri harremanetan $familyAdminEmail-(r)ekin zure kodea aldatzeko.';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB';
  }

  @override
  String get claimed => 'Eskatuta';

  @override
  String get details => 'Detaileak';

  @override
  String get claimMore => 'Eskatu gehiago!';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return 'Haiek ere lortuko dute $storageAmountInGB GB';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB norbaitek ordainpeko plan batean sartzen denean zure kodea aplikatzen badu';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'Sartu erreferentzia kodea: $referralCode\n\nAplikatu hemen: Ezarpenak → Orokorra→ Erreferentziak, $referralStorageInGB GB dohainik izateko ordainpeko plan batean \n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => 'Eskatu debaldeko biltegiratzea';

  @override
  String get inviteYourFriends => 'Gonbidatu zure lagunak';

  @override
  String get failedToFetchReferralDetails =>
      'Ezin dugu zure erreferentziaren detailerik lortu. Mesedez, saiatu berriro geroago.';

  @override
  String get referralStep1 => '1. Eman kode hau zure lagunei';

  @override
  String get referralStep2 =>
      '2. Haiek ordainpeko plan batean sinatu behar dute';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. Bai zuk bai haiek $storageInGB GB* dohainik izango duzue';
  }

  @override
  String get referralsAreCurrentlyPaused =>
      'Erreferentziak momentuz geldituta daude';

  @override
  String get youCanAtMaxDoubleYourStorage =>
      '* Gehienez zure biltegiratzea bikoiztu ahal duzu';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true': 'Zure familiak $storageAmountInGb GB eskatu du dagoeneko',
      'false': 'Zuk $storageAmountInGb GB eskatu duzu dagoeneko',
      'other': 'Zuk $storageAmountInGb GB eskatu duzu dagoeneko!',
    });
    return '$_temp0';
  }

  @override
  String get faq => 'FAQ';

  @override
  String get help => 'Laguntza';

  @override
  String get oopsSomethingWentWrong => 'Oops, zerbait txarto joan da';

  @override
  String get peopleUsingYourCode => 'Jendea zure kodea erabiltzen';

  @override
  String get eligible => 'aukerakoak';

  @override
  String get total => 'osotara';

  @override
  String get codeUsedByYou => 'Zuk erabilitako kodea';

  @override
  String get freeStorageClaimed => 'Debaldeko biltegiratzea eskatuta';

  @override
  String get freeStorageUsable => 'Debaldeko biltegiratzea erabilgarri';

  @override
  String get usableReferralStorageInfo =>
      'Biltegiratze erabilgarria zure oraingo planaren arabera mugatuta dago. Soberan eskatutako biltegiratzea automatikoki erabili ahal izango duzu zure plan gaurkotzen duzunean.';

  @override
  String get removeFromAlbumTitle => 'Albumetik kendu?';

  @override
  String get removeFromAlbum => 'Kendu albumetik';

  @override
  String get itemsWillBeRemovedFromAlbum =>
      'Hautatutako elementuak album honetatik kenduko dira';

  @override
  String get removeShareItemsWarning =>
      'Selected photos will not be accessible to any viewer of this album, except the photo owners.';

  @override
  String get addingToFavorites => 'Gogokoetan gehitzen...';

  @override
  String get removingFromFavorites => 'Gogokoetatik kentzen...';

  @override
  String get sorryCouldNotAddToFavorites =>
      'Sentitzen dut, ezin izan dugu zure gogokoetan gehitu!';

  @override
  String get sorryCouldNotRemoveFromFavorites =>
      'Sentitzen dugu, ezin izan dugu zure gogokoetatik kendu!';

  @override
  String get subscribeToEnableSharing =>
      'Ordainpeko harpidetza behar duzu partekatzea aktibatzeko.';

  @override
  String get subscribeToChangeLinkSetting =>
      'You need a paid subscription to change this link setting.';

  @override
  String get subscribe => 'Harpidetu';

  @override
  String get canOnlyRemoveFilesOwnedByYou =>
      'Zure fitxategiak baino ezin duzu ezabatu';

  @override
  String get deleteSharedAlbum => 'Partekatutako albuma ezabatu?';

  @override
  String get deleteAlbum => 'Ezabatu albuma';

  @override
  String get deleteAlbumDialog =>
      'Ezabatu nahi dituzu album honetan dauden argazkiak (eta bideoak) parte diren beste album <bold>guztietatik</bold> ere?';

  @override
  String get deleteSharedAlbumDialogBody =>
      'Albuma guztiontzat ezabatuko da \n\nAlbum honetan dauden beste pertsonek partekatutako argazkiak ezin izango dituzu eskuratu';

  @override
  String get yesRemove => 'Bai, ezabatu';

  @override
  String get creatingLink => 'Esteka sortzen...';

  @override
  String get removeWithQuestionMark => 'Ezabatuko?';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return '$userEmail partekatutako album honetatik ezabatuko da \n\nHaiek gehitutako argazki guztiak ere ezabatuak izango dira albumetik';
  }

  @override
  String get keepPhotos => 'Gorde Argazkiak';

  @override
  String get deletePhotos => 'Ezabatu argazkiak';

  @override
  String get inviteToEnte => 'Gonbidatu Ente-ra';

  @override
  String get removePublicLink => 'Ezabatu esteka publikoa';

  @override
  String disableLinkMessage({required Object albumName}) {
    return 'Honen bidez $albumName eskuratzeko esteka publikoa ezabatuko da.';
  }

  @override
  String get sharing => 'Partekatzen...';

  @override
  String get youCannotShareWithYourself =>
      'Ezin duzu zeure buruarekin partekatu';

  @override
  String get archive => 'Artxiboa';

  @override
  String get createAlbumActionHint =>
      'Luze klikatu argazkiak hautatzeko eta klikatu + albuma sortzeko';

  @override
  String get importing => 'Inportatzen....';

  @override
  String get failedToLoadAlbums => 'Errorea albumak kargatzen';

  @override
  String get hidden => 'Ezkutatuta';

  @override
  String get authToViewYourHiddenFiles =>
      'Mesedez, autentifikatu zure ezkutatutako fitxategiak ikusteko';

  @override
  String get authToViewTrashedFiles =>
      'Mesedez, autentifikatu paperontzira botatako zure fitxategiak ikusteko';

  @override
  String get trash => 'Zarama';

  @override
  String get uncategorized => 'Kategori gabekoa';

  @override
  String get videoSmallCase => 'bideoa';

  @override
  String get photoSmallCase => 'argazkia';

  @override
  String get singleFileDeleteHighlight => 'Album guztietatik ezabatuko da.';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return '$fileType hau Ente-n eta zure gailuan dago.';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return '$fileType hau Ente-tik ezabatuko da.';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return '$fileType hau zure gailutik ezabatuko da.';
  }

  @override
  String get deleteFromEnte => 'Ezabatu Ente-tik';

  @override
  String get yesDelete => 'Bai, ezabatu';

  @override
  String get movedToTrash => 'Zarama mugituta';

  @override
  String get deleteFromDevice => 'Ezabatu gailutik';

  @override
  String get deleteFromBoth => 'Ezabatu bietatik';

  @override
  String get newAlbum => 'Album berria';

  @override
  String get albums => 'Albumak';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount oroitzapen',
      one: 'oroitzapen $formattedCount',
      zero: 'oroitzapenik ez',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return '$count hautatuta';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return '$count hautatuta ($yourCount zureak)';
  }

  @override
  String get advancedSettings => 'Aurreratuak';

  @override
  String get photoGridSize => 'Argazki sarearen tamaina';

  @override
  String get manageDeviceStorage => 'Kudeatu gailuaren katxea';

  @override
  String get manageDeviceStorageDesc =>
      'Berrikusi eta garbitu katxe lokalaren biltegiratzea.';

  @override
  String get machineLearning => 'Ikasketa automatikoa';

  @override
  String get mlConsent => 'Aktibatu ikasketa automatikoa';

  @override
  String get mlConsentTitle => 'Ikasketa automatikoa aktibatuko?';

  @override
  String get mlConsentDescription =>
      'Ikasketa automatikoa aktibatuz gero, Ente-k fitxategietatik informazioa aterako du (ad. argazkien geometria), zurekin partekatutako argazkietatik ere.\n\nHau zure gailuan gertatuko da, eta sortutako informazio biometrikoa puntutik puntura zifratuta egongo da.';

  @override
  String get mlConsentPrivacy =>
      'Mesedez, klikatu hemen gure pribatutasun politikan ezaugarri honi buruz detaile gehiago izateko';

  @override
  String get mlConsentConfirmation =>
      'Ulertzen dut, eta ikasketa automatikoa aktibatu nahi dut';

  @override
  String get magicSearch => 'Bilaketa magikoa';

  @override
  String get discover => 'Aurkitu';

  @override
  String get discover_identity => 'Nortasuna';

  @override
  String get discover_screenshots => 'Pantaila argazkiak';

  @override
  String get discover_receipts => 'Ordainagiriak';

  @override
  String get discover_notes => 'Oharrak';

  @override
  String get discover_memes => 'Memeak';

  @override
  String get discover_visiting_cards => 'Bisita txartelak';

  @override
  String get discover_babies => 'Umeak';

  @override
  String get discover_pets => 'Etxe-animaliak';

  @override
  String get discover_selfies => 'Selfiak';

  @override
  String get discover_wallpapers => 'Horma-paperak';

  @override
  String get discover_food => 'Janaria';

  @override
  String get discover_celebrations => 'Ospakizunak';

  @override
  String get discover_sunset => 'Eguzki-sartzea';

  @override
  String get discover_hills => 'Muinoak';

  @override
  String get discover_greenery => 'Hostoa';

  @override
  String get mlIndexingDescription =>
      'Please note that machine learning will result in a higher bandwidth and battery usage until all items are indexed. Consider using the desktop app for faster indexing, all results will be synced automatically.';

  @override
  String get loadingModel => 'Downloading models...';

  @override
  String get waitingForWifi => 'Waiting for WiFi...';

  @override
  String get status => 'Status';

  @override
  String get indexedItems => 'Indexed items';

  @override
  String get pendingItems => 'Pending items';

  @override
  String get clearIndexes => 'Clear indexes';

  @override
  String get selectFoldersForBackup => 'Select folders for backup';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      'Selected folders will be encrypted and backed up';

  @override
  String get unselectAll => 'Unselect all';

  @override
  String get selectAll => 'Select all';

  @override
  String get skip => 'Skip';

  @override
  String get updatingFolderSelection => 'Updating folder selection...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count items',
      one: '$count item',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Delete $count items',
      one: 'Delete $count item',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count files, $formattedSize each';
  }

  @override
  String get showMemories => 'Show memories';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count years ago',
      one: '$count year ago',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'Backup settings';

  @override
  String get backupStatus => 'Backup status';

  @override
  String get backupStatusDescription =>
      'Items that have been backed up will show up here';

  @override
  String get backupOverMobileData => 'Backup over mobile data';

  @override
  String get backupVideos => 'Backup videos';

  @override
  String get disableAutoLock => 'Disable auto lock';

  @override
  String get deviceLockExplanation =>
      'Disable the device screen lock when Ente is in the foreground and there is a backup in progress. This is normally not needed, but may help big uploads and initial imports of large libraries complete faster.';

  @override
  String get about => 'About';

  @override
  String get weAreOpenSource => 'We are open source!';

  @override
  String get privacy => 'Privacy';

  @override
  String get terms => 'Terms';

  @override
  String get checkForUpdates => 'Check for updates';

  @override
  String get checkStatus => 'Check status';

  @override
  String get checking => 'Checking...';

  @override
  String get youAreOnTheLatestVersion => 'You are on the latest version';

  @override
  String get account => 'Account';

  @override
  String get manageSubscription => 'Manage subscription';

  @override
  String get authToChangeYourEmail =>
      'Mesedez, autentifikatu zure emaila aldatzeko';

  @override
  String get changePassword => 'Change password';

  @override
  String get authToChangeYourPassword =>
      'Mesedez, autentifikatu zure pasahitza aldatzeko';

  @override
  String get emailVerificationToggle => 'Email verification';

  @override
  String get authToChangeEmailVerificationSetting =>
      'Mesedez, autentifikatu emailaren egiaztatzea aldatzeko';

  @override
  String get exportYourData => 'Export your data';

  @override
  String get logout => 'Logout';

  @override
  String get authToInitiateAccountDeletion =>
      'Mesedez, autentifikatu kontu ezabaketa hasteko';

  @override
  String get areYouSureYouWantToLogout => 'Are you sure you want to logout?';

  @override
  String get yesLogout => 'Yes, logout';

  @override
  String get aNewVersionOfEnteIsAvailable =>
      'A new version of Ente is available.';

  @override
  String get update => 'Update';

  @override
  String get installManually => 'Install manually';

  @override
  String get criticalUpdateAvailable => 'Critical update available';

  @override
  String get updateAvailable => 'Update available';

  @override
  String get ignoreUpdate => 'Ignore';

  @override
  String get downloading => 'Downloading...';

  @override
  String get cannotDeleteSharedFiles => 'Cannot delete shared files';

  @override
  String get theDownloadCouldNotBeCompleted =>
      'The download could not be completed';

  @override
  String get retry => 'Retry';

  @override
  String get backedUpFolders => 'Backed up folders';

  @override
  String get backup => 'Backup';

  @override
  String get freeUpDeviceSpace => 'Free up device space';

  @override
  String get freeUpDeviceSpaceDesc =>
      'Save space on your device by clearing files that have been already backed up.';

  @override
  String get allClear => '✨ All clear';

  @override
  String get noDeviceThatCanBeDeleted =>
      'You\'ve no files on this device that can be deleted';

  @override
  String get removeDuplicates => 'Remove duplicates';

  @override
  String get removeDuplicatesDesc =>
      'Review and remove files that are exact duplicates.';

  @override
  String get viewLargeFiles => 'Large files';

  @override
  String get viewLargeFilesDesc =>
      'View files that are consuming the most amount of storage.';

  @override
  String get noDuplicates => '✨ No duplicates';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared =>
      'You don\'t have any duplicate files that can be cleared';

  @override
  String get success => 'Success';

  @override
  String get rateUs => 'Rate us';

  @override
  String get remindToEmptyDeviceTrash =>
      'Also empty \"Recently Deleted\" from \"Settings\" -> \"Storage\" to claim the freed space';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return 'You have successfully freed up $storageSaved!';
  }

  @override
  String get remindToEmptyEnteTrash =>
      'Also empty your \"Trash\" to claim the freed up space';

  @override
  String get sparkleSuccess => '✨ Success';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count duplicate files',
      one: '$count duplicate file',
    );
    return 'You have cleaned up $_temp0, saving ($storageSaved!)';
  }

  @override
  String get familyPlans => 'Family plans';

  @override
  String get referrals => 'Referrals';

  @override
  String get notifications => 'Notifications';

  @override
  String get sharedPhotoNotifications => 'New shared photos';

  @override
  String get sharedPhotoNotificationsExplanation =>
      'Receive notifications when someone adds a photo to a shared album that you\'re a part of';

  @override
  String get advanced => 'Advanced';

  @override
  String get general => 'General';

  @override
  String get security => 'Security';

  @override
  String get authToViewYourRecoveryKey =>
      'Mesedez, autentifikatu zure berreskuratze giltza ikusteko';

  @override
  String get twofactor => 'Two-factor';

  @override
  String get authToConfigureTwofactorAuthentication =>
      'Mesedez, autentifikatu faktore biko autentifikazioa konfiguratzeko';

  @override
  String get lockscreen => 'Lockscreen';

  @override
  String get authToChangeLockscreenSetting =>
      'Mesedez, autentifikatu pantaila blokeatzeko ezarpenak aldatzeko';

  @override
  String get viewActiveSessions => 'View active sessions';

  @override
  String get authToViewYourActiveSessions =>
      'Mesedez, autentifikatu indarrean dauden zure saioak ikusteko';

  @override
  String get disableTwofactor => 'Disable two-factor';

  @override
  String get confirm2FADisable =>
      'Seguru zaude faktore biko autentifikazioa deuseztatu nahi duzula?';

  @override
  String get no => 'No';

  @override
  String get yes => 'Yes';

  @override
  String get social => 'Social';

  @override
  String rateUsOnStore({required Object storeName}) {
    return 'Rate us on $storeName';
  }

  @override
  String get blog => 'Blog';

  @override
  String get merchandise => 'Merchandise';

  @override
  String get twitter => 'Twitter';

  @override
  String get mastodon => 'Mastodon';

  @override
  String get matrix => 'Matrix';

  @override
  String get discord => 'Discord';

  @override
  String get reddit => 'Reddit';

  @override
  String get yourStorageDetailsCouldNotBeFetched =>
      'Your storage details could not be fetched';

  @override
  String get reportABug => 'Report a bug';

  @override
  String get reportBug => 'Report bug';

  @override
  String get suggestFeatures => 'Suggest features';

  @override
  String get support => 'Support';

  @override
  String get theme => 'Theme';

  @override
  String get lightTheme => 'Light';

  @override
  String get darkTheme => 'Dark';

  @override
  String get systemTheme => 'System';

  @override
  String get freeTrial => 'Free trial';

  @override
  String get selectYourPlan => 'Select your plan';

  @override
  String get enteSubscriptionPitch =>
      'Ente preserves your memories, so they\'re always available to you, even if you lose your device.';

  @override
  String get enteSubscriptionShareWithFamily =>
      'Your family can be added to your plan as well.';

  @override
  String get currentUsageIs => 'Current usage is ';

  @override
  String get faqs => 'FAQs';

  @override
  String renewsOn({required Object endDate}) {
    return 'Subscription renews on $endDate';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return 'Free trial valid till $endDate';
  }

  @override
  String validTill({required Object endDate}) {
    return 'Valid till $endDate';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return 'Your $storageAmount add-on is valid till $endDate';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return 'Free trial valid till $endDate.\nYou can choose a paid plan afterwards.';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'Your subscription will be cancelled on $endDate';
  }

  @override
  String get subscription => 'Subscription';

  @override
  String get paymentDetails => 'Payment details';

  @override
  String get manageFamily => 'Manage Family';

  @override
  String contactToManageSubscription({required Object provider}) {
    return 'Please contact us at support@ente.io to manage your $provider subscription.';
  }

  @override
  String get renewSubscription => 'Renew subscription';

  @override
  String get cancelSubscription => 'Cancel subscription';

  @override
  String get areYouSureYouWantToRenew => 'Are you sure you want to renew?';

  @override
  String get yesRenew => 'Yes, Renew';

  @override
  String get areYouSureYouWantToCancel => 'Are you sure you want to cancel?';

  @override
  String get yesCancel => 'Yes, cancel';

  @override
  String get failedToRenew => 'Failed to renew';

  @override
  String get failedToCancel => 'Failed to cancel';

  @override
  String get twoMonthsFreeOnYearlyPlans => '2 months free on yearly plans';

  @override
  String get monthly => 'Monthly';

  @override
  String get yearly => 'Yearly';

  @override
  String get confirmPlanChange => 'Confirm plan change';

  @override
  String get areYouSureYouWantToChangeYourPlan =>
      'Are you sure you want to change your plan?';

  @override
  String get youCannotDowngradeToThisPlan =>
      'You cannot downgrade to this plan';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'Please cancel your existing subscription from $paymentProvider first';
  }

  @override
  String get optionalAsShortAsYouLike => 'Optional, as short as you like...';

  @override
  String get send => 'Send';

  @override
  String get askCancelReason =>
      'Your subscription was cancelled. Would you like to share the reason?';

  @override
  String get thankYouForSubscribing => 'Thank you for subscribing!';

  @override
  String get yourPurchaseWasSuccessful => 'Your purchase was successful';

  @override
  String get yourPlanWasSuccessfullyUpgraded =>
      'Your plan was successfully upgraded';

  @override
  String get yourPlanWasSuccessfullyDowngraded =>
      'Your plan was successfully downgraded';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully =>
      'Your subscription was updated successfully';

  @override
  String get googlePlayId => 'Google Play ID';

  @override
  String get appleId => 'Apple ID';

  @override
  String get playstoreSubscription => 'PlayStore subscription';

  @override
  String get appstoreSubscription => 'AppStore subscription';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return 'Your $id is already linked to another Ente account.\nIf you would like to use your $id with this account, please contact our support\'\'';
  }

  @override
  String get visitWebToManage =>
      'Please visit web.ente.io to manage your subscription';

  @override
  String get couldNotUpdateSubscription => 'Could not update subscription';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      'Please contact support@ente.io and we will be happy to help!';

  @override
  String get paymentFailed => 'Payment failed';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return 'Please talk to $providerName support if you were charged';
  }

  @override
  String get continueOnFreeTrial => 'Continue on free trial';

  @override
  String get areYouSureYouWantToExit => 'Are you sure you want to exit?';

  @override
  String get thankYou => 'Thank you';

  @override
  String get failedToVerifyPaymentStatus => 'Failed to verify payment status';

  @override
  String get pleaseWaitForSometimeBeforeRetrying =>
      'Please wait for sometime before retrying';

  @override
  String get paymentFailedMessage =>
      'Unfortunately your payment failed. Please contact support and we\'ll help you out!';

  @override
  String get youAreOnAFamilyPlan => 'You are on a family plan!';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'Please contact <green>$familyAdminEmail</green> to manage your subscription';
  }

  @override
  String get leaveFamily => 'Leave family';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily =>
      'Are you sure that you want to leave the family plan?';

  @override
  String get leave => 'Leave';

  @override
  String get rateTheApp => 'Rate the app';

  @override
  String get startBackup => 'Start backup';

  @override
  String get noPhotosAreBeingBackedUpRightNow =>
      'No photos are being backed up right now';

  @override
  String get preserveMore => 'Preserve more';

  @override
  String get grantFullAccessPrompt =>
      'Please allow access to all photos in the Settings app';

  @override
  String get allowPermTitle => 'Allow access to photos';

  @override
  String get allowPermBody =>
      'Please allow access to your photos from Settings so Ente can display and backup your library.';

  @override
  String get openSettings => 'Open Settings';

  @override
  String get selectMorePhotos => 'Select more photos';

  @override
  String get existingUser => 'Existing user';

  @override
  String get privateBackups => 'Private backups';

  @override
  String get forYourMemories => 'for your memories';

  @override
  String get endtoendEncryptedByDefault => 'End-to-end encrypted by default';

  @override
  String get safelyStored => 'Safely stored';

  @override
  String get atAFalloutShelter => 'at a fallout shelter';

  @override
  String get designedToOutlive => 'Designed to outlive';

  @override
  String get available => 'Available';

  @override
  String get everywhere => 'everywhere';

  @override
  String get androidIosWebDesktop => 'Android, iOS, Web, Desktop';

  @override
  String get mobileWebDesktop => 'Mobile, Web, Desktop';

  @override
  String get newToEnte => 'New to Ente';

  @override
  String get pleaseLoginAgain => 'Please login again';

  @override
  String get autoLogoutMessage =>
      'Due to technical glitch, you have been logged out. Our apologies for the inconvenience.';

  @override
  String get yourSubscriptionHasExpired => 'Your subscription has expired';

  @override
  String get storageLimitExceeded => 'Storage limit exceeded';

  @override
  String get upgrade => 'Upgrade';

  @override
  String get raiseTicket => 'Raise ticket';

  @override
  String get backupFailed => 'Backup failed';

  @override
  String get sorryBackupFailedDesc =>
      'Sorry, we could not backup this file right now, we will retry later.';

  @override
  String get couldNotBackUpTryLater =>
      'We could not backup your data.\nWe will retry later.';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      'Ente can encrypt and preserve files only if you grant access to them';

  @override
  String get pleaseGrantPermissions => 'Please grant permissions';

  @override
  String get grantPermission => 'Grant permission';

  @override
  String get privateSharing => 'Private sharing';

  @override
  String get shareOnlyWithThePeopleYouWant =>
      'Share only with the people you want';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      'Use public links for people not on Ente';

  @override
  String get allowPeopleToAddPhotos => 'Allow people to add photos';

  @override
  String get shareAnAlbumNow => 'Share an album now';

  @override
  String get collectEventPhotos => 'Collect event photos';

  @override
  String get sessionExpired => 'Session expired';

  @override
  String get loggingOut => 'Logging out...';

  @override
  String get onDevice => 'On device';

  @override
  String get onEnte => 'On <branding>ente</branding>';

  @override
  String get name => 'Name';

  @override
  String get newest => 'Newest';

  @override
  String get lastUpdated => 'Last updated';

  @override
  String get deleteEmptyAlbums => 'Delete empty albums';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => 'Delete empty albums?';

  @override
  String get deleteAlbumsDialogBody =>
      'This will delete all empty albums. This is useful when you want to reduce the clutter in your album list.';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return 'Deleting $currentlyDeleting / $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return 'Processing $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => 'Permanently delete';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou =>
      'Can only create link for files owned by you';

  @override
  String get publicLinkCreated => 'Public link created';

  @override
  String get youCanManageYourLinksInTheShareTab =>
      'You can manage your links in the share tab.';

  @override
  String get linkCopiedToClipboard => 'Link copied to clipboard';

  @override
  String get restore => 'Restore';

  @override
  String get moveToAlbum => 'Move to album';

  @override
  String get unhide => 'Unhide';

  @override
  String get unarchive => 'Unarchive';

  @override
  String get favorite => 'Favorite';

  @override
  String get removeFromFavorite => 'Remove from favorites';

  @override
  String get shareLink => 'Share link';

  @override
  String get createCollage => 'Create collage';

  @override
  String get saveCollage => 'Save collage';

  @override
  String get collageSaved => 'Collage saved to gallery';

  @override
  String get collageLayout => 'Layout';

  @override
  String get addToEnte => 'Add to Ente';

  @override
  String get addToAlbum => 'Add to album';

  @override
  String get delete => 'Delete';

  @override
  String get hide => 'Hide';

  @override
  String get share => 'Share';

  @override
  String get unhideToAlbum => 'Unhide to album';

  @override
  String get restoreToAlbum => 'Restore to album';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Move items',
      one: 'Move item',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add items',
      one: 'Add item',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'Create or select album';

  @override
  String get selectAlbum => 'Select album';

  @override
  String get searchByAlbumNameHint => 'Album name';

  @override
  String get albumTitle => 'Album title';

  @override
  String get enterAlbumName => 'Enter album name';

  @override
  String get restoringFiles => 'Restoring files...';

  @override
  String get movingFilesToAlbum => 'Moving files to album...';

  @override
  String get unhidingFilesToAlbum => 'Unhiding files to album';

  @override
  String get canNotUploadToAlbumsOwnedByOthers =>
      'Can not upload to albums owned by others';

  @override
  String get uploadingFilesToAlbum => 'Uploading files to album...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return 'Added successfully to  $albumName';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return 'Moved successfully to $albumName';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'This album already has a collaborative link';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return 'Collaborative link created for $albumName';
  }

  @override
  String get askYourLovedOnesToShare => 'Ask your loved ones to share';

  @override
  String get invite => 'Invite';

  @override
  String get shareYourFirstAlbum => 'Share your first album';

  @override
  String sharedWith({required Object emailIDs}) {
    return 'Shared with $emailIDs';
  }

  @override
  String get sharedWithMe => 'Shared with me';

  @override
  String get sharedByMe => 'Shared by me';

  @override
  String get doubleYourStorage => 'Double your storage';

  @override
  String get referFriendsAnd2xYourPlan => 'Refer friends and 2x your plan';

  @override
  String get shareAlbumHint =>
      'Open an album and tap the share button on the top right to share.';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      'Items show the number of days remaining before permanent deletion';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count days',
      one: '1 day',
      zero: 'Soon',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => 'Delete All';

  @override
  String get renameAlbum => 'Rename album';

  @override
  String get convertToAlbum => 'Convert to album';

  @override
  String get setCover => 'Set cover';

  @override
  String get sortAlbumsBy => 'Sort by';

  @override
  String get sortNewestFirst => 'Newest first';

  @override
  String get sortOldestFirst => 'Oldest first';

  @override
  String get rename => 'Rename';

  @override
  String get leaveSharedAlbum => 'Leave shared album?';

  @override
  String get leaveAlbum => 'Leave album';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'Photos added by you will be removed from the album';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted =>
      'You\'ve no files in this album that can be deleted';

  @override
  String get youDontHaveAnyArchivedItems =>
      'You don\'t have any archived items.';

  @override
  String get ignoredFolderUploadReason =>
      'Some files in this album are ignored from upload because they had previously been deleted from Ente.';

  @override
  String get resetIgnoredFiles => 'Reset ignored files';

  @override
  String get deviceFilesAutoUploading =>
      'Files added to this device album will automatically get uploaded to Ente.';

  @override
  String get turnOnBackupForAutoUpload =>
      'Turn on backup to automatically upload files added to this device folder to Ente.';

  @override
  String get noHiddenPhotosOrVideos => 'No hidden photos or videos';

  @override
  String get toHideAPhotoOrVideo => 'To hide a photo or video';

  @override
  String get openTheItem => '• Open the item';

  @override
  String get clickOnTheOverflowMenu => '• Click on the overflow menu';

  @override
  String get click => '• Click';

  @override
  String get nothingToSeeHere => 'Nothing to see here! 👀';

  @override
  String get unarchiveAlbum => 'Unarchive album';

  @override
  String get archiveAlbum => 'Archive album';

  @override
  String get calculating => 'Calculating...';

  @override
  String get pleaseWaitDeletingAlbum => 'Please wait, deleting album';

  @override
  String get searchByExamples =>
      '• Album names (e.g. \"Camera\")\n• Types of files (e.g. \"Videos\", \".gif\")\n• Years and months (e.g. \"2022\", \"January\")\n• Holidays (e.g. \"Christmas\")\n• Photo descriptions (e.g. “#fun”)';

  @override
  String get youCanTrySearchingForADifferentQuery =>
      'You can try searching for a different query.';

  @override
  String get noResultsFound => 'No results found';

  @override
  String addedBy({required Object emailOrName}) {
    return 'Added by $emailOrName';
  }

  @override
  String get loadingExifData => 'Loading EXIF data...';

  @override
  String get viewAllExifData => 'View all EXIF data';

  @override
  String get noExifData => 'No EXIF data';

  @override
  String get thisImageHasNoExifData => 'This image has no exif data';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => 'No results';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'We don\'t support editing photos and albums that you don\'t own yet';

  @override
  String get failedToFetchOriginalForEdit =>
      'Failed to fetch original for edit';

  @override
  String get close => 'Close';

  @override
  String get setAs => 'Set as';

  @override
  String get fileSavedToGallery => 'File saved to gallery';

  @override
  String get filesSavedToGallery => 'Files saved to gallery';

  @override
  String get fileFailedToSaveToGallery => 'Failed to save file to gallery';

  @override
  String get download => 'Download';

  @override
  String get pressAndHoldToPlayVideo => 'Press and hold to play video';

  @override
  String get pressAndHoldToPlayVideoDetailed =>
      'Press and hold on the image to  play video';

  @override
  String get downloadFailed => 'Download failed';

  @override
  String get deduplicateFiles => 'Deduplicate Files';

  @override
  String get deselectAll => 'Deselect all';

  @override
  String get reviewDeduplicateItems =>
      'Please review and delete the items you believe are duplicates.';

  @override
  String get clubByCaptureTime => 'Club by capture time';

  @override
  String get clubByFileName => 'Club by file name';

  @override
  String get count => 'Count';

  @override
  String get totalSize => 'Total size';

  @override
  String get longpressOnAnItemToViewInFullscreen =>
      'Long-press on an item to view in full-screen';

  @override
  String get decryptingVideo => 'Decrypting video...';

  @override
  String get authToViewYourMemories =>
      'Please authenticate to view your memories';

  @override
  String get unlock => 'Unlock';

  @override
  String get freeUpSpace => 'Free up space';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'They can be deleted from the device to free up $formattedSize',
      one: 'It can be deleted from the device to free up $formattedSize',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber files',
      one: '1 file',
    );
    return '$_temp0 in this album has been backed up safely';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber files',
      one: '1 file',
    );
    return '$_temp0 on this device have been backed up safely';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'them',
      one: 'it',
    );
    return 'You can still access $_temp0 on Ente as long as you have an active subscription';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return 'Free up $sizeInMBorGB';
  }

  @override
  String get thisEmailIsAlreadyInUse => 'This email is already in use';

  @override
  String get incorrectCode => 'Incorrect code';

  @override
  String get authenticationFailedPleaseTryAgain =>
      'Authentication failed, please try again';

  @override
  String get verificationFailedPleaseTryAgain =>
      'Verification failed, please try again';

  @override
  String get authenticating => 'Authenticating...';

  @override
  String get authenticationSuccessful => 'Authentication successful!';

  @override
  String get incorrectRecoveryKey => 'Incorrect recovery key';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect =>
      'The recovery key you entered is incorrect';

  @override
  String get twofactorAuthenticationSuccessfullyReset =>
      'Two-factor authentication successfully reset';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered =>
      'Please verify the code you have entered';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      'Please contact support if the problem persists';

  @override
  String get twofactorAuthenticationHasBeenDisabled =>
      'Faktore biko autentifikazioa deuseztatua izan da';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect =>
      'Sorry, the code you\'ve entered is incorrect';

  @override
  String get yourVerificationCodeHasExpired =>
      'Your verification code has expired';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'Email changed to $newEmail';
  }

  @override
  String get verifying => 'Verifying...';

  @override
  String get disablingTwofactorAuthentication =>
      'Disabling two-factor authentication...';

  @override
  String get allMemoriesPreserved => 'All memories preserved';

  @override
  String get loadingGallery => 'Loading gallery...';

  @override
  String get syncing => 'Syncing...';

  @override
  String get encryptingBackup => 'Encrypting backup...';

  @override
  String get syncStopped => 'Sync stopped';

  @override
  String syncProgress({required String completed, required String total}) {
    return '$completed/$total memories preserved';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return 'Preserving $count memories...';
  }

  @override
  String get uploadingSingleMemory => 'Preserving 1 memory...';

  @override
  String get archiving => 'Archiving...';

  @override
  String get unarchiving => 'Unarchiving...';

  @override
  String get successfullyArchived => 'Successfully archived';

  @override
  String get successfullyUnarchived => 'Successfully unarchived';

  @override
  String get renameFile => 'Rename file';

  @override
  String get enterFileName => 'Enter file name';

  @override
  String get filesDeleted => 'Files deleted';

  @override
  String get selectedFilesAreNotOnEnte => 'Selected files are not on Ente';

  @override
  String get thisActionCannotBeUndone => 'This action cannot be undone';

  @override
  String get emptyTrash => 'Empty trash?';

  @override
  String get permDeleteWarning =>
      'All items in trash will be permanently deleted\n\nThis action cannot be undone';

  @override
  String get empty => 'Empty';

  @override
  String get couldNotFreeUpSpace => 'Could not free up space';

  @override
  String get permanentlyDeleteFromDevice => 'Permanently delete from device?';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      'Some of the files you are trying to delete are only available on your device and cannot be recovered if deleted';

  @override
  String get theyWillBeDeletedFromAllAlbums =>
      'They will be deleted from all albums.';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'Some items are in both Ente and your device.';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      'Selected items will be deleted from all albums and moved to trash.';

  @override
  String get theseItemsWillBeDeletedFromYourDevice =>
      'These items will be deleted from your device.';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      'It looks like something went wrong. Please retry after some time. If the error persists, please contact our support team.';

  @override
  String get error => 'Error';

  @override
  String get tempErrorContactSupportIfPersists =>
      'It looks like something went wrong. Please retry after some time. If the error persists, please contact our support team.';

  @override
  String get networkHostLookUpErr =>
      'Unable to connect to Ente, please check your network settings and contact support if the error persists.';

  @override
  String get networkConnectionRefusedErr =>
      'Unable to connect to Ente, please retry after sometime. If the error persists, please contact support.';

  @override
  String get cachedData => 'Cached data';

  @override
  String get clearCaches => 'Clear caches';

  @override
  String get remoteImages => 'Remote images';

  @override
  String get remoteVideos => 'Remote videos';

  @override
  String get remoteThumbnails => 'Remote thumbnails';

  @override
  String get pendingSync => 'Pending sync';

  @override
  String get localGallery => 'Local gallery';

  @override
  String get todaysLogs => 'Today\'s logs';

  @override
  String get viewLogs => 'View logs';

  @override
  String get logsDialogBody =>
      'This will send across logs to help us debug your issue. Please note that file names will be included to help track issues with specific files.';

  @override
  String get preparingLogs => 'Preparing logs...';

  @override
  String get emailYourLogs => 'Email your logs';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'Please send the logs to \n$toEmail';
  }

  @override
  String get copyEmailAddress => 'Copy email address';

  @override
  String get exportLogs => 'Export logs';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return 'Please email us at $toEmail';
  }

  @override
  String get dismiss => 'Dismiss';

  @override
  String get didYouKnow => 'Did you know?';

  @override
  String get loadingMessage => 'Loading your photos...';

  @override
  String get loadMessage1 => 'You can share your subscription with your family';

  @override
  String get loadMessage2 =>
      'We have preserved over 200 million memories so far';

  @override
  String get loadMessage3 =>
      'We keep 3 copies of your data, one in an underground fallout shelter';

  @override
  String get loadMessage4 => 'All our apps are open source';

  @override
  String get loadMessage5 =>
      'Our source code and cryptography have been externally audited';

  @override
  String get loadMessage6 =>
      'You can share links to your albums with your loved ones';

  @override
  String get loadMessage7 =>
      'Our mobile apps run in the background to encrypt and backup any new photos you click';

  @override
  String get loadMessage8 => 'web.ente.io has a slick uploader';

  @override
  String get loadMessage9 =>
      'We use Xchacha20Poly1305 to safely encrypt your data';

  @override
  String get photoDescriptions => 'Photo descriptions';

  @override
  String get fileTypesAndNames => 'File types and names';

  @override
  String get location => 'Location';

  @override
  String get moments => 'Moments';

  @override
  String get searchFaceEmptySection =>
      'People will be shown here once indexing is done';

  @override
  String get searchDatesEmptySection => 'Search by a date, month or year';

  @override
  String get searchLocationEmptySection =>
      'Group photos that are taken within some radius of a photo';

  @override
  String get searchPeopleEmptySection =>
      'Invite people, and you\'ll see all photos shared by them here';

  @override
  String get searchAlbumsEmptySection => 'Albums';

  @override
  String get searchFileTypesAndNamesEmptySection => 'File types and names';

  @override
  String get searchCaptionEmptySection =>
      'Add descriptions like \"#trip\" in photo info to quickly find them here';

  @override
  String get language => 'Language';

  @override
  String get selectLanguage => 'Select Language';

  @override
  String get locationName => 'Location name';

  @override
  String get addLocation => 'Add location';

  @override
  String get groupNearbyPhotos => 'Group nearby photos';

  @override
  String get kiloMeterUnit => 'km';

  @override
  String get addLocationButton => 'Add';

  @override
  String get radius => 'Radius';

  @override
  String get locationTagFeatureDescription =>
      'A location tag groups all photos that were taken within some radius of a photo';

  @override
  String get galleryMemoryLimitInfo => 'Up to 1000 memories shown in gallery';

  @override
  String get save => 'Save';

  @override
  String get centerPoint => 'Center point';

  @override
  String get pickCenterPoint => 'Pick center point';

  @override
  String get useSelectedPhoto => 'Use selected photo';

  @override
  String get resetToDefault => 'Reset to default';

  @override
  String get edit => 'Edit';

  @override
  String get deleteLocation => 'Delete location';

  @override
  String get rotateLeft => 'Rotate left';

  @override
  String get flip => 'Flip';

  @override
  String get rotateRight => 'Rotate right';

  @override
  String get saveCopy => 'Save copy';

  @override
  String get light => 'Light';

  @override
  String get color => 'Color';

  @override
  String get yesDiscardChanges => 'Yes, discard changes';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade =>
      'Do you want to discard the edits you have made?';

  @override
  String get saving => 'Saving...';

  @override
  String get editsSaved => 'Edits saved';

  @override
  String get oopsCouldNotSaveEdits => 'Oops, could not save edits';

  @override
  String get distanceInKMUnit => 'km';

  @override
  String get dayToday => 'Today';

  @override
  String get dayYesterday => 'Yesterday';

  @override
  String get storage => 'Storage';

  @override
  String get usedSpace => 'Used space';

  @override
  String get storageBreakupFamily => 'Family';

  @override
  String get storageBreakupYou => 'You';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return '$usedAmount $usedStorageUnit of $totalAmount $totalStorageUnit used';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return '$freeAmount $storageUnit free';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'Version: $versionValue';
  }

  @override
  String get verifyIDLabel => 'Verify';

  @override
  String get fileInfoAddDescHint => 'Add a description...';

  @override
  String get editLocationTagTitle => 'Edit location';

  @override
  String get setLabel => 'Set';

  @override
  String get setRadius => 'Set radius';

  @override
  String get familyPlanPortalTitle => 'Family';

  @override
  String get familyPlanOverview =>
      'Add 5 family members to your existing plan without paying extra.\n\nEach member gets their own private space, and cannot see each other\'s files unless they\'re shared.\n\nFamily plans are available to customers who have a paid Ente subscription.\n\nSubscribe now to get started!';

  @override
  String get androidBiometricHint => 'Verify identity';

  @override
  String get androidBiometricNotRecognized => 'Not recognized. Try again.';

  @override
  String get androidBiometricSuccess => 'Success';

  @override
  String get androidCancelButton => 'Cancel';

  @override
  String get androidSignInTitle => 'Authentication required';

  @override
  String get androidBiometricRequiredTitle => 'Biometric required';

  @override
  String get androidDeviceCredentialsRequiredTitle =>
      'Device credentials required';

  @override
  String get androidDeviceCredentialsSetupDescription =>
      'Device credentials required';

  @override
  String get goToSettings => 'Go to settings';

  @override
  String get androidGoToSettingsDescription =>
      'Biometric authentication is not set up on your device. Go to \'Settings > Security\' to add biometric authentication.';

  @override
  String get iOSLockOut =>
      'Autentifikazio biometrikoa deuseztatuta dago. Mesedez, blokeatu eta desblokeatu zure pantaila indarrean jartzeko.';

  @override
  String get iOSGoToSettingsDescription =>
      'Biometric authentication is not set up on your device. Please either enable Touch ID or Face ID on your phone.';

  @override
  String get iOSOkButton => 'OK';

  @override
  String get openstreetmapContributors => 'OpenStreetMap contributors';

  @override
  String get hostedAtOsmFrance => 'Hosted at OSM France';

  @override
  String get map => 'Map';

  @override
  String get maps => 'Maps';

  @override
  String get mapsPrivacyNotice =>
      'Approximate coordinates will be sent to privacy conscious third parties like OpenStreetMap to show the map and location.';

  @override
  String get enableMaps => 'Enable Maps';

  @override
  String get quickLinks => 'Quick links';

  @override
  String get selectItemsToAdd => 'Select items to add';

  @override
  String get addSelected => 'Add selected';

  @override
  String get addFromDevice => 'Add from device';

  @override
  String get addPhotos => 'Add photos';

  @override
  String get noPhotosFoundHere => 'No photos found here';

  @override
  String get zoomOutToSeePhotos => 'Zoom out to see photos';

  @override
  String get noImagesWithLocation => 'No images with location';

  @override
  String get unpinAlbum => 'Unpin album';

  @override
  String get pinAlbum => 'Pin album';

  @override
  String get pin => 'Pin';

  @override
  String get pinPerson => 'Pin person';

  @override
  String get pinToTop => 'Pin to top';

  @override
  String get unpin => 'Unpin';

  @override
  String get unpinPerson => 'Unpin person';

  @override
  String get visibility => 'Visibility';

  @override
  String get hideFromMemories => 'Hide from memories';

  @override
  String get showInMemories => 'Show in memories';

  @override
  String get create => 'Create';

  @override
  String get viewAll => 'View all';

  @override
  String get nothingSharedWithYouYet => 'Nothing shared with you yet';

  @override
  String get noAlbumsSharedByYouYet => 'No albums shared by you yet';

  @override
  String get sharedWithYou => 'Shared with you';

  @override
  String get sharedByYou => 'Shared by you';

  @override
  String get inviteYourFriendsToEnte => 'Invite your friends to Ente';

  @override
  String get failedToDownloadVideo => 'Failed to download video';

  @override
  String get hiding => 'Hiding...';

  @override
  String get unhiding => 'Unhiding...';

  @override
  String get successfullyHid => 'Successfully hid';

  @override
  String get successfullyUnhid => 'Successfully unhid';

  @override
  String get crashReporting => 'Crash reporting';

  @override
  String get resumableUploads => 'Resumable uploads';

  @override
  String get addToHiddenAlbum => 'Add to hidden album';

  @override
  String get moveToHiddenAlbum => 'Move to hidden album';

  @override
  String get fileTypes => 'File types';

  @override
  String get deleteConfirmDialogBody =>
      'This account is linked to other Ente apps, if you use any. Your uploaded data, across all Ente apps, will be scheduled for deletion, and your account will be permanently deleted.';

  @override
  String get hearUsWhereTitle => 'How did you hear about Ente? (optional)';

  @override
  String get hearUsExplanation =>
      'We don\'t track app installs. It\'d help if you told us where you found us!';

  @override
  String get viewAddOnButton => 'View add-ons';

  @override
  String get addOns => 'Add-ons';

  @override
  String get addOnPageSubtitle => 'Details of add-ons';

  @override
  String get yourMap => 'Your map';

  @override
  String get modifyYourQueryOrTrySearchingFor =>
      'Modify your query, or try searching for';

  @override
  String get blackFridaySale => 'Black Friday Sale';

  @override
  String get upto50OffUntil4thDec => 'Upto 50% off, until 4th Dec.';

  @override
  String get photos => 'Photos';

  @override
  String get videos => 'Videos';

  @override
  String get livePhotos => 'Live Photos';

  @override
  String get searchHint1 => 'Fast, on-device search';

  @override
  String get searchHint2 => 'Photo dates, descriptions';

  @override
  String get searchHint3 => 'Albums, file names, and types';

  @override
  String get searchHint4 => 'Location';

  @override
  String get searchHint5 => 'Coming soon: Faces & magic search ✨';

  @override
  String get addYourPhotosNow => 'Add your photos now';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count results found',
      one: '$count result found',
    );
    return '$_temp0';
  }

  @override
  String get faces => 'Faces';

  @override
  String get people => 'People';

  @override
  String get contents => 'Contents';

  @override
  String get addNew => 'Add new';

  @override
  String get contacts => 'Contacts';

  @override
  String get noInternetConnection => 'No internet connection';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'Please check your internet connection and try again.';

  @override
  String get signOutFromOtherDevices => 'Sign out from other devices';

  @override
  String get signOutOtherBody =>
      'If you think someone might know your password, you can force all other devices using your account to sign out.';

  @override
  String get signOutOtherDevices => 'Sign out other devices';

  @override
  String get doNotSignOut => 'Do not sign out';

  @override
  String get editLocation => 'Edit location';

  @override
  String get selectALocation => 'Select a location';

  @override
  String get selectALocationFirst => 'Select a location first';

  @override
  String get changeLocationOfSelectedItems =>
      'Change location of selected items?';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte =>
      'Edits to location will only be seen within Ente';

  @override
  String get cleanUncategorized => 'Clean Uncategorized';

  @override
  String get cleanUncategorizedDescription =>
      'Remove all files from Uncategorized that are present in other albums';

  @override
  String get waitingForVerification => 'Waiting for verification...';

  @override
  String get passkey => 'Passkey';

  @override
  String get passkeyAuthTitle => 'Passkey verification';

  @override
  String get loginWithTOTP => 'Login with TOTP';

  @override
  String get passKeyPendingVerification => 'Verification is still pending';

  @override
  String get loginSessionExpired => 'Session expired';

  @override
  String get loginSessionExpiredDetails =>
      'Your session has expired. Please login again.';

  @override
  String get verifyPasskey => 'Verify passkey';

  @override
  String get playOnTv => 'Play album on TV';

  @override
  String get pair => 'Pair';

  @override
  String get deviceNotFound => 'Device not found';

  @override
  String get castInstruction =>
      'Visit cast.ente.io on the device you want to pair.\n\nEnter the code below to play the album on your TV.';

  @override
  String get deviceCodeHint => 'Enter the code';

  @override
  String get joinDiscord => 'Join Discord';

  @override
  String get locations => 'Locations';

  @override
  String get addAName => 'Add a name';

  @override
  String get findThemQuickly => 'Find them quickly';

  @override
  String get findPeopleByName => 'Find people quickly by name';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add viewers',
      one: 'Add viewer',
      zero: 'Add viewer',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add collaborators',
      one: 'Add collaborator',
      zero: 'Add collaborator',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      'Long press an email to verify end to end encryption.';

  @override
  String get developerSettingsWarning =>
      'Are you sure that you want to modify Developer settings?';

  @override
  String get developerSettings => 'Developer settings';

  @override
  String get serverEndpoint => 'Server endpoint';

  @override
  String get invalidEndpoint => 'Invalid endpoint';

  @override
  String get invalidEndpointMessage =>
      'Sorry, the endpoint you entered is invalid. Please enter a valid endpoint and try again.';

  @override
  String get endpointUpdatedMessage => 'Endpoint updated successfully';

  @override
  String customEndpoint({required Object endpoint}) {
    return 'Connected to $endpoint';
  }

  @override
  String get createCollaborativeLink => 'Create collaborative link';

  @override
  String get search => 'Search';

  @override
  String get enterPersonName => 'Enter person name';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'This email is already linked to $name.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return 'View $name to unlink';
  }

  @override
  String get enterName => 'Enter name';

  @override
  String get savePerson => 'Save person';

  @override
  String get editPerson => 'Edit person';

  @override
  String get mergedPhotos => 'Merged photos';

  @override
  String get orMergeWithExistingPerson => 'Or merge with existing';

  @override
  String get enterDateOfBirth => 'Birthday (optional)';

  @override
  String get birthday => 'Birthday';

  @override
  String get removePersonLabel => 'Remove person label';

  @override
  String get removePersonTag => 'Remove person tag';

  @override
  String get areYouSureRemoveThisPersonTag =>
      'Are you sure you want to remove this person tag?';

  @override
  String get autoPairDesc =>
      'Auto pair works only with devices that support Chromecast.';

  @override
  String get manualPairDesc =>
      'Pair with PIN works with any screen you wish to view your album on.';

  @override
  String get connectToDevice => 'Connect to device';

  @override
  String get autoCastDialogBody => 'You\'ll see available Cast devices here.';

  @override
  String get autoCastiOSPermission =>
      'Make sure Local Network permissions are turned on for the Ente Photos app, in Settings.';

  @override
  String get noDeviceFound => 'No device found';

  @override
  String get stopCastingTitle => 'Stop casting';

  @override
  String get stopCastingBody => 'Do you want to stop casting?';

  @override
  String get castIPMismatchTitle => 'Failed to cast album';

  @override
  String get castIPMismatchBody =>
      'Please make sure you are on the same network as the TV.';

  @override
  String get pairingComplete => 'Pairing complete';

  @override
  String get savingEdits => 'Saving edits...';

  @override
  String get autoPair => 'Auto pair';

  @override
  String get pairWithPin => 'Pair with PIN';

  @override
  String get faceRecognition => 'Face recognition';

  @override
  String get foundFaces => 'Found faces';

  @override
  String get clusteringProgress => 'Clustering progress';

  @override
  String get trim => 'Trim';

  @override
  String get crop => 'Crop';

  @override
  String get rotate => 'Rotate';

  @override
  String get left => 'Left';

  @override
  String get right => 'Right';

  @override
  String get whatsNew => 'What\'s new';

  @override
  String get reviewSuggestions => 'Review suggestions';

  @override
  String get review => 'Review';

  @override
  String get useAsCover => 'Use as cover';

  @override
  String notPersonLabel({required String name}) {
    return 'Not $name?';
  }

  @override
  String get enable => 'Enable';

  @override
  String get enabled => 'Enabled';

  @override
  String get moreDetails => 'More details';

  @override
  String get enableMLIndexingDesc =>
      'Ente supports on-device machine learning for face recognition, magic search and other advanced search features';

  @override
  String get magicSearchHint =>
      'Magic search allows to search photos by their contents, e.g. \'flower\', \'red car\', \'identity documents\'';

  @override
  String get panorama => 'Panorama';

  @override
  String get reenterPassword => 'Re-enter password';

  @override
  String get reenterPin => 'Re-enter PIN';

  @override
  String get deviceLock => 'Device lock';

  @override
  String get pinLock => 'PIN lock';

  @override
  String get next => 'Next';

  @override
  String get setNewPassword => 'Set new password';

  @override
  String get enterPin => 'Enter PIN';

  @override
  String get setNewPin => 'Set new PIN';

  @override
  String get appLock => 'App lock';

  @override
  String get noSystemLockFound => 'No system lock found';

  @override
  String get tapToUnlock => 'Tap to unlock';

  @override
  String get tooManyIncorrectAttempts => 'Too many incorrect attempts';

  @override
  String get videoInfo => 'Video Info';

  @override
  String get autoLock => 'Auto lock';

  @override
  String get immediately => 'Immediately';

  @override
  String get autoLockFeatureDescription =>
      'Time after which the app locks after being put in the background';

  @override
  String get hideContent => 'Hide content';

  @override
  String get hideContentDescriptionAndroid =>
      'Hides app content in the app switcher and disables screenshots';

  @override
  String get hideContentDescriptionIos =>
      'Hides app content in the app switcher';

  @override
  String get passwordStrengthInfo =>
      'Password strength is calculated considering the length of the password, used characters, and whether or not the password appears in the top 10,000 most used passwords';

  @override
  String get noQuickLinksSelected => 'No quick links selected';

  @override
  String get pleaseSelectQuickLinksToRemove =>
      'Please select quick links to remove';

  @override
  String get removePublicLinks => 'Remove public links';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      'This will remove public links of all selected quick links.';

  @override
  String get guestView => 'Guest view';

  @override
  String get guestViewEnablePreSteps =>
      'To enable guest view, please setup device passcode or screen lock in your system settings.';

  @override
  String get nameTheAlbum => 'Name the album';

  @override
  String get collectPhotosDescription =>
      'Create a link where your friends can upload photos in original quality.';

  @override
  String get collect => 'Collect';

  @override
  String get appLockDescriptions =>
      'Choose between your device\'s default lock screen and a custom lock screen with a PIN or password.';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'To enable app lock, please setup device passcode or screen lock in your system settings.';

  @override
  String get authToViewPasskey => 'Please authenticate to view your passkey';

  @override
  String get loopVideoOn => 'Disable looping';

  @override
  String get loopVideoOff => 'Enable looping';

  @override
  String get localSyncErrorMessage =>
      'Looks like something went wrong since local photos sync is taking more time than expected. Please reach out to our support team';

  @override
  String get showPerson => 'Show person';

  @override
  String get sort => 'Sort';

  @override
  String get mostRecent => 'Most recent';

  @override
  String get mostRelevant => 'Most relevant';

  @override
  String get loadingYourPhotos => 'Loading your photos...';

  @override
  String processingImport({required Object folderName}) {
    return 'Processing $folderName...';
  }

  @override
  String get personName => 'Person name';

  @override
  String get addPerson => 'Add person';

  @override
  String get addToPerson => 'Add to person';

  @override
  String get pleaseNamePersonInPeopleSectionFirst =>
      'Please name a person in the People section first';

  @override
  String get onlyUploadedFilesCanBeAddedToPerson =>
      'Only uploaded files can be added to a person';

  @override
  String get noFacesDetectedTapToAdd => 'No faces detected, tap to add.';

  @override
  String addedFilesToPerson({required int count, required String personName}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count files to $personName',
      one: 'Added 1 file to $personName',
    );
    return '$_temp0';
  }

  @override
  String filesAlreadyLinkedToPerson({
    required int count,
    required String personName,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count files are already linked to $personName',
      one: '1 file is already linked to $personName',
    );
    return '$_temp0';
  }

  @override
  String get addNewPerson => 'Add new person';

  @override
  String get addNameOrMerge => 'Add name or merge';

  @override
  String get mergeWithExisting => 'Merge with existing';

  @override
  String get newPerson => 'New person';

  @override
  String get addName => 'Add name';

  @override
  String get add => 'Add';

  @override
  String extraPhotosFoundFor({required String text}) {
    return 'Extra photos found for $text';
  }

  @override
  String get extraPhotosFound => 'Extra photos found';

  @override
  String get configuration => 'Configuration';

  @override
  String get localIndexing => 'Local indexing';

  @override
  String get processed => 'Processed';

  @override
  String get resetPerson => 'Remove';

  @override
  String get areYouSureYouWantToResetThisPerson =>
      'Are you sure you want to reset this person?';

  @override
  String get allPersonGroupingWillReset =>
      'All groupings for this person will be reset, and you will lose all suggestions made for this person';

  @override
  String get yesResetPerson => 'Yes, reset person';

  @override
  String get onlyThem => 'Only them';

  @override
  String get checkingModels => 'Checking models...';

  @override
  String get enableMachineLearningBanner =>
      'Enable machine learning for magic search and face recognition';

  @override
  String get searchDiscoverEmptySection =>
      'Images will be shown here once processing and syncing is complete';

  @override
  String get searchPersonsEmptySection =>
      'People will be shown here once processing and syncing is complete';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count viewers',
      one: 'Added 1 viewer',
      zero: 'Added 0 viewers',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count collaborators',
      one: 'Added 1 collaborator',
      zero: 'Added 0 collaborator',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured => 'Account is already configured.';

  @override
  String get sessionIdMismatch => 'Session ID mismatch';

  @override
  String get failedToFetchActiveSessions => 'Failed to fetch active sessions';

  @override
  String get failedToRefreshStripeSubscription =>
      'Failed to refresh subscription';

  @override
  String get failedToPlayVideo => 'Failed to play video';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return 'Upload is ignored due to $ignoreReason';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'Type of gallery $galleryType is not supported for rename';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'Tap to upload, upload is currently ignored due to $ignoreReason';
  }

  @override
  String get tapToUpload => 'Tap to upload';

  @override
  String get info => 'Info';

  @override
  String get addFiles => 'Add Files';

  @override
  String get castAlbum => 'Cast album';

  @override
  String get imageNotAnalyzed => 'Image not analyzed';

  @override
  String get noFacesFound => 'No faces found';

  @override
  String get fileNotUploadedYet => 'File not uploaded yet';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return 'No suggestions for $personName';
  }

  @override
  String get month => 'month';

  @override
  String get yearShort => 'yr';

  @override
  String get currentlyRunning => 'currently running';

  @override
  String get ignored => 'ignored';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count photos',
      one: '1 photo',
      zero: '0 photos',
    );
    return '$_temp0';
  }

  @override
  String get file => 'File';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'Sections length mismatch: $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'Select mail app';

  @override
  String get selectAllShort => 'All';

  @override
  String get selectCoverPhoto => 'Select cover photo';

  @override
  String get newLocation => 'New location';

  @override
  String get faceNotClusteredYet =>
      'Face not clustered yet, please come back later';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'The link you are trying to access has expired.';

  @override
  String get openFile => 'Open file';

  @override
  String get backupFile => 'Backup file';

  @override
  String get openAlbumInBrowser => 'Open album in browser';

  @override
  String get openAlbumInBrowserTitle =>
      'Please use the web app to add photos to this album';

  @override
  String get allow => 'Allow';

  @override
  String get allowAppToOpenSharedAlbumLinks =>
      'Allow app to open shared album links';

  @override
  String get seePublicAlbumLinksInApp => 'See public album links in app';

  @override
  String get emergencyContacts => 'Emergency Contacts';

  @override
  String get acceptTrustInvite => 'Accept Invite';

  @override
  String get declineTrustInvite => 'Decline Invite';

  @override
  String get removeYourselfAsTrustedContact =>
      'Remove yourself as trusted contact';

  @override
  String get legacy => 'Legacy';

  @override
  String get legacyPageDesc =>
      'Legacy allows trusted contacts to access your account in your absence.';

  @override
  String get legacyPageDesc2 =>
      'Trusted contacts can initiate account recovery, and if not blocked within 30 days, reset your password and access your account.';

  @override
  String get legacyAccounts => 'Legacy accounts';

  @override
  String get trustedContacts => 'Trusted contacts';

  @override
  String get addTrustedContact => 'Add Trusted Contact';

  @override
  String get removeInvite => 'Remove invite';

  @override
  String get recoveryWarning =>
      'A trusted contact is trying to access your account';

  @override
  String get rejectRecovery => 'Reject recovery';

  @override
  String get recoveryInitiated => 'Recovery initiated';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return 'You can access the account after $days days. A notification will be sent to $email.';
  }

  @override
  String get cancelAccountRecovery => 'Cancel recovery';

  @override
  String get recoveryAccount => 'Recover account';

  @override
  String get cancelAccountRecoveryBody =>
      'Are you sure you want to cancel recovery?';

  @override
  String get startAccountRecoveryTitle => 'Start recovery';

  @override
  String get whyAddTrustContact =>
      'Trusted contact can help in recovering your data.';

  @override
  String recoveryReady({required String email}) {
    return 'You can now recover $email\'s account by setting a new password.';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email is trying to recover your account.';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return 'You have been invited to be a legacy contact by $email.';
  }

  @override
  String get warning => 'Warning';

  @override
  String get proceed => 'Proceed';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return 'You are about to add $email as a trusted contact. They will be able to recover your account if you are absent for $numOfDays days.';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email has invited you to be a trusted contact';
  }

  @override
  String get authToManageLegacy =>
      'Please authenticate to manage your trusted contacts';

  @override
  String get hideSharedItemsFromHomeGallery =>
      'Hide shared items from home gallery';

  @override
  String get swipeToSelect => 'Swipe to select';

  @override
  String get gallery => 'Gallery';

  @override
  String get joinAlbum => 'Join album';

  @override
  String get joinAlbumSubtext => 'to view and add your photos';

  @override
  String get joinAlbumSubtextViewer => 'to add this to shared albums';

  @override
  String get join => 'Join';

  @override
  String get linkEmail => 'Link email';

  @override
  String get link => 'Link';

  @override
  String get noEnteAccountExclamation => 'No Ente account!';

  @override
  String get orPickFromYourContacts => 'or pick from your contacts';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return '$email does not have an Ente account.';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (Me)';
  }

  @override
  String get reassignMe => 'Reassign \"Me\"';

  @override
  String get me => 'Me';

  @override
  String get linkEmailToContactBannerCaption => 'for faster sharing';

  @override
  String get selectPersonToLink => 'Select person to link';

  @override
  String linkPersonToEmail({required String email}) {
    return 'Link person to $email';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return 'This will link $personName to $email';
  }

  @override
  String get selectYourFace => 'Select your face';

  @override
  String get reassigningLoading => 'Reassigning...';

  @override
  String reassignedToName({required String name}) {
    return 'Reassigned you to $name';
  }

  @override
  String get saveChangesBeforeLeavingQuestion => 'Save changes before leaving?';

  @override
  String get dontSave => 'Don\'t save';

  @override
  String get thisIsMeExclamation => 'This is me!';

  @override
  String get linkPerson => 'Link person';

  @override
  String get linkPersonCaption => 'for better sharing experience';

  @override
  String get videoStreaming => 'Streamable videos';

  @override
  String get processingVideos => 'Processing videos';

  @override
  String get streamDetails => 'Stream details';

  @override
  String get processing => 'Processing';

  @override
  String get queued => 'Queued';

  @override
  String get ineligible => 'Ineligible';

  @override
  String get failed => 'Failed';

  @override
  String get playStream => 'Play stream';

  @override
  String get playOriginal => 'Play original';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'Joining an album will make your email visible to its participants.';

  @override
  String get pleaseWaitThisWillTakeAWhile =>
      'Please wait, this will take a while.';

  @override
  String get editTime => 'Edit time';

  @override
  String get selectTime => 'Select time';

  @override
  String get selectDate => 'Select date';

  @override
  String get previous => 'Previous';

  @override
  String get selectOneDateAndTimeForAll => 'Select one date and time for all';

  @override
  String get selectStartOfRange => 'Select start of range';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      'This will make the date and time of all selected photos the same.';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'This is the first in the group. Other selected photos will automatically shift based on this new date';

  @override
  String get newRange => 'New range';

  @override
  String get selectOneDateAndTime => 'Select one date and time';

  @override
  String get moveSelectedPhotosToOneDate => 'Move selected photos to one date';

  @override
  String get shiftDatesAndTime => 'Shift dates and time';

  @override
  String get photosKeepRelativeTimeDifference =>
      'Photos keep relative time difference';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count photos',
      one: '1 photo',
      zero: 'No photos',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'App icon';

  @override
  String get notThisPerson => 'Not this person?';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      'Selected items will be removed from this person, but not deleted from your library.';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat through the years';
  }

  @override
  String get thisWeekThroughTheYears => 'This week through the years';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'This week, $count years ago',
      one: 'This week, $count year ago',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'You and $name';
  }

  @override
  String admiringThem({required Object name}) {
    return 'Admiring $name';
  }

  @override
  String embracingThem({required Object name}) {
    return 'Embracing $name';
  }

  @override
  String partyWithThem({required Object name}) {
    return 'Party with $name';
  }

  @override
  String hikingWithThem({required Object name}) {
    return 'Hiking with $name';
  }

  @override
  String feastingWithThem({required Object name}) {
    return 'Feasting with $name';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return 'Selfies with $name';
  }

  @override
  String posingWithThem({required Object name}) {
    return 'Posing with $name';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return 'Beautiful views with $name';
  }

  @override
  String sportsWithThem({required Object name}) {
    return 'Sports with $name';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return 'Road trip with $name';
  }

  @override
  String get spotlightOnYourself => 'Spotlight on yourself';

  @override
  String spotlightOnThem({required Object name}) {
    return 'Spotlight on $name';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$name is $age!';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name turning $age soon';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return 'Last time with $name';
  }

  @override
  String tripToLocation({required Object location}) {
    return 'Trip to $location';
  }

  @override
  String tripInYear({required Object year}) {
    return 'Trip in $year';
  }

  @override
  String get lastYearsTrip => 'Last year\'s trip';

  @override
  String get sunrise => 'On the horizon';

  @override
  String get mountains => 'Over the hills';

  @override
  String get greenery => 'The green life';

  @override
  String get beach => 'Sand and sea';

  @override
  String get city => 'In the city';

  @override
  String get moon => 'In the moonlight';

  @override
  String get onTheRoad => 'On the road again';

  @override
  String get food => 'Culinary delight';

  @override
  String get pets => 'Furry companions';

  @override
  String get curatedMemories => 'Curated memories';

  @override
  String get widgets => 'Widgets';

  @override
  String get memories => 'Memories';

  @override
  String get peopleWidgetDesc =>
      'Select the people you wish to see on your homescreen.';

  @override
  String get albumsWidgetDesc =>
      'Select the albums you wish to see on your homescreen.';

  @override
  String get memoriesWidgetDesc =>
      'Select the kind of memories you wish to see on your homescreen.';

  @override
  String get smartMemories => 'Smart memories';

  @override
  String get pastYearsMemories => 'Past years\' memories';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return 'Also delete the photos (and videos) present in these $count albums from <bold>all</bold> other albums they are part of?';
  }

  @override
  String get addParticipants => 'Add participants';

  @override
  String selectedAlbums({required Object count}) {
    return '$count selected';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'Action not supported on Favourites album';

  @override
  String get onThisDayMemories => 'On this day memories';

  @override
  String get onThisDay => 'On this day';

  @override
  String get lookBackOnYourMemories => 'Look back on your memories 🌄';

  @override
  String get newPhotosEmoji => ' new 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'Sorry, we had to pause your backups';

  @override
  String get clickToInstallOurBestVersionYet =>
      'Click to install our best version yet';

  @override
  String get onThisDayNotificationExplanation =>
      'Receive reminders about memories from this day in previous years.';

  @override
  String get addMemoriesWidgetPrompt =>
      'Add a memories widget to your homescreen and come back here to customize.';

  @override
  String get addAlbumWidgetPrompt =>
      'Add an album widget to your homescreen and come back here to customize.';

  @override
  String get addPeopleWidgetPrompt =>
      'Add a people widget to your homescreen and come back here to customize.';

  @override
  String get birthdayNotifications => 'Birthday notifications';

  @override
  String get receiveRemindersOnBirthdays =>
      'Receive reminders when it\'s someone\'s birthday. Tapping on the notification will take you to photos of the birthday person.';

  @override
  String get happyBirthday => 'Happy birthday! 🥳';

  @override
  String get birthdays => 'Birthdays';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return 'Wish $name a happy birthday! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      'Are you sure you want to remove this face from this person?';

  @override
  String get otherDetectedFaces => 'Other detected faces';

  @override
  String get areThey => 'Are they ';

  @override
  String get questionmark => '?';

  @override
  String get saveAsAnotherPerson => 'Save as another person';

  @override
  String get showLessFaces => 'Show less faces';

  @override
  String get showMoreFaces => 'Show more faces';

  @override
  String get ignore => 'Ignore';

  @override
  String get merge => 'Merge';

  @override
  String get reset => 'Reset';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      'Are you sure you want to ignore this person?';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      'Are you sure you want to ignore these persons?';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'The person groups will not be displayed in the people section anymore. Photos will remain untouched.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'The person will not be displayed in the people section anymore. Photos will remain untouched.';

  @override
  String get areYouSureYouWantToMergeThem =>
      'Are you sure you want to merge them?';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'All unnamed groups will be merged into the selected person. This can still be undone from the suggestions history overview of the person.';

  @override
  String get yesIgnore => 'Yes, ignore';

  @override
  String get same => 'Same';

  @override
  String get different => 'Different';

  @override
  String get sameperson => 'Same person?';

  @override
  String get indexingPausedStatusDescription =>
      'Indexing is paused. It will automatically resume when the device is ready. The device is considered ready when its battery level, battery health, and thermal status are within a healthy range.';

  @override
  String get thisWeek => 'This week';

  @override
  String get lastWeek => 'Last week';

  @override
  String get thisMonth => 'This month';

  @override
  String get thisYear => 'This year';

  @override
  String get groupBy => 'Group by';

  @override
  String get faceThumbnailGenerationFailed =>
      'Unable to generate face thumbnails';

  @override
  String get fileAnalysisFailed => 'Unable to analyze file';

  @override
  String get editAutoAddPeople => 'Edit auto-add people';

  @override
  String get autoAddPeople => 'Auto-add people';

  @override
  String get autoAddToAlbum => 'Auto-add to album';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      'Should the files related to the person that were previously selected in smart albums be removed?';

  @override
  String get addingPhotos => 'Adding photos';

  @override
  String get gettingReady => 'Getting ready';

  @override
  String get addSomePhotosDesc1 => 'Add some photos or pick ';

  @override
  String get addSomePhotosDesc2 => 'familiar faces';

  @override
  String get addSomePhotosDesc3 => '\nto begin with';

  @override
  String get ignorePerson => 'Ignore person';

  @override
  String get mixedGrouping => 'Mixed grouping?';

  @override
  String get analysis => 'Analysis';

  @override
  String get doesGroupContainMultiplePeople =>
      'Does this grouping contain multiple people?';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'We will automatically analyze the grouping to determine if there are multiple people present, and separate them out again. This may take a few seconds.';

  @override
  String get layout => 'Layout';

  @override
  String get day => 'Day';

  @override
  String get undo => 'Undo';

  @override
  String get redo => 'Redo';

  @override
  String get filter => 'Filter';

  @override
  String get adjust => 'Adjust';

  @override
  String get draw => 'Draw';

  @override
  String get sticker => 'Sticker';

  @override
  String get brushColor => 'Brush Color';

  @override
  String get font => 'Font';

  @override
  String get background => 'Background';

  @override
  String get align => 'Align';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added successfully to $count albums',
      one: 'Added successfully to 1 album',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => 'Videos processed';

  @override
  String get totalVideos => 'Total videos';

  @override
  String get skippedVideos => 'Skipped videos';

  @override
  String get videoStreamingDescriptionLine1 =>
      'Play videos instantly on any device.';

  @override
  String get videoStreamingDescriptionLine2 =>
      'Enable to process video streams on this device.';

  @override
  String get videoStreamingNote =>
      'Only videos from last 60 days and under 1 minute are processed on this device. For older/longer videos, enable streaming in the desktop app.';

  @override
  String get createStream => 'Create stream';

  @override
  String get recreateStream => 'Recreate stream';

  @override
  String get addedToStreamCreationQueue => 'Added to stream creation queue';

  @override
  String get addedToStreamRecreationQueue => 'Added to stream recreation queue';

  @override
  String get videoPreviewAlreadyExists => 'Video preview already exists';

  @override
  String get videoAlreadyInQueue => 'Video file already present in the queue';

  @override
  String get videoExportFailed => 'Video creation failed. Please try again.';

  @override
  String videoExportSuccess({required String path}) {
    return 'Video successfully created at $path';
  }

  @override
  String get addedToQueue => 'Added to queue';

  @override
  String get creatingStream => 'Creating stream';

  @override
  String get similarImages => 'Similar images';

  @override
  String get findSimilarImages => 'Find similar images';

  @override
  String get noSimilarImagesFound => 'No similar images found';

  @override
  String get yourPhotosLookUnique => 'Your photos look unique';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count groups found',
      one: '$count group found',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages => 'Review and remove similar images';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return 'Delete $count photos ($size)';
  }

  @override
  String get selectionOptions => 'Selection options';

  @override
  String selectExactWithCount({required int count}) {
    return 'Exactly similar ($count)';
  }

  @override
  String get selectExact => 'Select exact';

  @override
  String selectSimilarWithCount({required int count}) {
    return 'Mostly similar ($count)';
  }

  @override
  String get selectSimilar => 'Select similar';

  @override
  String selectAllWithCount({required int count}) {
    return 'All similarities ($count)';
  }

  @override
  String get selectSimilarImagesTitle => 'Select similar images';

  @override
  String get chooseSimilarImagesToSelect =>
      'Select images based on their visual similarity';

  @override
  String get clearSelection => 'Clear selection';

  @override
  String similarImagesCount({required int count}) {
    return '$count similar images';
  }

  @override
  String deleteWithCount({required int count}) {
    return 'Delete ($count)';
  }

  @override
  String get deleteFiles => 'Delete files';

  @override
  String get areYouSureDeleteFiles =>
      'Are you sure you want to delete these files?';

  @override
  String get greatJob => 'Great job!';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return 'You freed up $size of space';
  }

  @override
  String get size => 'Size';

  @override
  String get similarity => 'Similarity';

  @override
  String get analyzingPhotosLocally => 'Analyzing your photos locally...';

  @override
  String get lookingForVisualSimilarities =>
      'Looking for visual similarities...';

  @override
  String get comparingImageDetails => 'Comparing image details...';

  @override
  String get findingSimilarImages => 'Finding similar images...';

  @override
  String get almostDone => 'Almost done...';

  @override
  String get processingLocally => 'Processing locally';

  @override
  String get useMLToFindSimilarImages =>
      'Review and remove images that look similar to each other.';

  @override
  String get all => 'All';

  @override
  String get similar => 'Similar';

  @override
  String get identical => 'Identical';

  @override
  String get nothingHereTryAnotherFilter =>
      'Nothing here, try another filter! 👀';

  @override
  String get related => 'Related';

  @override
  String get hoorayyyy => 'Hoorayyyy!';

  @override
  String get nothingToTidyUpHere => 'Nothing to tidy up here';

  @override
  String get deletingDash => 'Deleting - ';

  @override
  String get cLTitle1 => 'Introducing Rituals';

  @override
  String get cLDesc1 =>
      'Planning resolutions for 2026? With Rituals, you can set a reminder on Ente Photos and track your progress by taking photos. Use it for workouts, eating habits, daily moments with loved ones—anything you want to make a habit.';

  @override
  String get cLTitle2 => 'Public links, now for everyone';

  @override
  String get cLDesc2 =>
      'All Ente users on the free plan can now create and share public links to photos and albums. To prevent abuse, links will have limits on how many people can view them.';

  @override
  String get cLTitle3 => 'Manually tag people';

  @override
  String get cLDesc3 =>
      'You can now tag people even when our on-device AI doesn\'t detect a face. Handy for pets, partially visible faces, or moments where someone isn\'t actually in the photo but should still be included.';

  @override
  String get cLTitle4 => 'And more';

  @override
  String get cLDesc4 =>
      'You can now pin shared albums. Album links are visible to collaborators and viewers to make sharing even easier. We\'ve fixed some iOS swiping bugs and updated the photo view, including a new favorite icon (making room for upcoming features).';

  @override
  String get closeBy => 'Close';

  @override
  String get peopleAutoAddDesc =>
      'Automatically add photos of the selected people to this album';

  @override
  String get festivities => 'Festive cheer';

  @override
  String get snowAdventures => 'Winter adventures';

  @override
  String get waterfalls => 'Chasing waterfalls';

  @override
  String get wildlife => 'Into the wild';

  @override
  String get flowers => 'Blooming beauties';

  @override
  String get nightLights => 'Neon nights';

  @override
  String get architecture => 'Design icons';

  @override
  String get autumnColors => 'Autumn splendor';

  @override
  String get desertDreams => 'Desert dreams';

  @override
  String get stargazing => 'Under the stars';

  @override
  String get lakeside => 'Lakeside calm';

  @override
  String get rainyDays => 'Rainy day feels';

  @override
  String get sportsAction => 'Game on';

  @override
  String get streetArt => 'Street art stories';

  @override
  String get familyMoments => 'Family time';

  @override
  String get fireworks => 'Firework finale';

  @override
  String get historicSites => 'Echoes of history';

  @override
  String get tropicalParadise => 'Tropical escapes';

  @override
  String get forestTrails => 'Forest strolls';

  @override
  String get citySunsets => 'City sunset glow';

  @override
  String get colorfulMarkets => 'Vibrant markets';

  @override
  String get cozyCafes => 'Cozy cafe corners';

  @override
  String get vintageVibes => 'Vintage vibes';

  @override
  String get aerialViews => 'Aerial perspectives';

  @override
  String get artisticPortraits => 'Artful portraits';

  @override
  String get streetFood => 'Street food bites';

  @override
  String get riverCruises => 'River cruise views';

  @override
  String get facesTimelineBannerTitle => 'Memory Lane';

  @override
  String facesTimelineBannerSubtitle({required String name}) {
    return 'See $name\'s photos across the years';
  }

  @override
  String get facesTimelineAppBarTitle => 'Memory lane';

  @override
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count years old',
      one: '$count year old',
    );
    return '$name was $_temp0';
  }

  @override
  String facesTimelineCaptionYearsAgo({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '# years ago',
      one: '# year ago',
    );
    return '$_temp0';
  }

  @override
  String get facesTimelineShareComingSoon => 'Video sharing coming soon';

  @override
  String get facesTimelinePlaybackPrevious => 'Previous';

  @override
  String get facesTimelinePlaybackNext => 'Next';

  @override
  String get facesTimelinePlaybackPlay => 'Play';

  @override
  String get facesTimelinePlaybackPause => 'Pause';

  @override
  String get facesTimelineUnavailable => 'Faces timeline is preparing...';

  @override
  String get playfulKids => 'Playful kids';

  @override
  String get coastalCliffs => 'Cliffs by the sea';

  @override
  String get ritualsTitle => 'Rituals';

  @override
  String get ritualAddTooltip => 'Add ritual';

  @override
  String get ritualActivityHeading => 'Activity';

  @override
  String get ritualDefaultHeatmapTitle => 'Take a photo every day';

  @override
  String get ritualUntitled => 'Untitled ritual';

  @override
  String get ritualShareUnavailable =>
      'Unable to share right now. Please try again.';

  @override
  String get ritualNotificationMessage => 'Take a photo now';

  @override
  String get ritualCameraNotFound => 'No camera found on this device.';

  @override
  String get ritualCameraStartError =>
      'Unable to start camera. Please check permissions.';

  @override
  String get ritualCaptureError => 'Unable to capture photo. Please try again.';

  @override
  String ritualPhotoLimit({required int maxPhotos}) {
    String _temp0 = intl.Intl.pluralLogic(
      maxPhotos,
      locale: localeName,
      other: '# photos.',
      one: '# photo.',
    );
    return 'You can add up to $_temp0';
  }

  @override
  String get ritualCaptureAtLeastOne => 'Capture at least one photo first.';

  @override
  String get ritualAlbumMissing =>
      'Ritual album missing. Edit the ritual to set an album.';

  @override
  String get ritualAddedToAlbum => 'Added to album';

  @override
  String ritualAddedToAlbumWithName({required String albumName}) {
    return 'Added to $albumName';
  }

  @override
  String ritualAddToAlbumFailure({required String error}) {
    return 'Couldn\'t add photos to the album: $error';
  }

  @override
  String get ritualBackToList => 'Back to rituals';

  @override
  String get ritualNoPhotosYet => 'No photos yet';

  @override
  String get ritualSetAlbumToLaunchCamera =>
      'Set an album for this ritual to launch the camera.';

  @override
  String get ritualDefaultCameraTitle => 'Take a photo';

  @override
  String get ritualBadgeMessage7 =>
      '7 days down! Consistency looks good on you. Keep going!';

  @override
  String get ritualBadgeMessage14 =>
      '14 days in! Your ritual is becoming a habit. Incredible!';

  @override
  String get ritualBadgeMessage30 =>
      '30 days in a row! Legendary consistency. Take a bow!';

  @override
  String get ritualBadgeMessageDefault => 'You\'re on a roll!';

  @override
  String get ritualBadgeNewTitle => 'New achievement';

  @override
  String get ritualBadgePreparing => 'Preparing...';

  @override
  String get ritualStreaksLabel => 'Streaks';

  @override
  String get ritualCreateYourOwn => 'Create your own ritual';

  @override
  String get ritualGetDailyReminders => 'Get daily reminders';

  @override
  String get ritualAlbumNotSet => 'Album not set';

  @override
  String get ritualOpenCameraTooltip => 'Open ritual camera';

  @override
  String get ritualEditorLabel => 'Ritual editor';

  @override
  String get ritualNew => 'Create new ritual';

  @override
  String get ritualCreateNewTitle => 'Create new ritual';

  @override
  String get ritualEdit => 'Edit ritual';

  @override
  String get ritualEnterPrompt => 'Enter your ritual';

  @override
  String get ritualEnterDescription => 'Please enter a description';

  @override
  String get ritualChooseDaysLabel => 'Choose days for ritual';

  @override
  String get ritualDayLabel => 'Day';

  @override
  String get ritualNotificationsOffHint =>
      'Notifications are off. Tap a day to turn them on.';

  @override
  String get ritualTimeLabel => 'Time';

  @override
  String get ritualAlbumLabel => 'Album';

  @override
  String get ritualSave => 'Save ritual';

  @override
  String get ritualCreateAction => 'Create ritual';

  @override
  String get ritualUpdate => 'Update ritual';

  @override
  String get ritualSelectAlbumTitle => 'Select album';

  @override
  String get ritualChooseAlbumLabel => 'Choose an album';

  @override
  String get ritualSendReminderLabel => 'Send reminder';

  @override
  String get ritualSearchOrCreate => 'Search or create new';

  @override
  String get ritualNoAlbumsYet => 'No albums yet';

  @override
  String get ritualNoMatchingAlbums => 'No matching albums';

  @override
  String ritualCreateAlbumWithName({required String albumName}) {
    return 'Create \"$albumName\"';
  }

  @override
  String get ritualCreateNew => 'Create new';

  @override
  String get ritualAlbumSelectionPlaceholder => 'Select album';

  @override
  String get ritualPickEmojiTitle => 'Pick an emoji';

  @override
  String get ritualCustomKeyboardLabel => 'Custom (keyboard)';

  @override
  String get ritualEmojiKeyboardHint => 'Press to open emoji keyboard';

  @override
  String get ritualEmojiUseAction => 'Use';

  @override
  String get ritualSearchEmpty =>
      'Build a ritual to keep your photo habit going.';
}
