// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Spanish Castilian (`es`).
class AppLocalizationsEs extends AppLocalizations {
  AppLocalizationsEs([String locale = 'es']) : super(locale);

  @override
  String get enterYourEmailAddress => 'Escribe tu correo electrónico';

  @override
  String get enterYourNewEmailAddress =>
      'Introduce tu nueva dirección de correo electrónico';

  @override
  String get accountWelcomeBack => '¡Bienvenido de nuevo!';

  @override
  String get emailAlreadyRegistered => 'Correo electrónico ya registrado.';

  @override
  String get emailNotRegistered => 'Correo electrónico no registrado.';

  @override
  String get email => 'Correo electrónico';

  @override
  String get cancel => 'Cancelar';

  @override
  String get verify => 'Verificar';

  @override
  String get invalidEmailAddress => 'Dirección de correo electrónico no válida';

  @override
  String get enterValidEmail =>
      'Por favor, introduce una dirección de correo electrónico válida.';

  @override
  String get deleteAccount => 'Eliminar cuenta';

  @override
  String get deleteAccountWarning =>
      'Esto eliminará su cuenta de Ente Auth, Ente Photos y Ente Locker.';

  @override
  String get askDeleteReason =>
      '¿Cuál es la razón principal por la que eliminas tu cuenta?';

  @override
  String get deleteAccountFeedbackPrompt =>
      'Lamentamos que te vayas. Por favor, explícanos el motivo para ayudarnos a mejorar.';

  @override
  String get feedback => 'Sugerencias';

  @override
  String get kindlyHelpUsWithThisInformation =>
      'Por favor ayúdanos con esta información';

  @override
  String get confirmDeletePrompt =>
      'Sí, quiero eliminar permanentemente esta cuenta y todos sus datos en todas las aplicaciones.';

  @override
  String get confirmAccountDeletion => 'Confirmar eliminación de cuenta';

  @override
  String get deleteAccountPermanentlyButton =>
      'Eliminar cuenta permanentemente';

  @override
  String get yourAccountHasBeenDeleted => 'Tu cuenta ha sido eliminada';

  @override
  String get selectReason => 'Seleccionar motivo';

  @override
  String get deleteReason1 => 'Falta una función clave que necesito';

  @override
  String get deleteReason2 =>
      'La aplicación o una característica determinada no se comporta como creo que debería';

  @override
  String get deleteReason3 => 'He encontrado otro servicio que me gusta más';

  @override
  String get deleteReason4 => 'Mi motivo no se encuentra en la lista';

  @override
  String get sendEmail => 'Enviar correo electrónico';

  @override
  String get deleteRequestSLAText =>
      'Tu solicitud será procesada dentro de las siguientes 72 horas.';

  @override
  String get deleteEmailRequest =>
      'Por favor, envía un correo electrónico a <warning>account-deletion@ente.io</warning> desde la dirección de correo electrónico que usó para registrarse.';

  @override
  String get entePhotosPerm =>
      'Ente <i>necesita permiso para</i> preservar tus fotos';

  @override
  String get ok => 'Aceptar';

  @override
  String get createAccount => 'Crear cuenta';

  @override
  String get createNewAccount => 'Crear nueva cuenta';

  @override
  String get password => 'Contraseña';

  @override
  String get confirmPassword => 'Confirmar contraseña';

  @override
  String get activeSessions => 'Sesiones activas';

  @override
  String get ocrProcessingOverlayMessage => 'Detectando texto...';

  @override
  String get ocrLoadingIndicatorLabel => 'Detectando texto';

  @override
  String get ocrSelectionHint =>
      'Desliza o toca dos veces para seleccionar lo que necesitas';

  @override
  String get ocrNoTextDetected => 'Ningún texto detectado';

  @override
  String get ocrRetryButtonLabel => 'Reintentar';

  @override
  String get ocrModelsNetworkRequiredError =>
      'Se requiere de conexión de red para descargar modelos OCR en el primer uso';

  @override
  String get ocrModelsPrepareFailed =>
      'No se pudieron preparar los modelos OCR';

  @override
  String get ocrImageNotFoundError => 'Archivo de imagen no encontrado';

  @override
  String get ocrImageDecodeFailedError =>
      'No se pudo leer el archivo de imagen';

  @override
  String get ocrGenericDetectError =>
      'No se pudo detectar el texto en la imagen';

  @override
  String get oops => 'Ups';

  @override
  String get somethingWentWrongPleaseTryAgain =>
      'Algo salió mal, por favor inténtalo de nuevo';

  @override
  String get thisWillLogYouOutOfThisDevice =>
      '¡Esto cerrará la sesión de este dispositivo!';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice =>
      'Esto cerrará la sesión del siguiente dispositivo:';

  @override
  String get terminateSession => '¿Terminar sesión?';

  @override
  String get terminate => 'Terminar';

  @override
  String get thisDevice => 'Este dispositivo';

  @override
  String get recoverButton => 'Recuperar';

  @override
  String get recoverySuccessful => '¡Recuperación exitosa!';

  @override
  String get decrypting => 'Descifrando...';

  @override
  String get incorrectRecoveryKeyTitle => 'Clave de recuperación incorrecta';

  @override
  String get incorrectRecoveryKeyBody =>
      'La clave de recuperación introducida es incorrecta';

  @override
  String get forgotPassword => 'Olvidé mi contraseña';

  @override
  String get enterYourRecoveryKey => 'Introduce tu clave de recuperación';

  @override
  String get noRecoveryKey => '¿Sin clave de recuperación?';

  @override
  String get sorry => 'Lo sentimos';

  @override
  String get noRecoveryKeyNoDecryption =>
      'Debido a la naturaleza de nuestro protocolo de cifrado de extremo a extremo, tus datos no pueden ser descifrados sin tu contraseña o clave de recuperación';

  @override
  String get verifyEmail => 'Verificar correo electrónico';

  @override
  String get toResetVerifyEmail =>
      'Para restablecer tu contraseña, por favor verifica tu correo electrónico primero.';

  @override
  String get checkInboxAndSpamFolder =>
      'Revisa tu bandeja de entrada (y spam) para completar la verificación';

  @override
  String get tapToEnterCode => 'Toca para introducir el código';

  @override
  String get resendEmail => 'Reenviar correo electrónico';

  @override
  String weHaveSendEmailTo({required String email}) {
    return 'Hemos enviado un correo a <green>$email</green>';
  }

  @override
  String get setPasswordTitle => 'Establecer contraseña';

  @override
  String get changePasswordTitle => 'Cambiar contraseña';

  @override
  String get resetPasswordTitle => 'Restablecer contraseña';

  @override
  String get encryptionKeys => 'Claves de cifrado';

  @override
  String get passwordWarning =>
      'No almacenamos esta contraseña, así que si la olvidas, <underline>no podremos descifrar tus datos</underline>';

  @override
  String get enterPasswordToEncrypt =>
      'Introduce una contraseña que podamos usar para cifrar tus datos';

  @override
  String get enterNewPasswordToEncrypt =>
      'Introduce una nueva contraseña que podamos usar para cifrar tus datos';

  @override
  String get weakStrength => 'Poco segura';

  @override
  String get strongStrength => 'Segura';

  @override
  String get moderateStrength => 'Moderada';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'Seguridad de la contraseña: $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully => 'Contraseña cambiada correctamente';

  @override
  String get generatingEncryptionKeys => 'Generando claves de cifrado...';

  @override
  String get pleaseWait => 'Por favor, espera...';

  @override
  String get continueLabel => 'Continuar';

  @override
  String get insecureDevice => 'Dispositivo inseguro';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'Lo sentimos, no hemos podido generar claves seguras en este dispositivo.\n\nPor favor, regístrate desde un dispositivo diferente.';

  @override
  String get howItWorks => 'Cómo funciona';

  @override
  String get encryption => 'Cifrado';

  @override
  String get ackPasswordLostWarning =>
      'Entiendo que si pierdo mi contraseña podría perder mis datos, ya que mis datos están <underline>cifrados de extremo a extremo</underline>.';

  @override
  String get privacyPolicyTitle => 'Política de Privacidad';

  @override
  String get termsOfServicesTitle => 'Términos';

  @override
  String get signUpTerms =>
      'Estoy de acuerdo con los <u-terms>términos del servicio</u-terms> y <u-policy> la política de privacidad</u-policy>';

  @override
  String get logInLabel => 'Iniciar sesión';

  @override
  String get loginTerms =>
      'Al hacer clic en iniciar sesión, acepto los <u-terms>términos de servicio</u-terms> y <u-policy>la política de privacidad</u-policy>';

  @override
  String get changeEmail => 'Cambiar correo electrónico';

  @override
  String get enterYourPassword => 'Ingresa tu contraseña';

  @override
  String get welcomeBack => '¡Bienvenido de nuevo!';

  @override
  String get contactSupport => 'Contactar con soporte';

  @override
  String get locationPickerTip =>
      'También puedes añadir una ubicación centrada en una foto desde la pantalla de información de la foto';

  @override
  String get incorrectPasswordTitle => 'Contraseña incorrecta';

  @override
  String get pleaseTryAgain => 'Por favor, inténtalo nuevamente';

  @override
  String get recreatePasswordTitle => 'Recrear contraseña';

  @override
  String get useRecoveryKey => 'Usar clave de recuperación';

  @override
  String get recreatePasswordBody =>
      'El dispositivo actual no es lo suficientemente potente para verificar su contraseña, pero podemos regenerarla de una manera que funcione con todos los dispositivos.\n\nPor favor inicie sesión usando su clave de recuperación y regenere su contraseña (puede volver a utilizar la misma si lo desea).';

  @override
  String get verifyPassword => 'Verificar contraseña';

  @override
  String get recoveryKey => 'Clave de recuperación';

  @override
  String get recoveryKeyOnForgotPassword =>
      'Si olvidas tu contraseña, la única forma de recuperar tus datos es con esta clave.';

  @override
  String get recoveryKeySaveDescription =>
      'Nosotros no almacenamos esta clave. Por favor, guarda esta clave de 24 palabras en un lugar seguro.';

  @override
  String get doThisLater => 'Hacerlo más tarde';

  @override
  String get saveKey => 'Guardar Clave';

  @override
  String get recoveryKeyCopiedToClipboard =>
      'Clave de recuperación copiada al portapapeles';

  @override
  String get recoverAccount => 'Recuperar cuenta';

  @override
  String get recover => 'Recuperar';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'Por favor, envía un correo electrónico a $supportEmail desde tu dirección de correo electrónico que usó para registrarse';
  }

  @override
  String get twofactorSetup => 'Configuración de dos pasos';

  @override
  String get enterCode => 'Introduce el código';

  @override
  String get scanCode => 'Escanear código';

  @override
  String get codeCopiedToClipboard => 'Código copiado al portapapeles';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      'Copia y pega este código\na tu aplicación de autenticador';

  @override
  String get tapToCopy => 'toca para copiar';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      'Escanea este código QR con tu aplicación de autenticación';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      'Ingresa el código de seis dígitos de tu aplicación de autenticación';

  @override
  String get confirm => 'Confirmar';

  @override
  String get setupComplete => 'Configuración completa';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready =>
      'Guarda tu clave de recuperación si aún no lo has hecho';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      'Esto puede utilizarse para recuperar tu cuenta si pierdes tu segundo factor';

  @override
  String get twofactorAuthenticationPageTitle => 'Autenticación en dos pasos';

  @override
  String get lostDevice => '¿Perdiste tu dispositivo?';

  @override
  String get verifyingRecoveryKey => 'Verificando clave de recuperación...';

  @override
  String get recoveryKeyVerified => 'Clave de recuperación verificada';

  @override
  String get recoveryKeySuccessBody =>
      '¡Genial! Tu clave de recuperación es válida. Gracias por verificar.\n\nPor favor, recuerda mantener tu clave de recuperación segura.';

  @override
  String get invalidRecoveryKey =>
      'La clave de recuperación introducida no es válida. Por favor, asegúrate de que contenga 24 palabras y comprueba la ortografía de cada una.\n\nSi has introducido un código de recuperación antiguo, asegúrate de que tiene 64 caracteres de largo y comprueba cada uno de ellos.';

  @override
  String get invalidKey => 'Clave inválida';

  @override
  String get tryAgain => 'Inténtalo de nuevo';

  @override
  String get viewRecoveryKey => 'Ver código de recuperación';

  @override
  String get confirmRecoveryKey => 'Confirmar clave de recuperación';

  @override
  String get recoveryKeyVerifyReason =>
      'Tu clave de recuperación es la única forma de recuperar tus fotos si olvidas tu contraseña. Puedes encontrar tu clave de recuperación en Ajustes > Cuenta.\n\nPor favor, introduce tu clave de recuperación aquí para verificar que la has guardado correctamente.';

  @override
  String get confirmYourRecoveryKey => 'Confirma tu clave de recuperación';

  @override
  String get addViewer => 'Añadir espectador';

  @override
  String get addCollaborator => 'Agregar colaborador';

  @override
  String get admin => 'Admin';

  @override
  String get admins => 'Admins';

  @override
  String get addAdmin => 'Add admin';

  @override
  String get addMoreAdmins => 'Add more admins';

  @override
  String get adminsAndCollaboratorsCanAddPhotosDescription =>
      'Admins and collaborators can add photos. Admins can also manage photos & participants.';

  @override
  String get addANewEmail => 'Agregar nuevo correo electrónico';

  @override
  String get orPickAnExistingOne => 'O elige uno existente';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'Colaboradores pueden añadir fotos y vídeos al álbum compartido.';

  @override
  String get enterEmail => 'Ingresar correo electrónico ';

  @override
  String get albumOwner => 'Propietario';

  @override
  String get you => 'Tu';

  @override
  String get collaborator => 'Colaborador';

  @override
  String get addMore => 'Añadir más';

  @override
  String get viewer => 'Espectador';

  @override
  String get remove => 'Quitar';

  @override
  String get removeParticipant => 'Quitar participante';

  @override
  String get manage => 'Administrar';

  @override
  String get addedAs => 'Agregado como';

  @override
  String get changePermissions => '¿Cambiar permisos?';

  @override
  String get yesConvertToViewer => 'Sí, convertir a espectador';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return '$user no podrá añadir más fotos a este álbum\n\nTodavía podrán eliminar las fotos ya añadidas por ellos';
  }

  @override
  String get allowAddingPhotos => 'Permitir añadir fotos';

  @override
  String get allowJoiningAlbum => 'Permitir unirse al álbum';

  @override
  String get allowAddPhotosDescription =>
      'Permitir a las personas con el enlace añadir fotos al álbum compartido.';

  @override
  String get passwordLock => 'Bloqueo con contraseña';

  @override
  String get canNotOpenTitle => 'No es posible abrir este álbum';

  @override
  String get canNotOpenBody =>
      'Lo sentimos, este álbum no se puede abrir en la aplicación.';

  @override
  String get disableDownloadWarningTitle => 'Por favor, ten en cuenta';

  @override
  String get disableDownloadWarningBody =>
      'Los espectadores todavía pueden tomar capturas de pantalla o guardar una copia de tus fotos usando herramientas externas';

  @override
  String get allowDownloads => 'Permitir descargas';

  @override
  String get linkDeviceLimit => 'Límite del dispositivo';

  @override
  String get noDeviceLimit => 'Ninguno';

  @override
  String get albumLayout => 'Diseño del álbum';

  @override
  String get layoutGrouped => 'Agrupado';

  @override
  String get layoutContinuous => 'Continuo';

  @override
  String get layoutTrip => 'Viaje';

  @override
  String get preview => 'Vista previa';

  @override
  String get linkExpiry => 'Enlace vence';

  @override
  String get linkExpired => 'Vencido';

  @override
  String get linkEnabled => 'Habilitado';

  @override
  String get linkNeverExpires => 'Nunca';

  @override
  String get expiredLinkInfo =>
      'Este enlace ha caducado. Por favor, selecciona una nueva fecha de caducidad o deshabilita la fecha de caducidad.';

  @override
  String get setAPassword => 'Establecer una contraseña';

  @override
  String get lockButtonLabel => 'Bloquear';

  @override
  String get enterPassword => 'Introduzca contraseña';

  @override
  String get removeLink => 'Eliminar enlace';

  @override
  String get manageLink => 'Administrar enlace';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'El enlace caducará en $expiryTime';
  }

  @override
  String get albumUpdated => 'Álbum actualizado';

  @override
  String get never => 'Nunca';

  @override
  String get custom => 'Personalizado';

  @override
  String get after1Hour => 'Después de 1 hora';

  @override
  String get after1Day => 'Después de un día';

  @override
  String get after1Week => 'Después de una semana';

  @override
  String get after1Month => 'Después de un mes';

  @override
  String get after1Year => 'Después de un año';

  @override
  String get manageParticipants => 'Administrar';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Participantes',
      one: '1 Participante',
      zero: 'No hay Participantes',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'Crea un enlace para permitir que otros pueda añadir y ver fotos en tu álbum compartido sin necesitar la aplicación Ente o una cuenta. Genial para recolectar fotos de eventos.';

  @override
  String get collectPhotos => 'Recolectar fotos';

  @override
  String get collaborativeLink => 'Enlace colaborativo';

  @override
  String get shareWithNonenteUsers => 'Compartir con usuarios fuera de Ente';

  @override
  String get createPublicLink => 'Crear enlace público';

  @override
  String get sendLink => 'Enviar enlace';

  @override
  String get qrCode => 'Código QR';

  @override
  String get sendQrCode => 'Enviar código QR';

  @override
  String get copyLink => 'Copiar enlace';

  @override
  String get copyEmbedHtml => 'Copiar HTML incorporado';

  @override
  String get linkHasExpired => 'El enlace ha caducado';

  @override
  String get publicLinkEnabled => 'Enlace público habilitado';

  @override
  String get shareALink => 'Compartir un enlace';

  @override
  String get sharedAlbumSectionDescription =>
      'Crea álbumes compartidos y colaborativos con otros usuarios de Ente, incluyendo usuarios de planes gratuitos.';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: 'Compartido con $numberOfPeople personas',
      one: 'Compartido con 1 persona',
      zero: 'Compartir con personas específicas',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId => 'Esta es tu ID de verificación';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'Alguien que comparta álbumes contigo debería ver el mismo ID en su dispositivo.';

  @override
  String get howToViewShareeVerificationID =>
      'Por favor, pídeles que mantengan presionada su dirección de correo electrónico en la pantalla de ajustes, y verifica que los identificadores de ambos dispositivos coincidan.';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'Este es el ID de verificación de $email';
  }

  @override
  String get verificationId => 'ID de verificación';

  @override
  String verifyEmailID({required Object email}) {
    return 'Verificar $email';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return '$email no tiene una cuente en Ente.\n\nEnvíale una invitación para compartir fotos.';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return 'Aquí está mi ID de verificación: $verificationID para ente.io.';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'Hola, ¿puedes confirmar que esta es tu ID de verificación ente.io: $verificationID?';
  }

  @override
  String get somethingWentWrong => 'Algo salió mal';

  @override
  String get sendInvite => 'Enviar invitación';

  @override
  String get shareTextRecommendUsingEnte =>
      'Descarga Ente para que podamos compartir fácilmente fotos y vídeos en calidad original.\n\nhttps://ente.io';

  @override
  String get done => 'Hecho';

  @override
  String get applyCodeTitle => 'Usar código';

  @override
  String get enterCodeDescription =>
      'Introduce el código proporcionado por tu amigo para reclamar almacenamiento gratuito para ambos';

  @override
  String get apply => 'Aplicar';

  @override
  String get failedToApplyCode => 'Error al aplicar el código';

  @override
  String get enterReferralCode => 'Introduce el código de referido';

  @override
  String get codeAppliedPageTitle => 'Código aplicado';

  @override
  String get changeYourReferralCode => 'Cambiar tu código de referido';

  @override
  String get change => 'Cambiar';

  @override
  String get unavailableReferralCode =>
      'Lo sentimos, este código no está disponible.';

  @override
  String get codeChangeLimitReached =>
      'Lo sentimos, has alcanzado el límite de cambios de códigos.';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'Por favor, contacta a $familyAdminEmail para cambiar tu código.';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB';
  }

  @override
  String get claimed => 'Obtenido';

  @override
  String get details => 'Detalles';

  @override
  String get claimMore => '¡Obtén más!';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return 'También obtienen $storageAmountInGB GB';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB cada vez que alguien se registra en un plan de pago y aplica tu código';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'Código de referido de Ente: $referralCode \n\nAñádelo en Ajustes → General → Referidos para obtener $referralStorageInGB GB gratis tras comprar un plan de pago.\n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => 'Obtén almacenamiento gratuito';

  @override
  String get inviteYourFriends => 'Invita a tus amigos';

  @override
  String get failedToFetchReferralDetails =>
      'No se pueden obtener los detalles de la referencia. Por favor, inténtalo de nuevo más tarde.';

  @override
  String get referralStep1 => '1. Dale este código a tus amigos';

  @override
  String get referralStep2 => '2. Se suscriben a un plan de pago';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. Ambos obtienen $storageInGB GB* gratis';
  }

  @override
  String get referralsAreCurrentlyPaused =>
      'Las referencias están actualmente en pausa';

  @override
  String get youCanAtMaxDoubleYourStorage =>
      '* Como máximo puedes duplicar tu almacenamiento';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true': 'Tu familia ha obtenido $storageAmountInGb GB hasta el momento',
      'false': 'Tú has obtenido $storageAmountInGb GB hasta el momento',
      'other': '¡Tú has obtenido $storageAmountInGb GB hasta el momento!',
    });
    return '$_temp0';
  }

  @override
  String get faq => 'Preguntas Frecuentes';

  @override
  String get help => 'Ayuda';

  @override
  String get oopsSomethingWentWrong => 'Ups, algo salió mal';

  @override
  String get peopleUsingYourCode => 'Personas usando tu código';

  @override
  String get eligible => 'elegible';

  @override
  String get total => 'total';

  @override
  String get codeUsedByYou => 'Código usado por ti';

  @override
  String get freeStorageClaimed => 'Almacenamiento gratuito obtenido';

  @override
  String get freeStorageUsable => 'Almacenamiento libre disponible';

  @override
  String get usableReferralStorageInfo =>
      'El almacenamiento utilizable está limitado por tu plan actual. El exceso de almacenamiento que obtengas se volverá automáticamente utilizable cuando actualices tu plan.';

  @override
  String get removeFromAlbumTitle => '¿Eliminar del álbum?';

  @override
  String get removeFromAlbum => 'Eliminar del álbum';

  @override
  String get itemsWillBeRemovedFromAlbum =>
      'Los elementos seleccionados serán eliminados de este álbum';

  @override
  String get removeShareItemsWarning =>
      'Las fotos seleccionadas no serán accesibles para ningún visor de este álbum, excepto para los propietarios de las fotos.';

  @override
  String get addingToFavorites => 'Añadiendo a favoritos...';

  @override
  String get removingFromFavorites => 'Quitando de favoritos...';

  @override
  String get sorryCouldNotAddToFavorites =>
      '¡Lo sentimos, no se pudo añadir a favoritos!';

  @override
  String get sorryCouldNotRemoveFromFavorites =>
      '¡Lo sentimos, no se pudo quitar de favoritos!';

  @override
  String get subscribeToEnableSharing =>
      'Necesitas una suscripción activa de pago para habilitar el compartir.';

  @override
  String get subscribeToChangeLinkSetting =>
      'Necesitas una suscripción de pago para cambiar la configuración de este enlace.';

  @override
  String get subscribe => 'Suscribirse';

  @override
  String get canOnlyRemoveFilesOwnedByYou =>
      'Sólo puede eliminar archivos de tu propiedad';

  @override
  String get deleteSharedAlbum => '¿Borrar álbum compartido?';

  @override
  String get deleteAlbum => 'Borrar álbum';

  @override
  String get deleteAlbumDialog =>
      '¿También eliminar las fotos (y los vídeos) presentes en este álbum de <bold>todos</bold> los otros álbumes de los que forman parte?';

  @override
  String get deleteSharedAlbumDialogBody =>
      'El álbum se eliminará para todos\n\nPerderás el acceso a las fotos compartidas en este álbum que son propiedad de otros';

  @override
  String get yesRemove => 'Sí, quitar';

  @override
  String get creatingLink => 'Creando enlace...';

  @override
  String get removeWithQuestionMark => 'Quitar?';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return '$userEmail será eliminado de este álbum compartido\n\nCualquier foto añadida por ellos también será eliminada del álbum';
  }

  @override
  String get keepPhotos => 'Conservar las fotos';

  @override
  String get deletePhotos => 'Borrar las fotos';

  @override
  String get inviteToEnte => 'Invitar a Ente';

  @override
  String get removePublicLink => 'Quitar enlace público';

  @override
  String disableLinkMessage({required Object albumName}) {
    return 'Esto eliminará el enlace público para acceder a \"$albumName\".';
  }

  @override
  String get sharing => 'Compartiendo...';

  @override
  String get youCannotShareWithYourself => 'No puedes compartir contigo mismo';

  @override
  String get archive => 'Archivo';

  @override
  String get createAlbumActionHint =>
      'Manten presionado para seleccionar fotos y haz clic en + para crear un álbum';

  @override
  String get importing => 'Importando....';

  @override
  String get failedToLoadAlbums => 'Error al cargar álbumes';

  @override
  String get hidden => 'Oculto';

  @override
  String get authToViewYourHiddenFiles =>
      'Por favor, autentícate para ver tus archivos ocultos';

  @override
  String get authToViewTrashedFiles =>
      'Por favor, autentícate para ver los archivos enviados a la papelera';

  @override
  String get trash => 'Papelera';

  @override
  String get uncategorized => 'Sin categorizar';

  @override
  String get videoSmallCase => 'vídeo';

  @override
  String get photoSmallCase => 'foto';

  @override
  String get singleFileDeleteHighlight => 'Se borrará de todos los álbumes.';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return 'Este $fileType está tanto en Ente como en tu dispositivo.';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return 'Este $fileType será eliminado de Ente.';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return 'Este $fileType se eliminará de tu dispositivo.';
  }

  @override
  String get deleteFromEnte => 'Eliminar de Ente';

  @override
  String get yesDelete => 'Sí, eliminar';

  @override
  String get movedToTrash => 'Movido a la papelera';

  @override
  String get deleteFromDevice => 'Eliminar del dispositivo';

  @override
  String get deleteFromBoth => 'Eliminar de ambos';

  @override
  String get newAlbum => 'Nuevo álbum';

  @override
  String get albums => 'Álbumes';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount recuerdos',
      one: '$formattedCount recuerdo',
      zero: 'no hay recuerdos',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return '$count seleccionados';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return '$count seleccionados ($yourCount tuyos)';
  }

  @override
  String get advancedSettings => 'Avanzado';

  @override
  String get photoGridSize => 'Tamaño de la cuadrícula de fotos';

  @override
  String get manageDeviceStorage =>
      'Gestionar almacenamiento caché del dispositivo';

  @override
  String get manageDeviceStorageDesc =>
      'Revisar y borrar almacenamiento caché local.';

  @override
  String get machineLearning => 'Aprendizaje automático';

  @override
  String get mlConsent => 'Habilitar aprendizaje automático';

  @override
  String get mlConsentTitle => '¿Habilitar aprendizaje automático?';

  @override
  String get mlConsentDescription =>
      'Si habilitas el aprendizaje automático, Ente extraerá información como la geometría de la cara de los archivos, incluyendo aquellos compartidos contigo.\n\nEsto sucederá en tu dispositivo, y cualquier información biométrica generada será encriptada de extremo a extremo.';

  @override
  String get mlConsentPrivacy =>
      'Por favor, haz clic aquí para más detalles sobre esta característica en nuestra política de privacidad';

  @override
  String get mlConsentConfirmation =>
      'Entiendo y deseo habilitar el aprendizaje automático';

  @override
  String get magicSearch => 'Búsqueda mágica';

  @override
  String get discover => 'Descubrir';

  @override
  String get discover_identity => 'Identidad';

  @override
  String get discover_screenshots => 'Capturas de pantalla';

  @override
  String get discover_receipts => 'Recibos';

  @override
  String get discover_notes => 'Notas';

  @override
  String get discover_memes => 'Memes';

  @override
  String get discover_visiting_cards => 'Tarjetas de visita';

  @override
  String get discover_babies => 'Bebés';

  @override
  String get discover_pets => 'Mascotas';

  @override
  String get discover_selfies => 'Selfies';

  @override
  String get discover_wallpapers => 'Fondos de pantalla';

  @override
  String get discover_food => 'Comida';

  @override
  String get discover_celebrations => 'Celebraciones';

  @override
  String get discover_sunset => 'Atardecer';

  @override
  String get discover_hills => 'Colinas';

  @override
  String get discover_greenery => 'Verdor';

  @override
  String get mlIndexingDescription =>
      'Por favor ten en cuenta que el aprendizaje automático dará como resultado un mayor consumo de ancho de banda y de batería hasta que todos los elementos estén indexados. Considera usar la aplicación de escritorio para una indexación más rápida. Todos los resultados se sincronizarán automáticamente.';

  @override
  String get loadingModel => 'Descargando modelos...';

  @override
  String get waitingForWifi => 'Esperando WiFi...';

  @override
  String get status => 'Estado';

  @override
  String get indexedItems => 'Elementos indexados';

  @override
  String get pendingItems => 'Elementos pendientes';

  @override
  String get clearIndexes => 'Limpiar índices';

  @override
  String get selectFoldersForBackup =>
      'Seleccionar carpetas para la copia de seguridad';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      'Las carpetas seleccionadas se cifrarán y se realizará una copia de seguridad';

  @override
  String get unselectAll => 'Desmarcar todos';

  @override
  String get selectAll => 'Seleccionar todos';

  @override
  String get skip => 'Omitir';

  @override
  String get updatingFolderSelection =>
      'Actualizando la selección de carpeta...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count elementos',
      one: '$count elemento',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Elimina $count elementos',
      one: 'Elimina $count elemento',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count archivos, $formattedSize cada uno';
  }

  @override
  String get showMemories => 'Mostrar recuerdos';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Hace $count años',
      one: 'Hace $count año',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'Ajustes de copia de seguridad';

  @override
  String get backupStatus => 'Estado de la copia de seguridad';

  @override
  String get backupStatusDescription =>
      'Los elementos con copia seguridad aparecerán aquí';

  @override
  String get backupOverMobileData => 'Copia de seguridad usando datos móviles';

  @override
  String get backupVideos => 'Copia de seguridad de vídeos';

  @override
  String get disableAutoLock => 'Desactivar bloqueo automático';

  @override
  String get deviceLockExplanation =>
      'Deshabilita el bloqueo de pantalla del dispositivo cuando Ente está en primer plano y haya una copia de seguridad en curso. Normalmente esto no es necesario, pero puede ayudar a que las grandes cargas y las importaciones iniciales de grandes bibliotecas se completen más rápido.';

  @override
  String get about => 'Acerca de';

  @override
  String get weAreOpenSource => '¡Somos de código abierto!';

  @override
  String get privacy => 'Privacidad';

  @override
  String get terms => 'Términos';

  @override
  String get checkForUpdates => 'Comprobar actualizaciones';

  @override
  String get checkStatus => 'Comprobar estado';

  @override
  String get checking => 'Comprobando...';

  @override
  String get youAreOnTheLatestVersion => 'Estás usando la última versión';

  @override
  String get account => 'Cuenta';

  @override
  String get manageSubscription => 'Administrar tu suscripción';

  @override
  String get authToChangeYourEmail =>
      'Por favor, autentícate para cambiar tu correo electrónico';

  @override
  String get changePassword => 'Cambiar contraseña';

  @override
  String get authToChangeYourPassword =>
      'Por favor, autentícate para cambiar tu contraseña';

  @override
  String get emailVerificationToggle => 'Verificación por correo electrónico';

  @override
  String get authToChangeEmailVerificationSetting =>
      'Por favor, autentícate para cambiar la verificación por correo electrónico';

  @override
  String get exportYourData => 'Exportar tus datos';

  @override
  String get logout => 'Cerrar sesión';

  @override
  String get authToInitiateAccountDeletion =>
      'Por favor, autentícate para iniciar la eliminación de la cuenta';

  @override
  String get areYouSureYouWantToLogout =>
      '¿Estás seguro de que quieres cerrar la sesión?';

  @override
  String get yesLogout => 'Sí, cerrar sesión';

  @override
  String get aNewVersionOfEnteIsAvailable =>
      'Hay una nueva versión de Ente disponible.';

  @override
  String get update => 'Actualizar';

  @override
  String get installManually => 'Instalar manualmente';

  @override
  String get criticalUpdateAvailable => 'Actualización crítica disponible';

  @override
  String get updateAvailable => 'Actualizacion disponible';

  @override
  String get ignoreUpdate => 'Ignorar';

  @override
  String get downloading => 'Descargando...';

  @override
  String get cannotDeleteSharedFiles =>
      'No se pueden eliminar los archivos compartidos';

  @override
  String get theDownloadCouldNotBeCompleted =>
      'No se ha podido completar la descarga';

  @override
  String get retry => 'Reintentar';

  @override
  String get backedUpFolders => 'Carpetas con copia de seguridad';

  @override
  String get backup => 'Copia de seguridad';

  @override
  String get freeUpDeviceSpace => 'Liberar espacio del dispositivo';

  @override
  String get freeUpDeviceSpaceDesc =>
      'Ahorra espacio en tu dispositivo limpiando archivos que tienen copia de seguridad.';

  @override
  String get allClear => '✨ Todo limpio';

  @override
  String get noDeviceThatCanBeDeleted =>
      'No tienes archivos en este dispositivo que puedan ser borrados';

  @override
  String get removeDuplicates => 'Eliminar duplicados';

  @override
  String get removeDuplicatesDesc =>
      'Revisar y eliminar archivos que son duplicados exactos.';

  @override
  String get viewLargeFiles => 'Archivos grandes';

  @override
  String get viewLargeFilesDesc =>
      'Ver los archivos que consumen la mayor cantidad de almacenamiento.';

  @override
  String get noDuplicates => '✨ Sin duplicados';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared =>
      'No tienes archivos duplicados que se puedan borrar';

  @override
  String get success => 'Éxito';

  @override
  String get rateUs => 'Califícanos';

  @override
  String get remindToEmptyDeviceTrash =>
      'También vacía \"Eliminado Recientemente\" de \"Configuración\" -> \"Almacenamiento\" para reclamar el espacio libre';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return '¡Has liberado $storageSaved con éxito!';
  }

  @override
  String get remindToEmptyEnteTrash =>
      'También vacía tu \"Papelera\" para reclamar el espacio liberado';

  @override
  String get sparkleSuccess => '✨ Éxito';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count archivos duplicados',
      one: '$count archivo duplicado',
    );
    return '¡Has limpiado $_temp0, ahorrando ($storageSaved!)';
  }

  @override
  String get familyPlans => 'Planes familiares';

  @override
  String get referrals => 'Referidos';

  @override
  String get notifications => 'Notificaciones';

  @override
  String get sharedPhotoNotifications => 'Nuevas fotos compartidas';

  @override
  String get sharedPhotoNotificationsExplanation =>
      'Recibir notificaciones cuando alguien agrega una foto a un álbum compartido contigo';

  @override
  String get advanced => 'Avanzado';

  @override
  String get general => 'General';

  @override
  String get security => 'Seguridad';

  @override
  String get authToViewYourRecoveryKey =>
      'Por favor, autentícate para ver tu clave de recuperación';

  @override
  String get twofactor => 'Dos factores';

  @override
  String get authToConfigureTwofactorAuthentication =>
      'Por favor, autentícate para configurar la autenticación de dos factores';

  @override
  String get lockscreen => 'Pantalla de bloqueo';

  @override
  String get authToChangeLockscreenSetting =>
      'Por favor, autentícate para cambiar la configuración de la pantalla de bloqueo';

  @override
  String get viewActiveSessions => 'Ver sesiones activas';

  @override
  String get authToViewYourActiveSessions =>
      'Por favor, autentícate para ver tus sesiones activas';

  @override
  String get disableTwofactor => 'Deshabilitar dos factores';

  @override
  String get confirm2FADisable =>
      '¿Estás seguro de que deseas deshabilitar la autenticación de doble factor?';

  @override
  String get no => 'No';

  @override
  String get yes => 'Sí';

  @override
  String get social => 'Social';

  @override
  String rateUsOnStore({required Object storeName}) {
    return 'Puntúanos en $storeName';
  }

  @override
  String get blog => 'Blog';

  @override
  String get merchandise => 'Mercancías';

  @override
  String get twitter => 'Twitter';

  @override
  String get mastodon => 'Mastodon';

  @override
  String get matrix => 'Matrix';

  @override
  String get discord => 'Discord';

  @override
  String get reddit => 'Reddit';

  @override
  String get yourStorageDetailsCouldNotBeFetched =>
      'Tus datos de almacenamiento no se han podido obtener';

  @override
  String get reportABug => 'Reportar un error';

  @override
  String get reportBug => 'Reportar error';

  @override
  String get suggestFeatures => 'Sugerir una característica';

  @override
  String get support => 'Soporte';

  @override
  String get theme => 'Tema';

  @override
  String get lightTheme => 'Claro';

  @override
  String get darkTheme => 'Oscuro';

  @override
  String get systemTheme => 'Sistema';

  @override
  String get freeTrial => 'Prueba gratuita';

  @override
  String get selectYourPlan => 'Elegir tu suscripción';

  @override
  String get enteSubscriptionPitch =>
      'Ente conserva tus recuerdos, así que siempre están disponibles para ti, incluso si pierdes tu dispositivo.';

  @override
  String get enteSubscriptionShareWithFamily =>
      'Tu familia también puede ser agregada a tu plan.';

  @override
  String get currentUsageIs => 'El uso actual es de ';

  @override
  String get faqs => 'Preguntas frecuentes';

  @override
  String renewsOn({required Object endDate}) {
    return 'La suscripción se renueva el $endDate';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return 'Prueba gratuita válida hasta $endDate';
  }

  @override
  String validTill({required Object endDate}) {
    return 'Válido hasta $endDate';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return 'Tu $storageAmount adicional es válido hasta $endDate';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return 'Prueba gratuita válida hasta $endDate.\nPuedes elegir un plan de pago después.';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'Tu suscripción se cancelará el $endDate';
  }

  @override
  String get subscription => 'Suscripción';

  @override
  String get paymentDetails => 'Detalles de pago';

  @override
  String get manageFamily => 'Administrar familia';

  @override
  String contactToManageSubscription({required Object provider}) {
    return 'Por favor, contáctanos en support@ente.io para gestionar tu suscripción a $provider.';
  }

  @override
  String get renewSubscription => 'Renovar suscripción';

  @override
  String get cancelSubscription => 'Cancelar suscripción';

  @override
  String get areYouSureYouWantToRenew =>
      '¿Estás seguro de que quieres renovar?';

  @override
  String get yesRenew => 'Sí, renovar';

  @override
  String get areYouSureYouWantToCancel =>
      '¿Estás seguro de que quieres cancelar?';

  @override
  String get yesCancel => 'Sí, cancelar';

  @override
  String get failedToRenew => 'Renovación fallida';

  @override
  String get failedToCancel => 'Error al cancelar';

  @override
  String get twoMonthsFreeOnYearlyPlans => '2 meses gratis en planes anuales';

  @override
  String get monthly => 'Mensualmente';

  @override
  String get yearly => 'Anualmente';

  @override
  String get confirmPlanChange => 'Confirmar los cambios en el plan';

  @override
  String get areYouSureYouWantToChangeYourPlan =>
      '¿Estás seguro de que quieres cambiar tu plan?';

  @override
  String get youCannotDowngradeToThisPlan => 'No puedes bajar a este plan';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'Por favor, cancela primero tu suscripción existente de $paymentProvider';
  }

  @override
  String get optionalAsShortAsYouLike => 'Opcional, tan corto como quieras...';

  @override
  String get send => 'Enviar';

  @override
  String get askCancelReason =>
      'Tu suscripción ha sido cancelada. ¿Quieres compartir el motivo?';

  @override
  String get thankYouForSubscribing => '¡Gracias por suscribirte!';

  @override
  String get yourPurchaseWasSuccessful => 'Tu compra ha sido exitosa';

  @override
  String get yourPlanWasSuccessfullyUpgraded =>
      'Tu plan se ha actualizado correctamente';

  @override
  String get yourPlanWasSuccessfullyDowngraded =>
      'Tu plan ha sido degradado con éxito';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully =>
      'Tu suscripción se ha actualizado con éxito';

  @override
  String get googlePlayId => 'ID de Google Play';

  @override
  String get appleId => 'ID de Apple';

  @override
  String get playstoreSubscription => 'Suscripción en la PlayStore';

  @override
  String get appstoreSubscription => 'Suscripción en la AppStore';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return 'Tu $id ya está vinculada a otra cuenta de Ente.\nSi deseas utilizar tu $id con esta cuenta, ponte en contacto con nuestro servicio de asistencia\'\'';
  }

  @override
  String get visitWebToManage =>
      'Por favor, visita web.ente.io para administrar tu suscripción';

  @override
  String get couldNotUpdateSubscription =>
      'No se pudo actualizar la suscripción';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      '¡Por favor, contacta con support@ente.io y estaremos encantados de ayudar!';

  @override
  String get paymentFailed => 'Pago fallido';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return 'Por favor, habla con el soporte de $providerName si se te cobró';
  }

  @override
  String get continueOnFreeTrial => 'Continuar con el plan gratuito';

  @override
  String get areYouSureYouWantToExit => '¿Estás seguro de que deseas salir?';

  @override
  String get thankYou => 'Gracias';

  @override
  String get failedToVerifyPaymentStatus =>
      'Error al verificar el estado de tu pago';

  @override
  String get pleaseWaitForSometimeBeforeRetrying =>
      'Por favor, espera un momento antes de volver a intentarlo';

  @override
  String get paymentFailedMessage =>
      'Lamentablemente tu pago falló. Por favor, ¡contacta con el soporte técnico y te ayudaremos!';

  @override
  String get youAreOnAFamilyPlan => '¡Estás en un plan familiar!';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'Por favor contacta con <green>$familyAdminEmail</green> para administrar tu suscripción';
  }

  @override
  String get leaveFamily => 'Abandonar plan familiar';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily =>
      '¿Está seguro de que desea abandonar el plan familiar?';

  @override
  String get leave => 'Abandonar';

  @override
  String get rateTheApp => 'Evalúa la aplicación';

  @override
  String get startBackup => 'Iniciar copia de seguridad';

  @override
  String get noPhotosAreBeingBackedUpRightNow =>
      'No se están realizando copias de seguridad de ninguna foto en este momento';

  @override
  String get preserveMore => 'Preservar más';

  @override
  String get grantFullAccessPrompt =>
      'Por favor, permite el acceso a todas las fotos en Ajustes';

  @override
  String get allowPermTitle => 'Permitir el acceso a las fotos';

  @override
  String get allowPermBody =>
      'Por favor, permite el acceso a tus fotos desde Ajustes para que Ente pueda mostrar y hacer una copia de seguridad de tu biblioteca.';

  @override
  String get openSettings => 'Abrir Ajustes';

  @override
  String get selectMorePhotos => 'Seleccionar más fotos';

  @override
  String get existingUser => 'Usuario existente';

  @override
  String get privateBackups => 'Copias de seguridad privadas';

  @override
  String get forYourMemories => 'para tus recuerdos';

  @override
  String get endtoendEncryptedByDefault =>
      'Encriptado de extremo a extremo por defecto';

  @override
  String get safelyStored => 'Almacenado con seguridad';

  @override
  String get atAFalloutShelter => 'en un refugio blindado';

  @override
  String get designedToOutlive => 'Diseñado para sobrevivir';

  @override
  String get available => 'Disponible';

  @override
  String get everywhere => 'todas partes';

  @override
  String get androidIosWebDesktop => 'Android, iOS, Web, Computadora';

  @override
  String get mobileWebDesktop => 'Celular, Web, Computadora';

  @override
  String get newToEnte => 'Nuevo en Ente';

  @override
  String get pleaseLoginAgain => 'Por favor, vuelve a iniciar sesión';

  @override
  String get autoLogoutMessage =>
      'Debido a un fallo técnico, has sido desconectado. Nuestras disculpas por las molestias.';

  @override
  String get yourSubscriptionHasExpired => 'Tu suscripción ha caducado';

  @override
  String get storageLimitExceeded => 'Límite de datos excedido';

  @override
  String get upgrade => 'Mejorar';

  @override
  String get raiseTicket => 'Generar ticket';

  @override
  String get backupFailed => 'La copia de seguridad ha fallado';

  @override
  String get sorryBackupFailedDesc =>
      'Lo sentimos, no hemos podido hacer una copia de seguridad de este archivo, lo intentaremos más tarde.';

  @override
  String get couldNotBackUpTryLater =>
      'No pudimos hacer una copia de seguridad de tus datos.\nVolveremos a intentarlo más tarde.';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      'Ente puede cifrar y preservar archivos solo si concedes acceso a ellos';

  @override
  String get pleaseGrantPermissions => 'Por favor, concede permiso';

  @override
  String get grantPermission => 'Conceder permiso';

  @override
  String get privateSharing => 'Compartir en privado';

  @override
  String get shareOnlyWithThePeopleYouWant =>
      'Comparte sólo con la gente que quieres';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      'Usar enlaces públicos para personas que no están en Ente';

  @override
  String get allowPeopleToAddPhotos => 'Permitir que la gente añada fotos';

  @override
  String get shareAnAlbumNow => 'Compartir un álbum ahora';

  @override
  String get collectEventPhotos => 'Recopilar fotos del evento';

  @override
  String get sessionExpired => 'La sesión ha expirado';

  @override
  String get loggingOut => 'Cerrando sesión...';

  @override
  String get onDevice => 'En el dispositivo';

  @override
  String get onEnte => 'En <branding>ente</branding>';

  @override
  String get name => 'Nombre';

  @override
  String get newest => 'Más reciente';

  @override
  String get lastUpdated => 'Última actualización';

  @override
  String get deleteEmptyAlbums => 'Eliminar álbumes vacíos';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => '¿Eliminar álbumes vacíos?';

  @override
  String get deleteAlbumsDialogBody =>
      'Esto eliminará todos los álbumes vacíos. Esto es útil cuando quieres reducir el desorden en tu lista de álbumes.';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return 'Borrando $currentlyDeleting / $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return 'Procesando $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => 'Borrar permanentemente';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou =>
      'Sólo puedes crear un enlace para archivos de tu propiedad';

  @override
  String get publicLinkCreated => 'Enlace público creado';

  @override
  String get youCanManageYourLinksInTheShareTab =>
      'Puedes administrar tus enlaces en la pestaña compartir.';

  @override
  String get linkCopiedToClipboard => 'Enlace copiado al portapapeles';

  @override
  String get restore => 'Restaurar';

  @override
  String get moveToAlbum => 'Mover al álbum';

  @override
  String get unhide => 'Dejar de ocultar';

  @override
  String get unarchive => 'Desarchivar';

  @override
  String get favorite => 'Favorito';

  @override
  String get removeFromFavorite => 'Remover desde favoritos';

  @override
  String get shareLink => 'Compartir enlace';

  @override
  String get createCollage => 'Crear un collage';

  @override
  String get saveCollage => 'Guardar collage';

  @override
  String get collageSaved => 'Collage guardado en la galería';

  @override
  String get collageLayout => 'Disposición';

  @override
  String get addToEnte => 'Añadir a Ente';

  @override
  String get addToAlbum => 'Añadir al álbum';

  @override
  String get delete => 'Eliminar';

  @override
  String get hide => 'Ocultar';

  @override
  String get share => 'Compartir';

  @override
  String get unhideToAlbum => 'Hacer visible al álbum';

  @override
  String get restoreToAlbum => 'Restaurar al álbum';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Mover objetos',
      one: 'Mover objeto',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Añadir objetos',
      one: 'Añadir objeto',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'Crear o seleccionar álbum';

  @override
  String get selectAlbum => 'Seleccionar álbum';

  @override
  String get searchByAlbumNameHint => 'Nombre del álbum';

  @override
  String get albumTitle => 'Título del álbum';

  @override
  String get enterAlbumName => 'Introduce el nombre del álbum';

  @override
  String get restoringFiles => 'Restaurando los archivos...';

  @override
  String get movingFilesToAlbum => 'Moviendo archivos al álbum...';

  @override
  String get unhidingFilesToAlbum => 'Desocultando archivos del álbum';

  @override
  String get canNotUploadToAlbumsOwnedByOthers =>
      'No se puede subir a álbumes que sean propiedad de otros';

  @override
  String get uploadingFilesToAlbum => 'Subiendo archivos al álbum...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return 'Añadido exitosamente a  $albumName';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return 'Movido exitosamente a $albumName';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'Este álbum ya tiene un enlace de colaboración';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return 'Enlace colaborativo creado para $albumName';
  }

  @override
  String get askYourLovedOnesToShare =>
      'Pide a tus seres queridos que compartan';

  @override
  String get invite => 'Invitar';

  @override
  String get shareYourFirstAlbum => 'Comparte tu primer álbum';

  @override
  String sharedWith({required Object emailIDs}) {
    return 'Compartido con $emailIDs';
  }

  @override
  String get sharedWithMe => 'Compartido conmigo';

  @override
  String get sharedByMe => 'Compartido por mí';

  @override
  String get doubleYourStorage => 'Duplica tu almacenamiento';

  @override
  String get referFriendsAnd2xYourPlan => 'Refiere a amigos y 2x su plan';

  @override
  String get shareAlbumHint =>
      'Abre un álbum y pulsa el botón compartir en la parte superior derecha para compartir.';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      'Los artículos muestran el número de días restantes antes de ser borrados permanente';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count días',
      one: '1 día',
      zero: 'Pronto',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => 'Borrar Todo';

  @override
  String get renameAlbum => 'Renombrar álbum';

  @override
  String get convertToAlbum => 'Convertir a álbum';

  @override
  String get setCover => 'Definir portada';

  @override
  String get sortAlbumsBy => 'Ordenar por';

  @override
  String get sortNewestFirst => 'Más recientes primero';

  @override
  String get sortOldestFirst => 'Más antiguos primero';

  @override
  String get rename => 'Renombrar';

  @override
  String get leaveSharedAlbum => '¿Dejar álbum compartido?';

  @override
  String get leaveAlbum => 'Abandonar álbum';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'Las fotos añadidas por ti serán removidas del álbum';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted =>
      'No tienes archivos en este álbum que puedan ser borrados';

  @override
  String get youDontHaveAnyArchivedItems =>
      'No tienes ningún elemento archivado.';

  @override
  String get ignoredFolderUploadReason =>
      'Algunos archivos de este álbum son ignorados de la carga porque previamente habían sido borrados de Ente.';

  @override
  String get resetIgnoredFiles => 'Restablecer archivos ignorados';

  @override
  String get deviceFilesAutoUploading =>
      'Los archivos añadidos a este álbum de dispositivo se subirán automáticamente a Ente.';

  @override
  String get turnOnBackupForAutoUpload =>
      'Activar la copia de seguridad para subir automáticamente archivos añadidos a la carpeta de este dispositivo a Ente.';

  @override
  String get noHiddenPhotosOrVideos => 'No hay fotos ni vídeos ocultos';

  @override
  String get toHideAPhotoOrVideo => 'Para ocultar una foto o vídeo';

  @override
  String get openTheItem => '• Abrir el elemento';

  @override
  String get clickOnTheOverflowMenu => '• Haga clic en el menú desbordante';

  @override
  String get click => '• Clic';

  @override
  String get nothingToSeeHere => '¡No hay nada que ver aquí! 👀';

  @override
  String get unarchiveAlbum => 'Desarchivar álbum';

  @override
  String get archiveAlbum => 'Archivar álbum';

  @override
  String get calculating => 'Calculando...';

  @override
  String get pleaseWaitDeletingAlbum => 'Por favor espera. Borrando el álbum';

  @override
  String get searchByExamples =>
      '• Nombres de álbumes (por ejemplo, \"Cámara\")\n• Tipos de archivos (por ejemplo, \"Vídeos\", \".gif\")\n• Años y meses (por ejemplo, \"2022\", \"Enero\")\n• Vacaciones (por ejemplo, \"Navidad\")\n• Descripciones fotográficas (por ejemplo, \"#diversión\")';

  @override
  String get youCanTrySearchingForADifferentQuery =>
      'Puedes intentar buscar una consulta diferente.';

  @override
  String get noResultsFound => 'No se han encontrado resultados';

  @override
  String addedBy({required Object emailOrName}) {
    return 'Añadido por $emailOrName';
  }

  @override
  String get loadingExifData => 'Cargando datos EXIF...';

  @override
  String get viewAllExifData => 'Ver todos los datos EXIF';

  @override
  String get noExifData => 'No hay datos EXIF';

  @override
  String get thisImageHasNoExifData => 'Esta imagen no tiene datos exif';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => 'Sin resultados';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'No admitimos la edición de fotos y álbumes que aún no son tuyos';

  @override
  String get failedToFetchOriginalForEdit =>
      'No se pudo obtener el original para editar';

  @override
  String get close => 'Cerca';

  @override
  String get setAs => 'Establecer como';

  @override
  String get fileSavedToGallery => 'Archivo guardado en la galería';

  @override
  String get filesSavedToGallery => 'Archivo guardado en la galería';

  @override
  String get fileFailedToSaveToGallery =>
      'No se pudo guardar el archivo en la galería';

  @override
  String get download => 'Descargar';

  @override
  String get pressAndHoldToPlayVideo =>
      'Presiona y mantén presionado para reproducir el vídeo';

  @override
  String get pressAndHoldToPlayVideoDetailed =>
      'Mantén pulsada la imagen para reproducir el vídeo';

  @override
  String get downloadFailed => 'Descarga fallida';

  @override
  String get deduplicateFiles => 'Deduplicar archivos';

  @override
  String get deselectAll => 'Deseleccionar todo';

  @override
  String get reviewDeduplicateItems =>
      'Por favor, revisa y elimina los elementos que crees que están duplicados.';

  @override
  String get clubByCaptureTime => 'Agrupar por tiempo de captura';

  @override
  String get clubByFileName => 'Club por nombre de archivo';

  @override
  String get count => 'Cuenta';

  @override
  String get totalSize => 'Tamaño total';

  @override
  String get longpressOnAnItemToViewInFullscreen =>
      'Manten presionado un elemento para ver en pantalla completa';

  @override
  String get decryptingVideo => 'Descifrando vídeo...';

  @override
  String get authToViewYourMemories =>
      'Por favor, autentícate para ver tus recuerdos';

  @override
  String get unlock => 'Desbloquear';

  @override
  String get freeUpSpace => 'Liberar espacio';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Se pueden eliminar del dispositivo para liberar $formattedSize',
      one: 'Se puede eliminar del dispositivo para liberar $formattedSize',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber archivos',
      one: '1 archivo',
    );
    return 'Se ha realizado la copia de seguridad de $_temp0 de este álbum de forma segura';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber archivos',
      one: '1 archivo',
    );
    return 'Se ha realizado la copia de seguridad de $_temp0 de este dispositivo de forma segura';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'a ellos',
      one: 'a él',
    );
    return 'Aún puedes acceder $_temp0 en Ente mientras tengas una suscripción activa';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return 'Liberar $sizeInMBorGB';
  }

  @override
  String get thisEmailIsAlreadyInUse =>
      'Este correo electrónico ya está en uso';

  @override
  String get incorrectCode => 'Código incorrecto';

  @override
  String get authenticationFailedPleaseTryAgain =>
      'Error de autenticación, por favor inténtalo de nuevo';

  @override
  String get verificationFailedPleaseTryAgain =>
      'Verificación fallida, por favor inténtalo de nuevo';

  @override
  String get authenticating => 'Autenticando...';

  @override
  String get authenticationSuccessful => '¡Autenticación exitosa!';

  @override
  String get incorrectRecoveryKey => 'Clave de recuperación incorrecta';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect =>
      'La clave de recuperación introducida es incorrecta';

  @override
  String get twofactorAuthenticationSuccessfullyReset =>
      'Autenticación de doble factor restablecida con éxito';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered =>
      'Por favor, verifica el código que has introducido';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      'Por favor, contacta a soporte técnico si el problema persiste';

  @override
  String get twofactorAuthenticationHasBeenDisabled =>
      'La autenticación de dos factores fue deshabilitada';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect =>
      'Lo sentimos, el código que has introducido es incorrecto';

  @override
  String get yourVerificationCodeHasExpired =>
      'Tu código de verificación ha expirado';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'Correo cambiado a $newEmail';
  }

  @override
  String get verifying => 'Verificando...';

  @override
  String get disablingTwofactorAuthentication =>
      'Deshabilitando la autenticación de dos factores...';

  @override
  String get allMemoriesPreserved => 'Todos los recuerdos preservados';

  @override
  String get loadingGallery => 'Cargando galería...';

  @override
  String get syncing => 'Sincronizando...';

  @override
  String get encryptingBackup => 'Cifrando copia de seguridad...';

  @override
  String get syncStopped => 'Sincronización detenida';

  @override
  String syncProgress({required String completed, required String total}) {
    return '$completed/$total recuerdos conservados';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return 'Preservando $count memorias...';
  }

  @override
  String get uploadingSingleMemory => 'Preservando 1 memoria...';

  @override
  String get archiving => 'Archivando...';

  @override
  String get unarchiving => 'Desarchivando...';

  @override
  String get successfullyArchived => 'Archivado correctamente';

  @override
  String get successfullyUnarchived => 'Desarchivado correctamente';

  @override
  String get renameFile => 'Renombrar archivo';

  @override
  String get enterFileName => 'Introduce el nombre del archivo';

  @override
  String get filesDeleted => 'Archivos eliminados';

  @override
  String get selectedFilesAreNotOnEnte =>
      'Los archivos seleccionados no están en Ente';

  @override
  String get thisActionCannotBeUndone => 'Esta acción no se puede deshacer';

  @override
  String get emptyTrash => '¿Vaciar la papelera?';

  @override
  String get permDeleteWarning =>
      'Todos los elementos de la papelera serán eliminados permanentemente\n\nEsta acción no se puede deshacer';

  @override
  String get empty => 'Vaciar';

  @override
  String get couldNotFreeUpSpace => 'No se pudo liberar espacio';

  @override
  String get permanentlyDeleteFromDevice =>
      '¿Eliminar permanentemente del dispositivo?';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      'Algunos de los archivos que estás intentando eliminar sólo están disponibles en tu dispositivo y no pueden ser recuperados si se eliminan';

  @override
  String get theyWillBeDeletedFromAllAlbums =>
      'Se borrarán de todos los álbumes.';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'Algunos elementos están tanto en Ente como en tu dispositivo.';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      'Los archivos seleccionados serán eliminados de todos los álbumes y movidos a la papelera.';

  @override
  String get theseItemsWillBeDeletedFromYourDevice =>
      'Estos elementos se eliminarán de tu dispositivo.';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      'Parece que algo salió mal. Por favor, vuelve a intentarlo después de algún tiempo. Si el error persiste, ponte en contacto con nuestro equipo de soporte.';

  @override
  String get error => 'Error';

  @override
  String get tempErrorContactSupportIfPersists =>
      'Parece que algo salió mal. Por favor, vuelve a intentarlo después de algún tiempo. Si el error persiste, ponte en contacto con nuestro equipo de soporte.';

  @override
  String get networkHostLookUpErr =>
      'No se puede conectar a Ente. Por favor, comprueba tu configuración de red y ponte en contacto con el soporte técnico si el error persiste.';

  @override
  String get networkConnectionRefusedErr =>
      'No se puede conectar a Ente. Por favor, vuelve a intentarlo pasado un tiempo. Si el error persiste, ponte en contacto con el soporte técnico.';

  @override
  String get cachedData => 'Datos almacenados en caché';

  @override
  String get clearCaches => 'Limpiar cachés';

  @override
  String get remoteImages => 'Imágenes remotas';

  @override
  String get remoteVideos => 'Vídeos remotos';

  @override
  String get remoteThumbnails => 'Miniaturas remotas';

  @override
  String get pendingSync => 'Sincronización pendiente';

  @override
  String get localGallery => 'Galería local';

  @override
  String get todaysLogs => 'Registros de hoy';

  @override
  String get viewLogs => 'Ver Registros';

  @override
  String get logsDialogBody =>
      'Esto enviará registros para ayudarnos a depurar su problema. Ten en cuenta que los nombres de los archivos se incluirán para ayudar a rastrear problemas con archivos específicos.';

  @override
  String get preparingLogs => 'Preparando registros...';

  @override
  String get emailYourLogs => 'Envía tus registros por correo electrónico';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'Por favor, envía los registros a $toEmail';
  }

  @override
  String get copyEmailAddress => 'Copiar dirección de correo electrónico';

  @override
  String get exportLogs => 'Exportar registros';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return 'Por favor, envíanos un correo electrónico a $toEmail';
  }

  @override
  String get dismiss => 'Descartar';

  @override
  String get didYouKnow => '¿Sabías que?';

  @override
  String get loadingMessage => 'Cargando tus fotos...';

  @override
  String get loadMessage1 => 'Puedes compartir tu suscripción con tu familia';

  @override
  String get loadMessage2 =>
      'Hasta ahora hemos conservado más de 200 millones de recuerdos';

  @override
  String get loadMessage3 =>
      'Guardamos 3 copias de tus datos, una en un refugio subterráneo';

  @override
  String get loadMessage4 =>
      'Todas nuestras aplicaciones son de código abierto';

  @override
  String get loadMessage5 =>
      'Nuestro código fuente y criptografía han sido auditados externamente';

  @override
  String get loadMessage6 =>
      'Puedes compartir enlaces a tus álbumes con tus seres queridos';

  @override
  String get loadMessage7 =>
      'Nuestras aplicaciones móviles se ejecutan en segundo plano para cifrar y hacer copias de seguridad de las nuevas fotos que hagas clic';

  @override
  String get loadMessage8 => 'web.ente.io tiene un cargador sofisticado';

  @override
  String get loadMessage9 =>
      'Utilizamos Xchacha20Poly1305 para cifrar tus datos de forma segura';

  @override
  String get photoDescriptions => 'Descripciones de fotos';

  @override
  String get fileTypesAndNames => 'Tipos de archivo y nombres';

  @override
  String get location => 'Ubicación';

  @override
  String get moments => 'Momentos';

  @override
  String get searchFaceEmptySection =>
      'Las personas se mostrarán aquí una vez que se haya hecho la indexación';

  @override
  String get searchDatesEmptySection => 'Buscar por fecha, mes o año';

  @override
  String get searchLocationEmptySection =>
      'Agrupar las fotos que se tomaron cerca de la localización de una foto';

  @override
  String get searchPeopleEmptySection =>
      'Invita a gente y verás todas las fotos compartidas aquí';

  @override
  String get searchAlbumsEmptySection => 'Álbumes';

  @override
  String get searchFileTypesAndNamesEmptySection =>
      'Tipos y nombres de archivo';

  @override
  String get searchCaptionEmptySection =>
      'Agrega descripciones como \"#viaje\" en la información de la foto para encontrarlas aquí rápidamente';

  @override
  String get language => 'Idioma';

  @override
  String get selectLanguage => 'Seleccionar idioma';

  @override
  String get locationName => 'Nombre de la ubicación';

  @override
  String get addLocation => 'Agregar ubicación';

  @override
  String get groupNearbyPhotos => 'Agrupar fotos cercanas';

  @override
  String get kiloMeterUnit => 'km';

  @override
  String get addLocationButton => 'Añadir';

  @override
  String get radius => 'Radio';

  @override
  String get locationTagFeatureDescription =>
      'Una etiqueta de ubicación agrupa todas las fotos que fueron tomadas dentro de un radio de una foto';

  @override
  String get galleryMemoryLimitInfo =>
      'Hasta 1000 memorias mostradas en la galería';

  @override
  String get save => 'Guardar';

  @override
  String get centerPoint => 'Punto central';

  @override
  String get pickCenterPoint => 'Elegir punto central';

  @override
  String get useSelectedPhoto => 'Usar foto seleccionada';

  @override
  String get resetToDefault => 'Restablecer valores predeterminados';

  @override
  String get edit => 'Editar';

  @override
  String get deleteLocation => 'Borrar la ubicación';

  @override
  String get rotateLeft => 'Girar a la izquierda';

  @override
  String get flip => 'Voltear';

  @override
  String get rotateRight => 'Girar a la derecha';

  @override
  String get saveCopy => 'Guardar copia';

  @override
  String get light => 'Brillo';

  @override
  String get color => 'Color';

  @override
  String get yesDiscardChanges => 'Sí, descartar cambios';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade =>
      '¿Quieres descartar las ediciones que has hecho?';

  @override
  String get saving => 'Saving...';

  @override
  String get editsSaved => 'Ediciones guardadas';

  @override
  String get oopsCouldNotSaveEdits =>
      'Ups, no se pudieron guardar las ediciónes';

  @override
  String get distanceInKMUnit => 'km';

  @override
  String get dayToday => 'Hoy';

  @override
  String get dayYesterday => 'Ayer';

  @override
  String get storage => 'Almacenamiento';

  @override
  String get usedSpace => 'Espacio usado';

  @override
  String get storageBreakupFamily => 'Familia';

  @override
  String get storageBreakupYou => 'Usted';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return '$usedAmount $usedStorageUnit de $totalAmount $totalStorageUnit usados';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return '$freeAmount $storageUnit disponible';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'Versión: $versionValue';
  }

  @override
  String get verifyIDLabel => 'Verificar';

  @override
  String get fileInfoAddDescHint => 'Añadir descripción...';

  @override
  String get editLocationTagTitle => 'Editar la ubicación';

  @override
  String get setLabel => 'Establecer';

  @override
  String get setRadius => 'Establecer radio';

  @override
  String get familyPlanPortalTitle => 'Familia';

  @override
  String get familyPlanOverview =>
      'Añade 5 familiares a tu plan existente sin pagar más.\n\nCada miembro tiene su propio espacio privado y no puede ver los archivos del otro a menos que sean compartidos.\n\nLos planes familiares están disponibles para los clientes que tienen una suscripción de Ente pagada.\n\n¡Suscríbete ahora para empezar!';

  @override
  String get androidBiometricHint => 'Verificar identidad';

  @override
  String get androidBiometricNotRecognized =>
      'No reconocido. Inténtelo nuevamente.';

  @override
  String get androidBiometricSuccess => 'Listo';

  @override
  String get androidCancelButton => 'Cancelar';

  @override
  String get androidSignInTitle => 'Se necesita autenticación biométrica';

  @override
  String get androidBiometricRequiredTitle =>
      'Autenticación biométrica necesaria';

  @override
  String get androidDeviceCredentialsRequiredTitle =>
      'Se necesitan credenciales de dispositivo';

  @override
  String get androidDeviceCredentialsSetupDescription =>
      'Se necesitan credenciales de dispositivo';

  @override
  String get goToSettings => 'Ir a Ajustes';

  @override
  String get androidGoToSettingsDescription =>
      'La autenticación biométrica no está configurada en su dispositivo. \'Ve a Ajustes > Seguridad\' para añadir autenticación biométrica.';

  @override
  String get iOSLockOut =>
      'La autenticación biométrica está deshabilitada. Por favor, bloquea y desbloquea la pantalla para habilitarla.';

  @override
  String get iOSGoToSettingsDescription =>
      'La autenticación biométrica no está configurada en tu dispositivo. Por favor, activa Touch ID o Face ID en tu teléfono.';

  @override
  String get iOSOkButton => 'Aceptar';

  @override
  String get openstreetmapContributors => 'Contribuidores de OpenStreetMap';

  @override
  String get hostedAtOsmFrance => 'Alojado en OSM France';

  @override
  String get map => 'Mapa';

  @override
  String get maps => 'Mapas';

  @override
  String get mapsPrivacyNotice =>
      'Las coordenadas aproximadas se enviarán a terceras partes conscientes de la privacidad como OpenStreetMap para mostrar el mapa y la ubicación.';

  @override
  String get enableMaps => 'Habilitar mapas';

  @override
  String get quickLinks => 'Acceso rápido';

  @override
  String get selectItemsToAdd => 'Selecciona elementos para agregar';

  @override
  String get addSelected => 'Agregar selección';

  @override
  String get addFromDevice => 'Agregar desde el dispositivo';

  @override
  String get addPhotos => 'Agregar fotos';

  @override
  String get noPhotosFoundHere => 'No se encontró ninguna foto aquí';

  @override
  String get zoomOutToSeePhotos => 'Alejar para ver las fotos';

  @override
  String get noImagesWithLocation => 'No hay imágenes con ubicación';

  @override
  String get unpinAlbum => 'Dejar de fijar álbum';

  @override
  String get pinAlbum => 'Fijar álbum';

  @override
  String get pin => 'Anclar';

  @override
  String get pinPerson => 'Pin person';

  @override
  String get pinToTop => 'Anclar al principio';

  @override
  String get unpin => 'Desanclar';

  @override
  String get unpinPerson => 'Unpin person';

  @override
  String get visibility => 'Visibilidad';

  @override
  String get hideFromMemories => 'Ocultar de los recuerdos';

  @override
  String get showInMemories => 'Mostrar en recuerdos';

  @override
  String get create => 'Crear';

  @override
  String get viewAll => 'Ver todo';

  @override
  String get nothingSharedWithYouYet => 'Aún no hay nada compartido contigo';

  @override
  String get noAlbumsSharedByYouYet => 'Aún no has compartido ningún álbum';

  @override
  String get sharedWithYou => 'Compartido contigo';

  @override
  String get sharedByYou => 'Compartido por ti';

  @override
  String get inviteYourFriendsToEnte => 'Invita a tus amigos a Ente';

  @override
  String get failedToDownloadVideo => 'Error al descargar el vídeo';

  @override
  String get hiding => 'Ocultando...';

  @override
  String get unhiding => 'Desocultando...';

  @override
  String get successfullyHid => 'Ocultado con éxito';

  @override
  String get successfullyUnhid => 'Desocultado con éxito';

  @override
  String get crashReporting => 'Reporte de errores';

  @override
  String get resumableUploads => 'Subidas reanudables';

  @override
  String get addToHiddenAlbum => 'Añadir al álbum oculto';

  @override
  String get moveToHiddenAlbum => 'Mover al álbum oculto';

  @override
  String get fileTypes => 'Tipos de archivos';

  @override
  String get deleteConfirmDialogBody =>
      'Esta cuenta está vinculada a otras aplicaciones de Ente, si utilizas alguna. Se programará la eliminación de los datos cargados en todas las aplicaciones de Ente, y tu cuenta se eliminará permanentemente.';

  @override
  String get hearUsWhereTitle => '¿Cómo escuchaste acerca de Ente? (opcional)';

  @override
  String get hearUsExplanation =>
      'No rastreamos las aplicaciones instaladas. ¡Nos ayudarías si nos dijeras dónde nos encontraste!';

  @override
  String get viewAddOnButton => 'Ver complementos';

  @override
  String get addOns => 'Complementos';

  @override
  String get addOnPageSubtitle => 'Detalles de los complementos';

  @override
  String get yourMap => 'Tu mapa';

  @override
  String get modifyYourQueryOrTrySearchingFor =>
      'Modifica tu consulta o intenta buscar';

  @override
  String get blackFridaySale => 'Oferta del Black Friday';

  @override
  String get upto50OffUntil4thDec =>
      'Hasta el 50% de descuento, hasta el 4 de diciembre.';

  @override
  String get photos => 'Fotos';

  @override
  String get videos => 'Vídeos';

  @override
  String get livePhotos => 'Foto en vivo';

  @override
  String get searchHint1 => 'Búsqueda rápida en el dispositivo';

  @override
  String get searchHint2 => 'Fechas de fotos, descripciones';

  @override
  String get searchHint3 => 'Álbumes, nombres de archivos y tipos';

  @override
  String get searchHint4 => 'Ubicación';

  @override
  String get searchHint5 => 'Próximamente: Caras y búsqueda mágica ✨';

  @override
  String get addYourPhotosNow => 'Añade tus fotos ahora';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count resultados encontrados',
      one: '$count resultado encontrado',
    );
    return '$_temp0';
  }

  @override
  String get faces => 'Caras';

  @override
  String get people => 'Personas';

  @override
  String get contents => 'Contenidos';

  @override
  String get addNew => 'Añadir nuevo';

  @override
  String get contacts => 'Contactos';

  @override
  String get noInternetConnection => 'No hay conexión al Internet';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'Por favor, revisa tu conexión a Internet e inténtalo otra vez.';

  @override
  String get signOutFromOtherDevices => 'Cerrar sesión de otros dispositivos';

  @override
  String get signOutOtherBody =>
      'Si crees que alguien puede conocer tu contraseña, puedes forzar a todos los demás dispositivos que usan tu cuenta a cerrar la sesión.';

  @override
  String get signOutOtherDevices => 'Cerrar la sesión de otros dispositivos';

  @override
  String get doNotSignOut => 'No cerrar la sesión';

  @override
  String get editLocation => 'Editar la ubicación';

  @override
  String get selectALocation => 'Seleccionar una ubicación';

  @override
  String get selectALocationFirst => 'Primero, selecciona una ubicación';

  @override
  String get changeLocationOfSelectedItems =>
      '¿Cambiar la ubicación de los elementos seleccionados?';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte =>
      'Las ediciones a la ubicación sólo se verán dentro de Ente';

  @override
  String get cleanUncategorized => 'Limpiar sin categorizar';

  @override
  String get cleanUncategorizedDescription =>
      'Elimina todos los archivos de Sin categorizar que están presentes en otros álbumes';

  @override
  String get waitingForVerification => 'Esperando verificación...';

  @override
  String get passkey => 'Clave de acceso';

  @override
  String get passkeyAuthTitle => 'Verificación de clave de acceso';

  @override
  String get loginWithTOTP => 'Iniciar sesión con TOTP';

  @override
  String get passKeyPendingVerification => 'La verificación aún está pendiente';

  @override
  String get loginSessionExpired => 'La sesión ha expirado';

  @override
  String get loginSessionExpiredDetails =>
      'Tu sesión ha expirado. Por favor, vuelve a iniciar sesión.';

  @override
  String get verifyPasskey => 'Verificar clave de acceso';

  @override
  String get playOnTv => 'Reproducir álbum en TV';

  @override
  String get pair => 'Emparejar';

  @override
  String get deviceNotFound => 'Dispositivo no encontrado';

  @override
  String get castInstruction =>
      'Visita cast.ente.io en el dispositivo que quieres emparejar.\n\nIntroduce el código de abajo para reproducir el álbum en tu TV.';

  @override
  String get deviceCodeHint => 'Introduce el código';

  @override
  String get joinDiscord => 'Únete al Discord';

  @override
  String get locations => 'Ubicaciones';

  @override
  String get addAName => 'Añade un nombre';

  @override
  String get findThemQuickly => 'Encuéntralos rápidamente';

  @override
  String get findPeopleByName => 'Encuentra gente rápidamente por su nombre';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Añadir espectadores',
      one: 'Añadir espectador',
      zero: 'Añadir espectador',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Añadir colaboradores',
      one: 'Añadir colaborador',
      zero: 'Añadir colaborador',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      'Mantén pulsado un correo electrónico para verificar el cifrado de extremo a extremo.';

  @override
  String get developerSettingsWarning =>
      '¿Estás seguro de que quieres modificar los ajustes de desarrollador?';

  @override
  String get developerSettings => 'Ajustes de desarrollador';

  @override
  String get serverEndpoint => 'Punto final del servidor';

  @override
  String get invalidEndpoint => 'Punto final no válido';

  @override
  String get invalidEndpointMessage =>
      'Lo sentimos, el punto final introducido no es válido. Por favor, introduce un punto final válido y vuelve a intentarlo.';

  @override
  String get endpointUpdatedMessage => 'Punto final actualizado con éxito';

  @override
  String customEndpoint({required Object endpoint}) {
    return 'Conectado a $endpoint';
  }

  @override
  String get createCollaborativeLink => 'Crear enlace colaborativo';

  @override
  String get search => 'Buscar';

  @override
  String get enterPersonName => 'Ingresar el nombre de una persona';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'Este correo electrónico ya está vinculado a $name.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return 'Ver $name para desvincular';
  }

  @override
  String get enterName => 'Introducir nombre';

  @override
  String get savePerson => 'Guardar persona';

  @override
  String get editPerson => 'Editar persona';

  @override
  String get mergedPhotos => 'Fotos combinadas';

  @override
  String get orMergeWithExistingPerson => 'O combinar con persona existente';

  @override
  String get enterDateOfBirth => 'Cumpleaños (opcional)';

  @override
  String get birthday => 'Cumpleaños';

  @override
  String get removePersonLabel => 'Eliminar etiqueta de persona';

  @override
  String get removePersonTag => 'Remove person tag';

  @override
  String get areYouSureRemoveThisPersonTag =>
      'Are you sure you want to remove this person tag?';

  @override
  String get autoPairDesc =>
      'El emparejamiento automático funciona sólo con dispositivos compatibles con Chromecast.';

  @override
  String get manualPairDesc =>
      'El emparejamiento con PIN funciona con cualquier pantalla en la que desees ver tu álbum.';

  @override
  String get connectToDevice => 'Conectar a dispositivo';

  @override
  String get autoCastDialogBody =>
      'Aquí verás los dispositivos de transmisión disponibles.';

  @override
  String get autoCastiOSPermission =>
      'Asegúrate de que los permisos de la red local están activados para la aplicación Ente Fotos, en Configuración.';

  @override
  String get noDeviceFound => 'No se encontró ningún dispositivo';

  @override
  String get stopCastingTitle => 'Detener la transmisión';

  @override
  String get stopCastingBody => '¿Quieres dejar de transmitir?';

  @override
  String get castIPMismatchTitle => 'Error al transmitir álbum';

  @override
  String get castIPMismatchBody =>
      'Por favor, asegúrate de estar en la misma red que el televisor.';

  @override
  String get pairingComplete => 'Emparejamiento completo';

  @override
  String get savingEdits => 'Guardando las ediciones...';

  @override
  String get autoPair => 'Emparejamiento automático';

  @override
  String get pairWithPin => 'Emparejar con PIN';

  @override
  String get faceRecognition => 'Reconocimiento facial';

  @override
  String get foundFaces => 'Caras encontradas';

  @override
  String get clusteringProgress => 'Proceso de agrupación';

  @override
  String get trim => 'Ajustar duración';

  @override
  String get crop => 'Ajustar encuadre';

  @override
  String get rotate => 'Girar';

  @override
  String get left => 'Izquierda';

  @override
  String get right => 'Derecha';

  @override
  String get whatsNew => 'Qué hay de nuevo';

  @override
  String get reviewSuggestions => 'Revisar sugerencias';

  @override
  String get review => 'Revisar';

  @override
  String get useAsCover => 'Usar como cubierta';

  @override
  String notPersonLabel({required String name}) {
    return '¿No es $name?';
  }

  @override
  String get enable => 'Habilitar';

  @override
  String get enabled => 'Habilitado';

  @override
  String get moreDetails => 'Más detalles';

  @override
  String get enableMLIndexingDesc =>
      'Ente soporta aprendizaje automático en el dispositivo para la detección de caras, búsqueda mágica y otras características de búsqueda avanzada';

  @override
  String get magicSearchHint =>
      'La búsqueda mágica permite buscar fotos por su contenido. Por ejemplo, \"flor\", \"coche rojo\", \"documentos de identidad\"';

  @override
  String get panorama => 'Panorama';

  @override
  String get reenterPassword => 'Rescribe tu contraseña';

  @override
  String get reenterPin => 'Rescribe tu PIN';

  @override
  String get deviceLock => 'Bloqueo del dispositivo';

  @override
  String get pinLock => 'Bloqueo con Pin';

  @override
  String get next => 'Siguiente';

  @override
  String get setNewPassword => 'Ingresa tu nueva contraseña';

  @override
  String get enterPin => 'Ingresa tu contraseña';

  @override
  String get setNewPin => 'Ingresa tu nuevo PIN';

  @override
  String get appLock => 'Bloqueo de aplicación';

  @override
  String get noSystemLockFound => 'Bloqueo de sistema no encontrado';

  @override
  String get tapToUnlock => 'Toca para desbloquear';

  @override
  String get tooManyIncorrectAttempts => 'Demasiados intentos incorrectos';

  @override
  String get videoInfo => 'Información de vídeo';

  @override
  String get autoLock => 'Bloqueo automático';

  @override
  String get immediately => 'Inmediatamente';

  @override
  String get autoLockFeatureDescription =>
      'Tiempo después de que la aplicación esté en segundo plano';

  @override
  String get hideContent => 'Ocultar contenido';

  @override
  String get hideContentDescriptionAndroid =>
      'Oculta el contenido de la aplicación en el selector de aplicaciones y desactivar capturas de pantalla';

  @override
  String get hideContentDescriptionIos =>
      'Ocultar el contenido de la aplicación en el selector de aplicaciones';

  @override
  String get passwordStrengthInfo =>
      'La fortaleza de la contraseña se calcula teniendo en cuenta la longitud de la contraseña, los caracteres utilizados, y si la contraseña aparece o no en el top 10.000 de contraseñas más usadas';

  @override
  String get noQuickLinksSelected => 'No se han seleccionado enlaces rápidos';

  @override
  String get pleaseSelectQuickLinksToRemove =>
      'Por favor, selecciona enlaces rápidos para eliminar';

  @override
  String get removePublicLinks => 'Eliminar enlaces públicos';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      'Esto eliminará los enlaces públicos de todos los enlaces rápidos seleccionados.';

  @override
  String get guestView => 'Vista de invitado';

  @override
  String get guestViewEnablePreSteps =>
      'Para habilitar la vista de invitados, por favor configure el código de acceso del dispositivo o el bloqueo de pantalla en los ajustes de su sistema.';

  @override
  String get nameTheAlbum => 'Nombre el álbum';

  @override
  String get collectPhotosDescription =>
      'Crea un enlace donde tus amigos pueden subir fotos en su calidad original.';

  @override
  String get collect => 'Recolectar';

  @override
  String get appLockDescriptions =>
      'Escoge entre la pantalla de bloqueo por defecto de tu dispositivo y una pantalla de bloqueo personalizada con un PIN o contraseña.';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'Para habilitar el bloqueo de la aplicación, por favor configura el código de acceso del dispositivo o el bloqueo de pantalla en los ajustes del sistema.';

  @override
  String get authToViewPasskey =>
      'Por favor, autentícate para ver tu clave de acceso';

  @override
  String get loopVideoOn => 'Desactivar bucle';

  @override
  String get loopVideoOff => 'Activar bucle';

  @override
  String get localSyncErrorMessage =>
      'Parece que algo salió mal ya que la sincronización de fotos locales está tomando más tiempo del esperado. Por favor contacta con nuestro equipo de soporte';

  @override
  String get showPerson => 'Mostrar persona';

  @override
  String get sort => 'Ordenar';

  @override
  String get mostRecent => 'Más reciente';

  @override
  String get mostRelevant => 'Más relevante';

  @override
  String get loadingYourPhotos => 'Cargando tus fotos...';

  @override
  String processingImport({required Object folderName}) {
    return 'Procesando $folderName...';
  }

  @override
  String get personName => 'Nombre de la persona';

  @override
  String get addPerson => 'Add person';

  @override
  String get addToPerson => 'Add to person';

  @override
  String get pleaseNamePersonInPeopleSectionFirst =>
      'Please name a person in the People section first';

  @override
  String get onlyUploadedFilesCanBeAddedToPerson =>
      'Only uploaded files can be added to a person';

  @override
  String get noFacesDetectedTapToAdd => 'No faces detected, tap to add.';

  @override
  String addedFilesToPerson({required int count, required String personName}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count files to $personName',
      one: 'Added 1 file to $personName',
    );
    return '$_temp0';
  }

  @override
  String filesAlreadyLinkedToPerson({
    required int count,
    required String personName,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count files are already linked to $personName',
      one: '1 file is already linked to $personName',
    );
    return '$_temp0';
  }

  @override
  String get addNewPerson => 'Añadir nueva persona';

  @override
  String get addNameOrMerge => 'Añadir nombre o combinar';

  @override
  String get mergeWithExisting => 'Combinar con existente';

  @override
  String get newPerson => 'Nueva persona';

  @override
  String get addName => 'Añadir nombre';

  @override
  String get add => 'Añadir';

  @override
  String extraPhotosFoundFor({required String text}) {
    return 'Fotos adicionales encontradas para $text';
  }

  @override
  String get extraPhotosFound => 'Fotos adicionales encontradas';

  @override
  String get configuration => 'Configuración';

  @override
  String get localIndexing => 'Indexado local';

  @override
  String get processed => 'Procesado';

  @override
  String get resetPerson => 'Eliminar';

  @override
  String get areYouSureYouWantToResetThisPerson =>
      '¿Seguro que desea eliminar esta persona?';

  @override
  String get allPersonGroupingWillReset =>
      'Se eliminarán todas las agrupaciones para esta persona, y se eliminarán todas sus sugerencias';

  @override
  String get yesResetPerson => 'Si, eliminar persona';

  @override
  String get onlyThem => 'Solo ellos';

  @override
  String get checkingModels => 'Comprobando modelos...';

  @override
  String get enableMachineLearningBanner =>
      'Activar aprendizaje automático para búsqueda mágica y reconocimiento facial';

  @override
  String get searchDiscoverEmptySection =>
      'Las imágenes se mostrarán aquí cuando se complete el procesado y la sincronización';

  @override
  String get searchPersonsEmptySection =>
      'Las personas se mostrarán aquí cuando se complete el procesado y la sincronización';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count espectadores añadidos',
      one: '1 espectador añadido',
      zero: '0 espectadores añadidos',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count colaboradores añadidos',
      one: '1 colaborador añadido',
      zero: '0 colaboradores añadidos',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured => 'La cuenta ya está configurada.';

  @override
  String get sessionIdMismatch => 'El ID de sesión no coincide';

  @override
  String get failedToFetchActiveSessions =>
      'Error al recuperar las sesiones activas';

  @override
  String get failedToRefreshStripeSubscription =>
      'Error al actualizar la suscripción';

  @override
  String get failedToPlayVideo => 'Error al reproducir el vídeo';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return 'La subida se ignoró debido a $ignoreReason';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'El tipo de galería $galleryType no es compatible con el renombrado';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'Toca para subir, la subida se está ignorando debido a $ignoreReason';
  }

  @override
  String get tapToUpload => 'Toca para subir';

  @override
  String get info => 'Info';

  @override
  String get addFiles => 'Añadir archivos';

  @override
  String get castAlbum => 'Enviar álbum';

  @override
  String get imageNotAnalyzed => 'Imagen no analizada';

  @override
  String get noFacesFound => 'No se han encontrado caras';

  @override
  String get fileNotUploadedYet => 'El archivo aún no se ha subido';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return 'No hay sugerencias para $personName';
  }

  @override
  String get month => 'mes';

  @override
  String get yearShort => 'año';

  @override
  String get currentlyRunning => 'ejecutando';

  @override
  String get ignored => 'ignorado';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count fotos',
      one: '1 foto',
      zero: '0 fotos',
    );
    return '$_temp0';
  }

  @override
  String get file => 'Archivo';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'La longitud de las secciones no coincide: $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'Seleccionar app de correo';

  @override
  String get selectAllShort => 'Todas';

  @override
  String get selectCoverPhoto => 'Seleccionar foto de portada';

  @override
  String get newLocation => 'Nueva localización';

  @override
  String get faceNotClusteredYet =>
      'Cara no agrupada todavía, por favor vuelve más tarde';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'El enlace al que intenta acceder ha caducado.';

  @override
  String get openFile => 'Abrir archivo';

  @override
  String get backupFile => 'Archivo de copia de seguridad';

  @override
  String get openAlbumInBrowser => 'Abrir álbum en el navegador';

  @override
  String get openAlbumInBrowserTitle =>
      'Por favor, utiliza la aplicación web para añadir fotos a este álbum';

  @override
  String get allow => 'Permitir';

  @override
  String get allowAppToOpenSharedAlbumLinks =>
      'Permitir a la aplicación abrir enlaces de álbum compartidos';

  @override
  String get seePublicAlbumLinksInApp =>
      'Ver enlaces del álbum público en la aplicación';

  @override
  String get emergencyContacts => 'Contactos de emergencia';

  @override
  String get acceptTrustInvite => 'Aceptar invitación';

  @override
  String get declineTrustInvite => 'Rechazar invitación';

  @override
  String get removeYourselfAsTrustedContact =>
      'Quitarse como contacto de confianza';

  @override
  String get legacy => 'Legado';

  @override
  String get legacyPageDesc =>
      'Legado permite a los contactos de confianza acceder a su cuenta en su ausencia.';

  @override
  String get legacyPageDesc2 =>
      'Los contactos de confianza pueden iniciar la recuperación de la cuenta, y si no están bloqueados en un plazo de 30 días, restablecer su contraseña y acceder a su cuenta.';

  @override
  String get legacyAccounts => 'Cuentas legadas';

  @override
  String get trustedContacts => 'Contactos de confianza';

  @override
  String get addTrustedContact => 'Añadir contacto de confianza';

  @override
  String get removeInvite => 'Eliminar invitación';

  @override
  String get recoveryWarning =>
      'Un contacto de confianza está intentando acceder a tu cuenta';

  @override
  String get rejectRecovery => 'Rechazar la recuperación';

  @override
  String get recoveryInitiated => 'Recuperación iniciada';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return 'Puedes acceder a la cuenta después de $days días. Se enviará una notificación a $email.';
  }

  @override
  String get cancelAccountRecovery => 'Cancelar la recuperación';

  @override
  String get recoveryAccount => 'Recuperar cuenta';

  @override
  String get cancelAccountRecoveryBody =>
      '¿Estás seguro de que quieres cancelar la recuperación?';

  @override
  String get startAccountRecoveryTitle => 'Iniciar la recuperación';

  @override
  String get whyAddTrustContact =>
      'Un contacto de confianza puede ayudar a recuperar sus datos.';

  @override
  String recoveryReady({required String email}) {
    return 'Ahora puedes recuperar la cuenta de $email estableciendo una nueva contraseña.';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email está intentando recuperar tu cuenta.';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return 'Has sido invitado a ser un contacto legado por $email.';
  }

  @override
  String get warning => 'Advertencia';

  @override
  String get proceed => 'Continuar';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return 'Estás a punto de añadir $email como un contacto de confianza. Esta persona podrá recuperar tu cuenta si no estás durante $numOfDays días.';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email te ha invitado a ser un contacto de confianza';
  }

  @override
  String get authToManageLegacy =>
      'Por favor, autentícate para administrar tus contactos de confianza';

  @override
  String get hideSharedItemsFromHomeGallery =>
      'Ocultar elementos compartidos de la galería de inicio';

  @override
  String get swipeToSelect => 'Desliza para seleccionar';

  @override
  String get gallery => 'Galería';

  @override
  String get joinAlbum => 'Unir álbum';

  @override
  String get joinAlbumSubtext => 'para ver y añadir tus fotos';

  @override
  String get joinAlbumSubtextViewer =>
      'para añadir esto a los álbumes compartidos';

  @override
  String get join => 'Unir';

  @override
  String get linkEmail => 'Vincular correo electrónico';

  @override
  String get link => 'Enlace';

  @override
  String get noEnteAccountExclamation => '¡No existe una cuenta de Ente!';

  @override
  String get orPickFromYourContacts => 'o elige de entre tus contactos';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return '$email no tiene una cuenta de Ente.';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (Yo)';
  }

  @override
  String get reassignMe => 'Reasignar \"Yo\"';

  @override
  String get me => 'Yo';

  @override
  String get linkEmailToContactBannerCaption => 'para compartir más rápido';

  @override
  String get selectPersonToLink => 'Selecciona persona a vincular';

  @override
  String linkPersonToEmail({required String email}) {
    return 'Enlazar persona a $email';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return 'Esto enlazará a $personName a $email';
  }

  @override
  String get selectYourFace => 'Selecciona tu cara';

  @override
  String get reassigningLoading => 'Reasignando...';

  @override
  String reassignedToName({required String name}) {
    return 'Te has reasignado a $name';
  }

  @override
  String get saveChangesBeforeLeavingQuestion =>
      '¿Guardar cambios antes de salir?';

  @override
  String get dontSave => 'No guardar';

  @override
  String get thisIsMeExclamation => '¡Este soy yo!';

  @override
  String get linkPerson => 'Vincular persona';

  @override
  String get linkPersonCaption => 'para una mejor experiencia compartida';

  @override
  String get videoStreaming => 'Vídeos en transmisión';

  @override
  String get processingVideos => 'Procesando vídeos';

  @override
  String get streamDetails => 'Detalles de la transmisión';

  @override
  String get processing => 'Procesando';

  @override
  String get queued => 'En cola';

  @override
  String get ineligible => 'Inelegible';

  @override
  String get failed => 'Fallido';

  @override
  String get playStream => 'Reproducir transmisión';

  @override
  String get playOriginal => 'Reproducir original';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'Unirse a un álbum hará visible tu correo electrónico a sus participantes.';

  @override
  String get pleaseWaitThisWillTakeAWhile => 'Espera. Esto tardará un poco.';

  @override
  String get editTime => 'Editar hora';

  @override
  String get selectTime => 'Seleccionar hora';

  @override
  String get selectDate => 'Seleccionar fecha';

  @override
  String get previous => 'Anterior';

  @override
  String get selectOneDateAndTimeForAll =>
      'Seleccione una fecha y hora para todas';

  @override
  String get selectStartOfRange => 'Seleccionar inicio del rango';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      'Esto hará que la fecha y la hora de todas las fotos seleccionadas sean las mismas.';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'Este es el primero en el grupo. Otras fotos seleccionadas cambiarán automáticamente basándose en esta nueva fecha';

  @override
  String get newRange => 'Nuevo rango';

  @override
  String get selectOneDateAndTime => 'Seleccionar fecha y hora';

  @override
  String get moveSelectedPhotosToOneDate =>
      'Mover las fotos seleccionadas a una fecha';

  @override
  String get shiftDatesAndTime => 'Cambiar fechas y hora';

  @override
  String get photosKeepRelativeTimeDifference =>
      'Las fotos mantienen una diferencia de tiempo relativa';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count fotos',
      one: '1 foto',
      zero: 'No hay fotos',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'Ícono';

  @override
  String get notThisPerson => '¿No es esta persona?';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      'Los elementos seleccionados se eliminarán de esta persona, pero no se eliminarán de tu biblioteca.';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat a través de los años';
  }

  @override
  String get thisWeekThroughTheYears => 'Esta semana a través de los años';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Esta semana, hace $count años',
      one: 'Esta semana, hace $count año',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'Tú y $name';
  }

  @override
  String admiringThem({required Object name}) {
    return 'Admirando a $name';
  }

  @override
  String embracingThem({required Object name}) {
    return 'Abrazando a $name';
  }

  @override
  String partyWithThem({required Object name}) {
    return 'Fiesta con $name';
  }

  @override
  String hikingWithThem({required Object name}) {
    return 'Senderismo con $name';
  }

  @override
  String feastingWithThem({required Object name}) {
    return 'Festejando con $name';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return 'Selfies con $name';
  }

  @override
  String posingWithThem({required Object name}) {
    return 'Posando con $name';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return 'Preciosas vistas con $name';
  }

  @override
  String sportsWithThem({required Object name}) {
    return 'Deportes con $name';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return 'Viaje en carretera con $name';
  }

  @override
  String get spotlightOnYourself => 'Enfócate a ti mismo';

  @override
  String spotlightOnThem({required Object name}) {
    return 'Enfocar a $name';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '¡$name tiene $age años!';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name cumpliendo $age pronto';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return 'Última vez con $name';
  }

  @override
  String tripToLocation({required Object location}) {
    return 'Viaje a $location';
  }

  @override
  String tripInYear({required Object year}) {
    return 'Viaje en $year';
  }

  @override
  String get lastYearsTrip => 'Viaje del año pasado';

  @override
  String get sunrise => 'Sobre el horizonte';

  @override
  String get mountains => 'Sobre las colinas';

  @override
  String get greenery => 'La vida verde';

  @override
  String get beach => 'Arena y mar ';

  @override
  String get city => 'En la ciudad';

  @override
  String get moon => 'A la luz de la luna';

  @override
  String get onTheRoad => 'De nuevo en la carretera';

  @override
  String get food => 'Delicia culinaria';

  @override
  String get pets => 'Compañeros peludos';

  @override
  String get curatedMemories => 'Memorias revisadas';

  @override
  String get widgets => 'Widgets';

  @override
  String get memories => 'Recuerdos';

  @override
  String get peopleWidgetDesc =>
      'Selecciona las personas que deseas ver en tu pantalla de inicio.';

  @override
  String get albumsWidgetDesc =>
      'Seleccione los álbumes que desea ver en su pantalla de inicio.';

  @override
  String get memoriesWidgetDesc =>
      'Seleccione el tipo de recuerdos que desea ver en su pantalla de inicio.';

  @override
  String get smartMemories => 'Recuerdos inteligentes';

  @override
  String get pastYearsMemories => 'Recuerdos de los últimos años';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return '¿Quiere borrar también las fotos (y vídeos) presentes en estos $count álbumes de <bold>todos</bold> los otros álbumes de los que forman parte?';
  }

  @override
  String get addParticipants => 'Añadir participantes';

  @override
  String selectedAlbums({required Object count}) {
    return '$count seleccionados';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'Acción no compatible con el álbum de Favoritos';

  @override
  String get onThisDayMemories => 'Recuerdos de un día como hoy';

  @override
  String get onThisDay => 'Un día como hoy';

  @override
  String get lookBackOnYourMemories => 'Revisa tus recuerdos 🌄';

  @override
  String get newPhotosEmoji => ' nuevo 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'Lo sentimos, tuvimos que pausar tus copias de seguridad';

  @override
  String get clickToInstallOurBestVersionYet =>
      'Haz clic para instalar nuestra mejor versión hasta la fecha';

  @override
  String get onThisDayNotificationExplanation =>
      'Recibe recordatorios sobre recuerdos de este día en años anteriores.';

  @override
  String get addMemoriesWidgetPrompt =>
      'Añade un widget de recuerdos a tu pantalla de inicio y vuelve aquí para personalizarlo.';

  @override
  String get addAlbumWidgetPrompt =>
      'Añade un widget de álbum a tu pantalla de inicio y vuelve aquí para personalizarlo.';

  @override
  String get addPeopleWidgetPrompt =>
      'Añade un widget de personas a tu pantalla de inicio y vuelve aquí para personalizarlo.';

  @override
  String get birthdayNotifications => 'Notificaciones de cumpleaños';

  @override
  String get receiveRemindersOnBirthdays =>
      'Recibe recordatorios cuando es el cumpleaños de alguien. Pulsar en la notificación te llevará a las fotos de la persona que cumple años.';

  @override
  String get happyBirthday => '¡Feliz cumpleaños! 🥳';

  @override
  String get birthdays => 'Cumpleaños';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return '¡Desea a $name un cumpleaños feliz! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      '¿Estás seguro de que quieres eliminar esta cara de esta persona?';

  @override
  String get otherDetectedFaces => 'Otras caras detectadas';

  @override
  String get areThey => '¿Son ellos';

  @override
  String get questionmark => '?';

  @override
  String get saveAsAnotherPerson => 'Guardar como otra persona';

  @override
  String get showLessFaces => 'Mostrar menos caras';

  @override
  String get showMoreFaces => 'Mostrar más caras';

  @override
  String get ignore => 'Ignorar';

  @override
  String get merge => 'Combinar';

  @override
  String get reset => 'Restablecer';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      '¿Estás seguro de que quieres ignorar a esta persona?';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      '¿Estás seguro de que quieres ignorar a estas personas?';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'Los grupos de personas ya no se mostrarán en la sección de personas. Las fotos permanecerán intactas.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'La persona ya no se mostrará en la sección de personas. Las fotos permanecerán intactas.';

  @override
  String get areYouSureYouWantToMergeThem =>
      '¿Estás seguro de que quieres combinarlas?';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'Todos los grupos sin nombre se combinarán en la persona seleccionada. Esto puede deshacerse desde el historial de sugerencias de la persona.';

  @override
  String get yesIgnore => 'Sí, ignorar';

  @override
  String get same => 'Igual';

  @override
  String get different => 'Diferente';

  @override
  String get sameperson => 'la misma persona?';

  @override
  String get indexingPausedStatusDescription =>
      'La indexación está pausada. Se reanudará automáticamente cuando el dispositivo esté listo. El dispositivo se considera listo cuando su nivel de batería, la salud de la batería y temperatura están en un rango saludable.';

  @override
  String get thisWeek => 'Esta semana';

  @override
  String get lastWeek => 'Semana pasada';

  @override
  String get thisMonth => 'Este mes';

  @override
  String get thisYear => 'Este año';

  @override
  String get groupBy => 'Agrupar por';

  @override
  String get faceThumbnailGenerationFailed =>
      'No se pueden generar las miniaturas de cara';

  @override
  String get fileAnalysisFailed => 'No se puede analizar el archivo';

  @override
  String get editAutoAddPeople => 'Editar agregar personas automáticamente';

  @override
  String get autoAddPeople => 'Agregar personas automáticamente';

  @override
  String get autoAddToAlbum => 'Añadir al álbum automáticamente';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      '¿Deben eliminarse los archivos relacionados con la persona previamente seleccionada en los álbumes inteligentes?';

  @override
  String get addingPhotos => 'Añadiendo fotos';

  @override
  String get gettingReady => 'Preparándose';

  @override
  String get addSomePhotosDesc1 => 'Añadir algunas fotos o elegir ';

  @override
  String get addSomePhotosDesc2 => 'caras familiares';

  @override
  String get addSomePhotosDesc3 => '\npara comenzar con';

  @override
  String get ignorePerson => 'Ignorar persona';

  @override
  String get mixedGrouping => '¿Grupo mixto?';

  @override
  String get analysis => 'Análisis';

  @override
  String get doesGroupContainMultiplePeople =>
      '¿Esta agrupación contiene varias personas?';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'Analizaremos automáticamente la agrupación para determinar si hay varias personas presentes, y separarlas de nuevo. Esto puede tardar unos segundos.';

  @override
  String get layout => 'Disposición';

  @override
  String get day => 'Día';

  @override
  String get undo => 'Deshacer';

  @override
  String get redo => 'Rehacer';

  @override
  String get filter => 'Filtro';

  @override
  String get adjust => 'Ajustar';

  @override
  String get draw => 'Dibujar';

  @override
  String get sticker => 'Pegatina';

  @override
  String get brushColor => 'Color del pincel';

  @override
  String get font => 'Fuente';

  @override
  String get background => 'Fondo';

  @override
  String get align => 'Alinear';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Añadido con éxito a $count álbumes',
      one: 'Añadido con éxito a 1 álbum',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => 'Vídeos procesados';

  @override
  String get totalVideos => 'Vídeos totales';

  @override
  String get skippedVideos => 'Vídeos omitidos';

  @override
  String get videoStreamingDescriptionLine1 =>
      'Reproduce vídeos al instante en cualquier dispositivo.';

  @override
  String get videoStreamingDescriptionLine2 =>
      'Habilitar para procesar transmisiones de vídeo en este dispositivo.';

  @override
  String get videoStreamingNote =>
      'Solo los vídeos de los últimos 60 días y menos de 1 minuto se procesan en este dispositivo. Para vídeos más viejos/más largos, habilita la transmisión en la aplicación de escritorio.';

  @override
  String get createStream => 'Crear transmisión';

  @override
  String get recreateStream => 'Recrear transmisión';

  @override
  String get addedToStreamCreationQueue =>
      'Añadido a la cola de creación de transmisiones';

  @override
  String get addedToStreamRecreationQueue =>
      'Añadido a la cola de grabación de transmisiones';

  @override
  String get videoPreviewAlreadyExists => 'La vista previa de vídeo ya existe';

  @override
  String get videoAlreadyInQueue => 'El archivo de vídeo ya está en la cola';

  @override
  String get videoExportFailed =>
      'Falló la creación de vídeo. Por favor, inténtalo de nuevo.';

  @override
  String videoExportSuccess({required String path}) {
    return 'Vídeo creado con éxito en $path';
  }

  @override
  String get addedToQueue => 'Añadido a la cola';

  @override
  String get creatingStream => 'Creando transmisión';

  @override
  String get similarImages => 'Imágenes similares';

  @override
  String get findSimilarImages => 'Buscar imágenes similares';

  @override
  String get noSimilarImagesFound => 'No se encontraron imágenes similares';

  @override
  String get yourPhotosLookUnique => 'Tus fotos se ven únicas';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count grupos encontrados',
      one: '$count grupo encontrado',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages =>
      'Revisar y eliminar imágenes similares';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return 'Eliminar $count fotos ($size)';
  }

  @override
  String get selectionOptions => 'Opciones de selección';

  @override
  String selectExactWithCount({required int count}) {
    return 'Exactamente similar ($count)';
  }

  @override
  String get selectExact => 'Seleccionar exactos';

  @override
  String selectSimilarWithCount({required int count}) {
    return 'Mayormente, similar ($count)';
  }

  @override
  String get selectSimilar => 'Seleccionar similares';

  @override
  String selectAllWithCount({required int count}) {
    return 'Todas las similitudes ($count)';
  }

  @override
  String get selectSimilarImagesTitle => 'Seleccionar imágenes similares';

  @override
  String get chooseSimilarImagesToSelect =>
      'Seleccionar imágenes basándose en su similitud visual';

  @override
  String get clearSelection => 'Borrar selección';

  @override
  String similarImagesCount({required int count}) {
    return '$count imágenes similares';
  }

  @override
  String deleteWithCount({required int count}) {
    return 'Eliminar ($count)';
  }

  @override
  String get deleteFiles => 'Eliminar archivos';

  @override
  String get areYouSureDeleteFiles =>
      '¿Estás seguro que quieres eliminar estos archivos?';

  @override
  String get greatJob => '¡Bien hecho!';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return 'Has liberado $size de espacio';
  }

  @override
  String get size => 'Tamaño';

  @override
  String get similarity => 'Similitud';

  @override
  String get analyzingPhotosLocally => 'Analizando tus fotos localmente...';

  @override
  String get lookingForVisualSimilarities => 'Buscando similitudes visuales...';

  @override
  String get comparingImageDetails => 'Comparando detalles de imágenes...';

  @override
  String get findingSimilarImages => 'Buscando imágenes similares...';

  @override
  String get almostDone => 'Ya casi terminamos...';

  @override
  String get processingLocally => 'Procesando localmente';

  @override
  String get useMLToFindSimilarImages =>
      'Revisar y eliminar imágenes que se parecen entre sí.';

  @override
  String get all => 'Todas';

  @override
  String get similar => 'Similares';

  @override
  String get identical => 'Idénticas';

  @override
  String get nothingHereTryAnotherFilter =>
      'Nada aquí, ¡prueba con otro filtro! 👀';

  @override
  String get related => 'Relacionado';

  @override
  String get hoorayyyy => '¡Hurraaaa!';

  @override
  String get nothingToTidyUpHere => 'Nada que limpiar aquí';

  @override
  String get deletingDash => 'Eliminando - ';

  @override
  String get cLTitle1 => 'Presentamos Rituales';

  @override
  String get cLDesc1 =>
      '¿Planeas propósitos para 2026? Con Rituales, puedes configurar un recordatorio en Ente Photos y seguir tu progreso tomando fotos. Úsalo para entrenamientos, hábitos alimenticios, momentos diarios con tus seres queridos, cualquier cosa que quieras convertir en hábito.';

  @override
  String get cLTitle2 => 'Enlaces públicos, ahora para todos';

  @override
  String get cLDesc2 =>
      'Todos los usuarios de Ente en el plan gratuito ahora pueden crear y compartir enlaces públicos a fotos y álbumes. Para prevenir abusos, los enlaces tendrán límites en cuántas personas pueden verlos.';

  @override
  String get cLTitle3 => 'Etiquetar personas manualmente';

  @override
  String get cLDesc3 =>
      'Ahora puedes etiquetar personas incluso cuando nuestra IA en el dispositivo no detecta un rostro. Útil para mascotas, rostros parcialmente visibles, o momentos donde alguien no está realmente en la foto pero debería ser incluido.';

  @override
  String get cLTitle4 => 'Y más';

  @override
  String get cLDesc4 =>
      'Ahora puedes fijar álbumes compartidos. Los enlaces de álbumes son visibles para colaboradores y espectadores para facilitar aún más el compartir. Hemos corregido algunos errores de deslizamiento en iOS y actualizado la vista de fotos, incluyendo un nuevo ícono de favoritos (preparando espacio para próximas funciones).';

  @override
  String get closeBy => 'Cerrar';

  @override
  String get peopleAutoAddDesc =>
      'Añadir automáticamente fotos de las personas seleccionadas a este álbum';

  @override
  String get festivities => 'Hurra festivo';

  @override
  String get snowAdventures => 'Aventuras invernales';

  @override
  String get waterfalls => 'Cazando cascadas';

  @override
  String get wildlife => 'En la naturaleza';

  @override
  String get flowers => 'Bellezas florecientes';

  @override
  String get nightLights => 'Noches de neón';

  @override
  String get architecture => 'Iconos de diseño';

  @override
  String get autumnColors => 'Esplendor otoñal';

  @override
  String get desertDreams => 'Sueños desérticos';

  @override
  String get stargazing => 'Bajo las estrellas';

  @override
  String get lakeside => 'Calma lacustre';

  @override
  String get rainyDays => 'Sentimiento de día lluvioso';

  @override
  String get sportsAction => 'Empieza el juego';

  @override
  String get streetArt => 'Historias de arte callejero';

  @override
  String get familyMoments => 'Tiempo en familia';

  @override
  String get fireworks => 'Final con fuegos artificiales';

  @override
  String get historicSites => 'Ecos históricos';

  @override
  String get tropicalParadise => 'Escapadas tropicales';

  @override
  String get forestTrails => 'Paseos por el bosque';

  @override
  String get citySunsets => 'Resplandor de atardecer citadino';

  @override
  String get colorfulMarkets => 'Mercados vivos';

  @override
  String get cozyCafes => 'Cantones cálidos de cafetería';

  @override
  String get vintageVibes => 'Vibras retro';

  @override
  String get aerialViews => 'Perspectivas aéreas';

  @override
  String get artisticPortraits => 'Retratos artísticos';

  @override
  String get streetFood => 'Antojos callejeros';

  @override
  String get riverCruises => 'Vistas de crusero fluvial';

  @override
  String get facesTimelineBannerTitle => 'Jardín de recuerdos';

  @override
  String facesTimelineBannerSubtitle({required String name}) {
    return 'Ver fotos de $name a lo largo de los años';
  }

  @override
  String get facesTimelineAppBarTitle => 'Jardín de recuerdos';

  @override
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count años de edad',
      one: '$count año de edad',
    );
    return '$name tenía $_temp0';
  }

  @override
  String facesTimelineCaptionYearsAgo({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Hace # años',
      one: 'Hace # año',
    );
    return '$_temp0';
  }

  @override
  String get facesTimelineShareComingSoon => 'Compartir vídeos próximamente';

  @override
  String get facesTimelinePlaybackPrevious => 'Anterior';

  @override
  String get facesTimelinePlaybackNext => 'Siguiente';

  @override
  String get facesTimelinePlaybackPlay => 'Reproducir';

  @override
  String get facesTimelinePlaybackPause => 'Pausar';

  @override
  String get facesTimelineUnavailable =>
      'Se está preparando la línea de tiempo de caras...';

  @override
  String get playfulKids => 'Niños jugando';

  @override
  String get coastalCliffs => 'Acantilados marinos';

  @override
  String get ritualsTitle => 'Rituales';

  @override
  String get ritualAddTooltip => 'Añadir ritual';

  @override
  String get ritualActivityHeading => 'Actividad';

  @override
  String get ritualDefaultHeatmapTitle => 'Toma una foto cada día';

  @override
  String get ritualUntitled => 'Untitled ritual';

  @override
  String get ritualShareUnavailable =>
      'No se puede compartir ahora. Por favor, inténtalo de nuevo.';

  @override
  String get ritualNotificationMessage => 'Tomar una foto ahora';

  @override
  String get ritualCameraNotFound =>
      'No se ha encontrado ninguna cámara en este dispositivo.';

  @override
  String get ritualCameraStartError =>
      'No se puede iniciar la cámara. Por favor, comprueba los permisos.';

  @override
  String get ritualCaptureError =>
      'No se puede capturar la foto. Por favor, inténtalo de nuevo.';

  @override
  String ritualPhotoLimit({required int maxPhotos}) {
    String _temp0 = intl.Intl.pluralLogic(
      maxPhotos,
      locale: localeName,
      other: '# photos.',
      one: '# photo.',
    );
    return 'You can add up to $_temp0';
  }

  @override
  String get ritualCaptureAtLeastOne => 'Captura al menos una foto primero.';

  @override
  String get ritualAlbumMissing =>
      'Ritual album missing. Edit the ritual to set an album.';

  @override
  String get ritualAddedToAlbum => 'Added to album';

  @override
  String ritualAddedToAlbumWithName({required String albumName}) {
    return 'Added to $albumName';
  }

  @override
  String ritualAddToAlbumFailure({required String error}) {
    return 'Couldn\'t add photos to the album: $error';
  }

  @override
  String get ritualBackToList => 'Back to rituals';

  @override
  String get ritualNoPhotosYet => 'No photos yet';

  @override
  String get ritualSetAlbumToLaunchCamera =>
      'Set an album for this ritual to launch the camera.';

  @override
  String get ritualDefaultCameraTitle => 'Tomar una foto';

  @override
  String get ritualBadgeMessage7 =>
      '7 days down! Consistency looks good on you. Keep going!';

  @override
  String get ritualBadgeMessage14 =>
      '14 days in! Your ritual is becoming a habit. Incredible!';

  @override
  String get ritualBadgeMessage30 =>
      '30 days in a row! Legendary consistency. Take a bow!';

  @override
  String get ritualBadgeMessageDefault => '¡Estás en buena racha!';

  @override
  String get ritualBadgeNewTitle => 'Nuevo logro';

  @override
  String get ritualBadgePreparing => 'Preparando...';

  @override
  String get ritualStreaksLabel => 'Rachas';

  @override
  String get ritualCreateYourOwn => 'Create your own ritual';

  @override
  String get ritualGetDailyReminders => 'Obtener recordatorios diarios';

  @override
  String get ritualAlbumNotSet => 'Álbum no establecido';

  @override
  String get ritualOpenCameraTooltip => 'Open ritual camera';

  @override
  String get ritualEditorLabel => 'Ritual editor';

  @override
  String get ritualNew => 'Create new ritual';

  @override
  String get ritualCreateNewTitle => 'Create new ritual';

  @override
  String get ritualEdit => 'Edit ritual';

  @override
  String get ritualEnterPrompt => 'Enter your ritual';

  @override
  String get ritualEnterDescription => 'Por favor, ingresa una descripción';

  @override
  String get ritualChooseDaysLabel => 'Choose days for ritual';

  @override
  String get ritualDayLabel => 'Día';

  @override
  String get ritualNotificationsOffHint =>
      'Las notificaciones están apagadas. Toca en un día para activarlas.';

  @override
  String get ritualTimeLabel => 'Time';

  @override
  String get ritualAlbumLabel => 'Álbum';

  @override
  String get ritualSave => 'Guardar ritual';

  @override
  String get ritualCreateAction => 'Create ritual';

  @override
  String get ritualUpdate => 'Actualizar ritual';

  @override
  String get ritualSelectAlbumTitle => 'Seleccionar álbum';

  @override
  String get ritualChooseAlbumLabel => 'Choose an album';

  @override
  String get ritualSendReminderLabel => 'Send reminder';

  @override
  String get ritualSearchOrCreate => 'Buscar o crear nuevo';

  @override
  String get ritualNoAlbumsYet => 'No albums yet';

  @override
  String get ritualNoMatchingAlbums => 'Sin álbumes que coincidan';

  @override
  String ritualCreateAlbumWithName({required String albumName}) {
    return 'Crear \"$albumName\"';
  }

  @override
  String get ritualCreateNew => 'Crear nuevo';

  @override
  String get ritualAlbumSelectionPlaceholder => 'Seleccionar álbum';

  @override
  String get ritualPickEmojiTitle => 'Elegir un emoji';

  @override
  String get ritualCustomKeyboardLabel => 'Personalizado (teclado)';

  @override
  String get ritualEmojiKeyboardHint =>
      'Presiona para abrir el teclado de emojis';

  @override
  String get ritualEmojiUseAction => 'Use';

  @override
  String get ritualSearchEmpty =>
      'Construye un ritual para mantener tu hábito fotográfico.';
}
