// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Modern Greek (`el`).
class AppLocalizationsEl extends AppLocalizations {
  AppLocalizationsEl([String locale = 'el']) : super(locale);

  @override
  String get enterYourEmailAddress =>
      'Εισάγετε την διεύθυνση ηλ. ταχυδρομείου σας';

  @override
  String get enterYourNewEmailAddress =>
      'Εισάγετε την διεύθυνση ηλ. ταχυδρομείου σας';

  @override
  String get accountWelcomeBack => 'Καλωσορίσατε και πάλι!';

  @override
  String get emailAlreadyRegistered =>
      'Υπάρχει ήδη λογαριασμός με αυτή τη διεύθυνση ηλ. ταχυδρομείου.';

  @override
  String get emailNotRegistered =>
      'Δεν υπάρχει λογαριασμός με αυτή τη διεύθυνση ηλ. ταχυδρομείου.';

  @override
  String get email => 'Email';

  @override
  String get cancel => 'Ακύρωση';

  @override
  String get verify => 'Επαλήθευση';

  @override
  String get invalidEmailAddress => 'Μη έγκυρη διεύθυνση email';

  @override
  String get enterValidEmail =>
      'Παρακαλώ εισάγετε μια έγκυρη διεύθυνση ηλεκτρονικού ταχυδρομείου.';

  @override
  String get deleteAccount => 'Διαγραφή λογαριασμού';

  @override
  String get deleteAccountWarning =>
      'Αυτό θα διαγράψει τους λογαριασμούς σας σε Ente Auth, Ente Photos και Ente Locker.';

  @override
  String get askDeleteReason =>
      'Ποιος είναι ο κύριος λόγος που διαγράφετε το λογαριασμό σας;';

  @override
  String get deleteAccountFeedbackPrompt =>
      'Λυπούμαστε που σας βλέπουμε να φεύγετε. Παρακαλούμε μοιραστείτε τα σχόλιά σας για να μας βοηθήσετε να βελτιωθούμε.';

  @override
  String get feedback => 'Σχόλια';

  @override
  String get kindlyHelpUsWithThisInformation =>
      'Παρακαλούμε βοηθήστε μας δίνοντας αυτές τις πληροφορίες';

  @override
  String get confirmDeletePrompt =>
      'Ναι, θέλω να διαγράψω μόνιμα αυτό το λογαριασμό και όλα τα δεδομένα του σε όλες τις εφαρμογές.';

  @override
  String get confirmAccountDeletion => 'Επιβεβαίωση Διαγραφής Λογαριασμού';

  @override
  String get deleteAccountPermanentlyButton => 'Οριστική Διαγραφή Λογαριασμού';

  @override
  String get yourAccountHasBeenDeleted => 'Ο λογαριασμός σας έχει διαγραφεί';

  @override
  String get selectReason => 'Επιλέξτε αιτία';

  @override
  String get deleteReason1 => 'Λείπει μία βασική λειτουργία που χρειάζομαι';

  @override
  String get deleteReason2 =>
      'Η εφαρμογή ή μια συγκεκριμένη λειτουργία δεν συμπεριφέρεται όπως νομίζω ότι θα έπρεπε';

  @override
  String get deleteReason3 =>
      'Βρήκα μια άλλη υπηρεσία που μου αρέσει περισσότερο';

  @override
  String get deleteReason4 => 'Ο λόγος δεν συμπεριλαμβάνεται στη λίστα';

  @override
  String get sendEmail => 'Αποστολή email';

  @override
  String get deleteRequestSLAText =>
      'Το αίτημά σας θα εξεταστεί εντός 72 ωρών.';

  @override
  String get deleteEmailRequest =>
      'Παρακαλούμε στείλτε ένα μήνυμα ηλ. ταχυδρομείου στο <warning>account-deletion@ente.io</warning> από την καταχωρημένη διεύθυνσή σας.';

  @override
  String get entePhotosPerm =>
      'Το Ente <i>χρειάζεται άδεια</i> για να διατηρεί τις φωτογραφίες σας';

  @override
  String get ok => 'OK';

  @override
  String get createAccount => 'Δημιουργία λογαριασμού';

  @override
  String get createNewAccount => 'Δημιουργία νέου λογαριασμού';

  @override
  String get password => 'Κωδικός πρόσβασης';

  @override
  String get confirmPassword => 'Επιβεβαίωση κωδικού πρόσβασης';

  @override
  String get activeSessions => 'Ενεργές συνεδρίες';

  @override
  String get ocrProcessingOverlayMessage => 'Ανίχνευση κειμένου...';

  @override
  String get ocrLoadingIndicatorLabel => 'Ανίχνευση Κειμένου';

  @override
  String get ocrSelectionHint =>
      'Σύρετε ή πατήστε δύο φορές για να επιλέξετε ακριβώς αυτό που χρειάζεστε';

  @override
  String get ocrNoTextDetected => 'Δεν ανιχνεύθηκε κείμενο';

  @override
  String get ocrRetryButtonLabel => 'Προσπάθησε ξανά';

  @override
  String get ocrModelsNetworkRequiredError =>
      'Απαιτείται σύνδεση δικτύου για λήψη μοντέλων OCR κατά την πρώτη χρήση';

  @override
  String get ocrModelsPrepareFailed =>
      'Δεν ήταν δυνατή η προετοιμασία μοντέλων OCR';

  @override
  String get ocrImageNotFoundError => 'Δεν βρέθηκε αρχείο εικόνας';

  @override
  String get ocrImageDecodeFailedError =>
      'Δεν ήταν δυνατή η ανάγνωση αρχείου εικόνας';

  @override
  String get ocrGenericDetectError => 'Δεν εντοπίστηκε κειμένο στην εικόνα';

  @override
  String get oops => 'Ουπς';

  @override
  String get somethingWentWrongPleaseTryAgain =>
      'Κάτι πήγε στραβά, παρακαλώ προσπαθήστε ξανά';

  @override
  String get thisWillLogYouOutOfThisDevice =>
      'Αυτό θα σας αποσυνδέσει από αυτή τη συσκευή!';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice =>
      'Αυτό θα σας αποσυνδέσει από την ακόλουθη συσκευή:';

  @override
  String get terminateSession => 'Τερματισμός συνεδρίας;';

  @override
  String get terminate => 'Τερματισμός';

  @override
  String get thisDevice => 'Αυτή η συσκευή';

  @override
  String get recoverButton => 'Ανάκτηση';

  @override
  String get recoverySuccessful => 'Η ανάκτηση ήταν επιτυχής!';

  @override
  String get decrypting => 'Αποκρυπτογράφηση...';

  @override
  String get incorrectRecoveryKeyTitle => 'Εσφαλμένο κλειδί ανάκτησης';

  @override
  String get incorrectRecoveryKeyBody =>
      'Το κλειδί ανάκτησης που εισάγατε είναι εσφαλμένο';

  @override
  String get forgotPassword => 'Ξέχασα τον κωδικό πρόσβασης';

  @override
  String get enterYourRecoveryKey => 'Εισάγετε το κλειδί ανάκτησής σας';

  @override
  String get noRecoveryKey => 'Δεν έχετε το κλειδί ανάκτησης;';

  @override
  String get sorry => 'Συγνώμη';

  @override
  String get noRecoveryKeyNoDecryption =>
      'Λόγω της φύσης του πρωτοκόλλου κρυπτογράφησης από άκρο σε άκρο, τα δεδομένα σας δεν μπορούν να αποκρυπτογραφηθούν χωρίς τον κωδικό πρόσβασης ή το κλειδί ανάκτησης';

  @override
  String get verifyEmail => 'Επαλήθευση email';

  @override
  String get toResetVerifyEmail =>
      'Για να επαναφέρετε τον κωδικό πρόσβασής σας, επαληθεύστε πρώτα το email σας.';

  @override
  String get checkInboxAndSpamFolder =>
      'Παρακαλούμε ελέγξτε τα εισερχόμενά σας (και τα ανεπιθύμητα) για να ολοκληρώσετε την επαλήθευση';

  @override
  String get tapToEnterCode => 'Πατήστε για να εισάγετε τον κωδικό';

  @override
  String get resendEmail => 'Επανάληψη αποστολής email';

  @override
  String weHaveSendEmailTo({required String email}) {
    return 'Έχουμε στείλει ένα μήνυμα στο <green>$email</green>';
  }

  @override
  String get setPasswordTitle => 'Ορισμός κωδικού πρόσβασης';

  @override
  String get changePasswordTitle => 'Αλλαγή κωδικού πρόσβασής';

  @override
  String get resetPasswordTitle => 'Επαναφορά κωδικού πρόσβασης';

  @override
  String get encryptionKeys => 'Κλειδιά κρυπτογράφησης';

  @override
  String get passwordWarning =>
      'Δεν αποθηκεύουμε αυτόν τον κωδικό πρόσβασης, οπότε αν τον ξεχάσετε <underline>δεν μπορούμε να αποκρυπτογραφήσουμε τα δεδομένα σας</underline>';

  @override
  String get enterPasswordToEncrypt =>
      'Εισάγετε έναν κωδικό πρόσβασης που μπορούμε να χρησιμοποιήσουμε για την κρυπτογράφηση των δεδομένων σας';

  @override
  String get enterNewPasswordToEncrypt =>
      'Εισάγετε ένα νέο κωδικό πρόσβασης που μπορούμε να χρησιμοποιήσουμε για να κρυπτογραφήσουμε τα δεδομένα σας';

  @override
  String get weakStrength => 'Αδύναμος';

  @override
  String get strongStrength => 'Δυνατός';

  @override
  String get moderateStrength => 'Μέτριος';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'Ισχύς κωδικού πρόσβασης: $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully =>
      'Ο κωδικός πρόσβασης άλλαξε επιτυχώς';

  @override
  String get generatingEncryptionKeys =>
      'Δημιουργία κλειδιών κρυπτογράφησης...';

  @override
  String get pleaseWait => 'Παρακαλώ περιμένετε...';

  @override
  String get continueLabel => 'Συνέχεια';

  @override
  String get insecureDevice => 'Μη ασφαλής συσκευή';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'Συγγνώμη, δεν μπορέσαμε να δημιουργήσουμε ασφαλή κλειδιά σε αυτήν τη συσκευή.\n\nΠαρακαλούμε εγγραφείτε από μια διαφορετική συσκευή.';

  @override
  String get howItWorks => 'Πώς λειτουργεί';

  @override
  String get encryption => 'Kρυπτογράφηση';

  @override
  String get ackPasswordLostWarning =>
      'Καταλαβαίνω ότι αν χάσω τον κωδικό μου μπορεί να χάσω τα δεδομένα μου αφού τα δεδομένα μου είναι <underline>κρυπτογραφημένα από άκρο-σε-άκρο</underline>.';

  @override
  String get privacyPolicyTitle => 'Πολιτική Απορρήτου';

  @override
  String get termsOfServicesTitle => 'Όροι';

  @override
  String get signUpTerms =>
      'Συμφωνώ με τους <u-terms>όρους χρήσης</u-terms> και την <u-policy>πολιτική απορρήτου</u-policy>';

  @override
  String get logInLabel => 'Σύνδεση';

  @override
  String get loginTerms =>
      'Κάνοντας κλικ στη σύνδεση, συμφωνώ με τους <u-terms>όρους χρήσης</u-terms> και την <u-policy>πολιτική απορρήτου</u-policy>';

  @override
  String get changeEmail => 'Αλλαγή διεύθυνσης ηλ. ταχυδρομείου';

  @override
  String get enterYourPassword => 'Εισάγετε τον κωδικό πρόσβασής σας';

  @override
  String get welcomeBack => 'Καλωσορίσατε και πάλι!';

  @override
  String get contactSupport => 'Επικοινωνήστε με την υποστήριξη';

  @override
  String get locationPickerTip =>
      'Μπορείτε επίσης να προσθέσετε μια τοποθεσία στο κέντρο μιας φωτογραφίας από την οθόνη πληροφοριών της φωτογραφίας';

  @override
  String get incorrectPasswordTitle => 'Λάθος κωδικός πρόσβασης';

  @override
  String get pleaseTryAgain => 'Παρακαλούμε δοκιμάστε ξανά';

  @override
  String get recreatePasswordTitle => 'Επαναδημιουργία κωδικού πρόσβασης';

  @override
  String get useRecoveryKey => 'Χρήση κλειδιού ανάκτησης';

  @override
  String get recreatePasswordBody =>
      'Η τρέχουσα συσκευή δεν είναι αρκετά ισχυρή για να επαληθεύσει τον κωδικό πρόσβασής σας, αλλά μπορούμε να τον αναδημιουργήσουμε με έναν τρόπο που λειτουργεί με όλες τις συσκευές.\n\nΠαρακαλούμε συνδεθείτε χρησιμοποιώντας το κλειδί ανάκτησης και αναδημιουργήστε τον κωδικό πρόσβασής σας (μπορείτε να χρησιμοποιήσετε ξανά τον ίδιο αν το επιθυμείτε).';

  @override
  String get verifyPassword => 'Επαλήθευση κωδικού πρόσβασης';

  @override
  String get recoveryKey => 'Κλειδί ανάκτησης';

  @override
  String get recoveryKeyOnForgotPassword =>
      'Εάν ξεχάσετε τον κωδικό πρόσβασής σας, ο μόνος τρόπος για να ανακτήσετε τα δεδομένα σας είναι με αυτό το κλειδί.';

  @override
  String get recoveryKeySaveDescription =>
      'Δεν αποθηκεύουμε αυτό το κλειδί, παρακαλώ αποθηκεύστε αυτό το κλειδί 24 λέξεων σε μια ασφαλή τοποθεσία.';

  @override
  String get doThisLater => 'Θα το κάνω αργότερα';

  @override
  String get saveKey => 'Αποθήκευση κλειδιού';

  @override
  String get recoveryKeyCopiedToClipboard =>
      'Το κλειδί ανάκτησης αντιγράφηκε στο πρόχειρο';

  @override
  String get recoverAccount => 'Ανάκτηση λογαριασμού';

  @override
  String get recover => 'Ανάκτηση';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'Παρακαλώ αφήστε ένα μήνυμα ηλ. ταχυδρομείου στο $supportEmail από την καταχωρημένη διεύθυνσή σας';
  }

  @override
  String get twofactorSetup => 'Ρύθμιση δύο παραγόντων';

  @override
  String get enterCode => 'Εισαγωγή κωδικού';

  @override
  String get scanCode => 'Σάρωση κωδικού';

  @override
  String get codeCopiedToClipboard => 'Ο κωδικός αντιγράφηκε στο πρόχειρο';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      'Αντιγράψτε αυτόν τον κωδικό \nστην εφαρμογή αυθεντικοποίησης';

  @override
  String get tapToCopy => 'πατήστε για αντιγραφή';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      'Σαρώστε αυτό το barcode\nμε την εφαρμογή αυθεντικοποίησης';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      'Εισάγετε τον 6ψήφιο κωδικό από \nτην εφαρμογή αυθεντικοποίησης';

  @override
  String get confirm => 'Επιβεβαίωση';

  @override
  String get setupComplete => 'Η εγκατάσταση ολοκληρώθηκε';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready =>
      'Αποθηκεύστε το κλειδί ανάκτησης αν δεν το έχετε ήδη κάνει';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      'Αυτό μπορεί να χρησιμοποιηθεί για να ανακτήσετε το λογαριασμό σας αν χάσετε τον δεύτερο σας παράγοντα';

  @override
  String get twofactorAuthenticationPageTitle =>
      'Αυθεντικοποίηση δύο παραγόντων';

  @override
  String get lostDevice => 'Χαμένη συσκευή;';

  @override
  String get verifyingRecoveryKey => 'Επαλήθευση κλειδιού ανάκτησης...';

  @override
  String get recoveryKeyVerified => 'Το κλειδί ανάκτησης επαληθεύτηκε';

  @override
  String get recoveryKeySuccessBody =>
      'Τέλεια! Το κλειδί ανάκτησης σας είναι έγκυρο. Σας ευχαριστούμε για την επαλήθευση.\n\nΠαρακαλούμε θυμηθείτε να κρατήσετε το κλειδί ανάκτησης σας και σε αντίγραφο ασφαλείας.';

  @override
  String get invalidRecoveryKey =>
      'Το κλειδί ανάκτησης που εισάγατε δεν είναι έγκυρο. Παρακαλούμε βεβαιωθείτε ότι περιέχει 24 λέξεις και ελέγξτε την ορθογραφία της κάθε μίας.\n\nΑν εισαγάγατε έναν παλαιότερο κωδικό ανάκτησης, βεβαιωθείτε ότι έχει μήκος 64 χαρακτήρες, και ελέγξτε κάθε έναν από αυτούς.';

  @override
  String get invalidKey => 'Μη έγκυρο κλειδί';

  @override
  String get tryAgain => 'Προσπαθήστε ξανά';

  @override
  String get viewRecoveryKey => 'Προβολή κλειδιού ανάκτησης';

  @override
  String get confirmRecoveryKey => 'Επιβεβαίωση κλειδιού ανάκτησης';

  @override
  String get recoveryKeyVerifyReason =>
      'Το κλειδί ανάκτησης σας είναι ο μόνος τρόπος για να ανακτήσετε τις φωτογραφίες σας εάν ξεχάσετε τον κωδικό πρόσβασής σας. Μπορείτε να βρείτε το κλειδί ανάκτησης σας στις Ρυθμίσεις > Λογαριασμός.\n\nΠαρακαλούμε εισάγετε το κλειδί ανάκτησης σας εδώ για να βεβαιωθείτε ότι το έχετε αποθηκεύσει σωστά.';

  @override
  String get confirmYourRecoveryKey => 'Επιβεβαίωση κλειδιού ανάκτησης';

  @override
  String get addViewer => 'Προσθήκη θεατή';

  @override
  String get addCollaborator => 'Προσθήκη συνεργάτη';

  @override
  String get admin => 'Admin';

  @override
  String get admins => 'Admins';

  @override
  String get addAdmin => 'Add admin';

  @override
  String get addMoreAdmins => 'Add more admins';

  @override
  String get adminsAndCollaboratorsCanAddPhotosDescription =>
      'Admins and collaborators can add photos. Admins can also manage photos & participants.';

  @override
  String get addANewEmail => 'Προσθήκη νέας διεύθυνσης ηλ. ταχυδρομείου';

  @override
  String get orPickAnExistingOne => 'Ή επιλέξτε από υπάρχοντες';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'Οι συνεργάτες μπορούν να προσθέτουν φωτογραφίες και βίντεο στο κοινόχρηστο άλμπουμ.';

  @override
  String get enterEmail => 'Εισάγετε ηλεκτρονική διεύθυνση';

  @override
  String get albumOwner => 'Κάτοχος';

  @override
  String get you => 'Εσείς';

  @override
  String get collaborator => 'Συνεργάτης';

  @override
  String get addMore => 'Προσθήκη περισσότερων';

  @override
  String get viewer => 'Θεατής';

  @override
  String get remove => 'Αφαίρεση';

  @override
  String get removeParticipant => 'Αφαίρεση συμμετέχοντα';

  @override
  String get manage => 'Διαχείριση';

  @override
  String get addedAs => 'Added as';

  @override
  String get changePermissions => 'Change permissions?';

  @override
  String get yesConvertToViewer => 'Yes, convert to viewer';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return '$user will not be able to add more photos to this album\n\nThey will still be able to remove existing photos added by them';
  }

  @override
  String get allowAddingPhotos => 'Allow adding photos';

  @override
  String get allowJoiningAlbum => 'Allow joining album';

  @override
  String get allowAddPhotosDescription =>
      'Allow people with the link to also add photos to the shared album.';

  @override
  String get passwordLock => 'Password lock';

  @override
  String get canNotOpenTitle => 'Cannot open this album';

  @override
  String get canNotOpenBody => 'Sorry, this album cannot be opened in the app.';

  @override
  String get disableDownloadWarningTitle => 'Please note';

  @override
  String get disableDownloadWarningBody =>
      'Viewers can still take screenshots or save a copy of your photos using external tools';

  @override
  String get allowDownloads => 'Allow downloads';

  @override
  String get linkDeviceLimit => 'Device limit';

  @override
  String get noDeviceLimit => 'None';

  @override
  String get albumLayout => 'Album layout';

  @override
  String get layoutGrouped => 'Grouped';

  @override
  String get layoutContinuous => 'Continuous';

  @override
  String get layoutTrip => 'Trip';

  @override
  String get preview => 'Preview';

  @override
  String get linkExpiry => 'Link expiry';

  @override
  String get linkExpired => 'Expired';

  @override
  String get linkEnabled => 'Enabled';

  @override
  String get linkNeverExpires => 'Never';

  @override
  String get expiredLinkInfo =>
      'This link has expired. Please select a new expiry time or disable link expiry.';

  @override
  String get setAPassword => 'Set a password';

  @override
  String get lockButtonLabel => 'Lock';

  @override
  String get enterPassword => 'Enter password';

  @override
  String get removeLink => 'Remove link';

  @override
  String get manageLink => 'Manage link';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'Link will expire on $expiryTime';
  }

  @override
  String get albumUpdated => 'Album updated';

  @override
  String get never => 'Never';

  @override
  String get custom => 'Custom';

  @override
  String get after1Hour => 'After 1 hour';

  @override
  String get after1Day => 'After 1 day';

  @override
  String get after1Week => 'After 1 week';

  @override
  String get after1Month => 'After 1 month';

  @override
  String get after1Year => 'After 1 year';

  @override
  String get manageParticipants => 'Manage';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Participants',
      one: '1 Participant',
      zero: 'No Participants',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'Create a link to allow people to add and view photos in your shared album without needing an Ente app or account. Great for collecting event photos.';

  @override
  String get collectPhotos => 'Collect photos';

  @override
  String get collaborativeLink => 'Collaborative link';

  @override
  String get shareWithNonenteUsers => 'Share with non-Ente users';

  @override
  String get createPublicLink => 'Create public link';

  @override
  String get sendLink => 'Send link';

  @override
  String get qrCode => 'QR Code';

  @override
  String get sendQrCode => 'Send QR code';

  @override
  String get copyLink => 'Copy link';

  @override
  String get copyEmbedHtml => 'Copy embed HTML';

  @override
  String get linkHasExpired => 'Ο σύνδεσμος έληξε';

  @override
  String get publicLinkEnabled => 'Ο δημόσιος σύνδεσμος ενεργοποιήθηκε';

  @override
  String get shareALink => 'Μοιραστείτε έναν σύνδεσμο';

  @override
  String get sharedAlbumSectionDescription =>
      'Δημιουργία κοινόχρηστων και συνεργατικών άλμπουμ με άλλους χρήστες Ente, συμπεριλαμβανομένων των χρηστών με δωρεάν συνδρομή.';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: 'Shared with $numberOfPeople people',
      one: 'Shared with 1 person',
      zero: 'Share with specific people',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId =>
      'Αυτός είναι ο κωδικός επαλήθευσής σας';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'Κάποιος που μοιράζεται άλμπουμ με εσάς θα πρέπει να δει τον ίδιο κωδικό στη συσκευή του.';

  @override
  String get howToViewShareeVerificationID =>
      'Παρακαλώ ζητήστε από τον άλλο χρήστη να πιέσει παρατεταμένα τη διεύθυνση ηλεκτρονικού ταχυδρομείου του στην οθόνη ρυθμίσεων και βεβαιωθείτε ότι οι κωδικοί και στις δύο συσκευές ταιριάζουν.';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'Αυτός είναι ο κωδικός επαλήθευσης του $email';
  }

  @override
  String get verificationId => 'Κωδικός επαλήθευσης';

  @override
  String verifyEmailID({required Object email}) {
    return 'Επαλήθευση $email';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return 'Η διεύθυνση $email δεν αντιστοιχεί σε λογαριασμό Ente.\n\nΣτείλτε μια πρόσκληση για να μοιραστείτε φωτογραφίες.';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return 'Αυτός είναι ο κωδικός επαλήθευσής μου: $verificationID για το ente.io.';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'Γεια σας, θα μπορούσατε να επιβεβαιώσετε ότι αυτό είναι το αναγνωριστικό επαλήθευσής σας για το ente.io: $verificationID';
  }

  @override
  String get somethingWentWrong => 'Κάτι πήγε στραβά';

  @override
  String get sendInvite => 'Αποστολή πρόσκλησης';

  @override
  String get shareTextRecommendUsingEnte =>
      'Κατεβάστε το Ente ώστε να μπορούμε εύκολα να μοιραστούμε φωτογραφίες και βίντεο στην αυθεντική τους ποιότητα\n\nhttps://ente.io';

  @override
  String get done => 'Ολοκληρώθηκε';

  @override
  String get applyCodeTitle => 'Εφαρμογή κωδικού';

  @override
  String get enterCodeDescription =>
      'Εισάγετε τον κωδικό που παρέχεται από το φίλο σας για να κερδίσετε δωρεάν αποθήκευση και για τους δύο σας';

  @override
  String get apply => 'Εφαρμογή';

  @override
  String get failedToApplyCode => 'Αποτυχία εφαρμογής κωδικού';

  @override
  String get enterReferralCode => 'Εισάγετε τον προωθητικό κωδικό';

  @override
  String get codeAppliedPageTitle => 'Ο κωδικός εφαρμόστηκε';

  @override
  String get changeYourReferralCode => 'Αλλάξτε τον προωθητικό κωδικό σας';

  @override
  String get change => 'Αλλαγή';

  @override
  String get unavailableReferralCode =>
      'Λυπούμαστε, αυτός ο κωδικός δεν είναι διαθέσιμος.';

  @override
  String get codeChangeLimitReached =>
      'Λυπούμαστε, έχετε συμπληρώσει το όριο των αλλαγών κωδικού.';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'Παρακαλούμε επικοινωνήστε με το $familyAdminEmail για να αλλάξετε τον κωδικό σας.';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB';
  }

  @override
  String get claimed => 'Κερδήθηκαν';

  @override
  String get details => 'Λεπτομέρειες';

  @override
  String get claimMore => 'Κερδίστε περισσότερα!';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return 'Κερδίζουν και εκείνοι $storageAmountInGB GB';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB κάθε φορά που κάποιος ξεκινά μία συνδρομή επί πληρωμή και εφαρμόζει τον κωδικό σας';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'Προωθητικό κωδικός Ente: $referralCode \n\nΕφαρμόστε το στις Ρυθμίσεις → Γενικές → Παραπομπές για να πάρετε $referralStorageInGB GB δωρεάν μετά την εγγραφή σας για μία συνδρομή επί πληρωμή\n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => 'Κερδίστε δωρεάν χώρο αποθήκευσης';

  @override
  String get inviteYourFriends => 'Προσκαλέστε τους φίλους σας';

  @override
  String get failedToFetchReferralDetails =>
      'Δεν είναι δυνατή η λήψη λεπτομερειών σχετικά με τον προώθησης. Παρακαλώ προσπαθήστε ξανά αργότερα.';

  @override
  String get referralStep1 => '1. Δώστε αυτόν τον κωδικό στους φίλους σας';

  @override
  String get referralStep2 => '2. Ξεκινούν μία συνδρομή επί πληρωμή';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. Και οι δύο κερδίζετε $storageInGB GB* δωρεάν';
  }

  @override
  String get referralsAreCurrentlyPaused =>
      'Οι παραπομπές είναι σε παύση αυτή τη στιγμή';

  @override
  String get youCanAtMaxDoubleYourStorage =>
      '* Μπορείτε κατά μέγιστο να διπλασιάσετε τον αποθηκευτικό σας χώρο';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true': 'Η οικογένειά σας έχει κερδίσει $storageAmountInGb GB μέχρι τώρα',
      'false': 'Έχετε κερδίσει $storageAmountInGb GB μέχρι τώρα',
      'other': 'Έχετε κερδίσει $storageAmountInGb GB μέχρι τώρα!',
    });
    return '$_temp0';
  }

  @override
  String get faq => 'Συχνές Ερωτήσεις';

  @override
  String get help => 'Βοήθεια';

  @override
  String get oopsSomethingWentWrong => 'Ωχ, κάτι πήγε στραβά';

  @override
  String get peopleUsingYourCode => 'Άτομα που χρησιμοποιούν τον κωδικό σου';

  @override
  String get eligible => 'επιλέξιμο';

  @override
  String get total => 'σύνολο';

  @override
  String get codeUsedByYou => 'Κωδικός που χρησιμοποιείται από εσάς';

  @override
  String get freeStorageClaimed => 'Δωρεάν χώρος που έχετε κερδίσει';

  @override
  String get freeStorageUsable => 'Δωρεάν χώρος που μπορεί να χρησιμοποιηθεί';

  @override
  String get usableReferralStorageInfo =>
      'Ο διαθέσιμος χώρος αποθήκευσης περιορίζεται από την τρέχουσα συνδρομή σας. Ο επιπλέον αποθηκευτικός χώρος θα γίνει αυτόματα διαθέσιμος όταν αναβαθμίσετε τη συνδρομή σας.';

  @override
  String get removeFromAlbumTitle => 'Αφαίρεση από το άλμπουμ;';

  @override
  String get removeFromAlbum => 'Αφαίρεση από το άλμπουμ';

  @override
  String get itemsWillBeRemovedFromAlbum =>
      'Τα επιλεγμένα αντικείμενα θα αφαιρεθούν από αυτό το άλμπουμ';

  @override
  String get removeShareItemsWarning =>
      'Selected photos will not be accessible to any viewer of this album, except the photo owners.';

  @override
  String get addingToFavorites => 'Προσθήκη στα αγαπημένα...';

  @override
  String get removingFromFavorites => 'Αφαίρεση από τα αγαπημένα...';

  @override
  String get sorryCouldNotAddToFavorites =>
      'Συγγνώμη, δεν ήταν δυνατή η προσθήκη στα αγαπημένα!';

  @override
  String get sorryCouldNotRemoveFromFavorites =>
      'Συγγνώμη, δεν ήταν δυνατή η αφαίρεση από τα αγαπημένα!';

  @override
  String get subscribeToEnableSharing =>
      'Χρειάζεστε μια ενεργή συνδρομή επί πληρωμή για να ενεργοποιήσετε την κοινή χρήση.';

  @override
  String get subscribeToChangeLinkSetting =>
      'You need a paid subscription to change this link setting.';

  @override
  String get subscribe => 'Εγγραφείτε';

  @override
  String get canOnlyRemoveFilesOwnedByYou =>
      'Μπορείτε να αφαιρέσετε μόνο αρχεία που ανήκουν σε εσάς';

  @override
  String get deleteSharedAlbum => 'Διαγραφή κοινόχρηστου άλμπουμ;';

  @override
  String get deleteAlbum => 'Διαγραφή άλμπουμ';

  @override
  String get deleteAlbumDialog =>
      'Να διαγραφούν επίσης οι φωτογραφίες (και τα βίντεο) αυτού του άλμπουμ από <bold>όλα τα άλλα</bold> άλμπουμ στα οποία βρίσκονται;';

  @override
  String get deleteSharedAlbumDialogBody =>
      'Το άλμπουμ θα διαγραφεί για όλους\n\nΘα χάσετε πρόσβαση σε κοινόχρηστες φωτογραφίες σε αυτό το άλμπουμ που ανήκουν σε άλλους';

  @override
  String get yesRemove => 'Ναι, αφαίρεση';

  @override
  String get creatingLink => 'Δημιουργία συνδέσμου...';

  @override
  String get removeWithQuestionMark => 'Αφαίρεση;';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return 'Ο χρήστης $userEmail θα αφαιρεθεί από το άλμπουμ\n\nΟποιεσδήποτε φωτογραφίες έχει προσθέσει θα αφαιρεθούν επίσης από το άλμπουμ';
  }

  @override
  String get keepPhotos => 'Διατήρηση Φωτογραφιών';

  @override
  String get deletePhotos => 'Διαγραφή φωτογραφιών';

  @override
  String get inviteToEnte => 'Προσκαλέστε στο Ente';

  @override
  String get removePublicLink => 'Αφαίρεση δημόσιου συνδέσμου';

  @override
  String disableLinkMessage({required Object albumName}) {
    return 'Αυτό θα διαγράψει τον δημόσιο σύνδεσμο για πρόσβαση στο \"$albumName\".';
  }

  @override
  String get sharing => 'Κοινή χρήση...';

  @override
  String get youCannotShareWithYourself =>
      'Δεν μπορείτε να κοινοποιήσετε στον εαυτό σας';

  @override
  String get archive => 'Αρχειοθέτηση';

  @override
  String get createAlbumActionHint =>
      'Πατήστε παρατεταμένα για να επιλέξετε φωτογραφίες και κάντε κλικ στο + για να δημιουργήσετε ένα άλμπουμ';

  @override
  String get importing => 'Εισαγωγή....';

  @override
  String get failedToLoadAlbums => 'Αποτυχία φόρτωσης άλμπουμ';

  @override
  String get hidden => 'Κρυφά';

  @override
  String get authToViewYourHiddenFiles =>
      'Παρακαλώ πραγματοποιήστε έλεγχο ταυτότητας για να δείτε τα κρυμμένα αρχεία σας';

  @override
  String get authToViewTrashedFiles =>
      'Παρακαλώ πραγματοποιήστε έλεγχο ταυτότητας για να δείτε τον κάδο απορριμμάτων σας';

  @override
  String get trash => 'Κάδος απορριμμάτων';

  @override
  String get uncategorized => 'Χωρίς Κατηγορία';

  @override
  String get videoSmallCase => 'βίντεο';

  @override
  String get photoSmallCase => 'φωτογραφία';

  @override
  String get singleFileDeleteHighlight => 'Θα διαγραφεί από όλα τα άλμπουμ.';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return 'Αυτό το αρχείο ($fileType) είναι και στο Ente και στη συσκευή σας.';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return 'Αυτό το αρχείο ($fileType) θα διαγραφεί από το Ente.';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return 'Αυτό το αρχείο ($fileType) θα διαγραφεί από τη συσκευή σας.';
  }

  @override
  String get deleteFromEnte => 'Διαγραφή από το Ente';

  @override
  String get yesDelete => 'Ναι, διαγραφή';

  @override
  String get movedToTrash => 'Μετακίνηση στον κάδο';

  @override
  String get deleteFromDevice => 'Διαγραφή από τη συσκευή';

  @override
  String get deleteFromBoth => 'Διαγραφή και από τα δύο';

  @override
  String get newAlbum => 'Νέο άλμπουμ';

  @override
  String get albums => 'Άλμπουμ';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount αναμνήσεις',
      one: '$formattedCount ανάμνηση',
      zero: 'δεν υπάρχουν αναμνήσεις',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count επιλεγμένα',
      one: '$count επιλεγμένο',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count επιλεγμένα',
      one: '$count επιλεγμένο',
    );
    String _temp1 = intl.Intl.pluralLogic(
      yourCount,
      locale: localeName,
      other: '$yourCount δικά σας',
      one: '$yourCount δικό σας',
    );
    return '$_temp0 ($_temp1)';
  }

  @override
  String get advancedSettings => 'Για προχωρημένους';

  @override
  String get photoGridSize => 'Μέγεθος πλέγματος φωτογραφιών';

  @override
  String get manageDeviceStorage => 'Διαχείριση προσωρινής μνήμης συσκευής';

  @override
  String get manageDeviceStorageDesc =>
      'Διαχείριση και εκκαθάριση τοπικής προσωρινής μνήμης.';

  @override
  String get machineLearning => 'Μηχανική μάθηση';

  @override
  String get mlConsent => 'Ενεργοποίηση μηχανικής μάθησης';

  @override
  String get mlConsentTitle => 'Ενεργοποίηση μηχανικής μάθησης;';

  @override
  String get mlConsentDescription =>
      'Αν ενεργοποιήσετε τη μηχανική μάθηση, το Ente θα εξάγει από τα αρχεία, συμπεριλαμβανομένων εκείνων που έχουν διαμοιραστεί άλλοι με εσάς, πληροφορίες όπως χαρακτηριστικά προσώπων.\n\nΑυτό θα συμβαίνει στη συσκευή σας και κάθε βιομετρική πληροφορία που δημιουργείται θα είναι κρυπρογραφημένη από άκρο σε άκρο.';

  @override
  String get mlConsentPrivacy =>
      'Παρακαλούμε κάντε κλικ εδώ για να διαβάσετε περισσότερες πληροφορίες σχετικά με αυτό το χαρακτηριστικό στην πολιτική απορρήτου μας';

  @override
  String get mlConsentConfirmation =>
      'Καταλαβαίνω και επιθυμώ να ενεργοποιήσω τη μηχανική μάθηση';

  @override
  String get magicSearch => 'Μαγική αναζήτηση';

  @override
  String get discover => 'Ανακαλύψτε';

  @override
  String get discover_identity => 'Ταυτότητα';

  @override
  String get discover_screenshots => 'Στιγμιότυπα οθόνης';

  @override
  String get discover_receipts => 'Αποδείξεις';

  @override
  String get discover_notes => 'Σημειώσεις';

  @override
  String get discover_memes => 'Memes';

  @override
  String get discover_visiting_cards => 'Επαγγελματικές Κάρτες';

  @override
  String get discover_babies => 'Μωρά';

  @override
  String get discover_pets => 'Κατοικίδια';

  @override
  String get discover_selfies => 'Selfies';

  @override
  String get discover_wallpapers => 'Ταπετσαρίες';

  @override
  String get discover_food => 'Φαγητό';

  @override
  String get discover_celebrations => 'Γιορτές';

  @override
  String get discover_sunset => 'Ηλιοβασιλέματα';

  @override
  String get discover_hills => 'Λόφοι';

  @override
  String get discover_greenery => 'Πράσινο';

  @override
  String get mlIndexingDescription =>
      'Έχετε υπόψιν ότι η μηχανική μάθηση θα έχει ως αποτέλεσμα υψηλότερη χρήση δικτύου και μπαταρίας μέχρι όλα τα αντικείμενα να εισαχθούν στο ευρετήριο. Εξετάστε το ενδεχόμενο να χρησιμοποιήσετε την εφαρμογή για υπολογιστές ώστε η ευρετηρίαση να ολοκληρωθεί ταχύτερα, όλα τα αποτελέσματα θα συγχρονιστούν αυτόματα.';

  @override
  String get loadingModel => 'Γίνεται λήψη μοντέλων...';

  @override
  String get waitingForWifi => 'Αναμονή για WiFi...';

  @override
  String get status => 'Κατάσταση';

  @override
  String get indexedItems => 'Αντικείμενα στο ευρετήριο';

  @override
  String get pendingItems => 'Εκκρεμή αντικείμενα';

  @override
  String get clearIndexes => 'Καθαρισμός ευρετηρίων';

  @override
  String get selectFoldersForBackup =>
      'Επιλέξτε φακέλους για αντίγραφα ασφαλείας';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      'Οι επιλεγμένοι φάκελοι θα κρυπτογραφηθούν και θα δημιουργηθούν αντίγραφα ασφαλείας';

  @override
  String get unselectAll => 'Αποεπιλογή όλων';

  @override
  String get selectAll => 'Επιλογή όλων';

  @override
  String get skip => 'Παράλειψη';

  @override
  String get updatingFolderSelection => 'Ενημέρωση επιλογής φακέλων...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count αντικείμενα',
      one: '$count αντικείμενο',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Διαγραφή $count αντικειμένων',
      one: 'Διαγραφή $count αντικειμένου',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count αρχεία, $formattedSize το καθένα';
  }

  @override
  String get showMemories => 'Εμφάνιση αναμνήσεων';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count έτη πριν',
      one: '$count έτος πριν',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'Ρυθμίσεις αντιγράφων ασφαλείας';

  @override
  String get backupStatus => 'Κατάσταση αντιγράφων ασφαλείας';

  @override
  String get backupStatusDescription =>
      'Αντικείμενα που έχουν αποθηκευτεί θα εμφανιστούν εδώ';

  @override
  String get backupOverMobileData =>
      'Αντίγραφα ασφαλείας μέσω δεδομένων κινητής τηλεφωνίας';

  @override
  String get backupVideos => 'Αντίγραφα ασφαλείας βίντεο';

  @override
  String get disableAutoLock => 'Απενεργοποίηση αυτόματου κλειδώματος';

  @override
  String get deviceLockExplanation =>
      'Απενεργοποιήστε το κλείδωμα οθόνης συσκευής όταν το Ente βρίσκεται στο προσκήνιο και είναι σε εξέλιξη δημιουργία αντιγράφων ασφαλείας. Αυτό συνήθως δεν χρειάζεται, αλλά μπορεί να βοηθήσει τις μεγάλες προσθήκες και τις αρχικές εισαγωγές μεγάλων βιβλιοθηκών να ολοκληρωθούν ταχύτερα.';

  @override
  String get about => 'Σχετικά με την εφαρμογή';

  @override
  String get weAreOpenSource => 'Είμαστε εφαρμογή ανοιχτού κώδικα!';

  @override
  String get privacy => 'Ιδιωτικότητα';

  @override
  String get terms => 'Όροι';

  @override
  String get checkForUpdates => 'Έλεγχος για ενημερώσεις';

  @override
  String get checkStatus => 'Έλεγχος κατάστασης';

  @override
  String get checking => 'Έλεγχος...';

  @override
  String get youAreOnTheLatestVersion => 'Είστε στην πιο πρόσφατη έκδοση';

  @override
  String get account => 'Λογαριασμός';

  @override
  String get manageSubscription => 'Διαχειριστείτε τη συνδρομή σας';

  @override
  String get authToChangeYourEmail =>
      'Παρακαλώ επαληθεύστε την ταυτότητά σας για να αλλάξετε το email σας';

  @override
  String get changePassword => 'Αλλαγή κωδικού πρόσβασής';

  @override
  String get authToChangeYourPassword =>
      'Παρακαλώ πραγματοποιήστε έλεγχο ταυτότητας για να αλλάξετε τον κωδικό πρόσβασής σας';

  @override
  String get emailVerificationToggle => 'Επαλήθευση email';

  @override
  String get authToChangeEmailVerificationSetting =>
      'Παρακαλώ επαληθεύστε την ταυτότητά σας για την επαλήθευση του email σας';

  @override
  String get exportYourData => 'Εξαγωγή των δεδομένων σας';

  @override
  String get logout => 'Αποσύνδεση';

  @override
  String get authToInitiateAccountDeletion =>
      'Παρακαλώ πραγματοποιήστε έλεγχο ταυτότητας για να ξεκινήσετε τη διαγραφή λογαριασμού';

  @override
  String get areYouSureYouWantToLogout => 'Θέλετε σίγουρα να αποσυνδεθείτε;';

  @override
  String get yesLogout => 'Ναι, αποσύνδεση';

  @override
  String get aNewVersionOfEnteIsAvailable =>
      'Μια νέα έκδοση του Ente είναι διαθέσιμη.';

  @override
  String get update => 'Ενημέρωση';

  @override
  String get installManually => 'Χειροκίνητη εγκατάσταση';

  @override
  String get criticalUpdateAvailable => 'Διαθέσιμη κρίσιμη ενημέρωση';

  @override
  String get updateAvailable => 'Διαθέσιμη ενημέρωση';

  @override
  String get ignoreUpdate => 'Παράβλεψη';

  @override
  String get downloading => 'Λήψη...';

  @override
  String get cannotDeleteSharedFiles =>
      'Δεν είναι δυνατή η διαγραφή κοινόχρηστων αρχείων';

  @override
  String get theDownloadCouldNotBeCompleted =>
      'Η λήψη δεν μπόρεσε να ολοκληρωθεί';

  @override
  String get retry => 'Προσπάθησε ξανά';

  @override
  String get backedUpFolders => 'Φάκελοι με αντίγραφο ασφαλείας';

  @override
  String get backup => 'Backup';

  @override
  String get freeUpDeviceSpace => 'Free up device space';

  @override
  String get freeUpDeviceSpaceDesc =>
      'Save space on your device by clearing files that have been already backed up.';

  @override
  String get allClear => '✨ All clear';

  @override
  String get noDeviceThatCanBeDeleted =>
      'You\'ve no files on this device that can be deleted';

  @override
  String get removeDuplicates => 'Remove duplicates';

  @override
  String get removeDuplicatesDesc =>
      'Review and remove files that are exact duplicates.';

  @override
  String get viewLargeFiles => 'Large files';

  @override
  String get viewLargeFilesDesc =>
      'View files that are consuming the most amount of storage.';

  @override
  String get noDuplicates => '✨ No duplicates';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared =>
      'Δεν υπάρχουν διπλότυπα αρχεία που μπορούν να εκκαθαριστούν';

  @override
  String get success => 'Επιτυχία';

  @override
  String get rateUs => 'Αξιολογήστε μας';

  @override
  String get remindToEmptyDeviceTrash =>
      'Αδειάστε επίσης τα \"Πρόσφατα Διαγραμμένα\" από τις \"Ρυθμίσεις\" -> \"Χώρος αποθήκευσης\" για να ανακτήσετε τον ελεύθερο χώρο';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return 'Έχετε ανακτήσει με επιτυχία $storageSaved!';
  }

  @override
  String get remindToEmptyEnteTrash =>
      'Αδειάστε επίσης τον \"Κάδο απορριμμάτων\" για να ανακτήσετε τον ελεύθερο χώρο';

  @override
  String get sparkleSuccess => '✨ Επιτυχία';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count διπλότυπα αρχεία',
      one: '$count διπλότυπο αρχείο',
    );
    return 'Έχετε εκκαθαρίσει $_temp0, εξοικονομώντας ($storageSaved!)';
  }

  @override
  String get familyPlans => 'Οικογενειακό πρόγραμμα';

  @override
  String get referrals => 'Συστάσεις';

  @override
  String get notifications => 'Ειδοποιήσεις';

  @override
  String get sharedPhotoNotifications => 'Νέες κοινόχρηστες φωτογραφίες';

  @override
  String get sharedPhotoNotificationsExplanation =>
      'Λάβετε ειδοποιήσεις όταν κάποιος προσθέτει μια φωτογραφία σε ένα κοινόχρηστο άλμπουμ που είστε μέρος του';

  @override
  String get advanced => 'Για προχωρημένους';

  @override
  String get general => 'Γενικά';

  @override
  String get security => 'Ασφάλεια';

  @override
  String get authToViewYourRecoveryKey =>
      'Παρακαλούμε πραγματοποιήστε έλεγχο ταυτότητας για να δείτε το κλειδί ανάκτησης';

  @override
  String get twofactor => 'Δύο παράγοντες';

  @override
  String get authToConfigureTwofactorAuthentication =>
      'Παρακαλούμε επαληθεύστε την ταυτότητά σας για να ρυθμίσετε τον έλεγχο ταυτότητας δύο παραγόντων';

  @override
  String get lockscreen => 'Οθόνη κλειδώματος';

  @override
  String get authToChangeLockscreenSetting =>
      'Παρακαλώ επαληθεύστε την ταυτότητά σας για να αλλάξετε τις ρυθμίσεις οθόνης κλειδώματος';

  @override
  String get viewActiveSessions => 'Προβολή ενεργών συνεδριών';

  @override
  String get authToViewYourActiveSessions =>
      'Παρακαλούμε επαληθεύστε την ταυτότητά σας για να δείτε τις ενεργές συνεδρίες σας';

  @override
  String get disableTwofactor => 'Απενεργοποίηση ταυτοποίησης δύο παραγόντων';

  @override
  String get confirm2FADisable =>
      'Θέλετε σίγουρα να απενεργοποιήσετε την ταυτοποίηση δύο παραγόντων;';

  @override
  String get no => 'Όχι';

  @override
  String get yes => 'Ναι';

  @override
  String get social => 'Κοινωνικά δίκτυα';

  @override
  String rateUsOnStore({required Object storeName}) {
    return 'Αξιολογήστε μας στο $storeName';
  }

  @override
  String get blog => 'Blog';

  @override
  String get merchandise => 'Κατάστημα';

  @override
  String get twitter => 'Twitter';

  @override
  String get mastodon => 'Mastodon';

  @override
  String get matrix => 'Matrix';

  @override
  String get discord => 'Discord';

  @override
  String get reddit => 'Reddit';

  @override
  String get yourStorageDetailsCouldNotBeFetched =>
      'Δεν ήταν δυνατή η λήψη των στοιχείων αποθηκευτικού χώρου';

  @override
  String get reportABug => 'Αναφορά Σφάλματος';

  @override
  String get reportBug => 'Αναφορά σφάλματος';

  @override
  String get suggestFeatures => 'Προτείνετε λειτουργίες';

  @override
  String get support => 'Υποστήριξη';

  @override
  String get theme => 'Θέμα';

  @override
  String get lightTheme => 'Φωτεινό';

  @override
  String get darkTheme => 'Σκοτεινό';

  @override
  String get systemTheme => 'Προεπιλογή συστήματος';

  @override
  String get freeTrial => 'Δωρεάν δοκιμή';

  @override
  String get selectYourPlan => 'Επιλέξτε το πλάνο σας';

  @override
  String get enteSubscriptionPitch =>
      'Το Ente διατηρεί τις αναμνήσεις σας για να είναι πάντα στη διάθεσή σας, ακόμα και αν χάσετε τη συσκευή σας.';

  @override
  String get enteSubscriptionShareWithFamily =>
      'Μπορείτε να προσθέσετε και την οικογένειά σας στο πλάνο σας.';

  @override
  String get currentUsageIs => 'Η τρέχουσα χρήση σας είναι ';

  @override
  String get faqs => 'FAQs';

  @override
  String renewsOn({required Object endDate}) {
    return 'Subscription renews on $endDate';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return 'Free trial valid till $endDate';
  }

  @override
  String validTill({required Object endDate}) {
    return 'Valid till $endDate';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return 'Your $storageAmount add-on is valid till $endDate';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return 'Free trial valid till $endDate.\nYou can choose a paid plan afterwards.';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'Your subscription will be cancelled on $endDate';
  }

  @override
  String get subscription => 'Subscription';

  @override
  String get paymentDetails => 'Payment details';

  @override
  String get manageFamily => 'Manage Family';

  @override
  String contactToManageSubscription({required Object provider}) {
    return 'Please contact us at support@ente.io to manage your $provider subscription.';
  }

  @override
  String get renewSubscription => 'Renew subscription';

  @override
  String get cancelSubscription => 'Cancel subscription';

  @override
  String get areYouSureYouWantToRenew => 'Are you sure you want to renew?';

  @override
  String get yesRenew => 'Yes, Renew';

  @override
  String get areYouSureYouWantToCancel => 'Are you sure you want to cancel?';

  @override
  String get yesCancel => 'Yes, cancel';

  @override
  String get failedToRenew => 'Failed to renew';

  @override
  String get failedToCancel => 'Failed to cancel';

  @override
  String get twoMonthsFreeOnYearlyPlans => '2 months free on yearly plans';

  @override
  String get monthly => 'Monthly';

  @override
  String get yearly => 'Yearly';

  @override
  String get confirmPlanChange => 'Confirm plan change';

  @override
  String get areYouSureYouWantToChangeYourPlan =>
      'Are you sure you want to change your plan?';

  @override
  String get youCannotDowngradeToThisPlan =>
      'You cannot downgrade to this plan';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'Please cancel your existing subscription from $paymentProvider first';
  }

  @override
  String get optionalAsShortAsYouLike => 'Optional, as short as you like...';

  @override
  String get send => 'Send';

  @override
  String get askCancelReason =>
      'Your subscription was cancelled. Would you like to share the reason?';

  @override
  String get thankYouForSubscribing => 'Thank you for subscribing!';

  @override
  String get yourPurchaseWasSuccessful => 'Your purchase was successful';

  @override
  String get yourPlanWasSuccessfullyUpgraded =>
      'Your plan was successfully upgraded';

  @override
  String get yourPlanWasSuccessfullyDowngraded =>
      'Your plan was successfully downgraded';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully =>
      'Your subscription was updated successfully';

  @override
  String get googlePlayId => 'Google Play ID';

  @override
  String get appleId => 'Apple ID';

  @override
  String get playstoreSubscription => 'PlayStore subscription';

  @override
  String get appstoreSubscription => 'AppStore subscription';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return 'Your $id is already linked to another Ente account.\nIf you would like to use your $id with this account, please contact our support\'\'';
  }

  @override
  String get visitWebToManage =>
      'Please visit web.ente.io to manage your subscription';

  @override
  String get couldNotUpdateSubscription => 'Αδυναμία ενημέρωσης συνδρομής';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      'Παρακαλούμε επικοινωνήστε με το support@ente.io και θα χαρούμε να βοηθήσουμε!';

  @override
  String get paymentFailed => 'Η πληρωμή απέτυχε';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return 'Παρακαλούμε επικοινωνήστε με την υποστήριξη του $providerName εάν έχετε χρεωθεί';
  }

  @override
  String get continueOnFreeTrial => 'Συνέχεια με δωρεάν δοκιμή';

  @override
  String get areYouSureYouWantToExit => 'Θέλετε σίγουρα να σταματήσετε;';

  @override
  String get thankYou => 'Ευχαριστούμε';

  @override
  String get failedToVerifyPaymentStatus =>
      'Αποτυχία επαλήθευσης κατάστασης πληρωμής';

  @override
  String get pleaseWaitForSometimeBeforeRetrying =>
      'Παρακαλούμε περιμένετε για λίγο πριν ξαναπροσπαθήσετε';

  @override
  String get paymentFailedMessage =>
      'Δυστυχώς η πληρωμή σας απέτυχε. Επικοινωνήστε με την υποστήριξη και θα σας βοηθήσουμε!';

  @override
  String get youAreOnAFamilyPlan => 'Είστε σε οικογενειακό πρόγραμμα!';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'Επικοινωνήστε με το <green>$familyAdminEmail</green> για να διαχειριστείτε τη συνδρομή σας';
  }

  @override
  String get leaveFamily => 'Αποχώρηση από το οικογενειακό πρόγραμμα';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily =>
      'Θέλετε σίγουρα να αποχωρήσετε από το οικογενειακό πρόγραμμα;';

  @override
  String get leave => 'Αποχώρηση';

  @override
  String get rateTheApp => 'Αξιολογήστε την εφαρμογή';

  @override
  String get startBackup => 'Ξεκινήστε τη δημιουργία αντιγράφων ασφαλείας';

  @override
  String get noPhotosAreBeingBackedUpRightNow =>
      'Δεν υπάρχουν φωτογραφίες που να αντιγράφονται αυτή τη στιγμή';

  @override
  String get preserveMore => 'Διατήρηση περισσότερων';

  @override
  String get grantFullAccessPrompt =>
      'Παρακαλούμε επιτρέψτε την πρόσβαση σε όλες τις φωτογραφίες από τις Ρυθμίσεις της συσκευής σας';

  @override
  String get allowPermTitle => 'Να επιτρέπεται η πρόσβαση στις φωτογραφίες';

  @override
  String get allowPermBody =>
      'Παρακαλούμε επιτρέψτε την πρόσβαση στις φωτογραφίες σας από τις Ρυθμίσεις, ώστε το Ente να μπορεί να εμφανίζει και να δημιουργεί αντίγραφα ασφαλείας της βιβλιοθήκης σας.';

  @override
  String get openSettings => 'Άνοιγμα Ρυθμίσεων';

  @override
  String get selectMorePhotos => 'Επιλογή περισσότερων φωτογραφιών';

  @override
  String get existingUser => 'Υπάρχων χρήστης';

  @override
  String get privateBackups => 'Ιδιωτικά αντίγραφα ασφαλείας';

  @override
  String get forYourMemories => 'για τις αναμνήσεις';

  @override
  String get endtoendEncryptedByDefault =>
      'Από προεπιλογή κρυπτογραφημένο από άκρο σε άκρο';

  @override
  String get safelyStored => 'Ασφαλής αποθήκευση';

  @override
  String get atAFalloutShelter => 'σε καταφύγιο';

  @override
  String get designedToOutlive => 'Σχεδιάστηκε για να διαρκέσει για πάντα';

  @override
  String get available => 'Διαθέσιμο';

  @override
  String get everywhere => 'παντού';

  @override
  String get androidIosWebDesktop => 'Android, iOS, Ίντερνετ, Υπολογιστές';

  @override
  String get mobileWebDesktop => 'Κινητά, Ίντερνετ, Υπολογιστές';

  @override
  String get newToEnte => 'Νέος/α στο Ente';

  @override
  String get pleaseLoginAgain => 'Παρακαλούμε συνδεθείτε ξανά';

  @override
  String get autoLogoutMessage =>
      'Έχετε αποσυνδεθεί λόγω τεχνικής δυσλειτουργίας. Ζητούμε συγνώμη για την ταλαιπωρία.';

  @override
  String get yourSubscriptionHasExpired => 'Η συνδρομή σας έχει λήξει';

  @override
  String get storageLimitExceeded => 'Υπέρβαση ορίου αποθήκευσης';

  @override
  String get upgrade => 'Αναβάθμιση';

  @override
  String get raiseTicket => 'Δημιουργία αιτήματος εξυπηρέτησης';

  @override
  String get backupFailed => 'Η δημιουργία αντιγράφου ασφαλείας απέτυχε';

  @override
  String get sorryBackupFailedDesc =>
      'Λυπούμαστε, δεν ήταν δυνατή η δημιουργία αντιγράφων ασφαλείας αυτού του αρχείου αυτή τη στιγμή, θα προσπαθήσουμε ξανά αργότερα.';

  @override
  String get couldNotBackUpTryLater =>
      'Δεν ήταν δυνατή η δημιουργία αντιγράφων ασφαλείας.\nΘα προσπαθήσουμε ξανά αργότερα.';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      'Το Ente μπορεί να κρυπτογραφεί και να διατηρεί αρχεία μόνο αν του δώσετε πρόσβαση σε αυτά';

  @override
  String get pleaseGrantPermissions => 'Παρακαλούμε παραχωρήστε τα δικαιώματα';

  @override
  String get grantPermission => 'Παραχώρηση δικαιωμάτων';

  @override
  String get privateSharing => 'Ιδιωτική κοινή χρήση';

  @override
  String get shareOnlyWithThePeopleYouWant =>
      'Μοιραστείτε μόνο με τους ανθρώπους που θέλετε';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      'Χρησιμοποιήστε δημόσιους συνδέσμους για όσους δεν έχουν Ente';

  @override
  String get allowPeopleToAddPhotos =>
      'Να επιτρέπεται σε άλλους να προσθέτουν φωτογραφίες';

  @override
  String get shareAnAlbumNow => 'Μοιραστείτε ένα άλμπουμ τώρα';

  @override
  String get collectEventPhotos => 'Συλλογή φωτογραφιών';

  @override
  String get sessionExpired => 'Η συνεδρία έληξε';

  @override
  String get loggingOut => 'Αποσύνδεση...';

  @override
  String get onDevice => 'Στη συσκευή';

  @override
  String get onEnte => 'Στο <branding>ente</branding>';

  @override
  String get name => 'Όνομα';

  @override
  String get newest => 'Νεότερα';

  @override
  String get lastUpdated => 'Τελευταία ενημέρωση';

  @override
  String get deleteEmptyAlbums => 'Διαγραφή κενών άλμπουμ';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => 'Διαγραφή κενών άλμπουμ;';

  @override
  String get deleteAlbumsDialogBody =>
      'Αυτό θα διαγράψει όλα τα κενά άλμπουμ. Χρήσιμο όταν θέλετε να μειώσετε την ακαταστασία στη λίστα των άλμπουμ σας.';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return 'Διαγραφή $currentlyDeleting / $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return 'Σε επεξεργασία $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => 'Οριστική διαγραφή';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou =>
      'Μπορείτε να δημιουργήσετε σύνδεσμο μόνο για αρχεία που ανήκουν σε εσάς';

  @override
  String get publicLinkCreated => 'Ο δημόσιος σύνδεσμος δημιουργήθηκε';

  @override
  String get youCanManageYourLinksInTheShareTab =>
      'Μπορείτε να διαχειριστείτε τους συνδέσμους σας στην καρτέλα κοινοποίησης.';

  @override
  String get linkCopiedToClipboard => 'Ο σύνδεσμος αντιγράφηκε στο πρόχειρο';

  @override
  String get restore => 'Επαναφορά';

  @override
  String get moveToAlbum => 'Μετακίνηση σε άλμπουμ';

  @override
  String get unhide => 'Επανεμφάνιση';

  @override
  String get unarchive => 'Κατάργηση αρχειοθέτησης';

  @override
  String get favorite => 'Σήμανση ως αγαπημένο';

  @override
  String get removeFromFavorite => 'Αφαίρεση από τα αγαπημένα';

  @override
  String get shareLink => 'Μοιραστείτε έναν σύνδεσμο';

  @override
  String get createCollage => 'Δημιουργία κολάζ';

  @override
  String get saveCollage => 'Αποθήκευση κολάζ';

  @override
  String get collageSaved => 'Το κολάζ αποθηκεύτηκε στη συλλογή';

  @override
  String get collageLayout => 'Διάταξη';

  @override
  String get addToEnte => 'Προσθήκη στο Ente';

  @override
  String get addToAlbum => 'Πρσθήκη σε άλμπουμ';

  @override
  String get delete => 'Διαγραφή';

  @override
  String get hide => 'Απόκρυψη';

  @override
  String get share => 'Κοινοποίηση';

  @override
  String get unhideToAlbum => 'Επανεμφάνιση στο άλμπουμ';

  @override
  String get restoreToAlbum => 'Επαναφορά στο άλμπουμ';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Μετακίνηση αντικειμένων',
      one: 'Μετακίνηση αντικειμένου',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Προσθήκη αντικειμένων',
      one: 'Προσθήκη αντικειμένου',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'Δημιουργία ή επιλογή άλμπουμ';

  @override
  String get selectAlbum => 'Επιλογή άλμπουμ';

  @override
  String get searchByAlbumNameHint => 'Όνομα άλμπουμ';

  @override
  String get albumTitle => 'Τίτλος άλμπουμ';

  @override
  String get enterAlbumName => 'Εισάγετε όνομα άλμπουμ';

  @override
  String get restoringFiles => 'Restoring files...';

  @override
  String get movingFilesToAlbum => 'Moving files to album...';

  @override
  String get unhidingFilesToAlbum => 'Unhiding files to album';

  @override
  String get canNotUploadToAlbumsOwnedByOthers =>
      'Can not upload to albums owned by others';

  @override
  String get uploadingFilesToAlbum => 'Uploading files to album...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return 'Added successfully to  $albumName';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return 'Moved successfully to $albumName';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'This album already has a collaborative link';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return 'Collaborative link created for $albumName';
  }

  @override
  String get askYourLovedOnesToShare =>
      'Ζητήστε από τα αγαπημένα σας πρόσωπα να συνεισφέρουν';

  @override
  String get invite => 'Πρόσκληση';

  @override
  String get shareYourFirstAlbum => 'Share your first album';

  @override
  String sharedWith({required Object emailIDs}) {
    return 'Shared with $emailIDs';
  }

  @override
  String get sharedWithMe => 'Shared with me';

  @override
  String get sharedByMe => 'Shared by me';

  @override
  String get doubleYourStorage => 'Double your storage';

  @override
  String get referFriendsAnd2xYourPlan => 'Refer friends and 2x your plan';

  @override
  String get shareAlbumHint =>
      'Open an album and tap the share button on the top right to share.';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      'Items show the number of days remaining before permanent deletion';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ημέρες',
      one: '1 ημέρα',
      zero: 'Σύντομα',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => 'Delete All';

  @override
  String get renameAlbum => 'Rename album';

  @override
  String get convertToAlbum => 'Convert to album';

  @override
  String get setCover => 'Set cover';

  @override
  String get sortAlbumsBy => 'Sort by';

  @override
  String get sortNewestFirst => 'Newest first';

  @override
  String get sortOldestFirst => 'Oldest first';

  @override
  String get rename => 'Rename';

  @override
  String get leaveSharedAlbum => 'Leave shared album?';

  @override
  String get leaveAlbum => 'Leave album';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'Photos added by you will be removed from the album';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted =>
      'You\'ve no files in this album that can be deleted';

  @override
  String get youDontHaveAnyArchivedItems =>
      'You don\'t have any archived items.';

  @override
  String get ignoredFolderUploadReason =>
      'Some files in this album are ignored from upload because they had previously been deleted from Ente.';

  @override
  String get resetIgnoredFiles => 'Reset ignored files';

  @override
  String get deviceFilesAutoUploading =>
      'Files added to this device album will automatically get uploaded to Ente.';

  @override
  String get turnOnBackupForAutoUpload =>
      'Turn on backup to automatically upload files added to this device folder to Ente.';

  @override
  String get noHiddenPhotosOrVideos => 'No hidden photos or videos';

  @override
  String get toHideAPhotoOrVideo => 'To hide a photo or video';

  @override
  String get openTheItem => '• Open the item';

  @override
  String get clickOnTheOverflowMenu => '• Click on the overflow menu';

  @override
  String get click => '• Click';

  @override
  String get nothingToSeeHere => 'Nothing to see here! 👀';

  @override
  String get unarchiveAlbum => 'Unarchive album';

  @override
  String get archiveAlbum => 'Archive album';

  @override
  String get calculating => 'Calculating...';

  @override
  String get pleaseWaitDeletingAlbum => 'Please wait, deleting album';

  @override
  String get searchByExamples =>
      '• Album names (e.g. \"Camera\")\n• Types of files (e.g. \"Videos\", \".gif\")\n• Years and months (e.g. \"2022\", \"January\")\n• Holidays (e.g. \"Christmas\")\n• Photo descriptions (e.g. “#fun”)';

  @override
  String get youCanTrySearchingForADifferentQuery =>
      'You can try searching for a different query.';

  @override
  String get noResultsFound => 'No results found';

  @override
  String addedBy({required Object emailOrName}) {
    return 'Added by $emailOrName';
  }

  @override
  String get loadingExifData => 'Loading EXIF data...';

  @override
  String get viewAllExifData => 'View all EXIF data';

  @override
  String get noExifData => 'Χωρίς δεδομένα EXIF';

  @override
  String get thisImageHasNoExifData => 'Αυτή η εικόνα δεν έχει δεδομένα exif';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => 'Κανένα αποτέλεσμα';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'Δεν υποστηρίζουμε την επεξεργασία φωτογραφιών και άλμπουμ που δεν σας ανήκουν ακόμα';

  @override
  String get failedToFetchOriginalForEdit =>
      'Αποτυχία ανάκτησης του αρχικού για επεξεργασία';

  @override
  String get close => 'Κλείσιμο';

  @override
  String get setAs => 'Ορισμός ως';

  @override
  String get fileSavedToGallery => 'Το αρχείο αποθηκεύτηκε στη συλλογή';

  @override
  String get filesSavedToGallery => 'Τα αρχεία αποθηκεύτηκαν στη συλλογή';

  @override
  String get fileFailedToSaveToGallery =>
      'Απέτυχε η αποθήκευση του αρχείου στη συλλογή';

  @override
  String get download => 'Λήψη';

  @override
  String get pressAndHoldToPlayVideo =>
      'Πατήστε παρατεταμένα για αναπαραγωγή βίντεο';

  @override
  String get pressAndHoldToPlayVideoDetailed =>
      'Πατήστε παρατεταμένα στην εικόνα για αναπαραγωγή βίντεο';

  @override
  String get downloadFailed => 'Η λήψη απέτυχε';

  @override
  String get deduplicateFiles => 'Διαγραφή διπλότυπων αρχείων';

  @override
  String get deselectAll => 'Αποεπιλογή όλων';

  @override
  String get reviewDeduplicateItems =>
      'Παρακαλούμε εξετάστε και διαγράψτε τα στοιχεία που πιστεύετε ότι είναι διπλότυπα.';

  @override
  String get clubByCaptureTime => 'Ομαδοποίηση κατά ημερομηνία/ώρα λήψης';

  @override
  String get clubByFileName => 'Ομαδοποίηση κατά όνομα αρχείου';

  @override
  String get count => 'Αριθμός';

  @override
  String get totalSize => 'Συνολικό μέγεθος';

  @override
  String get longpressOnAnItemToViewInFullscreen =>
      'Πατήστε παρατεταμένα σε ένα αντικείμενο για προβολή σε πλήρη οθόνη';

  @override
  String get decryptingVideo => 'Αποκρυπτογράφηση βίντεο...';

  @override
  String get authToViewYourMemories =>
      'Παρακαλώ πραγματοποιήστε έλεγχο ταυτότητας για να δείτε τις αναμνήσεις σας';

  @override
  String get unlock => 'Ξεκλείδωμα';

  @override
  String get freeUpSpace => 'Ελευθερώστε χώρο';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other:
          'Μπορούν να διαγραφούν από τη συσκευή για να ελευθερώσουν $formattedSize',
      one:
          'Μπορεί να διαγραφεί από τη συσκευή για να ελευθερώσει $formattedSize',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber αρχεία',
      one: '1 αρχείο',
    );
    return '$_temp0 σε αυτό το άλμπουμ έχουν αντίγραφα ασφαλείας';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber αρχεία',
      one: '1 αρχείο',
    );
    return '$_temp0 σε αυτή τη συσκευή έχουν αντίγραφα ασφαλείας';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'τα',
      one: 'το',
    );
    return 'Μπορείτε να $_temp0 βρείτε στο Ente όσο έχετε ενεργή συνδρομή';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return 'Εξοικονόμηση $sizeInMBorGB';
  }

  @override
  String get thisEmailIsAlreadyInUse =>
      'Αυτός ο λογαριασμός ηλ. ταχυδρομείου χρησιμοποιείται ήδη';

  @override
  String get incorrectCode => 'Εσφαλμένος κωδικός';

  @override
  String get authenticationFailedPleaseTryAgain =>
      'Αποτυχία ελέγχου ταυτότητας, παρακαλώ προσπαθήστε ξανά';

  @override
  String get verificationFailedPleaseTryAgain =>
      'Η επαλήθευση απέτυχε, παρακαλώ προσπαθήστε ξανά';

  @override
  String get authenticating => 'Ταυτοποίηση...';

  @override
  String get authenticationSuccessful => 'Επιτυχής έλεγχος ταυτότητας!';

  @override
  String get incorrectRecoveryKey => 'Εσφαλμένο κλειδί ανάκτησης';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect =>
      'Το κλειδί ανάκτησης που εισάγατε είναι εσφαλμένο';

  @override
  String get twofactorAuthenticationSuccessfullyReset =>
      'Η αυθεντικοποίηση δύο παραγόντων επαναφέρθηκε επιτυχώς';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered =>
      'Παρακαλούμε επαληθεύστε τον κωδικό που εισάγατε';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      'Επικοινωνήστε με την υποστήριξη πελατών εάν το πρόβλημα επιμένει';

  @override
  String get twofactorAuthenticationHasBeenDisabled =>
      'Ο έλεγχος ταυτότητας δύο παραγόντων έχει απενεργοποιηθεί';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect =>
      'Λυπούμαστε, ο κωδικός που εισαγάγατε είναι εσφαλμένος';

  @override
  String get yourVerificationCodeHasExpired =>
      'Ο κωδικός επαλήθευσής σας έχει λήξει';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'Το email άλλαξε σε $newEmail';
  }

  @override
  String get verifying => 'Γίνεται επιβεβαίωση...';

  @override
  String get disablingTwofactorAuthentication =>
      'Απενεργοποίηση ελέγχου ταυτότητας δύο παραγόντων...';

  @override
  String get allMemoriesPreserved => 'Όλες σας οι μνήμες έχουν διατηρηθεί';

  @override
  String get loadingGallery => 'Loading gallery...';

  @override
  String get syncing => 'Syncing...';

  @override
  String get encryptingBackup => 'Encrypting backup...';

  @override
  String get syncStopped => 'Sync stopped';

  @override
  String syncProgress({required String completed, required String total}) {
    return '$completed/$total memories preserved';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return 'Preserving $count memories...';
  }

  @override
  String get uploadingSingleMemory => 'Preserving 1 memory...';

  @override
  String get archiving => 'Archiving...';

  @override
  String get unarchiving => 'Unarchiving...';

  @override
  String get successfullyArchived => 'Successfully archived';

  @override
  String get successfullyUnarchived => 'Successfully unarchived';

  @override
  String get renameFile => 'Rename file';

  @override
  String get enterFileName => 'Enter file name';

  @override
  String get filesDeleted => 'Files deleted';

  @override
  String get selectedFilesAreNotOnEnte => 'Selected files are not on Ente';

  @override
  String get thisActionCannotBeUndone => 'This action cannot be undone';

  @override
  String get emptyTrash => 'Άδειασμα κάδου;';

  @override
  String get permDeleteWarning =>
      'Όλα τα αντικείμενα στον κάδο απορριμμάτων θα διαγραφούν οριστικά\n\nΑυτή η ενέργεια δεν μπορεί να αναιρεθεί';

  @override
  String get empty => 'Empty';

  @override
  String get couldNotFreeUpSpace => 'Could not free up space';

  @override
  String get permanentlyDeleteFromDevice => 'Permanently delete from device?';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      'Some of the files you are trying to delete are only available on your device and cannot be recovered if deleted';

  @override
  String get theyWillBeDeletedFromAllAlbums =>
      'They will be deleted from all albums.';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'Some items are in both Ente and your device.';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      'Τα επιλεγμένα αρχεία θα αφαιρεθούν από όλα τα άλμπουμ και θα μετακινηθούν στα απορρίμματα.';

  @override
  String get theseItemsWillBeDeletedFromYourDevice =>
      'These items will be deleted from your device.';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      'It looks like something went wrong. Please retry after some time. If the error persists, please contact our support team.';

  @override
  String get error => 'Error';

  @override
  String get tempErrorContactSupportIfPersists =>
      'It looks like something went wrong. Please retry after some time. If the error persists, please contact our support team.';

  @override
  String get networkHostLookUpErr =>
      'Unable to connect to Ente, please check your network settings and contact support if the error persists.';

  @override
  String get networkConnectionRefusedErr =>
      'Unable to connect to Ente, please retry after sometime. If the error persists, please contact support.';

  @override
  String get cachedData => 'Cached data';

  @override
  String get clearCaches => 'Clear caches';

  @override
  String get remoteImages => 'Remote images';

  @override
  String get remoteVideos => 'Remote videos';

  @override
  String get remoteThumbnails => 'Remote thumbnails';

  @override
  String get pendingSync => 'Pending sync';

  @override
  String get localGallery => 'Local gallery';

  @override
  String get todaysLogs => 'Today\'s logs';

  @override
  String get viewLogs => 'View logs';

  @override
  String get logsDialogBody =>
      'This will send across logs to help us debug your issue. Please note that file names will be included to help track issues with specific files.';

  @override
  String get preparingLogs => 'Preparing logs...';

  @override
  String get emailYourLogs => 'Email your logs';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'Please send the logs to \n$toEmail';
  }

  @override
  String get copyEmailAddress => 'Copy email address';

  @override
  String get exportLogs => 'Export logs';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return 'Please email us at $toEmail';
  }

  @override
  String get dismiss => 'Dismiss';

  @override
  String get didYouKnow => 'Did you know?';

  @override
  String get loadingMessage => 'Loading your photos...';

  @override
  String get loadMessage1 => 'You can share your subscription with your family';

  @override
  String get loadMessage2 =>
      'We have preserved over 200 million memories so far';

  @override
  String get loadMessage3 =>
      'We keep 3 copies of your data, one in an underground fallout shelter';

  @override
  String get loadMessage4 => 'Όλες οι εφαρμογές μας είναι ανοιχτού κώδικα';

  @override
  String get loadMessage5 =>
      'Ο πηγαίος κώδικας και η κρυπτογράφησή μας έχουν ελεγχθεί από ανεξάρτητους αξιολογητές';

  @override
  String get loadMessage6 =>
      'Μπορείτε να μοιραστείτε συνδέσμους προς τα άλμπουμ σας με τους αγαπημένους σας';

  @override
  String get loadMessage7 =>
      'Οι εφαρμογές μας για κινητά τρέχουν στο παρασκήνιο για κρυπτογράφηση και δημιουργία αντιγράφων ασφαλείας τυχόν νέων φωτογραφιών σας';

  @override
  String get loadMessage8 =>
      'Το web.ente.io διαθέτει ένα εξαιρετικό μενού μεταφόρτωσης';

  @override
  String get loadMessage9 =>
      'Χρησιμοποιούμε το Xchacha20Poly1305 για την ασφαλή κρυπτογράφηση των δεδομένων σας';

  @override
  String get photoDescriptions => 'Περιγραφές φωτογραφιών';

  @override
  String get fileTypesAndNames => 'Τύποι και ονόματα αρχείων';

  @override
  String get location => 'Τοποθεσία';

  @override
  String get moments => 'Στιγμές';

  @override
  String get searchFaceEmptySection =>
      'Τα άτομα θα εμφανιστούν εδώ μόλις ολοκληρωθεί η δημιουργία ευρετηρίου';

  @override
  String get searchDatesEmptySection => 'Αναζήτηση με ημερομηνία, μήνα ή έτος';

  @override
  String get searchLocationEmptySection =>
      'Ομαδοποίηση φωτογραφιών που τραβήχθηκαν σε συγκεκριμένη ακτίνα από μία φωτογραφία';

  @override
  String get searchPeopleEmptySection =>
      'Προσκαλέστε ανθρώπους και δείτε όλες τις φωτογραφίες που θα μοιραστούν εδώ';

  @override
  String get searchAlbumsEmptySection => 'Άλμπουμ';

  @override
  String get searchFileTypesAndNamesEmptySection => 'Τύποι και ονόματα αρχείων';

  @override
  String get searchCaptionEmptySection =>
      'Προσθέστε περιγραφές όπως #ταξίδι στις πληροφορίες φωτογραφιών για να τις βρείτε γρήγορα εδώ';

  @override
  String get language => 'Γλώσσα';

  @override
  String get selectLanguage => 'Επιλογή Γλώσσας';

  @override
  String get locationName => 'Όνομα τοποθεσίας';

  @override
  String get addLocation => 'Προσθήκη τοποθεσίας';

  @override
  String get groupNearbyPhotos => 'Ομαδοποίηση κοντινών φωτογραφιών';

  @override
  String get kiloMeterUnit => 'χλμ';

  @override
  String get addLocationButton => 'Προσθήκη';

  @override
  String get radius => 'Ακτίνα';

  @override
  String get locationTagFeatureDescription =>
      'Μια ετικέτα τοποθεσίας ομαδοποιεί όλες τις φωτογραφίες που τραβήχθηκαν σε κάποια ακτίνα από μία φωτογραφία';

  @override
  String get galleryMemoryLimitInfo =>
      'Έως και 1000 μνήμες εμφανίζονται στη συλλογή';

  @override
  String get save => 'Αποθήκευση';

  @override
  String get centerPoint => 'Κεντρικό σημείο';

  @override
  String get pickCenterPoint => 'Διαλέξτε κεντρικό σημείο';

  @override
  String get useSelectedPhoto => 'Χρήση επιλεγμένης φωτογραφίας';

  @override
  String get resetToDefault => 'Επαναφορά προεπιλογών';

  @override
  String get edit => 'Επεξεργασία';

  @override
  String get deleteLocation => 'Διαγραφή τοποθεσίας';

  @override
  String get rotateLeft => 'Αριστερή περιστροφή';

  @override
  String get flip => 'Αντιστροφή';

  @override
  String get rotateRight => 'Δεξιά περιστροφή';

  @override
  String get saveCopy => 'Αποθήκευση αντιγράφου';

  @override
  String get light => 'Φωτεινότητα';

  @override
  String get color => 'Χρώμα';

  @override
  String get yesDiscardChanges => 'Ναι, απόρριψη αλλαγών';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade =>
      'Θέλετε να απορρίψετε τις αλλαγές που έχετε κάνει;';

  @override
  String get saving => 'Αποθήκευση...';

  @override
  String get editsSaved => 'Οι αλλαγές αποθηκεύτηκαν';

  @override
  String get oopsCouldNotSaveEdits =>
      'Ωχ, δεν ήταν δυνατή η αποθήκευση των αλλαγών';

  @override
  String get distanceInKMUnit => 'χλμ';

  @override
  String get dayToday => 'Σήμερα';

  @override
  String get dayYesterday => 'Χθες';

  @override
  String get storage => 'Αποθηκευτικός χώρος';

  @override
  String get usedSpace => 'Χώρος που χρησιμοποιείται';

  @override
  String get storageBreakupFamily => 'Οικογένεια';

  @override
  String get storageBreakupYou => 'Εσείς';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return '$usedAmount $usedStorageUnit από $totalAmount $totalStorageUnit σε χρήση';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return '$freeAmount $storageUnit ελεύθερα';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'Έκδοση: $versionValue';
  }

  @override
  String get verifyIDLabel => 'Επαλήθευση';

  @override
  String get fileInfoAddDescHint => 'Προσθήκη περιγραφής...';

  @override
  String get editLocationTagTitle => 'Επεξεργασία τοποθεσίας';

  @override
  String get setLabel => 'Ορισμός';

  @override
  String get setRadius => 'Ορισμός ακτίνας';

  @override
  String get familyPlanPortalTitle => 'Οικογένεια';

  @override
  String get familyPlanOverview =>
      'Προσθέστε 5 μέλη της οικογένειας στη συνδρομή σας χωρίς να πληρώσετε επιπλέον.\n\nΚάθε μέλος έχει τον δικό του ιδιωτικό χώρο και δεν μπορεί να δει τα αρχεία των άλλων εκτός αν του κοινοποιηθούν.\n\nΤα οικογενειακά σχέδια είναι διαθέσιμα σε χρήστες που έχουν συνδρομή επί πληρωμή στο Ente.\n\nΕγγραφείτε τώρα για να ξεκινήσετε!';

  @override
  String get androidBiometricHint => 'Επαλήθευση ταυτότητας';

  @override
  String get androidBiometricNotRecognized =>
      'Δεν αναγνωρίζεται. Δοκιμάστε ξανά.';

  @override
  String get androidBiometricSuccess => 'Επιτυχία';

  @override
  String get androidCancelButton => 'Ακύρωση';

  @override
  String get androidSignInTitle => 'Απαιτείται έλεγχος ταυτότητας';

  @override
  String get androidBiometricRequiredTitle =>
      'Απαιτείται βιομετρικός έλεγχος ταυτότητας';

  @override
  String get androidDeviceCredentialsRequiredTitle =>
      'Απαιτούνται διαπιστευτήρια συσκευής';

  @override
  String get androidDeviceCredentialsSetupDescription =>
      'Απαιτούνται διαπιστευτήρια συσκευής';

  @override
  String get goToSettings => 'Μετάβαση στις ρυθμίσεις';

  @override
  String get androidGoToSettingsDescription =>
      'Ο βιομετρικός έλεγχος ταυτότητας δεν έχει ρυθμιστεί στη συσκευή σας. Μεταβείτε στις \"Ρυθμίσεις > Ασφάλεια\" για να προσθέσετε βιομετρική ταυτοποίηση.';

  @override
  String get iOSLockOut =>
      'Ο βιομετρικός έλεγχος ταυτότητας έχει απενεργοποιηθεί. Παρακαλούμε κλειδώστε και ξεκλειδώστε την οθόνη σας για να τον ενεργοποιήσετε.';

  @override
  String get iOSGoToSettingsDescription =>
      'Ο βιομετρικός έλεγχος ταυτότητας δεν έχει ρυθμιστεί στη συσκευή σας. Παρακαλούμε ενεργοποιήστε το Touch ID ή το Face ID στο τηλέφωνό σας.';

  @override
  String get iOSOkButton => 'OK';

  @override
  String get openstreetmapContributors => 'Συντελεστές του OpenStreetMap';

  @override
  String get hostedAtOsmFrance => 'Hosted at OSM France';

  @override
  String get map => 'Map';

  @override
  String get maps => 'Maps';

  @override
  String get mapsPrivacyNotice =>
      'Approximate coordinates will be sent to privacy conscious third parties like OpenStreetMap to show the map and location.';

  @override
  String get enableMaps => 'Enable Maps';

  @override
  String get quickLinks => 'Quick links';

  @override
  String get selectItemsToAdd => 'Select items to add';

  @override
  String get addSelected => 'Add selected';

  @override
  String get addFromDevice => 'Add from device';

  @override
  String get addPhotos => 'Add photos';

  @override
  String get noPhotosFoundHere => 'No photos found here';

  @override
  String get zoomOutToSeePhotos => 'Zoom out to see photos';

  @override
  String get noImagesWithLocation => 'No images with location';

  @override
  String get unpinAlbum => 'Unpin album';

  @override
  String get pinAlbum => 'Pin album';

  @override
  String get pin => 'Pin';

  @override
  String get pinPerson => 'Pin person';

  @override
  String get pinToTop => 'Pin to top';

  @override
  String get unpin => 'Unpin';

  @override
  String get unpinPerson => 'Unpin person';

  @override
  String get visibility => 'Visibility';

  @override
  String get hideFromMemories => 'Hide from memories';

  @override
  String get showInMemories => 'Show in memories';

  @override
  String get create => 'Create';

  @override
  String get viewAll => 'View all';

  @override
  String get nothingSharedWithYouYet => 'Nothing shared with you yet';

  @override
  String get noAlbumsSharedByYouYet => 'No albums shared by you yet';

  @override
  String get sharedWithYou => 'Shared with you';

  @override
  String get sharedByYou => 'Shared by you';

  @override
  String get inviteYourFriendsToEnte => 'Invite your friends to Ente';

  @override
  String get failedToDownloadVideo => 'Failed to download video';

  @override
  String get hiding => 'Hiding...';

  @override
  String get unhiding => 'Unhiding...';

  @override
  String get successfullyHid => 'Successfully hid';

  @override
  String get successfullyUnhid => 'Successfully unhid';

  @override
  String get crashReporting => 'Crash reporting';

  @override
  String get resumableUploads => 'Resumable uploads';

  @override
  String get addToHiddenAlbum => 'Add to hidden album';

  @override
  String get moveToHiddenAlbum => 'Move to hidden album';

  @override
  String get fileTypes => 'File types';

  @override
  String get deleteConfirmDialogBody =>
      'This account is linked to other Ente apps, if you use any. Your uploaded data, across all Ente apps, will be scheduled for deletion, and your account will be permanently deleted.';

  @override
  String get hearUsWhereTitle => 'How did you hear about Ente? (optional)';

  @override
  String get hearUsExplanation =>
      'We don\'t track app installs. It\'d help if you told us where you found us!';

  @override
  String get viewAddOnButton => 'View add-ons';

  @override
  String get addOns => 'Add-ons';

  @override
  String get addOnPageSubtitle => 'Details of add-ons';

  @override
  String get yourMap => 'Your map';

  @override
  String get modifyYourQueryOrTrySearchingFor =>
      'Modify your query, or try searching for';

  @override
  String get blackFridaySale => 'Black Friday Sale';

  @override
  String get upto50OffUntil4thDec => 'Upto 50% off, until 4th Dec.';

  @override
  String get photos => 'Photos';

  @override
  String get videos => 'Videos';

  @override
  String get livePhotos => 'Live Photos';

  @override
  String get searchHint1 => 'Fast, on-device search';

  @override
  String get searchHint2 => 'Photo dates, descriptions';

  @override
  String get searchHint3 => 'Albums, file names, and types';

  @override
  String get searchHint4 => 'Location';

  @override
  String get searchHint5 => 'Coming soon: Faces & magic search ✨';

  @override
  String get addYourPhotosNow => 'Προσθέστε τις φωτογραφίες σας τώρα';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count αποτελέσματα',
      one: '$count αποτέλεσμα',
    );
    return '$_temp0';
  }

  @override
  String get faces => 'Πρόσωπα';

  @override
  String get people => 'Άνθρωποι';

  @override
  String get contents => 'Περιεχόμενα';

  @override
  String get addNew => 'Προσθήκη νέου';

  @override
  String get contacts => 'Επαφές';

  @override
  String get noInternetConnection => 'Χωρίς σύνδεση στο διαδίκτυο';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'Παρακαλούμε ελέγξτε τη σύνδεσή σας στο διαδίκτυο και προσπαθήστε ξανά.';

  @override
  String get signOutFromOtherDevices => 'Αποσύνδεση από άλλες συσκευές';

  @override
  String get signOutOtherBody =>
      'Αν νομίζετε ότι κάποιος μπορεί να γνωρίζει τον κωδικό πρόσβασής σας, μπορείτε να αναγκάσετε όλες τις άλλες συσκευές που χρησιμοποιούν το λογαριασμό σας να αποσυνδεθούν.';

  @override
  String get signOutOtherDevices => 'Αποσύνδεση άλλων συσκευών';

  @override
  String get doNotSignOut => 'Μην αποσυνδεθείτε';

  @override
  String get editLocation => 'Επεξεργασία τοποθεσίας';

  @override
  String get selectALocation => 'Επιλογή τοποθεσίας';

  @override
  String get selectALocationFirst => 'Επιλέξτε πρώτα μια τοποθεσία';

  @override
  String get changeLocationOfSelectedItems =>
      'Αλλαγή τοποθεσίας των επιλεγμένων στοιχείων;';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte =>
      'Οι αλλαγές στην τοποθεσία θα εμφανίζονται μόνο μέσα στο Ente';

  @override
  String get cleanUncategorized => 'Καθαρισμός μη κατηγοριοποιημένων';

  @override
  String get cleanUncategorizedDescription =>
      'Αφαίρεση από το Χωρίς Κατηγορία όλων των αρχείων που υπάρχουν σε άλλα άλμπουμ';

  @override
  String get waitingForVerification => 'Αναμονή για επαλήθευση...';

  @override
  String get passkey => 'Κλειδί πρόσβασης';

  @override
  String get passkeyAuthTitle => 'Επιβεβαίωση κλειδιού πρόσβασης';

  @override
  String get loginWithTOTP => 'Είσοδος με κωδικό μίας χρήσης (TOTP)';

  @override
  String get passKeyPendingVerification =>
      'Η επαλήθευση εξακολουθεί να εκκρεμεί';

  @override
  String get loginSessionExpired => 'Η συνεδρία έληξε';

  @override
  String get loginSessionExpiredDetails =>
      'Η συνεδρία σας έληξε. Παρακαλώ συνδεθείτε ξανά.';

  @override
  String get verifyPasskey => 'Επιβεβαίωση κλειδιού πρόσβασης';

  @override
  String get playOnTv => 'Αναπαραγωγή άλμπουμ στην τηλεόραση';

  @override
  String get pair => 'Σύζευξη';

  @override
  String get deviceNotFound => 'Η συσκευή δε βρέθηκε';

  @override
  String get castInstruction =>
      'Επισκεφθείτε το cast.ente.io στη συσκευή που θέλετε να συζεύξετε.\n\nΕισάγετε τον παρακάτω κωδικό για να παίξετε το άλμπουμ στην τηλεόρασή σας.';

  @override
  String get deviceCodeHint => 'Εισάγετε τον κωδικό';

  @override
  String get joinDiscord => 'Μπείτε στο Discord';

  @override
  String get locations => 'Τοποθεσίες';

  @override
  String get addAName => 'Προσθήκη ονόματος';

  @override
  String get findThemQuickly => 'Βρείτε τους γρήγορα';

  @override
  String get findPeopleByName => 'Εύρεση ατόμων γρήγορα με το όνομά τους';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Προσθήκη θεατών',
      one: 'Προσθήκη θεατή',
      zero: 'Προσθήκη θεατή',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Προσθήκη συνεργατών',
      one: 'Προσθήκη συνεργάτη',
      zero: 'Προσθήκη συνεργάτη',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      'Πατήστε παρατεταμένα ένα email για να επιβεβαιώσετε την κρυπτογράφηση από άκρη σε άκρη.';

  @override
  String get developerSettingsWarning =>
      'Είστε σίγουροι ότι θέλετε να τροποποιήσετε τις ρυθμίσεις προγραμματιστή;';

  @override
  String get developerSettings => 'Ρυθμίσεις προγραμματιστή';

  @override
  String get serverEndpoint => 'Τερματικό σημείο διακομιστή';

  @override
  String get invalidEndpoint => 'Μη έγκυρο τερματικό σημείο';

  @override
  String get invalidEndpointMessage =>
      'Λυπούμαστε, το τερματικό σημείο που εισάγατε δεν είναι έγκυρο. Παρακαλώ εισάγετε ένα έγκυρο τερματικό σημείο και προσπαθήστε ξανά.';

  @override
  String get endpointUpdatedMessage =>
      'Το τερματκό σημείο ενημερώθηκε επιτυχώς';

  @override
  String customEndpoint({required Object endpoint}) {
    return 'Συνδεδεμένο στο $endpoint';
  }

  @override
  String get createCollaborativeLink => 'Δημιουργία συνεργατικού συνδέσμου';

  @override
  String get search => 'Αναζήτηση';

  @override
  String get enterPersonName => 'Enter person name';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'This email is already linked to $name.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return 'View $name to unlink';
  }

  @override
  String get enterName => 'Enter name';

  @override
  String get savePerson => 'Save person';

  @override
  String get editPerson => 'Edit person';

  @override
  String get mergedPhotos => 'Merged photos';

  @override
  String get orMergeWithExistingPerson => 'Or merge with existing';

  @override
  String get enterDateOfBirth => 'Birthday (optional)';

  @override
  String get birthday => 'Birthday';

  @override
  String get removePersonLabel => 'Remove person label';

  @override
  String get removePersonTag => 'Remove person tag';

  @override
  String get areYouSureRemoveThisPersonTag =>
      'Are you sure you want to remove this person tag?';

  @override
  String get autoPairDesc =>
      'Auto pair works only with devices that support Chromecast.';

  @override
  String get manualPairDesc =>
      'Pair with PIN works with any screen you wish to view your album on.';

  @override
  String get connectToDevice => 'Connect to device';

  @override
  String get autoCastDialogBody => 'You\'ll see available Cast devices here.';

  @override
  String get autoCastiOSPermission =>
      'Make sure Local Network permissions are turned on for the Ente Photos app, in Settings.';

  @override
  String get noDeviceFound => 'No device found';

  @override
  String get stopCastingTitle => 'Stop casting';

  @override
  String get stopCastingBody => 'Do you want to stop casting?';

  @override
  String get castIPMismatchTitle => 'Failed to cast album';

  @override
  String get castIPMismatchBody =>
      'Please make sure you are on the same network as the TV.';

  @override
  String get pairingComplete => 'Pairing complete';

  @override
  String get savingEdits => 'Saving edits...';

  @override
  String get autoPair => 'Auto pair';

  @override
  String get pairWithPin => 'Pair with PIN';

  @override
  String get faceRecognition => 'Face recognition';

  @override
  String get foundFaces => 'Found faces';

  @override
  String get clusteringProgress => 'Clustering progress';

  @override
  String get trim => 'Trim';

  @override
  String get crop => 'Crop';

  @override
  String get rotate => 'Rotate';

  @override
  String get left => 'Left';

  @override
  String get right => 'Right';

  @override
  String get whatsNew => 'What\'s new';

  @override
  String get reviewSuggestions => 'Review suggestions';

  @override
  String get review => 'Review';

  @override
  String get useAsCover => 'Use as cover';

  @override
  String notPersonLabel({required String name}) {
    return 'Not $name?';
  }

  @override
  String get enable => 'Enable';

  @override
  String get enabled => 'Enabled';

  @override
  String get moreDetails => 'More details';

  @override
  String get enableMLIndexingDesc =>
      'Ente supports on-device machine learning for face recognition, magic search and other advanced search features';

  @override
  String get magicSearchHint =>
      'Magic search allows to search photos by their contents, e.g. \'flower\', \'red car\', \'identity documents\'';

  @override
  String get panorama => 'Panorama';

  @override
  String get reenterPassword => 'Re-enter password';

  @override
  String get reenterPin => 'Re-enter PIN';

  @override
  String get deviceLock => 'Device lock';

  @override
  String get pinLock => 'PIN lock';

  @override
  String get next => 'Next';

  @override
  String get setNewPassword => 'Set new password';

  @override
  String get enterPin => 'Εισαγωγή PIN';

  @override
  String get setNewPin => 'Ορίστε νέο PIN';

  @override
  String get appLock => 'Κλείδωμα εφαρμογής';

  @override
  String get noSystemLockFound => 'Δεν βρέθηκε κλείδωμα συστήματος';

  @override
  String get tapToUnlock => 'Πατήστε για ξεκλείδωμα';

  @override
  String get tooManyIncorrectAttempts => 'Πάρα πολλές εσφαλμένες προσπάθειες';

  @override
  String get videoInfo => 'Πληροφορίες βίντεο';

  @override
  String get autoLock => 'Αυτόματο κλείδωμα';

  @override
  String get immediately => 'Αμέσως';

  @override
  String get autoLockFeatureDescription =>
      'Χρόνος μετά τον οποίο η εφαρμογή κλειδώνει μετά την τοποθέτηση στο παρασκήνιο';

  @override
  String get hideContent => 'Απόκρυψη περιεχομένου';

  @override
  String get hideContentDescriptionAndroid =>
      'Απόκρυψη περιεχομένου εφαρμογής στην εναλλαγή εφαρμογών και απενεργοποίηση στιγμιότυπων οθόνης';

  @override
  String get hideContentDescriptionIos =>
      'Απόκρυψη περιεχομένου εφαρμογών στην εναλλαγή εφαρμογών';

  @override
  String get passwordStrengthInfo =>
      'Η ισχύς του κωδικού πρόσβασης υπολογίζεται λαμβάνοντας υπόψη το μήκος του, τους χρησιμοποιούμενους χαρακτήρες, και αν ο κωδικός πρόσβασης εμφανίζεται ή όχι στους 10.000 πιο δημοφιλείς';

  @override
  String get noQuickLinksSelected => 'Δεν επιλέχθηκαν γρήγοροι σύνδεσμοι';

  @override
  String get pleaseSelectQuickLinksToRemove =>
      'Παρακαλώ επιλέξτε γρήγορους συνδέσμους για αφαίρεση';

  @override
  String get removePublicLinks => 'Αφαίρεση δημόσιων συνδέσμων';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      'Αυτό θα αφαιρέσει τους δημόσιους συνδέσμους όλων των επιλεγμένων γρήγορων συνδέσμων.';

  @override
  String get guestView => 'Προβολή επισκέπτη';

  @override
  String get guestViewEnablePreSteps =>
      'Για να ενεργοποιήσετε την προβολή επισκέπτη, παρακαλώ ρυθμίστε τον κωδικό πρόσβασης της συσκευής ή το κλείδωμα οθόνης στις ρυθμίσεις συστήματος.';

  @override
  String get nameTheAlbum => 'Ονομάστε το άλμπουμ';

  @override
  String get collectPhotosDescription =>
      'Δημιουργήστε έναν σύνδεσμο όπου οι φίλοι σας μπορούν να ανεβάσουν φωτογραφίες στην αρχική ποιότητα.';

  @override
  String get collect => 'Συλλογή';

  @override
  String get appLockDescriptions =>
      'Επιλέξτε ανάμεσα στην προεπιλεγμένη οθόνη κλειδώματος της συσκευής σας και σε μια προσαρμοσμένη οθόνη κλειδώματος με ένα PIN ή έναν κωδικό πρόσβασης.';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'Για να ενεργοποιήσετε το κλείδωμα εφαρμογής, παρακαλώ ορίστε τον κωδικό πρόσβασης της συσκευής ή το κλείδωμα οθόνης στις ρυθμίσεις του συστήματος σας.';

  @override
  String get authToViewPasskey =>
      'Παρακαλούμε πραγματοποιήστε έλεγχο ταυτότητας για να δείτε το κλειδί πρόσβασης';

  @override
  String get loopVideoOn => 'Disable looping';

  @override
  String get loopVideoOff => 'Enable looping';

  @override
  String get localSyncErrorMessage =>
      'Φαίνεται ότι κάτι πήγε στραβά καθώς ο τοπικός συγχρονισμός φωτογραφιών παίρνει περισσότερο χρόνο από το αναμενόμενο. Επικοινωνήστε με την ομάδα υποστήριξης';

  @override
  String get showPerson => 'Εμφάνιση προσώπου';

  @override
  String get sort => 'Ταξινόμηση';

  @override
  String get mostRecent => 'Πιο πρόσφατα';

  @override
  String get mostRelevant => 'Πιο σχετικά';

  @override
  String get loadingYourPhotos => 'Φόρτωση των φωτογραφιών σας...';

  @override
  String processingImport({required Object folderName}) {
    return 'Σε επεξεργασία $folderName...';
  }

  @override
  String get personName => 'Όνομα ατόμου';

  @override
  String get addPerson => 'Add person';

  @override
  String get addToPerson => 'Add to person';

  @override
  String get pleaseNamePersonInPeopleSectionFirst =>
      'Please name a person in the People section first';

  @override
  String get onlyUploadedFilesCanBeAddedToPerson =>
      'Only uploaded files can be added to a person';

  @override
  String get noFacesDetectedTapToAdd => 'No faces detected, tap to add.';

  @override
  String addedFilesToPerson({required int count, required String personName}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count files to $personName',
      one: 'Added 1 file to $personName',
    );
    return '$_temp0';
  }

  @override
  String filesAlreadyLinkedToPerson({
    required int count,
    required String personName,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count files are already linked to $personName',
      one: '1 file is already linked to $personName',
    );
    return '$_temp0';
  }

  @override
  String get addNewPerson => 'Προσθήκη νέου ατόμου';

  @override
  String get addNameOrMerge => 'Προσθήκη ονόματος ή συγχώνευση';

  @override
  String get mergeWithExisting => 'Συγχώνευση με υπάρχον';

  @override
  String get newPerson => 'Νέο άτομο';

  @override
  String get addName => 'Προσθήκη ονόματος';

  @override
  String get add => 'Προσθήκη';

  @override
  String extraPhotosFoundFor({required String text}) {
    return 'Βρέθηκαν επιπλέον φωτογραφίες για $text';
  }

  @override
  String get extraPhotosFound => 'Βρέθηκαν επιπλέον φωτογραφίες';

  @override
  String get configuration => 'Παραμετροποίηση';

  @override
  String get localIndexing => 'Τοπική δημιουργία ευρετηρίων';

  @override
  String get processed => 'Έγινε επεξεργασία';

  @override
  String get resetPerson => 'Αφαίρεση';

  @override
  String get areYouSureYouWantToResetThisPerson =>
      'Θέλετε σίγουρα να επαναφέρετε αυτό το άτομο;';

  @override
  String get allPersonGroupingWillReset =>
      'Οι ομαδοποιήσεις προσώπου θα επαναφερθούν και θα χάσετε όλες τις προτάσεις σχετικά με αυτό το άτομο';

  @override
  String get yesResetPerson => 'Yes, reset person';

  @override
  String get onlyThem => 'Only them';

  @override
  String get checkingModels => 'Checking models...';

  @override
  String get enableMachineLearningBanner =>
      'Enable machine learning for magic search and face recognition';

  @override
  String get searchDiscoverEmptySection =>
      'Images will be shown here once processing and syncing is complete';

  @override
  String get searchPersonsEmptySection =>
      'People will be shown here once processing and syncing is complete';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count viewers',
      one: 'Added 1 viewer',
      zero: 'Added 0 viewers',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count collaborators',
      one: 'Added 1 collaborator',
      zero: 'Added 0 collaborator',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured => 'Account is already configured.';

  @override
  String get sessionIdMismatch => 'Session ID mismatch';

  @override
  String get failedToFetchActiveSessions => 'Failed to fetch active sessions';

  @override
  String get failedToRefreshStripeSubscription =>
      'Failed to refresh subscription';

  @override
  String get failedToPlayVideo => 'Failed to play video';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return 'Upload is ignored due to $ignoreReason';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'Type of gallery $galleryType is not supported for rename';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'Tap to upload, upload is currently ignored due to $ignoreReason';
  }

  @override
  String get tapToUpload => 'Tap to upload';

  @override
  String get info => 'Info';

  @override
  String get addFiles => 'Add Files';

  @override
  String get castAlbum => 'Cast album';

  @override
  String get imageNotAnalyzed => 'Image not analyzed';

  @override
  String get noFacesFound => 'No faces found';

  @override
  String get fileNotUploadedYet => 'File not uploaded yet';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return 'No suggestions for $personName';
  }

  @override
  String get month => 'month';

  @override
  String get yearShort => 'yr';

  @override
  String get currentlyRunning => 'currently running';

  @override
  String get ignored => 'ignored';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count photos',
      one: '1 photo',
      zero: '0 photos',
    );
    return '$_temp0';
  }

  @override
  String get file => 'File';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'Sections length mismatch: $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'Select mail app';

  @override
  String get selectAllShort => 'All';

  @override
  String get selectCoverPhoto => 'Select cover photo';

  @override
  String get newLocation => 'New location';

  @override
  String get faceNotClusteredYet =>
      'Face not clustered yet, please come back later';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'The link you are trying to access has expired.';

  @override
  String get openFile => 'Open file';

  @override
  String get backupFile => 'Backup file';

  @override
  String get openAlbumInBrowser => 'Open album in browser';

  @override
  String get openAlbumInBrowserTitle =>
      'Please use the web app to add photos to this album';

  @override
  String get allow => 'Allow';

  @override
  String get allowAppToOpenSharedAlbumLinks =>
      'Allow app to open shared album links';

  @override
  String get seePublicAlbumLinksInApp => 'See public album links in app';

  @override
  String get emergencyContacts => 'Emergency Contacts';

  @override
  String get acceptTrustInvite => 'Accept Invite';

  @override
  String get declineTrustInvite => 'Decline Invite';

  @override
  String get removeYourselfAsTrustedContact =>
      'Remove yourself as trusted contact';

  @override
  String get legacy => 'Legacy';

  @override
  String get legacyPageDesc =>
      'Legacy allows trusted contacts to access your account in your absence.';

  @override
  String get legacyPageDesc2 =>
      'Οι αξιόπιστες επαφές μπορούν να ξεκινήσουν ανάκτηση του λογαριασμού και, αν δεν αποκλειστούν εντός 30 ημερών, να επαναφέρουν τον κωδικό πρόσβασής σας και να αποκτήσουν πρόσβαση στο λογαριασμό σας.';

  @override
  String get legacyAccounts => 'Κληρονομιά λογαριασμού';

  @override
  String get trustedContacts => 'Έμπιστες επαφές';

  @override
  String get addTrustedContact => 'Προσθήκη Έμπιστης Επαφής';

  @override
  String get removeInvite => 'Ανάκληση πρόσκλησης';

  @override
  String get recoveryWarning =>
      'Μια έμπιστη επαφή προσπαθεί να αποκτήσει πρόσβαση στο λογαριασμό σας';

  @override
  String get rejectRecovery => 'Απόρριψη ανάκτησης';

  @override
  String get recoveryInitiated => 'Η ανάκτηση ξεκίνησε';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return 'Θα μπορείτε να έχετε πρόσβαση στο λογαριασμό μετά από $days ημέρες. Θα σταλεί ειδοποίηση στο $email.';
  }

  @override
  String get cancelAccountRecovery => 'Ακύρωση ανάκτησης';

  @override
  String get recoveryAccount => 'Ανάκτηση λογαριασμού';

  @override
  String get cancelAccountRecoveryBody =>
      'Θέλετε σίγουρα να ακυρώσετε την ανάκτηση;';

  @override
  String get startAccountRecoveryTitle => 'Έναρξη ανάκτησης';

  @override
  String get whyAddTrustContact =>
      'Μία έμπιστη επαφή μπορεί να βοηθήσει στην ανάκτηση των δεδομένων σας.';

  @override
  String recoveryReady({required String email}) {
    return 'Τώρα μπορείτε να ανακτήσετε το λογαριασμό του $email ορίζοντας έναν νέο κωδικό πρόσβασης.';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return 'Το $email προσπαθεί να ανακτήσει το λογαριασμό σας.';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return 'Έχετε προσκληθεί να είστε κληρονόμος του λογαριασμού $email.';
  }

  @override
  String get warning => 'Προσοχή';

  @override
  String get proceed => 'Συνέχεια';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return 'Πρόκειται να προσθέτε το $email ως έμπιστη επαφή. Θα μπορούν να ανακτήσουν το λογαριασμό σας αν απουσιάσετε για $numOfDays ημέρες.';
  }

  @override
  String legacyInvite({required Object email}) {
    return 'Ο λογαριασμός $email σας προσκάλεσε ως έμπιστη επαφή του';
  }

  @override
  String get authToManageLegacy =>
      'Παρακαλώ πραγματοποιήστε έλεγχο ταυτότητας για να διαχειριστείτε τις έμπιστες επαφές σας';

  @override
  String get hideSharedItemsFromHomeGallery =>
      'Απόκρυψη κοινόχρηστων αντικειμένων από την αρχική συλλογή';

  @override
  String get swipeToSelect => 'Swipe to select';

  @override
  String get gallery => 'Συλλογή';

  @override
  String get joinAlbum => 'Συμμετοχή στο άλμπουμ';

  @override
  String get joinAlbumSubtext => 'για προβολή και προσθήκη φωτογραφιών';

  @override
  String get joinAlbumSubtextViewer => 'για προσθήκη σε κοινόχρηστα άλμπουμ';

  @override
  String get join => 'Συμμετοχή';

  @override
  String get linkEmail => 'Σύνδεση email';

  @override
  String get link => 'Σύνδεση';

  @override
  String get noEnteAccountExclamation => 'Δεν υπάρχει λογαριασμός Ente!';

  @override
  String get orPickFromYourContacts => 'ή διαλέξτε από τις επαφές σας';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return 'Το $email δεν διαθέτει λογαριασμό Ente.';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (Εγώ)';
  }

  @override
  String get reassignMe => 'Αλλαγή \"Εγώ\"';

  @override
  String get me => 'Εγώ';

  @override
  String get linkEmailToContactBannerCaption => 'για γρηγορότερη κοινή χρήση';

  @override
  String get selectPersonToLink => 'Επιλέξτε άτομο για σύνδεση';

  @override
  String linkPersonToEmail({required String email}) {
    return 'Σύνδεση ατόμου με $email';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return 'Αυτό θα συνδέσει το άτομο $personName με το $email';
  }

  @override
  String get selectYourFace => 'Επιλέξτε το πρόσωπό σας';

  @override
  String get reassigningLoading => 'Επαναπροσδιορισμός...';

  @override
  String reassignedToName({required String name}) {
    return 'Σας ανατέθηκε το $name';
  }

  @override
  String get saveChangesBeforeLeavingQuestion =>
      'Αποθήκευση αλλαγών πριν την αποχώρηση;';

  @override
  String get dontSave => 'Να μην αποθηκευτεί';

  @override
  String get thisIsMeExclamation => 'Είμαι εγώ!';

  @override
  String get linkPerson => 'Σύνδεση ατόμου';

  @override
  String get linkPersonCaption => 'για καλύτερη εμπειρία κοινής χρήσης';

  @override
  String get videoStreaming => 'Βίντεο με υποστήριξη μετάδοσης';

  @override
  String get processingVideos => 'Επεξεργασία βίντεο';

  @override
  String get streamDetails => 'Stream details';

  @override
  String get processing => 'Processing';

  @override
  String get queued => 'Queued';

  @override
  String get ineligible => 'Ineligible';

  @override
  String get failed => 'Failed';

  @override
  String get playStream => 'Play stream';

  @override
  String get playOriginal => 'Play original';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'Joining an album will make your email visible to its participants.';

  @override
  String get pleaseWaitThisWillTakeAWhile =>
      'Please wait, this will take a while.';

  @override
  String get editTime => 'Edit time';

  @override
  String get selectTime => 'Select time';

  @override
  String get selectDate => 'Select date';

  @override
  String get previous => 'Previous';

  @override
  String get selectOneDateAndTimeForAll => 'Select one date and time for all';

  @override
  String get selectStartOfRange => 'Select start of range';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      'This will make the date and time of all selected photos the same.';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'This is the first in the group. Other selected photos will automatically shift based on this new date';

  @override
  String get newRange => 'New range';

  @override
  String get selectOneDateAndTime => 'Select one date and time';

  @override
  String get moveSelectedPhotosToOneDate => 'Move selected photos to one date';

  @override
  String get shiftDatesAndTime => 'Shift dates and time';

  @override
  String get photosKeepRelativeTimeDifference =>
      'Photos keep relative time difference';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count photos',
      one: '1 photo',
      zero: 'No photos',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'App icon';

  @override
  String get notThisPerson => 'Not this person?';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      'Selected items will be removed from this person, but not deleted from your library.';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat through the years';
  }

  @override
  String get thisWeekThroughTheYears => 'This week through the years';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'This week, $count years ago',
      one: 'This week, $count year ago',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'You and $name';
  }

  @override
  String admiringThem({required Object name}) {
    return 'Admiring $name';
  }

  @override
  String embracingThem({required Object name}) {
    return 'Embracing $name';
  }

  @override
  String partyWithThem({required Object name}) {
    return 'Party with $name';
  }

  @override
  String hikingWithThem({required Object name}) {
    return 'Hiking with $name';
  }

  @override
  String feastingWithThem({required Object name}) {
    return 'Feasting with $name';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return 'Selfies with $name';
  }

  @override
  String posingWithThem({required Object name}) {
    return 'Posing with $name';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return 'Beautiful views with $name';
  }

  @override
  String sportsWithThem({required Object name}) {
    return 'Sports with $name';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return 'Road trip with $name';
  }

  @override
  String get spotlightOnYourself => 'Spotlight on yourself';

  @override
  String spotlightOnThem({required Object name}) {
    return 'Spotlight on $name';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$name is $age!';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name turning $age soon';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return 'Last time with $name';
  }

  @override
  String tripToLocation({required Object location}) {
    return 'Trip to $location';
  }

  @override
  String tripInYear({required Object year}) {
    return 'Trip in $year';
  }

  @override
  String get lastYearsTrip => 'Last year\'s trip';

  @override
  String get sunrise => 'On the horizon';

  @override
  String get mountains => 'Over the hills';

  @override
  String get greenery => 'The green life';

  @override
  String get beach => 'Sand and sea';

  @override
  String get city => 'In the city';

  @override
  String get moon => 'In the moonlight';

  @override
  String get onTheRoad => 'On the road again';

  @override
  String get food => 'Culinary delight';

  @override
  String get pets => 'Furry companions';

  @override
  String get curatedMemories => 'Curated memories';

  @override
  String get widgets => 'Widgets';

  @override
  String get memories => 'Memories';

  @override
  String get peopleWidgetDesc =>
      'Select the people you wish to see on your homescreen.';

  @override
  String get albumsWidgetDesc =>
      'Select the albums you wish to see on your homescreen.';

  @override
  String get memoriesWidgetDesc =>
      'Select the kind of memories you wish to see on your homescreen.';

  @override
  String get smartMemories => 'Smart memories';

  @override
  String get pastYearsMemories => 'Past years\' memories';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return 'Also delete the photos (and videos) present in these $count albums from <bold>all</bold> other albums they are part of?';
  }

  @override
  String get addParticipants => 'Add participants';

  @override
  String selectedAlbums({required Object count}) {
    return '$count selected';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'Action not supported on Favourites album';

  @override
  String get onThisDayMemories => 'On this day memories';

  @override
  String get onThisDay => 'On this day';

  @override
  String get lookBackOnYourMemories => 'Look back on your memories 🌄';

  @override
  String get newPhotosEmoji => ' new 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'Sorry, we had to pause your backups';

  @override
  String get clickToInstallOurBestVersionYet =>
      'Click to install our best version yet';

  @override
  String get onThisDayNotificationExplanation =>
      'Receive reminders about memories from this day in previous years.';

  @override
  String get addMemoriesWidgetPrompt =>
      'Add a memories widget to your homescreen and come back here to customize.';

  @override
  String get addAlbumWidgetPrompt =>
      'Add an album widget to your homescreen and come back here to customize.';

  @override
  String get addPeopleWidgetPrompt =>
      'Add a people widget to your homescreen and come back here to customize.';

  @override
  String get birthdayNotifications => 'Birthday notifications';

  @override
  String get receiveRemindersOnBirthdays =>
      'Receive reminders when it\'s someone\'s birthday. Tapping on the notification will take you to photos of the birthday person.';

  @override
  String get happyBirthday => 'Happy birthday! 🥳';

  @override
  String get birthdays => 'Birthdays';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return 'Wish $name a happy birthday! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      'Are you sure you want to remove this face from this person?';

  @override
  String get otherDetectedFaces => 'Other detected faces';

  @override
  String get areThey => 'Are they ';

  @override
  String get questionmark => '?';

  @override
  String get saveAsAnotherPerson => 'Save as another person';

  @override
  String get showLessFaces => 'Show less faces';

  @override
  String get showMoreFaces => 'Show more faces';

  @override
  String get ignore => 'Ignore';

  @override
  String get merge => 'Merge';

  @override
  String get reset => 'Reset';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      'Are you sure you want to ignore this person?';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      'Are you sure you want to ignore these persons?';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'The person groups will not be displayed in the people section anymore. Photos will remain untouched.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'The person will not be displayed in the people section anymore. Photos will remain untouched.';

  @override
  String get areYouSureYouWantToMergeThem =>
      'Are you sure you want to merge them?';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'All unnamed groups will be merged into the selected person. This can still be undone from the suggestions history overview of the person.';

  @override
  String get yesIgnore => 'Yes, ignore';

  @override
  String get same => 'Same';

  @override
  String get different => 'Different';

  @override
  String get sameperson => 'Same person?';

  @override
  String get indexingPausedStatusDescription =>
      'Indexing is paused. It will automatically resume when the device is ready. The device is considered ready when its battery level, battery health, and thermal status are within a healthy range.';

  @override
  String get thisWeek => 'This week';

  @override
  String get lastWeek => 'Last week';

  @override
  String get thisMonth => 'This month';

  @override
  String get thisYear => 'This year';

  @override
  String get groupBy => 'Group by';

  @override
  String get faceThumbnailGenerationFailed =>
      'Unable to generate face thumbnails';

  @override
  String get fileAnalysisFailed => 'Unable to analyze file';

  @override
  String get editAutoAddPeople => 'Edit auto-add people';

  @override
  String get autoAddPeople => 'Auto-add people';

  @override
  String get autoAddToAlbum => 'Auto-add to album';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      'Should the files related to the person that were previously selected in smart albums be removed?';

  @override
  String get addingPhotos => 'Adding photos';

  @override
  String get gettingReady => 'Getting ready';

  @override
  String get addSomePhotosDesc1 => 'Add some photos or pick ';

  @override
  String get addSomePhotosDesc2 => 'familiar faces';

  @override
  String get addSomePhotosDesc3 => '\nto begin with';

  @override
  String get ignorePerson => 'Ignore person';

  @override
  String get mixedGrouping => 'Mixed grouping?';

  @override
  String get analysis => 'Analysis';

  @override
  String get doesGroupContainMultiplePeople =>
      'Does this grouping contain multiple people?';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'We will automatically analyze the grouping to determine if there are multiple people present, and separate them out again. This may take a few seconds.';

  @override
  String get layout => 'Layout';

  @override
  String get day => 'Day';

  @override
  String get undo => 'Undo';

  @override
  String get redo => 'Redo';

  @override
  String get filter => 'Filter';

  @override
  String get adjust => 'Adjust';

  @override
  String get draw => 'Draw';

  @override
  String get sticker => 'Sticker';

  @override
  String get brushColor => 'Brush Color';

  @override
  String get font => 'Font';

  @override
  String get background => 'Background';

  @override
  String get align => 'Align';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added successfully to $count albums',
      one: 'Added successfully to 1 album',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => 'Videos processed';

  @override
  String get totalVideos => 'Total videos';

  @override
  String get skippedVideos => 'Skipped videos';

  @override
  String get videoStreamingDescriptionLine1 =>
      'Play videos instantly on any device.';

  @override
  String get videoStreamingDescriptionLine2 =>
      'Enable to process video streams on this device.';

  @override
  String get videoStreamingNote =>
      'Only videos from last 60 days and under 1 minute are processed on this device. For older/longer videos, enable streaming in the desktop app.';

  @override
  String get createStream => 'Create stream';

  @override
  String get recreateStream => 'Recreate stream';

  @override
  String get addedToStreamCreationQueue => 'Added to stream creation queue';

  @override
  String get addedToStreamRecreationQueue => 'Added to stream recreation queue';

  @override
  String get videoPreviewAlreadyExists => 'Video preview already exists';

  @override
  String get videoAlreadyInQueue => 'Video file already present in the queue';

  @override
  String get videoExportFailed => 'Video creation failed. Please try again.';

  @override
  String videoExportSuccess({required String path}) {
    return 'Video successfully created at $path';
  }

  @override
  String get addedToQueue => 'Added to queue';

  @override
  String get creatingStream => 'Creating stream';

  @override
  String get similarImages => 'Similar images';

  @override
  String get findSimilarImages => 'Find similar images';

  @override
  String get noSimilarImagesFound => 'No similar images found';

  @override
  String get yourPhotosLookUnique => 'Your photos look unique';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count groups found',
      one: '$count group found',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages => 'Review and remove similar images';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return 'Delete $count photos ($size)';
  }

  @override
  String get selectionOptions => 'Selection options';

  @override
  String selectExactWithCount({required int count}) {
    return 'Exactly similar ($count)';
  }

  @override
  String get selectExact => 'Select exact';

  @override
  String selectSimilarWithCount({required int count}) {
    return 'Mostly similar ($count)';
  }

  @override
  String get selectSimilar => 'Select similar';

  @override
  String selectAllWithCount({required int count}) {
    return 'All similarities ($count)';
  }

  @override
  String get selectSimilarImagesTitle => 'Select similar images';

  @override
  String get chooseSimilarImagesToSelect =>
      'Select images based on their visual similarity';

  @override
  String get clearSelection => 'Clear selection';

  @override
  String similarImagesCount({required int count}) {
    return '$count similar images';
  }

  @override
  String deleteWithCount({required int count}) {
    return 'Delete ($count)';
  }

  @override
  String get deleteFiles => 'Delete files';

  @override
  String get areYouSureDeleteFiles =>
      'Are you sure you want to delete these files?';

  @override
  String get greatJob => 'Great job!';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return 'You freed up $size of space';
  }

  @override
  String get size => 'Size';

  @override
  String get similarity => 'Similarity';

  @override
  String get analyzingPhotosLocally => 'Analyzing your photos locally...';

  @override
  String get lookingForVisualSimilarities =>
      'Looking for visual similarities...';

  @override
  String get comparingImageDetails => 'Comparing image details...';

  @override
  String get findingSimilarImages => 'Finding similar images...';

  @override
  String get almostDone => 'Almost done...';

  @override
  String get processingLocally => 'Processing locally';

  @override
  String get useMLToFindSimilarImages =>
      'Review and remove images that look similar to each other.';

  @override
  String get all => 'All';

  @override
  String get similar => 'Similar';

  @override
  String get identical => 'Identical';

  @override
  String get nothingHereTryAnotherFilter =>
      'Nothing here, try another filter! 👀';

  @override
  String get related => 'Related';

  @override
  String get hoorayyyy => 'Hoorayyyy!';

  @override
  String get nothingToTidyUpHere => 'Nothing to tidy up here';

  @override
  String get deletingDash => 'Deleting - ';

  @override
  String get cLTitle1 => 'Introducing Rituals';

  @override
  String get cLDesc1 =>
      'Planning resolutions for 2026? With Rituals, you can set a reminder on Ente Photos and track your progress by taking photos. Use it for workouts, eating habits, daily moments with loved ones—anything you want to make a habit.';

  @override
  String get cLTitle2 => 'Public links, now for everyone';

  @override
  String get cLDesc2 =>
      'All Ente users on the free plan can now create and share public links to photos and albums. To prevent abuse, links will have limits on how many people can view them.';

  @override
  String get cLTitle3 => 'Manually tag people';

  @override
  String get cLDesc3 =>
      'You can now tag people even when our on-device AI doesn\'t detect a face. Handy for pets, partially visible faces, or moments where someone isn\'t actually in the photo but should still be included.';

  @override
  String get cLTitle4 => 'And more';

  @override
  String get cLDesc4 =>
      'You can now pin shared albums. Album links are visible to collaborators and viewers to make sharing even easier. We\'ve fixed some iOS swiping bugs and updated the photo view, including a new favorite icon (making room for upcoming features).';

  @override
  String get closeBy => 'Close';

  @override
  String get peopleAutoAddDesc =>
      'Automatically add photos of the selected people to this album';

  @override
  String get festivities => 'Festive cheer';

  @override
  String get snowAdventures => 'Winter adventures';

  @override
  String get waterfalls => 'Chasing waterfalls';

  @override
  String get wildlife => 'Into the wild';

  @override
  String get flowers => 'Blooming beauties';

  @override
  String get nightLights => 'Neon nights';

  @override
  String get architecture => 'Design icons';

  @override
  String get autumnColors => 'Autumn splendor';

  @override
  String get desertDreams => 'Desert dreams';

  @override
  String get stargazing => 'Under the stars';

  @override
  String get lakeside => 'Lakeside calm';

  @override
  String get rainyDays => 'Rainy day feels';

  @override
  String get sportsAction => 'Game on';

  @override
  String get streetArt => 'Street art stories';

  @override
  String get familyMoments => 'Family time';

  @override
  String get fireworks => 'Firework finale';

  @override
  String get historicSites => 'Echoes of history';

  @override
  String get tropicalParadise => 'Tropical escapes';

  @override
  String get forestTrails => 'Forest strolls';

  @override
  String get citySunsets => 'City sunset glow';

  @override
  String get colorfulMarkets => 'Vibrant markets';

  @override
  String get cozyCafes => 'Cozy cafe corners';

  @override
  String get vintageVibes => 'Vintage vibes';

  @override
  String get aerialViews => 'Aerial perspectives';

  @override
  String get artisticPortraits => 'Artful portraits';

  @override
  String get streetFood => 'Street food bites';

  @override
  String get riverCruises => 'River cruise views';

  @override
  String get facesTimelineBannerTitle => 'Memory Lane';

  @override
  String facesTimelineBannerSubtitle({required String name}) {
    return 'See $name\'s photos across the years';
  }

  @override
  String get facesTimelineAppBarTitle => 'Memory lane';

  @override
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count years old',
      one: '$count year old',
    );
    return '$name was $_temp0';
  }

  @override
  String facesTimelineCaptionYearsAgo({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '# years ago',
      one: '# year ago',
    );
    return '$_temp0';
  }

  @override
  String get facesTimelineShareComingSoon => 'Video sharing coming soon';

  @override
  String get facesTimelinePlaybackPrevious => 'Previous';

  @override
  String get facesTimelinePlaybackNext => 'Next';

  @override
  String get facesTimelinePlaybackPlay => 'Play';

  @override
  String get facesTimelinePlaybackPause => 'Pause';

  @override
  String get facesTimelineUnavailable => 'Faces timeline is preparing...';

  @override
  String get playfulKids => 'Playful kids';

  @override
  String get coastalCliffs => 'Cliffs by the sea';

  @override
  String get ritualsTitle => 'Rituals';

  @override
  String get ritualAddTooltip => 'Add ritual';

  @override
  String get ritualActivityHeading => 'Activity';

  @override
  String get ritualDefaultHeatmapTitle => 'Take a photo every day';

  @override
  String get ritualUntitled => 'Untitled ritual';

  @override
  String get ritualShareUnavailable =>
      'Unable to share right now. Please try again.';

  @override
  String get ritualNotificationMessage => 'Take a photo now';

  @override
  String get ritualCameraNotFound => 'No camera found on this device.';

  @override
  String get ritualCameraStartError =>
      'Unable to start camera. Please check permissions.';

  @override
  String get ritualCaptureError => 'Unable to capture photo. Please try again.';

  @override
  String ritualPhotoLimit({required int maxPhotos}) {
    String _temp0 = intl.Intl.pluralLogic(
      maxPhotos,
      locale: localeName,
      other: '# photos.',
      one: '# photo.',
    );
    return 'You can add up to $_temp0';
  }

  @override
  String get ritualCaptureAtLeastOne => 'Capture at least one photo first.';

  @override
  String get ritualAlbumMissing =>
      'Ritual album missing. Edit the ritual to set an album.';

  @override
  String get ritualAddedToAlbum => 'Added to album';

  @override
  String ritualAddedToAlbumWithName({required String albumName}) {
    return 'Added to $albumName';
  }

  @override
  String ritualAddToAlbumFailure({required String error}) {
    return 'Couldn\'t add photos to the album: $error';
  }

  @override
  String get ritualBackToList => 'Back to rituals';

  @override
  String get ritualNoPhotosYet => 'No photos yet';

  @override
  String get ritualSetAlbumToLaunchCamera =>
      'Set an album for this ritual to launch the camera.';

  @override
  String get ritualDefaultCameraTitle => 'Take a photo';

  @override
  String get ritualBadgeMessage7 =>
      '7 days down! Consistency looks good on you. Keep going!';

  @override
  String get ritualBadgeMessage14 =>
      '14 days in! Your ritual is becoming a habit. Incredible!';

  @override
  String get ritualBadgeMessage30 =>
      '30 days in a row! Legendary consistency. Take a bow!';

  @override
  String get ritualBadgeMessageDefault => 'You\'re on a roll!';

  @override
  String get ritualBadgeNewTitle => 'New achievement';

  @override
  String get ritualBadgePreparing => 'Preparing...';

  @override
  String get ritualStreaksLabel => 'Streaks';

  @override
  String get ritualCreateYourOwn => 'Create your own ritual';

  @override
  String get ritualGetDailyReminders => 'Get daily reminders';

  @override
  String get ritualAlbumNotSet => 'Album not set';

  @override
  String get ritualOpenCameraTooltip => 'Open ritual camera';

  @override
  String get ritualEditorLabel => 'Ritual editor';

  @override
  String get ritualNew => 'Create new ritual';

  @override
  String get ritualCreateNewTitle => 'Create new ritual';

  @override
  String get ritualEdit => 'Edit ritual';

  @override
  String get ritualEnterPrompt => 'Enter your ritual';

  @override
  String get ritualEnterDescription => 'Please enter a description';

  @override
  String get ritualChooseDaysLabel => 'Choose days for ritual';

  @override
  String get ritualDayLabel => 'Day';

  @override
  String get ritualNotificationsOffHint =>
      'Notifications are off. Tap a day to turn them on.';

  @override
  String get ritualTimeLabel => 'Time';

  @override
  String get ritualAlbumLabel => 'Album';

  @override
  String get ritualSave => 'Save ritual';

  @override
  String get ritualCreateAction => 'Create ritual';

  @override
  String get ritualUpdate => 'Update ritual';

  @override
  String get ritualSelectAlbumTitle => 'Select album';

  @override
  String get ritualChooseAlbumLabel => 'Choose an album';

  @override
  String get ritualSendReminderLabel => 'Send reminder';

  @override
  String get ritualSearchOrCreate => 'Search or create new';

  @override
  String get ritualNoAlbumsYet => 'No albums yet';

  @override
  String get ritualNoMatchingAlbums => 'No matching albums';

  @override
  String ritualCreateAlbumWithName({required String albumName}) {
    return 'Create \"$albumName\"';
  }

  @override
  String get ritualCreateNew => 'Create new';

  @override
  String get ritualAlbumSelectionPlaceholder => 'Select album';

  @override
  String get ritualPickEmojiTitle => 'Pick an emoji';

  @override
  String get ritualCustomKeyboardLabel => 'Custom (keyboard)';

  @override
  String get ritualEmojiKeyboardHint => 'Press to open emoji keyboard';

  @override
  String get ritualEmojiUseAction => 'Use';

  @override
  String get ritualSearchEmpty =>
      'Build a ritual to keep your photo habit going.';
}
