// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for German (`de`).
class AppLocalizationsDe extends AppLocalizations {
  AppLocalizationsDe([String locale = 'de']) : super(locale);

  @override
  String get enterYourEmailAddress => 'Gib deine E-Mail-Adresse ein';

  @override
  String get enterYourNewEmailAddress => 'Gib Deine neue E-Mail-Adresse ein';

  @override
  String get accountWelcomeBack => 'Willkommen zurück!';

  @override
  String get emailAlreadyRegistered => 'E-Mail ist bereits registriert.';

  @override
  String get emailNotRegistered => 'E-Mail nicht registriert.';

  @override
  String get email => 'E-Mail';

  @override
  String get cancel => 'Abbrechen';

  @override
  String get verify => 'Überprüfen';

  @override
  String get invalidEmailAddress => 'Ungültige E-Mail-Adresse';

  @override
  String get enterValidEmail => 'Bitte gib eine gültige E-Mail-Adresse ein.';

  @override
  String get deleteAccount => 'Konto löschen';

  @override
  String get deleteAccountWarning =>
      'Hiermit wird dein Account bei Ente Auth, Ente Photos und Ente Locker gelöscht.';

  @override
  String get askDeleteReason =>
      'Was ist der Hauptgrund für die Löschung deines Kontos?';

  @override
  String get deleteAccountFeedbackPrompt =>
      'Wir bedauern sehr, dass du dein Konto löschen möchtest. Du würdest uns sehr helfen, wenn du uns kurz einige Gründe hierfür nennen könntest.';

  @override
  String get feedback => 'Rückmeldung';

  @override
  String get kindlyHelpUsWithThisInformation => 'Bitte gib diese Daten ein';

  @override
  String get confirmDeletePrompt =>
      'Ja, ich möchte dieses Konto und alle enthaltenen Daten über alle Apps hinweg endgültig löschen.';

  @override
  String get confirmAccountDeletion => 'Kontolöschung bestätigen';

  @override
  String get deleteAccountPermanentlyButton => 'Konto unwiderruflich löschen';

  @override
  String get yourAccountHasBeenDeleted => 'Dein Benutzerkonto wurde gelöscht';

  @override
  String get selectReason => 'Grund auswählen';

  @override
  String get deleteReason1 =>
      'Es fehlt eine zentrale Funktion, die ich benötige';

  @override
  String get deleteReason2 =>
      'Die App oder eine bestimmte Funktion verhält sich nicht so wie gedacht';

  @override
  String get deleteReason3 =>
      'Ich habe einen anderen Dienst gefunden, der mir mehr zusagt';

  @override
  String get deleteReason4 => 'Mein Grund ist nicht aufgeführt';

  @override
  String get sendEmail => 'E-Mail senden';

  @override
  String get deleteRequestSLAText =>
      'Deine Anfrage wird innerhalb von 72 Stunden bearbeitet.';

  @override
  String get deleteEmailRequest =>
      'Bitte sende eine E-Mail an <warning>account-deletion@ente.io</warning> von Ihrer bei uns hinterlegten E-Mail-Adresse.';

  @override
  String get entePhotosPerm =>
      'Ente <i> benötigt Berechtigung, um </i> Ihre Fotos zu sichern';

  @override
  String get ok => 'Ok';

  @override
  String get createAccount => 'Konto erstellen';

  @override
  String get createNewAccount => 'Neues Konto erstellen';

  @override
  String get password => 'Passwort';

  @override
  String get confirmPassword => 'Passwort wiederholen';

  @override
  String get activeSessions => 'Aktive Sitzungen';

  @override
  String get ocrProcessingOverlayMessage => 'Erkenne Text...';

  @override
  String get ocrLoadingIndicatorLabel => 'Text erkennen';

  @override
  String get ocrSelectionHint =>
      'Wischen oder doppeltes Tippen, um genau das auszuwählen, was du brauchst';

  @override
  String get ocrNoTextDetected => 'Kein Text erkannt';

  @override
  String get ocrRetryButtonLabel => 'Erneut versuchen';

  @override
  String get ocrModelsNetworkRequiredError =>
      'Netzwerkverbindung erforderlich, um die OCR-Modelle bei der ersten Nutzung herunterzuladen';

  @override
  String get ocrModelsPrepareFailed =>
      'OCR-Modelle konnten nicht vorbereitet werden';

  @override
  String get ocrImageNotFoundError => 'Bilddatei nicht gefunden';

  @override
  String get ocrImageDecodeFailedError =>
      'Bilddatei konnte nicht gelesen werden';

  @override
  String get ocrGenericDetectError => 'Konnte keinen Text im Bild erkennen';

  @override
  String get oops => 'Hoppla';

  @override
  String get somethingWentWrongPleaseTryAgain =>
      'Ein Fehler ist aufgetreten, bitte versuche es erneut';

  @override
  String get thisWillLogYouOutOfThisDevice =>
      'Dadurch werden Sie von Ihrem Gerät abgemeldet!';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice =>
      'Dadurch werden Sie von folgendem Gerät abgemeldet:';

  @override
  String get terminateSession => 'Sitzungen beenden?';

  @override
  String get terminate => 'Beenden';

  @override
  String get thisDevice => 'Dieses Gerät';

  @override
  String get recoverButton => 'Wiederherstellen';

  @override
  String get recoverySuccessful => 'Wiederherstellung erfolgreich!';

  @override
  String get decrypting => 'Wird entschlüsselt...';

  @override
  String get incorrectRecoveryKeyTitle =>
      'Falscher Wiederherstellungs-Schlüssel';

  @override
  String get incorrectRecoveryKeyBody =>
      'Der eingegebene Schlüssel ist ungültig';

  @override
  String get forgotPassword => 'Passwort vergessen';

  @override
  String get enterYourRecoveryKey =>
      'Geben Ihren Wiederherstellungs-Schlüssel ein';

  @override
  String get noRecoveryKey => 'Kein Wiederherstellungs-Schlüssel?';

  @override
  String get sorry => 'Entschuldigung';

  @override
  String get noRecoveryKeyNoDecryption =>
      'Aufgrund unseres Ende-zu-Ende-Verschlüsselungsprotokolls können deine Daten nicht ohne dein Passwort oder deinen Wiederherstellungs-Schlüssel entschlüsselt werden';

  @override
  String get verifyEmail => 'E-Mail-Adresse verifizieren';

  @override
  String get toResetVerifyEmail =>
      'Um dein Passwort zurückzusetzen, verifiziere bitte zuerst deine E-Mail-Adresse.';

  @override
  String get checkInboxAndSpamFolder =>
      'Bitte überprüfe deinen E-Mail-Posteingang (und Spam), um die Verifizierung abzuschließen';

  @override
  String get tapToEnterCode => 'Antippen, um den Code einzugeben';

  @override
  String get resendEmail => 'E-Mail erneut senden';

  @override
  String weHaveSendEmailTo({required String email}) {
    return 'Wir haben eine E-Mail an <green>$email</green> gesendet';
  }

  @override
  String get setPasswordTitle => 'Passwort festlegen';

  @override
  String get changePasswordTitle => 'Passwort ändern';

  @override
  String get resetPasswordTitle => 'Passwort zurücksetzen';

  @override
  String get encryptionKeys => 'Verschlüsselungscode';

  @override
  String get passwordWarning =>
      'Wir speichern dieses Passwort nicht. Wenn du es vergisst, <underline>können wir deine Daten nicht entschlüsseln</underline>';

  @override
  String get enterPasswordToEncrypt =>
      'Gib ein Passwort ein, mit dem wir deine Daten verschlüsseln können';

  @override
  String get enterNewPasswordToEncrypt =>
      'Gib ein neues Passwort ein, mit dem wir deine Daten verschlüsseln können';

  @override
  String get weakStrength => 'Schwach';

  @override
  String get strongStrength => 'Stark';

  @override
  String get moderateStrength => 'Mittel';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'Passwortstärke: $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully => 'Passwort erfolgreich geändert';

  @override
  String get generatingEncryptionKeys =>
      'Generierung von Verschlüsselungscodes...';

  @override
  String get pleaseWait => 'Bitte warten...';

  @override
  String get continueLabel => 'Weiter';

  @override
  String get insecureDevice => 'Unsicheres Gerät';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'Es tut uns leid, wir konnten keine sicheren Schlüssel auf diesem Gerät generieren.\n\nBitte starte die Registrierung auf einem anderen Gerät.';

  @override
  String get howItWorks => 'So funktioniert\'s';

  @override
  String get encryption => 'Verschlüsselung';

  @override
  String get ackPasswordLostWarning =>
      'Ich verstehe, dass ich meine Daten verlieren kann, wenn ich mein Passwort vergesse, da meine Daten <underline>Ende-zu-Ende-verschlüsselt</underline> sind.';

  @override
  String get privacyPolicyTitle => 'Datenschutzerklärung';

  @override
  String get termsOfServicesTitle => 'Nutzungsbedingungen';

  @override
  String get signUpTerms =>
      'Ich stimme den <u-terms>Nutzungsbedingungen</u-terms> und der <u-policy>Datenschutzerklärung</u-policy> zu';

  @override
  String get logInLabel => 'Anmelden';

  @override
  String get loginTerms =>
      'Mit dem Klick auf \"Anmelden\" stimme ich den <u-terms>Nutzungsbedingungen</u-terms> und der <u-policy>Datenschutzerklärung</u-policy> zu';

  @override
  String get changeEmail => 'E-Mail-Adresse ändern';

  @override
  String get enterYourPassword => 'Passwort eingeben';

  @override
  String get welcomeBack => 'Willkommen zurück!';

  @override
  String get contactSupport => 'Support kontaktieren';

  @override
  String get locationPickerTip =>
      'Du kannst auch vom Infobildschirm eines Fotos aus einen Ort zentriert um das Foto hinzufügen';

  @override
  String get incorrectPasswordTitle => 'Falsches Passwort';

  @override
  String get pleaseTryAgain => 'Bitte versuche es erneut';

  @override
  String get recreatePasswordTitle => 'Passwort wiederherstellen';

  @override
  String get useRecoveryKey => 'Wiederherstellungs-Schlüssel verwenden';

  @override
  String get recreatePasswordBody =>
      'Das aktuelle Gerät ist nicht leistungsfähig genug, um dein Passwort zu verifizieren, aber wir können es neu erstellen, damit es auf allen Geräten funktioniert.\n\nBitte melde dich mit deinem Wiederherstellungs-Schlüssel an und erstelle dein Passwort neu (Wenn du willst, kannst du dasselbe erneut verwenden).';

  @override
  String get verifyPassword => 'Passwort überprüfen';

  @override
  String get recoveryKey => 'Wiederherstellungs-Schlüssel';

  @override
  String get recoveryKeyOnForgotPassword =>
      'Falls du dein Passwort vergisst, kannst du deine Daten allein mit diesem Schlüssel wiederherstellen.';

  @override
  String get recoveryKeySaveDescription =>
      'Wir speichern diesen Schlüssel nicht. Bitte speichere diese Schlüssel aus 24 Wörtern an einem sicheren Ort.';

  @override
  String get doThisLater => 'Später erledigen';

  @override
  String get saveKey => 'Schlüssel speichern';

  @override
  String get recoveryKeyCopiedToClipboard =>
      'Wiederherstellungs-Schlüssel in die Zwischenablage kopiert';

  @override
  String get recoverAccount => 'Konto wiederherstellen';

  @override
  String get recover => 'Wiederherstellen';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'Bitte sende eine E-Mail an $supportEmail von deiner registrierten E-Mail-Adresse';
  }

  @override
  String get twofactorSetup => 'Zweiten Faktor (2FA) einrichten';

  @override
  String get enterCode => 'Code eingeben';

  @override
  String get scanCode => 'Code scannen';

  @override
  String get codeCopiedToClipboard => 'Code in Zwischenablage kopiert';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      'Kopiere diesen Code\nin deine Authentifizierungs-App';

  @override
  String get tapToCopy => 'zum Kopieren antippen';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      'Scanne diesen Code mit \ndeiner Authentifizierungs-App';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      'Gib den 6-stelligen Code aus\ndeiner Authentifizierungs-App ein';

  @override
  String get confirm => 'Bestätigen';

  @override
  String get setupComplete => 'Einrichtung abgeschlossen';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready =>
      'Sichere deinen Wiederherstellungs-Schlüssel, falls noch nicht geschehen';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      'Dies kann verwendet werden, um dein Konto wiederherzustellen, wenn du deinen zweiten Faktor (2FA) verlierst';

  @override
  String get twofactorAuthenticationPageTitle =>
      'Zwei-Faktor-Authentifizierung';

  @override
  String get lostDevice => 'Gerät verloren?';

  @override
  String get verifyingRecoveryKey =>
      'Wiederherstellungs-Schlüssel wird überprüft...';

  @override
  String get recoveryKeyVerified => 'Wiederherstellungs-Schlüssel überprüft';

  @override
  String get recoveryKeySuccessBody =>
      'Sehr gut! Dein Wiederherstellungsschlüssel ist gültig. Vielen Dank für die Verifizierung.\n\nBitte vergiss nicht eine Kopie des Wiederherstellungsschlüssels sicher aufzubewahren.';

  @override
  String get invalidRecoveryKey =>
      'Der eingegebene Wiederherstellungsschlüssel ist nicht gültig. Bitte stelle sicher, dass er aus 24 Wörtern zusammengesetzt ist und jedes dieser Worte richtig geschrieben wurde.\n\nSolltest du den Wiederherstellungscode eingegeben haben, stelle bitte sicher, dass dieser 64 Zeichen lang ist und ebenfalls richtig geschrieben wurde.';

  @override
  String get invalidKey => 'Ungültiger Schlüssel';

  @override
  String get tryAgain => 'Erneut versuchen';

  @override
  String get viewRecoveryKey => 'Wiederherstellungsschlüssel anzeigen';

  @override
  String get confirmRecoveryKey => 'Wiederherstellungsschlüssel bestätigen';

  @override
  String get recoveryKeyVerifyReason =>
      'Dein Wiederherstellungsschlüssel ist die einzige Möglichkeit, auf deine Fotos zuzugreifen, solltest du dein Passwort vergessen. Du findest ihn unter Einstellungen > Konto.\n\nBitte gib deinen Wiederherstellungsschlüssel hier ein, um sicherzugehen, dass du ihn korrekt gesichert hast.';

  @override
  String get confirmYourRecoveryKey =>
      'Bestätige deinen Wiederherstellungsschlüssel';

  @override
  String get addViewer => 'Album teilen';

  @override
  String get addCollaborator => 'Bearbeiter hinzufügen';

  @override
  String get admin => 'Admin';

  @override
  String get admins => 'Admins';

  @override
  String get addAdmin => 'Add admin';

  @override
  String get addMoreAdmins => 'Add more admins';

  @override
  String get adminsAndCollaboratorsCanAddPhotosDescription =>
      'Admins and collaborators can add photos. Admins can also manage photos & participants.';

  @override
  String get addANewEmail => 'Neue E-Mail-Adresse hinzufügen';

  @override
  String get orPickAnExistingOne => 'Oder eine vorherige auswählen';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'Bearbeiter können Fotos & Videos zu dem geteilten Album hinzufügen.';

  @override
  String get enterEmail => 'E-Mail eingeben';

  @override
  String get albumOwner => 'Besitzer';

  @override
  String get you => 'Du';

  @override
  String get collaborator => 'Bearbeiter';

  @override
  String get addMore => 'Mehr hinzufügen';

  @override
  String get viewer => 'Zuschauer';

  @override
  String get remove => 'Entfernen';

  @override
  String get removeParticipant => 'Teilnehmer entfernen';

  @override
  String get manage => 'Verwalten';

  @override
  String get addedAs => 'Hinzugefügt als';

  @override
  String get changePermissions => 'Berechtigungen ändern?';

  @override
  String get yesConvertToViewer => 'Ja, zu \"Beobachter\" ändern';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return 'Der Nutzer \"$user\" wird keine weiteren Fotos zum Album hinzufügen können.\n\nJedoch kann er weiterhin vorhandene Bilder, welche durch ihn hinzugefügt worden sind, wieder entfernen';
  }

  @override
  String get allowAddingPhotos => 'Hinzufügen von Fotos erlauben';

  @override
  String get allowJoiningAlbum => 'Erlaube das Beitreten zum Album';

  @override
  String get allowAddPhotosDescription =>
      'Erlaube Nutzern, mit diesem Link ebenfalls Fotos zu diesem geteilten Album hinzuzufügen.';

  @override
  String get passwordLock => 'Passwort Sperre';

  @override
  String get canNotOpenTitle => 'Album kann nicht geöffnet werden';

  @override
  String get canNotOpenBody =>
      'Leider kann dieses Album nicht in der App geöffnet werden.';

  @override
  String get disableDownloadWarningTitle => 'Bitte beachten Sie:';

  @override
  String get disableDownloadWarningBody =>
      'Zuschauer können weiterhin Screenshots oder mit anderen externen Programmen Kopien der Bilder machen.';

  @override
  String get allowDownloads => 'Downloads erlauben';

  @override
  String get linkDeviceLimit => 'Geräte-Limit';

  @override
  String get noDeviceLimit => 'Keins';

  @override
  String get albumLayout => 'Album-Layout';

  @override
  String get layoutGrouped => 'Gruppiert';

  @override
  String get layoutContinuous => 'Kontinuierlich';

  @override
  String get layoutTrip => 'Reise';

  @override
  String get preview => 'Vorschau';

  @override
  String get linkExpiry => 'Ablaufdatum des Links';

  @override
  String get linkExpired => 'Abgelaufen';

  @override
  String get linkEnabled => 'Aktiviert';

  @override
  String get linkNeverExpires => 'Niemals';

  @override
  String get expiredLinkInfo =>
      'Dieser Link ist abgelaufen. Bitte wähle ein neues Ablaufdatum oder deaktiviere das Ablaufdatum des Links.';

  @override
  String get setAPassword => 'Passwort setzen';

  @override
  String get lockButtonLabel => 'Sperren';

  @override
  String get enterPassword => 'Passwort eingeben';

  @override
  String get removeLink => 'Link entfernen';

  @override
  String get manageLink => 'Link verwalten';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'Link läuft am $expiryTime ab';
  }

  @override
  String get albumUpdated => 'Album aktualisiert';

  @override
  String get never => 'Niemals';

  @override
  String get custom => 'Benutzerdefiniert';

  @override
  String get after1Hour => 'Nach 1 Stunde';

  @override
  String get after1Day => 'Nach einem Tag';

  @override
  String get after1Week => 'Nach 1 Woche';

  @override
  String get after1Month => 'Nach 1 Monat';

  @override
  String get after1Year => 'Nach 1 Jahr';

  @override
  String get manageParticipants => 'Verwalten';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Teilnehmer',
      one: '1 Teilnehmer',
      zero: 'Keine Teilnehmer',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'Erstelle einen Link, mit dem andere Fotos in dem geteilten Album sehen und selbst welche hinzufügen können - ohne dass sie die ein Ente-Konto oder die App benötigen. Ideal um gemeinsam Fotos von Events zu sammeln.';

  @override
  String get collectPhotos => 'Fotos sammeln';

  @override
  String get collaborativeLink => 'Gemeinschaftlicher Link';

  @override
  String get shareWithNonenteUsers => 'Mit Nicht-Ente-Benutzern teilen';

  @override
  String get createPublicLink => 'Öffentlichen Link erstellen';

  @override
  String get sendLink => 'Link senden';

  @override
  String get qrCode => 'QR-Code';

  @override
  String get sendQrCode => 'QR-Code senden';

  @override
  String get copyLink => 'Link kopieren';

  @override
  String get copyEmbedHtml => 'Einzubettendes HTML kopieren';

  @override
  String get linkHasExpired => 'Link ist abgelaufen';

  @override
  String get publicLinkEnabled => 'Öffentlicher Link aktiviert';

  @override
  String get shareALink => 'Einen Link teilen';

  @override
  String get sharedAlbumSectionDescription =>
      'Erstelle gemeinsam mit anderen Ente-Nutzern geteilte Alben, inkl. Nutzern ohne Bezahltarif.';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: 'Teilen mit $numberOfPeople Personen',
      one: 'Teilen mit 1 Person',
      zero: 'Teile mit bestimmten Personen',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId => 'Dies ist deine Verifizierungs-ID';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'Jemand, der Alben mit dir teilt, sollte die gleiche ID auf seinem Gerät sehen.';

  @override
  String get howToViewShareeVerificationID =>
      'Bitte sie, auf den Einstellungs Bildschirm ihre E-Mail-Adresse lange anzuklicken und zu überprüfen, dass die IDs auf beiden Geräten übereinstimmen.';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'Dies ist ${email}s Verifizierungs-ID';
  }

  @override
  String get verificationId => 'Verifizierungs-ID';

  @override
  String verifyEmailID({required Object email}) {
    return 'Verifiziere $email';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return '$email hat kein Ente-Konto.\n\nSende eine Einladung, um Fotos zu teilen.';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return 'Hier ist meine Verifizierungs-ID: $verificationID für ente.io.';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'Hey, kannst du bestätigen, dass dies deine ente.io Verifizierungs-ID ist: $verificationID';
  }

  @override
  String get somethingWentWrong => 'Irgendetwas ging schief';

  @override
  String get sendInvite => 'Einladung senden';

  @override
  String get shareTextRecommendUsingEnte =>
      'Hol dir Ente, damit wir ganz einfach Fotos und Videos in Originalqualität teilen können\n\nhttps://ente.io';

  @override
  String get done => 'Fertig';

  @override
  String get applyCodeTitle => 'Code nutzen';

  @override
  String get enterCodeDescription =>
      'Gib den Code deines Freundes ein, damit sie beide kostenlosen Speicherplatz erhalten';

  @override
  String get apply => 'Anwenden';

  @override
  String get failedToApplyCode => 'Der Code konnte nicht aktiviert werden';

  @override
  String get enterReferralCode => 'Gib den Weiterempfehlungs-Code ein';

  @override
  String get codeAppliedPageTitle => 'Code eingelöst';

  @override
  String get changeYourReferralCode => 'Empfehlungscode ändern';

  @override
  String get change => 'Ändern';

  @override
  String get unavailableReferralCode =>
      'Entschuldigung, dieser Code ist nicht verfügbar.';

  @override
  String get codeChangeLimitReached =>
      'Entschuldigung, du hast das Limit der Code-Änderungen erreicht.';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'Bitte wende Dich an $familyAdminEmail, um den Code zu ändern.';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB';
  }

  @override
  String get claimed => 'Eingelöst';

  @override
  String get details => 'Details';

  @override
  String get claimMore => 'Mehr einlösen!';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return 'Diese erhalten auch $storageAmountInGB GB';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB jedes Mal, wenn sich jemand mit deinem Code für einen bezahlten Tarif anmeldet';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'Ente Weiterempfehlungs-Code: $referralCode \n\nEinlösen unter Einstellungen → Allgemein → Weiterempfehlungen, um $referralStorageInGB GB kostenlos zu erhalten, sobald Sie einen kostenpflichtigen Tarif abgeschlossen haben\n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => 'Freien Speicher einlösen';

  @override
  String get inviteYourFriends => 'Lade deine Freunde ein';

  @override
  String get failedToFetchReferralDetails =>
      'Die Weiterempfehlungs-Details können nicht abgerufen werden. Bitte versuche es später erneut.';

  @override
  String get referralStep1 => '1. Gib diesen Code an deine Freunde';

  @override
  String get referralStep2 => '2. Sie schließen ein bezahltes Abo ab';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. Ihr beide erhaltet $storageInGB GB* kostenlos';
  }

  @override
  String get referralsAreCurrentlyPaused => 'Einlösungen sind derzeit pausiert';

  @override
  String get youCanAtMaxDoubleYourStorage =>
      '* Du kannst deinen Speicher maximal verdoppeln';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true': 'Deine Familiengruppe hat bereits $storageAmountInGb GB erhalten',
      'false': 'Du hast bereits $storageAmountInGb GB erhalten',
      'other': 'Du hast bereits $storageAmountInGb GB erhalten!',
    });
    return '$_temp0';
  }

  @override
  String get faq => 'Häufig gestellte Fragen';

  @override
  String get help => 'Hilfe';

  @override
  String get oopsSomethingWentWrong => 'Ups. Leider ist ein Fehler aufgetreten';

  @override
  String get peopleUsingYourCode => 'Leute, die deinen Code verwenden';

  @override
  String get eligible => 'zulässig';

  @override
  String get total => 'Gesamt';

  @override
  String get codeUsedByYou => 'Von dir benutzter Code';

  @override
  String get freeStorageClaimed => 'Kostenlos hinzugefügter Speicherplatz';

  @override
  String get freeStorageUsable => 'Freier Speicherplatz nutzbar';

  @override
  String get usableReferralStorageInfo =>
      'Der verwendbare Speicherplatz ist von deinem aktuellen Abonnement eingeschränkt. Überschüssiger, beanspruchter Speicherplatz wird automatisch verwendbar werden, wenn du ein höheres Abonnement buchst.';

  @override
  String get removeFromAlbumTitle => 'Aus Album entfernen?';

  @override
  String get removeFromAlbum => 'Aus Album entfernen';

  @override
  String get itemsWillBeRemovedFromAlbum =>
      'Ausgewählte Elemente werden aus diesem Album entfernt';

  @override
  String get removeShareItemsWarning =>
      'Ausgewählte Fotos werden für Betrachter dieses Albums nicht zugänglich sein, außer für die Besitzer der Fotos.';

  @override
  String get addingToFavorites => 'Wird zu Favoriten hinzugefügt...';

  @override
  String get removingFromFavorites => 'Wird aus Favoriten entfernt...';

  @override
  String get sorryCouldNotAddToFavorites =>
      'Konnte leider nicht zu den Favoriten hinzugefügt werden!';

  @override
  String get sorryCouldNotRemoveFromFavorites =>
      'Konnte leider nicht aus den Favoriten entfernt werden!';

  @override
  String get subscribeToEnableSharing =>
      'Du benötigst ein aktives, bezahltes Abonnement, um das Teilen zu aktivieren.';

  @override
  String get subscribeToChangeLinkSetting =>
      'Du benötigst ein kostenpflichtiges Abonnement, um diese Link-Einstellung zu ändern.';

  @override
  String get subscribe => 'Abonnieren';

  @override
  String get canOnlyRemoveFilesOwnedByYou =>
      'Du kannst nur Dateien entfernen, die dir gehören';

  @override
  String get deleteSharedAlbum => 'Geteiltes Album löschen?';

  @override
  String get deleteAlbum => 'Album löschen';

  @override
  String get deleteAlbumDialog =>
      'Auch die Fotos (und Videos) in diesem Album aus <bold>allen</bold> anderen Alben löschen, die sie enthalten?';

  @override
  String get deleteSharedAlbumDialogBody =>
      'Dieses Album wird für alle gelöscht\n\nDu wirst den Zugriff auf geteilte Fotos in diesem Album, die anderen gehören, verlieren';

  @override
  String get yesRemove => 'Ja, entfernen';

  @override
  String get creatingLink => 'Erstelle Link...';

  @override
  String get removeWithQuestionMark => 'Entfernen?';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return '$userEmail wird aus diesem geteilten Album entfernt\n\nAlle von ihnen hinzugefügte Fotos werden ebenfalls aus dem Album entfernt';
  }

  @override
  String get keepPhotos => 'Fotos behalten';

  @override
  String get deletePhotos => 'Fotos löschen';

  @override
  String get inviteToEnte => 'Zu Ente einladen';

  @override
  String get removePublicLink => 'Öffentlichen Link entfernen';

  @override
  String disableLinkMessage({required Object albumName}) {
    return 'Der öffentliche Link zum Zugriff auf \"$albumName\" wird entfernt.';
  }

  @override
  String get sharing => 'Teilt...';

  @override
  String get youCannotShareWithYourself =>
      'Du kannst nicht mit dir selbst teilen';

  @override
  String get archive => 'Archiv';

  @override
  String get createAlbumActionHint =>
      'Drücke lange um Fotos auszuwählen und klicke + um ein Album zu erstellen';

  @override
  String get importing => 'Importiert....';

  @override
  String get failedToLoadAlbums => 'Laden der Alben fehlgeschlagen';

  @override
  String get hidden => 'Versteckt';

  @override
  String get authToViewYourHiddenFiles =>
      'Bitte authentifizieren, um die versteckten Dateien anzusehen';

  @override
  String get authToViewTrashedFiles =>
      'Bitte authentifizieren, um die gelöschten Dateien anzuzeigen';

  @override
  String get trash => 'Papierkorb';

  @override
  String get uncategorized => 'Unkategorisiert';

  @override
  String get videoSmallCase => 'Video';

  @override
  String get photoSmallCase => 'Foto';

  @override
  String get singleFileDeleteHighlight => 'Es wird aus allen Alben gelöscht.';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return 'Diese Datei ist sowohl in Ente als auch auf deinem Gerät.';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return 'Diese Datei wird von Ente gelöscht.';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return 'Dieses $fileType wird von deinem Gerät gelöscht.';
  }

  @override
  String get deleteFromEnte => 'Von Ente löschen';

  @override
  String get yesDelete => 'Ja, löschen';

  @override
  String get movedToTrash => 'In den Papierkorb verschoben';

  @override
  String get deleteFromDevice => 'Vom Gerät löschen';

  @override
  String get deleteFromBoth => 'Aus beidem löschen';

  @override
  String get newAlbum => 'Neues Album';

  @override
  String get albums => 'Alben';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount Erinnerungen',
      one: '$formattedCount Erinnerung',
      zero: 'keine Erinnerungen',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return '$count ausgewählt';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return '$count ausgewählt ($yourCount von Ihnen)';
  }

  @override
  String get advancedSettings => 'Erweitert';

  @override
  String get photoGridSize => 'Fotorastergröße';

  @override
  String get manageDeviceStorage => 'Geräte-Cache verwalten';

  @override
  String get manageDeviceStorageDesc =>
      'Lokalen Cache-Speicher überprüfen und löschen.';

  @override
  String get machineLearning => 'Maschinelles Lernen';

  @override
  String get mlConsent => 'Maschinelles Lernen aktivieren';

  @override
  String get mlConsentTitle => 'Maschinelles Lernen aktivieren?';

  @override
  String get mlConsentDescription =>
      'Wenn du das maschinelle Lernen aktivierst, wird Ente Informationen wie etwa Gesichtsgeometrie aus Dateien extrahieren, einschließlich derjenigen, die mit dir geteilt werden.\n\nDies geschieht auf deinem Gerät und alle erzeugten biometrischen Informationen werden Ende-zu-Ende-verschlüsselt.';

  @override
  String get mlConsentPrivacy =>
      'Bitte klicke hier für weitere Details zu dieser Funktion in unserer Datenschutzerklärung';

  @override
  String get mlConsentConfirmation =>
      'Ich verstehe und möchte das maschinelle Lernen aktivieren';

  @override
  String get magicSearch => 'Magische Suche';

  @override
  String get discover => 'Entdecken';

  @override
  String get discover_identity => 'Identität';

  @override
  String get discover_screenshots => 'Bildschirmfotos';

  @override
  String get discover_receipts => 'Belege';

  @override
  String get discover_notes => 'Notizen';

  @override
  String get discover_memes => 'Memes';

  @override
  String get discover_visiting_cards => 'Visitenkarten';

  @override
  String get discover_babies => 'Babys';

  @override
  String get discover_pets => 'Haustiere';

  @override
  String get discover_selfies => 'Selfies';

  @override
  String get discover_wallpapers => 'Hintergründe';

  @override
  String get discover_food => 'Essen';

  @override
  String get discover_celebrations => 'Feiern';

  @override
  String get discover_sunset => 'Sonnenuntergang';

  @override
  String get discover_hills => 'Berge';

  @override
  String get discover_greenery => 'Grün';

  @override
  String get mlIndexingDescription =>
      'Bitte beachte, dass das maschinelle Lernen zu einem höheren Daten- und Akkuverbrauch führen wird, bis alle Elemente indiziert sind. Du kannst die Desktop-App für eine schnellere Indizierung verwenden, alle Ergebnisse werden automatisch synchronisiert.';

  @override
  String get loadingModel => 'Lade Modelle herunter...';

  @override
  String get waitingForWifi => 'Warte auf WLAN...';

  @override
  String get status => 'Status';

  @override
  String get indexedItems => 'Indizierte Elemente';

  @override
  String get pendingItems => 'Ausstehende Elemente';

  @override
  String get clearIndexes => 'Indexe löschen';

  @override
  String get selectFoldersForBackup => 'Ordner für Sicherung auswählen';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      'Ausgewählte Ordner werden verschlüsselt und gesichert';

  @override
  String get unselectAll => 'Alle demarkieren';

  @override
  String get selectAll => 'Alle markieren';

  @override
  String get skip => 'Überspringen';

  @override
  String get updatingFolderSelection => 'Ordnerauswahl wird aktualisiert...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Objekte',
      one: '$count Objekt',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Lösche $count Elemente',
      one: 'Lösche $count Element',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count Dateien, $formattedSize jede';
  }

  @override
  String get showMemories => 'Erinnerungen anschauen';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'vor $count Jahren',
      one: 'vor einem Jahr',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'Backup-Einstellungen';

  @override
  String get backupStatus => 'Sicherungsstatus';

  @override
  String get backupStatusDescription =>
      'Gesicherte Elemente werden hier angezeigt';

  @override
  String get backupOverMobileData => 'Über mobile Daten sichern';

  @override
  String get backupVideos => 'Videos sichern';

  @override
  String get disableAutoLock => 'Automatische Sperre deaktivieren';

  @override
  String get deviceLockExplanation =>
      'Verhindern, dass der Bildschirm gesperrt wird, während die App im Vordergrund ist und eine Sicherung läuft. Das ist normalerweise nicht notwendig, kann aber dabei helfen, große Uploads wie einen Erstimport schneller abzuschließen.';

  @override
  String get about => 'Allgemeine Informationen';

  @override
  String get weAreOpenSource => 'Unser Quellcode ist offen einsehbar!';

  @override
  String get privacy => 'Datenschutz';

  @override
  String get terms => 'Nutzungsbedingungen';

  @override
  String get checkForUpdates => 'Nach Aktualisierungen suchen';

  @override
  String get checkStatus => 'Status überprüfen';

  @override
  String get checking => 'Wird geprüft...';

  @override
  String get youAreOnTheLatestVersion => 'Du bist auf der neuesten Version';

  @override
  String get account => 'Konto';

  @override
  String get manageSubscription => 'Abonnement verwalten';

  @override
  String get authToChangeYourEmail =>
      'Bitte authentifizieren, um deine E-Mail-Adresse zu ändern';

  @override
  String get changePassword => 'Passwort ändern';

  @override
  String get authToChangeYourPassword =>
      'Bitte authentifizieren, um das Passwort zu ändern';

  @override
  String get emailVerificationToggle => 'E-Mail-Verifizierung';

  @override
  String get authToChangeEmailVerificationSetting =>
      'Bitte authentifizieren, um die E-Mail-Bestätigung zu ändern';

  @override
  String get exportYourData => 'Daten exportieren';

  @override
  String get logout => 'Ausloggen';

  @override
  String get authToInitiateAccountDeletion =>
      'Bitte authentifizieren, um die Löschung des Kontos einzuleiten';

  @override
  String get areYouSureYouWantToLogout =>
      'Bist Du sicher, dass du dich abmelden möchtest?';

  @override
  String get yesLogout => 'Ja, ausloggen';

  @override
  String get aNewVersionOfEnteIsAvailable =>
      'Eine neue Version von Ente ist verfügbar.';

  @override
  String get update => 'Updaten';

  @override
  String get installManually => 'Manuell installieren';

  @override
  String get criticalUpdateAvailable => 'Kritisches Update ist verfügbar!';

  @override
  String get updateAvailable => 'Update verfügbar';

  @override
  String get ignoreUpdate => 'Ignorieren';

  @override
  String get downloading => 'Wird heruntergeladen...';

  @override
  String get cannotDeleteSharedFiles => 'Konnte geteilte Dateien nicht löschen';

  @override
  String get theDownloadCouldNotBeCompleted =>
      'Der Download konnte nicht abgeschlossen werden';

  @override
  String get retry => 'Erneut versuchen';

  @override
  String get backedUpFolders => 'Gesicherte Ordner';

  @override
  String get backup => 'Backup';

  @override
  String get freeUpDeviceSpace => 'Gerätespeicher freiräumen';

  @override
  String get freeUpDeviceSpaceDesc =>
      'Spare Speicherplatz auf deinem Gerät, indem du Dateien löschst, die bereits gesichert wurden.';

  @override
  String get allClear => '✨ Alles klar';

  @override
  String get noDeviceThatCanBeDeleted =>
      'Du hast keine Dateien auf diesem Gerät, die gelöscht werden können';

  @override
  String get removeDuplicates => 'Duplikate entfernen';

  @override
  String get removeDuplicatesDesc =>
      'Überprüfe und lösche Dateien, die exakte Duplikate sind.';

  @override
  String get viewLargeFiles => 'Große Dateien';

  @override
  String get viewLargeFilesDesc =>
      'Dateien anzeigen, die den meisten Speicherplatz belegen.';

  @override
  String get noDuplicates => '✨ Keine Duplikate';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared =>
      'Du hast keine Duplikate, die gelöscht werden können';

  @override
  String get success => 'Abgeschlossen';

  @override
  String get rateUs => 'Bewerte uns';

  @override
  String get remindToEmptyDeviceTrash =>
      'Lösche auch Dateien aus \"Kürzlich gelöscht\" unter \"Einstellungen\" -> \"Speicher\" um freien Speicher zu erhalten';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return 'Du hast $storageSaved erfolgreich freigegeben!';
  }

  @override
  String get remindToEmptyEnteTrash =>
      'Leere auch deinen \"Papierkorb\", um freien Platz zu erhalten';

  @override
  String get sparkleSuccess => '✨ Abgeschlossen';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count dupliziere Dateien',
      one: '$count duplizierte Datei',
    );
    return 'Du hast $_temp0 gelöscht und ($storageSaved!) freigegeben';
  }

  @override
  String get familyPlans => 'Familientarif';

  @override
  String get referrals => 'Weiterempfehlungen';

  @override
  String get notifications => 'Benachrichtigungen';

  @override
  String get sharedPhotoNotifications => 'Neue geteilte Fotos';

  @override
  String get sharedPhotoNotificationsExplanation =>
      'Erhalte Benachrichtigungen, wenn jemand ein Foto zu einem gemeinsam genutzten Album hinzufügt, dem du angehörst';

  @override
  String get advanced => 'Erweitert';

  @override
  String get general => 'Allgemein';

  @override
  String get security => 'Sicherheit';

  @override
  String get authToViewYourRecoveryKey =>
      'Bitte authentifizieren, um deinen Wiederherstellungs-Schlüssel anzusehen';

  @override
  String get twofactor => 'Zwei-Faktor';

  @override
  String get authToConfigureTwofactorAuthentication =>
      'Bitte authentifizieren, um Zwei-Faktor-Authentifizierung zu konfigurieren';

  @override
  String get lockscreen => 'Sperrbildschirm';

  @override
  String get authToChangeLockscreenSetting =>
      'Bitte authentifizieren, um die Sperrbildschirm-Einstellung zu ändern';

  @override
  String get viewActiveSessions => 'Aktive Sitzungen anzeigen';

  @override
  String get authToViewYourActiveSessions =>
      'Bitte authentifizieren, um die aktiven Sitzungen anzusehen';

  @override
  String get disableTwofactor => 'Zweiten Faktor (2FA) deaktivieren';

  @override
  String get confirm2FADisable =>
      'Bist du sicher, dass du die Zwei-Faktor-Authentifizierung (2FA) deaktivieren willst?';

  @override
  String get no => 'Nein';

  @override
  String get yes => 'Ja';

  @override
  String get social => 'Social Media';

  @override
  String rateUsOnStore({required Object storeName}) {
    return 'Bewerte uns auf $storeName';
  }

  @override
  String get blog => 'Blog';

  @override
  String get merchandise => 'Merchandise';

  @override
  String get twitter => 'Twitter';

  @override
  String get mastodon => 'Mastodon';

  @override
  String get matrix => 'Matrix';

  @override
  String get discord => 'Discord';

  @override
  String get reddit => 'Reddit';

  @override
  String get yourStorageDetailsCouldNotBeFetched =>
      'Details zum Speicherplatz konnten nicht abgerufen werden';

  @override
  String get reportABug => 'Fehler melden';

  @override
  String get reportBug => 'Fehler melden';

  @override
  String get suggestFeatures => 'Verbesserung vorschlagen';

  @override
  String get support => 'Support';

  @override
  String get theme => 'Theme';

  @override
  String get lightTheme => 'Hell';

  @override
  String get darkTheme => 'Dunkel';

  @override
  String get systemTheme => 'System';

  @override
  String get freeTrial => 'Kostenlose Testphase';

  @override
  String get selectYourPlan => 'Wähle dein Abo aus';

  @override
  String get enteSubscriptionPitch =>
      'Ente sichert deine Erinnerungen, sodass sie dir nie verloren gehen, selbst wenn du dein Gerät verlierst.';

  @override
  String get enteSubscriptionShareWithFamily =>
      'Deine Familie kann zu deinem Abo hinzugefügt werden.';

  @override
  String get currentUsageIs => 'Aktuell genutzt werden ';

  @override
  String get faqs => 'FAQs';

  @override
  String renewsOn({required Object endDate}) {
    return 'Erneuert am $endDate';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return 'Kostenlose Demo verfügbar bis zum $endDate';
  }

  @override
  String validTill({required Object endDate}) {
    return 'Gültig bis $endDate';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return 'Dein $storageAmount Add-on ist gültig bis $endDate';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return 'Kostenlose Testversion gültig bis $endDate.\nDu kannst anschließend ein bezahltes Paket auswählen.';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'Dein Abo endet am $endDate';
  }

  @override
  String get subscription => 'Abonnement';

  @override
  String get paymentDetails => 'Zahlungsdetails';

  @override
  String get manageFamily => 'Familiengruppe verwalten';

  @override
  String contactToManageSubscription({required Object provider}) {
    return 'Bitte kontaktiere uns über support@ente.io, um dein $provider Abo zu verwalten.';
  }

  @override
  String get renewSubscription => 'Abonnement erneuern';

  @override
  String get cancelSubscription => 'Abonnement kündigen';

  @override
  String get areYouSureYouWantToRenew =>
      'Bist du sicher, dass du verlängern möchtest?';

  @override
  String get yesRenew => 'Ja, erneuern';

  @override
  String get areYouSureYouWantToCancel =>
      'Bist du sicher, dass du kündigen willst?';

  @override
  String get yesCancel => 'Ja, kündigen';

  @override
  String get failedToRenew => 'Erneuern fehlgeschlagen';

  @override
  String get failedToCancel => 'Kündigung fehlgeschlagen';

  @override
  String get twoMonthsFreeOnYearlyPlans =>
      '2 Monate kostenlos beim jährlichen Bezahlen';

  @override
  String get monthly => 'Monatlich';

  @override
  String get yearly => 'Jährlich';

  @override
  String get confirmPlanChange => 'Aboänderungen bestätigen';

  @override
  String get areYouSureYouWantToChangeYourPlan =>
      'Bist du sicher, dass du deinen Tarif ändern möchtest?';

  @override
  String get youCannotDowngradeToThisPlan =>
      'Du kannst nicht auf diesen Tarif wechseln';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'Bitte kündige dein aktuelles Abo über $paymentProvider zuerst';
  }

  @override
  String get optionalAsShortAsYouLike =>
      'Bei Bedarf auch so kurz wie du willst...';

  @override
  String get send => 'Absenden';

  @override
  String get askCancelReason =>
      'Dein Abonnement wurde gekündigt. Möchtest du uns den Grund mitteilen?';

  @override
  String get thankYouForSubscribing => 'Danke fürs Abonnieren!';

  @override
  String get yourPurchaseWasSuccessful => 'Dein Einkauf war erfolgreich';

  @override
  String get yourPlanWasSuccessfullyUpgraded =>
      'Dein Abo wurde erfolgreich hochgestuft';

  @override
  String get yourPlanWasSuccessfullyDowngraded =>
      'Dein Tarif wurde erfolgreich heruntergestuft';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully =>
      'Dein Abonnement wurde erfolgreich aktualisiert.';

  @override
  String get googlePlayId => 'Google Play ID';

  @override
  String get appleId => 'Apple ID';

  @override
  String get playstoreSubscription => 'PlayStore Abo';

  @override
  String get appstoreSubscription => 'AppStore Abo';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return 'Dein $id ist bereits mit einem anderen Ente-Konto verknüpft.\nWenn du deine $id mit diesem Konto verwenden möchtest, kontaktiere bitte unseren Support';
  }

  @override
  String get visitWebToManage =>
      'Bitte rufe \"web.ente.io\" auf, um dein Abo zu verwalten';

  @override
  String get couldNotUpdateSubscription =>
      'Abo konnte nicht aktualisiert werden';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      'Bitte kontaktieren Sie uns über support@ente.io wo wir Ihnen gerne weiterhelfen.';

  @override
  String get paymentFailed => 'Zahlung fehlgeschlagen';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return 'Bitte kontaktiere den Support von $providerName, falls etwas abgebucht wurde';
  }

  @override
  String get continueOnFreeTrial => 'Mit kostenloser Testversion fortfahren';

  @override
  String get areYouSureYouWantToExit =>
      'Möchtest du Vorgang wirklich abbrechen?';

  @override
  String get thankYou => 'Vielen Dank';

  @override
  String get failedToVerifyPaymentStatus =>
      'Überprüfung des Zahlungsstatus fehlgeschlagen';

  @override
  String get pleaseWaitForSometimeBeforeRetrying =>
      'Bitte warte kurz, bevor du es erneut versuchst';

  @override
  String get paymentFailedMessage =>
      'Leider ist deine Zahlung fehlgeschlagen. Wende dich an unseren Support und wir helfen dir weiter!';

  @override
  String get youAreOnAFamilyPlan => 'Du bist im Familien-Tarif!';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'Bitte kontaktiere <green>$familyAdminEmail</green> um dein Abo zu verwalten';
  }

  @override
  String get leaveFamily => 'Familienabo verlassen';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily =>
      'Bist du sicher, dass du den Familien-Tarif verlassen möchtest?';

  @override
  String get leave => 'Verlassen';

  @override
  String get rateTheApp => 'App bewerten';

  @override
  String get startBackup => 'Sicherung starten';

  @override
  String get noPhotosAreBeingBackedUpRightNow =>
      'Momentan werden keine Fotos gesichert';

  @override
  String get preserveMore => 'Mehr Daten sichern';

  @override
  String get grantFullAccessPrompt =>
      'Bitte gewähre Zugang zu allen Fotos in der Einstellungen App';

  @override
  String get allowPermTitle => 'Zugriff auf Fotos erlauben';

  @override
  String get allowPermBody =>
      'Bitte erlaube den Zugriff auf Deine Fotos in den Einstellungen, damit Ente sie anzeigen und sichern kann.';

  @override
  String get openSettings => 'Öffne Einstellungen';

  @override
  String get selectMorePhotos => 'Mehr Fotos auswählen';

  @override
  String get existingUser => 'Existierender Benutzer';

  @override
  String get privateBackups => 'Private Sicherungen';

  @override
  String get forYourMemories => 'Als Erinnerung';

  @override
  String get endtoendEncryptedByDefault =>
      'Automatisch Ende-zu-Ende-verschlüsselt';

  @override
  String get safelyStored => 'Gesichert';

  @override
  String get atAFalloutShelter => 'in einem ehemaligen Luftschutzbunker';

  @override
  String get designedToOutlive => 'Entwickelt um zu bewahren';

  @override
  String get available => 'Verfügbar';

  @override
  String get everywhere => 'überall';

  @override
  String get androidIosWebDesktop => 'Android, iOS, Web, Desktop';

  @override
  String get mobileWebDesktop => 'Mobil, Web, Desktop';

  @override
  String get newToEnte => 'Neu bei Ente';

  @override
  String get pleaseLoginAgain => 'Bitte logge dich erneut ein';

  @override
  String get autoLogoutMessage =>
      'Du wurdest aufgrund technischer Störungen abgemeldet. Wir entschuldigen uns für die Unannehmlichkeiten.';

  @override
  String get yourSubscriptionHasExpired => 'Dein Abonnement ist abgelaufen';

  @override
  String get storageLimitExceeded => 'Speichergrenze überschritten';

  @override
  String get upgrade => 'Upgrade';

  @override
  String get raiseTicket => 'Ticket erstellen';

  @override
  String get backupFailed => 'Sicherung fehlgeschlagen';

  @override
  String get sorryBackupFailedDesc =>
      'Leider konnten wir diese Datei momentan nicht sichern, wir werden es später erneut versuchen.';

  @override
  String get couldNotBackUpTryLater =>
      'Deine Daten konnten nicht gesichert werden.\nWir versuchen es später erneut.';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      'Ente kann Dateien nur verschlüsseln und sichern, wenn du den Zugriff darauf gewährst';

  @override
  String get pleaseGrantPermissions =>
      'Bitte erteile die nötigen Berechtigungen';

  @override
  String get grantPermission => 'Zugriff gewähren';

  @override
  String get privateSharing => 'Privates Teilen';

  @override
  String get shareOnlyWithThePeopleYouWant => 'Teile mit ausgewählten Personen';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      'Verwende öffentliche Links für Personen, die kein Ente-Konto haben';

  @override
  String get allowPeopleToAddPhotos =>
      'Erlaube anderen das Hinzufügen von Fotos';

  @override
  String get shareAnAlbumNow => 'Teile jetzt ein Album';

  @override
  String get collectEventPhotos => 'Gemeinsam Event-Fotos sammeln';

  @override
  String get sessionExpired => 'Sitzung abgelaufen';

  @override
  String get loggingOut => 'Abmeldung...';

  @override
  String get onDevice => 'Auf dem Gerät';

  @override
  String get onEnte => 'Auf <branding>ente</branding>';

  @override
  String get name => 'Name';

  @override
  String get newest => 'Zuletzt';

  @override
  String get lastUpdated => 'Zuletzt aktualisiert';

  @override
  String get deleteEmptyAlbums => 'Leere Alben löschen';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => 'Leere Alben löschen?';

  @override
  String get deleteAlbumsDialogBody =>
      'Damit werden alle leeren Alben gelöscht. Dies ist nützlich, wenn du das Durcheinander in deiner Albenliste verringern möchtest.';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return 'Lösche $currentlyDeleting / $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return 'Verarbeite $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => 'Dauerhaft löschen';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou =>
      'Sie können nur Links für Dateien erstellen, die Ihnen gehören';

  @override
  String get publicLinkCreated => 'Öffentlicher Link erstellt';

  @override
  String get youCanManageYourLinksInTheShareTab =>
      'Du kannst deine Links im \"Teilen\"-Tab verwalten.';

  @override
  String get linkCopiedToClipboard => 'Link in Zwischenablage kopiert';

  @override
  String get restore => 'Wiederherstellen';

  @override
  String get moveToAlbum => 'Zum Album verschieben';

  @override
  String get unhide => 'Einblenden';

  @override
  String get unarchive => 'Dearchivieren';

  @override
  String get favorite => 'Favorit';

  @override
  String get removeFromFavorite => 'Aus Favoriten entfernen';

  @override
  String get shareLink => 'Link teilen';

  @override
  String get createCollage => 'Collage erstellen';

  @override
  String get saveCollage => 'Collage speichern';

  @override
  String get collageSaved => 'Collage in Galerie gespeichert';

  @override
  String get collageLayout => 'Layout';

  @override
  String get addToEnte => 'Zu Ente hinzufügen';

  @override
  String get addToAlbum => 'Zum Album hinzufügen';

  @override
  String get delete => 'Löschen';

  @override
  String get hide => 'Ausblenden';

  @override
  String get share => 'Teilen';

  @override
  String get unhideToAlbum => 'Im Album anzeigen';

  @override
  String get restoreToAlbum => 'Album wiederherstellen';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Elemente verschieben',
      one: 'Element verschieben',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Elemente hinzufügen',
      one: 'Element hinzufügen',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'Album erstellen oder auswählen';

  @override
  String get selectAlbum => 'Album auswählen';

  @override
  String get searchByAlbumNameHint => 'Name des Albums';

  @override
  String get albumTitle => 'Albumtitel';

  @override
  String get enterAlbumName => 'Albumname eingeben';

  @override
  String get restoringFiles => 'Dateien werden wiederhergestellt...';

  @override
  String get movingFilesToAlbum => 'Verschiebe Dateien in Album...';

  @override
  String get unhidingFilesToAlbum => 'Dateien im Album anzeigen';

  @override
  String get canNotUploadToAlbumsOwnedByOthers =>
      'Kann nicht auf Alben anderer Personen hochladen';

  @override
  String get uploadingFilesToAlbum => 'Dateien werden ins Album hochgeladen...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return 'Erfolgreich zu  $albumName hinzugefügt';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return 'Erfolgreich zu $albumName hinzugefügt';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'Dieses Album hat bereits einen kollaborativen Link';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return 'Kollaborativer Link für $albumName erstellt';
  }

  @override
  String get askYourLovedOnesToShare => 'Bitte deine Liebsten ums Teilen';

  @override
  String get invite => 'Einladen';

  @override
  String get shareYourFirstAlbum => 'Teile dein erstes Album';

  @override
  String sharedWith({required Object emailIDs}) {
    return 'Geteilt mit $emailIDs';
  }

  @override
  String get sharedWithMe => 'Mit mir geteilt';

  @override
  String get sharedByMe => 'Von mir geteilt';

  @override
  String get doubleYourStorage => 'Speicherplatz verdoppeln';

  @override
  String get referFriendsAnd2xYourPlan =>
      'Begeistere Freunde für uns und verdopple deinen Speicher';

  @override
  String get shareAlbumHint =>
      'Öffne ein Album und tippe auf den Teilen-Button oben rechts, um zu teilen.';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      'Elemente zeigen die Anzahl der Tage bis zum dauerhaften Löschen an';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Tage',
      one: '1 Tag',
      zero: 'Demnächst',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => 'Alle löschen';

  @override
  String get renameAlbum => 'Album umbenennen';

  @override
  String get convertToAlbum => 'Konvertiere zum Album';

  @override
  String get setCover => 'Titelbild festlegen';

  @override
  String get sortAlbumsBy => 'Sortieren nach';

  @override
  String get sortNewestFirst => 'Neueste zuerst';

  @override
  String get sortOldestFirst => 'Älteste zuerst';

  @override
  String get rename => 'Umbenennen';

  @override
  String get leaveSharedAlbum => 'Geteiltes Album verlassen?';

  @override
  String get leaveAlbum => 'Album verlassen';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'Von dir hinzugefügte Fotos werden vom Album entfernt';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted =>
      'Du hast keine Dateien in diesem Album, die gelöscht werden können';

  @override
  String get youDontHaveAnyArchivedItems =>
      'Du hast keine archivierten Elemente.';

  @override
  String get ignoredFolderUploadReason =>
      'Ein paar Dateien in diesem Album werden nicht hochgeladen, weil sie in der Vergangenheit schonmal aus Ente gelöscht wurden.';

  @override
  String get resetIgnoredFiles => 'Ignorierte Dateien zurücksetzen';

  @override
  String get deviceFilesAutoUploading =>
      'Dateien, die zu diesem Album hinzugefügt werden, werden automatisch zu Ente hochgeladen.';

  @override
  String get turnOnBackupForAutoUpload =>
      'Aktiviere die Sicherung, um neue Dateien in diesem Ordner automatisch zu Ente hochzuladen.';

  @override
  String get noHiddenPhotosOrVideos => 'Keine versteckten Fotos oder Videos';

  @override
  String get toHideAPhotoOrVideo => 'Foto oder Video verstecken';

  @override
  String get openTheItem => '• Element öffnen';

  @override
  String get clickOnTheOverflowMenu => '• Klicken Sie auf das Überlaufmenü';

  @override
  String get click => '• Klick';

  @override
  String get nothingToSeeHere => 'Hier gibt es nichts zu sehen! 👀';

  @override
  String get unarchiveAlbum => 'Album dearchivieren';

  @override
  String get archiveAlbum => 'Album archivieren';

  @override
  String get calculating => 'Wird berechnet...';

  @override
  String get pleaseWaitDeletingAlbum => 'Bitte warten, Album wird gelöscht';

  @override
  String get searchByExamples =>
      '• Albumnamen (z.B. \"Kamera\")\n• Dateitypen (z.B. \"Videos\", \".gif\")\n• Jahre und Monate (z.B. \"2022\", \"Januar\")\n• Feiertage (z.B. \"Weihnachten\")\n• Fotobeschreibungen (z.B. \"#fun\")';

  @override
  String get youCanTrySearchingForADifferentQuery =>
      'Sie können versuchen, nach einer anderen Abfrage suchen.';

  @override
  String get noResultsFound => 'Keine Ergebnisse gefunden';

  @override
  String addedBy({required Object emailOrName}) {
    return 'Von $emailOrName hinzugefügt';
  }

  @override
  String get loadingExifData => 'Lade Exif-Daten...';

  @override
  String get viewAllExifData => 'Alle Exif-Daten anzeigen';

  @override
  String get noExifData => 'Keine Exif-Daten';

  @override
  String get thisImageHasNoExifData => 'Dieses Bild hat keine Exif-Daten';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => 'Keine Ergebnisse';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'Wir unterstützen keine Bearbeitung von Fotos und Alben, die du noch nicht besitzt';

  @override
  String get failedToFetchOriginalForEdit =>
      'Fehler beim Abrufen des Originals zur Bearbeitung';

  @override
  String get close => 'Schließen';

  @override
  String get setAs => 'Festlegen als';

  @override
  String get fileSavedToGallery => 'Datei in Galerie gespeichert';

  @override
  String get filesSavedToGallery => 'Dateien in Galerie gespeichert';

  @override
  String get fileFailedToSaveToGallery =>
      'Fehler beim Speichern der Datei in der Galerie';

  @override
  String get download => 'Herunterladen';

  @override
  String get pressAndHoldToPlayVideo => 'Gedrückt halten, um Video abzuspielen';

  @override
  String get pressAndHoldToPlayVideoDetailed =>
      'Drücke und halte aufs Foto gedrückt um Video abzuspielen';

  @override
  String get downloadFailed => 'Herunterladen fehlgeschlagen';

  @override
  String get deduplicateFiles => 'Dateien duplizieren';

  @override
  String get deselectAll => 'Alle abwählen';

  @override
  String get reviewDeduplicateItems =>
      'Bitte überprüfe und lösche die Elemente, die du für Duplikate hältst.';

  @override
  String get clubByCaptureTime => 'Nach Aufnahmezeit gruppieren';

  @override
  String get clubByFileName => 'Nach Dateiname gruppieren';

  @override
  String get count => 'Anzahl';

  @override
  String get totalSize => 'Gesamtgröße';

  @override
  String get longpressOnAnItemToViewInFullscreen =>
      'Drücken Sie lange auf ein Element, um es im Vollbildmodus anzuzeigen';

  @override
  String get decryptingVideo => 'Entschlüssele Video …';

  @override
  String get authToViewYourMemories =>
      'Bitte authentifizieren, um deine Erinnerungsstücke anzusehen';

  @override
  String get unlock => 'Jetzt freischalten';

  @override
  String get freeUpSpace => 'Speicherplatz freigeben';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other:
          'Sie können vom Gerät gelöscht werden, um $formattedSize freizugeben',
      one: 'Es kann vom Gerät gelöscht werden, um $formattedSize freizugeben',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber Dateien',
      one: '1 Datei',
    );
    return '$_temp0 in diesem Album wurde(n) sicher gespeichert';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber Dateien',
      one: '1 Datei',
    );
    return '$_temp0 auf diesem Gerät wurde(n) sicher gespeichert';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'auf sie',
      one: 'darauf',
    );
    return 'Du hast $_temp0 weiterhin Zugriff, solange du ein aktives Abo hast';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return '$sizeInMBorGB freigeben';
  }

  @override
  String get thisEmailIsAlreadyInUse =>
      'Diese E-Mail-Adresse wird bereits verwendet';

  @override
  String get incorrectCode => 'Falscher Code';

  @override
  String get authenticationFailedPleaseTryAgain =>
      'Authentifizierung fehlgeschlagen, versuchen Sie es bitte erneut';

  @override
  String get verificationFailedPleaseTryAgain =>
      'Verifizierung fehlgeschlagen, bitte versuchen Sie es erneut';

  @override
  String get authenticating => 'Authentifiziere …';

  @override
  String get authenticationSuccessful => 'Authentifizierung erfogreich!';

  @override
  String get incorrectRecoveryKey => 'Falscher Wiederherstellungs-Schlüssel';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect =>
      'Der eingegebene Schlüssel ist ungültig';

  @override
  String get twofactorAuthenticationSuccessfullyReset =>
      'Zwei-Faktor-Authentifizierung (2FA) erfolgreich zurückgesetzt';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered =>
      'Bitte bestätigen Sie den eingegebenen Code';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      'Bitte wenden Sie sich an den Support, falls das Problem weiterhin besteht';

  @override
  String get twofactorAuthenticationHasBeenDisabled =>
      'Zwei-Faktor-Authentifizierung (2FA) wurde deaktiviert';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect =>
      'Leider ist der eingegebene Code falsch';

  @override
  String get yourVerificationCodeHasExpired =>
      'Ihr Bestätigungscode ist abgelaufen';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'E-Mail-Adresse geändert zu $newEmail';
  }

  @override
  String get verifying => 'Verifiziere …';

  @override
  String get disablingTwofactorAuthentication =>
      'Zwei-Faktor-Authentifizierung (2FA) wird deaktiviert...';

  @override
  String get allMemoriesPreserved => 'Alle Erinnerungsstücke gesichert';

  @override
  String get loadingGallery => 'Lade Galerie …';

  @override
  String get syncing => 'Synchronisiere …';

  @override
  String get encryptingBackup => 'Verschlüssele Sicherung …';

  @override
  String get syncStopped => 'Synchronisierung angehalten';

  @override
  String syncProgress({required String completed, required String total}) {
    return '$completed/$total Erinnerungsstücke gesichert';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return 'Sichere $count Erinnerungsstücke...';
  }

  @override
  String get uploadingSingleMemory => 'Sichere ein Erinnerungsstück...';

  @override
  String get archiving => 'Archiviere …';

  @override
  String get unarchiving => 'Dearchiviere …';

  @override
  String get successfullyArchived => 'Erfolgreich archiviert';

  @override
  String get successfullyUnarchived => 'Erfolgreich dearchiviert';

  @override
  String get renameFile => 'Datei umbenennen';

  @override
  String get enterFileName => 'Dateinamen eingeben';

  @override
  String get filesDeleted => 'Dateien gelöscht';

  @override
  String get selectedFilesAreNotOnEnte =>
      'Ausgewählte Dateien sind nicht auf Ente';

  @override
  String get thisActionCannotBeUndone =>
      'Diese Aktion kann nicht rückgängig gemacht werden';

  @override
  String get emptyTrash => 'Papierkorb leeren?';

  @override
  String get permDeleteWarning =>
      'Alle Elemente im Papierkorb werden dauerhaft gelöscht\n\nDiese Aktion kann nicht rückgängig gemacht werden';

  @override
  String get empty => 'Leeren';

  @override
  String get couldNotFreeUpSpace => 'Konnte Speicherplatz nicht freigeben';

  @override
  String get permanentlyDeleteFromDevice => 'Endgültig vom Gerät löschen?';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      'Einige der Dateien, die Sie löschen möchten, sind nur auf Ihrem Gerät verfügbar und können nicht wiederhergestellt werden, wenn sie gelöscht wurden';

  @override
  String get theyWillBeDeletedFromAllAlbums =>
      'Sie werden aus allen Alben gelöscht.';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'Einige Elemente sind sowohl auf Ente als auch auf deinem Gerät.';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      'Ausgewählte Elemente werden aus allen Alben gelöscht und in den Papierkorb verschoben.';

  @override
  String get theseItemsWillBeDeletedFromYourDevice =>
      'Diese Elemente werden von deinem Gerät gelöscht.';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      'Etwas ist schiefgelaufen. Bitte versuche es später noch einmal. Sollte der Fehler weiter bestehen, kontaktiere unser Supportteam.';

  @override
  String get error => 'Fehler';

  @override
  String get tempErrorContactSupportIfPersists =>
      'Etwas ist schiefgelaufen. Bitte versuche es später noch einmal. Sollte der Fehler weiter bestehen, kontaktiere unser Supportteam.';

  @override
  String get networkHostLookUpErr =>
      'Ente ist im Moment nicht erreichbar. Bitte überprüfen Sie Ihre Netzwerkeinstellungen. Sollte das Problem bestehen bleiben, wenden Sie sich bitte an den Support.';

  @override
  String get networkConnectionRefusedErr =>
      'Ente ist im Moment nicht erreichbar. Bitte versuchen Sie es später erneut. Sollte das Problem bestehen bleiben, wenden Sie sich bitte an den Support.';

  @override
  String get cachedData => 'Daten im Cache';

  @override
  String get clearCaches => 'Cache löschen';

  @override
  String get remoteImages => 'Grafiken aus externen Quellen';

  @override
  String get remoteVideos => 'Videos aus externen Quellen';

  @override
  String get remoteThumbnails => 'Vorschaubilder aus externen Quellen';

  @override
  String get pendingSync => 'Synchronisation anstehend';

  @override
  String get localGallery => 'Lokale Galerie';

  @override
  String get todaysLogs => 'Heutiges Protokoll';

  @override
  String get viewLogs => 'Protokolle anzeigen';

  @override
  String get logsDialogBody =>
      'Dies wird über Logs gesendet, um uns zu helfen, Ihr Problem zu beheben. Bitte beachten Sie, dass Dateinamen aufgenommen werden, um Probleme mit bestimmten Dateien zu beheben.';

  @override
  String get preparingLogs => 'Protokolle werden vorbereitet...';

  @override
  String get emailYourLogs => 'Protokolle per E-Mail senden';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'Bitte sende die Protokolle an $toEmail';
  }

  @override
  String get copyEmailAddress => 'E-Mail-Adresse kopieren';

  @override
  String get exportLogs => 'Protokolle exportieren';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return 'Bitte sende uns eine E-Mail an $toEmail';
  }

  @override
  String get dismiss => 'Verwerfen';

  @override
  String get didYouKnow => 'Schon gewusst?';

  @override
  String get loadingMessage => 'Fotos werden geladen...';

  @override
  String get loadMessage1 =>
      'Du kannst dein Abonnement mit deiner Familie teilen';

  @override
  String get loadMessage2 =>
      'Wir haben bereits über 200 Millionen Erinnerungen bewahrt';

  @override
  String get loadMessage3 =>
      'Wir behalten 3 Kopien Ihrer Daten, eine in einem unterirdischen Schutzbunker';

  @override
  String get loadMessage4 => 'Alle unsere Apps sind Open-Source';

  @override
  String get loadMessage5 =>
      'Unser Quellcode und unsere Kryptografie wurden extern geprüft';

  @override
  String get loadMessage6 =>
      'Du kannst Links zu deinen Alben mit deinen Geliebten teilen';

  @override
  String get loadMessage7 =>
      'Unsere mobilen Apps laufen im Hintergrund, um neue Fotos zu verschlüsseln und zu sichern';

  @override
  String get loadMessage8 => 'web.ente.io hat einen Spitzen-Uploader';

  @override
  String get loadMessage9 =>
      'Wir verwenden Xchacha20Poly1305, um Ihre Daten sicher zu verschlüsseln';

  @override
  String get photoDescriptions => 'Foto Beschreibungen';

  @override
  String get fileTypesAndNames => 'Dateitypen und -namen';

  @override
  String get location => 'Standort';

  @override
  String get moments => 'Momente';

  @override
  String get searchFaceEmptySection =>
      'Personen werden hier angezeigt, sobald die Indizierung abgeschlossen ist';

  @override
  String get searchDatesEmptySection => 'Suche nach Datum, Monat oder Jahr';

  @override
  String get searchLocationEmptySection =>
      'Gruppiere Fotos, die innerhalb des Radius eines bestimmten Fotos aufgenommen wurden';

  @override
  String get searchPeopleEmptySection =>
      'Laden Sie Personen ein, damit Sie geteilte Fotos hier einsehen können';

  @override
  String get searchAlbumsEmptySection => 'Alben';

  @override
  String get searchFileTypesAndNamesEmptySection => 'Dateitypen und -namen';

  @override
  String get searchCaptionEmptySection =>
      'Füge Beschreibungen wie \"#trip\" in der Fotoinfo hinzu um diese schnell hier wiederzufinden';

  @override
  String get language => 'Sprache';

  @override
  String get selectLanguage => 'Sprache auswählen';

  @override
  String get locationName => 'Standortname';

  @override
  String get addLocation => 'Ort hinzufügen';

  @override
  String get groupNearbyPhotos => 'Fotos in der Nähe gruppieren';

  @override
  String get kiloMeterUnit => 'km';

  @override
  String get addLocationButton => 'Hinzufügen';

  @override
  String get radius => 'Umkreis';

  @override
  String get locationTagFeatureDescription =>
      'Ein Standort-Tag gruppiert alle Fotos, die in einem Radius eines Fotos aufgenommen wurden';

  @override
  String get galleryMemoryLimitInfo =>
      'Bis zu 1000 Erinnerungsstücke angezeigt in der Galerie';

  @override
  String get save => 'Speichern';

  @override
  String get centerPoint => 'Mittelpunkt';

  @override
  String get pickCenterPoint => 'Mittelpunkt auswählen';

  @override
  String get useSelectedPhoto => 'Ausgewähltes Foto verwenden';

  @override
  String get resetToDefault => 'Standardwerte zurücksetzen';

  @override
  String get edit => 'Bearbeiten';

  @override
  String get deleteLocation => 'Standort löschen';

  @override
  String get rotateLeft => 'Nach links drehen';

  @override
  String get flip => 'Spiegeln';

  @override
  String get rotateRight => 'Nach rechts drehen';

  @override
  String get saveCopy => 'Kopie speichern';

  @override
  String get light => 'Hell';

  @override
  String get color => 'Farbe';

  @override
  String get yesDiscardChanges => 'Ja, Änderungen verwerfen';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade =>
      'Möchtest du deine Änderungen verwerfen?';

  @override
  String get saving => 'Speichern...';

  @override
  String get editsSaved => 'Änderungen gespeichert';

  @override
  String get oopsCouldNotSaveEdits =>
      'Hoppla, die Änderungen konnten nicht gespeichert werden';

  @override
  String get distanceInKMUnit => 'km';

  @override
  String get dayToday => 'Heute';

  @override
  String get dayYesterday => 'Gestern';

  @override
  String get storage => 'Speicherplatz';

  @override
  String get usedSpace => 'Belegter Speicherplatz';

  @override
  String get storageBreakupFamily => 'Familie';

  @override
  String get storageBreakupYou => 'Sie';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return '$usedAmount $usedStorageUnit von $totalAmount $totalStorageUnit verwendet';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return '$freeAmount $storageUnit frei';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'Version: $versionValue';
  }

  @override
  String get verifyIDLabel => 'Überprüfen';

  @override
  String get fileInfoAddDescHint => 'Beschreibung hinzufügen …';

  @override
  String get editLocationTagTitle => 'Standort bearbeiten';

  @override
  String get setLabel => 'Festlegen';

  @override
  String get setRadius => 'Radius festlegen';

  @override
  String get familyPlanPortalTitle => 'Familie';

  @override
  String get familyPlanOverview =>
      'Füge kostenlos 5 Familienmitglieder zu deinem bestehenden Abo hinzu.\n\nJedes Mitglied bekommt seinen eigenen privaten Bereich und kann die Dateien der anderen nur sehen, wenn sie geteilt werden.\n\nFamilien-Abos stehen Nutzern mit einem Bezahltarif zur Verfügung.\n\nMelde dich jetzt an, um loszulegen!';

  @override
  String get androidBiometricHint => 'Identität verifizieren';

  @override
  String get androidBiometricNotRecognized =>
      'Nicht erkannt. Versuchen Sie es erneut.';

  @override
  String get androidBiometricSuccess => 'Erfolgreich';

  @override
  String get androidCancelButton => 'Abbrechen';

  @override
  String get androidSignInTitle => 'Authentifizierung erforderlich';

  @override
  String get androidBiometricRequiredTitle => 'Biometrie erforderlich';

  @override
  String get androidDeviceCredentialsRequiredTitle =>
      'Geräteanmeldeinformationen erforderlich';

  @override
  String get androidDeviceCredentialsSetupDescription =>
      'Geräteanmeldeinformationen erforderlich';

  @override
  String get goToSettings => 'Zu den Einstellungen';

  @override
  String get androidGoToSettingsDescription =>
      'Auf Ihrem Gerät ist keine biometrische Authentifizierung eingerichtet. Gehen Sie „Einstellungen“ > „Sicherheit“, um die biometrische Authentifizierung hinzuzufügen.';

  @override
  String get iOSLockOut =>
      'Die biometrische Authentifizierung ist deaktiviert. Bitte sperren und entsperren Sie Ihren Bildschirm, um sie zu aktivieren.';

  @override
  String get iOSGoToSettingsDescription =>
      'Auf Ihrem Gerät ist keine biometrische Authentifizierung eingerichtet. Bitte aktivieren Sie entweder Touch ID oder Face ID auf Ihrem Telefon.';

  @override
  String get iOSOkButton => 'OK';

  @override
  String get openstreetmapContributors => 'OpenStreetMap-Beitragende';

  @override
  String get hostedAtOsmFrance => 'Gehostet bei OSM France';

  @override
  String get map => 'Karte';

  @override
  String get maps => 'Karten';

  @override
  String get mapsPrivacyNotice =>
      'Ungefähre Koordinaten werden an datenschutzbewusste Dritte wie OpenStreetMap gesendet, um die Karte und den Ort anzuzeigen.';

  @override
  String get enableMaps => 'Karten aktivieren';

  @override
  String get quickLinks => 'Quick Links';

  @override
  String get selectItemsToAdd => 'Elemente zum Hinzufügen auswählen';

  @override
  String get addSelected => 'Auswahl hinzufügen';

  @override
  String get addFromDevice => 'Vom Gerät hinzufügen';

  @override
  String get addPhotos => 'Fotos hinzufügen';

  @override
  String get noPhotosFoundHere => 'Keine Fotos gefunden';

  @override
  String get zoomOutToSeePhotos => 'Verkleinern, um Fotos zu sehen';

  @override
  String get noImagesWithLocation => 'Keine Bilder mit Standort';

  @override
  String get unpinAlbum => 'Album lösen';

  @override
  String get pinAlbum => 'Album anheften';

  @override
  String get pin => 'Anheften';

  @override
  String get pinPerson => 'Person anheften';

  @override
  String get pinToTop => 'Oben anheften';

  @override
  String get unpin => 'Lösen';

  @override
  String get unpinPerson => 'Person lösen';

  @override
  String get visibility => 'Sichtbarkeit';

  @override
  String get hideFromMemories => 'Aus Erinnerungen ausblenden';

  @override
  String get showInMemories => 'In Erinnerungen anzeigen';

  @override
  String get create => 'Erstellen';

  @override
  String get viewAll => 'Alle anzeigen';

  @override
  String get nothingSharedWithYouYet => 'Noch nichts mit Dir geteilt';

  @override
  String get noAlbumsSharedByYouYet => 'Noch keine Alben von dir geteilt';

  @override
  String get sharedWithYou => 'Mit dir geteilt';

  @override
  String get sharedByYou => 'Von dir geteilt';

  @override
  String get inviteYourFriendsToEnte => 'Lade deine Freunde zu Ente ein';

  @override
  String get failedToDownloadVideo => 'Herunterladen des Videos fehlgeschlagen';

  @override
  String get hiding => 'Verstecken...';

  @override
  String get unhiding => 'Einblenden...';

  @override
  String get successfullyHid => 'Erfolgreich versteckt';

  @override
  String get successfullyUnhid => 'Erfolgreich eingeblendet';

  @override
  String get crashReporting => 'Absturzbericht';

  @override
  String get resumableUploads => 'Fortsetzbares Hochladen';

  @override
  String get addToHiddenAlbum => 'Zum versteckten Album hinzufügen';

  @override
  String get moveToHiddenAlbum => 'Zu verstecktem Album verschieben';

  @override
  String get fileTypes => 'Dateitypen';

  @override
  String get deleteConfirmDialogBody =>
      'Dieses Konto ist mit anderen Ente-Apps verknüpft, falls du welche verwendest. Deine hochgeladenen Daten werden in allen Ente-Apps zur Löschung vorgemerkt und dein Konto wird endgültig gelöscht.';

  @override
  String get hearUsWhereTitle => 'Wie hast du von Ente erfahren? (optional)';

  @override
  String get hearUsExplanation =>
      'Wir tracken keine App-Installationen. Es würde uns jedoch helfen, wenn du uns mitteilst, wie du von uns erfahren hast!';

  @override
  String get viewAddOnButton => 'Zeige Add-ons';

  @override
  String get addOns => 'Add-ons';

  @override
  String get addOnPageSubtitle => 'Details der Add-ons';

  @override
  String get yourMap => 'Deine Karte';

  @override
  String get modifyYourQueryOrTrySearchingFor =>
      'Ändere deine Suchanfrage oder suche nach';

  @override
  String get blackFridaySale => 'Black-Friday-Aktion';

  @override
  String get upto50OffUntil4thDec => 'Bis zu 50% Rabatt bis zum 4. Dezember.';

  @override
  String get photos => 'Fotos';

  @override
  String get videos => 'Videos';

  @override
  String get livePhotos => 'Live-Fotos';

  @override
  String get searchHint1 => 'Schnell auf dem Gerät suchen';

  @override
  String get searchHint2 => 'Fotodaten, Beschreibungen';

  @override
  String get searchHint3 => 'Alben, Dateinamen und -typen';

  @override
  String get searchHint4 => 'Ort';

  @override
  String get searchHint5 => 'Demnächst: Gesichter & magische Suche ✨';

  @override
  String get addYourPhotosNow => 'Füge deine Foto jetzt hinzu';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Ergebnisse gefunden',
      one: '$count Ergebnis gefunden',
    );
    return '$_temp0';
  }

  @override
  String get faces => 'Gesichter';

  @override
  String get people => 'Personen';

  @override
  String get contents => 'Inhalte';

  @override
  String get addNew => 'Hinzufügen';

  @override
  String get contacts => 'Kontakte';

  @override
  String get noInternetConnection => 'Keine Internetverbindung';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'Bitte überprüfe deine Internetverbindung und versuche es erneut.';

  @override
  String get signOutFromOtherDevices => 'Von anderen Geräten abmelden';

  @override
  String get signOutOtherBody =>
      'Falls du denkst, dass jemand dein Passwort kennen könnte, kannst du alle anderen Geräte von deinem Account abmelden.';

  @override
  String get signOutOtherDevices => 'Andere Geräte abmelden';

  @override
  String get doNotSignOut => 'Melde dich nicht ab';

  @override
  String get editLocation => 'Standort bearbeiten';

  @override
  String get selectALocation => 'Standort auswählen';

  @override
  String get selectALocationFirst => 'Wähle zuerst einen Standort';

  @override
  String get changeLocationOfSelectedItems =>
      'Standort der gewählten Elemente ändern?';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte =>
      'Edits to location will only be seen within Ente';

  @override
  String get cleanUncategorized => 'Unkategorisiert leeren';

  @override
  String get cleanUncategorizedDescription =>
      'Entferne alle Dateien von \"Unkategorisiert\" die in anderen Alben vorhanden sind';

  @override
  String get waitingForVerification => 'Warte auf Bestätigung...';

  @override
  String get passkey => 'Passkey';

  @override
  String get passkeyAuthTitle => 'Passkey-Verifizierung';

  @override
  String get loginWithTOTP => 'Mit TOTP anmelden';

  @override
  String get passKeyPendingVerification => 'Verifizierung steht noch aus';

  @override
  String get loginSessionExpired => 'Sitzung abgelaufen';

  @override
  String get loginSessionExpiredDetails =>
      'Deine Sitzung ist abgelaufen. Bitte melde Dich erneut an.';

  @override
  String get verifyPasskey => 'Passkey verifizieren';

  @override
  String get playOnTv => 'Album auf dem Fernseher wiedergeben';

  @override
  String get pair => 'Koppeln';

  @override
  String get deviceNotFound => 'Gerät nicht gefunden';

  @override
  String get castInstruction =>
      'Besuche cast.ente.io auf dem Gerät, das du verbinden möchtest.\n\nGib den unten angegebenen Code ein, um das Album auf deinem Fernseher abzuspielen.';

  @override
  String get deviceCodeHint => 'Code eingeben';

  @override
  String get joinDiscord => 'Discord beitreten';

  @override
  String get locations => 'Orte';

  @override
  String get addAName => 'Füge einen Namen hinzu';

  @override
  String get findThemQuickly => 'Finde sie schnell';

  @override
  String get findPeopleByName => 'Finde Personen schnell nach Namen';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Betrachter hinzufügen',
      one: 'Betrachter hinzufügen',
      zero: 'Betrachter hinzufügen',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Bearbeiter hinzufügen',
      one: 'Bearbeiter hinzufügen',
      zero: 'Bearbeiter hinzufügen',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      'Lange auf eine E-Mail drücken, um die Ende-zu-Ende-Verschlüsselung zu überprüfen.';

  @override
  String get developerSettingsWarning =>
      'Bist du sicher, dass du Entwicklereinstellungen bearbeiten willst?';

  @override
  String get developerSettings => 'Entwicklereinstellungen';

  @override
  String get serverEndpoint => 'Server Endpunkt';

  @override
  String get invalidEndpoint => 'Ungültiger Endpunkt';

  @override
  String get invalidEndpointMessage =>
      'Der eingegebene Endpunkt ist ungültig. Gib einen gültigen Endpunkt ein und versuch es nochmal.';

  @override
  String get endpointUpdatedMessage => 'Endpunkt erfolgreich geändert';

  @override
  String customEndpoint({required Object endpoint}) {
    return 'Verbunden mit $endpoint';
  }

  @override
  String get createCollaborativeLink => 'Gemeinschaftlichen Link erstellen';

  @override
  String get search => 'Suche';

  @override
  String get enterPersonName => 'Namen der Person eingeben';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'Diese E-Mail ist bereits verknüpft mit $name.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return '$name zum Entfernen des Links anzeigen';
  }

  @override
  String get enterName => 'Name eingeben';

  @override
  String get savePerson => 'Person speichern';

  @override
  String get editPerson => 'Person bearbeiten';

  @override
  String get mergedPhotos => 'Zusammengeführte Fotos';

  @override
  String get orMergeWithExistingPerson =>
      'Oder mit existierenden zusammenführen';

  @override
  String get enterDateOfBirth => 'Geburtstag (optional)';

  @override
  String get birthday => 'Geburtstag';

  @override
  String get removePersonLabel => 'Personenetikett entfernen';

  @override
  String get removePersonTag => 'Personen-Tag entfernen';

  @override
  String get areYouSureRemoveThisPersonTag =>
      'Möchtest du dieses Personen-Tag wirklich entfernen?';

  @override
  String get autoPairDesc =>
      'Automatisches Verbinden funktioniert nur mit Geräten, die Chromecast unterstützen.';

  @override
  String get manualPairDesc =>
      '\"Mit PIN verbinden\" funktioniert mit jedem Bildschirm, auf dem du dein Album sehen möchtest.';

  @override
  String get connectToDevice => 'Mit Gerät verbinden';

  @override
  String get autoCastDialogBody =>
      'Verfügbare Cast-Geräte werden hier angezeigt.';

  @override
  String get autoCastiOSPermission =>
      'Stelle sicher, dass die Ente-App auf das lokale Netzwerk zugreifen darf. Das kannst du in den Einstellungen unter \"Datenschutz\".';

  @override
  String get noDeviceFound => 'Kein Gerät gefunden';

  @override
  String get stopCastingTitle => 'Übertragung beenden';

  @override
  String get stopCastingBody => 'Möchtest du die Übertragung beenden?';

  @override
  String get castIPMismatchTitle =>
      'Album konnte nicht auf den Bildschirm übertragen werden';

  @override
  String get castIPMismatchBody =>
      'Stelle sicher, dass du im selben Netzwerk bist wie der Fernseher.';

  @override
  String get pairingComplete => 'Verbunden';

  @override
  String get savingEdits => 'Speichere Änderungen...';

  @override
  String get autoPair => 'Automatisch verbinden';

  @override
  String get pairWithPin => 'Mit PIN verbinden';

  @override
  String get faceRecognition => 'Gesichtserkennung';

  @override
  String get foundFaces => 'Gesichter gefunden';

  @override
  String get clusteringProgress => 'Fortschritt beim Clustering';

  @override
  String get trim => 'Schneiden';

  @override
  String get crop => 'Zuschneiden';

  @override
  String get rotate => 'Drehen';

  @override
  String get left => 'Links';

  @override
  String get right => 'Rechts';

  @override
  String get whatsNew => 'Neue Funktionen';

  @override
  String get reviewSuggestions => 'Vorschläge überprüfen';

  @override
  String get review => 'Überprüfen';

  @override
  String get useAsCover => 'Als Titelbild festlegen';

  @override
  String notPersonLabel({required String name}) {
    return 'Nicht $name?';
  }

  @override
  String get enable => 'Aktivieren';

  @override
  String get enabled => 'Aktiviert';

  @override
  String get moreDetails => 'Weitere Details';

  @override
  String get enableMLIndexingDesc =>
      'Ente unterstützt maschinelles Lernen für Gesichtserkennung, magische Suche und andere erweiterte Suchfunktionen auf dem Gerät';

  @override
  String get magicSearchHint =>
      'Die magische Suche erlaubt das Durchsuchen von Fotos nach ihrem Inhalt, z.B. \'Blumen\', \'rotes Auto\', \'Ausweisdokumente\'';

  @override
  String get panorama => 'Panorama';

  @override
  String get reenterPassword => 'Passwort erneut eingeben';

  @override
  String get reenterPin => 'PIN erneut eingeben';

  @override
  String get deviceLock => 'Gerätsperre';

  @override
  String get pinLock => 'PIN-Sperre';

  @override
  String get next => 'Weiter';

  @override
  String get setNewPassword => 'Neues Passwort festlegen';

  @override
  String get enterPin => 'PIN eingeben';

  @override
  String get setNewPin => 'Neue PIN festlegen';

  @override
  String get appLock => 'App-Sperre';

  @override
  String get noSystemLockFound => 'Keine Systemsperre gefunden';

  @override
  String get tapToUnlock => 'Zum Entsperren antippen';

  @override
  String get tooManyIncorrectAttempts => 'Zu viele fehlerhafte Versuche';

  @override
  String get videoInfo => 'Video-Informationen';

  @override
  String get autoLock => 'Automatisches Sperren';

  @override
  String get immediately => 'Sofort';

  @override
  String get autoLockFeatureDescription =>
      'Zeit, nach der die App gesperrt wird, nachdem sie in den Hintergrund verschoben wurde';

  @override
  String get hideContent => 'Inhalte verstecken';

  @override
  String get hideContentDescriptionAndroid =>
      'Versteckt Inhalte der App beim Wechseln zwischen Apps und deaktiviert Screenshots';

  @override
  String get hideContentDescriptionIos =>
      'Versteckt Inhalte der App beim Wechseln zwischen Apps';

  @override
  String get passwordStrengthInfo =>
      'Die Berechnung der Stärke des Passworts basiert auf dessen Länge, den verwendeten Zeichen, und ob es in den 10.000 am häufigsten verwendeten Passwörtern vorkommt';

  @override
  String get noQuickLinksSelected => 'Keine schnellen Links ausgewählt';

  @override
  String get pleaseSelectQuickLinksToRemove =>
      'Bitte wähle die zu entfernenden schnellen Links';

  @override
  String get removePublicLinks => 'Öffentliche Links entfernen';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      'Hiermit werden die öffentlichen Links aller ausgewählten schnellen Links entfernt.';

  @override
  String get guestView => 'Gastansicht';

  @override
  String get guestViewEnablePreSteps =>
      'Bitte richte einen Gerätepasscode oder eine Bildschirmsperre ein, um die Gastansicht zu nutzen.';

  @override
  String get nameTheAlbum => 'Album benennen';

  @override
  String get collectPhotosDescription =>
      'Erstelle einen Link, mit dem deine Freunde Fotos in Originalqualität hochladen können.';

  @override
  String get collect => 'Sammeln';

  @override
  String get appLockDescriptions =>
      'Wähle zwischen dem Standard-Sperrbildschirm deines Gerätes und einem eigenen Sperrbildschirm mit PIN oder Passwort.';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'Um die App-Sperre zu aktivieren, konfiguriere bitte den Gerätepasscode oder die Bildschirmsperre in den Systemeinstellungen.';

  @override
  String get authToViewPasskey =>
      'Bitte authentifizieren, um deinen Passkey zu sehen';

  @override
  String get loopVideoOn => 'Endlosschleife ausschalten';

  @override
  String get loopVideoOff => 'Endlosschleife einschalten';

  @override
  String get localSyncErrorMessage =>
      'Es sieht so aus, als ob etwas schiefgelaufen ist, da die lokale Foto-Synchronisierung länger dauert als erwartet. Bitte kontaktiere unser Support-Team';

  @override
  String get showPerson => 'Person anzeigen';

  @override
  String get sort => 'Sortierung';

  @override
  String get mostRecent => 'Neuste';

  @override
  String get mostRelevant => 'Nach Relevanz';

  @override
  String get loadingYourPhotos => 'Lade deine Fotos...';

  @override
  String processingImport({required Object folderName}) {
    return 'Verarbeite $folderName...';
  }

  @override
  String get personName => 'Name der Person';

  @override
  String get addPerson => 'Add person';

  @override
  String get addToPerson => 'Add to person';

  @override
  String get pleaseNamePersonInPeopleSectionFirst =>
      'Please name a person in the People section first';

  @override
  String get onlyUploadedFilesCanBeAddedToPerson =>
      'Only uploaded files can be added to a person';

  @override
  String get noFacesDetectedTapToAdd => 'No faces detected, tap to add.';

  @override
  String addedFilesToPerson({required int count, required String personName}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count files to $personName',
      one: 'Added 1 file to $personName',
    );
    return '$_temp0';
  }

  @override
  String filesAlreadyLinkedToPerson({
    required int count,
    required String personName,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count files are already linked to $personName',
      one: '1 file is already linked to $personName',
    );
    return '$_temp0';
  }

  @override
  String get addNewPerson => 'Neue Person hinzufügen';

  @override
  String get addNameOrMerge => 'Name hinzufügen oder zusammenführen';

  @override
  String get mergeWithExisting => 'Mit vorhandenem zusammenführen';

  @override
  String get newPerson => 'Neue Person';

  @override
  String get addName => 'Name hinzufügen';

  @override
  String get add => 'Hinzufügen';

  @override
  String extraPhotosFoundFor({required String text}) {
    return 'Zusätzliche Fotos für $text gefunden';
  }

  @override
  String get extraPhotosFound => 'Zusätzliche Fotos gefunden';

  @override
  String get configuration => 'Konfiguration';

  @override
  String get localIndexing => 'Lokale Indizierung';

  @override
  String get processed => 'Verarbeitet';

  @override
  String get resetPerson => 'Entfernen';

  @override
  String get areYouSureYouWantToResetThisPerson =>
      'Bist du sicher, dass du diese Person zurücksetzen möchtest?';

  @override
  String get allPersonGroupingWillReset =>
      'Alle Gruppierungen für diese Person werden zurückgesetzt und du wirst alle Vorschläge für diese Person verlieren';

  @override
  String get yesResetPerson => 'Ja, Person zurücksetzen';

  @override
  String get onlyThem => 'Nur diese';

  @override
  String get checkingModels => 'Prüfe Modelle...';

  @override
  String get enableMachineLearningBanner =>
      'Aktiviere maschinelles Lernen für die magische Suche und Gesichtserkennung';

  @override
  String get searchDiscoverEmptySection =>
      'Bilder werden hier angezeigt, sobald Verarbeitung und Synchronisation abgeschlossen sind';

  @override
  String get searchPersonsEmptySection =>
      'Personen werden hier angezeigt, sobald Verarbeitung und Synchronisierung abgeschlossen sind';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Betrachter hinzugefügt',
      one: 'Einen Betrachter hinzugefügt',
      zero: '0 Betrachter hinzugefügt',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Mitarbeiter hinzugefügt',
      one: '1 Mitarbeiter hinzugefügt',
      zero: '0 Mitarbeiter hinzugefügt',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured =>
      'Das Konto ist bereits konfiguriert.';

  @override
  String get sessionIdMismatch => 'Sitzungs-ID stimmt nicht überein';

  @override
  String get failedToFetchActiveSessions =>
      'Fehler beim Abrufen der aktiven Sitzungen';

  @override
  String get failedToRefreshStripeSubscription =>
      'Abonnement konnte nicht erneuert werden';

  @override
  String get failedToPlayVideo => 'Fehler beim Abspielen des Videos';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return 'Upload wird aufgrund von $ignoreReason ignoriert';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'Der Galerie-Typ $galleryType unterstützt kein Umbenennen';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'Zum Hochladen tippen, Hochladen wird derzeit ignoriert, da $ignoreReason';
  }

  @override
  String get tapToUpload => 'Zum Hochladen antippen';

  @override
  String get info => 'Info';

  @override
  String get addFiles => 'Dateien hinzufügen';

  @override
  String get castAlbum => 'Album übertragen';

  @override
  String get imageNotAnalyzed => 'Bild nicht analysiert';

  @override
  String get noFacesFound => 'Keine Gesichter gefunden';

  @override
  String get fileNotUploadedYet => 'Datei wurde noch nicht hochgeladen';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return 'Keine Vorschläge für $personName';
  }

  @override
  String get month => 'Monat';

  @override
  String get yearShort => 'Jahr';

  @override
  String get currentlyRunning => 'läuft gerade';

  @override
  String get ignored => 'ignoriert';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Fotos',
      one: 'Ein Foto',
      zero: '0 Fotos',
    );
    return '$_temp0';
  }

  @override
  String get file => 'Datei';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'Abschnittslänge stimmt nicht überein: $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'E-Mail-App auswählen';

  @override
  String get selectAllShort => 'Alle';

  @override
  String get selectCoverPhoto => 'Titelbild auswählen';

  @override
  String get newLocation => 'Neuer Ort';

  @override
  String get faceNotClusteredYet =>
      'Gesicht ist noch nicht gruppiert, bitte komm später zurück';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'Der Link, den du aufrufen möchtest, ist abgelaufen.';

  @override
  String get openFile => 'Datei öffnen';

  @override
  String get backupFile => 'Datei sichern';

  @override
  String get openAlbumInBrowser => 'Album im Browser öffnen';

  @override
  String get openAlbumInBrowserTitle =>
      'Bitte nutze die Web-App, um Fotos zu diesem Album hinzuzufügen';

  @override
  String get allow => 'Erlauben';

  @override
  String get allowAppToOpenSharedAlbumLinks =>
      'Erlaube der App, geteilte Album-Links zu öffnen';

  @override
  String get seePublicAlbumLinksInApp =>
      'Öffentliche Album-Links in der App ansehen';

  @override
  String get emergencyContacts => 'Notfallkontakte';

  @override
  String get acceptTrustInvite => 'Einladung annehmen';

  @override
  String get declineTrustInvite => 'Einladung ablehnen';

  @override
  String get removeYourselfAsTrustedContact =>
      'Entferne dich als vertrauenswürdigen Kontakt';

  @override
  String get legacy => 'Digitales Erbe';

  @override
  String get legacyPageDesc =>
      'Das digitale Erbe erlaubt vertrauenswürdigen Kontakten den Zugriff auf dein Konto in deiner Abwesenheit.';

  @override
  String get legacyPageDesc2 =>
      'Vertrauenswürdige Kontakte können eine Kontowiederherstellung einleiten und, wenn dies nicht innerhalb von 30 Tagen blockiert wird, dein Passwort und den Kontozugriff zurücksetzen.';

  @override
  String get legacyAccounts => 'Digital geerbte Konten';

  @override
  String get trustedContacts => 'Vertrauenswürdige Kontakte';

  @override
  String get addTrustedContact => 'Vertrauenswürdigen Kontakt hinzufügen';

  @override
  String get removeInvite => 'Einladung entfernen';

  @override
  String get recoveryWarning =>
      'Ein vertrauenswürdiger Kontakt versucht, auf dein Konto zuzugreifen';

  @override
  String get rejectRecovery => 'Wiederherstellung ablehnen';

  @override
  String get recoveryInitiated => 'Wiederherstellung gestartet';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return 'Du kannst nach $days Tagen auf das Konto zugreifen. Eine Benachrichtigung wird an $email versendet.';
  }

  @override
  String get cancelAccountRecovery => 'Wiederherstellung abbrechen';

  @override
  String get recoveryAccount => 'Konto wiederherstellen';

  @override
  String get cancelAccountRecoveryBody =>
      'Bist du sicher, dass du die Wiederherstellung abbrechen möchtest?';

  @override
  String get startAccountRecoveryTitle => 'Wiederherstellung starten';

  @override
  String get whyAddTrustContact =>
      'Ein vertrauenswürdiger Kontakt kann helfen, deine Daten wiederherzustellen.';

  @override
  String recoveryReady({required String email}) {
    return 'Du kannst jetzt das Konto von $email wiederherstellen, indem du ein neues Passwort setzt.';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email versucht, dein Konto wiederherzustellen.';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return 'Du wurdest von $email eingeladen, ein Kontakt für das digitale Erbe zu werden.';
  }

  @override
  String get warning => 'Warnung';

  @override
  String get proceed => 'Fortfahren';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return 'Du bist dabei, $email als vertrauenswürdigen Kontakt hinzuzufügen. Die Person wird in der Lage sein, dein Konto wiederherzustellen, wenn du für $numOfDays Tage abwesend bist.';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email hat dich eingeladen, ein vertrauenswürdiger Kontakt zu werden';
  }

  @override
  String get authToManageLegacy =>
      'Bitte authentifiziere dich, um deine vertrauenswürdigen Kontakte zu verwalten';

  @override
  String get hideSharedItemsFromHomeGallery =>
      'Geteilte Elemente in der Home-Galerie ausblenden';

  @override
  String get swipeToSelect => 'Zum Auswählen wischen';

  @override
  String get gallery => 'Galerie';

  @override
  String get joinAlbum => 'Album beitreten';

  @override
  String get joinAlbumSubtext => 'um deine Fotos anzuzeigen und hinzuzufügen';

  @override
  String get joinAlbumSubtextViewer =>
      'um dies zu geteilten Alben hinzuzufügen';

  @override
  String get join => 'Beitreten';

  @override
  String get linkEmail => 'E-Mail-Adresse verknüpfen';

  @override
  String get link => 'Verknüpfen';

  @override
  String get noEnteAccountExclamation => 'Kein Ente-Konto!';

  @override
  String get orPickFromYourContacts => 'oder wähle aus deinen Kontakten';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return '$email hat kein Ente-Konto.';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (Ich)';
  }

  @override
  String get reassignMe => '\"Ich\" neu zuweisen';

  @override
  String get me => 'Ich';

  @override
  String get linkEmailToContactBannerCaption => 'für schnelleres Teilen';

  @override
  String get selectPersonToLink => 'Person zum Verknüpfen auswählen';

  @override
  String linkPersonToEmail({required String email}) {
    return 'Person mit $email verknüpfen';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return 'Dies wird $personName mit $email verknüpfen';
  }

  @override
  String get selectYourFace => 'Wähle dein Gesicht';

  @override
  String get reassigningLoading => 'Ordne neu zu...';

  @override
  String reassignedToName({required String name}) {
    return 'Du wurdest an $name neu zugewiesen';
  }

  @override
  String get saveChangesBeforeLeavingQuestion =>
      'Änderungen vor dem Verlassen speichern?';

  @override
  String get dontSave => 'Nicht speichern';

  @override
  String get thisIsMeExclamation => 'Das bin ich!';

  @override
  String get linkPerson => 'Person verknüpfen';

  @override
  String get linkPersonCaption => 'um besseres Teilen zu ermöglichen';

  @override
  String get videoStreaming => 'Streambare Videos';

  @override
  String get processingVideos => 'Verarbeite Videos';

  @override
  String get streamDetails => 'Stream-Details';

  @override
  String get processing => 'In Bearbeitung';

  @override
  String get queued => 'In der Warteschlange';

  @override
  String get ineligible => 'Unzulässig';

  @override
  String get failed => 'Fehlgeschlagen';

  @override
  String get playStream => 'Stream abspielen';

  @override
  String get playOriginal => 'Original abspielen';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'Wenn du einem Album beitrittst, wird deine E-Mail-Adresse für seine Teilnehmer sichtbar.';

  @override
  String get pleaseWaitThisWillTakeAWhile =>
      'Bitte warten, dies wird eine Weile dauern.';

  @override
  String get editTime => 'Uhrzeit ändern';

  @override
  String get selectTime => 'Uhrzeit wählen';

  @override
  String get selectDate => 'Datum wählen';

  @override
  String get previous => 'Zurück';

  @override
  String get selectOneDateAndTimeForAll =>
      'Wähle ein Datum und eine Uhrzeit für alle';

  @override
  String get selectStartOfRange => 'Anfang des Bereichs auswählen';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      'Dadurch werden Datum und Uhrzeit aller ausgewählten Fotos gleich.';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'Dies ist die erste in der Gruppe. Andere ausgewählte Fotos werden automatisch nach diesem neuen Datum verschoben';

  @override
  String get newRange => 'Neue Auswahl';

  @override
  String get selectOneDateAndTime => 'Wähle ein Datum und eine Uhrzeit';

  @override
  String get moveSelectedPhotosToOneDate =>
      'Ausgewählte Fotos auf ein Datum verschieben';

  @override
  String get shiftDatesAndTime => 'Datum und Uhrzeit verschieben';

  @override
  String get photosKeepRelativeTimeDifference =>
      'Fotos behalten relativen Zeitunterschied';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Fotos',
      one: 'Ein Foto',
      zero: 'Keine Fotos',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'App-Symbol';

  @override
  String get notThisPerson => 'Nicht diese Person?';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      'Ausgewählte Elemente werden von dieser Person entfernt, aber nicht aus deiner Bibliothek gelöscht.';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat über die Jahre';
  }

  @override
  String get thisWeekThroughTheYears => 'Diese Woche über die Jahre';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Diese Woche, vor $count Jahren',
      one: 'Diese Woche, vor einem Jahr',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'Du und $name';
  }

  @override
  String admiringThem({required Object name}) {
    return '$name wertschätzen';
  }

  @override
  String embracingThem({required Object name}) {
    return '$name umarmen';
  }

  @override
  String partyWithThem({required Object name}) {
    return 'Party mit $name';
  }

  @override
  String hikingWithThem({required Object name}) {
    return 'Wandern mit $name';
  }

  @override
  String feastingWithThem({required Object name}) {
    return 'Feiern mit $name';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return 'Selfies mit $name';
  }

  @override
  String posingWithThem({required Object name}) {
    return 'Posieren mit $name';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return 'Schöne Ausblicke mit $name';
  }

  @override
  String sportsWithThem({required Object name}) {
    return 'Sport mit $name';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return 'Roadtrip mit $name';
  }

  @override
  String get spotlightOnYourself => 'Spot auf dich selbst';

  @override
  String spotlightOnThem({required Object name}) {
    return 'Spot auf $name';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$name ist $age!';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name wird bald $age';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return 'Zuletzt mit $name';
  }

  @override
  String tripToLocation({required Object location}) {
    return 'Ausflug nach $location';
  }

  @override
  String tripInYear({required Object year}) {
    return 'Reise in $year';
  }

  @override
  String get lastYearsTrip => 'Reise im letzten Jahr';

  @override
  String get sunrise => 'Am Horizont';

  @override
  String get mountains => 'Über den Bergen';

  @override
  String get greenery => 'Im Grünen';

  @override
  String get beach => 'Am Strand';

  @override
  String get city => 'In der Stadt';

  @override
  String get moon => 'Bei Mondschein';

  @override
  String get onTheRoad => 'Wieder unterwegs';

  @override
  String get food => 'Kulinarische Genüsse';

  @override
  String get pets => 'Pelzige Begleiter';

  @override
  String get curatedMemories => 'Ausgewählte Erinnerungen';

  @override
  String get widgets => 'Widgets';

  @override
  String get memories => 'Erinnerungen';

  @override
  String get peopleWidgetDesc =>
      'Wähle die Personen, die du auf der Startseite sehen möchtest.';

  @override
  String get albumsWidgetDesc =>
      'Wähle die Alben, die du auf der Startseite sehen möchtest.';

  @override
  String get memoriesWidgetDesc =>
      'Wähle die Arten von Erinnerungen, die du auf der Startseite sehen möchtest.';

  @override
  String get smartMemories => 'Smarte Erinnerungen';

  @override
  String get pastYearsMemories => 'Erinnerungen der letzten Jahre';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return 'Sollen die Fotos (und Videos) aus diesen $count Alben auch aus <bold>allen</bold> anderen Alben gelöscht werden, in denen sie enthalten sind?';
  }

  @override
  String get addParticipants => 'Teilnehmer hinzufügen';

  @override
  String selectedAlbums({required Object count}) {
    return '$count ausgewählt';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'Aktion für das Favoritenalbum nicht unterstützt';

  @override
  String get onThisDayMemories => 'Erinnerungen an diesem Tag';

  @override
  String get onThisDay => 'An diesem Tag';

  @override
  String get lookBackOnYourMemories => 'Schau zurück auf deine Erinnerungen 🌄';

  @override
  String get newPhotosEmoji => ' neue 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'Entschuldigung, wir mussten deine Sicherungen pausieren';

  @override
  String get clickToInstallOurBestVersionYet =>
      'Klicke, um unsere bisher beste Version zu installieren';

  @override
  String get onThisDayNotificationExplanation =>
      'Erhalte Erinnerungen von diesem Tag in den vergangenen Jahren.';

  @override
  String get addMemoriesWidgetPrompt =>
      'Füge ein Erinnerungs-Widget zu deiner Startseite hinzu und komm hierher zurück, um es anzupassen.';

  @override
  String get addAlbumWidgetPrompt =>
      'Füge ein Alben-Widget zu deiner Startseite hinzu und komm hierher zurück, um es anzupassen.';

  @override
  String get addPeopleWidgetPrompt =>
      'Füge ein Personen-Widget zu deiner Startseite hinzu und komm hierher zurück, um es anzupassen.';

  @override
  String get birthdayNotifications => 'Geburtstagsbenachrichtigungen';

  @override
  String get receiveRemindersOnBirthdays =>
      'Erhalte Erinnerungen, wenn jemand Geburtstag hat. Ein Klick auf die Benachrichtigung bringt dich zu den Fotos der Person, die Geburtstag hat.';

  @override
  String get happyBirthday => 'Herzlichen Glückwunsch zum Geburtstag! 🥳';

  @override
  String get birthdays => 'Geburtstage';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return 'Wünsche $name alles Gute zum Geburtstag! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      'Bist du sicher, dass du dieses Gesicht von dieser Person entfernen möchtest?';

  @override
  String get otherDetectedFaces => 'Andere erkannte Gesichter';

  @override
  String get areThey => 'Ist das ';

  @override
  String get questionmark => '?';

  @override
  String get saveAsAnotherPerson => 'Als andere Person speichern';

  @override
  String get showLessFaces => 'Weniger Gesichter zeigen';

  @override
  String get showMoreFaces => 'Mehr Gesichter zeigen';

  @override
  String get ignore => 'Ignorieren';

  @override
  String get merge => 'Zusammenführen';

  @override
  String get reset => 'Zurücksetzen';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      'Bist du sicher, dass du diese Person ignorieren willst?';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      'Bist du sicher, dass du diese Personen ignorieren willst?';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'Diese Personengruppen werden im Personen-Abschnitt nicht mehr angezeigt. Die Fotos bleiben unverändert.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'Diese Person wird im Personen-Abschnitt nicht mehr angezeigt. Die Fotos bleiben unverändert.';

  @override
  String get areYouSureYouWantToMergeThem =>
      'Bist du sicher, dass du sie zusammenführen willst?';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'Alle unbenannten Gruppen werden zur ausgewählten Person zusammengeführt. Dies kann im Verlauf der Vorschläge für diese Person rückgängig gemacht werden.';

  @override
  String get yesIgnore => 'Ja, ignorieren';

  @override
  String get same => 'Gleich';

  @override
  String get different => 'Verschieden';

  @override
  String get sameperson => 'Dieselbe Person?';

  @override
  String get indexingPausedStatusDescription =>
      'Die Indizierung ist pausiert. Sie wird automatisch fortgesetzt, wenn das Gerät bereit ist. Das Gerät wird als bereit angesehen, wenn sich der Akkustand, die Akkugesundheit und der thermische Zustand in einem gesunden Bereich befinden.';

  @override
  String get thisWeek => 'Diese Woche';

  @override
  String get lastWeek => 'Letzte Woche';

  @override
  String get thisMonth => 'Diesen Monat';

  @override
  String get thisYear => 'Dieses Jahr';

  @override
  String get groupBy => 'Gruppieren nach';

  @override
  String get faceThumbnailGenerationFailed =>
      'Vorschaubilder konnten nicht erstellt werden';

  @override
  String get fileAnalysisFailed => 'Datei konnte nicht analysiert werden';

  @override
  String get editAutoAddPeople =>
      'Automatisch hinzugefügte Personen bearbeiten';

  @override
  String get autoAddPeople => 'Personen automatisch hinzufügen';

  @override
  String get autoAddToAlbum => 'Automatisch zu Album hinzufügen';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      'Sollen die Dateien, die sich auf die Person beziehen, die zuvor in Smart-Alben ausgewählt wurde, entfernt werden?';

  @override
  String get addingPhotos => 'Füge Fotos hinzu';

  @override
  String get gettingReady => 'Vorbereitung';

  @override
  String get addSomePhotosDesc1 => 'Fotos hinzufügen oder auswählen ';

  @override
  String get addSomePhotosDesc2 => 'bekannte Gesichter';

  @override
  String get addSomePhotosDesc3 => '\nzu beginnen';

  @override
  String get ignorePerson => 'Person ignorieren';

  @override
  String get mixedGrouping => 'Gemischte Gruppierung?';

  @override
  String get analysis => 'Analyse';

  @override
  String get doesGroupContainMultiplePeople =>
      'Enthält diese Gruppierung mehrere Personen?';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'Wir analysieren die Gruppierung automatisch, um festzustellen, ob mehrere Personen vorhanden sind, und trennen sie erneut. Dies kann ein paar Sekunden dauern.';

  @override
  String get layout => 'Layout';

  @override
  String get day => 'Tag';

  @override
  String get undo => 'Rückgängig';

  @override
  String get redo => 'Wiederherstellen';

  @override
  String get filter => 'Filter';

  @override
  String get adjust => 'Anpassen';

  @override
  String get draw => 'Zeichnen';

  @override
  String get sticker => 'Sticker';

  @override
  String get brushColor => 'Pinselfarbe';

  @override
  String get font => 'Schriftart';

  @override
  String get background => 'Hintergrund';

  @override
  String get align => 'Ausrichten';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Erfolgreich zu $count Alben hinzugefügt',
      one: 'Erfolgreich zu einem Album hinzugefügt',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => 'Videos verarbeitet';

  @override
  String get totalVideos => 'Videos insgesamt';

  @override
  String get skippedVideos => 'Übersprungene Videos';

  @override
  String get videoStreamingDescriptionLine1 =>
      'Videos sofort auf jedem Gerät abspielen.';

  @override
  String get videoStreamingDescriptionLine2 =>
      'Aktivieren, um Video-Streams auf diesem Gerät zu verarbeiten.';

  @override
  String get videoStreamingNote =>
      'Nur Videos der letzten 60 Tage und unter einer Minute werden auf diesem Gerät verarbeitet. Für ältere/längere Videos aktiviere das Streaming in der Desktop-App.';

  @override
  String get createStream => 'Stream erzeugen';

  @override
  String get recreateStream => 'Stream neu erzeugen';

  @override
  String get addedToStreamCreationQueue =>
      'Zur Warteschlange für Streamerstellung hinzugefügt';

  @override
  String get addedToStreamRecreationQueue =>
      'Zur Warteschlange für Neuerstellung der Streams hinzugefügt';

  @override
  String get videoPreviewAlreadyExists => 'Videovorschau existiert bereits';

  @override
  String get videoAlreadyInQueue =>
      'Videodatei existiert bereits in der Warteschlange';

  @override
  String get videoExportFailed =>
      'Erstellung des Videos fehlgeschlagen. Bitte versuche es erneut.';

  @override
  String videoExportSuccess({required String path}) {
    return 'Video erfolgreich unter $path erstellt';
  }

  @override
  String get addedToQueue => 'Zur Warteschlange hinzugefügt';

  @override
  String get creatingStream => 'Stream wird erzeugt';

  @override
  String get similarImages => 'Ähnliche Bilder';

  @override
  String get findSimilarImages => 'Ähnliche Bilder finden';

  @override
  String get noSimilarImagesFound => 'Keine ähnlichen Bilder gefunden';

  @override
  String get yourPhotosLookUnique => 'Deine Fotos sehen einzigartig aus';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Gruppen gefunden',
      one: 'Eine Gruppe gefunden',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages =>
      'Überprüfe und lösche ähnliche Bilder';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return 'Lösche $count Fotos ($size)';
  }

  @override
  String get selectionOptions => 'Auswahloptionen';

  @override
  String selectExactWithCount({required int count}) {
    return 'Exakt gleich ($count)';
  }

  @override
  String get selectExact => 'Exakte auswählen';

  @override
  String selectSimilarWithCount({required int count}) {
    return 'Nahezu gleich ($count)';
  }

  @override
  String get selectSimilar => 'Ähnliche auswählen';

  @override
  String selectAllWithCount({required int count}) {
    return 'Alle Ähnlichkeiten ($count)';
  }

  @override
  String get selectSimilarImagesTitle => 'Ähnliche Bilder auswählen';

  @override
  String get chooseSimilarImagesToSelect =>
      'Wähle Bilder anhand ihrer visuellen Ähnlichkeit';

  @override
  String get clearSelection => 'Auswahl aufheben';

  @override
  String similarImagesCount({required int count}) {
    return '$count ähnliche Bilder';
  }

  @override
  String deleteWithCount({required int count}) {
    return 'Löschen ($count)';
  }

  @override
  String get deleteFiles => 'Dateien löschen';

  @override
  String get areYouSureDeleteFiles =>
      'Bist du sicher, dass du diese Dateien löschen willst?';

  @override
  String get greatJob => 'Gut gemacht!';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return 'Du hast $size an Speicherplatz freigegeben';
  }

  @override
  String get size => 'Größe';

  @override
  String get similarity => 'Ähnlichkeit';

  @override
  String get analyzingPhotosLocally => 'Deine Fotos werden lokal analysiert...';

  @override
  String get lookingForVisualSimilarities =>
      'Suche nach visuellen Ähnlichkeiten...';

  @override
  String get comparingImageDetails => 'Vergleiche Bilddetails...';

  @override
  String get findingSimilarImages => 'Finde ähnliche Bilder...';

  @override
  String get almostDone => 'Fast fertig...';

  @override
  String get processingLocally => 'Lokale Verarbeitung';

  @override
  String get useMLToFindSimilarImages =>
      'Überprüfe und entferne Bilder, die sich ähnlich sehen.';

  @override
  String get all => 'Alle';

  @override
  String get similar => 'Gleich';

  @override
  String get identical => 'Identisch';

  @override
  String get nothingHereTryAnotherFilter =>
      'Nichts zu sehen, probier einen anderen Filter! 👀';

  @override
  String get related => 'Verwandt';

  @override
  String get hoorayyyy => 'Hurraaaa!';

  @override
  String get nothingToTidyUpHere => 'Hier gibt es nichts zu bereinigen';

  @override
  String get deletingDash => 'Lösche - ';

  @override
  String get cLTitle1 => 'Einführung von Ritualen';

  @override
  String get cLDesc1 =>
      'Planst du Vorsätze für 2026? Mit Ritualen kannst du eine Erinnerung in Ente Photos setzen und deinen Fortschritt durch Fotos verfolgen. Nutze es für Workouts, Essgewohnheiten, tägliche Momente mit deinen Liebsten – alles, was du zur Gewohnheit machen möchtest.';

  @override
  String get cLTitle2 => 'Öffentliche Links, jetzt für alle';

  @override
  String get cLDesc2 =>
      'Alle Ente-Nutzer im kostenlosen Tarif können jetzt öffentliche Links zu Fotos und Alben erstellen und teilen. Um Missbrauch zu verhindern, werden Links Grenzen haben, wie viele Personen sie ansehen können.';

  @override
  String get cLTitle3 => 'Personen manuell markieren';

  @override
  String get cLDesc3 =>
      'Du kannst jetzt Personen markieren, auch wenn unsere On-Device-KI kein Gesicht erkennt. Praktisch für Haustiere, teilweise sichtbare Gesichter oder Momente, in denen jemand nicht wirklich auf dem Foto ist, aber trotzdem einbezogen werden sollte.';

  @override
  String get cLTitle4 => 'Und mehr';

  @override
  String get cLDesc4 =>
      'Du kannst jetzt geteilte Alben anpinnen. Album-Links sind für Mitarbeiter und Betrachter sichtbar, um das Teilen noch einfacher zu machen. Wir haben einige iOS-Wischfehler behoben und die Fotoansicht aktualisiert, einschließlich eines neuen Favoriten-Symbols (Platz für kommende Funktionen).';

  @override
  String get closeBy => 'Ähnlich';

  @override
  String get peopleAutoAddDesc =>
      'Fotos der ausgewählten Personen automatisch zu diesem Album hinzufügen';

  @override
  String get festivities => 'Festlicher Beifall';

  @override
  String get snowAdventures => 'Winterabenteuer';

  @override
  String get waterfalls => 'Wasserfälle jagen';

  @override
  String get wildlife => 'In die Wildnis';

  @override
  String get flowers => 'Blühende Schönheiten';

  @override
  String get nightLights => 'Nächte in Neon';

  @override
  String get architecture => 'Icons designen';

  @override
  String get autumnColors => 'Herbstpracht';

  @override
  String get desertDreams => 'Wüstenträume';

  @override
  String get stargazing => 'Unter den Sternen';

  @override
  String get lakeside => 'Ruhe am See';

  @override
  String get rainyDays => 'Regentag-Gefühle';

  @override
  String get sportsAction => 'Zocken';

  @override
  String get streetArt => 'Straßenkunst-Geschichten';

  @override
  String get familyMoments => 'Familienzeit';

  @override
  String get fireworks => 'Feuerwerk-Finale';

  @override
  String get historicSites => 'Echos der Geschichte';

  @override
  String get tropicalParadise => 'Flucht in die Tropen';

  @override
  String get forestTrails => 'Waldspaziergänge';

  @override
  String get citySunsets => 'Leuchtender Sonnenuntergang in der Stadt';

  @override
  String get colorfulMarkets => 'Lebhafte Märkte';

  @override
  String get cozyCafes => 'Gemütliche Kaffee-Ecken';

  @override
  String get vintageVibes => 'Vintage-Stimmungen';

  @override
  String get aerialViews => 'Perspektiven aus der Luft';

  @override
  String get artisticPortraits => 'Kunstvolle Porträts';

  @override
  String get streetFood => 'Streetfood-Happen';

  @override
  String get riverCruises => 'Flusskreuzfahrt-Ausblicke';

  @override
  String get facesTimelineBannerTitle => 'Erinnerungen';

  @override
  String facesTimelineBannerSubtitle({required String name}) {
    return 'Sieh dir Fotos von $name über die Jahre an';
  }

  @override
  String get facesTimelineAppBarTitle => 'Erinnerungen';

  @override
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Jahre alt',
      one: 'ein Jahr alt',
    );
    return '$name war $_temp0';
  }

  @override
  String facesTimelineCaptionYearsAgo({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '# Jahren',
      one: 'einem Jahr',
    );
    return 'vor $_temp0';
  }

  @override
  String get facesTimelineShareComingSoon => 'Das Teilen von Videos kommt bald';

  @override
  String get facesTimelinePlaybackPrevious => 'Vorheriges';

  @override
  String get facesTimelinePlaybackNext => 'Nächstes';

  @override
  String get facesTimelinePlaybackPlay => 'Wiedergabe';

  @override
  String get facesTimelinePlaybackPause => 'Pause';

  @override
  String get facesTimelineUnavailable =>
      'Zeitleiste der Gesichter wird vorbereitet...';

  @override
  String get playfulKids => 'Verspielte Kinder';

  @override
  String get coastalCliffs => 'Klippen am Meer';

  @override
  String get ritualsTitle => 'Rituale';

  @override
  String get ritualAddTooltip => 'Ritual hinzufügen';

  @override
  String get ritualActivityHeading => 'Aktivität';

  @override
  String get ritualDefaultHeatmapTitle => 'Täglich ein Foto machen';

  @override
  String get ritualUntitled => 'Unbenanntes Ritual';

  @override
  String get ritualShareUnavailable =>
      'Momentan kann nicht geteilt werden. Bitte versuche es erneut.';

  @override
  String get ritualNotificationMessage => 'Jetzt ein Foto machen';

  @override
  String get ritualCameraNotFound => 'Keine Kamera auf diesem Gerät gefunden.';

  @override
  String get ritualCameraStartError =>
      'Kamera kann nicht gestartet werden. Bitte überprüfe die Berechtigungen.';

  @override
  String get ritualCaptureError =>
      'Foto konnte nicht aufgenommen werden. Bitte versuche es erneut.';

  @override
  String ritualPhotoLimit({required int maxPhotos}) {
    String _temp0 = intl.Intl.pluralLogic(
      maxPhotos,
      locale: localeName,
      other: '# Fotos',
      one: 'einem Foto',
    );
    return 'Du kannst bis zu $_temp0 hinzufügen.';
  }

  @override
  String get ritualCaptureAtLeastOne => 'Nimm zuerst mindestens ein Foto auf.';

  @override
  String get ritualAlbumMissing =>
      'Das Rituale-Album fehlt. Bearbeite das Ritual, um ein Album festzulegen.';

  @override
  String get ritualAddedToAlbum => 'Zum Album hinzugefügt';

  @override
  String ritualAddedToAlbumWithName({required String albumName}) {
    return 'Zu $albumName hinzugefügt';
  }

  @override
  String ritualAddToAlbumFailure({required String error}) {
    return 'Konnte keine Fotos zum Album hinzufügen: $error';
  }

  @override
  String get ritualBackToList => 'Zurück zu den Ritualen';

  @override
  String get ritualNoPhotosYet => 'Noch keine Fotos';

  @override
  String get ritualSetAlbumToLaunchCamera =>
      'Lege ein Album für dieses Ritual fest, um die Kamera zu starten.';

  @override
  String get ritualDefaultCameraTitle => 'Mach ein Foto';

  @override
  String get ritualBadgeMessage7 =>
      '7 Tage geschafft! Die Beständigkeit steht dir. Weiter so!';

  @override
  String get ritualBadgeMessage14 =>
      '14 Tage dabei! Dein Ritual wird zur Gewohnheit. Unglaublich!';

  @override
  String get ritualBadgeMessage30 =>
      '30 Tage in Folge! Legendäre Beständigkeit! Genieße den Applaus!';

  @override
  String get ritualBadgeMessageDefault => 'Du hast einen Lauf!';

  @override
  String get ritualBadgeNewTitle => 'Neuer Erfolg';

  @override
  String get ritualBadgePreparing => 'Wird vorbereitet...';

  @override
  String get ritualStreaksLabel => 'Streaks';

  @override
  String get ritualCreateYourOwn => 'Erstelle dein eigenes Ritual';

  @override
  String get ritualGetDailyReminders => 'Erhalte tägliche Erinnerungen';

  @override
  String get ritualAlbumNotSet => 'Album nicht gesetzt';

  @override
  String get ritualOpenCameraTooltip => 'Ritualkamera öffnen';

  @override
  String get ritualEditorLabel => 'Ritual-Editor';

  @override
  String get ritualNew => 'Neues Ritual';

  @override
  String get ritualCreateNewTitle => 'Create new ritual';

  @override
  String get ritualEdit => 'Ritual bearbeiten';

  @override
  String get ritualEnterPrompt => 'Gib dein Ritual ein';

  @override
  String get ritualEnterDescription => 'Bitte gib eine Beschreibung ein';

  @override
  String get ritualChooseDaysLabel => 'Choose days for ritual';

  @override
  String get ritualDayLabel => 'Tag';

  @override
  String get ritualNotificationsOffHint =>
      'Benachrichtigungen sind ausgeschaltet. Tippe auf einen Tag, um sie einzuschalten.';

  @override
  String get ritualTimeLabel => 'Zeitpunkt';

  @override
  String get ritualAlbumLabel => 'Album';

  @override
  String get ritualSave => 'Ritual speichern';

  @override
  String get ritualCreateAction => 'Create ritual';

  @override
  String get ritualUpdate => 'Ritual aktualisieren';

  @override
  String get ritualSelectAlbumTitle => 'Album auswählen';

  @override
  String get ritualChooseAlbumLabel => 'Choose an album';

  @override
  String get ritualSendReminderLabel => 'Send reminder';

  @override
  String get ritualSearchOrCreate => 'Suchen oder neu erstellen';

  @override
  String get ritualNoAlbumsYet => 'Bisher keine Alben';

  @override
  String get ritualNoMatchingAlbums => 'Keine passenden Alben';

  @override
  String ritualCreateAlbumWithName({required String albumName}) {
    return '\"$albumName \" erstellen';
  }

  @override
  String get ritualCreateNew => 'Neu erstellen';

  @override
  String get ritualAlbumSelectionPlaceholder => 'Album auswählen';

  @override
  String get ritualPickEmojiTitle => 'Emoji auswählen';

  @override
  String get ritualCustomKeyboardLabel => 'Custom (keyboard)';

  @override
  String get ritualEmojiKeyboardHint => 'Press to open emoji keyboard';

  @override
  String get ritualEmojiUseAction => 'Use';

  @override
  String get ritualSearchEmpty =>
      'Build a ritual to keep your photo habit going.';
}
