// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Catalan Valencian (`ca`).
class AppLocalizationsCa extends AppLocalizations {
  AppLocalizationsCa([String locale = 'ca']) : super(locale);

  @override
  String get enterYourEmailAddress => 'Introdueix la teva adreça de correu';

  @override
  String get enterYourNewEmailAddress =>
      'Introdueix la teva nova adreça de correu';

  @override
  String get accountWelcomeBack => 'Benvingut de nou!';

  @override
  String get emailAlreadyRegistered => 'Correu ja registrat.';

  @override
  String get emailNotRegistered => 'Correu no registrat.';

  @override
  String get email => 'Correu';

  @override
  String get cancel => 'Cancel·la';

  @override
  String get verify => 'Verifica';

  @override
  String get invalidEmailAddress => 'Adreça de correu invàlida';

  @override
  String get enterValidEmail =>
      'Si us plau, introdueix una adreça de correu vàlida.';

  @override
  String get deleteAccount => 'Esborra el compte';

  @override
  String get deleteAccountWarning =>
      'Això esborrarà el teu compte d\'Ente Auth, Ente Photos i Ente Locker.';

  @override
  String get askDeleteReason =>
      'Quina és la raó principal per la qual esborres el teu compte?';

  @override
  String get deleteAccountFeedbackPrompt =>
      'Ens sap greu veure\'t marxar. Si us plau, comparteix els teus comentaris per ajudar-nos a millorar.';

  @override
  String get feedback => 'Comentaris';

  @override
  String get kindlyHelpUsWithThisInformation =>
      'Si us plau, ajuda\'ns amb aquesta informació';

  @override
  String get confirmDeletePrompt =>
      'Sí, vull esborrar permanentment aquest compte i les seves dades a totes les aplicacions.';

  @override
  String get confirmAccountDeletion => 'Confirma l\'eliminació del compte';

  @override
  String get deleteAccountPermanentlyButton =>
      'Esborra el compte permanentment';

  @override
  String get yourAccountHasBeenDeleted => 'El teu compte ha estat esborrat';

  @override
  String get selectReason => 'Selecciona una raó';

  @override
  String get deleteReason1 => 'Falta una funció clau que necessito';

  @override
  String get deleteReason2 =>
      'L\'aplicació o una certa funció no es comporta com crec que hauria de fer-ho';

  @override
  String get deleteReason3 => 'He trobat un altre servei que m\'agrada més';

  @override
  String get deleteReason4 => 'La meva raó no està llistada';

  @override
  String get sendEmail => 'Envia correu';

  @override
  String get deleteRequestSLAText =>
      'La teva sol·licitud es processarà en 72 hores.';

  @override
  String get deleteEmailRequest =>
      'Si us plau, envia un correu a <warning>account-deletion@ente.io</warning> des de la teva adreça de correu registrada.';

  @override
  String get entePhotosPerm =>
      'Ente <i>necessita permís per</i> preservar les teves fotos';

  @override
  String get ok => 'D\'acord';

  @override
  String get createAccount => 'Crea compte';

  @override
  String get createNewAccount => 'Crea nou compte';

  @override
  String get password => 'Contrasenya';

  @override
  String get confirmPassword => 'Confirma la contrasenya';

  @override
  String get activeSessions => 'Sessions actives';

  @override
  String get ocrProcessingOverlayMessage => 'Detectant text...';

  @override
  String get ocrLoadingIndicatorLabel => 'Detectant text';

  @override
  String get ocrSelectionHint =>
      'Llisca o fes doble toc per seleccionar només el que necessites';

  @override
  String get ocrNoTextDetected => 'No s\'ha detectat text';

  @override
  String get ocrRetryButtonLabel => 'Reintenta';

  @override
  String get ocrModelsNetworkRequiredError =>
      'Es requereix connexió a la xarxa per descarregar els models OCR en el primer ús';

  @override
  String get ocrModelsPrepareFailed =>
      'No s\'han pogut preparar els models OCR';

  @override
  String get ocrImageNotFoundError => 'No s\'ha trobat el fitxer d\'imatge';

  @override
  String get ocrImageDecodeFailedError =>
      'No s\'ha pogut llegir el fitxer d\'imatge';

  @override
  String get ocrGenericDetectError =>
      'No s\'ha pogut detectar text a la imatge';

  @override
  String get oops => 'Vaja';

  @override
  String get somethingWentWrongPleaseTryAgain =>
      'Alguna cosa ha anat malament, si us plau torna-ho a provar';

  @override
  String get thisWillLogYouOutOfThisDevice =>
      'Això tancarà la sessió d\'aquest dispositiu!';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice =>
      'Això tancarà la sessió del següent dispositiu:';

  @override
  String get terminateSession => 'Tancar la sessió?';

  @override
  String get terminate => 'Tanca';

  @override
  String get thisDevice => 'Aquest dispositiu';

  @override
  String get recoverButton => 'Recupera';

  @override
  String get recoverySuccessful => 'Recuperació exitosa!';

  @override
  String get decrypting => 'Desxifrant...';

  @override
  String get incorrectRecoveryKeyTitle => 'Clau de recuperació incorrecta';

  @override
  String get incorrectRecoveryKeyBody =>
      'La clau de recuperació que has introduït és incorrecta';

  @override
  String get forgotPassword => 'Has oblidat la contrasenya?';

  @override
  String get enterYourRecoveryKey => 'Introdueix la teva clau de recuperació';

  @override
  String get noRecoveryKey => 'No tens clau de recuperació?';

  @override
  String get sorry => 'Ho sentim';

  @override
  String get noRecoveryKeyNoDecryption =>
      'A causa de la naturalesa del nostre protocol de xifratge d\'extrem a extrem, les teves dades no es poden desxifrar sense la teva contrasenya o clau de recuperació';

  @override
  String get verifyEmail => 'Verifica el correu';

  @override
  String get toResetVerifyEmail =>
      'Per restablir la teva contrasenya, si us plau verifica primer el teu correu.';

  @override
  String get checkInboxAndSpamFolder =>
      'Si us plau, revisa la teva bústia (i el correu brossa) per completar la verificació';

  @override
  String get tapToEnterCode => 'Toca per introduir el codi';

  @override
  String get resendEmail => 'Reenvia correu';

  @override
  String weHaveSendEmailTo({required String email}) {
    return 'Hem enviat un correu a <green>$email</green>';
  }

  @override
  String get setPasswordTitle => 'Estableix contrasenya';

  @override
  String get changePasswordTitle => 'Canvia la contrasenya';

  @override
  String get resetPasswordTitle => 'Restableix la contrasenya';

  @override
  String get encryptionKeys => 'Claus de xifratge';

  @override
  String get passwordWarning =>
      'No guardem aquesta contrasenya, així que si l\'oblides, <underline>no podrem desxifrar les teves dades</underline>';

  @override
  String get enterPasswordToEncrypt =>
      'Introdueix una contrasenya que puguem utilitzar per xifrar les teves dades';

  @override
  String get enterNewPasswordToEncrypt =>
      'Introdueix una nova contrasenya que puguem utilitzar per xifrar les teves dades';

  @override
  String get weakStrength => 'Dèbil';

  @override
  String get strongStrength => 'Forta';

  @override
  String get moderateStrength => 'Moderada';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'Força de la contrasenya: $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully => 'Contrasenya canviada amb èxit';

  @override
  String get generatingEncryptionKeys => 'Generant claus de xifratge...';

  @override
  String get pleaseWait => 'Si us plau, espera...';

  @override
  String get continueLabel => 'Continua';

  @override
  String get insecureDevice => 'Dispositiu insegur';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'Ho sentim, no hem pogut generar claus segures en aquest dispositiu.\n\nsi us plau, registra\'t des d\'un altre dispositiu.';

  @override
  String get howItWorks => 'Com funciona';

  @override
  String get encryption => 'Xifratge';

  @override
  String get ackPasswordLostWarning =>
      'Entenc que si perdo la meva contrasenya, puc perdre les meves dades ja que les meves dades estan <underline>xifrades d\'extrem a extrem</underline>.';

  @override
  String get privacyPolicyTitle => 'Política de privadesa';

  @override
  String get termsOfServicesTitle => 'Termes';

  @override
  String get signUpTerms =>
      'Accepto els <u-terms>termes del servei</u-terms> i la <u-policy>política de privadesa</u-policy>';

  @override
  String get logInLabel => 'Inicia sessió';

  @override
  String get loginTerms =>
      'En fer clic a inicia sessió, accepto els <u-terms>termes del servei</u-terms> i la <u-policy>política de privadesa</u-policy>';

  @override
  String get changeEmail => 'Canvia el correu';

  @override
  String get enterYourPassword => 'Introdueix la teva contrasenya';

  @override
  String get welcomeBack => 'Benvingut de nou!';

  @override
  String get contactSupport => 'Contacta amb suport';

  @override
  String get locationPickerTip =>
      'També pots afegir una ubicació centrada en una foto des de la pantalla d\'informació de la foto';

  @override
  String get incorrectPasswordTitle => 'Contrasenya incorrecta';

  @override
  String get pleaseTryAgain => 'Si us plau, torna-ho a provar';

  @override
  String get recreatePasswordTitle => 'Torna a crear la contrasenya';

  @override
  String get useRecoveryKey => 'Utilitza la clau de recuperació';

  @override
  String get recreatePasswordBody =>
      'El dispositiu actual no és prou potent per verificar la teva contrasenya, però podem regenerar-la d\'una manera que funcioni amb tots els dispositius.\n\nSi us plau, inicia sessió utilitzant la teva clau de recuperació i regenera la teva contrasenya (pots utilitzar la mateixa de nou si ho desitges).';

  @override
  String get verifyPassword => 'Verifica la contrasenya';

  @override
  String get recoveryKey => 'Clau de recuperació';

  @override
  String get recoveryKeyOnForgotPassword =>
      'Si oblides la teva contrasenya, l\'única manera de recuperar les teves dades és amb aquesta clau.';

  @override
  String get recoveryKeySaveDescription =>
      'No guardem aquesta clau, si us plau guarda aquesta clau de 24 paraules en un lloc segur.';

  @override
  String get doThisLater => 'Fes-ho més tard';

  @override
  String get saveKey => 'Guarda la clau';

  @override
  String get recoveryKeyCopiedToClipboard =>
      'Clau de recuperació copiada al porta-retalls';

  @override
  String get recoverAccount => 'Recupera el compte';

  @override
  String get recover => 'Recupera';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'Si us plau, envia un correu a $supportEmail des de la teva adreça de correu registrada';
  }

  @override
  String get twofactorSetup => 'Configuració de doble factor';

  @override
  String get enterCode => 'Introdueix el codi';

  @override
  String get scanCode => 'Escaneja el codi';

  @override
  String get codeCopiedToClipboard => 'Codi copiat al porta-retalls';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      'Copia i enganxa aquest codi\na la teva aplicació d\'autenticació';

  @override
  String get tapToCopy => 'toca per copiar';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      'Escaneja aquest codi de barres amb\nla teva aplicació d\'autenticació';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      'Introdueix el codi de 6 dígits de\nla teva aplicació d\'autenticació';

  @override
  String get confirm => 'Confirma';

  @override
  String get setupComplete => 'Configuració completa';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready =>
      'Guarda la teva clau de recuperació si encara no ho has fet';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      'Això es pot utilitzar per recuperar el teu compte si perds el teu segon factor';

  @override
  String get twofactorAuthenticationPageTitle => 'Autenticació de doble factor';

  @override
  String get lostDevice => 'Dispositiu perdut?';

  @override
  String get verifyingRecoveryKey => 'Verificant clau de recuperació...';

  @override
  String get recoveryKeyVerified => 'Clau de recuperació verificada';

  @override
  String get recoveryKeySuccessBody =>
      'Genial! La teva clau de recuperació és vàlida. Gràcies per verificar-la.\n\nSi us plau, recorda guardar la teva clau de recuperació de manera segura.';

  @override
  String get invalidRecoveryKey =>
      'La clau de recuperació que has introduït no és vàlida. Si us plau, assegura\'t que conté 24 paraules, i comprova l\'ortografia de cadascuna.\n\nSi has introduït un codi de recuperació antic, assegura\'t que té 64 caràcters de llargada, i comprova cadascun d\'ells.';

  @override
  String get invalidKey => 'Clau invàlida';

  @override
  String get tryAgain => 'Torna-ho a provar';

  @override
  String get viewRecoveryKey => 'Veure clau de recuperació';

  @override
  String get confirmRecoveryKey => 'Confirma clau de recuperació';

  @override
  String get recoveryKeyVerifyReason =>
      'La teva clau de recuperació és l\'única manera de recuperar les teves fotos si oblides la teva contrasenya. Pots trobar la teva clau de recuperació a Configuració > Compte.\n\nSi us plau, introdueix la teva clau de recuperació aquí per verificar que l\'has guardat correctament.';

  @override
  String get confirmYourRecoveryKey => 'Confirma la teva clau de recuperació';

  @override
  String get addViewer => 'Afegeix visualitzador';

  @override
  String get addCollaborator => 'Afegeix col·laborador';

  @override
  String get admin => 'Admin';

  @override
  String get admins => 'Admins';

  @override
  String get addAdmin => 'Add admin';

  @override
  String get addMoreAdmins => 'Add more admins';

  @override
  String get adminsAndCollaboratorsCanAddPhotosDescription =>
      'Admins and collaborators can add photos. Admins can also manage photos & participants.';

  @override
  String get addANewEmail => 'Afegeix un nou correu';

  @override
  String get orPickAnExistingOne => 'O tria\'n un d\'existent';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'Els col·laboradors poden afegir fotos i vídeos a l\'àlbum compartit.';

  @override
  String get enterEmail => 'Introdueix correu';

  @override
  String get albumOwner => 'Propietari';

  @override
  String get you => 'Tu';

  @override
  String get collaborator => 'Col·laborador';

  @override
  String get addMore => 'Afegeix més';

  @override
  String get viewer => 'Visualitzador';

  @override
  String get remove => 'Elimina';

  @override
  String get removeParticipant => 'Elimina participant';

  @override
  String get manage => 'Gestiona';

  @override
  String get addedAs => 'Afegit com';

  @override
  String get changePermissions => 'Canviar permisos?';

  @override
  String get yesConvertToViewer => 'Sí, converteix a visualitzador';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return '$user no podrà afegir més fotos a aquest àlbum\n\nEncara podrà eliminar les fotos existents afegides per ells';
  }

  @override
  String get allowAddingPhotos => 'Permet afegir fotos';

  @override
  String get allowJoiningAlbum => 'Permet unir-se a l\'àlbum';

  @override
  String get allowAddPhotosDescription =>
      'Permet que les persones amb l\'enllaç també afegeixin fotos a l\'àlbum compartit.';

  @override
  String get passwordLock => 'Bloqueig per contrasenya';

  @override
  String get canNotOpenTitle => 'No es pot obrir aquest àlbum';

  @override
  String get canNotOpenBody =>
      'Ho sentim, aquest àlbum no es pot obrir a l\'aplicació.';

  @override
  String get disableDownloadWarningTitle => 'Si us plau, tingues en compte';

  @override
  String get disableDownloadWarningBody =>
      'Els visualitzadors encara poden fer captures de pantalla o guardar una còpia de les teves fotos utilitzant eines externes';

  @override
  String get allowDownloads => 'Permet descàrregues';

  @override
  String get linkDeviceLimit => 'Límit de dispositius';

  @override
  String get noDeviceLimit => 'Cap';

  @override
  String get albumLayout => 'Disposició de l\'àlbum';

  @override
  String get layoutGrouped => 'Agrupat';

  @override
  String get layoutContinuous => 'Continu';

  @override
  String get layoutTrip => 'Viatge';

  @override
  String get preview => 'Previsualització';

  @override
  String get linkExpiry => 'Caducitat de l\'enllaç';

  @override
  String get linkExpired => 'Caducat';

  @override
  String get linkEnabled => 'Activat';

  @override
  String get linkNeverExpires => 'Mai';

  @override
  String get expiredLinkInfo =>
      'Aquest enllaç ha caducat. Si us plau, selecciona una nova hora de caducitat o desactiva la caducitat de l\'enllaç.';

  @override
  String get setAPassword => 'Estableix una contrasenya';

  @override
  String get lockButtonLabel => 'Bloqueja';

  @override
  String get enterPassword => 'Introdueix la contrasenya';

  @override
  String get removeLink => 'Elimina enllaç';

  @override
  String get manageLink => 'Gestiona enllaç';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'L\'enllaç caducarà el $expiryTime';
  }

  @override
  String get albumUpdated => 'Àlbum actualitzat';

  @override
  String get never => 'Mai';

  @override
  String get custom => 'Personalitzat';

  @override
  String get after1Hour => 'Després d\'1 hora';

  @override
  String get after1Day => 'Després d\'1 dia';

  @override
  String get after1Week => 'Després d\'1 setmana';

  @override
  String get after1Month => 'Després d\'1 mes';

  @override
  String get after1Year => 'Després d\'1 any';

  @override
  String get manageParticipants => 'Gestiona';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count participants',
      one: '1 participant',
      zero: 'Sense participants',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'Crea un enllaç per permetre que la gent afegeixi i vegi fotos al teu àlbum compartit sense necessitat d\'una aplicació o compte d\'Ente. Genial per recollir fotos d\'esdeveniments.';

  @override
  String get collectPhotos => 'Recull fotos';

  @override
  String get collaborativeLink => 'Enllaç col·laboratiu';

  @override
  String get shareWithNonenteUsers => 'Comparteix amb usuaris no Ente';

  @override
  String get createPublicLink => 'Crea enllaç públic';

  @override
  String get sendLink => 'Envia enllaç';

  @override
  String get qrCode => 'Codi QR';

  @override
  String get sendQrCode => 'Envia codi QR';

  @override
  String get copyLink => 'Copia enllaç';

  @override
  String get copyEmbedHtml => 'Copia HTML incrustat';

  @override
  String get linkHasExpired => 'L\'enllaç ha caducat';

  @override
  String get publicLinkEnabled => 'Enllaç públic activat';

  @override
  String get shareALink => 'Comparteix un enllaç';

  @override
  String get sharedAlbumSectionDescription =>
      'Crea àlbums compartits i col·laboratius amb altres usuaris d\'Ente, inclosos els usuaris de plans gratuïts.';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: 'Compartit amb $numberOfPeople persones',
      one: 'Compartit amb 1 persona',
      zero: 'Comparteix amb persones específiques',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId => 'Aquest és el teu ID de verificació';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'Algú que comparteixi àlbums amb tu hauria de veure el mateix ID al seu dispositiu.';

  @override
  String get howToViewShareeVerificationID =>
      'Si us plau, demana\'ls que facin una pressió llarga sobre la seva adreça de correu a la pantalla de configuració, i verifica que els ID en ambdós dispositius coincideixen.';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'Aquest és l\'ID de verificació de $email';
  }

  @override
  String get verificationId => 'ID de verificació';

  @override
  String verifyEmailID({required Object email}) {
    return 'Verifica $email';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return '$email no té un compte d\'Ente.\n\nEnvia\'ls una invitació per compartir fotos.';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return 'Aquí tens el meu ID de verificació: $verificationID per a ente.io.';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'Ei, pots confirmar que aquest és el teu ID de verificació d\'ente.io: $verificationID';
  }

  @override
  String get somethingWentWrong => 'Alguna cosa ha anat malament';

  @override
  String get sendInvite => 'Envia invitació';

  @override
  String get shareTextRecommendUsingEnte =>
      'Descarrega Ente perquè puguem compartir fàcilment fotos i vídeos en qualitat original\n\nhttps://ente.io';

  @override
  String get done => 'Fet';

  @override
  String get applyCodeTitle => 'Aplica codi';

  @override
  String get enterCodeDescription =>
      'Introdueix el codi proporcionat pel teu amic per reclamar emmagatzematge gratuït per a tots dos';

  @override
  String get apply => 'Aplica';

  @override
  String get failedToApplyCode => 'No s\'ha pogut aplicar el codi';

  @override
  String get enterReferralCode => 'Introdueix codi de referència';

  @override
  String get codeAppliedPageTitle => 'Codi aplicat';

  @override
  String get changeYourReferralCode => 'Canvia el teu codi de referència';

  @override
  String get change => 'Canvia';

  @override
  String get unavailableReferralCode =>
      'Ho sentim, aquest codi no està disponible.';

  @override
  String get codeChangeLimitReached =>
      'Ho sentim, has assolit el límit de canvis de codi.';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'Si us plau, contacta amb $familyAdminEmail per canviar el teu codi.';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB';
  }

  @override
  String get claimed => 'Reclamat';

  @override
  String get details => 'Detalls';

  @override
  String get claimMore => 'Reclama més!';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return 'Ells també obtenen $storageAmountInGB GB';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB cada vegada que algú es registra per a un pla de pagament i aplica el teu codi';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'Codi de referència d\'Ente: $referralCode \n\nAplica\'l a Configuració → General → Referències per obtenir $referralStorageInGB GB gratis després de registrar-te per a un pla de pagament\n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => 'Reclama emmagatzematge gratuït';

  @override
  String get inviteYourFriends => 'Convida els teus amics';

  @override
  String get failedToFetchReferralDetails =>
      'No s\'han pogut obtenir els detalls de la referència. Si us plau, torna-ho a provar més tard.';

  @override
  String get referralStep1 => '1. Dona aquest codi als teus amics';

  @override
  String get referralStep2 => '2. Es registren per a un pla de pagament';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. Tots dos obteniu $storageInGB GB* gratis';
  }

  @override
  String get referralsAreCurrentlyPaused =>
      'Les referències estan actualment en pausa';

  @override
  String get youCanAtMaxDoubleYourStorage =>
      '* Pots com a màxim duplicar el teu emmagatzematge';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true': 'La teva família ha reclamat $storageAmountInGb GB fins ara',
      'false': 'Has reclamat $storageAmountInGb GB fins ara',
      'other': 'Has reclamat $storageAmountInGb GB fins ara!',
    });
    return '$_temp0';
  }

  @override
  String get faq => 'Preguntes freqüents';

  @override
  String get help => 'Ajuda';

  @override
  String get oopsSomethingWentWrong => 'Vaja, alguna cosa ha anat malament';

  @override
  String get peopleUsingYourCode => 'Persones utilitzant el teu codi';

  @override
  String get eligible => 'eligible';

  @override
  String get total => 'total';

  @override
  String get codeUsedByYou => 'Codi utilitzat per tu';

  @override
  String get freeStorageClaimed => 'Emmagatzematge gratuït reclamat';

  @override
  String get freeStorageUsable => 'Emmagatzematge gratuït utilitzable';

  @override
  String get usableReferralStorageInfo =>
      'L\'emmagatzematge utilitzable està limitat pel teu pla actual. L\'excés d\'emmagatzematge reclamat esdevindrà automàticament utilitzable quan milloris el teu pla.';

  @override
  String get removeFromAlbumTitle => 'Eliminar de l\'àlbum?';

  @override
  String get removeFromAlbum => 'Elimina de l\'àlbum';

  @override
  String get itemsWillBeRemovedFromAlbum =>
      'Els elements seleccionats s\'eliminaran d\'aquest àlbum';

  @override
  String get removeShareItemsWarning =>
      'Les fotos seleccionades no seran accessibles per a cap visualitzador d\'aquest àlbum, excepte els propietaris de les fotos.';

  @override
  String get addingToFavorites => 'Afegint a favorits...';

  @override
  String get removingFromFavorites => 'Eliminant de favorits...';

  @override
  String get sorryCouldNotAddToFavorites =>
      'Ho sentim, no s\'ha pogut afegir a favorits!';

  @override
  String get sorryCouldNotRemoveFromFavorites =>
      'Ho sentim, no s\'ha pogut eliminar de favorits!';

  @override
  String get subscribeToEnableSharing =>
      'Necessites una subscripció de pagament activa per activar la compartició.';

  @override
  String get subscribeToChangeLinkSetting =>
      'You need a paid subscription to change this link setting.';

  @override
  String get subscribe => 'Subscriu-te';

  @override
  String get canOnlyRemoveFilesOwnedByYou =>
      'Només pots eliminar fitxers que siguin teus';

  @override
  String get deleteSharedAlbum => 'Esborrar àlbum compartit?';

  @override
  String get deleteAlbum => 'Esborra àlbum';

  @override
  String get deleteAlbumDialog =>
      'Esborrar també les fotos (i vídeos) presents en aquest àlbum de <bold>tots</bold> els altres àlbums dels quals formen part?';

  @override
  String get deleteSharedAlbumDialogBody =>
      'L\'àlbum s\'esborrarà per a tothom\n\nPerdràs l\'accés a les fotos compartides en aquest àlbum que siguin propietat d\'altres';

  @override
  String get yesRemove => 'Sí, elimina';

  @override
  String get creatingLink => 'Creant enllaç...';

  @override
  String get removeWithQuestionMark => 'Eliminar?';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return '$userEmail s\'eliminarà d\'aquest àlbum compartit\n\nQualsevol foto afegida per ells també s\'eliminarà de l\'àlbum';
  }

  @override
  String get keepPhotos => 'Mantingues les fotos';

  @override
  String get deletePhotos => 'Esborra fotos';

  @override
  String get inviteToEnte => 'Convida a Ente';

  @override
  String get removePublicLink => 'Elimina enllaç públic';

  @override
  String disableLinkMessage({required Object albumName}) {
    return 'Això eliminarà l\'enllaç públic per accedir a \"$albumName\".';
  }

  @override
  String get sharing => 'Compartint...';

  @override
  String get youCannotShareWithYourself => 'No pots compartir amb tu mateix';

  @override
  String get archive => 'Arxiva';

  @override
  String get createAlbumActionHint =>
      'Fes una pressió llarga per seleccionar fotos i fes clic a + per crear un àlbum';

  @override
  String get importing => 'Importar....';

  @override
  String get failedToLoadAlbums => 'No s\'han pogut carregar els àlbums';

  @override
  String get hidden => 'Ocult';

  @override
  String get authToViewYourHiddenFiles =>
      'Si us plau, autentica\'t per veure els teus fitxers ocults';

  @override
  String get authToViewTrashedFiles =>
      'Si us plau, autentica\'t per veure els teus fitxers a la paperera';

  @override
  String get trash => 'Paperera';

  @override
  String get uncategorized => 'Sense categoria';

  @override
  String get videoSmallCase => 'vídeo';

  @override
  String get photoSmallCase => 'foto';

  @override
  String get singleFileDeleteHighlight => 'S\'eliminarà de tots els àlbums.';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return 'Aquest $fileType està tant a Ente com al teu dispositiu.';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return 'Aquest $fileType s\'eliminarà d\'Ente.';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return 'Aquest $fileType s\'eliminarà del teu dispositiu.';
  }

  @override
  String get deleteFromEnte => 'Esborra d\'Ente';

  @override
  String get yesDelete => 'Sí, esborra';

  @override
  String get movedToTrash => 'Mogut a la paperera';

  @override
  String get deleteFromDevice => 'Esborra del dispositiu';

  @override
  String get deleteFromBoth => 'Esborra de tots dos';

  @override
  String get newAlbum => 'Nou àlbum';

  @override
  String get albums => 'Àlbums';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount records',
      one: '$formattedCount record',
      zero: 'sense records',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return '$count seleccionats';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return '$count seleccionats ($yourCount teus)';
  }

  @override
  String get advancedSettings => 'Avançat';

  @override
  String get photoGridSize => 'Mida de la graella de fotos';

  @override
  String get manageDeviceStorage => 'Gestiona la memòria cau del dispositiu';

  @override
  String get manageDeviceStorageDesc =>
      'Revisa i neteja l\'emmagatzematge de la memòria cau local.';

  @override
  String get machineLearning => 'Aprenentatge automàtic';

  @override
  String get mlConsent => 'Activa aprenentatge automàtic';

  @override
  String get mlConsentTitle => 'Activar aprenentatge automàtic?';

  @override
  String get mlConsentDescription =>
      'Si actives l\'aprenentatge automàtic, Ente extreurà informació com la geometria facial dels fitxers, inclosos els compartits amb tu.\n\nAixò passarà al teu dispositiu, i qualsevol informació biomètrica generada estarà xifrada d\'extrem a extrem.';

  @override
  String get mlConsentPrivacy =>
      'Si us plau, fes clic aquí per a més detalls sobre aquesta funció a la nostra política de privadesa';

  @override
  String get mlConsentConfirmation =>
      'Ho entenc, i vull activar l\'aprenentatge automàtic';

  @override
  String get magicSearch => 'Cerca màgica';

  @override
  String get discover => 'Descobreix';

  @override
  String get discover_identity => 'Identitat';

  @override
  String get discover_screenshots => 'Captures de pantalla';

  @override
  String get discover_receipts => 'Rebuts';

  @override
  String get discover_notes => 'Notes';

  @override
  String get discover_memes => 'Mems';

  @override
  String get discover_visiting_cards => 'Targetes de visita';

  @override
  String get discover_babies => 'Bebès';

  @override
  String get discover_pets => 'Mascotes';

  @override
  String get discover_selfies => 'Selfies';

  @override
  String get discover_wallpapers => 'Fons de pantalla';

  @override
  String get discover_food => 'Menjar';

  @override
  String get discover_celebrations => 'Celebracions';

  @override
  String get discover_sunset => 'Posta de sol';

  @override
  String get discover_hills => 'Turons';

  @override
  String get discover_greenery => 'Verdor';

  @override
  String get mlIndexingDescription =>
      'Si us plau, tingues en compte que l\'aprenentatge automàtic resultarà en un major ús d\'ample de banda i bateria fins que tots els elements estiguin indexats. Considera utilitzar l\'aplicació d\'escriptori per a una indexació més ràpida, tots els resultats es sincronitzaran automàticament.';

  @override
  String get loadingModel => 'Descarregant models...';

  @override
  String get waitingForWifi => 'Esperant WiFi...';

  @override
  String get status => 'Estat';

  @override
  String get indexedItems => 'Elements indexats';

  @override
  String get pendingItems => 'Elements pendents';

  @override
  String get clearIndexes => 'Neteja índexs';

  @override
  String get selectFoldersForBackup =>
      'Selecciona carpetes per a còpia de seguretat';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      'Les carpetes seleccionades es xifraran i se\'n farà còpia de seguretat';

  @override
  String get unselectAll => 'Deselecciona tot';

  @override
  String get selectAll => 'Selecciona tot';

  @override
  String get skip => 'Omet';

  @override
  String get updatingFolderSelection => 'Actualitzant selecció de carpetes...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count elements',
      one: '$count element',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Esborra $count elements',
      one: 'Esborra $count element',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count fitxers, $formattedSize cadascun';
  }

  @override
  String get showMemories => 'Mostra records';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'fa $count anys',
      one: 'fa $count any',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'Configuració de còpia de seguretat';

  @override
  String get backupStatus => 'Estat de la còpia de seguretat';

  @override
  String get backupStatusDescription =>
      'Els elements dels quals s\'ha fet còpia de seguretat apareixeran aquí';

  @override
  String get backupOverMobileData => 'Còpia de seguretat amb dades mòbils';

  @override
  String get backupVideos => 'Còpia de seguretat de vídeos';

  @override
  String get disableAutoLock => 'Desactiva bloqueig automàtic';

  @override
  String get deviceLockExplanation =>
      'Desactiva el bloqueig de pantalla del dispositiu quan Ente està en primer pla i hi ha una còpia de seguretat en curs. Això normalment no és necessari, però pot ajudar a completar més ràpidament les pujades grans i les importacions inicials de biblioteques grans.';

  @override
  String get about => 'Sobre';

  @override
  String get weAreOpenSource => 'Som de codi obert!';

  @override
  String get privacy => 'Privadesa';

  @override
  String get terms => 'Termes';

  @override
  String get checkForUpdates => 'Comprova actualitzacions';

  @override
  String get checkStatus => 'Comprova estat';

  @override
  String get checking => 'Comprovant...';

  @override
  String get youAreOnTheLatestVersion => 'Estàs a l\'última versió';

  @override
  String get account => 'Compte';

  @override
  String get manageSubscription => 'Gestiona subscripció';

  @override
  String get authToChangeYourEmail =>
      'Si us plau, autentica\'t per canviar el teu correu';

  @override
  String get changePassword => 'Canvia la contrasenya';

  @override
  String get authToChangeYourPassword =>
      'Si us plau, autentica\'t per canviar la teva contrasenya';

  @override
  String get emailVerificationToggle => 'Verificació de correu';

  @override
  String get authToChangeEmailVerificationSetting =>
      'Si us plau, autentica\'t per canviar la configuració de verificació de correu';

  @override
  String get exportYourData => 'Exporta les teves dades';

  @override
  String get logout => 'Tanca sessió';

  @override
  String get authToInitiateAccountDeletion =>
      'Si us plau, autentica\'t per iniciar l\'eliminació del compte';

  @override
  String get areYouSureYouWantToLogout =>
      'Estàs segur que vols tancar la sessió?';

  @override
  String get yesLogout => 'Sí, tanca sessió';

  @override
  String get aNewVersionOfEnteIsAvailable =>
      'Una nova versió d\'Ente està disponible.';

  @override
  String get update => 'Actualitza';

  @override
  String get installManually => 'Instal·la manualment';

  @override
  String get criticalUpdateAvailable => 'Actualització crítica disponible';

  @override
  String get updateAvailable => 'Actualització disponible';

  @override
  String get ignoreUpdate => 'Ignora';

  @override
  String get downloading => 'Descarregant...';

  @override
  String get cannotDeleteSharedFiles =>
      'No es poden esborrar fitxers compartits';

  @override
  String get theDownloadCouldNotBeCompleted =>
      'La descàrrega no s\'ha pogut completar';

  @override
  String get retry => 'Reintenta';

  @override
  String get backedUpFolders => 'Carpetes amb còpia de seguretat';

  @override
  String get backup => 'Còpia de seguretat';

  @override
  String get freeUpDeviceSpace => 'Allibera espai al dispositiu';

  @override
  String get freeUpDeviceSpaceDesc =>
      'Estalvia espai al teu dispositiu netejant fitxers dels quals ja s\'ha fet còpia de seguretat.';

  @override
  String get allClear => '✨ Tot net';

  @override
  String get noDeviceThatCanBeDeleted =>
      'No tens fitxers en aquest dispositiu que es puguin esborrar';

  @override
  String get removeDuplicates => 'Elimina duplicats';

  @override
  String get removeDuplicatesDesc =>
      'Revisa i elimina fitxers que són duplicats exactes.';

  @override
  String get viewLargeFiles => 'Fitxers grans';

  @override
  String get viewLargeFilesDesc =>
      'Veure fitxers que estan consumint la major quantitat d\'emmagatzematge.';

  @override
  String get noDuplicates => '✨ Sense duplicats';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared =>
      'No tens cap fitxer duplicat que es pugui netejar';

  @override
  String get success => 'Èxit';

  @override
  String get rateUs => 'Valora\'ns';

  @override
  String get remindToEmptyDeviceTrash =>
      'També buida \"Eliminats recentment\" de \"Configuració\" -> \"Emmagatzematge\" per reclamar l\'espai alliberat';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return 'Has alliberat amb èxit $storageSaved!';
  }

  @override
  String get remindToEmptyEnteTrash =>
      'També buida la teva \"Paperera\" per reclamar l\'espai alliberat';

  @override
  String get sparkleSuccess => '✨ Èxit';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count fitxers duplicats',
      one: '$count fitxer duplicat',
    );
    return 'Has netejat $_temp0, estalviant ($storageSaved!)';
  }

  @override
  String get familyPlans => 'Plans familiars';

  @override
  String get referrals => 'Referències';

  @override
  String get notifications => 'Notificacions';

  @override
  String get sharedPhotoNotifications => 'Noves fotos compartides';

  @override
  String get sharedPhotoNotificationsExplanation =>
      'Rep notificacions quan algú afegeix una foto a un àlbum compartit del qual formes part';

  @override
  String get advanced => 'Avançat';

  @override
  String get general => 'General';

  @override
  String get security => 'Seguretat';

  @override
  String get authToViewYourRecoveryKey =>
      'Si us plau, autentica\'t per veure la teva clau de recuperació';

  @override
  String get twofactor => 'Doble factor';

  @override
  String get authToConfigureTwofactorAuthentication =>
      'Si us plau, autentica\'t per configurar l\'autenticació de doble factor';

  @override
  String get lockscreen => 'Pantalla de bloqueig';

  @override
  String get authToChangeLockscreenSetting =>
      'Si us plau, autentica\'t per canviar la configuració de la pantalla de bloqueig';

  @override
  String get viewActiveSessions => 'Veure sessions actives';

  @override
  String get authToViewYourActiveSessions =>
      'Si us plau, autentica\'t per veure les teves sessions actives';

  @override
  String get disableTwofactor => 'Desactiva doble factor';

  @override
  String get confirm2FADisable =>
      'Estàs segur que vols desactivar l\'autenticació de doble factor?';

  @override
  String get no => 'No';

  @override
  String get yes => 'Sí';

  @override
  String get social => 'Social';

  @override
  String rateUsOnStore({required Object storeName}) {
    return 'Valora\'ns a $storeName';
  }

  @override
  String get blog => 'Blog';

  @override
  String get merchandise => 'Marxandatge';

  @override
  String get twitter => 'Twitter';

  @override
  String get mastodon => 'Mastodon';

  @override
  String get matrix => 'Matrix';

  @override
  String get discord => 'Discord';

  @override
  String get reddit => 'Reddit';

  @override
  String get yourStorageDetailsCouldNotBeFetched =>
      'No s\'han pogut obtenir els detalls del teu emmagatzematge';

  @override
  String get reportABug => 'Informa d\'un error';

  @override
  String get reportBug => 'Informa d\'error';

  @override
  String get suggestFeatures => 'Suggereix funcionalitats';

  @override
  String get support => 'Suport';

  @override
  String get theme => 'Tema';

  @override
  String get lightTheme => 'Clar';

  @override
  String get darkTheme => 'Fosc';

  @override
  String get systemTheme => 'Sistema';

  @override
  String get freeTrial => 'Prova gratuïta';

  @override
  String get selectYourPlan => 'Selecciona el teu pla';

  @override
  String get enteSubscriptionPitch =>
      'Ente preserva els teus records, perquè estiguin sempre disponibles per a tu, fins i tot si perds el teu dispositiu.';

  @override
  String get enteSubscriptionShareWithFamily =>
      'La teva família també es pot afegir al teu pla.';

  @override
  String get currentUsageIs => 'L\'ús actual és ';

  @override
  String get faqs => 'Preguntes freqüents';

  @override
  String renewsOn({required Object endDate}) {
    return 'La subscripció es renova el $endDate';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return 'Prova gratuïta vàlida fins al $endDate';
  }

  @override
  String validTill({required Object endDate}) {
    return 'Vàlid fins al $endDate';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return 'El teu complement de $storageAmount és vàlid fins al $endDate';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return 'Prova gratuïta vàlida fins al $endDate.\nPots triar un pla de pagament després.';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'La teva subscripció es cancel·larà el $endDate';
  }

  @override
  String get subscription => 'Subscripció';

  @override
  String get paymentDetails => 'Detalls del pagament';

  @override
  String get manageFamily => 'Gestiona família';

  @override
  String contactToManageSubscription({required Object provider}) {
    return 'Si us plau, contacta amb nosaltres a support@ente.io per gestionar la teva subscripció de $provider.';
  }

  @override
  String get renewSubscription => 'Renova subscripció';

  @override
  String get cancelSubscription => 'Cancel·la subscripció';

  @override
  String get areYouSureYouWantToRenew => 'Estàs segur que vols renovar?';

  @override
  String get yesRenew => 'Sí, renova';

  @override
  String get areYouSureYouWantToCancel => 'Estàs segur que vols cancel·lar?';

  @override
  String get yesCancel => 'Sí, cancel·la';

  @override
  String get failedToRenew => 'No s\'ha pogut renovar';

  @override
  String get failedToCancel => 'No s\'ha pogut cancel·lar';

  @override
  String get twoMonthsFreeOnYearlyPlans => '2 mesos gratis en plans anuals';

  @override
  String get monthly => 'Mensual';

  @override
  String get yearly => 'Anual';

  @override
  String get confirmPlanChange => 'Confirma el canvi de pla';

  @override
  String get areYouSureYouWantToChangeYourPlan =>
      'Estàs segur que vols canviar el teu pla?';

  @override
  String get youCannotDowngradeToThisPlan => 'No pots baixar a aquest pla';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'Si us plau, cancel·la primer la teva subscripció existent de $paymentProvider';
  }

  @override
  String get optionalAsShortAsYouLike => 'Opcional, tan curt com vulguis...';

  @override
  String get send => 'Envia';

  @override
  String get askCancelReason =>
      'La teva subscripció s\'ha cancel·lat. T\'agradaria compartir la raó?';

  @override
  String get thankYouForSubscribing => 'Gràcies per subscriure\'t!';

  @override
  String get yourPurchaseWasSuccessful => 'La teva compra ha estat exitosa';

  @override
  String get yourPlanWasSuccessfullyUpgraded =>
      'El teu pla s\'ha millorat amb èxit';

  @override
  String get yourPlanWasSuccessfullyDowngraded =>
      'El teu pla s\'ha rebaixat amb èxit';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully =>
      'La teva subscripció s\'ha actualitzat amb èxit';

  @override
  String get googlePlayId => 'Google Play ID';

  @override
  String get appleId => 'Apple ID';

  @override
  String get playstoreSubscription => 'Subscripció de PlayStore';

  @override
  String get appstoreSubscription => 'Subscripció d\'AppStore';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return 'El teu $id ja està vinculat a un altre compte d\'Ente.\nSi vols utilitzar el teu $id amb aquest compte, si us plau contacta amb el nostre suport\'\'';
  }

  @override
  String get visitWebToManage =>
      'Si us plau, visita web.ente.io per gestionar la teva subscripció';

  @override
  String get couldNotUpdateSubscription =>
      'No s\'ha pogut actualitzar la subscripció';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      'Si us plau, contacta amb support@ente.io i estarem encantats d\'ajudar!';

  @override
  String get paymentFailed => 'El pagament ha fallat';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return 'Si us plau, parla amb el suport de $providerName si se t\'ha cobrat';
  }

  @override
  String get continueOnFreeTrial => 'Continua amb la prova gratuïta';

  @override
  String get areYouSureYouWantToExit => 'Estàs segur que vols sortir?';

  @override
  String get thankYou => 'Gràcies';

  @override
  String get failedToVerifyPaymentStatus =>
      'No s\'ha pogut verificar l\'estat del pagament';

  @override
  String get pleaseWaitForSometimeBeforeRetrying =>
      'Si us plau, espera una estona abans de tornar-ho a provar';

  @override
  String get paymentFailedMessage =>
      'Malauradament el teu pagament ha fallat. Si us plau, contacta amb suport i t\'ajudarem!';

  @override
  String get youAreOnAFamilyPlan => 'Estàs en un pla familiar!';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'Si us plau, contacta amb <green>$familyAdminEmail</green> per gestionar la teva subscripció';
  }

  @override
  String get leaveFamily => 'Deixa la família';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily =>
      'Estàs segur que vols deixar el pla familiar?';

  @override
  String get leave => 'Deixa';

  @override
  String get rateTheApp => 'Valora l\'aplicació';

  @override
  String get startBackup => 'Inicia còpia de seguretat';

  @override
  String get noPhotosAreBeingBackedUpRightNow =>
      'No s\'està fent còpia de seguretat de cap foto ara mateix';

  @override
  String get preserveMore => 'Preserva més';

  @override
  String get grantFullAccessPrompt =>
      'Si us plau, permet l\'accés a totes les fotos a l\'aplicació de Configuració';

  @override
  String get allowPermTitle => 'Permet l\'accés a les fotos';

  @override
  String get allowPermBody =>
      'Si us plau, permet l\'accés a les teves fotos des de Configuració perquè Ente pugui mostrar i fer còpia de seguretat de la teva biblioteca.';

  @override
  String get openSettings => 'Obre Configuració';

  @override
  String get selectMorePhotos => 'Selecciona més fotos';

  @override
  String get existingUser => 'Usuari existent';

  @override
  String get privateBackups => 'Còpies de seguretat privades';

  @override
  String get forYourMemories => 'pels teus records';

  @override
  String get endtoendEncryptedByDefault =>
      'Xifratge d\'extrem a extrem per defecte';

  @override
  String get safelyStored => 'Emmagatzematge segur';

  @override
  String get atAFalloutShelter => 'en un refugi nuclear';

  @override
  String get designedToOutlive => 'Dissenyat per perdurar';

  @override
  String get available => 'Disponible';

  @override
  String get everywhere => 'a tot arreu';

  @override
  String get androidIosWebDesktop => 'Android, iOS, Web, Escriptori';

  @override
  String get mobileWebDesktop => 'Mòbil, Web, Escriptori';

  @override
  String get newToEnte => 'Nou a Ente';

  @override
  String get pleaseLoginAgain => 'Si us plau, inicia sessió de nou';

  @override
  String get autoLogoutMessage =>
      'A causa d\'un error tècnic, s\'ha tancat la teva sessió. Les nostres disculpes per les molèsties.';

  @override
  String get yourSubscriptionHasExpired => 'La teva subscripció ha caducat';

  @override
  String get storageLimitExceeded => 'Límit d\'emmagatzematge superat';

  @override
  String get upgrade => 'Millora';

  @override
  String get raiseTicket => 'Obre tiquet';

  @override
  String get backupFailed => 'La còpia de seguretat ha fallat';

  @override
  String get sorryBackupFailedDesc =>
      'Ho sentim, no hem pogut fer còpia de seguretat d\'aquest fitxer ara mateix, ho reintentarem més tard.';

  @override
  String get couldNotBackUpTryLater =>
      'No hem pogut fer còpia de seguretat de les teves dades.\nHo reintentarem més tard.';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      'Ente només pot xifrar i preservar fitxers si li concedeixes accés a ells';

  @override
  String get pleaseGrantPermissions => 'Si us plau, concedeix permisos';

  @override
  String get grantPermission => 'Concedeix permís';

  @override
  String get privateSharing => 'Compartició privada';

  @override
  String get shareOnlyWithThePeopleYouWant =>
      'Comparteix només amb la gent que vulguis';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      'Utilitza enllaços públics per a gent que no està a Ente';

  @override
  String get allowPeopleToAddPhotos => 'Permet que la gent afegeixi fotos';

  @override
  String get shareAnAlbumNow => 'Comparteix un àlbum ara';

  @override
  String get collectEventPhotos => 'Recull fotos d\'esdeveniments';

  @override
  String get sessionExpired => 'Sessió caducada';

  @override
  String get loggingOut => 'Tancant sessió...';

  @override
  String get onDevice => 'Al dispositiu';

  @override
  String get onEnte => 'A <branding>ente</branding>';

  @override
  String get name => 'Nom';

  @override
  String get newest => 'Més nou';

  @override
  String get lastUpdated => 'Última actualització';

  @override
  String get deleteEmptyAlbums => 'Esborra àlbums buits';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => 'Esborrar àlbums buits?';

  @override
  String get deleteAlbumsDialogBody =>
      'Això esborrarà tots els àlbums buits. Això és útil quan vols reduir el desordre a la teva llista d\'àlbums.';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return 'Esborrant $currentlyDeleting / $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return 'Processant $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => 'Esborra permanentment';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou =>
      'Només pots crear enllaços per a fitxers que siguin teus';

  @override
  String get publicLinkCreated => 'Enllaç públic creat';

  @override
  String get youCanManageYourLinksInTheShareTab =>
      'Pots gestionar els teus enllaços a la pestanya de compartir.';

  @override
  String get linkCopiedToClipboard => 'Enllaç copiat al porta-retalls';

  @override
  String get restore => 'Restaura';

  @override
  String get moveToAlbum => 'Mou a l\'àlbum';

  @override
  String get unhide => 'Mostra';

  @override
  String get unarchive => 'Desarxiva';

  @override
  String get favorite => 'Favorit';

  @override
  String get removeFromFavorite => 'Elimina de favorits';

  @override
  String get shareLink => 'Comparteix enllaç';

  @override
  String get createCollage => 'Crea collage';

  @override
  String get saveCollage => 'Guarda collage';

  @override
  String get collageSaved => 'Collage guardat a la galeria';

  @override
  String get collageLayout => 'Disposició';

  @override
  String get addToEnte => 'Afegeix a Ente';

  @override
  String get addToAlbum => 'Afegeix a l\'àlbum';

  @override
  String get delete => 'Esborra';

  @override
  String get hide => 'Amaga';

  @override
  String get share => 'Comparteix';

  @override
  String get unhideToAlbum => 'Mostra a l\'àlbum';

  @override
  String get restoreToAlbum => 'Restaura a l\'àlbum';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Mou elements',
      one: 'Mou element',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Afegeix elements',
      one: 'Afegeix element',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'Crea o selecciona àlbum';

  @override
  String get selectAlbum => 'Selecciona àlbum';

  @override
  String get searchByAlbumNameHint => 'Nom de l\'àlbum';

  @override
  String get albumTitle => 'Títol de l\'àlbum';

  @override
  String get enterAlbumName => 'Introdueix nom de l\'àlbum';

  @override
  String get restoringFiles => 'Restaurant fitxers...';

  @override
  String get movingFilesToAlbum => 'Movent fitxers a l\'àlbum...';

  @override
  String get unhidingFilesToAlbum => 'Mostrant fitxers a l\'àlbum';

  @override
  String get canNotUploadToAlbumsOwnedByOthers =>
      'No es pot pujar a àlbums propietat d\'altres';

  @override
  String get uploadingFilesToAlbum => 'Pujant fitxers a l\'àlbum...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return 'Afegit amb èxit a $albumName';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return 'Mogut amb èxit a $albumName';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'Aquest àlbum ja té un enllaç col·laboratiu';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return 'Enllaç col·laboratiu creat per a $albumName';
  }

  @override
  String get askYourLovedOnesToShare =>
      'Demana als teus éssers estimats que comparteixin';

  @override
  String get invite => 'Convida';

  @override
  String get shareYourFirstAlbum => 'Comparteix el teu primer àlbum';

  @override
  String sharedWith({required Object emailIDs}) {
    return 'Compartit amb $emailIDs';
  }

  @override
  String get sharedWithMe => 'Compartit amb mi';

  @override
  String get sharedByMe => 'Compartit per mi';

  @override
  String get doubleYourStorage => 'Duplica el teu emmagatzematge';

  @override
  String get referFriendsAnd2xYourPlan =>
      'Referencia amics i duplica el teu pla';

  @override
  String get shareAlbumHint =>
      'Obre un àlbum i toca el botó de compartir a la part superior dreta per compartir.';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      'Els elements mostren el nombre de dies restants abans de l\'eliminació permanent';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count dies',
      one: '1 dia',
      zero: 'Aviat',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => 'Esborra tot';

  @override
  String get renameAlbum => 'Reanomena àlbum';

  @override
  String get convertToAlbum => 'Converteix a àlbum';

  @override
  String get setCover => 'Estableix portada';

  @override
  String get sortAlbumsBy => 'Ordena per';

  @override
  String get sortNewestFirst => 'Més nous primer';

  @override
  String get sortOldestFirst => 'Més antics primer';

  @override
  String get rename => 'Reanomena';

  @override
  String get leaveSharedAlbum => 'Deixar l\'àlbum compartit?';

  @override
  String get leaveAlbum => 'Deixa l\'àlbum';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'Les fotos afegides per tu s\'eliminaran de l\'àlbum';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted =>
      'No tens fitxers en aquest àlbum que es puguin esborrar';

  @override
  String get youDontHaveAnyArchivedItems => 'No tens cap element arxivat.';

  @override
  String get ignoredFolderUploadReason =>
      'Alguns fitxers en aquest àlbum s\'ignoren de la pujada perquè prèviament s\'havien esborrat d\'Ente.';

  @override
  String get resetIgnoredFiles => 'Restableix fitxers ignorats';

  @override
  String get deviceFilesAutoUploading =>
      'Els fitxers afegits a aquest àlbum del dispositiu es pujaran automàticament a Ente.';

  @override
  String get turnOnBackupForAutoUpload =>
      'Activa la còpia de seguretat per pujar automàticament els fitxers afegits a aquesta carpeta del dispositiu a Ente.';

  @override
  String get noHiddenPhotosOrVideos => 'No hi ha fotos o vídeos ocults';

  @override
  String get toHideAPhotoOrVideo => 'Per amagar una foto o vídeo';

  @override
  String get openTheItem => '• Obre l\'element';

  @override
  String get clickOnTheOverflowMenu => '• Fes clic al menú desbordant';

  @override
  String get click => '• Fes clic';

  @override
  String get nothingToSeeHere => 'Res a veure aquí! 👀';

  @override
  String get unarchiveAlbum => 'Desarxiva àlbum';

  @override
  String get archiveAlbum => 'Arxiva àlbum';

  @override
  String get calculating => 'Calculant...';

  @override
  String get pleaseWaitDeletingAlbum => 'Si us plau, espera, esborrant àlbum';

  @override
  String get searchByExamples =>
      '• Noms d\'àlbum (p. ex. \"Càmera\")\n• Tipus de fitxers (p. ex. \"Vídeos\", \".gif\")\n• Anys i mesos (p. ex. \"2022\", \"Gener\")\n• Festius (p. ex. \"Nadal\")\n• Descripcions de fotos (p. ex. “#divertit”)';

  @override
  String get youCanTrySearchingForADifferentQuery =>
      'Pots intentar cercar una consulta diferent.';

  @override
  String get noResultsFound => 'No s\'han trobat resultats';

  @override
  String addedBy({required Object emailOrName}) {
    return 'Afegit per $emailOrName';
  }

  @override
  String get loadingExifData => 'Carregant dades EXIF...';

  @override
  String get viewAllExifData => 'Veure totes les dades EXIF';

  @override
  String get noExifData => 'Sense dades EXIF';

  @override
  String get thisImageHasNoExifData => 'Aquesta imatge no té dades exif';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => 'Sense resultats';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'Encara no suportem l\'edició de fotos i àlbums que no són teus';

  @override
  String get failedToFetchOriginalForEdit =>
      'No s\'ha pogut obtenir l\'original per editar';

  @override
  String get close => 'Tanca';

  @override
  String get setAs => 'Estableix com a';

  @override
  String get fileSavedToGallery => 'Fitxer guardat a la galeria';

  @override
  String get filesSavedToGallery => 'Fitxers guardats a la galeria';

  @override
  String get fileFailedToSaveToGallery =>
      'No s\'ha pogut guardar el fitxer a la galeria';

  @override
  String get download => 'Descarrega';

  @override
  String get pressAndHoldToPlayVideo => 'Prem i mantén per reproduir vídeo';

  @override
  String get pressAndHoldToPlayVideoDetailed =>
      'Prem i mantén a la imatge per reproduir vídeo';

  @override
  String get downloadFailed => 'Descàrrega fallida';

  @override
  String get deduplicateFiles => 'Desduplica fitxers';

  @override
  String get deselectAll => 'Deselecciona tot';

  @override
  String get reviewDeduplicateItems =>
      'Si us plau, revisa i esborra els elements que creguis que són duplicats.';

  @override
  String get clubByCaptureTime => 'Agrupa per hora de captura';

  @override
  String get clubByFileName => 'Agrupa per nom de fitxer';

  @override
  String get count => 'Recompte';

  @override
  String get totalSize => 'Mida total';

  @override
  String get longpressOnAnItemToViewInFullscreen =>
      'Fes una pressió llarga sobre un element per veure\'l a pantalla completa';

  @override
  String get decryptingVideo => 'Desxifrant vídeo...';

  @override
  String get authToViewYourMemories =>
      'Si us plau, autentica\'t per veure els teus records';

  @override
  String get unlock => 'Desbloqueja';

  @override
  String get freeUpSpace => 'Allibera espai';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Es poden esborrar del dispositiu per alliberar $formattedSize',
      one: 'Es pot esborrar del dispositiu per alliberar $formattedSize',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber fitxers',
      one: '1 fitxer',
    );
    return '$_temp0 en aquest àlbum s\'han copiat de manera segura';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber fitxers',
      one: '1 fitxer',
    );
    return '$_temp0 en aquest dispositiu s\'han copiat de manera segura';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'ells',
      one: 'ell',
    );
    return 'Encara podràs accedir a $_temp0 a Ente mentre tinguis una subscripció activa';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return 'Allibera $sizeInMBorGB';
  }

  @override
  String get thisEmailIsAlreadyInUse => 'Aquest correu ja està en ús';

  @override
  String get incorrectCode => 'Codi incorrecte';

  @override
  String get authenticationFailedPleaseTryAgain =>
      'Autenticació fallida, si us plau torna-ho a provar';

  @override
  String get verificationFailedPleaseTryAgain =>
      'Verificació fallida, si us plau torna-ho a provar';

  @override
  String get authenticating => 'Autenticant...';

  @override
  String get authenticationSuccessful => 'Autenticació exitosa!';

  @override
  String get incorrectRecoveryKey => 'Clau de recuperació incorrecta';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect =>
      'La clau de recuperació que has introduït és incorrecta';

  @override
  String get twofactorAuthenticationSuccessfullyReset =>
      'Autenticació de doble factor restablerta amb èxit';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered =>
      'Si us plau, verifica el codi que has introduït';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      'Si us plau, contacta amb suport si el problema persisteix';

  @override
  String get twofactorAuthenticationHasBeenDisabled =>
      'L\'autenticació de doble factor ha estat desactivada';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect =>
      'Ho sentim, el codi que has introduït és incorrecte';

  @override
  String get yourVerificationCodeHasExpired =>
      'El teu codi de verificació ha caducat';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'Correu canviat a $newEmail';
  }

  @override
  String get verifying => 'Verificant...';

  @override
  String get disablingTwofactorAuthentication =>
      'Desactivant l\'autenticació de doble factor...';

  @override
  String get allMemoriesPreserved => 'Tots els records preservats';

  @override
  String get loadingGallery => 'Carregant galeria...';

  @override
  String get syncing => 'Sincronitzant...';

  @override
  String get encryptingBackup => 'Xifrant còpia de seguretat...';

  @override
  String get syncStopped => 'Sincronització aturada';

  @override
  String syncProgress({required String completed, required String total}) {
    return '$completed/$total records preservats';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return 'Preservant $count records...';
  }

  @override
  String get uploadingSingleMemory => 'Preservant 1 record...';

  @override
  String get archiving => 'Arxivant...';

  @override
  String get unarchiving => 'Desarxivant...';

  @override
  String get successfullyArchived => 'Arxivat amb èxit';

  @override
  String get successfullyUnarchived => 'Desarxivat amb èxit';

  @override
  String get renameFile => 'Reanomena fitxer';

  @override
  String get enterFileName => 'Introdueix nom del fitxer';

  @override
  String get filesDeleted => 'Fitxers esborrats';

  @override
  String get selectedFilesAreNotOnEnte =>
      'Els fitxers seleccionats no estan a Ente';

  @override
  String get thisActionCannotBeUndone => 'Aquesta acció no es pot desfer';

  @override
  String get emptyTrash => 'Buidar paperera?';

  @override
  String get permDeleteWarning =>
      'Tots els elements de la paperera s\'esborraran permanentment\n\nAquesta acció no es pot desfer';

  @override
  String get empty => 'Buida';

  @override
  String get couldNotFreeUpSpace => 'No s\'ha pogut alliberar espai';

  @override
  String get permanentlyDeleteFromDevice =>
      'Esborrar permanentment del dispositiu?';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      'Alguns dels fitxers que intentes esborrar només estan disponibles al teu dispositiu i no es poden recuperar si s\'esborren';

  @override
  String get theyWillBeDeletedFromAllAlbums =>
      'S\'eliminaran de tots els àlbums.';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'Alguns elements estan tant a Ente com al teu dispositiu.';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      'Els elements seleccionats s\'eliminaran de tots els àlbums i es mouran a la paperera.';

  @override
  String get theseItemsWillBeDeletedFromYourDevice =>
      'Aquests elements s\'eliminaran del teu dispositiu.';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      'Sembla que alguna cosa ha anat malament. Si us plau, torna-ho a provar després d\'una estona. Si l\'error persisteix, si us plau contacta amb el nostre equip de suport.';

  @override
  String get error => 'Error';

  @override
  String get tempErrorContactSupportIfPersists =>
      'Sembla que alguna cosa ha anat malament. Si us plau, torna-ho a provar després d\'una estona. Si l\'error persisteix, si us plau contacta amb el nostre equip de suport.';

  @override
  String get networkHostLookUpErr =>
      'No s\'ha pogut connectar a Ente, si us plau comprova la teva configuració de xarxa i contacta amb suport si l\'error persisteix.';

  @override
  String get networkConnectionRefusedErr =>
      'No s\'ha pogut connectar a Ente, si us plau torna-ho a provar després d\'una estona. Si l\'error persisteix, si us plau contacta amb suport.';

  @override
  String get cachedData => 'Dades en memòria cau';

  @override
  String get clearCaches => 'Neteja memòries cau';

  @override
  String get remoteImages => 'Imatges remotes';

  @override
  String get remoteVideos => 'Vídeos remots';

  @override
  String get remoteThumbnails => 'Miniatures remotes';

  @override
  String get pendingSync => 'Sincronització pendent';

  @override
  String get localGallery => 'Galeria local';

  @override
  String get todaysLogs => 'Registres d\'avui';

  @override
  String get viewLogs => 'Veure registres';

  @override
  String get logsDialogBody =>
      'Això enviarà els registres per ajudar-nos a depurar el teu problema. Si us plau, tingues en compte que els noms dels fitxers s\'inclouran per ajudar a rastrejar problemes amb fitxers específics.';

  @override
  String get preparingLogs => 'Preparant registres...';

  @override
  String get emailYourLogs => 'Envia els teus registres per correu';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'Si us plau, envia els registres a \n$toEmail';
  }

  @override
  String get copyEmailAddress => 'Copia adreça de correu';

  @override
  String get exportLogs => 'Exporta registres';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return 'Si us plau, envia\'ns un correu a $toEmail';
  }

  @override
  String get dismiss => 'Descarta';

  @override
  String get didYouKnow => 'Sabies que?';

  @override
  String get loadingMessage => 'Carregant les teves fotos...';

  @override
  String get loadMessage1 =>
      'Pots compartir la teva subscripció amb la teva família';

  @override
  String get loadMessage2 =>
      'Hem preservat més de 200 milions de records fins ara';

  @override
  String get loadMessage3 =>
      'Guardem 3 còpies de les teves dades, una en un refugi nuclear subterrani';

  @override
  String get loadMessage4 => 'Totes les nostres aplicacions són de codi obert';

  @override
  String get loadMessage5 =>
      'El nostre codi font i criptografia han estat auditats externament';

  @override
  String get loadMessage6 =>
      'Pots compartir enllaços als teus àlbums amb els teus éssers estimats';

  @override
  String get loadMessage7 =>
      'Les nostres aplicacions mòbils s\'executen en segon pla per xifrar i fer còpia de seguretat de qualsevol foto nova que facis';

  @override
  String get loadMessage8 => 'web.ente.io té un carregador elegant';

  @override
  String get loadMessage9 =>
      'Utilitzem Xchacha20Poly1305 per xifrar de manera segura les teves dades';

  @override
  String get photoDescriptions => 'Descripcions de fotos';

  @override
  String get fileTypesAndNames => 'Tipus i noms de fitxers';

  @override
  String get location => 'Ubicació';

  @override
  String get moments => 'Moments';

  @override
  String get searchFaceEmptySection =>
      'La gent es mostrarà aquí un cop finalitzada la indexació';

  @override
  String get searchDatesEmptySection => 'Cerca per data, mes o any';

  @override
  String get searchLocationEmptySection =>
      'Agrupa fotos que s\'han fet dins d\'un cert radi d\'una foto';

  @override
  String get searchPeopleEmptySection =>
      'Convida gent, i veuràs totes les fotos compartides per ells aquí';

  @override
  String get searchAlbumsEmptySection => 'Àlbums';

  @override
  String get searchFileTypesAndNamesEmptySection => 'Tipus i noms de fitxers';

  @override
  String get searchCaptionEmptySection =>
      'Afegeix descripcions com \"#viatge\" a la informació de la foto per trobar-les ràpidament aquí';

  @override
  String get language => 'Idioma';

  @override
  String get selectLanguage => 'Selecciona idioma';

  @override
  String get locationName => 'Nom de la ubicació';

  @override
  String get addLocation => 'Afegeix ubicació';

  @override
  String get groupNearbyPhotos => 'Agrupa fotos properes';

  @override
  String get kiloMeterUnit => 'km';

  @override
  String get addLocationButton => 'Afegeix';

  @override
  String get radius => 'Radi';

  @override
  String get locationTagFeatureDescription =>
      'Una etiqueta d\'ubicació agrupa totes les fotos que s\'han fet dins d\'un cert radi d\'una foto';

  @override
  String get galleryMemoryLimitInfo =>
      'Fins a 1000 records mostrats a la galeria';

  @override
  String get save => 'Guarda';

  @override
  String get centerPoint => 'Punt central';

  @override
  String get pickCenterPoint => 'Tria punt central';

  @override
  String get useSelectedPhoto => 'Utilitza foto seleccionada';

  @override
  String get resetToDefault => 'Restableix a per defecte';

  @override
  String get edit => 'Edita';

  @override
  String get deleteLocation => 'Esborra ubicació';

  @override
  String get rotateLeft => 'Rota a l\'esquerra';

  @override
  String get flip => 'Gira';

  @override
  String get rotateRight => 'Rota a la dreta';

  @override
  String get saveCopy => 'Guarda còpia';

  @override
  String get light => 'Llum';

  @override
  String get color => 'Color';

  @override
  String get yesDiscardChanges => 'Sí, descarta canvis';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade =>
      'Vols descartar les edicions que has fet?';

  @override
  String get saving => 'Guardant...';

  @override
  String get editsSaved => 'Edicions guardades';

  @override
  String get oopsCouldNotSaveEdits =>
      'Vaja, no s\'han pogut guardar les edicions';

  @override
  String get distanceInKMUnit => 'km';

  @override
  String get dayToday => 'Avui';

  @override
  String get dayYesterday => 'Ahir';

  @override
  String get storage => 'Emmagatzematge';

  @override
  String get usedSpace => 'Espai utilitzat';

  @override
  String get storageBreakupFamily => 'Família';

  @override
  String get storageBreakupYou => 'Tu';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return '$usedAmount $usedStorageUnit de $totalAmount $totalStorageUnit utilitzats';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return '$freeAmount $storageUnit lliures';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'Versió: $versionValue';
  }

  @override
  String get verifyIDLabel => 'Verifica';

  @override
  String get fileInfoAddDescHint => 'Afegeix una descripció...';

  @override
  String get editLocationTagTitle => 'Edita ubicació';

  @override
  String get setLabel => 'Estableix';

  @override
  String get setRadius => 'Estableix radi';

  @override
  String get familyPlanPortalTitle => 'Família';

  @override
  String get familyPlanOverview =>
      'Afegeix 5 membres de la família al teu pla existent sense pagar extra.\n\nCada membre obté el seu propi espai privat, i no pot veure els fitxers dels altres a menys que es comparteixin.\n\nEls plans familiars estan disponibles per als clients que tenen una subscripció de pagament d\'Ente.\n\nSubscriu-te ara per començar!';

  @override
  String get androidBiometricHint => 'Verifica identitat';

  @override
  String get androidBiometricNotRecognized =>
      'No reconegut. Torna-ho a provar.';

  @override
  String get androidBiometricSuccess => 'Èxit';

  @override
  String get androidCancelButton => 'Cancel·la';

  @override
  String get androidSignInTitle => 'Autenticació requerida';

  @override
  String get androidBiometricRequiredTitle => 'Biometria requerida';

  @override
  String get androidDeviceCredentialsRequiredTitle =>
      'Credencials del dispositiu requerides';

  @override
  String get androidDeviceCredentialsSetupDescription =>
      'Credencials del dispositiu requerides';

  @override
  String get goToSettings => 'Ves a configuració';

  @override
  String get androidGoToSettingsDescription =>
      'L\'autenticació biomètrica no està configurada al teu dispositiu. Ves a \'Configuració > Seguretat\' per afegir autenticació biomètrica.';

  @override
  String get iOSLockOut =>
      'L\'autenticació biomètrica està desactivada. Si us plau, bloqueja i desbloqueja la teva pantalla per activar-la.';

  @override
  String get iOSGoToSettingsDescription =>
      'L\'autenticació biomètrica no està configurada al teu dispositiu. Si us plau, activa Touch ID o Face ID al teu telèfon.';

  @override
  String get iOSOkButton => 'D\'acord';

  @override
  String get openstreetmapContributors => 'Col·laboradors d\'OpenStreetMap';

  @override
  String get hostedAtOsmFrance => 'Allotjat a OSM França';

  @override
  String get map => 'Mapa';

  @override
  String get maps => 'Mapes';

  @override
  String get mapsPrivacyNotice =>
      'Les coordenades aproximades s\'enviaran a tercers conscients de la privadesa com OpenStreetMap per mostrar el mapa i la ubicació.';

  @override
  String get enableMaps => 'Activa Mapes';

  @override
  String get quickLinks => 'Enllaços ràpids';

  @override
  String get selectItemsToAdd => 'Selecciona elements per afegir';

  @override
  String get addSelected => 'Afegeix seleccionats';

  @override
  String get addFromDevice => 'Afegeix des del dispositiu';

  @override
  String get addPhotos => 'Afegeix fotos';

  @override
  String get noPhotosFoundHere => 'No s\'han trobat fotos aquí';

  @override
  String get zoomOutToSeePhotos => 'Allunya per veure fotos';

  @override
  String get noImagesWithLocation => 'No hi ha imatges amb ubicació';

  @override
  String get unpinAlbum => 'Desfixa àlbum';

  @override
  String get pinAlbum => 'Fixa àlbum';

  @override
  String get pin => 'Fixa';

  @override
  String get pinPerson => 'Pin person';

  @override
  String get pinToTop => 'Fixa a dalt';

  @override
  String get unpin => 'Desfixa';

  @override
  String get unpinPerson => 'Unpin person';

  @override
  String get visibility => 'Visibilitat';

  @override
  String get hideFromMemories => 'Amaga dels records';

  @override
  String get showInMemories => 'Show in memories';

  @override
  String get create => 'Crea';

  @override
  String get viewAll => 'Veure tot';

  @override
  String get nothingSharedWithYouYet => 'Encara no s\'ha compartit res amb tu';

  @override
  String get noAlbumsSharedByYouYet => 'Encara no has compartit cap àlbum';

  @override
  String get sharedWithYou => 'Compartit amb tu';

  @override
  String get sharedByYou => 'Compartit per tu';

  @override
  String get inviteYourFriendsToEnte => 'Convida els teus amics a Ente';

  @override
  String get failedToDownloadVideo => 'No s\'ha pogut descarregar el vídeo';

  @override
  String get hiding => 'Amagant...';

  @override
  String get unhiding => 'Mostrant...';

  @override
  String get successfullyHid => 'Amagat amb èxit';

  @override
  String get successfullyUnhid => 'Mostrat amb èxit';

  @override
  String get crashReporting => 'Informe d\'errors';

  @override
  String get resumableUploads => 'Pujades reprenibles';

  @override
  String get addToHiddenAlbum => 'Afegeix a l\'àlbum ocult';

  @override
  String get moveToHiddenAlbum => 'Mou a l\'àlbum ocult';

  @override
  String get fileTypes => 'Tipus de fitxers';

  @override
  String get deleteConfirmDialogBody =>
      'Aquest compte està vinculat a altres aplicacions d\'Ente, si en fas servir alguna. Les teves dades pujades, a través de totes les aplicacions d\'Ente, es programaran per a l\'eliminació, i el teu compte s\'esborrarà permanentment.';

  @override
  String get hearUsWhereTitle => 'Com has conegut Ente? (opcional)';

  @override
  String get hearUsExplanation =>
      'No rastregem les instal·lacions de l\'aplicació. Ens ajudaria que ens diguessis on ens has trobat!';

  @override
  String get viewAddOnButton => 'Veure complements';

  @override
  String get addOns => 'Complements';

  @override
  String get addOnPageSubtitle => 'Detalls dels complements';

  @override
  String get yourMap => 'El teu mapa';

  @override
  String get modifyYourQueryOrTrySearchingFor =>
      'Modifica la teva consulta, o intenta cercar';

  @override
  String get blackFridaySale => 'Venda de Black Friday';

  @override
  String get upto50OffUntil4thDec =>
      'Fins a un 50% de descompte, fins al 4 de desembre.';

  @override
  String get photos => 'Fotos';

  @override
  String get videos => 'Vídeos';

  @override
  String get livePhotos => 'Live Photos';

  @override
  String get searchHint1 => 'Cerca ràpida al dispositiu';

  @override
  String get searchHint2 => 'Dates de fotos, descripcions';

  @override
  String get searchHint3 => 'Àlbums, noms de fitxers i tipus';

  @override
  String get searchHint4 => 'Ubicació';

  @override
  String get searchHint5 => 'Properament: Cares i cerca màgica ✨';

  @override
  String get addYourPhotosNow => 'Afegeix les teves fotos ara';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count resultats trobats',
      one: '$count resultat trobat',
    );
    return '$_temp0';
  }

  @override
  String get faces => 'Cares';

  @override
  String get people => 'Gent';

  @override
  String get contents => 'Continguts';

  @override
  String get addNew => 'Afegeix nou';

  @override
  String get contacts => 'Contactes';

  @override
  String get noInternetConnection => 'Sense connexió a internet';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'Si us plau, comprova la teva connexió a internet i torna-ho a provar.';

  @override
  String get signOutFromOtherDevices => 'Tanca sessió d\'altres dispositius';

  @override
  String get signOutOtherBody =>
      'Si creus que algú pot saber la teva contrasenya, pots forçar que tots els altres dispositius que utilitzen el teu compte tanquin la sessió.';

  @override
  String get signOutOtherDevices => 'Tanca sessió d\'altres dispositius';

  @override
  String get doNotSignOut => 'No tanquis sessió';

  @override
  String get editLocation => 'Edita ubicació';

  @override
  String get selectALocation => 'Selecciona una ubicació';

  @override
  String get selectALocationFirst => 'Selecciona una ubicació primer';

  @override
  String get changeLocationOfSelectedItems =>
      'Canviar la ubicació dels elements seleccionats?';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte =>
      'Les edicions a la ubicació només es veuran dins d\'Ente';

  @override
  String get cleanUncategorized => 'Neteja Sense categoria';

  @override
  String get cleanUncategorizedDescription =>
      'Elimina tots els fitxers de Sense categoria que estiguin presents en altres àlbums';

  @override
  String get waitingForVerification => 'Esperant verificació...';

  @override
  String get passkey => 'Clau d\'accés';

  @override
  String get passkeyAuthTitle => 'Verificació de clau d\'accés';

  @override
  String get loginWithTOTP => 'Inicia sessió amb TOTP';

  @override
  String get passKeyPendingVerification => 'La verificació encara està pendent';

  @override
  String get loginSessionExpired => 'Sessió caducada';

  @override
  String get loginSessionExpiredDetails =>
      'La teva sessió ha caducat. Si us plau, inicia sessió de nou.';

  @override
  String get verifyPasskey => 'Verifica clau d\'accés';

  @override
  String get playOnTv => 'Reprodueix àlbum a la TV';

  @override
  String get pair => 'Aparella';

  @override
  String get deviceNotFound => 'Dispositiu no trobat';

  @override
  String get castInstruction =>
      'Visita cast.ente.io al dispositiu que vols aparellar.\n\nIntrodueix el codi de sota per reproduir l\'àlbum a la teva TV.';

  @override
  String get deviceCodeHint => 'Introdueix el codi';

  @override
  String get joinDiscord => 'Uneix-te a Discord';

  @override
  String get locations => 'Ubicacions';

  @override
  String get addAName => 'Afegeix un nom';

  @override
  String get findThemQuickly => 'Troba\'ls ràpidament';

  @override
  String get findPeopleByName => 'Troba gent ràpidament per nom';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Afegeix visualitzadors',
      one: 'Afegeix visualitzador',
      zero: 'Afegeix visualitzador',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Afegeix col·laboradors',
      one: 'Afegeix col·laborador',
      zero: 'Afegeix col·laborador',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      'Fes una pressió llarga sobre un correu per verificar el xifratge d\'extrem a extrem.';

  @override
  String get developerSettingsWarning =>
      'Estàs segur que vols modificar la configuració de desenvolupador?';

  @override
  String get developerSettings => 'Configuració de desenvolupador';

  @override
  String get serverEndpoint => 'Punt final del servidor';

  @override
  String get invalidEndpoint => 'Punt final invàlid';

  @override
  String get invalidEndpointMessage =>
      'Ho sentim, el punt final que has introduït és invàlid. Si us plau, introdueix un punt final vàlid i torna-ho a provar.';

  @override
  String get endpointUpdatedMessage => 'Punt final actualitzat amb èxit';

  @override
  String customEndpoint({required Object endpoint}) {
    return 'Connectat a $endpoint';
  }

  @override
  String get createCollaborativeLink => 'Crea enllaç col·laboratiu';

  @override
  String get search => 'Cerca';

  @override
  String get enterPersonName => 'Introdueix nom de la persona';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'Aquest correu ja està vinculat a $name.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return 'Veure $name per desvincular';
  }

  @override
  String get enterName => 'Introdueix nom';

  @override
  String get savePerson => 'Guarda persona';

  @override
  String get editPerson => 'Edita persona';

  @override
  String get mergedPhotos => 'Fotos fusionades';

  @override
  String get orMergeWithExistingPerson => 'O fusiona amb existent';

  @override
  String get enterDateOfBirth => 'Aniversari (opcional)';

  @override
  String get birthday => 'Aniversari';

  @override
  String get removePersonLabel => 'Elimina etiqueta de persona';

  @override
  String get removePersonTag => 'Remove person tag';

  @override
  String get areYouSureRemoveThisPersonTag =>
      'Are you sure you want to remove this person tag?';

  @override
  String get autoPairDesc =>
      'L\'aparellament automàtic només funciona amb dispositius que suporten Chromecast.';

  @override
  String get manualPairDesc =>
      'L\'aparellament amb PIN funciona amb qualsevol pantalla on vulguis veure el teu àlbum.';

  @override
  String get connectToDevice => 'Connecta al dispositiu';

  @override
  String get autoCastDialogBody =>
      'Veuràs els dispositius Cast disponibles aquí.';

  @override
  String get autoCastiOSPermission =>
      'Assegura\'t que els permisos de Xarxa Local estiguin activats per a l\'aplicació Ente Photos, a Configuració.';

  @override
  String get noDeviceFound => 'No s\'ha trobat cap dispositiu';

  @override
  String get stopCastingTitle => 'Atura la transmissió';

  @override
  String get stopCastingBody => 'Vols aturar la transmissió?';

  @override
  String get castIPMismatchTitle => 'No s\'ha pogut transmetre l\'àlbum';

  @override
  String get castIPMismatchBody =>
      'Si us plau, assegura\'t que estàs a la mateixa xarxa que la TV.';

  @override
  String get pairingComplete => 'Aparellament complet';

  @override
  String get savingEdits => 'Guardant edicions...';

  @override
  String get autoPair => 'Aparellament automàtic';

  @override
  String get pairWithPin => 'Aparella amb PIN';

  @override
  String get faceRecognition => 'Reconeixement facial';

  @override
  String get foundFaces => 'Cares trobades';

  @override
  String get clusteringProgress => 'Progrés d\'agrupament';

  @override
  String get trim => 'Retalla';

  @override
  String get crop => 'Retalla';

  @override
  String get rotate => 'Rota';

  @override
  String get left => 'Esquerra';

  @override
  String get right => 'Dreta';

  @override
  String get whatsNew => 'Novetats';

  @override
  String get reviewSuggestions => 'Revisa suggeriments';

  @override
  String get review => 'Revisa';

  @override
  String get useAsCover => 'Utilitza com a portada';

  @override
  String notPersonLabel({required String name}) {
    return 'No és $name?';
  }

  @override
  String get enable => 'Activa';

  @override
  String get enabled => 'Activat';

  @override
  String get moreDetails => 'Més detalls';

  @override
  String get enableMLIndexingDesc =>
      'Ente suporta aprenentatge automàtic al dispositiu per al reconeixement facial, cerca màgica i altres funcions de cerca avançades';

  @override
  String get magicSearchHint =>
      'La cerca màgica permet cercar fotos pel seu contingut, p. ex. \'flor\', \'cotxe vermell\', \'documents d\'identitat\'';

  @override
  String get panorama => 'Panorama';

  @override
  String get reenterPassword => 'Torna a introduir la contrasenya';

  @override
  String get reenterPin => 'Torna a introduir el PIN';

  @override
  String get deviceLock => 'Bloqueig del dispositiu';

  @override
  String get pinLock => 'Bloqueig amb PIN';

  @override
  String get next => 'Següent';

  @override
  String get setNewPassword => 'Estableix nova contrasenya';

  @override
  String get enterPin => 'Introdueix PIN';

  @override
  String get setNewPin => 'Estableix nou PIN';

  @override
  String get appLock => 'Bloqueig d\'aplicació';

  @override
  String get noSystemLockFound => 'No s\'ha trobat bloqueig del sistema';

  @override
  String get tapToUnlock => 'Toca per desbloquejar';

  @override
  String get tooManyIncorrectAttempts => 'Massa intents incorrectes';

  @override
  String get videoInfo => 'Informació del vídeo';

  @override
  String get autoLock => 'Bloqueig automàtic';

  @override
  String get immediately => 'Immediatament';

  @override
  String get autoLockFeatureDescription =>
      'Temps després del qual l\'aplicació es bloqueja després de posar-se en segon pla';

  @override
  String get hideContent => 'Amaga contingut';

  @override
  String get hideContentDescriptionAndroid =>
      'Amaga el contingut de l\'aplicació al selector d\'aplicacions i desactiva les captures de pantalla';

  @override
  String get hideContentDescriptionIos =>
      'Amaga el contingut de l\'aplicació al selector d\'aplicacions';

  @override
  String get passwordStrengthInfo =>
      'La força de la contrasenya es calcula considerant la longitud de la contrasenya, els caràcters utilitzats i si la contrasenya apareix o no a les 10.000 contrasenyes més utilitzades';

  @override
  String get noQuickLinksSelected => 'No s\'han seleccionat enllaços ràpids';

  @override
  String get pleaseSelectQuickLinksToRemove =>
      'Si us plau, selecciona enllaços ràpids per eliminar';

  @override
  String get removePublicLinks => 'Elimina enllaços públics';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      'Això eliminarà els enllaços públics de tots els enllaços ràpids seleccionats.';

  @override
  String get guestView => 'Vista de convidat';

  @override
  String get guestViewEnablePreSteps =>
      'Per activar la vista de convidat, si us plau configura el codi d\'accés del dispositiu o el bloqueig de pantalla a la configuració del sistema.';

  @override
  String get nameTheAlbum => 'Posa nom a l\'àlbum';

  @override
  String get collectPhotosDescription =>
      'Crea un enllaç on els teus amics puguin pujar fotos en qualitat original.';

  @override
  String get collect => 'Recull';

  @override
  String get appLockDescriptions =>
      'Tria entre la pantalla de bloqueig per defecte del teu dispositiu i una pantalla de bloqueig personalitzada amb un PIN o contrasenya.';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'Per activar el bloqueig d\'aplicació, si us plau configura el codi d\'accés del dispositiu o el bloqueig de pantalla a la configuració del sistema.';

  @override
  String get authToViewPasskey =>
      'Si us plau, autentica\'t per veure la teva clau d\'accés';

  @override
  String get loopVideoOn => 'Desactiva bucle';

  @override
  String get loopVideoOff => 'Activa bucle';

  @override
  String get localSyncErrorMessage =>
      'Sembla que alguna cosa ha anat malament ja que la sincronització de fotos locals està trigant més del previst. Si us plau, contacta amb el nostre equip de suport';

  @override
  String get showPerson => 'Mostra persona';

  @override
  String get sort => 'Ordena';

  @override
  String get mostRecent => 'Més recent';

  @override
  String get mostRelevant => 'Més rellevant';

  @override
  String get loadingYourPhotos => 'Carregant les teves fotos...';

  @override
  String processingImport({required Object folderName}) {
    return 'Processant $folderName...';
  }

  @override
  String get personName => 'Nom de la persona';

  @override
  String get addPerson => 'Add person';

  @override
  String get addToPerson => 'Add to person';

  @override
  String get pleaseNamePersonInPeopleSectionFirst =>
      'Please name a person in the People section first';

  @override
  String get onlyUploadedFilesCanBeAddedToPerson =>
      'Only uploaded files can be added to a person';

  @override
  String get noFacesDetectedTapToAdd => 'No faces detected, tap to add.';

  @override
  String addedFilesToPerson({required int count, required String personName}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count files to $personName',
      one: 'Added 1 file to $personName',
    );
    return '$_temp0';
  }

  @override
  String filesAlreadyLinkedToPerson({
    required int count,
    required String personName,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count files are already linked to $personName',
      one: '1 file is already linked to $personName',
    );
    return '$_temp0';
  }

  @override
  String get addNewPerson => 'Afegeix nova persona';

  @override
  String get addNameOrMerge => 'Afegeix nom o fusiona';

  @override
  String get mergeWithExisting => 'Fusiona amb existent';

  @override
  String get newPerson => 'Nova persona';

  @override
  String get addName => 'Afegeix nom';

  @override
  String get add => 'Afegeix';

  @override
  String extraPhotosFoundFor({required String text}) {
    return 'Fotos extra trobades per a $text';
  }

  @override
  String get extraPhotosFound => 'Fotos extra trobades';

  @override
  String get configuration => 'Configuració';

  @override
  String get localIndexing => 'Indexació local';

  @override
  String get processed => 'Processat';

  @override
  String get resetPerson => 'Elimina';

  @override
  String get areYouSureYouWantToResetThisPerson =>
      'Estàs segur que vols restablir aquesta persona?';

  @override
  String get allPersonGroupingWillReset =>
      'Tots els agrupaments per a aquesta persona es restabliran, i perdràs tots els suggeriments fets per a aquesta persona';

  @override
  String get yesResetPerson => 'Sí, restablir persona';

  @override
  String get onlyThem => 'Només ells';

  @override
  String get checkingModels => 'Comprovant models...';

  @override
  String get enableMachineLearningBanner =>
      'Activa l\'aprenentatge automàtic per a la cerca màgica i el reconeixement facial';

  @override
  String get searchDiscoverEmptySection =>
      'Les imatges es mostraran aquí un cop completat el processament i la sincronització';

  @override
  String get searchPersonsEmptySection =>
      'La gent es mostrarà aquí un cop completat el processament i la sincronització';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Afegits $count visualitzadors',
      one: 'Afegit 1 visualitzador',
      zero: 'Afegits 0 visualitzadors',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Afegits $count col·laboradors',
      one: 'Afegit 1 col·laborador',
      zero: 'Afegit 0 col·laborador',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured => 'El compte ja està configurat.';

  @override
  String get sessionIdMismatch => 'L\'ID de sessió no coincideix';

  @override
  String get failedToFetchActiveSessions =>
      'No s\'han pogut obtenir les sessions actives';

  @override
  String get failedToRefreshStripeSubscription =>
      'No s\'ha pogut actualitzar la subscripció';

  @override
  String get failedToPlayVideo => 'No s\'ha pogut reproduir el vídeo';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return 'La pujada s\'ignora a causa de $ignoreReason';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'El tipus de galeria $galleryType no és compatible amb el canvi de nom';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'Toca per pujar, la pujada s\'ignora actualment a causa de $ignoreReason';
  }

  @override
  String get tapToUpload => 'Toca per pujar';

  @override
  String get info => 'Informació';

  @override
  String get addFiles => 'Afegeix fitxers';

  @override
  String get castAlbum => 'Transmet àlbum';

  @override
  String get imageNotAnalyzed => 'Imatge no analitzada';

  @override
  String get noFacesFound => 'No s\'han trobat cares';

  @override
  String get fileNotUploadedYet => 'Fitxer encara no pujat';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return 'No hi ha suggeriments per a $personName';
  }

  @override
  String get month => 'mes';

  @override
  String get yearShort => 'any';

  @override
  String get currentlyRunning => 'actualment en execució';

  @override
  String get ignored => 'ignorat';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count fotos',
      one: '1 foto',
      zero: '0 fotos',
    );
    return '$_temp0';
  }

  @override
  String get file => 'Fitxer';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'La longitud de les seccions no coincideix: $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'Selecciona aplicació de correu';

  @override
  String get selectAllShort => 'Tot';

  @override
  String get selectCoverPhoto => 'Selecciona foto de portada';

  @override
  String get newLocation => 'Nova ubicació';

  @override
  String get faceNotClusteredYet =>
      'Cara encara no agrupada, si us plau torna més tard';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'L\'enllaç al qual intentes accedir ha caducat.';

  @override
  String get openFile => 'Obre fitxer';

  @override
  String get backupFile => 'Fes còpia de seguretat del fitxer';

  @override
  String get openAlbumInBrowser => 'Obre àlbum al navegador';

  @override
  String get openAlbumInBrowserTitle =>
      'Si us plau, utilitza l\'aplicació web per afegir fotos a aquest àlbum';

  @override
  String get allow => 'Permet';

  @override
  String get allowAppToOpenSharedAlbumLinks =>
      'Permet que l\'aplicació obri enllaços d\'àlbums compartits';

  @override
  String get seePublicAlbumLinksInApp =>
      'Veure enllaços d\'àlbums públics a l\'aplicació';

  @override
  String get emergencyContacts => 'Contactes d\'emergència';

  @override
  String get acceptTrustInvite => 'Accepta invitació';

  @override
  String get declineTrustInvite => 'Rebutja invitació';

  @override
  String get removeYourselfAsTrustedContact =>
      'Elimina\'t com a contacte de confiança';

  @override
  String get legacy => 'Llegat';

  @override
  String get legacyPageDesc =>
      'El llegat permet als contactes de confiança accedir al teu compte en la teva absència.';

  @override
  String get legacyPageDesc2 =>
      'Els contactes de confiança poden iniciar la recuperació del compte, i si no es bloquegen en 30 dies, restablir la teva contrasenya i accedir al teu compte.';

  @override
  String get legacyAccounts => 'Comptes de llegat';

  @override
  String get trustedContacts => 'Contactes de confiança';

  @override
  String get addTrustedContact => 'Afegeix contacte de confiança';

  @override
  String get removeInvite => 'Elimina invitació';

  @override
  String get recoveryWarning =>
      'Un contacte de confiança està intentant accedir al teu compte';

  @override
  String get rejectRecovery => 'Rebutja recuperació';

  @override
  String get recoveryInitiated => 'Recuperació iniciada';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return 'Pots accedir al compte després de $days dies. S\'enviarà una notificació a $email.';
  }

  @override
  String get cancelAccountRecovery => 'Cancel·la recuperació';

  @override
  String get recoveryAccount => 'Recupera compte';

  @override
  String get cancelAccountRecoveryBody =>
      'Estàs segur que vols cancel·lar la recuperació?';

  @override
  String get startAccountRecoveryTitle => 'Inicia recuperació';

  @override
  String get whyAddTrustContact =>
      'El contacte de confiança pot ajudar a recuperar les teves dades.';

  @override
  String recoveryReady({required String email}) {
    return 'Ara pots recuperar el compte de $email establint una nova contrasenya.';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email està intentant recuperar el teu compte.';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return 'Has estat convidat a ser un contacte de llegat per $email.';
  }

  @override
  String get warning => 'Avís';

  @override
  String get proceed => 'Procedeix';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return 'Estàs a punt d\'afegir $email com a contacte de confiança. Podran recuperar el teu compte si estàs absent durant $numOfDays dies.';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email t\'ha convidat a ser un contacte de confiança';
  }

  @override
  String get authToManageLegacy =>
      'Si us plau, autentica\'t per gestionar els teus contactes de confiança';

  @override
  String get hideSharedItemsFromHomeGallery =>
      'Amaga elements compartits de la galeria d\'inici';

  @override
  String get swipeToSelect => 'Llisca per seleccionar';

  @override
  String get gallery => 'Galeria';

  @override
  String get joinAlbum => 'Uneix-te a l\'àlbum';

  @override
  String get joinAlbumSubtext => 'per veure i afegir les teves fotos';

  @override
  String get joinAlbumSubtextViewer => 'per afegir això als àlbums compartits';

  @override
  String get join => 'Uneix-te';

  @override
  String get linkEmail => 'Vincula correu';

  @override
  String get link => 'Vincula';

  @override
  String get noEnteAccountExclamation => 'No tens compte d\'Ente!';

  @override
  String get orPickFromYourContacts => 'o tria dels teus contactes';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return '$email no té un compte d\'Ente.';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (Jo)';
  }

  @override
  String get reassignMe => 'Reassigna \"Jo\"';

  @override
  String get me => 'Jo';

  @override
  String get linkEmailToContactBannerCaption => 'per compartir més ràpidament';

  @override
  String get selectPersonToLink => 'Selecciona persona per vincular';

  @override
  String linkPersonToEmail({required String email}) {
    return 'Vincula persona a $email';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return 'Això vincularà $personName a $email';
  }

  @override
  String get selectYourFace => 'Selecciona la teva cara';

  @override
  String get reassigningLoading => 'Reassignant...';

  @override
  String reassignedToName({required String name}) {
    return 'T\'has reassignat a $name';
  }

  @override
  String get saveChangesBeforeLeavingQuestion =>
      'Guardar canvis abans de sortir?';

  @override
  String get dontSave => 'No guardis';

  @override
  String get thisIsMeExclamation => 'Aquest soc jo!';

  @override
  String get linkPerson => 'Vincula persona';

  @override
  String get linkPersonCaption => 'per una millor experiència de compartició';

  @override
  String get videoStreaming => 'Vídeos reproduïbles';

  @override
  String get processingVideos => 'Processant vídeos';

  @override
  String get streamDetails => 'Detalls de la transmissió';

  @override
  String get processing => 'Processant';

  @override
  String get queued => 'En cua';

  @override
  String get ineligible => 'No elegible';

  @override
  String get failed => 'Fallit';

  @override
  String get playStream => 'Reprodueix transmissió';

  @override
  String get playOriginal => 'Reprodueix original';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'Unir-se a un àlbum farà que el teu correu sigui visible per als seus participants.';

  @override
  String get pleaseWaitThisWillTakeAWhile =>
      'Si us plau, espera, això trigarà una estona.';

  @override
  String get editTime => 'Edita hora';

  @override
  String get selectTime => 'Selecciona hora';

  @override
  String get selectDate => 'Selecciona data';

  @override
  String get previous => 'Anterior';

  @override
  String get selectOneDateAndTimeForAll =>
      'Selecciona una data i hora per a tots';

  @override
  String get selectStartOfRange => 'Selecciona inici del rang';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      'Això farà que la data i hora de totes les fotos seleccionades sigui la mateixa.';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'Aquesta és la primera del grup. Altres fotos seleccionades es desplaçaran automàticament basant-se en aquesta nova data';

  @override
  String get newRange => 'Nou rang';

  @override
  String get selectOneDateAndTime => 'Selecciona una data i hora';

  @override
  String get moveSelectedPhotosToOneDate =>
      'Mou les fotos seleccionades a una data';

  @override
  String get shiftDatesAndTime => 'Desplaça dates i hora';

  @override
  String get photosKeepRelativeTimeDifference =>
      'Les fotos mantenen la diferència horària relativa';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count fotos',
      one: '1 foto',
      zero: 'Sense fotos',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'Icona de l\'aplicació';

  @override
  String get notThisPerson => 'No és aquesta persona?';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      'Els elements seleccionats s\'eliminaran d\'aquesta persona, però no s\'esborraran de la teva biblioteca.';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat a través dels anys';
  }

  @override
  String get thisWeekThroughTheYears => 'Aquesta setmana a través dels anys';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Aquesta setmana, fa $count anys',
      one: 'Aquesta setmana, fa $count any',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'Tu i $name';
  }

  @override
  String admiringThem({required Object name}) {
    return 'Admirant $name';
  }

  @override
  String embracingThem({required Object name}) {
    return 'Abraçant $name';
  }

  @override
  String partyWithThem({required Object name}) {
    return 'Festa amb $name';
  }

  @override
  String hikingWithThem({required Object name}) {
    return 'Excursió amb $name';
  }

  @override
  String feastingWithThem({required Object name}) {
    return 'Banquet amb $name';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return 'Selfies amb $name';
  }

  @override
  String posingWithThem({required Object name}) {
    return 'Posant amb $name';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return 'Vistes boniques amb $name';
  }

  @override
  String sportsWithThem({required Object name}) {
    return 'Esports amb $name';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return 'Viatge per carretera amb $name';
  }

  @override
  String get spotlightOnYourself => 'Focus en tu mateix';

  @override
  String spotlightOnThem({required Object name}) {
    return 'Focus en $name';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$name té $age!';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name farà $age aviat';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return 'Última vegada amb $name';
  }

  @override
  String tripToLocation({required Object location}) {
    return 'Viatge a $location';
  }

  @override
  String tripInYear({required Object year}) {
    return 'Viatge el $year';
  }

  @override
  String get lastYearsTrip => 'Viatge de l\'any passat';

  @override
  String get sunrise => 'A l\'horitzó';

  @override
  String get mountains => 'Sobre els turons';

  @override
  String get greenery => 'La vida verda';

  @override
  String get beach => 'Sorra i mar';

  @override
  String get city => 'A la ciutat';

  @override
  String get moon => 'A la llum de la lluna';

  @override
  String get onTheRoad => 'De nou a la carretera';

  @override
  String get food => 'Delícia culinària';

  @override
  String get pets => 'Companys peluts';

  @override
  String get curatedMemories => 'Records seleccionats';

  @override
  String get widgets => 'Widgets';

  @override
  String get memories => 'Records';

  @override
  String get peopleWidgetDesc =>
      'Selecciona les persones que vols veure a la teva pantalla d\'inici.';

  @override
  String get albumsWidgetDesc =>
      'Selecciona els àlbums que vols veure a la teva pantalla d\'inici.';

  @override
  String get memoriesWidgetDesc =>
      'Selecciona el tipus de records que vols veure a la teva pantalla d\'inici.';

  @override
  String get smartMemories => 'Records intel·ligents';

  @override
  String get pastYearsMemories => 'Records d\'anys passats';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return 'Esborrar també les fotos (i vídeos) presents en aquests $count àlbums de <bold>tots</bold> els altres àlbums dels quals formen part?';
  }

  @override
  String get addParticipants => 'Afegeix participants';

  @override
  String selectedAlbums({required Object count}) {
    return '$count seleccionats';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'Acció no suportada a l\'àlbum de Favorits';

  @override
  String get onThisDayMemories => 'Records d\'aquest dia';

  @override
  String get onThisDay => 'Aquest dia';

  @override
  String get lookBackOnYourMemories => 'Mira enrere als teus records 🌄';

  @override
  String get newPhotosEmoji => ' noves 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'Ho sentim, hem hagut de pausar les teves còpies de seguretat';

  @override
  String get clickToInstallOurBestVersionYet =>
      'Fes clic per instal·lar la nostra millor versió fins ara';

  @override
  String get onThisDayNotificationExplanation =>
      'Rep recordatoris sobre records d\'aquest dia en anys anteriors.';

  @override
  String get addMemoriesWidgetPrompt =>
      'Afegeix un widget de records a la teva pantalla d\'inici i torna aquí per personalitzar.';

  @override
  String get addAlbumWidgetPrompt =>
      'Afegeix un widget d\'àlbum a la teva pantalla d\'inici i torna aquí per personalitzar.';

  @override
  String get addPeopleWidgetPrompt =>
      'Afegeix un widget de persones a la teva pantalla d\'inici i torna aquí per personalitzar.';

  @override
  String get birthdayNotifications => 'Notificacions d\'aniversari';

  @override
  String get receiveRemindersOnBirthdays =>
      'Rep recordatoris quan sigui l\'aniversari d\'algú. Tocar la notificació et portarà a fotos de la persona que fa anys.';

  @override
  String get happyBirthday => 'Per molts anys! 🥳';

  @override
  String get birthdays => 'Aniversaris';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return 'Desitja a $name un feliç aniversari! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      'Estàs segur que vols eliminar aquesta cara d\'aquesta persona?';

  @override
  String get otherDetectedFaces => 'Altres cares detectades';

  @override
  String get areThey => 'Són ells ';

  @override
  String get questionmark => '?';

  @override
  String get saveAsAnotherPerson => 'Guarda com una altra persona';

  @override
  String get showLessFaces => 'Mostra menys cares';

  @override
  String get showMoreFaces => 'Mostra més cares';

  @override
  String get ignore => 'Ignora';

  @override
  String get merge => 'Fusiona';

  @override
  String get reset => 'Restableix';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      'Estàs segur que vols ignorar aquesta persona?';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      'Estàs segur que vols ignorar aquestes persones?';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'Els grups de persones ja no es mostraran a la secció de persones. Les fotos romandran intactes.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'La persona ja no es mostrarà a la secció de persones. Les fotos romandran intactes.';

  @override
  String get areYouSureYouWantToMergeThem =>
      'Estàs segur que vols fusionar-los?';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'Tots els grups sense nom es fusionaran amb la persona seleccionada. Això encara es pot desfer des de la visió general de l\'historial de suggeriments de la persona.';

  @override
  String get yesIgnore => 'Sí, ignora';

  @override
  String get same => 'Igual';

  @override
  String get different => 'Diferent';

  @override
  String get sameperson => 'Mateixa persona?';

  @override
  String get indexingPausedStatusDescription =>
      'La indexació està en pausa. Es reprendrà automàticament quan el dispositiu estigui llest. El dispositiu es considera llest quan el nivell de bateria, la salut de la bateria i l\'estat tèrmic estan dins d\'un rang saludable.';

  @override
  String get thisWeek => 'Aquesta setmana';

  @override
  String get lastWeek => 'La setmana passada';

  @override
  String get thisMonth => 'Aquest mes';

  @override
  String get thisYear => 'Aquest any';

  @override
  String get groupBy => 'Agrupa per';

  @override
  String get faceThumbnailGenerationFailed =>
      'No s\'han pogut generar miniatures de cares';

  @override
  String get fileAnalysisFailed => 'No s\'ha pogut analitzar el fitxer';

  @override
  String get editAutoAddPeople => 'Edita persones d\'afegit automàtic';

  @override
  String get autoAddPeople => 'Afegit automàtic de persones';

  @override
  String get autoAddToAlbum => 'Afegit automàtic a l\'àlbum';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      'S\'han d\'eliminar els fitxers relacionats amb la persona que es van seleccionar prèviament en àlbums intel·ligents?';

  @override
  String get addingPhotos => 'Afegint fotos';

  @override
  String get gettingReady => 'Preparant-se';

  @override
  String get addSomePhotosDesc1 => 'Afegeix algunes fotos o tria ';

  @override
  String get addSomePhotosDesc2 => 'cares familiars';

  @override
  String get addSomePhotosDesc3 => '\nper començar';

  @override
  String get ignorePerson => 'Ignora persona';

  @override
  String get mixedGrouping => 'Agrupament mixt?';

  @override
  String get analysis => 'Anàlisi';

  @override
  String get doesGroupContainMultiplePeople =>
      'Aquest agrupament conté múltiples persones?';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'Analitzarem automàticament l\'agrupament per determinar si hi ha múltiples persones presents, i les separarem de nou. Això pot trigar uns segons.';

  @override
  String get layout => 'Disposició';

  @override
  String get day => 'Dia';

  @override
  String get undo => 'Desfés';

  @override
  String get redo => 'Refés';

  @override
  String get filter => 'Filtre';

  @override
  String get adjust => 'Ajusta';

  @override
  String get draw => 'Dibuixa';

  @override
  String get sticker => 'Adhesiu';

  @override
  String get brushColor => 'Color del pinzell';

  @override
  String get font => 'Font';

  @override
  String get background => 'Fons';

  @override
  String get align => 'Alinea';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Afegit amb èxit a $count àlbums',
      one: 'Afegit amb èxit a 1 àlbum',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => 'Vídeos processats';

  @override
  String get totalVideos => 'Total de vídeos';

  @override
  String get skippedVideos => 'Vídeos omesos';

  @override
  String get videoStreamingDescriptionLine1 =>
      'Reprodueix vídeos a l\'instant en qualsevol dispositiu.';

  @override
  String get videoStreamingDescriptionLine2 =>
      'Activa per processar fluxos de vídeo en aquest dispositiu.';

  @override
  String get videoStreamingNote =>
      'Només els vídeos dels últims 60 dies i de menys d\'1 minut es processen en aquest dispositiu. Per a vídeos més antics/llargs, activa la transmissió a l\'aplicació d\'escriptori.';

  @override
  String get createStream => 'Crea transmissió';

  @override
  String get recreateStream => 'Recrea transmissió';

  @override
  String get addedToStreamCreationQueue =>
      'Afegit a la cua de creació de transmissió';

  @override
  String get addedToStreamRecreationQueue =>
      'Afegit a la cua de recreació de transmissió';

  @override
  String get videoPreviewAlreadyExists =>
      'La previsualització del vídeo ja existeix';

  @override
  String get videoAlreadyInQueue => 'El fitxer de vídeo ja és present a la cua';

  @override
  String get videoExportFailed =>
      'La creació del vídeo ha fallat. Si us plau, torna-ho a provar.';

  @override
  String videoExportSuccess({required String path}) {
    return 'Vídeo creat amb èxit a $path';
  }

  @override
  String get addedToQueue => 'Afegit a la cua';

  @override
  String get creatingStream => 'Creant transmissió';

  @override
  String get similarImages => 'Imatges similars';

  @override
  String get findSimilarImages => 'Troba imatges similars';

  @override
  String get noSimilarImagesFound => 'No s\'han trobat imatges similars';

  @override
  String get yourPhotosLookUnique => 'Les teves fotos semblen úniques';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count grups trobats',
      one: '$count grup trobat',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages =>
      'Revisa i elimina imatges similars';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return 'Esborra $count fotos ($size)';
  }

  @override
  String get selectionOptions => 'Opcions de selecció';

  @override
  String selectExactWithCount({required int count}) {
    return 'Exactament similars ($count)';
  }

  @override
  String get selectExact => 'Selecciona exactes';

  @override
  String selectSimilarWithCount({required int count}) {
    return 'Majoritàriament similars ($count)';
  }

  @override
  String get selectSimilar => 'Selecciona similars';

  @override
  String selectAllWithCount({required int count}) {
    return 'Totes les similituds ($count)';
  }

  @override
  String get selectSimilarImagesTitle => 'Selecciona imatges similars';

  @override
  String get chooseSimilarImagesToSelect =>
      'Selecciona imatges basant-se en la seva similitud visual';

  @override
  String get clearSelection => 'Neteja selecció';

  @override
  String similarImagesCount({required int count}) {
    return '$count imatges similars';
  }

  @override
  String deleteWithCount({required int count}) {
    return 'Esborra ($count)';
  }

  @override
  String get deleteFiles => 'Esborra fitxers';

  @override
  String get areYouSureDeleteFiles =>
      'Estàs segur que vols esborrar aquests fitxers?';

  @override
  String get greatJob => 'Bona feina!';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return 'Has alliberat $size d\'espai';
  }

  @override
  String get size => 'Mida';

  @override
  String get similarity => 'Similitud';

  @override
  String get analyzingPhotosLocally =>
      'Analitzant les teves fotos localment...';

  @override
  String get lookingForVisualSimilarities => 'Buscant similituds visuals...';

  @override
  String get comparingImageDetails => 'Comparant detalls de la imatge...';

  @override
  String get findingSimilarImages => 'Trobant imatges similars...';

  @override
  String get almostDone => 'Gairebé llest...';

  @override
  String get processingLocally => 'Processant localment';

  @override
  String get useMLToFindSimilarImages =>
      'Revisa i elimina imatges que semblen similars entre si.';

  @override
  String get all => 'Tot';

  @override
  String get similar => 'Similar';

  @override
  String get identical => 'Idèntic';

  @override
  String get nothingHereTryAnotherFilter =>
      'Res aquí, prova un altre filtre! 👀';

  @override
  String get related => 'Relacionat';

  @override
  String get hoorayyyy => 'Viscaaaa!';

  @override
  String get nothingToTidyUpHere => 'Res a endreçar aquí';

  @override
  String get deletingDash => 'Esborrant - ';

  @override
  String get cLTitle1 => 'Salta a la data';

  @override
  String get cLDesc1 =>
      'Veure fotos circumdants per a qualsevol foto seleccionant l\'opció salta a la data al panell d\'informació del fitxer.';

  @override
  String get cLTitle2 => 'Editor de vídeo més ràpid';

  @override
  String get cLDesc2 =>
      'L\'editor de vídeo s\'ha renovat per millorar dràsticament la seva velocitat en editar vídeos més grans, i també millorar l\'experiència d\'usuari.';

  @override
  String get cLTitle3 => 'Nous records';

  @override
  String get cLDesc3 =>
      '\"Nens juganers\", \"Aventures d\'hivern\", \"Nits de neó\", i més.';

  @override
  String get cLTitle4 => 'Galeria apaïsada i més';

  @override
  String get cLDesc4 =>
      'Suport per a la disposició apaïsada a la galeria principal de l\'aplicació. Mostra persones sense cap foto associada en lloc de filtrar-les. Millora la detecció d\'aspecte de vídeo quan es comparteix des d\'aplicacions externes.';

  @override
  String get closeBy => 'A prop';

  @override
  String get peopleAutoAddDesc =>
      'Afegeix automàticament fotos de les persones seleccionades a aquest àlbum';

  @override
  String get festivities => 'Alegria festiva';

  @override
  String get snowAdventures => 'Aventures d\'hivern';

  @override
  String get waterfalls => 'Perseguint cascades';

  @override
  String get wildlife => 'A la natura';

  @override
  String get flowers => 'Belleses en flor';

  @override
  String get nightLights => 'Nits de neó';

  @override
  String get architecture => 'Icones de disseny';

  @override
  String get autumnColors => 'Esplendor de tardor';

  @override
  String get desertDreams => 'Somnis del desert';

  @override
  String get stargazing => 'Sota les estrelles';

  @override
  String get lakeside => 'Calma al costat del llac';

  @override
  String get rainyDays => 'Sensacions de dia plujós';

  @override
  String get sportsAction => 'Joc en marxa';

  @override
  String get streetArt => 'Històries d\'art urbà';

  @override
  String get familyMoments => 'Temps en família';

  @override
  String get fireworks => 'Final de focs artificials';

  @override
  String get historicSites => 'Ecos de la història';

  @override
  String get tropicalParadise => 'Escapades tropicals';

  @override
  String get forestTrails => 'Passejades pel bosc';

  @override
  String get citySunsets => 'Resplendor de posta de sol a la ciutat';

  @override
  String get colorfulMarkets => 'Mercats vibrants';

  @override
  String get cozyCafes => 'Racons de cafeteria acollidors';

  @override
  String get vintageVibes => 'Vibes vintage';

  @override
  String get aerialViews => 'Perspectives aèries';

  @override
  String get artisticPortraits => 'Retrats artístics';

  @override
  String get streetFood => 'Mossegades de menjar de carrer';

  @override
  String get riverCruises => 'Vistes de creuer fluvial';

  @override
  String get facesTimelineBannerTitle => 'Camí dels records';

  @override
  String facesTimelineBannerSubtitle({required String name}) {
    return 'Veure les fotos de $name a través dels anys';
  }

  @override
  String get facesTimelineAppBarTitle => 'Camí dels records';

  @override
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count anys',
      one: '$count any',
    );
    return '$name tenia $_temp0';
  }

  @override
  String facesTimelineCaptionYearsAgo({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'fa # anys',
      one: 'fa # any',
    );
    return '$_temp0';
  }

  @override
  String get facesTimelineShareComingSoon => 'Compartició de vídeo properament';

  @override
  String get facesTimelinePlaybackPrevious => 'Anterior';

  @override
  String get facesTimelinePlaybackNext => 'Següent';

  @override
  String get facesTimelinePlaybackPlay => 'Reprodueix';

  @override
  String get facesTimelinePlaybackPause => 'Pausa';

  @override
  String get facesTimelineUnavailable =>
      'El camí dels records s\'està preparant...';

  @override
  String get playfulKids => 'Nens juganers';

  @override
  String get coastalCliffs => 'Penya-segats vora el mar';

  @override
  String get ritualsTitle => 'Rituals';

  @override
  String get ritualAddTooltip => 'Afegeix ritual';

  @override
  String get ritualActivityHeading => 'Activitat';

  @override
  String get ritualDefaultHeatmapTitle => 'Fes una foto cada dia';

  @override
  String get ritualUntitled => 'Ritual sense títol';

  @override
  String get ritualShareUnavailable =>
      'No es pot compartir ara mateix. Si us plau, torna-ho a provar.';

  @override
  String get ritualNotificationMessage => 'Fes una foto ara';

  @override
  String get ritualCameraNotFound =>
      'No s\'ha trobat càmera en aquest dispositiu.';

  @override
  String get ritualCameraStartError =>
      'No s\'ha pogut iniciar la càmera. Si us plau, comprova els permisos.';

  @override
  String get ritualCaptureError =>
      'No s\'ha pogut capturar la foto. Si us plau, torna-ho a provar.';

  @override
  String ritualPhotoLimit({required int maxPhotos}) {
    String _temp0 = intl.Intl.pluralLogic(
      maxPhotos,
      locale: localeName,
      other: '# fotos.',
      one: '# foto.',
    );
    return 'Pots afegir fins a $_temp0';
  }

  @override
  String get ritualCaptureAtLeastOne => 'Captura almenys una foto primer.';

  @override
  String get ritualAlbumMissing =>
      'Falta l\'àlbum del ritual. Edita el ritual per establir un àlbum.';

  @override
  String get ritualAddedToAlbum => 'Afegit a l\'àlbum';

  @override
  String ritualAddedToAlbumWithName({required String albumName}) {
    return 'Afegit a $albumName';
  }

  @override
  String ritualAddToAlbumFailure({required String error}) {
    return 'No s\'han pogut afegir fotos a l\'àlbum: $error';
  }

  @override
  String get ritualBackToList => 'Torna als rituals';

  @override
  String get ritualNoPhotosYet => 'Encara no hi ha fotos';

  @override
  String get ritualSetAlbumToLaunchCamera =>
      'Estableix un àlbum per a aquest ritual per iniciar la càmera.';

  @override
  String get ritualDefaultCameraTitle => 'Fes una foto';

  @override
  String get ritualBadgeMessage7 =>
      '7 dies fets! La consistència et queda bé. Segueix així!';

  @override
  String get ritualBadgeMessage14 =>
      '14 dies dins! El teu ritual s\'està convertint en un hàbit. Increïble!';

  @override
  String get ritualBadgeMessage30 =>
      '30 dies seguits! Consistència llegendària. Fes una reverència!';

  @override
  String get ritualBadgeMessageDefault => 'Estàs en ratxa!';

  @override
  String get ritualBadgeNewTitle => 'Nou assoliment';

  @override
  String get ritualBadgePreparing => 'Preparant...';

  @override
  String get ritualStreaksLabel => 'Ratxes';

  @override
  String get ritualCreateYourOwn => 'Crea el teu propi ritual';

  @override
  String get ritualGetDailyReminders => 'Rep recordatoris diaris';

  @override
  String get ritualAlbumNotSet => 'Àlbum no establert';

  @override
  String get ritualOpenCameraTooltip => 'Obre càmera de ritual';

  @override
  String get ritualEditorLabel => 'Editor de rituals';

  @override
  String get ritualNew => 'Nou ritual';

  @override
  String get ritualCreateNewTitle => 'Create new ritual';

  @override
  String get ritualEdit => 'Edita ritual';

  @override
  String get ritualEnterPrompt => 'Introdueix el teu ritual';

  @override
  String get ritualEnterDescription => 'Si us plau, introdueix una descripció';

  @override
  String get ritualChooseDaysLabel => 'Choose days for ritual';

  @override
  String get ritualDayLabel => 'Dia';

  @override
  String get ritualNotificationsOffHint =>
      'Les notificacions estan desactivades. Toca un dia per activar-les.';

  @override
  String get ritualTimeLabel => 'Hora';

  @override
  String get ritualAlbumLabel => 'Àlbum';

  @override
  String get ritualSave => 'Guarda ritual';

  @override
  String get ritualCreateAction => 'Create ritual';

  @override
  String get ritualUpdate => 'Actualitza ritual';

  @override
  String get ritualSelectAlbumTitle => 'Selecciona àlbum';

  @override
  String get ritualChooseAlbumLabel => 'Choose an album';

  @override
  String get ritualSendReminderLabel => 'Send reminder';

  @override
  String get ritualSearchOrCreate => 'Cerca o crea nou';

  @override
  String get ritualNoAlbumsYet => 'Encara no hi ha àlbums';

  @override
  String get ritualNoMatchingAlbums => 'No hi ha àlbums coincidents';

  @override
  String ritualCreateAlbumWithName({required String albumName}) {
    return 'Crea \"$albumName\"';
  }

  @override
  String get ritualCreateNew => 'Crea nou';

  @override
  String get ritualAlbumSelectionPlaceholder => 'Selecciona àlbum';

  @override
  String get ritualPickEmojiTitle => 'Tria un emoji';

  @override
  String get ritualCustomKeyboardLabel => 'Personalitzat (teclat)';

  @override
  String get ritualEmojiKeyboardHint => 'Prem per obrir el teclat d\'emojis';

  @override
  String get ritualEmojiUseAction => 'Utilitza';

  @override
  String get ritualSearchEmpty =>
      'Construeix un ritual per mantenir el teu hàbit de fotos.';
}
