// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Belarusian (`be`).
class AppLocalizationsBe extends AppLocalizations {
  AppLocalizationsBe([String locale = 'be']) : super(locale);

  @override
  String get enterYourEmailAddress => 'Увядзіце свой адрас электроннай пошты';

  @override
  String get enterYourNewEmailAddress =>
      'Увядзіце свой новы адрас электроннай пошты';

  @override
  String get accountWelcomeBack => 'З вяртаннем!';

  @override
  String get emailAlreadyRegistered => 'Электронная пошта ўжо зарэгістравана.';

  @override
  String get emailNotRegistered => 'Электронная пошта не зарэгістравана.';

  @override
  String get email => 'Электронная пошта';

  @override
  String get cancel => 'Скасаваць';

  @override
  String get verify => 'Спраўдзіць';

  @override
  String get invalidEmailAddress => 'Памылковы адрас электроннай пошты';

  @override
  String get enterValidEmail => 'Увядзіце сапраўдны адрас электроннай пошты.';

  @override
  String get deleteAccount => 'Выдаліць уліковы запіс';

  @override
  String get deleteAccountWarning =>
      'Гэта выдаліць ваш уліковы запіс Ente Auth, Ente Photos і Ente Locker.';

  @override
  String get askDeleteReason =>
      'Якая асноўная прычына выдалення ўліковага запісу?';

  @override
  String get deleteAccountFeedbackPrompt =>
      'Нам шкада, што вы выдаляеце свой уліковы запіс. Абагуліце з намі водгук, каб дапамагчы нам палепшыць сэрвіс.';

  @override
  String get feedback => 'Водгук';

  @override
  String get kindlyHelpUsWithThisInformation =>
      'Дапамажыце нам з гэтай інфармацыяй';

  @override
  String get confirmDeletePrompt =>
      'Так. Я хачу незваротна выдаліць гэты ўліковы запіс і яго даныя ва ўсіх праграмах.';

  @override
  String get confirmAccountDeletion => 'Пацвердзіць выдаленне ўліковага запісу';

  @override
  String get deleteAccountPermanentlyButton =>
      'Незваротна выдаліць уліковы запіс';

  @override
  String get yourAccountHasBeenDeleted => 'Ваш уліковы запіс быў выдалены';

  @override
  String get selectReason => 'Выберыце прычыну';

  @override
  String get deleteReason1 =>
      'У вас адсутнічае важная функцыя, якая мне неабходна';

  @override
  String get deleteReason2 =>
      'Праграма або пэўная функцыя не паводзіць сябе так, як павінна';

  @override
  String get deleteReason3 => 'Я знайшоў больш прывабны сэрвіс';

  @override
  String get deleteReason4 => 'Прычына адсутнічае ў спісе';

  @override
  String get sendEmail => 'Адправіць ліст';

  @override
  String get deleteRequestSLAText =>
      'Ваш запыт будзе апрацаваны цягам 72 гадзін.';

  @override
  String get deleteEmailRequest =>
      'Адпраўце ліст на <warning>account-deletion@ente.io</warning> з вашага зарэгістраванага адраса электроннай пошты.';

  @override
  String get entePhotosPerm =>
      'Праграме <i>неабходны доступ</i> для захавання вашых фатаграфій';

  @override
  String get ok => 'OK';

  @override
  String get createAccount => 'Стварыць уліковы запіс';

  @override
  String get createNewAccount => 'Стварыць новы ўліковы запіс';

  @override
  String get password => 'Пароль';

  @override
  String get confirmPassword => 'Пацвердзіць пароль';

  @override
  String get activeSessions => 'Актыўныя сеансы';

  @override
  String get ocrProcessingOverlayMessage => 'Выяўленне тэксту...';

  @override
  String get ocrLoadingIndicatorLabel => 'Выяўленне тэксту';

  @override
  String get ocrSelectionHint =>
      'Правядзіце пальцам або двойчы націсніце, каб выбраць менавіта тое, што вам трэба';

  @override
  String get ocrNoTextDetected => 'Тэкст не выяўлены';

  @override
  String get ocrRetryButtonLabel => 'Паўтарыць';

  @override
  String get ocrModelsNetworkRequiredError =>
      'Для спампоўвання мадэляў аптычнага распазнавання пры першым выкарыстанні патрабуецца падключэнне да сеткі';

  @override
  String get ocrModelsPrepareFailed =>
      'Не ўдалося падрыхтаваць мадэлі аптычнага распазнавання';

  @override
  String get ocrImageNotFoundError => 'Файл відарыса не знойдзены';

  @override
  String get ocrImageDecodeFailedError => 'Не ўдалося прачытаць файл відарыса';

  @override
  String get ocrGenericDetectError => 'Не ўдалося выявіць тэкст у відарысе';

  @override
  String get oops => 'Вой';

  @override
  String get somethingWentWrongPleaseTryAgain =>
      'Нешта пайшло не так. Паспрабуйце яшчэ раз';

  @override
  String get thisWillLogYouOutOfThisDevice =>
      'Гэта дзеянне завершыць сеанс на вашай прыладзе!';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice =>
      'Гэта дзеянне завершыць сеанс на наступнай прыладзе:';

  @override
  String get terminateSession => 'Перарваць сеанс?';

  @override
  String get terminate => 'Перарваць';

  @override
  String get thisDevice => 'Гэта прылада';

  @override
  String get recoverButton => 'Аднавіць';

  @override
  String get recoverySuccessful => 'Паспяхова адноўлена!';

  @override
  String get decrypting => 'Расшыфроўка...';

  @override
  String get incorrectRecoveryKeyTitle => 'Няправільны ключ аднаўлення';

  @override
  String get incorrectRecoveryKeyBody => 'Вы ўвялі памылковы ключ аднаўлення';

  @override
  String get forgotPassword => 'Нагадаць пароль';

  @override
  String get enterYourRecoveryKey => 'Увядзіце свой ключ аднаўлення';

  @override
  String get noRecoveryKey => 'Няма ключа аднаўлення?';

  @override
  String get sorry => 'Прабачце';

  @override
  String get noRecoveryKeyNoDecryption =>
      'З прычыны архітэктуры нашага пратакола скразнога шыфравання немагчыма расшыфраваць вашы даныя без пароля або ключа аднаўлення';

  @override
  String get verifyEmail => 'Спраўдзіць электронную пошту';

  @override
  String get toResetVerifyEmail =>
      'Спраўдзіце электронную пошту, каб скінуць свой пароль.';

  @override
  String get checkInboxAndSpamFolder =>
      'Праверце свае ўваходныя лісты (і спам) для завяршэння спраўджання';

  @override
  String get tapToEnterCode => 'Націсніце, каб увесці код';

  @override
  String get resendEmail => 'Адправіць ліст яшчэ раз';

  @override
  String weHaveSendEmailTo({required String email}) {
    return 'Ліст адпраўлены на электронную пошту <green>$email</green>';
  }

  @override
  String get setPasswordTitle => 'Задаць пароль';

  @override
  String get changePasswordTitle => 'Змяніць пароль';

  @override
  String get resetPasswordTitle => 'Скінуць пароль';

  @override
  String get encryptionKeys => 'Ключы шыфравання';

  @override
  String get passwordWarning =>
      'Мы не захоўваем гэты пароль і таму, <underline>мы не зможам расшыфраваць вашы даныя</underline>, калі вы забудзеце яго';

  @override
  String get enterPasswordToEncrypt =>
      'Увядзіце пароль, каб мы маглі выкарыстаць яго для расшыфроўкі вашых даных';

  @override
  String get enterNewPasswordToEncrypt =>
      'Увядзіце новы пароль, каб мы маглі выкарыстаць яго для расшыфроўкі вашых даных';

  @override
  String get weakStrength => 'Ненадзейны';

  @override
  String get strongStrength => 'Надзейны';

  @override
  String get moderateStrength => 'Умераны';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'Надзейнасць пароля: $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully => 'Пароль паспяхова зменены';

  @override
  String get generatingEncryptionKeys => 'Генерацыя ключоў шыфравання...';

  @override
  String get pleaseWait => 'Пачакайце...';

  @override
  String get continueLabel => 'Працягнуць';

  @override
  String get insecureDevice => 'Небяспечная прылада';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'Немагчыма згенерыраваць ключы бяспекі на гэтай прыладзе.\n\nЗарэгіструйцеся з іншай прылады.';

  @override
  String get howItWorks => 'Як гэта працуе';

  @override
  String get encryption => 'Шыфраванне';

  @override
  String get ackPasswordLostWarning =>
      'Я ўсведамляю, што калі я страчу свой пароль, то я магу згубіць свае даныя, бо мае даныя абаронены <underline>скразным шыфраваннем</underline>.';

  @override
  String get privacyPolicyTitle => 'Палітыка прыватнасці';

  @override
  String get termsOfServicesTitle => 'Умовы';

  @override
  String get signUpTerms =>
      'Я пагаджаюся з <u-terms>умовамі абслугоўвання</u-terms> і <u-policy>палітыкай прыватнасці</u-policy>';

  @override
  String get logInLabel => 'Увайсці';

  @override
  String get loginTerms =>
      'Націскаючы ўвайсці, я пагаджаюся з <u-terms>умовамі абслугоўвання</u-terms> і <u-policy>палітыкай прыватнасці</u-policy>';

  @override
  String get changeEmail => 'Змяніць адрас электроннай пошты';

  @override
  String get enterYourPassword => 'Увядзіце свой пароль';

  @override
  String get welcomeBack => 'З вяртаннем!';

  @override
  String get contactSupport => 'Звярніцеся ў службу падтрымкі';

  @override
  String get locationPickerTip =>
      'Вы таксама можаце дадаць месцазнаходжанне ў цэнтры фатаграфіі з экрана інфармацыі пра фота';

  @override
  String get incorrectPasswordTitle => 'Няправільны пароль';

  @override
  String get pleaseTryAgain => 'Паспрабуйце яшчэ раз';

  @override
  String get recreatePasswordTitle => 'Стварыць пароль паўторна';

  @override
  String get useRecoveryKey => 'Выкарыстоўваць ключ аднаўлення';

  @override
  String get recreatePasswordBody =>
      'У бягучай прылады недастаткова вылічальнай здольнасці для праверкі вашага паролю, але мы можам регенерыраваць яго, бо гэта працуе з усімі прыладамі.\n\nУвайдзіце, выкарыстоўваючы свой ключа аднаўлення і регенерыруйце свой пароль (калі хочаце, то можаце выбраць папярэдні пароль).';

  @override
  String get verifyPassword => 'Праверыць пароль';

  @override
  String get recoveryKey => 'Ключ аднаўлення';

  @override
  String get recoveryKeyOnForgotPassword =>
      'Адзіным спосабам аднавіць вашы даныя з\'яўляецца гэты ключ, калі вы забылі свой пароль.';

  @override
  String get recoveryKeySaveDescription =>
      'Захавайце гэты ключ, які складаецца з 24 слоў, у наедзеным месцы. Ён не захоўваецца на нашым серверы.';

  @override
  String get doThisLater => 'Зрабіць гэта пазней';

  @override
  String get saveKey => 'Захаваць ключ';

  @override
  String get recoveryKeyCopiedToClipboard =>
      'Ключ аднаўлення скапіяваны ў буфер абмену';

  @override
  String get recoverAccount => 'Аднавіць уліковы запіс';

  @override
  String get recover => 'Аднавіць';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'Адпраўце ліст на паштовы адрас $supportEmail з вашага зарэгістраванага адраса электроннай пошты';
  }

  @override
  String get twofactorSetup => 'Наладжванне двухфактарнай аўтэнтыфікацыі';

  @override
  String get enterCode => 'Увядзіце код';

  @override
  String get scanCode => 'Сканіраваць код';

  @override
  String get codeCopiedToClipboard => 'Код скапіяваны ў буфер абмену';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      'Скапіюйце і ўстаўце гэты код\nу сваю праграму аўтэнтыфікацыі';

  @override
  String get tapToCopy => 'націсніце, каб скапіяваць';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      'Сканіруйце гэты штрых-код з\nдапамогай праграмы аўтэнтыфікацыі';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      'Увядзіце шасцізначны код з\nпраграмы аўтэнтыфікацыі';

  @override
  String get confirm => 'Пацвердзіць';

  @override
  String get setupComplete => 'Наладжванне завершана';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready =>
      'Захавайце свой ключ аднаўлення, калі не рабілі гэта раней';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      'Ён можа быць выкарыстаны для аднаўлення вашага ўліковага запісу, калі страчаны другі фактар аўтэнтыфікацыі';

  @override
  String get twofactorAuthenticationPageTitle => 'Двухфактарная аўтэнтыфікацыя';

  @override
  String get lostDevice => 'Згубілі прыладу?';

  @override
  String get verifyingRecoveryKey => 'Спраўджанне ключа аднаўлення...';

  @override
  String get recoveryKeyVerified => 'Ключ аднаўлення спраўджаны';

  @override
  String get recoveryKeySuccessBody =>
      'Усё ў парадку! Ваш ключ аднаўлення з\'яўляецца сапраўдным.\n\nНе забывайце захоўваць свой ключ аднаўлення ў надзейным месцы.';

  @override
  String get invalidRecoveryKey =>
      'Уведзены ключ аднаўлення з\'яўляецца несапраўдным. Пераканайцеся, што ён змяшчае 24 словы і ўсе словы напісаны слушна.\nКалі ўведзены стары код аднаўлення, то варта пераканацца, што яго даўжыня складае 64 сімвалы і ўсе сімвалы напісаны слушна.';

  @override
  String get invalidKey => 'Памылковы ключ';

  @override
  String get tryAgain => 'Паспрабуйце яшчэ раз';

  @override
  String get viewRecoveryKey => 'Прагледзець ключ аднаўлення';

  @override
  String get confirmRecoveryKey => 'Пацвердзіце ключ аднаўлення';

  @override
  String get recoveryKeyVerifyReason =>
      'Ключ аднаўлення - гэта адзіны спосаб аднавіць вашы фатаграфіі, калі вы забылі пароль. Вы можаце знайсці ключ аднаўлення ў раздзеле «Налады -> Уліковы запіс».\n\nУвядзіце свой ключ аднаўлення тут, каб пераканацца, што ён захаваны слушна.';

  @override
  String get confirmYourRecoveryKey => 'Пацвердзіце свой ключ аднаўлення';

  @override
  String get addViewer => 'Дадаць гледача';

  @override
  String get addCollaborator => 'Дадаць суаўтара';

  @override
  String get admin => 'Admin';

  @override
  String get admins => 'Admins';

  @override
  String get addAdmin => 'Add admin';

  @override
  String get addMoreAdmins => 'Add more admins';

  @override
  String get adminsAndCollaboratorsCanAddPhotosDescription =>
      'Admins and collaborators can add photos. Admins can also manage photos & participants.';

  @override
  String get addANewEmail => 'Дадаць новую электронную пошту';

  @override
  String get orPickAnExistingOne => 'Або выберыце адзін з існуючых';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'Суаўтары могуць дадаваць фатаграфіі і відэа ў абагулены альбом.';

  @override
  String get enterEmail => 'Увядзіце электронную пошту';

  @override
  String get albumOwner => 'Уладальнік';

  @override
  String get you => 'Вы';

  @override
  String get collaborator => 'Суаўтар';

  @override
  String get addMore => 'Дадаць яшчэ';

  @override
  String get viewer => 'Праглядальнік';

  @override
  String get remove => 'Выдаліць';

  @override
  String get removeParticipant => 'Выдаліць удзельніка';

  @override
  String get manage => 'Кіраванне';

  @override
  String get addedAs => 'Дададзена як';

  @override
  String get changePermissions => 'Змяніць дазволы?';

  @override
  String get yesConvertToViewer => 'Так, перавесці ў гледача';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return 'У карыстальніка $user не будзе магчымасці дадаваць іншыя фатаграфіі ў гэты альбом\n\nДадзены карыстальнік усё яшчэ можа выдаляць існуючыя фатаграфіі, якія ён дадаваў раней';
  }

  @override
  String get allowAddingPhotos => 'Дазволіць дадаваць фатаграфіі';

  @override
  String get allowJoiningAlbum => 'Дазволіць далучэнне да альбома';

  @override
  String get allowAddPhotosDescription =>
      'Дазволіць людзям з гэтай спасылкай дадаваць фатаграфіі ў агульны альбом.';

  @override
  String get passwordLock => 'Блакіраванне паролем';

  @override
  String get canNotOpenTitle => 'Немагчыма адкрыць гэты альбом';

  @override
  String get canNotOpenBody =>
      'Прабачце, але гэты альбом немагчыма адкрыць у праграме.';

  @override
  String get disableDownloadWarningTitle => 'Звярніце ўвагу';

  @override
  String get disableDownloadWarningBody =>
      'Улічвайце, што гледачы ўсё яшчэ могуць рабіць здымкі экрана або захоўваць копію вашых фатаграфій пры дапамозе знешніх інструментаў';

  @override
  String get allowDownloads => 'Дазволіць спампоўванні';

  @override
  String get linkDeviceLimit => 'Абмежаванне па прыладах';

  @override
  String get noDeviceLimit => 'Адсутнічае';

  @override
  String get albumLayout => 'Макет альбома';

  @override
  String get layoutGrouped => 'Згрупавана';

  @override
  String get layoutContinuous => 'Бесперапынны';

  @override
  String get layoutTrip => 'Падарожжа';

  @override
  String get preview => 'Перадпрагляд';

  @override
  String get linkExpiry => 'Спасылка пратэрмінавана';

  @override
  String get linkExpired => 'Пратэрмінавана';

  @override
  String get linkEnabled => 'Уключана';

  @override
  String get linkNeverExpires => 'Ніколі';

  @override
  String get expiredLinkInfo =>
      'Гэта спасылка пратэрмінавана. Выберыце новы час тэрміну дзеяння або адключыце тэрмін дзеяння для спасылкі.';

  @override
  String get setAPassword => 'Задаць пароль';

  @override
  String get lockButtonLabel => 'Заблакіраваць';

  @override
  String get enterPassword => 'Увядзіце пароль';

  @override
  String get removeLink => 'Выдаліць спасылку';

  @override
  String get manageLink => 'Кіраваць спасылкай';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'Спасылка міне $expiryTime';
  }

  @override
  String get albumUpdated => 'Альбом абноўлены';

  @override
  String get never => 'Ніколі';

  @override
  String get custom => 'Карыстальніцкія';

  @override
  String get after1Hour => 'Праз 1 гадзіну';

  @override
  String get after1Day => 'Праз 1 дзень';

  @override
  String get after1Week => 'Праз 1 тыдзень';

  @override
  String get after1Month => 'Праз 1 месяц';

  @override
  String get after1Year => 'Праз 1 год';

  @override
  String get manageParticipants => 'Кіраванне';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count удзельнікаў',
      many: '$count удзельнікаў',
      few: '$count удзельнікі',
      one: '1 удзельнік',
      zero: 'Няма ўдзельнікаў',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'Стварыце спасылку, каб людзі маглі дадаваць і праглядаць фатаграфіі ў вашым абагуленым альбоме без неабходнасці ўсталёўваць праграму або ствараць уліковы запіс Ente. Гэта выдатна пасуе для збору фатаграфій з падзей.';

  @override
  String get collectPhotos => 'Збор фатаграфій';

  @override
  String get collaborativeLink => 'Сумесная спасылка';

  @override
  String get shareWithNonenteUsers =>
      'Абагуліць з карыстальнікамі, якія не карыстаюцца Ente';

  @override
  String get createPublicLink => 'Стварыць публічную спасылку';

  @override
  String get sendLink => 'Адправіць спасылку';

  @override
  String get qrCode => 'QR-код';

  @override
  String get sendQrCode => 'Адправіць QR-код';

  @override
  String get copyLink => 'Скапіяваць спасылку';

  @override
  String get copyEmbedHtml => 'Скапіяваць убудаваны HTML';

  @override
  String get linkHasExpired => 'Спасылка пратэрмінавана';

  @override
  String get publicLinkEnabled => 'Публічная спасылка ўключана';

  @override
  String get shareALink => 'Абагуліць спасылку';

  @override
  String get sharedAlbumSectionDescription =>
      'Стварайце абагуленыя і сумесныя альбомы з іншымі карыстальнікамі Ente, уключаючы карыстальнікаў з бясплатным тарыфным планам.';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: 'Абагулена з $numberOfPeople людзьмі',
      one: 'Абагулена з 1 чалавекам',
      zero: 'Абагуліць з пэўнымі людзьмі',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId => 'Гэта ваш ідэнтыфікатар спраўджання';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'Вы і той, хто абагуліў альбом з вамі, павінны бачыць аднолькавы ідэнтыфікатар на сваіх прыладах.';

  @override
  String get howToViewShareeVerificationID =>
      'Папрасіце іх доўга ўтрымліваць палец на сваім паштовым адрасе на экране наладаў і пераканайцеся, што ідэнтыфікатары на абодвух прыладах супадаюць.';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'Гэта ідэнтыфікатар спраўджання $email';
  }

  @override
  String get verificationId => 'Ідэнтыфікатар спраўджання';

  @override
  String verifyEmailID({required Object email}) {
    return 'Спраўджанне $email';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return 'У $email адсутнічае ўліковы запіс Ente.\n\nАдпраўце запрашэнне карыстальніку, каб абагуліць фатаграфіі.';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return 'Вось мой ідэнтыфікатар спраўджання: $verificationID для ente.io.';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'Здароў! Можаш пацвердзіць, што гэта твой ідэнтыфікатар спраўджання ente.io: $verificationID';
  }

  @override
  String get somethingWentWrong => 'Нешта пайшло не так';

  @override
  String get sendInvite => 'Адправіць запрашэнне';

  @override
  String get shareTextRecommendUsingEnte =>
      'Спампуйце Ente для таго, каб мы маглі лёгка змаглі абагуляць фатаграфіі ў зыходнай якасці і відэа\n\nhttps://ente.io';

  @override
  String get done => 'Гатова';

  @override
  String get applyCodeTitle => 'Ужыць код';

  @override
  String get enterCodeDescription =>
      'Увядзіце код, атрыманы ад вашага сябра, каб вы абодва змаглі атрымаць бясплатнае сховішча';

  @override
  String get apply => 'Ужыць';

  @override
  String get failedToApplyCode => 'Не ўдалося ўжыць код';

  @override
  String get enterReferralCode => 'Увядзіце рэферальны код';

  @override
  String get codeAppliedPageTitle => 'Код ужыты';

  @override
  String get changeYourReferralCode => 'Змяніць свой рэферальны код';

  @override
  String get change => 'Змяніць';

  @override
  String get unavailableReferralCode => 'На жаль, гэты код ужо недаступны.';

  @override
  String get codeChangeLimitReached =>
      'На жаль, вы дасягнулі абмежавання па колькасці змяненняў кода.';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'Адпраўце ліст на паштовы адрас $familyAdminEmail, каб змяніць код.';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB ГБ';
  }

  @override
  String get claimed => 'Атрымана';

  @override
  String get details => 'Падрабязнасці';

  @override
  String get claimMore => 'Атрымайце больш!';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return 'Яны таксама атрымаць $storageAmountInGB ГБ';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '$storageAmountInGB ГБ кожны раз, калі нехта стварае падпіску на платны тарыфны план і ўжывае ваш код';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'Рэферальны код Ente: $referralCode\n\nУжыць яго можна ў раздзеле Налады → Агульныя → Рэфералы, каб атрымаць $referralStorageInGB ГБ бясплатнай прасторы пасля пераходу на платны тарыфны план';
  }

  @override
  String get claimFreeStorage => 'Атрымаць бясплатнае сховішча';

  @override
  String get inviteYourFriends => 'Запрасіце сваіх сяброў';

  @override
  String get failedToFetchReferralDetails =>
      'Немагчыма атрымаць падрабязнасці аб рэфералах. Паспрабуйце яшчэ раз пазней.';

  @override
  String get referralStep1 => '1. Перадайце гэты код сваім сябрам';

  @override
  String get referralStep2 => '2. Яны падпісваюцца на платны тарыфны план';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. Вы абодва атрымаеце $storageInGB ГБ* бясплатнага сховішча';
  }

  @override
  String get referralsAreCurrentlyPaused =>
      'Рэфералы ў цяперашні момант прыпынены';

  @override
  String get youCanAtMaxDoubleYourStorage =>
      '* Вы можаце павялічыць сховішча максімум у два разы';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true': 'Ваша сям\'я атрымала $storageAmountInGb ГБ',
      'false': 'Вы атрымалі $storageAmountInGb ГБ',
      'other': 'У дадзены момант вы атрымалі $storageAmountInGb ГБ!',
    });
    return '$_temp0';
  }

  @override
  String get faq => 'Частыя пытанні';

  @override
  String get help => 'Даведка';

  @override
  String get oopsSomethingWentWrong => 'Вой! Нешта пайшло не так';

  @override
  String get peopleUsingYourCode => 'Людзі, якія скарысталіся вашым кодам';

  @override
  String get eligible => 'прыдатны';

  @override
  String get total => 'агулам';

  @override
  String get codeUsedByYou => 'Код, якім вы скарысталіся';

  @override
  String get freeStorageClaimed => 'Атрымана бясплатнае сховішча';

  @override
  String get freeStorageUsable => 'Можна выкарыстаць бясплатнае сховішча';

  @override
  String get usableReferralStorageInfo =>
      'Прыдатнае для захоўвання сховішча абмежавана вашым бягучым тарыфным планам. Лішняя заяўленае сховішча стане аўтаматычна даступна пасля паляпшэння тарыфнага плана.';

  @override
  String get removeFromAlbumTitle => 'Выдаліць з альбома?';

  @override
  String get removeFromAlbum => 'Выдаліць з альбома';

  @override
  String get itemsWillBeRemovedFromAlbum =>
      'Выбраныя элементы будуць выдалены з гэтага альбома';

  @override
  String get removeShareItemsWarning =>
      'Выбраныя фатаграфіі не будуць даступныя нікому з гледачоў гэтага альбома, акрамя іх уладальнікаў.';

  @override
  String get addingToFavorites => 'Дадаванне ў абранае...';

  @override
  String get removingFromFavorites => 'Выдаленне з абраных...';

  @override
  String get sorryCouldNotAddToFavorites => 'Немагчыма дадаць у абраныя!';

  @override
  String get sorryCouldNotRemoveFromFavorites =>
      'Немагчыма выдаліць з абраных!';

  @override
  String get subscribeToEnableSharing =>
      'У вас павінна быць актыўная платная падпіска, каб уключыць абагульванне.';

  @override
  String get subscribeToChangeLinkSetting =>
      'Каб змяніць гэты параметр спасылкі, вам патрэбна платная падпіска.';

  @override
  String get subscribe => 'Падпісацца';

  @override
  String get canOnlyRemoveFilesOwnedByYou =>
      'Можна выдаляць толькі файлы, якія належаць вам';

  @override
  String get deleteSharedAlbum => 'Выдаліць абагулены альбом?';

  @override
  String get deleteAlbum => 'Выдаліць альбом';

  @override
  String get deleteAlbumDialog =>
      'Таксама выдаліць фатаграфіі (і відэа), якое знаходзіцца ў гэтым альбоме з <bold>усіх</bold> іншых альбомаў, часткай якіх яны з\'яўляюцца?';

  @override
  String get deleteSharedAlbumDialogBody =>
      'Альбом будзе выдалены для ўсіх\n\nВы згубіце доступ да агульных фатаграфій у гэтым альбоме, якія належаць іншым удзельнікам';

  @override
  String get yesRemove => 'Так, выдаліць';

  @override
  String get creatingLink => 'Стварэнне спасылкі...';

  @override
  String get removeWithQuestionMark => 'Выдаліць?';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return '$userEmail будзе выдалены з гэтага абагуленага альбома\n\nЛюбыя фатаграфіі, якія дададзены гэтым карыстальнікам, таксама будуць выдалены з альбома';
  }

  @override
  String get keepPhotos => 'Пакінуць фатаграфіі';

  @override
  String get deletePhotos => 'Выдаліць фатаграфіі';

  @override
  String get inviteToEnte => 'Запрасіць у Ente';

  @override
  String get removePublicLink => 'Выдаліць публічную спасылку';

  @override
  String disableLinkMessage({required Object albumName}) {
    return 'Гэта дзеянне прывядзе да выдалення публічнай спасылкі для доступу да «$albumName».';
  }

  @override
  String get sharing => 'Абагульванне...';

  @override
  String get youCannotShareWithYourself =>
      'Нельга абагуліць файлы з самім сабою';

  @override
  String get archive => 'Архіў';

  @override
  String get createAlbumActionHint =>
      'Доўга ўтрымлівайце, каб выбраць фатаграфію, і націсніце «+», каб стварыць альбом';

  @override
  String get importing => 'Імпартаванне....';

  @override
  String get failedToLoadAlbums => 'Не ўдалося загрузіць альбомы';

  @override
  String get hidden => 'Схаваныя';

  @override
  String get authToViewYourHiddenFiles =>
      'Прайдзіце аўтэнтыфікацыю, каб паглядзець схаваныя файлы';

  @override
  String get authToViewTrashedFiles =>
      'Прайдзіце аўтэнтыфікацыю, каб паглядзець выдаленыя файлы';

  @override
  String get trash => 'Сметніца';

  @override
  String get uncategorized => 'Без катэгорыі';

  @override
  String get videoSmallCase => 'відэа';

  @override
  String get photoSmallCase => 'фатаграфіі';

  @override
  String get singleFileDeleteHighlight =>
      'Гэта дзеянне прывядзе да выдалення з усіх альбомаў.';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return 'Гэта $fileType ёсць і ў Ente, і на вашай прыладзе.';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return 'Гэта $fileType будзе выдалена з Ente.';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return 'Гэта $fileType будзе выдалена з вашай прылады.';
  }

  @override
  String get deleteFromEnte => 'Выдаліць з Ente';

  @override
  String get yesDelete => 'Так, выдаліць';

  @override
  String get movedToTrash => 'Перамешчана ў сметніцу';

  @override
  String get deleteFromDevice => 'Выдаліць з прылады';

  @override
  String get deleteFromBoth => 'Выдаліць і ў Ente, і на вашай прыладзе';

  @override
  String get newAlbum => 'Новы альбом';

  @override
  String get albums => 'Альбомы';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount успамінаў',
      many: '$formattedCount успамінаў',
      few: '$formattedCount успаміны',
      one: '$formattedCount успамін',
      zero: 'няма ўспамінаў',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return 'Выбрана: $count';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return 'Выбрана: $count ($yourCount вашы)';
  }

  @override
  String get advancedSettings => 'Дадаткова';

  @override
  String get photoGridSize => 'Памер сеткі фатаграфій';

  @override
  String get manageDeviceStorage => 'Кіраваць кэшам прылады';

  @override
  String get manageDeviceStorageDesc =>
      'Паглядзець і ачысціць лакальны кэш сховішча.';

  @override
  String get machineLearning => 'Машыннае навучанне';

  @override
  String get mlConsent => 'Уключана машыннае навучанне';

  @override
  String get mlConsentTitle => 'Уключыць машыннае навучанне?';

  @override
  String get mlConsentDescription =>
      'Ente будзе вымаць такую ​​інфармацыю з файлаў (таксама з файлаў, якія абагулілі з вамі), як геаметрыя твару.\nДадзены працэс адбываецца на вашай прыладзе, і любая згенерыраваная біяметрычная інфармацыя будзе абаронена скразным шыфраваннем.';

  @override
  String get mlConsentPrivacy =>
      'Націсніце тут, каб атрымаць больш падрабязныя звесткі аб гэтай функцыі ў нашай палітыцы прыватнасці';

  @override
  String get mlConsentConfirmation =>
      'Я разумею і хачу ўключыць машыннае навучанне';

  @override
  String get magicSearch => 'Магічны пошук';

  @override
  String get discover => 'Даведацца';

  @override
  String get discover_identity => 'Ідэнтычнасць';

  @override
  String get discover_screenshots => 'Здымкі экрана';

  @override
  String get discover_receipts => 'Чэкі';

  @override
  String get discover_notes => 'Нататкі';

  @override
  String get discover_memes => 'Мемы';

  @override
  String get discover_visiting_cards => 'Візітныя карткі';

  @override
  String get discover_babies => 'Немаўляты';

  @override
  String get discover_pets => 'Домашнія жывёлы';

  @override
  String get discover_selfies => 'Сэлфi';

  @override
  String get discover_wallpapers => 'Шпалеры';

  @override
  String get discover_food => 'Ежа';

  @override
  String get discover_celebrations => 'Святы';

  @override
  String get discover_sunset => 'Захад сонца';

  @override
  String get discover_hills => 'Узгоркі';

  @override
  String get discover_greenery => 'Зеляніна';

  @override
  String get mlIndexingDescription =>
      'Звярніце ўвагу, што гэта камп\'ютарнае навучанне павялічыць спажыванне трафіку і акумулятара, пакуль усе элементы не будуць праіндэксаваны. Разгледзьце магчымасць зрабіць гэту задачу на камп\'ютары. Усе вынікі будуць сінхранізаваны аўтаматычна.';

  @override
  String get loadingModel => 'Спампоўванне мадэляў...';

  @override
  String get waitingForWifi => 'Чаканне Wi-Fi...';

  @override
  String get status => 'Стан';

  @override
  String get indexedItems => 'Праіндэксаваныя элементы';

  @override
  String get pendingItems => 'Элементы ў чарзе';

  @override
  String get clearIndexes => 'Ачысціць індэксы';

  @override
  String get selectFoldersForBackup =>
      'Выберыце папкі для рэзервовага капіявання';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      'Выбраныя папкі будуць зашыфраваны і захаваны ў рэзервовую копію';

  @override
  String get unselectAll => 'Скасаваць выбар усіх';

  @override
  String get selectAll => 'Выбраць усе';

  @override
  String get skip => 'Прапусціць';

  @override
  String get updatingFolderSelection => 'Абнаўленне выбару папкі...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count элементаў',
      few: '$count элементы',
      one: '$count элемент',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Выдаліць $count элементаў',
      few: 'Выдаліць $count элементы',
      one: 'Выдаліць $count элемент',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return 'Файлаў: $count; кожны з іх па $formattedSize';
  }

  @override
  String get showMemories => 'Паказаць успаміны';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count гадоў таму',
      few: '$count гады таму',
      one: '$count год таму',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'Налады рэзервовага капіявання';

  @override
  String get backupStatus => 'Статус рэзервовага капіявання';

  @override
  String get backupStatusDescription =>
      'Элементы, якія былі захаваны ў рэзервовай копіі, з\'явяцца тут';

  @override
  String get backupOverMobileData => 'Рэзервовая копія праз мабільныя даныя';

  @override
  String get backupVideos => 'Рэзервовае капіяванне відэа';

  @override
  String get disableAutoLock => 'Адключыць аўтаблакіроўку';

  @override
  String get deviceLockExplanation =>
      'Адключыць блакіроўку экрана, калі Ente знаходзіцца на пярэднім плане і выконваецца рэзервовае капіяванне. У большасці выпадкаў гэта не патрабуецца, але можа дапамагчы з вялікімі запампоўваннямі і пры першапачатковым імпартаванні вялікіх бібліятэк.';

  @override
  String get about => 'Аб праграме';

  @override
  String get weAreOpenSource => 'Праграма мае адкрыты зыходны код!';

  @override
  String get privacy => 'Прыватнасць';

  @override
  String get terms => 'Умовы';

  @override
  String get checkForUpdates => 'Праверыць наяўнасць абнаўленняў';

  @override
  String get checkStatus => 'Праверыць статус';

  @override
  String get checking => 'Праверка...';

  @override
  String get youAreOnTheLatestVersion => 'У вас апошняя версія праграмы';

  @override
  String get account => 'Уліковы запіс';

  @override
  String get manageSubscription => 'Кіраваць падпіскай';

  @override
  String get authToChangeYourEmail =>
      'Прайдзіце аўтэнтыфікацыю, каб змяніць электронную пошту';

  @override
  String get changePassword => 'Змяніць пароль';

  @override
  String get authToChangeYourPassword =>
      'Прайдзіце аўтэнтыфікацыю, каб змяніць пароль';

  @override
  String get emailVerificationToggle => 'Спраўджанне электроннай пошты';

  @override
  String get authToChangeEmailVerificationSetting =>
      'Прайдзіце аўтэнтыфікацыю, каб змяніць спраўджанне праз электронную пошту';

  @override
  String get exportYourData => 'Экспартаваць даныя';

  @override
  String get logout => 'Выйсці';

  @override
  String get authToInitiateAccountDeletion =>
      'Прайдзіце аўтэнтыфікацыю, каб пачаць выдаленне ўліковага запісу';

  @override
  String get areYouSureYouWantToLogout => 'Вы сапраўды хочаце выйсці?';

  @override
  String get yesLogout => 'Так, выйсці';

  @override
  String get aNewVersionOfEnteIsAvailable => 'Даступна новая версія Ente.';

  @override
  String get update => 'Абнавіць';

  @override
  String get installManually => 'Усталяваць уручную';

  @override
  String get criticalUpdateAvailable => 'Даступны крытычныя абнаўленні';

  @override
  String get updateAvailable => 'Даступна абнаўленне';

  @override
  String get ignoreUpdate => 'Ігнараваць';

  @override
  String get downloading => 'Спампоўванне...';

  @override
  String get cannotDeleteSharedFiles => 'Немагчыма выдаліць абагуленыя файлы';

  @override
  String get theDownloadCouldNotBeCompleted =>
      'Спампоўка не можа быць завершана';

  @override
  String get retry => 'Паўтарыць';

  @override
  String get backedUpFolders => 'Папкі з рэзервовым капіяваннем';

  @override
  String get backup => 'Рэзервовая копія';

  @override
  String get freeUpDeviceSpace => 'Вызваленне прасторы на прыладзе';

  @override
  String get freeUpDeviceSpaceDesc =>
      'Вызваліце месца на сваёй прыладзе ачысціўшы файлы, якія ўжо зарэзерваваны.';

  @override
  String get allClear => '✨ Усё лаканічна';

  @override
  String get noDeviceThatCanBeDeleted =>
      'На гэтай прыладзе няма файлаў для выдалення';

  @override
  String get removeDuplicates => 'Выдаліць дублікаты';

  @override
  String get removeDuplicatesDesc =>
      'Пераглядзіце і выдаліце дубліраваныя файлы.';

  @override
  String get viewLargeFiles => 'Вялікія файлы';

  @override
  String get viewLargeFilesDesc =>
      'Праглядзіце файлы, якія займаюць найбольш месца на прыладзе.';

  @override
  String get noDuplicates => '✨ Без дублікатаў';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared =>
      'У вас няма дубліраваных файлаў, якія можна ачысціць';

  @override
  String get success => 'Паспяхова';

  @override
  String get rateUs => 'Ацаніце нас';

  @override
  String get remindToEmptyDeviceTrash =>
      'Таксама ачысціце «Нядаўна выдаленыя» з меню «Налады» -> «Сховішча», каб вызваліць месца';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return 'Вы вызвалілі $storageSaved!';
  }

  @override
  String get remindToEmptyEnteTrash =>
      'Таксама ачысціце сметніцу, каб вызваліць месца';

  @override
  String get sparkleSuccess => '✨ Поспех';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count дублікатаў',
      few: '$count дубліката',
      one: '$count дублікат',
    );
    return 'Вы выдалілі $_temp0, вызваліўшы ($storageSaved!)';
  }

  @override
  String get familyPlans => 'Сямейныя тарыфныя планы';

  @override
  String get referrals => 'Рэфералы';

  @override
  String get notifications => 'Апавяшчэнні';

  @override
  String get sharedPhotoNotifications => 'Новыя абагульненыя фатаграфіі';

  @override
  String get sharedPhotoNotificationsExplanation =>
      'Атрымлівайце апавяшчэнні, калі нехта дадае фатаграфію ў абагульнены альбом, да якога вы належыце';

  @override
  String get advanced => 'Дадаткова';

  @override
  String get general => 'Асноўныя';

  @override
  String get security => 'Бяспека';

  @override
  String get authToViewYourRecoveryKey =>
      'Прайдзіце аўтэнтыфікацыю, каб паглядзець свае ключы аднаўлення';

  @override
  String get twofactor => 'Двухфактарная аўтэнтыфікацыя';

  @override
  String get authToConfigureTwofactorAuthentication =>
      'Прайдзіце аўтэнтыфікацыю, каб сканфігурыраваць двухфактарную аўтэнтыфікацыю';

  @override
  String get lockscreen => 'Экран блакіроўкі';

  @override
  String get authToChangeLockscreenSetting =>
      'Прайдзіце аўтэнтыфікацыю, каб змяніць налады блакіроўкі экрана';

  @override
  String get viewActiveSessions => 'Паглядзець актыўныя сеансы';

  @override
  String get authToViewYourActiveSessions =>
      'Прайдзіце аўтэнтыфікацыю, каб паглядзець свае актыўныя сеансы';

  @override
  String get disableTwofactor => 'Адключыць двухфактарную аўтэнтыфікацыю';

  @override
  String get confirm2FADisable =>
      'Вы сапраўды хочаце адключыць двухфактарную аўтэнтыфікацыю?';

  @override
  String get no => 'Не';

  @override
  String get yes => 'Так';

  @override
  String get social => 'Сацыяльныя сеткі';

  @override
  String rateUsOnStore({required Object storeName}) {
    return 'Ацаніць нас у $storeName';
  }

  @override
  String get blog => 'Блог';

  @override
  String get merchandise => 'Тавары';

  @override
  String get twitter => 'Twitter';

  @override
  String get mastodon => 'Mastodon';

  @override
  String get matrix => 'Matrix';

  @override
  String get discord => 'Discord';

  @override
  String get reddit => 'Reddit';

  @override
  String get yourStorageDetailsCouldNotBeFetched =>
      'Не ўдалося атрымаць даныя аб вашым сховішчы';

  @override
  String get reportABug => 'Паведаміць аб памылцы';

  @override
  String get reportBug => 'Паведаміць аб памылцы';

  @override
  String get suggestFeatures => 'Прапанаваць функцыю';

  @override
  String get support => 'Падтрымка';

  @override
  String get theme => 'Тэма';

  @override
  String get lightTheme => 'Светлая';

  @override
  String get darkTheme => 'Цёмная';

  @override
  String get systemTheme => 'Сістэма';

  @override
  String get freeTrial => 'Бясплатная пробны перыяд';

  @override
  String get selectYourPlan => 'Выберыце тарыфны план';

  @override
  String get enteSubscriptionPitch =>
      'Ente захоўвае вашы ўспаміны, таму яны заўсёды даступны вам, нават калі вы згубіце прыладу.';

  @override
  String get enteSubscriptionShareWithFamily =>
      'Ваша сям\'я можа быць уключана ў ваш тарыфны план.';

  @override
  String get currentUsageIs => 'Выкарыстана сховішча: ';

  @override
  String get faqs => 'Частыя пытанні';

  @override
  String renewsOn({required Object endDate}) {
    return 'Наступнае падаўжэнне падпіскі адбудзецца $endDate';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return 'Бясплатны пробны перыяд дзейнічае да $endDate';
  }

  @override
  String validTill({required Object endDate}) {
    return 'Дзейнічае да $endDate';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return 'Ваш дадатак у $storageAmount дзейнічае да $endDate';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return 'Бясплатны пробны перыяд дзейнічае да $endDate.\nПасля яго завяршэння вы можаце выбраць платны тарыфны план.';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'Ваша падпіска будзе скасавана $endDate';
  }

  @override
  String get subscription => 'Падпіска';

  @override
  String get paymentDetails => 'Падрабязнасці плацяжу';

  @override
  String get manageFamily => 'Кіраванне сям\'ёй';

  @override
  String contactToManageSubscription({required Object provider}) {
    return 'Адпраўце ліст на паштовы адрас support@ente.io, каб кіраваць сваёй падпіскай $provider.';
  }

  @override
  String get renewSubscription => 'Падоўжыць падпіску';

  @override
  String get cancelSubscription => 'Скасаваць падпіску';

  @override
  String get areYouSureYouWantToRenew => 'Вы сапраўды хочаце падоўжыць?';

  @override
  String get yesRenew => 'Так, падоўжыць';

  @override
  String get areYouSureYouWantToCancel => 'Вы сапраўды хочаце скасаваць?';

  @override
  String get yesCancel => 'Так, скасаваць';

  @override
  String get failedToRenew => 'Не ўдалося падоўжыць';

  @override
  String get failedToCancel => 'Не ўдалося скасаваць';

  @override
  String get twoMonthsFreeOnYearlyPlans =>
      '2 месяцы ў падарунак пры падпісцы на 1 год';

  @override
  String get monthly => 'Штомесячна';

  @override
  String get yearly => 'Штогод';

  @override
  String get confirmPlanChange => 'Пацвердзіць змяненне тарыфнага плана';

  @override
  String get areYouSureYouWantToChangeYourPlan =>
      'Вы сапраўды хочаце змяніць свой тарыфны план?';

  @override
  String get youCannotDowngradeToThisPlan =>
      'Вы не можаце панізіць да гэтага тарыфнага плана';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'Першапачаткова скасуйце сваю існуючую падпіску ад $paymentProvider';
  }

  @override
  String get optionalAsShortAsYouLike =>
      'Неабавязкова і так коратка, як вы захочаце...';

  @override
  String get send => 'Адправіць';

  @override
  String get askCancelReason =>
      'Ваша падпіска была скасавана. Можа быць вы хочаце распавесці нам прычыну?';

  @override
  String get thankYouForSubscribing => 'Дзякуем за падпіску!';

  @override
  String get yourPurchaseWasSuccessful => 'Вы паспяхова здзейснілі куплю';

  @override
  String get yourPlanWasSuccessfullyUpgraded =>
      'Ваш тарыфны план паспяхова палепшаны';

  @override
  String get yourPlanWasSuccessfullyDowngraded =>
      'Ваш тарыфны план паспяхова паніжаны';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully =>
      'Ваша падпіска была паспяхова абноўлена';

  @override
  String get googlePlayId => 'Ідэнтыфікатар Google Play';

  @override
  String get appleId => 'Ідэнтыфікатар Apple';

  @override
  String get playstoreSubscription => 'Падпіска PlayStore';

  @override
  String get appstoreSubscription => 'Падпіска AppStore';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return 'Ваш $id ужо звязаны з іншым уліковым запісам Ente.\nКалі вы хочаце выкарыстоўваць ваш $id з гэтым уліковым запісам, звярніцеся ў нашу службу падтрымкі';
  }

  @override
  String get visitWebToManage =>
      'Наведайце web.ente.io, каб кіраваць сваёй падпіскай';

  @override
  String get couldNotUpdateSubscription => 'Не ўдалося абнавіць падпіску';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      'Адпраўце ліст на паштовы адрас support@ente.io і мы будзем рады дапамагчы!';

  @override
  String get paymentFailed => 'Збой плацяжу';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return 'Звярніцеся ў падтрымку $providerName, калі з вас спагналі грашовыя сродкі';
  }

  @override
  String get continueOnFreeTrial => 'Працягнуць бясплатны пробны перыяд';

  @override
  String get areYouSureYouWantToExit => 'Вы сапраўды хочаце выйсці?';

  @override
  String get thankYou => 'Дзякуй';

  @override
  String get failedToVerifyPaymentStatus =>
      'Не ўдалося спраўдзіць плацежны статус';

  @override
  String get pleaseWaitForSometimeBeforeRetrying =>
      'Пачакайце крыху перад паўторнай спробай';

  @override
  String get paymentFailedMessage =>
      'На жаль, адбыўся збой вашага плацяжу. Звярніцеся ў службу падтрымкі, каб мы маглі дапамагчы вам!';

  @override
  String get youAreOnAFamilyPlan => 'Вы ўдзельнік сямейнага плана!';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'Звяжыцеся з <green>$familyAdminEmail</green>, каб кіраваць сваёй падпіскай';
  }

  @override
  String get leaveFamily => 'Выйсці з сямейнага плана';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily =>
      'Вы сапраўды хочаце выйсці з сямейнага тарыфнага плана?';

  @override
  String get leave => 'Выйсці';

  @override
  String get rateTheApp => 'Ацаніць праграму';

  @override
  String get startBackup => 'Пачаць рэзервовае капіяванне';

  @override
  String get noPhotosAreBeingBackedUpRightNow =>
      'У дадзены момант не адбываецца рэзервовая копія фатаграфій';

  @override
  String get preserveMore => 'Захаваць больш';

  @override
  String get grantFullAccessPrompt =>
      'Дазвольце доступ да ўсіх фатаграфій у наладах праграмы';

  @override
  String get allowPermTitle => 'Дазволіць доступ да фатаграфій';

  @override
  String get allowPermBody =>
      'Дазвольце доступ да сваіх фатаграфій з налад, каб Ente мог адлюстраваць і зарэзерваваць вашу бібліятэку.';

  @override
  String get openSettings => 'Акдкрыць налады';

  @override
  String get selectMorePhotos => 'Выберыце больш фатаграфій';

  @override
  String get existingUser => 'Бягучы карыстальнік';

  @override
  String get privateBackups => 'Прыватныя рэзервовыя копіі';

  @override
  String get forYourMemories => 'для вашых успамінаў';

  @override
  String get endtoendEncryptedByDefault => 'Прадвызначанае скразное шыфраванне';

  @override
  String get safelyStored => 'Бяспечна захоўваюцца';

  @override
  String get atAFalloutShelter => 'ў бамбасховішчы';

  @override
  String get designedToOutlive => 'Распрацавана на стагоддзі';

  @override
  String get available => 'Даступна';

  @override
  String get everywhere => 'усюды';

  @override
  String get androidIosWebDesktop =>
      'Android, iOS, вэб-праграма, праграма для камп\'ютара';

  @override
  String get mobileWebDesktop =>
      'Праграма для смартфона, вэб-праграма, праграма для камп\'ютара';

  @override
  String get newToEnte => 'Упершыню ў Ente';

  @override
  String get pleaseLoginAgain => 'Аўтарызуйцеся яшчэ раз';

  @override
  String get autoLogoutMessage =>
      'З прычыны тэхнічнага збою ваш сеанс у сістэме быў завершаны. Прыносім прабачэнні за нязручнасці.';

  @override
  String get yourSubscriptionHasExpired =>
      'Тэрмін дзеяння вашай падпіскі завяршыўся';

  @override
  String get storageLimitExceeded => 'Перавышана абмежаванне аб\'ёму сховішча';

  @override
  String get upgrade => 'Палепшыць';

  @override
  String get raiseTicket => 'Падаць запыт';

  @override
  String get backupFailed => 'Збой рэзервовага капіявання';

  @override
  String get sorryBackupFailedDesc =>
      'Немагчыма зрабіць рэзервовую копію гэтага файла ў цяперашні час. Паўторная спроба будзе зроблена пазней.';

  @override
  String get couldNotBackUpTryLater =>
      'Не ўдалося зарэзерваваць вашы даныя.\nПаўторная спроба будзе зроблена пазней.';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      'Ente можа зашыфраваць і захаваць файлы толькі ў тым выпадку, калі будзе прадстаўлены доступ да іх';

  @override
  String get pleaseGrantPermissions => 'Дайце дазволы';

  @override
  String get grantPermission => 'Даць дазволы';

  @override
  String get privateSharing => 'Прыватнае абагульванне';

  @override
  String get shareOnlyWithThePeopleYouWant =>
      'Вы самі выбіраеце людзей з якімі хочаце абагуліць свае даныя';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      'Выкарыстоўваць публічныя спасылкі для людзей, якія не карыстаюцца Ente';

  @override
  String get allowPeopleToAddPhotos => 'Дазволіць людзям дадаваць фатаграфіі';

  @override
  String get shareAnAlbumNow => 'Абагуліць альбом';

  @override
  String get collectEventPhotos => 'Сабраць фатаграфіі падзеі';

  @override
  String get sessionExpired => 'Сеанс завяршыўся';

  @override
  String get loggingOut => 'Выхад...';

  @override
  String get onDevice => 'На прыладзе';

  @override
  String get onEnte => 'У <branding>Ente</branding>';

  @override
  String get name => 'Назва';

  @override
  String get newest => 'Самыя новыя';

  @override
  String get lastUpdated => 'Апошнія абноўленыя';

  @override
  String get deleteEmptyAlbums => 'Выдаліць пустыя альбомы';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => 'Выдаліць пустыя альбомы?';

  @override
  String get deleteAlbumsDialogBody =>
      'Гэта дзеянне прывядзе да выдалення ўсіх пустых альбомаў. Гэта карысна ў выпадку, калі вы хочаце навесці парадак у сваім спісе альбомаў.';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return 'Выдаленне $currentlyDeleting / $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return 'Апрацоўка $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => 'Выдаліць незваротна';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou =>
      'Можна стварыць спасылку толькі для вашых уласных файлаў';

  @override
  String get publicLinkCreated => 'Публічная спасылка створана';

  @override
  String get youCanManageYourLinksInTheShareTab =>
      'Вы можаце кіраваць сваімі спасылкамі ва ўкладцы з абагуленымі элементамі.';

  @override
  String get linkCopiedToClipboard => 'Спасылка скапіявана ў буфер абмену';

  @override
  String get restore => 'Аднавіць';

  @override
  String get moveToAlbum => 'Перамясціць у альбом';

  @override
  String get unhide => 'Паказаць';

  @override
  String get unarchive => 'Вывесці з архіва';

  @override
  String get favorite => 'Абраныя';

  @override
  String get removeFromFavorite => 'Выдаліць з абранага';

  @override
  String get shareLink => 'Абагуліць спасылку';

  @override
  String get createCollage => 'Стварыць калаж';

  @override
  String get saveCollage => 'Захаваць калаж';

  @override
  String get collageSaved => 'Калаж захаваны ў галерэі';

  @override
  String get collageLayout => 'Макет';

  @override
  String get addToEnte => 'Дадаць у Ente';

  @override
  String get addToAlbum => 'Дадаць у альбом';

  @override
  String get delete => 'Выдаліць';

  @override
  String get hide => 'Схаваць';

  @override
  String get share => 'Абагуліць';

  @override
  String get unhideToAlbum => 'Паказаць альбом';

  @override
  String get restoreToAlbum => 'Аднавіць у альбом';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Перамясціць элементы',
      one: 'Перамясціць элемент',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Дадаць элементы',
      one: 'Дадаць элемент',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'Стварыць або выбраць альбом';

  @override
  String get selectAlbum => 'Выбраць альбом';

  @override
  String get searchByAlbumNameHint => 'Назва альбома';

  @override
  String get albumTitle => 'Назва альбома';

  @override
  String get enterAlbumName => 'Увядзіце назву альбома';

  @override
  String get restoringFiles => 'Аднаўленне файлаў...';

  @override
  String get movingFilesToAlbum => 'Перамяшчэнне файлаў у альбом...';

  @override
  String get unhidingFilesToAlbum => 'Паказ файлаў у альбоме';

  @override
  String get canNotUploadToAlbumsOwnedByOthers =>
      'Нельга запампоўваць у альбомы, якія належаць іншым';

  @override
  String get uploadingFilesToAlbum => 'Запампоўванне файлаў у альбом...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return 'Паспяхова дададзена ў $albumName';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return 'Паспяхова перамешчана ў $albumName';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'У гэтага альбома ўжо ёсць сумесная спасылка';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return 'Сумесная спасылка створана для $albumName';
  }

  @override
  String get askYourLovedOnesToShare => 'Папрасіце блізкіх абагуліць';

  @override
  String get invite => 'Запрасіць';

  @override
  String get shareYourFirstAlbum => 'Абагуліце свой першы альбом';

  @override
  String sharedWith({required Object emailIDs}) {
    return 'Абагулена з $emailIDs';
  }

  @override
  String get sharedWithMe => 'Абагулена са мной';

  @override
  String get sharedByMe => 'Абагулена мной';

  @override
  String get doubleYourStorage => 'Падвоіць сваё сховішча';

  @override
  String get referFriendsAnd2xYourPlan =>
      'Запрасіце сяброў і падвойце свой тарыфны план';

  @override
  String get shareAlbumHint =>
      'Адкрыйце альбом і націсніце кнопку абагульвання ў верхнім правым куце.';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      'На элементах паказваецца колькасць дзён, якая засталася да іх незваротнага выдалення';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count дзён',
      few: '$count дні',
      one: '1 дзень',
      zero: 'Неўзабаве',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => 'Выдаліць усе';

  @override
  String get renameAlbum => 'Перайменаваць альбом';

  @override
  String get convertToAlbum => 'Пераўтварыць у альбом';

  @override
  String get setCover => 'Задаць вокладку';

  @override
  String get sortAlbumsBy => 'Сартаваць па';

  @override
  String get sortNewestFirst => 'Спачатку самыя новыя';

  @override
  String get sortOldestFirst => 'Спачатку самыя старыя';

  @override
  String get rename => 'Перайменаваць';

  @override
  String get leaveSharedAlbum => 'Выйсці з абагуленага альбома?';

  @override
  String get leaveAlbum => 'Выйсці з альбома';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'Дададзеныя вамі фатаграфіі будуць выдалены з альбома';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted =>
      'У гэтым альбоме адсутнічаюць файлы, якія можна выдаліць';

  @override
  String get youDontHaveAnyArchivedItems =>
      'У вас адсутнічаюць архіўныя элементы.';

  @override
  String get ignoredFolderUploadReason =>
      'Некаторыя файлы ў гэтым альбоме ігнаруюцца, бо яны раней былі выдалены з Ente.';

  @override
  String get resetIgnoredFiles => 'Скінуць ігнараваныя файлы';

  @override
  String get deviceFilesAutoUploading =>
      'Файлы, дададзеныя ў гэты альбом на прыладзе, будуць аўтаматычна запампаваны ў Ente.';

  @override
  String get turnOnBackupForAutoUpload =>
      'Уключыце рэзервовае капіяванне, каб аўтаматычна запампоўваць дададзеныя файлы да папкі прылады ў Ente.';

  @override
  String get noHiddenPhotosOrVideos =>
      'Адсутнічаюць схаваныя фатаграфіі або відэа';

  @override
  String get toHideAPhotoOrVideo => 'Схаваць фатаграфіі або відэа';

  @override
  String get openTheItem => '• Адкрыць элемент';

  @override
  String get clickOnTheOverflowMenu => '• Націсніце на дадатковае меню';

  @override
  String get click => '• Націсніце';

  @override
  String get nothingToSeeHere => 'Тут нічога няма! 👀';

  @override
  String get unarchiveAlbum => 'Вывесці альбом з архіва';

  @override
  String get archiveAlbum => 'Архіваваць альбом';

  @override
  String get calculating => 'Падлік...';

  @override
  String get pleaseWaitDeletingAlbum => 'Выдаленне альбома. Пачакайце...';

  @override
  String get searchByExamples =>
      '• Назвы альбомаў (напрыклад, «Камера»)\n• Тыпы файлаў (напрыклад, «Відэа», «.gif»)\n• Гады і месяцы (напрыклад, «2022», «Студзень»)\n• Святы (напрыклад, «Каляды»)\n• Апісанне фатаграфій (напрыклад, «#забава»)';

  @override
  String get youCanTrySearchingForADifferentQuery =>
      'Паспрабуйце пашукаць з іншым запытам.';

  @override
  String get noResultsFound => 'Нічога не знойдзена';

  @override
  String addedBy({required Object emailOrName}) {
    return 'Дададзена $emailOrName';
  }

  @override
  String get loadingExifData => 'Загрузка даных EXIF...';

  @override
  String get viewAllExifData => 'Паглядзець усе даныя EXIF';

  @override
  String get noExifData => 'Даныя EXIF адсутнічаюць';

  @override
  String get thisImageHasNoExifData => 'Гэты відарыс не змяшчае даных EXIF';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => 'Вынікі адсутнічаюць';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'Мы не падтрымліваем рэдагаванне фатаграфій і альбомаў, якімі вы пакуль не валодаеце';

  @override
  String get failedToFetchOriginalForEdit =>
      'Не ўдалося атрымаць арыгінал для рэдагавання';

  @override
  String get close => 'Закрыць';

  @override
  String get setAs => 'Задаць як';

  @override
  String get fileSavedToGallery => 'Файл захаваны ў галерэю';

  @override
  String get filesSavedToGallery => 'Файлы захаваны ў галерэю';

  @override
  String get fileFailedToSaveToGallery => 'Не ўдалося захаваць файл у галерэю';

  @override
  String get download => 'Спампаваць';

  @override
  String get pressAndHoldToPlayVideo =>
      'Націсніце і ўтрымлівайце, каб узнавіць відэа';

  @override
  String get pressAndHoldToPlayVideoDetailed =>
      'Націсніце і ўтрымлівайце на відарысе, каб узнавіць відэа';

  @override
  String get downloadFailed => 'Збой спампоўвання';

  @override
  String get deduplicateFiles => 'Дубліраваныя файлы';

  @override
  String get deselectAll => 'Зняць выбар з усіх';

  @override
  String get reviewDeduplicateItems =>
      'Паглядзіце і выдаліце элементы, якія лічыце дубліраванымі.';

  @override
  String get clubByCaptureTime => 'Групаваць па часе захопу';

  @override
  String get clubByFileName => 'Групаваць па назве файла';

  @override
  String get count => 'Колькасць';

  @override
  String get totalSize => 'Агульны памер';

  @override
  String get longpressOnAnItemToViewInFullscreen =>
      'Доўгі націск на элемент для прагляду ў поўнаэкранны рэжыме';

  @override
  String get decryptingVideo => 'Расшыфроўка відэа...';

  @override
  String get authToViewYourMemories =>
      'Прайдзіце аўтэнтыфікацыю, каб паглядзець свае ўспаміны';

  @override
  String get unlock => 'Разблакіраваць';

  @override
  String get freeUpSpace => 'Вызваліць прастору';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Іх можна выдаліць з прылады, каб вызваліць $formattedSize',
      one: 'Яго можна выдаліць з прылады, каб вызваліць $formattedSize',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Для $formattedNumber файлаў у',
      one: 'Для 1 файла ў',
    );
    return '$_temp0 гэтым альбоме была створана рэзервовая копія';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Для $formattedNumber файлаў',
      one: 'Для 1 файла',
    );
    return '$_temp0 на гэтай прыладзе была створана рэзервовая копія';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'іх у',
      one: 'яго ў',
    );
    return 'Вы ўсё яшчэ можаце атрымаць доступ да $_temp0 Ente, пакуль у вас актыўная падпіска';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return 'Вызваліць $sizeInMBorGB';
  }

  @override
  String get thisEmailIsAlreadyInUse =>
      'Гэта электронная пошта ўжо выкарыстоўваецца';

  @override
  String get incorrectCode => 'Няправільны код';

  @override
  String get authenticationFailedPleaseTryAgain =>
      'Збой аўтэнтыфікацыі. Паспрабуйце яшчэ раз';

  @override
  String get verificationFailedPleaseTryAgain =>
      'Збой спраўджання. Паспрабуйце яшчэ раз';

  @override
  String get authenticating => 'Аўтэнтыфікацыя...';

  @override
  String get authenticationSuccessful => 'Аўтэнтыфікацыя паспяхова пройдзена!';

  @override
  String get incorrectRecoveryKey => 'Няправільны ключ аднаўлення';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect =>
      'Вы ўвялі памылковы ключ аднаўлення';

  @override
  String get twofactorAuthenticationSuccessfullyReset =>
      'Двухфактарная аўтэнтыфікацыя паспяхова скінута';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered =>
      'Спраўдзіце ўведзены вамі код';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      'Звяжыцеся са службай падтрымкі, калі праблема застанецца';

  @override
  String get twofactorAuthenticationHasBeenDisabled =>
      'Двухфактарная аўтэнтыфікацыя была адключана';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect =>
      'Уведзены вамі код з\'яўляецца няправільным';

  @override
  String get yourVerificationCodeHasExpired =>
      'Ваш код спраўджання пратэрмінаваны';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'Электронная пошта зменена на $newEmail';
  }

  @override
  String get verifying => 'Спраўджанне...';

  @override
  String get disablingTwofactorAuthentication =>
      'Адключэнне двухфактарнай аўтэнтыфікацыі...';

  @override
  String get allMemoriesPreserved => 'Усе ўспаміны захаваны';

  @override
  String get loadingGallery => 'Загрузка галерэі...';

  @override
  String get syncing => 'Сінхранізацыя...';

  @override
  String get encryptingBackup => 'Шыфраванне рэзервовай копіі...';

  @override
  String get syncStopped => 'Сінхранізацыя спынена';

  @override
  String syncProgress({required String completed, required String total}) {
    return '$completed/$total успамінаў захавана';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return 'Захавана ўспамінаў: $count...';
  }

  @override
  String get uploadingSingleMemory => 'Захаваны 1 успамін...';

  @override
  String get archiving => 'Дадаванне ў архіў...';

  @override
  String get unarchiving => 'Выманне з архіва...';

  @override
  String get successfullyArchived => 'Паспяхова дададзена ў архіў';

  @override
  String get successfullyUnarchived => 'Паспяхова вынята з архіва';

  @override
  String get renameFile => 'Перайменаваць файл';

  @override
  String get enterFileName => 'Увядзіце назву файла';

  @override
  String get filesDeleted => 'Файлы выдалены';

  @override
  String get selectedFilesAreNotOnEnte => 'Выбраныя файлы адсутнічаюць у Ente';

  @override
  String get thisActionCannotBeUndone => 'Гэта дзеянне немагчыма адрабіць';

  @override
  String get emptyTrash => 'Ачысціць сметніцу?';

  @override
  String get permDeleteWarning =>
      'Усе элементы будуць незваротна выдалены\n\nГэта дзеянне немагчыма будзе адрабіць';

  @override
  String get empty => 'Ачысціць';

  @override
  String get couldNotFreeUpSpace => 'Не ўдалося вызваліць месца';

  @override
  String get permanentlyDeleteFromDevice => 'Незваротна выдаліць з прылады?';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      'Некаторыя файлы, якія вы спрабуеце выдаліць, даступны толькі на вашай прыладзе і іх немагчыма будзе аднавіць пасля выдалення';

  @override
  String get theyWillBeDeletedFromAllAlbums =>
      'Яны будуць выдалены з усіх альбомаў.';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'Некаторыя элементы знаходзяцца як у сховішчы Ente, так і на вашай прыладзе.';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      'Выбраныя элементы будуць выдалены з усіх альбомаў і перамешчаны ў сметніцу.';

  @override
  String get theseItemsWillBeDeletedFromYourDevice =>
      'Гэтыя элементы будуць выдалены з усіх вашых прылад.';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      'Здаецца, што нешта пайшло не так. Паспрабуйце яшчэ раз крыху пазней. Звяжыцеся са службай падтрымкі, калі праблема захаваецца.';

  @override
  String get error => 'Памылка';

  @override
  String get tempErrorContactSupportIfPersists =>
      'Здаецца, што нешта пайшло не так. Паспрабуйце яшчэ раз крыху пазней. Звяжыцеся са службай падтрымкі, калі праблема захаваецца.';

  @override
  String get networkHostLookUpErr =>
      'Немагчыма падключыцца да сервера Ente. Праверце свае сеткавыя налады. Звярніцеся ў службу падтрымкі кліентаў, калі праблема застанецца.';

  @override
  String get networkConnectionRefusedErr =>
      'Немагчыма падключыцца да Ente. Паспрабуйце яшчэ раз праз некаторы час. Звярніцеся ў службу падтрымкі кліентаў, калі праблема застанецца.';

  @override
  String get cachedData => 'Даныя ў кэшы';

  @override
  String get clearCaches => 'Ачысціць кэш';

  @override
  String get remoteImages => 'Аддаленыя відарысы';

  @override
  String get remoteVideos => 'Аддаленыя відэа';

  @override
  String get remoteThumbnails => 'Аддаленыя мініяцюры';

  @override
  String get pendingSync => 'Чаканне сінхранізацыі';

  @override
  String get localGallery => 'Лакальная галерэя';

  @override
  String get todaysLogs => 'Сённяшнія журналы';

  @override
  String get viewLogs => 'Паглядзець журналы';

  @override
  String get logsDialogBody =>
      'Гэта дзеянне прывядзе да адпраўкі журналаў, якія дапамогуць нам адладзіць вашу праблему. Звярніце ўвагу, што назвы файлаў будуць уключаны для адсочвання праблем з канкрэтнымі файламі.';

  @override
  String get preparingLogs => 'Падрыхтоўка журналаў...';

  @override
  String get emailYourLogs => 'Адправіць журналы';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'Адпраўце журналы на \n$toEmail';
  }

  @override
  String get copyEmailAddress => 'Скапіяваць адрас электроннай пошты';

  @override
  String get exportLogs => 'Экспартаваць журналы';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return 'Адпраўце ліст на паштовы адрас $toEmail';
  }

  @override
  String get dismiss => 'Адхіліць';

  @override
  String get didYouKnow => 'Ці ведалі вы што?';

  @override
  String get loadingMessage => 'Загрузка вашых фатаграфій...';

  @override
  String get loadMessage1 =>
      'У вас ёсць магчымасць абагуліць падпіску з вашай сям\'ёй';

  @override
  String get loadMessage2 =>
      'У цяперашні час на нашых серверах захоўваецца больш за 200 мільёнаў успамінаў';

  @override
  String get loadMessage3 =>
      'У нас захоўваецца 3 копіі вашых даных і адна з іх захоўваецца ў бамбасховішчы';

  @override
  String get loadMessage4 => 'Усе нашы праграмы маюць адкрыты зыходны код';

  @override
  String get loadMessage5 =>
      'Наш зыходны код і крыптаграфія правераны незалежнымі экспертамі';

  @override
  String get loadMessage6 =>
      'Вы можаце абагуляць спасылкі на свае альбомы з блізкімі людзьмі';

  @override
  String get loadMessage7 =>
      'Нашы мабільныя праграмы працуюць у фонавым рэжыме, каб шыфраваць і рэзерваваць усе новыя фатаграфіі, якія вы здымаеце';

  @override
  String get loadMessage8 =>
      'web.ente.io мае зручны інструмент для запампоўвання файлаў';

  @override
  String get loadMessage9 =>
      'Мы выкарыстоўваем Xchacha20Poly1305 для бяспечнага шыфравання вашых даных';

  @override
  String get photoDescriptions => 'Апісанне фатаграфій';

  @override
  String get fileTypesAndNames => 'Тыпы файлаў і назвы';

  @override
  String get location => 'Месцазнаходжанне';

  @override
  String get moments => 'Моманты';

  @override
  String get searchFaceEmptySection =>
      'Людзі будуць паказаны тут пасля завяршэння індэксацыі';

  @override
  String get searchDatesEmptySection => 'Пошук па даце, месяцу або году';

  @override
  String get searchLocationEmptySection =>
      'Групуйце фатаграфіі, якія зроблены ў пэўным радыусе ад фатаграфіі';

  @override
  String get searchPeopleEmptySection =>
      'Запрашайце людзей, і вы ўбачыце ўсе фатаграфіі, якія яны абагулілі';

  @override
  String get searchAlbumsEmptySection => 'Альбомы';

  @override
  String get searchFileTypesAndNamesEmptySection => 'Тыпы файлаў і назвы';

  @override
  String get searchCaptionEmptySection =>
      'Дадайце апісанне накшталт «#падарожжа» ў звесткі аб фатаграфіі, каб хутка знайсці яе тут';

  @override
  String get language => 'Мова';

  @override
  String get selectLanguage => 'Выберыце мову';

  @override
  String get locationName => 'Назва месцазнаходжання';

  @override
  String get addLocation => 'Дадаць месцазнаходжанне';

  @override
  String get groupNearbyPhotos => 'Групаваць найбліжэйшыя фатаграфіі';

  @override
  String get kiloMeterUnit => 'км';

  @override
  String get addLocationButton => 'Дадаць';

  @override
  String get radius => 'Радыус';

  @override
  String get locationTagFeatureDescription =>
      'Тэг месцазнаходжання групуе ўсе фатаграфіі, якія зроблены ў пэўным радыусе ад фатаграфіі';

  @override
  String get galleryMemoryLimitInfo =>
      'У галерэі паказваецца да 1000 успамінаў';

  @override
  String get save => 'Захаваць';

  @override
  String get centerPoint => 'Цэнтральны пункт';

  @override
  String get pickCenterPoint => 'Выберыце цэнтральны пункт';

  @override
  String get useSelectedPhoto => 'Выкарыстоўвайце выбраную фатаграфію';

  @override
  String get resetToDefault => 'Скінуць да прадвызначаных';

  @override
  String get edit => 'Рэдагаваць';

  @override
  String get deleteLocation => 'Выдаліць месцазнаходжанне';

  @override
  String get rotateLeft => 'Павярнуць улева';

  @override
  String get flip => 'Перавярнуць';

  @override
  String get rotateRight => 'Павярнуць управа';

  @override
  String get saveCopy => 'Захаваць копію';

  @override
  String get light => 'Светлая';

  @override
  String get color => 'Колер';

  @override
  String get yesDiscardChanges => 'Так, адхіліць змены';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade =>
      'Вы сапраўды хочаце адхіліць зробленыя рэдагаванні?';

  @override
  String get saving => 'Захаванне...';

  @override
  String get editsSaved => 'Рэдагаванні захаваны';

  @override
  String get oopsCouldNotSaveEdits => 'Вой! Не ўдалося захаваць рэдагаванні';

  @override
  String get distanceInKMUnit => 'км';

  @override
  String get dayToday => 'Сёння';

  @override
  String get dayYesterday => 'Учора';

  @override
  String get storage => 'Сховішча';

  @override
  String get usedSpace => 'Выкарыстаная прастора';

  @override
  String get storageBreakupFamily => 'Сямейны';

  @override
  String get storageBreakupYou => 'Вы';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return 'Выкарыстана $usedAmount $usedStorageUnit з $totalAmount $totalStorageUnit';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return 'Вольна $freeAmount $storageUnit';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'Версія: $versionValue';
  }

  @override
  String get verifyIDLabel => 'Спраўдзіць';

  @override
  String get fileInfoAddDescHint => 'Дадаць апісанне...';

  @override
  String get editLocationTagTitle => 'Змяніць месцазнаходжанне';

  @override
  String get setLabel => 'Задаць';

  @override
  String get setRadius => 'Задаць радыус';

  @override
  String get familyPlanPortalTitle => 'Сямейны';

  @override
  String get familyPlanOverview =>
      'Дадайце 5 членаў сям\'і да бягучага тарыфнага плана без дадатковай платы.\n\nКожны член атрымае сваю ўласную прыватную прастору і не зможа бачыць файлы іншых, пакуль яны не будуць абагулены.\n\nСямейныя тарыфныя планы даступны для кліентаў з платнай падпіскай Ente.\n\nПадпішыцеся, каб скарыстацца прапановай!';

  @override
  String get androidBiometricHint => 'Спраўдзіць ідэнтычнасць';

  @override
  String get androidBiometricNotRecognized =>
      'Не распазнана. Паспрабуйце яшчэ раз.';

  @override
  String get androidBiometricSuccess => 'Паспяхова';

  @override
  String get androidCancelButton => 'Скасаваць';

  @override
  String get androidSignInTitle => 'Патрабуецца аўтэнтыфікацыя';

  @override
  String get androidBiometricRequiredTitle => 'Патрабуецца біяметрыя';

  @override
  String get androidDeviceCredentialsRequiredTitle =>
      'Патрабуюцца ўліковыя даныя прылады';

  @override
  String get androidDeviceCredentialsSetupDescription =>
      'Патрабуюцца ўліковыя даныя прылады';

  @override
  String get goToSettings => 'Перайсці ў налады';

  @override
  String get androidGoToSettingsDescription =>
      'Біяметрычная аўтэнтыфікацыя не наладжана на вашай прыладзе. Перайдзіце ў раздзел «Налады > Бяспека», каб дадаць біяметрычную аўтэнтыфікацыю.';

  @override
  String get iOSLockOut =>
      'Біяметрычная аўтэнтыфікацыя адключана. Заблакіруйце, а потым разблакіруйце экран для яе ўключэння.';

  @override
  String get iOSGoToSettingsDescription =>
      'Біяметрычная аўтэнтыфікацыя не наладжана на вашай прыладзе. Уключыце Touch ID або Face ID на вашай прыладзе.';

  @override
  String get iOSOkButton => 'OK';

  @override
  String get openstreetmapContributors => 'Удзельнікі OpenStreetMap';

  @override
  String get hostedAtOsmFrance => 'Размешчана на OSM France';

  @override
  String get map => 'Карта';

  @override
  String get maps => 'Карты';

  @override
  String get mapsPrivacyNotice =>
      'Прыблізныя каардынаты будуць адпраўлены з улікам прыватнасці трэціх асоб, такіх як OpenStreetMap, каб паказаць карту і месцазнаходжанне.';

  @override
  String get enableMaps => 'Уключыць карты';

  @override
  String get quickLinks => 'Хуткія спасылкі';

  @override
  String get selectItemsToAdd => 'Выберыце элементы, каб дадаць іх';

  @override
  String get addSelected => 'Дадаць выбраныя';

  @override
  String get addFromDevice => 'Дадаць з прылады';

  @override
  String get addPhotos => 'Дадаць фатаграфіі';

  @override
  String get noPhotosFoundHere => 'Тут фатаграфій не знойдзена';

  @override
  String get zoomOutToSeePhotos => 'Паменшыць маштаб, каб убачыць фатаграфіі';

  @override
  String get noImagesWithLocation =>
      'Відарысы з месцазнаходжаннем адсутнічаюць';

  @override
  String get unpinAlbum => 'Адмацаваць альбом';

  @override
  String get pinAlbum => 'Замацаваць альбом';

  @override
  String get pin => 'Замацаваць';

  @override
  String get pinPerson => 'Замацаваць асобу';

  @override
  String get pinToTop => 'Замацаваць уверсе';

  @override
  String get unpin => 'Адмацаваць';

  @override
  String get unpinPerson => 'Адмацаваць асобу';

  @override
  String get visibility => 'Бачнасць';

  @override
  String get hideFromMemories => 'Схаваць ад успамінаў';

  @override
  String get showInMemories => 'Паказаць ва ўспамінах';

  @override
  String get create => 'Стварыць';

  @override
  String get viewAll => 'Паглядзець усе';

  @override
  String get nothingSharedWithYouYet => 'Пакуль з вамі нічога не абагулена';

  @override
  String get noAlbumsSharedByYouYet =>
      'Ніякія альбомы пакуль не абагулены вамі';

  @override
  String get sharedWithYou => 'Абагулена з вамі';

  @override
  String get sharedByYou => 'Абагулена вамі';

  @override
  String get inviteYourFriendsToEnte => 'Запрасіце сваіх сяброў у Ente';

  @override
  String get failedToDownloadVideo => 'Не ўдалося спампаваць відэа';

  @override
  String get hiding => 'Хаванне...';

  @override
  String get unhiding => 'Паказ...';

  @override
  String get successfullyHid => 'Паспяхова схавана';

  @override
  String get successfullyUnhid => 'Паспяхова паказана';

  @override
  String get crashReporting => 'Справаздачы аб збоях';

  @override
  String get resumableUploads => 'Запампоўванні з магчымасцю ўзнаўлення';

  @override
  String get addToHiddenAlbum => 'Дадаць у схаваны альбом';

  @override
  String get moveToHiddenAlbum => 'Перамясціць у схаваны альбом';

  @override
  String get fileTypes => 'Тыпы файлаў';

  @override
  String get deleteConfirmDialogBody =>
      'Гэты ўліковы запіс звязаны з іншымі праграмамі Ente, калі вы імі карыстаецеся. Запампаваныя вамі даныя будуць запланаваны да выдалення ва ўсіх праграмах Ente, а ваш уліковы запіс будзе незваротна выдалены.';

  @override
  String get hearUsWhereTitle => 'Адкуль вы пачулі пра Ente? (неабавязкова)';

  @override
  String get hearUsExplanation =>
      'Наша каманда не збірае статыстыку ўсталяванняў. Нам вельмі дапаможа, калі вы абагуліце інфармацыю, дзе вы знайшлі нашу праграму!';

  @override
  String get viewAddOnButton => 'Паглядзець дадаткі';

  @override
  String get addOns => 'Дадаткі';

  @override
  String get addOnPageSubtitle => 'Падрабязнасці дадаткаў';

  @override
  String get yourMap => 'Ваша карта';

  @override
  String get modifyYourQueryOrTrySearchingFor =>
      'Змяніце свой запыт або паспрабуйце шукаць';

  @override
  String get blackFridaySale => 'Распродаж з нагоды «Чорнай пятніцы»';

  @override
  String get upto50OffUntil4thDec => 'Скідка ў памеры 50% да 4-га снежня.';

  @override
  String get photos => 'Фатаграфіі';

  @override
  String get videos => 'Відэа';

  @override
  String get livePhotos => 'Live Photos';

  @override
  String get searchHint1 => 'Хуткі пошук на прыладзе';

  @override
  String get searchHint2 => 'Даты фатаграфій і іх апісанне';

  @override
  String get searchHint3 => 'Альбомы, назвы і тыпы файлаў';

  @override
  String get searchHint4 => 'Месцазнаходжанне';

  @override
  String get searchHint5 => 'Неўзабаве чакаецца: твары і магічны пошук ✨';

  @override
  String get addYourPhotosNow => 'Дадайце свае фатаграфіі';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Знойдзены $count вынікаў',
      many: 'Знойдзены $count вынікаў',
      few: 'Знойдзены $count вынікі',
      one: 'Знойдзены $count вынік',
    );
    return '$_temp0';
  }

  @override
  String get faces => 'Твары';

  @override
  String get people => 'Людзі';

  @override
  String get contents => 'Змесціва';

  @override
  String get addNew => 'Дадаць новы';

  @override
  String get contacts => 'Кантакты';

  @override
  String get noInternetConnection => 'Адсутнічае падключэнне да інтэрнэту';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'Праверце злучэнне з інтэрнэтам і паспрабуйце яшчэ раз.';

  @override
  String get signOutFromOtherDevices => 'Выйсці з іншых прылад';

  @override
  String get signOutOtherBody =>
      'Вы можаце прымусова закрыць сеанс на ўсіх прыладах, калі думаеце, што ваш пароль скампраметаваны.';

  @override
  String get signOutOtherDevices => 'Выйсці на іншых прыладах';

  @override
  String get doNotSignOut => 'Не выходзіць';

  @override
  String get editLocation => 'Змяніць месцазнаходжанне';

  @override
  String get selectALocation => 'Выбраць месцазнаходжанне';

  @override
  String get selectALocationFirst => 'Спачатку выберыце месцазнаходжанне';

  @override
  String get changeLocationOfSelectedItems =>
      'Змяніць месцазнаходжанне выбраных элементаў?';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte =>
      'Рэдагаванні месцазнаходжання будзе бачна толькі ў Ente';

  @override
  String get cleanUncategorized => 'Ачысціць «Без катэгорыі»';

  @override
  String get cleanUncategorizedDescription =>
      'Выдаліць у раздзеле «Без катэгорыі» ўсе файлы, якія прысутнічаюць у іншых альбомах';

  @override
  String get waitingForVerification => 'Чаканне спраўджання...';

  @override
  String get passkey => 'Ключ доступу';

  @override
  String get passkeyAuthTitle => 'Спраўджанне ключа доступу';

  @override
  String get loginWithTOTP => 'Увайсці з TOTP';

  @override
  String get passKeyPendingVerification =>
      'Спраўджанне пакуль яшчэ не завершана';

  @override
  String get loginSessionExpired => 'Сеанс завяршыўся';

  @override
  String get loginSessionExpiredDetails =>
      'Ваш сеанс завяршыўся. Увайдзіце яшчэ раз.';

  @override
  String get verifyPasskey => 'Спраўдзіць ключ доступу';

  @override
  String get playOnTv => 'Узнавіць альбом на тэлевізары';

  @override
  String get pair => 'Спалучыць';

  @override
  String get deviceNotFound => 'Прылада не знойдзена';

  @override
  String get castInstruction =>
      'Наведайце cast.ente.io на прыладзе, якую хочаце спалучыць.\n\nУвядзіце кода ніжэй, каб прайграць альбом на тэлевізары.';

  @override
  String get deviceCodeHint => 'Увядзіце код';

  @override
  String get joinDiscord => 'Далучыцца да Discord';

  @override
  String get locations => 'Месцазнаходжанні';

  @override
  String get addAName => 'Дадаць назву';

  @override
  String get findThemQuickly => 'Знаходзьце іх хутка';

  @override
  String get findPeopleByName => 'Хутка знаходзьце людзей па імі';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Дадаць праглядальнікаў',
      one: 'Дадаць праглядальніка',
      zero: 'Дадаць праглядальніка',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Дадаць суаўтараў',
      one: 'Дадаць суаўтара',
      zero: 'Дадаць суаўтара',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      'Доўга ўтрымлівайце паштовы адрас, каб спраўдзіць скразное шыфраванне.';

  @override
  String get developerSettingsWarning =>
      'Вы сапраўды хочаце змяніць налады распрацоўшчыка?';

  @override
  String get developerSettings => 'Налады распрацоўшчыка';

  @override
  String get serverEndpoint => 'Канцавы пункт сервера';

  @override
  String get invalidEndpoint => 'Памылковы канцавы пункт';

  @override
  String get invalidEndpointMessage =>
      'Прабачце, але ўведзены вамі канцавы пункт з\'яўляецца памылковым. Увядзіце сапраўдны канцавы пункт і паспрабуйце яшчэ раз.';

  @override
  String get endpointUpdatedMessage => 'Канцавы пункт паспяхова абноўлены';

  @override
  String customEndpoint({required Object endpoint}) {
    return 'Падключана да $endpoint';
  }

  @override
  String get createCollaborativeLink => 'Стварыць сумесную спасылку';

  @override
  String get search => 'Пошук';

  @override
  String get enterPersonName => 'Увядзіце імя асобы';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'Гэта электронная пошта ўжо звязана з $name.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return 'Паглядзець $name, каб скасаваць прывязку';
  }

  @override
  String get enterName => 'Увядзіце імя';

  @override
  String get savePerson => 'Захаваць асобу';

  @override
  String get editPerson => 'Рэдагаваць асобу';

  @override
  String get mergedPhotos => 'Аб\'яднаныя фатаграфіі';

  @override
  String get orMergeWithExistingPerson => 'Або аб\'яднаць з існуючымі';

  @override
  String get enterDateOfBirth => 'Дзень нараджэння (неабавязкова)';

  @override
  String get birthday => 'Дзень нараджэння';

  @override
  String get removePersonLabel => 'Выдаліць метку асобы';

  @override
  String get removePersonTag => 'Выдаліць тэг асобы';

  @override
  String get areYouSureRemoveThisPersonTag =>
      'Вы ўпэўненыя, што хочаце выдаліць гэты тэг чалавека?';

  @override
  String get autoPairDesc =>
      'Аўтаспалучэнне працуе толькі з прыладамі, якія падтрымліваюць Chromecast.';

  @override
  String get manualPairDesc =>
      'Спалучэнне з PIN працуе з любым экранам, на якім вы хочаце паглядзець альбом.';

  @override
  String get connectToDevice => 'Падключыцца да прылады';

  @override
  String get autoCastDialogBody =>
      'Паглядзець даступныя прылады Cast можна тут.';

  @override
  String get autoCastiOSPermission =>
      'Пераканайцеся, што для праграмы Ente Photos уключаны дазволы лакальнай сеткі ў наладах.';

  @override
  String get noDeviceFound => 'Ніводнай прылады не знойдзена';

  @override
  String get stopCastingTitle => 'Спыніць вяшчанне';

  @override
  String get stopCastingBody => 'Вы сапраўды хочаце спыніць вяшчанне?';

  @override
  String get castIPMismatchTitle => 'Не ўдалося вяшчаць альбом';

  @override
  String get castIPMismatchBody =>
      'Пераканайцеся, што вы знаходзіцеся ў адной сетцы з тэлевізарам.';

  @override
  String get pairingComplete => 'Спалучэнне завершана';

  @override
  String get savingEdits => 'Захаванне рэдагаванняў...';

  @override
  String get autoPair => 'Аўтаспалучэнне';

  @override
  String get pairWithPin => 'Спалучэнне з PIN';

  @override
  String get faceRecognition => 'Распазнаванне твару';

  @override
  String get foundFaces => 'Знойдзеныя твары';

  @override
  String get clusteringProgress => 'Выкананне кластэрызацыі';

  @override
  String get trim => 'Скараціць';

  @override
  String get crop => 'Абрэзаць';

  @override
  String get rotate => 'Павярнуць';

  @override
  String get left => 'Улева';

  @override
  String get right => 'Управа';

  @override
  String get whatsNew => 'Што новага';

  @override
  String get reviewSuggestions => 'Паглядзець прапановы';

  @override
  String get review => 'Ацаніць';

  @override
  String get useAsCover => 'Выкарыстоўваць як вокладку';

  @override
  String notPersonLabel({required String name}) {
    return 'Не $name?';
  }

  @override
  String get enable => 'Уключыць';

  @override
  String get enabled => 'Уключана';

  @override
  String get moreDetails => 'Падрабязней';

  @override
  String get enableMLIndexingDesc =>
      'Ente падтрымлівае машыннае навучанне для распазнавання твару, магічны пошук і іншыя пошукавыя функцыі';

  @override
  String get magicSearchHint =>
      'Магічны пошук дазваляе шукаць фатаграфіі па іх змесціву. Напрыклад, «кветка», «чырвоная машына» «дакументы»';

  @override
  String get panorama => 'Панарама';

  @override
  String get reenterPassword => 'Увядзіце пароль яшчэ раз';

  @override
  String get reenterPin => 'Увядзіце PIN-код яшчэ раз';

  @override
  String get deviceLock => 'Блакіроўка прылады';

  @override
  String get pinLock => 'Блакіроўка PIN\'ам';

  @override
  String get next => 'Далей';

  @override
  String get setNewPassword => 'Задаць новы пароль';

  @override
  String get enterPin => 'Увядзіце PIN';

  @override
  String get setNewPin => 'Задаць новы PIN';

  @override
  String get appLock => 'Блакіроўка праграмы';

  @override
  String get noSystemLockFound => 'Сістэмная блакіроўка не знойдзена';

  @override
  String get tapToUnlock => 'Націсніце, каб разблакіраваць';

  @override
  String get tooManyIncorrectAttempts => 'Занадта шмат няўдалых спроб';

  @override
  String get videoInfo => 'Інфармацыя аб відэа';

  @override
  String get autoLock => 'Аўтаблакіроўка';

  @override
  String get immediately => 'Неадкладна';

  @override
  String get autoLockFeatureDescription =>
      'Час, праз які праграма будзе заблакіравана пасля пераходу ў фонавы рэжым';

  @override
  String get hideContent => 'Схаваць змесціва';

  @override
  String get hideContentDescriptionAndroid =>
      'Схаваць змесціва праграмы ў пераключальніку праграм і адключыць здымкі экрана';

  @override
  String get hideContentDescriptionIos =>
      'Схаваць змесціва праграмы ў пераключальніку праграм';

  @override
  String get passwordStrengthInfo =>
      'Надзейнасць пароля вылічана з улікам яго даўжыні, выкарыстаных сімвалаў, а таксама прысутнасці сярод 10000 самых папулярных пароляў';

  @override
  String get noQuickLinksSelected => 'Хуткія спасылкі не выбраны';

  @override
  String get pleaseSelectQuickLinksToRemove =>
      'Выберыце хуткія спасылкі для выдалення';

  @override
  String get removePublicLinks => 'Выдаліць публічныя спасылкі';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      'Гэта дзеянне прывядзе да выдалення публічных спасылак усіх выбраных хуткіх спасылак.';

  @override
  String get guestView => 'Гасцявы прагляд';

  @override
  String get guestViewEnablePreSteps =>
      'Наладзьце код доступу або блакіроўку экрана ў сістэмных наладах вашай прылады, каб уключыць гасцявы ўваход.';

  @override
  String get nameTheAlbum => 'Назва альбома';

  @override
  String get collectPhotosDescription =>
      'Стварыце спасылку, па якой вашы сябры змогуць запампоўваць фатаграфіі ў арыгінальнай якасці.';

  @override
  String get collect => 'Сабраць';

  @override
  String get appLockDescriptions =>
      'Выберыце паміж прадвызначаным экранам блакіравання сваёй прылады і карыстальніцкім экранам блакіравання з PIN-кодам або паролем.';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'Наладзьце код доступу да прылады або блакіроўку экрана ў наладах вашай сістэме, каб уключыць блакіроўку праграмы.';

  @override
  String get authToViewPasskey =>
      'Прайдзіце аўтэнтыфікацыю, каб паглядзець свой код доступу';

  @override
  String get loopVideoOn => 'Адключыць цыкл';

  @override
  String get loopVideoOff => 'Уключыць цыкл';

  @override
  String get localSyncErrorMessage =>
      'Здаецца, што нешта пайшло не так. Паколькі лакальная сінхранізацыя фатаграфій займае больш часу, чым чакалася. Звяжыцеся з нашай службай падтрымкі';

  @override
  String get showPerson => 'Паказаць асобу';

  @override
  String get sort => 'Сартаваць';

  @override
  String get mostRecent => 'Самыя апошнія';

  @override
  String get mostRelevant => 'Самыя актуальныя';

  @override
  String get loadingYourPhotos => 'Загрузка вашых фатаграфій...';

  @override
  String processingImport({required Object folderName}) {
    return 'Апрацоўка $folderName...';
  }

  @override
  String get personName => 'Імя асобы';

  @override
  String get addPerson => 'Add person';

  @override
  String get addToPerson => 'Add to person';

  @override
  String get pleaseNamePersonInPeopleSectionFirst =>
      'Please name a person in the People section first';

  @override
  String get onlyUploadedFilesCanBeAddedToPerson =>
      'Only uploaded files can be added to a person';

  @override
  String get noFacesDetectedTapToAdd => 'No faces detected, tap to add.';

  @override
  String addedFilesToPerson({required int count, required String personName}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count files to $personName',
      one: 'Added 1 file to $personName',
    );
    return '$_temp0';
  }

  @override
  String filesAlreadyLinkedToPerson({
    required int count,
    required String personName,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count files are already linked to $personName',
      one: '1 file is already linked to $personName',
    );
    return '$_temp0';
  }

  @override
  String get addNewPerson => 'Дадаць новую асобу';

  @override
  String get addNameOrMerge => 'Дадаць імя або аб\'яднаць';

  @override
  String get mergeWithExisting => 'Аб\'яднаць з існуючым';

  @override
  String get newPerson => 'Новая асоба';

  @override
  String get addName => 'Дадаць імя';

  @override
  String get add => 'Дадаць';

  @override
  String extraPhotosFoundFor({required String text}) {
    return 'Дадатковыя фатаграфіі знойдзены для $text';
  }

  @override
  String get extraPhotosFound => 'Знойдзены дадатковыя фатаграфіі';

  @override
  String get configuration => 'Канфігурацыя';

  @override
  String get localIndexing => 'Лакальная індэксацыя';

  @override
  String get processed => 'Апрацавана';

  @override
  String get resetPerson => 'Выдаліць';

  @override
  String get areYouSureYouWantToResetThisPerson =>
      'Вы сапраўды хочаце скінуць даныя гэтай асобы?';

  @override
  String get allPersonGroupingWillReset =>
      'Усе групы для гэтай асобы будуць скінуты, а вы згубіце ўсе прапановы, якія зроблены для яе';

  @override
  String get yesResetPerson => 'Так, скінуць асобу';

  @override
  String get onlyThem => 'Толькі яны';

  @override
  String get checkingModels => 'Праверка мадэляў...';

  @override
  String get enableMachineLearningBanner =>
      'Уключыць машыннае навучанне для магічнага пошуку і распазнавання твару';

  @override
  String get searchDiscoverEmptySection =>
      'Відарысы будуць паказаны тут пасля завяршэння апрацоўкі і сінхранізацыі';

  @override
  String get searchPersonsEmptySection =>
      'Людзі будуць паказаны тут пасля завяршэння апрацоўкі і сінхранізацыі';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Дададзены $count праглядальнікаў',
      many: 'Дададзены $count праглядальнікаў',
      few: 'Дададзены $count праглядальнікі',
      one: 'Дададзены 1 праглядальнік',
      zero: 'Дададзены 0 праглядальнікаў',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Дададзены $count суаўтараў',
      many: 'Дададзены $count суаўтараў',
      few: 'Дададзены $count суаўтары',
      one: 'Дададзены 1 суаўтар',
      zero: 'Дададзены 0 суаўтараў',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured =>
      'Уліковы запіс ужо сканфігурыраваны.';

  @override
  String get sessionIdMismatch => 'Неадпаведнасць ідэнтыфікатара сеанса';

  @override
  String get failedToFetchActiveSessions => 'Не ўдалося атрымаць актыўны сеанс';

  @override
  String get failedToRefreshStripeSubscription =>
      'Не ўдалося абнавіць падпіску';

  @override
  String get failedToPlayVideo => 'Не ўдалося ўзнавіць відэа';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return 'Запампоўванне праігнаравана з прычыны $ignoreReason';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'Тып галерэі $galleryType не падтрымлівае перайменаванне';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'Націсніце запампаваць. Запампоўванне ігнаруецца з прычыны $ignoreReason';
  }

  @override
  String get tapToUpload => 'Націсніце запампаваць';

  @override
  String get info => 'Інфармацыя';

  @override
  String get addFiles => 'Дадаць файлы';

  @override
  String get castAlbum => 'Вяшчаць альбом';

  @override
  String get imageNotAnalyzed => 'Відарыс не прааналізаваны';

  @override
  String get noFacesFound => 'Твар не знойдзены';

  @override
  String get fileNotUploadedYet => 'Файл пакуль не запампаваны';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return 'Адсутнічаюць прапановы для $personName';
  }

  @override
  String get month => 'месяц';

  @override
  String get yearShort => 'год';

  @override
  String get currentlyRunning => 'цяпер выконваецца';

  @override
  String get ignored => 'ігнаруецца';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count фатаграфій',
      many: '$count фатаграфій',
      few: '$count фатаграфіі',
      one: '1 фатаграфія',
      zero: '0 фатаграфій',
    );
    return '$_temp0';
  }

  @override
  String get file => 'Файл';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'Неадпаведнасць даўжыні раздзелаў: $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'Выберыце паштовую праграму';

  @override
  String get selectAllShort => 'Усе';

  @override
  String get selectCoverPhoto => 'Выберыце фатаграфію вокладкі';

  @override
  String get newLocation => 'Новае месцазнаходжанне';

  @override
  String get faceNotClusteredYet =>
      'Твар пакуль не кластэрызаваны. Паспрабуйце яшчэ раз пазней';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'Тэрмін дзеяння спасылкі, да якой вы спрабавалі атрымаць доступ, пратэрмінаваны.';

  @override
  String get openFile => 'Адкрыць файл';

  @override
  String get backupFile => 'Файл рэзервовай копіі';

  @override
  String get openAlbumInBrowser => 'Адкрыць альбом у браўзеры';

  @override
  String get openAlbumInBrowserTitle =>
      'Скарыстайцеся вэб-праграмай, каб дадаць фатаграфіі ў гэты альбом';

  @override
  String get allow => 'Дазволіць';

  @override
  String get allowAppToOpenSharedAlbumLinks =>
      'Дазволіць праграме адкрываць спасылкі на агульныя альбомы';

  @override
  String get seePublicAlbumLinksInApp =>
      'Праглядаць публічныя спасылкі на альбомы ў праграме';

  @override
  String get emergencyContacts => 'Экстранныя кантакты';

  @override
  String get acceptTrustInvite => 'Прыняць запрашэнне';

  @override
  String get declineTrustInvite => 'Адхіліць запрашэнне';

  @override
  String get removeYourselfAsTrustedContact =>
      'Выдаліць сябе з давераных кантактаў';

  @override
  String get legacy => 'Спадчына';

  @override
  String get legacyPageDesc =>
      'Функцыя «Спадчына» дазваляе давераным кантактам атрымаць доступ да вашага ўліковага запісу пры вашай адсутнасці.';

  @override
  String get legacyPageDesc2 =>
      'Давераныя кантакты могуць ініцыяваць аднаўленне ўліковага запісу, і калі яно не будзе заблакіравана цягам 30 дзён, то яны змогуць скінуць пароль і атрымаць доступ да яго.';

  @override
  String get legacyAccounts => 'Уліковыя запісы «Спадчына»';

  @override
  String get trustedContacts => 'Давераныя кантакты';

  @override
  String get addTrustedContact => 'Дадаць давераны кантакт';

  @override
  String get removeInvite => 'Выдаліць запрашэнне';

  @override
  String get recoveryWarning =>
      'Давераны кантакт спрабуе атрымаць доступ да вашага ўліковага запісу';

  @override
  String get rejectRecovery => 'Адхіліць аднаўленне';

  @override
  String get recoveryInitiated => 'Ініцыявана аднаўленне';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return 'Вы зможаце атрымаць доступ да ўліковага запісу праз $days дні/дзён. Апавяшчэнне будзе адпраўлена на $email.';
  }

  @override
  String get cancelAccountRecovery => 'Скасаваць аднаўленне';

  @override
  String get recoveryAccount => 'Аднавіць уліковы запіс';

  @override
  String get cancelAccountRecoveryBody =>
      'Вы сапраўды хочаце скасаваць аднаўленне?';

  @override
  String get startAccountRecoveryTitle => 'Пачаць аднаўленне';

  @override
  String get whyAddTrustContact =>
      'Давераныя кантакты могуць дапамагчы з аднаўленнем вашых даных.';

  @override
  String recoveryReady({required String email}) {
    return 'Цяпер вы можаце аднавіць уліковы запіс $email, задаўшы новы пароль.';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email спрабуе аднавіць ваш уліковы запіс.';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return 'Вы атрымалі запрашэнне стаць давераным кантактам $email.';
  }

  @override
  String get warning => 'Папярэджанне';

  @override
  String get proceed => 'Працягнуць';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return 'Вы збіраеце дадаць $email у якасці даверанага кантакту. У гэтага карыстальніка будзе магчымасць аднавіць ваш уліковы запіс, калі вы будзеце адсутнічаць $numOfDays дні/дзён.';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email запрасіў вас стаць давераным кантактам';
  }

  @override
  String get authToManageLegacy =>
      'Прайдзіце аўтэнтыфікацыю, каб кіраваць сваімі даверанымі кантактамі';

  @override
  String get hideSharedItemsFromHomeGallery =>
      'Схаваць абагуленыя элементы з асноўнай галерэі';

  @override
  String get swipeToSelect => 'Правядзіце пальцам, каб выбраць';

  @override
  String get gallery => 'Галерэя';

  @override
  String get joinAlbum => 'Далучыцца да альбома';

  @override
  String get joinAlbumSubtext => 'каб праглядаць і дадаваць свае фатаграфіі';

  @override
  String get joinAlbumSubtextViewer => 'каб дадаць яе ў абагуленыя альбомы';

  @override
  String get join => 'Далучыцца';

  @override
  String get linkEmail => 'Прывязаць электронную пошту';

  @override
  String get link => 'Прывязаць';

  @override
  String get noEnteAccountExclamation => 'Адсутнічае ўліковы запіс Ente!';

  @override
  String get orPickFromYourContacts => 'або выберыце са сваіх кантактаў';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return 'У $email адсутнічае ўліковы запіс Ente.';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (Я)';
  }

  @override
  String get reassignMe => 'Пераназначыць «Мяне»';

  @override
  String get me => 'Я';

  @override
  String get linkEmailToContactBannerCaption =>
      'для больш хуткага абагульвання';

  @override
  String get selectPersonToLink => 'Выберыце асобу для прывязкі';

  @override
  String linkPersonToEmail({required String email}) {
    return 'Прывязаць асобу да $email';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return 'Гэта дзеянне прывяжа $personName да $email';
  }

  @override
  String get selectYourFace => 'Выберыце свой твар';

  @override
  String get reassigningLoading => 'Пераназначэнне...';

  @override
  String reassignedToName({required String name}) {
    return 'Вы пераназначаны на $name';
  }

  @override
  String get saveChangesBeforeLeavingQuestion =>
      'Захаваць змяненні перад выхадам?';

  @override
  String get dontSave => 'Не захоўваць';

  @override
  String get thisIsMeExclamation => 'Гэта я!';

  @override
  String get linkPerson => 'Прывязаць асобу';

  @override
  String get linkPersonCaption => 'для больш зручнага абагульвання';

  @override
  String get videoStreaming => 'Перадача відэа плынню';

  @override
  String get processingVideos => 'Апрацоўка відэа';

  @override
  String get streamDetails => 'Падрабязнасці плыні';

  @override
  String get processing => 'Апрацоўка';

  @override
  String get queued => 'У чарзе';

  @override
  String get ineligible => 'Непрыдатны';

  @override
  String get failed => 'Збой';

  @override
  String get playStream => 'Узнавіць плынь';

  @override
  String get playOriginal => 'Узнавіць арыгінал';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'Іншыя ўдзельнікі змогуць убачыць вашу электронную пошту, калі вы далучыцеся да альбома.';

  @override
  String get pleaseWaitThisWillTakeAWhile =>
      'Гэта зойме пэўны час. Пачакайце...';

  @override
  String get editTime => 'Рэдагаваць час';

  @override
  String get selectTime => 'Выбраць час';

  @override
  String get selectDate => 'Выбраць дату';

  @override
  String get previous => 'Папярэдні';

  @override
  String get selectOneDateAndTimeForAll => 'Выберыце адну дату і час для ўсіх';

  @override
  String get selectStartOfRange => 'Выберыце пачатак дыяпазону';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      'Гэта зробіць дату і час усіх выбраных фатаграфій аднолькавымі.';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'Гэта першае ў групе. Іншыя выбраныя фатаграфіі будуць аўтаматычна зрушаныя ў залежнасці ад гэтай новай даты';

  @override
  String get newRange => 'Новы дыяпазон';

  @override
  String get selectOneDateAndTime => 'Выберыце адну дату і час';

  @override
  String get moveSelectedPhotosToOneDate =>
      'Перамясціць выбраныя фатаграфіі ў адну дату';

  @override
  String get shiftDatesAndTime => 'Перанос даты і часу';

  @override
  String get photosKeepRelativeTimeDifference =>
      'Фатаграфіі захоўваюць адносную розніцу ў часе';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count фатаграфій',
      many: '$count фатаграфій',
      few: '$count фатаграфіі',
      one: '1 фатаграфія',
      zero: 'Няма фатаграфій',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'Значок праграмы';

  @override
  String get notThisPerson => 'Не гэта асоба?';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      'Выбраныя элементы будуць выдалены ў гэтай асобы, але не выдалены з вашай бібліятэкі.';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat праз гады';
  }

  @override
  String get thisWeekThroughTheYears => 'Гэты тыдзень праз гады';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'На гэтым тыдні $count гадоў таму',
      many: 'На гэтым тыдні $count гадоў таму',
      few: 'На гэтым тыдні $count гады таму',
      one: 'На гэтым тыдні $count год таму',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'Вы і $name';
  }

  @override
  String admiringThem({required Object name}) {
    return 'Любуючыся $name';
  }

  @override
  String embracingThem({required Object name}) {
    return 'Абдымаючы $name';
  }

  @override
  String partyWithThem({required Object name}) {
    return 'Вечарына з $name';
  }

  @override
  String hikingWithThem({required Object name}) {
    return 'Паход з $name';
  }

  @override
  String feastingWithThem({required Object name}) {
    return 'Застолле з $name';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return 'Сэлфі з $name';
  }

  @override
  String posingWithThem({required Object name}) {
    return 'Пазіруючы з $name';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return 'Прыгожыя краявіды з $name';
  }

  @override
  String sportsWithThem({required Object name}) {
    return 'Спорт з $name';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return 'Падарожжа з $name';
  }

  @override
  String get spotlightOnYourself => 'Вы ў цэнтры ўвагі';

  @override
  String spotlightOnThem({required Object name}) {
    return 'У цэнтры ўвагі $name';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$name споўнілася $age!';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name неўзабаве споўніцца $age';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return 'У апошні раз з $name';
  }

  @override
  String tripToLocation({required Object location}) {
    return 'Падарожжа ў $location';
  }

  @override
  String tripInYear({required Object year}) {
    return 'Падарожжа ў $year';
  }

  @override
  String get lastYearsTrip => 'Леташняе падарожжа';

  @override
  String get sunrise => 'На гарызонце';

  @override
  String get mountains => 'Праз узвышшы';

  @override
  String get greenery => 'Зялёнае жыццё';

  @override
  String get beach => 'Пясок і мора';

  @override
  String get city => 'У горадзе';

  @override
  String get moon => 'Пад святлом месяца';

  @override
  String get onTheRoad => 'Зноў у дарозе';

  @override
  String get food => 'Кулінарнае задавальненне';

  @override
  String get pets => 'Пухнатыя спадарожнікі';

  @override
  String get curatedMemories => 'Абраныя ўспаміны';

  @override
  String get widgets => 'Віджэты';

  @override
  String get memories => 'Успаміны';

  @override
  String get peopleWidgetDesc =>
      'Выберыце людзей, якіх вы хочаце бачыць на галоўным экране.';

  @override
  String get albumsWidgetDesc =>
      'Выберыце альбомы, якія вы хочаце бачыць на галоўным экране.';

  @override
  String get memoriesWidgetDesc =>
      'Выберыце, якія ўспаміны вы хочаце бачыць на галоўным экране.';

  @override
  String get smartMemories => 'Інтэлектуальныя ўспаміны';

  @override
  String get pastYearsMemories => 'Успаміны мінулых гадоў';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return 'Таксама выдаліць фатаграфіі (разам з відэа), якія знаходзяцца ў гэтых $count альбомах, з <bold>усіх</bold> іншых альбомаў, часткай якіх яны з\'яўляюцца?';
  }

  @override
  String get addParticipants => 'Дадаць удзельнікаў';

  @override
  String selectedAlbums({required Object count}) {
    return 'Выбрана: $count';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'Дзеянне не падтрымліваецца ў альбоме «Абранае»';

  @override
  String get onThisDayMemories => 'Успаміны ў гэты дзень';

  @override
  String get onThisDay => 'У гэты дзень';

  @override
  String get lookBackOnYourMemories => 'Азіраючыся на вашы ўспаміны';

  @override
  String get newPhotosEmoji => ' новая 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'Прабачце, але давялося прыпыніць ваша рэзервовае капіяванне';

  @override
  String get clickToInstallOurBestVersionYet =>
      'Націсніце, каб усталяваць нашу лепшую версію';

  @override
  String get onThisDayNotificationExplanation =>
      'Атрымлівайце напаміны аб успамінах з гэтага дня ў мінулыя гады.';

  @override
  String get addMemoriesWidgetPrompt =>
      'Дадайце віджэт успамін на галоўны экран і вярніцеся сюды, каб наладзіць яго.';

  @override
  String get addAlbumWidgetPrompt =>
      'Дадайце віджэт альбома на галоўны экран і вярніцеся сюды, каб наладзіць яго.';

  @override
  String get addPeopleWidgetPrompt =>
      'Дадайце віджэт людзей на галоўны экран і вярніцеся сюды, каб наладзіць яго.';

  @override
  String get birthdayNotifications => 'Апавяшчэнні аб днях нараджэння';

  @override
  String get receiveRemindersOnBirthdays =>
      'Атрымлівайце напаміны, калі ў некага дзень нараджэння. Націск на апавяшчэнне перанясе вас да фатаграфій імянінніка.';

  @override
  String get happyBirthday => 'З днём нараджэння! 🥳';

  @override
  String get birthdays => 'Дні нараджэння';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return 'Віншуем з днём нараджэння, $name! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      'Вы сапраўды хочаце выдаліць твар з гэтай асобы?';

  @override
  String get otherDetectedFaces => 'Іншыя выяўленыя твары';

  @override
  String get areThey => 'Яны ';

  @override
  String get questionmark => '?';

  @override
  String get saveAsAnotherPerson => 'Захаваць як іншую асобу';

  @override
  String get showLessFaces => 'Паказаць менш твараў';

  @override
  String get showMoreFaces => 'Паказаць больш твараў';

  @override
  String get ignore => 'Ігнараваць';

  @override
  String get merge => 'Аб\'яднаць';

  @override
  String get reset => 'Скінуць';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      'Вы сапраўды хочаце ігнараваць гэту асобу?';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      'Вы сапраўды хочаце ігнараваць гэтых асоб?';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'Групы асоб больш не будуць паказвацца ў раздзеле людзей. Фатаграфіі застануцца некранутымі.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'Асобы больш не будуць паказвацца ў раздзеле людзей. Фатаграфіі застануцца некранутымі.';

  @override
  String get areYouSureYouWantToMergeThem =>
      'Вы сапраўды хочаце іх аб\'яднаць?';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'Усе групы, у якіх адсутнічае назва, будуць аб\'яднаны з выбранай асобай. Гэта можна адрабіць у аглядзе гісторыі прапаноў для гэтай асобы.';

  @override
  String get yesIgnore => 'Так, ігнараваць';

  @override
  String get same => 'Пакінуць папярэдні';

  @override
  String get different => 'Розныя';

  @override
  String get sameperson => 'Тая ж асоба?';

  @override
  String get indexingPausedStatusDescription =>
      'Індэксаванне прыпынена. Яно аўтаматычна будзе ўзноўлена, калі прылада будзе гатова. Прылада лічыцца гатовай, калі ўзровень зараду акумулятара, стан акумулятара і цеплавы статус знаходзяцца ў межах нармальнага дыяпазону.';

  @override
  String get thisWeek => 'На гэтым тыдні';

  @override
  String get lastWeek => 'На мінулым тыдні';

  @override
  String get thisMonth => 'У гэтым месяцы';

  @override
  String get thisYear => 'У гэтым тыдні';

  @override
  String get groupBy => 'Групаваць па';

  @override
  String get faceThumbnailGenerationFailed =>
      'Немагчыма згенерыраваць мініяцюру твару';

  @override
  String get fileAnalysisFailed => 'Немагчыма прааналізаваць файл';

  @override
  String get editAutoAddPeople => 'Рэдагаваць аўтаматычнае дадаванне людзей';

  @override
  String get autoAddPeople => 'Аўтададаванне людзей';

  @override
  String get autoAddToAlbum => 'Аўтададаванне альбома';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      'Ці варта выдаляць файлы, звязаны з чалавекам, які раней быў выбраны ў інтэлектуальных альбомах?';

  @override
  String get addingPhotos => 'Дадаванне фатаграфій';

  @override
  String get gettingReady => 'Ідзе падрыхтоўка';

  @override
  String get addSomePhotosDesc1 => 'Дадайце некалькі фатаграфій або выберыце ';

  @override
  String get addSomePhotosDesc2 => 'знаёмыя твары';

  @override
  String get addSomePhotosDesc3 => '\nпачаць з';

  @override
  String get ignorePerson => 'Ігнараваць асобу';

  @override
  String get mixedGrouping => 'Змешаная група?';

  @override
  String get analysis => 'Аналіз';

  @override
  String get doesGroupContainMultiplePeople =>
      'Ці змяшчае гэта група некалькі людзей?';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'Сістэма аўтаматычна прааналізуе групу для вызначэння, ці ёсць у ёй некалькі людзей, і зноў раздзеліць іх. Гэта можа заняць некалькі секунд.';

  @override
  String get layout => 'Макет';

  @override
  String get day => 'Дзень';

  @override
  String get undo => 'Адрабіць';

  @override
  String get redo => 'Узнавіць';

  @override
  String get filter => 'Фільтр';

  @override
  String get adjust => 'Рэгуляваць';

  @override
  String get draw => 'Намаляваць';

  @override
  String get sticker => 'Стыкер';

  @override
  String get brushColor => 'Колер пэндзля';

  @override
  String get font => 'Шрыфт';

  @override
  String get background => 'Фон';

  @override
  String get align => 'Выраўноўванне';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Паспяхова дададзена ў $count альбомаў',
      few: 'Паспяхова дададзена ў $count альбомы',
      one: 'Паспяхова дададзена ў 1 альбом',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => 'Відэа было апрацавана';

  @override
  String get totalVideos => 'Усяго відэа';

  @override
  String get skippedVideos => 'Прапушчаныя відэа';

  @override
  String get videoStreamingDescriptionLine1 =>
      'Імгненнае ўзнаўленне відэа на любой прыладзе.';

  @override
  String get videoStreamingDescriptionLine2 =>
      'Уключыць апрацоўку відэаплыняў на гэтай прыладзе.';

  @override
  String get videoStreamingNote =>
      'Гэта прылада можа апрацоўваць відэа, якія зняты не пазней за 60 дзён таму і працягласцю не больш за 1 хвіліну. Для больш старых або больш доўгіх відэа ўключыце перадачу плынню ў праграме для камп\'ютара.';

  @override
  String get createStream => 'Уключыць перадачу плынню';

  @override
  String get recreateStream => 'Стварыць трансляцыю паўторна';

  @override
  String get addedToStreamCreationQueue => 'Дададзена ў чаргу стварэння плыні';

  @override
  String get addedToStreamRecreationQueue =>
      'Дададзена ў чаргу паўторнай рэгенерацыі плыні';

  @override
  String get videoPreviewAlreadyExists => 'Прадпрагляд відэа ўжо існуе';

  @override
  String get videoAlreadyInQueue => 'Файл відэа ўжо знаходзіцца ў чарзе';

  @override
  String get videoExportFailed =>
      'Не атрымалася стварыць відэа. Паўтарыце спробу.';

  @override
  String videoExportSuccess({required String path}) {
    return 'Відэа паспяхова створана на $path';
  }

  @override
  String get addedToQueue => 'Дададзена ў чаргу';

  @override
  String get creatingStream => 'Стварэнне плыні';

  @override
  String get similarImages => 'Падобныя відарысы';

  @override
  String get findSimilarImages => 'Знайсці падобныя відарысы';

  @override
  String get noSimilarImagesFound => 'Падобныя відарысы не знойдзены';

  @override
  String get yourPhotosLookUnique => 'Вашы фатаграфіі выглядаюць унікальнымі';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Знойдзена $count груп',
      few: 'Знойдзена $count групы',
      one: 'Знойдзена $count група',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages =>
      'Прагляд і выдаленне падобных відарысаў';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return 'Выдаліць фатаграфій: $count ($size)';
  }

  @override
  String get selectionOptions => 'Параметры выбару';

  @override
  String selectExactWithCount({required int count}) {
    return 'Такія ж самыя ($count)';
  }

  @override
  String get selectExact => 'Выбраць дакладныя';

  @override
  String selectSimilarWithCount({required int count}) {
    return 'Часткова падобныя ($count)';
  }

  @override
  String get selectSimilar => 'Выбраць падобныя';

  @override
  String selectAllWithCount({required int count}) {
    return 'Усе падабенствы ($count)';
  }

  @override
  String get selectSimilarImagesTitle => 'Выбраць падобныя відарысы';

  @override
  String get chooseSimilarImagesToSelect =>
      'Выберыце відарысы на аснове іх візуальнага падабенства';

  @override
  String get clearSelection => 'Ачысціць выбраныя';

  @override
  String similarImagesCount({required int count}) {
    return 'Падобных відарысаў ($count)';
  }

  @override
  String deleteWithCount({required int count}) {
    return 'Выдаліць ($count)';
  }

  @override
  String get deleteFiles => 'Выдаліць файлы';

  @override
  String get areYouSureDeleteFiles =>
      'Вы сапраўды хочаце выдаліць гэтыя файлы?';

  @override
  String get greatJob => 'Выдатная праца!';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return 'Вы вызвалілі $size прасторы';
  }

  @override
  String get size => 'Памер';

  @override
  String get similarity => 'Падабенства';

  @override
  String get analyzingPhotosLocally => 'Аналіз вашых фатаграфій лакальна...';

  @override
  String get lookingForVisualSimilarities =>
      'Пошук па візуальным падабенстве...';

  @override
  String get comparingImageDetails => 'Параўнанне падрабязнасцяў відарыса...';

  @override
  String get findingSimilarImages => 'Знайсці падобныя відарысы...';

  @override
  String get almostDone => 'Амаль гатова...';

  @override
  String get processingLocally => 'Апрацоўка лакальна';

  @override
  String get useMLToFindSimilarImages =>
      'Паглядзіце і выдаліце відарысы, якія выглядаюць падобна.';

  @override
  String get all => 'Усе';

  @override
  String get similar => 'Падобныя';

  @override
  String get identical => 'Ідэнтычныя';

  @override
  String get nothingHereTryAnotherFilter =>
      'Тут нічога няма. Паспрабуйце іншы фільтр!👀';

  @override
  String get related => 'Звязаныя';

  @override
  String get hoorayyyy => 'Ураааа!';

  @override
  String get nothingToTidyUpHere => 'Адсутнічаюць элементы для ўпарадкавання';

  @override
  String get deletingDash => 'Выдаленне - ';

  @override
  String get cLTitle1 => 'Перайсці да даты';

  @override
  String get cLDesc1 =>
      'На панэлі інфармацыі аб файле выберыце параметр «Перайсці да даты», каб паглядзець усе фатаграфіі побач з датай файла.';

  @override
  String get cLTitle2 => 'Больш хуткі рэдактар відэа';

  @override
  String get cLDesc2 =>
      'Рэдактар відэа быў падноўлены, што надзвычайна палепшыла яго хуткасць пры рэдагаванні вялікіх відэа, а таксама абнавіла UX.';

  @override
  String get cLTitle3 => 'Новыя ўспаміны';

  @override
  String get cLDesc3 =>
      '«Гуллівыя дзеці», «Зімовыя прыгоды», «Неонавыя ночы» і многае іншае.';

  @override
  String get cLTitle4 => 'Галерэя пейзажаў і іншае';

  @override
  String get cLDesc4 =>
      'Падтрымка альбомнай арыентацыі ў галоўнай галерэі праграмы. Паказваць людзей без звязаных з імі фатаграфій замест іх фільтрацыі. Палепшана выяўленне аспекту відэа пры абмене са знешнімі праграмамі.';

  @override
  String get closeBy => 'Закрыць';

  @override
  String get peopleAutoAddDesc =>
      'Аўтададаваць фатаграфіі выбраных людзей у гэты альбом';

  @override
  String get festivities => 'Святочны настрой';

  @override
  String get snowAdventures => 'Зімовыя прыгоды';

  @override
  String get waterfalls => 'Пагоня за вадаспадамі';

  @override
  String get wildlife => 'У дзікай прыродзе';

  @override
  String get flowers => 'Квітнеючая прыгажосць';

  @override
  String get nightLights => 'Неонавая ноч';

  @override
  String get architecture => 'Дызайн значкоў';

  @override
  String get autumnColors => 'Восеньскае хараство';

  @override
  String get desertDreams => 'Мара пустыні';

  @override
  String get stargazing => 'Пад зоркамі';

  @override
  String get lakeside => 'Цішыня ў возера';

  @override
  String get rainyDays => 'Адчуванне дажджлівага дня';

  @override
  String get sportsAction => 'Гульня';

  @override
  String get streetArt => 'Гісторыі вулічнага мастацтва';

  @override
  String get familyMoments => 'Час сям\'і';

  @override
  String get fireworks => 'Фінал з феерверкам';

  @override
  String get historicSites => 'Адгалоскі гісторыі';

  @override
  String get tropicalParadise => 'Трапічныя ўцёкі';

  @override
  String get forestTrails => 'Прагулка па лесе';

  @override
  String get citySunsets => 'Заход сонца ў горадзе';

  @override
  String get colorfulMarkets => 'Яркі рынак';

  @override
  String get cozyCafes => 'Утульны куток у кавярні';

  @override
  String get vintageVibes => 'Вінтажны сталь';

  @override
  String get aerialViews => 'Паветраная перспектыва';

  @override
  String get artisticPortraits => 'Майстэрскі партрэт';

  @override
  String get streetFood => 'Вулічна ежа';

  @override
  String get riverCruises => 'Від на раку';

  @override
  String get facesTimelineBannerTitle => 'Алея ўспамінаў';

  @override
  String facesTimelineBannerSubtitle({required String name}) {
    return 'Глядзіце фатаграфіі карыстальніка $name за розныя гады';
  }

  @override
  String get facesTimelineAppBarTitle => 'Алея ўспамінаў';

  @override
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count год',
      one: '$count год',
    );
    return '$name быў $_temp0';
  }

  @override
  String facesTimelineCaptionYearsAgo({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '# гадоў таму',
      one: '# гадоў таму',
    );
    return '$_temp0';
  }

  @override
  String get facesTimelineShareComingSoon => 'Абмен відэа хутка будзе';

  @override
  String get facesTimelinePlaybackPrevious => 'Папярэдняе';

  @override
  String get facesTimelinePlaybackNext => 'Наступнае';

  @override
  String get facesTimelinePlaybackPlay => 'Прайграць';

  @override
  String get facesTimelinePlaybackPause => 'Прыпыніць';

  @override
  String get facesTimelineUnavailable => 'Храналогія твараў рыхтуецца...';

  @override
  String get playfulKids => 'Гарэзлівыя дзеці';

  @override
  String get coastalCliffs => 'Скалы ля мора';

  @override
  String get ritualsTitle => 'Рытуалы';

  @override
  String get ritualAddTooltip => 'Дадаць рытуал';

  @override
  String get ritualActivityHeading => 'Актыўнасць';

  @override
  String get ritualDefaultHeatmapTitle => 'Рабіце фатаграфіі кожны дзень';

  @override
  String get ritualUntitled => 'Рытуал без назвы';

  @override
  String get ritualShareUnavailable =>
      'Немагчыма абагуліць зараз. Калі ласка, паспрабуйце яшчэ раз.';

  @override
  String get ritualNotificationMessage => 'Сфатаграфуйце зараз';

  @override
  String get ritualCameraNotFound => 'На гэтай прыладзе камера не знойдзена.';

  @override
  String get ritualCameraStartError =>
      'Немагчыма ўключыць камеру. Праверце дазволы.';

  @override
  String get ritualCaptureError =>
      'Не атрымалася зрабіць фатаграфію. Паўтарыце спробу.';

  @override
  String ritualPhotoLimit({required int maxPhotos}) {
    String _temp0 = intl.Intl.pluralLogic(
      maxPhotos,
      locale: localeName,
      other: '# photos.',
      one: '# photo.',
    );
    return 'Вы можаце дадаць да $_temp0';
  }

  @override
  String get ritualCaptureAtLeastOne =>
      'Спачатку зрабіце хаця б адну фатаграфію.';

  @override
  String get ritualAlbumMissing =>
      'Адсутнічае альбом рытуалаў. Адрэдагуйце рытуал, каб усталяваць альбом.';

  @override
  String get ritualAddedToAlbum => 'Дададзена ў альбом';

  @override
  String ritualAddedToAlbumWithName({required String albumName}) {
    return 'Дададзена ў $albumName';
  }

  @override
  String ritualAddToAlbumFailure({required String error}) {
    return 'Не атрымалася дадаць фатаграфію ў альбом: $error';
  }

  @override
  String get ritualBackToList => 'Вернуцца да рытуалаў';

  @override
  String get ritualNoPhotosYet => 'Фатаграфій пакуль няма';

  @override
  String get ritualSetAlbumToLaunchCamera =>
      'Усталюйце альбом для гэтага рытуалу, каб запусціць камеру.';

  @override
  String get ritualDefaultCameraTitle => 'Зрабіць фота';

  @override
  String get ritualBadgeMessage7 =>
      '7 дзён прайшло! Паслядоўнасць табе пасуе. Працягвай!';

  @override
  String get ritualBadgeMessage14 =>
      '14 дзён прайшло! Ваш рытуал становіцца звычкай. Неверагодна!';

  @override
  String get ritualBadgeMessage30 =>
      '30 дзён запар! Легендарная паслядоўнасць. Пакланіцеся!';

  @override
  String get ritualBadgeMessageDefault => 'У цябе ўсё атрымліваецца!';

  @override
  String get ritualBadgeNewTitle => 'Новае дасягненне';

  @override
  String get ritualBadgePreparing => 'Падрыхтоўка...';

  @override
  String get ritualStreaksLabel => 'Палоскі';

  @override
  String get ritualCreateYourOwn => 'Стварыце свой уласны рытуал';

  @override
  String get ritualGetDailyReminders => 'Get daily reminders';

  @override
  String get ritualAlbumNotSet => 'Album not set';

  @override
  String get ritualOpenCameraTooltip => 'Open ritual camera';

  @override
  String get ritualEditorLabel => 'Ritual editor';

  @override
  String get ritualNew => 'Create new ritual';

  @override
  String get ritualCreateNewTitle => 'Create new ritual';

  @override
  String get ritualEdit => 'Edit ritual';

  @override
  String get ritualEnterPrompt => 'Enter your ritual';

  @override
  String get ritualEnterDescription => 'Please enter a description';

  @override
  String get ritualChooseDaysLabel => 'Choose days for ritual';

  @override
  String get ritualDayLabel => 'Day';

  @override
  String get ritualNotificationsOffHint =>
      'Notifications are off. Tap a day to turn them on.';

  @override
  String get ritualTimeLabel => 'Time';

  @override
  String get ritualAlbumLabel => 'Album';

  @override
  String get ritualSave => 'Save ritual';

  @override
  String get ritualCreateAction => 'Create ritual';

  @override
  String get ritualUpdate => 'Update ritual';

  @override
  String get ritualSelectAlbumTitle => 'Select album';

  @override
  String get ritualChooseAlbumLabel => 'Choose an album';

  @override
  String get ritualSendReminderLabel => 'Send reminder';

  @override
  String get ritualSearchOrCreate => 'Search or create new';

  @override
  String get ritualNoAlbumsYet => 'No albums yet';

  @override
  String get ritualNoMatchingAlbums => 'No matching albums';

  @override
  String ritualCreateAlbumWithName({required String albumName}) {
    return 'Create \"$albumName\"';
  }

  @override
  String get ritualCreateNew => 'Create new';

  @override
  String get ritualAlbumSelectionPlaceholder => 'Select album';

  @override
  String get ritualPickEmojiTitle => 'Pick an emoji';

  @override
  String get ritualCustomKeyboardLabel => 'Custom (keyboard)';

  @override
  String get ritualEmojiKeyboardHint => 'Press to open emoji keyboard';

  @override
  String get ritualEmojiUseAction => 'Use';

  @override
  String get ritualSearchEmpty =>
      'Build a ritual to keep your photo habit going.';
}
