// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Arabic (`ar`).
class AppLocalizationsAr extends AppLocalizations {
  AppLocalizationsAr([String locale = 'ar']) : super(locale);

  @override
  String get enterYourEmailAddress => 'أدخل عنوان بريدك الإلكتروني';

  @override
  String get enterYourNewEmailAddress => 'أدخل عنوان بريدك الإلكتروني الجديد';

  @override
  String get accountWelcomeBack => 'أهلاً بعودتك!';

  @override
  String get emailAlreadyRegistered => 'البريد الإلكتروني مُسجل من قبل.';

  @override
  String get emailNotRegistered => 'البريد الإلكتروني غير مسجل.';

  @override
  String get email => 'البريد الإلكتروني';

  @override
  String get cancel => 'إلغاء';

  @override
  String get verify => 'التحقق';

  @override
  String get invalidEmailAddress => 'عنوان البريد الإلكتروني غير صالح';

  @override
  String get enterValidEmail => 'يرجى إدخال عنوان بريد إلكتروني صالح.';

  @override
  String get deleteAccount => 'حذف الحساب';

  @override
  String get deleteAccountWarning =>
      'This will delete your Ente Auth, Ente Photos and Ente Locker account.';

  @override
  String get askDeleteReason => 'ما السبب الرئيس لحذف حسابك؟';

  @override
  String get deleteAccountFeedbackPrompt =>
      'نأسف لمغادرتك. نرجو مشاركة ملاحظاتك لمساعدتنا على التحسين.';

  @override
  String get feedback => 'ملاحظات';

  @override
  String get kindlyHelpUsWithThisInformation => 'يرجى مساعدتنا بهذه المعلومات';

  @override
  String get confirmDeletePrompt =>
      'نعم، أرغب في حذف هذا الحساب وبياناته نهائيًا من جميع التطبيقات.';

  @override
  String get confirmAccountDeletion => 'تأكيد حذف الحساب';

  @override
  String get deleteAccountPermanentlyButton => 'حذف الحساب نهائيًا';

  @override
  String get yourAccountHasBeenDeleted => 'تم حذف حسابك بنجاح';

  @override
  String get selectReason => 'اختر سببًا';

  @override
  String get deleteReason1 => 'تفتقر إلى مِيزة أساسية أحتاج إليها';

  @override
  String get deleteReason2 => 'التطبيق أو مِيزة معينة لا تعمل كما هو متوقع';

  @override
  String get deleteReason3 => 'وجدت خدمة أخرى أفضل';

  @override
  String get deleteReason4 => 'سببي غير مدرج';

  @override
  String get sendEmail => 'إرسال بريد إلكتروني';

  @override
  String get deleteRequestSLAText => 'ستتم معالجة طلبك خلال 72 ساعة.';

  @override
  String get deleteEmailRequest =>
      'أرسل بريدًا إلكترونيًا إلى <warning>account-deletion@ente.io</warning> من عنوان بريدك الإلكتروني المسجل.';

  @override
  String get entePhotosPerm => 'Ente <i>بحاجة إلى إذن</i> لحفظ صورك';

  @override
  String get ok => 'حسنًا';

  @override
  String get createAccount => 'إنشاء حساب';

  @override
  String get createNewAccount => 'إنشاء حساب جديد';

  @override
  String get password => 'كلمة المرور';

  @override
  String get confirmPassword => 'تأكيد كلمة المرور';

  @override
  String get activeSessions => 'الجلسات النشطة';

  @override
  String get ocrProcessingOverlayMessage => 'Detecting text...';

  @override
  String get ocrLoadingIndicatorLabel => 'Detecting Text';

  @override
  String get ocrSelectionHint =>
      'Swipe or double tap to select just what you need';

  @override
  String get ocrNoTextDetected => 'No text detected';

  @override
  String get ocrRetryButtonLabel => 'Retry';

  @override
  String get ocrModelsNetworkRequiredError =>
      'Network connection required to download OCR models on first use';

  @override
  String get ocrModelsPrepareFailed => 'Could not prepare OCR models';

  @override
  String get ocrImageNotFoundError => 'Image file not found';

  @override
  String get ocrImageDecodeFailedError => 'Could not read image file';

  @override
  String get ocrGenericDetectError => 'Could not detect text in image';

  @override
  String get oops => 'عفوًا';

  @override
  String get somethingWentWrongPleaseTryAgain =>
      'حدث خطأ ما، يرجى المحاولة مرة أخرى';

  @override
  String get thisWillLogYouOutOfThisDevice =>
      'سيؤدي هذا إلى تسجيل خروجك من هذا الجهاز!';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice =>
      'سيؤدي هذا إلى تسجيل خروجك من الجهاز التالي:';

  @override
  String get terminateSession => 'إنهاء الجَلسةِ؟';

  @override
  String get terminate => 'إنهاء';

  @override
  String get thisDevice => 'هذا الجهاز';

  @override
  String get recoverButton => 'استرداد';

  @override
  String get recoverySuccessful => 'تم الاسترداد بنجاح!';

  @override
  String get decrypting => 'جارٍ فك التشفير...';

  @override
  String get incorrectRecoveryKeyTitle => 'مفتاح الاسترداد غير صحيح';

  @override
  String get incorrectRecoveryKeyBody => 'مفتاح الاسترداد الذي أدخلته غير صحيح';

  @override
  String get forgotPassword => 'نسيت كلمة المرور';

  @override
  String get enterYourRecoveryKey => 'أدخل مفتاح الاسترداد';

  @override
  String get noRecoveryKey => 'لا تملك مفتاح استرداد؟';

  @override
  String get sorry => 'عفوًا';

  @override
  String get noRecoveryKeyNoDecryption =>
      'نظرًا لطبيعة التشفير الكامل من طرف إلى طرف، لا يمكن فك تشفير بياناتك دون كلمة المرور أو مفتاح الاسترداد الخاص بك';

  @override
  String get verifyEmail => 'التحقق من البريد الإلكتروني';

  @override
  String get toResetVerifyEmail =>
      'لإعادة تعيين كلمة المرور، يرجى التحقق من بريدك الإلكتروني أولاً.';

  @override
  String get checkInboxAndSpamFolder =>
      'تحقق من صندوق الوارد ومجلد البريد غير الهام (Spam) لإكمال التحقق';

  @override
  String get tapToEnterCode => 'انقر لإدخال الرمز';

  @override
  String get resendEmail => 'إعادة إرسال البريد الإلكتروني';

  @override
  String weHaveSendEmailTo({required String email}) {
    return 'لقد أرسلنا بريدًا إلكترونيًا إلى <green>$email</green>';
  }

  @override
  String get setPasswordTitle => 'تعيين كلمة المرور';

  @override
  String get changePasswordTitle => 'تغيير كلمة المرور';

  @override
  String get resetPasswordTitle => 'إعادة تعيين كلمة المرور';

  @override
  String get encryptionKeys => 'مفاتيح التشفير';

  @override
  String get passwordWarning =>
      'نحن لا نقوم بتخزين كلمة المرور هذه، لذا إذا نسيتها، <underline>لا يمكننا فك تشفير بياناتك</underline>';

  @override
  String get enterPasswordToEncrypt =>
      'أدخل كلمة مرور يمكننا استخدامها لتشفير بياناتك';

  @override
  String get enterNewPasswordToEncrypt =>
      'أدخل كلمة مرور جديدة يمكننا استخدامها لتشفير بياناتك';

  @override
  String get weakStrength => 'ضعيفة';

  @override
  String get strongStrength => 'قوية';

  @override
  String get moderateStrength => 'متوسطة';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'قوة كلمة المرور: $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully => 'تم تغيير كلمة المرور بنجاح';

  @override
  String get generatingEncryptionKeys => 'جارٍ إنشاء مفاتيح التشفير...';

  @override
  String get pleaseWait => 'يرجى الانتظار...';

  @override
  String get continueLabel => 'متابعة';

  @override
  String get insecureDevice => 'جهاز غير آمن';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'عذرًا، لم نتمكن من إنشاء مفاتيح آمنة على هذا الجهاز.\n\nيرجى التسجيل من جهاز مختلف.';

  @override
  String get howItWorks => 'كيف يعمل';

  @override
  String get encryption => 'التشفير';

  @override
  String get ackPasswordLostWarning =>
      'أدرك أنني إذا فقدت كلمة المرور، فقد أفقد بياناتي لأنها <underline>مشفرة بالكامل من طرف إلى طرف</underline>.';

  @override
  String get privacyPolicyTitle => 'سياسة الخصوصية';

  @override
  String get termsOfServicesTitle => 'شروط الخدمة';

  @override
  String get signUpTerms =>
      'أوافق على <u-terms>شروط الخدمة</u-terms> و<u-policy>سياسة الخصوصية</u-policy>';

  @override
  String get logInLabel => 'تسجيل الدخول';

  @override
  String get loginTerms =>
      'بالنقر على تسجيل الدخول، أوافق على <u-terms>شروط الخدمة</u-terms> و <u-policy>سياسة الخصوصية</u-policy>';

  @override
  String get changeEmail => 'تغيير البريد الإلكتروني';

  @override
  String get enterYourPassword => 'أدخل كلمة المرور';

  @override
  String get welcomeBack => 'أهلاً بعودتك!';

  @override
  String get contactSupport => 'الاتصال بالدعم';

  @override
  String get locationPickerTip =>
      'You can also add a location centered on a photo from the photo\'s info screen';

  @override
  String get incorrectPasswordTitle => 'كلمة المرور غير صحيحة';

  @override
  String get pleaseTryAgain => 'يرجى المحاولة مرة أخرى';

  @override
  String get recreatePasswordTitle => 'إعادة إنشاء كلمة المرور';

  @override
  String get useRecoveryKey => 'استخدام مفتاح الاسترداد';

  @override
  String get recreatePasswordBody =>
      'لا يمكن التحقق من كلمة المرور على جهازك الحالي، لكن يمكننا تعديلها لتعمل على جميع الأجهزة.\n\nسجّل الدخول باستخدام مفتاح الاسترداد، ثم أنشئ كلمة مرور جديدة (يمكنك اختيار نفس الكلمة السابقة إذا أردت).';

  @override
  String get verifyPassword => 'التحقق من كلمة المرور';

  @override
  String get recoveryKey => 'مفتاح الاسترداد';

  @override
  String get recoveryKeyOnForgotPassword =>
      'إذا نسيت كلمة المرور الخاصة بك، فإن الطريقة الوحيدة لاستعادة بياناتك هي باستخدام هذا المفتاح.';

  @override
  String get recoveryKeySaveDescription =>
      'لا نحتفظ بنسخة من هذا المفتاح. يرجى حفظ المفتاح المكون من 24 كلمة في مكان آمن.';

  @override
  String get doThisLater => 'لاحقًا';

  @override
  String get saveKey => 'حفظ المفتاح';

  @override
  String get recoveryKeyCopiedToClipboard =>
      'تم نسخ مفتاح الاسترداد إلى الحافظة';

  @override
  String get recoverAccount => 'استعادة الحساب';

  @override
  String get recover => 'استعادة';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'يرجى إرسال بريد إلكتروني إلى $supportEmail من عنوان بريدك الإلكتروني المسجل';
  }

  @override
  String get twofactorSetup => 'إعداد المصادقة الثنائية';

  @override
  String get enterCode => 'أدخل الرمز';

  @override
  String get scanCode => 'مسح الرمز';

  @override
  String get codeCopiedToClipboard => 'تم نسخ الرمز إلى الحافظة';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      'انسخ هذا الرمز وألصقه\n في تطبيق المصادقة الخاص بك';

  @override
  String get tapToCopy => 'انقر للنسخ';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      'امسح هذا الباركود باستخدام\nتطبيق المصادقة الخاص بك';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      'أدخل الرمز المكون من 6 أرقام من\n تطبيق المصادقة الخاص بك';

  @override
  String get confirm => 'تأكيد';

  @override
  String get setupComplete => 'اكتمل الإعداد';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready =>
      'احفظ مفتاح الاسترداد إذا لم تكن قد فعلت ذلك';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      'يمكن استخدام هذا المفتاح لاستعادة حسابك إذا فقدت العامل الثاني للمصادقة';

  @override
  String get twofactorAuthenticationPageTitle => 'المصادقة الثنائية';

  @override
  String get lostDevice => 'جهاز مفقود؟';

  @override
  String get verifyingRecoveryKey => 'جارٍ التحقق من مفتاح الاسترداد...';

  @override
  String get recoveryKeyVerified => 'تم التحقق من مفتاح الاسترداد';

  @override
  String get recoveryKeySuccessBody =>
      'مفتاح الاسترداد الخاص بك صالح. شكرًا على التحقق.\n\nيرجى تذكر الاحتفاظ بنسخة احتياطية آمنة من مفتاح الاسترداد.';

  @override
  String get invalidRecoveryKey =>
      'مفتاح الاسترداد الذي أدخلته غير صالح. يرجى التأكد من أنه يحتوي على 24 كلمة، والتحقق من كتابة كل كلمة بشكل صحيح.\n\nإذا كنت تستخدم مفتاح استرداد قديمًا، تأكد من أنه مكون من 64 حرفًا، وتحقق من صحة كل حرف.';

  @override
  String get invalidKey => 'المفتاح غير صالح';

  @override
  String get tryAgain => 'المحاولة مرة أخرى';

  @override
  String get viewRecoveryKey => 'عرض مفتاح الاسترداد';

  @override
  String get confirmRecoveryKey => 'تأكيد مفتاح الاسترداد';

  @override
  String get recoveryKeyVerifyReason =>
      'مفتاح الاسترداد هو الطريقة الوحيدة لاستعادة صورك إذا نسيت كلمة المرور. يمكنك العثور عليه في الإعدادات > الحساب.\n\nالرجاء إدخال مفتاح الاسترداد هنا للتحقق من أنك حفظته بشكل صحيح.';

  @override
  String get confirmYourRecoveryKey => 'تأكيد مفتاح الاسترداد الخاص بك';

  @override
  String get addViewer => 'إضافة مشاهد';

  @override
  String get addCollaborator => 'إضافة متعاون';

  @override
  String get admin => 'Admin';

  @override
  String get admins => 'Admins';

  @override
  String get addAdmin => 'Add admin';

  @override
  String get addMoreAdmins => 'Add more admins';

  @override
  String get adminsAndCollaboratorsCanAddPhotosDescription =>
      'Admins and collaborators can add photos. Admins can also manage photos & participants.';

  @override
  String get addANewEmail => 'إضافة بريد إلكتروني جديد';

  @override
  String get orPickAnExistingOne => 'أو اختر واحدًا موجودًا';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'يمكن للمتعاونين إضافة الصور ومقاطع الفيديو إلى الألبوم المشترك.';

  @override
  String get enterEmail => 'أدخل البريد الإلكتروني';

  @override
  String get albumOwner => 'المالك';

  @override
  String get you => 'أنت';

  @override
  String get collaborator => 'متعاون';

  @override
  String get addMore => 'إضافة المزيد';

  @override
  String get viewer => 'مشاهد';

  @override
  String get remove => 'إزالة';

  @override
  String get removeParticipant => 'إزالة المشارك';

  @override
  String get manage => 'إدارة';

  @override
  String get addedAs => 'تمت الإضافة كـ';

  @override
  String get changePermissions => 'تغيير الإذن؟';

  @override
  String get yesConvertToViewer => 'نعم، التحويل إلى مشاهد';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return 'لن يتمكن $user من إضافة المزيد من الصور إلى هذا الألبوم\n\nسيظل بإمكانه إزالة الصور الحالية التي أضافها';
  }

  @override
  String get allowAddingPhotos => 'السماح بإضافة الصور';

  @override
  String get allowJoiningAlbum => 'Allow joining album';

  @override
  String get allowAddPhotosDescription =>
      'السماح للأشخاص الذين لديهم الرابط بإضافة صور إلى الألبوم المشترك أيضًا.';

  @override
  String get passwordLock => 'قفل بكلمة مرور';

  @override
  String get canNotOpenTitle => 'لا يمكن فتح هذا الألبوم';

  @override
  String get canNotOpenBody => 'عذرًا، لا يمكن فتح هذا الألبوم في التطبيق.';

  @override
  String get disableDownloadWarningTitle => 'يرجى الملاحظة';

  @override
  String get disableDownloadWarningBody =>
      'لا يزال بإمكان المشاهدين التقاط لقطات شاشة أو حفظ نسخة من صورك باستخدام أدوات خارجية';

  @override
  String get allowDownloads => 'السماح بالتنزيلات';

  @override
  String get linkDeviceLimit => 'حد الأجهزة';

  @override
  String get noDeviceLimit => 'لا شيء';

  @override
  String get albumLayout => 'Album layout';

  @override
  String get layoutGrouped => 'Grouped';

  @override
  String get layoutContinuous => 'Continuous';

  @override
  String get layoutTrip => 'Trip';

  @override
  String get preview => 'Preview';

  @override
  String get linkExpiry => 'انتهاء صلاحية الرابط';

  @override
  String get linkExpired => 'منتهي الصلاحية';

  @override
  String get linkEnabled => 'مفعّل';

  @override
  String get linkNeverExpires => 'أبدًا';

  @override
  String get expiredLinkInfo =>
      'انتهت صلاحية هذا الرابط. يرجى اختيار وقت انتهاء صلاحية جديد أو تعطيل انتهاء صلاحية الرابط.';

  @override
  String get setAPassword => 'تعيين كلمة مرور';

  @override
  String get lockButtonLabel => 'قفل';

  @override
  String get enterPassword => 'أدخل كلمة المرور';

  @override
  String get removeLink => 'إزالة الرابط';

  @override
  String get manageLink => 'إدارة الرابط';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'ستنتهي صلاحية الرابط في $expiryTime';
  }

  @override
  String get albumUpdated => 'تم تحديث الألبوم';

  @override
  String get never => 'أبدًا';

  @override
  String get custom => 'مخصص';

  @override
  String get after1Hour => 'بعد ساعة';

  @override
  String get after1Day => 'بعد يوم';

  @override
  String get after1Week => 'بعد أسبوع';

  @override
  String get after1Month => 'بعد شهر';

  @override
  String get after1Year => 'بعد سنة';

  @override
  String get manageParticipants => 'إدارة المشاركين';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count مُشاركين',
      one: 'مُشارك واحد',
      zero: 'لا يوجد مُشاركون',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'أنشئ رابطًا يسمح للأشخاص بإضافة الصور ومشاهدتها في ألبومك المشترك دون الحاجة إلى تطبيق أو حساب Ente. خيار مثالي لجمع صور الفعاليات بسهولة.';

  @override
  String get collectPhotos => 'جمع الصور';

  @override
  String get collaborativeLink => 'رابط تعاوني';

  @override
  String get shareWithNonenteUsers => 'المشاركة مع غير مستخدمي Ente';

  @override
  String get createPublicLink => 'إنشاء رابط عام';

  @override
  String get sendLink => 'إرسال الرابط';

  @override
  String get qrCode => 'QR Code';

  @override
  String get sendQrCode => 'Send QR code';

  @override
  String get copyLink => 'نسخ الرابط';

  @override
  String get copyEmbedHtml => 'Copy embed HTML';

  @override
  String get linkHasExpired => 'انتهت صلاحية الرابط';

  @override
  String get publicLinkEnabled => 'تمكين الرابط العام';

  @override
  String get shareALink => 'مشاركة رابط';

  @override
  String get sharedAlbumSectionDescription =>
      'أنشئ ألبومات مشتركة وتعاونية مع مستخدمي Ente الآخرين، بما في ذلك المستخدمين ذوي الاشتراكات المجانية.';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: 'مُشارَك مع $numberOfPeople أشخاص',
      one: 'مُشارَك مع شخص واحد',
      zero: 'مشاركة مع أشخاص مُحددين',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId => 'هذا هو معرّف التحقق الخاص بك';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'يجب أن يرى أي شخص يشارك ألبومات معك نفس معرّف التحقق على جهازه.';

  @override
  String get howToViewShareeVerificationID =>
      'يرجى الطلب منهم الضغط مطولًا على عنوان بريدهم الإلكتروني في شاشة الإعدادات، والتأكد من تطابق المعرّفات على كلا الجهازين.';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'هذا هو معرّف التحقق الخاص بـ $email';
  }

  @override
  String get verificationId => 'معرّف التحقق';

  @override
  String verifyEmailID({required Object email}) {
    return 'التحقق من $email';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return '$email لا يملك حسابًا على Ente.\n\nأرسل له دعوة لمشاركة الصور.';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return 'إليك معرّف التحقق الخاص بي لـ ente.io: $verificationID';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'مرحبًا، هل يمكنك تأكيد أن هذا هو معرّف التحقق الخاص بك على ente.io: $verificationID';
  }

  @override
  String get somethingWentWrong => 'حدث خطأ ما';

  @override
  String get sendInvite => 'إرسال دعوة';

  @override
  String get shareTextRecommendUsingEnte =>
      'قم بتنزيل تطبيق Ente حتى نتمكن من مشاركة الصور ومقاطع الفيديو بالجودة الأصلية بسهولة.\n\nhttps://ente.io';

  @override
  String get done => 'تم';

  @override
  String get applyCodeTitle => 'تطبيق الرمز';

  @override
  String get enterCodeDescription =>
      'أدخل الرمز المقدم من صديقك للمطالبة بمساحة تخزين مجانية لكما';

  @override
  String get apply => 'تطبيق';

  @override
  String get failedToApplyCode => 'فشل تطبيق الرمز';

  @override
  String get enterReferralCode => 'أدخل رمز الإحالة';

  @override
  String get codeAppliedPageTitle => 'تم تطبيق الرمز';

  @override
  String get changeYourReferralCode => 'تغيير رمز الإحالة الخاص بك';

  @override
  String get change => 'تغيير';

  @override
  String get unavailableReferralCode => 'عذرًا، هذا الرمز غير متوفر.';

  @override
  String get codeChangeLimitReached =>
      'عذرًا، لقد تجاوزت الحد المسموح به لتعديلات الرمز.';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'يرجى الاتصال بـ $familyAdminEmail لتغيير الرمز الخاص بك.';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB جيجابايت';
  }

  @override
  String get claimed => 'تم الحصول عليها';

  @override
  String get details => 'التفاصيل';

  @override
  String get claimMore => 'المطالبة بالمزيد!';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return 'سيحصلون أيضًا على $storageAmountInGB جيجابايت';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '$storageAmountInGB جيجابايت مجانية في كل مرة يشترك فيها شخص بخطة مدفوعة ويطبق رمزك';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'رمز إحالة Ente الخاص بي: $referralCode\n\nطبقه في الإعدادات ← عام ← الإحالات للحصول على $referralStorageInGB جيجابايت مجانًا بعد الاشتراك في خطة مدفوعة.\n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => 'المطالبة بمساحة تخزين مجانية';

  @override
  String get inviteYourFriends => 'ادعُ أصدقاءك';

  @override
  String get failedToFetchReferralDetails =>
      'تعذر جلب تفاصيل الإحالة. يرجى المحاولة مرة أخرى لاحقًا.';

  @override
  String get referralStep1 => '1. أعطِ هذا الرمز لأصدقائك';

  @override
  String get referralStep2 => '2. يشتركون في خطة مدفوعة';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. تحصلون كلاكما على $storageInGB جيجابايت* مجانًا';
  }

  @override
  String get referralsAreCurrentlyPaused => 'الإحالات متوقفة مؤقتًا';

  @override
  String get youCanAtMaxDoubleYourStorage =>
      '* يمكنك مضاعفة مساحة التخزين الخاصة بك بحد أقصى';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true': 'عائلتك حصلت على $storageAmountInGb جيجابايت حتى الآن',
      'false': 'لقد حصلت على $storageAmountInGb جيجابايت حتى الآن',
      'other': 'لقد حصلت على $storageAmountInGb جيجابايت حتى الآن!',
    });
    return '$_temp0';
  }

  @override
  String get faq => 'الأسئلة الشائعة';

  @override
  String get help => 'المساعدة';

  @override
  String get oopsSomethingWentWrong => 'عفوًا، حدث خطأ ما';

  @override
  String get peopleUsingYourCode => 'الأشخاص الذين يستخدمون رمزك';

  @override
  String get eligible => 'مؤهل';

  @override
  String get total => 'المجموع';

  @override
  String get codeUsedByYou => 'الرمز المستخدم من قبلك';

  @override
  String get freeStorageClaimed => 'تم المطالبة بمساحة التخزين المجانية';

  @override
  String get freeStorageUsable => 'مساحة تخزين مجانية متاحة للاستخدام';

  @override
  String get usableReferralStorageInfo =>
      'مساحة التخزين القابلة للاستخدام مقيدة بخطتك الحالية.\nالمساحة التخزينية الزائدة التي تمت المطالبة بها ستصبح قابلة للاستخدام تلقائيًا عند ترقية خطتك.';

  @override
  String get removeFromAlbumTitle => 'إزالة من الألبوم؟';

  @override
  String get removeFromAlbum => 'إزالة من الألبوم';

  @override
  String get itemsWillBeRemovedFromAlbum =>
      'سيتم إزالة العناصر المحددة من هذا الألبوم.';

  @override
  String get removeShareItemsWarning =>
      'Selected photos will not be accessible to any viewer of this album, except the photo owners.';

  @override
  String get addingToFavorites => 'جارٍ الإضافة إلى المفضلة...';

  @override
  String get removingFromFavorites => 'جارٍ الإزالة من المفضلة...';

  @override
  String get sorryCouldNotAddToFavorites => 'عذرًا، تعذرت الإضافة إلى المفضلة!';

  @override
  String get sorryCouldNotRemoveFromFavorites =>
      'عذرًا، تعذرت الإزالة من المفضلة!';

  @override
  String get subscribeToEnableSharing =>
      'المشاركة متاحة فقط للاشتراكات المدفوعة النشطة.';

  @override
  String get subscribeToChangeLinkSetting =>
      'You need a paid subscription to change this link setting.';

  @override
  String get subscribe => 'اشتراك';

  @override
  String get canOnlyRemoveFilesOwnedByYou =>
      'يمكنك فقط إزالة الملفات التي تملكها.';

  @override
  String get deleteSharedAlbum => 'حذف الألبوم المشترك؟';

  @override
  String get deleteAlbum => 'حذف الألبوم';

  @override
  String get deleteAlbumDialog =>
      'هل ترغب أيضًا في حذف الصور (ومقاطع الفيديو) الموجودة في هذا الألبوم من <bold>جميع</bold> الألبومات الأخرى التي هي جزء منها؟';

  @override
  String get deleteSharedAlbumDialogBody =>
      'سيتم حذف الألبوم للجميع.\n\nستفقد الوصول إلى الصور المشتركة في هذا الألبوم التي يملكها الآخرون.';

  @override
  String get yesRemove => 'نعم، إزالة';

  @override
  String get creatingLink => 'جارٍ إنشاء الرابط...';

  @override
  String get removeWithQuestionMark => 'إزالة؟';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return 'سيتم إزالة $userEmail من هذا الألبوم المشترك.\n\nسيتم أيضًا إزالة أي صور أضافها إلى الألبوم.';
  }

  @override
  String get keepPhotos => 'الاحتفاظ بالصور';

  @override
  String get deletePhotos => 'حذف الصور';

  @override
  String get inviteToEnte => 'دعوة إلى Ente';

  @override
  String get removePublicLink => 'إزالة الرابط العام';

  @override
  String disableLinkMessage({required Object albumName}) {
    return 'سيؤدي هذا إلى إزالة الرابط العام للوصول إلى \"$albumName\".';
  }

  @override
  String get sharing => 'جارٍ المشاركة...';

  @override
  String get youCannotShareWithYourself => 'لا يمكنك المشاركة مع نفسك.';

  @override
  String get archive => 'الأرشيف';

  @override
  String get createAlbumActionHint =>
      'اضغط مطولاً لتحديد الصور ثم انقر على \'+\' لإنشاء ألبوم';

  @override
  String get importing => 'جارٍ الاستيراد...';

  @override
  String get failedToLoadAlbums => 'فشل تحميل الألبومات';

  @override
  String get hidden => 'المخفية';

  @override
  String get authToViewYourHiddenFiles =>
      'يرجى المصادقة للوصول إلى ملفاتك المخفية';

  @override
  String get authToViewTrashedFiles => 'يرجى المصادقة لعرض ملفاتك المحذوفة';

  @override
  String get trash => 'سلة المهملات';

  @override
  String get uncategorized => 'غير مصنف';

  @override
  String get videoSmallCase => 'فيديو';

  @override
  String get photoSmallCase => 'صورة';

  @override
  String get singleFileDeleteHighlight => 'سيتم حذفه من جميع الألبومات.';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return '$fileType موجود في Ente وعلى جهازك.';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return 'سيتم حذف $fileType من Ente.';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return 'سيتم حذف $fileType من جهازك.';
  }

  @override
  String get deleteFromEnte => 'حذف من Ente';

  @override
  String get yesDelete => 'نعم، حذف';

  @override
  String get movedToTrash => 'تم النقل إلى سلة المهملات';

  @override
  String get deleteFromDevice => 'الحذف من الجهاز';

  @override
  String get deleteFromBoth => 'الحذف من كليهما';

  @override
  String get newAlbum => 'ألبوم جديد';

  @override
  String get albums => 'الألبومات';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount ذكرى',
      many: '$formattedCount ذكرى',
      few: '$formattedCount ذكريات',
      two: 'ذكريتان',
      one: 'ذكرى واحدة',
      zero: 'لا توجد ذكريات',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return 'تم تحديد $count';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return 'تم تحديد $count ($yourCount منها لك)';
  }

  @override
  String get advancedSettings => 'الإعدادات المتقدمة';

  @override
  String get photoGridSize => 'حجم شبكة الصور';

  @override
  String get manageDeviceStorage => 'إدارة مساحة تخزين الجهاز';

  @override
  String get manageDeviceStorageDesc =>
      'مراجعة ومسح ذاكرة التخزين المؤقت المحلية.';

  @override
  String get machineLearning => 'تعلم الآلة';

  @override
  String get mlConsent => 'تمكين تعلم الآلة';

  @override
  String get mlConsentTitle => 'تمكين تعلم الآلة؟';

  @override
  String get mlConsentDescription =>
      'إذا قمت بتمكين تعلم الآلة، سيقوم Ente باستخراج معلومات مثل هندسة الوجه من الملفات، بما في ذلك تلك التي تمت مشاركتها معك.\n\nسيحدث هذا على جهازك، وسيتم تشفير أي معلومات بيومترية تم إنشاؤها تشفيرًا تامًا من طرف إلى طرف.';

  @override
  String get mlConsentPrivacy =>
      'يرجى النقر هنا لمزيد من التفاصيل حول هذه الميزة في سياسة الخصوصية الخاصة بنا';

  @override
  String get mlConsentConfirmation => 'أنا أفهم، وأرغب في تمكين تعلم الآلة';

  @override
  String get magicSearch => 'البحث السحري';

  @override
  String get discover => 'اكتشاف';

  @override
  String get discover_identity => 'الهوية';

  @override
  String get discover_screenshots => 'لقطات الشاشة';

  @override
  String get discover_receipts => 'الإيصالات';

  @override
  String get discover_notes => 'الملاحظات';

  @override
  String get discover_memes => 'الميمز';

  @override
  String get discover_visiting_cards => 'بطاقات الزيارة';

  @override
  String get discover_babies => 'الأطفال';

  @override
  String get discover_pets => 'الحيوانات الأليفة';

  @override
  String get discover_selfies => 'صور السيلفي';

  @override
  String get discover_wallpapers => 'الخلفيات';

  @override
  String get discover_food => 'الطعام';

  @override
  String get discover_celebrations => 'الاحتفالات';

  @override
  String get discover_sunset => 'غروب الشمس';

  @override
  String get discover_hills => 'التلال';

  @override
  String get discover_greenery => 'المساحات الخضراء';

  @override
  String get mlIndexingDescription =>
      'يرجى ملاحظة أن تعلم الآلة سيؤدي إلى استهلاك أعلى لعرض النطاق الترددي والبطارية حتى تتم فهرسة جميع العناصر.\nنوصي باستخدام تطبيق سطح المكتب لإجراء الفهرسة بشكل أسرع. سيتم مزامنة جميع النتائج تلقائيًا.';

  @override
  String get loadingModel => 'جارٍ تحميل النماذج...';

  @override
  String get waitingForWifi => 'في انتظار شبكة Wi-Fi...';

  @override
  String get status => 'الحالة';

  @override
  String get indexedItems => 'العناصر المفهرسة';

  @override
  String get pendingItems => 'العناصر المعلقة';

  @override
  String get clearIndexes => 'مسح الفهارس';

  @override
  String get selectFoldersForBackup => 'تحديد المجلدات للنسخ الاحتياطي';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      'سيتم تشفير المجلدات المحددة ونسخها احتياطيًا';

  @override
  String get unselectAll => 'إلغاء تحديد الكل';

  @override
  String get selectAll => 'تحديد الكل';

  @override
  String get skip => 'تخط';

  @override
  String get updatingFolderSelection => 'جارٍ تحديث تحديد المجلد...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count عَنَاصِر',
      one: '$count عُنْصُر',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'حذف $count عنصرًا',
      many: 'حذف $count عنصرًا',
      few: 'حذف $count عناصر',
      two: 'حذف عنصرين',
      one: 'حذف عنصر واحد',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count ملفات، $formattedSize لكل منها';
  }

  @override
  String get showMemories => 'عرض الذكريات';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'قبل $count سنة',
      many: 'قبل $count سنة',
      few: 'قبل $count سنوات',
      two: 'قبل سنتين',
      one: 'قبل سنة',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'إعدادات النسخ الاحتياطي';

  @override
  String get backupStatus => 'حالة النسخ الاحتياطي';

  @override
  String get backupStatusDescription =>
      'ستظهر العناصر التي تم نسخها احتياطيًا هنا';

  @override
  String get backupOverMobileData => 'النسخ الاحتياطي عبر بيانات الجوال';

  @override
  String get backupVideos => 'النسخ الاحتياطي لمقاطع الفيديو';

  @override
  String get disableAutoLock => 'تعطيل القفل التلقائي';

  @override
  String get deviceLockExplanation =>
      'عطّل قفل شاشة الجهاز عندما يكون Ente قيد التشغيل في المقدمة ويقوم بالنسخ الاحتياطي.\nهذا الإجراء غير مطلوب عادةً، لكنه قد يسرّع إكمال التحميلات الكبيرة أو الاستيرادات الأولية للمكتبات الضخمة.';

  @override
  String get about => 'حول التطبيق';

  @override
  String get weAreOpenSource => 'نحن مفتوحو المصدر!';

  @override
  String get privacy => 'الخصوصية';

  @override
  String get terms => 'الشروط';

  @override
  String get checkForUpdates => 'التحقق من وجود تحديثات';

  @override
  String get checkStatus => 'التحقق من الحالة';

  @override
  String get checking => 'جارٍ التحقق...';

  @override
  String get youAreOnTheLatestVersion => 'أنت تستخدم أحدث إصدار.';

  @override
  String get account => 'الحساب';

  @override
  String get manageSubscription => 'إدارة الاشتراك';

  @override
  String get authToChangeYourEmail => 'يرجى المصادقة لتغيير بريدك الإلكتروني';

  @override
  String get changePassword => 'تغيير كلمة المرور';

  @override
  String get authToChangeYourPassword =>
      'يرجى المصادقة لتغيير كلمة المرور الخاصة بك';

  @override
  String get emailVerificationToggle => 'تأكيد عنوان البريد الإلكتروني';

  @override
  String get authToChangeEmailVerificationSetting =>
      'يرجى المصادقة لتغيير إعداد التحقق من البريد الإلكتروني';

  @override
  String get exportYourData => 'تصدير بياناتك';

  @override
  String get logout => 'تسجيل الخروج';

  @override
  String get authToInitiateAccountDeletion =>
      'يرجى المصادقة لبدء عملية حذف الحساب';

  @override
  String get areYouSureYouWantToLogout =>
      'هل أنت متأكد من رغبتك في تسجيل الخروج؟';

  @override
  String get yesLogout => 'نعم، تسجيل الخروج';

  @override
  String get aNewVersionOfEnteIsAvailable => 'يتوفر إصدار جديد من Ente.';

  @override
  String get update => 'تحديث';

  @override
  String get installManually => 'التثبيت يدويًا';

  @override
  String get criticalUpdateAvailable => 'يتوفر تحديث حرج';

  @override
  String get updateAvailable => 'يتوفر تحديث';

  @override
  String get ignoreUpdate => 'تجاهل';

  @override
  String get downloading => 'جارٍ التنزيل...';

  @override
  String get cannotDeleteSharedFiles => 'لا يمكن حذف الملفات المشتركة';

  @override
  String get theDownloadCouldNotBeCompleted => 'تعذر إكمال التنزيل';

  @override
  String get retry => 'إعادة المحاولة';

  @override
  String get backedUpFolders => 'المجلدات المنسوخة احتياطيًا';

  @override
  String get backup => 'النسخ الاحتياطي';

  @override
  String get freeUpDeviceSpace => 'تحرير مساحة على الجهاز';

  @override
  String get freeUpDeviceSpaceDesc =>
      'وفر مساحة على جهازك عن طريق مسح الملفات التي تم نسخها احتياطيًا.';

  @override
  String get allClear => '✨ كل شيء واضح';

  @override
  String get noDeviceThatCanBeDeleted =>
      'لا توجد ملفات على هذا الجهاز يمكن حذفها';

  @override
  String get removeDuplicates => 'إزالة النسخ المكررة';

  @override
  String get removeDuplicatesDesc => 'مراجعة وإزالة الملفات المتطابقة تمامًا.';

  @override
  String get viewLargeFiles => 'الملفات الكبيرة';

  @override
  String get viewLargeFilesDesc =>
      'عرض الملفات التي تستهلك أكبر قدر من مساحة التخزين.';

  @override
  String get noDuplicates => '✨ لا توجد ملفات مكررة';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared =>
      'لا توجد لديك أي ملفات مكررة يمكن مسحها';

  @override
  String get success => 'تم بنجاح';

  @override
  String get rateUs => 'تقييم التطبيق';

  @override
  String get remindToEmptyDeviceTrash =>
      'تذكر أيضًا إفراغ \"المحذوفة مؤخرًا\" من \"الإعدادات\" -> \"التخزين\" لاستعادة المساحة المحررة';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return 'لقد حررت $storageSaved بنجاح!';
  }

  @override
  String get remindToEmptyEnteTrash =>
      'تذكر أيضًا إفراغ \"سلة المهملات\" لاستعادة المساحة المحررة.';

  @override
  String get sparkleSuccess => '✨ نجاح';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ملفًا مكررًا',
      many: '$count ملفًا مكررًا',
      few: '$count ملفات مكررة',
      two: 'ملفين مكررين',
      one: 'ملف مكرر واحد',
    );
    return 'لقد قمت بتنظيف $_temp0، مما وفر $storageSaved!';
  }

  @override
  String get familyPlans => 'الخطط العائلية';

  @override
  String get referrals => 'الإحالات';

  @override
  String get notifications => 'الإشعارات';

  @override
  String get sharedPhotoNotifications => 'إشعارات الصور المشتركة الجديدة';

  @override
  String get sharedPhotoNotificationsExplanation =>
      'تلقّ إشعارات عندما يضيف شخص ما صورة إلى ألبوم مشترك أنت جزء منه.';

  @override
  String get advanced => 'متقدم';

  @override
  String get general => 'عام';

  @override
  String get security => 'الأمان';

  @override
  String get authToViewYourRecoveryKey =>
      'يرجى المصادقة لعرض مفتاح الاسترداد الخاص بك.';

  @override
  String get twofactor => 'المصادقة الثنائية';

  @override
  String get authToConfigureTwofactorAuthentication =>
      'يرجى المصادقة لإعداد المصادقة الثنائية.';

  @override
  String get lockscreen => 'شاشة القفل';

  @override
  String get authToChangeLockscreenSetting =>
      'يرجى المصادقة لتغيير إعدادات شاشة القفل.';

  @override
  String get viewActiveSessions => 'عرض الجلسات النشطة';

  @override
  String get authToViewYourActiveSessions =>
      'يرجى المصادقة لعرض جلساتك النشطة.';

  @override
  String get disableTwofactor => 'تعطيل المصادقة الثنائية';

  @override
  String get confirm2FADisable =>
      'هل أنت متأكد من رغبتك في تعطيل المصادقة الثنائية؟';

  @override
  String get no => 'لا';

  @override
  String get yes => 'نعم';

  @override
  String get social => 'التواصل الاجتماعي';

  @override
  String rateUsOnStore({required Object storeName}) {
    return 'قيّمنا على $storeName';
  }

  @override
  String get blog => 'المدونة';

  @override
  String get merchandise => 'المنتجات الترويجية';

  @override
  String get twitter => 'X (Twitter سابقًا)';

  @override
  String get mastodon => 'Mastodon';

  @override
  String get matrix => 'Matrix';

  @override
  String get discord => 'Discord';

  @override
  String get reddit => 'Reddit';

  @override
  String get yourStorageDetailsCouldNotBeFetched =>
      'تعذر جلب تفاصيل التخزين الخاصة بك.';

  @override
  String get reportABug => 'الإبلاغ عن خطأ';

  @override
  String get reportBug => 'الإبلاغ عن خطأ';

  @override
  String get suggestFeatures => 'اقتراح ميزة';

  @override
  String get support => 'الدعم';

  @override
  String get theme => 'المظهر';

  @override
  String get lightTheme => 'فاتح';

  @override
  String get darkTheme => 'داكن';

  @override
  String get systemTheme => 'النظام';

  @override
  String get freeTrial => 'تجربة مجانية';

  @override
  String get selectYourPlan => 'اختر خطتك';

  @override
  String get enteSubscriptionPitch =>
      'يحفظ Ente ذكرياتك، بحيث تظل دائمًا متاحة لك حتى لو فقدت جهازك.';

  @override
  String get enteSubscriptionShareWithFamily =>
      'يمكنك أيضًا إضافة أفراد عائلتك إلى خطتك.';

  @override
  String get currentUsageIs => 'استخدامك الحالي هو ';

  @override
  String get faqs => 'الأسئلة الشائعة';

  @override
  String renewsOn({required Object endDate}) {
    return 'يتجدد الاشتراك في $endDate';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return 'التجربة المجانية صالحة حتى $endDate';
  }

  @override
  String validTill({required Object endDate}) {
    return 'صالح حتى $endDate';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return 'إضافتك بسعة $storageAmount صالحة حتى $endDate';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return 'التجربة المجانية صالحة حتى $endDate.\nيمكنك اختيار خطة مدفوعة بعد ذلك.';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'سيتم إلغاء اشتراكك في $endDate';
  }

  @override
  String get subscription => 'الاشتراك';

  @override
  String get paymentDetails => 'تفاصيل الدفع';

  @override
  String get manageFamily => 'إدارة العائلة';

  @override
  String contactToManageSubscription({required Object provider}) {
    return 'يرجى التواصل معنا على support@ente.io لإدارة اشتراكك في $provider.';
  }

  @override
  String get renewSubscription => 'تجديد الاشتراك';

  @override
  String get cancelSubscription => 'إلغاء الاشتراك';

  @override
  String get areYouSureYouWantToRenew => 'هل أنت متأكد من رغبتك في التجديد؟';

  @override
  String get yesRenew => 'نعم، تجديد';

  @override
  String get areYouSureYouWantToCancel => 'هل أنت متأكد من رغبتك في الإلغاء؟';

  @override
  String get yesCancel => 'نعم، إلغاء';

  @override
  String get failedToRenew => 'فشل التجديد';

  @override
  String get failedToCancel => 'فشل الإلغاء';

  @override
  String get twoMonthsFreeOnYearlyPlans => 'شهرين مجانيين على الخطط السنوية.';

  @override
  String get monthly => 'شهريًا';

  @override
  String get yearly => 'سنويًا';

  @override
  String get confirmPlanChange => 'تأكيد تغيير الخطة';

  @override
  String get areYouSureYouWantToChangeYourPlan =>
      'هل أنت متأكد من رغبتك في تغيير خطتك؟';

  @override
  String get youCannotDowngradeToThisPlan => 'لا يمكنك الترقية إلى هذه الخطة.';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'يرجى إلغاء اشتراكك الحالي من $paymentProvider أولاً.';
  }

  @override
  String get optionalAsShortAsYouLike => 'اختياري، قصير كما تشاء...';

  @override
  String get send => 'إرسال';

  @override
  String get askCancelReason => 'تم إلغاء اشتراكك. هل ترغب في مشاركة السبب؟';

  @override
  String get thankYouForSubscribing => 'شكرًا لاشتراكك!';

  @override
  String get yourPurchaseWasSuccessful => 'تم الشراء بنجاح.';

  @override
  String get yourPlanWasSuccessfullyUpgraded => 'تمت ترقية خطتك بنجاح.';

  @override
  String get yourPlanWasSuccessfullyDowngraded => 'تم تخفيض خطتك بنجاح.';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully =>
      'تم تحديث اشتراكك بنجاح.';

  @override
  String get googlePlayId => 'معرّف Google Play';

  @override
  String get appleId => 'معرّف Apple';

  @override
  String get playstoreSubscription => 'اشتراك متجر Play';

  @override
  String get appstoreSubscription => 'اشتراك متجر App Store';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return 'تم ربط $id الخاص بك بحساب Ente آخر.\nإذا كنت ترغب في استخدام $id مع هذا الحساب، يرجى الاتصال بدعمنا.';
  }

  @override
  String get visitWebToManage => 'يرجى زيارة web.ente.io لإدارة اشتراكك.';

  @override
  String get couldNotUpdateSubscription => 'تعذر تحديث الاشتراك.';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      'يرجى التواصل مع support@ente.io وسنكون سعداء بمساعدتك!';

  @override
  String get paymentFailed => 'فشلت عملية الدفع';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return 'يرجى التواصل مع دعم $providerName إذا تم خصم المبلغ منك.';
  }

  @override
  String get continueOnFreeTrial => 'الاستمرار في التجربة المجانية';

  @override
  String get areYouSureYouWantToExit => 'هل أنت متأكد من رغبتك في الخروج؟';

  @override
  String get thankYou => 'شكرًا لك';

  @override
  String get failedToVerifyPaymentStatus => 'فشل التحقق من حالة الدفع.';

  @override
  String get pleaseWaitForSometimeBeforeRetrying =>
      'يرجى الانتظار لبعض الوقت قبل إعادة المحاولة';

  @override
  String get paymentFailedMessage =>
      'للأسف، فشلت عملية الدفع الخاصة بك. يرجى الاتصال بالدعم وسوف نساعدك!';

  @override
  String get youAreOnAFamilyPlan => 'أنت مشترك في خطة عائلية!';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'يرجى الاتصال بـ <green>$familyAdminEmail</green> لإدارة اشتراكك.';
  }

  @override
  String get leaveFamily => 'مغادرة خطة العائلة';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily =>
      'هل أنت متأكد من رغبتك في مغادرة الخطة العائلية؟';

  @override
  String get leave => 'مغادرة';

  @override
  String get rateTheApp => 'تقييم التطبيق';

  @override
  String get startBackup => 'بدء النسخ الاحتياطي';

  @override
  String get noPhotosAreBeingBackedUpRightNow =>
      'لا يتم نسخ أي صور احتياطيًا في الوقت الحالي';

  @override
  String get preserveMore => 'حفظ المزيد';

  @override
  String get grantFullAccessPrompt =>
      'الرجاء السماح بالوصول إلى جميع الصور في تطبيق الإعدادات';

  @override
  String get allowPermTitle => 'السماح بالوصول إلى الصور';

  @override
  String get allowPermBody =>
      'يرجى السماح بالوصول إلى صورك من الإعدادات حتى يتمكن Ente من عرض نسختك الاحتياطية ومكتبتك.';

  @override
  String get openSettings => 'فتح الإعدادات';

  @override
  String get selectMorePhotos => 'تحديد المزيد من الصور';

  @override
  String get existingUser => 'مستخدم حالي';

  @override
  String get privateBackups => 'نسخ احتياطية خاصة';

  @override
  String get forYourMemories => 'لذكرياتك';

  @override
  String get endtoendEncryptedByDefault => 'تشفير من طرف إلى طرف بشكل افتراضي';

  @override
  String get safelyStored => 'مخزنة بأمان';

  @override
  String get atAFalloutShelter => 'في ملجأ للطوارئ';

  @override
  String get designedToOutlive => 'مصممة لتدوم';

  @override
  String get available => 'متوفر';

  @override
  String get everywhere => 'في كل مكان';

  @override
  String get androidIosWebDesktop => 'أندرويد، iOS، الويب، سطح المكتب';

  @override
  String get mobileWebDesktop => 'الهاتف المحمول، الويب، سطح المكتب';

  @override
  String get newToEnte => 'جديد في Ente';

  @override
  String get pleaseLoginAgain => 'يرجى تسجيل الدخول مرة أخرى';

  @override
  String get autoLogoutMessage =>
      'بسبب خلل تقني، تم تسجيل خروجك. نعتذر عن الإزعاج.';

  @override
  String get yourSubscriptionHasExpired => 'انتهت صلاحية اشتراكك';

  @override
  String get storageLimitExceeded => 'تم تجاوز حد التخزين';

  @override
  String get upgrade => 'ترقية';

  @override
  String get raiseTicket => 'فتح تذكرة دعم';

  @override
  String get backupFailed => 'فشل النسخ الاحتياطي';

  @override
  String get sorryBackupFailedDesc =>
      'عذرًا، لم نتمكن من عمل نسخة احتياطية لهذا الملف الآن، سنعيد المحاولة لاحقًا.';

  @override
  String get couldNotBackUpTryLater =>
      'لم نتمكن من نسخ بياناتك احتياطيًا.\nسنحاول مرة أخرى لاحقًا.';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      'يمكن لـ Ente تشفير وحفظ الملفات فقط إذا منحت الإذن بالوصول إليها';

  @override
  String get pleaseGrantPermissions => 'يرجى منح الأذونات';

  @override
  String get grantPermission => 'منح الإذن';

  @override
  String get privateSharing => 'مشاركة خاصة';

  @override
  String get shareOnlyWithThePeopleYouWant =>
      'شارك فقط مع الأشخاص الذين تريدهم.';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      'استخدم الروابط العامة للأشخاص غير المسجلين في Ente.';

  @override
  String get allowPeopleToAddPhotos => 'السماح للأشخاص بإضافة الصور';

  @override
  String get shareAnAlbumNow => 'شارك ألبومًا الآن';

  @override
  String get collectEventPhotos => 'جمع صور الفعالية';

  @override
  String get sessionExpired => 'انتهت صلاحية الجلسة';

  @override
  String get loggingOut => 'جارٍ تسجيل الخروج...';

  @override
  String get onDevice => 'على الجهاز';

  @override
  String get onEnte => 'على <branding>Ente</branding>';

  @override
  String get name => 'الاسم';

  @override
  String get newest => 'الأحدث';

  @override
  String get lastUpdated => 'آخر تحديث';

  @override
  String get deleteEmptyAlbums => 'حذف الألبومات الفارغة';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => 'حذف الألبومات الفارغة؟';

  @override
  String get deleteAlbumsDialogBody =>
      'سيؤدي هذا إلى حذف جميع الألبومات الفارغة. هذا مفيد عندما تريد تقليل الفوضى في قائمة ألبوماتك.';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return 'جارٍ الحذف $currentlyDeleting / $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return 'جارٍ المعالجة $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => 'حذف نهائي';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou =>
      'يمكن إنشاء رابط للملفات التي تملكها فقط.';

  @override
  String get publicLinkCreated => 'تم إنشاء الرابط العام.';

  @override
  String get youCanManageYourLinksInTheShareTab =>
      'يمكنك إدارة روابطك في علامة تبويب المشاركة.';

  @override
  String get linkCopiedToClipboard => 'تم نسخ الرابط إلى الحافظة.';

  @override
  String get restore => 'استعادة';

  @override
  String get moveToAlbum => 'نقل إلى ألبوم';

  @override
  String get unhide => 'إظهار';

  @override
  String get unarchive => 'إلغاء الأرشفة';

  @override
  String get favorite => 'المفضلة';

  @override
  String get removeFromFavorite => 'إزالة من المفضلة';

  @override
  String get shareLink => 'مشاركة الرابط';

  @override
  String get createCollage => 'إنشاء كولاج';

  @override
  String get saveCollage => 'حفظ الكولاج';

  @override
  String get collageSaved => 'تم حفظ الكولاج في المعرض.';

  @override
  String get collageLayout => 'التخطيط';

  @override
  String get addToEnte => 'إضافة إلى Ente';

  @override
  String get addToAlbum => 'إضافة إلى الألبوم';

  @override
  String get delete => 'حذف';

  @override
  String get hide => 'إخفاء';

  @override
  String get share => 'مشاركة';

  @override
  String get unhideToAlbum => 'إظهار في الألبوم';

  @override
  String get restoreToAlbum => 'استعادة إلى الألبوم';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'نقل $count عنصرًا',
      many: 'نقل $count عنصرًا',
      few: 'نقل $count عناصر',
      two: 'نقل عنصرين',
      one: 'نقل عنصر',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'إضافة $count عنصرًا',
      many: 'إضافة $count عنصرًا',
      few: 'إضافة $count عناصر',
      two: 'إضافة عنصرين',
      one: 'إضافة عنصر',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'إنشاء أو تحديد ألبوم';

  @override
  String get selectAlbum => 'تحديد ألبوم';

  @override
  String get searchByAlbumNameHint => 'اسم الألبوم';

  @override
  String get albumTitle => 'عنوان الألبوم';

  @override
  String get enterAlbumName => 'أدخل اسم الألبوم';

  @override
  String get restoringFiles => 'جارٍ استعادة الملفات...';

  @override
  String get movingFilesToAlbum => 'جارٍ نقل الملفات إلى الألبوم...';

  @override
  String get unhidingFilesToAlbum => 'جارٍ إظهار الملفات في الألبوم...';

  @override
  String get canNotUploadToAlbumsOwnedByOthers =>
      'لا يمكن التحميل إلى ألبومات يملكها آخرون.';

  @override
  String get uploadingFilesToAlbum => 'جارٍ تحميل الملفات إلى الألبوم...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return 'تمت الإضافة بنجاح إلى $albumName';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return 'تم النقل بنجاح إلى $albumName';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'هذا الألبوم لديه رابط تعاوني بالفعل.';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return 'تم إنشاء رابط تعاوني لـ $albumName';
  }

  @override
  String get askYourLovedOnesToShare => 'اطلب من أحبائك المشاركة';

  @override
  String get invite => 'دعوة';

  @override
  String get shareYourFirstAlbum => 'شارك ألبومك الأول';

  @override
  String sharedWith({required Object emailIDs}) {
    return 'تمت المشاركة مع $emailIDs';
  }

  @override
  String get sharedWithMe => 'تمت مشاركتها معي';

  @override
  String get sharedByMe => 'تمت مشاركتها بواسطتي';

  @override
  String get doubleYourStorage => 'ضاعف مساحة التخزين الخاصة بك';

  @override
  String get referFriendsAnd2xYourPlan => 'أحِل الأصدقاء وضاعف خطتك مرتين';

  @override
  String get shareAlbumHint =>
      'افتح ألبومًا وانقر على زر المشاركة في الزاوية اليمنى العليا للمشاركة.';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      'تعرض العناصر عدد الأيام المتبقية قبل الحذف الدائم.';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count يومًا',
      many: '$count يومًا',
      few: '$count أيام',
      two: 'يومان',
      one: 'يوم واحد',
      zero: 'قريبًا',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => 'حذف الكل';

  @override
  String get renameAlbum => 'إعادة تسمية الألبوم';

  @override
  String get convertToAlbum => 'تحويل إلى ألبوم';

  @override
  String get setCover => 'تعيين كغلاف';

  @override
  String get sortAlbumsBy => 'فرز حسب';

  @override
  String get sortNewestFirst => 'الأحدث أولاً';

  @override
  String get sortOldestFirst => 'الأقدم أولاً';

  @override
  String get rename => 'إعادة تسمية';

  @override
  String get leaveSharedAlbum => 'مغادرة الألبوم المشترك؟';

  @override
  String get leaveAlbum => 'مغادرة الألبوم';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'ستتم إزالة الصور التي أضفتها من الألبوم.';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted =>
      'لا توجد لديك ملفات في هذا الألبوم يمكن حذفها.';

  @override
  String get youDontHaveAnyArchivedItems => 'لا توجد لديك أي عناصر مؤرشفة.';

  @override
  String get ignoredFolderUploadReason =>
      'تم تجاهل تحميل بعض الملفات في هذا الألبوم لأنه تم حذفها مسبقًا من Ente.';

  @override
  String get resetIgnoredFiles => 'إعادة تعيين الملفات المتجاهلة';

  @override
  String get deviceFilesAutoUploading =>
      'سيتم تحميل الملفات المضافة إلى ألبوم الجهاز هذا تلقائيًا إلى Ente.';

  @override
  String get turnOnBackupForAutoUpload =>
      'قم بتشغيل النسخ الاحتياطي لتحميل الملفات المضافة إلى مجلد الجهاز هذا تلقائيًا إلى Ente.';

  @override
  String get noHiddenPhotosOrVideos => 'لا توجد صور أو مقاطع فيديو مخفية';

  @override
  String get toHideAPhotoOrVideo => 'لإخفاء صورة أو مقطع فيديو:';

  @override
  String get openTheItem => '• افتح العنصر';

  @override
  String get clickOnTheOverflowMenu => '• انقر على قائمة الخيارات الإضافية';

  @override
  String get click => '• انقر على';

  @override
  String get nothingToSeeHere => 'لا يوجد شيء هنا! 👀';

  @override
  String get unarchiveAlbum => 'إلغاء أرشفة الألبوم';

  @override
  String get archiveAlbum => 'أرشفة الألبوم';

  @override
  String get calculating => 'جارٍ الحساب...';

  @override
  String get pleaseWaitDeletingAlbum => 'يرجى الانتظار، جارٍ حذف الألبوم';

  @override
  String get searchByExamples =>
      '• أسماء الألبومات (مثل \"الكاميرا\")\n• أنواع الملفات (مثل \"مقاطع الفيديو\"، \".gif\")\n• السنوات والأشهر (مثل \"2022\"، \"يناير\")\n• العطلات (مثل \"عيد الميلاد\")\n• أوصاف الصور (مثل \"#مرح\")';

  @override
  String get youCanTrySearchingForADifferentQuery =>
      'يمكنك محاولة البحث عن استعلام مختلف.';

  @override
  String get noResultsFound => 'لم يتم العثور على نتائج.';

  @override
  String addedBy({required Object emailOrName}) {
    return 'تمت الإضافة بواسطة $emailOrName';
  }

  @override
  String get loadingExifData => 'جارٍ تحميل بيانات EXIF...';

  @override
  String get viewAllExifData => 'عرض جميع بيانات EXIF';

  @override
  String get noExifData => 'لا توجد بيانات EXIF';

  @override
  String get thisImageHasNoExifData => 'لا تحتوي هذه الصورة على بيانات EXIF.';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => 'لا توجد نتائج';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'لا ندعم تعديل الصور والألبومات التي لا تملكها بعد.';

  @override
  String get failedToFetchOriginalForEdit => 'فشل جلب النسخة الأصلية للتعديل.';

  @override
  String get close => 'إغلاق';

  @override
  String get setAs => 'تعيين كـ';

  @override
  String get fileSavedToGallery => 'تم حفظ الملف في المعرض.';

  @override
  String get filesSavedToGallery => 'تم حفظ الملفات في المعرض.';

  @override
  String get fileFailedToSaveToGallery => 'فشل حفظ الملف في المعرض.';

  @override
  String get download => 'تنزيل';

  @override
  String get pressAndHoldToPlayVideo => 'اضغط مطولاً لتشغيل الفيديو';

  @override
  String get pressAndHoldToPlayVideoDetailed =>
      'اضغط مطولاً على الصورة لتشغيل الفيديو';

  @override
  String get downloadFailed => 'فشل التنزيل';

  @override
  String get deduplicateFiles => 'إزالة الملفات المكررة';

  @override
  String get deselectAll => 'إلغاء تحديد الكل';

  @override
  String get reviewDeduplicateItems =>
      'يرجى مراجعة وحذف العناصر التي تعتقد أنها مكررة.';

  @override
  String get clubByCaptureTime => 'التجميع حسب وقت الالتقاط';

  @override
  String get clubByFileName => 'التجميع حسب اسم الملف';

  @override
  String get count => 'العدد';

  @override
  String get totalSize => 'الحجم الإجمالي';

  @override
  String get longpressOnAnItemToViewInFullscreen =>
      'اضغط مطولاً على عنصر لعرضه في وضع ملء الشاشة.';

  @override
  String get decryptingVideo => 'جارٍ فك تشفير الفيديو...';

  @override
  String get authToViewYourMemories => 'يرجى المصادقة لعرض ذكرياتك.';

  @override
  String get unlock => 'فتح';

  @override
  String get freeUpSpace => 'تحرير المساحة';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'يمكن حذفها من الجهاز لتحرير $formattedSize',
      many: 'يمكن حذفها من الجهاز لتحرير $formattedSize',
      few: 'يمكن حذفها من الجهاز لتحرير $formattedSize',
      two: 'يمكن حذفهما من الجهاز لتحرير $formattedSize',
      one: 'يمكن حذفه من الجهاز لتحرير $formattedSize',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber ملفًا',
      many: '$formattedNumber ملفًا',
      few: '$formattedNumber ملفات',
      two: 'ملفان',
      one: 'ملف واحد',
    );
    return '$_temp0 في هذا الألبوم تم نسخه احتياطيًا بأمان';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber ملفًا',
      many: '$formattedNumber ملفًا',
      few: '$formattedNumber ملفات',
      two: 'ملفان',
      one: 'ملف واحد',
    );
    return '$_temp0 على هذا الجهاز تم نسخه احتياطيًا بأمان';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'إليها',
      two: 'إليهما',
      one: 'إليه',
    );
    return 'لا يزال بإمكانك الوصول $_temp0 على Ente طالما لديك اشتراك نشط.';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return 'تحرير $sizeInMBorGB';
  }

  @override
  String get thisEmailIsAlreadyInUse => 'هذا البريد الإلكتروني مستخدم بالفعل.';

  @override
  String get incorrectCode => 'رمز غير صحيح';

  @override
  String get authenticationFailedPleaseTryAgain =>
      'فشلت المصادقة، يرجى المحاولة مرة أخرى.';

  @override
  String get verificationFailedPleaseTryAgain =>
      'فشل التحقق، يرجى المحاولة مرة أخرى.';

  @override
  String get authenticating => 'جارٍ المصادقة...';

  @override
  String get authenticationSuccessful => 'تمت المصادقة بنجاح!';

  @override
  String get incorrectRecoveryKey => 'مفتاح الاسترداد غير صحيح.';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect =>
      'مفتاح الاسترداد الذي أدخلته غير صحيح.';

  @override
  String get twofactorAuthenticationSuccessfullyReset =>
      'تمت إعادة تعيين المصادقة الثنائية بنجاح.';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered =>
      'يرجى التحقق من الرمز الذي أدخلته.';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      'يرجى الاتصال بالدعم إذا استمرت المشكلة.';

  @override
  String get twofactorAuthenticationHasBeenDisabled =>
      'تم تعطيل المصادقة الثنائية.';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect =>
      'عذرًا، الرمز الذي أدخلته غير صحيح.';

  @override
  String get yourVerificationCodeHasExpired =>
      'انتهت صلاحية رمز التحقق الخاص بك.';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'تم تغيير البريد الإلكتروني إلى $newEmail';
  }

  @override
  String get verifying => 'جارٍ التحقق...';

  @override
  String get disablingTwofactorAuthentication =>
      'جارٍ تعطيل المصادقة الثنائية...';

  @override
  String get allMemoriesPreserved => 'تم حفظ جميع الذكريات';

  @override
  String get loadingGallery => 'جارٍ تحميل المعرض...';

  @override
  String get syncing => 'جارٍ المزامنة...';

  @override
  String get encryptingBackup => 'جارٍ تشفير النسخة الاحتياطية...';

  @override
  String get syncStopped => 'توقفت المزامنة';

  @override
  String syncProgress({required String completed, required String total}) {
    return '$completed/$total ذكريات محفوظة';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return 'جارٍ حفظ $count ذكريات...';
  }

  @override
  String get uploadingSingleMemory => 'جارٍ حفظ ذكرى واحدة...';

  @override
  String get archiving => 'جارٍ الأرشفة...';

  @override
  String get unarchiving => 'جارٍ إلغاء الأرشفة...';

  @override
  String get successfullyArchived => 'تمت الأرشفة بنجاح.';

  @override
  String get successfullyUnarchived => 'تم إلغاء الأرشفة بنجاح.';

  @override
  String get renameFile => 'إعادة تسمية الملف';

  @override
  String get enterFileName => 'أدخل اسم الملف';

  @override
  String get filesDeleted => 'تم حذف الملفات.';

  @override
  String get selectedFilesAreNotOnEnte =>
      'الملفات المحددة ليست موجودة على Ente.';

  @override
  String get thisActionCannotBeUndone => 'لا يمكن التراجع عن هذا الإجراء.';

  @override
  String get emptyTrash => 'إفراغ سلة المهملات؟';

  @override
  String get permDeleteWarning =>
      'سيتم حذف جميع العناصر في سلة المهملات نهائيًا.\n\nلا يمكن التراجع عن هذا الإجراء.';

  @override
  String get empty => 'إفراغ';

  @override
  String get couldNotFreeUpSpace => 'تعذر تحرير المساحة.';

  @override
  String get permanentlyDeleteFromDevice => 'حذف نهائي من الجهاز؟';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      'بعض الملفات التي تحاول حذفها متوفرة فقط على جهازك ولا يمكن استردادها إذا تم حذفها.';

  @override
  String get theyWillBeDeletedFromAllAlbums => 'سيتم حذفها من جميع الألبومات.';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'بعض العناصر موجودة في Ente وعلى جهازك.';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      'سيتم حذف العناصر المحددة من جميع الألبومات ونقلها إلى سلة المهملات.';

  @override
  String get theseItemsWillBeDeletedFromYourDevice =>
      'سيتم حذف هذه العناصر من جهازك.';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      'يبدو أن خطأً ما قد حدث. يرجى المحاولة مرة أخرى بعد بعض الوقت. إذا استمر الخطأ، يرجى الاتصال بفريق الدعم لدينا.';

  @override
  String get error => 'خطأ';

  @override
  String get tempErrorContactSupportIfPersists =>
      'يبدو أن خطأً ما قد حدث. يرجى المحاولة مرة أخرى بعد بعض الوقت. إذا استمر الخطأ، يرجى الاتصال بفريق الدعم لدينا.';

  @override
  String get networkHostLookUpErr =>
      'تعذر الاتصال بـ Ente، يرجى التحقق من إعدادات الشبكة والاتصال بالدعم إذا استمر الخطأ.';

  @override
  String get networkConnectionRefusedErr =>
      'تعذر الاتصال بـ Ente، يرجى المحاولة مرة أخرى بعد بعض الوقت. إذا استمر الخطأ، يرجى الاتصال بالدعم.';

  @override
  String get cachedData => 'البيانات المؤقتة';

  @override
  String get clearCaches => 'مسح ذاكرة التخزين المؤقت';

  @override
  String get remoteImages => 'الصور عن بعد';

  @override
  String get remoteVideos => 'مقاطع الفيديو عن بعد';

  @override
  String get remoteThumbnails => 'الصور المصغرة عن بعد';

  @override
  String get pendingSync => 'المزامنة المعلقة';

  @override
  String get localGallery => 'المعرض المحلي';

  @override
  String get todaysLogs => 'سجلات اليوم';

  @override
  String get viewLogs => 'عرض السجلات';

  @override
  String get logsDialogBody =>
      'سيؤدي هذا إلى إرسال السجلات لمساعدتنا في تصحيح مشكلتك. يرجى ملاحظة أنه سيتم تضمين أسماء الملفات للمساعدة في تتبع المشكلات المتعلقة بملفات معينة.';

  @override
  String get preparingLogs => 'جارٍ تحضير السجلات...';

  @override
  String get emailYourLogs => 'إرسال سجلاتك عبر البريد الإلكتروني';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'يرجى إرسال السجلات إلى \n$toEmail';
  }

  @override
  String get copyEmailAddress => 'نسخ عنوان البريد الإلكتروني';

  @override
  String get exportLogs => 'تصدير السجلات';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return 'يرجى مراسلتنا عبر البريد الإلكتروني على $toEmail';
  }

  @override
  String get dismiss => 'تجاهل';

  @override
  String get didYouKnow => 'هل تعلم؟';

  @override
  String get loadingMessage => 'جارٍ تحميل صورك...';

  @override
  String get loadMessage1 => 'يمكنك مشاركة اشتراكك مع عائلتك.';

  @override
  String get loadMessage2 => 'لقد حفظنا أكثر من 200 مليون ذكرى حتى الآن';

  @override
  String get loadMessage3 =>
      'نحتفظ بـ 3 نسخ من بياناتك، إحداها في ملجأ للطوارئ تحت الأرض.';

  @override
  String get loadMessage4 => 'جميع تطبيقاتنا مفتوحة المصدر.';

  @override
  String get loadMessage5 =>
      'تم تدقيق شفرتنا المصدرية والتشفير الخاص بنا خارجيًا.';

  @override
  String get loadMessage6 => 'يمكنك مشاركة روابط ألبوماتك مع أحبائك.';

  @override
  String get loadMessage7 =>
      'تعمل تطبيقات الهاتف المحمول الخاصة بنا في الخلفية لتشفير أي صور جديدة تلتقطها ونسخها احتياطيًا.';

  @override
  String get loadMessage8 => 'web.ente.io لديه أداة تحميل رائعة.';

  @override
  String get loadMessage9 => 'نستخدم XChaCha20-Poly1305 لتشفير بياناتك بأمان.';

  @override
  String get photoDescriptions => 'أوصاف الصور';

  @override
  String get fileTypesAndNames => 'أنواع وأسماء الملفات';

  @override
  String get location => 'الموقع';

  @override
  String get moments => 'اللحظات';

  @override
  String get searchFaceEmptySection =>
      'سيتم عرض الأشخاص هنا بمجرد الانتهاء من الفهرسة.';

  @override
  String get searchDatesEmptySection => 'ابحث حسب تاريخ أو شهر أو سنة.';

  @override
  String get searchLocationEmptySection =>
      'تجميع الصور الملتقطة ضمن نصف قطر معين لصورة ما.';

  @override
  String get searchPeopleEmptySection =>
      'ادعُ الأشخاص، وسترى جميع الصور التي شاركوها هنا.';

  @override
  String get searchAlbumsEmptySection => 'الألبومات';

  @override
  String get searchFileTypesAndNamesEmptySection => 'أنواع وأسماء الملفات';

  @override
  String get searchCaptionEmptySection =>
      'أضف أوصافًا مثل \"#رحلة\" في معلومات الصورة للعثور عليها بسرعة هنا.';

  @override
  String get language => 'اللغة';

  @override
  String get selectLanguage => 'اختر اللغة';

  @override
  String get locationName => 'اسم الموقع';

  @override
  String get addLocation => 'إضافة موقع';

  @override
  String get groupNearbyPhotos => 'تجميع الصور القريبة';

  @override
  String get kiloMeterUnit => 'كم';

  @override
  String get addLocationButton => 'إضافة';

  @override
  String get radius => 'نصف القطر';

  @override
  String get locationTagFeatureDescription =>
      'تقوم علامة الموقع بتجميع جميع الصور التي تم التقاطها ضمن نصف قطر معين لصورة ما.';

  @override
  String get galleryMemoryLimitInfo =>
      'يتم عرض ما يصل إلى 1000 ذكرى في المعرض.';

  @override
  String get save => 'حفظ';

  @override
  String get centerPoint => 'نقطة المركز';

  @override
  String get pickCenterPoint => 'اختيار نقطة المركز';

  @override
  String get useSelectedPhoto => 'استخدام الصورة المحددة';

  @override
  String get resetToDefault => 'إعادة التعيين إلى الافتراضي';

  @override
  String get edit => 'تعديل';

  @override
  String get deleteLocation => 'حذف الموقع';

  @override
  String get rotateLeft => 'تدوير لليسار';

  @override
  String get flip => 'قلب';

  @override
  String get rotateRight => 'تدوير لليمين';

  @override
  String get saveCopy => 'حفظ نسخة';

  @override
  String get light => 'فاتح';

  @override
  String get color => 'اللون';

  @override
  String get yesDiscardChanges => 'نعم، تجاهل التغييرات';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade =>
      'هل تريد تجاهل التعديلات التي قمت بها؟';

  @override
  String get saving => 'جارٍ الحفظ...';

  @override
  String get editsSaved => 'تم حفظ التعديلات.';

  @override
  String get oopsCouldNotSaveEdits => 'عفوًا، تعذر حفظ التعديلات.';

  @override
  String get distanceInKMUnit => 'كم';

  @override
  String get dayToday => 'اليوم';

  @override
  String get dayYesterday => 'الأمس';

  @override
  String get storage => 'التخزين';

  @override
  String get usedSpace => 'المساحة المستخدمة';

  @override
  String get storageBreakupFamily => 'العائلة';

  @override
  String get storageBreakupYou => 'أنت';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return 'تم استخدام $usedAmount $usedStorageUnit من $totalAmount $totalStorageUnit';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return '$freeAmount $storageUnit متوفرة';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'الإصدار: $versionValue';
  }

  @override
  String get verifyIDLabel => 'تحقق';

  @override
  String get fileInfoAddDescHint => 'إضافة وصف...';

  @override
  String get editLocationTagTitle => 'تعديل الموقع';

  @override
  String get setLabel => 'تعيين';

  @override
  String get setRadius => 'تعيين نصف القطر';

  @override
  String get familyPlanPortalTitle => 'العائلة';

  @override
  String get familyPlanOverview =>
      'أضف 5 أفراد من عائلتك إلى خطتك الحالية دون دفع رسوم إضافية.\n\nيحصل كل فرد على مساحة خاصة به، ولا يمكنهم رؤية ملفات بعضهم البعض إلا إذا تمت مشاركتها.\n\nالخطط العائلية متاحة للعملاء الذين لديهم اشتراك Ente مدفوع.\n\nاشترك الآن للبدء!';

  @override
  String get androidBiometricHint => 'تحقق من الهوية';

  @override
  String get androidBiometricNotRecognized => 'لم يتم التعرف. حاول مرة أخرى.';

  @override
  String get androidBiometricSuccess => 'نجاح';

  @override
  String get androidCancelButton => 'إلغاء';

  @override
  String get androidSignInTitle => 'المصادقة مطلوبة';

  @override
  String get androidBiometricRequiredTitle => 'المصادقة البيومترية مطلوبة';

  @override
  String get androidDeviceCredentialsRequiredTitle =>
      'بيانات اعتماد الجهاز مطلوبة';

  @override
  String get androidDeviceCredentialsSetupDescription =>
      'بيانات اعتماد الجهاز مطلوبة';

  @override
  String get goToSettings => 'الانتقال إلى الإعدادات';

  @override
  String get androidGoToSettingsDescription =>
      'لم يتم إعداد المصادقة البيومترية على جهازك. انتقل إلى \'الإعدادات > الأمان\' لإضافة المصادقة البيومترية.';

  @override
  String get iOSLockOut =>
      'تم تعطيل المصادقة البيومترية. يرجى قفل شاشتك وفتحها لتمكينها.';

  @override
  String get iOSGoToSettingsDescription =>
      'لم يتم إعداد المصادقة البيومترية على جهازك. يرجى تمكين Touch ID أو Face ID على هاتفك.';

  @override
  String get iOSOkButton => 'موافق';

  @override
  String get openstreetmapContributors => 'مساهمو OpenStreetMap';

  @override
  String get hostedAtOsmFrance => 'مستضاف في OSM France';

  @override
  String get map => 'الخريطة';

  @override
  String get maps => 'الخرائط';

  @override
  String get mapsPrivacyNotice =>
      'Approximate coordinates will be sent to privacy conscious third parties like OpenStreetMap to show the map and location.';

  @override
  String get enableMaps => 'تمكين الخرائط';

  @override
  String get quickLinks => 'روابط سريعة';

  @override
  String get selectItemsToAdd => 'تحديد العناصر للإضافة';

  @override
  String get addSelected => 'إضافة المحدد';

  @override
  String get addFromDevice => 'إضافة من الجهاز';

  @override
  String get addPhotos => 'إضافة صور';

  @override
  String get noPhotosFoundHere => 'لم يتم العثور على صور هنا';

  @override
  String get zoomOutToSeePhotos => 'قم بالتصغير لرؤية الصور';

  @override
  String get noImagesWithLocation => 'لا توجد صور تحتوي على موقع';

  @override
  String get unpinAlbum => 'إلغاء تثبيت الألبوم';

  @override
  String get pinAlbum => 'تثبيت الألبوم';

  @override
  String get pin => 'Pin';

  @override
  String get pinPerson => 'Pin person';

  @override
  String get pinToTop => 'Pin to top';

  @override
  String get unpin => 'Unpin';

  @override
  String get unpinPerson => 'Unpin person';

  @override
  String get visibility => 'Visibility';

  @override
  String get hideFromMemories => 'Hide from memories';

  @override
  String get showInMemories => 'Show in memories';

  @override
  String get create => 'إنشاء';

  @override
  String get viewAll => 'عرض الكل';

  @override
  String get nothingSharedWithYouYet => 'لم تتم مشاركة أي شيء معك بعد';

  @override
  String get noAlbumsSharedByYouYet => 'لم تشارك أي ألبومات بعد';

  @override
  String get sharedWithYou => 'تمت مشاركتها معك';

  @override
  String get sharedByYou => 'تمت مشاركتها بواسطتك';

  @override
  String get inviteYourFriendsToEnte => 'ادعُ أصدقاءك إلى Ente';

  @override
  String get failedToDownloadVideo => 'فشل تنزيل الفيديو';

  @override
  String get hiding => 'جارٍ الإخفاء...';

  @override
  String get unhiding => 'جارٍ إظهار...';

  @override
  String get successfullyHid => 'تم الإخفاء بنجاح.';

  @override
  String get successfullyUnhid => 'تم الإظهار بنجاح.';

  @override
  String get crashReporting => 'الإبلاغ عن الأعطال';

  @override
  String get resumableUploads => 'تحميلات قابلة للاستئناف';

  @override
  String get addToHiddenAlbum => 'إضافة إلى الألبوم المخفي';

  @override
  String get moveToHiddenAlbum => 'نقل إلى الألبوم المخفي';

  @override
  String get fileTypes => 'أنواع الملفات';

  @override
  String get deleteConfirmDialogBody =>
      'هذا الحساب مرتبط بتطبيقات Ente الأخرى، إذا كنت تستخدم أيًا منها. سيتم جدولة بياناتك التي تم تحميلها، عبر جميع تطبيقات Ente، للحذف، وسيتم حذف حسابك نهائيًا.';

  @override
  String get hearUsWhereTitle => 'كيف سمعت عن Ente؟ (اختياري)';

  @override
  String get hearUsExplanation =>
      'نحن لا نتتبع عمليات تثبيت التطبيق. سيساعدنا إذا أخبرتنا أين وجدتنا!';

  @override
  String get viewAddOnButton => 'عرض الإضافات';

  @override
  String get addOns => 'الإضافات';

  @override
  String get addOnPageSubtitle => 'تفاصيل الإضافات';

  @override
  String get yourMap => 'خريطتك';

  @override
  String get modifyYourQueryOrTrySearchingFor =>
      'قم بتعديل استعلامك، أو حاول البحث عن';

  @override
  String get blackFridaySale => 'تخفيضات الجمعة السوداء';

  @override
  String get upto50OffUntil4thDec => 'خصم يصل إلى 50%، حتى 4 ديسمبر.';

  @override
  String get photos => 'الصور';

  @override
  String get videos => 'مقاطع الفيديو';

  @override
  String get livePhotos => 'الصور الحية';

  @override
  String get searchHint1 => 'بحث سريع على الجهاز';

  @override
  String get searchHint2 => 'تواريخ الصور، الأوصاف';

  @override
  String get searchHint3 => 'الألبومات، أسماء الملفات، والأنواع';

  @override
  String get searchHint4 => 'الموقع';

  @override
  String get searchHint5 => 'قريبًا: الوجوه والبحث السحري ✨';

  @override
  String get addYourPhotosNow => 'أضف صورك الآن';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count النتائج التي تم العثور عليها',
      one: '$count النتائج التي تم العثور عليها',
    );
    return '$_temp0';
  }

  @override
  String get faces => 'الوجوه';

  @override
  String get people => 'الأشخاص';

  @override
  String get contents => 'المحتويات';

  @override
  String get addNew => 'إضافة جديد';

  @override
  String get contacts => 'جهات الاتصال';

  @override
  String get noInternetConnection => 'لا يوجد اتصال بالإنترنت';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'يرجى التحقق من اتصال الإنترنت الخاص بك والمحاولة مرة أخرى.';

  @override
  String get signOutFromOtherDevices => 'تسجيل الخروج من الأجهزة الأخرى';

  @override
  String get signOutOtherBody =>
      'إذا كنت تعتقد أن شخصًا ما قد يعرف كلمة مرورك، يمكنك إجبار جميع الأجهزة الأخرى التي تستخدم حسابك على تسجيل الخروج.';

  @override
  String get signOutOtherDevices => 'تسجيل الخروج من الأجهزة الأخرى';

  @override
  String get doNotSignOut => 'عدم تسجيل الخروج';

  @override
  String get editLocation => 'تعديل الموقع';

  @override
  String get selectALocation => 'تحديد موقع';

  @override
  String get selectALocationFirst => 'حدد موقعًا أولاً';

  @override
  String get changeLocationOfSelectedItems => 'تغيير موقع العناصر المحددة؟';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte =>
      'ستكون التعديلات على الموقع مرئية فقط داخل Ente.';

  @override
  String get cleanUncategorized => 'تنظيف غير المصنف';

  @override
  String get cleanUncategorizedDescription =>
      'إزالة جميع الملفات من قسم \'غير مصنف\' الموجودة في ألبومات أخرى.';

  @override
  String get waitingForVerification => 'في انتظار التحقق...';

  @override
  String get passkey => 'مفتاح المرور';

  @override
  String get passkeyAuthTitle => 'التحقق من مفتاح المرور';

  @override
  String get loginWithTOTP => 'تسجيل الدخول باستخدام TOTP';

  @override
  String get passKeyPendingVerification => 'التحقق لا يزال معلقًا.';

  @override
  String get loginSessionExpired => 'انتهت صلاحية الجلسة.';

  @override
  String get loginSessionExpiredDetails =>
      'انتهت صلاحية جلستك. يرجى تسجيل الدخول مرة أخرى.';

  @override
  String get verifyPasskey => 'التحقق من مفتاح المرور';

  @override
  String get playOnTv => 'تشغيل الألبوم على التلفزيون';

  @override
  String get pair => 'إقران';

  @override
  String get deviceNotFound => 'لم يتم العثور على الجهاز';

  @override
  String get castInstruction =>
      'قم بزيارة cast.ente.io على الجهاز الذي تريد إقرانه.\n\nأدخل الرمز أدناه لتشغيل الألبوم على تلفزيونك.';

  @override
  String get deviceCodeHint => 'أدخل الرمز';

  @override
  String get joinDiscord => 'الانضمام إلى Discord';

  @override
  String get locations => 'المواقع';

  @override
  String get addAName => 'إضافة اسم';

  @override
  String get findThemQuickly => 'اعثر عليهم بسرعة';

  @override
  String get findPeopleByName => 'البحث عن الأشخاص بسرعة بالاسم';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'إضافة $count مشاهدًا',
      many: 'إضافة $count مشاهدًا',
      few: 'إضافة $count مشاهدين',
      two: 'إضافة مشاهدين',
      one: 'إضافة مشاهد',
      zero: 'إضافة مشاهد',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'إضافة $count متعاونًا',
      many: 'إضافة $count متعاونًا',
      few: 'إضافة $count متعاونين',
      two: 'إضافة متعاونين',
      one: 'إضافة متعاون',
      zero: 'إضافة متعاون',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      'اضغط مطولاً على بريد إلكتروني للتحقق من التشفير من طرف إلى طرف.';

  @override
  String get developerSettingsWarning =>
      'هل أنت متأكد من رغبتك في تعديل إعدادات المطور؟';

  @override
  String get developerSettings => 'إعدادات المطور';

  @override
  String get serverEndpoint => 'نقطة نهاية الخادم';

  @override
  String get invalidEndpoint => 'نقطة النهاية غير صالحة';

  @override
  String get invalidEndpointMessage =>
      'عذرًا، نقطة النهاية التي أدخلتها غير صالحة. يرجى إدخال نقطة نهاية صالحة والمحاولة مرة أخرى.';

  @override
  String get endpointUpdatedMessage => 'تم تحديث نقطة النهاية بنجاح.';

  @override
  String customEndpoint({required Object endpoint}) {
    return 'متصل بـ $endpoint';
  }

  @override
  String get createCollaborativeLink => 'إنشاء رابط تعاوني';

  @override
  String get search => 'بحث';

  @override
  String get enterPersonName => 'أدخل اسم الشخص';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'هذا البريد الإلكتروني مرتبط مسبقاً بـ $name.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return 'عرض $name لإلغاء الربط';
  }

  @override
  String get enterName => 'أدخل الاسم';

  @override
  String get savePerson => 'حفظ الشخص';

  @override
  String get editPerson => 'تعديل الشخص';

  @override
  String get mergedPhotos => 'الصور المدمجة';

  @override
  String get orMergeWithExistingPerson => 'أو الدمج مع شخص موجود';

  @override
  String get enterDateOfBirth => 'تاريخ الميلاد (اختياري)';

  @override
  String get birthday => 'تاريخ الميلاد';

  @override
  String get removePersonLabel => 'إزالة تسمية الشخص';

  @override
  String get removePersonTag => 'Remove person tag';

  @override
  String get areYouSureRemoveThisPersonTag =>
      'Are you sure you want to remove this person tag?';

  @override
  String get autoPairDesc =>
      'الإقران التلقائي يعمل فقط مع الأجهزة التي تدعم Chromecast.';

  @override
  String get manualPairDesc =>
      'الإقران بالرمز السري يعمل مع أي شاشة ترغب في عرض ألبومك عليها.';

  @override
  String get connectToDevice => 'الاتصال بالجهاز';

  @override
  String get autoCastDialogBody => 'سترى أجهزة Cast المتاحة هنا.';

  @override
  String get autoCastiOSPermission =>
      'تأكد من تشغيل أذونات الشبكة المحلية لتطبيق Ente Photos في الإعدادات.';

  @override
  String get noDeviceFound => 'لم يتم العثور على جهاز.';

  @override
  String get stopCastingTitle => 'إيقاف البث';

  @override
  String get stopCastingBody => 'هل تريد إيقاف البث؟';

  @override
  String get castIPMismatchTitle => 'فشل بث الألبوم';

  @override
  String get castIPMismatchBody =>
      'يرجى التأكد من أنك متصل بنفس الشبكة المتصل بها التلفزيون.';

  @override
  String get pairingComplete => 'اكتمل الإقران';

  @override
  String get savingEdits => 'جارٍ حفظ التعديلات...';

  @override
  String get autoPair => 'إقران تلقائي';

  @override
  String get pairWithPin => 'الإقران بالرمز السري';

  @override
  String get faceRecognition => 'التعرف على الوجوه';

  @override
  String get foundFaces => 'الوجوه التي تم العثور عليها';

  @override
  String get clusteringProgress => 'تقدم التجميع';

  @override
  String get trim => 'قص';

  @override
  String get crop => 'اقتصاص';

  @override
  String get rotate => 'تدوير';

  @override
  String get left => 'يسار';

  @override
  String get right => 'يمين';

  @override
  String get whatsNew => 'ما الجديد';

  @override
  String get reviewSuggestions => 'مراجعة الاقتراحات';

  @override
  String get review => 'مراجعة';

  @override
  String get useAsCover => 'استخدام كغلاف';

  @override
  String notPersonLabel({required String name}) {
    return 'ليس $name؟';
  }

  @override
  String get enable => 'تمكين';

  @override
  String get enabled => 'مُمكّن';

  @override
  String get moreDetails => 'المزيد من التفاصيل';

  @override
  String get enableMLIndexingDesc =>
      'يدعم Ente تعلم الآلة على الجهاز للتعرف على الوجوه والبحث السحري وميزات البحث المتقدم الأخرى.';

  @override
  String get magicSearchHint =>
      'يسمح البحث السحري بالبحث عن الصور حسب محتوياتها، مثل \'زهرة\'، \'سيارة حمراء\'، \'وثائق هوية\'';

  @override
  String get panorama => 'بانوراما';

  @override
  String get reenterPassword => 'إعادة إدخال كلمة المرور';

  @override
  String get reenterPin => 'إعادة إدخال رمز PIN';

  @override
  String get deviceLock => 'قفل الجهاز';

  @override
  String get pinLock => 'قفل برمز PIN';

  @override
  String get next => 'التالي';

  @override
  String get setNewPassword => 'تعيين كلمة مرور جديدة';

  @override
  String get enterPin => 'أدخل رمز PIN';

  @override
  String get setNewPin => 'تعيين رمز PIN جديد';

  @override
  String get appLock => 'قفل التطبيق';

  @override
  String get noSystemLockFound => 'لم يتم العثور على قفل نظام.';

  @override
  String get tapToUnlock => 'انقر لفتح القفل';

  @override
  String get tooManyIncorrectAttempts => 'محاولات غير صحيحة كثيرة جدًا.';

  @override
  String get videoInfo => 'معلومات الفيديو';

  @override
  String get autoLock => 'قفل تلقائي';

  @override
  String get immediately => 'فورًا';

  @override
  String get autoLockFeatureDescription =>
      'الوقت الذي يتم بعده قفل التطبيق بعد وضعه في الخلفية.';

  @override
  String get hideContent => 'إخفاء المحتوى';

  @override
  String get hideContentDescriptionAndroid =>
      'يخفي محتوى التطبيق في مبدل التطبيقات ويعطل لقطات الشاشة.';

  @override
  String get hideContentDescriptionIos =>
      'يخفي محتوى التطبيق في مبدل التطبيقات.';

  @override
  String get passwordStrengthInfo =>
      'يتم حساب قوة كلمة المرور مع الأخذ في الاعتبار طول كلمة المرور، والأحرف المستخدمة، وما إذا كانت كلمة المرور تظهر في قائمة أفضل 10,000 كلمة مرور شائعة الاستخدام.';

  @override
  String get noQuickLinksSelected => 'لم يتم تحديد روابط سريعة.';

  @override
  String get pleaseSelectQuickLinksToRemove =>
      'يرجى تحديد الروابط السريعة للإزالة.';

  @override
  String get removePublicLinks => 'إزالة الروابط العامة';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      'سيؤدي هذا إلى إزالة الروابط العامة لجميع الروابط السريعة المحددة.';

  @override
  String get guestView => 'عرض الضيف';

  @override
  String get guestViewEnablePreSteps =>
      'لتمكين عرض الضيف، يرجى إعداد رمز مرور الجهاز أو قفل الشاشة في إعدادات النظام.';

  @override
  String get nameTheAlbum => 'تسمية الألبوم';

  @override
  String get collectPhotosDescription =>
      'أنشئ رابطًا يمكن لأصدقائك من خلاله تحميل الصور بالجودة الأصلية.';

  @override
  String get collect => 'جمع';

  @override
  String get appLockDescriptions =>
      'اختر بين شاشة القفل الافتراضية لجهازك وشاشة قفل مخصصة برمز PIN أو كلمة مرور.';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'لتمكين قفل التطبيق، يرجى إعداد رمز مرور الجهاز أو قفل الشاشة في إعدادات النظام.';

  @override
  String get authToViewPasskey => 'يرجى المصادقة لعرض مفتاح المرور الخاص بك.';

  @override
  String get loopVideoOn => 'Disable looping';

  @override
  String get loopVideoOff => 'Enable looping';

  @override
  String get localSyncErrorMessage =>
      'يبدو أن خطأً ما قد حدث لأن مزامنة الصور المحلية تستغرق وقتًا أطول من المتوقع. يرجى التواصل مع فريق الدعم لدينا.';

  @override
  String get showPerson => 'إظهار الشخص';

  @override
  String get sort => 'فرز';

  @override
  String get mostRecent => 'الأحدث';

  @override
  String get mostRelevant => 'الأكثر صلة';

  @override
  String get loadingYourPhotos => 'جارٍ تحميل صورك...';

  @override
  String processingImport({required Object folderName}) {
    return 'جارٍ معالجة $folderName...';
  }

  @override
  String get personName => 'اسم الشخص';

  @override
  String get addPerson => 'Add person';

  @override
  String get addToPerson => 'Add to person';

  @override
  String get pleaseNamePersonInPeopleSectionFirst =>
      'Please name a person in the People section first';

  @override
  String get onlyUploadedFilesCanBeAddedToPerson =>
      'Only uploaded files can be added to a person';

  @override
  String get noFacesDetectedTapToAdd => 'No faces detected, tap to add.';

  @override
  String addedFilesToPerson({required int count, required String personName}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count files to $personName',
      one: 'Added 1 file to $personName',
    );
    return '$_temp0';
  }

  @override
  String filesAlreadyLinkedToPerson({
    required int count,
    required String personName,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count files are already linked to $personName',
      one: '1 file is already linked to $personName',
    );
    return '$_temp0';
  }

  @override
  String get addNewPerson => 'إضافة شخص جديد';

  @override
  String get addNameOrMerge => 'إضافة اسم أو دمج';

  @override
  String get mergeWithExisting => 'الدمج مع شخص موجود';

  @override
  String get newPerson => 'شخص جديد';

  @override
  String get addName => 'إضافة اسم';

  @override
  String get add => 'إضافة';

  @override
  String extraPhotosFoundFor({required String text}) {
    return 'تم العثور على صور إضافية لـ $text';
  }

  @override
  String get extraPhotosFound => 'تم العثور على صور إضافية';

  @override
  String get configuration => 'التكوين';

  @override
  String get localIndexing => 'الفهرسة المحلية';

  @override
  String get processed => 'تمت المعالجة';

  @override
  String get resetPerson => 'إزالة';

  @override
  String get areYouSureYouWantToResetThisPerson =>
      'هل أنت متأكد من رغبتك في إعادة تعيين هذا الشخص؟';

  @override
  String get allPersonGroupingWillReset =>
      'سيتم إعادة تعيين جميع تجمعات هذا الشخص، وستفقد جميع الاقتراحات المقدمة لهذا الشخص.';

  @override
  String get yesResetPerson => 'نعم، إعادة تعيين الشخص';

  @override
  String get onlyThem => 'هم فقط';

  @override
  String get checkingModels => 'جارٍ فحص النماذج...';

  @override
  String get enableMachineLearningBanner =>
      'قم بتمكين تعلم الآلة للبحث السحري والتعرف على الوجوه.';

  @override
  String get searchDiscoverEmptySection =>
      'سيتم عرض الصور هنا بمجرد اكتمال المعالجة والمزامنة.';

  @override
  String get searchPersonsEmptySection =>
      'سيتم عرض الأشخاص هنا بمجرد اكتمال المعالجة والمزامنة.';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'تمت إضافة $count مشاهدًا',
      many: 'تمت إضافة $count مشاهدًا',
      few: 'تمت إضافة $count مشاهدين',
      two: 'تمت إضافة مشاهدين',
      one: 'تمت إضافة مشاهد واحد',
      zero: 'تمت إضافة 0 مشاهدين',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'تمت إضافة $count متعاونًا',
      many: 'تمت إضافة $count متعاونًا',
      few: 'تمت إضافة $count متعاونين',
      two: 'تمت إضافة متعاونين',
      one: 'تمت إضافة متعاون واحد',
      zero: 'تمت إضافة 0 متعاونين',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured => 'الحساب تم تكوينه بالفعل.';

  @override
  String get sessionIdMismatch => 'عدم تطابق معرّف الجلسة';

  @override
  String get failedToFetchActiveSessions => 'فشل جلب الجلسات النشطة.';

  @override
  String get failedToRefreshStripeSubscription => 'فشل تحديث الاشتراك.';

  @override
  String get failedToPlayVideo => 'فشل تشغيل الفيديو.';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return 'تم تجاهل التحميل بسبب $ignoreReason';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'نوع المعرض $galleryType غير مدعوم لإعادة التسمية.';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'انقر للتحميل، تم تجاهل التحميل حاليًا بسبب $ignoreReason';
  }

  @override
  String get tapToUpload => 'انقر للتحميل';

  @override
  String get info => 'معلومات';

  @override
  String get addFiles => 'إضافة ملفات';

  @override
  String get castAlbum => 'بث الألبوم';

  @override
  String get imageNotAnalyzed => 'لم يتم تحليل الصورة';

  @override
  String get noFacesFound => 'لم يتم العثور على وجوه';

  @override
  String get fileNotUploadedYet => 'لم يتم تحميل الملف بعد';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return 'لا توجد اقتراحات لـ $personName';
  }

  @override
  String get month => 'شهر';

  @override
  String get yearShort => 'سنة';

  @override
  String get currentlyRunning => 'قيد التشغيل حاليًا';

  @override
  String get ignored => 'تم التجاهل';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count صورة',
      many: '$count صورة',
      few: '$count صور',
      two: 'صورتان',
      one: 'صورة واحدة',
      zero: 'لا توجد صور',
    );
    return '$_temp0';
  }

  @override
  String get file => 'ملف';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'عدم تطابق طول الأقسام: $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'تحديد تطبيق البريد';

  @override
  String get selectAllShort => 'الكل';

  @override
  String get selectCoverPhoto => 'تحديد صورة الغلاف';

  @override
  String get newLocation => 'موقع جديد';

  @override
  String get faceNotClusteredYet =>
      'لم يتم تجميع الوجه بعد، يرجى العودة لاحقًا';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'انتهت صلاحية الرابط الذي تحاول الوصول إليه.';

  @override
  String get openFile => 'فتح الملف';

  @override
  String get backupFile => 'نسخ احتياطي للملف';

  @override
  String get openAlbumInBrowser => 'فتح الألبوم في المتصفح';

  @override
  String get openAlbumInBrowserTitle =>
      'يرجى استخدام تطبيق الويب لإضافة صور إلى هذا الألبوم';

  @override
  String get allow => 'السماح';

  @override
  String get allowAppToOpenSharedAlbumLinks =>
      'السماح للتطبيق بفتح روابط الألبومات المشتركة';

  @override
  String get seePublicAlbumLinksInApp =>
      'رؤية روابط الألبومات العامة في التطبيق';

  @override
  String get emergencyContacts => 'جهات اتصال الطوارئ';

  @override
  String get acceptTrustInvite => 'قبول الدعوة';

  @override
  String get declineTrustInvite => 'رفض الدعوة';

  @override
  String get removeYourselfAsTrustedContact => 'إزالة نفسك كجهة اتصال موثوقة';

  @override
  String get legacy => 'جهات الاتصال الموثوقة';

  @override
  String get legacyPageDesc =>
      'تسمح جهات الاتصال الموثوقة لأشخاص معينين بالوصول إلى حسابك في حالة غيابك.';

  @override
  String get legacyPageDesc2 =>
      'يمكن لجهات الاتصال الموثوقة بدء استرداد الحساب، وإذا لم يتم حظر ذلك خلال 30 يومًا، يمكنهم إعادة تعيين كلمة المرور والوصول إلى حسابك.';

  @override
  String get legacyAccounts => 'الحسابات الموثوقة';

  @override
  String get trustedContacts => 'جهات الاتصال الموثوقة';

  @override
  String get addTrustedContact => 'إضافة جهة اتصال موثوقة';

  @override
  String get removeInvite => 'إزالة الدعوة';

  @override
  String get recoveryWarning => 'جهة اتصال موثوقة تحاول الوصول إلى حسابك';

  @override
  String get rejectRecovery => 'رفض الاسترداد';

  @override
  String get recoveryInitiated => 'بدء الاسترداد';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return 'يمكنك الوصول إلى الحساب بعد $days أيام. سيتم إرسال إشعار إلى $email.';
  }

  @override
  String get cancelAccountRecovery => 'إلغاء استرداد الحساب';

  @override
  String get recoveryAccount => 'استرداد الحساب';

  @override
  String get cancelAccountRecoveryBody =>
      'هل أنت متأكد من رغبتك في إلغاء الاسترداد؟';

  @override
  String get startAccountRecoveryTitle => 'بدء الاسترداد';

  @override
  String get whyAddTrustContact =>
      'يمكن لجهة الاتصال الموثوقة المساعدة في استعادة بياناتك.';

  @override
  String recoveryReady({required String email}) {
    return 'يمكنك الآن استرداد حساب $email عن طريق تعيين كلمة مرور جديدة.';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email يحاول استرداد حسابك.';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return 'لقد تمت دعوتك لتكون جهة اتصال موثوقة بواسطة $email.';
  }

  @override
  String get warning => 'تحذير';

  @override
  String get proceed => 'متابعة';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return 'أنت على وشك إضافة $email كجهة اتصال موثوقة. سيكون بإمكانهم استعادة حسابك إذا كنت غائبًا لمدة $numOfDays أيام.';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email دعاك لتكون جهة اتصال موثوقة';
  }

  @override
  String get authToManageLegacy =>
      'يرجى المصادقة لإدارة جهات الاتصال الموثوقة الخاصة بك.';

  @override
  String get hideSharedItemsFromHomeGallery =>
      'إخفاء العناصر المشتركة من معرض الصفحة الرئيسية';

  @override
  String get swipeToSelect => 'Swipe to select';

  @override
  String get gallery => 'المعرض';

  @override
  String get joinAlbum => 'الانضمام إلى الألبوم';

  @override
  String get joinAlbumSubtext => 'لعرض صورك وإضافتها';

  @override
  String get joinAlbumSubtextViewer => 'لإضافة هذا إلى الألبومات المشتركة';

  @override
  String get join => 'انضمام';

  @override
  String get linkEmail => 'ربط البريد الإلكتروني';

  @override
  String get link => 'ربط';

  @override
  String get noEnteAccountExclamation => 'لا يوجد حساب Ente!';

  @override
  String get orPickFromYourContacts => 'أو اختر من جهات اتصالك';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return '$email لا يملك حساب Ente.';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (أنا)';
  }

  @override
  String get reassignMe => 'إعادة تعيين \"أنا\"';

  @override
  String get me => 'أنا';

  @override
  String get linkEmailToContactBannerCaption => 'لمشاركة أسرع';

  @override
  String get selectPersonToLink => 'تحديد الشخص للربط';

  @override
  String linkPersonToEmail({required String email}) {
    return 'ربط الشخص بـ $email';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return 'سيؤدي هذا إلى ربط $personName بـ $email';
  }

  @override
  String get selectYourFace => 'حدد وجهك';

  @override
  String get reassigningLoading => 'جارٍ إعادة التعيين...';

  @override
  String reassignedToName({required String name}) {
    return 'تمت إعادة تعيينك إلى $name';
  }

  @override
  String get saveChangesBeforeLeavingQuestion => 'حفظ التغييرات قبل المغادرة؟';

  @override
  String get dontSave => 'عدم الحفظ';

  @override
  String get thisIsMeExclamation => 'هذا أنا!';

  @override
  String get linkPerson => 'ربط الشخص';

  @override
  String get linkPersonCaption => 'لتجربة مشاركة أفضل';

  @override
  String get videoStreaming => 'مقاطع فيديو قابلة للبث';

  @override
  String get processingVideos => 'معالجة مقاطع الفيديو';

  @override
  String get streamDetails => 'تفاصيل البث';

  @override
  String get processing => 'المعالجة';

  @override
  String get queued => 'في قائمة الانتظار';

  @override
  String get ineligible => 'غير مؤهل';

  @override
  String get failed => 'فشل';

  @override
  String get playStream => 'تشغيل البث';

  @override
  String get playOriginal => 'تشغيل الأصلي';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'الانضمام إلى ألبوم سيجعل بريدك الإلكتروني مرئيًا للمشاركين فيه.';

  @override
  String get pleaseWaitThisWillTakeAWhile =>
      'يرجى الانتظار، قد يستغرق هذا بعض الوقت.';

  @override
  String get editTime => 'تعديل الوقت';

  @override
  String get selectTime => 'تحديد الوقت';

  @override
  String get selectDate => 'تحديد التاريخ';

  @override
  String get previous => 'السابق';

  @override
  String get selectOneDateAndTimeForAll => 'تحديد تاريخ ووقت واحد للجميع';

  @override
  String get selectStartOfRange => 'تحديد بداية النطاق';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      'سيجعل هذا تاريخ ووقت جميع الصور المحددة متماثلاً.';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'هذه هي الأولى في المجموعة. سيتم تغيير تواريخ الصور المحددة الأخرى تلقائيًا بناءً على هذا التاريخ الجديد.';

  @override
  String get newRange => 'نطاق جديد';

  @override
  String get selectOneDateAndTime => 'تحديد تاريخ ووقت واحد';

  @override
  String get moveSelectedPhotosToOneDate => 'نقل الصور المحددة إلى تاريخ واحد';

  @override
  String get shiftDatesAndTime => 'تغيير التواريخ والوقت';

  @override
  String get photosKeepRelativeTimeDifference =>
      'تحتفظ الصور بالفرق الزمني النسبي';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count صورة',
      many: '$count صورة',
      few: '$count صور',
      two: 'صورتان',
      one: 'صورة واحدة',
      zero: 'لا توجد صور',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'أيقونة التطبيق';

  @override
  String get notThisPerson => 'ليس هذا الشخص؟';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      'سيتم إزالة العناصر المحددة من هذا الشخص، ولكن لن يتم حذفها من مكتبتك.';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat عبر السنين';
  }

  @override
  String get thisWeekThroughTheYears => 'هذا الأسبوع عبر السنين';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'هذا الأسبوع، قبل $count سنة',
      many: 'هذا الأسبوع، قبل $count سنة',
      few: 'هذا الأسبوع، قبل $count سنوات',
      two: 'هذا الأسبوع، قبل سنتين',
      one: 'هذا الأسبوع، قبل سنة',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'أنت و $name';
  }

  @override
  String admiringThem({required Object name}) {
    return 'الإعجاب بـ $name';
  }

  @override
  String embracingThem({required Object name}) {
    return 'معانقة $name';
  }

  @override
  String partyWithThem({required Object name}) {
    return 'الاحتفال مع $name';
  }

  @override
  String hikingWithThem({required Object name}) {
    return 'التنزه مع $name';
  }

  @override
  String feastingWithThem({required Object name}) {
    return 'الاستمتاع بالطعام مع $name';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return 'صور سيلفي مع $name';
  }

  @override
  String posingWithThem({required Object name}) {
    return 'التقاط صور مع $name';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return 'مناظر جميلة مع $name';
  }

  @override
  String sportsWithThem({required Object name}) {
    return 'الرياضة مع $name';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return 'رحلة برية مع $name';
  }

  @override
  String get spotlightOnYourself => 'تسليط الضوء عليك';

  @override
  String spotlightOnThem({required Object name}) {
    return 'تسليط الضوء على $name';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$name يبلغ $age!';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name سيبلغ $age قريبًا';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return 'آخر مرة مع $name';
  }

  @override
  String tripToLocation({required Object location}) {
    return 'رحلة إلى $location';
  }

  @override
  String tripInYear({required Object year}) {
    return 'رحلة في $year';
  }

  @override
  String get lastYearsTrip => 'رحلة العام الماضي';

  @override
  String get sunrise => 'على الأفق';

  @override
  String get mountains => 'فوق التلال';

  @override
  String get greenery => 'الحياة الخضراء';

  @override
  String get beach => 'رمال وبحر';

  @override
  String get city => 'في المدينة';

  @override
  String get moon => 'في ضوء القمر';

  @override
  String get onTheRoad => 'على الطريق مرة أخرى';

  @override
  String get food => 'متعة الطهي';

  @override
  String get pets => 'رفاق فروي';

  @override
  String get curatedMemories => 'ذكريات منسقة';

  @override
  String get widgets => 'عناصر واجهة';

  @override
  String get memories => 'ذكريات';

  @override
  String get peopleWidgetDesc =>
      'حدد الأشخاص الذين ترغب في ظهورهم على شاشتك الرئيسية.';

  @override
  String get albumsWidgetDesc =>
      'حدد الألبومات التي تريد ظهورها على شاشتك الرئيسية.';

  @override
  String get memoriesWidgetDesc =>
      'اختر نوع الذكريات التي ترغب في رؤيتها على شاشتك الرئيسية.';

  @override
  String get smartMemories => 'ذكريات ذكية';

  @override
  String get pastYearsMemories => 'ذكريات السنوات الماضية';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return 'هل تريد أيضًا حذف الصور (والمقاطع) الموجودة في هذه الألبومات $count من <bold>كافة</bold> الألبومات الأخرى التي تشترك فيها؟';
  }

  @override
  String get addParticipants => 'إضافة مشاركين';

  @override
  String selectedAlbums({required Object count}) {
    return '$count تم تحديد';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'الإجراء غير مدعوم في ألبوم المفضلة';

  @override
  String get onThisDayMemories => 'ذكريات هذا اليوم';

  @override
  String get onThisDay => 'في هذا اليوم';

  @override
  String get lookBackOnYourMemories => 'استرجع ذكرياتك 🌄';

  @override
  String get newPhotosEmoji => ' جديد 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'عذراً، لقد اضطررنا إلى إيقاف النسخ الاحتياطي الخاصة بك';

  @override
  String get clickToInstallOurBestVersionYet =>
      'انقر لتثبيت أفضل إصدار لنا حتى الآن';

  @override
  String get onThisDayNotificationExplanation =>
      'تلقي  تذكيرات حول ذكريات مثل اليوم في السنوات السابقة.';

  @override
  String get addMemoriesWidgetPrompt =>
      'أضف أداة ذكريات إلى شاشتك الرئيسية، ثم عد إلى هنا لتخصيصها.';

  @override
  String get addAlbumWidgetPrompt =>
      'أضف أداة ألبوم إلى شاشتك الرئيسية، ثم عد إلى هنا لتخصيصها.';

  @override
  String get addPeopleWidgetPrompt =>
      'أضف عنصر واجهة الأشخاص إلى شاشتك الرئيسية ثم عد إلى هنا لتخصيصه.';

  @override
  String get birthdayNotifications => 'إشعارات عيد الميلاد';

  @override
  String get receiveRemindersOnBirthdays =>
      'استلم تذكيرات عندما يحين عيد ميلاد أحدهم. النقر على الإشعار سينقلك إلى صور الشخص المحتفل بعيد ميلاده.';

  @override
  String get happyBirthday => 'عيد ميلاد سعيد! 🥳';

  @override
  String get birthdays => 'أعياد الميلاد';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return 'أتمنى لـ$name عيد ميلاد سعيد! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      'هل أنت متأكد من رغبتك في إزالة هذا الوجه من هذا الشخص؟';

  @override
  String get otherDetectedFaces => 'وجوه أخرى تم اكتشافها';

  @override
  String get areThey => 'هل هم ';

  @override
  String get questionmark => '؟';

  @override
  String get saveAsAnotherPerson => 'حفظ كشخص آخر';

  @override
  String get showLessFaces => 'إظهار وجوه أقل';

  @override
  String get showMoreFaces => 'إظهار المزيد من الوجوه';

  @override
  String get ignore => 'تجاهل';

  @override
  String get merge => 'دمج';

  @override
  String get reset => 'إعادة تعيين';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      'هل أنت متأكد من أنك تريد تجاهل هذا الشخص؟';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      'هل أنت متأكد أنك تريد تجاهل هؤلاء الأشخاص؟';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'لن تظهر مجموعات الأشخاص في قسم الأشخاص بعد الآن. ستظل الصور دون تغيير.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'لن يتم عرض هذا الشخص في قسم الأشخاص بعد الآن. الصور ستبقى كما هي دون تغيير.';

  @override
  String get areYouSureYouWantToMergeThem => 'هل أنت متأكد من رغبتك في دمجهم؟';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'سيتم دمج جميع المجموعات غير المسماة مع الشخص المحدد. يمكن التراجع عن هذا الإجراء لاحقًا من خلال نظرة عامة على سجل الاقتراحات التابع لهذا الشخص.';

  @override
  String get yesIgnore => 'نعم، تجاهل';

  @override
  String get same => 'نفس';

  @override
  String get different => 'مختلف';

  @override
  String get sameperson => 'نفس الشخص؟';

  @override
  String get indexingPausedStatusDescription =>
      'يتم إيقاف الفهرسة مؤقتاً. سوف تستأنف تلقائياً عندما يكون الجهاز جاهزاً. يعدّ الجهاز جاهزا عندما يكون مستوى البطارية وصحة البطارية والحالة الحرارية في نطاق سليم.';

  @override
  String get thisWeek => 'هذا الأسبوع';

  @override
  String get lastWeek => 'الأسبوع الماضي';

  @override
  String get thisMonth => 'هذا الشهر';

  @override
  String get thisYear => 'هذه السنة';

  @override
  String get groupBy => 'تجميع حسب';

  @override
  String get faceThumbnailGenerationFailed => 'تعذر إنشاء الصور المصغرة للوجه';

  @override
  String get fileAnalysisFailed => 'تعذر تحليل الملف';

  @override
  String get editAutoAddPeople => 'تحرير إضافة الأشخاص التلقائية';

  @override
  String get autoAddPeople => 'إضافة الأشخاص التلقائية';

  @override
  String get autoAddToAlbum => 'إضافة تلقائية إلى الألبوم';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      'هل ينبغي إزالة الملفات المتعلقة بالشخص الذي تم اختياره سابقا في الألبومات الذكية؟';

  @override
  String get addingPhotos => 'جاري إضافة الصور';

  @override
  String get gettingReady => 'جاري الإعداد';

  @override
  String get addSomePhotosDesc1 => 'إضافة بعض الصور أو الاختيار ';

  @override
  String get addSomePhotosDesc2 => 'وجوه مألوفة';

  @override
  String get addSomePhotosDesc3 => '\nللبدء بـ';

  @override
  String get ignorePerson => 'تجاهل الشخص';

  @override
  String get mixedGrouping => 'تجميع مختلط؟';

  @override
  String get analysis => 'تحليل';

  @override
  String get doesGroupContainMultiplePeople =>
      'هل هذه المجموعة تحتوي على أشخاص متعددين؟';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'سنقوم تلقائيا بتحليل المجموعة لتحديد ما إذا كان هناك عدة أشخاص، وفصلهم مرة أخرى. قد يستغرق هذا بضع ثوان.';

  @override
  String get layout => 'التخطيط';

  @override
  String get day => 'اليوم';

  @override
  String get undo => 'تراجع';

  @override
  String get redo => 'إعادة';

  @override
  String get filter => 'فلتر';

  @override
  String get adjust => 'تعديل';

  @override
  String get draw => 'رسم';

  @override
  String get sticker => 'ملصق';

  @override
  String get brushColor => 'لون الفرشاة';

  @override
  String get font => 'الخط';

  @override
  String get background => 'خلفية';

  @override
  String get align => 'محاذاة';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'تم الإضافة إلى $count ألبومات بنجاح',
      one: 'تمت الإضافة إلى ألبوم واحد بنجاح',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => 'تم معالجة الفيديو';

  @override
  String get totalVideos => 'Total videos';

  @override
  String get skippedVideos => 'Skipped videos';

  @override
  String get videoStreamingDescriptionLine1 =>
      'Play videos instantly on any device.';

  @override
  String get videoStreamingDescriptionLine2 =>
      'Enable to process video streams on this device.';

  @override
  String get videoStreamingNote =>
      'Only videos from last 60 days and under 1 minute are processed on this device. For older/longer videos, enable streaming in the desktop app.';

  @override
  String get createStream => 'Create stream';

  @override
  String get recreateStream => 'Recreate stream';

  @override
  String get addedToStreamCreationQueue => 'Added to stream creation queue';

  @override
  String get addedToStreamRecreationQueue => 'Added to stream recreation queue';

  @override
  String get videoPreviewAlreadyExists => 'Video preview already exists';

  @override
  String get videoAlreadyInQueue => 'Video file already present in the queue';

  @override
  String get videoExportFailed => 'Video creation failed. Please try again.';

  @override
  String videoExportSuccess({required String path}) {
    return 'Video successfully created at $path';
  }

  @override
  String get addedToQueue => 'Added to queue';

  @override
  String get creatingStream => 'Creating stream';

  @override
  String get similarImages => 'Similar images';

  @override
  String get findSimilarImages => 'Find similar images';

  @override
  String get noSimilarImagesFound => 'No similar images found';

  @override
  String get yourPhotosLookUnique => 'Your photos look unique';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count groups found',
      one: '$count group found',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages => 'Review and remove similar images';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return 'Delete $count photos ($size)';
  }

  @override
  String get selectionOptions => 'Selection options';

  @override
  String selectExactWithCount({required int count}) {
    return 'Exactly similar ($count)';
  }

  @override
  String get selectExact => 'Select exact';

  @override
  String selectSimilarWithCount({required int count}) {
    return 'Mostly similar ($count)';
  }

  @override
  String get selectSimilar => 'Select similar';

  @override
  String selectAllWithCount({required int count}) {
    return 'All similarities ($count)';
  }

  @override
  String get selectSimilarImagesTitle => 'Select similar images';

  @override
  String get chooseSimilarImagesToSelect =>
      'Select images based on their visual similarity';

  @override
  String get clearSelection => 'Clear selection';

  @override
  String similarImagesCount({required int count}) {
    return '$count similar images';
  }

  @override
  String deleteWithCount({required int count}) {
    return 'Delete ($count)';
  }

  @override
  String get deleteFiles => 'Delete files';

  @override
  String get areYouSureDeleteFiles =>
      'Are you sure you want to delete these files?';

  @override
  String get greatJob => 'Great job!';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return 'You freed up $size of space';
  }

  @override
  String get size => 'Size';

  @override
  String get similarity => 'Similarity';

  @override
  String get analyzingPhotosLocally => 'Analyzing your photos locally...';

  @override
  String get lookingForVisualSimilarities =>
      'Looking for visual similarities...';

  @override
  String get comparingImageDetails => 'Comparing image details...';

  @override
  String get findingSimilarImages => 'Finding similar images...';

  @override
  String get almostDone => 'Almost done...';

  @override
  String get processingLocally => 'Processing locally';

  @override
  String get useMLToFindSimilarImages =>
      'Review and remove images that look similar to each other.';

  @override
  String get all => 'All';

  @override
  String get similar => 'Similar';

  @override
  String get identical => 'Identical';

  @override
  String get nothingHereTryAnotherFilter =>
      'Nothing here, try another filter! 👀';

  @override
  String get related => 'Related';

  @override
  String get hoorayyyy => 'Hoorayyyy!';

  @override
  String get nothingToTidyUpHere => 'Nothing to tidy up here';

  @override
  String get deletingDash => 'Deleting - ';

  @override
  String get cLTitle1 => 'Introducing Rituals';

  @override
  String get cLDesc1 =>
      'Planning resolutions for 2026? With Rituals, you can set a reminder on Ente Photos and track your progress by taking photos. Use it for workouts, eating habits, daily moments with loved ones—anything you want to make a habit.';

  @override
  String get cLTitle2 => 'Public links, now for everyone';

  @override
  String get cLDesc2 =>
      'All Ente users on the free plan can now create and share public links to photos and albums. To prevent abuse, links will have limits on how many people can view them.';

  @override
  String get cLTitle3 => 'Manually tag people';

  @override
  String get cLDesc3 =>
      'You can now tag people even when our on-device AI doesn\'t detect a face. Handy for pets, partially visible faces, or moments where someone isn\'t actually in the photo but should still be included.';

  @override
  String get cLTitle4 => 'And more';

  @override
  String get cLDesc4 =>
      'You can now pin shared albums. Album links are visible to collaborators and viewers to make sharing even easier. We\'ve fixed some iOS swiping bugs and updated the photo view, including a new favorite icon (making room for upcoming features).';

  @override
  String get closeBy => 'Close';

  @override
  String get peopleAutoAddDesc =>
      'Automatically add photos of the selected people to this album';

  @override
  String get festivities => 'Festive cheer';

  @override
  String get snowAdventures => 'Winter adventures';

  @override
  String get waterfalls => 'Chasing waterfalls';

  @override
  String get wildlife => 'Into the wild';

  @override
  String get flowers => 'Blooming beauties';

  @override
  String get nightLights => 'Neon nights';

  @override
  String get architecture => 'Design icons';

  @override
  String get autumnColors => 'Autumn splendor';

  @override
  String get desertDreams => 'Desert dreams';

  @override
  String get stargazing => 'Under the stars';

  @override
  String get lakeside => 'Lakeside calm';

  @override
  String get rainyDays => 'Rainy day feels';

  @override
  String get sportsAction => 'Game on';

  @override
  String get streetArt => 'Street art stories';

  @override
  String get familyMoments => 'Family time';

  @override
  String get fireworks => 'Firework finale';

  @override
  String get historicSites => 'Echoes of history';

  @override
  String get tropicalParadise => 'Tropical escapes';

  @override
  String get forestTrails => 'Forest strolls';

  @override
  String get citySunsets => 'City sunset glow';

  @override
  String get colorfulMarkets => 'Vibrant markets';

  @override
  String get cozyCafes => 'Cozy cafe corners';

  @override
  String get vintageVibes => 'Vintage vibes';

  @override
  String get aerialViews => 'Aerial perspectives';

  @override
  String get artisticPortraits => 'Artful portraits';

  @override
  String get streetFood => 'Street food bites';

  @override
  String get riverCruises => 'River cruise views';

  @override
  String get facesTimelineBannerTitle => 'Memory Lane';

  @override
  String facesTimelineBannerSubtitle({required String name}) {
    return 'See $name\'s photos across the years';
  }

  @override
  String get facesTimelineAppBarTitle => 'Memory lane';

  @override
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count years old',
      one: '$count year old',
    );
    return '$name was $_temp0';
  }

  @override
  String facesTimelineCaptionYearsAgo({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '# years ago',
      one: '# year ago',
    );
    return '$_temp0';
  }

  @override
  String get facesTimelineShareComingSoon => 'Video sharing coming soon';

  @override
  String get facesTimelinePlaybackPrevious => 'Previous';

  @override
  String get facesTimelinePlaybackNext => 'Next';

  @override
  String get facesTimelinePlaybackPlay => 'Play';

  @override
  String get facesTimelinePlaybackPause => 'Pause';

  @override
  String get facesTimelineUnavailable => 'Faces timeline is preparing...';

  @override
  String get playfulKids => 'Playful kids';

  @override
  String get coastalCliffs => 'Cliffs by the sea';

  @override
  String get ritualsTitle => 'Rituals';

  @override
  String get ritualAddTooltip => 'Add ritual';

  @override
  String get ritualActivityHeading => 'Activity';

  @override
  String get ritualDefaultHeatmapTitle => 'Take a photo every day';

  @override
  String get ritualUntitled => 'Untitled ritual';

  @override
  String get ritualShareUnavailable =>
      'Unable to share right now. Please try again.';

  @override
  String get ritualNotificationMessage => 'Take a photo now';

  @override
  String get ritualCameraNotFound => 'No camera found on this device.';

  @override
  String get ritualCameraStartError =>
      'Unable to start camera. Please check permissions.';

  @override
  String get ritualCaptureError => 'Unable to capture photo. Please try again.';

  @override
  String ritualPhotoLimit({required int maxPhotos}) {
    String _temp0 = intl.Intl.pluralLogic(
      maxPhotos,
      locale: localeName,
      other: '# photos.',
      one: '# photo.',
    );
    return 'You can add up to $_temp0';
  }

  @override
  String get ritualCaptureAtLeastOne => 'Capture at least one photo first.';

  @override
  String get ritualAlbumMissing =>
      'Ritual album missing. Edit the ritual to set an album.';

  @override
  String get ritualAddedToAlbum => 'Added to album';

  @override
  String ritualAddedToAlbumWithName({required String albumName}) {
    return 'Added to $albumName';
  }

  @override
  String ritualAddToAlbumFailure({required String error}) {
    return 'Couldn\'t add photos to the album: $error';
  }

  @override
  String get ritualBackToList => 'Back to rituals';

  @override
  String get ritualNoPhotosYet => 'No photos yet';

  @override
  String get ritualSetAlbumToLaunchCamera =>
      'Set an album for this ritual to launch the camera.';

  @override
  String get ritualDefaultCameraTitle => 'Take a photo';

  @override
  String get ritualBadgeMessage7 =>
      '7 days down! Consistency looks good on you. Keep going!';

  @override
  String get ritualBadgeMessage14 =>
      '14 days in! Your ritual is becoming a habit. Incredible!';

  @override
  String get ritualBadgeMessage30 =>
      '30 days in a row! Legendary consistency. Take a bow!';

  @override
  String get ritualBadgeMessageDefault => 'You\'re on a roll!';

  @override
  String get ritualBadgeNewTitle => 'New achievement';

  @override
  String get ritualBadgePreparing => 'Preparing...';

  @override
  String get ritualStreaksLabel => 'Streaks';

  @override
  String get ritualCreateYourOwn => 'Create your own ritual';

  @override
  String get ritualGetDailyReminders => 'Get daily reminders';

  @override
  String get ritualAlbumNotSet => 'Album not set';

  @override
  String get ritualOpenCameraTooltip => 'Open ritual camera';

  @override
  String get ritualEditorLabel => 'Ritual editor';

  @override
  String get ritualNew => 'Create new ritual';

  @override
  String get ritualCreateNewTitle => 'Create new ritual';

  @override
  String get ritualEdit => 'Edit ritual';

  @override
  String get ritualEnterPrompt => 'Enter your ritual';

  @override
  String get ritualEnterDescription => 'Please enter a description';

  @override
  String get ritualChooseDaysLabel => 'Choose days for ritual';

  @override
  String get ritualDayLabel => 'Day';

  @override
  String get ritualNotificationsOffHint =>
      'Notifications are off. Tap a day to turn them on.';

  @override
  String get ritualTimeLabel => 'Time';

  @override
  String get ritualAlbumLabel => 'Album';

  @override
  String get ritualSave => 'Save ritual';

  @override
  String get ritualCreateAction => 'Create ritual';

  @override
  String get ritualUpdate => 'Update ritual';

  @override
  String get ritualSelectAlbumTitle => 'Select album';

  @override
  String get ritualChooseAlbumLabel => 'Choose an album';

  @override
  String get ritualSendReminderLabel => 'Send reminder';

  @override
  String get ritualSearchOrCreate => 'Search or create new';

  @override
  String get ritualNoAlbumsYet => 'No albums yet';

  @override
  String get ritualNoMatchingAlbums => 'No matching albums';

  @override
  String ritualCreateAlbumWithName({required String albumName}) {
    return 'Create \"$albumName\"';
  }

  @override
  String get ritualCreateNew => 'Create new';

  @override
  String get ritualAlbumSelectionPlaceholder => 'Select album';

  @override
  String get ritualPickEmojiTitle => 'Pick an emoji';

  @override
  String get ritualCustomKeyboardLabel => 'Custom (keyboard)';

  @override
  String get ritualEmojiKeyboardHint => 'Press to open emoji keyboard';

  @override
  String get ritualEmojiUseAction => 'Use';

  @override
  String get ritualSearchEmpty =>
      'Build a ritual to keep your photo habit going.';
}
