#include <sstream>
#include <iomanip>
#include <array>

#include "rive/viewmodel/viewmodel_instance_string.hpp"
#include "rive/component_dirt.hpp"

using namespace rive;

void ViewModelInstanceString::propertyValueChanged()
{
    addDirt(ComponentDirt::Bindings);
#ifdef WITH_RIVE_TOOLS
    if (m_changedCallback != nullptr)
    {
        m_changedCallback(this, propertyValue().c_str());
    }
#endif
    onValueChanged();
}

void ViewModelInstanceString::applyValue(DataValueString* dataValue)
{
    propertyValue(dataValue->value());
}