#include <sstream>
#include <iomanip>
#include <array>

#include "rive/viewmodel/viewmodel_instance_number.hpp"
#include "rive/component_dirt.hpp"

using namespace rive;

void ViewModelInstanceNumber::propertyValueChanged()
{
    addDirt(ComponentDirt::Bindings);
#ifdef WITH_RIVE_TOOLS
    if (m_changedCallback != nullptr)
    {
        m_changedCallback(this, propertyValue());
    }
#endif
    onValueChanged();
}

void ViewModelInstanceNumber::applyValue(DataValueNumber* dataValue)
{
    propertyValue(dataValue->value());
}