#include <sstream>
#include <iomanip>
#include <array>

#include "rive/viewmodel/viewmodel_instance_color.hpp"
#include "rive/component_dirt.hpp"

using namespace rive;

void ViewModelInstanceColor::propertyValueChanged()
{
    addDirt(ComponentDirt::Bindings);
#ifdef WITH_RIVE_TOOLS
    if (m_changedCallback != nullptr)
    {
        m_changedCallback(this, propertyValue());
    }
#endif
    onValueChanged();
}

void ViewModelInstanceColor::applyValue(DataValueColor* dataValue)
{
    propertyValue(dataValue->value());
}