// Copyright (c) 2024, the Dart project authors. Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

// Bindings for `src/foundation.h`.
// Regenerate bindings with `dart run tool/generate_code.dart`.

// ignore_for_file: always_specify_types
// ignore_for_file: camel_case_types
// ignore_for_file: non_constant_identifier_names
// ignore_for_file: unnecessary_non_null_assertion
// ignore_for_file: unused_element
// ignore_for_file: unused_field
// coverage:ignore-file

// AUTO GENERATED FILE, DO NOT EDIT.
//
// Generated by `package:ffigen`.
// ignore_for_file: type=lint
import 'dart:ffi' as ffi;
import '../objective_c.dart' as objc;
import 'package:ffi/ffi.dart' as pkg_ffi;

@ffi.Native<ffi.Pointer<objc.ObjCObject>>(symbol: 'NSLocalizedDescriptionKey')
external ffi.Pointer<objc.ObjCObject> _NSLocalizedDescriptionKey;

NSString get NSLocalizedDescriptionKey =>
    NSString.castFromPointer(_NSLocalizedDescriptionKey,
        retain: true, release: true);

set NSLocalizedDescriptionKey(NSString value) {
  NSString.castFromPointer(_NSLocalizedDescriptionKey,
          retain: false, release: true)
      .ref
      .release();
  _NSLocalizedDescriptionKey = value.ref.retainAndReturnPointer();
}

@ffi.Native<
    instancetype Function(
        ffi.Pointer<objc.ObjCObject>,
        ffi.Pointer<ffi.Void>,
        ffi.Pointer<objc.ObjCObject>,
        ffi.Pointer<objc.ObjCObject>,
        ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>()
external instancetype _ObjectiveCBindings_protocolTrampoline_10z9f5k(
  ffi.Pointer<objc.ObjCObject> target,
  ffi.Pointer<ffi.Void> arg0,
  ffi.Pointer<objc.ObjCObject> arg1,
  ffi.Pointer<objc.ObjCObject> arg2,
  ffi.Pointer<ffi.Pointer<objc.ObjCObject>> arg3,
);

@ffi.Native<
    ffi.UnsignedLong Function(
        ffi.Pointer<objc.ObjCObject>,
        ffi.Pointer<ffi.Void>,
        ffi.Pointer<NSFastEnumerationState>,
        ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
        ffi.UnsignedLong)>()
external int _ObjectiveCBindings_protocolTrampoline_17ap02x(
  ffi.Pointer<objc.ObjCObject> target,
  ffi.Pointer<ffi.Void> arg0,
  ffi.Pointer<NSFastEnumerationState> arg1,
  ffi.Pointer<ffi.Pointer<objc.ObjCObject>> arg2,
  int arg3,
);

@ffi.Native<
    ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
        ffi.Pointer<ffi.Void>, ffi.Pointer<NSZone>)>()
external ffi.Pointer<objc.ObjCObject>
    _ObjectiveCBindings_protocolTrampoline_18nsem0(
  ffi.Pointer<objc.ObjCObject> target,
  ffi.Pointer<ffi.Void> arg0,
  ffi.Pointer<NSZone> arg1,
);

@ffi.Native<
    ffi.Void Function(ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>,
        ffi.Pointer<objc.ObjCObject>)>()
external void _ObjectiveCBindings_protocolTrampoline_18v1jvf(
  ffi.Pointer<objc.ObjCObject> target,
  ffi.Pointer<ffi.Void> arg0,
  ffi.Pointer<objc.ObjCObject> arg1,
);

@ffi.Native<
    ffi.Pointer<NSZone> Function(
        ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>)>()
external ffi.Pointer<NSZone> _ObjectiveCBindings_protocolTrampoline_1a8cl66(
  ffi.Pointer<objc.ObjCObject> target,
  ffi.Pointer<ffi.Void> arg0,
);

@ffi.Native<
    ffi.UnsignedLong Function(
        ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>)>()
external int _ObjectiveCBindings_protocolTrampoline_1ckyi24(
  ffi.Pointer<objc.ObjCObject> target,
  ffi.Pointer<ffi.Void> arg0,
);

@ffi.Native<
    ffi.Long Function(ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>,
        ffi.Pointer<objc.ObjCObject>)>()
external int _ObjectiveCBindings_protocolTrampoline_1ldqghh(
  ffi.Pointer<objc.ObjCObject> target,
  ffi.Pointer<ffi.Void> arg0,
  ffi.Pointer<objc.ObjCObject> arg1,
);

@ffi.Native<
    ffi.Pointer<objc.ObjCObject> Function(
        ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>)>()
external ffi.Pointer<objc.ObjCObject>
    _ObjectiveCBindings_protocolTrampoline_1mbt9g9(
  ffi.Pointer<objc.ObjCObject> target,
  ffi.Pointer<ffi.Void> arg0,
);

@ffi.Native<
    ffi.Pointer<objc.ObjCObject> Function(
        ffi.Pointer<objc.ObjCObject>,
        ffi.Pointer<ffi.Void>,
        ffi.Pointer<objc.ObjCSelector>,
        ffi.Pointer<objc.ObjCObject>)>()
external ffi.Pointer<objc.ObjCObject>
    _ObjectiveCBindings_protocolTrampoline_1mllhpc(
  ffi.Pointer<objc.ObjCObject> target,
  ffi.Pointer<ffi.Void> arg0,
  ffi.Pointer<objc.ObjCSelector> arg1,
  ffi.Pointer<objc.ObjCObject> arg2,
);

@ffi.Native<
    ffi.Bool Function(ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>,
        ffi.Pointer<objc.ObjCObject>)>()
external bool _ObjectiveCBindings_protocolTrampoline_3su7tt(
  ffi.Pointer<objc.ObjCObject> target,
  ffi.Pointer<ffi.Void> arg0,
  ffi.Pointer<objc.ObjCObject> arg1,
);

@ffi.Native<
    ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
        ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>)>()
external ffi.Pointer<objc.ObjCObject>
    _ObjectiveCBindings_protocolTrampoline_50as9u(
  ffi.Pointer<objc.ObjCObject> target,
  ffi.Pointer<ffi.Void> arg0,
  ffi.Pointer<objc.ObjCSelector> arg1,
);

@ffi.Native<
    ffi.Pointer<objc.ObjCObject> Function(
        ffi.Pointer<objc.ObjCObject>,
        ffi.Pointer<ffi.Void>,
        ffi.Pointer<objc.ObjCSelector>,
        ffi.Pointer<objc.ObjCObject>,
        ffi.Pointer<objc.ObjCObject>)>()
external ffi.Pointer<objc.ObjCObject>
    _ObjectiveCBindings_protocolTrampoline_c7gk2u(
  ffi.Pointer<objc.ObjCObject> target,
  ffi.Pointer<ffi.Void> arg0,
  ffi.Pointer<objc.ObjCSelector> arg1,
  ffi.Pointer<objc.ObjCObject> arg2,
  ffi.Pointer<objc.ObjCObject> arg3,
);

@ffi.Native<
    ffi.Bool Function(ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>)>()
external bool _ObjectiveCBindings_protocolTrampoline_e3qsqz(
  ffi.Pointer<objc.ObjCObject> target,
  ffi.Pointer<ffi.Void> arg0,
);

@ffi.Native<
    ffi.Void Function(ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>,
        ffi.Pointer<objc.ObjCObject>, ffi.UnsignedLong)>()
external void _ObjectiveCBindings_protocolTrampoline_hoampi(
  ffi.Pointer<objc.ObjCObject> target,
  ffi.Pointer<ffi.Void> arg0,
  ffi.Pointer<objc.ObjCObject> arg1,
  int arg2,
);

@ffi.Native<
    ffi.Void Function(ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>)>()
external void _ObjectiveCBindings_protocolTrampoline_ovsamd(
  ffi.Pointer<objc.ObjCObject> target,
  ffi.Pointer<ffi.Void> arg0,
);

@ffi.Native<
    ffi.Bool Function(ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>,
        ffi.Pointer<objc.ObjCSelector>)>()
external bool _ObjectiveCBindings_protocolTrampoline_w1e3k0(
  ffi.Pointer<objc.ObjCObject> target,
  ffi.Pointer<ffi.Void> arg0,
  ffi.Pointer<objc.ObjCSelector> arg1,
);

@ffi.Native<
    instancetype Function(ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>,
        ffi.Pointer<objc.ObjCObject>)>()
external instancetype _ObjectiveCBindings_protocolTrampoline_xr62hr(
  ffi.Pointer<objc.ObjCObject> target,
  ffi.Pointer<ffi.Void> arg0,
  ffi.Pointer<objc.ObjCObject> arg1,
);

@ffi.Native<
    ffi.Pointer<objc.ObjCBlockImpl> Function(
        ffi.Pointer<objc.ObjCBlockImpl>,
        ffi.Pointer<objc.ObjCBlockImpl>,
        ffi.Pointer<objc.DOBJC_Context>)>(isLeaf: true)
external ffi.Pointer<objc.ObjCBlockImpl>
    _ObjectiveCBindings_wrapBlockingBlock_18v1jvf(
  ffi.Pointer<objc.ObjCBlockImpl> block,
  ffi.Pointer<objc.ObjCBlockImpl> listnerBlock,
  ffi.Pointer<objc.DOBJC_Context> context,
);

@ffi.Native<
    ffi.Pointer<objc.ObjCBlockImpl> Function(
        ffi.Pointer<objc.ObjCBlockImpl>,
        ffi.Pointer<objc.ObjCBlockImpl>,
        ffi.Pointer<objc.DOBJC_Context>)>(isLeaf: true)
external ffi.Pointer<objc.ObjCBlockImpl>
    _ObjectiveCBindings_wrapBlockingBlock_1b3bb6a(
  ffi.Pointer<objc.ObjCBlockImpl> block,
  ffi.Pointer<objc.ObjCBlockImpl> listnerBlock,
  ffi.Pointer<objc.DOBJC_Context> context,
);

@ffi.Native<
    ffi.Pointer<objc.ObjCBlockImpl> Function(
        ffi.Pointer<objc.ObjCBlockImpl>,
        ffi.Pointer<objc.ObjCBlockImpl>,
        ffi.Pointer<objc.DOBJC_Context>)>(isLeaf: true)
external ffi.Pointer<objc.ObjCBlockImpl>
    _ObjectiveCBindings_wrapBlockingBlock_hoampi(
  ffi.Pointer<objc.ObjCBlockImpl> block,
  ffi.Pointer<objc.ObjCBlockImpl> listnerBlock,
  ffi.Pointer<objc.DOBJC_Context> context,
);

@ffi.Native<
    ffi.Pointer<objc.ObjCBlockImpl> Function(
        ffi.Pointer<objc.ObjCBlockImpl>,
        ffi.Pointer<objc.ObjCBlockImpl>,
        ffi.Pointer<objc.DOBJC_Context>)>(isLeaf: true)
external ffi.Pointer<objc.ObjCBlockImpl>
    _ObjectiveCBindings_wrapBlockingBlock_ovsamd(
  ffi.Pointer<objc.ObjCBlockImpl> block,
  ffi.Pointer<objc.ObjCBlockImpl> listnerBlock,
  ffi.Pointer<objc.DOBJC_Context> context,
);

@ffi.Native<
    ffi.Pointer<objc.ObjCBlockImpl> Function(
        ffi.Pointer<objc.ObjCBlockImpl>,
        ffi.Pointer<objc.ObjCBlockImpl>,
        ffi.Pointer<objc.DOBJC_Context>)>(isLeaf: true)
external ffi.Pointer<objc.ObjCBlockImpl>
    _ObjectiveCBindings_wrapBlockingBlock_pfv6jd(
  ffi.Pointer<objc.ObjCBlockImpl> block,
  ffi.Pointer<objc.ObjCBlockImpl> listnerBlock,
  ffi.Pointer<objc.DOBJC_Context> context,
);

@ffi.Native<
    ffi.Pointer<objc.ObjCBlockImpl> Function(
        ffi.Pointer<objc.ObjCBlockImpl>)>(isLeaf: true)
external ffi.Pointer<objc.ObjCBlockImpl>
    _ObjectiveCBindings_wrapListenerBlock_18v1jvf(
  ffi.Pointer<objc.ObjCBlockImpl> block,
);

@ffi.Native<
    ffi.Pointer<objc.ObjCBlockImpl> Function(
        ffi.Pointer<objc.ObjCBlockImpl>)>(isLeaf: true)
external ffi.Pointer<objc.ObjCBlockImpl>
    _ObjectiveCBindings_wrapListenerBlock_1b3bb6a(
  ffi.Pointer<objc.ObjCBlockImpl> block,
);

@ffi.Native<
    ffi.Pointer<objc.ObjCBlockImpl> Function(
        ffi.Pointer<objc.ObjCBlockImpl>)>(isLeaf: true)
external ffi.Pointer<objc.ObjCBlockImpl>
    _ObjectiveCBindings_wrapListenerBlock_hoampi(
  ffi.Pointer<objc.ObjCBlockImpl> block,
);

@ffi.Native<
    ffi.Pointer<objc.ObjCBlockImpl> Function(
        ffi.Pointer<objc.ObjCBlockImpl>)>(isLeaf: true)
external ffi.Pointer<objc.ObjCBlockImpl>
    _ObjectiveCBindings_wrapListenerBlock_ovsamd(
  ffi.Pointer<objc.ObjCBlockImpl> block,
);

@ffi.Native<
    ffi.Pointer<objc.ObjCBlockImpl> Function(
        ffi.Pointer<objc.ObjCBlockImpl>)>(isLeaf: true)
external ffi.Pointer<objc.ObjCBlockImpl>
    _ObjectiveCBindings_wrapListenerBlock_pfv6jd(
  ffi.Pointer<objc.ObjCBlockImpl> block,
);

/// Helper class to adapt a Dart stream into a `NSInputStream`.
class DartInputStreamAdapter extends NSInputStream implements NSStreamDelegate {
  DartInputStreamAdapter._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [DartInputStreamAdapter] that points to the same underlying object as [other].
  DartInputStreamAdapter.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [DartInputStreamAdapter] that wraps the given raw object pointer.
  DartInputStreamAdapter.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [DartInputStreamAdapter].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(obj.ref.pointer, _sel_isKindOfClass_,
        _class_DOBJCDartInputStreamAdapter);
  }

  /// inputStreamWithData:
  static DartInputStreamAdapter? inputStreamWithData_(NSData data) {
    final _ret = _objc_msgSend_1sotr3r(_class_DOBJCDartInputStreamAdapter,
        _sel_inputStreamWithData_, data.ref.pointer);
    return _ret.address == 0
        ? null
        : DartInputStreamAdapter.castFromPointer(_ret,
            retain: true, release: true);
  }

  /// inputStreamWithFileAtPath:
  static DartInputStreamAdapter? inputStreamWithFileAtPath_(NSString path) {
    final _ret = _objc_msgSend_1sotr3r(_class_DOBJCDartInputStreamAdapter,
        _sel_inputStreamWithFileAtPath_, path.ref.pointer);
    return _ret.address == 0
        ? null
        : DartInputStreamAdapter.castFromPointer(_ret,
            retain: true, release: true);
  }

  /// Creates the adapter.
  /// @param sendPort A port to that is will receive two types of messages:
  /// -1 => The `NSInputStream` has been closed and the port can be closed.
  /// _  => The number of types being required in a `read:maxLength` call.
  static DartInputStreamAdapter inputStreamWithPort_(int sendPort) {
    final _ret = _objc_msgSend_1ya1kjn(_class_DOBJCDartInputStreamAdapter,
        _sel_inputStreamWithPort_, sendPort);
    return DartInputStreamAdapter.castFromPointer(_ret,
        retain: true, release: true);
  }

  /// inputStreamWithURL:
  static DartInputStreamAdapter? inputStreamWithURL_(NSURL url) {
    objc.checkOsVersionInternal(
        'DOBJCDartInputStreamAdapter.inputStreamWithURL:',
        iOS: (false, (4, 0, 0)),
        macOS: (false, (10, 6, 0)));
    final _ret = _objc_msgSend_1sotr3r(_class_DOBJCDartInputStreamAdapter,
        _sel_inputStreamWithURL_, url.ref.pointer);
    return _ret.address == 0
        ? null
        : DartInputStreamAdapter.castFromPointer(_ret,
            retain: true, release: true);
  }

  /// addData:
  int addData_(NSData data) {
    return _objc_msgSend_1vd1c5m(
        this.ref.pointer, _sel_addData_, data.ref.pointer);
  }

  /// initWithData:
  DartInputStreamAdapter initWithData_(NSData data) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithData_, data.ref.pointer);
    return DartInputStreamAdapter.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// initWithFileAtPath:
  DartInputStreamAdapter? initWithFileAtPath_(NSString path) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithFileAtPath_, path.ref.pointer);
    return _ret.address == 0
        ? null
        : DartInputStreamAdapter.castFromPointer(_ret,
            retain: false, release: true);
  }

  /// initWithURL:
  DartInputStreamAdapter? initWithURL_(NSURL url) {
    objc.checkOsVersionInternal('DOBJCDartInputStreamAdapter.initWithURL:',
        iOS: (false, (4, 0, 0)), macOS: (false, (10, 6, 0)));
    final _ret = _objc_msgSend_1sotr3r(
        this.ref.retainAndReturnPointer(), _sel_initWithURL_, url.ref.pointer);
    return _ret.address == 0
        ? null
        : DartInputStreamAdapter.castFromPointer(_ret,
            retain: false, release: true);
  }

  /// setDone
  void setDone() {
    _objc_msgSend_1pl9qdv(this.ref.pointer, _sel_setDone);
  }

  /// setError:
  void setError_(NSError error) {
    _objc_msgSend_xtuoz7(this.ref.pointer, _sel_setError_, error.ref.pointer);
  }

  /// stream:handleEvent:
  void stream_handleEvent_(NSStream aStream, NSStreamEvent eventCode) {
    if (!objc.respondsToSelector(this.ref.pointer, _sel_stream_handleEvent_)) {
      throw objc.UnimplementedOptionalMethodException(
          'DOBJCDartInputStreamAdapter', 'stream:handleEvent:');
    }
    _objc_msgSend_3l8zum(this.ref.pointer, _sel_stream_handleEvent_,
        aStream.ref.pointer, eventCode.value);
  }
}

/// Base class of all classes DOBJCDartProtocolBuilder creates.
class DartProtocol extends NSObject {
  DartProtocol._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [DartProtocol] that points to the same underlying object as [other].
  DartProtocol.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [DartProtocol] that wraps the given raw object pointer.
  DartProtocol.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [DartProtocol].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_DOBJCDartProtocol);
  }

  /// alloc
  static DartProtocol alloc() {
    final _ret = _objc_msgSend_151sglz(_class_DOBJCDartProtocol, _sel_alloc);
    return DartProtocol.castFromPointer(_ret, retain: false, release: true);
  }

  /// allocWithZone:
  static DartProtocol allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret = _objc_msgSend_1cwp428(
        _class_DOBJCDartProtocol, _sel_allocWithZone_, zone);
    return DartProtocol.castFromPointer(_ret, retain: false, release: true);
  }

  /// new
  static DartProtocol new$() {
    final _ret = _objc_msgSend_151sglz(_class_DOBJCDartProtocol, _sel_new);
    return DartProtocol.castFromPointer(_ret, retain: false, release: true);
  }

  /// autorelease
  DartProtocol autorelease() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_autorelease);
    return DartProtocol.castFromPointer(_ret, retain: true, release: true);
  }

  /// dealloc
  void dealloc() {
    _objc_msgSend_1pl9qdv(this.ref.pointer, _sel_dealloc);
  }

  /// getDOBJCDartProtocolMethodForSelector:
  objc.ObjCObjectBase getDOBJCDartProtocolMethodForSelector_(
      ffi.Pointer<objc.ObjCSelector> sel) {
    final _ret = _objc_msgSend_3ctkt6(
        this.ref.pointer, _sel_getDOBJCDartProtocolMethodForSelector_, sel);
    return objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// init
  DartProtocol init() {
    objc.checkOsVersionInternal('DOBJCDartProtocol.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return DartProtocol.castFromPointer(_ret, retain: false, release: true);
  }

  /// initDOBJCDartProtocolFromDartProtocolBuilder:withDisposePort:
  DartProtocol initDOBJCDartProtocolFromDartProtocolBuilder_withDisposePort_(
      DartProtocolBuilder builder, int port) {
    final _ret = _objc_msgSend_dbvvll(
        this.ref.retainAndReturnPointer(),
        _sel_initDOBJCDartProtocolFromDartProtocolBuilder_withDisposePort_,
        builder.ref.pointer,
        port);
    return DartProtocol.castFromPointer(_ret, retain: false, release: true);
  }

  /// retain
  DartProtocol retain() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_retain);
    return DartProtocol.castFromPointer(_ret, retain: true, release: true);
  }

  /// self
  DartProtocol self$1() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_self);
    return DartProtocol.castFromPointer(_ret, retain: true, release: true);
  }

  /// Returns a new instance of DartProtocol constructed with the default `new` method.
  factory DartProtocol() => new$();
}

/// Used by the Dart ObjCProtocolBuilder to construct ObjC classes at runtime to
/// implement protocols.
class DartProtocolBuilder extends NSObject {
  DartProtocolBuilder._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [DartProtocolBuilder] that points to the same underlying object as [other].
  DartProtocolBuilder.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [DartProtocolBuilder] that wraps the given raw object pointer.
  DartProtocolBuilder.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [DartProtocolBuilder].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_DOBJCDartProtocolBuilder);
  }

  /// alloc
  static DartProtocolBuilder alloc() {
    final _ret =
        _objc_msgSend_151sglz(_class_DOBJCDartProtocolBuilder, _sel_alloc);
    return DartProtocolBuilder.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// allocWithZone:
  static DartProtocolBuilder allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret = _objc_msgSend_1cwp428(
        _class_DOBJCDartProtocolBuilder, _sel_allocWithZone_, zone);
    return DartProtocolBuilder.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// new
  static DartProtocolBuilder new$() {
    final _ret =
        _objc_msgSend_151sglz(_class_DOBJCDartProtocolBuilder, _sel_new);
    return DartProtocolBuilder.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// addProtocol:
  void addProtocol_(Protocol protocol) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_addProtocol_, protocol.ref.pointer);
  }

  /// autorelease
  DartProtocolBuilder autorelease() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_autorelease);
    return DartProtocolBuilder.castFromPointer(_ret,
        retain: true, release: true);
  }

  /// buildInstance:
  DartProtocol buildInstance_(int port) {
    final _ret =
        _objc_msgSend_1ya1kjn(this.ref.pointer, _sel_buildInstance_, port);
    return DartProtocol.castFromPointer(_ret, retain: true, release: true);
  }

  /// implementMethod:withBlock:withTrampoline:withSignature:
  void implementMethod_withBlock_withTrampoline_withSignature_(
      ffi.Pointer<objc.ObjCSelector> sel,
      ffi.Pointer<ffi.Void> block,
      ffi.Pointer<ffi.Void> trampoline,
      ffi.Pointer<ffi.Char> signature) {
    _objc_msgSend_1s2gdyk(
        this.ref.pointer,
        _sel_implementMethod_withBlock_withTrampoline_withSignature_,
        sel,
        block,
        trampoline,
        signature);
  }

  /// init
  DartProtocolBuilder init() {
    objc.checkOsVersionInternal('DOBJCDartProtocolBuilder.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return DartProtocolBuilder.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// initWithClassName:
  DartProtocolBuilder initWithClassName_(ffi.Pointer<ffi.Char> name) {
    final _ret = _objc_msgSend_56zxyn(
        this.ref.retainAndReturnPointer(), _sel_initWithClassName_, name);
    return DartProtocolBuilder.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// registerClass
  void registerClass() {
    _objc_msgSend_1pl9qdv(this.ref.pointer, _sel_registerClass);
  }

  /// retain
  DartProtocolBuilder retain() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_retain);
    return DartProtocolBuilder.castFromPointer(_ret,
        retain: true, release: true);
  }

  /// self
  DartProtocolBuilder self$1() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_self);
    return DartProtocolBuilder.castFromPointer(_ret,
        retain: true, release: true);
  }

  /// Returns a new instance of DartProtocolBuilder constructed with the default `new` method.
  factory DartProtocolBuilder() => new$();
}

/// NSArray
class NSArray extends NSObject
    implements NSCopying, NSMutableCopying, NSSecureCoding, NSFastEnumeration {
  NSArray._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSArray] that points to the same underlying object as [other].
  NSArray.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSArray] that wraps the given raw object pointer.
  NSArray.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSArray].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSArray);
  }

  /// alloc
  static NSArray alloc() {
    final _ret = _objc_msgSend_151sglz(_class_NSArray, _sel_alloc);
    return NSArray.castFromPointer(_ret, retain: false, release: true);
  }

  /// allocWithZone:
  static NSArray allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret =
        _objc_msgSend_1cwp428(_class_NSArray, _sel_allocWithZone_, zone);
    return NSArray.castFromPointer(_ret, retain: false, release: true);
  }

  /// array
  static NSArray array() {
    final _ret = _objc_msgSend_151sglz(_class_NSArray, _sel_array);
    return NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// arrayWithArray:
  static NSArray arrayWithArray_(NSArray array) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSArray, _sel_arrayWithArray_, array.ref.pointer);
    return NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// arrayWithObject:
  static NSArray arrayWithObject_(objc.ObjCObjectBase anObject) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSArray, _sel_arrayWithObject_, anObject.ref.pointer);
    return NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// arrayWithObjects:
  static NSArray arrayWithObjects_(objc.ObjCObjectBase firstObj) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSArray, _sel_arrayWithObjects_, firstObj.ref.pointer);
    return NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// arrayWithObjects:count:
  static NSArray arrayWithObjects_count_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects, int cnt) {
    final _ret = _objc_msgSend_zmbtbd(
        _class_NSArray, _sel_arrayWithObjects_count_, objects, cnt);
    return NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// new
  static NSArray new$() {
    final _ret = _objc_msgSend_151sglz(_class_NSArray, _sel_new);
    return NSArray.castFromPointer(_ret, retain: false, release: true);
  }

  /// supportsSecureCoding
  static bool getSupportsSecureCoding() {
    return _objc_msgSend_91o635(_class_NSArray, _sel_supportsSecureCoding);
  }

  /// count
  int get count {
    return _objc_msgSend_xw2lbc(this.ref.pointer, _sel_count);
  }

  /// countByEnumeratingWithState:objects:count:
  int countByEnumeratingWithState_objects_count_(
      ffi.Pointer<NSFastEnumerationState> state,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> buffer,
      int len) {
    return _objc_msgSend_1b5ysjl(this.ref.pointer,
        _sel_countByEnumeratingWithState_objects_count_, state, buffer, len);
  }

  /// encodeWithCoder:
  void encodeWithCoder_(NSCoder coder) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_encodeWithCoder_, coder.ref.pointer);
  }

  /// init
  NSArray init() {
    objc.checkOsVersionInternal('NSArray.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSArray.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithArray:
  NSArray initWithArray_(NSArray array) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithArray_, array.ref.pointer);
    return NSArray.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithArray:copyItems:
  NSArray initWithArray_copyItems_(NSArray array, bool flag) {
    final _ret = _objc_msgSend_17amj0z(this.ref.retainAndReturnPointer(),
        _sel_initWithArray_copyItems_, array.ref.pointer, flag);
    return NSArray.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithCoder:
  NSArray? initWithCoder_(NSCoder coder) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithCoder_, coder.ref.pointer);
    return _ret.address == 0
        ? null
        : NSArray.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithObjects:
  NSArray initWithObjects_(objc.ObjCObjectBase firstObj) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithObjects_, firstObj.ref.pointer);
    return NSArray.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithObjects:count:
  NSArray initWithObjects_count_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects, int cnt) {
    final _ret = _objc_msgSend_zmbtbd(this.ref.retainAndReturnPointer(),
        _sel_initWithObjects_count_, objects, cnt);
    return NSArray.castFromPointer(_ret, retain: false, release: true);
  }

  /// objectAtIndex:
  objc.ObjCObjectBase objectAtIndex_(int index) {
    final _ret =
        _objc_msgSend_14hpxwa(this.ref.pointer, _sel_objectAtIndex_, index);
    return objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// Returns a new instance of NSArray constructed with the default `new` method.
  factory NSArray() => new$();
}

enum NSBinarySearchingOptions {
  NSBinarySearchingFirstEqual(256),
  NSBinarySearchingLastEqual(512),
  NSBinarySearchingInsertionIndex(1024);

  final int value;
  const NSBinarySearchingOptions(this.value);

  static NSBinarySearchingOptions fromValue(int value) => switch (value) {
        256 => NSBinarySearchingFirstEqual,
        512 => NSBinarySearchingLastEqual,
        1024 => NSBinarySearchingInsertionIndex,
        _ => throw ArgumentError(
            'Unknown value for NSBinarySearchingOptions: $value'),
      };
}

/// NSCharacterSet
class NSCharacterSet extends NSObject
    implements NSCopying, NSMutableCopying, NSSecureCoding {
  NSCharacterSet._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSCharacterSet] that points to the same underlying object as [other].
  NSCharacterSet.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSCharacterSet] that wraps the given raw object pointer.
  NSCharacterSet.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSCharacterSet].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSCharacterSet);
  }

  /// alloc
  static NSCharacterSet alloc() {
    final _ret = _objc_msgSend_151sglz(_class_NSCharacterSet, _sel_alloc);
    return NSCharacterSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// allocWithZone:
  static NSCharacterSet allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret =
        _objc_msgSend_1cwp428(_class_NSCharacterSet, _sel_allocWithZone_, zone);
    return NSCharacterSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// alphanumericCharacterSet
  static NSCharacterSet getAlphanumericCharacterSet() {
    final _ret = _objc_msgSend_151sglz(
        _class_NSCharacterSet, _sel_alphanumericCharacterSet);
    return NSCharacterSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// capitalizedLetterCharacterSet
  static NSCharacterSet getCapitalizedLetterCharacterSet() {
    final _ret = _objc_msgSend_151sglz(
        _class_NSCharacterSet, _sel_capitalizedLetterCharacterSet);
    return NSCharacterSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// characterSetWithBitmapRepresentation:
  static NSCharacterSet characterSetWithBitmapRepresentation_(NSData data) {
    final _ret = _objc_msgSend_1sotr3r(_class_NSCharacterSet,
        _sel_characterSetWithBitmapRepresentation_, data.ref.pointer);
    return NSCharacterSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// characterSetWithCharactersInString:
  static NSCharacterSet characterSetWithCharactersInString_(NSString aString) {
    final _ret = _objc_msgSend_1sotr3r(_class_NSCharacterSet,
        _sel_characterSetWithCharactersInString_, aString.ref.pointer);
    return NSCharacterSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// characterSetWithContentsOfFile:
  static NSCharacterSet? characterSetWithContentsOfFile_(NSString fName) {
    final _ret = _objc_msgSend_1sotr3r(_class_NSCharacterSet,
        _sel_characterSetWithContentsOfFile_, fName.ref.pointer);
    return _ret.address == 0
        ? null
        : NSCharacterSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// characterSetWithRange:
  static NSCharacterSet characterSetWithRange_(NSRange aRange) {
    final _ret = _objc_msgSend_1k1o1s7(
        _class_NSCharacterSet, _sel_characterSetWithRange_, aRange);
    return NSCharacterSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// controlCharacterSet
  static NSCharacterSet getControlCharacterSet() {
    final _ret =
        _objc_msgSend_151sglz(_class_NSCharacterSet, _sel_controlCharacterSet);
    return NSCharacterSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// decimalDigitCharacterSet
  static NSCharacterSet getDecimalDigitCharacterSet() {
    final _ret = _objc_msgSend_151sglz(
        _class_NSCharacterSet, _sel_decimalDigitCharacterSet);
    return NSCharacterSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// decomposableCharacterSet
  static NSCharacterSet getDecomposableCharacterSet() {
    final _ret = _objc_msgSend_151sglz(
        _class_NSCharacterSet, _sel_decomposableCharacterSet);
    return NSCharacterSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// illegalCharacterSet
  static NSCharacterSet getIllegalCharacterSet() {
    final _ret =
        _objc_msgSend_151sglz(_class_NSCharacterSet, _sel_illegalCharacterSet);
    return NSCharacterSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// letterCharacterSet
  static NSCharacterSet getLetterCharacterSet() {
    final _ret =
        _objc_msgSend_151sglz(_class_NSCharacterSet, _sel_letterCharacterSet);
    return NSCharacterSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// lowercaseLetterCharacterSet
  static NSCharacterSet getLowercaseLetterCharacterSet() {
    final _ret = _objc_msgSend_151sglz(
        _class_NSCharacterSet, _sel_lowercaseLetterCharacterSet);
    return NSCharacterSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// new
  static NSCharacterSet new$() {
    final _ret = _objc_msgSend_151sglz(_class_NSCharacterSet, _sel_new);
    return NSCharacterSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// newlineCharacterSet
  static NSCharacterSet getNewlineCharacterSet() {
    objc.checkOsVersionInternal('NSCharacterSet.newlineCharacterSet',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 5, 0)));
    final _ret =
        _objc_msgSend_151sglz(_class_NSCharacterSet, _sel_newlineCharacterSet);
    return NSCharacterSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// nonBaseCharacterSet
  static NSCharacterSet getNonBaseCharacterSet() {
    final _ret =
        _objc_msgSend_151sglz(_class_NSCharacterSet, _sel_nonBaseCharacterSet);
    return NSCharacterSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// punctuationCharacterSet
  static NSCharacterSet getPunctuationCharacterSet() {
    final _ret = _objc_msgSend_151sglz(
        _class_NSCharacterSet, _sel_punctuationCharacterSet);
    return NSCharacterSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// supportsSecureCoding
  static bool getSupportsSecureCoding() {
    return _objc_msgSend_91o635(
        _class_NSCharacterSet, _sel_supportsSecureCoding);
  }

  /// symbolCharacterSet
  static NSCharacterSet getSymbolCharacterSet() {
    final _ret =
        _objc_msgSend_151sglz(_class_NSCharacterSet, _sel_symbolCharacterSet);
    return NSCharacterSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// uppercaseLetterCharacterSet
  static NSCharacterSet getUppercaseLetterCharacterSet() {
    final _ret = _objc_msgSend_151sglz(
        _class_NSCharacterSet, _sel_uppercaseLetterCharacterSet);
    return NSCharacterSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// whitespaceAndNewlineCharacterSet
  static NSCharacterSet getWhitespaceAndNewlineCharacterSet() {
    final _ret = _objc_msgSend_151sglz(
        _class_NSCharacterSet, _sel_whitespaceAndNewlineCharacterSet);
    return NSCharacterSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// whitespaceCharacterSet
  static NSCharacterSet getWhitespaceCharacterSet() {
    final _ret = _objc_msgSend_151sglz(
        _class_NSCharacterSet, _sel_whitespaceCharacterSet);
    return NSCharacterSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// autorelease
  NSCharacterSet autorelease() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_autorelease);
    return NSCharacterSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// bitmapRepresentation
  NSData get bitmapRepresentation {
    final _ret =
        _objc_msgSend_151sglz(this.ref.pointer, _sel_bitmapRepresentation);
    return NSData.castFromPointer(_ret, retain: true, release: true);
  }

  /// characterIsMember:
  bool characterIsMember_(int aCharacter) {
    return _objc_msgSend_1co9mn4(
        this.ref.pointer, _sel_characterIsMember_, aCharacter);
  }

  /// encodeWithCoder:
  void encodeWithCoder_(NSCoder coder) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_encodeWithCoder_, coder.ref.pointer);
  }

  /// hasMemberInPlane:
  bool hasMemberInPlane_(int thePlane) {
    return _objc_msgSend_gerswc(
        this.ref.pointer, _sel_hasMemberInPlane_, thePlane);
  }

  /// init
  NSCharacterSet init() {
    objc.checkOsVersionInternal('NSCharacterSet.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSCharacterSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithCoder:
  NSCharacterSet? initWithCoder_(NSCoder coder) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithCoder_, coder.ref.pointer);
    return _ret.address == 0
        ? null
        : NSCharacterSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// invertedSet
  NSCharacterSet get invertedSet {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_invertedSet);
    return NSCharacterSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// isSupersetOfSet:
  bool isSupersetOfSet_(NSCharacterSet theOtherSet) {
    return _objc_msgSend_19nvye5(
        this.ref.pointer, _sel_isSupersetOfSet_, theOtherSet.ref.pointer);
  }

  /// longCharacterIsMember:
  bool longCharacterIsMember_(int theLongChar) {
    return _objc_msgSend_jsclrq(
        this.ref.pointer, _sel_longCharacterIsMember_, theLongChar);
  }

  /// retain
  NSCharacterSet retain() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_retain);
    return NSCharacterSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// self
  NSCharacterSet self$1() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_self);
    return NSCharacterSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// Returns a new instance of NSCharacterSet constructed with the default `new` method.
  factory NSCharacterSet() => new$();
}

/// NSCoder
class NSCoder extends objc.ObjCObjectBase {
  NSCoder._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super(pointer, retain: retain, release: release);

  /// Constructs a [NSCoder] that points to the same underlying object as [other].
  NSCoder.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSCoder] that wraps the given raw object pointer.
  NSCoder.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSCoder].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSCoder);
  }
}

/// NSCoding
interface class NSCoding extends objc.ObjCProtocolBase {
  NSCoding._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super(pointer, retain: retain, release: release);

  /// Constructs a [NSCoding] that points to the same underlying object as [other].
  NSCoding.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSCoding] that wraps the given raw object pointer.
  NSCoding.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSCoding].
  static bool conformsTo(objc.ObjCObjectBase obj) {
    return _objc_msgSend_e3qsqz(
        obj.ref.pointer, _sel_conformsToProtocol_, _protocol_NSCoding);
  }

  /// Returns the [objc.Protocol] object for this protocol.
  static objc.Protocol get $protocol =>
      objc.Protocol.castFromPointer(_protocol_NSCoding.cast());

  /// Builds an object that implements the NSCoding protocol. To implement
  /// multiple protocols, use [addToBuilder] or [objc.ObjCProtocolBuilder] directly.
  ///
  /// If `$keepIsolateAlive` is true, this protocol will keep this isolate
  /// alive until it is garbage collected by both Dart and ObjC.
  static NSCoding implement(
      {required void Function(NSCoder) encodeWithCoder_,
      required Dartinstancetype? Function(NSCoder) initWithCoder_,
      bool $keepIsolateAlive = true}) {
    final builder = objc.ObjCProtocolBuilder(debugName: 'NSCoding');
    NSCoding.encodeWithCoder_.implement(builder, encodeWithCoder_);
    NSCoding.initWithCoder_.implement(builder, initWithCoder_);
    builder.addProtocol($protocol);
    return NSCoding.castFrom(
        builder.build(keepIsolateAlive: $keepIsolateAlive));
  }

  /// Adds the implementation of the NSCoding protocol to an existing
  /// [objc.ObjCProtocolBuilder].
  ///
  /// Note: You cannot call this method after you have called `builder.build`.
  static void addToBuilder(objc.ObjCProtocolBuilder builder,
      {required void Function(NSCoder) encodeWithCoder_,
      required Dartinstancetype? Function(NSCoder) initWithCoder_,
      bool $keepIsolateAlive = true}) {
    NSCoding.encodeWithCoder_.implement(builder, encodeWithCoder_);
    NSCoding.initWithCoder_.implement(builder, initWithCoder_);
    builder.addProtocol($protocol);
  }

  /// Builds an object that implements the NSCoding protocol. To implement
  /// multiple protocols, use [addToBuilder] or [objc.ObjCProtocolBuilder] directly. All
  /// methods that can be implemented as listeners will be.
  ///
  /// If `$keepIsolateAlive` is true, this protocol will keep this isolate
  /// alive until it is garbage collected by both Dart and ObjC.
  static NSCoding implementAsListener(
      {required void Function(NSCoder) encodeWithCoder_,
      required Dartinstancetype? Function(NSCoder) initWithCoder_,
      bool $keepIsolateAlive = true}) {
    final builder = objc.ObjCProtocolBuilder(debugName: 'NSCoding');
    NSCoding.encodeWithCoder_.implementAsListener(builder, encodeWithCoder_);
    NSCoding.initWithCoder_.implement(builder, initWithCoder_);
    builder.addProtocol($protocol);
    return NSCoding.castFrom(
        builder.build(keepIsolateAlive: $keepIsolateAlive));
  }

  /// Adds the implementation of the NSCoding protocol to an existing
  /// [objc.ObjCProtocolBuilder]. All methods that can be implemented as listeners will
  /// be.
  ///
  /// Note: You cannot call this method after you have called `builder.build`.
  static void addToBuilderAsListener(objc.ObjCProtocolBuilder builder,
      {required void Function(NSCoder) encodeWithCoder_,
      required Dartinstancetype? Function(NSCoder) initWithCoder_,
      bool $keepIsolateAlive = true}) {
    NSCoding.encodeWithCoder_.implementAsListener(builder, encodeWithCoder_);
    NSCoding.initWithCoder_.implement(builder, initWithCoder_);
    builder.addProtocol($protocol);
  }

  /// Builds an object that implements the NSCoding protocol. To implement
  /// multiple protocols, use [addToBuilder] or [objc.ObjCProtocolBuilder] directly. All
  /// methods that can be implemented as blocking listeners will be.
  ///
  /// If `$keepIsolateAlive` is true, this protocol will keep this isolate
  /// alive until it is garbage collected by both Dart and ObjC.
  static NSCoding implementAsBlocking(
      {required void Function(NSCoder) encodeWithCoder_,
      required Dartinstancetype? Function(NSCoder) initWithCoder_,
      bool $keepIsolateAlive = true}) {
    final builder = objc.ObjCProtocolBuilder(debugName: 'NSCoding');
    NSCoding.encodeWithCoder_.implementAsBlocking(builder, encodeWithCoder_);
    NSCoding.initWithCoder_.implement(builder, initWithCoder_);
    builder.addProtocol($protocol);
    return NSCoding.castFrom(
        builder.build(keepIsolateAlive: $keepIsolateAlive));
  }

  /// Adds the implementation of the NSCoding protocol to an existing
  /// [objc.ObjCProtocolBuilder]. All methods that can be implemented as blocking
  /// listeners will be.
  ///
  /// Note: You cannot call this method after you have called `builder.build`.
  static void addToBuilderAsBlocking(objc.ObjCProtocolBuilder builder,
      {required void Function(NSCoder) encodeWithCoder_,
      required Dartinstancetype? Function(NSCoder) initWithCoder_,
      bool $keepIsolateAlive = true}) {
    NSCoding.encodeWithCoder_.implementAsBlocking(builder, encodeWithCoder_);
    NSCoding.initWithCoder_.implement(builder, initWithCoder_);
    builder.addProtocol($protocol);
  }

  /// encodeWithCoder:
  static final encodeWithCoder_ =
      objc.ObjCProtocolListenableMethod<void Function(NSCoder)>(
    _protocol_NSCoding,
    _sel_encodeWithCoder_,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                        ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>>(
            _ObjectiveCBindings_protocolTrampoline_18v1jvf)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSCoding,
      _sel_encodeWithCoder_,
      isRequired: true,
      isInstanceMethod: true,
    ),
    (void Function(NSCoder) func) =>
        ObjCBlock_ffiVoid_ffiVoid_NSCoder.fromFunction(
            (ffi.Pointer<ffi.Void> _, NSCoder arg1) => func(arg1)),
    (void Function(NSCoder) func) => ObjCBlock_ffiVoid_ffiVoid_NSCoder.listener(
        (ffi.Pointer<ffi.Void> _, NSCoder arg1) => func(arg1)),
    (void Function(NSCoder) func) => ObjCBlock_ffiVoid_ffiVoid_NSCoder.blocking(
        (ffi.Pointer<ffi.Void> _, NSCoder arg1) => func(arg1)),
  );

  /// initWithCoder:
  static final initWithCoder_ =
      objc.ObjCProtocolMethod<Dartinstancetype? Function(NSCoder)>(
    _protocol_NSCoding,
    _sel_initWithCoder_,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    instancetype Function(ffi.Pointer<objc.ObjCObject>,
                        ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>>(
            _ObjectiveCBindings_protocolTrampoline_xr62hr)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSCoding,
      _sel_initWithCoder_,
      isRequired: true,
      isInstanceMethod: true,
    ),
    (Dartinstancetype? Function(NSCoder) func) =>
        ObjCBlock_instancetype_ffiVoid_NSCoder.fromFunction(
            (ffi.Pointer<ffi.Void> _, NSCoder arg1) => func(arg1)),
  );
}

enum NSComparisonResult {
  NSOrderedAscending(-1),
  NSOrderedSame(0),
  NSOrderedDescending(1);

  final int value;
  const NSComparisonResult(this.value);

  static NSComparisonResult fromValue(int value) => switch (value) {
        -1 => NSOrderedAscending,
        0 => NSOrderedSame,
        1 => NSOrderedDescending,
        _ =>
          throw ArgumentError('Unknown value for NSComparisonResult: $value'),
      };
}

/// NSCopying
interface class NSCopying extends objc.ObjCProtocolBase {
  NSCopying._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super(pointer, retain: retain, release: release);

  /// Constructs a [NSCopying] that points to the same underlying object as [other].
  NSCopying.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSCopying] that wraps the given raw object pointer.
  NSCopying.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSCopying].
  static bool conformsTo(objc.ObjCObjectBase obj) {
    return _objc_msgSend_e3qsqz(
        obj.ref.pointer, _sel_conformsToProtocol_, _protocol_NSCopying);
  }

  /// Returns the [objc.Protocol] object for this protocol.
  static objc.Protocol get $protocol =>
      objc.Protocol.castFromPointer(_protocol_NSCopying.cast());

  /// Builds an object that implements the NSCopying protocol. To implement
  /// multiple protocols, use [addToBuilder] or [objc.ObjCProtocolBuilder] directly.
  ///
  /// If `$keepIsolateAlive` is true, this protocol will keep this isolate
  /// alive until it is garbage collected by both Dart and ObjC.
  static NSCopying implement(
      {required objc.ObjCObjectBase Function(ffi.Pointer<NSZone>) copyWithZone_,
      bool $keepIsolateAlive = true}) {
    final builder = objc.ObjCProtocolBuilder(debugName: 'NSCopying');
    NSCopying.copyWithZone_.implement(builder, copyWithZone_);
    builder.addProtocol($protocol);
    return NSCopying.castFrom(
        builder.build(keepIsolateAlive: $keepIsolateAlive));
  }

  /// Adds the implementation of the NSCopying protocol to an existing
  /// [objc.ObjCProtocolBuilder].
  ///
  /// Note: You cannot call this method after you have called `builder.build`.
  static void addToBuilder(objc.ObjCProtocolBuilder builder,
      {required objc.ObjCObjectBase Function(ffi.Pointer<NSZone>) copyWithZone_,
      bool $keepIsolateAlive = true}) {
    NSCopying.copyWithZone_.implement(builder, copyWithZone_);
    builder.addProtocol($protocol);
  }

  /// copyWithZone:
  static final copyWithZone_ = objc.ObjCProtocolMethod<
      objc.ObjCObjectBase Function(ffi.Pointer<NSZone>)>(
    _protocol_NSCopying,
    _sel_copyWithZone_,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.Pointer<objc.ObjCObject> Function(
                        ffi.Pointer<objc.ObjCObject>,
                        ffi.Pointer<ffi.Void>,
                        ffi.Pointer<NSZone>)>>(
            _ObjectiveCBindings_protocolTrampoline_18nsem0)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSCopying,
      _sel_copyWithZone_,
      isRequired: true,
      isInstanceMethod: true,
    ),
    (objc.ObjCObjectBase Function(ffi.Pointer<NSZone>) func) =>
        ObjCBlock_objcObjCObject_ffiVoid_NSZone.fromFunction(
            (ffi.Pointer<ffi.Void> _, ffi.Pointer<NSZone> arg1) => func(arg1)),
  );
}

/// NSData
class NSData extends NSObject
    implements NSCopying, NSMutableCopying, NSSecureCoding {
  NSData._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSData] that points to the same underlying object as [other].
  NSData.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSData] that wraps the given raw object pointer.
  NSData.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSData].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSData);
  }

  /// alloc
  static NSData alloc() {
    final _ret = _objc_msgSend_151sglz(_class_NSData, _sel_alloc);
    return NSData.castFromPointer(_ret, retain: false, release: true);
  }

  /// allocWithZone:
  static NSData allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret =
        _objc_msgSend_1cwp428(_class_NSData, _sel_allocWithZone_, zone);
    return NSData.castFromPointer(_ret, retain: false, release: true);
  }

  /// data
  static NSData data() {
    final _ret = _objc_msgSend_151sglz(_class_NSData, _sel_data);
    return NSData.castFromPointer(_ret, retain: true, release: true);
  }

  /// dataWithBytes:length:
  static NSData dataWithBytes_length_(ffi.Pointer<ffi.Void> bytes, int length) {
    final _ret = _objc_msgSend_3nbx5e(
        _class_NSData, _sel_dataWithBytes_length_, bytes, length);
    return NSData.castFromPointer(_ret, retain: true, release: true);
  }

  /// dataWithBytesNoCopy:length:
  static NSData dataWithBytesNoCopy_length_(
      ffi.Pointer<ffi.Void> bytes, int length) {
    final _ret = _objc_msgSend_3nbx5e(
        _class_NSData, _sel_dataWithBytesNoCopy_length_, bytes, length);
    return NSData.castFromPointer(_ret, retain: true, release: true);
  }

  /// dataWithBytesNoCopy:length:freeWhenDone:
  static NSData dataWithBytesNoCopy_length_freeWhenDone_(
      ffi.Pointer<ffi.Void> bytes, int length, bool b) {
    final _ret = _objc_msgSend_161ne8y(_class_NSData,
        _sel_dataWithBytesNoCopy_length_freeWhenDone_, bytes, length, b);
    return NSData.castFromPointer(_ret, retain: true, release: true);
  }

  /// dataWithContentsOfFile:
  static NSData? dataWithContentsOfFile_(NSString path) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSData, _sel_dataWithContentsOfFile_, path.ref.pointer);
    return _ret.address == 0
        ? null
        : NSData.castFromPointer(_ret, retain: true, release: true);
  }

  /// dataWithContentsOfFile:options:error:
  static NSData? dataWithContentsOfFile_options_error_(
      NSString path,
      NSDataReadingOptions readOptionsMask,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> errorPtr) {
    final _ret = _objc_msgSend_8321cp(
        _class_NSData,
        _sel_dataWithContentsOfFile_options_error_,
        path.ref.pointer,
        readOptionsMask.value,
        errorPtr);
    return _ret.address == 0
        ? null
        : NSData.castFromPointer(_ret, retain: true, release: true);
  }

  /// dataWithContentsOfURL:
  static NSData? dataWithContentsOfURL_(NSURL url) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSData, _sel_dataWithContentsOfURL_, url.ref.pointer);
    return _ret.address == 0
        ? null
        : NSData.castFromPointer(_ret, retain: true, release: true);
  }

  /// dataWithContentsOfURL:options:error:
  static NSData? dataWithContentsOfURL_options_error_(
      NSURL url,
      NSDataReadingOptions readOptionsMask,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> errorPtr) {
    final _ret = _objc_msgSend_8321cp(
        _class_NSData,
        _sel_dataWithContentsOfURL_options_error_,
        url.ref.pointer,
        readOptionsMask.value,
        errorPtr);
    return _ret.address == 0
        ? null
        : NSData.castFromPointer(_ret, retain: true, release: true);
  }

  /// dataWithData:
  static NSData dataWithData_(NSData data) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSData, _sel_dataWithData_, data.ref.pointer);
    return NSData.castFromPointer(_ret, retain: true, release: true);
  }

  /// new
  static NSData new$() {
    final _ret = _objc_msgSend_151sglz(_class_NSData, _sel_new);
    return NSData.castFromPointer(_ret, retain: false, release: true);
  }

  /// supportsSecureCoding
  static bool getSupportsSecureCoding() {
    return _objc_msgSend_91o635(_class_NSData, _sel_supportsSecureCoding);
  }

  /// bytes
  ffi.Pointer<ffi.Void> get bytes {
    return _objc_msgSend_6ex6p5(this.ref.pointer, _sel_bytes);
  }

  /// compressedDataUsingAlgorithm:error:
  ///
  /// iOS: introduced 13.0.0
  /// macOS: introduced 10.15.0
  NSData? compressedDataUsingAlgorithm_error_(
      NSDataCompressionAlgorithm algorithm,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    objc.checkOsVersionInternal('NSData.compressedDataUsingAlgorithm:error:',
        iOS: (false, (13, 0, 0)), macOS: (false, (10, 15, 0)));
    final _ret = _objc_msgSend_1vnlaqg(this.ref.pointer,
        _sel_compressedDataUsingAlgorithm_error_, algorithm.value, error);
    return _ret.address == 0
        ? null
        : NSData.castFromPointer(_ret, retain: true, release: true);
  }

  /// decompressedDataUsingAlgorithm:error:
  ///
  /// iOS: introduced 13.0.0
  /// macOS: introduced 10.15.0
  NSData? decompressedDataUsingAlgorithm_error_(
      NSDataCompressionAlgorithm algorithm,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    objc.checkOsVersionInternal('NSData.decompressedDataUsingAlgorithm:error:',
        iOS: (false, (13, 0, 0)), macOS: (false, (10, 15, 0)));
    final _ret = _objc_msgSend_1vnlaqg(this.ref.pointer,
        _sel_decompressedDataUsingAlgorithm_error_, algorithm.value, error);
    return _ret.address == 0
        ? null
        : NSData.castFromPointer(_ret, retain: true, release: true);
  }

  /// encodeWithCoder:
  void encodeWithCoder_(NSCoder coder) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_encodeWithCoder_, coder.ref.pointer);
  }

  /// init
  NSData init() {
    objc.checkOsVersionInternal('NSData.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSData.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithBase64EncodedData:options:
  NSData? initWithBase64EncodedData_options_(
      NSData base64Data, NSDataBase64DecodingOptions options) {
    objc.checkOsVersionInternal('NSData.initWithBase64EncodedData:options:',
        iOS: (false, (7, 0, 0)), macOS: (false, (10, 9, 0)));
    final _ret = _objc_msgSend_7kpg7m(
        this.ref.retainAndReturnPointer(),
        _sel_initWithBase64EncodedData_options_,
        base64Data.ref.pointer,
        options.value);
    return _ret.address == 0
        ? null
        : NSData.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithBase64EncodedString:options:
  NSData? initWithBase64EncodedString_options_(
      NSString base64String, NSDataBase64DecodingOptions options) {
    objc.checkOsVersionInternal('NSData.initWithBase64EncodedString:options:',
        iOS: (false, (7, 0, 0)), macOS: (false, (10, 9, 0)));
    final _ret = _objc_msgSend_7kpg7m(
        this.ref.retainAndReturnPointer(),
        _sel_initWithBase64EncodedString_options_,
        base64String.ref.pointer,
        options.value);
    return _ret.address == 0
        ? null
        : NSData.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithBytes:length:
  NSData initWithBytes_length_(ffi.Pointer<ffi.Void> bytes, int length) {
    final _ret = _objc_msgSend_3nbx5e(this.ref.retainAndReturnPointer(),
        _sel_initWithBytes_length_, bytes, length);
    return NSData.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithBytesNoCopy:length:
  NSData initWithBytesNoCopy_length_(ffi.Pointer<ffi.Void> bytes, int length) {
    final _ret = _objc_msgSend_3nbx5e(this.ref.retainAndReturnPointer(),
        _sel_initWithBytesNoCopy_length_, bytes, length);
    return NSData.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithBytesNoCopy:length:freeWhenDone:
  NSData initWithBytesNoCopy_length_freeWhenDone_(
      ffi.Pointer<ffi.Void> bytes, int length, bool b) {
    final _ret = _objc_msgSend_161ne8y(this.ref.retainAndReturnPointer(),
        _sel_initWithBytesNoCopy_length_freeWhenDone_, bytes, length, b);
    return NSData.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithCoder:
  NSData? initWithCoder_(NSCoder coder) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithCoder_, coder.ref.pointer);
    return _ret.address == 0
        ? null
        : NSData.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithContentsOfFile:
  NSData? initWithContentsOfFile_(NSString path) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithContentsOfFile_, path.ref.pointer);
    return _ret.address == 0
        ? null
        : NSData.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithContentsOfFile:options:error:
  NSData? initWithContentsOfFile_options_error_(
      NSString path,
      NSDataReadingOptions readOptionsMask,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> errorPtr) {
    final _ret = _objc_msgSend_8321cp(
        this.ref.retainAndReturnPointer(),
        _sel_initWithContentsOfFile_options_error_,
        path.ref.pointer,
        readOptionsMask.value,
        errorPtr);
    return _ret.address == 0
        ? null
        : NSData.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithContentsOfURL:
  NSData? initWithContentsOfURL_(NSURL url) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithContentsOfURL_, url.ref.pointer);
    return _ret.address == 0
        ? null
        : NSData.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithContentsOfURL:options:error:
  NSData? initWithContentsOfURL_options_error_(
      NSURL url,
      NSDataReadingOptions readOptionsMask,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> errorPtr) {
    final _ret = _objc_msgSend_8321cp(
        this.ref.retainAndReturnPointer(),
        _sel_initWithContentsOfURL_options_error_,
        url.ref.pointer,
        readOptionsMask.value,
        errorPtr);
    return _ret.address == 0
        ? null
        : NSData.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithData:
  NSData initWithData_(NSData data) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithData_, data.ref.pointer);
    return NSData.castFromPointer(_ret, retain: false, release: true);
  }

  /// length
  int get length {
    return _objc_msgSend_xw2lbc(this.ref.pointer, _sel_length);
  }

  /// Returns a new instance of NSData constructed with the default `new` method.
  factory NSData() => new$();
}

enum NSDataBase64DecodingOptions {
  NSDataBase64DecodingIgnoreUnknownCharacters(1);

  final int value;
  const NSDataBase64DecodingOptions(this.value);

  static NSDataBase64DecodingOptions fromValue(int value) => switch (value) {
        1 => NSDataBase64DecodingIgnoreUnknownCharacters,
        _ => throw ArgumentError(
            'Unknown value for NSDataBase64DecodingOptions: $value'),
      };
}

enum NSDataBase64EncodingOptions {
  NSDataBase64Encoding64CharacterLineLength(1),
  NSDataBase64Encoding76CharacterLineLength(2),
  NSDataBase64EncodingEndLineWithCarriageReturn(16),
  NSDataBase64EncodingEndLineWithLineFeed(32);

  final int value;
  const NSDataBase64EncodingOptions(this.value);

  static NSDataBase64EncodingOptions fromValue(int value) => switch (value) {
        1 => NSDataBase64Encoding64CharacterLineLength,
        2 => NSDataBase64Encoding76CharacterLineLength,
        16 => NSDataBase64EncodingEndLineWithCarriageReturn,
        32 => NSDataBase64EncodingEndLineWithLineFeed,
        _ => throw ArgumentError(
            'Unknown value for NSDataBase64EncodingOptions: $value'),
      };
}

/// iOS: introduced 13.0.0
/// macOS: introduced 10.15.0
enum NSDataCompressionAlgorithm {
  NSDataCompressionAlgorithmLZFSE(0),
  NSDataCompressionAlgorithmLZ4(1),
  NSDataCompressionAlgorithmLZMA(2),
  NSDataCompressionAlgorithmZlib(3);

  final int value;
  const NSDataCompressionAlgorithm(this.value);

  static NSDataCompressionAlgorithm fromValue(int value) => switch (value) {
        0 => NSDataCompressionAlgorithmLZFSE,
        1 => NSDataCompressionAlgorithmLZ4,
        2 => NSDataCompressionAlgorithmLZMA,
        3 => NSDataCompressionAlgorithmZlib,
        _ => throw ArgumentError(
            'Unknown value for NSDataCompressionAlgorithm: $value'),
      };
}

/// NSDataCreation
extension NSDataCreation on NSData {}

enum NSDataReadingOptions {
  NSDataReadingMappedIfSafe(1),
  NSDataReadingUncached(2),
  NSDataReadingMappedAlways(8);

  static const NSDataReadingMapped = NSDataReadingMappedIfSafe;
  static const NSMappedRead = NSDataReadingMappedIfSafe;
  static const NSUncachedRead = NSDataReadingUncached;

  final int value;
  const NSDataReadingOptions(this.value);

  static NSDataReadingOptions fromValue(int value) => switch (value) {
        1 => NSDataReadingMappedIfSafe,
        2 => NSDataReadingUncached,
        8 => NSDataReadingMappedAlways,
        _ =>
          throw ArgumentError('Unknown value for NSDataReadingOptions: $value'),
      };

  @override
  String toString() {
    if (this == NSDataReadingMappedIfSafe)
      return "NSDataReadingOptions.NSDataReadingMappedIfSafe, NSDataReadingOptions.NSDataReadingMapped, NSDataReadingOptions.NSMappedRead";
    if (this == NSDataReadingUncached)
      return "NSDataReadingOptions.NSDataReadingUncached, NSDataReadingOptions.NSUncachedRead";
    return super.toString();
  }
}

enum NSDataSearchOptions {
  NSDataSearchBackwards(1),
  NSDataSearchAnchored(2);

  final int value;
  const NSDataSearchOptions(this.value);

  static NSDataSearchOptions fromValue(int value) => switch (value) {
        1 => NSDataSearchBackwards,
        2 => NSDataSearchAnchored,
        _ =>
          throw ArgumentError('Unknown value for NSDataSearchOptions: $value'),
      };
}

enum NSDataWritingOptions {
  NSDataWritingAtomic(1),
  NSDataWritingWithoutOverwriting(2),
  NSDataWritingFileProtectionNone(268435456),
  NSDataWritingFileProtectionComplete(536870912),
  NSDataWritingFileProtectionCompleteUnlessOpen(805306368),
  NSDataWritingFileProtectionCompleteUntilFirstUserAuthentication(1073741824),
  NSDataWritingFileProtectionCompleteWhenUserInactive(1342177280),
  NSDataWritingFileProtectionMask(4026531840);

  static const NSAtomicWrite = NSDataWritingAtomic;

  final int value;
  const NSDataWritingOptions(this.value);

  static NSDataWritingOptions fromValue(int value) => switch (value) {
        1 => NSDataWritingAtomic,
        2 => NSDataWritingWithoutOverwriting,
        268435456 => NSDataWritingFileProtectionNone,
        536870912 => NSDataWritingFileProtectionComplete,
        805306368 => NSDataWritingFileProtectionCompleteUnlessOpen,
        1073741824 =>
          NSDataWritingFileProtectionCompleteUntilFirstUserAuthentication,
        1342177280 => NSDataWritingFileProtectionCompleteWhenUserInactive,
        4026531840 => NSDataWritingFileProtectionMask,
        _ =>
          throw ArgumentError('Unknown value for NSDataWritingOptions: $value'),
      };

  @override
  String toString() {
    if (this == NSDataWritingAtomic)
      return "NSDataWritingOptions.NSDataWritingAtomic, NSDataWritingOptions.NSAtomicWrite";
    return super.toString();
  }
}

/// NSDate
class NSDate extends NSObject implements NSCopying, NSSecureCoding {
  NSDate._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSDate] that points to the same underlying object as [other].
  NSDate.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSDate] that wraps the given raw object pointer.
  NSDate.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSDate].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSDate);
  }

  /// alloc
  static NSDate alloc() {
    final _ret = _objc_msgSend_151sglz(_class_NSDate, _sel_alloc);
    return NSDate.castFromPointer(_ret, retain: false, release: true);
  }

  /// allocWithZone:
  static NSDate allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret =
        _objc_msgSend_1cwp428(_class_NSDate, _sel_allocWithZone_, zone);
    return NSDate.castFromPointer(_ret, retain: false, release: true);
  }

  /// date
  static NSDate date() {
    final _ret = _objc_msgSend_151sglz(_class_NSDate, _sel_date);
    return NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  /// dateWithTimeInterval:sinceDate:
  static NSDate dateWithTimeInterval_sinceDate_(
      double secsToBeAdded, NSDate date) {
    final _ret = _objc_msgSend_1ozwf6k(_class_NSDate,
        _sel_dateWithTimeInterval_sinceDate_, secsToBeAdded, date.ref.pointer);
    return NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  /// dateWithTimeIntervalSince1970:
  static NSDate dateWithTimeIntervalSince1970_(double secs) {
    final _ret = _objc_msgSend_oa8mke(
        _class_NSDate, _sel_dateWithTimeIntervalSince1970_, secs);
    return NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  /// dateWithTimeIntervalSinceNow:
  static NSDate dateWithTimeIntervalSinceNow_(double secs) {
    final _ret = _objc_msgSend_oa8mke(
        _class_NSDate, _sel_dateWithTimeIntervalSinceNow_, secs);
    return NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  /// dateWithTimeIntervalSinceReferenceDate:
  static NSDate dateWithTimeIntervalSinceReferenceDate_(double ti) {
    final _ret = _objc_msgSend_oa8mke(
        _class_NSDate, _sel_dateWithTimeIntervalSinceReferenceDate_, ti);
    return NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  /// new
  static NSDate new$() {
    final _ret = _objc_msgSend_151sglz(_class_NSDate, _sel_new);
    return NSDate.castFromPointer(_ret, retain: false, release: true);
  }

  /// supportsSecureCoding
  static bool getSupportsSecureCoding() {
    return _objc_msgSend_91o635(_class_NSDate, _sel_supportsSecureCoding);
  }

  /// autorelease
  NSDate autorelease() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_autorelease);
    return NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  /// dateByAddingTimeInterval:
  NSDate dateByAddingTimeInterval_(double ti) {
    objc.checkOsVersionInternal('NSDate.dateByAddingTimeInterval:',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 6, 0)));
    final _ret = _objc_msgSend_oa8mke(
        this.ref.pointer, _sel_dateByAddingTimeInterval_, ti);
    return NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  /// encodeWithCoder:
  void encodeWithCoder_(NSCoder coder) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_encodeWithCoder_, coder.ref.pointer);
  }

  /// init
  NSDate init() {
    objc.checkOsVersionInternal('NSDate.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSDate.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithCoder:
  NSDate? initWithCoder_(NSCoder coder) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithCoder_, coder.ref.pointer);
    return _ret.address == 0
        ? null
        : NSDate.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithTimeInterval:sinceDate:
  NSDate initWithTimeInterval_sinceDate_(double secsToBeAdded, NSDate date) {
    final _ret = _objc_msgSend_1ozwf6k(this.ref.retainAndReturnPointer(),
        _sel_initWithTimeInterval_sinceDate_, secsToBeAdded, date.ref.pointer);
    return NSDate.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithTimeIntervalSince1970:
  NSDate initWithTimeIntervalSince1970_(double secs) {
    final _ret = _objc_msgSend_oa8mke(this.ref.retainAndReturnPointer(),
        _sel_initWithTimeIntervalSince1970_, secs);
    return NSDate.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithTimeIntervalSinceNow:
  NSDate initWithTimeIntervalSinceNow_(double secs) {
    final _ret = _objc_msgSend_oa8mke(this.ref.retainAndReturnPointer(),
        _sel_initWithTimeIntervalSinceNow_, secs);
    return NSDate.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithTimeIntervalSinceReferenceDate:
  NSDate initWithTimeIntervalSinceReferenceDate_(double ti) {
    final _ret = _objc_msgSend_oa8mke(this.ref.retainAndReturnPointer(),
        _sel_initWithTimeIntervalSinceReferenceDate_, ti);
    return NSDate.castFromPointer(_ret, retain: false, release: true);
  }

  /// retain
  NSDate retain() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_retain);
    return NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  /// self
  NSDate self$1() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_self);
    return NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  /// timeIntervalSinceReferenceDate
  double get timeIntervalSinceReferenceDate {
    return objc.useMsgSendVariants
        ? _objc_msgSend_1ukqyt8Fpret(
            this.ref.pointer, _sel_timeIntervalSinceReferenceDate)
        : _objc_msgSend_1ukqyt8(
            this.ref.pointer, _sel_timeIntervalSinceReferenceDate);
  }

  /// Returns a new instance of NSDate constructed with the default `new` method.
  factory NSDate() => new$();
}

/// NSDictionary
class NSDictionary extends NSObject
    implements NSCopying, NSMutableCopying, NSSecureCoding, NSFastEnumeration {
  NSDictionary._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSDictionary] that points to the same underlying object as [other].
  NSDictionary.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSDictionary] that wraps the given raw object pointer.
  NSDictionary.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSDictionary].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSDictionary);
  }

  /// alloc
  static NSDictionary alloc() {
    final _ret = _objc_msgSend_151sglz(_class_NSDictionary, _sel_alloc);
    return NSDictionary.castFromPointer(_ret, retain: false, release: true);
  }

  /// allocWithZone:
  static NSDictionary allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret =
        _objc_msgSend_1cwp428(_class_NSDictionary, _sel_allocWithZone_, zone);
    return NSDictionary.castFromPointer(_ret, retain: false, release: true);
  }

  /// dictionary
  static NSDictionary dictionary() {
    final _ret = _objc_msgSend_151sglz(_class_NSDictionary, _sel_dictionary);
    return NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  /// dictionaryWithDictionary:
  static NSDictionary dictionaryWithDictionary_(NSDictionary dict) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSDictionary, _sel_dictionaryWithDictionary_, dict.ref.pointer);
    return NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  /// dictionaryWithObject:forKey:
  static NSDictionary dictionaryWithObject_forKey_(
      objc.ObjCObjectBase object, NSCopying key) {
    final _ret = _objc_msgSend_15qeuct(_class_NSDictionary,
        _sel_dictionaryWithObject_forKey_, object.ref.pointer, key.ref.pointer);
    return NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  /// dictionaryWithObjects:forKeys:
  static NSDictionary dictionaryWithObjects_forKeys_(
      NSArray objects, NSArray keys) {
    final _ret = _objc_msgSend_15qeuct(
        _class_NSDictionary,
        _sel_dictionaryWithObjects_forKeys_,
        objects.ref.pointer,
        keys.ref.pointer);
    return NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  /// dictionaryWithObjects:forKeys:count:
  static NSDictionary dictionaryWithObjects_forKeys_count_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> keys,
      int cnt) {
    final _ret = _objc_msgSend_1dydpdi(_class_NSDictionary,
        _sel_dictionaryWithObjects_forKeys_count_, objects, keys, cnt);
    return NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  /// dictionaryWithObjectsAndKeys:
  static NSDictionary dictionaryWithObjectsAndKeys_(
      objc.ObjCObjectBase firstObject) {
    final _ret = _objc_msgSend_1sotr3r(_class_NSDictionary,
        _sel_dictionaryWithObjectsAndKeys_, firstObject.ref.pointer);
    return NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  /// new
  static NSDictionary new$() {
    final _ret = _objc_msgSend_151sglz(_class_NSDictionary, _sel_new);
    return NSDictionary.castFromPointer(_ret, retain: false, release: true);
  }

  /// supportsSecureCoding
  static bool getSupportsSecureCoding() {
    return _objc_msgSend_91o635(_class_NSDictionary, _sel_supportsSecureCoding);
  }

  /// count
  int get count {
    return _objc_msgSend_xw2lbc(this.ref.pointer, _sel_count);
  }

  /// countByEnumeratingWithState:objects:count:
  int countByEnumeratingWithState_objects_count_(
      ffi.Pointer<NSFastEnumerationState> state,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> buffer,
      int len) {
    return _objc_msgSend_1b5ysjl(this.ref.pointer,
        _sel_countByEnumeratingWithState_objects_count_, state, buffer, len);
  }

  /// encodeWithCoder:
  void encodeWithCoder_(NSCoder coder) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_encodeWithCoder_, coder.ref.pointer);
  }

  /// init
  NSDictionary init() {
    objc.checkOsVersionInternal('NSDictionary.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSDictionary.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithCoder:
  NSDictionary? initWithCoder_(NSCoder coder) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithCoder_, coder.ref.pointer);
    return _ret.address == 0
        ? null
        : NSDictionary.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithDictionary:
  NSDictionary initWithDictionary_(NSDictionary otherDictionary) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithDictionary_, otherDictionary.ref.pointer);
    return NSDictionary.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithDictionary:copyItems:
  NSDictionary initWithDictionary_copyItems_(
      NSDictionary otherDictionary, bool flag) {
    final _ret = _objc_msgSend_17amj0z(this.ref.retainAndReturnPointer(),
        _sel_initWithDictionary_copyItems_, otherDictionary.ref.pointer, flag);
    return NSDictionary.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithObjects:forKeys:
  NSDictionary initWithObjects_forKeys_(NSArray objects, NSArray keys) {
    final _ret = _objc_msgSend_15qeuct(this.ref.retainAndReturnPointer(),
        _sel_initWithObjects_forKeys_, objects.ref.pointer, keys.ref.pointer);
    return NSDictionary.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithObjects:forKeys:count:
  NSDictionary initWithObjects_forKeys_count_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> keys,
      int cnt) {
    final _ret = _objc_msgSend_1dydpdi(this.ref.retainAndReturnPointer(),
        _sel_initWithObjects_forKeys_count_, objects, keys, cnt);
    return NSDictionary.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithObjectsAndKeys:
  NSDictionary initWithObjectsAndKeys_(objc.ObjCObjectBase firstObject) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithObjectsAndKeys_, firstObject.ref.pointer);
    return NSDictionary.castFromPointer(_ret, retain: false, release: true);
  }

  /// keyEnumerator
  NSEnumerator keyEnumerator() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_keyEnumerator);
    return NSEnumerator.castFromPointer(_ret, retain: true, release: true);
  }

  /// objectForKey:
  objc.ObjCObjectBase? objectForKey_(objc.ObjCObjectBase aKey) {
    final _ret = _objc_msgSend_1sotr3r(
        this.ref.pointer, _sel_objectForKey_, aKey.ref.pointer);
    return _ret.address == 0
        ? null
        : objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// Returns a new instance of NSDictionary constructed with the default `new` method.
  factory NSDictionary() => new$();
}

enum NSEnumerationOptions {
  NSEnumerationConcurrent(1),
  NSEnumerationReverse(2);

  final int value;
  const NSEnumerationOptions(this.value);

  static NSEnumerationOptions fromValue(int value) => switch (value) {
        1 => NSEnumerationConcurrent,
        2 => NSEnumerationReverse,
        _ =>
          throw ArgumentError('Unknown value for NSEnumerationOptions: $value'),
      };
}

/// NSEnumerator
class NSEnumerator extends NSObject implements NSFastEnumeration {
  NSEnumerator._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSEnumerator] that points to the same underlying object as [other].
  NSEnumerator.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSEnumerator] that wraps the given raw object pointer.
  NSEnumerator.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSEnumerator].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSEnumerator);
  }

  /// alloc
  static NSEnumerator alloc() {
    final _ret = _objc_msgSend_151sglz(_class_NSEnumerator, _sel_alloc);
    return NSEnumerator.castFromPointer(_ret, retain: false, release: true);
  }

  /// allocWithZone:
  static NSEnumerator allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret =
        _objc_msgSend_1cwp428(_class_NSEnumerator, _sel_allocWithZone_, zone);
    return NSEnumerator.castFromPointer(_ret, retain: false, release: true);
  }

  /// new
  static NSEnumerator new$() {
    final _ret = _objc_msgSend_151sglz(_class_NSEnumerator, _sel_new);
    return NSEnumerator.castFromPointer(_ret, retain: false, release: true);
  }

  /// countByEnumeratingWithState:objects:count:
  int countByEnumeratingWithState_objects_count_(
      ffi.Pointer<NSFastEnumerationState> state,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> buffer,
      int len) {
    return _objc_msgSend_1b5ysjl(this.ref.pointer,
        _sel_countByEnumeratingWithState_objects_count_, state, buffer, len);
  }

  /// init
  NSEnumerator init() {
    objc.checkOsVersionInternal('NSEnumerator.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSEnumerator.castFromPointer(_ret, retain: false, release: true);
  }

  /// nextObject
  objc.ObjCObjectBase? nextObject() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_nextObject);
    return _ret.address == 0
        ? null
        : objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// Returns a new instance of NSEnumerator constructed with the default `new` method.
  factory NSEnumerator() => new$();
}

/// NSError
class NSError extends NSObject implements NSCopying, NSSecureCoding {
  NSError._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSError] that points to the same underlying object as [other].
  NSError.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSError] that wraps the given raw object pointer.
  NSError.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSError].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSError);
  }

  /// alloc
  static NSError alloc() {
    final _ret = _objc_msgSend_151sglz(_class_NSError, _sel_alloc);
    return NSError.castFromPointer(_ret, retain: false, release: true);
  }

  /// allocWithZone:
  static NSError allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret =
        _objc_msgSend_1cwp428(_class_NSError, _sel_allocWithZone_, zone);
    return NSError.castFromPointer(_ret, retain: false, release: true);
  }

  /// errorWithDomain:code:userInfo:
  static NSError errorWithDomain_code_userInfo_(
      NSString domain, int code, objc.ObjCObjectBase? dict) {
    final _ret = _objc_msgSend_rc4ypv(
        _class_NSError,
        _sel_errorWithDomain_code_userInfo_,
        domain.ref.pointer,
        code,
        dict?.ref.pointer ?? ffi.nullptr);
    return NSError.castFromPointer(_ret, retain: true, release: true);
  }

  /// new
  static NSError new$() {
    final _ret = _objc_msgSend_151sglz(_class_NSError, _sel_new);
    return NSError.castFromPointer(_ret, retain: false, release: true);
  }

  /// supportsSecureCoding
  static bool getSupportsSecureCoding() {
    return _objc_msgSend_91o635(_class_NSError, _sel_supportsSecureCoding);
  }

  /// code
  int get code {
    return _objc_msgSend_1hz7y9r(this.ref.pointer, _sel_code);
  }

  /// domain
  NSString get domain {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_domain);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// encodeWithCoder:
  void encodeWithCoder_(NSCoder coder) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_encodeWithCoder_, coder.ref.pointer);
  }

  /// helpAnchor
  NSString? get helpAnchor {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_helpAnchor);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// init
  NSError init() {
    objc.checkOsVersionInternal('NSError.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSError.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithCoder:
  NSError? initWithCoder_(NSCoder coder) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithCoder_, coder.ref.pointer);
    return _ret.address == 0
        ? null
        : NSError.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithDomain:code:userInfo:
  NSError initWithDomain_code_userInfo_(
      NSString domain, int code, objc.ObjCObjectBase? dict) {
    final _ret = _objc_msgSend_rc4ypv(
        this.ref.retainAndReturnPointer(),
        _sel_initWithDomain_code_userInfo_,
        domain.ref.pointer,
        code,
        dict?.ref.pointer ?? ffi.nullptr);
    return NSError.castFromPointer(_ret, retain: false, release: true);
  }

  /// localizedDescription
  NSString get localizedDescription {
    final _ret =
        _objc_msgSend_151sglz(this.ref.pointer, _sel_localizedDescription);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// localizedFailureReason
  NSString? get localizedFailureReason {
    final _ret =
        _objc_msgSend_151sglz(this.ref.pointer, _sel_localizedFailureReason);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// localizedRecoveryOptions
  NSArray? get localizedRecoveryOptions {
    final _ret =
        _objc_msgSend_151sglz(this.ref.pointer, _sel_localizedRecoveryOptions);
    return _ret.address == 0
        ? null
        : NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// localizedRecoverySuggestion
  NSString? get localizedRecoverySuggestion {
    final _ret = _objc_msgSend_151sglz(
        this.ref.pointer, _sel_localizedRecoverySuggestion);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// recoveryAttempter
  objc.ObjCObjectBase? get recoveryAttempter {
    final _ret =
        _objc_msgSend_151sglz(this.ref.pointer, _sel_recoveryAttempter);
    return _ret.address == 0
        ? null
        : objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// iOS: introduced 14.5.0
  /// macOS: introduced 11.3.0
  NSArray get underlyingErrors {
    objc.checkOsVersionInternal('NSError.underlyingErrors',
        iOS: (false, (14, 5, 0)), macOS: (false, (11, 3, 0)));
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_underlyingErrors);
    return NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// userInfo
  objc.ObjCObjectBase get userInfo {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_userInfo);
    return objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// Returns a new instance of NSError constructed with the default `new` method.
  factory NSError() => new$();
}

/// NSExtendedArray
extension NSExtendedArray on NSArray {
  /// arrayByAddingObject:
  NSArray arrayByAddingObject_(objc.ObjCObjectBase anObject) {
    final _ret = _objc_msgSend_1sotr3r(
        this.ref.pointer, _sel_arrayByAddingObject_, anObject.ref.pointer);
    return NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// arrayByAddingObjectsFromArray:
  NSArray arrayByAddingObjectsFromArray_(NSArray otherArray) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.pointer,
        _sel_arrayByAddingObjectsFromArray_, otherArray.ref.pointer);
    return NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// componentsJoinedByString:
  NSString componentsJoinedByString_(NSString separator) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.pointer,
        _sel_componentsJoinedByString_, separator.ref.pointer);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// containsObject:
  bool containsObject_(objc.ObjCObjectBase anObject) {
    return _objc_msgSend_19nvye5(
        this.ref.pointer, _sel_containsObject_, anObject.ref.pointer);
  }

  /// description
  NSString get description {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_description);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// descriptionWithLocale:
  NSString descriptionWithLocale_(objc.ObjCObjectBase? locale) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.pointer,
        _sel_descriptionWithLocale_, locale?.ref.pointer ?? ffi.nullptr);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// descriptionWithLocale:indent:
  NSString descriptionWithLocale_indent_(
      objc.ObjCObjectBase? locale, int level) {
    final _ret = _objc_msgSend_1k4kd9s(
        this.ref.pointer,
        _sel_descriptionWithLocale_indent_,
        locale?.ref.pointer ?? ffi.nullptr,
        level);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// firstObject
  objc.ObjCObjectBase? get firstObject {
    objc.checkOsVersionInternal('NSArray.firstObject',
        iOS: (false, (4, 0, 0)), macOS: (false, (10, 6, 0)));
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_firstObject);
    return _ret.address == 0
        ? null
        : objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// firstObjectCommonWithArray:
  objc.ObjCObjectBase? firstObjectCommonWithArray_(NSArray otherArray) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.pointer,
        _sel_firstObjectCommonWithArray_, otherArray.ref.pointer);
    return _ret.address == 0
        ? null
        : objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// getObjects:range:
  void getObjects_range_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects, NSRange range) {
    _objc_msgSend_o16d3k(
        this.ref.pointer, _sel_getObjects_range_, objects, range);
  }

  /// indexOfObject:
  int indexOfObject_(objc.ObjCObjectBase anObject) {
    return _objc_msgSend_1vd1c5m(
        this.ref.pointer, _sel_indexOfObject_, anObject.ref.pointer);
  }

  /// indexOfObject:inRange:
  int indexOfObject_inRange_(objc.ObjCObjectBase anObject, NSRange range) {
    return _objc_msgSend_zug4wi(this.ref.pointer, _sel_indexOfObject_inRange_,
        anObject.ref.pointer, range);
  }

  /// indexOfObjectIdenticalTo:
  int indexOfObjectIdenticalTo_(objc.ObjCObjectBase anObject) {
    return _objc_msgSend_1vd1c5m(
        this.ref.pointer, _sel_indexOfObjectIdenticalTo_, anObject.ref.pointer);
  }

  /// indexOfObjectIdenticalTo:inRange:
  int indexOfObjectIdenticalTo_inRange_(
      objc.ObjCObjectBase anObject, NSRange range) {
    return _objc_msgSend_zug4wi(this.ref.pointer,
        _sel_indexOfObjectIdenticalTo_inRange_, anObject.ref.pointer, range);
  }

  /// isEqualToArray:
  bool isEqualToArray_(NSArray otherArray) {
    return _objc_msgSend_19nvye5(
        this.ref.pointer, _sel_isEqualToArray_, otherArray.ref.pointer);
  }

  /// lastObject
  objc.ObjCObjectBase? get lastObject {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_lastObject);
    return _ret.address == 0
        ? null
        : objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// makeObjectsPerformSelector:
  void makeObjectsPerformSelector_(ffi.Pointer<objc.ObjCSelector> aSelector) {
    _objc_msgSend_1d9e4oe(
        this.ref.pointer, _sel_makeObjectsPerformSelector_, aSelector);
  }

  /// makeObjectsPerformSelector:withObject:
  void makeObjectsPerformSelector_withObject_(
      ffi.Pointer<objc.ObjCSelector> aSelector, objc.ObjCObjectBase? argument) {
    _objc_msgSend_1qv0eq4(
        this.ref.pointer,
        _sel_makeObjectsPerformSelector_withObject_,
        aSelector,
        argument?.ref.pointer ?? ffi.nullptr);
  }

  /// objectAtIndexedSubscript:
  objc.ObjCObjectBase objectAtIndexedSubscript_(int idx) {
    objc.checkOsVersionInternal('NSArray.objectAtIndexedSubscript:',
        iOS: (false, (6, 0, 0)), macOS: (false, (10, 8, 0)));
    final _ret = _objc_msgSend_14hpxwa(
        this.ref.pointer, _sel_objectAtIndexedSubscript_, idx);
    return objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// objectEnumerator
  NSEnumerator objectEnumerator() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_objectEnumerator);
    return NSEnumerator.castFromPointer(_ret, retain: true, release: true);
  }

  /// objectsAtIndexes:
  NSArray objectsAtIndexes_(NSIndexSet indexes) {
    final _ret = _objc_msgSend_1sotr3r(
        this.ref.pointer, _sel_objectsAtIndexes_, indexes.ref.pointer);
    return NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// reverseObjectEnumerator
  NSEnumerator reverseObjectEnumerator() {
    final _ret =
        _objc_msgSend_151sglz(this.ref.pointer, _sel_reverseObjectEnumerator);
    return NSEnumerator.castFromPointer(_ret, retain: true, release: true);
  }

  /// sortedArrayHint
  NSData get sortedArrayHint {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_sortedArrayHint);
    return NSData.castFromPointer(_ret, retain: true, release: true);
  }

  /// sortedArrayUsingFunction:context:
  NSArray sortedArrayUsingFunction_context_(
      ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Long Function(ffi.Pointer<objc.ObjCObject>,
                      ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>)>>
          comparator,
      ffi.Pointer<ffi.Void> context) {
    final _ret = _objc_msgSend_1ffoev1(this.ref.pointer,
        _sel_sortedArrayUsingFunction_context_, comparator, context);
    return NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// sortedArrayUsingFunction:context:hint:
  NSArray sortedArrayUsingFunction_context_hint_(
      ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Long Function(ffi.Pointer<objc.ObjCObject>,
                      ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>)>>
          comparator,
      ffi.Pointer<ffi.Void> context,
      NSData? hint) {
    final _ret = _objc_msgSend_1i2r70j(
        this.ref.pointer,
        _sel_sortedArrayUsingFunction_context_hint_,
        comparator,
        context,
        hint?.ref.pointer ?? ffi.nullptr);
    return NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// sortedArrayUsingSelector:
  NSArray sortedArrayUsingSelector_(ffi.Pointer<objc.ObjCSelector> comparator) {
    final _ret = _objc_msgSend_3ctkt6(
        this.ref.pointer, _sel_sortedArrayUsingSelector_, comparator);
    return NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// subarrayWithRange:
  NSArray subarrayWithRange_(NSRange range) {
    final _ret =
        _objc_msgSend_1k1o1s7(this.ref.pointer, _sel_subarrayWithRange_, range);
    return NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// writeToURL:error:
  bool writeToURL_error_(
      NSURL url, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    objc.checkOsVersionInternal('NSArray.writeToURL:error:',
        iOS: (false, (11, 0, 0)), macOS: (false, (10, 13, 0)));
    return _objc_msgSend_l9p60w(
        this.ref.pointer, _sel_writeToURL_error_, url.ref.pointer, error);
  }
}

/// NSExtendedData
extension NSExtendedData on NSData {
  /// description
  NSString get description {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_description);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// getBytes:length:
  void getBytes_length_(ffi.Pointer<ffi.Void> buffer, int length) {
    _objc_msgSend_zuf90e(
        this.ref.pointer, _sel_getBytes_length_, buffer, length);
  }

  /// getBytes:range:
  void getBytes_range_(ffi.Pointer<ffi.Void> buffer, NSRange range) {
    _objc_msgSend_xpqfd7(this.ref.pointer, _sel_getBytes_range_, buffer, range);
  }

  /// isEqualToData:
  bool isEqualToData_(NSData other) {
    return _objc_msgSend_19nvye5(
        this.ref.pointer, _sel_isEqualToData_, other.ref.pointer);
  }

  /// rangeOfData:options:range:
  NSRange rangeOfData_options_range_(
      NSData dataToFind, NSDataSearchOptions mask, NSRange searchRange) {
    objc.checkOsVersionInternal('NSData.rangeOfData:options:range:',
        iOS: (false, (4, 0, 0)), macOS: (false, (10, 6, 0)));
    final _ptr = pkg_ffi.calloc<NSRange>();
    objc.useMsgSendVariants
        ? _objc_msgSend_1d8s65wStret(
            _ptr,
            this.ref.pointer,
            _sel_rangeOfData_options_range_,
            dataToFind.ref.pointer,
            mask.value,
            searchRange)
        : _ptr.ref = _objc_msgSend_1d8s65w(
            this.ref.pointer,
            _sel_rangeOfData_options_range_,
            dataToFind.ref.pointer,
            mask.value,
            searchRange);
    final _finalizable = _ptr.cast<ffi.Uint8>().asTypedList(
        ffi.sizeOf<NSRange>(),
        finalizer: pkg_ffi.calloc.nativeFree);
    return ffi.Struct.create<NSRange>(_finalizable);
  }

  /// subdataWithRange:
  NSData subdataWithRange_(NSRange range) {
    final _ret =
        _objc_msgSend_1k1o1s7(this.ref.pointer, _sel_subdataWithRange_, range);
    return NSData.castFromPointer(_ret, retain: true, release: true);
  }

  /// writeToFile:atomically:
  bool writeToFile_atomically_(NSString path, bool useAuxiliaryFile) {
    return _objc_msgSend_1iyq28l(this.ref.pointer, _sel_writeToFile_atomically_,
        path.ref.pointer, useAuxiliaryFile);
  }

  /// writeToFile:options:error:
  bool writeToFile_options_error_(
      NSString path,
      NSDataWritingOptions writeOptionsMask,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> errorPtr) {
    return _objc_msgSend_1xi08ar(
        this.ref.pointer,
        _sel_writeToFile_options_error_,
        path.ref.pointer,
        writeOptionsMask.value,
        errorPtr);
  }

  /// writeToURL:atomically:
  bool writeToURL_atomically_(NSURL url, bool atomically) {
    return _objc_msgSend_1iyq28l(this.ref.pointer, _sel_writeToURL_atomically_,
        url.ref.pointer, atomically);
  }

  /// writeToURL:options:error:
  bool writeToURL_options_error_(
      NSURL url,
      NSDataWritingOptions writeOptionsMask,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> errorPtr) {
    return _objc_msgSend_1xi08ar(
        this.ref.pointer,
        _sel_writeToURL_options_error_,
        url.ref.pointer,
        writeOptionsMask.value,
        errorPtr);
  }
}

/// NSExtendedDate
extension NSExtendedDate on NSDate {
  /// timeIntervalSinceReferenceDate
  static double getTimeIntervalSinceReferenceDate() {
    return objc.useMsgSendVariants
        ? _objc_msgSend_1ukqyt8Fpret(
            _class_NSDate, _sel_timeIntervalSinceReferenceDate)
        : _objc_msgSend_1ukqyt8(
            _class_NSDate, _sel_timeIntervalSinceReferenceDate);
  }

  /// compare:
  NSComparisonResult compare_(NSDate other) {
    final _ret = _objc_msgSend_1ym6zyw(
        this.ref.pointer, _sel_compare_, other.ref.pointer);
    return NSComparisonResult.fromValue(_ret);
  }

  /// description
  NSString get description {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_description);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// descriptionWithLocale:
  NSString descriptionWithLocale_(objc.ObjCObjectBase? locale) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.pointer,
        _sel_descriptionWithLocale_, locale?.ref.pointer ?? ffi.nullptr);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// earlierDate:
  NSDate earlierDate_(NSDate anotherDate) {
    final _ret = _objc_msgSend_1sotr3r(
        this.ref.pointer, _sel_earlierDate_, anotherDate.ref.pointer);
    return NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  /// isEqualToDate:
  bool isEqualToDate_(NSDate otherDate) {
    return _objc_msgSend_19nvye5(
        this.ref.pointer, _sel_isEqualToDate_, otherDate.ref.pointer);
  }

  /// laterDate:
  NSDate laterDate_(NSDate anotherDate) {
    final _ret = _objc_msgSend_1sotr3r(
        this.ref.pointer, _sel_laterDate_, anotherDate.ref.pointer);
    return NSDate.castFromPointer(_ret, retain: true, release: true);
  }

  /// timeIntervalSince1970
  double get timeIntervalSince1970 {
    return objc.useMsgSendVariants
        ? _objc_msgSend_1ukqyt8Fpret(
            this.ref.pointer, _sel_timeIntervalSince1970)
        : _objc_msgSend_1ukqyt8(this.ref.pointer, _sel_timeIntervalSince1970);
  }

  /// timeIntervalSinceDate:
  double timeIntervalSinceDate_(NSDate anotherDate) {
    return objc.useMsgSendVariants
        ? _objc_msgSend_mabicuFpret(this.ref.pointer,
            _sel_timeIntervalSinceDate_, anotherDate.ref.pointer)
        : _objc_msgSend_mabicu(this.ref.pointer, _sel_timeIntervalSinceDate_,
            anotherDate.ref.pointer);
  }

  /// timeIntervalSinceNow
  double get timeIntervalSinceNow {
    return objc.useMsgSendVariants
        ? _objc_msgSend_1ukqyt8Fpret(
            this.ref.pointer, _sel_timeIntervalSinceNow)
        : _objc_msgSend_1ukqyt8(this.ref.pointer, _sel_timeIntervalSinceNow);
  }
}

/// NSExtendedDictionary
extension NSExtendedDictionary on NSDictionary {
  /// allKeys
  NSArray get allKeys {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_allKeys);
    return NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// allKeysForObject:
  NSArray allKeysForObject_(objc.ObjCObjectBase anObject) {
    final _ret = _objc_msgSend_1sotr3r(
        this.ref.pointer, _sel_allKeysForObject_, anObject.ref.pointer);
    return NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// allValues
  NSArray get allValues {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_allValues);
    return NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// description
  NSString get description {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_description);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// descriptionInStringsFileFormat
  NSString get descriptionInStringsFileFormat {
    final _ret = _objc_msgSend_151sglz(
        this.ref.pointer, _sel_descriptionInStringsFileFormat);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// descriptionWithLocale:
  NSString descriptionWithLocale_(objc.ObjCObjectBase? locale) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.pointer,
        _sel_descriptionWithLocale_, locale?.ref.pointer ?? ffi.nullptr);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// descriptionWithLocale:indent:
  NSString descriptionWithLocale_indent_(
      objc.ObjCObjectBase? locale, int level) {
    final _ret = _objc_msgSend_1k4kd9s(
        this.ref.pointer,
        _sel_descriptionWithLocale_indent_,
        locale?.ref.pointer ?? ffi.nullptr,
        level);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// getObjects:andKeys:count:
  void getObjects_andKeys_count_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> keys,
      int count) {
    objc.checkOsVersionInternal('NSDictionary.getObjects:andKeys:count:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    _objc_msgSend_n2svg2(
        this.ref.pointer, _sel_getObjects_andKeys_count_, objects, keys, count);
  }

  /// isEqualToDictionary:
  bool isEqualToDictionary_(NSDictionary otherDictionary) {
    return _objc_msgSend_19nvye5(this.ref.pointer, _sel_isEqualToDictionary_,
        otherDictionary.ref.pointer);
  }

  /// keysSortedByValueUsingSelector:
  NSArray keysSortedByValueUsingSelector_(
      ffi.Pointer<objc.ObjCSelector> comparator) {
    final _ret = _objc_msgSend_3ctkt6(
        this.ref.pointer, _sel_keysSortedByValueUsingSelector_, comparator);
    return NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// objectEnumerator
  NSEnumerator objectEnumerator() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_objectEnumerator);
    return NSEnumerator.castFromPointer(_ret, retain: true, release: true);
  }

  /// objectForKeyedSubscript:
  objc.ObjCObjectBase? objectForKeyedSubscript_(objc.ObjCObjectBase key) {
    objc.checkOsVersionInternal('NSDictionary.objectForKeyedSubscript:',
        iOS: (false, (6, 0, 0)), macOS: (false, (10, 8, 0)));
    final _ret = _objc_msgSend_1sotr3r(
        this.ref.pointer, _sel_objectForKeyedSubscript_, key.ref.pointer);
    return _ret.address == 0
        ? null
        : objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// objectsForKeys:notFoundMarker:
  NSArray objectsForKeys_notFoundMarker_(
      NSArray keys, objc.ObjCObjectBase marker) {
    final _ret = _objc_msgSend_15qeuct(
        this.ref.pointer,
        _sel_objectsForKeys_notFoundMarker_,
        keys.ref.pointer,
        marker.ref.pointer);
    return NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// writeToURL:error:
  bool writeToURL_error_(
      NSURL url, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    objc.checkOsVersionInternal('NSDictionary.writeToURL:error:',
        iOS: (false, (11, 0, 0)), macOS: (false, (10, 13, 0)));
    return _objc_msgSend_l9p60w(
        this.ref.pointer, _sel_writeToURL_error_, url.ref.pointer, error);
  }
}

/// NSExtendedEnumerator
extension NSExtendedEnumerator on NSEnumerator {
  /// allObjects
  objc.ObjCObjectBase get allObjects {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_allObjects);
    return objc.ObjCObjectBase(_ret, retain: true, release: true);
  }
}

/// NSExtendedMutableArray
extension NSExtendedMutableArray on NSMutableArray {
  /// addObjectsFromArray:
  void addObjectsFromArray_(NSArray otherArray) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_addObjectsFromArray_, otherArray.ref.pointer);
  }

  /// exchangeObjectAtIndex:withObjectAtIndex:
  void exchangeObjectAtIndex_withObjectAtIndex_(int idx1, int idx2) {
    _objc_msgSend_bfp043(this.ref.pointer,
        _sel_exchangeObjectAtIndex_withObjectAtIndex_, idx1, idx2);
  }

  /// insertObjects:atIndexes:
  void insertObjects_atIndexes_(NSArray objects, NSIndexSet indexes) {
    _objc_msgSend_pfv6jd(this.ref.pointer, _sel_insertObjects_atIndexes_,
        objects.ref.pointer, indexes.ref.pointer);
  }

  /// removeAllObjects
  void removeAllObjects() {
    _objc_msgSend_1pl9qdv(this.ref.pointer, _sel_removeAllObjects);
  }

  /// removeObject:
  void removeObject_(objc.ObjCObjectBase anObject) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_removeObject_, anObject.ref.pointer);
  }

  /// removeObject:inRange:
  void removeObject_inRange_(objc.ObjCObjectBase anObject, NSRange range) {
    _objc_msgSend_1oteutl(this.ref.pointer, _sel_removeObject_inRange_,
        anObject.ref.pointer, range);
  }

  /// removeObjectIdenticalTo:
  void removeObjectIdenticalTo_(objc.ObjCObjectBase anObject) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_removeObjectIdenticalTo_, anObject.ref.pointer);
  }

  /// removeObjectIdenticalTo:inRange:
  void removeObjectIdenticalTo_inRange_(
      objc.ObjCObjectBase anObject, NSRange range) {
    _objc_msgSend_1oteutl(this.ref.pointer,
        _sel_removeObjectIdenticalTo_inRange_, anObject.ref.pointer, range);
  }

  /// removeObjectsAtIndexes:
  void removeObjectsAtIndexes_(NSIndexSet indexes) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_removeObjectsAtIndexes_, indexes.ref.pointer);
  }

  /// removeObjectsInArray:
  void removeObjectsInArray_(NSArray otherArray) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_removeObjectsInArray_, otherArray.ref.pointer);
  }

  /// removeObjectsInRange:
  void removeObjectsInRange_(NSRange range) {
    _objc_msgSend_1e3pm0z(this.ref.pointer, _sel_removeObjectsInRange_, range);
  }

  /// replaceObjectsAtIndexes:withObjects:
  void replaceObjectsAtIndexes_withObjects_(
      NSIndexSet indexes, NSArray objects) {
    _objc_msgSend_pfv6jd(
        this.ref.pointer,
        _sel_replaceObjectsAtIndexes_withObjects_,
        indexes.ref.pointer,
        objects.ref.pointer);
  }

  /// replaceObjectsInRange:withObjectsFromArray:
  void replaceObjectsInRange_withObjectsFromArray_(
      NSRange range, NSArray otherArray) {
    _objc_msgSend_1tv4uax(
        this.ref.pointer,
        _sel_replaceObjectsInRange_withObjectsFromArray_,
        range,
        otherArray.ref.pointer);
  }

  /// replaceObjectsInRange:withObjectsFromArray:range:
  void replaceObjectsInRange_withObjectsFromArray_range_(
      NSRange range, NSArray otherArray, NSRange otherRange) {
    _objc_msgSend_15bolr3(
        this.ref.pointer,
        _sel_replaceObjectsInRange_withObjectsFromArray_range_,
        range,
        otherArray.ref.pointer,
        otherRange);
  }

  /// setArray:
  void setArray_(NSArray otherArray) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_setArray_, otherArray.ref.pointer);
  }

  /// setObject:atIndexedSubscript:
  void setObject_atIndexedSubscript_(objc.ObjCObjectBase obj, int idx) {
    objc.checkOsVersionInternal('NSMutableArray.setObject:atIndexedSubscript:',
        iOS: (false, (6, 0, 0)), macOS: (false, (10, 8, 0)));
    _objc_msgSend_djsa9o(this.ref.pointer, _sel_setObject_atIndexedSubscript_,
        obj.ref.pointer, idx);
  }

  /// sortUsingFunction:context:
  void sortUsingFunction_context_(
      ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Long Function(ffi.Pointer<objc.ObjCObject>,
                      ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>)>>
          compare,
      ffi.Pointer<ffi.Void> context) {
    _objc_msgSend_1bvics1(
        this.ref.pointer, _sel_sortUsingFunction_context_, compare, context);
  }

  /// sortUsingSelector:
  void sortUsingSelector_(ffi.Pointer<objc.ObjCSelector> comparator) {
    _objc_msgSend_1d9e4oe(
        this.ref.pointer, _sel_sortUsingSelector_, comparator);
  }
}

/// NSExtendedMutableData
extension NSExtendedMutableData on NSMutableData {
  /// appendBytes:length:
  void appendBytes_length_(ffi.Pointer<ffi.Void> bytes, int length) {
    _objc_msgSend_zuf90e(
        this.ref.pointer, _sel_appendBytes_length_, bytes, length);
  }

  /// appendData:
  void appendData_(NSData other) {
    _objc_msgSend_xtuoz7(this.ref.pointer, _sel_appendData_, other.ref.pointer);
  }

  /// increaseLengthBy:
  void increaseLengthBy_(int extraLength) {
    _objc_msgSend_1i9r4xy(
        this.ref.pointer, _sel_increaseLengthBy_, extraLength);
  }

  /// replaceBytesInRange:withBytes:
  void replaceBytesInRange_withBytes_(
      NSRange range, ffi.Pointer<ffi.Void> bytes) {
    _objc_msgSend_eh32gn(
        this.ref.pointer, _sel_replaceBytesInRange_withBytes_, range, bytes);
  }

  /// replaceBytesInRange:withBytes:length:
  void replaceBytesInRange_withBytes_length_(NSRange range,
      ffi.Pointer<ffi.Void> replacementBytes, int replacementLength) {
    _objc_msgSend_c0vg4w(
        this.ref.pointer,
        _sel_replaceBytesInRange_withBytes_length_,
        range,
        replacementBytes,
        replacementLength);
  }

  /// resetBytesInRange:
  void resetBytesInRange_(NSRange range) {
    _objc_msgSend_1e3pm0z(this.ref.pointer, _sel_resetBytesInRange_, range);
  }

  /// setData:
  void setData_(NSData data) {
    _objc_msgSend_xtuoz7(this.ref.pointer, _sel_setData_, data.ref.pointer);
  }
}

/// NSExtendedMutableDictionary
extension NSExtendedMutableDictionary on NSMutableDictionary {
  /// addEntriesFromDictionary:
  void addEntriesFromDictionary_(NSDictionary otherDictionary) {
    _objc_msgSend_xtuoz7(this.ref.pointer, _sel_addEntriesFromDictionary_,
        otherDictionary.ref.pointer);
  }

  /// removeAllObjects
  void removeAllObjects() {
    _objc_msgSend_1pl9qdv(this.ref.pointer, _sel_removeAllObjects);
  }

  /// removeObjectsForKeys:
  void removeObjectsForKeys_(NSArray keyArray) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_removeObjectsForKeys_, keyArray.ref.pointer);
  }

  /// setDictionary:
  void setDictionary_(NSDictionary otherDictionary) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_setDictionary_, otherDictionary.ref.pointer);
  }

  /// setObject:forKeyedSubscript:
  void setObject_forKeyedSubscript_(objc.ObjCObjectBase? obj, NSCopying key) {
    objc.checkOsVersionInternal(
        'NSMutableDictionary.setObject:forKeyedSubscript:',
        iOS: (false, (6, 0, 0)),
        macOS: (false, (10, 8, 0)));
    _objc_msgSend_pfv6jd(this.ref.pointer, _sel_setObject_forKeyedSubscript_,
        obj?.ref.pointer ?? ffi.nullptr, key.ref.pointer);
  }
}

/// NSExtendedMutableOrderedSet
extension NSExtendedMutableOrderedSet on NSMutableOrderedSet {
  /// addObject:
  void addObject_(objc.ObjCObjectBase object) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.addObject:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    _objc_msgSend_xtuoz7(this.ref.pointer, _sel_addObject_, object.ref.pointer);
  }

  /// addObjects:count:
  void addObjects_count_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects, int count) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.addObjects:count:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    _objc_msgSend_gcjqkl(
        this.ref.pointer, _sel_addObjects_count_, objects, count);
  }

  /// addObjectsFromArray:
  void addObjectsFromArray_(NSArray array) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.addObjectsFromArray:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_addObjectsFromArray_, array.ref.pointer);
  }

  /// exchangeObjectAtIndex:withObjectAtIndex:
  void exchangeObjectAtIndex_withObjectAtIndex_(int idx1, int idx2) {
    objc.checkOsVersionInternal(
        'NSMutableOrderedSet.exchangeObjectAtIndex:withObjectAtIndex:',
        iOS: (false, (5, 0, 0)),
        macOS: (false, (10, 7, 0)));
    _objc_msgSend_bfp043(this.ref.pointer,
        _sel_exchangeObjectAtIndex_withObjectAtIndex_, idx1, idx2);
  }

  /// insertObjects:atIndexes:
  void insertObjects_atIndexes_(NSArray objects, NSIndexSet indexes) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.insertObjects:atIndexes:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    _objc_msgSend_pfv6jd(this.ref.pointer, _sel_insertObjects_atIndexes_,
        objects.ref.pointer, indexes.ref.pointer);
  }

  /// intersectOrderedSet:
  void intersectOrderedSet_(NSOrderedSet other) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.intersectOrderedSet:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_intersectOrderedSet_, other.ref.pointer);
  }

  /// intersectSet:
  void intersectSet_(objc.ObjCObjectBase other) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.intersectSet:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_intersectSet_, other.ref.pointer);
  }

  /// minusOrderedSet:
  void minusOrderedSet_(NSOrderedSet other) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.minusOrderedSet:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_minusOrderedSet_, other.ref.pointer);
  }

  /// minusSet:
  void minusSet_(objc.ObjCObjectBase other) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.minusSet:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    _objc_msgSend_xtuoz7(this.ref.pointer, _sel_minusSet_, other.ref.pointer);
  }

  /// moveObjectsAtIndexes:toIndex:
  void moveObjectsAtIndexes_toIndex_(NSIndexSet indexes, int idx) {
    objc.checkOsVersionInternal(
        'NSMutableOrderedSet.moveObjectsAtIndexes:toIndex:',
        iOS: (false, (5, 0, 0)),
        macOS: (false, (10, 7, 0)));
    _objc_msgSend_djsa9o(this.ref.pointer, _sel_moveObjectsAtIndexes_toIndex_,
        indexes.ref.pointer, idx);
  }

  /// removeAllObjects
  void removeAllObjects() {
    objc.checkOsVersionInternal('NSMutableOrderedSet.removeAllObjects',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    _objc_msgSend_1pl9qdv(this.ref.pointer, _sel_removeAllObjects);
  }

  /// removeObject:
  void removeObject_(objc.ObjCObjectBase object) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.removeObject:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_removeObject_, object.ref.pointer);
  }

  /// removeObjectsAtIndexes:
  void removeObjectsAtIndexes_(NSIndexSet indexes) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.removeObjectsAtIndexes:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_removeObjectsAtIndexes_, indexes.ref.pointer);
  }

  /// removeObjectsInArray:
  void removeObjectsInArray_(NSArray array) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.removeObjectsInArray:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_removeObjectsInArray_, array.ref.pointer);
  }

  /// removeObjectsInRange:
  void removeObjectsInRange_(NSRange range) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.removeObjectsInRange:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    _objc_msgSend_1e3pm0z(this.ref.pointer, _sel_removeObjectsInRange_, range);
  }

  /// replaceObjectsAtIndexes:withObjects:
  void replaceObjectsAtIndexes_withObjects_(
      NSIndexSet indexes, NSArray objects) {
    objc.checkOsVersionInternal(
        'NSMutableOrderedSet.replaceObjectsAtIndexes:withObjects:',
        iOS: (false, (5, 0, 0)),
        macOS: (false, (10, 7, 0)));
    _objc_msgSend_pfv6jd(
        this.ref.pointer,
        _sel_replaceObjectsAtIndexes_withObjects_,
        indexes.ref.pointer,
        objects.ref.pointer);
  }

  /// replaceObjectsInRange:withObjects:count:
  void replaceObjectsInRange_withObjects_count_(NSRange range,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects, int count) {
    objc.checkOsVersionInternal(
        'NSMutableOrderedSet.replaceObjectsInRange:withObjects:count:',
        iOS: (false, (5, 0, 0)),
        macOS: (false, (10, 7, 0)));
    _objc_msgSend_122v0cv(this.ref.pointer,
        _sel_replaceObjectsInRange_withObjects_count_, range, objects, count);
  }

  /// setObject:atIndex:
  void setObject_atIndex_(objc.ObjCObjectBase obj, int idx) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.setObject:atIndex:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    _objc_msgSend_djsa9o(
        this.ref.pointer, _sel_setObject_atIndex_, obj.ref.pointer, idx);
  }

  /// setObject:atIndexedSubscript:
  void setObject_atIndexedSubscript_(objc.ObjCObjectBase obj, int idx) {
    objc.checkOsVersionInternal(
        'NSMutableOrderedSet.setObject:atIndexedSubscript:',
        iOS: (false, (6, 0, 0)),
        macOS: (false, (10, 8, 0)));
    _objc_msgSend_djsa9o(this.ref.pointer, _sel_setObject_atIndexedSubscript_,
        obj.ref.pointer, idx);
  }

  /// unionOrderedSet:
  void unionOrderedSet_(NSOrderedSet other) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.unionOrderedSet:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_unionOrderedSet_, other.ref.pointer);
  }

  /// unionSet:
  void unionSet_(objc.ObjCObjectBase other) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.unionSet:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    _objc_msgSend_xtuoz7(this.ref.pointer, _sel_unionSet_, other.ref.pointer);
  }
}

/// NSExtendedMutableSet
extension NSExtendedMutableSet on NSMutableSet {
  /// addObjectsFromArray:
  void addObjectsFromArray_(NSArray array) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_addObjectsFromArray_, array.ref.pointer);
  }

  /// intersectSet:
  void intersectSet_(NSSet otherSet) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_intersectSet_, otherSet.ref.pointer);
  }

  /// minusSet:
  void minusSet_(NSSet otherSet) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_minusSet_, otherSet.ref.pointer);
  }

  /// removeAllObjects
  void removeAllObjects() {
    _objc_msgSend_1pl9qdv(this.ref.pointer, _sel_removeAllObjects);
  }

  /// setSet:
  void setSet_(NSSet otherSet) {
    _objc_msgSend_xtuoz7(this.ref.pointer, _sel_setSet_, otherSet.ref.pointer);
  }

  /// unionSet:
  void unionSet_(NSSet otherSet) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_unionSet_, otherSet.ref.pointer);
  }
}

/// NSExtendedOrderedSet
extension NSExtendedOrderedSet on NSOrderedSet {
  /// array
  NSArray get array {
    objc.checkOsVersionInternal('NSOrderedSet.array',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_array);
    return NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// containsObject:
  bool containsObject_(objc.ObjCObjectBase object) {
    objc.checkOsVersionInternal('NSOrderedSet.containsObject:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    return _objc_msgSend_19nvye5(
        this.ref.pointer, _sel_containsObject_, object.ref.pointer);
  }

  /// description
  NSString get description {
    objc.checkOsVersionInternal('NSOrderedSet.description',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_description);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// descriptionWithLocale:
  NSString descriptionWithLocale_(objc.ObjCObjectBase? locale) {
    objc.checkOsVersionInternal('NSOrderedSet.descriptionWithLocale:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_1sotr3r(this.ref.pointer,
        _sel_descriptionWithLocale_, locale?.ref.pointer ?? ffi.nullptr);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// descriptionWithLocale:indent:
  NSString descriptionWithLocale_indent_(
      objc.ObjCObjectBase? locale, int level) {
    objc.checkOsVersionInternal('NSOrderedSet.descriptionWithLocale:indent:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_1k4kd9s(
        this.ref.pointer,
        _sel_descriptionWithLocale_indent_,
        locale?.ref.pointer ?? ffi.nullptr,
        level);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// firstObject
  objc.ObjCObjectBase? get firstObject {
    objc.checkOsVersionInternal('NSOrderedSet.firstObject',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_firstObject);
    return _ret.address == 0
        ? null
        : objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// getObjects:range:
  void getObjects_range_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects, NSRange range) {
    _objc_msgSend_o16d3k(
        this.ref.pointer, _sel_getObjects_range_, objects, range);
  }

  /// intersectsOrderedSet:
  bool intersectsOrderedSet_(NSOrderedSet other) {
    objc.checkOsVersionInternal('NSOrderedSet.intersectsOrderedSet:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    return _objc_msgSend_19nvye5(
        this.ref.pointer, _sel_intersectsOrderedSet_, other.ref.pointer);
  }

  /// intersectsSet:
  bool intersectsSet_(objc.ObjCObjectBase set) {
    objc.checkOsVersionInternal('NSOrderedSet.intersectsSet:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    return _objc_msgSend_19nvye5(
        this.ref.pointer, _sel_intersectsSet_, set.ref.pointer);
  }

  /// isEqualToOrderedSet:
  bool isEqualToOrderedSet_(NSOrderedSet other) {
    objc.checkOsVersionInternal('NSOrderedSet.isEqualToOrderedSet:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    return _objc_msgSend_19nvye5(
        this.ref.pointer, _sel_isEqualToOrderedSet_, other.ref.pointer);
  }

  /// isSubsetOfOrderedSet:
  bool isSubsetOfOrderedSet_(NSOrderedSet other) {
    objc.checkOsVersionInternal('NSOrderedSet.isSubsetOfOrderedSet:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    return _objc_msgSend_19nvye5(
        this.ref.pointer, _sel_isSubsetOfOrderedSet_, other.ref.pointer);
  }

  /// isSubsetOfSet:
  bool isSubsetOfSet_(objc.ObjCObjectBase set) {
    objc.checkOsVersionInternal('NSOrderedSet.isSubsetOfSet:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    return _objc_msgSend_19nvye5(
        this.ref.pointer, _sel_isSubsetOfSet_, set.ref.pointer);
  }

  /// lastObject
  objc.ObjCObjectBase? get lastObject {
    objc.checkOsVersionInternal('NSOrderedSet.lastObject',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_lastObject);
    return _ret.address == 0
        ? null
        : objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// objectAtIndexedSubscript:
  objc.ObjCObjectBase objectAtIndexedSubscript_(int idx) {
    objc.checkOsVersionInternal('NSOrderedSet.objectAtIndexedSubscript:',
        iOS: (false, (6, 0, 0)), macOS: (false, (10, 8, 0)));
    final _ret = _objc_msgSend_14hpxwa(
        this.ref.pointer, _sel_objectAtIndexedSubscript_, idx);
    return objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// objectEnumerator
  NSEnumerator objectEnumerator() {
    objc.checkOsVersionInternal('NSOrderedSet.objectEnumerator',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_objectEnumerator);
    return NSEnumerator.castFromPointer(_ret, retain: true, release: true);
  }

  /// objectsAtIndexes:
  NSArray objectsAtIndexes_(NSIndexSet indexes) {
    objc.checkOsVersionInternal('NSOrderedSet.objectsAtIndexes:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_1sotr3r(
        this.ref.pointer, _sel_objectsAtIndexes_, indexes.ref.pointer);
    return NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// reverseObjectEnumerator
  NSEnumerator reverseObjectEnumerator() {
    objc.checkOsVersionInternal('NSOrderedSet.reverseObjectEnumerator',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.pointer, _sel_reverseObjectEnumerator);
    return NSEnumerator.castFromPointer(_ret, retain: true, release: true);
  }

  /// reversedOrderedSet
  NSOrderedSet get reversedOrderedSet {
    objc.checkOsVersionInternal('NSOrderedSet.reversedOrderedSet',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.pointer, _sel_reversedOrderedSet);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// set
  objc.ObjCObjectBase get set$ {
    objc.checkOsVersionInternal('NSOrderedSet.set',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_set);
    return objc.ObjCObjectBase(_ret, retain: true, release: true);
  }
}

/// NSExtendedSet
extension NSExtendedSet on NSSet {
  /// allObjects
  NSArray get allObjects {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_allObjects);
    return NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// anyObject
  objc.ObjCObjectBase? anyObject() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_anyObject);
    return _ret.address == 0
        ? null
        : objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// containsObject:
  bool containsObject_(objc.ObjCObjectBase anObject) {
    return _objc_msgSend_19nvye5(
        this.ref.pointer, _sel_containsObject_, anObject.ref.pointer);
  }

  /// description
  NSString get description {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_description);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// descriptionWithLocale:
  NSString descriptionWithLocale_(objc.ObjCObjectBase? locale) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.pointer,
        _sel_descriptionWithLocale_, locale?.ref.pointer ?? ffi.nullptr);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// intersectsSet:
  bool intersectsSet_(NSSet otherSet) {
    return _objc_msgSend_19nvye5(
        this.ref.pointer, _sel_intersectsSet_, otherSet.ref.pointer);
  }

  /// isEqualToSet:
  bool isEqualToSet_(NSSet otherSet) {
    return _objc_msgSend_19nvye5(
        this.ref.pointer, _sel_isEqualToSet_, otherSet.ref.pointer);
  }

  /// isSubsetOfSet:
  bool isSubsetOfSet_(NSSet otherSet) {
    return _objc_msgSend_19nvye5(
        this.ref.pointer, _sel_isSubsetOfSet_, otherSet.ref.pointer);
  }

  /// makeObjectsPerformSelector:
  void makeObjectsPerformSelector_(ffi.Pointer<objc.ObjCSelector> aSelector) {
    _objc_msgSend_1d9e4oe(
        this.ref.pointer, _sel_makeObjectsPerformSelector_, aSelector);
  }

  /// makeObjectsPerformSelector:withObject:
  void makeObjectsPerformSelector_withObject_(
      ffi.Pointer<objc.ObjCSelector> aSelector, objc.ObjCObjectBase? argument) {
    _objc_msgSend_1qv0eq4(
        this.ref.pointer,
        _sel_makeObjectsPerformSelector_withObject_,
        aSelector,
        argument?.ref.pointer ?? ffi.nullptr);
  }

  /// setByAddingObject:
  NSSet setByAddingObject_(objc.ObjCObjectBase anObject) {
    objc.checkOsVersionInternal('NSSet.setByAddingObject:',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 5, 0)));
    final _ret = _objc_msgSend_1sotr3r(
        this.ref.pointer, _sel_setByAddingObject_, anObject.ref.pointer);
    return NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// setByAddingObjectsFromArray:
  NSSet setByAddingObjectsFromArray_(NSArray other) {
    objc.checkOsVersionInternal('NSSet.setByAddingObjectsFromArray:',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 5, 0)));
    final _ret = _objc_msgSend_1sotr3r(
        this.ref.pointer, _sel_setByAddingObjectsFromArray_, other.ref.pointer);
    return NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// setByAddingObjectsFromSet:
  NSSet setByAddingObjectsFromSet_(NSSet other) {
    objc.checkOsVersionInternal('NSSet.setByAddingObjectsFromSet:',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 5, 0)));
    final _ret = _objc_msgSend_1sotr3r(
        this.ref.pointer, _sel_setByAddingObjectsFromSet_, other.ref.pointer);
    return NSSet.castFromPointer(_ret, retain: true, release: true);
  }
}

/// NSFastEnumeration
interface class NSFastEnumeration extends objc.ObjCProtocolBase {
  NSFastEnumeration._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super(pointer, retain: retain, release: release);

  /// Constructs a [NSFastEnumeration] that points to the same underlying object as [other].
  NSFastEnumeration.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSFastEnumeration] that wraps the given raw object pointer.
  NSFastEnumeration.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSFastEnumeration].
  static bool conformsTo(objc.ObjCObjectBase obj) {
    return _objc_msgSend_e3qsqz(
        obj.ref.pointer, _sel_conformsToProtocol_, _protocol_NSFastEnumeration);
  }

  /// Returns the [objc.Protocol] object for this protocol.
  static objc.Protocol get $protocol =>
      objc.Protocol.castFromPointer(_protocol_NSFastEnumeration.cast());

  /// Builds an object that implements the NSFastEnumeration protocol. To implement
  /// multiple protocols, use [addToBuilder] or [objc.ObjCProtocolBuilder] directly.
  ///
  /// If `$keepIsolateAlive` is true, this protocol will keep this isolate
  /// alive until it is garbage collected by both Dart and ObjC.
  static NSFastEnumeration implement(
      {required int Function(ffi.Pointer<NSFastEnumerationState>,
              ffi.Pointer<ffi.Pointer<objc.ObjCObject>>, int)
          countByEnumeratingWithState_objects_count_,
      bool $keepIsolateAlive = true}) {
    final builder = objc.ObjCProtocolBuilder(debugName: 'NSFastEnumeration');
    NSFastEnumeration.countByEnumeratingWithState_objects_count_
        .implement(builder, countByEnumeratingWithState_objects_count_);
    builder.addProtocol($protocol);
    return NSFastEnumeration.castFrom(
        builder.build(keepIsolateAlive: $keepIsolateAlive));
  }

  /// Adds the implementation of the NSFastEnumeration protocol to an existing
  /// [objc.ObjCProtocolBuilder].
  ///
  /// Note: You cannot call this method after you have called `builder.build`.
  static void addToBuilder(objc.ObjCProtocolBuilder builder,
      {required int Function(ffi.Pointer<NSFastEnumerationState>,
              ffi.Pointer<ffi.Pointer<objc.ObjCObject>>, int)
          countByEnumeratingWithState_objects_count_,
      bool $keepIsolateAlive = true}) {
    NSFastEnumeration.countByEnumeratingWithState_objects_count_
        .implement(builder, countByEnumeratingWithState_objects_count_);
    builder.addProtocol($protocol);
  }

  /// countByEnumeratingWithState:objects:count:
  static final countByEnumeratingWithState_objects_count_ =
      objc.ObjCProtocolMethod<
          int Function(ffi.Pointer<NSFastEnumerationState>,
              ffi.Pointer<ffi.Pointer<objc.ObjCObject>>, int)>(
    _protocol_NSFastEnumeration,
    _sel_countByEnumeratingWithState_objects_count_,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.UnsignedLong Function(
                        ffi.Pointer<objc.ObjCObject>,
                        ffi.Pointer<ffi.Void>,
                        ffi.Pointer<NSFastEnumerationState>,
                        ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                        ffi.UnsignedLong)>>(
            _ObjectiveCBindings_protocolTrampoline_17ap02x)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSFastEnumeration,
      _sel_countByEnumeratingWithState_objects_count_,
      isRequired: true,
      isInstanceMethod: true,
    ),
    (int Function(ffi.Pointer<NSFastEnumerationState>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>, int)
            func) =>
        ObjCBlock_NSUInteger_ffiVoid_NSFastEnumerationState_objcObjCObject_NSUInteger
            .fromFunction((ffi.Pointer<ffi.Void> _,
                    ffi.Pointer<NSFastEnumerationState> arg1,
                    ffi.Pointer<ffi.Pointer<objc.ObjCObject>> arg2,
                    int arg3) =>
                func(arg1, arg2, arg3)),
  );
}

final class NSFastEnumerationState extends ffi.Struct {
  @ffi.UnsignedLong()
  external int state;

  external ffi.Pointer<ffi.Pointer<objc.ObjCObject>> itemsPtr;

  external ffi.Pointer<ffi.UnsignedLong> mutationsPtr;

  @ffi.Array.multi([5])
  external ffi.Array<ffi.UnsignedLong> extra;
}

/// NSIndexSet
class NSIndexSet extends NSObject
    implements NSCopying, NSMutableCopying, NSSecureCoding {
  NSIndexSet._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSIndexSet] that points to the same underlying object as [other].
  NSIndexSet.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSIndexSet] that wraps the given raw object pointer.
  NSIndexSet.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSIndexSet].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSIndexSet);
  }

  /// alloc
  static NSIndexSet alloc() {
    final _ret = _objc_msgSend_151sglz(_class_NSIndexSet, _sel_alloc);
    return NSIndexSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// allocWithZone:
  static NSIndexSet allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret =
        _objc_msgSend_1cwp428(_class_NSIndexSet, _sel_allocWithZone_, zone);
    return NSIndexSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// indexSet
  static NSIndexSet indexSet() {
    final _ret = _objc_msgSend_151sglz(_class_NSIndexSet, _sel_indexSet);
    return NSIndexSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// indexSetWithIndex:
  static NSIndexSet indexSetWithIndex_(int value) {
    final _ret = _objc_msgSend_14hpxwa(
        _class_NSIndexSet, _sel_indexSetWithIndex_, value);
    return NSIndexSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// indexSetWithIndexesInRange:
  static NSIndexSet indexSetWithIndexesInRange_(NSRange range) {
    final _ret = _objc_msgSend_1k1o1s7(
        _class_NSIndexSet, _sel_indexSetWithIndexesInRange_, range);
    return NSIndexSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// new
  static NSIndexSet new$() {
    final _ret = _objc_msgSend_151sglz(_class_NSIndexSet, _sel_new);
    return NSIndexSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// supportsSecureCoding
  static bool getSupportsSecureCoding() {
    return _objc_msgSend_91o635(_class_NSIndexSet, _sel_supportsSecureCoding);
  }

  /// containsIndex:
  bool containsIndex_(int value) {
    return _objc_msgSend_6peh6o(this.ref.pointer, _sel_containsIndex_, value);
  }

  /// containsIndexes:
  bool containsIndexes_(NSIndexSet indexSet) {
    return _objc_msgSend_19nvye5(
        this.ref.pointer, _sel_containsIndexes_, indexSet.ref.pointer);
  }

  /// containsIndexesInRange:
  bool containsIndexesInRange_(NSRange range) {
    return _objc_msgSend_p4nurx(
        this.ref.pointer, _sel_containsIndexesInRange_, range);
  }

  /// count
  int get count {
    return _objc_msgSend_xw2lbc(this.ref.pointer, _sel_count);
  }

  /// countOfIndexesInRange:
  int countOfIndexesInRange_(NSRange range) {
    objc.checkOsVersionInternal('NSIndexSet.countOfIndexesInRange:',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 5, 0)));
    return _objc_msgSend_qm9f5w(
        this.ref.pointer, _sel_countOfIndexesInRange_, range);
  }

  /// encodeWithCoder:
  void encodeWithCoder_(NSCoder coder) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_encodeWithCoder_, coder.ref.pointer);
  }

  /// firstIndex
  int get firstIndex {
    return _objc_msgSend_xw2lbc(this.ref.pointer, _sel_firstIndex);
  }

  /// getIndexes:maxCount:inIndexRange:
  int getIndexes_maxCount_inIndexRange_(
      ffi.Pointer<ffi.UnsignedLong> indexBuffer,
      int bufferSize,
      ffi.Pointer<NSRange> range) {
    return _objc_msgSend_89xgla(this.ref.pointer,
        _sel_getIndexes_maxCount_inIndexRange_, indexBuffer, bufferSize, range);
  }

  /// indexGreaterThanIndex:
  int indexGreaterThanIndex_(int value) {
    return _objc_msgSend_12py2ux(
        this.ref.pointer, _sel_indexGreaterThanIndex_, value);
  }

  /// indexGreaterThanOrEqualToIndex:
  int indexGreaterThanOrEqualToIndex_(int value) {
    return _objc_msgSend_12py2ux(
        this.ref.pointer, _sel_indexGreaterThanOrEqualToIndex_, value);
  }

  /// indexLessThanIndex:
  int indexLessThanIndex_(int value) {
    return _objc_msgSend_12py2ux(
        this.ref.pointer, _sel_indexLessThanIndex_, value);
  }

  /// indexLessThanOrEqualToIndex:
  int indexLessThanOrEqualToIndex_(int value) {
    return _objc_msgSend_12py2ux(
        this.ref.pointer, _sel_indexLessThanOrEqualToIndex_, value);
  }

  /// init
  NSIndexSet init() {
    objc.checkOsVersionInternal('NSIndexSet.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSIndexSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithCoder:
  NSIndexSet? initWithCoder_(NSCoder coder) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithCoder_, coder.ref.pointer);
    return _ret.address == 0
        ? null
        : NSIndexSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithIndex:
  NSIndexSet initWithIndex_(int value) {
    final _ret = _objc_msgSend_14hpxwa(
        this.ref.retainAndReturnPointer(), _sel_initWithIndex_, value);
    return NSIndexSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithIndexSet:
  NSIndexSet initWithIndexSet_(NSIndexSet indexSet) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithIndexSet_, indexSet.ref.pointer);
    return NSIndexSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithIndexesInRange:
  NSIndexSet initWithIndexesInRange_(NSRange range) {
    final _ret = _objc_msgSend_1k1o1s7(
        this.ref.retainAndReturnPointer(), _sel_initWithIndexesInRange_, range);
    return NSIndexSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// intersectsIndexesInRange:
  bool intersectsIndexesInRange_(NSRange range) {
    return _objc_msgSend_p4nurx(
        this.ref.pointer, _sel_intersectsIndexesInRange_, range);
  }

  /// isEqualToIndexSet:
  bool isEqualToIndexSet_(NSIndexSet indexSet) {
    return _objc_msgSend_19nvye5(
        this.ref.pointer, _sel_isEqualToIndexSet_, indexSet.ref.pointer);
  }

  /// lastIndex
  int get lastIndex {
    return _objc_msgSend_xw2lbc(this.ref.pointer, _sel_lastIndex);
  }

  /// Returns a new instance of NSIndexSet constructed with the default `new` method.
  factory NSIndexSet() => new$();
}

/// NSInputStream
class NSInputStream extends NSStream {
  NSInputStream._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSInputStream] that points to the same underlying object as [other].
  NSInputStream.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSInputStream] that wraps the given raw object pointer.
  NSInputStream.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSInputStream].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSInputStream);
  }

  /// inputStreamWithData:
  static NSInputStream? inputStreamWithData_(NSData data) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSInputStream, _sel_inputStreamWithData_, data.ref.pointer);
    return _ret.address == 0
        ? null
        : NSInputStream.castFromPointer(_ret, retain: true, release: true);
  }

  /// inputStreamWithFileAtPath:
  static NSInputStream? inputStreamWithFileAtPath_(NSString path) {
    final _ret = _objc_msgSend_1sotr3r(_class_NSInputStream,
        _sel_inputStreamWithFileAtPath_, path.ref.pointer);
    return _ret.address == 0
        ? null
        : NSInputStream.castFromPointer(_ret, retain: true, release: true);
  }

  /// inputStreamWithURL:
  static NSInputStream? inputStreamWithURL_(NSURL url) {
    objc.checkOsVersionInternal('NSInputStream.inputStreamWithURL:',
        iOS: (false, (4, 0, 0)), macOS: (false, (10, 6, 0)));
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSInputStream, _sel_inputStreamWithURL_, url.ref.pointer);
    return _ret.address == 0
        ? null
        : NSInputStream.castFromPointer(_ret, retain: true, release: true);
  }

  /// getBuffer:length:
  bool getBuffer_length_(ffi.Pointer<ffi.Pointer<ffi.Uint8>> buffer,
      ffi.Pointer<ffi.UnsignedLong> len) {
    return _objc_msgSend_19lrthf(
        this.ref.pointer, _sel_getBuffer_length_, buffer, len);
  }

  /// hasBytesAvailable
  bool get hasBytesAvailable {
    return _objc_msgSend_91o635(this.ref.pointer, _sel_hasBytesAvailable);
  }

  /// initWithData:
  NSInputStream initWithData_(NSData data) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithData_, data.ref.pointer);
    return NSInputStream.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithFileAtPath:
  NSInputStream? initWithFileAtPath_(NSString path) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithFileAtPath_, path.ref.pointer);
    return _ret.address == 0
        ? null
        : NSInputStream.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithURL:
  NSInputStream? initWithURL_(NSURL url) {
    objc.checkOsVersionInternal('NSInputStream.initWithURL:',
        iOS: (false, (4, 0, 0)), macOS: (false, (10, 6, 0)));
    final _ret = _objc_msgSend_1sotr3r(
        this.ref.retainAndReturnPointer(), _sel_initWithURL_, url.ref.pointer);
    return _ret.address == 0
        ? null
        : NSInputStream.castFromPointer(_ret, retain: false, release: true);
  }

  /// read:maxLength:
  int read_maxLength_(ffi.Pointer<ffi.Uint8> buffer, int len) {
    return _objc_msgSend_11e9f5x(
        this.ref.pointer, _sel_read_maxLength_, buffer, len);
  }
}

/// NSInvocation
class NSInvocation extends objc.ObjCObjectBase {
  NSInvocation._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super(pointer, retain: retain, release: release);

  /// Constructs a [NSInvocation] that points to the same underlying object as [other].
  NSInvocation.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSInvocation] that wraps the given raw object pointer.
  NSInvocation.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSInvocation].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSInvocation);
  }
}

/// NSItemProvider
class NSItemProvider extends NSObject implements NSCopying {
  NSItemProvider._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release) {
    objc.checkOsVersionInternal('NSItemProvider',
        iOS: (false, (8, 0, 0)), macOS: (false, (10, 10, 0)));
  }

  /// Constructs a [NSItemProvider] that points to the same underlying object as [other].
  NSItemProvider.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSItemProvider] that wraps the given raw object pointer.
  NSItemProvider.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSItemProvider].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSItemProvider);
  }

  /// alloc
  static NSItemProvider alloc() {
    final _ret = _objc_msgSend_151sglz(_class_NSItemProvider, _sel_alloc);
    return NSItemProvider.castFromPointer(_ret, retain: false, release: true);
  }

  /// allocWithZone:
  static NSItemProvider allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret =
        _objc_msgSend_1cwp428(_class_NSItemProvider, _sel_allocWithZone_, zone);
    return NSItemProvider.castFromPointer(_ret, retain: false, release: true);
  }

  /// new
  static NSItemProvider new$() {
    final _ret = _objc_msgSend_151sglz(_class_NSItemProvider, _sel_new);
    return NSItemProvider.castFromPointer(_ret, retain: false, release: true);
  }

  /// autorelease
  NSItemProvider autorelease() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_autorelease);
    return NSItemProvider.castFromPointer(_ret, retain: true, release: true);
  }

  /// canLoadObjectOfClass:
  bool canLoadObjectOfClass_(NSItemProviderReading aClass) {
    objc.checkOsVersionInternal('NSItemProvider.canLoadObjectOfClass:',
        iOS: (false, (11, 0, 0)), macOS: (false, (10, 13, 0)));
    return _objc_msgSend_19nvye5(
        this.ref.pointer, _sel_canLoadObjectOfClass_, aClass.ref.pointer);
  }

  /// hasItemConformingToTypeIdentifier:
  bool hasItemConformingToTypeIdentifier_(NSString typeIdentifier) {
    objc.checkOsVersionInternal(
        'NSItemProvider.hasItemConformingToTypeIdentifier:',
        iOS: (false, (8, 0, 0)),
        macOS: (false, (10, 10, 0)));
    return _objc_msgSend_19nvye5(this.ref.pointer,
        _sel_hasItemConformingToTypeIdentifier_, typeIdentifier.ref.pointer);
  }

  /// hasRepresentationConformingToTypeIdentifier:fileOptions:
  bool hasRepresentationConformingToTypeIdentifier_fileOptions_(
      NSString typeIdentifier, NSItemProviderFileOptions fileOptions) {
    objc.checkOsVersionInternal(
        'NSItemProvider.hasRepresentationConformingToTypeIdentifier:fileOptions:',
        iOS: (false, (11, 0, 0)),
        macOS: (false, (10, 13, 0)));
    return _objc_msgSend_1wdb8ji(
        this.ref.pointer,
        _sel_hasRepresentationConformingToTypeIdentifier_fileOptions_,
        typeIdentifier.ref.pointer,
        fileOptions.value);
  }

  /// init
  NSItemProvider init() {
    objc.checkOsVersionInternal('NSItemProvider.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSItemProvider.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithContentsOfURL:
  NSItemProvider? initWithContentsOfURL_(NSURL fileURL) {
    objc.checkOsVersionInternal('NSItemProvider.initWithContentsOfURL:',
        iOS: (false, (8, 0, 0)), macOS: (false, (10, 10, 0)));
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithContentsOfURL_, fileURL.ref.pointer);
    return _ret.address == 0
        ? null
        : NSItemProvider.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithItem:typeIdentifier:
  NSItemProvider initWithItem_typeIdentifier_(
      NSSecureCoding? item, NSString? typeIdentifier) {
    objc.checkOsVersionInternal('NSItemProvider.initWithItem:typeIdentifier:',
        iOS: (false, (8, 0, 0)), macOS: (false, (10, 10, 0)));
    final _ret = _objc_msgSend_15qeuct(
        this.ref.retainAndReturnPointer(),
        _sel_initWithItem_typeIdentifier_,
        item?.ref.pointer ?? ffi.nullptr,
        typeIdentifier?.ref.pointer ?? ffi.nullptr);
    return NSItemProvider.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithObject:
  NSItemProvider initWithObject_(NSItemProviderWriting object) {
    objc.checkOsVersionInternal('NSItemProvider.initWithObject:',
        iOS: (false, (11, 0, 0)), macOS: (false, (10, 13, 0)));
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithObject_, object.ref.pointer);
    return NSItemProvider.castFromPointer(_ret, retain: false, release: true);
  }

  /// loadItemForTypeIdentifier:options:completionHandler:
  void loadItemForTypeIdentifier_options_completionHandler_(
      NSString typeIdentifier,
      NSDictionary? options,
      objc.ObjCBlock<ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)>?
          completionHandler) {
    objc.checkOsVersionInternal(
        'NSItemProvider.loadItemForTypeIdentifier:options:completionHandler:',
        iOS: (false, (8, 0, 0)),
        macOS: (false, (10, 10, 0)));
    _objc_msgSend_18qun1e(
        this.ref.pointer,
        _sel_loadItemForTypeIdentifier_options_completionHandler_,
        typeIdentifier.ref.pointer,
        options?.ref.pointer ?? ffi.nullptr,
        completionHandler?.ref.pointer ?? ffi.nullptr);
  }

  /// registerObject:visibility:
  void registerObject_visibility_(NSItemProviderWriting object,
      NSItemProviderRepresentationVisibility visibility) {
    objc.checkOsVersionInternal('NSItemProvider.registerObject:visibility:',
        iOS: (false, (11, 0, 0)), macOS: (false, (10, 13, 0)));
    _objc_msgSend_1k745tv(this.ref.pointer, _sel_registerObject_visibility_,
        object.ref.pointer, visibility.value);
  }

  /// registeredTypeIdentifiers
  NSArray get registeredTypeIdentifiers {
    objc.checkOsVersionInternal('NSItemProvider.registeredTypeIdentifiers',
        iOS: (false, (8, 0, 0)), macOS: (false, (10, 10, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.pointer, _sel_registeredTypeIdentifiers);
    return NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// registeredTypeIdentifiersWithFileOptions:
  NSArray registeredTypeIdentifiersWithFileOptions_(
      NSItemProviderFileOptions fileOptions) {
    objc.checkOsVersionInternal(
        'NSItemProvider.registeredTypeIdentifiersWithFileOptions:',
        iOS: (false, (11, 0, 0)),
        macOS: (false, (10, 13, 0)));
    final _ret = _objc_msgSend_7g3u2y(this.ref.pointer,
        _sel_registeredTypeIdentifiersWithFileOptions_, fileOptions.value);
    return NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// retain
  NSItemProvider retain() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_retain);
    return NSItemProvider.castFromPointer(_ret, retain: true, release: true);
  }

  /// self
  NSItemProvider self$1() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_self);
    return NSItemProvider.castFromPointer(_ret, retain: true, release: true);
  }

  /// setSuggestedName:
  set suggestedName(NSString? value) {
    objc.checkOsVersionInternal('NSItemProvider.setSuggestedName:',
        iOS: (false, (11, 0, 0)), macOS: (false, (10, 14, 0)));
    _objc_msgSend_xtuoz7(this.ref.pointer, _sel_setSuggestedName_,
        value?.ref.pointer ?? ffi.nullptr);
  }

  /// suggestedName
  NSString? get suggestedName {
    objc.checkOsVersionInternal('NSItemProvider.suggestedName',
        iOS: (false, (11, 0, 0)), macOS: (false, (10, 14, 0)));
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_suggestedName);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// Returns a new instance of NSItemProvider constructed with the default `new` method.
  factory NSItemProvider() => new$();
}

enum NSItemProviderFileOptions {
  NSItemProviderFileOptionOpenInPlace(1);

  final int value;
  const NSItemProviderFileOptions(this.value);

  static NSItemProviderFileOptions fromValue(int value) => switch (value) {
        1 => NSItemProviderFileOptionOpenInPlace,
        _ => throw ArgumentError(
            'Unknown value for NSItemProviderFileOptions: $value'),
      };
}

/// NSItemProviderReading
interface class NSItemProviderReading extends objc.ObjCProtocolBase
    implements NSObjectProtocol {
  NSItemProviderReading._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super(pointer, retain: retain, release: release);

  /// Constructs a [NSItemProviderReading] that points to the same underlying object as [other].
  NSItemProviderReading.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSItemProviderReading] that wraps the given raw object pointer.
  NSItemProviderReading.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSItemProviderReading].
  static bool conformsTo(objc.ObjCObjectBase obj) {
    return _objc_msgSend_e3qsqz(obj.ref.pointer, _sel_conformsToProtocol_,
        _protocol_NSItemProviderReading);
  }

  /// Returns the [objc.Protocol] object for this protocol.
  static objc.Protocol get $protocol =>
      objc.Protocol.castFromPointer(_protocol_NSItemProviderReading.cast());

  /// Builds an object that implements the NSItemProviderReading protocol. To implement
  /// multiple protocols, use [addToBuilder] or [objc.ObjCProtocolBuilder] directly.
  ///
  /// If `$keepIsolateAlive` is true, this protocol will keep this isolate
  /// alive until it is garbage collected by both Dart and ObjC.
  static NSItemProviderReading implement({bool $keepIsolateAlive = true}) {
    final builder =
        objc.ObjCProtocolBuilder(debugName: 'NSItemProviderReading');

    builder.addProtocol($protocol);
    return NSItemProviderReading.castFrom(
        builder.build(keepIsolateAlive: $keepIsolateAlive));
  }

  /// Adds the implementation of the NSItemProviderReading protocol to an existing
  /// [objc.ObjCProtocolBuilder].
  ///
  /// Note: You cannot call this method after you have called `builder.build`.
  static void addToBuilder(objc.ObjCProtocolBuilder builder,
      {bool $keepIsolateAlive = true}) {
    builder.addProtocol($protocol);
  }
}

enum NSItemProviderRepresentationVisibility {
  NSItemProviderRepresentationVisibilityAll(0),
  NSItemProviderRepresentationVisibilityTeam(1),
  NSItemProviderRepresentationVisibilityGroup(2),
  NSItemProviderRepresentationVisibilityOwnProcess(3);

  final int value;
  const NSItemProviderRepresentationVisibility(this.value);

  static NSItemProviderRepresentationVisibility fromValue(int value) =>
      switch (value) {
        0 => NSItemProviderRepresentationVisibilityAll,
        1 => NSItemProviderRepresentationVisibilityTeam,
        2 => NSItemProviderRepresentationVisibilityGroup,
        3 => NSItemProviderRepresentationVisibilityOwnProcess,
        _ => throw ArgumentError(
            'Unknown value for NSItemProviderRepresentationVisibility: $value'),
      };
}

/// NSItemProviderWriting
interface class NSItemProviderWriting extends objc.ObjCProtocolBase
    implements NSObjectProtocol {
  NSItemProviderWriting._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super(pointer, retain: retain, release: release);

  /// Constructs a [NSItemProviderWriting] that points to the same underlying object as [other].
  NSItemProviderWriting.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSItemProviderWriting] that wraps the given raw object pointer.
  NSItemProviderWriting.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSItemProviderWriting].
  static bool conformsTo(objc.ObjCObjectBase obj) {
    return _objc_msgSend_e3qsqz(obj.ref.pointer, _sel_conformsToProtocol_,
        _protocol_NSItemProviderWriting);
  }

  /// Returns the [objc.Protocol] object for this protocol.
  static objc.Protocol get $protocol =>
      objc.Protocol.castFromPointer(_protocol_NSItemProviderWriting.cast());

  /// Builds an object that implements the NSItemProviderWriting protocol. To implement
  /// multiple protocols, use [addToBuilder] or [objc.ObjCProtocolBuilder] directly.
  ///
  /// If `$keepIsolateAlive` is true, this protocol will keep this isolate
  /// alive until it is garbage collected by both Dart and ObjC.
  static NSItemProviderWriting implement(
      {NSItemProviderRepresentationVisibility Function(NSString)?
          itemProviderVisibilityForRepresentationWithTypeIdentifier_,
      NSArray Function()? writableTypeIdentifiersForItemProvider,
      bool $keepIsolateAlive = true}) {
    final builder =
        objc.ObjCProtocolBuilder(debugName: 'NSItemProviderWriting');
    NSItemProviderWriting
        .itemProviderVisibilityForRepresentationWithTypeIdentifier_
        .implement(builder,
            itemProviderVisibilityForRepresentationWithTypeIdentifier_);
    NSItemProviderWriting.writableTypeIdentifiersForItemProvider
        .implement(builder, writableTypeIdentifiersForItemProvider);
    builder.addProtocol($protocol);
    return NSItemProviderWriting.castFrom(
        builder.build(keepIsolateAlive: $keepIsolateAlive));
  }

  /// Adds the implementation of the NSItemProviderWriting protocol to an existing
  /// [objc.ObjCProtocolBuilder].
  ///
  /// Note: You cannot call this method after you have called `builder.build`.
  static void addToBuilder(objc.ObjCProtocolBuilder builder,
      {NSItemProviderRepresentationVisibility Function(NSString)?
          itemProviderVisibilityForRepresentationWithTypeIdentifier_,
      NSArray Function()? writableTypeIdentifiersForItemProvider,
      bool $keepIsolateAlive = true}) {
    NSItemProviderWriting
        .itemProviderVisibilityForRepresentationWithTypeIdentifier_
        .implement(builder,
            itemProviderVisibilityForRepresentationWithTypeIdentifier_);
    NSItemProviderWriting.writableTypeIdentifiersForItemProvider
        .implement(builder, writableTypeIdentifiersForItemProvider);
    builder.addProtocol($protocol);
  }

  /// itemProviderVisibilityForRepresentationWithTypeIdentifier:
  static final itemProviderVisibilityForRepresentationWithTypeIdentifier_ =
      objc.ObjCProtocolMethod<
          NSItemProviderRepresentationVisibility Function(NSString)>(
    _protocol_NSItemProviderWriting,
    _sel_itemProviderVisibilityForRepresentationWithTypeIdentifier_,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.Long Function(ffi.Pointer<objc.ObjCObject>,
                        ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>>(
            _ObjectiveCBindings_protocolTrampoline_1ldqghh)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSItemProviderWriting,
      _sel_itemProviderVisibilityForRepresentationWithTypeIdentifier_,
      isRequired: false,
      isInstanceMethod: true,
    ),
    (NSItemProviderRepresentationVisibility Function(NSString) func) =>
        ObjCBlock_NSItemProviderRepresentationVisibility_ffiVoid_NSString
            .fromFunction(
                (ffi.Pointer<ffi.Void> _, NSString arg1) => func(arg1)),
  );

  /// writableTypeIdentifiersForItemProvider
  static final writableTypeIdentifiersForItemProvider =
      objc.ObjCProtocolMethod<NSArray Function()>(
    _protocol_NSItemProviderWriting,
    _sel_writableTypeIdentifiersForItemProvider,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.Pointer<objc.ObjCObject> Function(
                        ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>)>>(
            _ObjectiveCBindings_protocolTrampoline_1mbt9g9)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSItemProviderWriting,
      _sel_writableTypeIdentifiersForItemProvider,
      isRequired: false,
      isInstanceMethod: true,
    ),
    (NSArray Function() func) => ObjCBlock_NSArray_ffiVoid.fromFunction((
      ffi.Pointer<ffi.Void> _,
    ) =>
        func()),
  );
}

enum NSKeyValueChange {
  NSKeyValueChangeSetting(1),
  NSKeyValueChangeInsertion(2),
  NSKeyValueChangeRemoval(3),
  NSKeyValueChangeReplacement(4);

  final int value;
  const NSKeyValueChange(this.value);

  static NSKeyValueChange fromValue(int value) => switch (value) {
        1 => NSKeyValueChangeSetting,
        2 => NSKeyValueChangeInsertion,
        3 => NSKeyValueChangeRemoval,
        4 => NSKeyValueChangeReplacement,
        _ => throw ArgumentError('Unknown value for NSKeyValueChange: $value'),
      };
}

enum NSKeyValueObservingOptions {
  NSKeyValueObservingOptionNew(1),
  NSKeyValueObservingOptionOld(2),
  NSKeyValueObservingOptionInitial(4),
  NSKeyValueObservingOptionPrior(8);

  final int value;
  const NSKeyValueObservingOptions(this.value);

  static NSKeyValueObservingOptions fromValue(int value) => switch (value) {
        1 => NSKeyValueObservingOptionNew,
        2 => NSKeyValueObservingOptionOld,
        4 => NSKeyValueObservingOptionInitial,
        8 => NSKeyValueObservingOptionPrior,
        _ => throw ArgumentError(
            'Unknown value for NSKeyValueObservingOptions: $value'),
      };
}

enum NSKeyValueSetMutationKind {
  NSKeyValueUnionSetMutation(1),
  NSKeyValueMinusSetMutation(2),
  NSKeyValueIntersectSetMutation(3),
  NSKeyValueSetSetMutation(4);

  final int value;
  const NSKeyValueSetMutationKind(this.value);

  static NSKeyValueSetMutationKind fromValue(int value) => switch (value) {
        1 => NSKeyValueUnionSetMutation,
        2 => NSKeyValueMinusSetMutation,
        3 => NSKeyValueIntersectSetMutation,
        4 => NSKeyValueSetSetMutation,
        _ => throw ArgumentError(
            'Unknown value for NSKeyValueSetMutationKind: $value'),
      };
}

/// NSLocale
class NSLocale extends objc.ObjCObjectBase {
  NSLocale._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super(pointer, retain: retain, release: release);

  /// Constructs a [NSLocale] that points to the same underlying object as [other].
  NSLocale.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSLocale] that wraps the given raw object pointer.
  NSLocale.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSLocale].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSLocale);
  }
}

/// NSMethodSignature
class NSMethodSignature extends NSObject {
  NSMethodSignature._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSMethodSignature] that points to the same underlying object as [other].
  NSMethodSignature.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSMethodSignature] that wraps the given raw object pointer.
  NSMethodSignature.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSMethodSignature].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSMethodSignature);
  }

  /// alloc
  static NSMethodSignature alloc() {
    final _ret = _objc_msgSend_151sglz(_class_NSMethodSignature, _sel_alloc);
    return NSMethodSignature.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// allocWithZone:
  static NSMethodSignature allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret = _objc_msgSend_1cwp428(
        _class_NSMethodSignature, _sel_allocWithZone_, zone);
    return NSMethodSignature.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// new
  static NSMethodSignature new$() {
    final _ret = _objc_msgSend_151sglz(_class_NSMethodSignature, _sel_new);
    return NSMethodSignature.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// signatureWithObjCTypes:
  static NSMethodSignature? signatureWithObjCTypes_(
      ffi.Pointer<ffi.Char> types) {
    final _ret = _objc_msgSend_56zxyn(
        _class_NSMethodSignature, _sel_signatureWithObjCTypes_, types);
    return _ret.address == 0
        ? null
        : NSMethodSignature.castFromPointer(_ret, retain: true, release: true);
  }

  /// frameLength
  int get frameLength {
    return _objc_msgSend_xw2lbc(this.ref.pointer, _sel_frameLength);
  }

  /// getArgumentTypeAtIndex:
  ffi.Pointer<ffi.Char> getArgumentTypeAtIndex_(int idx) {
    return _objc_msgSend_1jtxufi(
        this.ref.pointer, _sel_getArgumentTypeAtIndex_, idx);
  }

  /// init
  NSMethodSignature init() {
    objc.checkOsVersionInternal('NSMethodSignature.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSMethodSignature.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// isOneway
  bool isOneway() {
    return _objc_msgSend_91o635(this.ref.pointer, _sel_isOneway);
  }

  /// methodReturnLength
  int get methodReturnLength {
    return _objc_msgSend_xw2lbc(this.ref.pointer, _sel_methodReturnLength);
  }

  /// methodReturnType
  ffi.Pointer<ffi.Char> get methodReturnType {
    return _objc_msgSend_1fuqfwb(this.ref.pointer, _sel_methodReturnType);
  }

  /// numberOfArguments
  int get numberOfArguments {
    return _objc_msgSend_xw2lbc(this.ref.pointer, _sel_numberOfArguments);
  }

  /// Returns a new instance of NSMethodSignature constructed with the default `new` method.
  factory NSMethodSignature() => new$();
}

/// NSMutableArray
class NSMutableArray extends NSArray {
  NSMutableArray._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSMutableArray] that points to the same underlying object as [other].
  NSMutableArray.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSMutableArray] that wraps the given raw object pointer.
  NSMutableArray.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSMutableArray].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSMutableArray);
  }

  /// alloc
  static NSMutableArray alloc() {
    final _ret = _objc_msgSend_151sglz(_class_NSMutableArray, _sel_alloc);
    return NSMutableArray.castFromPointer(_ret, retain: false, release: true);
  }

  /// allocWithZone:
  static NSMutableArray allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret =
        _objc_msgSend_1cwp428(_class_NSMutableArray, _sel_allocWithZone_, zone);
    return NSMutableArray.castFromPointer(_ret, retain: false, release: true);
  }

  /// array
  static NSMutableArray array() {
    final _ret = _objc_msgSend_151sglz(_class_NSMutableArray, _sel_array);
    return NSMutableArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// arrayWithArray:
  static NSMutableArray arrayWithArray_(NSArray array) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSMutableArray, _sel_arrayWithArray_, array.ref.pointer);
    return NSMutableArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// arrayWithCapacity:
  static NSMutableArray arrayWithCapacity_(int numItems) {
    final _ret = _objc_msgSend_14hpxwa(
        _class_NSMutableArray, _sel_arrayWithCapacity_, numItems);
    return NSMutableArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// arrayWithObject:
  static NSMutableArray arrayWithObject_(objc.ObjCObjectBase anObject) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSMutableArray, _sel_arrayWithObject_, anObject.ref.pointer);
    return NSMutableArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// arrayWithObjects:
  static NSMutableArray arrayWithObjects_(objc.ObjCObjectBase firstObj) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSMutableArray, _sel_arrayWithObjects_, firstObj.ref.pointer);
    return NSMutableArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// arrayWithObjects:count:
  static NSMutableArray arrayWithObjects_count_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects, int cnt) {
    final _ret = _objc_msgSend_zmbtbd(
        _class_NSMutableArray, _sel_arrayWithObjects_count_, objects, cnt);
    return NSMutableArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// new
  static NSMutableArray new$() {
    final _ret = _objc_msgSend_151sglz(_class_NSMutableArray, _sel_new);
    return NSMutableArray.castFromPointer(_ret, retain: false, release: true);
  }

  /// supportsSecureCoding
  static bool getSupportsSecureCoding() {
    return _objc_msgSend_91o635(
        _class_NSMutableArray, _sel_supportsSecureCoding);
  }

  /// addObject:
  void addObject_(objc.ObjCObjectBase anObject) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_addObject_, anObject.ref.pointer);
  }

  /// init
  NSMutableArray init() {
    objc.checkOsVersionInternal('NSMutableArray.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSMutableArray.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithArray:
  NSMutableArray initWithArray_(NSArray array) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithArray_, array.ref.pointer);
    return NSMutableArray.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithArray:copyItems:
  NSMutableArray initWithArray_copyItems_(NSArray array, bool flag) {
    final _ret = _objc_msgSend_17amj0z(this.ref.retainAndReturnPointer(),
        _sel_initWithArray_copyItems_, array.ref.pointer, flag);
    return NSMutableArray.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithCapacity:
  NSMutableArray initWithCapacity_(int numItems) {
    final _ret = _objc_msgSend_14hpxwa(
        this.ref.retainAndReturnPointer(), _sel_initWithCapacity_, numItems);
    return NSMutableArray.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithCoder:
  NSMutableArray? initWithCoder_(NSCoder coder) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithCoder_, coder.ref.pointer);
    return _ret.address == 0
        ? null
        : NSMutableArray.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithObjects:
  NSMutableArray initWithObjects_(objc.ObjCObjectBase firstObj) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithObjects_, firstObj.ref.pointer);
    return NSMutableArray.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithObjects:count:
  NSMutableArray initWithObjects_count_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects, int cnt) {
    final _ret = _objc_msgSend_zmbtbd(this.ref.retainAndReturnPointer(),
        _sel_initWithObjects_count_, objects, cnt);
    return NSMutableArray.castFromPointer(_ret, retain: false, release: true);
  }

  /// insertObject:atIndex:
  void insertObject_atIndex_(objc.ObjCObjectBase anObject, int index) {
    _objc_msgSend_djsa9o(this.ref.pointer, _sel_insertObject_atIndex_,
        anObject.ref.pointer, index);
  }

  /// removeLastObject
  void removeLastObject() {
    _objc_msgSend_1pl9qdv(this.ref.pointer, _sel_removeLastObject);
  }

  /// removeObjectAtIndex:
  void removeObjectAtIndex_(int index) {
    _objc_msgSend_1i9r4xy(this.ref.pointer, _sel_removeObjectAtIndex_, index);
  }

  /// replaceObjectAtIndex:withObject:
  void replaceObjectAtIndex_withObject_(
      int index, objc.ObjCObjectBase anObject) {
    _objc_msgSend_1gypgok(this.ref.pointer,
        _sel_replaceObjectAtIndex_withObject_, index, anObject.ref.pointer);
  }

  /// Returns a new instance of NSMutableArray constructed with the default `new` method.
  factory NSMutableArray() => new$();
}

/// NSMutableCopying
interface class NSMutableCopying extends objc.ObjCProtocolBase {
  NSMutableCopying._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super(pointer, retain: retain, release: release);

  /// Constructs a [NSMutableCopying] that points to the same underlying object as [other].
  NSMutableCopying.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSMutableCopying] that wraps the given raw object pointer.
  NSMutableCopying.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSMutableCopying].
  static bool conformsTo(objc.ObjCObjectBase obj) {
    return _objc_msgSend_e3qsqz(
        obj.ref.pointer, _sel_conformsToProtocol_, _protocol_NSMutableCopying);
  }

  /// Returns the [objc.Protocol] object for this protocol.
  static objc.Protocol get $protocol =>
      objc.Protocol.castFromPointer(_protocol_NSMutableCopying.cast());

  /// Builds an object that implements the NSMutableCopying protocol. To implement
  /// multiple protocols, use [addToBuilder] or [objc.ObjCProtocolBuilder] directly.
  ///
  /// If `$keepIsolateAlive` is true, this protocol will keep this isolate
  /// alive until it is garbage collected by both Dart and ObjC.
  static NSMutableCopying implement(
      {required objc.ObjCObjectBase Function(ffi.Pointer<NSZone>)
          mutableCopyWithZone_,
      bool $keepIsolateAlive = true}) {
    final builder = objc.ObjCProtocolBuilder(debugName: 'NSMutableCopying');
    NSMutableCopying.mutableCopyWithZone_
        .implement(builder, mutableCopyWithZone_);
    builder.addProtocol($protocol);
    return NSMutableCopying.castFrom(
        builder.build(keepIsolateAlive: $keepIsolateAlive));
  }

  /// Adds the implementation of the NSMutableCopying protocol to an existing
  /// [objc.ObjCProtocolBuilder].
  ///
  /// Note: You cannot call this method after you have called `builder.build`.
  static void addToBuilder(objc.ObjCProtocolBuilder builder,
      {required objc.ObjCObjectBase Function(ffi.Pointer<NSZone>)
          mutableCopyWithZone_,
      bool $keepIsolateAlive = true}) {
    NSMutableCopying.mutableCopyWithZone_
        .implement(builder, mutableCopyWithZone_);
    builder.addProtocol($protocol);
  }

  /// mutableCopyWithZone:
  static final mutableCopyWithZone_ = objc.ObjCProtocolMethod<
      objc.ObjCObjectBase Function(ffi.Pointer<NSZone>)>(
    _protocol_NSMutableCopying,
    _sel_mutableCopyWithZone_,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.Pointer<objc.ObjCObject> Function(
                        ffi.Pointer<objc.ObjCObject>,
                        ffi.Pointer<ffi.Void>,
                        ffi.Pointer<NSZone>)>>(
            _ObjectiveCBindings_protocolTrampoline_18nsem0)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSMutableCopying,
      _sel_mutableCopyWithZone_,
      isRequired: true,
      isInstanceMethod: true,
    ),
    (objc.ObjCObjectBase Function(ffi.Pointer<NSZone>) func) =>
        ObjCBlock_objcObjCObject_ffiVoid_NSZone.fromFunction(
            (ffi.Pointer<ffi.Void> _, ffi.Pointer<NSZone> arg1) => func(arg1)),
  );
}

/// NSMutableData
class NSMutableData extends NSData {
  NSMutableData._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSMutableData] that points to the same underlying object as [other].
  NSMutableData.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSMutableData] that wraps the given raw object pointer.
  NSMutableData.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSMutableData].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSMutableData);
  }

  /// alloc
  static NSMutableData alloc() {
    final _ret = _objc_msgSend_151sglz(_class_NSMutableData, _sel_alloc);
    return NSMutableData.castFromPointer(_ret, retain: false, release: true);
  }

  /// allocWithZone:
  static NSMutableData allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret =
        _objc_msgSend_1cwp428(_class_NSMutableData, _sel_allocWithZone_, zone);
    return NSMutableData.castFromPointer(_ret, retain: false, release: true);
  }

  /// data
  static NSMutableData data() {
    final _ret = _objc_msgSend_151sglz(_class_NSMutableData, _sel_data);
    return NSMutableData.castFromPointer(_ret, retain: true, release: true);
  }

  /// dataWithBytes:length:
  static NSMutableData dataWithBytes_length_(
      ffi.Pointer<ffi.Void> bytes, int length) {
    final _ret = _objc_msgSend_3nbx5e(
        _class_NSMutableData, _sel_dataWithBytes_length_, bytes, length);
    return NSMutableData.castFromPointer(_ret, retain: true, release: true);
  }

  /// dataWithBytesNoCopy:length:
  static NSMutableData dataWithBytesNoCopy_length_(
      ffi.Pointer<ffi.Void> bytes, int length) {
    final _ret = _objc_msgSend_3nbx5e(
        _class_NSMutableData, _sel_dataWithBytesNoCopy_length_, bytes, length);
    return NSMutableData.castFromPointer(_ret, retain: true, release: true);
  }

  /// dataWithBytesNoCopy:length:freeWhenDone:
  static NSMutableData dataWithBytesNoCopy_length_freeWhenDone_(
      ffi.Pointer<ffi.Void> bytes, int length, bool b) {
    final _ret = _objc_msgSend_161ne8y(_class_NSMutableData,
        _sel_dataWithBytesNoCopy_length_freeWhenDone_, bytes, length, b);
    return NSMutableData.castFromPointer(_ret, retain: true, release: true);
  }

  /// dataWithCapacity:
  static NSMutableData? dataWithCapacity_(int aNumItems) {
    final _ret = _objc_msgSend_14hpxwa(
        _class_NSMutableData, _sel_dataWithCapacity_, aNumItems);
    return _ret.address == 0
        ? null
        : NSMutableData.castFromPointer(_ret, retain: true, release: true);
  }

  /// dataWithContentsOfFile:
  static NSMutableData? dataWithContentsOfFile_(NSString path) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSMutableData, _sel_dataWithContentsOfFile_, path.ref.pointer);
    return _ret.address == 0
        ? null
        : NSMutableData.castFromPointer(_ret, retain: true, release: true);
  }

  /// dataWithContentsOfFile:options:error:
  static NSMutableData? dataWithContentsOfFile_options_error_(
      NSString path,
      NSDataReadingOptions readOptionsMask,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> errorPtr) {
    final _ret = _objc_msgSend_8321cp(
        _class_NSMutableData,
        _sel_dataWithContentsOfFile_options_error_,
        path.ref.pointer,
        readOptionsMask.value,
        errorPtr);
    return _ret.address == 0
        ? null
        : NSMutableData.castFromPointer(_ret, retain: true, release: true);
  }

  /// dataWithContentsOfURL:
  static NSMutableData? dataWithContentsOfURL_(NSURL url) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSMutableData, _sel_dataWithContentsOfURL_, url.ref.pointer);
    return _ret.address == 0
        ? null
        : NSMutableData.castFromPointer(_ret, retain: true, release: true);
  }

  /// dataWithContentsOfURL:options:error:
  static NSMutableData? dataWithContentsOfURL_options_error_(
      NSURL url,
      NSDataReadingOptions readOptionsMask,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> errorPtr) {
    final _ret = _objc_msgSend_8321cp(
        _class_NSMutableData,
        _sel_dataWithContentsOfURL_options_error_,
        url.ref.pointer,
        readOptionsMask.value,
        errorPtr);
    return _ret.address == 0
        ? null
        : NSMutableData.castFromPointer(_ret, retain: true, release: true);
  }

  /// dataWithData:
  static NSMutableData dataWithData_(NSData data) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSMutableData, _sel_dataWithData_, data.ref.pointer);
    return NSMutableData.castFromPointer(_ret, retain: true, release: true);
  }

  /// dataWithLength:
  static NSMutableData? dataWithLength_(int length) {
    final _ret = _objc_msgSend_14hpxwa(
        _class_NSMutableData, _sel_dataWithLength_, length);
    return _ret.address == 0
        ? null
        : NSMutableData.castFromPointer(_ret, retain: true, release: true);
  }

  /// new
  static NSMutableData new$() {
    final _ret = _objc_msgSend_151sglz(_class_NSMutableData, _sel_new);
    return NSMutableData.castFromPointer(_ret, retain: false, release: true);
  }

  /// supportsSecureCoding
  static bool getSupportsSecureCoding() {
    return _objc_msgSend_91o635(
        _class_NSMutableData, _sel_supportsSecureCoding);
  }

  /// compressedDataUsingAlgorithm:error:
  ///
  /// iOS: introduced 13.0.0
  /// macOS: introduced 10.15.0
  NSMutableData? compressedDataUsingAlgorithm_error_(
      NSDataCompressionAlgorithm algorithm,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    objc.checkOsVersionInternal(
        'NSMutableData.compressedDataUsingAlgorithm:error:',
        iOS: (false, (13, 0, 0)),
        macOS: (false, (10, 15, 0)));
    final _ret = _objc_msgSend_1vnlaqg(this.ref.pointer,
        _sel_compressedDataUsingAlgorithm_error_, algorithm.value, error);
    return _ret.address == 0
        ? null
        : NSMutableData.castFromPointer(_ret, retain: true, release: true);
  }

  /// decompressedDataUsingAlgorithm:error:
  ///
  /// iOS: introduced 13.0.0
  /// macOS: introduced 10.15.0
  NSMutableData? decompressedDataUsingAlgorithm_error_(
      NSDataCompressionAlgorithm algorithm,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    objc.checkOsVersionInternal(
        'NSMutableData.decompressedDataUsingAlgorithm:error:',
        iOS: (false, (13, 0, 0)),
        macOS: (false, (10, 15, 0)));
    final _ret = _objc_msgSend_1vnlaqg(this.ref.pointer,
        _sel_decompressedDataUsingAlgorithm_error_, algorithm.value, error);
    return _ret.address == 0
        ? null
        : NSMutableData.castFromPointer(_ret, retain: true, release: true);
  }

  /// init
  NSMutableData init() {
    objc.checkOsVersionInternal('NSMutableData.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSMutableData.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithBase64EncodedData:options:
  NSMutableData? initWithBase64EncodedData_options_(
      NSData base64Data, NSDataBase64DecodingOptions options) {
    objc.checkOsVersionInternal(
        'NSMutableData.initWithBase64EncodedData:options:',
        iOS: (false, (7, 0, 0)),
        macOS: (false, (10, 9, 0)));
    final _ret = _objc_msgSend_7kpg7m(
        this.ref.retainAndReturnPointer(),
        _sel_initWithBase64EncodedData_options_,
        base64Data.ref.pointer,
        options.value);
    return _ret.address == 0
        ? null
        : NSMutableData.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithBase64EncodedString:options:
  NSMutableData? initWithBase64EncodedString_options_(
      NSString base64String, NSDataBase64DecodingOptions options) {
    objc.checkOsVersionInternal(
        'NSMutableData.initWithBase64EncodedString:options:',
        iOS: (false, (7, 0, 0)),
        macOS: (false, (10, 9, 0)));
    final _ret = _objc_msgSend_7kpg7m(
        this.ref.retainAndReturnPointer(),
        _sel_initWithBase64EncodedString_options_,
        base64String.ref.pointer,
        options.value);
    return _ret.address == 0
        ? null
        : NSMutableData.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithBytes:length:
  NSMutableData initWithBytes_length_(ffi.Pointer<ffi.Void> bytes, int length) {
    final _ret = _objc_msgSend_3nbx5e(this.ref.retainAndReturnPointer(),
        _sel_initWithBytes_length_, bytes, length);
    return NSMutableData.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithBytesNoCopy:length:
  NSMutableData initWithBytesNoCopy_length_(
      ffi.Pointer<ffi.Void> bytes, int length) {
    final _ret = _objc_msgSend_3nbx5e(this.ref.retainAndReturnPointer(),
        _sel_initWithBytesNoCopy_length_, bytes, length);
    return NSMutableData.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithBytesNoCopy:length:freeWhenDone:
  NSMutableData initWithBytesNoCopy_length_freeWhenDone_(
      ffi.Pointer<ffi.Void> bytes, int length, bool b) {
    final _ret = _objc_msgSend_161ne8y(this.ref.retainAndReturnPointer(),
        _sel_initWithBytesNoCopy_length_freeWhenDone_, bytes, length, b);
    return NSMutableData.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithCapacity:
  NSMutableData? initWithCapacity_(int capacity) {
    final _ret = _objc_msgSend_14hpxwa(
        this.ref.retainAndReturnPointer(), _sel_initWithCapacity_, capacity);
    return _ret.address == 0
        ? null
        : NSMutableData.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithCoder:
  NSMutableData? initWithCoder_(NSCoder coder) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithCoder_, coder.ref.pointer);
    return _ret.address == 0
        ? null
        : NSMutableData.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithContentsOfFile:
  NSMutableData? initWithContentsOfFile_(NSString path) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithContentsOfFile_, path.ref.pointer);
    return _ret.address == 0
        ? null
        : NSMutableData.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithContentsOfFile:options:error:
  NSMutableData? initWithContentsOfFile_options_error_(
      NSString path,
      NSDataReadingOptions readOptionsMask,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> errorPtr) {
    final _ret = _objc_msgSend_8321cp(
        this.ref.retainAndReturnPointer(),
        _sel_initWithContentsOfFile_options_error_,
        path.ref.pointer,
        readOptionsMask.value,
        errorPtr);
    return _ret.address == 0
        ? null
        : NSMutableData.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithContentsOfURL:
  NSMutableData? initWithContentsOfURL_(NSURL url) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithContentsOfURL_, url.ref.pointer);
    return _ret.address == 0
        ? null
        : NSMutableData.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithContentsOfURL:options:error:
  NSMutableData? initWithContentsOfURL_options_error_(
      NSURL url,
      NSDataReadingOptions readOptionsMask,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> errorPtr) {
    final _ret = _objc_msgSend_8321cp(
        this.ref.retainAndReturnPointer(),
        _sel_initWithContentsOfURL_options_error_,
        url.ref.pointer,
        readOptionsMask.value,
        errorPtr);
    return _ret.address == 0
        ? null
        : NSMutableData.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithData:
  NSMutableData initWithData_(NSData data) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithData_, data.ref.pointer);
    return NSMutableData.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithLength:
  NSMutableData? initWithLength_(int length) {
    final _ret = _objc_msgSend_14hpxwa(
        this.ref.retainAndReturnPointer(), _sel_initWithLength_, length);
    return _ret.address == 0
        ? null
        : NSMutableData.castFromPointer(_ret, retain: false, release: true);
  }

  /// length
  int get length {
    return _objc_msgSend_xw2lbc(this.ref.pointer, _sel_length);
  }

  /// mutableBytes
  ffi.Pointer<ffi.Void> get mutableBytes {
    return _objc_msgSend_6ex6p5(this.ref.pointer, _sel_mutableBytes);
  }

  /// setLength:
  set length(int value) {
    _objc_msgSend_1i9r4xy(this.ref.pointer, _sel_setLength_, value);
  }

  /// Returns a new instance of NSMutableData constructed with the default `new` method.
  factory NSMutableData() => new$();
}

/// NSMutableDictionary
class NSMutableDictionary extends NSDictionary {
  NSMutableDictionary._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSMutableDictionary] that points to the same underlying object as [other].
  NSMutableDictionary.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSMutableDictionary] that wraps the given raw object pointer.
  NSMutableDictionary.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSMutableDictionary].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSMutableDictionary);
  }

  /// alloc
  static NSMutableDictionary alloc() {
    final _ret = _objc_msgSend_151sglz(_class_NSMutableDictionary, _sel_alloc);
    return NSMutableDictionary.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// allocWithZone:
  static NSMutableDictionary allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret = _objc_msgSend_1cwp428(
        _class_NSMutableDictionary, _sel_allocWithZone_, zone);
    return NSMutableDictionary.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// dictionary
  static NSMutableDictionary dictionary() {
    final _ret =
        _objc_msgSend_151sglz(_class_NSMutableDictionary, _sel_dictionary);
    return NSMutableDictionary.castFromPointer(_ret,
        retain: true, release: true);
  }

  /// dictionaryWithCapacity:
  static NSMutableDictionary dictionaryWithCapacity_(int numItems) {
    final _ret = _objc_msgSend_14hpxwa(
        _class_NSMutableDictionary, _sel_dictionaryWithCapacity_, numItems);
    return NSMutableDictionary.castFromPointer(_ret,
        retain: true, release: true);
  }

  /// dictionaryWithDictionary:
  static NSMutableDictionary dictionaryWithDictionary_(NSDictionary dict) {
    final _ret = _objc_msgSend_1sotr3r(_class_NSMutableDictionary,
        _sel_dictionaryWithDictionary_, dict.ref.pointer);
    return NSMutableDictionary.castFromPointer(_ret,
        retain: true, release: true);
  }

  /// dictionaryWithObject:forKey:
  static NSMutableDictionary dictionaryWithObject_forKey_(
      objc.ObjCObjectBase object, NSCopying key) {
    final _ret = _objc_msgSend_15qeuct(_class_NSMutableDictionary,
        _sel_dictionaryWithObject_forKey_, object.ref.pointer, key.ref.pointer);
    return NSMutableDictionary.castFromPointer(_ret,
        retain: true, release: true);
  }

  /// dictionaryWithObjects:forKeys:
  static NSMutableDictionary dictionaryWithObjects_forKeys_(
      NSArray objects, NSArray keys) {
    final _ret = _objc_msgSend_15qeuct(
        _class_NSMutableDictionary,
        _sel_dictionaryWithObjects_forKeys_,
        objects.ref.pointer,
        keys.ref.pointer);
    return NSMutableDictionary.castFromPointer(_ret,
        retain: true, release: true);
  }

  /// dictionaryWithObjects:forKeys:count:
  static NSMutableDictionary dictionaryWithObjects_forKeys_count_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> keys,
      int cnt) {
    final _ret = _objc_msgSend_1dydpdi(_class_NSMutableDictionary,
        _sel_dictionaryWithObjects_forKeys_count_, objects, keys, cnt);
    return NSMutableDictionary.castFromPointer(_ret,
        retain: true, release: true);
  }

  /// dictionaryWithObjectsAndKeys:
  static NSMutableDictionary dictionaryWithObjectsAndKeys_(
      objc.ObjCObjectBase firstObject) {
    final _ret = _objc_msgSend_1sotr3r(_class_NSMutableDictionary,
        _sel_dictionaryWithObjectsAndKeys_, firstObject.ref.pointer);
    return NSMutableDictionary.castFromPointer(_ret,
        retain: true, release: true);
  }

  /// new
  static NSMutableDictionary new$() {
    final _ret = _objc_msgSend_151sglz(_class_NSMutableDictionary, _sel_new);
    return NSMutableDictionary.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// supportsSecureCoding
  static bool getSupportsSecureCoding() {
    return _objc_msgSend_91o635(
        _class_NSMutableDictionary, _sel_supportsSecureCoding);
  }

  /// init
  NSMutableDictionary init() {
    objc.checkOsVersionInternal('NSMutableDictionary.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSMutableDictionary.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// initWithCapacity:
  NSMutableDictionary initWithCapacity_(int numItems) {
    final _ret = _objc_msgSend_14hpxwa(
        this.ref.retainAndReturnPointer(), _sel_initWithCapacity_, numItems);
    return NSMutableDictionary.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// initWithCoder:
  NSMutableDictionary? initWithCoder_(NSCoder coder) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithCoder_, coder.ref.pointer);
    return _ret.address == 0
        ? null
        : NSMutableDictionary.castFromPointer(_ret,
            retain: false, release: true);
  }

  /// initWithDictionary:
  NSMutableDictionary initWithDictionary_(NSDictionary otherDictionary) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithDictionary_, otherDictionary.ref.pointer);
    return NSMutableDictionary.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// initWithDictionary:copyItems:
  NSMutableDictionary initWithDictionary_copyItems_(
      NSDictionary otherDictionary, bool flag) {
    final _ret = _objc_msgSend_17amj0z(this.ref.retainAndReturnPointer(),
        _sel_initWithDictionary_copyItems_, otherDictionary.ref.pointer, flag);
    return NSMutableDictionary.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// initWithObjects:forKeys:
  NSMutableDictionary initWithObjects_forKeys_(NSArray objects, NSArray keys) {
    final _ret = _objc_msgSend_15qeuct(this.ref.retainAndReturnPointer(),
        _sel_initWithObjects_forKeys_, objects.ref.pointer, keys.ref.pointer);
    return NSMutableDictionary.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// initWithObjects:forKeys:count:
  NSMutableDictionary initWithObjects_forKeys_count_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> keys,
      int cnt) {
    final _ret = _objc_msgSend_1dydpdi(this.ref.retainAndReturnPointer(),
        _sel_initWithObjects_forKeys_count_, objects, keys, cnt);
    return NSMutableDictionary.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// initWithObjectsAndKeys:
  NSMutableDictionary initWithObjectsAndKeys_(objc.ObjCObjectBase firstObject) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithObjectsAndKeys_, firstObject.ref.pointer);
    return NSMutableDictionary.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// removeObjectForKey:
  void removeObjectForKey_(objc.ObjCObjectBase aKey) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_removeObjectForKey_, aKey.ref.pointer);
  }

  /// setObject:forKey:
  void setObject_forKey_(objc.ObjCObjectBase anObject, NSCopying aKey) {
    _objc_msgSend_pfv6jd(this.ref.pointer, _sel_setObject_forKey_,
        anObject.ref.pointer, aKey.ref.pointer);
  }

  /// Returns a new instance of NSMutableDictionary constructed with the default `new` method.
  factory NSMutableDictionary() => new$();
}

/// NSMutableIndexSet
class NSMutableIndexSet extends NSIndexSet {
  NSMutableIndexSet._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSMutableIndexSet] that points to the same underlying object as [other].
  NSMutableIndexSet.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSMutableIndexSet] that wraps the given raw object pointer.
  NSMutableIndexSet.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSMutableIndexSet].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSMutableIndexSet);
  }

  /// alloc
  static NSMutableIndexSet alloc() {
    final _ret = _objc_msgSend_151sglz(_class_NSMutableIndexSet, _sel_alloc);
    return NSMutableIndexSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// allocWithZone:
  static NSMutableIndexSet allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret = _objc_msgSend_1cwp428(
        _class_NSMutableIndexSet, _sel_allocWithZone_, zone);
    return NSMutableIndexSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// indexSet
  static NSMutableIndexSet indexSet() {
    final _ret = _objc_msgSend_151sglz(_class_NSMutableIndexSet, _sel_indexSet);
    return NSMutableIndexSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// indexSetWithIndex:
  static NSMutableIndexSet indexSetWithIndex_(int value) {
    final _ret = _objc_msgSend_14hpxwa(
        _class_NSMutableIndexSet, _sel_indexSetWithIndex_, value);
    return NSMutableIndexSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// indexSetWithIndexesInRange:
  static NSMutableIndexSet indexSetWithIndexesInRange_(NSRange range) {
    final _ret = _objc_msgSend_1k1o1s7(
        _class_NSMutableIndexSet, _sel_indexSetWithIndexesInRange_, range);
    return NSMutableIndexSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// new
  static NSMutableIndexSet new$() {
    final _ret = _objc_msgSend_151sglz(_class_NSMutableIndexSet, _sel_new);
    return NSMutableIndexSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// supportsSecureCoding
  static bool getSupportsSecureCoding() {
    return _objc_msgSend_91o635(
        _class_NSMutableIndexSet, _sel_supportsSecureCoding);
  }

  /// addIndex:
  void addIndex_(int value) {
    _objc_msgSend_1i9r4xy(this.ref.pointer, _sel_addIndex_, value);
  }

  /// addIndexes:
  void addIndexes_(NSIndexSet indexSet) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_addIndexes_, indexSet.ref.pointer);
  }

  /// addIndexesInRange:
  void addIndexesInRange_(NSRange range) {
    _objc_msgSend_1e3pm0z(this.ref.pointer, _sel_addIndexesInRange_, range);
  }

  /// init
  NSMutableIndexSet init() {
    objc.checkOsVersionInternal('NSMutableIndexSet.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSMutableIndexSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// initWithCoder:
  NSMutableIndexSet? initWithCoder_(NSCoder coder) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithCoder_, coder.ref.pointer);
    return _ret.address == 0
        ? null
        : NSMutableIndexSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithIndex:
  NSMutableIndexSet initWithIndex_(int value) {
    final _ret = _objc_msgSend_14hpxwa(
        this.ref.retainAndReturnPointer(), _sel_initWithIndex_, value);
    return NSMutableIndexSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// initWithIndexSet:
  NSMutableIndexSet initWithIndexSet_(NSIndexSet indexSet) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithIndexSet_, indexSet.ref.pointer);
    return NSMutableIndexSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// initWithIndexesInRange:
  NSMutableIndexSet initWithIndexesInRange_(NSRange range) {
    final _ret = _objc_msgSend_1k1o1s7(
        this.ref.retainAndReturnPointer(), _sel_initWithIndexesInRange_, range);
    return NSMutableIndexSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// removeAllIndexes
  void removeAllIndexes() {
    _objc_msgSend_1pl9qdv(this.ref.pointer, _sel_removeAllIndexes);
  }

  /// removeIndex:
  void removeIndex_(int value) {
    _objc_msgSend_1i9r4xy(this.ref.pointer, _sel_removeIndex_, value);
  }

  /// removeIndexes:
  void removeIndexes_(NSIndexSet indexSet) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_removeIndexes_, indexSet.ref.pointer);
  }

  /// removeIndexesInRange:
  void removeIndexesInRange_(NSRange range) {
    _objc_msgSend_1e3pm0z(this.ref.pointer, _sel_removeIndexesInRange_, range);
  }

  /// shiftIndexesStartingAtIndex:by:
  void shiftIndexesStartingAtIndex_by_(int index, int delta) {
    _objc_msgSend_otx1t4(
        this.ref.pointer, _sel_shiftIndexesStartingAtIndex_by_, index, delta);
  }

  /// Returns a new instance of NSMutableIndexSet constructed with the default `new` method.
  factory NSMutableIndexSet() => new$();
}

/// NSMutableOrderedSet
class NSMutableOrderedSet extends NSOrderedSet {
  NSMutableOrderedSet._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release) {
    objc.checkOsVersionInternal('NSMutableOrderedSet',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
  }

  /// Constructs a [NSMutableOrderedSet] that points to the same underlying object as [other].
  NSMutableOrderedSet.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSMutableOrderedSet] that wraps the given raw object pointer.
  NSMutableOrderedSet.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSMutableOrderedSet].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSMutableOrderedSet);
  }

  /// alloc
  static NSMutableOrderedSet alloc() {
    final _ret = _objc_msgSend_151sglz(_class_NSMutableOrderedSet, _sel_alloc);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// allocWithZone:
  static NSMutableOrderedSet allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret = _objc_msgSend_1cwp428(
        _class_NSMutableOrderedSet, _sel_allocWithZone_, zone);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// new
  static NSMutableOrderedSet new$() {
    final _ret = _objc_msgSend_151sglz(_class_NSMutableOrderedSet, _sel_new);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// orderedSet
  static NSMutableOrderedSet orderedSet() {
    objc.checkOsVersionInternal('NSMutableOrderedSet.orderedSet',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret =
        _objc_msgSend_151sglz(_class_NSMutableOrderedSet, _sel_orderedSet);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  /// orderedSetWithArray:
  static NSMutableOrderedSet orderedSetWithArray_(NSArray array) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.orderedSetWithArray:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_1sotr3r(_class_NSMutableOrderedSet,
        _sel_orderedSetWithArray_, array.ref.pointer);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  /// orderedSetWithArray:range:copyItems:
  static NSMutableOrderedSet orderedSetWithArray_range_copyItems_(
      NSArray array, NSRange range, bool flag) {
    objc.checkOsVersionInternal(
        'NSMutableOrderedSet.orderedSetWithArray:range:copyItems:',
        iOS: (false, (5, 0, 0)),
        macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_w9bq5x(
        _class_NSMutableOrderedSet,
        _sel_orderedSetWithArray_range_copyItems_,
        array.ref.pointer,
        range,
        flag);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  /// orderedSetWithCapacity:
  static NSMutableOrderedSet orderedSetWithCapacity_(int numItems) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.orderedSetWithCapacity:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_14hpxwa(
        _class_NSMutableOrderedSet, _sel_orderedSetWithCapacity_, numItems);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  /// orderedSetWithObject:
  static NSMutableOrderedSet orderedSetWithObject_(objc.ObjCObjectBase object) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.orderedSetWithObject:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_1sotr3r(_class_NSMutableOrderedSet,
        _sel_orderedSetWithObject_, object.ref.pointer);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  /// orderedSetWithObjects:
  static NSMutableOrderedSet orderedSetWithObjects_(
      objc.ObjCObjectBase firstObj) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.orderedSetWithObjects:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_1sotr3r(_class_NSMutableOrderedSet,
        _sel_orderedSetWithObjects_, firstObj.ref.pointer);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  /// orderedSetWithObjects:count:
  static NSMutableOrderedSet orderedSetWithObjects_count_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects, int cnt) {
    objc.checkOsVersionInternal(
        'NSMutableOrderedSet.orderedSetWithObjects:count:',
        iOS: (false, (5, 0, 0)),
        macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_zmbtbd(_class_NSMutableOrderedSet,
        _sel_orderedSetWithObjects_count_, objects, cnt);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  /// orderedSetWithOrderedSet:
  static NSMutableOrderedSet orderedSetWithOrderedSet_(NSOrderedSet set) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.orderedSetWithOrderedSet:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_1sotr3r(_class_NSMutableOrderedSet,
        _sel_orderedSetWithOrderedSet_, set.ref.pointer);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  /// orderedSetWithOrderedSet:range:copyItems:
  static NSMutableOrderedSet orderedSetWithOrderedSet_range_copyItems_(
      NSOrderedSet set, NSRange range, bool flag) {
    objc.checkOsVersionInternal(
        'NSMutableOrderedSet.orderedSetWithOrderedSet:range:copyItems:',
        iOS: (false, (5, 0, 0)),
        macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_w9bq5x(
        _class_NSMutableOrderedSet,
        _sel_orderedSetWithOrderedSet_range_copyItems_,
        set.ref.pointer,
        range,
        flag);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  /// orderedSetWithSet:
  static NSMutableOrderedSet orderedSetWithSet_(objc.ObjCObjectBase set) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.orderedSetWithSet:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSMutableOrderedSet, _sel_orderedSetWithSet_, set.ref.pointer);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  /// orderedSetWithSet:copyItems:
  static NSMutableOrderedSet orderedSetWithSet_copyItems_(
      objc.ObjCObjectBase set, bool flag) {
    objc.checkOsVersionInternal(
        'NSMutableOrderedSet.orderedSetWithSet:copyItems:',
        iOS: (false, (5, 0, 0)),
        macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_17amj0z(_class_NSMutableOrderedSet,
        _sel_orderedSetWithSet_copyItems_, set.ref.pointer, flag);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  /// supportsSecureCoding
  static bool getSupportsSecureCoding() {
    return _objc_msgSend_91o635(
        _class_NSMutableOrderedSet, _sel_supportsSecureCoding);
  }

  /// autorelease
  NSMutableOrderedSet autorelease() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_autorelease);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  /// init
  NSMutableOrderedSet init() {
    objc.checkOsVersionInternal('NSMutableOrderedSet.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// initWithArray:
  NSMutableOrderedSet initWithArray_(NSArray array) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.initWithArray:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithArray_, array.ref.pointer);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// initWithArray:copyItems:
  NSMutableOrderedSet initWithArray_copyItems_(NSArray set, bool flag) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.initWithArray:copyItems:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_17amj0z(this.ref.retainAndReturnPointer(),
        _sel_initWithArray_copyItems_, set.ref.pointer, flag);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// initWithArray:range:copyItems:
  NSMutableOrderedSet initWithArray_range_copyItems_(
      NSArray set, NSRange range, bool flag) {
    objc.checkOsVersionInternal(
        'NSMutableOrderedSet.initWithArray:range:copyItems:',
        iOS: (false, (5, 0, 0)),
        macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_w9bq5x(this.ref.retainAndReturnPointer(),
        _sel_initWithArray_range_copyItems_, set.ref.pointer, range, flag);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// initWithCapacity:
  NSMutableOrderedSet initWithCapacity_(int numItems) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.initWithCapacity:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_14hpxwa(
        this.ref.retainAndReturnPointer(), _sel_initWithCapacity_, numItems);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// initWithCoder:
  NSMutableOrderedSet? initWithCoder_(NSCoder coder) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithCoder_, coder.ref.pointer);
    return _ret.address == 0
        ? null
        : NSMutableOrderedSet.castFromPointer(_ret,
            retain: false, release: true);
  }

  /// initWithObject:
  NSMutableOrderedSet initWithObject_(objc.ObjCObjectBase object) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.initWithObject:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithObject_, object.ref.pointer);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// initWithObjects:
  NSMutableOrderedSet initWithObjects_(objc.ObjCObjectBase firstObj) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.initWithObjects:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithObjects_, firstObj.ref.pointer);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// initWithObjects:count:
  NSMutableOrderedSet initWithObjects_count_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects, int cnt) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.initWithObjects:count:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_zmbtbd(this.ref.retainAndReturnPointer(),
        _sel_initWithObjects_count_, objects, cnt);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// initWithOrderedSet:
  NSMutableOrderedSet initWithOrderedSet_(NSOrderedSet set) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.initWithOrderedSet:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithOrderedSet_, set.ref.pointer);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// initWithOrderedSet:copyItems:
  NSMutableOrderedSet initWithOrderedSet_copyItems_(
      NSOrderedSet set, bool flag) {
    objc.checkOsVersionInternal(
        'NSMutableOrderedSet.initWithOrderedSet:copyItems:',
        iOS: (false, (5, 0, 0)),
        macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_17amj0z(this.ref.retainAndReturnPointer(),
        _sel_initWithOrderedSet_copyItems_, set.ref.pointer, flag);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// initWithOrderedSet:range:copyItems:
  NSMutableOrderedSet initWithOrderedSet_range_copyItems_(
      NSOrderedSet set, NSRange range, bool flag) {
    objc.checkOsVersionInternal(
        'NSMutableOrderedSet.initWithOrderedSet:range:copyItems:',
        iOS: (false, (5, 0, 0)),
        macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_w9bq5x(this.ref.retainAndReturnPointer(),
        _sel_initWithOrderedSet_range_copyItems_, set.ref.pointer, range, flag);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// initWithSet:
  NSMutableOrderedSet initWithSet_(objc.ObjCObjectBase set) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.initWithSet:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_1sotr3r(
        this.ref.retainAndReturnPointer(), _sel_initWithSet_, set.ref.pointer);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// initWithSet:copyItems:
  NSMutableOrderedSet initWithSet_copyItems_(
      objc.ObjCObjectBase set, bool flag) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.initWithSet:copyItems:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_17amj0z(this.ref.retainAndReturnPointer(),
        _sel_initWithSet_copyItems_, set.ref.pointer, flag);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// insertObject:atIndex:
  void insertObject_atIndex_(objc.ObjCObjectBase object, int idx) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.insertObject:atIndex:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    _objc_msgSend_djsa9o(
        this.ref.pointer, _sel_insertObject_atIndex_, object.ref.pointer, idx);
  }

  /// removeObjectAtIndex:
  void removeObjectAtIndex_(int idx) {
    objc.checkOsVersionInternal('NSMutableOrderedSet.removeObjectAtIndex:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    _objc_msgSend_1i9r4xy(this.ref.pointer, _sel_removeObjectAtIndex_, idx);
  }

  /// replaceObjectAtIndex:withObject:
  void replaceObjectAtIndex_withObject_(int idx, objc.ObjCObjectBase object) {
    objc.checkOsVersionInternal(
        'NSMutableOrderedSet.replaceObjectAtIndex:withObject:',
        iOS: (false, (5, 0, 0)),
        macOS: (false, (10, 7, 0)));
    _objc_msgSend_1gypgok(this.ref.pointer,
        _sel_replaceObjectAtIndex_withObject_, idx, object.ref.pointer);
  }

  /// retain
  NSMutableOrderedSet retain() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_retain);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  /// self
  NSMutableOrderedSet self$1() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_self);
    return NSMutableOrderedSet.castFromPointer(_ret,
        retain: true, release: true);
  }

  /// Returns a new instance of NSMutableOrderedSet constructed with the default `new` method.
  factory NSMutableOrderedSet() => new$();
}

/// NSMutableSet
class NSMutableSet extends NSSet {
  NSMutableSet._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSMutableSet] that points to the same underlying object as [other].
  NSMutableSet.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSMutableSet] that wraps the given raw object pointer.
  NSMutableSet.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSMutableSet].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSMutableSet);
  }

  /// alloc
  static NSMutableSet alloc() {
    final _ret = _objc_msgSend_151sglz(_class_NSMutableSet, _sel_alloc);
    return NSMutableSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// allocWithZone:
  static NSMutableSet allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret =
        _objc_msgSend_1cwp428(_class_NSMutableSet, _sel_allocWithZone_, zone);
    return NSMutableSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// new
  static NSMutableSet new$() {
    final _ret = _objc_msgSend_151sglz(_class_NSMutableSet, _sel_new);
    return NSMutableSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// set
  static NSMutableSet set$() {
    final _ret = _objc_msgSend_151sglz(_class_NSMutableSet, _sel_set);
    return NSMutableSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// setWithArray:
  static NSMutableSet setWithArray_(NSArray array) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSMutableSet, _sel_setWithArray_, array.ref.pointer);
    return NSMutableSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// setWithCapacity:
  static NSMutableSet setWithCapacity_(int numItems) {
    final _ret = _objc_msgSend_14hpxwa(
        _class_NSMutableSet, _sel_setWithCapacity_, numItems);
    return NSMutableSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// setWithObject:
  static NSMutableSet setWithObject_(objc.ObjCObjectBase object) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSMutableSet, _sel_setWithObject_, object.ref.pointer);
    return NSMutableSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// setWithObjects:
  static NSMutableSet setWithObjects_(objc.ObjCObjectBase firstObj) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSMutableSet, _sel_setWithObjects_, firstObj.ref.pointer);
    return NSMutableSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// setWithObjects:count:
  static NSMutableSet setWithObjects_count_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects, int cnt) {
    final _ret = _objc_msgSend_zmbtbd(
        _class_NSMutableSet, _sel_setWithObjects_count_, objects, cnt);
    return NSMutableSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// setWithSet:
  static NSMutableSet setWithSet_(NSSet set) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSMutableSet, _sel_setWithSet_, set.ref.pointer);
    return NSMutableSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// supportsSecureCoding
  static bool getSupportsSecureCoding() {
    return _objc_msgSend_91o635(_class_NSMutableSet, _sel_supportsSecureCoding);
  }

  /// addObject:
  void addObject_(objc.ObjCObjectBase object) {
    _objc_msgSend_xtuoz7(this.ref.pointer, _sel_addObject_, object.ref.pointer);
  }

  /// init
  NSMutableSet init() {
    objc.checkOsVersionInternal('NSMutableSet.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSMutableSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithArray:
  NSMutableSet initWithArray_(NSArray array) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithArray_, array.ref.pointer);
    return NSMutableSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithCapacity:
  NSMutableSet initWithCapacity_(int numItems) {
    final _ret = _objc_msgSend_14hpxwa(
        this.ref.retainAndReturnPointer(), _sel_initWithCapacity_, numItems);
    return NSMutableSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithCoder:
  NSMutableSet? initWithCoder_(NSCoder coder) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithCoder_, coder.ref.pointer);
    return _ret.address == 0
        ? null
        : NSMutableSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithObjects:
  NSMutableSet initWithObjects_(objc.ObjCObjectBase firstObj) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithObjects_, firstObj.ref.pointer);
    return NSMutableSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithObjects:count:
  NSMutableSet initWithObjects_count_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects, int cnt) {
    final _ret = _objc_msgSend_zmbtbd(this.ref.retainAndReturnPointer(),
        _sel_initWithObjects_count_, objects, cnt);
    return NSMutableSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithSet:
  NSMutableSet initWithSet_(NSSet set) {
    final _ret = _objc_msgSend_1sotr3r(
        this.ref.retainAndReturnPointer(), _sel_initWithSet_, set.ref.pointer);
    return NSMutableSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithSet:copyItems:
  NSMutableSet initWithSet_copyItems_(NSSet set, bool flag) {
    final _ret = _objc_msgSend_17amj0z(this.ref.retainAndReturnPointer(),
        _sel_initWithSet_copyItems_, set.ref.pointer, flag);
    return NSMutableSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// removeObject:
  void removeObject_(objc.ObjCObjectBase object) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_removeObject_, object.ref.pointer);
  }

  /// Returns a new instance of NSMutableSet constructed with the default `new` method.
  factory NSMutableSet() => new$();
}

/// NSMutableString
class NSMutableString extends NSString {
  NSMutableString._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSMutableString] that points to the same underlying object as [other].
  NSMutableString.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSMutableString] that wraps the given raw object pointer.
  NSMutableString.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSMutableString].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSMutableString);
  }

  /// alloc
  static NSMutableString alloc() {
    final _ret = _objc_msgSend_151sglz(_class_NSMutableString, _sel_alloc);
    return NSMutableString.castFromPointer(_ret, retain: false, release: true);
  }

  /// allocWithZone:
  static NSMutableString allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret = _objc_msgSend_1cwp428(
        _class_NSMutableString, _sel_allocWithZone_, zone);
    return NSMutableString.castFromPointer(_ret, retain: false, release: true);
  }

  /// localizedStringWithFormat:
  static NSMutableString localizedStringWithFormat_(NSString format) {
    final _ret = _objc_msgSend_1sotr3r(_class_NSMutableString,
        _sel_localizedStringWithFormat_, format.ref.pointer);
    return NSMutableString.castFromPointer(_ret, retain: true, release: true);
  }

  /// localizedStringWithValidatedFormat:validFormatSpecifiers:error:
  static NSMutableString?
      localizedStringWithValidatedFormat_validFormatSpecifiers_error_(
          NSString format,
          NSString validFormatSpecifiers,
          ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    objc.checkOsVersionInternal(
        'NSMutableString.localizedStringWithValidatedFormat:validFormatSpecifiers:error:',
        iOS: (false, (11, 0, 0)),
        macOS: (false, (10, 13, 0)));
    final _ret = _objc_msgSend_1pnyuds(
        _class_NSMutableString,
        _sel_localizedStringWithValidatedFormat_validFormatSpecifiers_error_,
        format.ref.pointer,
        validFormatSpecifiers.ref.pointer,
        error);
    return _ret.address == 0
        ? null
        : NSMutableString.castFromPointer(_ret, retain: true, release: true);
  }

  /// new
  static NSMutableString new$() {
    final _ret = _objc_msgSend_151sglz(_class_NSMutableString, _sel_new);
    return NSMutableString.castFromPointer(_ret, retain: false, release: true);
  }

  /// objectWithItemProviderData:typeIdentifier:error:
  static NSMutableString? objectWithItemProviderData_typeIdentifier_error_(
      NSData data,
      NSString typeIdentifier,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> outError) {
    objc.checkOsVersionInternal(
        'NSMutableString.objectWithItemProviderData:typeIdentifier:error:',
        iOS: (false, (11, 0, 0)),
        macOS: (false, (10, 13, 0)));
    final _ret = _objc_msgSend_1pnyuds(
        _class_NSMutableString,
        _sel_objectWithItemProviderData_typeIdentifier_error_,
        data.ref.pointer,
        typeIdentifier.ref.pointer,
        outError);
    return _ret.address == 0
        ? null
        : NSMutableString.castFromPointer(_ret, retain: true, release: true);
  }

  /// string
  static NSMutableString string() {
    final _ret = _objc_msgSend_151sglz(_class_NSMutableString, _sel_string);
    return NSMutableString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringWithCString:encoding:
  static NSMutableString? stringWithCString_encoding_(
      ffi.Pointer<ffi.Char> cString, int enc) {
    final _ret = _objc_msgSend_erqryg(
        _class_NSMutableString, _sel_stringWithCString_encoding_, cString, enc);
    return _ret.address == 0
        ? null
        : NSMutableString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringWithCharacters:length:
  static NSMutableString stringWithCharacters_length_(
      ffi.Pointer<ffi.UnsignedShort> characters, int length) {
    final _ret = _objc_msgSend_9x4k8x(_class_NSMutableString,
        _sel_stringWithCharacters_length_, characters, length);
    return NSMutableString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringWithContentsOfFile:encoding:error:
  static NSMutableString? stringWithContentsOfFile_encoding_error_(
      NSString path, int enc, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_1nomli1(
        _class_NSMutableString,
        _sel_stringWithContentsOfFile_encoding_error_,
        path.ref.pointer,
        enc,
        error);
    return _ret.address == 0
        ? null
        : NSMutableString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringWithContentsOfFile:usedEncoding:error:
  static NSMutableString? stringWithContentsOfFile_usedEncoding_error_(
      NSString path,
      ffi.Pointer<ffi.UnsignedLong> enc,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_1alewu7(
        _class_NSMutableString,
        _sel_stringWithContentsOfFile_usedEncoding_error_,
        path.ref.pointer,
        enc,
        error);
    return _ret.address == 0
        ? null
        : NSMutableString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringWithContentsOfURL:encoding:error:
  static NSMutableString? stringWithContentsOfURL_encoding_error_(
      NSURL url, int enc, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_1nomli1(
        _class_NSMutableString,
        _sel_stringWithContentsOfURL_encoding_error_,
        url.ref.pointer,
        enc,
        error);
    return _ret.address == 0
        ? null
        : NSMutableString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringWithContentsOfURL:usedEncoding:error:
  static NSMutableString? stringWithContentsOfURL_usedEncoding_error_(
      NSURL url,
      ffi.Pointer<ffi.UnsignedLong> enc,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_1alewu7(
        _class_NSMutableString,
        _sel_stringWithContentsOfURL_usedEncoding_error_,
        url.ref.pointer,
        enc,
        error);
    return _ret.address == 0
        ? null
        : NSMutableString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringWithFormat:
  static NSMutableString stringWithFormat_(NSString format) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSMutableString, _sel_stringWithFormat_, format.ref.pointer);
    return NSMutableString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringWithString:
  static NSMutableString stringWithString_(NSString string) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSMutableString, _sel_stringWithString_, string.ref.pointer);
    return NSMutableString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringWithUTF8String:
  static NSMutableString? stringWithUTF8String_(
      ffi.Pointer<ffi.Char> nullTerminatedCString) {
    final _ret = _objc_msgSend_56zxyn(_class_NSMutableString,
        _sel_stringWithUTF8String_, nullTerminatedCString);
    return _ret.address == 0
        ? null
        : NSMutableString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringWithValidatedFormat:validFormatSpecifiers:error:
  static NSMutableString?
      stringWithValidatedFormat_validFormatSpecifiers_error_(
          NSString format,
          NSString validFormatSpecifiers,
          ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    objc.checkOsVersionInternal(
        'NSMutableString.stringWithValidatedFormat:validFormatSpecifiers:error:',
        iOS: (false, (11, 0, 0)),
        macOS: (false, (10, 13, 0)));
    final _ret = _objc_msgSend_1pnyuds(
        _class_NSMutableString,
        _sel_stringWithValidatedFormat_validFormatSpecifiers_error_,
        format.ref.pointer,
        validFormatSpecifiers.ref.pointer,
        error);
    return _ret.address == 0
        ? null
        : NSMutableString.castFromPointer(_ret, retain: true, release: true);
  }

  /// supportsSecureCoding
  static bool getSupportsSecureCoding() {
    return _objc_msgSend_91o635(
        _class_NSMutableString, _sel_supportsSecureCoding);
  }

  /// autorelease
  NSMutableString autorelease() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_autorelease);
    return NSMutableString.castFromPointer(_ret, retain: true, release: true);
  }

  /// init
  NSMutableString init() {
    objc.checkOsVersionInternal('NSMutableString.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSMutableString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithBytes:length:encoding:
  NSMutableString? initWithBytes_length_encoding_(
      ffi.Pointer<ffi.Void> bytes, int len, int encoding) {
    final _ret = _objc_msgSend_9b3h4v(this.ref.retainAndReturnPointer(),
        _sel_initWithBytes_length_encoding_, bytes, len, encoding);
    return _ret.address == 0
        ? null
        : NSMutableString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithBytesNoCopy:length:encoding:freeWhenDone:
  NSMutableString? initWithBytesNoCopy_length_encoding_freeWhenDone_(
      ffi.Pointer<ffi.Void> bytes, int len, int encoding, bool freeBuffer) {
    final _ret = _objc_msgSend_k4j8m3(
        this.ref.retainAndReturnPointer(),
        _sel_initWithBytesNoCopy_length_encoding_freeWhenDone_,
        bytes,
        len,
        encoding,
        freeBuffer);
    return _ret.address == 0
        ? null
        : NSMutableString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithCString:encoding:
  NSMutableString? initWithCString_encoding_(
      ffi.Pointer<ffi.Char> nullTerminatedCString, int encoding) {
    final _ret = _objc_msgSend_erqryg(this.ref.retainAndReturnPointer(),
        _sel_initWithCString_encoding_, nullTerminatedCString, encoding);
    return _ret.address == 0
        ? null
        : NSMutableString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithCharacters:length:
  NSMutableString initWithCharacters_length_(
      ffi.Pointer<ffi.UnsignedShort> characters, int length) {
    final _ret = _objc_msgSend_9x4k8x(this.ref.retainAndReturnPointer(),
        _sel_initWithCharacters_length_, characters, length);
    return NSMutableString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithCharactersNoCopy:length:freeWhenDone:
  NSMutableString initWithCharactersNoCopy_length_freeWhenDone_(
      ffi.Pointer<ffi.UnsignedShort> characters, int length, bool freeBuffer) {
    final _ret = _objc_msgSend_lh0jh5(
        this.ref.retainAndReturnPointer(),
        _sel_initWithCharactersNoCopy_length_freeWhenDone_,
        characters,
        length,
        freeBuffer);
    return NSMutableString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithCoder:
  NSMutableString? initWithCoder_(NSCoder coder) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithCoder_, coder.ref.pointer);
    return _ret.address == 0
        ? null
        : NSMutableString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithContentsOfFile:encoding:error:
  NSMutableString? initWithContentsOfFile_encoding_error_(
      NSString path, int enc, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_1nomli1(
        this.ref.retainAndReturnPointer(),
        _sel_initWithContentsOfFile_encoding_error_,
        path.ref.pointer,
        enc,
        error);
    return _ret.address == 0
        ? null
        : NSMutableString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithContentsOfFile:usedEncoding:error:
  NSMutableString? initWithContentsOfFile_usedEncoding_error_(
      NSString path,
      ffi.Pointer<ffi.UnsignedLong> enc,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_1alewu7(
        this.ref.retainAndReturnPointer(),
        _sel_initWithContentsOfFile_usedEncoding_error_,
        path.ref.pointer,
        enc,
        error);
    return _ret.address == 0
        ? null
        : NSMutableString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithContentsOfURL:encoding:error:
  NSMutableString? initWithContentsOfURL_encoding_error_(
      NSURL url, int enc, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_1nomli1(
        this.ref.retainAndReturnPointer(),
        _sel_initWithContentsOfURL_encoding_error_,
        url.ref.pointer,
        enc,
        error);
    return _ret.address == 0
        ? null
        : NSMutableString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithContentsOfURL:usedEncoding:error:
  NSMutableString? initWithContentsOfURL_usedEncoding_error_(
      NSURL url,
      ffi.Pointer<ffi.UnsignedLong> enc,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_1alewu7(
        this.ref.retainAndReturnPointer(),
        _sel_initWithContentsOfURL_usedEncoding_error_,
        url.ref.pointer,
        enc,
        error);
    return _ret.address == 0
        ? null
        : NSMutableString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithData:encoding:
  NSMutableString? initWithData_encoding_(NSData data, int encoding) {
    final _ret = _objc_msgSend_1k4kd9s(this.ref.retainAndReturnPointer(),
        _sel_initWithData_encoding_, data.ref.pointer, encoding);
    return _ret.address == 0
        ? null
        : NSMutableString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithFormat:
  NSMutableString initWithFormat_(NSString format) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithFormat_, format.ref.pointer);
    return NSMutableString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithFormat:locale:
  NSMutableString initWithFormat_locale_(
      NSString format, objc.ObjCObjectBase? locale) {
    final _ret = _objc_msgSend_15qeuct(
        this.ref.retainAndReturnPointer(),
        _sel_initWithFormat_locale_,
        format.ref.pointer,
        locale?.ref.pointer ?? ffi.nullptr);
    return NSMutableString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithString:
  NSMutableString initWithString_(NSString aString) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithString_, aString.ref.pointer);
    return NSMutableString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithUTF8String:
  NSMutableString? initWithUTF8String_(
      ffi.Pointer<ffi.Char> nullTerminatedCString) {
    final _ret = _objc_msgSend_56zxyn(this.ref.retainAndReturnPointer(),
        _sel_initWithUTF8String_, nullTerminatedCString);
    return _ret.address == 0
        ? null
        : NSMutableString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithValidatedFormat:validFormatSpecifiers:error:
  ///
  /// iOS: introduced 16.0.0
  /// macOS: introduced 13.0.0
  NSMutableString? initWithValidatedFormat_validFormatSpecifiers_error_(
      NSString format,
      NSString validFormatSpecifiers,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    objc.checkOsVersionInternal(
        'NSMutableString.initWithValidatedFormat:validFormatSpecifiers:error:',
        iOS: (false, (16, 0, 0)),
        macOS: (false, (13, 0, 0)));
    final _ret = _objc_msgSend_1pnyuds(
        this.ref.retainAndReturnPointer(),
        _sel_initWithValidatedFormat_validFormatSpecifiers_error_,
        format.ref.pointer,
        validFormatSpecifiers.ref.pointer,
        error);
    return _ret.address == 0
        ? null
        : NSMutableString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithValidatedFormat:validFormatSpecifiers:locale:error:
  ///
  /// iOS: introduced 16.0.0
  /// macOS: introduced 13.0.0
  NSMutableString? initWithValidatedFormat_validFormatSpecifiers_locale_error_(
      NSString format,
      NSString validFormatSpecifiers,
      objc.ObjCObjectBase? locale,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    objc.checkOsVersionInternal(
        'NSMutableString.initWithValidatedFormat:validFormatSpecifiers:locale:error:',
        iOS: (false, (16, 0, 0)),
        macOS: (false, (13, 0, 0)));
    final _ret = _objc_msgSend_1k0ezzm(
        this.ref.retainAndReturnPointer(),
        _sel_initWithValidatedFormat_validFormatSpecifiers_locale_error_,
        format.ref.pointer,
        validFormatSpecifiers.ref.pointer,
        locale?.ref.pointer ?? ffi.nullptr,
        error);
    return _ret.address == 0
        ? null
        : NSMutableString.castFromPointer(_ret, retain: false, release: true);
  }

  /// replaceCharactersInRange:withString:
  void replaceCharactersInRange_withString_(NSRange range, NSString aString) {
    _objc_msgSend_1tv4uax(this.ref.pointer,
        _sel_replaceCharactersInRange_withString_, range, aString.ref.pointer);
  }

  /// retain
  NSMutableString retain() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_retain);
    return NSMutableString.castFromPointer(_ret, retain: true, release: true);
  }

  /// self
  NSMutableString self$1() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_self);
    return NSMutableString.castFromPointer(_ret, retain: true, release: true);
  }

  /// Returns a new instance of NSMutableString constructed with the default `new` method.
  factory NSMutableString() => new$();
}

/// NSNotification
class NSNotification extends NSObject implements NSCopying, NSCoding {
  NSNotification._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSNotification] that points to the same underlying object as [other].
  NSNotification.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSNotification] that wraps the given raw object pointer.
  NSNotification.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSNotification].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSNotification);
  }

  /// alloc
  static NSNotification alloc() {
    final _ret = _objc_msgSend_151sglz(_class_NSNotification, _sel_alloc);
    return NSNotification.castFromPointer(_ret, retain: false, release: true);
  }

  /// allocWithZone:
  static NSNotification allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret =
        _objc_msgSend_1cwp428(_class_NSNotification, _sel_allocWithZone_, zone);
    return NSNotification.castFromPointer(_ret, retain: false, release: true);
  }

  /// new
  static NSNotification new$() {
    final _ret = _objc_msgSend_151sglz(_class_NSNotification, _sel_new);
    return NSNotification.castFromPointer(_ret, retain: false, release: true);
  }

  /// notificationWithName:object:
  static NSNotification notificationWithName_object_(
      NSString aName, objc.ObjCObjectBase? anObject) {
    final _ret = _objc_msgSend_15qeuct(
        _class_NSNotification,
        _sel_notificationWithName_object_,
        aName.ref.pointer,
        anObject?.ref.pointer ?? ffi.nullptr);
    return NSNotification.castFromPointer(_ret, retain: true, release: true);
  }

  /// notificationWithName:object:userInfo:
  static NSNotification notificationWithName_object_userInfo_(
      NSString aName, objc.ObjCObjectBase? anObject, NSDictionary? aUserInfo) {
    final _ret = _objc_msgSend_11spmsz(
        _class_NSNotification,
        _sel_notificationWithName_object_userInfo_,
        aName.ref.pointer,
        anObject?.ref.pointer ?? ffi.nullptr,
        aUserInfo?.ref.pointer ?? ffi.nullptr);
    return NSNotification.castFromPointer(_ret, retain: true, release: true);
  }

  /// autorelease
  NSNotification autorelease() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_autorelease);
    return NSNotification.castFromPointer(_ret, retain: true, release: true);
  }

  /// encodeWithCoder:
  void encodeWithCoder_(NSCoder coder) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_encodeWithCoder_, coder.ref.pointer);
  }

  /// init
  NSNotification init() {
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSNotification.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithCoder:
  NSNotification? initWithCoder_(NSCoder coder) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithCoder_, coder.ref.pointer);
    return _ret.address == 0
        ? null
        : NSNotification.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithName:object:userInfo:
  NSNotification initWithName_object_userInfo_(
      NSString name, objc.ObjCObjectBase? object, NSDictionary? userInfo) {
    objc.checkOsVersionInternal('NSNotification.initWithName:object:userInfo:',
        iOS: (false, (4, 0, 0)), macOS: (false, (10, 6, 0)));
    final _ret = _objc_msgSend_11spmsz(
        this.ref.retainAndReturnPointer(),
        _sel_initWithName_object_userInfo_,
        name.ref.pointer,
        object?.ref.pointer ?? ffi.nullptr,
        userInfo?.ref.pointer ?? ffi.nullptr);
    return NSNotification.castFromPointer(_ret, retain: false, release: true);
  }

  /// name
  NSString get name {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_name);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// object
  objc.ObjCObjectBase? get object {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_object);
    return _ret.address == 0
        ? null
        : objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// retain
  NSNotification retain() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_retain);
    return NSNotification.castFromPointer(_ret, retain: true, release: true);
  }

  /// self
  NSNotification self$1() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_self);
    return NSNotification.castFromPointer(_ret, retain: true, release: true);
  }

  /// userInfo
  NSDictionary? get userInfo {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_userInfo);
    return _ret.address == 0
        ? null
        : NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  /// Returns a new instance of NSNotification constructed with the default `new` method.
  factory NSNotification() => new$();
}

/// NSNumber
class NSNumber extends NSValue {
  NSNumber._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSNumber] that points to the same underlying object as [other].
  NSNumber.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSNumber] that wraps the given raw object pointer.
  NSNumber.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSNumber].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSNumber);
  }

  /// alloc
  static NSNumber alloc() {
    final _ret = _objc_msgSend_151sglz(_class_NSNumber, _sel_alloc);
    return NSNumber.castFromPointer(_ret, retain: false, release: true);
  }

  /// allocWithZone:
  static NSNumber allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret =
        _objc_msgSend_1cwp428(_class_NSNumber, _sel_allocWithZone_, zone);
    return NSNumber.castFromPointer(_ret, retain: false, release: true);
  }

  /// new
  static NSNumber new$() {
    final _ret = _objc_msgSend_151sglz(_class_NSNumber, _sel_new);
    return NSNumber.castFromPointer(_ret, retain: false, release: true);
  }

  /// supportsSecureCoding
  static bool getSupportsSecureCoding() {
    return _objc_msgSend_91o635(_class_NSNumber, _sel_supportsSecureCoding);
  }

  /// boolValue
  bool get boolValue {
    return _objc_msgSend_91o635(this.ref.pointer, _sel_boolValue);
  }

  /// charValue
  int get charValue {
    return _objc_msgSend_xmlz1t(this.ref.pointer, _sel_charValue);
  }

  /// compare:
  NSComparisonResult compare_(NSNumber otherNumber) {
    final _ret = _objc_msgSend_1ym6zyw(
        this.ref.pointer, _sel_compare_, otherNumber.ref.pointer);
    return NSComparisonResult.fromValue(_ret);
  }

  /// descriptionWithLocale:
  NSString descriptionWithLocale_(objc.ObjCObjectBase? locale) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.pointer,
        _sel_descriptionWithLocale_, locale?.ref.pointer ?? ffi.nullptr);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// doubleValue
  double get doubleValue {
    return objc.useMsgSendVariants
        ? _objc_msgSend_1ukqyt8Fpret(this.ref.pointer, _sel_doubleValue)
        : _objc_msgSend_1ukqyt8(this.ref.pointer, _sel_doubleValue);
  }

  /// floatValue
  double get floatValue {
    return objc.useMsgSendVariants
        ? _objc_msgSend_2cgrxlFpret(this.ref.pointer, _sel_floatValue)
        : _objc_msgSend_2cgrxl(this.ref.pointer, _sel_floatValue);
  }

  /// init
  NSNumber init() {
    objc.checkOsVersionInternal('NSNumber.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSNumber.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithBool:
  NSNumber initWithBool_(bool value) {
    final _ret = _objc_msgSend_1t6aok9(
        this.ref.retainAndReturnPointer(), _sel_initWithBool_, value);
    return NSNumber.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithBytes:objCType:
  NSNumber initWithBytes_objCType_(
      ffi.Pointer<ffi.Void> value, ffi.Pointer<ffi.Char> type) {
    final _ret = _objc_msgSend_e9mncn(this.ref.retainAndReturnPointer(),
        _sel_initWithBytes_objCType_, value, type);
    return NSNumber.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithChar:
  NSNumber initWithChar_(int value) {
    final _ret = _objc_msgSend_13mclwd(
        this.ref.retainAndReturnPointer(), _sel_initWithChar_, value);
    return NSNumber.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithCoder:
  NSNumber? initWithCoder_(NSCoder coder) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithCoder_, coder.ref.pointer);
    return _ret.address == 0
        ? null
        : NSNumber.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithDouble:
  NSNumber initWithDouble_(double value) {
    final _ret = _objc_msgSend_oa8mke(
        this.ref.retainAndReturnPointer(), _sel_initWithDouble_, value);
    return NSNumber.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithFloat:
  NSNumber initWithFloat_(double value) {
    final _ret = _objc_msgSend_et8cuh(
        this.ref.retainAndReturnPointer(), _sel_initWithFloat_, value);
    return NSNumber.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithInt:
  NSNumber initWithInt_(int value) {
    final _ret = _objc_msgSend_14hvw5k(
        this.ref.retainAndReturnPointer(), _sel_initWithInt_, value);
    return NSNumber.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithInteger:
  NSNumber initWithInteger_(int value) {
    objc.checkOsVersionInternal('NSNumber.initWithInteger:',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 5, 0)));
    final _ret = _objc_msgSend_qugqlf(
        this.ref.retainAndReturnPointer(), _sel_initWithInteger_, value);
    return NSNumber.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithLong:
  NSNumber initWithLong_(int value) {
    final _ret = _objc_msgSend_qugqlf(
        this.ref.retainAndReturnPointer(), _sel_initWithLong_, value);
    return NSNumber.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithLongLong:
  NSNumber initWithLongLong_(int value) {
    final _ret = _objc_msgSend_16f0drb(
        this.ref.retainAndReturnPointer(), _sel_initWithLongLong_, value);
    return NSNumber.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithShort:
  NSNumber initWithShort_(int value) {
    final _ret = _objc_msgSend_68x6r1(
        this.ref.retainAndReturnPointer(), _sel_initWithShort_, value);
    return NSNumber.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithUnsignedChar:
  NSNumber initWithUnsignedChar_(int value) {
    final _ret = _objc_msgSend_7uautw(
        this.ref.retainAndReturnPointer(), _sel_initWithUnsignedChar_, value);
    return NSNumber.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithUnsignedInt:
  NSNumber initWithUnsignedInt_(int value) {
    final _ret = _objc_msgSend_degb40(
        this.ref.retainAndReturnPointer(), _sel_initWithUnsignedInt_, value);
    return NSNumber.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithUnsignedInteger:
  NSNumber initWithUnsignedInteger_(int value) {
    objc.checkOsVersionInternal('NSNumber.initWithUnsignedInteger:',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 5, 0)));
    final _ret = _objc_msgSend_14hpxwa(this.ref.retainAndReturnPointer(),
        _sel_initWithUnsignedInteger_, value);
    return NSNumber.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithUnsignedLong:
  NSNumber initWithUnsignedLong_(int value) {
    final _ret = _objc_msgSend_14hpxwa(
        this.ref.retainAndReturnPointer(), _sel_initWithUnsignedLong_, value);
    return NSNumber.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithUnsignedLongLong:
  NSNumber initWithUnsignedLongLong_(int value) {
    final _ret = _objc_msgSend_1x2hskc(this.ref.retainAndReturnPointer(),
        _sel_initWithUnsignedLongLong_, value);
    return NSNumber.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithUnsignedShort:
  NSNumber initWithUnsignedShort_(int value) {
    final _ret = _objc_msgSend_1njucl2(
        this.ref.retainAndReturnPointer(), _sel_initWithUnsignedShort_, value);
    return NSNumber.castFromPointer(_ret, retain: false, release: true);
  }

  /// intValue
  int get intValue {
    return _objc_msgSend_13yqbb6(this.ref.pointer, _sel_intValue);
  }

  /// integerValue
  int get integerValue {
    objc.checkOsVersionInternal('NSNumber.integerValue',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 5, 0)));
    return _objc_msgSend_1hz7y9r(this.ref.pointer, _sel_integerValue);
  }

  /// isEqualToNumber:
  bool isEqualToNumber_(NSNumber number) {
    return _objc_msgSend_19nvye5(
        this.ref.pointer, _sel_isEqualToNumber_, number.ref.pointer);
  }

  /// longLongValue
  int get longLongValue {
    return _objc_msgSend_1k101e3(this.ref.pointer, _sel_longLongValue);
  }

  /// longValue
  int get longValue {
    return _objc_msgSend_1hz7y9r(this.ref.pointer, _sel_longValue);
  }

  /// shortValue
  int get shortValue {
    return _objc_msgSend_1jwityx(this.ref.pointer, _sel_shortValue);
  }

  /// stringValue
  NSString get stringValue {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_stringValue);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// unsignedCharValue
  int get unsignedCharValue {
    return _objc_msgSend_1ko4qka(this.ref.pointer, _sel_unsignedCharValue);
  }

  /// unsignedIntValue
  int get unsignedIntValue {
    return _objc_msgSend_3pyzne(this.ref.pointer, _sel_unsignedIntValue);
  }

  /// unsignedIntegerValue
  int get unsignedIntegerValue {
    objc.checkOsVersionInternal('NSNumber.unsignedIntegerValue',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 5, 0)));
    return _objc_msgSend_xw2lbc(this.ref.pointer, _sel_unsignedIntegerValue);
  }

  /// unsignedLongLongValue
  int get unsignedLongLongValue {
    return _objc_msgSend_1p4gbjy(this.ref.pointer, _sel_unsignedLongLongValue);
  }

  /// unsignedLongValue
  int get unsignedLongValue {
    return _objc_msgSend_xw2lbc(this.ref.pointer, _sel_unsignedLongValue);
  }

  /// unsignedShortValue
  int get unsignedShortValue {
    return _objc_msgSend_ud8gg(this.ref.pointer, _sel_unsignedShortValue);
  }

  /// Returns a new instance of NSNumber constructed with the default `new` method.
  factory NSNumber() => new$();
}

/// NSNumberCreation
extension NSNumberCreation on NSNumber {
  /// numberWithBool:
  static NSNumber numberWithBool_(bool value) {
    final _ret =
        _objc_msgSend_1t6aok9(_class_NSNumber, _sel_numberWithBool_, value);
    return NSNumber.castFromPointer(_ret, retain: true, release: true);
  }

  /// numberWithChar:
  static NSNumber numberWithChar_(int value) {
    final _ret =
        _objc_msgSend_13mclwd(_class_NSNumber, _sel_numberWithChar_, value);
    return NSNumber.castFromPointer(_ret, retain: true, release: true);
  }

  /// numberWithDouble:
  static NSNumber numberWithDouble_(double value) {
    final _ret =
        _objc_msgSend_oa8mke(_class_NSNumber, _sel_numberWithDouble_, value);
    return NSNumber.castFromPointer(_ret, retain: true, release: true);
  }

  /// numberWithFloat:
  static NSNumber numberWithFloat_(double value) {
    final _ret =
        _objc_msgSend_et8cuh(_class_NSNumber, _sel_numberWithFloat_, value);
    return NSNumber.castFromPointer(_ret, retain: true, release: true);
  }

  /// numberWithInt:
  static NSNumber numberWithInt_(int value) {
    final _ret =
        _objc_msgSend_14hvw5k(_class_NSNumber, _sel_numberWithInt_, value);
    return NSNumber.castFromPointer(_ret, retain: true, release: true);
  }

  /// numberWithInteger:
  static NSNumber numberWithInteger_(int value) {
    objc.checkOsVersionInternal('NSNumber.numberWithInteger:',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 5, 0)));
    final _ret =
        _objc_msgSend_qugqlf(_class_NSNumber, _sel_numberWithInteger_, value);
    return NSNumber.castFromPointer(_ret, retain: true, release: true);
  }

  /// numberWithLong:
  static NSNumber numberWithLong_(int value) {
    final _ret =
        _objc_msgSend_qugqlf(_class_NSNumber, _sel_numberWithLong_, value);
    return NSNumber.castFromPointer(_ret, retain: true, release: true);
  }

  /// numberWithLongLong:
  static NSNumber numberWithLongLong_(int value) {
    final _ret =
        _objc_msgSend_16f0drb(_class_NSNumber, _sel_numberWithLongLong_, value);
    return NSNumber.castFromPointer(_ret, retain: true, release: true);
  }

  /// numberWithShort:
  static NSNumber numberWithShort_(int value) {
    final _ret =
        _objc_msgSend_68x6r1(_class_NSNumber, _sel_numberWithShort_, value);
    return NSNumber.castFromPointer(_ret, retain: true, release: true);
  }

  /// numberWithUnsignedChar:
  static NSNumber numberWithUnsignedChar_(int value) {
    final _ret = _objc_msgSend_7uautw(
        _class_NSNumber, _sel_numberWithUnsignedChar_, value);
    return NSNumber.castFromPointer(_ret, retain: true, release: true);
  }

  /// numberWithUnsignedInt:
  static NSNumber numberWithUnsignedInt_(int value) {
    final _ret = _objc_msgSend_degb40(
        _class_NSNumber, _sel_numberWithUnsignedInt_, value);
    return NSNumber.castFromPointer(_ret, retain: true, release: true);
  }

  /// numberWithUnsignedInteger:
  static NSNumber numberWithUnsignedInteger_(int value) {
    objc.checkOsVersionInternal('NSNumber.numberWithUnsignedInteger:',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 5, 0)));
    final _ret = _objc_msgSend_14hpxwa(
        _class_NSNumber, _sel_numberWithUnsignedInteger_, value);
    return NSNumber.castFromPointer(_ret, retain: true, release: true);
  }

  /// numberWithUnsignedLong:
  static NSNumber numberWithUnsignedLong_(int value) {
    final _ret = _objc_msgSend_14hpxwa(
        _class_NSNumber, _sel_numberWithUnsignedLong_, value);
    return NSNumber.castFromPointer(_ret, retain: true, release: true);
  }

  /// numberWithUnsignedLongLong:
  static NSNumber numberWithUnsignedLongLong_(int value) {
    final _ret = _objc_msgSend_1x2hskc(
        _class_NSNumber, _sel_numberWithUnsignedLongLong_, value);
    return NSNumber.castFromPointer(_ret, retain: true, release: true);
  }

  /// numberWithUnsignedShort:
  static NSNumber numberWithUnsignedShort_(int value) {
    final _ret = _objc_msgSend_1njucl2(
        _class_NSNumber, _sel_numberWithUnsignedShort_, value);
    return NSNumber.castFromPointer(_ret, retain: true, release: true);
  }
}

/// NSObject
class NSObject extends objc.ObjCObjectBase implements NSObjectProtocol {
  NSObject._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super(pointer, retain: retain, release: release) {
    objc.checkOsVersionInternal('NSObject',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
  }

  /// Constructs a [NSObject] that points to the same underlying object as [other].
  NSObject.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSObject] that wraps the given raw object pointer.
  NSObject.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSObject].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSObject);
  }

  /// alloc
  static NSObject alloc() {
    final _ret = _objc_msgSend_151sglz(_class_NSObject, _sel_alloc);
    return NSObject.castFromPointer(_ret, retain: false, release: true);
  }

  /// allocWithZone:
  static NSObject allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret =
        _objc_msgSend_1cwp428(_class_NSObject, _sel_allocWithZone_, zone);
    return NSObject.castFromPointer(_ret, retain: false, release: true);
  }

  /// class
  static objc.ObjCObjectBase class$() {
    final _ret = _objc_msgSend_151sglz(_class_NSObject, _sel_class);
    return objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// conformsToProtocol:
  static bool conformsToProtocol_(Protocol protocol) {
    objc.checkOsVersionInternal('NSObject.conformsToProtocol:',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    return _objc_msgSend_19nvye5(
        _class_NSObject, _sel_conformsToProtocol_, protocol.ref.pointer);
  }

  /// copyWithZone:
  static objc.ObjCObjectBase copyWithZone_(ffi.Pointer<NSZone> zone) {
    objc.checkOsVersionInternal('NSObject.copyWithZone:',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_1cwp428(_class_NSObject, _sel_copyWithZone_, zone);
    return objc.ObjCObjectBase(_ret, retain: false, release: true);
  }

  /// debugDescription
  static NSString debugDescription() {
    objc.checkOsVersionInternal('NSObject.debugDescription',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret = _objc_msgSend_151sglz(_class_NSObject, _sel_debugDescription);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// description
  static NSString description() {
    objc.checkOsVersionInternal('NSObject.description',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret = _objc_msgSend_151sglz(_class_NSObject, _sel_description);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// hash
  static int hash() {
    objc.checkOsVersionInternal('NSObject.hash',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    return _objc_msgSend_xw2lbc(_class_NSObject, _sel_hash);
  }

  /// initialize
  static void initialize() {
    objc.checkOsVersionInternal('NSObject.initialize',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    _objc_msgSend_1pl9qdv(_class_NSObject, _sel_initialize);
  }

  /// instanceMethodForSelector:
  static ffi.Pointer<ffi.NativeFunction<ffi.Void Function()>>
      instanceMethodForSelector_(ffi.Pointer<objc.ObjCSelector> aSelector) {
    objc.checkOsVersionInternal('NSObject.instanceMethodForSelector:',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    return _objc_msgSend_1pa9f4m(
        _class_NSObject, _sel_instanceMethodForSelector_, aSelector);
  }

  /// instanceMethodSignatureForSelector:
  static NSMethodSignature instanceMethodSignatureForSelector_(
      ffi.Pointer<objc.ObjCSelector> aSelector) {
    final _ret = _objc_msgSend_3ctkt6(
        _class_NSObject, _sel_instanceMethodSignatureForSelector_, aSelector);
    return NSMethodSignature.castFromPointer(_ret, retain: true, release: true);
  }

  /// instancesRespondToSelector:
  static bool instancesRespondToSelector_(
      ffi.Pointer<objc.ObjCSelector> aSelector) {
    objc.checkOsVersionInternal('NSObject.instancesRespondToSelector:',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    return _objc_msgSend_1srf6wk(
        _class_NSObject, _sel_instancesRespondToSelector_, aSelector);
  }

  /// isSubclassOfClass:
  static bool isSubclassOfClass_(objc.ObjCObjectBase aClass) {
    objc.checkOsVersionInternal('NSObject.isSubclassOfClass:',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    return _objc_msgSend_19nvye5(
        _class_NSObject, _sel_isSubclassOfClass_, aClass.ref.pointer);
  }

  /// load
  static void load() {
    objc.checkOsVersionInternal('NSObject.load',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    _objc_msgSend_1pl9qdv(_class_NSObject, _sel_load);
  }

  /// mutableCopyWithZone:
  static objc.ObjCObjectBase mutableCopyWithZone_(ffi.Pointer<NSZone> zone) {
    objc.checkOsVersionInternal('NSObject.mutableCopyWithZone:',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_1cwp428(_class_NSObject, _sel_mutableCopyWithZone_, zone);
    return objc.ObjCObjectBase(_ret, retain: false, release: true);
  }

  /// new
  static NSObject new$() {
    final _ret = _objc_msgSend_151sglz(_class_NSObject, _sel_new);
    return NSObject.castFromPointer(_ret, retain: false, release: true);
  }

  /// resolveClassMethod:
  static bool resolveClassMethod_(ffi.Pointer<objc.ObjCSelector> sel) {
    objc.checkOsVersionInternal('NSObject.resolveClassMethod:',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 5, 0)));
    return _objc_msgSend_1srf6wk(
        _class_NSObject, _sel_resolveClassMethod_, sel);
  }

  /// resolveInstanceMethod:
  static bool resolveInstanceMethod_(ffi.Pointer<objc.ObjCSelector> sel) {
    objc.checkOsVersionInternal('NSObject.resolveInstanceMethod:',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 5, 0)));
    return _objc_msgSend_1srf6wk(
        _class_NSObject, _sel_resolveInstanceMethod_, sel);
  }

  /// superclass
  static objc.ObjCObjectBase superclass() {
    objc.checkOsVersionInternal('NSObject.superclass',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret = _objc_msgSend_151sglz(_class_NSObject, _sel_superclass);
    return objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// autorelease
  NSObject autorelease() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_autorelease);
    return NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  /// class
  objc.ObjCObjectBase class$1() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_class);
    return objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// conformsToProtocol:
  bool conformsToProtocol_$1(Protocol aProtocol) {
    return _objc_msgSend_19nvye5(
        this.ref.pointer, _sel_conformsToProtocol_, aProtocol.ref.pointer);
  }

  /// copy
  objc.ObjCObjectBase copy() {
    objc.checkOsVersionInternal('NSObject.copy',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_copy);
    return objc.ObjCObjectBase(_ret, retain: false, release: true);
  }

  /// dealloc
  void dealloc() {
    _objc_msgSend_1pl9qdv(this.ref.pointer, _sel_dealloc);
  }

  /// debugDescription
  NSString get debugDescription$1 {
    if (!objc.respondsToSelector(this.ref.pointer, _sel_debugDescription)) {
      throw objc.UnimplementedOptionalMethodException(
          'NSObject', 'debugDescription');
    }
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_debugDescription);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// description
  NSString get description$1 {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_description);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// doesNotRecognizeSelector:
  void doesNotRecognizeSelector_(ffi.Pointer<objc.ObjCSelector> aSelector) {
    objc.checkOsVersionInternal('NSObject.doesNotRecognizeSelector:',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    _objc_msgSend_1d9e4oe(
        this.ref.pointer, _sel_doesNotRecognizeSelector_, aSelector);
  }

  /// forwardInvocation:
  void forwardInvocation_(NSInvocation anInvocation) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_forwardInvocation_, anInvocation.ref.pointer);
  }

  /// forwardingTargetForSelector:
  objc.ObjCObjectBase forwardingTargetForSelector_(
      ffi.Pointer<objc.ObjCSelector> aSelector) {
    objc.checkOsVersionInternal('NSObject.forwardingTargetForSelector:',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 5, 0)));
    final _ret = _objc_msgSend_3ctkt6(
        this.ref.pointer, _sel_forwardingTargetForSelector_, aSelector);
    return objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// hash
  int get hash$1 {
    return _objc_msgSend_xw2lbc(this.ref.pointer, _sel_hash);
  }

  /// init
  NSObject init() {
    objc.checkOsVersionInternal('NSObject.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSObject.castFromPointer(_ret, retain: false, release: true);
  }

  /// isEqual:
  bool isEqual_(objc.ObjCObjectBase object) {
    return _objc_msgSend_19nvye5(
        this.ref.pointer, _sel_isEqual_, object.ref.pointer);
  }

  /// isKindOfClass:
  bool isKindOfClass_(objc.ObjCObjectBase aClass) {
    return _objc_msgSend_19nvye5(
        this.ref.pointer, _sel_isKindOfClass_, aClass.ref.pointer);
  }

  /// isMemberOfClass:
  bool isMemberOfClass_(objc.ObjCObjectBase aClass) {
    return _objc_msgSend_19nvye5(
        this.ref.pointer, _sel_isMemberOfClass_, aClass.ref.pointer);
  }

  /// isProxy
  bool isProxy() {
    return _objc_msgSend_91o635(this.ref.pointer, _sel_isProxy);
  }

  /// methodForSelector:
  ffi.Pointer<ffi.NativeFunction<ffi.Void Function()>> methodForSelector_(
      ffi.Pointer<objc.ObjCSelector> aSelector) {
    objc.checkOsVersionInternal('NSObject.methodForSelector:',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    return _objc_msgSend_1pa9f4m(
        this.ref.pointer, _sel_methodForSelector_, aSelector);
  }

  /// methodSignatureForSelector:
  NSMethodSignature methodSignatureForSelector_(
      ffi.Pointer<objc.ObjCSelector> aSelector) {
    final _ret = _objc_msgSend_3ctkt6(
        this.ref.pointer, _sel_methodSignatureForSelector_, aSelector);
    return NSMethodSignature.castFromPointer(_ret, retain: true, release: true);
  }

  /// mutableCopy
  objc.ObjCObjectBase mutableCopy() {
    objc.checkOsVersionInternal('NSObject.mutableCopy',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_mutableCopy);
    return objc.ObjCObjectBase(_ret, retain: false, release: true);
  }

  /// performSelector:
  objc.ObjCObjectBase performSelector_(
      ffi.Pointer<objc.ObjCSelector> aSelector) {
    final _ret = _objc_msgSend_3ctkt6(
        this.ref.pointer, _sel_performSelector_, aSelector);
    return objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// performSelector:withObject:
  objc.ObjCObjectBase performSelector_withObject_(
      ffi.Pointer<objc.ObjCSelector> aSelector, objc.ObjCObjectBase object) {
    final _ret = _objc_msgSend_gx50so(this.ref.pointer,
        _sel_performSelector_withObject_, aSelector, object.ref.pointer);
    return objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// performSelector:withObject:withObject:
  objc.ObjCObjectBase performSelector_withObject_withObject_(
      ffi.Pointer<objc.ObjCSelector> aSelector,
      objc.ObjCObjectBase object1,
      objc.ObjCObjectBase object2) {
    final _ret = _objc_msgSend_cfx8ce(
        this.ref.pointer,
        _sel_performSelector_withObject_withObject_,
        aSelector,
        object1.ref.pointer,
        object2.ref.pointer);
    return objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// release
  void release() {
    _objc_msgSend_1pl9qdv(this.ref.pointer, _sel_release);
  }

  /// respondsToSelector:
  bool respondsToSelector_(ffi.Pointer<objc.ObjCSelector> aSelector) {
    return _objc_msgSend_1srf6wk(
        this.ref.pointer, _sel_respondsToSelector_, aSelector);
  }

  /// retain
  NSObject retain() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_retain);
    return NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  /// retainCount
  int retainCount() {
    return _objc_msgSend_xw2lbc(this.ref.pointer, _sel_retainCount);
  }

  /// self
  NSObject self$1() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_self);
    return NSObject.castFromPointer(_ret, retain: true, release: true);
  }

  /// superclass
  objc.ObjCObjectBase get superclass$1 {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_superclass);
    return objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// zone
  ffi.Pointer<NSZone> zone() {
    return _objc_msgSend_sz90oi(this.ref.pointer, _sel_zone);
  }

  /// Returns a new instance of NSObject constructed with the default `new` method.
  factory NSObject() => new$();
}

/// NSObject
interface class NSObjectProtocol extends objc.ObjCProtocolBase {
  NSObjectProtocol._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super(pointer, retain: retain, release: release);

  /// Constructs a [NSObjectProtocol] that points to the same underlying object as [other].
  NSObjectProtocol.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSObjectProtocol] that wraps the given raw object pointer.
  NSObjectProtocol.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSObjectProtocol].
  static bool conformsTo(objc.ObjCObjectBase obj) {
    return _objc_msgSend_e3qsqz(
        obj.ref.pointer, _sel_conformsToProtocol_, _protocol_NSObject);
  }

  /// Returns the [objc.Protocol] object for this protocol.
  static objc.Protocol get $protocol =>
      objc.Protocol.castFromPointer(_protocol_NSObject.cast());

  /// Builds an object that implements the NSObject protocol. To implement
  /// multiple protocols, use [addToBuilder] or [objc.ObjCProtocolBuilder] directly.
  ///
  /// If `$keepIsolateAlive` is true, this protocol will keep this isolate
  /// alive until it is garbage collected by both Dart and ObjC.
  static NSObjectProtocol implement(
      {required objc.ObjCObjectBase Function() autorelease,
      required objc.ObjCObjectBase Function() class$,
      required bool Function(Protocol) conformsToProtocol_,
      NSString Function()? debugDescription,
      required NSString Function() description,
      required int Function() hash,
      required bool Function(objc.ObjCObjectBase) isEqual_,
      required bool Function(objc.ObjCObjectBase) isKindOfClass_,
      required bool Function(objc.ObjCObjectBase) isMemberOfClass_,
      required bool Function() isProxy,
      required objc.ObjCObjectBase Function(ffi.Pointer<objc.ObjCSelector>)
          performSelector_,
      required objc.ObjCObjectBase Function(
              ffi.Pointer<objc.ObjCSelector>, objc.ObjCObjectBase)
          performSelector_withObject_,
      required objc.ObjCObjectBase Function(ffi.Pointer<objc.ObjCSelector>,
              objc.ObjCObjectBase, objc.ObjCObjectBase)
          performSelector_withObject_withObject_,
      required void Function() release,
      required bool Function(ffi.Pointer<objc.ObjCSelector>)
          respondsToSelector_,
      required objc.ObjCObjectBase Function() retain,
      required int Function() retainCount,
      required objc.ObjCObjectBase Function() self$1,
      required objc.ObjCObjectBase Function() superclass,
      required ffi.Pointer<NSZone> Function() zone,
      bool $keepIsolateAlive = true}) {
    final builder = objc.ObjCProtocolBuilder(debugName: 'NSObject');
    NSObjectProtocol.autorelease.implement(builder, autorelease);
    NSObjectProtocol.class$.implement(builder, class$);
    NSObjectProtocol.conformsToProtocol_
        .implement(builder, conformsToProtocol_);
    NSObjectProtocol.debugDescription.implement(builder, debugDescription);
    NSObjectProtocol.description.implement(builder, description);
    NSObjectProtocol.hash.implement(builder, hash);
    NSObjectProtocol.isEqual_.implement(builder, isEqual_);
    NSObjectProtocol.isKindOfClass_.implement(builder, isKindOfClass_);
    NSObjectProtocol.isMemberOfClass_.implement(builder, isMemberOfClass_);
    NSObjectProtocol.isProxy.implement(builder, isProxy);
    NSObjectProtocol.performSelector_.implement(builder, performSelector_);
    NSObjectProtocol.performSelector_withObject_
        .implement(builder, performSelector_withObject_);
    NSObjectProtocol.performSelector_withObject_withObject_
        .implement(builder, performSelector_withObject_withObject_);
    NSObjectProtocol.release.implement(builder, release);
    NSObjectProtocol.respondsToSelector_
        .implement(builder, respondsToSelector_);
    NSObjectProtocol.retain.implement(builder, retain);
    NSObjectProtocol.retainCount.implement(builder, retainCount);
    NSObjectProtocol.self$1.implement(builder, self$1);
    NSObjectProtocol.superclass.implement(builder, superclass);
    NSObjectProtocol.zone.implement(builder, zone);
    builder.addProtocol($protocol);
    return NSObjectProtocol.castFrom(
        builder.build(keepIsolateAlive: $keepIsolateAlive));
  }

  /// Adds the implementation of the NSObject protocol to an existing
  /// [objc.ObjCProtocolBuilder].
  ///
  /// Note: You cannot call this method after you have called `builder.build`.
  static void addToBuilder(objc.ObjCProtocolBuilder builder,
      {required objc.ObjCObjectBase Function() autorelease,
      required objc.ObjCObjectBase Function() class$,
      required bool Function(Protocol) conformsToProtocol_,
      NSString Function()? debugDescription,
      required NSString Function() description,
      required int Function() hash,
      required bool Function(objc.ObjCObjectBase) isEqual_,
      required bool Function(objc.ObjCObjectBase) isKindOfClass_,
      required bool Function(objc.ObjCObjectBase) isMemberOfClass_,
      required bool Function() isProxy,
      required objc.ObjCObjectBase Function(ffi.Pointer<objc.ObjCSelector>)
          performSelector_,
      required objc.ObjCObjectBase Function(
              ffi.Pointer<objc.ObjCSelector>, objc.ObjCObjectBase)
          performSelector_withObject_,
      required objc.ObjCObjectBase Function(ffi.Pointer<objc.ObjCSelector>,
              objc.ObjCObjectBase, objc.ObjCObjectBase)
          performSelector_withObject_withObject_,
      required void Function() release,
      required bool Function(ffi.Pointer<objc.ObjCSelector>)
          respondsToSelector_,
      required objc.ObjCObjectBase Function() retain,
      required int Function() retainCount,
      required objc.ObjCObjectBase Function() self$1,
      required objc.ObjCObjectBase Function() superclass,
      required ffi.Pointer<NSZone> Function() zone,
      bool $keepIsolateAlive = true}) {
    NSObjectProtocol.autorelease.implement(builder, autorelease);
    NSObjectProtocol.class$.implement(builder, class$);
    NSObjectProtocol.conformsToProtocol_
        .implement(builder, conformsToProtocol_);
    NSObjectProtocol.debugDescription.implement(builder, debugDescription);
    NSObjectProtocol.description.implement(builder, description);
    NSObjectProtocol.hash.implement(builder, hash);
    NSObjectProtocol.isEqual_.implement(builder, isEqual_);
    NSObjectProtocol.isKindOfClass_.implement(builder, isKindOfClass_);
    NSObjectProtocol.isMemberOfClass_.implement(builder, isMemberOfClass_);
    NSObjectProtocol.isProxy.implement(builder, isProxy);
    NSObjectProtocol.performSelector_.implement(builder, performSelector_);
    NSObjectProtocol.performSelector_withObject_
        .implement(builder, performSelector_withObject_);
    NSObjectProtocol.performSelector_withObject_withObject_
        .implement(builder, performSelector_withObject_withObject_);
    NSObjectProtocol.release.implement(builder, release);
    NSObjectProtocol.respondsToSelector_
        .implement(builder, respondsToSelector_);
    NSObjectProtocol.retain.implement(builder, retain);
    NSObjectProtocol.retainCount.implement(builder, retainCount);
    NSObjectProtocol.self$1.implement(builder, self$1);
    NSObjectProtocol.superclass.implement(builder, superclass);
    NSObjectProtocol.zone.implement(builder, zone);
    builder.addProtocol($protocol);
  }

  /// Builds an object that implements the NSObject protocol. To implement
  /// multiple protocols, use [addToBuilder] or [objc.ObjCProtocolBuilder] directly. All
  /// methods that can be implemented as listeners will be.
  ///
  /// If `$keepIsolateAlive` is true, this protocol will keep this isolate
  /// alive until it is garbage collected by both Dart and ObjC.
  static NSObjectProtocol implementAsListener(
      {required objc.ObjCObjectBase Function() autorelease,
      required objc.ObjCObjectBase Function() class$,
      required bool Function(Protocol) conformsToProtocol_,
      NSString Function()? debugDescription,
      required NSString Function() description,
      required int Function() hash,
      required bool Function(objc.ObjCObjectBase) isEqual_,
      required bool Function(objc.ObjCObjectBase) isKindOfClass_,
      required bool Function(objc.ObjCObjectBase) isMemberOfClass_,
      required bool Function() isProxy,
      required objc.ObjCObjectBase Function(ffi.Pointer<objc.ObjCSelector>)
          performSelector_,
      required objc.ObjCObjectBase Function(
              ffi.Pointer<objc.ObjCSelector>, objc.ObjCObjectBase)
          performSelector_withObject_,
      required objc.ObjCObjectBase Function(ffi.Pointer<objc.ObjCSelector>,
              objc.ObjCObjectBase, objc.ObjCObjectBase)
          performSelector_withObject_withObject_,
      required void Function() release,
      required bool Function(ffi.Pointer<objc.ObjCSelector>)
          respondsToSelector_,
      required objc.ObjCObjectBase Function() retain,
      required int Function() retainCount,
      required objc.ObjCObjectBase Function() self$1,
      required objc.ObjCObjectBase Function() superclass,
      required ffi.Pointer<NSZone> Function() zone,
      bool $keepIsolateAlive = true}) {
    final builder = objc.ObjCProtocolBuilder(debugName: 'NSObject');
    NSObjectProtocol.autorelease.implement(builder, autorelease);
    NSObjectProtocol.class$.implement(builder, class$);
    NSObjectProtocol.conformsToProtocol_
        .implement(builder, conformsToProtocol_);
    NSObjectProtocol.debugDescription.implement(builder, debugDescription);
    NSObjectProtocol.description.implement(builder, description);
    NSObjectProtocol.hash.implement(builder, hash);
    NSObjectProtocol.isEqual_.implement(builder, isEqual_);
    NSObjectProtocol.isKindOfClass_.implement(builder, isKindOfClass_);
    NSObjectProtocol.isMemberOfClass_.implement(builder, isMemberOfClass_);
    NSObjectProtocol.isProxy.implement(builder, isProxy);
    NSObjectProtocol.performSelector_.implement(builder, performSelector_);
    NSObjectProtocol.performSelector_withObject_
        .implement(builder, performSelector_withObject_);
    NSObjectProtocol.performSelector_withObject_withObject_
        .implement(builder, performSelector_withObject_withObject_);
    NSObjectProtocol.release.implementAsListener(builder, release);
    NSObjectProtocol.respondsToSelector_
        .implement(builder, respondsToSelector_);
    NSObjectProtocol.retain.implement(builder, retain);
    NSObjectProtocol.retainCount.implement(builder, retainCount);
    NSObjectProtocol.self$1.implement(builder, self$1);
    NSObjectProtocol.superclass.implement(builder, superclass);
    NSObjectProtocol.zone.implement(builder, zone);
    builder.addProtocol($protocol);
    return NSObjectProtocol.castFrom(
        builder.build(keepIsolateAlive: $keepIsolateAlive));
  }

  /// Adds the implementation of the NSObject protocol to an existing
  /// [objc.ObjCProtocolBuilder]. All methods that can be implemented as listeners will
  /// be.
  ///
  /// Note: You cannot call this method after you have called `builder.build`.
  static void addToBuilderAsListener(objc.ObjCProtocolBuilder builder,
      {required objc.ObjCObjectBase Function() autorelease,
      required objc.ObjCObjectBase Function() class$,
      required bool Function(Protocol) conformsToProtocol_,
      NSString Function()? debugDescription,
      required NSString Function() description,
      required int Function() hash,
      required bool Function(objc.ObjCObjectBase) isEqual_,
      required bool Function(objc.ObjCObjectBase) isKindOfClass_,
      required bool Function(objc.ObjCObjectBase) isMemberOfClass_,
      required bool Function() isProxy,
      required objc.ObjCObjectBase Function(ffi.Pointer<objc.ObjCSelector>)
          performSelector_,
      required objc.ObjCObjectBase Function(
              ffi.Pointer<objc.ObjCSelector>, objc.ObjCObjectBase)
          performSelector_withObject_,
      required objc.ObjCObjectBase Function(ffi.Pointer<objc.ObjCSelector>,
              objc.ObjCObjectBase, objc.ObjCObjectBase)
          performSelector_withObject_withObject_,
      required void Function() release,
      required bool Function(ffi.Pointer<objc.ObjCSelector>)
          respondsToSelector_,
      required objc.ObjCObjectBase Function() retain,
      required int Function() retainCount,
      required objc.ObjCObjectBase Function() self$1,
      required objc.ObjCObjectBase Function() superclass,
      required ffi.Pointer<NSZone> Function() zone,
      bool $keepIsolateAlive = true}) {
    NSObjectProtocol.autorelease.implement(builder, autorelease);
    NSObjectProtocol.class$.implement(builder, class$);
    NSObjectProtocol.conformsToProtocol_
        .implement(builder, conformsToProtocol_);
    NSObjectProtocol.debugDescription.implement(builder, debugDescription);
    NSObjectProtocol.description.implement(builder, description);
    NSObjectProtocol.hash.implement(builder, hash);
    NSObjectProtocol.isEqual_.implement(builder, isEqual_);
    NSObjectProtocol.isKindOfClass_.implement(builder, isKindOfClass_);
    NSObjectProtocol.isMemberOfClass_.implement(builder, isMemberOfClass_);
    NSObjectProtocol.isProxy.implement(builder, isProxy);
    NSObjectProtocol.performSelector_.implement(builder, performSelector_);
    NSObjectProtocol.performSelector_withObject_
        .implement(builder, performSelector_withObject_);
    NSObjectProtocol.performSelector_withObject_withObject_
        .implement(builder, performSelector_withObject_withObject_);
    NSObjectProtocol.release.implementAsListener(builder, release);
    NSObjectProtocol.respondsToSelector_
        .implement(builder, respondsToSelector_);
    NSObjectProtocol.retain.implement(builder, retain);
    NSObjectProtocol.retainCount.implement(builder, retainCount);
    NSObjectProtocol.self$1.implement(builder, self$1);
    NSObjectProtocol.superclass.implement(builder, superclass);
    NSObjectProtocol.zone.implement(builder, zone);
    builder.addProtocol($protocol);
  }

  /// Builds an object that implements the NSObject protocol. To implement
  /// multiple protocols, use [addToBuilder] or [objc.ObjCProtocolBuilder] directly. All
  /// methods that can be implemented as blocking listeners will be.
  ///
  /// If `$keepIsolateAlive` is true, this protocol will keep this isolate
  /// alive until it is garbage collected by both Dart and ObjC.
  static NSObjectProtocol implementAsBlocking(
      {required objc.ObjCObjectBase Function() autorelease,
      required objc.ObjCObjectBase Function() class$,
      required bool Function(Protocol) conformsToProtocol_,
      NSString Function()? debugDescription,
      required NSString Function() description,
      required int Function() hash,
      required bool Function(objc.ObjCObjectBase) isEqual_,
      required bool Function(objc.ObjCObjectBase) isKindOfClass_,
      required bool Function(objc.ObjCObjectBase) isMemberOfClass_,
      required bool Function() isProxy,
      required objc.ObjCObjectBase Function(ffi.Pointer<objc.ObjCSelector>)
          performSelector_,
      required objc.ObjCObjectBase Function(
              ffi.Pointer<objc.ObjCSelector>, objc.ObjCObjectBase)
          performSelector_withObject_,
      required objc.ObjCObjectBase Function(ffi.Pointer<objc.ObjCSelector>,
              objc.ObjCObjectBase, objc.ObjCObjectBase)
          performSelector_withObject_withObject_,
      required void Function() release,
      required bool Function(ffi.Pointer<objc.ObjCSelector>)
          respondsToSelector_,
      required objc.ObjCObjectBase Function() retain,
      required int Function() retainCount,
      required objc.ObjCObjectBase Function() self$1,
      required objc.ObjCObjectBase Function() superclass,
      required ffi.Pointer<NSZone> Function() zone,
      bool $keepIsolateAlive = true}) {
    final builder = objc.ObjCProtocolBuilder(debugName: 'NSObject');
    NSObjectProtocol.autorelease.implement(builder, autorelease);
    NSObjectProtocol.class$.implement(builder, class$);
    NSObjectProtocol.conformsToProtocol_
        .implement(builder, conformsToProtocol_);
    NSObjectProtocol.debugDescription.implement(builder, debugDescription);
    NSObjectProtocol.description.implement(builder, description);
    NSObjectProtocol.hash.implement(builder, hash);
    NSObjectProtocol.isEqual_.implement(builder, isEqual_);
    NSObjectProtocol.isKindOfClass_.implement(builder, isKindOfClass_);
    NSObjectProtocol.isMemberOfClass_.implement(builder, isMemberOfClass_);
    NSObjectProtocol.isProxy.implement(builder, isProxy);
    NSObjectProtocol.performSelector_.implement(builder, performSelector_);
    NSObjectProtocol.performSelector_withObject_
        .implement(builder, performSelector_withObject_);
    NSObjectProtocol.performSelector_withObject_withObject_
        .implement(builder, performSelector_withObject_withObject_);
    NSObjectProtocol.release.implementAsBlocking(builder, release);
    NSObjectProtocol.respondsToSelector_
        .implement(builder, respondsToSelector_);
    NSObjectProtocol.retain.implement(builder, retain);
    NSObjectProtocol.retainCount.implement(builder, retainCount);
    NSObjectProtocol.self$1.implement(builder, self$1);
    NSObjectProtocol.superclass.implement(builder, superclass);
    NSObjectProtocol.zone.implement(builder, zone);
    builder.addProtocol($protocol);
    return NSObjectProtocol.castFrom(
        builder.build(keepIsolateAlive: $keepIsolateAlive));
  }

  /// Adds the implementation of the NSObject protocol to an existing
  /// [objc.ObjCProtocolBuilder]. All methods that can be implemented as blocking
  /// listeners will be.
  ///
  /// Note: You cannot call this method after you have called `builder.build`.
  static void addToBuilderAsBlocking(objc.ObjCProtocolBuilder builder,
      {required objc.ObjCObjectBase Function() autorelease,
      required objc.ObjCObjectBase Function() class$,
      required bool Function(Protocol) conformsToProtocol_,
      NSString Function()? debugDescription,
      required NSString Function() description,
      required int Function() hash,
      required bool Function(objc.ObjCObjectBase) isEqual_,
      required bool Function(objc.ObjCObjectBase) isKindOfClass_,
      required bool Function(objc.ObjCObjectBase) isMemberOfClass_,
      required bool Function() isProxy,
      required objc.ObjCObjectBase Function(ffi.Pointer<objc.ObjCSelector>)
          performSelector_,
      required objc.ObjCObjectBase Function(
              ffi.Pointer<objc.ObjCSelector>, objc.ObjCObjectBase)
          performSelector_withObject_,
      required objc.ObjCObjectBase Function(ffi.Pointer<objc.ObjCSelector>,
              objc.ObjCObjectBase, objc.ObjCObjectBase)
          performSelector_withObject_withObject_,
      required void Function() release,
      required bool Function(ffi.Pointer<objc.ObjCSelector>)
          respondsToSelector_,
      required objc.ObjCObjectBase Function() retain,
      required int Function() retainCount,
      required objc.ObjCObjectBase Function() self$1,
      required objc.ObjCObjectBase Function() superclass,
      required ffi.Pointer<NSZone> Function() zone,
      bool $keepIsolateAlive = true}) {
    NSObjectProtocol.autorelease.implement(builder, autorelease);
    NSObjectProtocol.class$.implement(builder, class$);
    NSObjectProtocol.conformsToProtocol_
        .implement(builder, conformsToProtocol_);
    NSObjectProtocol.debugDescription.implement(builder, debugDescription);
    NSObjectProtocol.description.implement(builder, description);
    NSObjectProtocol.hash.implement(builder, hash);
    NSObjectProtocol.isEqual_.implement(builder, isEqual_);
    NSObjectProtocol.isKindOfClass_.implement(builder, isKindOfClass_);
    NSObjectProtocol.isMemberOfClass_.implement(builder, isMemberOfClass_);
    NSObjectProtocol.isProxy.implement(builder, isProxy);
    NSObjectProtocol.performSelector_.implement(builder, performSelector_);
    NSObjectProtocol.performSelector_withObject_
        .implement(builder, performSelector_withObject_);
    NSObjectProtocol.performSelector_withObject_withObject_
        .implement(builder, performSelector_withObject_withObject_);
    NSObjectProtocol.release.implementAsBlocking(builder, release);
    NSObjectProtocol.respondsToSelector_
        .implement(builder, respondsToSelector_);
    NSObjectProtocol.retain.implement(builder, retain);
    NSObjectProtocol.retainCount.implement(builder, retainCount);
    NSObjectProtocol.self$1.implement(builder, self$1);
    NSObjectProtocol.superclass.implement(builder, superclass);
    NSObjectProtocol.zone.implement(builder, zone);
    builder.addProtocol($protocol);
  }

  /// autorelease
  static final autorelease =
      objc.ObjCProtocolMethod<objc.ObjCObjectBase Function()>(
    _protocol_NSObject,
    _sel_autorelease,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.Pointer<objc.ObjCObject> Function(
                        ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>)>>(
            _ObjectiveCBindings_protocolTrampoline_1mbt9g9)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSObject,
      _sel_autorelease,
      isRequired: true,
      isInstanceMethod: true,
    ),
    (objc.ObjCObjectBase Function() func) =>
        ObjCBlock_objcObjCObject_ffiVoid.fromFunction((
      ffi.Pointer<ffi.Void> _,
    ) =>
            func()),
  );

  /// class
  static final class$ = objc.ObjCProtocolMethod<objc.ObjCObjectBase Function()>(
    _protocol_NSObject,
    _sel_class,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.Pointer<objc.ObjCObject> Function(
                        ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>)>>(
            _ObjectiveCBindings_protocolTrampoline_1mbt9g9)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSObject,
      _sel_class,
      isRequired: true,
      isInstanceMethod: true,
    ),
    (objc.ObjCObjectBase Function() func) =>
        ObjCBlock_objcObjCObject_ffiVoid.fromFunction((
      ffi.Pointer<ffi.Void> _,
    ) =>
            func()),
  );

  /// conformsToProtocol:
  static final conformsToProtocol_ =
      objc.ObjCProtocolMethod<bool Function(Protocol)>(
    _protocol_NSObject,
    _sel_conformsToProtocol_,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.Bool Function(ffi.Pointer<objc.ObjCObject>,
                        ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>>(
            _ObjectiveCBindings_protocolTrampoline_3su7tt)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSObject,
      _sel_conformsToProtocol_,
      isRequired: true,
      isInstanceMethod: true,
    ),
    (bool Function(Protocol) func) =>
        ObjCBlock_bool_ffiVoid_Protocol.fromFunction(
            (ffi.Pointer<ffi.Void> _, Protocol arg1) => func(arg1)),
  );

  /// debugDescription
  static final debugDescription = objc.ObjCProtocolMethod<NSString Function()>(
    _protocol_NSObject,
    _sel_debugDescription,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.Pointer<objc.ObjCObject> Function(
                        ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>)>>(
            _ObjectiveCBindings_protocolTrampoline_1mbt9g9)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSObject,
      _sel_debugDescription,
      isRequired: false,
      isInstanceMethod: true,
    ),
    (NSString Function() func) => ObjCBlock_NSString_ffiVoid.fromFunction((
      ffi.Pointer<ffi.Void> _,
    ) =>
        func()),
  );

  /// description
  static final description = objc.ObjCProtocolMethod<NSString Function()>(
    _protocol_NSObject,
    _sel_description,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.Pointer<objc.ObjCObject> Function(
                        ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>)>>(
            _ObjectiveCBindings_protocolTrampoline_1mbt9g9)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSObject,
      _sel_description,
      isRequired: true,
      isInstanceMethod: true,
    ),
    (NSString Function() func) => ObjCBlock_NSString_ffiVoid.fromFunction((
      ffi.Pointer<ffi.Void> _,
    ) =>
        func()),
  );

  /// hash
  static final hash = objc.ObjCProtocolMethod<int Function()>(
    _protocol_NSObject,
    _sel_hash,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.UnsignedLong Function(
                        ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>)>>(
            _ObjectiveCBindings_protocolTrampoline_1ckyi24)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSObject,
      _sel_hash,
      isRequired: true,
      isInstanceMethod: true,
    ),
    (int Function() func) => ObjCBlock_NSUInteger_ffiVoid.fromFunction((
      ffi.Pointer<ffi.Void> _,
    ) =>
        func()),
  );

  /// isEqual:
  static final isEqual_ =
      objc.ObjCProtocolMethod<bool Function(objc.ObjCObjectBase)>(
    _protocol_NSObject,
    _sel_isEqual_,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.Bool Function(ffi.Pointer<objc.ObjCObject>,
                        ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>>(
            _ObjectiveCBindings_protocolTrampoline_3su7tt)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSObject,
      _sel_isEqual_,
      isRequired: true,
      isInstanceMethod: true,
    ),
    (bool Function(objc.ObjCObjectBase) func) =>
        ObjCBlock_bool_ffiVoid_objcObjCObject.fromFunction(
            (ffi.Pointer<ffi.Void> _, objc.ObjCObjectBase arg1) => func(arg1)),
  );

  /// isKindOfClass:
  static final isKindOfClass_ =
      objc.ObjCProtocolMethod<bool Function(objc.ObjCObjectBase)>(
    _protocol_NSObject,
    _sel_isKindOfClass_,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.Bool Function(ffi.Pointer<objc.ObjCObject>,
                        ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>>(
            _ObjectiveCBindings_protocolTrampoline_3su7tt)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSObject,
      _sel_isKindOfClass_,
      isRequired: true,
      isInstanceMethod: true,
    ),
    (bool Function(objc.ObjCObjectBase) func) =>
        ObjCBlock_bool_ffiVoid_objcObjCObject.fromFunction(
            (ffi.Pointer<ffi.Void> _, objc.ObjCObjectBase arg1) => func(arg1)),
  );

  /// isMemberOfClass:
  static final isMemberOfClass_ =
      objc.ObjCProtocolMethod<bool Function(objc.ObjCObjectBase)>(
    _protocol_NSObject,
    _sel_isMemberOfClass_,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.Bool Function(ffi.Pointer<objc.ObjCObject>,
                        ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>>(
            _ObjectiveCBindings_protocolTrampoline_3su7tt)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSObject,
      _sel_isMemberOfClass_,
      isRequired: true,
      isInstanceMethod: true,
    ),
    (bool Function(objc.ObjCObjectBase) func) =>
        ObjCBlock_bool_ffiVoid_objcObjCObject.fromFunction(
            (ffi.Pointer<ffi.Void> _, objc.ObjCObjectBase arg1) => func(arg1)),
  );

  /// isProxy
  static final isProxy = objc.ObjCProtocolMethod<bool Function()>(
    _protocol_NSObject,
    _sel_isProxy,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.Bool Function(
                        ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>)>>(
            _ObjectiveCBindings_protocolTrampoline_e3qsqz)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSObject,
      _sel_isProxy,
      isRequired: true,
      isInstanceMethod: true,
    ),
    (bool Function() func) => ObjCBlock_bool_ffiVoid.fromFunction((
      ffi.Pointer<ffi.Void> _,
    ) =>
        func()),
  );

  /// performSelector:
  static final performSelector_ = objc.ObjCProtocolMethod<
      objc.ObjCObjectBase Function(ffi.Pointer<objc.ObjCSelector>)>(
    _protocol_NSObject,
    _sel_performSelector_,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.Pointer<objc.ObjCObject> Function(
                        ffi.Pointer<objc.ObjCObject>,
                        ffi.Pointer<ffi.Void>,
                        ffi.Pointer<objc.ObjCSelector>)>>(
            _ObjectiveCBindings_protocolTrampoline_50as9u)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSObject,
      _sel_performSelector_,
      isRequired: true,
      isInstanceMethod: true,
    ),
    (objc.ObjCObjectBase Function(ffi.Pointer<objc.ObjCSelector>) func) =>
        ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector.fromFunction(
            (ffi.Pointer<ffi.Void> _, ffi.Pointer<objc.ObjCSelector> arg1) =>
                func(arg1)),
  );

  /// performSelector:withObject:
  static final performSelector_withObject_ = objc.ObjCProtocolMethod<
      objc.ObjCObjectBase Function(
          ffi.Pointer<objc.ObjCSelector>, objc.ObjCObjectBase)>(
    _protocol_NSObject,
    _sel_performSelector_withObject_,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.Pointer<objc.ObjCObject> Function(
                        ffi.Pointer<objc.ObjCObject>,
                        ffi.Pointer<ffi.Void>,
                        ffi.Pointer<objc.ObjCSelector>,
                        ffi.Pointer<objc.ObjCObject>)>>(
            _ObjectiveCBindings_protocolTrampoline_1mllhpc)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSObject,
      _sel_performSelector_withObject_,
      isRequired: true,
      isInstanceMethod: true,
    ),
    (objc.ObjCObjectBase Function(
                ffi.Pointer<objc.ObjCSelector>, objc.ObjCObjectBase)
            func) =>
        ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_objcObjCObject
            .fromFunction((ffi.Pointer<ffi.Void> _,
                    ffi.Pointer<objc.ObjCSelector> arg1,
                    objc.ObjCObjectBase arg2) =>
                func(arg1, arg2)),
  );

  /// performSelector:withObject:withObject:
  static final performSelector_withObject_withObject_ = objc.ObjCProtocolMethod<
      objc.ObjCObjectBase Function(ffi.Pointer<objc.ObjCSelector>,
          objc.ObjCObjectBase, objc.ObjCObjectBase)>(
    _protocol_NSObject,
    _sel_performSelector_withObject_withObject_,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.Pointer<objc.ObjCObject> Function(
                        ffi.Pointer<objc.ObjCObject>,
                        ffi.Pointer<ffi.Void>,
                        ffi.Pointer<objc.ObjCSelector>,
                        ffi.Pointer<objc.ObjCObject>,
                        ffi.Pointer<objc.ObjCObject>)>>(
            _ObjectiveCBindings_protocolTrampoline_c7gk2u)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSObject,
      _sel_performSelector_withObject_withObject_,
      isRequired: true,
      isInstanceMethod: true,
    ),
    (objc.ObjCObjectBase Function(ffi.Pointer<objc.ObjCSelector>,
                objc.ObjCObjectBase, objc.ObjCObjectBase)
            func) =>
        ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_objcObjCObject_objcObjCObject
            .fromFunction((ffi.Pointer<ffi.Void> _,
                    ffi.Pointer<objc.ObjCSelector> arg1,
                    objc.ObjCObjectBase arg2,
                    objc.ObjCObjectBase arg3) =>
                func(arg1, arg2, arg3)),
  );

  /// release
  static final release = objc.ObjCProtocolListenableMethod<void Function()>(
    _protocol_NSObject,
    _sel_release,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.Void Function(
                        ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>)>>(
            _ObjectiveCBindings_protocolTrampoline_ovsamd)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSObject,
      _sel_release,
      isRequired: true,
      isInstanceMethod: true,
    ),
    (void Function() func) => ObjCBlock_ffiVoid_ffiVoid.fromFunction((
      ffi.Pointer<ffi.Void> _,
    ) =>
        func()),
    (void Function() func) => ObjCBlock_ffiVoid_ffiVoid.listener((
      ffi.Pointer<ffi.Void> _,
    ) =>
        func()),
    (void Function() func) => ObjCBlock_ffiVoid_ffiVoid.blocking((
      ffi.Pointer<ffi.Void> _,
    ) =>
        func()),
  );

  /// respondsToSelector:
  static final respondsToSelector_ =
      objc.ObjCProtocolMethod<bool Function(ffi.Pointer<objc.ObjCSelector>)>(
    _protocol_NSObject,
    _sel_respondsToSelector_,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.Bool Function(
                        ffi.Pointer<objc.ObjCObject>,
                        ffi.Pointer<ffi.Void>,
                        ffi.Pointer<objc.ObjCSelector>)>>(
            _ObjectiveCBindings_protocolTrampoline_w1e3k0)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSObject,
      _sel_respondsToSelector_,
      isRequired: true,
      isInstanceMethod: true,
    ),
    (bool Function(ffi.Pointer<objc.ObjCSelector>) func) =>
        ObjCBlock_bool_ffiVoid_objcObjCSelector.fromFunction(
            (ffi.Pointer<ffi.Void> _, ffi.Pointer<objc.ObjCSelector> arg1) =>
                func(arg1)),
  );

  /// retain
  static final retain = objc.ObjCProtocolMethod<objc.ObjCObjectBase Function()>(
    _protocol_NSObject,
    _sel_retain,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.Pointer<objc.ObjCObject> Function(
                        ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>)>>(
            _ObjectiveCBindings_protocolTrampoline_1mbt9g9)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSObject,
      _sel_retain,
      isRequired: true,
      isInstanceMethod: true,
    ),
    (objc.ObjCObjectBase Function() func) =>
        ObjCBlock_objcObjCObject_ffiVoid.fromFunction((
      ffi.Pointer<ffi.Void> _,
    ) =>
            func()),
  );

  /// retainCount
  static final retainCount = objc.ObjCProtocolMethod<int Function()>(
    _protocol_NSObject,
    _sel_retainCount,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.UnsignedLong Function(
                        ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>)>>(
            _ObjectiveCBindings_protocolTrampoline_1ckyi24)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSObject,
      _sel_retainCount,
      isRequired: true,
      isInstanceMethod: true,
    ),
    (int Function() func) => ObjCBlock_NSUInteger_ffiVoid.fromFunction((
      ffi.Pointer<ffi.Void> _,
    ) =>
        func()),
  );

  /// self
  static final self$1 = objc.ObjCProtocolMethod<objc.ObjCObjectBase Function()>(
    _protocol_NSObject,
    _sel_self,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.Pointer<objc.ObjCObject> Function(
                        ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>)>>(
            _ObjectiveCBindings_protocolTrampoline_1mbt9g9)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSObject,
      _sel_self,
      isRequired: true,
      isInstanceMethod: true,
    ),
    (objc.ObjCObjectBase Function() func) =>
        ObjCBlock_objcObjCObject_ffiVoid.fromFunction((
      ffi.Pointer<ffi.Void> _,
    ) =>
            func()),
  );

  /// superclass
  static final superclass =
      objc.ObjCProtocolMethod<objc.ObjCObjectBase Function()>(
    _protocol_NSObject,
    _sel_superclass,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.Pointer<objc.ObjCObject> Function(
                        ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>)>>(
            _ObjectiveCBindings_protocolTrampoline_1mbt9g9)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSObject,
      _sel_superclass,
      isRequired: true,
      isInstanceMethod: true,
    ),
    (objc.ObjCObjectBase Function() func) =>
        ObjCBlock_objcObjCObject_ffiVoid.fromFunction((
      ffi.Pointer<ffi.Void> _,
    ) =>
            func()),
  );

  /// zone
  static final zone = objc.ObjCProtocolMethod<ffi.Pointer<NSZone> Function()>(
    _protocol_NSObject,
    _sel_zone,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.Pointer<NSZone> Function(
                        ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>)>>(
            _ObjectiveCBindings_protocolTrampoline_1a8cl66)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSObject,
      _sel_zone,
      isRequired: true,
      isInstanceMethod: true,
    ),
    (ffi.Pointer<NSZone> Function() func) =>
        ObjCBlock_NSZone_ffiVoid.fromFunction((
      ffi.Pointer<ffi.Void> _,
    ) =>
            func()),
  );
}

/// NSOrderedCollectionDifference
///
/// iOS: introduced 13.0.0
/// macOS: introduced 10.15.0
class NSOrderedCollectionDifference extends NSObject
    implements NSFastEnumeration {
  NSOrderedCollectionDifference._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release) {
    objc.checkOsVersionInternal('NSOrderedCollectionDifference',
        iOS: (false, (13, 0, 0)), macOS: (false, (10, 15, 0)));
  }

  /// Constructs a [NSOrderedCollectionDifference] that points to the same underlying object as [other].
  NSOrderedCollectionDifference.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSOrderedCollectionDifference] that wraps the given raw object pointer.
  NSOrderedCollectionDifference.castFromPointer(
      ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false,
      bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSOrderedCollectionDifference].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(obj.ref.pointer, _sel_isKindOfClass_,
        _class_NSOrderedCollectionDifference);
  }

  /// alloc
  static NSOrderedCollectionDifference alloc() {
    final _ret =
        _objc_msgSend_151sglz(_class_NSOrderedCollectionDifference, _sel_alloc);
    return NSOrderedCollectionDifference.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// allocWithZone:
  static NSOrderedCollectionDifference allocWithZone_(
      ffi.Pointer<NSZone> zone) {
    final _ret = _objc_msgSend_1cwp428(
        _class_NSOrderedCollectionDifference, _sel_allocWithZone_, zone);
    return NSOrderedCollectionDifference.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// new
  static NSOrderedCollectionDifference new$() {
    final _ret =
        _objc_msgSend_151sglz(_class_NSOrderedCollectionDifference, _sel_new);
    return NSOrderedCollectionDifference.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// countByEnumeratingWithState:objects:count:
  int countByEnumeratingWithState_objects_count_(
      ffi.Pointer<NSFastEnumerationState> state,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> buffer,
      int len) {
    return _objc_msgSend_1b5ysjl(this.ref.pointer,
        _sel_countByEnumeratingWithState_objects_count_, state, buffer, len);
  }

  /// iOS: introduced 13.0.0
  /// macOS: introduced 10.15.0
  bool get hasChanges {
    objc.checkOsVersionInternal('NSOrderedCollectionDifference.hasChanges',
        iOS: (false, (13, 0, 0)), macOS: (false, (10, 15, 0)));
    return _objc_msgSend_91o635(this.ref.pointer, _sel_hasChanges);
  }

  /// init
  NSOrderedCollectionDifference init() {
    objc.checkOsVersionInternal('NSOrderedCollectionDifference.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSOrderedCollectionDifference.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// initWithChanges:
  ///
  /// iOS: introduced 13.0.0
  /// macOS: introduced 10.15.0
  NSOrderedCollectionDifference initWithChanges_(objc.ObjCObjectBase changes) {
    objc.checkOsVersionInternal(
        'NSOrderedCollectionDifference.initWithChanges:',
        iOS: (false, (13, 0, 0)),
        macOS: (false, (10, 15, 0)));
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithChanges_, changes.ref.pointer);
    return NSOrderedCollectionDifference.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// initWithInsertIndexes:insertedObjects:removeIndexes:removedObjects:
  ///
  /// iOS: introduced 13.0.0
  /// macOS: introduced 10.15.0
  NSOrderedCollectionDifference
      initWithInsertIndexes_insertedObjects_removeIndexes_removedObjects_(
          NSIndexSet inserts,
          objc.ObjCObjectBase? insertedObjects,
          NSIndexSet removes,
          objc.ObjCObjectBase? removedObjects) {
    objc.checkOsVersionInternal(
        'NSOrderedCollectionDifference.initWithInsertIndexes:insertedObjects:removeIndexes:removedObjects:',
        iOS: (false, (13, 0, 0)),
        macOS: (false, (10, 15, 0)));
    final _ret = _objc_msgSend_s92gih(
        this.ref.retainAndReturnPointer(),
        _sel_initWithInsertIndexes_insertedObjects_removeIndexes_removedObjects_,
        inserts.ref.pointer,
        insertedObjects?.ref.pointer ?? ffi.nullptr,
        removes.ref.pointer,
        removedObjects?.ref.pointer ?? ffi.nullptr);
    return NSOrderedCollectionDifference.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// initWithInsertIndexes:insertedObjects:removeIndexes:removedObjects:additionalChanges:
  ///
  /// iOS: introduced 13.0.0
  /// macOS: introduced 10.15.0
  NSOrderedCollectionDifference
      initWithInsertIndexes_insertedObjects_removeIndexes_removedObjects_additionalChanges_(
          NSIndexSet inserts,
          objc.ObjCObjectBase? insertedObjects,
          NSIndexSet removes,
          objc.ObjCObjectBase? removedObjects,
          objc.ObjCObjectBase changes) {
    objc.checkOsVersionInternal(
        'NSOrderedCollectionDifference.initWithInsertIndexes:insertedObjects:removeIndexes:removedObjects:additionalChanges:',
        iOS: (false, (13, 0, 0)),
        macOS: (false, (10, 15, 0)));
    final _ret = _objc_msgSend_3cbdpb(
        this.ref.retainAndReturnPointer(),
        _sel_initWithInsertIndexes_insertedObjects_removeIndexes_removedObjects_additionalChanges_,
        inserts.ref.pointer,
        insertedObjects?.ref.pointer ?? ffi.nullptr,
        removes.ref.pointer,
        removedObjects?.ref.pointer ?? ffi.nullptr,
        changes.ref.pointer);
    return NSOrderedCollectionDifference.castFromPointer(_ret,
        retain: false, release: true);
  }

  /// iOS: introduced 13.0.0
  /// macOS: introduced 10.15.0
  objc.ObjCObjectBase get insertions {
    objc.checkOsVersionInternal('NSOrderedCollectionDifference.insertions',
        iOS: (false, (13, 0, 0)), macOS: (false, (10, 15, 0)));
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_insertions);
    return objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// inverseDifference
  ///
  /// iOS: introduced 13.0.0
  /// macOS: introduced 10.15.0
  NSOrderedCollectionDifference inverseDifference() {
    objc.checkOsVersionInternal(
        'NSOrderedCollectionDifference.inverseDifference',
        iOS: (false, (13, 0, 0)),
        macOS: (false, (10, 15, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.pointer, _sel_inverseDifference);
    return NSOrderedCollectionDifference.castFromPointer(_ret,
        retain: true, release: true);
  }

  /// iOS: introduced 13.0.0
  /// macOS: introduced 10.15.0
  objc.ObjCObjectBase get removals {
    objc.checkOsVersionInternal('NSOrderedCollectionDifference.removals',
        iOS: (false, (13, 0, 0)), macOS: (false, (10, 15, 0)));
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_removals);
    return objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// Returns a new instance of NSOrderedCollectionDifference constructed with the default `new` method.
  factory NSOrderedCollectionDifference() => new$();
}

/// iOS: introduced 13.0.0
/// macOS: introduced 10.15.0
enum NSOrderedCollectionDifferenceCalculationOptions {
  NSOrderedCollectionDifferenceCalculationOmitInsertedObjects(1),
  NSOrderedCollectionDifferenceCalculationOmitRemovedObjects(2),
  NSOrderedCollectionDifferenceCalculationInferMoves(4);

  final int value;
  const NSOrderedCollectionDifferenceCalculationOptions(this.value);

  static NSOrderedCollectionDifferenceCalculationOptions fromValue(int value) =>
      switch (value) {
        1 => NSOrderedCollectionDifferenceCalculationOmitInsertedObjects,
        2 => NSOrderedCollectionDifferenceCalculationOmitRemovedObjects,
        4 => NSOrderedCollectionDifferenceCalculationInferMoves,
        _ => throw ArgumentError(
            'Unknown value for NSOrderedCollectionDifferenceCalculationOptions: $value'),
      };
}

/// NSOrderedSet
class NSOrderedSet extends NSObject
    implements NSCopying, NSMutableCopying, NSSecureCoding, NSFastEnumeration {
  NSOrderedSet._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release) {
    objc.checkOsVersionInternal('NSOrderedSet',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
  }

  /// Constructs a [NSOrderedSet] that points to the same underlying object as [other].
  NSOrderedSet.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSOrderedSet] that wraps the given raw object pointer.
  NSOrderedSet.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSOrderedSet].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSOrderedSet);
  }

  /// alloc
  static NSOrderedSet alloc() {
    final _ret = _objc_msgSend_151sglz(_class_NSOrderedSet, _sel_alloc);
    return NSOrderedSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// allocWithZone:
  static NSOrderedSet allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret =
        _objc_msgSend_1cwp428(_class_NSOrderedSet, _sel_allocWithZone_, zone);
    return NSOrderedSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// new
  static NSOrderedSet new$() {
    final _ret = _objc_msgSend_151sglz(_class_NSOrderedSet, _sel_new);
    return NSOrderedSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// orderedSet
  static NSOrderedSet orderedSet() {
    objc.checkOsVersionInternal('NSOrderedSet.orderedSet',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_151sglz(_class_NSOrderedSet, _sel_orderedSet);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// orderedSetWithArray:
  static NSOrderedSet orderedSetWithArray_(NSArray array) {
    objc.checkOsVersionInternal('NSOrderedSet.orderedSetWithArray:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSOrderedSet, _sel_orderedSetWithArray_, array.ref.pointer);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// orderedSetWithArray:range:copyItems:
  static NSOrderedSet orderedSetWithArray_range_copyItems_(
      NSArray array, NSRange range, bool flag) {
    objc.checkOsVersionInternal(
        'NSOrderedSet.orderedSetWithArray:range:copyItems:',
        iOS: (false, (5, 0, 0)),
        macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_w9bq5x(
        _class_NSOrderedSet,
        _sel_orderedSetWithArray_range_copyItems_,
        array.ref.pointer,
        range,
        flag);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// orderedSetWithObject:
  static NSOrderedSet orderedSetWithObject_(objc.ObjCObjectBase object) {
    objc.checkOsVersionInternal('NSOrderedSet.orderedSetWithObject:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSOrderedSet, _sel_orderedSetWithObject_, object.ref.pointer);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// orderedSetWithObjects:
  static NSOrderedSet orderedSetWithObjects_(objc.ObjCObjectBase firstObj) {
    objc.checkOsVersionInternal('NSOrderedSet.orderedSetWithObjects:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSOrderedSet, _sel_orderedSetWithObjects_, firstObj.ref.pointer);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// orderedSetWithObjects:count:
  static NSOrderedSet orderedSetWithObjects_count_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects, int cnt) {
    objc.checkOsVersionInternal('NSOrderedSet.orderedSetWithObjects:count:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_zmbtbd(
        _class_NSOrderedSet, _sel_orderedSetWithObjects_count_, objects, cnt);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// orderedSetWithOrderedSet:
  static NSOrderedSet orderedSetWithOrderedSet_(NSOrderedSet set) {
    objc.checkOsVersionInternal('NSOrderedSet.orderedSetWithOrderedSet:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSOrderedSet, _sel_orderedSetWithOrderedSet_, set.ref.pointer);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// orderedSetWithOrderedSet:range:copyItems:
  static NSOrderedSet orderedSetWithOrderedSet_range_copyItems_(
      NSOrderedSet set, NSRange range, bool flag) {
    objc.checkOsVersionInternal(
        'NSOrderedSet.orderedSetWithOrderedSet:range:copyItems:',
        iOS: (false, (5, 0, 0)),
        macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_w9bq5x(
        _class_NSOrderedSet,
        _sel_orderedSetWithOrderedSet_range_copyItems_,
        set.ref.pointer,
        range,
        flag);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// orderedSetWithSet:
  static NSOrderedSet orderedSetWithSet_(objc.ObjCObjectBase set) {
    objc.checkOsVersionInternal('NSOrderedSet.orderedSetWithSet:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSOrderedSet, _sel_orderedSetWithSet_, set.ref.pointer);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// orderedSetWithSet:copyItems:
  static NSOrderedSet orderedSetWithSet_copyItems_(
      objc.ObjCObjectBase set, bool flag) {
    objc.checkOsVersionInternal('NSOrderedSet.orderedSetWithSet:copyItems:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_17amj0z(_class_NSOrderedSet,
        _sel_orderedSetWithSet_copyItems_, set.ref.pointer, flag);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// supportsSecureCoding
  static bool getSupportsSecureCoding() {
    return _objc_msgSend_91o635(_class_NSOrderedSet, _sel_supportsSecureCoding);
  }

  /// autorelease
  NSOrderedSet autorelease() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_autorelease);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// count
  int get count {
    objc.checkOsVersionInternal('NSOrderedSet.count',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    return _objc_msgSend_xw2lbc(this.ref.pointer, _sel_count);
  }

  /// countByEnumeratingWithState:objects:count:
  int countByEnumeratingWithState_objects_count_(
      ffi.Pointer<NSFastEnumerationState> state,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> buffer,
      int len) {
    return _objc_msgSend_1b5ysjl(this.ref.pointer,
        _sel_countByEnumeratingWithState_objects_count_, state, buffer, len);
  }

  /// encodeWithCoder:
  void encodeWithCoder_(NSCoder coder) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_encodeWithCoder_, coder.ref.pointer);
  }

  /// indexOfObject:
  int indexOfObject_(objc.ObjCObjectBase object) {
    objc.checkOsVersionInternal('NSOrderedSet.indexOfObject:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    return _objc_msgSend_1vd1c5m(
        this.ref.pointer, _sel_indexOfObject_, object.ref.pointer);
  }

  /// init
  NSOrderedSet init() {
    objc.checkOsVersionInternal('NSOrderedSet.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSOrderedSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithArray:
  NSOrderedSet initWithArray_(NSArray array) {
    objc.checkOsVersionInternal('NSOrderedSet.initWithArray:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithArray_, array.ref.pointer);
    return NSOrderedSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithArray:copyItems:
  NSOrderedSet initWithArray_copyItems_(NSArray set, bool flag) {
    objc.checkOsVersionInternal('NSOrderedSet.initWithArray:copyItems:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_17amj0z(this.ref.retainAndReturnPointer(),
        _sel_initWithArray_copyItems_, set.ref.pointer, flag);
    return NSOrderedSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithArray:range:copyItems:
  NSOrderedSet initWithArray_range_copyItems_(
      NSArray set, NSRange range, bool flag) {
    objc.checkOsVersionInternal('NSOrderedSet.initWithArray:range:copyItems:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_w9bq5x(this.ref.retainAndReturnPointer(),
        _sel_initWithArray_range_copyItems_, set.ref.pointer, range, flag);
    return NSOrderedSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithCoder:
  NSOrderedSet? initWithCoder_(NSCoder coder) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithCoder_, coder.ref.pointer);
    return _ret.address == 0
        ? null
        : NSOrderedSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithObject:
  NSOrderedSet initWithObject_(objc.ObjCObjectBase object) {
    objc.checkOsVersionInternal('NSOrderedSet.initWithObject:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithObject_, object.ref.pointer);
    return NSOrderedSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithObjects:
  NSOrderedSet initWithObjects_(objc.ObjCObjectBase firstObj) {
    objc.checkOsVersionInternal('NSOrderedSet.initWithObjects:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithObjects_, firstObj.ref.pointer);
    return NSOrderedSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithObjects:count:
  NSOrderedSet initWithObjects_count_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects, int cnt) {
    objc.checkOsVersionInternal('NSOrderedSet.initWithObjects:count:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_zmbtbd(this.ref.retainAndReturnPointer(),
        _sel_initWithObjects_count_, objects, cnt);
    return NSOrderedSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithOrderedSet:
  NSOrderedSet initWithOrderedSet_(NSOrderedSet set) {
    objc.checkOsVersionInternal('NSOrderedSet.initWithOrderedSet:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithOrderedSet_, set.ref.pointer);
    return NSOrderedSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithOrderedSet:copyItems:
  NSOrderedSet initWithOrderedSet_copyItems_(NSOrderedSet set, bool flag) {
    objc.checkOsVersionInternal('NSOrderedSet.initWithOrderedSet:copyItems:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_17amj0z(this.ref.retainAndReturnPointer(),
        _sel_initWithOrderedSet_copyItems_, set.ref.pointer, flag);
    return NSOrderedSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithOrderedSet:range:copyItems:
  NSOrderedSet initWithOrderedSet_range_copyItems_(
      NSOrderedSet set, NSRange range, bool flag) {
    objc.checkOsVersionInternal(
        'NSOrderedSet.initWithOrderedSet:range:copyItems:',
        iOS: (false, (5, 0, 0)),
        macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_w9bq5x(this.ref.retainAndReturnPointer(),
        _sel_initWithOrderedSet_range_copyItems_, set.ref.pointer, range, flag);
    return NSOrderedSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithSet:
  NSOrderedSet initWithSet_(objc.ObjCObjectBase set) {
    objc.checkOsVersionInternal('NSOrderedSet.initWithSet:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_1sotr3r(
        this.ref.retainAndReturnPointer(), _sel_initWithSet_, set.ref.pointer);
    return NSOrderedSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithSet:copyItems:
  NSOrderedSet initWithSet_copyItems_(objc.ObjCObjectBase set, bool flag) {
    objc.checkOsVersionInternal('NSOrderedSet.initWithSet:copyItems:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret = _objc_msgSend_17amj0z(this.ref.retainAndReturnPointer(),
        _sel_initWithSet_copyItems_, set.ref.pointer, flag);
    return NSOrderedSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// objectAtIndex:
  objc.ObjCObjectBase objectAtIndex_(int idx) {
    objc.checkOsVersionInternal('NSOrderedSet.objectAtIndex:',
        iOS: (false, (5, 0, 0)), macOS: (false, (10, 7, 0)));
    final _ret =
        _objc_msgSend_14hpxwa(this.ref.pointer, _sel_objectAtIndex_, idx);
    return objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// retain
  NSOrderedSet retain() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_retain);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// self
  NSOrderedSet self$1() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_self);
    return NSOrderedSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// Returns a new instance of NSOrderedSet constructed with the default `new` method.
  factory NSOrderedSet() => new$();
}

/// NSOutputStream
class NSOutputStream extends NSStream {
  NSOutputStream._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSOutputStream] that points to the same underlying object as [other].
  NSOutputStream.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSOutputStream] that wraps the given raw object pointer.
  NSOutputStream.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSOutputStream].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSOutputStream);
  }

  /// outputStreamToBuffer:capacity:
  static NSOutputStream outputStreamToBuffer_capacity_(
      ffi.Pointer<ffi.Uint8> buffer, int capacity) {
    final _ret = _objc_msgSend_158ju31(_class_NSOutputStream,
        _sel_outputStreamToBuffer_capacity_, buffer, capacity);
    return NSOutputStream.castFromPointer(_ret, retain: true, release: true);
  }

  /// outputStreamToFileAtPath:append:
  static NSOutputStream outputStreamToFileAtPath_append_(
      NSString path, bool shouldAppend) {
    final _ret = _objc_msgSend_17amj0z(_class_NSOutputStream,
        _sel_outputStreamToFileAtPath_append_, path.ref.pointer, shouldAppend);
    return NSOutputStream.castFromPointer(_ret, retain: true, release: true);
  }

  /// outputStreamToMemory
  static NSOutputStream outputStreamToMemory() {
    final _ret =
        _objc_msgSend_151sglz(_class_NSOutputStream, _sel_outputStreamToMemory);
    return NSOutputStream.castFromPointer(_ret, retain: true, release: true);
  }

  /// outputStreamWithURL:append:
  static NSOutputStream? outputStreamWithURL_append_(
      NSURL url, bool shouldAppend) {
    objc.checkOsVersionInternal('NSOutputStream.outputStreamWithURL:append:',
        iOS: (false, (4, 0, 0)), macOS: (false, (10, 6, 0)));
    final _ret = _objc_msgSend_17amj0z(_class_NSOutputStream,
        _sel_outputStreamWithURL_append_, url.ref.pointer, shouldAppend);
    return _ret.address == 0
        ? null
        : NSOutputStream.castFromPointer(_ret, retain: true, release: true);
  }

  /// hasSpaceAvailable
  bool get hasSpaceAvailable {
    return _objc_msgSend_91o635(this.ref.pointer, _sel_hasSpaceAvailable);
  }

  /// initToBuffer:capacity:
  NSOutputStream initToBuffer_capacity_(
      ffi.Pointer<ffi.Uint8> buffer, int capacity) {
    final _ret = _objc_msgSend_158ju31(this.ref.retainAndReturnPointer(),
        _sel_initToBuffer_capacity_, buffer, capacity);
    return NSOutputStream.castFromPointer(_ret, retain: false, release: true);
  }

  /// initToFileAtPath:append:
  NSOutputStream? initToFileAtPath_append_(NSString path, bool shouldAppend) {
    final _ret = _objc_msgSend_17amj0z(this.ref.retainAndReturnPointer(),
        _sel_initToFileAtPath_append_, path.ref.pointer, shouldAppend);
    return _ret.address == 0
        ? null
        : NSOutputStream.castFromPointer(_ret, retain: false, release: true);
  }

  /// initToMemory
  NSOutputStream initToMemory() {
    final _ret = _objc_msgSend_151sglz(
        this.ref.retainAndReturnPointer(), _sel_initToMemory);
    return NSOutputStream.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithURL:append:
  NSOutputStream? initWithURL_append_(NSURL url, bool shouldAppend) {
    objc.checkOsVersionInternal('NSOutputStream.initWithURL:append:',
        iOS: (false, (4, 0, 0)), macOS: (false, (10, 6, 0)));
    final _ret = _objc_msgSend_17amj0z(this.ref.retainAndReturnPointer(),
        _sel_initWithURL_append_, url.ref.pointer, shouldAppend);
    return _ret.address == 0
        ? null
        : NSOutputStream.castFromPointer(_ret, retain: false, release: true);
  }

  /// write:maxLength:
  int write_maxLength_(ffi.Pointer<ffi.Uint8> buffer, int len) {
    return _objc_msgSend_11e9f5x(
        this.ref.pointer, _sel_write_maxLength_, buffer, len);
  }
}

final class NSRange extends ffi.Struct {
  @ffi.UnsignedLong()
  external int location;

  @ffi.UnsignedLong()
  external int length;
}

/// NSRunLoop
class NSRunLoop extends objc.ObjCObjectBase {
  NSRunLoop._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super(pointer, retain: retain, release: release);

  /// Constructs a [NSRunLoop] that points to the same underlying object as [other].
  NSRunLoop.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSRunLoop] that wraps the given raw object pointer.
  NSRunLoop.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSRunLoop].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSRunLoop);
  }
}

/// NSSecureCoding
interface class NSSecureCoding extends objc.ObjCProtocolBase
    implements NSCoding {
  NSSecureCoding._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super(pointer, retain: retain, release: release);

  /// Constructs a [NSSecureCoding] that points to the same underlying object as [other].
  NSSecureCoding.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSSecureCoding] that wraps the given raw object pointer.
  NSSecureCoding.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSSecureCoding].
  static bool conformsTo(objc.ObjCObjectBase obj) {
    return _objc_msgSend_e3qsqz(
        obj.ref.pointer, _sel_conformsToProtocol_, _protocol_NSSecureCoding);
  }

  /// Returns the [objc.Protocol] object for this protocol.
  static objc.Protocol get $protocol =>
      objc.Protocol.castFromPointer(_protocol_NSSecureCoding.cast());

  /// Builds an object that implements the NSSecureCoding protocol. To implement
  /// multiple protocols, use [addToBuilder] or [objc.ObjCProtocolBuilder] directly.
  ///
  /// If `$keepIsolateAlive` is true, this protocol will keep this isolate
  /// alive until it is garbage collected by both Dart and ObjC.
  static NSSecureCoding implement(
      {required void Function(NSCoder) encodeWithCoder_,
      required Dartinstancetype? Function(NSCoder) initWithCoder_,
      bool $keepIsolateAlive = true}) {
    final builder = objc.ObjCProtocolBuilder(debugName: 'NSSecureCoding');
    NSSecureCoding.encodeWithCoder_.implement(builder, encodeWithCoder_);
    NSSecureCoding.initWithCoder_.implement(builder, initWithCoder_);
    builder.addProtocol($protocol);
    return NSSecureCoding.castFrom(
        builder.build(keepIsolateAlive: $keepIsolateAlive));
  }

  /// Adds the implementation of the NSSecureCoding protocol to an existing
  /// [objc.ObjCProtocolBuilder].
  ///
  /// Note: You cannot call this method after you have called `builder.build`.
  static void addToBuilder(objc.ObjCProtocolBuilder builder,
      {required void Function(NSCoder) encodeWithCoder_,
      required Dartinstancetype? Function(NSCoder) initWithCoder_,
      bool $keepIsolateAlive = true}) {
    NSSecureCoding.encodeWithCoder_.implement(builder, encodeWithCoder_);
    NSSecureCoding.initWithCoder_.implement(builder, initWithCoder_);
    builder.addProtocol($protocol);
  }

  /// Builds an object that implements the NSSecureCoding protocol. To implement
  /// multiple protocols, use [addToBuilder] or [objc.ObjCProtocolBuilder] directly. All
  /// methods that can be implemented as listeners will be.
  ///
  /// If `$keepIsolateAlive` is true, this protocol will keep this isolate
  /// alive until it is garbage collected by both Dart and ObjC.
  static NSSecureCoding implementAsListener(
      {required void Function(NSCoder) encodeWithCoder_,
      required Dartinstancetype? Function(NSCoder) initWithCoder_,
      bool $keepIsolateAlive = true}) {
    final builder = objc.ObjCProtocolBuilder(debugName: 'NSSecureCoding');
    NSSecureCoding.encodeWithCoder_
        .implementAsListener(builder, encodeWithCoder_);
    NSSecureCoding.initWithCoder_.implement(builder, initWithCoder_);
    builder.addProtocol($protocol);
    return NSSecureCoding.castFrom(
        builder.build(keepIsolateAlive: $keepIsolateAlive));
  }

  /// Adds the implementation of the NSSecureCoding protocol to an existing
  /// [objc.ObjCProtocolBuilder]. All methods that can be implemented as listeners will
  /// be.
  ///
  /// Note: You cannot call this method after you have called `builder.build`.
  static void addToBuilderAsListener(objc.ObjCProtocolBuilder builder,
      {required void Function(NSCoder) encodeWithCoder_,
      required Dartinstancetype? Function(NSCoder) initWithCoder_,
      bool $keepIsolateAlive = true}) {
    NSSecureCoding.encodeWithCoder_
        .implementAsListener(builder, encodeWithCoder_);
    NSSecureCoding.initWithCoder_.implement(builder, initWithCoder_);
    builder.addProtocol($protocol);
  }

  /// Builds an object that implements the NSSecureCoding protocol. To implement
  /// multiple protocols, use [addToBuilder] or [objc.ObjCProtocolBuilder] directly. All
  /// methods that can be implemented as blocking listeners will be.
  ///
  /// If `$keepIsolateAlive` is true, this protocol will keep this isolate
  /// alive until it is garbage collected by both Dart and ObjC.
  static NSSecureCoding implementAsBlocking(
      {required void Function(NSCoder) encodeWithCoder_,
      required Dartinstancetype? Function(NSCoder) initWithCoder_,
      bool $keepIsolateAlive = true}) {
    final builder = objc.ObjCProtocolBuilder(debugName: 'NSSecureCoding');
    NSSecureCoding.encodeWithCoder_
        .implementAsBlocking(builder, encodeWithCoder_);
    NSSecureCoding.initWithCoder_.implement(builder, initWithCoder_);
    builder.addProtocol($protocol);
    return NSSecureCoding.castFrom(
        builder.build(keepIsolateAlive: $keepIsolateAlive));
  }

  /// Adds the implementation of the NSSecureCoding protocol to an existing
  /// [objc.ObjCProtocolBuilder]. All methods that can be implemented as blocking
  /// listeners will be.
  ///
  /// Note: You cannot call this method after you have called `builder.build`.
  static void addToBuilderAsBlocking(objc.ObjCProtocolBuilder builder,
      {required void Function(NSCoder) encodeWithCoder_,
      required Dartinstancetype? Function(NSCoder) initWithCoder_,
      bool $keepIsolateAlive = true}) {
    NSSecureCoding.encodeWithCoder_
        .implementAsBlocking(builder, encodeWithCoder_);
    NSSecureCoding.initWithCoder_.implement(builder, initWithCoder_);
    builder.addProtocol($protocol);
  }

  /// encodeWithCoder:
  static final encodeWithCoder_ =
      objc.ObjCProtocolListenableMethod<void Function(NSCoder)>(
    _protocol_NSSecureCoding,
    _sel_encodeWithCoder_,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                        ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>>(
            _ObjectiveCBindings_protocolTrampoline_18v1jvf)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSSecureCoding,
      _sel_encodeWithCoder_,
      isRequired: true,
      isInstanceMethod: true,
    ),
    (void Function(NSCoder) func) =>
        ObjCBlock_ffiVoid_ffiVoid_NSCoder.fromFunction(
            (ffi.Pointer<ffi.Void> _, NSCoder arg1) => func(arg1)),
    (void Function(NSCoder) func) => ObjCBlock_ffiVoid_ffiVoid_NSCoder.listener(
        (ffi.Pointer<ffi.Void> _, NSCoder arg1) => func(arg1)),
    (void Function(NSCoder) func) => ObjCBlock_ffiVoid_ffiVoid_NSCoder.blocking(
        (ffi.Pointer<ffi.Void> _, NSCoder arg1) => func(arg1)),
  );

  /// initWithCoder:
  static final initWithCoder_ =
      objc.ObjCProtocolMethod<Dartinstancetype? Function(NSCoder)>(
    _protocol_NSSecureCoding,
    _sel_initWithCoder_,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    instancetype Function(ffi.Pointer<objc.ObjCObject>,
                        ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>>(
            _ObjectiveCBindings_protocolTrampoline_xr62hr)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSSecureCoding,
      _sel_initWithCoder_,
      isRequired: true,
      isInstanceMethod: true,
    ),
    (Dartinstancetype? Function(NSCoder) func) =>
        ObjCBlock_instancetype_ffiVoid_NSCoder.fromFunction(
            (ffi.Pointer<ffi.Void> _, NSCoder arg1) => func(arg1)),
  );
}

/// NSSet
class NSSet extends NSObject
    implements NSCopying, NSMutableCopying, NSSecureCoding, NSFastEnumeration {
  NSSet._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSSet] that points to the same underlying object as [other].
  NSSet.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSSet] that wraps the given raw object pointer.
  NSSet.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSSet].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSSet);
  }

  /// alloc
  static NSSet alloc() {
    final _ret = _objc_msgSend_151sglz(_class_NSSet, _sel_alloc);
    return NSSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// allocWithZone:
  static NSSet allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret = _objc_msgSend_1cwp428(_class_NSSet, _sel_allocWithZone_, zone);
    return NSSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// new
  static NSSet new$() {
    final _ret = _objc_msgSend_151sglz(_class_NSSet, _sel_new);
    return NSSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// set
  static NSSet set$() {
    final _ret = _objc_msgSend_151sglz(_class_NSSet, _sel_set);
    return NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// setWithArray:
  static NSSet setWithArray_(NSArray array) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSSet, _sel_setWithArray_, array.ref.pointer);
    return NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// setWithObject:
  static NSSet setWithObject_(objc.ObjCObjectBase object) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSSet, _sel_setWithObject_, object.ref.pointer);
    return NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// setWithObjects:
  static NSSet setWithObjects_(objc.ObjCObjectBase firstObj) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSSet, _sel_setWithObjects_, firstObj.ref.pointer);
    return NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// setWithObjects:count:
  static NSSet setWithObjects_count_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects, int cnt) {
    final _ret = _objc_msgSend_zmbtbd(
        _class_NSSet, _sel_setWithObjects_count_, objects, cnt);
    return NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// setWithSet:
  static NSSet setWithSet_(NSSet set) {
    final _ret =
        _objc_msgSend_1sotr3r(_class_NSSet, _sel_setWithSet_, set.ref.pointer);
    return NSSet.castFromPointer(_ret, retain: true, release: true);
  }

  /// supportsSecureCoding
  static bool getSupportsSecureCoding() {
    return _objc_msgSend_91o635(_class_NSSet, _sel_supportsSecureCoding);
  }

  /// count
  int get count {
    return _objc_msgSend_xw2lbc(this.ref.pointer, _sel_count);
  }

  /// countByEnumeratingWithState:objects:count:
  int countByEnumeratingWithState_objects_count_(
      ffi.Pointer<NSFastEnumerationState> state,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> buffer,
      int len) {
    return _objc_msgSend_1b5ysjl(this.ref.pointer,
        _sel_countByEnumeratingWithState_objects_count_, state, buffer, len);
  }

  /// encodeWithCoder:
  void encodeWithCoder_(NSCoder coder) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_encodeWithCoder_, coder.ref.pointer);
  }

  /// init
  NSSet init() {
    objc.checkOsVersionInternal('NSSet.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithArray:
  NSSet initWithArray_(NSArray array) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithArray_, array.ref.pointer);
    return NSSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithCoder:
  NSSet? initWithCoder_(NSCoder coder) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithCoder_, coder.ref.pointer);
    return _ret.address == 0
        ? null
        : NSSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithObjects:
  NSSet initWithObjects_(objc.ObjCObjectBase firstObj) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithObjects_, firstObj.ref.pointer);
    return NSSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithObjects:count:
  NSSet initWithObjects_count_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> objects, int cnt) {
    final _ret = _objc_msgSend_zmbtbd(this.ref.retainAndReturnPointer(),
        _sel_initWithObjects_count_, objects, cnt);
    return NSSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithSet:
  NSSet initWithSet_(NSSet set) {
    final _ret = _objc_msgSend_1sotr3r(
        this.ref.retainAndReturnPointer(), _sel_initWithSet_, set.ref.pointer);
    return NSSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithSet:copyItems:
  NSSet initWithSet_copyItems_(NSSet set, bool flag) {
    final _ret = _objc_msgSend_17amj0z(this.ref.retainAndReturnPointer(),
        _sel_initWithSet_copyItems_, set.ref.pointer, flag);
    return NSSet.castFromPointer(_ret, retain: false, release: true);
  }

  /// member:
  objc.ObjCObjectBase? member_(objc.ObjCObjectBase object) {
    final _ret = _objc_msgSend_1sotr3r(
        this.ref.pointer, _sel_member_, object.ref.pointer);
    return _ret.address == 0
        ? null
        : objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// objectEnumerator
  NSEnumerator objectEnumerator() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_objectEnumerator);
    return NSEnumerator.castFromPointer(_ret, retain: true, release: true);
  }

  /// Returns a new instance of NSSet constructed with the default `new` method.
  factory NSSet() => new$();
}

enum NSSortOptions {
  NSSortConcurrent(1),
  NSSortStable(16);

  final int value;
  const NSSortOptions(this.value);

  static NSSortOptions fromValue(int value) => switch (value) {
        1 => NSSortConcurrent,
        16 => NSSortStable,
        _ => throw ArgumentError('Unknown value for NSSortOptions: $value'),
      };
}

/// NSStream
class NSStream extends NSObject {
  NSStream._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSStream] that points to the same underlying object as [other].
  NSStream.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSStream] that wraps the given raw object pointer.
  NSStream.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSStream].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSStream);
  }

  /// alloc
  static NSStream alloc() {
    final _ret = _objc_msgSend_151sglz(_class_NSStream, _sel_alloc);
    return NSStream.castFromPointer(_ret, retain: false, release: true);
  }

  /// allocWithZone:
  static NSStream allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret =
        _objc_msgSend_1cwp428(_class_NSStream, _sel_allocWithZone_, zone);
    return NSStream.castFromPointer(_ret, retain: false, release: true);
  }

  /// new
  static NSStream new$() {
    final _ret = _objc_msgSend_151sglz(_class_NSStream, _sel_new);
    return NSStream.castFromPointer(_ret, retain: false, release: true);
  }

  /// autorelease
  NSStream autorelease() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_autorelease);
    return NSStream.castFromPointer(_ret, retain: true, release: true);
  }

  /// close
  void close() {
    _objc_msgSend_1pl9qdv(this.ref.pointer, _sel_close);
  }

  /// delegate
  NSStreamDelegate? get delegate {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_delegate);
    return _ret.address == 0
        ? null
        : NSStreamDelegate.castFromPointer(_ret, retain: true, release: true);
  }

  /// init
  NSStream init() {
    objc.checkOsVersionInternal('NSStream.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSStream.castFromPointer(_ret, retain: false, release: true);
  }

  /// open
  void open() {
    _objc_msgSend_1pl9qdv(this.ref.pointer, _sel_open);
  }

  /// propertyForKey:
  objc.ObjCObjectBase? propertyForKey_(NSString key) {
    final _ret = _objc_msgSend_1sotr3r(
        this.ref.pointer, _sel_propertyForKey_, key.ref.pointer);
    return _ret.address == 0
        ? null
        : objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// removeFromRunLoop:forMode:
  void removeFromRunLoop_forMode_(NSRunLoop aRunLoop, NSString mode) {
    _objc_msgSend_pfv6jd(this.ref.pointer, _sel_removeFromRunLoop_forMode_,
        aRunLoop.ref.pointer, mode.ref.pointer);
  }

  /// retain
  NSStream retain() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_retain);
    return NSStream.castFromPointer(_ret, retain: true, release: true);
  }

  /// scheduleInRunLoop:forMode:
  void scheduleInRunLoop_forMode_(NSRunLoop aRunLoop, NSString mode) {
    _objc_msgSend_pfv6jd(this.ref.pointer, _sel_scheduleInRunLoop_forMode_,
        aRunLoop.ref.pointer, mode.ref.pointer);
  }

  /// self
  NSStream self$1() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_self);
    return NSStream.castFromPointer(_ret, retain: true, release: true);
  }

  /// setDelegate:
  set delegate(NSStreamDelegate? value) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_setDelegate_, value?.ref.pointer ?? ffi.nullptr);
  }

  /// setProperty:forKey:
  bool setProperty_forKey_(objc.ObjCObjectBase? property, NSString key) {
    return _objc_msgSend_1lsax7n(this.ref.pointer, _sel_setProperty_forKey_,
        property?.ref.pointer ?? ffi.nullptr, key.ref.pointer);
  }

  /// streamError
  NSError? get streamError {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_streamError);
    return _ret.address == 0
        ? null
        : NSError.castFromPointer(_ret, retain: true, release: true);
  }

  /// streamStatus
  NSStreamStatus get streamStatus {
    final _ret = _objc_msgSend_1efxbd8(this.ref.pointer, _sel_streamStatus);
    return NSStreamStatus.fromValue(_ret);
  }

  /// Returns a new instance of NSStream constructed with the default `new` method.
  factory NSStream() => new$();
}

/// NSStreamDelegate
interface class NSStreamDelegate extends objc.ObjCProtocolBase
    implements NSObjectProtocol {
  NSStreamDelegate._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super(pointer, retain: retain, release: release);

  /// Constructs a [NSStreamDelegate] that points to the same underlying object as [other].
  NSStreamDelegate.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSStreamDelegate] that wraps the given raw object pointer.
  NSStreamDelegate.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSStreamDelegate].
  static bool conformsTo(objc.ObjCObjectBase obj) {
    return _objc_msgSend_e3qsqz(
        obj.ref.pointer, _sel_conformsToProtocol_, _protocol_NSStreamDelegate);
  }

  /// Returns the [objc.Protocol] object for this protocol.
  static objc.Protocol get $protocol =>
      objc.Protocol.castFromPointer(_protocol_NSStreamDelegate.cast());

  /// Builds an object that implements the NSStreamDelegate protocol. To implement
  /// multiple protocols, use [addToBuilder] or [objc.ObjCProtocolBuilder] directly.
  ///
  /// If `$keepIsolateAlive` is true, this protocol will keep this isolate
  /// alive until it is garbage collected by both Dart and ObjC.
  static NSStreamDelegate implement(
      {void Function(NSStream, NSStreamEvent)? stream_handleEvent_,
      bool $keepIsolateAlive = true}) {
    final builder = objc.ObjCProtocolBuilder(debugName: 'NSStreamDelegate');
    NSStreamDelegate.stream_handleEvent_
        .implement(builder, stream_handleEvent_);
    builder.addProtocol($protocol);
    return NSStreamDelegate.castFrom(
        builder.build(keepIsolateAlive: $keepIsolateAlive));
  }

  /// Adds the implementation of the NSStreamDelegate protocol to an existing
  /// [objc.ObjCProtocolBuilder].
  ///
  /// Note: You cannot call this method after you have called `builder.build`.
  static void addToBuilder(objc.ObjCProtocolBuilder builder,
      {void Function(NSStream, NSStreamEvent)? stream_handleEvent_,
      bool $keepIsolateAlive = true}) {
    NSStreamDelegate.stream_handleEvent_
        .implement(builder, stream_handleEvent_);
    builder.addProtocol($protocol);
  }

  /// Builds an object that implements the NSStreamDelegate protocol. To implement
  /// multiple protocols, use [addToBuilder] or [objc.ObjCProtocolBuilder] directly. All
  /// methods that can be implemented as listeners will be.
  ///
  /// If `$keepIsolateAlive` is true, this protocol will keep this isolate
  /// alive until it is garbage collected by both Dart and ObjC.
  static NSStreamDelegate implementAsListener(
      {void Function(NSStream, NSStreamEvent)? stream_handleEvent_,
      bool $keepIsolateAlive = true}) {
    final builder = objc.ObjCProtocolBuilder(debugName: 'NSStreamDelegate');
    NSStreamDelegate.stream_handleEvent_
        .implementAsListener(builder, stream_handleEvent_);
    builder.addProtocol($protocol);
    return NSStreamDelegate.castFrom(
        builder.build(keepIsolateAlive: $keepIsolateAlive));
  }

  /// Adds the implementation of the NSStreamDelegate protocol to an existing
  /// [objc.ObjCProtocolBuilder]. All methods that can be implemented as listeners will
  /// be.
  ///
  /// Note: You cannot call this method after you have called `builder.build`.
  static void addToBuilderAsListener(objc.ObjCProtocolBuilder builder,
      {void Function(NSStream, NSStreamEvent)? stream_handleEvent_,
      bool $keepIsolateAlive = true}) {
    NSStreamDelegate.stream_handleEvent_
        .implementAsListener(builder, stream_handleEvent_);
    builder.addProtocol($protocol);
  }

  /// Builds an object that implements the NSStreamDelegate protocol. To implement
  /// multiple protocols, use [addToBuilder] or [objc.ObjCProtocolBuilder] directly. All
  /// methods that can be implemented as blocking listeners will be.
  ///
  /// If `$keepIsolateAlive` is true, this protocol will keep this isolate
  /// alive until it is garbage collected by both Dart and ObjC.
  static NSStreamDelegate implementAsBlocking(
      {void Function(NSStream, NSStreamEvent)? stream_handleEvent_,
      bool $keepIsolateAlive = true}) {
    final builder = objc.ObjCProtocolBuilder(debugName: 'NSStreamDelegate');
    NSStreamDelegate.stream_handleEvent_
        .implementAsBlocking(builder, stream_handleEvent_);
    builder.addProtocol($protocol);
    return NSStreamDelegate.castFrom(
        builder.build(keepIsolateAlive: $keepIsolateAlive));
  }

  /// Adds the implementation of the NSStreamDelegate protocol to an existing
  /// [objc.ObjCProtocolBuilder]. All methods that can be implemented as blocking
  /// listeners will be.
  ///
  /// Note: You cannot call this method after you have called `builder.build`.
  static void addToBuilderAsBlocking(objc.ObjCProtocolBuilder builder,
      {void Function(NSStream, NSStreamEvent)? stream_handleEvent_,
      bool $keepIsolateAlive = true}) {
    NSStreamDelegate.stream_handleEvent_
        .implementAsBlocking(builder, stream_handleEvent_);
    builder.addProtocol($protocol);
  }

  /// stream:handleEvent:
  static final stream_handleEvent_ =
      objc.ObjCProtocolListenableMethod<void Function(NSStream, NSStreamEvent)>(
    _protocol_NSStreamDelegate,
    _sel_stream_handleEvent_,
    ffi.Native.addressOf<
                ffi.NativeFunction<
                    ffi.Void Function(
                        ffi.Pointer<objc.ObjCObject>,
                        ffi.Pointer<ffi.Void>,
                        ffi.Pointer<objc.ObjCObject>,
                        ffi.UnsignedLong)>>(
            _ObjectiveCBindings_protocolTrampoline_hoampi)
        .cast(),
    objc.getProtocolMethodSignature(
      _protocol_NSStreamDelegate,
      _sel_stream_handleEvent_,
      isRequired: false,
      isInstanceMethod: true,
    ),
    (void Function(NSStream, NSStreamEvent) func) =>
        ObjCBlock_ffiVoid_ffiVoid_NSStream_NSStreamEvent.fromFunction(
            (ffi.Pointer<ffi.Void> _, NSStream arg1, NSStreamEvent arg2) =>
                func(arg1, arg2)),
    (void Function(NSStream, NSStreamEvent) func) =>
        ObjCBlock_ffiVoid_ffiVoid_NSStream_NSStreamEvent.listener(
            (ffi.Pointer<ffi.Void> _, NSStream arg1, NSStreamEvent arg2) =>
                func(arg1, arg2)),
    (void Function(NSStream, NSStreamEvent) func) =>
        ObjCBlock_ffiVoid_ffiVoid_NSStream_NSStreamEvent.blocking(
            (ffi.Pointer<ffi.Void> _, NSStream arg1, NSStreamEvent arg2) =>
                func(arg1, arg2)),
  );
}

enum NSStreamEvent {
  NSStreamEventNone(0),
  NSStreamEventOpenCompleted(1),
  NSStreamEventHasBytesAvailable(2),
  NSStreamEventHasSpaceAvailable(4),
  NSStreamEventErrorOccurred(8),
  NSStreamEventEndEncountered(16);

  final int value;
  const NSStreamEvent(this.value);

  static NSStreamEvent fromValue(int value) => switch (value) {
        0 => NSStreamEventNone,
        1 => NSStreamEventOpenCompleted,
        2 => NSStreamEventHasBytesAvailable,
        4 => NSStreamEventHasSpaceAvailable,
        8 => NSStreamEventErrorOccurred,
        16 => NSStreamEventEndEncountered,
        _ => throw ArgumentError('Unknown value for NSStreamEvent: $value'),
      };
}

enum NSStreamStatus {
  NSStreamStatusNotOpen(0),
  NSStreamStatusOpening(1),
  NSStreamStatusOpen(2),
  NSStreamStatusReading(3),
  NSStreamStatusWriting(4),
  NSStreamStatusAtEnd(5),
  NSStreamStatusClosed(6),
  NSStreamStatusError(7);

  final int value;
  const NSStreamStatus(this.value);

  static NSStreamStatus fromValue(int value) => switch (value) {
        0 => NSStreamStatusNotOpen,
        1 => NSStreamStatusOpening,
        2 => NSStreamStatusOpen,
        3 => NSStreamStatusReading,
        4 => NSStreamStatusWriting,
        5 => NSStreamStatusAtEnd,
        6 => NSStreamStatusClosed,
        7 => NSStreamStatusError,
        _ => throw ArgumentError('Unknown value for NSStreamStatus: $value'),
      };
}

/// NSString
class NSString extends NSObject
    implements NSCopying, NSMutableCopying, NSSecureCoding {
  factory NSString(String str) {
    final cstr = str.toNativeUtf16();
    final nsstr = stringWithCharacters_length_(cstr.cast(), str.length);
    pkg_ffi.calloc.free(cstr);
    return nsstr;
  }

  NSString._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSString] that points to the same underlying object as [other].
  NSString.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSString] that wraps the given raw object pointer.
  NSString.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSString].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSString);
  }

  /// alloc
  static NSString alloc() {
    final _ret = _objc_msgSend_151sglz(_class_NSString, _sel_alloc);
    return NSString.castFromPointer(_ret, retain: false, release: true);
  }

  /// allocWithZone:
  static NSString allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret =
        _objc_msgSend_1cwp428(_class_NSString, _sel_allocWithZone_, zone);
    return NSString.castFromPointer(_ret, retain: false, release: true);
  }

  /// localizedStringWithFormat:
  static NSString localizedStringWithFormat_(NSString format) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSString, _sel_localizedStringWithFormat_, format.ref.pointer);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// localizedStringWithValidatedFormat:validFormatSpecifiers:error:
  static NSString?
      localizedStringWithValidatedFormat_validFormatSpecifiers_error_(
          NSString format,
          NSString validFormatSpecifiers,
          ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    objc.checkOsVersionInternal(
        'NSString.localizedStringWithValidatedFormat:validFormatSpecifiers:error:',
        iOS: (false, (11, 0, 0)),
        macOS: (false, (10, 13, 0)));
    final _ret = _objc_msgSend_1pnyuds(
        _class_NSString,
        _sel_localizedStringWithValidatedFormat_validFormatSpecifiers_error_,
        format.ref.pointer,
        validFormatSpecifiers.ref.pointer,
        error);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// new
  static NSString new$() {
    final _ret = _objc_msgSend_151sglz(_class_NSString, _sel_new);
    return NSString.castFromPointer(_ret, retain: false, release: true);
  }

  /// objectWithItemProviderData:typeIdentifier:error:
  static NSString? objectWithItemProviderData_typeIdentifier_error_(
      NSData data,
      NSString typeIdentifier,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> outError) {
    objc.checkOsVersionInternal(
        'NSString.objectWithItemProviderData:typeIdentifier:error:',
        iOS: (false, (11, 0, 0)),
        macOS: (false, (10, 13, 0)));
    final _ret = _objc_msgSend_1pnyuds(
        _class_NSString,
        _sel_objectWithItemProviderData_typeIdentifier_error_,
        data.ref.pointer,
        typeIdentifier.ref.pointer,
        outError);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// string
  static NSString string() {
    final _ret = _objc_msgSend_151sglz(_class_NSString, _sel_string);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringWithCString:encoding:
  static NSString? stringWithCString_encoding_(
      ffi.Pointer<ffi.Char> cString, int enc) {
    final _ret = _objc_msgSend_erqryg(
        _class_NSString, _sel_stringWithCString_encoding_, cString, enc);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringWithCharacters:length:
  static NSString stringWithCharacters_length_(
      ffi.Pointer<ffi.UnsignedShort> characters, int length) {
    final _ret = _objc_msgSend_9x4k8x(
        _class_NSString, _sel_stringWithCharacters_length_, characters, length);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringWithContentsOfFile:encoding:error:
  static NSString? stringWithContentsOfFile_encoding_error_(
      NSString path, int enc, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_1nomli1(
        _class_NSString,
        _sel_stringWithContentsOfFile_encoding_error_,
        path.ref.pointer,
        enc,
        error);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringWithContentsOfFile:usedEncoding:error:
  static NSString? stringWithContentsOfFile_usedEncoding_error_(
      NSString path,
      ffi.Pointer<ffi.UnsignedLong> enc,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_1alewu7(
        _class_NSString,
        _sel_stringWithContentsOfFile_usedEncoding_error_,
        path.ref.pointer,
        enc,
        error);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringWithContentsOfURL:encoding:error:
  static NSString? stringWithContentsOfURL_encoding_error_(
      NSURL url, int enc, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_1nomli1(
        _class_NSString,
        _sel_stringWithContentsOfURL_encoding_error_,
        url.ref.pointer,
        enc,
        error);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringWithContentsOfURL:usedEncoding:error:
  static NSString? stringWithContentsOfURL_usedEncoding_error_(
      NSURL url,
      ffi.Pointer<ffi.UnsignedLong> enc,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_1alewu7(
        _class_NSString,
        _sel_stringWithContentsOfURL_usedEncoding_error_,
        url.ref.pointer,
        enc,
        error);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringWithFormat:
  static NSString stringWithFormat_(NSString format) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSString, _sel_stringWithFormat_, format.ref.pointer);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringWithString:
  static NSString stringWithString_(NSString string) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSString, _sel_stringWithString_, string.ref.pointer);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringWithUTF8String:
  static NSString? stringWithUTF8String_(
      ffi.Pointer<ffi.Char> nullTerminatedCString) {
    final _ret = _objc_msgSend_56zxyn(
        _class_NSString, _sel_stringWithUTF8String_, nullTerminatedCString);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringWithValidatedFormat:validFormatSpecifiers:error:
  static NSString? stringWithValidatedFormat_validFormatSpecifiers_error_(
      NSString format,
      NSString validFormatSpecifiers,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    objc.checkOsVersionInternal(
        'NSString.stringWithValidatedFormat:validFormatSpecifiers:error:',
        iOS: (false, (11, 0, 0)),
        macOS: (false, (10, 13, 0)));
    final _ret = _objc_msgSend_1pnyuds(
        _class_NSString,
        _sel_stringWithValidatedFormat_validFormatSpecifiers_error_,
        format.ref.pointer,
        validFormatSpecifiers.ref.pointer,
        error);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// supportsSecureCoding
  static bool getSupportsSecureCoding() {
    return _objc_msgSend_91o635(_class_NSString, _sel_supportsSecureCoding);
  }

  /// autorelease
  NSString autorelease() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_autorelease);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// characterAtIndex:
  int characterAtIndex_(int index) {
    return _objc_msgSend_1deg8x(
        this.ref.pointer, _sel_characterAtIndex_, index);
  }

  /// encodeWithCoder:
  void encodeWithCoder_(NSCoder coder) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_encodeWithCoder_, coder.ref.pointer);
  }

  /// init
  NSString init() {
    objc.checkOsVersionInternal('NSString.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithBytes:length:encoding:
  NSString? initWithBytes_length_encoding_(
      ffi.Pointer<ffi.Void> bytes, int len, int encoding) {
    final _ret = _objc_msgSend_9b3h4v(this.ref.retainAndReturnPointer(),
        _sel_initWithBytes_length_encoding_, bytes, len, encoding);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithBytesNoCopy:length:encoding:freeWhenDone:
  NSString? initWithBytesNoCopy_length_encoding_freeWhenDone_(
      ffi.Pointer<ffi.Void> bytes, int len, int encoding, bool freeBuffer) {
    final _ret = _objc_msgSend_k4j8m3(
        this.ref.retainAndReturnPointer(),
        _sel_initWithBytesNoCopy_length_encoding_freeWhenDone_,
        bytes,
        len,
        encoding,
        freeBuffer);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithCString:encoding:
  NSString? initWithCString_encoding_(
      ffi.Pointer<ffi.Char> nullTerminatedCString, int encoding) {
    final _ret = _objc_msgSend_erqryg(this.ref.retainAndReturnPointer(),
        _sel_initWithCString_encoding_, nullTerminatedCString, encoding);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithCharacters:length:
  NSString initWithCharacters_length_(
      ffi.Pointer<ffi.UnsignedShort> characters, int length) {
    final _ret = _objc_msgSend_9x4k8x(this.ref.retainAndReturnPointer(),
        _sel_initWithCharacters_length_, characters, length);
    return NSString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithCharactersNoCopy:length:freeWhenDone:
  NSString initWithCharactersNoCopy_length_freeWhenDone_(
      ffi.Pointer<ffi.UnsignedShort> characters, int length, bool freeBuffer) {
    final _ret = _objc_msgSend_lh0jh5(
        this.ref.retainAndReturnPointer(),
        _sel_initWithCharactersNoCopy_length_freeWhenDone_,
        characters,
        length,
        freeBuffer);
    return NSString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithCoder:
  NSString? initWithCoder_(NSCoder coder) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithCoder_, coder.ref.pointer);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithContentsOfFile:encoding:error:
  NSString? initWithContentsOfFile_encoding_error_(
      NSString path, int enc, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_1nomli1(
        this.ref.retainAndReturnPointer(),
        _sel_initWithContentsOfFile_encoding_error_,
        path.ref.pointer,
        enc,
        error);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithContentsOfFile:usedEncoding:error:
  NSString? initWithContentsOfFile_usedEncoding_error_(
      NSString path,
      ffi.Pointer<ffi.UnsignedLong> enc,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_1alewu7(
        this.ref.retainAndReturnPointer(),
        _sel_initWithContentsOfFile_usedEncoding_error_,
        path.ref.pointer,
        enc,
        error);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithContentsOfURL:encoding:error:
  NSString? initWithContentsOfURL_encoding_error_(
      NSURL url, int enc, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_1nomli1(
        this.ref.retainAndReturnPointer(),
        _sel_initWithContentsOfURL_encoding_error_,
        url.ref.pointer,
        enc,
        error);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithContentsOfURL:usedEncoding:error:
  NSString? initWithContentsOfURL_usedEncoding_error_(
      NSURL url,
      ffi.Pointer<ffi.UnsignedLong> enc,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    final _ret = _objc_msgSend_1alewu7(
        this.ref.retainAndReturnPointer(),
        _sel_initWithContentsOfURL_usedEncoding_error_,
        url.ref.pointer,
        enc,
        error);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithData:encoding:
  NSString? initWithData_encoding_(NSData data, int encoding) {
    final _ret = _objc_msgSend_1k4kd9s(this.ref.retainAndReturnPointer(),
        _sel_initWithData_encoding_, data.ref.pointer, encoding);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithFormat:
  NSString initWithFormat_(NSString format) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithFormat_, format.ref.pointer);
    return NSString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithFormat:locale:
  NSString initWithFormat_locale_(
      NSString format, objc.ObjCObjectBase? locale) {
    final _ret = _objc_msgSend_15qeuct(
        this.ref.retainAndReturnPointer(),
        _sel_initWithFormat_locale_,
        format.ref.pointer,
        locale?.ref.pointer ?? ffi.nullptr);
    return NSString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithString:
  NSString initWithString_(NSString aString) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithString_, aString.ref.pointer);
    return NSString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithUTF8String:
  NSString? initWithUTF8String_(ffi.Pointer<ffi.Char> nullTerminatedCString) {
    final _ret = _objc_msgSend_56zxyn(this.ref.retainAndReturnPointer(),
        _sel_initWithUTF8String_, nullTerminatedCString);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithValidatedFormat:validFormatSpecifiers:error:
  ///
  /// iOS: introduced 16.0.0
  /// macOS: introduced 13.0.0
  NSString? initWithValidatedFormat_validFormatSpecifiers_error_(
      NSString format,
      NSString validFormatSpecifiers,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    objc.checkOsVersionInternal(
        'NSString.initWithValidatedFormat:validFormatSpecifiers:error:',
        iOS: (false, (16, 0, 0)),
        macOS: (false, (13, 0, 0)));
    final _ret = _objc_msgSend_1pnyuds(
        this.ref.retainAndReturnPointer(),
        _sel_initWithValidatedFormat_validFormatSpecifiers_error_,
        format.ref.pointer,
        validFormatSpecifiers.ref.pointer,
        error);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithValidatedFormat:validFormatSpecifiers:locale:error:
  ///
  /// iOS: introduced 16.0.0
  /// macOS: introduced 13.0.0
  NSString? initWithValidatedFormat_validFormatSpecifiers_locale_error_(
      NSString format,
      NSString validFormatSpecifiers,
      objc.ObjCObjectBase? locale,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    objc.checkOsVersionInternal(
        'NSString.initWithValidatedFormat:validFormatSpecifiers:locale:error:',
        iOS: (false, (16, 0, 0)),
        macOS: (false, (13, 0, 0)));
    final _ret = _objc_msgSend_1k0ezzm(
        this.ref.retainAndReturnPointer(),
        _sel_initWithValidatedFormat_validFormatSpecifiers_locale_error_,
        format.ref.pointer,
        validFormatSpecifiers.ref.pointer,
        locale?.ref.pointer ?? ffi.nullptr,
        error);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: false, release: true);
  }

  /// length
  int get length {
    return _objc_msgSend_xw2lbc(this.ref.pointer, _sel_length);
  }

  /// retain
  NSString retain() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_retain);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// self
  NSString self$1() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_self);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }
}

enum NSStringCompareOptions {
  NSCaseInsensitiveSearch(1),
  NSLiteralSearch(2),
  NSBackwardsSearch(4),
  NSAnchoredSearch(8),
  NSNumericSearch(64),
  NSDiacriticInsensitiveSearch(128),
  NSWidthInsensitiveSearch(256),
  NSForcedOrderingSearch(512),
  NSRegularExpressionSearch(1024);

  final int value;
  const NSStringCompareOptions(this.value);

  static NSStringCompareOptions fromValue(int value) => switch (value) {
        1 => NSCaseInsensitiveSearch,
        2 => NSLiteralSearch,
        4 => NSBackwardsSearch,
        8 => NSAnchoredSearch,
        64 => NSNumericSearch,
        128 => NSDiacriticInsensitiveSearch,
        256 => NSWidthInsensitiveSearch,
        512 => NSForcedOrderingSearch,
        1024 => NSRegularExpressionSearch,
        _ => throw ArgumentError(
            'Unknown value for NSStringCompareOptions: $value'),
      };
}

enum NSStringEncodingConversionOptions {
  NSStringEncodingConversionAllowLossy(1),
  NSStringEncodingConversionExternalRepresentation(2);

  final int value;
  const NSStringEncodingConversionOptions(this.value);

  static NSStringEncodingConversionOptions fromValue(int value) =>
      switch (value) {
        1 => NSStringEncodingConversionAllowLossy,
        2 => NSStringEncodingConversionExternalRepresentation,
        _ => throw ArgumentError(
            'Unknown value for NSStringEncodingConversionOptions: $value'),
      };
}

enum NSStringEnumerationOptions {
  NSStringEnumerationByLines(0),
  NSStringEnumerationByParagraphs(1),
  NSStringEnumerationByComposedCharacterSequences(2),
  NSStringEnumerationByWords(3),
  NSStringEnumerationBySentences(4),
  NSStringEnumerationByCaretPositions(5),
  NSStringEnumerationByDeletionClusters(6),
  NSStringEnumerationReverse(256),
  NSStringEnumerationSubstringNotRequired(512),
  NSStringEnumerationLocalized(1024);

  final int value;
  const NSStringEnumerationOptions(this.value);

  static NSStringEnumerationOptions fromValue(int value) => switch (value) {
        0 => NSStringEnumerationByLines,
        1 => NSStringEnumerationByParagraphs,
        2 => NSStringEnumerationByComposedCharacterSequences,
        3 => NSStringEnumerationByWords,
        4 => NSStringEnumerationBySentences,
        5 => NSStringEnumerationByCaretPositions,
        6 => NSStringEnumerationByDeletionClusters,
        256 => NSStringEnumerationReverse,
        512 => NSStringEnumerationSubstringNotRequired,
        1024 => NSStringEnumerationLocalized,
        _ => throw ArgumentError(
            'Unknown value for NSStringEnumerationOptions: $value'),
      };
}

/// NSStringExtensionMethods
extension NSStringExtensionMethods on NSString {
  /// availableStringEncodings
  static ffi.Pointer<ffi.UnsignedLong> getAvailableStringEncodings() {
    return _objc_msgSend_1h2q612(
        _class_NSString, _sel_availableStringEncodings);
  }

  /// defaultCStringEncoding
  static int getDefaultCStringEncoding() {
    return _objc_msgSend_xw2lbc(_class_NSString, _sel_defaultCStringEncoding);
  }

  /// localizedNameOfStringEncoding:
  static NSString localizedNameOfStringEncoding_(int encoding) {
    final _ret = _objc_msgSend_14hpxwa(
        _class_NSString, _sel_localizedNameOfStringEncoding_, encoding);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// UTF8String
  ffi.Pointer<ffi.Char> get UTF8String {
    return _objc_msgSend_1fuqfwb(this.ref.pointer, _sel_UTF8String);
  }

  /// boolValue
  bool get boolValue {
    objc.checkOsVersionInternal('NSString.boolValue',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 5, 0)));
    return _objc_msgSend_91o635(this.ref.pointer, _sel_boolValue);
  }

  /// cStringUsingEncoding:
  ffi.Pointer<ffi.Char> cStringUsingEncoding_(int encoding) {
    return _objc_msgSend_1jtxufi(
        this.ref.pointer, _sel_cStringUsingEncoding_, encoding);
  }

  /// canBeConvertedToEncoding:
  bool canBeConvertedToEncoding_(int encoding) {
    return _objc_msgSend_6peh6o(
        this.ref.pointer, _sel_canBeConvertedToEncoding_, encoding);
  }

  /// capitalizedString
  NSString get capitalizedString {
    final _ret =
        _objc_msgSend_151sglz(this.ref.pointer, _sel_capitalizedString);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// capitalizedStringWithLocale:
  NSString capitalizedStringWithLocale_(NSLocale? locale) {
    objc.checkOsVersionInternal('NSString.capitalizedStringWithLocale:',
        iOS: (false, (6, 0, 0)), macOS: (false, (10, 8, 0)));
    final _ret = _objc_msgSend_1sotr3r(this.ref.pointer,
        _sel_capitalizedStringWithLocale_, locale?.ref.pointer ?? ffi.nullptr);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// caseInsensitiveCompare:
  NSComparisonResult caseInsensitiveCompare_(NSString string) {
    final _ret = _objc_msgSend_1ym6zyw(
        this.ref.pointer, _sel_caseInsensitiveCompare_, string.ref.pointer);
    return NSComparisonResult.fromValue(_ret);
  }

  /// commonPrefixWithString:options:
  NSString commonPrefixWithString_options_(
      NSString str, NSStringCompareOptions mask) {
    final _ret = _objc_msgSend_diypgk(this.ref.pointer,
        _sel_commonPrefixWithString_options_, str.ref.pointer, mask.value);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// compare:
  NSComparisonResult compare_(NSString string) {
    final _ret = _objc_msgSend_1ym6zyw(
        this.ref.pointer, _sel_compare_, string.ref.pointer);
    return NSComparisonResult.fromValue(_ret);
  }

  /// compare:options:
  NSComparisonResult compare_options_(
      NSString string, NSStringCompareOptions mask) {
    final _ret = _objc_msgSend_pg1fnv(this.ref.pointer, _sel_compare_options_,
        string.ref.pointer, mask.value);
    return NSComparisonResult.fromValue(_ret);
  }

  /// compare:options:range:
  NSComparisonResult compare_options_range_(NSString string,
      NSStringCompareOptions mask, NSRange rangeOfReceiverToCompare) {
    final _ret = _objc_msgSend_xrqic1(
        this.ref.pointer,
        _sel_compare_options_range_,
        string.ref.pointer,
        mask.value,
        rangeOfReceiverToCompare);
    return NSComparisonResult.fromValue(_ret);
  }

  /// compare:options:range:locale:
  NSComparisonResult compare_options_range_locale_(
      NSString string,
      NSStringCompareOptions mask,
      NSRange rangeOfReceiverToCompare,
      objc.ObjCObjectBase? locale) {
    final _ret = _objc_msgSend_1895u4n(
        this.ref.pointer,
        _sel_compare_options_range_locale_,
        string.ref.pointer,
        mask.value,
        rangeOfReceiverToCompare,
        locale?.ref.pointer ?? ffi.nullptr);
    return NSComparisonResult.fromValue(_ret);
  }

  /// componentsSeparatedByCharactersInSet:
  NSArray componentsSeparatedByCharactersInSet_(NSCharacterSet separator) {
    objc.checkOsVersionInternal(
        'NSString.componentsSeparatedByCharactersInSet:',
        iOS: (false, (2, 0, 0)),
        macOS: (false, (10, 5, 0)));
    final _ret = _objc_msgSend_1sotr3r(this.ref.pointer,
        _sel_componentsSeparatedByCharactersInSet_, separator.ref.pointer);
    return NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// componentsSeparatedByString:
  NSArray componentsSeparatedByString_(NSString separator) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.pointer,
        _sel_componentsSeparatedByString_, separator.ref.pointer);
    return NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// containsString:
  bool containsString_(NSString str) {
    objc.checkOsVersionInternal('NSString.containsString:',
        iOS: (false, (8, 0, 0)), macOS: (false, (10, 10, 0)));
    return _objc_msgSend_19nvye5(
        this.ref.pointer, _sel_containsString_, str.ref.pointer);
  }

  /// dataUsingEncoding:
  NSData? dataUsingEncoding_(int encoding) {
    final _ret = _objc_msgSend_14hpxwa(
        this.ref.pointer, _sel_dataUsingEncoding_, encoding);
    return _ret.address == 0
        ? null
        : NSData.castFromPointer(_ret, retain: true, release: true);
  }

  /// dataUsingEncoding:allowLossyConversion:
  NSData? dataUsingEncoding_allowLossyConversion_(int encoding, bool lossy) {
    final _ret = _objc_msgSend_hiwitm(this.ref.pointer,
        _sel_dataUsingEncoding_allowLossyConversion_, encoding, lossy);
    return _ret.address == 0
        ? null
        : NSData.castFromPointer(_ret, retain: true, release: true);
  }

  /// decomposedStringWithCanonicalMapping
  NSString get decomposedStringWithCanonicalMapping {
    final _ret = _objc_msgSend_151sglz(
        this.ref.pointer, _sel_decomposedStringWithCanonicalMapping);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// decomposedStringWithCompatibilityMapping
  NSString get decomposedStringWithCompatibilityMapping {
    final _ret = _objc_msgSend_151sglz(
        this.ref.pointer, _sel_decomposedStringWithCompatibilityMapping);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// description
  NSString get description {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_description);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// doubleValue
  double get doubleValue {
    return objc.useMsgSendVariants
        ? _objc_msgSend_1ukqyt8Fpret(this.ref.pointer, _sel_doubleValue)
        : _objc_msgSend_1ukqyt8(this.ref.pointer, _sel_doubleValue);
  }

  /// fastestEncoding
  int get fastestEncoding {
    return _objc_msgSend_xw2lbc(this.ref.pointer, _sel_fastestEncoding);
  }

  /// floatValue
  double get floatValue {
    return objc.useMsgSendVariants
        ? _objc_msgSend_2cgrxlFpret(this.ref.pointer, _sel_floatValue)
        : _objc_msgSend_2cgrxl(this.ref.pointer, _sel_floatValue);
  }

  /// getBytes:maxLength:usedLength:encoding:options:range:remainingRange:
  bool getBytes_maxLength_usedLength_encoding_options_range_remainingRange_(
      ffi.Pointer<ffi.Void> buffer,
      int maxBufferCount,
      ffi.Pointer<ffi.UnsignedLong> usedBufferCount,
      int encoding,
      NSStringEncodingConversionOptions options,
      NSRange range,
      ffi.Pointer<NSRange> leftover) {
    return _objc_msgSend_i30zh3(
        this.ref.pointer,
        _sel_getBytes_maxLength_usedLength_encoding_options_range_remainingRange_,
        buffer,
        maxBufferCount,
        usedBufferCount,
        encoding,
        options.value,
        range,
        leftover);
  }

  /// getCString:maxLength:encoding:
  bool getCString_maxLength_encoding_(
      ffi.Pointer<ffi.Char> buffer, int maxBufferCount, int encoding) {
    return _objc_msgSend_1lv8yz3(this.ref.pointer,
        _sel_getCString_maxLength_encoding_, buffer, maxBufferCount, encoding);
  }

  /// getCharacters:range:
  void getCharacters_range_(
      ffi.Pointer<ffi.UnsignedShort> buffer, NSRange range) {
    _objc_msgSend_898fog(
        this.ref.pointer, _sel_getCharacters_range_, buffer, range);
  }

  /// getLineStart:end:contentsEnd:forRange:
  void getLineStart_end_contentsEnd_forRange_(
      ffi.Pointer<ffi.UnsignedLong> startPtr,
      ffi.Pointer<ffi.UnsignedLong> lineEndPtr,
      ffi.Pointer<ffi.UnsignedLong> contentsEndPtr,
      NSRange range) {
    _objc_msgSend_ourvf2(
        this.ref.pointer,
        _sel_getLineStart_end_contentsEnd_forRange_,
        startPtr,
        lineEndPtr,
        contentsEndPtr,
        range);
  }

  /// getParagraphStart:end:contentsEnd:forRange:
  void getParagraphStart_end_contentsEnd_forRange_(
      ffi.Pointer<ffi.UnsignedLong> startPtr,
      ffi.Pointer<ffi.UnsignedLong> parEndPtr,
      ffi.Pointer<ffi.UnsignedLong> contentsEndPtr,
      NSRange range) {
    _objc_msgSend_ourvf2(
        this.ref.pointer,
        _sel_getParagraphStart_end_contentsEnd_forRange_,
        startPtr,
        parEndPtr,
        contentsEndPtr,
        range);
  }

  /// hasPrefix:
  bool hasPrefix_(NSString str) {
    return _objc_msgSend_19nvye5(
        this.ref.pointer, _sel_hasPrefix_, str.ref.pointer);
  }

  /// hasSuffix:
  bool hasSuffix_(NSString str) {
    return _objc_msgSend_19nvye5(
        this.ref.pointer, _sel_hasSuffix_, str.ref.pointer);
  }

  /// hash
  int get hash {
    return _objc_msgSend_xw2lbc(this.ref.pointer, _sel_hash);
  }

  /// intValue
  int get intValue {
    return _objc_msgSend_13yqbb6(this.ref.pointer, _sel_intValue);
  }

  /// integerValue
  int get integerValue {
    objc.checkOsVersionInternal('NSString.integerValue',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 5, 0)));
    return _objc_msgSend_1hz7y9r(this.ref.pointer, _sel_integerValue);
  }

  /// isEqualToString:
  bool isEqualToString_(NSString aString) {
    return _objc_msgSend_19nvye5(
        this.ref.pointer, _sel_isEqualToString_, aString.ref.pointer);
  }

  /// lengthOfBytesUsingEncoding:
  int lengthOfBytesUsingEncoding_(int enc) {
    return _objc_msgSend_12py2ux(
        this.ref.pointer, _sel_lengthOfBytesUsingEncoding_, enc);
  }

  /// lineRangeForRange:
  NSRange lineRangeForRange_(NSRange range) {
    final _ptr = pkg_ffi.calloc<NSRange>();
    objc.useMsgSendVariants
        ? _objc_msgSend_uimyc7Stret(
            _ptr, this.ref.pointer, _sel_lineRangeForRange_, range)
        : _ptr.ref = _objc_msgSend_uimyc7(
            this.ref.pointer, _sel_lineRangeForRange_, range);
    final _finalizable = _ptr.cast<ffi.Uint8>().asTypedList(
        ffi.sizeOf<NSRange>(),
        finalizer: pkg_ffi.calloc.nativeFree);
    return ffi.Struct.create<NSRange>(_finalizable);
  }

  /// localizedCapitalizedString
  NSString get localizedCapitalizedString {
    objc.checkOsVersionInternal('NSString.localizedCapitalizedString',
        iOS: (false, (9, 0, 0)), macOS: (false, (10, 11, 0)));
    final _ret = _objc_msgSend_151sglz(
        this.ref.pointer, _sel_localizedCapitalizedString);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// localizedCaseInsensitiveCompare:
  NSComparisonResult localizedCaseInsensitiveCompare_(NSString string) {
    final _ret = _objc_msgSend_1ym6zyw(this.ref.pointer,
        _sel_localizedCaseInsensitiveCompare_, string.ref.pointer);
    return NSComparisonResult.fromValue(_ret);
  }

  /// localizedCaseInsensitiveContainsString:
  bool localizedCaseInsensitiveContainsString_(NSString str) {
    objc.checkOsVersionInternal(
        'NSString.localizedCaseInsensitiveContainsString:',
        iOS: (false, (8, 0, 0)),
        macOS: (false, (10, 10, 0)));
    return _objc_msgSend_19nvye5(this.ref.pointer,
        _sel_localizedCaseInsensitiveContainsString_, str.ref.pointer);
  }

  /// localizedCompare:
  NSComparisonResult localizedCompare_(NSString string) {
    final _ret = _objc_msgSend_1ym6zyw(
        this.ref.pointer, _sel_localizedCompare_, string.ref.pointer);
    return NSComparisonResult.fromValue(_ret);
  }

  /// localizedLowercaseString
  NSString get localizedLowercaseString {
    objc.checkOsVersionInternal('NSString.localizedLowercaseString',
        iOS: (false, (9, 0, 0)), macOS: (false, (10, 11, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.pointer, _sel_localizedLowercaseString);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// localizedStandardCompare:
  NSComparisonResult localizedStandardCompare_(NSString string) {
    objc.checkOsVersionInternal('NSString.localizedStandardCompare:',
        iOS: (false, (4, 0, 0)), macOS: (false, (10, 6, 0)));
    final _ret = _objc_msgSend_1ym6zyw(
        this.ref.pointer, _sel_localizedStandardCompare_, string.ref.pointer);
    return NSComparisonResult.fromValue(_ret);
  }

  /// localizedStandardContainsString:
  bool localizedStandardContainsString_(NSString str) {
    objc.checkOsVersionInternal('NSString.localizedStandardContainsString:',
        iOS: (false, (9, 0, 0)), macOS: (false, (10, 11, 0)));
    return _objc_msgSend_19nvye5(this.ref.pointer,
        _sel_localizedStandardContainsString_, str.ref.pointer);
  }

  /// localizedStandardRangeOfString:
  NSRange localizedStandardRangeOfString_(NSString str) {
    objc.checkOsVersionInternal('NSString.localizedStandardRangeOfString:',
        iOS: (false, (9, 0, 0)), macOS: (false, (10, 11, 0)));
    final _ptr = pkg_ffi.calloc<NSRange>();
    objc.useMsgSendVariants
        ? _objc_msgSend_182fzonStret(_ptr, this.ref.pointer,
            _sel_localizedStandardRangeOfString_, str.ref.pointer)
        : _ptr.ref = _objc_msgSend_182fzon(this.ref.pointer,
            _sel_localizedStandardRangeOfString_, str.ref.pointer);
    final _finalizable = _ptr.cast<ffi.Uint8>().asTypedList(
        ffi.sizeOf<NSRange>(),
        finalizer: pkg_ffi.calloc.nativeFree);
    return ffi.Struct.create<NSRange>(_finalizable);
  }

  /// localizedUppercaseString
  NSString get localizedUppercaseString {
    objc.checkOsVersionInternal('NSString.localizedUppercaseString',
        iOS: (false, (9, 0, 0)), macOS: (false, (10, 11, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.pointer, _sel_localizedUppercaseString);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// longLongValue
  int get longLongValue {
    objc.checkOsVersionInternal('NSString.longLongValue',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 5, 0)));
    return _objc_msgSend_1k101e3(this.ref.pointer, _sel_longLongValue);
  }

  /// lowercaseString
  NSString get lowercaseString {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_lowercaseString);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// lowercaseStringWithLocale:
  NSString lowercaseStringWithLocale_(NSLocale? locale) {
    objc.checkOsVersionInternal('NSString.lowercaseStringWithLocale:',
        iOS: (false, (6, 0, 0)), macOS: (false, (10, 8, 0)));
    final _ret = _objc_msgSend_1sotr3r(this.ref.pointer,
        _sel_lowercaseStringWithLocale_, locale?.ref.pointer ?? ffi.nullptr);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// maximumLengthOfBytesUsingEncoding:
  int maximumLengthOfBytesUsingEncoding_(int enc) {
    return _objc_msgSend_12py2ux(
        this.ref.pointer, _sel_maximumLengthOfBytesUsingEncoding_, enc);
  }

  /// paragraphRangeForRange:
  NSRange paragraphRangeForRange_(NSRange range) {
    final _ptr = pkg_ffi.calloc<NSRange>();
    objc.useMsgSendVariants
        ? _objc_msgSend_uimyc7Stret(
            _ptr, this.ref.pointer, _sel_paragraphRangeForRange_, range)
        : _ptr.ref = _objc_msgSend_uimyc7(
            this.ref.pointer, _sel_paragraphRangeForRange_, range);
    final _finalizable = _ptr.cast<ffi.Uint8>().asTypedList(
        ffi.sizeOf<NSRange>(),
        finalizer: pkg_ffi.calloc.nativeFree);
    return ffi.Struct.create<NSRange>(_finalizable);
  }

  /// precomposedStringWithCanonicalMapping
  NSString get precomposedStringWithCanonicalMapping {
    final _ret = _objc_msgSend_151sglz(
        this.ref.pointer, _sel_precomposedStringWithCanonicalMapping);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// precomposedStringWithCompatibilityMapping
  NSString get precomposedStringWithCompatibilityMapping {
    final _ret = _objc_msgSend_151sglz(
        this.ref.pointer, _sel_precomposedStringWithCompatibilityMapping);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// rangeOfCharacterFromSet:
  NSRange rangeOfCharacterFromSet_(NSCharacterSet searchSet) {
    final _ptr = pkg_ffi.calloc<NSRange>();
    objc.useMsgSendVariants
        ? _objc_msgSend_182fzonStret(_ptr, this.ref.pointer,
            _sel_rangeOfCharacterFromSet_, searchSet.ref.pointer)
        : _ptr.ref = _objc_msgSend_182fzon(this.ref.pointer,
            _sel_rangeOfCharacterFromSet_, searchSet.ref.pointer);
    final _finalizable = _ptr.cast<ffi.Uint8>().asTypedList(
        ffi.sizeOf<NSRange>(),
        finalizer: pkg_ffi.calloc.nativeFree);
    return ffi.Struct.create<NSRange>(_finalizable);
  }

  /// rangeOfCharacterFromSet:options:
  NSRange rangeOfCharacterFromSet_options_(
      NSCharacterSet searchSet, NSStringCompareOptions mask) {
    final _ptr = pkg_ffi.calloc<NSRange>();
    objc.useMsgSendVariants
        ? _objc_msgSend_102xxo4Stret(
            _ptr,
            this.ref.pointer,
            _sel_rangeOfCharacterFromSet_options_,
            searchSet.ref.pointer,
            mask.value)
        : _ptr.ref = _objc_msgSend_102xxo4(
            this.ref.pointer,
            _sel_rangeOfCharacterFromSet_options_,
            searchSet.ref.pointer,
            mask.value);
    final _finalizable = _ptr.cast<ffi.Uint8>().asTypedList(
        ffi.sizeOf<NSRange>(),
        finalizer: pkg_ffi.calloc.nativeFree);
    return ffi.Struct.create<NSRange>(_finalizable);
  }

  /// rangeOfCharacterFromSet:options:range:
  NSRange rangeOfCharacterFromSet_options_range_(NSCharacterSet searchSet,
      NSStringCompareOptions mask, NSRange rangeOfReceiverToSearch) {
    final _ptr = pkg_ffi.calloc<NSRange>();
    objc.useMsgSendVariants
        ? _objc_msgSend_1nmlvqcStret(
            _ptr,
            this.ref.pointer,
            _sel_rangeOfCharacterFromSet_options_range_,
            searchSet.ref.pointer,
            mask.value,
            rangeOfReceiverToSearch)
        : _ptr.ref = _objc_msgSend_1nmlvqc(
            this.ref.pointer,
            _sel_rangeOfCharacterFromSet_options_range_,
            searchSet.ref.pointer,
            mask.value,
            rangeOfReceiverToSearch);
    final _finalizable = _ptr.cast<ffi.Uint8>().asTypedList(
        ffi.sizeOf<NSRange>(),
        finalizer: pkg_ffi.calloc.nativeFree);
    return ffi.Struct.create<NSRange>(_finalizable);
  }

  /// rangeOfComposedCharacterSequenceAtIndex:
  NSRange rangeOfComposedCharacterSequenceAtIndex_(int index) {
    final _ptr = pkg_ffi.calloc<NSRange>();
    objc.useMsgSendVariants
        ? _objc_msgSend_d3i1uyStret(_ptr, this.ref.pointer,
            _sel_rangeOfComposedCharacterSequenceAtIndex_, index)
        : _ptr.ref = _objc_msgSend_d3i1uy(this.ref.pointer,
            _sel_rangeOfComposedCharacterSequenceAtIndex_, index);
    final _finalizable = _ptr.cast<ffi.Uint8>().asTypedList(
        ffi.sizeOf<NSRange>(),
        finalizer: pkg_ffi.calloc.nativeFree);
    return ffi.Struct.create<NSRange>(_finalizable);
  }

  /// rangeOfComposedCharacterSequencesForRange:
  NSRange rangeOfComposedCharacterSequencesForRange_(NSRange range) {
    objc.checkOsVersionInternal(
        'NSString.rangeOfComposedCharacterSequencesForRange:',
        iOS: (false, (2, 0, 0)),
        macOS: (false, (10, 5, 0)));
    final _ptr = pkg_ffi.calloc<NSRange>();
    objc.useMsgSendVariants
        ? _objc_msgSend_uimyc7Stret(_ptr, this.ref.pointer,
            _sel_rangeOfComposedCharacterSequencesForRange_, range)
        : _ptr.ref = _objc_msgSend_uimyc7(this.ref.pointer,
            _sel_rangeOfComposedCharacterSequencesForRange_, range);
    final _finalizable = _ptr.cast<ffi.Uint8>().asTypedList(
        ffi.sizeOf<NSRange>(),
        finalizer: pkg_ffi.calloc.nativeFree);
    return ffi.Struct.create<NSRange>(_finalizable);
  }

  /// rangeOfString:
  NSRange rangeOfString_(NSString searchString) {
    final _ptr = pkg_ffi.calloc<NSRange>();
    objc.useMsgSendVariants
        ? _objc_msgSend_182fzonStret(_ptr, this.ref.pointer,
            _sel_rangeOfString_, searchString.ref.pointer)
        : _ptr.ref = _objc_msgSend_182fzon(
            this.ref.pointer, _sel_rangeOfString_, searchString.ref.pointer);
    final _finalizable = _ptr.cast<ffi.Uint8>().asTypedList(
        ffi.sizeOf<NSRange>(),
        finalizer: pkg_ffi.calloc.nativeFree);
    return ffi.Struct.create<NSRange>(_finalizable);
  }

  /// rangeOfString:options:
  NSRange rangeOfString_options_(
      NSString searchString, NSStringCompareOptions mask) {
    final _ptr = pkg_ffi.calloc<NSRange>();
    objc.useMsgSendVariants
        ? _objc_msgSend_102xxo4Stret(_ptr, this.ref.pointer,
            _sel_rangeOfString_options_, searchString.ref.pointer, mask.value)
        : _ptr.ref = _objc_msgSend_102xxo4(this.ref.pointer,
            _sel_rangeOfString_options_, searchString.ref.pointer, mask.value);
    final _finalizable = _ptr.cast<ffi.Uint8>().asTypedList(
        ffi.sizeOf<NSRange>(),
        finalizer: pkg_ffi.calloc.nativeFree);
    return ffi.Struct.create<NSRange>(_finalizable);
  }

  /// rangeOfString:options:range:
  NSRange rangeOfString_options_range_(NSString searchString,
      NSStringCompareOptions mask, NSRange rangeOfReceiverToSearch) {
    final _ptr = pkg_ffi.calloc<NSRange>();
    objc.useMsgSendVariants
        ? _objc_msgSend_1nmlvqcStret(
            _ptr,
            this.ref.pointer,
            _sel_rangeOfString_options_range_,
            searchString.ref.pointer,
            mask.value,
            rangeOfReceiverToSearch)
        : _ptr.ref = _objc_msgSend_1nmlvqc(
            this.ref.pointer,
            _sel_rangeOfString_options_range_,
            searchString.ref.pointer,
            mask.value,
            rangeOfReceiverToSearch);
    final _finalizable = _ptr.cast<ffi.Uint8>().asTypedList(
        ffi.sizeOf<NSRange>(),
        finalizer: pkg_ffi.calloc.nativeFree);
    return ffi.Struct.create<NSRange>(_finalizable);
  }

  /// rangeOfString:options:range:locale:
  NSRange rangeOfString_options_range_locale_(
      NSString searchString,
      NSStringCompareOptions mask,
      NSRange rangeOfReceiverToSearch,
      NSLocale? locale) {
    objc.checkOsVersionInternal('NSString.rangeOfString:options:range:locale:',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 5, 0)));
    final _ptr = pkg_ffi.calloc<NSRange>();
    objc.useMsgSendVariants
        ? _objc_msgSend_gg0462Stret(
            _ptr,
            this.ref.pointer,
            _sel_rangeOfString_options_range_locale_,
            searchString.ref.pointer,
            mask.value,
            rangeOfReceiverToSearch,
            locale?.ref.pointer ?? ffi.nullptr)
        : _ptr.ref = _objc_msgSend_gg0462(
            this.ref.pointer,
            _sel_rangeOfString_options_range_locale_,
            searchString.ref.pointer,
            mask.value,
            rangeOfReceiverToSearch,
            locale?.ref.pointer ?? ffi.nullptr);
    final _finalizable = _ptr.cast<ffi.Uint8>().asTypedList(
        ffi.sizeOf<NSRange>(),
        finalizer: pkg_ffi.calloc.nativeFree);
    return ffi.Struct.create<NSRange>(_finalizable);
  }

  /// smallestEncoding
  int get smallestEncoding {
    return _objc_msgSend_xw2lbc(this.ref.pointer, _sel_smallestEncoding);
  }

  /// stringByAppendingFormat:
  NSString stringByAppendingFormat_(NSString format) {
    final _ret = _objc_msgSend_1sotr3r(
        this.ref.pointer, _sel_stringByAppendingFormat_, format.ref.pointer);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringByAppendingString:
  NSString stringByAppendingString_(NSString aString) {
    final _ret = _objc_msgSend_1sotr3r(
        this.ref.pointer, _sel_stringByAppendingString_, aString.ref.pointer);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringByApplyingTransform:reverse:
  NSString? stringByApplyingTransform_reverse_(
      NSString transform, bool reverse) {
    objc.checkOsVersionInternal('NSString.stringByApplyingTransform:reverse:',
        iOS: (false, (9, 0, 0)), macOS: (false, (10, 11, 0)));
    final _ret = _objc_msgSend_17amj0z(
        this.ref.pointer,
        _sel_stringByApplyingTransform_reverse_,
        transform.ref.pointer,
        reverse);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringByFoldingWithOptions:locale:
  NSString stringByFoldingWithOptions_locale_(
      NSStringCompareOptions options, NSLocale? locale) {
    objc.checkOsVersionInternal('NSString.stringByFoldingWithOptions:locale:',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 5, 0)));
    final _ret = _objc_msgSend_11cbyu0(
        this.ref.pointer,
        _sel_stringByFoldingWithOptions_locale_,
        options.value,
        locale?.ref.pointer ?? ffi.nullptr);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringByPaddingToLength:withString:startingAtIndex:
  NSString stringByPaddingToLength_withString_startingAtIndex_(
      int newLength, NSString padString, int padIndex) {
    final _ret = _objc_msgSend_1tfztp(
        this.ref.pointer,
        _sel_stringByPaddingToLength_withString_startingAtIndex_,
        newLength,
        padString.ref.pointer,
        padIndex);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringByReplacingCharactersInRange:withString:
  NSString stringByReplacingCharactersInRange_withString_(
      NSRange range, NSString replacement) {
    objc.checkOsVersionInternal(
        'NSString.stringByReplacingCharactersInRange:withString:',
        iOS: (false, (2, 0, 0)),
        macOS: (false, (10, 5, 0)));
    final _ret = _objc_msgSend_bstjp9(
        this.ref.pointer,
        _sel_stringByReplacingCharactersInRange_withString_,
        range,
        replacement.ref.pointer);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringByReplacingOccurrencesOfString:withString:
  NSString stringByReplacingOccurrencesOfString_withString_(
      NSString target, NSString replacement) {
    objc.checkOsVersionInternal(
        'NSString.stringByReplacingOccurrencesOfString:withString:',
        iOS: (false, (2, 0, 0)),
        macOS: (false, (10, 5, 0)));
    final _ret = _objc_msgSend_15qeuct(
        this.ref.pointer,
        _sel_stringByReplacingOccurrencesOfString_withString_,
        target.ref.pointer,
        replacement.ref.pointer);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringByReplacingOccurrencesOfString:withString:options:range:
  NSString stringByReplacingOccurrencesOfString_withString_options_range_(
      NSString target,
      NSString replacement,
      NSStringCompareOptions options,
      NSRange searchRange) {
    objc.checkOsVersionInternal(
        'NSString.stringByReplacingOccurrencesOfString:withString:options:range:',
        iOS: (false, (2, 0, 0)),
        macOS: (false, (10, 5, 0)));
    final _ret = _objc_msgSend_2u4jm6(
        this.ref.pointer,
        _sel_stringByReplacingOccurrencesOfString_withString_options_range_,
        target.ref.pointer,
        replacement.ref.pointer,
        options.value,
        searchRange);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// stringByTrimmingCharactersInSet:
  NSString stringByTrimmingCharactersInSet_(NSCharacterSet set) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.pointer,
        _sel_stringByTrimmingCharactersInSet_, set.ref.pointer);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// substringFromIndex:
  NSString substringFromIndex_(int from) {
    final _ret =
        _objc_msgSend_14hpxwa(this.ref.pointer, _sel_substringFromIndex_, from);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// substringToIndex:
  NSString substringToIndex_(int to) {
    final _ret =
        _objc_msgSend_14hpxwa(this.ref.pointer, _sel_substringToIndex_, to);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// substringWithRange:
  NSString substringWithRange_(NSRange range) {
    final _ret = _objc_msgSend_1k1o1s7(
        this.ref.pointer, _sel_substringWithRange_, range);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// uppercaseString
  NSString get uppercaseString {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_uppercaseString);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// uppercaseStringWithLocale:
  NSString uppercaseStringWithLocale_(NSLocale? locale) {
    objc.checkOsVersionInternal('NSString.uppercaseStringWithLocale:',
        iOS: (false, (6, 0, 0)), macOS: (false, (10, 8, 0)));
    final _ret = _objc_msgSend_1sotr3r(this.ref.pointer,
        _sel_uppercaseStringWithLocale_, locale?.ref.pointer ?? ffi.nullptr);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// writeToFile:atomically:encoding:error:
  bool writeToFile_atomically_encoding_error_(
      NSString path,
      bool useAuxiliaryFile,
      int enc,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_dv3z6r(
        this.ref.pointer,
        _sel_writeToFile_atomically_encoding_error_,
        path.ref.pointer,
        useAuxiliaryFile,
        enc,
        error);
  }

  /// writeToURL:atomically:encoding:error:
  bool writeToURL_atomically_encoding_error_(NSURL url, bool useAuxiliaryFile,
      int enc, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    return _objc_msgSend_dv3z6r(
        this.ref.pointer,
        _sel_writeToURL_atomically_encoding_error_,
        url.ref.pointer,
        useAuxiliaryFile,
        enc,
        error);
  }
}

/// NSURL
class NSURL extends NSObject implements NSSecureCoding, NSCopying {
  NSURL._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSURL] that points to the same underlying object as [other].
  NSURL.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSURL] that wraps the given raw object pointer.
  NSURL.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSURL].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSURL);
  }

  /// URLByResolvingAliasFileAtURL:options:error:
  static NSURL? URLByResolvingAliasFileAtURL_options_error_(
      NSURL url,
      NSURLBookmarkResolutionOptions options,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    objc.checkOsVersionInternal(
        'NSURL.URLByResolvingAliasFileAtURL:options:error:',
        iOS: (false, (8, 0, 0)),
        macOS: (false, (10, 10, 0)));
    final _ret = _objc_msgSend_1tiux5i(
        _class_NSURL,
        _sel_URLByResolvingAliasFileAtURL_options_error_,
        url.ref.pointer,
        options.value,
        error);
    return _ret.address == 0
        ? null
        : NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  /// URLByResolvingBookmarkData:options:relativeToURL:bookmarkDataIsStale:error:
  static NSURL?
      URLByResolvingBookmarkData_options_relativeToURL_bookmarkDataIsStale_error_(
          NSData bookmarkData,
          NSURLBookmarkResolutionOptions options,
          NSURL? relativeURL,
          ffi.Pointer<ffi.Bool> isStale,
          ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    objc.checkOsVersionInternal(
        'NSURL.URLByResolvingBookmarkData:options:relativeToURL:bookmarkDataIsStale:error:',
        iOS: (false, (4, 0, 0)),
        macOS: (false, (10, 6, 0)));
    final _ret = _objc_msgSend_1ceswyu(
        _class_NSURL,
        _sel_URLByResolvingBookmarkData_options_relativeToURL_bookmarkDataIsStale_error_,
        bookmarkData.ref.pointer,
        options.value,
        relativeURL?.ref.pointer ?? ffi.nullptr,
        isStale,
        error);
    return _ret.address == 0
        ? null
        : NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  /// URLWithDataRepresentation:relativeToURL:
  static NSURL URLWithDataRepresentation_relativeToURL_(
      NSData data, NSURL? baseURL) {
    objc.checkOsVersionInternal(
        'NSURL.URLWithDataRepresentation:relativeToURL:',
        iOS: (false, (9, 0, 0)),
        macOS: (false, (10, 11, 0)));
    final _ret = _objc_msgSend_15qeuct(
        _class_NSURL,
        _sel_URLWithDataRepresentation_relativeToURL_,
        data.ref.pointer,
        baseURL?.ref.pointer ?? ffi.nullptr);
    return NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  /// URLWithString:
  static NSURL? URLWithString_(NSString URLString) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSURL, _sel_URLWithString_, URLString.ref.pointer);
    return _ret.address == 0
        ? null
        : NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  /// URLWithString:encodingInvalidCharacters:
  ///
  /// iOS: introduced 17.0.0
  /// macOS: introduced 14.0.0
  static NSURL? URLWithString_encodingInvalidCharacters_(
      NSString URLString, bool encodingInvalidCharacters) {
    objc.checkOsVersionInternal(
        'NSURL.URLWithString:encodingInvalidCharacters:',
        iOS: (false, (17, 0, 0)),
        macOS: (false, (14, 0, 0)));
    final _ret = _objc_msgSend_17amj0z(
        _class_NSURL,
        _sel_URLWithString_encodingInvalidCharacters_,
        URLString.ref.pointer,
        encodingInvalidCharacters);
    return _ret.address == 0
        ? null
        : NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  /// URLWithString:relativeToURL:
  static NSURL? URLWithString_relativeToURL_(
      NSString URLString, NSURL? baseURL) {
    final _ret = _objc_msgSend_15qeuct(
        _class_NSURL,
        _sel_URLWithString_relativeToURL_,
        URLString.ref.pointer,
        baseURL?.ref.pointer ?? ffi.nullptr);
    return _ret.address == 0
        ? null
        : NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  /// absoluteURLWithDataRepresentation:relativeToURL:
  static NSURL absoluteURLWithDataRepresentation_relativeToURL_(
      NSData data, NSURL? baseURL) {
    objc.checkOsVersionInternal(
        'NSURL.absoluteURLWithDataRepresentation:relativeToURL:',
        iOS: (false, (9, 0, 0)),
        macOS: (false, (10, 11, 0)));
    final _ret = _objc_msgSend_15qeuct(
        _class_NSURL,
        _sel_absoluteURLWithDataRepresentation_relativeToURL_,
        data.ref.pointer,
        baseURL?.ref.pointer ?? ffi.nullptr);
    return NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  /// alloc
  static NSURL alloc() {
    final _ret = _objc_msgSend_151sglz(_class_NSURL, _sel_alloc);
    return NSURL.castFromPointer(_ret, retain: false, release: true);
  }

  /// allocWithZone:
  static NSURL allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret = _objc_msgSend_1cwp428(_class_NSURL, _sel_allocWithZone_, zone);
    return NSURL.castFromPointer(_ret, retain: false, release: true);
  }

  /// bookmarkDataWithContentsOfURL:error:
  static NSData? bookmarkDataWithContentsOfURL_error_(
      NSURL bookmarkFileURL, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    objc.checkOsVersionInternal('NSURL.bookmarkDataWithContentsOfURL:error:',
        iOS: (false, (4, 0, 0)), macOS: (false, (10, 6, 0)));
    final _ret = _objc_msgSend_1lhpu4m(
        _class_NSURL,
        _sel_bookmarkDataWithContentsOfURL_error_,
        bookmarkFileURL.ref.pointer,
        error);
    return _ret.address == 0
        ? null
        : NSData.castFromPointer(_ret, retain: true, release: true);
  }

  /// fileURLWithFileSystemRepresentation:isDirectory:relativeToURL:
  static NSURL fileURLWithFileSystemRepresentation_isDirectory_relativeToURL_(
      ffi.Pointer<ffi.Char> path, bool isDir, NSURL? baseURL) {
    objc.checkOsVersionInternal(
        'NSURL.fileURLWithFileSystemRepresentation:isDirectory:relativeToURL:',
        iOS: (false, (7, 0, 0)),
        macOS: (false, (10, 9, 0)));
    final _ret = _objc_msgSend_1n40f6p(
        _class_NSURL,
        _sel_fileURLWithFileSystemRepresentation_isDirectory_relativeToURL_,
        path,
        isDir,
        baseURL?.ref.pointer ?? ffi.nullptr);
    return NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  /// fileURLWithPath:
  static NSURL fileURLWithPath_(NSString path) {
    final _ret = _objc_msgSend_1sotr3r(
        _class_NSURL, _sel_fileURLWithPath_, path.ref.pointer);
    return NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  /// fileURLWithPath:isDirectory:
  static NSURL fileURLWithPath_isDirectory_(NSString path, bool isDir) {
    objc.checkOsVersionInternal('NSURL.fileURLWithPath:isDirectory:',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 5, 0)));
    final _ret = _objc_msgSend_17amj0z(_class_NSURL,
        _sel_fileURLWithPath_isDirectory_, path.ref.pointer, isDir);
    return NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  /// fileURLWithPath:isDirectory:relativeToURL:
  static NSURL fileURLWithPath_isDirectory_relativeToURL_(
      NSString path, bool isDir, NSURL? baseURL) {
    objc.checkOsVersionInternal(
        'NSURL.fileURLWithPath:isDirectory:relativeToURL:',
        iOS: (false, (9, 0, 0)),
        macOS: (false, (10, 11, 0)));
    final _ret = _objc_msgSend_1ged0jd(
        _class_NSURL,
        _sel_fileURLWithPath_isDirectory_relativeToURL_,
        path.ref.pointer,
        isDir,
        baseURL?.ref.pointer ?? ffi.nullptr);
    return NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  /// fileURLWithPath:relativeToURL:
  static NSURL fileURLWithPath_relativeToURL_(NSString path, NSURL? baseURL) {
    objc.checkOsVersionInternal('NSURL.fileURLWithPath:relativeToURL:',
        iOS: (false, (9, 0, 0)), macOS: (false, (10, 11, 0)));
    final _ret = _objc_msgSend_15qeuct(
        _class_NSURL,
        _sel_fileURLWithPath_relativeToURL_,
        path.ref.pointer,
        baseURL?.ref.pointer ?? ffi.nullptr);
    return NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  /// new
  static NSURL new$() {
    final _ret = _objc_msgSend_151sglz(_class_NSURL, _sel_new);
    return NSURL.castFromPointer(_ret, retain: false, release: true);
  }

  /// objectWithItemProviderData:typeIdentifier:error:
  static NSURL? objectWithItemProviderData_typeIdentifier_error_(
      NSData data,
      NSString typeIdentifier,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> outError) {
    objc.checkOsVersionInternal(
        'NSURL.objectWithItemProviderData:typeIdentifier:error:',
        iOS: (false, (11, 0, 0)),
        macOS: (false, (10, 13, 0)));
    final _ret = _objc_msgSend_1pnyuds(
        _class_NSURL,
        _sel_objectWithItemProviderData_typeIdentifier_error_,
        data.ref.pointer,
        typeIdentifier.ref.pointer,
        outError);
    return _ret.address == 0
        ? null
        : NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  /// resourceValuesForKeys:fromBookmarkData:
  static objc.ObjCObjectBase? resourceValuesForKeys_fromBookmarkData_(
      NSArray keys, NSData bookmarkData) {
    objc.checkOsVersionInternal('NSURL.resourceValuesForKeys:fromBookmarkData:',
        iOS: (false, (4, 0, 0)), macOS: (false, (10, 6, 0)));
    final _ret = _objc_msgSend_15qeuct(
        _class_NSURL,
        _sel_resourceValuesForKeys_fromBookmarkData_,
        keys.ref.pointer,
        bookmarkData.ref.pointer);
    return _ret.address == 0
        ? null
        : objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// supportsSecureCoding
  static bool getSupportsSecureCoding() {
    return _objc_msgSend_91o635(_class_NSURL, _sel_supportsSecureCoding);
  }

  /// writeBookmarkData:toURL:options:error:
  static bool writeBookmarkData_toURL_options_error_(
      NSData bookmarkData,
      NSURL bookmarkFileURL,
      int options,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    objc.checkOsVersionInternal('NSURL.writeBookmarkData:toURL:options:error:',
        iOS: (false, (4, 0, 0)), macOS: (false, (10, 6, 0)));
    return _objc_msgSend_1vxoo9h(
        _class_NSURL,
        _sel_writeBookmarkData_toURL_options_error_,
        bookmarkData.ref.pointer,
        bookmarkFileURL.ref.pointer,
        options,
        error);
  }

  /// absoluteString
  NSString? get absoluteString {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_absoluteString);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// absoluteURL
  NSURL? get absoluteURL {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_absoluteURL);
    return _ret.address == 0
        ? null
        : NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  /// baseURL
  NSURL? get baseURL {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_baseURL);
    return _ret.address == 0
        ? null
        : NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  /// bookmarkDataWithOptions:includingResourceValuesForKeys:relativeToURL:error:
  NSData?
      bookmarkDataWithOptions_includingResourceValuesForKeys_relativeToURL_error_(
          NSURLBookmarkCreationOptions options,
          NSArray? keys,
          NSURL? relativeURL,
          ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    objc.checkOsVersionInternal(
        'NSURL.bookmarkDataWithOptions:includingResourceValuesForKeys:relativeToURL:error:',
        iOS: (false, (4, 0, 0)),
        macOS: (false, (10, 6, 0)));
    final _ret = _objc_msgSend_1wt9a7r(
        this.ref.pointer,
        _sel_bookmarkDataWithOptions_includingResourceValuesForKeys_relativeToURL_error_,
        options.value,
        keys?.ref.pointer ?? ffi.nullptr,
        relativeURL?.ref.pointer ?? ffi.nullptr,
        error);
    return _ret.address == 0
        ? null
        : NSData.castFromPointer(_ret, retain: true, release: true);
  }

  /// dataRepresentation
  NSData get dataRepresentation {
    objc.checkOsVersionInternal('NSURL.dataRepresentation',
        iOS: (false, (9, 0, 0)), macOS: (false, (10, 11, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.pointer, _sel_dataRepresentation);
    return NSData.castFromPointer(_ret, retain: true, release: true);
  }

  /// encodeWithCoder:
  void encodeWithCoder_(NSCoder coder) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_encodeWithCoder_, coder.ref.pointer);
  }

  /// filePathURL
  NSURL? get filePathURL {
    objc.checkOsVersionInternal('NSURL.filePathURL',
        iOS: (false, (4, 0, 0)), macOS: (false, (10, 6, 0)));
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_filePathURL);
    return _ret.address == 0
        ? null
        : NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  /// fileReferenceURL
  NSURL? fileReferenceURL() {
    objc.checkOsVersionInternal('NSURL.fileReferenceURL',
        iOS: (false, (4, 0, 0)), macOS: (false, (10, 6, 0)));
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_fileReferenceURL);
    return _ret.address == 0
        ? null
        : NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  /// fileSystemRepresentation
  ffi.Pointer<ffi.Char> get fileSystemRepresentation {
    objc.checkOsVersionInternal('NSURL.fileSystemRepresentation',
        iOS: (false, (7, 0, 0)), macOS: (false, (10, 9, 0)));
    return _objc_msgSend_1fuqfwb(
        this.ref.pointer, _sel_fileSystemRepresentation);
  }

  /// fragment
  NSString? get fragment {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_fragment);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// getFileSystemRepresentation:maxLength:
  bool getFileSystemRepresentation_maxLength_(
      ffi.Pointer<ffi.Char> buffer, int maxBufferLength) {
    objc.checkOsVersionInternal('NSURL.getFileSystemRepresentation:maxLength:',
        iOS: (false, (7, 0, 0)), macOS: (false, (10, 9, 0)));
    return _objc_msgSend_8cymbm(this.ref.pointer,
        _sel_getFileSystemRepresentation_maxLength_, buffer, maxBufferLength);
  }

  /// getResourceValue:forKey:error:
  bool getResourceValue_forKey_error_(
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> value,
      NSString key,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    objc.checkOsVersionInternal('NSURL.getResourceValue:forKey:error:',
        iOS: (false, (4, 0, 0)), macOS: (false, (10, 6, 0)));
    return _objc_msgSend_1j9bhml(this.ref.pointer,
        _sel_getResourceValue_forKey_error_, value, key.ref.pointer, error);
  }

  /// hasDirectoryPath
  bool get hasDirectoryPath {
    objc.checkOsVersionInternal('NSURL.hasDirectoryPath',
        iOS: (false, (9, 0, 0)), macOS: (false, (10, 11, 0)));
    return _objc_msgSend_91o635(this.ref.pointer, _sel_hasDirectoryPath);
  }

  /// host
  NSString? get host {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_host);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// init
  NSURL init() {
    objc.checkOsVersionInternal('NSURL.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSURL.castFromPointer(_ret, retain: false, release: true);
  }

  /// initAbsoluteURLWithDataRepresentation:relativeToURL:
  NSURL initAbsoluteURLWithDataRepresentation_relativeToURL_(
      NSData data, NSURL? baseURL) {
    objc.checkOsVersionInternal(
        'NSURL.initAbsoluteURLWithDataRepresentation:relativeToURL:',
        iOS: (false, (9, 0, 0)),
        macOS: (false, (10, 11, 0)));
    final _ret = _objc_msgSend_15qeuct(
        this.ref.retainAndReturnPointer(),
        _sel_initAbsoluteURLWithDataRepresentation_relativeToURL_,
        data.ref.pointer,
        baseURL?.ref.pointer ?? ffi.nullptr);
    return NSURL.castFromPointer(_ret, retain: false, release: true);
  }

  /// initByResolvingBookmarkData:options:relativeToURL:bookmarkDataIsStale:error:
  NSURL?
      initByResolvingBookmarkData_options_relativeToURL_bookmarkDataIsStale_error_(
          NSData bookmarkData,
          NSURLBookmarkResolutionOptions options,
          NSURL? relativeURL,
          ffi.Pointer<ffi.Bool> isStale,
          ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    objc.checkOsVersionInternal(
        'NSURL.initByResolvingBookmarkData:options:relativeToURL:bookmarkDataIsStale:error:',
        iOS: (false, (4, 0, 0)),
        macOS: (false, (10, 6, 0)));
    final _ret = _objc_msgSend_1ceswyu(
        this.ref.retainAndReturnPointer(),
        _sel_initByResolvingBookmarkData_options_relativeToURL_bookmarkDataIsStale_error_,
        bookmarkData.ref.pointer,
        options.value,
        relativeURL?.ref.pointer ?? ffi.nullptr,
        isStale,
        error);
    return _ret.address == 0
        ? null
        : NSURL.castFromPointer(_ret, retain: false, release: true);
  }

  /// initFileURLWithFileSystemRepresentation:isDirectory:relativeToURL:
  NSURL initFileURLWithFileSystemRepresentation_isDirectory_relativeToURL_(
      ffi.Pointer<ffi.Char> path, bool isDir, NSURL? baseURL) {
    objc.checkOsVersionInternal(
        'NSURL.initFileURLWithFileSystemRepresentation:isDirectory:relativeToURL:',
        iOS: (false, (7, 0, 0)),
        macOS: (false, (10, 9, 0)));
    final _ret = _objc_msgSend_1n40f6p(
        this.ref.retainAndReturnPointer(),
        _sel_initFileURLWithFileSystemRepresentation_isDirectory_relativeToURL_,
        path,
        isDir,
        baseURL?.ref.pointer ?? ffi.nullptr);
    return NSURL.castFromPointer(_ret, retain: false, release: true);
  }

  /// initFileURLWithPath:
  NSURL initFileURLWithPath_(NSString path) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initFileURLWithPath_, path.ref.pointer);
    return NSURL.castFromPointer(_ret, retain: false, release: true);
  }

  /// initFileURLWithPath:isDirectory:
  NSURL initFileURLWithPath_isDirectory_(NSString path, bool isDir) {
    objc.checkOsVersionInternal('NSURL.initFileURLWithPath:isDirectory:',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 5, 0)));
    final _ret = _objc_msgSend_17amj0z(this.ref.retainAndReturnPointer(),
        _sel_initFileURLWithPath_isDirectory_, path.ref.pointer, isDir);
    return NSURL.castFromPointer(_ret, retain: false, release: true);
  }

  /// initFileURLWithPath:isDirectory:relativeToURL:
  NSURL initFileURLWithPath_isDirectory_relativeToURL_(
      NSString path, bool isDir, NSURL? baseURL) {
    objc.checkOsVersionInternal(
        'NSURL.initFileURLWithPath:isDirectory:relativeToURL:',
        iOS: (false, (9, 0, 0)),
        macOS: (false, (10, 11, 0)));
    final _ret = _objc_msgSend_1ged0jd(
        this.ref.retainAndReturnPointer(),
        _sel_initFileURLWithPath_isDirectory_relativeToURL_,
        path.ref.pointer,
        isDir,
        baseURL?.ref.pointer ?? ffi.nullptr);
    return NSURL.castFromPointer(_ret, retain: false, release: true);
  }

  /// initFileURLWithPath:relativeToURL:
  NSURL initFileURLWithPath_relativeToURL_(NSString path, NSURL? baseURL) {
    objc.checkOsVersionInternal('NSURL.initFileURLWithPath:relativeToURL:',
        iOS: (false, (9, 0, 0)), macOS: (false, (10, 11, 0)));
    final _ret = _objc_msgSend_15qeuct(
        this.ref.retainAndReturnPointer(),
        _sel_initFileURLWithPath_relativeToURL_,
        path.ref.pointer,
        baseURL?.ref.pointer ?? ffi.nullptr);
    return NSURL.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithCoder:
  NSURL? initWithCoder_(NSCoder coder) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithCoder_, coder.ref.pointer);
    return _ret.address == 0
        ? null
        : NSURL.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithDataRepresentation:relativeToURL:
  NSURL initWithDataRepresentation_relativeToURL_(NSData data, NSURL? baseURL) {
    objc.checkOsVersionInternal(
        'NSURL.initWithDataRepresentation:relativeToURL:',
        iOS: (false, (9, 0, 0)),
        macOS: (false, (10, 11, 0)));
    final _ret = _objc_msgSend_15qeuct(
        this.ref.retainAndReturnPointer(),
        _sel_initWithDataRepresentation_relativeToURL_,
        data.ref.pointer,
        baseURL?.ref.pointer ?? ffi.nullptr);
    return NSURL.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithString:
  NSURL? initWithString_(NSString URLString) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithString_, URLString.ref.pointer);
    return _ret.address == 0
        ? null
        : NSURL.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithString:encodingInvalidCharacters:
  ///
  /// iOS: introduced 17.0.0
  /// macOS: introduced 14.0.0
  NSURL? initWithString_encodingInvalidCharacters_(
      NSString URLString, bool encodingInvalidCharacters) {
    objc.checkOsVersionInternal(
        'NSURL.initWithString:encodingInvalidCharacters:',
        iOS: (false, (17, 0, 0)),
        macOS: (false, (14, 0, 0)));
    final _ret = _objc_msgSend_17amj0z(
        this.ref.retainAndReturnPointer(),
        _sel_initWithString_encodingInvalidCharacters_,
        URLString.ref.pointer,
        encodingInvalidCharacters);
    return _ret.address == 0
        ? null
        : NSURL.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithString:relativeToURL:
  NSURL? initWithString_relativeToURL_(NSString URLString, NSURL? baseURL) {
    final _ret = _objc_msgSend_15qeuct(
        this.ref.retainAndReturnPointer(),
        _sel_initWithString_relativeToURL_,
        URLString.ref.pointer,
        baseURL?.ref.pointer ?? ffi.nullptr);
    return _ret.address == 0
        ? null
        : NSURL.castFromPointer(_ret, retain: false, release: true);
  }

  /// isFileReferenceURL
  bool isFileReferenceURL() {
    objc.checkOsVersionInternal('NSURL.isFileReferenceURL',
        iOS: (false, (4, 0, 0)), macOS: (false, (10, 6, 0)));
    return _objc_msgSend_91o635(this.ref.pointer, _sel_isFileReferenceURL);
  }

  /// isFileURL
  bool get fileURL {
    return _objc_msgSend_91o635(this.ref.pointer, _sel_isFileURL);
  }

  /// iOS: introduced 2.0.0, deprecated 13.0.0
  /// macOS: introduced 10.2.0, deprecated 10.15.0
  NSString? get parameterString {
    objc.checkOsVersionInternal('NSURL.parameterString',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 2, 0)));
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_parameterString);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// password
  NSString? get password {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_password);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// path
  NSString? get path {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_path);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// port
  NSNumber? get port {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_port);
    return _ret.address == 0
        ? null
        : NSNumber.castFromPointer(_ret, retain: true, release: true);
  }

  /// query
  NSString? get query {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_query);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// relativePath
  NSString? get relativePath {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_relativePath);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// relativeString
  NSString get relativeString {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_relativeString);
    return NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// removeAllCachedResourceValues
  void removeAllCachedResourceValues() {
    objc.checkOsVersionInternal('NSURL.removeAllCachedResourceValues',
        iOS: (false, (7, 0, 0)), macOS: (false, (10, 9, 0)));
    _objc_msgSend_1pl9qdv(this.ref.pointer, _sel_removeAllCachedResourceValues);
  }

  /// removeCachedResourceValueForKey:
  void removeCachedResourceValueForKey_(NSString key) {
    objc.checkOsVersionInternal('NSURL.removeCachedResourceValueForKey:',
        iOS: (false, (7, 0, 0)), macOS: (false, (10, 9, 0)));
    _objc_msgSend_xtuoz7(this.ref.pointer,
        _sel_removeCachedResourceValueForKey_, key.ref.pointer);
  }

  /// resourceSpecifier
  NSString? get resourceSpecifier {
    final _ret =
        _objc_msgSend_151sglz(this.ref.pointer, _sel_resourceSpecifier);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// resourceValuesForKeys:error:
  objc.ObjCObjectBase? resourceValuesForKeys_error_(
      NSArray keys, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    objc.checkOsVersionInternal('NSURL.resourceValuesForKeys:error:',
        iOS: (false, (4, 0, 0)), macOS: (false, (10, 6, 0)));
    final _ret = _objc_msgSend_1lhpu4m(this.ref.pointer,
        _sel_resourceValuesForKeys_error_, keys.ref.pointer, error);
    return _ret.address == 0
        ? null
        : objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// scheme
  NSString? get scheme {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_scheme);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// setResourceValue:forKey:error:
  bool setResourceValue_forKey_error_(objc.ObjCObjectBase? value, NSString key,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    objc.checkOsVersionInternal('NSURL.setResourceValue:forKey:error:',
        iOS: (false, (4, 0, 0)), macOS: (false, (10, 6, 0)));
    return _objc_msgSend_6z4k82(
        this.ref.pointer,
        _sel_setResourceValue_forKey_error_,
        value?.ref.pointer ?? ffi.nullptr,
        key.ref.pointer,
        error);
  }

  /// setResourceValues:error:
  bool setResourceValues_error_(objc.ObjCObjectBase keyedValues,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> error) {
    objc.checkOsVersionInternal('NSURL.setResourceValues:error:',
        iOS: (false, (4, 0, 0)), macOS: (false, (10, 6, 0)));
    return _objc_msgSend_l9p60w(this.ref.pointer, _sel_setResourceValues_error_,
        keyedValues.ref.pointer, error);
  }

  /// setTemporaryResourceValue:forKey:
  void setTemporaryResourceValue_forKey_(
      objc.ObjCObjectBase? value, NSString key) {
    objc.checkOsVersionInternal('NSURL.setTemporaryResourceValue:forKey:',
        iOS: (false, (7, 0, 0)), macOS: (false, (10, 9, 0)));
    _objc_msgSend_pfv6jd(
        this.ref.pointer,
        _sel_setTemporaryResourceValue_forKey_,
        value?.ref.pointer ?? ffi.nullptr,
        key.ref.pointer);
  }

  /// standardizedURL
  NSURL? get standardizedURL {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_standardizedURL);
    return _ret.address == 0
        ? null
        : NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  /// startAccessingSecurityScopedResource
  bool startAccessingSecurityScopedResource() {
    objc.checkOsVersionInternal('NSURL.startAccessingSecurityScopedResource',
        iOS: (false, (8, 0, 0)), macOS: (false, (10, 7, 0)));
    return _objc_msgSend_91o635(
        this.ref.pointer, _sel_startAccessingSecurityScopedResource);
  }

  /// stopAccessingSecurityScopedResource
  void stopAccessingSecurityScopedResource() {
    objc.checkOsVersionInternal('NSURL.stopAccessingSecurityScopedResource',
        iOS: (false, (8, 0, 0)), macOS: (false, (10, 7, 0)));
    _objc_msgSend_1pl9qdv(
        this.ref.pointer, _sel_stopAccessingSecurityScopedResource);
  }

  /// user
  NSString? get user {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_user);
    return _ret.address == 0
        ? null
        : NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// Returns a new instance of NSURL constructed with the default `new` method.
  factory NSURL() => new$();
}

enum NSURLBookmarkCreationOptions {
  NSURLBookmarkCreationPreferFileIDResolution(256),
  NSURLBookmarkCreationMinimalBookmark(512),
  NSURLBookmarkCreationSuitableForBookmarkFile(1024),
  NSURLBookmarkCreationWithSecurityScope(2048),
  NSURLBookmarkCreationSecurityScopeAllowOnlyReadAccess(4096),
  NSURLBookmarkCreationWithoutImplicitSecurityScope(536870912);

  final int value;
  const NSURLBookmarkCreationOptions(this.value);

  static NSURLBookmarkCreationOptions fromValue(int value) => switch (value) {
        256 => NSURLBookmarkCreationPreferFileIDResolution,
        512 => NSURLBookmarkCreationMinimalBookmark,
        1024 => NSURLBookmarkCreationSuitableForBookmarkFile,
        2048 => NSURLBookmarkCreationWithSecurityScope,
        4096 => NSURLBookmarkCreationSecurityScopeAllowOnlyReadAccess,
        536870912 => NSURLBookmarkCreationWithoutImplicitSecurityScope,
        _ => throw ArgumentError(
            'Unknown value for NSURLBookmarkCreationOptions: $value'),
      };
}

enum NSURLBookmarkResolutionOptions {
  NSURLBookmarkResolutionWithoutUI(256),
  NSURLBookmarkResolutionWithoutMounting(512),
  NSURLBookmarkResolutionWithSecurityScope(1024),
  NSURLBookmarkResolutionWithoutImplicitStartAccessing(32768);

  final int value;
  const NSURLBookmarkResolutionOptions(this.value);

  static NSURLBookmarkResolutionOptions fromValue(int value) => switch (value) {
        256 => NSURLBookmarkResolutionWithoutUI,
        512 => NSURLBookmarkResolutionWithoutMounting,
        1024 => NSURLBookmarkResolutionWithSecurityScope,
        32768 => NSURLBookmarkResolutionWithoutImplicitStartAccessing,
        _ => throw ArgumentError(
            'Unknown value for NSURLBookmarkResolutionOptions: $value'),
      };
}

/// NSURLHandle
class NSURLHandle extends NSObject {
  NSURLHandle._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSURLHandle] that points to the same underlying object as [other].
  NSURLHandle.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSURLHandle] that wraps the given raw object pointer.
  NSURLHandle.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSURLHandle].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSURLHandle);
  }

  /// alloc
  static NSURLHandle alloc() {
    final _ret = _objc_msgSend_151sglz(_class_NSURLHandle, _sel_alloc);
    return NSURLHandle.castFromPointer(_ret, retain: false, release: true);
  }

  /// allocWithZone:
  static NSURLHandle allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret =
        _objc_msgSend_1cwp428(_class_NSURLHandle, _sel_allocWithZone_, zone);
    return NSURLHandle.castFromPointer(_ret, retain: false, release: true);
  }

  /// new
  static NSURLHandle new$() {
    final _ret = _objc_msgSend_151sglz(_class_NSURLHandle, _sel_new);
    return NSURLHandle.castFromPointer(_ret, retain: false, release: true);
  }

  /// autorelease
  NSURLHandle autorelease() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_autorelease);
    return NSURLHandle.castFromPointer(_ret, retain: true, release: true);
  }

  /// init
  NSURLHandle init() {
    objc.checkOsVersionInternal('NSURLHandle.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSURLHandle.castFromPointer(_ret, retain: false, release: true);
  }

  /// retain
  NSURLHandle retain() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_retain);
    return NSURLHandle.castFromPointer(_ret, retain: true, release: true);
  }

  /// self
  NSURLHandle self$1() {
    final _ret = _objc_msgSend_151sglz(this.ref.pointer, _sel_self);
    return NSURLHandle.castFromPointer(_ret, retain: true, release: true);
  }

  /// Returns a new instance of NSURLHandle constructed with the default `new` method.
  factory NSURLHandle() => new$();
}

enum NSURLHandleStatus {
  NSURLHandleNotLoaded(0),
  NSURLHandleLoadSucceeded(1),
  NSURLHandleLoadInProgress(2),
  NSURLHandleLoadFailed(3);

  final int value;
  const NSURLHandleStatus(this.value);

  static NSURLHandleStatus fromValue(int value) => switch (value) {
        0 => NSURLHandleNotLoaded,
        1 => NSURLHandleLoadSucceeded,
        2 => NSURLHandleLoadInProgress,
        3 => NSURLHandleLoadFailed,
        _ => throw ArgumentError('Unknown value for NSURLHandleStatus: $value'),
      };
}

/// NSValue
class NSValue extends NSObject implements NSCopying, NSSecureCoding {
  NSValue._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [NSValue] that points to the same underlying object as [other].
  NSValue.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [NSValue] that wraps the given raw object pointer.
  NSValue.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [NSValue].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_NSValue);
  }

  /// alloc
  static NSValue alloc() {
    final _ret = _objc_msgSend_151sglz(_class_NSValue, _sel_alloc);
    return NSValue.castFromPointer(_ret, retain: false, release: true);
  }

  /// allocWithZone:
  static NSValue allocWithZone_(ffi.Pointer<NSZone> zone) {
    final _ret =
        _objc_msgSend_1cwp428(_class_NSValue, _sel_allocWithZone_, zone);
    return NSValue.castFromPointer(_ret, retain: false, release: true);
  }

  /// new
  static NSValue new$() {
    final _ret = _objc_msgSend_151sglz(_class_NSValue, _sel_new);
    return NSValue.castFromPointer(_ret, retain: false, release: true);
  }

  /// supportsSecureCoding
  static bool getSupportsSecureCoding() {
    return _objc_msgSend_91o635(_class_NSValue, _sel_supportsSecureCoding);
  }

  /// encodeWithCoder:
  void encodeWithCoder_(NSCoder coder) {
    _objc_msgSend_xtuoz7(
        this.ref.pointer, _sel_encodeWithCoder_, coder.ref.pointer);
  }

  /// getValue:size:
  void getValue_size_(ffi.Pointer<ffi.Void> value, int size) {
    objc.checkOsVersionInternal('NSValue.getValue:size:',
        iOS: (false, (11, 0, 0)), macOS: (false, (10, 13, 0)));
    _objc_msgSend_zuf90e(this.ref.pointer, _sel_getValue_size_, value, size);
  }

  /// init
  NSValue init() {
    objc.checkOsVersionInternal('NSValue.init',
        iOS: (false, (2, 0, 0)), macOS: (false, (10, 0, 0)));
    final _ret =
        _objc_msgSend_151sglz(this.ref.retainAndReturnPointer(), _sel_init);
    return NSValue.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithBytes:objCType:
  NSValue initWithBytes_objCType_(
      ffi.Pointer<ffi.Void> value, ffi.Pointer<ffi.Char> type) {
    final _ret = _objc_msgSend_e9mncn(this.ref.retainAndReturnPointer(),
        _sel_initWithBytes_objCType_, value, type);
    return NSValue.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithCoder:
  NSValue? initWithCoder_(NSCoder coder) {
    final _ret = _objc_msgSend_1sotr3r(this.ref.retainAndReturnPointer(),
        _sel_initWithCoder_, coder.ref.pointer);
    return _ret.address == 0
        ? null
        : NSValue.castFromPointer(_ret, retain: false, release: true);
  }

  /// objCType
  ffi.Pointer<ffi.Char> get objCType {
    return _objc_msgSend_1fuqfwb(this.ref.pointer, _sel_objCType);
  }

  /// Returns a new instance of NSValue constructed with the default `new` method.
  factory NSValue() => new$();
}

final class NSZone extends ffi.Opaque {}

ffi.Pointer<objc.ObjCObject> _ObjCBlock_NSArray_ffiVoid_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block, ffi.Pointer<ffi.Void> arg0) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.Pointer<objc.ObjCObject> Function(
                    ffi.Pointer<ffi.Void> arg0)>>()
        .asFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<ffi.Void>)>()(arg0);
ffi.Pointer<ffi.Void> _ObjCBlock_NSArray_ffiVoid_fnPtrCallable =
    ffi.Pointer.fromFunction<
                ffi.Pointer<objc.ObjCObject> Function(
                    ffi.Pointer<objc.ObjCBlockImpl>, ffi.Pointer<ffi.Void>)>(
            _ObjCBlock_NSArray_ffiVoid_fnPtrTrampoline)
        .cast();
ffi.Pointer<objc.ObjCObject> _ObjCBlock_NSArray_ffiVoid_closureTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block, ffi.Pointer<ffi.Void> arg0) =>
    (objc.getBlockClosure(block) as ffi.Pointer<objc.ObjCObject> Function(
        ffi.Pointer<ffi.Void>))(arg0);
ffi.Pointer<ffi.Void> _ObjCBlock_NSArray_ffiVoid_closureCallable =
    ffi.Pointer.fromFunction<
                ffi.Pointer<objc.ObjCObject> Function(
                    ffi.Pointer<objc.ObjCBlockImpl>, ffi.Pointer<ffi.Void>)>(
            _ObjCBlock_NSArray_ffiVoid_closureTrampoline)
        .cast();

/// Construction methods for `objc.ObjCBlock<NSArray Function(ffi.Pointer<ffi.Void>)>`.
abstract final class ObjCBlock_NSArray_ffiVoid {
  /// Returns a block that wraps the given raw block pointer.
  static objc.ObjCBlock<NSArray Function(ffi.Pointer<ffi.Void>)>
      castFromPointer(ffi.Pointer<objc.ObjCBlockImpl> pointer,
              {bool retain = false, bool release = false}) =>
          objc.ObjCBlock<NSArray Function(ffi.Pointer<ffi.Void>)>(pointer,
              retain: retain, release: release);

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  static objc.ObjCBlock<NSArray Function(ffi.Pointer<ffi.Void>)> fromFunctionPointer(
          ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Pointer<objc.ObjCObject> Function(
                          ffi.Pointer<ffi.Void> arg0)>>
              ptr) =>
      objc.ObjCBlock<NSArray Function(ffi.Pointer<ffi.Void>)>(
          objc.newPointerBlock(
              _ObjCBlock_NSArray_ffiVoid_fnPtrCallable, ptr.cast()),
          retain: false,
          release: true);

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC.
  static objc.ObjCBlock<NSArray Function(ffi.Pointer<ffi.Void>)> fromFunction(
          NSArray Function(ffi.Pointer<ffi.Void>) fn,
          {bool keepIsolateAlive = true}) =>
      objc.ObjCBlock<NSArray Function(ffi.Pointer<ffi.Void>)>(
          objc.newClosureBlock(
              _ObjCBlock_NSArray_ffiVoid_closureCallable,
              (ffi.Pointer<ffi.Void> arg0) =>
                  fn(arg0).ref.retainAndAutorelease(),
              keepIsolateAlive),
          retain: false,
          release: true);
}

/// Call operator for `objc.ObjCBlock<NSArray Function(ffi.Pointer<ffi.Void>)>`.
extension ObjCBlock_NSArray_ffiVoid_CallExtension
    on objc.ObjCBlock<NSArray Function(ffi.Pointer<ffi.Void>)> {
  NSArray call(ffi.Pointer<ffi.Void> arg0) => NSArray.castFromPointer(
      ref.pointer.ref.invoke
          .cast<
              ffi.NativeFunction<
                  ffi.Pointer<objc.ObjCObject> Function(
                      ffi.Pointer<objc.ObjCBlockImpl> block,
                      ffi.Pointer<ffi.Void> arg0)>>()
          .asFunction<
              ffi.Pointer<objc.ObjCObject> Function(
                  ffi.Pointer<objc.ObjCBlockImpl>,
                  ffi.Pointer<ffi.Void>)>()(ref.pointer, arg0),
      retain: true,
      release: true);
}

int _ObjCBlock_NSItemProviderRepresentationVisibility_ffiVoid_NSString_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block,
        ffi.Pointer<ffi.Void> arg0,
        ffi.Pointer<objc.ObjCObject> arg1) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.Long Function(ffi.Pointer<ffi.Void> arg0,
                    ffi.Pointer<objc.ObjCObject> arg1)>>()
        .asFunction<
            int Function(ffi.Pointer<ffi.Void>,
                ffi.Pointer<objc.ObjCObject>)>()(arg0, arg1);
ffi.Pointer<ffi.Void>
    _ObjCBlock_NSItemProviderRepresentationVisibility_ffiVoid_NSString_fnPtrCallable =
    ffi.Pointer.fromFunction<
                ffi.Long Function(ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>(
            _ObjCBlock_NSItemProviderRepresentationVisibility_ffiVoid_NSString_fnPtrTrampoline,
            0)
        .cast();
int _ObjCBlock_NSItemProviderRepresentationVisibility_ffiVoid_NSString_closureTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block,
        ffi.Pointer<ffi.Void> arg0,
        ffi.Pointer<objc.ObjCObject> arg1) =>
    (objc.getBlockClosure(block) as int Function(
        ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>))(arg0, arg1);
ffi.Pointer<ffi.Void>
    _ObjCBlock_NSItemProviderRepresentationVisibility_ffiVoid_NSString_closureCallable =
    ffi.Pointer.fromFunction<
                ffi.Long Function(ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>(
            _ObjCBlock_NSItemProviderRepresentationVisibility_ffiVoid_NSString_closureTrampoline,
            0)
        .cast();

/// Construction methods for `objc.ObjCBlock<ffi.Long Function(ffi.Pointer<ffi.Void>, NSString)>`.
abstract final class ObjCBlock_NSItemProviderRepresentationVisibility_ffiVoid_NSString {
  /// Returns a block that wraps the given raw block pointer.
  static objc.ObjCBlock<ffi.Long Function(ffi.Pointer<ffi.Void>, NSString)>
      castFromPointer(ffi.Pointer<objc.ObjCBlockImpl> pointer,
              {bool retain = false, bool release = false}) =>
          objc.ObjCBlock<ffi.Long Function(ffi.Pointer<ffi.Void>, NSString)>(
              pointer,
              retain: retain,
              release: release);

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  static objc.ObjCBlock<ffi.Long Function(ffi.Pointer<ffi.Void>, NSString)>
      fromFunctionPointer(
              ffi.Pointer<
                      ffi.NativeFunction<
                          ffi.Long Function(ffi.Pointer<ffi.Void> arg0,
                              ffi.Pointer<objc.ObjCObject> arg1)>>
                  ptr) =>
          objc.ObjCBlock<ffi.Long Function(ffi.Pointer<ffi.Void>, NSString)>(
              objc.newPointerBlock(_ObjCBlock_NSItemProviderRepresentationVisibility_ffiVoid_NSString_fnPtrCallable, ptr.cast()),
              retain: false,
              release: true);

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC.
  static objc.ObjCBlock<ffi.Long Function(ffi.Pointer<ffi.Void>, NSString)> fromFunction(
          NSItemProviderRepresentationVisibility Function(
                  ffi.Pointer<ffi.Void>, NSString)
              fn,
          {bool keepIsolateAlive = true}) =>
      objc.ObjCBlock<ffi.Long Function(ffi.Pointer<ffi.Void>, NSString)>(
          objc.newClosureBlock(
              _ObjCBlock_NSItemProviderRepresentationVisibility_ffiVoid_NSString_closureCallable,
              (ffi.Pointer<ffi.Void> arg0, ffi.Pointer<objc.ObjCObject> arg1) =>
                  fn(arg0, NSString.castFromPointer(arg1, retain: true, release: true)).value,
              keepIsolateAlive),
          retain: false,
          release: true);
}

/// Call operator for `objc.ObjCBlock<ffi.Long Function(ffi.Pointer<ffi.Void>, NSString)>`.
extension ObjCBlock_NSItemProviderRepresentationVisibility_ffiVoid_NSString_CallExtension
    on objc.ObjCBlock<ffi.Long Function(ffi.Pointer<ffi.Void>, NSString)> {
  NSItemProviderRepresentationVisibility call(
          ffi.Pointer<ffi.Void> arg0, NSString arg1) =>
      NSItemProviderRepresentationVisibility.fromValue(ref.pointer.ref.invoke
              .cast<
                  ffi.NativeFunction<
                      ffi.Long Function(
                          ffi.Pointer<objc.ObjCBlockImpl> block,
                          ffi.Pointer<ffi.Void> arg0,
                          ffi.Pointer<objc.ObjCObject> arg1)>>()
              .asFunction<
                  int Function(ffi.Pointer<objc.ObjCBlockImpl>,
                      ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>()(
          ref.pointer, arg0, arg1.ref.pointer));
}

ffi.Pointer<objc.ObjCObject> _ObjCBlock_NSString_ffiVoid_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block, ffi.Pointer<ffi.Void> arg0) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.Pointer<objc.ObjCObject> Function(
                    ffi.Pointer<ffi.Void> arg0)>>()
        .asFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<ffi.Void>)>()(arg0);
ffi.Pointer<ffi.Void> _ObjCBlock_NSString_ffiVoid_fnPtrCallable =
    ffi.Pointer.fromFunction<
                ffi.Pointer<objc.ObjCObject> Function(
                    ffi.Pointer<objc.ObjCBlockImpl>, ffi.Pointer<ffi.Void>)>(
            _ObjCBlock_NSString_ffiVoid_fnPtrTrampoline)
        .cast();
ffi.Pointer<objc.ObjCObject> _ObjCBlock_NSString_ffiVoid_closureTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block, ffi.Pointer<ffi.Void> arg0) =>
    (objc.getBlockClosure(block) as ffi.Pointer<objc.ObjCObject> Function(
        ffi.Pointer<ffi.Void>))(arg0);
ffi.Pointer<ffi.Void> _ObjCBlock_NSString_ffiVoid_closureCallable =
    ffi.Pointer.fromFunction<
                ffi.Pointer<objc.ObjCObject> Function(
                    ffi.Pointer<objc.ObjCBlockImpl>, ffi.Pointer<ffi.Void>)>(
            _ObjCBlock_NSString_ffiVoid_closureTrampoline)
        .cast();

/// Construction methods for `objc.ObjCBlock<NSString Function(ffi.Pointer<ffi.Void>)>`.
abstract final class ObjCBlock_NSString_ffiVoid {
  /// Returns a block that wraps the given raw block pointer.
  static objc.ObjCBlock<NSString Function(ffi.Pointer<ffi.Void>)>
      castFromPointer(ffi.Pointer<objc.ObjCBlockImpl> pointer,
              {bool retain = false, bool release = false}) =>
          objc.ObjCBlock<NSString Function(ffi.Pointer<ffi.Void>)>(pointer,
              retain: retain, release: release);

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  static objc.ObjCBlock<NSString Function(ffi.Pointer<ffi.Void>)> fromFunctionPointer(
          ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Pointer<objc.ObjCObject> Function(
                          ffi.Pointer<ffi.Void> arg0)>>
              ptr) =>
      objc.ObjCBlock<NSString Function(ffi.Pointer<ffi.Void>)>(
          objc.newPointerBlock(
              _ObjCBlock_NSString_ffiVoid_fnPtrCallable, ptr.cast()),
          retain: false,
          release: true);

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC.
  static objc.ObjCBlock<NSString Function(ffi.Pointer<ffi.Void>)> fromFunction(
          NSString Function(ffi.Pointer<ffi.Void>) fn,
          {bool keepIsolateAlive = true}) =>
      objc.ObjCBlock<NSString Function(ffi.Pointer<ffi.Void>)>(
          objc.newClosureBlock(
              _ObjCBlock_NSString_ffiVoid_closureCallable,
              (ffi.Pointer<ffi.Void> arg0) =>
                  fn(arg0).ref.retainAndAutorelease(),
              keepIsolateAlive),
          retain: false,
          release: true);
}

/// Call operator for `objc.ObjCBlock<NSString Function(ffi.Pointer<ffi.Void>)>`.
extension ObjCBlock_NSString_ffiVoid_CallExtension
    on objc.ObjCBlock<NSString Function(ffi.Pointer<ffi.Void>)> {
  NSString call(ffi.Pointer<ffi.Void> arg0) => NSString.castFromPointer(
      ref.pointer.ref.invoke
          .cast<
              ffi.NativeFunction<
                  ffi.Pointer<objc.ObjCObject> Function(
                      ffi.Pointer<objc.ObjCBlockImpl> block,
                      ffi.Pointer<ffi.Void> arg0)>>()
          .asFunction<
              ffi.Pointer<objc.ObjCObject> Function(
                  ffi.Pointer<objc.ObjCBlockImpl>,
                  ffi.Pointer<ffi.Void>)>()(ref.pointer, arg0),
      retain: true,
      release: true);
}

int _ObjCBlock_NSUInteger_ffiVoid_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block, ffi.Pointer<ffi.Void> arg0) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.UnsignedLong Function(ffi.Pointer<ffi.Void> arg0)>>()
        .asFunction<int Function(ffi.Pointer<ffi.Void>)>()(arg0);
ffi.Pointer<ffi.Void> _ObjCBlock_NSUInteger_ffiVoid_fnPtrCallable =
    ffi.Pointer.fromFunction<
                ffi.UnsignedLong Function(
                    ffi.Pointer<objc.ObjCBlockImpl>, ffi.Pointer<ffi.Void>)>(
            _ObjCBlock_NSUInteger_ffiVoid_fnPtrTrampoline, 0)
        .cast();
int _ObjCBlock_NSUInteger_ffiVoid_closureTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block, ffi.Pointer<ffi.Void> arg0) =>
    (objc.getBlockClosure(block) as int Function(ffi.Pointer<ffi.Void>))(arg0);
ffi.Pointer<ffi.Void> _ObjCBlock_NSUInteger_ffiVoid_closureCallable =
    ffi.Pointer.fromFunction<
                ffi.UnsignedLong Function(
                    ffi.Pointer<objc.ObjCBlockImpl>, ffi.Pointer<ffi.Void>)>(
            _ObjCBlock_NSUInteger_ffiVoid_closureTrampoline, 0)
        .cast();

/// Construction methods for `objc.ObjCBlock<ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>)>`.
abstract final class ObjCBlock_NSUInteger_ffiVoid {
  /// Returns a block that wraps the given raw block pointer.
  static objc.ObjCBlock<ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>)>
      castFromPointer(ffi.Pointer<objc.ObjCBlockImpl> pointer,
              {bool retain = false, bool release = false}) =>
          objc.ObjCBlock<ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>)>(
              pointer,
              retain: retain,
              release: release);

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  static objc.ObjCBlock<ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>)>
      fromFunctionPointer(
              ffi.Pointer<
                      ffi.NativeFunction<
                          ffi.UnsignedLong Function(
                              ffi.Pointer<ffi.Void> arg0)>>
                  ptr) =>
          objc.ObjCBlock<ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>)>(
              objc.newPointerBlock(_ObjCBlock_NSUInteger_ffiVoid_fnPtrCallable, ptr.cast()),
              retain: false,
              release: true);

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC.
  static objc.ObjCBlock<ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>)>
      fromFunction(int Function(ffi.Pointer<ffi.Void>) fn,
              {bool keepIsolateAlive = true}) =>
          objc.ObjCBlock<ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>)>(
              objc.newClosureBlock(
                  _ObjCBlock_NSUInteger_ffiVoid_closureCallable,
                  (ffi.Pointer<ffi.Void> arg0) => fn(arg0),
                  keepIsolateAlive),
              retain: false,
              release: true);
}

/// Call operator for `objc.ObjCBlock<ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>)>`.
extension ObjCBlock_NSUInteger_ffiVoid_CallExtension
    on objc.ObjCBlock<ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>)> {
  int call(ffi.Pointer<ffi.Void> arg0) => ref.pointer.ref.invoke
      .cast<
          ffi.NativeFunction<
              ffi.UnsignedLong Function(ffi.Pointer<objc.ObjCBlockImpl> block,
                  ffi.Pointer<ffi.Void> arg0)>>()
      .asFunction<
          int Function(ffi.Pointer<objc.ObjCBlockImpl>,
              ffi.Pointer<ffi.Void>)>()(ref.pointer, arg0);
}

int _ObjCBlock_NSUInteger_ffiVoid_NSFastEnumerationState_objcObjCObject_NSUInteger_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block,
        ffi.Pointer<ffi.Void> arg0,
        ffi.Pointer<NSFastEnumerationState> arg1,
        ffi.Pointer<ffi.Pointer<objc.ObjCObject>> arg2,
        int arg3) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.UnsignedLong Function(
                    ffi.Pointer<ffi.Void> arg0,
                    ffi.Pointer<NSFastEnumerationState> arg1,
                    ffi.Pointer<ffi.Pointer<objc.ObjCObject>> arg2,
                    ffi.UnsignedLong arg3)>>()
        .asFunction<
            int Function(
                ffi.Pointer<ffi.Void>,
                ffi.Pointer<NSFastEnumerationState>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                int)>()(arg0, arg1, arg2, arg3);
ffi.Pointer<ffi.Void>
    _ObjCBlock_NSUInteger_ffiVoid_NSFastEnumerationState_objcObjCObject_NSUInteger_fnPtrCallable =
    ffi.Pointer.fromFunction<
                ffi.UnsignedLong Function(
                    ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<ffi.Void>,
                    ffi.Pointer<NSFastEnumerationState>,
                    ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                    ffi.UnsignedLong)>(
            _ObjCBlock_NSUInteger_ffiVoid_NSFastEnumerationState_objcObjCObject_NSUInteger_fnPtrTrampoline,
            0)
        .cast();
int _ObjCBlock_NSUInteger_ffiVoid_NSFastEnumerationState_objcObjCObject_NSUInteger_closureTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block,
        ffi.Pointer<ffi.Void> arg0,
        ffi.Pointer<NSFastEnumerationState> arg1,
        ffi.Pointer<ffi.Pointer<objc.ObjCObject>> arg2,
        int arg3) =>
    (objc.getBlockClosure(block) as int Function(
        ffi.Pointer<ffi.Void>,
        ffi.Pointer<NSFastEnumerationState>,
        ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
        int))(arg0, arg1, arg2, arg3);
ffi.Pointer<ffi.Void>
    _ObjCBlock_NSUInteger_ffiVoid_NSFastEnumerationState_objcObjCObject_NSUInteger_closureCallable =
    ffi.Pointer.fromFunction<
                ffi.UnsignedLong Function(
                    ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<ffi.Void>,
                    ffi.Pointer<NSFastEnumerationState>,
                    ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                    ffi.UnsignedLong)>(
            _ObjCBlock_NSUInteger_ffiVoid_NSFastEnumerationState_objcObjCObject_NSUInteger_closureTrampoline,
            0)
        .cast();

/// Construction methods for `objc.ObjCBlock<ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>, ffi.Pointer<NSFastEnumerationState>, ffi.Pointer<ffi.Pointer<objc.ObjCObject>>, ffi.UnsignedLong)>`.
abstract final class ObjCBlock_NSUInteger_ffiVoid_NSFastEnumerationState_objcObjCObject_NSUInteger {
  /// Returns a block that wraps the given raw block pointer.
  static objc.ObjCBlock<
          ffi.UnsignedLong Function(
              ffi.Pointer<ffi.Void>,
              ffi.Pointer<NSFastEnumerationState>,
              ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
              ffi.UnsignedLong)>
      castFromPointer(ffi.Pointer<objc.ObjCBlockImpl> pointer,
              {bool retain = false, bool release = false}) =>
          objc.ObjCBlock<
              ffi.UnsignedLong Function(
                  ffi.Pointer<ffi.Void>,
                  ffi.Pointer<NSFastEnumerationState>,
                  ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                  ffi.UnsignedLong)>(pointer, retain: retain, release: release);

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  static objc.ObjCBlock<
          ffi.UnsignedLong Function(
              ffi.Pointer<ffi.Void>,
              ffi.Pointer<NSFastEnumerationState>,
              ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
              ffi.UnsignedLong)>
      fromFunctionPointer(ffi.Pointer<ffi.NativeFunction<ffi.UnsignedLong Function(ffi.Pointer<ffi.Void> arg0, ffi.Pointer<NSFastEnumerationState> arg1, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> arg2, ffi.UnsignedLong arg3)>> ptr) =>
          objc.ObjCBlock<
                  ffi.UnsignedLong Function(
                      ffi.Pointer<ffi.Void>,
                      ffi.Pointer<NSFastEnumerationState>,
                      ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                      ffi.UnsignedLong)>(
              objc.newPointerBlock(_ObjCBlock_NSUInteger_ffiVoid_NSFastEnumerationState_objcObjCObject_NSUInteger_fnPtrCallable, ptr.cast()),
              retain: false,
              release: true);

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC.
  static objc
      .ObjCBlock<ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>, ffi.Pointer<NSFastEnumerationState>, ffi.Pointer<ffi.Pointer<objc.ObjCObject>>, ffi.UnsignedLong)>
      fromFunction(int Function(ffi.Pointer<ffi.Void>, ffi.Pointer<NSFastEnumerationState>, ffi.Pointer<ffi.Pointer<objc.ObjCObject>>, int) fn,
              {bool keepIsolateAlive = true}) =>
          objc.ObjCBlock<ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>, ffi.Pointer<NSFastEnumerationState>, ffi.Pointer<ffi.Pointer<objc.ObjCObject>>, ffi.UnsignedLong)>(
              objc.newClosureBlock(
                  _ObjCBlock_NSUInteger_ffiVoid_NSFastEnumerationState_objcObjCObject_NSUInteger_closureCallable,
                  (ffi.Pointer<ffi.Void> arg0,
                          ffi.Pointer<NSFastEnumerationState> arg1,
                          ffi.Pointer<ffi.Pointer<objc.ObjCObject>> arg2,
                          int arg3) =>
                      fn(arg0, arg1, arg2, arg3),
                  keepIsolateAlive),
              retain: false,
              release: true);
}

/// Call operator for `objc.ObjCBlock<ffi.UnsignedLong Function(ffi.Pointer<ffi.Void>, ffi.Pointer<NSFastEnumerationState>, ffi.Pointer<ffi.Pointer<objc.ObjCObject>>, ffi.UnsignedLong)>`.
extension ObjCBlock_NSUInteger_ffiVoid_NSFastEnumerationState_objcObjCObject_NSUInteger_CallExtension
    on objc.ObjCBlock<
        ffi.UnsignedLong Function(
            ffi.Pointer<ffi.Void>,
            ffi.Pointer<NSFastEnumerationState>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            ffi.UnsignedLong)> {
  int call(ffi.Pointer<ffi.Void> arg0, ffi.Pointer<NSFastEnumerationState> arg1,
          ffi.Pointer<ffi.Pointer<objc.ObjCObject>> arg2, int arg3) =>
      ref.pointer.ref.invoke
          .cast<
              ffi.NativeFunction<
                  ffi.UnsignedLong Function(
                      ffi.Pointer<objc.ObjCBlockImpl> block,
                      ffi.Pointer<ffi.Void> arg0,
                      ffi.Pointer<NSFastEnumerationState> arg1,
                      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> arg2,
                      ffi.UnsignedLong arg3)>>()
          .asFunction<
              int Function(
                  ffi.Pointer<objc.ObjCBlockImpl>,
                  ffi.Pointer<ffi.Void>,
                  ffi.Pointer<NSFastEnumerationState>,
                  ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                  int)>()(ref.pointer, arg0, arg1, arg2, arg3);
}

ffi.Pointer<NSZone> _ObjCBlock_NSZone_ffiVoid_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block, ffi.Pointer<ffi.Void> arg0) =>
    block.ref.target
            .cast<
                ffi.NativeFunction<
                    ffi.Pointer<NSZone> Function(ffi.Pointer<ffi.Void> arg0)>>()
            .asFunction<ffi.Pointer<NSZone> Function(ffi.Pointer<ffi.Void>)>()(
        arg0);
ffi.Pointer<ffi.Void> _ObjCBlock_NSZone_ffiVoid_fnPtrCallable =
    ffi.Pointer.fromFunction<
                ffi.Pointer<NSZone> Function(
                    ffi.Pointer<objc.ObjCBlockImpl>, ffi.Pointer<ffi.Void>)>(
            _ObjCBlock_NSZone_ffiVoid_fnPtrTrampoline)
        .cast();
ffi.Pointer<NSZone> _ObjCBlock_NSZone_ffiVoid_closureTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block, ffi.Pointer<ffi.Void> arg0) =>
    (objc.getBlockClosure(block) as ffi.Pointer<NSZone> Function(
        ffi.Pointer<ffi.Void>))(arg0);
ffi.Pointer<ffi.Void> _ObjCBlock_NSZone_ffiVoid_closureCallable =
    ffi.Pointer.fromFunction<
                ffi.Pointer<NSZone> Function(
                    ffi.Pointer<objc.ObjCBlockImpl>, ffi.Pointer<ffi.Void>)>(
            _ObjCBlock_NSZone_ffiVoid_closureTrampoline)
        .cast();

/// Construction methods for `objc.ObjCBlock<ffi.Pointer<NSZone> Function(ffi.Pointer<ffi.Void>)>`.
abstract final class ObjCBlock_NSZone_ffiVoid {
  /// Returns a block that wraps the given raw block pointer.
  static objc.ObjCBlock<ffi.Pointer<NSZone> Function(ffi.Pointer<ffi.Void>)>
      castFromPointer(ffi.Pointer<objc.ObjCBlockImpl> pointer,
              {bool retain = false, bool release = false}) =>
          objc.ObjCBlock<ffi.Pointer<NSZone> Function(ffi.Pointer<ffi.Void>)>(
              pointer,
              retain: retain,
              release: release);

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  static objc.ObjCBlock<ffi.Pointer<NSZone> Function(ffi.Pointer<ffi.Void>)>
      fromFunctionPointer(
              ffi.Pointer<
                      ffi.NativeFunction<
                          ffi.Pointer<NSZone> Function(
                              ffi.Pointer<ffi.Void> arg0)>>
                  ptr) =>
          objc.ObjCBlock<ffi.Pointer<NSZone> Function(ffi.Pointer<ffi.Void>)>(
              objc.newPointerBlock(_ObjCBlock_NSZone_ffiVoid_fnPtrCallable, ptr.cast()),
              retain: false,
              release: true);

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC.
  static objc.ObjCBlock<ffi.Pointer<NSZone> Function(ffi.Pointer<ffi.Void>)>
      fromFunction(ffi.Pointer<NSZone> Function(ffi.Pointer<ffi.Void>) fn,
              {bool keepIsolateAlive = true}) =>
          objc.ObjCBlock<ffi.Pointer<NSZone> Function(ffi.Pointer<ffi.Void>)>(
              objc.newClosureBlock(_ObjCBlock_NSZone_ffiVoid_closureCallable,
                  (ffi.Pointer<ffi.Void> arg0) => fn(arg0), keepIsolateAlive),
              retain: false,
              release: true);
}

/// Call operator for `objc.ObjCBlock<ffi.Pointer<NSZone> Function(ffi.Pointer<ffi.Void>)>`.
extension ObjCBlock_NSZone_ffiVoid_CallExtension
    on objc.ObjCBlock<ffi.Pointer<NSZone> Function(ffi.Pointer<ffi.Void>)> {
  ffi.Pointer<NSZone> call(ffi.Pointer<ffi.Void> arg0) => ref.pointer.ref.invoke
      .cast<
          ffi.NativeFunction<
              ffi.Pointer<NSZone> Function(
                  ffi.Pointer<objc.ObjCBlockImpl> block,
                  ffi.Pointer<ffi.Void> arg0)>>()
      .asFunction<
          ffi.Pointer<NSZone> Function(ffi.Pointer<objc.ObjCBlockImpl>,
              ffi.Pointer<ffi.Void>)>()(ref.pointer, arg0);
}

bool _ObjCBlock_bool_ffiVoid_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block, ffi.Pointer<ffi.Void> arg0) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<ffi.Bool Function(ffi.Pointer<ffi.Void> arg0)>>()
        .asFunction<bool Function(ffi.Pointer<ffi.Void>)>()(arg0);
ffi.Pointer<ffi.Void> _ObjCBlock_bool_ffiVoid_fnPtrCallable =
    ffi.Pointer.fromFunction<
                ffi.Bool Function(
                    ffi.Pointer<objc.ObjCBlockImpl>, ffi.Pointer<ffi.Void>)>(
            _ObjCBlock_bool_ffiVoid_fnPtrTrampoline, false)
        .cast();
bool _ObjCBlock_bool_ffiVoid_closureTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block, ffi.Pointer<ffi.Void> arg0) =>
    (objc.getBlockClosure(block) as bool Function(ffi.Pointer<ffi.Void>))(arg0);
ffi.Pointer<ffi.Void> _ObjCBlock_bool_ffiVoid_closureCallable =
    ffi.Pointer.fromFunction<
                ffi.Bool Function(
                    ffi.Pointer<objc.ObjCBlockImpl>, ffi.Pointer<ffi.Void>)>(
            _ObjCBlock_bool_ffiVoid_closureTrampoline, false)
        .cast();

/// Construction methods for `objc.ObjCBlock<ffi.Bool Function(ffi.Pointer<ffi.Void>)>`.
abstract final class ObjCBlock_bool_ffiVoid {
  /// Returns a block that wraps the given raw block pointer.
  static objc.ObjCBlock<ffi.Bool Function(ffi.Pointer<ffi.Void>)>
      castFromPointer(ffi.Pointer<objc.ObjCBlockImpl> pointer,
              {bool retain = false, bool release = false}) =>
          objc.ObjCBlock<ffi.Bool Function(ffi.Pointer<ffi.Void>)>(pointer,
              retain: retain, release: release);

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  static objc.ObjCBlock<ffi.Bool Function(ffi.Pointer<ffi.Void>)>
      fromFunctionPointer(
              ffi.Pointer<
                      ffi.NativeFunction<
                          ffi.Bool Function(ffi.Pointer<ffi.Void> arg0)>>
                  ptr) =>
          objc.ObjCBlock<ffi.Bool Function(ffi.Pointer<ffi.Void>)>(
              objc.newPointerBlock(_ObjCBlock_bool_ffiVoid_fnPtrCallable, ptr.cast()),
              retain: false,
              release: true);

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC.
  static objc.ObjCBlock<ffi.Bool Function(ffi.Pointer<ffi.Void>)> fromFunction(
          bool Function(ffi.Pointer<ffi.Void>) fn,
          {bool keepIsolateAlive = true}) =>
      objc.ObjCBlock<ffi.Bool Function(ffi.Pointer<ffi.Void>)>(
          objc.newClosureBlock(_ObjCBlock_bool_ffiVoid_closureCallable,
              (ffi.Pointer<ffi.Void> arg0) => fn(arg0), keepIsolateAlive),
          retain: false,
          release: true);
}

/// Call operator for `objc.ObjCBlock<ffi.Bool Function(ffi.Pointer<ffi.Void>)>`.
extension ObjCBlock_bool_ffiVoid_CallExtension
    on objc.ObjCBlock<ffi.Bool Function(ffi.Pointer<ffi.Void>)> {
  bool call(ffi.Pointer<ffi.Void> arg0) => ref.pointer.ref.invoke
      .cast<
          ffi.NativeFunction<
              ffi.Bool Function(ffi.Pointer<objc.ObjCBlockImpl> block,
                  ffi.Pointer<ffi.Void> arg0)>>()
      .asFunction<
          bool Function(ffi.Pointer<objc.ObjCBlockImpl>,
              ffi.Pointer<ffi.Void>)>()(ref.pointer, arg0);
}

bool _ObjCBlock_bool_ffiVoid_Protocol_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block,
        ffi.Pointer<ffi.Void> arg0,
        ffi.Pointer<objc.ObjCObject> arg1) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.Bool Function(ffi.Pointer<ffi.Void> arg0,
                    ffi.Pointer<objc.ObjCObject> arg1)>>()
        .asFunction<
            bool Function(ffi.Pointer<ffi.Void>,
                ffi.Pointer<objc.ObjCObject>)>()(arg0, arg1);
ffi.Pointer<ffi.Void> _ObjCBlock_bool_ffiVoid_Protocol_fnPtrCallable =
    ffi.Pointer.fromFunction<
                ffi.Bool Function(ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>(
            _ObjCBlock_bool_ffiVoid_Protocol_fnPtrTrampoline, false)
        .cast();
bool _ObjCBlock_bool_ffiVoid_Protocol_closureTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block,
        ffi.Pointer<ffi.Void> arg0,
        ffi.Pointer<objc.ObjCObject> arg1) =>
    (objc.getBlockClosure(block) as bool Function(
        ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>))(arg0, arg1);
ffi.Pointer<ffi.Void> _ObjCBlock_bool_ffiVoid_Protocol_closureCallable =
    ffi.Pointer.fromFunction<
                ffi.Bool Function(ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>(
            _ObjCBlock_bool_ffiVoid_Protocol_closureTrampoline, false)
        .cast();

/// Construction methods for `objc.ObjCBlock<ffi.Bool Function(ffi.Pointer<ffi.Void>, Protocol)>`.
abstract final class ObjCBlock_bool_ffiVoid_Protocol {
  /// Returns a block that wraps the given raw block pointer.
  static objc.ObjCBlock<ffi.Bool Function(ffi.Pointer<ffi.Void>, Protocol)>
      castFromPointer(ffi.Pointer<objc.ObjCBlockImpl> pointer,
              {bool retain = false, bool release = false}) =>
          objc.ObjCBlock<ffi.Bool Function(ffi.Pointer<ffi.Void>, Protocol)>(
              pointer,
              retain: retain,
              release: release);

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  static objc.ObjCBlock<ffi.Bool Function(ffi.Pointer<ffi.Void>, Protocol)>
      fromFunctionPointer(
              ffi.Pointer<
                      ffi.NativeFunction<
                          ffi.Bool Function(ffi.Pointer<ffi.Void> arg0,
                              ffi.Pointer<objc.ObjCObject> arg1)>>
                  ptr) =>
          objc.ObjCBlock<ffi.Bool Function(ffi.Pointer<ffi.Void>, Protocol)>(
              objc.newPointerBlock(_ObjCBlock_bool_ffiVoid_Protocol_fnPtrCallable, ptr.cast()),
              retain: false,
              release: true);

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC.
  static objc.ObjCBlock<
      ffi.Bool Function(ffi.Pointer<ffi.Void>, Protocol)> fromFunction(
          bool Function(ffi.Pointer<ffi.Void>, Protocol) fn,
          {bool keepIsolateAlive = true}) =>
      objc.ObjCBlock<ffi.Bool Function(ffi.Pointer<ffi.Void>, Protocol)>(
          objc.newClosureBlock(
              _ObjCBlock_bool_ffiVoid_Protocol_closureCallable,
              (ffi.Pointer<ffi.Void> arg0, ffi.Pointer<objc.ObjCObject> arg1) =>
                  fn(arg0, Protocol.castFromPointer(arg1, retain: true, release: true)),
              keepIsolateAlive),
          retain: false,
          release: true);
}

/// Call operator for `objc.ObjCBlock<ffi.Bool Function(ffi.Pointer<ffi.Void>, Protocol)>`.
extension ObjCBlock_bool_ffiVoid_Protocol_CallExtension
    on objc.ObjCBlock<ffi.Bool Function(ffi.Pointer<ffi.Void>, Protocol)> {
  bool call(ffi.Pointer<ffi.Void> arg0, Protocol arg1) => ref.pointer.ref.invoke
          .cast<
              ffi.NativeFunction<
                  ffi.Bool Function(
                      ffi.Pointer<objc.ObjCBlockImpl> block,
                      ffi.Pointer<ffi.Void> arg0,
                      ffi.Pointer<objc.ObjCObject> arg1)>>()
          .asFunction<
              bool Function(ffi.Pointer<objc.ObjCBlockImpl>,
                  ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>()(
      ref.pointer, arg0, arg1.ref.pointer);
}

bool _ObjCBlock_bool_ffiVoid_objcObjCObject_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block,
        ffi.Pointer<ffi.Void> arg0,
        ffi.Pointer<objc.ObjCObject> arg1) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.Bool Function(ffi.Pointer<ffi.Void> arg0,
                    ffi.Pointer<objc.ObjCObject> arg1)>>()
        .asFunction<
            bool Function(ffi.Pointer<ffi.Void>,
                ffi.Pointer<objc.ObjCObject>)>()(arg0, arg1);
ffi.Pointer<ffi.Void> _ObjCBlock_bool_ffiVoid_objcObjCObject_fnPtrCallable =
    ffi.Pointer.fromFunction<
                ffi.Bool Function(ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>(
            _ObjCBlock_bool_ffiVoid_objcObjCObject_fnPtrTrampoline, false)
        .cast();
bool _ObjCBlock_bool_ffiVoid_objcObjCObject_closureTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block,
        ffi.Pointer<ffi.Void> arg0,
        ffi.Pointer<objc.ObjCObject> arg1) =>
    (objc.getBlockClosure(block) as bool Function(
        ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>))(arg0, arg1);
ffi.Pointer<ffi.Void> _ObjCBlock_bool_ffiVoid_objcObjCObject_closureCallable =
    ffi.Pointer.fromFunction<
                ffi.Bool Function(ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>(
            _ObjCBlock_bool_ffiVoid_objcObjCObject_closureTrampoline, false)
        .cast();

/// Construction methods for `objc.ObjCBlock<ffi.Bool Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>`.
abstract final class ObjCBlock_bool_ffiVoid_objcObjCObject {
  /// Returns a block that wraps the given raw block pointer.
  static objc.ObjCBlock<
          ffi.Bool Function(
              ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>
      castFromPointer(ffi.Pointer<objc.ObjCBlockImpl> pointer,
              {bool retain = false, bool release = false}) =>
          objc.ObjCBlock<
                  ffi.Bool Function(
                      ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>(
              pointer,
              retain: retain,
              release: release);

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  static objc.ObjCBlock<ffi.Bool Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)> fromFunctionPointer(
          ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Bool Function(ffi.Pointer<ffi.Void> arg0,
                          ffi.Pointer<objc.ObjCObject> arg1)>>
              ptr) =>
      objc.ObjCBlock<ffi.Bool Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>(
          objc.newPointerBlock(_ObjCBlock_bool_ffiVoid_objcObjCObject_fnPtrCallable, ptr.cast()),
          retain: false,
          release: true);

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC.
  static objc.ObjCBlock<
      ffi.Bool Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)> fromFunction(
          bool Function(ffi.Pointer<ffi.Void>, objc.ObjCObjectBase) fn,
          {bool keepIsolateAlive = true}) =>
      objc.ObjCBlock<ffi.Bool Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>(
          objc.newClosureBlock(
              _ObjCBlock_bool_ffiVoid_objcObjCObject_closureCallable,
              (ffi.Pointer<ffi.Void> arg0, ffi.Pointer<objc.ObjCObject> arg1) =>
                  fn(arg0, objc.ObjCObjectBase(arg1, retain: true, release: true)),
              keepIsolateAlive),
          retain: false,
          release: true);
}

/// Call operator for `objc.ObjCBlock<ffi.Bool Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>`.
extension ObjCBlock_bool_ffiVoid_objcObjCObject_CallExtension on objc.ObjCBlock<
    ffi.Bool Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)> {
  bool call(ffi.Pointer<ffi.Void> arg0, objc.ObjCObjectBase arg1) =>
      ref.pointer.ref.invoke
              .cast<
                  ffi.NativeFunction<
                      ffi.Bool Function(
                          ffi.Pointer<objc.ObjCBlockImpl> block,
                          ffi.Pointer<ffi.Void> arg0,
                          ffi.Pointer<objc.ObjCObject> arg1)>>()
              .asFunction<
                  bool Function(ffi.Pointer<objc.ObjCBlockImpl>,
                      ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>()(
          ref.pointer, arg0, arg1.ref.pointer);
}

bool _ObjCBlock_bool_ffiVoid_objcObjCSelector_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block,
        ffi.Pointer<ffi.Void> arg0,
        ffi.Pointer<objc.ObjCSelector> arg1) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.Bool Function(ffi.Pointer<ffi.Void> arg0,
                    ffi.Pointer<objc.ObjCSelector> arg1)>>()
        .asFunction<
            bool Function(ffi.Pointer<ffi.Void>,
                ffi.Pointer<objc.ObjCSelector>)>()(arg0, arg1);
ffi.Pointer<ffi.Void> _ObjCBlock_bool_ffiVoid_objcObjCSelector_fnPtrCallable =
    ffi.Pointer.fromFunction<
                ffi.Bool Function(ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>)>(
            _ObjCBlock_bool_ffiVoid_objcObjCSelector_fnPtrTrampoline, false)
        .cast();
bool _ObjCBlock_bool_ffiVoid_objcObjCSelector_closureTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block,
        ffi.Pointer<ffi.Void> arg0,
        ffi.Pointer<objc.ObjCSelector> arg1) =>
    (objc.getBlockClosure(block) as bool Function(
        ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>))(arg0, arg1);
ffi.Pointer<ffi.Void> _ObjCBlock_bool_ffiVoid_objcObjCSelector_closureCallable =
    ffi.Pointer.fromFunction<
                ffi.Bool Function(ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>)>(
            _ObjCBlock_bool_ffiVoid_objcObjCSelector_closureTrampoline, false)
        .cast();

/// Construction methods for `objc.ObjCBlock<ffi.Bool Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>)>`.
abstract final class ObjCBlock_bool_ffiVoid_objcObjCSelector {
  /// Returns a block that wraps the given raw block pointer.
  static objc.ObjCBlock<
          ffi.Bool Function(
              ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>)>
      castFromPointer(ffi.Pointer<objc.ObjCBlockImpl> pointer,
              {bool retain = false, bool release = false}) =>
          objc.ObjCBlock<
                  ffi.Bool Function(
                      ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>)>(
              pointer,
              retain: retain,
              release: release);

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  static objc.ObjCBlock<ffi.Bool Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>)> fromFunctionPointer(
          ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Bool Function(ffi.Pointer<ffi.Void> arg0,
                          ffi.Pointer<objc.ObjCSelector> arg1)>>
              ptr) =>
      objc.ObjCBlock<ffi.Bool Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>)>(
          objc.newPointerBlock(_ObjCBlock_bool_ffiVoid_objcObjCSelector_fnPtrCallable, ptr.cast()),
          retain: false,
          release: true);

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC.
  static objc.ObjCBlock<
          ffi.Bool Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>)>
      fromFunction(bool Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>) fn,
              {bool keepIsolateAlive = true}) =>
          objc.ObjCBlock<ffi.Bool Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>)>(
              objc.newClosureBlock(
                  _ObjCBlock_bool_ffiVoid_objcObjCSelector_closureCallable,
                  (ffi.Pointer<ffi.Void> arg0, ffi.Pointer<objc.ObjCSelector> arg1) =>
                      fn(arg0, arg1),
                  keepIsolateAlive),
              retain: false,
              release: true);
}

/// Call operator for `objc.ObjCBlock<ffi.Bool Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>)>`.
extension ObjCBlock_bool_ffiVoid_objcObjCSelector_CallExtension
    on objc.ObjCBlock<
        ffi.Bool Function(
            ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>)> {
  bool call(ffi.Pointer<ffi.Void> arg0, ffi.Pointer<objc.ObjCSelector> arg1) =>
      ref.pointer.ref.invoke
          .cast<
              ffi.NativeFunction<
                  ffi.Bool Function(
                      ffi.Pointer<objc.ObjCBlockImpl> block,
                      ffi.Pointer<ffi.Void> arg0,
                      ffi.Pointer<objc.ObjCSelector> arg1)>>()
          .asFunction<
              bool Function(
                  ffi.Pointer<objc.ObjCBlockImpl>,
                  ffi.Pointer<ffi.Void>,
                  ffi.Pointer<objc.ObjCSelector>)>()(ref.pointer, arg0, arg1);
}

void
    _ObjCBlock_ffiVoid_NSItemProviderCompletionHandler_objcObjCObject_NSDictionary_fnPtrTrampoline(
            ffi.Pointer<objc.ObjCBlockImpl> block,
            ffi.Pointer<objc.ObjCBlockImpl> arg0,
            ffi.Pointer<objc.ObjCObject> arg1,
            ffi.Pointer<objc.ObjCObject> arg2) =>
        block.ref.target
            .cast<
                ffi.NativeFunction<
                    ffi.Void Function(
                        ffi.Pointer<objc.ObjCBlockImpl> arg0,
                        ffi.Pointer<objc.ObjCObject> arg1,
                        ffi.Pointer<objc.ObjCObject> arg2)>>()
            .asFunction<
                void Function(
                    ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<objc.ObjCObject>,
                    ffi.Pointer<objc.ObjCObject>)>()(arg0, arg1, arg2);
ffi.Pointer<ffi.Void>
    _ObjCBlock_ffiVoid_NSItemProviderCompletionHandler_objcObjCObject_NSDictionary_fnPtrCallable =
    ffi.Pointer.fromFunction<
                ffi.Void Function(
                    ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<objc.ObjCObject>,
                    ffi.Pointer<objc.ObjCObject>)>(
            _ObjCBlock_ffiVoid_NSItemProviderCompletionHandler_objcObjCObject_NSDictionary_fnPtrTrampoline)
        .cast();
void
    _ObjCBlock_ffiVoid_NSItemProviderCompletionHandler_objcObjCObject_NSDictionary_closureTrampoline(
            ffi.Pointer<objc.ObjCBlockImpl> block,
            ffi.Pointer<objc.ObjCBlockImpl> arg0,
            ffi.Pointer<objc.ObjCObject> arg1,
            ffi.Pointer<objc.ObjCObject> arg2) =>
        (objc.getBlockClosure(block) as void Function(
            ffi.Pointer<objc.ObjCBlockImpl>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>))(arg0, arg1, arg2);
ffi.Pointer<ffi.Void>
    _ObjCBlock_ffiVoid_NSItemProviderCompletionHandler_objcObjCObject_NSDictionary_closureCallable =
    ffi.Pointer.fromFunction<
                ffi.Void Function(
                    ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<objc.ObjCObject>,
                    ffi.Pointer<objc.ObjCObject>)>(
            _ObjCBlock_ffiVoid_NSItemProviderCompletionHandler_objcObjCObject_NSDictionary_closureTrampoline)
        .cast();
void
    _ObjCBlock_ffiVoid_NSItemProviderCompletionHandler_objcObjCObject_NSDictionary_listenerTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block,
        ffi.Pointer<objc.ObjCBlockImpl> arg0,
        ffi.Pointer<objc.ObjCObject> arg1,
        ffi.Pointer<objc.ObjCObject> arg2) {
  (objc.getBlockClosure(block) as void Function(
      ffi.Pointer<objc.ObjCBlockImpl>,
      ffi.Pointer<objc.ObjCObject>,
      ffi.Pointer<objc.ObjCObject>))(arg0, arg1, arg2);
  objc.objectRelease(block.cast());
}

ffi.NativeCallable<
        ffi.Void Function(
            ffi.Pointer<objc.ObjCBlockImpl>,
            ffi.Pointer<objc.ObjCBlockImpl>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>
    _ObjCBlock_ffiVoid_NSItemProviderCompletionHandler_objcObjCObject_NSDictionary_listenerCallable =
    ffi.NativeCallable<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCBlockImpl>,
                ffi.Pointer<objc.ObjCBlockImpl>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>.listener(
        _ObjCBlock_ffiVoid_NSItemProviderCompletionHandler_objcObjCObject_NSDictionary_listenerTrampoline)
      ..keepIsolateAlive = false;
void
    _ObjCBlock_ffiVoid_NSItemProviderCompletionHandler_objcObjCObject_NSDictionary_blockingTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block,
        ffi.Pointer<ffi.Void> waiter,
        ffi.Pointer<objc.ObjCBlockImpl> arg0,
        ffi.Pointer<objc.ObjCObject> arg1,
        ffi.Pointer<objc.ObjCObject> arg2) {
  try {
    (objc.getBlockClosure(block) as void Function(
        ffi.Pointer<objc.ObjCBlockImpl>,
        ffi.Pointer<objc.ObjCObject>,
        ffi.Pointer<objc.ObjCObject>))(arg0, arg1, arg2);
  } catch (e) {
  } finally {
    objc.signalWaiter(waiter);
    objc.objectRelease(block.cast());
  }
}

ffi.NativeCallable<
        ffi.Void Function(
            ffi.Pointer<objc.ObjCBlockImpl>,
            ffi.Pointer<ffi.Void>,
            ffi.Pointer<objc.ObjCBlockImpl>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>
    _ObjCBlock_ffiVoid_NSItemProviderCompletionHandler_objcObjCObject_NSDictionary_blockingCallable =
    ffi.NativeCallable<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCBlockImpl>,
                ffi.Pointer<ffi.Void>,
                ffi.Pointer<objc.ObjCBlockImpl>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>.isolateLocal(
        _ObjCBlock_ffiVoid_NSItemProviderCompletionHandler_objcObjCObject_NSDictionary_blockingTrampoline)
      ..keepIsolateAlive = false;
ffi.NativeCallable<
        ffi.Void Function(
            ffi.Pointer<objc.ObjCBlockImpl>,
            ffi.Pointer<ffi.Void>,
            ffi.Pointer<objc.ObjCBlockImpl>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>
    _ObjCBlock_ffiVoid_NSItemProviderCompletionHandler_objcObjCObject_NSDictionary_blockingListenerCallable =
    ffi.NativeCallable<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCBlockImpl>,
                ffi.Pointer<ffi.Void>,
                ffi.Pointer<objc.ObjCBlockImpl>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>.listener(
        _ObjCBlock_ffiVoid_NSItemProviderCompletionHandler_objcObjCObject_NSDictionary_blockingTrampoline)
      ..keepIsolateAlive = false;

/// Construction methods for `objc.ObjCBlock<ffi.Void Function(objc.ObjCBlock<ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)>, ffi.Pointer<objc.ObjCObject>, NSDictionary)>`.
abstract final class ObjCBlock_ffiVoid_NSItemProviderCompletionHandler_objcObjCObject_NSDictionary {
  /// Returns a block that wraps the given raw block pointer.
  static objc.ObjCBlock<
          ffi.Void Function(
              objc.ObjCBlock<
                  ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)>,
              ffi.Pointer<objc.ObjCObject>,
              NSDictionary)>
      castFromPointer(ffi.Pointer<objc.ObjCBlockImpl> pointer, {bool retain = false, bool release = false}) =>
          objc.ObjCBlock<
              ffi.Void Function(
                  objc.ObjCBlock<ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)>,
                  ffi.Pointer<objc.ObjCObject>,
                  NSDictionary)>(pointer, retain: retain, release: release);

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  static objc.ObjCBlock<
          ffi.Void Function(
              objc.ObjCBlock<
                  ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)>,
              ffi.Pointer<objc.ObjCObject>,
              NSDictionary)>
      fromFunctionPointer(ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<objc.ObjCBlockImpl> arg0, ffi.Pointer<objc.ObjCObject> arg1, ffi.Pointer<objc.ObjCObject> arg2)>> ptr) =>
          objc.ObjCBlock<
              ffi.Void Function(
                  objc.ObjCBlock<ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)>,
                  ffi.Pointer<objc.ObjCObject>,
                  NSDictionary)>(objc.newPointerBlock(_ObjCBlock_ffiVoid_NSItemProviderCompletionHandler_objcObjCObject_NSDictionary_fnPtrCallable, ptr.cast()), retain: false, release: true);

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC.
  static objc.ObjCBlock<ffi.Void Function(objc.ObjCBlock<ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)>, ffi.Pointer<objc.ObjCObject>, NSDictionary)>
      fromFunction(void Function(objc.ObjCBlock<ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)>, objc.ObjCObjectBase, NSDictionary) fn,
              {bool keepIsolateAlive = true}) =>
          objc.ObjCBlock<ffi.Void Function(objc.ObjCBlock<ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)>, ffi.Pointer<objc.ObjCObject>, NSDictionary)>(
              objc.newClosureBlock(
                  _ObjCBlock_ffiVoid_NSItemProviderCompletionHandler_objcObjCObject_NSDictionary_closureCallable,
                  (ffi.Pointer<objc.ObjCBlockImpl> arg0, ffi.Pointer<objc.ObjCObject> arg1, ffi.Pointer<objc.ObjCObject> arg2) => fn(
                      ObjCBlock_ffiVoid_idNSSecureCoding_NSError.castFromPointer(arg0, retain: true, release: true),
                      objc.ObjCObjectBase(arg1, retain: true, release: true),
                      NSDictionary.castFromPointer(arg2, retain: true, release: true)),
                  keepIsolateAlive),
              retain: false,
              release: true);

  /// Creates a listener block from a Dart function.
  ///
  /// This is based on FFI's NativeCallable.listener, and has the same
  /// capabilities and limitations. This block can be invoked from any thread,
  /// but only supports void functions, and is not run synchronously. See
  /// NativeCallable.listener for more details.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC.
  static objc.ObjCBlock<
      ffi.Void Function(
          objc.ObjCBlock<
              ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)>,
          ffi.Pointer<objc.ObjCObject>,
          NSDictionary)> listener(
      void Function(
              objc.ObjCBlock<
                  ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)>,
              objc.ObjCObjectBase,
              NSDictionary)
          fn,
      {bool keepIsolateAlive = true}) {
    final raw = objc.newClosureBlock(
        _ObjCBlock_ffiVoid_NSItemProviderCompletionHandler_objcObjCObject_NSDictionary_listenerCallable
            .nativeFunction
            .cast(),
        (ffi.Pointer<objc.ObjCBlockImpl> arg0,
                ffi.Pointer<objc.ObjCObject> arg1,
                ffi.Pointer<objc.ObjCObject> arg2) =>
            fn(
                ObjCBlock_ffiVoid_idNSSecureCoding_NSError.castFromPointer(arg0,
                    retain: false, release: true),
                objc.ObjCObjectBase(arg1, retain: false, release: true),
                NSDictionary.castFromPointer(arg2,
                    retain: false, release: true)),
        keepIsolateAlive);
    final wrapper = _ObjectiveCBindings_wrapListenerBlock_1b3bb6a(raw);
    objc.objectRelease(raw.cast());
    return objc.ObjCBlock<
        ffi.Void Function(
            objc.ObjCBlock<
                ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)>,
            ffi.Pointer<objc.ObjCObject>,
            NSDictionary)>(wrapper, retain: false, release: true);
  }

  /// Creates a blocking block from a Dart function.
  ///
  /// This callback can be invoked from any native thread, and will block the
  /// caller until the callback is handled by the Dart isolate that created
  /// the block. Async functions are not supported.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC. If the owner isolate
  /// has shut down, and the block is invoked by native code, it may block
  /// indefinitely, or have other undefined behavior.
  static objc.ObjCBlock<
      ffi.Void Function(
          objc.ObjCBlock<
              ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)>,
          ffi.Pointer<objc.ObjCObject>,
          NSDictionary)> blocking(
      void Function(
              objc.ObjCBlock<
                  ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)>,
              objc.ObjCObjectBase,
              NSDictionary)
          fn,
      {bool keepIsolateAlive = true}) {
    final raw = objc.newClosureBlock(
        _ObjCBlock_ffiVoid_NSItemProviderCompletionHandler_objcObjCObject_NSDictionary_blockingCallable
            .nativeFunction
            .cast(),
        (ffi.Pointer<objc.ObjCBlockImpl> arg0,
                ffi.Pointer<objc.ObjCObject> arg1,
                ffi.Pointer<objc.ObjCObject> arg2) =>
            fn(
                ObjCBlock_ffiVoid_idNSSecureCoding_NSError.castFromPointer(arg0,
                    retain: false, release: true),
                objc.ObjCObjectBase(arg1, retain: false, release: true),
                NSDictionary.castFromPointer(arg2,
                    retain: false, release: true)),
        keepIsolateAlive);
    final rawListener = objc.newClosureBlock(
        _ObjCBlock_ffiVoid_NSItemProviderCompletionHandler_objcObjCObject_NSDictionary_blockingListenerCallable
            .nativeFunction
            .cast(),
        (ffi.Pointer<objc.ObjCBlockImpl> arg0,
                ffi.Pointer<objc.ObjCObject> arg1,
                ffi.Pointer<objc.ObjCObject> arg2) =>
            fn(
                ObjCBlock_ffiVoid_idNSSecureCoding_NSError.castFromPointer(arg0,
                    retain: false, release: true),
                objc.ObjCObjectBase(arg1, retain: false, release: true),
                NSDictionary.castFromPointer(arg2,
                    retain: false, release: true)),
        keepIsolateAlive);
    final wrapper = _ObjectiveCBindings_wrapBlockingBlock_1b3bb6a(
        raw, rawListener, objc.objCContext);
    objc.objectRelease(raw.cast());
    objc.objectRelease(rawListener.cast());
    return objc.ObjCBlock<
        ffi.Void Function(
            objc.ObjCBlock<
                ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)>,
            ffi.Pointer<objc.ObjCObject>,
            NSDictionary)>(wrapper, retain: false, release: true);
  }
}

/// Call operator for `objc.ObjCBlock<ffi.Void Function(objc.ObjCBlock<ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)>, ffi.Pointer<objc.ObjCObject>, NSDictionary)>`.
extension ObjCBlock_ffiVoid_NSItemProviderCompletionHandler_objcObjCObject_NSDictionary_CallExtension
    on objc.ObjCBlock<
        ffi.Void Function(
            objc.ObjCBlock<
                ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)>,
            ffi.Pointer<objc.ObjCObject>,
            NSDictionary)> {
  void call(
          objc.ObjCBlock<ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)>
              arg0,
          objc.ObjCObjectBase arg1,
          NSDictionary arg2) =>
      ref.pointer.ref.invoke
              .cast<
                  ffi.NativeFunction<
                      ffi.Void Function(
                          ffi.Pointer<objc.ObjCBlockImpl> block,
                          ffi.Pointer<objc.ObjCBlockImpl> arg0,
                          ffi.Pointer<objc.ObjCObject> arg1,
                          ffi.Pointer<objc.ObjCObject> arg2)>>()
              .asFunction<
                  void Function(
                      ffi.Pointer<objc.ObjCBlockImpl>,
                      ffi.Pointer<objc.ObjCBlockImpl>,
                      ffi.Pointer<objc.ObjCObject>,
                      ffi.Pointer<objc.ObjCObject>)>()(
          ref.pointer, arg0.ref.pointer, arg1.ref.pointer, arg2.ref.pointer);
}

void _ObjCBlock_ffiVoid_ffiVoid_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block, ffi.Pointer<ffi.Void> arg0) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void> arg0)>>()
        .asFunction<void Function(ffi.Pointer<ffi.Void>)>()(arg0);
ffi.Pointer<ffi.Void> _ObjCBlock_ffiVoid_ffiVoid_fnPtrCallable =
    ffi.Pointer.fromFunction<
                ffi.Void Function(
                    ffi.Pointer<objc.ObjCBlockImpl>, ffi.Pointer<ffi.Void>)>(
            _ObjCBlock_ffiVoid_ffiVoid_fnPtrTrampoline)
        .cast();
void _ObjCBlock_ffiVoid_ffiVoid_closureTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block, ffi.Pointer<ffi.Void> arg0) =>
    (objc.getBlockClosure(block) as void Function(ffi.Pointer<ffi.Void>))(arg0);
ffi.Pointer<ffi.Void> _ObjCBlock_ffiVoid_ffiVoid_closureCallable =
    ffi.Pointer.fromFunction<
                ffi.Void Function(
                    ffi.Pointer<objc.ObjCBlockImpl>, ffi.Pointer<ffi.Void>)>(
            _ObjCBlock_ffiVoid_ffiVoid_closureTrampoline)
        .cast();
void _ObjCBlock_ffiVoid_ffiVoid_listenerTrampoline(
    ffi.Pointer<objc.ObjCBlockImpl> block, ffi.Pointer<ffi.Void> arg0) {
  (objc.getBlockClosure(block) as void Function(ffi.Pointer<ffi.Void>))(arg0);
  objc.objectRelease(block.cast());
}

ffi.NativeCallable<
        ffi.Void Function(
            ffi.Pointer<objc.ObjCBlockImpl>, ffi.Pointer<ffi.Void>)>
    _ObjCBlock_ffiVoid_ffiVoid_listenerCallable = ffi.NativeCallable<
            ffi.Void Function(ffi.Pointer<objc.ObjCBlockImpl>,
                ffi.Pointer<ffi.Void>)>.listener(
        _ObjCBlock_ffiVoid_ffiVoid_listenerTrampoline)
      ..keepIsolateAlive = false;
void _ObjCBlock_ffiVoid_ffiVoid_blockingTrampoline(
    ffi.Pointer<objc.ObjCBlockImpl> block,
    ffi.Pointer<ffi.Void> waiter,
    ffi.Pointer<ffi.Void> arg0) {
  try {
    (objc.getBlockClosure(block) as void Function(ffi.Pointer<ffi.Void>))(arg0);
  } catch (e) {
  } finally {
    objc.signalWaiter(waiter);
    objc.objectRelease(block.cast());
  }
}

ffi.NativeCallable<
        ffi.Void Function(ffi.Pointer<objc.ObjCBlockImpl>,
            ffi.Pointer<ffi.Void>, ffi.Pointer<ffi.Void>)>
    _ObjCBlock_ffiVoid_ffiVoid_blockingCallable = ffi.NativeCallable<
            ffi.Void Function(ffi.Pointer<objc.ObjCBlockImpl>,
                ffi.Pointer<ffi.Void>, ffi.Pointer<ffi.Void>)>.isolateLocal(
        _ObjCBlock_ffiVoid_ffiVoid_blockingTrampoline)
      ..keepIsolateAlive = false;
ffi.NativeCallable<
        ffi.Void Function(ffi.Pointer<objc.ObjCBlockImpl>,
            ffi.Pointer<ffi.Void>, ffi.Pointer<ffi.Void>)>
    _ObjCBlock_ffiVoid_ffiVoid_blockingListenerCallable = ffi.NativeCallable<
            ffi.Void Function(ffi.Pointer<objc.ObjCBlockImpl>,
                ffi.Pointer<ffi.Void>, ffi.Pointer<ffi.Void>)>.listener(
        _ObjCBlock_ffiVoid_ffiVoid_blockingTrampoline)
      ..keepIsolateAlive = false;

/// Construction methods for `objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>)>`.
abstract final class ObjCBlock_ffiVoid_ffiVoid {
  /// Returns a block that wraps the given raw block pointer.
  static objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>)>
      castFromPointer(ffi.Pointer<objc.ObjCBlockImpl> pointer,
              {bool retain = false, bool release = false}) =>
          objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>)>(pointer,
              retain: retain, release: release);

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  static objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>)> fromFunctionPointer(
          ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(ffi.Pointer<ffi.Void> arg0)>>
              ptr) =>
      objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>)>(
          objc.newPointerBlock(
              _ObjCBlock_ffiVoid_ffiVoid_fnPtrCallable, ptr.cast()),
          retain: false,
          release: true);

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC.
  static objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>)> fromFunction(
          void Function(ffi.Pointer<ffi.Void>) fn,
          {bool keepIsolateAlive = true}) =>
      objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>)>(
          objc.newClosureBlock(_ObjCBlock_ffiVoid_ffiVoid_closureCallable,
              (ffi.Pointer<ffi.Void> arg0) => fn(arg0), keepIsolateAlive),
          retain: false,
          release: true);

  /// Creates a listener block from a Dart function.
  ///
  /// This is based on FFI's NativeCallable.listener, and has the same
  /// capabilities and limitations. This block can be invoked from any thread,
  /// but only supports void functions, and is not run synchronously. See
  /// NativeCallable.listener for more details.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC.
  static objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>)> listener(
      void Function(ffi.Pointer<ffi.Void>) fn,
      {bool keepIsolateAlive = true}) {
    final raw = objc.newClosureBlock(
        _ObjCBlock_ffiVoid_ffiVoid_listenerCallable.nativeFunction.cast(),
        (ffi.Pointer<ffi.Void> arg0) => fn(arg0),
        keepIsolateAlive);
    final wrapper = _ObjectiveCBindings_wrapListenerBlock_ovsamd(raw);
    objc.objectRelease(raw.cast());
    return objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>)>(wrapper,
        retain: false, release: true);
  }

  /// Creates a blocking block from a Dart function.
  ///
  /// This callback can be invoked from any native thread, and will block the
  /// caller until the callback is handled by the Dart isolate that created
  /// the block. Async functions are not supported.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC. If the owner isolate
  /// has shut down, and the block is invoked by native code, it may block
  /// indefinitely, or have other undefined behavior.
  static objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>)> blocking(
      void Function(ffi.Pointer<ffi.Void>) fn,
      {bool keepIsolateAlive = true}) {
    final raw = objc.newClosureBlock(
        _ObjCBlock_ffiVoid_ffiVoid_blockingCallable.nativeFunction.cast(),
        (ffi.Pointer<ffi.Void> arg0) => fn(arg0),
        keepIsolateAlive);
    final rawListener = objc.newClosureBlock(
        _ObjCBlock_ffiVoid_ffiVoid_blockingListenerCallable.nativeFunction
            .cast(),
        (ffi.Pointer<ffi.Void> arg0) => fn(arg0),
        keepIsolateAlive);
    final wrapper = _ObjectiveCBindings_wrapBlockingBlock_ovsamd(
        raw, rawListener, objc.objCContext);
    objc.objectRelease(raw.cast());
    objc.objectRelease(rawListener.cast());
    return objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>)>(wrapper,
        retain: false, release: true);
  }
}

/// Call operator for `objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>)>`.
extension ObjCBlock_ffiVoid_ffiVoid_CallExtension
    on objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>)> {
  void call(ffi.Pointer<ffi.Void> arg0) => ref.pointer.ref.invoke
      .cast<
          ffi.NativeFunction<
              ffi.Void Function(ffi.Pointer<objc.ObjCBlockImpl> block,
                  ffi.Pointer<ffi.Void> arg0)>>()
      .asFunction<
          void Function(ffi.Pointer<objc.ObjCBlockImpl>,
              ffi.Pointer<ffi.Void>)>()(ref.pointer, arg0);
}

void _ObjCBlock_ffiVoid_ffiVoid_NSCoder_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block,
        ffi.Pointer<ffi.Void> arg0,
        ffi.Pointer<objc.ObjCObject> arg1) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.Void Function(ffi.Pointer<ffi.Void> arg0,
                    ffi.Pointer<objc.ObjCObject> arg1)>>()
        .asFunction<
            void Function(ffi.Pointer<ffi.Void>,
                ffi.Pointer<objc.ObjCObject>)>()(arg0, arg1);
ffi.Pointer<ffi.Void> _ObjCBlock_ffiVoid_ffiVoid_NSCoder_fnPtrCallable =
    ffi.Pointer.fromFunction<
                ffi.Void Function(ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>(
            _ObjCBlock_ffiVoid_ffiVoid_NSCoder_fnPtrTrampoline)
        .cast();
void _ObjCBlock_ffiVoid_ffiVoid_NSCoder_closureTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block,
        ffi.Pointer<ffi.Void> arg0,
        ffi.Pointer<objc.ObjCObject> arg1) =>
    (objc.getBlockClosure(block) as void Function(
        ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>))(arg0, arg1);
ffi.Pointer<ffi.Void> _ObjCBlock_ffiVoid_ffiVoid_NSCoder_closureCallable =
    ffi.Pointer.fromFunction<
                ffi.Void Function(ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>(
            _ObjCBlock_ffiVoid_ffiVoid_NSCoder_closureTrampoline)
        .cast();
void _ObjCBlock_ffiVoid_ffiVoid_NSCoder_listenerTrampoline(
    ffi.Pointer<objc.ObjCBlockImpl> block,
    ffi.Pointer<ffi.Void> arg0,
    ffi.Pointer<objc.ObjCObject> arg1) {
  (objc.getBlockClosure(block) as void Function(
      ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>))(arg0, arg1);
  objc.objectRelease(block.cast());
}

ffi.NativeCallable<
        ffi.Void Function(ffi.Pointer<objc.ObjCBlockImpl>,
            ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>
    _ObjCBlock_ffiVoid_ffiVoid_NSCoder_listenerCallable = ffi.NativeCallable<
            ffi.Void Function(ffi.Pointer<objc.ObjCBlockImpl>,
                ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>.listener(
        _ObjCBlock_ffiVoid_ffiVoid_NSCoder_listenerTrampoline)
      ..keepIsolateAlive = false;
void _ObjCBlock_ffiVoid_ffiVoid_NSCoder_blockingTrampoline(
    ffi.Pointer<objc.ObjCBlockImpl> block,
    ffi.Pointer<ffi.Void> waiter,
    ffi.Pointer<ffi.Void> arg0,
    ffi.Pointer<objc.ObjCObject> arg1) {
  try {
    (objc.getBlockClosure(block) as void Function(
        ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>))(arg0, arg1);
  } catch (e) {
  } finally {
    objc.signalWaiter(waiter);
    objc.objectRelease(block.cast());
  }
}

ffi.NativeCallable<
        ffi.Void Function(
            ffi.Pointer<objc.ObjCBlockImpl>,
            ffi.Pointer<ffi.Void>,
            ffi.Pointer<ffi.Void>,
            ffi.Pointer<objc.ObjCObject>)>
    _ObjCBlock_ffiVoid_ffiVoid_NSCoder_blockingCallable = ffi.NativeCallable<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCBlockImpl>,
                ffi.Pointer<ffi.Void>,
                ffi.Pointer<ffi.Void>,
                ffi.Pointer<objc.ObjCObject>)>.isolateLocal(
        _ObjCBlock_ffiVoid_ffiVoid_NSCoder_blockingTrampoline)
      ..keepIsolateAlive = false;
ffi.NativeCallable<
        ffi.Void Function(
            ffi.Pointer<objc.ObjCBlockImpl>,
            ffi.Pointer<ffi.Void>,
            ffi.Pointer<ffi.Void>,
            ffi.Pointer<objc.ObjCObject>)>
    _ObjCBlock_ffiVoid_ffiVoid_NSCoder_blockingListenerCallable = ffi
        .NativeCallable<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCBlockImpl>,
                ffi.Pointer<ffi.Void>,
                ffi.Pointer<ffi.Void>,
                ffi.Pointer<objc.ObjCObject>)>.listener(
        _ObjCBlock_ffiVoid_ffiVoid_NSCoder_blockingTrampoline)
      ..keepIsolateAlive = false;

/// Construction methods for `objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>, NSCoder)>`.
abstract final class ObjCBlock_ffiVoid_ffiVoid_NSCoder {
  /// Returns a block that wraps the given raw block pointer.
  static objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>, NSCoder)>
      castFromPointer(ffi.Pointer<objc.ObjCBlockImpl> pointer,
              {bool retain = false, bool release = false}) =>
          objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>, NSCoder)>(
              pointer,
              retain: retain,
              release: release);

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  static objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>, NSCoder)>
      fromFunctionPointer(
              ffi.Pointer<
                      ffi.NativeFunction<
                          ffi.Void Function(ffi.Pointer<ffi.Void> arg0,
                              ffi.Pointer<objc.ObjCObject> arg1)>>
                  ptr) =>
          objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>, NSCoder)>(
              objc.newPointerBlock(_ObjCBlock_ffiVoid_ffiVoid_NSCoder_fnPtrCallable, ptr.cast()),
              retain: false,
              release: true);

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC.
  static objc.ObjCBlock<
      ffi.Void Function(ffi.Pointer<ffi.Void>, NSCoder)> fromFunction(
          void Function(ffi.Pointer<ffi.Void>, NSCoder) fn,
          {bool keepIsolateAlive = true}) =>
      objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>, NSCoder)>(
          objc.newClosureBlock(
              _ObjCBlock_ffiVoid_ffiVoid_NSCoder_closureCallable,
              (ffi.Pointer<ffi.Void> arg0, ffi.Pointer<objc.ObjCObject> arg1) =>
                  fn(arg0, NSCoder.castFromPointer(arg1, retain: true, release: true)),
              keepIsolateAlive),
          retain: false,
          release: true);

  /// Creates a listener block from a Dart function.
  ///
  /// This is based on FFI's NativeCallable.listener, and has the same
  /// capabilities and limitations. This block can be invoked from any thread,
  /// but only supports void functions, and is not run synchronously. See
  /// NativeCallable.listener for more details.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC.
  static objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>, NSCoder)>
      listener(void Function(ffi.Pointer<ffi.Void>, NSCoder) fn,
          {bool keepIsolateAlive = true}) {
    final raw = objc.newClosureBlock(
        _ObjCBlock_ffiVoid_ffiVoid_NSCoder_listenerCallable.nativeFunction
            .cast(),
        (ffi.Pointer<ffi.Void> arg0, ffi.Pointer<objc.ObjCObject> arg1) => fn(
            arg0, NSCoder.castFromPointer(arg1, retain: false, release: true)),
        keepIsolateAlive);
    final wrapper = _ObjectiveCBindings_wrapListenerBlock_18v1jvf(raw);
    objc.objectRelease(raw.cast());
    return objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>, NSCoder)>(
        wrapper,
        retain: false,
        release: true);
  }

  /// Creates a blocking block from a Dart function.
  ///
  /// This callback can be invoked from any native thread, and will block the
  /// caller until the callback is handled by the Dart isolate that created
  /// the block. Async functions are not supported.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC. If the owner isolate
  /// has shut down, and the block is invoked by native code, it may block
  /// indefinitely, or have other undefined behavior.
  static objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>, NSCoder)>
      blocking(void Function(ffi.Pointer<ffi.Void>, NSCoder) fn,
          {bool keepIsolateAlive = true}) {
    final raw = objc.newClosureBlock(
        _ObjCBlock_ffiVoid_ffiVoid_NSCoder_blockingCallable.nativeFunction
            .cast(),
        (ffi.Pointer<ffi.Void> arg0, ffi.Pointer<objc.ObjCObject> arg1) => fn(
            arg0, NSCoder.castFromPointer(arg1, retain: false, release: true)),
        keepIsolateAlive);
    final rawListener = objc.newClosureBlock(
        _ObjCBlock_ffiVoid_ffiVoid_NSCoder_blockingListenerCallable
            .nativeFunction
            .cast(),
        (ffi.Pointer<ffi.Void> arg0, ffi.Pointer<objc.ObjCObject> arg1) => fn(
            arg0, NSCoder.castFromPointer(arg1, retain: false, release: true)),
        keepIsolateAlive);
    final wrapper = _ObjectiveCBindings_wrapBlockingBlock_18v1jvf(
        raw, rawListener, objc.objCContext);
    objc.objectRelease(raw.cast());
    objc.objectRelease(rawListener.cast());
    return objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>, NSCoder)>(
        wrapper,
        retain: false,
        release: true);
  }
}

/// Call operator for `objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>, NSCoder)>`.
extension ObjCBlock_ffiVoid_ffiVoid_NSCoder_CallExtension
    on objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>, NSCoder)> {
  void call(ffi.Pointer<ffi.Void> arg0, NSCoder arg1) => ref.pointer.ref.invoke
          .cast<
              ffi.NativeFunction<
                  ffi.Void Function(
                      ffi.Pointer<objc.ObjCBlockImpl> block,
                      ffi.Pointer<ffi.Void> arg0,
                      ffi.Pointer<objc.ObjCObject> arg1)>>()
          .asFunction<
              void Function(ffi.Pointer<objc.ObjCBlockImpl>,
                  ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>()(
      ref.pointer, arg0, arg1.ref.pointer);
}

void _ObjCBlock_ffiVoid_ffiVoid_NSStream_NSStreamEvent_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block,
        ffi.Pointer<ffi.Void> arg0,
        ffi.Pointer<objc.ObjCObject> arg1,
        int arg2) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.Void Function(
                    ffi.Pointer<ffi.Void> arg0,
                    ffi.Pointer<objc.ObjCObject> arg1,
                    ffi.UnsignedLong arg2)>>()
        .asFunction<
            void Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>,
                int)>()(arg0, arg1, arg2);
ffi.Pointer<ffi.Void>
    _ObjCBlock_ffiVoid_ffiVoid_NSStream_NSStreamEvent_fnPtrCallable =
    ffi.Pointer.fromFunction<
                ffi.Void Function(
                    ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<ffi.Void>,
                    ffi.Pointer<objc.ObjCObject>,
                    ffi.UnsignedLong)>(
            _ObjCBlock_ffiVoid_ffiVoid_NSStream_NSStreamEvent_fnPtrTrampoline)
        .cast();
void _ObjCBlock_ffiVoid_ffiVoid_NSStream_NSStreamEvent_closureTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block,
        ffi.Pointer<ffi.Void> arg0,
        ffi.Pointer<objc.ObjCObject> arg1,
        int arg2) =>
    (objc.getBlockClosure(block) as void Function(ffi.Pointer<ffi.Void>,
        ffi.Pointer<objc.ObjCObject>, int))(arg0, arg1, arg2);
ffi.Pointer<ffi.Void>
    _ObjCBlock_ffiVoid_ffiVoid_NSStream_NSStreamEvent_closureCallable =
    ffi.Pointer.fromFunction<
                ffi.Void Function(
                    ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<ffi.Void>,
                    ffi.Pointer<objc.ObjCObject>,
                    ffi.UnsignedLong)>(
            _ObjCBlock_ffiVoid_ffiVoid_NSStream_NSStreamEvent_closureTrampoline)
        .cast();
void _ObjCBlock_ffiVoid_ffiVoid_NSStream_NSStreamEvent_listenerTrampoline(
    ffi.Pointer<objc.ObjCBlockImpl> block,
    ffi.Pointer<ffi.Void> arg0,
    ffi.Pointer<objc.ObjCObject> arg1,
    int arg2) {
  (objc.getBlockClosure(block) as void Function(ffi.Pointer<ffi.Void>,
      ffi.Pointer<objc.ObjCObject>, int))(arg0, arg1, arg2);
  objc.objectRelease(block.cast());
}

ffi.NativeCallable<
        ffi.Void Function(
            ffi.Pointer<objc.ObjCBlockImpl>,
            ffi.Pointer<ffi.Void>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.UnsignedLong)>
    _ObjCBlock_ffiVoid_ffiVoid_NSStream_NSStreamEvent_listenerCallable = ffi
        .NativeCallable<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCBlockImpl>,
                ffi.Pointer<ffi.Void>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong)>.listener(
        _ObjCBlock_ffiVoid_ffiVoid_NSStream_NSStreamEvent_listenerTrampoline)
      ..keepIsolateAlive = false;
void _ObjCBlock_ffiVoid_ffiVoid_NSStream_NSStreamEvent_blockingTrampoline(
    ffi.Pointer<objc.ObjCBlockImpl> block,
    ffi.Pointer<ffi.Void> waiter,
    ffi.Pointer<ffi.Void> arg0,
    ffi.Pointer<objc.ObjCObject> arg1,
    int arg2) {
  try {
    (objc.getBlockClosure(block) as void Function(ffi.Pointer<ffi.Void>,
        ffi.Pointer<objc.ObjCObject>, int))(arg0, arg1, arg2);
  } catch (e) {
  } finally {
    objc.signalWaiter(waiter);
    objc.objectRelease(block.cast());
  }
}

ffi.NativeCallable<
        ffi.Void Function(
            ffi.Pointer<objc.ObjCBlockImpl>,
            ffi.Pointer<ffi.Void>,
            ffi.Pointer<ffi.Void>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.UnsignedLong)>
    _ObjCBlock_ffiVoid_ffiVoid_NSStream_NSStreamEvent_blockingCallable =
    ffi.NativeCallable<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCBlockImpl>,
                ffi.Pointer<ffi.Void>,
                ffi.Pointer<ffi.Void>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong)>.isolateLocal(
        _ObjCBlock_ffiVoid_ffiVoid_NSStream_NSStreamEvent_blockingTrampoline)
      ..keepIsolateAlive = false;
ffi.NativeCallable<
        ffi.Void Function(
            ffi.Pointer<objc.ObjCBlockImpl>,
            ffi.Pointer<ffi.Void>,
            ffi.Pointer<ffi.Void>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.UnsignedLong)>
    _ObjCBlock_ffiVoid_ffiVoid_NSStream_NSStreamEvent_blockingListenerCallable =
    ffi.NativeCallable<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCBlockImpl>,
                ffi.Pointer<ffi.Void>,
                ffi.Pointer<ffi.Void>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong)>.listener(
        _ObjCBlock_ffiVoid_ffiVoid_NSStream_NSStreamEvent_blockingTrampoline)
      ..keepIsolateAlive = false;

/// Construction methods for `objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>, NSStream, ffi.UnsignedLong)>`.
abstract final class ObjCBlock_ffiVoid_ffiVoid_NSStream_NSStreamEvent {
  /// Returns a block that wraps the given raw block pointer.
  static objc.ObjCBlock<
          ffi.Void Function(ffi.Pointer<ffi.Void>, NSStream, ffi.UnsignedLong)>
      castFromPointer(ffi.Pointer<objc.ObjCBlockImpl> pointer,
              {bool retain = false, bool release = false}) =>
          objc.ObjCBlock<
              ffi.Void Function(ffi.Pointer<ffi.Void>, NSStream,
                  ffi.UnsignedLong)>(pointer, retain: retain, release: release);

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  static objc
      .ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>, NSStream, ffi.UnsignedLong)>
      fromFunctionPointer(
              ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void> arg0, ffi.Pointer<objc.ObjCObject> arg1, ffi.UnsignedLong arg2)>>
                  ptr) =>
          objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>, NSStream, ffi.UnsignedLong)>(
              objc.newPointerBlock(
                  _ObjCBlock_ffiVoid_ffiVoid_NSStream_NSStreamEvent_fnPtrCallable,
                  ptr.cast()),
              retain: false,
              release: true);

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC.
  static objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>, NSStream, ffi.UnsignedLong)> fromFunction(
          void Function(ffi.Pointer<ffi.Void>, NSStream, NSStreamEvent) fn,
          {bool keepIsolateAlive = true}) =>
      objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>, NSStream, ffi.UnsignedLong)>(
          objc.newClosureBlock(
              _ObjCBlock_ffiVoid_ffiVoid_NSStream_NSStreamEvent_closureCallable,
              (ffi.Pointer<ffi.Void> arg0, ffi.Pointer<objc.ObjCObject> arg1, int arg2) =>
                  fn(
                      arg0,
                      NSStream.castFromPointer(arg1, retain: true, release: true),
                      NSStreamEvent.fromValue(arg2)),
              keepIsolateAlive),
          retain: false,
          release: true);

  /// Creates a listener block from a Dart function.
  ///
  /// This is based on FFI's NativeCallable.listener, and has the same
  /// capabilities and limitations. This block can be invoked from any thread,
  /// but only supports void functions, and is not run synchronously. See
  /// NativeCallable.listener for more details.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC.
  static objc.ObjCBlock<
          ffi.Void Function(ffi.Pointer<ffi.Void>, NSStream, ffi.UnsignedLong)>
      listener(void Function(ffi.Pointer<ffi.Void>, NSStream, NSStreamEvent) fn,
          {bool keepIsolateAlive = true}) {
    final raw = objc.newClosureBlock(
        _ObjCBlock_ffiVoid_ffiVoid_NSStream_NSStreamEvent_listenerCallable
            .nativeFunction
            .cast(),
        (ffi.Pointer<ffi.Void> arg0, ffi.Pointer<objc.ObjCObject> arg1,
                int arg2) =>
            fn(
                arg0,
                NSStream.castFromPointer(arg1, retain: false, release: true),
                NSStreamEvent.fromValue(arg2)),
        keepIsolateAlive);
    final wrapper = _ObjectiveCBindings_wrapListenerBlock_hoampi(raw);
    objc.objectRelease(raw.cast());
    return objc.ObjCBlock<
        ffi.Void Function(ffi.Pointer<ffi.Void>, NSStream,
            ffi.UnsignedLong)>(wrapper, retain: false, release: true);
  }

  /// Creates a blocking block from a Dart function.
  ///
  /// This callback can be invoked from any native thread, and will block the
  /// caller until the callback is handled by the Dart isolate that created
  /// the block. Async functions are not supported.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC. If the owner isolate
  /// has shut down, and the block is invoked by native code, it may block
  /// indefinitely, or have other undefined behavior.
  static objc.ObjCBlock<
          ffi.Void Function(ffi.Pointer<ffi.Void>, NSStream, ffi.UnsignedLong)>
      blocking(void Function(ffi.Pointer<ffi.Void>, NSStream, NSStreamEvent) fn,
          {bool keepIsolateAlive = true}) {
    final raw = objc.newClosureBlock(
        _ObjCBlock_ffiVoid_ffiVoid_NSStream_NSStreamEvent_blockingCallable
            .nativeFunction
            .cast(),
        (ffi.Pointer<ffi.Void> arg0, ffi.Pointer<objc.ObjCObject> arg1,
                int arg2) =>
            fn(
                arg0,
                NSStream.castFromPointer(arg1, retain: false, release: true),
                NSStreamEvent.fromValue(arg2)),
        keepIsolateAlive);
    final rawListener = objc.newClosureBlock(
        _ObjCBlock_ffiVoid_ffiVoid_NSStream_NSStreamEvent_blockingListenerCallable
            .nativeFunction
            .cast(),
        (ffi.Pointer<ffi.Void> arg0, ffi.Pointer<objc.ObjCObject> arg1,
                int arg2) =>
            fn(
                arg0,
                NSStream.castFromPointer(arg1, retain: false, release: true),
                NSStreamEvent.fromValue(arg2)),
        keepIsolateAlive);
    final wrapper = _ObjectiveCBindings_wrapBlockingBlock_hoampi(
        raw, rawListener, objc.objCContext);
    objc.objectRelease(raw.cast());
    objc.objectRelease(rawListener.cast());
    return objc.ObjCBlock<
        ffi.Void Function(ffi.Pointer<ffi.Void>, NSStream,
            ffi.UnsignedLong)>(wrapper, retain: false, release: true);
  }
}

/// Call operator for `objc.ObjCBlock<ffi.Void Function(ffi.Pointer<ffi.Void>, NSStream, ffi.UnsignedLong)>`.
extension ObjCBlock_ffiVoid_ffiVoid_NSStream_NSStreamEvent_CallExtension
    on objc.ObjCBlock<
        ffi.Void Function(ffi.Pointer<ffi.Void>, NSStream, ffi.UnsignedLong)> {
  void call(ffi.Pointer<ffi.Void> arg0, NSStream arg1, NSStreamEvent arg2) =>
      ref.pointer.ref.invoke
          .cast<
              ffi.NativeFunction<
                  ffi.Void Function(
                      ffi.Pointer<objc.ObjCBlockImpl> block,
                      ffi.Pointer<ffi.Void> arg0,
                      ffi.Pointer<objc.ObjCObject> arg1,
                      ffi.UnsignedLong arg2)>>()
          .asFunction<
              void Function(
                  ffi.Pointer<objc.ObjCBlockImpl>,
                  ffi.Pointer<ffi.Void>,
                  ffi.Pointer<objc.ObjCObject>,
                  int)>()(ref.pointer, arg0, arg1.ref.pointer, arg2.value);
}

void _ObjCBlock_ffiVoid_idNSSecureCoding_NSError_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block,
        ffi.Pointer<objc.ObjCObject> arg0,
        ffi.Pointer<objc.ObjCObject> arg1) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.Void Function(ffi.Pointer<objc.ObjCObject> arg0,
                    ffi.Pointer<objc.ObjCObject> arg1)>>()
        .asFunction<
            void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>()(arg0, arg1);
ffi.Pointer<ffi.Void>
    _ObjCBlock_ffiVoid_idNSSecureCoding_NSError_fnPtrCallable =
    ffi.Pointer.fromFunction<
                ffi.Void Function(
                    ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<objc.ObjCObject>,
                    ffi.Pointer<objc.ObjCObject>)>(
            _ObjCBlock_ffiVoid_idNSSecureCoding_NSError_fnPtrTrampoline)
        .cast();
void _ObjCBlock_ffiVoid_idNSSecureCoding_NSError_closureTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block,
        ffi.Pointer<objc.ObjCObject> arg0,
        ffi.Pointer<objc.ObjCObject> arg1) =>
    (objc.getBlockClosure(block) as void Function(ffi.Pointer<objc.ObjCObject>,
        ffi.Pointer<objc.ObjCObject>))(arg0, arg1);
ffi.Pointer<ffi.Void>
    _ObjCBlock_ffiVoid_idNSSecureCoding_NSError_closureCallable =
    ffi.Pointer.fromFunction<
                ffi.Void Function(
                    ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<objc.ObjCObject>,
                    ffi.Pointer<objc.ObjCObject>)>(
            _ObjCBlock_ffiVoid_idNSSecureCoding_NSError_closureTrampoline)
        .cast();
void _ObjCBlock_ffiVoid_idNSSecureCoding_NSError_listenerTrampoline(
    ffi.Pointer<objc.ObjCBlockImpl> block,
    ffi.Pointer<objc.ObjCObject> arg0,
    ffi.Pointer<objc.ObjCObject> arg1) {
  (objc.getBlockClosure(block) as void Function(
      ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCObject>))(arg0, arg1);
  objc.objectRelease(block.cast());
}

ffi.NativeCallable<
        ffi.Void Function(ffi.Pointer<objc.ObjCBlockImpl>,
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCObject>)>
    _ObjCBlock_ffiVoid_idNSSecureCoding_NSError_listenerCallable = ffi
        .NativeCallable<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCBlockImpl>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>.listener(
        _ObjCBlock_ffiVoid_idNSSecureCoding_NSError_listenerTrampoline)
      ..keepIsolateAlive = false;
void _ObjCBlock_ffiVoid_idNSSecureCoding_NSError_blockingTrampoline(
    ffi.Pointer<objc.ObjCBlockImpl> block,
    ffi.Pointer<ffi.Void> waiter,
    ffi.Pointer<objc.ObjCObject> arg0,
    ffi.Pointer<objc.ObjCObject> arg1) {
  try {
    (objc.getBlockClosure(block) as void Function(ffi.Pointer<objc.ObjCObject>,
        ffi.Pointer<objc.ObjCObject>))(arg0, arg1);
  } catch (e) {
  } finally {
    objc.signalWaiter(waiter);
    objc.objectRelease(block.cast());
  }
}

ffi.NativeCallable<
        ffi.Void Function(
            ffi.Pointer<objc.ObjCBlockImpl>,
            ffi.Pointer<ffi.Void>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>
    _ObjCBlock_ffiVoid_idNSSecureCoding_NSError_blockingCallable = ffi
        .NativeCallable<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCBlockImpl>,
                ffi.Pointer<ffi.Void>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>.isolateLocal(
        _ObjCBlock_ffiVoid_idNSSecureCoding_NSError_blockingTrampoline)
      ..keepIsolateAlive = false;
ffi.NativeCallable<
        ffi.Void Function(
            ffi.Pointer<objc.ObjCBlockImpl>,
            ffi.Pointer<ffi.Void>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>
    _ObjCBlock_ffiVoid_idNSSecureCoding_NSError_blockingListenerCallable = ffi
        .NativeCallable<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCBlockImpl>,
                ffi.Pointer<ffi.Void>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>.listener(
        _ObjCBlock_ffiVoid_idNSSecureCoding_NSError_blockingTrampoline)
      ..keepIsolateAlive = false;

/// Construction methods for `objc.ObjCBlock<ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)>`.
abstract final class ObjCBlock_ffiVoid_idNSSecureCoding_NSError {
  /// Returns a block that wraps the given raw block pointer.
  static objc
      .ObjCBlock<ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)>
      castFromPointer(ffi.Pointer<objc.ObjCBlockImpl> pointer,
              {bool retain = false, bool release = false}) =>
          objc.ObjCBlock<
              ffi.Void Function(ffi.Pointer<objc.ObjCObject>?,
                  NSError)>(pointer, retain: retain, release: release);

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  static objc.ObjCBlock<ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)> fromFunctionPointer(
          ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(ffi.Pointer<objc.ObjCObject> arg0,
                          ffi.Pointer<objc.ObjCObject> arg1)>>
              ptr) =>
      objc.ObjCBlock<ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)>(
          objc.newPointerBlock(_ObjCBlock_ffiVoid_idNSSecureCoding_NSError_fnPtrCallable, ptr.cast()),
          retain: false,
          release: true);

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC.
  static objc.ObjCBlock<ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)> fromFunction(
          void Function(NSSecureCoding?, NSError) fn,
          {bool keepIsolateAlive = true}) =>
      objc.ObjCBlock<ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)>(
          objc.newClosureBlock(
              _ObjCBlock_ffiVoid_idNSSecureCoding_NSError_closureCallable,
              (ffi.Pointer<objc.ObjCObject> arg0, ffi.Pointer<objc.ObjCObject> arg1) => fn(
                  arg0.address == 0
                      ? null
                      : NSSecureCoding.castFromPointer(arg0, retain: true, release: true),
                  NSError.castFromPointer(arg1, retain: true, release: true)),
              keepIsolateAlive),
          retain: false,
          release: true);

  /// Creates a listener block from a Dart function.
  ///
  /// This is based on FFI's NativeCallable.listener, and has the same
  /// capabilities and limitations. This block can be invoked from any thread,
  /// but only supports void functions, and is not run synchronously. See
  /// NativeCallable.listener for more details.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC.
  static objc
      .ObjCBlock<ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)>
      listener(void Function(NSSecureCoding?, NSError) fn,
          {bool keepIsolateAlive = true}) {
    final raw = objc.newClosureBlock(
        _ObjCBlock_ffiVoid_idNSSecureCoding_NSError_listenerCallable
            .nativeFunction
            .cast(),
        (ffi.Pointer<objc.ObjCObject> arg0,
                ffi.Pointer<objc.ObjCObject> arg1) =>
            fn(
                arg0.address == 0
                    ? null
                    : NSSecureCoding.castFromPointer(arg0,
                        retain: false, release: true),
                NSError.castFromPointer(arg1, retain: false, release: true)),
        keepIsolateAlive);
    final wrapper = _ObjectiveCBindings_wrapListenerBlock_pfv6jd(raw);
    objc.objectRelease(raw.cast());
    return objc.ObjCBlock<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)>(wrapper,
        retain: false, release: true);
  }

  /// Creates a blocking block from a Dart function.
  ///
  /// This callback can be invoked from any native thread, and will block the
  /// caller until the callback is handled by the Dart isolate that created
  /// the block. Async functions are not supported.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC. If the owner isolate
  /// has shut down, and the block is invoked by native code, it may block
  /// indefinitely, or have other undefined behavior.
  static objc
      .ObjCBlock<ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)>
      blocking(void Function(NSSecureCoding?, NSError) fn,
          {bool keepIsolateAlive = true}) {
    final raw = objc.newClosureBlock(
        _ObjCBlock_ffiVoid_idNSSecureCoding_NSError_blockingCallable
            .nativeFunction
            .cast(),
        (ffi.Pointer<objc.ObjCObject> arg0,
                ffi.Pointer<objc.ObjCObject> arg1) =>
            fn(
                arg0.address == 0
                    ? null
                    : NSSecureCoding.castFromPointer(arg0,
                        retain: false, release: true),
                NSError.castFromPointer(arg1, retain: false, release: true)),
        keepIsolateAlive);
    final rawListener = objc.newClosureBlock(
        _ObjCBlock_ffiVoid_idNSSecureCoding_NSError_blockingListenerCallable
            .nativeFunction
            .cast(),
        (ffi.Pointer<objc.ObjCObject> arg0,
                ffi.Pointer<objc.ObjCObject> arg1) =>
            fn(
                arg0.address == 0
                    ? null
                    : NSSecureCoding.castFromPointer(arg0,
                        retain: false, release: true),
                NSError.castFromPointer(arg1, retain: false, release: true)),
        keepIsolateAlive);
    final wrapper = _ObjectiveCBindings_wrapBlockingBlock_pfv6jd(
        raw, rawListener, objc.objCContext);
    objc.objectRelease(raw.cast());
    objc.objectRelease(rawListener.cast());
    return objc.ObjCBlock<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)>(wrapper,
        retain: false, release: true);
  }
}

/// Call operator for `objc.ObjCBlock<ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)>`.
extension ObjCBlock_ffiVoid_idNSSecureCoding_NSError_CallExtension on objc
    .ObjCBlock<ffi.Void Function(ffi.Pointer<objc.ObjCObject>?, NSError)> {
  void call(NSSecureCoding? arg0, NSError arg1) => ref.pointer.ref.invoke
          .cast<
              ffi.NativeFunction<
                  ffi.Void Function(
                      ffi.Pointer<objc.ObjCBlockImpl> block,
                      ffi.Pointer<objc.ObjCObject> arg0,
                      ffi.Pointer<objc.ObjCObject> arg1)>>()
          .asFunction<
              void Function(
                  ffi.Pointer<objc.ObjCBlockImpl>,
                  ffi.Pointer<objc.ObjCObject>,
                  ffi.Pointer<objc.ObjCObject>)>()(
      ref.pointer, arg0?.ref.pointer ?? ffi.nullptr, arg1.ref.pointer);
}

instancetype _ObjCBlock_instancetype_ffiVoid_NSCoder_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block,
        ffi.Pointer<ffi.Void> arg0,
        ffi.Pointer<objc.ObjCObject> arg1) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                instancetype Function(ffi.Pointer<ffi.Void> arg0,
                    ffi.Pointer<objc.ObjCObject> arg1)>>()
        .asFunction<
            instancetype Function(ffi.Pointer<ffi.Void>,
                ffi.Pointer<objc.ObjCObject>)>()(arg0, arg1);
ffi.Pointer<ffi.Void> _ObjCBlock_instancetype_ffiVoid_NSCoder_fnPtrCallable =
    ffi.Pointer.fromFunction<
                instancetype Function(ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>(
            _ObjCBlock_instancetype_ffiVoid_NSCoder_fnPtrTrampoline)
        .cast();
instancetype _ObjCBlock_instancetype_ffiVoid_NSCoder_closureTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block,
        ffi.Pointer<ffi.Void> arg0,
        ffi.Pointer<objc.ObjCObject> arg1) =>
    (objc.getBlockClosure(block) as instancetype Function(
        ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>))(arg0, arg1);
ffi.Pointer<ffi.Void> _ObjCBlock_instancetype_ffiVoid_NSCoder_closureCallable =
    ffi.Pointer.fromFunction<
                instancetype Function(ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>(
            _ObjCBlock_instancetype_ffiVoid_NSCoder_closureTrampoline)
        .cast();

/// Construction methods for `objc.ObjCBlock<objc.Retained<ffi.Pointer<objc.ObjCObject>?> Function(ffi.Pointer<ffi.Void>, NSCoder)>`.
abstract final class ObjCBlock_instancetype_ffiVoid_NSCoder {
  /// Returns a block that wraps the given raw block pointer.
  static objc.ObjCBlock<
          objc.Retained<ffi.Pointer<objc.ObjCObject>?> Function(
              ffi.Pointer<ffi.Void>, NSCoder)>
      castFromPointer(ffi.Pointer<objc.ObjCBlockImpl> pointer,
              {bool retain = false, bool release = false}) =>
          objc.ObjCBlock<
              objc.Retained<ffi.Pointer<objc.ObjCObject>?> Function(
                  ffi.Pointer<ffi.Void>,
                  NSCoder)>(pointer, retain: retain, release: release);

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  static objc.ObjCBlock<
          objc.Retained<ffi.Pointer<objc.ObjCObject>?> Function(
              ffi.Pointer<ffi.Void>, NSCoder)>
      fromFunctionPointer(ffi.Pointer<ffi.NativeFunction<instancetype Function(ffi.Pointer<ffi.Void> arg0, ffi.Pointer<objc.ObjCObject> arg1)>> ptr) =>
          objc.ObjCBlock<
                  objc.Retained<ffi.Pointer<objc.ObjCObject>?> Function(
                      ffi.Pointer<ffi.Void>, NSCoder)>(
              objc.newPointerBlock(
                  _ObjCBlock_instancetype_ffiVoid_NSCoder_fnPtrCallable, ptr.cast()),
              retain: false,
              release: true);

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC.
  static objc.ObjCBlock<objc.Retained<ffi.Pointer<objc.ObjCObject>?> Function(ffi.Pointer<ffi.Void>, NSCoder)>
      fromFunction(
              Dartinstancetype? Function(ffi.Pointer<ffi.Void>, NSCoder) fn,
              {bool keepIsolateAlive = true}) =>
          objc.ObjCBlock<objc.Retained<ffi.Pointer<objc.ObjCObject>?> Function(ffi.Pointer<ffi.Void>, NSCoder)>(
              objc.newClosureBlock(
                  _ObjCBlock_instancetype_ffiVoid_NSCoder_closureCallable,
                  (ffi.Pointer<ffi.Void> arg0, ffi.Pointer<objc.ObjCObject> arg1) =>
                      fn(arg0, NSCoder.castFromPointer(arg1, retain: true, release: true))
                          ?.ref
                          .retainAndReturnPointer() ??
                      ffi.nullptr,
                  keepIsolateAlive),
              retain: false,
              release: true);
}

/// Call operator for `objc.ObjCBlock<objc.Retained<ffi.Pointer<objc.ObjCObject>?> Function(ffi.Pointer<ffi.Void>, NSCoder)>`.
extension ObjCBlock_instancetype_ffiVoid_NSCoder_CallExtension
    on objc.ObjCBlock<
        objc.Retained<ffi.Pointer<objc.ObjCObject>?> Function(
            ffi.Pointer<ffi.Void>, NSCoder)> {
  Dartinstancetype? call(ffi.Pointer<ffi.Void> arg0, NSCoder arg1) => ref
              .pointer.ref.invoke
              .cast<
                  ffi.NativeFunction<
                      instancetype Function(
                          ffi.Pointer<objc.ObjCBlockImpl> block,
                          ffi.Pointer<ffi.Void> arg0,
                          ffi.Pointer<objc.ObjCObject> arg1)>>()
              .asFunction<instancetype Function(ffi.Pointer<objc.ObjCBlockImpl>, ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>()
              (ref.pointer, arg0, arg1.ref.pointer)
              .address ==
          0
      ? null
      : objc.ObjCObjectBase(
          ref.pointer.ref.invoke
              .cast<ffi.NativeFunction<instancetype Function(ffi.Pointer<objc.ObjCBlockImpl> block, ffi.Pointer<ffi.Void> arg0, ffi.Pointer<objc.ObjCObject> arg1)>>()
              .asFunction<instancetype Function(ffi.Pointer<objc.ObjCBlockImpl>, ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>)>()(ref.pointer, arg0, arg1.ref.pointer),
          retain: false,
          release: true);
}

instancetype
    _ObjCBlock_instancetype_ffiVoid_NSData_NSString_NSError_fnPtrTrampoline(
            ffi.Pointer<objc.ObjCBlockImpl> block,
            ffi.Pointer<ffi.Void> arg0,
            ffi.Pointer<objc.ObjCObject> arg1,
            ffi.Pointer<objc.ObjCObject> arg2,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>> arg3) =>
        block.ref.target
                .cast<
                    ffi.NativeFunction<
                        instancetype Function(
                            ffi.Pointer<ffi.Void> arg0,
                            ffi.Pointer<objc.ObjCObject> arg1,
                            ffi.Pointer<objc.ObjCObject> arg2,
                            ffi.Pointer<ffi.Pointer<objc.ObjCObject>> arg3)>>()
                .asFunction<
                    instancetype Function(
                        ffi.Pointer<ffi.Void>,
                        ffi.Pointer<objc.ObjCObject>,
                        ffi.Pointer<objc.ObjCObject>,
                        ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>()(
            arg0, arg1, arg2, arg3);
ffi.Pointer<ffi.Void>
    _ObjCBlock_instancetype_ffiVoid_NSData_NSString_NSError_fnPtrCallable =
    ffi.Pointer.fromFunction<
                instancetype Function(
                    ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<ffi.Void>,
                    ffi.Pointer<objc.ObjCObject>,
                    ffi.Pointer<objc.ObjCObject>,
                    ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>(
            _ObjCBlock_instancetype_ffiVoid_NSData_NSString_NSError_fnPtrTrampoline)
        .cast();
instancetype
    _ObjCBlock_instancetype_ffiVoid_NSData_NSString_NSError_closureTrampoline(
            ffi.Pointer<objc.ObjCBlockImpl> block,
            ffi.Pointer<ffi.Void> arg0,
            ffi.Pointer<objc.ObjCObject> arg1,
            ffi.Pointer<objc.ObjCObject> arg2,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>> arg3) =>
        (objc.getBlockClosure(block) as instancetype Function(
            ffi.Pointer<ffi.Void>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>))(arg0, arg1, arg2, arg3);
ffi.Pointer<ffi.Void>
    _ObjCBlock_instancetype_ffiVoid_NSData_NSString_NSError_closureCallable =
    ffi.Pointer.fromFunction<
                instancetype Function(
                    ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<ffi.Void>,
                    ffi.Pointer<objc.ObjCObject>,
                    ffi.Pointer<objc.ObjCObject>,
                    ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>(
            _ObjCBlock_instancetype_ffiVoid_NSData_NSString_NSError_closureTrampoline)
        .cast();

/// Construction methods for `objc.ObjCBlock<ffi.Pointer<objc.ObjCObject>? Function(ffi.Pointer<ffi.Void>, NSData, NSString, ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>`.
abstract final class ObjCBlock_instancetype_ffiVoid_NSData_NSString_NSError {
  /// Returns a block that wraps the given raw block pointer.
  static objc.ObjCBlock<
          ffi.Pointer<objc.ObjCObject>? Function(
              ffi.Pointer<ffi.Void>, NSData, NSString, ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>
      castFromPointer(ffi.Pointer<objc.ObjCBlockImpl> pointer,
              {bool retain = false, bool release = false}) =>
          objc.ObjCBlock<
                  ffi.Pointer<objc.ObjCObject>? Function(
                      ffi.Pointer<ffi.Void>,
                      NSData,
                      NSString,
                      ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>(pointer,
              retain: retain, release: release);

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  static objc.ObjCBlock<
          ffi.Pointer<objc.ObjCObject>? Function(ffi.Pointer<ffi.Void>, NSData,
              NSString, ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>
      fromFunctionPointer(ffi.Pointer<ffi.NativeFunction<instancetype Function(ffi.Pointer<ffi.Void> arg0, ffi.Pointer<objc.ObjCObject> arg1, ffi.Pointer<objc.ObjCObject> arg2, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> arg3)>> ptr) =>
          objc.ObjCBlock<
                  ffi.Pointer<objc.ObjCObject>? Function(
                      ffi.Pointer<ffi.Void>,
                      NSData,
                      NSString,
                      ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>(
              objc.newPointerBlock(_ObjCBlock_instancetype_ffiVoid_NSData_NSString_NSError_fnPtrCallable, ptr.cast()),
              retain: false,
              release: true);

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC.
  static objc
      .ObjCBlock<ffi.Pointer<objc.ObjCObject>? Function(ffi.Pointer<ffi.Void>, NSData, NSString, ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>
      fromFunction(Dartinstancetype? Function(ffi.Pointer<ffi.Void>, NSData, NSString, ffi.Pointer<ffi.Pointer<objc.ObjCObject>>) fn,
              {bool keepIsolateAlive = true}) =>
          objc.ObjCBlock<ffi.Pointer<objc.ObjCObject>? Function(ffi.Pointer<ffi.Void>, NSData, NSString, ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>(
              objc.newClosureBlock(
                  _ObjCBlock_instancetype_ffiVoid_NSData_NSString_NSError_closureCallable,
                  (ffi.Pointer<ffi.Void> arg0,
                          ffi.Pointer<objc.ObjCObject> arg1,
                          ffi.Pointer<objc.ObjCObject> arg2,
                          ffi.Pointer<ffi.Pointer<objc.ObjCObject>> arg3) =>
                      fn(arg0, NSData.castFromPointer(arg1, retain: true, release: true), NSString.castFromPointer(arg2, retain: true, release: true), arg3)?.ref.retainAndAutorelease() ?? ffi.nullptr,
                  keepIsolateAlive),
              retain: false,
              release: true);
}

/// Call operator for `objc.ObjCBlock<ffi.Pointer<objc.ObjCObject>? Function(ffi.Pointer<ffi.Void>, NSData, NSString, ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>`.
extension ObjCBlock_instancetype_ffiVoid_NSData_NSString_NSError_CallExtension
    on objc.ObjCBlock<
        ffi.Pointer<objc.ObjCObject>? Function(ffi.Pointer<ffi.Void>, NSData,
            NSString, ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)> {
  Dartinstancetype? call(ffi.Pointer<ffi.Void> arg0, NSData arg1, NSString arg2, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> arg3) => ref
              .pointer.ref.invoke
              .cast<
                  ffi.NativeFunction<
                      instancetype Function(
                          ffi.Pointer<objc.ObjCBlockImpl> block,
                          ffi.Pointer<ffi.Void> arg0,
                          ffi.Pointer<objc.ObjCObject> arg1,
                          ffi.Pointer<objc.ObjCObject> arg2,
                          ffi.Pointer<ffi.Pointer<objc.ObjCObject>> arg3)>>()
              .asFunction<
                  instancetype Function(
                      ffi.Pointer<objc.ObjCBlockImpl>,
                      ffi.Pointer<ffi.Void>,
                      ffi.Pointer<objc.ObjCObject>,
                      ffi.Pointer<objc.ObjCObject>,
                      ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>()
              (ref.pointer, arg0, arg1.ref.pointer, arg2.ref.pointer, arg3)
              .address ==
          0
      ? null
      : objc.ObjCObjectBase(
          ref.pointer.ref.invoke.cast<ffi.NativeFunction<instancetype Function(ffi.Pointer<objc.ObjCBlockImpl> block, ffi.Pointer<ffi.Void> arg0, ffi.Pointer<objc.ObjCObject> arg1, ffi.Pointer<objc.ObjCObject> arg2, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> arg3)>>().asFunction<instancetype Function(ffi.Pointer<objc.ObjCBlockImpl>, ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>()(ref.pointer, arg0, arg1.ref.pointer, arg2.ref.pointer, arg3),
          retain: true,
          release: true);
}

ffi.Pointer<objc.ObjCObject> _ObjCBlock_objcObjCObject_ffiVoid_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block, ffi.Pointer<ffi.Void> arg0) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.Pointer<objc.ObjCObject> Function(
                    ffi.Pointer<ffi.Void> arg0)>>()
        .asFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<ffi.Void>)>()(arg0);
ffi.Pointer<ffi.Void> _ObjCBlock_objcObjCObject_ffiVoid_fnPtrCallable =
    ffi.Pointer.fromFunction<
                ffi.Pointer<objc.ObjCObject> Function(
                    ffi.Pointer<objc.ObjCBlockImpl>, ffi.Pointer<ffi.Void>)>(
            _ObjCBlock_objcObjCObject_ffiVoid_fnPtrTrampoline)
        .cast();
ffi.Pointer<objc.ObjCObject>
    _ObjCBlock_objcObjCObject_ffiVoid_closureTrampoline(
            ffi.Pointer<objc.ObjCBlockImpl> block,
            ffi.Pointer<ffi.Void> arg0) =>
        (objc.getBlockClosure(block) as ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<ffi.Void>))(arg0);
ffi.Pointer<ffi.Void> _ObjCBlock_objcObjCObject_ffiVoid_closureCallable =
    ffi.Pointer.fromFunction<
                ffi.Pointer<objc.ObjCObject> Function(
                    ffi.Pointer<objc.ObjCBlockImpl>, ffi.Pointer<ffi.Void>)>(
            _ObjCBlock_objcObjCObject_ffiVoid_closureTrampoline)
        .cast();

/// Construction methods for `objc.ObjCBlock<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>)>`.
abstract final class ObjCBlock_objcObjCObject_ffiVoid {
  /// Returns a block that wraps the given raw block pointer.
  static objc
      .ObjCBlock<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>)>
      castFromPointer(ffi.Pointer<objc.ObjCBlockImpl> pointer,
              {bool retain = false, bool release = false}) =>
          objc.ObjCBlock<
                  ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>)>(
              pointer,
              retain: retain,
              release: release);

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  static objc.ObjCBlock<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>)>
      fromFunctionPointer(
              ffi.Pointer<
                      ffi.NativeFunction<
                          ffi.Pointer<objc.ObjCObject> Function(
                              ffi.Pointer<ffi.Void> arg0)>>
                  ptr) =>
          objc.ObjCBlock<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>)>(
              objc.newPointerBlock(_ObjCBlock_objcObjCObject_ffiVoid_fnPtrCallable, ptr.cast()),
              retain: false,
              release: true);

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC.
  static objc
      .ObjCBlock<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>)>
      fromFunction(objc.ObjCObjectBase Function(ffi.Pointer<ffi.Void>) fn,
              {bool keepIsolateAlive = true}) =>
          objc.ObjCBlock<
                  ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>)>(
              objc.newClosureBlock(
                  _ObjCBlock_objcObjCObject_ffiVoid_closureCallable,
                  (ffi.Pointer<ffi.Void> arg0) =>
                      fn(arg0).ref.retainAndAutorelease(),
                  keepIsolateAlive),
              retain: false,
              release: true);
}

/// Call operator for `objc.ObjCBlock<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>)>`.
extension ObjCBlock_objcObjCObject_ffiVoid_CallExtension on objc
    .ObjCBlock<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>)> {
  objc.ObjCObjectBase call(ffi.Pointer<ffi.Void> arg0) => objc.ObjCObjectBase(
      ref.pointer.ref.invoke
          .cast<
              ffi.NativeFunction<
                  ffi.Pointer<objc.ObjCObject> Function(
                      ffi.Pointer<objc.ObjCBlockImpl> block,
                      ffi.Pointer<ffi.Void> arg0)>>()
          .asFunction<
              ffi.Pointer<objc.ObjCObject> Function(
                  ffi.Pointer<objc.ObjCBlockImpl>,
                  ffi.Pointer<ffi.Void>)>()(ref.pointer, arg0),
      retain: true,
      release: true);
}

ffi.Pointer<objc.ObjCObject>
    _ObjCBlock_objcObjCObject_ffiVoid_NSZone_fnPtrTrampoline(
            ffi.Pointer<objc.ObjCBlockImpl> block,
            ffi.Pointer<ffi.Void> arg0,
            ffi.Pointer<NSZone> arg1) =>
        block.ref.target
            .cast<
                ffi.NativeFunction<
                    ffi.Pointer<objc.ObjCObject> Function(
                        ffi.Pointer<ffi.Void> arg0,
                        ffi.Pointer<NSZone> arg1)>>()
            .asFunction<
                ffi.Pointer<objc.ObjCObject> Function(
                    ffi.Pointer<ffi.Void>, ffi.Pointer<NSZone>)>()(arg0, arg1);
ffi.Pointer<ffi.Void> _ObjCBlock_objcObjCObject_ffiVoid_NSZone_fnPtrCallable =
    ffi.Pointer.fromFunction<
                ffi.Pointer<objc.ObjCObject> Function(
                    ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<ffi.Void>,
                    ffi.Pointer<NSZone>)>(
            _ObjCBlock_objcObjCObject_ffiVoid_NSZone_fnPtrTrampoline)
        .cast();
ffi.Pointer<objc.ObjCObject>
    _ObjCBlock_objcObjCObject_ffiVoid_NSZone_closureTrampoline(
            ffi.Pointer<objc.ObjCBlockImpl> block,
            ffi.Pointer<ffi.Void> arg0,
            ffi.Pointer<NSZone> arg1) =>
        (objc.getBlockClosure(block) as ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<ffi.Void>, ffi.Pointer<NSZone>))(arg0, arg1);
ffi.Pointer<ffi.Void> _ObjCBlock_objcObjCObject_ffiVoid_NSZone_closureCallable =
    ffi.Pointer.fromFunction<
                ffi.Pointer<objc.ObjCObject> Function(
                    ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<ffi.Void>,
                    ffi.Pointer<NSZone>)>(
            _ObjCBlock_objcObjCObject_ffiVoid_NSZone_closureTrampoline)
        .cast();

/// Construction methods for `objc.ObjCBlock<objc.Retained<ffi.Pointer<objc.ObjCObject>> Function(ffi.Pointer<ffi.Void>, ffi.Pointer<NSZone>)>`.
abstract final class ObjCBlock_objcObjCObject_ffiVoid_NSZone {
  /// Returns a block that wraps the given raw block pointer.
  static objc.ObjCBlock<
          objc.Retained<ffi.Pointer<objc.ObjCObject>> Function(
              ffi.Pointer<ffi.Void>, ffi.Pointer<NSZone>)>
      castFromPointer(ffi.Pointer<objc.ObjCBlockImpl> pointer,
              {bool retain = false, bool release = false}) =>
          objc.ObjCBlock<
                  objc.Retained<ffi.Pointer<objc.ObjCObject>> Function(
                      ffi.Pointer<ffi.Void>, ffi.Pointer<NSZone>)>(pointer,
              retain: retain, release: release);

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  static objc.ObjCBlock<
          objc.Retained<ffi.Pointer<objc.ObjCObject>> Function(
              ffi.Pointer<ffi.Void>, ffi.Pointer<NSZone>)>
      fromFunctionPointer(ffi.Pointer<ffi.NativeFunction<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void> arg0, ffi.Pointer<NSZone> arg1)>> ptr) =>
          objc.ObjCBlock<
                  objc.Retained<ffi.Pointer<objc.ObjCObject>> Function(
                      ffi.Pointer<ffi.Void>, ffi.Pointer<NSZone>)>(
              objc.newPointerBlock(_ObjCBlock_objcObjCObject_ffiVoid_NSZone_fnPtrCallable, ptr.cast()),
              retain: false,
              release: true);

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC.
  static objc.ObjCBlock<objc.Retained<ffi.Pointer<objc.ObjCObject>> Function(ffi.Pointer<ffi.Void>, ffi.Pointer<NSZone>)>
      fromFunction(objc.ObjCObjectBase Function(ffi.Pointer<ffi.Void>, ffi.Pointer<NSZone>) fn,
              {bool keepIsolateAlive = true}) =>
          objc.ObjCBlock<
                  objc.Retained<ffi.Pointer<objc.ObjCObject>> Function(
                      ffi.Pointer<ffi.Void>, ffi.Pointer<NSZone>)>(
              objc.newClosureBlock(
                  _ObjCBlock_objcObjCObject_ffiVoid_NSZone_closureCallable,
                  (ffi.Pointer<ffi.Void> arg0, ffi.Pointer<NSZone> arg1) =>
                      fn(arg0, arg1).ref.retainAndReturnPointer(),
                  keepIsolateAlive),
              retain: false,
              release: true);
}

/// Call operator for `objc.ObjCBlock<objc.Retained<ffi.Pointer<objc.ObjCObject>> Function(ffi.Pointer<ffi.Void>, ffi.Pointer<NSZone>)>`.
extension ObjCBlock_objcObjCObject_ffiVoid_NSZone_CallExtension
    on objc.ObjCBlock<
        objc.Retained<ffi.Pointer<objc.ObjCObject>> Function(
            ffi.Pointer<ffi.Void>, ffi.Pointer<NSZone>)> {
  objc.ObjCObjectBase call(
          ffi.Pointer<ffi.Void> arg0, ffi.Pointer<NSZone> arg1) =>
      objc.ObjCObjectBase(
          ref.pointer.ref.invoke
              .cast<
                  ffi.NativeFunction<
                      ffi.Pointer<objc.ObjCObject> Function(
                          ffi.Pointer<objc.ObjCBlockImpl> block,
                          ffi.Pointer<ffi.Void> arg0,
                          ffi.Pointer<NSZone> arg1)>>()
              .asFunction<
                  ffi.Pointer<objc.ObjCObject> Function(
                      ffi.Pointer<objc.ObjCBlockImpl>,
                      ffi.Pointer<ffi.Void>,
                      ffi.Pointer<NSZone>)>()(ref.pointer, arg0, arg1),
          retain: false,
          release: true);
}

ffi.Pointer<objc.ObjCObject>
    _ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_fnPtrTrampoline(
            ffi.Pointer<objc.ObjCBlockImpl> block,
            ffi.Pointer<ffi.Void> arg0,
            ffi.Pointer<objc.ObjCSelector> arg1) =>
        block.ref.target
            .cast<
                ffi.NativeFunction<
                    ffi.Pointer<objc.ObjCObject> Function(
                        ffi.Pointer<ffi.Void> arg0,
                        ffi.Pointer<objc.ObjCSelector> arg1)>>()
            .asFunction<
                ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>,
                    ffi.Pointer<objc.ObjCSelector>)>()(arg0, arg1);
ffi.Pointer<ffi.Void>
    _ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_fnPtrCallable =
    ffi.Pointer.fromFunction<
                ffi.Pointer<objc.ObjCObject> Function(
                    ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<ffi.Void>,
                    ffi.Pointer<objc.ObjCSelector>)>(
            _ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_fnPtrTrampoline)
        .cast();
ffi.Pointer<objc.ObjCObject>
    _ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_closureTrampoline(
            ffi.Pointer<objc.ObjCBlockImpl> block,
            ffi.Pointer<ffi.Void> arg0,
            ffi.Pointer<objc.ObjCSelector> arg1) =>
        (objc.getBlockClosure(block) as ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>))(arg0, arg1);
ffi.Pointer<ffi.Void>
    _ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_closureCallable =
    ffi.Pointer.fromFunction<
                ffi.Pointer<objc.ObjCObject> Function(
                    ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<ffi.Void>,
                    ffi.Pointer<objc.ObjCSelector>)>(
            _ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_closureTrampoline)
        .cast();

/// Construction methods for `objc.ObjCBlock<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>)>`.
abstract final class ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector {
  /// Returns a block that wraps the given raw block pointer.
  static objc.ObjCBlock<
          ffi.Pointer<objc.ObjCObject> Function(
              ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>)>
      castFromPointer(ffi.Pointer<objc.ObjCBlockImpl> pointer,
              {bool retain = false, bool release = false}) =>
          objc.ObjCBlock<
                  ffi.Pointer<objc.ObjCObject> Function(
                      ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>)>(
              pointer,
              retain: retain,
              release: release);

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  static objc.ObjCBlock<
          ffi.Pointer<objc.ObjCObject> Function(
              ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>)>
      fromFunctionPointer(ffi.Pointer<ffi.NativeFunction<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void> arg0, ffi.Pointer<objc.ObjCSelector> arg1)>> ptr) =>
          objc.ObjCBlock<
                  ffi.Pointer<objc.ObjCObject> Function(
                      ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>)>(
              objc.newPointerBlock(_ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_fnPtrCallable, ptr.cast()),
              retain: false,
              release: true);

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC.
  static objc.ObjCBlock<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>)> fromFunction(
          objc.ObjCObjectBase Function(
                  ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>)
              fn,
          {bool keepIsolateAlive = true}) =>
      objc.ObjCBlock<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>)>(
          objc.newClosureBlock(
              _ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_closureCallable,
              (ffi.Pointer<ffi.Void> arg0, ffi.Pointer<objc.ObjCSelector> arg1) =>
                  fn(arg0, arg1).ref.retainAndAutorelease(),
              keepIsolateAlive),
          retain: false,
          release: true);
}

/// Call operator for `objc.ObjCBlock<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>)>`.
extension ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_CallExtension
    on objc.ObjCBlock<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>)> {
  objc.ObjCObjectBase call(
          ffi.Pointer<ffi.Void> arg0, ffi.Pointer<objc.ObjCSelector> arg1) =>
      objc.ObjCObjectBase(
          ref.pointer.ref.invoke
                  .cast<
                      ffi.NativeFunction<
                          ffi.Pointer<objc.ObjCObject> Function(
                              ffi.Pointer<objc.ObjCBlockImpl> block,
                              ffi.Pointer<ffi.Void> arg0,
                              ffi.Pointer<objc.ObjCSelector> arg1)>>()
                  .asFunction<
                      ffi.Pointer<objc.ObjCObject> Function(
                          ffi.Pointer<objc.ObjCBlockImpl>,
                          ffi.Pointer<ffi.Void>,
                          ffi.Pointer<objc.ObjCSelector>)>()(
              ref.pointer, arg0, arg1),
          retain: true,
          release: true);
}

ffi.Pointer<objc.ObjCObject>
    _ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_objcObjCObject_fnPtrTrampoline(
            ffi.Pointer<objc.ObjCBlockImpl> block,
            ffi.Pointer<ffi.Void> arg0,
            ffi.Pointer<objc.ObjCSelector> arg1,
            ffi.Pointer<objc.ObjCObject> arg2) =>
        block.ref.target
            .cast<
                ffi.NativeFunction<
                    ffi.Pointer<objc.ObjCObject> Function(
                        ffi.Pointer<ffi.Void> arg0,
                        ffi.Pointer<objc.ObjCSelector> arg1,
                        ffi.Pointer<objc.ObjCObject> arg2)>>()
            .asFunction<
                ffi.Pointer<objc.ObjCObject> Function(
                    ffi.Pointer<ffi.Void>,
                    ffi.Pointer<objc.ObjCSelector>,
                    ffi.Pointer<objc.ObjCObject>)>()(arg0, arg1, arg2);
ffi.Pointer<ffi.Void>
    _ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_objcObjCObject_fnPtrCallable =
    ffi.Pointer.fromFunction<
                ffi.Pointer<objc.ObjCObject> Function(
                    ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<ffi.Void>,
                    ffi.Pointer<objc.ObjCSelector>,
                    ffi.Pointer<objc.ObjCObject>)>(
            _ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_objcObjCObject_fnPtrTrampoline)
        .cast();
ffi.Pointer<objc.ObjCObject>
    _ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_objcObjCObject_closureTrampoline(
            ffi.Pointer<objc.ObjCBlockImpl> block,
            ffi.Pointer<ffi.Void> arg0,
            ffi.Pointer<objc.ObjCSelector> arg1,
            ffi.Pointer<objc.ObjCObject> arg2) =>
        (objc.getBlockClosure(block) as ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<ffi.Void>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>))(arg0, arg1, arg2);
ffi.Pointer<ffi.Void>
    _ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_objcObjCObject_closureCallable =
    ffi.Pointer.fromFunction<
                ffi.Pointer<objc.ObjCObject> Function(
                    ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<ffi.Void>,
                    ffi.Pointer<objc.ObjCSelector>,
                    ffi.Pointer<objc.ObjCObject>)>(
            _ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_objcObjCObject_closureTrampoline)
        .cast();

/// Construction methods for `objc.ObjCBlock<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>`.
abstract final class ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_objcObjCObject {
  /// Returns a block that wraps the given raw block pointer.
  static objc.ObjCBlock<
          ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>,
              ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>
      castFromPointer(ffi.Pointer<objc.ObjCBlockImpl> pointer,
              {bool retain = false, bool release = false}) =>
          objc.ObjCBlock<
                  ffi.Pointer<objc.ObjCObject> Function(
                      ffi.Pointer<ffi.Void>,
                      ffi.Pointer<objc.ObjCSelector>,
                      ffi.Pointer<objc.ObjCObject>)>(pointer,
              retain: retain, release: release);

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  static objc.ObjCBlock<
          ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>,
              ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>
      fromFunctionPointer(ffi.Pointer<ffi.NativeFunction<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void> arg0, ffi.Pointer<objc.ObjCSelector> arg1, ffi.Pointer<objc.ObjCObject> arg2)>> ptr) =>
          objc.ObjCBlock<
                  ffi.Pointer<objc.ObjCObject> Function(
                      ffi.Pointer<ffi.Void>,
                      ffi.Pointer<objc.ObjCSelector>,
                      ffi.Pointer<objc.ObjCObject>)>(
              objc.newPointerBlock(_ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_objcObjCObject_fnPtrCallable, ptr.cast()),
              retain: false,
              release: true);

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC.
  static objc.ObjCBlock<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>
      fromFunction(objc.ObjCObjectBase Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>, objc.ObjCObjectBase) fn,
              {bool keepIsolateAlive = true}) =>
          objc.ObjCBlock<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>(
              objc.newClosureBlock(
                  _ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_objcObjCObject_closureCallable,
                  (ffi.Pointer<ffi.Void> arg0,
                          ffi.Pointer<objc.ObjCSelector> arg1,
                          ffi.Pointer<objc.ObjCObject> arg2) =>
                      fn(arg0, arg1, objc.ObjCObjectBase(arg2, retain: true, release: true))
                          .ref
                          .retainAndAutorelease(),
                  keepIsolateAlive),
              retain: false,
              release: true);
}

/// Call operator for `objc.ObjCBlock<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>`.
extension ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_objcObjCObject_CallExtension
    on objc.ObjCBlock<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)> {
  objc.ObjCObjectBase call(ffi.Pointer<ffi.Void> arg0,
          ffi.Pointer<objc.ObjCSelector> arg1, objc.ObjCObjectBase arg2) =>
      objc.ObjCObjectBase(
          ref.pointer.ref.invoke
                  .cast<
                      ffi.NativeFunction<
                          ffi.Pointer<objc.ObjCObject> Function(
                              ffi.Pointer<objc.ObjCBlockImpl> block,
                              ffi.Pointer<ffi.Void> arg0,
                              ffi.Pointer<objc.ObjCSelector> arg1,
                              ffi.Pointer<objc.ObjCObject> arg2)>>()
                  .asFunction<
                      ffi.Pointer<objc.ObjCObject> Function(
                          ffi.Pointer<objc.ObjCBlockImpl>,
                          ffi.Pointer<ffi.Void>,
                          ffi.Pointer<objc.ObjCSelector>,
                          ffi.Pointer<objc.ObjCObject>)>()(
              ref.pointer, arg0, arg1, arg2.ref.pointer),
          retain: true,
          release: true);
}

ffi.Pointer<objc.ObjCObject>
    _ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_objcObjCObject_objcObjCObject_fnPtrTrampoline(
            ffi.Pointer<objc.ObjCBlockImpl> block,
            ffi.Pointer<ffi.Void> arg0,
            ffi.Pointer<objc.ObjCSelector> arg1,
            ffi.Pointer<objc.ObjCObject> arg2,
            ffi.Pointer<objc.ObjCObject> arg3) =>
        block.ref.target
            .cast<
                ffi.NativeFunction<
                    ffi.Pointer<objc.ObjCObject> Function(
                        ffi.Pointer<ffi.Void> arg0,
                        ffi.Pointer<objc.ObjCSelector> arg1,
                        ffi.Pointer<objc.ObjCObject> arg2,
                        ffi.Pointer<objc.ObjCObject> arg3)>>()
            .asFunction<
                ffi.Pointer<objc.ObjCObject> Function(
                    ffi.Pointer<ffi.Void>,
                    ffi.Pointer<objc.ObjCSelector>,
                    ffi.Pointer<objc.ObjCObject>,
                    ffi.Pointer<objc.ObjCObject>)>()(arg0, arg1, arg2, arg3);
ffi.Pointer<ffi.Void>
    _ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_objcObjCObject_objcObjCObject_fnPtrCallable =
    ffi.Pointer.fromFunction<
                ffi.Pointer<objc.ObjCObject> Function(
                    ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<ffi.Void>,
                    ffi.Pointer<objc.ObjCSelector>,
                    ffi.Pointer<objc.ObjCObject>,
                    ffi.Pointer<objc.ObjCObject>)>(
            _ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_objcObjCObject_objcObjCObject_fnPtrTrampoline)
        .cast();
ffi.Pointer<objc.ObjCObject>
    _ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_objcObjCObject_objcObjCObject_closureTrampoline(
            ffi.Pointer<objc.ObjCBlockImpl> block,
            ffi.Pointer<ffi.Void> arg0,
            ffi.Pointer<objc.ObjCSelector> arg1,
            ffi.Pointer<objc.ObjCObject> arg2,
            ffi.Pointer<objc.ObjCObject> arg3) =>
        (objc.getBlockClosure(block) as ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<ffi.Void>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>))(arg0, arg1, arg2, arg3);
ffi.Pointer<ffi.Void>
    _ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_objcObjCObject_objcObjCObject_closureCallable =
    ffi.Pointer.fromFunction<
                ffi.Pointer<objc.ObjCObject> Function(
                    ffi.Pointer<objc.ObjCBlockImpl>,
                    ffi.Pointer<ffi.Void>,
                    ffi.Pointer<objc.ObjCSelector>,
                    ffi.Pointer<objc.ObjCObject>,
                    ffi.Pointer<objc.ObjCObject>)>(
            _ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_objcObjCObject_objcObjCObject_closureTrampoline)
        .cast();

/// Construction methods for `objc.ObjCBlock<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCObject>)>`.
abstract final class ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_objcObjCObject_objcObjCObject {
  /// Returns a block that wraps the given raw block pointer.
  static objc.ObjCBlock<
          ffi.Pointer<objc.ObjCObject> Function(
              ffi.Pointer<ffi.Void>,
              ffi.Pointer<objc.ObjCSelector>,
              ffi.Pointer<objc.ObjCObject>,
              ffi.Pointer<objc.ObjCObject>)>
      castFromPointer(ffi.Pointer<objc.ObjCBlockImpl> pointer,
              {bool retain = false, bool release = false}) =>
          objc.ObjCBlock<
              ffi.Pointer<objc.ObjCObject> Function(
                  ffi.Pointer<ffi.Void>,
                  ffi.Pointer<objc.ObjCSelector>,
                  ffi.Pointer<objc.ObjCObject>,
                  ffi.Pointer<objc.ObjCObject>)>(pointer, retain: retain, release: release);

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  static objc.ObjCBlock<
          ffi.Pointer<objc.ObjCObject> Function(
              ffi.Pointer<ffi.Void>,
              ffi.Pointer<objc.ObjCSelector>,
              ffi.Pointer<objc.ObjCObject>,
              ffi.Pointer<objc.ObjCObject>)>
      fromFunctionPointer(ffi.Pointer<ffi.NativeFunction<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void> arg0, ffi.Pointer<objc.ObjCSelector> arg1, ffi.Pointer<objc.ObjCObject> arg2, ffi.Pointer<objc.ObjCObject> arg3)>> ptr) =>
          objc.ObjCBlock<
                  ffi.Pointer<objc.ObjCObject> Function(
                      ffi.Pointer<ffi.Void>,
                      ffi.Pointer<objc.ObjCSelector>,
                      ffi.Pointer<objc.ObjCObject>,
                      ffi.Pointer<objc.ObjCObject>)>(
              objc.newPointerBlock(_ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_objcObjCObject_objcObjCObject_fnPtrCallable, ptr.cast()),
              retain: false,
              release: true);

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  ///
  /// If `keepIsolateAlive` is true, this block will keep this isolate alive
  /// until it is garbage collected by both Dart and ObjC.
  static objc
      .ObjCBlock<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCObject>)>
      fromFunction(objc.ObjCObjectBase Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>, objc.ObjCObjectBase, objc.ObjCObjectBase) fn,
              {bool keepIsolateAlive = true}) =>
          objc.ObjCBlock<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCObject>)>(
              objc.newClosureBlock(
                  _ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_objcObjCObject_objcObjCObject_closureCallable,
                  (ffi.Pointer<ffi.Void> arg0,
                          ffi.Pointer<objc.ObjCSelector> arg1,
                          ffi.Pointer<objc.ObjCObject> arg2,
                          ffi.Pointer<objc.ObjCObject> arg3) =>
                      fn(arg0, arg1, objc.ObjCObjectBase(arg2, retain: true, release: true), objc.ObjCObjectBase(arg3, retain: true, release: true)).ref.retainAndAutorelease(),
                  keepIsolateAlive),
              retain: false,
              release: true);
}

/// Call operator for `objc.ObjCBlock<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>, ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCObject>)>`.
extension ObjCBlock_objcObjCObject_ffiVoid_objcObjCSelector_objcObjCObject_objcObjCObject_CallExtension
    on objc.ObjCBlock<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<ffi.Void>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)> {
  objc.ObjCObjectBase call(
          ffi.Pointer<ffi.Void> arg0,
          ffi.Pointer<objc.ObjCSelector> arg1,
          objc.ObjCObjectBase arg2,
          objc.ObjCObjectBase arg3) =>
      objc.ObjCObjectBase(
          ref.pointer.ref.invoke
              .cast<
                  ffi.NativeFunction<
                      ffi.Pointer<objc.ObjCObject> Function(
                          ffi.Pointer<objc.ObjCBlockImpl> block,
                          ffi.Pointer<ffi.Void> arg0,
                          ffi.Pointer<objc.ObjCSelector> arg1,
                          ffi.Pointer<objc.ObjCObject> arg2,
                          ffi.Pointer<objc.ObjCObject> arg3)>>()
              .asFunction<
                  ffi.Pointer<objc.ObjCObject> Function(
                      ffi.Pointer<objc.ObjCBlockImpl>,
                      ffi.Pointer<ffi.Void>,
                      ffi.Pointer<objc.ObjCSelector>,
                      ffi.Pointer<objc.ObjCObject>,
                      ffi.Pointer<objc.ObjCObject>)>()(ref.pointer, arg0, arg1, arg2.ref.pointer, arg3.ref.pointer),
          retain: true,
          release: true);
}

/// Protocol
class Protocol extends objc.ObjCObjectBase {
  Protocol._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super(pointer, retain: retain, release: release);

  /// Constructs a [Protocol] that points to the same underlying object as [other].
  Protocol.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [Protocol] that wraps the given raw object pointer.
  Protocol.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [Protocol].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_19nvye5(
        obj.ref.pointer, _sel_isKindOfClass_, _class_Protocol);
  }
}

late final _class_DOBJCDartInputStreamAdapter =
    objc.getClass("DOBJCDartInputStreamAdapter");
late final _class_DOBJCDartProtocol = objc.getClass("DOBJCDartProtocol");
late final _class_DOBJCDartProtocolBuilder =
    objc.getClass("DOBJCDartProtocolBuilder");
late final _class_NSArray = objc.getClass("NSArray");
late final _class_NSCharacterSet = objc.getClass("NSCharacterSet");
late final _class_NSCoder = objc.getClass("NSCoder");
late final _class_NSData = objc.getClass("NSData");
late final _class_NSDate = objc.getClass("NSDate");
late final _class_NSDictionary = objc.getClass("NSDictionary");
late final _class_NSEnumerator = objc.getClass("NSEnumerator");
late final _class_NSError = objc.getClass("NSError");
late final _class_NSIndexSet = objc.getClass("NSIndexSet");
late final _class_NSInputStream = objc.getClass("NSInputStream");
late final _class_NSInvocation = objc.getClass("NSInvocation");
late final _class_NSItemProvider = objc.getClass("NSItemProvider");
late final _class_NSLocale = objc.getClass("NSLocale");
late final _class_NSMethodSignature = objc.getClass("NSMethodSignature");
late final _class_NSMutableArray = objc.getClass("NSMutableArray");
late final _class_NSMutableData = objc.getClass("NSMutableData");
late final _class_NSMutableDictionary = objc.getClass("NSMutableDictionary");
late final _class_NSMutableIndexSet = objc.getClass("NSMutableIndexSet");
late final _class_NSMutableOrderedSet = objc.getClass("NSMutableOrderedSet");
late final _class_NSMutableSet = objc.getClass("NSMutableSet");
late final _class_NSMutableString = objc.getClass("NSMutableString");
late final _class_NSNotification = objc.getClass("NSNotification");
late final _class_NSNumber = objc.getClass("NSNumber");
late final _class_NSObject = objc.getClass("NSObject");
late final _class_NSOrderedCollectionDifference =
    objc.getClass("NSOrderedCollectionDifference");
late final _class_NSOrderedSet = objc.getClass("NSOrderedSet");
late final _class_NSOutputStream = objc.getClass("NSOutputStream");
late final _class_NSRunLoop = objc.getClass("NSRunLoop");
late final _class_NSSet = objc.getClass("NSSet");
late final _class_NSStream = objc.getClass("NSStream");
late final _class_NSString = objc.getClass("NSString");
late final _class_NSURL = objc.getClass("NSURL");
late final _class_NSURLHandle = objc.getClass("NSURLHandle");
late final _class_NSValue = objc.getClass("NSValue");
late final _class_Protocol = objc.getClass("Protocol");
final _objc_msgSend_102xxo4 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            NSRange Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong)>>()
    .asFunction<
        NSRange Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
final _objc_msgSend_102xxo4Stret = objc.msgSendStretPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<NSRange>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong)>>()
    .asFunction<
        void Function(
            ffi.Pointer<NSRange>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
final _objc_msgSend_11cbyu0 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.UnsignedLong,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_11e9f5x = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Long Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Uint8>,
                ffi.UnsignedLong)>>()
    .asFunction<
        int Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.Uint8>, int)>();
final _objc_msgSend_11spmsz = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_122v0cv = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                NSRange,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                ffi.UnsignedLong)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            NSRange,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            int)>();
final _objc_msgSend_12py2ux = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.UnsignedLong Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.UnsignedLong)>>()
    .asFunction<
        int Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
final _objc_msgSend_13mclwd = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Char)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
final _objc_msgSend_13yqbb6 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Int Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_14hpxwa = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.UnsignedLong)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
final _objc_msgSend_14hvw5k = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
final _objc_msgSend_151sglz = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_158ju31 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Uint8>,
                ffi.UnsignedLong)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.Uint8>, int)>();
final _objc_msgSend_15bolr3 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                NSRange,
                ffi.Pointer<objc.ObjCObject>,
                NSRange)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            NSRange,
            ffi.Pointer<objc.ObjCObject>,
            NSRange)>();
final _objc_msgSend_15qeuct = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_161ne8y = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Void>,
                ffi.UnsignedLong,
                ffi.Bool)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.Void>,
            int,
            bool)>();
final _objc_msgSend_16f0drb = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.LongLong)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
final _objc_msgSend_16fy0up = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Long Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        int Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_17amj0z = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Bool)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            bool)>();
final _objc_msgSend_182fzon = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            NSRange Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        NSRange Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_182fzonStret = objc.msgSendStretPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<NSRange>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<NSRange>, ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_1895u4n = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Long Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong,
                NSRange,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            NSRange,
            ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_18qun1e = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCBlockImpl>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCBlockImpl>)>();
final _objc_msgSend_19lrthf = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Pointer<ffi.Uint8>>,
                ffi.Pointer<ffi.UnsignedLong>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.Pointer<ffi.Uint8>>,
            ffi.Pointer<ffi.UnsignedLong>)>();
final _objc_msgSend_19nvye5 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_1alewu7 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.UnsignedLong>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.UnsignedLong>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
final _objc_msgSend_1b5ysjl = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.UnsignedLong Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<NSFastEnumerationState>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                ffi.UnsignedLong)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<NSFastEnumerationState>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            int)>();
final _objc_msgSend_1bvics1 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<
                    ffi.NativeFunction<
                        ffi.Long Function(
                            ffi.Pointer<objc.ObjCObject>,
                            ffi.Pointer<objc.ObjCObject>,
                            ffi.Pointer<ffi.Void>)>>,
                ffi.Pointer<ffi.Void>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<
                ffi.NativeFunction<
                    ffi.Long Function(ffi.Pointer<objc.ObjCObject>,
                        ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>)>>,
            ffi.Pointer<ffi.Void>)>();
final _objc_msgSend_1ceswyu = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Bool>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Bool>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
final _objc_msgSend_1co9mn4 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.UnsignedShort)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
final _objc_msgSend_1cwp428 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<NSZone>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<NSZone>)>();
final _objc_msgSend_1d8s65w = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            NSRange Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong,
                NSRange)>>()
    .asFunction<
        NSRange Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            NSRange)>();
final _objc_msgSend_1d8s65wStret = objc.msgSendStretPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<NSRange>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong,
                NSRange)>>()
    .asFunction<
        void Function(
            ffi.Pointer<NSRange>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            NSRange)>();
final _objc_msgSend_1d9e4oe = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_1deg8x = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.UnsignedShort Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.UnsignedLong)>>()
    .asFunction<
        int Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
final _objc_msgSend_1dydpdi = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                ffi.UnsignedLong)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            int)>();
final _objc_msgSend_1e3pm0z = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, NSRange)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, NSRange)>();
final _objc_msgSend_1efxbd8 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.UnsignedLong Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_1ffoev1 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<
                    ffi.NativeFunction<
                        ffi.Long Function(
                            ffi.Pointer<objc.ObjCObject>,
                            ffi.Pointer<objc.ObjCObject>,
                            ffi.Pointer<ffi.Void>)>>,
                ffi.Pointer<ffi.Void>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<
                ffi.NativeFunction<
                    ffi.Long Function(ffi.Pointer<objc.ObjCObject>,
                        ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>)>>,
            ffi.Pointer<ffi.Void>)>();
final _objc_msgSend_1fuqfwb = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<ffi.Char> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<ffi.Char> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_1ged0jd = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Bool,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            bool,
            ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_1gypgok = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.UnsignedLong,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_1h2q612 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<ffi.UnsignedLong> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<ffi.UnsignedLong> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_1hz7y9r = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Long Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_1i2r70j = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<
                    ffi.NativeFunction<
                        ffi.Long Function(
                            ffi.Pointer<objc.ObjCObject>,
                            ffi.Pointer<objc.ObjCObject>,
                            ffi.Pointer<ffi.Void>)>>,
                ffi.Pointer<ffi.Void>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<
                ffi.NativeFunction<
                    ffi.Long Function(ffi.Pointer<objc.ObjCObject>,
                        ffi.Pointer<objc.ObjCObject>, ffi.Pointer<ffi.Void>)>>,
            ffi.Pointer<ffi.Void>,
            ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_1i9r4xy = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.UnsignedLong)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
final _objc_msgSend_1iyq28l = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Bool)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            bool)>();
final _objc_msgSend_1j9bhml = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
final _objc_msgSend_1jtxufi = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<ffi.Char> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.UnsignedLong)>>()
    .asFunction<
        ffi.Pointer<ffi.Char> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
final _objc_msgSend_1jwityx = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Short Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_1k0ezzm = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
final _objc_msgSend_1k101e3 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.LongLong Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_1k1o1s7 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, NSRange)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, NSRange)>();
final _objc_msgSend_1k4kd9s = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
final _objc_msgSend_1k745tv = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Long)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
final _objc_msgSend_1ko4qka = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.UnsignedChar Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_1lhpu4m = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
final _objc_msgSend_1lsax7n = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_1lv8yz3 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Char>,
                ffi.UnsignedLong,
                ffi.UnsignedLong)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.Char>, int, int)>();
final _objc_msgSend_1n40f6p = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Char>,
                ffi.Bool,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.Char>,
            bool,
            ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_1njucl2 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.UnsignedShort)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
final _objc_msgSend_1nmlvqc = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            NSRange Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong,
                NSRange)>>()
    .asFunction<
        NSRange Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            NSRange)>();
final _objc_msgSend_1nmlvqcStret = objc.msgSendStretPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<NSRange>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong,
                NSRange)>>()
    .asFunction<
        void Function(
            ffi.Pointer<NSRange>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            NSRange)>();
final _objc_msgSend_1nomli1 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
final _objc_msgSend_1oteutl = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                NSRange)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            NSRange)>();
final _objc_msgSend_1ozwf6k = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Double,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            double,
            ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_1p4gbjy = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.UnsignedLongLong Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_1pa9f4m = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<ffi.NativeFunction<ffi.Void Function()>> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<ffi.NativeFunction<ffi.Void Function()>> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_1pl9qdv = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_1pnyuds = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
final _objc_msgSend_1qv0eq4 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_1s2gdyk = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Void>,
                ffi.Pointer<ffi.Void>,
                ffi.Pointer<ffi.Char>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.Void>,
            ffi.Pointer<ffi.Void>,
            ffi.Pointer<ffi.Char>)>();
final _objc_msgSend_1sotr3r = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_1srf6wk = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_1t6aok9 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Bool)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, bool)>();
final _objc_msgSend_1tfztp = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.UnsignedLong,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
final _objc_msgSend_1tiux5i = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
final _objc_msgSend_1tv4uax = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                NSRange,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            NSRange,
            ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_1ukqyt8 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Double Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        double Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_1ukqyt8Fpret = objc.msgSendFpretPointer
    .cast<
        ffi.NativeFunction<
            ffi.Double Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        double Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_1vd1c5m = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.UnsignedLong Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        int Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_1vnlaqg = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Long,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
final _objc_msgSend_1vxoo9h = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
final _objc_msgSend_1wdb8ji = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Long)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
final _objc_msgSend_1wt9a7r = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.UnsignedLong,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            int,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
final _objc_msgSend_1x2hskc = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.UnsignedLongLong)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
final _objc_msgSend_1xi08ar = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
final _objc_msgSend_1ya1kjn = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Int64)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
final _objc_msgSend_1ym6zyw = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Long Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        int Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_2cgrxl = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Float Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        double Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_2cgrxlFpret = objc.msgSendFpretPointer
    .cast<
        ffi.NativeFunction<
            ffi.Float Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        double Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_2u4jm6 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong,
                NSRange)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            NSRange)>();
final _objc_msgSend_3cbdpb = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_3ctkt6 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_3l8zum = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
final _objc_msgSend_3nbx5e = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Void>,
                ffi.UnsignedLong)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.Void>, int)>();
final _objc_msgSend_3pyzne = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.UnsignedInt Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_56zxyn = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.Char>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.Char>)>();
final _objc_msgSend_68x6r1 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Short)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
final _objc_msgSend_6ex6p5 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<ffi.Void> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<ffi.Void> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_6peh6o = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.UnsignedLong)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
final _objc_msgSend_6z4k82 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
final _objc_msgSend_7g3u2y = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Long)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
final _objc_msgSend_7kpg7m = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
final _objc_msgSend_7uautw = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.UnsignedChar)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
final _objc_msgSend_8321cp = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
final _objc_msgSend_898fog = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.UnsignedShort>,
                NSRange)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.UnsignedShort>,
            NSRange)>();
final _objc_msgSend_89xgla = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.UnsignedLong Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.UnsignedLong>,
                ffi.UnsignedLong,
                ffi.Pointer<NSRange>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.UnsignedLong>,
            int,
            ffi.Pointer<NSRange>)>();
final _objc_msgSend_8cymbm = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Char>,
                ffi.UnsignedLong)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.Char>, int)>();
final _objc_msgSend_91o635 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_9b3h4v = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Void>,
                ffi.UnsignedLong,
                ffi.UnsignedLong)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.Void>, int, int)>();
final _objc_msgSend_9x4k8x = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.UnsignedShort>,
                ffi.UnsignedLong)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.UnsignedShort>,
            int)>();
final _objc_msgSend_bfp043 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.UnsignedLong,
                ffi.UnsignedLong)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int, int)>();
final _objc_msgSend_bstjp9 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                NSRange,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            NSRange,
            ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_c0vg4w = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                NSRange,
                ffi.Pointer<ffi.Void>,
                ffi.UnsignedLong)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            NSRange,
            ffi.Pointer<ffi.Void>,
            int)>();
final _objc_msgSend_cfx8ce = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_d3i1uy = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            NSRange Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.UnsignedLong)>>()
    .asFunction<
        NSRange Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
final _objc_msgSend_d3i1uyStret = objc.msgSendStretPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<NSRange>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.UnsignedLong)>>()
    .asFunction<
        void Function(ffi.Pointer<NSRange>, ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
final _objc_msgSend_dbvvll = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Int64)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
final _objc_msgSend_degb40 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.UnsignedInt)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
final _objc_msgSend_diypgk = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
final _objc_msgSend_djsa9o = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
final _objc_msgSend_dv3z6r = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Bool,
                ffi.UnsignedLong,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            bool,
            int,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
final _objc_msgSend_e3qsqz = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCProtocol>)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCProtocol>)>();
final _objc_msgSend_e9mncn = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Void>,
                ffi.Pointer<ffi.Char>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.Void>,
            ffi.Pointer<ffi.Char>)>();
final _objc_msgSend_eh32gn = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                NSRange,
                ffi.Pointer<ffi.Void>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, NSRange, ffi.Pointer<ffi.Void>)>();
final _objc_msgSend_erqryg = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Char>,
                ffi.UnsignedLong)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.Char>, int)>();
final _objc_msgSend_et8cuh = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Float)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, double)>();
final _objc_msgSend_gcjqkl = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                ffi.UnsignedLong)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            int)>();
final _objc_msgSend_gerswc = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Uint8)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
final _objc_msgSend_gg0462 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            NSRange Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong,
                NSRange,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        NSRange Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            NSRange,
            ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_gg0462Stret = objc.msgSendStretPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<NSRange>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong,
                NSRange,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<NSRange>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            NSRange,
            ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_gx50so = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_hiwitm = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.UnsignedLong, ffi.Bool)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int, bool)>();
final _objc_msgSend_i30zh3 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Void>,
                ffi.UnsignedLong,
                ffi.Pointer<ffi.UnsignedLong>,
                ffi.UnsignedLong,
                ffi.UnsignedLong,
                NSRange,
                ffi.Pointer<NSRange>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.Void>,
            int,
            ffi.Pointer<ffi.UnsignedLong>,
            int,
            int,
            NSRange,
            ffi.Pointer<NSRange>)>();
final _objc_msgSend_jsclrq = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.UnsignedInt)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
final _objc_msgSend_k4j8m3 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Void>,
                ffi.UnsignedLong,
                ffi.UnsignedLong,
                ffi.Bool)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.Void>,
            int,
            int,
            bool)>();
final _objc_msgSend_l9p60w = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
final _objc_msgSend_lh0jh5 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.UnsignedShort>,
                ffi.UnsignedLong,
                ffi.Bool)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.UnsignedShort>,
            int,
            bool)>();
final _objc_msgSend_mabicu = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Double Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        double Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_mabicuFpret = objc.msgSendFpretPointer
    .cast<
        ffi.NativeFunction<
            ffi.Double Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        double Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_n2svg2 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                ffi.UnsignedLong)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            int)>();
final _objc_msgSend_o16d3k = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                NSRange)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            NSRange)>();
final _objc_msgSend_oa8mke = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Double)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, double)>();
final _objc_msgSend_otx1t4 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.UnsignedLong, ffi.Long)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int, int)>();
final _objc_msgSend_ourvf2 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.UnsignedLong>,
                ffi.Pointer<ffi.UnsignedLong>,
                ffi.Pointer<ffi.UnsignedLong>,
                NSRange)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.UnsignedLong>,
            ffi.Pointer<ffi.UnsignedLong>,
            ffi.Pointer<ffi.UnsignedLong>,
            NSRange)>();
final _objc_msgSend_p4nurx = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, NSRange)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, NSRange)>();
final _objc_msgSend_pfv6jd = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_pg1fnv = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Long Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int)>();
final _objc_msgSend_qm9f5w = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.UnsignedLong Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, NSRange)>>()
    .asFunction<
        int Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, NSRange)>();
final _objc_msgSend_qugqlf = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Long)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
final _objc_msgSend_rc4ypv = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Long,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_s92gih = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_sz90oi = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<NSZone> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<NSZone> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_ud8gg = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.UnsignedShort Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_uimyc7 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            NSRange Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, NSRange)>>()
    .asFunction<
        NSRange Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, NSRange)>();
final _objc_msgSend_uimyc7Stret = objc.msgSendStretPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<NSRange>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                NSRange)>>()
    .asFunction<
        void Function(ffi.Pointer<NSRange>, ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, NSRange)>();
final _objc_msgSend_w9bq5x = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                NSRange,
                ffi.Bool)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            NSRange,
            bool)>();
final _objc_msgSend_xmlz1t = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Char Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_xpqfd7 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Void>,
                NSRange)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.Void>, NSRange)>();
final _objc_msgSend_xrqic1 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Long Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.UnsignedLong,
                NSRange)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            int,
            NSRange)>();
final _objc_msgSend_xtuoz7 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
final _objc_msgSend_xw2lbc = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.UnsignedLong Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_zmbtbd = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
                ffi.UnsignedLong)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>,
            int)>();
final _objc_msgSend_zuf90e = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<ffi.Void>,
                ffi.UnsignedLong)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<ffi.Void>, int)>();
final _objc_msgSend_zug4wi = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.UnsignedLong Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                NSRange)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            NSRange)>();
late final _protocol_NSCoding = objc.getProtocol("NSCoding");
late final _protocol_NSCopying = objc.getProtocol("NSCopying");
late final _protocol_NSFastEnumeration = objc.getProtocol("NSFastEnumeration");
late final _protocol_NSItemProviderReading =
    objc.getProtocol("NSItemProviderReading");
late final _protocol_NSItemProviderWriting =
    objc.getProtocol("NSItemProviderWriting");
late final _protocol_NSMutableCopying = objc.getProtocol("NSMutableCopying");
late final _protocol_NSObject = objc.getProtocol("NSObject");
late final _protocol_NSSecureCoding = objc.getProtocol("NSSecureCoding");
late final _protocol_NSStreamDelegate = objc.getProtocol("NSStreamDelegate");
late final _sel_URLByResolvingAliasFileAtURL_options_error_ =
    objc.registerName("URLByResolvingAliasFileAtURL:options:error:");
late final _sel_URLByResolvingBookmarkData_options_relativeToURL_bookmarkDataIsStale_error_ =
    objc.registerName(
        "URLByResolvingBookmarkData:options:relativeToURL:bookmarkDataIsStale:error:");
late final _sel_URLWithDataRepresentation_relativeToURL_ =
    objc.registerName("URLWithDataRepresentation:relativeToURL:");
late final _sel_URLWithString_ = objc.registerName("URLWithString:");
late final _sel_URLWithString_encodingInvalidCharacters_ =
    objc.registerName("URLWithString:encodingInvalidCharacters:");
late final _sel_URLWithString_relativeToURL_ =
    objc.registerName("URLWithString:relativeToURL:");
late final _sel_UTF8String = objc.registerName("UTF8String");
late final _sel_absoluteString = objc.registerName("absoluteString");
late final _sel_absoluteURL = objc.registerName("absoluteURL");
late final _sel_absoluteURLWithDataRepresentation_relativeToURL_ =
    objc.registerName("absoluteURLWithDataRepresentation:relativeToURL:");
late final _sel_addData_ = objc.registerName("addData:");
late final _sel_addEntriesFromDictionary_ =
    objc.registerName("addEntriesFromDictionary:");
late final _sel_addIndex_ = objc.registerName("addIndex:");
late final _sel_addIndexesInRange_ = objc.registerName("addIndexesInRange:");
late final _sel_addIndexes_ = objc.registerName("addIndexes:");
late final _sel_addObject_ = objc.registerName("addObject:");
late final _sel_addObjectsFromArray_ =
    objc.registerName("addObjectsFromArray:");
late final _sel_addObjects_count_ = objc.registerName("addObjects:count:");
late final _sel_addProtocol_ = objc.registerName("addProtocol:");
late final _sel_allKeys = objc.registerName("allKeys");
late final _sel_allKeysForObject_ = objc.registerName("allKeysForObject:");
late final _sel_allObjects = objc.registerName("allObjects");
late final _sel_allValues = objc.registerName("allValues");
late final _sel_alloc = objc.registerName("alloc");
late final _sel_allocWithZone_ = objc.registerName("allocWithZone:");
late final _sel_alphanumericCharacterSet =
    objc.registerName("alphanumericCharacterSet");
late final _sel_anyObject = objc.registerName("anyObject");
late final _sel_appendBytes_length_ = objc.registerName("appendBytes:length:");
late final _sel_appendData_ = objc.registerName("appendData:");
late final _sel_array = objc.registerName("array");
late final _sel_arrayByAddingObject_ =
    objc.registerName("arrayByAddingObject:");
late final _sel_arrayByAddingObjectsFromArray_ =
    objc.registerName("arrayByAddingObjectsFromArray:");
late final _sel_arrayWithArray_ = objc.registerName("arrayWithArray:");
late final _sel_arrayWithCapacity_ = objc.registerName("arrayWithCapacity:");
late final _sel_arrayWithObject_ = objc.registerName("arrayWithObject:");
late final _sel_arrayWithObjects_ = objc.registerName("arrayWithObjects:");
late final _sel_arrayWithObjects_count_ =
    objc.registerName("arrayWithObjects:count:");
late final _sel_autorelease = objc.registerName("autorelease");
late final _sel_availableStringEncodings =
    objc.registerName("availableStringEncodings");
late final _sel_baseURL = objc.registerName("baseURL");
late final _sel_bitmapRepresentation =
    objc.registerName("bitmapRepresentation");
late final _sel_bookmarkDataWithContentsOfURL_error_ =
    objc.registerName("bookmarkDataWithContentsOfURL:error:");
late final _sel_bookmarkDataWithOptions_includingResourceValuesForKeys_relativeToURL_error_ =
    objc.registerName(
        "bookmarkDataWithOptions:includingResourceValuesForKeys:relativeToURL:error:");
late final _sel_boolValue = objc.registerName("boolValue");
late final _sel_buildInstance_ = objc.registerName("buildInstance:");
late final _sel_bytes = objc.registerName("bytes");
late final _sel_cStringUsingEncoding_ =
    objc.registerName("cStringUsingEncoding:");
late final _sel_canBeConvertedToEncoding_ =
    objc.registerName("canBeConvertedToEncoding:");
late final _sel_canLoadObjectOfClass_ =
    objc.registerName("canLoadObjectOfClass:");
late final _sel_capitalizedLetterCharacterSet =
    objc.registerName("capitalizedLetterCharacterSet");
late final _sel_capitalizedString = objc.registerName("capitalizedString");
late final _sel_capitalizedStringWithLocale_ =
    objc.registerName("capitalizedStringWithLocale:");
late final _sel_caseInsensitiveCompare_ =
    objc.registerName("caseInsensitiveCompare:");
late final _sel_charValue = objc.registerName("charValue");
late final _sel_characterAtIndex_ = objc.registerName("characterAtIndex:");
late final _sel_characterIsMember_ = objc.registerName("characterIsMember:");
late final _sel_characterSetWithBitmapRepresentation_ =
    objc.registerName("characterSetWithBitmapRepresentation:");
late final _sel_characterSetWithCharactersInString_ =
    objc.registerName("characterSetWithCharactersInString:");
late final _sel_characterSetWithContentsOfFile_ =
    objc.registerName("characterSetWithContentsOfFile:");
late final _sel_characterSetWithRange_ =
    objc.registerName("characterSetWithRange:");
late final _sel_class = objc.registerName("class");
late final _sel_close = objc.registerName("close");
late final _sel_code = objc.registerName("code");
late final _sel_commonPrefixWithString_options_ =
    objc.registerName("commonPrefixWithString:options:");
late final _sel_compare_ = objc.registerName("compare:");
late final _sel_compare_options_ = objc.registerName("compare:options:");
late final _sel_compare_options_range_ =
    objc.registerName("compare:options:range:");
late final _sel_compare_options_range_locale_ =
    objc.registerName("compare:options:range:locale:");
late final _sel_componentsJoinedByString_ =
    objc.registerName("componentsJoinedByString:");
late final _sel_componentsSeparatedByCharactersInSet_ =
    objc.registerName("componentsSeparatedByCharactersInSet:");
late final _sel_componentsSeparatedByString_ =
    objc.registerName("componentsSeparatedByString:");
late final _sel_compressedDataUsingAlgorithm_error_ =
    objc.registerName("compressedDataUsingAlgorithm:error:");
late final _sel_conformsToProtocol_ = objc.registerName("conformsToProtocol:");
late final _sel_containsIndex_ = objc.registerName("containsIndex:");
late final _sel_containsIndexesInRange_ =
    objc.registerName("containsIndexesInRange:");
late final _sel_containsIndexes_ = objc.registerName("containsIndexes:");
late final _sel_containsObject_ = objc.registerName("containsObject:");
late final _sel_containsString_ = objc.registerName("containsString:");
late final _sel_controlCharacterSet = objc.registerName("controlCharacterSet");
late final _sel_copy = objc.registerName("copy");
late final _sel_copyWithZone_ = objc.registerName("copyWithZone:");
late final _sel_count = objc.registerName("count");
late final _sel_countByEnumeratingWithState_objects_count_ =
    objc.registerName("countByEnumeratingWithState:objects:count:");
late final _sel_countOfIndexesInRange_ =
    objc.registerName("countOfIndexesInRange:");
late final _sel_data = objc.registerName("data");
late final _sel_dataRepresentation = objc.registerName("dataRepresentation");
late final _sel_dataUsingEncoding_ = objc.registerName("dataUsingEncoding:");
late final _sel_dataUsingEncoding_allowLossyConversion_ =
    objc.registerName("dataUsingEncoding:allowLossyConversion:");
late final _sel_dataWithBytesNoCopy_length_ =
    objc.registerName("dataWithBytesNoCopy:length:");
late final _sel_dataWithBytesNoCopy_length_freeWhenDone_ =
    objc.registerName("dataWithBytesNoCopy:length:freeWhenDone:");
late final _sel_dataWithBytes_length_ =
    objc.registerName("dataWithBytes:length:");
late final _sel_dataWithCapacity_ = objc.registerName("dataWithCapacity:");
late final _sel_dataWithContentsOfFile_ =
    objc.registerName("dataWithContentsOfFile:");
late final _sel_dataWithContentsOfFile_options_error_ =
    objc.registerName("dataWithContentsOfFile:options:error:");
late final _sel_dataWithContentsOfURL_ =
    objc.registerName("dataWithContentsOfURL:");
late final _sel_dataWithContentsOfURL_options_error_ =
    objc.registerName("dataWithContentsOfURL:options:error:");
late final _sel_dataWithData_ = objc.registerName("dataWithData:");
late final _sel_dataWithLength_ = objc.registerName("dataWithLength:");
late final _sel_date = objc.registerName("date");
late final _sel_dateByAddingTimeInterval_ =
    objc.registerName("dateByAddingTimeInterval:");
late final _sel_dateWithTimeIntervalSince1970_ =
    objc.registerName("dateWithTimeIntervalSince1970:");
late final _sel_dateWithTimeIntervalSinceNow_ =
    objc.registerName("dateWithTimeIntervalSinceNow:");
late final _sel_dateWithTimeIntervalSinceReferenceDate_ =
    objc.registerName("dateWithTimeIntervalSinceReferenceDate:");
late final _sel_dateWithTimeInterval_sinceDate_ =
    objc.registerName("dateWithTimeInterval:sinceDate:");
late final _sel_dealloc = objc.registerName("dealloc");
late final _sel_debugDescription = objc.registerName("debugDescription");
late final _sel_decimalDigitCharacterSet =
    objc.registerName("decimalDigitCharacterSet");
late final _sel_decomposableCharacterSet =
    objc.registerName("decomposableCharacterSet");
late final _sel_decomposedStringWithCanonicalMapping =
    objc.registerName("decomposedStringWithCanonicalMapping");
late final _sel_decomposedStringWithCompatibilityMapping =
    objc.registerName("decomposedStringWithCompatibilityMapping");
late final _sel_decompressedDataUsingAlgorithm_error_ =
    objc.registerName("decompressedDataUsingAlgorithm:error:");
late final _sel_defaultCStringEncoding =
    objc.registerName("defaultCStringEncoding");
late final _sel_delegate = objc.registerName("delegate");
late final _sel_description = objc.registerName("description");
late final _sel_descriptionInStringsFileFormat =
    objc.registerName("descriptionInStringsFileFormat");
late final _sel_descriptionWithLocale_ =
    objc.registerName("descriptionWithLocale:");
late final _sel_descriptionWithLocale_indent_ =
    objc.registerName("descriptionWithLocale:indent:");
late final _sel_dictionary = objc.registerName("dictionary");
late final _sel_dictionaryWithCapacity_ =
    objc.registerName("dictionaryWithCapacity:");
late final _sel_dictionaryWithDictionary_ =
    objc.registerName("dictionaryWithDictionary:");
late final _sel_dictionaryWithObject_forKey_ =
    objc.registerName("dictionaryWithObject:forKey:");
late final _sel_dictionaryWithObjectsAndKeys_ =
    objc.registerName("dictionaryWithObjectsAndKeys:");
late final _sel_dictionaryWithObjects_forKeys_ =
    objc.registerName("dictionaryWithObjects:forKeys:");
late final _sel_dictionaryWithObjects_forKeys_count_ =
    objc.registerName("dictionaryWithObjects:forKeys:count:");
late final _sel_doesNotRecognizeSelector_ =
    objc.registerName("doesNotRecognizeSelector:");
late final _sel_domain = objc.registerName("domain");
late final _sel_doubleValue = objc.registerName("doubleValue");
late final _sel_earlierDate_ = objc.registerName("earlierDate:");
late final _sel_encodeWithCoder_ = objc.registerName("encodeWithCoder:");
late final _sel_errorWithDomain_code_userInfo_ =
    objc.registerName("errorWithDomain:code:userInfo:");
late final _sel_exchangeObjectAtIndex_withObjectAtIndex_ =
    objc.registerName("exchangeObjectAtIndex:withObjectAtIndex:");
late final _sel_fastestEncoding = objc.registerName("fastestEncoding");
late final _sel_filePathURL = objc.registerName("filePathURL");
late final _sel_fileReferenceURL = objc.registerName("fileReferenceURL");
late final _sel_fileSystemRepresentation =
    objc.registerName("fileSystemRepresentation");
late final _sel_fileURLWithFileSystemRepresentation_isDirectory_relativeToURL_ =
    objc.registerName(
        "fileURLWithFileSystemRepresentation:isDirectory:relativeToURL:");
late final _sel_fileURLWithPath_ = objc.registerName("fileURLWithPath:");
late final _sel_fileURLWithPath_isDirectory_ =
    objc.registerName("fileURLWithPath:isDirectory:");
late final _sel_fileURLWithPath_isDirectory_relativeToURL_ =
    objc.registerName("fileURLWithPath:isDirectory:relativeToURL:");
late final _sel_fileURLWithPath_relativeToURL_ =
    objc.registerName("fileURLWithPath:relativeToURL:");
late final _sel_firstIndex = objc.registerName("firstIndex");
late final _sel_firstObject = objc.registerName("firstObject");
late final _sel_firstObjectCommonWithArray_ =
    objc.registerName("firstObjectCommonWithArray:");
late final _sel_floatValue = objc.registerName("floatValue");
late final _sel_forwardInvocation_ = objc.registerName("forwardInvocation:");
late final _sel_forwardingTargetForSelector_ =
    objc.registerName("forwardingTargetForSelector:");
late final _sel_fragment = objc.registerName("fragment");
late final _sel_frameLength = objc.registerName("frameLength");
late final _sel_getArgumentTypeAtIndex_ =
    objc.registerName("getArgumentTypeAtIndex:");
late final _sel_getBuffer_length_ = objc.registerName("getBuffer:length:");
late final _sel_getBytes_length_ = objc.registerName("getBytes:length:");
late final _sel_getBytes_maxLength_usedLength_encoding_options_range_remainingRange_ =
    objc.registerName(
        "getBytes:maxLength:usedLength:encoding:options:range:remainingRange:");
late final _sel_getBytes_range_ = objc.registerName("getBytes:range:");
late final _sel_getCString_maxLength_encoding_ =
    objc.registerName("getCString:maxLength:encoding:");
late final _sel_getCharacters_range_ =
    objc.registerName("getCharacters:range:");
late final _sel_getDOBJCDartProtocolMethodForSelector_ =
    objc.registerName("getDOBJCDartProtocolMethodForSelector:");
late final _sel_getFileSystemRepresentation_maxLength_ =
    objc.registerName("getFileSystemRepresentation:maxLength:");
late final _sel_getIndexes_maxCount_inIndexRange_ =
    objc.registerName("getIndexes:maxCount:inIndexRange:");
late final _sel_getLineStart_end_contentsEnd_forRange_ =
    objc.registerName("getLineStart:end:contentsEnd:forRange:");
late final _sel_getObjects_andKeys_count_ =
    objc.registerName("getObjects:andKeys:count:");
late final _sel_getObjects_range_ = objc.registerName("getObjects:range:");
late final _sel_getParagraphStart_end_contentsEnd_forRange_ =
    objc.registerName("getParagraphStart:end:contentsEnd:forRange:");
late final _sel_getResourceValue_forKey_error_ =
    objc.registerName("getResourceValue:forKey:error:");
late final _sel_getValue_size_ = objc.registerName("getValue:size:");
late final _sel_hasBytesAvailable = objc.registerName("hasBytesAvailable");
late final _sel_hasChanges = objc.registerName("hasChanges");
late final _sel_hasDirectoryPath = objc.registerName("hasDirectoryPath");
late final _sel_hasItemConformingToTypeIdentifier_ =
    objc.registerName("hasItemConformingToTypeIdentifier:");
late final _sel_hasMemberInPlane_ = objc.registerName("hasMemberInPlane:");
late final _sel_hasPrefix_ = objc.registerName("hasPrefix:");
late final _sel_hasRepresentationConformingToTypeIdentifier_fileOptions_ = objc
    .registerName("hasRepresentationConformingToTypeIdentifier:fileOptions:");
late final _sel_hasSpaceAvailable = objc.registerName("hasSpaceAvailable");
late final _sel_hasSuffix_ = objc.registerName("hasSuffix:");
late final _sel_hash = objc.registerName("hash");
late final _sel_helpAnchor = objc.registerName("helpAnchor");
late final _sel_host = objc.registerName("host");
late final _sel_illegalCharacterSet = objc.registerName("illegalCharacterSet");
late final _sel_implementMethod_withBlock_withTrampoline_withSignature_ = objc
    .registerName("implementMethod:withBlock:withTrampoline:withSignature:");
late final _sel_increaseLengthBy_ = objc.registerName("increaseLengthBy:");
late final _sel_indexGreaterThanIndex_ =
    objc.registerName("indexGreaterThanIndex:");
late final _sel_indexGreaterThanOrEqualToIndex_ =
    objc.registerName("indexGreaterThanOrEqualToIndex:");
late final _sel_indexLessThanIndex_ = objc.registerName("indexLessThanIndex:");
late final _sel_indexLessThanOrEqualToIndex_ =
    objc.registerName("indexLessThanOrEqualToIndex:");
late final _sel_indexOfObjectIdenticalTo_ =
    objc.registerName("indexOfObjectIdenticalTo:");
late final _sel_indexOfObjectIdenticalTo_inRange_ =
    objc.registerName("indexOfObjectIdenticalTo:inRange:");
late final _sel_indexOfObject_ = objc.registerName("indexOfObject:");
late final _sel_indexOfObject_inRange_ =
    objc.registerName("indexOfObject:inRange:");
late final _sel_indexSet = objc.registerName("indexSet");
late final _sel_indexSetWithIndex_ = objc.registerName("indexSetWithIndex:");
late final _sel_indexSetWithIndexesInRange_ =
    objc.registerName("indexSetWithIndexesInRange:");
late final _sel_init = objc.registerName("init");
late final _sel_initAbsoluteURLWithDataRepresentation_relativeToURL_ =
    objc.registerName("initAbsoluteURLWithDataRepresentation:relativeToURL:");
late final _sel_initByResolvingBookmarkData_options_relativeToURL_bookmarkDataIsStale_error_ =
    objc.registerName(
        "initByResolvingBookmarkData:options:relativeToURL:bookmarkDataIsStale:error:");
late final _sel_initDOBJCDartProtocolFromDartProtocolBuilder_withDisposePort_ =
    objc.registerName(
        "initDOBJCDartProtocolFromDartProtocolBuilder:withDisposePort:");
late final _sel_initFileURLWithFileSystemRepresentation_isDirectory_relativeToURL_ =
    objc.registerName(
        "initFileURLWithFileSystemRepresentation:isDirectory:relativeToURL:");
late final _sel_initFileURLWithPath_ =
    objc.registerName("initFileURLWithPath:");
late final _sel_initFileURLWithPath_isDirectory_ =
    objc.registerName("initFileURLWithPath:isDirectory:");
late final _sel_initFileURLWithPath_isDirectory_relativeToURL_ =
    objc.registerName("initFileURLWithPath:isDirectory:relativeToURL:");
late final _sel_initFileURLWithPath_relativeToURL_ =
    objc.registerName("initFileURLWithPath:relativeToURL:");
late final _sel_initToBuffer_capacity_ =
    objc.registerName("initToBuffer:capacity:");
late final _sel_initToFileAtPath_append_ =
    objc.registerName("initToFileAtPath:append:");
late final _sel_initToMemory = objc.registerName("initToMemory");
late final _sel_initWithArray_ = objc.registerName("initWithArray:");
late final _sel_initWithArray_copyItems_ =
    objc.registerName("initWithArray:copyItems:");
late final _sel_initWithArray_range_copyItems_ =
    objc.registerName("initWithArray:range:copyItems:");
late final _sel_initWithBase64EncodedData_options_ =
    objc.registerName("initWithBase64EncodedData:options:");
late final _sel_initWithBase64EncodedString_options_ =
    objc.registerName("initWithBase64EncodedString:options:");
late final _sel_initWithBool_ = objc.registerName("initWithBool:");
late final _sel_initWithBytesNoCopy_length_ =
    objc.registerName("initWithBytesNoCopy:length:");
late final _sel_initWithBytesNoCopy_length_encoding_freeWhenDone_ =
    objc.registerName("initWithBytesNoCopy:length:encoding:freeWhenDone:");
late final _sel_initWithBytesNoCopy_length_freeWhenDone_ =
    objc.registerName("initWithBytesNoCopy:length:freeWhenDone:");
late final _sel_initWithBytes_length_ =
    objc.registerName("initWithBytes:length:");
late final _sel_initWithBytes_length_encoding_ =
    objc.registerName("initWithBytes:length:encoding:");
late final _sel_initWithBytes_objCType_ =
    objc.registerName("initWithBytes:objCType:");
late final _sel_initWithCString_encoding_ =
    objc.registerName("initWithCString:encoding:");
late final _sel_initWithCapacity_ = objc.registerName("initWithCapacity:");
late final _sel_initWithChanges_ = objc.registerName("initWithChanges:");
late final _sel_initWithChar_ = objc.registerName("initWithChar:");
late final _sel_initWithCharactersNoCopy_length_freeWhenDone_ =
    objc.registerName("initWithCharactersNoCopy:length:freeWhenDone:");
late final _sel_initWithCharacters_length_ =
    objc.registerName("initWithCharacters:length:");
late final _sel_initWithClassName_ = objc.registerName("initWithClassName:");
late final _sel_initWithCoder_ = objc.registerName("initWithCoder:");
late final _sel_initWithContentsOfFile_ =
    objc.registerName("initWithContentsOfFile:");
late final _sel_initWithContentsOfFile_encoding_error_ =
    objc.registerName("initWithContentsOfFile:encoding:error:");
late final _sel_initWithContentsOfFile_options_error_ =
    objc.registerName("initWithContentsOfFile:options:error:");
late final _sel_initWithContentsOfFile_usedEncoding_error_ =
    objc.registerName("initWithContentsOfFile:usedEncoding:error:");
late final _sel_initWithContentsOfURL_ =
    objc.registerName("initWithContentsOfURL:");
late final _sel_initWithContentsOfURL_encoding_error_ =
    objc.registerName("initWithContentsOfURL:encoding:error:");
late final _sel_initWithContentsOfURL_options_error_ =
    objc.registerName("initWithContentsOfURL:options:error:");
late final _sel_initWithContentsOfURL_usedEncoding_error_ =
    objc.registerName("initWithContentsOfURL:usedEncoding:error:");
late final _sel_initWithDataRepresentation_relativeToURL_ =
    objc.registerName("initWithDataRepresentation:relativeToURL:");
late final _sel_initWithData_ = objc.registerName("initWithData:");
late final _sel_initWithData_encoding_ =
    objc.registerName("initWithData:encoding:");
late final _sel_initWithDictionary_ = objc.registerName("initWithDictionary:");
late final _sel_initWithDictionary_copyItems_ =
    objc.registerName("initWithDictionary:copyItems:");
late final _sel_initWithDomain_code_userInfo_ =
    objc.registerName("initWithDomain:code:userInfo:");
late final _sel_initWithDouble_ = objc.registerName("initWithDouble:");
late final _sel_initWithFileAtPath_ = objc.registerName("initWithFileAtPath:");
late final _sel_initWithFloat_ = objc.registerName("initWithFloat:");
late final _sel_initWithFormat_ = objc.registerName("initWithFormat:");
late final _sel_initWithFormat_locale_ =
    objc.registerName("initWithFormat:locale:");
late final _sel_initWithIndexSet_ = objc.registerName("initWithIndexSet:");
late final _sel_initWithIndex_ = objc.registerName("initWithIndex:");
late final _sel_initWithIndexesInRange_ =
    objc.registerName("initWithIndexesInRange:");
late final _sel_initWithInsertIndexes_insertedObjects_removeIndexes_removedObjects_ =
    objc.registerName(
        "initWithInsertIndexes:insertedObjects:removeIndexes:removedObjects:");
late final _sel_initWithInsertIndexes_insertedObjects_removeIndexes_removedObjects_additionalChanges_ =
    objc.registerName(
        "initWithInsertIndexes:insertedObjects:removeIndexes:removedObjects:additionalChanges:");
late final _sel_initWithInt_ = objc.registerName("initWithInt:");
late final _sel_initWithInteger_ = objc.registerName("initWithInteger:");
late final _sel_initWithItem_typeIdentifier_ =
    objc.registerName("initWithItem:typeIdentifier:");
late final _sel_initWithLength_ = objc.registerName("initWithLength:");
late final _sel_initWithLongLong_ = objc.registerName("initWithLongLong:");
late final _sel_initWithLong_ = objc.registerName("initWithLong:");
late final _sel_initWithName_object_userInfo_ =
    objc.registerName("initWithName:object:userInfo:");
late final _sel_initWithObject_ = objc.registerName("initWithObject:");
late final _sel_initWithObjectsAndKeys_ =
    objc.registerName("initWithObjectsAndKeys:");
late final _sel_initWithObjects_ = objc.registerName("initWithObjects:");
late final _sel_initWithObjects_count_ =
    objc.registerName("initWithObjects:count:");
late final _sel_initWithObjects_forKeys_ =
    objc.registerName("initWithObjects:forKeys:");
late final _sel_initWithObjects_forKeys_count_ =
    objc.registerName("initWithObjects:forKeys:count:");
late final _sel_initWithOrderedSet_ = objc.registerName("initWithOrderedSet:");
late final _sel_initWithOrderedSet_copyItems_ =
    objc.registerName("initWithOrderedSet:copyItems:");
late final _sel_initWithOrderedSet_range_copyItems_ =
    objc.registerName("initWithOrderedSet:range:copyItems:");
late final _sel_initWithSet_ = objc.registerName("initWithSet:");
late final _sel_initWithSet_copyItems_ =
    objc.registerName("initWithSet:copyItems:");
late final _sel_initWithShort_ = objc.registerName("initWithShort:");
late final _sel_initWithString_ = objc.registerName("initWithString:");
late final _sel_initWithString_encodingInvalidCharacters_ =
    objc.registerName("initWithString:encodingInvalidCharacters:");
late final _sel_initWithString_relativeToURL_ =
    objc.registerName("initWithString:relativeToURL:");
late final _sel_initWithTimeIntervalSince1970_ =
    objc.registerName("initWithTimeIntervalSince1970:");
late final _sel_initWithTimeIntervalSinceNow_ =
    objc.registerName("initWithTimeIntervalSinceNow:");
late final _sel_initWithTimeIntervalSinceReferenceDate_ =
    objc.registerName("initWithTimeIntervalSinceReferenceDate:");
late final _sel_initWithTimeInterval_sinceDate_ =
    objc.registerName("initWithTimeInterval:sinceDate:");
late final _sel_initWithURL_ = objc.registerName("initWithURL:");
late final _sel_initWithURL_append_ = objc.registerName("initWithURL:append:");
late final _sel_initWithUTF8String_ = objc.registerName("initWithUTF8String:");
late final _sel_initWithUnsignedChar_ =
    objc.registerName("initWithUnsignedChar:");
late final _sel_initWithUnsignedInt_ =
    objc.registerName("initWithUnsignedInt:");
late final _sel_initWithUnsignedInteger_ =
    objc.registerName("initWithUnsignedInteger:");
late final _sel_initWithUnsignedLongLong_ =
    objc.registerName("initWithUnsignedLongLong:");
late final _sel_initWithUnsignedLong_ =
    objc.registerName("initWithUnsignedLong:");
late final _sel_initWithUnsignedShort_ =
    objc.registerName("initWithUnsignedShort:");
late final _sel_initWithValidatedFormat_validFormatSpecifiers_error_ =
    objc.registerName("initWithValidatedFormat:validFormatSpecifiers:error:");
late final _sel_initWithValidatedFormat_validFormatSpecifiers_locale_error_ =
    objc.registerName(
        "initWithValidatedFormat:validFormatSpecifiers:locale:error:");
late final _sel_initialize = objc.registerName("initialize");
late final _sel_inputStreamWithData_ =
    objc.registerName("inputStreamWithData:");
late final _sel_inputStreamWithFileAtPath_ =
    objc.registerName("inputStreamWithFileAtPath:");
late final _sel_inputStreamWithPort_ =
    objc.registerName("inputStreamWithPort:");
late final _sel_inputStreamWithURL_ = objc.registerName("inputStreamWithURL:");
late final _sel_insertObject_atIndex_ =
    objc.registerName("insertObject:atIndex:");
late final _sel_insertObjects_atIndexes_ =
    objc.registerName("insertObjects:atIndexes:");
late final _sel_insertions = objc.registerName("insertions");
late final _sel_instanceMethodForSelector_ =
    objc.registerName("instanceMethodForSelector:");
late final _sel_instanceMethodSignatureForSelector_ =
    objc.registerName("instanceMethodSignatureForSelector:");
late final _sel_instancesRespondToSelector_ =
    objc.registerName("instancesRespondToSelector:");
late final _sel_intValue = objc.registerName("intValue");
late final _sel_integerValue = objc.registerName("integerValue");
late final _sel_intersectOrderedSet_ =
    objc.registerName("intersectOrderedSet:");
late final _sel_intersectSet_ = objc.registerName("intersectSet:");
late final _sel_intersectsIndexesInRange_ =
    objc.registerName("intersectsIndexesInRange:");
late final _sel_intersectsOrderedSet_ =
    objc.registerName("intersectsOrderedSet:");
late final _sel_intersectsSet_ = objc.registerName("intersectsSet:");
late final _sel_inverseDifference = objc.registerName("inverseDifference");
late final _sel_invertedSet = objc.registerName("invertedSet");
late final _sel_isEqualToArray_ = objc.registerName("isEqualToArray:");
late final _sel_isEqualToData_ = objc.registerName("isEqualToData:");
late final _sel_isEqualToDate_ = objc.registerName("isEqualToDate:");
late final _sel_isEqualToDictionary_ =
    objc.registerName("isEqualToDictionary:");
late final _sel_isEqualToIndexSet_ = objc.registerName("isEqualToIndexSet:");
late final _sel_isEqualToNumber_ = objc.registerName("isEqualToNumber:");
late final _sel_isEqualToOrderedSet_ =
    objc.registerName("isEqualToOrderedSet:");
late final _sel_isEqualToSet_ = objc.registerName("isEqualToSet:");
late final _sel_isEqualToString_ = objc.registerName("isEqualToString:");
late final _sel_isEqual_ = objc.registerName("isEqual:");
late final _sel_isFileReferenceURL = objc.registerName("isFileReferenceURL");
late final _sel_isFileURL = objc.registerName("isFileURL");
late final _sel_isKindOfClass_ = objc.registerName("isKindOfClass:");
late final _sel_isMemberOfClass_ = objc.registerName("isMemberOfClass:");
late final _sel_isOneway = objc.registerName("isOneway");
late final _sel_isProxy = objc.registerName("isProxy");
late final _sel_isSubclassOfClass_ = objc.registerName("isSubclassOfClass:");
late final _sel_isSubsetOfOrderedSet_ =
    objc.registerName("isSubsetOfOrderedSet:");
late final _sel_isSubsetOfSet_ = objc.registerName("isSubsetOfSet:");
late final _sel_isSupersetOfSet_ = objc.registerName("isSupersetOfSet:");
late final _sel_itemProviderVisibilityForRepresentationWithTypeIdentifier_ =
    objc.registerName(
        "itemProviderVisibilityForRepresentationWithTypeIdentifier:");
late final _sel_keyEnumerator = objc.registerName("keyEnumerator");
late final _sel_keysSortedByValueUsingSelector_ =
    objc.registerName("keysSortedByValueUsingSelector:");
late final _sel_lastIndex = objc.registerName("lastIndex");
late final _sel_lastObject = objc.registerName("lastObject");
late final _sel_laterDate_ = objc.registerName("laterDate:");
late final _sel_length = objc.registerName("length");
late final _sel_lengthOfBytesUsingEncoding_ =
    objc.registerName("lengthOfBytesUsingEncoding:");
late final _sel_letterCharacterSet = objc.registerName("letterCharacterSet");
late final _sel_lineRangeForRange_ = objc.registerName("lineRangeForRange:");
late final _sel_load = objc.registerName("load");
late final _sel_loadItemForTypeIdentifier_options_completionHandler_ =
    objc.registerName("loadItemForTypeIdentifier:options:completionHandler:");
late final _sel_localizedCapitalizedString =
    objc.registerName("localizedCapitalizedString");
late final _sel_localizedCaseInsensitiveCompare_ =
    objc.registerName("localizedCaseInsensitiveCompare:");
late final _sel_localizedCaseInsensitiveContainsString_ =
    objc.registerName("localizedCaseInsensitiveContainsString:");
late final _sel_localizedCompare_ = objc.registerName("localizedCompare:");
late final _sel_localizedDescription =
    objc.registerName("localizedDescription");
late final _sel_localizedFailureReason =
    objc.registerName("localizedFailureReason");
late final _sel_localizedLowercaseString =
    objc.registerName("localizedLowercaseString");
late final _sel_localizedNameOfStringEncoding_ =
    objc.registerName("localizedNameOfStringEncoding:");
late final _sel_localizedRecoveryOptions =
    objc.registerName("localizedRecoveryOptions");
late final _sel_localizedRecoverySuggestion =
    objc.registerName("localizedRecoverySuggestion");
late final _sel_localizedStandardCompare_ =
    objc.registerName("localizedStandardCompare:");
late final _sel_localizedStandardContainsString_ =
    objc.registerName("localizedStandardContainsString:");
late final _sel_localizedStandardRangeOfString_ =
    objc.registerName("localizedStandardRangeOfString:");
late final _sel_localizedStringWithFormat_ =
    objc.registerName("localizedStringWithFormat:");
late final _sel_localizedStringWithValidatedFormat_validFormatSpecifiers_error_ =
    objc.registerName(
        "localizedStringWithValidatedFormat:validFormatSpecifiers:error:");
late final _sel_localizedUppercaseString =
    objc.registerName("localizedUppercaseString");
late final _sel_longCharacterIsMember_ =
    objc.registerName("longCharacterIsMember:");
late final _sel_longLongValue = objc.registerName("longLongValue");
late final _sel_longValue = objc.registerName("longValue");
late final _sel_lowercaseLetterCharacterSet =
    objc.registerName("lowercaseLetterCharacterSet");
late final _sel_lowercaseString = objc.registerName("lowercaseString");
late final _sel_lowercaseStringWithLocale_ =
    objc.registerName("lowercaseStringWithLocale:");
late final _sel_makeObjectsPerformSelector_ =
    objc.registerName("makeObjectsPerformSelector:");
late final _sel_makeObjectsPerformSelector_withObject_ =
    objc.registerName("makeObjectsPerformSelector:withObject:");
late final _sel_maximumLengthOfBytesUsingEncoding_ =
    objc.registerName("maximumLengthOfBytesUsingEncoding:");
late final _sel_member_ = objc.registerName("member:");
late final _sel_methodForSelector_ = objc.registerName("methodForSelector:");
late final _sel_methodReturnLength = objc.registerName("methodReturnLength");
late final _sel_methodReturnType = objc.registerName("methodReturnType");
late final _sel_methodSignatureForSelector_ =
    objc.registerName("methodSignatureForSelector:");
late final _sel_minusOrderedSet_ = objc.registerName("minusOrderedSet:");
late final _sel_minusSet_ = objc.registerName("minusSet:");
late final _sel_moveObjectsAtIndexes_toIndex_ =
    objc.registerName("moveObjectsAtIndexes:toIndex:");
late final _sel_mutableBytes = objc.registerName("mutableBytes");
late final _sel_mutableCopy = objc.registerName("mutableCopy");
late final _sel_mutableCopyWithZone_ =
    objc.registerName("mutableCopyWithZone:");
late final _sel_name = objc.registerName("name");
late final _sel_new = objc.registerName("new");
late final _sel_newlineCharacterSet = objc.registerName("newlineCharacterSet");
late final _sel_nextObject = objc.registerName("nextObject");
late final _sel_nonBaseCharacterSet = objc.registerName("nonBaseCharacterSet");
late final _sel_notificationWithName_object_ =
    objc.registerName("notificationWithName:object:");
late final _sel_notificationWithName_object_userInfo_ =
    objc.registerName("notificationWithName:object:userInfo:");
late final _sel_numberOfArguments = objc.registerName("numberOfArguments");
late final _sel_numberWithBool_ = objc.registerName("numberWithBool:");
late final _sel_numberWithChar_ = objc.registerName("numberWithChar:");
late final _sel_numberWithDouble_ = objc.registerName("numberWithDouble:");
late final _sel_numberWithFloat_ = objc.registerName("numberWithFloat:");
late final _sel_numberWithInt_ = objc.registerName("numberWithInt:");
late final _sel_numberWithInteger_ = objc.registerName("numberWithInteger:");
late final _sel_numberWithLongLong_ = objc.registerName("numberWithLongLong:");
late final _sel_numberWithLong_ = objc.registerName("numberWithLong:");
late final _sel_numberWithShort_ = objc.registerName("numberWithShort:");
late final _sel_numberWithUnsignedChar_ =
    objc.registerName("numberWithUnsignedChar:");
late final _sel_numberWithUnsignedInt_ =
    objc.registerName("numberWithUnsignedInt:");
late final _sel_numberWithUnsignedInteger_ =
    objc.registerName("numberWithUnsignedInteger:");
late final _sel_numberWithUnsignedLongLong_ =
    objc.registerName("numberWithUnsignedLongLong:");
late final _sel_numberWithUnsignedLong_ =
    objc.registerName("numberWithUnsignedLong:");
late final _sel_numberWithUnsignedShort_ =
    objc.registerName("numberWithUnsignedShort:");
late final _sel_objCType = objc.registerName("objCType");
late final _sel_object = objc.registerName("object");
late final _sel_objectAtIndex_ = objc.registerName("objectAtIndex:");
late final _sel_objectAtIndexedSubscript_ =
    objc.registerName("objectAtIndexedSubscript:");
late final _sel_objectEnumerator = objc.registerName("objectEnumerator");
late final _sel_objectForKey_ = objc.registerName("objectForKey:");
late final _sel_objectForKeyedSubscript_ =
    objc.registerName("objectForKeyedSubscript:");
late final _sel_objectWithItemProviderData_typeIdentifier_error_ =
    objc.registerName("objectWithItemProviderData:typeIdentifier:error:");
late final _sel_objectsAtIndexes_ = objc.registerName("objectsAtIndexes:");
late final _sel_objectsForKeys_notFoundMarker_ =
    objc.registerName("objectsForKeys:notFoundMarker:");
late final _sel_open = objc.registerName("open");
late final _sel_orderedSet = objc.registerName("orderedSet");
late final _sel_orderedSetWithArray_ =
    objc.registerName("orderedSetWithArray:");
late final _sel_orderedSetWithArray_range_copyItems_ =
    objc.registerName("orderedSetWithArray:range:copyItems:");
late final _sel_orderedSetWithCapacity_ =
    objc.registerName("orderedSetWithCapacity:");
late final _sel_orderedSetWithObject_ =
    objc.registerName("orderedSetWithObject:");
late final _sel_orderedSetWithObjects_ =
    objc.registerName("orderedSetWithObjects:");
late final _sel_orderedSetWithObjects_count_ =
    objc.registerName("orderedSetWithObjects:count:");
late final _sel_orderedSetWithOrderedSet_ =
    objc.registerName("orderedSetWithOrderedSet:");
late final _sel_orderedSetWithOrderedSet_range_copyItems_ =
    objc.registerName("orderedSetWithOrderedSet:range:copyItems:");
late final _sel_orderedSetWithSet_ = objc.registerName("orderedSetWithSet:");
late final _sel_orderedSetWithSet_copyItems_ =
    objc.registerName("orderedSetWithSet:copyItems:");
late final _sel_outputStreamToBuffer_capacity_ =
    objc.registerName("outputStreamToBuffer:capacity:");
late final _sel_outputStreamToFileAtPath_append_ =
    objc.registerName("outputStreamToFileAtPath:append:");
late final _sel_outputStreamToMemory =
    objc.registerName("outputStreamToMemory");
late final _sel_outputStreamWithURL_append_ =
    objc.registerName("outputStreamWithURL:append:");
late final _sel_paragraphRangeForRange_ =
    objc.registerName("paragraphRangeForRange:");
late final _sel_parameterString = objc.registerName("parameterString");
late final _sel_password = objc.registerName("password");
late final _sel_path = objc.registerName("path");
late final _sel_performSelector_ = objc.registerName("performSelector:");
late final _sel_performSelector_withObject_ =
    objc.registerName("performSelector:withObject:");
late final _sel_performSelector_withObject_withObject_ =
    objc.registerName("performSelector:withObject:withObject:");
late final _sel_port = objc.registerName("port");
late final _sel_precomposedStringWithCanonicalMapping =
    objc.registerName("precomposedStringWithCanonicalMapping");
late final _sel_precomposedStringWithCompatibilityMapping =
    objc.registerName("precomposedStringWithCompatibilityMapping");
late final _sel_propertyForKey_ = objc.registerName("propertyForKey:");
late final _sel_punctuationCharacterSet =
    objc.registerName("punctuationCharacterSet");
late final _sel_query = objc.registerName("query");
late final _sel_rangeOfCharacterFromSet_ =
    objc.registerName("rangeOfCharacterFromSet:");
late final _sel_rangeOfCharacterFromSet_options_ =
    objc.registerName("rangeOfCharacterFromSet:options:");
late final _sel_rangeOfCharacterFromSet_options_range_ =
    objc.registerName("rangeOfCharacterFromSet:options:range:");
late final _sel_rangeOfComposedCharacterSequenceAtIndex_ =
    objc.registerName("rangeOfComposedCharacterSequenceAtIndex:");
late final _sel_rangeOfComposedCharacterSequencesForRange_ =
    objc.registerName("rangeOfComposedCharacterSequencesForRange:");
late final _sel_rangeOfData_options_range_ =
    objc.registerName("rangeOfData:options:range:");
late final _sel_rangeOfString_ = objc.registerName("rangeOfString:");
late final _sel_rangeOfString_options_ =
    objc.registerName("rangeOfString:options:");
late final _sel_rangeOfString_options_range_ =
    objc.registerName("rangeOfString:options:range:");
late final _sel_rangeOfString_options_range_locale_ =
    objc.registerName("rangeOfString:options:range:locale:");
late final _sel_read_maxLength_ = objc.registerName("read:maxLength:");
late final _sel_recoveryAttempter = objc.registerName("recoveryAttempter");
late final _sel_registerClass = objc.registerName("registerClass");
late final _sel_registerObject_visibility_ =
    objc.registerName("registerObject:visibility:");
late final _sel_registeredTypeIdentifiers =
    objc.registerName("registeredTypeIdentifiers");
late final _sel_registeredTypeIdentifiersWithFileOptions_ =
    objc.registerName("registeredTypeIdentifiersWithFileOptions:");
late final _sel_relativePath = objc.registerName("relativePath");
late final _sel_relativeString = objc.registerName("relativeString");
late final _sel_release = objc.registerName("release");
late final _sel_removals = objc.registerName("removals");
late final _sel_removeAllCachedResourceValues =
    objc.registerName("removeAllCachedResourceValues");
late final _sel_removeAllIndexes = objc.registerName("removeAllIndexes");
late final _sel_removeAllObjects = objc.registerName("removeAllObjects");
late final _sel_removeCachedResourceValueForKey_ =
    objc.registerName("removeCachedResourceValueForKey:");
late final _sel_removeFromRunLoop_forMode_ =
    objc.registerName("removeFromRunLoop:forMode:");
late final _sel_removeIndex_ = objc.registerName("removeIndex:");
late final _sel_removeIndexesInRange_ =
    objc.registerName("removeIndexesInRange:");
late final _sel_removeIndexes_ = objc.registerName("removeIndexes:");
late final _sel_removeLastObject = objc.registerName("removeLastObject");
late final _sel_removeObjectAtIndex_ =
    objc.registerName("removeObjectAtIndex:");
late final _sel_removeObjectForKey_ = objc.registerName("removeObjectForKey:");
late final _sel_removeObjectIdenticalTo_ =
    objc.registerName("removeObjectIdenticalTo:");
late final _sel_removeObjectIdenticalTo_inRange_ =
    objc.registerName("removeObjectIdenticalTo:inRange:");
late final _sel_removeObject_ = objc.registerName("removeObject:");
late final _sel_removeObject_inRange_ =
    objc.registerName("removeObject:inRange:");
late final _sel_removeObjectsAtIndexes_ =
    objc.registerName("removeObjectsAtIndexes:");
late final _sel_removeObjectsForKeys_ =
    objc.registerName("removeObjectsForKeys:");
late final _sel_removeObjectsInArray_ =
    objc.registerName("removeObjectsInArray:");
late final _sel_removeObjectsInRange_ =
    objc.registerName("removeObjectsInRange:");
late final _sel_replaceBytesInRange_withBytes_ =
    objc.registerName("replaceBytesInRange:withBytes:");
late final _sel_replaceBytesInRange_withBytes_length_ =
    objc.registerName("replaceBytesInRange:withBytes:length:");
late final _sel_replaceCharactersInRange_withString_ =
    objc.registerName("replaceCharactersInRange:withString:");
late final _sel_replaceObjectAtIndex_withObject_ =
    objc.registerName("replaceObjectAtIndex:withObject:");
late final _sel_replaceObjectsAtIndexes_withObjects_ =
    objc.registerName("replaceObjectsAtIndexes:withObjects:");
late final _sel_replaceObjectsInRange_withObjectsFromArray_ =
    objc.registerName("replaceObjectsInRange:withObjectsFromArray:");
late final _sel_replaceObjectsInRange_withObjectsFromArray_range_ =
    objc.registerName("replaceObjectsInRange:withObjectsFromArray:range:");
late final _sel_replaceObjectsInRange_withObjects_count_ =
    objc.registerName("replaceObjectsInRange:withObjects:count:");
late final _sel_resetBytesInRange_ = objc.registerName("resetBytesInRange:");
late final _sel_resolveClassMethod_ = objc.registerName("resolveClassMethod:");
late final _sel_resolveInstanceMethod_ =
    objc.registerName("resolveInstanceMethod:");
late final _sel_resourceSpecifier = objc.registerName("resourceSpecifier");
late final _sel_resourceValuesForKeys_error_ =
    objc.registerName("resourceValuesForKeys:error:");
late final _sel_resourceValuesForKeys_fromBookmarkData_ =
    objc.registerName("resourceValuesForKeys:fromBookmarkData:");
late final _sel_respondsToSelector_ = objc.registerName("respondsToSelector:");
late final _sel_retain = objc.registerName("retain");
late final _sel_retainCount = objc.registerName("retainCount");
late final _sel_reverseObjectEnumerator =
    objc.registerName("reverseObjectEnumerator");
late final _sel_reversedOrderedSet = objc.registerName("reversedOrderedSet");
late final _sel_scheduleInRunLoop_forMode_ =
    objc.registerName("scheduleInRunLoop:forMode:");
late final _sel_scheme = objc.registerName("scheme");
late final _sel_self = objc.registerName("self");
late final _sel_set = objc.registerName("set");
late final _sel_setArray_ = objc.registerName("setArray:");
late final _sel_setByAddingObject_ = objc.registerName("setByAddingObject:");
late final _sel_setByAddingObjectsFromArray_ =
    objc.registerName("setByAddingObjectsFromArray:");
late final _sel_setByAddingObjectsFromSet_ =
    objc.registerName("setByAddingObjectsFromSet:");
late final _sel_setData_ = objc.registerName("setData:");
late final _sel_setDelegate_ = objc.registerName("setDelegate:");
late final _sel_setDictionary_ = objc.registerName("setDictionary:");
late final _sel_setDone = objc.registerName("setDone");
late final _sel_setError_ = objc.registerName("setError:");
late final _sel_setLength_ = objc.registerName("setLength:");
late final _sel_setObject_atIndex_ = objc.registerName("setObject:atIndex:");
late final _sel_setObject_atIndexedSubscript_ =
    objc.registerName("setObject:atIndexedSubscript:");
late final _sel_setObject_forKey_ = objc.registerName("setObject:forKey:");
late final _sel_setObject_forKeyedSubscript_ =
    objc.registerName("setObject:forKeyedSubscript:");
late final _sel_setProperty_forKey_ = objc.registerName("setProperty:forKey:");
late final _sel_setResourceValue_forKey_error_ =
    objc.registerName("setResourceValue:forKey:error:");
late final _sel_setResourceValues_error_ =
    objc.registerName("setResourceValues:error:");
late final _sel_setSet_ = objc.registerName("setSet:");
late final _sel_setSuggestedName_ = objc.registerName("setSuggestedName:");
late final _sel_setTemporaryResourceValue_forKey_ =
    objc.registerName("setTemporaryResourceValue:forKey:");
late final _sel_setWithArray_ = objc.registerName("setWithArray:");
late final _sel_setWithCapacity_ = objc.registerName("setWithCapacity:");
late final _sel_setWithObject_ = objc.registerName("setWithObject:");
late final _sel_setWithObjects_ = objc.registerName("setWithObjects:");
late final _sel_setWithObjects_count_ =
    objc.registerName("setWithObjects:count:");
late final _sel_setWithSet_ = objc.registerName("setWithSet:");
late final _sel_shiftIndexesStartingAtIndex_by_ =
    objc.registerName("shiftIndexesStartingAtIndex:by:");
late final _sel_shortValue = objc.registerName("shortValue");
late final _sel_signatureWithObjCTypes_ =
    objc.registerName("signatureWithObjCTypes:");
late final _sel_smallestEncoding = objc.registerName("smallestEncoding");
late final _sel_sortUsingFunction_context_ =
    objc.registerName("sortUsingFunction:context:");
late final _sel_sortUsingSelector_ = objc.registerName("sortUsingSelector:");
late final _sel_sortedArrayHint = objc.registerName("sortedArrayHint");
late final _sel_sortedArrayUsingFunction_context_ =
    objc.registerName("sortedArrayUsingFunction:context:");
late final _sel_sortedArrayUsingFunction_context_hint_ =
    objc.registerName("sortedArrayUsingFunction:context:hint:");
late final _sel_sortedArrayUsingSelector_ =
    objc.registerName("sortedArrayUsingSelector:");
late final _sel_standardizedURL = objc.registerName("standardizedURL");
late final _sel_startAccessingSecurityScopedResource =
    objc.registerName("startAccessingSecurityScopedResource");
late final _sel_stopAccessingSecurityScopedResource =
    objc.registerName("stopAccessingSecurityScopedResource");
late final _sel_streamError = objc.registerName("streamError");
late final _sel_streamStatus = objc.registerName("streamStatus");
late final _sel_stream_handleEvent_ = objc.registerName("stream:handleEvent:");
late final _sel_string = objc.registerName("string");
late final _sel_stringByAppendingFormat_ =
    objc.registerName("stringByAppendingFormat:");
late final _sel_stringByAppendingString_ =
    objc.registerName("stringByAppendingString:");
late final _sel_stringByApplyingTransform_reverse_ =
    objc.registerName("stringByApplyingTransform:reverse:");
late final _sel_stringByFoldingWithOptions_locale_ =
    objc.registerName("stringByFoldingWithOptions:locale:");
late final _sel_stringByPaddingToLength_withString_startingAtIndex_ =
    objc.registerName("stringByPaddingToLength:withString:startingAtIndex:");
late final _sel_stringByReplacingCharactersInRange_withString_ =
    objc.registerName("stringByReplacingCharactersInRange:withString:");
late final _sel_stringByReplacingOccurrencesOfString_withString_ =
    objc.registerName("stringByReplacingOccurrencesOfString:withString:");
late final _sel_stringByReplacingOccurrencesOfString_withString_options_range_ =
    objc.registerName(
        "stringByReplacingOccurrencesOfString:withString:options:range:");
late final _sel_stringByTrimmingCharactersInSet_ =
    objc.registerName("stringByTrimmingCharactersInSet:");
late final _sel_stringValue = objc.registerName("stringValue");
late final _sel_stringWithCString_encoding_ =
    objc.registerName("stringWithCString:encoding:");
late final _sel_stringWithCharacters_length_ =
    objc.registerName("stringWithCharacters:length:");
late final _sel_stringWithContentsOfFile_encoding_error_ =
    objc.registerName("stringWithContentsOfFile:encoding:error:");
late final _sel_stringWithContentsOfFile_usedEncoding_error_ =
    objc.registerName("stringWithContentsOfFile:usedEncoding:error:");
late final _sel_stringWithContentsOfURL_encoding_error_ =
    objc.registerName("stringWithContentsOfURL:encoding:error:");
late final _sel_stringWithContentsOfURL_usedEncoding_error_ =
    objc.registerName("stringWithContentsOfURL:usedEncoding:error:");
late final _sel_stringWithFormat_ = objc.registerName("stringWithFormat:");
late final _sel_stringWithString_ = objc.registerName("stringWithString:");
late final _sel_stringWithUTF8String_ =
    objc.registerName("stringWithUTF8String:");
late final _sel_stringWithValidatedFormat_validFormatSpecifiers_error_ =
    objc.registerName("stringWithValidatedFormat:validFormatSpecifiers:error:");
late final _sel_subarrayWithRange_ = objc.registerName("subarrayWithRange:");
late final _sel_subdataWithRange_ = objc.registerName("subdataWithRange:");
late final _sel_substringFromIndex_ = objc.registerName("substringFromIndex:");
late final _sel_substringToIndex_ = objc.registerName("substringToIndex:");
late final _sel_substringWithRange_ = objc.registerName("substringWithRange:");
late final _sel_suggestedName = objc.registerName("suggestedName");
late final _sel_superclass = objc.registerName("superclass");
late final _sel_supportsSecureCoding =
    objc.registerName("supportsSecureCoding");
late final _sel_symbolCharacterSet = objc.registerName("symbolCharacterSet");
late final _sel_timeIntervalSince1970 =
    objc.registerName("timeIntervalSince1970");
late final _sel_timeIntervalSinceDate_ =
    objc.registerName("timeIntervalSinceDate:");
late final _sel_timeIntervalSinceNow =
    objc.registerName("timeIntervalSinceNow");
late final _sel_timeIntervalSinceReferenceDate =
    objc.registerName("timeIntervalSinceReferenceDate");
late final _sel_underlyingErrors = objc.registerName("underlyingErrors");
late final _sel_unionOrderedSet_ = objc.registerName("unionOrderedSet:");
late final _sel_unionSet_ = objc.registerName("unionSet:");
late final _sel_unsignedCharValue = objc.registerName("unsignedCharValue");
late final _sel_unsignedIntValue = objc.registerName("unsignedIntValue");
late final _sel_unsignedIntegerValue =
    objc.registerName("unsignedIntegerValue");
late final _sel_unsignedLongLongValue =
    objc.registerName("unsignedLongLongValue");
late final _sel_unsignedLongValue = objc.registerName("unsignedLongValue");
late final _sel_unsignedShortValue = objc.registerName("unsignedShortValue");
late final _sel_uppercaseLetterCharacterSet =
    objc.registerName("uppercaseLetterCharacterSet");
late final _sel_uppercaseString = objc.registerName("uppercaseString");
late final _sel_uppercaseStringWithLocale_ =
    objc.registerName("uppercaseStringWithLocale:");
late final _sel_user = objc.registerName("user");
late final _sel_userInfo = objc.registerName("userInfo");
late final _sel_whitespaceAndNewlineCharacterSet =
    objc.registerName("whitespaceAndNewlineCharacterSet");
late final _sel_whitespaceCharacterSet =
    objc.registerName("whitespaceCharacterSet");
late final _sel_writableTypeIdentifiersForItemProvider =
    objc.registerName("writableTypeIdentifiersForItemProvider");
late final _sel_writeBookmarkData_toURL_options_error_ =
    objc.registerName("writeBookmarkData:toURL:options:error:");
late final _sel_writeToFile_atomically_ =
    objc.registerName("writeToFile:atomically:");
late final _sel_writeToFile_atomically_encoding_error_ =
    objc.registerName("writeToFile:atomically:encoding:error:");
late final _sel_writeToFile_options_error_ =
    objc.registerName("writeToFile:options:error:");
late final _sel_writeToURL_atomically_ =
    objc.registerName("writeToURL:atomically:");
late final _sel_writeToURL_atomically_encoding_error_ =
    objc.registerName("writeToURL:atomically:encoding:error:");
late final _sel_writeToURL_error_ = objc.registerName("writeToURL:error:");
late final _sel_writeToURL_options_error_ =
    objc.registerName("writeToURL:options:error:");
late final _sel_write_maxLength_ = objc.registerName("write:maxLength:");
late final _sel_zone = objc.registerName("zone");
typedef instancetype = ffi.Pointer<objc.ObjCObject>;
typedef Dartinstancetype = objc.ObjCObjectBase;
