import 'package:ml_linalg/dtype.dart';
import 'package:ml_linalg/matrix.dart';
import 'package:test/test.dart';

import '../../../dtype_to_title.dart';

void matrixIdentityConstructorTestGroupFactory(DType dtype) =>
    group(dtypeToMatrixTestTitle[dtype], () {
      group('identity constructor', () {
        test(
            'should create a matrix with main diagonal elements equal to 1, '
            'and the rest elements equal to 0', () {
          final matrix = Matrix.identity(7, dtype: dtype);

          expect(
              matrix,
              equals([
                [1, 0, 0, 0, 0, 0, 0],
                [0, 1, 0, 0, 0, 0, 0],
                [0, 0, 1, 0, 0, 0, 0],
                [0, 0, 0, 1, 0, 0, 0],
                [0, 0, 0, 0, 1, 0, 0],
                [0, 0, 0, 0, 0, 1, 0],
                [0, 0, 0, 0, 0, 0, 1],
              ]));
          expect(matrix.dtype, dtype);
        });
      });
    });
