# Contributing
We'd love for you to contribute to our source code and to make the project even better than it is today!
Here are the guidelines we'd like you to follow:

 - [Code of Conduct](#coc)
 - [Git Commit Messages](#commit)
 - [Got a Question or Problem?](#question)
 - [Found an Issue?](#issue)

## <a name="coc"></a> Code of Conduct
[Code of Conduct](https://github.com/BirjuVachhani/adaptive_theme/blob/main/CODE_OF_CONDUCT.md)

## <a name="commit"></a> Git Commit Messages

* Use the present tense ("Add feature" not "Added feature")
* Use the imperative mood ("Move cursor to..." not "Moves cursor to...")
* Limit the first line to 72 characters or less
* Reference issues and pull requests liberally after the first line
* When only changing documentation, include `[ci skip]` in the commit title
* Consider starting the commit message with an applicable emoji:
    * :art: `:art:` when improving the format/structure of the code
    * :racehorse: `:racehorse:` when improving performance
    * :non-potable_water: `:non-potable_water:` when plugging memory leaks
    * :memo: `:memo:` when writing docs
    * :bug: `:bug:` when fixing a bug
    * :fire: `:fire:` when removing code or files
    * :green_heart: `:green_heart:` when fixing the CI build
    * :white_check_mark: `:white_check_mark:` when adding tests
    * :lock: `:lock:` when dealing with security
    * :arrow_up: `:arrow_up:` when upgrading dependencies
    * :arrow_down: `:arrow_down:` when downgrading dependencies
    * :shirt: `:shirt:` when removing lint/checkstyle warnings
    
    Find all the available emojis [here](https://gitmoji.carloscuesta.me/). 

## <a name="question"></a> Got a Question or Problem?

If you feel that we're missing an important bit of documentation, feel free to
file an issue so we can help. Here's an example to get you started:

```
What are you trying to do or find out more about?

Where have you looked?

Where did you expect to find this information?
```

## <a name="issue"></a> Found an Issue?
If you find a bug in the source code or a mistake in the documentation, you can help us by
submitting an issue to our project.

To submit an issue, please check the [Issue Template](https://github.com/BirjuVachhani/adaptive_theme/blob/main/ISSUE_TEMPLATE.md).

Even better you can submit a Pull Request with a fix.

### Pull Request
To generate a pull request, please consider following [Pull Request Template](https://github.com/BirjuVachhani/adaptive_theme/blob/main/PULL_REQUEST_TEMPLATE.md).

* Search [GitHub](https://github.com/BirjuVachhani/adaptive_theme/pulls) for an open or closed Pull Request
  that relates to your submission. You don't want to duplicate effort.
* Please have a look at [License](https://github.com/BirjuVachhani/adaptive_theme/blob/main/LICENSE) before sending pull
  requests. We cannot accept code without this.

That's it! Thank you for your contribution!
