import 'package:ente_ui/theme/ente_theme.dart';
import 'package:flutter/material.dart';
import 'package:hugeicons/hugeicons.dart';

class GradientButton extends StatelessWidget {
  final VoidCallback? onTap;
  final String text;
  final HugeIcon? hugeIcon;
  final double paddingValue;
  final Color? backgroundColor;
  final Color? textColor;

  const GradientButton({
    super.key,
    this.onTap,
    this.text = '',
    this.hugeIcon,
    this.paddingValue = 6.0,
    this.backgroundColor,
    this.textColor,
  });

  static const TextStyle _textStyle = TextStyle(
    color: Colors.white,
    fontWeight: FontWeight.w600,
    fontFamily: 'Inter-SemiBold',
    fontSize: 18,
  );

  @override
  Widget build(BuildContext context) {
    final colorScheme = getEnteColorScheme(context);
    final bool isEnabled = onTap != null;
    final Color effectiveBackgroundColor = backgroundColor ??
        (isEnabled ? colorScheme.primary700 : colorScheme.fillFaint);
    final Color effectiveTextColor =
        textColor ?? (isEnabled ? Colors.white : colorScheme.textMuted);
    final TextStyle effectiveTextStyle = _textStyle.copyWith(
      color: effectiveTextColor,
    );

    final Widget textWidget = Text(text, style: effectiveTextStyle);

    final Widget content = (hugeIcon != null)
        ? Row(
            mainAxisAlignment: MainAxisAlignment.center,
            crossAxisAlignment: CrossAxisAlignment.center,
            mainAxisSize: MainAxisSize.min,
            children: [
              hugeIcon!,
              Padding(padding: EdgeInsets.symmetric(horizontal: paddingValue)),
              if (text.isNotEmpty) textWidget,
            ],
          )
        : textWidget;

    return ClipRRect(
      borderRadius: BorderRadius.circular(20),
      child: Material(
        color: effectiveBackgroundColor,
        child: InkWell(
          onTap: onTap,
          splashColor: isEnabled ? null : Colors.transparent,
          highlightColor: isEnabled ? null : Colors.transparent,
          child: SizedBox(
            height: 56,
            child: Center(child: content),
          ),
        ),
      ),
    );
  }
}
