// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Vietnamese (`vi`).
class AppLocalizationsVi extends AppLocalizations {
  AppLocalizationsVi([String locale = 'vi']) : super(locale);

  @override
  String get enterYourEmailAddress => 'Nhập địa chỉ email của bạn';

  @override
  String get enterYourNewEmailAddress => 'Nhập địa chỉ email mới của bạn';

  @override
  String get accountWelcomeBack => 'Chào mừng bạn trở lại!';

  @override
  String get emailAlreadyRegistered => 'Email đã được đăng ký.';

  @override
  String get emailNotRegistered => 'Email chưa được đăng ký.';

  @override
  String get email => 'Email';

  @override
  String get cancel => 'Hủy';

  @override
  String get verify => 'Xác minh';

  @override
  String get invalidEmailAddress => 'Địa chỉ email không hợp lệ';

  @override
  String get enterValidEmail => 'Vui lòng nhập một địa chỉ email hợp lệ.';

  @override
  String get deleteAccount => 'Xóa tài khoản';

  @override
  String get deleteAccountWarning =>
      'Việc này sẽ xóa Ente Auth, Ente Photos và tài khoản Ente Locker của bạn.';

  @override
  String get askDeleteReason => 'Lý do chính bạn xóa tài khoản là gì?';

  @override
  String get deleteAccountFeedbackPrompt =>
      'Chúng tôi rất tiếc khi thấy bạn rời đi. Vui lòng chia sẻ phản hồi của bạn để giúp chúng tôi cải thiện.';

  @override
  String get feedback => 'Phản hồi';

  @override
  String get kindlyHelpUsWithThisInformation =>
      'Mong bạn giúp chúng tôi thông tin này';

  @override
  String get confirmDeletePrompt =>
      'Có, tôi muốn xóa vĩnh viễn tài khoản này và tất cả dữ liệu.';

  @override
  String get confirmAccountDeletion => 'Xác nhận xóa tài khoản';

  @override
  String get deleteAccountPermanentlyButton => 'Xóa tài khoản vĩnh viễn';

  @override
  String get yourAccountHasBeenDeleted => 'Tài khoản của bạn đã bị xóa';

  @override
  String get selectReason => 'Chọn lý do';

  @override
  String get deleteReason1 => 'Nó thiếu một tính năng quan trọng mà tôi cần';

  @override
  String get deleteReason2 =>
      'Ứng dụng hoặc một tính năng không hoạt động như tôi muốn';

  @override
  String get deleteReason3 => 'Tôi tìm thấy một dịch vụ khác mà tôi thích hơn';

  @override
  String get deleteReason4 => 'Lý do không có trong danh sách';

  @override
  String get sendEmail => 'Gửi email';

  @override
  String get deleteRequestSLAText =>
      'Yêu cầu của bạn sẽ được xử lý trong vòng 72 giờ.';

  @override
  String get deleteEmailRequest =>
      'Vui lòng gửi email đến <warning>account-deletion@ente.io</warning> từ địa chỉ email đã đăng ký của bạn.';

  @override
  String get entePhotosPerm => 'Ente <i>cần quyền để</i> lưu giữ ảnh của bạn';

  @override
  String get ok => 'OK';

  @override
  String get createAccount => 'Tạo tài khoản';

  @override
  String get createNewAccount => 'Tạo tài khoản mới';

  @override
  String get password => 'Mật khẩu';

  @override
  String get confirmPassword => 'Xác nhận mật khẩu';

  @override
  String get activeSessions => 'Phiên hoạt động';

  @override
  String get ocrProcessingOverlayMessage => 'Đang phát hiện văn bản...';

  @override
  String get ocrLoadingIndicatorLabel => 'Phát hiện văn bản';

  @override
  String get ocrSelectionHint =>
      'Vuốt hoặc nhấn đúp để chọn chính xác những gì bạn cần';

  @override
  String get ocrNoTextDetected => 'Không phát hiện văn bản';

  @override
  String get ocrRetryButtonLabel => 'Thử lại';

  @override
  String get ocrModelsNetworkRequiredError =>
      'Cần có kết nối mạng để tải xuống các mô hình OCR khi sử dụng lần đầu';

  @override
  String get ocrModelsPrepareFailed => 'Không thể chuẩn bị các mô hình OCR';

  @override
  String get ocrImageNotFoundError => 'Không tìm thấy tệp ảnh';

  @override
  String get ocrImageDecodeFailedError => 'Không thể đọc tệp ảnh';

  @override
  String get ocrGenericDetectError => 'Không thể phát hiện văn bản trong ảnh';

  @override
  String get oops => 'Ốii!';

  @override
  String get somethingWentWrongPleaseTryAgain =>
      'Có gì đó không ổn, vui lòng thử lại';

  @override
  String get thisWillLogYouOutOfThisDevice =>
      'Bạn sẽ đăng xuất khỏi thiết bị này!';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice =>
      'Bạn cũng sẽ đăng xuất khỏi những thiết bị sau:';

  @override
  String get terminateSession => 'Kết thúc phiên? ';

  @override
  String get terminate => 'Kết thúc';

  @override
  String get thisDevice => 'Thiết bị này';

  @override
  String get recoverButton => 'Khôi phục';

  @override
  String get recoverySuccessful => 'Khôi phục thành công!';

  @override
  String get decrypting => 'Đang giải mã...';

  @override
  String get incorrectRecoveryKeyTitle => 'Mã khôi phục không chính xác';

  @override
  String get incorrectRecoveryKeyBody =>
      'Mã khôi phục bạn nhập không chính xác';

  @override
  String get forgotPassword => 'Quên mật khẩu';

  @override
  String get enterYourRecoveryKey => 'Nhập mã khôi phục của bạn';

  @override
  String get noRecoveryKey => 'Không có mã khôi phục?';

  @override
  String get sorry => 'Xin lỗi';

  @override
  String get noRecoveryKeyNoDecryption =>
      'Do tính chất của giao thức mã hóa đầu cuối, không thể giải mã dữ liệu của bạn mà không có mật khẩu hoặc mã khôi phục';

  @override
  String get verifyEmail => 'Xác minh email';

  @override
  String get toResetVerifyEmail =>
      'Để đặt lại mật khẩu, vui lòng xác minh email của bạn trước.';

  @override
  String get checkInboxAndSpamFolder =>
      'Vui lòng kiểm tra hộp thư đến (và thư rác) để hoàn tất xác minh';

  @override
  String get tapToEnterCode => 'Nhấn để nhập mã';

  @override
  String get resendEmail => 'Gửi lại email';

  @override
  String weHaveSendEmailTo({required String email}) {
    return 'Chúng tôi đã gửi một email đến <green>$email</green>';
  }

  @override
  String get setPasswordTitle => 'Đặt mật khẩu';

  @override
  String get changePasswordTitle => 'Thay đổi mật khẩu';

  @override
  String get resetPasswordTitle => 'Đặt lại mật khẩu';

  @override
  String get encryptionKeys => 'Khóa mã hóa';

  @override
  String get passwordWarning =>
      'Chúng tôi không lưu trữ mật khẩu này, nên nếu bạn quên, <underline>chúng tôi không thể giải mã dữ liệu của bạn</underline>';

  @override
  String get enterPasswordToEncrypt =>
      'Vui lòng nhập một mật khẩu dùng để mã hóa dữ liệu của bạn';

  @override
  String get enterNewPasswordToEncrypt =>
      'Vui lòng nhập một mật khẩu mới để mã hóa dữ liệu của bạn';

  @override
  String get weakStrength => 'Yếu';

  @override
  String get strongStrength => 'Mạnh';

  @override
  String get moderateStrength => 'Trung bình';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'Độ mạnh mật khẩu: $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully => 'Đã thay đổi mật khẩu thành công';

  @override
  String get generatingEncryptionKeys => 'Đang mã hóa...';

  @override
  String get pleaseWait => 'Vui lòng chờ...';

  @override
  String get continueLabel => 'Tiếp tục';

  @override
  String get insecureDevice => 'Thiết bị không an toàn';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'Rất tiếc, chúng tôi không thể tạo khóa an toàn trên thiết bị này.\n\nVui lòng đăng ký từ một thiết bị khác.';

  @override
  String get howItWorks => 'Cách thức hoạt động';

  @override
  String get encryption => 'Mã hóa';

  @override
  String get ackPasswordLostWarning =>
      'Tôi hiểu rằng nếu mất mật khẩu, dữ liệu của tôi sẽ mất vì nó được <underline>mã hóa đầu cuối</underline>.';

  @override
  String get privacyPolicyTitle => 'Chính sách bảo mật';

  @override
  String get termsOfServicesTitle => 'Điều khoản';

  @override
  String get signUpTerms =>
      'Tôi đồng ý với <u-terms>điều khoản</u-terms> và <u-policy>chính sách bảo mật</u-policy>';

  @override
  String get logInLabel => 'Đăng nhập';

  @override
  String get loginTerms =>
      'Nhấn vào đăng nhập, tôi đồng ý với <u-terms>điều khoản</u-terms> và <u-policy>chính sách bảo mật</u-policy>';

  @override
  String get changeEmail => 'Đổi email';

  @override
  String get enterYourPassword => 'Nhập mật khẩu của bạn';

  @override
  String get welcomeBack => 'Chào mừng trở lại!';

  @override
  String get contactSupport => 'Liên hệ hỗ trợ';

  @override
  String get locationPickerTip =>
      'Bạn cũng có thể thêm vị trí tập trung vào ảnh từ phần thông tin của ảnh';

  @override
  String get incorrectPasswordTitle => 'Mật khẩu không đúng';

  @override
  String get pleaseTryAgain => 'Vui lòng thử lại';

  @override
  String get recreatePasswordTitle => 'Tạo lại mật khẩu';

  @override
  String get useRecoveryKey => 'Dùng mã khôi phục';

  @override
  String get recreatePasswordBody =>
      'Thiết bị hiện tại không đủ mạnh để xác minh mật khẩu của bạn, nhưng chúng tôi có thể tạo lại để nó hoạt động với tất cả thiết bị.\n\nVui lòng đăng nhập bằng mã khôi phục và tạo lại mật khẩu (bạn có thể dùng lại mật khẩu cũ nếu muốn).';

  @override
  String get verifyPassword => 'Xác minh mật khẩu';

  @override
  String get recoveryKey => 'Mã khôi phục';

  @override
  String get recoveryKeyOnForgotPassword =>
      'Nếu bạn quên mật khẩu, cách duy nhất để khôi phục dữ liệu của bạn là dùng mã này.';

  @override
  String get recoveryKeySaveDescription =>
      'Chúng tôi không lưu trữ mã này, nên hãy lưu nó ở nơi an toàn.';

  @override
  String get doThisLater => 'Để sau';

  @override
  String get saveKey => 'Lưu mã';

  @override
  String get recoveryKeyCopiedToClipboard =>
      'Đã sao chép mã khôi phục vào bộ nhớ tạm';

  @override
  String get recoverAccount => 'Khôi phục tài khoản';

  @override
  String get recover => 'Khôi phục';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'Vui lòng gửi email đến $supportEmail từ địa chỉ email đã đăng ký của bạn';
  }

  @override
  String get twofactorSetup => 'Cài đặt xác minh 2 bước';

  @override
  String get enterCode => 'Nhập mã';

  @override
  String get scanCode => 'Quét mã';

  @override
  String get codeCopiedToClipboard => 'Mã đã được sao chép vào bộ nhớ tạm';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      'Chép & dán mã này\nvào ứng dụng xác thực của bạn';

  @override
  String get tapToCopy => 'nhấn để sao chép';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      'Quét mã vạch này bằng\nứng dụng xác thực của bạn';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      'Nhập mã 6 chữ số từ\nứng dụng xác thực của bạn';

  @override
  String get confirm => 'Xác nhận';

  @override
  String get setupComplete => 'Cài đặt hoàn tất';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready =>
      'Lưu mã khôi phục của bạn nếu bạn chưa làm';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      'Chúng có thể giúp khôi phục tài khoản của bạn nếu bạn mất xác thực 2 bước';

  @override
  String get twofactorAuthenticationPageTitle => 'Xác thực 2 bước';

  @override
  String get lostDevice => 'Mất thiết bị?';

  @override
  String get verifyingRecoveryKey => 'Đang xác minh mã khôi phục...';

  @override
  String get recoveryKeyVerified => 'Mã khôi phục đã được xác minh';

  @override
  String get recoveryKeySuccessBody =>
      'Tuyệt! Mã khôi phục của bạn hợp lệ. Cảm ơn đã xác minh.\n\nNhớ lưu giữ mã khôi phục của bạn ở nơi an toàn.';

  @override
  String get invalidRecoveryKey =>
      'Mã khôi phục không hợp lệ. Vui lòng đảm bảo nó chứa 24 từ, và đúng chính tả từng từ.\n\nNếu bạn nhập loại mã khôi phục cũ, hãy đảm bảo nó dài 64 ký tự, và kiểm tra từng ký tự.';

  @override
  String get invalidKey => 'Mã không hợp lệ';

  @override
  String get tryAgain => 'Thử lại';

  @override
  String get viewRecoveryKey => 'Xem mã khôi phục';

  @override
  String get confirmRecoveryKey => 'Xác nhận mã khôi phục';

  @override
  String get recoveryKeyVerifyReason =>
      'Mã khôi phục là cách duy nhất để khôi phục ảnh của bạn nếu bạn quên mật khẩu. Bạn có thể xem mã khôi phục của mình trong Cài đặt > Tài khoản.\n\nVui lòng nhập mã khôi phục của bạn ở đây để xác minh rằng bạn đã lưu nó đúng cách.';

  @override
  String get confirmYourRecoveryKey => 'Xác nhận mã khôi phục của bạn';

  @override
  String get addViewer => 'Thêm người xem';

  @override
  String get addCollaborator => 'Thêm cộng tác viên';

  @override
  String get addANewEmail => 'Thêm một email mới';

  @override
  String get orPickAnExistingOne => 'Hoặc chọn một cái có sẵn';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'Cộng tác viên có thể thêm ảnh và video vào album chia sẻ.';

  @override
  String get enterEmail => 'Nhập email';

  @override
  String get albumOwner => 'Chủ sở hữu';

  @override
  String get you => 'Bạn';

  @override
  String get collaborator => 'Cộng tác viên';

  @override
  String get addMore => 'Thêm nhiều hơn';

  @override
  String get viewer => 'Người xem';

  @override
  String get remove => 'Xóa';

  @override
  String get removeParticipant => 'Xóa người tham gia';

  @override
  String get manage => 'Quản lý';

  @override
  String get addedAs => 'Đã thêm như';

  @override
  String get changePermissions => 'Thay đổi quyền?';

  @override
  String get yesConvertToViewer => 'Có, chuyển thành người xem';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return '$user sẽ không thể thêm ảnh vào album này\n\nHọ vẫn có thể xóa ảnh đã thêm bởi họ';
  }

  @override
  String get allowAddingPhotos => 'Cho phép thêm ảnh';

  @override
  String get allowJoiningAlbum => 'Cho phép ghép album';

  @override
  String get allowAddPhotosDescription =>
      'Cho phép người có liên kết thêm ảnh vào album chia sẻ.';

  @override
  String get passwordLock => 'Khóa bằng mật khẩu';

  @override
  String get canNotOpenTitle => 'Không thể mở album này';

  @override
  String get canNotOpenBody =>
      'Rất tiếc, album này không thể mở trong ứng dụng.';

  @override
  String get disableDownloadWarningTitle => 'Xin lưu ý';

  @override
  String get disableDownloadWarningBody =>
      'Người xem vẫn có thể chụp màn hình hoặc sao chép ảnh của bạn bằng các công cụ bên ngoài';

  @override
  String get allowDownloads => 'Cho phép tải xuống';

  @override
  String get linkDeviceLimit => 'Giới hạn thiết bị';

  @override
  String get noDeviceLimit => 'Không có';

  @override
  String get albumLayout => 'Bố cục album';

  @override
  String get layoutGrouped => 'Đã phân nhóm';

  @override
  String get layoutContinuous => 'Liên tục';

  @override
  String get layoutTrip => 'Chuyến đi';

  @override
  String get preview => 'Xem trước';

  @override
  String get linkExpiry => 'Hết hạn liên kết';

  @override
  String get linkExpired => 'Hết hạn';

  @override
  String get linkEnabled => 'Đã bật';

  @override
  String get linkNeverExpires => 'Không bao giờ';

  @override
  String get expiredLinkInfo =>
      'Liên kết này đã hết hạn. Vui lòng chọn thời gian hết hạn mới hoặc tắt tính năng hết hạn liên kết.';

  @override
  String get setAPassword => 'Đặt mật khẩu';

  @override
  String get lockButtonLabel => 'Khóa';

  @override
  String get enterPassword => 'Nhập mật khẩu';

  @override
  String get removeLink => 'Xóa liên kết';

  @override
  String get manageLink => 'Quản lý liên kết';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'Liên kết sẽ hết hạn vào $expiryTime';
  }

  @override
  String get albumUpdated => 'Album đã được cập nhật';

  @override
  String get never => 'Không bao giờ';

  @override
  String get custom => 'Tùy chỉnh';

  @override
  String get after1Hour => 'Sau 1 giờ';

  @override
  String get after1Day => 'Sau 1 ngày';

  @override
  String get after1Week => 'Sau 1 tuần';

  @override
  String get after1Month => 'Sau 1 tháng';

  @override
  String get after1Year => 'Sau 1 năm';

  @override
  String get manageParticipants => 'Quản lý';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Người tham gia',
      one: '1 người tham gia',
      zero: 'Không có người tham gia',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'Tạo một liên kết cho phép mọi người thêm và xem ảnh trong album chia sẻ của bạn mà không cần ứng dụng hoặc tài khoản Ente. Phù hợp để thu thập ảnh sự kiện.';

  @override
  String get collectPhotos => 'Thu thập ảnh';

  @override
  String get collaborativeLink => 'Liên kết cộng tác';

  @override
  String get shareWithNonenteUsers => 'Chia sẻ với người không dùng Ente';

  @override
  String get createPublicLink => 'Tạo liên kết công khai';

  @override
  String get sendLink => 'Gửi liên kết';

  @override
  String get qrCode => 'QR Code';

  @override
  String get sendQrCode => 'Gửi mã QR';

  @override
  String get copyLink => 'Sao chép liên kết';

  @override
  String get copyEmbedHtml => 'Sao chép mã nhúng HTML';

  @override
  String get linkHasExpired => 'Liên kết đã hết hạn';

  @override
  String get publicLinkEnabled => 'Liên kết công khai đã được bật';

  @override
  String get shareALink => 'Chia sẻ một liên kết';

  @override
  String get sharedAlbumSectionDescription =>
      'Tạo album chia sẻ và cộng tác với người dùng Ente khác, bao gồm người dùng gói miễn phí.';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: 'Chia sẻ với $numberOfPeople người',
      one: 'Chia sẻ với 1 người',
      zero: 'Chia sẻ với những người cụ thể',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId => 'Đây là ID xác minh của bạn';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'Ai đó chia sẻ album với bạn nên thấy cùng một ID trên thiết bị của họ.';

  @override
  String get howToViewShareeVerificationID =>
      'Hãy chỉ họ nhấn giữ địa chỉ email của họ trên màn hình cài đặt, và xác minh rằng ID trên cả hai thiết bị khớp nhau.';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'Đây là ID xác minh của $email';
  }

  @override
  String get verificationId => 'ID xác minh';

  @override
  String verifyEmailID({required Object email}) {
    return 'Xác minh $email';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return '$email không có tài khoản Ente.\n\nGửi họ một lời mời để chia sẻ ảnh.';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return 'Đây là ID xác minh của tôi: $verificationID cho ente.io.';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'Chào, bạn có thể xác nhận rằng đây là ID xác minh ente.io của bạn: $verificationID';
  }

  @override
  String get somethingWentWrong => 'Có gì đó không ổn';

  @override
  String get sendInvite => 'Gửi lời mời';

  @override
  String get shareTextRecommendUsingEnte =>
      'Tải Ente để chúng ta có thể dễ dàng chia sẻ ảnh và video chất lượng gốc\n\nhttps://ente.io';

  @override
  String get done => 'Xong';

  @override
  String get applyCodeTitle => 'Áp dụng mã';

  @override
  String get enterCodeDescription =>
      'Nhập mã do bạn bè cung cấp để nhận thêm dung lượng miễn phí cho cả hai';

  @override
  String get apply => 'Áp dụng';

  @override
  String get failedToApplyCode => 'Không thể áp dụng mã';

  @override
  String get enterReferralCode => 'Nhập mã giới thiệu';

  @override
  String get codeAppliedPageTitle => 'Mã đã được áp dụng';

  @override
  String get changeYourReferralCode => 'Thay đổi mã giới thiệu của bạn';

  @override
  String get change => 'Thay đổi';

  @override
  String get unavailableReferralCode => 'Rất tiếc, mã này không khả dụng.';

  @override
  String get codeChangeLimitReached =>
      'Rất tiếc, bạn đã đạt hạn mức thay đổi mã.';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'Vui lòng liên hệ $familyAdminEmail để thay đổi mã của bạn.';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB';
  }

  @override
  String get claimed => 'Đã nhận';

  @override
  String get details => 'Chi tiết';

  @override
  String get claimMore => 'Nhận thêm!';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return 'Họ cũng nhận được $storageAmountInGB GB';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB mỗi khi ai đó đăng ký gói trả phí và áp dụng mã của bạn';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'Mã giới thiệu Ente: $referralCode \n\nÁp dụng nó trong Cài đặt → Chung → Giới thiệu để nhận thêm $referralStorageInGB GB miễn phí sau khi bạn đăng ký gói trả phí\n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => 'Nhận thêm dung lượng';

  @override
  String get inviteYourFriends => 'Mời bạn bè của bạn';

  @override
  String get failedToFetchReferralDetails =>
      'Không thể lấy thông tin giới thiệu. Vui lòng thử lại sau.';

  @override
  String get referralStep1 => '1. Đưa mã này cho bạn bè của bạn';

  @override
  String get referralStep2 => '2. Họ đăng ký gói trả phí';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. Cả hai nhận thêm $storageInGB GB* miễn phí';
  }

  @override
  String get referralsAreCurrentlyPaused => 'Giới thiệu hiện đang tạm dừng';

  @override
  String get youCanAtMaxDoubleYourStorage =>
      '* Bạn có thể tối đa ×2 dung lượng của mình';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true':
          'Gia đình bạn đã nhận thêm $storageAmountInGb GB tính đến hiện tại',
      'false': 'Bạn đã nhận thêm $storageAmountInGb GB tính đến hiện tại',
      'other': 'Bạn đã nhận thêm $storageAmountInGb GB tính đến hiện tại!',
    });
    return '$_temp0';
  }

  @override
  String get faq => 'Câu hỏi thường gặp';

  @override
  String get help => 'Trợ giúp';

  @override
  String get oopsSomethingWentWrong => 'Ốii!, có gì đó không ổn';

  @override
  String get peopleUsingYourCode => 'Người dùng mã của bạn';

  @override
  String get eligible => 'đủ điều kiện';

  @override
  String get total => 'tổng';

  @override
  String get codeUsedByYou => 'Mã bạn đã dùng';

  @override
  String get freeStorageClaimed => 'Dung lượng miễn phí đã nhận';

  @override
  String get freeStorageUsable => 'Dung lượng miễn phí có thể dùng';

  @override
  String get usableReferralStorageInfo =>
      'Dung lượng có thể dùng bị giới hạn bởi gói hiện tại của bạn. Dung lượng nhận thêm vượt hạn mức sẽ tự động có thể dùng khi bạn nâng cấp gói.';

  @override
  String get removeFromAlbumTitle => 'Xóa khỏi album?';

  @override
  String get removeFromAlbum => 'Xóa khỏi album';

  @override
  String get itemsWillBeRemovedFromAlbum =>
      'Các mục đã chọn sẽ bị xóa khỏi album này';

  @override
  String get removeShareItemsWarning =>
      'Vài mục mà bạn đang xóa được thêm bởi người khác, và bạn sẽ mất quyền truy cập vào chúng';

  @override
  String get addingToFavorites => 'Đang thêm vào mục yêu thích...';

  @override
  String get removingFromFavorites => 'Đang xóa khỏi mục yêu thích...';

  @override
  String get sorryCouldNotAddToFavorites =>
      'Xin lỗi, không thể thêm vào mục yêu thích!';

  @override
  String get sorryCouldNotRemoveFromFavorites =>
      'Xin lỗi, không thể xóa khỏi mục yêu thích!';

  @override
  String get subscribeToEnableSharing =>
      'Bạn phải dùng gói trả phí mới có thể chia sẻ.';

  @override
  String get subscribe => 'Đăng ký gói';

  @override
  String get canOnlyRemoveFilesOwnedByYou =>
      'Chỉ có thể xóa các tệp thuộc sở hữu của bạn';

  @override
  String get deleteSharedAlbum => 'Xóa album chia sẻ?';

  @override
  String get deleteAlbum => 'Xóa album';

  @override
  String get deleteAlbumDialog =>
      'Xóa luôn ảnh (và video) có trong album này khỏi <bold>mọi album khác</bold> có chứa chúng?';

  @override
  String get deleteSharedAlbumDialogBody =>
      'Album sẽ bị xóa với tất cả mọi người\n\nBạn sẽ mất quyền truy cập vào các ảnh chia sẻ trong album này mà thuộc sở hữu của người khác';

  @override
  String get yesRemove => 'Có, xóa';

  @override
  String get creatingLink => 'Đang tạo liên kết...';

  @override
  String get removeWithQuestionMark => 'Xóa?';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return '$userEmail sẽ bị xóa khỏi album chia sẻ này\n\nBất kỳ ảnh nào được thêm bởi họ cũng sẽ bị xóa khỏi album';
  }

  @override
  String get keepPhotos => 'Giữ ảnh';

  @override
  String get deletePhotos => 'Xóa ảnh';

  @override
  String get inviteToEnte => 'Mời sử dụng Ente';

  @override
  String get removePublicLink => 'Xóa liên kết công khai';

  @override
  String disableLinkMessage({required Object albumName}) {
    return 'Xóa liên kết công khai dùng để truy cập \"$albumName\".';
  }

  @override
  String get sharing => 'Đang chia sẻ...';

  @override
  String get youCannotShareWithYourself =>
      'Bạn không thể chia sẻ với chính mình';

  @override
  String get archive => 'Lưu trữ';

  @override
  String get createAlbumActionHint =>
      'Nhấn giữ để chọn ảnh và nhấn + để tạo album';

  @override
  String get importing => 'Đang nhập....';

  @override
  String get failedToLoadAlbums => 'Không thể tải album';

  @override
  String get hidden => 'Ẩn';

  @override
  String get authToViewYourHiddenFiles => 'Vui lòng xác thực để xem các tệp ẩn';

  @override
  String get authToViewTrashedFiles =>
      'Vui lòng xác thực để xem các tệp đã xóa';

  @override
  String get trash => 'Thùng rác';

  @override
  String get uncategorized => 'Chưa phân loại';

  @override
  String get videoSmallCase => 'video';

  @override
  String get photoSmallCase => 'ảnh';

  @override
  String get singleFileDeleteHighlight => 'Nó sẽ bị xóa khỏi tất cả album.';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return 'Tệp $fileType này có trong cả Ente và thiết bị của bạn.';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return 'Tệp $fileType này sẽ bị xóa khỏi Ente.';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return 'Tệp $fileType này sẽ bị xóa khỏi thiết bị của bạn.';
  }

  @override
  String get deleteFromEnte => 'Xóa khỏi Ente';

  @override
  String get yesDelete => 'Có, xóa';

  @override
  String get movedToTrash => 'Đã cho vào thùng rác';

  @override
  String get deleteFromDevice => 'Xóa khỏi thiết bị';

  @override
  String get deleteFromBoth => 'Xóa khỏi cả hai';

  @override
  String get newAlbum => 'Album mới';

  @override
  String get albums => 'Album';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount kỷ niệm',
      zero: 'chưa có kỷ niệm',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return '$count đã chọn';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return '$count đã chọn ($yourCount là của bạn)';
  }

  @override
  String get advancedSettings => 'Nâng cao';

  @override
  String get photoGridSize => 'Kích thước lưới ảnh';

  @override
  String get manageDeviceStorage => 'Quản lý bộ nhớ đệm của thiết bị';

  @override
  String get manageDeviceStorageDesc => 'Xem và xóa bộ nhớ đệm trên thiết bị.';

  @override
  String get machineLearning => 'Học máy';

  @override
  String get mlConsent => 'Bật học máy';

  @override
  String get mlConsentTitle => 'Bật học máy?';

  @override
  String get mlConsentDescription =>
      'Nếu bạn bật học máy, Ente sẽ trích xuất thông tin như hình dạng khuôn mặt từ các tệp, gồm cả những tệp mà bạn được chia sẻ.\n\nViệc này sẽ diễn ra trên thiết bị của bạn, với mọi thông tin sinh trắc học tạo ra đều được mã hóa đầu cuối.';

  @override
  String get mlConsentPrivacy =>
      'Vui lòng nhấn vào đây để biết thêm chi tiết về tính năng này trong chính sách quyền riêng tư của chúng tôi';

  @override
  String get mlConsentConfirmation => 'Tôi hiểu và muốn bật học máy';

  @override
  String get magicSearch => 'Tìm kiếm vi diệu';

  @override
  String get discover => 'Khám phá';

  @override
  String get discover_identity => 'Nhận dạng';

  @override
  String get discover_screenshots => 'Ảnh chụp màn hình';

  @override
  String get discover_receipts => 'Biên lai';

  @override
  String get discover_notes => 'Ghi chú';

  @override
  String get discover_memes => 'Meme';

  @override
  String get discover_visiting_cards => 'Danh thiếp';

  @override
  String get discover_babies => 'Em bé';

  @override
  String get discover_pets => 'Thú cưng';

  @override
  String get discover_selfies => 'Selfie';

  @override
  String get discover_wallpapers => 'Hình nền';

  @override
  String get discover_food => 'Thức ăn';

  @override
  String get discover_celebrations => 'Lễ kỷ niệm';

  @override
  String get discover_sunset => 'Hoàng hôn';

  @override
  String get discover_hills => 'Đồi';

  @override
  String get discover_greenery => 'Cây cối';

  @override
  String get mlIndexingDescription =>
      'Lưu ý rằng việc học máy sẽ khiến tốn băng thông và pin nhiều hơn cho đến khi tất cả mục được lập chỉ mục. Hãy sử dụng ứng dụng máy tính để lập chỉ mục nhanh hơn. Mọi kết quả sẽ được tự động đồng bộ.';

  @override
  String get loadingModel => 'Đang tải mô hình...';

  @override
  String get waitingForWifi => 'Đang chờ WiFi...';

  @override
  String get status => 'Trạng thái';

  @override
  String get indexedItems => 'Các mục đã lập chỉ mục';

  @override
  String get pendingItems => 'Các mục đang chờ';

  @override
  String get clearIndexes => 'Xóa chỉ mục';

  @override
  String get selectFoldersForBackup => 'Chọn thư mục để sao lưu';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      'Các thư mục đã chọn sẽ được mã hóa và sao lưu';

  @override
  String get unselectAll => 'Bỏ chọn tất cả';

  @override
  String get selectAll => 'Chọn tất cả';

  @override
  String get skip => 'Bỏ qua';

  @override
  String get updatingFolderSelection => 'Đang cập nhật lựa chọn thư mục...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count mục',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Xóa $count mục',
      one: 'Xóa $count mục',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count tệp, $formattedSize mỗi tệp';
  }

  @override
  String get showMemories => 'Xem lại kỷ niệm';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count năm trước',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'Cài đặt sao lưu';

  @override
  String get backupStatus => 'Trạng thái sao lưu';

  @override
  String get backupStatusDescription =>
      'Các mục đã được sao lưu sẽ hiển thị ở đây';

  @override
  String get backupOverMobileData => 'Sao lưu với dữ liệu di động';

  @override
  String get backupVideos => 'Sao lưu video';

  @override
  String get disableAutoLock => 'Vô hiệu hóa khóa tự động';

  @override
  String get deviceLockExplanation =>
      'Vô hiệu hóa khóa màn hình thiết bị khi Ente đang ở chế độ nền và có một bản sao lưu đang diễn ra. Điều này thường không cần thiết, nhưng có thể giúp tải lên các tệp lớn và tệp nhập của các thư viện lớn xong nhanh hơn.';

  @override
  String get about => 'Giới thiệu';

  @override
  String get weAreOpenSource => 'Chúng tôi là mã nguồn mở!';

  @override
  String get privacy => 'Bảo mật';

  @override
  String get terms => 'Điều khoản';

  @override
  String get checkForUpdates => 'Kiểm tra cập nhật';

  @override
  String get checkStatus => 'Kiểm tra trạng thái';

  @override
  String get checking => 'Đang kiểm tra...';

  @override
  String get youAreOnTheLatestVersion => 'Bạn đang sử dụng phiên bản mới nhất';

  @override
  String get account => 'Tài khoản';

  @override
  String get manageSubscription => 'Quản lý gói';

  @override
  String get authToChangeYourEmail => 'Vui lòng xác thực để đổi email';

  @override
  String get changePassword => 'Đổi mật khẩu';

  @override
  String get authToChangeYourPassword => 'Vui lòng xác thực để đổi mật khẩu';

  @override
  String get emailVerificationToggle => 'Xác minh email';

  @override
  String get authToChangeEmailVerificationSetting =>
      'Vui lòng xác thực để đổi cài đặt xác minh email';

  @override
  String get exportYourData => 'Xuất dữ liệu của bạn';

  @override
  String get logout => 'Đăng xuất';

  @override
  String get authToInitiateAccountDeletion =>
      'Vui lòng xác thực để bắt đầu xóa tài khoản';

  @override
  String get areYouSureYouWantToLogout => 'Bạn có chắc muốn đăng xuất không?';

  @override
  String get yesLogout => 'Có, đăng xuất';

  @override
  String get aNewVersionOfEnteIsAvailable => 'Ente có phiên bản mới.';

  @override
  String get update => 'Cập nhật';

  @override
  String get installManually => 'Cài đặt thủ công';

  @override
  String get criticalUpdateAvailable => 'Cập nhật quan trọng có sẵn';

  @override
  String get updateAvailable => 'Cập nhật có sẵn';

  @override
  String get ignoreUpdate => 'Bỏ qua';

  @override
  String get downloading => 'Đang tải xuống...';

  @override
  String get cannotDeleteSharedFiles => 'Không thể xóa các tệp đã chia sẻ';

  @override
  String get theDownloadCouldNotBeCompleted => 'Không thể hoàn tất tải xuống';

  @override
  String get retry => 'Thử lại';

  @override
  String get backedUpFolders => 'Thư mục đã sao lưu';

  @override
  String get backup => 'Sao lưu';

  @override
  String get freeUpDeviceSpace => 'Giải phóng dung lượng thiết bị';

  @override
  String get freeUpDeviceSpaceDesc =>
      'Tiết kiệm dung lượng thiết bị của bạn bằng cách xóa các tệp đã được sao lưu.';

  @override
  String get allClear => '✨ Tất cả đã xong';

  @override
  String get noDeviceThatCanBeDeleted =>
      'Bạn không có tệp nào có thể xóa trên thiết bị này';

  @override
  String get removeDuplicates => 'Xóa trùng lặp';

  @override
  String get removeDuplicatesDesc => 'Xem và xóa các tệp bị trùng lặp.';

  @override
  String get viewLargeFiles => 'Tệp lớn';

  @override
  String get viewLargeFilesDesc =>
      'Xem các tệp đang chiếm nhiều dung lượng nhất.';

  @override
  String get noDuplicates => '✨ Không có trùng lặp';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared =>
      'Bạn không có tệp nào bị trùng để xóa';

  @override
  String get success => 'Thành công';

  @override
  String get rateUs => 'Đánh giá chúng tôi';

  @override
  String get remindToEmptyDeviceTrash =>
      'Hãy xóa luôn \"Đã xóa gần đây\" từ \"Cài đặt\" -> \"Lưu trữ\" để lấy lại dung lượng đã giải phóng';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return 'Bạn đã giải phóng thành công $storageSaved!';
  }

  @override
  String get remindToEmptyEnteTrash =>
      'Hãy xóa luôn \"Thùng rác\" của bạn để lấy lại dung lượng đã giải phóng';

  @override
  String get sparkleSuccess => '✨ Thành công';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count tệp bị trùng lặp',
    );
    return 'Bạn đã dọn dẹp $_temp0, lấy lại ($storageSaved!)';
  }

  @override
  String get familyPlans => 'Gói gia đình';

  @override
  String get referrals => 'Giới thiệu';

  @override
  String get notifications => 'Thông báo';

  @override
  String get sharedPhotoNotifications => 'Ảnh chia sẻ mới';

  @override
  String get sharedPhotoNotificationsExplanation =>
      'Nhận thông báo khi ai đó thêm ảnh vào album chia sẻ mà bạn tham gia.';

  @override
  String get advanced => 'Nâng cao';

  @override
  String get general => 'Chung';

  @override
  String get security => 'Bảo mật';

  @override
  String get authToViewYourRecoveryKey =>
      'Vui lòng xác thực để xem mã khôi phục';

  @override
  String get twofactor => 'Xác thực 2 bước';

  @override
  String get authToConfigureTwofactorAuthentication =>
      'Vui lòng xác thực để cấu hình xác thực 2 bước';

  @override
  String get lockscreen => 'Khóa màn hình';

  @override
  String get authToChangeLockscreenSetting =>
      'Vui lòng xác thực để thay đổi cài đặt khóa màn hình';

  @override
  String get viewActiveSessions => 'Xem phiên hoạt động';

  @override
  String get authToViewYourActiveSessions =>
      'Vui lòng xác thực để xem các phiên hoạt động';

  @override
  String get disableTwofactor => 'Tắt xác thực 2 bước';

  @override
  String get confirm2FADisable => 'Bạn có chắc muốn tắt xác thực 2 bước không?';

  @override
  String get no => 'Không';

  @override
  String get yes => 'Có';

  @override
  String get social => 'Mạng xã hội';

  @override
  String rateUsOnStore({required Object storeName}) {
    return 'Đánh giá chúng tôi trên $storeName';
  }

  @override
  String get blog => 'Blog';

  @override
  String get merchandise => 'Vật phẩm';

  @override
  String get twitter => 'Twitter';

  @override
  String get mastodon => 'Mastodon';

  @override
  String get matrix => 'Matrix';

  @override
  String get discord => 'Discord';

  @override
  String get reddit => 'Reddit';

  @override
  String get yourStorageDetailsCouldNotBeFetched =>
      'Không thể lấy chi tiết dung lượng của bạn';

  @override
  String get reportABug => 'Báo lỗi';

  @override
  String get reportBug => 'Báo lỗi';

  @override
  String get suggestFeatures => 'Đề xuất tính năng';

  @override
  String get support => 'Hỗ trợ';

  @override
  String get theme => 'Chủ đề';

  @override
  String get lightTheme => 'Sáng';

  @override
  String get darkTheme => 'Tối';

  @override
  String get systemTheme => 'Giống hệ thống';

  @override
  String get freeTrial => 'Dùng thử miễn phí';

  @override
  String get selectYourPlan => 'Chọn gói của bạn';

  @override
  String get enteSubscriptionPitch =>
      'Ente lưu giữ kỷ niệm của bạn, vì vậy chúng luôn có sẵn, ngay cả khi bạn mất thiết bị.';

  @override
  String get enteSubscriptionShareWithFamily =>
      'Bạn có thể thêm gia đình vào gói của mình.';

  @override
  String get currentUsageIs => 'Dung lượng hiện tại ';

  @override
  String get faqs => 'Câu hỏi thường gặp';

  @override
  String renewsOn({required Object endDate}) {
    return 'Gia hạn gói vào $endDate';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return 'Dùng thử miễn phí áp dụng đến $endDate';
  }

  @override
  String validTill({required Object endDate}) {
    return 'Áp dụng đến $endDate';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return 'Gói bổ sung $storageAmount áp dụng đến $endDate';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return 'Dùng thử miễn phí áp dụng đến $endDate.\nBạn có thể chọn gói trả phí sau đó.';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'Gói của bạn sẽ bị hủy vào $endDate';
  }

  @override
  String get subscription => 'Gói đăng ký';

  @override
  String get paymentDetails => 'Chi tiết thanh toán';

  @override
  String get manageFamily => 'Quản lý gia đình';

  @override
  String contactToManageSubscription({required Object provider}) {
    return 'Vui lòng liên hệ với chúng tôi qua support@ente.io để quản lý gói $provider của bạn.';
  }

  @override
  String get renewSubscription => 'Gia hạn gói';

  @override
  String get cancelSubscription => 'Hủy gói';

  @override
  String get areYouSureYouWantToRenew => 'Bạn có chắc muốn gia hạn không?';

  @override
  String get yesRenew => 'Có, Gia hạn';

  @override
  String get areYouSureYouWantToCancel => 'Bạn có chắc muốn hủy không?';

  @override
  String get yesCancel => 'Có, hủy';

  @override
  String get failedToRenew => 'Gia hạn không thành công';

  @override
  String get failedToCancel => 'Hủy không thành công';

  @override
  String get twoMonthsFreeOnYearlyPlans =>
      'Nhận 2 tháng miễn phí với các gói theo năm';

  @override
  String get monthly => 'Theo tháng';

  @override
  String get yearly => 'Theo năm';

  @override
  String get confirmPlanChange => 'Xác nhận thay đổi gói';

  @override
  String get areYouSureYouWantToChangeYourPlan =>
      'Bạn có chắc muốn thay đổi gói của mình không?';

  @override
  String get youCannotDowngradeToThisPlan => 'Bạn không thể đổi xuống gói này';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'Vui lòng hủy gói hiện tại của bạn từ $paymentProvider trước';
  }

  @override
  String get optionalAsShortAsYouLike => 'Tùy chọn, ngắn dài tùy ý...';

  @override
  String get send => 'Gửi';

  @override
  String get askCancelReason =>
      'Gói của bạn đã bị hủy. Bạn có muốn chia sẻ lý do không?';

  @override
  String get thankYouForSubscribing => 'Cảm ơn bạn đã đăng ký gói!';

  @override
  String get yourPurchaseWasSuccessful => 'Bạn đã giao dịch thành công';

  @override
  String get yourPlanWasSuccessfullyUpgraded =>
      'Gói của bạn đã được nâng cấp thành công';

  @override
  String get yourPlanWasSuccessfullyDowngraded =>
      'Gói của bạn đã được hạ cấp thành công';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully =>
      'Gói của bạn đã được cập nhật thành công';

  @override
  String get googlePlayId => 'ID Google Play';

  @override
  String get appleId => 'ID Apple';

  @override
  String get playstoreSubscription => 'Gói PlayStore';

  @override
  String get appstoreSubscription => 'Gói AppStore';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return 'ID $id của bạn đã được liên kết với một tài khoản Ente khác.\nNếu bạn muốn sử dụng ID $id này với tài khoản này, vui lòng liên hệ bộ phận hỗ trợ của chúng tôi.';
  }

  @override
  String get visitWebToManage =>
      'Vui lòng truy cập web.ente.io để quản lý gói đăng ký';

  @override
  String get couldNotUpdateSubscription => 'Không thể cập nhật gói';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      'Vui lòng liên hệ support@ente.io và chúng tôi rất sẵn sàng giúp đỡ!';

  @override
  String get paymentFailed => 'Thanh toán thất bại';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return 'Vui lòng trao đổi với bộ phận hỗ trợ $providerName nếu bạn đã bị tính phí';
  }

  @override
  String get continueOnFreeTrial => 'Tiếp tục dùng thử miễn phí';

  @override
  String get areYouSureYouWantToExit => 'Bạn có chắc muốn thoát không?';

  @override
  String get thankYou => 'Cảm ơn bạn';

  @override
  String get failedToVerifyPaymentStatus =>
      'Không thể xác minh trạng thái thanh toán';

  @override
  String get pleaseWaitForSometimeBeforeRetrying =>
      'Vui lòng chờ một chút trước khi thử lại';

  @override
  String get paymentFailedMessage =>
      'Rất tiếc, bạn đã thanh toán không thành công. Vui lòng liên hệ hỗ trợ và chúng tôi sẽ giúp bạn!';

  @override
  String get youAreOnAFamilyPlan => 'Bạn đang dùng gói gia đình!';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'Vui lòng liên hệ <green>$familyAdminEmail</green> để quản lý gói của bạn';
  }

  @override
  String get leaveFamily => 'Rời khỏi gia đình';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily =>
      'Bạn có chắc muốn rời khỏi gói gia đình không?';

  @override
  String get leave => 'Rời';

  @override
  String get rateTheApp => 'Đánh giá ứng dụng';

  @override
  String get startBackup => 'Bắt đầu sao lưu';

  @override
  String get noPhotosAreBeingBackedUpRightNow =>
      'Hiện tại không có ảnh nào đang được sao lưu';

  @override
  String get preserveMore => 'Lưu giữ nhiều hơn';

  @override
  String get grantFullAccessPrompt =>
      'Vui lòng cho phép truy cập vào tất cả ảnh trong ứng dụng Cài đặt';

  @override
  String get allowPermTitle => 'Cho phép truy cập ảnh';

  @override
  String get allowPermBody =>
      'Vui lòng cho phép truy cập vào ảnh của bạn từ Cài đặt để Ente có thể hiển thị và sao lưu thư viện của bạn.';

  @override
  String get openSettings => 'Mở Cài đặt';

  @override
  String get selectMorePhotos => 'Chọn thêm ảnh';

  @override
  String get existingUser => 'Người dùng hiện tại';

  @override
  String get privateBackups => 'Sao lưu riêng tư';

  @override
  String get forYourMemories => 'cho những kỷ niệm của bạn';

  @override
  String get endtoendEncryptedByDefault => 'Mã hóa đầu cuối theo mặc định';

  @override
  String get safelyStored => 'Lưu trữ an toàn';

  @override
  String get atAFalloutShelter => 'ở hầm trú ẩn hạt nhân';

  @override
  String get designedToOutlive => 'Được thiết kế để trường tồn';

  @override
  String get available => 'Có sẵn';

  @override
  String get everywhere => 'mọi nơi';

  @override
  String get androidIosWebDesktop => 'Android, iOS, Web, Desktop';

  @override
  String get mobileWebDesktop => 'Di động, Web, Desktop';

  @override
  String get newToEnte => 'Mới dùng Ente';

  @override
  String get pleaseLoginAgain => 'Vui lòng đăng nhập lại';

  @override
  String get autoLogoutMessage =>
      'Do sự cố kỹ thuật, bạn đã bị đăng xuất. Chúng tôi xin lỗi vì sự bất tiện.';

  @override
  String get yourSubscriptionHasExpired => 'Gói của bạn đã hết hạn';

  @override
  String get storageLimitExceeded => 'Đã vượt hạn mức lưu trữ';

  @override
  String get upgrade => 'Nâng cấp';

  @override
  String get raiseTicket => 'Yêu cầu hỗ trợ';

  @override
  String get backupFailed => 'Sao lưu thất bại';

  @override
  String get sorryBackupFailedDesc =>
      'Rất tiếc, không thể sao lưu tệp vào lúc này, chúng tôi sẽ thử lại sau.';

  @override
  String get couldNotBackUpTryLater =>
      'Chúng tôi không thể sao lưu dữ liệu của bạn.\nChúng tôi sẽ thử lại sau.';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      'Ente chỉ có thể mã hóa và lưu giữ tệp nếu bạn cấp quyền truy cập chúng';

  @override
  String get pleaseGrantPermissions => 'Vui lòng cấp quyền';

  @override
  String get grantPermission => 'Cấp quyền';

  @override
  String get privateSharing => 'Chia sẻ riêng tư';

  @override
  String get shareOnlyWithThePeopleYouWant =>
      'Chỉ chia sẻ với những người bạn muốn';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      'Dùng liên kết công khai cho những người không dùng Ente';

  @override
  String get allowPeopleToAddPhotos => 'Cho phép mọi người thêm ảnh';

  @override
  String get shareAnAlbumNow => 'Chia sẻ ngay một album';

  @override
  String get collectEventPhotos => 'Thu thập ảnh sự kiện';

  @override
  String get sessionExpired => 'Phiên đã hết hạn';

  @override
  String get loggingOut => 'Đang đăng xuất...';

  @override
  String get onDevice => 'Trên thiết bị';

  @override
  String get onEnte => 'Trên <branding>ente</branding>';

  @override
  String get name => 'Tên';

  @override
  String get newest => 'Mới nhất';

  @override
  String get lastUpdated => 'Mới cập nhật';

  @override
  String get deleteEmptyAlbums => 'Xóa album trống';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => 'Xóa album trống?';

  @override
  String get deleteAlbumsDialogBody =>
      'Tất cả album trống sẽ bị xóa. Sẽ hữu ích khi bạn muốn giảm bớt sự lộn xộn trong danh sách album của mình.';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return 'Đang xóa $currentlyDeleting / $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return 'Đang xử lý $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => 'Xóa vĩnh viễn';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou =>
      'Chỉ có thể tạo liên kết cho các tệp thuộc sở hữu của bạn';

  @override
  String get publicLinkCreated => 'Liên kết công khai đã được tạo';

  @override
  String get youCanManageYourLinksInTheShareTab =>
      'Bạn có thể quản lý các liên kết của mình trong tab chia sẻ.';

  @override
  String get linkCopiedToClipboard =>
      'Liên kết đã được sao chép vào bộ nhớ tạm';

  @override
  String get restore => 'Khôi phục';

  @override
  String get moveToAlbum => 'Chuyển đến album';

  @override
  String get unhide => 'Hiện lại';

  @override
  String get unarchive => 'Bỏ lưu trữ';

  @override
  String get favorite => 'Thích';

  @override
  String get removeFromFavorite => 'Xóa khỏi mục đã thích';

  @override
  String get shareLink => 'Chia sẻ liên kết';

  @override
  String get createCollage => 'Tạo ảnh ghép';

  @override
  String get saveCollage => 'Lưu ảnh ghép';

  @override
  String get collageSaved => 'Ảnh ghép đã được lưu vào thư viện';

  @override
  String get collageLayout => 'Bố cục';

  @override
  String get addToEnte => 'Thêm vào Ente';

  @override
  String get addToAlbum => 'Thêm vào album';

  @override
  String get delete => 'Xóa';

  @override
  String get hide => 'Ẩn';

  @override
  String get share => 'Chia sẻ';

  @override
  String get unhideToAlbum => 'Hiện lại trong album';

  @override
  String get restoreToAlbum => 'Khôi phục vào album';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Di chuyển các mục',
      one: 'Di chuyển mục',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Thêm các mục',
      one: 'Thêm mục',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'Tạo hoặc chọn album';

  @override
  String get selectAlbum => 'Chọn album';

  @override
  String get searchByAlbumNameHint => 'Tên album';

  @override
  String get albumTitle => 'Tiêu đề album';

  @override
  String get enterAlbumName => 'Nhập tên album';

  @override
  String get restoringFiles => 'Đang khôi phục tệp...';

  @override
  String get movingFilesToAlbum => 'Đang di chuyển tệp vào album...';

  @override
  String get unhidingFilesToAlbum => 'Đang hiện lại tệp trong album';

  @override
  String get canNotUploadToAlbumsOwnedByOthers =>
      'Không thể tải lên album thuộc sở hữu của người khác';

  @override
  String get uploadingFilesToAlbum => 'Đang tải tệp lên album...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return 'Đã thêm thành công vào $albumName';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return 'Đã di chuyển thành công đến $albumName';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'Album này đã có một liên kết cộng tác';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return 'Liên kết cộng tác đã được tạo cho $albumName';
  }

  @override
  String get askYourLovedOnesToShare =>
      'Hãy gợi ý những người thân yêu của bạn chia sẻ';

  @override
  String get invite => 'Mời';

  @override
  String get shareYourFirstAlbum => 'Chia sẻ album đầu tiên của bạn';

  @override
  String sharedWith({required Object emailIDs}) {
    return 'Chia sẻ với $emailIDs';
  }

  @override
  String get sharedWithMe => 'Chia sẻ với tôi';

  @override
  String get sharedByMe => 'Chia sẻ bởi tôi';

  @override
  String get doubleYourStorage => 'Nhân đôi dung lượng';

  @override
  String get referFriendsAnd2xYourPlan =>
      'Giới thiệu bạn bè để được ×2 dung lượng gói của bạn';

  @override
  String get shareAlbumHint =>
      'Mở album và nhấn nút chia sẻ ở góc trên bên phải để chia sẻ.';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      'Trên các mục là số ngày còn lại trước khi xóa vĩnh viễn';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ngày',
      one: '1 ngày',
      zero: 'Sắp xóa',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => 'Xóa tất cả';

  @override
  String get renameAlbum => 'Đổi tên album';

  @override
  String get convertToAlbum => 'Chuyển đổi thành album';

  @override
  String get setCover => 'Đặt ảnh bìa';

  @override
  String get sortAlbumsBy => 'Sắp xếp theo';

  @override
  String get sortNewestFirst => 'Mới nhất trước';

  @override
  String get sortOldestFirst => 'Cũ nhất trước';

  @override
  String get rename => 'Đổi tên';

  @override
  String get leaveSharedAlbum => 'Rời album được chia sẻ?';

  @override
  String get leaveAlbum => 'Rời khỏi album';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'Ảnh bạn đã thêm sẽ bị xóa khỏi album';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted =>
      'Bạn không có tệp nào có thể xóa trong album này';

  @override
  String get youDontHaveAnyArchivedItems => 'Bạn không có mục nào đã lưu trữ.';

  @override
  String get ignoredFolderUploadReason =>
      'Một số tệp trong album này bị bỏ qua khi tải lên vì chúng đã bị xóa trước đó từ Ente.';

  @override
  String get resetIgnoredFiles => 'Đặt lại các tệp bị bỏ qua';

  @override
  String get deviceFilesAutoUploading =>
      'Các tệp được thêm vào album thiết bị này sẽ tự động được tải lên Ente.';

  @override
  String get turnOnBackupForAutoUpload =>
      'Bật sao lưu để tự động tải lên các tệp được thêm vào thư mục thiết bị này lên Ente.';

  @override
  String get noHiddenPhotosOrVideos => 'Không có ảnh hoặc video ẩn';

  @override
  String get toHideAPhotoOrVideo => 'Để ẩn một ảnh hoặc video';

  @override
  String get openTheItem => '• Mở mục';

  @override
  String get clickOnTheOverflowMenu => '• Nhấn vào menu xổ xuống';

  @override
  String get click => '• Nhấn';

  @override
  String get nothingToSeeHere => 'Ở đây không có gì để xem! 👀';

  @override
  String get unarchiveAlbum => 'Bỏ lưu trữ album';

  @override
  String get archiveAlbum => 'Lưu trữ album';

  @override
  String get calculating => 'Đang tính toán...';

  @override
  String get pleaseWaitDeletingAlbum => 'Vui lòng chờ, đang xóa album';

  @override
  String get searchByExamples =>
      '• Tên album (vd: \"Camera\")\n• Loại tệp (vd: \"Video\", \".gif\")\n• Năm và tháng (vd: \"2022\", \"Tháng Một\")\n• Ngày lễ (vd: \"Giáng Sinh\")\n• Mô tả ảnh (vd: “#vui”)';

  @override
  String get youCanTrySearchingForADifferentQuery =>
      'Bạn có thể thử tìm kiếm một truy vấn khác.';

  @override
  String get noResultsFound => 'Không tìm thấy kết quả';

  @override
  String addedBy({required Object emailOrName}) {
    return 'Được thêm bởi $emailOrName';
  }

  @override
  String get loadingExifData => 'Đang lấy thông số Exif...';

  @override
  String get viewAllExifData => 'Xem thông số Exif';

  @override
  String get noExifData => 'Không có Exif';

  @override
  String get thisImageHasNoExifData => 'Ảnh này không có thông số Exif';

  @override
  String get exif => 'Exif';

  @override
  String get noResults => 'Không có kết quả';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'Chúng tôi chưa hỗ trợ chỉnh sửa ảnh và album không phải bạn sở hữu';

  @override
  String get failedToFetchOriginalForEdit =>
      'Không thể lấy bản gốc để chỉnh sửa';

  @override
  String get close => 'Đóng';

  @override
  String get setAs => 'Đặt làm';

  @override
  String get fileSavedToGallery => 'Tệp đã được lưu vào thư viện';

  @override
  String get filesSavedToGallery => 'Các tệp đã được lưu vào thư viện';

  @override
  String get fileFailedToSaveToGallery => 'Không thể lưu tệp vào thư viện';

  @override
  String get download => 'Tải xuống';

  @override
  String get pressAndHoldToPlayVideo => 'Nhấn giữ để phát video';

  @override
  String get pressAndHoldToPlayVideoDetailed => 'Nhấn giữ ảnh để phát video';

  @override
  String get downloadFailed => 'Tải xuống thất bại';

  @override
  String get deduplicateFiles => 'Xóa trùng lặp';

  @override
  String get deselectAll => 'Bỏ chọn tất cả';

  @override
  String get reviewDeduplicateItems =>
      'Vui lòng xem qua và xóa các mục mà bạn tin là trùng lặp.';

  @override
  String get clubByCaptureTime => 'Xếp theo thời gian chụp';

  @override
  String get clubByFileName => 'Xếp theo tên tệp';

  @override
  String get count => 'Số lượng';

  @override
  String get totalSize => 'Tổng dung lượng';

  @override
  String get longpressOnAnItemToViewInFullscreen =>
      'Nhấn giữ một mục để xem toàn màn hình';

  @override
  String get decryptingVideo => 'Đang giải mã video...';

  @override
  String get authToViewYourMemories => 'Vui lòng xác thực để xem kỷ niệm';

  @override
  String get unlock => 'Mở khóa';

  @override
  String get freeUpSpace => 'Giải phóng dung lượng';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Xóa chúng khỏi thiết bị để giải phóng $formattedSize',
      one: 'Xóa chúng khỏi thiết bị để giải phóng $formattedSize',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber tệp',
    );
    return '$_temp0 trong album đã được sao lưu an toàn';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber tệp',
    );
    return '$_temp0 trên thiết bị đã được sao lưu an toàn';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'chúng',
      one: 'chúng',
    );
    return 'Bạn vẫn có thể truy cập $_temp0 trên Ente, miễn là gói của bạn còn hiệu lực';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return 'Giải phóng $sizeInMBorGB';
  }

  @override
  String get thisEmailIsAlreadyInUse => 'Email này đã được sử dụng';

  @override
  String get incorrectCode => 'Mã không chính xác';

  @override
  String get authenticationFailedPleaseTryAgain =>
      'Xác thực không thành công, vui lòng thử lại';

  @override
  String get verificationFailedPleaseTryAgain =>
      'Xác minh không thành công, vui lòng thử lại';

  @override
  String get authenticating => 'Đang xác thực...';

  @override
  String get authenticationSuccessful => 'Xác thực thành công!';

  @override
  String get incorrectRecoveryKey => 'Mã khôi phục không chính xác';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect =>
      'Mã khôi phục bạn nhập không chính xác';

  @override
  String get twofactorAuthenticationSuccessfullyReset =>
      'Xác thực 2 bước đã được đặt lại thành công';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered =>
      'Vui lòng xác minh mã bạn đã nhập';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      'Vui lòng liên hệ bộ phận hỗ trợ nếu vấn đề vẫn tiếp diễn';

  @override
  String get twofactorAuthenticationHasBeenDisabled =>
      'Xác thực 2 bước đã bị vô hiệu hóa';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect =>
      'Rất tiếc, mã bạn nhập không chính xác';

  @override
  String get yourVerificationCodeHasExpired => 'Mã xác minh của bạn đã hết hạn';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'Email đã được đổi thành $newEmail';
  }

  @override
  String get verifying => 'Đang xác minh...';

  @override
  String get disablingTwofactorAuthentication =>
      'Đang vô hiệu hóa xác thực 2 bước...';

  @override
  String get allMemoriesPreserved => 'Tất cả kỷ niệm đã được lưu giữ';

  @override
  String get loadingGallery => 'Đang tải thư viện...';

  @override
  String get syncing => 'Đang đồng bộ...';

  @override
  String get encryptingBackup => 'Đang mã hóa sao lưu...';

  @override
  String get syncStopped => 'Đồng bộ hóa đã dừng';

  @override
  String syncProgress({required String completed, required String total}) {
    return '$completed/$total kỷ niệm đã được lưu giữ';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return 'Đang lưu giữ $count kỷ niệm...';
  }

  @override
  String get uploadingSingleMemory => 'Đang lưu giữ 1 kỷ niệm...';

  @override
  String get archiving => 'Đang lưu trữ...';

  @override
  String get unarchiving => 'Đang bỏ lưu trữ...';

  @override
  String get successfullyArchived => 'Lưu trữ thành công';

  @override
  String get successfullyUnarchived => 'Bỏ lưu trữ thành công';

  @override
  String get renameFile => 'Đổi tên tệp';

  @override
  String get enterFileName => 'Nhập tên tệp';

  @override
  String get filesDeleted => 'Tệp đã bị xóa';

  @override
  String get selectedFilesAreNotOnEnte => 'Các tệp đã chọn không có trên Ente';

  @override
  String get thisActionCannotBeUndone => 'Không thể hoàn tác thao tác này';

  @override
  String get emptyTrash => 'Xóa sạch thùng rác?';

  @override
  String get permDeleteWarning =>
      'Tất cả các mục trong thùng rác sẽ bị xóa vĩnh viễn\n\nKhông thể hoàn tác thao tác này';

  @override
  String get empty => 'Xóa sạch';

  @override
  String get couldNotFreeUpSpace => 'Không thể giải phóng dung lượng';

  @override
  String get permanentlyDeleteFromDevice => 'Xóa vĩnh viễn khỏi thiết bị?';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      'Một số tệp bạn đang cố gắng xóa chỉ có trên thiết bị của bạn và không thể khôi phục nếu bị xóa';

  @override
  String get theyWillBeDeletedFromAllAlbums =>
      'Nó sẽ bị xóa khỏi tất cả album.';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'Một số mục có trên cả Ente và thiết bị của bạn.';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      'Các tệp đã chọn sẽ bị xóa khỏi tất cả album và cho vào thùng rác.';

  @override
  String get theseItemsWillBeDeletedFromYourDevice =>
      'Các mục này sẽ bị xóa khỏi thiết bị của bạn.';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      'Có vẻ đã xảy ra sự cố. Vui lòng thử lại sau ít phút. Nếu lỗi vẫn tiếp diễn, hãy liên hệ với đội ngũ hỗ trợ của chúng tôi.';

  @override
  String get error => 'Lỗi';

  @override
  String get tempErrorContactSupportIfPersists =>
      'Có vẻ đã xảy ra sự cố. Vui lòng thử lại sau ít phút. Nếu lỗi vẫn tiếp diễn, hãy liên hệ với đội ngũ hỗ trợ của chúng tôi.';

  @override
  String get networkHostLookUpErr =>
      'Không thể kết nối với Ente, vui lòng kiểm tra cài đặt mạng của bạn và liên hệ với bộ phận hỗ trợ nếu lỗi vẫn tiếp diễn.';

  @override
  String get networkConnectionRefusedErr =>
      'Không thể kết nối với Ente, vui lòng thử lại sau ít phút. Nếu lỗi vẫn tiếp diễn, hãy liên hệ với bộ phận hỗ trợ.';

  @override
  String get cachedData => 'Dữ liệu đã lưu trong bộ nhớ đệm';

  @override
  String get clearCaches => 'Xóa bộ nhớ cache';

  @override
  String get remoteImages => 'Ảnh bên ngoài';

  @override
  String get remoteVideos => 'Video bên ngoài';

  @override
  String get remoteThumbnails => 'Ảnh thu nhỏ bên ngoài';

  @override
  String get pendingSync => 'Đồng bộ hóa đang chờ';

  @override
  String get localGallery => 'Thư viện cục bộ';

  @override
  String get todaysLogs => 'Nhật ký hôm nay';

  @override
  String get viewLogs => 'Xem nhật ký';

  @override
  String get logsDialogBody =>
      'Gửi file nhật ký để chúng tôi có thể phân tích lỗi mà bạn gặp. Lưu ý rằng, trong nhật ký lỗi sẽ bao gồm tên các tệp để giúp theo dõi vấn đề với từng tệp cụ thể.';

  @override
  String get preparingLogs => 'Đang ghi nhật ký...';

  @override
  String get emailYourLogs => 'Gửi nhật ký qua email';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'Vui lòng gửi nhật ký đến \n$toEmail';
  }

  @override
  String get copyEmailAddress => 'Sao chép địa chỉ email';

  @override
  String get exportLogs => 'Xuất nhật ký';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return 'Vui lòng gửi email cho chúng tôi tại $toEmail';
  }

  @override
  String get dismiss => 'Bỏ qua';

  @override
  String get didYouKnow => 'Bạn có biết?';

  @override
  String get loadingMessage => 'Đang tải ảnh của bạn...';

  @override
  String get loadMessage1 => 'Bạn có thể chia sẻ gói của mình với gia đình';

  @override
  String get loadMessage2 =>
      'Chúng tôi đã lưu giữ hơn 200 triệu kỷ niệm cho đến hiện tại';

  @override
  String get loadMessage3 =>
      'Chúng tôi giữ 3 bản sao dữ liệu của bạn, một cái lưu ở hầm trú ẩn hạt nhân';

  @override
  String get loadMessage4 =>
      'Tất cả các ứng dụng của chúng tôi đều là mã nguồn mở';

  @override
  String get loadMessage5 =>
      'Mã nguồn và mã hóa của chúng tôi đã được kiểm nghiệm ngoại bộ';

  @override
  String get loadMessage6 =>
      'Bạn có thể chia sẻ liên kết đến album của mình với những người thân yêu';

  @override
  String get loadMessage7 =>
      'Các ứng dụng di động của chúng tôi chạy ngầm để mã hóa và sao lưu bất kỳ ảnh nào bạn mới chụp';

  @override
  String get loadMessage8 => 'web.ente.io có một trình tải lên mượt mà';

  @override
  String get loadMessage9 =>
      'Chúng tôi sử dụng Xchacha20Poly1305 để mã hóa dữ liệu của bạn';

  @override
  String get photoDescriptions => 'Mô tả ảnh';

  @override
  String get fileTypesAndNames => 'Loại tệp và tên';

  @override
  String get location => 'Vị trí';

  @override
  String get moments => 'Khoảnh khắc';

  @override
  String get searchFaceEmptySection =>
      'Người sẽ được hiển thị ở đây khi quá trình xử lý hoàn tất';

  @override
  String get searchDatesEmptySection => 'Tìm kiếm theo ngày, tháng hoặc năm';

  @override
  String get searchLocationEmptySection =>
      'Xếp nhóm những ảnh được chụp gần kề nhau';

  @override
  String get searchPeopleEmptySection =>
      'Mời mọi người, và bạn sẽ thấy tất cả ảnh mà họ chia sẻ ở đây';

  @override
  String get searchAlbumsEmptySection => 'Album';

  @override
  String get searchFileTypesAndNamesEmptySection => 'Loại tệp và tên';

  @override
  String get searchCaptionEmptySection =>
      'Thêm mô tả như \"#phượt\" trong thông tin ảnh để tìm nhanh thấy chúng ở đây';

  @override
  String get language => 'Ngôn ngữ';

  @override
  String get selectLanguage => 'Chọn ngôn ngữ';

  @override
  String get locationName => 'Tên vị trí';

  @override
  String get addLocation => 'Thêm vị trí';

  @override
  String get groupNearbyPhotos => 'Nhóm ảnh gần nhau';

  @override
  String get kiloMeterUnit => 'km';

  @override
  String get addLocationButton => 'Thêm';

  @override
  String get radius => 'Bán kính';

  @override
  String get locationTagFeatureDescription =>
      'Thẻ vị trí sẽ giúp xếp nhóm tất cả ảnh được chụp gần kề nhau';

  @override
  String get galleryMemoryLimitInfo =>
      'Mỗi thư viện chứa tối đa 1000 ảnh và video';

  @override
  String get save => 'Lưu';

  @override
  String get centerPoint => 'Tâm điểm';

  @override
  String get pickCenterPoint => 'Chọn tâm điểm';

  @override
  String get useSelectedPhoto => 'Sử dụng ảnh đã chọn';

  @override
  String get resetToDefault => 'Đặt lại mặc định';

  @override
  String get edit => 'Chỉnh sửa';

  @override
  String get deleteLocation => 'Xóa vị trí';

  @override
  String get rotateLeft => 'Xoay trái';

  @override
  String get flip => 'Lật';

  @override
  String get rotateRight => 'Xoay phải';

  @override
  String get saveCopy => 'Lưu bản sao';

  @override
  String get light => 'Độ sáng';

  @override
  String get color => 'Màu sắc';

  @override
  String get yesDiscardChanges => 'Có, bỏ qua thay đổi';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade =>
      'Bạn có muốn bỏ qua các chỉnh sửa đã thực hiện không?';

  @override
  String get saving => 'Đang lưu...';

  @override
  String get editsSaved => 'Chỉnh sửa đã được lưu';

  @override
  String get oopsCouldNotSaveEdits => 'Ốii!, không thể lưu chỉnh sửa';

  @override
  String get distanceInKMUnit => 'km';

  @override
  String get dayToday => 'Hôm nay';

  @override
  String get dayYesterday => 'Hôm qua';

  @override
  String get storage => 'Dung lượng';

  @override
  String get usedSpace => 'Dung lượng đã dùng';

  @override
  String get storageBreakupFamily => 'Gia đình';

  @override
  String get storageBreakupYou => 'Bạn';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return '$usedAmount $usedStorageUnit / $totalAmount $totalStorageUnit đã dùng';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return '$freeAmount $storageUnit trống';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'Phiên bản: $versionValue';
  }

  @override
  String get verifyIDLabel => 'Xác minh';

  @override
  String get fileInfoAddDescHint => 'Thêm mô tả...';

  @override
  String get editLocationTagTitle => 'Chỉnh sửa vị trí';

  @override
  String get setLabel => 'Đặt';

  @override
  String get setRadius => 'Đặt bán kính';

  @override
  String get familyPlanPortalTitle => 'Gia đình';

  @override
  String get familyPlanOverview =>
      'Thêm 5 thành viên gia đình vào gói hiện tại của bạn mà không phải trả thêm phí.\n\nMỗi thành viên có không gian riêng tư của mình và không thể xem tệp của nhau trừ khi được chia sẻ.\n\nGói gia đình có sẵn cho người dùng Ente gói trả phí.\n\nĐăng ký ngay để bắt đầu!';

  @override
  String get androidBiometricHint => 'Xác minh danh tính';

  @override
  String get androidBiometricNotRecognized => 'Không nhận diện được. Thử lại.';

  @override
  String get androidBiometricSuccess => 'Thành công';

  @override
  String get androidCancelButton => 'Hủy';

  @override
  String get androidSignInTitle => 'Yêu cầu xác thực';

  @override
  String get androidBiometricRequiredTitle => 'Yêu cầu sinh trắc học';

  @override
  String get androidDeviceCredentialsRequiredTitle =>
      'Yêu cầu thông tin xác thực thiết bị';

  @override
  String get androidDeviceCredentialsSetupDescription =>
      'Yêu cầu thông tin xác thực thiết bị';

  @override
  String get goToSettings => 'Đi đến cài đặt';

  @override
  String get androidGoToSettingsDescription =>
      'Xác thực sinh trắc học chưa được thiết lập trên thiết bị của bạn. Đi đến \'Cài đặt > Bảo mật\' để thêm xác thực sinh trắc học.';

  @override
  String get iOSLockOut =>
      'Xác thực sinh trắc học đã bị vô hiệu hóa. Vui lòng khóa và mở khóa màn hình của bạn để kích hoạt lại.';

  @override
  String get iOSGoToSettingsDescription =>
      'Xác thực sinh trắc học chưa được thiết lập trên thiết bị của bạn. Vui lòng kích hoạt Touch ID hoặc Face ID.';

  @override
  String get iOSOkButton => 'OK';

  @override
  String get openstreetmapContributors => 'Người đóng góp OpenStreetMap';

  @override
  String get hostedAtOsmFrance => 'Được lưu trữ tại OSM Pháp';

  @override
  String get map => 'Bản đồ';

  @override
  String get maps => 'Bản đồ';

  @override
  String get mapsPrivacyNotice =>
      'Tọa độ gần đúng sẽ được gửi đến các bên thứ ba quan tâm đến quyền riêng tư như OpenStreetMap để hiển thị bản đồ và vị trí.';

  @override
  String get enableMaps => 'Kích hoạt Bản đồ';

  @override
  String get quickLinks => 'Liên kết nhanh';

  @override
  String get selectItemsToAdd => 'Chọn mục để thêm';

  @override
  String get addSelected => 'Thêm mục đã chọn';

  @override
  String get addFromDevice => 'Thêm từ thiết bị';

  @override
  String get addPhotos => 'Thêm ảnh';

  @override
  String get noPhotosFoundHere => 'Không tìm thấy ảnh ở đây';

  @override
  String get zoomOutToSeePhotos => 'Phóng to để xem ảnh';

  @override
  String get noImagesWithLocation => 'Không có ảnh với vị trí';

  @override
  String get unpinAlbum => 'Bỏ ghim album';

  @override
  String get pinAlbum => 'Ghim album';

  @override
  String get pin => 'Ghim';

  @override
  String get pinPerson => 'Pin person';

  @override
  String get pinToTop => 'Ghim lên đầu';

  @override
  String get unpin => 'Bỏ ghim';

  @override
  String get unpinPerson => 'Unpin person';

  @override
  String get visibility => 'Hiển thị';

  @override
  String get hideFromMemories => 'Ẩn khỏi kỷ niệm';

  @override
  String get showInMemories => 'Show in memories';

  @override
  String get create => 'Tạo';

  @override
  String get viewAll => 'Xem tất cả';

  @override
  String get nothingSharedWithYouYet => 'Bạn chưa được chia sẻ gì';

  @override
  String get noAlbumsSharedByYouYet => 'Bạn chưa chia sẻ album nào';

  @override
  String get sharedWithYou => 'Được chia sẻ với bạn';

  @override
  String get sharedByYou => 'Được chia sẻ bởi bạn';

  @override
  String get inviteYourFriendsToEnte => 'Mời bạn bè dùng Ente';

  @override
  String get failedToDownloadVideo => 'Không thể tải video';

  @override
  String get hiding => 'Đang ẩn...';

  @override
  String get unhiding => 'Đang hiện...';

  @override
  String get successfullyHid => 'Đã ẩn thành công';

  @override
  String get successfullyUnhid => 'Đã hiện thành công';

  @override
  String get crashReporting => 'Báo cáo sự cố';

  @override
  String get resumableUploads => 'Cho phép tải lên tiếp tục';

  @override
  String get addToHiddenAlbum => 'Thêm vào album ẩn';

  @override
  String get moveToHiddenAlbum => 'Di chuyển đến album ẩn';

  @override
  String get fileTypes => 'Loại tệp';

  @override
  String get deleteConfirmDialogBody =>
      'Tài khoản này được liên kết với các ứng dụng Ente khác, nếu bạn có dùng. Dữ liệu bạn đã tải lên, trên tất cả ứng dụng Ente, sẽ được lên lịch để xóa, và tài khoản của bạn sẽ bị xóa vĩnh viễn.';

  @override
  String get hearUsWhereTitle => 'Bạn biết Ente từ đâu? (tùy chọn)';

  @override
  String get hearUsExplanation =>
      'Chúng tôi không theo dõi cài đặt ứng dụng, nên nếu bạn bật mí bạn tìm thấy chúng tôi từ đâu sẽ rất hữu ích!';

  @override
  String get viewAddOnButton => 'Xem tiện ích mở rộng';

  @override
  String get addOns => 'Tiện ích mở rộng';

  @override
  String get addOnPageSubtitle => 'Chi tiết về tiện ích mở rộng';

  @override
  String get yourMap => 'Bản đồ của bạn';

  @override
  String get modifyYourQueryOrTrySearchingFor =>
      'Chỉnh sửa truy vấn của bạn, hoặc thử tìm';

  @override
  String get blackFridaySale => 'Giảm giá Black Friday';

  @override
  String get upto50OffUntil4thDec => 'Giảm tới 50%, đến ngày 4 Tháng 12.';

  @override
  String get photos => 'Ảnh';

  @override
  String get videos => 'Video';

  @override
  String get livePhotos => 'Ảnh động';

  @override
  String get searchHint1 => 'Tìm kiếm nhanh, trên thiết bị';

  @override
  String get searchHint2 => 'Ngày chụp, mô tả ảnh';

  @override
  String get searchHint3 => 'Album, tên tệp và loại';

  @override
  String get searchHint4 => 'Vị trí';

  @override
  String get searchHint5 =>
      'Sắp ra mắt: Nhận diện khuôn mặt & tìm kiếm vi diệu ✨';

  @override
  String get addYourPhotosNow => 'Thêm ảnh của bạn ngay bây giờ';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count kết quả đã tìm thấy',
    );
    return '$_temp0';
  }

  @override
  String get faces => 'Khuôn mặt';

  @override
  String get people => 'Người';

  @override
  String get contents => 'Nội dung';

  @override
  String get addNew => 'Thêm mới';

  @override
  String get contacts => 'Danh bạ';

  @override
  String get noInternetConnection => 'Không có kết nối internet';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'Vui lòng kiểm tra kết nối internet của bạn và thử lại.';

  @override
  String get signOutFromOtherDevices => 'Đăng xuất khỏi các thiết bị khác';

  @override
  String get signOutOtherBody =>
      'Nếu bạn nghĩ rằng ai đó biết mật khẩu của bạn, hãy ép tài khoản của bạn đăng xuất khỏi tất cả thiết bị khác đang sử dụng.';

  @override
  String get signOutOtherDevices => 'Đăng xuất khỏi các thiết bị khác';

  @override
  String get doNotSignOut => 'Không đăng xuất';

  @override
  String get editLocation => 'Chỉnh sửa vị trí';

  @override
  String get selectALocation => 'Chọn một vị trí';

  @override
  String get selectALocationFirst => 'Chọn một vị trí trước';

  @override
  String get changeLocationOfSelectedItems =>
      'Thay đổi vị trí của các mục đã chọn?';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte =>
      'Các chỉnh sửa vị trí sẽ chỉ thấy được trong Ente';

  @override
  String get cleanUncategorized => 'Dọn dẹp chưa phân loại';

  @override
  String get cleanUncategorizedDescription =>
      'Xóa khỏi mục Chưa phân loại với tất cả tệp đang xuất hiện trong các album khác';

  @override
  String get waitingForVerification => 'Đang chờ xác minh...';

  @override
  String get passkey => 'Khóa truy cập';

  @override
  String get passkeyAuthTitle => 'Xác minh khóa truy cập';

  @override
  String get loginWithTOTP => 'Đăng nhập bằng TOTP';

  @override
  String get passKeyPendingVerification => 'Xác minh vẫn đang chờ';

  @override
  String get loginSessionExpired => 'Phiên đăng nhập đã hết hạn';

  @override
  String get loginSessionExpiredDetails =>
      'Phiên đăng nhập của bạn đã hết hạn. Vui lòng đăng nhập lại.';

  @override
  String get verifyPasskey => 'Xác minh khóa truy cập';

  @override
  String get playOnTv => 'Phát album trên TV';

  @override
  String get pair => 'Kết nối';

  @override
  String get deviceNotFound => 'Không tìm thấy thiết bị';

  @override
  String get castInstruction =>
      'Truy cập cast.ente.io trên thiết bị bạn muốn kết nối.\n\nNhập mã dưới đây để phát album trên TV của bạn.';

  @override
  String get deviceCodeHint => 'Nhập mã';

  @override
  String get joinDiscord => 'Tham gia Discord';

  @override
  String get locations => 'Vị trí';

  @override
  String get addAName => 'Thêm một tên';

  @override
  String get findThemQuickly => 'Tìm họ nhanh chóng';

  @override
  String get findPeopleByName => 'Tìm nhanh người theo tên';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Thêm người xem',
      one: 'Thêm người xem',
      zero: 'Thêm người xem',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Thêm cộng tác viên',
      one: 'Thêm cộng tác viên',
      zero: 'Thêm cộng tác viên',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      'Nhấn giữ một email để xác minh mã hóa đầu cuối.';

  @override
  String get developerSettingsWarning =>
      'Bạn có chắc muốn thay đổi cài đặt Nhà phát triển không?';

  @override
  String get developerSettings => 'Cài đặt Nhà phát triển';

  @override
  String get serverEndpoint => 'Điểm cuối máy chủ';

  @override
  String get invalidEndpoint => 'Điểm cuối không hợp lệ';

  @override
  String get invalidEndpointMessage =>
      'Xin lỗi, điểm cuối bạn nhập không hợp lệ. Vui lòng nhập một điểm cuối hợp lệ và thử lại.';

  @override
  String get endpointUpdatedMessage => 'Điểm cuối đã được cập nhật thành công';

  @override
  String customEndpoint({required Object endpoint}) {
    return 'Đã kết nối với $endpoint';
  }

  @override
  String get createCollaborativeLink => 'Tạo liên kết cộng tác';

  @override
  String get search => 'Tìm kiếm';

  @override
  String get enterPersonName => 'Nhập tên người';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'Email này đã được liên kết với $name trước.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return 'Xem $name để hủy liên kết';
  }

  @override
  String get enterName => 'Nhập tên';

  @override
  String get savePerson => 'Lưu người';

  @override
  String get editPerson => 'Chỉnh sửa người';

  @override
  String get mergedPhotos => 'Hợp nhất ảnh';

  @override
  String get orMergeWithExistingPerson => 'Hoặc hợp nhất với hiện có';

  @override
  String get enterDateOfBirth => 'Sinh nhật (tùy chọn)';

  @override
  String get birthday => 'Sinh nhật';

  @override
  String get removePersonLabel => 'Xóa nhãn người';

  @override
  String get autoPairDesc =>
      'Kết nối tự động chỉ hoạt động với các thiết bị hỗ trợ Chromecast.';

  @override
  String get manualPairDesc =>
      'Kết nối bằng PIN hoạt động với bất kỳ màn hình nào bạn muốn.';

  @override
  String get connectToDevice => 'Kết nối với thiết bị';

  @override
  String get autoCastDialogBody =>
      'Bạn sẽ thấy các thiết bị phát khả dụng ở đây.';

  @override
  String get autoCastiOSPermission =>
      'Hãy chắc rằng quyền Mạng cục bộ đã được bật cho ứng dụng Ente Photos, trong Cài đặt.';

  @override
  String get noDeviceFound => 'Không tìm thấy thiết bị';

  @override
  String get stopCastingTitle => 'Dừng phát';

  @override
  String get stopCastingBody => 'Bạn có muốn dừng phát không?';

  @override
  String get castIPMismatchTitle => 'Không thể phát album';

  @override
  String get castIPMismatchBody =>
      'Hãy chắc rằng bạn đang dùng chung mạng với TV.';

  @override
  String get pairingComplete => 'Kết nối hoàn tất';

  @override
  String get savingEdits => 'Đang lưu chỉnh sửa...';

  @override
  String get autoPair => 'Kết nối tự động';

  @override
  String get pairWithPin => 'Kết nối bằng PIN';

  @override
  String get faceRecognition => 'Nhận diện khuôn mặt';

  @override
  String get foundFaces => 'Đã tìm thấy khuôn mặt';

  @override
  String get clusteringProgress => 'Tiến trình phân cụm';

  @override
  String get trim => 'Cắt';

  @override
  String get crop => 'Cắt xén';

  @override
  String get rotate => 'Xoay';

  @override
  String get left => 'Trái';

  @override
  String get right => 'Phải';

  @override
  String get whatsNew => 'Có gì mới';

  @override
  String get reviewSuggestions => 'Xem gợi ý';

  @override
  String get review => 'Xem lại';

  @override
  String get useAsCover => 'Đặt làm ảnh bìa';

  @override
  String notPersonLabel({required String name}) {
    return 'Không phải $name?';
  }

  @override
  String get enable => 'Bật';

  @override
  String get enabled => 'Bật';

  @override
  String get moreDetails => 'Thông tin thêm';

  @override
  String get enableMLIndexingDesc =>
      'Ente hỗ trợ học máy trên-thiết-bị nhằm nhận diện khuôn mặt, tìm kiếm vi diệu và các tính năng tìm kiếm nâng cao khác';

  @override
  String get magicSearchHint =>
      'Tìm kiếm vi diệu cho phép tìm ảnh theo nội dung của chúng, ví dụ: \'xe hơi\', \'xe hơi đỏ\', \'Ferrari\'';

  @override
  String get panorama => 'Panorama';

  @override
  String get reenterPassword => 'Nhập lại mật khẩu';

  @override
  String get reenterPin => 'Nhập lại PIN';

  @override
  String get deviceLock => 'Khóa thiết bị';

  @override
  String get pinLock => 'Khóa PIN';

  @override
  String get next => 'Tiếp theo';

  @override
  String get setNewPassword => 'Đặt mật khẩu mới';

  @override
  String get enterPin => 'Nhập PIN';

  @override
  String get setNewPin => 'Đặt PIN mới';

  @override
  String get appLock => 'Khóa ứng dụng';

  @override
  String get noSystemLockFound => 'Không tìm thấy khóa hệ thống';

  @override
  String get tapToUnlock => 'Nhấn để mở khóa';

  @override
  String get tooManyIncorrectAttempts => 'Thử sai nhiều lần';

  @override
  String get videoInfo => 'Thông tin video';

  @override
  String get autoLock => 'Khóa tự động';

  @override
  String get immediately => 'Lập tức';

  @override
  String get autoLockFeatureDescription =>
      'Sau thời gian này, ứng dụng sẽ khóa sau khi được chạy ở chế độ nền';

  @override
  String get hideContent => 'Ẩn nội dung';

  @override
  String get hideContentDescriptionAndroid =>
      'Ẩn nội dung ứng dụng trong trình chuyển đổi ứng dụng và vô hiệu hóa chụp màn hình';

  @override
  String get hideContentDescriptionIos =>
      'Ẩn nội dung ứng dụng trong trình chuyển đổi ứng dụng';

  @override
  String get passwordStrengthInfo =>
      'Độ mạnh của mật khẩu được tính toán dựa trên độ dài của mật khẩu, các ký tự đã sử dụng và liệu mật khẩu có xuất hiện trong 10.000 mật khẩu được sử dụng nhiều nhất hay không';

  @override
  String get noQuickLinksSelected => 'Không có liên kết nhanh nào được chọn';

  @override
  String get pleaseSelectQuickLinksToRemove =>
      'Vui lòng chọn liên kết nhanh để xóa';

  @override
  String get removePublicLinks => 'Xóa liên kết công khai';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      'Liên kết công khai của tất cả các liên kết nhanh đã chọn sẽ bị xóa.';

  @override
  String get guestView => 'Chế độ khách';

  @override
  String get guestViewEnablePreSteps =>
      'Để bật chế độ khách, vui lòng thiết lập mã khóa thiết bị hoặc khóa màn hình trong cài đặt hệ thống của bạn.';

  @override
  String get nameTheAlbum => 'Đặt tên cho album';

  @override
  String get collectPhotosDescription =>
      'Tạo một liên kết nơi bạn bè của bạn có thể tải lên ảnh với chất lượng gốc.';

  @override
  String get collect => 'Thu thập';

  @override
  String get appLockDescriptions =>
      'Chọn giữa màn hình khóa mặc định của thiết bị và màn hình khóa tùy chỉnh với PIN hoặc mật khẩu.';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'Để bật khóa ứng dụng, vui lòng thiết lập mã khóa thiết bị hoặc khóa màn hình trong cài đặt hệ thống của bạn.';

  @override
  String get authToViewPasskey => 'Vui lòng xác thực để xem khóa truy cập';

  @override
  String get loopVideoOn => 'Tắt lặp';

  @override
  String get loopVideoOff => 'Bật lặp';

  @override
  String get localSyncErrorMessage =>
      'Có vẻ như có điều gì đó không ổn vì đồng bộ ảnh cục bộ đang tốn nhiều thời gian hơn mong đợi. Vui lòng liên hệ đội ngũ hỗ trợ của chúng tôi';

  @override
  String get showPerson => 'Hiện người';

  @override
  String get sort => 'Sắp xếp';

  @override
  String get mostRecent => 'Mới nhất';

  @override
  String get mostRelevant => 'Liên quan nhất';

  @override
  String get loadingYourPhotos => 'Đang tải ảnh của bạn...';

  @override
  String processingImport({required Object folderName}) {
    return 'Đang xử lý $folderName...';
  }

  @override
  String get personName => 'Tên người';

  @override
  String get addNewPerson => 'Thêm người mới';

  @override
  String get addNameOrMerge => 'Thêm tên hoặc hợp nhất';

  @override
  String get mergeWithExisting => 'Hợp nhất với người đã có';

  @override
  String get newPerson => 'Người mới';

  @override
  String get addName => 'Thêm tên';

  @override
  String get add => 'Thêm';

  @override
  String extraPhotosFoundFor({required String text}) {
    return 'Tìm thấy ảnh bổ sung cho $text';
  }

  @override
  String get extraPhotosFound => 'Tìm thấy ảnh bổ sung';

  @override
  String get configuration => 'Cấu hình';

  @override
  String get localIndexing => 'Chỉ mục cục bộ';

  @override
  String get processed => 'Đã xử lý';

  @override
  String get resetPerson => 'Xóa';

  @override
  String get areYouSureYouWantToResetThisPerson =>
      'Bạn có chắc muốn đặt lại người này không?';

  @override
  String get allPersonGroupingWillReset =>
      'Tất cả nhóm của người này sẽ được đặt lại, và bạn sẽ mất tất cả các gợi ý đã được tạo ra cho người này';

  @override
  String get yesResetPerson => 'Có, đặt lại người';

  @override
  String get onlyThem => 'Chỉ họ';

  @override
  String get checkingModels => 'Đang kiểm tra mô hình...';

  @override
  String get enableMachineLearningBanner =>
      'Bật học máy để tìm kiếm vi diệu và nhận diện khuôn mặt';

  @override
  String get searchDiscoverEmptySection =>
      'Ảnh sẽ được hiển thị ở đây sau khi xử lý và đồng bộ hoàn tất';

  @override
  String get searchPersonsEmptySection =>
      'Người sẽ được hiển thị ở đây sau khi hoàn tất xử lý và đồng bộ';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Đã thêm $count người xem',
      one: 'Đã thêm 1 người xem',
      zero: 'Chưa thêm người xem',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Đã thêm $count cộng tác viên',
      one: 'Đã thêm 1 cộng tác viên',
      zero: 'Chưa có cộng tác viên',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured => 'Tài khoản đã được cấu hình.';

  @override
  String get sessionIdMismatch => 'Mã phiên không khớp';

  @override
  String get failedToFetchActiveSessions => 'Không thể lấy phiên hoạt động';

  @override
  String get failedToRefreshStripeSubscription => 'Không thể làm mới gói';

  @override
  String get failedToPlayVideo => 'Không thể phát video';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return 'Tải lên bị bỏ qua do $ignoreReason';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'Loại thư viện $galleryType không được hỗ trợ đổi tên';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'Nhấn để tải lên, tải lên hiện tại bị bỏ qua do $ignoreReason';
  }

  @override
  String get tapToUpload => 'Nhấn để tải lên';

  @override
  String get info => 'Thông tin';

  @override
  String get addFiles => 'Thêm tệp';

  @override
  String get castAlbum => 'Phát album';

  @override
  String get imageNotAnalyzed => 'Hình ảnh chưa được phân tích';

  @override
  String get noFacesFound => 'Không tìm thấy khuôn mặt';

  @override
  String get fileNotUploadedYet => 'Tệp chưa được tải lên';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return 'Không có gợi ý cho $personName';
  }

  @override
  String get month => 'tháng';

  @override
  String get yearShort => 'năm';

  @override
  String get currentlyRunning => 'đang chạy';

  @override
  String get ignored => 'bỏ qua';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ảnh',
      one: '1 ảnh',
      zero: 'Chưa có ảnh',
    );
    return '$_temp0';
  }

  @override
  String get file => 'Tệp';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'Độ dài các phần không khớp: $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'Chọn ứng dụng email';

  @override
  String get selectAllShort => 'Tất cả';

  @override
  String get selectCoverPhoto => 'Chọn ảnh bìa';

  @override
  String get newLocation => 'Vị trí mới';

  @override
  String get faceNotClusteredYet =>
      'Khuôn mặt chưa được phân cụm, vui lòng quay lại sau';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'Liên kết mà bạn truy cập đã hết hạn.';

  @override
  String get openFile => 'Mở tệp';

  @override
  String get backupFile => 'Sao lưu tệp';

  @override
  String get openAlbumInBrowser => 'Mở album trong trình duyệt';

  @override
  String get openAlbumInBrowserTitle =>
      'Vui lòng sử dụng ứng dụng web để thêm ảnh vào album này';

  @override
  String get allow => 'Cho phép';

  @override
  String get allowAppToOpenSharedAlbumLinks =>
      'Cho phép ứng dụng mở liên kết album chia sẻ';

  @override
  String get seePublicAlbumLinksInApp =>
      'Xem liên kết album công khai trong ứng dụng';

  @override
  String get emergencyContacts => 'Liên hệ khẩn cấp';

  @override
  String get acceptTrustInvite => 'Chấp nhận lời mời';

  @override
  String get declineTrustInvite => 'Từ chối lời mời';

  @override
  String get removeYourselfAsTrustedContact => 'Gỡ bỏ bạn khỏi liên hệ tin cậy';

  @override
  String get legacy => 'Thừa kế';

  @override
  String get legacyPageDesc =>
      'Thừa kế cho phép các liên hệ tin cậy truy cập tài khoản của bạn khi bạn qua đời.';

  @override
  String get legacyPageDesc2 =>
      'Các liên hệ tin cậy có thể khởi động quá trình khôi phục tài khoản, và nếu không bị chặn trong vòng 30 ngày, có thể đặt lại mật khẩu và truy cập tài khoản của bạn.';

  @override
  String get legacyAccounts => 'Tài khoản thừa kế';

  @override
  String get trustedContacts => 'Liên hệ tin cậy';

  @override
  String get addTrustedContact => 'Thêm liên hệ tin cậy';

  @override
  String get removeInvite => 'Gỡ bỏ lời mời';

  @override
  String get recoveryWarning =>
      'Một liên hệ tin cậy đang cố gắng truy cập tài khoản của bạn';

  @override
  String get rejectRecovery => 'Từ chối khôi phục';

  @override
  String get recoveryInitiated => 'Quá trình khôi phục đã được khởi động';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return 'Bạn có thể truy cập tài khoản sau $days ngày. Một thông báo sẽ được gửi đến $email.';
  }

  @override
  String get cancelAccountRecovery => 'Hủy khôi phục';

  @override
  String get recoveryAccount => 'Khôi phục tài khoản';

  @override
  String get cancelAccountRecoveryBody =>
      'Bạn có chắc muốn hủy khôi phục không?';

  @override
  String get startAccountRecoveryTitle => 'Bắt đầu khôi phục';

  @override
  String get whyAddTrustContact =>
      'Liên hệ tin cậy có thể giúp khôi phục dữ liệu của bạn.';

  @override
  String recoveryReady({required String email}) {
    return 'Bạn có thể khôi phục tài khoản của $email bằng cách đặt lại mật khẩu mới.';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email đang cố gắng khôi phục tài khoản của bạn.';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return 'Bạn đã được mời làm người thừa kế của $email.';
  }

  @override
  String get warning => 'Cảnh báo';

  @override
  String get proceed => 'Tiếp tục';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return 'Bạn sắp thêm $email làm liên hệ tin cậy. Họ sẽ có thể khôi phục tài khoản của bạn nếu bạn không hoạt động trong $numOfDays ngày.';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email đã mời bạn trở thành một liên hệ tin cậy';
  }

  @override
  String get authToManageLegacy =>
      'Vui lòng xác thực để quản lý các liên hệ tin cậy';

  @override
  String get hideSharedItemsFromHomeGallery =>
      'Ẩn các mục được chia sẻ khỏi thư viện chính';

  @override
  String get swipeToSelect => 'Quẹt để chọn';

  @override
  String get gallery => 'Thư viện';

  @override
  String get joinAlbum => 'Tham gia album';

  @override
  String get joinAlbumSubtext => 'để xem và thêm ảnh của bạn';

  @override
  String get joinAlbumSubtextViewer => 'để thêm vào album được chia sẻ';

  @override
  String get join => 'Tham gia';

  @override
  String get linkEmail => 'Liên kết email';

  @override
  String get link => 'Liên kết';

  @override
  String get noEnteAccountExclamation => 'Chưa có tài khoản Ente!';

  @override
  String get orPickFromYourContacts => 'hoặc chọn từ danh bạ';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return '$email chưa có tài khoản Ente.';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (Tôi)';
  }

  @override
  String get reassignMe => 'Chỉ định lại \"Tôi\"';

  @override
  String get me => 'Tôi';

  @override
  String get linkEmailToContactBannerCaption => 'để chia sẻ nhanh hơn';

  @override
  String get selectPersonToLink => 'Chọn người để liên kết';

  @override
  String linkPersonToEmail({required String email}) {
    return 'Liên kết người với $email';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return 'Việc này sẽ liên kết $personName với $email';
  }

  @override
  String get selectYourFace => 'Chọn khuôn mặt bạn';

  @override
  String get reassigningLoading => 'Đang chỉ định lại...';

  @override
  String reassignedToName({required String name}) {
    return 'Đã chỉ định lại bạn thành $name';
  }

  @override
  String get saveChangesBeforeLeavingQuestion => 'Lưu thay đổi trước khi rời?';

  @override
  String get dontSave => 'Không lưu';

  @override
  String get thisIsMeExclamation => 'Đây là tôi!';

  @override
  String get linkPerson => 'Liên kết người';

  @override
  String get linkPersonCaption => 'để trải nghiệm chia sẻ tốt hơn';

  @override
  String get videoStreaming => 'Phát trực tuyến video';

  @override
  String get processingVideos => 'Đang xử lý video';

  @override
  String get streamDetails => 'Chi tiết phát';

  @override
  String get processing => 'Đang xử lý';

  @override
  String get queued => 'Đang chờ';

  @override
  String get ineligible => 'Không đủ điều kiện';

  @override
  String get failed => 'Không thành công';

  @override
  String get playStream => 'Phát trực tiếp';

  @override
  String get playOriginal => 'Phát tệp gốc';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'Tham gia một album sẽ khiến email của bạn hiển thị với những người tham gia khác.';

  @override
  String get pleaseWaitThisWillTakeAWhile =>
      'Vui lòng chờ, có thể mất một lúc.';

  @override
  String get editTime => 'Chỉnh sửa thời gian';

  @override
  String get selectTime => 'Chọn thời gian';

  @override
  String get selectDate => 'Chọn ngày';

  @override
  String get previous => 'Trước';

  @override
  String get selectOneDateAndTimeForAll => 'Chọn một ngày và giờ cho tất cả';

  @override
  String get selectStartOfRange => 'Chọn phạm vi bắt đầu';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      'Thao tác này sẽ làm cho ngày và giờ của tất cả ảnh được chọn đều giống nhau.';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'Đây là ảnh đầu tiên trong nhóm. Các ảnh được chọn khác sẽ tự động thay đổi dựa theo ngày mới này';

  @override
  String get newRange => 'Phạm vi mới';

  @override
  String get selectOneDateAndTime => 'Chọn một ngày và giờ';

  @override
  String get moveSelectedPhotosToOneDate =>
      'Di chuyển ảnh đã chọn đến một ngày';

  @override
  String get shiftDatesAndTime => 'Di chuyển ngày và giờ';

  @override
  String get photosKeepRelativeTimeDifference =>
      'Ảnh giữ nguyên chênh lệch thời gian tương đối';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ảnh',
      one: '1 ảnh',
      zero: 'Chưa có ảnh',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'Biểu tượng ứng dụng';

  @override
  String get notThisPerson => 'Không phải người này?';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      'Các mục đã chọn sẽ bị xóa khỏi người này, nhưng không bị xóa khỏi thư viện của bạn.';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat qua các năm';
  }

  @override
  String get thisWeekThroughTheYears => 'Tuần này qua các năm';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Tuần này, $count năm trước',
      one: 'Tuần này, $count năm trước',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'Bạn và $name';
  }

  @override
  String admiringThem({required Object name}) {
    return 'Ngưỡng mộ $name';
  }

  @override
  String embracingThem({required Object name}) {
    return 'Yêu mến $name';
  }

  @override
  String partyWithThem({required Object name}) {
    return 'Quẩy với $name';
  }

  @override
  String hikingWithThem({required Object name}) {
    return 'Leo núi với $name';
  }

  @override
  String feastingWithThem({required Object name}) {
    return 'Tiệc tùng với $name';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return 'Selfie với $name';
  }

  @override
  String posingWithThem({required Object name}) {
    return 'Làm dáng với $name';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return 'Ngắm cảnh với $name';
  }

  @override
  String sportsWithThem({required Object name}) {
    return 'Chơi thể thao với $name';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return 'Đi bộ với $name';
  }

  @override
  String get spotlightOnYourself => 'Tập trung vào bản thân bạn';

  @override
  String spotlightOnThem({required Object name}) {
    return 'Tập trung vào $name';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$name đã $age tuổi!';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name sắp $age tuổi';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return 'Lần cuối với $name';
  }

  @override
  String tripToLocation({required Object location}) {
    return 'Phượt ở $location';
  }

  @override
  String tripInYear({required Object year}) {
    return 'Phượt năm $year';
  }

  @override
  String get lastYearsTrip => 'Phượt năm ngoái';

  @override
  String get sunrise => 'Đường chân trời';

  @override
  String get mountains => 'Đồi núi';

  @override
  String get greenery => 'Cây cối';

  @override
  String get beach => 'Cát và biển';

  @override
  String get city => 'Trong thành phố';

  @override
  String get moon => 'Ánh trăng';

  @override
  String get onTheRoad => 'Trên đường';

  @override
  String get food => 'Ăn chơi';

  @override
  String get pets => 'Thú cưng';

  @override
  String get curatedMemories => 'Kỷ niệm đáng nhớ';

  @override
  String get widgets => 'Tiện ích';

  @override
  String get memories => 'Kỷ niệm';

  @override
  String get peopleWidgetDesc =>
      'Chọn những người bạn muốn thấy trên màn hình chính của mình.';

  @override
  String get albumsWidgetDesc =>
      'Chọn những album bạn muốn thấy trên màn hình chính của mình.';

  @override
  String get memoriesWidgetDesc =>
      'Chọn những loại kỷ niệm bạn muốn thấy trên màn hình chính của mình.';

  @override
  String get smartMemories => 'Gợi nhớ kỷ niệm';

  @override
  String get pastYearsMemories => 'Kỷ niệm năm ngoái';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return 'Xóa luôn ảnh (và video) có trong $count album này khỏi <bold>mọi album khác</bold> có chứa chúng?';
  }

  @override
  String get addParticipants => 'Thêm người tham gia';

  @override
  String selectedAlbums({required Object count}) {
    return '$count đã chọn';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'Hành động không áp dụng trong album Đã thích';

  @override
  String get onThisDayMemories => 'Kỷ niệm hôm nay';

  @override
  String get onThisDay => 'Vào ngày này';

  @override
  String get lookBackOnYourMemories => 'Xem lại kỷ niệm của bạn 🌄';

  @override
  String get newPhotosEmoji => ' mới 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'Rất tiếc, chúng tôi phải dừng sao lưu cho bạn';

  @override
  String get clickToInstallOurBestVersionYet =>
      'Nhấn để cài đặt phiên bản tốt nhất';

  @override
  String get onThisDayNotificationExplanation =>
      'Nhắc về những kỷ niệm ngày này trong những năm trước.';

  @override
  String get addMemoriesWidgetPrompt =>
      'Thêm tiện ích kỷ niệm vào màn hình chính và quay lại đây để tùy chỉnh.';

  @override
  String get addAlbumWidgetPrompt =>
      'Thêm tiện ích album vào màn hình chính và quay lại đây để tùy chỉnh.';

  @override
  String get addPeopleWidgetPrompt =>
      'Thêm tiện ích người vào màn hình chính và quay lại đây để tùy chỉnh.';

  @override
  String get birthdayNotifications => 'Thông báo sinh nhật';

  @override
  String get receiveRemindersOnBirthdays =>
      'Nhắc khi đến sinh nhật của ai đó. Nhấn vào thông báo sẽ đưa bạn đến ảnh của người sinh nhật.';

  @override
  String get happyBirthday => 'Chúc mừng sinh nhật! 🥳';

  @override
  String get birthdays => 'Sinh nhật';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return 'Chúc $name sinh nhật vui vẻ! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      'Bạn có chắc muốn xóa khuôn mặt này khỏi người này không?';

  @override
  String get otherDetectedFaces => 'Những khuôn mặt khác được phát hiện';

  @override
  String get areThey => 'Họ có phải là ';

  @override
  String get questionmark => '?';

  @override
  String get saveAsAnotherPerson => 'Lưu như một người khác';

  @override
  String get showLessFaces => 'Hiện ít khuôn mặt hơn';

  @override
  String get showMoreFaces => 'Hiện nhiều khuôn mặt hơn';

  @override
  String get ignore => 'Bỏ qua';

  @override
  String get merge => 'Hợp nhất';

  @override
  String get reset => 'Đặt lại';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      'Bạn có chắc muốn bỏ qua người này?';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      'Bạn có chắc muốn bỏ qua những người này?';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'Nhóm người sẽ không được hiển thị trong phần người nữa. Ảnh sẽ vẫn được giữ nguyên.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'Người sẽ không được hiển thị trong phần người nữa. Ảnh sẽ vẫn được giữ nguyên.';

  @override
  String get areYouSureYouWantToMergeThem => 'Bạn có chắc muốn hợp nhất họ?';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'Tất cả nhóm không có tên sẽ được hợp nhất vào người đã chọn. Điều này vẫn có thể được hoàn tác từ tổng quan lịch sử đề xuất của người đó.';

  @override
  String get yesIgnore => 'Có, bỏ qua';

  @override
  String get same => 'Chính xác';

  @override
  String get different => 'Khác';

  @override
  String get sameperson => 'Cùng một người?';

  @override
  String get indexingPausedStatusDescription =>
      'Lập chỉ mục bị tạm dừng. Nó sẽ tự động tiếp tục khi thiết bị đã sẵn sàng. Thiết bị được coi là sẵn sàng khi mức pin, tình trạng pin và trạng thái nhiệt độ nằm trong phạm vi tốt.';

  @override
  String get thisWeek => 'Tuần này';

  @override
  String get lastWeek => 'Tuần trước';

  @override
  String get thisMonth => 'Tháng này';

  @override
  String get thisYear => 'Năm nay';

  @override
  String get groupBy => 'Phân nhóm theo';

  @override
  String get faceThumbnailGenerationFailed =>
      'Không thể tạo ảnh thu nhỏ khuôn mặt';

  @override
  String get fileAnalysisFailed => 'Không thể xác định tệp';

  @override
  String get editAutoAddPeople => 'Sửa tự động thêm người';

  @override
  String get autoAddPeople => 'Tự động thêm người';

  @override
  String get autoAddToAlbum => 'Tự động thêm vào album';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      'Bạn có muốn xóa các tệp liên quan đến người đã được chọn trước đó trong album thông minh không?';

  @override
  String get addingPhotos => 'Đang thêm ảnh';

  @override
  String get gettingReady => 'Chuẩn bị sẵn sàng';

  @override
  String get addSomePhotosDesc1 => 'Thêm vài ảnh hoặc chọn ';

  @override
  String get addSomePhotosDesc2 => 'những khuôn mặt giống nhau';

  @override
  String get addSomePhotosDesc3 => '\nđể bắt đầu với';

  @override
  String get ignorePerson => 'Bỏ qua người';

  @override
  String get mixedGrouping => 'Nhóm hỗn hợp?';

  @override
  String get analysis => 'Phân tích';

  @override
  String get doesGroupContainMultiplePeople => 'Nhóm này có chứa nhiều người?';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'Chúng tôi sẽ tự động phân tích nhóm để xác định xem có nhiều người góp mặt hay không và tách họ ra lần nữa. Việc này có thể mất vài giây.';

  @override
  String get layout => 'Bố cục';

  @override
  String get day => 'Ngày';

  @override
  String get undo => 'Hoàn tác';

  @override
  String get redo => 'Làm lại';

  @override
  String get filter => 'Bộ lọc';

  @override
  String get adjust => 'Điều chỉnh';

  @override
  String get draw => 'Vẽ';

  @override
  String get sticker => 'Sticker';

  @override
  String get brushColor => 'Màu cọ';

  @override
  String get font => 'Phông chữ';

  @override
  String get background => 'Nền';

  @override
  String get align => 'Căn chỉnh';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Đã thêm vào $count album thành công',
      one: 'Đã thêm vào 1 album thành công',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => 'Video đã được xử lý';

  @override
  String get totalVideos => 'Tổng số video';

  @override
  String get skippedVideos => 'Video bị bỏ qua';

  @override
  String get videoStreamingDescriptionLine1 =>
      'Phát video trên bất kỳ thiết bị.';

  @override
  String get videoStreamingDescriptionLine2 =>
      'Bật để xử lý luồng phát video trên thiết bị này.';

  @override
  String get videoStreamingNote =>
      'Thiết bị này chỉ xử lý các video từ 60 ngày trở xuống và có thời lượng dưới 1 phút. Đối với các video cũ hơn/dài hơn, hãy bật tính năng phát trực tuyến trong ứng dụng máy tính để bàn.';

  @override
  String get createStream => 'Tạo phát trực tiếp';

  @override
  String get recreateStream => 'Tạo lại phát trực tiếp';

  @override
  String get addedToStreamCreationQueue => 'Đã thêm vào hàng đợi tạo luồng';

  @override
  String get addedToStreamRecreationQueue =>
      'Đã thêm vào hàng đợi tạo lại luồng';

  @override
  String get videoPreviewAlreadyExists => 'Bản xem trước video đã tồn tại';

  @override
  String get videoAlreadyInQueue => 'Tệp video đã có trong hàng đợi';

  @override
  String get videoExportFailed =>
      'Tạo video không thành công. Vui lòng thử lại.';

  @override
  String videoExportSuccess({required String path}) {
    return 'Đã tạo video thành công tại $path';
  }

  @override
  String get addedToQueue => 'Đã thêm vào hàng đợi';

  @override
  String get creatingStream => 'Đang tạo luồng';

  @override
  String get similarImages => 'Ảnh giống nhau';

  @override
  String get findSimilarImages => 'Tìm ảnh giống nhau';

  @override
  String get noSimilarImagesFound => 'Không tìm thấy ảnh giống nhau';

  @override
  String get yourPhotosLookUnique => 'Ảnh của bạn trông độc đáo';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count nhóm được tìm thấy',
      one: '$count nhóm được tìm thấy',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages => 'Xem lại và xóa ảnh giống nhau';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return 'Xóa $count ảnh ($size)';
  }

  @override
  String get selectionOptions => 'Tùy chọn lựa chọn';

  @override
  String selectExactWithCount({required int count}) {
    return 'Giống nhau hoàn toàn ($count)';
  }

  @override
  String get selectExact => 'Chọn chính xác';

  @override
  String selectSimilarWithCount({required int count}) {
    return 'Giống nhau một phần ($count)';
  }

  @override
  String get selectSimilar => 'Chọn giống nhau';

  @override
  String selectAllWithCount({required int count}) {
    return 'Tất cả giống nhau ($count)';
  }

  @override
  String get selectSimilarImagesTitle => 'Chọn những ảnh giống nhau';

  @override
  String get chooseSimilarImagesToSelect =>
      'Chọn ảnh dựa trên sự tương đồng thị giác';

  @override
  String get clearSelection => 'Bỏ chọn';

  @override
  String similarImagesCount({required int count}) {
    return '$count ảnh giống nhau';
  }

  @override
  String deleteWithCount({required int count}) {
    return 'Xóa ($count)';
  }

  @override
  String get deleteFiles => 'Xóa các tệp';

  @override
  String get areYouSureDeleteFiles => 'Bạn có chắc muốn xóa các tệp này?';

  @override
  String get greatJob => 'Tốt lắm!';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return 'Bạn tiết kiệm được $size';
  }

  @override
  String get size => 'Dung lượng';

  @override
  String get similarity => 'Sự giống nhau';

  @override
  String get analyzingPhotosLocally => 'Phân tích ảnh của bạn trên thiết bị...';

  @override
  String get lookingForVisualSimilarities =>
      'Tìm theo sự tương đồng thị giác...';

  @override
  String get comparingImageDetails => 'So sánh các đặc điểm ảnh...';

  @override
  String get findingSimilarImages => 'Tìm các ảnh giống nhau...';

  @override
  String get almostDone => 'Sắp xong...';

  @override
  String get processingLocally => 'Đang xử lý cục bộ';

  @override
  String get useMLToFindSimilarImages =>
      'Xem lại và xóa những ảnh có vẻ giống nhau.';

  @override
  String get all => 'Tất cả';

  @override
  String get similar => 'Giống nhau';

  @override
  String get identical => 'Giống hệt nhau';

  @override
  String get nothingHereTryAnotherFilter =>
      'Không thấy gì, hãy thử thay đổi bộ lọc! 👀';

  @override
  String get related => 'Có liên quan';

  @override
  String get hoorayyyy => 'Hoorayyyy!';

  @override
  String get nothingToTidyUpHere => 'Ở đây đã ngon lành rồi';

  @override
  String get deletingDash => 'Đang xóa - ';

  @override
  String get cLTitle1 => 'Chuyển đến ngày';

  @override
  String get cLDesc1 =>
      'Xem các ảnh xung quanh cho bất kỳ ảnh nào bằng cách chọn tùy chọn chuyển đến ngày trong ngăn thông tin của tệp.';

  @override
  String get cLTitle2 => 'Chỉnh sửa video nhanh hơn';

  @override
  String get cLDesc2 =>
      'Trình chỉnh sửa video đã được cải tiến để cải thiện đáng kể tốc độ khi chỉnh sửa video lớn cũng như cải thiện UX.';

  @override
  String get cLTitle3 => 'Kỷ niệm mới';

  @override
  String get cLDesc3 =>
      '\"Những đứa trẻ vui tươi\", \"Cuộc phiêu lưu mùa đông\", \"Đêm neon\" và hơn thế nữa.';

  @override
  String get cLTitle4 => 'Phòng trưng bày phong cảnh và hơn thế nữa';

  @override
  String get cLDesc4 =>
      'Hỗ trợ bố cục ngang trong thư viện chính của ứng dụng. Hiển thị những người không có bất kỳ ảnh liên quan nào thay vì lọc chúng ra. Cải thiện khả năng phát hiện khía cạnh video khi được chia sẻ từ các ứng dụng bên ngoài.';

  @override
  String get closeBy => 'Gần giống';

  @override
  String get peopleAutoAddDesc =>
      'Tự động thêm ảnh của những người đã chọn vào album này';

  @override
  String get festivities => 'Vui lễ hội';

  @override
  String get snowAdventures => 'Phiêu lưu mùa đông';

  @override
  String get waterfalls => 'Thác nước';

  @override
  String get wildlife => 'Vào trong hoang dã';

  @override
  String get flowers => 'Nở thắm';

  @override
  String get nightLights => 'Đêm neon';

  @override
  String get architecture => 'Biểu tượng thiết kế';

  @override
  String get autumnColors => 'Thu quyến rũ';

  @override
  String get desertDreams => 'Giấc mơ sa mạc';

  @override
  String get stargazing => 'Dưới những vì sao';

  @override
  String get lakeside => 'Hồ tĩnh lặng';

  @override
  String get rainyDays => 'Ngày mưa';

  @override
  String get sportsAction => 'Trò chơi';

  @override
  String get streetArt => 'Đường phố';

  @override
  String get familyMoments => 'Gia đình';

  @override
  String get fireworks => 'Pháo hoa';

  @override
  String get historicSites => 'Di tích lịch sử';

  @override
  String get tropicalParadise => 'Rừng nhiệt đới';

  @override
  String get forestTrails => 'Đi dạo trong rừng';

  @override
  String get citySunsets => 'Hoàng hôn thành phố';

  @override
  String get colorfulMarkets => 'Khu chợ sắc màu';

  @override
  String get cozyCafes => 'Góc cà phê';

  @override
  String get vintageVibes => 'Cổ điển';

  @override
  String get aerialViews => 'Trên không trung';

  @override
  String get artisticPortraits => 'Chân dung nghệ thuật';

  @override
  String get streetFood => 'Món ngon đường phố';

  @override
  String get riverCruises => 'Cảnh quan trên sông';

  @override
  String get facesTimelineBannerTitle => 'Hồi Ức';

  @override
  String facesTimelineBannerSubtitle({required String name}) {
    return 'Xem ảnh của $name qua từng năm';
  }

  @override
  String get facesTimelineAppBarTitle => 'Hồi ức';

  @override
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count tuổi',
    );
    return '$name vừa tròn $_temp0';
  }

  @override
  String facesTimelineCaptionYearsAgo({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '# năm trước',
    );
    return '$_temp0';
  }

  @override
  String get facesTimelineShareComingSoon => 'Chia sẻ video sẽ sớm ra mắt';

  @override
  String get facesTimelinePlaybackPrevious => 'Trước';

  @override
  String get facesTimelinePlaybackNext => 'Kế tiếp';

  @override
  String get facesTimelinePlaybackPlay => 'Phát';

  @override
  String get facesTimelinePlaybackPause => 'Dừng';

  @override
  String get facesTimelineUnavailable => 'Đang chuẩn bị dòng thời gian...';

  @override
  String get playfulKids => 'Trẻ em vui chơi';

  @override
  String get coastalCliffs => 'Vách đá bên bờ biển';

  @override
  String get ritualsTitle => 'Rituals';

  @override
  String get ritualAddTooltip => 'Add ritual';

  @override
  String get ritualActivityHeading => 'Activity';

  @override
  String get ritualDefaultHeatmapTitle => 'Take a photo every day';

  @override
  String get ritualUntitled => 'Untitled ritual';

  @override
  String get ritualShareUnavailable =>
      'Unable to share right now. Please try again.';

  @override
  String get ritualNotificationMessage => 'Take a photo now';

  @override
  String get ritualCameraNotFound => 'No camera found on this device.';

  @override
  String get ritualCameraStartError =>
      'Unable to start camera. Please check permissions.';

  @override
  String get ritualCaptureError => 'Unable to capture photo. Please try again.';

  @override
  String ritualPhotoLimit({required int maxPhotos}) {
    String _temp0 = intl.Intl.pluralLogic(
      maxPhotos,
      locale: localeName,
      other: '# photos.',
      one: '# photo.',
    );
    return 'You can add up to $_temp0';
  }

  @override
  String get ritualCaptureAtLeastOne => 'Capture at least one photo first.';

  @override
  String get ritualAlbumMissing =>
      'Ritual album missing. Edit the ritual to set an album.';

  @override
  String get ritualAddedToAlbum => 'Added to album';

  @override
  String ritualAddedToAlbumWithName({required String albumName}) {
    return 'Added to $albumName';
  }

  @override
  String ritualAddToAlbumFailure({required String error}) {
    return 'Couldn\'t add photos to the album: $error';
  }

  @override
  String get ritualBackToList => 'Back to rituals';

  @override
  String get ritualNoPhotosYet => 'No photos yet';

  @override
  String get ritualSetAlbumToLaunchCamera =>
      'Set an album for this ritual to launch the camera.';

  @override
  String get ritualDefaultCameraTitle => 'Take a photo';

  @override
  String get ritualBadgeMessage7 =>
      '7 days down! Consistency looks good on you. Keep going!';

  @override
  String get ritualBadgeMessage14 =>
      '14 days in! Your ritual is becoming a habit. Incredible!';

  @override
  String get ritualBadgeMessage30 =>
      '30 days in a row! Legendary consistency. Take a bow!';

  @override
  String get ritualBadgeMessageDefault => 'You\'re on a roll!';

  @override
  String get ritualBadgeNewTitle => 'New achievement';

  @override
  String get ritualBadgePreparing => 'Preparing...';

  @override
  String get ritualStreaksLabel => 'Streaks';

  @override
  String get ritualCreateYourOwn => 'Create your own ritual';

  @override
  String get ritualGetDailyReminders => 'Get daily reminders';

  @override
  String get ritualAlbumNotSet => 'Album not set';

  @override
  String get ritualOpenCameraTooltip => 'Open ritual camera';

  @override
  String get ritualEditorLabel => 'Ritual editor';

  @override
  String get ritualNew => 'New ritual';

  @override
  String get ritualEdit => 'Edit ritual';

  @override
  String get ritualEnterPrompt => 'Enter your ritual';

  @override
  String get ritualEnterDescription => 'Please enter a description';

  @override
  String get ritualDayLabel => 'Day';

  @override
  String get ritualNotificationsOffHint =>
      'Notifications are off. Tap a day to turn them on.';

  @override
  String get ritualTimeLabel => 'Time';

  @override
  String get ritualAlbumLabel => 'Album';

  @override
  String get ritualSave => 'Save ritual';

  @override
  String get ritualUpdate => 'Update ritual';

  @override
  String get ritualSelectAlbumTitle => 'Select album';

  @override
  String get ritualSearchOrCreate => 'Search or create new';

  @override
  String get ritualNoAlbumsYet => 'No albums yet';

  @override
  String get ritualNoMatchingAlbums => 'No matching albums';

  @override
  String ritualCreateAlbumWithName({required String albumName}) {
    return 'Create \"$albumName\"';
  }

  @override
  String get ritualCreateNew => 'Create new';

  @override
  String get ritualAlbumSelectionPlaceholder => 'Select album';

  @override
  String get ritualPickEmojiTitle => 'Pick an emoji';

  @override
  String get ritualCustomKeyboardLabel => 'Custom (keyboard)';

  @override
  String get ritualEmojiKeyboardHint => 'Press to open emoji keyboard';

  @override
  String get ritualEmojiUseAction => 'Use';

  @override
  String get ritualSearchEmpty =>
      'Build a ritual to keep your photo habit going.';
}
