// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Swedish (`sv`).
class AppLocalizationsSv extends AppLocalizations {
  AppLocalizationsSv([String locale = 'sv']) : super(locale);

  @override
  String get enterYourEmailAddress => 'Ange din e-postadress';

  @override
  String get enterYourNewEmailAddress => 'Ange din nya e-postadress';

  @override
  String get accountWelcomeBack => 'Välkommen tillbaka!';

  @override
  String get emailAlreadyRegistered => 'E-postadress redan registrerad.';

  @override
  String get emailNotRegistered => 'E-postadressen är inte registrerad.';

  @override
  String get email => 'E-post';

  @override
  String get cancel => 'Avbryt';

  @override
  String get verify => 'Bekräfta';

  @override
  String get invalidEmailAddress => 'Ogiltig e-postadress';

  @override
  String get enterValidEmail => 'Ange en giltig e-postadress.';

  @override
  String get deleteAccount => 'Radera konto';

  @override
  String get deleteAccountWarning =>
      'This will delete your Ente Auth, Ente Photos and Ente Locker account.';

  @override
  String get askDeleteReason =>
      'Vad är den främsta anledningen till att du raderar ditt konto?';

  @override
  String get deleteAccountFeedbackPrompt =>
      'Vi är ledsna att se dig lämna oss. Vänligen dela dina synpunkter för att hjälpa oss att förbättra.';

  @override
  String get feedback => 'Feedback';

  @override
  String get kindlyHelpUsWithThisInformation =>
      'Vänligen hjälp oss med denna information';

  @override
  String get confirmDeletePrompt =>
      'Ja, jag vill permanent ta bort detta konto och data i alla appar.';

  @override
  String get confirmAccountDeletion => 'Bekräfta radering av konto';

  @override
  String get deleteAccountPermanentlyButton => 'Radera kontot permanent';

  @override
  String get yourAccountHasBeenDeleted => 'Ditt konto har raderats';

  @override
  String get selectReason => 'Välj anledning';

  @override
  String get deleteReason1 => 'Det saknas en viktig funktion som jag behöver';

  @override
  String get deleteReason2 =>
      'Appen eller en viss funktion beter sig inte som jag tycker det ska';

  @override
  String get deleteReason3 =>
      'Jag hittade en annan tjänst som jag gillar bättre';

  @override
  String get deleteReason4 => 'Min orsak finns inte med';

  @override
  String get sendEmail => 'Skicka e-post';

  @override
  String get deleteRequestSLAText =>
      'Din begäran kommer att hanteras inom 72 timmar.';

  @override
  String get deleteEmailRequest =>
      'Vänligen skicka ett e-postmeddelande till <warning>account-deletion@ente.io</warning> från din registrerade e-postadress.';

  @override
  String get entePhotosPerm =>
      'Ente <i>behöver tillåtelse att</i> bevara dina foton';

  @override
  String get ok => 'OK';

  @override
  String get createAccount => 'Skapa konto';

  @override
  String get createNewAccount => 'Skapa nytt konto';

  @override
  String get password => 'Lösenord';

  @override
  String get confirmPassword => 'Bekräfta lösenord';

  @override
  String get activeSessions => 'Aktiva sessioner';

  @override
  String get ocrProcessingOverlayMessage => 'Upptäcker text...';

  @override
  String get ocrLoadingIndicatorLabel => 'Upptäcker text';

  @override
  String get ocrSelectionHint =>
      'Swipe or double tap to select just what you need';

  @override
  String get ocrNoTextDetected => 'Ingen text upptäckt';

  @override
  String get ocrRetryButtonLabel => 'Försök igen';

  @override
  String get ocrModelsNetworkRequiredError =>
      'Network connection required to download OCR models on first use';

  @override
  String get ocrModelsPrepareFailed => 'Kunde inte förbereda OCR-modeller';

  @override
  String get ocrImageNotFoundError => 'Bildfil hittades inte';

  @override
  String get ocrImageDecodeFailedError => 'Kunde inte läsa bildfil';

  @override
  String get ocrGenericDetectError => 'Could not detect text in image';

  @override
  String get oops => 'Hoppsan';

  @override
  String get somethingWentWrongPleaseTryAgain =>
      'Något gick fel, vänligen försök igen';

  @override
  String get thisWillLogYouOutOfThisDevice =>
      'Detta kommer att logga ut dig från denna enhet!';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice =>
      'Detta kommer att logga ut dig från följande enhet:';

  @override
  String get terminateSession => 'Avsluta sessionen?';

  @override
  String get terminate => 'Avsluta';

  @override
  String get thisDevice => 'Den här enheten';

  @override
  String get recoverButton => 'Återställ';

  @override
  String get recoverySuccessful => 'Återställning lyckades!';

  @override
  String get decrypting => 'Dekrypterar...';

  @override
  String get incorrectRecoveryKeyTitle => 'Felaktig återställningsnyckel';

  @override
  String get incorrectRecoveryKeyBody =>
      'Återställningsnyckeln du angav är felaktig';

  @override
  String get forgotPassword => 'Glömt lösenord';

  @override
  String get enterYourRecoveryKey => 'Ange din återställningsnyckel';

  @override
  String get noRecoveryKey => 'Ingen återställningsnyckel?';

  @override
  String get sorry => 'Förlåt';

  @override
  String get noRecoveryKeyNoDecryption =>
      'På grund av vårt punkt-till-punkt-krypteringssystem så kan dina data inte avkrypteras utan ditt lösenord eller återställningsnyckel';

  @override
  String get verifyEmail => 'Bekräfta e-postadress';

  @override
  String get toResetVerifyEmail =>
      'För att återställa ditt lösenord måste du först bekräfta din e-postadress.';

  @override
  String get checkInboxAndSpamFolder =>
      'Kontrollera din inkorg (och skräppost) för att slutföra verifieringen';

  @override
  String get tapToEnterCode => 'Tryck för att ange kod';

  @override
  String get resendEmail => 'Skicka e-postmeddelandet igen';

  @override
  String weHaveSendEmailTo({required String email}) {
    return 'Vi har skickat ett e-postmeddelande till <green>$email</green>';
  }

  @override
  String get setPasswordTitle => 'Välj lösenord';

  @override
  String get changePasswordTitle => 'Ändra lösenord';

  @override
  String get resetPasswordTitle => 'Återställ lösenord';

  @override
  String get encryptionKeys => 'Krypteringsnycklar';

  @override
  String get passwordWarning =>
      'Vi lagrar inte detta lösenord, så om du glömmer bort det, <underline>kan vi inte dekryptera dina data</underline>';

  @override
  String get enterPasswordToEncrypt =>
      'Ange ett lösenord som vi kan använda för att kryptera din data';

  @override
  String get enterNewPasswordToEncrypt =>
      'Ange ett nytt lösenord som vi kan använda för att kryptera din data';

  @override
  String get weakStrength => 'Svagt';

  @override
  String get strongStrength => 'Starkt';

  @override
  String get moderateStrength => 'Måttligt';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'Lösenordsstyrka: $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully => 'Lösenordet har ändrats';

  @override
  String get generatingEncryptionKeys => 'Skapar krypteringsnycklar...';

  @override
  String get pleaseWait => 'Var god vänta...';

  @override
  String get continueLabel => 'Fortsätt';

  @override
  String get insecureDevice => 'Osäker enhet';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'Tyvärr, vi kunde inte generera säkra nycklar på den här enheten.\n\nVänligen registrera dig från en annan enhet.';

  @override
  String get howItWorks => 'Så här fungerar det';

  @override
  String get encryption => 'Kryptering';

  @override
  String get ackPasswordLostWarning =>
      'Jag förstår att om jag förlorar mitt lösenord kan jag förlora mina data eftersom min data är <underline>end-to-end-krypterad</underline>.';

  @override
  String get privacyPolicyTitle => 'Integritetspolicy';

  @override
  String get termsOfServicesTitle => 'Villkor';

  @override
  String get signUpTerms =>
      'Jag samtycker till <u-terms>användarvillkoren</u-terms> och <u-policy>integritetspolicyn</u-policy>';

  @override
  String get logInLabel => 'Logga in';

  @override
  String get loginTerms =>
      'Genom att klicka på logga in godkänner jag <u-terms>användarvillkoren</u-terms> och våran <u-policy>integritetspolicy</u-policy>';

  @override
  String get changeEmail => 'Ändra e-postadress';

  @override
  String get enterYourPassword => 'Ange ditt lösenord';

  @override
  String get welcomeBack => 'Välkommen tillbaka!';

  @override
  String get contactSupport => 'Kontakta support';

  @override
  String get locationPickerTip =>
      'You can also add a location centered on a photo from the photo\'s info screen';

  @override
  String get incorrectPasswordTitle => 'Felaktigt lösenord';

  @override
  String get pleaseTryAgain => 'Försök igen';

  @override
  String get recreatePasswordTitle => 'Återskapa lösenord';

  @override
  String get useRecoveryKey => 'Använd återställningsnyckel';

  @override
  String get recreatePasswordBody =>
      'Denna enhet är inte tillräckligt kraftfull för att verifiera ditt lösenord, men vi kan återskapa det på ett sätt som fungerar med alla enheter.\n\nLogga in med din återställningsnyckel och återskapa ditt lösenord (du kan använda samma igen om du vill).';

  @override
  String get verifyPassword => 'Bekräfta lösenord';

  @override
  String get recoveryKey => 'Återställningsnyckel';

  @override
  String get recoveryKeyOnForgotPassword =>
      'Om du glömmer ditt lösenord är det enda sättet du kan återställa dina data med denna nyckel.';

  @override
  String get recoveryKeySaveDescription =>
      'Vi lagrar inte och har därför inte åtkomst till denna nyckel, vänligen spara denna 24 ords nyckel på en säker plats.';

  @override
  String get doThisLater => 'Gör detta senare';

  @override
  String get saveKey => 'Spara nyckel';

  @override
  String get recoveryKeyCopiedToClipboard =>
      'Återställningsnyckel kopierad till urklipp';

  @override
  String get recoverAccount => 'Återställ konto';

  @override
  String get recover => 'Återställ';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'Vänligen skicka ett e-postmeddelande till $supportEmail från din registrerade e-postadress';
  }

  @override
  String get twofactorSetup => 'Tvåfaktorskonfiguration';

  @override
  String get enterCode => 'Ange kod';

  @override
  String get scanCode => 'Skanna kod';

  @override
  String get codeCopiedToClipboard => 'Koden har kopierats till urklipp';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      'Kopiera-klistra in den här koden\ntill din autentiseringsapp';

  @override
  String get tapToCopy => 'tryck för att kopiera';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      'Skanna denna streckkod med\ndin autentiseringsapp';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      'Ange den 6-siffriga koden från din autentiseringsapp';

  @override
  String get confirm => 'Bekräfta';

  @override
  String get setupComplete => 'Konfiguration slutförd';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready =>
      'Spara din återställningsnyckel om du inte redan har gjort det';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      'Detta kan användas för att återställa ditt konto om du förlorar din andra faktor';

  @override
  String get twofactorAuthenticationPageTitle => 'Tvåfaktorsautentisering';

  @override
  String get lostDevice => 'Förlorad enhet?';

  @override
  String get verifyingRecoveryKey => 'Verifierar återställningsnyckel...';

  @override
  String get recoveryKeyVerified => 'Återställningsnyckel verifierad';

  @override
  String get recoveryKeySuccessBody =>
      'Grymt! Din återställningsnyckel är giltig. Tack för att du verifierade.\n\nKom ihåg att hålla din återställningsnyckel säker med backups.';

  @override
  String get invalidRecoveryKey =>
      'Återställningsnyckeln du angav är inte giltig. Kontrollera att den innehåller 24 ord och kontrollera stavningen av varje ord.\n\nOm du har angett en äldre återställnings kod, se till att den är 64 tecken lång, och kontrollera var och en av bokstäverna.';

  @override
  String get invalidKey => 'Ogiltig nyckel';

  @override
  String get tryAgain => 'Försök igen';

  @override
  String get viewRecoveryKey => 'Visa återställningsnyckel';

  @override
  String get confirmRecoveryKey => 'Bekräfta återställningsnyckel';

  @override
  String get recoveryKeyVerifyReason =>
      'Din återställningsnyckel är det enda sättet att återställa dina foton om du glömmer ditt lösenord. Du hittar din återställningsnyckel i Inställningar > Säkerhet.\n\nAnge din återställningsnyckel här för att verifiera att du har sparat den ordentligt.';

  @override
  String get confirmYourRecoveryKey => 'Bekräfta din återställningsnyckel';

  @override
  String get addViewer => 'Lägg till bildvy';

  @override
  String get addCollaborator => 'Lägg till samarbetspartner';

  @override
  String get addANewEmail => 'Lägg till en ny e-postadress';

  @override
  String get orPickAnExistingOne => 'Eller välj en befintlig';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'Samarbetspartner kan lägga till foton och videor till det delade albumet.';

  @override
  String get enterEmail => 'Ange e-post';

  @override
  String get albumOwner => 'Ägare';

  @override
  String get you => 'Du';

  @override
  String get collaborator => 'Samarbetspartner';

  @override
  String get addMore => 'Lägg till fler';

  @override
  String get viewer => 'Bildvy';

  @override
  String get remove => 'Ta bort';

  @override
  String get removeParticipant => 'Ta bort användaren';

  @override
  String get manage => 'Hantera';

  @override
  String get addedAs => 'Lades till som';

  @override
  String get changePermissions => 'Ändra behörighet?';

  @override
  String get yesConvertToViewer => 'Ja, konvertera till bildvy';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return '$user kommer inte att kunna lägga till fler foton till detta album\n\nDe kommer fortfarande att kunna ta bort befintliga foton som lagts till av dem';
  }

  @override
  String get allowAddingPhotos => 'Tillåt lägga till foton';

  @override
  String get allowJoiningAlbum => 'Allow joining album';

  @override
  String get allowAddPhotosDescription =>
      'Tillåt personer med länken att även lägga till foton i det delade albumet.';

  @override
  String get passwordLock => 'Lösenordskydd';

  @override
  String get canNotOpenTitle => 'Kan inte öppna det här albumet';

  @override
  String get canNotOpenBody => 'Tyvärr kan detta album inte öppnas i appen.';

  @override
  String get disableDownloadWarningTitle => 'Vänligen notera:';

  @override
  String get disableDownloadWarningBody =>
      'Besökare kan fortfarande ta skärmdumpar eller spara en kopia av dina foton med hjälp av externa verktyg';

  @override
  String get allowDownloads => 'Tillåt nedladdningar';

  @override
  String get linkDeviceLimit => 'Enhetsgräns';

  @override
  String get noDeviceLimit => 'Ingen';

  @override
  String get albumLayout => 'Album layout';

  @override
  String get layoutGrouped => 'Grupperad';

  @override
  String get layoutContinuous => 'Kontinuerlig';

  @override
  String get layoutTrip => 'Trip';

  @override
  String get preview => 'Preview';

  @override
  String get linkExpiry => 'Länken upphör';

  @override
  String get linkExpired => 'Upphört';

  @override
  String get linkEnabled => 'Aktiverat';

  @override
  String get linkNeverExpires => 'Aldrig';

  @override
  String get expiredLinkInfo =>
      'Denna länk har upphört att gälla. Välj ett nytt datum eller inaktivera tidsbegränsningen.';

  @override
  String get setAPassword => 'Ange ett lösenord';

  @override
  String get lockButtonLabel => 'Lås';

  @override
  String get enterPassword => 'Ange lösenord';

  @override
  String get removeLink => 'Radera länk';

  @override
  String get manageLink => 'Hantera länk';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'Länken upphör att gälla $expiryTime';
  }

  @override
  String get albumUpdated => 'Album uppdaterat';

  @override
  String get never => 'Aldrig';

  @override
  String get custom => 'Anpassad';

  @override
  String get after1Hour => 'Om en timme';

  @override
  String get after1Day => 'Om en dag';

  @override
  String get after1Week => 'Om en vecka';

  @override
  String get after1Month => 'Om en månad';

  @override
  String get after1Year => 'Om ett år';

  @override
  String get manageParticipants => 'Hantera';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count deltagare',
      one: '1 deltagare',
      zero: 'Inga deltagare',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'Skapa en länk så att personer kan lägga till och visa foton i ditt delade album utan att behöva en Ente app eller konto. Perfekt för att samla in bilder från evenemang.';

  @override
  String get collectPhotos => 'Samla in foton';

  @override
  String get collaborativeLink => 'Samarbetslänk';

  @override
  String get shareWithNonenteUsers => 'Dela med icke-Ente användare';

  @override
  String get createPublicLink => 'Skapa offentlig länk';

  @override
  String get sendLink => 'Skicka länk';

  @override
  String get qrCode => 'QR Code';

  @override
  String get sendQrCode => 'Skicka QR-kod';

  @override
  String get copyLink => 'Kopiera länk';

  @override
  String get copyEmbedHtml => 'Copy embed HTML';

  @override
  String get linkHasExpired => 'Länk har upphört att gälla';

  @override
  String get publicLinkEnabled => 'Offentlig länk aktiverad';

  @override
  String get shareALink => 'Dela en länk';

  @override
  String get sharedAlbumSectionDescription =>
      'Skapa delade och samarbetande album med andra Ente användare, inklusive användare med gratisnivån.';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: 'Delad med $numberOfPeople personer',
      one: 'Delad med en person',
      zero: 'Dela med specifika personer',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId => 'Detta är ditt verifierings-ID';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'Någon som delar album med dig bör se samma ID på deras enhet.';

  @override
  String get howToViewShareeVerificationID =>
      'Be dem att långtrycka på sin e-postadress på inställningsskärmen och verifiera att ID:n på båda enheterna matchar.';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'Detta är ${email}s verifierings-ID';
  }

  @override
  String get verificationId => 'Verifierings-ID';

  @override
  String verifyEmailID({required Object email}) {
    return 'Bekräfta $email';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return '$email har inte ett Ente-konto.\n\nSkicka dem en inbjudan för att dela bilder.';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return 'Här är mitt verifierings-ID: $verificationID för ente.io.';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'Hallå, kan du bekräfta att detta är ditt ente.io verifierings-ID: $verificationID';
  }

  @override
  String get somethingWentWrong => 'Något gick fel';

  @override
  String get sendInvite => 'Skicka inbjudan';

  @override
  String get shareTextRecommendUsingEnte =>
      'Ladda ner Ente så att vi enkelt kan dela bilder och videor med originell kvalitet\n\nhttps://ente.io';

  @override
  String get done => 'Klar';

  @override
  String get applyCodeTitle => 'Använd kod';

  @override
  String get enterCodeDescription =>
      'Ange koden som din vän har angett för att få gratis lagring för er båda';

  @override
  String get apply => 'Verkställ';

  @override
  String get failedToApplyCode => 'Det gick inte att använda koden';

  @override
  String get enterReferralCode => 'Ange hänvisningskod';

  @override
  String get codeAppliedPageTitle => 'Kod tillämpad';

  @override
  String get changeYourReferralCode => 'Ändra din värvningskod';

  @override
  String get change => 'Ändra';

  @override
  String get unavailableReferralCode => 'Tyvärr är denna kod inte tillgänglig.';

  @override
  String get codeChangeLimitReached =>
      'Tyvärr, du har nått gränsen för kodändringar.';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'Kontakta $familyAdminEmail för att ändra din kod.';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB';
  }

  @override
  String get claimed => 'Nyttjad';

  @override
  String get details => 'Uppgifter';

  @override
  String get claimMore => 'Begär mer!';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return 'De får också $storageAmountInGB GB';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB varje gång någon registrerar sig för en betalplan och tillämpar din kod';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'Ente värvningskod: $referralCode \n\nTillämpa den i Inställningar → Allmänt → Hänvisningar för att få $referralStorageInGB GB gratis när du registrerar dig för en betalplan\n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => 'Hämta kostnadsfri lagring';

  @override
  String get inviteYourFriends => 'Bjud in dina vänner';

  @override
  String get failedToFetchReferralDetails =>
      'Det gick inte att hämta hänvisningsdetaljer. Försök igen senare.';

  @override
  String get referralStep1 => '1. Ge denna kod till dina vänner';

  @override
  String get referralStep2 => '2. De registrerar sig för en betalplan';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. Ni får båda $storageInGB GB* gratis';
  }

  @override
  String get referralsAreCurrentlyPaused =>
      'Hänvisningar är för närvarande pausade';

  @override
  String get youCanAtMaxDoubleYourStorage =>
      '* Du kan max fördubbla ditt lagringsutrymme';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true': 'Din familj har begärt $storageAmountInGb GB',
      'false': '$storageAmountInGb',
      'other': 'Du har begärt $storageAmountInGb GB!',
    });
    return '$_temp0';
  }

  @override
  String get faq => 'Vanliga frågor och svar';

  @override
  String get help => 'Hjälp';

  @override
  String get oopsSomethingWentWrong => 'Oj, något gick fel';

  @override
  String get peopleUsingYourCode => 'Personer som använder din kod';

  @override
  String get eligible => 'berättigad';

  @override
  String get total => 'totalt';

  @override
  String get codeUsedByYou => 'Kod som används av dig';

  @override
  String get freeStorageClaimed => 'Gratis lagring begärd';

  @override
  String get freeStorageUsable => 'Gratis lagringsutrymme som kan användas';

  @override
  String get usableReferralStorageInfo =>
      'Användbart lagringsutrymme begränsas av din nuvarande plan. Överskrider du lagringsutrymmet kommer automatiskt att kunna använda det när du uppgraderar din plan.';

  @override
  String get removeFromAlbumTitle => 'Ta bort från album?';

  @override
  String get removeFromAlbum => 'Ta bort från album';

  @override
  String get itemsWillBeRemovedFromAlbum =>
      'Valda objekt kommer att tas bort från detta album';

  @override
  String get removeShareItemsWarning =>
      'Några av de objekt som du tar bort lades av andra personer, och du kommer att förlora tillgång till dem';

  @override
  String get addingToFavorites => 'Lägger till bland favoriter...';

  @override
  String get removingFromFavorites => 'Tar bort från favoriter...';

  @override
  String get sorryCouldNotAddToFavorites =>
      'Tyvärr, kunde inte lägga till i favoriterna!';

  @override
  String get sorryCouldNotRemoveFromFavorites =>
      'Tyvärr kunde inte ta bort från favoriter!';

  @override
  String get subscribeToEnableSharing =>
      'Du behöver en aktiv betald prenumeration för att möjliggöra delning.';

  @override
  String get subscribe => 'Prenumerera';

  @override
  String get canOnlyRemoveFilesOwnedByYou =>
      'Kan endast ta bort filer som ägs av dig';

  @override
  String get deleteSharedAlbum => 'Radera delat album?';

  @override
  String get deleteAlbum => 'Radera album';

  @override
  String get deleteAlbumDialog =>
      'Ta också bort foton (och videor) som finns i detta album från <bold>alla</bold> andra album som de är en del av?';

  @override
  String get deleteSharedAlbumDialogBody =>
      'Albumet kommer att raderas för alla\n\nDu kommer att förlora åtkomst till delade foton i detta album som ägs av andra';

  @override
  String get yesRemove => 'Ja, ta bort';

  @override
  String get creatingLink => 'Skapar länk...';

  @override
  String get removeWithQuestionMark => 'Ta bort?';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return '$userEmail kommer att tas bort från detta delade album\n\nAlla bilder som lagts till av dem kommer också att tas bort från albumet';
  }

  @override
  String get keepPhotos => 'Behåll foton';

  @override
  String get deletePhotos => 'Radera foton';

  @override
  String get inviteToEnte => 'Bjud in till Ente';

  @override
  String get removePublicLink => 'Ta bort publik länk';

  @override
  String disableLinkMessage({required Object albumName}) {
    return 'Detta kommer att ta bort den publika länken för att komma åt \"$albumName\".';
  }

  @override
  String get sharing => 'Delar...';

  @override
  String get youCannotShareWithYourself => 'Du kan inte dela med dig själv';

  @override
  String get archive => 'Arkiv';

  @override
  String get createAlbumActionHint =>
      'Långtryck för att välja foton och klicka på + för att skapa ett album';

  @override
  String get importing => 'Importerar....';

  @override
  String get failedToLoadAlbums => 'Det gick inte att läsa in album';

  @override
  String get hidden => 'Dold';

  @override
  String get authToViewYourHiddenFiles =>
      'Vänligen autentisera för att visa dina dolda filer';

  @override
  String get authToViewTrashedFiles =>
      'Vänligen autentisera för att se dina kastade filer';

  @override
  String get trash => 'Papperskorg';

  @override
  String get uncategorized => 'Okategoriserade';

  @override
  String get videoSmallCase => 'video';

  @override
  String get photoSmallCase => 'foto';

  @override
  String get singleFileDeleteHighlight =>
      'Det kommer att tas bort från alla album.';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return 'Denna $fileType finns i både Ente och din enhet.';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return 'Denna $fileType kommer att raderas från Ente.';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return 'Denna $fileType kommer att raderas från din enhet.';
  }

  @override
  String get deleteFromEnte => 'Radera från ente';

  @override
  String get yesDelete => 'Ja, radera';

  @override
  String get movedToTrash => 'Flyttad till papperskorgen';

  @override
  String get deleteFromDevice => 'Radera från enhet';

  @override
  String get deleteFromBoth => '';

  @override
  String get newAlbum => 'Nytt album';

  @override
  String get albums => 'Album';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount minnen',
      one: '$formattedCount minne',
      zero: 'inga minnen',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return '$count markerade';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return '$count markerade ($yourCount din)';
  }

  @override
  String get advancedSettings => 'Avancerad';

  @override
  String get photoGridSize => 'Storlek på bildrutnät';

  @override
  String get manageDeviceStorage => 'Hantera enhetscache';

  @override
  String get manageDeviceStorageDesc => 'Granska och rensa lokal cachelagring.';

  @override
  String get machineLearning => 'Maskininlärning';

  @override
  String get mlConsent => 'Aktivera maskininlärning';

  @override
  String get mlConsentTitle => 'Aktivera maskininlärning?';

  @override
  String get mlConsentDescription =>
      'Om du aktiverar maskininlärning, kommer Ente extrahera information som ansiktsgeometri från filer, inklusive de som delas med dig.\n\nDetta kommer att hända på din enhet, och all genererad biometrisk information kommer att helsträckskrypteras.';

  @override
  String get mlConsentPrivacy =>
      'Klicka här för mer information om denna funktion i vår integritetspolicy';

  @override
  String get mlConsentConfirmation =>
      'Jag förstår och vill aktivera maskininlärning';

  @override
  String get magicSearch => 'Magisk sökning';

  @override
  String get discover => 'Upptäck';

  @override
  String get discover_identity => 'Identitet';

  @override
  String get discover_screenshots => 'Skärmdumpar';

  @override
  String get discover_receipts => 'Kvitton';

  @override
  String get discover_notes => 'Anteckningar';

  @override
  String get discover_memes => 'Memes';

  @override
  String get discover_visiting_cards => 'Besökskort';

  @override
  String get discover_babies => 'Barn';

  @override
  String get discover_pets => 'Husdjur';

  @override
  String get discover_selfies => 'Selfies';

  @override
  String get discover_wallpapers => 'Bakgrundsbilder';

  @override
  String get discover_food => 'Mat';

  @override
  String get discover_celebrations => 'Firanden';

  @override
  String get discover_sunset => 'Solnedgång';

  @override
  String get discover_hills => 'Berg';

  @override
  String get discover_greenery => 'Grönt landskap';

  @override
  String get mlIndexingDescription =>
      'Observera att maskininlärning kommer att resultera i en högre bandbredd och batterianvändning tills alla objekt är indexerade. Överväg att använda skrivbordsappen för snabbare indexering, alla resultat kommer att synkroniseras automatiskt.';

  @override
  String get loadingModel => 'Laddar ner modeller...';

  @override
  String get waitingForWifi => 'Väntar på WiFi...';

  @override
  String get status => 'Status';

  @override
  String get indexedItems => 'Indexerade objekt';

  @override
  String get pendingItems => 'Väntande objekt';

  @override
  String get clearIndexes => 'Rensa index';

  @override
  String get selectFoldersForBackup => 'Välj mappar för säkerhetskopiering';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      'Valda mappar kommer att krypteras och säkerhetskopieras';

  @override
  String get unselectAll => 'Avmarkera alla';

  @override
  String get selectAll => 'Markera allt';

  @override
  String get skip => 'Hoppa över';

  @override
  String get updatingFolderSelection => 'Uppdaterar mappval...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count objekt',
      one: '$count objekt',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Radera $count objekt',
      one: 'Radera $count objekt',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count filer, $formattedSize vardera';
  }

  @override
  String get showMemories => 'Visa minnen';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count år sedan',
      one: '$count år sedan',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'Säkerhetskopieringsinställningar';

  @override
  String get backupStatus => 'Säkerhetskopieringsstatus';

  @override
  String get backupStatusDescription =>
      'Objekt som har säkerhetskopierats kommer att visas här';

  @override
  String get backupOverMobileData => 'Säkerhetskopiera via mobildata';

  @override
  String get backupVideos => 'Säkerhetskopiera videor';

  @override
  String get disableAutoLock => 'Inaktivera automatisk låsning';

  @override
  String get deviceLockExplanation =>
      'Inaktivera enhetens skärmlås när Ente är i förgrunden och  säkerhetskopiering pågår. Detta är normalt inte nödvändigt, men kan hjälpa stora uppladdningar och initial import av stora bibliotek slutföra snabbare.';

  @override
  String get about => 'Om';

  @override
  String get weAreOpenSource => 'Vi har öppen källkod!';

  @override
  String get privacy => 'Sekretess';

  @override
  String get terms => 'Villkor';

  @override
  String get checkForUpdates => 'Sök efter uppdateringar';

  @override
  String get checkStatus => 'Kontrollera status';

  @override
  String get checking => 'Kontrollerar...';

  @override
  String get youAreOnTheLatestVersion => 'Du är på den senaste versionen';

  @override
  String get account => 'Konto';

  @override
  String get manageSubscription => 'Hantera prenumeration';

  @override
  String get authToChangeYourEmail =>
      'Autentisera för att ändra din e-postadress';

  @override
  String get changePassword => 'Ändra lösenord';

  @override
  String get authToChangeYourPassword =>
      'Autentisera för att ändra ditt lösenord';

  @override
  String get emailVerificationToggle => 'E-postverifiering';

  @override
  String get authToChangeEmailVerificationSetting =>
      'Please authenticate to change email verification';

  @override
  String get exportYourData => 'Exportera din data';

  @override
  String get logout => 'Logga ut';

  @override
  String get authToInitiateAccountDeletion =>
      'Vänligen autentisera för att initiera borttagning av konto';

  @override
  String get areYouSureYouWantToLogout =>
      'Är du säker på att du vill logga ut?';

  @override
  String get yesLogout => 'Ja, logga ut';

  @override
  String get aNewVersionOfEnteIsAvailable =>
      'En ny version av Ente är tillgänglig.';

  @override
  String get update => 'Uppdatera';

  @override
  String get installManually => 'Installera manuellt';

  @override
  String get criticalUpdateAvailable => 'Kritisk uppdatering tillgänglig';

  @override
  String get updateAvailable => 'Uppdatering tillgänglig';

  @override
  String get ignoreUpdate => 'Ignorera';

  @override
  String get downloading => 'Laddar ner...';

  @override
  String get cannotDeleteSharedFiles => 'Kan inte ta bort delade filer';

  @override
  String get theDownloadCouldNotBeCompleted =>
      'Nedladdningen kunde inte slutföras';

  @override
  String get retry => 'Försök igen';

  @override
  String get backedUpFolders => 'Säkerhetskopiera mappar';

  @override
  String get backup => 'Säkerhetskopiera';

  @override
  String get freeUpDeviceSpace => 'Frigör enhetens lagringsutrymme';

  @override
  String get freeUpDeviceSpaceDesc =>
      'Spara utrymme på din enhet genom att rensa filer som redan har säkerhetskopierats.';

  @override
  String get allClear => '✨ Allt klart';

  @override
  String get noDeviceThatCanBeDeleted =>
      'Du har inga filer på denna enhet som kan tas bort';

  @override
  String get removeDuplicates => 'Ta bort dubbletter';

  @override
  String get removeDuplicatesDesc =>
      'Review and remove files that are exact duplicates.';

  @override
  String get viewLargeFiles => 'Stora filer';

  @override
  String get viewLargeFilesDesc =>
      'View files that are consuming the most amount of storage.';

  @override
  String get noDuplicates => '✨ Inga dubbletter';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared =>
      'You don\'t have any duplicate files that can be cleared';

  @override
  String get success => 'Success';

  @override
  String get rateUs => 'Betygsätt oss';

  @override
  String get remindToEmptyDeviceTrash =>
      'Also empty \"Recently Deleted\" from \"Settings\" -> \"Storage\" to claim the freed space';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return 'You have successfully freed up $storageSaved!';
  }

  @override
  String get remindToEmptyEnteTrash =>
      'Also empty your \"Trash\" to claim the freed up space';

  @override
  String get sparkleSuccess => '✨ Success';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count duplicate files',
      one: '$count duplicate file',
    );
    return 'You have cleaned up $_temp0, saving ($storageSaved!)';
  }

  @override
  String get familyPlans => 'Family plans';

  @override
  String get referrals => 'Referrals';

  @override
  String get notifications => 'Notifications';

  @override
  String get sharedPhotoNotifications => 'Nya delade foton';

  @override
  String get sharedPhotoNotificationsExplanation =>
      'Receive notifications when someone adds a photo to a shared album that you\'re a part of';

  @override
  String get advanced => 'Avancerad';

  @override
  String get general => 'Allmänt';

  @override
  String get security => 'Säkerhet';

  @override
  String get authToViewYourRecoveryKey =>
      'Please authenticate to view your recovery key';

  @override
  String get twofactor => 'Two-factor';

  @override
  String get authToConfigureTwofactorAuthentication =>
      'Please authenticate to configure two-factor authentication';

  @override
  String get lockscreen => 'Låsskärm';

  @override
  String get authToChangeLockscreenSetting =>
      'Please authenticate to change lockscreen setting';

  @override
  String get viewActiveSessions => 'Visa aktiva sessioner';

  @override
  String get authToViewYourActiveSessions =>
      'Please authenticate to view your active sessions';

  @override
  String get disableTwofactor => 'Disable two-factor';

  @override
  String get confirm2FADisable =>
      'Are you sure you want to disable two-factor authentication?';

  @override
  String get no => 'Nej';

  @override
  String get yes => 'Ja';

  @override
  String get social => 'Social';

  @override
  String rateUsOnStore({required Object storeName}) {
    return 'Betygsätt oss på $storeName';
  }

  @override
  String get blog => 'Blogg';

  @override
  String get merchandise => 'Merchandise';

  @override
  String get twitter => 'Twitter';

  @override
  String get mastodon => 'Mastodon';

  @override
  String get matrix => 'Matrix';

  @override
  String get discord => 'Discord';

  @override
  String get reddit => 'Reddit';

  @override
  String get yourStorageDetailsCouldNotBeFetched =>
      'Your storage details could not be fetched';

  @override
  String get reportABug => 'Rapportera en bugg';

  @override
  String get reportBug => 'Rapportera bugg';

  @override
  String get suggestFeatures => 'Föreslå funktioner';

  @override
  String get support => 'Support';

  @override
  String get theme => 'Tema';

  @override
  String get lightTheme => 'Ljust';

  @override
  String get darkTheme => 'Mörkt';

  @override
  String get systemTheme => 'System';

  @override
  String get freeTrial => 'Gratis provperiod';

  @override
  String get selectYourPlan => 'Välj din plan';

  @override
  String get enteSubscriptionPitch =>
      'Ente preserves your memories, so they\'re always available to you, even if you lose your device.';

  @override
  String get enteSubscriptionShareWithFamily =>
      'Your family can be added to your plan as well.';

  @override
  String get currentUsageIs => 'Current usage is ';

  @override
  String get faqs => 'FAQs';

  @override
  String renewsOn({required Object endDate}) {
    return 'Subscription renews on $endDate';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return 'Free trial valid till $endDate';
  }

  @override
  String validTill({required Object endDate}) {
    return 'Giltig till $endDate';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return 'Your $storageAmount add-on is valid till $endDate';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return 'Free trial valid till $endDate.\nYou can choose a paid plan afterwards.';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'Your subscription will be cancelled on $endDate';
  }

  @override
  String get subscription => 'Prenumeration';

  @override
  String get paymentDetails => 'Betalningsdetaljer';

  @override
  String get manageFamily => 'Hantera familj';

  @override
  String contactToManageSubscription({required Object provider}) {
    return 'Please contact us at support@ente.io to manage your $provider subscription.';
  }

  @override
  String get renewSubscription => 'Förnya prenumeration';

  @override
  String get cancelSubscription => 'Avbryt prenumeration';

  @override
  String get areYouSureYouWantToRenew => 'Are you sure you want to renew?';

  @override
  String get yesRenew => 'Ja, förnya';

  @override
  String get areYouSureYouWantToCancel => 'Är du säker på att du vill avbryta?';

  @override
  String get yesCancel => 'Ja, avbryt';

  @override
  String get failedToRenew => 'Kunde inte förnya';

  @override
  String get failedToCancel => 'Misslyckades att avbryta';

  @override
  String get twoMonthsFreeOnYearlyPlans => '2 months free on yearly plans';

  @override
  String get monthly => 'Monthly';

  @override
  String get yearly => 'Yearly';

  @override
  String get confirmPlanChange => 'Bekräfta ändring av plan';

  @override
  String get areYouSureYouWantToChangeYourPlan =>
      'Are you sure you want to change your plan?';

  @override
  String get youCannotDowngradeToThisPlan =>
      'You cannot downgrade to this plan';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'Please cancel your existing subscription from $paymentProvider first';
  }

  @override
  String get optionalAsShortAsYouLike => 'Optional, as short as you like...';

  @override
  String get send => 'Skicka';

  @override
  String get askCancelReason =>
      'Your subscription was cancelled. Would you like to share the reason?';

  @override
  String get thankYouForSubscribing => 'Thank you for subscribing!';

  @override
  String get yourPurchaseWasSuccessful => 'Your purchase was successful';

  @override
  String get yourPlanWasSuccessfullyUpgraded =>
      'Your plan was successfully upgraded';

  @override
  String get yourPlanWasSuccessfullyDowngraded =>
      'Your plan was successfully downgraded';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully =>
      'Your subscription was updated successfully';

  @override
  String get googlePlayId => 'Google Play ID';

  @override
  String get appleId => 'Apple ID';

  @override
  String get playstoreSubscription => 'PlayStore-prenumeration';

  @override
  String get appstoreSubscription => 'AppStore-prenumeration';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return 'Your $id is already linked to another Ente account.\nIf you would like to use your $id with this account, please contact our support\'\'';
  }

  @override
  String get visitWebToManage =>
      'Please visit web.ente.io to manage your subscription';

  @override
  String get couldNotUpdateSubscription => 'Kunde inte uppdatera prenumeration';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      'Please contact support@ente.io and we will be happy to help!';

  @override
  String get paymentFailed => 'Betalning misslyckades';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return 'Please talk to $providerName support if you were charged';
  }

  @override
  String get continueOnFreeTrial => 'Continue on free trial';

  @override
  String get areYouSureYouWantToExit => 'Är du säker på att du vill avsluta?';

  @override
  String get thankYou => 'Tack';

  @override
  String get failedToVerifyPaymentStatus => 'Failed to verify payment status';

  @override
  String get pleaseWaitForSometimeBeforeRetrying =>
      'Please wait for sometime before retrying';

  @override
  String get paymentFailedMessage =>
      'Unfortunately your payment failed. Please contact support and we\'ll help you out!';

  @override
  String get youAreOnAFamilyPlan => 'You are on a family plan!';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'Please contact <green>$familyAdminEmail</green> to manage your subscription';
  }

  @override
  String get leaveFamily => 'Leave family';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily =>
      'Are you sure that you want to leave the family plan?';

  @override
  String get leave => 'Lämna';

  @override
  String get rateTheApp => 'Rate the app';

  @override
  String get startBackup => 'Starta säkerhetskopiering';

  @override
  String get noPhotosAreBeingBackedUpRightNow =>
      'No photos are being backed up right now';

  @override
  String get preserveMore => 'Bevara mer';

  @override
  String get grantFullAccessPrompt =>
      'Please allow access to all photos in the Settings app';

  @override
  String get allowPermTitle => 'Tillåt åtkomst till foton';

  @override
  String get allowPermBody =>
      'Please allow access to your photos from Settings so Ente can display and backup your library.';

  @override
  String get openSettings => 'Öppna inställningar';

  @override
  String get selectMorePhotos => 'Välj fler foton';

  @override
  String get existingUser => 'Befintlig användare';

  @override
  String get privateBackups => 'Privata säkerhetskopior';

  @override
  String get forYourMemories => 'för dina minnen';

  @override
  String get endtoendEncryptedByDefault => 'End-to-end encrypted by default';

  @override
  String get safelyStored => 'Safely stored';

  @override
  String get atAFalloutShelter => 'at a fallout shelter';

  @override
  String get designedToOutlive => 'Designed to outlive';

  @override
  String get available => 'Tillgänglig';

  @override
  String get everywhere => 'överallt';

  @override
  String get androidIosWebDesktop => 'Android, iOS, Web, Desktop';

  @override
  String get mobileWebDesktop => 'Mobile, Web, Desktop';

  @override
  String get newToEnte => 'New to Ente';

  @override
  String get pleaseLoginAgain => 'Logga in igen';

  @override
  String get autoLogoutMessage =>
      'Due to technical glitch, you have been logged out. Our apologies for the inconvenience.';

  @override
  String get yourSubscriptionHasExpired => 'Your subscription has expired';

  @override
  String get storageLimitExceeded => 'Lagringsgräns överskriden';

  @override
  String get upgrade => 'Uppgradera';

  @override
  String get raiseTicket => 'Raise ticket';

  @override
  String get backupFailed => 'Säkerhetskopiering misslyckades';

  @override
  String get sorryBackupFailedDesc =>
      'Sorry, we could not backup this file right now, we will retry later.';

  @override
  String get couldNotBackUpTryLater =>
      'We could not backup your data.\nWe will retry later.';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      'Ente can encrypt and preserve files only if you grant access to them';

  @override
  String get pleaseGrantPermissions => 'Please grant permissions';

  @override
  String get grantPermission => 'Grant permission';

  @override
  String get privateSharing => 'Privat delning';

  @override
  String get shareOnlyWithThePeopleYouWant =>
      'Share only with the people you want';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      'Use public links for people not on Ente';

  @override
  String get allowPeopleToAddPhotos => 'Tillåt personer att lägga till foton';

  @override
  String get shareAnAlbumNow => 'Dela ett album nu';

  @override
  String get collectEventPhotos => 'Samla händelsefoton';

  @override
  String get sessionExpired => 'Session expired';

  @override
  String get loggingOut => 'Loggar ut...';

  @override
  String get onDevice => 'På enhet';

  @override
  String get onEnte => 'On <branding>ente</branding>';

  @override
  String get name => 'Namn';

  @override
  String get newest => 'Nyaste';

  @override
  String get lastUpdated => 'Senast uppdaterad';

  @override
  String get deleteEmptyAlbums => 'Ta bort tomma album';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => 'Ta bort tomma album?';

  @override
  String get deleteAlbumsDialogBody =>
      'This will delete all empty albums. This is useful when you want to reduce the clutter in your album list.';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return 'Deleting $currentlyDeleting / $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return 'Processing $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => 'Radera permanent';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou =>
      'Can only create link for files owned by you';

  @override
  String get publicLinkCreated => 'Offentlig länk skapad';

  @override
  String get youCanManageYourLinksInTheShareTab =>
      'You can manage your links in the share tab.';

  @override
  String get linkCopiedToClipboard => 'Länk kopierad till urklipp';

  @override
  String get restore => 'Återställ';

  @override
  String get moveToAlbum => 'Flytta till album';

  @override
  String get unhide => 'Unhide';

  @override
  String get unarchive => 'Unarchive';

  @override
  String get favorite => 'Favorit';

  @override
  String get removeFromFavorite => 'Ta bort från favoriter';

  @override
  String get shareLink => 'Dela länk';

  @override
  String get createCollage => 'Skapa collage';

  @override
  String get saveCollage => 'Spara collage';

  @override
  String get collageSaved => 'Kollage sparat i galleriet';

  @override
  String get collageLayout => 'Layout';

  @override
  String get addToEnte => 'Add to Ente';

  @override
  String get addToAlbum => 'Lägg till i album';

  @override
  String get delete => 'Radera';

  @override
  String get hide => 'Dölj';

  @override
  String get share => 'Dela';

  @override
  String get unhideToAlbum => 'Unhide to album';

  @override
  String get restoreToAlbum => 'Återställ till album';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Move items',
      one: 'Move item',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add items',
      one: 'Add item',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'Skapa eller välj album';

  @override
  String get selectAlbum => 'Välj album';

  @override
  String get searchByAlbumNameHint => 'Albumnamn';

  @override
  String get albumTitle => 'Albumtitel';

  @override
  String get enterAlbumName => 'Ange albumnamn';

  @override
  String get restoringFiles => 'Återställer filer...';

  @override
  String get movingFilesToAlbum => 'Flyttar filer till album...';

  @override
  String get unhidingFilesToAlbum => 'Unhiding files to album';

  @override
  String get canNotUploadToAlbumsOwnedByOthers =>
      'Can not upload to albums owned by others';

  @override
  String get uploadingFilesToAlbum => 'Laddar upp filer till album...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return 'Added successfully to  $albumName';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return 'Moved successfully to $albumName';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'This album already has a collaborative link';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return 'Collaborative link created for $albumName';
  }

  @override
  String get askYourLovedOnesToShare => 'Ask your loved ones to share';

  @override
  String get invite => 'Bjud in';

  @override
  String get shareYourFirstAlbum => 'Dela ditt första album';

  @override
  String sharedWith({required Object emailIDs}) {
    return 'Delad med $emailIDs';
  }

  @override
  String get sharedWithMe => 'Delade med mig';

  @override
  String get sharedByMe => 'Delat av mig';

  @override
  String get doubleYourStorage => 'Dubbla ditt lagringsutrymme';

  @override
  String get referFriendsAnd2xYourPlan => 'Refer friends and 2x your plan';

  @override
  String get shareAlbumHint =>
      'Open an album and tap the share button on the top right to share.';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      'Items show the number of days remaining before permanent deletion';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count days',
      one: '1 day',
      zero: 'Soon',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => 'Radera alla';

  @override
  String get renameAlbum => 'Döp om album';

  @override
  String get convertToAlbum => 'Konvertera till album';

  @override
  String get setCover => 'Set cover';

  @override
  String get sortAlbumsBy => 'Sortera efter';

  @override
  String get sortNewestFirst => 'Nyast först';

  @override
  String get sortOldestFirst => 'Äldst först';

  @override
  String get rename => 'Döp om';

  @override
  String get leaveSharedAlbum => 'Lämna delat album?';

  @override
  String get leaveAlbum => 'Lämna album';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'Photos added by you will be removed from the album';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted =>
      'You\'ve no files in this album that can be deleted';

  @override
  String get youDontHaveAnyArchivedItems =>
      'You don\'t have any archived items.';

  @override
  String get ignoredFolderUploadReason =>
      'Some files in this album are ignored from upload because they had previously been deleted from Ente.';

  @override
  String get resetIgnoredFiles => 'Återställ ignorerade filer';

  @override
  String get deviceFilesAutoUploading =>
      'Files added to this device album will automatically get uploaded to Ente.';

  @override
  String get turnOnBackupForAutoUpload =>
      'Turn on backup to automatically upload files added to this device folder to Ente.';

  @override
  String get noHiddenPhotosOrVideos => 'Inga dolda foton eller videor';

  @override
  String get toHideAPhotoOrVideo => 'To hide a photo or video';

  @override
  String get openTheItem => '• Open the item';

  @override
  String get clickOnTheOverflowMenu => '• Click on the overflow menu';

  @override
  String get click => '• Click';

  @override
  String get nothingToSeeHere => 'Inget att se här! 👀';

  @override
  String get unarchiveAlbum => 'Unarchive album';

  @override
  String get archiveAlbum => 'Arkivera album';

  @override
  String get calculating => 'Beräknar...';

  @override
  String get pleaseWaitDeletingAlbum => 'Vänta, tar bort album';

  @override
  String get searchByExamples =>
      '• Album names (e.g. \"Camera\")\n• Types of files (e.g. \"Videos\", \".gif\")\n• Years and months (e.g. \"2022\", \"January\")\n• Holidays (e.g. \"Christmas\")\n• Photo descriptions (e.g. “#fun”)';

  @override
  String get youCanTrySearchingForADifferentQuery =>
      'You can try searching for a different query.';

  @override
  String get noResultsFound => 'Inga resultat hittades';

  @override
  String addedBy({required Object emailOrName}) {
    return 'Tillagd av $emailOrName';
  }

  @override
  String get loadingExifData => 'Laddar EXIF-data...';

  @override
  String get viewAllExifData => 'Visa all EXIF-data';

  @override
  String get noExifData => 'Ingen EXIF-data';

  @override
  String get thisImageHasNoExifData => 'This image has no exif data';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => 'Inga resultat';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'We don\'t support editing photos and albums that you don\'t own yet';

  @override
  String get failedToFetchOriginalForEdit =>
      'Failed to fetch original for edit';

  @override
  String get close => 'Stäng';

  @override
  String get setAs => 'Set as';

  @override
  String get fileSavedToGallery => 'Fil sparad i galleri';

  @override
  String get filesSavedToGallery => 'Filer sparade i galleri';

  @override
  String get fileFailedToSaveToGallery => 'Kunde inte spara fil till galleri';

  @override
  String get download => 'Ladda ner';

  @override
  String get pressAndHoldToPlayVideo => 'Press and hold to play video';

  @override
  String get pressAndHoldToPlayVideoDetailed =>
      'Press and hold on the image to  play video';

  @override
  String get downloadFailed => 'Nedladdning misslyckades';

  @override
  String get deduplicateFiles => 'Deduplicera filer';

  @override
  String get deselectAll => 'Deselect all';

  @override
  String get reviewDeduplicateItems =>
      'Please review and delete the items you believe are duplicates.';

  @override
  String get clubByCaptureTime => 'Club by capture time';

  @override
  String get clubByFileName => 'Club by file name';

  @override
  String get count => 'Count';

  @override
  String get totalSize => 'Total size';

  @override
  String get longpressOnAnItemToViewInFullscreen =>
      'Long-press on an item to view in full-screen';

  @override
  String get decryptingVideo => 'Decrypting video...';

  @override
  String get authToViewYourMemories =>
      'Please authenticate to view your memories';

  @override
  String get unlock => 'Lås upp';

  @override
  String get freeUpSpace => 'Frigör utrymme';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'They can be deleted from the device to free up $formattedSize',
      one: 'It can be deleted from the device to free up $formattedSize',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber files',
      one: '1 file',
    );
    return '$_temp0 in this album has been backed up safely';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber files',
      one: '1 file',
    );
    return '$_temp0 on this device have been backed up safely';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'them',
      one: 'it',
    );
    return 'You can still access $_temp0 on Ente as long as you have an active subscription';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return 'Free up $sizeInMBorGB';
  }

  @override
  String get thisEmailIsAlreadyInUse => 'Denna e-post används redan';

  @override
  String get incorrectCode => 'Felaktig kod';

  @override
  String get authenticationFailedPleaseTryAgain =>
      'Autentisering misslyckades, försök igen';

  @override
  String get verificationFailedPleaseTryAgain =>
      'Verification failed, please try again';

  @override
  String get authenticating => 'Autentiserar...';

  @override
  String get authenticationSuccessful => 'Authentication successful!';

  @override
  String get incorrectRecoveryKey => 'Felaktig återställningsnyckel';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect =>
      'Återställningsnyckeln du angav är felaktig';

  @override
  String get twofactorAuthenticationSuccessfullyReset =>
      'Two-factor authentication successfully reset';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered =>
      'Please verify the code you have entered';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      'Please contact support if the problem persists';

  @override
  String get twofactorAuthenticationHasBeenDisabled =>
      'Tvåfaktorsautentisering har inaktiverats';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect =>
      'Sorry, the code you\'ve entered is incorrect';

  @override
  String get yourVerificationCodeHasExpired =>
      'Your verification code has expired';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'Email changed to $newEmail';
  }

  @override
  String get verifying => 'Verifierar...';

  @override
  String get disablingTwofactorAuthentication =>
      'Disabling two-factor authentication...';

  @override
  String get allMemoriesPreserved => 'All memories preserved';

  @override
  String get loadingGallery => 'Laddar galleri...';

  @override
  String get syncing => 'Syncing...';

  @override
  String get encryptingBackup => 'Krypterar säkerhetskopia...';

  @override
  String get syncStopped => 'Sync stopped';

  @override
  String syncProgress({required String completed, required String total}) {
    return '$completed/$total memories preserved';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return 'Bevarar $count minnen...';
  }

  @override
  String get uploadingSingleMemory => 'Bevarar 1 minne...';

  @override
  String get archiving => 'Arkiverar...';

  @override
  String get unarchiving => 'Unarchiving...';

  @override
  String get successfullyArchived => 'Successfully archived';

  @override
  String get successfullyUnarchived => 'Successfully unarchived';

  @override
  String get renameFile => 'Döp om fil';

  @override
  String get enterFileName => 'Ange filnamn';

  @override
  String get filesDeleted => 'Filer borttagna';

  @override
  String get selectedFilesAreNotOnEnte => 'Selected files are not on Ente';

  @override
  String get thisActionCannotBeUndone => 'Denna åtgärd kan inte ångras';

  @override
  String get emptyTrash => 'Töm papperskorgen?';

  @override
  String get permDeleteWarning =>
      'All items in trash will be permanently deleted\n\nThis action cannot be undone';

  @override
  String get empty => 'Tom';

  @override
  String get couldNotFreeUpSpace => 'Kunde inte frigöra utrymme';

  @override
  String get permanentlyDeleteFromDevice => 'Permanently delete from device?';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      'Some of the files you are trying to delete are only available on your device and cannot be recovered if deleted';

  @override
  String get theyWillBeDeletedFromAllAlbums =>
      'They will be deleted from all albums.';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'Some items are in both Ente and your device.';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      'Selected items will be deleted from all albums and moved to trash.';

  @override
  String get theseItemsWillBeDeletedFromYourDevice =>
      'These items will be deleted from your device.';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      'It looks like something went wrong. Please retry after some time. If the error persists, please contact our support team.';

  @override
  String get error => 'Fel';

  @override
  String get tempErrorContactSupportIfPersists =>
      'It looks like something went wrong. Please retry after some time. If the error persists, please contact our support team.';

  @override
  String get networkHostLookUpErr =>
      'Unable to connect to Ente, please check your network settings and contact support if the error persists.';

  @override
  String get networkConnectionRefusedErr =>
      'Unable to connect to Ente, please retry after sometime. If the error persists, please contact support.';

  @override
  String get cachedData => 'Cachelagrad data';

  @override
  String get clearCaches => 'Clear caches';

  @override
  String get remoteImages => 'Remote images';

  @override
  String get remoteVideos => 'Remote videos';

  @override
  String get remoteThumbnails => 'Remote thumbnails';

  @override
  String get pendingSync => 'Väntande synkronisering';

  @override
  String get localGallery => 'Lokalt galleri';

  @override
  String get todaysLogs => 'Dagens loggar';

  @override
  String get viewLogs => 'Visa loggar';

  @override
  String get logsDialogBody =>
      'This will send across logs to help us debug your issue. Please note that file names will be included to help track issues with specific files.';

  @override
  String get preparingLogs => 'Förbereder loggar...';

  @override
  String get emailYourLogs => 'E-posta dina loggar';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'Skicka loggarna till \n$toEmail';
  }

  @override
  String get copyEmailAddress => 'Kopiera e-postadress';

  @override
  String get exportLogs => 'Exportera loggar';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return 'Skicka e-post till oss på $toEmail';
  }

  @override
  String get dismiss => 'Dismiss';

  @override
  String get didYouKnow => 'Visste du?';

  @override
  String get loadingMessage => 'Laddar dina foton...';

  @override
  String get loadMessage1 => 'You can share your subscription with your family';

  @override
  String get loadMessage2 =>
      'We have preserved over 200 million memories so far';

  @override
  String get loadMessage3 =>
      'We keep 3 copies of your data, one in an underground fallout shelter';

  @override
  String get loadMessage4 => 'All our apps are open source';

  @override
  String get loadMessage5 =>
      'Our source code and cryptography have been externally audited';

  @override
  String get loadMessage6 =>
      'You can share links to your albums with your loved ones';

  @override
  String get loadMessage7 =>
      'Our mobile apps run in the background to encrypt and backup any new photos you click';

  @override
  String get loadMessage8 => 'web.ente.io has a slick uploader';

  @override
  String get loadMessage9 =>
      'We use Xchacha20Poly1305 to safely encrypt your data';

  @override
  String get photoDescriptions => 'Fotobeskrivningar';

  @override
  String get fileTypesAndNames => 'Filtyper och namn';

  @override
  String get location => 'Plats';

  @override
  String get moments => 'Moments';

  @override
  String get searchFaceEmptySection =>
      'People will be shown here once indexing is done';

  @override
  String get searchDatesEmptySection => 'Search by a date, month or year';

  @override
  String get searchLocationEmptySection =>
      'Group photos that are taken within some radius of a photo';

  @override
  String get searchPeopleEmptySection =>
      'Invite people, and you\'ll see all photos shared by them here';

  @override
  String get searchAlbumsEmptySection => 'Album';

  @override
  String get searchFileTypesAndNamesEmptySection => 'Filtyper och namn';

  @override
  String get searchCaptionEmptySection =>
      'Add descriptions like \"#trip\" in photo info to quickly find them here';

  @override
  String get language => 'Språk';

  @override
  String get selectLanguage => 'Välj språk';

  @override
  String get locationName => 'Platsnamn';

  @override
  String get addLocation => 'Lägg till plats';

  @override
  String get groupNearbyPhotos => 'Group nearby photos';

  @override
  String get kiloMeterUnit => 'km';

  @override
  String get addLocationButton => 'Lägg till';

  @override
  String get radius => 'Radie';

  @override
  String get locationTagFeatureDescription =>
      'A location tag groups all photos that were taken within some radius of a photo';

  @override
  String get galleryMemoryLimitInfo => 'Up to 1000 memories shown in gallery';

  @override
  String get save => 'Spara';

  @override
  String get centerPoint => 'Center point';

  @override
  String get pickCenterPoint => 'Pick center point';

  @override
  String get useSelectedPhoto => 'Använd valt foto';

  @override
  String get resetToDefault => 'Återställ till standard';

  @override
  String get edit => 'Redigera';

  @override
  String get deleteLocation => 'Ta bort plats';

  @override
  String get rotateLeft => 'Rotera vänster';

  @override
  String get flip => 'Flip';

  @override
  String get rotateRight => 'Rotera höger';

  @override
  String get saveCopy => 'Spara kopia';

  @override
  String get light => 'Ljust';

  @override
  String get color => 'Färg';

  @override
  String get yesDiscardChanges => 'Ja, avfärda ändringarna';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade =>
      'Do you want to discard the edits you have made?';

  @override
  String get saving => 'Sparar...';

  @override
  String get editsSaved => 'Edits saved';

  @override
  String get oopsCouldNotSaveEdits => 'Oops, could not save edits';

  @override
  String get distanceInKMUnit => 'km';

  @override
  String get dayToday => 'Idag';

  @override
  String get dayYesterday => 'Igår';

  @override
  String get storage => 'Lagring';

  @override
  String get usedSpace => 'Använt utrymme';

  @override
  String get storageBreakupFamily => 'Familj';

  @override
  String get storageBreakupYou => 'Du';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return '$usedAmount $usedStorageUnit of $totalAmount $totalStorageUnit used';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return '$freeAmount $storageUnit gratis';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'Version: $versionValue';
  }

  @override
  String get verifyIDLabel => 'Verifiera';

  @override
  String get fileInfoAddDescHint => 'Lägg till en beskrivning...';

  @override
  String get editLocationTagTitle => 'Redigera plats';

  @override
  String get setLabel => 'Set';

  @override
  String get setRadius => 'Set radius';

  @override
  String get familyPlanPortalTitle => 'Familj';

  @override
  String get familyPlanOverview =>
      'Add 5 family members to your existing plan without paying extra.\n\nEach member gets their own private space, and cannot see each other\'s files unless they\'re shared.\n\nFamily plans are available to customers who have a paid Ente subscription.\n\nSubscribe now to get started!';

  @override
  String get androidBiometricHint => 'Verifiera identitet';

  @override
  String get androidBiometricNotRecognized => 'Inte igenkänd. Försök igen.';

  @override
  String get androidBiometricSuccess => 'Success';

  @override
  String get androidCancelButton => 'Avbryt';

  @override
  String get androidSignInTitle => 'Authentication required';

  @override
  String get androidBiometricRequiredTitle => 'Biometric required';

  @override
  String get androidDeviceCredentialsRequiredTitle =>
      'Device credentials required';

  @override
  String get androidDeviceCredentialsSetupDescription =>
      'Device credentials required';

  @override
  String get goToSettings => 'Gå till inställningar';

  @override
  String get androidGoToSettingsDescription =>
      'Biometric authentication is not set up on your device. Go to \'Settings > Security\' to add biometric authentication.';

  @override
  String get iOSLockOut =>
      'Biometric authentication is disabled. Please lock and unlock your screen to enable it.';

  @override
  String get iOSGoToSettingsDescription =>
      'Biometric authentication is not set up on your device. Please either enable Touch ID or Face ID on your phone.';

  @override
  String get iOSOkButton => 'OK';

  @override
  String get openstreetmapContributors => 'OpenStreetMap contributors';

  @override
  String get hostedAtOsmFrance => 'Hosted at OSM France';

  @override
  String get map => 'Karta';

  @override
  String get maps => 'Kartor';

  @override
  String get mapsPrivacyNotice =>
      'Approximate coordinates will be sent to privacy conscious third parties like OpenStreetMap to show the map and location.';

  @override
  String get enableMaps => 'Aktivera kartor';

  @override
  String get quickLinks => 'Snabblänkar';

  @override
  String get selectItemsToAdd => 'Select items to add';

  @override
  String get addSelected => 'Add selected';

  @override
  String get addFromDevice => 'Lägg till från enhet';

  @override
  String get addPhotos => 'Lägg till foton';

  @override
  String get noPhotosFoundHere => 'Inga foton hittades här';

  @override
  String get zoomOutToSeePhotos => 'Zooma ut för att se foton';

  @override
  String get noImagesWithLocation => 'Inga bilder med plats';

  @override
  String get unpinAlbum => 'Unpin album';

  @override
  String get pinAlbum => 'Pin album';

  @override
  String get pin => 'Pin';

  @override
  String get pinPerson => 'Pin person';

  @override
  String get pinToTop => 'Pin to top';

  @override
  String get unpin => 'Unpin';

  @override
  String get unpinPerson => 'Unpin person';

  @override
  String get visibility => 'Visibility';

  @override
  String get hideFromMemories => 'Hide from memories';

  @override
  String get showInMemories => 'Show in memories';

  @override
  String get create => 'Skapa';

  @override
  String get viewAll => 'Visa alla';

  @override
  String get nothingSharedWithYouYet => 'Inget delat med dig ännu';

  @override
  String get noAlbumsSharedByYouYet => 'No albums shared by you yet';

  @override
  String get sharedWithYou => 'Delat med dig';

  @override
  String get sharedByYou => 'Delat av dig';

  @override
  String get inviteYourFriendsToEnte => 'Bjud in dina vänner till Ente';

  @override
  String get failedToDownloadVideo => 'Kunde inte ladda ner video';

  @override
  String get hiding => 'Döljer...';

  @override
  String get unhiding => 'Unhiding...';

  @override
  String get successfullyHid => 'Successfully hid';

  @override
  String get successfullyUnhid => 'Successfully unhid';

  @override
  String get crashReporting => 'Kraschrapportering';

  @override
  String get resumableUploads => 'Resumable uploads';

  @override
  String get addToHiddenAlbum => 'Lägg till i dolt album';

  @override
  String get moveToHiddenAlbum => 'Flytta till dolt album';

  @override
  String get fileTypes => 'Filtyper';

  @override
  String get deleteConfirmDialogBody =>
      'This account is linked to other Ente apps, if you use any. Your uploaded data, across all Ente apps, will be scheduled for deletion, and your account will be permanently deleted.';

  @override
  String get hearUsWhereTitle => 'How did you hear about Ente? (optional)';

  @override
  String get hearUsExplanation =>
      'We don\'t track app installs. It\'d help if you told us where you found us!';

  @override
  String get viewAddOnButton => 'View add-ons';

  @override
  String get addOns => 'Add-ons';

  @override
  String get addOnPageSubtitle => 'Details of add-ons';

  @override
  String get yourMap => 'Din karta';

  @override
  String get modifyYourQueryOrTrySearchingFor =>
      'Modify your query, or try searching for';

  @override
  String get blackFridaySale => 'Black Friday Sale';

  @override
  String get upto50OffUntil4thDec => 'Upto 50% off, until 4th Dec.';

  @override
  String get photos => 'Foton';

  @override
  String get videos => 'Videor';

  @override
  String get livePhotos => 'Livefoton';

  @override
  String get searchHint1 => 'Fast, on-device search';

  @override
  String get searchHint2 => 'Photo dates, descriptions';

  @override
  String get searchHint3 => 'Album, filnamn och typer';

  @override
  String get searchHint4 => 'Plats';

  @override
  String get searchHint5 => 'Coming soon: Faces & magic search ✨';

  @override
  String get addYourPhotosNow => 'Lägg till dina foton nu';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count resultat hittades',
      one: '$count resultat hittades',
    );
    return '$_temp0';
  }

  @override
  String get faces => 'Ansikten';

  @override
  String get people => 'Människor';

  @override
  String get contents => 'Innehåll';

  @override
  String get addNew => 'Lägg till ny';

  @override
  String get contacts => 'Kontakter';

  @override
  String get noInternetConnection => 'Ingen internetanslutning';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'Kontrollera din internetanslutning och försök igen.';

  @override
  String get signOutFromOtherDevices => 'Logga ut från andra enheter';

  @override
  String get signOutOtherBody =>
      'If you think someone might know your password, you can force all other devices using your account to sign out.';

  @override
  String get signOutOtherDevices => 'Logga ut andra enheter';

  @override
  String get doNotSignOut => 'Logga inte ut';

  @override
  String get editLocation => 'Redigera plats';

  @override
  String get selectALocation => 'Välj en plats';

  @override
  String get selectALocationFirst => 'Välj en plats först';

  @override
  String get changeLocationOfSelectedItems =>
      'Change location of selected items?';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte =>
      'Edits to location will only be seen within Ente';

  @override
  String get cleanUncategorized => 'Rensa okategoriserade';

  @override
  String get cleanUncategorizedDescription =>
      'Remove all files from Uncategorized that are present in other albums';

  @override
  String get waitingForVerification => 'Väntar på verifiering...';

  @override
  String get passkey => 'Nyckel';

  @override
  String get passkeyAuthTitle => 'Passkey verification';

  @override
  String get loginWithTOTP => 'Logga in med TOTP';

  @override
  String get passKeyPendingVerification => 'Verification is still pending';

  @override
  String get loginSessionExpired => 'Session expired';

  @override
  String get loginSessionExpiredDetails =>
      'Din session har upphört. Logga in igen.';

  @override
  String get verifyPasskey => 'Verifiera nyckel';

  @override
  String get playOnTv => 'Spela album på TV';

  @override
  String get pair => 'Pair';

  @override
  String get deviceNotFound => 'Enhet hittades inte';

  @override
  String get castInstruction =>
      'Visit cast.ente.io on the device you want to pair.\n\nEnter the code below to play the album on your TV.';

  @override
  String get deviceCodeHint => 'Ange koden';

  @override
  String get joinDiscord => 'Gå med i Discord';

  @override
  String get locations => 'Platser';

  @override
  String get addAName => 'Lägg till ett namn';

  @override
  String get findThemQuickly => 'Hitta dem snabbt';

  @override
  String get findPeopleByName => 'Find people quickly by name';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add viewers',
      one: 'Add viewer',
      zero: 'Add viewer',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add collaborators',
      one: 'Add collaborator',
      zero: 'Add collaborator',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      'Long press an email to verify end to end encryption.';

  @override
  String get developerSettingsWarning =>
      'Are you sure that you want to modify Developer settings?';

  @override
  String get developerSettings => 'Utvecklarinställningar';

  @override
  String get serverEndpoint => 'Server endpoint';

  @override
  String get invalidEndpoint => 'Invalid endpoint';

  @override
  String get invalidEndpointMessage =>
      'Sorry, the endpoint you entered is invalid. Please enter a valid endpoint and try again.';

  @override
  String get endpointUpdatedMessage => 'Endpoint updated successfully';

  @override
  String customEndpoint({required Object endpoint}) {
    return 'Ansluten till $endpoint';
  }

  @override
  String get createCollaborativeLink => 'Create collaborative link';

  @override
  String get search => 'Sök';

  @override
  String get enterPersonName => 'Ange personnamn';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'This email is already linked to $name.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return 'View $name to unlink';
  }

  @override
  String get enterName => 'Ange namn';

  @override
  String get savePerson => 'Spara person';

  @override
  String get editPerson => 'Redigera person';

  @override
  String get mergedPhotos => 'Sammanslagna foton';

  @override
  String get orMergeWithExistingPerson => 'Or merge with existing';

  @override
  String get enterDateOfBirth => 'Birthday (optional)';

  @override
  String get birthday => 'Födelsedag';

  @override
  String get removePersonLabel => 'Remove person label';

  @override
  String get autoPairDesc =>
      'Auto pair works only with devices that support Chromecast.';

  @override
  String get manualPairDesc =>
      'Pair with PIN works with any screen you wish to view your album on.';

  @override
  String get connectToDevice => 'Anslut till enhet';

  @override
  String get autoCastDialogBody => 'You\'ll see available Cast devices here.';

  @override
  String get autoCastiOSPermission =>
      'Make sure Local Network permissions are turned on for the Ente Photos app, in Settings.';

  @override
  String get noDeviceFound => 'Ingen enhet hittades';

  @override
  String get stopCastingTitle => 'Stop casting';

  @override
  String get stopCastingBody => 'Do you want to stop casting?';

  @override
  String get castIPMismatchTitle => 'Failed to cast album';

  @override
  String get castIPMismatchBody =>
      'Please make sure you are on the same network as the TV.';

  @override
  String get pairingComplete => 'Parkoppling lyckades';

  @override
  String get savingEdits => 'Sparar ändringar...';

  @override
  String get autoPair => 'Auto pair';

  @override
  String get pairWithPin => 'Parkoppla med PIN-kod';

  @override
  String get faceRecognition => 'Ansiktsigenkänning';

  @override
  String get foundFaces => 'Hittade ansikten';

  @override
  String get clusteringProgress => 'Clustering progress';

  @override
  String get trim => 'Trim';

  @override
  String get crop => 'Crop';

  @override
  String get rotate => 'Rotera';

  @override
  String get left => 'Vänster';

  @override
  String get right => 'Höger';

  @override
  String get whatsNew => 'Nyheter';

  @override
  String get reviewSuggestions => 'Review suggestions';

  @override
  String get review => 'Review';

  @override
  String get useAsCover => 'Använd som omslag';

  @override
  String notPersonLabel({required String name}) {
    return 'Inte $name?';
  }

  @override
  String get enable => 'Aktivera';

  @override
  String get enabled => 'Aktiverad';

  @override
  String get moreDetails => 'Mer detaljer';

  @override
  String get enableMLIndexingDesc =>
      'Ente supports on-device machine learning for face recognition, magic search and other advanced search features';

  @override
  String get magicSearchHint =>
      'Magic search allows to search photos by their contents, e.g. \'flower\', \'red car\', \'identity documents\'';

  @override
  String get panorama => 'Panorama';

  @override
  String get reenterPassword => 'Ange lösenord igen';

  @override
  String get reenterPin => 'Ange PIN-kod igen';

  @override
  String get deviceLock => 'Enhetslås';

  @override
  String get pinLock => 'PIN-lås';

  @override
  String get next => 'Nästa';

  @override
  String get setNewPassword => 'Ange nytt lösenord';

  @override
  String get enterPin => 'Ange PIN-kod';

  @override
  String get setNewPin => 'Ange ny PIN-kod';

  @override
  String get appLock => 'Applås';

  @override
  String get noSystemLockFound => 'Inget systemlås hittades';

  @override
  String get tapToUnlock => 'Tryck för att låsa upp';

  @override
  String get tooManyIncorrectAttempts => 'För många felaktiga försök';

  @override
  String get videoInfo => 'Videoinformation';

  @override
  String get autoLock => 'Auto lock';

  @override
  String get immediately => 'Omedelbart';

  @override
  String get autoLockFeatureDescription =>
      'Time after which the app locks after being put in the background';

  @override
  String get hideContent => 'Dölj innehåll';

  @override
  String get hideContentDescriptionAndroid =>
      'Hides app content in the app switcher and disables screenshots';

  @override
  String get hideContentDescriptionIos =>
      'Hides app content in the app switcher';

  @override
  String get passwordStrengthInfo =>
      'Password strength is calculated considering the length of the password, used characters, and whether or not the password appears in the top 10,000 most used passwords';

  @override
  String get noQuickLinksSelected => 'No quick links selected';

  @override
  String get pleaseSelectQuickLinksToRemove =>
      'Please select quick links to remove';

  @override
  String get removePublicLinks => 'Ta bort offentliga länkar';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      'This will remove public links of all selected quick links.';

  @override
  String get guestView => 'Gästvy';

  @override
  String get guestViewEnablePreSteps =>
      'To enable guest view, please setup device passcode or screen lock in your system settings.';

  @override
  String get nameTheAlbum => 'Namnge albumet';

  @override
  String get collectPhotosDescription =>
      'Create a link where your friends can upload photos in original quality.';

  @override
  String get collect => 'Samla';

  @override
  String get appLockDescriptions =>
      'Choose between your device\'s default lock screen and a custom lock screen with a PIN or password.';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'To enable app lock, please setup device passcode or screen lock in your system settings.';

  @override
  String get authToViewPasskey => 'Please authenticate to view your passkey';

  @override
  String get loopVideoOn => 'Disable looping';

  @override
  String get loopVideoOff => 'Enable looping';

  @override
  String get localSyncErrorMessage =>
      'Looks like something went wrong since local photos sync is taking more time than expected. Please reach out to our support team';

  @override
  String get showPerson => 'Visa person';

  @override
  String get sort => 'Sortera';

  @override
  String get mostRecent => 'Senaste';

  @override
  String get mostRelevant => 'Mest relevant';

  @override
  String get loadingYourPhotos => 'Laddar dina foton...';

  @override
  String processingImport({required Object folderName}) {
    return 'Processing $folderName...';
  }

  @override
  String get personName => 'Personnamn';

  @override
  String get addNewPerson => 'Lägg till ny person';

  @override
  String get addNameOrMerge => 'Add name or merge';

  @override
  String get mergeWithExisting => 'Merge with existing';

  @override
  String get newPerson => 'Ny person';

  @override
  String get addName => 'Lägg till namn';

  @override
  String get add => 'Lägg till';

  @override
  String extraPhotosFoundFor({required String text}) {
    return 'Extra photos found for $text';
  }

  @override
  String get extraPhotosFound => 'Extra photos found';

  @override
  String get configuration => 'Konfiguration';

  @override
  String get localIndexing => 'Lokal indexering';

  @override
  String get processed => 'Bearbetade';

  @override
  String get resetPerson => 'Ta bort';

  @override
  String get areYouSureYouWantToResetThisPerson =>
      'Are you sure you want to reset this person?';

  @override
  String get allPersonGroupingWillReset =>
      'All groupings for this person will be reset, and you will lose all suggestions made for this person';

  @override
  String get yesResetPerson => 'Ja, återställ person';

  @override
  String get onlyThem => 'Endast dem';

  @override
  String get checkingModels => 'Kontrollerar modeller...';

  @override
  String get enableMachineLearningBanner =>
      'Enable machine learning for magic search and face recognition';

  @override
  String get searchDiscoverEmptySection =>
      'Images will be shown here once processing and syncing is complete';

  @override
  String get searchPersonsEmptySection =>
      'People will be shown here once processing and syncing is complete';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count viewers',
      one: 'Added 1 viewer',
      zero: 'Added 0 viewers',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count collaborators',
      one: 'Added 1 collaborator',
      zero: 'Added 0 collaborator',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured => 'Kontot är redan konfigurerat.';

  @override
  String get sessionIdMismatch => 'Session ID mismatch';

  @override
  String get failedToFetchActiveSessions => 'Failed to fetch active sessions';

  @override
  String get failedToRefreshStripeSubscription =>
      'Failed to refresh subscription';

  @override
  String get failedToPlayVideo => 'Kunde inte spela video';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return 'Upload is ignored due to $ignoreReason';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'Type of gallery $galleryType is not supported for rename';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'Tap to upload, upload is currently ignored due to $ignoreReason';
  }

  @override
  String get tapToUpload => 'Tryck för att ladda upp';

  @override
  String get info => 'Info';

  @override
  String get addFiles => 'Lägg till filer';

  @override
  String get castAlbum => 'Cast album';

  @override
  String get imageNotAnalyzed => 'Bild inte analyserad';

  @override
  String get noFacesFound => 'Inga ansikten hittades';

  @override
  String get fileNotUploadedYet => 'Filen har inte laddats upp ännu';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return 'Inga förslag för $personName';
  }

  @override
  String get month => 'månad';

  @override
  String get yearShort => 'yr';

  @override
  String get currentlyRunning => 'currently running';

  @override
  String get ignored => 'ignorerad';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count photos',
      one: '1 photo',
      zero: '0 photos',
    );
    return '$_temp0';
  }

  @override
  String get file => 'Fil';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'Sections length mismatch: $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'Välj e-postapp';

  @override
  String get selectAllShort => 'Alla';

  @override
  String get selectCoverPhoto => 'Select cover photo';

  @override
  String get newLocation => 'Ny plats';

  @override
  String get faceNotClusteredYet =>
      'Face not clustered yet, please come back later';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'The link you are trying to access has expired.';

  @override
  String get openFile => 'Öppna fil';

  @override
  String get backupFile => 'Säkerhetskopiera fil';

  @override
  String get openAlbumInBrowser => 'Öppna album i webbläsare';

  @override
  String get openAlbumInBrowserTitle =>
      'Please use the web app to add photos to this album';

  @override
  String get allow => 'Tillåt';

  @override
  String get allowAppToOpenSharedAlbumLinks =>
      'Allow app to open shared album links';

  @override
  String get seePublicAlbumLinksInApp => 'See public album links in app';

  @override
  String get emergencyContacts => 'Nödkontakter';

  @override
  String get acceptTrustInvite => 'Acceptera inbjudan';

  @override
  String get declineTrustInvite => 'Avböj inbjudan';

  @override
  String get removeYourselfAsTrustedContact =>
      'Remove yourself as trusted contact';

  @override
  String get legacy => 'Legacy';

  @override
  String get legacyPageDesc =>
      'Legacy allows trusted contacts to access your account in your absence.';

  @override
  String get legacyPageDesc2 =>
      'Trusted contacts can initiate account recovery, and if not blocked within 30 days, reset your password and access your account.';

  @override
  String get legacyAccounts => 'Legacy accounts';

  @override
  String get trustedContacts => 'Betrodda kontakter';

  @override
  String get addTrustedContact => 'Lägg till betrodd kontakt';

  @override
  String get removeInvite => 'Ta bort inbjudan';

  @override
  String get recoveryWarning =>
      'A trusted contact is trying to access your account';

  @override
  String get rejectRecovery => 'Reject recovery';

  @override
  String get recoveryInitiated => 'Recovery initiated';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return 'You can access the account after $days days. A notification will be sent to $email.';
  }

  @override
  String get cancelAccountRecovery => 'Avbryt återställning';

  @override
  String get recoveryAccount => 'Återställ konto';

  @override
  String get cancelAccountRecoveryBody =>
      'Are you sure you want to cancel recovery?';

  @override
  String get startAccountRecoveryTitle => 'Starta återställning';

  @override
  String get whyAddTrustContact =>
      'Trusted contact can help in recovering your data.';

  @override
  String recoveryReady({required String email}) {
    return 'You can now recover $email\'s account by setting a new password.';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email is trying to recover your account.';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return 'You have been invited to be a legacy contact by $email.';
  }

  @override
  String get warning => 'Varning';

  @override
  String get proceed => 'Fortsätt';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return 'You are about to add $email as a trusted contact. They will be able to recover your account if you are absent for $numOfDays days.';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email has invited you to be a trusted contact';
  }

  @override
  String get authToManageLegacy =>
      'Please authenticate to manage your trusted contacts';

  @override
  String get hideSharedItemsFromHomeGallery =>
      'Hide shared items from home gallery';

  @override
  String get swipeToSelect => 'Swipe to select';

  @override
  String get gallery => 'Galleri';

  @override
  String get joinAlbum => 'Join album';

  @override
  String get joinAlbumSubtext => 'to view and add your photos';

  @override
  String get joinAlbumSubtextViewer => 'to add this to shared albums';

  @override
  String get join => 'Join';

  @override
  String get linkEmail => 'Länka e-post';

  @override
  String get link => 'Länk';

  @override
  String get noEnteAccountExclamation => 'No Ente account!';

  @override
  String get orPickFromYourContacts => 'eller välj från dina kontakter';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return '$email does not have an Ente account.';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (Me)';
  }

  @override
  String get reassignMe => 'Reassign \"Me\"';

  @override
  String get me => 'Me';

  @override
  String get linkEmailToContactBannerCaption => 'för snabbare delning';

  @override
  String get selectPersonToLink => 'Välj person att länka';

  @override
  String linkPersonToEmail({required String email}) {
    return 'Länka person till $email';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return 'This will link $personName to $email';
  }

  @override
  String get selectYourFace => 'Välj ditt ansikte';

  @override
  String get reassigningLoading => 'Reassigning...';

  @override
  String reassignedToName({required String name}) {
    return 'Reassigned you to $name';
  }

  @override
  String get saveChangesBeforeLeavingQuestion =>
      'Spara ändringar innan du lämnar?';

  @override
  String get dontSave => 'Spara inte';

  @override
  String get thisIsMeExclamation => 'Det här är jag!';

  @override
  String get linkPerson => 'Länka person';

  @override
  String get linkPersonCaption => 'for better sharing experience';

  @override
  String get videoStreaming => 'Streamable videos';

  @override
  String get processingVideos => 'Bearbetar videor';

  @override
  String get streamDetails => 'Strömdetaljer';

  @override
  String get processing => 'Bearbetar';

  @override
  String get queued => 'Köad';

  @override
  String get ineligible => 'Ineligible';

  @override
  String get failed => 'Failed';

  @override
  String get playStream => 'Spela ström';

  @override
  String get playOriginal => 'Spela original';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'Joining an album will make your email visible to its participants.';

  @override
  String get pleaseWaitThisWillTakeAWhile =>
      'Vänligen vänta, detta kommer att ta ett tag.';

  @override
  String get editTime => 'Redigera tid';

  @override
  String get selectTime => 'Välj tid';

  @override
  String get selectDate => 'Välj datum';

  @override
  String get previous => 'Föregående';

  @override
  String get selectOneDateAndTimeForAll => 'Välj ett datum och tid för alla';

  @override
  String get selectStartOfRange => 'Select start of range';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      'This will make the date and time of all selected photos the same.';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'This is the first in the group. Other selected photos will automatically shift based on this new date';

  @override
  String get newRange => 'New range';

  @override
  String get selectOneDateAndTime => 'Välj ett datum och tid';

  @override
  String get moveSelectedPhotosToOneDate => 'Flytta valda foton till ett datum';

  @override
  String get shiftDatesAndTime => 'Shift dates and time';

  @override
  String get photosKeepRelativeTimeDifference =>
      'Photos keep relative time difference';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count photos',
      one: '1 photo',
      zero: 'No photos',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'Appikon';

  @override
  String get notThisPerson => 'Inte den här personen?';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      'Selected items will be removed from this person, but not deleted from your library.';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat through the years';
  }

  @override
  String get thisWeekThroughTheYears => 'This week through the years';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'This week, $count years ago',
      one: 'This week, $count year ago',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'Du och $name';
  }

  @override
  String admiringThem({required Object name}) {
    return 'Beundrar $name';
  }

  @override
  String embracingThem({required Object name}) {
    return 'Embracing $name';
  }

  @override
  String partyWithThem({required Object name}) {
    return 'Party med $name';
  }

  @override
  String hikingWithThem({required Object name}) {
    return 'Hiking with $name';
  }

  @override
  String feastingWithThem({required Object name}) {
    return 'Feasting with $name';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return 'Selfies with $name';
  }

  @override
  String posingWithThem({required Object name}) {
    return 'Posing with $name';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return 'Beautiful views with $name';
  }

  @override
  String sportsWithThem({required Object name}) {
    return 'Sports with $name';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return 'Road trip with $name';
  }

  @override
  String get spotlightOnYourself => 'Spotlight on yourself';

  @override
  String spotlightOnThem({required Object name}) {
    return 'Spotlight on $name';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$name är $age!';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name turning $age soon';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return 'Senast med $name';
  }

  @override
  String tripToLocation({required Object location}) {
    return 'Trip to $location';
  }

  @override
  String tripInYear({required Object year}) {
    return 'Trip in $year';
  }

  @override
  String get lastYearsTrip => 'Förra årets resa';

  @override
  String get sunrise => 'På horisonten';

  @override
  String get mountains => 'Över kullarna';

  @override
  String get greenery => 'Det gröna livet';

  @override
  String get beach => 'Sand och hav';

  @override
  String get city => 'I staden';

  @override
  String get moon => 'I månskenet';

  @override
  String get onTheRoad => 'På vägarna igen';

  @override
  String get food => 'Culinary delight';

  @override
  String get pets => 'Furry companions';

  @override
  String get curatedMemories => 'Curated memories';

  @override
  String get widgets => 'Widgets';

  @override
  String get memories => 'Minnen';

  @override
  String get peopleWidgetDesc =>
      'Select the people you wish to see on your homescreen.';

  @override
  String get albumsWidgetDesc =>
      'Select the albums you wish to see on your homescreen.';

  @override
  String get memoriesWidgetDesc =>
      'Select the kind of memories you wish to see on your homescreen.';

  @override
  String get smartMemories => 'Smarta minnen';

  @override
  String get pastYearsMemories => 'Tidigare års minnen';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return 'Also delete the photos (and videos) present in these $count albums from <bold>all</bold> other albums they are part of?';
  }

  @override
  String get addParticipants => 'Lägg till deltagare';

  @override
  String selectedAlbums({required Object count}) {
    return '$count selected';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'Action not supported on Favourites album';

  @override
  String get onThisDayMemories => 'On this day memories';

  @override
  String get onThisDay => 'På denna dag';

  @override
  String get lookBackOnYourMemories => 'Look back on your memories 🌄';

  @override
  String get newPhotosEmoji => ' ny 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'Sorry, we had to pause your backups';

  @override
  String get clickToInstallOurBestVersionYet =>
      'Click to install our best version yet';

  @override
  String get onThisDayNotificationExplanation =>
      'Receive reminders about memories from this day in previous years.';

  @override
  String get addMemoriesWidgetPrompt =>
      'Add a memories widget to your homescreen and come back here to customize.';

  @override
  String get addAlbumWidgetPrompt =>
      'Add an album widget to your homescreen and come back here to customize.';

  @override
  String get addPeopleWidgetPrompt =>
      'Add a people widget to your homescreen and come back here to customize.';

  @override
  String get birthdayNotifications => 'Birthday notifications';

  @override
  String get receiveRemindersOnBirthdays =>
      'Receive reminders when it\'s someone\'s birthday. Tapping on the notification will take you to photos of the birthday person.';

  @override
  String get happyBirthday => 'Grattis på födelsedagen! 🥳';

  @override
  String get birthdays => 'Födelsedagar';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return 'Wish $name a happy birthday! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      'Are you sure you want to remove this face from this person?';

  @override
  String get otherDetectedFaces => 'Andra upptäckta ansikten';

  @override
  String get areThey => 'Är de ';

  @override
  String get questionmark => '?';

  @override
  String get saveAsAnotherPerson => 'Spara som annan person';

  @override
  String get showLessFaces => 'Visa färre ansikten';

  @override
  String get showMoreFaces => 'Visa fler ansikten';

  @override
  String get ignore => 'Ignorera';

  @override
  String get merge => 'Merge';

  @override
  String get reset => 'Återställ';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      'Are you sure you want to ignore this person?';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      'Are you sure you want to ignore these persons?';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'The person groups will not be displayed in the people section anymore. Photos will remain untouched.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'The person will not be displayed in the people section anymore. Photos will remain untouched.';

  @override
  String get areYouSureYouWantToMergeThem =>
      'Är du säker på att du vill slå ihop dem?';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'All unnamed groups will be merged into the selected person. This can still be undone from the suggestions history overview of the person.';

  @override
  String get yesIgnore => 'Ja, ignorera';

  @override
  String get same => 'Samma';

  @override
  String get different => 'Annorlunda';

  @override
  String get sameperson => 'Samma person?';

  @override
  String get indexingPausedStatusDescription =>
      'Indexing is paused. It will automatically resume when the device is ready. The device is considered ready when its battery level, battery health, and thermal status are within a healthy range.';

  @override
  String get thisWeek => 'Denna vecka';

  @override
  String get lastWeek => 'Förra veckan';

  @override
  String get thisMonth => 'Denna månad';

  @override
  String get thisYear => 'This year';

  @override
  String get groupBy => 'Gruppera efter';

  @override
  String get faceThumbnailGenerationFailed =>
      'Unable to generate face thumbnails';

  @override
  String get fileAnalysisFailed => 'Kunde inte analysera fil';

  @override
  String get editAutoAddPeople => 'Edit auto-add people';

  @override
  String get autoAddPeople => 'Auto-add people';

  @override
  String get autoAddToAlbum => 'Auto-add to album';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      'Should the files related to the person that were previously selected in smart albums be removed?';

  @override
  String get addingPhotos => 'Lägger till foton';

  @override
  String get gettingReady => 'Förbered dig';

  @override
  String get addSomePhotosDesc1 => 'Add some photos or pick ';

  @override
  String get addSomePhotosDesc2 => 'bekanta ansikten';

  @override
  String get addSomePhotosDesc3 => '\ntill att börja med';

  @override
  String get ignorePerson => 'Ignorera person';

  @override
  String get mixedGrouping => 'Mixed grouping?';

  @override
  String get analysis => 'Analys';

  @override
  String get doesGroupContainMultiplePeople =>
      'Does this grouping contain multiple people?';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'We will automatically analyze the grouping to determine if there are multiple people present, and separate them out again. This may take a few seconds.';

  @override
  String get layout => 'Layout';

  @override
  String get day => 'Dag';

  @override
  String get undo => 'Ångra';

  @override
  String get redo => 'Upprepa';

  @override
  String get filter => 'Filter';

  @override
  String get adjust => 'Justera';

  @override
  String get draw => 'Draw';

  @override
  String get sticker => 'Sticker';

  @override
  String get brushColor => 'Brush Color';

  @override
  String get font => 'Font';

  @override
  String get background => 'Bakgrund';

  @override
  String get align => 'Align';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added successfully to $count albums',
      one: 'Added successfully to 1 album',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => 'Videor bearbetade';

  @override
  String get totalVideos => 'Total videos';

  @override
  String get skippedVideos => 'Överhoppade videor';

  @override
  String get videoStreamingDescriptionLine1 =>
      'Play videos instantly on any device.';

  @override
  String get videoStreamingDescriptionLine2 =>
      'Enable to process video streams on this device.';

  @override
  String get videoStreamingNote =>
      'Only videos from last 60 days and under 1 minute are processed on this device. For older/longer videos, enable streaming in the desktop app.';

  @override
  String get createStream => 'Skapa ström';

  @override
  String get recreateStream => 'Återskapa ström';

  @override
  String get addedToStreamCreationQueue => 'Added to stream creation queue';

  @override
  String get addedToStreamRecreationQueue => 'Added to stream recreation queue';

  @override
  String get videoPreviewAlreadyExists => 'Video preview already exists';

  @override
  String get videoAlreadyInQueue => 'Video file already present in the queue';

  @override
  String get videoExportFailed => 'Video creation failed. Please try again.';

  @override
  String videoExportSuccess({required String path}) {
    return 'Video successfully created at $path';
  }

  @override
  String get addedToQueue => 'Tillagd i kön';

  @override
  String get creatingStream => 'Skapar ström';

  @override
  String get similarImages => 'Liknande bilder';

  @override
  String get findSimilarImages => 'Hitta liknande bilder';

  @override
  String get noSimilarImagesFound => 'Inga liknande bilder hittades';

  @override
  String get yourPhotosLookUnique => 'Your photos look unique';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count groups found',
      one: '$count group found',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages => 'Review and remove similar images';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return 'Delete $count photos ($size)';
  }

  @override
  String get selectionOptions => 'Selection options';

  @override
  String selectExactWithCount({required int count}) {
    return 'Exactly similar ($count)';
  }

  @override
  String get selectExact => 'Välj exakt';

  @override
  String selectSimilarWithCount({required int count}) {
    return 'Mostly similar ($count)';
  }

  @override
  String get selectSimilar => 'Välj liknande';

  @override
  String selectAllWithCount({required int count}) {
    return 'All similarities ($count)';
  }

  @override
  String get selectSimilarImagesTitle => 'Välj liknande bilder';

  @override
  String get chooseSimilarImagesToSelect =>
      'Select images based on their visual similarity';

  @override
  String get clearSelection => 'Clear selection';

  @override
  String similarImagesCount({required int count}) {
    return '$count liknande bilder';
  }

  @override
  String deleteWithCount({required int count}) {
    return 'Ta bort ($count)';
  }

  @override
  String get deleteFiles => 'Ta bort filer';

  @override
  String get areYouSureDeleteFiles =>
      'Are you sure you want to delete these files?';

  @override
  String get greatJob => 'Bra jobbat!';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return 'You freed up $size of space';
  }

  @override
  String get size => 'Storlek';

  @override
  String get similarity => 'Likhet';

  @override
  String get analyzingPhotosLocally => 'Analyzing your photos locally...';

  @override
  String get lookingForVisualSimilarities =>
      'Looking for visual similarities...';

  @override
  String get comparingImageDetails => 'Jämför bilddetaljer...';

  @override
  String get findingSimilarImages => 'Hittar liknande bilder...';

  @override
  String get almostDone => 'Nästan klar...';

  @override
  String get processingLocally => 'Bearbetar lokalt';

  @override
  String get useMLToFindSimilarImages =>
      'Review and remove images that look similar to each other.';

  @override
  String get all => 'Alla';

  @override
  String get similar => 'Liknande';

  @override
  String get identical => 'Identisk';

  @override
  String get nothingHereTryAnotherFilter =>
      'Ingenting här, prova ett annat filter! 👀';

  @override
  String get related => 'Relaterat';

  @override
  String get hoorayyyy => 'Huurraaaa!';

  @override
  String get nothingToTidyUpHere => 'Nothing to tidy up here';

  @override
  String get deletingDash => 'Tar bort - ';

  @override
  String get cLTitle1 => 'Gå till datum';

  @override
  String get cLDesc1 =>
      'See surrounding photos for any photo by selecting the jump to date option in the file\'s info pane.';

  @override
  String get cLTitle2 => 'Faster video editor';

  @override
  String get cLDesc2 =>
      'Video editor was revamped to both drastically improve its speed when editing larger videos, and also improve the UX.';

  @override
  String get cLTitle3 => 'Nya minnen';

  @override
  String get cLDesc3 =>
      '\"Playful kids\", \"Winter adventures\", \"Neon nights\", and more.';

  @override
  String get cLTitle4 => 'Landscape gallery and more';

  @override
  String get cLDesc4 =>
      'Support for landscape layout in the app\'s main gallery. Show persons without any associated photos instead of filtering them out. Improve video aspect detection when shared from external apps.';

  @override
  String get closeBy => 'Stäng';

  @override
  String get peopleAutoAddDesc =>
      'Automatically add photos of the selected people to this album';

  @override
  String get festivities => 'Festive cheer';

  @override
  String get snowAdventures => 'Vinteräventyr';

  @override
  String get waterfalls => 'Chasing waterfalls';

  @override
  String get wildlife => 'In i vildmarken';

  @override
  String get flowers => 'Blooming beauties';

  @override
  String get nightLights => 'Neonnätter';

  @override
  String get architecture => 'Designa ikoner';

  @override
  String get autumnColors => 'Autumn splendor';

  @override
  String get desertDreams => 'Desert dreams';

  @override
  String get stargazing => 'Under stjärnorna';

  @override
  String get lakeside => 'Sjönära lugn';

  @override
  String get rainyDays => 'Rainy day feels';

  @override
  String get sportsAction => 'Game on';

  @override
  String get streetArt => 'Street art stories';

  @override
  String get familyMoments => 'Familjetid';

  @override
  String get fireworks => 'Firework finale';

  @override
  String get historicSites => 'Echoes of history';

  @override
  String get tropicalParadise => 'Tropical escapes';

  @override
  String get forestTrails => 'Skogspromenader';

  @override
  String get citySunsets => 'City sunset glow';

  @override
  String get colorfulMarkets => 'Vibrant markets';

  @override
  String get cozyCafes => 'Cozy cafe corners';

  @override
  String get vintageVibes => 'Vintage vibes';

  @override
  String get aerialViews => 'Flygperspektiv';

  @override
  String get artisticPortraits => 'Konstnärliga porträtt';

  @override
  String get streetFood => 'Street food bites';

  @override
  String get riverCruises => 'River cruise views';

  @override
  String get facesTimelineBannerTitle => 'Memory Lane';

  @override
  String facesTimelineBannerSubtitle({required String name}) {
    return 'See $name\'s photos across the years';
  }

  @override
  String get facesTimelineAppBarTitle => 'Memory lane';

  @override
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count years old',
      one: '$count year old',
    );
    return '$name was $_temp0';
  }

  @override
  String facesTimelineCaptionYearsAgo({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '# years ago',
      one: '# year ago',
    );
    return '$_temp0';
  }

  @override
  String get facesTimelineShareComingSoon => 'Video sharing coming soon';

  @override
  String get facesTimelinePlaybackPrevious => 'Föregående';

  @override
  String get facesTimelinePlaybackNext => 'Nästa';

  @override
  String get facesTimelinePlaybackPlay => 'Spela';

  @override
  String get facesTimelinePlaybackPause => 'Pausa';

  @override
  String get facesTimelineUnavailable => 'Faces timeline is preparing...';

  @override
  String get playfulKids => 'Lekfulla barn';

  @override
  String get coastalCliffs => 'Klippor vid havet';

  @override
  String get ritualsTitle => 'Rituals';

  @override
  String get ritualAddTooltip => 'Add ritual';

  @override
  String get ritualActivityHeading => 'Activity';

  @override
  String get ritualDefaultHeatmapTitle => 'Take a photo every day';

  @override
  String get ritualUntitled => 'Untitled ritual';

  @override
  String get ritualShareUnavailable =>
      'Unable to share right now. Please try again.';

  @override
  String get ritualNotificationMessage => 'Take a photo now';

  @override
  String get ritualCameraNotFound => 'No camera found on this device.';

  @override
  String get ritualCameraStartError =>
      'Unable to start camera. Please check permissions.';

  @override
  String get ritualCaptureError => 'Unable to capture photo. Please try again.';

  @override
  String ritualPhotoLimit({required int maxPhotos}) {
    String _temp0 = intl.Intl.pluralLogic(
      maxPhotos,
      locale: localeName,
      other: '# photos.',
      one: '# photo.',
    );
    return 'You can add up to $_temp0';
  }

  @override
  String get ritualCaptureAtLeastOne => 'Capture at least one photo first.';

  @override
  String get ritualAlbumMissing =>
      'Ritual album missing. Edit the ritual to set an album.';

  @override
  String get ritualAddedToAlbum => 'Added to album';

  @override
  String ritualAddedToAlbumWithName({required String albumName}) {
    return 'Added to $albumName';
  }

  @override
  String ritualAddToAlbumFailure({required String error}) {
    return 'Couldn\'t add photos to the album: $error';
  }

  @override
  String get ritualBackToList => 'Back to rituals';

  @override
  String get ritualNoPhotosYet => 'No photos yet';

  @override
  String get ritualSetAlbumToLaunchCamera =>
      'Set an album for this ritual to launch the camera.';

  @override
  String get ritualDefaultCameraTitle => 'Take a photo';

  @override
  String get ritualBadgeMessage7 =>
      '7 days down! Consistency looks good on you. Keep going!';

  @override
  String get ritualBadgeMessage14 =>
      '14 days in! Your ritual is becoming a habit. Incredible!';

  @override
  String get ritualBadgeMessage30 =>
      '30 days in a row! Legendary consistency. Take a bow!';

  @override
  String get ritualBadgeMessageDefault => 'You\'re on a roll!';

  @override
  String get ritualBadgeNewTitle => 'New achievement';

  @override
  String get ritualBadgePreparing => 'Preparing...';

  @override
  String get ritualStreaksLabel => 'Streaks';

  @override
  String get ritualCreateYourOwn => 'Create your own ritual';

  @override
  String get ritualGetDailyReminders => 'Get daily reminders';

  @override
  String get ritualAlbumNotSet => 'Album not set';

  @override
  String get ritualOpenCameraTooltip => 'Open ritual camera';

  @override
  String get ritualEditorLabel => 'Ritual editor';

  @override
  String get ritualNew => 'New ritual';

  @override
  String get ritualEdit => 'Edit ritual';

  @override
  String get ritualEnterPrompt => 'Enter your ritual';

  @override
  String get ritualEnterDescription => 'Please enter a description';

  @override
  String get ritualDayLabel => 'Day';

  @override
  String get ritualNotificationsOffHint =>
      'Notifications are off. Tap a day to turn them on.';

  @override
  String get ritualTimeLabel => 'Time';

  @override
  String get ritualAlbumLabel => 'Album';

  @override
  String get ritualSave => 'Save ritual';

  @override
  String get ritualUpdate => 'Update ritual';

  @override
  String get ritualSelectAlbumTitle => 'Select album';

  @override
  String get ritualSearchOrCreate => 'Search or create new';

  @override
  String get ritualNoAlbumsYet => 'No albums yet';

  @override
  String get ritualNoMatchingAlbums => 'No matching albums';

  @override
  String ritualCreateAlbumWithName({required String albumName}) {
    return 'Create \"$albumName\"';
  }

  @override
  String get ritualCreateNew => 'Create new';

  @override
  String get ritualAlbumSelectionPlaceholder => 'Select album';

  @override
  String get ritualPickEmojiTitle => 'Pick an emoji';

  @override
  String get ritualCustomKeyboardLabel => 'Custom (keyboard)';

  @override
  String get ritualEmojiKeyboardHint => 'Press to open emoji keyboard';

  @override
  String get ritualEmojiUseAction => 'Use';

  @override
  String get ritualSearchEmpty =>
      'Build a ritual to keep your photo habit going.';
}
