// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Serbian (`sr`).
class AppLocalizationsSr extends AppLocalizations {
  AppLocalizationsSr([String locale = 'sr']) : super(locale);

  @override
  String get enterYourEmailAddress => 'Унесите Вашу е-пошту';

  @override
  String get enterYourNewEmailAddress => 'Унесите Вашу нову е-пошту';

  @override
  String get accountWelcomeBack => 'Добродошли назад!';

  @override
  String get emailAlreadyRegistered => 'Е-пошта је већ регистрована.';

  @override
  String get emailNotRegistered => 'Е-пошта није регистрована.';

  @override
  String get email => 'Е-пошта';

  @override
  String get cancel => 'Откажи';

  @override
  String get verify => 'Верификуј';

  @override
  String get invalidEmailAddress => 'Неисправна е-пошта';

  @override
  String get enterValidEmail => 'Молимо унесите исправну адресу е-поште.';

  @override
  String get deleteAccount => 'Обриши налог';

  @override
  String get deleteAccountWarning =>
      'This will delete your Ente Auth, Ente Photos and Ente Locker account.';

  @override
  String get askDeleteReason => 'Који је главни разлог што бришете свој налог?';

  @override
  String get deleteAccountFeedbackPrompt =>
      'Жао нам је што одлазите. Молимо вас да нам оставите повратне информације како бисмо могли да се побољшамо.';

  @override
  String get feedback => 'Повратне информације';

  @override
  String get kindlyHelpUsWithThisInformation =>
      'Љубазно вас молимо да нам помогнете са овим информацијама';

  @override
  String get confirmDeletePrompt =>
      'Да, желим трајно да избришем овај налог и све његове податке у свим апликацијама.';

  @override
  String get confirmAccountDeletion => 'Потврдите брисање налога';

  @override
  String get deleteAccountPermanentlyButton => 'Трајно обриши налог';

  @override
  String get yourAccountHasBeenDeleted => 'Ваш налог је обрисан';

  @override
  String get selectReason => 'Одаберите разлог';

  @override
  String get deleteReason1 => 'Недостаје важна функција која ми је потребна';

  @override
  String get deleteReason2 =>
      'Апликација или одређена функција не ради онако како мислим да би требало';

  @override
  String get deleteReason3 =>
      'Пронашао/ла сам други сервис који ми више одговара';

  @override
  String get deleteReason4 => 'Мој разлог није на листи';

  @override
  String get sendEmail => 'Пошаљи е-пошту';

  @override
  String get deleteRequestSLAText =>
      'Ваш захтев ће бити обрађен у року од 72 сата.';

  @override
  String get deleteEmailRequest =>
      'Молимо пошаљите имејл на <warning>account-deletion@ente.io</warning> са ваше регистроване адресе е-поште.';

  @override
  String get entePhotosPerm =>
      'Енте-у <i>је потребна дозвола да</i> сачува ваше фотографије';

  @override
  String get ok => 'Ок';

  @override
  String get createAccount => 'Направи налог';

  @override
  String get createNewAccount => 'Креирај нови налог';

  @override
  String get password => 'Лозинка';

  @override
  String get confirmPassword => 'Потврдите лозинку';

  @override
  String get activeSessions => 'Активне сесије';

  @override
  String get ocrProcessingOverlayMessage => 'Detecting text...';

  @override
  String get ocrLoadingIndicatorLabel => 'Detecting Text';

  @override
  String get ocrSelectionHint =>
      'Swipe or double tap to select just what you need';

  @override
  String get ocrNoTextDetected => 'No text detected';

  @override
  String get ocrRetryButtonLabel => 'Retry';

  @override
  String get ocrModelsNetworkRequiredError =>
      'Network connection required to download OCR models on first use';

  @override
  String get ocrModelsPrepareFailed => 'Could not prepare OCR models';

  @override
  String get ocrImageNotFoundError => 'Image file not found';

  @override
  String get ocrImageDecodeFailedError => 'Could not read image file';

  @override
  String get ocrGenericDetectError => 'Could not detect text in image';

  @override
  String get oops => 'Упс!';

  @override
  String get somethingWentWrongPleaseTryAgain =>
      'Нешто је пошло наопако, покушајте поново';

  @override
  String get thisWillLogYouOutOfThisDevice =>
      'Ово ће вас одјавити са овог уређаја!';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice =>
      'Ово ће вас одјавити са овог уређаја:';

  @override
  String get terminateSession => 'Прекинути сесију?';

  @override
  String get terminate => 'Прекини';

  @override
  String get thisDevice => 'Овај уређај';

  @override
  String get recoverButton => 'Опорави';

  @override
  String get recoverySuccessful => 'Опоравак успешан!';

  @override
  String get decrypting => 'Дешифровање...';

  @override
  String get incorrectRecoveryKeyTitle => 'Нетачан кључ за опоравак';

  @override
  String get incorrectRecoveryKeyBody => 'Унети кључ за опоравак је натачан';

  @override
  String get forgotPassword => 'Заборавио сам лозинку';

  @override
  String get enterYourRecoveryKey => 'Унесите Ваш кључ за опоравак';

  @override
  String get noRecoveryKey => 'Немате кључ за опоравак?';

  @override
  String get sorry => 'Извините';

  @override
  String get noRecoveryKeyNoDecryption =>
      'Због природе нашег протокола за крај-до-крај енкрипцију, ваши подаци не могу бити дешифровани без ваше лозинке или кључа за опоравак';

  @override
  String get verifyEmail => 'Верификуј е-пошту';

  @override
  String get toResetVerifyEmail =>
      'Да бисте ресетовали лозинку, прво потврдите своју е-пошту.';

  @override
  String get checkInboxAndSpamFolder =>
      'Молимо вас да проверите примљену пошту (и нежељену пошту) да бисте довршили верификацију';

  @override
  String get tapToEnterCode => 'Пипните да бисте унели кôд';

  @override
  String get resendEmail => 'Поново пошаљи е-пошту';

  @override
  String weHaveSendEmailTo({required String email}) {
    return 'Послали смо е-попту на <green>$email</green>';
  }

  @override
  String get setPasswordTitle => 'Постави лозинку';

  @override
  String get changePasswordTitle => 'Промени лозинку';

  @override
  String get resetPasswordTitle => 'Ресетуј лозинку';

  @override
  String get encryptionKeys => 'Кључеви шифровања';

  @override
  String get passwordWarning =>
      'Не чувамо ову лозинку, па ако је заборавите, <underline>не можемо дешифрирати ваше податке</underline>';

  @override
  String get enterPasswordToEncrypt =>
      'Унесите лозинку коју можемо да користимо за шифровање ваших података';

  @override
  String get enterNewPasswordToEncrypt =>
      'Унесите нову лозинку коју можемо да користимо за шифровање ваших података';

  @override
  String get weakStrength => 'Слабо';

  @override
  String get strongStrength => 'Јако';

  @override
  String get moderateStrength => 'Средње';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'Снага лозинке: $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully => 'Лозинка је успешно промењена';

  @override
  String get generatingEncryptionKeys => 'Генерисање кључева за шифровање...';

  @override
  String get pleaseWait => 'Молимо сачекајте...';

  @override
  String get continueLabel => 'Настави';

  @override
  String get insecureDevice => 'Уређај није сигуран';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'Извините, не можемо да генеришемо сигурне кључеве на овом уређају.\n\nМолимо пријавите се са другог уређаја.';

  @override
  String get howItWorks => 'Како ради';

  @override
  String get encryption => 'Шифровање';

  @override
  String get ackPasswordLostWarning =>
      'Разумем да ако изгубим лозинку, могу изгубити своје податке пошто су <underline>шифрирани од краја до краја</underline>.';

  @override
  String get privacyPolicyTitle => 'Политика приватности';

  @override
  String get termsOfServicesTitle => 'Услови';

  @override
  String get signUpTerms =>
      'Прихватам <u-terms>услове сервиса</u-terms> и <u-policy>политику приватности</u-policy>';

  @override
  String get logInLabel => 'Пријави се';

  @override
  String get loginTerms =>
      'Кликом на пријаву, прихватам <u-terms>услове сервиса</u-terms> и <u-policy>политику приватности</u-policy>';

  @override
  String get changeEmail => 'Промени е-пошту';

  @override
  String get enterYourPassword => 'Унесите лозинку';

  @override
  String get welcomeBack => 'Добродошли назад!';

  @override
  String get contactSupport => 'Контактирати подршку';

  @override
  String get locationPickerTip =>
      'You can also add a location centered on a photo from the photo\'s info screen';

  @override
  String get incorrectPasswordTitle => 'Неисправна лозинка';

  @override
  String get pleaseTryAgain => 'Пробајте поново';

  @override
  String get recreatePasswordTitle => 'Рекреирај лозинку';

  @override
  String get useRecoveryKey => 'Користи кључ за опоравак';

  @override
  String get recreatePasswordBody =>
      'Тренутни уређај није довољно моћан да потврди вашу лозинку, али можемо регенерирати на начин који ради са свим уређајима.\n\nПријавите се помоћу кључа за опоравак и обновите своју лозинку (можете поново користити исту ако желите).';

  @override
  String get verifyPassword => 'Верификујте лозинку';

  @override
  String get recoveryKey => 'Кључ за опоравак';

  @override
  String get recoveryKeyOnForgotPassword =>
      'Ако заборавите лозинку, једини начин на који можете повратити податке је са овим кључем.';

  @override
  String get recoveryKeySaveDescription =>
      'Не чувамо овај кључ, молимо да сачувате кључ од 24 речи на сигурном месту.';

  @override
  String get doThisLater => 'Уради ово касније';

  @override
  String get saveKey => 'Сачувај кључ';

  @override
  String get recoveryKeyCopiedToClipboard =>
      'Кључ за опоравак је копиран у међуспремник';

  @override
  String get recoverAccount => 'Опоравак налога';

  @override
  String get recover => 'Опорави';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'Молимо Вас да пошаљете имејл на $supportEmail са Ваше регистроване адресе е-поште';
  }

  @override
  String get twofactorSetup => 'Постављање двофакторске аутентификације';

  @override
  String get enterCode => 'Унесите кôд';

  @override
  String get scanCode => 'Скенирајте кôд';

  @override
  String get codeCopiedToClipboard => 'Копирано у међуспремник';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      'Копирајте и налепите овај код \nу своју апликацију за аутентификацију';

  @override
  String get tapToCopy => 'питисните да копирате';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      'Скенирајте овај баркод \nсвојом апликацијом за аутентификацију';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      'Унесите 6-цифрени кôд из\nапликације за аутентификацију';

  @override
  String get confirm => 'Потврди';

  @override
  String get setupComplete => 'Постављање завршено';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready =>
      'Уколико већ нисте, сачувајте кључ за опоравак';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      'Може се користити за опоравак рачуна уколико заборавите други ниво провере идентитета';

  @override
  String get twofactorAuthenticationPageTitle => 'Двострука провера идентитета';

  @override
  String get lostDevice => 'Изгубили сте уређај?';

  @override
  String get verifyingRecoveryKey => 'Проверавам кључ за опоравак...';

  @override
  String get recoveryKeyVerified => 'Кључ за опоравак је потврђен';

  @override
  String get recoveryKeySuccessBody =>
      'Сјајно! Ваш кључ за опоравак је исправан. Хвала за потврду.\n\nНе заборавите да овај кључ чувате на сигурном месту.';

  @override
  String get invalidRecoveryKey =>
      'Кључ за опоравак који сте унели није исправан. Постарајте се да садржи 24 речи, и проверите да ли сте их правилно уписали.\n\nУколико сте унели стари формат кључа, постарајте се да садржи 64 карактера и додатно проверите да ли је сваки исправно уписан.';

  @override
  String get invalidKey => 'Неисправан кључ';

  @override
  String get tryAgain => 'Покушај поново';

  @override
  String get viewRecoveryKey => 'Погледај кључ за опоравак';

  @override
  String get confirmRecoveryKey => 'Потврди кључ за опоравак';

  @override
  String get recoveryKeyVerifyReason =>
      'Кључ за опоравак рачуна је једини начин да повратите фотографије ако заборавите лозинку. Можете га пронаћи под Подешавања  > Рачун.\n\nУнесите ваш кључ за опоравак рачуна како бисмо били сигурни да сте га правилно сачували.';

  @override
  String get confirmYourRecoveryKey => 'Потврдите кључ за опоравак';

  @override
  String get addViewer => 'Додај посматрача';

  @override
  String get addCollaborator => 'Додај сарадника';

  @override
  String get addANewEmail => 'Додај нови имејл';

  @override
  String get orPickAnExistingOne => 'Или изабери већ постојећи';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'Сарадници могу додати фотографије и клипове у заједнички албум.';

  @override
  String get enterEmail => 'Унеси имејл';

  @override
  String get albumOwner => 'Власник';

  @override
  String get you => 'Ти';

  @override
  String get collaborator => 'Сарадник';

  @override
  String get addMore => 'Додај још';

  @override
  String get viewer => 'Посматрач';

  @override
  String get remove => 'Уклони';

  @override
  String get removeParticipant => 'Уклони учесника';

  @override
  String get manage => 'Управљај';

  @override
  String get addedAs => 'Додат као';

  @override
  String get changePermissions => 'Измените дозволе?';

  @override
  String get yesConvertToViewer => 'Да, претвори у посматрача';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return '$user неће више моћи да додаје фотографије у овај албум\nИ даље ће моћи да уклони фотографије које је претходно додао';
  }

  @override
  String get allowAddingPhotos => 'Дозволи додавање фотографија';

  @override
  String get allowJoiningAlbum => 'Allow joining album';

  @override
  String get allowAddPhotosDescription =>
      'Дозволи људима са линком да додају фотографије у заједнички албум.';

  @override
  String get passwordLock => 'Закључај помоћу лозинке';

  @override
  String get canNotOpenTitle => 'Не могу да отворим овај албум';

  @override
  String get canNotOpenBody =>
      'Жао ми је, овај албум се не може отворити у апликацији.';

  @override
  String get disableDownloadWarningTitle => 'Молим, обратите пажњу';

  @override
  String get disableDownloadWarningBody =>
      'Људи и даље могу да направе снимак екрана или да скину ваше фотографије користећи друге апликације';

  @override
  String get allowDownloads => 'Дозволи преузимање';

  @override
  String get linkDeviceLimit => 'Device limit';

  @override
  String get noDeviceLimit => 'None';

  @override
  String get albumLayout => 'Album layout';

  @override
  String get layoutGrouped => 'Grouped';

  @override
  String get layoutContinuous => 'Continuous';

  @override
  String get layoutTrip => 'Trip';

  @override
  String get preview => 'Preview';

  @override
  String get linkExpiry => 'Рок важења линка';

  @override
  String get linkExpired => 'Истекао';

  @override
  String get linkEnabled => 'Омогућено';

  @override
  String get linkNeverExpires => 'Никада';

  @override
  String get expiredLinkInfo =>
      'Линк је истекао. Поставите ново време за престанак важности линка или онемогућите његово истицање.';

  @override
  String get setAPassword => 'Постави лозинку';

  @override
  String get lockButtonLabel => 'Закључај';

  @override
  String get enterPassword => 'Унеси лозинку';

  @override
  String get removeLink => 'Уклони везу';

  @override
  String get manageLink => 'Управљај везом';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'Веза ће истећи $expiryTime';
  }

  @override
  String get albumUpdated => 'Албум ажуриран';

  @override
  String get never => 'Никад';

  @override
  String get custom => 'Прилагођено';

  @override
  String get after1Hour => 'Након 1 сата';

  @override
  String get after1Day => 'Након 1 дана';

  @override
  String get after1Week => 'Након 1 недеље';

  @override
  String get after1Month => 'Након 1 месеца';

  @override
  String get after1Year => 'Након 1 године';

  @override
  String get manageParticipants => 'Управљај';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count учесника',
      one: '1 учесник',
      zero: 'Нека учесника',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'Креирајте везу која омогућава људима да додају и прегледају фотографије у вашем дељеном албуму без потребе за Енте апликацијом или налогом. Одлично за прикупљање фотографија са догађаја.';

  @override
  String get collectPhotos => 'Прикупи фотографије';

  @override
  String get collaborativeLink => 'Сарадничка веза';

  @override
  String get shareWithNonenteUsers =>
      'Пошаљи корисницима који немају Енте налог';

  @override
  String get createPublicLink => 'Креирај јавну везу';

  @override
  String get sendLink => 'Пошаљи везу';

  @override
  String get qrCode => 'QR Code';

  @override
  String get sendQrCode => 'Send QR code';

  @override
  String get copyLink => 'Копирај везу';

  @override
  String get copyEmbedHtml => 'Copy embed HTML';

  @override
  String get linkHasExpired => 'Веза је истекла';

  @override
  String get publicLinkEnabled => 'Јавна веза је укључена';

  @override
  String get shareALink => 'Подели везу';

  @override
  String get sharedAlbumSectionDescription =>
      'Креирај дељене и заједничке албуме са другим Енте корисницима, укључујући и оне на бесплатним плановима.';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: 'Подељено са $numberOfPeople особа',
      one: 'Подељено са 1 особом',
      zero: 'Подели са одређеним особама',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId => 'Ово је Ваш ИД за верификацију';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'Особе које деле албуме с тобом би требале да виде исти ИД на свом уређају.';

  @override
  String get howToViewShareeVerificationID =>
      'Молимо их да дуго притисну своју адресу е-поште на екрану за подешавања и провере да ли се ИД-ови на оба уређаја поклапају.';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'Ово је ИД за верификацију корисника $email';
  }

  @override
  String get verificationId => 'ИД за верификацију';

  @override
  String verifyEmailID({required Object email}) {
    return 'Верификуј $email';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return '$email нема Енте налог.\n\nПошаљи им позивницу за дељење фотографија.';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return 'Ево мог ИД-а за верификацију: $verificationID за ente.io.';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'Здраво, можеш ли да потврдиш да је ово твој ente.io ИД за верификацију: $verificationID';
  }

  @override
  String get somethingWentWrong => 'Нешто није у реду';

  @override
  String get sendInvite => 'Пошаљи позивницу';

  @override
  String get shareTextRecommendUsingEnte =>
      'Преузми Енте да бисмо лако делили фотографије и видео записе у оригиналном квалитету\n\nhttps://ente.io';

  @override
  String get done => 'Готово';

  @override
  String get applyCodeTitle => 'Примени кôд';

  @override
  String get enterCodeDescription =>
      'Унеси код који ти је дао пријатељ да бисте обоје добили бесплатан простор за складиштење';

  @override
  String get apply => 'Примени';

  @override
  String get failedToApplyCode => 'Грешка у примењивању кôда';

  @override
  String get enterReferralCode => 'Унеси реферални код';

  @override
  String get codeAppliedPageTitle => 'Кôд примењен';

  @override
  String get changeYourReferralCode => 'Промени свој реферални код';

  @override
  String get change => 'Измени';

  @override
  String get unavailableReferralCode => 'Жао нам је, овај кôд није доступан.';

  @override
  String get codeChangeLimitReached =>
      'Жао нам је, достигли сте максимум броја промена кôда.';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'Молимо вас да контактирате $familyAdminEmail да бисте променили свој код.';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB ГБ';
  }

  @override
  String get claimed => 'Освојено';

  @override
  String get details => 'Више детаља';

  @override
  String get claimMore => 'Освоји још!';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return 'Они ће такође добити $storageAmountInGB ГБ';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '$storageAmountInGB ГБ сваки пут када се неко претплати на неку од наших понуда и при том унесе ваш код';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'Ente referral code: $referralCode \n\nApply it in Settings → General → Referrals to get $referralStorageInGB GB free after you signup for a paid plan\n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => 'Освоји бесплатан простор на диску';

  @override
  String get inviteYourFriends => 'Позови своје пријатеље';

  @override
  String get failedToFetchReferralDetails =>
      'Unable to fetch referral details. Please try again later.';

  @override
  String get referralStep1 => '1. Дај овај код својим пријатељима';

  @override
  String get referralStep2 => '2. Они се претплате на понуду која се плаћа';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. Обоје добијате $storageInGB ГБ* бесплатно';
  }

  @override
  String get referralsAreCurrentlyPaused =>
      'Препоручивање је тренутно паузирано';

  @override
  String get youCanAtMaxDoubleYourStorage =>
      '* У најбољем случају можете удвостручити ваш простор';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true': 'Your family has claimed $storageAmountInGb GB so far',
      'false': 'You have claimed $storageAmountInGb GB so far',
      'other': 'You have claimed $storageAmountInGb GB so far!',
    });
    return '$_temp0';
  }

  @override
  String get faq => 'Честа питања';

  @override
  String get help => 'Помоћ';

  @override
  String get oopsSomethingWentWrong => 'Упс, дошло је до грешке';

  @override
  String get peopleUsingYourCode => 'Људи који користе ваш позивни код';

  @override
  String get eligible => 'eligible';

  @override
  String get total => 'укупно';

  @override
  String get codeUsedByYou => 'Код који ви користите';

  @override
  String get freeStorageClaimed => 'Освојен бесплатан простор';

  @override
  String get freeStorageUsable =>
      'Бесплатан простор који је могуће искористити';

  @override
  String get usableReferralStorageInfo =>
      'Usable storage is limited by your current plan. Excess claimed storage will automatically become usable when you upgrade your plan.';

  @override
  String get removeFromAlbumTitle => 'Уклони из албума?';

  @override
  String get removeFromAlbum => 'Уклони из албума';

  @override
  String get itemsWillBeRemovedFromAlbum =>
      'Изабране ставке ће бити уклоњене из овог албума';

  @override
  String get removeShareItemsWarning =>
      'Selected photos will not be accessible to any viewer of this album, except the photo owners.';

  @override
  String get addingToFavorites => 'Додајем у омиљене';

  @override
  String get removingFromFavorites => 'Уклањам из омиљених';

  @override
  String get sorryCouldNotAddToFavorites => 'Извини, није додато у омиљене!';

  @override
  String get sorryCouldNotRemoveFromFavorites =>
      'Извини, није уклоњено из омиљених!';

  @override
  String get subscribeToEnableSharing =>
      'You need an active paid subscription to enable sharing.';

  @override
  String get subscribe => 'Претплати се';

  @override
  String get canOnlyRemoveFilesOwnedByYou =>
      'Can only remove files owned by you';

  @override
  String get deleteSharedAlbum => 'Иѕбриши дељени албум?';

  @override
  String get deleteAlbum => 'Избриши албум';

  @override
  String get deleteAlbumDialog =>
      'Also delete the photos (and videos) present in this album from <bold>all</bold> other albums they are part of?';

  @override
  String get deleteSharedAlbumDialogBody => 'Албум ће бити обрисан за све';

  @override
  String get yesRemove => 'Да, уклони';

  @override
  String get creatingLink => 'Креирам линк...';

  @override
  String get removeWithQuestionMark => 'Уклони?';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return '$userEmail ће бити уклоњен из овог дељеног албума.\n\nСве фотографије које су они додали ће такође бити уклоњене';
  }

  @override
  String get keepPhotos => 'Задржи фотографије';

  @override
  String get deletePhotos => 'Обриши фотгорафије';

  @override
  String get inviteToEnte => 'Позови у Енте';

  @override
  String get removePublicLink => 'Remove public link';

  @override
  String disableLinkMessage({required Object albumName}) {
    return 'Ово ће уклонити јавни линк за приступ \"$albumName\".';
  }

  @override
  String get sharing => 'Делим...';

  @override
  String get youCannotShareWithYourself => 'Не можеш делити сам са собом';

  @override
  String get archive => 'Архивирај';

  @override
  String get createAlbumActionHint =>
      'Дуго притисните да бисте изабрали фотографије и кликните на + да бисте направили албум';

  @override
  String get importing => 'Увоз....';

  @override
  String get failedToLoadAlbums => 'Грешка при учитавању албума';

  @override
  String get hidden => 'Скривено';

  @override
  String get authToViewYourHiddenFiles =>
      'Молимо вас да се аутентификујете да бисте видели скривене датотеке';

  @override
  String get authToViewTrashedFiles =>
      'Молимо вас да се аутентификујете да бисте видели датотеке у отпаду';

  @override
  String get trash => 'Смеће';

  @override
  String get uncategorized => 'Некатегоризовано';

  @override
  String get videoSmallCase => 'видео';

  @override
  String get photoSmallCase => 'слика';

  @override
  String get singleFileDeleteHighlight => 'Биће обрисано из свих албума.';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return 'Овај $fileType се налази и у Енте-у и на Вашем уређају.';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return 'Овај $fileType ће бити избрисан из Енте-а.';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return 'Овај $fileType ће бити избрисан са твог уређаја.';
  }

  @override
  String get deleteFromEnte => 'Обриши са Енте-а';

  @override
  String get yesDelete => 'Да, обриши';

  @override
  String get movedToTrash => 'Премештено у смеће';

  @override
  String get deleteFromDevice => 'Обриши са уређаја';

  @override
  String get deleteFromBoth => 'Обриши са оба';

  @override
  String get newAlbum => 'Нови албум';

  @override
  String get albums => 'Албуми';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount сећања',
      one: '$formattedCount сећање',
      zero: 'нема сећања',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return '$count изабрано';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return '$count изабрано ($yourCount Ваше)';
  }

  @override
  String get advancedSettings => 'Напредно';

  @override
  String get photoGridSize => 'Величина мреже за приказ фотографија';

  @override
  String get manageDeviceStorage => 'Управљај кеш меморијом уређаја';

  @override
  String get manageDeviceStorageDesc =>
      'Прегледај и очисти локалну кеш меморију.';

  @override
  String get machineLearning => 'Машинско учење';

  @override
  String get mlConsent => 'Омогући машинско учење';

  @override
  String get mlConsentTitle => 'Омогући машинско учење?';

  @override
  String get mlConsentDescription =>
      'If you enable machine learning, Ente will extract information like face geometry from files, including those shared with you.\n\nThis will happen on your device, and any generated biometric information will be end-to-end encrypted.';

  @override
  String get mlConsentPrivacy =>
      'Кликните како бисте сазнали више о овоме у нашим правилима приватности';

  @override
  String get mlConsentConfirmation =>
      'Разумем, и желим да укључим машинско учење';

  @override
  String get magicSearch => 'Магична претрага';

  @override
  String get discover => 'Истражи';

  @override
  String get discover_identity => 'Идентитет';

  @override
  String get discover_screenshots => 'Снимци екрана';

  @override
  String get discover_receipts => 'Признанице';

  @override
  String get discover_notes => 'Белешке';

  @override
  String get discover_memes => 'Мимови';

  @override
  String get discover_visiting_cards => 'Разгледнице';

  @override
  String get discover_babies => 'Бебе';

  @override
  String get discover_pets => 'Љубимци';

  @override
  String get discover_selfies => 'Селфији';

  @override
  String get discover_wallpapers => 'Позадине';

  @override
  String get discover_food => 'Храна';

  @override
  String get discover_celebrations => 'Прославе';

  @override
  String get discover_sunset => 'Заласци сунца';

  @override
  String get discover_hills => 'Брда';

  @override
  String get discover_greenery => 'Зеленило';

  @override
  String get mlIndexingDescription =>
      'Please note that machine learning will result in a higher bandwidth and battery usage until all items are indexed. Consider using the desktop app for faster indexing, all results will be synced automatically.';

  @override
  String get loadingModel => 'Downloading models...';

  @override
  String get waitingForWifi => 'Чекам на бежичну мрежу...';

  @override
  String get status => 'Статус';

  @override
  String get indexedItems => 'Индексиране ставке';

  @override
  String get pendingItems => 'На чекању';

  @override
  String get clearIndexes => 'Очисти индексе';

  @override
  String get selectFoldersForBackup => 'Изабери фолдере за копирање';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      'Иѕабрани фолдери ће бити енкриптовани и сигурно похрањени';

  @override
  String get unselectAll => 'Деселектуј све';

  @override
  String get selectAll => 'Означи све';

  @override
  String get skip => 'Прескочи';

  @override
  String get updatingFolderSelection => 'Освежавам избор фолдера...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count items',
      one: '$count item',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Delete $count items',
      one: 'Delete $count item',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count фајлова, $formattedSize сваки';
  }

  @override
  String get showMemories => 'Прикажи успомене';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count година уназад',
      few: '$count године уназад',
      one: '$count година уназад',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'Backup settings';

  @override
  String get backupStatus => 'Статус резервних копија';

  @override
  String get backupStatusDescription =>
      'Items that have been backed up will show up here';

  @override
  String get backupOverMobileData => 'Копирај користећи мобилни интернет';

  @override
  String get backupVideos => 'Копирај видео снимке';

  @override
  String get disableAutoLock => 'Онемогући закључавање екрана';

  @override
  String get deviceLockExplanation =>
      'Disable the device screen lock when Ente is in the foreground and there is a backup in progress. This is normally not needed, but may help big uploads and initial imports of large libraries complete faster.';

  @override
  String get about => 'О нама';

  @override
  String get weAreOpenSource => 'We are open source!';

  @override
  String get privacy => 'Приватност';

  @override
  String get terms => 'Услови';

  @override
  String get checkForUpdates => 'Провери да ли постоје новине';

  @override
  String get checkStatus => 'Провери статус';

  @override
  String get checking => 'Проверавам...';

  @override
  String get youAreOnTheLatestVersion => 'Користите најновију верзију';

  @override
  String get account => 'Рачун';

  @override
  String get manageSubscription => 'Управљај претплатом';

  @override
  String get authToChangeYourEmail =>
      'Please authenticate to change your email';

  @override
  String get changePassword => 'Измени лозинку';

  @override
  String get authToChangeYourPassword =>
      'Потврдите идентитет како бисте променили лозинку';

  @override
  String get emailVerificationToggle => 'Провера имејла';

  @override
  String get authToChangeEmailVerificationSetting =>
      'Please authenticate to change email verification';

  @override
  String get exportYourData => 'Извези своје податке';

  @override
  String get logout => 'Одјави се';

  @override
  String get authToInitiateAccountDeletion =>
      'Потврдите идентитет како бисте покренули брисање рачуна';

  @override
  String get areYouSureYouWantToLogout =>
      'Да ли сигурно желите да се одјавите?';

  @override
  String get yesLogout => 'Да, одјави ме';

  @override
  String get aNewVersionOfEnteIsAvailable => 'Нова Енте верзија је доступна.';

  @override
  String get update => 'Ажурирај';

  @override
  String get installManually => 'Инсталирај ручно';

  @override
  String get criticalUpdateAvailable => 'Критично ажурирање је доступно';

  @override
  String get updateAvailable => 'Ажурирање доступно';

  @override
  String get ignoreUpdate => 'Игнориши';

  @override
  String get downloading => 'Downloading...';

  @override
  String get cannotDeleteSharedFiles => 'Не могу да обришем дељене фајлове';

  @override
  String get theDownloadCouldNotBeCompleted =>
      'The download could not be completed';

  @override
  String get retry => 'Покушај поново';

  @override
  String get backedUpFolders => 'Backed up folders';

  @override
  String get backup => 'Backup';

  @override
  String get freeUpDeviceSpace => 'Ослободи простор на уређају';

  @override
  String get freeUpDeviceSpaceDesc =>
      'Save space on your device by clearing files that have been already backed up.';

  @override
  String get allClear => '✨ Све је чисто';

  @override
  String get noDeviceThatCanBeDeleted =>
      'Не постоје фајлови на овом уређају који би могли бити обрисани';

  @override
  String get removeDuplicates => 'Уклони дупликате';

  @override
  String get removeDuplicatesDesc =>
      'Прегледај и уклони фајлове који су дупликати.';

  @override
  String get viewLargeFiles => 'Велики фајлови';

  @override
  String get viewLargeFilesDesc =>
      'Погледај фајлове који заузимају највише простора.';

  @override
  String get noDuplicates => '✨ Нема дупликата';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared =>
      'Немаш дупликата које бисмо могли да обришемо';

  @override
  String get success => 'Success';

  @override
  String get rateUs => 'Оцени нас';

  @override
  String get remindToEmptyDeviceTrash =>
      'Also empty \"Recently Deleted\" from \"Settings\" -> \"Storage\" to claim the freed space';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return 'Успешно сте ослободили $storageSaved!';
  }

  @override
  String get remindToEmptyEnteTrash =>
      'Also empty your \"Trash\" to claim the freed up space';

  @override
  String get sparkleSuccess => '✨ Success';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count дупликата',
      few: '$count дупликата',
      one: '$count дупликат',
    );
    return 'Обрисали сте $_temp0, ослобађам ($storageSaved!)';
  }

  @override
  String get familyPlans => 'Породичне понуде';

  @override
  String get referrals => 'Препоруке';

  @override
  String get notifications => 'Обавештења';

  @override
  String get sharedPhotoNotifications => 'Нове дељене фотографије';

  @override
  String get sharedPhotoNotificationsExplanation =>
      'Добиј обавештење када неко дода фотографију у албум у којем ви учествујете';

  @override
  String get advanced => 'Напредно';

  @override
  String get general => 'Опште';

  @override
  String get security => 'Сигурност';

  @override
  String get authToViewYourRecoveryKey =>
      'Please authenticate to view your recovery key';

  @override
  String get twofactor => 'Two-factor';

  @override
  String get authToConfigureTwofactorAuthentication =>
      'Please authenticate to configure two-factor authentication';

  @override
  String get lockscreen => 'Lockscreen';

  @override
  String get authToChangeLockscreenSetting =>
      'Please authenticate to change lockscreen setting';

  @override
  String get viewActiveSessions => 'View active sessions';

  @override
  String get authToViewYourActiveSessions =>
      'Please authenticate to view your active sessions';

  @override
  String get disableTwofactor => 'Disable two-factor';

  @override
  String get confirm2FADisable =>
      'Are you sure you want to disable two-factor authentication?';

  @override
  String get no => 'Не';

  @override
  String get yes => 'Да';

  @override
  String get social => 'Social';

  @override
  String rateUsOnStore({required Object storeName}) {
    return 'Оцени нас на $storeName';
  }

  @override
  String get blog => 'Блог';

  @override
  String get merchandise => 'Роба';

  @override
  String get twitter => 'Твитер';

  @override
  String get mastodon => 'Мастодон';

  @override
  String get matrix => 'Матрикс';

  @override
  String get discord => 'Дискорд';

  @override
  String get reddit => 'Редит';

  @override
  String get yourStorageDetailsCouldNotBeFetched =>
      'Подаци о вашем простору на диску нису могли бити освежени';

  @override
  String get reportABug => 'Пријави грешку';

  @override
  String get reportBug => 'Пријави грешку';

  @override
  String get suggestFeatures => 'Предложи нову функционалност';

  @override
  String get support => 'Подршка';

  @override
  String get theme => 'Тема';

  @override
  String get lightTheme => 'Светла';

  @override
  String get darkTheme => 'Тамна';

  @override
  String get systemTheme => 'Системска';

  @override
  String get freeTrial => 'Бесплатна проба';

  @override
  String get selectYourPlan => 'Изабери пакет';

  @override
  String get enteSubscriptionPitch =>
      'Енте чува твоје успомене тако да су увек са тобом, чак и ако изгубиш уређај.';

  @override
  String get enteSubscriptionShareWithFamily =>
      'Можеш додати и породицу у оквиру овог пакета.';

  @override
  String get currentUsageIs => 'Тренутно искоришћено';

  @override
  String get faqs => 'Често постављана питања';

  @override
  String renewsOn({required Object endDate}) {
    return 'Претплата се обнавља $endDate';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return 'Бесплатан пробни период важи до $endDate';
  }

  @override
  String validTill({required Object endDate}) {
    return 'Важи до $endDate';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return 'Ваш $storageAmount додатак важи до $endDate';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return 'Бесплатни пробни период важи до $endDate.\nМожете изабрати неки од планова након тога.';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'Ваша претплата ће бити отказана $endDate';
  }

  @override
  String get subscription => 'Претплата';

  @override
  String get paymentDetails => 'Детаљи плаћања';

  @override
  String get manageFamily => 'Управљај породицом';

  @override
  String contactToManageSubscription({required Object provider}) {
    return 'Please contact us at support@ente.io to manage your $provider subscription.';
  }

  @override
  String get renewSubscription => 'Однови претплату';

  @override
  String get cancelSubscription => 'Откажи претплату';

  @override
  String get areYouSureYouWantToRenew =>
      'Да ли сте сигурни да желите да обновите претплату?';

  @override
  String get yesRenew => 'Да, обнови претплату';

  @override
  String get areYouSureYouWantToCancel =>
      'Да ли сте сигурни да желите да откажете?';

  @override
  String get yesCancel => 'Да, откажи';

  @override
  String get failedToRenew => 'Failed to renew';

  @override
  String get failedToCancel => 'Неуспешно отказивање';

  @override
  String get twoMonthsFreeOnYearlyPlans =>
      '2 месеца гратис уз годишњу претплату';

  @override
  String get monthly => 'Месечно';

  @override
  String get yearly => 'Годишње';

  @override
  String get confirmPlanChange => 'Потврди промену пакета';

  @override
  String get areYouSureYouWantToChangeYourPlan =>
      'Да ли сигурно желиш да промениш пакет?';

  @override
  String get youCannotDowngradeToThisPlan => 'Не можете изабрати овај пакет';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'Молимо, прво откажите претплау на $paymentProvider';
  }

  @override
  String get optionalAsShortAsYouLike => 'Опционо, коико год кратко желите...';

  @override
  String get send => 'Пошаљи';

  @override
  String get askCancelReason =>
      'Отказали сте претплату. Да ли бисте нам рекли разлог?';

  @override
  String get thankYouForSubscribing => 'Хвала што сте се претплатили!';

  @override
  String get yourPurchaseWasSuccessful => 'Куповина успешно закључена';

  @override
  String get yourPlanWasSuccessfullyUpgraded =>
      'Успешно сте прешли на јачи пакет';

  @override
  String get yourPlanWasSuccessfullyDowngraded =>
      'Успешно сте прешли на слабији пакет';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully =>
      'Претплата успешно ажурирана';

  @override
  String get googlePlayId => 'Гугл плеј идентификација';

  @override
  String get appleId => 'Епл идентификација';

  @override
  String get playstoreSubscription => 'Претплата путем Гугл продавнице';

  @override
  String get appstoreSubscription => 'Претплата путем Епл продавнице';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return 'Your $id is already linked to another Ente account.\nIf you would like to use your $id with this account, please contact our support\'\'';
  }

  @override
  String get visitWebToManage =>
      'Претплатом можете управљати на страници web.ente.io';

  @override
  String get couldNotUpdateSubscription => 'Неуспешно ажурирање претплате';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      'Контактирајте подршку на support@ente.io и радо ћемо вам помоћи!';

  @override
  String get paymentFailed => 'Неуспела уплата';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return 'Please talk to $providerName support if you were charged';
  }

  @override
  String get continueOnFreeTrial => 'Настави бесплатни пробни период';

  @override
  String get areYouSureYouWantToExit => 'Сигурно желите да изађете?';

  @override
  String get thankYou => 'Хвала вам';

  @override
  String get failedToVerifyPaymentStatus => 'Failed to verify payment status';

  @override
  String get pleaseWaitForSometimeBeforeRetrying =>
      'Мало сачекајте пре него што покушате поново';

  @override
  String get paymentFailedMessage =>
      'Unfortunately your payment failed. Please contact support and we\'ll help you out!';

  @override
  String get youAreOnAFamilyPlan => 'Ви сте на породичном пакету!';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'Please contact <green>$familyAdminEmail</green> to manage your subscription';
  }

  @override
  String get leaveFamily => 'Напусти породицу';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily =>
      'Да ли заиста желиш да напустиш породични пакет?';

  @override
  String get leave => 'Напусти';

  @override
  String get rateTheApp => 'Оцените апликацију';

  @override
  String get startBackup => 'Започни сигурносно копирање';

  @override
  String get noPhotosAreBeingBackedUpRightNow =>
      'No photos are being backed up right now';

  @override
  String get preserveMore => 'Сачувај још';

  @override
  String get grantFullAccessPrompt =>
      'Дозволите приступ свим фотографијама у подешавањима уређаја';

  @override
  String get allowPermTitle => 'Дозволи приступ фотографијама';

  @override
  String get allowPermBody =>
      'Please allow access to your photos from Settings so Ente can display and backup your library.';

  @override
  String get openSettings => 'Отвори подешавања';

  @override
  String get selectMorePhotos => 'Изабери још фотографија';

  @override
  String get existingUser => 'Постојећи корисник';

  @override
  String get privateBackups => 'Приватни бекапи';

  @override
  String get forYourMemories => 'за твоје успомене';

  @override
  String get endtoendEncryptedByDefault => 'End-to-end encrypted by default';

  @override
  String get safelyStored => 'Сигурно похрањено';

  @override
  String get atAFalloutShelter => 'у подземном бункеру';

  @override
  String get designedToOutlive => 'Направљено да надживи';

  @override
  String get available => 'Доступно';

  @override
  String get everywhere => 'свуда';

  @override
  String get androidIosWebDesktop => 'Android, iOS, Web, Desktop';

  @override
  String get mobileWebDesktop => 'Mobile, Web, Desktop';

  @override
  String get newToEnte => 'Нови на Енте';

  @override
  String get pleaseLoginAgain => 'Молимо, улогујте се поново';

  @override
  String get autoLogoutMessage =>
      'Излоговани сте услед техничке грешке. Извињавамо се за непријатност.';

  @override
  String get yourSubscriptionHasExpired => 'Ваша претплата је истекла';

  @override
  String get storageLimitExceeded => 'Расположив простор је прекорачен';

  @override
  String get upgrade => 'Ажурирај';

  @override
  String get raiseTicket => 'Пошаљи упит';

  @override
  String get backupFailed => 'Неуспешна израда резервне копије';

  @override
  String get sorryBackupFailedDesc =>
      'Извините, нисмо успели да копирамо овај фајл тренутно. Покушаћемо касније.';

  @override
  String get couldNotBackUpTryLater =>
      'Нисмо могли да бекапујемо ваше податке.\nПокушаћемо касније.';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      'Енте може да екриптује и сачува фајлове једино ако дозволите приступ њима';

  @override
  String get pleaseGrantPermissions => 'Молимо, дозволите приступ';

  @override
  String get grantPermission => 'Дозволите приступ';

  @override
  String get privateSharing => 'Приватно дељење';

  @override
  String get shareOnlyWithThePeopleYouWant =>
      'Дели само са људима са којима желиш';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      'Користи јавне линкове за људима који нису на Енте';

  @override
  String get allowPeopleToAddPhotos => 'Дозволи људима да додају фотографије';

  @override
  String get shareAnAlbumNow => 'Подели албум сада';

  @override
  String get collectEventPhotos => 'Прикупи фотографије са догађаја';

  @override
  String get sessionExpired => 'Session expired';

  @override
  String get loggingOut => 'Logging out...';

  @override
  String get onDevice => 'На уређају';

  @override
  String get onEnte => 'У Енте';

  @override
  String get name => 'Име';

  @override
  String get newest => 'Најновије';

  @override
  String get lastUpdated => 'Последње ажурирано';

  @override
  String get deleteEmptyAlbums => 'Избриши празне албуме';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => 'Обриши празне албуме?';

  @override
  String get deleteAlbumsDialogBody =>
      'This will delete all empty albums. This is useful when you want to reduce the clutter in your album list.';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return 'Deleting $currentlyDeleting / $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return 'Processing $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => 'Трајно избриши';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou =>
      'Можете направити линк само за фајлове који су ваше власништво';

  @override
  String get publicLinkCreated => 'Public link created';

  @override
  String get youCanManageYourLinksInTheShareTab =>
      'You can manage your links in the share tab.';

  @override
  String get linkCopiedToClipboard => 'Линк је копиран у меморију';

  @override
  String get restore => 'Поврати';

  @override
  String get moveToAlbum => 'Премести у албум';

  @override
  String get unhide => 'Unhide';

  @override
  String get unarchive => 'Врати из архиве';

  @override
  String get favorite => 'Favorite';

  @override
  String get removeFromFavorite => 'Remove from favorites';

  @override
  String get shareLink => 'Share link';

  @override
  String get createCollage => 'Направи колаж';

  @override
  String get saveCollage => 'Сачувај колаж';

  @override
  String get collageSaved => 'Collage saved to gallery';

  @override
  String get collageLayout => 'Layout';

  @override
  String get addToEnte => 'Додај у Енте';

  @override
  String get addToAlbum => 'Додај у албум';

  @override
  String get delete => 'Обриши';

  @override
  String get hide => 'Сакриј';

  @override
  String get share => 'Подели';

  @override
  String get unhideToAlbum => 'Unhide to album';

  @override
  String get restoreToAlbum => 'Restore to album';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Move items',
      one: 'Move item',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add items',
      one: 'Add item',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'Create or select album';

  @override
  String get selectAlbum => 'Select album';

  @override
  String get searchByAlbumNameHint => 'Име албума';

  @override
  String get albumTitle => 'Наслов албума';

  @override
  String get enterAlbumName => 'Унесите име албума';

  @override
  String get restoringFiles => 'Restoring files...';

  @override
  String get movingFilesToAlbum => 'Премештам фајлове у албум...';

  @override
  String get unhidingFilesToAlbum => 'Unhiding files to album';

  @override
  String get canNotUploadToAlbumsOwnedByOthers =>
      'Can not upload to albums owned by others';

  @override
  String get uploadingFilesToAlbum => 'Uploading files to album...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return 'Успешно додато у $albumName';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return 'Успешно премештено у $albumName';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'Овај албум већ има линк за сарадњу';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return 'Линк за сарадњу креиран за $albumName';
  }

  @override
  String get askYourLovedOnesToShare => 'Замолите ваше вољене да деле';

  @override
  String get invite => 'Позови';

  @override
  String get shareYourFirstAlbum => 'Подели твој први албум';

  @override
  String sharedWith({required Object emailIDs}) {
    return 'Подељено са $emailIDs';
  }

  @override
  String get sharedWithMe => 'Подељено са мном';

  @override
  String get sharedByMe => 'Ја поделио';

  @override
  String get doubleYourStorage => 'Удвостручи простор';

  @override
  String get referFriendsAnd2xYourPlan =>
      'Препоручи пријатељима и удвостручи тренутни пакет';

  @override
  String get shareAlbumHint =>
      'Open an album and tap the share button on the top right to share.';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      'Items show the number of days remaining before permanent deletion';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count days',
      one: '1 day',
      zero: 'Soon',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => 'Delete All';

  @override
  String get renameAlbum => 'Rename album';

  @override
  String get convertToAlbum => 'Convert to album';

  @override
  String get setCover => 'Set cover';

  @override
  String get sortAlbumsBy => 'Sort by';

  @override
  String get sortNewestFirst => 'Newest first';

  @override
  String get sortOldestFirst => 'Oldest first';

  @override
  String get rename => 'Преименуј';

  @override
  String get leaveSharedAlbum => 'Leave shared album?';

  @override
  String get leaveAlbum => 'Leave album';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'Photos added by you will be removed from the album';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted =>
      'You\'ve no files in this album that can be deleted';

  @override
  String get youDontHaveAnyArchivedItems =>
      'You don\'t have any archived items.';

  @override
  String get ignoredFolderUploadReason =>
      'Some files in this album are ignored from upload because they had previously been deleted from Ente.';

  @override
  String get resetIgnoredFiles => 'Reset ignored files';

  @override
  String get deviceFilesAutoUploading =>
      'Files added to this device album will automatically get uploaded to Ente.';

  @override
  String get turnOnBackupForAutoUpload =>
      'Turn on backup to automatically upload files added to this device folder to Ente.';

  @override
  String get noHiddenPhotosOrVideos => 'No hidden photos or videos';

  @override
  String get toHideAPhotoOrVideo => 'To hide a photo or video';

  @override
  String get openTheItem => '• Open the item';

  @override
  String get clickOnTheOverflowMenu => '• Click on the overflow menu';

  @override
  String get click => '• Click';

  @override
  String get nothingToSeeHere => 'Nothing to see here! 👀';

  @override
  String get unarchiveAlbum => 'Unarchive album';

  @override
  String get archiveAlbum => 'Archive album';

  @override
  String get calculating => 'Calculating...';

  @override
  String get pleaseWaitDeletingAlbum => 'Please wait, deleting album';

  @override
  String get searchByExamples =>
      '• Album names (e.g. \"Camera\")\n• Types of files (e.g. \"Videos\", \".gif\")\n• Years and months (e.g. \"2022\", \"January\")\n• Holidays (e.g. \"Christmas\")\n• Photo descriptions (e.g. “#fun”)';

  @override
  String get youCanTrySearchingForADifferentQuery =>
      'You can try searching for a different query.';

  @override
  String get noResultsFound => 'No results found';

  @override
  String addedBy({required Object emailOrName}) {
    return 'Added by $emailOrName';
  }

  @override
  String get loadingExifData => 'Loading EXIF data...';

  @override
  String get viewAllExifData => 'View all EXIF data';

  @override
  String get noExifData => 'No EXIF data';

  @override
  String get thisImageHasNoExifData => 'This image has no exif data';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => 'No results';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'We don\'t support editing photos and albums that you don\'t own yet';

  @override
  String get failedToFetchOriginalForEdit =>
      'Failed to fetch original for edit';

  @override
  String get close => 'Close';

  @override
  String get setAs => 'Set as';

  @override
  String get fileSavedToGallery => 'File saved to gallery';

  @override
  String get filesSavedToGallery => 'Files saved to gallery';

  @override
  String get fileFailedToSaveToGallery => 'Failed to save file to gallery';

  @override
  String get download => 'Download';

  @override
  String get pressAndHoldToPlayVideo => 'Press and hold to play video';

  @override
  String get pressAndHoldToPlayVideoDetailed =>
      'Press and hold on the image to  play video';

  @override
  String get downloadFailed => 'Download failed';

  @override
  String get deduplicateFiles => 'Deduplicate Files';

  @override
  String get deselectAll => 'Deselect all';

  @override
  String get reviewDeduplicateItems =>
      'Please review and delete the items you believe are duplicates.';

  @override
  String get clubByCaptureTime => 'Club by capture time';

  @override
  String get clubByFileName => 'Club by file name';

  @override
  String get count => 'Count';

  @override
  String get totalSize => 'Total size';

  @override
  String get longpressOnAnItemToViewInFullscreen =>
      'Long-press on an item to view in full-screen';

  @override
  String get decryptingVideo => 'Decrypting video...';

  @override
  String get authToViewYourMemories =>
      'Please authenticate to view your memories';

  @override
  String get unlock => 'Unlock';

  @override
  String get freeUpSpace => 'Free up space';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'They can be deleted from the device to free up $formattedSize',
      one: 'It can be deleted from the device to free up $formattedSize',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber files',
      one: '1 file',
    );
    return '$_temp0 in this album has been backed up safely';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber files',
      one: '1 file',
    );
    return '$_temp0 on this device have been backed up safely';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'them',
      one: 'it',
    );
    return 'You can still access $_temp0 on Ente as long as you have an active subscription';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return 'Free up $sizeInMBorGB';
  }

  @override
  String get thisEmailIsAlreadyInUse => 'Имејл је већ у употреби';

  @override
  String get incorrectCode => 'Incorrect code';

  @override
  String get authenticationFailedPleaseTryAgain =>
      'Authentication failed, please try again';

  @override
  String get verificationFailedPleaseTryAgain =>
      'Verification failed, please try again';

  @override
  String get authenticating => 'Authenticating...';

  @override
  String get authenticationSuccessful => 'Authentication successful!';

  @override
  String get incorrectRecoveryKey => 'Incorrect recovery key';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect =>
      'The recovery key you entered is incorrect';

  @override
  String get twofactorAuthenticationSuccessfullyReset =>
      'Two-factor authentication successfully reset';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered =>
      'Please verify the code you have entered';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      'Please contact support if the problem persists';

  @override
  String get twofactorAuthenticationHasBeenDisabled =>
      'Two-factor authentication has been disabled';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect =>
      'Sorry, the code you\'ve entered is incorrect';

  @override
  String get yourVerificationCodeHasExpired =>
      'Ваш код ѕа верификацију је истекао';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'Имејл промењен у $newEmail';
  }

  @override
  String get verifying => 'Verifying...';

  @override
  String get disablingTwofactorAuthentication =>
      'Disabling two-factor authentication...';

  @override
  String get allMemoriesPreserved => 'Све успомене су сачуване';

  @override
  String get loadingGallery => 'Учитавам галерију';

  @override
  String get syncing => 'Синхронизујем...';

  @override
  String get encryptingBackup => 'Encrypting backup...';

  @override
  String get syncStopped => 'Синхронизација прекинута';

  @override
  String syncProgress({required String completed, required String total}) {
    return '$completed/$total memories preserved';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return 'Preserving $count memories...';
  }

  @override
  String get uploadingSingleMemory => 'Preserving 1 memory...';

  @override
  String get archiving => 'Архивирам...';

  @override
  String get unarchiving => 'Премештам из архиве...';

  @override
  String get successfullyArchived => 'Успешно архивирано';

  @override
  String get successfullyUnarchived => 'Успешно премештено из архиве';

  @override
  String get renameFile => 'Преименуј фајл';

  @override
  String get enterFileName => 'Именуј фајл';

  @override
  String get filesDeleted => 'Обрисани фајлови';

  @override
  String get selectedFilesAreNotOnEnte => 'Selected files are not on Ente';

  @override
  String get thisActionCannotBeUndone => 'This action cannot be undone';

  @override
  String get emptyTrash => 'Empty trash?';

  @override
  String get permDeleteWarning =>
      'All items in trash will be permanently deleted\n\nThis action cannot be undone';

  @override
  String get empty => 'Empty';

  @override
  String get couldNotFreeUpSpace => 'Could not free up space';

  @override
  String get permanentlyDeleteFromDevice => 'Трајно обриши са уређаја?';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      'Some of the files you are trying to delete are only available on your device and cannot be recovered if deleted';

  @override
  String get theyWillBeDeletedFromAllAlbums =>
      'They will be deleted from all albums.';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'Some items are in both Ente and your device.';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      'Selected items will be deleted from all albums and moved to trash.';

  @override
  String get theseItemsWillBeDeletedFromYourDevice =>
      'These items will be deleted from your device.';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      'It looks like something went wrong. Please retry after some time. If the error persists, please contact our support team.';

  @override
  String get error => 'Error';

  @override
  String get tempErrorContactSupportIfPersists =>
      'It looks like something went wrong. Please retry after some time. If the error persists, please contact our support team.';

  @override
  String get networkHostLookUpErr =>
      'Unable to connect to Ente, please check your network settings and contact support if the error persists.';

  @override
  String get networkConnectionRefusedErr =>
      'Unable to connect to Ente, please retry after sometime. If the error persists, please contact support.';

  @override
  String get cachedData => 'Cached data';

  @override
  String get clearCaches => 'Clear caches';

  @override
  String get remoteImages => 'Remote images';

  @override
  String get remoteVideos => 'Remote videos';

  @override
  String get remoteThumbnails => 'Remote thumbnails';

  @override
  String get pendingSync => 'Pending sync';

  @override
  String get localGallery => 'Local gallery';

  @override
  String get todaysLogs => 'Today\'s logs';

  @override
  String get viewLogs => 'View logs';

  @override
  String get logsDialogBody =>
      'This will send across logs to help us debug your issue. Please note that file names will be included to help track issues with specific files.';

  @override
  String get preparingLogs => 'Preparing logs...';

  @override
  String get emailYourLogs => 'Email your logs';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'Please send the logs to \n$toEmail';
  }

  @override
  String get copyEmailAddress => 'Copy email address';

  @override
  String get exportLogs => 'Export logs';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return 'Please email us at $toEmail';
  }

  @override
  String get dismiss => 'Dismiss';

  @override
  String get didYouKnow => 'Did you know?';

  @override
  String get loadingMessage => 'Loading your photos...';

  @override
  String get loadMessage1 => 'You can share your subscription with your family';

  @override
  String get loadMessage2 =>
      'We have preserved over 200 million memories so far';

  @override
  String get loadMessage3 =>
      'We keep 3 copies of your data, one in an underground fallout shelter';

  @override
  String get loadMessage4 => 'All our apps are open source';

  @override
  String get loadMessage5 =>
      'Our source code and cryptography have been externally audited';

  @override
  String get loadMessage6 =>
      'You can share links to your albums with your loved ones';

  @override
  String get loadMessage7 =>
      'Our mobile apps run in the background to encrypt and backup any new photos you click';

  @override
  String get loadMessage8 => 'web.ente.io has a slick uploader';

  @override
  String get loadMessage9 =>
      'We use Xchacha20Poly1305 to safely encrypt your data';

  @override
  String get photoDescriptions => 'Photo descriptions';

  @override
  String get fileTypesAndNames => 'File types and names';

  @override
  String get location => 'Location';

  @override
  String get moments => 'Moments';

  @override
  String get searchFaceEmptySection =>
      'People will be shown here once indexing is done';

  @override
  String get searchDatesEmptySection => 'Search by a date, month or year';

  @override
  String get searchLocationEmptySection =>
      'Group photos that are taken within some radius of a photo';

  @override
  String get searchPeopleEmptySection =>
      'Invite people, and you\'ll see all photos shared by them here';

  @override
  String get searchAlbumsEmptySection => 'Albums';

  @override
  String get searchFileTypesAndNamesEmptySection => 'File types and names';

  @override
  String get searchCaptionEmptySection =>
      'Add descriptions like \"#trip\" in photo info to quickly find them here';

  @override
  String get language => 'Језик';

  @override
  String get selectLanguage => 'Изабери језик';

  @override
  String get locationName => 'Назив локације';

  @override
  String get addLocation => 'Додај локацију';

  @override
  String get groupNearbyPhotos => 'Групиши околне фотографије';

  @override
  String get kiloMeterUnit => 'км';

  @override
  String get addLocationButton => 'Додај';

  @override
  String get radius => 'Пречник';

  @override
  String get locationTagFeatureDescription =>
      'A location tag groups all photos that were taken within some radius of a photo';

  @override
  String get galleryMemoryLimitInfo => 'Up to 1000 memories shown in gallery';

  @override
  String get save => 'Сачувај';

  @override
  String get centerPoint => 'Централна тачка';

  @override
  String get pickCenterPoint => 'Изабери централну тачку';

  @override
  String get useSelectedPhoto => 'Корисити изабрану фотографију';

  @override
  String get resetToDefault => 'Reset to default';

  @override
  String get edit => 'Измени';

  @override
  String get deleteLocation => 'Обриши локацију';

  @override
  String get rotateLeft => 'Заротирај у лево';

  @override
  String get flip => 'Обрни у огледалу';

  @override
  String get rotateRight => 'Заротирај у десно';

  @override
  String get saveCopy => 'Сачувај копију';

  @override
  String get light => 'Осветљење';

  @override
  String get color => 'Боја';

  @override
  String get yesDiscardChanges => 'Да, одбаци измене';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade =>
      'Да ли желиш да одбациш направљене измене?';

  @override
  String get saving => 'Чувам...';

  @override
  String get editsSaved => 'Измене сачуване';

  @override
  String get oopsCouldNotSaveEdits => 'Oops, could not save edits';

  @override
  String get distanceInKMUnit => 'км';

  @override
  String get dayToday => 'Данас';

  @override
  String get dayYesterday => 'Јуче';

  @override
  String get storage => 'Storage';

  @override
  String get usedSpace => 'Искоришћен простор';

  @override
  String get storageBreakupFamily => 'Породица';

  @override
  String get storageBreakupYou => 'Ти';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return '$usedAmount $usedStorageUnit of $totalAmount $totalStorageUnit used';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return '$freeAmount $storageUnit free';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'Version: $versionValue';
  }

  @override
  String get verifyIDLabel => 'Verify';

  @override
  String get fileInfoAddDescHint => 'Додај опис';

  @override
  String get editLocationTagTitle => 'Измени локацију';

  @override
  String get setLabel => 'Set';

  @override
  String get setRadius => 'Задај пречник';

  @override
  String get familyPlanPortalTitle => 'Family';

  @override
  String get familyPlanOverview =>
      'Add 5 family members to your existing plan without paying extra.\n\nEach member gets their own private space, and cannot see each other\'s files unless they\'re shared.\n\nFamily plans are available to customers who have a paid Ente subscription.\n\nSubscribe now to get started!';

  @override
  String get androidBiometricHint => 'Verify identity';

  @override
  String get androidBiometricNotRecognized => 'Not recognized. Try again.';

  @override
  String get androidBiometricSuccess => 'Success';

  @override
  String get androidCancelButton => 'Cancel';

  @override
  String get androidSignInTitle => 'Authentication required';

  @override
  String get androidBiometricRequiredTitle => 'Biometric required';

  @override
  String get androidDeviceCredentialsRequiredTitle =>
      'Device credentials required';

  @override
  String get androidDeviceCredentialsSetupDescription =>
      'Device credentials required';

  @override
  String get goToSettings => 'Go to settings';

  @override
  String get androidGoToSettingsDescription =>
      'Biometric authentication is not set up on your device. Go to \'Settings > Security\' to add biometric authentication.';

  @override
  String get iOSLockOut =>
      'Biometric authentication is disabled. Please lock and unlock your screen to enable it.';

  @override
  String get iOSGoToSettingsDescription =>
      'Biometric authentication is not set up on your device. Please either enable Touch ID or Face ID on your phone.';

  @override
  String get iOSOkButton => 'OK';

  @override
  String get openstreetmapContributors => 'OpenStreetMap contributors';

  @override
  String get hostedAtOsmFrance => 'Hosted at OSM France';

  @override
  String get map => 'Мапа';

  @override
  String get maps => 'Мапе';

  @override
  String get mapsPrivacyNotice =>
      'Approximate coordinates will be sent to privacy conscious third parties like OpenStreetMap to show the map and location.';

  @override
  String get enableMaps => 'Омогући мапе';

  @override
  String get quickLinks => 'Quick links';

  @override
  String get selectItemsToAdd => 'Select items to add';

  @override
  String get addSelected => 'Add selected';

  @override
  String get addFromDevice => 'Add from device';

  @override
  String get addPhotos => 'Додај фотографије';

  @override
  String get noPhotosFoundHere => 'No photos found here';

  @override
  String get zoomOutToSeePhotos => 'Одзумирај да видиш фотографије';

  @override
  String get noImagesWithLocation => 'No images with location';

  @override
  String get unpinAlbum => 'Unpin album';

  @override
  String get pinAlbum => 'Pin album';

  @override
  String get pin => 'Pin';

  @override
  String get pinPerson => 'Pin person';

  @override
  String get pinToTop => 'Pin to top';

  @override
  String get unpin => 'Unpin';

  @override
  String get unpinPerson => 'Unpin person';

  @override
  String get visibility => 'Visibility';

  @override
  String get hideFromMemories => 'Hide from memories';

  @override
  String get showInMemories => 'Show in memories';

  @override
  String get create => 'Create';

  @override
  String get viewAll => 'View all';

  @override
  String get nothingSharedWithYouYet => 'Nothing shared with you yet';

  @override
  String get noAlbumsSharedByYouYet => 'No albums shared by you yet';

  @override
  String get sharedWithYou => 'Shared with you';

  @override
  String get sharedByYou => 'Shared by you';

  @override
  String get inviteYourFriendsToEnte => 'Позови твоје пријатеље на Енте';

  @override
  String get failedToDownloadVideo => 'Failed to download video';

  @override
  String get hiding => 'Hiding...';

  @override
  String get unhiding => 'Unhiding...';

  @override
  String get successfullyHid => 'Successfully hid';

  @override
  String get successfullyUnhid => 'Successfully unhid';

  @override
  String get crashReporting => 'Crash reporting';

  @override
  String get resumableUploads => 'Resumable uploads';

  @override
  String get addToHiddenAlbum => 'Додај у тајни албум';

  @override
  String get moveToHiddenAlbum => 'Move to hidden album';

  @override
  String get fileTypes => 'File types';

  @override
  String get deleteConfirmDialogBody =>
      'This account is linked to other Ente apps, if you use any. Your uploaded data, across all Ente apps, will be scheduled for deletion, and your account will be permanently deleted.';

  @override
  String get hearUsWhereTitle => 'How did you hear about Ente? (optional)';

  @override
  String get hearUsExplanation =>
      'We don\'t track app installs. It\'d help if you told us where you found us!';

  @override
  String get viewAddOnButton => 'Погледај додатке';

  @override
  String get addOns => 'Додаци';

  @override
  String get addOnPageSubtitle => 'Детаљи додатака';

  @override
  String get yourMap => 'Твоја мапа';

  @override
  String get modifyYourQueryOrTrySearchingFor =>
      'Modify your query, or try searching for';

  @override
  String get blackFridaySale => 'Black Friday Sale';

  @override
  String get upto50OffUntil4thDec => 'Upto 50% off, until 4th Dec.';

  @override
  String get photos => 'Photos';

  @override
  String get videos => 'Videos';

  @override
  String get livePhotos => 'Live Photos';

  @override
  String get searchHint1 => 'Fast, on-device search';

  @override
  String get searchHint2 => 'Photo dates, descriptions';

  @override
  String get searchHint3 => 'Albums, file names, and types';

  @override
  String get searchHint4 => 'Локација';

  @override
  String get searchHint5 => 'Coming soon: Faces & magic search ✨';

  @override
  String get addYourPhotosNow => 'Add your photos now';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count results found',
      one: '$count result found',
    );
    return '$_temp0';
  }

  @override
  String get faces => 'Лица';

  @override
  String get people => 'Људи';

  @override
  String get contents => 'Contents';

  @override
  String get addNew => 'Add new';

  @override
  String get contacts => 'Контакти';

  @override
  String get noInternetConnection => 'No internet connection';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'Please check your internet connection and try again.';

  @override
  String get signOutFromOtherDevices => 'Излогујте се са осталих уређаја';

  @override
  String get signOutOtherBody =>
      'If you think someone might know your password, you can force all other devices using your account to sign out.';

  @override
  String get signOutOtherDevices => 'Излогуј друге уређаје';

  @override
  String get doNotSignOut => 'Do not sign out';

  @override
  String get editLocation => 'Edit location';

  @override
  String get selectALocation => 'Изабери локацију';

  @override
  String get selectALocationFirst => 'Прво изабери локацију';

  @override
  String get changeLocationOfSelectedItems =>
      'Измени локацију изабраних ставки?';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte =>
      'Edits to location will only be seen within Ente';

  @override
  String get cleanUncategorized => 'Clean Uncategorized';

  @override
  String get cleanUncategorizedDescription =>
      'Remove all files from Uncategorized that are present in other albums';

  @override
  String get waitingForVerification => 'Waiting for verification...';

  @override
  String get passkey => 'Passkey';

  @override
  String get passkeyAuthTitle => 'Passkey verification';

  @override
  String get loginWithTOTP => 'Login with TOTP';

  @override
  String get passKeyPendingVerification => 'Verification is still pending';

  @override
  String get loginSessionExpired => 'Session expired';

  @override
  String get loginSessionExpiredDetails =>
      'Your session has expired. Please login again.';

  @override
  String get verifyPasskey => 'Verify passkey';

  @override
  String get playOnTv => 'Гледај албум на телевизору';

  @override
  String get pair => 'Упари';

  @override
  String get deviceNotFound => 'Уређај није пронађен';

  @override
  String get castInstruction =>
      'Visit cast.ente.io on the device you want to pair.\n\nEnter the code below to play the album on your TV.';

  @override
  String get deviceCodeHint => 'Enter the code';

  @override
  String get joinDiscord => 'Прикључи се Дискорду';

  @override
  String get locations => 'Локације';

  @override
  String get addAName => 'Add a name';

  @override
  String get findThemQuickly => 'Find them quickly';

  @override
  String get findPeopleByName => 'Find people quickly by name';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add viewers',
      one: 'Add viewer',
      zero: 'Add viewer',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add collaborators',
      one: 'Add collaborator',
      zero: 'Add collaborator',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      'Long press an email to verify end to end encryption.';

  @override
  String get developerSettingsWarning =>
      'Are you sure that you want to modify Developer settings?';

  @override
  String get developerSettings => 'с';

  @override
  String get serverEndpoint => 'Server endpoint';

  @override
  String get invalidEndpoint => 'Invalid endpoint';

  @override
  String get invalidEndpointMessage =>
      'Sorry, the endpoint you entered is invalid. Please enter a valid endpoint and try again.';

  @override
  String get endpointUpdatedMessage => 'Endpoint updated successfully';

  @override
  String customEndpoint({required Object endpoint}) {
    return 'Connected to $endpoint';
  }

  @override
  String get createCollaborativeLink => 'Create collaborative link';

  @override
  String get search => 'Search';

  @override
  String get enterPersonName => 'Enter person name';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'This email is already linked to $name.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return 'View $name to unlink';
  }

  @override
  String get enterName => 'Enter name';

  @override
  String get savePerson => 'Save person';

  @override
  String get editPerson => 'Edit person';

  @override
  String get mergedPhotos => 'Merged photos';

  @override
  String get orMergeWithExistingPerson => 'Or merge with existing';

  @override
  String get enterDateOfBirth => 'Birthday (optional)';

  @override
  String get birthday => 'Birthday';

  @override
  String get removePersonLabel => 'Remove person label';

  @override
  String get autoPairDesc =>
      'Auto pair works only with devices that support Chromecast.';

  @override
  String get manualPairDesc =>
      'Pair with PIN works with any screen you wish to view your album on.';

  @override
  String get connectToDevice => 'Connect to device';

  @override
  String get autoCastDialogBody => 'You\'ll see available Cast devices here.';

  @override
  String get autoCastiOSPermission =>
      'Make sure Local Network permissions are turned on for the Ente Photos app, in Settings.';

  @override
  String get noDeviceFound => 'No device found';

  @override
  String get stopCastingTitle => 'Stop casting';

  @override
  String get stopCastingBody => 'Do you want to stop casting?';

  @override
  String get castIPMismatchTitle => 'Failed to cast album';

  @override
  String get castIPMismatchBody =>
      'Please make sure you are on the same network as the TV.';

  @override
  String get pairingComplete => 'Pairing complete';

  @override
  String get savingEdits => 'Saving edits...';

  @override
  String get autoPair => 'Auto pair';

  @override
  String get pairWithPin => 'Pair with PIN';

  @override
  String get faceRecognition => 'Face recognition';

  @override
  String get foundFaces => 'Found faces';

  @override
  String get clusteringProgress => 'Clustering progress';

  @override
  String get trim => 'Trim';

  @override
  String get crop => 'Crop';

  @override
  String get rotate => 'Ротирај';

  @override
  String get left => 'Лево';

  @override
  String get right => 'Десно';

  @override
  String get whatsNew => 'Шта је ново';

  @override
  String get reviewSuggestions => 'Review suggestions';

  @override
  String get review => 'Review';

  @override
  String get useAsCover => 'Користи за позадину';

  @override
  String notPersonLabel({required String name}) {
    return 'Није $name?';
  }

  @override
  String get enable => 'Enable';

  @override
  String get enabled => 'Enabled';

  @override
  String get moreDetails => 'More details';

  @override
  String get enableMLIndexingDesc =>
      'Ente supports on-device machine learning for face recognition, magic search and other advanced search features';

  @override
  String get magicSearchHint =>
      'Magic search allows to search photos by their contents, e.g. \'flower\', \'red car\', \'identity documents\'';

  @override
  String get panorama => 'Панорама';

  @override
  String get reenterPassword => 'Поново унеси лозинку';

  @override
  String get reenterPin => 'Поново унеси пин';

  @override
  String get deviceLock => 'Закључавање уређаја';

  @override
  String get pinLock => 'PIN lock';

  @override
  String get next => 'Next';

  @override
  String get setNewPassword => 'Постави нову лозинку';

  @override
  String get enterPin => 'Унеси пин';

  @override
  String get setNewPin => 'Постави нови пин';

  @override
  String get appLock => 'Закључавање апликације';

  @override
  String get noSystemLockFound => 'No system lock found';

  @override
  String get tapToUnlock => 'Додирните за откључавање';

  @override
  String get tooManyIncorrectAttempts => 'Превише погрешних покушаја';

  @override
  String get videoInfo => 'Video Info';

  @override
  String get autoLock => 'Аутоматско закључавање';

  @override
  String get immediately => 'Одмах';

  @override
  String get autoLockFeatureDescription =>
      'Time after which the app locks after being put in the background';

  @override
  String get hideContent => 'Сакриј садржај';

  @override
  String get hideContentDescriptionAndroid =>
      'Hides app content in the app switcher and disables screenshots';

  @override
  String get hideContentDescriptionIos =>
      'Hides app content in the app switcher';

  @override
  String get passwordStrengthInfo =>
      'Password strength is calculated considering the length of the password, used characters, and whether or not the password appears in the top 10,000 most used passwords';

  @override
  String get noQuickLinksSelected => 'No quick links selected';

  @override
  String get pleaseSelectQuickLinksToRemove =>
      'Please select quick links to remove';

  @override
  String get removePublicLinks => 'Remove public links';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      'This will remove public links of all selected quick links.';

  @override
  String get guestView => 'Guest view';

  @override
  String get guestViewEnablePreSteps =>
      'To enable guest view, please setup device passcode or screen lock in your system settings.';

  @override
  String get nameTheAlbum => 'Именуј албум';

  @override
  String get collectPhotosDescription =>
      'Create a link where your friends can upload photos in original quality.';

  @override
  String get collect => 'Collect';

  @override
  String get appLockDescriptions =>
      'Choose between your device\'s default lock screen and a custom lock screen with a PIN or password.';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'To enable app lock, please setup device passcode or screen lock in your system settings.';

  @override
  String get authToViewPasskey => 'Please authenticate to view your passkey';

  @override
  String get loopVideoOn => 'Disable looping';

  @override
  String get loopVideoOff => 'Enable looping';

  @override
  String get localSyncErrorMessage =>
      'Looks like something went wrong since local photos sync is taking more time than expected. Please reach out to our support team';

  @override
  String get showPerson => 'Покажи особу';

  @override
  String get sort => 'Сортирај';

  @override
  String get mostRecent => 'Најновије';

  @override
  String get mostRelevant => 'Најрелевантније';

  @override
  String get loadingYourPhotos => 'Loading your photos...';

  @override
  String processingImport({required Object folderName}) {
    return 'Processing $folderName...';
  }

  @override
  String get personName => 'Име особе';

  @override
  String get addNewPerson => 'Додај нову особу';

  @override
  String get addNameOrMerge => 'Додај име или споји';

  @override
  String get mergeWithExisting => 'Споји са постојећом';

  @override
  String get newPerson => 'Нова особа';

  @override
  String get addName => 'Додај име';

  @override
  String get add => 'Додај';

  @override
  String extraPhotosFoundFor({required String text}) {
    return 'Extra photos found for $text';
  }

  @override
  String get extraPhotosFound => 'Extra photos found';

  @override
  String get configuration => 'Configuration';

  @override
  String get localIndexing => 'Локално индексирање';

  @override
  String get processed => 'Processed';

  @override
  String get resetPerson => 'Уклони';

  @override
  String get areYouSureYouWantToResetThisPerson =>
      'Are you sure you want to reset this person?';

  @override
  String get allPersonGroupingWillReset =>
      'All groupings for this person will be reset, and you will lose all suggestions made for this person';

  @override
  String get yesResetPerson => 'Yes, reset person';

  @override
  String get onlyThem => 'Only them';

  @override
  String get checkingModels => 'Checking models...';

  @override
  String get enableMachineLearningBanner =>
      'Enable machine learning for magic search and face recognition';

  @override
  String get searchDiscoverEmptySection =>
      'Images will be shown here once processing and syncing is complete';

  @override
  String get searchPersonsEmptySection =>
      'People will be shown here once processing and syncing is complete';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count viewers',
      one: 'Added 1 viewer',
      zero: 'Added 0 viewers',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count collaborators',
      one: 'Added 1 collaborator',
      zero: 'Added 0 collaborator',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured => 'Account is already configured.';

  @override
  String get sessionIdMismatch => 'Session ID mismatch';

  @override
  String get failedToFetchActiveSessions => 'Failed to fetch active sessions';

  @override
  String get failedToRefreshStripeSubscription =>
      'Failed to refresh subscription';

  @override
  String get failedToPlayVideo => 'Failed to play video';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return 'Upload is ignored due to $ignoreReason';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'Type of gallery $galleryType is not supported for rename';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'Tap to upload, upload is currently ignored due to $ignoreReason';
  }

  @override
  String get tapToUpload => 'Tap to upload';

  @override
  String get info => 'Info';

  @override
  String get addFiles => 'Add Files';

  @override
  String get castAlbum => 'Cast album';

  @override
  String get imageNotAnalyzed => 'Image not analyzed';

  @override
  String get noFacesFound => 'No faces found';

  @override
  String get fileNotUploadedYet => 'File not uploaded yet';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return 'No suggestions for $personName';
  }

  @override
  String get month => 'месец';

  @override
  String get yearShort => 'год';

  @override
  String get currentlyRunning => 'currently running';

  @override
  String get ignored => 'ignored';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count photos',
      one: '1 photo',
      zero: '0 photos',
    );
    return '$_temp0';
  }

  @override
  String get file => 'File';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'Sections length mismatch: $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'Select mail app';

  @override
  String get selectAllShort => 'All';

  @override
  String get selectCoverPhoto => 'Select cover photo';

  @override
  String get newLocation => 'New location';

  @override
  String get faceNotClusteredYet =>
      'Face not clustered yet, please come back later';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'The link you are trying to access has expired.';

  @override
  String get openFile => 'Open file';

  @override
  String get backupFile => 'Backup file';

  @override
  String get openAlbumInBrowser => 'Open album in browser';

  @override
  String get openAlbumInBrowserTitle =>
      'Please use the web app to add photos to this album';

  @override
  String get allow => 'Дозволи';

  @override
  String get allowAppToOpenSharedAlbumLinks =>
      'Allow app to open shared album links';

  @override
  String get seePublicAlbumLinksInApp => 'See public album links in app';

  @override
  String get emergencyContacts => 'Emergency Contacts';

  @override
  String get acceptTrustInvite => 'Прихвати позивницу';

  @override
  String get declineTrustInvite => 'Одбиј позивницу';

  @override
  String get removeYourselfAsTrustedContact =>
      'Remove yourself as trusted contact';

  @override
  String get legacy => 'Наслеђе';

  @override
  String get legacyPageDesc =>
      'Legacy allows trusted contacts to access your account in your absence.';

  @override
  String get legacyPageDesc2 =>
      'Trusted contacts can initiate account recovery, and if not blocked within 30 days, reset your password and access your account.';

  @override
  String get legacyAccounts => 'Legacy accounts';

  @override
  String get trustedContacts => 'Контакти од поверења';

  @override
  String get addTrustedContact => 'Add Trusted Contact';

  @override
  String get removeInvite => 'Remove invite';

  @override
  String get recoveryWarning =>
      'A trusted contact is trying to access your account';

  @override
  String get rejectRecovery => 'Reject recovery';

  @override
  String get recoveryInitiated => 'Recovery initiated';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return 'You can access the account after $days days. A notification will be sent to $email.';
  }

  @override
  String get cancelAccountRecovery => 'Cancel recovery';

  @override
  String get recoveryAccount => 'Recover account';

  @override
  String get cancelAccountRecoveryBody =>
      'Are you sure you want to cancel recovery?';

  @override
  String get startAccountRecoveryTitle => 'Start recovery';

  @override
  String get whyAddTrustContact =>
      'Trusted contact can help in recovering your data.';

  @override
  String recoveryReady({required String email}) {
    return 'You can now recover $email\'s account by setting a new password.';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email is trying to recover your account.';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return 'You have been invited to be a legacy contact by $email.';
  }

  @override
  String get warning => 'Упозорење';

  @override
  String get proceed => 'Настави';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return 'You are about to add $email as a trusted contact. They will be able to recover your account if you are absent for $numOfDays days.';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email has invited you to be a trusted contact';
  }

  @override
  String get authToManageLegacy =>
      'Please authenticate to manage your trusted contacts';

  @override
  String get hideSharedItemsFromHomeGallery =>
      'Hide shared items from home gallery';

  @override
  String get swipeToSelect => 'Swipe to select';

  @override
  String get gallery => 'Галерија';

  @override
  String get joinAlbum => 'Join album';

  @override
  String get joinAlbumSubtext => 'to view and add your photos';

  @override
  String get joinAlbumSubtextViewer => 'to add this to shared albums';

  @override
  String get join => 'Join';

  @override
  String get linkEmail => 'Повежи имејл';

  @override
  String get link => 'Link';

  @override
  String get noEnteAccountExclamation => 'No Ente account!';

  @override
  String get orPickFromYourContacts => 'or pick from your contacts';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return '$email does not have an Ente account.';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (Me)';
  }

  @override
  String get reassignMe => 'Reassign \"Me\"';

  @override
  String get me => 'Ја';

  @override
  String get linkEmailToContactBannerCaption => 'for faster sharing';

  @override
  String get selectPersonToLink => 'Select person to link';

  @override
  String linkPersonToEmail({required String email}) {
    return 'Link person to $email';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return 'This will link $personName to $email';
  }

  @override
  String get selectYourFace => 'Select your face';

  @override
  String get reassigningLoading => 'Reassigning...';

  @override
  String reassignedToName({required String name}) {
    return 'Reassigned you to $name';
  }

  @override
  String get saveChangesBeforeLeavingQuestion => 'Save changes before leaving?';

  @override
  String get dontSave => 'Don\'t save';

  @override
  String get thisIsMeExclamation => 'Ово сам ја!';

  @override
  String get linkPerson => 'Link person';

  @override
  String get linkPersonCaption => 'for better sharing experience';

  @override
  String get videoStreaming => 'Streamable videos';

  @override
  String get processingVideos => 'Processing videos';

  @override
  String get streamDetails => 'Stream details';

  @override
  String get processing => 'Processing';

  @override
  String get queued => 'Queued';

  @override
  String get ineligible => 'Ineligible';

  @override
  String get failed => 'Failed';

  @override
  String get playStream => 'Play stream';

  @override
  String get playOriginal => 'Пусти оригинал';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'Joining an album will make your email visible to its participants.';

  @override
  String get pleaseWaitThisWillTakeAWhile =>
      'Please wait, this will take a while.';

  @override
  String get editTime => 'Edit time';

  @override
  String get selectTime => 'Изабери време';

  @override
  String get selectDate => 'Изабери датум';

  @override
  String get previous => 'Previous';

  @override
  String get selectOneDateAndTimeForAll => 'Select one date and time for all';

  @override
  String get selectStartOfRange => 'Select start of range';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      'This will make the date and time of all selected photos the same.';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'This is the first in the group. Other selected photos will automatically shift based on this new date';

  @override
  String get newRange => 'New range';

  @override
  String get selectOneDateAndTime => 'Select one date and time';

  @override
  String get moveSelectedPhotosToOneDate => 'Move selected photos to one date';

  @override
  String get shiftDatesAndTime => 'Shift dates and time';

  @override
  String get photosKeepRelativeTimeDifference =>
      'Photos keep relative time difference';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count photos',
      one: '1 photo',
      zero: 'No photos',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'Иконица апликације';

  @override
  String get notThisPerson => 'То није та особа?';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      'Selected items will be removed from this person, but not deleted from your library.';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat кроз године';
  }

  @override
  String get thisWeekThroughTheYears => 'Тренутна недеља кроз године';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'This week, $count years ago',
      one: 'This week, $count year ago',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'Ти и $name';
  }

  @override
  String admiringThem({required Object name}) {
    return 'Admiring $name';
  }

  @override
  String embracingThem({required Object name}) {
    return 'Embracing $name';
  }

  @override
  String partyWithThem({required Object name}) {
    return 'Журка са $name';
  }

  @override
  String hikingWithThem({required Object name}) {
    return 'Походништво са $name';
  }

  @override
  String feastingWithThem({required Object name}) {
    return 'Feasting with $name';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return 'Селфији са $name';
  }

  @override
  String posingWithThem({required Object name}) {
    return 'Позирање са $name';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return 'Прелепи призори са $name';
  }

  @override
  String sportsWithThem({required Object name}) {
    return 'Спорт са $name';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return 'Путовање са $name';
  }

  @override
  String get spotlightOnYourself => 'Сва светла на теби';

  @override
  String spotlightOnThem({required Object name}) {
    return 'Сва светла на $name';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$name is $age!';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name ускоро навршава $age';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return 'Последњи пут са $name';
  }

  @override
  String tripToLocation({required Object location}) {
    return 'Пут у $location';
  }

  @override
  String tripInYear({required Object year}) {
    return 'Пут из $year';
  }

  @override
  String get lastYearsTrip => 'Прошлогодишње путовање';

  @override
  String get sunrise => 'На хирозонту';

  @override
  String get mountains => 'Преко брда';

  @override
  String get greenery => 'Зеленило';

  @override
  String get beach => 'Песак и море';

  @override
  String get city => 'У граду';

  @override
  String get moon => 'Под светлом Месеца';

  @override
  String get onTheRoad => 'На путу';

  @override
  String get food => 'Кулинарски ужици';

  @override
  String get pets => 'Чупави другари';

  @override
  String get curatedMemories => 'Пробране успомене';

  @override
  String get widgets => 'Виџети';

  @override
  String get memories => 'Успомене';

  @override
  String get peopleWidgetDesc =>
      'Select the people you wish to see on your homescreen.';

  @override
  String get albumsWidgetDesc =>
      'Select the albums you wish to see on your homescreen.';

  @override
  String get memoriesWidgetDesc =>
      'Select the kind of memories you wish to see on your homescreen.';

  @override
  String get smartMemories => 'Smart memories';

  @override
  String get pastYearsMemories => 'Прошлогодишње успомене';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return 'Also delete the photos (and videos) present in these $count albums from <bold>all</bold> other albums they are part of?';
  }

  @override
  String get addParticipants => 'Додај учеснике';

  @override
  String selectedAlbums({required Object count}) {
    return '$count selected';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'Action not supported on Favourites album';

  @override
  String get onThisDayMemories => 'Успомене на данашњи дан';

  @override
  String get onThisDay => 'На данашњи дан';

  @override
  String get lookBackOnYourMemories => 'Look back on your memories 🌄';

  @override
  String get newPhotosEmoji => ' new 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'Sorry, we had to pause your backups';

  @override
  String get clickToInstallOurBestVersionYet =>
      'Click to install our best version yet';

  @override
  String get onThisDayNotificationExplanation =>
      'Receive reminders about memories from this day in previous years.';

  @override
  String get addMemoriesWidgetPrompt =>
      'Add a memories widget to your homescreen and come back here to customize.';

  @override
  String get addAlbumWidgetPrompt =>
      'Add an album widget to your homescreen and come back here to customize.';

  @override
  String get addPeopleWidgetPrompt =>
      'Add a people widget to your homescreen and come back here to customize.';

  @override
  String get birthdayNotifications => 'Обавешења о рођенданима';

  @override
  String get receiveRemindersOnBirthdays =>
      'Receive reminders when it\'s someone\'s birthday. Tapping on the notification will take you to photos of the birthday person.';

  @override
  String get happyBirthday => 'Срећан рођендан! 🥳';

  @override
  String get birthdays => 'Рођендани';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return 'Пожели $name срећан рођендан! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      'Are you sure you want to remove this face from this person?';

  @override
  String get otherDetectedFaces => 'Друга препозната лица';

  @override
  String get areThey => 'Да ли је то';

  @override
  String get questionmark => '?';

  @override
  String get saveAsAnotherPerson => 'Сачувај као другу особу';

  @override
  String get showLessFaces => 'Прикажи мање лица';

  @override
  String get showMoreFaces => 'Прикажи још лица';

  @override
  String get ignore => 'Игнориши';

  @override
  String get merge => 'Споји';

  @override
  String get reset => 'Ресетуј';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      'Are you sure you want to ignore this person?';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      'Are you sure you want to ignore these persons?';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'The person groups will not be displayed in the people section anymore. Photos will remain untouched.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'The person will not be displayed in the people section anymore. Photos will remain untouched.';

  @override
  String get areYouSureYouWantToMergeThem =>
      'Да ли си сигуран да желиш да их спојиш?';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'All unnamed groups will be merged into the selected person. This can still be undone from the suggestions history overview of the person.';

  @override
  String get yesIgnore => 'Yes, ignore';

  @override
  String get same => 'Same';

  @override
  String get different => 'Different';

  @override
  String get sameperson => 'Same person?';

  @override
  String get indexingPausedStatusDescription =>
      'Indexing is paused. It will automatically resume when the device is ready. The device is considered ready when its battery level, battery health, and thermal status are within a healthy range.';

  @override
  String get thisWeek => 'This week';

  @override
  String get lastWeek => 'Last week';

  @override
  String get thisMonth => 'This month';

  @override
  String get thisYear => 'This year';

  @override
  String get groupBy => 'Group by';

  @override
  String get faceThumbnailGenerationFailed =>
      'Unable to generate face thumbnails';

  @override
  String get fileAnalysisFailed => 'Unable to analyze file';

  @override
  String get editAutoAddPeople => 'Edit auto-add people';

  @override
  String get autoAddPeople => 'Auto-add people';

  @override
  String get autoAddToAlbum => 'Auto-add to album';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      'Should the files related to the person that were previously selected in smart albums be removed?';

  @override
  String get addingPhotos => 'Adding photos';

  @override
  String get gettingReady => 'Getting ready';

  @override
  String get addSomePhotosDesc1 => 'Додај фотографије или изабери';

  @override
  String get addSomePhotosDesc2 => 'позната лица';

  @override
  String get addSomePhotosDesc3 => 'за почетак';

  @override
  String get ignorePerson => 'Игнориши особу';

  @override
  String get mixedGrouping => 'Mixed grouping?';

  @override
  String get analysis => 'Анализа';

  @override
  String get doesGroupContainMultiplePeople =>
      'Does this grouping contain multiple people?';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'We will automatically analyze the grouping to determine if there are multiple people present, and separate them out again. This may take a few seconds.';

  @override
  String get layout => 'Распоред';

  @override
  String get day => 'Дан';

  @override
  String get undo => 'Undo';

  @override
  String get redo => 'Redo';

  @override
  String get filter => 'Филтер';

  @override
  String get adjust => 'Прилагоди';

  @override
  String get draw => 'Нацртај';

  @override
  String get sticker => 'Налепница';

  @override
  String get brushColor => 'Боја четкице';

  @override
  String get font => 'Фонт';

  @override
  String get background => 'Позадина';

  @override
  String get align => 'Поравнај';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Успешно додано у $count албума',
      one: 'Успешно додано у 1 албум',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => 'Videos processed';

  @override
  String get totalVideos => 'Total videos';

  @override
  String get skippedVideos => 'Skipped videos';

  @override
  String get videoStreamingDescriptionLine1 =>
      'Play videos instantly on any device.';

  @override
  String get videoStreamingDescriptionLine2 =>
      'Enable to process video streams on this device.';

  @override
  String get videoStreamingNote =>
      'Only videos from last 60 days and under 1 minute are processed on this device. For older/longer videos, enable streaming in the desktop app.';

  @override
  String get createStream => 'Create stream';

  @override
  String get recreateStream => 'Recreate stream';

  @override
  String get addedToStreamCreationQueue => 'Added to stream creation queue';

  @override
  String get addedToStreamRecreationQueue => 'Added to stream recreation queue';

  @override
  String get videoPreviewAlreadyExists => 'Video preview already exists';

  @override
  String get videoAlreadyInQueue => 'Video file already present in the queue';

  @override
  String get videoExportFailed => 'Video creation failed. Please try again.';

  @override
  String videoExportSuccess({required String path}) {
    return 'Video successfully created at $path';
  }

  @override
  String get addedToQueue => 'Added to queue';

  @override
  String get creatingStream => 'Creating stream';

  @override
  String get similarImages => 'Similar images';

  @override
  String get findSimilarImages => 'Find similar images';

  @override
  String get noSimilarImagesFound => 'No similar images found';

  @override
  String get yourPhotosLookUnique => 'Your photos look unique';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count groups found',
      one: '$count group found',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages => 'Review and remove similar images';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return 'Delete $count photos ($size)';
  }

  @override
  String get selectionOptions => 'Selection options';

  @override
  String selectExactWithCount({required int count}) {
    return 'Exactly similar ($count)';
  }

  @override
  String get selectExact => 'Select exact';

  @override
  String selectSimilarWithCount({required int count}) {
    return 'Mostly similar ($count)';
  }

  @override
  String get selectSimilar => 'Select similar';

  @override
  String selectAllWithCount({required int count}) {
    return 'All similarities ($count)';
  }

  @override
  String get selectSimilarImagesTitle => 'Select similar images';

  @override
  String get chooseSimilarImagesToSelect =>
      'Select images based on their visual similarity';

  @override
  String get clearSelection => 'Clear selection';

  @override
  String similarImagesCount({required int count}) {
    return '$count similar images';
  }

  @override
  String deleteWithCount({required int count}) {
    return 'Delete ($count)';
  }

  @override
  String get deleteFiles => 'Delete files';

  @override
  String get areYouSureDeleteFiles =>
      'Are you sure you want to delete these files?';

  @override
  String get greatJob => 'Great job!';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return 'You freed up $size of space';
  }

  @override
  String get size => 'Size';

  @override
  String get similarity => 'Similarity';

  @override
  String get analyzingPhotosLocally => 'Analyzing your photos locally...';

  @override
  String get lookingForVisualSimilarities =>
      'Looking for visual similarities...';

  @override
  String get comparingImageDetails => 'Comparing image details...';

  @override
  String get findingSimilarImages => 'Finding similar images...';

  @override
  String get almostDone => 'Almost done...';

  @override
  String get processingLocally => 'Processing locally';

  @override
  String get useMLToFindSimilarImages =>
      'Review and remove images that look similar to each other.';

  @override
  String get all => 'All';

  @override
  String get similar => 'Similar';

  @override
  String get identical => 'Identical';

  @override
  String get nothingHereTryAnotherFilter =>
      'Nothing here, try another filter! 👀';

  @override
  String get related => 'Related';

  @override
  String get hoorayyyy => 'Hoorayyyy!';

  @override
  String get nothingToTidyUpHere => 'Nothing to tidy up here';

  @override
  String get deletingDash => 'Deleting - ';

  @override
  String get cLTitle1 => 'Jump to date';

  @override
  String get cLDesc1 =>
      'See surrounding photos for any photo by selecting the jump to date option in the file\'s info pane.';

  @override
  String get cLTitle2 => 'Faster video editor';

  @override
  String get cLDesc2 =>
      'Video editor was revamped to both drastically improve its speed when editing larger videos, and also improve the UX.';

  @override
  String get cLTitle3 => 'New memories';

  @override
  String get cLDesc3 =>
      '\"Playful kids\", \"Winter adventures\", \"Neon nights\", and more.';

  @override
  String get cLTitle4 => 'Landscape gallery and more';

  @override
  String get cLDesc4 =>
      'Support for landscape layout in the app\'s main gallery. Show persons without any associated photos instead of filtering them out. Improve video aspect detection when shared from external apps.';

  @override
  String get closeBy => 'Close';

  @override
  String get peopleAutoAddDesc =>
      'Automatically add photos of the selected people to this album';

  @override
  String get festivities => 'Festive cheer';

  @override
  String get snowAdventures => 'Winter adventures';

  @override
  String get waterfalls => 'Chasing waterfalls';

  @override
  String get wildlife => 'Into the wild';

  @override
  String get flowers => 'Blooming beauties';

  @override
  String get nightLights => 'Neon nights';

  @override
  String get architecture => 'Design icons';

  @override
  String get autumnColors => 'Autumn splendor';

  @override
  String get desertDreams => 'Desert dreams';

  @override
  String get stargazing => 'Under the stars';

  @override
  String get lakeside => 'Lakeside calm';

  @override
  String get rainyDays => 'Rainy day feels';

  @override
  String get sportsAction => 'Game on';

  @override
  String get streetArt => 'Street art stories';

  @override
  String get familyMoments => 'Family time';

  @override
  String get fireworks => 'Firework finale';

  @override
  String get historicSites => 'Echoes of history';

  @override
  String get tropicalParadise => 'Tropical escapes';

  @override
  String get forestTrails => 'Forest strolls';

  @override
  String get citySunsets => 'City sunset glow';

  @override
  String get colorfulMarkets => 'Vibrant markets';

  @override
  String get cozyCafes => 'Cozy cafe corners';

  @override
  String get vintageVibes => 'Vintage vibes';

  @override
  String get aerialViews => 'Aerial perspectives';

  @override
  String get artisticPortraits => 'Artful portraits';

  @override
  String get streetFood => 'Street food bites';

  @override
  String get riverCruises => 'River cruise views';

  @override
  String get facesTimelineBannerTitle => 'Memory Lane';

  @override
  String facesTimelineBannerSubtitle({required String name}) {
    return 'See $name\'s photos across the years';
  }

  @override
  String get facesTimelineAppBarTitle => 'Memory lane';

  @override
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count years old',
      one: '$count year old',
    );
    return '$name was $_temp0';
  }

  @override
  String facesTimelineCaptionYearsAgo({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '# years ago',
      one: '# year ago',
    );
    return '$_temp0';
  }

  @override
  String get facesTimelineShareComingSoon => 'Video sharing coming soon';

  @override
  String get facesTimelinePlaybackPrevious => 'Previous';

  @override
  String get facesTimelinePlaybackNext => 'Next';

  @override
  String get facesTimelinePlaybackPlay => 'Play';

  @override
  String get facesTimelinePlaybackPause => 'Pause';

  @override
  String get facesTimelineUnavailable => 'Faces timeline is preparing...';

  @override
  String get playfulKids => 'Playful kids';

  @override
  String get coastalCliffs => 'Cliffs by the sea';

  @override
  String get ritualsTitle => 'Rituals';

  @override
  String get ritualAddTooltip => 'Add ritual';

  @override
  String get ritualActivityHeading => 'Activity';

  @override
  String get ritualDefaultHeatmapTitle => 'Take a photo every day';

  @override
  String get ritualUntitled => 'Untitled ritual';

  @override
  String get ritualShareUnavailable =>
      'Unable to share right now. Please try again.';

  @override
  String get ritualNotificationMessage => 'Take a photo now';

  @override
  String get ritualCameraNotFound => 'No camera found on this device.';

  @override
  String get ritualCameraStartError =>
      'Unable to start camera. Please check permissions.';

  @override
  String get ritualCaptureError => 'Unable to capture photo. Please try again.';

  @override
  String ritualPhotoLimit({required int maxPhotos}) {
    String _temp0 = intl.Intl.pluralLogic(
      maxPhotos,
      locale: localeName,
      other: '# photos.',
      one: '# photo.',
    );
    return 'You can add up to $_temp0';
  }

  @override
  String get ritualCaptureAtLeastOne => 'Capture at least one photo first.';

  @override
  String get ritualAlbumMissing =>
      'Ritual album missing. Edit the ritual to set an album.';

  @override
  String get ritualAddedToAlbum => 'Added to album';

  @override
  String ritualAddedToAlbumWithName({required String albumName}) {
    return 'Added to $albumName';
  }

  @override
  String ritualAddToAlbumFailure({required String error}) {
    return 'Couldn\'t add photos to the album: $error';
  }

  @override
  String get ritualBackToList => 'Back to rituals';

  @override
  String get ritualNoPhotosYet => 'No photos yet';

  @override
  String get ritualSetAlbumToLaunchCamera =>
      'Set an album for this ritual to launch the camera.';

  @override
  String get ritualDefaultCameraTitle => 'Take a photo';

  @override
  String get ritualBadgeMessage7 =>
      '7 days down! Consistency looks good on you. Keep going!';

  @override
  String get ritualBadgeMessage14 =>
      '14 days in! Your ritual is becoming a habit. Incredible!';

  @override
  String get ritualBadgeMessage30 =>
      '30 days in a row! Legendary consistency. Take a bow!';

  @override
  String get ritualBadgeMessageDefault => 'You\'re on a roll!';

  @override
  String get ritualBadgeNewTitle => 'New achievement';

  @override
  String get ritualBadgePreparing => 'Preparing...';

  @override
  String get ritualStreaksLabel => 'Streaks';

  @override
  String get ritualCreateYourOwn => 'Create your own ritual';

  @override
  String get ritualGetDailyReminders => 'Get daily reminders';

  @override
  String get ritualAlbumNotSet => 'Album not set';

  @override
  String get ritualOpenCameraTooltip => 'Open ritual camera';

  @override
  String get ritualEditorLabel => 'Ritual editor';

  @override
  String get ritualNew => 'New ritual';

  @override
  String get ritualEdit => 'Edit ritual';

  @override
  String get ritualEnterPrompt => 'Enter your ritual';

  @override
  String get ritualEnterDescription => 'Please enter a description';

  @override
  String get ritualDayLabel => 'Day';

  @override
  String get ritualNotificationsOffHint =>
      'Notifications are off. Tap a day to turn them on.';

  @override
  String get ritualTimeLabel => 'Time';

  @override
  String get ritualAlbumLabel => 'Album';

  @override
  String get ritualSave => 'Save ritual';

  @override
  String get ritualUpdate => 'Update ritual';

  @override
  String get ritualSelectAlbumTitle => 'Select album';

  @override
  String get ritualSearchOrCreate => 'Search or create new';

  @override
  String get ritualNoAlbumsYet => 'No albums yet';

  @override
  String get ritualNoMatchingAlbums => 'No matching albums';

  @override
  String ritualCreateAlbumWithName({required String albumName}) {
    return 'Create \"$albumName\"';
  }

  @override
  String get ritualCreateNew => 'Create new';

  @override
  String get ritualAlbumSelectionPlaceholder => 'Select album';

  @override
  String get ritualPickEmojiTitle => 'Pick an emoji';

  @override
  String get ritualCustomKeyboardLabel => 'Custom (keyboard)';

  @override
  String get ritualEmojiKeyboardHint => 'Press to open emoji keyboard';

  @override
  String get ritualEmojiUseAction => 'Use';

  @override
  String get ritualSearchEmpty =>
      'Build a ritual to keep your photo habit going.';
}
