// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Russian (`ru`).
class AppLocalizationsRu extends AppLocalizations {
  AppLocalizationsRu([String locale = 'ru']) : super(locale);

  @override
  String get enterYourEmailAddress => 'Введите адрес вашей электронной почты';

  @override
  String get enterYourNewEmailAddress =>
      'Введите ваш новый адрес электронной почты';

  @override
  String get accountWelcomeBack => 'С возвращением!';

  @override
  String get emailAlreadyRegistered =>
      'Электронная почта уже зарегистрирована.';

  @override
  String get emailNotRegistered => 'Электронная почта не зарегистрирована.';

  @override
  String get email => 'Электронная почта';

  @override
  String get cancel => 'Отменить';

  @override
  String get verify => 'Подтвердить';

  @override
  String get invalidEmailAddress => 'Недействительный адрес электронной почты';

  @override
  String get enterValidEmail =>
      'Пожалуйста, введите действительный адрес электронной почты.';

  @override
  String get deleteAccount => 'Удалить аккаунт';

  @override
  String get deleteAccountWarning =>
      'Это приведет к удалению ваших учетных записей Ente Auth, Ente Photos и Ente Locker.';

  @override
  String get askDeleteReason =>
      'Какова основная причина удаления вашего аккаунта?';

  @override
  String get deleteAccountFeedbackPrompt =>
      'Нам жаль, что вы уходите. Пожалуйста, поделитесь мнением о том, как мы могли бы стать лучше.';

  @override
  String get feedback => 'Обратная связь';

  @override
  String get kindlyHelpUsWithThisInformation =>
      'Пожалуйста, помогите нам с этой информацией';

  @override
  String get confirmDeletePrompt =>
      'Да, я хочу навсегда удалить этот аккаунт и все его данные во всех приложениях.';

  @override
  String get confirmAccountDeletion => 'Подтвердить удаление аккаунта';

  @override
  String get deleteAccountPermanentlyButton => 'Удалить аккаунт навсегда';

  @override
  String get yourAccountHasBeenDeleted => 'Ваш аккаунт был удалён';

  @override
  String get selectReason => 'Выберите причину';

  @override
  String get deleteReason1 => 'Отсутствует необходимая функция';

  @override
  String get deleteReason2 =>
      'Приложение или определённая функция работают не так, как я ожидал';

  @override
  String get deleteReason3 =>
      'Я нашёл другой сервис, который мне больше нравится';

  @override
  String get deleteReason4 => 'Моя причина не указана';

  @override
  String get sendEmail => 'Отправить электронное письмо';

  @override
  String get deleteRequestSLAText =>
      'Ваш запрос будет обработан в течение 72 часов.';

  @override
  String get deleteEmailRequest =>
      'Пожалуйста, отправьте письмо на <warning>account-deletion@ente.io</warning> с вашего зарегистрированного адреса электронной почты.';

  @override
  String get entePhotosPerm =>
      'Ente <i>требуется разрешение для</i> сохранения ваших фото';

  @override
  String get ok => 'Хорошо';

  @override
  String get createAccount => 'Создать аккаунт';

  @override
  String get createNewAccount => 'Создать новый аккаунт';

  @override
  String get password => 'Пароль';

  @override
  String get confirmPassword => 'Подтвердите пароль';

  @override
  String get activeSessions => 'Активные сеансы';

  @override
  String get ocrProcessingOverlayMessage => 'Обнаружение текста...';

  @override
  String get ocrLoadingIndicatorLabel => 'Обнаружение текста';

  @override
  String get ocrSelectionHint =>
      'Свайп или двойное нажатие для выбора того, что вам нужно';

  @override
  String get ocrNoTextDetected => 'Текст не обнаружен';

  @override
  String get ocrRetryButtonLabel => 'Повторить';

  @override
  String get ocrModelsNetworkRequiredError =>
      'Для загрузки моделей OCR при первом использовании требуется сетевое подключение';

  @override
  String get ocrModelsPrepareFailed => 'Не удалось создать модели OCR';

  @override
  String get ocrImageNotFoundError => 'Файл изображения не найден';

  @override
  String get ocrImageDecodeFailedError =>
      'Не удалось прочитать файл изображения';

  @override
  String get ocrGenericDetectError =>
      'Не удалось обнаружить текст на изображении';

  @override
  String get oops => 'Ой';

  @override
  String get somethingWentWrongPleaseTryAgain =>
      'Что-то пошло не так. Пожалуйста, попробуйте снова';

  @override
  String get thisWillLogYouOutOfThisDevice =>
      'Это завершит ваш сеанс на этом устройстве!';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice =>
      'Это завершит ваш сеанс на следующем устройстве:';

  @override
  String get terminateSession => 'Завершить сеанс?';

  @override
  String get terminate => 'Завершить';

  @override
  String get thisDevice => 'Это устройство';

  @override
  String get recoverButton => 'Восстановить';

  @override
  String get recoverySuccessful => 'Успешное восстановление!';

  @override
  String get decrypting => 'Расшифровка...';

  @override
  String get incorrectRecoveryKeyTitle => 'Неверный ключ восстановления';

  @override
  String get incorrectRecoveryKeyBody =>
      'Введённый вами ключ восстановления неверен';

  @override
  String get forgotPassword => 'Забыл пароль';

  @override
  String get enterYourRecoveryKey => 'Введите ваш ключ восстановления';

  @override
  String get noRecoveryKey => 'Нет ключа восстановления?';

  @override
  String get sorry => 'Извините';

  @override
  String get noRecoveryKeyNoDecryption =>
      'Из-за особенностей нашего протокола сквозного шифрования ваши данные не могут быть расшифрованы без пароля или ключа восстановления';

  @override
  String get verifyEmail => 'Подтвердить электронную почту';

  @override
  String get toResetVerifyEmail =>
      'Чтобы сбросить пароль, сначала подтвердите вашу электронную почту.';

  @override
  String get checkInboxAndSpamFolder =>
      'Пожалуйста, проверьте ваш почтовый ящик (и спам) для завершения верификации';

  @override
  String get tapToEnterCode => 'Нажмите, чтобы ввести код';

  @override
  String get resendEmail => 'Отправить письмо повторно';

  @override
  String weHaveSendEmailTo({required String email}) {
    return 'Мы отправили письмо на <green>$email</green>';
  }

  @override
  String get setPasswordTitle => 'Установить пароль';

  @override
  String get changePasswordTitle => 'Изменить пароль';

  @override
  String get resetPasswordTitle => 'Сбросить пароль';

  @override
  String get encryptionKeys => 'Ключи шифрования';

  @override
  String get passwordWarning =>
      'Мы не храним этот пароль, поэтому, если вы его забудете, <underline>мы не сможем расшифровать ваши данные</underline>';

  @override
  String get enterPasswordToEncrypt =>
      'Введите пароль для шифрования ваших данных';

  @override
  String get enterNewPasswordToEncrypt =>
      'Введите новый пароль для шифрования ваших данных';

  @override
  String get weakStrength => 'Низкая';

  @override
  String get strongStrength => 'Высокая';

  @override
  String get moderateStrength => 'Средняя';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'Надёжность пароля: $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully => 'Пароль успешно изменён';

  @override
  String get generatingEncryptionKeys => 'Генерация ключей шифрования...';

  @override
  String get pleaseWait => 'Пожалуйста, подождите...';

  @override
  String get continueLabel => 'Продолжить';

  @override
  String get insecureDevice => 'Небезопасное устройство';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'К сожалению, мы не смогли сгенерировать безопасные ключи на этом устройстве.\n\nПожалуйста, зарегистрируйтесь с другого устройства.';

  @override
  String get howItWorks => 'Как это работает';

  @override
  String get encryption => 'Шифрование';

  @override
  String get ackPasswordLostWarning =>
      'Я понимаю, что если я потеряю пароль, я могу потерять свои данные, так как они <underline>защищены сквозным шифрованием</underline>.';

  @override
  String get privacyPolicyTitle => 'Политика конфиденциальности';

  @override
  String get termsOfServicesTitle => 'Условия использования';

  @override
  String get signUpTerms =>
      'Я согласен с <u-terms>условиями предоставления услуг</u-terms> и <u-policy>политикой конфиденциальности</u-policy>';

  @override
  String get logInLabel => 'Войти';

  @override
  String get loginTerms =>
      'Нажимая \"Войти\", я соглашаюсь с <u-terms>условиями предоставления услуг</u-terms> и <u-policy>политикой конфиденциальности</u-policy>';

  @override
  String get changeEmail => 'Изменить адрес электронной почты';

  @override
  String get enterYourPassword => 'Введите ваш пароль';

  @override
  String get welcomeBack => 'С возвращением!';

  @override
  String get contactSupport => 'Связаться с поддержкой';

  @override
  String get locationPickerTip =>
      'Вы также можете добавить местоположение по центру фотографии из экрана информации о фотографии';

  @override
  String get incorrectPasswordTitle => 'Неверный пароль';

  @override
  String get pleaseTryAgain => 'Пожалуйста, попробуйте снова';

  @override
  String get recreatePasswordTitle => 'Пересоздать пароль';

  @override
  String get useRecoveryKey => 'Использовать ключ восстановления';

  @override
  String get recreatePasswordBody =>
      'Текущее устройство недостаточно мощное для проверки вашего пароля, но мы можем сгенерировать его снова так, чтобы он работал на всех устройствах.\n\nПожалуйста, войдите, используя ваш ключ восстановления, и сгенерируйте пароль (при желании вы можете использовать тот же самый).';

  @override
  String get verifyPassword => 'Подтвердить пароль';

  @override
  String get recoveryKey => 'Ключ восстановления';

  @override
  String get recoveryKeyOnForgotPassword =>
      'Если вы забудете пароль, единственный способ восстановить ваши данные — это использовать этот ключ.';

  @override
  String get recoveryKeySaveDescription =>
      'Мы не храним этот ключ. Пожалуйста, сохраните этот ключ из 24 слов в безопасном месте.';

  @override
  String get doThisLater => 'Сделать это позже';

  @override
  String get saveKey => 'Сохранить ключ';

  @override
  String get recoveryKeyCopiedToClipboard =>
      'Ключ восстановления скопирован в буфер обмена';

  @override
  String get recoverAccount => 'Восстановить аккаунт';

  @override
  String get recover => 'Восстановить';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'Пожалуйста, отправьте письмо на $supportEmail с вашего зарегистрированного адреса электронной почты';
  }

  @override
  String get twofactorSetup => 'Настройка двухфакторной аутентификации';

  @override
  String get enterCode => 'Введите код';

  @override
  String get scanCode => 'Сканировать код';

  @override
  String get codeCopiedToClipboard => 'Код скопирован в буфер обмена';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      'Скопируйте этот код\nв ваше приложение для аутентификации';

  @override
  String get tapToCopy => 'нажмите, чтобы скопировать';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      'Отсканируйте этот штрих-код\nс помощью вашего приложения для аутентификации';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      'Введите 6-значный код из\nвашего приложения для аутентификации';

  @override
  String get confirm => 'Подтвердить';

  @override
  String get setupComplete => 'Настройка завершена';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready =>
      'Сохраните ваш ключ восстановления, если вы ещё этого не сделали';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      'Это можно использовать для восстановления вашего аккаунта, если вы потеряете свой аутентификатор';

  @override
  String get twofactorAuthenticationPageTitle => 'Двухфакторная аутентификация';

  @override
  String get lostDevice => 'Потеряли устройство?';

  @override
  String get verifyingRecoveryKey => 'Проверка ключа восстановления...';

  @override
  String get recoveryKeyVerified => 'Ключ восстановления подтверждён';

  @override
  String get recoveryKeySuccessBody =>
      'Отлично! Ваш ключ восстановления действителен. Спасибо за проверку.\n\nПожалуйста, не забудьте сохранить ключ восстановления в безопасном месте.';

  @override
  String get invalidRecoveryKey =>
      'Введённый вами ключ восстановления недействителен. Убедитесь, что он содержит 24 слова, и проверьте правописание каждого из них.\n\nЕсли вы ввели старый код восстановления, убедитесь, что он состоит из 64 символов, и проверьте каждый из них.';

  @override
  String get invalidKey => 'Недействительный ключ';

  @override
  String get tryAgain => 'Попробовать снова';

  @override
  String get viewRecoveryKey => 'Увидеть ключ восстановления';

  @override
  String get confirmRecoveryKey => 'Подтвердить ключ восстановления';

  @override
  String get recoveryKeyVerifyReason =>
      'Ваш ключ восстановления — единственный способ восстановить ваши фото, если вы забудете пароль. Вы можете найти ключ восстановления в разделе «Настройки» → «Аккаунт».\n\nПожалуйста, введите ваш ключ восстановления здесь, чтобы убедиться, что вы сохранили его правильно.';

  @override
  String get confirmYourRecoveryKey => 'Подтвердите ваш ключ восстановления';

  @override
  String get addViewer => 'Добавить зрителя';

  @override
  String get addCollaborator => 'Добавить соавтора';

  @override
  String get addANewEmail => 'Добавьте новую электронную почту';

  @override
  String get orPickAnExistingOne => 'Или выберите существующую';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'Соавторы могут добавлять фото и видео в общий альбом.';

  @override
  String get enterEmail => 'Введите электронную почту';

  @override
  String get albumOwner => 'Владелец';

  @override
  String get you => 'Вы';

  @override
  String get collaborator => 'Соавтор';

  @override
  String get addMore => 'Добавить ещё';

  @override
  String get viewer => 'Зритель';

  @override
  String get remove => 'Удалить';

  @override
  String get removeParticipant => 'Удалить участника';

  @override
  String get manage => 'Управлять';

  @override
  String get addedAs => 'Добавлен как';

  @override
  String get changePermissions => 'Изменить разрешения?';

  @override
  String get yesConvertToViewer => 'Да, перевести в зрители';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return '$user не сможет добавлять новые фото в этот альбом\n\nЭтот пользователь всё ещё сможет удалять существующие фото, добавленные им';
  }

  @override
  String get allowAddingPhotos => 'Разрешить добавление фото';

  @override
  String get allowJoiningAlbum => 'Разрешить объединение альбомов';

  @override
  String get allowAddPhotosDescription =>
      'Разрешить людям с этой ссылкой добавлять фото в общий альбом.';

  @override
  String get passwordLock => 'Защита паролем';

  @override
  String get canNotOpenTitle => 'Не удаётся открыть этот альбом';

  @override
  String get canNotOpenBody =>
      'Извините, этот альбом не может быть открыт в приложении.';

  @override
  String get disableDownloadWarningTitle => 'Обратите внимание';

  @override
  String get disableDownloadWarningBody =>
      'Зрители всё ещё могут делать скриншоты или сохранять копии ваших фото с помощью внешних инструментов';

  @override
  String get allowDownloads => 'Разрешить скачивание';

  @override
  String get linkDeviceLimit => 'Ограничение по количеству устройств';

  @override
  String get noDeviceLimit => 'Нет';

  @override
  String get albumLayout => 'Макет альбома';

  @override
  String get layoutGrouped => 'Сгруппированные';

  @override
  String get layoutContinuous => 'Непрерывный';

  @override
  String get layoutTrip => 'Путешествие';

  @override
  String get preview => 'Предварительный просмотр';

  @override
  String get linkExpiry => 'Срок действия ссылки';

  @override
  String get linkExpired => 'Истекла';

  @override
  String get linkEnabled => 'Включена';

  @override
  String get linkNeverExpires => 'Никогда';

  @override
  String get expiredLinkInfo =>
      'Срок действия этой ссылки истёк. Пожалуйста, выберите новый срок или отключите его.';

  @override
  String get setAPassword => 'Установить пароль';

  @override
  String get lockButtonLabel => 'Заблокировать';

  @override
  String get enterPassword => 'Введите пароль';

  @override
  String get removeLink => 'Удалить ссылку';

  @override
  String get manageLink => 'Управлять ссылкой';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'Ссылка истечёт $expiryTime';
  }

  @override
  String get albumUpdated => 'Альбом обновлён';

  @override
  String get never => 'Никогда';

  @override
  String get custom => 'Пользовательский';

  @override
  String get after1Hour => 'Через 1 час';

  @override
  String get after1Day => 'Через 1 день';

  @override
  String get after1Week => 'Через 1 неделю';

  @override
  String get after1Month => 'Через 1 месяц';

  @override
  String get after1Year => 'Через 1 год';

  @override
  String get manageParticipants => 'Управлять';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count участников',
      one: '$count участник',
      zero: 'Нет участников',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'Создайте ссылку, чтобы люди могли добавлять и просматривать фото в вашем общем альбоме без использования приложения или аккаунта Ente. Это отлично подходит для сбора фото с мероприятий.';

  @override
  String get collectPhotos => 'Сбор фото';

  @override
  String get collaborativeLink => 'Совместная ссылка';

  @override
  String get shareWithNonenteUsers =>
      'Поделиться с пользователями, не использующими Ente';

  @override
  String get createPublicLink => 'Создать публичную ссылку';

  @override
  String get sendLink => 'Отправить ссылку';

  @override
  String get qrCode => 'QR Code';

  @override
  String get sendQrCode => 'Отправить QR-код';

  @override
  String get copyLink => 'Скопировать ссылку';

  @override
  String get copyEmbedHtml => 'Скопируйте HTML-код для вставки';

  @override
  String get linkHasExpired => 'Срок действия ссылки истёк';

  @override
  String get publicLinkEnabled => 'Публичная ссылка включена';

  @override
  String get shareALink => 'Поделиться ссылкой';

  @override
  String get sharedAlbumSectionDescription =>
      'Создавайте общие и совместные альбомы с другими пользователями Ente, включая пользователей на бесплатных тарифах.';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: 'Доступно $numberOfPeople людям',
      one: 'Доступно 1 человеку',
      zero: 'Поделиться с конкретными людьми',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId => 'Это ваш идентификатор подтверждения';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'Тот, кто делится с вами альбомами, должен видеть такой же идентификатор на своём устройстве.';

  @override
  String get howToViewShareeVerificationID =>
      'Попросите их нажать с удержанием на адрес электронной почты на экране настроек и убедиться, что идентификаторы на обоих устройствах совпадают.';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'Это идентификатор подтверждения $email';
  }

  @override
  String get verificationId => 'Идентификатор подтверждения';

  @override
  String verifyEmailID({required Object email}) {
    return 'Подтвердить $email';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return 'У $email нет аккаунта Ente.\n\nОтправьте ему приглашение для обмена фото.';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return 'Вот мой идентификатор подтверждения: $verificationID для ente.io.';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'Привет, можешь подтвердить, что это твой идентификатор подтверждения ente.io: $verificationID';
  }

  @override
  String get somethingWentWrong => 'Что-то пошло не так';

  @override
  String get sendInvite => 'Отправить приглашение';

  @override
  String get shareTextRecommendUsingEnte =>
      'Скачай Ente, чтобы мы могли легко делиться фото и видео в оригинальном качестве\n\nhttps://ente.io';

  @override
  String get done => 'Готово';

  @override
  String get applyCodeTitle => 'Применить код';

  @override
  String get enterCodeDescription =>
      'Введите код, предоставленный вашим другом, чтобы вы оба могли получить бесплатное хранилище';

  @override
  String get apply => 'Применить';

  @override
  String get failedToApplyCode => 'Не удалось применить код';

  @override
  String get enterReferralCode => 'Введите реферальный код';

  @override
  String get codeAppliedPageTitle => 'Код применён';

  @override
  String get changeYourReferralCode => 'Изменить ваш реферальный код';

  @override
  String get change => 'Изменить';

  @override
  String get unavailableReferralCode => 'Извините, этот код недоступен.';

  @override
  String get codeChangeLimitReached =>
      'Извините, вы достигли лимита изменений кода.';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'Пожалуйста, свяжитесь с $familyAdminEmail для изменения кода.';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB ГБ';
  }

  @override
  String get claimed => 'Получено';

  @override
  String get details => 'Подробности';

  @override
  String get claimMore => 'Получите больше!';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return 'Они тоже получат $storageAmountInGB ГБ';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '$storageAmountInGB ГБ каждый раз, когда кто-то подписывается на платный тариф и применяет ваш код';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'Реферальный код Ente: $referralCode \n\nПримените его в разделе «Настройки» → «Общие» → «Рефералы», чтобы получить $referralStorageInGB ГБ бесплатно после подписки на платный тариф\n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => 'Получить бесплатное хранилище';

  @override
  String get inviteYourFriends => 'Пригласите своих друзей';

  @override
  String get failedToFetchReferralDetails =>
      'Не удалось получить данные о рефералах. Пожалуйста, попробуйте позже.';

  @override
  String get referralStep1 => '1. Даёте этот код своим друзьям';

  @override
  String get referralStep2 => '2. Они подписываются на платный тариф';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. Вы оба получаете $storageInGB ГБ* бесплатно';
  }

  @override
  String get referralsAreCurrentlyPaused =>
      'Реферальная программа временно приостановлена';

  @override
  String get youCanAtMaxDoubleYourStorage =>
      '* Вы можете увеличить хранилище максимум в два раза';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true': 'Ваша семья получила $storageAmountInGb ГБ на данный момент',
      'false': 'Вы получили $storageAmountInGb ГБ на данный момент',
      'other': 'Вы получили $storageAmountInGb ГБ на данный момент!',
    });
    return '$_temp0';
  }

  @override
  String get faq => 'Часто задаваемые вопросы';

  @override
  String get help => 'Помощь';

  @override
  String get oopsSomethingWentWrong => 'Ой, что-то пошло не так';

  @override
  String get peopleUsingYourCode => 'Люди, использующие ваш код';

  @override
  String get eligible => 'доступно';

  @override
  String get total => 'всего';

  @override
  String get codeUsedByYou => 'Код, использованный вами';

  @override
  String get freeStorageClaimed => 'Полученное бесплатное хранилище';

  @override
  String get freeStorageUsable => 'Доступное бесплатное хранилище';

  @override
  String get usableReferralStorageInfo =>
      'Доступное хранилище ограничено вашим текущим тарифом. Избыточное полученное хранилище автоматически станет доступным при улучшении тарифа.';

  @override
  String get removeFromAlbumTitle => 'Удалить из альбома?';

  @override
  String get removeFromAlbum => 'Удалить из альбома';

  @override
  String get itemsWillBeRemovedFromAlbum =>
      'Выбранные элементы будут удалены из этого альбома';

  @override
  String get removeShareItemsWarning =>
      'Некоторые из удаляемых вами элементов были добавлены другими людьми, и вы потеряете к ним доступ';

  @override
  String get addingToFavorites => 'Добавление в избранное...';

  @override
  String get removingFromFavorites => 'Удаление из избранного...';

  @override
  String get sorryCouldNotAddToFavorites =>
      'Извините, не удалось добавить в избранное!';

  @override
  String get sorryCouldNotRemoveFromFavorites =>
      'Извините, не удалось удалить из избранного!';

  @override
  String get subscribeToEnableSharing =>
      'Вам нужна активная платная подписка, чтобы включить общий доступ.';

  @override
  String get subscribe => 'Подписаться';

  @override
  String get canOnlyRemoveFilesOwnedByYou =>
      'Можно удалять только файлы, принадлежащие вам';

  @override
  String get deleteSharedAlbum => 'Удалить общий альбом?';

  @override
  String get deleteAlbum => 'Удалить альбом';

  @override
  String get deleteAlbumDialog =>
      'Также удалить фото (и видео), находящиеся в этом альбоме, из <bold>всех</bold> других альбомов, частью которых они являются?';

  @override
  String get deleteSharedAlbumDialogBody =>
      'Альбом будет удалён для всех\n\nВы потеряете доступ к общим фото в этом альбоме, принадлежащим другим';

  @override
  String get yesRemove => 'Да, удалить';

  @override
  String get creatingLink => 'Создание ссылки...';

  @override
  String get removeWithQuestionMark => 'Удалить?';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return '$userEmail будет удалён из этого общего альбома\n\nВсе фото, добавленные этим пользователем, также будут удалены из альбома';
  }

  @override
  String get keepPhotos => 'Оставить фото';

  @override
  String get deletePhotos => 'Удалить фото';

  @override
  String get inviteToEnte => 'Пригласить в Ente';

  @override
  String get removePublicLink => 'Удалить публичную ссылку';

  @override
  String disableLinkMessage({required Object albumName}) {
    return 'Это удалит публичную ссылку для доступа к \"$albumName\".';
  }

  @override
  String get sharing => 'Отправка...';

  @override
  String get youCannotShareWithYourself =>
      'Вы не можете поделиться с самим собой';

  @override
  String get archive => 'Архив';

  @override
  String get createAlbumActionHint =>
      'Нажмите и удерживайте, чтобы выбрать фото, и нажмите «+», чтобы создать альбом';

  @override
  String get importing => 'Импортирование...';

  @override
  String get failedToLoadAlbums => 'Не удалось загрузить альбомы';

  @override
  String get hidden => 'Скрытые';

  @override
  String get authToViewYourHiddenFiles =>
      'Пожалуйста, авторизуйтесь для просмотра скрытых файлов';

  @override
  String get authToViewTrashedFiles =>
      'Пожалуйста, авторизуйтесь для просмотра удалённых файлов';

  @override
  String get trash => 'Корзина';

  @override
  String get uncategorized => 'Без категории';

  @override
  String get videoSmallCase => 'видео';

  @override
  String get photoSmallCase => 'фото';

  @override
  String get singleFileDeleteHighlight => 'Оно будет удалено из всех альбомов.';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return 'Это $fileType есть и в Ente, и на вашем устройстве.';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return 'Это $fileType будет удалено из Ente.';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return 'Это $fileType будет удалено с вашего устройства.';
  }

  @override
  String get deleteFromEnte => 'Удалить из Ente';

  @override
  String get yesDelete => 'Да, удалить';

  @override
  String get movedToTrash => 'Перемещено в корзину';

  @override
  String get deleteFromDevice => 'Удалить с устройства';

  @override
  String get deleteFromBoth => 'Удалить из обоих мест';

  @override
  String get newAlbum => 'Новый альбом';

  @override
  String get albums => 'Альбомы';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount воспоминаний',
      one: '$formattedCount воспоминание',
      zero: 'нет воспоминаний',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return '$count выбрано';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return '$count выбрано ($yourCount ваших)';
  }

  @override
  String get advancedSettings => 'Расширенные';

  @override
  String get photoGridSize => 'Размер сетки фото';

  @override
  String get manageDeviceStorage => 'Управление кэшем устройства';

  @override
  String get manageDeviceStorageDesc =>
      'Ознакомиться и очистить локальный кэш.';

  @override
  String get machineLearning => 'Машинное обучение';

  @override
  String get mlConsent => 'Включить машинное обучение';

  @override
  String get mlConsentTitle => 'Включить машинное обучение?';

  @override
  String get mlConsentDescription =>
      'Если вы включите машинное обучение, Ente будет извлекать информацию такую, как геометрия лица, из файлов, включая те, которыми с вами поделились.\n\nЭтот процесс будет происходить на вашем устройстве, и любая сгенерированная биометрическая информация будет защищена сквозным шифрованием.';

  @override
  String get mlConsentPrivacy =>
      'Пожалуйста, нажмите здесь для получения подробностей об этой функции в нашей политике конфиденциальности';

  @override
  String get mlConsentConfirmation =>
      'Я понимаю и хочу включить машинное обучение';

  @override
  String get magicSearch => 'Магический поиск';

  @override
  String get discover => 'Откройте для себя';

  @override
  String get discover_identity => 'Документы';

  @override
  String get discover_screenshots => 'Скриншоты';

  @override
  String get discover_receipts => 'Чеки';

  @override
  String get discover_notes => 'Заметки';

  @override
  String get discover_memes => 'Мемы';

  @override
  String get discover_visiting_cards => 'Визитки';

  @override
  String get discover_babies => 'Малыши';

  @override
  String get discover_pets => 'Питомцы';

  @override
  String get discover_selfies => 'Селфи';

  @override
  String get discover_wallpapers => 'Обои';

  @override
  String get discover_food => 'Еда';

  @override
  String get discover_celebrations => 'Праздники';

  @override
  String get discover_sunset => 'Закат';

  @override
  String get discover_hills => 'Холмы';

  @override
  String get discover_greenery => 'Зелень';

  @override
  String get mlIndexingDescription =>
      'Обратите внимание, что машинное обучение увеличит использование трафика и батареи, пока все элементы не будут проиндексированы. Рассмотрите использование приложения для компьютера для более быстрой индексации. Результаты будут автоматически синхронизированы.';

  @override
  String get loadingModel => 'Загрузка моделей...';

  @override
  String get waitingForWifi => 'Ожидание Wi-Fi...';

  @override
  String get status => 'Статус';

  @override
  String get indexedItems => 'Проиндексированные элементы';

  @override
  String get pendingItems => 'Элементы в очереди';

  @override
  String get clearIndexes => 'Удалить индексы';

  @override
  String get selectFoldersForBackup =>
      'Выберите папки для резервного копирования';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      'Выбранные папки будут зашифрованы и сохранены в резервной копии';

  @override
  String get unselectAll => 'Отменить выбор';

  @override
  String get selectAll => 'Выбрать все';

  @override
  String get skip => 'Пропустить';

  @override
  String get updatingFolderSelection => 'Обновление выбора папок...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count элементов',
      one: '$count элемент',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Удалить $count элементов',
      one: 'Удалить $count элемент',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count файлов, по $formattedSize каждый';
  }

  @override
  String get showMemories => 'Показывать воспоминания';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count лет назад',
      few: '$count года назад',
      one: '$count год назад',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'Настройки резервного копирования';

  @override
  String get backupStatus => 'Статус резервного копирования';

  @override
  String get backupStatusDescription =>
      'Элементы, сохранённые в резервной копии, появятся здесь';

  @override
  String get backupOverMobileData =>
      'Резервное копирование через мобильный интернет';

  @override
  String get backupVideos => 'Резервное копирование видео';

  @override
  String get disableAutoLock => 'Отключить автоблокировку';

  @override
  String get deviceLockExplanation =>
      'Отключить блокировку экрана устройства, когда Ente на экране, и выполняется резервное копирование. Обычно это не требуется, но это может ускорить завершение больших загрузок и первоначального импортирования крупных библиотек.';

  @override
  String get about => 'О программе';

  @override
  String get weAreOpenSource => 'У нас открытый исходный код!';

  @override
  String get privacy => 'Конфиденциальность';

  @override
  String get terms => 'Условия';

  @override
  String get checkForUpdates => 'Проверить обновления';

  @override
  String get checkStatus => 'Проверить статус';

  @override
  String get checking => 'Проверка...';

  @override
  String get youAreOnTheLatestVersion => 'Вы используете последнюю версию';

  @override
  String get account => 'Аккаунт';

  @override
  String get manageSubscription => 'Управление подпиской';

  @override
  String get authToChangeYourEmail =>
      'Пожалуйста, авторизуйтесь для смены электронной почты';

  @override
  String get changePassword => 'Сменить пароль';

  @override
  String get authToChangeYourPassword =>
      'Пожалуйста, авторизуйтесь для смены пароля';

  @override
  String get emailVerificationToggle => 'Подтверждение входа по почте';

  @override
  String get authToChangeEmailVerificationSetting =>
      'Пожалуйста, авторизуйтесь для изменения настроек подтверждения электронной почты';

  @override
  String get exportYourData => 'Экспортировать ваши данные';

  @override
  String get logout => 'Выйти';

  @override
  String get authToInitiateAccountDeletion =>
      'Пожалуйста, авторизуйтесь для начала процедуры удаления аккаунта';

  @override
  String get areYouSureYouWantToLogout => 'Вы уверены, что хотите выйти?';

  @override
  String get yesLogout => 'Да, выйти';

  @override
  String get aNewVersionOfEnteIsAvailable => 'Доступна новая версия Ente.';

  @override
  String get update => 'Обновить';

  @override
  String get installManually => 'Установить вручную';

  @override
  String get criticalUpdateAvailable => 'Доступно критическое обновление';

  @override
  String get updateAvailable => 'Доступно обновление';

  @override
  String get ignoreUpdate => 'Игнорировать';

  @override
  String get downloading => 'Скачивание...';

  @override
  String get cannotDeleteSharedFiles => 'Нельзя удалить общие файлы';

  @override
  String get theDownloadCouldNotBeCompleted =>
      'Скачивание не может быть завершено';

  @override
  String get retry => 'Повторить';

  @override
  String get backedUpFolders => 'Папки для резервного копирования';

  @override
  String get backup => 'Резервное копирование';

  @override
  String get freeUpDeviceSpace => 'Освободить место на устройстве';

  @override
  String get freeUpDeviceSpaceDesc =>
      'Освободите место на устройстве, удалив файлы, которые уже сохранены в резервной копии.';

  @override
  String get allClear => '✨ Всё чисто';

  @override
  String get noDeviceThatCanBeDeleted =>
      'На этом устройстве нет файлов, которые можно удалить';

  @override
  String get removeDuplicates => 'Удалить дубликаты';

  @override
  String get removeDuplicatesDesc =>
      'Проверьте и удалите файлы, которые являются точными дубликатами.';

  @override
  String get viewLargeFiles => 'Большие файлы';

  @override
  String get viewLargeFilesDesc =>
      'Узнайте, какие файлы занимают больше всего места.';

  @override
  String get noDuplicates => '✨ Дубликатов нет';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared =>
      'У вас нет дубликатов файлов, которые можно удалить';

  @override
  String get success => 'Успех';

  @override
  String get rateUs => 'Оцените нас';

  @override
  String get remindToEmptyDeviceTrash =>
      'Также очистите «Недавно удалённые» в «Настройки» → «Хранилище», чтобы освободить место';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return 'Вы успешно освободили $storageSaved!';
  }

  @override
  String get remindToEmptyEnteTrash =>
      'Также очистите «Корзину», чтобы освободить место';

  @override
  String get sparkleSuccess => '✨ Успех';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count дубликатов',
      one: '$count дубликат',
    );
    return 'Вы удалили $_temp0, освободив ($storageSaved!)';
  }

  @override
  String get familyPlans => 'Семейные тарифы';

  @override
  String get referrals => 'Рефералы';

  @override
  String get notifications => 'Уведомления';

  @override
  String get sharedPhotoNotifications => 'Новые общие фото';

  @override
  String get sharedPhotoNotificationsExplanation =>
      'Получать уведомления, когда кто-то добавляет фото в общий альбом, в котором вы состоите';

  @override
  String get advanced => 'Расширенные';

  @override
  String get general => 'Общие';

  @override
  String get security => 'Безопасность';

  @override
  String get authToViewYourRecoveryKey =>
      'Пожалуйста, авторизуйтесь для просмотра ключа восстановления';

  @override
  String get twofactor => 'Двухфакторная аутентификация';

  @override
  String get authToConfigureTwofactorAuthentication =>
      'Пожалуйста, авторизуйтесь для настройки двухфакторной аутентификации';

  @override
  String get lockscreen => 'Экран блокировки';

  @override
  String get authToChangeLockscreenSetting =>
      'Пожалуйста, авторизуйтесь для изменения настроек экрана блокировки';

  @override
  String get viewActiveSessions => 'Просмотр активных сессий';

  @override
  String get authToViewYourActiveSessions =>
      'Пожалуйста, авторизуйтесь для просмотра активных сессий';

  @override
  String get disableTwofactor => 'Отключить двухфакторную аутентификацию';

  @override
  String get confirm2FADisable =>
      'Вы уверены, что хотите отключить двухфакторную аутентификацию?';

  @override
  String get no => 'Нет';

  @override
  String get yes => 'Да';

  @override
  String get social => 'Социальные сети';

  @override
  String rateUsOnStore({required Object storeName}) {
    return 'Оцените нас в $storeName';
  }

  @override
  String get blog => 'Блог';

  @override
  String get merchandise => 'Мерч';

  @override
  String get twitter => 'X (Ранее Twitter)';

  @override
  String get mastodon => 'Mastodon';

  @override
  String get matrix => 'Matrix';

  @override
  String get discord => 'Discord';

  @override
  String get reddit => 'Reddit';

  @override
  String get yourStorageDetailsCouldNotBeFetched =>
      'Не удалось получить данные о вашем хранилище';

  @override
  String get reportABug => 'Сообщить об ошибке';

  @override
  String get reportBug => 'Сообщить об ошибке';

  @override
  String get suggestFeatures => 'Предложить идею';

  @override
  String get support => 'Поддержка';

  @override
  String get theme => 'Тема';

  @override
  String get lightTheme => 'Светлая';

  @override
  String get darkTheme => 'Тёмная';

  @override
  String get systemTheme => 'Системная';

  @override
  String get freeTrial => 'Бесплатный пробный период';

  @override
  String get selectYourPlan => 'Выберите тариф';

  @override
  String get enteSubscriptionPitch =>
      'Ente сохраняет ваши воспоминания, чтобы они всегда были доступны вам, даже если вы потеряете устройство.';

  @override
  String get enteSubscriptionShareWithFamily =>
      'Ваша семья также может быть включена в ваш тариф.';

  @override
  String get currentUsageIs => 'Текущее использование составляет ';

  @override
  String get faqs => 'Часто задаваемые вопросы';

  @override
  String renewsOn({required Object endDate}) {
    return 'Подписка будет продлена $endDate';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return 'Бесплатный пробный период действителен до $endDate';
  }

  @override
  String validTill({required Object endDate}) {
    return 'Действительно до $endDate';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return 'Ваше дополнение на $storageAmount действительно до $endDate';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return 'Бесплатный пробный период действителен до $endDate.\nПосле этого вы можете выбрать платный тариф.';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'Ваша подписка будет отменена $endDate';
  }

  @override
  String get subscription => 'Подписка';

  @override
  String get paymentDetails => 'Платёжные данные';

  @override
  String get manageFamily => 'Управление семьёй';

  @override
  String contactToManageSubscription({required Object provider}) {
    return 'Пожалуйста, свяжитесь с нами по адресу support@ente.io для управления вашей подпиской $provider.';
  }

  @override
  String get renewSubscription => 'Продлить подписку';

  @override
  String get cancelSubscription => 'Отменить подписку';

  @override
  String get areYouSureYouWantToRenew => 'Вы уверены, что хотите продлить?';

  @override
  String get yesRenew => 'Да, продлить';

  @override
  String get areYouSureYouWantToCancel => 'Вы уверены, что хотите отменить?';

  @override
  String get yesCancel => 'Да, отменить';

  @override
  String get failedToRenew => 'Не удалось продлить';

  @override
  String get failedToCancel => 'Не удалось отменить';

  @override
  String get twoMonthsFreeOnYearlyPlans =>
      '2 месяца в подарок на годовом тарифе';

  @override
  String get monthly => 'Ежемесячно';

  @override
  String get yearly => 'Ежегодно';

  @override
  String get confirmPlanChange => 'Подтвердить смену тарифа';

  @override
  String get areYouSureYouWantToChangeYourPlan =>
      'Вы уверены, что хотите сменить тариф?';

  @override
  String get youCannotDowngradeToThisPlan =>
      'Вы не можете понизить до этого тарифа';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'Пожалуйста, сначала отмените существующую подписку через $paymentProvider';
  }

  @override
  String get optionalAsShortAsYouLike =>
      'Необязательно, насколько коротко пожелаете...';

  @override
  String get send => 'Отправить';

  @override
  String get askCancelReason =>
      'Ваша подписка была отменена. Не хотели бы вы поделиться причиной?';

  @override
  String get thankYouForSubscribing => 'Спасибо за подписку!';

  @override
  String get yourPurchaseWasSuccessful => 'Ваша покупка прошла успешно';

  @override
  String get yourPlanWasSuccessfullyUpgraded => 'Ваш тариф успешно повышен';

  @override
  String get yourPlanWasSuccessfullyDowngraded => 'Ваш тариф успешно понижен';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully =>
      'Ваша подписка успешно обновлена';

  @override
  String get googlePlayId => 'Идентификатор Google Play';

  @override
  String get appleId => 'Идентификатор Apple';

  @override
  String get playstoreSubscription => 'Подписка PlayStore';

  @override
  String get appstoreSubscription => 'Подписка AppStore';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return 'Ваш $id уже связан с другим аккаунтом Ente.\nЕсли вы хотите использовать $id с этим аккаунтом, пожалуйста, свяжитесь с нашей службой поддержки';
  }

  @override
  String get visitWebToManage =>
      'Пожалуйста, посетите web.ente.io для управления вашей подпиской';

  @override
  String get couldNotUpdateSubscription => 'Не удалось обновить подписку';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      'Пожалуйста, свяжитесь с support@ente.io, и мы будем рады помочь!';

  @override
  String get paymentFailed => 'Платёж не удался';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return 'Пожалуйста, обратитесь в поддержку $providerName, если с вас сняли деньги';
  }

  @override
  String get continueOnFreeTrial => 'Продолжить с бесплатным пробным периодом';

  @override
  String get areYouSureYouWantToExit => 'Вы уверены, что хотите выйти?';

  @override
  String get thankYou => 'Спасибо';

  @override
  String get failedToVerifyPaymentStatus =>
      'Не удалось проверить статус платежа';

  @override
  String get pleaseWaitForSometimeBeforeRetrying =>
      'Пожалуйста, подождите некоторое время перед повторной попыткой';

  @override
  String get paymentFailedMessage =>
      'К сожалению, ваш платёж не удался. Пожалуйста, свяжитесь с поддержкой, и мы вам поможем!';

  @override
  String get youAreOnAFamilyPlan => 'Вы на семейном тарифе!';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'Пожалуйста, свяжитесь с <green>$familyAdminEmail</green> для управления подпиской';
  }

  @override
  String get leaveFamily => 'Покинуть семью';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily =>
      'Вы уверены, что хотите покинуть семейный тариф?';

  @override
  String get leave => 'Покинуть';

  @override
  String get rateTheApp => 'Оценить приложение';

  @override
  String get startBackup => 'Начать резервное копирование';

  @override
  String get noPhotosAreBeingBackedUpRightNow =>
      'В данный момент фото не копируются';

  @override
  String get preserveMore => 'Сохранить больше';

  @override
  String get grantFullAccessPrompt =>
      'Пожалуйста, разрешите доступ ко всем фото в настройках устройства';

  @override
  String get allowPermTitle => 'Разрешить доступ к фото';

  @override
  String get allowPermBody =>
      'Пожалуйста, разрешите доступ к вашим фото через настройки устройства, чтобы Ente мог отображать и сохранять вашу библиотеку.';

  @override
  String get openSettings => 'Открыть настройки';

  @override
  String get selectMorePhotos => 'Выбрать больше фото';

  @override
  String get existingUser => 'Существующий пользователь';

  @override
  String get privateBackups => 'Защищённые резервные копии';

  @override
  String get forYourMemories => 'для ваших воспоминаний';

  @override
  String get endtoendEncryptedByDefault => 'Сквозное шифрование по умолчанию';

  @override
  String get safelyStored => 'Надёжно сохранены';

  @override
  String get atAFalloutShelter => 'в бункере';

  @override
  String get designedToOutlive => 'Создано на века';

  @override
  String get available => 'Доступно';

  @override
  String get everywhere => 'везде';

  @override
  String get androidIosWebDesktop => 'Android, iOS, браузер, компьютер';

  @override
  String get mobileWebDesktop => 'Смартфон, браузер, компьютер';

  @override
  String get newToEnte => 'Впервые в Ente';

  @override
  String get pleaseLoginAgain => 'Пожалуйста, войдите снова';

  @override
  String get autoLogoutMessage =>
      'Из-за технического сбоя вы были выведены из системы. Приносим извинения за неудобства.';

  @override
  String get yourSubscriptionHasExpired => 'Срок действия вашей подписки истёк';

  @override
  String get storageLimitExceeded => 'Превышен лимит хранилища';

  @override
  String get upgrade => 'Улучшить';

  @override
  String get raiseTicket => 'Создать запрос';

  @override
  String get backupFailed => 'Резервное копирование не удалось';

  @override
  String get sorryBackupFailedDesc =>
      'К сожалению, мы не смогли сделать резервную копию этого файла сейчас, мы повторим попытку позже.';

  @override
  String get couldNotBackUpTryLater =>
      'Нам не удалось создать резервную копию ваших данных.\nМы повторим попытку позже.';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      'Ente может шифровать и сохранять файлы, только если вы предоставите к ним доступ';

  @override
  String get pleaseGrantPermissions => 'Пожалуйста, предоставьте разрешения';

  @override
  String get grantPermission => 'Предоставить разрешение';

  @override
  String get privateSharing => 'Защищённый обмен';

  @override
  String get shareOnlyWithThePeopleYouWant =>
      'Делитесь только с теми, с кем хотите';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      'Используйте публичные ссылки для людей, не использующих Ente';

  @override
  String get allowPeopleToAddPhotos => 'Разрешить людям добавлять фото';

  @override
  String get shareAnAlbumNow => 'Поделиться альбомом';

  @override
  String get collectEventPhotos => 'Собрать фото с мероприятия';

  @override
  String get sessionExpired => 'Сессия истекла';

  @override
  String get loggingOut => 'Выход...';

  @override
  String get onDevice => 'На устройстве';

  @override
  String get onEnte => 'В <branding>ente</branding>';

  @override
  String get name => 'Имя';

  @override
  String get newest => 'Недавние';

  @override
  String get lastUpdated => 'Последнее обновление';

  @override
  String get deleteEmptyAlbums => 'Удалить пустые альбомы';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => 'Удалить пустые альбомы?';

  @override
  String get deleteAlbumsDialogBody =>
      'Это удалит все пустые альбомы. Это может быть полезно, если вы хотите навести порядок в списке альбомов.';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return 'Удаление $currentlyDeleting / $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return 'Обработка $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => 'Удалить безвозвратно';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou =>
      'Можно создать ссылку только для ваших файлов';

  @override
  String get publicLinkCreated => 'Публичная ссылка создана';

  @override
  String get youCanManageYourLinksInTheShareTab =>
      'Вы можете управлять своими ссылками на вкладке «Поделиться».';

  @override
  String get linkCopiedToClipboard => 'Ссылка скопирована в буфер обмена';

  @override
  String get restore => 'Восстановить';

  @override
  String get moveToAlbum => 'Переместить в альбом';

  @override
  String get unhide => 'Не скрывать';

  @override
  String get unarchive => 'Извлечь из архива';

  @override
  String get favorite => 'В избранное';

  @override
  String get removeFromFavorite => 'Убрать из избранного';

  @override
  String get shareLink => 'Поделиться ссылкой';

  @override
  String get createCollage => 'Создать коллаж';

  @override
  String get saveCollage => 'Сохранить коллаж';

  @override
  String get collageSaved => 'Коллаж сохранён в галерее';

  @override
  String get collageLayout => 'Макет';

  @override
  String get addToEnte => 'Добавить в Ente';

  @override
  String get addToAlbum => 'Добавить в альбом';

  @override
  String get delete => 'Удалить';

  @override
  String get hide => 'Скрыть';

  @override
  String get share => 'Поделиться';

  @override
  String get unhideToAlbum => 'Перенести в альбом';

  @override
  String get restoreToAlbum => 'Восстановить в альбом';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Переместить элементы',
      one: 'Переместить элемент',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Добавить элементы',
      one: 'Добавить элемент',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'Создать или выбрать альбом';

  @override
  String get selectAlbum => 'Выбрать альбом';

  @override
  String get searchByAlbumNameHint => 'Название альбома';

  @override
  String get albumTitle => 'Название альбома';

  @override
  String get enterAlbumName => 'Введите название альбома';

  @override
  String get restoringFiles => 'Восстановление файлов...';

  @override
  String get movingFilesToAlbum => 'Перемещение файлов в альбом...';

  @override
  String get unhidingFilesToAlbum => 'Перенос файлов в альбом';

  @override
  String get canNotUploadToAlbumsOwnedByOthers =>
      'Нельзя загружать в альбомы, принадлежащие другим';

  @override
  String get uploadingFilesToAlbum => 'Загрузка файлов в альбом...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return 'Успешно добавлено в $albumName';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return 'Успешно перемещено в $albumName';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'У этого альбома уже есть совместная ссылка';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return 'Совместная ссылка создана для $albumName';
  }

  @override
  String get askYourLovedOnesToShare => 'Попросите близких поделиться';

  @override
  String get invite => 'Пригласить';

  @override
  String get shareYourFirstAlbum => 'Поделитесь своим первым альбомом';

  @override
  String sharedWith({required Object emailIDs}) {
    return 'Доступен для $emailIDs';
  }

  @override
  String get sharedWithMe => 'Со мной поделились';

  @override
  String get sharedByMe => 'Я поделился';

  @override
  String get doubleYourStorage => 'Удвойте своё хранилище';

  @override
  String get referFriendsAnd2xYourPlan =>
      'Пригласите друзей и удвойте свой тариф';

  @override
  String get shareAlbumHint =>
      'Откройте альбом и нажмите кнопку «Поделиться» в правом верхнем углу, чтобы поделиться.';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      'На элементах отображается количество дней, оставшихся до их безвозвратного удаления';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count дней',
      one: '1 день',
      zero: 'Скоро',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => 'Удалить всё';

  @override
  String get renameAlbum => 'Переименовать альбом';

  @override
  String get convertToAlbum => 'Преобразовать в альбом';

  @override
  String get setCover => 'Установить обложку';

  @override
  String get sortAlbumsBy => 'Сортировать по';

  @override
  String get sortNewestFirst => 'Сначала новые';

  @override
  String get sortOldestFirst => 'Сначала старые';

  @override
  String get rename => 'Переименовать';

  @override
  String get leaveSharedAlbum => 'Покинуть общий альбом?';

  @override
  String get leaveAlbum => 'Покинуть альбом';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'Добавленные вами фото будут удалены из альбома';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted =>
      'В этом альбоме нет файлов, которые можно удалить';

  @override
  String get youDontHaveAnyArchivedItems => 'У вас нет архивных элементов.';

  @override
  String get ignoredFolderUploadReason =>
      'Некоторые файлы в этом альбоме игнорируются, так как ранее они были удалены из Ente.';

  @override
  String get resetIgnoredFiles => 'Сбросить игнорируемые файлы';

  @override
  String get deviceFilesAutoUploading =>
      'Файлы, добавленные в этот альбом на устройстве, будут автоматически загружены в Ente.';

  @override
  String get turnOnBackupForAutoUpload =>
      'Включите резервное копирование, чтобы автоматически загружать файлы из этой папки на устройстве в Ente.';

  @override
  String get noHiddenPhotosOrVideos => 'Нет скрытых фото или видео';

  @override
  String get toHideAPhotoOrVideo => 'Скрыть фото или видео';

  @override
  String get openTheItem => '• Откройте элемент';

  @override
  String get clickOnTheOverflowMenu =>
      '• Нажмите на меню дополнительных действий';

  @override
  String get click => '• Нажмите';

  @override
  String get nothingToSeeHere => 'Здесь ничего нет! 👀';

  @override
  String get unarchiveAlbum => 'Извлечь альбом из архива';

  @override
  String get archiveAlbum => 'Архивировать альбом';

  @override
  String get calculating => 'Подсчёт...';

  @override
  String get pleaseWaitDeletingAlbum =>
      'Пожалуйста, подождите, альбом удаляется';

  @override
  String get searchByExamples =>
      '• Названия альбомов (например, «Камера»)\n• Типы файлов (например, «Видео», «.gif»)\n• Годы и месяцы (например, «2022», «Январь»)\n• Праздники (например, «Рождество»)\n• Описания фото (например, «#веселье»)';

  @override
  String get youCanTrySearchingForADifferentQuery =>
      'Вы можете попробовать выполнить поиск по другому запросу.';

  @override
  String get noResultsFound => 'Нет результатов';

  @override
  String addedBy({required Object emailOrName}) {
    return 'Добавлено $emailOrName';
  }

  @override
  String get loadingExifData => 'Загрузка данных EXIF...';

  @override
  String get viewAllExifData => 'Посмотреть все данные EXIF';

  @override
  String get noExifData => 'Нет данных EXIF';

  @override
  String get thisImageHasNoExifData => 'Это фото не имеет данных EXIF';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => 'Нет результатов';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'Мы не поддерживаем редактирование фото и альбомов, которые вам пока не принадлежат';

  @override
  String get failedToFetchOriginalForEdit =>
      'Не удалось скачать оригинал для редактирования';

  @override
  String get close => 'Закрыть';

  @override
  String get setAs => 'Установить как';

  @override
  String get fileSavedToGallery => 'Файл сохранён в галерею';

  @override
  String get filesSavedToGallery => 'Файлы сохранены в галерею';

  @override
  String get fileFailedToSaveToGallery => 'Не удалось сохранить файл в галерею';

  @override
  String get download => 'Скачать';

  @override
  String get pressAndHoldToPlayVideo =>
      'Нажмите и удерживайте для воспроизведения видео';

  @override
  String get pressAndHoldToPlayVideoDetailed =>
      'Нажмите с удержанием на изображение для воспроизведения видео';

  @override
  String get downloadFailed => 'Скачивание не удалось';

  @override
  String get deduplicateFiles => 'Удалить дубликаты файлов';

  @override
  String get deselectAll => 'Отменить выделение';

  @override
  String get reviewDeduplicateItems =>
      'Пожалуйста, проверьте и удалите элементы, которые считаете дубликатами.';

  @override
  String get clubByCaptureTime => 'Группировать по времени съёмки';

  @override
  String get clubByFileName => 'Группировать по имени файла';

  @override
  String get count => 'Количество';

  @override
  String get totalSize => 'Общий размер';

  @override
  String get longpressOnAnItemToViewInFullscreen =>
      'Нажмите с удержанием на элемент для просмотра в полноэкранном режиме';

  @override
  String get decryptingVideo => 'Расшифровка видео...';

  @override
  String get authToViewYourMemories =>
      'Пожалуйста, авторизуйтесь для просмотра воспоминаний';

  @override
  String get unlock => 'Разблокировать';

  @override
  String get freeUpSpace => 'Освободить место';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Их можно удалить с устройства, чтобы освободить $formattedSize',
      one: 'Его можно удалить с устройства, чтобы освободить $formattedSize',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber файлов в этом альбоме были успешно сохранены',
      one: '$formattedNumber файл в этом альбоме был успешно сохранён',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other:
          '$formattedNumber файлов на этом устройстве были успешно сохранены',
      one: '$formattedNumber файл на этом устройстве был успешно сохранён',
    );
    return '$_temp0';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'ним',
      one: 'нему',
    );
    return 'Вы всё ещё сможете получить доступ к $_temp0 в Ente, пока у вас активна подписка';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return 'Освободить $sizeInMBorGB';
  }

  @override
  String get thisEmailIsAlreadyInUse =>
      'Эта электронная почта уже используется';

  @override
  String get incorrectCode => 'Неверный код';

  @override
  String get authenticationFailedPleaseTryAgain =>
      'Аутентификация не удалась, пожалуйста, попробуйте снова';

  @override
  String get verificationFailedPleaseTryAgain =>
      'Проверка не удалась, пожалуйста, попробуйте снова';

  @override
  String get authenticating => 'Аутентификация...';

  @override
  String get authenticationSuccessful => 'Аутентификация прошла успешно!';

  @override
  String get incorrectRecoveryKey => 'Неверный ключ восстановления';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect =>
      'Введённый вами ключ восстановления неверен';

  @override
  String get twofactorAuthenticationSuccessfullyReset =>
      'Двухфакторная аутентификация успешно сброшена';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered =>
      'Пожалуйста, проверьте введённый вами код';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      'Пожалуйста, обратитесь в поддержку, если проблема сохраняется';

  @override
  String get twofactorAuthenticationHasBeenDisabled =>
      'Двухфакторная аутентификация отключена';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect =>
      'Извините, введённый вами код неверен';

  @override
  String get yourVerificationCodeHasExpired =>
      'Срок действия вашего кода подтверждения истёк';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'Электронная почта изменена на $newEmail';
  }

  @override
  String get verifying => 'Проверка...';

  @override
  String get disablingTwofactorAuthentication =>
      'Отключение двухфакторной аутентификации...';

  @override
  String get allMemoriesPreserved => 'Все воспоминания сохранены';

  @override
  String get loadingGallery => 'Загрузка галереи...';

  @override
  String get syncing => 'Синхронизация...';

  @override
  String get encryptingBackup => 'Шифрование резервной копии...';

  @override
  String get syncStopped => 'Синхронизация остановлена';

  @override
  String syncProgress({required String completed, required String total}) {
    return '$completed/$total воспоминаний сохранено';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return 'Сохранение $count воспоминаний...';
  }

  @override
  String get uploadingSingleMemory => 'Сохранение 1 воспоминания...';

  @override
  String get archiving => 'Архивация...';

  @override
  String get unarchiving => 'Извлечение...';

  @override
  String get successfullyArchived => 'Успешно архивировано';

  @override
  String get successfullyUnarchived => 'Успешно извлечено';

  @override
  String get renameFile => 'Переименовать файл';

  @override
  String get enterFileName => 'Введите название файла';

  @override
  String get filesDeleted => 'Файлы удалены';

  @override
  String get selectedFilesAreNotOnEnte => 'Выбранные файлы отсутствуют в Ente';

  @override
  String get thisActionCannotBeUndone => 'Это действие нельзя отменить';

  @override
  String get emptyTrash => 'Очистить корзину?';

  @override
  String get permDeleteWarning =>
      'Все элементы в корзине будут удалены навсегда\n\nЭто действие нельзя отменить';

  @override
  String get empty => 'Очистить';

  @override
  String get couldNotFreeUpSpace => 'Не удалось освободить место';

  @override
  String get permanentlyDeleteFromDevice =>
      'Удалить с устройства безвозвратно?';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      'Некоторые файлы, которые вы пытаетесь удалить, доступны только на вашем устройстве и не могут быть восстановлены после удаления';

  @override
  String get theyWillBeDeletedFromAllAlbums =>
      'Они будут удалены из всех альбомов.';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'Некоторые элементы находятся как в Ente, так и на вашем устройстве.';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      'Выбранные элементы будут удалены из всех альбомов и перемещены в корзину.';

  @override
  String get theseItemsWillBeDeletedFromYourDevice =>
      'Эти элементы будут удалены с вашего устройства.';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      'Похоже, что-то пошло не так. Пожалуйста, повторите попытку через некоторое время. Если ошибка сохраняется, обратитесь в нашу службу поддержки.';

  @override
  String get error => 'Ошибка';

  @override
  String get tempErrorContactSupportIfPersists =>
      'Похоже, что-то пошло не так. Пожалуйста, повторите попытку через некоторое время. Если ошибка сохраняется, обратитесь в нашу службу поддержки.';

  @override
  String get networkHostLookUpErr =>
      'Не удалось подключиться к Ente. Проверьте настройки сети и обратитесь в поддержку, если ошибка сохраняется.';

  @override
  String get networkConnectionRefusedErr =>
      'Не удалось подключиться к Ente. Повторите попытку через некоторое время. Если ошибка сохраняется, обратитесь в поддержку.';

  @override
  String get cachedData => 'Кэшированные данные';

  @override
  String get clearCaches => 'Очистить кэш';

  @override
  String get remoteImages => 'Изображения вне устройства';

  @override
  String get remoteVideos => 'Видео вне устройства';

  @override
  String get remoteThumbnails => 'Миниатюры вне устройства';

  @override
  String get pendingSync => 'Ожидание синхронизации';

  @override
  String get localGallery => 'Локальная галерея';

  @override
  String get todaysLogs => 'Сегодняшние логи';

  @override
  String get viewLogs => 'Просмотреть логи';

  @override
  String get logsDialogBody =>
      'Это отправит нам логи, чтобы помочь разобраться с вашей проблемой. Обратите внимание, что имена файлов будут включены для отслеживания проблем с конкретными файлами.';

  @override
  String get preparingLogs => 'Подготовка логов...';

  @override
  String get emailYourLogs => 'Отправить логи по электронной почте';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'Пожалуйста, отправьте логи на \n$toEmail';
  }

  @override
  String get copyEmailAddress => 'Скопировать адрес электронной почты';

  @override
  String get exportLogs => 'Экспортировать логи';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return 'Пожалуйста, напишите нам на $toEmail';
  }

  @override
  String get dismiss => 'Отклонить';

  @override
  String get didYouKnow => 'Знаете ли вы?';

  @override
  String get loadingMessage => 'Загрузка ваших фото...';

  @override
  String get loadMessage1 => 'Вы можете поделиться подпиской с вашей семьёй';

  @override
  String get loadMessage2 =>
      'На сегодняшний день мы сохранили более 200 миллионов воспоминаний';

  @override
  String get loadMessage3 =>
      'Мы храним 3 копии ваших данных, одну из них — в бункере';

  @override
  String get loadMessage4 => 'Все наши приложения имеют открытый исходный код';

  @override
  String get loadMessage5 =>
      'Наш исходный код и криптография прошли внешний аудит';

  @override
  String get loadMessage6 =>
      'Вы можете делиться ссылками на свои альбомы с близкими';

  @override
  String get loadMessage7 =>
      'Наши мобильные приложения работают в фоновом режиме, чтобы шифровать и сохранять все новые фото, которые вы снимаете';

  @override
  String get loadMessage8 => 'На web.ente.io есть удобный загрузчик';

  @override
  String get loadMessage9 =>
      'Мы используем Xchacha20Poly1305 для безопасного шифрования ваших данных';

  @override
  String get photoDescriptions => 'Описания фото';

  @override
  String get fileTypesAndNames => 'Типы и названия файлов';

  @override
  String get location => 'Местоположение';

  @override
  String get moments => 'Моменты';

  @override
  String get searchFaceEmptySection =>
      'Люди появятся здесь после завершения индексации';

  @override
  String get searchDatesEmptySection => 'Ищите по дате, месяцу или году';

  @override
  String get searchLocationEmptySection =>
      'Группируйте фото, снятые в определённом радиусе от фото';

  @override
  String get searchPeopleEmptySection =>
      'Приглашайте людей, и здесь появятся все фото, которыми они поделились';

  @override
  String get searchAlbumsEmptySection => 'Альбомы';

  @override
  String get searchFileTypesAndNamesEmptySection => 'Типы и названия файлов';

  @override
  String get searchCaptionEmptySection =>
      'Добавляйте описания вроде «#поездка» в информацию о фото, чтобы быстро находить их здесь';

  @override
  String get language => 'Язык';

  @override
  String get selectLanguage => 'Выберите язык';

  @override
  String get locationName => 'Название местоположения';

  @override
  String get addLocation => 'Добавить местоположение';

  @override
  String get groupNearbyPhotos => 'Группировать ближайшие фото';

  @override
  String get kiloMeterUnit => 'км';

  @override
  String get addLocationButton => 'Добавить';

  @override
  String get radius => 'Радиус';

  @override
  String get locationTagFeatureDescription =>
      'Тег местоположения группирует все фото, снятые в определённом радиусе от фото';

  @override
  String get galleryMemoryLimitInfo =>
      'В галерее отображается до 1000 воспоминаний';

  @override
  String get save => 'Сохранить';

  @override
  String get centerPoint => 'Центральная точка';

  @override
  String get pickCenterPoint => 'Выбрать центральную точку';

  @override
  String get useSelectedPhoto => 'Использовать выбранное фото';

  @override
  String get resetToDefault => 'Вернуть стандартную';

  @override
  String get edit => 'Редактировать';

  @override
  String get deleteLocation => 'Удалить местоположение';

  @override
  String get rotateLeft => 'Повернуть влево';

  @override
  String get flip => 'Отразить';

  @override
  String get rotateRight => 'Повернуть вправо';

  @override
  String get saveCopy => 'Сохранить копию';

  @override
  String get light => 'Яркость';

  @override
  String get color => 'Цвет';

  @override
  String get yesDiscardChanges => 'Да, отменить изменения';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade =>
      'Хотите отменить сделанные изменения?';

  @override
  String get saving => 'Сохранение...';

  @override
  String get editsSaved => 'Изменения сохранены';

  @override
  String get oopsCouldNotSaveEdits => 'Ой, не удалось сохранить изменения';

  @override
  String get distanceInKMUnit => 'км';

  @override
  String get dayToday => 'Сегодня';

  @override
  String get dayYesterday => 'Вчера';

  @override
  String get storage => 'Хранилище';

  @override
  String get usedSpace => 'Использовано места';

  @override
  String get storageBreakupFamily => 'Семья';

  @override
  String get storageBreakupYou => 'Вы';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return 'Использовано $usedAmount $usedStorageUnit из $totalAmount $totalStorageUnit';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return 'Свободно $freeAmount $storageUnit';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'Версия: $versionValue';
  }

  @override
  String get verifyIDLabel => 'Подтвердить';

  @override
  String get fileInfoAddDescHint => 'Добавить описание...';

  @override
  String get editLocationTagTitle => 'Изменить местоположение';

  @override
  String get setLabel => 'Установить';

  @override
  String get setRadius => 'Установить радиус';

  @override
  String get familyPlanPortalTitle => 'Семья';

  @override
  String get familyPlanOverview =>
      'Добавьте 5 членов семьи к существующему тарифу без дополнительной оплаты.\n\nКаждый участник получает своё личное пространство и не может видеть файлы других, если они не общедоступны.\n\nСемейные тарифы доступны клиентам с платной подпиской на Ente.\n\nПодпишитесь сейчас, чтобы начать!';

  @override
  String get androidBiometricHint => 'Подтвердите личность';

  @override
  String get androidBiometricNotRecognized =>
      'Не распознано. Попробуйте снова.';

  @override
  String get androidBiometricSuccess => 'Успешно';

  @override
  String get androidCancelButton => 'Отмена';

  @override
  String get androidSignInTitle => 'Требуется аутентификация';

  @override
  String get androidBiometricRequiredTitle => 'Требуется биометрия';

  @override
  String get androidDeviceCredentialsRequiredTitle =>
      'Требуются учётные данные устройства';

  @override
  String get androidDeviceCredentialsSetupDescription =>
      'Требуются учётные данные устройства';

  @override
  String get goToSettings => 'Перейти в настройки';

  @override
  String get androidGoToSettingsDescription =>
      'Биометрическая аутентификация не настроена. Перейдите в «Настройки» → «Безопасность», чтобы добавить её.';

  @override
  String get iOSLockOut =>
      'Биометрическая аутентификация отключена. Пожалуйста, заблокируйте и разблокируйте экран, чтобы включить её.';

  @override
  String get iOSGoToSettingsDescription =>
      'Биометрическая аутентификация не настроена. Пожалуйста, включите Touch ID или Face ID на вашем устройстве.';

  @override
  String get iOSOkButton => 'Хорошо';

  @override
  String get openstreetmapContributors => 'Участники OpenStreetMap';

  @override
  String get hostedAtOsmFrance => 'Размещено на OSM France';

  @override
  String get map => 'Карта';

  @override
  String get maps => 'Карты';

  @override
  String get mapsPrivacyNotice =>
      'Приблизительные координаты будут отправлены заботящимся о конфиденциальности третьим сторонам, таким как OpenStreetMap, для отображения карты и местоположения.';

  @override
  String get enableMaps => 'Включить Карты';

  @override
  String get quickLinks => 'Быстрые ссылки';

  @override
  String get selectItemsToAdd => 'Выберите элементы для добавления';

  @override
  String get addSelected => 'Добавить выбранные';

  @override
  String get addFromDevice => 'Добавить с устройства';

  @override
  String get addPhotos => 'Добавить фото';

  @override
  String get noPhotosFoundHere => 'Здесь фото не найдены';

  @override
  String get zoomOutToSeePhotos => 'Уменьшите масштаб, чтобы увидеть фото';

  @override
  String get noImagesWithLocation => 'Нет фото с местоположением';

  @override
  String get unpinAlbum => 'Открепить альбом';

  @override
  String get pinAlbum => 'Закрепить альбом';

  @override
  String get pin => 'Прикрепить';

  @override
  String get pinPerson => 'Pin person';

  @override
  String get pinToTop => 'Закрепить сверху';

  @override
  String get unpin => 'Открепить';

  @override
  String get unpinPerson => 'Unpin person';

  @override
  String get visibility => 'Видимость';

  @override
  String get hideFromMemories => 'Скрыть из воспоминаний';

  @override
  String get showInMemories => 'Show in memories';

  @override
  String get create => 'Создать';

  @override
  String get viewAll => 'Посмотреть все';

  @override
  String get nothingSharedWithYouYet => 'С вами пока ничем не поделились';

  @override
  String get noAlbumsSharedByYouYet => 'Вы пока не делились альбомами';

  @override
  String get sharedWithYou => 'Поделились с вами';

  @override
  String get sharedByYou => 'Вы поделились';

  @override
  String get inviteYourFriendsToEnte => 'Пригласите друзей в Ente';

  @override
  String get failedToDownloadVideo => 'Не удалось скачать видео';

  @override
  String get hiding => 'Скрытие...';

  @override
  String get unhiding => 'Раскрытие...';

  @override
  String get successfullyHid => 'Успешно скрыто';

  @override
  String get successfullyUnhid => 'Успешно раскрыто';

  @override
  String get crashReporting => 'Отчёты об ошибках';

  @override
  String get resumableUploads => 'Возобновляемые загрузки';

  @override
  String get addToHiddenAlbum => 'Добавить в скрытый альбом';

  @override
  String get moveToHiddenAlbum => 'Переместить в скрытый альбом';

  @override
  String get fileTypes => 'Типы файлов';

  @override
  String get deleteConfirmDialogBody =>
      'Этот аккаунт связан с другими приложениями Ente, если вы их используете. Все загруженные данные во всех приложениях Ente будут поставлены в очередь на удаление, а ваш аккаунт будет удален навсегда.';

  @override
  String get hearUsWhereTitle => 'Как вы узнали об Ente? (необязательно)';

  @override
  String get hearUsExplanation =>
      'Мы не отслеживаем установки приложений. Нам поможет, если скажете, как вы нас нашли!';

  @override
  String get viewAddOnButton => 'Посмотреть дополнения';

  @override
  String get addOns => 'Дополнения';

  @override
  String get addOnPageSubtitle => 'Подробности дополнений';

  @override
  String get yourMap => 'Ваша карта';

  @override
  String get modifyYourQueryOrTrySearchingFor =>
      'Измените запрос или попробуйте поискать';

  @override
  String get blackFridaySale => 'Распродажа в \"Черную пятницу\"';

  @override
  String get upto50OffUntil4thDec => 'Скидки до 50% до 4 декабря';

  @override
  String get photos => 'Фото';

  @override
  String get videos => 'Видео';

  @override
  String get livePhotos => 'Живые фото';

  @override
  String get searchHint1 => 'Быстрый поиск прямо на устройстве';

  @override
  String get searchHint2 => 'Даты, описания фото';

  @override
  String get searchHint3 => 'Альбомы, названия и типы файлов';

  @override
  String get searchHint4 => 'Местоположение';

  @override
  String get searchHint5 => 'Скоро: Лица и магический поиск ✨';

  @override
  String get addYourPhotosNow => 'Добавьте ваши фото';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count результатов найдено',
      one: '$count результат найден',
    );
    return '$_temp0';
  }

  @override
  String get faces => 'Лица';

  @override
  String get people => 'Люди';

  @override
  String get contents => 'Содержимое';

  @override
  String get addNew => 'Добавить новое';

  @override
  String get contacts => 'Контакты';

  @override
  String get noInternetConnection => 'Нет подключения к Интернету';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'Пожалуйста, проверьте подключение к Интернету и попробуйте снова.';

  @override
  String get signOutFromOtherDevices => 'Выйти с других устройств';

  @override
  String get signOutOtherBody =>
      'Если вы считаете, что кто-то может знать ваш пароль, вы можете принудительно выйти с других устройств, использующих ваш аккаунт.';

  @override
  String get signOutOtherDevices => 'Выйти с других устройств';

  @override
  String get doNotSignOut => 'Не выходить';

  @override
  String get editLocation => 'Изменить местоположение';

  @override
  String get selectALocation => 'Выбрать местоположение';

  @override
  String get selectALocationFirst => 'Сначала выберите местоположение';

  @override
  String get changeLocationOfSelectedItems =>
      'Изменить местоположение выбранных элементов?';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte =>
      'Изменения в местоположении будут видны только в Ente';

  @override
  String get cleanUncategorized => 'Очистить «Без категории»';

  @override
  String get cleanUncategorizedDescription =>
      'Удалить из «Без категории» все файлы, присутствующие в других альбомах';

  @override
  String get waitingForVerification => 'Ожидание подтверждения...';

  @override
  String get passkey => 'Ключ доступа';

  @override
  String get passkeyAuthTitle => 'Проверка ключа доступа';

  @override
  String get loginWithTOTP => 'Войти с одноразовым кодом';

  @override
  String get passKeyPendingVerification => 'Проверка всё ещё ожидается';

  @override
  String get loginSessionExpired => 'Сессия истекла';

  @override
  String get loginSessionExpiredDetails =>
      'Ваша сессия истекла. Пожалуйста, войдите снова.';

  @override
  String get verifyPasskey => 'Подтвердить ключ доступа';

  @override
  String get playOnTv => 'Воспроизвести альбом на ТВ';

  @override
  String get pair => 'Подключить';

  @override
  String get deviceNotFound => 'Устройство не найдено';

  @override
  String get castInstruction =>
      'Посетите cast.ente.io на устройстве, которое хотите подключить.\n\nВведите код ниже, чтобы воспроизвести альбом на телевизоре.';

  @override
  String get deviceCodeHint => 'Введите код';

  @override
  String get joinDiscord => 'Присоединиться в Discord';

  @override
  String get locations => 'Местоположения';

  @override
  String get addAName => 'Добавить имя';

  @override
  String get findThemQuickly => 'С лёгкостью находите его';

  @override
  String get findPeopleByName => 'С лёгкостью находите людей по имени';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Добавить зрителей',
      one: 'Добавить зрителя',
      zero: 'Добавить зрителя',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Добавить соавторов',
      one: 'Добавить соавтора',
      zero: 'Добавить соавтора',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      'Нажмите с удержанием на электронную почту для подтверждения сквозного шифрования.';

  @override
  String get developerSettingsWarning =>
      'Вы уверены, что хотите изменить настройки для разработчиков?';

  @override
  String get developerSettings => 'Настройки для разработчиков';

  @override
  String get serverEndpoint => 'Конечная точка сервера';

  @override
  String get invalidEndpoint => 'Недействительная конечная точка';

  @override
  String get invalidEndpointMessage =>
      'Извините, введённая вами конечная точка недействительна. Пожалуйста, введите корректную точку и попробуйте снова.';

  @override
  String get endpointUpdatedMessage => 'Конечная точка успешно обновлена';

  @override
  String customEndpoint({required Object endpoint}) {
    return 'Подключено к $endpoint';
  }

  @override
  String get createCollaborativeLink => 'Создать совместную ссылку';

  @override
  String get search => 'Поиск';

  @override
  String get enterPersonName => 'Введите имя человека';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'Этот адрес электронной почты уже связан с $name.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return 'Посмотреть $name для отмены привязки';
  }

  @override
  String get enterName => 'Введите имя';

  @override
  String get savePerson => 'Сохранить человека';

  @override
  String get editPerson => 'Редактировать человека';

  @override
  String get mergedPhotos => 'Объединённые фото';

  @override
  String get orMergeWithExistingPerson => 'Или объединить с существующим';

  @override
  String get enterDateOfBirth => 'Дата рождения (необязательно)';

  @override
  String get birthday => 'День рождения';

  @override
  String get removePersonLabel => 'Удалить метку человека';

  @override
  String get autoPairDesc =>
      'Автоподключение работает только с устройствами, поддерживающими Chromecast.';

  @override
  String get manualPairDesc =>
      'Подключение с PIN-кодом работает с любым устройством, на котором вы хотите просматривать альбом.';

  @override
  String get connectToDevice => 'Подключиться к устройству';

  @override
  String get autoCastDialogBody => 'Здесь вы увидите доступные устройства.';

  @override
  String get autoCastiOSPermission =>
      'Убедитесь, что для приложения Ente Photos включены разрешения локальной сети в настройках.';

  @override
  String get noDeviceFound => 'Устройства не обнаружены';

  @override
  String get stopCastingTitle => 'Остановить трансляцию';

  @override
  String get stopCastingBody => 'Хотите остановить трансляцию?';

  @override
  String get castIPMismatchTitle => 'Не удалось транслировать альбом';

  @override
  String get castIPMismatchBody =>
      'Пожалуйста, убедитесь, что вы находитесь в одной сети с телевизором.';

  @override
  String get pairingComplete => 'Подключение завершено';

  @override
  String get savingEdits => 'Сохранение изменений...';

  @override
  String get autoPair => 'Автоподключение';

  @override
  String get pairWithPin => 'Подключить с PIN';

  @override
  String get faceRecognition => 'Распознавание лиц';

  @override
  String get foundFaces => 'Найденные лица';

  @override
  String get clusteringProgress => 'Прогресс кластеризации';

  @override
  String get trim => 'Сократить';

  @override
  String get crop => 'Обрезать';

  @override
  String get rotate => 'Повернуть';

  @override
  String get left => 'Влево';

  @override
  String get right => 'Вправо';

  @override
  String get whatsNew => 'Что нового';

  @override
  String get reviewSuggestions => 'Посмотреть предложения';

  @override
  String get review => 'Предложения';

  @override
  String get useAsCover => 'Использовать для обложки';

  @override
  String notPersonLabel({required String name}) {
    return 'Не $name?';
  }

  @override
  String get enable => 'Включить';

  @override
  String get enabled => 'Включено';

  @override
  String get moreDetails => 'Подробнее';

  @override
  String get enableMLIndexingDesc =>
      'Ente поддерживает машинное обучение прямо на устройстве для распознавания лиц, магического поиска и других поисковых функций';

  @override
  String get magicSearchHint =>
      'Магический поиск позволяет искать фото по содержимому, например, «цветок», «красная машина», «документы»';

  @override
  String get panorama => 'Панорама';

  @override
  String get reenterPassword => 'Подтвердите пароль';

  @override
  String get reenterPin => 'Введите PIN-код ещё раз';

  @override
  String get deviceLock => 'Блокировка устройства';

  @override
  String get pinLock => 'Блокировка PIN-кодом';

  @override
  String get next => 'Далее';

  @override
  String get setNewPassword => 'Установите новый пароль';

  @override
  String get enterPin => 'Введите PIN-код';

  @override
  String get setNewPin => 'Установите новый PIN-код';

  @override
  String get appLock => 'Блокировка приложения';

  @override
  String get noSystemLockFound => 'Системная блокировка не найдена';

  @override
  String get tapToUnlock => 'Нажмите для разблокировки';

  @override
  String get tooManyIncorrectAttempts => 'Слишком много неудачных попыток';

  @override
  String get videoInfo => 'Информация о видео';

  @override
  String get autoLock => 'Автоблокировка';

  @override
  String get immediately => 'Немедленно';

  @override
  String get autoLockFeatureDescription =>
      'Спустя какое время приложение блокируется после перехода в фоновый режим';

  @override
  String get hideContent => 'Скрыть содержимое';

  @override
  String get hideContentDescriptionAndroid =>
      'Скрывает содержимое приложения при переключении между приложениями и отключает скриншоты';

  @override
  String get hideContentDescriptionIos =>
      'Скрывает содержимое приложения при переключении между приложениями';

  @override
  String get passwordStrengthInfo =>
      'Надёжность пароля определяется его длиной, используемыми символами и присутствием среди 10000 самых популярных паролей';

  @override
  String get noQuickLinksSelected => 'Быстрые ссылки не выбраны';

  @override
  String get pleaseSelectQuickLinksToRemove =>
      'Пожалуйста, выберите быстрые ссылки для удаления';

  @override
  String get removePublicLinks => 'Удалить публичные ссылки';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      'Это удалит публичные ссылки всех выбранных быстрых ссылок.';

  @override
  String get guestView => 'Гостевой просмотр';

  @override
  String get guestViewEnablePreSteps =>
      'Для включения гостевого просмотра, пожалуйста, настройте код или блокировку экрана в настройках устройства.';

  @override
  String get nameTheAlbum => 'Дайте название альбому';

  @override
  String get collectPhotosDescription =>
      'Создайте ссылку, по которой ваши друзья смогут загружать фото в оригинальном качестве.';

  @override
  String get collect => 'Собрать';

  @override
  String get appLockDescriptions =>
      'Выберите между экраном блокировки устройства и пользовательским с PIN-кодом или паролем.';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'Для блокировки приложения, пожалуйста, настройте код или экран блокировки в настройках устройства.';

  @override
  String get authToViewPasskey =>
      'Пожалуйста, авторизуйтесь для просмотра ключа доступа';

  @override
  String get loopVideoOn => 'Отключить повтор';

  @override
  String get loopVideoOff => 'Запустить повтор';

  @override
  String get localSyncErrorMessage =>
      'Похоже, что-то пошло не так: синхронизация фото занимает больше времени, чем ожидалось. Пожалуйста, обратитесь в поддержку';

  @override
  String get showPerson => 'Показать человека';

  @override
  String get sort => 'Сортировать';

  @override
  String get mostRecent => 'Самые последние';

  @override
  String get mostRelevant => 'Самые актуальные';

  @override
  String get loadingYourPhotos => 'Загрузка ваших фото...';

  @override
  String processingImport({required Object folderName}) {
    return 'Обработка $folderName...';
  }

  @override
  String get personName => 'Имя человека';

  @override
  String get addNewPerson => 'Добавить нового человека';

  @override
  String get addNameOrMerge => 'Добавить имя или объединить';

  @override
  String get mergeWithExisting => 'Объединить с существующим';

  @override
  String get newPerson => 'Новый человек';

  @override
  String get addName => 'Добавить имя';

  @override
  String get add => 'Добавить';

  @override
  String extraPhotosFoundFor({required String text}) {
    return 'Дополнительные фото найдены для $text';
  }

  @override
  String get extraPhotosFound => 'Найдены дополнительные фото';

  @override
  String get configuration => 'Настройки';

  @override
  String get localIndexing => 'Локальная индексация';

  @override
  String get processed => 'Обработано';

  @override
  String get resetPerson => 'Удалить';

  @override
  String get areYouSureYouWantToResetThisPerson =>
      'Вы уверены, что хотите сбросить данные этого человека?';

  @override
  String get allPersonGroupingWillReset =>
      'Все группы этого человека будут сброшены, и вы потеряете все предложения для него';

  @override
  String get yesResetPerson => 'Да, сбросить данные человека';

  @override
  String get onlyThem => 'Только он(а)';

  @override
  String get checkingModels => 'Проверка моделей...';

  @override
  String get enableMachineLearningBanner =>
      'Включите машинное обучение для магического поиска и распознавания лиц';

  @override
  String get searchDiscoverEmptySection =>
      'Изображения появятся здесь после завершения обработки и синхронизации';

  @override
  String get searchPersonsEmptySection =>
      'Люди появятся здесь после завершения обработки и синхронизации';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Добавлено $count зрителей',
      one: 'Добавлен 1 зритель',
      zero: 'Добавлено 0 зрителей',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Добавлено $count соавторов',
      one: 'Добавлен 1 соавтор',
      zero: 'Добавлено 0 соавторов',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured => 'Аккаунт уже настроен.';

  @override
  String get sessionIdMismatch => 'Несоответствие ID сессии';

  @override
  String get failedToFetchActiveSessions =>
      'Не удалось получить активные сессии';

  @override
  String get failedToRefreshStripeSubscription =>
      'Не удалось обновить подписку';

  @override
  String get failedToPlayVideo => 'Не удалось воспроизвести видео';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return 'Загрузка игнорируется из-за $ignoreReason';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'Тип галереи $galleryType не поддерживает переименование';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'Нажмите для загрузки. Загрузка игнорируется из-за $ignoreReason';
  }

  @override
  String get tapToUpload => 'Нажмите для загрузки';

  @override
  String get info => 'Информация';

  @override
  String get addFiles => 'Добавить файлы';

  @override
  String get castAlbum => 'Транслировать альбом';

  @override
  String get imageNotAnalyzed => 'Изображение не проанализировано';

  @override
  String get noFacesFound => 'Лица не найдены';

  @override
  String get fileNotUploadedYet => 'Файл ещё не загружен';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return 'Нет предложений для $personName';
  }

  @override
  String get month => 'месяц';

  @override
  String get yearShort => 'год';

  @override
  String get currentlyRunning => 'выполняется';

  @override
  String get ignored => 'игнорируется';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count фотографий',
      one: '1 фотография',
      zero: '0 фотографий',
    );
    return '$_temp0';
  }

  @override
  String get file => 'Файл';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'Несоответствие длины разделов: $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'Выберите почтовое приложение';

  @override
  String get selectAllShort => 'Все';

  @override
  String get selectCoverPhoto => 'Выберите обложку';

  @override
  String get newLocation => 'Новое местоположение';

  @override
  String get faceNotClusteredYet =>
      'Лицо ещё не кластеризовано. Пожалуйста, попробуйте позже';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'Срок действия ссылки, к которой вы обращаетесь, истёк.';

  @override
  String get openFile => 'Открыть файл';

  @override
  String get backupFile => 'Резервное копирование файла';

  @override
  String get openAlbumInBrowser => 'Открыть альбом в браузере';

  @override
  String get openAlbumInBrowserTitle =>
      'Пожалуйста, используйте веб-версию, чтобы добавить фото в этот альбом';

  @override
  String get allow => 'Разрешить';

  @override
  String get allowAppToOpenSharedAlbumLinks =>
      'Разрешить приложению открывать ссылки на общие альбомы';

  @override
  String get seePublicAlbumLinksInApp =>
      'Просматривать публичные ссылки на альбомы в приложении';

  @override
  String get emergencyContacts => 'Экстренные контакты';

  @override
  String get acceptTrustInvite => 'Принять приглашение';

  @override
  String get declineTrustInvite => 'Отклонить приглашение';

  @override
  String get removeYourselfAsTrustedContact =>
      'Удалить себя из доверенных контактов';

  @override
  String get legacy => 'Наследие';

  @override
  String get legacyPageDesc =>
      'Наследие позволяет доверенным контактам получить доступ к вашему аккаунту в ваше отсутствие.';

  @override
  String get legacyPageDesc2 =>
      'Доверенные контакты могут начать восстановление аккаунта. Если не отменить это в течение 30 дней, то они смогут сбросить пароль и получить доступ.';

  @override
  String get legacyAccounts => 'Наследуемые аккаунты';

  @override
  String get trustedContacts => 'Доверенные контакты';

  @override
  String get addTrustedContact => 'Добавить доверенный контакт';

  @override
  String get removeInvite => 'Удалить приглашение';

  @override
  String get recoveryWarning =>
      'Доверенный контакт пытается получить доступ к вашему аккаунту';

  @override
  String get rejectRecovery => 'Отклонить восстановление';

  @override
  String get recoveryInitiated => 'Восстановление начато';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return 'Вы сможете получить доступ к аккаунту через $days дней. Уведомление будет отправлено на $email.';
  }

  @override
  String get cancelAccountRecovery => 'Отменить восстановление';

  @override
  String get recoveryAccount => 'Восстановить аккаунт';

  @override
  String get cancelAccountRecoveryBody =>
      'Вы уверены, что хотите отменить восстановление?';

  @override
  String get startAccountRecoveryTitle => 'Начать восстановление';

  @override
  String get whyAddTrustContact =>
      'Доверенный контакт может помочь в восстановлении ваших данных.';

  @override
  String recoveryReady({required String email}) {
    return 'Теперь вы можете восстановить аккаунт $email, установив новый пароль.';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email пытается восстановить ваш аккаунт.';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return 'Вы приглашены стать доверенным контактом $email.';
  }

  @override
  String get warning => 'Предупреждение';

  @override
  String get proceed => 'Продолжить';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return 'Вы собираетесь добавить $email в качестве доверенного контакта. Доверенный контакт сможет восстановить ваш аккаунт, если вы будете отсутствовать $numOfDays дней.';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email пригласил вас стать доверенным контактом';
  }

  @override
  String get authToManageLegacy =>
      'Пожалуйста, авторизуйтесь для управления доверенными контактами';

  @override
  String get hideSharedItemsFromHomeGallery =>
      'Скрыть общие элементы из основной галереи';

  @override
  String get swipeToSelect => 'Swipe to select';

  @override
  String get gallery => 'Галерея';

  @override
  String get joinAlbum => 'Присоединиться к альбому';

  @override
  String get joinAlbumSubtext => 'чтобы просматривать и добавлять свои фото';

  @override
  String get joinAlbumSubtextViewer => 'чтобы добавить это в общие альбомы';

  @override
  String get join => 'Присоединиться';

  @override
  String get linkEmail => 'Привязать электронную почту';

  @override
  String get link => 'Привязать';

  @override
  String get noEnteAccountExclamation => 'Нет аккаунта Ente!';

  @override
  String get orPickFromYourContacts => 'или выберите из ваших контактов';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return '$email не имеет аккаунта Ente.';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (Я)';
  }

  @override
  String get reassignMe => 'Переназначить \"Меня\"';

  @override
  String get me => 'Я';

  @override
  String get linkEmailToContactBannerCaption => 'чтобы быстрее делиться';

  @override
  String get selectPersonToLink => 'Выберите человека для привязки';

  @override
  String linkPersonToEmail({required String email}) {
    return 'Связать человека с $email';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return 'Это свяжет $personName с $email';
  }

  @override
  String get selectYourFace => 'Выберите своё лицо';

  @override
  String get reassigningLoading => 'Переназначение...';

  @override
  String reassignedToName({required String name}) {
    return 'Вы переназначены на $name';
  }

  @override
  String get saveChangesBeforeLeavingQuestion =>
      'Сохранить изменения перед выходом?';

  @override
  String get dontSave => 'Не сохранять';

  @override
  String get thisIsMeExclamation => 'Это я!';

  @override
  String get linkPerson => 'Связать человека';

  @override
  String get linkPersonCaption => 'чтобы было удобнее делиться';

  @override
  String get videoStreaming => 'Потоковое видео';

  @override
  String get processingVideos => 'Обработка видео';

  @override
  String get streamDetails => 'Информация о потоке';

  @override
  String get processing => 'Обработка';

  @override
  String get queued => 'В очереди';

  @override
  String get ineligible => 'Неподходящий';

  @override
  String get failed => 'Не удалось';

  @override
  String get playStream => 'Воспроизвести поток';

  @override
  String get playOriginal => 'Воспроизвести оригинал';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'Если вы присоединитесь к альбому, ваша электронная почта станет видимой для его участников.';

  @override
  String get pleaseWaitThisWillTakeAWhile =>
      'Пожалуйста, подождите, это займёт некоторое время.';

  @override
  String get editTime => 'Изменить время';

  @override
  String get selectTime => 'Выбрать время';

  @override
  String get selectDate => 'Выбрать дату';

  @override
  String get previous => 'Предыдущий';

  @override
  String get selectOneDateAndTimeForAll =>
      'Выберите одну дату и время для всех';

  @override
  String get selectStartOfRange => 'Выберите начало диапазона';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      'Это сделает дату и время всех выбранных фото одинаковыми.';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'Это первое фото в группе. Остальные выбранные фото автоматически сместятся на основе новой даты';

  @override
  String get newRange => 'Новый диапазон';

  @override
  String get selectOneDateAndTime => 'Выбрать одну дату и время';

  @override
  String get moveSelectedPhotosToOneDate =>
      'Переместите выбранные фото на одну дату';

  @override
  String get shiftDatesAndTime => 'Сместить даты и время';

  @override
  String get photosKeepRelativeTimeDifference =>
      'Фото сохранят относительную разницу во времени';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count фото',
      one: '1 фото',
      zero: 'Нет фото',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'Иконка приложения';

  @override
  String get notThisPerson => 'Не этот человек?';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      'Выбранные элементы будут отвязаны от этого человека, но не удалены из вашей библиотеки.';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat сквозь годы';
  }

  @override
  String get thisWeekThroughTheYears => 'Эта неделя сквозь годы';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Эта неделя, $count лет назад',
      one: 'Эта неделя, $count год назад',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'Вы и $name';
  }

  @override
  String admiringThem({required Object name}) {
    return 'Любуясь $name';
  }

  @override
  String embracingThem({required Object name}) {
    return 'Обнимая $name';
  }

  @override
  String partyWithThem({required Object name}) {
    return 'Вечеринка с $name';
  }

  @override
  String hikingWithThem({required Object name}) {
    return 'Поход с $name';
  }

  @override
  String feastingWithThem({required Object name}) {
    return 'Пир с $name';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return 'Селфи с $name';
  }

  @override
  String posingWithThem({required Object name}) {
    return 'Позируя с $name';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return 'Красивые виды с $name';
  }

  @override
  String sportsWithThem({required Object name}) {
    return 'Спорт с $name';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return 'Путешествие с $name';
  }

  @override
  String get spotlightOnYourself => 'Вы в центре внимания';

  @override
  String spotlightOnThem({required Object name}) {
    return 'В центре внимания $name';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$name исполнилось $age!';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name скоро исполнится $age';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return 'В последний раз с $name';
  }

  @override
  String tripToLocation({required Object location}) {
    return 'Поездка в $location';
  }

  @override
  String tripInYear({required Object year}) {
    return 'Поездка в $year';
  }

  @override
  String get lastYearsTrip => 'Прошлогодняя поездка';

  @override
  String get sunrise => 'На горизонте';

  @override
  String get mountains => 'За холмами';

  @override
  String get greenery => 'Зелёная жизнь';

  @override
  String get beach => 'Песок и море';

  @override
  String get city => 'В городе';

  @override
  String get moon => 'В лунном свете';

  @override
  String get onTheRoad => 'Снова в пути';

  @override
  String get food => 'Кулинарное наслаждение';

  @override
  String get pets => 'Пушистые спутники';

  @override
  String get curatedMemories => 'Отобранные воспоминания';

  @override
  String get widgets => 'Виджеты';

  @override
  String get memories => 'Воспоминания';

  @override
  String get peopleWidgetDesc =>
      'Выберите людей, которых вы хотите видеть на главном экране.';

  @override
  String get albumsWidgetDesc =>
      'Выберите альбомы, которые вы хотите видеть на главном экране.';

  @override
  String get memoriesWidgetDesc =>
      'Выберите, какие воспоминания вы хотите видеть на главном экране.';

  @override
  String get smartMemories => 'Умные воспоминания';

  @override
  String get pastYearsMemories => 'Воспоминания прошлых лет';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return 'Также удалить фото (и видео), находящиеся в этих $count альбомах, из <bold>всех</bold> других альбомов, частью которых они являются?';
  }

  @override
  String get addParticipants => 'Добавить участников';

  @override
  String selectedAlbums({required Object count}) {
    return '$count выбрано';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'Действие не поддерживается в альбоме «Избранное»';

  @override
  String get onThisDayMemories => 'В этот день воспоминания';

  @override
  String get onThisDay => 'В этот день';

  @override
  String get lookBackOnYourMemories => 'Оглянитесь на ваши воспоминания 🌄';

  @override
  String get newPhotosEmoji => ' новая 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'Извините, нам пришлось приостановить резервное копирование';

  @override
  String get clickToInstallOurBestVersionYet =>
      'Нажмите, чтобы установить нашу лучшую версию';

  @override
  String get onThisDayNotificationExplanation =>
      'Получайте напоминания о воспоминаниях, связанных с этим днем в прошлые годы.';

  @override
  String get addMemoriesWidgetPrompt =>
      'Добавьте виджет воспоминаний на главный экран и вернитесь сюда, чтобы настроить его.';

  @override
  String get addAlbumWidgetPrompt =>
      'Добавьте виджет альбома на главный экран и вернитесь сюда, чтобы настроить его.';

  @override
  String get addPeopleWidgetPrompt =>
      'Добавьте виджет людей на главный экран и вернитесь сюда, чтобы настроить его.';

  @override
  String get birthdayNotifications => 'Уведомления о днях рождения';

  @override
  String get receiveRemindersOnBirthdays =>
      'Получайте напоминания, когда у кого-то день рождения. Нажатие на уведомление перенесет вас к фотографиям именинника.';

  @override
  String get happyBirthday => 'С днём рождения! 🥳';

  @override
  String get birthdays => 'Дни рождения';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return 'Поздравляем $name с днем ​​рождения! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      'Вы уверены, что хотите удалить лицо этого человека?';

  @override
  String get otherDetectedFaces => 'Другие найденные лица';

  @override
  String get areThey => 'Они ';

  @override
  String get questionmark => '?';

  @override
  String get saveAsAnotherPerson => 'Сохранить как другого человека';

  @override
  String get showLessFaces => 'Показывать меньше лиц';

  @override
  String get showMoreFaces => 'Показывать больше лиц';

  @override
  String get ignore => 'Игнорировать';

  @override
  String get merge => 'Объединить';

  @override
  String get reset => 'Сбросить';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      'Вы уверены, что хотите игнорировать этого человека?';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      'Вы уверены, что хотите игнорировать этих людей?';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'Группы людей больше не будут отображаться в разделе людей. Фотографии останутся нетронутыми.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'Человек больше не будет отображаться в разделе людей. Фотографии останутся нетронутыми.';

  @override
  String get areYouSureYouWantToMergeThem =>
      'Вы уверены, что хотите их объединить?';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'Все неназванные группы будут объединены в выбранного человека. Это можно отменить в обзоре истории предложений для данного человека.';

  @override
  String get yesIgnore => 'Да, игнорировать';

  @override
  String get same => 'Такой же';

  @override
  String get different => 'Разные';

  @override
  String get sameperson => 'Тот же человек?';

  @override
  String get indexingPausedStatusDescription =>
      'Индексирование приостановлено. Оно автоматически возобновится, когда устройство будет готово. Устройство считается готовым, когда уровень заряда батареи, её состояние и температура находятся в пределах нормы.';

  @override
  String get thisWeek => 'На этой неделе';

  @override
  String get lastWeek => 'На прошлой неделе';

  @override
  String get thisMonth => 'В этом месяце';

  @override
  String get thisYear => 'В этом году';

  @override
  String get groupBy => 'Группировать по';

  @override
  String get faceThumbnailGenerationFailed =>
      'Не удалось создать миниатюры лиц';

  @override
  String get fileAnalysisFailed => 'Не удалось проанализировать файл';

  @override
  String get editAutoAddPeople =>
      'Редактировать автоматическое добавление людей';

  @override
  String get autoAddPeople => 'Автоматически добавлять людей';

  @override
  String get autoAddToAlbum => 'Автоматически добавлять в альбом';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      'Хотите удалить файлы, связанные с человеком, ранее выбранным в смарт-альбоме?';

  @override
  String get addingPhotos => 'Добавление фото';

  @override
  String get gettingReady => 'Идет подготовка';

  @override
  String get addSomePhotosDesc1 =>
      'Добавьте несколько фотографий или выберите ';

  @override
  String get addSomePhotosDesc2 => 'знакомые лица';

  @override
  String get addSomePhotosDesc3 => '\nначать с';

  @override
  String get ignorePerson => 'Игнорировать людей';

  @override
  String get mixedGrouping => 'Смешанная группа?';

  @override
  String get analysis => 'Анализ';

  @override
  String get doesGroupContainMultiplePeople => 'Много ли людей в этой группе?';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'Мы автоматически проанализируем группу, чтобы определить, есть ли в ней несколько человек, и снова разделим их. Это может занять несколько секунд.';

  @override
  String get layout => 'Макет';

  @override
  String get day => 'Дню';

  @override
  String get undo => 'Отменить';

  @override
  String get redo => 'Переделать';

  @override
  String get filter => 'Фильтр';

  @override
  String get adjust => 'Отрегулировать';

  @override
  String get draw => 'Рисовать';

  @override
  String get sticker => 'Стикер';

  @override
  String get brushColor => 'Цвет кисти';

  @override
  String get font => 'Шрифт';

  @override
  String get background => 'Фон';

  @override
  String get align => 'Выравнивание';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Добавлено в $count альбомов успешно',
      few: 'Добавлено в $count альбомов успешно',
      one: 'Добавлено в 1 альбом успешно',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => 'Видео было обработано';

  @override
  String get totalVideos => 'Всего видео';

  @override
  String get skippedVideos => 'Пропущенные видео';

  @override
  String get videoStreamingDescriptionLine1 =>
      'Мгновенно воспроизводите видео на любом устройстве.';

  @override
  String get videoStreamingDescriptionLine2 =>
      'Включить обработку видеопотоков на этом устройстве.';

  @override
  String get videoStreamingNote =>
      'Это устройство поддерживает только видео, снятые не более 60 дней назад и продолжительностью менее 1 минуты. Для более старых/длинных видео включите потоковую передачу в приложении для ПК.';

  @override
  String get createStream => 'Создать прямую трансляцию';

  @override
  String get recreateStream => 'Воссоздать прямую трансляцию';

  @override
  String get addedToStreamCreationQueue =>
      'Добавлено в очередь создания потока';

  @override
  String get addedToStreamRecreationQueue =>
      'Добавлено в очередь регенерации потока';

  @override
  String get videoPreviewAlreadyExists => 'Видео-превью уже существует';

  @override
  String get videoAlreadyInQueue => 'Видеофайл уже в очереди';

  @override
  String get videoExportFailed =>
      'Не удалось создать видео, пожалуйста, попробуйте снова.';

  @override
  String videoExportSuccess({required String path}) {
    return 'Видео успешно создано в $path';
  }

  @override
  String get addedToQueue => 'Добавлено в очередь';

  @override
  String get creatingStream => 'Создание потока';

  @override
  String get similarImages => 'Похожие фотографии';

  @override
  String get findSimilarImages => 'Найти похожие фотографии';

  @override
  String get noSimilarImagesFound => 'Подходящих фотографий не найдено';

  @override
  String get yourPhotosLookUnique => 'Ваши фотографии выглядят уникальными';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count группы найдены',
      one: '$count группа найдена',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages =>
      'Просмотр и удаление дубликатов фотографий';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return 'Удалить $count изображений ($size)';
  }

  @override
  String get selectionOptions => 'Варианты выбора';

  @override
  String selectExactWithCount({required int count}) {
    return 'Точно такие же ($count)';
  }

  @override
  String get selectExact => 'Выберите точное';

  @override
  String selectSimilarWithCount({required int count}) {
    return 'Частично идентичны ($count)';
  }

  @override
  String get selectSimilar => 'Выбрать похожие';

  @override
  String selectAllWithCount({required int count}) {
    return 'Все сходства ($count)';
  }

  @override
  String get selectSimilarImagesTitle => 'Выбрать похожие изображения';

  @override
  String get chooseSimilarImagesToSelect =>
      'Выбирать изображения на основе их визуального сходства';

  @override
  String get clearSelection => 'Очистить выбранные';

  @override
  String similarImagesCount({required int count}) {
    return '$count похожих фотографий';
  }

  @override
  String deleteWithCount({required int count}) {
    return 'Удалить ($count)';
  }

  @override
  String get deleteFiles => 'Удалить файлы';

  @override
  String get areYouSureDeleteFiles =>
      'Вы уверены, что хотите удалить эти файлы?';

  @override
  String get greatJob => 'Отличная работа!';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return 'Вы освободили $size места';
  }

  @override
  String get size => 'Размер';

  @override
  String get similarity => 'Сходство';

  @override
  String get analyzingPhotosLocally =>
      'Анализ ваших фотографий на устройстве...';

  @override
  String get lookingForVisualSimilarities => 'Поиск по визуальному сходству...';

  @override
  String get comparingImageDetails => 'Сравнение деталей изображения...';

  @override
  String get findingSimilarImages => 'Найти похожие фотографии...';

  @override
  String get almostDone => 'Почти готово...';

  @override
  String get processingLocally => 'Обработка локально';

  @override
  String get useMLToFindSimilarImages =>
      'Просмотрите и удалите фотографии, которые кажутся похожими.';

  @override
  String get all => 'Все';

  @override
  String get similar => 'Похожий';

  @override
  String get identical => 'Идентичный';

  @override
  String get nothingHereTryAnotherFilter =>
      'Ничего не видно, попробуйте сменить фильтр! 👀';

  @override
  String get related => 'Связанный';

  @override
  String get hoorayyyy => 'Ураааа!';

  @override
  String get nothingToTidyUpHere => 'Здесь очень вкусно';

  @override
  String get deletingDash => 'Удаление - ';

  @override
  String get cLTitle1 => 'Перейти к дате';

  @override
  String get cLDesc1 =>
      'На панели информации о файле выберите опцию «Перейти к дате», чтобы просмотреть все фотографии рядом с датой файла.';

  @override
  String get cLTitle2 => 'Быстрое редактирование видео';

  @override
  String get cLDesc2 =>
      'Видеоредактор был полностью переработан, что значительно увеличило скорость редактирования больших видеороликов и улучшило пользовательский опыт.';

  @override
  String get cLTitle3 => 'Новые воспоминания';

  @override
  String get cLDesc3 =>
      '\"Игра детей\", \"Зимнее приключение\", \"Неоновая ночь\" и другое.';

  @override
  String get cLTitle4 => 'Галерея пейзажей и многое другое';

  @override
  String get cLDesc4 =>
      'Поддержка горизонтальной ориентации в основной галерее приложения. Показывайте людей без связанных фотографий вместо их фильтрации. Улучшено определение соотношения сторон видео при публикации из внешних приложений.';

  @override
  String get closeBy => 'Закрыть';

  @override
  String get peopleAutoAddDesc =>
      'Автоматически добавлять фотографии выбранных людей в этот альбом';

  @override
  String get festivities => 'Праздничное настроение';

  @override
  String get snowAdventures => 'Зимнее приключение';

  @override
  String get waterfalls => 'Водопад';

  @override
  String get wildlife => 'В дикой природе';

  @override
  String get flowers => 'Цветущая красота';

  @override
  String get nightLights => 'Неоновая ночь';

  @override
  String get architecture => 'Дизайн иконок';

  @override
  String get autumnColors => 'Очаровательная осень';

  @override
  String get desertDreams => 'Мечта пустыни';

  @override
  String get stargazing => 'Под звездами';

  @override
  String get lakeside => 'Тихое озеро';

  @override
  String get rainyDays => 'Дождливый день';

  @override
  String get sportsAction => 'Игра';

  @override
  String get streetArt => 'Уличное искусство';

  @override
  String get familyMoments => 'Время семьи';

  @override
  String get fireworks => 'Фейерверк';

  @override
  String get historicSites => 'Историческое место';

  @override
  String get tropicalParadise => 'Джунгли';

  @override
  String get forestTrails => 'Прогулка по лесу';

  @override
  String get citySunsets => 'Городской закат';

  @override
  String get colorfulMarkets => 'Красочный рынок';

  @override
  String get cozyCafes => 'Кофейный уголок';

  @override
  String get vintageVibes => 'Классический';

  @override
  String get aerialViews => 'В воздухе';

  @override
  String get artisticPortraits => 'Художественный портрет';

  @override
  String get streetFood => 'Уличная еда';

  @override
  String get riverCruises => 'Вид на реку';

  @override
  String get facesTimelineBannerTitle => 'Линия воспоминаний';

  @override
  String facesTimelineBannerSubtitle({required String name}) {
    return 'Смотрите фотографии $name на протяжении многих лет';
  }

  @override
  String get facesTimelineAppBarTitle => 'Линия воспоминаний';

  @override
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count лет',
      many: '$count лет',
      few: '$count года',
      one: '$count год',
    );
    return '$name было $_temp0';
  }

  @override
  String facesTimelineCaptionYearsAgo({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '# лет назад',
      many: '# лет назад',
      few: '# года назад',
      one: '# год назад',
    );
    return '$_temp0';
  }

  @override
  String get facesTimelineShareComingSoon => 'Обмен видео скоро появится';

  @override
  String get facesTimelinePlaybackPrevious => 'Предыдущий';

  @override
  String get facesTimelinePlaybackNext => 'Далее';

  @override
  String get facesTimelinePlaybackPlay => 'Воспроизвести';

  @override
  String get facesTimelinePlaybackPause => 'Приостановить';

  @override
  String get facesTimelineUnavailable => 'Таймлайн готовиться...';

  @override
  String get playfulKids => 'Игра детей';

  @override
  String get coastalCliffs => 'Скалы у моря';

  @override
  String get ritualsTitle => 'Rituals';

  @override
  String get ritualAddTooltip => 'Add ritual';

  @override
  String get ritualActivityHeading => 'Activity';

  @override
  String get ritualDefaultHeatmapTitle => 'Take a photo every day';

  @override
  String get ritualUntitled => 'Untitled ritual';

  @override
  String get ritualShareUnavailable =>
      'Unable to share right now. Please try again.';

  @override
  String get ritualNotificationMessage => 'Take a photo now';

  @override
  String get ritualCameraNotFound => 'No camera found on this device.';

  @override
  String get ritualCameraStartError =>
      'Unable to start camera. Please check permissions.';

  @override
  String get ritualCaptureError => 'Unable to capture photo. Please try again.';

  @override
  String ritualPhotoLimit({required int maxPhotos}) {
    String _temp0 = intl.Intl.pluralLogic(
      maxPhotos,
      locale: localeName,
      other: '# photos.',
      one: '# photo.',
    );
    return 'You can add up to $_temp0';
  }

  @override
  String get ritualCaptureAtLeastOne => 'Capture at least one photo first.';

  @override
  String get ritualAlbumMissing =>
      'Ritual album missing. Edit the ritual to set an album.';

  @override
  String get ritualAddedToAlbum => 'Added to album';

  @override
  String ritualAddedToAlbumWithName({required String albumName}) {
    return 'Added to $albumName';
  }

  @override
  String ritualAddToAlbumFailure({required String error}) {
    return 'Couldn\'t add photos to the album: $error';
  }

  @override
  String get ritualBackToList => 'Back to rituals';

  @override
  String get ritualNoPhotosYet => 'No photos yet';

  @override
  String get ritualSetAlbumToLaunchCamera =>
      'Set an album for this ritual to launch the camera.';

  @override
  String get ritualDefaultCameraTitle => 'Take a photo';

  @override
  String get ritualBadgeMessage7 =>
      '7 days down! Consistency looks good on you. Keep going!';

  @override
  String get ritualBadgeMessage14 =>
      '14 days in! Your ritual is becoming a habit. Incredible!';

  @override
  String get ritualBadgeMessage30 =>
      '30 days in a row! Legendary consistency. Take a bow!';

  @override
  String get ritualBadgeMessageDefault => 'You\'re on a roll!';

  @override
  String get ritualBadgeNewTitle => 'New achievement';

  @override
  String get ritualBadgePreparing => 'Preparing...';

  @override
  String get ritualStreaksLabel => 'Streaks';

  @override
  String get ritualCreateYourOwn => 'Create your own ritual';

  @override
  String get ritualGetDailyReminders => 'Get daily reminders';

  @override
  String get ritualAlbumNotSet => 'Album not set';

  @override
  String get ritualOpenCameraTooltip => 'Open ritual camera';

  @override
  String get ritualEditorLabel => 'Ritual editor';

  @override
  String get ritualNew => 'New ritual';

  @override
  String get ritualEdit => 'Edit ritual';

  @override
  String get ritualEnterPrompt => 'Enter your ritual';

  @override
  String get ritualEnterDescription => 'Please enter a description';

  @override
  String get ritualDayLabel => 'Day';

  @override
  String get ritualNotificationsOffHint =>
      'Notifications are off. Tap a day to turn them on.';

  @override
  String get ritualTimeLabel => 'Time';

  @override
  String get ritualAlbumLabel => 'Album';

  @override
  String get ritualSave => 'Save ritual';

  @override
  String get ritualUpdate => 'Update ritual';

  @override
  String get ritualSelectAlbumTitle => 'Select album';

  @override
  String get ritualSearchOrCreate => 'Search or create new';

  @override
  String get ritualNoAlbumsYet => 'No albums yet';

  @override
  String get ritualNoMatchingAlbums => 'No matching albums';

  @override
  String ritualCreateAlbumWithName({required String albumName}) {
    return 'Create \"$albumName\"';
  }

  @override
  String get ritualCreateNew => 'Create new';

  @override
  String get ritualAlbumSelectionPlaceholder => 'Select album';

  @override
  String get ritualPickEmojiTitle => 'Pick an emoji';

  @override
  String get ritualCustomKeyboardLabel => 'Custom (keyboard)';

  @override
  String get ritualEmojiKeyboardHint => 'Press to open emoji keyboard';

  @override
  String get ritualEmojiUseAction => 'Use';

  @override
  String get ritualSearchEmpty =>
      'Build a ritual to keep your photo habit going.';
}
