// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Portuguese (`pt`).
class AppLocalizationsPt extends AppLocalizations {
  AppLocalizationsPt([String locale = 'pt']) : super(locale);

  @override
  String get enterYourEmailAddress => 'Insira o seu endereço de email';

  @override
  String get enterYourNewEmailAddress => 'Enter your new email address';

  @override
  String get accountWelcomeBack => 'Bem-vindo de volta!';

  @override
  String get emailAlreadyRegistered => 'Email already registered.';

  @override
  String get emailNotRegistered => 'Email not registered.';

  @override
  String get email => 'Email';

  @override
  String get cancel => 'Cancelar';

  @override
  String get verify => 'Verificar';

  @override
  String get invalidEmailAddress => 'Endereço de email inválido';

  @override
  String get enterValidEmail =>
      'Por favor, insira um endereço de email válido.';

  @override
  String get deleteAccount => 'Eliminar conta';

  @override
  String get deleteAccountWarning =>
      'This will delete your Ente Auth, Ente Photos and Ente Locker account.';

  @override
  String get askDeleteReason =>
      'Qual o principal motivo pelo qual está a eliminar a conta?';

  @override
  String get deleteAccountFeedbackPrompt =>
      'Lamentamos a sua partida. Indique-nos a razão para podermos melhorar o serviço.';

  @override
  String get feedback => 'Opinião';

  @override
  String get kindlyHelpUsWithThisInformation =>
      'Por favor, ajude-nos com esta informação';

  @override
  String get confirmDeletePrompt =>
      'Sim, pretendo apagar permanentemente esta conta e os respetivos dados em todas as aplicações.';

  @override
  String get confirmAccountDeletion => 'Confirmar eliminação de conta';

  @override
  String get deleteAccountPermanentlyButton => 'Excluir conta permanentemente';

  @override
  String get yourAccountHasBeenDeleted => 'A sua conta foi eliminada';

  @override
  String get selectReason => 'Selecionar motivo';

  @override
  String get deleteReason1 =>
      'Falta uma funcionalidade-chave de que eu necessito';

  @override
  String get deleteReason2 =>
      'O aplicativo ou um determinado recurso não se comportou como era suposto';

  @override
  String get deleteReason3 => 'Encontrei outro serviço de que gosto mais';

  @override
  String get deleteReason4 => 'O motivo não está na lista';

  @override
  String get sendEmail => 'Enviar email';

  @override
  String get deleteRequestSLAText =>
      'O seu pedido será processado dentro de 72 horas.';

  @override
  String get deleteEmailRequest =>
      'Envie um e-mail para <warning>accountt-deletion@ente.io</warning> a partir do seu endereço de email registrado.';

  @override
  String get entePhotosPerm =>
      'Ente <i>precisa de permissão para</i> preservar suas fotos';

  @override
  String get ok => 'Ok';

  @override
  String get createAccount => 'Criar conta';

  @override
  String get createNewAccount => 'Criar nova conta';

  @override
  String get password => 'Palavra-passe';

  @override
  String get confirmPassword => 'Confirmar palavra-passe';

  @override
  String get activeSessions => 'Sessões ativas';

  @override
  String get ocrProcessingOverlayMessage => 'Detecting text...';

  @override
  String get ocrLoadingIndicatorLabel => 'Detecting Text';

  @override
  String get ocrSelectionHint =>
      'Swipe or double tap to select just what you need';

  @override
  String get ocrNoTextDetected => 'No text detected';

  @override
  String get ocrRetryButtonLabel => 'Retry';

  @override
  String get ocrModelsNetworkRequiredError =>
      'Network connection required to download OCR models on first use';

  @override
  String get ocrModelsPrepareFailed => 'Could not prepare OCR models';

  @override
  String get ocrImageNotFoundError => 'Image file not found';

  @override
  String get ocrImageDecodeFailedError => 'Could not read image file';

  @override
  String get ocrGenericDetectError => 'Could not detect text in image';

  @override
  String get oops => 'Oops';

  @override
  String get somethingWentWrongPleaseTryAgain =>
      'Ocorreu um erro. Tente novamente';

  @override
  String get thisWillLogYouOutOfThisDevice =>
      'Irá desconectar a sua conta do seu dispositivo!';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice =>
      'Irá desconectar a sua conta do seguinte dispositivo:';

  @override
  String get terminateSession => 'Terminar sessão?';

  @override
  String get terminate => 'Terminar';

  @override
  String get thisDevice => 'Este dispositivo';

  @override
  String get recoverButton => 'Recuperar';

  @override
  String get recoverySuccessful => 'Recuperação bem sucedida!';

  @override
  String get decrypting => 'A desencriptar…';

  @override
  String get incorrectRecoveryKeyTitle => 'Chave de recuperação incorreta';

  @override
  String get incorrectRecoveryKeyBody =>
      'A chave de recuperação inserida está incorreta';

  @override
  String get forgotPassword => 'Esqueceu-se da palavra-passe';

  @override
  String get enterYourRecoveryKey => 'Insira a sua chave de recuperação';

  @override
  String get noRecoveryKey => 'Não tem chave de recuperação?';

  @override
  String get sorry => 'Desculpe';

  @override
  String get noRecoveryKeyNoDecryption =>
      'Devido à natureza do nosso protocolo de criptografia de ponta a ponta, os seus dados não podem ser descriptografados sem a sua palavra-passe ou a sua chave de recuperação';

  @override
  String get verifyEmail => 'Verificar email';

  @override
  String get toResetVerifyEmail =>
      'Para redefinir a sua palavra-passe, verifique primeiro o seu e-mail.';

  @override
  String get checkInboxAndSpamFolder =>
      'Verifique a sua caixa de entrada (e spam) para concluir a verificação';

  @override
  String get tapToEnterCode => 'Toque para inserir código';

  @override
  String get resendEmail => 'Reenviar e-mail';

  @override
  String weHaveSendEmailTo({required String email}) {
    return 'Enviamos um e-mail para <green>$email</green>';
  }

  @override
  String get setPasswordTitle => 'Definir palavra-passe';

  @override
  String get changePasswordTitle => 'Alterar palavra-passe';

  @override
  String get resetPasswordTitle => 'Redefinir palavra-passe';

  @override
  String get encryptionKeys => 'Chaves de encriptação';

  @override
  String get passwordWarning =>
      'Não armazenamos esta palavra-passe, se você a esquecer, <underline>não podemos desencriptar os seus dados</underline>';

  @override
  String get enterPasswordToEncrypt =>
      'Inserir uma palavra-passe para encriptar os seus dados';

  @override
  String get enterNewPasswordToEncrypt =>
      'Inserir uma nova palavra-passe para encriptar os seus dados';

  @override
  String get weakStrength => 'Fraca';

  @override
  String get strongStrength => 'Forte';

  @override
  String get moderateStrength => 'Moderada';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'Força da palavra-passe: $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully =>
      'Palavra-passe alterada com sucesso';

  @override
  String get generatingEncryptionKeys => 'Gerando chaves de encriptação...';

  @override
  String get pleaseWait => 'Por favor, aguarde ...';

  @override
  String get continueLabel => 'Continuar';

  @override
  String get insecureDevice => 'Dispositivo inseguro';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'Desculpe, não foi possível gerar chaves seguras neste dispositivo.\n\npor favor iniciar sessão com um dispositivo diferente.';

  @override
  String get howItWorks => 'Como funciona';

  @override
  String get encryption => 'Encriptação';

  @override
  String get ackPasswordLostWarning =>
      'Eu entendo que se eu perder a minha palavra-passe, posso perder os meus dados já que esses dados são <underline> encriptados de ponta a ponta</underline>.';

  @override
  String get privacyPolicyTitle => 'Política de privacidade';

  @override
  String get termsOfServicesTitle => 'Termos';

  @override
  String get signUpTerms =>
      'Eu concordo com os <u-terms>termos de serviço</u-terms> e <u-policy>política de privacidade</u-policy>';

  @override
  String get logInLabel => 'Iniciar sessão';

  @override
  String get loginTerms =>
      'Ao clicar em iniciar sessão, eu concordo com os termos <u-terms>de serviço</u-terms> e <u-policy>política de privacidade</u-policy>';

  @override
  String get changeEmail => 'Alterar e-mail';

  @override
  String get enterYourPassword => 'Introduza a sua palavra-passe';

  @override
  String get welcomeBack => 'Bem-vindo(a) de volta!';

  @override
  String get contactSupport => 'Contactar o suporte';

  @override
  String get locationPickerTip =>
      'You can also add a location centered on a photo from the photo\'s info screen';

  @override
  String get incorrectPasswordTitle => 'Palavra-passe incorreta';

  @override
  String get pleaseTryAgain => 'Por favor, tente novamente';

  @override
  String get recreatePasswordTitle => 'Recriar palavra-passe';

  @override
  String get useRecoveryKey => 'Usar chave de recuperação';

  @override
  String get recreatePasswordBody =>
      'O dispositivo atual não é suficientemente poderoso para verificar a palavra-passe, mas podemos regenerar novamente de uma maneira que funcione no seu dispositivo.\n\nPor favor, iniciar sessão utilizando código de recuperação e gerar novamente a sua palavra-passe (pode utilizar a mesma se quiser).';

  @override
  String get verifyPassword => 'Verificar palavra-passe';

  @override
  String get recoveryKey => 'Chave de recuperação';

  @override
  String get recoveryKeyOnForgotPassword =>
      'Se esquecer sua palavra-passe, a única maneira de recuperar os seus dados é com esta chave.';

  @override
  String get recoveryKeySaveDescription =>
      'Não armazenamos essa chave, por favor, guarde esta chave de 24 palavras num lugar seguro.';

  @override
  String get doThisLater => 'Fazer isto mais tarde';

  @override
  String get saveKey => 'Guardar chave';

  @override
  String get recoveryKeyCopiedToClipboard =>
      'Chave de recuperação copiada para a área de transferência';

  @override
  String get recoverAccount => 'Recuperar conta';

  @override
  String get recover => 'Recuperar';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'Envie um e-mail para $supportEmail a partir do seu endereço de e-mail registado';
  }

  @override
  String get twofactorSetup => 'Configuração de dois fatores';

  @override
  String get enterCode => 'Insira o código';

  @override
  String get scanCode => 'Ler código Qr';

  @override
  String get codeCopiedToClipboard =>
      'Código copiado para área de transferência';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      'Copie e cole este código\nno seu aplicativo de autenticação';

  @override
  String get tapToCopy => 'toque para copiar';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      'Leia este código com a sua aplicação dois fatores.';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      'Introduzir o código de 6 dígitos da\nsua aplicação de autenticação';

  @override
  String get confirm => 'Confirmar';

  @override
  String get setupComplete => 'Configuração concluída';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready =>
      'Guarde a sua chave de recuperação, caso ainda não o tenha feito';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      'Isto pode ser usado para recuperar sua conta se você perder seu segundo fator';

  @override
  String get twofactorAuthenticationPageTitle => 'Autenticação de dois fatores';

  @override
  String get lostDevice => 'Perdeu o seu dispositívo?';

  @override
  String get verifyingRecoveryKey => 'Verificando chave de recuperação...';

  @override
  String get recoveryKeyVerified => 'Chave de recuperação verificada';

  @override
  String get recoveryKeySuccessBody =>
      'Ótimo! A sua chave de recuperação é válida. Obrigado por verificar.\n\nLembre-se de manter cópia de segurança da sua chave de recuperação.';

  @override
  String get invalidRecoveryKey =>
      'A chave de recuperação que inseriu não é válida. Por favor, certifique-se que ela contém 24 palavras e verifique a ortografia de cada uma.\n\nSe inseriu um código de recuperação mais antigo, certifique-se de que tem 64 caracteres e verifique cada um deles.';

  @override
  String get invalidKey => 'Chave inválida';

  @override
  String get tryAgain => 'Tente novamente';

  @override
  String get viewRecoveryKey => 'Ver chave de recuperação';

  @override
  String get confirmRecoveryKey => 'Confirmar chave de recuperação';

  @override
  String get recoveryKeyVerifyReason =>
      'A sua chave de recuperação é a única forma de recuperar as suas fotografias se se esquecer da sua palavra-passe. Pode encontrar a sua chave de recuperação em Definições > Conta.\n\n\nIntroduza aqui a sua chave de recuperação para verificar se a guardou corretamente.';

  @override
  String get confirmYourRecoveryKey => 'Confirmar chave de recuperação';

  @override
  String get addViewer => 'Adicionar visualizador';

  @override
  String get addCollaborator => 'Adicionar colaborador';

  @override
  String get addANewEmail => 'Adicionar um novo e-mail';

  @override
  String get orPickAnExistingOne => 'Ou escolha um já existente';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'Os colaboradores podem adicionar fotos e vídeos ao álbum compartilhado.';

  @override
  String get enterEmail => 'Digite o e-mail';

  @override
  String get albumOwner => 'Dono';

  @override
  String get you => 'Tu';

  @override
  String get collaborator => 'Colaborador';

  @override
  String get addMore => 'Adicionar mais';

  @override
  String get viewer => 'Visualizador';

  @override
  String get remove => 'Remover';

  @override
  String get removeParticipant => 'Remover participante';

  @override
  String get manage => 'Gerir';

  @override
  String get addedAs => 'Adicionado como';

  @override
  String get changePermissions => 'Alterar permissões';

  @override
  String get yesConvertToViewer => 'Sim, converter para visualizador';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return '$user não será capaz de adicionar mais fotos a este álbum\n\nEles ainda serão capazes de remover fotos existentes adicionadas por eles';
  }

  @override
  String get allowAddingPhotos => 'Permitir adicionar fotos';

  @override
  String get allowJoiningAlbum => 'Allow joining album';

  @override
  String get allowAddPhotosDescription =>
      'Permitir que pessoas com o link também adicionem fotos ao álbum compartilhado.';

  @override
  String get passwordLock => 'Bloqueio da palavra-passe';

  @override
  String get canNotOpenTitle => 'Cannot open this album';

  @override
  String get canNotOpenBody => 'Sorry, this album cannot be opened in the app.';

  @override
  String get disableDownloadWarningTitle => 'Por favor, observe';

  @override
  String get disableDownloadWarningBody =>
      'Visualizadores ainda podem fazer capturas de tela ou salvar uma cópia das suas fotos usando ferramentas externas';

  @override
  String get allowDownloads => 'Permitir downloads';

  @override
  String get linkDeviceLimit => 'Limite de dispositivo';

  @override
  String get noDeviceLimit => 'Nenhum';

  @override
  String get albumLayout => 'Album layout';

  @override
  String get layoutGrouped => 'Grouped';

  @override
  String get layoutContinuous => 'Continuous';

  @override
  String get layoutTrip => 'Trip';

  @override
  String get preview => 'Preview';

  @override
  String get linkExpiry => 'Link expirado';

  @override
  String get linkExpired => 'Expirado';

  @override
  String get linkEnabled => 'Ativado';

  @override
  String get linkNeverExpires => 'Nunca';

  @override
  String get expiredLinkInfo =>
      'Este link expirou. Por favor, selecione um novo tempo de expiração ou desabilite a expiração do link.';

  @override
  String get setAPassword => 'Definir uma palavra-passe';

  @override
  String get lockButtonLabel => 'Bloquear';

  @override
  String get enterPassword => 'Introduzir palavra-passe';

  @override
  String get removeLink => 'Remover link';

  @override
  String get manageLink => 'Gerir link';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'O link expirará em $expiryTime';
  }

  @override
  String get albumUpdated => 'Álbum atualizado';

  @override
  String get never => 'Nunca';

  @override
  String get custom => 'Personalizado';

  @override
  String get after1Hour => 'Depois de 1 Hora';

  @override
  String get after1Day => 'Depois de 1 dia';

  @override
  String get after1Week => 'Depois de 1 semana';

  @override
  String get after1Month => 'Depois de 1 mês';

  @override
  String get after1Year => 'Depois de 1 ano';

  @override
  String get manageParticipants => 'Gerir';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count participantes',
      one: '1 participante',
      zero: 'Nenhum participante',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'Criar um link para permitir que as pessoas adicionem e visualizem fotos em seu álbum compartilhado sem precisar de um aplicativo Ente ou conta. Ótimo para coletar fotos do evento.';

  @override
  String get collectPhotos => 'Coletar fotos';

  @override
  String get collaborativeLink => 'Link colaborativo';

  @override
  String get shareWithNonenteUsers =>
      'Compartilhar com usuários que não usam Ente';

  @override
  String get createPublicLink => 'Criar link público';

  @override
  String get sendLink => 'Enviar link';

  @override
  String get qrCode => 'QR Code';

  @override
  String get sendQrCode => 'Send QR code';

  @override
  String get copyLink => 'Copiar link';

  @override
  String get copyEmbedHtml => 'Copy embed HTML';

  @override
  String get linkHasExpired => 'O link expirou';

  @override
  String get publicLinkEnabled => 'Link público ativado';

  @override
  String get shareALink => 'Partilhar um link';

  @override
  String get sharedAlbumSectionDescription =>
      'Criar álbuns compartilhados e colaborativos com outros usuários da Ente, incluindo usuários em planos gratuitos.';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: 'Compartilhado com $numberOfPeople pessoas',
      one: 'Compartilhado com 1 pessoa',
      zero: 'Compartilhe com pessoas específicas',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId => 'Este é o seu ID de verificação';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'Alguém compartilhando álbuns com você deve ver o mesmo ID no seu dispositivo.';

  @override
  String get howToViewShareeVerificationID =>
      'Por favor, peça-lhes para pressionar longamente o endereço de e-mail na tela de configurações e verifique se os IDs de ambos os dispositivos coincidem.';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'Este é o ID de verificação de $email';
  }

  @override
  String get verificationId => 'ID de Verificação';

  @override
  String verifyEmailID({required Object email}) {
    return 'Verificar e-mail';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return '$email não possui uma conta Ente.\n\nEnvie um convite para compartilhar fotos.';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return 'Aqui está o meu ID de verificação: $verificationID para ente.io.';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'Ei, você pode confirmar que este é seu ID de verificação do ente.io: $verificationID';
  }

  @override
  String get somethingWentWrong => 'Ocorreu um erro';

  @override
  String get sendInvite => 'Enviar convite';

  @override
  String get shareTextRecommendUsingEnte =>
      'Descarregue o Ente para poder partilhar facilmente fotografias e vídeos de qualidade original\n\n\nhttps://ente.io';

  @override
  String get done => 'Concluído';

  @override
  String get applyCodeTitle => 'Aplicar código';

  @override
  String get enterCodeDescription =>
      'Introduza o código fornecido pelo seu amigo para obter armazenamento gratuito para ambos';

  @override
  String get apply => 'Aplicar';

  @override
  String get failedToApplyCode => 'Falha ao aplicar código';

  @override
  String get enterReferralCode => 'Insira o código de referência';

  @override
  String get codeAppliedPageTitle => 'Código aplicado';

  @override
  String get changeYourReferralCode => 'Alterar o código de referência';

  @override
  String get change => 'Alterar';

  @override
  String get unavailableReferralCode =>
      'Desculpe, este código não está disponível.';

  @override
  String get codeChangeLimitReached =>
      'Desculpe, você atingiu o limite de alterações de código.';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'Entre em contato com $familyAdminEmail para alterar o seu código.';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB';
  }

  @override
  String get claimed => 'Reclamado';

  @override
  String get details => 'Detalhes';

  @override
  String get claimMore => 'Reclamar mais!';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return 'Eles também recebem $storageAmountInGB GB';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB sempre que alguém se inscreve num plano pago e aplica o seu código';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'Insira o código de referência: $referralCode \n\nAplique-o em Configurações → Geral → Indicações para obter $referralStorageInGB GB gratuitamente após a sua inscrição para um plano pago\n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => 'Solicitar armazenamento gratuito';

  @override
  String get inviteYourFriends => 'Convide os seus amigos';

  @override
  String get failedToFetchReferralDetails =>
      'Não foi possível obter detalhes de indicação. Por favor, tente novamente mais tarde.';

  @override
  String get referralStep1 => '1. Envie este código aos seus amigos';

  @override
  String get referralStep2 => '2. Eles se inscrevem em um plano pago';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. Ambos ganham $storageInGB GB* grátis';
  }

  @override
  String get referralsAreCurrentlyPaused =>
      'As referências estão atualmente em pausa';

  @override
  String get youCanAtMaxDoubleYourStorage =>
      '* Você pode duplicar seu armazenamento no máximo';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true': 'Sua família reinvidicou $storageAmountInGb GB até então',
      'false': 'Você reinvindicou $storageAmountInGb GB até então',
      'other': 'Você reinvindicou $storageAmountInGb GB até então!',
    });
    return '$_temp0';
  }

  @override
  String get faq => 'Perguntas Frequentes';

  @override
  String get help => 'Ajuda';

  @override
  String get oopsSomethingWentWrong => 'Ops, algo deu errado';

  @override
  String get peopleUsingYourCode => 'Pessoas que utilizam seu código';

  @override
  String get eligible => 'elegível';

  @override
  String get total => 'total';

  @override
  String get codeUsedByYou => 'Código usado por você';

  @override
  String get freeStorageClaimed => 'Armazenamento gratuito reclamado';

  @override
  String get freeStorageUsable => 'Armazenamento livre utilizável';

  @override
  String get usableReferralStorageInfo =>
      'O armazenamento disponível é limitado pelo seu plano atual. O excesso de armazenamento reivindicado tornará automaticamente útil quando você atualizar seu plano.';

  @override
  String get removeFromAlbumTitle => 'Remover do álbum';

  @override
  String get removeFromAlbum => 'Remover do álbum';

  @override
  String get itemsWillBeRemovedFromAlbum =>
      'Os itens selecionados serão removidos deste álbum';

  @override
  String get removeShareItemsWarning =>
      'Alguns dos itens que você está removendo foram adicionados por outras pessoas, e você perderá o acesso a eles';

  @override
  String get addingToFavorites => 'Adicionando aos favoritos...';

  @override
  String get removingFromFavorites => 'Removendo dos favoritos...';

  @override
  String get sorryCouldNotAddToFavorites =>
      'Desculpe, não foi possível adicionar aos favoritos!';

  @override
  String get sorryCouldNotRemoveFromFavorites =>
      'Desculpe, não foi possível remover dos favoritos!';

  @override
  String get subscribeToEnableSharing =>
      'Você precisa de uma assinatura paga ativa para ativar o compartilhamento.';

  @override
  String get subscribe => 'Subscrever';

  @override
  String get canOnlyRemoveFilesOwnedByYou => '';

  @override
  String get deleteSharedAlbum => 'Excluir álbum compartilhado?';

  @override
  String get deleteAlbum => 'Apagar álbum';

  @override
  String get deleteAlbumDialog =>
      'Eliminar também as fotos (e vídeos) presentes neste álbum de <bold>all</bold>  os outros álbuns de que fazem parte?';

  @override
  String get deleteSharedAlbumDialogBody =>
      'O álbum será apagado para todos\n\nVocê perderá o acesso a fotos compartilhadas neste álbum que são propriedade de outros';

  @override
  String get yesRemove => 'Sim, remover';

  @override
  String get creatingLink => 'Criar link...';

  @override
  String get removeWithQuestionMark => 'Remover?';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return '$userEmail será removido deste álbum compartilhado\n\nQuaisquer fotos adicionadas por elas também serão removidas do álbum';
  }

  @override
  String get keepPhotos => 'Manter fotos';

  @override
  String get deletePhotos => 'Apagar fotos';

  @override
  String get inviteToEnte => 'Convidar para Ente';

  @override
  String get removePublicLink => 'Remover link público';

  @override
  String disableLinkMessage({required Object albumName}) {
    return 'Isto removerá o link público para acessar \"$albumName\".';
  }

  @override
  String get sharing => 'Partilhar...';

  @override
  String get youCannotShareWithYourself => 'Não podes partilhar contigo mesmo';

  @override
  String get archive => '............';

  @override
  String get createAlbumActionHint =>
      'Pressione e segure para selecionar fotos e clique em + para criar um álbum';

  @override
  String get importing => 'A importar...';

  @override
  String get failedToLoadAlbums => 'Falha ao carregar álbuns';

  @override
  String get hidden => 'Oculto';

  @override
  String get authToViewYourHiddenFiles =>
      'Por favor, autentique para ver seus arquivos ocultos';

  @override
  String get authToViewTrashedFiles =>
      'Please authenticate to view your trashed files';

  @override
  String get trash => 'Lixo';

  @override
  String get uncategorized => 'Sem categoria';

  @override
  String get videoSmallCase => 'vídeo';

  @override
  String get photoSmallCase => 'foto';

  @override
  String get singleFileDeleteHighlight => 'Será eliminado de todos os álbuns.';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return 'Este $fileType encontra-se tanto no Ente como no seu dispositivo.';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return 'Este $fileType será eliminado do Ente.';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return 'Este $fileType será eliminado do seu dispositivo.';
  }

  @override
  String get deleteFromEnte => 'Apagar do Ente';

  @override
  String get yesDelete => 'Sim, apagar';

  @override
  String get movedToTrash => 'Mover para o lixo';

  @override
  String get deleteFromDevice => 'Apagar do dispositivo';

  @override
  String get deleteFromBoth => 'Apagar de ambos';

  @override
  String get newAlbum => 'Novo álbum';

  @override
  String get albums => 'Álbuns';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount memories',
      one: '$formattedCount memory',
      zero: 'no memories',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return '$count selecionado(s)';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return '$count selecionado(s) ($yourCount seus)';
  }

  @override
  String get advancedSettings => 'Definições avançadas';

  @override
  String get photoGridSize => 'Tamanho da grelha de fotos';

  @override
  String get manageDeviceStorage => 'Manage device cache';

  @override
  String get manageDeviceStorageDesc =>
      'Reveja e limpe o armazenamento de cache local.';

  @override
  String get machineLearning => 'Aprendizagem automática';

  @override
  String get mlConsent => 'Ativar aprendizagem automática';

  @override
  String get mlConsentTitle => 'Ativar aprendizagem automática?';

  @override
  String get mlConsentDescription =>
      'Se ativar a aprendizagem automática, o Ente extrairá informações como a geometria do rosto de ficheiros, incluindo os partilhados consigo.\n\n\nIsto acontecerá no seu dispositivo e todas as informações biométricas geradas serão encriptadas de ponta a ponta.';

  @override
  String get mlConsentPrivacy =>
      'Por favor, clique aqui para mais detalhes sobre este recurso na nossa política de privacidade';

  @override
  String get mlConsentConfirmation =>
      'Eu entendo, e desejo ativar a aprendizagem automática';

  @override
  String get magicSearch => 'Pesquisa mágica';

  @override
  String get discover => 'Descobrir';

  @override
  String get discover_identity => 'Identidade';

  @override
  String get discover_screenshots => 'Capturas de ecrã';

  @override
  String get discover_receipts => 'Recibos';

  @override
  String get discover_notes => 'Notas';

  @override
  String get discover_memes => 'Memes';

  @override
  String get discover_visiting_cards => 'Cartões de visita';

  @override
  String get discover_babies => 'Bebés';

  @override
  String get discover_pets => 'Animais de estimação';

  @override
  String get discover_selfies => 'Selfies';

  @override
  String get discover_wallpapers => 'Papéis de parede';

  @override
  String get discover_food => 'Comida';

  @override
  String get discover_celebrations => 'Comemorações';

  @override
  String get discover_sunset => 'Pôr do sol';

  @override
  String get discover_hills => 'Colinas';

  @override
  String get discover_greenery => 'Vegetação';

  @override
  String get mlIndexingDescription =>
      'Tenha em atenção que a aprendizagem automática resultará numa maior utilização da largura de banda e da bateria até que todos os itens sejam indexados. Considere utilizar a aplicação de ambiente de trabalho para uma indexação mais rápida, todos os resultados serão sincronizados automaticamente.';

  @override
  String get loadingModel => 'Transferindo modelos...';

  @override
  String get waitingForWifi => 'Aguardando Wi-Fi...';

  @override
  String get status => 'Status';

  @override
  String get indexedItems => 'Itens indexados';

  @override
  String get pendingItems => 'Itens pendentes';

  @override
  String get clearIndexes => 'Limpar índices';

  @override
  String get selectFoldersForBackup =>
      'Selecionar pastas para cópia de segurança';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      'As pastas selecionadas serão encriptadas e guardadas como cópia de segurança';

  @override
  String get unselectAll => 'Desmarcar tudo';

  @override
  String get selectAll => 'Selecionar tudo';

  @override
  String get skip => 'Pular';

  @override
  String get updatingFolderSelection => 'Atualizando seleção de pasta...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count itens',
      one: '$count item',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Apagar $count itens',
      one: 'Apagar $count item',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count arquivos, $formattedSize cada';
  }

  @override
  String get showMemories => 'Mostrar memórias';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count anos atrás',
      one: '$count ano atrás',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'Definições da cópia de segurança';

  @override
  String get backupStatus => 'Status da cópia de segurança';

  @override
  String get backupStatusDescription =>
      'Os itens que foram salvos com segurança aparecerão aqui';

  @override
  String get backupOverMobileData =>
      'Cópia de segurança através dos dados móveis';

  @override
  String get backupVideos => 'Cópia de segurança de vídeos';

  @override
  String get disableAutoLock => 'Desativar bloqueio automático';

  @override
  String get deviceLockExplanation =>
      'Desativar o bloqueio do ecrã do dispositivo quando o Ente estiver em primeiro plano e houver uma cópia de segurança em curso. Normalmente, isto não é necessário, mas pode ajudar a que os grandes carregamentos e as importações iniciais de grandes bibliotecas sejam concluídos mais rapidamente.';

  @override
  String get about => 'Sobre';

  @override
  String get weAreOpenSource => 'Nós somos de código aberto!';

  @override
  String get privacy => 'Privacidade';

  @override
  String get terms => 'Termos';

  @override
  String get checkForUpdates => 'Procurar atualizações';

  @override
  String get checkStatus => 'Verificar status';

  @override
  String get checking => 'A verificar...';

  @override
  String get youAreOnTheLatestVersion =>
      'Está a utilizar a versão mais recente';

  @override
  String get account => 'Conta';

  @override
  String get manageSubscription => 'Gerir subscrição';

  @override
  String get authToChangeYourEmail =>
      'Por favor, autentique-se para alterar o seu e-mail';

  @override
  String get changePassword => 'Alterar palavra-passe';

  @override
  String get authToChangeYourPassword =>
      'Por favor, autentique-se para alterar a palavra-passe';

  @override
  String get emailVerificationToggle => 'Verificação por e-mail';

  @override
  String get authToChangeEmailVerificationSetting =>
      'Por favor, autentique-se para alterar a verificação de e-mail';

  @override
  String get exportYourData => 'Exportar os seus dados';

  @override
  String get logout => 'Terminar sessão';

  @override
  String get authToInitiateAccountDeletion =>
      'Autentique-se para iniciar a eliminação da conta';

  @override
  String get areYouSureYouWantToLogout =>
      'Tem certeza que deseja terminar a sessão?';

  @override
  String get yesLogout => 'Sim, terminar sessão';

  @override
  String get aNewVersionOfEnteIsAvailable =>
      'Está disponível uma nova versão do Ente.';

  @override
  String get update => 'Atualizar';

  @override
  String get installManually => 'Instalar manualmente';

  @override
  String get criticalUpdateAvailable => 'Atualização crítica disponível';

  @override
  String get updateAvailable => 'Atualização disponível';

  @override
  String get ignoreUpdate => 'Ignorar';

  @override
  String get downloading => 'A transferir...';

  @override
  String get cannotDeleteSharedFiles =>
      'Não é possível eliminar ficheiros partilhados';

  @override
  String get theDownloadCouldNotBeCompleted =>
      'Não foi possível concluir o download.';

  @override
  String get retry => 'Tentar novamente';

  @override
  String get backedUpFolders => 'Pastas com cópia de segurança';

  @override
  String get backup => 'Cópia de segurança';

  @override
  String get freeUpDeviceSpace => 'Libertar espaço no dispositivo';

  @override
  String get freeUpDeviceSpaceDesc =>
      'Poupe espaço no seu dispositivo limpando ficheiros dos quais já foi feita uma cópia de segurança.';

  @override
  String get allClear => '✨ Tudo limpo';

  @override
  String get noDeviceThatCanBeDeleted =>
      'Você não tem arquivos neste dispositivo que possam ser apagados';

  @override
  String get removeDuplicates => 'Remover duplicados';

  @override
  String get removeDuplicatesDesc =>
      'Rever e remover ficheiros que sejam duplicados exatos.';

  @override
  String get viewLargeFiles => 'Ficheiros grandes';

  @override
  String get viewLargeFilesDesc =>
      'Ver os ficheiros que estão a consumir a maior quantidade de armazenamento.';

  @override
  String get noDuplicates => '✨ Sem duplicados';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared =>
      'You don\'t have any duplicate files that can be cleared';

  @override
  String get success => 'Sucesso';

  @override
  String get rateUs => 'Avalie-nos';

  @override
  String get remindToEmptyDeviceTrash =>
      'Esvazie também a opção “Eliminados recentemente” em “Definições” -> “Armazenamento” para reclamar o espaço libertado';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return 'Você liberou $storageSaved com sucesso!';
  }

  @override
  String get remindToEmptyEnteTrash =>
      'Esvazie também o seu “Lixo” para reivindicar o espaço libertado';

  @override
  String get sparkleSuccess => '✨ Sucesso';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count arquivos duplicados',
      one: '$count arquivo duplicado',
    );
    return 'Você limpou $_temp0, guardando ($storageSaved!)';
  }

  @override
  String get familyPlans => 'Planos familiares';

  @override
  String get referrals => 'Referências';

  @override
  String get notifications => 'Notificações';

  @override
  String get sharedPhotoNotifications => 'Novas fotos partilhadas';

  @override
  String get sharedPhotoNotificationsExplanation =>
      'Receber notificações quando alguém adiciona uma foto a um álbum partilhado do qual faz parte';

  @override
  String get advanced => 'Avançado';

  @override
  String get general => 'Geral';

  @override
  String get security => 'Segurança';

  @override
  String get authToViewYourRecoveryKey =>
      'Por favor, autentique-se para ver a chave de recuperação';

  @override
  String get twofactor => 'Dois fatores';

  @override
  String get authToConfigureTwofactorAuthentication =>
      'Por favor, autentique para configurar a autenticação de dois fatores';

  @override
  String get lockscreen => 'Ecrã de bloqueio';

  @override
  String get authToChangeLockscreenSetting =>
      'Por favor, autentique-se para alterar a configuração da tela do ecrã de bloqueio';

  @override
  String get viewActiveSessions => 'Ver sessões ativas';

  @override
  String get authToViewYourActiveSessions =>
      'Por favor, autentique-se para ver as suas sessões ativas';

  @override
  String get disableTwofactor => 'Desativar autenticação de dois fatores';

  @override
  String get confirm2FADisable =>
      'Tem a certeza de que pretende desativar a autenticação de dois fatores?';

  @override
  String get no => 'Não';

  @override
  String get yes => 'Sim';

  @override
  String get social => 'Social';

  @override
  String rateUsOnStore({required Object storeName}) {
    return 'Avalie-nos em $storeName';
  }

  @override
  String get blog => 'Blog';

  @override
  String get merchandise => 'Produtos';

  @override
  String get twitter => 'Twitter';

  @override
  String get mastodon => 'Mastodon';

  @override
  String get matrix => 'Matrix';

  @override
  String get discord => 'Discord';

  @override
  String get reddit => 'Reddit';

  @override
  String get yourStorageDetailsCouldNotBeFetched =>
      'Não foi possível obter os seus dados de armazenamento';

  @override
  String get reportABug => 'Reporte um bug';

  @override
  String get reportBug => 'Reportar bug';

  @override
  String get suggestFeatures => 'Sugerir recursos';

  @override
  String get support => 'Suporte';

  @override
  String get theme => 'Tema';

  @override
  String get lightTheme => 'Claro';

  @override
  String get darkTheme => 'Escuro';

  @override
  String get systemTheme => 'Sistema';

  @override
  String get freeTrial => 'Teste grátis';

  @override
  String get selectYourPlan => 'Selecione o seu plano';

  @override
  String get enteSubscriptionPitch =>
      'O Ente preserva as suas memórias, para que estejam sempre disponíveis, mesmo que perca o seu dispositivo.';

  @override
  String get enteSubscriptionShareWithFamily =>
      'Sua família também pode ser adicionada ao seu plano.';

  @override
  String get currentUsageIs => 'O uso atual é ';

  @override
  String get faqs => 'Perguntas frequentes';

  @override
  String renewsOn({required Object endDate}) {
    return 'A subscrição é renovada em $endDate';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return 'Teste gratuito válido até $endDate';
  }

  @override
  String validTill({required Object endDate}) {
    return 'Válido até $endDate';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return 'Seu addon $storageAmount é válido até o momento $endDate';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return 'Teste gratuito válido até $endDate.\nVocê pode escolher um plano pago depois.';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'A sua subscrição será cancelada em $endDate';
  }

  @override
  String get subscription => 'Subscrição';

  @override
  String get paymentDetails => 'Detalhes de pagamento';

  @override
  String get manageFamily => 'Gerir família';

  @override
  String contactToManageSubscription({required Object provider}) {
    return 'Contacte-nos em support@ente.io para gerir a sua subscrição $provider';
  }

  @override
  String get renewSubscription => 'Renovar subscrição';

  @override
  String get cancelSubscription => 'Cancelar subscrição';

  @override
  String get areYouSureYouWantToRenew =>
      'Tem a certeza de que pretende renovar?';

  @override
  String get yesRenew => 'Sim, Renovar';

  @override
  String get areYouSureYouWantToCancel => 'Tem a certeza de que quer cancelar?';

  @override
  String get yesCancel => 'Sim, cancelar';

  @override
  String get failedToRenew => 'Falhou ao renovar';

  @override
  String get failedToCancel => 'Falhou ao cancelar';

  @override
  String get twoMonthsFreeOnYearlyPlans => '2 meses grátis em planos anuais';

  @override
  String get monthly => 'Mensal';

  @override
  String get yearly => 'Anual';

  @override
  String get confirmPlanChange => 'Confirmar alteração de plano';

  @override
  String get areYouSureYouWantToChangeYourPlan =>
      'Tem a certeza de que pretende alterar o seu plano?';

  @override
  String get youCannotDowngradeToThisPlan =>
      'Não é possível fazer o downgrade para este plano';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'Por favor, cancele primeiro a sua subscrição existente de $paymentProvider';
  }

  @override
  String get optionalAsShortAsYouLike => 'Opcional, o mais breve que quiser...';

  @override
  String get send => 'Enviar';

  @override
  String get askCancelReason =>
      'A sua subscrição foi cancelada. Gostaria de partilhar o motivo?';

  @override
  String get thankYouForSubscribing => 'Obrigado pela sua subscrição!';

  @override
  String get yourPurchaseWasSuccessful =>
      'Sua compra foi realizada com sucesso';

  @override
  String get yourPlanWasSuccessfullyUpgraded =>
      'O seu plano foi atualizado com sucesso';

  @override
  String get yourPlanWasSuccessfullyDowngraded =>
      'O seu plano foi rebaixado com sucesso';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully =>
      'A sua subscrição foi actualizada com sucesso';

  @override
  String get googlePlayId => 'ID do Google Play';

  @override
  String get appleId => 'ID da Apple';

  @override
  String get playstoreSubscription => 'Subscrição da PlayStore';

  @override
  String get appstoreSubscription => 'Subscrição da AppStore';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return 'Seu $id já está vinculado a outra conta Ente.\nSe você gostaria de usar seu $id com esta conta, por favor contate nosso suporte\'\'';
  }

  @override
  String get visitWebToManage =>
      'Visite web.ente.io para gerir a sua subscrição';

  @override
  String get couldNotUpdateSubscription =>
      'Não foi possível atualizar a subscrição';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      'Por favor, entre em contato com support@ente.io e nós ficaremos felizes em ajudar!';

  @override
  String get paymentFailed => 'O pagamento falhou';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return 'Por favor, fale com o suporte $providerName se você foi cobrado';
  }

  @override
  String get continueOnFreeTrial => 'Continuar em teste gratuito';

  @override
  String get areYouSureYouWantToExit => 'Tem certeza de que deseja sair?';

  @override
  String get thankYou => 'Obrigado';

  @override
  String get failedToVerifyPaymentStatus =>
      'Falha ao verificar status do pagamento';

  @override
  String get pleaseWaitForSometimeBeforeRetrying =>
      'Por favor, aguarde algum tempo antes de tentar novamente';

  @override
  String get paymentFailedMessage =>
      'Infelizmente o seu pagamento falhou. Entre em contato com o suporte e nós ajudaremos você!';

  @override
  String get youAreOnAFamilyPlan => 'Você está em um plano familiar!';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'Contacte <green>$familyAdminEmail</green> para gerir a sua subscrição';
  }

  @override
  String get leaveFamily => 'Deixar plano famíliar';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily =>
      'Tem certeza que deseja sair do plano familiar?';

  @override
  String get leave => 'Sair';

  @override
  String get rateTheApp => 'Avaliar aplicação';

  @override
  String get startBackup => 'Iniciar cópia de segurança';

  @override
  String get noPhotosAreBeingBackedUpRightNow =>
      'No momento não há backup de fotos sendo feito';

  @override
  String get preserveMore => 'Preservar mais';

  @override
  String get grantFullAccessPrompt =>
      'Por favor, permita o acesso a todas as fotos nas definições do aplicativo';

  @override
  String get allowPermTitle => 'Allow access to photos';

  @override
  String get allowPermBody =>
      'Please allow access to your photos from Settings so Ente can display and backup your library.';

  @override
  String get openSettings => 'Abrir Definições';

  @override
  String get selectMorePhotos => 'Selecionar mais fotos';

  @override
  String get existingUser => 'Utilizador existente';

  @override
  String get privateBackups => 'Backups privados';

  @override
  String get forYourMemories => 'para suas memórias';

  @override
  String get endtoendEncryptedByDefault =>
      'Criptografia de ponta a ponta por padrão';

  @override
  String get safelyStored => 'Armazenado com segurança';

  @override
  String get atAFalloutShelter => 'em um abrigo avançado';

  @override
  String get designedToOutlive => 'Feito para ter longevidade';

  @override
  String get available => 'Disponível';

  @override
  String get everywhere => 'em todo o lado';

  @override
  String get androidIosWebDesktop => 'Android, iOS, Web, Desktop';

  @override
  String get mobileWebDesktop => 'Mobile, Web, Desktop';

  @override
  String get newToEnte => 'Novo no Ente';

  @override
  String get pleaseLoginAgain => 'Por favor, inicie sessão novamente';

  @override
  String get autoLogoutMessage =>
      'Devido a uma falha técnica, a sua sessão foi encerrada. Pedimos desculpas pelo incómodo.';

  @override
  String get yourSubscriptionHasExpired => 'A sua subscrição expirou';

  @override
  String get storageLimitExceeded => 'Limite de armazenamento excedido';

  @override
  String get upgrade => 'Atualizar';

  @override
  String get raiseTicket => 'Abrir ticket';

  @override
  String get backupFailed => 'Backup falhou';

  @override
  String get sorryBackupFailedDesc =>
      'Sorry, we could not backup this file right now, we will retry later.';

  @override
  String get couldNotBackUpTryLater =>
      'Não foi possível fazer o backup de seus dados.\nTentaremos novamente mais tarde.';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      'Ente pode criptografar e preservar arquivos apenas se você conceder acesso a eles';

  @override
  String get pleaseGrantPermissions => 'Por favor, conceda as permissões';

  @override
  String get grantPermission => 'Conceder permissão';

  @override
  String get privateSharing => 'Partilha privada';

  @override
  String get shareOnlyWithThePeopleYouWant =>
      'Partilhar apenas com as pessoas que deseja';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      'Usar links públicos para pessoas que não estão no Ente';

  @override
  String get allowPeopleToAddPhotos =>
      'Permitir que as pessoas adicionem fotos';

  @override
  String get shareAnAlbumNow => 'Partilhar um álbum';

  @override
  String get collectEventPhotos => 'Coletar fotos do evento';

  @override
  String get sessionExpired => 'Sessão expirada';

  @override
  String get loggingOut => 'Terminar a sessão...';

  @override
  String get onDevice => 'No dispositivo';

  @override
  String get onEnte => 'Em <branding>ente</branding>';

  @override
  String get name => 'Nome';

  @override
  String get newest => 'Recentes';

  @override
  String get lastUpdated => 'Última atualização';

  @override
  String get deleteEmptyAlbums => 'Apagar álbuns vazios';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => 'Apagar álbuns vazios?';

  @override
  String get deleteAlbumsDialogBody =>
      'Esta ação elimina todos os álbuns vazios. Isto é útil quando pretende reduzir a confusão na sua lista de álbuns.';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return 'Apagar $currentlyDeleting / $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return 'Processando $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => 'Eliminar permanentemente';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou =>
      'Só pode criar um link para arquivos pertencentes a você';

  @override
  String get publicLinkCreated => 'Link público criado';

  @override
  String get youCanManageYourLinksInTheShareTab =>
      'Pode gerir as suas ligações no separador partilhar.';

  @override
  String get linkCopiedToClipboard =>
      'Link copiado para a área de transferência';

  @override
  String get restore => 'Restaurar';

  @override
  String get moveToAlbum => 'Mover para álbum';

  @override
  String get unhide => 'Mostrar';

  @override
  String get unarchive => 'Desarquivar';

  @override
  String get favorite => 'Favorito';

  @override
  String get removeFromFavorite => 'Remover dos favoritos';

  @override
  String get shareLink => 'Partilhar link';

  @override
  String get createCollage => 'Criar coleção';

  @override
  String get saveCollage => 'Guardar colagem';

  @override
  String get collageSaved => 'Colagem guardada na galeria';

  @override
  String get collageLayout => 'Layout';

  @override
  String get addToEnte => 'Adicionar ao Ente';

  @override
  String get addToAlbum => 'Adicionar ao álbum';

  @override
  String get delete => 'Apagar';

  @override
  String get hide => 'Ocultar';

  @override
  String get share => 'Partilhar';

  @override
  String get unhideToAlbum => 'Mostrar para o álbum';

  @override
  String get restoreToAlbum => 'Restaurar para álbum';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Move items',
      one: 'Move item',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add items',
      one: 'Add item',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'Criar ou selecionar álbum';

  @override
  String get selectAlbum => 'Selecionar álbum';

  @override
  String get searchByAlbumNameHint => 'Nome do álbum';

  @override
  String get albumTitle => 'Título do álbum';

  @override
  String get enterAlbumName => 'Introduzir nome do álbum';

  @override
  String get restoringFiles => 'Restaurar arquivos...';

  @override
  String get movingFilesToAlbum => 'Mover arquivos para o álbum...';

  @override
  String get unhidingFilesToAlbum => 'Desocultar ficheiros para o álbum';

  @override
  String get canNotUploadToAlbumsOwnedByOthers =>
      'Não é possível fazer upload para álbuns pertencentes a outros';

  @override
  String get uploadingFilesToAlbum => 'Enviar ficheiros para o álbum...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return 'Adicionado com sucesso a $albumName';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return 'Movido com sucesso para $albumName';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'Este álbum já tem um link colaborativo';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return 'Link colaborativo criado para $albumName';
  }

  @override
  String get askYourLovedOnesToShare =>
      'Peça aos seus entes queridos para partilharem';

  @override
  String get invite => 'Convidar';

  @override
  String get shareYourFirstAlbum => 'Partilhe o seu primeiro álbum';

  @override
  String sharedWith({required Object emailIDs}) {
    return 'Partilhado com $emailIDs';
  }

  @override
  String get sharedWithMe => 'Partilhado comigo';

  @override
  String get sharedByMe => 'Partilhado por mim';

  @override
  String get doubleYourStorage => 'Duplicar o seu armazenamento';

  @override
  String get referFriendsAnd2xYourPlan =>
      'Recomende amigos e duplique o seu plano';

  @override
  String get shareAlbumHint =>
      'Abra um álbum e toque no botão de partilha no canto superior direito para partilhar';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      'Os itens mostram o número de dias restantes antes da eliminação permanente';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count dias',
      one: '1 dia',
      zero: 'Brevemente',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => 'Apagar tudo';

  @override
  String get renameAlbum => 'Renomear álbum';

  @override
  String get convertToAlbum => 'Converter para álbum';

  @override
  String get setCover => 'Definir capa';

  @override
  String get sortAlbumsBy => 'Ordenar por';

  @override
  String get sortNewestFirst => 'Mais recentes primeiro';

  @override
  String get sortOldestFirst => 'Mais antigos primeiro';

  @override
  String get rename => 'Renomear';

  @override
  String get leaveSharedAlbum => 'Sair do álbum compartilhado?';

  @override
  String get leaveAlbum => 'Sair do álbum';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'As fotos adicionadas por si serão removidas do álbum';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted =>
      'Não existem ficheiros neste álbum que possam ser eliminados';

  @override
  String get youDontHaveAnyArchivedItems => 'Não tem nenhum item arquivado.';

  @override
  String get ignoredFolderUploadReason =>
      'Alguns ficheiros deste álbum não podem ser carregados porque foram anteriormente eliminados do Ente.';

  @override
  String get resetIgnoredFiles => 'Repor ficheiros ignorados';

  @override
  String get deviceFilesAutoUploading =>
      'Os ficheiros adicionados a este álbum de dispositivo serão automaticamente transferidos para o Ente.';

  @override
  String get turnOnBackupForAutoUpload =>
      'Ative o backup para enviar automaticamente arquivos adicionados a esta pasta do dispositivo para o Ente.';

  @override
  String get noHiddenPhotosOrVideos => 'Sem fotos ou vídeos ocultos';

  @override
  String get toHideAPhotoOrVideo => 'Para ocultar uma foto ou um vídeo';

  @override
  String get openTheItem => '• Abra o item';

  @override
  String get clickOnTheOverflowMenu => '• Clique no menu adicional';

  @override
  String get click => 'Clique';

  @override
  String get nothingToSeeHere => 'Nada para ver aqui! 👀';

  @override
  String get unarchiveAlbum => 'Desarquivar álbum';

  @override
  String get archiveAlbum => 'Arquivar álbum';

  @override
  String get calculating => 'Calcular...';

  @override
  String get pleaseWaitDeletingAlbum => 'Por favor aguarde,  apagar o álbum';

  @override
  String get searchByExamples =>
      '• Nomes de álbuns (ex: \"Câmera\")\n• Tipos de arquivos (ex.: \"Vídeos\", \".gif\")\n• Anos e meses (e.. \"2022\", \"Janeiro\")\n• Feriados (por exemplo, \"Natal\")\n• Descrições de fotos (por exemplo, \"#divertido\")';

  @override
  String get youCanTrySearchingForADifferentQuery =>
      'Pode tentar pesquisar uma consulta diferente.';

  @override
  String get noResultsFound => 'Não foram encontrados resultados';

  @override
  String addedBy({required Object emailOrName}) {
    return 'Adicionado por $emailOrName';
  }

  @override
  String get loadingExifData => 'Carregando dados EXIF...';

  @override
  String get viewAllExifData => 'Ver todos os dados EXIF';

  @override
  String get noExifData => 'Sem dados EXIF';

  @override
  String get thisImageHasNoExifData => 'Esta imagem não tem dados exif';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => 'Nenhum resultado';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'Não suportamos a edição de fotos e álbuns que ainda não possui';

  @override
  String get failedToFetchOriginalForEdit =>
      'Falha ao obter original para edição';

  @override
  String get close => 'Fechar';

  @override
  String get setAs => 'Definir como';

  @override
  String get fileSavedToGallery => 'Arquivo guardado na galeria';

  @override
  String get filesSavedToGallery => 'Arquivos guardados na galeria';

  @override
  String get fileFailedToSaveToGallery =>
      'Falha ao guardar o ficheiro na galeria';

  @override
  String get download => 'Download';

  @override
  String get pressAndHoldToPlayVideo =>
      'Pressione e segure para reproduzir o vídeo';

  @override
  String get pressAndHoldToPlayVideoDetailed =>
      'Pressione e segure na imagem para reproduzir o vídeo';

  @override
  String get downloadFailed => 'Falha no download';

  @override
  String get deduplicateFiles => 'Arquivos duplicados';

  @override
  String get deselectAll => 'Desmarcar tudo';

  @override
  String get reviewDeduplicateItems =>
      'Reveja e elimine os itens que considera serem duplicados.';

  @override
  String get clubByCaptureTime => 'Agrupar por tempo de captura';

  @override
  String get clubByFileName => 'Agrupar pelo nome de arquivo';

  @override
  String get count => 'Contagem';

  @override
  String get totalSize => 'Tamanho total';

  @override
  String get longpressOnAnItemToViewInFullscreen =>
      'Pressione e segure em um item para ver em tela cheia';

  @override
  String get decryptingVideo => 'Descriptografando vídeo...';

  @override
  String get authToViewYourMemories =>
      'Por favor, autentique-se para ver suas memórias';

  @override
  String get unlock => 'Desbloquear';

  @override
  String get freeUpSpace => 'Libertar espaço';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'They can be deleted from the device to free up $formattedSize',
      one: 'It can be deleted from the device to free up $formattedSize',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber arquivos',
      one: '1 arquivo',
    );
    return '$_temp0 neste álbum teve um backup seguro';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber arquivos',
      one: '1 arquivo',
    );
    return '$_temp0 neste dispositivo teve um backup seguro';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'them',
      one: 'it',
    );
    return 'You can still access $_temp0 on Ente as long as you have an active subscription';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return 'Libertar $sizeInMBorGB';
  }

  @override
  String get thisEmailIsAlreadyInUse => 'Este email já está em uso';

  @override
  String get incorrectCode => 'Código incorrecto';

  @override
  String get authenticationFailedPleaseTryAgain =>
      'Falha na autenticação, por favor tente novamente';

  @override
  String get verificationFailedPleaseTryAgain =>
      'Falha na verificação, por favor tente novamente';

  @override
  String get authenticating => 'A Autenticar...';

  @override
  String get authenticationSuccessful => 'Autenticação bem sucedida!';

  @override
  String get incorrectRecoveryKey => 'Chave de recuperação incorreta';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect =>
      'A chave de recuperação inserida está incorreta';

  @override
  String get twofactorAuthenticationSuccessfullyReset =>
      'Autenticação de dois fatores redefinida com êxito';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered =>
      'Por favor, verifique se o código que você inseriu';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      'Por favor, contate o suporte se o problema persistir';

  @override
  String get twofactorAuthenticationHasBeenDisabled =>
      'A autenticação de dois fatores foi desativada';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect =>
      'Desculpe, o código inserido está incorreto';

  @override
  String get yourVerificationCodeHasExpired =>
      'O seu código de verificação expirou';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'Email alterado para $newEmail';
  }

  @override
  String get verifying => 'A verificar…';

  @override
  String get disablingTwofactorAuthentication =>
      'Desativar a autenticação de dois factores...';

  @override
  String get allMemoriesPreserved => 'Todas as memórias preservadas';

  @override
  String get loadingGallery => 'Carregando galeria...';

  @override
  String get syncing => 'Sincronizando...';

  @override
  String get encryptingBackup => 'Criptografando backup...';

  @override
  String get syncStopped => 'Sincronização interrompida';

  @override
  String syncProgress({required String completed, required String total}) {
    return '$completed/$total memórias preservadas';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return 'Preservar $count memórias...';
  }

  @override
  String get uploadingSingleMemory => 'Preservar 1 memória...';

  @override
  String get archiving => 'Arquivar...';

  @override
  String get unarchiving => 'Desarquivar...';

  @override
  String get successfullyArchived => 'Arquivado com sucesso';

  @override
  String get successfullyUnarchived => 'Desarquivado com sucesso';

  @override
  String get renameFile => 'Renomear arquivo';

  @override
  String get enterFileName => 'Inserir nome do arquivo';

  @override
  String get filesDeleted => 'Arquivos apagados';

  @override
  String get selectedFilesAreNotOnEnte =>
      'Os arquivos selecionados não estão no Ente';

  @override
  String get thisActionCannotBeUndone => 'Esta ação não pode ser desfeita';

  @override
  String get emptyTrash => 'Esvaziar lixo?';

  @override
  String get permDeleteWarning =>
      'Todos os itens no lixo serão permanentemente eliminados\n\n\nEsta ação não pode ser anulada';

  @override
  String get empty => 'Esvaziar';

  @override
  String get couldNotFreeUpSpace => 'Não foi possível libertar espaço';

  @override
  String get permanentlyDeleteFromDevice =>
      'Apagar permanentemente do dispositivo?';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      'Alguns dos ficheiros que está a tentar eliminar só estão disponíveis no seu dispositivo e não podem ser recuperados se forem eliminados';

  @override
  String get theyWillBeDeletedFromAllAlbums =>
      'Serão eliminados de todos os álbuns.';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'Alguns itens estão tanto no Ente como no seu dispositivo.';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      'Os itens selecionados serão eliminados de todos os álbuns e movidos para o lixo.';

  @override
  String get theseItemsWillBeDeletedFromYourDevice =>
      'Estes itens serão eliminados do seu dispositivo.';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      'Parece que algo correu mal. Por favor, tente novamente após algum tempo. Se o erro persistir, contacte a nossa equipa de apoio.';

  @override
  String get error => 'Erro';

  @override
  String get tempErrorContactSupportIfPersists =>
      'Parece que algo correu mal. Por favor, tente novamente mais tarde. Se o erro persistir, entre em contacto com a nossa equipa de suporte.';

  @override
  String get networkHostLookUpErr =>
      'Não foi possível estabelecer ligação ao Ente. Verifique as definições de rede e contacte o serviço de apoio se o erro persistir.';

  @override
  String get networkConnectionRefusedErr =>
      'Não foi possível conectar ao Ente, tente novamente após algum tempo. Se o erro persistir, entre em contato com o suporte.';

  @override
  String get cachedData => 'Dados em cache';

  @override
  String get clearCaches => 'Limpar cache';

  @override
  String get remoteImages => 'Imagens remotas';

  @override
  String get remoteVideos => 'Vídeos remotos';

  @override
  String get remoteThumbnails => 'Miniaturas remotas';

  @override
  String get pendingSync => 'Sincronização pendente';

  @override
  String get localGallery => 'Galeria local';

  @override
  String get todaysLogs => 'Logs de hoje';

  @override
  String get viewLogs => 'Ver logs';

  @override
  String get logsDialogBody =>
      'Isto enviará os registos para nos ajudar a resolver o problema. Tenha em atenção que os nomes dos ficheiros serão incluídos para ajudar a localizar problemas com ficheiros específicos.';

  @override
  String get preparingLogs => 'Preparando logs...';

  @override
  String get emailYourLogs => 'Enviar logs por e-mail';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'Por favor, envie os logs para \n$toEmail';
  }

  @override
  String get copyEmailAddress => 'Copiar endereço de email';

  @override
  String get exportLogs => 'Exportar logs';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return 'Por favor, envie-nos um e-mail para $toEmail';
  }

  @override
  String get dismiss => 'Rejeitar';

  @override
  String get didYouKnow => 'Você sabia?';

  @override
  String get loadingMessage => 'Carregar as suas fotos...';

  @override
  String get loadMessage1 =>
      'Pode partilhar a sua subscrição com a sua família';

  @override
  String get loadMessage2 =>
      'We have preserved over 200 million memories so far';

  @override
  String get loadMessage3 =>
      'Mantemos 3 cópias dos seus dados, uma em um abrigo subterrâneo';

  @override
  String get loadMessage4 => 'Todos os nossos aplicativos são de código aberto';

  @override
  String get loadMessage5 =>
      'Nosso código-fonte e criptografia foram auditadas externamente';

  @override
  String get loadMessage6 => 'Deixar o álbum partilhado?';

  @override
  String get loadMessage7 =>
      'Nossos aplicativos móveis são executados em segundo plano para criptografar e fazer backup de quaisquer novas fotos que você clique';

  @override
  String get loadMessage8 => 'web.ente.io tem um envio mais rápido';

  @override
  String get loadMessage9 =>
      'Nós usamos Xchacha20Poly1305 para criptografar seus dados com segurança';

  @override
  String get photoDescriptions => 'Descrições das fotos';

  @override
  String get fileTypesAndNames => 'Tipos de arquivo e nomes';

  @override
  String get location => 'Localização';

  @override
  String get moments => 'Momentos';

  @override
  String get searchFaceEmptySection =>
      'As pessoas serão mostradas aqui quando a indexação estiver concluída';

  @override
  String get searchDatesEmptySection => 'Pesquisar por data, mês ou ano';

  @override
  String get searchLocationEmptySection =>
      'Fotos de grupo que estão sendo tiradas em algum raio da foto';

  @override
  String get searchPeopleEmptySection =>
      'Convide pessoas e verá todas as fotos partilhadas por elas aqui';

  @override
  String get searchAlbumsEmptySection => 'Álbuns';

  @override
  String get searchFileTypesAndNamesEmptySection => 'Tipos de arquivo e nomes';

  @override
  String get searchCaptionEmptySection =>
      'Adicione descrições como \"#trip\" nas informações das fotos para encontrá-las aqui rapidamente';

  @override
  String get language => 'Idioma';

  @override
  String get selectLanguage => 'Selecionar Idioma';

  @override
  String get locationName => 'Nome da localização';

  @override
  String get addLocation => 'Adicionar localização';

  @override
  String get groupNearbyPhotos => 'Agrupar fotos próximas';

  @override
  String get kiloMeterUnit => 'km';

  @override
  String get addLocationButton => 'Adicionar';

  @override
  String get radius => 'Raio';

  @override
  String get locationTagFeatureDescription =>
      'Uma etiqueta de localização agrupa todas as fotos que foram tiradas num determinado raio de uma fotografia';

  @override
  String get galleryMemoryLimitInfo => 'Até 1000 memórias mostradas na galeria';

  @override
  String get save => 'Guardar';

  @override
  String get centerPoint => 'Ponto central';

  @override
  String get pickCenterPoint => 'Escolha o ponto central';

  @override
  String get useSelectedPhoto => 'Utilizar foto selecionada';

  @override
  String get resetToDefault => 'Redefinir para o padrão';

  @override
  String get edit => 'Editar';

  @override
  String get deleteLocation => 'Apagar localização';

  @override
  String get rotateLeft => 'Rodar para a esquerda';

  @override
  String get flip => 'Inverter';

  @override
  String get rotateRight => 'Rodar para a direita';

  @override
  String get saveCopy => 'Guardar cópia';

  @override
  String get light => 'Claro';

  @override
  String get color => 'Cor';

  @override
  String get yesDiscardChanges => 'Sim, rejeitar alterações';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade =>
      'Pretende eliminar as edições que efectuou?';

  @override
  String get saving => 'A gravar...';

  @override
  String get editsSaved => 'Edição guardada';

  @override
  String get oopsCouldNotSaveEdits =>
      'Oops, não foi possível guardar as edições';

  @override
  String get distanceInKMUnit => 'km';

  @override
  String get dayToday => 'Hoje';

  @override
  String get dayYesterday => 'Ontem';

  @override
  String get storage => 'Armazenamento';

  @override
  String get usedSpace => 'Espaço utilizado';

  @override
  String get storageBreakupFamily => 'Família';

  @override
  String get storageBreakupYou => 'Tu';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return '$usedAmount $usedStorageUnit de $totalAmount $totalStorageUnit usado';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return '$freeAmount $storageUnit grátis';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'Versão: $versionValue';
  }

  @override
  String get verifyIDLabel => 'Verificar';

  @override
  String get fileInfoAddDescHint => 'Acrescente uma descrição...';

  @override
  String get editLocationTagTitle => 'Editar localização';

  @override
  String get setLabel => 'Definir';

  @override
  String get setRadius => 'Definir raio';

  @override
  String get familyPlanPortalTitle => 'Família';

  @override
  String get familyPlanOverview =>
      'Adicione 5 membros da família ao seu plano existente sem pagar mais.\n\n\nCada membro tem o seu próprio espaço privado e não pode ver os ficheiros dos outros, a menos que sejam partilhados.\n\n\nOs planos familiares estão disponíveis para clientes que tenham uma subscrição paga do Ente.\n\n\nSubscreva agora para começar!';

  @override
  String get androidBiometricHint => 'Verificar identidade';

  @override
  String get androidBiometricNotRecognized =>
      'Não reconhecido. Tente novamente.';

  @override
  String get androidBiometricSuccess => 'Sucesso';

  @override
  String get androidCancelButton => 'Cancelar';

  @override
  String get androidSignInTitle => 'Autenticação necessária';

  @override
  String get androidBiometricRequiredTitle => 'Biometria necessária';

  @override
  String get androidDeviceCredentialsRequiredTitle =>
      'Credenciais do dispositivo são necessárias';

  @override
  String get androidDeviceCredentialsSetupDescription =>
      'Credenciais do dispositivo necessárias';

  @override
  String get goToSettings => 'Ir para as definições';

  @override
  String get androidGoToSettingsDescription =>
      'A autenticação biométrica não está configurada no seu dispositivo. Vá a “Definições > Segurança” para adicionar a autenticação biométrica.';

  @override
  String get iOSLockOut =>
      'A autenticação biométrica está desativada. Por favor, bloqueie e desbloqueie o ecrã para ativá-la.';

  @override
  String get iOSGoToSettingsDescription =>
      'A autenticação biométrica não está configurada no seu dispositivo. Active o Touch ID ou o Face ID no seu telemóvel.';

  @override
  String get iOSOkButton => 'OK';

  @override
  String get openstreetmapContributors => 'Contribuidores do OpenStreetMap';

  @override
  String get hostedAtOsmFrance => 'Hospedado na OSM France';

  @override
  String get map => 'Mapa';

  @override
  String get maps => 'Mapas';

  @override
  String get mapsPrivacyNotice =>
      'Approximate coordinates will be sent to privacy conscious third parties like OpenStreetMap to show the map and location.';

  @override
  String get enableMaps => 'Ativar mapas';

  @override
  String get quickLinks => 'Links rápidos';

  @override
  String get selectItemsToAdd => 'Selecionar itens para adicionar';

  @override
  String get addSelected => 'Adicionar selecionados';

  @override
  String get addFromDevice => 'Adicionar a partir do dispositivo';

  @override
  String get addPhotos => 'Adicionar fotos';

  @override
  String get noPhotosFoundHere => 'Nenhuma foto encontrada aqui';

  @override
  String get zoomOutToSeePhotos => 'Diminuir o zoom para ver fotos';

  @override
  String get noImagesWithLocation => 'Nenhuma imagem com localização';

  @override
  String get unpinAlbum => 'Desafixar álbum';

  @override
  String get pinAlbum => 'Fixar álbum';

  @override
  String get pin => 'Pin';

  @override
  String get pinPerson => 'Pin person';

  @override
  String get pinToTop => 'Pin to top';

  @override
  String get unpin => 'Unpin';

  @override
  String get unpinPerson => 'Unpin person';

  @override
  String get visibility => 'Visibility';

  @override
  String get hideFromMemories => 'Hide from memories';

  @override
  String get showInMemories => 'Show in memories';

  @override
  String get create => 'Criar';

  @override
  String get viewAll => 'Ver tudo';

  @override
  String get nothingSharedWithYouYet => 'Ainda nada partilhado consigo';

  @override
  String get noAlbumsSharedByYouYet => 'Ainda não há álbuns partilhados por si';

  @override
  String get sharedWithYou => 'Partilhado consigo';

  @override
  String get sharedByYou => 'Partilhado por si';

  @override
  String get inviteYourFriendsToEnte => 'Convide seus amigos para o Ente';

  @override
  String get failedToDownloadVideo => 'Falha ao fazer o download do vídeo';

  @override
  String get hiding => 'Ocultando...';

  @override
  String get unhiding => 'Reexibindo...';

  @override
  String get successfullyHid => 'Ocultado com sucesso';

  @override
  String get successfullyUnhid => 'Reexibido com sucesso';

  @override
  String get crashReporting => 'Relatório de falhas';

  @override
  String get resumableUploads => 'Uploads reenviados';

  @override
  String get addToHiddenAlbum => 'Adicionar a álbum oculto';

  @override
  String get moveToHiddenAlbum => 'Mover para álbum oculto';

  @override
  String get fileTypes => 'Tipos de arquivo';

  @override
  String get deleteConfirmDialogBody =>
      'Esta conta está ligada a outras aplicações Ente, se utilizar alguma. Os seus dados carregados, em todas as aplicações Ente, serão agendados para eliminação e a sua conta será permanentemente eliminada.';

  @override
  String get hearUsWhereTitle => 'Como é que soube do Ente? (opcional)';

  @override
  String get hearUsExplanation =>
      'Não monitorizamos as instalações de aplicações. Ajudaria se nos dissesse onde nos encontrou!';

  @override
  String get viewAddOnButton => 'Ver addons';

  @override
  String get addOns => 'addons';

  @override
  String get addOnPageSubtitle => 'Detalhes dos addons';

  @override
  String get yourMap => 'Seu mapa';

  @override
  String get modifyYourQueryOrTrySearchingFor =>
      'Modifique a sua consulta ou tente pesquisar por';

  @override
  String get blackFridaySale => 'Promoção Black Friday';

  @override
  String get upto50OffUntil4thDec => 'Até 50% de desconto, até 4 de dezembro.';

  @override
  String get photos => 'Fotos';

  @override
  String get videos => 'Vídeos';

  @override
  String get livePhotos => 'Fotos Em Tempo Real';

  @override
  String get searchHint1 => 'Pesquisa rápida no dispositivo';

  @override
  String get searchHint2 => 'Datas das fotos, descrições';

  @override
  String get searchHint3 => 'Álbuns, nomes de arquivos e tipos';

  @override
  String get searchHint4 => 'Local';

  @override
  String get searchHint5 => 'Em breve: Rostos e pesquisa mágica ✨';

  @override
  String get addYourPhotosNow => 'Adicione suas fotos agora';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count anos atrás',
      one: '$count ano atrás',
    );
    return '$_temp0';
  }

  @override
  String get faces => 'Rostos';

  @override
  String get people => 'Pessoas';

  @override
  String get contents => 'Conteúdos';

  @override
  String get addNew => 'Adicionar novo';

  @override
  String get contacts => 'Contactos';

  @override
  String get noInternetConnection => 'Sem ligação à internet';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'Por favor, verifique a sua ligação à Internet e tente novamente.';

  @override
  String get signOutFromOtherDevices => 'Terminar sessão noutros dispositivos';

  @override
  String get signOutOtherBody =>
      'Se pensa que alguém pode saber a sua palavra-passe, pode forçar todos os outros dispositivos que utilizam a sua conta a terminar a sessão.';

  @override
  String get signOutOtherDevices => 'Terminar a sessão noutros dispositivos';

  @override
  String get doNotSignOut => 'Não terminar a sessão';

  @override
  String get editLocation => 'Editar localização';

  @override
  String get selectALocation => 'Selecione uma localização';

  @override
  String get selectALocationFirst => 'Selecione uma localização primeiro';

  @override
  String get changeLocationOfSelectedItems =>
      'Alterar a localização dos itens selecionados?';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte =>
      'Edições para localização só serão vistas dentro do Ente';

  @override
  String get cleanUncategorized => 'Limpar sem categoria';

  @override
  String get cleanUncategorizedDescription =>
      'Remover todos os arquivos da Não Categorizados que estão presentes em outros álbuns';

  @override
  String get waitingForVerification => 'Aguardando verificação...';

  @override
  String get passkey => 'Chave de acesso';

  @override
  String get passkeyAuthTitle => 'Verificação da chave de acesso';

  @override
  String get loginWithTOTP => 'Iniciar sessão com TOTP';

  @override
  String get passKeyPendingVerification => 'A verificação ainda está pendente';

  @override
  String get loginSessionExpired => 'Sessão expirada';

  @override
  String get loginSessionExpiredDetails =>
      'A sua sessão expirou. Por favor, inicie sessão novamente.';

  @override
  String get verifyPasskey => 'Verificar chave de acesso';

  @override
  String get playOnTv => 'Reproduzir álbum na TV';

  @override
  String get pair => 'Emparelhar';

  @override
  String get deviceNotFound => 'Dispositivo não encontrado';

  @override
  String get castInstruction =>
      'Visite cast.ente.io no dispositivo que pretende emparelhar.\n\n\nIntroduza o código abaixo para reproduzir o álbum na sua TV.';

  @override
  String get deviceCodeHint => 'Introduza o código';

  @override
  String get joinDiscord => 'Juntar-se ao Discord';

  @override
  String get locations => 'Localizações';

  @override
  String get addAName => 'Adiciona um nome';

  @override
  String get findThemQuickly => 'Ache-os rapidamente';

  @override
  String get findPeopleByName => 'Encontrar pessoas rapidamente pelo nome';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add viewers',
      one: 'Add viewer',
      zero: 'Add viewer',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add collaborators',
      one: 'Add collaborator',
      zero: 'Add collaborator',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      'Pressione e segure um e-mail para verificar a criptografia de ponta a ponta.';

  @override
  String get developerSettingsWarning =>
      'Tem a certeza de que pretende modificar as definições de programador?';

  @override
  String get developerSettings => 'Definições do programador';

  @override
  String get serverEndpoint => 'Endpoint do servidor';

  @override
  String get invalidEndpoint => 'Endpoint inválido';

  @override
  String get invalidEndpointMessage =>
      'Desculpe, o endpoint que introduziu é inválido. Introduza um ponto final válido e tente novamente.';

  @override
  String get endpointUpdatedMessage => 'Endpoint atualizado com sucesso';

  @override
  String customEndpoint({required Object endpoint}) {
    return 'Conectado a $endpoint';
  }

  @override
  String get createCollaborativeLink => 'Criar link colaborativo';

  @override
  String get search => 'Pesquisar';

  @override
  String get enterPersonName => 'Inserir nome da pessoa';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'This email is already linked to $name.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return 'View $name to unlink';
  }

  @override
  String get enterName => 'Inserir nome';

  @override
  String get savePerson => 'Guardar pessoa';

  @override
  String get editPerson => 'Editar pessoa';

  @override
  String get mergedPhotos => 'Fotos combinadas';

  @override
  String get orMergeWithExistingPerson => 'Ou combinar com já existente';

  @override
  String get enterDateOfBirth => 'Aniversário (opcional)';

  @override
  String get birthday => 'Aniversário';

  @override
  String get removePersonLabel => 'Remover etiqueta da pessoa';

  @override
  String get autoPairDesc =>
      'O pareamento automático funciona apenas com dispositivos que suportam o Chromecast.';

  @override
  String get manualPairDesc =>
      'Emparelhar com PIN funciona com qualquer ecrã onde pretenda ver o seu álbum.';

  @override
  String get connectToDevice => 'Ligar ao dispositivo';

  @override
  String get autoCastDialogBody =>
      'Verá os dispositivos Cast disponíveis aqui.';

  @override
  String get autoCastiOSPermission =>
      'Certifique-se de que as permissões de Rede local estão activadas para a aplicação Ente Photos, nas Definições.';

  @override
  String get noDeviceFound => 'Nenhum dispositivo encontrado';

  @override
  String get stopCastingTitle => 'Parar transmissão';

  @override
  String get stopCastingBody => 'Queres parar de fazer transmissão?';

  @override
  String get castIPMismatchTitle => 'Falha ao transmitir álbum';

  @override
  String get castIPMismatchBody =>
      'Certifique-se de estar na mesma rede que a TV.';

  @override
  String get pairingComplete => 'Emparelhamento concluído';

  @override
  String get savingEdits => 'Gravando edições...';

  @override
  String get autoPair => 'Emparelhamento automático';

  @override
  String get pairWithPin => 'Emparelhar com PIN';

  @override
  String get faceRecognition => 'Reconhecimento facial';

  @override
  String get foundFaces => 'Rostos encontrados';

  @override
  String get clusteringProgress => 'Progresso de agrupamento';

  @override
  String get trim => 'Cortar';

  @override
  String get crop => 'Recortar';

  @override
  String get rotate => 'Rodar';

  @override
  String get left => 'Esquerda';

  @override
  String get right => 'Direita';

  @override
  String get whatsNew => 'O que há de novo';

  @override
  String get reviewSuggestions => 'Revisar sugestões';

  @override
  String get review => 'Rever';

  @override
  String get useAsCover => 'Usar como capa';

  @override
  String notPersonLabel({required String name}) {
    return 'Não é $name?';
  }

  @override
  String get enable => 'Ativar';

  @override
  String get enabled => 'Ativado';

  @override
  String get moreDetails => 'Mais detalhes';

  @override
  String get enableMLIndexingDesc =>
      'O Ente suporta a aprendizagem automática no dispositivo para reconhecimento facial, pesquisa mágica e outras funcionalidades de pesquisa avançadas';

  @override
  String get magicSearchHint =>
      'A pesquisa mágica permite pesquisar fotos por seu conteúdo, por exemplo, \'flor\', \'carro vermelho\', \'documentos de identidade\'';

  @override
  String get panorama => 'Panorama';

  @override
  String get reenterPassword => 'Insira novamente a palavra-passe';

  @override
  String get reenterPin => 'Inserir PIN novamente';

  @override
  String get deviceLock => 'Bloqueio do dispositivo';

  @override
  String get pinLock => 'Bloqueio por PIN';

  @override
  String get next => 'Seguinte';

  @override
  String get setNewPassword => 'Definir nova palavra-passe';

  @override
  String get enterPin => 'Introduzir PIN';

  @override
  String get setNewPin => 'Definir novo PIN';

  @override
  String get appLock => 'Bloqueio de app';

  @override
  String get noSystemLockFound => 'Nenhum bloqueio de sistema encontrado';

  @override
  String get tapToUnlock => 'Toque para desbloquear';

  @override
  String get tooManyIncorrectAttempts => 'Muitas tentativas incorretas';

  @override
  String get videoInfo => 'Informação de Vídeo';

  @override
  String get autoLock => 'Bloqueio automático';

  @override
  String get immediately => 'Imediatamente';

  @override
  String get autoLockFeatureDescription =>
      'Tempo após o qual a aplicação bloqueia depois de ser colocada em segundo plano';

  @override
  String get hideContent => 'Ocultar conteúdo';

  @override
  String get hideContentDescriptionAndroid =>
      'Oculta o conteúdo da aplicação no alternador de aplicações e desactiva as capturas de ecrã';

  @override
  String get hideContentDescriptionIos =>
      'Oculta o conteúdo da aplicação no alternador de aplicações';

  @override
  String get passwordStrengthInfo =>
      'A força da palavra-passe é calculada tendo em conta o comprimento da palavra-passe, os caracteres utilizados e se a palavra-passe aparece ou não nas 10.000 palavras-passe mais utilizadas';

  @override
  String get noQuickLinksSelected => 'Nenhum link rápido selecionado';

  @override
  String get pleaseSelectQuickLinksToRemove =>
      'Selecione links rápidos para remover';

  @override
  String get removePublicLinks => 'Remover link público';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      'Isto removerá links públicos de todos os links rápidos selecionados.';

  @override
  String get guestView => 'Visão de convidado';

  @override
  String get guestViewEnablePreSteps =>
      'Para ativar a vista de convidado, configure o código de acesso do dispositivo ou o bloqueio do ecrã nas definições do sistema.';

  @override
  String get nameTheAlbum => 'Nomear o álbum';

  @override
  String get collectPhotosDescription =>
      'Crie um link onde seus amigos podem enviar fotos na qualidade original.';

  @override
  String get collect => 'Recolher';

  @override
  String get appLockDescriptions =>
      'Escolha entre o ecrã de bloqueio predefinido do seu dispositivo e um ecrã de bloqueio personalizado com um PIN ou uma palavra-passe.';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'Para ativar o bloqueio de aplicações, configure o código de acesso do dispositivo ou o bloqueio de ecrã nas definições do sistema.';

  @override
  String get authToViewPasskey =>
      'Autentique-se para ver a sua chave de acesso';

  @override
  String get loopVideoOn => 'Repetir vídeo ligado';

  @override
  String get loopVideoOff => 'Repetir vídeo desligado';

  @override
  String get localSyncErrorMessage =>
      'Parece que algo correu mal, uma vez que a sincronização de fotografias locais está a demorar mais tempo do que o esperado. Contacte a nossa equipa de apoio';

  @override
  String get showPerson => 'Mostrar pessoa';

  @override
  String get sort => 'Ordenar';

  @override
  String get mostRecent => 'Mais recente';

  @override
  String get mostRelevant => 'Mais relevante';

  @override
  String get loadingYourPhotos => 'Carregar as suas fotos...';

  @override
  String processingImport({required Object folderName}) {
    return 'Processando $folderName...';
  }

  @override
  String get personName => 'Nome da pessoa';

  @override
  String get addNewPerson => 'Adicionar nova pessoa';

  @override
  String get addNameOrMerge => 'Adicionar nome ou juntar';

  @override
  String get mergeWithExisting => 'Juntar com o existente';

  @override
  String get newPerson => 'Nova pessoa';

  @override
  String get addName => 'Adicionar pessoa';

  @override
  String get add => 'Adicionar';

  @override
  String extraPhotosFoundFor({required String text}) {
    return 'Fotos extras encontradas para $text';
  }

  @override
  String get extraPhotosFound => 'Fotos adicionais encontradas';

  @override
  String get configuration => 'Configuração';

  @override
  String get localIndexing => 'Indexação local';

  @override
  String get processed => 'Processed';

  @override
  String get resetPerson => 'Remover';

  @override
  String get areYouSureYouWantToResetThisPerson =>
      'Tens a certeza de que queres repor esta pessoa?';

  @override
  String get allPersonGroupingWillReset =>
      'Todos os agrupamentos para esta pessoa serão reiniciados e perderá todas as sugestões feitas para esta pessoa';

  @override
  String get yesResetPerson => 'Sim, repor pessoa';

  @override
  String get onlyThem => 'Apenas eles';

  @override
  String get checkingModels => 'A verificar modelos...';

  @override
  String get enableMachineLearningBanner =>
      'Habilitar aprendizagem automática para pesquisa mágica e reconhecimento de rosto';

  @override
  String get searchDiscoverEmptySection =>
      'Images will be shown here once processing and syncing is complete';

  @override
  String get searchPersonsEmptySection =>
      'People will be shown here once processing and syncing is complete';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count viewers',
      one: 'Added 1 viewer',
      zero: 'Added 0 viewers',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Adicionado $count colaboradores',
      one: 'Adicionado 1 colaborador',
      zero: 'Adicionado 0 colaboradores',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured => 'A conta já está ajustada.';

  @override
  String get sessionIdMismatch => 'Incompatibilidade de ID de sessão';

  @override
  String get failedToFetchActiveSessions =>
      'Falha ao obter sessões em atividade';

  @override
  String get failedToRefreshStripeSubscription =>
      'Falha ao atualizar subscrição';

  @override
  String get failedToPlayVideo => 'Falha ao reproduzir multimédia';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return 'Envio ignorado devido à $ignoreReason';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'Tipo de galeria $galleryType não é permitido para renomear';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'Toque para enviar, atualmente o envio é ignorado devido a $ignoreReason';
  }

  @override
  String get tapToUpload => 'Toque para enviar';

  @override
  String get info => 'Info';

  @override
  String get addFiles => 'Adicionar arquivos';

  @override
  String get castAlbum => 'Transferir álbum';

  @override
  String get imageNotAnalyzed => 'Imagem não analisada';

  @override
  String get noFacesFound => 'Nenhum rosto encontrado';

  @override
  String get fileNotUploadedYet => 'Arquivo ainda não enviado';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return 'Sem sugestões para $personName';
  }

  @override
  String get month => 'mês';

  @override
  String get yearShort => 'ano';

  @override
  String get currentlyRunning => 'Atualmente executando';

  @override
  String get ignored => 'ignorado';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count fotos',
      one: '1 foto',
      zero: '0 fotos',
    );
    return '$_temp0';
  }

  @override
  String get file => 'Arquivo';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'Incompatibilidade de comprimento de seções: $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'Selecionar aplicativo de e-mail';

  @override
  String get selectAllShort => 'Tudo';

  @override
  String get selectCoverPhoto => 'Selecionar foto da capa';

  @override
  String get newLocation => 'Nova localização';

  @override
  String get faceNotClusteredYet =>
      'Rosto não agrupado ainda, volte aqui mais tarde';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'O link que você está tentando acessar já expirou.';

  @override
  String get openFile => 'Abrir arquivo';

  @override
  String get backupFile => 'Copiar arquivo com segurança';

  @override
  String get openAlbumInBrowser => 'Abrir álbum no navegador';

  @override
  String get openAlbumInBrowserTitle =>
      'Use o aplicativo da web para adicionar fotos a este álbum';

  @override
  String get allow => 'Permitir';

  @override
  String get allowAppToOpenSharedAlbumLinks =>
      'Permitir aplicativo abrir links de álbum compartilhado';

  @override
  String get seePublicAlbumLinksInApp =>
      'Ver links de álbum compartilhado no aplicativo';

  @override
  String get emergencyContacts => 'Contatos de emergência';

  @override
  String get acceptTrustInvite => 'Aceitar convite';

  @override
  String get declineTrustInvite => 'Recusar convite';

  @override
  String get removeYourselfAsTrustedContact =>
      'Remover si mesmo dos contatos confiáveis';

  @override
  String get legacy => 'Legado';

  @override
  String get legacyPageDesc =>
      'O legado permite que contatos confiáveis acessem sua conta em sua ausência.';

  @override
  String get legacyPageDesc2 =>
      'Contatos confiáveis podem iniciar recuperação de conta. Se não cancelado dentro de 30 dias, redefina sua senha e acesse sua conta.';

  @override
  String get legacyAccounts => 'Contas legadas';

  @override
  String get trustedContacts => 'Contatos confiáveis';

  @override
  String get addTrustedContact => 'Adicionar contato confiável';

  @override
  String get removeInvite => 'Remover convite';

  @override
  String get recoveryWarning =>
      'Um contato confiável está tentando acessar sua conta';

  @override
  String get rejectRecovery => 'Rejeitar recuperação';

  @override
  String get recoveryInitiated => 'A recuperação iniciou';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return 'Você poderá acessar a conta após $days dias.  Uma notificação será enviada para $email.';
  }

  @override
  String get cancelAccountRecovery => 'Cancelar recuperação';

  @override
  String get recoveryAccount => 'Recuperar conta';

  @override
  String get cancelAccountRecoveryBody =>
      'Deseja mesmo cancelar a recuperação de conta?';

  @override
  String get startAccountRecoveryTitle => 'Iniciar recuperação';

  @override
  String get whyAddTrustContact =>
      'Um contato confiável pode ajudá-lo em recuperar seus dados.';

  @override
  String recoveryReady({required String email}) {
    return 'Você pode recuperar a conta com e-mail $email por definir uma nova senha.';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email está tentando recuperar sua conta.';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return 'Você foi convidado para ser um contato legado por $email.';
  }

  @override
  String get warning => 'Aviso';

  @override
  String get proceed => 'Continuar';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return 'Você está prestes a adicionar $email como contato confiável. Eles poderão recuperar sua conta se você estiver ausente por $numOfDays dias.';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email convidou você para ser um contato confiável';
  }

  @override
  String get authToManageLegacy =>
      'Autentique-se para gerenciar seus contatos confiáveis';

  @override
  String get hideSharedItemsFromHomeGallery =>
      'Ocultar itens compartilhados da galeria inicial';

  @override
  String get swipeToSelect => 'Swipe to select';

  @override
  String get gallery => 'Galeria';

  @override
  String get joinAlbum => 'Unir-se ao álbum';

  @override
  String get joinAlbumSubtext => 'para visualizar e adicionar suas fotos';

  @override
  String get joinAlbumSubtextViewer =>
      'para adicionar isso aos álbuns compartilhados';

  @override
  String get join => 'Unir-se';

  @override
  String get linkEmail => 'Vincular e-mail';

  @override
  String get link => 'Vincular';

  @override
  String get noEnteAccountExclamation => 'Nenhuma conta Ente!';

  @override
  String get orPickFromYourContacts => 'ou escolher dos seus contatos';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return '$email não possui uma conta Ente.';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (Eu)';
  }

  @override
  String get reassignMe => 'Reatribuir \"Eu\"';

  @override
  String get me => 'Eu';

  @override
  String get linkEmailToContactBannerCaption => 'para compartilhar rápido';

  @override
  String get selectPersonToLink => 'Selecione a pessoa para vincular';

  @override
  String linkPersonToEmail({required String email}) {
    return 'Vincular pessoa a $email';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return 'Isso vinculará $personName a $email';
  }

  @override
  String get selectYourFace => 'Selecione seu rosto';

  @override
  String get reassigningLoading => 'Reatribuindo...';

  @override
  String reassignedToName({required String name}) {
    return 'Atribuído a $name';
  }

  @override
  String get saveChangesBeforeLeavingQuestion =>
      'Salvar mudanças antes de sair?';

  @override
  String get dontSave => 'Não salvar';

  @override
  String get thisIsMeExclamation => 'Este é você!';

  @override
  String get linkPerson => 'Vincular pessoa';

  @override
  String get linkPersonCaption => 'para melhor experiência de compartilhamento';

  @override
  String get videoStreaming => 'Transmissão de vídeo';

  @override
  String get processingVideos => 'Processando vídeos';

  @override
  String get streamDetails => 'Detalhes da transmissão';

  @override
  String get processing => 'Processando';

  @override
  String get queued => 'Na fila';

  @override
  String get ineligible => 'Inelegível';

  @override
  String get failed => 'Falhou';

  @override
  String get playStream => 'Reproduzir transmissão';

  @override
  String get playOriginal => 'Reproduzir original';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'Unir-se ao álbum fará que seu e-mail seja visível a todos do álbum.';

  @override
  String get pleaseWaitThisWillTakeAWhile =>
      'Aguarde um pouco, isso talvez leve um tempo.';

  @override
  String get editTime => 'Editar tempo';

  @override
  String get selectTime => 'Selecionar tempo';

  @override
  String get selectDate => 'Selecionar data';

  @override
  String get previous => 'Anterior';

  @override
  String get selectOneDateAndTimeForAll =>
      'Selecione uma data e hora para todos';

  @override
  String get selectStartOfRange => 'Selecionar início de intervalo';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      'Isso fará que a data e hora de todas as fotos selecionadas fiquem iguais.';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'Este é o primeiro do grupo. As outras fotos selecionadas serão automaticamente alteradas para esta nova data';

  @override
  String get newRange => 'Novo intervalo';

  @override
  String get selectOneDateAndTime => 'Selecionar data e hora';

  @override
  String get moveSelectedPhotosToOneDate =>
      'Mover fotos selecionadas para uma data';

  @override
  String get shiftDatesAndTime => 'Alterar as datas e horas';

  @override
  String get photosKeepRelativeTimeDifference =>
      'As fotos mantêm a diferença de tempo relativo';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count fotos',
      one: '1 foto',
      zero: 'Sem fotos',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'Ícone do aplicativo';

  @override
  String get notThisPerson => 'Não é esta pessoa?';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      'Os itens selecionados serão removidos desta pessoa, entretanto não serão excluídos da sua biblioteca.';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat com o passar dos anos';
  }

  @override
  String get thisWeekThroughTheYears => 'Esta semana com o passar dos anos';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Esta semana, $count anos atrás',
      one: 'Esta semana, $count ano atrás',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'Você e $name';
  }

  @override
  String admiringThem({required Object name}) {
    return 'Admirando $name';
  }

  @override
  String embracingThem({required Object name}) {
    return 'Abraçando $name';
  }

  @override
  String partyWithThem({required Object name}) {
    return 'Festejando com $name';
  }

  @override
  String hikingWithThem({required Object name}) {
    return 'Caminhando com $name';
  }

  @override
  String feastingWithThem({required Object name}) {
    return 'Tendo banquete com $name';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return 'Tirando selfies com $name';
  }

  @override
  String posingWithThem({required Object name}) {
    return 'Fazendo pose com $name';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return 'Vistas bonitas com $name';
  }

  @override
  String sportsWithThem({required Object name}) {
    return 'Jogando esportes com $name';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return 'Viajando de carro com $name';
  }

  @override
  String get spotlightOnYourself => 'Destacar si mesmo';

  @override
  String spotlightOnThem({required Object name}) {
    return 'Destacar $name';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$name está com $age!';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name terá $age em breve';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return 'Últimos momentos com $name';
  }

  @override
  String tripToLocation({required Object location}) {
    return 'Viajem à $location';
  }

  @override
  String tripInYear({required Object year}) {
    return 'Viajem em $year';
  }

  @override
  String get lastYearsTrip => 'Viajem do ano passado';

  @override
  String get sunrise => 'No horizonte';

  @override
  String get mountains => 'Sob as montanhas';

  @override
  String get greenery => 'A vegetação verde';

  @override
  String get beach => 'Areia e o mar';

  @override
  String get city => 'Na cidade';

  @override
  String get moon => 'Na luz do luar';

  @override
  String get onTheRoad => 'Na estrada de novo';

  @override
  String get food => 'Prazer em culinária';

  @override
  String get pets => 'Companhia de pelos';

  @override
  String get curatedMemories => 'Curated memories';

  @override
  String get widgets => 'Widgets';

  @override
  String get memories => 'Memories';

  @override
  String get peopleWidgetDesc =>
      'Select the people you wish to see on your homescreen.';

  @override
  String get albumsWidgetDesc =>
      'Select the albums you wish to see on your homescreen.';

  @override
  String get memoriesWidgetDesc =>
      'Select the kind of memories you wish to see on your homescreen.';

  @override
  String get smartMemories => 'Smart memories';

  @override
  String get pastYearsMemories => 'Past years\' memories';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return 'Also delete the photos (and videos) present in these $count albums from <bold>all</bold> other albums they are part of?';
  }

  @override
  String get addParticipants => 'Add participants';

  @override
  String selectedAlbums({required Object count}) {
    return '$count selected';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'Action not supported on Favourites album';

  @override
  String get onThisDayMemories => 'On this day memories';

  @override
  String get onThisDay => 'On this day';

  @override
  String get lookBackOnYourMemories => 'Look back on your memories 🌄';

  @override
  String get newPhotosEmoji => ' new 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'Sorry, we had to pause your backups';

  @override
  String get clickToInstallOurBestVersionYet =>
      'Click to install our best version yet';

  @override
  String get onThisDayNotificationExplanation =>
      'Receive reminders about memories from this day in previous years.';

  @override
  String get addMemoriesWidgetPrompt =>
      'Add a memories widget to your homescreen and come back here to customize.';

  @override
  String get addAlbumWidgetPrompt =>
      'Add an album widget to your homescreen and come back here to customize.';

  @override
  String get addPeopleWidgetPrompt =>
      'Add a people widget to your homescreen and come back here to customize.';

  @override
  String get birthdayNotifications => 'Birthday notifications';

  @override
  String get receiveRemindersOnBirthdays =>
      'Receive reminders when it\'s someone\'s birthday. Tapping on the notification will take you to photos of the birthday person.';

  @override
  String get happyBirthday => 'Happy birthday! 🥳';

  @override
  String get birthdays => 'Birthdays';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return 'Wish \$$name a happy birthday! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      'Are you sure you want to remove this face from this person?';

  @override
  String get otherDetectedFaces => 'Other detected faces';

  @override
  String get areThey => 'Are they ';

  @override
  String get questionmark => '?';

  @override
  String get saveAsAnotherPerson => 'Save as another person';

  @override
  String get showLessFaces => 'Show less faces';

  @override
  String get showMoreFaces => 'Show more faces';

  @override
  String get ignore => 'Ignore';

  @override
  String get merge => 'Merge';

  @override
  String get reset => 'Reset';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      'Are you sure you want to ignore this person?';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      'Are you sure you want to ignore these persons?';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'The person groups will not be displayed in the people section anymore. Photos will remain untouched.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'The person will not be displayed in the people section anymore. Photos will remain untouched.';

  @override
  String get areYouSureYouWantToMergeThem =>
      'Are you sure you want to merge them?';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'All unnamed groups will be merged into the selected person. This can still be undone from the suggestions history overview of the person.';

  @override
  String get yesIgnore => 'Yes, ignore';

  @override
  String get same => 'Same';

  @override
  String get different => 'Different';

  @override
  String get sameperson => 'Same person?';

  @override
  String get indexingPausedStatusDescription =>
      'Indexing is paused. It will automatically resume when the device is ready. The device is considered ready when its battery level, battery health, and thermal status are within a healthy range.';

  @override
  String get thisWeek => 'This week';

  @override
  String get lastWeek => 'Last week';

  @override
  String get thisMonth => 'This month';

  @override
  String get thisYear => 'This year';

  @override
  String get groupBy => 'Group by';

  @override
  String get faceThumbnailGenerationFailed =>
      'Unable to generate face thumbnails';

  @override
  String get fileAnalysisFailed => 'Unable to analyze file';

  @override
  String get editAutoAddPeople => 'Edit auto-add people';

  @override
  String get autoAddPeople => 'Auto-add people';

  @override
  String get autoAddToAlbum => 'Auto-add to album';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      'Should the files related to the person that were previously selected in smart albums be removed?';

  @override
  String get addingPhotos => 'Adding photos';

  @override
  String get gettingReady => 'Getting ready';

  @override
  String get addSomePhotosDesc1 => 'Add some photos or pick ';

  @override
  String get addSomePhotosDesc2 => 'familiar faces';

  @override
  String get addSomePhotosDesc3 => '\nto begin with';

  @override
  String get ignorePerson => 'Ignore person';

  @override
  String get mixedGrouping => 'Mixed grouping?';

  @override
  String get analysis => 'Analysis';

  @override
  String get doesGroupContainMultiplePeople =>
      'Does this grouping contain multiple people?';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'We will automatically analyze the grouping to determine if there are multiple people present, and separate them out again. This may take a few seconds.';

  @override
  String get layout => 'Layout';

  @override
  String get day => 'Day';

  @override
  String get undo => 'Undo';

  @override
  String get redo => 'Redo';

  @override
  String get filter => 'Filter';

  @override
  String get adjust => 'Adjust';

  @override
  String get draw => 'Draw';

  @override
  String get sticker => 'Sticker';

  @override
  String get brushColor => 'Brush Color';

  @override
  String get font => 'Font';

  @override
  String get background => 'Background';

  @override
  String get align => 'Align';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added successfully to $count albums',
      one: 'Added successfully to 1 album',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => 'Videos processed';

  @override
  String get totalVideos => 'Total videos';

  @override
  String get skippedVideos => 'Skipped videos';

  @override
  String get videoStreamingDescriptionLine1 =>
      'Play videos instantly on any device.';

  @override
  String get videoStreamingDescriptionLine2 =>
      'Enable to process video streams on this device.';

  @override
  String get videoStreamingNote =>
      'Only videos from last 60 days and under 1 minute are processed on this device. For older/longer videos, enable streaming in the desktop app.';

  @override
  String get createStream => 'Create stream';

  @override
  String get recreateStream => 'Recreate stream';

  @override
  String get addedToStreamCreationQueue => 'Added to stream creation queue';

  @override
  String get addedToStreamRecreationQueue => 'Added to stream recreation queue';

  @override
  String get videoPreviewAlreadyExists => 'Video preview already exists';

  @override
  String get videoAlreadyInQueue => 'Video file already present in the queue';

  @override
  String get videoExportFailed => 'Video creation failed. Please try again.';

  @override
  String videoExportSuccess({required String path}) {
    return 'Video successfully created at $path';
  }

  @override
  String get addedToQueue => 'Added to queue';

  @override
  String get creatingStream => 'Creating stream';

  @override
  String get similarImages => 'Similar images';

  @override
  String get findSimilarImages => 'Find similar images';

  @override
  String get noSimilarImagesFound => 'No similar images found';

  @override
  String get yourPhotosLookUnique => 'Your photos look unique';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count groups found',
      one: '$count group found',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages => 'Review and remove similar images';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return 'Delete $count photos ($size)';
  }

  @override
  String get selectionOptions => 'Selection options';

  @override
  String selectExactWithCount({required int count}) {
    return 'Exactly similar ($count)';
  }

  @override
  String get selectExact => 'Select exact';

  @override
  String selectSimilarWithCount({required int count}) {
    return 'Mostly similar ($count)';
  }

  @override
  String get selectSimilar => 'Select similar';

  @override
  String selectAllWithCount({required int count}) {
    return 'All similarities ($count)';
  }

  @override
  String get selectSimilarImagesTitle => 'Select similar images';

  @override
  String get chooseSimilarImagesToSelect =>
      'Select images based on their visual similarity';

  @override
  String get clearSelection => 'Clear selection';

  @override
  String similarImagesCount({required int count}) {
    return '$count similar images';
  }

  @override
  String deleteWithCount({required int count}) {
    return 'Delete ($count)';
  }

  @override
  String get deleteFiles => 'Delete files';

  @override
  String get areYouSureDeleteFiles =>
      'Are you sure you want to delete these files?';

  @override
  String get greatJob => 'Great job!';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return 'You freed up $size of space';
  }

  @override
  String get size => 'Size';

  @override
  String get similarity => 'Similarity';

  @override
  String get analyzingPhotosLocally => 'Analyzing your photos locally...';

  @override
  String get lookingForVisualSimilarities =>
      'Looking for visual similarities...';

  @override
  String get comparingImageDetails => 'Comparing image details...';

  @override
  String get findingSimilarImages => 'Finding similar images...';

  @override
  String get almostDone => 'Almost done...';

  @override
  String get processingLocally => 'Processing locally';

  @override
  String get useMLToFindSimilarImages =>
      'Review and remove images that look similar to each other.';

  @override
  String get all => 'All';

  @override
  String get similar => 'Similar';

  @override
  String get identical => 'Identical';

  @override
  String get nothingHereTryAnotherFilter =>
      'Nothing here, try another filter! 👀';

  @override
  String get related => 'Related';

  @override
  String get hoorayyyy => 'Hoorayyyy!';

  @override
  String get nothingToTidyUpHere => 'Nothing to tidy up here';

  @override
  String get deletingDash => 'Deleting - ';

  @override
  String get cLTitle1 => 'Jump to date';

  @override
  String get cLDesc1 =>
      'See surrounding photos for any photo by selecting the jump to date option in the file\'s info pane.';

  @override
  String get cLTitle2 => 'Faster video editor';

  @override
  String get cLDesc2 =>
      'Video editor was revamped to both drastically improve its speed when editing larger videos, and also improve the UX.';

  @override
  String get cLTitle3 => 'New memories';

  @override
  String get cLDesc3 =>
      '\"Playful kids\", \"Winter adventures\", \"Neon nights\", and more.';

  @override
  String get cLTitle4 => 'Landscape gallery and more';

  @override
  String get cLDesc4 =>
      'Support for landscape layout in the app\'s main gallery. Show persons without any associated photos instead of filtering them out. Improve video aspect detection when shared from external apps.';

  @override
  String get closeBy => 'Close';

  @override
  String get peopleAutoAddDesc =>
      'Automatically add photos of the selected people to this album';

  @override
  String get festivities => 'Festive cheer';

  @override
  String get snowAdventures => 'Winter adventures';

  @override
  String get waterfalls => 'Chasing waterfalls';

  @override
  String get wildlife => 'Into the wild';

  @override
  String get flowers => 'Blooming beauties';

  @override
  String get nightLights => 'Neon nights';

  @override
  String get architecture => 'Design icons';

  @override
  String get autumnColors => 'Autumn splendor';

  @override
  String get desertDreams => 'Desert dreams';

  @override
  String get stargazing => 'Under the stars';

  @override
  String get lakeside => 'Lakeside calm';

  @override
  String get rainyDays => 'Rainy day feels';

  @override
  String get sportsAction => 'Game on';

  @override
  String get streetArt => 'Street art stories';

  @override
  String get familyMoments => 'Family time';

  @override
  String get fireworks => 'Firework finale';

  @override
  String get historicSites => 'Echoes of history';

  @override
  String get tropicalParadise => 'Tropical escapes';

  @override
  String get forestTrails => 'Forest strolls';

  @override
  String get citySunsets => 'City sunset glow';

  @override
  String get colorfulMarkets => 'Vibrant markets';

  @override
  String get cozyCafes => 'Cozy cafe corners';

  @override
  String get vintageVibes => 'Vintage vibes';

  @override
  String get aerialViews => 'Aerial perspectives';

  @override
  String get artisticPortraits => 'Artful portraits';

  @override
  String get streetFood => 'Street food bites';

  @override
  String get riverCruises => 'River cruise views';

  @override
  String get facesTimelineBannerTitle => 'Memory Lane';

  @override
  String facesTimelineBannerSubtitle({required String name}) {
    return 'See $name\'s photos across the years';
  }

  @override
  String get facesTimelineAppBarTitle => 'Memory lane';

  @override
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count years old',
      one: '$count year old',
    );
    return '$name was $_temp0';
  }

  @override
  String facesTimelineCaptionYearsAgo({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '# years ago',
      one: '# year ago',
    );
    return '$_temp0';
  }

  @override
  String get facesTimelineShareComingSoon => 'Video sharing coming soon';

  @override
  String get facesTimelinePlaybackPrevious => 'Previous';

  @override
  String get facesTimelinePlaybackNext => 'Next';

  @override
  String get facesTimelinePlaybackPlay => 'Play';

  @override
  String get facesTimelinePlaybackPause => 'Pause';

  @override
  String get facesTimelineUnavailable => 'Faces timeline is preparing...';

  @override
  String get playfulKids => 'Playful kids';

  @override
  String get coastalCliffs => 'Cliffs by the sea';

  @override
  String get ritualsTitle => 'Rituals';

  @override
  String get ritualAddTooltip => 'Add ritual';

  @override
  String get ritualActivityHeading => 'Activity';

  @override
  String get ritualDefaultHeatmapTitle => 'Take a photo every day';

  @override
  String get ritualUntitled => 'Untitled ritual';

  @override
  String get ritualShareUnavailable =>
      'Unable to share right now. Please try again.';

  @override
  String get ritualNotificationMessage => 'Take a photo now';

  @override
  String get ritualCameraNotFound => 'No camera found on this device.';

  @override
  String get ritualCameraStartError =>
      'Unable to start camera. Please check permissions.';

  @override
  String get ritualCaptureError => 'Unable to capture photo. Please try again.';

  @override
  String ritualPhotoLimit({required int maxPhotos}) {
    String _temp0 = intl.Intl.pluralLogic(
      maxPhotos,
      locale: localeName,
      other: '# photos.',
      one: '# photo.',
    );
    return 'You can add up to $_temp0';
  }

  @override
  String get ritualCaptureAtLeastOne => 'Capture at least one photo first.';

  @override
  String get ritualAlbumMissing =>
      'Ritual album missing. Edit the ritual to set an album.';

  @override
  String get ritualAddedToAlbum => 'Added to album';

  @override
  String ritualAddedToAlbumWithName({required String albumName}) {
    return 'Added to $albumName';
  }

  @override
  String ritualAddToAlbumFailure({required String error}) {
    return 'Couldn\'t add photos to the album: $error';
  }

  @override
  String get ritualBackToList => 'Back to rituals';

  @override
  String get ritualNoPhotosYet => 'No photos yet';

  @override
  String get ritualSetAlbumToLaunchCamera =>
      'Set an album for this ritual to launch the camera.';

  @override
  String get ritualDefaultCameraTitle => 'Take a photo';

  @override
  String get ritualBadgeMessage7 =>
      '7 days down! Consistency looks good on you. Keep going!';

  @override
  String get ritualBadgeMessage14 =>
      '14 days in! Your ritual is becoming a habit. Incredible!';

  @override
  String get ritualBadgeMessage30 =>
      '30 days in a row! Legendary consistency. Take a bow!';

  @override
  String get ritualBadgeMessageDefault => 'You\'re on a roll!';

  @override
  String get ritualBadgeNewTitle => 'New achievement';

  @override
  String get ritualBadgePreparing => 'Preparing...';

  @override
  String get ritualStreaksLabel => 'Streaks';

  @override
  String get ritualCreateYourOwn => 'Create your own ritual';

  @override
  String get ritualGetDailyReminders => 'Get daily reminders';

  @override
  String get ritualAlbumNotSet => 'Album not set';

  @override
  String get ritualOpenCameraTooltip => 'Open ritual camera';

  @override
  String get ritualEditorLabel => 'Ritual editor';

  @override
  String get ritualNew => 'New ritual';

  @override
  String get ritualEdit => 'Edit ritual';

  @override
  String get ritualEnterPrompt => 'Enter your ritual';

  @override
  String get ritualEnterDescription => 'Please enter a description';

  @override
  String get ritualDayLabel => 'Day';

  @override
  String get ritualNotificationsOffHint =>
      'Notifications are off. Tap a day to turn them on.';

  @override
  String get ritualTimeLabel => 'Time';

  @override
  String get ritualAlbumLabel => 'Album';

  @override
  String get ritualSave => 'Save ritual';

  @override
  String get ritualUpdate => 'Update ritual';

  @override
  String get ritualSelectAlbumTitle => 'Select album';

  @override
  String get ritualSearchOrCreate => 'Search or create new';

  @override
  String get ritualNoAlbumsYet => 'No albums yet';

  @override
  String get ritualNoMatchingAlbums => 'No matching albums';

  @override
  String ritualCreateAlbumWithName({required String albumName}) {
    return 'Create \"$albumName\"';
  }

  @override
  String get ritualCreateNew => 'Create new';

  @override
  String get ritualAlbumSelectionPlaceholder => 'Select album';

  @override
  String get ritualPickEmojiTitle => 'Pick an emoji';

  @override
  String get ritualCustomKeyboardLabel => 'Custom (keyboard)';

  @override
  String get ritualEmojiKeyboardHint => 'Press to open emoji keyboard';

  @override
  String get ritualEmojiUseAction => 'Use';

  @override
  String get ritualSearchEmpty =>
      'Build a ritual to keep your photo habit going.';
}

/// The translations for Portuguese, as used in Brazil (`pt_BR`).
class AppLocalizationsPtBr extends AppLocalizationsPt {
  AppLocalizationsPtBr() : super('pt_BR');

  @override
  String get enterYourEmailAddress => 'Insira seu e-mail';

  @override
  String get enterYourNewEmailAddress => 'Insira seu novo e-mail';

  @override
  String get accountWelcomeBack => 'Bem-vindo(a) de volta!';

  @override
  String get emailAlreadyRegistered => 'E-mail já registrado.';

  @override
  String get emailNotRegistered => 'E-mail não registrado.';

  @override
  String get email => 'E-mail';

  @override
  String get cancel => 'Cancelar';

  @override
  String get verify => 'Verificar';

  @override
  String get invalidEmailAddress => 'E-mail inválido';

  @override
  String get enterValidEmail => 'Insira um e-mail válido.';

  @override
  String get deleteAccount => 'Excluir conta';

  @override
  String get deleteAccountWarning =>
      'Isto irá excluir sua conta de Ente Auth, Ente Photos e Ente Locker.';

  @override
  String get askDeleteReason => 'Por que você quer excluir sua conta?';

  @override
  String get deleteAccountFeedbackPrompt =>
      'Lamentamos você ir. Compartilhe seu feedback para ajudar-nos a melhorar.';

  @override
  String get feedback => 'Feedback';

  @override
  String get kindlyHelpUsWithThisInformation => 'Ajude-nos com esta informação';

  @override
  String get confirmDeletePrompt =>
      'Sim, eu quero permanentemente excluir esta conta e os dados em todos os aplicativos.';

  @override
  String get confirmAccountDeletion => 'Confirmar exclusão da conta';

  @override
  String get deleteAccountPermanentlyButton => 'Excluir conta permanentemente';

  @override
  String get yourAccountHasBeenDeleted => 'Sua conta foi excluída';

  @override
  String get selectReason => 'Diga o motivo';

  @override
  String get deleteReason1 => 'Está faltando um recurso-chave que eu preciso';

  @override
  String get deleteReason2 =>
      'O aplicativo ou um certo recurso não funciona da maneira que eu acredito que deveria funcionar';

  @override
  String get deleteReason3 => 'Encontrei outro serviço que considero melhor';

  @override
  String get deleteReason4 => 'Meu motivo não está listado';

  @override
  String get sendEmail => 'Enviar e-mail';

  @override
  String get deleteRequestSLAText =>
      'Sua solicitação será revisada em até 72 horas.';

  @override
  String get deleteEmailRequest =>
      'Por favor, envie um e-mail a <warning>account-deletion@ente.io</warning> do seu e-mail registrado.';

  @override
  String get entePhotosPerm =>
      'Ente <i>precisa de permissão para</i> preservar suas fotos';

  @override
  String get ok => 'OK';

  @override
  String get createAccount => 'Criar conta';

  @override
  String get createNewAccount => 'Criar nova conta';

  @override
  String get password => 'Senha';

  @override
  String get confirmPassword => 'Confirmar senha';

  @override
  String get activeSessions => 'Sessões ativas';

  @override
  String get ocrProcessingOverlayMessage => 'Detectando texto...';

  @override
  String get ocrLoadingIndicatorLabel => 'Detectando texto';

  @override
  String get ocrSelectionHint =>
      'Deslize ou toque duas vezes para selecionar apenas o que você precisa';

  @override
  String get ocrNoTextDetected => 'Nenhum texto detectado';

  @override
  String get ocrRetryButtonLabel => 'Tentar novamente';

  @override
  String get ocrModelsNetworkRequiredError =>
      'Conexão de rede necessária para baixar modelos OCR no primeiro uso';

  @override
  String get ocrModelsPrepareFailed => 'Não foi possível preparar modelos OCR';

  @override
  String get ocrImageNotFoundError => 'Arquivo de imagem não encontrado';

  @override
  String get ocrImageDecodeFailedError =>
      'Não foi possível ler o arquivo de imagem';

  @override
  String get ocrGenericDetectError =>
      'Não foi possível detectar o texto na imagem';

  @override
  String get oops => 'Ops';

  @override
  String get somethingWentWrongPleaseTryAgain =>
      'Algo deu errado. Tente outra vez';

  @override
  String get thisWillLogYouOutOfThisDevice =>
      'Isso fará você sair deste dispositivo!';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice =>
      'Isso fará você sair do dispositivo a seguir:';

  @override
  String get terminateSession => 'Sair?';

  @override
  String get terminate => 'Encerrar';

  @override
  String get thisDevice => 'Este dispositivo';

  @override
  String get recoverButton => 'Recuperar';

  @override
  String get recoverySuccessful => 'Recuperação com sucesso!';

  @override
  String get decrypting => 'Descriptografando...';

  @override
  String get incorrectRecoveryKeyTitle => 'Chave de recuperação incorreta';

  @override
  String get incorrectRecoveryKeyBody =>
      'A chave de recuperação inserida está incorreta';

  @override
  String get forgotPassword => 'Esqueci a senha';

  @override
  String get enterYourRecoveryKey => 'Insira sua chave de recuperação';

  @override
  String get noRecoveryKey => 'Sem chave de recuperação?';

  @override
  String get sorry => 'Desculpe';

  @override
  String get noRecoveryKeyNoDecryption =>
      'Devido à natureza do nosso protocolo de criptografia de ponta a ponta, seus dados não podem ser descriptografados sem sua senha ou chave de recuperação';

  @override
  String get verifyEmail => 'Verificar e-mail';

  @override
  String get toResetVerifyEmail =>
      'Para redefinir sua senha, verifique seu e-mail primeiramente.';

  @override
  String get checkInboxAndSpamFolder =>
      'Verifique sua caixa de entrada (e spam) para concluir a verificação';

  @override
  String get tapToEnterCode => 'Toque para inserir código';

  @override
  String get resendEmail => 'Reenviar e-mail';

  @override
  String weHaveSendEmailTo({required String email}) {
    return 'Enviamos um e-mail à <green>$email</green>';
  }

  @override
  String get setPasswordTitle => 'Definir senha';

  @override
  String get changePasswordTitle => 'Alterar senha';

  @override
  String get resetPasswordTitle => 'Redefinir senha';

  @override
  String get encryptionKeys => 'Chaves de criptografia';

  @override
  String get passwordWarning =>
      'Nós não armazenamos esta senha, se você esquecer, <underline>nós não poderemos descriptografar seus dados</underline>';

  @override
  String get enterPasswordToEncrypt =>
      'Insira uma senha que podemos usar para criptografar seus dados';

  @override
  String get enterNewPasswordToEncrypt =>
      'Insira uma senha nova para criptografar seus dados';

  @override
  String get weakStrength => 'Fraca';

  @override
  String get strongStrength => 'Forte';

  @override
  String get moderateStrength => 'Moderado';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'Força da senha: $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully => 'Senha alterada com sucesso';

  @override
  String get generatingEncryptionKeys => 'Gerando chaves de criptografia...';

  @override
  String get pleaseWait => 'Aguarde...';

  @override
  String get continueLabel => 'Continuar';

  @override
  String get insecureDevice => 'Dispositivo inseguro';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'Desculpe, não foi possível gerar chaves seguras neste dispositivo.\n\ninicie sessão com um dispositivo diferente.';

  @override
  String get howItWorks => 'Como funciona';

  @override
  String get encryption => 'Criptografia';

  @override
  String get ackPasswordLostWarning =>
      'Eu entendo que se eu perder minha senha, posso perder meus dados, já que meus dados são <underline>criptografados de ponta a ponta</underline>.';

  @override
  String get privacyPolicyTitle => 'Política de Privacidade';

  @override
  String get termsOfServicesTitle => 'Termos';

  @override
  String get signUpTerms =>
      'Eu concordo com os <u-terms>termos de serviço</u-terms> e a <u-policy>política de privacidade</u-policy>';

  @override
  String get logInLabel => 'Entrar';

  @override
  String get loginTerms =>
      'Ao clicar em entrar, eu concordo com os <u-terms>termos de serviço</u-terms> e a <u-policy>política de privacidade</u-policy>';

  @override
  String get changeEmail => 'Alterar e-mail';

  @override
  String get enterYourPassword => 'Insira sua senha';

  @override
  String get welcomeBack => 'Bem-vindo(a) de volta!';

  @override
  String get contactSupport => 'Contatar suporte';

  @override
  String get incorrectPasswordTitle => 'Senha incorreta';

  @override
  String get pleaseTryAgain => 'Tente novamente';

  @override
  String get recreatePasswordTitle => 'Redefinir senha';

  @override
  String get useRecoveryKey => 'Usar chave de recuperação';

  @override
  String get recreatePasswordBody =>
      'O dispositivo atual não é poderoso o suficiente para verificar sua senha, no entanto, nós podemos regenerar numa maneira que funciona em todos os dispositivos.\n\nEntre usando a chave de recuperação e regenere sua senha (você pode usar a mesma novamente se desejar).';

  @override
  String get verifyPassword => 'Verificar senha';

  @override
  String get recoveryKey => 'Chave de recuperação';

  @override
  String get recoveryKeyOnForgotPassword =>
      'Caso você esqueça sua senha, a única maneira de recuperar seus dados é com esta chave.';

  @override
  String get recoveryKeySaveDescription =>
      'Não armazenamos esta chave, salve esta chave de 24 palavras em um lugar seguro.';

  @override
  String get doThisLater => 'Fazer isso depois';

  @override
  String get saveKey => 'Salvar chave';

  @override
  String get recoveryKeyCopiedToClipboard =>
      'Chave de recuperação copiada para a área de transferência';

  @override
  String get recoverAccount => 'Recuperar conta';

  @override
  String get recover => 'Recuperar';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'Envie um e-mail para $supportEmail a partir do e-mail registrado';
  }

  @override
  String get twofactorSetup => 'Configuração de dois fatores';

  @override
  String get enterCode => 'Inserir código';

  @override
  String get scanCode => 'Escanear código';

  @override
  String get codeCopiedToClipboard =>
      'Código copiado para a área de transferência';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      'Copie e cole o código no aplicativo autenticador';

  @override
  String get tapToCopy => 'toque para copiar';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      'Escaneie este código de barras com\no aplicativo autenticador';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      'Digite o código de 6 dígitos do\naplicativo autenticador';

  @override
  String get confirm => 'Confirmar';

  @override
  String get setupComplete => 'Configuração concluída';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready =>
      'Salve sua chave de recuperação, se você ainda não fez';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      'Isso pode ser usado para recuperar sua conta se você perder seu segundo fator';

  @override
  String get twofactorAuthenticationPageTitle => 'Autenticação de dois fatores';

  @override
  String get lostDevice => 'Perdeu o dispositivo?';

  @override
  String get verifyingRecoveryKey => 'Verificando chave de recuperação...';

  @override
  String get recoveryKeyVerified => 'Chave de recuperação verificada';

  @override
  String get recoveryKeySuccessBody =>
      'Ótimo! Sua chave de recuperação é válida. Obrigada por verificar.\n\nLembre-se de manter sua chave de recuperação salva em segurança.';

  @override
  String get invalidRecoveryKey =>
      'A chave de recuperação que você inseriu não é válida. Certifique-se de conter 24 caracteres, e verifique a ortografia de cada um deles.\n\nSe você inseriu um código de recuperação mais antigo, verifique se ele tem 64 caracteres e verifique cada um deles.';

  @override
  String get invalidKey => 'Chave inválida';

  @override
  String get tryAgain => 'Tente novamente';

  @override
  String get viewRecoveryKey => 'Ver chave de recuperação';

  @override
  String get confirmRecoveryKey => 'Confirmar chave de recuperação';

  @override
  String get recoveryKeyVerifyReason =>
      'Sua chave de recuperação é a única maneira de recuperar suas fotos se você esqueceu sua senha. Você pode encontrar sua chave de recuperação em Opções > Conta.\n\nInsira sua chave de recuperação aqui para verificar se você a salvou corretamente.';

  @override
  String get confirmYourRecoveryKey => 'Confirme sua chave de recuperação';

  @override
  String get addViewer => 'Adicionar visualizador';

  @override
  String get addCollaborator => 'Adicionar colaborador';

  @override
  String get addANewEmail => 'Adicionar um novo e-mail';

  @override
  String get orPickAnExistingOne => 'Ou escolha um existente';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'Colaboradores podem adicionar fotos e vídeos ao álbum compartilhado.';

  @override
  String get enterEmail => 'Inserir e-mail';

  @override
  String get albumOwner => 'Proprietário';

  @override
  String get you => 'Você';

  @override
  String get collaborator => 'Colaborador';

  @override
  String get addMore => 'Adicionar mais';

  @override
  String get viewer => 'Visualizador';

  @override
  String get remove => 'Remover';

  @override
  String get removeParticipant => 'Remover participante';

  @override
  String get manage => 'Gerenciar';

  @override
  String get addedAs => 'Adicionado como';

  @override
  String get changePermissions => 'Alterar permissões?';

  @override
  String get yesConvertToViewer => 'Sim, converter para visualizador';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return '$user Não poderá adicionar mais fotos a este álbum\n\nEles ainda conseguirão remover fotos existentes adicionadas por eles';
  }

  @override
  String get allowAddingPhotos => 'Permitir adicionar fotos';

  @override
  String get allowJoiningAlbum => 'Permitir entrada de álbum';

  @override
  String get allowAddPhotosDescription =>
      'Permitir que as pessoas com link também adicionem fotos ao álbum compartilhado.';

  @override
  String get passwordLock => 'Bloqueio por senha';

  @override
  String get canNotOpenTitle => 'Não pôde abrir este álbum';

  @override
  String get canNotOpenBody =>
      'Desculpe, este álbum não pode ser aberto no aplicativo.';

  @override
  String get disableDownloadWarningTitle => 'Por favor, saiba que';

  @override
  String get disableDownloadWarningBody =>
      'Os visualizadores podem fazer capturas de tela ou salvar uma cópia de suas fotos usando ferramentas externas';

  @override
  String get allowDownloads => 'Permitir downloads';

  @override
  String get linkDeviceLimit => 'Limite do dispositivo';

  @override
  String get noDeviceLimit => 'Nenhum';

  @override
  String get albumLayout => 'Layout do álbum';

  @override
  String get layoutGrouped => 'Agrupados';

  @override
  String get layoutContinuous => 'Contínuo';

  @override
  String get layoutTrip => 'Viagem';

  @override
  String get preview => 'Pré-visualizar';

  @override
  String get linkExpiry => 'Expiração do link';

  @override
  String get linkExpired => 'Expirado';

  @override
  String get linkEnabled => 'Ativado';

  @override
  String get linkNeverExpires => 'Nunca';

  @override
  String get expiredLinkInfo =>
      'O link expirou. Selecione um novo tempo de expiração ou desative a expiração do link.';

  @override
  String get setAPassword => 'Definir senha';

  @override
  String get lockButtonLabel => 'Bloquear';

  @override
  String get enterPassword => 'Inserir senha';

  @override
  String get removeLink => 'Remover link';

  @override
  String get manageLink => 'Gerenciar link';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'O link expirará em $expiryTime';
  }

  @override
  String get albumUpdated => 'Álbum atualizado';

  @override
  String get never => 'Nunca';

  @override
  String get custom => 'Personalizado';

  @override
  String get after1Hour => 'Após 1 hora';

  @override
  String get after1Day => 'Após 1 dia';

  @override
  String get after1Week => 'Após 1 semana';

  @override
  String get after1Month => 'Após 1 mês';

  @override
  String get after1Year => 'Após 1 ano';

  @override
  String get manageParticipants => 'Gerenciar';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count participantes',
      one: '1 participante',
      zero: 'Nenhum participante',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'Crie um link para permitir que as pessoas adicionem e vejam fotos no seu álbum compartilhado sem a necessidade do aplicativo ou uma conta Ente. Ótimo para colecionar fotos de eventos.';

  @override
  String get collectPhotos => 'Coletar fotos';

  @override
  String get collaborativeLink => 'Link colaborativo';

  @override
  String get shareWithNonenteUsers => 'Compartilhar com usuários não ente';

  @override
  String get createPublicLink => 'Criar link público';

  @override
  String get sendLink => 'Enviar link';

  @override
  String get sendQrCode => 'Escanear QR code';

  @override
  String get copyLink => 'Copiar link';

  @override
  String get copyEmbedHtml => 'Copiar HTML incorporado';

  @override
  String get linkHasExpired => 'O link expirou';

  @override
  String get publicLinkEnabled => 'Link público ativo';

  @override
  String get shareALink => 'Compartilhar link';

  @override
  String get sharedAlbumSectionDescription =>
      'Criar álbuns compartilhados e colaborativos com outros usuários Ente, incluindo usuários em planos gratuitos.';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: 'Compartilhado com $numberOfPeople pessoas',
      one: 'Compartilhado com 1 pessoa',
      zero: 'Compartilhe com pessoas específicas',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId => 'Este é o seu ID de verificação';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'Alguém compartilhando álbuns com você deve ver o mesmo ID no dispositivo.';

  @override
  String get howToViewShareeVerificationID =>
      'Peça-os para pressionarem no e-mail a partir das Opções, e verifique-se os IDs de ambos os dispositivos correspondem.';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'Este é o ID de verificação de $email';
  }

  @override
  String get verificationId => 'ID de verificação';

  @override
  String verifyEmailID({required Object email}) {
    return 'Verificar $email';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return '$email não tem uma conta Ente.\n\nEnvie-os um convite para compartilhar fotos.';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return 'Aqui está meu ID de verificação para o ente.io: $verificationID';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'Ei, você pode confirmar se este ID de verificação do ente.io é seu?: $verificationID';
  }

  @override
  String get somethingWentWrong => 'Algo deu errado';

  @override
  String get sendInvite => 'Enviar convite';

  @override
  String get shareTextRecommendUsingEnte =>
      'Baixe o Ente para que nós possamos compartilhar com facilidade fotos e vídeos de qualidade original\n\nhttps://ente.io';

  @override
  String get done => 'Concluído';

  @override
  String get applyCodeTitle => 'Aplicar código';

  @override
  String get enterCodeDescription =>
      'Insira o código fornecido por um amigo para reivindicar armazenamento grátis para ambos';

  @override
  String get apply => 'Aplicar';

  @override
  String get failedToApplyCode => 'Falhou ao aplicar código';

  @override
  String get enterReferralCode => 'Inserir código de referência';

  @override
  String get codeAppliedPageTitle => 'Código aplicado';

  @override
  String get changeYourReferralCode => 'Alterar código de referência';

  @override
  String get change => 'Alterar';

  @override
  String get unavailableReferralCode =>
      'Desculpe, este código está indisponível.';

  @override
  String get codeChangeLimitReached =>
      'Desculpe, você atingiu o limite de mudanças de código.';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'Entre em contato com $familyAdminEmail para alterar o seu código.';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB';
  }

  @override
  String get claimed => 'Reivindicado';

  @override
  String get details => 'Detalhes';

  @override
  String get claimMore => 'Reivindique mais!';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return 'Eles também recebem $storageAmountInGB GB';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB toda vez que alguém utilizar seu código num plano pago';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'Código de referência Ente: $referralCode \n\nAplique-o em Opções → Geral → Referências para obter $referralStorageInGB GB grátis após a inscrição num plano pago\n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => 'Reivindique armaz. grátis';

  @override
  String get inviteYourFriends => 'Convide seus amigos';

  @override
  String get failedToFetchReferralDetails =>
      'Não foi possível buscar os detalhes de referência. Tente novamente mais tarde.';

  @override
  String get referralStep1 => '1. Envie este código aos seus amigos';

  @override
  String get referralStep2 => '2. Eles então se inscrevem num plano pago';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. Ambos ganham $storageInGB GB* grátis';
  }

  @override
  String get referralsAreCurrentlyPaused =>
      'As referências estão atualmente pausadas';

  @override
  String get youCanAtMaxDoubleYourStorage =>
      '* Você pode duplicar seu armazenamento ao máximo';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true': 'Sua família reinvidicou $storageAmountInGb GB até então',
      'false': 'Você reinvindicou $storageAmountInGb GB até então',
      'other': 'Você reinvindicou $storageAmountInGb GB até então!',
    });
    return '$_temp0';
  }

  @override
  String get faq => 'Perguntas frequentes';

  @override
  String get help => 'Ajuda';

  @override
  String get oopsSomethingWentWrong => 'Ops, algo deu errado';

  @override
  String get peopleUsingYourCode => 'Pessoas que usou o código';

  @override
  String get eligible => 'elegível';

  @override
  String get total => 'total';

  @override
  String get codeUsedByYou => 'Código usado por você';

  @override
  String get freeStorageClaimed => 'Armaz. grátis reivindicado';

  @override
  String get freeStorageUsable => 'Armazenamento disponível';

  @override
  String get usableReferralStorageInfo =>
      'O armazenamento disponível é limitado devido ao seu plano atual. O armazenamento adicional será aplicado quando você atualizar seu plano.';

  @override
  String get removeFromAlbumTitle => 'Remover do álbum?';

  @override
  String get removeFromAlbum => 'Remover do álbum';

  @override
  String get itemsWillBeRemovedFromAlbum =>
      'Os itens selecionados serão removidos deste álbum';

  @override
  String get removeShareItemsWarning =>
      'Alguns dos itens que você está removendo foram adicionados por outras pessoas, e você perderá o acesso a eles';

  @override
  String get addingToFavorites => 'Adicionando aos favoritos...';

  @override
  String get removingFromFavorites => 'Removendo dos favoritos...';

  @override
  String get sorryCouldNotAddToFavorites =>
      'Desculpe, não foi possível adicionar aos favoritos!';

  @override
  String get sorryCouldNotRemoveFromFavorites =>
      'Desculpe, não foi possível remover dos favoritos!';

  @override
  String get subscribeToEnableSharing =>
      'Você precisa de uma inscrição paga ativa para ativar o compartilhamento.';

  @override
  String get subscribe => 'Inscrever-se';

  @override
  String get canOnlyRemoveFilesOwnedByYou =>
      'Só pode remover arquivos de sua propriedade';

  @override
  String get deleteSharedAlbum => 'Excluir álbum compartilhado?';

  @override
  String get deleteAlbum => 'Excluir álbum';

  @override
  String get deleteAlbumDialog =>
      'Também excluir as fotos (e vídeos) presentes neste álbum de <bold>todos</bold> os outros álbuns que eles fazem parte?';

  @override
  String get deleteSharedAlbumDialogBody =>
      'O álbum será apagado para todos\n\nVocê perderá o acesso a fotos compartilhadas neste álbum que pertencem aos outros';

  @override
  String get yesRemove => 'Sim, excluir';

  @override
  String get creatingLink => 'Criando link...';

  @override
  String get removeWithQuestionMark => 'Remover?';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return '$userEmail será removido do álbum compartilhado\n\nQualquer foto adicionada por ele será removida.';
  }

  @override
  String get keepPhotos => 'Manter fotos';

  @override
  String get deletePhotos => 'Excluir fotos';

  @override
  String get inviteToEnte => 'Convidar ao Ente';

  @override
  String get removePublicLink => 'Remover link público';

  @override
  String disableLinkMessage({required Object albumName}) {
    return 'Isso removerá o link público para acessar \"$albumName\".';
  }

  @override
  String get sharing => 'Compartilhando...';

  @override
  String get youCannotShareWithYourself =>
      'Não é possível compartilhar consigo mesmo';

  @override
  String get archive => 'Arquivo';

  @override
  String get createAlbumActionHint =>
      'Pressione para selecionar fotos e clique em + para criar um álbum';

  @override
  String get importing => 'Importando....';

  @override
  String get failedToLoadAlbums => 'Falhou ao carregar álbuns';

  @override
  String get hidden => 'Oculto';

  @override
  String get authToViewYourHiddenFiles =>
      'Autentique-se para visualizar seus arquivos ocultos';

  @override
  String get authToViewTrashedFiles =>
      'Autentique-se para ver seus arquivos excluídos';

  @override
  String get trash => 'Lixeira';

  @override
  String get uncategorized => 'Sem categoria';

  @override
  String get videoSmallCase => 'vídeo';

  @override
  String get photoSmallCase => 'foto';

  @override
  String get singleFileDeleteHighlight =>
      'Ele será excluído de todos os álbuns.';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return 'Este $fileType está no Ente e em seu dispositivo.';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return 'Este $fileType será excluído do Ente.';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return 'Este $fileType será excluído do dispositivo.';
  }

  @override
  String get deleteFromEnte => 'Excluir do Ente';

  @override
  String get yesDelete => 'Sim, excluir';

  @override
  String get movedToTrash => 'Movido para a lixeira';

  @override
  String get deleteFromDevice => 'Excluir do dispositivo';

  @override
  String get deleteFromBoth => 'Excluir de ambos';

  @override
  String get newAlbum => 'Novo álbum';

  @override
  String get albums => 'Álbuns';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount memórias',
      one: '$formattedCount memória',
      zero: 'sem memórias',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return '$count selecionado(s)';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return '$count selecionado(s) ($yourCount seus)';
  }

  @override
  String get advancedSettings => 'Avançado';

  @override
  String get photoGridSize => 'Tamanho da grade de fotos';

  @override
  String get manageDeviceStorage => 'Gerenciar cache do dispositivo';

  @override
  String get manageDeviceStorageDesc =>
      'Reveja e limpe o armazenamento de cache local.';

  @override
  String get machineLearning => 'Aprendizado automático';

  @override
  String get mlConsent => 'Ativar o aprendizado automático';

  @override
  String get mlConsentTitle => 'Ativar aprendizado auto.?';

  @override
  String get mlConsentDescription =>
      'Se ativar o aprendizado automático, Ente extrairá informações de geometria facial dos arquivos, incluindo aqueles compartilhados consigo.\n\nIsso acontecerá em seu dispositivo, e qualquer informação biométrica gerada será criptografada de ponta a ponta.';

  @override
  String get mlConsentPrivacy =>
      'Clique aqui para mais detalhes sobre este recurso na política de privacidade';

  @override
  String get mlConsentConfirmation => 'Concordo e desejo ativá-lo';

  @override
  String get magicSearch => 'Busca mágica';

  @override
  String get discover => 'Explorar';

  @override
  String get discover_identity => 'Identidade';

  @override
  String get discover_screenshots => 'Capturas de tela';

  @override
  String get discover_receipts => 'Recibos';

  @override
  String get discover_notes => 'Notas';

  @override
  String get discover_memes => 'Memes';

  @override
  String get discover_visiting_cards => 'Cartões de visita';

  @override
  String get discover_babies => 'Bebês';

  @override
  String get discover_pets => 'Animais de estimação';

  @override
  String get discover_selfies => 'Selfies';

  @override
  String get discover_wallpapers => 'Papéis de parede';

  @override
  String get discover_food => 'Comida';

  @override
  String get discover_celebrations => 'Comemorações';

  @override
  String get discover_sunset => 'Pôr do sol';

  @override
  String get discover_hills => 'Colinas';

  @override
  String get discover_greenery => 'Vegetação';

  @override
  String get mlIndexingDescription =>
      'Saiba que o aprendizado automático afetará a bateria do dispositivo negativamente até todos os itens serem indexados. Utilize a versão para computadores para melhor indexação, todos os resultados se auto-sincronizaram.';

  @override
  String get loadingModel => 'Baixando modelos...';

  @override
  String get waitingForWifi => 'Aguardando Wi-Fi...';

  @override
  String get status => 'Estado';

  @override
  String get indexedItems => 'Itens indexados';

  @override
  String get pendingItems => 'Itens pendentes';

  @override
  String get clearIndexes => 'Limpar índices';

  @override
  String get selectFoldersForBackup => 'Selecione as pastas para salvá-las';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      'As pastas selecionadas serão criptografadas e salvas em segurança';

  @override
  String get unselectAll => 'Desmarcar tudo';

  @override
  String get selectAll => 'Selecionar tudo';

  @override
  String get skip => 'Pular';

  @override
  String get updatingFolderSelection => 'Atualizando seleção de pasta...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count itens',
      one: '$count item',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Excluir $count itens',
      one: 'Excluir $count item',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count arquivos, $formattedSize cada';
  }

  @override
  String get showMemories => 'Mostrar memórias';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count anos atrás',
      one: '$count ano atrás',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'Ajustes de salvar em segurança';

  @override
  String get backupStatus => 'Estado das mídias salvas';

  @override
  String get backupStatusDescription =>
      'Os itens salvos em segurança aparecerão aqui';

  @override
  String get backupOverMobileData => 'Salvar fotos com dados móveis';

  @override
  String get backupVideos => 'Salvar vídeos em segurança';

  @override
  String get disableAutoLock => 'Desativar bloqueio automático';

  @override
  String get deviceLockExplanation =>
      'Desativa o bloqueio de tela se o Ente estiver de fundo e uma cópia de segurança ainda estiver em andamento. Às vezes, isso não é necessário, mas ajuda a agilizar envios grandes e importações iniciais de bibliotecas maiores.';

  @override
  String get about => 'Sobre';

  @override
  String get weAreOpenSource => 'Nós somos de código aberto!';

  @override
  String get privacy => 'Privacidade';

  @override
  String get terms => 'Termos';

  @override
  String get checkForUpdates => 'Buscar atualizações';

  @override
  String get checkStatus => 'Verificar estado';

  @override
  String get checking => 'Verificando...';

  @override
  String get youAreOnTheLatestVersion => 'Você está na versão mais recente';

  @override
  String get account => 'Conta';

  @override
  String get manageSubscription => 'Gerenciar assinatura';

  @override
  String get authToChangeYourEmail =>
      'Por favor, autentique-se para alterar o seu e-mail';

  @override
  String get changePassword => 'Alterar senha';

  @override
  String get authToChangeYourPassword => 'Autentique para alterar sua senha';

  @override
  String get emailVerificationToggle => 'Verificação por e-mail';

  @override
  String get authToChangeEmailVerificationSetting =>
      'Autentique-se para alterar o e-mail de verificação';

  @override
  String get exportYourData => 'Exportar dados';

  @override
  String get logout => 'Encerrar sessão';

  @override
  String get authToInitiateAccountDeletion =>
      'Autentique para iniciar a exclusão de conta';

  @override
  String get areYouSureYouWantToLogout =>
      'Você tem certeza que quer encerrar sessão?';

  @override
  String get yesLogout => 'Sim, encerrar sessão';

  @override
  String get aNewVersionOfEnteIsAvailable =>
      'Uma nova versão do Ente está disponível.';

  @override
  String get update => 'Atualizar';

  @override
  String get installManually => 'Instalar manualmente';

  @override
  String get criticalUpdateAvailable => 'Atualização crítica disponível';

  @override
  String get updateAvailable => 'Atualização disponível';

  @override
  String get ignoreUpdate => 'Ignorar';

  @override
  String get downloading => 'Baixando...';

  @override
  String get cannotDeleteSharedFiles =>
      'Não é possível excluir arquivos compartilhados';

  @override
  String get theDownloadCouldNotBeCompleted =>
      'A instalação não pôde ser concluída';

  @override
  String get retry => 'Tentar novamente';

  @override
  String get backedUpFolders => 'Pastas salvas em segurança';

  @override
  String get backup => 'Salvar em segurança';

  @override
  String get freeUpDeviceSpace => 'Liberar espaço no dispositivo';

  @override
  String get freeUpDeviceSpaceDesc =>
      'Economize espaço em seu dispositivo por limpar arquivos já salvos com segurança.';

  @override
  String get allClear => '✨ Tudo limpo';

  @override
  String get noDeviceThatCanBeDeleted =>
      'Você não tem arquivos neste dispositivo que possam ser excluídos';

  @override
  String get removeDuplicates => 'Excluir duplicatas';

  @override
  String get removeDuplicatesDesc =>
      'Revise e remova arquivos que são duplicatas exatas.';

  @override
  String get viewLargeFiles => 'Arquivos grandes';

  @override
  String get viewLargeFilesDesc =>
      'Ver arquivos que consumem a maior parte do armazenamento.';

  @override
  String get noDuplicates => '✨ Sem duplicatas';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared =>
      'Você não possui nenhum arquivo duplicado que possa ser excluído';

  @override
  String get success => 'Sucesso';

  @override
  String get rateUs => 'Avaliar';

  @override
  String get remindToEmptyDeviceTrash =>
      'Também esvazie o \"Excluído Recentemente\" das \"Opções\" -> \"Armazenamento\" para liberar espaço';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return 'Você liberou $storageSaved com sucesso!';
  }

  @override
  String get remindToEmptyEnteTrash =>
      'Também esvazie sua \"Lixeira\" para reivindicar o espaço liberado';

  @override
  String get sparkleSuccess => '✨ Sucesso';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count arquivos duplicados',
      one: '$count arquivo duplicado',
    );
    return 'Você limpou $_temp0, salvando ($storageSaved!)';
  }

  @override
  String get familyPlans => 'Planos familiares';

  @override
  String get referrals => 'Referências';

  @override
  String get notifications => 'Notificações';

  @override
  String get sharedPhotoNotifications => 'Novas fotos compartilhadas';

  @override
  String get sharedPhotoNotificationsExplanation =>
      'Receba notificações caso alguém adicione uma foto a um álbum compartilhado que você faz parte';

  @override
  String get advanced => 'Avançado';

  @override
  String get general => 'Geral';

  @override
  String get security => 'Segurança';

  @override
  String get authToViewYourRecoveryKey =>
      'Autentique para ver sua chave de recuperação';

  @override
  String get twofactor => 'Dois fatores';

  @override
  String get authToConfigureTwofactorAuthentication =>
      'Autentique para configurar a autenticação de dois fatores';

  @override
  String get lockscreen => 'Tela de bloqueio';

  @override
  String get authToChangeLockscreenSetting =>
      'Autentique para alterar a configuração da tela de bloqueio';

  @override
  String get viewActiveSessions => 'Ver sessões ativas';

  @override
  String get authToViewYourActiveSessions =>
      'Autentique para ver as sessões ativas';

  @override
  String get disableTwofactor => 'Desativar autenticação de dois fatores';

  @override
  String get confirm2FADisable =>
      'Você tem certeza que queira desativar a autenticação de dois fatores?';

  @override
  String get no => 'Não';

  @override
  String get yes => 'Sim';

  @override
  String get social => 'Redes sociais';

  @override
  String rateUsOnStore({required Object storeName}) {
    return 'Avalie-nos no $storeName';
  }

  @override
  String get blog => 'Blog';

  @override
  String get merchandise => 'Produtos';

  @override
  String get twitter => 'Twitter/X';

  @override
  String get mastodon => 'Mastodon';

  @override
  String get matrix => 'Matrix';

  @override
  String get discord => 'Discord';

  @override
  String get reddit => 'Reddit';

  @override
  String get yourStorageDetailsCouldNotBeFetched =>
      'Seus detalhes de armazenamento não puderam ser obtidos';

  @override
  String get reportABug => 'Informar um erro';

  @override
  String get reportBug => 'Informar erro';

  @override
  String get suggestFeatures => 'Sugerir recurso';

  @override
  String get support => 'Suporte';

  @override
  String get theme => 'Tema';

  @override
  String get lightTheme => 'Claro';

  @override
  String get darkTheme => 'Escuro';

  @override
  String get systemTheme => 'Sistema';

  @override
  String get freeTrial => 'Avaliação grátis';

  @override
  String get selectYourPlan => 'Selecione seu plano';

  @override
  String get enteSubscriptionPitch =>
      'O Ente preserva suas memórias, então eles sempre estão disponíveis para você, mesmo se você perder o dispositivo.';

  @override
  String get enteSubscriptionShareWithFamily =>
      'Sua família também poderá ser adicionada ao seu plano.';

  @override
  String get currentUsageIs => 'O uso atual é ';

  @override
  String get faqs => 'Perguntas frequentes';

  @override
  String renewsOn({required Object endDate}) {
    return 'Renovação de assinatura em $endDate';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return 'A avaliação grátis acaba em $endDate';
  }

  @override
  String validTill({required Object endDate}) {
    return 'Válido até $endDate';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return 'Seu complemento $storageAmount é válido até $endDate';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return 'Avaliação grátis válida até $endDate.\nVocê pode alterar para um plano pago depois.';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'Sua assinatura será cancelada em $endDate';
  }

  @override
  String get subscription => 'Assinatura';

  @override
  String get paymentDetails => 'Detalhes de pagamento';

  @override
  String get manageFamily => 'Gerenciar família';

  @override
  String contactToManageSubscription({required Object provider}) {
    return 'Entre em contato conosco em support@ente.io para gerenciar sua assinatura $provider.';
  }

  @override
  String get renewSubscription => 'Renovar assinatura';

  @override
  String get cancelSubscription => 'Cancelar assinatura';

  @override
  String get areYouSureYouWantToRenew => 'Deseja renovar?';

  @override
  String get yesRenew => 'Sim';

  @override
  String get areYouSureYouWantToCancel => 'Deseja cancelar?';

  @override
  String get yesCancel => 'Sim';

  @override
  String get failedToRenew => 'Falhou ao renovar';

  @override
  String get failedToCancel => 'Falhou ao cancelar';

  @override
  String get twoMonthsFreeOnYearlyPlans => '2 meses grátis em planos anuais';

  @override
  String get monthly => 'Mensal';

  @override
  String get yearly => 'Anual';

  @override
  String get confirmPlanChange => 'Confirmar mudança de plano';

  @override
  String get areYouSureYouWantToChangeYourPlan => 'Deseja trocar de plano?';

  @override
  String get youCannotDowngradeToThisPlan =>
      'Você não pode rebaixar para este plano';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'Primeiramente cancele sua assinatura existente do $paymentProvider';
  }

  @override
  String get optionalAsShortAsYouLike => 'Opcional, tão curto como quiser...';

  @override
  String get send => 'Enviar';

  @override
  String get askCancelReason =>
      'Sua assinatura foi cancelada. Deseja compartilhar o motivo?';

  @override
  String get thankYouForSubscribing => 'Obrigado por assinar!';

  @override
  String get yourPurchaseWasSuccessful => 'Sua compra foi efetuada com sucesso';

  @override
  String get yourPlanWasSuccessfullyUpgraded =>
      'Seu plano foi atualizado com sucesso';

  @override
  String get yourPlanWasSuccessfullyDowngraded =>
      'Seu plano foi rebaixado com sucesso';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully =>
      'Sua assinatura foi atualizada com sucesso';

  @override
  String get googlePlayId => 'ID do Google Play';

  @override
  String get appleId => 'ID da Apple';

  @override
  String get playstoreSubscription => 'Assinatura da PlayStore';

  @override
  String get appstoreSubscription => 'Assinatura da AppStore';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return 'Seu $id já está vinculado a outra conta Ente. Se você gostaria de usar seu $id com esta conta, entre em contato conosco\"';
  }

  @override
  String get visitWebToManage =>
      'Visite o web.ente.io para gerenciar sua assinatura';

  @override
  String get couldNotUpdateSubscription =>
      'Não foi possível atualizar a assinatura';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      'Entre em contato com support@ente.io e nós ficaremos felizes em ajudar!';

  @override
  String get paymentFailed => 'O pagamento falhou';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return 'Fale com o suporte $providerName se você foi cobrado';
  }

  @override
  String get continueOnFreeTrial => 'Continuar com a avaliação grátis';

  @override
  String get areYouSureYouWantToExit => 'Tem certeza de que queira sair?';

  @override
  String get thankYou => 'Obrigado';

  @override
  String get failedToVerifyPaymentStatus =>
      'Falhou ao verificar estado do pagamento';

  @override
  String get pleaseWaitForSometimeBeforeRetrying =>
      'Por favor, aguarde mais algum tempo antes de tentar novamente';

  @override
  String get paymentFailedMessage =>
      'Infelizmente o pagamento falhou. Entre em contato com o suporte e nós ajudaremos você!';

  @override
  String get youAreOnAFamilyPlan => 'Você está em um plano familiar!';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'Entre em contato com <green>$familyAdminEmail</green> para gerenciar sua assinatura';
  }

  @override
  String get leaveFamily => 'Sair do plano familiar';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily =>
      'Você tem certeza que queira sair do plano familiar?';

  @override
  String get leave => 'Sair';

  @override
  String get rateTheApp => 'Avalie o aplicativo';

  @override
  String get startBackup => 'Iniciar a salvar em segurança';

  @override
  String get noPhotosAreBeingBackedUpRightNow =>
      'No momento não há fotos sendo salvas em segurança';

  @override
  String get preserveMore => 'Preservar mais';

  @override
  String get grantFullAccessPrompt =>
      'Permita o acesso a todas as fotos nas opções do aplicativo';

  @override
  String get allowPermTitle => 'Permita acesso às Fotos';

  @override
  String get allowPermBody =>
      'Permita o acesso a suas fotos nas Opções para que Ente exiba e salva em segurança sua fototeca.';

  @override
  String get openSettings => 'Abrir opções';

  @override
  String get selectMorePhotos => 'Selecionar mais fotos';

  @override
  String get existingUser => 'Usuário existente';

  @override
  String get privateBackups => 'Cópias privadas';

  @override
  String get forYourMemories => 'para suas memórias';

  @override
  String get endtoendEncryptedByDefault =>
      'Criptografado de ponta a ponta por padrão';

  @override
  String get safelyStored => 'Armazenado com segurança';

  @override
  String get atAFalloutShelter => 'em um abrigo avançado';

  @override
  String get designedToOutlive => 'Feito para reviver memórias';

  @override
  String get available => 'Disponível';

  @override
  String get everywhere => 'em todas as partes';

  @override
  String get androidIosWebDesktop => 'Android, iOS, Web, Computador';

  @override
  String get mobileWebDesktop => 'Celular, Web, Computador';

  @override
  String get newToEnte => 'Novo no Ente';

  @override
  String get pleaseLoginAgain => 'Registre-se novamente';

  @override
  String get autoLogoutMessage =>
      'Devido ao ocorrido de erros técnicos, você foi desconectado. Pedimos desculpas pela inconveniência.';

  @override
  String get yourSubscriptionHasExpired => 'A sua assinatura expirou';

  @override
  String get storageLimitExceeded => 'Limite de armazenamento excedido';

  @override
  String get upgrade => 'Atualizar';

  @override
  String get raiseTicket => 'Abrir ticket';

  @override
  String get backupFailed => 'Falhou ao salvar em segurança';

  @override
  String get sorryBackupFailedDesc =>
      'Desculpe, não podemos salvar em segurança este arquivo no momento, nós tentaremos mais tarde.';

  @override
  String get couldNotBackUpTryLater =>
      'Nós não podemos salvar seus dados.\nNós tentaremos novamente mais tarde.';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      'Ente pode criptografar e preservar arquivos apenas se você conceder acesso a eles';

  @override
  String get pleaseGrantPermissions => 'Por favor, conceda as permissões';

  @override
  String get grantPermission => 'Conceder permissões';

  @override
  String get privateSharing => 'Compartilha privada';

  @override
  String get shareOnlyWithThePeopleYouWant =>
      'Compartilhar apenas com as pessoas que você quiser';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      'Usar links públicos para pessoas que não estão no Ente';

  @override
  String get allowPeopleToAddPhotos => 'Permitir que pessoas adicionem fotos';

  @override
  String get shareAnAlbumNow => 'Compartilhar um álbum agora';

  @override
  String get collectEventPhotos => 'Coletar fotos de evento';

  @override
  String get sessionExpired => 'Sessão expirada';

  @override
  String get loggingOut => 'Desconectando...';

  @override
  String get onDevice => 'No dispositivo';

  @override
  String get onEnte => 'No <branding>ente</branding>';

  @override
  String get name => 'Nome';

  @override
  String get newest => 'Mais recente';

  @override
  String get lastUpdated => 'Última atualização';

  @override
  String get deleteEmptyAlbums => 'Excluir álbuns vazios';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => 'Excluir álbuns vazios?';

  @override
  String get deleteAlbumsDialogBody =>
      'Isso excluirá todos os álbuns vazios. Isso é útil quando você quiser reduzir a desordem no seu álbum.';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return 'Excluindo $currentlyDeleting / $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return 'Processando $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => 'Excluir permanentemente';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou =>
      'Só é possível criar um link para arquivos pertencentes a você';

  @override
  String get publicLinkCreated => 'Link público criado';

  @override
  String get youCanManageYourLinksInTheShareTab =>
      'Você pode gerenciar seus links na aba de compartilhamento.';

  @override
  String get linkCopiedToClipboard =>
      'Link copiado para a área de transferência';

  @override
  String get restore => 'Restaurar';

  @override
  String get moveToAlbum => 'Mover para o álbum';

  @override
  String get unhide => 'Desocultar';

  @override
  String get unarchive => 'Desarquivar';

  @override
  String get favorite => 'Favorito';

  @override
  String get removeFromFavorite => 'Desfavoritar';

  @override
  String get shareLink => 'Compartilhar link';

  @override
  String get createCollage => 'Criar colagem';

  @override
  String get saveCollage => 'Salvar colagem';

  @override
  String get collageSaved => 'Colagem salva na galeria';

  @override
  String get collageLayout => 'Layout';

  @override
  String get addToEnte => 'Adicionar ao Ente';

  @override
  String get addToAlbum => 'Adicionar ao álbum';

  @override
  String get delete => 'Excluir';

  @override
  String get hide => 'Ocultar';

  @override
  String get share => 'Compartilhar';

  @override
  String get unhideToAlbum => 'Desocultar para o álbum';

  @override
  String get restoreToAlbum => 'Restaurar para álbum';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Mover itens',
      one: 'Mover item',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Adicionar itens',
      one: 'Adicionar item',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'Criar ou selecionar álbum';

  @override
  String get selectAlbum => 'Selecionar álbum';

  @override
  String get searchByAlbumNameHint => 'Nome do álbum';

  @override
  String get albumTitle => 'Título do álbum';

  @override
  String get enterAlbumName => 'Inserir nome do álbum';

  @override
  String get restoringFiles => 'Restaurando arquivos...';

  @override
  String get movingFilesToAlbum => 'Movendo arquivos para o álbum...';

  @override
  String get unhidingFilesToAlbum => 'Desocultando arquivos para o álbum';

  @override
  String get canNotUploadToAlbumsOwnedByOthers =>
      'Não é possível enviar para álbuns pertencentes a outros';

  @override
  String get uploadingFilesToAlbum => 'Enviando arquivos para o álbum...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return 'Adicionado com sucesso a  $albumName';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return 'Movido com sucesso para $albumName';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'Este álbum já tem um link colaborativo';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return 'Link colaborativo criado para $albumName';
  }

  @override
  String get askYourLovedOnesToShare =>
      'Peça que seus entes queridos compartilhem';

  @override
  String get invite => 'Convidar';

  @override
  String get shareYourFirstAlbum => 'Compartilhar seu primeiro álbum';

  @override
  String sharedWith({required Object emailIDs}) {
    return 'Compartilhado com $emailIDs';
  }

  @override
  String get sharedWithMe => 'Compartilhado comigo';

  @override
  String get sharedByMe => 'Compartilhada por mim';

  @override
  String get doubleYourStorage => 'Duplique seu armazenamento';

  @override
  String get referFriendsAnd2xYourPlan =>
      'Recomende seus amigos e duplique seu plano';

  @override
  String get shareAlbumHint =>
      'Abra um álbum e toque no botão compartilhar no canto superior direito para compartilhar.';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      'Os itens exibem o número de dias restantes antes da exclusão permanente';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count dias',
      one: '1 dia',
      zero: 'Em breve',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => 'Excluir tudo';

  @override
  String get renameAlbum => 'Renomear álbum';

  @override
  String get convertToAlbum => 'Converter para álbum';

  @override
  String get setCover => 'Definir capa';

  @override
  String get sortAlbumsBy => 'Ordenar por';

  @override
  String get sortNewestFirst => 'Recentes primeiro';

  @override
  String get sortOldestFirst => 'Antigos primeiro';

  @override
  String get rename => 'Renomear';

  @override
  String get leaveSharedAlbum => 'Sair do álbum compartilhado?';

  @override
  String get leaveAlbum => 'Sair do álbum';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'Suas fotos adicionadas serão removidas do álbum';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted =>
      'Você não tem arquivos neste álbum que possam ser excluídos';

  @override
  String get youDontHaveAnyArchivedItems =>
      'Você não tem nenhum item arquivado.';

  @override
  String get ignoredFolderUploadReason =>
      'Alguns arquivos neste álbum são ignorados do envio porque eles foram anteriormente excluídos do Ente.';

  @override
  String get resetIgnoredFiles => 'Redefinir arquivos ignorados';

  @override
  String get deviceFilesAutoUploading =>
      'Arquivos adicionados ao álbum do dispositivo serão automaticamente enviados para o Ente.';

  @override
  String get turnOnBackupForAutoUpload =>
      'Ative o salvamento em segurança para automaticamente enviar arquivos adicionados à pasta do dispositivo para o Ente.';

  @override
  String get noHiddenPhotosOrVideos => 'Sem fotos ou vídeos ocultos';

  @override
  String get toHideAPhotoOrVideo => 'Para ocultar uma foto ou vídeo';

  @override
  String get openTheItem => '• Abra a foto ou vídeo';

  @override
  String get clickOnTheOverflowMenu => '• Clique no menu adicional';

  @override
  String get click => '• Clique';

  @override
  String get nothingToSeeHere => 'Nada para ver aqui! 👀';

  @override
  String get unarchiveAlbum => 'Desarquivar álbum';

  @override
  String get archiveAlbum => 'Arquivar álbum';

  @override
  String get calculating => 'Calculando...';

  @override
  String get pleaseWaitDeletingAlbum => 'Aguarde, excluindo álbum';

  @override
  String get searchByExamples =>
      '• Nomes de álbuns (ex: \"Câmera\")\n• Tipos de arquivos (ex.: \"Vídeos\", \".gif\")\n• Anos e meses (ex.: \"2022\", \"Janeiro\")\n• Temporadas (ex.: \"Natal\")\n• Tags (ex.: \"#divertido\")';

  @override
  String get youCanTrySearchingForADifferentQuery =>
      'Você pode tentar buscar por outra consulta.';

  @override
  String get noResultsFound => 'Nenhum resultado encontrado';

  @override
  String addedBy({required Object emailOrName}) {
    return 'Adicionado por $emailOrName';
  }

  @override
  String get loadingExifData => 'Carregando dados EXIF...';

  @override
  String get viewAllExifData => 'Ver todos os dados EXIF';

  @override
  String get noExifData => 'Sem dados EXIF';

  @override
  String get thisImageHasNoExifData => 'Esta imagem não possui dados EXIF';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => 'Nenhum resultado';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'Não suportamos a edição de fotos e álbuns que você ainda não possui';

  @override
  String get failedToFetchOriginalForEdit =>
      'Falhou ao obter original para edição';

  @override
  String get close => 'Fechar';

  @override
  String get setAs => 'Definir como';

  @override
  String get fileSavedToGallery => 'Arquivo salvo na galeria';

  @override
  String get filesSavedToGallery => 'Arquivos salvos na galeria';

  @override
  String get fileFailedToSaveToGallery => 'Falhou ao salvar arquivo na galeria';

  @override
  String get download => 'Baixar';

  @override
  String get pressAndHoldToPlayVideo =>
      'Pressione e segure para reproduzir o vídeo';

  @override
  String get pressAndHoldToPlayVideoDetailed =>
      'Pressione e segure na imagem para reproduzir o vídeo';

  @override
  String get downloadFailed => 'Falhou ao baixar';

  @override
  String get deduplicateFiles => 'Arquivos duplicados';

  @override
  String get deselectAll => 'Deselecionar tudo';

  @override
  String get reviewDeduplicateItems =>
      'Reveja e exclua os itens que você acredita serem duplicados.';

  @override
  String get clubByCaptureTime => 'Agrupar por tempo de captura';

  @override
  String get clubByFileName => 'Agrupar por nome do arquivo';

  @override
  String get count => 'Contagem';

  @override
  String get totalSize => 'Tamanho total';

  @override
  String get longpressOnAnItemToViewInFullscreen =>
      'Mantenha pressionado em um item para visualizá-lo em tela cheia';

  @override
  String get decryptingVideo => 'Descriptografando vídeo...';

  @override
  String get authToViewYourMemories => 'Autentique-se para ver suas memórias';

  @override
  String get unlock => 'Desbloquear';

  @override
  String get freeUpSpace => 'Liberar espaço';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other:
          'Eles podem ser excluídos do dispositivo para liberar $formattedSize',
      one: 'Ele pode excluído do dispositivo para liberar $formattedSize',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber arquivos',
      one: '1 arquivo',
    );
    return '$_temp0 deste álbum foi(ram) salvo(s) em segurança';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber arquivos',
      one: '1 arquivo',
    );
    return '$_temp0 deste dispositivo foi(ram) salvos em segurança';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '-los',
      one: '-lo',
    );
    return 'Você ainda pode acessá$_temp0 no Ente se você tiver uma assinatura ativa';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return 'Liberar $sizeInMBorGB';
  }

  @override
  String get thisEmailIsAlreadyInUse => 'Este e-mail já está sendo usado';

  @override
  String get incorrectCode => 'Código incorreto';

  @override
  String get authenticationFailedPleaseTryAgain =>
      'Falha na autenticação. Tente novamente';

  @override
  String get verificationFailedPleaseTryAgain =>
      'Falha na verificação. Tente novamente';

  @override
  String get authenticating => 'Autenticando...';

  @override
  String get authenticationSuccessful => 'Autenticado com sucesso!';

  @override
  String get incorrectRecoveryKey => 'Chave de recuperação incorreta';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect =>
      'A chave de recuperação inserida está incorreta';

  @override
  String get twofactorAuthenticationSuccessfullyReset =>
      'Autenticação de dois fatores redefinida com sucesso';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered => 'Verifique o código inserido';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      'Por favor, contate o suporte se o problema persistir';

  @override
  String get twofactorAuthenticationHasBeenDisabled =>
      'A autenticação de dois fatores foi desativada';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect =>
      'O código inserido está incorreto';

  @override
  String get yourVerificationCodeHasExpired =>
      'O código de verificação expirou';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'E-mail alterado para $newEmail';
  }

  @override
  String get verifying => 'Verificando...';

  @override
  String get disablingTwofactorAuthentication =>
      'Desativando a autenticação de dois fatores...';

  @override
  String get allMemoriesPreserved => 'Todas as memórias preservadas';

  @override
  String get loadingGallery => 'Carregando galeria...';

  @override
  String get syncing => 'Sincronizando...';

  @override
  String get encryptingBackup => 'Criptografando salvar em segurança...';

  @override
  String get syncStopped => 'Sincronização interrompida';

  @override
  String syncProgress({required String completed, required String total}) {
    return '$completed/$total memórias preservadas';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return 'Preservando $count memórias...';
  }

  @override
  String get uploadingSingleMemory => 'Preservando 1 memória...';

  @override
  String get archiving => 'Arquivando...';

  @override
  String get unarchiving => 'Desarquivando...';

  @override
  String get successfullyArchived => 'Arquivado com sucesso';

  @override
  String get successfullyUnarchived => 'Desarquivado com sucesso';

  @override
  String get renameFile => 'Renomear arquivo';

  @override
  String get enterFileName => 'Inserir nome do arquivo';

  @override
  String get filesDeleted => 'Arquivos excluídos';

  @override
  String get selectedFilesAreNotOnEnte =>
      'Os arquivos selecionados não estão no Ente';

  @override
  String get thisActionCannotBeUndone => 'Esta ação não pode ser desfeita';

  @override
  String get emptyTrash => 'Esvaziar a lixeira?';

  @override
  String get permDeleteWarning =>
      'Todos os itens na lixeira serão excluídos permanentemente\n\nEsta ação não pode ser desfeita';

  @override
  String get empty => 'Esvaziar';

  @override
  String get couldNotFreeUpSpace => 'Não foi possível liberar espaço';

  @override
  String get permanentlyDeleteFromDevice =>
      'Excluir permanentemente do dispositivo?';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      'Alguns dos arquivos que você está tentando excluir só estão disponíveis no seu dispositivo e não podem ser recuperados se forem excluídos';

  @override
  String get theyWillBeDeletedFromAllAlbums =>
      'Eles serão excluídos de todos os álbuns.';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'Alguns itens estão em ambos o Ente quanto no seu dispositivo.';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      'Os itens selecionados serão excluídos de todos os álbuns e movidos para a lixeira.';

  @override
  String get theseItemsWillBeDeletedFromYourDevice =>
      'Estes itens serão excluídos do seu dispositivo.';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      'Parece que algo deu errado. Tente novamente mais tarde. Caso o erro persistir, por favor, entre em contato com nossa equipe.';

  @override
  String get error => 'Erro';

  @override
  String get tempErrorContactSupportIfPersists =>
      'Parece que algo deu errado. Tente novamente mais tarde. Caso o erro persistir, por favor, entre em contato com nossa equipe.';

  @override
  String get networkHostLookUpErr =>
      'Não foi possível conectar-se ao Ente, verifique suas configurações de rede e entre em contato com o suporte se o erro persistir.';

  @override
  String get networkConnectionRefusedErr =>
      'Não foi possível conectar ao Ente, tente novamente mais tarde. Se o erro persistir, entre em contato com o suporte.';

  @override
  String get cachedData => 'Dados armazenados em cache';

  @override
  String get clearCaches => 'Limpar cache';

  @override
  String get remoteImages => 'Imagens remotas';

  @override
  String get remoteVideos => 'Vídeos remotos';

  @override
  String get remoteThumbnails => 'Miniaturas remotas';

  @override
  String get pendingSync => 'Sincronização pendente';

  @override
  String get localGallery => 'Galeria local';

  @override
  String get todaysLogs => 'Registros de hoje';

  @override
  String get viewLogs => 'Ver registros';

  @override
  String get logsDialogBody =>
      'Isso enviará através dos registros para ajudar-nos a resolver seu problema. Saiba que, nome de arquivos serão incluídos para ajudar a buscar problemas com arquivos específicos.';

  @override
  String get preparingLogs => 'Preparando registros...';

  @override
  String get emailYourLogs => 'Enviar registros por e-mail';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'Envie os registros para \n$toEmail';
  }

  @override
  String get copyEmailAddress => 'Copiar e-mail';

  @override
  String get exportLogs => 'Exportar registros';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return 'Envie-nos um e-mail para $toEmail';
  }

  @override
  String get dismiss => 'Descartar';

  @override
  String get didYouKnow => 'Você sabia?';

  @override
  String get loadingMessage => 'Carregando suas fotos...';

  @override
  String get loadMessage1 =>
      'Você pode compartilhar sua assinatura com seus familiares';

  @override
  String get loadMessage2 =>
      'Preservamos mais de 200 milhões de memórias até então';

  @override
  String get loadMessage3 =>
      'Mantemos 3 cópias dos seus dados, uma em um abrigo subterrâneo';

  @override
  String get loadMessage4 => 'Todos os nossos aplicativos são de código aberto';

  @override
  String get loadMessage5 =>
      'Nosso código-fonte e criptografia foram auditadas externamente';

  @override
  String get loadMessage6 =>
      'Você pode compartilhar links para seus álbuns com seus entes queridos';

  @override
  String get loadMessage7 =>
      'Nossos aplicativos móveis são executados em segundo plano para criptografar e salvar em segurança quaisquer fotos novas que você acessar';

  @override
  String get loadMessage8 => 'web.ente.io tem um enviador mais rápido';

  @override
  String get loadMessage9 =>
      'Nós usamos Xchacha20Poly1305 para criptografar seus dados com segurança';

  @override
  String get photoDescriptions => 'Descrições das fotos';

  @override
  String get fileTypesAndNames => 'Tipos de arquivo e nomes';

  @override
  String get location => 'Localização';

  @override
  String get moments => 'Momentos';

  @override
  String get searchFaceEmptySection =>
      'As pessoas apareceram aqui quando a indexação for concluída';

  @override
  String get searchDatesEmptySection => 'Buscar por data, mês ou ano';

  @override
  String get searchLocationEmptySection =>
      'Fotos de grupo que estão sendo tiradas em algum raio da foto';

  @override
  String get searchPeopleEmptySection =>
      'Convide pessoas e você verá todas as fotos compartilhadas por elas aqui';

  @override
  String get searchAlbumsEmptySection => 'Álbuns';

  @override
  String get searchFileTypesAndNamesEmptySection => 'Tipos de arquivo e nomes';

  @override
  String get searchCaptionEmptySection =>
      'Adicione marcações como \"#viagem\" nas informações das fotos para encontrá-las aqui com facilidade';

  @override
  String get language => 'Idioma';

  @override
  String get selectLanguage => 'Selecionar idioma';

  @override
  String get locationName => 'Nome da localização';

  @override
  String get addLocation => 'Adicionar localização';

  @override
  String get groupNearbyPhotos => 'Agrupar fotos próximas';

  @override
  String get kiloMeterUnit => 'km';

  @override
  String get addLocationButton => 'Adicionar';

  @override
  String get radius => 'Raio';

  @override
  String get locationTagFeatureDescription =>
      'Uma etiqueta de localização agrupa todas as fotos fotografadas em algum raio de uma foto';

  @override
  String get galleryMemoryLimitInfo => 'Até 1.000 memórias exibidas na galeria';

  @override
  String get save => 'Salvar';

  @override
  String get centerPoint => 'Ponto central';

  @override
  String get pickCenterPoint => 'Escolha o ponto central';

  @override
  String get useSelectedPhoto => 'Usar foto selecionada';

  @override
  String get resetToDefault => 'Redefinir para o padrão';

  @override
  String get edit => 'Editar';

  @override
  String get deleteLocation => 'Excluir localização';

  @override
  String get rotateLeft => 'Girar para a esquerda';

  @override
  String get flip => 'Inverter';

  @override
  String get rotateRight => 'Girar para a direita';

  @override
  String get saveCopy => 'Salvar cópia';

  @override
  String get light => 'Brilho';

  @override
  String get color => 'Cor';

  @override
  String get yesDiscardChanges => 'Sim, descartar alterações';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade =>
      'Você quer descartar as edições que você fez?';

  @override
  String get saving => 'Salvando...';

  @override
  String get editsSaved => 'Edições salvas';

  @override
  String get oopsCouldNotSaveEdits => 'Opa! Não foi possível salvar as edições';

  @override
  String get distanceInKMUnit => 'km';

  @override
  String get dayToday => 'Hoje';

  @override
  String get dayYesterday => 'Ontem';

  @override
  String get storage => 'Armazenamento';

  @override
  String get usedSpace => 'Espaço usado';

  @override
  String get storageBreakupFamily => 'Família';

  @override
  String get storageBreakupYou => 'Você';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return '$usedAmount $usedStorageUnit de $totalAmount $totalStorageUnit usado';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return '$freeAmount $storageUnit livre';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'Versão: $versionValue';
  }

  @override
  String get verifyIDLabel => 'Verificar';

  @override
  String get fileInfoAddDescHint => 'Adicionar descrição...';

  @override
  String get editLocationTagTitle => 'Editar localização';

  @override
  String get setLabel => 'Definir';

  @override
  String get setRadius => 'Definir raio';

  @override
  String get familyPlanPortalTitle => 'Família';

  @override
  String get familyPlanOverview =>
      'Adicione 5 familiares para seu plano existente sem pagar nenhum custo adicional.\n\nCada membro ganha seu espaço privado, significando que eles não podem ver os arquivos dos outros a menos que eles sejam compartilhados.\n\nOs planos familiares estão disponíveis para clientes que já tem uma assinatura paga do Ente.\n\nAssine agora para iniciar!';

  @override
  String get androidBiometricHint => 'Verificar identidade';

  @override
  String get androidBiometricNotRecognized =>
      'Não reconhecido. Tente novamente.';

  @override
  String get androidBiometricSuccess => 'Sucesso';

  @override
  String get androidCancelButton => 'Cancelar';

  @override
  String get androidSignInTitle => 'Autenticação necessária';

  @override
  String get androidBiometricRequiredTitle => 'Biométrica necessária';

  @override
  String get androidDeviceCredentialsRequiredTitle => 'Credenciais necessários';

  @override
  String get androidDeviceCredentialsSetupDescription =>
      'Credenciais necessários';

  @override
  String get goToSettings => 'Ir às opções';

  @override
  String get androidGoToSettingsDescription =>
      'A autenticação biométrica não está definida no dispositivo. Vá em \'Opções > Segurança\' para adicionar a autenticação biométrica.';

  @override
  String get iOSLockOut =>
      'A autenticação biométrica está desativada. Bloqueie e desbloqueie sua tela para ativá-la.';

  @override
  String get iOSGoToSettingsDescription =>
      'A autenticação biométrica não está definida no dispositivo. Ative o Touch ID ou Face ID no dispositivo.';

  @override
  String get iOSOkButton => 'OK';

  @override
  String get openstreetmapContributors => 'Contribuidores do OpenStreetMap';

  @override
  String get hostedAtOsmFrance => 'Hospedado em OSM France';

  @override
  String get map => 'Mapa';

  @override
  String get maps => 'Mapas';

  @override
  String get mapsPrivacyNotice =>
      'Coordenadas aproximadas serão enviadas a terceiros conscientes da privacidade, como o OpenStreetMap para mostrar o mapa e a localização.';

  @override
  String get enableMaps => 'Ativar mapas';

  @override
  String get quickLinks => 'Links rápidos';

  @override
  String get selectItemsToAdd => 'Selecionar itens para adicionar';

  @override
  String get addSelected => 'Adicionar selecionado';

  @override
  String get addFromDevice => 'Adicionar do dispositivo';

  @override
  String get addPhotos => 'Adicionar fotos';

  @override
  String get noPhotosFoundHere => 'Nenhuma foto encontrada aqui';

  @override
  String get zoomOutToSeePhotos => 'Reduzir ampliação para ver as fotos';

  @override
  String get noImagesWithLocation => 'Nenhuma imagem com localização';

  @override
  String get unpinAlbum => 'Desafixar álbum';

  @override
  String get pinAlbum => 'Fixar álbum';

  @override
  String get create => 'Criar';

  @override
  String get viewAll => 'Ver tudo';

  @override
  String get nothingSharedWithYouYet => 'Nada compartilhado com você ainda';

  @override
  String get noAlbumsSharedByYouYet =>
      'Nenhum álbum compartilhado por você ainda';

  @override
  String get sharedWithYou => 'Compartilhado com você';

  @override
  String get sharedByYou => 'Compartilhado por você';

  @override
  String get inviteYourFriendsToEnte => 'Convide seus amigos ao Ente';

  @override
  String get failedToDownloadVideo => 'Falhou ao baixar vídeo';

  @override
  String get hiding => 'Ocultando...';

  @override
  String get unhiding => 'Reexibindo...';

  @override
  String get successfullyHid => 'Ocultado com sucesso';

  @override
  String get successfullyUnhid => 'Desocultado com sucesso';

  @override
  String get crashReporting => 'Relatório de erros';

  @override
  String get resumableUploads => 'Envios retomáveis';

  @override
  String get addToHiddenAlbum => 'Adicionar ao álbum oculto';

  @override
  String get moveToHiddenAlbum => 'Mover ao álbum oculto';

  @override
  String get fileTypes => 'Tipos de arquivo';

  @override
  String get deleteConfirmDialogBody =>
      'Esta conta está vinculada aos outros aplicativos do Ente, se você usar algum. Seus dados baixados, entre todos os aplicativos do Ente, serão programados para exclusão, e sua conta será permanentemente excluída.';

  @override
  String get hearUsWhereTitle => 'Como você soube do Ente? (opcional)';

  @override
  String get hearUsExplanation =>
      'Não rastreamos instalações de aplicativo. Seria útil se você contasse onde nos encontrou!';

  @override
  String get viewAddOnButton => 'Ver complementos';

  @override
  String get addOns => 'Complementos';

  @override
  String get addOnPageSubtitle => 'Detalhes dos complementos';

  @override
  String get yourMap => 'Seu mapa';

  @override
  String get modifyYourQueryOrTrySearchingFor =>
      'Altere o termo de busca ou tente consultar';

  @override
  String get blackFridaySale => 'Promoção Black Friday';

  @override
  String get upto50OffUntil4thDec => 'Com 50% de desconto, até 4 de dezembro';

  @override
  String get photos => 'Fotos';

  @override
  String get videos => 'Vídeos';

  @override
  String get livePhotos => 'Fotos animadas';

  @override
  String get searchHint1 => 'busca rápida no dispositivo';

  @override
  String get searchHint2 => 'Descrições e data das fotos';

  @override
  String get searchHint3 => 'Álbuns, nomes de arquivos e tipos';

  @override
  String get searchHint4 => 'Localização';

  @override
  String get searchHint5 => 'Em breve: Busca mágica e rostos ✨';

  @override
  String get addYourPhotosNow => 'Adicione suas fotos agora';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count resultados encontrados',
      one: '$count resultado encontrado',
    );
    return '$_temp0';
  }

  @override
  String get faces => 'Rostos';

  @override
  String get people => 'Pessoas';

  @override
  String get contents => 'Conteúdos';

  @override
  String get addNew => 'Adicionar novo';

  @override
  String get contacts => 'Contatos';

  @override
  String get noInternetConnection => 'Sem conexão à internet';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'Verifique sua conexão com a internet e tente novamente.';

  @override
  String get signOutFromOtherDevices => 'Sair da conta em outros dispositivos';

  @override
  String get signOutOtherBody =>
      'Se você acha que alguém possa saber da sua senha, você pode forçar desconectar sua conta de outros dispositivos.';

  @override
  String get signOutOtherDevices => 'Sair em outros dispositivos';

  @override
  String get doNotSignOut => 'Não sair';

  @override
  String get editLocation => 'Editar localização';

  @override
  String get selectALocation => 'Selecionar localização';

  @override
  String get selectALocationFirst => 'Primeiramente selecione uma localização';

  @override
  String get changeLocationOfSelectedItems =>
      'Alterar a localização dos itens selecionados?';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte =>
      'Edições à localização serão apenas vistos no Ente';

  @override
  String get cleanUncategorized => 'Limpar não categorizado';

  @override
  String get cleanUncategorizedDescription =>
      'Remover todos os arquivos não categorizados que estão presentes em outros álbuns';

  @override
  String get waitingForVerification => 'Esperando verificação...';

  @override
  String get passkey => 'Chave de acesso';

  @override
  String get passkeyAuthTitle => 'Verificação de chave de acesso';

  @override
  String get loginWithTOTP => 'Registrar com TOTP';

  @override
  String get passKeyPendingVerification => 'Verificação pendente';

  @override
  String get loginSessionExpired => 'Sessão expirada';

  @override
  String get loginSessionExpiredDetails =>
      'Sua sessão expirou. Registre-se novamente.';

  @override
  String get verifyPasskey => 'Verificar chave de acesso';

  @override
  String get playOnTv => 'Reproduzir álbum na TV';

  @override
  String get pair => 'Parear';

  @override
  String get deviceNotFound => 'Dispositivo não encontrado';

  @override
  String get castInstruction =>
      'Acesse cast.ente.io no dispositivo desejado para parear.\n\nInsira o código abaixo para reproduzir o álbum na sua TV.';

  @override
  String get deviceCodeHint => 'Insira o código';

  @override
  String get joinDiscord => 'Junte-se ao Discord';

  @override
  String get locations => 'Localizações';

  @override
  String get addAName => 'Adicione um nome';

  @override
  String get findThemQuickly => 'Busque-os rapidamente';

  @override
  String get findPeopleByName => 'Busque pessoas facilmente pelo nome';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Adicionar vizualizadores',
      one: 'Adicionar visualizador',
      zero: 'Adicionar visualizador',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Adicionar colaboradores',
      one: 'Adicionar colaborador',
      zero: 'Adicionar colaborador',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      'Pressione um e-mail para verificar a criptografia ponta a ponta.';

  @override
  String get developerSettingsWarning =>
      'Deseja modificar as Opções de Desenvolvedor?';

  @override
  String get developerSettings => 'Opções de desenvolvedor';

  @override
  String get serverEndpoint => 'Ponto final do servidor';

  @override
  String get invalidEndpoint => 'Ponto final inválido';

  @override
  String get invalidEndpointMessage =>
      'Desculpe, o ponto final inserido é inválido. Insira um ponto final válido e tente novamente.';

  @override
  String get endpointUpdatedMessage => 'Ponto final atualizado com sucesso';

  @override
  String customEndpoint({required Object endpoint}) {
    return 'Conectado à $endpoint';
  }

  @override
  String get createCollaborativeLink => 'Criar link colaborativo';

  @override
  String get search => 'Buscar';

  @override
  String get enterPersonName => 'Inserir nome da pessoa';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'Este e-mail já está vinculado a $name.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return 'Visualizar $name para desvincular';
  }

  @override
  String get enterName => 'Inserir nome';

  @override
  String get savePerson => 'Salvar pessoa';

  @override
  String get editPerson => 'Editar pessoa';

  @override
  String get mergedPhotos => 'Fotos mescladas';

  @override
  String get orMergeWithExistingPerson => 'Ou mesclar com existente';

  @override
  String get enterDateOfBirth => 'Aniversário (opcional)';

  @override
  String get birthday => 'Aniversário';

  @override
  String get removePersonLabel => 'Remover etiqueta da pessoa';

  @override
  String get autoPairDesc =>
      'O pareamento automático só funciona com dispositivos que suportam o Chromecast.';

  @override
  String get manualPairDesc =>
      'Parear com PIN funciona com qualquer tela que queira visualizar seu álbum.';

  @override
  String get connectToDevice => 'Conectar ao dispositivo';

  @override
  String get autoCastDialogBody =>
      'Você verá dispositivos de transmissão disponível aqui.';

  @override
  String get autoCastiOSPermission =>
      'Certifique-se que as permissões da internet local estejam ligadas para o Ente Photos App, em opções.';

  @override
  String get noDeviceFound => 'Nenhum dispositivo encontrado';

  @override
  String get stopCastingTitle => 'Parar transmissão';

  @override
  String get stopCastingBody => 'Deseja parar a transmissão?';

  @override
  String get castIPMismatchTitle => 'Falhou ao transmitir álbum';

  @override
  String get castIPMismatchBody =>
      'Certifique-se de estar na mesma internet que a TV.';

  @override
  String get pairingComplete => 'Pareamento concluído';

  @override
  String get savingEdits => 'Salvando edições...';

  @override
  String get autoPair => 'Pareamento automático';

  @override
  String get pairWithPin => 'Parear com PIN';

  @override
  String get faceRecognition => 'Reconhecimento facial';

  @override
  String get foundFaces => 'Rostos encontrados';

  @override
  String get clusteringProgress => 'Progresso de agrupamento';

  @override
  String get trim => 'Recortar';

  @override
  String get crop => 'Cortar';

  @override
  String get rotate => 'Girar';

  @override
  String get left => 'Esquerda';

  @override
  String get right => 'Direita';

  @override
  String get whatsNew => 'O que há de novo';

  @override
  String get reviewSuggestions => 'Revisar sugestões';

  @override
  String get review => 'Revisar';

  @override
  String get useAsCover => 'Usar como capa';

  @override
  String notPersonLabel({required String name}) {
    return 'Não é $name?';
  }

  @override
  String get enable => 'Ativar';

  @override
  String get enabled => 'Ativado';

  @override
  String get moreDetails => 'Mais detalhes';

  @override
  String get enableMLIndexingDesc =>
      'Ente fornece aprendizado automático no dispositivo para reconhecimento facial, busca mágica e outros recursos de busca avançados.';

  @override
  String get magicSearchHint =>
      'A busca mágica permite buscar fotos pelo conteúdo, p. e.x. \'flor\', \'carro vermelho\', \'identidade\'';

  @override
  String get panorama => 'Panorama';

  @override
  String get reenterPassword => 'Reinserir senha';

  @override
  String get reenterPin => 'Reinserir PIN';

  @override
  String get deviceLock => 'Bloqueio do dispositivo';

  @override
  String get pinLock => 'Bloqueio por PIN';

  @override
  String get next => 'Próximo';

  @override
  String get setNewPassword => 'Definir nova senha';

  @override
  String get enterPin => 'Inserir PIN';

  @override
  String get setNewPin => 'Definir PIN novo';

  @override
  String get appLock => 'Bloqueio do aplicativo';

  @override
  String get noSystemLockFound => 'Nenhum bloqueio do sistema encontrado';

  @override
  String get tapToUnlock => 'Toque para desbloquear';

  @override
  String get tooManyIncorrectAttempts => 'Muitas tentativas incorretas';

  @override
  String get videoInfo => 'Informações do vídeo';

  @override
  String get autoLock => 'Bloqueio automático';

  @override
  String get immediately => 'Imediatamente';

  @override
  String get autoLockFeatureDescription =>
      'Tempo após o qual o aplicativo bloqueia após ser colocado em segundo plano';

  @override
  String get hideContent => 'Ocultar conteúdo';

  @override
  String get hideContentDescriptionAndroid =>
      'Oculta os conteúdos do aplicativo no seletor de aplicativos e desativa capturas de tela';

  @override
  String get hideContentDescriptionIos =>
      'Oculta o conteúdo no seletor de aplicativos';

  @override
  String get passwordStrengthInfo =>
      'A força da senha é calculada considerando o comprimento dos dígitos, carácteres usados, e se ou não a senha aparece nas 10.000 senhas usadas.';

  @override
  String get noQuickLinksSelected => 'Nenhum link rápido selecionado';

  @override
  String get pleaseSelectQuickLinksToRemove =>
      'Selecione links rápidos para remover';

  @override
  String get removePublicLinks => 'Remover link público';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      'Isto removerá links públicos de todos os links rápidos selecionados.';

  @override
  String get guestView => 'Vista do convidado';

  @override
  String get guestViewEnablePreSteps =>
      'Para ativar a vista do convidado, defina uma senha de acesso no dispositivo ou bloqueie sua tela nas opções do sistema.';

  @override
  String get nameTheAlbum => 'Nomear álbum';

  @override
  String get collectPhotosDescription =>
      'Crie um link onde seus amigos podem enviar fotos na qualidade original.';

  @override
  String get collect => 'Coletar';

  @override
  String get appLockDescriptions =>
      'Escolha entre a tela de bloqueio padrão do seu dispositivo e uma tela de bloqueio personalizada com PIN ou senha.';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'Para ativar o bloqueio do aplicativo, defina uma senha de acesso no dispositivo ou bloqueie sua tela nas opções do sistema.';

  @override
  String get authToViewPasskey => 'Autentique-se para ver sua chave de acesso';

  @override
  String get localSyncErrorMessage =>
      'Ocorreu um erro devido à sincronização de localização das fotos estar levando mais tempo que o esperado. Entre em contato conosco.';

  @override
  String get showPerson => 'Mostrar pessoa';

  @override
  String get sort => 'Ordenar';

  @override
  String get mostRecent => 'Mais recente';

  @override
  String get mostRelevant => 'Mais relevante';

  @override
  String get loadingYourPhotos => 'Carregando suas fotos...';

  @override
  String processingImport({required Object folderName}) {
    return 'Processando $folderName...';
  }

  @override
  String get personName => 'Nome da pessoa';

  @override
  String get addNewPerson => 'Adicionar nova pessoa';

  @override
  String get addNameOrMerge => 'Adicionar nome ou juntar';

  @override
  String get mergeWithExisting => 'Juntar com o existente';

  @override
  String get newPerson => 'Nova pessoa';

  @override
  String get addName => 'Adicionar pessoa';

  @override
  String get add => 'Adicionar';

  @override
  String extraPhotosFoundFor({required String text}) {
    return 'Fotos adicionais encontradas para $text';
  }

  @override
  String get extraPhotosFound => 'Fotos adicionais encontradas';

  @override
  String get configuration => 'Configuração';

  @override
  String get localIndexing => 'Indexação local';

  @override
  String get processed => 'Processado(s)';

  @override
  String get resetPerson => 'Remover';

  @override
  String get areYouSureYouWantToResetThisPerson =>
      'Deseja redefinir esta pessoa?';

  @override
  String get allPersonGroupingWillReset =>
      'Todos os agrupamentos dessa pessoa serão redefinidos, e você perderá todas as sugestões feitas por essa pessoa.';

  @override
  String get yesResetPerson => 'Sim, redefinir pessoa';

  @override
  String get onlyThem => 'Apenas ele';

  @override
  String get checkingModels => 'Verificando modelos...';

  @override
  String get enableMachineLearningBanner =>
      'Ativar o aprendizado automático para busca mágica e reconhecimento facial';

  @override
  String get searchDiscoverEmptySection =>
      'As imagens serão exibidas aqui quando o processamento e sincronização for concluído';

  @override
  String get searchPersonsEmptySection =>
      'As pessoas serão exibidas aqui quando o processamento e sincronização for concluído';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Adicionado $count visualizadores',
      one: 'Adicionado 1 visualizador',
      zero: 'Adicionado 0 vizualizadores',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Adicionado $count colaboradores',
      one: 'Adicionado 1 colaborador',
      zero: 'Adicionado 0 colaboradores',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured => 'A conta já está configurada.';

  @override
  String get sessionIdMismatch => 'Incompatibilidade de ID de sessão';

  @override
  String get failedToFetchActiveSessions => 'Falhou ao obter sessões ativas';

  @override
  String get failedToRefreshStripeSubscription =>
      'Falhou ao atualizar assinatura';

  @override
  String get failedToPlayVideo => 'Falhou ao reproduzir vídeo';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return 'O envio é ignorado devido a $ignoreReason';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'O tipo de galeria $galleryType não é suportado para renomear';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'Toque para enviar, atualmente o envio é ignorado devido a $ignoreReason';
  }

  @override
  String get tapToUpload => 'Toque para enviar';

  @override
  String get info => 'Info';

  @override
  String get addFiles => 'Adicionar arquivos';

  @override
  String get castAlbum => 'Transferir álbum';

  @override
  String get imageNotAnalyzed => 'Imagem não analisada';

  @override
  String get noFacesFound => 'Nenhum rosto encontrado';

  @override
  String get fileNotUploadedYet => 'Arquivo ainda não enviado';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return 'Sem sugestões para $personName';
  }

  @override
  String get month => 'mês';

  @override
  String get yearShort => 'ano';

  @override
  String get currentlyRunning => 'Atualmente executando';

  @override
  String get ignored => 'ignorado';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count fotos',
      one: '1 foto',
      zero: '0 fotos',
    );
    return '$_temp0';
  }

  @override
  String get file => 'Arquivo';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'Incompatibilidade de comprimento de seções: $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'Selecionar aplicativo de e-mail';

  @override
  String get selectAllShort => 'Tudo';

  @override
  String get selectCoverPhoto => 'Selecionar foto da capa';

  @override
  String get newLocation => 'Nova localização';

  @override
  String get faceNotClusteredYet =>
      'Rosto não agrupado ainda, volte aqui mais tarde';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'O link que você está tentando acessar já expirou.';

  @override
  String get openFile => 'Abrir arquivo';

  @override
  String get backupFile => 'Salvar arquivo em segurança';

  @override
  String get openAlbumInBrowser => 'Abrir álbum no navegador';

  @override
  String get openAlbumInBrowserTitle =>
      'Use o aplicativo da web para adicionar fotos a este álbum';

  @override
  String get allow => 'Permitir';

  @override
  String get allowAppToOpenSharedAlbumLinks =>
      'Permitir aplicativo abrir links de álbum compartilhado';

  @override
  String get seePublicAlbumLinksInApp =>
      'Ver links de álbum compartilhado no aplicativo';

  @override
  String get emergencyContacts => 'Contatos de emergência';

  @override
  String get acceptTrustInvite => 'Aceitar convite';

  @override
  String get declineTrustInvite => 'Recusar convite';

  @override
  String get removeYourselfAsTrustedContact =>
      'Remover si mesmo dos contatos confiáveis';

  @override
  String get legacy => 'Legado';

  @override
  String get legacyPageDesc =>
      'O legado permite que contatos confiáveis acessem sua conta em sua ausência.';

  @override
  String get legacyPageDesc2 =>
      'Contatos confiáveis podem iniciar recuperação de conta. Se não cancelado dentro de 30 dias, redefina sua senha e acesse sua conta.';

  @override
  String get legacyAccounts => 'Contas legadas';

  @override
  String get trustedContacts => 'Contatos confiáveis';

  @override
  String get addTrustedContact => 'Adicionar contato confiável';

  @override
  String get removeInvite => 'Remover convite';

  @override
  String get recoveryWarning =>
      'Um contato confiável está tentando acessar sua conta';

  @override
  String get rejectRecovery => 'Rejeitar recuperação';

  @override
  String get recoveryInitiated => 'A recuperação iniciou';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return 'Você poderá acessar a conta após $days dias.  Uma notificação será enviada para $email.';
  }

  @override
  String get cancelAccountRecovery => 'Cancelar recuperação';

  @override
  String get recoveryAccount => 'Recuperar conta';

  @override
  String get cancelAccountRecoveryBody =>
      'Deseja mesmo cancelar a recuperação de conta?';

  @override
  String get startAccountRecoveryTitle => 'Iniciar recuperação';

  @override
  String get whyAddTrustContact =>
      'Um contato confiável pode ajudá-lo em recuperar seus dados.';

  @override
  String recoveryReady({required String email}) {
    return 'Você pode recuperar a conta com e-mail $email por definir uma nova senha.';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email está tentando recuperar sua conta.';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return 'Você foi convidado para ser um contato legado por $email.';
  }

  @override
  String get warning => 'Aviso';

  @override
  String get proceed => 'Continuar';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return 'Você está prestes a adicionar $email como contato confiável. Eles poderão recuperar sua conta se você estiver ausente por $numOfDays dias.';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email convidou você para ser um contato confiável';
  }

  @override
  String get authToManageLegacy =>
      'Autentique-se para gerenciar seus contatos confiáveis';

  @override
  String get hideSharedItemsFromHomeGallery =>
      'Ocultar itens compartilhados da galeria inicial';

  @override
  String get gallery => 'Galeria';

  @override
  String get joinAlbum => 'Unir-se ao álbum';

  @override
  String get joinAlbumSubtext => 'para visualizar e adicionar suas fotos';

  @override
  String get joinAlbumSubtextViewer =>
      'para adicionar isso aos álbuns compartilhados';

  @override
  String get join => 'Unir-se';

  @override
  String get linkEmail => 'Vincular e-mail';

  @override
  String get link => 'Vincular';

  @override
  String get noEnteAccountExclamation => 'Nenhuma conta Ente!';

  @override
  String get orPickFromYourContacts => 'ou escolher dos seus contatos';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return '$email não possui uma conta Ente.';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (Eu)';
  }

  @override
  String get reassignMe => 'Reatribuir \"Eu\"';

  @override
  String get me => 'Eu';

  @override
  String get linkEmailToContactBannerCaption => 'para compartilhar rápido';

  @override
  String get selectPersonToLink => 'Selecione a pessoa para vincular';

  @override
  String linkPersonToEmail({required String email}) {
    return 'Vincular pessoa a $email';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return 'Isso vinculará $personName a $email';
  }

  @override
  String get selectYourFace => 'Selecione seu rosto';

  @override
  String get reassigningLoading => 'Reatribuindo...';

  @override
  String reassignedToName({required String name}) {
    return 'Atribuído a $name';
  }

  @override
  String get saveChangesBeforeLeavingQuestion =>
      'Salvar mudanças antes de sair?';

  @override
  String get dontSave => 'Não salvar';

  @override
  String get thisIsMeExclamation => 'Este é você!';

  @override
  String get linkPerson => 'Vincular pessoa';

  @override
  String get linkPersonCaption => 'para melhorar o compartilhamento';

  @override
  String get videoStreaming => 'Vídeos transmissíveis';

  @override
  String get processingVideos => 'Processando vídeos';

  @override
  String get streamDetails => 'Detalhes da transmissão';

  @override
  String get processing => 'Processando';

  @override
  String get queued => 'Na fila';

  @override
  String get ineligible => 'Inelegível';

  @override
  String get failed => 'Falhou';

  @override
  String get playStream => 'Reproduzir transmissão';

  @override
  String get playOriginal => 'Reproduzir original';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'Unir-se ao álbum fará que seu e-mail seja visível a todos do álbum.';

  @override
  String get pleaseWaitThisWillTakeAWhile =>
      'Aguarde um pouco, isso talvez leve um tempo.';

  @override
  String get editTime => 'Editar tempo';

  @override
  String get selectTime => 'Selecionar tempo';

  @override
  String get selectDate => 'Selecionar data';

  @override
  String get previous => 'Anterior';

  @override
  String get selectOneDateAndTimeForAll =>
      'Selecione uma data e hora para todos';

  @override
  String get selectStartOfRange => 'Selecionar início de intervalo';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      'Isso fará que a data e hora de todas as fotos selecionadas fiquem iguais.';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'Este é o primeiro do grupo. As outras fotos selecionadas serão automaticamente alteradas para esta nova data';

  @override
  String get newRange => 'Novo intervalo';

  @override
  String get selectOneDateAndTime => 'Selecionar data e hora';

  @override
  String get moveSelectedPhotosToOneDate =>
      'Mover fotos selecionadas para uma data';

  @override
  String get shiftDatesAndTime => 'Alterar as datas e horas';

  @override
  String get photosKeepRelativeTimeDifference =>
      'As fotos mantêm a diferença de tempo relativo';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count fotos',
      one: '1 foto',
      zero: 'Sem fotos',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'Ícone do aplicativo';

  @override
  String get notThisPerson => 'Não é esta pessoa?';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      'Os itens selecionados serão removidos desta pessoa, entretanto não serão excluídos da sua biblioteca.';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat com o passar dos anos';
  }

  @override
  String get thisWeekThroughTheYears => 'Esta semana com o passar dos anos';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Esta semana, $count anos atrás',
      one: 'Esta semana, $count ano atrás',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'Você e $name';
  }

  @override
  String admiringThem({required Object name}) {
    return 'Admirando $name';
  }

  @override
  String embracingThem({required Object name}) {
    return 'Abraçando $name';
  }

  @override
  String partyWithThem({required Object name}) {
    return 'Festejando com $name';
  }

  @override
  String hikingWithThem({required Object name}) {
    return 'Caminhando com $name';
  }

  @override
  String feastingWithThem({required Object name}) {
    return 'Tendo banquete com $name';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return 'Tirando selfies com $name';
  }

  @override
  String posingWithThem({required Object name}) {
    return 'Fazendo pose com $name';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return 'Vistas bonitas com $name';
  }

  @override
  String sportsWithThem({required Object name}) {
    return 'Jogando esportes com $name';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return 'Viajando de carro com $name';
  }

  @override
  String get spotlightOnYourself => 'Seus destaques';

  @override
  String spotlightOnThem({required Object name}) {
    return 'Destaques em $name';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$name tem $age anos!';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name terá $age em breve';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return 'Últimos momentos com $name';
  }

  @override
  String tripToLocation({required Object location}) {
    return 'Viajem à $location';
  }

  @override
  String tripInYear({required Object year}) {
    return 'Viajem em $year';
  }

  @override
  String get lastYearsTrip => 'Viajem do ano passado';

  @override
  String get sunrise => 'No horizonte';

  @override
  String get mountains => 'Sob as montanhas';

  @override
  String get greenery => 'A vegetação verde';

  @override
  String get beach => 'Areia e o mar';

  @override
  String get city => 'Na cidade';

  @override
  String get moon => 'Na luz do luar';

  @override
  String get onTheRoad => 'Na estrada novamente';

  @override
  String get food => 'Delícias de cozinha';

  @override
  String get pets => 'Companhias peludas';

  @override
  String get curatedMemories => 'Memórias restauradas';

  @override
  String get widgets => 'Widgets';

  @override
  String get memories => 'Memórias';

  @override
  String get peopleWidgetDesc =>
      'Selecione as pessoas que deseje vê-las na sua tela inicial.';

  @override
  String get albumsWidgetDesc =>
      'Selecione os álbuns que deseje vê-los na sua tela inicial.';

  @override
  String get memoriesWidgetDesc =>
      'Selecione os tipos de memórias que deseje vê-las na sua tela inicial.';

  @override
  String get smartMemories => 'Memórias inteligentes';

  @override
  String get pastYearsMemories => 'Memórias dos anos passados';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return 'E também excluir todas as fotos (e vídeos) presente dentro desses $count álbuns e de <bold>todos</bold> os álbuns que eles fazem parte?';
  }

  @override
  String get addParticipants => 'Adicionar participante';

  @override
  String selectedAlbums({required Object count}) {
    return '$count selecionado(s)';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'Ação não suportada em álbum favorito';

  @override
  String get onThisDayMemories => 'Memórias deste dia';

  @override
  String get onThisDay => 'Neste dia';

  @override
  String get lookBackOnYourMemories => 'Revise suas memórias 🌄';

  @override
  String get newPhotosEmoji => ' novo 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'Desculpe, tivemos que pausar os salvamentos em segurança';

  @override
  String get clickToInstallOurBestVersionYet =>
      'Clique para instalar a nossa melhor versão até então';

  @override
  String get onThisDayNotificationExplanation =>
      'Receba lembretes de memórias deste dia em anos passados.';

  @override
  String get addMemoriesWidgetPrompt =>
      'Adicione um widget de memória a sua tela inicial e volte aqui para personalizar.';

  @override
  String get addAlbumWidgetPrompt =>
      'Adicione um widget de álbum a sua tela inicial e volte aqui para personalizar.';

  @override
  String get addPeopleWidgetPrompt =>
      'Adicione um widget de pessoas a sua tela inicial e volte aqui para personalizar.';

  @override
  String get birthdayNotifications => 'Notificações de aniversário';

  @override
  String get receiveRemindersOnBirthdays =>
      'Receba notificações quando alguém fizer um aniversário. Tocar na notificação o levará às fotos do aniversariante.';

  @override
  String get happyBirthday => 'Feliz aniversário! 🥳';

  @override
  String get birthdays => 'Aniversários';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return 'Deseje um feliz aniversário a $name! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      'Deseja mesmo remover o rosto desta pessoa?';

  @override
  String get otherDetectedFaces => 'Outros rostos detectados';

  @override
  String get areThey => 'Eles são ';

  @override
  String get questionmark => '?';

  @override
  String get saveAsAnotherPerson => 'Salvar como outra pessoa';

  @override
  String get showLessFaces => 'Exibir menos rostos';

  @override
  String get showMoreFaces => 'Exibir mais rostos';

  @override
  String get ignore => 'Ignorar';

  @override
  String get merge => 'Mesclar';

  @override
  String get reset => 'Redefinir';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      'Você deseja mesmo ignorar esta pessoa?';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      'Você deseja mesmo ignorar estas pessoas?';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'Os grupos de pessoa não serão exibidos na seção de pessoa. As fotos permanecerão intactas.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'A pessoa não será exibida na seção de pessoas. As fotos permanecerão intactas.';

  @override
  String get areYouSureYouWantToMergeThem => 'Você desejar mesmo mesclá-los?';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'Todos os grupos sem nome serão mesclados numa pessoa selecionada. Isso ainda pode ser desfeito no histórico de sugestões da pessoa.';

  @override
  String get yesIgnore => 'Sim, ignorar';

  @override
  String get same => 'Igual';

  @override
  String get different => 'Diferente';

  @override
  String get sameperson => 'Mesma pessoa?';

  @override
  String get indexingPausedStatusDescription =>
      'A indexação foi pausada. Ela retomará automaticamente quando o dispositivo estiver pronto. O dispositivo é considerado pronto quando o nível de bateria, saúde da bateria, e estado térmico estejam num alcance saudável.';

  @override
  String get thisWeek => 'Esta semana';

  @override
  String get lastWeek => 'Semana passada';

  @override
  String get thisMonth => 'Este mês';

  @override
  String get thisYear => 'Este ano';

  @override
  String get groupBy => 'Agrupar por';

  @override
  String get faceThumbnailGenerationFailed =>
      'Incapaz de gerar miniaturas de rosto';

  @override
  String get fileAnalysisFailed => 'Incapaz de analisar rosto';

  @override
  String get editAutoAddPeople => 'Editar adição automática de pessoas';

  @override
  String get autoAddPeople => 'Adicionar pessoas auto.';

  @override
  String get autoAddToAlbum => 'Adicionar ao álbum auto.';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      'Deveria excluir os arquivos relacionados à pessoa anteriormente selecionada nos álbuns inteligentes?';

  @override
  String get addingPhotos => 'Adicionando fotos';

  @override
  String get gettingReady => 'Preparando';

  @override
  String get addSomePhotosDesc1 => 'Adicione algumas fotos ou selecione ';

  @override
  String get addSomePhotosDesc2 => 'rostos familiares';

  @override
  String get addSomePhotosDesc3 => 'para iniciar com';

  @override
  String get ignorePerson => 'Ignorar pessoa';

  @override
  String get mixedGrouping => 'Agrupamento mesclado?';

  @override
  String get analysis => 'Análise';

  @override
  String get doesGroupContainMultiplePeople =>
      'O agrupamento possui várias pessoas?';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'Determinaremos automaticamente o agrupamento para saber se há várias pessoas presentes, e separá-las novamente. Isso deve levar alguns segundos.';

  @override
  String get layout => 'Layout';

  @override
  String get day => 'Dia';

  @override
  String get undo => ' Desfazer ';

  @override
  String get redo => 'Refazer';

  @override
  String get filter => 'Filtrar';

  @override
  String get adjust => 'Ajuste';

  @override
  String get draw => 'Desenho';

  @override
  String get sticker => 'Figurinha';

  @override
  String get brushColor => 'Cor do pincel';

  @override
  String get font => 'Fonte';

  @override
  String get background => 'Fundo';

  @override
  String get align => 'Alinhar';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Adicionado com sucesso a $count álbuns',
      one: 'Adicionado com sucesso a 1 álbum',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => 'Vídeos processados';

  @override
  String get totalVideos => 'Total de vídeos';

  @override
  String get skippedVideos => 'Vídeos ignorados';

  @override
  String get videoStreamingDescriptionLine1 =>
      'Reproduzir vídeos instantaneamente em qualquer dispositivo.';

  @override
  String get videoStreamingDescriptionLine2 =>
      'Ative para processar fluxos de vídeo neste dispositivo.';

  @override
  String get videoStreamingNote =>
      'Apenas vídeos dos últimos 60 dias e menos de 1 minuto são processados neste dispositivo. Para vídeos mais antigos/mais longos, habilite a transmissão no aplicativo da área de trabalho.';

  @override
  String get createStream => 'Criar fluxo';

  @override
  String get recreateStream => 'Criar fluxo';

  @override
  String get addedToStreamCreationQueue =>
      'Adicionado à fila de criação do stream';

  @override
  String get addedToStreamRecreationQueue =>
      'Adicionado à fila de recriação do stream';

  @override
  String get videoPreviewAlreadyExists => 'Pré-visualização de vídeo já existe';

  @override
  String get videoAlreadyInQueue => 'Arquivo de vídeo já presente na fila';

  @override
  String get addedToQueue => 'Adicionado à fila:';

  @override
  String get creatingStream => 'Criando fluxo';

  @override
  String get similarImages => 'Imagens similares';

  @override
  String get findSimilarImages => 'Encontrar imagens semelhantes';

  @override
  String get noSimilarImagesFound => 'Nenhuma imagem semelhante encontrada';

  @override
  String get yourPhotosLookUnique => 'Suas fotos parecem únicas';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count resultados encontrados',
      one: '$count resultado encontrado',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages =>
      'Revisar e remover imagens semelhantes';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return 'Excluir $count fotos ($size)';
  }

  @override
  String get selectionOptions => 'Opções de seleção';

  @override
  String selectExactWithCount({required int count}) {
    return 'Exatamente semelhante ($count)';
  }

  @override
  String get selectExact => 'Selecione exato';

  @override
  String selectSimilarWithCount({required int count}) {
    return 'Quase semelhante ($count)';
  }

  @override
  String get selectSimilar => 'Selecionar similares';

  @override
  String selectAllWithCount({required int count}) {
    return 'Todas as semelhanças ($count)';
  }

  @override
  String get selectSimilarImagesTitle => 'Selecione imagens similares';

  @override
  String get chooseSimilarImagesToSelect =>
      'Selecionar imagens baseadas em sua semelhança visual';

  @override
  String get clearSelection => 'Limpar seleção';

  @override
  String similarImagesCount({required int count}) {
    return '$count imagens semelhantes';
  }

  @override
  String deleteWithCount({required int count}) {
    return 'Excluir ($count)';
  }

  @override
  String get deleteFiles => 'Excluir arquivos';

  @override
  String get areYouSureDeleteFiles =>
      'Você tem certeza que deseja excluir estes arquivos?';

  @override
  String get greatJob => 'Bom trabalho!';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return 'Você liberou $size de espaço';
  }

  @override
  String get size => 'Tamanho';

  @override
  String get similarity => 'Similaridade';

  @override
  String get analyzingPhotosLocally => 'Analisando suas fotos localmente...';

  @override
  String get lookingForVisualSimilarities =>
      'Procurando por semelhanças visuais...';

  @override
  String get comparingImageDetails => 'Comparando detalhes da imagem...';

  @override
  String get findingSimilarImages => 'Encontrando imagens semelhantes...';

  @override
  String get almostDone => 'Quase lá...';

  @override
  String get processingLocally => 'Processando localmente';

  @override
  String get useMLToFindSimilarImages =>
      'Revise e remova imagens que pareçam semelhantes entre si.';

  @override
  String get all => 'Todos';

  @override
  String get similar => 'Parecido';

  @override
  String get identical => 'Idêntico';

  @override
  String get nothingHereTryAnotherFilter => 'Nada aqui, tente outro filtro! 👀';

  @override
  String get related => 'Relacionado';

  @override
  String get hoorayyyy => 'Uuhuuuulll!';

  @override
  String get nothingToTidyUpHere => 'Nada para arrumar aqui';

  @override
  String get deletingDash => 'Apagando - ';

  @override
  String get cLTitle3 => 'Novas recordações';

  @override
  String get cLDesc3 =>
      '“Crianças brincalhonas”, “Aventuras de inverno”, “Noites neon” e muito mais.';

  @override
  String get cLTitle4 => 'Galeria de paisagens e muito mais';

  @override
  String get cLDesc4 =>
      'Suporte para layout paisagem na galeria principal do aplicativo. Mostrar pessoas sem fotos associadas em vez de filtrá-las. Melhorar a detecção do aspecto do vídeo quando compartilhado a partir de aplicativos externos.';

  @override
  String get closeBy => 'Parecida';

  @override
  String get peopleAutoAddDesc =>
      'Adicionar automaticamente fotos das pessoas selecionadas a este álbum';

  @override
  String get festivities => 'Alegria festiva';

  @override
  String get snowAdventures => 'Aventuras de inverno';

  @override
  String get waterfalls => 'Em busca de cachoeiras';

  @override
  String get wildlife => 'Na natureza';

  @override
  String get flowers => 'Belezas em flor';

  @override
  String get nightLights => 'Noites de néon';

  @override
  String get architecture => 'Ícones do design';

  @override
  String get autumnColors => 'Esplendor do outono';

  @override
  String get desertDreams => 'Sonhos do deserto';

  @override
  String get stargazing => 'Sob as estrelas';

  @override
  String get lakeside => 'Calma à beira do lago';

  @override
  String get rainyDays => 'Sensação de dia chuvoso';

  @override
  String get sportsAction => 'Começa o jogo';

  @override
  String get streetArt => 'Histórias da arte de rua';

  @override
  String get familyMoments => 'Tempo com a família';

  @override
  String get fireworks => 'Fim com fogos de artifício';

  @override
  String get historicSites => 'Ecos da história';

  @override
  String get tropicalParadise => 'Escapadas tropicais';

  @override
  String get forestTrails => 'Passeios pela floresta';

  @override
  String get citySunsets => 'Brilho do pôr do sol na cidade';

  @override
  String get colorfulMarkets => 'Mercados vibrantes';

  @override
  String get cozyCafes => 'Cantinhos aconchegantes em cafés';

  @override
  String get vintageVibes => 'Vibrações vintage';

  @override
  String get aerialViews => 'Perspectivas aéreas';

  @override
  String get artisticPortraits => 'Retratos artísticos';

  @override
  String get streetFood => 'Petiscos de rua';

  @override
  String get riverCruises => 'Vistas do cruzeiro fluvial';

  @override
  String get playfulKids => 'Crianças brincalhonas';

  @override
  String get coastalCliffs => 'Penhascos à beira-mar';
}

/// The translations for Portuguese, as used in Portugal (`pt_PT`).
class AppLocalizationsPtPt extends AppLocalizationsPt {
  AppLocalizationsPtPt() : super('pt_PT');

  @override
  String get enterYourEmailAddress => 'Introduza o seu e-mail';

  @override
  String get enterYourNewEmailAddress => 'Introduza o seu novo e-mail';

  @override
  String get accountWelcomeBack => 'Boas-vindas de volta!';

  @override
  String get emailAlreadyRegistered => 'E-mail já em utilização.';

  @override
  String get emailNotRegistered => 'E-mail não em utilização.';

  @override
  String get email => 'E-mail';

  @override
  String get cancel => 'Cancelar';

  @override
  String get verify => 'Verificar';

  @override
  String get invalidEmailAddress => 'E-mail inválido';

  @override
  String get enterValidEmail => 'Favor, introduz um e-mail válido.';

  @override
  String get deleteAccount => 'Eliminar conta';

  @override
  String get askDeleteReason => 'Por que quer eliminar a sua conta?';

  @override
  String get deleteAccountFeedbackPrompt =>
      'Lamentável a sua ida. Favor, partilhe o seu comentário para ajudar-nos a aprimorar.';

  @override
  String get feedback => 'Comentário';

  @override
  String get kindlyHelpUsWithThisInformation => 'Ajude-nos com esta informação';

  @override
  String get confirmDeletePrompt =>
      'Sim, quero permanentemente eliminar esta conta com os dados.';

  @override
  String get confirmAccountDeletion => 'Eliminar Conta';

  @override
  String get deleteAccountPermanentlyButton => 'Eliminar Conta Permanentemente';

  @override
  String get yourAccountHasBeenDeleted => 'A sua conta foi eliminada';

  @override
  String get selectReason => 'Diz a razão';

  @override
  String get deleteReason1 => 'Necessita uma funcionalidade-chave que quero';

  @override
  String get deleteReason2 =>
      'A aplicação ou certa funcionalidade não comporta conforme o meu desejo';

  @override
  String get deleteReason3 => 'Possuo outro serviço que acho melhor';

  @override
  String get deleteReason4 => 'A razão não está listada';

  @override
  String get sendEmail => 'Enviar e-mail';

  @override
  String get deleteRequestSLAText => 'O pedido será revisto dentre 72 horas.';

  @override
  String get deleteEmailRequest =>
      'Favor, envie um e-mail a <warning>account-deletion@ente.io</warning> do e-mail registado.';

  @override
  String get entePhotosPerm =>
      'Ente <i>precisa da permissão para</i> preservar as suas fotos';

  @override
  String get ok => 'OK';

  @override
  String get createAccount => 'Criar conta';

  @override
  String get createNewAccount => 'Criar conta nova';

  @override
  String get password => 'Palavra-passe';

  @override
  String get confirmPassword => 'Confirmar palavra-passe';

  @override
  String get activeSessions => 'Sessões ativas';

  @override
  String get oops => 'Ops';

  @override
  String get somethingWentWrongPleaseTryAgain =>
      'Algo correu mal. Favor, tentar de novo';

  @override
  String get thisWillLogYouOutOfThisDevice =>
      'Isto desconectará-vos deste aparelho!';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice =>
      'Isto desconectará-vos dos aparelhos a seguir:';

  @override
  String get terminateSession => 'Desconectar?';

  @override
  String get terminate => 'Desconectar';

  @override
  String get thisDevice => 'Este aparelho';

  @override
  String get recoverButton => 'Recuperar';

  @override
  String get recoverySuccessful => 'Recuperação com êxito!';

  @override
  String get decrypting => 'A desencriptar…';

  @override
  String get incorrectRecoveryKeyTitle => 'Chave de recuperação incorreta';

  @override
  String get incorrectRecoveryKeyBody =>
      'A chave de recuperação introduzida está incorreta';

  @override
  String get forgotPassword => 'Não recordo a palavra-passe';

  @override
  String get enterYourRecoveryKey => 'Introduz a sua chave de recuperação';

  @override
  String get noRecoveryKey => 'Sem chave de recuperação?';

  @override
  String get sorry => 'Desculpe';

  @override
  String get noRecoveryKeyNoDecryption =>
      'Por conta da natureza do nosso protocolo de encriptação, os seus dados não podem ser desencriptados sem a sua palavra-passe ou chave de recuperação.';

  @override
  String get verifyEmail => 'Verificar e-mail';

  @override
  String get toResetVerifyEmail =>
      'Para redefinir a palavra-passe, favor, verifique o seu e-mail.';

  @override
  String get checkInboxAndSpamFolder =>
      'Revê a sua caixa de entrada (e de spam) para concluir a verificação';

  @override
  String get tapToEnterCode => 'Tocar para introduzir código';

  @override
  String get resendEmail => 'Reenviar e-mail';

  @override
  String weHaveSendEmailTo({required String email}) {
    return 'Enviamos um e-mail para <green>$email</green>';
  }

  @override
  String get setPasswordTitle => 'Definir palavra-passe';

  @override
  String get changePasswordTitle => 'Alterar palavra-passe';

  @override
  String get resetPasswordTitle => 'Redefinir palavra-passe';

  @override
  String get encryptionKeys => 'Chaves de encriptação';

  @override
  String get passwordWarning =>
      'Não armazenamos esta palavra-passe, se você a esquecer, <underline>não podemos desencriptar os seus dados</underline>';

  @override
  String get enterPasswordToEncrypt =>
      'Inserir uma palavra-passe para encriptar os seus dados';

  @override
  String get enterNewPasswordToEncrypt =>
      'Inserir uma nova palavra-passe para encriptar os seus dados';

  @override
  String get weakStrength => 'Fraca';

  @override
  String get strongStrength => 'Forte';

  @override
  String get moderateStrength => 'Moderada';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'Força da palavra-passe: $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully =>
      'Palavra-passe alterada com sucesso';

  @override
  String get generatingEncryptionKeys => 'Gerando chaves de encriptação...';

  @override
  String get pleaseWait => 'Por favor, aguarde ...';

  @override
  String get continueLabel => 'Continuar';

  @override
  String get insecureDevice => 'Dispositivo inseguro';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'Desculpe, não foi possível gerar chaves seguras neste dispositivo.\n\npor favor iniciar sessão com um dispositivo diferente.';

  @override
  String get howItWorks => 'Como funciona';

  @override
  String get encryption => 'Encriptação';

  @override
  String get ackPasswordLostWarning =>
      'Eu entendo que se eu perder a minha palavra-passe, posso perder os meus dados já que esses dados são <underline> encriptados de ponta a ponta</underline>.';

  @override
  String get privacyPolicyTitle => 'Política de privacidade';

  @override
  String get termsOfServicesTitle => 'Termos';

  @override
  String get signUpTerms =>
      'Eu concordo com os <u-terms>termos de serviço</u-terms> e <u-policy>política de privacidade</u-policy>';

  @override
  String get logInLabel => 'Iniciar sessão';

  @override
  String get loginTerms =>
      'Ao clicar em iniciar sessão, eu concordo com os termos <u-terms>de serviço</u-terms> e <u-policy>política de privacidade</u-policy>';

  @override
  String get changeEmail => 'Alterar e-mail';

  @override
  String get enterYourPassword => 'Introduza a sua palavra-passe';

  @override
  String get welcomeBack => 'Bem-vindo(a) de volta!';

  @override
  String get contactSupport => 'Contactar o suporte';

  @override
  String get incorrectPasswordTitle => 'Palavra-passe incorreta';

  @override
  String get pleaseTryAgain => 'Por favor, tente novamente';

  @override
  String get recreatePasswordTitle => 'Recriar palavra-passe';

  @override
  String get useRecoveryKey => 'Usar chave de recuperação';

  @override
  String get recreatePasswordBody =>
      'O dispositivo atual não é suficientemente poderoso para verificar a palavra-passe, mas podemos regenerar novamente de uma maneira que funcione no seu dispositivo.\n\nPor favor, iniciar sessão utilizando código de recuperação e gerar novamente a sua palavra-passe (pode utilizar a mesma se quiser).';

  @override
  String get verifyPassword => 'Verificar palavra-passe';

  @override
  String get recoveryKey => 'Chave de recuperação';

  @override
  String get recoveryKeyOnForgotPassword =>
      'Se esquecer sua palavra-passe, a única maneira de recuperar os seus dados é com esta chave.';

  @override
  String get recoveryKeySaveDescription =>
      'Não armazenamos essa chave, por favor, guarde esta chave de 24 palavras num lugar seguro.';

  @override
  String get doThisLater => 'Fazer isto mais tarde';

  @override
  String get saveKey => 'Guardar chave';

  @override
  String get recoveryKeyCopiedToClipboard =>
      'Chave de recuperação copiada para a área de transferência';

  @override
  String get recoverAccount => 'Recuperar conta';

  @override
  String get recover => 'Recuperar';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'Envie um e-mail para $supportEmail a partir do seu endereço de e-mail registado';
  }

  @override
  String get twofactorSetup => 'Configuração de dois fatores';

  @override
  String get enterCode => 'Insira o código';

  @override
  String get scanCode => 'Ler código Qr';

  @override
  String get codeCopiedToClipboard =>
      'Código copiado para área de transferência';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      'Copie e cole este código\nno seu aplicativo de autenticação';

  @override
  String get tapToCopy => 'toque para copiar';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      'Leia este código com a sua aplicação dois fatores.';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      'Introduzir o código de 6 dígitos da\nsua aplicação de autenticação';

  @override
  String get confirm => 'Confirmar';

  @override
  String get setupComplete => 'Configuração concluída';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready =>
      'Guarde a sua chave de recuperação, caso ainda não o tenha feito';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      'Isto pode ser usado para recuperar sua conta se você perder seu segundo fator';

  @override
  String get twofactorAuthenticationPageTitle => 'Autenticação de dois fatores';

  @override
  String get lostDevice => 'Perdeu o seu dispositívo?';

  @override
  String get verifyingRecoveryKey => 'Verificando chave de recuperação...';

  @override
  String get recoveryKeyVerified => 'Chave de recuperação verificada';

  @override
  String get recoveryKeySuccessBody =>
      'Ótimo! A sua chave de recuperação é válida. Obrigado por verificar.\n\nLembre-se de manter cópia de segurança da sua chave de recuperação.';

  @override
  String get invalidRecoveryKey =>
      'A chave de recuperação que inseriu não é válida. Por favor, certifique-se que ela contém 24 palavras e verifique a ortografia de cada uma.\n\nSe inseriu um código de recuperação mais antigo, certifique-se de que tem 64 caracteres e verifique cada um deles.';

  @override
  String get invalidKey => 'Chave inválida';

  @override
  String get tryAgain => 'Tente novamente';

  @override
  String get viewRecoveryKey => 'Ver chave de recuperação';

  @override
  String get confirmRecoveryKey => 'Confirmar chave de recuperação';

  @override
  String get recoveryKeyVerifyReason =>
      'A sua chave de recuperação é a única forma de recuperar as suas fotografias se se esquecer da sua palavra-passe. Pode encontrar a sua chave de recuperação em Definições > Conta.\n\n\nIntroduza aqui a sua chave de recuperação para verificar se a guardou corretamente.';

  @override
  String get confirmYourRecoveryKey => 'Confirmar chave de recuperação';

  @override
  String get addViewer => 'Adicionar visualizador';

  @override
  String get addCollaborator => 'Adicionar colaborador';

  @override
  String get addANewEmail => 'Adicionar um novo e-mail';

  @override
  String get orPickAnExistingOne => 'Ou escolha um já existente';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'Os colaboradores podem adicionar fotos e vídeos ao álbum compartilhado.';

  @override
  String get enterEmail => 'Digite o e-mail';

  @override
  String get albumOwner => 'Dono';

  @override
  String get you => 'Tu';

  @override
  String get collaborator => 'Colaborador';

  @override
  String get addMore => 'Adicionar mais';

  @override
  String get viewer => 'Visualizador';

  @override
  String get remove => 'Remover';

  @override
  String get removeParticipant => 'Remover participante';

  @override
  String get manage => 'Gerir';

  @override
  String get addedAs => 'Adicionado como';

  @override
  String get changePermissions => 'Alterar permissões';

  @override
  String get yesConvertToViewer => 'Sim, converter para visualizador';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return '$user não será capaz de adicionar mais fotos a este álbum\n\nEles ainda serão capazes de remover fotos existentes adicionadas por eles';
  }

  @override
  String get allowAddingPhotos => 'Permitir adicionar fotos';

  @override
  String get allowAddPhotosDescription =>
      'Permitir que pessoas com o link também adicionem fotos ao álbum compartilhado.';

  @override
  String get passwordLock => 'Bloqueio da palavra-passe';

  @override
  String get canNotOpenTitle => 'Não pôde abrir este álbum';

  @override
  String get canNotOpenBody =>
      'Perdão, portanto o álbum não pode ser aberto na aplicação.';

  @override
  String get disableDownloadWarningTitle => 'Por favor, observe';

  @override
  String get disableDownloadWarningBody =>
      'Visualizadores ainda podem fazer capturas de tela ou salvar uma cópia das suas fotos usando ferramentas externas';

  @override
  String get allowDownloads => 'Permitir downloads';

  @override
  String get linkDeviceLimit => 'Limite de dispositivo';

  @override
  String get noDeviceLimit => 'Nenhum';

  @override
  String get linkExpiry => 'Link expirado';

  @override
  String get linkExpired => 'Expirado';

  @override
  String get linkEnabled => 'Ativado';

  @override
  String get linkNeverExpires => 'Nunca';

  @override
  String get expiredLinkInfo =>
      'Este link expirou. Por favor, selecione um novo tempo de expiração ou desabilite a expiração do link.';

  @override
  String get setAPassword => 'Definir uma palavra-passe';

  @override
  String get lockButtonLabel => 'Bloquear';

  @override
  String get enterPassword => 'Introduzir palavra-passe';

  @override
  String get removeLink => 'Remover link';

  @override
  String get manageLink => 'Gerir link';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'O link expirará em $expiryTime';
  }

  @override
  String get albumUpdated => 'Álbum atualizado';

  @override
  String get never => 'Nunca';

  @override
  String get custom => 'Personalizado';

  @override
  String get after1Hour => 'Depois de 1 Hora';

  @override
  String get after1Day => 'Depois de 1 dia';

  @override
  String get after1Week => 'Depois de 1 semana';

  @override
  String get after1Month => 'Depois de 1 mês';

  @override
  String get after1Year => 'Depois de 1 ano';

  @override
  String get manageParticipants => 'Gerir';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count participantes',
      one: '1 participante',
      zero: 'Nenhum participante',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'Criar um link para permitir que as pessoas adicionem e visualizem fotos em seu álbum compartilhado sem precisar de um aplicativo Ente ou conta. Ótimo para coletar fotos do evento.';

  @override
  String get collectPhotos => 'Coletar fotos';

  @override
  String get collaborativeLink => 'Link colaborativo';

  @override
  String get shareWithNonenteUsers =>
      'Compartilhar com usuários que não usam Ente';

  @override
  String get createPublicLink => 'Criar link público';

  @override
  String get sendLink => 'Enviar link';

  @override
  String get copyLink => 'Copiar link';

  @override
  String get linkHasExpired => 'O link expirou';

  @override
  String get publicLinkEnabled => 'Link público ativado';

  @override
  String get shareALink => 'Partilhar um link';

  @override
  String get sharedAlbumSectionDescription =>
      'Criar álbuns compartilhados e colaborativos com outros usuários da Ente, incluindo usuários em planos gratuitos.';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: 'Compartilhado com $numberOfPeople pessoas',
      one: 'Compartilhado com 1 pessoa',
      zero: 'Compartilhe com pessoas específicas',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId => 'Este é o seu ID de verificação';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'Alguém compartilhando álbuns com você deve ver o mesmo ID no seu dispositivo.';

  @override
  String get howToViewShareeVerificationID =>
      'Por favor, peça-lhes para pressionar longamente o endereço de e-mail na tela de configurações e verifique se os IDs de ambos os dispositivos coincidem.';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'Este é o ID de verificação de $email';
  }

  @override
  String get verificationId => 'ID de Verificação';

  @override
  String verifyEmailID({required Object email}) {
    return 'Verificar e-mail';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return '$email não possui uma conta Ente.\n\nEnvie um convite para compartilhar fotos.';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return 'Aqui está o meu ID de verificação: $verificationID para ente.io.';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'Ei, você pode confirmar que este é seu ID de verificação do ente.io: $verificationID';
  }

  @override
  String get somethingWentWrong => 'Ocorreu um erro';

  @override
  String get sendInvite => 'Enviar convite';

  @override
  String get shareTextRecommendUsingEnte =>
      'Descarregue o Ente para poder partilhar facilmente fotografias e vídeos de qualidade original\n\n\nhttps://ente.io';

  @override
  String get done => 'Concluído';

  @override
  String get applyCodeTitle => 'Aplicar código';

  @override
  String get enterCodeDescription =>
      'Introduza o código fornecido pelo seu amigo para obter armazenamento gratuito para ambos';

  @override
  String get apply => 'Aplicar';

  @override
  String get failedToApplyCode => 'Falha ao aplicar código';

  @override
  String get enterReferralCode => 'Insira o código de referência';

  @override
  String get codeAppliedPageTitle => 'Código aplicado';

  @override
  String get changeYourReferralCode => 'Alterar o código de referência';

  @override
  String get change => 'Alterar';

  @override
  String get unavailableReferralCode =>
      'Desculpe, este código não está disponível.';

  @override
  String get codeChangeLimitReached =>
      'Desculpe, você atingiu o limite de alterações de código.';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'Entre em contato com $familyAdminEmail para alterar o seu código.';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB';
  }

  @override
  String get claimed => 'Reclamado';

  @override
  String get details => 'Detalhes';

  @override
  String get claimMore => 'Reclamar mais!';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return 'Eles também recebem $storageAmountInGB GB';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB sempre que alguém se inscreve num plano pago e aplica o seu código';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'Insira o código de referência: $referralCode \n\nAplique-o em Configurações → Geral → Indicações para obter $referralStorageInGB GB gratuitamente após a sua inscrição para um plano pago\n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => 'Solicitar armazenamento gratuito';

  @override
  String get inviteYourFriends => 'Convide os seus amigos';

  @override
  String get failedToFetchReferralDetails =>
      'Não foi possível obter detalhes de indicação. Por favor, tente novamente mais tarde.';

  @override
  String get referralStep1 => '1. Envie este código aos seus amigos';

  @override
  String get referralStep2 => '2. Eles se inscrevem em um plano pago';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. Ambos ganham $storageInGB GB* grátis';
  }

  @override
  String get referralsAreCurrentlyPaused =>
      'As referências estão atualmente em pausa';

  @override
  String get youCanAtMaxDoubleYourStorage =>
      '* Você pode duplicar seu armazenamento no máximo';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true': 'Sua família reinvidicou $storageAmountInGb GB até então',
      'false': 'Você reinvindicou $storageAmountInGb GB até então',
      'other': 'Você reinvindicou $storageAmountInGb GB até então!',
    });
    return '$_temp0';
  }

  @override
  String get faq => 'Perguntas Frequentes';

  @override
  String get help => 'Ajuda';

  @override
  String get oopsSomethingWentWrong => 'Ops, algo deu errado';

  @override
  String get peopleUsingYourCode => 'Pessoas que utilizam seu código';

  @override
  String get eligible => 'elegível';

  @override
  String get total => 'total';

  @override
  String get codeUsedByYou => 'Código usado por você';

  @override
  String get freeStorageClaimed => 'Armazenamento gratuito reclamado';

  @override
  String get freeStorageUsable => 'Armazenamento livre utilizável';

  @override
  String get usableReferralStorageInfo =>
      'O armazenamento disponível é limitado pelo seu plano atual. O excesso de armazenamento reivindicado tornará automaticamente útil quando você atualizar seu plano.';

  @override
  String get removeFromAlbumTitle => 'Remover do álbum';

  @override
  String get removeFromAlbum => 'Remover do álbum';

  @override
  String get itemsWillBeRemovedFromAlbum =>
      'Os itens selecionados serão removidos deste álbum';

  @override
  String get removeShareItemsWarning =>
      'Alguns dos itens que você está removendo foram adicionados por outras pessoas, e você perderá o acesso a eles';

  @override
  String get addingToFavorites => 'Adicionando aos favoritos...';

  @override
  String get removingFromFavorites => 'Removendo dos favoritos...';

  @override
  String get sorryCouldNotAddToFavorites =>
      'Desculpe, não foi possível adicionar aos favoritos!';

  @override
  String get sorryCouldNotRemoveFromFavorites =>
      'Desculpe, não foi possível remover dos favoritos!';

  @override
  String get subscribeToEnableSharing =>
      'Você precisa de uma assinatura paga ativa para ativar o compartilhamento.';

  @override
  String get subscribe => 'Subscrever';

  @override
  String get canOnlyRemoveFilesOwnedByYou => '';

  @override
  String get deleteSharedAlbum => 'Excluir álbum compartilhado?';

  @override
  String get deleteAlbum => 'Apagar álbum';

  @override
  String get deleteAlbumDialog =>
      'Eliminar também as fotos (e vídeos) presentes neste álbum de <bold>all</bold>  os outros álbuns de que fazem parte?';

  @override
  String get deleteSharedAlbumDialogBody =>
      'O álbum será apagado para todos\n\nVocê perderá o acesso a fotos compartilhadas neste álbum que são propriedade de outros';

  @override
  String get yesRemove => 'Sim, remover';

  @override
  String get creatingLink => 'Criar link...';

  @override
  String get removeWithQuestionMark => 'Remover?';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return '$userEmail será removido deste álbum compartilhado\n\nQuaisquer fotos adicionadas por elas também serão removidas do álbum';
  }

  @override
  String get keepPhotos => 'Manter fotos';

  @override
  String get deletePhotos => 'Apagar fotos';

  @override
  String get inviteToEnte => 'Convidar para Ente';

  @override
  String get removePublicLink => 'Remover link público';

  @override
  String disableLinkMessage({required Object albumName}) {
    return 'Isto removerá o link público para acessar \"$albumName\".';
  }

  @override
  String get sharing => 'Partilhar...';

  @override
  String get youCannotShareWithYourself => 'Não podes partilhar contigo mesmo';

  @override
  String get archive => '............';

  @override
  String get createAlbumActionHint =>
      'Pressione e segure para selecionar fotos e clique em + para criar um álbum';

  @override
  String get importing => 'A importar...';

  @override
  String get failedToLoadAlbums => 'Falha ao carregar álbuns';

  @override
  String get hidden => 'Oculto';

  @override
  String get authToViewYourHiddenFiles =>
      'Por favor, autentique para ver seus arquivos ocultos';

  @override
  String get authToViewTrashedFiles =>
      'Autentica-se para visualizar os ficheiros na lata de lixo';

  @override
  String get trash => 'Lixo';

  @override
  String get uncategorized => 'Sem categoria';

  @override
  String get videoSmallCase => 'vídeo';

  @override
  String get photoSmallCase => 'foto';

  @override
  String get singleFileDeleteHighlight => 'Será eliminado de todos os álbuns.';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return 'Este $fileType encontra-se tanto no Ente como no seu dispositivo.';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return 'Este $fileType será eliminado do Ente.';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return 'Este $fileType será eliminado do seu dispositivo.';
  }

  @override
  String get deleteFromEnte => 'Apagar do Ente';

  @override
  String get yesDelete => 'Sim, apagar';

  @override
  String get movedToTrash => 'Mover para o lixo';

  @override
  String get deleteFromDevice => 'Apagar do dispositivo';

  @override
  String get deleteFromBoth => 'Apagar de ambos';

  @override
  String get newAlbum => 'Novo álbum';

  @override
  String get albums => 'Álbuns';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount memórias',
      one: '$formattedCount memória',
      zero: 'não há memórias',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return '$count selecionado(s)';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return '$count selecionado(s) ($yourCount seus)';
  }

  @override
  String get advancedSettings => 'Definições avançadas';

  @override
  String get photoGridSize => 'Tamanho da grelha de fotos';

  @override
  String get manageDeviceStorage => 'Gerir cache do aparelho';

  @override
  String get manageDeviceStorageDesc =>
      'Reveja e limpe o armazenamento de cache local.';

  @override
  String get machineLearning => 'Aprendizagem automática';

  @override
  String get mlConsent => 'Ativar aprendizagem automática';

  @override
  String get mlConsentTitle => 'Ativar aprendizagem automática?';

  @override
  String get mlConsentDescription =>
      'Se ativar a aprendizagem automática, o Ente extrairá informações como a geometria do rosto de ficheiros, incluindo os partilhados consigo.\n\n\nIsto acontecerá no seu dispositivo e todas as informações biométricas geradas serão encriptadas de ponta a ponta.';

  @override
  String get mlConsentPrivacy =>
      'Por favor, clique aqui para mais detalhes sobre este recurso na nossa política de privacidade';

  @override
  String get mlConsentConfirmation =>
      'Eu entendo, e desejo ativar a aprendizagem automática';

  @override
  String get magicSearch => 'Pesquisa mágica';

  @override
  String get discover => 'Descobrir';

  @override
  String get discover_identity => 'Identidade';

  @override
  String get discover_screenshots => 'Capturas de ecrã';

  @override
  String get discover_receipts => 'Recibos';

  @override
  String get discover_notes => 'Notas';

  @override
  String get discover_memes => 'Memes';

  @override
  String get discover_visiting_cards => 'Cartões de visita';

  @override
  String get discover_babies => 'Bebés';

  @override
  String get discover_pets => 'Animais de estimação';

  @override
  String get discover_selfies => 'Selfies';

  @override
  String get discover_wallpapers => 'Papéis de parede';

  @override
  String get discover_food => 'Comida';

  @override
  String get discover_celebrations => 'Comemorações';

  @override
  String get discover_sunset => 'Pôr do sol';

  @override
  String get discover_hills => 'Colinas';

  @override
  String get discover_greenery => 'Vegetação';

  @override
  String get mlIndexingDescription =>
      'Tenha em atenção que a aprendizagem automática resultará numa maior utilização da largura de banda e da bateria até que todos os itens sejam indexados. Considere utilizar a aplicação de ambiente de trabalho para uma indexação mais rápida, todos os resultados serão sincronizados automaticamente.';

  @override
  String get loadingModel => 'Transferindo modelos...';

  @override
  String get waitingForWifi => 'Aguardando Wi-Fi...';

  @override
  String get status => 'Status';

  @override
  String get indexedItems => 'Itens indexados';

  @override
  String get pendingItems => 'Itens pendentes';

  @override
  String get clearIndexes => 'Limpar índices';

  @override
  String get selectFoldersForBackup =>
      'Selecionar pastas para cópia de segurança';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      'As pastas selecionadas serão encriptadas e guardadas como cópia de segurança';

  @override
  String get unselectAll => 'Desmarcar tudo';

  @override
  String get selectAll => 'Selecionar tudo';

  @override
  String get skip => 'Pular';

  @override
  String get updatingFolderSelection => 'Atualizando seleção de pasta...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count itens',
      one: '$count item',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Apagar $count itens',
      one: 'Apagar $count item',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count arquivos, $formattedSize cada';
  }

  @override
  String get showMemories => 'Mostrar memórias';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count anos atrás',
      one: '$count ano atrás',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'Definições da cópia de segurança';

  @override
  String get backupStatus => 'Status da cópia de segurança';

  @override
  String get backupStatusDescription =>
      'Os itens que foram salvos com segurança aparecerão aqui';

  @override
  String get backupOverMobileData =>
      'Cópia de segurança através dos dados móveis';

  @override
  String get backupVideos => 'Cópia de segurança de vídeos';

  @override
  String get disableAutoLock => 'Desativar bloqueio automático';

  @override
  String get deviceLockExplanation =>
      'Desativar o bloqueio do ecrã do dispositivo quando o Ente estiver em primeiro plano e houver uma cópia de segurança em curso. Normalmente, isto não é necessário, mas pode ajudar a que os grandes carregamentos e as importações iniciais de grandes bibliotecas sejam concluídos mais rapidamente.';

  @override
  String get about => 'Sobre';

  @override
  String get weAreOpenSource => 'Nós somos de código aberto!';

  @override
  String get privacy => 'Privacidade';

  @override
  String get terms => 'Termos';

  @override
  String get checkForUpdates => 'Procurar atualizações';

  @override
  String get checkStatus => 'Verificar status';

  @override
  String get checking => 'A verificar...';

  @override
  String get youAreOnTheLatestVersion =>
      'Está a utilizar a versão mais recente';

  @override
  String get account => 'Conta';

  @override
  String get manageSubscription => 'Gerir subscrição';

  @override
  String get authToChangeYourEmail =>
      'Por favor, autentique-se para alterar o seu e-mail';

  @override
  String get changePassword => 'Alterar palavra-passe';

  @override
  String get authToChangeYourPassword =>
      'Por favor, autentique-se para alterar a palavra-passe';

  @override
  String get emailVerificationToggle => 'Verificação por e-mail';

  @override
  String get authToChangeEmailVerificationSetting =>
      'Por favor, autentique-se para alterar a verificação de e-mail';

  @override
  String get exportYourData => 'Exportar os seus dados';

  @override
  String get logout => 'Terminar sessão';

  @override
  String get authToInitiateAccountDeletion =>
      'Autentique-se para iniciar a eliminação da conta';

  @override
  String get areYouSureYouWantToLogout =>
      'Tem certeza que deseja terminar a sessão?';

  @override
  String get yesLogout => 'Sim, terminar sessão';

  @override
  String get aNewVersionOfEnteIsAvailable =>
      'Está disponível uma nova versão do Ente.';

  @override
  String get update => 'Atualizar';

  @override
  String get installManually => 'Instalar manualmente';

  @override
  String get criticalUpdateAvailable => 'Atualização crítica disponível';

  @override
  String get updateAvailable => 'Atualização disponível';

  @override
  String get ignoreUpdate => 'Ignorar';

  @override
  String get downloading => 'A transferir...';

  @override
  String get cannotDeleteSharedFiles =>
      'Não é possível eliminar ficheiros partilhados';

  @override
  String get theDownloadCouldNotBeCompleted =>
      'Não foi possível concluir o download.';

  @override
  String get retry => 'Tentar novamente';

  @override
  String get backedUpFolders => 'Pastas com cópia de segurança';

  @override
  String get backup => 'Cópia de segurança';

  @override
  String get freeUpDeviceSpace => 'Libertar espaço no dispositivo';

  @override
  String get freeUpDeviceSpaceDesc =>
      'Poupe espaço no seu dispositivo limpando ficheiros dos quais já foi feita uma cópia de segurança.';

  @override
  String get allClear => '✨ Tudo limpo';

  @override
  String get noDeviceThatCanBeDeleted =>
      'Você não tem arquivos neste dispositivo que possam ser apagados';

  @override
  String get removeDuplicates => 'Remover duplicados';

  @override
  String get removeDuplicatesDesc =>
      'Rever e remover ficheiros que sejam duplicados exatos.';

  @override
  String get viewLargeFiles => 'Ficheiros grandes';

  @override
  String get viewLargeFilesDesc =>
      'Ver os ficheiros que estão a consumir a maior quantidade de armazenamento.';

  @override
  String get noDuplicates => '✨ Sem duplicados';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared =>
      'Não tem nenhum ficheiro duplicado que possa ser eliminado';

  @override
  String get success => 'Sucesso';

  @override
  String get rateUs => 'Avalie-nos';

  @override
  String get remindToEmptyDeviceTrash =>
      'Esvazie também a opção “Eliminados recentemente” em “Definições” -> “Armazenamento” para reclamar o espaço libertado';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return 'Você liberou $storageSaved com sucesso!';
  }

  @override
  String get remindToEmptyEnteTrash =>
      'Esvazie também o seu “Lixo” para reivindicar o espaço libertado';

  @override
  String get sparkleSuccess => '✨ Sucesso';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count arquivos duplicados',
      one: '$count arquivo duplicado',
    );
    return 'Você limpou $_temp0, guardando ($storageSaved!)';
  }

  @override
  String get familyPlans => 'Planos familiares';

  @override
  String get referrals => 'Referências';

  @override
  String get notifications => 'Notificações';

  @override
  String get sharedPhotoNotifications => 'Novas fotos partilhadas';

  @override
  String get sharedPhotoNotificationsExplanation =>
      'Receber notificações quando alguém adiciona uma foto a um álbum partilhado do qual faz parte';

  @override
  String get advanced => 'Avançado';

  @override
  String get general => 'Geral';

  @override
  String get security => 'Segurança';

  @override
  String get authToViewYourRecoveryKey =>
      'Por favor, autentique-se para ver a chave de recuperação';

  @override
  String get twofactor => 'Dois fatores';

  @override
  String get authToConfigureTwofactorAuthentication =>
      'Por favor, autentique para configurar a autenticação de dois fatores';

  @override
  String get lockscreen => 'Ecrã de bloqueio';

  @override
  String get authToChangeLockscreenSetting =>
      'Por favor, autentique-se para alterar a configuração da tela do ecrã de bloqueio';

  @override
  String get viewActiveSessions => 'Ver sessões ativas';

  @override
  String get authToViewYourActiveSessions =>
      'Por favor, autentique-se para ver as suas sessões ativas';

  @override
  String get disableTwofactor => 'Desativar autenticação de dois fatores';

  @override
  String get confirm2FADisable =>
      'Tem a certeza de que pretende desativar a autenticação de dois fatores?';

  @override
  String get no => 'Não';

  @override
  String get yes => 'Sim';

  @override
  String get social => 'Social';

  @override
  String rateUsOnStore({required Object storeName}) {
    return 'Avalie-nos em $storeName';
  }

  @override
  String get blog => 'Blog';

  @override
  String get merchandise => 'Produtos';

  @override
  String get twitter => 'Twitter';

  @override
  String get mastodon => 'Mastodon';

  @override
  String get matrix => 'Matrix';

  @override
  String get discord => 'Discord';

  @override
  String get reddit => 'Reddit';

  @override
  String get yourStorageDetailsCouldNotBeFetched =>
      'Não foi possível obter os seus dados de armazenamento';

  @override
  String get reportABug => 'Reporte um bug';

  @override
  String get reportBug => 'Reportar bug';

  @override
  String get suggestFeatures => 'Sugerir recursos';

  @override
  String get support => 'Suporte';

  @override
  String get theme => 'Tema';

  @override
  String get lightTheme => 'Claro';

  @override
  String get darkTheme => 'Escuro';

  @override
  String get systemTheme => 'Sistema';

  @override
  String get freeTrial => 'Teste grátis';

  @override
  String get selectYourPlan => 'Selecione o seu plano';

  @override
  String get enteSubscriptionPitch =>
      'O Ente preserva as suas memórias, para que estejam sempre disponíveis, mesmo que perca o seu dispositivo.';

  @override
  String get enteSubscriptionShareWithFamily =>
      'Sua família também pode ser adicionada ao seu plano.';

  @override
  String get currentUsageIs => 'O uso atual é ';

  @override
  String get faqs => 'Perguntas frequentes';

  @override
  String renewsOn({required Object endDate}) {
    return 'A subscrição é renovada em $endDate';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return 'Teste gratuito válido até $endDate';
  }

  @override
  String validTill({required Object endDate}) {
    return 'Válido até $endDate';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return 'Seu addon $storageAmount é válido até o momento $endDate';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return 'Teste gratuito válido até $endDate.\nVocê pode escolher um plano pago depois.';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'A sua subscrição será cancelada em $endDate';
  }

  @override
  String get subscription => 'Subscrição';

  @override
  String get paymentDetails => 'Detalhes de pagamento';

  @override
  String get manageFamily => 'Gerir família';

  @override
  String contactToManageSubscription({required Object provider}) {
    return 'Contacte-nos em support@ente.io para gerir a sua subscrição $provider';
  }

  @override
  String get renewSubscription => 'Renovar subscrição';

  @override
  String get cancelSubscription => 'Cancelar subscrição';

  @override
  String get areYouSureYouWantToRenew =>
      'Tem a certeza de que pretende renovar?';

  @override
  String get yesRenew => 'Sim, Renovar';

  @override
  String get areYouSureYouWantToCancel => 'Tem a certeza de que quer cancelar?';

  @override
  String get yesCancel => 'Sim, cancelar';

  @override
  String get failedToRenew => 'Falhou ao renovar';

  @override
  String get failedToCancel => 'Falhou ao cancelar';

  @override
  String get twoMonthsFreeOnYearlyPlans => '2 meses grátis em planos anuais';

  @override
  String get monthly => 'Mensal';

  @override
  String get yearly => 'Anual';

  @override
  String get confirmPlanChange => 'Confirmar alteração de plano';

  @override
  String get areYouSureYouWantToChangeYourPlan =>
      'Tem a certeza de que pretende alterar o seu plano?';

  @override
  String get youCannotDowngradeToThisPlan =>
      'Não é possível fazer o downgrade para este plano';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'Por favor, cancele primeiro a sua subscrição existente de $paymentProvider';
  }

  @override
  String get optionalAsShortAsYouLike => 'Opcional, o mais breve que quiser...';

  @override
  String get send => 'Enviar';

  @override
  String get askCancelReason =>
      'A sua subscrição foi cancelada. Gostaria de partilhar o motivo?';

  @override
  String get thankYouForSubscribing => 'Obrigado pela sua subscrição!';

  @override
  String get yourPurchaseWasSuccessful =>
      'Sua compra foi realizada com sucesso';

  @override
  String get yourPlanWasSuccessfullyUpgraded =>
      'O seu plano foi atualizado com sucesso';

  @override
  String get yourPlanWasSuccessfullyDowngraded =>
      'O seu plano foi rebaixado com sucesso';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully =>
      'A sua subscrição foi actualizada com sucesso';

  @override
  String get googlePlayId => 'ID do Google Play';

  @override
  String get appleId => 'ID da Apple';

  @override
  String get playstoreSubscription => 'Subscrição da PlayStore';

  @override
  String get appstoreSubscription => 'Subscrição da AppStore';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return 'Seu $id já está vinculado a outra conta Ente.\nSe você gostaria de usar seu $id com esta conta, por favor contate nosso suporte\'\'';
  }

  @override
  String get visitWebToManage =>
      'Visite web.ente.io para gerir a sua subscrição';

  @override
  String get couldNotUpdateSubscription =>
      'Não foi possível atualizar a subscrição';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      'Por favor, entre em contato com support@ente.io e nós ficaremos felizes em ajudar!';

  @override
  String get paymentFailed => 'O pagamento falhou';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return 'Por favor, fale com o suporte $providerName se você foi cobrado';
  }

  @override
  String get continueOnFreeTrial => 'Continuar em teste gratuito';

  @override
  String get areYouSureYouWantToExit => 'Tem certeza de que deseja sair?';

  @override
  String get thankYou => 'Obrigado';

  @override
  String get failedToVerifyPaymentStatus =>
      'Falha ao verificar status do pagamento';

  @override
  String get pleaseWaitForSometimeBeforeRetrying =>
      'Por favor, aguarde algum tempo antes de tentar novamente';

  @override
  String get paymentFailedMessage =>
      'Infelizmente o seu pagamento falhou. Entre em contato com o suporte e nós ajudaremos você!';

  @override
  String get youAreOnAFamilyPlan => 'Você está em um plano familiar!';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'Contacte <green>$familyAdminEmail</green> para gerir a sua subscrição';
  }

  @override
  String get leaveFamily => 'Deixar plano famíliar';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily =>
      'Tem certeza que deseja sair do plano familiar?';

  @override
  String get leave => 'Sair';

  @override
  String get rateTheApp => 'Avaliar aplicação';

  @override
  String get startBackup => 'Iniciar cópia de segurança';

  @override
  String get noPhotosAreBeingBackedUpRightNow =>
      'No momento não há backup de fotos sendo feito';

  @override
  String get preserveMore => 'Preservar mais';

  @override
  String get grantFullAccessPrompt =>
      'Por favor, permita o acesso a todas as fotos nas definições do aplicativo';

  @override
  String get allowPermTitle => 'Garanta acesso às fotos';

  @override
  String get allowPermBody =>
      'Favor, permite acesso às fotos nas Definições para que Ente possa exibi-las e fazer backup na Fototeca.';

  @override
  String get openSettings => 'Abrir Definições';

  @override
  String get selectMorePhotos => 'Selecionar mais fotos';

  @override
  String get existingUser => 'Utilizador existente';

  @override
  String get privateBackups => 'Backups privados';

  @override
  String get forYourMemories => 'para suas memórias';

  @override
  String get endtoendEncryptedByDefault =>
      'Criptografia de ponta a ponta por padrão';

  @override
  String get safelyStored => 'Armazenado com segurança';

  @override
  String get atAFalloutShelter => 'em um abrigo avançado';

  @override
  String get designedToOutlive => 'Feito para ter longevidade';

  @override
  String get available => 'Disponível';

  @override
  String get everywhere => 'em todo o lado';

  @override
  String get androidIosWebDesktop => 'Android, iOS, Web, Desktop';

  @override
  String get mobileWebDesktop => 'Mobile, Web, Desktop';

  @override
  String get newToEnte => 'Novo no Ente';

  @override
  String get pleaseLoginAgain => 'Por favor, inicie sessão novamente';

  @override
  String get autoLogoutMessage =>
      'Devido a uma falha técnica, a sua sessão foi encerrada. Pedimos desculpas pelo incómodo.';

  @override
  String get yourSubscriptionHasExpired => 'A sua subscrição expirou';

  @override
  String get storageLimitExceeded => 'Limite de armazenamento excedido';

  @override
  String get upgrade => 'Atualizar';

  @override
  String get raiseTicket => 'Abrir ticket';

  @override
  String get backupFailed => 'Backup falhou';

  @override
  String get sorryBackupFailedDesc =>
      'Perdão, mas não podemos fazer backup deste ficheiro agora, tentaremos mais tarde.';

  @override
  String get couldNotBackUpTryLater =>
      'Não foi possível fazer o backup de seus dados.\nTentaremos novamente mais tarde.';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      'Ente pode criptografar e preservar arquivos apenas se você conceder acesso a eles';

  @override
  String get pleaseGrantPermissions => 'Por favor, conceda as permissões';

  @override
  String get grantPermission => 'Conceder permissão';

  @override
  String get privateSharing => 'Partilha privada';

  @override
  String get shareOnlyWithThePeopleYouWant =>
      'Partilhar apenas com as pessoas que deseja';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      'Usar links públicos para pessoas que não estão no Ente';

  @override
  String get allowPeopleToAddPhotos =>
      'Permitir que as pessoas adicionem fotos';

  @override
  String get shareAnAlbumNow => 'Partilhar um álbum';

  @override
  String get collectEventPhotos => 'Coletar fotos do evento';

  @override
  String get sessionExpired => 'Sessão expirada';

  @override
  String get loggingOut => 'Terminar a sessão...';

  @override
  String get onDevice => 'No dispositivo';

  @override
  String get onEnte => 'Em <branding>ente</branding>';

  @override
  String get name => 'Nome';

  @override
  String get newest => 'Recentes';

  @override
  String get lastUpdated => 'Última atualização';

  @override
  String get deleteEmptyAlbums => 'Apagar álbuns vazios';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => 'Apagar álbuns vazios?';

  @override
  String get deleteAlbumsDialogBody =>
      'Esta ação elimina todos os álbuns vazios. Isto é útil quando pretende reduzir a confusão na sua lista de álbuns.';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return 'Apagar $currentlyDeleting / $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return 'Processando $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => 'Eliminar permanentemente';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou =>
      'Só pode criar um link para arquivos pertencentes a você';

  @override
  String get publicLinkCreated => 'Link público criado';

  @override
  String get youCanManageYourLinksInTheShareTab =>
      'Pode gerir as suas ligações no separador partilhar.';

  @override
  String get linkCopiedToClipboard =>
      'Link copiado para a área de transferência';

  @override
  String get restore => 'Restaurar';

  @override
  String get moveToAlbum => 'Mover para álbum';

  @override
  String get unhide => 'Mostrar';

  @override
  String get unarchive => 'Desarquivar';

  @override
  String get favorite => 'Favorito';

  @override
  String get removeFromFavorite => 'Remover dos favoritos';

  @override
  String get shareLink => 'Partilhar link';

  @override
  String get createCollage => 'Criar coleção';

  @override
  String get saveCollage => 'Guardar colagem';

  @override
  String get collageSaved => 'Colagem guardada na galeria';

  @override
  String get collageLayout => 'Layout';

  @override
  String get addToEnte => 'Adicionar ao Ente';

  @override
  String get addToAlbum => 'Adicionar ao álbum';

  @override
  String get delete => 'Apagar';

  @override
  String get hide => 'Ocultar';

  @override
  String get share => 'Partilhar';

  @override
  String get unhideToAlbum => 'Mostrar para o álbum';

  @override
  String get restoreToAlbum => 'Restaurar para álbum';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Mover itens',
      one: 'Mover item',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Adicionar itens',
      one: 'Adicionar item',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'Criar ou selecionar álbum';

  @override
  String get selectAlbum => 'Selecionar álbum';

  @override
  String get searchByAlbumNameHint => 'Nome do álbum';

  @override
  String get albumTitle => 'Título do álbum';

  @override
  String get enterAlbumName => 'Introduzir nome do álbum';

  @override
  String get restoringFiles => 'Restaurar arquivos...';

  @override
  String get movingFilesToAlbum => 'Mover arquivos para o álbum...';

  @override
  String get unhidingFilesToAlbum => 'Desocultar ficheiros para o álbum';

  @override
  String get canNotUploadToAlbumsOwnedByOthers =>
      'Não é possível fazer upload para álbuns pertencentes a outros';

  @override
  String get uploadingFilesToAlbum => 'Enviar ficheiros para o álbum...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return 'Adicionado com sucesso a $albumName';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return 'Movido com sucesso para $albumName';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'Este álbum já tem um link colaborativo';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return 'Link colaborativo criado para $albumName';
  }

  @override
  String get askYourLovedOnesToShare =>
      'Peça aos seus entes queridos para partilharem';

  @override
  String get invite => 'Convidar';

  @override
  String get shareYourFirstAlbum => 'Partilhe o seu primeiro álbum';

  @override
  String sharedWith({required Object emailIDs}) {
    return 'Partilhado com $emailIDs';
  }

  @override
  String get sharedWithMe => 'Partilhado comigo';

  @override
  String get sharedByMe => 'Partilhado por mim';

  @override
  String get doubleYourStorage => 'Duplicar o seu armazenamento';

  @override
  String get referFriendsAnd2xYourPlan =>
      'Recomende amigos e duplique o seu plano';

  @override
  String get shareAlbumHint =>
      'Abra um álbum e toque no botão de partilha no canto superior direito para partilhar';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      'Os itens mostram o número de dias restantes antes da eliminação permanente';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count dias',
      one: '1 dia',
      zero: 'Brevemente',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => 'Apagar tudo';

  @override
  String get renameAlbum => 'Renomear álbum';

  @override
  String get convertToAlbum => 'Converter para álbum';

  @override
  String get setCover => 'Definir capa';

  @override
  String get sortAlbumsBy => 'Ordenar por';

  @override
  String get sortNewestFirst => 'Mais recentes primeiro';

  @override
  String get sortOldestFirst => 'Mais antigos primeiro';

  @override
  String get rename => 'Renomear';

  @override
  String get leaveSharedAlbum => 'Sair do álbum compartilhado?';

  @override
  String get leaveAlbum => 'Sair do álbum';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'As fotos adicionadas por si serão removidas do álbum';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted =>
      'Não existem ficheiros neste álbum que possam ser eliminados';

  @override
  String get youDontHaveAnyArchivedItems => 'Não tem nenhum item arquivado.';

  @override
  String get ignoredFolderUploadReason =>
      'Alguns ficheiros deste álbum não podem ser carregados porque foram anteriormente eliminados do Ente.';

  @override
  String get resetIgnoredFiles => 'Repor ficheiros ignorados';

  @override
  String get deviceFilesAutoUploading =>
      'Os ficheiros adicionados a este álbum de dispositivo serão automaticamente transferidos para o Ente.';

  @override
  String get turnOnBackupForAutoUpload =>
      'Ative o backup para enviar automaticamente arquivos adicionados a esta pasta do dispositivo para o Ente.';

  @override
  String get noHiddenPhotosOrVideos => 'Sem fotos ou vídeos ocultos';

  @override
  String get toHideAPhotoOrVideo => 'Para ocultar uma foto ou um vídeo';

  @override
  String get openTheItem => '• Abra o item';

  @override
  String get clickOnTheOverflowMenu => '• Clique no menu adicional';

  @override
  String get click => 'Clique';

  @override
  String get nothingToSeeHere => 'Nada para ver aqui! 👀';

  @override
  String get unarchiveAlbum => 'Desarquivar álbum';

  @override
  String get archiveAlbum => 'Arquivar álbum';

  @override
  String get calculating => 'Calcular...';

  @override
  String get pleaseWaitDeletingAlbum => 'Por favor aguarde,  apagar o álbum';

  @override
  String get searchByExamples =>
      '• Nomes de álbuns (ex: \"Câmera\")\n• Tipos de arquivos (ex.: \"Vídeos\", \".gif\")\n• Anos e meses (e.. \"2022\", \"Janeiro\")\n• Feriados (por exemplo, \"Natal\")\n• Descrições de fotos (por exemplo, \"#divertido\")';

  @override
  String get youCanTrySearchingForADifferentQuery =>
      'Pode tentar pesquisar uma consulta diferente.';

  @override
  String get noResultsFound => 'Não foram encontrados resultados';

  @override
  String addedBy({required Object emailOrName}) {
    return 'Adicionado por $emailOrName';
  }

  @override
  String get loadingExifData => 'Carregando dados EXIF...';

  @override
  String get viewAllExifData => 'Ver todos os dados EXIF';

  @override
  String get noExifData => 'Sem dados EXIF';

  @override
  String get thisImageHasNoExifData => 'Esta imagem não tem dados exif';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => 'Nenhum resultado';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'Não suportamos a edição de fotos e álbuns que ainda não possui';

  @override
  String get failedToFetchOriginalForEdit =>
      'Falha ao obter original para edição';

  @override
  String get close => 'Fechar';

  @override
  String get setAs => 'Definir como';

  @override
  String get fileSavedToGallery => 'Arquivo guardado na galeria';

  @override
  String get filesSavedToGallery => 'Arquivos guardados na galeria';

  @override
  String get fileFailedToSaveToGallery =>
      'Falha ao guardar o ficheiro na galeria';

  @override
  String get download => 'Download';

  @override
  String get pressAndHoldToPlayVideo =>
      'Pressione e segure para reproduzir o vídeo';

  @override
  String get pressAndHoldToPlayVideoDetailed =>
      'Pressione e segure na imagem para reproduzir o vídeo';

  @override
  String get downloadFailed => 'Falha no download';

  @override
  String get deduplicateFiles => 'Arquivos duplicados';

  @override
  String get deselectAll => 'Desmarcar tudo';

  @override
  String get reviewDeduplicateItems =>
      'Reveja e elimine os itens que considera serem duplicados.';

  @override
  String get clubByCaptureTime => 'Agrupar por tempo de captura';

  @override
  String get clubByFileName => 'Agrupar pelo nome de arquivo';

  @override
  String get count => 'Contagem';

  @override
  String get totalSize => 'Tamanho total';

  @override
  String get longpressOnAnItemToViewInFullscreen =>
      'Pressione e segure em um item para ver em tela cheia';

  @override
  String get decryptingVideo => 'Descriptografando vídeo...';

  @override
  String get authToViewYourMemories =>
      'Por favor, autentique-se para ver suas memórias';

  @override
  String get unlock => 'Desbloquear';

  @override
  String get freeUpSpace => 'Libertar espaço';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Pode eliminá-los do aparelho para esvaziar $formattedSize',
      one: 'Pode eliminá-lo do aparelho para esvaziar $formattedSize',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber arquivos',
      one: '1 arquivo',
    );
    return '$_temp0 neste álbum teve um backup seguro';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber arquivos',
      one: '1 arquivo',
    );
    return '$_temp0 neste dispositivo teve um backup seguro';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '-los',
      one: '-lo',
    );
    return 'Ainda pode acessá$_temp0 no Ente contanto que tenha uma subscrição ativa';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return 'Libertar $sizeInMBorGB';
  }

  @override
  String get thisEmailIsAlreadyInUse => 'Este email já está em uso';

  @override
  String get incorrectCode => 'Código incorrecto';

  @override
  String get authenticationFailedPleaseTryAgain =>
      'Falha na autenticação, por favor tente novamente';

  @override
  String get verificationFailedPleaseTryAgain =>
      'Falha na verificação, por favor tente novamente';

  @override
  String get authenticating => 'A Autenticar...';

  @override
  String get authenticationSuccessful => 'Autenticação bem sucedida!';

  @override
  String get incorrectRecoveryKey => 'Chave de recuperação incorreta';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect =>
      'A chave de recuperação inserida está incorreta';

  @override
  String get twofactorAuthenticationSuccessfullyReset =>
      'Autenticação de dois fatores redefinida com êxito';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered =>
      'Por favor, verifique se o código que você inseriu';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      'Por favor, contate o suporte se o problema persistir';

  @override
  String get twofactorAuthenticationHasBeenDisabled =>
      'A autenticação de dois fatores foi desativada';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect =>
      'Desculpe, o código inserido está incorreto';

  @override
  String get yourVerificationCodeHasExpired =>
      'O seu código de verificação expirou';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'Email alterado para $newEmail';
  }

  @override
  String get verifying => 'A verificar…';

  @override
  String get disablingTwofactorAuthentication =>
      'Desativar a autenticação de dois factores...';

  @override
  String get allMemoriesPreserved => 'Todas as memórias preservadas';

  @override
  String get loadingGallery => 'Carregando galeria...';

  @override
  String get syncing => 'Sincronizando...';

  @override
  String get encryptingBackup => 'Criptografando backup...';

  @override
  String get syncStopped => 'Sincronização interrompida';

  @override
  String syncProgress({required String completed, required String total}) {
    return '$completed/$total memórias preservadas';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return 'Preservar $count memórias...';
  }

  @override
  String get uploadingSingleMemory => 'Preservar 1 memória...';

  @override
  String get archiving => 'Arquivar...';

  @override
  String get unarchiving => 'Desarquivar...';

  @override
  String get successfullyArchived => 'Arquivado com sucesso';

  @override
  String get successfullyUnarchived => 'Desarquivado com sucesso';

  @override
  String get renameFile => 'Renomear arquivo';

  @override
  String get enterFileName => 'Inserir nome do arquivo';

  @override
  String get filesDeleted => 'Arquivos apagados';

  @override
  String get selectedFilesAreNotOnEnte =>
      'Os arquivos selecionados não estão no Ente';

  @override
  String get thisActionCannotBeUndone => 'Esta ação não pode ser desfeita';

  @override
  String get emptyTrash => 'Esvaziar lixo?';

  @override
  String get permDeleteWarning =>
      'Todos os itens no lixo serão permanentemente eliminados\n\n\nEsta ação não pode ser anulada';

  @override
  String get empty => 'Esvaziar';

  @override
  String get couldNotFreeUpSpace => 'Não foi possível libertar espaço';

  @override
  String get permanentlyDeleteFromDevice =>
      'Apagar permanentemente do dispositivo?';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      'Alguns dos ficheiros que está a tentar eliminar só estão disponíveis no seu dispositivo e não podem ser recuperados se forem eliminados';

  @override
  String get theyWillBeDeletedFromAllAlbums =>
      'Serão eliminados de todos os álbuns.';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'Alguns itens estão tanto no Ente como no seu dispositivo.';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      'Os itens selecionados serão eliminados de todos os álbuns e movidos para o lixo.';

  @override
  String get theseItemsWillBeDeletedFromYourDevice =>
      'Estes itens serão eliminados do seu dispositivo.';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      'Parece que algo correu mal. Por favor, tente novamente após algum tempo. Se o erro persistir, contacte a nossa equipa de apoio.';

  @override
  String get error => 'Erro';

  @override
  String get tempErrorContactSupportIfPersists =>
      'Parece que algo correu mal. Por favor, tente novamente mais tarde. Se o erro persistir, entre em contacto com a nossa equipa de suporte.';

  @override
  String get networkHostLookUpErr =>
      'Não foi possível estabelecer ligação ao Ente. Verifique as definições de rede e contacte o serviço de apoio se o erro persistir.';

  @override
  String get networkConnectionRefusedErr =>
      'Não foi possível conectar ao Ente, tente novamente após algum tempo. Se o erro persistir, entre em contato com o suporte.';

  @override
  String get cachedData => 'Dados em cache';

  @override
  String get clearCaches => 'Limpar cache';

  @override
  String get remoteImages => 'Imagens remotas';

  @override
  String get remoteVideos => 'Vídeos remotos';

  @override
  String get remoteThumbnails => 'Miniaturas remotas';

  @override
  String get pendingSync => 'Sincronização pendente';

  @override
  String get localGallery => 'Galeria local';

  @override
  String get todaysLogs => 'Logs de hoje';

  @override
  String get viewLogs => 'Ver logs';

  @override
  String get logsDialogBody =>
      'Isto enviará os registos para nos ajudar a resolver o problema. Tenha em atenção que os nomes dos ficheiros serão incluídos para ajudar a localizar problemas com ficheiros específicos.';

  @override
  String get preparingLogs => 'Preparando logs...';

  @override
  String get emailYourLogs => 'Enviar logs por e-mail';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'Por favor, envie os logs para \n$toEmail';
  }

  @override
  String get copyEmailAddress => 'Copiar endereço de email';

  @override
  String get exportLogs => 'Exportar logs';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return 'Por favor, envie-nos um e-mail para $toEmail';
  }

  @override
  String get dismiss => 'Rejeitar';

  @override
  String get didYouKnow => 'Você sabia?';

  @override
  String get loadingMessage => 'Carregar as suas fotos...';

  @override
  String get loadMessage1 =>
      'Pode partilhar a sua subscrição com a sua família';

  @override
  String get loadMessage2 =>
      'Já contivemos 200 milhões de memórias até o momento';

  @override
  String get loadMessage3 =>
      'Mantemos 3 cópias dos seus dados, uma em um abrigo subterrâneo';

  @override
  String get loadMessage4 => 'Todos os nossos aplicativos são de código aberto';

  @override
  String get loadMessage5 =>
      'Nosso código-fonte e criptografia foram auditadas externamente';

  @override
  String get loadMessage6 => 'Deixar o álbum partilhado?';

  @override
  String get loadMessage7 =>
      'Nossos aplicativos móveis são executados em segundo plano para criptografar e fazer backup de quaisquer novas fotos que você clique';

  @override
  String get loadMessage8 => 'web.ente.io tem um envio mais rápido';

  @override
  String get loadMessage9 =>
      'Nós usamos Xchacha20Poly1305 para criptografar seus dados com segurança';

  @override
  String get photoDescriptions => 'Descrições das fotos';

  @override
  String get fileTypesAndNames => 'Tipos de arquivo e nomes';

  @override
  String get location => 'Localização';

  @override
  String get moments => 'Momentos';

  @override
  String get searchFaceEmptySection =>
      'As pessoas serão mostradas aqui quando a indexação estiver concluída';

  @override
  String get searchDatesEmptySection => 'Pesquisar por data, mês ou ano';

  @override
  String get searchLocationEmptySection =>
      'Fotos de grupo que estão sendo tiradas em algum raio da foto';

  @override
  String get searchPeopleEmptySection =>
      'Convide pessoas e verá todas as fotos partilhadas por elas aqui';

  @override
  String get searchAlbumsEmptySection => 'Álbuns';

  @override
  String get searchFileTypesAndNamesEmptySection => 'Tipos de arquivo e nomes';

  @override
  String get searchCaptionEmptySection =>
      'Adicione descrições como \"#trip\" nas informações das fotos para encontrá-las aqui rapidamente';

  @override
  String get language => 'Idioma';

  @override
  String get selectLanguage => 'Selecionar Idioma';

  @override
  String get locationName => 'Nome da localização';

  @override
  String get addLocation => 'Adicionar localização';

  @override
  String get groupNearbyPhotos => 'Agrupar fotos próximas';

  @override
  String get kiloMeterUnit => 'km';

  @override
  String get addLocationButton => 'Adicionar';

  @override
  String get radius => 'Raio';

  @override
  String get locationTagFeatureDescription =>
      'Uma etiqueta de localização agrupa todas as fotos que foram tiradas num determinado raio de uma fotografia';

  @override
  String get galleryMemoryLimitInfo => 'Até 1000 memórias mostradas na galeria';

  @override
  String get save => 'Guardar';

  @override
  String get centerPoint => 'Ponto central';

  @override
  String get pickCenterPoint => 'Escolha o ponto central';

  @override
  String get useSelectedPhoto => 'Utilizar foto selecionada';

  @override
  String get resetToDefault => 'Redefinir para o padrão';

  @override
  String get edit => 'Editar';

  @override
  String get deleteLocation => 'Apagar localização';

  @override
  String get rotateLeft => 'Rodar para a esquerda';

  @override
  String get flip => 'Inverter';

  @override
  String get rotateRight => 'Rodar para a direita';

  @override
  String get saveCopy => 'Guardar cópia';

  @override
  String get light => 'Claro';

  @override
  String get color => 'Cor';

  @override
  String get yesDiscardChanges => 'Sim, rejeitar alterações';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade =>
      'Pretende eliminar as edições que efectuou?';

  @override
  String get saving => 'A gravar...';

  @override
  String get editsSaved => 'Edição guardada';

  @override
  String get oopsCouldNotSaveEdits =>
      'Oops, não foi possível guardar as edições';

  @override
  String get distanceInKMUnit => 'km';

  @override
  String get dayToday => 'Hoje';

  @override
  String get dayYesterday => 'Ontem';

  @override
  String get storage => 'Armazenamento';

  @override
  String get usedSpace => 'Espaço utilizado';

  @override
  String get storageBreakupFamily => 'Família';

  @override
  String get storageBreakupYou => 'Tu';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return '$usedAmount $usedStorageUnit de $totalAmount $totalStorageUnit usado';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return '$freeAmount $storageUnit grátis';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'Versão: $versionValue';
  }

  @override
  String get verifyIDLabel => 'Verificar';

  @override
  String get fileInfoAddDescHint => 'Acrescente uma descrição...';

  @override
  String get editLocationTagTitle => 'Editar localização';

  @override
  String get setLabel => 'Definir';

  @override
  String get setRadius => 'Definir raio';

  @override
  String get familyPlanPortalTitle => 'Família';

  @override
  String get familyPlanOverview =>
      'Adicione 5 membros da família ao seu plano existente sem pagar mais.\n\n\nCada membro tem o seu próprio espaço privado e não pode ver os ficheiros dos outros, a menos que sejam partilhados.\n\n\nOs planos familiares estão disponíveis para clientes que tenham uma subscrição paga do Ente.\n\n\nSubscreva agora para começar!';

  @override
  String get androidBiometricHint => 'Verificar identidade';

  @override
  String get androidBiometricNotRecognized =>
      'Não reconhecido. Tente novamente.';

  @override
  String get androidBiometricSuccess => 'Sucesso';

  @override
  String get androidCancelButton => 'Cancelar';

  @override
  String get androidSignInTitle => 'Autenticação necessária';

  @override
  String get androidBiometricRequiredTitle => 'Biometria necessária';

  @override
  String get androidDeviceCredentialsRequiredTitle =>
      'Credenciais do dispositivo são necessárias';

  @override
  String get androidDeviceCredentialsSetupDescription =>
      'Credenciais do dispositivo necessárias';

  @override
  String get goToSettings => 'Ir para as definições';

  @override
  String get androidGoToSettingsDescription =>
      'A autenticação biométrica não está configurada no seu dispositivo. Vá a “Definições > Segurança” para adicionar a autenticação biométrica.';

  @override
  String get iOSLockOut =>
      'A autenticação biométrica está desativada. Por favor, bloqueie e desbloqueie o ecrã para ativá-la.';

  @override
  String get iOSGoToSettingsDescription =>
      'A autenticação biométrica não está configurada no seu dispositivo. Active o Touch ID ou o Face ID no seu telemóvel.';

  @override
  String get iOSOkButton => 'OK';

  @override
  String get openstreetmapContributors => 'Contribuidores do OpenStreetMap';

  @override
  String get hostedAtOsmFrance => 'Hospedado na OSM France';

  @override
  String get map => 'Mapa';

  @override
  String get maps => 'Mapas';

  @override
  String get enableMaps => 'Ativar mapas';

  @override
  String get quickLinks => 'Links rápidos';

  @override
  String get selectItemsToAdd => 'Selecionar itens para adicionar';

  @override
  String get addSelected => 'Adicionar selecionados';

  @override
  String get addFromDevice => 'Adicionar a partir do dispositivo';

  @override
  String get addPhotos => 'Adicionar fotos';

  @override
  String get noPhotosFoundHere => 'Nenhuma foto encontrada aqui';

  @override
  String get zoomOutToSeePhotos => 'Diminuir o zoom para ver fotos';

  @override
  String get noImagesWithLocation => 'Nenhuma imagem com localização';

  @override
  String get unpinAlbum => 'Desafixar álbum';

  @override
  String get pinAlbum => 'Fixar álbum';

  @override
  String get create => 'Criar';

  @override
  String get viewAll => 'Ver tudo';

  @override
  String get nothingSharedWithYouYet => 'Ainda nada partilhado consigo';

  @override
  String get noAlbumsSharedByYouYet => 'Ainda não há álbuns partilhados por si';

  @override
  String get sharedWithYou => 'Partilhado consigo';

  @override
  String get sharedByYou => 'Partilhado por si';

  @override
  String get inviteYourFriendsToEnte => 'Convide seus amigos para o Ente';

  @override
  String get failedToDownloadVideo => 'Falha ao fazer o download do vídeo';

  @override
  String get hiding => 'Ocultando...';

  @override
  String get unhiding => 'Reexibindo...';

  @override
  String get successfullyHid => 'Ocultado com sucesso';

  @override
  String get successfullyUnhid => 'Reexibido com sucesso';

  @override
  String get crashReporting => 'Relatório de falhas';

  @override
  String get resumableUploads => 'Uploads reenviados';

  @override
  String get addToHiddenAlbum => 'Adicionar a álbum oculto';

  @override
  String get moveToHiddenAlbum => 'Mover para álbum oculto';

  @override
  String get fileTypes => 'Tipos de arquivo';

  @override
  String get deleteConfirmDialogBody =>
      'Esta conta está ligada a outras aplicações Ente, se utilizar alguma. Os seus dados carregados, em todas as aplicações Ente, serão agendados para eliminação e a sua conta será permanentemente eliminada.';

  @override
  String get hearUsWhereTitle => 'Como é que soube do Ente? (opcional)';

  @override
  String get hearUsExplanation =>
      'Não monitorizamos as instalações de aplicações. Ajudaria se nos dissesse onde nos encontrou!';

  @override
  String get viewAddOnButton => 'Ver addons';

  @override
  String get addOns => 'addons';

  @override
  String get addOnPageSubtitle => 'Detalhes dos addons';

  @override
  String get yourMap => 'Seu mapa';

  @override
  String get modifyYourQueryOrTrySearchingFor =>
      'Modifique a sua consulta ou tente pesquisar por';

  @override
  String get blackFridaySale => 'Promoção Black Friday';

  @override
  String get upto50OffUntil4thDec => 'Até 50% de desconto, até 4 de dezembro.';

  @override
  String get photos => 'Fotos';

  @override
  String get videos => 'Vídeos';

  @override
  String get livePhotos => 'Fotos Em Tempo Real';

  @override
  String get searchHint1 => 'Pesquisa rápida no dispositivo';

  @override
  String get searchHint2 => 'Datas das fotos, descrições';

  @override
  String get searchHint3 => 'Álbuns, nomes de arquivos e tipos';

  @override
  String get searchHint4 => 'Local';

  @override
  String get searchHint5 => 'Em breve: Rostos e pesquisa mágica ✨';

  @override
  String get addYourPhotosNow => 'Adicione suas fotos agora';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count anos atrás',
      one: '$count ano atrás',
    );
    return '$_temp0';
  }

  @override
  String get faces => 'Rostos';

  @override
  String get people => 'Pessoas';

  @override
  String get contents => 'Conteúdos';

  @override
  String get addNew => 'Adicionar novo';

  @override
  String get contacts => 'Contactos';

  @override
  String get noInternetConnection => 'Sem ligação à internet';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'Por favor, verifique a sua ligação à Internet e tente novamente.';

  @override
  String get signOutFromOtherDevices => 'Terminar sessão noutros dispositivos';

  @override
  String get signOutOtherBody =>
      'Se pensa que alguém pode saber a sua palavra-passe, pode forçar todos os outros dispositivos que utilizam a sua conta a terminar a sessão.';

  @override
  String get signOutOtherDevices => 'Terminar a sessão noutros dispositivos';

  @override
  String get doNotSignOut => 'Não terminar a sessão';

  @override
  String get editLocation => 'Editar localização';

  @override
  String get selectALocation => 'Selecione uma localização';

  @override
  String get selectALocationFirst => 'Selecione uma localização primeiro';

  @override
  String get changeLocationOfSelectedItems =>
      'Alterar a localização dos itens selecionados?';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte =>
      'Edições para localização só serão vistas dentro do Ente';

  @override
  String get cleanUncategorized => 'Limpar sem categoria';

  @override
  String get cleanUncategorizedDescription =>
      'Remover todos os arquivos da Não Categorizados que estão presentes em outros álbuns';

  @override
  String get waitingForVerification => 'Aguardando verificação...';

  @override
  String get passkey => 'Chave de acesso';

  @override
  String get passkeyAuthTitle => 'Verificação da chave de acesso';

  @override
  String get loginWithTOTP => 'Iniciar sessão com TOTP';

  @override
  String get passKeyPendingVerification => 'A verificação ainda está pendente';

  @override
  String get loginSessionExpired => 'Sessão expirada';

  @override
  String get loginSessionExpiredDetails =>
      'A sua sessão expirou. Por favor, inicie sessão novamente.';

  @override
  String get verifyPasskey => 'Verificar chave de acesso';

  @override
  String get playOnTv => 'Reproduzir álbum na TV';

  @override
  String get pair => 'Emparelhar';

  @override
  String get deviceNotFound => 'Dispositivo não encontrado';

  @override
  String get castInstruction =>
      'Visite cast.ente.io no dispositivo que pretende emparelhar.\n\n\nIntroduza o código abaixo para reproduzir o álbum na sua TV.';

  @override
  String get deviceCodeHint => 'Introduza o código';

  @override
  String get joinDiscord => 'Juntar-se ao Discord';

  @override
  String get locations => 'Localizações';

  @override
  String get addAName => 'Adiciona um nome';

  @override
  String get findThemQuickly => 'Ache-os rapidamente';

  @override
  String get findPeopleByName => 'Encontrar pessoas rapidamente pelo nome';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Adicionar vizualizadores',
      one: 'Adicionar visualizador',
      zero: 'Adicionar visualizador',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Adicionar colaboradores',
      one: 'Adicionar colaborador',
      zero: 'Adicionar colaborador',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      'Pressione e segure um e-mail para verificar a criptografia de ponta a ponta.';

  @override
  String get developerSettingsWarning =>
      'Tem a certeza de que pretende modificar as definições de programador?';

  @override
  String get developerSettings => 'Definições do programador';

  @override
  String get serverEndpoint => 'Endpoint do servidor';

  @override
  String get invalidEndpoint => 'Endpoint inválido';

  @override
  String get invalidEndpointMessage =>
      'Desculpe, o endpoint que introduziu é inválido. Introduza um ponto final válido e tente novamente.';

  @override
  String get endpointUpdatedMessage => 'Endpoint atualizado com sucesso';

  @override
  String customEndpoint({required Object endpoint}) {
    return 'Conectado a $endpoint';
  }

  @override
  String get createCollaborativeLink => 'Criar link colaborativo';

  @override
  String get search => 'Pesquisar';

  @override
  String get enterPersonName => 'Inserir nome da pessoa';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'Este e-mail já está ligado a $name.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return 'Ver $name para desligar';
  }

  @override
  String get enterName => 'Inserir nome';

  @override
  String get savePerson => 'Guardar pessoa';

  @override
  String get editPerson => 'Editar pessoa';

  @override
  String get mergedPhotos => 'Fotos combinadas';

  @override
  String get orMergeWithExistingPerson => 'Ou combinar com já existente';

  @override
  String get enterDateOfBirth => 'Aniversário (opcional)';

  @override
  String get birthday => 'Aniversário';

  @override
  String get removePersonLabel => 'Remover etiqueta da pessoa';

  @override
  String get autoPairDesc =>
      'O pareamento automático funciona apenas com dispositivos que suportam o Chromecast.';

  @override
  String get manualPairDesc =>
      'Emparelhar com PIN funciona com qualquer ecrã onde pretenda ver o seu álbum.';

  @override
  String get connectToDevice => 'Ligar ao dispositivo';

  @override
  String get autoCastDialogBody =>
      'Verá os dispositivos Cast disponíveis aqui.';

  @override
  String get autoCastiOSPermission =>
      'Certifique-se de que as permissões de Rede local estão activadas para a aplicação Ente Photos, nas Definições.';

  @override
  String get noDeviceFound => 'Nenhum dispositivo encontrado';

  @override
  String get stopCastingTitle => 'Parar transmissão';

  @override
  String get stopCastingBody => 'Queres parar de fazer transmissão?';

  @override
  String get castIPMismatchTitle => 'Falha ao transmitir álbum';

  @override
  String get castIPMismatchBody =>
      'Certifique-se de estar na mesma rede que a TV.';

  @override
  String get pairingComplete => 'Emparelhamento concluído';

  @override
  String get savingEdits => 'Gravando edições...';

  @override
  String get autoPair => 'Emparelhamento automático';

  @override
  String get pairWithPin => 'Emparelhar com PIN';

  @override
  String get faceRecognition => 'Reconhecimento facial';

  @override
  String get foundFaces => 'Rostos encontrados';

  @override
  String get clusteringProgress => 'Progresso de agrupamento';

  @override
  String get trim => 'Cortar';

  @override
  String get crop => 'Recortar';

  @override
  String get rotate => 'Rodar';

  @override
  String get left => 'Esquerda';

  @override
  String get right => 'Direita';

  @override
  String get whatsNew => 'O que há de novo';

  @override
  String get reviewSuggestions => 'Revisar sugestões';

  @override
  String get review => 'Rever';

  @override
  String get useAsCover => 'Usar como capa';

  @override
  String notPersonLabel({required String name}) {
    return 'Não é $name?';
  }

  @override
  String get enable => 'Ativar';

  @override
  String get enabled => 'Ativado';

  @override
  String get moreDetails => 'Mais detalhes';

  @override
  String get enableMLIndexingDesc =>
      'O Ente suporta a aprendizagem automática no dispositivo para reconhecimento facial, pesquisa mágica e outras funcionalidades de pesquisa avançadas';

  @override
  String get magicSearchHint =>
      'A pesquisa mágica permite pesquisar fotos por seu conteúdo, por exemplo, \'flor\', \'carro vermelho\', \'documentos de identidade\'';

  @override
  String get panorama => 'Panorama';

  @override
  String get reenterPassword => 'Insira novamente a palavra-passe';

  @override
  String get reenterPin => 'Inserir PIN novamente';

  @override
  String get deviceLock => 'Bloqueio do dispositivo';

  @override
  String get pinLock => 'Bloqueio por PIN';

  @override
  String get next => 'Seguinte';

  @override
  String get setNewPassword => 'Definir nova palavra-passe';

  @override
  String get enterPin => 'Introduzir PIN';

  @override
  String get setNewPin => 'Definir novo PIN';

  @override
  String get appLock => 'Bloqueio de app';

  @override
  String get noSystemLockFound => 'Nenhum bloqueio de sistema encontrado';

  @override
  String get tapToUnlock => 'Toque para desbloquear';

  @override
  String get tooManyIncorrectAttempts => 'Muitas tentativas incorretas';

  @override
  String get videoInfo => 'Informação de Vídeo';

  @override
  String get autoLock => 'Bloqueio automático';

  @override
  String get immediately => 'Imediatamente';

  @override
  String get autoLockFeatureDescription =>
      'Tempo após o qual a aplicação bloqueia depois de ser colocada em segundo plano';

  @override
  String get hideContent => 'Ocultar conteúdo';

  @override
  String get hideContentDescriptionAndroid =>
      'Oculta o conteúdo da aplicação no alternador de aplicações e desactiva as capturas de ecrã';

  @override
  String get hideContentDescriptionIos =>
      'Oculta o conteúdo da aplicação no alternador de aplicações';

  @override
  String get passwordStrengthInfo =>
      'A força da palavra-passe é calculada tendo em conta o comprimento da palavra-passe, os caracteres utilizados e se a palavra-passe aparece ou não nas 10.000 palavras-passe mais utilizadas';

  @override
  String get noQuickLinksSelected => 'Nenhum link rápido selecionado';

  @override
  String get pleaseSelectQuickLinksToRemove =>
      'Selecione links rápidos para remover';

  @override
  String get removePublicLinks => 'Remover link público';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      'Isto removerá links públicos de todos os links rápidos selecionados.';

  @override
  String get guestView => 'Visão de convidado';

  @override
  String get guestViewEnablePreSteps =>
      'Para ativar a vista de convidado, configure o código de acesso do dispositivo ou o bloqueio do ecrã nas definições do sistema.';

  @override
  String get nameTheAlbum => 'Nomear o álbum';

  @override
  String get collectPhotosDescription =>
      'Crie um link onde seus amigos podem enviar fotos na qualidade original.';

  @override
  String get collect => 'Recolher';

  @override
  String get appLockDescriptions =>
      'Escolha entre o ecrã de bloqueio predefinido do seu dispositivo e um ecrã de bloqueio personalizado com um PIN ou uma palavra-passe.';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'Para ativar o bloqueio de aplicações, configure o código de acesso do dispositivo ou o bloqueio de ecrã nas definições do sistema.';

  @override
  String get authToViewPasskey =>
      'Autentique-se para ver a sua chave de acesso';

  @override
  String get localSyncErrorMessage =>
      'Parece que algo correu mal, uma vez que a sincronização de fotografias locais está a demorar mais tempo do que o esperado. Contacte a nossa equipa de apoio';

  @override
  String get showPerson => 'Mostrar pessoa';

  @override
  String get sort => 'Ordenar';

  @override
  String get mostRecent => 'Mais recente';

  @override
  String get mostRelevant => 'Mais relevante';

  @override
  String get loadingYourPhotos => 'Carregar as suas fotos...';

  @override
  String processingImport({required Object folderName}) {
    return 'Processando $folderName...';
  }

  @override
  String get personName => 'Nome da pessoa';

  @override
  String get addNewPerson => 'Adicionar nova pessoa';

  @override
  String get addNameOrMerge => 'Adicionar nome ou juntar';

  @override
  String get mergeWithExisting => 'Juntar com o existente';

  @override
  String get newPerson => 'Nova pessoa';

  @override
  String get addName => 'Adicionar pessoa';

  @override
  String get add => 'Adicionar';

  @override
  String extraPhotosFoundFor({required String text}) {
    return 'Fotos extras encontradas para $text';
  }

  @override
  String get extraPhotosFound => 'Fotos adicionais encontradas';

  @override
  String get configuration => 'Configuração';

  @override
  String get localIndexing => 'Indexação local';

  @override
  String get processed => 'Processado';

  @override
  String get resetPerson => 'Remover';

  @override
  String get areYouSureYouWantToResetThisPerson =>
      'Tens a certeza de que queres repor esta pessoa?';

  @override
  String get allPersonGroupingWillReset =>
      'Todos os agrupamentos para esta pessoa serão reiniciados e perderá todas as sugestões feitas para esta pessoa';

  @override
  String get yesResetPerson => 'Sim, repor pessoa';

  @override
  String get onlyThem => 'Apenas eles';

  @override
  String get checkingModels => 'A verificar modelos...';

  @override
  String get enableMachineLearningBanner =>
      'Habilitar aprendizagem automática para pesquisa mágica e reconhecimento de rosto';

  @override
  String get searchDiscoverEmptySection =>
      'As imagens aparecerão aqui caso o processamento e sincronização for concluído';

  @override
  String get searchPersonsEmptySection =>
      'As pessoas aparecerão aqui caso o processamento e sincronização for concluído';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Adicionado $count visualizadores',
      one: 'Adicionado 1 visualizador',
      zero: 'Adicionado 0 vizualizadores',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Adicionado $count colaboradores',
      one: 'Adicionado 1 colaborador',
      zero: 'Adicionado 0 colaboradores',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured => 'A conta já está ajustada.';

  @override
  String get sessionIdMismatch => 'Incompatibilidade de ID de sessão';

  @override
  String get failedToFetchActiveSessions =>
      'Falha ao obter sessões em atividade';

  @override
  String get failedToRefreshStripeSubscription =>
      'Falha ao atualizar subscrição';

  @override
  String get failedToPlayVideo => 'Falha ao reproduzir multimédia';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return 'Envio ignorado devido à $ignoreReason';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'Tipo de galeria $galleryType não é permitido para renomear';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'Clique para enviar, o envio foi ignorado devido a $ignoreReason';
  }

  @override
  String get tapToUpload => 'Clique para enviar';

  @override
  String get info => 'Info';

  @override
  String get addFiles => 'Adicionar Ficheiros';

  @override
  String get castAlbum => 'Transferir Álbum';

  @override
  String get imageNotAnalyzed => 'Imagem sem análise';

  @override
  String get noFacesFound => 'Nenhum rosto foi detetado';

  @override
  String get fileNotUploadedYet => 'Ficheiro não enviado ainda';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return 'Sem sugestões para $personName';
  }

  @override
  String get month => 'mês';

  @override
  String get yearShort => 'ano';

  @override
  String get currentlyRunning => 'em execução';

  @override
  String get ignored => 'ignorado';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count fotos',
      one: '1 foto',
      zero: '0 fotos',
    );
    return '$_temp0';
  }

  @override
  String get file => 'Ficheiro';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'Desigualdade de Largura entre Seções: $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'Selecione Aplicação de Correios';

  @override
  String get selectAllShort => 'Tudo';

  @override
  String get selectCoverPhoto => 'Selecionar Foto para Capa';

  @override
  String get newLocation => 'Novo Lugar';

  @override
  String get faceNotClusteredYet =>
      'Rosto não aglomerado ainda, retome mais tarde';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'A ligação que está a tentar acessar já expirou.';

  @override
  String get openFile => 'Abrir o Ficheiro';

  @override
  String get backupFile => 'Backup de Ficheiro';

  @override
  String get openAlbumInBrowser => 'Abrir o Álbum em Navegador';

  @override
  String get openAlbumInBrowserTitle =>
      'Utilize a Aplicação de Web Sítio para adicionar fotos ao álbum';

  @override
  String get allow => 'Permitir';

  @override
  String get allowAppToOpenSharedAlbumLinks =>
      'Permitir Aplicação Abrir Ligações Partilhadas';

  @override
  String get seePublicAlbumLinksInApp => 'Ver Ligações Públicas na Aplicação';

  @override
  String get emergencyContacts => 'Contactos de Emergência';

  @override
  String get acceptTrustInvite => 'Aceite o Convite';

  @override
  String get declineTrustInvite => 'Dispense o Convite';

  @override
  String get removeYourselfAsTrustedContact =>
      'Retirar-vos dos contactos de confiança';

  @override
  String get legacy => 'Revivência';

  @override
  String get legacyPageDesc =>
      'A Revivência permite que contactos de confiança acessem a sua conta na sua inatividade.';

  @override
  String get legacyPageDesc2 =>
      'Contactos de confiança podem restaurar a sua conta, e se não lhes impedir em 30 dias, redefine a sua palavra-passe e acesse a sua conta.';

  @override
  String get legacyAccounts => 'Contas revividas';

  @override
  String get trustedContacts => 'Contactos de Confiança';

  @override
  String get addTrustedContact => 'Adicionar Contacto de Confiança';

  @override
  String get removeInvite => 'Retirar convite';

  @override
  String get recoveryWarning =>
      'Um contacto de confiança está a tentar acessar a sua conta';

  @override
  String get rejectRecovery => 'Recusar recuperação';

  @override
  String get recoveryInitiated => 'Recuperação iniciada';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return 'Pode acessar a conta após $days dias. Uma notificação será enviada para $email.';
  }

  @override
  String get cancelAccountRecovery => 'Cancelar recuperação';

  @override
  String get recoveryAccount => 'Recuperar Conta';

  @override
  String get cancelAccountRecoveryBody => 'Quer mesmo cancelar a recuperação?';

  @override
  String get startAccountRecoveryTitle => 'Começar Recuperação';

  @override
  String get whyAddTrustContact =>
      'O contacto de confiança pode ajudar na recuperação dos seus dados.';

  @override
  String recoveryReady({required String email}) {
    return 'Agora pode recuperar a conta de $email definindo uma nova palavra-passe.';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email está a tentar recuperar a sua conta.';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return 'Foste convidado para ser um contacto revivido de $email.';
  }

  @override
  String get warning => 'Alerta';

  @override
  String get proceed => 'Continuar';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return 'Está prestes a adicionar $email como contacto de confiança. Eles poderão recuperar a sua conta caso esteja inativo por $numOfDays dias.';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email convidou-lhe a ser um contacto de confiança';
  }

  @override
  String get authToManageLegacy =>
      'Autentica-se para gerir os seus contactos de confiança';

  @override
  String get hideSharedItemsFromHomeGallery =>
      'Esconder Itens Partilhados da Galeria Inicial';

  @override
  String get gallery => 'Galeria';

  @override
  String get joinAlbum => 'Aderir ao Álbum';

  @override
  String get joinAlbumSubtext => 'para ver e adicionar as suas fotos';

  @override
  String get joinAlbumSubtextViewer =>
      'para adicionar isto aos álbuns partilhados';

  @override
  String get join => 'Aderir';

  @override
  String get linkEmail => 'Ligar e-mail';

  @override
  String get link => 'Ligar';

  @override
  String get noEnteAccountExclamation => 'Nenhuma conta do Ente!';

  @override
  String get orPickFromYourContacts => 'ou selecione dos seus contactos';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return '$email não há uma conta no Ente.';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (Eu)';
  }

  @override
  String get reassignMe => 'Retribua \"Mim\"';

  @override
  String get me => 'Eu';

  @override
  String get linkEmailToContactBannerCaption => 'para partilha ágil';

  @override
  String get selectPersonToLink => 'Selecione uma pessoa para ligar-se';

  @override
  String linkPersonToEmail({required String email}) {
    return 'Ligar pessoa a $email';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return 'Isto ligará $personName a $email';
  }

  @override
  String get selectYourFace => 'Selecionar o seu rosto';

  @override
  String get reassigningLoading => 'A retribuir...';

  @override
  String reassignedToName({required String name}) {
    return 'Retribuiu tu a $name';
  }

  @override
  String get saveChangesBeforeLeavingQuestion =>
      'Guardar as alterações antes de sair?';

  @override
  String get dontSave => 'Não guarde';

  @override
  String get thisIsMeExclamation => 'Este sou eu!';

  @override
  String get linkPerson => 'Ligar pessoa';

  @override
  String get linkPersonCaption => 'para melhor experiência de partilha';

  @override
  String get videoStreaming => 'Vídeos transmissíveis';

  @override
  String get processingVideos => 'A processar vídeos';

  @override
  String get streamDetails => 'Detalhes do em direto';

  @override
  String get processing => 'A processar';

  @override
  String get queued => 'Em fila';

  @override
  String get ineligible => 'Inelegível';

  @override
  String get failed => 'Falha';

  @override
  String get playStream => 'Ver em direto';

  @override
  String get playOriginal => 'Ver original';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'Aderir a um álbum fará o seu e-mail visível aos participantes.';

  @override
  String get pleaseWaitThisWillTakeAWhile =>
      'Espera um pouco, isto deve levar um tempo.';

  @override
  String get editTime => 'Editar tempo';

  @override
  String get selectTime => 'Selecionar tempo';

  @override
  String get selectDate => 'Selecionar data';

  @override
  String get previous => 'Anterior';

  @override
  String get selectOneDateAndTimeForAll => 'Selecionar uma data e hora a todos';

  @override
  String get selectStartOfRange => 'Selecionar início de intervalo';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      'Isto fará a data e hora de todas as fotos o mesmo.';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'Este é o primeiro neste grupo. Outras fotos selecionadas serão automaticamente alteradas para a nova data';

  @override
  String get newRange => 'Novo intervalo';

  @override
  String get selectOneDateAndTime => 'Selecione uma Data e Hora';

  @override
  String get moveSelectedPhotosToOneDate =>
      'Alterar datas de Fotos ao Selecionado';

  @override
  String get shiftDatesAndTime => 'Mude as Datas e Horas';

  @override
  String get photosKeepRelativeTimeDifference =>
      'As Fotos continuam com uma diferença de horário relativo';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count fotos',
      one: '1 foto',
      zero: 'Sem fotos',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'Ícone da Aplicação';

  @override
  String get notThisPerson => 'Não é esta pessoa?';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      'Os itens em seleção serão removidos desta pessoa, mas não da sua biblioteca.';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat com o avanço dos anos';
  }

  @override
  String get thisWeekThroughTheYears => 'Esta semana com o avanço dos anos';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Esta semana, $count anos atrás',
      one: 'Esta semana, $count ano atrás',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'Tu e $name';
  }

  @override
  String admiringThem({required Object name}) {
    return 'A admirar $name';
  }

  @override
  String embracingThem({required Object name}) {
    return 'A abraçar $name';
  }

  @override
  String partyWithThem({required Object name}) {
    return 'Tendo uma festa com $name';
  }

  @override
  String hikingWithThem({required Object name}) {
    return 'Passeando com $name';
  }

  @override
  String feastingWithThem({required Object name}) {
    return 'A comer com $name';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return 'A captar selfies com $name';
  }

  @override
  String posingWithThem({required Object name}) {
    return 'A posicionar com $name';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return 'Vistas deslumbrantes com $name';
  }

  @override
  String sportsWithThem({required Object name}) {
    return 'A praticar esportes com $name';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return 'A viajar na rua com $name';
  }

  @override
  String get spotlightOnYourself => 'A dar destaque em vos';

  @override
  String spotlightOnThem({required Object name}) {
    return 'A dar destaque em $name';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$name tem $age anos!';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name fará $age anos em breve';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return 'Últimos momentos com $name';
  }

  @override
  String tripToLocation({required Object location}) {
    return 'Viagem para $location';
  }

  @override
  String tripInYear({required Object year}) {
    return 'Viajem em $year';
  }

  @override
  String get lastYearsTrip => 'Viagem do ano passado';

  @override
  String get sunrise => 'No horizonte';

  @override
  String get mountains => 'Sobre as colinas';

  @override
  String get greenery => 'A vida esverdeada';

  @override
  String get beach => 'A areia e o mar';

  @override
  String get city => 'Na cidade';

  @override
  String get moon => 'Na luz da lua';

  @override
  String get onTheRoad => 'Na rua de novo';

  @override
  String get food => 'Culinária saborosa';

  @override
  String get pets => 'Acompanhantes peludos';

  @override
  String get curatedMemories => 'Memórias curadas';

  @override
  String get widgets => 'Widgets';

  @override
  String get memories => 'Memórias';

  @override
  String get peopleWidgetDesc =>
      'Seleciona as pessoas que adoraria ver no seu ecrã inicial.';

  @override
  String get albumsWidgetDesc =>
      'Seleciona os álbuns que adoraria ver no seu ecrã inicial.';

  @override
  String get memoriesWidgetDesc =>
      'Seleciona os tipos de memórias que adoraria ver no seu ecrã inicial.';

  @override
  String get smartMemories => 'Memórias inteligentes';

  @override
  String get pastYearsMemories => 'Memórias de anos passados';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return 'Também eliminar fotos (e vídeos) presentes em $count álbuns e de <bold>todos</bold> os outros álbuns que fazem parte?';
  }

  @override
  String get addParticipants => 'Adicionar participante';

  @override
  String selectedAlbums({required Object count}) {
    return '$count selecionado(s)';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'Ação não suportada no álbum de Preferidos';

  @override
  String get onThisDayMemories => 'Memórias deste dia';

  @override
  String get onThisDay => 'Neste dia';

  @override
  String get lookBackOnYourMemories => 'Revê as suas memórias 🌄';

  @override
  String get newPhotosEmoji => ' novo 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'Perdão, precisamos parar seus backups';

  @override
  String get clickToInstallOurBestVersionYet =>
      'Clica para transferir a melhor versão';

  @override
  String get onThisDayNotificationExplanation =>
      'Obtém lembretes de memórias deste dia em anos passados.';

  @override
  String get addMemoriesWidgetPrompt =>
      'Adiciona um widget de memórias no seu ecrã inicial e volte aqui para personalizar.';

  @override
  String get addAlbumWidgetPrompt =>
      'Adiciona um widget de álbum no seu ecrã inicial e volte aqui para personalizar.';

  @override
  String get addPeopleWidgetPrompt =>
      'Adiciona um widget de pessoas no seu ecrã inicial e volte aqui para personalizar.';

  @override
  String get birthdayNotifications => 'Notificações de felicidades';

  @override
  String get receiveRemindersOnBirthdays =>
      'Obtém lembretes de quando é aniversário de alguém. Apertar na notificação o levará às fotos do aniversariante.';

  @override
  String get happyBirthday => 'Felicidades! 🥳';

  @override
  String get birthdays => 'Aniversários';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return 'Envie um \"Felicidades\" a $name! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      'Tem a certeza que queira remover o rosto desta pessoa?';

  @override
  String get otherDetectedFaces => 'Outros rostos detetados';

  @override
  String get areThey => 'Eles são ';

  @override
  String get questionmark => '?';

  @override
  String get saveAsAnotherPerson => 'Guardar como outra pessoa';

  @override
  String get showLessFaces => 'Mostrar menos rostos';

  @override
  String get showMoreFaces => 'Mostrar mais rostos';

  @override
  String get ignore => 'Ignorar';

  @override
  String get merge => 'Fundir';

  @override
  String get reset => 'Redefinir';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      'Tem a certeza que quer ignorar esta pessoa?';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      'Tem a certeza que quer ignorar estas pessoas?';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'Os grupos de pessoa não aparecerão mais na secção de pessoas. As Fotos permanecerão intocadas.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'As pessoas não aparecerão mais na secção de pessoas. As fotos permanecerão intocadas.';

  @override
  String get areYouSureYouWantToMergeThem =>
      'Tem a certeza que quer fundi-los?';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'Todos os grupos sem título serão fundidos na pessoa selecionada. Isso pode ser desfeito no histórico geral das sugestões da pessoa.';

  @override
  String get yesIgnore => 'Sim, ignorar';

  @override
  String get same => 'Igual';

  @override
  String get different => 'Diferente';

  @override
  String get sameperson => 'A mesma pessoa?';

  @override
  String get indexingPausedStatusDescription =>
      'A indexação foi interrompida. Ele será retomado se o dispositivo estiver pronto. O dispositivo é considerado pronto se o nível de bateria, saúde da bateria, e estado térmico esteja num estado saudável.';

  @override
  String get thisWeek => 'Esta semana';

  @override
  String get lastWeek => 'Semana passada';

  @override
  String get thisMonth => 'Este mês';

  @override
  String get thisYear => 'Este ano';

  @override
  String get groupBy => 'Agrupar por';

  @override
  String get faceThumbnailGenerationFailed =>
      'Impossível gerar thumbnails de rosto';

  @override
  String get fileAnalysisFailed => 'Impossível analisar arquivo';

  @override
  String get editAutoAddPeople => 'Editar auto adição de pessoas';

  @override
  String get autoAddPeople => 'Auto adicionar pessoas';

  @override
  String get autoAddToAlbum => 'Auto adicionar ao álbum';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      'Deve eliminar os ficheiros relacionados à pessoa selecionada anteriormente nos álbuns inteligentes?';

  @override
  String get addingPhotos => 'A adicionar fotos';

  @override
  String get gettingReady => 'A preparar';

  @override
  String get addSomePhotosDesc1 => 'Adicione algumas fotos ou selecione ';

  @override
  String get addSomePhotosDesc2 => 'rostos familiares';

  @override
  String get addSomePhotosDesc3 => 'para iniciar com';

  @override
  String get ignorePerson => 'Ignorar pessoa';

  @override
  String get mixedGrouping => 'Agrupamento misturado?';

  @override
  String get analysis => 'Análise';

  @override
  String get doesGroupContainMultiplePeople =>
      'Este agrupamento tem várias pessoas?';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'Nós iremos analisar automaticamente o agrupamento para determinar se há várias pessoas presentes, e separá-las de novo. Isto levará alguns instantes.';

  @override
  String get layout => 'Layout';

  @override
  String get day => 'Dia';

  @override
  String get undo => ' Desfazer ';

  @override
  String get redo => 'Refazer';

  @override
  String get filter => 'Filtrar';

  @override
  String get adjust => 'Ajuste';

  @override
  String get draw => 'Desenho';

  @override
  String get sticker => 'Autocolante';

  @override
  String get brushColor => 'Cor do pincel';

  @override
  String get font => 'Fonte';

  @override
  String get background => 'Fundo';

  @override
  String get align => 'Alinhar';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Adicionado com sucesso a $count álbuns',
      one: 'Adicionado com sucesso a 1 álbum',
    );
    return '$_temp0';
  }
}
