// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Polish (`pl`).
class AppLocalizationsPl extends AppLocalizations {
  AppLocalizationsPl([String locale = 'pl']) : super(locale);

  @override
  String get enterYourEmailAddress => 'Podaj swój adres e-mail';

  @override
  String get enterYourNewEmailAddress => 'Podaj swój nowy adres e-mail';

  @override
  String get accountWelcomeBack => 'Witaj ponownie!';

  @override
  String get emailAlreadyRegistered => 'Adres e-mail jest już zarejestrowany.';

  @override
  String get emailNotRegistered => 'Adres e-mail nie jest zarejestrowany.';

  @override
  String get email => 'Adres e-mail';

  @override
  String get cancel => 'Anuluj';

  @override
  String get verify => 'Zweryfikuj';

  @override
  String get invalidEmailAddress => 'Nieprawidłowy adres e-mail';

  @override
  String get enterValidEmail => 'Prosimy podać prawidłowy adres e-mail.';

  @override
  String get deleteAccount => 'Usuń konto';

  @override
  String get deleteAccountWarning =>
      'This will delete your Ente Auth, Ente Photos and Ente Locker account.';

  @override
  String get askDeleteReason =>
      'Jaka jest główna przyczyna usunięcia Twojego konta?';

  @override
  String get deleteAccountFeedbackPrompt =>
      'Przykro nam, że odchodzisz. Wyjaśnij nam, dlaczego nas opuszczasz, aby pomóc ulepszać nasze usługi.';

  @override
  String get feedback => 'Opinia';

  @override
  String get kindlyHelpUsWithThisInformation => 'Pomóż nam z tą informacją';

  @override
  String get confirmDeletePrompt =>
      'Tak, chcę trwale usunąć to konto i jego dane ze wszystkich aplikacji.';

  @override
  String get confirmAccountDeletion => 'Potwierdź usunięcie konta';

  @override
  String get deleteAccountPermanentlyButton => 'Usuń konto na stałe';

  @override
  String get yourAccountHasBeenDeleted => 'Twoje konto zostało usunięte';

  @override
  String get selectReason => 'Wybierz powód';

  @override
  String get deleteReason1 => 'Brakuje kluczowej funkcji, której potrzebuję';

  @override
  String get deleteReason2 =>
      'Aplikacja lub określona funkcja nie zachowuje się tak, jak sądzę, że powinna';

  @override
  String get deleteReason3 => 'Znalazłem/am inną, lepszą usługę';

  @override
  String get deleteReason4 => 'Moja przyczyna nie jest wymieniona';

  @override
  String get sendEmail => 'Wyślij e-mail';

  @override
  String get deleteRequestSLAText =>
      'Twoje żądanie zostanie przetworzone w ciągu 72 godzin.';

  @override
  String get deleteEmailRequest =>
      'Wyślij wiadomość e-mail na <warning>account-deletion@ente.io</warning> z zarejestrowanego adresu e-mail.';

  @override
  String get entePhotosPerm =>
      'Ente <i>potrzebuje uprawnień</i> aby przechowywać twoje zdjęcia';

  @override
  String get ok => 'Ok';

  @override
  String get createAccount => 'Stwórz konto';

  @override
  String get createNewAccount => 'Stwórz nowe konto';

  @override
  String get password => 'Hasło';

  @override
  String get confirmPassword => 'Powtórz hasło';

  @override
  String get activeSessions => 'Aktywne sesje';

  @override
  String get ocrProcessingOverlayMessage => 'Wykrywanie tekstu...';

  @override
  String get ocrLoadingIndicatorLabel => 'Wykrywanie Tekstu';

  @override
  String get ocrSelectionHint =>
      'Przesuń palcem lub dwukrotnie dotknij, aby zaznaczyć, to co potrzebujesz';

  @override
  String get ocrNoTextDetected => 'Nie wykryto tekstu';

  @override
  String get ocrRetryButtonLabel => 'Spróbuj ponownie';

  @override
  String get ocrModelsNetworkRequiredError =>
      'Wymagane połączenie sieciowe do pobrania modeli OCR przy pierwszym użyciu';

  @override
  String get ocrModelsPrepareFailed => 'Nie udało się przygotować modeli OCR';

  @override
  String get ocrImageNotFoundError => 'Nie znaleziono pliku obrazu';

  @override
  String get ocrImageDecodeFailedError => 'Nie udało się odczytać pliku obrazu';

  @override
  String get ocrGenericDetectError => 'Nie udało się wykryć tekstu w zdjęciu';

  @override
  String get oops => 'Ups';

  @override
  String get somethingWentWrongPleaseTryAgain =>
      'Coś poszło nie tak, spróbuj ponownie';

  @override
  String get thisWillLogYouOutOfThisDevice =>
      'To wyloguje Cię z tego urządzenia!';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice =>
      'To wyloguje Cię z tego urządzenia:';

  @override
  String get terminateSession => 'Zakończyć sesję?';

  @override
  String get terminate => 'Zakończ';

  @override
  String get thisDevice => 'To urządzenie';

  @override
  String get recoverButton => 'Odzyskaj';

  @override
  String get recoverySuccessful => 'Odzyskano pomyślnie!';

  @override
  String get decrypting => 'Odszyfrowanie...';

  @override
  String get incorrectRecoveryKeyTitle => 'Nieprawidłowy klucz odzyskiwania';

  @override
  String get incorrectRecoveryKeyBody => 'Kod jest nieprawidłowy';

  @override
  String get forgotPassword => 'Nie pamiętam hasła';

  @override
  String get enterYourRecoveryKey => 'Wprowadź swój klucz odzyskiwania';

  @override
  String get noRecoveryKey => 'Brak klucza odzyskiwania?';

  @override
  String get sorry => 'Przepraszamy';

  @override
  String get noRecoveryKeyNoDecryption =>
      'Ze względu na charakter naszego protokołu szyfrowania end-to-end, dane nie mogą być odszyfrowane bez hasła lub klucza odzyskiwania';

  @override
  String get verifyEmail => 'Zweryfikuj adres e-mail';

  @override
  String get toResetVerifyEmail =>
      'Aby zresetować hasło, najpierw zweryfikuj swój adres e-mail.';

  @override
  String get checkInboxAndSpamFolder =>
      'Sprawdź swoją skrzynkę odbiorczą (i spam), aby zakończyć weryfikację';

  @override
  String get tapToEnterCode => 'Stuknij, aby wprowadzić kod';

  @override
  String get resendEmail => 'Wyślij e-mail ponownie';

  @override
  String weHaveSendEmailTo({required String email}) {
    return 'Wysłaliśmy wiadomość na adres <green>$email</green>';
  }

  @override
  String get setPasswordTitle => 'Ustaw hasło';

  @override
  String get changePasswordTitle => 'Zmień hasło';

  @override
  String get resetPasswordTitle => 'Zresetuj hasło';

  @override
  String get encryptionKeys => 'Klucze szyfrowania';

  @override
  String get passwordWarning =>
      'Nie przechowujemy tego hasła, więc jeśli go zapomnisz, <underline>nie będziemy w stanie odszyfrować Twoich danych</underline>';

  @override
  String get enterPasswordToEncrypt =>
      'Wprowadź hasło, którego możemy użyć do zaszyfrowania Twoich danych';

  @override
  String get enterNewPasswordToEncrypt =>
      'Wprowadź nowe hasło, którego możemy użyć do zaszyfrowania Twoich danych';

  @override
  String get weakStrength => 'Słabe';

  @override
  String get strongStrength => 'Silne';

  @override
  String get moderateStrength => 'Umiarkowane';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'Siła hasła: $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully => 'Hasło zostało pomyślnie zmienione';

  @override
  String get generatingEncryptionKeys => 'Generowanie kluczy szyfrujących...';

  @override
  String get pleaseWait => 'Prosimy czekać...';

  @override
  String get continueLabel => 'Kontynuuj';

  @override
  String get insecureDevice => 'Niezabezpieczone urządzenie';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'Przepraszamy, nie mogliśmy wygenerować bezpiecznych kluczy na tym urządzeniu.\n\nZarejestruj się z innego urządzenia.';

  @override
  String get howItWorks => 'Jak to działa';

  @override
  String get encryption => 'Szyfrowanie';

  @override
  String get ackPasswordLostWarning =>
      'Rozumiem, że jeśli utracę hasło, mogę utracić dane, ponieważ moje dane są <underline>całkowicie zaszyfrowane</underline>.';

  @override
  String get privacyPolicyTitle => 'Polityka Prywatności';

  @override
  String get termsOfServicesTitle => 'Regulamin';

  @override
  String get signUpTerms =>
      'Akceptuję <u-terms>warunki korzystania z usługi</u-terms> i <u-policy>politykę prywatności</u-policy>';

  @override
  String get logInLabel => 'Zaloguj się';

  @override
  String get loginTerms =>
      'Klikając, zaloguj się, zgadzam się na <u-terms>regulamin</u-terms> i <u-policy>politykę prywatności</u-policy>';

  @override
  String get changeEmail => 'Zmień adres e-mail';

  @override
  String get enterYourPassword => 'Wprowadź hasło';

  @override
  String get welcomeBack => 'Witaj ponownie!';

  @override
  String get contactSupport => 'Skontaktuj się z pomocą techniczną';

  @override
  String get locationPickerTip =>
      'You can also add a location centered on a photo from the photo\'s info screen';

  @override
  String get incorrectPasswordTitle => 'Nieprawidłowe hasło';

  @override
  String get pleaseTryAgain => 'Spróbuj ponownie';

  @override
  String get recreatePasswordTitle => 'Ponownie utwórz hasło';

  @override
  String get useRecoveryKey => 'Użyj kodu odzyskiwania';

  @override
  String get recreatePasswordBody =>
      'Obecne urządzenie nie jest wystarczająco wydajne, aby zweryfikować hasło, ale możemy je wygenerować w sposób działający na wszystkich urządzeniach.\n\nZaloguj się przy użyciu klucza odzyskiwania i wygeneruj nowe hasło (jeśli chcesz, możesz ponownie użyć tego samego).';

  @override
  String get verifyPassword => 'Zweryfikuj hasło';

  @override
  String get recoveryKey => 'Klucz odzyskiwania';

  @override
  String get recoveryKeyOnForgotPassword =>
      'Jeśli zapomnisz hasła, jedynym sposobem odzyskania danych jest ten klucz.';

  @override
  String get recoveryKeySaveDescription =>
      'Nie przechowujemy tego klucza, prosimy zapisać ten 24-słowny klucz w bezpiecznym miejscu.';

  @override
  String get doThisLater => 'Spróbuj później';

  @override
  String get saveKey => 'Zapisz klucz';

  @override
  String get recoveryKeyCopiedToClipboard =>
      'Klucz odzyskiwania został skopiowany do schowka';

  @override
  String get recoverAccount => 'Odzyskaj konto';

  @override
  String get recover => 'Odzyskaj';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'Wyślij wiadomość e-mail na $supportEmail z zarejestrowanego adresu e-mail';
  }

  @override
  String get twofactorSetup => 'Uwierzytelnianie dwustopniowe';

  @override
  String get enterCode => 'Wprowadź kod';

  @override
  String get scanCode => 'Zeskanuj kod';

  @override
  String get codeCopiedToClipboard => 'Kod został skopiowany do schowka';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      'Kopiuj, wklej ten kod\ndo swojej aplikacji uwierzytelniającej';

  @override
  String get tapToCopy => 'naciśnij aby skopiować';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      'Zeskanuj ten kod kreskowy używając\nswojej aplikacji uwierzytelniającej';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      'Wprowadź 6-cyfrowy kod z\nTwojej aplikacji uwierzytelniającej';

  @override
  String get confirm => 'Potwierdź';

  @override
  String get setupComplete => 'Konfiguracja ukończona';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready =>
      'Zapisz swój klucz odzyskiwania, jeśli jeszcze tego nie zrobiłeś';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      'Można go użyć do odzyskania konta w przypadku utraty swojej drugiej metody uwierzytelniania';

  @override
  String get twofactorAuthenticationPageTitle =>
      'Uwierzytelnianie dwustopniowe';

  @override
  String get lostDevice => 'Utracono urządzenie?';

  @override
  String get verifyingRecoveryKey => 'Weryfikowanie klucza odzyskiwania...';

  @override
  String get recoveryKeyVerified => 'Klucz odzyskiwania zweryfikowany';

  @override
  String get recoveryKeySuccessBody =>
      'Znakomicie! Klucz odzyskiwania jest prawidłowy. Dziękujemy za weryfikację.\n\nPamiętaj, aby bezpiecznie przechowywać kopię zapasową klucza odzyskiwania.';

  @override
  String get invalidRecoveryKey =>
      'Wprowadzony klucz odzyskiwania jest nieprawidłowy. Upewnij się, że zawiera on 24 słowa i sprawdź pisownię każdego z nich.\n\nJeśli wprowadziłeś starszy kod odzyskiwania, upewnij się, że ma on 64 znaki i sprawdź każdy z nich.';

  @override
  String get invalidKey => 'Klucz jest nieprawidłowy';

  @override
  String get tryAgain => 'Spróbuj ponownie';

  @override
  String get viewRecoveryKey => 'Zobacz klucz odzyskiwania';

  @override
  String get confirmRecoveryKey => 'Potwierdź klucz odzyskiwania';

  @override
  String get recoveryKeyVerifyReason =>
      'Twój klucz odzyskiwania jest jedynym sposobem na odzyskanie zdjęć, jeśli zapomnisz hasła. Klucz odzyskiwania można znaleźć w Ustawieniach > Konto.\n\nWprowadź tutaj swój klucz odzyskiwania, aby sprawdzić, czy został zapisany poprawnie.';

  @override
  String get confirmYourRecoveryKey => 'Potwierdź klucz odzyskiwania';

  @override
  String get addViewer => 'Dodaj widza';

  @override
  String get addCollaborator => 'Dodaj współuczestnika';

  @override
  String get addANewEmail => 'Dodaj nowy adres e-mail';

  @override
  String get orPickAnExistingOne => 'Lub wybierz istniejący';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'Współuczestnicy mogą dodawać zdjęcia i wideo do udostępnionego albumu.';

  @override
  String get enterEmail => 'Wprowadź adres e-mail';

  @override
  String get albumOwner => 'Właściciel';

  @override
  String get you => 'Ty';

  @override
  String get collaborator => 'Współuczestnik';

  @override
  String get addMore => 'Dodaj więcej';

  @override
  String get viewer => 'Widz';

  @override
  String get remove => 'Usuń';

  @override
  String get removeParticipant => 'Usuń użytkownika';

  @override
  String get manage => 'Zarządzaj';

  @override
  String get addedAs => 'Dodano jako';

  @override
  String get changePermissions => 'Zmień uprawnienia?';

  @override
  String get yesConvertToViewer => 'Tak, konwertuj na widza';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return '$user nie będzie mógł dodać więcej zdjęć do tego albumu\n\nJednak nadal będą mogli usunąć istniejące zdjęcia, które dodali';
  }

  @override
  String get allowAddingPhotos => 'Pozwól na dodawanie zdjęć';

  @override
  String get allowJoiningAlbum => 'Zezwól na dołączanie do albumu';

  @override
  String get allowAddPhotosDescription =>
      'Pozwól osobom z linkiem na dodawania zdjęć do udostępnionego albumu.';

  @override
  String get passwordLock => 'Blokada hasłem';

  @override
  String get canNotOpenTitle => 'Nie można otworzyć tego albumu';

  @override
  String get canNotOpenBody =>
      'Przepraszamy, ten album nie może zostać otwarty w aplikacji.';

  @override
  String get disableDownloadWarningTitle => 'Uwaga';

  @override
  String get disableDownloadWarningBody =>
      'Widzowie mogą nadal robić zrzuty ekranu lub zapisywać kopie zdjęć za pomocą programów trzecich';

  @override
  String get allowDownloads => 'Zezwól na pobieranie';

  @override
  String get linkDeviceLimit => 'Limit urządzeń';

  @override
  String get noDeviceLimit => 'Brak';

  @override
  String get albumLayout => 'Układ albumu';

  @override
  String get layoutGrouped => 'Grouped';

  @override
  String get layoutContinuous => 'Continuous';

  @override
  String get layoutTrip => 'Trip';

  @override
  String get preview => 'Preview';

  @override
  String get linkExpiry => 'Wygaśnięcie linku';

  @override
  String get linkExpired => 'Wygasł';

  @override
  String get linkEnabled => 'Aktywny';

  @override
  String get linkNeverExpires => 'Nigdy';

  @override
  String get expiredLinkInfo =>
      'Ten link wygasł. Wybierz nowy czas wygaśnięcia lub wyłącz automatyczne wygasanie linku.';

  @override
  String get setAPassword => 'Ustaw hasło';

  @override
  String get lockButtonLabel => 'Zablokuj';

  @override
  String get enterPassword => 'Wprowadź hasło';

  @override
  String get removeLink => 'Usuń link';

  @override
  String get manageLink => 'Zarządzaj linkiem';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'Link wygaśnie $expiryTime';
  }

  @override
  String get albumUpdated => 'Album został zaktualizowany';

  @override
  String get never => 'Nigdy';

  @override
  String get custom => 'Niestandardowy';

  @override
  String get after1Hour => 'Po 1 godzinie';

  @override
  String get after1Day => 'Po 1 dniu';

  @override
  String get after1Week => 'Po 1 tygodniu';

  @override
  String get after1Month => 'Po 1 miesiącu';

  @override
  String get after1Year => 'Po 1 roku';

  @override
  String get manageParticipants => 'Zarządzaj';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Uczestników',
      one: '1 Uczestnik',
      zero: 'Brak Uczestników',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'Utwórz link, aby umożliwić innym dodawanie i przeglądanie zdjęć w udostępnionym albumie bez konieczności korzystania z aplikacji lub konta Ente. Świetne rozwiązanie do gromadzenia zdjęć ze wspólnych wydarzeń.';

  @override
  String get collectPhotos => 'Zbierz zdjęcia';

  @override
  String get collaborativeLink => 'Link do współpracy';

  @override
  String get shareWithNonenteUsers => 'Udostępnij użytkownikom bez konta Ente';

  @override
  String get createPublicLink => 'Utwórz publiczny link';

  @override
  String get sendLink => 'Wyślij link';

  @override
  String get qrCode => 'QR Code';

  @override
  String get sendQrCode => 'Wyślij kod QR';

  @override
  String get copyLink => 'Skopiuj link';

  @override
  String get copyEmbedHtml => 'Kopiuj osadzony HTML';

  @override
  String get linkHasExpired => 'Link wygasł';

  @override
  String get publicLinkEnabled => 'Publiczny link włączony';

  @override
  String get shareALink => 'Udostępnij link';

  @override
  String get sharedAlbumSectionDescription =>
      'Twórz wspólne albumy i współpracuj z innymi użytkownikami Ente, w tym z użytkownikami korzystającymi z bezpłatnych planów.';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: 'Udostępnione $numberOfPeople osobom',
      one: 'Udostępnione 1 osobie',
      zero: 'Udostępnione określonym osobom',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId =>
      'To jest Twój Identyfikator Weryfikacji';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'Osoba udostępniająca albumy powinna widzieć ten sam identyfikator na swoim urządzeniu.';

  @override
  String get howToViewShareeVerificationID =>
      'Poproś ich o przytrzymanie swojego adresu e-mail na ekranie ustawień i sprawdzenie, czy identyfikatory na obu urządzeniach są zgodne.';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'To jest identyfikator weryfikacyjny $email';
  }

  @override
  String get verificationId => 'Identyfikator weryfikacyjny';

  @override
  String verifyEmailID({required Object email}) {
    return 'Zweryfikuj $email';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return '$email nie posiada konta Ente.\n\nWyślij im zaproszenie do udostępniania zdjęć.';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return 'Oto mój identyfikator weryfikacyjny: $verificationID dla ente.io.';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'Hej, czy możesz potwierdzić, że to jest Twój identyfikator weryfikacyjny ente.io: $verificationID';
  }

  @override
  String get somethingWentWrong => 'Coś poszło nie tak';

  @override
  String get sendInvite => 'Wyślij zaproszenie';

  @override
  String get shareTextRecommendUsingEnte =>
      'Pobierz Ente, abyśmy mogli łatwo udostępniać zdjęcia i wideo w oryginalnej jakości\n\nhttps://ente.io';

  @override
  String get done => 'Gotowe';

  @override
  String get applyCodeTitle => 'Użyj kodu';

  @override
  String get enterCodeDescription =>
      'Wprowadź kod dostarczony przez znajomego, aby uzyskać bezpłatne miejsce dla was obojga';

  @override
  String get apply => 'Zastosuj';

  @override
  String get failedToApplyCode => 'Nie udało się zastosować kodu';

  @override
  String get enterReferralCode => 'Wprowadź kod polecenia';

  @override
  String get codeAppliedPageTitle => 'Kod został zastosowany';

  @override
  String get changeYourReferralCode => 'Zmień swój kod polecający';

  @override
  String get change => 'Zmień';

  @override
  String get unavailableReferralCode =>
      'Przepraszamy, ten kod jest niedostępny.';

  @override
  String get codeChangeLimitReached =>
      'Przepraszamy, osiągnięto limit zmian kodu.';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'Skontaktuj się z $familyAdminEmail, aby zmienić swój kod.';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB';
  }

  @override
  String get claimed => 'Odebrano';

  @override
  String get details => 'Szczegóły';

  @override
  String get claimMore => 'Zdobądź więcej!';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return 'Oni również otrzymują $storageAmountInGB GB';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB za każdym razem, gdy ktoś zarejestruje się w płatnym planie i użyje twojego kodu';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'Kod polecający: $referralCode \n\nZastosuj go w: Ustawienia → Ogólne → Polecanie, aby otrzymać $referralStorageInGB GB za darmo po zarejestrowaniu się w płatnym planie\n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => 'Odbierz bezpłatną przestrzeń dyskową';

  @override
  String get inviteYourFriends => 'Zaproś znajomych';

  @override
  String get failedToFetchReferralDetails =>
      'Nie można pobrać szczegółów polecenia. Spróbuj ponownie później.';

  @override
  String get referralStep1 => '1. Przekaż ten kod swoim znajomym';

  @override
  String get referralStep2 => '2. Wykupują płatny plan';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. Oboje otrzymujecie $storageInGB GB* za darmo';
  }

  @override
  String get referralsAreCurrentlyPaused =>
      'Wysyłanie poleceń jest obecnie wstrzymane';

  @override
  String get youCanAtMaxDoubleYourStorage =>
      '* Maksymalnie możesz podwoić swoją przestrzeń dyskową';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true': 'Twoja rodzina odebrała $storageAmountInGb GB do tej pory',
      'false': 'Odebrałeś $storageAmountInGb GB do tej pory',
      'other': 'Odebrałeś $storageAmountInGb GB do tej pory!',
    });
    return '$_temp0';
  }

  @override
  String get faq => 'FAQ – Często zadawane pytania';

  @override
  String get help => 'Pomoc';

  @override
  String get oopsSomethingWentWrong => 'Ups, coś poszło nie tak';

  @override
  String get peopleUsingYourCode => 'Osoby używające twojego kodu';

  @override
  String get eligible => 'kwalifikujący się';

  @override
  String get total => 'ogółem';

  @override
  String get codeUsedByYou => 'Kod użyty przez Ciebie';

  @override
  String get freeStorageClaimed => 'Bezpłatna pamięć, którą odebrano';

  @override
  String get freeStorageUsable => 'Darmowa pamięć użyteczna';

  @override
  String get usableReferralStorageInfo =>
      'Użyteczna przestrzeń dyskowa jest ograniczona przez Twój obecny plan. Nadmiar zadeklarowanej przestrzeni dyskowej stanie się automatycznie użyteczny po uaktualnieniu planu.';

  @override
  String get removeFromAlbumTitle => 'Usunąć z albumu?';

  @override
  String get removeFromAlbum => 'Usuń z albumu';

  @override
  String get itemsWillBeRemovedFromAlbum =>
      'Wybrane elementy zostaną usunięte z tego albumu';

  @override
  String get removeShareItemsWarning =>
      'Niektóre z usuwanych elementów zostały dodane przez inne osoby i utracisz do nich dostęp';

  @override
  String get addingToFavorites => 'Dodawanie do ulubionych...';

  @override
  String get removingFromFavorites => 'Usuwanie z ulubionych...';

  @override
  String get sorryCouldNotAddToFavorites =>
      'Przepraszamy, nie udało się dodać do ulubionych!';

  @override
  String get sorryCouldNotRemoveFromFavorites =>
      'Przepraszamy, nie udało się usunąć z ulubionych!';

  @override
  String get subscribeToEnableSharing =>
      'Potrzebujesz aktywnej płatnej subskrypcji, aby włączyć udostępnianie.';

  @override
  String get subscribe => 'Subskrybuj';

  @override
  String get canOnlyRemoveFilesOwnedByYou =>
      'Można usuwać tylko pliki należące do Ciebie';

  @override
  String get deleteSharedAlbum => 'Usunąć udostępniony album?';

  @override
  String get deleteAlbum => 'Usuń album';

  @override
  String get deleteAlbumDialog =>
      'Usunąć również zdjęcia (i wideo) znajdujące się w tym albumie ze <bold>wszystkich</bold> innych albumów, których są częścią?';

  @override
  String get deleteSharedAlbumDialogBody =>
      'Album zostanie usunięty dla wszystkich\n\nUtracisz dostęp do udostępnionych zdjęć w tym albumie, które są własnością innych osób';

  @override
  String get yesRemove => 'Tak, usuń';

  @override
  String get creatingLink => 'Tworzenie linku...';

  @override
  String get removeWithQuestionMark => 'Usunąć?';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return '$userEmail zostanie usunięty z tego udostępnionego albumu\n\nWszelkie dodane przez nich zdjęcia zostaną usunięte z albumu';
  }

  @override
  String get keepPhotos => 'Zachowaj Zdjęcia';

  @override
  String get deletePhotos => 'Usuń zdjęcia';

  @override
  String get inviteToEnte => 'Zaproś do Ente';

  @override
  String get removePublicLink => 'Usuń link publiczny';

  @override
  String disableLinkMessage({required Object albumName}) {
    return 'Spowoduje to usunięcie publicznego linku dostępu do \"$albumName\".';
  }

  @override
  String get sharing => 'Udostępnianie...';

  @override
  String get youCannotShareWithYourself => 'Nie możesz udostępnić samemu sobie';

  @override
  String get archive => 'Archiwum';

  @override
  String get createAlbumActionHint =>
      'Przytrzymaj, aby wybrać zdjęcia i kliknij +, aby utworzyć album';

  @override
  String get importing => 'Importowanie....';

  @override
  String get failedToLoadAlbums => 'Nie udało się załadować albumów';

  @override
  String get hidden => 'Ukryte';

  @override
  String get authToViewYourHiddenFiles =>
      'Prosimy uwierzytelnić się, aby wyświetlić ukryte pliki';

  @override
  String get authToViewTrashedFiles =>
      'Prosimy uwierzytelnić się, aby wyświetlić swoje pliki w koszu';

  @override
  String get trash => 'Kosz';

  @override
  String get uncategorized => 'Bez kategorii';

  @override
  String get videoSmallCase => 'wideo';

  @override
  String get photoSmallCase => 'zdjęcie';

  @override
  String get singleFileDeleteHighlight =>
      'To zostanie usunięte ze wszystkich albumów.';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return 'Ten $fileType jest zarówno w Ente, jak i na twoim urządzeniu.';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return 'Ten $fileType zostanie usunięty z Ente.';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return 'Ten $fileType zostanie usunięty z Twojego urządzenia.';
  }

  @override
  String get deleteFromEnte => 'Usuń z Ente';

  @override
  String get yesDelete => 'Tak, usuń';

  @override
  String get movedToTrash => 'Przeniesiono do kosza';

  @override
  String get deleteFromDevice => 'Usuń z urządzenia';

  @override
  String get deleteFromBoth => 'Usuń z obu';

  @override
  String get newAlbum => 'Nowy album';

  @override
  String get albums => 'Albumy';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount wspomnień',
      many: '$formattedCount wspomnień',
      few: '$formattedCount wspomnienia',
      one: '$formattedCount wspomnienie',
      zero: 'brak wspomnień',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return 'Wybrano $count';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return 'Wybrano $count (twoich $yourCount)';
  }

  @override
  String get advancedSettings => 'Zaawansowane';

  @override
  String get photoGridSize => 'Rozmiar siatki zdjęć';

  @override
  String get manageDeviceStorage => 'Zarządzaj pamięcią podręczną urządzenia';

  @override
  String get manageDeviceStorageDesc =>
      'Przejrzyj i wyczyść lokalną pamięć podręczną.';

  @override
  String get machineLearning => 'Nauczanie maszynowe';

  @override
  String get mlConsent => 'Włącz nauczanie maszynowe';

  @override
  String get mlConsentTitle => 'Włączyć nauczanie maszynowe?';

  @override
  String get mlConsentDescription =>
      'Jeśli włączysz nauczanie maszynowe, Ente wyodrębni informacje takie jak geometria twarzy z plików, w tym tych udostępnionych z Tobą.\n\nTo się stanie na Twoim urządzeniu i wygenerowane informacje biometryczne zostaną zaszyfrowane end-to-end.';

  @override
  String get mlConsentPrivacy =>
      'Kliknij tutaj, aby uzyskać więcej informacji na temat tej funkcji w naszej polityce prywatności';

  @override
  String get mlConsentConfirmation =>
      'Rozumiem i chcę włączyć nauczanie maszynowe';

  @override
  String get magicSearch => 'Magiczne wyszukiwanie';

  @override
  String get discover => 'Odkryj';

  @override
  String get discover_identity => 'Tożsamość';

  @override
  String get discover_screenshots => 'Zrzuty ekranu';

  @override
  String get discover_receipts => 'Paragony';

  @override
  String get discover_notes => 'Notatki';

  @override
  String get discover_memes => 'Memy';

  @override
  String get discover_visiting_cards => 'Wizytówki';

  @override
  String get discover_babies => 'Niemowlęta';

  @override
  String get discover_pets => 'Zwierzęta domowe';

  @override
  String get discover_selfies => 'Selfie';

  @override
  String get discover_wallpapers => 'Tapety';

  @override
  String get discover_food => 'Jedzenie';

  @override
  String get discover_celebrations => 'Uroczystości';

  @override
  String get discover_sunset => 'Zachód słońca';

  @override
  String get discover_hills => 'Wzgórza';

  @override
  String get discover_greenery => 'Zieleń';

  @override
  String get mlIndexingDescription =>
      'Pamiętaj, że nauczanie maszynowe spowoduje większą przepustowość i zużycie baterii do czasu zindeksowania wszystkich elementów. Rozważ użycie aplikacji komputerowej do szybszego indeksowania, wszystkie wyniki zostaną automatycznie zsynchronizowane.';

  @override
  String get loadingModel => 'Pobieranie modeli...';

  @override
  String get waitingForWifi => 'Czekanie na WiFi...';

  @override
  String get status => 'Stan';

  @override
  String get indexedItems => 'Zindeksowane elementy';

  @override
  String get pendingItems => 'Oczekujące elementy';

  @override
  String get clearIndexes => 'Wyczyść indeksy';

  @override
  String get selectFoldersForBackup =>
      'Wybierz foldery do stworzenia kopii zapasowej';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      'Wybrane foldery zostaną zaszyforwane i zostanie utworzona ich kopia zapasowa';

  @override
  String get unselectAll => 'Odznacz wszystko';

  @override
  String get selectAll => 'Zaznacz wszystko';

  @override
  String get skip => 'Pomiń';

  @override
  String get updatingFolderSelection => 'Aktualizowanie wyboru folderu...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count elementu',
      many: '$count elementów',
      few: '$count elementy',
      one: '$count element',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Usuń $count elementu',
      many: 'Usuń $count elementów',
      few: 'Usuń $count elementy',
      one: 'Usuń $count element',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count plików, każdy po $formattedSize';
  }

  @override
  String get showMemories => 'Pokaż wspomnienia';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count lata temu',
      many: '$count lat temu',
      few: '$count lata temu',
      one: '$count rok temu',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'Ustawienia kopii zapasowej';

  @override
  String get backupStatus => 'Status kopii zapasowej';

  @override
  String get backupStatusDescription =>
      'Elementy, których kopia zapasowa została utworzona, zostaną wyświetlone w tym miejscu';

  @override
  String get backupOverMobileData => 'Kopia zapasowa przez dane mobilne';

  @override
  String get backupVideos => 'Utwórz kopię zapasową wideo';

  @override
  String get disableAutoLock => 'Wyłącz automatyczną blokadę';

  @override
  String get deviceLockExplanation =>
      'Wyłącz blokadę ekranu urządzenia, gdy Ente jest na pierwszym planie i w trakcie tworzenia kopii zapasowej. Zwykle nie jest to potrzebne, ale może pomóc w szybszym przesyłaniu i początkowym imporcie dużych bibliotek.';

  @override
  String get about => 'O nas';

  @override
  String get weAreOpenSource => 'Posiadamy otwarte źródło!';

  @override
  String get privacy => 'Prywatność';

  @override
  String get terms => 'Warunki';

  @override
  String get checkForUpdates => 'Sprawdź dostępne aktualizacje';

  @override
  String get checkStatus => 'Sprawdź stan';

  @override
  String get checking => 'Sprawdzanie...';

  @override
  String get youAreOnTheLatestVersion => 'Korzystasz z najnowszej wersji';

  @override
  String get account => 'Konto';

  @override
  String get manageSubscription => 'Zarządzaj subskrypcją';

  @override
  String get authToChangeYourEmail =>
      'Prosimy uwierzytelnić się, aby zmienić swój adres e-mail';

  @override
  String get changePassword => 'Zmień hasło';

  @override
  String get authToChangeYourPassword =>
      'Prosimy uwierzytelnić się, aby zmienić hasło';

  @override
  String get emailVerificationToggle => 'Weryfikacja e-mail';

  @override
  String get authToChangeEmailVerificationSetting =>
      'Prosimy uwierzytelnić się, aby zmienić weryfikację e-mail';

  @override
  String get exportYourData => 'Eksportuj swoje dane';

  @override
  String get logout => 'Wyloguj';

  @override
  String get authToInitiateAccountDeletion =>
      'Prosimy uwierzytelnić się, aby zainicjować usuwanie konta';

  @override
  String get areYouSureYouWantToLogout => 'Czy na pewno chcesz się wylogować?';

  @override
  String get yesLogout => 'Tak, wyloguj';

  @override
  String get aNewVersionOfEnteIsAvailable => 'Dostępna jest nowa wersja Ente.';

  @override
  String get update => 'Aktualizuj';

  @override
  String get installManually => 'Zainstaluj manualnie';

  @override
  String get criticalUpdateAvailable => 'Dostępna jest krytyczna aktualizacja';

  @override
  String get updateAvailable => 'Dostępna jest aktualizacja';

  @override
  String get ignoreUpdate => 'Ignoruj';

  @override
  String get downloading => 'Pobieranie...';

  @override
  String get cannotDeleteSharedFiles =>
      'Nie można usunąć udostępnionych plików';

  @override
  String get theDownloadCouldNotBeCompleted =>
      'Pobieranie nie mogło zostać ukończone';

  @override
  String get retry => 'Spróbuj ponownie';

  @override
  String get backedUpFolders => 'Foldery kopii zapasowej';

  @override
  String get backup => 'Kopia zapasowa';

  @override
  String get freeUpDeviceSpace => 'Zwolnij miejsce na urządzeniu';

  @override
  String get freeUpDeviceSpaceDesc =>
      'Oszczędzaj miejsce na urządzeniu poprzez wyczyszczenie plików, które zostały już przesłane.';

  @override
  String get allClear => '✨ Wszystko wyczyszczone';

  @override
  String get noDeviceThatCanBeDeleted =>
      'Nie masz żadnych plików na tym urządzeniu, które można usunąć';

  @override
  String get removeDuplicates => 'Usuń duplikaty';

  @override
  String get removeDuplicatesDesc =>
      'Przejrzyj i usuń pliki, które są dokładnymi duplikatami.';

  @override
  String get viewLargeFiles => 'Duże pliki';

  @override
  String get viewLargeFilesDesc =>
      'Wyświetl pliki zużywające największą ilość pamięci.';

  @override
  String get noDuplicates => '✨ Brak duplikatów';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared =>
      'Nie masz zduplikowanych plików, które można wyczyścić';

  @override
  String get success => 'Sukces';

  @override
  String get rateUs => 'Oceń nas';

  @override
  String get remindToEmptyDeviceTrash =>
      'Również opróżnij \"Ostatnio usunięte\" z \"Ustawienia\" -> \"Pamięć\", aby odebrać wolną przestrzeń';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return 'Pomyślnie zwolniłeś/aś $storageSaved!';
  }

  @override
  String get remindToEmptyEnteTrash =>
      'Opróżnij również swój \"Kosz\", aby zwolnić miejsce';

  @override
  String get sparkleSuccess => '✨ Sukces';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count zdduplikowane pliki',
      one: '$count zdduplikowany plik',
    );
    return 'Wyczyszczono $_temp0, oszczędzając ($storageSaved!)';
  }

  @override
  String get familyPlans => 'Plany rodzinne';

  @override
  String get referrals => 'Polecenia';

  @override
  String get notifications => 'Powiadomienia';

  @override
  String get sharedPhotoNotifications => 'Nowe udostępnione zdjęcia';

  @override
  String get sharedPhotoNotificationsExplanation =>
      'Otrzymuj powiadomienia, gdy ktoś doda zdjęcie do udostępnionego albumu, którego jesteś częścią';

  @override
  String get advanced => 'Zaawansowane';

  @override
  String get general => 'Ogólne';

  @override
  String get security => 'Bezpieczeństwo';

  @override
  String get authToViewYourRecoveryKey =>
      'Prosimy uwierzytelnić się, aby wyświetlić swój klucz odzyskiwania';

  @override
  String get twofactor => 'Uwierzytelnianie dwustopniowe';

  @override
  String get authToConfigureTwofactorAuthentication =>
      'Uwierzytelnij się, aby skonfigurować uwierzytelnianie dwustopniowe';

  @override
  String get lockscreen => 'Ekran blokady';

  @override
  String get authToChangeLockscreenSetting =>
      'Prosimy uwierzytelnić się, aby zmienić ustawienia ekranu blokady';

  @override
  String get viewActiveSessions => 'Zobacz aktywne sesje';

  @override
  String get authToViewYourActiveSessions =>
      'Prosimy uwierzytelnić się, aby wyświetlić swoje aktywne sesje';

  @override
  String get disableTwofactor => 'Wyłącz uwierzytelnianie dwustopniowe';

  @override
  String get confirm2FADisable =>
      'Czy na pewno chcesz wyłączyć uwierzytelnianie dwustopniowe?';

  @override
  String get no => 'Nie';

  @override
  String get yes => 'Tak';

  @override
  String get social => 'Społeczność';

  @override
  String rateUsOnStore({required Object storeName}) {
    return 'Oceń nas na $storeName';
  }

  @override
  String get blog => 'Blog';

  @override
  String get merchandise => 'Sklep';

  @override
  String get twitter => 'Twitter';

  @override
  String get mastodon => 'Mastodon';

  @override
  String get matrix => 'Matrix';

  @override
  String get discord => 'Discord';

  @override
  String get reddit => 'Reddit';

  @override
  String get yourStorageDetailsCouldNotBeFetched =>
      'Nie można pobrać szczegółów pamięci';

  @override
  String get reportABug => 'Zgłoś błąd';

  @override
  String get reportBug => 'Zgłoś błąd';

  @override
  String get suggestFeatures => 'Zaproponuj funkcje';

  @override
  String get support => 'Wsparcie techniczne';

  @override
  String get theme => 'Motyw';

  @override
  String get lightTheme => 'Jasny';

  @override
  String get darkTheme => 'Ciemny';

  @override
  String get systemTheme => 'Systemowy';

  @override
  String get freeTrial => 'Darmowy okres próbny';

  @override
  String get selectYourPlan => 'Wybierz swój plan';

  @override
  String get enteSubscriptionPitch =>
      'Ente zachowuje Twoje wspomnienia, więc są zawsze dostępne dla Ciebie, nawet jeśli zgubisz urządzenie.';

  @override
  String get enteSubscriptionShareWithFamily =>
      'Twoja rodzina może być również dodana do Twojego planu.';

  @override
  String get currentUsageIs => 'Aktualne użycie to ';

  @override
  String get faqs => 'FAQ – Często zadawane pytania';

  @override
  String renewsOn({required Object endDate}) {
    return 'Subskrypcja odnowi się $endDate';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return 'Okres próbny ważny do $endDate';
  }

  @override
  String validTill({required Object endDate}) {
    return 'Ważne do $endDate';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return 'Twój dodatek $storageAmount jest ważny do $endDate';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return 'Bezpłatny okres próbny ważny do $endDate.\nNastępnie możesz wybrać płatny plan.';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'Twoja subskrypcja zostanie anulowana dnia $endDate';
  }

  @override
  String get subscription => 'Subskrypcja';

  @override
  String get paymentDetails => 'Szczegóły płatności';

  @override
  String get manageFamily => 'Zarządzaj Rodziną';

  @override
  String contactToManageSubscription({required Object provider}) {
    return 'Skontaktuj się z nami pod adresem support@ente.io, aby zarządzać subskrypcją $provider.';
  }

  @override
  String get renewSubscription => 'Odnów subskrypcję';

  @override
  String get cancelSubscription => 'Anuluj subskrypcję';

  @override
  String get areYouSureYouWantToRenew => 'Czy na pewno chcesz odnowić?';

  @override
  String get yesRenew => 'Tak, Odnów';

  @override
  String get areYouSureYouWantToCancel => 'Czy na pewno chcesz anulować?';

  @override
  String get yesCancel => 'Tak, anuluj';

  @override
  String get failedToRenew => 'Nie udało się odnowić';

  @override
  String get failedToCancel => 'Nie udało się anulować';

  @override
  String get twoMonthsFreeOnYearlyPlans =>
      '2 miesiące za darmo na planach rocznych';

  @override
  String get monthly => 'Miesięcznie';

  @override
  String get yearly => 'Rocznie';

  @override
  String get confirmPlanChange => 'Potwierdź zmianę planu';

  @override
  String get areYouSureYouWantToChangeYourPlan =>
      'Czy na pewno chcesz zmienić swój plan?';

  @override
  String get youCannotDowngradeToThisPlan => 'Nie możesz przejść do tego planu';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'Prosimy najpierw anulować istniejącą subskrypcję z $paymentProvider';
  }

  @override
  String get optionalAsShortAsYouLike =>
      'Opcjonalnie, tak krótko, jak chcesz...';

  @override
  String get send => 'Wyślij';

  @override
  String get askCancelReason =>
      'Twoja subskrypcja została anulowana. Czy chcesz podzielić się powodem?';

  @override
  String get thankYouForSubscribing => 'Dziękujemy za subskrypcję!';

  @override
  String get yourPurchaseWasSuccessful => 'Twój zakup zakończył się pomyślnie';

  @override
  String get yourPlanWasSuccessfullyUpgraded =>
      'Twój plan został pomyślnie ulepszony';

  @override
  String get yourPlanWasSuccessfullyDowngraded =>
      'Twój plan został pomyślnie obniżony';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully =>
      'Twoja subskrypcja została pomyślnie zaktualizowana';

  @override
  String get googlePlayId => 'Identyfikator Google Play';

  @override
  String get appleId => 'Apple ID';

  @override
  String get playstoreSubscription => 'Subskrypcja PlayStore';

  @override
  String get appstoreSubscription => 'Subskrypcja AppStore';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return 'Twoje $id jest już połączony z innym kontem Ente.\nJeśli chcesz użyć swojego $id za pomocą tego konta, skontaktuj się z naszym wsparciem technicznym';
  }

  @override
  String get visitWebToManage =>
      'Odwiedź stronę web.ente.io, aby zarządzać subskrypcją';

  @override
  String get couldNotUpdateSubscription =>
      'Nie można było zaktualizować subskrybcji';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      'Skontaktuj się z support@ente.io i z przyjemnością pomożemy!';

  @override
  String get paymentFailed => 'Płatność się nie powiodła';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return 'Porozmawiaj ze wsparciem $providerName jeśli zostałeś obciążony';
  }

  @override
  String get continueOnFreeTrial => 'Kontynuuj bezpłatny okres próbny';

  @override
  String get areYouSureYouWantToExit => 'Czy na pewno chcesz wyjść?';

  @override
  String get thankYou => 'Dziękujemy';

  @override
  String get failedToVerifyPaymentStatus =>
      'Nie udało się zweryfikować stanu płatności';

  @override
  String get pleaseWaitForSometimeBeforeRetrying =>
      'Prosimy poczekać chwilę przed ponowną próbą';

  @override
  String get paymentFailedMessage =>
      'Niestety Twoja płatność nie powiodła się. Skontaktuj się z pomocą techniczną, a my Ci pomożemy!';

  @override
  String get youAreOnAFamilyPlan => 'Jesteś w planie rodzinnym!';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'Prosimy skontaktować się z <green>$familyAdminEmail</green>, by zarzadząć swoją subskrypcją';
  }

  @override
  String get leaveFamily => 'Opuść rodzinę';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily =>
      'Czy jesteś pewien/pewna, że chcesz opuścić plan rodzinny?';

  @override
  String get leave => 'Wyjdź';

  @override
  String get rateTheApp => 'Oceń aplikację';

  @override
  String get startBackup => 'Uruchom tworzenie kopii zapasowej';

  @override
  String get noPhotosAreBeingBackedUpRightNow =>
      'W tej chwili nie wykonuje się kopii zapasowej zdjęć';

  @override
  String get preserveMore => 'Zachowaj więcej';

  @override
  String get grantFullAccessPrompt =>
      'Zezwól na dostęp do wszystkich zdjęć w aplikacji Ustawienia';

  @override
  String get allowPermTitle => 'Zezwól na dostęp do zdjęć';

  @override
  String get allowPermBody =>
      'Prosimy zezwolić na dostęp do swoich zdjęć w Ustawieniach, aby Ente mogło wyświetlać i tworzyć kopię zapasową Twojej biblioteki.';

  @override
  String get openSettings => 'Otwórz Ustawienia';

  @override
  String get selectMorePhotos => 'Wybierz więcej zdjęć';

  @override
  String get existingUser => 'Istniejący użytkownik';

  @override
  String get privateBackups => 'Prywatne kopie zapasowe';

  @override
  String get forYourMemories => 'dla twoich wspomnień';

  @override
  String get endtoendEncryptedByDefault =>
      'Domyślnie zaszyfrowane metodą end-to-end';

  @override
  String get safelyStored => 'Bezpiecznie przechowywane';

  @override
  String get atAFalloutShelter => 'w schronie';

  @override
  String get designedToOutlive => 'Zaprojektowane do przetrwania';

  @override
  String get available => 'Dostępne';

  @override
  String get everywhere => 'wszędzie';

  @override
  String get androidIosWebDesktop =>
      'Android, iOS, Strona Internetowa, Aplikacja Komputerowa';

  @override
  String get mobileWebDesktop =>
      'Aplikacja Mobilna, Strona Internetowa, Aplikacja Komputerowa';

  @override
  String get newToEnte => 'Nowy/a do Ente';

  @override
  String get pleaseLoginAgain => 'Zaloguj się ponownie';

  @override
  String get autoLogoutMessage =>
      'Z powodu technicznego błędu, zostałeś wylogowany. Przepraszamy za niedogodności.';

  @override
  String get yourSubscriptionHasExpired => 'Twoja subskrypcja wygasła';

  @override
  String get storageLimitExceeded => 'Przekroczono limit pamięci';

  @override
  String get upgrade => 'Ulepsz';

  @override
  String get raiseTicket => 'Zgłoś';

  @override
  String get backupFailed => 'Tworzenie kopii zapasowej nie powiodło się';

  @override
  String get sorryBackupFailedDesc =>
      'Przepraszamy, nie mogliśmy utworzyć kopii zapasowej tego pliku teraz, spróbujemy ponownie później.';

  @override
  String get couldNotBackUpTryLater =>
      'Nie można utworzyć kopii zapasowej Twoich danych.\nSpróbujemy ponownie później.';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      'Ente może zaszyfrować i zachować pliki tylko wtedy, gdy udzielisz do nich dostępu';

  @override
  String get pleaseGrantPermissions => 'Prosimy przyznać uprawnienia';

  @override
  String get grantPermission => 'Przyznaj uprawnienie';

  @override
  String get privateSharing => 'Udostępnianie prywatne';

  @override
  String get shareOnlyWithThePeopleYouWant =>
      'Udostępnij tylko ludziom, którym chcesz';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      'Użyj publicznych linków dla osób spoza Ente';

  @override
  String get allowPeopleToAddPhotos => 'Pozwól innym dodawać zdjęcia';

  @override
  String get shareAnAlbumNow => 'Udostępnij teraz album';

  @override
  String get collectEventPhotos => 'Zbierz zdjęcia z wydarzenia';

  @override
  String get sessionExpired => 'Sesja wygasła';

  @override
  String get loggingOut => 'Wylogowywanie...';

  @override
  String get onDevice => 'Na urządzeniu';

  @override
  String get onEnte => 'W <branding>ente</branding>';

  @override
  String get name => 'Nazwa';

  @override
  String get newest => 'Najnowsze';

  @override
  String get lastUpdated => 'Ostatnio zaktualizowano';

  @override
  String get deleteEmptyAlbums => 'Usuń puste albumy';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => 'Usunąć puste albumy?';

  @override
  String get deleteAlbumsDialogBody =>
      'Spowoduje to usunięcie wszystkich pustych albumów. Jest to przydatne, gdy chcesz zmniejszyć ilość śmieci na liście albumów.';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return 'Usuwanie $currentlyDeleting / $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return 'Przetwarzanie $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => 'Usuń trwale';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou =>
      'Można tylko utworzyć link dla plików należących do Ciebie';

  @override
  String get publicLinkCreated => 'Utworzono publiczny link';

  @override
  String get youCanManageYourLinksInTheShareTab =>
      'Możesz zarządzać swoimi linkami w zakładce udostępnianie.';

  @override
  String get linkCopiedToClipboard => 'Link skopiowany do schowka';

  @override
  String get restore => 'Przywróć';

  @override
  String get moveToAlbum => 'Przenieś do albumu';

  @override
  String get unhide => 'Odkryj';

  @override
  String get unarchive => 'Przywróć z archiwum';

  @override
  String get favorite => 'Dodaj do ulubionych';

  @override
  String get removeFromFavorite => 'Usuń z ulubionych';

  @override
  String get shareLink => 'Udostępnij link';

  @override
  String get createCollage => 'Utwórz kolaż';

  @override
  String get saveCollage => 'Zapisz kolaż';

  @override
  String get collageSaved => 'Kolaż zapisano w galerii';

  @override
  String get collageLayout => 'Układ';

  @override
  String get addToEnte => 'Dodaj do Ente';

  @override
  String get addToAlbum => 'Dodaj do albumu';

  @override
  String get delete => 'Usuń';

  @override
  String get hide => 'Ukryj';

  @override
  String get share => 'Udostępnij';

  @override
  String get unhideToAlbum => 'Odkryj do albumu';

  @override
  String get restoreToAlbum => 'Przywróć do albumu';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Przenieś elementów',
      many: 'Przenieś elementów',
      few: 'Przenieś elementy',
      one: 'Przenieś element',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Dodaj elementów',
      many: 'Dodaj elementów',
      few: 'Dodaj elementy',
      one: 'Dodaj element',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'Utwórz lub wybierz album';

  @override
  String get selectAlbum => 'Wybierz album';

  @override
  String get searchByAlbumNameHint => 'Nazwa albumu';

  @override
  String get albumTitle => 'Tytuł albumu';

  @override
  String get enterAlbumName => 'Wprowadź nazwę albumu';

  @override
  String get restoringFiles => 'Przywracanie plików...';

  @override
  String get movingFilesToAlbum => 'Przenoszenie plików do albumów...';

  @override
  String get unhidingFilesToAlbum => 'Odkrywanie plików do albumu';

  @override
  String get canNotUploadToAlbumsOwnedByOthers =>
      'Nie można przesłać do albumów należących do innych';

  @override
  String get uploadingFilesToAlbum => 'Przesyłanie plików do albumu...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return 'Pomyślnie dodano do  $albumName';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return 'Pomyślnie przeniesiono do $albumName';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'Ten album posiada już link do współpracy';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return 'Utworzono link współpracy dla $albumName';
  }

  @override
  String get askYourLovedOnesToShare =>
      'Poproś swoich bliskich o udostępnienie';

  @override
  String get invite => 'Zaproś';

  @override
  String get shareYourFirstAlbum => 'Udostępnij swój pierwszy album';

  @override
  String sharedWith({required Object emailIDs}) {
    return 'Udostępnione z $emailIDs';
  }

  @override
  String get sharedWithMe => 'Udostępnione ze mną';

  @override
  String get sharedByMe => 'Udostępnione przeze mnie';

  @override
  String get doubleYourStorage => 'Podwój swoją przestrzeń dyskową';

  @override
  String get referFriendsAnd2xYourPlan => 'Poleć znajomym i podwój swój plan';

  @override
  String get shareAlbumHint =>
      'Otwórz album i dotknij przycisk udostępniania w prawym górnym rogu, aby udostępnić.';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      'Elementy pokazują liczbę dni pozostałych przed trwałym usunięciem';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count dni',
      few: '$count dni',
      one: '1 dzień',
      zero: 'Wkrótce',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => 'Usuń Wszystko';

  @override
  String get renameAlbum => 'Zmień nazwę albumu';

  @override
  String get convertToAlbum => 'Konwertuj na album';

  @override
  String get setCover => 'Ustaw okładkę';

  @override
  String get sortAlbumsBy => 'Sortuj według';

  @override
  String get sortNewestFirst => 'Od najnowszych';

  @override
  String get sortOldestFirst => 'Od najstarszych';

  @override
  String get rename => 'Zmień nazwę';

  @override
  String get leaveSharedAlbum => 'Opuścić udostępniony album?';

  @override
  String get leaveAlbum => 'Opuść album';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'Zdjęcia dodane przez Ciebie zostaną usunięte z albumu';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted =>
      'Nie masz żadnych plików w tym albumie, które można usunąć';

  @override
  String get youDontHaveAnyArchivedItems =>
      'Nie masz żadnych zarchiwizowanych elementów.';

  @override
  String get ignoredFolderUploadReason =>
      'Niektóre pliki w tym albumie są ignorowane podczas przesyłania, ponieważ zostały wcześniej usunięte z Ente.';

  @override
  String get resetIgnoredFiles => 'Zresetuj zignorowane pliki';

  @override
  String get deviceFilesAutoUploading =>
      'Pliki dodane do tego albumu urządzenia zostaną automatycznie przesłane do Ente.';

  @override
  String get turnOnBackupForAutoUpload =>
      'Włącz kopię zapasową, aby automatycznie przesyłać pliki dodane do folderu urządzenia do Ente.';

  @override
  String get noHiddenPhotosOrVideos => 'Brak ukrytych zdjęć lub wideo';

  @override
  String get toHideAPhotoOrVideo => 'Aby ukryć zdjęcie lub wideo';

  @override
  String get openTheItem => '• Otwórz element';

  @override
  String get clickOnTheOverflowMenu => '• Kliknij na menu przepełnienia';

  @override
  String get click => '• Kliknij';

  @override
  String get nothingToSeeHere => 'Nie ma tutaj nic do zobaczenia! 👀';

  @override
  String get unarchiveAlbum => 'Przywróć album z archiwum';

  @override
  String get archiveAlbum => 'Archiwizuj album';

  @override
  String get calculating => 'Obliczanie...';

  @override
  String get pleaseWaitDeletingAlbum => 'Prosimy czekać, usuwanie albumu';

  @override
  String get searchByExamples =>
      '• Nazwy albumów (np. \"Aparat\")\n• Rodzaje plików (np. \"Wideo\", \".gif\")\n• Lata i miesiące (np. \"2022\", \"Styczeń\")\n• Święta (np. \"Boże Narodzenie\")\n• Opisy zdjęć (np. \"#fun\")';

  @override
  String get youCanTrySearchingForADifferentQuery =>
      'Możesz spróbować wyszukać inne zapytanie.';

  @override
  String get noResultsFound => 'Nie znaleziono wyników';

  @override
  String addedBy({required Object emailOrName}) {
    return 'Dodane przez $emailOrName';
  }

  @override
  String get loadingExifData => 'Wczytywanie danych EXIF...';

  @override
  String get viewAllExifData => 'Wyświetl wszystkie dane EXIF';

  @override
  String get noExifData => 'Brak danych EXIF';

  @override
  String get thisImageHasNoExifData => 'Ten obraz nie posiada danych exif';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => 'Brak wyników';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'Nie wspieramy edycji zdjęć i albumów, których jeszcze nie posiadasz';

  @override
  String get failedToFetchOriginalForEdit =>
      'Nie udało się pobrać oryginału do edycji';

  @override
  String get close => 'Zamknij';

  @override
  String get setAs => 'Ustaw jako';

  @override
  String get fileSavedToGallery => 'Plik zapisany do galerii';

  @override
  String get filesSavedToGallery => 'Pliki zapisane do galerii';

  @override
  String get fileFailedToSaveToGallery =>
      'Nie udało się zapisać pliku do galerii';

  @override
  String get download => 'Pobierz';

  @override
  String get pressAndHoldToPlayVideo =>
      'Naciśnij i przytrzymaj, aby odtworzyć wideo';

  @override
  String get pressAndHoldToPlayVideoDetailed =>
      'Naciśnij i przytrzymaj obraz, aby odtworzyć wideo';

  @override
  String get downloadFailed => 'Pobieranie nie powiodło się';

  @override
  String get deduplicateFiles => 'Odduplikuj pliki';

  @override
  String get deselectAll => 'Odznacz wszystko';

  @override
  String get reviewDeduplicateItems =>
      'Przejrzyj i usuń elementy, które uważasz, że są duplikatami.';

  @override
  String get clubByCaptureTime => 'Club według czasu przechwycenia';

  @override
  String get clubByFileName => 'Club według nazwy pliku';

  @override
  String get count => 'Ilość';

  @override
  String get totalSize => 'Całkowity rozmiar';

  @override
  String get longpressOnAnItemToViewInFullscreen =>
      'Długo naciśnij element, aby wyświetlić go na pełnym ekranie';

  @override
  String get decryptingVideo => 'Odszyfrowywanie wideo...';

  @override
  String get authToViewYourMemories =>
      'Prosimy uwierzytelnić się, aby wyświetlić swoje wspomnienia';

  @override
  String get unlock => 'Odblokuj';

  @override
  String get freeUpSpace => 'Zwolnij miejsce';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Mogą być usunięte z urządzenia, aby zwolnić $formattedSize',
      many: 'Może być usuniętych z urządzenia, aby zwolnić $formattedSize',
      one: 'Może zostać usunięty z urządzenia, aby zwolnić $formattedSize',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber plikom',
      one: '1 plikowi',
    );
    return '$_temp0 w tym albumie została bezpiecznie utworzona kopia zapasowa';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber plikom',
      one: '1 plikowi',
    );
    return '$_temp0 na tym urządzeniu została bezpiecznie utworzona kopia zapasowa';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'do tych',
      one: 'do tego',
    );
    return 'Nadal możesz mieć dostęp $_temp0 na Ente tak długo, jak masz aktywną subskrypcję';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return 'Zwolnij $sizeInMBorGB';
  }

  @override
  String get thisEmailIsAlreadyInUse => 'Ten e-mail jest już używany';

  @override
  String get incorrectCode => 'Nieprawidłowy kod';

  @override
  String get authenticationFailedPleaseTryAgain =>
      'Uwierzytelnianie nie powiodło się, prosimy spróbować ponownie';

  @override
  String get verificationFailedPleaseTryAgain =>
      'Weryfikacja nie powiodła się, spróbuj ponownie';

  @override
  String get authenticating => 'Uwierzytelnianie...';

  @override
  String get authenticationSuccessful => 'Uwierzytelnianie powiodło się!';

  @override
  String get incorrectRecoveryKey => 'Nieprawidłowy klucz odzyskiwania';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect =>
      'Wprowadzony klucz odzyskiwania jest nieprawidłowy';

  @override
  String get twofactorAuthenticationSuccessfullyReset =>
      'Pomyślnie zresetowano uwierzytelnianie dwustopniowe';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered =>
      'Prosimy zweryfikować wprowadzony kod';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      'Skontaktuj się z pomocą techniczną, jeśli problem będzie się powtarzał';

  @override
  String get twofactorAuthenticationHasBeenDisabled =>
      'Uwierzytelnianie dwustopniowe zostało wyłączone';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect =>
      'Niestety, wprowadzony kod jest nieprawidłowy';

  @override
  String get yourVerificationCodeHasExpired => 'Twój kod weryfikacyjny wygasł';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'Adres e-mail został zmieniony na $newEmail';
  }

  @override
  String get verifying => 'Weryfikowanie...';

  @override
  String get disablingTwofactorAuthentication =>
      'Uwierzytelnianie dwustopniowe jest wyłączane...';

  @override
  String get allMemoriesPreserved => 'Wszystkie wspomnienia zachowane';

  @override
  String get loadingGallery => 'Ładowanie galerii...';

  @override
  String get syncing => 'Synchronizowanie...';

  @override
  String get encryptingBackup => 'Szyfrowanie kopii zapasowej...';

  @override
  String get syncStopped => 'Synchronizacja zatrzymana';

  @override
  String syncProgress({required String completed, required String total}) {
    return 'Zachowano $completed/$total wspomnień';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return 'Zachowywanie $count wspomnień...';
  }

  @override
  String get uploadingSingleMemory => 'Zachowywanie 1 wspomnienia...';

  @override
  String get archiving => 'Archiwizowanie...';

  @override
  String get unarchiving => 'Usuwanie z archiwum...';

  @override
  String get successfullyArchived => 'Pomyślnie zarchiwizowano';

  @override
  String get successfullyUnarchived => 'Pomyślnie przywrócono z archiwum';

  @override
  String get renameFile => 'Zmień nazwę pliku';

  @override
  String get enterFileName => 'Wprowadź nazwę pliku';

  @override
  String get filesDeleted => 'Pliki usunięto';

  @override
  String get selectedFilesAreNotOnEnte => 'Wybrane pliki nie są w Ente';

  @override
  String get thisActionCannotBeUndone => 'Tej czynności nie można cofnąć';

  @override
  String get emptyTrash => 'Opróżnić kosz?';

  @override
  String get permDeleteWarning =>
      'Wszystkie elementy w koszu zostaną trwale usunięte\n\nTej czynności nie można cofnąć';

  @override
  String get empty => 'Opróżnij';

  @override
  String get couldNotFreeUpSpace => 'Nie udało się zwolnić miejsca';

  @override
  String get permanentlyDeleteFromDevice => 'Trwale usunąć z urządzenia?';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      'Niektóre z plików, które próbujesz usunąć, są dostępne tylko na Twoim urządzeniu i nie można ich odzyskać po usunięciu';

  @override
  String get theyWillBeDeletedFromAllAlbums =>
      'Zostaną one usunięte ze wszystkich albumów.';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'Niektóre elementy są zarówno w Ente, jak i na Twoim urządzeniu.';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      'Wybrane elementy zostaną usunięte ze wszystkich albumów i przeniesione do kosza.';

  @override
  String get theseItemsWillBeDeletedFromYourDevice =>
      'Te elementy zostaną usunięte z Twojego urządzenia.';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      'Wygląda na to, że coś poszło nie tak. Spróbuj ponownie po pewnym czasie. Jeśli błąd będzie się powtarzał, skontaktuj się z naszym zespołem pomocy technicznej.';

  @override
  String get error => 'Błąd';

  @override
  String get tempErrorContactSupportIfPersists =>
      'Wygląda na to, że coś poszło nie tak. Spróbuj ponownie po pewnym czasie. Jeśli błąd będzie się powtarzał, skontaktuj się z naszym zespołem pomocy technicznej.';

  @override
  String get networkHostLookUpErr =>
      'Nie można połączyć się z Ente, sprawdź ustawienia sieci i skontaktuj się z pomocą techniczną, jeśli błąd będzie się powtarzał.';

  @override
  String get networkConnectionRefusedErr =>
      'Nie można połączyć się z Ente, spróbuj ponownie po pewnym czasie. Jeśli błąd będzie się powtarzał, skontaktuj się z pomocą techniczną.';

  @override
  String get cachedData => 'Dane w pamięci podręcznej';

  @override
  String get clearCaches => 'Wyczyść pamięć podręczną';

  @override
  String get remoteImages => 'Zdjęcia zdalne';

  @override
  String get remoteVideos => 'Zdalne wideo';

  @override
  String get remoteThumbnails => 'Zdalne miniatury';

  @override
  String get pendingSync => 'Oczekująca synchronizacja';

  @override
  String get localGallery => 'Galeria lokalna';

  @override
  String get todaysLogs => 'Dzisiejsze logi';

  @override
  String get viewLogs => 'Wyświetl logi';

  @override
  String get logsDialogBody =>
      'Spowoduje to wysyłanie logów, aby pomóc nam w debugowaniu twojego problemu. Pamiętaj, że nazwy plików zostaną dołączone, aby pomóc w śledzeniu problemów z określonymi plikami.';

  @override
  String get preparingLogs => 'Przygotowywanie logów...';

  @override
  String get emailYourLogs => 'Wyślij mailem logi';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'Prosimy wysłać logi do $toEmail';
  }

  @override
  String get copyEmailAddress => 'Kopiuj adres e-mail';

  @override
  String get exportLogs => 'Eksportuj logi';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return 'Prosimy o kontakt mailowy pod adresem $toEmail';
  }

  @override
  String get dismiss => 'Odrzuć';

  @override
  String get didYouKnow => 'Czy wiedziałeś/aś?';

  @override
  String get loadingMessage => 'Wczytywanie Twoich zdjęć...';

  @override
  String get loadMessage1 =>
      'Możesz udostępnić swoją subskrypcję swojej rodzinie';

  @override
  String get loadMessage2 =>
      'Do tej pory zachowaliśmy ponad 200 milionów wspomnień';

  @override
  String get loadMessage3 =>
      'Przechowujemy 3 kopie Twoich danych, jedną w podziemnym schronie';

  @override
  String get loadMessage4 => 'Wszystkie nasze aplikacje są otwarto źródłowe';

  @override
  String get loadMessage5 =>
      'Nasz kod źródłowy i kryptografia zostały poddane zewnętrznemu audytowi';

  @override
  String get loadMessage6 =>
      'Możesz udostępniać linki do swoich albumów swoim bliskim';

  @override
  String get loadMessage7 =>
      'Nasze aplikacje mobilne działają w tle, aby zaszyfrować i wykonać kopię zapasową wszystkich nowych zdjęć, które klikniesz';

  @override
  String get loadMessage8 => 'web.ente.io ma zgrabny program do przesyłania';

  @override
  String get loadMessage9 =>
      'Używamy Xchacha20Poly1305 do bezpiecznego szyfrowania Twoich danych';

  @override
  String get photoDescriptions => 'Opisy zdjęć';

  @override
  String get fileTypesAndNames => 'Typy plików i nazwy';

  @override
  String get location => 'Lokalizacja';

  @override
  String get moments => 'Momenty';

  @override
  String get searchFaceEmptySection =>
      'Po zakończeniu indeksowania ludzie będą tu wyświetlani';

  @override
  String get searchDatesEmptySection => 'Szukaj według daty, miesiąca lub roku';

  @override
  String get searchLocationEmptySection =>
      'Grupuj zdjęcia zrobione w promieniu zdjęcia';

  @override
  String get searchPeopleEmptySection =>
      'Zaproś ludzi, a zobaczysz tutaj wszystkie udostępnione przez nich zdjęcia';

  @override
  String get searchAlbumsEmptySection => 'Albumy';

  @override
  String get searchFileTypesAndNamesEmptySection => 'Typy plików i nazwy';

  @override
  String get searchCaptionEmptySection =>
      'Dodaj opisy takie jak \"#trip\" w informacji o zdjęciu, aby szybko znaleźć je tutaj';

  @override
  String get language => 'Język';

  @override
  String get selectLanguage => 'Wybierz Język';

  @override
  String get locationName => 'Nazwa lokalizacji';

  @override
  String get addLocation => 'Dodaj lokalizację';

  @override
  String get groupNearbyPhotos => 'Grupuj pobliskie zdjęcia';

  @override
  String get kiloMeterUnit => 'km';

  @override
  String get addLocationButton => 'Dodaj';

  @override
  String get radius => 'Promień';

  @override
  String get locationTagFeatureDescription =>
      'Znacznik lokalizacji grupuje wszystkie zdjęcia, które zostały zrobione w promieniu zdjęcia';

  @override
  String get galleryMemoryLimitInfo =>
      'W galerii wyświetlane jest do 1000 pamięci';

  @override
  String get save => 'Zapisz';

  @override
  String get centerPoint => 'Punkt środkowy';

  @override
  String get pickCenterPoint => 'Wybierz punkt środkowy';

  @override
  String get useSelectedPhoto => 'Użyj zaznaczone zdjęcie';

  @override
  String get resetToDefault => 'Przywróć domyślne';

  @override
  String get edit => 'Edytuj';

  @override
  String get deleteLocation => 'Usuń lokalizację';

  @override
  String get rotateLeft => 'Obróć w lewo';

  @override
  String get flip => 'Obróć';

  @override
  String get rotateRight => 'Obróć w prawo';

  @override
  String get saveCopy => 'Zapisz kopię';

  @override
  String get light => 'Jasny';

  @override
  String get color => 'Kolor';

  @override
  String get yesDiscardChanges => 'Tak, odrzuć zmiany';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade =>
      'Czy chcesz odrzucić dokonane zmiany?';

  @override
  String get saving => 'Zapisywanie...';

  @override
  String get editsSaved => 'Edycje zapisane';

  @override
  String get oopsCouldNotSaveEdits => 'Ups, nie udało się zapisać zmian';

  @override
  String get distanceInKMUnit => 'km';

  @override
  String get dayToday => 'Dzisiaj';

  @override
  String get dayYesterday => 'Wczoraj';

  @override
  String get storage => 'Pamięć';

  @override
  String get usedSpace => 'Zajęta przestrzeń';

  @override
  String get storageBreakupFamily => 'Rodzina';

  @override
  String get storageBreakupYou => 'Ty';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return 'Użyto $usedAmount $usedStorageUnit z $totalAmount $totalStorageUnit';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return '$freeAmount $storageUnit wolne';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'Wersja: $versionValue';
  }

  @override
  String get verifyIDLabel => 'Zweryfikuj';

  @override
  String get fileInfoAddDescHint => 'Dodaj opis...';

  @override
  String get editLocationTagTitle => 'Edytuj lokalizację';

  @override
  String get setLabel => 'Ustaw';

  @override
  String get setRadius => 'Ustaw promień';

  @override
  String get familyPlanPortalTitle => 'Rodzina';

  @override
  String get familyPlanOverview =>
      'Dodaj 5 członków rodziny do istniejącego planu bez dodatkowego płacenia.\n\nKażdy członek otrzymuje własną przestrzeń prywatną i nie widzi wzajemnie swoich plików, chyba że są one udostępnione.\n\nPlany rodzinne są dostępne dla klientów, którzy mają płatną subskrypcję Ente.\n\nSubskrybuj teraz, aby rozpocząć!';

  @override
  String get androidBiometricHint => 'Potwierdź swoją tożsamość';

  @override
  String get androidBiometricNotRecognized =>
      'Nie rozpoznano. Spróbuj ponownie.';

  @override
  String get androidBiometricSuccess => 'Sukces';

  @override
  String get androidCancelButton => 'Anuluj';

  @override
  String get androidSignInTitle => 'Wymagane uwierzytelnienie';

  @override
  String get androidBiometricRequiredTitle => 'Wymagana biometria';

  @override
  String get androidDeviceCredentialsRequiredTitle =>
      'Wymagane dane logowania urządzenia';

  @override
  String get androidDeviceCredentialsSetupDescription =>
      'Wymagane dane logowania urządzenia';

  @override
  String get goToSettings => 'Przejdź do ustawień';

  @override
  String get androidGoToSettingsDescription =>
      'Uwierzytelnianie biometryczne nie jest skonfigurowane na tym urządzeniu. Przejdź do \'Ustawienia > Bezpieczeństwo\', aby dodać uwierzytelnianie biometryczne.';

  @override
  String get iOSLockOut =>
      'Uwierzytelnianie biometryczne jest wyłączone. Prosimy zablokować i odblokować ekran, aby je włączyć.';

  @override
  String get iOSGoToSettingsDescription =>
      'Uwierzytelnianie biometryczne nie jest skonfigurowane na Twoim urządzeniu. Prosimy włączyć Touch ID lub Face ID na swoim telefonie.';

  @override
  String get iOSOkButton => 'OK';

  @override
  String get openstreetmapContributors => 'Współautorzy OpenStreetMap';

  @override
  String get hostedAtOsmFrance => 'Hostowane w OSM Francja';

  @override
  String get map => 'Mapa';

  @override
  String get maps => 'Mapy';

  @override
  String get mapsPrivacyNotice =>
      'Przybliżone współrzędne zostaną przesłane do stron trzecich dbających o prywatność, takich jak OpenStreetMap, w celu wyświetlenia mapy i lokalizacji.';

  @override
  String get enableMaps => 'Włącz mapy';

  @override
  String get quickLinks => 'Szybkie linki';

  @override
  String get selectItemsToAdd => 'Wybierz elementy do dodania';

  @override
  String get addSelected => 'Dodaj zaznaczone';

  @override
  String get addFromDevice => 'Dodaj z urządzenia';

  @override
  String get addPhotos => 'Dodaj zdjęcia';

  @override
  String get noPhotosFoundHere => 'Nie znaleziono tutaj zdjęć';

  @override
  String get zoomOutToSeePhotos => 'Pomniejsz, aby zobaczyć zdjęcia';

  @override
  String get noImagesWithLocation => 'Brak zdjęć z lokalizacją';

  @override
  String get unpinAlbum => 'Odepnij album';

  @override
  String get pinAlbum => 'Przypnij album';

  @override
  String get pin => 'Pin';

  @override
  String get pinPerson => 'Pin person';

  @override
  String get pinToTop => 'Pin to top';

  @override
  String get unpin => 'Unpin';

  @override
  String get unpinPerson => 'Unpin person';

  @override
  String get visibility => 'Visibility';

  @override
  String get hideFromMemories => 'Hide from memories';

  @override
  String get showInMemories => 'Show in memories';

  @override
  String get create => 'Utwórz';

  @override
  String get viewAll => 'Pokaż wszystkie';

  @override
  String get nothingSharedWithYouYet => 'Nic Ci jeszcze nie udostępniono';

  @override
  String get noAlbumsSharedByYouYet =>
      'Brak jeszcze albumów udostępnianych przez Ciebie';

  @override
  String get sharedWithYou => 'Udostępnione z Tobą';

  @override
  String get sharedByYou => 'Udostępnione przez Ciebie';

  @override
  String get inviteYourFriendsToEnte => 'Zaproś znajomych do Ente';

  @override
  String get failedToDownloadVideo => 'Nie udało się pobrać wideo';

  @override
  String get hiding => 'Ukrywanie...';

  @override
  String get unhiding => 'Odkrywanie...';

  @override
  String get successfullyHid => 'Pomyślnie ukryto';

  @override
  String get successfullyUnhid => 'Pomyślnie odkryto';

  @override
  String get crashReporting => 'Zgłaszanie awarii';

  @override
  String get resumableUploads => 'Przesyłania wznawialne';

  @override
  String get addToHiddenAlbum => 'Dodaj do ukrytego albumu';

  @override
  String get moveToHiddenAlbum => 'Przenieś do ukrytego albumu';

  @override
  String get fileTypes => 'Rodzaje plików';

  @override
  String get deleteConfirmDialogBody =>
      'To konto jest połączone z innymi aplikacjami Ente, jeśli ich używasz. Twoje przesłane dane, we wszystkich aplikacjach Ente, zostaną zaplanowane do usunięcia, a Twoje konto zostanie trwale usunięte.';

  @override
  String get hearUsWhereTitle => 'Jak usłyszałeś/aś o Ente? (opcjonalnie)';

  @override
  String get hearUsExplanation =>
      'Nie śledzimy instalacji aplikacji. Pomogłyby nam, gdybyś powiedział/a nam, gdzie nas znalazłeś/aś!';

  @override
  String get viewAddOnButton => 'Zobacz dodatki';

  @override
  String get addOns => 'Dodatki';

  @override
  String get addOnPageSubtitle => 'Szczegóły dodatków';

  @override
  String get yourMap => 'Twoja mapa';

  @override
  String get modifyYourQueryOrTrySearchingFor =>
      'Zmodyfikuj zapytanie lub spróbuj wyszukać';

  @override
  String get blackFridaySale => 'Wyprzedaż z okazji Czarnego Piątku';

  @override
  String get upto50OffUntil4thDec => 'Do 50% zniżki, do 4 grudnia.';

  @override
  String get photos => 'Zdjęcia';

  @override
  String get videos => 'Wideo';

  @override
  String get livePhotos => 'Zdjęcia Live Photo';

  @override
  String get searchHint1 => 'Szybkie wyszukiwanie na urządzeniu';

  @override
  String get searchHint2 => 'Daty zdjęć, opisy';

  @override
  String get searchHint3 => 'Albumy, nazwy plików i typy';

  @override
  String get searchHint4 => 'Lokalizacja';

  @override
  String get searchHint5 => 'Wkrótce: Twarze i magiczne wyszukiwanie ✨';

  @override
  String get addYourPhotosNow => 'Dodaj swoje zdjęcia teraz';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Znaleziono $count wyników',
      few: 'Znaleziono $count wyniki',
      one: 'Znaleziono $count wynik',
    );
    return '$_temp0';
  }

  @override
  String get faces => 'Twarze';

  @override
  String get people => 'Ludzie';

  @override
  String get contents => 'Zawartość';

  @override
  String get addNew => 'Dodaj nowe';

  @override
  String get contacts => 'Kontakty';

  @override
  String get noInternetConnection => 'Brak połączenia z Internetem';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'Prosimy sprawdzić połączenie internetowe i spróbować ponownie.';

  @override
  String get signOutFromOtherDevices => 'Wyloguj z pozostałych urządzeń';

  @override
  String get signOutOtherBody =>
      'Jeśli uważasz, że ktoś może znać Twoje hasło, możesz wymusić wylogowanie na wszystkich innych urządzeniach korzystających z Twojego konta.';

  @override
  String get signOutOtherDevices => 'Wyloguj z pozostałych urządzeń';

  @override
  String get doNotSignOut => 'Nie wylogowuj mnie';

  @override
  String get editLocation => 'Edytuj lokalizację';

  @override
  String get selectALocation => 'Wybierz lokalizację';

  @override
  String get selectALocationFirst => 'Najpierw wybierz lokalizację';

  @override
  String get changeLocationOfSelectedItems =>
      'Zmienić lokalizację wybranych elementów?';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte =>
      'Edycje lokalizacji będą widoczne tylko w Ente';

  @override
  String get cleanUncategorized => 'Wyczyść Nieskategoryzowane';

  @override
  String get cleanUncategorizedDescription =>
      'Usuń wszystkie pliki z Nieskategoryzowanych, które są obecne w innych albumach';

  @override
  String get waitingForVerification => 'Oczekiwanie na weryfikację...';

  @override
  String get passkey => 'Klucz dostępu';

  @override
  String get passkeyAuthTitle => 'Weryfikacja kluczem dostępu';

  @override
  String get loginWithTOTP => 'Zaloguj się za pomocą TOTP';

  @override
  String get passKeyPendingVerification => 'Weryfikacja jest nadal w toku';

  @override
  String get loginSessionExpired => 'Sesja wygasła';

  @override
  String get loginSessionExpiredDetails =>
      'Twoja sesja wygasła. Zaloguj się ponownie.';

  @override
  String get verifyPasskey => 'Zweryfikuj klucz dostępu';

  @override
  String get playOnTv => 'Odtwórz album na telewizorze';

  @override
  String get pair => 'Sparuj';

  @override
  String get deviceNotFound => 'Nie znaleziono urządzenia';

  @override
  String get castInstruction =>
      'Odwiedź cast.ente.io na urządzeniu, które chcesz sparować.\n\nWprowadź poniższy kod, aby odtworzyć album na telewizorze.';

  @override
  String get deviceCodeHint => 'Wprowadź kod';

  @override
  String get joinDiscord => 'Dołącz do serwera Discord';

  @override
  String get locations => 'Lokalizacje';

  @override
  String get addAName => 'Dodaj nazwę';

  @override
  String get findThemQuickly => 'Znajdź ich szybko';

  @override
  String get findPeopleByName => 'Szybko szukaj osób po imieniu';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Dodaj widzów',
      one: 'Dodaj widza',
      zero: 'Dodaj widza',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Dodaj współuczestników',
      one: 'Dodaj współuczestnika',
      zero: 'Dodaj współuczestnika',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      'Naciśnij i przytrzymaj e-mail, aby zweryfikować szyfrowanie end-to-end.';

  @override
  String get developerSettingsWarning =>
      'Czy na pewno chcesz zmodyfikować ustawienia programisty?';

  @override
  String get developerSettings => 'Ustawienia dla programistów';

  @override
  String get serverEndpoint => 'Punkt końcowy serwera';

  @override
  String get invalidEndpoint => 'Punkt końcowy jest nieprawidłowy';

  @override
  String get invalidEndpointMessage =>
      'Niestety, wprowadzony punkt końcowy jest nieprawidłowy. Wprowadź prawidłowy punkt końcowy i spróbuj ponownie.';

  @override
  String get endpointUpdatedMessage => 'Punkt końcowy zaktualizowano pomyślnie';

  @override
  String customEndpoint({required Object endpoint}) {
    return 'Połączono z $endpoint';
  }

  @override
  String get createCollaborativeLink => 'Utwórz link współpracy';

  @override
  String get search => 'Szukaj';

  @override
  String get enterPersonName => 'Wprowadź imię osoby';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'Ten e-mail jest już powiązany z $name.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return 'Zobacz $name, aby odłączyć';
  }

  @override
  String get enterName => 'Wprowadź nazwę';

  @override
  String get savePerson => 'Zapisz osobę';

  @override
  String get editPerson => 'Edytuj osobę';

  @override
  String get mergedPhotos => 'Scalone zdjęcia';

  @override
  String get orMergeWithExistingPerson => 'Lub złącz z istniejącymi';

  @override
  String get enterDateOfBirth => 'Urodziny (nieobowiązkowo)';

  @override
  String get birthday => 'Urodziny';

  @override
  String get removePersonLabel => 'Usuń etykietę osoby';

  @override
  String get autoPairDesc =>
      'Automatyczne parowanie działa tylko z urządzeniami obsługującymi Chromecast.';

  @override
  String get manualPairDesc =>
      'Parowanie PIN-em działa z każdym ekranem, na którym chcesz wyświetlić swój album.';

  @override
  String get connectToDevice => 'Połącz z urządzeniem';

  @override
  String get autoCastDialogBody => 'Tutaj zobaczysz dostępne urządzenia Cast.';

  @override
  String get autoCastiOSPermission =>
      'Upewnij się, że uprawnienia sieci lokalnej są włączone dla aplikacji Zdjęcia Ente w Ustawieniach.';

  @override
  String get noDeviceFound => 'Nie znaleziono żadnego urządzenia';

  @override
  String get stopCastingTitle => 'Zatrzymaj wyświetlanie';

  @override
  String get stopCastingBody => 'Czy chcesz przestać wyświetlać?';

  @override
  String get castIPMismatchTitle => 'Nie udało się wyświetlić albumu';

  @override
  String get castIPMismatchBody =>
      'Upewnij się, że jesteś w tej samej sieci co telewizor.';

  @override
  String get pairingComplete => 'Parowanie zakończone';

  @override
  String get savingEdits => 'Zapisywanie zmian...';

  @override
  String get autoPair => 'Automatyczne parowanie';

  @override
  String get pairWithPin => 'Sparuj kodem PIN';

  @override
  String get faceRecognition => 'Rozpoznawanie twarzy';

  @override
  String get foundFaces => 'Znaleziono twarze';

  @override
  String get clusteringProgress => 'Postęp tworzenia klastrów';

  @override
  String get trim => 'Przytnij';

  @override
  String get crop => 'Kadruj';

  @override
  String get rotate => 'Obróć';

  @override
  String get left => 'W lewo';

  @override
  String get right => 'W prawo';

  @override
  String get whatsNew => 'Co nowego';

  @override
  String get reviewSuggestions => 'Przeglądaj sugestie';

  @override
  String get review => 'Przejrzyj';

  @override
  String get useAsCover => 'Użyj jako okładki';

  @override
  String notPersonLabel({required String name}) {
    return 'Nie $name?';
  }

  @override
  String get enable => 'Włącz';

  @override
  String get enabled => 'Włączone';

  @override
  String get moreDetails => 'Więcej szczegółów';

  @override
  String get enableMLIndexingDesc =>
      'Ente obsługuje nauczanie maszynowe na urządzeniu dla rozpoznawania twarzy, wyszukiwania magicznego i innych zaawansowanych funkcji wyszukiwania';

  @override
  String get magicSearchHint =>
      'Magiczne wyszukiwanie pozwala na wyszukiwanie zdjęć według ich zawartości, np. \"kwiat\", \"czerwony samochód\", \"dokumenty tożsamości\"';

  @override
  String get panorama => 'Panorama';

  @override
  String get reenterPassword => 'Wprowadź ponownie hasło';

  @override
  String get reenterPin => 'Wprowadź ponownie kod PIN';

  @override
  String get deviceLock => 'Blokada urządzenia';

  @override
  String get pinLock => 'Blokada PIN';

  @override
  String get next => 'Dalej';

  @override
  String get setNewPassword => 'Ustaw nowe hasło';

  @override
  String get enterPin => 'Wprowadź kod PIN';

  @override
  String get setNewPin => 'Ustaw nowy kod PIN';

  @override
  String get appLock => 'Blokada dostępu do aplikacji';

  @override
  String get noSystemLockFound => 'Nie znaleziono blokady systemowej';

  @override
  String get tapToUnlock => 'Naciśnij, aby odblokować';

  @override
  String get tooManyIncorrectAttempts => 'Zbyt wiele błędnych prób';

  @override
  String get videoInfo => 'Informacje Wideo';

  @override
  String get autoLock => 'Automatyczna blokada';

  @override
  String get immediately => 'Natychmiast';

  @override
  String get autoLockFeatureDescription =>
      'Czas, po którym aplikacja blokuje się po umieszczeniu jej w tle';

  @override
  String get hideContent => 'Ukryj zawartość';

  @override
  String get hideContentDescriptionAndroid =>
      'Ukrywa zawartość aplikacji w przełączniku aplikacji i wyłącza zrzuty ekranu';

  @override
  String get hideContentDescriptionIos =>
      'Ukrywa zawartość aplikacji w przełączniku aplikacji';

  @override
  String get passwordStrengthInfo =>
      'Siła hasła jest obliczana, biorąc pod uwagę długość hasła, użyte znaki, i czy hasło pojawi się w 10 000 najczęściej używanych haseł';

  @override
  String get noQuickLinksSelected => 'Nie wybrano żadnych szybkich linków';

  @override
  String get pleaseSelectQuickLinksToRemove =>
      'Prosimy wybrać szybkie linki do usunięcia';

  @override
  String get removePublicLinks => 'Usuń linki publiczne';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      'Spowoduje to usunięcie publicznych linków wszystkich zaznaczonych szybkich linków.';

  @override
  String get guestView => 'Widok gościa';

  @override
  String get guestViewEnablePreSteps =>
      'Aby włączyć widok gościa, należy skonfigurować hasło urządzenia lub blokadę ekranu w ustawieniach Twojego systemu.';

  @override
  String get nameTheAlbum => 'Nazwij album';

  @override
  String get collectPhotosDescription =>
      'Utwórz link, w którym Twoi znajomi mogą przesyłać zdjęcia w oryginalnej jakości.';

  @override
  String get collect => 'Zbieraj';

  @override
  String get appLockDescriptions =>
      'Wybierz między domyślnym ekranem blokady urządzenia a niestandardowym ekranem blokady z kodem PIN lub hasłem.';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'Aby włączyć blokadę aplikacji, należy skonfigurować hasło urządzenia lub blokadę ekranu w ustawieniach systemu.';

  @override
  String get authToViewPasskey =>
      'Prosimy uwierzytelnić się, aby wyświetlić swój klucz dostępu';

  @override
  String get loopVideoOn => 'Disable looping';

  @override
  String get loopVideoOff => 'Enable looping';

  @override
  String get localSyncErrorMessage =>
      'Wygląda na to, że coś poszło nie tak, ponieważ lokalna synchronizacja zdjęć zajmuje więcej czasu, niż oczekiwano. Skontaktuj się z naszym zespołem pomocy technicznej';

  @override
  String get showPerson => 'Pokaż osobę';

  @override
  String get sort => 'Sortuj';

  @override
  String get mostRecent => 'Od najnowszych';

  @override
  String get mostRelevant => 'Najbardziej trafne';

  @override
  String get loadingYourPhotos => 'Wczytywanie Twoich zdjęć...';

  @override
  String processingImport({required Object folderName}) {
    return 'Przetwarzanie $folderName...';
  }

  @override
  String get personName => 'Nazwa osoby';

  @override
  String get addNewPerson => 'Dodaj nową osobę';

  @override
  String get addNameOrMerge => 'Dodaj nazwę lub scal';

  @override
  String get mergeWithExisting => 'Scal z istniejącym';

  @override
  String get newPerson => 'Nowa osoba';

  @override
  String get addName => 'Dodaj nazwę';

  @override
  String get add => 'Dodaj';

  @override
  String extraPhotosFoundFor({required String text}) {
    return 'Znaleziono dodatkowe zdjęcia dla $text';
  }

  @override
  String get extraPhotosFound => 'Znaleziono dodatkowe zdjęcia';

  @override
  String get configuration => 'Konfiguracja';

  @override
  String get localIndexing => 'Indeksowanie lokalne';

  @override
  String get processed => 'Przetworzone';

  @override
  String get resetPerson => 'Usuń';

  @override
  String get areYouSureYouWantToResetThisPerson =>
      'Czy na pewno chcesz zresetować tę osobę?';

  @override
  String get allPersonGroupingWillReset =>
      'Wszystkie grupy dla tej osoby zostaną zresetowane i stracisz wszystkie sugestie dla tej osoby';

  @override
  String get yesResetPerson => 'Tak, zresetuj osobę';

  @override
  String get onlyThem => 'Tylko te';

  @override
  String get checkingModels => 'Sprawdzanie modeli...';

  @override
  String get enableMachineLearningBanner =>
      'Włącz nauczanie maszynowe dla magicznego wyszukiwania i rozpoznawania twarzy';

  @override
  String get searchDiscoverEmptySection =>
      'Obrazy będą wyświetlane tutaj po zakończeniu przetwarzania i synchronizacji';

  @override
  String get searchPersonsEmptySection =>
      'Osoby będą wyświetlane tutaj po zakończeniu przetwarzania i synchronizacji';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Dodano $count widzów',
      one: 'Dodano 1 widza',
      zero: 'Dodano 0 widzów',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Dodano $count współuczestników',
      one: 'Dodano 1 współuczestnika',
      zero: 'Dodano 0 współuczestników',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured => 'Konto jest już skonfigurowane.';

  @override
  String get sessionIdMismatch => 'Niezgodność ID sesji';

  @override
  String get failedToFetchActiveSessions =>
      'Nie udało się pobrać aktywnych sesji';

  @override
  String get failedToRefreshStripeSubscription =>
      'Nie udało się odświeżyć subskrypcji';

  @override
  String get failedToPlayVideo => 'Nie udało się odtworzyć wideo';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return 'Przesyłanie jest ignorowane z powodu $ignoreReason';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'Typ galerii $galleryType nie jest obsługiwany dla zmiany nazwy';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'Naciśnij, aby przesłać, przesyłanie jest obecnie ignorowane z powodu $ignoreReason';
  }

  @override
  String get tapToUpload => 'Naciśnij, aby przesłać';

  @override
  String get info => 'Informacje';

  @override
  String get addFiles => 'Dodaj Pliki';

  @override
  String get castAlbum => 'Odtwórz album';

  @override
  String get imageNotAnalyzed => 'Obraz nie został przeanalizowany';

  @override
  String get noFacesFound => 'Nie znaleziono twarzy';

  @override
  String get fileNotUploadedYet => 'Plik nie został jeszcze przesłany';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return 'Brak sugestii dla $personName';
  }

  @override
  String get month => 'miesiąc';

  @override
  String get yearShort => 'r';

  @override
  String get currentlyRunning => 'aktualnie uruchomiony';

  @override
  String get ignored => 'ignorowane';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count zdjęć',
      many: '$count zdjęć',
      few: '$count zdjęcia',
      one: '1 zdjęcie',
      zero: '0 zdjęć',
    );
    return '$_temp0';
  }

  @override
  String get file => 'Plik';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'Niezgodność długości sekcji: $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'Wybierz aplikację pocztową';

  @override
  String get selectAllShort => 'Wszystko';

  @override
  String get selectCoverPhoto => 'Wybierz zdjęcie na okładkę';

  @override
  String get newLocation => 'Nowa lokalizacja';

  @override
  String get faceNotClusteredYet =>
      'Twarz jeszcze nie zgrupowana, prosimy wrócić później';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'Link, do którego próbujesz uzyskać dostęp, wygasł.';

  @override
  String get openFile => 'Otwórz plik';

  @override
  String get backupFile => 'Zrób kopię zapasową pliku';

  @override
  String get openAlbumInBrowser => 'Otwórz album w przeglądarce';

  @override
  String get openAlbumInBrowserTitle =>
      'Prosimy użyć aplikacji internetowej, aby dodać zdjęcia do tego albumu';

  @override
  String get allow => 'Zezwól';

  @override
  String get allowAppToOpenSharedAlbumLinks =>
      'Zezwalaj aplikacji na otwieranie udostępnianych linków do albumu';

  @override
  String get seePublicAlbumLinksInApp =>
      'Zobacz publiczne linki do albumów w aplikacji';

  @override
  String get emergencyContacts => 'Kontakty Alarmowe';

  @override
  String get acceptTrustInvite => 'Zaakceptuj Zaproszenie';

  @override
  String get declineTrustInvite => 'Odrzuć Zaproszenie';

  @override
  String get removeYourselfAsTrustedContact =>
      'Usuń siebie z listy zaufanych kontaktów';

  @override
  String get legacy => 'Dziedzictwo';

  @override
  String get legacyPageDesc =>
      'Dziedzictwo pozwala zaufanym kontaktom na dostęp do Twojego konta w razie Twojej nieobecności.';

  @override
  String get legacyPageDesc2 =>
      'Zaufane kontakty mogą rozpocząć odzyskiwanie konta, a jeśli nie zostaną zablokowane w ciągu 30 dni, zresetować Twoje hasło i uzyskać dostęp do Twojego konta.';

  @override
  String get legacyAccounts => 'Odziedziczone konta';

  @override
  String get trustedContacts => 'Zaufane kontakty';

  @override
  String get addTrustedContact => 'Dodaj Zaufany Kontakt';

  @override
  String get removeInvite => 'Usuń zaproszenie';

  @override
  String get recoveryWarning =>
      'Zaufany kontakt próbuje uzyskać dostęp do Twojego konta';

  @override
  String get rejectRecovery => 'Odrzuć odzyskiwanie';

  @override
  String get recoveryInitiated => 'Odzyskiwanie rozpoczęte';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return 'Możesz uzyskać dostęp do konta po dniu $days dni. Powiadomienie zostanie wysłane na $email.';
  }

  @override
  String get cancelAccountRecovery => 'Anuluj odzyskiwanie';

  @override
  String get recoveryAccount => 'Odzyskaj konto';

  @override
  String get cancelAccountRecoveryBody =>
      'Czy na pewno chcesz anulować odzyskiwanie?';

  @override
  String get startAccountRecoveryTitle => 'Rozpocznij odzyskiwanie';

  @override
  String get whyAddTrustContact =>
      'Zaufany kontakt może pomóc w odzyskaniu Twoich danych.';

  @override
  String recoveryReady({required String email}) {
    return 'Możesz teraz odzyskać konto $email poprzez ustawienie nowego hasła.';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email próbuje odzyskać Twoje konto.';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return 'Zostałeś zaproszony do bycia dziedzicznym kontaktem przez $email.';
  }

  @override
  String get warning => 'Uwaga';

  @override
  String get proceed => 'Kontynuuj';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return 'Zamierzasz dodać $email jako zaufany kontakt. Będą mogli odzyskać Twoje konto, jeśli jesteś nieobecny przez $numOfDays dni.';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email zaprosił Cię do zostania zaufanym kontaktem';
  }

  @override
  String get authToManageLegacy =>
      'Prosimy uwierzytelnić się, aby zarządzać zaufanymi kontaktami';

  @override
  String get hideSharedItemsFromHomeGallery =>
      'Ukryj współdzielone elementy w galerii głównej';

  @override
  String get swipeToSelect => 'Swipe to select';

  @override
  String get gallery => 'Galeria';

  @override
  String get joinAlbum => 'Dołącz do albumu';

  @override
  String get joinAlbumSubtext => 'aby wyświetlić i dodać swoje zdjęcia';

  @override
  String get joinAlbumSubtextViewer => 'aby dodać to do udostępnionych albumów';

  @override
  String get join => 'Dołącz';

  @override
  String get linkEmail => 'Połącz adres e-mail';

  @override
  String get link => 'Połącz';

  @override
  String get noEnteAccountExclamation => 'Brak konta Ente!';

  @override
  String get orPickFromYourContacts => 'lub wybierz ze swoich kontaktów';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return '$email nie posiada konta Ente.';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (Ja)';
  }

  @override
  String get reassignMe => 'Przypisz \"Mnie\" ponownie';

  @override
  String get me => 'Ja';

  @override
  String get linkEmailToContactBannerCaption => 'aby szybciej udostępniać';

  @override
  String get selectPersonToLink => 'Wybierz osobę do powiązania';

  @override
  String linkPersonToEmail({required String email}) {
    return 'Połącz osobę z $email';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return 'Spowoduje to powiązanie $personName z $email';
  }

  @override
  String get selectYourFace => 'Wybierz swoją twarz';

  @override
  String get reassigningLoading => 'Ponowne przypisywanie...';

  @override
  String reassignedToName({required String name}) {
    return 'Ponownie przypisano cię do $name';
  }

  @override
  String get saveChangesBeforeLeavingQuestion =>
      'Zapisać zmiany przed wyjściem?';

  @override
  String get dontSave => 'Nie zapisuj';

  @override
  String get thisIsMeExclamation => 'To ja!';

  @override
  String get linkPerson => 'Połącz osobę';

  @override
  String get linkPersonCaption =>
      'dla lepszych doświadczeń podczas udostępniania';

  @override
  String get videoStreaming => 'Streamowalne wideo';

  @override
  String get processingVideos => 'Przetwarzanie wideo';

  @override
  String get streamDetails => 'Szczegóły transmisji';

  @override
  String get processing => 'Przetwarzanie';

  @override
  String get queued => 'W kolejce';

  @override
  String get ineligible => 'Nie kwalifikuje się';

  @override
  String get failed => 'Nie powiodło się';

  @override
  String get playStream => 'Odtwórz transmisję';

  @override
  String get playOriginal => 'Odtwórz oryginał';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'Dołączenie do albumu sprawi, że Twój e-mail będzie widoczny dla jego uczestników.';

  @override
  String get pleaseWaitThisWillTakeAWhile =>
      'Prosimy czekać, to może zająć chwilę.';

  @override
  String get editTime => 'Edytuj czas';

  @override
  String get selectTime => 'Wybierz czas';

  @override
  String get selectDate => 'Wybierz datę';

  @override
  String get previous => 'Poprzedni';

  @override
  String get selectOneDateAndTimeForAll =>
      'Wybierz jedną datę i czas dla wszystkich';

  @override
  String get selectStartOfRange => 'Wybierz początek zakresu';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      'To sprawi, że data i czas wszystkich wybranych zdjęć będą takie same.';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'To jest pierwsze w grupie. Inne wybrane zdjęcia zostaną automatycznie przesunięte w oparciu o tę nową datę';

  @override
  String get newRange => 'Nowy zakres';

  @override
  String get selectOneDateAndTime => 'Wybierz jedną datę i czas';

  @override
  String get moveSelectedPhotosToOneDate =>
      'Przenieś wybrane zdjęcia na jedną datę';

  @override
  String get shiftDatesAndTime => 'Zmień daty i czas';

  @override
  String get photosKeepRelativeTimeDifference =>
      'Zdjęcia zachowują względną różnicę czasu';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count zdjęć',
      many: '$count zdjęć',
      few: '$count zdjęcia',
      one: '1 zdjęcie',
      zero: 'Brak zdjęć',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'Ikona aplikacji';

  @override
  String get notThisPerson => 'Nie ta osoba?';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      'Wybrane elementy zostaną usunięte z tej osoby, ale nie zostaną usunięte z Twojej biblioteki.';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat przez lata';
  }

  @override
  String get thisWeekThroughTheYears => 'Ten tydzień przez lata';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'W tym tygodniu, $count lat temu',
      many: 'W tym tygodniu, $count lat temu',
      few: 'W tym tygodniu, $count lata temu',
      one: 'W tym tygodniu, $count rok temu',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'Ty i $name';
  }

  @override
  String admiringThem({required Object name}) {
    return 'Podziwianie $name';
  }

  @override
  String embracingThem({required Object name}) {
    return 'Obejmowanie $name';
  }

  @override
  String partyWithThem({required Object name}) {
    return 'Impreza z $name';
  }

  @override
  String hikingWithThem({required Object name}) {
    return 'Wędrówka z $name';
  }

  @override
  String feastingWithThem({required Object name}) {
    return 'Ucztowanie z $name';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return 'Selfie z $name';
  }

  @override
  String posingWithThem({required Object name}) {
    return 'Pozowanie z $name';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return 'Piękne widoki z $name';
  }

  @override
  String sportsWithThem({required Object name}) {
    return 'Sport z $name';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return 'Wycieczka z $name';
  }

  @override
  String get spotlightOnYourself => 'Uwaga na siebie';

  @override
  String spotlightOnThem({required Object name}) {
    return 'Uwaga na $name';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$name ma $age lat!';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name wkrótce będzie mieć $age lat';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return 'Ostatnio z $name';
  }

  @override
  String tripToLocation({required Object location}) {
    return 'Wyjazd do $location';
  }

  @override
  String tripInYear({required Object year}) {
    return 'Podróż w $year';
  }

  @override
  String get lastYearsTrip => 'Zeszłoroczna podróż';

  @override
  String get sunrise => 'Na horyzoncie';

  @override
  String get mountains => 'Na wzgórzach';

  @override
  String get greenery => 'Zielone życie';

  @override
  String get beach => 'Piasek i morze';

  @override
  String get city => 'W mieście';

  @override
  String get moon => 'W świetle księżyca';

  @override
  String get onTheRoad => 'Znowu na drodze';

  @override
  String get food => 'Kulinarna rozkosz';

  @override
  String get pets => 'Futrzani towarzysze';

  @override
  String get curatedMemories => 'Wyselekcjonowane wspomnienia';

  @override
  String get widgets => 'Widżety';

  @override
  String get memories => 'Wspomnienia';

  @override
  String get peopleWidgetDesc =>
      'Wybierz osoby, które chcesz zobaczyć na ekranie głównym.';

  @override
  String get albumsWidgetDesc =>
      'Wybierz albumy, które chcesz zobaczyć na ekranie głównym.';

  @override
  String get memoriesWidgetDesc =>
      'Wybierz rodzaj wspomnień, które chcesz zobaczyć na ekranie głównym.';

  @override
  String get smartMemories => 'Inteligentne wspomnienia';

  @override
  String get pastYearsMemories => 'Wspomnienia z ubiegłych lat';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return 'Usunąć również zdjęcia (i filmy) obecne w tych albumach $count z <bold>wszystkich</bold> innych albumów, których są częścią?';
  }

  @override
  String get addParticipants => 'Dodaj uczestników';

  @override
  String selectedAlbums({required Object count}) {
    return 'Wybrano $count';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'Akcja nie jest obsługiwana na Ulubionym albumie';

  @override
  String get onThisDayMemories => 'Wspomnienia z tego dnia';

  @override
  String get onThisDay => 'Tego dnia';

  @override
  String get lookBackOnYourMemories =>
      'Spójrz ponownie na swoje wspomnienia 🌄';

  @override
  String get newPhotosEmoji => ' nowe 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'Przepraszamy, musieliśmy wstrzymać tworzenie kopii zapasowych';

  @override
  String get clickToInstallOurBestVersionYet =>
      'Kliknij, aby zainstalować naszą najlepszą wersję';

  @override
  String get onThisDayNotificationExplanation =>
      'Otrzymuj przypomnienia o wspomnieniach z tego dnia w poprzednich latach.';

  @override
  String get addMemoriesWidgetPrompt =>
      'Dodaj widżet wspomnień do ekranu głównego i wróć tutaj, aby dostosować.';

  @override
  String get addAlbumWidgetPrompt =>
      'Dodaj widżet albumu do ekranu głównego i wróć tutaj, aby dostosować.';

  @override
  String get addPeopleWidgetPrompt =>
      'Dodaj widżet ludzi do ekranu głównego i wróć tutaj, aby dostosować.';

  @override
  String get birthdayNotifications => 'Powiadomienia o urodzinach';

  @override
  String get receiveRemindersOnBirthdays =>
      'Otrzymuj przypomnienia, kiedy są czyjeś urodziny. Naciskając na powiadomienie zabierze Cię do zdjęć osoby, która ma urodziny.';

  @override
  String get happyBirthday => 'Wszystkiego najlepszego! 🥳';

  @override
  String get birthdays => 'Urodziny';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return 'Życz $name wszystkiego  najlepszego! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      'Czy na pewno chcesz usunąć tę twarz z tej osoby?';

  @override
  String get otherDetectedFaces => 'Inne wykryte twarze';

  @override
  String get areThey => 'Czy są ';

  @override
  String get questionmark => '?';

  @override
  String get saveAsAnotherPerson => 'Zapisz jako inną osobę';

  @override
  String get showLessFaces => 'Pokaż mniej twarzy';

  @override
  String get showMoreFaces => 'Pokaż więcej twarzy';

  @override
  String get ignore => 'Ignoruj';

  @override
  String get merge => 'Scal';

  @override
  String get reset => 'Zresetuj';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      'Czy na pewno chcesz zignorować tę osobę?';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      'Czy na pewno chcesz zignorować te osoby?';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'Grupy osób nie będą już wyświetlane w sekcji ludzi. Zdjęcia pozostaną nienaruszone.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'Osoba nie będzie już wyświetlana w sekcji ludzi. Zdjęcia pozostaną nienaruszone.';

  @override
  String get areYouSureYouWantToMergeThem => 'Czy na pewno chcesz je scalić?';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'Wszystkie nienazwane grupy zostaną scalone z wybraną osobą. To nadal może zostać cofnięte z przeglądu historii sugestii danej osoby.';

  @override
  String get yesIgnore => 'Tak, ignoruj';

  @override
  String get same => 'Identyczne';

  @override
  String get different => 'Inne';

  @override
  String get sameperson => 'Ta sama osoba?';

  @override
  String get indexingPausedStatusDescription =>
      'Indeksowanie zostało wstrzymane. Zostanie automatycznie wznowione, gdy urządzenie będzie gotowe. Urządzenie uznaje się za gotowe, gdy poziom baterii, stan jej zdrowia oraz status termiczny znajdują się w bezpiecznym zakresie.';

  @override
  String get thisWeek => 'Ten tydzień';

  @override
  String get lastWeek => 'Zeszły tydzień';

  @override
  String get thisMonth => 'Ten miesiąc';

  @override
  String get thisYear => 'Ten rok';

  @override
  String get groupBy => 'Grupuj według';

  @override
  String get faceThumbnailGenerationFailed =>
      'Nie można wygenerować miniaturek twarzy';

  @override
  String get fileAnalysisFailed => 'Nie można przeanalizować pliku';

  @override
  String get editAutoAddPeople => 'Edytuj automatyczne dodawanie osób';

  @override
  String get autoAddPeople => 'Automatycznie dodaj osoby';

  @override
  String get autoAddToAlbum => 'Automatycznie dodaj do albumu';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      'Czy pliki związane z osobą, które zostały wcześniej wybrane w inteligentnych albumach, powinny zostać usunięte?';

  @override
  String get addingPhotos => 'Dodawanie zdjęć';

  @override
  String get gettingReady => 'Przygotowywanie';

  @override
  String get addSomePhotosDesc1 => 'Dodaj jakieś zdjęcia lub wybierz ';

  @override
  String get addSomePhotosDesc2 => 'znane twarze';

  @override
  String get addSomePhotosDesc3 => '\nzaczynając od';

  @override
  String get ignorePerson => 'Ignoruj osobę';

  @override
  String get mixedGrouping => 'Grupowanie mieszane?';

  @override
  String get analysis => 'Analiza';

  @override
  String get doesGroupContainMultiplePeople =>
      'Czy ta grupa zawiera wiele osób?';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'Automatycznie przeanalizujemy grupę, aby ustalić, czy jest wiele osób i oddzielimy ich ponownie. Może to potrwać kilka sekund.';

  @override
  String get layout => 'Układ';

  @override
  String get day => 'Dzień';

  @override
  String get undo => 'Cofnij';

  @override
  String get redo => 'Ponów';

  @override
  String get filter => 'Filtruj';

  @override
  String get adjust => 'Dostosuj';

  @override
  String get draw => 'Rysuj';

  @override
  String get sticker => 'Naklejka';

  @override
  String get brushColor => 'Kolor Pędzla';

  @override
  String get font => 'Czcionka';

  @override
  String get background => 'Tło';

  @override
  String get align => 'Wyrównaj';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Pomyślnie dodano do $count albumów',
      one: 'Pomyślnie dodano do 1 albumu',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => 'Videos processed';

  @override
  String get totalVideos => 'Total videos';

  @override
  String get skippedVideos => 'Skipped videos';

  @override
  String get videoStreamingDescriptionLine1 =>
      'Play videos instantly on any device.';

  @override
  String get videoStreamingDescriptionLine2 =>
      'Enable to process video streams on this device.';

  @override
  String get videoStreamingNote =>
      'Only videos from last 60 days and under 1 minute are processed on this device. For older/longer videos, enable streaming in the desktop app.';

  @override
  String get createStream => 'Create stream';

  @override
  String get recreateStream => 'Recreate stream';

  @override
  String get addedToStreamCreationQueue => 'Added to stream creation queue';

  @override
  String get addedToStreamRecreationQueue => 'Added to stream recreation queue';

  @override
  String get videoPreviewAlreadyExists => 'Video preview already exists';

  @override
  String get videoAlreadyInQueue => 'Video file already present in the queue';

  @override
  String get videoExportFailed => 'Video creation failed. Please try again.';

  @override
  String videoExportSuccess({required String path}) {
    return 'Video successfully created at $path';
  }

  @override
  String get addedToQueue => 'Dodano do kolejki';

  @override
  String get creatingStream => 'Creating stream';

  @override
  String get similarImages => 'Podobne zdjęcia';

  @override
  String get findSimilarImages => 'Znajdź podobne zdjęcia';

  @override
  String get noSimilarImagesFound => 'Nie znaleziono podobnych zdjęć';

  @override
  String get yourPhotosLookUnique => 'Twoje zdjęcia wyglądają na unikalne';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count groups found',
      one: '$count group found',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages => 'Przejrzyj i usuń podobne zdjęcia';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return 'Delete $count photos ($size)';
  }

  @override
  String get selectionOptions => 'Opcje zaznaczania';

  @override
  String selectExactWithCount({required int count}) {
    return 'Exactly similar ($count)';
  }

  @override
  String get selectExact => 'Select exact';

  @override
  String selectSimilarWithCount({required int count}) {
    return 'Mostly similar ($count)';
  }

  @override
  String get selectSimilar => 'Wybierz podobne';

  @override
  String selectAllWithCount({required int count}) {
    return 'All similarities ($count)';
  }

  @override
  String get selectSimilarImagesTitle => 'Wybierz podobne zdjęcia';

  @override
  String get chooseSimilarImagesToSelect =>
      'Wybierz zdjęcia na podstawie ich podobieństwa wizualnego';

  @override
  String get clearSelection => 'Wyczyść zaznaczenie';

  @override
  String similarImagesCount({required int count}) {
    return '$count similar images';
  }

  @override
  String deleteWithCount({required int count}) {
    return 'Delete ($count)';
  }

  @override
  String get deleteFiles => 'Usuń pliki';

  @override
  String get areYouSureDeleteFiles => 'Czy na pewno chcesz usunąć te pliki?';

  @override
  String get greatJob => 'Świetna robota!';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return 'You freed up $size of space';
  }

  @override
  String get size => 'Rozmiar';

  @override
  String get similarity => 'Podobieństwo';

  @override
  String get analyzingPhotosLocally => 'Analizowanie zdjęć lokalnie...';

  @override
  String get lookingForVisualSimilarities =>
      'Szukanie podobieństw wizualnych...';

  @override
  String get comparingImageDetails => 'Porównywanie szczegółów zdjęć...';

  @override
  String get findingSimilarImages => 'Szukanie podobnych zdjęć...';

  @override
  String get almostDone => 'Prawie gotowe…';

  @override
  String get processingLocally => 'Przetwarzanie lokalne';

  @override
  String get useMLToFindSimilarImages =>
      'Przejrzyj i usuń zdjęcia, które wyglądają podobnie.';

  @override
  String get all => 'Wszystko';

  @override
  String get similar => 'Podobne';

  @override
  String get identical => 'Identyczne';

  @override
  String get nothingHereTryAnotherFilter =>
      'Nic tu nie ma, spróbuj innego filtra! 👀';

  @override
  String get related => 'Powiązane';

  @override
  String get hoorayyyy => 'Huuraaaa!';

  @override
  String get nothingToTidyUpHere => 'Nie ma nic do uporządkowania';

  @override
  String get deletingDash => 'Usuwanie - ';

  @override
  String get cLTitle1 => 'Jump to date';

  @override
  String get cLDesc1 =>
      'See surrounding photos for any photo by selecting the jump to date option in the file\'s info pane.';

  @override
  String get cLTitle2 => 'Faster video editor';

  @override
  String get cLDesc2 =>
      'Video editor was revamped to both drastically improve its speed when editing larger videos, and also improve the UX.';

  @override
  String get cLTitle3 => 'New memories';

  @override
  String get cLDesc3 =>
      '\"Playful kids\", \"Winter adventures\", \"Neon nights\", and more.';

  @override
  String get cLTitle4 => 'Landscape gallery and more';

  @override
  String get cLDesc4 =>
      'Support for landscape layout in the app\'s main gallery. Show persons without any associated photos instead of filtering them out. Improve video aspect detection when shared from external apps.';

  @override
  String get closeBy => 'Close';

  @override
  String get peopleAutoAddDesc =>
      'Automatically add photos of the selected people to this album';

  @override
  String get festivities => 'Festive cheer';

  @override
  String get snowAdventures => 'Winter adventures';

  @override
  String get waterfalls => 'Chasing waterfalls';

  @override
  String get wildlife => 'Into the wild';

  @override
  String get flowers => 'Blooming beauties';

  @override
  String get nightLights => 'Neon nights';

  @override
  String get architecture => 'Design icons';

  @override
  String get autumnColors => 'Autumn splendor';

  @override
  String get desertDreams => 'Desert dreams';

  @override
  String get stargazing => 'Under the stars';

  @override
  String get lakeside => 'Lakeside calm';

  @override
  String get rainyDays => 'Rainy day feels';

  @override
  String get sportsAction => 'Game on';

  @override
  String get streetArt => 'Street art stories';

  @override
  String get familyMoments => 'Family time';

  @override
  String get fireworks => 'Firework finale';

  @override
  String get historicSites => 'Echoes of history';

  @override
  String get tropicalParadise => 'Tropical escapes';

  @override
  String get forestTrails => 'Forest strolls';

  @override
  String get citySunsets => 'City sunset glow';

  @override
  String get colorfulMarkets => 'Vibrant markets';

  @override
  String get cozyCafes => 'Cozy cafe corners';

  @override
  String get vintageVibes => 'Vintage vibes';

  @override
  String get aerialViews => 'Aerial perspectives';

  @override
  String get artisticPortraits => 'Artful portraits';

  @override
  String get streetFood => 'Street food bites';

  @override
  String get riverCruises => 'River cruise views';

  @override
  String get facesTimelineBannerTitle => 'Memory Lane';

  @override
  String facesTimelineBannerSubtitle({required String name}) {
    return 'See $name\'s photos across the years';
  }

  @override
  String get facesTimelineAppBarTitle => 'Memory lane';

  @override
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count years old',
      one: '$count year old',
    );
    return '$name was $_temp0';
  }

  @override
  String facesTimelineCaptionYearsAgo({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '# years ago',
      one: '# year ago',
    );
    return '$_temp0';
  }

  @override
  String get facesTimelineShareComingSoon => 'Video sharing coming soon';

  @override
  String get facesTimelinePlaybackPrevious => 'Previous';

  @override
  String get facesTimelinePlaybackNext => 'Next';

  @override
  String get facesTimelinePlaybackPlay => 'Play';

  @override
  String get facesTimelinePlaybackPause => 'Pause';

  @override
  String get facesTimelineUnavailable => 'Faces timeline is preparing...';

  @override
  String get playfulKids => 'Playful kids';

  @override
  String get coastalCliffs => 'Cliffs by the sea';

  @override
  String get ritualsTitle => 'Rituals';

  @override
  String get ritualAddTooltip => 'Add ritual';

  @override
  String get ritualActivityHeading => 'Activity';

  @override
  String get ritualDefaultHeatmapTitle => 'Take a photo every day';

  @override
  String get ritualUntitled => 'Untitled ritual';

  @override
  String get ritualShareUnavailable =>
      'Unable to share right now. Please try again.';

  @override
  String get ritualNotificationMessage => 'Take a photo now';

  @override
  String get ritualCameraNotFound => 'No camera found on this device.';

  @override
  String get ritualCameraStartError =>
      'Unable to start camera. Please check permissions.';

  @override
  String get ritualCaptureError => 'Unable to capture photo. Please try again.';

  @override
  String ritualPhotoLimit({required int maxPhotos}) {
    String _temp0 = intl.Intl.pluralLogic(
      maxPhotos,
      locale: localeName,
      other: '# photos.',
      one: '# photo.',
    );
    return 'You can add up to $_temp0';
  }

  @override
  String get ritualCaptureAtLeastOne => 'Capture at least one photo first.';

  @override
  String get ritualAlbumMissing =>
      'Ritual album missing. Edit the ritual to set an album.';

  @override
  String get ritualAddedToAlbum => 'Added to album';

  @override
  String ritualAddedToAlbumWithName({required String albumName}) {
    return 'Added to $albumName';
  }

  @override
  String ritualAddToAlbumFailure({required String error}) {
    return 'Couldn\'t add photos to the album: $error';
  }

  @override
  String get ritualBackToList => 'Back to rituals';

  @override
  String get ritualNoPhotosYet => 'No photos yet';

  @override
  String get ritualSetAlbumToLaunchCamera =>
      'Set an album for this ritual to launch the camera.';

  @override
  String get ritualDefaultCameraTitle => 'Take a photo';

  @override
  String get ritualBadgeMessage7 =>
      '7 days down! Consistency looks good on you. Keep going!';

  @override
  String get ritualBadgeMessage14 =>
      '14 days in! Your ritual is becoming a habit. Incredible!';

  @override
  String get ritualBadgeMessage30 =>
      '30 days in a row! Legendary consistency. Take a bow!';

  @override
  String get ritualBadgeMessageDefault => 'You\'re on a roll!';

  @override
  String get ritualBadgeNewTitle => 'New achievement';

  @override
  String get ritualBadgePreparing => 'Preparing...';

  @override
  String get ritualStreaksLabel => 'Streaks';

  @override
  String get ritualCreateYourOwn => 'Create your own ritual';

  @override
  String get ritualGetDailyReminders => 'Get daily reminders';

  @override
  String get ritualAlbumNotSet => 'Album not set';

  @override
  String get ritualOpenCameraTooltip => 'Open ritual camera';

  @override
  String get ritualEditorLabel => 'Ritual editor';

  @override
  String get ritualNew => 'New ritual';

  @override
  String get ritualEdit => 'Edit ritual';

  @override
  String get ritualEnterPrompt => 'Enter your ritual';

  @override
  String get ritualEnterDescription => 'Please enter a description';

  @override
  String get ritualDayLabel => 'Day';

  @override
  String get ritualNotificationsOffHint =>
      'Notifications are off. Tap a day to turn them on.';

  @override
  String get ritualTimeLabel => 'Time';

  @override
  String get ritualAlbumLabel => 'Album';

  @override
  String get ritualSave => 'Save ritual';

  @override
  String get ritualUpdate => 'Update ritual';

  @override
  String get ritualSelectAlbumTitle => 'Select album';

  @override
  String get ritualSearchOrCreate => 'Search or create new';

  @override
  String get ritualNoAlbumsYet => 'No albums yet';

  @override
  String get ritualNoMatchingAlbums => 'No matching albums';

  @override
  String ritualCreateAlbumWithName({required String albumName}) {
    return 'Create \"$albumName\"';
  }

  @override
  String get ritualCreateNew => 'Create new';

  @override
  String get ritualAlbumSelectionPlaceholder => 'Select album';

  @override
  String get ritualPickEmojiTitle => 'Pick an emoji';

  @override
  String get ritualCustomKeyboardLabel => 'Custom (keyboard)';

  @override
  String get ritualEmojiKeyboardHint => 'Press to open emoji keyboard';

  @override
  String get ritualEmojiUseAction => 'Use';

  @override
  String get ritualSearchEmpty =>
      'Build a ritual to keep your photo habit going.';
}
