// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Norwegian (`no`).
class AppLocalizationsNo extends AppLocalizations {
  AppLocalizationsNo([String locale = 'no']) : super(locale);

  @override
  String get enterYourEmailAddress => 'Skriv inn e-postadressen din';

  @override
  String get enterYourNewEmailAddress => 'Skriv inn den nye e-postadressen din';

  @override
  String get accountWelcomeBack => 'Velkommen tilbake!';

  @override
  String get emailAlreadyRegistered => 'E-postadressen er allerede registrert.';

  @override
  String get emailNotRegistered => 'E-postadressen er ikke registrert.';

  @override
  String get email => 'E-post';

  @override
  String get cancel => 'Avbryt';

  @override
  String get verify => 'Bekreft';

  @override
  String get invalidEmailAddress => 'Ugyldig e-postadresse';

  @override
  String get enterValidEmail => 'Vennligst skriv inn en gyldig e-postadresse.';

  @override
  String get deleteAccount => 'Slett konto';

  @override
  String get deleteAccountWarning =>
      'This will delete your Ente Auth, Ente Photos and Ente Locker account.';

  @override
  String get askDeleteReason =>
      'Hva er hovedårsaken til at du sletter kontoen din?';

  @override
  String get deleteAccountFeedbackPrompt =>
      'Vi er lei oss for at du forlater oss. Gi oss gjerne en tilbakemelding så vi kan forbedre oss.';

  @override
  String get feedback => 'Tilbakemelding';

  @override
  String get kindlyHelpUsWithThisInformation =>
      'Vær vennlig og hjelp oss med denne informasjonen';

  @override
  String get confirmDeletePrompt =>
      'Ja, jeg ønsker å slette denne kontoen og all dataen dens permanent.';

  @override
  String get confirmAccountDeletion => 'Bekreft sletting av konto';

  @override
  String get deleteAccountPermanentlyButton => 'Slett bruker for altid';

  @override
  String get yourAccountHasBeenDeleted => 'Brukeren din har blitt slettet';

  @override
  String get selectReason => 'Velg grunn';

  @override
  String get deleteReason1 => 'Det mangler en hovedfunksjon jeg trenger';

  @override
  String get deleteReason2 =>
      'Appen, eller en bestemt funksjon, fungerer ikke slik jeg tror den skal';

  @override
  String get deleteReason3 => 'Jeg fant en annen tjeneste jeg liker bedre';

  @override
  String get deleteReason4 => 'Årsaken min er ikke oppført';

  @override
  String get sendEmail => 'Send e-post';

  @override
  String get deleteRequestSLAText =>
      'Forespørselen din vil bli behandlet innen 72 timer.';

  @override
  String get deleteEmailRequest =>
      'Vennligst send en e-post til <warning>account-deletion@ente.io</warning> fra din registrerte e-postadresse.';

  @override
  String get entePhotosPerm =>
      'Ente <i>trenger tillatelse</i> for å bevare bildene dine';

  @override
  String get ok => 'Ok';

  @override
  String get createAccount => 'Opprett konto';

  @override
  String get createNewAccount => 'Opprett ny konto';

  @override
  String get password => 'Passord';

  @override
  String get confirmPassword => 'Bekreft passordet';

  @override
  String get activeSessions => 'Aktive økter';

  @override
  String get ocrProcessingOverlayMessage => 'Detecting text...';

  @override
  String get ocrLoadingIndicatorLabel => 'Detecting Text';

  @override
  String get ocrSelectionHint =>
      'Swipe or double tap to select just what you need';

  @override
  String get ocrNoTextDetected => 'No text detected';

  @override
  String get ocrRetryButtonLabel => 'Retry';

  @override
  String get ocrModelsNetworkRequiredError =>
      'Network connection required to download OCR models on first use';

  @override
  String get ocrModelsPrepareFailed => 'Could not prepare OCR models';

  @override
  String get ocrImageNotFoundError => 'Image file not found';

  @override
  String get ocrImageDecodeFailedError => 'Could not read image file';

  @override
  String get ocrGenericDetectError => 'Could not detect text in image';

  @override
  String get oops => 'Oisann';

  @override
  String get somethingWentWrongPleaseTryAgain =>
      'Noe gikk galt. Vennligst prøv igjen';

  @override
  String get thisWillLogYouOutOfThisDevice =>
      'Dette vil logge deg ut av denne enheten!';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice =>
      'Dette vil logge deg ut av følgende enhet:';

  @override
  String get terminateSession => 'Avslutte økten?';

  @override
  String get terminate => 'Avslutte';

  @override
  String get thisDevice => 'Denne enheten';

  @override
  String get recoverButton => 'Gjenopprett';

  @override
  String get recoverySuccessful => 'Gjenopprettingen var vellykket!';

  @override
  String get decrypting => 'Dekrypterer...';

  @override
  String get incorrectRecoveryKeyTitle => 'Feil gjenopprettingsnøkkel';

  @override
  String get incorrectRecoveryKeyBody =>
      'Gjennopprettingsnøkkelen du skrev inn er feil';

  @override
  String get forgotPassword => 'Glemt passord';

  @override
  String get enterYourRecoveryKey => 'Skriv inn din gjenopprettingsnøkkel';

  @override
  String get noRecoveryKey => 'Ingen gjenopprettingsnøkkel?';

  @override
  String get sorry => 'Beklager';

  @override
  String get noRecoveryKeyNoDecryption =>
      'Grunnet vår type ente-til-ende-krypteringsprotokoll kan ikke dine data dekrypteres uten passordet ditt eller gjenopprettingsnøkkelen din';

  @override
  String get verifyEmail => 'Bekreft e-postadresse';

  @override
  String get toResetVerifyEmail =>
      'For å tilbakestille passordet ditt, vennligst bekreft e-posten din først.';

  @override
  String get checkInboxAndSpamFolder =>
      'Vennligst sjekk innboksen din (og søppelpost) for å fullføre verifiseringen';

  @override
  String get tapToEnterCode => 'Trykk for å angi kode';

  @override
  String get resendEmail => 'Send e-posten på nytt';

  @override
  String weHaveSendEmailTo({required String email}) {
    return 'Vi har sendt en e-post til <green>$email</green>';
  }

  @override
  String get setPasswordTitle => 'Angi passord';

  @override
  String get changePasswordTitle => 'Bytt passord';

  @override
  String get resetPasswordTitle => 'Tilbakestill passord';

  @override
  String get encryptionKeys => 'Krypteringsnøkkel';

  @override
  String get passwordWarning =>
      'Vi lagrer ikke dette passordet, så hvis du glemmer det, <underline>kan vi ikke dekryptere dataene dine</underline>';

  @override
  String get enterPasswordToEncrypt =>
      'Angi et passord vi kan bruke til å kryptere dataene dine';

  @override
  String get enterNewPasswordToEncrypt =>
      'Angi et nytt passord vi kan bruke til å kryptere dataene dine';

  @override
  String get weakStrength => 'Svakt';

  @override
  String get strongStrength => 'Sterkt';

  @override
  String get moderateStrength => 'Moderat';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'Passordstyrke: $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully => 'Passordet ble endret';

  @override
  String get generatingEncryptionKeys => 'Genererer krypteringsnøkler...';

  @override
  String get pleaseWait => 'Vennligst vent...';

  @override
  String get continueLabel => 'Fortsett';

  @override
  String get insecureDevice => 'Usikker enhet';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'Beklager, vi kunne ikke generere sikre nøkler på denne enheten.\n\nvennligst registrer deg fra en annen enhet.';

  @override
  String get howItWorks => 'Hvordan det fungerer';

  @override
  String get encryption => 'Kryptering';

  @override
  String get ackPasswordLostWarning =>
      'Jeg forstår at dersom jeg mister passordet mitt, kan jeg miste dataen min, siden daten er <underline>ende-til-ende-kryptert</underline>.';

  @override
  String get privacyPolicyTitle => 'Personvernserklæring';

  @override
  String get termsOfServicesTitle => 'Vilkår';

  @override
  String get signUpTerms =>
      'Jeg godtar <u-terms>bruksvilkårene</u-terms> og <u-policy>personvernreglene</u-policy>';

  @override
  String get logInLabel => 'Logg inn';

  @override
  String get loginTerms =>
      'Ved å klikke Logg inn, godtar jeg <u-terms>brukervilkårene</u-terms> og <u-policy>personvernreglene</u-policy>';

  @override
  String get changeEmail => 'Endre e-postadresse';

  @override
  String get enterYourPassword => 'Angi passordet ditt';

  @override
  String get welcomeBack => 'Velkommen tilbake!';

  @override
  String get contactSupport => 'Kontakt kundestøtte';

  @override
  String get locationPickerTip =>
      'You can also add a location centered on a photo from the photo\'s info screen';

  @override
  String get incorrectPasswordTitle => 'Feil passord';

  @override
  String get pleaseTryAgain => 'Vennligst prøv igjen';

  @override
  String get recreatePasswordTitle => 'Gjenopprett passord';

  @override
  String get useRecoveryKey => 'Bruk gjenopprettingsnøkkel';

  @override
  String get recreatePasswordBody =>
      'Den gjeldende enheten er ikke kraftig nok til å verifisere passordet ditt, men vi kan regenerere på en måte som fungerer på alle enheter.\n\nVennligst logg inn med gjenopprettingsnøkkelen og regenerer passordet (du kan bruke den samme igjen om du vil).';

  @override
  String get verifyPassword => 'Bekreft passord';

  @override
  String get recoveryKey => 'Gjenopprettingsnøkkel';

  @override
  String get recoveryKeyOnForgotPassword =>
      'Hvis du glemmer passordet ditt er den eneste måten du kan gjenopprette dataene dine på med denne nøkkelen.';

  @override
  String get recoveryKeySaveDescription =>
      'Vi lagrer ikke denne nøkkelen, vennligst lagre denne 24-ords nøkkelen på et trygt sted.';

  @override
  String get doThisLater => 'Gjør dette senere';

  @override
  String get saveKey => 'Lagre nøkkel';

  @override
  String get recoveryKeyCopiedToClipboard =>
      'Gjenopprettingsnøkkel kopiert til utklippstavlen';

  @override
  String get recoverAccount => 'Gjenopprett konto';

  @override
  String get recover => 'Gjenopprett';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'Vennligst send en e-post til $supportEmail fra din registrerte e-postadresse';
  }

  @override
  String get twofactorSetup => 'Oppsett av to-faktor';

  @override
  String get enterCode => 'Angi kode';

  @override
  String get scanCode => 'Skann kode';

  @override
  String get codeCopiedToClipboard => 'Koden er kopiert til utklippstavlen';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      'Kopier og lim inn denne koden\ntil autentiseringsappen din';

  @override
  String get tapToCopy => 'trykk for å kopiere';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      'Skann denne strekkoden med\nautentiseringsappen din';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      'Skriv inn den 6-sifrede koden fra\ndin autentiseringsapp';

  @override
  String get confirm => 'Bekreft';

  @override
  String get setupComplete => 'Oppsett fullført';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready =>
      'Lagre gjenopprettingsnøkkelen hvis du ikke allerede har gjort det';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      'Dette kan brukes til å gjenopprette kontoen din hvis du mister din andre faktor';

  @override
  String get twofactorAuthenticationPageTitle => 'Tofaktorautentisering';

  @override
  String get lostDevice => 'Mistet enhet?';

  @override
  String get verifyingRecoveryKey => 'Verifiserer gjenopprettingsnøkkel...';

  @override
  String get recoveryKeyVerified => 'Gjenopprettingsnøkkel bekreftet';

  @override
  String get recoveryKeySuccessBody =>
      'Flott! Din gjenopprettingsnøkkel er gyldig. Takk for bekreftelsen.\n\nVennligst husk å holde gjenopprettingsnøkkelen din trygt sikkerhetskopiert.';

  @override
  String get invalidRecoveryKey =>
      'Gjenopprettingsnøkkelen du har skrevet inn er ikke gyldig. Kontroller at den inneholder 24 ord og kontroller stavemåten av hvert ord.\n\nHvis du har angitt en eldre gjenopprettingskode, må du kontrollere at den er 64 tegn lang, og kontrollere hvert av dem.';

  @override
  String get invalidKey => 'Ugyldig nøkkel';

  @override
  String get tryAgain => 'Prøv igjen';

  @override
  String get viewRecoveryKey => 'Vis gjenopprettingsnøkkel';

  @override
  String get confirmRecoveryKey => 'Bekreft gjenopprettingsnøkkel';

  @override
  String get recoveryKeyVerifyReason =>
      'Gjenopprettingsnøkkelen er den eneste måten å gjenopprette bildene dine på hvis du glemmer passordet ditt. Du finner gjenopprettingsnøkkelen din i Innstillinger > Konto.\n\nVennligst skriv inn gjenopprettingsnøkkelen din her for å bekrefte at du har lagret den riktig.';

  @override
  String get confirmYourRecoveryKey => 'Bekreft din gjenopprettingsnøkkel';

  @override
  String get addViewer => 'Legg til seer';

  @override
  String get addCollaborator => 'Legg til samarbeidspartner';

  @override
  String get addANewEmail => 'Legg til ny e-post';

  @override
  String get orPickAnExistingOne => 'Eller velg en eksisterende';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'Samarbeidspartnere kan legge til bilder og videoer i det delte albumet.';

  @override
  String get enterEmail => 'Skriv inn e-post';

  @override
  String get albumOwner => 'Eier';

  @override
  String get you => 'Deg';

  @override
  String get collaborator => 'Samarbeidspartner';

  @override
  String get addMore => 'Legg til flere';

  @override
  String get viewer => 'Seer';

  @override
  String get remove => 'Fjern';

  @override
  String get removeParticipant => 'Fjern deltaker';

  @override
  String get manage => 'Administrer';

  @override
  String get addedAs => 'Lagt til som';

  @override
  String get changePermissions => 'Endre tillatelser?';

  @override
  String get yesConvertToViewer => 'Ja, konverter til seer';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return '$user vil ikke kunne legge til flere bilder til dette albumet\n\nDe vil fortsatt kunne fjerne eksisterende bilder lagt til av dem';
  }

  @override
  String get allowAddingPhotos => 'Tillat å legge til bilder';

  @override
  String get allowJoiningAlbum => 'Allow joining album';

  @override
  String get allowAddPhotosDescription =>
      'Tillat folk med lenken å også legge til bilder til det delte albumet.';

  @override
  String get passwordLock => 'Passordlås';

  @override
  String get canNotOpenTitle => 'Kan ikke åpne dette albumet';

  @override
  String get canNotOpenBody =>
      'Beklager, dette albumet kan ikke åpnes i appen.';

  @override
  String get disableDownloadWarningTitle => 'Vær oppmerksom på';

  @override
  String get disableDownloadWarningBody =>
      'Seere kan fremdeles ta skjermbilder eller lagre en kopi av bildene dine ved bruk av eksterne verktøy';

  @override
  String get allowDownloads => 'Tillat nedlastinger';

  @override
  String get linkDeviceLimit => 'Enhetsgrense';

  @override
  String get noDeviceLimit => 'Ingen';

  @override
  String get albumLayout => 'Album layout';

  @override
  String get layoutGrouped => 'Grouped';

  @override
  String get layoutContinuous => 'Continuous';

  @override
  String get layoutTrip => 'Trip';

  @override
  String get preview => 'Preview';

  @override
  String get linkExpiry => 'Lenkeutløp';

  @override
  String get linkExpired => 'Utløpt';

  @override
  String get linkEnabled => 'Aktivert';

  @override
  String get linkNeverExpires => 'Aldri';

  @override
  String get expiredLinkInfo =>
      'Denne lenken er utløpt. Vennligst velg en ny utløpstid eller deaktiver lenkeutløp.';

  @override
  String get setAPassword => 'Lag et passord';

  @override
  String get lockButtonLabel => 'Lås';

  @override
  String get enterPassword => 'Angi passord';

  @override
  String get removeLink => 'Fjern lenke';

  @override
  String get manageLink => 'Administrer lenke';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'Lenken utløper på $expiryTime';
  }

  @override
  String get albumUpdated => 'Album oppdatert';

  @override
  String get never => 'Aldri';

  @override
  String get custom => 'Egendefinert';

  @override
  String get after1Hour => 'Etter 1 time';

  @override
  String get after1Day => 'Etter 1 dag';

  @override
  String get after1Week => 'Etter 1 uke';

  @override
  String get after1Month => 'Etter 1 måned';

  @override
  String get after1Year => 'Etter 1 år';

  @override
  String get manageParticipants => 'Administrer';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count deltakere',
      one: '1 deltaker',
      zero: 'Ingen deltakere',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'Opprett en lenke slik at folk kan legge til og se bilder i det delte albumet ditt uten å trenge Ente-appen eller en konto. Perfekt for å samle bilder fra arrangementer.';

  @override
  String get collectPhotos => 'Samle bilder';

  @override
  String get collaborativeLink => 'Samarbeidslenke';

  @override
  String get shareWithNonenteUsers => 'Del med brukere som ikke har Ente';

  @override
  String get createPublicLink => 'Opprett offentlig lenke';

  @override
  String get sendLink => 'Send lenke';

  @override
  String get qrCode => 'QR Code';

  @override
  String get sendQrCode => 'Send QR code';

  @override
  String get copyLink => 'Kopier lenke';

  @override
  String get copyEmbedHtml => 'Copy embed HTML';

  @override
  String get linkHasExpired => 'Lenken har utløpt';

  @override
  String get publicLinkEnabled => 'Offentlig lenke aktivert';

  @override
  String get shareALink => 'Del en lenke';

  @override
  String get sharedAlbumSectionDescription =>
      'Opprett delte album du kan samarbeide om med andre Ente-brukere, inkludert brukere med gratisabonnement.';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: 'Delt med $numberOfPeople personer',
      one: 'Delt med 1 person',
      zero: 'Del med bestemte personer',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId => 'Dette er din bekreftelses-ID';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'Folk som deler album med deg bør se den samme ID-en på deres enhet.';

  @override
  String get howToViewShareeVerificationID =>
      'Vennligst be dem om å trykke og holde inne på e-postadressen sin på innstillingsskjermen, og bekreft at ID-ene på begge enhetene er like.';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'Dette er $email sin verifiserings-ID';
  }

  @override
  String get verificationId => 'Verifiserings-ID';

  @override
  String verifyEmailID({required Object email}) {
    return 'Verifiser $email';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return '$email har ikke en Ente-konto.\n\nsender dem en invitasjon til å dele bilder.';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return 'Her er min verifiserings-ID: $verificationID for ente.io.';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'Hei, kan du bekrefte at dette er din ente.io verifiserings-ID: $verificationID';
  }

  @override
  String get somethingWentWrong => 'Noe gikk galt';

  @override
  String get sendInvite => 'Send invitasjon';

  @override
  String get shareTextRecommendUsingEnte =>
      'Last ned Ente slik at vi lett kan dele bilder og videoer av original kvalitet\n\nhttps://ente.io';

  @override
  String get done => 'Ferdig';

  @override
  String get applyCodeTitle => 'Bruk kode';

  @override
  String get enterCodeDescription =>
      'Angi koden fra vennen din for å få gratis lagringsplass for dere begge';

  @override
  String get apply => 'Anvend';

  @override
  String get failedToApplyCode => 'Kunne ikke bruke koden';

  @override
  String get enterReferralCode => 'Angi vervekode';

  @override
  String get codeAppliedPageTitle => 'Kode brukt';

  @override
  String get changeYourReferralCode => 'Endre din vervekode';

  @override
  String get change => 'Endre';

  @override
  String get unavailableReferralCode =>
      'Beklager, denne koden er utilgjengelig.';

  @override
  String get codeChangeLimitReached =>
      'Beklager, du har nådd grensen for kodeendringer.';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'Vennligst kontakt $familyAdminEmail for å endre koden din.';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB';
  }

  @override
  String get claimed => 'Løst inn';

  @override
  String get details => 'Detaljer';

  @override
  String get claimMore => 'Løs inn mer!';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return 'De får også $storageAmountInGB GB';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB hver gang noen melder seg på en betalt plan og bruker koden din';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'Gi vervekode: $referralCode \n\nBruk den i Innstillinger → General → Verving for å få $referralStorageInGB GB gratis etter at du har registrert deg for en betalt plan\n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => 'Få gratis lagring';

  @override
  String get inviteYourFriends => 'Inviter vennene dine';

  @override
  String get failedToFetchReferralDetails =>
      'Kan ikke hente vervedetaljer. Prøv igjen senere.';

  @override
  String get referralStep1 => '1. Gi denne koden til vennene dine';

  @override
  String get referralStep2 => 'De registrerer seg for en betalt plan';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. Begge dere får $storageInGB GB* gratis';
  }

  @override
  String get referralsAreCurrentlyPaused =>
      'Vervinger er for øyeblikket satt på pause';

  @override
  String get youCanAtMaxDoubleYourStorage =>
      '* Du kan maksimalt doble lagringsplassen din';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true': 'Familien din har gjort krav på $storageAmountInGb GB så langt',
      'false': 'Du har gjort krav på $storageAmountInGb GB så langt',
      'other': 'Du har gjort krav på $storageAmountInGb GB så langt!',
    });
    return '$_temp0\n';
  }

  @override
  String get faq => 'Ofte stilte spørsmål';

  @override
  String get help => 'Hjelp';

  @override
  String get oopsSomethingWentWrong => 'Oisann! Noe gikk galt';

  @override
  String get peopleUsingYourCode => 'Personer som bruker koden din';

  @override
  String get eligible => 'kvalifisert';

  @override
  String get total => 'totalt';

  @override
  String get codeUsedByYou => 'Kode som brukes av deg';

  @override
  String get freeStorageClaimed => 'Gratis lagringplass aktivert';

  @override
  String get freeStorageUsable => 'Gratis lagringsplass som kan brukes';

  @override
  String get usableReferralStorageInfo =>
      'Brukbar lagringsplass er begrenset av abonnementet ditt. Lagring du har gjort krav på utover denne grensen blir automatisk tilgjengelig når du oppgraderer abonnementet ditt.';

  @override
  String get removeFromAlbumTitle => 'Fjern fra album?';

  @override
  String get removeFromAlbum => 'Fjern fra album';

  @override
  String get itemsWillBeRemovedFromAlbum =>
      'Valgte elementer vil bli fjernet fra dette albumet';

  @override
  String get removeShareItemsWarning =>
      'Noen av elementene du fjerner ble lagt til av andre personer, og du vil miste tilgang til dem';

  @override
  String get addingToFavorites => 'Legger til i favoritter...';

  @override
  String get removingFromFavorites => 'Fjerner fra favoritter...';

  @override
  String get sorryCouldNotAddToFavorites =>
      'Beklager, kan ikke legge til i favoritter!';

  @override
  String get sorryCouldNotRemoveFromFavorites =>
      'Beklager, kunne ikke fjerne fra favoritter!';

  @override
  String get subscribeToEnableSharing =>
      'Du trenger et aktivt betalt abonnement for å aktivere deling.';

  @override
  String get subscribe => 'Abonner';

  @override
  String get canOnlyRemoveFilesOwnedByYou =>
      'Du kan kun fjerne filer som eies av deg';

  @override
  String get deleteSharedAlbum => 'Slett delt album?';

  @override
  String get deleteAlbum => 'Slett album';

  @override
  String get deleteAlbumDialog =>
      'Også slette bilder (og videoer) i dette albumet fra <bold>alle</bold> andre album de er del av?';

  @override
  String get deleteSharedAlbumDialogBody =>
      'Albumet vil bli slettet for alle\n\nDu vil miste tilgang til delte bilder i dette albumet som eies av andre';

  @override
  String get yesRemove => 'Ja, fjern';

  @override
  String get creatingLink => 'Lager lenke...';

  @override
  String get removeWithQuestionMark => 'Fjern?';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return '$userEmail vil bli fjernet fra dette delte albumet\n\nAlle bilder lagt til av dem vil også bli fjernet fra albumet';
  }

  @override
  String get keepPhotos => 'Behold Bilder';

  @override
  String get deletePhotos => 'Slett bilder';

  @override
  String get inviteToEnte => 'Inviter til Ente';

  @override
  String get removePublicLink => 'Fjern offentlig lenke';

  @override
  String disableLinkMessage({required Object albumName}) {
    return 'Dette fjerner den offentlige lenken for tilgang til \"$albumName\".';
  }

  @override
  String get sharing => 'Deler...';

  @override
  String get youCannotShareWithYourself => 'Du kan ikke dele med deg selv';

  @override
  String get archive => 'Arkiv';

  @override
  String get createAlbumActionHint =>
      'Trykk og holde inne for å velge bilder, og trykk på + for å lage et album';

  @override
  String get importing => 'Importerer....';

  @override
  String get failedToLoadAlbums => 'Kunne ikke laste inn album';

  @override
  String get hidden => 'Skjult';

  @override
  String get authToViewYourHiddenFiles =>
      'Vennligst autentiser deg for å se dine skjulte filer';

  @override
  String get authToViewTrashedFiles =>
      'Vennligst autentiser deg for å se dine slettede filer';

  @override
  String get trash => 'Papirkurv';

  @override
  String get uncategorized => 'Ukategorisert';

  @override
  String get videoSmallCase => 'video';

  @override
  String get photoSmallCase => 'bilde';

  @override
  String get singleFileDeleteHighlight => 'Den vil bli slettet fra alle album.';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return 'Denne $fileType er både i Ente og på enheten din.';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return 'Denne $fileType vil bli slettet fra Ente.';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return 'Denne $fileType vil bli slettet fra enheten din.';
  }

  @override
  String get deleteFromEnte => 'Slett fra Ente';

  @override
  String get yesDelete => 'Ja, slett';

  @override
  String get movedToTrash => 'Flyttet til papirkurven';

  @override
  String get deleteFromDevice => 'Slett fra enhet';

  @override
  String get deleteFromBoth => 'Slett fra begge';

  @override
  String get newAlbum => 'Nytt album';

  @override
  String get albums => 'Album';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount minner',
      one: '$formattedCount minne',
      zero: 'ingen minner',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return '$count valgt';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return '$count valgt ($yourCount dine)';
  }

  @override
  String get advancedSettings => 'Avansert';

  @override
  String get photoGridSize => 'Bilderutenettstørrelse';

  @override
  String get manageDeviceStorage => 'Behandle enhetens hurtigbuffer';

  @override
  String get manageDeviceStorageDesc =>
      'Gjennomgå og fjern lokal hurtigbuffer.';

  @override
  String get machineLearning => 'Maskinlæring';

  @override
  String get mlConsent => 'Aktiver maskinlæring';

  @override
  String get mlConsentTitle => 'Aktiver maskinlæring?';

  @override
  String get mlConsentDescription =>
      'Hvis du aktiverer maskinlæring, vil Ente hente ut informasjon som ansiktsgeometri fra filer, inkludert de som er delt med deg.\n\nDette skjer på enheten din, og all generert biometrisk informasjon blir ende-til-ende-kryptert.';

  @override
  String get mlConsentPrivacy =>
      'Klikk her for mer informasjon om denne funksjonen i våre retningslinjer for personvern';

  @override
  String get mlConsentConfirmation =>
      'Jeg forstår, og ønsker å aktivere maskinlæring';

  @override
  String get magicSearch => 'Magisk søk';

  @override
  String get discover => 'Oppdag';

  @override
  String get discover_identity => 'Identitet';

  @override
  String get discover_screenshots => 'Skjermbilder';

  @override
  String get discover_receipts => 'Kvitteringer';

  @override
  String get discover_notes => 'Notater';

  @override
  String get discover_memes => 'Memes';

  @override
  String get discover_visiting_cards => 'Visittkort';

  @override
  String get discover_babies => 'Babyer';

  @override
  String get discover_pets => 'Kjæledyr';

  @override
  String get discover_selfies => 'Selfier';

  @override
  String get discover_wallpapers => 'Bakgrunnsbilder';

  @override
  String get discover_food => 'Mat';

  @override
  String get discover_celebrations => 'Feiringer';

  @override
  String get discover_sunset => 'Solnedgang';

  @override
  String get discover_hills => 'Åser';

  @override
  String get discover_greenery => 'Grøntområder';

  @override
  String get mlIndexingDescription =>
      'Vær oppmerksom på at maskinlæring vil resultere i høyere båndbredde og batteribruk inntil alle elementer er indeksert. Vurder å bruke skrivebordsappen for raskere indeksering, alle resultater vil bli synkronisert automatisk.';

  @override
  String get loadingModel => 'Laster ned modeller...';

  @override
  String get waitingForWifi => 'Venter på WiFi...';

  @override
  String get status => 'Status';

  @override
  String get indexedItems => 'Indekserte elementer';

  @override
  String get pendingItems => 'Ventende elementer';

  @override
  String get clearIndexes => 'Tøm indekser';

  @override
  String get selectFoldersForBackup => 'Velg mapper for sikkerhetskopiering';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      'Valgte mapper vil bli kryptert og sikkerhetskopiert';

  @override
  String get unselectAll => 'Velg bort alle';

  @override
  String get selectAll => 'Velg alle';

  @override
  String get skip => 'Hopp over';

  @override
  String get updatingFolderSelection => 'Oppdaterer mappevalg...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count elementer',
      one: '$count element',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Slett $count elementer',
      one: 'Slett $count element',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count filer, $formattedSize hver';
  }

  @override
  String get showMemories => 'Vis minner';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count år siden',
      one: '$count år siden',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'Sikkerhetskopier innstillinger';

  @override
  String get backupStatus => 'Status for sikkerhetskopi';

  @override
  String get backupStatusDescription =>
      'Elementer som har blitt sikkerhetskopiert vil vises her';

  @override
  String get backupOverMobileData => 'Sikkerhetskopier via mobildata';

  @override
  String get backupVideos => 'Sikkerhetskopier videoer';

  @override
  String get disableAutoLock => 'Deaktiver autolås';

  @override
  String get deviceLockExplanation =>
      'Deaktiver enhetens skjermlås når Ente er i forgrunnen og det er en sikkerhetskopi som pågår. Dette trengs normalt ikke, men kan hjelpe store opplastinger og førstegangsimport av store biblioteker med å fullføre raskere.';

  @override
  String get about => 'Om';

  @override
  String get weAreOpenSource => 'Vi har åpen kildekode!';

  @override
  String get privacy => 'Personvern';

  @override
  String get terms => 'Vilkår';

  @override
  String get checkForUpdates => 'Se etter oppdateringer';

  @override
  String get checkStatus => 'Kontroller status';

  @override
  String get checking => 'Sjekker...';

  @override
  String get youAreOnTheLatestVersion => 'Du er på den nyeste versjonen';

  @override
  String get account => 'Konto';

  @override
  String get manageSubscription => 'Administrer abonnement';

  @override
  String get authToChangeYourEmail =>
      'Vennlist autentiser deg for å endre e-postadressen din';

  @override
  String get changePassword => 'Bytt passord';

  @override
  String get authToChangeYourPassword =>
      'Vennligst autentiser deg for å endre passordet ditt';

  @override
  String get emailVerificationToggle => 'E-postbekreftelse';

  @override
  String get authToChangeEmailVerificationSetting =>
      'Vennligst autentiser deg for å endre e-postbekreftelse';

  @override
  String get exportYourData => 'Eksporter dine data';

  @override
  String get logout => 'Logg ut';

  @override
  String get authToInitiateAccountDeletion =>
      'Vennlist autentiser deg for å starte sletting av konto';

  @override
  String get areYouSureYouWantToLogout => 'Er du sikker på at du vil logge ut?';

  @override
  String get yesLogout => 'Ja, logg ut';

  @override
  String get aNewVersionOfEnteIsAvailable =>
      'En ny versjon av Ente er tilgjengelig.';

  @override
  String get update => 'Oppdater';

  @override
  String get installManually => 'Installer manuelt';

  @override
  String get criticalUpdateAvailable => 'Kritisk oppdatering er tilgjengelig';

  @override
  String get updateAvailable => 'En oppdatering er tilgjengelig';

  @override
  String get ignoreUpdate => 'Ignorer';

  @override
  String get downloading => 'Laster ned...';

  @override
  String get cannotDeleteSharedFiles => 'Kan ikke slette delte filer';

  @override
  String get theDownloadCouldNotBeCompleted =>
      'Nedlastingen kunne ikke fullføres';

  @override
  String get retry => 'Prøv på nytt';

  @override
  String get backedUpFolders => 'Sikkerhetskopierte mapper';

  @override
  String get backup => 'Sikkerhetskopi';

  @override
  String get freeUpDeviceSpace => 'Frigjør plass på enheten';

  @override
  String get freeUpDeviceSpaceDesc =>
      'Spar plass på enheten ved å fjerne filer som allerede er sikkerhetskopiert.';

  @override
  String get allClear => '✨ Alt klart';

  @override
  String get noDeviceThatCanBeDeleted =>
      'Du har ingen filer i dette albumet som kan bli slettet';

  @override
  String get removeDuplicates => 'Fjern duplikater';

  @override
  String get removeDuplicatesDesc =>
      'Gjennomgå og fjern filer som er eksakte duplikater.';

  @override
  String get viewLargeFiles => 'Store filer';

  @override
  String get viewLargeFilesDesc => 'Vis filer som bruker mest lagringsplass.';

  @override
  String get noDuplicates => '✨ Ingen duplikater';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared =>
      'Du har ingen duplikatfiler som kan fjernes';

  @override
  String get success => 'Suksess';

  @override
  String get rateUs => 'Vurder oss';

  @override
  String get remindToEmptyDeviceTrash =>
      'Tøm også \"Nylig slettet\" fra \"Innstillinger\" → \"Lagring\" for å få frigjort plass';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return 'Du har frigjort $storageSaved!';
  }

  @override
  String get remindToEmptyEnteTrash =>
      'Du kan også tømme \"Papirkurven\" for å få den frigjorte lagringsplassen';

  @override
  String get sparkleSuccess => '✨ Suksess';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count duplikatfiler',
      one: '$count duplikatfil',
    );
    return 'Du har ryddet bort $_temp0, som frigjør ($storageSaved!)';
  }

  @override
  String get familyPlans => 'Familieabonnementer';

  @override
  String get referrals => 'Vervinger';

  @override
  String get notifications => 'Varslinger';

  @override
  String get sharedPhotoNotifications => 'Nye delte bilder';

  @override
  String get sharedPhotoNotificationsExplanation =>
      'Motta varsler når noen legger til et bilde i et delt album som du er en del av';

  @override
  String get advanced => 'Avansert';

  @override
  String get general => 'Generelt';

  @override
  String get security => 'Sikkerhet';

  @override
  String get authToViewYourRecoveryKey =>
      'Vennligst autentiser deg for å se gjennopprettingsnøkkelen din';

  @override
  String get twofactor => 'Tofaktor';

  @override
  String get authToConfigureTwofactorAuthentication =>
      'Autentiser deg for å konfigurere tofaktorautentisering';

  @override
  String get lockscreen => 'Låseskjerm';

  @override
  String get authToChangeLockscreenSetting =>
      'Autentiser deg for å endre låseskjerminnstillingen';

  @override
  String get viewActiveSessions => 'Vis aktive økter';

  @override
  String get authToViewYourActiveSessions =>
      'Vennligst autentiser deg for å se dine aktive økter';

  @override
  String get disableTwofactor => 'Deaktiver tofaktor';

  @override
  String get confirm2FADisable =>
      'Er du sikker på at du vil deaktivere tofaktorautentisering?';

  @override
  String get no => 'Nei';

  @override
  String get yes => 'Ja';

  @override
  String get social => 'Sosial';

  @override
  String rateUsOnStore({required Object storeName}) {
    return 'Vurder oss på $storeName';
  }

  @override
  String get blog => 'Blogg';

  @override
  String get merchandise => 'Varer';

  @override
  String get twitter => 'Twitter';

  @override
  String get mastodon => 'Mastodon';

  @override
  String get matrix => 'Matrix';

  @override
  String get discord => 'Discord';

  @override
  String get reddit => 'Reddit';

  @override
  String get yourStorageDetailsCouldNotBeFetched =>
      'Lagringsdetaljene dine kunne ikke hentes';

  @override
  String get reportABug => 'Rapporter en feil';

  @override
  String get reportBug => 'Rapporter feil';

  @override
  String get suggestFeatures => 'Foreslå funksjoner';

  @override
  String get support => 'Brukerstøtte';

  @override
  String get theme => 'Tema';

  @override
  String get lightTheme => 'Lys';

  @override
  String get darkTheme => 'Mørk';

  @override
  String get systemTheme => 'System';

  @override
  String get freeTrial => 'Gratis prøveversjon';

  @override
  String get selectYourPlan => 'Velg abonnementet ditt';

  @override
  String get enteSubscriptionPitch =>
      'Ente bevarer minnene dine, slik at de er alltid tilgjengelig for deg, selv om du mister enheten.';

  @override
  String get enteSubscriptionShareWithFamily =>
      'Familien din kan også legges til abonnementet ditt.';

  @override
  String get currentUsageIs => 'Nåværende bruk er ';

  @override
  String get faqs => 'Ofte stilte spørsmål';

  @override
  String renewsOn({required Object endDate}) {
    return 'Abonnement fornyes på $endDate';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return 'Prøveperioden varer til $endDate';
  }

  @override
  String validTill({required Object endDate}) {
    return 'Gyldig til $endDate';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return 'Tillegget på $storageAmount er gyldig til $endDate';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return 'Prøveperioden varer til $endDate.\nDu kan velge en betalt plan etterpå.';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'Abonnementet ditt blir avsluttet den $endDate';
  }

  @override
  String get subscription => 'Abonnement';

  @override
  String get paymentDetails => 'Betalingsinformasjon';

  @override
  String get manageFamily => 'Administrer familie';

  @override
  String contactToManageSubscription({required Object provider}) {
    return 'Kontakt oss på support@ente.io for å administrere ditt $provider abonnement.';
  }

  @override
  String get renewSubscription => 'Forny abonnement';

  @override
  String get cancelSubscription => 'Avslutt abonnement';

  @override
  String get areYouSureYouWantToRenew => 'Er du sikker på at du vil fornye?';

  @override
  String get yesRenew => 'Ja, forny';

  @override
  String get areYouSureYouWantToCancel => 'Er du sikker på at du vil avslutte?';

  @override
  String get yesCancel => 'Ja, avslutt';

  @override
  String get failedToRenew => 'Kunne ikke fornye';

  @override
  String get failedToCancel => 'Kan ikke avbryte';

  @override
  String get twoMonthsFreeOnYearlyPlans => '2 måneder gratis med årsabonnement';

  @override
  String get monthly => 'Månedlig';

  @override
  String get yearly => 'Årlig';

  @override
  String get confirmPlanChange => 'Bekreft endring av abonnement';

  @override
  String get areYouSureYouWantToChangeYourPlan =>
      'Er du sikker på at du vil endre abonnement?';

  @override
  String get youCannotDowngradeToThisPlan =>
      'Du kan ikke nedgradere til dette abonnementet';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'Vennlist avslutt ditt eksisterende abonnement fra $paymentProvider først';
  }

  @override
  String get optionalAsShortAsYouLike => 'Valgfri, så kort som du vil...';

  @override
  String get send => 'Send';

  @override
  String get askCancelReason =>
      'Abonnementet ble avbrutt. Ønsker du å dele grunnen?';

  @override
  String get thankYouForSubscribing => 'Takk for at du abonnerer!';

  @override
  String get yourPurchaseWasSuccessful => 'Ditt kjøp var vellykket';

  @override
  String get yourPlanWasSuccessfullyUpgraded =>
      'Abonnementet ditt ble oppgradert';

  @override
  String get yourPlanWasSuccessfullyDowngraded =>
      'Abonnementet ditt ble nedgradert';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully =>
      'Abonnementet ditt ble oppdatert';

  @override
  String get googlePlayId => 'Google Play ID';

  @override
  String get appleId => 'Apple ID';

  @override
  String get playstoreSubscription => 'PlayStore abonnement';

  @override
  String get appstoreSubscription => 'AppStore subscription';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return 'Din $id er allerede koblet til en annen Ente-konto.\nHvis du ønsker å bruke din $id med denne kontoen, vennligst kontakt vår brukerstøtte\'\'';
  }

  @override
  String get visitWebToManage =>
      'Vennligst besøk web.ente.io for å administrere abonnementet';

  @override
  String get couldNotUpdateSubscription => 'Kunne ikke oppdatere abonnement';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      'Vennligst kontakt support@ente.io og vi vil gjerne hjelpe!';

  @override
  String get paymentFailed => 'Betaling feilet';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return 'Snakk med $providerName kundestøtte hvis du ble belastet';
  }

  @override
  String get continueOnFreeTrial => 'Fortsett med gratis prøveversjon';

  @override
  String get areYouSureYouWantToExit => 'Er du sikker på at du vil avslutte?';

  @override
  String get thankYou => 'Tusen takk';

  @override
  String get failedToVerifyPaymentStatus =>
      'Kunne ikke verifisere betalingsstatus';

  @override
  String get pleaseWaitForSometimeBeforeRetrying =>
      'Vennligst vent en stund før du prøver på nytt';

  @override
  String get paymentFailedMessage =>
      'Betalingen din mislyktes. Kontakt kundestøtte og vi vil hjelpe deg!';

  @override
  String get youAreOnAFamilyPlan => 'Du har et familieabonnement!';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'Vennligst kontakt <green>$familyAdminEmail</green> for å administrere abonnementet';
  }

  @override
  String get leaveFamily => 'Forlat familie';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily =>
      'Er du sikker på at du vil forlate familieabonnementet?';

  @override
  String get leave => 'Forlat';

  @override
  String get rateTheApp => 'Vurder appen';

  @override
  String get startBackup => 'Start sikkerhetskopiering';

  @override
  String get noPhotosAreBeingBackedUpRightNow =>
      'Ingen bilder er blitt sikkerhetskopiert akkurat nå';

  @override
  String get preserveMore => 'Behold mer';

  @override
  String get grantFullAccessPrompt =>
      'Vennligst gi tilgang til alle bilder i Innstillinger-appen';

  @override
  String get allowPermTitle => 'Gi tilgang til bilder';

  @override
  String get allowPermBody =>
      'Vennligst gi tilgang til bildene dine i Innstillinger, slik at Ente kan vise og sikkerhetskopiere biblioteket.';

  @override
  String get openSettings => 'Åpne innstillinger';

  @override
  String get selectMorePhotos => 'Velg flere bilder';

  @override
  String get existingUser => 'Eksisterende bruker';

  @override
  String get privateBackups => 'Private sikkerhetskopier';

  @override
  String get forYourMemories => 'for dine minner';

  @override
  String get endtoendEncryptedByDefault =>
      'Ende-til-ende kryptert som standard';

  @override
  String get safelyStored => 'Trygt lagret';

  @override
  String get atAFalloutShelter => 'i en bunker';

  @override
  String get designedToOutlive => 'Laget for å vare lenger enn';

  @override
  String get available => 'Tilgjengelig';

  @override
  String get everywhere => 'Overalt';

  @override
  String get androidIosWebDesktop => 'Android, iOS, Web, Desktop';

  @override
  String get mobileWebDesktop => 'Mobil, Web, Datamaskin';

  @override
  String get newToEnte => 'Ny til Ente';

  @override
  String get pleaseLoginAgain => 'Vennligst logg inn igjen';

  @override
  String get autoLogoutMessage =>
      'Du har blitt logget ut på grunn av en teknisk feil. Vi beklager ulempen.';

  @override
  String get yourSubscriptionHasExpired => 'Abonnementet har utløpt';

  @override
  String get storageLimitExceeded => 'Lagringsplassen er full';

  @override
  String get upgrade => 'Oppgrader';

  @override
  String get raiseTicket => 'Opprett sak';

  @override
  String get backupFailed => 'Sikkerhetskopiering mislyktes';

  @override
  String get sorryBackupFailedDesc =>
      'Beklager, vi kunne ikke sikkerhetskopiere denne filen akkurat nå, vil vi prøve på nytt senere.';

  @override
  String get couldNotBackUpTryLater =>
      'Vi kunne ikke sikkerhetskopiere dine data.\nVi vil prøve på nytt senere.';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      'Ente kan bare kryptere og bevare filer hvis du gir tilgang til dem';

  @override
  String get pleaseGrantPermissions => 'Vennligst gi tillatelser';

  @override
  String get grantPermission => 'Gi tillatelse';

  @override
  String get privateSharing => 'Privat deling';

  @override
  String get shareOnlyWithThePeopleYouWant => 'Del bare med de du vil';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      'Bruk offentlige lenker for folk som ikke bruker Ente';

  @override
  String get allowPeopleToAddPhotos => 'Tillat folk å legge til bilder';

  @override
  String get shareAnAlbumNow => 'Del et album nå';

  @override
  String get collectEventPhotos => 'Samle arrangementbilder';

  @override
  String get sessionExpired => 'Økten har utløpt';

  @override
  String get loggingOut => 'Logger ut...';

  @override
  String get onDevice => 'På enhet';

  @override
  String get onEnte => 'På <branding>ente</branding>';

  @override
  String get name => 'Navn';

  @override
  String get newest => 'Nyeste';

  @override
  String get lastUpdated => 'Sist oppdatert';

  @override
  String get deleteEmptyAlbums => 'Slett tomme album';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => 'Slette tomme albumer?';

  @override
  String get deleteAlbumsDialogBody =>
      'Dette vil slette alle tomme albumer. Dette er nyttig når du vil redusere rotet i albumlisten din.';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return 'Sletter $currentlyDeleting / $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return 'Behandler $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => 'Slette for godt';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou =>
      'Kan bare opprette link for filer som eies av deg';

  @override
  String get publicLinkCreated => 'Offentlig lenke opprettet';

  @override
  String get youCanManageYourLinksInTheShareTab =>
      'Du kan administrere koblingene dine i fanen for deling.';

  @override
  String get linkCopiedToClipboard => 'Lenker er kopiert til utklippstavlen';

  @override
  String get restore => 'Gjenopprett';

  @override
  String get moveToAlbum => 'Flytt til album';

  @override
  String get unhide => 'Gjør synligjort';

  @override
  String get unarchive => 'Opphev arkivering';

  @override
  String get favorite => 'Favoritt';

  @override
  String get removeFromFavorite => 'Fjern fra favoritter';

  @override
  String get shareLink => 'Del link';

  @override
  String get createCollage => 'Opprett kollasje';

  @override
  String get saveCollage => 'Lagre kollasje';

  @override
  String get collageSaved => 'Kollasje lagret i galleriet';

  @override
  String get collageLayout => 'Utforming';

  @override
  String get addToEnte => 'Legg til i Ente';

  @override
  String get addToAlbum => 'Legg til i album';

  @override
  String get delete => 'Slett';

  @override
  String get hide => 'Skjul';

  @override
  String get share => 'Del';

  @override
  String get unhideToAlbum => 'Gjør synlig i album';

  @override
  String get restoreToAlbum => 'Gjenopprett til album';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Flytt elementene',
      one: 'Flytt elementet',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Legg til elementene',
      one: 'Legg til element',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'Opprett eller velg album';

  @override
  String get selectAlbum => 'Velg album';

  @override
  String get searchByAlbumNameHint => 'Albumnavn';

  @override
  String get albumTitle => 'Albumtittel';

  @override
  String get enterAlbumName => 'Skriv inn albumnavn';

  @override
  String get restoringFiles => 'Gjenoppretter filer...';

  @override
  String get movingFilesToAlbum => 'Flytter filer til album...';

  @override
  String get unhidingFilesToAlbum => 'Gjør filer synlige i albumet';

  @override
  String get canNotUploadToAlbumsOwnedByOthers =>
      'Kan ikke laste opp til album eid av andre';

  @override
  String get uploadingFilesToAlbum => 'Laster opp filer til albumet...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return 'Lagt til $albumName';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return 'Flyttet til $albumName';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'Dette albumet har allerede en samarbeidslenke';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return 'Samarbeidslenke er opprettet for $albumName';
  }

  @override
  String get askYourLovedOnesToShare => 'Spør dine kjære om å dele';

  @override
  String get invite => 'Inviter';

  @override
  String get shareYourFirstAlbum => 'Del ditt første album';

  @override
  String sharedWith({required Object emailIDs}) {
    return 'Delt med $emailIDs';
  }

  @override
  String get sharedWithMe => 'Delt med meg';

  @override
  String get sharedByMe => 'Delt av meg';

  @override
  String get doubleYourStorage => 'Doble lagringsplassen din';

  @override
  String get referFriendsAnd2xYourPlan =>
      'Verv venner og doble abonnementet ditt';

  @override
  String get shareAlbumHint =>
      'Åpne et album og trykk på del-knappen øverst til høyre for å dele.';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      'Elementer viser gjenværende dager før de slettes for godt';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count dager',
      one: '1 dag',
      zero: 'Snart',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => 'Slett alt';

  @override
  String get renameAlbum => 'Gi album nytt navn';

  @override
  String get convertToAlbum => 'Gjør om til album';

  @override
  String get setCover => 'Angi forside';

  @override
  String get sortAlbumsBy => 'Sorter etter';

  @override
  String get sortNewestFirst => 'Nyeste først';

  @override
  String get sortOldestFirst => 'Eldste først';

  @override
  String get rename => 'Endre navn';

  @override
  String get leaveSharedAlbum => 'Slett delt album?';

  @override
  String get leaveAlbum => 'Forlat album';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'Bilder lagt til av deg vil bli fjernet fra albumet';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted =>
      'Du har ingen filer i dette albumet som kan bli slettet';

  @override
  String get youDontHaveAnyArchivedItems => 'Du har ingen arkiverte elementer.';

  @override
  String get ignoredFolderUploadReason =>
      'Noen filer i dette albumet ble ikke lastet opp fordi de tidligere har blitt slettet fra Ente.';

  @override
  String get resetIgnoredFiles => 'Tilbakestill ignorerte filer';

  @override
  String get deviceFilesAutoUploading =>
      'Filer lagt til dette enhetsalbumet vil automatisk bli lastet opp til Ente.';

  @override
  String get turnOnBackupForAutoUpload =>
      'Slå på sikkerhetskopi for å automatisk laste opp filer lagt til denne enhetsmappen i Ente.';

  @override
  String get noHiddenPhotosOrVideos => 'Ingen skjulte bilder eller videoer';

  @override
  String get toHideAPhotoOrVideo => 'For å skjule et bilde eller video';

  @override
  String get openTheItem => '• Åpne elementet';

  @override
  String get clickOnTheOverflowMenu => '• Klikk på menyen med tre prikker';

  @override
  String get click => '• Klikk';

  @override
  String get nothingToSeeHere => 'Ingenting å se her! 👀';

  @override
  String get unarchiveAlbum => 'Gjenopprett album';

  @override
  String get archiveAlbum => 'Arkiver album';

  @override
  String get calculating => 'Beregner...';

  @override
  String get pleaseWaitDeletingAlbum => 'Vennligst vent, sletter album';

  @override
  String get searchByExamples =>
      '• Albumnavn (f.eks. \"Kamera\")\n• Filtyper (f.eks. \"Videoer\", \".gif\")\n• År og måneder (f.eks. \"2022\", \"January\")\n• Hellidager (f.eks. \"Jul\")\n• Bildebeskrivelser (f.eks. \"#moro\")';

  @override
  String get youCanTrySearchingForADifferentQuery =>
      'Du kan prøve å søke etter noe annet.';

  @override
  String get noResultsFound => 'Ingen resultater funnet';

  @override
  String addedBy({required Object emailOrName}) {
    return 'Lagt til av $emailOrName';
  }

  @override
  String get loadingExifData => 'Laster inn EXIF-data...';

  @override
  String get viewAllExifData => 'Vis alle EXIF-data';

  @override
  String get noExifData => 'Ingen EXIF-data';

  @override
  String get thisImageHasNoExifData => 'Dette bildet har ingen exif-data';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => 'Ingen resultater';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'Vi støtter ikke redigering av bilder og album som du ikke eier ennå';

  @override
  String get failedToFetchOriginalForEdit =>
      'Kunne ikke hente originalen for redigering';

  @override
  String get close => 'Lukk';

  @override
  String get setAs => 'Angi som';

  @override
  String get fileSavedToGallery => 'Fil lagret i galleriet';

  @override
  String get filesSavedToGallery => 'Filer lagret i galleriet';

  @override
  String get fileFailedToSaveToGallery => 'Kunne ikke lagre filen i galleriet';

  @override
  String get download => 'Last ned';

  @override
  String get pressAndHoldToPlayVideo =>
      'Trykk og hold inne for å spille av video';

  @override
  String get pressAndHoldToPlayVideoDetailed =>
      'Trykk og hold inne bildet for å spille av video';

  @override
  String get downloadFailed => 'Nedlasting mislyktes';

  @override
  String get deduplicateFiles => 'Fjern duplikatfiler';

  @override
  String get deselectAll => 'Fjern alle valg';

  @override
  String get reviewDeduplicateItems =>
      'Vennligst gjennomgå og slett elementene du tror er duplikater.';

  @override
  String get clubByCaptureTime => 'Grupper etter tidspunkt for opptak';

  @override
  String get clubByFileName => 'Grupper etter filnavn';

  @override
  String get count => 'Antall';

  @override
  String get totalSize => 'Total størrelse';

  @override
  String get longpressOnAnItemToViewInFullscreen =>
      'Lang-trykk på en gjenstand for å vise i fullskjerm';

  @override
  String get decryptingVideo => 'Dekrypterer video...';

  @override
  String get authToViewYourMemories =>
      'Vennligst autentiser deg for å se minnene dine';

  @override
  String get unlock => 'Lås opp';

  @override
  String get freeUpSpace => 'Frigjør lagringsplass';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'De kan slettes fra enheten for å frigjøre $formattedSize',
      one: 'Det kan slettes fra enheten for å frigi $formattedSize',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber filer',
      one: '1 fil',
    );
    return '$_temp0 I dette albumet har blitt sikkerhetskopiert';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber filer',
      one: '1 fil',
    );
    return '$_temp0 på denne enheten har blitt sikkerhetskopiert';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'dem',
      one: 'det',
    );
    return 'Du kan fortsatt få tilgang til $_temp0 på Ente så lenge du har et aktivt abonnement';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return 'Frigjør $sizeInMBorGB';
  }

  @override
  String get thisEmailIsAlreadyInUse =>
      'Denne e-postadressen er allerede i bruk';

  @override
  String get incorrectCode => 'Feil kode';

  @override
  String get authenticationFailedPleaseTryAgain =>
      'Autentisering mislyktes, prøv igjen';

  @override
  String get verificationFailedPleaseTryAgain =>
      'Bekreftelse mislyktes, vennligst prøv igjen';

  @override
  String get authenticating => 'Autentiserer...';

  @override
  String get authenticationSuccessful => 'Autentisering var vellykket!';

  @override
  String get incorrectRecoveryKey => 'Feil gjenopprettingsnøkkel';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect =>
      'Gjennopprettingsnøkkelen du skrev inn er feil';

  @override
  String get twofactorAuthenticationSuccessfullyReset =>
      'Tofaktorautentisering ble tilbakestilt';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered =>
      'Bekreft koden du har skrevet inn';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      'Vennligst kontakt kundestøtte hvis problemet vedvarer';

  @override
  String get twofactorAuthenticationHasBeenDisabled =>
      'Tofaktorautentisering har blitt deaktivert';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect =>
      'Beklager, koden du skrev inn er feil';

  @override
  String get yourVerificationCodeHasExpired => 'Bekreftelseskoden er utløpt';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'E-postadressen er endret til $newEmail';
  }

  @override
  String get verifying => 'Verifiserer...';

  @override
  String get disablingTwofactorAuthentication =>
      'Deaktiverer tofaktorautentisering...';

  @override
  String get allMemoriesPreserved => 'Alle minner bevart';

  @override
  String get loadingGallery => 'Laster galleri...';

  @override
  String get syncing => 'Synkroniserer...';

  @override
  String get encryptingBackup => 'Krypterer sikkerhetskopi...';

  @override
  String get syncStopped => 'Synkronisering stoppet';

  @override
  String syncProgress({required String completed, required String total}) {
    return '$completed/$total minner bevart';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return 'Bevarer $count minner...';
  }

  @override
  String get uploadingSingleMemory => 'Bevarer 1 minne...';

  @override
  String get archiving => 'Legger til i arkivet...';

  @override
  String get unarchiving => 'Fjerner fra arkivet...';

  @override
  String get successfullyArchived => 'Lagt til i arkivet';

  @override
  String get successfullyUnarchived => 'Fjernet fra arkviet';

  @override
  String get renameFile => 'Gi nytt filnavn';

  @override
  String get enterFileName => 'Skriv inn filnavn';

  @override
  String get filesDeleted => 'Filene er slettet';

  @override
  String get selectedFilesAreNotOnEnte => 'Valgte filer er ikke på Ente';

  @override
  String get thisActionCannotBeUndone => 'Denne handlingen kan ikke angres';

  @override
  String get emptyTrash => 'Tøm papirkurv?';

  @override
  String get permDeleteWarning =>
      'Alle elementer i papirkurven vil slettes permanent\n\nDenne handlingen kan ikke angres';

  @override
  String get empty => 'Tom';

  @override
  String get couldNotFreeUpSpace => 'Kunne ikke frigjøre plass';

  @override
  String get permanentlyDeleteFromDevice => 'Slett permanent fra enhet?';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      'Noen av filene du prøver å slette, er kun tilgjengelig på enheten og kan ikke gjenopprettes dersom det blir slettet';

  @override
  String get theyWillBeDeletedFromAllAlbums =>
      'De vil bli slettet fra alle album.';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'Noen elementer er i både Ente og på enheten din.';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      'Valgte elementer vil bli slettet fra alle album og flyttet til papirkurven.';

  @override
  String get theseItemsWillBeDeletedFromYourDevice =>
      'Disse elementene vil bli slettet fra enheten din.';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      'Det ser ut til at noe gikk galt. Prøv på nytt etter en stund. Hvis feilen vedvarer, kan du kontakte kundestøtte.';

  @override
  String get error => 'Feil';

  @override
  String get tempErrorContactSupportIfPersists =>
      'Det ser ut som noe gikk galt. Prøv på nytt etter en stund. Hvis feilen vedvarer, kontakt kundestøtte.';

  @override
  String get networkHostLookUpErr =>
      'Kan ikke koble til Ente, kontroller nettverksinnstillingene og kontakt kundestøtte hvis feilen vedvarer.';

  @override
  String get networkConnectionRefusedErr =>
      'Kan ikke koble til Ente, prøv igjen etter en stund. Hvis feilen vedvarer, vennligst kontakt kundestøtte.';

  @override
  String get cachedData => 'Bufrede data';

  @override
  String get clearCaches => 'Tom hurtigbuffer';

  @override
  String get remoteImages => 'Eksterne bilder';

  @override
  String get remoteVideos => 'Eksterne videoer';

  @override
  String get remoteThumbnails => 'Eksterne miniatyrbilder';

  @override
  String get pendingSync => 'Ventende synkronisering';

  @override
  String get localGallery => 'Lokalt galleri';

  @override
  String get todaysLogs => 'Dagens logger';

  @override
  String get viewLogs => 'Se logger';

  @override
  String get logsDialogBody =>
      'Dette vil sende over logger for å hjelpe oss med å feilsøke problemet. Vær oppmerksom på at filnavn vil bli inkludert for å hjelpe å spore problemer med spesifikke filer.';

  @override
  String get preparingLogs => 'Forbereder logger...';

  @override
  String get emailYourLogs => 'Send loggene dine på e-post';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'Vennligst send loggene til \n$toEmail';
  }

  @override
  String get copyEmailAddress => 'Kopier e-postadresse';

  @override
  String get exportLogs => 'Eksporter logger';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return 'Vennligst send oss en e-post på $toEmail';
  }

  @override
  String get dismiss => 'Avvis ';

  @override
  String get didYouKnow => 'Visste du at?';

  @override
  String get loadingMessage => 'Laster bildene dine...';

  @override
  String get loadMessage1 => 'Du kan dele abonnementet med familien din';

  @override
  String get loadMessage2 => 'Vi har bevart over 200 millioner minner så langt';

  @override
  String get loadMessage3 =>
      'Vi beholder 3 kopier av dine data, en i en underjordisk bunker';

  @override
  String get loadMessage4 => 'Alle våre apper har åpen kildekode';

  @override
  String get loadMessage5 =>
      'Vår kildekode og kryptografi har blitt revidert eksternt';

  @override
  String get loadMessage6 => 'Du kan dele lenker til dine album med dine kjære';

  @override
  String get loadMessage7 =>
      'Våre mobilapper kjører i bakgrunnen for å kryptere og sikkerhetskopiere de nye bildene du klikker';

  @override
  String get loadMessage8 => 'web.ente.io har en flott opplaster';

  @override
  String get loadMessage9 =>
      'Vi bruker Xcha20Poly1305 for å trygt kryptere dataene dine';

  @override
  String get photoDescriptions => 'Bildebeskrivelser';

  @override
  String get fileTypesAndNames => 'Filtyper og navn';

  @override
  String get location => 'Plassering';

  @override
  String get moments => 'Øyeblikk';

  @override
  String get searchFaceEmptySection =>
      'Folk vil vises her når indeksering er gjort';

  @override
  String get searchDatesEmptySection => 'Søk etter dato, måned eller år';

  @override
  String get searchLocationEmptySection =>
      'Gruppebilder som er tatt innenfor noen radius av et bilde';

  @override
  String get searchPeopleEmptySection =>
      'Inviter folk, og du vil se alle bilder som deles av dem her';

  @override
  String get searchAlbumsEmptySection => 'Album';

  @override
  String get searchFileTypesAndNamesEmptySection => 'Filtyper og navn';

  @override
  String get searchCaptionEmptySection =>
      'Legg til beskrivelser som \"#tur\" i bildeinfo for raskt å finne dem her';

  @override
  String get language => 'Språk';

  @override
  String get selectLanguage => 'Velg språk';

  @override
  String get locationName => 'Stedsnavn';

  @override
  String get addLocation => 'Legg til sted';

  @override
  String get groupNearbyPhotos => 'Grupper nærliggende bilder';

  @override
  String get kiloMeterUnit => 'km';

  @override
  String get addLocationButton => 'Legg til';

  @override
  String get radius => 'Radius';

  @override
  String get locationTagFeatureDescription =>
      'En plasseringsetikett grupperer alle bilder som ble tatt innenfor en gitt radius av et bilde';

  @override
  String get galleryMemoryLimitInfo => 'Opptil 1000 minner vist i galleriet';

  @override
  String get save => 'Lagre';

  @override
  String get centerPoint => 'Midtstill punkt';

  @override
  String get pickCenterPoint => 'Velg midtpunkt';

  @override
  String get useSelectedPhoto => 'Bruk valgt bilde';

  @override
  String get resetToDefault => 'Tilbakestill til standard';

  @override
  String get edit => 'Rediger';

  @override
  String get deleteLocation => 'Slett sted';

  @override
  String get rotateLeft => 'Roter mot venstre';

  @override
  String get flip => 'Speilvend';

  @override
  String get rotateRight => 'Roter mot høyre';

  @override
  String get saveCopy => 'Lagre en kopi';

  @override
  String get light => 'Lys';

  @override
  String get color => 'Farge';

  @override
  String get yesDiscardChanges => 'Ja, forkast endringer';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade =>
      'Vil du forkaste endringene du har gjort?';

  @override
  String get saving => 'Lagrer...';

  @override
  String get editsSaved => 'Endringer lagret';

  @override
  String get oopsCouldNotSaveEdits => 'Oisann, kunne ikke lagre endringer';

  @override
  String get distanceInKMUnit => 'km';

  @override
  String get dayToday => 'I dag';

  @override
  String get dayYesterday => 'I går';

  @override
  String get storage => 'Lagring';

  @override
  String get usedSpace => 'Benyttet lagringsplass';

  @override
  String get storageBreakupFamily => 'Familie';

  @override
  String get storageBreakupYou => 'Deg';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return '$usedAmount $usedStorageUnit av $totalAmount $totalStorageUnit brukt';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return '$freeAmount $storageUnit ledig';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'Versjon: $versionValue';
  }

  @override
  String get verifyIDLabel => 'Bekreft';

  @override
  String get fileInfoAddDescHint => 'Legg til en beskrivelse...';

  @override
  String get editLocationTagTitle => 'Rediger plassering';

  @override
  String get setLabel => 'Angi';

  @override
  String get setRadius => 'Angi radius';

  @override
  String get familyPlanPortalTitle => 'Familie';

  @override
  String get familyPlanOverview =>
      'Legg til 5 familiemedlemmer til det eksisterende abonnementet uten å betale ekstra.\n\nHvert medlem får sitt eget private område, og kan ikke se hverandres filer med mindre de er delt.\n\nFamilieabonnement er tilgjengelige for kunder som har et betalt Ente-abonnement.\n\nAbonner nå for å komme i gang!';

  @override
  String get androidBiometricHint => 'Verifiser identitet';

  @override
  String get androidBiometricNotRecognized => 'Ikke gjenkjent. Prøv igjen.';

  @override
  String get androidBiometricSuccess => 'Vellykket';

  @override
  String get androidCancelButton => 'Avbryt';

  @override
  String get androidSignInTitle => 'Krever innlogging';

  @override
  String get androidBiometricRequiredTitle => 'Biometri kreves';

  @override
  String get androidDeviceCredentialsRequiredTitle =>
      'Enhetens påloggingsinformasjon kreves';

  @override
  String get androidDeviceCredentialsSetupDescription =>
      'Enhetens påloggingsinformasjon kreves';

  @override
  String get goToSettings => 'Gå til innstillinger';

  @override
  String get androidGoToSettingsDescription =>
      'Biometrisk autentisering er ikke satt opp på enheten din. Gå til \'Innstillinger > Sikkerhet\' for å legge til biometrisk godkjenning.';

  @override
  String get iOSLockOut =>
      'Biometrisk autentisering er deaktivert. Vennligst lås og lås opp skjermen for å aktivere den.';

  @override
  String get iOSGoToSettingsDescription =>
      'Biometrisk autentisering er ikke satt opp på enheten din. Aktiver enten Touch-ID eller Ansikts-ID på telefonen.';

  @override
  String get iOSOkButton => 'OK';

  @override
  String get openstreetmapContributors => 'OpenStreetMap bidragsytere';

  @override
  String get hostedAtOsmFrance => 'Hostet på OSM France';

  @override
  String get map => 'Kart';

  @override
  String get maps => 'Kart';

  @override
  String get mapsPrivacyNotice =>
      'Approximate coordinates will be sent to privacy conscious third parties like OpenStreetMap to show the map and location.';

  @override
  String get enableMaps => 'Aktiver kart';

  @override
  String get quickLinks => 'Hurtiglenker';

  @override
  String get selectItemsToAdd => 'Velg produkter å legge til';

  @override
  String get addSelected => 'Legg til valgte';

  @override
  String get addFromDevice => 'Legg til fra enhet';

  @override
  String get addPhotos => 'Legg til bilder';

  @override
  String get noPhotosFoundHere => 'Ingen bilder funnet her';

  @override
  String get zoomOutToSeePhotos => 'Zoom ut for å se bilder';

  @override
  String get noImagesWithLocation => 'Ingen bilder med plassering';

  @override
  String get unpinAlbum => 'Løsne album';

  @override
  String get pinAlbum => 'Fest album';

  @override
  String get pin => 'Pin';

  @override
  String get pinPerson => 'Pin person';

  @override
  String get pinToTop => 'Pin to top';

  @override
  String get unpin => 'Unpin';

  @override
  String get unpinPerson => 'Unpin person';

  @override
  String get visibility => 'Visibility';

  @override
  String get hideFromMemories => 'Hide from memories';

  @override
  String get showInMemories => 'Show in memories';

  @override
  String get create => 'Opprett';

  @override
  String get viewAll => 'Vis alle';

  @override
  String get nothingSharedWithYouYet => 'Ingenting delt med deg enda';

  @override
  String get noAlbumsSharedByYouYet => 'Ingen album delt av deg enda';

  @override
  String get sharedWithYou => 'Delt med deg';

  @override
  String get sharedByYou => 'Delt av deg';

  @override
  String get inviteYourFriendsToEnte => 'Inviter vennene dine til Ente';

  @override
  String get failedToDownloadVideo => 'Kan ikke laste ned video';

  @override
  String get hiding => 'Skjuler...';

  @override
  String get unhiding => 'Synliggjør...';

  @override
  String get successfullyHid => 'Vellykket skjult';

  @override
  String get successfullyUnhid => 'Vellykket synliggjøring';

  @override
  String get crashReporting => 'Krasjrapportering';

  @override
  String get resumableUploads => 'Fortsette opplastinger';

  @override
  String get addToHiddenAlbum => 'Legg til i skjult album';

  @override
  String get moveToHiddenAlbum => 'Flytt til skjult album';

  @override
  String get fileTypes => 'Filtyper';

  @override
  String get deleteConfirmDialogBody =>
      'Denne kontoen er knyttet til andre Ente-apper, hvis du bruker noen. De opplastede dataene, i alle Ente-apper, vil bli planlagt slettet, og kontoen din vil bli slettet permanent.';

  @override
  String get hearUsWhereTitle => 'Hvordan fikk du høre om Ente? (valgfritt)';

  @override
  String get hearUsExplanation =>
      'Vi sporer ikke app-installasjoner. Det hadde vært til hjelp om du fortalte oss hvor du fant oss!';

  @override
  String get viewAddOnButton => 'Vis tillegg';

  @override
  String get addOns => 'Tillegg';

  @override
  String get addOnPageSubtitle => 'Detaljer om tillegg';

  @override
  String get yourMap => 'Ditt kart';

  @override
  String get modifyYourQueryOrTrySearchingFor =>
      'Juster søket ditt, eller prøv å søke etter';

  @override
  String get blackFridaySale => 'Black Friday salg';

  @override
  String get upto50OffUntil4thDec =>
      'Opptil 50 % rabatt, frem til 4. desember.';

  @override
  String get photos => 'Bilder';

  @override
  String get videos => 'Videoer';

  @override
  String get livePhotos => 'Live-bilder';

  @override
  String get searchHint1 => 'Raskt søk på enheten';

  @override
  String get searchHint2 => 'Bildedatoer, beskrivelser';

  @override
  String get searchHint3 => 'Albumer, filnavn og typer';

  @override
  String get searchHint4 => 'Plassering';

  @override
  String get searchHint5 => 'Kommer snart: ansikt & magisk søk ✨';

  @override
  String get addYourPhotosNow => 'Legg til bildene dine nå';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count resultater funnet',
      one: '$count resultat funnet',
    );
    return '$_temp0';
  }

  @override
  String get faces => 'Ansikt';

  @override
  String get people => 'Folk';

  @override
  String get contents => 'Innhold';

  @override
  String get addNew => 'Legg til ny';

  @override
  String get contacts => 'Kontakter';

  @override
  String get noInternetConnection => 'Ingen nettverksforbindelse';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'Kontroller Internett-tilkoblingen din og prøv igjen.';

  @override
  String get signOutFromOtherDevices => 'Logg ut fra andre enheter';

  @override
  String get signOutOtherBody =>
      'Hvis du tror noen kjenner til ditt passord, kan du tvinge alle andre enheter som bruker kontoen din til å logge ut.';

  @override
  String get signOutOtherDevices => 'Logg ut andre enheter';

  @override
  String get doNotSignOut => 'Ikke logg ut';

  @override
  String get editLocation => 'Rediger plassering';

  @override
  String get selectALocation => 'Velg en plassering';

  @override
  String get selectALocationFirst => 'Velg en plassering først';

  @override
  String get changeLocationOfSelectedItems =>
      'Endre plassering av valgte elementer?';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte =>
      'Endringer i plassering vil kun være synlige i Ente';

  @override
  String get cleanUncategorized => 'Tøm ukategorisert';

  @override
  String get cleanUncategorizedDescription =>
      'Fjern alle filer fra Ukategoriserte som finnes i andre album';

  @override
  String get waitingForVerification => 'Venter på verifikasjon...';

  @override
  String get passkey => 'Tilgangsnøkkel';

  @override
  String get passkeyAuthTitle => 'Verifisering av tilgangsnøkkel';

  @override
  String get loginWithTOTP => 'Pålogging med TOTP';

  @override
  String get passKeyPendingVerification => 'Bekreftelse venter fortsatt';

  @override
  String get loginSessionExpired => 'Økten har utløpt';

  @override
  String get loginSessionExpiredDetails =>
      'Økten er utløpt. Vennligst logg inn på nytt.';

  @override
  String get verifyPasskey => 'Bekreft tilgangsnøkkel';

  @override
  String get playOnTv => 'Spill av album på TV';

  @override
  String get pair => 'Par';

  @override
  String get deviceNotFound => 'Enhet ikke funnet';

  @override
  String get castInstruction =>
      'Besøk cast.ente.io på enheten du vil parre.\n\nSkriv inn koden under for å spille albumet på TV-en din.';

  @override
  String get deviceCodeHint => 'Skriv inn koden';

  @override
  String get joinDiscord => 'Bli med i Discord';

  @override
  String get locations => 'Plasseringer';

  @override
  String get addAName => 'Legg til et navn';

  @override
  String get findThemQuickly => 'Finn dem raskt';

  @override
  String get findPeopleByName => 'Finn folk raskt med navn';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Legg til seere',
      one: 'Legg til seer',
      zero: 'Legg til seer',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Legg til samarbeidspartnere',
      one: 'Legg til samarbeidspartner',
      zero: 'Legg til samarbeidspartner',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      'Trykk og hold på en e-post for å bekrefte ende-til-ende-kryptering.';

  @override
  String get developerSettingsWarning =>
      'Er du sikker på at du vil endre utviklerinnstillingene?';

  @override
  String get developerSettings => 'Utviklerinnstillinger';

  @override
  String get serverEndpoint => 'Serverendepunkt';

  @override
  String get invalidEndpoint => 'Ugyldig endepunkt';

  @override
  String get invalidEndpointMessage =>
      'Beklager, endepunktet du skrev inn er ugyldig. Skriv inn et gyldig endepunkt og prøv igjen.';

  @override
  String get endpointUpdatedMessage => 'Endepunktet ble oppdatert';

  @override
  String customEndpoint({required Object endpoint}) {
    return 'Koblet til $endpoint';
  }

  @override
  String get createCollaborativeLink => 'Samarbeidslenke';

  @override
  String get search => 'Søk';

  @override
  String get enterPersonName => 'Angi personnavn';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'Denne e-postadressen er allerede koblet til $name.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return 'Vis $name for å fjerne koblingen';
  }

  @override
  String get enterName => 'Angi navn';

  @override
  String get savePerson => 'Lagre person';

  @override
  String get editPerson => 'Rediger person';

  @override
  String get mergedPhotos => 'Sammenslåtte bilder';

  @override
  String get orMergeWithExistingPerson => 'Eller slå sammen med eksisterende';

  @override
  String get enterDateOfBirth => 'Bursdag (valgfritt)';

  @override
  String get birthday => 'Bursdag';

  @override
  String get removePersonLabel => 'Fjern etikett for person';

  @override
  String get autoPairDesc =>
      'Automatisk par fungerer kun med enheter som støtter Chromecast.';

  @override
  String get manualPairDesc =>
      'Koble til PIN fungerer med alle skjermer du vil se albumet på.';

  @override
  String get connectToDevice => 'Koble til enheten';

  @override
  String get autoCastDialogBody => 'Du vil se tilgjengelige Cast enheter her.';

  @override
  String get autoCastiOSPermission =>
      'Kontroller at lokale nettverkstillatelser er slått på for Ente Photos-appen, i innstillinger.';

  @override
  String get noDeviceFound => 'Ingen enheter funnet';

  @override
  String get stopCastingTitle => 'Stopp strømmingen';

  @override
  String get stopCastingBody => 'Vil du avbryte strømmingen?';

  @override
  String get castIPMismatchTitle => 'Kunne ikke strømme album';

  @override
  String get castIPMismatchBody =>
      'Kontroller at du er på samme nettverk som TV-en.';

  @override
  String get pairingComplete => 'Sammenkobling fullført';

  @override
  String get savingEdits => 'Lagrer redigeringer...';

  @override
  String get autoPair => 'Automatisk parring';

  @override
  String get pairWithPin => 'Parr sammen med PIN';

  @override
  String get faceRecognition => 'Ansiktsgjenkjenning';

  @override
  String get foundFaces => 'Fant ansikter';

  @override
  String get clusteringProgress => 'Fremdrift for klynging';

  @override
  String get trim => 'Beskjær';

  @override
  String get crop => 'Beskjær';

  @override
  String get rotate => 'Roter';

  @override
  String get left => 'Venstre';

  @override
  String get right => 'Høyre';

  @override
  String get whatsNew => 'Det som er nytt';

  @override
  String get reviewSuggestions => 'Gjennomgå forslag';

  @override
  String get review => 'Gjennomgå';

  @override
  String get useAsCover => 'Bruk som forsidebilde';

  @override
  String notPersonLabel({required String name}) {
    return 'Ikke $name?';
  }

  @override
  String get enable => 'Aktiver';

  @override
  String get enabled => 'Aktivert';

  @override
  String get moreDetails => 'Flere detaljer';

  @override
  String get enableMLIndexingDesc =>
      'Ente støtter maskinlæring på enheten for ansiktsgjenkjenning, magisk søk og andre avanserte søkefunksjoner';

  @override
  String get magicSearchHint =>
      'Magisk søk lar deg finne bilder basert på innholdet i dem, for eksempel ‘blomst’, ‘rød bil’, ‘ID-dokumenter\'';

  @override
  String get panorama => 'Panora';

  @override
  String get reenterPassword => 'Skriv inn passord på nytt';

  @override
  String get reenterPin => 'Skriv inn PIN-kode på nytt';

  @override
  String get deviceLock => 'Enhetslås';

  @override
  String get pinLock => 'PIN-kode lås';

  @override
  String get next => 'Neste';

  @override
  String get setNewPassword => 'Angi nytt passord';

  @override
  String get enterPin => 'Skriv inn PIN-koden';

  @override
  String get setNewPin => 'Angi ny PIN-kode';

  @override
  String get appLock => 'Applås';

  @override
  String get noSystemLockFound => 'Ingen systemlås funnet';

  @override
  String get tapToUnlock => 'Trykk for å låse opp';

  @override
  String get tooManyIncorrectAttempts => 'For mange gale forsøk';

  @override
  String get videoInfo => 'Videoinformasjon';

  @override
  String get autoLock => 'Lås automatisk';

  @override
  String get immediately => 'Umiddelbart';

  @override
  String get autoLockFeatureDescription =>
      'Tid før appen låses etter at den er lagt i bakgrunnen';

  @override
  String get hideContent => 'Skjul innhold';

  @override
  String get hideContentDescriptionAndroid =>
      'Skjuler appinnhold i appveksleren og deaktiverer skjermbilder';

  @override
  String get hideContentDescriptionIos => 'Skjuler appinnhold i appveksleren';

  @override
  String get passwordStrengthInfo =>
      'Passordstyrken beregnes basert på passordets lengde, brukte tegn, og om passordet finnes blant de 10 000 mest brukte passordene';

  @override
  String get noQuickLinksSelected => 'Ingen hurtiglenker er valgt';

  @override
  String get pleaseSelectQuickLinksToRemove => 'Velg hurtiglenker å fjerne';

  @override
  String get removePublicLinks => 'Fjern offentlige lenker';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      'Dette fjerner de offentlige lenkene av alle valgte hurtiglenker.';

  @override
  String get guestView => 'Gjestevisning';

  @override
  String get guestViewEnablePreSteps =>
      'For å aktivere gjestevisning, vennligst konfigurer enhetens passord eller skjermlås i systeminnstillingene.';

  @override
  String get nameTheAlbum => 'Navngi albumet';

  @override
  String get collectPhotosDescription =>
      'Opprett en link hvor vennene dine kan laste opp bilder i original kvalitet.';

  @override
  String get collect => 'Samle';

  @override
  String get appLockDescriptions =>
      'Velg mellom enhetens standard låseskjerm og en egendefinert låseskjerm med en PIN-kode eller passord.';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'For å aktivere applås, vennligst angi passord eller skjermlås i systeminnstillingene.';

  @override
  String get authToViewPasskey =>
      'Vennligst autentiser deg for å se gjennopprettingsnøkkelen din';

  @override
  String get loopVideoOn => 'Disable looping';

  @override
  String get loopVideoOff => 'Enable looping';

  @override
  String get localSyncErrorMessage =>
      'Ser ut som noe gikk galt siden lokal synkronisering av bilder tar lengre tid enn forventet. Vennligst kontakt vårt supportteam';

  @override
  String get showPerson => 'Vis person';

  @override
  String get sort => 'Sorter';

  @override
  String get mostRecent => 'Nyeste';

  @override
  String get mostRelevant => 'Mest relevant';

  @override
  String get loadingYourPhotos => 'Laster bildene dine...';

  @override
  String processingImport({required Object folderName}) {
    return 'Behandler $folderName...';
  }

  @override
  String get personName => 'Personnavn';

  @override
  String get addNewPerson => 'Legg til ny person';

  @override
  String get addNameOrMerge => 'Legg til navn eller sammenslåing';

  @override
  String get mergeWithExisting => 'Slå sammen med eksisterende';

  @override
  String get newPerson => 'Ny person';

  @override
  String get addName => 'Legg til navn';

  @override
  String get add => 'Legg til';

  @override
  String extraPhotosFoundFor({required String text}) {
    return 'Ekstra bilder funnet for $text';
  }

  @override
  String get extraPhotosFound => 'Ekstra bilder funnet';

  @override
  String get configuration => 'Konfigurasjon';

  @override
  String get localIndexing => 'Lokal indeksering';

  @override
  String get processed => 'Behandlet';

  @override
  String get resetPerson => 'Fjern';

  @override
  String get areYouSureYouWantToResetThisPerson =>
      'Er du sikker på at du vil tilbakestille denne personen?';

  @override
  String get allPersonGroupingWillReset =>
      'Alle grupperinger for denne personen vil bli tilbakestilt, og du vil miste alle forslag for denne personen';

  @override
  String get yesResetPerson => 'Ja, tilbakestill person';

  @override
  String get onlyThem => 'Bare de';

  @override
  String get checkingModels => 'Sjekker modeller...';

  @override
  String get enableMachineLearningBanner =>
      'Aktiver maskinlæring for magisk søk og ansiktsgjenkjenning';

  @override
  String get searchDiscoverEmptySection =>
      'Bilder vil vises her når behandlingen og synkronisering er fullført';

  @override
  String get searchPersonsEmptySection =>
      'Folk vil vises her når behandling og synkronisering er fullført';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'La til $count tilskuer',
      one: 'La til 1 tilskuer',
      zero: 'La til 0 tilskuere',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Lagt til $count samarbeidspartnere',
      one: 'La til 1 samarbeidspartner',
      zero: 'La til 0 samarbeidspartner',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured => 'Kontoen er allerede konfigurert.';

  @override
  String get sessionIdMismatch => 'Økt-ID stemmer ikke';

  @override
  String get failedToFetchActiveSessions => 'Kunne ikke hente aktive økter';

  @override
  String get failedToRefreshStripeSubscription =>
      'Kunne ikke oppdatere abonnement';

  @override
  String get failedToPlayVideo => 'Kunne ikke spille av video';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return 'Opplastingen ble ignorert på grunn av $ignoreReason';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'Galleritype $galleryType støttes ikke for nytt navn';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'Trykk for å laste opp, opplasting er ignorert nå på grunn av $ignoreReason';
  }

  @override
  String get tapToUpload => 'Trykk for å laste opp';

  @override
  String get info => 'Info';

  @override
  String get addFiles => 'Legg til filer';

  @override
  String get castAlbum => 'Cast album';

  @override
  String get imageNotAnalyzed => 'Bilde ikke analysert';

  @override
  String get noFacesFound => 'Ingen ansikter funnet';

  @override
  String get fileNotUploadedYet => 'Filen er ikke lastet opp enda';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return 'Ingen forslag for $personName';
  }

  @override
  String get month => 'måned';

  @override
  String get yearShort => 'år';

  @override
  String get currentlyRunning => 'Kjører for øyeblikket';

  @override
  String get ignored => 'ignorert';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count bilder',
      one: '1 bilde',
      zero: '0 bilder',
    );
    return '$_temp0';
  }

  @override
  String get file => 'Fil';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'Uoverensstemmelse i seksjonslengde: $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'Velg e-post-app';

  @override
  String get selectAllShort => 'Alle';

  @override
  String get selectCoverPhoto => 'Velg forsidebilde';

  @override
  String get newLocation => 'Ny plassering';

  @override
  String get faceNotClusteredYet =>
      'Ansikt ikke gruppert ennå, vennligst kom tilbake senere';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'Lenken du prøver å få tilgang til, er utløpt.';

  @override
  String get openFile => 'Åpne fil';

  @override
  String get backupFile => 'Sikkerhetskopieringsfil\n';

  @override
  String get openAlbumInBrowser => 'Åpne album i nettleser';

  @override
  String get openAlbumInBrowserTitle =>
      'Vennligst bruk webapplikasjonen for å legge til bilder til dette albumet';

  @override
  String get allow => 'Tillat';

  @override
  String get allowAppToOpenSharedAlbumLinks =>
      'Tillat app å åpne delte albumlenker';

  @override
  String get seePublicAlbumLinksInApp => 'Se offentlige albumlenker i appen';

  @override
  String get emergencyContacts => 'Nødkontakter';

  @override
  String get acceptTrustInvite => 'Godta invitasjonen';

  @override
  String get declineTrustInvite => 'Avslå invitasjon';

  @override
  String get removeYourselfAsTrustedContact =>
      'Fjern deg selv som betrodd kontakt';

  @override
  String get legacy => 'Arv';

  @override
  String get legacyPageDesc =>
      'Arv-funksjonen lar betrodde kontakter få tilgang til kontoen din i ditt fravær.';

  @override
  String get legacyPageDesc2 =>
      'Betrodde kontakter kan starte gjenoppretting av kontoen, og hvis de ikke blir blokkert innen 30 dager, tilbakestille passordet ditt og få tilgang til kontoen din.';

  @override
  String get legacyAccounts => 'Eldre kontoer';

  @override
  String get trustedContacts => 'Betrodde kontakter';

  @override
  String get addTrustedContact => 'Legg til betrodd kontakt';

  @override
  String get removeInvite => 'Fjern invitasjon';

  @override
  String get recoveryWarning =>
      'En betrodd kontakt prøver å få tilgang til kontoen din';

  @override
  String get rejectRecovery => 'Avslå gjenoppretting';

  @override
  String get recoveryInitiated => 'Gjenoppretting startet';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return 'Du kan få tilgang til kontoen etter $days dager. En varsling vil bli sendt til $email.';
  }

  @override
  String get cancelAccountRecovery => 'Avbryt gjenoppretting';

  @override
  String get recoveryAccount => 'Gjenopprett konto';

  @override
  String get cancelAccountRecoveryBody =>
      'Er du sikker på at du vil avbryte gjenoppretting?';

  @override
  String get startAccountRecoveryTitle => 'Start gjenoppretting';

  @override
  String get whyAddTrustContact =>
      'Betrodd kontakt kan hjelpe til med å gjenopprette dine data.';

  @override
  String recoveryReady({required String email}) {
    return 'Du kan nå gjenopprette $email sin konto ved å sette et nytt passord.';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email prøver å gjenopprette kontoen din.';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return 'Du er invitert til å være en betrodd kontakt av $email.';
  }

  @override
  String get warning => 'Advarsel';

  @override
  String get proceed => 'Fortsett';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return 'Du er i ferd med å legge til $email som en betrodd kontakt. De vil kunne gjenopprette kontoen din hvis du er fraværende i $numOfDays dager.';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email har invitert deg til å være en betrodd kontakt';
  }

  @override
  String get authToManageLegacy =>
      'Vennlist autentiser deg for å administrere de betrodde kontaktene dine';

  @override
  String get hideSharedItemsFromHomeGallery =>
      'Skjul delte elementer fra hjemgalleriet';

  @override
  String get swipeToSelect => 'Swipe to select';

  @override
  String get gallery => 'Galleri';

  @override
  String get joinAlbum => 'Bli med i albumet';

  @override
  String get joinAlbumSubtext => 'for å se og legge til bildene dine';

  @override
  String get joinAlbumSubtextViewer => 'for å legge dette til til delte album';

  @override
  String get join => 'Bli med';

  @override
  String get linkEmail => 'Koble til e-post';

  @override
  String get link => 'Lenke';

  @override
  String get noEnteAccountExclamation => 'Ingen Ente-konto!';

  @override
  String get orPickFromYourContacts => 'Eller velg fra kontaktene dine';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return '$email har ikke en Ente-konto.';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (Me)';
  }

  @override
  String get reassignMe => 'Tildel \"Meg\"';

  @override
  String get me => 'Meg';

  @override
  String get linkEmailToContactBannerCaption => 'for raskere deling';

  @override
  String get selectPersonToLink => 'Velg person å knytte til';

  @override
  String linkPersonToEmail({required String email}) {
    return 'Knytt personen til $email';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return 'Dette knytter $personName til $email';
  }

  @override
  String get selectYourFace => 'Velg ansiktet ditt';

  @override
  String get reassigningLoading => 'Tildeler...';

  @override
  String reassignedToName({required String name}) {
    return 'Tildeler deg til $name$name$name$name$name';
  }

  @override
  String get saveChangesBeforeLeavingQuestion => 'Lagre endringer før du drar?';

  @override
  String get dontSave => 'Ikke lagre';

  @override
  String get thisIsMeExclamation => 'Dette er meg!';

  @override
  String get linkPerson => 'Knytt til person';

  @override
  String get linkPersonCaption => 'for bedre delingsopplevelse';

  @override
  String get videoStreaming => 'Strømbare videoer';

  @override
  String get processingVideos => 'Behandler videoer';

  @override
  String get streamDetails => 'Strømmedetaljer';

  @override
  String get processing => 'Behandler';

  @override
  String get queued => 'I køen';

  @override
  String get ineligible => 'Ikke aktuell';

  @override
  String get failed => 'Mislykket';

  @override
  String get playStream => 'Spill av strøm';

  @override
  String get playOriginal => 'Spill av original';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'Å bli med i et album vil gjøre e-postadressen din synlig for dens deltakere.';

  @override
  String get pleaseWaitThisWillTakeAWhile =>
      'Vennligst vent, dette vil ta litt tid.';

  @override
  String get editTime => 'Endre tidspunkt';

  @override
  String get selectTime => 'Velg tidspunkt';

  @override
  String get selectDate => 'Velg dato';

  @override
  String get previous => 'Forrige';

  @override
  String get selectOneDateAndTimeForAll =>
      'Velg én dato og klokkeslett for alle';

  @override
  String get selectStartOfRange => 'Velg starten på rekkevidde';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      'Dette vil gjøre dato og klokkeslett for alle valgte bilder det samme.';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'Dette er den første i gruppen. Andre valgte bilder vil automatisk forflyttet basert på denne nye datoen';

  @override
  String get newRange => 'Ny rekkevidde';

  @override
  String get selectOneDateAndTime => 'Velg en dato og klokkeslett';

  @override
  String get moveSelectedPhotosToOneDate => 'Flytt valgte bilder til en dato';

  @override
  String get shiftDatesAndTime => 'Forskyv datoer og klokkeslett';

  @override
  String get photosKeepRelativeTimeDifference =>
      'Bilder holder relativ tidsforskjell';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count bilder',
      one: '1 bilde',
      zero: 'Ingen bilder',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'App-ikon';

  @override
  String get notThisPerson => 'Ikke denne personen?';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      'Valgte elementer fjernes fra denne personen, men blir ikke slettet fra biblioteket ditt.';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat gjennom årene';
  }

  @override
  String get thisWeekThroughTheYears => 'Denne uka gjennom årene';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Denne uka, $count år siden',
      one: 'Denne uka, $count år siden',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'Du og $name';
  }

  @override
  String admiringThem({required Object name}) {
    return 'Beundrer $name';
  }

  @override
  String embracingThem({required Object name}) {
    return 'Omfavner $name';
  }

  @override
  String partyWithThem({required Object name}) {
    return 'Fest med $name';
  }

  @override
  String hikingWithThem({required Object name}) {
    return 'Tur med $name';
  }

  @override
  String feastingWithThem({required Object name}) {
    return 'Festing med $name';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return 'Selfier med $name';
  }

  @override
  String posingWithThem({required Object name}) {
    return 'Poseringer med $name';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return 'Vakker utsikt med $name';
  }

  @override
  String sportsWithThem({required Object name}) {
    return 'Sport med $name';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return 'Biltur med $name';
  }

  @override
  String get spotlightOnYourself => 'Fremhev deg selv';

  @override
  String spotlightOnThem({required Object name}) {
    return 'Fremhev $name';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$name er $age!';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name fyller $age snart';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return 'Siste gang med $name';
  }

  @override
  String tripToLocation({required Object location}) {
    return 'Reise til $location';
  }

  @override
  String tripInYear({required Object year}) {
    return 'Reise i $year';
  }

  @override
  String get lastYearsTrip => 'Fjorårets tur';

  @override
  String get sunrise => 'På horisonten';

  @override
  String get mountains => 'Over åsene';

  @override
  String get greenery => 'Det grønne livet';

  @override
  String get beach => 'Sand og sjø';

  @override
  String get city => 'I byen';

  @override
  String get moon => 'I månelyset';

  @override
  String get onTheRoad => 'På veien igjen';

  @override
  String get food => 'Kulinær glede';

  @override
  String get pets => 'Pelsvenner';

  @override
  String get curatedMemories => 'Kuraterte minner';

  @override
  String get widgets => 'Moduler';

  @override
  String get memories => 'Minner';

  @override
  String get peopleWidgetDesc =>
      'Velg folkene du ønsker å se på din hjemskjerm.';

  @override
  String get albumsWidgetDesc =>
      'Velg albumene du ønsker å se på din hjemskjerm.';

  @override
  String get memoriesWidgetDesc =>
      'Velg typen minner du ønsker å se på din hjemskjerm.';

  @override
  String get smartMemories => 'Smarte minner';

  @override
  String get pastYearsMemories => 'Tidligere års minner';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return 'Also delete the photos (and videos) present in these $count albums from <bold>all</bold> other albums they are part of?';
  }

  @override
  String get addParticipants => 'Add participants';

  @override
  String selectedAlbums({required Object count}) {
    return '$count selected';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'Action not supported on Favourites album';

  @override
  String get onThisDayMemories => 'On this day memories';

  @override
  String get onThisDay => 'On this day';

  @override
  String get lookBackOnYourMemories => 'Look back on your memories 🌄';

  @override
  String get newPhotosEmoji => ' new 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'Sorry, we had to pause your backups';

  @override
  String get clickToInstallOurBestVersionYet =>
      'Click to install our best version yet';

  @override
  String get onThisDayNotificationExplanation =>
      'Receive reminders about memories from this day in previous years.';

  @override
  String get addMemoriesWidgetPrompt =>
      'Add a memories widget to your homescreen and come back here to customize.';

  @override
  String get addAlbumWidgetPrompt =>
      'Add an album widget to your homescreen and come back here to customize.';

  @override
  String get addPeopleWidgetPrompt =>
      'Add a people widget to your homescreen and come back here to customize.';

  @override
  String get birthdayNotifications => 'Birthday notifications';

  @override
  String get receiveRemindersOnBirthdays =>
      'Receive reminders when it\'s someone\'s birthday. Tapping on the notification will take you to photos of the birthday person.';

  @override
  String get happyBirthday => 'Happy birthday! 🥳';

  @override
  String get birthdays => 'Birthdays';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return 'Wish $name a happy birthday! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      'Are you sure you want to remove this face from this person?';

  @override
  String get otherDetectedFaces => 'Other detected faces';

  @override
  String get areThey => 'Are they ';

  @override
  String get questionmark => '?';

  @override
  String get saveAsAnotherPerson => 'Save as another person';

  @override
  String get showLessFaces => 'Show less faces';

  @override
  String get showMoreFaces => 'Show more faces';

  @override
  String get ignore => 'Ignore';

  @override
  String get merge => 'Merge';

  @override
  String get reset => 'Reset';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      'Are you sure you want to ignore this person?';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      'Are you sure you want to ignore these persons?';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'The person groups will not be displayed in the people section anymore. Photos will remain untouched.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'The person will not be displayed in the people section anymore. Photos will remain untouched.';

  @override
  String get areYouSureYouWantToMergeThem =>
      'Are you sure you want to merge them?';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'All unnamed groups will be merged into the selected person. This can still be undone from the suggestions history overview of the person.';

  @override
  String get yesIgnore => 'Yes, ignore';

  @override
  String get same => 'Same';

  @override
  String get different => 'Different';

  @override
  String get sameperson => 'Same person?';

  @override
  String get indexingPausedStatusDescription =>
      'Indexing is paused. It will automatically resume when the device is ready. The device is considered ready when its battery level, battery health, and thermal status are within a healthy range.';

  @override
  String get thisWeek => 'This week';

  @override
  String get lastWeek => 'Last week';

  @override
  String get thisMonth => 'This month';

  @override
  String get thisYear => 'This year';

  @override
  String get groupBy => 'Group by';

  @override
  String get faceThumbnailGenerationFailed =>
      'Unable to generate face thumbnails';

  @override
  String get fileAnalysisFailed => 'Unable to analyze file';

  @override
  String get editAutoAddPeople => 'Edit auto-add people';

  @override
  String get autoAddPeople => 'Auto-add people';

  @override
  String get autoAddToAlbum => 'Auto-add to album';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      'Should the files related to the person that were previously selected in smart albums be removed?';

  @override
  String get addingPhotos => 'Adding photos';

  @override
  String get gettingReady => 'Getting ready';

  @override
  String get addSomePhotosDesc1 => 'Add some photos or pick ';

  @override
  String get addSomePhotosDesc2 => 'familiar faces';

  @override
  String get addSomePhotosDesc3 => '\nto begin with';

  @override
  String get ignorePerson => 'Ignore person';

  @override
  String get mixedGrouping => 'Mixed grouping?';

  @override
  String get analysis => 'Analysis';

  @override
  String get doesGroupContainMultiplePeople =>
      'Does this grouping contain multiple people?';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'We will automatically analyze the grouping to determine if there are multiple people present, and separate them out again. This may take a few seconds.';

  @override
  String get layout => 'Layout';

  @override
  String get day => 'Day';

  @override
  String get undo => 'Undo';

  @override
  String get redo => 'Redo';

  @override
  String get filter => 'Filter';

  @override
  String get adjust => 'Adjust';

  @override
  String get draw => 'Draw';

  @override
  String get sticker => 'Sticker';

  @override
  String get brushColor => 'Brush Color';

  @override
  String get font => 'Font';

  @override
  String get background => 'Background';

  @override
  String get align => 'Align';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added successfully to $count albums',
      one: 'Added successfully to 1 album',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => 'Videos processed';

  @override
  String get totalVideos => 'Total videos';

  @override
  String get skippedVideos => 'Skipped videos';

  @override
  String get videoStreamingDescriptionLine1 =>
      'Play videos instantly on any device.';

  @override
  String get videoStreamingDescriptionLine2 =>
      'Enable to process video streams on this device.';

  @override
  String get videoStreamingNote =>
      'Only videos from last 60 days and under 1 minute are processed on this device. For older/longer videos, enable streaming in the desktop app.';

  @override
  String get createStream => 'Create stream';

  @override
  String get recreateStream => 'Recreate stream';

  @override
  String get addedToStreamCreationQueue => 'Added to stream creation queue';

  @override
  String get addedToStreamRecreationQueue => 'Added to stream recreation queue';

  @override
  String get videoPreviewAlreadyExists => 'Video preview already exists';

  @override
  String get videoAlreadyInQueue => 'Video file already present in the queue';

  @override
  String get videoExportFailed => 'Video creation failed. Please try again.';

  @override
  String videoExportSuccess({required String path}) {
    return 'Video successfully created at $path';
  }

  @override
  String get addedToQueue => 'Added to queue';

  @override
  String get creatingStream => 'Creating stream';

  @override
  String get similarImages => 'Similar images';

  @override
  String get findSimilarImages => 'Find similar images';

  @override
  String get noSimilarImagesFound => 'No similar images found';

  @override
  String get yourPhotosLookUnique => 'Your photos look unique';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count groups found',
      one: '$count group found',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages => 'Review and remove similar images';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return 'Delete $count photos ($size)';
  }

  @override
  String get selectionOptions => 'Selection options';

  @override
  String selectExactWithCount({required int count}) {
    return 'Exactly similar ($count)';
  }

  @override
  String get selectExact => 'Select exact';

  @override
  String selectSimilarWithCount({required int count}) {
    return 'Mostly similar ($count)';
  }

  @override
  String get selectSimilar => 'Select similar';

  @override
  String selectAllWithCount({required int count}) {
    return 'All similarities ($count)';
  }

  @override
  String get selectSimilarImagesTitle => 'Select similar images';

  @override
  String get chooseSimilarImagesToSelect =>
      'Select images based on their visual similarity';

  @override
  String get clearSelection => 'Clear selection';

  @override
  String similarImagesCount({required int count}) {
    return '$count similar images';
  }

  @override
  String deleteWithCount({required int count}) {
    return 'Delete ($count)';
  }

  @override
  String get deleteFiles => 'Delete files';

  @override
  String get areYouSureDeleteFiles =>
      'Are you sure you want to delete these files?';

  @override
  String get greatJob => 'Great job!';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return 'You freed up $size of space';
  }

  @override
  String get size => 'Size';

  @override
  String get similarity => 'Similarity';

  @override
  String get analyzingPhotosLocally => 'Analyzing your photos locally...';

  @override
  String get lookingForVisualSimilarities =>
      'Looking for visual similarities...';

  @override
  String get comparingImageDetails => 'Comparing image details...';

  @override
  String get findingSimilarImages => 'Finding similar images...';

  @override
  String get almostDone => 'Almost done...';

  @override
  String get processingLocally => 'Processing locally';

  @override
  String get useMLToFindSimilarImages =>
      'Review and remove images that look similar to each other.';

  @override
  String get all => 'All';

  @override
  String get similar => 'Similar';

  @override
  String get identical => 'Identical';

  @override
  String get nothingHereTryAnotherFilter =>
      'Nothing here, try another filter! 👀';

  @override
  String get related => 'Related';

  @override
  String get hoorayyyy => 'Hoorayyyy!';

  @override
  String get nothingToTidyUpHere => 'Nothing to tidy up here';

  @override
  String get deletingDash => 'Deleting - ';

  @override
  String get cLTitle1 => 'Jump to date';

  @override
  String get cLDesc1 =>
      'See surrounding photos for any photo by selecting the jump to date option in the file\'s info pane.';

  @override
  String get cLTitle2 => 'Faster video editor';

  @override
  String get cLDesc2 =>
      'Video editor was revamped to both drastically improve its speed when editing larger videos, and also improve the UX.';

  @override
  String get cLTitle3 => 'New memories';

  @override
  String get cLDesc3 =>
      '\"Playful kids\", \"Winter adventures\", \"Neon nights\", and more.';

  @override
  String get cLTitle4 => 'Landscape gallery and more';

  @override
  String get cLDesc4 =>
      'Support for landscape layout in the app\'s main gallery. Show persons without any associated photos instead of filtering them out. Improve video aspect detection when shared from external apps.';

  @override
  String get closeBy => 'Close';

  @override
  String get peopleAutoAddDesc =>
      'Automatically add photos of the selected people to this album';

  @override
  String get festivities => 'Festive cheer';

  @override
  String get snowAdventures => 'Winter adventures';

  @override
  String get waterfalls => 'Chasing waterfalls';

  @override
  String get wildlife => 'Into the wild';

  @override
  String get flowers => 'Blooming beauties';

  @override
  String get nightLights => 'Neon nights';

  @override
  String get architecture => 'Design icons';

  @override
  String get autumnColors => 'Autumn splendor';

  @override
  String get desertDreams => 'Desert dreams';

  @override
  String get stargazing => 'Under the stars';

  @override
  String get lakeside => 'Lakeside calm';

  @override
  String get rainyDays => 'Rainy day feels';

  @override
  String get sportsAction => 'Game on';

  @override
  String get streetArt => 'Street art stories';

  @override
  String get familyMoments => 'Family time';

  @override
  String get fireworks => 'Firework finale';

  @override
  String get historicSites => 'Echoes of history';

  @override
  String get tropicalParadise => 'Tropical escapes';

  @override
  String get forestTrails => 'Forest strolls';

  @override
  String get citySunsets => 'City sunset glow';

  @override
  String get colorfulMarkets => 'Vibrant markets';

  @override
  String get cozyCafes => 'Cozy cafe corners';

  @override
  String get vintageVibes => 'Vintage vibes';

  @override
  String get aerialViews => 'Aerial perspectives';

  @override
  String get artisticPortraits => 'Artful portraits';

  @override
  String get streetFood => 'Street food bites';

  @override
  String get riverCruises => 'River cruise views';

  @override
  String get facesTimelineBannerTitle => 'Memory Lane';

  @override
  String facesTimelineBannerSubtitle({required String name}) {
    return 'See $name\'s photos across the years';
  }

  @override
  String get facesTimelineAppBarTitle => 'Memory lane';

  @override
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count years old',
      one: '$count year old',
    );
    return '$name was $_temp0';
  }

  @override
  String facesTimelineCaptionYearsAgo({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '# years ago',
      one: '# year ago',
    );
    return '$_temp0';
  }

  @override
  String get facesTimelineShareComingSoon => 'Video sharing coming soon';

  @override
  String get facesTimelinePlaybackPrevious => 'Previous';

  @override
  String get facesTimelinePlaybackNext => 'Next';

  @override
  String get facesTimelinePlaybackPlay => 'Play';

  @override
  String get facesTimelinePlaybackPause => 'Pause';

  @override
  String get facesTimelineUnavailable => 'Faces timeline is preparing...';

  @override
  String get playfulKids => 'Playful kids';

  @override
  String get coastalCliffs => 'Cliffs by the sea';

  @override
  String get ritualsTitle => 'Rituals';

  @override
  String get ritualAddTooltip => 'Add ritual';

  @override
  String get ritualActivityHeading => 'Activity';

  @override
  String get ritualDefaultHeatmapTitle => 'Take a photo every day';

  @override
  String get ritualUntitled => 'Untitled ritual';

  @override
  String get ritualShareUnavailable =>
      'Unable to share right now. Please try again.';

  @override
  String get ritualNotificationMessage => 'Take a photo now';

  @override
  String get ritualCameraNotFound => 'No camera found on this device.';

  @override
  String get ritualCameraStartError =>
      'Unable to start camera. Please check permissions.';

  @override
  String get ritualCaptureError => 'Unable to capture photo. Please try again.';

  @override
  String ritualPhotoLimit({required int maxPhotos}) {
    String _temp0 = intl.Intl.pluralLogic(
      maxPhotos,
      locale: localeName,
      other: '# photos.',
      one: '# photo.',
    );
    return 'You can add up to $_temp0';
  }

  @override
  String get ritualCaptureAtLeastOne => 'Capture at least one photo first.';

  @override
  String get ritualAlbumMissing =>
      'Ritual album missing. Edit the ritual to set an album.';

  @override
  String get ritualAddedToAlbum => 'Added to album';

  @override
  String ritualAddedToAlbumWithName({required String albumName}) {
    return 'Added to $albumName';
  }

  @override
  String ritualAddToAlbumFailure({required String error}) {
    return 'Couldn\'t add photos to the album: $error';
  }

  @override
  String get ritualBackToList => 'Back to rituals';

  @override
  String get ritualNoPhotosYet => 'No photos yet';

  @override
  String get ritualSetAlbumToLaunchCamera =>
      'Set an album for this ritual to launch the camera.';

  @override
  String get ritualDefaultCameraTitle => 'Take a photo';

  @override
  String get ritualBadgeMessage7 =>
      '7 days down! Consistency looks good on you. Keep going!';

  @override
  String get ritualBadgeMessage14 =>
      '14 days in! Your ritual is becoming a habit. Incredible!';

  @override
  String get ritualBadgeMessage30 =>
      '30 days in a row! Legendary consistency. Take a bow!';

  @override
  String get ritualBadgeMessageDefault => 'You\'re on a roll!';

  @override
  String get ritualBadgeNewTitle => 'New achievement';

  @override
  String get ritualBadgePreparing => 'Preparing...';

  @override
  String get ritualStreaksLabel => 'Streaks';

  @override
  String get ritualCreateYourOwn => 'Create your own ritual';

  @override
  String get ritualGetDailyReminders => 'Get daily reminders';

  @override
  String get ritualAlbumNotSet => 'Album not set';

  @override
  String get ritualOpenCameraTooltip => 'Open ritual camera';

  @override
  String get ritualEditorLabel => 'Ritual editor';

  @override
  String get ritualNew => 'New ritual';

  @override
  String get ritualEdit => 'Edit ritual';

  @override
  String get ritualEnterPrompt => 'Enter your ritual';

  @override
  String get ritualEnterDescription => 'Please enter a description';

  @override
  String get ritualDayLabel => 'Day';

  @override
  String get ritualNotificationsOffHint =>
      'Notifications are off. Tap a day to turn them on.';

  @override
  String get ritualTimeLabel => 'Time';

  @override
  String get ritualAlbumLabel => 'Album';

  @override
  String get ritualSave => 'Save ritual';

  @override
  String get ritualUpdate => 'Update ritual';

  @override
  String get ritualSelectAlbumTitle => 'Select album';

  @override
  String get ritualSearchOrCreate => 'Search or create new';

  @override
  String get ritualNoAlbumsYet => 'No albums yet';

  @override
  String get ritualNoMatchingAlbums => 'No matching albums';

  @override
  String ritualCreateAlbumWithName({required String albumName}) {
    return 'Create \"$albumName\"';
  }

  @override
  String get ritualCreateNew => 'Create new';

  @override
  String get ritualAlbumSelectionPlaceholder => 'Select album';

  @override
  String get ritualPickEmojiTitle => 'Pick an emoji';

  @override
  String get ritualCustomKeyboardLabel => 'Custom (keyboard)';

  @override
  String get ritualEmojiKeyboardHint => 'Press to open emoji keyboard';

  @override
  String get ritualEmojiUseAction => 'Use';

  @override
  String get ritualSearchEmpty =>
      'Build a ritual to keep your photo habit going.';
}
