// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Dutch Flemish (`nl`).
class AppLocalizationsNl extends AppLocalizations {
  AppLocalizationsNl([String locale = 'nl']) : super(locale);

  @override
  String get enterYourEmailAddress => 'Voer je e-mailadres in';

  @override
  String get enterYourNewEmailAddress => 'Voer uw nieuwe e-mailadres in';

  @override
  String get accountWelcomeBack => 'Welkom terug!';

  @override
  String get emailAlreadyRegistered => 'E-mail is al geregistreerd.';

  @override
  String get emailNotRegistered => 'E-mail niet geregistreerd.';

  @override
  String get email => 'E-mail';

  @override
  String get cancel => 'Annuleer';

  @override
  String get verify => 'Verifiëren';

  @override
  String get invalidEmailAddress => 'Ongeldig e-mailadres';

  @override
  String get enterValidEmail => 'Voer een geldig e-mailadres in.';

  @override
  String get deleteAccount => 'Account verwijderen';

  @override
  String get deleteAccountWarning =>
      'This will delete your Ente Auth, Ente Photos and Ente Locker account.';

  @override
  String get askDeleteReason =>
      'Wat is de voornaamste reden dat je jouw account verwijdert?';

  @override
  String get deleteAccountFeedbackPrompt =>
      'We vinden het jammer je te zien gaan. Deel je feedback om ons te helpen verbeteren.';

  @override
  String get feedback => 'Feedback';

  @override
  String get kindlyHelpUsWithThisInformation =>
      'Help ons alsjeblieft met deze informatie';

  @override
  String get confirmDeletePrompt =>
      'Ja, ik wil mijn account en de bijbehorende gegevens verspreid over alle apps permanent verwijderen.';

  @override
  String get confirmAccountDeletion => 'Account verwijderen bevestigen';

  @override
  String get deleteAccountPermanentlyButton => 'Account permanent verwijderen';

  @override
  String get yourAccountHasBeenDeleted => 'Je account is verwijderd';

  @override
  String get selectReason => 'Selecteer reden';

  @override
  String get deleteReason1 => 'Ik mis een belangrijke functie';

  @override
  String get deleteReason2 =>
      'De app of een bepaalde functie functioneert niet zoals ik verwacht';

  @override
  String get deleteReason3 =>
      'Ik heb een andere dienst gevonden die me beter bevalt';

  @override
  String get deleteReason4 => 'Mijn reden wordt niet vermeld';

  @override
  String get sendEmail => 'E-mail versturen';

  @override
  String get deleteRequestSLAText => 'Je verzoek wordt binnen 72 uur verwerkt.';

  @override
  String get deleteEmailRequest =>
      'Stuur een e-mail naar <warning>account-deletion@ente.io</warning> vanaf het door jou geregistreerde e-mailadres.';

  @override
  String get entePhotosPerm =>
      'Ente <i>heeft toestemming nodig om</i> je foto\'s te bewaren';

  @override
  String get ok => 'Oké';

  @override
  String get createAccount => 'Maak account';

  @override
  String get createNewAccount => 'Maak nieuw account';

  @override
  String get password => 'Wachtwoord';

  @override
  String get confirmPassword => 'Wachtwoord bevestigen';

  @override
  String get activeSessions => 'Actieve sessies';

  @override
  String get ocrProcessingOverlayMessage => 'Tekst aan het detecteren...';

  @override
  String get ocrLoadingIndicatorLabel => 'Tekst aan het detecteren';

  @override
  String get ocrSelectionHint =>
      'Veeg of dubbeltik om precies te selecteren wat je nodig hebt';

  @override
  String get ocrNoTextDetected => 'Geen tekst gevonden';

  @override
  String get ocrRetryButtonLabel => 'Probeer opnieuw';

  @override
  String get ocrModelsNetworkRequiredError =>
      'Netwerkverbinding vereist om OCR-modellen voor het eerst te gebruiken';

  @override
  String get ocrModelsPrepareFailed => 'Kan OCR-modellen niet voorbereiden';

  @override
  String get ocrImageNotFoundError => 'Afbeeldingsbestand niet gevonden';

  @override
  String get ocrImageDecodeFailedError => 'Kan afbeeldingsbestand niet lezen';

  @override
  String get ocrGenericDetectError => 'Kan geen tekst in de afbeelding vinden';

  @override
  String get oops => 'Oeps';

  @override
  String get somethingWentWrongPleaseTryAgain =>
      'Er is iets fout gegaan, probeer het opnieuw';

  @override
  String get thisWillLogYouOutOfThisDevice =>
      'Dit zal je uitloggen van dit apparaat!';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice =>
      'Dit zal je uitloggen van het volgende apparaat:';

  @override
  String get terminateSession => 'Sessie beëindigen?';

  @override
  String get terminate => 'Beëindigen';

  @override
  String get thisDevice => 'Dit apparaat';

  @override
  String get recoverButton => 'Herstellen';

  @override
  String get recoverySuccessful => 'Herstel succesvol!';

  @override
  String get decrypting => 'Ontsleutelen...';

  @override
  String get incorrectRecoveryKeyTitle => 'Onjuiste herstelsleutel';

  @override
  String get incorrectRecoveryKeyBody =>
      'De ingevoerde herstelsleutel is onjuist';

  @override
  String get forgotPassword => 'Wachtwoord vergeten';

  @override
  String get enterYourRecoveryKey => 'Voer je herstelcode in';

  @override
  String get noRecoveryKey => 'Geen herstelcode?';

  @override
  String get sorry => 'Sorry';

  @override
  String get noRecoveryKeyNoDecryption =>
      'Door de aard van ons end-to-end encryptieprotocol kunnen je gegevens niet worden ontsleuteld zonder je wachtwoord of herstelsleutel';

  @override
  String get verifyEmail => 'Bevestig e-mail';

  @override
  String get toResetVerifyEmail =>
      'Verifieer eerst je e-mailadres om je wachtwoord opnieuw in te stellen.';

  @override
  String get checkInboxAndSpamFolder =>
      'Controleer je inbox (en spam) om verificatie te voltooien';

  @override
  String get tapToEnterCode => 'Tik om code in te voeren';

  @override
  String get resendEmail => 'E-mail opnieuw versturen';

  @override
  String weHaveSendEmailTo({required String email}) {
    return 'We hebben een e-mail gestuurd naar <green>$email</green>';
  }

  @override
  String get setPasswordTitle => 'Wachtwoord instellen';

  @override
  String get changePasswordTitle => 'Wachtwoord wijzigen';

  @override
  String get resetPasswordTitle => 'Wachtwoord resetten';

  @override
  String get encryptionKeys => 'Encryptiesleutels';

  @override
  String get passwordWarning =>
      'Wij slaan dit wachtwoord niet op, dus als je het vergeet, kunnen <underline>we je gegevens niet ontsleutelen</underline>';

  @override
  String get enterPasswordToEncrypt =>
      'Voer een wachtwoord in dat we kunnen gebruiken om je gegevens te versleutelen';

  @override
  String get enterNewPasswordToEncrypt =>
      'Voer een nieuw wachtwoord in dat we kunnen gebruiken om je gegevens te versleutelen';

  @override
  String get weakStrength => 'Zwak';

  @override
  String get strongStrength => 'Sterk';

  @override
  String get moderateStrength => 'Matig';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'Wachtwoord sterkte: $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully => 'Wachtwoord succesvol aangepast';

  @override
  String get generatingEncryptionKeys => 'Encryptiesleutels genereren...';

  @override
  String get pleaseWait => 'Een ogenblik geduld...';

  @override
  String get continueLabel => 'Doorgaan';

  @override
  String get insecureDevice => 'Onveilig apparaat';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'Sorry, we konden geen beveiligde sleutels genereren op dit apparaat.\n\nGelieve je aan te melden vanaf een ander apparaat.';

  @override
  String get howItWorks => 'Hoe het werkt';

  @override
  String get encryption => 'Encryptie';

  @override
  String get ackPasswordLostWarning =>
      'Ik begrijp dat als ik mijn wachtwoord verlies, ik mijn gegevens kan verliezen omdat mijn gegevens <underline>end-to-end versleuteld</underline> zijn.';

  @override
  String get privacyPolicyTitle => 'Privacybeleid';

  @override
  String get termsOfServicesTitle => 'Voorwaarden';

  @override
  String get signUpTerms =>
      'Ik ga akkoord met de <u-terms>gebruiksvoorwaarden</u-terms> en <u-policy>privacybeleid</u-policy>';

  @override
  String get logInLabel => 'Inloggen';

  @override
  String get loginTerms =>
      'Door op inloggen te klikken, ga ik akkoord met de <u-terms>gebruiksvoorwaarden</u-terms> en <u-policy>privacybeleid</u-policy>';

  @override
  String get changeEmail => 'E-mail wijzigen';

  @override
  String get enterYourPassword => 'Voer je wachtwoord in';

  @override
  String get welcomeBack => 'Welkom terug!';

  @override
  String get contactSupport => 'Contacteer klantenservice';

  @override
  String get locationPickerTip =>
      'You can also add a location centered on a photo from the photo\'s info screen';

  @override
  String get incorrectPasswordTitle => 'Onjuist wachtwoord';

  @override
  String get pleaseTryAgain => 'Probeer het nog eens';

  @override
  String get recreatePasswordTitle => 'Wachtwoord opnieuw instellen';

  @override
  String get useRecoveryKey => 'Herstelcode gebruiken';

  @override
  String get recreatePasswordBody =>
      'Het huidige apparaat is niet krachtig genoeg om je wachtwoord te verifiëren, dus moeten we de code een keer opnieuw genereren op een manier die met alle apparaten werkt.\n\nLog in met behulp van uw herstelcode en genereer opnieuw uw wachtwoord (je kunt dezelfde indien gewenst opnieuw gebruiken).';

  @override
  String get verifyPassword => 'Bevestig wachtwoord';

  @override
  String get recoveryKey => 'Herstelsleutel';

  @override
  String get recoveryKeyOnForgotPassword =>
      'Als je je wachtwoord vergeet, kun je alleen met deze sleutel je gegevens herstellen.';

  @override
  String get recoveryKeySaveDescription =>
      'We slaan deze sleutel niet op, bewaar deze 24 woorden sleutel op een veilige plaats.';

  @override
  String get doThisLater => 'Doe dit later';

  @override
  String get saveKey => 'Bewaar sleutel';

  @override
  String get recoveryKeyCopiedToClipboard =>
      'Herstelsleutel gekopieerd naar klembord';

  @override
  String get recoverAccount => 'Account herstellen';

  @override
  String get recover => 'Herstellen';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'Stuur een e-mail naar $supportEmail vanaf het door jou geregistreerde e-mailadres';
  }

  @override
  String get twofactorSetup => 'Tweestapsverificatie';

  @override
  String get enterCode => 'Voer code in';

  @override
  String get scanCode => 'Scan code';

  @override
  String get codeCopiedToClipboard => 'Code gekopieerd naar klembord';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      'Kopieer en plak deze code\nnaar je authenticator app';

  @override
  String get tapToCopy => 'tik om te kopiëren';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      'Scan deze barcode met\nje authenticator app';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      'Voer de 6-cijferige code van je verificatie-app in';

  @override
  String get confirm => 'Bevestig';

  @override
  String get setupComplete => 'Setup voltooid';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready =>
      'Sla je herstelsleutel op als je dat nog niet gedaan hebt';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      'Dit kan worden gebruikt om je account te herstellen als je je tweede factor verliest';

  @override
  String get twofactorAuthenticationPageTitle => 'Tweestapsverificatie';

  @override
  String get lostDevice => 'Apparaat verloren?';

  @override
  String get verifyingRecoveryKey => 'Herstelsleutel verifiëren...';

  @override
  String get recoveryKeyVerified => 'Herstel sleutel geverifieerd';

  @override
  String get recoveryKeySuccessBody =>
      'Super! Je herstelsleutel is geldig. Bedankt voor het verifiëren.\n\nVergeet niet om je herstelsleutel veilig te bewaren.';

  @override
  String get invalidRecoveryKey =>
      'De herstelsleutel die je hebt ingevoerd is niet geldig. Zorg ervoor dat deze 24 woorden bevat en controleer de spelling van elk van deze woorden.\n\nAls je een oudere herstelcode hebt ingevoerd, zorg ervoor dat deze 64 tekens lang is, en controleer ze allemaal.';

  @override
  String get invalidKey => 'Ongeldige sleutel';

  @override
  String get tryAgain => 'Probeer opnieuw';

  @override
  String get viewRecoveryKey => 'Toon herstelsleutel';

  @override
  String get confirmRecoveryKey => 'Bevestig herstelsleutel';

  @override
  String get recoveryKeyVerifyReason =>
      'Je herstelsleutel is de enige manier om je foto\'s te herstellen als je je wachtwoord bent vergeten. Je vindt je herstelsleutel in Instellingen > Account.\n\nVoer hier je herstelsleutel in om te controleren of je hem correct hebt opgeslagen.';

  @override
  String get confirmYourRecoveryKey => 'Bevestig herstelsleutel';

  @override
  String get addViewer => 'Voeg kijker toe';

  @override
  String get addCollaborator => 'Samenwerker toevoegen';

  @override
  String get addANewEmail => 'Nieuw e-mailadres toevoegen';

  @override
  String get orPickAnExistingOne => 'Of kies een bestaande';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'Samenwerkers kunnen foto\'s en video\'s toevoegen aan het gedeelde album.';

  @override
  String get enterEmail => 'Voer e-mailadres in';

  @override
  String get albumOwner => 'Eigenaar';

  @override
  String get you => 'Jij';

  @override
  String get collaborator => 'Samenwerker';

  @override
  String get addMore => 'Meer toevoegen';

  @override
  String get viewer => 'Kijker';

  @override
  String get remove => 'Verwijder';

  @override
  String get removeParticipant => 'Deelnemer verwijderen';

  @override
  String get manage => 'Beheren';

  @override
  String get addedAs => 'Toegevoegd als';

  @override
  String get changePermissions => 'Rechten aanpassen?';

  @override
  String get yesConvertToViewer => 'Ja, converteren naar viewer';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return '$user zal geen foto\'s meer kunnen toevoegen aan dit album\n\nDe gebruiker zal nog steeds bestaande foto\'s kunnen verwijderen die door hen zijn toegevoegd';
  }

  @override
  String get allowAddingPhotos => 'Foto\'s toevoegen toestaan';

  @override
  String get allowJoiningAlbum => 'Samenvoegen van album toestaan';

  @override
  String get allowAddPhotosDescription =>
      'Sta toe dat mensen met de link ook foto\'s kunnen toevoegen aan het gedeelde album.';

  @override
  String get passwordLock => 'Wachtwoord slot';

  @override
  String get canNotOpenTitle => 'Kan dit album niet openen';

  @override
  String get canNotOpenBody =>
      'Sorry, dit album kan niet worden geopend in de app.';

  @override
  String get disableDownloadWarningTitle => 'Let op';

  @override
  String get disableDownloadWarningBody =>
      'Kijkers kunnen nog steeds screenshots maken of een kopie van je foto\'s opslaan met behulp van externe tools';

  @override
  String get allowDownloads => 'Downloads toestaan';

  @override
  String get linkDeviceLimit => 'Apparaat limiet';

  @override
  String get noDeviceLimit => 'Geen';

  @override
  String get albumLayout => 'Albumweergave';

  @override
  String get layoutGrouped => 'Gegroepeerd';

  @override
  String get layoutContinuous => 'Doorlopend';

  @override
  String get layoutTrip => 'Reis';

  @override
  String get preview => 'Voorbeeld';

  @override
  String get linkExpiry => 'Vervaldatum';

  @override
  String get linkExpired => 'Verlopen';

  @override
  String get linkEnabled => 'Ingeschakeld';

  @override
  String get linkNeverExpires => 'Nooit';

  @override
  String get expiredLinkInfo =>
      'Deze link is verlopen. Selecteer een nieuwe vervaltijd of schakel de vervaldatum uit.';

  @override
  String get setAPassword => 'Stel een wachtwoord in';

  @override
  String get lockButtonLabel => 'Vergrendel';

  @override
  String get enterPassword => 'Voer wachtwoord in';

  @override
  String get removeLink => 'Verwijder link';

  @override
  String get manageLink => 'Beheer link';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'Link vervalt op $expiryTime';
  }

  @override
  String get albumUpdated => 'Album bijgewerkt';

  @override
  String get never => 'Nooit';

  @override
  String get custom => 'Aangepast';

  @override
  String get after1Hour => 'Na 1 uur';

  @override
  String get after1Day => 'Na 1 dag';

  @override
  String get after1Week => 'Na 1 week';

  @override
  String get after1Month => 'Na 1 maand';

  @override
  String get after1Year => 'Na 1 jaar';

  @override
  String get manageParticipants => 'Beheren';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count deelnemers',
      one: '1 deelnemer',
      zero: 'Geen deelnemers',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'Maak een link waarmee mensen foto\'s in jouw gedeelde album kunnen toevoegen en bekijken zonder dat ze daarvoor een Ente app of account nodig hebben. Handig voor het verzamelen van foto\'s van evenementen.';

  @override
  String get collectPhotos => 'Foto\'s verzamelen';

  @override
  String get collaborativeLink => 'Gezamenlijke link';

  @override
  String get shareWithNonenteUsers => 'Delen met niet-Ente gebruikers';

  @override
  String get createPublicLink => 'Maak publieke link';

  @override
  String get sendLink => 'Stuur link';

  @override
  String get qrCode => 'QR Code';

  @override
  String get sendQrCode => 'Stuur QR code';

  @override
  String get copyLink => 'Kopieer link';

  @override
  String get copyEmbedHtml => 'Kopieer embed HTML';

  @override
  String get linkHasExpired => 'Link is vervallen';

  @override
  String get publicLinkEnabled => 'Publieke link ingeschakeld';

  @override
  String get shareALink => 'Deel een link';

  @override
  String get sharedAlbumSectionDescription =>
      'Maak gedeelde en collaboratieve albums met andere Ente gebruikers, inclusief gebruikers met gratis abonnementen.';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: 'Gedeeld met $numberOfPeople mensen',
      one: 'Gedeeld met 1 persoon',
      zero: 'Deel met specifieke mensen',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId => 'Dit is uw verificatie-ID';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'Iemand die albums met je deelt zou hetzelfde ID op hun apparaat moeten zien.';

  @override
  String get howToViewShareeVerificationID =>
      'Vraag hen om hun e-mailadres lang in te drukken op het instellingenscherm en te controleren dat de ID\'s op beide apparaten overeenkomen.';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'Dit is de verificatie-ID van $email';
  }

  @override
  String get verificationId => 'Verificatie ID';

  @override
  String verifyEmailID({required Object email}) {
    return 'Verifieer $email';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return '$email heeft geen Ente account.\n\nStuur ze een uitnodiging om foto\'s te delen.';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return 'Hier is mijn verificatie-ID: $verificationID voor ente.io.';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'Hey, kunt u bevestigen dat dit uw ente.io verificatie-ID is: $verificationID';
  }

  @override
  String get somethingWentWrong => 'Er ging iets mis';

  @override
  String get sendInvite => 'Stuur een uitnodiging';

  @override
  String get shareTextRecommendUsingEnte =>
      'Download Ente zodat we gemakkelijk foto\'s en video\'s in originele kwaliteit kunnen delen\n\nhttps://ente.io';

  @override
  String get done => 'Voltooid';

  @override
  String get applyCodeTitle => 'Code toepassen';

  @override
  String get enterCodeDescription =>
      'Voer de code van de vriend in om gratis opslag voor jullie beiden te claimen';

  @override
  String get apply => 'Toepassen';

  @override
  String get failedToApplyCode => 'Code toepassen mislukt';

  @override
  String get enterReferralCode => 'Voer verwijzingscode in';

  @override
  String get codeAppliedPageTitle => 'Code toegepast';

  @override
  String get changeYourReferralCode => 'Wijzig uw verwijzingscode';

  @override
  String get change => 'Wijzigen';

  @override
  String get unavailableReferralCode => 'Deze code is helaas niet beschikbaar.';

  @override
  String get codeChangeLimitReached =>
      'Sorry, u heeft de limiet van het aantal codewijzigingen bereikt.';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'Neem contact op met $familyAdminEmail om uw code te wijzigen.';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB';
  }

  @override
  String get claimed => 'Geclaimd';

  @override
  String get details => 'Details';

  @override
  String get claimMore => 'Claim meer!';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return 'Zij krijgen ook $storageAmountInGB GB';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB telkens als iemand zich aanmeldt voor een betaald abonnement en je code toepast';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'Ente verwijzingscode: $referralCode \n\nPas het toe bij Instellingen → Algemeen → Verwijzingen om $referralStorageInGB GB gratis te krijgen nadat je je hebt aangemeld voor een betaald abonnement\n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => 'Claim gratis opslag';

  @override
  String get inviteYourFriends => 'Vrienden uitnodigen';

  @override
  String get failedToFetchReferralDetails =>
      'Kan geen verwijzingsgegevens ophalen. Probeer het later nog eens.';

  @override
  String get referralStep1 => '1. Geef deze code aan je vrienden';

  @override
  String get referralStep2 => '2. Ze registreren voor een betaald plan';

  @override
  String referralStep3({required Object storageInGB}) {
    return 'Jullie krijgen allebei $storageInGB GB* gratis';
  }

  @override
  String get referralsAreCurrentlyPaused =>
      'Verwijzingen zijn momenteel gepauzeerd';

  @override
  String get youCanAtMaxDoubleYourStorage =>
      '* Je kunt maximaal je opslag verdubbelen';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true': 'Jouw familie heeft $storageAmountInGb GB geclaimd tot nu toe',
      'false': 'Je hebt $storageAmountInGb GB geclaimd tot nu toe',
      'other': 'Je hebt $storageAmountInGb GB geclaimd tot nu toe!',
    });
    return '$_temp0';
  }

  @override
  String get faq => 'Veelgestelde vragen';

  @override
  String get help => 'Hulp';

  @override
  String get oopsSomethingWentWrong => 'Oeps, er is iets misgegaan';

  @override
  String get peopleUsingYourCode => 'Mensen die jouw code gebruiken';

  @override
  String get eligible => 'gerechtigd';

  @override
  String get total => 'totaal';

  @override
  String get codeUsedByYou => 'Code gebruikt door jou';

  @override
  String get freeStorageClaimed => 'Gratis opslag geclaimd';

  @override
  String get freeStorageUsable => 'Gratis opslag bruikbaar';

  @override
  String get usableReferralStorageInfo =>
      'Bruikbare opslag is beperkt door je huidige abonnement. Buitensporige geclaimde opslag zal automatisch bruikbaar worden wanneer je je abonnement upgrade.';

  @override
  String get removeFromAlbumTitle => 'Uit album verwijderen?';

  @override
  String get removeFromAlbum => 'Verwijder uit album';

  @override
  String get itemsWillBeRemovedFromAlbum =>
      'Geselecteerde items zullen worden verwijderd uit dit album';

  @override
  String get removeShareItemsWarning =>
      'Sommige van de items die je verwijdert zijn door andere mensen toegevoegd, en je verliest de toegang daartoe';

  @override
  String get addingToFavorites => 'Toevoegen aan favorieten...';

  @override
  String get removingFromFavorites => 'Verwijderen uit favorieten...';

  @override
  String get sorryCouldNotAddToFavorites =>
      'Sorry, kon niet aan favorieten worden toegevoegd!';

  @override
  String get sorryCouldNotRemoveFromFavorites =>
      'Sorry, kon niet uit favorieten worden verwijderd!';

  @override
  String get subscribeToEnableSharing =>
      'Je hebt een actief betaald abonnement nodig om delen mogelijk te maken.';

  @override
  String get subscribe => 'Abonneer';

  @override
  String get canOnlyRemoveFilesOwnedByYou =>
      'Kan alleen bestanden verwijderen die jouw eigendom zijn';

  @override
  String get deleteSharedAlbum => 'Gedeeld album verwijderen?';

  @override
  String get deleteAlbum => 'Verwijder album';

  @override
  String get deleteAlbumDialog =>
      'Verwijder de foto\'s (en video\'s) van dit album ook uit <bold>alle</bold> andere albums waar deze deel van uitmaken?';

  @override
  String get deleteSharedAlbumDialogBody =>
      'Het album wordt verwijderd voor iedereen\n\nJe verliest de toegang tot gedeelde foto\'s in dit album die eigendom zijn van anderen';

  @override
  String get yesRemove => 'Ja, verwijderen';

  @override
  String get creatingLink => 'Link aanmaken...';

  @override
  String get removeWithQuestionMark => 'Verwijder?';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return '$userEmail zal worden verwijderd uit dit gedeelde album\n\nAlle door hen toegevoegde foto\'s worden ook uit het album verwijderd';
  }

  @override
  String get keepPhotos => 'Foto\'s behouden';

  @override
  String get deletePhotos => 'Foto\'s verwijderen';

  @override
  String get inviteToEnte => 'Uitnodigen voor Ente';

  @override
  String get removePublicLink => 'Verwijder publieke link';

  @override
  String disableLinkMessage({required Object albumName}) {
    return 'Dit verwijdert de openbare link voor toegang tot \"$albumName\".';
  }

  @override
  String get sharing => 'Delen...';

  @override
  String get youCannotShareWithYourself => 'Je kunt niet met jezelf delen';

  @override
  String get archive => 'Archiveer';

  @override
  String get createAlbumActionHint =>
      'Lang indrukken om foto\'s te selecteren en klik + om een album te maken';

  @override
  String get importing => 'Importeren....';

  @override
  String get failedToLoadAlbums => 'Laden van albums mislukt';

  @override
  String get hidden => 'Verborgen';

  @override
  String get authToViewYourHiddenFiles =>
      'Gelieve te verifiëren om je verborgen bestanden te bekijken';

  @override
  String get authToViewTrashedFiles =>
      'Graag verifiëren om je verwijderde bestanden te bekijken';

  @override
  String get trash => 'Prullenbak';

  @override
  String get uncategorized => 'Ongecategoriseerd';

  @override
  String get videoSmallCase => 'video';

  @override
  String get photoSmallCase => 'foto';

  @override
  String get singleFileDeleteHighlight =>
      'Het wordt uit alle albums verwijderd.';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return 'Deze $fileType staat zowel in Ente als op jouw apparaat.';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return 'Deze $fileType zal worden verwijderd uit Ente.';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return 'Deze $fileType zal worden verwijderd van jouw apparaat.';
  }

  @override
  String get deleteFromEnte => 'Verwijder van Ente';

  @override
  String get yesDelete => 'Ja, verwijderen';

  @override
  String get movedToTrash => 'Naar prullenbak verplaatst';

  @override
  String get deleteFromDevice => 'Verwijder van apparaat';

  @override
  String get deleteFromBoth => 'Verwijder van beide';

  @override
  String get newAlbum => 'Nieuw album';

  @override
  String get albums => 'Albums';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount herinneringen',
      one: '$formattedCount herinnering',
      zero: 'geen herinneringen',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return '$count geselecteerd';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return '$count geselecteerd ($yourCount van jou)';
  }

  @override
  String get advancedSettings => 'Geavanceerd';

  @override
  String get photoGridSize => 'Foto raster grootte';

  @override
  String get manageDeviceStorage => 'Apparaatcache beheren';

  @override
  String get manageDeviceStorageDesc => 'Bekijk en wis lokale cache opslag.';

  @override
  String get machineLearning => 'Machine Learning';

  @override
  String get mlConsent => 'Schakel machine learning in';

  @override
  String get mlConsentTitle => 'Machine learning inschakelen?';

  @override
  String get mlConsentDescription =>
      'Als u machine learning inschakelt, zal Ente informatie zoals gezichtsgeometrie uit bestanden extraheren, inclusief degenen die met u gedeeld worden.\n\nDit gebeurt op uw apparaat, en alle gegenereerde biometrische informatie zal end-to-end versleuteld worden.';

  @override
  String get mlConsentPrivacy =>
      'Klik hier voor meer details over deze functie in ons privacybeleid.';

  @override
  String get mlConsentConfirmation =>
      'Ik begrijp het, en wil machine learning inschakelen';

  @override
  String get magicSearch => 'Magische zoekfunctie';

  @override
  String get discover => 'Ontdek';

  @override
  String get discover_identity => 'Identiteit';

  @override
  String get discover_screenshots => 'Schermafbeeldingen';

  @override
  String get discover_receipts => 'Bonnen';

  @override
  String get discover_notes => 'Notities';

  @override
  String get discover_memes => 'Memes';

  @override
  String get discover_visiting_cards => 'Visitekaartjes';

  @override
  String get discover_babies => 'Baby\'s';

  @override
  String get discover_pets => 'Huisdieren';

  @override
  String get discover_selfies => 'Selfies';

  @override
  String get discover_wallpapers => 'Achtergronden';

  @override
  String get discover_food => 'Eten';

  @override
  String get discover_celebrations => 'Vieringen';

  @override
  String get discover_sunset => 'Zonsondergang';

  @override
  String get discover_hills => 'Heuvels';

  @override
  String get discover_greenery => 'Natuur';

  @override
  String get mlIndexingDescription =>
      'Houd er rekening mee dat machine learning zal leiden tot hoger bandbreedte- en batterijgebruik totdat alle items geïndexeerd zijn. Overweeg het gebruik van de desktop app voor snellere indexering. Alle resultaten worden automatisch gesynchroniseerd.';

  @override
  String get loadingModel => 'Modellen downloaden...';

  @override
  String get waitingForWifi => 'Wachten op WiFi...';

  @override
  String get status => 'Status';

  @override
  String get indexedItems => 'Geïndexeerde bestanden';

  @override
  String get pendingItems => 'Bestanden in behandeling';

  @override
  String get clearIndexes => 'Index wissen';

  @override
  String get selectFoldersForBackup => 'Selecteer mappen voor back-up';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      'Geselecteerde mappen worden versleuteld en geback-upt';

  @override
  String get unselectAll => 'Deselecteer alles';

  @override
  String get selectAll => 'Selecteer alles';

  @override
  String get skip => 'Overslaan';

  @override
  String get updatingFolderSelection => 'Map selectie bijwerken...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count items',
      one: '$count item',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Verwijder $count bestanden',
      one: 'Verwijder $count bestand',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count bestanden, elk $formattedSize';
  }

  @override
  String get showMemories => 'Toon herinneringen';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count jaar geleden',
      one: '$count jaar geleden',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'Back-up instellingen';

  @override
  String get backupStatus => 'Back-up status';

  @override
  String get backupStatusDescription =>
      'Items die zijn geback-upt, worden hier getoond';

  @override
  String get backupOverMobileData => 'Back-up maken via mobiele data';

  @override
  String get backupVideos => 'Back-up video\'s';

  @override
  String get disableAutoLock => 'Automatisch vergrendelen uitschakelen';

  @override
  String get deviceLockExplanation =>
      'Schakel de schermvergrendeling van het apparaat uit wanneer Ente op de voorgrond is en er een back-up aan de gang is. Dit is normaal gesproken niet nodig, maar kan grote uploads en initiële imports van grote mappen sneller laten verlopen.';

  @override
  String get about => 'Over';

  @override
  String get weAreOpenSource => 'We zijn open source!';

  @override
  String get privacy => 'Privacy';

  @override
  String get terms => 'Voorwaarden';

  @override
  String get checkForUpdates => 'Controleer op updates';

  @override
  String get checkStatus => 'Status controleren';

  @override
  String get checking => 'Controleren...';

  @override
  String get youAreOnTheLatestVersion => 'Je hebt de laatste versie';

  @override
  String get account => 'Account';

  @override
  String get manageSubscription => 'Abonnement beheren';

  @override
  String get authToChangeYourEmail =>
      'Gelieve te verifiëren om je e-mailadres te wijzigen';

  @override
  String get changePassword => 'Wachtwoord wijzigen';

  @override
  String get authToChangeYourPassword =>
      'Gelieve te verifiëren om je wachtwoord te wijzigen';

  @override
  String get emailVerificationToggle => 'E-mailverificatie';

  @override
  String get authToChangeEmailVerificationSetting =>
      'Gelieve te verifiëren om de e-mailverificatie te wijzigen';

  @override
  String get exportYourData => 'Exporteer je gegevens';

  @override
  String get logout => 'Uitloggen';

  @override
  String get authToInitiateAccountDeletion =>
      'Gelieve te verifiëren om het verwijderen van je account te starten';

  @override
  String get areYouSureYouWantToLogout =>
      'Weet je zeker dat je wilt uitloggen?';

  @override
  String get yesLogout => 'Ja, log uit';

  @override
  String get aNewVersionOfEnteIsAvailable =>
      'Er is een nieuwe versie van Ente beschikbaar.';

  @override
  String get update => 'Update';

  @override
  String get installManually => 'Installeer handmatig';

  @override
  String get criticalUpdateAvailable => 'Belangrijke update beschikbaar';

  @override
  String get updateAvailable => 'Update beschikbaar';

  @override
  String get ignoreUpdate => 'Negeren';

  @override
  String get downloading => 'Downloaden...';

  @override
  String get cannotDeleteSharedFiles =>
      'Kan gedeelde bestanden niet verwijderen';

  @override
  String get theDownloadCouldNotBeCompleted =>
      'De download kon niet worden voltooid';

  @override
  String get retry => 'Opnieuw';

  @override
  String get backedUpFolders => 'Back-up mappen';

  @override
  String get backup => 'Back-up';

  @override
  String get freeUpDeviceSpace => 'Apparaatruimte vrijmaken';

  @override
  String get freeUpDeviceSpaceDesc =>
      'Bespaar ruimte op je apparaat door bestanden die al geback-upt zijn te wissen.';

  @override
  String get allClear => '✨ Alles in orde';

  @override
  String get noDeviceThatCanBeDeleted =>
      'Je hebt geen bestanden op dit apparaat die verwijderd kunnen worden';

  @override
  String get removeDuplicates => 'Duplicaten verwijderen';

  @override
  String get removeDuplicatesDesc =>
      'Controleer en verwijder bestanden die exacte kopieën zijn.';

  @override
  String get viewLargeFiles => 'Grote bestanden';

  @override
  String get viewLargeFilesDesc =>
      'Bekijk bestanden die de meeste opslagruimte verbruiken.';

  @override
  String get noDuplicates => '✨ Geen duplicaten';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared =>
      'Je hebt geen dubbele bestanden die kunnen worden gewist';

  @override
  String get success => 'Succes';

  @override
  String get rateUs => 'Beoordeel ons';

  @override
  String get remindToEmptyDeviceTrash =>
      'Leeg ook \"Onlangs verwijderd\" uit \"Instellingen\" -> \"Opslag\" om de vrij gekomen ruimte te benutten';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return 'Je hebt $storageSaved succesvol vrijgemaakt!';
  }

  @override
  String get remindToEmptyEnteTrash =>
      'Leeg ook uw \"Prullenbak\" om de vrij gekomen ruimte te benutten';

  @override
  String get sparkleSuccess => '✨ Succes';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count dubbele bestanden',
      one: '$count dubbel bestand',
    );
    return 'Je hebt $_temp0 opgeruimd, totaal ($storageSaved!)';
  }

  @override
  String get familyPlans => 'Familie abonnement';

  @override
  String get referrals => 'Referenties';

  @override
  String get notifications => 'Meldingen';

  @override
  String get sharedPhotoNotifications => 'Nieuwe gedeelde foto\'s';

  @override
  String get sharedPhotoNotificationsExplanation =>
      'Ontvang meldingen wanneer iemand een foto toevoegt aan een gedeeld album waar je deel van uitmaakt';

  @override
  String get advanced => 'Geavanceerd';

  @override
  String get general => 'Algemeen';

  @override
  String get security => 'Beveiliging';

  @override
  String get authToViewYourRecoveryKey =>
      'Graag verifiëren om uw herstelsleutel te bekijken';

  @override
  String get twofactor => 'Tweestapsverificatie';

  @override
  String get authToConfigureTwofactorAuthentication =>
      'Graag verifiëren om tweestapsverificatie te configureren';

  @override
  String get lockscreen => 'Vergrendelscherm';

  @override
  String get authToChangeLockscreenSetting =>
      'Graag verifiëren om de vergrendelscherm instellingen te wijzigen';

  @override
  String get viewActiveSessions => 'Actieve sessies bekijken';

  @override
  String get authToViewYourActiveSessions =>
      'Graag verifiëren om uw actieve sessies te bekijken';

  @override
  String get disableTwofactor => 'Tweestapsverificatie uitschakelen';

  @override
  String get confirm2FADisable =>
      'Weet u zeker dat u tweestapsverificatie wilt uitschakelen?';

  @override
  String get no => 'Nee';

  @override
  String get yes => 'Ja';

  @override
  String get social => 'Sociale media';

  @override
  String rateUsOnStore({required Object storeName}) {
    return 'Beoordeel ons op $storeName';
  }

  @override
  String get blog => 'Blog';

  @override
  String get merchandise => 'Merchandise';

  @override
  String get twitter => 'Twitter';

  @override
  String get mastodon => 'Mastodon';

  @override
  String get matrix => 'Matrix';

  @override
  String get discord => 'Discord';

  @override
  String get reddit => 'Reddit';

  @override
  String get yourStorageDetailsCouldNotBeFetched =>
      'Uw opslaggegevens konden niet worden opgehaald';

  @override
  String get reportABug => 'Een fout melden';

  @override
  String get reportBug => 'Fout melden';

  @override
  String get suggestFeatures => 'Features voorstellen';

  @override
  String get support => 'Ondersteuning';

  @override
  String get theme => 'Thema';

  @override
  String get lightTheme => 'Licht';

  @override
  String get darkTheme => 'Donker';

  @override
  String get systemTheme => 'Systeem';

  @override
  String get freeTrial => 'Gratis proefversie';

  @override
  String get selectYourPlan => 'Kies uw abonnement';

  @override
  String get enteSubscriptionPitch =>
      'Ente bewaart uw herinneringen, zodat ze altijd beschikbaar voor u zijn, zelfs als u uw apparaat verliest.';

  @override
  String get enteSubscriptionShareWithFamily =>
      'Je familie kan ook aan je abonnement worden toegevoegd.';

  @override
  String get currentUsageIs => 'Huidig gebruik is ';

  @override
  String get faqs => 'Veelgestelde vragen';

  @override
  String renewsOn({required Object endDate}) {
    return 'Wordt verlengd op $endDate';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return 'Gratis proefversie geldig tot $endDate';
  }

  @override
  String validTill({required Object endDate}) {
    return 'Geldig tot $endDate';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return 'Jouw $storageAmount add-on is geldig tot $endDate';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return 'Gratis proefperiode geldig tot $endDate.\nU kunt naderhand een betaald abonnement kiezen.';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'Uw abonnement loopt af op $endDate';
  }

  @override
  String get subscription => 'Abonnement';

  @override
  String get paymentDetails => 'Betaalgegevens';

  @override
  String get manageFamily => 'Familie abonnement beheren';

  @override
  String contactToManageSubscription({required Object provider}) {
    return 'Neem contact met ons op via support@ente.io om uw $provider abonnement te beheren.';
  }

  @override
  String get renewSubscription => 'Abonnement verlengen';

  @override
  String get cancelSubscription => 'Abonnement opzeggen';

  @override
  String get areYouSureYouWantToRenew => 'Weet u zeker dat u wilt verlengen?';

  @override
  String get yesRenew => 'Ja, verlengen';

  @override
  String get areYouSureYouWantToCancel => 'Weet u zeker dat u wilt opzeggen?';

  @override
  String get yesCancel => 'Ja, opzeggen';

  @override
  String get failedToRenew => 'Verlengen mislukt';

  @override
  String get failedToCancel => 'Opzeggen mislukt';

  @override
  String get twoMonthsFreeOnYearlyPlans =>
      'Krijg 2 maanden gratis bij jaarlijkse abonnementen';

  @override
  String get monthly => 'Maandelijks';

  @override
  String get yearly => 'Jaarlijks';

  @override
  String get confirmPlanChange => 'Bevestig verandering van abonnement';

  @override
  String get areYouSureYouWantToChangeYourPlan =>
      'Weet u zeker dat u uw abonnement wilt wijzigen?';

  @override
  String get youCannotDowngradeToThisPlan =>
      'U kunt niet downgraden naar dit abonnement';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'Annuleer eerst uw bestaande abonnement bij $paymentProvider';
  }

  @override
  String get optionalAsShortAsYouLike => 'Optioneel, zo kort als je wilt...';

  @override
  String get send => 'Verzenden';

  @override
  String get askCancelReason =>
      'Uw abonnement is opgezegd. Wilt u de reden delen?';

  @override
  String get thankYouForSubscribing => 'Dank je wel voor het abonneren!';

  @override
  String get yourPurchaseWasSuccessful => 'Uw betaling is geslaagd';

  @override
  String get yourPlanWasSuccessfullyUpgraded =>
      'Uw abonnement is succesvol opgewaardeerd';

  @override
  String get yourPlanWasSuccessfullyDowngraded =>
      'Uw abonnement is succesvol gedegradeerd';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully =>
      'Uw abonnement is succesvol bijgewerkt';

  @override
  String get googlePlayId => 'Google Play ID';

  @override
  String get appleId => 'Apple ID';

  @override
  String get playstoreSubscription => 'PlayStore abonnement';

  @override
  String get appstoreSubscription => 'PlayStore abonnement';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return 'Jouw $id is al aan een ander Ente account gekoppeld.\nAls je jouw $id wilt gebruiken met dit account, neem dan contact op met onze klantenservice';
  }

  @override
  String get visitWebToManage =>
      'Bezoek alstublieft web.ente.io om uw abonnement te beheren';

  @override
  String get couldNotUpdateSubscription => 'Kon abonnement niet wijzigen';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      'Neem alstublieft contact op met support@ente.io en we helpen u graag!';

  @override
  String get paymentFailed => 'Betaling mislukt';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return 'Praat met $providerName klantenservice als u in rekening bent gebracht';
  }

  @override
  String get continueOnFreeTrial => 'Doorgaan met gratis proefversie';

  @override
  String get areYouSureYouWantToExit => 'Weet u zeker dat u wilt afsluiten?';

  @override
  String get thankYou => 'Bedankt';

  @override
  String get failedToVerifyPaymentStatus =>
      'Betalingsstatus verifiëren mislukt';

  @override
  String get pleaseWaitForSometimeBeforeRetrying =>
      'Gelieve even te wachten voordat u opnieuw probeert';

  @override
  String get paymentFailedMessage =>
      'Helaas is je betaling mislukt. Neem contact op met support zodat we je kunnen helpen!';

  @override
  String get youAreOnAFamilyPlan =>
      'U bent onderdeel van een familie abonnement!';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'Neem contact op met <green>$familyAdminEmail</green> om uw abonnement te beheren';
  }

  @override
  String get leaveFamily => 'Familie abonnement verlaten';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily =>
      'Weet u zeker dat u het familie abonnement wilt verlaten?';

  @override
  String get leave => 'Verlaten';

  @override
  String get rateTheApp => 'Beoordeel de app';

  @override
  String get startBackup => 'Back-up starten';

  @override
  String get noPhotosAreBeingBackedUpRightNow =>
      'Er worden momenteel geen foto\'s geback-upt';

  @override
  String get preserveMore => 'Meer bewaren';

  @override
  String get grantFullAccessPrompt =>
      'Geef toegang tot alle foto\'s in de Instellingen app';

  @override
  String get allowPermTitle => 'Toegang tot foto\'s toestaan';

  @override
  String get allowPermBody =>
      'Geef toegang tot je foto\'s vanuit Instellingen zodat Ente je bibliotheek kan weergeven en back-uppen.';

  @override
  String get openSettings => 'Instellingen openen';

  @override
  String get selectMorePhotos => 'Selecteer meer foto\'s';

  @override
  String get existingUser => 'Bestaande gebruiker';

  @override
  String get privateBackups => 'Privé back-ups';

  @override
  String get forYourMemories => 'voor uw herinneringen';

  @override
  String get endtoendEncryptedByDefault => 'Standaard end-to-end versleuteld';

  @override
  String get safelyStored => 'Veilig opgeslagen';

  @override
  String get atAFalloutShelter => 'in een kernbunker';

  @override
  String get designedToOutlive => 'Ontworpen om levenslang mee te gaan';

  @override
  String get available => 'Beschikbaar';

  @override
  String get everywhere => 'overal';

  @override
  String get androidIosWebDesktop => 'Android, iOS, Web, Desktop';

  @override
  String get mobileWebDesktop => 'Mobiel, Web, Desktop';

  @override
  String get newToEnte => 'Nieuw bij Ente';

  @override
  String get pleaseLoginAgain => 'Log opnieuw in';

  @override
  String get autoLogoutMessage =>
      'Door een technische storing bent u uitgelogd. Onze excuses voor het ongemak.';

  @override
  String get yourSubscriptionHasExpired => 'Uw abonnement is verlopen';

  @override
  String get storageLimitExceeded => 'Opslaglimiet overschreden';

  @override
  String get upgrade => 'Upgraden';

  @override
  String get raiseTicket => 'Meld probleem';

  @override
  String get backupFailed => 'Back-up mislukt';

  @override
  String get sorryBackupFailedDesc =>
      'Sorry, we kunnen dit bestand nu niet back-uppen, we zullen het later opnieuw proberen.';

  @override
  String get couldNotBackUpTryLater =>
      'We konden uw gegevens niet back-uppen.\nWe zullen het later opnieuw proberen.';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      'Ente kan bestanden alleen versleutelen en bewaren als u toegang tot ze geeft';

  @override
  String get pleaseGrantPermissions => 'Geef alstublieft toestemming';

  @override
  String get grantPermission => 'Toestemming verlenen';

  @override
  String get privateSharing => 'Privé delen';

  @override
  String get shareOnlyWithThePeopleYouWant =>
      'Deel alleen met de mensen die u wilt';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      'Gebruik publieke links voor mensen die geen Ente account hebben';

  @override
  String get allowPeopleToAddPhotos => 'Mensen toestaan foto\'s toe te voegen';

  @override
  String get shareAnAlbumNow => 'Deel nu een album';

  @override
  String get collectEventPhotos => 'Foto\'s van gebeurtenissen verzamelen';

  @override
  String get sessionExpired => 'Sessie verlopen';

  @override
  String get loggingOut => 'Uitloggen...';

  @override
  String get onDevice => 'Op het apparaat';

  @override
  String get onEnte => 'Op <branding>ente</branding>';

  @override
  String get name => 'Naam';

  @override
  String get newest => 'Nieuwste';

  @override
  String get lastUpdated => 'Laatst gewijzigd';

  @override
  String get deleteEmptyAlbums => 'Lege albums verwijderen';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => 'Lege albums verwijderen?';

  @override
  String get deleteAlbumsDialogBody =>
      'Hiermee worden alle lege albums verwijderd. Dit is handig wanneer je rommel in je albumlijst wilt verminderen.';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return 'Verwijderen van $currentlyDeleting / $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return 'Verwerken van $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => 'Permanent verwijderen';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou =>
      'Kan alleen een link maken voor bestanden die van u zijn';

  @override
  String get publicLinkCreated => 'Publieke link aangemaakt';

  @override
  String get youCanManageYourLinksInTheShareTab =>
      'U kunt uw links beheren in het tabblad \'Delen\'.';

  @override
  String get linkCopiedToClipboard => 'Link gekopieerd naar klembord';

  @override
  String get restore => 'Herstellen';

  @override
  String get moveToAlbum => 'Verplaats naar album';

  @override
  String get unhide => 'Zichtbaar maken';

  @override
  String get unarchive => 'Uit archief halen';

  @override
  String get favorite => 'Toevoegen aan favorieten';

  @override
  String get removeFromFavorite => 'Verwijder van favorieten';

  @override
  String get shareLink => 'Link delen';

  @override
  String get createCollage => 'Creëer collage';

  @override
  String get saveCollage => 'Sla collage op';

  @override
  String get collageSaved => 'Collage opgeslagen in gallerij';

  @override
  String get collageLayout => 'Layout';

  @override
  String get addToEnte => 'Toevoegen aan Ente';

  @override
  String get addToAlbum => 'Toevoegen aan album';

  @override
  String get delete => 'Verwijderen';

  @override
  String get hide => 'Verbergen';

  @override
  String get share => 'Delen';

  @override
  String get unhideToAlbum => 'Zichtbaar maken in album';

  @override
  String get restoreToAlbum => 'Terugzetten naar album';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Bestanden verplaatsen',
      one: 'Bestand verplaatsen',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Bestanden toevoegen',
      one: 'Bestand toevoegen',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'Maak of selecteer album';

  @override
  String get selectAlbum => 'Album selecteren';

  @override
  String get searchByAlbumNameHint => 'Albumnaam';

  @override
  String get albumTitle => 'Albumtitel';

  @override
  String get enterAlbumName => 'Voer albumnaam in';

  @override
  String get restoringFiles => 'Bestanden herstellen...';

  @override
  String get movingFilesToAlbum => 'Bestanden verplaatsen naar album...';

  @override
  String get unhidingFilesToAlbum => 'Bestanden zichtbaar maken in album';

  @override
  String get canNotUploadToAlbumsOwnedByOthers =>
      'Kan niet uploaden naar albums die van anderen zijn';

  @override
  String get uploadingFilesToAlbum => 'Bestanden worden geüpload naar album...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return 'Succesvol toegevoegd aan  $albumName';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return 'Succesvol verplaatst naar $albumName';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'Dit album heeft al een gezamenlijke link';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return 'Gezamenlijke link aangemaakt voor $albumName';
  }

  @override
  String get askYourLovedOnesToShare => 'Vraag uw dierbaren om te delen';

  @override
  String get invite => 'Uitnodigen';

  @override
  String get shareYourFirstAlbum => 'Deel jouw eerste album';

  @override
  String sharedWith({required Object emailIDs}) {
    return 'Gedeeld met $emailIDs';
  }

  @override
  String get sharedWithMe => 'Gedeeld met mij';

  @override
  String get sharedByMe => 'Gedeeld door mij';

  @override
  String get doubleYourStorage => 'Verdubbel uw opslagruimte';

  @override
  String get referFriendsAnd2xYourPlan =>
      'Verwijs vrienden en 2x uw abonnement';

  @override
  String get shareAlbumHint =>
      'Open een album en tik op de deelknop rechts bovenaan om te delen.';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      'Bestanden tonen het aantal resterende dagen voordat ze permanent worden verwijderd';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count dagen',
      one: '1 dag',
      zero: 'Binnenkort',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => 'Alles Verwijderen';

  @override
  String get renameAlbum => 'Albumnaam wijzigen';

  @override
  String get convertToAlbum => 'Omzetten naar album';

  @override
  String get setCover => 'Omslag instellen';

  @override
  String get sortAlbumsBy => 'Sorteren op';

  @override
  String get sortNewestFirst => 'Nieuwste eerst';

  @override
  String get sortOldestFirst => 'Oudste eerst';

  @override
  String get rename => 'Naam wijzigen';

  @override
  String get leaveSharedAlbum => 'Gedeeld album verlaten?';

  @override
  String get leaveAlbum => 'Album verlaten';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'Foto\'s toegevoegd door u zullen worden verwijderd uit het album';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted =>
      'Je hebt geen bestanden in dit album die verwijderd kunnen worden';

  @override
  String get youDontHaveAnyArchivedItems =>
      'U heeft geen gearchiveerde bestanden.';

  @override
  String get ignoredFolderUploadReason =>
      'Sommige bestanden in dit album worden genegeerd voor uploaden omdat ze eerder van Ente zijn verwijderd.';

  @override
  String get resetIgnoredFiles => 'Reset genegeerde bestanden';

  @override
  String get deviceFilesAutoUploading =>
      'Bestanden toegevoegd aan dit album van dit apparaat zullen automatisch geüpload worden naar Ente.';

  @override
  String get turnOnBackupForAutoUpload =>
      'Schakel back-up in om bestanden die toegevoegd zijn aan deze map op dit apparaat automatisch te uploaden.';

  @override
  String get noHiddenPhotosOrVideos => 'Geen verborgen foto\'s of video\'s';

  @override
  String get toHideAPhotoOrVideo => 'Om een foto of video te verbergen';

  @override
  String get openTheItem => '• Open het item';

  @override
  String get clickOnTheOverflowMenu => '• Klik op het menu';

  @override
  String get click => '• Click';

  @override
  String get nothingToSeeHere => 'Nog niets te zien hier! 👀';

  @override
  String get unarchiveAlbum => 'Album uit archief halen';

  @override
  String get archiveAlbum => 'Album archiveren';

  @override
  String get calculating => 'Berekenen...';

  @override
  String get pleaseWaitDeletingAlbum =>
      'Een ogenblik geduld, album wordt verwijderd';

  @override
  String get searchByExamples =>
      '• Albumnamen (bijv. \"Camera\")\n• Types van bestanden (bijv. \"Video\'s\", \".gif\")\n• Jaren en maanden (bijv. \"2022\", \"januari\")\n• Feestdagen (bijv. \"Kerstmis\")\n• Fotobeschrijvingen (bijv. \"#fun\")';

  @override
  String get youCanTrySearchingForADifferentQuery =>
      'U kunt proberen een andere zoekopdracht te vinden.';

  @override
  String get noResultsFound => 'Geen resultaten gevonden';

  @override
  String addedBy({required Object emailOrName}) {
    return 'Toegevoegd door $emailOrName';
  }

  @override
  String get loadingExifData => 'EXIF-gegevens laden...';

  @override
  String get viewAllExifData => 'Bekijk alle EXIF gegevens';

  @override
  String get noExifData => 'Geen EXIF gegevens';

  @override
  String get thisImageHasNoExifData => 'Deze foto heeft geen exif gegevens';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => 'Geen resultaten';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'We ondersteunen het bewerken van foto\'s en albums waar je niet de eigenaar van bent nog niet';

  @override
  String get failedToFetchOriginalForEdit =>
      'Fout bij ophalen origineel voor bewerking';

  @override
  String get close => 'Sluiten';

  @override
  String get setAs => 'Instellen als';

  @override
  String get fileSavedToGallery => 'Bestand opgeslagen in galerij';

  @override
  String get filesSavedToGallery => 'Bestand opgeslagen in galerij';

  @override
  String get fileFailedToSaveToGallery =>
      'Opslaan van bestand naar galerij mislukt';

  @override
  String get download => 'Downloaden';

  @override
  String get pressAndHoldToPlayVideo =>
      'Ingedrukt houden om video af te spelen';

  @override
  String get pressAndHoldToPlayVideoDetailed =>
      'Houd de afbeelding ingedrukt om video af te spelen';

  @override
  String get downloadFailed => 'Download mislukt';

  @override
  String get deduplicateFiles => 'Dubbele bestanden verwijderen';

  @override
  String get deselectAll => 'Alles deselecteren';

  @override
  String get reviewDeduplicateItems =>
      'Controleer en verwijder de bestanden die u denkt dat dubbel zijn.';

  @override
  String get clubByCaptureTime => 'Samenvoegen op tijd';

  @override
  String get clubByFileName => 'Samenvoegen op bestandsnaam';

  @override
  String get count => 'Aantal';

  @override
  String get totalSize => 'Totale grootte';

  @override
  String get longpressOnAnItemToViewInFullscreen =>
      'Houd een bestand lang ingedrukt om te bekijken op volledig scherm';

  @override
  String get decryptingVideo => 'Video ontsleutelen...';

  @override
  String get authToViewYourMemories =>
      'Graag verifiëren om uw herinneringen te bekijken';

  @override
  String get unlock => 'Ontgrendelen';

  @override
  String get freeUpSpace => 'Ruimte vrijmaken';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other:
          'Ze kunnen verwijderd worden van het apparaat om $formattedSize vrij te maken',
      one:
          'Het kan verwijderd worden van het apparaat om $formattedSize vrij te maken',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber bestanden',
      one: '1 bestand',
    );
    return '$_temp0 in dit album is veilig geback-upt';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber bestanden',
      one: '1 bestand',
    );
    return '$_temp0 in dit album zijn veilig geback-upt';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'ze',
      one: 'het',
    );
    return 'Je hebt nog steeds toegang tot $_temp0 op Ente zolang je een actief abonnement hebt';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return 'Maak $sizeInMBorGB vrij';
  }

  @override
  String get thisEmailIsAlreadyInUse => 'Dit e-mailadres is al in gebruik';

  @override
  String get incorrectCode => 'Onjuiste code';

  @override
  String get authenticationFailedPleaseTryAgain =>
      'Verificatie mislukt, probeer het opnieuw';

  @override
  String get verificationFailedPleaseTryAgain =>
      'Verificatie mislukt, probeer het opnieuw';

  @override
  String get authenticating => 'Verifiëren...';

  @override
  String get authenticationSuccessful => 'Verificatie geslaagd!';

  @override
  String get incorrectRecoveryKey => 'Onjuiste herstelsleutel';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect =>
      'De ingevoerde herstelsleutel is onjuist';

  @override
  String get twofactorAuthenticationSuccessfullyReset =>
      'Tweestapsverificatie succesvol gereset';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered =>
      'Controleer de code die u hebt ingevoerd';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      'Neem contact op met klantenservice als het probleem aanhoudt';

  @override
  String get twofactorAuthenticationHasBeenDisabled =>
      'Tweestapsverificatie is uitgeschakeld';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect =>
      'Sorry, de ingevoerde code is onjuist';

  @override
  String get yourVerificationCodeHasExpired => 'Uw verificatiecode is verlopen';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'E-mailadres gewijzigd naar $newEmail';
  }

  @override
  String get verifying => 'Verifiëren...';

  @override
  String get disablingTwofactorAuthentication =>
      'Tweestapsverificatie uitschakelen...';

  @override
  String get allMemoriesPreserved => 'Alle herinneringen bewaard';

  @override
  String get loadingGallery => 'Laden van gallerij...';

  @override
  String get syncing => 'Synchroniseren...';

  @override
  String get encryptingBackup => 'Back-up versleutelen...';

  @override
  String get syncStopped => 'Synchronisatie gestopt';

  @override
  String syncProgress({required String completed, required String total}) {
    return '$completed/$total herinneringen bewaard';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return '$count herinneringen veiligstellen...';
  }

  @override
  String get uploadingSingleMemory => '1 herinnering veiligstellen...';

  @override
  String get archiving => 'Archiveren...';

  @override
  String get unarchiving => 'Uit het archief halen...';

  @override
  String get successfullyArchived => 'Succesvol gearchiveerd';

  @override
  String get successfullyUnarchived => 'Succesvol uit archief gehaald';

  @override
  String get renameFile => 'Bestandsnaam wijzigen';

  @override
  String get enterFileName => 'Geef bestandsnaam op';

  @override
  String get filesDeleted => 'Bestanden verwijderd';

  @override
  String get selectedFilesAreNotOnEnte =>
      'Geselecteerde bestanden staan niet op Ente';

  @override
  String get thisActionCannotBeUndone =>
      'Deze actie kan niet ongedaan gemaakt worden';

  @override
  String get emptyTrash => 'Prullenbak leegmaken?';

  @override
  String get permDeleteWarning =>
      'Alle bestanden in de prullenbak zullen permanent worden verwijderd\n\nDeze actie kan niet ongedaan worden gemaakt';

  @override
  String get empty => 'Leeg';

  @override
  String get couldNotFreeUpSpace => 'Kon geen ruimte vrijmaken';

  @override
  String get permanentlyDeleteFromDevice =>
      'Permanent verwijderen van apparaat?';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      'Sommige bestanden die u probeert te verwijderen zijn alleen beschikbaar op uw apparaat en kunnen niet hersteld worden als deze verwijderd worden';

  @override
  String get theyWillBeDeletedFromAllAlbums =>
      'Ze zullen uit alle albums worden verwijderd.';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'Sommige bestanden bevinden zich zowel in Ente als op jouw apparaat.';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      'Geselecteerde bestanden worden verwijderd uit alle albums en verplaatst naar de prullenbak.';

  @override
  String get theseItemsWillBeDeletedFromYourDevice =>
      'Deze bestanden zullen worden verwijderd van uw apparaat.';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      'Het lijkt erop dat er iets fout is gegaan. Probeer het later opnieuw. Als de fout zich blijft voordoen, neem dan contact op met ons supportteam.';

  @override
  String get error => 'Foutmelding';

  @override
  String get tempErrorContactSupportIfPersists =>
      'Het lijkt erop dat er iets fout is gegaan. Probeer het later opnieuw. Als de fout zich blijft voordoen, neem dan contact op met ons supportteam.';

  @override
  String get networkHostLookUpErr =>
      'Kan geen verbinding maken met Ente, controleer uw netwerkinstellingen en neem contact op met ondersteuning als de fout zich blijft voordoen.';

  @override
  String get networkConnectionRefusedErr =>
      'Kan geen verbinding maken met Ente, probeer het later opnieuw. Als de fout zich blijft voordoen, neem dan contact op met support.';

  @override
  String get cachedData => 'Cachegegevens';

  @override
  String get clearCaches => 'Cache legen';

  @override
  String get remoteImages => 'Externe afbeeldingen';

  @override
  String get remoteVideos => 'Externe video\'s';

  @override
  String get remoteThumbnails => 'Externe thumbnails';

  @override
  String get pendingSync => 'Synchronisatie in behandeling';

  @override
  String get localGallery => 'Lokale galerij';

  @override
  String get todaysLogs => 'Logboeken van vandaag';

  @override
  String get viewLogs => 'Logboeken bekijken';

  @override
  String get logsDialogBody =>
      'Dit zal logboeken verzenden om ons te helpen uw probleem op te lossen. Houd er rekening mee dat bestandsnamen zullen worden meegenomen om problemen met specifieke bestanden bij te houden.';

  @override
  String get preparingLogs => 'Logboeken voorbereiden...';

  @override
  String get emailYourLogs => 'E-mail uw logboeken';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'Verstuur de logboeken alstublieft naar $toEmail';
  }

  @override
  String get copyEmailAddress => 'E-mailadres kopiëren';

  @override
  String get exportLogs => 'Logboek exporteren';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return 'Stuur ons een e-mail op $toEmail';
  }

  @override
  String get dismiss => 'Afwijzen';

  @override
  String get didYouKnow => 'Wist u dat?';

  @override
  String get loadingMessage => 'Uw foto\'s laden...';

  @override
  String get loadMessage1 => 'U kunt uw abonnement met uw familie delen';

  @override
  String get loadMessage2 =>
      'We hebben tot nu toe meer dan 200 miljoen herinneringen bewaard';

  @override
  String get loadMessage3 =>
      'We bewaren 3 kopieën van uw bestanden, één in een ondergrondse kernbunker';

  @override
  String get loadMessage4 => 'Al onze apps zijn open source';

  @override
  String get loadMessage5 =>
      'Onze broncode en cryptografie zijn extern gecontroleerd en geverifieerd';

  @override
  String get loadMessage6 =>
      'Je kunt links naar je albums delen met je dierbaren';

  @override
  String get loadMessage7 =>
      'Onze mobiele apps draaien op de achtergrond om alle nieuwe foto\'s die je maakt te versleutelen en te back-uppen';

  @override
  String get loadMessage8 => 'web.ente.io heeft een vlotte uploader';

  @override
  String get loadMessage9 =>
      'We gebruiken Xchacha20Poly1305 om uw gegevens veilig te versleutelen';

  @override
  String get photoDescriptions => 'Foto beschrijvingen';

  @override
  String get fileTypesAndNames => 'Bestandstypen en namen';

  @override
  String get location => 'Locatie';

  @override
  String get moments => 'Momenten';

  @override
  String get searchFaceEmptySection =>
      'Mensen worden hier getoond als het indexeren klaar is';

  @override
  String get searchDatesEmptySection => 'Zoeken op een datum, maand of jaar';

  @override
  String get searchLocationEmptySection =>
      'Foto\'s groeperen die in een bepaalde straal van een foto worden genomen';

  @override
  String get searchPeopleEmptySection =>
      'Nodig mensen uit, en je ziet alle foto\'s die door hen worden gedeeld hier';

  @override
  String get searchAlbumsEmptySection => 'Albums';

  @override
  String get searchFileTypesAndNamesEmptySection => 'Bestandstypen en namen';

  @override
  String get searchCaptionEmptySection =>
      'Voeg beschrijvingen zoals \"#weekendje weg\" toe in foto-info om ze snel hier te vinden';

  @override
  String get language => 'Taal';

  @override
  String get selectLanguage => 'Taal selecteren';

  @override
  String get locationName => 'Locatie naam';

  @override
  String get addLocation => 'Locatie toevoegen';

  @override
  String get groupNearbyPhotos => 'Groep foto\'s in de buurt';

  @override
  String get kiloMeterUnit => 'km';

  @override
  String get addLocationButton => 'Toevoegen';

  @override
  String get radius => 'Straal';

  @override
  String get locationTagFeatureDescription =>
      'Een locatie tag groept alle foto\'s die binnen een bepaalde straal van een foto zijn genomen';

  @override
  String get galleryMemoryLimitInfo =>
      'Tot 1000 herinneringen getoond in de galerij';

  @override
  String get save => 'Opslaan';

  @override
  String get centerPoint => 'Middelpunt';

  @override
  String get pickCenterPoint => 'Kies middelpunt';

  @override
  String get useSelectedPhoto => 'Gebruik geselecteerde foto';

  @override
  String get resetToDefault => 'Standaardinstellingen herstellen';

  @override
  String get edit => 'Bewerken';

  @override
  String get deleteLocation => 'Verwijder locatie';

  @override
  String get rotateLeft => 'Roteer links';

  @override
  String get flip => 'Omdraaien';

  @override
  String get rotateRight => 'Rechtsom draaien';

  @override
  String get saveCopy => 'Kopie opslaan';

  @override
  String get light => 'Licht';

  @override
  String get color => 'Kleur';

  @override
  String get yesDiscardChanges => 'Ja, wijzigingen negeren';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade =>
      'Wilt u de bewerkingen die u hebt gemaakt annuleren?';

  @override
  String get saving => 'Opslaan...';

  @override
  String get editsSaved => 'Bewerkingen opgeslagen';

  @override
  String get oopsCouldNotSaveEdits => 'Oeps, kon bewerkingen niet opslaan';

  @override
  String get distanceInKMUnit => 'km';

  @override
  String get dayToday => 'Vandaag';

  @override
  String get dayYesterday => 'Gisteren';

  @override
  String get storage => 'Opslagruimte';

  @override
  String get usedSpace => 'Gebruikte ruimte';

  @override
  String get storageBreakupFamily => 'Familie';

  @override
  String get storageBreakupYou => 'Jij';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return '$usedAmount $usedStorageUnit van $totalAmount $totalStorageUnit gebruikt';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return '$freeAmount $storageUnit vrij';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'Versie: $versionValue';
  }

  @override
  String get verifyIDLabel => 'Verifiëren';

  @override
  String get fileInfoAddDescHint => 'Voeg een beschrijving toe...';

  @override
  String get editLocationTagTitle => 'Locatie bewerken';

  @override
  String get setLabel => 'Instellen';

  @override
  String get setRadius => 'Radius instellen';

  @override
  String get familyPlanPortalTitle => 'Familie';

  @override
  String get familyPlanOverview =>
      'Voeg 5 gezinsleden toe aan je bestaande abonnement zonder extra te betalen.\n\nElk lid krijgt zijn eigen privé ruimte en kan elkaars bestanden niet zien tenzij ze zijn gedeeld.\n\nFamilieplannen zijn beschikbaar voor klanten die een betaald Ente abonnement hebben.\n\nAbonneer nu om aan de slag te gaan!';

  @override
  String get androidBiometricHint => 'Identiteit verifiëren';

  @override
  String get androidBiometricNotRecognized =>
      'Niet herkend. Probeer het opnieuw.';

  @override
  String get androidBiometricSuccess => 'Succes';

  @override
  String get androidCancelButton => 'Annuleren';

  @override
  String get androidSignInTitle => 'Verificatie vereist';

  @override
  String get androidBiometricRequiredTitle =>
      'Biometrische verificatie vereist';

  @override
  String get androidDeviceCredentialsRequiredTitle =>
      'Apparaatgegevens vereist';

  @override
  String get androidDeviceCredentialsSetupDescription =>
      'Apparaatgegevens vereist';

  @override
  String get goToSettings => 'Ga naar instellingen';

  @override
  String get androidGoToSettingsDescription =>
      'Biometrische verificatie is niet ingesteld op uw apparaat. Ga naar \'Instellingen > Beveiliging\' om biometrische verificatie toe te voegen.';

  @override
  String get iOSLockOut =>
      'Biometrische verificatie is uitgeschakeld. Vergrendel en ontgrendel uw scherm om het in te schakelen.';

  @override
  String get iOSGoToSettingsDescription =>
      'Biometrische authenticatie is niet ingesteld op uw apparaat. Schakel Touch ID of Face ID in op uw telefoon.';

  @override
  String get iOSOkButton => 'Oké';

  @override
  String get openstreetmapContributors => 'OpenStreetMap bijdragers';

  @override
  String get hostedAtOsmFrance => 'Gehost bij OSM France';

  @override
  String get map => 'Kaart';

  @override
  String get maps => 'Kaarten';

  @override
  String get mapsPrivacyNotice =>
      'Benaderende coördinaten worden naar privacybewuste derden zoals OpenStreetMap gestuurd om de kaart en locatie weer te geven.';

  @override
  String get enableMaps => 'Kaarten inschakelen';

  @override
  String get quickLinks => 'Snelle links';

  @override
  String get selectItemsToAdd => 'Selecteer items om toe te voegen';

  @override
  String get addSelected => 'Voeg geselecteerde toe';

  @override
  String get addFromDevice => 'Toevoegen vanaf apparaat';

  @override
  String get addPhotos => 'Foto\'s toevoegen';

  @override
  String get noPhotosFoundHere => 'Geen foto\'s gevonden hier';

  @override
  String get zoomOutToSeePhotos => 'Zoom uit om foto\'s te zien';

  @override
  String get noImagesWithLocation => 'Geen afbeeldingen met locatie';

  @override
  String get unpinAlbum => 'Album losmaken';

  @override
  String get pinAlbum => 'Album bovenaan vastzetten';

  @override
  String get pin => 'Pin';

  @override
  String get pinPerson => 'Pin person';

  @override
  String get pinToTop => 'Pin to top';

  @override
  String get unpin => 'Unpin';

  @override
  String get unpinPerson => 'Unpin person';

  @override
  String get visibility => 'Visibility';

  @override
  String get hideFromMemories => 'Hide from memories';

  @override
  String get showInMemories => 'Show in memories';

  @override
  String get create => 'Creëren';

  @override
  String get viewAll => 'Alles weergeven';

  @override
  String get nothingSharedWithYouYet => 'Nog niets met je gedeeld';

  @override
  String get noAlbumsSharedByYouYet => 'Nog geen albums gedeeld door jou';

  @override
  String get sharedWithYou => 'Gedeeld met jou';

  @override
  String get sharedByYou => 'Gedeeld door jou';

  @override
  String get inviteYourFriendsToEnte => 'Vrienden uitnodigen voor Ente';

  @override
  String get failedToDownloadVideo => 'Downloaden van video mislukt';

  @override
  String get hiding => 'Verbergen...';

  @override
  String get unhiding => 'Zichtbaar maken...';

  @override
  String get successfullyHid => 'Succesvol verborgen';

  @override
  String get successfullyUnhid => 'Met succes zichtbaar gemaakt';

  @override
  String get crashReporting => 'Crash rapportering';

  @override
  String get resumableUploads => 'Hervatbare uploads';

  @override
  String get addToHiddenAlbum => 'Toevoegen aan verborgen album';

  @override
  String get moveToHiddenAlbum => 'Verplaatsen naar verborgen album';

  @override
  String get fileTypes => 'Bestandstype';

  @override
  String get deleteConfirmDialogBody =>
      'Dit account is gekoppeld aan andere Ente apps, als je er gebruik van maakt. Je geüploade gegevens worden in alle Ente apps gepland voor verwijdering, en je account wordt permanent verwijderd voor alle Ente diensten.';

  @override
  String get hearUsWhereTitle => 'Hoe hoorde je over Ente? (optioneel)';

  @override
  String get hearUsExplanation =>
      'Wij gebruiken geen tracking. Het zou helpen als je ons vertelt waar je ons gevonden hebt!';

  @override
  String get viewAddOnButton => 'Add-ons bekijken';

  @override
  String get addOns => 'Add-ons';

  @override
  String get addOnPageSubtitle => 'Details van add-ons';

  @override
  String get yourMap => 'Jouw kaart';

  @override
  String get modifyYourQueryOrTrySearchingFor =>
      'Pas je zoekopdracht aan of zoek naar';

  @override
  String get blackFridaySale => 'Black Friday-aanbieding';

  @override
  String get upto50OffUntil4thDec => 'Tot 50% korting, tot 4 december.';

  @override
  String get photos => 'Foto\'s';

  @override
  String get videos => 'Video\'s';

  @override
  String get livePhotos => 'Live foto';

  @override
  String get searchHint1 => 'Snelle, lokale zoekfunctie';

  @override
  String get searchHint2 => 'Foto datums, beschrijvingen';

  @override
  String get searchHint3 => 'Albums, bestandsnamen en typen';

  @override
  String get searchHint4 => 'Locatie';

  @override
  String get searchHint5 =>
      'Binnenkort beschikbaar: Gezichten & magische zoekopdrachten ✨';

  @override
  String get addYourPhotosNow => 'Voeg nu je foto\'s toe';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count resultaten gevonden',
      one: '$count resultaat gevonden',
    );
    return '$_temp0';
  }

  @override
  String get faces => 'Gezichten';

  @override
  String get people => 'Personen';

  @override
  String get contents => 'Inhoud';

  @override
  String get addNew => 'Nieuwe toevoegen';

  @override
  String get contacts => 'Contacten';

  @override
  String get noInternetConnection => 'Geen internetverbinding';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'Controleer je internetverbinding en probeer het opnieuw.';

  @override
  String get signOutFromOtherDevices => 'Log uit op andere apparaten';

  @override
  String get signOutOtherBody =>
      'Als je denkt dat iemand je wachtwoord zou kunnen kennen, kun je alle andere apparaten die je account gebruiken dwingen om uit te loggen.';

  @override
  String get signOutOtherDevices => 'Log uit op andere apparaten';

  @override
  String get doNotSignOut => 'Niet uitloggen';

  @override
  String get editLocation => 'Locatie bewerken';

  @override
  String get selectALocation => 'Selecteer een locatie';

  @override
  String get selectALocationFirst => 'Selecteer eerst een locatie';

  @override
  String get changeLocationOfSelectedItems =>
      'Locatie van geselecteerde items wijzigen?';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte =>
      'Bewerkte locatie wordt alleen gezien binnen Ente';

  @override
  String get cleanUncategorized => 'Ongecategoriseerd opschonen';

  @override
  String get cleanUncategorizedDescription =>
      'Verwijder alle bestanden van Ongecategoriseerd die aanwezig zijn in andere albums';

  @override
  String get waitingForVerification => 'Wachten op verificatie...';

  @override
  String get passkey => 'Passkey';

  @override
  String get passkeyAuthTitle => 'Passkey verificatie';

  @override
  String get loginWithTOTP => 'Inloggen met TOTP';

  @override
  String get passKeyPendingVerification => 'Verificatie is nog in behandeling';

  @override
  String get loginSessionExpired => 'Sessie verlopen';

  @override
  String get loginSessionExpiredDetails =>
      'Jouw sessie is verlopen. Log opnieuw in.';

  @override
  String get verifyPasskey => 'Bevestig passkey';

  @override
  String get playOnTv => 'Album afspelen op TV';

  @override
  String get pair => 'Koppelen';

  @override
  String get deviceNotFound => 'Apparaat niet gevonden';

  @override
  String get castInstruction =>
      'Bezoek cast.ente.io op het apparaat dat u wilt koppelen.\n\nVoer de code hieronder in om het album op uw TV af te spelen.';

  @override
  String get deviceCodeHint => 'Voer de code in';

  @override
  String get joinDiscord => 'Join de Discord';

  @override
  String get locations => 'Locaties';

  @override
  String get addAName => 'Een naam toevoegen';

  @override
  String get findThemQuickly => 'Vind ze snel';

  @override
  String get findPeopleByName => 'Mensen snel op naam zoeken';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Kijkers toevoegen',
      one: 'Kijker toevoegen',
      zero: 'Kijker toevoegen',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Samenwerkers toevoegen',
      one: 'Samenwerker toevoegen',
      zero: 'Samenwerker toevoegen',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      'Druk lang op een e-mail om de versleuteling te verifiëren.';

  @override
  String get developerSettingsWarning =>
      'Weet je zeker dat je de ontwikkelaarsinstellingen wilt wijzigen?';

  @override
  String get developerSettings => 'Ontwikkelaarsinstellingen';

  @override
  String get serverEndpoint => 'Server eindpunt';

  @override
  String get invalidEndpoint => 'Ongeldig eindpunt';

  @override
  String get invalidEndpointMessage =>
      'Sorry, het eindpunt dat je hebt ingevoerd is ongeldig. Voer een geldig eindpunt in en probeer het opnieuw.';

  @override
  String get endpointUpdatedMessage => 'Eindpunt met succes bijgewerkt';

  @override
  String customEndpoint({required Object endpoint}) {
    return 'Verbonden met $endpoint';
  }

  @override
  String get createCollaborativeLink => 'Maak een gezamenlijke link';

  @override
  String get search => 'Zoeken';

  @override
  String get enterPersonName => 'Naam van persoon invoeren';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'Dit e-mailadres is al aan $name gekoppeld.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return 'Bekijk $name om te ontkoppelen';
  }

  @override
  String get enterName => 'Naam invoeren';

  @override
  String get savePerson => 'Persoon opslaan';

  @override
  String get editPerson => 'Persoon bewerken';

  @override
  String get mergedPhotos => 'Samengevoegde foto\'s';

  @override
  String get orMergeWithExistingPerson => 'Of samenvoegen met bestaande';

  @override
  String get enterDateOfBirth => 'Verjaardag (optioneel)';

  @override
  String get birthday => 'Verjaardag';

  @override
  String get removePersonLabel => 'Verwijder persoonslabel';

  @override
  String get autoPairDesc =>
      'Automatisch koppelen werkt alleen met apparaten die Chromecast ondersteunen.';

  @override
  String get manualPairDesc =>
      'Koppelen met de PIN werkt met elk scherm waarop je jouw album wilt zien.';

  @override
  String get connectToDevice => 'Verbinding maken met apparaat';

  @override
  String get autoCastDialogBody =>
      'Je zult de beschikbare Cast apparaten hier zien.';

  @override
  String get autoCastiOSPermission =>
      'Zorg ervoor dat lokale netwerkrechten zijn ingeschakeld voor de Ente Photos app, in Instellingen.';

  @override
  String get noDeviceFound => 'Geen apparaat gevonden';

  @override
  String get stopCastingTitle => 'Casten stoppen';

  @override
  String get stopCastingBody => 'Wil je stoppen met casten?';

  @override
  String get castIPMismatchTitle => 'Album casten mislukt';

  @override
  String get castIPMismatchBody =>
      'Zorg ervoor dat je op hetzelfde netwerk zit als de tv.';

  @override
  String get pairingComplete => 'Koppeling voltooid';

  @override
  String get savingEdits => 'Bewerken opslaan...';

  @override
  String get autoPair => 'Automatisch koppelen';

  @override
  String get pairWithPin => 'Koppelen met PIN';

  @override
  String get faceRecognition => 'Gezichtsherkenning';

  @override
  String get foundFaces => 'Gezichten gevonden';

  @override
  String get clusteringProgress => 'Voortgang clusteren';

  @override
  String get trim => 'Knippen';

  @override
  String get crop => 'Bijsnijden';

  @override
  String get rotate => 'Roteren';

  @override
  String get left => 'Links';

  @override
  String get right => 'Rechts';

  @override
  String get whatsNew => 'Nieuw';

  @override
  String get reviewSuggestions => 'Suggesties beoordelen';

  @override
  String get review => 'Beoordelen';

  @override
  String get useAsCover => 'Als cover gebruiken';

  @override
  String notPersonLabel({required String name}) {
    return 'Niet $name?';
  }

  @override
  String get enable => 'Inschakelen';

  @override
  String get enabled => 'Ingeschakeld';

  @override
  String get moreDetails => 'Meer details';

  @override
  String get enableMLIndexingDesc =>
      'Ente ondersteunt on-device machine learning voor gezichtsherkenning, magisch zoeken en andere geavanceerde zoekfuncties';

  @override
  String get magicSearchHint =>
      'Magisch zoeken maakt het mogelijk om foto\'s op hun inhoud worden gezocht, bijvoorbeeld \"bloem\", \"rode auto\", \"identiteitsdocumenten\"';

  @override
  String get panorama => 'Panorama';

  @override
  String get reenterPassword => 'Wachtwoord opnieuw invoeren';

  @override
  String get reenterPin => 'PIN opnieuw invoeren';

  @override
  String get deviceLock => 'Apparaat vergrendeld';

  @override
  String get pinLock => 'PIN vergrendeling';

  @override
  String get next => 'Volgende';

  @override
  String get setNewPassword => 'Nieuw wachtwoord instellen';

  @override
  String get enterPin => 'PIN invoeren';

  @override
  String get setNewPin => 'Nieuwe PIN instellen';

  @override
  String get appLock => 'App-vergrendeling';

  @override
  String get noSystemLockFound => 'Geen systeemvergrendeling gevonden';

  @override
  String get tapToUnlock => 'Tik om te ontgrendelen';

  @override
  String get tooManyIncorrectAttempts => 'Te veel onjuiste pogingen';

  @override
  String get videoInfo => 'Video-info';

  @override
  String get autoLock => 'Automatische vergrendeling';

  @override
  String get immediately => 'Onmiddellijk';

  @override
  String get autoLockFeatureDescription =>
      'Tijd waarna de app wordt vergrendeld wanneer deze in achtergrond-modus is gezet';

  @override
  String get hideContent => 'Inhoud verbergen';

  @override
  String get hideContentDescriptionAndroid =>
      'Verbergt app-inhoud in de app-schakelaar en schakelt schermopnamen uit';

  @override
  String get hideContentDescriptionIos =>
      'Verbergt de inhoud van de app in de app-schakelaar';

  @override
  String get passwordStrengthInfo =>
      'De wachtwoordsterkte wordt berekend aan de hand van de lengte van het wachtwoord, de gebruikte tekens en of het wachtwoord al dan niet in de top 10.000 van meest gebruikte wachtwoorden staat';

  @override
  String get noQuickLinksSelected => 'Geen snelle links geselecteerd';

  @override
  String get pleaseSelectQuickLinksToRemove =>
      'Selecteer snelle links om te verwijderen';

  @override
  String get removePublicLinks => 'Verwijder publieke link';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      'Hiermee worden openbare links van alle geselecteerde snelle links verwijderd.';

  @override
  String get guestView => 'Gasten weergave';

  @override
  String get guestViewEnablePreSteps =>
      'Om gasten weergave in te schakelen, moet u een toegangscode of schermvergrendeling instellen in uw systeeminstellingen.';

  @override
  String get nameTheAlbum => 'Album benoemen';

  @override
  String get collectPhotosDescription =>
      'Maak een link waarin je vrienden foto\'s kunnen uploaden in de originele kwaliteit.';

  @override
  String get collect => 'Verzamelen';

  @override
  String get appLockDescriptions =>
      'Kies tussen het standaard vergrendelscherm van uw apparaat en een aangepast vergrendelscherm met een pincode of wachtwoord.';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'Om appvergrendeling in te schakelen, moet u een toegangscode of schermvergrendeling instellen in uw systeeminstellingen.';

  @override
  String get authToViewPasskey =>
      'Verifieer uzelf om uw toegangssleutel te bekijken';

  @override
  String get loopVideoOn => 'Disable looping';

  @override
  String get loopVideoOff => 'Enable looping';

  @override
  String get localSyncErrorMessage =>
      'Het lijkt erop dat er iets mis is gegaan omdat het synchroniseren van lokale foto\'s meer tijd kost dan verwacht. Neem contact op met ons supportteam';

  @override
  String get showPerson => 'Toon persoon';

  @override
  String get sort => 'Sorteren';

  @override
  String get mostRecent => 'Meest recent';

  @override
  String get mostRelevant => 'Meest relevant';

  @override
  String get loadingYourPhotos => 'Je foto\'s worden geladen...';

  @override
  String processingImport({required Object folderName}) {
    return 'Verwerken van $folderName...';
  }

  @override
  String get personName => 'Naam van persoon';

  @override
  String get addNewPerson => 'Nieuw persoon toevoegen';

  @override
  String get addNameOrMerge => 'Naam toevoegen of samenvoegen';

  @override
  String get mergeWithExisting => 'Samenvoegen met bestaand';

  @override
  String get newPerson => 'Nieuw persoon';

  @override
  String get addName => 'Naam toevoegen';

  @override
  String get add => 'Toevoegen';

  @override
  String extraPhotosFoundFor({required String text}) {
    return 'Extra foto\'s gevonden voor $text';
  }

  @override
  String get extraPhotosFound => 'Extra foto\'s gevonden';

  @override
  String get configuration => 'Configuratie';

  @override
  String get localIndexing => 'Lokaal indexeren';

  @override
  String get processed => 'Verwerkt';

  @override
  String get resetPerson => 'Verwijderen';

  @override
  String get areYouSureYouWantToResetThisPerson =>
      'Weet u zeker dat u deze persoon wilt resetten?';

  @override
  String get allPersonGroupingWillReset =>
      'Alle groepen voor deze persoon worden gereset, en je verliest alle suggesties die voor deze persoon zijn gedaan';

  @override
  String get yesResetPerson => 'Ja, reset persoon';

  @override
  String get onlyThem => 'Alleen hen';

  @override
  String get checkingModels => 'Modellen controleren...';

  @override
  String get enableMachineLearningBanner =>
      'Schakel machine learning in voor magische zoekopdrachten en gezichtsherkenning';

  @override
  String get searchDiscoverEmptySection =>
      'Afbeeldingen worden hier getoond zodra verwerking en synchroniseren voltooid is';

  @override
  String get searchPersonsEmptySection =>
      'Personen worden hier getoond zodra verwerking en synchroniseren voltooid is';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count kijkers toegevoegd',
      one: '1 kijker toegevoegd',
      zero: '0 kijkers toegevoegd',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count samenwerkers toegevoegd',
      one: '1 samenwerker toegevoegd',
      zero: '0 samenwerkers toegevoegd',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured => 'Account is al geconfigureerd.';

  @override
  String get sessionIdMismatch => 'Sessie ID komt niet overeen';

  @override
  String get failedToFetchActiveSessions =>
      'Ophalen van actieve sessies mislukt';

  @override
  String get failedToRefreshStripeSubscription =>
      'Abonnement vernieuwen mislukt';

  @override
  String get failedToPlayVideo => 'Afspelen van video mislukt';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return 'Upload wordt genegeerd omdat $ignoreReason';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'Galerijtype $galleryType wordt niet ondersteund voor hernoemen';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'Tik om te uploaden, upload wordt momenteel genegeerd vanwege $ignoreReason';
  }

  @override
  String get tapToUpload => 'Tik om te uploaden';

  @override
  String get info => 'Info';

  @override
  String get addFiles => 'Bestanden toevoegen';

  @override
  String get castAlbum => 'Album casten';

  @override
  String get imageNotAnalyzed => 'Afbeelding niet geanalyseerd';

  @override
  String get noFacesFound => 'Geen gezichten gevonden';

  @override
  String get fileNotUploadedYet => 'Bestand nog niet geüpload';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return 'Geen suggesties voor $personName';
  }

  @override
  String get month => 'maand';

  @override
  String get yearShort => 'jr';

  @override
  String get currentlyRunning => 'momenteel bezig';

  @override
  String get ignored => 'genegeerd';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count foto\'s',
      one: '1 foto',
      zero: '0 foto\'s',
    );
    return '$_temp0';
  }

  @override
  String get file => 'Bestand';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'Lengte van secties komt niet overeen: $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'Selecteer mail app';

  @override
  String get selectAllShort => 'Alle';

  @override
  String get selectCoverPhoto => 'Selecteer omslagfoto';

  @override
  String get newLocation => 'Nieuwe locatie';

  @override
  String get faceNotClusteredYet =>
      'Gezicht nog niet geclusterd, kom later terug';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'De link die je probeert te openen is verlopen.';

  @override
  String get openFile => 'Bestand openen';

  @override
  String get backupFile => 'Back-up bestand';

  @override
  String get openAlbumInBrowser => 'Open album in browser';

  @override
  String get openAlbumInBrowserTitle =>
      'Gebruik de webapp om foto\'s aan dit album toe te voegen';

  @override
  String get allow => 'Toestaan';

  @override
  String get allowAppToOpenSharedAlbumLinks =>
      'App toestaan gedeelde album links te openen';

  @override
  String get seePublicAlbumLinksInApp =>
      'Bekijk publieke album links in de app';

  @override
  String get emergencyContacts => 'Noodcontacten';

  @override
  String get acceptTrustInvite => 'Uitnodiging accepteren';

  @override
  String get declineTrustInvite => 'Uitnodiging afwijzen';

  @override
  String get removeYourselfAsTrustedContact =>
      'Verwijder jezelf als vertrouwd contact';

  @override
  String get legacy => 'Legacy';

  @override
  String get legacyPageDesc =>
      'Legacy geeft vertrouwde contacten toegang tot je account bij afwezigheid.';

  @override
  String get legacyPageDesc2 =>
      'Vertrouwde contacten kunnen accountherstel starten, en indien deze niet binnen 30 dagen wordt geblokkeerd, je wachtwoord resetten en toegang krijgen tot je account.';

  @override
  String get legacyAccounts => 'Legacy accounts';

  @override
  String get trustedContacts => 'Vertrouwde contacten';

  @override
  String get addTrustedContact => 'Vertrouwd contact toevoegen';

  @override
  String get removeInvite => 'Verwijder uitnodiging';

  @override
  String get recoveryWarning =>
      'Een vertrouwd contact probeert toegang te krijgen tot je account';

  @override
  String get rejectRecovery => 'Herstel weigeren';

  @override
  String get recoveryInitiated => 'Herstel gestart';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return 'U krijgt toegang tot het account na $days dagen. Een melding zal worden verzonden naar $email.';
  }

  @override
  String get cancelAccountRecovery => 'Herstel annuleren';

  @override
  String get recoveryAccount => 'Account herstellen';

  @override
  String get cancelAccountRecoveryBody =>
      'Weet je zeker dat je het herstel wilt annuleren?';

  @override
  String get startAccountRecoveryTitle => 'Herstel starten';

  @override
  String get whyAddTrustContact =>
      'Vertrouwde contacten kunnen helpen bij het herstellen van je data.';

  @override
  String recoveryReady({required String email}) {
    return 'U kunt nu het account van $email herstellen door een nieuw wachtwoord in te stellen.';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email probeert je account te herstellen.';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return 'Je bent uitgenodigd om een legacy contact van $email te zijn.';
  }

  @override
  String get warning => 'Waarschuwing';

  @override
  String get proceed => 'Verder';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return 'Je staat op het punt $email toe te voegen als vertrouwde contactpersoon. Ze kunnen je account herstellen als je $numOfDays dagen afwezig bent.';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email heeft je uitgenodigd om een vertrouwd contact te zijn';
  }

  @override
  String get authToManageLegacy =>
      'Verifieer om je vertrouwde contacten te beheren';

  @override
  String get hideSharedItemsFromHomeGallery =>
      'Verberg gedeelde bestanden uit de galerij';

  @override
  String get swipeToSelect => 'Swipe to select';

  @override
  String get gallery => 'Galerij';

  @override
  String get joinAlbum => 'Deelnemen aan album';

  @override
  String get joinAlbumSubtext => 'om je foto\'s te bekijken en toe te voegen';

  @override
  String get joinAlbumSubtextViewer =>
      'om dit aan gedeelde albums toe te voegen';

  @override
  String get join => 'Deelnemen';

  @override
  String get linkEmail => 'Link email';

  @override
  String get link => 'Link';

  @override
  String get noEnteAccountExclamation => 'Geen Ente account!';

  @override
  String get orPickFromYourContacts => 'of kies uit je contacten';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return '$email heeft geen Ente account.';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (Ik)';
  }

  @override
  String get reassignMe => '\"Ik\" opnieuw toewijzen';

  @override
  String get me => 'Ik';

  @override
  String get linkEmailToContactBannerCaption => 'voor sneller delen';

  @override
  String get selectPersonToLink => 'Kies persoon om te linken';

  @override
  String linkPersonToEmail({required String email}) {
    return 'Link persoon aan $email';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return 'Dit linkt $personName aan $email';
  }

  @override
  String get selectYourFace => 'Selecteer je gezicht';

  @override
  String get reassigningLoading => 'Opnieuw toewijzen...';

  @override
  String reassignedToName({required String name}) {
    return 'Toegewezen aan $name';
  }

  @override
  String get saveChangesBeforeLeavingQuestion =>
      'Wijzigingen opslaan voor verlaten?';

  @override
  String get dontSave => 'Niet opslaan';

  @override
  String get thisIsMeExclamation => 'Dit ben ik!';

  @override
  String get linkPerson => 'Link persoon';

  @override
  String get linkPersonCaption => 'voor een betere ervaring met delen';

  @override
  String get videoStreaming => 'Video\'s met stream';

  @override
  String get processingVideos => 'Video\'s verwerken';

  @override
  String get streamDetails => 'Stream details';

  @override
  String get processing => 'Verwerken';

  @override
  String get queued => 'In wachtrij';

  @override
  String get ineligible => 'Ongerechtigd';

  @override
  String get failed => 'Mislukt';

  @override
  String get playStream => 'Stream afspelen';

  @override
  String get playOriginal => 'Origineel afspelen';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'Deelnemen aan een album maakt je e-mail zichtbaar voor de deelnemers.';

  @override
  String get pleaseWaitThisWillTakeAWhile =>
      'Een ogenblik geduld, dit zal even duren.';

  @override
  String get editTime => 'Tijd bewerken';

  @override
  String get selectTime => 'Tijd selecteren';

  @override
  String get selectDate => 'Selecteer datum';

  @override
  String get previous => 'Vorige';

  @override
  String get selectOneDateAndTimeForAll =>
      'Selecteer één datum en tijd voor allen';

  @override
  String get selectStartOfRange => 'Selecteer start van reeks';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      'Dit maakt de datum en tijd van alle geselecteerde foto\'s hetzelfde.';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'Dit is de eerste in de groep. Andere geselecteerde foto\'s worden automatisch verschoven op basis van deze nieuwe datum';

  @override
  String get newRange => 'Nieuwe reeks';

  @override
  String get selectOneDateAndTime => 'Selecteer één datum en tijd';

  @override
  String get moveSelectedPhotosToOneDate =>
      'Verplaats de geselecteerde foto\'s naar één datum';

  @override
  String get shiftDatesAndTime => 'Verschuif datum en tijd';

  @override
  String get photosKeepRelativeTimeDifference =>
      'Foto\'s behouden relatief tijdsverschil';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count foto\'s',
      one: '1 foto',
      zero: 'Geen foto\'s',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'App icoon';

  @override
  String get notThisPerson => 'Niet dezelfde persoon?';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      'Geselecteerde bestanden worden van deze persoon verwijderd, maar niet uit uw bibliotheek verwijderd.';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat door de jaren';
  }

  @override
  String get thisWeekThroughTheYears => 'Deze week door de jaren';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Deze week, $count jaren geleden',
      one: 'Deze week, $count jaar geleden',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'Jij en $name';
  }

  @override
  String admiringThem({required Object name}) {
    return '$name bewonderen';
  }

  @override
  String embracingThem({required Object name}) {
    return '$name omarmen';
  }

  @override
  String partyWithThem({required Object name}) {
    return 'Feest met $name';
  }

  @override
  String hikingWithThem({required Object name}) {
    return 'Wandelen met $name';
  }

  @override
  String feastingWithThem({required Object name}) {
    return 'Feestmaal met $name';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return 'Selfies met $name';
  }

  @override
  String posingWithThem({required Object name}) {
    return 'Poseren met $name';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return 'Prachtige uitzichten met $name';
  }

  @override
  String sportsWithThem({required Object name}) {
    return 'Sporten met $name';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return 'Roadtrip met $name';
  }

  @override
  String get spotlightOnYourself => 'Spotlicht op jezelf';

  @override
  String spotlightOnThem({required Object name}) {
    return 'Spotlicht op $name';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$name is $age!';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name wordt binnenkort $age';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return 'Laatste keer met $name';
  }

  @override
  String tripToLocation({required Object location}) {
    return 'Reis naar $location';
  }

  @override
  String tripInYear({required Object year}) {
    return 'Reis in $year';
  }

  @override
  String get lastYearsTrip => 'Reis van vorig jaar';

  @override
  String get sunrise => 'Aan de horizon';

  @override
  String get mountains => 'Over de heuvels';

  @override
  String get greenery => 'Het groene leven';

  @override
  String get beach => 'Zand en zee';

  @override
  String get city => 'In de stad';

  @override
  String get moon => 'In het maanlicht';

  @override
  String get onTheRoad => 'Onderweg';

  @override
  String get food => 'Culinaire vreugde';

  @override
  String get pets => 'Harige kameraden';

  @override
  String get curatedMemories => 'Samengestelde herinneringen';

  @override
  String get widgets => 'Widgets';

  @override
  String get memories => 'Herinneringen';

  @override
  String get peopleWidgetDesc =>
      'Selecteer de mensen die je wilt zien op je beginscherm.';

  @override
  String get albumsWidgetDesc =>
      'Selecteer de albums die je wilt zien op je beginscherm.';

  @override
  String get memoriesWidgetDesc =>
      'Selecteer het soort herinneringen dat je wilt zien op je beginscherm.';

  @override
  String get smartMemories => 'Slimme herinneringen';

  @override
  String get pastYearsMemories => 'Afgelopen jaren';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return 'Verwijder de foto\'s (en video\'s) van deze $count albums ook uit <bold>alle</bold> andere albums waar deze deel van uitmaken?';
  }

  @override
  String get addParticipants => 'Voeg deelnemers toe';

  @override
  String selectedAlbums({required Object count}) {
    return '$count geselecteerd';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'Actie niet ondersteund op Favorieten album';

  @override
  String get onThisDayMemories => 'Op deze dag herinneringen';

  @override
  String get onThisDay => 'Op deze dag';

  @override
  String get lookBackOnYourMemories => 'Kijk terug op je herinneringen 🌄';

  @override
  String get newPhotosEmoji => ' nieuwe 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'Sorry, we moesten je back-ups pauzeren';

  @override
  String get clickToInstallOurBestVersionYet =>
      'Klik om onze beste versie tot nu toe te installeren';

  @override
  String get onThisDayNotificationExplanation =>
      'Ontvang meldingen over herinneringen op deze dag door de jaren heen.';

  @override
  String get addMemoriesWidgetPrompt =>
      'Voeg een widget toe aan je beginscherm en kom hier terug om aan te passen.';

  @override
  String get addAlbumWidgetPrompt =>
      'Voeg een widget toe aan je beginscherm en kom hier terug om aan te passen.';

  @override
  String get addPeopleWidgetPrompt =>
      'Voeg een widget toe aan je beginscherm en kom hier terug om aan te passen.';

  @override
  String get birthdayNotifications => 'Meldingen over verjaardagen';

  @override
  String get receiveRemindersOnBirthdays =>
      'Ontvang herinneringen wanneer iemand jarig is. Als je op de melding drukt, krijg je foto\'s van de jarige.';

  @override
  String get happyBirthday => 'Fijne verjaardag! 🥳';

  @override
  String get birthdays => 'Verjaardagen';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return 'Wens $name een fijne verjaardag! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      'Weet je zeker dat je dit gezicht van deze persoon wilt verwijderen?';

  @override
  String get otherDetectedFaces => 'Andere gedetecteerde gezichten';

  @override
  String get areThey => 'Is dit ';

  @override
  String get questionmark => '?';

  @override
  String get saveAsAnotherPerson => 'Opslaan als ander persoon';

  @override
  String get showLessFaces => 'Minder gezichten weergeven';

  @override
  String get showMoreFaces => 'Minder gezichten weergeven';

  @override
  String get ignore => 'Negeren';

  @override
  String get merge => 'Samenvoegen';

  @override
  String get reset => 'Reset';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      'Weet je zeker dat je deze persoon wilt negeren?';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      'Weet je zeker dat je deze personen wilt negeren?';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'De groepen worden niet meer getoond in de personen sectie. Foto\'s blijven ongemoeid.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'De persoon wordt niet meer getoond in de personen sectie. Foto\'s blijven ongemoeid.';

  @override
  String get areYouSureYouWantToMergeThem =>
      'Weet je zeker dat je ze wilt samenvoegen?';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'Alle naamloze groepen worden samengevoegd met de geselecteerde persoon. Dit kan nog steeds ongedaan worden gemaakt vanuit het geschiedenisoverzicht van de persoon.';

  @override
  String get yesIgnore => 'Ja, negeer';

  @override
  String get same => 'Zelfde';

  @override
  String get different => 'Andere';

  @override
  String get sameperson => 'Zelfde persoon?';

  @override
  String get indexingPausedStatusDescription =>
      'Indexeren is gepauzeerd. Het zal automatisch verdergaan wanneer het apparaat er klaar voor is. Het apparaat is er klaar voor wanneer batterijniveau, batterijgezondheid, en thermische status binnen het gezonde bereik liggen.';

  @override
  String get thisWeek => 'Deze week';

  @override
  String get lastWeek => 'Afgelopen week';

  @override
  String get thisMonth => 'Deze maand';

  @override
  String get thisYear => 'Dit jaar';

  @override
  String get groupBy => 'Groepeer op';

  @override
  String get faceThumbnailGenerationFailed => 'Kan thumbnails niet genereren';

  @override
  String get fileAnalysisFailed => 'Kan bestand niet analyseren';

  @override
  String get editAutoAddPeople => 'Bewerk automatisch personen toevoegen';

  @override
  String get autoAddPeople => 'Automatisch personen toevoegen';

  @override
  String get autoAddToAlbum => 'Automatisch toevoegen aan album';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      'Moeten de bestanden met betrekking tot de persoon die eerder was geselecteerd in slimme albums worden verwijderd?';

  @override
  String get addingPhotos => 'Foto\'s aan het toevoegen';

  @override
  String get gettingReady => 'Bezig met voorbereiden';

  @override
  String get addSomePhotosDesc1 => 'Voeg foto\'s toe of kies ';

  @override
  String get addSomePhotosDesc2 => 'bekende gezichten';

  @override
  String get addSomePhotosDesc3 => '\nom mee te beginnen';

  @override
  String get ignorePerson => 'Negeer persoon';

  @override
  String get mixedGrouping => 'Gemixte groep?';

  @override
  String get analysis => 'Analyse';

  @override
  String get doesGroupContainMultiplePeople =>
      'Bevat deze groepering meerdere personen?';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'We zullen automatisch de groepering analyseren om te bepalen of er meerdere mensen aanwezig zijn en ze opnieuw scheiden. Dit kan een paar seconden duren.';

  @override
  String get layout => 'Layout';

  @override
  String get day => 'Dag';

  @override
  String get undo => 'Ongedaan maken';

  @override
  String get redo => 'Herstel ongedaan maken';

  @override
  String get filter => 'Filter';

  @override
  String get adjust => 'Aanpassen';

  @override
  String get draw => 'Teken';

  @override
  String get sticker => 'Sticker';

  @override
  String get brushColor => 'Kwast kleur';

  @override
  String get font => 'Lettertype';

  @override
  String get background => 'Achtergrond';

  @override
  String get align => 'Uitlijnen';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Succesvol toegevoegd aan $count albums',
      one: 'Succesvol toegevoegd aan 1 album',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => 'Video\'s verwerkt';

  @override
  String get totalVideos => 'Totaal aantal video\'s';

  @override
  String get skippedVideos => 'Overgeslagen video\'s';

  @override
  String get videoStreamingDescriptionLine1 =>
      'Video\'s direct afspelen op elk apparaat.';

  @override
  String get videoStreamingDescriptionLine2 =>
      'Schakel in om videostreams te verwerken op dit apparaat.';

  @override
  String get videoStreamingNote =>
      'Alleen video\'s van de afgelopen 60 dagen en korter dan 1 minuut worden op dit apparaat verwerkt. Voor oudere video\'s, schakel streaming in via de desktop app.';

  @override
  String get createStream => 'Creëer stream';

  @override
  String get recreateStream => 'Hercreëer stream';

  @override
  String get addedToStreamCreationQueue =>
      'Toegevoegd aan stream creatie wachtrij';

  @override
  String get addedToStreamRecreationQueue =>
      'Toegevoegd aan stream recreatie wachtrij';

  @override
  String get videoPreviewAlreadyExists => 'Videovoorbeeld bestaat al';

  @override
  String get videoAlreadyInQueue =>
      'Videobestand is al aanwezig in de wachtrij';

  @override
  String get videoExportFailed => 'Video creation failed. Please try again.';

  @override
  String videoExportSuccess({required String path}) {
    return 'Video successfully created at $path';
  }

  @override
  String get addedToQueue => 'Toegevoegd aan de wachtrij';

  @override
  String get creatingStream => 'Stream aan het maken';

  @override
  String get similarImages => 'Soortgelijke afbeeldingen';

  @override
  String get findSimilarImages => 'Vind soortgelijke afbeeldingen';

  @override
  String get noSimilarImagesFound => 'Geen soortgelijke afbeeldingen gevonden';

  @override
  String get yourPhotosLookUnique => 'Your photos look unique';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count groepen gevonden',
      one: '$count groep gevonden',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages =>
      'Controleer en verwijder soortgelijke afbeeldingen';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return 'Verwijder $count foto\'s ($size)';
  }

  @override
  String get selectionOptions => 'Selectieopties';

  @override
  String selectExactWithCount({required int count}) {
    return 'Exact hetzelfde ($count)';
  }

  @override
  String get selectExact => 'Select exact';

  @override
  String selectSimilarWithCount({required int count}) {
    return 'Grotendeels hetzelfde ($count)';
  }

  @override
  String get selectSimilar => 'Select similar';

  @override
  String selectAllWithCount({required int count}) {
    return 'All similarities ($count)';
  }

  @override
  String get selectSimilarImagesTitle => 'Selecteer soortgelijke afbeeldingen';

  @override
  String get chooseSimilarImagesToSelect =>
      'Selecteer afbeeldingen op basis van hun visuele overeenkomstigheid';

  @override
  String get clearSelection => 'Selectie ongedaan maken';

  @override
  String similarImagesCount({required int count}) {
    return '$count soortgelijke afbeeldingen';
  }

  @override
  String deleteWithCount({required int count}) {
    return 'Verwijder ($count)';
  }

  @override
  String get deleteFiles => 'Verwijder bestanden';

  @override
  String get areYouSureDeleteFiles =>
      'Weet je zeker dat je deze bestanden wilt verwijderen?';

  @override
  String get greatJob => 'Goed gedaan!';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return 'Je hebt $size vrijgemaakt';
  }

  @override
  String get size => 'Formaat';

  @override
  String get similarity => 'Similarity';

  @override
  String get analyzingPhotosLocally =>
      'Bezig met je foto\'s lokaal analyseren...';

  @override
  String get lookingForVisualSimilarities =>
      'Zoeken naar visuele overeenkomsten...';

  @override
  String get comparingImageDetails => 'Comparing image details...';

  @override
  String get findingSimilarImages =>
      'Soortgelijke afbeeldingen aan het zoeken...';

  @override
  String get almostDone => 'Bijna klaar...';

  @override
  String get processingLocally => 'Lokaal aan het verwerken';

  @override
  String get useMLToFindSimilarImages =>
      'Controleer en verwijder afbeeldingen die op elkaar lijken.';

  @override
  String get all => 'All';

  @override
  String get similar => 'Vergelijkbaar';

  @override
  String get identical => 'Identiek';

  @override
  String get nothingHereTryAnotherFilter =>
      'Niets hier, probeer een ander filter! 👀';

  @override
  String get related => 'Gerelateerd';

  @override
  String get hoorayyyy => 'Hoeraaaa!';

  @override
  String get nothingToTidyUpHere => 'Niks op te schonen hier';

  @override
  String get deletingDash => 'Verwijderen - ';

  @override
  String get cLTitle1 => 'Jump to date';

  @override
  String get cLDesc1 =>
      'See surrounding photos for any photo by selecting the jump to date option in the file\'s info pane.';

  @override
  String get cLTitle2 => 'Faster video editor';

  @override
  String get cLDesc2 =>
      'Video editor was revamped to both drastically improve its speed when editing larger videos, and also improve the UX.';

  @override
  String get cLTitle3 => 'Nieuwe herinneringen';

  @override
  String get cLDesc3 =>
      '\"Playful kids\", \"Winter adventures\", \"Neon nights\", and more.';

  @override
  String get cLTitle4 => 'Landscape gallery and more';

  @override
  String get cLDesc4 =>
      'Support for landscape layout in the app\'s main gallery. Show persons without any associated photos instead of filtering them out. Improve video aspect detection when shared from external apps.';

  @override
  String get closeBy => 'Nauw verwant';

  @override
  String get peopleAutoAddDesc =>
      'Automatically add photos of the selected people to this album';

  @override
  String get festivities => 'Feestelijkheden';

  @override
  String get snowAdventures => 'Winterse avonturen';

  @override
  String get waterfalls => 'Watervallen';

  @override
  String get wildlife => 'In het wild';

  @override
  String get flowers => 'Bloeiende bloemen';

  @override
  String get nightLights => 'Neonnachten';

  @override
  String get architecture => 'Architectuur';

  @override
  String get autumnColors => 'Heerlijke herfst';

  @override
  String get desertDreams => 'Desert dreams';

  @override
  String get stargazing => 'Sterrenhemel';

  @override
  String get lakeside => 'Lakeside calm';

  @override
  String get rainyDays => 'Rainy day feels';

  @override
  String get sportsAction => 'Game on';

  @override
  String get streetArt => 'Street art stories';

  @override
  String get familyMoments => 'Family time';

  @override
  String get fireworks => 'Vuurwerk';

  @override
  String get historicSites => 'Historische plaatsen';

  @override
  String get tropicalParadise => 'Tropische paradijzen';

  @override
  String get forestTrails => 'Boswandelingen';

  @override
  String get citySunsets => 'De stad in gouden gloed';

  @override
  String get colorfulMarkets => 'Levendige markten';

  @override
  String get cozyCafes => 'Knusse cafés';

  @override
  String get vintageVibes => 'Vintage vibes';

  @override
  String get aerialViews => 'De lucht in';

  @override
  String get artisticPortraits => 'Kunstige portretten';

  @override
  String get streetFood => 'Street food bites';

  @override
  String get riverCruises => 'Uitzichten vanaf de cruise';

  @override
  String get facesTimelineBannerTitle => 'Memory Lane';

  @override
  String facesTimelineBannerSubtitle({required String name}) {
    return 'See $name\'s photos across the years';
  }

  @override
  String get facesTimelineAppBarTitle => 'Memory lane';

  @override
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count years old',
      one: '$count year old',
    );
    return '$name was $_temp0';
  }

  @override
  String facesTimelineCaptionYearsAgo({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '# years ago',
      one: '# year ago',
    );
    return '$_temp0';
  }

  @override
  String get facesTimelineShareComingSoon => 'Video sharing coming soon';

  @override
  String get facesTimelinePlaybackPrevious => 'Previous';

  @override
  String get facesTimelinePlaybackNext => 'Next';

  @override
  String get facesTimelinePlaybackPlay => 'Play';

  @override
  String get facesTimelinePlaybackPause => 'Pause';

  @override
  String get facesTimelineUnavailable => 'Faces timeline is preparing...';

  @override
  String get playfulKids => 'Spelende kinderen';

  @override
  String get coastalCliffs => 'Kliffen bij de zee';

  @override
  String get ritualsTitle => 'Rituals';

  @override
  String get ritualAddTooltip => 'Add ritual';

  @override
  String get ritualActivityHeading => 'Activity';

  @override
  String get ritualDefaultHeatmapTitle => 'Take a photo every day';

  @override
  String get ritualUntitled => 'Untitled ritual';

  @override
  String get ritualShareUnavailable =>
      'Unable to share right now. Please try again.';

  @override
  String get ritualNotificationMessage => 'Take a photo now';

  @override
  String get ritualCameraNotFound => 'No camera found on this device.';

  @override
  String get ritualCameraStartError =>
      'Unable to start camera. Please check permissions.';

  @override
  String get ritualCaptureError => 'Unable to capture photo. Please try again.';

  @override
  String ritualPhotoLimit({required int maxPhotos}) {
    String _temp0 = intl.Intl.pluralLogic(
      maxPhotos,
      locale: localeName,
      other: '# photos.',
      one: '# photo.',
    );
    return 'You can add up to $_temp0';
  }

  @override
  String get ritualCaptureAtLeastOne => 'Capture at least one photo first.';

  @override
  String get ritualAlbumMissing =>
      'Ritual album missing. Edit the ritual to set an album.';

  @override
  String get ritualAddedToAlbum => 'Added to album';

  @override
  String ritualAddedToAlbumWithName({required String albumName}) {
    return 'Added to $albumName';
  }

  @override
  String ritualAddToAlbumFailure({required String error}) {
    return 'Couldn\'t add photos to the album: $error';
  }

  @override
  String get ritualBackToList => 'Back to rituals';

  @override
  String get ritualNoPhotosYet => 'No photos yet';

  @override
  String get ritualSetAlbumToLaunchCamera =>
      'Set an album for this ritual to launch the camera.';

  @override
  String get ritualDefaultCameraTitle => 'Take a photo';

  @override
  String get ritualBadgeMessage7 =>
      '7 days down! Consistency looks good on you. Keep going!';

  @override
  String get ritualBadgeMessage14 =>
      '14 days in! Your ritual is becoming a habit. Incredible!';

  @override
  String get ritualBadgeMessage30 =>
      '30 days in a row! Legendary consistency. Take a bow!';

  @override
  String get ritualBadgeMessageDefault => 'You\'re on a roll!';

  @override
  String get ritualBadgeNewTitle => 'New achievement';

  @override
  String get ritualBadgePreparing => 'Preparing...';

  @override
  String get ritualStreaksLabel => 'Streaks';

  @override
  String get ritualCreateYourOwn => 'Create your own ritual';

  @override
  String get ritualGetDailyReminders => 'Get daily reminders';

  @override
  String get ritualAlbumNotSet => 'Album not set';

  @override
  String get ritualOpenCameraTooltip => 'Open ritual camera';

  @override
  String get ritualEditorLabel => 'Ritual editor';

  @override
  String get ritualNew => 'New ritual';

  @override
  String get ritualEdit => 'Edit ritual';

  @override
  String get ritualEnterPrompt => 'Enter your ritual';

  @override
  String get ritualEnterDescription => 'Please enter a description';

  @override
  String get ritualDayLabel => 'Day';

  @override
  String get ritualNotificationsOffHint =>
      'Notifications are off. Tap a day to turn them on.';

  @override
  String get ritualTimeLabel => 'Time';

  @override
  String get ritualAlbumLabel => 'Album';

  @override
  String get ritualSave => 'Save ritual';

  @override
  String get ritualUpdate => 'Update ritual';

  @override
  String get ritualSelectAlbumTitle => 'Select album';

  @override
  String get ritualSearchOrCreate => 'Search or create new';

  @override
  String get ritualNoAlbumsYet => 'No albums yet';

  @override
  String get ritualNoMatchingAlbums => 'No matching albums';

  @override
  String ritualCreateAlbumWithName({required String albumName}) {
    return 'Create \"$albumName\"';
  }

  @override
  String get ritualCreateNew => 'Create new';

  @override
  String get ritualAlbumSelectionPlaceholder => 'Select album';

  @override
  String get ritualPickEmojiTitle => 'Pick an emoji';

  @override
  String get ritualCustomKeyboardLabel => 'Custom (keyboard)';

  @override
  String get ritualEmojiKeyboardHint => 'Press to open emoji keyboard';

  @override
  String get ritualEmojiUseAction => 'Use';

  @override
  String get ritualSearchEmpty =>
      'Build a ritual to keep your photo habit going.';
}
