// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Danish (`da`).
class AppLocalizationsDa extends AppLocalizations {
  AppLocalizationsDa([String locale = 'da']) : super(locale);

  @override
  String get enterYourEmailAddress => 'Indtast din email adresse';

  @override
  String get enterYourNewEmailAddress => 'Enter your new email address';

  @override
  String get accountWelcomeBack => 'Velkommen tilbage!';

  @override
  String get emailAlreadyRegistered => 'E-mail er allerede registreret.';

  @override
  String get emailNotRegistered => 'E-mail er ikke registreret.';

  @override
  String get email => 'Email';

  @override
  String get cancel => 'Annuller';

  @override
  String get verify => 'Bekræft';

  @override
  String get invalidEmailAddress => 'Ugyldig email adresse';

  @override
  String get enterValidEmail => 'Indtast venligst en gyldig email adresse.';

  @override
  String get deleteAccount => 'Slet konto';

  @override
  String get deleteAccountWarning =>
      'This will delete your Ente Auth, Ente Photos and Ente Locker account.';

  @override
  String get askDeleteReason =>
      'Hvad er hovedårsagen til, at du sletter din konto?';

  @override
  String get deleteAccountFeedbackPrompt =>
      'Vi er kede af at du forlader os. Forklar venligst hvorfor, så vi kan forbedre os.';

  @override
  String get feedback => 'Feedback';

  @override
  String get kindlyHelpUsWithThisInformation =>
      'Hjælp os venligst med disse oplysninger';

  @override
  String get confirmDeletePrompt =>
      'Yes, I want to permanently delete this account and its data across all apps.';

  @override
  String get confirmAccountDeletion => 'Bekræft Sletning Af Konto';

  @override
  String get deleteAccountPermanentlyButton => 'Slet konto permanent';

  @override
  String get yourAccountHasBeenDeleted => 'Din konto er blevet slettet';

  @override
  String get selectReason => 'Vælg årsag';

  @override
  String get deleteReason1 =>
      'Der mangler en vigtig funktion, som jeg har brug for';

  @override
  String get deleteReason2 =>
      'App\'en eller en bestemt funktion virker ikke som den skal';

  @override
  String get deleteReason3 =>
      'Jeg fandt en anden tjeneste, som jeg syntes bedre om';

  @override
  String get deleteReason4 => 'Min grund er ikke angivet';

  @override
  String get sendEmail => 'Send email';

  @override
  String get deleteRequestSLAText =>
      'Din anmodning vil blive behandlet inden for 72 timer.';

  @override
  String get deleteEmailRequest =>
      'Send venligst en email til <warning>account-deletion@ente.io</warning> fra din registrerede email adresse.';

  @override
  String get entePhotosPerm =>
      'Ente <i>needs permission to</i> preserve your photos';

  @override
  String get ok => 'Ok';

  @override
  String get createAccount => 'Opret konto';

  @override
  String get createNewAccount => 'Opret en ny konto';

  @override
  String get password => 'Adgangskode';

  @override
  String get confirmPassword => 'Bekræft adgangskode';

  @override
  String get activeSessions => 'Aktive sessioner';

  @override
  String get ocrProcessingOverlayMessage => 'Detecting text...';

  @override
  String get ocrLoadingIndicatorLabel => 'Detecting Text';

  @override
  String get ocrSelectionHint =>
      'Swipe or double tap to select just what you need';

  @override
  String get ocrNoTextDetected => 'No text detected';

  @override
  String get ocrRetryButtonLabel => 'Retry';

  @override
  String get ocrModelsNetworkRequiredError =>
      'Network connection required to download OCR models on first use';

  @override
  String get ocrModelsPrepareFailed => 'Could not prepare OCR models';

  @override
  String get ocrImageNotFoundError => 'Image file not found';

  @override
  String get ocrImageDecodeFailedError => 'Could not read image file';

  @override
  String get ocrGenericDetectError => 'Could not detect text in image';

  @override
  String get oops => 'Ups';

  @override
  String get somethingWentWrongPleaseTryAgain =>
      'Noget gik galt, prøv venligst igen';

  @override
  String get thisWillLogYouOutOfThisDevice =>
      'Dette vil logge dig ud af denne enhed!';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice =>
      'Dette vil logge dig ud af følgende enhed:';

  @override
  String get terminateSession => 'Afslut session?';

  @override
  String get terminate => 'Afbryd';

  @override
  String get thisDevice => 'Denne enhed';

  @override
  String get recoverButton => 'Gendan';

  @override
  String get recoverySuccessful => 'Gendannelse lykkedes!';

  @override
  String get decrypting => 'Dekrypterer...';

  @override
  String get incorrectRecoveryKeyTitle => 'Forkert gendannelsesnøgle';

  @override
  String get incorrectRecoveryKeyBody =>
      'Den gendannelsesnøgle du indtastede er forkert';

  @override
  String get forgotPassword => 'Glemt adgangskode';

  @override
  String get enterYourRecoveryKey => 'Indtast din gendannelsesnøgle';

  @override
  String get noRecoveryKey => 'Ingen gendannelsesnøgle?';

  @override
  String get sorry => 'Beklager';

  @override
  String get noRecoveryKeyNoDecryption =>
      'Due to the nature of our end-to-end encryption protocol, your data cannot be decrypted without your password or recovery key';

  @override
  String get verifyEmail => 'Bekræft e-mail';

  @override
  String get toResetVerifyEmail =>
      'For at nulstille din adgangskode, bekræft venligst din email adresse.';

  @override
  String get checkInboxAndSpamFolder =>
      'Tjek venligst din indbakke (og spam) for at færdiggøre verificeringen';

  @override
  String get tapToEnterCode => 'Tryk for at indtaste kode';

  @override
  String get resendEmail => 'Send email igen';

  @override
  String weHaveSendEmailTo({required String email}) {
    return 'Vi har sendt en email til <green>$email</green>';
  }

  @override
  String get setPasswordTitle => 'Angiv adgangskode';

  @override
  String get changePasswordTitle => 'Skift adgangskode';

  @override
  String get resetPasswordTitle => 'Nulstil adgangskode';

  @override
  String get encryptionKeys => 'Krypteringsnøgler';

  @override
  String get passwordWarning =>
      'Vi gemmer ikke denne adgangskode, så hvis du glemmer den <underline>kan vi ikke dekryptere dine data</underline>';

  @override
  String get enterPasswordToEncrypt =>
      'Indtast en adgangskode vi kan bruge til at kryptere dine data';

  @override
  String get enterNewPasswordToEncrypt =>
      'Indtast en ny adgangskode vi kan bruge til at kryptere dine data';

  @override
  String get weakStrength => 'Svagt';

  @override
  String get strongStrength => 'Stærkt';

  @override
  String get moderateStrength => 'Moderat';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'Kodeordets styrke: $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully => 'Adgangskoden er blevet ændret';

  @override
  String get generatingEncryptionKeys => 'Genererer krypteringsnøgler...';

  @override
  String get pleaseWait => 'Vent venligst...';

  @override
  String get continueLabel => 'Fortsæt';

  @override
  String get insecureDevice => 'Usikker enhed';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'Beklager, vi kunne ikke generere sikre krypteringsnøgler på denne enhed.\n\nForsøg venligst at oprette en konto fra en anden enhed.';

  @override
  String get howItWorks => 'Sådan fungerer det';

  @override
  String get encryption => 'Kryptering';

  @override
  String get ackPasswordLostWarning =>
      'Jeg forstår at hvis jeg mister min adgangskode kan jeg miste mine data, da mine data er <underline>end-to-end krypteret</underline>.';

  @override
  String get privacyPolicyTitle => 'Privatlivspolitik';

  @override
  String get termsOfServicesTitle => 'Betingelser';

  @override
  String get signUpTerms =>
      'Jeg er enig i <u-terms>betingelser for brug</u-terms> og <u-policy>privatlivspolitik</u-policy>';

  @override
  String get logInLabel => 'Log ind';

  @override
  String get loginTerms =>
      'Ved at klikke på log ind accepterer jeg <u-terms>vilkårene for service</u-terms> og <u-policy>privatlivspolitik</u-policy>';

  @override
  String get changeEmail => 'Skift email adresse';

  @override
  String get enterYourPassword => 'Indtast adgangskode';

  @override
  String get welcomeBack => 'Velkommen tilbage!';

  @override
  String get contactSupport => 'Kontakt support';

  @override
  String get locationPickerTip =>
      'You can also add a location centered on a photo from the photo\'s info screen';

  @override
  String get incorrectPasswordTitle => 'Forkert adgangskode';

  @override
  String get pleaseTryAgain => 'Prøv venligst igen';

  @override
  String get recreatePasswordTitle => 'Genskab adgangskode';

  @override
  String get useRecoveryKey => 'Brug gendannelsesnøgle';

  @override
  String get recreatePasswordBody =>
      'The current device is not powerful enough to verify your password, but we can regenerate in a way that works with all devices.\n\nPlease login using your recovery key and regenerate your password (you can use the same one again if you wish).';

  @override
  String get verifyPassword => 'Bekræft adgangskode';

  @override
  String get recoveryKey => 'Gendannelse nøgle';

  @override
  String get recoveryKeyOnForgotPassword =>
      'Hvis du glemmer din adgangskode, den eneste måde, du kan gendanne dine data er med denne nøgle.';

  @override
  String get recoveryKeySaveDescription =>
      'Vi gemmer ikke denne nøgle, gem venligst denne 24 ord nøgle på et sikkert sted.';

  @override
  String get doThisLater => 'Gør det senere';

  @override
  String get saveKey => 'Gem nøgle';

  @override
  String get recoveryKeyCopiedToClipboard =>
      'Gendannelsesnøgle kopieret til udklipsholder';

  @override
  String get recoverAccount => 'Gendan konto';

  @override
  String get recover => 'Gendan';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'Send venligst en email til $supportEmail fra din registrerede email adresse';
  }

  @override
  String get twofactorSetup => 'To-faktor opsætning';

  @override
  String get enterCode => 'Indtast kode';

  @override
  String get scanCode => 'Skan kode';

  @override
  String get codeCopiedToClipboard => 'Kode kopieret til udklipsholder';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      'Kopiér denne kode\ntil din autentificeringsapp';

  @override
  String get tapToCopy => 'tryk for at kopiere';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      'Skan denne QR-kode med godkendelses-appen';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      'Indtast den 6-cifrede kode fra din autentificeringsapp';

  @override
  String get confirm => 'Bekræft';

  @override
  String get setupComplete => 'Opsætning fuldført';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready =>
      'Gem din gendannelsesnøgle, hvis du ikke allerede har';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      'Dette kan bruges til at gendanne din konto, hvis du mister din anden faktor';

  @override
  String get twofactorAuthenticationPageTitle => 'To-faktor-godkendelse';

  @override
  String get lostDevice => 'Har du mistet enhed?';

  @override
  String get verifyingRecoveryKey => 'Verificerer gendannelsesnøgle...';

  @override
  String get recoveryKeyVerified => 'Gendannelsesnøgle bekræftet';

  @override
  String get recoveryKeySuccessBody =>
      'Super! Din gendannelsesnøgle er gyldig. Tak fordi du verificerer.\n\nHusk at holde din gendannelsesnøgle sikker sikkerhedskopieret.';

  @override
  String get invalidRecoveryKey =>
      'The recovery key you entered is not valid. Please make sure it contains 24 words, and check the spelling of each.\n\nIf you entered an older recovery code, make sure it is 64 characters long, and check each of them.';

  @override
  String get invalidKey => 'Ugyldig nøgle';

  @override
  String get tryAgain => 'Prøv igen';

  @override
  String get viewRecoveryKey => 'Vis gendannelsesnøgle';

  @override
  String get confirmRecoveryKey => 'Bekræft gendannelsesnøgle';

  @override
  String get recoveryKeyVerifyReason =>
      'Your recovery key is the only way to recover your photos if you forget your password. You can find your recovery key in Settings > Account.\n\nPlease enter your recovery key here to verify that you have saved it correctly.';

  @override
  String get confirmYourRecoveryKey => 'Bekræft din gendannelsesnøgle';

  @override
  String get addViewer => 'Tilføj seer';

  @override
  String get addCollaborator => 'Tilføj samarbejdspartner';

  @override
  String get addANewEmail => 'Tilføj en ny e-mail';

  @override
  String get orPickAnExistingOne => 'Eller vælg en eksisterende';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'Collaborators can add photos and videos to the shared album.';

  @override
  String get enterEmail => 'Indtast email adresse';

  @override
  String get albumOwner => 'Ejer';

  @override
  String get you => 'Dig';

  @override
  String get collaborator => 'Collaborator';

  @override
  String get addMore => 'Tilføj flere';

  @override
  String get viewer => 'Seer';

  @override
  String get remove => 'Fjern';

  @override
  String get removeParticipant => 'Fjern deltager';

  @override
  String get manage => 'Administrér';

  @override
  String get addedAs => 'Tilføjet som';

  @override
  String get changePermissions => 'Rediger rettigheder?';

  @override
  String get yesConvertToViewer => 'Ja, konverter til præsentation';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return '$user vil ikke kunne tilføje flere billeder til dette album\n\nDe vil stadig kunne fjerne eksisterende billeder tilføjet af dem';
  }

  @override
  String get allowAddingPhotos => 'Tillad tilføjelse af fotos';

  @override
  String get allowJoiningAlbum => 'Allow joining album';

  @override
  String get allowAddPhotosDescription =>
      'Tillad personer med linket også at tilføje billeder til det delte album.';

  @override
  String get passwordLock => 'Adgangskodelås';

  @override
  String get canNotOpenTitle => 'Cannot open this album';

  @override
  String get canNotOpenBody => 'Beklager, dette album kan ikke åbnes i appen.';

  @override
  String get disableDownloadWarningTitle => 'Bemærk venligst';

  @override
  String get disableDownloadWarningBody =>
      'Viewers can still take screenshots or save a copy of your photos using external tools';

  @override
  String get allowDownloads => 'Tillad downloads';

  @override
  String get linkDeviceLimit => 'Enheds grænse';

  @override
  String get noDeviceLimit => 'Ingen';

  @override
  String get albumLayout => 'Album layout';

  @override
  String get layoutGrouped => 'Grouped';

  @override
  String get layoutContinuous => 'Continuous';

  @override
  String get layoutTrip => 'Trip';

  @override
  String get preview => 'Preview';

  @override
  String get linkExpiry => 'Udløb af link';

  @override
  String get linkExpired => 'Udløbet';

  @override
  String get linkEnabled => 'Aktiveret';

  @override
  String get linkNeverExpires => 'Aldrig';

  @override
  String get expiredLinkInfo =>
      'This link has expired. Please select a new expiry time or disable link expiry.';

  @override
  String get setAPassword => 'Set a password';

  @override
  String get lockButtonLabel => 'Lås';

  @override
  String get enterPassword => 'Indtast adgangskode';

  @override
  String get removeLink => 'Fjern link';

  @override
  String get manageLink => 'Manage link';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'Link udløber den $expiryTime';
  }

  @override
  String get albumUpdated => 'Album er opdateret';

  @override
  String get never => 'Aldrig';

  @override
  String get custom => 'Tilpasset';

  @override
  String get after1Hour => 'Efter 1 time';

  @override
  String get after1Day => 'Efter 1 dag';

  @override
  String get after1Week => 'Efter 1 uge';

  @override
  String get after1Month => 'Efter 1 måned';

  @override
  String get after1Year => 'Efter 1 år';

  @override
  String get manageParticipants => 'Administrer';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Deltagere',
      one: '1 Deltager',
      zero: 'Ingen Deltagere',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'Opret et link, så folk kan tilføje og se fotos i dit delte album uden at behøve en Ente-app eller konto. Fantastisk til at indsamle event fotos.';

  @override
  String get collectPhotos => 'Indsaml billeder';

  @override
  String get collaborativeLink => 'Kollaborativt link';

  @override
  String get shareWithNonenteUsers => 'Del med ikke Ente brugere';

  @override
  String get createPublicLink => 'Opret et offentligt link';

  @override
  String get sendLink => 'Send link';

  @override
  String get qrCode => 'QR Code';

  @override
  String get sendQrCode => 'Send QR code';

  @override
  String get copyLink => 'Kopiér link';

  @override
  String get copyEmbedHtml => 'Copy embed HTML';

  @override
  String get linkHasExpired => 'Linket er udløbet';

  @override
  String get publicLinkEnabled => 'Offentligt link aktiveret';

  @override
  String get shareALink => 'Del et link';

  @override
  String get sharedAlbumSectionDescription =>
      'Create shared and collaborative albums with other Ente users, including users on free plans.';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: 'Shared with $numberOfPeople people',
      one: 'Shared with 1 person',
      zero: 'Share with specific people',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId => 'Dette er dit bekræftelses-ID';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'Someone sharing albums with you should see the same ID on their device.';

  @override
  String get howToViewShareeVerificationID =>
      'Please ask them to long-press their email address on the settings screen, and verify that the IDs on both devices match.';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'This is $email\'s Verification ID';
  }

  @override
  String get verificationId => 'Verification ID';

  @override
  String verifyEmailID({required Object email}) {
    return 'Verify $email';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return '$email does not have an Ente account.\n\nSend them an invite to share photos.';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return 'Here\'s my verification ID: $verificationID for ente.io.';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'Hey, kan du bekræfte, at dette er dit ente.io verifikation ID: $verificationID';
  }

  @override
  String get somethingWentWrong => 'Something went wrong';

  @override
  String get sendInvite => 'Send invite';

  @override
  String get shareTextRecommendUsingEnte =>
      'Download Ente so we can easily share original quality photos and videos\n\nhttps://ente.io';

  @override
  String get done => 'Done';

  @override
  String get applyCodeTitle => 'Apply code';

  @override
  String get enterCodeDescription =>
      'Enter the code provided by your friend to claim free storage for both of you';

  @override
  String get apply => 'Apply';

  @override
  String get failedToApplyCode => 'Failed to apply code';

  @override
  String get enterReferralCode => 'Enter referral code';

  @override
  String get codeAppliedPageTitle => 'Code applied';

  @override
  String get changeYourReferralCode => 'Change your referral code';

  @override
  String get change => 'Change';

  @override
  String get unavailableReferralCode =>
      'Beklager, denne kode er ikke tilgængelig.';

  @override
  String get codeChangeLimitReached =>
      'Sorry, you\'ve reached the limit of code changes.';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'Please contact $familyAdminEmail to change your code.';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB';
  }

  @override
  String get claimed => 'Claimed';

  @override
  String get details => 'Detaljer';

  @override
  String get claimMore => 'Claim more!';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return 'De får også $storageAmountInGB GB';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB hver gang nogen tilmelder sig et betalt abonnement og anvender din kode';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'Ente referral code: $referralCode \n\nApply it in Settings → General → Referrals to get $referralStorageInGB GB free after you signup for a paid plan\n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => 'Claim free storage';

  @override
  String get inviteYourFriends => 'Inviter dine venner';

  @override
  String get failedToFetchReferralDetails =>
      'Unable to fetch referral details. Please try again later.';

  @override
  String get referralStep1 => '1. Give this code to your friends';

  @override
  String get referralStep2 => '2. De tilmelder sig en betalt plan';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. Both of you get $storageInGB GB* free';
  }

  @override
  String get referralsAreCurrentlyPaused => 'Referrals are currently paused';

  @override
  String get youCanAtMaxDoubleYourStorage =>
      '* You can at max double your storage';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true': 'Your family has claimed $storageAmountInGb GB so far',
      'false': 'You have claimed $storageAmountInGb GB so far',
      'other': 'You have claimed $storageAmountInGb GB so far!',
    });
    return '$_temp0';
  }

  @override
  String get faq => 'FAQ';

  @override
  String get help => 'Hjælp';

  @override
  String get oopsSomethingWentWrong => 'Ups, noget gik galt';

  @override
  String get peopleUsingYourCode => 'Personer, der bruger din kode';

  @override
  String get eligible => 'kvalificeret';

  @override
  String get total => 'total';

  @override
  String get codeUsedByYou => 'Code used by you';

  @override
  String get freeStorageClaimed => 'Free storage claimed';

  @override
  String get freeStorageUsable => 'Free storage usable';

  @override
  String get usableReferralStorageInfo =>
      'Usable storage is limited by your current plan. Excess claimed storage will automatically become usable when you upgrade your plan.';

  @override
  String get removeFromAlbumTitle => 'Fjern fra album?';

  @override
  String get removeFromAlbum => 'Fjern fra album';

  @override
  String get itemsWillBeRemovedFromAlbum =>
      'Valgte elementer vil blive fjernet fra dette album';

  @override
  String get removeShareItemsWarning =>
      'Selected photos will not be accessible to any viewer of this album, except the photo owners.';

  @override
  String get addingToFavorites => 'Tilføjer til favoritter...';

  @override
  String get removingFromFavorites => 'Fjerner fra favoritter...';

  @override
  String get sorryCouldNotAddToFavorites =>
      'Beklager, kunne ikke føje til favoritter!';

  @override
  String get sorryCouldNotRemoveFromFavorites =>
      'Beklager, kunne ikke fjernes fra favoritter!';

  @override
  String get subscribeToEnableSharing =>
      'Du skal have et aktivt betalt abonnement for at aktivere deling.';

  @override
  String get subscribe => 'Abonner';

  @override
  String get canOnlyRemoveFilesOwnedByYou => 'Kan kun fjerne filer ejet af dig';

  @override
  String get deleteSharedAlbum => 'Slet delt album?';

  @override
  String get deleteAlbum => 'Slet album';

  @override
  String get deleteAlbumDialog =>
      'Also delete the photos (and videos) present in this album from <bold>all</bold> other albums they are part of?';

  @override
  String get deleteSharedAlbumDialogBody =>
      'The album will be deleted for everyone\n\nYou will lose access to shared photos in this album that are owned by others';

  @override
  String get yesRemove => 'Ja, fjern';

  @override
  String get creatingLink => 'Opretter link...';

  @override
  String get removeWithQuestionMark => 'Fjern?';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return '$userEmail will be removed from this shared album\n\nAny photos added by them will also be removed from the album';
  }

  @override
  String get keepPhotos => 'Behold billeder';

  @override
  String get deletePhotos => 'Delete photos';

  @override
  String get inviteToEnte => 'Invite to Ente';

  @override
  String get removePublicLink => 'Remove public link';

  @override
  String disableLinkMessage({required Object albumName}) {
    return 'This will remove the public link for accessing \"$albumName\".';
  }

  @override
  String get sharing => 'Sharing...';

  @override
  String get youCannotShareWithYourself => 'You cannot share with yourself';

  @override
  String get archive => 'Archive';

  @override
  String get createAlbumActionHint =>
      'Long press to select photos and click + to create an album';

  @override
  String get importing => 'Importing....';

  @override
  String get failedToLoadAlbums => 'Failed to load albums';

  @override
  String get hidden => 'Hidden';

  @override
  String get authToViewYourHiddenFiles =>
      'Please authenticate to view your hidden files';

  @override
  String get authToViewTrashedFiles =>
      'Please authenticate to view your trashed files';

  @override
  String get trash => 'Trash';

  @override
  String get uncategorized => 'Uncategorized';

  @override
  String get videoSmallCase => 'video';

  @override
  String get photoSmallCase => 'photo';

  @override
  String get singleFileDeleteHighlight => 'It will be deleted from all albums.';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return 'This $fileType is in both Ente and your device.';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return 'This $fileType will be deleted from Ente.';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return 'This $fileType will be deleted from your device.';
  }

  @override
  String get deleteFromEnte => 'Delete from Ente';

  @override
  String get yesDelete => 'Yes, delete';

  @override
  String get movedToTrash => 'Moved to trash';

  @override
  String get deleteFromDevice => 'Delete from device';

  @override
  String get deleteFromBoth => 'Delete from both';

  @override
  String get newAlbum => 'Nyt album';

  @override
  String get albums => 'Albums';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount memories',
      one: '$formattedCount memory',
      zero: 'no memories',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return '$count valgt';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return '$count selected ($yourCount yours)';
  }

  @override
  String get advancedSettings => 'Avanceret';

  @override
  String get photoGridSize => 'Photo grid size';

  @override
  String get manageDeviceStorage => 'Manage device cache';

  @override
  String get manageDeviceStorageDesc => 'Gennemgå og ryd lokal cache-lagring.';

  @override
  String get machineLearning => 'Maskinlæring';

  @override
  String get mlConsent => 'Aktiver maskinlæring';

  @override
  String get mlConsentTitle => 'Aktiver maskinlæring?';

  @override
  String get mlConsentDescription =>
      'If you enable machine learning, Ente will extract information like face geometry from files, including those shared with you.\n\nThis will happen on your device, and any generated biometric information will be end-to-end encrypted.';

  @override
  String get mlConsentPrivacy =>
      'Klik her for flere detaljer om denne funktion i vores privatlivspolitik';

  @override
  String get mlConsentConfirmation =>
      'I understand, and wish to enable machine learning';

  @override
  String get magicSearch => 'Magisk søgning';

  @override
  String get discover => 'Discover';

  @override
  String get discover_identity => 'Identitet';

  @override
  String get discover_screenshots => 'Skærmbilleder';

  @override
  String get discover_receipts => 'Receipts';

  @override
  String get discover_notes => 'Noter';

  @override
  String get discover_memes => 'Memes';

  @override
  String get discover_visiting_cards => 'Visiting Cards';

  @override
  String get discover_babies => 'Babies';

  @override
  String get discover_pets => 'Kæledyr';

  @override
  String get discover_selfies => 'Selfier';

  @override
  String get discover_wallpapers => 'Baggrundsbilleder';

  @override
  String get discover_food => 'Mad';

  @override
  String get discover_celebrations => 'Celebrations';

  @override
  String get discover_sunset => 'Solnedgang';

  @override
  String get discover_hills => 'Hills';

  @override
  String get discover_greenery => 'Greenery';

  @override
  String get mlIndexingDescription =>
      'Bemærk venligst, at maskinindlæring vil resultere i en højere båndbredde og batteriforbrug, indtil alle elementer er indekseret. Overvej at bruge desktop app til hurtigere indeksering, vil alle resultater blive synkroniseret automatisk.';

  @override
  String get loadingModel => 'Downloader modeller...';

  @override
  String get waitingForWifi => 'Venter på Wi-fi...';

  @override
  String get status => 'Status';

  @override
  String get indexedItems => 'Indekserede elementer';

  @override
  String get pendingItems => 'Afventende elementer';

  @override
  String get clearIndexes => 'Ryd indekser';

  @override
  String get selectFoldersForBackup => 'Vælg mapper til sikkerhedskopiering';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      'Valgte mapper vil blive krypteret og sikkerhedskopieret';

  @override
  String get unselectAll => 'Fravælg alle';

  @override
  String get selectAll => 'Vælg alle';

  @override
  String get skip => 'Spring over';

  @override
  String get updatingFolderSelection => 'Opdaterer mappevalg...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count items',
      one: '$count item',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Delete $count items',
      one: 'Delete $count item',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count files, $formattedSize each';
  }

  @override
  String get showMemories => 'Vis minder';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count years ago',
      one: '$count year ago',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'Backup settings';

  @override
  String get backupStatus => 'Backup status';

  @override
  String get backupStatusDescription =>
      'Elementer, der er blevet sikkerhedskopieret, vil blive vist her';

  @override
  String get backupOverMobileData => 'Backup over mobile data';

  @override
  String get backupVideos => 'Backup videos';

  @override
  String get disableAutoLock => 'Disable auto lock';

  @override
  String get deviceLockExplanation =>
      'Disable the device screen lock when Ente is in the foreground and there is a backup in progress. This is normally not needed, but may help big uploads and initial imports of large libraries complete faster.';

  @override
  String get about => 'About';

  @override
  String get weAreOpenSource => 'We are open source!';

  @override
  String get privacy => 'Privacy';

  @override
  String get terms => 'Terms';

  @override
  String get checkForUpdates => 'Check for updates';

  @override
  String get checkStatus => 'Check status';

  @override
  String get checking => 'Checking...';

  @override
  String get youAreOnTheLatestVersion => 'You are on the latest version';

  @override
  String get account => 'Account';

  @override
  String get manageSubscription => 'Manage subscription';

  @override
  String get authToChangeYourEmail =>
      'Please authenticate to change your email';

  @override
  String get changePassword => 'Change password';

  @override
  String get authToChangeYourPassword =>
      'Please authenticate to change your password';

  @override
  String get emailVerificationToggle => 'Email verification';

  @override
  String get authToChangeEmailVerificationSetting =>
      'Please authenticate to change email verification';

  @override
  String get exportYourData => 'Export your data';

  @override
  String get logout => 'Logout';

  @override
  String get authToInitiateAccountDeletion =>
      'Please authenticate to initiate account deletion';

  @override
  String get areYouSureYouWantToLogout => 'Are you sure you want to logout?';

  @override
  String get yesLogout => 'Yes, logout';

  @override
  String get aNewVersionOfEnteIsAvailable =>
      'A new version of Ente is available.';

  @override
  String get update => 'Update';

  @override
  String get installManually => 'Install manually';

  @override
  String get criticalUpdateAvailable => 'Critical update available';

  @override
  String get updateAvailable => 'Update available';

  @override
  String get ignoreUpdate => 'Ignore';

  @override
  String get downloading => 'Downloading...';

  @override
  String get cannotDeleteSharedFiles => 'Kan ikke slette delte filer';

  @override
  String get theDownloadCouldNotBeCompleted =>
      'The download could not be completed';

  @override
  String get retry => 'Prøv igen';

  @override
  String get backedUpFolders => 'Sikkerhedskopierede mapper';

  @override
  String get backup => 'Backup';

  @override
  String get freeUpDeviceSpace => 'Frigør enhedsplads';

  @override
  String get freeUpDeviceSpaceDesc =>
      'Spar plads på din enhed ved at rydde filer, der allerede er sikkerhedskopieret.';

  @override
  String get allClear => '✨ All clear';

  @override
  String get noDeviceThatCanBeDeleted =>
      'You\'ve no files on this device that can be deleted';

  @override
  String get removeDuplicates => 'Remove duplicates';

  @override
  String get removeDuplicatesDesc =>
      'Review and remove files that are exact duplicates.';

  @override
  String get viewLargeFiles => 'Large files';

  @override
  String get viewLargeFilesDesc =>
      'View files that are consuming the most amount of storage.';

  @override
  String get noDuplicates => '✨ No duplicates';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared =>
      'You don\'t have any duplicate files that can be cleared';

  @override
  String get success => 'Success';

  @override
  String get rateUs => 'Rate us';

  @override
  String get remindToEmptyDeviceTrash =>
      'Also empty \"Recently Deleted\" from \"Settings\" -> \"Storage\" to claim the freed space';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return 'You have successfully freed up $storageSaved!';
  }

  @override
  String get remindToEmptyEnteTrash =>
      'Also empty your \"Trash\" to claim the freed up space';

  @override
  String get sparkleSuccess => '✨ Success';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count duplicate files',
      one: '$count duplicate file',
    );
    return 'You have cleaned up $_temp0, saving ($storageSaved!)';
  }

  @override
  String get familyPlans => 'Family plans';

  @override
  String get referrals => 'Referrals';

  @override
  String get notifications => 'Notifications';

  @override
  String get sharedPhotoNotifications => 'New shared photos';

  @override
  String get sharedPhotoNotificationsExplanation =>
      'Receive notifications when someone adds a photo to a shared album that you\'re a part of';

  @override
  String get advanced => 'Advanced';

  @override
  String get general => 'General';

  @override
  String get security => 'Security';

  @override
  String get authToViewYourRecoveryKey =>
      'Please authenticate to view your recovery key';

  @override
  String get twofactor => 'Two-factor';

  @override
  String get authToConfigureTwofactorAuthentication =>
      'Please authenticate to configure two-factor authentication';

  @override
  String get lockscreen => 'Lockscreen';

  @override
  String get authToChangeLockscreenSetting =>
      'Please authenticate to change lockscreen setting';

  @override
  String get viewActiveSessions => 'View active sessions';

  @override
  String get authToViewYourActiveSessions =>
      'Please authenticate to view your active sessions';

  @override
  String get disableTwofactor => 'Disable two-factor';

  @override
  String get confirm2FADisable =>
      'Are you sure you want to disable two-factor authentication?';

  @override
  String get no => 'No';

  @override
  String get yes => 'Yes';

  @override
  String get social => 'Social';

  @override
  String rateUsOnStore({required Object storeName}) {
    return 'Rate us on $storeName';
  }

  @override
  String get blog => 'Blog';

  @override
  String get merchandise => 'Merchandise';

  @override
  String get twitter => 'Twitter';

  @override
  String get mastodon => 'Mastodon';

  @override
  String get matrix => 'Matrix';

  @override
  String get discord => 'Discord';

  @override
  String get reddit => 'Reddit';

  @override
  String get yourStorageDetailsCouldNotBeFetched =>
      'Your storage details could not be fetched';

  @override
  String get reportABug => 'Report a bug';

  @override
  String get reportBug => 'Report bug';

  @override
  String get suggestFeatures => 'Suggest features';

  @override
  String get support => 'Support';

  @override
  String get theme => 'Theme';

  @override
  String get lightTheme => 'Light';

  @override
  String get darkTheme => 'Dark';

  @override
  String get systemTheme => 'System';

  @override
  String get freeTrial => 'Free trial';

  @override
  String get selectYourPlan => 'Select your plan';

  @override
  String get enteSubscriptionPitch =>
      'Ente preserves your memories, so they\'re always available to you, even if you lose your device.';

  @override
  String get enteSubscriptionShareWithFamily =>
      'Your family can be added to your plan as well.';

  @override
  String get currentUsageIs => 'Current usage is ';

  @override
  String get faqs => 'FAQs';

  @override
  String renewsOn({required Object endDate}) {
    return 'Subscription renews on $endDate';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return 'Free trial valid till $endDate';
  }

  @override
  String validTill({required Object endDate}) {
    return 'Valid till $endDate';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return 'Your $storageAmount add-on is valid till $endDate';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return 'Free trial valid till $endDate.\nYou can choose a paid plan afterwards.';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'Your subscription will be cancelled on $endDate';
  }

  @override
  String get subscription => 'Subscription';

  @override
  String get paymentDetails => 'Payment details';

  @override
  String get manageFamily => 'Manage Family';

  @override
  String contactToManageSubscription({required Object provider}) {
    return 'Please contact us at support@ente.io to manage your $provider subscription.';
  }

  @override
  String get renewSubscription => 'Renew subscription';

  @override
  String get cancelSubscription => 'Cancel subscription';

  @override
  String get areYouSureYouWantToRenew => 'Are you sure you want to renew?';

  @override
  String get yesRenew => 'Yes, Renew';

  @override
  String get areYouSureYouWantToCancel => 'Are you sure you want to cancel?';

  @override
  String get yesCancel => 'Yes, cancel';

  @override
  String get failedToRenew => 'Failed to renew';

  @override
  String get failedToCancel => 'Failed to cancel';

  @override
  String get twoMonthsFreeOnYearlyPlans => '2 months free on yearly plans';

  @override
  String get monthly => 'Monthly';

  @override
  String get yearly => 'Yearly';

  @override
  String get confirmPlanChange => 'Confirm plan change';

  @override
  String get areYouSureYouWantToChangeYourPlan =>
      'Are you sure you want to change your plan?';

  @override
  String get youCannotDowngradeToThisPlan =>
      'You cannot downgrade to this plan';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'Please cancel your existing subscription from $paymentProvider first';
  }

  @override
  String get optionalAsShortAsYouLike => 'Optional, as short as you like...';

  @override
  String get send => 'Send';

  @override
  String get askCancelReason =>
      'Your subscription was cancelled. Would you like to share the reason?';

  @override
  String get thankYouForSubscribing => 'Thank you for subscribing!';

  @override
  String get yourPurchaseWasSuccessful => 'Your purchase was successful';

  @override
  String get yourPlanWasSuccessfullyUpgraded =>
      'Your plan was successfully upgraded';

  @override
  String get yourPlanWasSuccessfullyDowngraded =>
      'Your plan was successfully downgraded';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully =>
      'Your subscription was updated successfully';

  @override
  String get googlePlayId => 'Google Play ID';

  @override
  String get appleId => 'Apple ID';

  @override
  String get playstoreSubscription => 'PlayStore subscription';

  @override
  String get appstoreSubscription => 'AppStore subscription';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return 'Your $id is already linked to another Ente account.\nIf you would like to use your $id with this account, please contact our support\'\'';
  }

  @override
  String get visitWebToManage =>
      'Please visit web.ente.io to manage your subscription';

  @override
  String get couldNotUpdateSubscription => 'Abonnementet kunne ikke opdateres.';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      'Kontakt support@ente.io og vi vil være glade for at hjælpe!';

  @override
  String get paymentFailed => 'Payment failed';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return 'Please talk to $providerName support if you were charged';
  }

  @override
  String get continueOnFreeTrial => 'Continue on free trial';

  @override
  String get areYouSureYouWantToExit => 'Are you sure you want to exit?';

  @override
  String get thankYou => 'Thank you';

  @override
  String get failedToVerifyPaymentStatus => 'Failed to verify payment status';

  @override
  String get pleaseWaitForSometimeBeforeRetrying =>
      'Please wait for sometime before retrying';

  @override
  String get paymentFailedMessage =>
      'Unfortunately your payment failed. Please contact support and we\'ll help you out!';

  @override
  String get youAreOnAFamilyPlan => 'You are on a family plan!';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'Please contact <green>$familyAdminEmail</green> to manage your subscription';
  }

  @override
  String get leaveFamily => 'Leave family';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily =>
      'Are you sure that you want to leave the family plan?';

  @override
  String get leave => 'Leave';

  @override
  String get rateTheApp => 'Rate the app';

  @override
  String get startBackup => 'Start backup';

  @override
  String get noPhotosAreBeingBackedUpRightNow =>
      'No photos are being backed up right now';

  @override
  String get preserveMore => 'Preserve more';

  @override
  String get grantFullAccessPrompt =>
      'Please allow access to all photos in the Settings app';

  @override
  String get allowPermTitle => 'Allow access to photos';

  @override
  String get allowPermBody =>
      'Please allow access to your photos from Settings so Ente can display and backup your library.';

  @override
  String get openSettings => 'Open Settings';

  @override
  String get selectMorePhotos => 'Select more photos';

  @override
  String get existingUser => 'Existing user';

  @override
  String get privateBackups => 'Private backups';

  @override
  String get forYourMemories => 'for your memories';

  @override
  String get endtoendEncryptedByDefault => 'End-to-end encrypted by default';

  @override
  String get safelyStored => 'Safely stored';

  @override
  String get atAFalloutShelter => 'at a fallout shelter';

  @override
  String get designedToOutlive => 'Designed to outlive';

  @override
  String get available => 'Available';

  @override
  String get everywhere => 'everywhere';

  @override
  String get androidIosWebDesktop => 'Android, iOS, Web, Desktop';

  @override
  String get mobileWebDesktop => 'Mobile, Web, Desktop';

  @override
  String get newToEnte => 'New to Ente';

  @override
  String get pleaseLoginAgain => 'Please login again';

  @override
  String get autoLogoutMessage =>
      'Due to technical glitch, you have been logged out. Our apologies for the inconvenience.';

  @override
  String get yourSubscriptionHasExpired => 'Your subscription has expired';

  @override
  String get storageLimitExceeded => 'Storage limit exceeded';

  @override
  String get upgrade => 'Upgrade';

  @override
  String get raiseTicket => 'Raise ticket';

  @override
  String get backupFailed => 'Backup failed';

  @override
  String get sorryBackupFailedDesc =>
      'Sorry, we could not backup this file right now, we will retry later.';

  @override
  String get couldNotBackUpTryLater =>
      'We could not backup your data.\nWe will retry later.';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      'Ente can encrypt and preserve files only if you grant access to them';

  @override
  String get pleaseGrantPermissions => 'Please grant permissions';

  @override
  String get grantPermission => 'Grant permission';

  @override
  String get privateSharing => 'Private sharing';

  @override
  String get shareOnlyWithThePeopleYouWant =>
      'Share only with the people you want';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      'Use public links for people not on Ente';

  @override
  String get allowPeopleToAddPhotos => 'Allow people to add photos';

  @override
  String get shareAnAlbumNow => 'Share an album now';

  @override
  String get collectEventPhotos => 'Collect event photos';

  @override
  String get sessionExpired => 'Session expired';

  @override
  String get loggingOut => 'Logger ud...';

  @override
  String get onDevice => 'On device';

  @override
  String get onEnte => 'On <branding>ente</branding>';

  @override
  String get name => 'Name';

  @override
  String get newest => 'Newest';

  @override
  String get lastUpdated => 'Last updated';

  @override
  String get deleteEmptyAlbums => 'Delete empty albums';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => 'Delete empty albums?';

  @override
  String get deleteAlbumsDialogBody =>
      'This will delete all empty albums. This is useful when you want to reduce the clutter in your album list.';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return 'Deleting $currentlyDeleting / $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return 'Processing $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => 'Permanently delete';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou =>
      'Can only create link for files owned by you';

  @override
  String get publicLinkCreated => 'Public link created';

  @override
  String get youCanManageYourLinksInTheShareTab =>
      'You can manage your links in the share tab.';

  @override
  String get linkCopiedToClipboard => 'Link copied to clipboard';

  @override
  String get restore => 'Restore';

  @override
  String get moveToAlbum => 'Move to album';

  @override
  String get unhide => 'Unhide';

  @override
  String get unarchive => 'Unarchive';

  @override
  String get favorite => 'Favorite';

  @override
  String get removeFromFavorite => 'Remove from favorites';

  @override
  String get shareLink => 'Share link';

  @override
  String get createCollage => 'Create collage';

  @override
  String get saveCollage => 'Save collage';

  @override
  String get collageSaved => 'Collage saved to gallery';

  @override
  String get collageLayout => 'Layout';

  @override
  String get addToEnte => 'Add to Ente';

  @override
  String get addToAlbum => 'Add to album';

  @override
  String get delete => 'Delete';

  @override
  String get hide => 'Hide';

  @override
  String get share => 'Share';

  @override
  String get unhideToAlbum => 'Unhide to album';

  @override
  String get restoreToAlbum => 'Restore to album';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Move items',
      one: 'Move item',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add items',
      one: 'Add item',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'Create or select album';

  @override
  String get selectAlbum => 'Select album';

  @override
  String get searchByAlbumNameHint => 'Album name';

  @override
  String get albumTitle => 'Album title';

  @override
  String get enterAlbumName => 'Enter album name';

  @override
  String get restoringFiles => 'Restoring files...';

  @override
  String get movingFilesToAlbum => 'Moving files to album...';

  @override
  String get unhidingFilesToAlbum => 'Unhiding files to album';

  @override
  String get canNotUploadToAlbumsOwnedByOthers =>
      'Can not upload to albums owned by others';

  @override
  String get uploadingFilesToAlbum => 'Uploading files to album...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return 'Added successfully to  $albumName';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return 'Moved successfully to $albumName';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'This album already has a collaborative link';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return 'Collaborative link created for $albumName';
  }

  @override
  String get askYourLovedOnesToShare => 'Ask your loved ones to share';

  @override
  String get invite => 'Inviter';

  @override
  String get shareYourFirstAlbum => 'Share your first album';

  @override
  String sharedWith({required Object emailIDs}) {
    return 'Shared with $emailIDs';
  }

  @override
  String get sharedWithMe => 'Shared with me';

  @override
  String get sharedByMe => 'Shared by me';

  @override
  String get doubleYourStorage => 'Double your storage';

  @override
  String get referFriendsAnd2xYourPlan => 'Refer friends and 2x your plan';

  @override
  String get shareAlbumHint =>
      'Open an album and tap the share button on the top right to share.';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      'Items show the number of days remaining before permanent deletion';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count days',
      one: '1 day',
      zero: 'Soon',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => 'Delete All';

  @override
  String get renameAlbum => 'Rename album';

  @override
  String get convertToAlbum => 'Convert to album';

  @override
  String get setCover => 'Set cover';

  @override
  String get sortAlbumsBy => 'Sort by';

  @override
  String get sortNewestFirst => 'Newest first';

  @override
  String get sortOldestFirst => 'Oldest first';

  @override
  String get rename => 'Rename';

  @override
  String get leaveSharedAlbum => 'Leave shared album?';

  @override
  String get leaveAlbum => 'Leave album';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'Photos added by you will be removed from the album';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted =>
      'You\'ve no files in this album that can be deleted';

  @override
  String get youDontHaveAnyArchivedItems =>
      'You don\'t have any archived items.';

  @override
  String get ignoredFolderUploadReason =>
      'Some files in this album are ignored from upload because they had previously been deleted from Ente.';

  @override
  String get resetIgnoredFiles => 'Reset ignored files';

  @override
  String get deviceFilesAutoUploading =>
      'Files added to this device album will automatically get uploaded to Ente.';

  @override
  String get turnOnBackupForAutoUpload =>
      'Turn on backup to automatically upload files added to this device folder to Ente.';

  @override
  String get noHiddenPhotosOrVideos => 'No hidden photos or videos';

  @override
  String get toHideAPhotoOrVideo => 'To hide a photo or video';

  @override
  String get openTheItem => '• Open the item';

  @override
  String get clickOnTheOverflowMenu => '• Click on the overflow menu';

  @override
  String get click => '• Click';

  @override
  String get nothingToSeeHere => 'Nothing to see here! 👀';

  @override
  String get unarchiveAlbum => 'Unarchive album';

  @override
  String get archiveAlbum => 'Archive album';

  @override
  String get calculating => 'Calculating...';

  @override
  String get pleaseWaitDeletingAlbum => 'Please wait, deleting album';

  @override
  String get searchByExamples =>
      '• Album names (e.g. \"Camera\")\n• Types of files (e.g. \"Videos\", \".gif\")\n• Years and months (e.g. \"2022\", \"January\")\n• Holidays (e.g. \"Christmas\")\n• Photo descriptions (e.g. “#fun”)';

  @override
  String get youCanTrySearchingForADifferentQuery =>
      'You can try searching for a different query.';

  @override
  String get noResultsFound => 'No results found';

  @override
  String addedBy({required Object emailOrName}) {
    return 'Added by $emailOrName';
  }

  @override
  String get loadingExifData => 'Loading EXIF data...';

  @override
  String get viewAllExifData => 'View all EXIF data';

  @override
  String get noExifData => 'No EXIF data';

  @override
  String get thisImageHasNoExifData => 'This image has no exif data';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => 'No results';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'We don\'t support editing photos and albums that you don\'t own yet';

  @override
  String get failedToFetchOriginalForEdit =>
      'Failed to fetch original for edit';

  @override
  String get close => 'Close';

  @override
  String get setAs => 'Set as';

  @override
  String get fileSavedToGallery => 'Fil gemt i galleri';

  @override
  String get filesSavedToGallery => 'Files saved to gallery';

  @override
  String get fileFailedToSaveToGallery => 'Failed to save file to gallery';

  @override
  String get download => 'Download';

  @override
  String get pressAndHoldToPlayVideo => 'Press and hold to play video';

  @override
  String get pressAndHoldToPlayVideoDetailed =>
      'Press and hold on the image to  play video';

  @override
  String get downloadFailed => 'Download failed';

  @override
  String get deduplicateFiles => 'Deduplicate Files';

  @override
  String get deselectAll => 'Deselect all';

  @override
  String get reviewDeduplicateItems =>
      'Please review and delete the items you believe are duplicates.';

  @override
  String get clubByCaptureTime => 'Club by capture time';

  @override
  String get clubByFileName => 'Club by file name';

  @override
  String get count => 'Count';

  @override
  String get totalSize => 'Total size';

  @override
  String get longpressOnAnItemToViewInFullscreen =>
      'Long-press on an item to view in full-screen';

  @override
  String get decryptingVideo => 'Decrypting video...';

  @override
  String get authToViewYourMemories =>
      'Please authenticate to view your memories';

  @override
  String get unlock => 'Unlock';

  @override
  String get freeUpSpace => 'Free up space';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'They can be deleted from the device to free up $formattedSize',
      one: 'It can be deleted from the device to free up $formattedSize',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber files',
      one: '1 file',
    );
    return '$_temp0 in this album has been backed up safely';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber files',
      one: '1 file',
    );
    return '$_temp0 on this device have been backed up safely';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'them',
      one: 'it',
    );
    return 'You can still access $_temp0 on Ente as long as you have an active subscription';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return 'Free up $sizeInMBorGB';
  }

  @override
  String get thisEmailIsAlreadyInUse => 'This email is already in use';

  @override
  String get incorrectCode => 'Incorrect code';

  @override
  String get authenticationFailedPleaseTryAgain =>
      'Authentication failed, please try again';

  @override
  String get verificationFailedPleaseTryAgain =>
      'Verification failed, please try again';

  @override
  String get authenticating => 'Authenticating...';

  @override
  String get authenticationSuccessful => 'Authentication successful!';

  @override
  String get incorrectRecoveryKey => 'Incorrect recovery key';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect =>
      'The recovery key you entered is incorrect';

  @override
  String get twofactorAuthenticationSuccessfullyReset =>
      'Two-factor authentication successfully reset';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered =>
      'Please verify the code you have entered';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      'Please contact support if the problem persists';

  @override
  String get twofactorAuthenticationHasBeenDisabled =>
      'Two-factor authentication has been disabled';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect =>
      'Sorry, the code you\'ve entered is incorrect';

  @override
  String get yourVerificationCodeHasExpired =>
      'Your verification code has expired';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'Email changed to $newEmail';
  }

  @override
  String get verifying => 'Verifying...';

  @override
  String get disablingTwofactorAuthentication =>
      'Disabling two-factor authentication...';

  @override
  String get allMemoriesPreserved => 'All memories preserved';

  @override
  String get loadingGallery => 'Loading gallery...';

  @override
  String get syncing => 'Syncing...';

  @override
  String get encryptingBackup => 'Encrypting backup...';

  @override
  String get syncStopped => 'Sync stopped';

  @override
  String syncProgress({required String completed, required String total}) {
    return '$completed/$total memories preserved';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return 'Preserving $count memories...';
  }

  @override
  String get uploadingSingleMemory => 'Preserving 1 memory...';

  @override
  String get archiving => 'Archiving...';

  @override
  String get unarchiving => 'Unarchiving...';

  @override
  String get successfullyArchived => 'Successfully archived';

  @override
  String get successfullyUnarchived => 'Successfully unarchived';

  @override
  String get renameFile => 'Omdøb fil';

  @override
  String get enterFileName => 'Enter file name';

  @override
  String get filesDeleted => 'Files deleted';

  @override
  String get selectedFilesAreNotOnEnte => 'Selected files are not on Ente';

  @override
  String get thisActionCannotBeUndone => 'This action cannot be undone';

  @override
  String get emptyTrash => 'Empty trash?';

  @override
  String get permDeleteWarning =>
      'All items in trash will be permanently deleted\n\nThis action cannot be undone';

  @override
  String get empty => 'Empty';

  @override
  String get couldNotFreeUpSpace => 'Could not free up space';

  @override
  String get permanentlyDeleteFromDevice => 'Permanently delete from device?';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      'Some of the files you are trying to delete are only available on your device and cannot be recovered if deleted';

  @override
  String get theyWillBeDeletedFromAllAlbums =>
      'They will be deleted from all albums.';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'Some items are in both Ente and your device.';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      'Selected items will be deleted from all albums and moved to trash.';

  @override
  String get theseItemsWillBeDeletedFromYourDevice =>
      'These items will be deleted from your device.';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      'It looks like something went wrong. Please retry after some time. If the error persists, please contact our support team.';

  @override
  String get error => 'Error';

  @override
  String get tempErrorContactSupportIfPersists =>
      'It looks like something went wrong. Please retry after some time. If the error persists, please contact our support team.';

  @override
  String get networkHostLookUpErr =>
      'Unable to connect to Ente, please check your network settings and contact support if the error persists.';

  @override
  String get networkConnectionRefusedErr =>
      'Unable to connect to Ente, please retry after sometime. If the error persists, please contact support.';

  @override
  String get cachedData => 'Cached data';

  @override
  String get clearCaches => 'Clear caches';

  @override
  String get remoteImages => 'Remote images';

  @override
  String get remoteVideos => 'Remote videos';

  @override
  String get remoteThumbnails => 'Remote thumbnails';

  @override
  String get pendingSync => 'Pending sync';

  @override
  String get localGallery => 'Local gallery';

  @override
  String get todaysLogs => 'Today\'s logs';

  @override
  String get viewLogs => 'View logs';

  @override
  String get logsDialogBody =>
      'This will send across logs to help us debug your issue. Please note that file names will be included to help track issues with specific files.';

  @override
  String get preparingLogs => 'Preparing logs...';

  @override
  String get emailYourLogs => 'Email your logs';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'Please send the logs to \n$toEmail';
  }

  @override
  String get copyEmailAddress => 'Copy email address';

  @override
  String get exportLogs => 'Export logs';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return 'Please email us at $toEmail';
  }

  @override
  String get dismiss => 'Dismiss';

  @override
  String get didYouKnow => 'Did you know?';

  @override
  String get loadingMessage => 'Loading your photos...';

  @override
  String get loadMessage1 => 'You can share your subscription with your family';

  @override
  String get loadMessage2 =>
      'We have preserved over 200 million memories so far';

  @override
  String get loadMessage3 =>
      'We keep 3 copies of your data, one in an underground fallout shelter';

  @override
  String get loadMessage4 => 'All our apps are open source';

  @override
  String get loadMessage5 =>
      'Our source code and cryptography have been externally audited';

  @override
  String get loadMessage6 =>
      'You can share links to your albums with your loved ones';

  @override
  String get loadMessage7 =>
      'Our mobile apps run in the background to encrypt and backup any new photos you click';

  @override
  String get loadMessage8 => 'web.ente.io has a slick uploader';

  @override
  String get loadMessage9 =>
      'We use Xchacha20Poly1305 to safely encrypt your data';

  @override
  String get photoDescriptions => 'Photo descriptions';

  @override
  String get fileTypesAndNames => 'File types and names';

  @override
  String get location => 'Location';

  @override
  String get moments => 'Øjeblikke';

  @override
  String get searchFaceEmptySection =>
      'People will be shown here once indexing is done';

  @override
  String get searchDatesEmptySection => 'Search by a date, month or year';

  @override
  String get searchLocationEmptySection =>
      'Group photos that are taken within some radius of a photo';

  @override
  String get searchPeopleEmptySection =>
      'Invite people, and you\'ll see all photos shared by them here';

  @override
  String get searchAlbumsEmptySection => 'Albums';

  @override
  String get searchFileTypesAndNamesEmptySection => 'File types and names';

  @override
  String get searchCaptionEmptySection =>
      'Add descriptions like \"#trip\" in photo info to quickly find them here';

  @override
  String get language => 'Language';

  @override
  String get selectLanguage => 'Select Language';

  @override
  String get locationName => 'Location name';

  @override
  String get addLocation => 'Add location';

  @override
  String get groupNearbyPhotos => 'Group nearby photos';

  @override
  String get kiloMeterUnit => 'km';

  @override
  String get addLocationButton => 'Add';

  @override
  String get radius => 'Radius';

  @override
  String get locationTagFeatureDescription =>
      'A location tag groups all photos that were taken within some radius of a photo';

  @override
  String get galleryMemoryLimitInfo => 'Up to 1000 memories shown in gallery';

  @override
  String get save => 'Save';

  @override
  String get centerPoint => 'Center point';

  @override
  String get pickCenterPoint => 'Pick center point';

  @override
  String get useSelectedPhoto => 'Use selected photo';

  @override
  String get resetToDefault => 'Reset to default';

  @override
  String get edit => 'Edit';

  @override
  String get deleteLocation => 'Delete location';

  @override
  String get rotateLeft => 'Rotate left';

  @override
  String get flip => 'Flip';

  @override
  String get rotateRight => 'Rotate right';

  @override
  String get saveCopy => 'Save copy';

  @override
  String get light => 'Light';

  @override
  String get color => 'Color';

  @override
  String get yesDiscardChanges => 'Yes, discard changes';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade =>
      'Do you want to discard the edits you have made?';

  @override
  String get saving => 'Saving...';

  @override
  String get editsSaved => 'Edits saved';

  @override
  String get oopsCouldNotSaveEdits => 'Oops, could not save edits';

  @override
  String get distanceInKMUnit => 'km';

  @override
  String get dayToday => 'Today';

  @override
  String get dayYesterday => 'Yesterday';

  @override
  String get storage => 'Storage';

  @override
  String get usedSpace => 'Used space';

  @override
  String get storageBreakupFamily => 'Family';

  @override
  String get storageBreakupYou => 'You';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return '$usedAmount $usedStorageUnit of $totalAmount $totalStorageUnit used';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return '$freeAmount $storageUnit free';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'Version: $versionValue';
  }

  @override
  String get verifyIDLabel => 'Verify';

  @override
  String get fileInfoAddDescHint => 'Add a description...';

  @override
  String get editLocationTagTitle => 'Edit location';

  @override
  String get setLabel => 'Set';

  @override
  String get setRadius => 'Set radius';

  @override
  String get familyPlanPortalTitle => 'Familie';

  @override
  String get familyPlanOverview =>
      'Add 5 family members to your existing plan without paying extra.\n\nEach member gets their own private space, and cannot see each other\'s files unless they\'re shared.\n\nFamily plans are available to customers who have a paid Ente subscription.\n\nSubscribe now to get started!';

  @override
  String get androidBiometricHint => 'Verify identity';

  @override
  String get androidBiometricNotRecognized => 'Not recognized. Try again.';

  @override
  String get androidBiometricSuccess => 'Success';

  @override
  String get androidCancelButton => 'Cancel';

  @override
  String get androidSignInTitle => 'Authentication required';

  @override
  String get androidBiometricRequiredTitle => 'Biometric required';

  @override
  String get androidDeviceCredentialsRequiredTitle =>
      'Device credentials required';

  @override
  String get androidDeviceCredentialsSetupDescription =>
      'Device credentials required';

  @override
  String get goToSettings => 'Go to settings';

  @override
  String get androidGoToSettingsDescription =>
      'Biometric authentication is not set up on your device. Go to \'Settings > Security\' to add biometric authentication.';

  @override
  String get iOSLockOut =>
      'Biometric authentication is disabled. Please lock and unlock your screen to enable it.';

  @override
  String get iOSGoToSettingsDescription =>
      'Biometric authentication is not set up on your device. Please either enable Touch ID or Face ID on your phone.';

  @override
  String get iOSOkButton => 'OK';

  @override
  String get openstreetmapContributors => 'OpenStreetMap contributors';

  @override
  String get hostedAtOsmFrance => 'Hosted at OSM France';

  @override
  String get map => 'Map';

  @override
  String get maps => 'Maps';

  @override
  String get mapsPrivacyNotice =>
      'Approximate coordinates will be sent to privacy conscious third parties like OpenStreetMap to show the map and location.';

  @override
  String get enableMaps => 'Enable Maps';

  @override
  String get quickLinks => 'Quick links';

  @override
  String get selectItemsToAdd => 'Select items to add';

  @override
  String get addSelected => 'Add selected';

  @override
  String get addFromDevice => 'Add from device';

  @override
  String get addPhotos => 'Add photos';

  @override
  String get noPhotosFoundHere => 'No photos found here';

  @override
  String get zoomOutToSeePhotos => 'Zoom out to see photos';

  @override
  String get noImagesWithLocation => 'No images with location';

  @override
  String get unpinAlbum => 'Unpin album';

  @override
  String get pinAlbum => 'Pin album';

  @override
  String get pin => 'Pin';

  @override
  String get pinPerson => 'Pin person';

  @override
  String get pinToTop => 'Pin to top';

  @override
  String get unpin => 'Unpin';

  @override
  String get unpinPerson => 'Unpin person';

  @override
  String get visibility => 'Visibility';

  @override
  String get hideFromMemories => 'Hide from memories';

  @override
  String get showInMemories => 'Show in memories';

  @override
  String get create => 'Create';

  @override
  String get viewAll => 'View all';

  @override
  String get nothingSharedWithYouYet => 'Nothing shared with you yet';

  @override
  String get noAlbumsSharedByYouYet => 'No albums shared by you yet';

  @override
  String get sharedWithYou => 'Shared with you';

  @override
  String get sharedByYou => 'Shared by you';

  @override
  String get inviteYourFriendsToEnte => 'Invite your friends to Ente';

  @override
  String get failedToDownloadVideo => 'Failed to download video';

  @override
  String get hiding => 'Hiding...';

  @override
  String get unhiding => 'Unhiding...';

  @override
  String get successfullyHid => 'Successfully hid';

  @override
  String get successfullyUnhid => 'Successfully unhid';

  @override
  String get crashReporting => 'Crash reporting';

  @override
  String get resumableUploads => 'Resumable uploads';

  @override
  String get addToHiddenAlbum => 'Add to hidden album';

  @override
  String get moveToHiddenAlbum => 'Move to hidden album';

  @override
  String get fileTypes => 'File types';

  @override
  String get deleteConfirmDialogBody =>
      'This account is linked to other Ente apps, if you use any. Your uploaded data, across all Ente apps, will be scheduled for deletion, and your account will be permanently deleted.';

  @override
  String get hearUsWhereTitle => 'How did you hear about Ente? (optional)';

  @override
  String get hearUsExplanation =>
      'We don\'t track app installs. It\'d help if you told us where you found us!';

  @override
  String get viewAddOnButton => 'Vis tilføjelser';

  @override
  String get addOns => 'Add-ons';

  @override
  String get addOnPageSubtitle => 'Oplysninger om tilføjelser';

  @override
  String get yourMap => 'Your map';

  @override
  String get modifyYourQueryOrTrySearchingFor =>
      'Modify your query, or try searching for';

  @override
  String get blackFridaySale => 'Black Friday Sale';

  @override
  String get upto50OffUntil4thDec => 'Upto 50% off, until 4th Dec.';

  @override
  String get photos => 'Photos';

  @override
  String get videos => 'Videos';

  @override
  String get livePhotos => 'Live Photos';

  @override
  String get searchHint1 => 'Hurtig, søgning på enheden';

  @override
  String get searchHint2 => 'Photo dates, descriptions';

  @override
  String get searchHint3 => 'Albums, file names, and types';

  @override
  String get searchHint4 => 'Location';

  @override
  String get searchHint5 => 'Coming soon: Faces & magic search ✨';

  @override
  String get addYourPhotosNow => 'Add your photos now';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count results found',
      one: '$count result found',
    );
    return '$_temp0';
  }

  @override
  String get faces => 'Faces';

  @override
  String get people => 'People';

  @override
  String get contents => 'Contents';

  @override
  String get addNew => 'Add new';

  @override
  String get contacts => 'Contacts';

  @override
  String get noInternetConnection => 'No internet connection';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'Please check your internet connection and try again.';

  @override
  String get signOutFromOtherDevices => 'Sign out from other devices';

  @override
  String get signOutOtherBody =>
      'If you think someone might know your password, you can force all other devices using your account to sign out.';

  @override
  String get signOutOtherDevices => 'Sign out other devices';

  @override
  String get doNotSignOut => 'Do not sign out';

  @override
  String get editLocation => 'Edit location';

  @override
  String get selectALocation => 'Select a location';

  @override
  String get selectALocationFirst => 'Select a location first';

  @override
  String get changeLocationOfSelectedItems =>
      'Change location of selected items?';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte =>
      'Edits to location will only be seen within Ente';

  @override
  String get cleanUncategorized => 'Clean Uncategorized';

  @override
  String get cleanUncategorizedDescription =>
      'Remove all files from Uncategorized that are present in other albums';

  @override
  String get waitingForVerification => 'Waiting for verification...';

  @override
  String get passkey => 'Passkey';

  @override
  String get passkeyAuthTitle => 'Passkey verification';

  @override
  String get loginWithTOTP => 'Login with TOTP';

  @override
  String get passKeyPendingVerification => 'Verification is still pending';

  @override
  String get loginSessionExpired => 'Session expired';

  @override
  String get loginSessionExpiredDetails =>
      'Your session has expired. Please login again.';

  @override
  String get verifyPasskey => 'Verify passkey';

  @override
  String get playOnTv => 'Play album on TV';

  @override
  String get pair => 'Pair';

  @override
  String get deviceNotFound => 'Device not found';

  @override
  String get castInstruction =>
      'Visit cast.ente.io on the device you want to pair.\n\nEnter the code below to play the album on your TV.';

  @override
  String get deviceCodeHint => 'Enter the code';

  @override
  String get joinDiscord => 'Join Discord';

  @override
  String get locations => 'Locations';

  @override
  String get addAName => 'Add a name';

  @override
  String get findThemQuickly => 'Find them quickly';

  @override
  String get findPeopleByName => 'Find folk hurtigt ved navn';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add viewers',
      one: 'Add viewer',
      zero: 'Add viewer',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add collaborators',
      one: 'Add collaborator',
      zero: 'Add collaborator',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      'Langt tryk på en e-mail for at bekræfte slutningen af krypteringen.';

  @override
  String get developerSettingsWarning =>
      'Er du sikker på, at du vil ændre udviklerindstillingerne?';

  @override
  String get developerSettings => 'Developer settings';

  @override
  String get serverEndpoint => 'Server endpoint';

  @override
  String get invalidEndpoint => 'Invalid endpoint';

  @override
  String get invalidEndpointMessage =>
      'Sorry, the endpoint you entered is invalid. Please enter a valid endpoint and try again.';

  @override
  String get endpointUpdatedMessage => 'Endpoint updated successfully';

  @override
  String customEndpoint({required Object endpoint}) {
    return 'Connected to $endpoint';
  }

  @override
  String get createCollaborativeLink => 'Create collaborative link';

  @override
  String get search => 'Search';

  @override
  String get enterPersonName => 'Enter person name';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'This email is already linked to $name.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return 'View $name to unlink';
  }

  @override
  String get enterName => 'Enter name';

  @override
  String get savePerson => 'Save person';

  @override
  String get editPerson => 'Edit person';

  @override
  String get mergedPhotos => 'Merged photos';

  @override
  String get orMergeWithExistingPerson => 'Or merge with existing';

  @override
  String get enterDateOfBirth => 'Birthday (optional)';

  @override
  String get birthday => 'Birthday';

  @override
  String get removePersonLabel => 'Remove person label';

  @override
  String get autoPairDesc =>
      'Auto pair works only with devices that support Chromecast.';

  @override
  String get manualPairDesc =>
      'Pair with PIN works with any screen you wish to view your album on.';

  @override
  String get connectToDevice => 'Connect to device';

  @override
  String get autoCastDialogBody => 'You\'ll see available Cast devices here.';

  @override
  String get autoCastiOSPermission =>
      'Make sure Local Network permissions are turned on for the Ente Photos app, in Settings.';

  @override
  String get noDeviceFound => 'No device found';

  @override
  String get stopCastingTitle => 'Stop casting';

  @override
  String get stopCastingBody => 'Do you want to stop casting?';

  @override
  String get castIPMismatchTitle => 'Failed to cast album';

  @override
  String get castIPMismatchBody =>
      'Please make sure you are on the same network as the TV.';

  @override
  String get pairingComplete => 'Pairing complete';

  @override
  String get savingEdits => 'Saving edits...';

  @override
  String get autoPair => 'Auto pair';

  @override
  String get pairWithPin => 'Pair with PIN';

  @override
  String get faceRecognition => 'Face recognition';

  @override
  String get foundFaces => 'Found faces';

  @override
  String get clusteringProgress => 'Clustering progress';

  @override
  String get trim => 'Trim';

  @override
  String get crop => 'Crop';

  @override
  String get rotate => 'Rotate';

  @override
  String get left => 'Left';

  @override
  String get right => 'Right';

  @override
  String get whatsNew => 'What\'s new';

  @override
  String get reviewSuggestions => 'Review suggestions';

  @override
  String get review => 'Review';

  @override
  String get useAsCover => 'Use as cover';

  @override
  String notPersonLabel({required String name}) {
    return 'Not $name?';
  }

  @override
  String get enable => 'Enable';

  @override
  String get enabled => 'Enabled';

  @override
  String get moreDetails => 'More details';

  @override
  String get enableMLIndexingDesc =>
      'Ente supports on-device machine learning for face recognition, magic search and other advanced search features';

  @override
  String get magicSearchHint =>
      'Magic search allows to search photos by their contents, e.g. \'flower\', \'red car\', \'identity documents\'';

  @override
  String get panorama => 'Panorama';

  @override
  String get reenterPassword => 'Re-enter password';

  @override
  String get reenterPin => 'Re-enter PIN';

  @override
  String get deviceLock => 'Device lock';

  @override
  String get pinLock => 'PIN lock';

  @override
  String get next => 'Næste';

  @override
  String get setNewPassword => 'Set new password';

  @override
  String get enterPin => 'Indtast PIN';

  @override
  String get setNewPin => 'Set new PIN';

  @override
  String get appLock => 'App lock';

  @override
  String get noSystemLockFound => 'No system lock found';

  @override
  String get tapToUnlock => 'Tap to unlock';

  @override
  String get tooManyIncorrectAttempts => 'Too many incorrect attempts';

  @override
  String get videoInfo => 'Video Info';

  @override
  String get autoLock => 'Auto lock';

  @override
  String get immediately => 'Immediately';

  @override
  String get autoLockFeatureDescription =>
      'Time after which the app locks after being put in the background';

  @override
  String get hideContent => 'Hide content';

  @override
  String get hideContentDescriptionAndroid =>
      'Hides app content in the app switcher and disables screenshots';

  @override
  String get hideContentDescriptionIos =>
      'Hides app content in the app switcher';

  @override
  String get passwordStrengthInfo =>
      'Password strength is calculated considering the length of the password, used characters, and whether or not the password appears in the top 10,000 most used passwords';

  @override
  String get noQuickLinksSelected => 'No quick links selected';

  @override
  String get pleaseSelectQuickLinksToRemove =>
      'Please select quick links to remove';

  @override
  String get removePublicLinks => 'Remove public links';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      'This will remove public links of all selected quick links.';

  @override
  String get guestView => 'Guest view';

  @override
  String get guestViewEnablePreSteps =>
      'To enable guest view, please setup device passcode or screen lock in your system settings.';

  @override
  String get nameTheAlbum => 'Name the album';

  @override
  String get collectPhotosDescription =>
      'Create a link where your friends can upload photos in original quality.';

  @override
  String get collect => 'Collect';

  @override
  String get appLockDescriptions =>
      'Choose between your device\'s default lock screen and a custom lock screen with a PIN or password.';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'To enable app lock, please setup device passcode or screen lock in your system settings.';

  @override
  String get authToViewPasskey => 'Please authenticate to view your passkey';

  @override
  String get loopVideoOn => 'Disable looping';

  @override
  String get loopVideoOff => 'Enable looping';

  @override
  String get localSyncErrorMessage =>
      'Looks like something went wrong since local photos sync is taking more time than expected. Please reach out to our support team';

  @override
  String get showPerson => 'Show person';

  @override
  String get sort => 'Sort';

  @override
  String get mostRecent => 'Most recent';

  @override
  String get mostRelevant => 'Most relevant';

  @override
  String get loadingYourPhotos => 'Loading your photos...';

  @override
  String processingImport({required Object folderName}) {
    return 'Processing $folderName...';
  }

  @override
  String get personName => 'Person name';

  @override
  String get addNewPerson => 'Add new person';

  @override
  String get addNameOrMerge => 'Add name or merge';

  @override
  String get mergeWithExisting => 'Merge with existing';

  @override
  String get newPerson => 'New person';

  @override
  String get addName => 'Add name';

  @override
  String get add => 'Add';

  @override
  String extraPhotosFoundFor({required String text}) {
    return 'Extra photos found for $text';
  }

  @override
  String get extraPhotosFound => 'Extra photos found';

  @override
  String get configuration => 'Configuration';

  @override
  String get localIndexing => 'Local indexing';

  @override
  String get processed => 'Processed';

  @override
  String get resetPerson => 'Remove';

  @override
  String get areYouSureYouWantToResetThisPerson =>
      'Are you sure you want to reset this person?';

  @override
  String get allPersonGroupingWillReset =>
      'All groupings for this person will be reset, and you will lose all suggestions made for this person';

  @override
  String get yesResetPerson => 'Yes, reset person';

  @override
  String get onlyThem => 'Only them';

  @override
  String get checkingModels => 'Checking models...';

  @override
  String get enableMachineLearningBanner =>
      'Enable machine learning for magic search and face recognition';

  @override
  String get searchDiscoverEmptySection =>
      'Images will be shown here once processing and syncing is complete';

  @override
  String get searchPersonsEmptySection =>
      'People will be shown here once processing and syncing is complete';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count viewers',
      one: 'Added 1 viewer',
      zero: 'Added 0 viewers',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added $count collaborators',
      one: 'Added 1 collaborator',
      zero: 'Added 0 collaborator',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured => 'Account is already configured.';

  @override
  String get sessionIdMismatch => 'Session ID mismatch';

  @override
  String get failedToFetchActiveSessions => 'Failed to fetch active sessions';

  @override
  String get failedToRefreshStripeSubscription =>
      'Failed to refresh subscription';

  @override
  String get failedToPlayVideo => 'Failed to play video';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return 'Upload is ignored due to $ignoreReason';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'Type of gallery $galleryType is not supported for rename';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'Tap to upload, upload is currently ignored due to $ignoreReason';
  }

  @override
  String get tapToUpload => 'Tap to upload';

  @override
  String get info => 'Info';

  @override
  String get addFiles => 'Add Files';

  @override
  String get castAlbum => 'Cast album';

  @override
  String get imageNotAnalyzed => 'Image not analyzed';

  @override
  String get noFacesFound => 'No faces found';

  @override
  String get fileNotUploadedYet => 'File not uploaded yet';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return 'No suggestions for $personName';
  }

  @override
  String get month => 'month';

  @override
  String get yearShort => 'yr';

  @override
  String get currentlyRunning => 'currently running';

  @override
  String get ignored => 'ignored';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count photos',
      one: '1 photo',
      zero: '0 photos',
    );
    return '$_temp0';
  }

  @override
  String get file => 'File';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'Sections length mismatch: $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'Select mail app';

  @override
  String get selectAllShort => 'All';

  @override
  String get selectCoverPhoto => 'Select cover photo';

  @override
  String get newLocation => 'New location';

  @override
  String get faceNotClusteredYet =>
      'Face not clustered yet, please come back later';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'The link you are trying to access has expired.';

  @override
  String get openFile => 'Open file';

  @override
  String get backupFile => 'Backup file';

  @override
  String get openAlbumInBrowser => 'Open album in browser';

  @override
  String get openAlbumInBrowserTitle =>
      'Please use the web app to add photos to this album';

  @override
  String get allow => 'Allow';

  @override
  String get allowAppToOpenSharedAlbumLinks =>
      'Allow app to open shared album links';

  @override
  String get seePublicAlbumLinksInApp => 'See public album links in app';

  @override
  String get emergencyContacts => 'Emergency Contacts';

  @override
  String get acceptTrustInvite => 'Accept Invite';

  @override
  String get declineTrustInvite => 'Decline Invite';

  @override
  String get removeYourselfAsTrustedContact =>
      'Remove yourself as trusted contact';

  @override
  String get legacy => 'Legacy';

  @override
  String get legacyPageDesc =>
      'Legacy allows trusted contacts to access your account in your absence.';

  @override
  String get legacyPageDesc2 =>
      'Trusted contacts can initiate account recovery, and if not blocked within 30 days, reset your password and access your account.';

  @override
  String get legacyAccounts => 'Legacy accounts';

  @override
  String get trustedContacts => 'Trusted contacts';

  @override
  String get addTrustedContact => 'Add Trusted Contact';

  @override
  String get removeInvite => 'Remove invite';

  @override
  String get recoveryWarning =>
      'A trusted contact is trying to access your account';

  @override
  String get rejectRecovery => 'Reject recovery';

  @override
  String get recoveryInitiated => 'Recovery initiated';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return 'You can access the account after $days days. A notification will be sent to $email.';
  }

  @override
  String get cancelAccountRecovery => 'Cancel recovery';

  @override
  String get recoveryAccount => 'Recover account';

  @override
  String get cancelAccountRecoveryBody =>
      'Are you sure you want to cancel recovery?';

  @override
  String get startAccountRecoveryTitle => 'Start recovery';

  @override
  String get whyAddTrustContact =>
      'Trusted contact can help in recovering your data.';

  @override
  String recoveryReady({required String email}) {
    return 'You can now recover $email\'s account by setting a new password.';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email is trying to recover your account.';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return 'You have been invited to be a legacy contact by $email.';
  }

  @override
  String get warning => 'Warning';

  @override
  String get proceed => 'Proceed';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return 'You are about to add $email as a trusted contact. They will be able to recover your account if you are absent for $numOfDays days.';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email has invited you to be a trusted contact';
  }

  @override
  String get authToManageLegacy =>
      'Please authenticate to manage your trusted contacts';

  @override
  String get hideSharedItemsFromHomeGallery =>
      'Hide shared items from home gallery';

  @override
  String get swipeToSelect => 'Swipe to select';

  @override
  String get gallery => 'Gallery';

  @override
  String get joinAlbum => 'Join album';

  @override
  String get joinAlbumSubtext => 'to view and add your photos';

  @override
  String get joinAlbumSubtextViewer => 'to add this to shared albums';

  @override
  String get join => 'Join';

  @override
  String get linkEmail => 'Link email';

  @override
  String get link => 'Link';

  @override
  String get noEnteAccountExclamation => 'No Ente account!';

  @override
  String get orPickFromYourContacts => 'or pick from your contacts';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return '$email does not have an Ente account.';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (Me)';
  }

  @override
  String get reassignMe => 'Reassign \"Me\"';

  @override
  String get me => 'Me';

  @override
  String get linkEmailToContactBannerCaption => 'for faster sharing';

  @override
  String get selectPersonToLink => 'Select person to link';

  @override
  String linkPersonToEmail({required String email}) {
    return 'Link person to $email';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return 'This will link $personName to $email';
  }

  @override
  String get selectYourFace => 'Select your face';

  @override
  String get reassigningLoading => 'Reassigning...';

  @override
  String reassignedToName({required String name}) {
    return 'Reassigned you to $name';
  }

  @override
  String get saveChangesBeforeLeavingQuestion => 'Save changes before leaving?';

  @override
  String get dontSave => 'Don\'t save';

  @override
  String get thisIsMeExclamation => 'This is me!';

  @override
  String get linkPerson => 'Link person';

  @override
  String get linkPersonCaption => 'for better sharing experience';

  @override
  String get videoStreaming => 'Streamable videos';

  @override
  String get processingVideos => 'Processing videos';

  @override
  String get streamDetails => 'Stream details';

  @override
  String get processing => 'Processing';

  @override
  String get queued => 'Queued';

  @override
  String get ineligible => 'Ineligible';

  @override
  String get failed => 'Failed';

  @override
  String get playStream => 'Play stream';

  @override
  String get playOriginal => 'Play original';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'Joining an album will make your email visible to its participants.';

  @override
  String get pleaseWaitThisWillTakeAWhile =>
      'Please wait, this will take a while.';

  @override
  String get editTime => 'Edit time';

  @override
  String get selectTime => 'Select time';

  @override
  String get selectDate => 'Select date';

  @override
  String get previous => 'Previous';

  @override
  String get selectOneDateAndTimeForAll => 'Select one date and time for all';

  @override
  String get selectStartOfRange => 'Select start of range';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      'This will make the date and time of all selected photos the same.';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'This is the first in the group. Other selected photos will automatically shift based on this new date';

  @override
  String get newRange => 'New range';

  @override
  String get selectOneDateAndTime => 'Select one date and time';

  @override
  String get moveSelectedPhotosToOneDate => 'Move selected photos to one date';

  @override
  String get shiftDatesAndTime => 'Shift dates and time';

  @override
  String get photosKeepRelativeTimeDifference =>
      'Photos keep relative time difference';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count photos',
      one: '1 photo',
      zero: 'No photos',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'App icon';

  @override
  String get notThisPerson => 'Not this person?';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      'Selected items will be removed from this person, but not deleted from your library.';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat through the years';
  }

  @override
  String get thisWeekThroughTheYears => 'This week through the years';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'This week, $count years ago',
      one: 'This week, $count year ago',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'You and $name';
  }

  @override
  String admiringThem({required Object name}) {
    return 'Admiring $name';
  }

  @override
  String embracingThem({required Object name}) {
    return 'Embracing $name';
  }

  @override
  String partyWithThem({required Object name}) {
    return 'Party with $name';
  }

  @override
  String hikingWithThem({required Object name}) {
    return 'Hiking with $name';
  }

  @override
  String feastingWithThem({required Object name}) {
    return 'Feasting with $name';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return 'Selfies with $name';
  }

  @override
  String posingWithThem({required Object name}) {
    return 'Posing with $name';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return 'Beautiful views with $name';
  }

  @override
  String sportsWithThem({required Object name}) {
    return 'Sports with $name';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return 'Road trip with $name';
  }

  @override
  String get spotlightOnYourself => 'Spotlight on yourself';

  @override
  String spotlightOnThem({required Object name}) {
    return 'Spotlight on $name';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$name is $age!';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name turning $age soon';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return 'Last time with $name';
  }

  @override
  String tripToLocation({required Object location}) {
    return 'Trip to $location';
  }

  @override
  String tripInYear({required Object year}) {
    return 'Trip in $year';
  }

  @override
  String get lastYearsTrip => 'Last year\'s trip';

  @override
  String get sunrise => 'On the horizon';

  @override
  String get mountains => 'Over the hills';

  @override
  String get greenery => 'The green life';

  @override
  String get beach => 'Sand and sea';

  @override
  String get city => 'In the city';

  @override
  String get moon => 'In the moonlight';

  @override
  String get onTheRoad => 'On the road again';

  @override
  String get food => 'Culinary delight';

  @override
  String get pets => 'Furry companions';

  @override
  String get curatedMemories => 'Curated memories';

  @override
  String get widgets => 'Widgets';

  @override
  String get memories => 'Memories';

  @override
  String get peopleWidgetDesc =>
      'Select the people you wish to see on your homescreen.';

  @override
  String get albumsWidgetDesc =>
      'Select the albums you wish to see on your homescreen.';

  @override
  String get memoriesWidgetDesc =>
      'Select the kind of memories you wish to see on your homescreen.';

  @override
  String get smartMemories => 'Smart memories';

  @override
  String get pastYearsMemories => 'Past years\' memories';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return 'Also delete the photos (and videos) present in these $count albums from <bold>all</bold> other albums they are part of?';
  }

  @override
  String get addParticipants => 'Add participants';

  @override
  String selectedAlbums({required Object count}) {
    return '$count selected';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'Action not supported on Favourites album';

  @override
  String get onThisDayMemories => 'On this day memories';

  @override
  String get onThisDay => 'On this day';

  @override
  String get lookBackOnYourMemories => 'Look back on your memories 🌄';

  @override
  String get newPhotosEmoji => ' new 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'Sorry, we had to pause your backups';

  @override
  String get clickToInstallOurBestVersionYet =>
      'Click to install our best version yet';

  @override
  String get onThisDayNotificationExplanation =>
      'Receive reminders about memories from this day in previous years.';

  @override
  String get addMemoriesWidgetPrompt =>
      'Add a memories widget to your homescreen and come back here to customize.';

  @override
  String get addAlbumWidgetPrompt =>
      'Add an album widget to your homescreen and come back here to customize.';

  @override
  String get addPeopleWidgetPrompt =>
      'Add a people widget to your homescreen and come back here to customize.';

  @override
  String get birthdayNotifications => 'Birthday notifications';

  @override
  String get receiveRemindersOnBirthdays =>
      'Receive reminders when it\'s someone\'s birthday. Tapping on the notification will take you to photos of the birthday person.';

  @override
  String get happyBirthday => 'Happy birthday! 🥳';

  @override
  String get birthdays => 'Birthdays';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return 'Wish $name a happy birthday! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      'Are you sure you want to remove this face from this person?';

  @override
  String get otherDetectedFaces => 'Other detected faces';

  @override
  String get areThey => 'Are they ';

  @override
  String get questionmark => '?';

  @override
  String get saveAsAnotherPerson => 'Save as another person';

  @override
  String get showLessFaces => 'Show less faces';

  @override
  String get showMoreFaces => 'Show more faces';

  @override
  String get ignore => 'Ignore';

  @override
  String get merge => 'Merge';

  @override
  String get reset => 'Reset';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      'Are you sure you want to ignore this person?';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      'Are you sure you want to ignore these persons?';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'The person groups will not be displayed in the people section anymore. Photos will remain untouched.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'The person will not be displayed in the people section anymore. Photos will remain untouched.';

  @override
  String get areYouSureYouWantToMergeThem =>
      'Are you sure you want to merge them?';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'All unnamed groups will be merged into the selected person. This can still be undone from the suggestions history overview of the person.';

  @override
  String get yesIgnore => 'Yes, ignore';

  @override
  String get same => 'Same';

  @override
  String get different => 'Different';

  @override
  String get sameperson => 'Same person?';

  @override
  String get indexingPausedStatusDescription =>
      'Indexing is paused. It will automatically resume when the device is ready. The device is considered ready when its battery level, battery health, and thermal status are within a healthy range.';

  @override
  String get thisWeek => 'This week';

  @override
  String get lastWeek => 'Last week';

  @override
  String get thisMonth => 'This month';

  @override
  String get thisYear => 'This year';

  @override
  String get groupBy => 'Group by';

  @override
  String get faceThumbnailGenerationFailed =>
      'Unable to generate face thumbnails';

  @override
  String get fileAnalysisFailed => 'Unable to analyze file';

  @override
  String get editAutoAddPeople => 'Edit auto-add people';

  @override
  String get autoAddPeople => 'Auto-add people';

  @override
  String get autoAddToAlbum => 'Auto-add to album';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      'Should the files related to the person that were previously selected in smart albums be removed?';

  @override
  String get addingPhotos => 'Adding photos';

  @override
  String get gettingReady => 'Getting ready';

  @override
  String get addSomePhotosDesc1 => 'Add some photos or pick ';

  @override
  String get addSomePhotosDesc2 => 'familiar faces';

  @override
  String get addSomePhotosDesc3 => '\nto begin with';

  @override
  String get ignorePerson => 'Ignore person';

  @override
  String get mixedGrouping => 'Mixed grouping?';

  @override
  String get analysis => 'Analysis';

  @override
  String get doesGroupContainMultiplePeople =>
      'Does this grouping contain multiple people?';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'We will automatically analyze the grouping to determine if there are multiple people present, and separate them out again. This may take a few seconds.';

  @override
  String get layout => 'Layout';

  @override
  String get day => 'Day';

  @override
  String get undo => 'Undo';

  @override
  String get redo => 'Redo';

  @override
  String get filter => 'Filter';

  @override
  String get adjust => 'Adjust';

  @override
  String get draw => 'Draw';

  @override
  String get sticker => 'Sticker';

  @override
  String get brushColor => 'Brush Color';

  @override
  String get font => 'Font';

  @override
  String get background => 'Background';

  @override
  String get align => 'Align';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Added successfully to $count albums',
      one: 'Added successfully to 1 album',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => 'Videos processed';

  @override
  String get totalVideos => 'Total videos';

  @override
  String get skippedVideos => 'Skipped videos';

  @override
  String get videoStreamingDescriptionLine1 =>
      'Play videos instantly on any device.';

  @override
  String get videoStreamingDescriptionLine2 =>
      'Enable to process video streams on this device.';

  @override
  String get videoStreamingNote =>
      'Only videos from last 60 days and under 1 minute are processed on this device. For older/longer videos, enable streaming in the desktop app.';

  @override
  String get createStream => 'Create stream';

  @override
  String get recreateStream => 'Recreate stream';

  @override
  String get addedToStreamCreationQueue => 'Added to stream creation queue';

  @override
  String get addedToStreamRecreationQueue => 'Added to stream recreation queue';

  @override
  String get videoPreviewAlreadyExists => 'Video preview already exists';

  @override
  String get videoAlreadyInQueue => 'Video file already present in the queue';

  @override
  String get videoExportFailed => 'Video creation failed. Please try again.';

  @override
  String videoExportSuccess({required String path}) {
    return 'Video successfully created at $path';
  }

  @override
  String get addedToQueue => 'Added to queue';

  @override
  String get creatingStream => 'Creating stream';

  @override
  String get similarImages => 'Similar images';

  @override
  String get findSimilarImages => 'Find similar images';

  @override
  String get noSimilarImagesFound => 'No similar images found';

  @override
  String get yourPhotosLookUnique => 'Your photos look unique';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count groups found',
      one: '$count group found',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages => 'Review and remove similar images';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return 'Delete $count photos ($size)';
  }

  @override
  String get selectionOptions => 'Selection options';

  @override
  String selectExactWithCount({required int count}) {
    return 'Exactly similar ($count)';
  }

  @override
  String get selectExact => 'Select exact';

  @override
  String selectSimilarWithCount({required int count}) {
    return 'Mostly similar ($count)';
  }

  @override
  String get selectSimilar => 'Select similar';

  @override
  String selectAllWithCount({required int count}) {
    return 'All similarities ($count)';
  }

  @override
  String get selectSimilarImagesTitle => 'Select similar images';

  @override
  String get chooseSimilarImagesToSelect =>
      'Select images based on their visual similarity';

  @override
  String get clearSelection => 'Clear selection';

  @override
  String similarImagesCount({required int count}) {
    return '$count similar images';
  }

  @override
  String deleteWithCount({required int count}) {
    return 'Delete ($count)';
  }

  @override
  String get deleteFiles => 'Delete files';

  @override
  String get areYouSureDeleteFiles =>
      'Are you sure you want to delete these files?';

  @override
  String get greatJob => 'Great job!';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return 'You freed up $size of space';
  }

  @override
  String get size => 'Size';

  @override
  String get similarity => 'Similarity';

  @override
  String get analyzingPhotosLocally => 'Analyzing your photos locally...';

  @override
  String get lookingForVisualSimilarities =>
      'Looking for visual similarities...';

  @override
  String get comparingImageDetails => 'Comparing image details...';

  @override
  String get findingSimilarImages => 'Finding similar images...';

  @override
  String get almostDone => 'Almost done...';

  @override
  String get processingLocally => 'Processing locally';

  @override
  String get useMLToFindSimilarImages =>
      'Review and remove images that look similar to each other.';

  @override
  String get all => 'All';

  @override
  String get similar => 'Similar';

  @override
  String get identical => 'Identical';

  @override
  String get nothingHereTryAnotherFilter =>
      'Nothing here, try another filter! 👀';

  @override
  String get related => 'Related';

  @override
  String get hoorayyyy => 'Hoorayyyy!';

  @override
  String get nothingToTidyUpHere => 'Nothing to tidy up here';

  @override
  String get deletingDash => 'Deleting - ';

  @override
  String get cLTitle1 => 'Jump to date';

  @override
  String get cLDesc1 =>
      'See surrounding photos for any photo by selecting the jump to date option in the file\'s info pane.';

  @override
  String get cLTitle2 => 'Faster video editor';

  @override
  String get cLDesc2 =>
      'Video editor was revamped to both drastically improve its speed when editing larger videos, and also improve the UX.';

  @override
  String get cLTitle3 => 'New memories';

  @override
  String get cLDesc3 =>
      '\"Playful kids\", \"Winter adventures\", \"Neon nights\", and more.';

  @override
  String get cLTitle4 => 'Landscape gallery and more';

  @override
  String get cLDesc4 =>
      'Support for landscape layout in the app\'s main gallery. Show persons without any associated photos instead of filtering them out. Improve video aspect detection when shared from external apps.';

  @override
  String get closeBy => 'Close';

  @override
  String get peopleAutoAddDesc =>
      'Automatically add photos of the selected people to this album';

  @override
  String get festivities => 'Festive cheer';

  @override
  String get snowAdventures => 'Winter adventures';

  @override
  String get waterfalls => 'Chasing waterfalls';

  @override
  String get wildlife => 'Into the wild';

  @override
  String get flowers => 'Blooming beauties';

  @override
  String get nightLights => 'Neon nights';

  @override
  String get architecture => 'Design icons';

  @override
  String get autumnColors => 'Autumn splendor';

  @override
  String get desertDreams => 'Desert dreams';

  @override
  String get stargazing => 'Under the stars';

  @override
  String get lakeside => 'Lakeside calm';

  @override
  String get rainyDays => 'Rainy day feels';

  @override
  String get sportsAction => 'Game on';

  @override
  String get streetArt => 'Street art stories';

  @override
  String get familyMoments => 'Family time';

  @override
  String get fireworks => 'Firework finale';

  @override
  String get historicSites => 'Echoes of history';

  @override
  String get tropicalParadise => 'Tropical escapes';

  @override
  String get forestTrails => 'Forest strolls';

  @override
  String get citySunsets => 'City sunset glow';

  @override
  String get colorfulMarkets => 'Vibrant markets';

  @override
  String get cozyCafes => 'Cozy cafe corners';

  @override
  String get vintageVibes => 'Vintage vibes';

  @override
  String get aerialViews => 'Aerial perspectives';

  @override
  String get artisticPortraits => 'Artful portraits';

  @override
  String get streetFood => 'Street food bites';

  @override
  String get riverCruises => 'River cruise views';

  @override
  String get facesTimelineBannerTitle => 'Memory Lane';

  @override
  String facesTimelineBannerSubtitle({required String name}) {
    return 'See $name\'s photos across the years';
  }

  @override
  String get facesTimelineAppBarTitle => 'Memory lane';

  @override
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count years old',
      one: '$count year old',
    );
    return '$name was $_temp0';
  }

  @override
  String facesTimelineCaptionYearsAgo({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '# years ago',
      one: '# year ago',
    );
    return '$_temp0';
  }

  @override
  String get facesTimelineShareComingSoon => 'Video sharing coming soon';

  @override
  String get facesTimelinePlaybackPrevious => 'Previous';

  @override
  String get facesTimelinePlaybackNext => 'Next';

  @override
  String get facesTimelinePlaybackPlay => 'Play';

  @override
  String get facesTimelinePlaybackPause => 'Pause';

  @override
  String get facesTimelineUnavailable => 'Faces timeline is preparing...';

  @override
  String get playfulKids => 'Playful kids';

  @override
  String get coastalCliffs => 'Cliffs by the sea';

  @override
  String get ritualsTitle => 'Rituals';

  @override
  String get ritualAddTooltip => 'Add ritual';

  @override
  String get ritualActivityHeading => 'Activity';

  @override
  String get ritualDefaultHeatmapTitle => 'Take a photo every day';

  @override
  String get ritualUntitled => 'Untitled ritual';

  @override
  String get ritualShareUnavailable =>
      'Unable to share right now. Please try again.';

  @override
  String get ritualNotificationMessage => 'Take a photo now';

  @override
  String get ritualCameraNotFound => 'No camera found on this device.';

  @override
  String get ritualCameraStartError =>
      'Unable to start camera. Please check permissions.';

  @override
  String get ritualCaptureError => 'Unable to capture photo. Please try again.';

  @override
  String ritualPhotoLimit({required int maxPhotos}) {
    String _temp0 = intl.Intl.pluralLogic(
      maxPhotos,
      locale: localeName,
      other: '# photos.',
      one: '# photo.',
    );
    return 'You can add up to $_temp0';
  }

  @override
  String get ritualCaptureAtLeastOne => 'Capture at least one photo first.';

  @override
  String get ritualAlbumMissing =>
      'Ritual album missing. Edit the ritual to set an album.';

  @override
  String get ritualAddedToAlbum => 'Added to album';

  @override
  String ritualAddedToAlbumWithName({required String albumName}) {
    return 'Added to $albumName';
  }

  @override
  String ritualAddToAlbumFailure({required String error}) {
    return 'Couldn\'t add photos to the album: $error';
  }

  @override
  String get ritualBackToList => 'Back to rituals';

  @override
  String get ritualNoPhotosYet => 'No photos yet';

  @override
  String get ritualSetAlbumToLaunchCamera =>
      'Set an album for this ritual to launch the camera.';

  @override
  String get ritualDefaultCameraTitle => 'Take a photo';

  @override
  String get ritualBadgeMessage7 =>
      '7 days down! Consistency looks good on you. Keep going!';

  @override
  String get ritualBadgeMessage14 =>
      '14 days in! Your ritual is becoming a habit. Incredible!';

  @override
  String get ritualBadgeMessage30 =>
      '30 days in a row! Legendary consistency. Take a bow!';

  @override
  String get ritualBadgeMessageDefault => 'You\'re on a roll!';

  @override
  String get ritualBadgeNewTitle => 'New achievement';

  @override
  String get ritualBadgePreparing => 'Preparing...';

  @override
  String get ritualStreaksLabel => 'Streaks';

  @override
  String get ritualCreateYourOwn => 'Create your own ritual';

  @override
  String get ritualGetDailyReminders => 'Get daily reminders';

  @override
  String get ritualAlbumNotSet => 'Album not set';

  @override
  String get ritualOpenCameraTooltip => 'Open ritual camera';

  @override
  String get ritualEditorLabel => 'Ritual editor';

  @override
  String get ritualNew => 'New ritual';

  @override
  String get ritualEdit => 'Edit ritual';

  @override
  String get ritualEnterPrompt => 'Enter your ritual';

  @override
  String get ritualEnterDescription => 'Please enter a description';

  @override
  String get ritualDayLabel => 'Day';

  @override
  String get ritualNotificationsOffHint =>
      'Notifications are off. Tap a day to turn them on.';

  @override
  String get ritualTimeLabel => 'Time';

  @override
  String get ritualAlbumLabel => 'Album';

  @override
  String get ritualSave => 'Save ritual';

  @override
  String get ritualUpdate => 'Update ritual';

  @override
  String get ritualSelectAlbumTitle => 'Select album';

  @override
  String get ritualSearchOrCreate => 'Search or create new';

  @override
  String get ritualNoAlbumsYet => 'No albums yet';

  @override
  String get ritualNoMatchingAlbums => 'No matching albums';

  @override
  String ritualCreateAlbumWithName({required String albumName}) {
    return 'Create \"$albumName\"';
  }

  @override
  String get ritualCreateNew => 'Create new';

  @override
  String get ritualAlbumSelectionPlaceholder => 'Select album';

  @override
  String get ritualPickEmojiTitle => 'Pick an emoji';

  @override
  String get ritualCustomKeyboardLabel => 'Custom (keyboard)';

  @override
  String get ritualEmojiKeyboardHint => 'Press to open emoji keyboard';

  @override
  String get ritualEmojiUseAction => 'Use';

  @override
  String get ritualSearchEmpty =>
      'Build a ritual to keep your photo habit going.';
}
