// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Czech (`cs`).
class AppLocalizationsCs extends AppLocalizations {
  AppLocalizationsCs([String locale = 'cs']) : super(locale);

  @override
  String get enterYourEmailAddress => 'Zadejte svou e-mailovou adresu';

  @override
  String get enterYourNewEmailAddress => 'Zadejte novou e-mailovou adresu';

  @override
  String get accountWelcomeBack => 'Vítejte zpět!';

  @override
  String get emailAlreadyRegistered => 'E-mail je již zaregistrován.';

  @override
  String get emailNotRegistered => 'E-mail není registrován.';

  @override
  String get email => 'E-mail';

  @override
  String get cancel => 'Zrušit';

  @override
  String get verify => 'Ověřit';

  @override
  String get invalidEmailAddress => 'Neplatná e-mailová adresa';

  @override
  String get enterValidEmail => 'Prosím, zadejte platnou e-mailovou adresu.';

  @override
  String get deleteAccount => 'Smazat účet';

  @override
  String get deleteAccountWarning =>
      'This will delete your Ente Auth, Ente Photos and Ente Locker account.';

  @override
  String get askDeleteReason =>
      'Jaký je váš hlavní důvod, proč mažete svůj účet?';

  @override
  String get deleteAccountFeedbackPrompt =>
      'Je nám líto, že nás opouštíte. Prosím, dejte nám zpětnou vazbu, ať se můžeme zlepšit.';

  @override
  String get feedback => 'Zpětná vazba';

  @override
  String get kindlyHelpUsWithThisInformation =>
      'Pomozte nám s těmito informacemi';

  @override
  String get confirmDeletePrompt =>
      'Ano, chci trvale smazat tento účet a jeho data napříč všemi aplikacemi.';

  @override
  String get confirmAccountDeletion => 'Potvrdit odstranění účtu';

  @override
  String get deleteAccountPermanentlyButton => 'Trvale smazat účet';

  @override
  String get yourAccountHasBeenDeleted => 'Váš účet byl smazán';

  @override
  String get selectReason => 'Vyberte důvod';

  @override
  String get deleteReason1 => 'Chybí klíčová funkce, kterou potřebuji';

  @override
  String get deleteReason2 =>
      'Aplikace nebo určitá funkce se nechová tak, jak si myslím, že by měla';

  @override
  String get deleteReason3 => 'Našel jsem jinou službu, která se mi líbí více';

  @override
  String get deleteReason4 => 'Můj důvod není uveden';

  @override
  String get sendEmail => 'Odeslat e-mail';

  @override
  String get deleteRequestSLAText =>
      'Váš požadavek bude zpracován do 72 hodin.';

  @override
  String get deleteEmailRequest =>
      'Prosím, zašlete e-mail na <warning>account-deletion@ente.io</warning> ze schránky, se kterou jste se registrovali.';

  @override
  String get entePhotosPerm =>
      'Ente <i>potřebuje oprávnění</i> k uchovávání vašich fotek';

  @override
  String get ok => 'Ok';

  @override
  String get createAccount => 'Vytvořit účet';

  @override
  String get createNewAccount => 'Vytvořit nový účet';

  @override
  String get password => 'Heslo';

  @override
  String get confirmPassword => 'Potvrďte heslo';

  @override
  String get activeSessions => 'Aktivní relace';

  @override
  String get ocrProcessingOverlayMessage => 'Detecting text...';

  @override
  String get ocrLoadingIndicatorLabel => 'Detecting Text';

  @override
  String get ocrSelectionHint =>
      'Swipe or double tap to select just what you need';

  @override
  String get ocrNoTextDetected => 'No text detected';

  @override
  String get ocrRetryButtonLabel => 'Retry';

  @override
  String get ocrModelsNetworkRequiredError =>
      'Network connection required to download OCR models on first use';

  @override
  String get ocrModelsPrepareFailed => 'Could not prepare OCR models';

  @override
  String get ocrImageNotFoundError => 'Image file not found';

  @override
  String get ocrImageDecodeFailedError => 'Could not read image file';

  @override
  String get ocrGenericDetectError => 'Could not detect text in image';

  @override
  String get oops => 'Jejda';

  @override
  String get somethingWentWrongPleaseTryAgain =>
      'Něco se pokazilo. Zkuste to, prosím, znovu';

  @override
  String get thisWillLogYouOutOfThisDevice =>
      'Toto vás odhlásí z tohoto zařízení!';

  @override
  String get thisWillLogYouOutOfTheFollowingDevice =>
      'Toto vás odhlásí z následujícího zařízení:';

  @override
  String get terminateSession => 'Ukončit relaci?';

  @override
  String get terminate => 'Ukončit';

  @override
  String get thisDevice => 'Toto zařízení';

  @override
  String get recoverButton => 'Obnovit';

  @override
  String get recoverySuccessful => 'Úspěšně obnoveno!';

  @override
  String get decrypting => 'Dešifrování...';

  @override
  String get incorrectRecoveryKeyTitle => 'Nesprávný obnovovací klíč';

  @override
  String get incorrectRecoveryKeyBody =>
      'Vámi zadaný obnovovací klíč je nesprávný';

  @override
  String get forgotPassword => 'Zapomenuté heslo';

  @override
  String get enterYourRecoveryKey => 'Zadejte svůj obnovovací klíč';

  @override
  String get noRecoveryKey => 'Nemáte obnovovací klíč?';

  @override
  String get sorry => 'Omlouváme se';

  @override
  String get noRecoveryKeyNoDecryption =>
      'Vzhledem k povaze našeho protokolu koncového šifrování nemohou být vaše data dešifrována bez vašeho hesla nebo obnovovacího klíče';

  @override
  String get verifyEmail => 'Ověřit e-mail';

  @override
  String get toResetVerifyEmail =>
      'Chcete-li resetovat heslo, nejprve ověřte svou e-mailovou adresu.';

  @override
  String get checkInboxAndSpamFolder =>
      'Zkontrolujte prosím svou doručenou poštu (a spam) pro dokončení ověření';

  @override
  String get tapToEnterCode => 'Klepněte pro zadání kódu';

  @override
  String get resendEmail => 'Znovu odeslat e-mail';

  @override
  String weHaveSendEmailTo({required String email}) {
    return 'Poslali jsme vám zprávu na <green>$email</green>';
  }

  @override
  String get setPasswordTitle => 'Nastavit heslo';

  @override
  String get changePasswordTitle => 'Změnit heslo';

  @override
  String get resetPasswordTitle => 'Obnovit heslo';

  @override
  String get encryptionKeys => 'Šifrovací klíče';

  @override
  String get passwordWarning =>
      'Toto heslo neukládáme, takže pokud jej zapomenete, <underline>nemůžeme dešifrovat vaše data</underline>';

  @override
  String get enterPasswordToEncrypt =>
      'Zadejte heslo, které můžeme použít k šifrování vašich dat';

  @override
  String get enterNewPasswordToEncrypt =>
      'Zadejte nové heslo, které můžeme použít k šifrování vašich dat';

  @override
  String get weakStrength => 'Slabé';

  @override
  String get strongStrength => 'Silné';

  @override
  String get moderateStrength => 'Střední';

  @override
  String passwordStrength({required String passwordStrengthValue}) {
    return 'Síla hesla: $passwordStrengthValue';
  }

  @override
  String get passwordChangedSuccessfully => 'Heslo úspěšně změněno';

  @override
  String get generatingEncryptionKeys => 'Generování šifrovacích klíčů...';

  @override
  String get pleaseWait => 'Čekejte prosím...';

  @override
  String get continueLabel => 'Pokračovat';

  @override
  String get insecureDevice => 'Nezabezpečené zařízení';

  @override
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease =>
      'Omlouváme se, nemohli jsme vygenerovat bezpečné klíče na tomto zařízení.\n\nProsíme, zaregistrujte se z jiného zařízení.';

  @override
  String get howItWorks => 'Jak to funguje';

  @override
  String get encryption => 'Šifrování';

  @override
  String get ackPasswordLostWarning =>
      'Rozumím, že pokud zapomenu své heslo, mohu přijít o data, jelikož má data jsou <underline>koncově šifrována</underline>.';

  @override
  String get privacyPolicyTitle => 'Zásady ochrany osobních údajů';

  @override
  String get termsOfServicesTitle => 'Podmínky služby';

  @override
  String get signUpTerms =>
      'Souhlasím s <u-terms>podmínkami služby</u-terms> a <u-terms>zásadami ochrany osobních údajů</u-terms>';

  @override
  String get logInLabel => 'Přihlásit se';

  @override
  String get loginTerms =>
      'Kliknutím na přihlášení souhlasím s <u-terms>podmínkami služby</u-terms> a <u-policy>zásadami ochrany osobních údajů</u-policy>';

  @override
  String get changeEmail => 'Změnit e-mail';

  @override
  String get enterYourPassword => 'Zadejte své heslo';

  @override
  String get welcomeBack => 'Vítejte zpět!';

  @override
  String get contactSupport => 'Kontaktovat podporu';

  @override
  String get locationPickerTip =>
      'You can also add a location centered on a photo from the photo\'s info screen';

  @override
  String get incorrectPasswordTitle => 'Nesprávné heslo';

  @override
  String get pleaseTryAgain => 'Zkuste to prosím znovu';

  @override
  String get recreatePasswordTitle => 'Znovu vytvořit heslo';

  @override
  String get useRecoveryKey => 'Použít obnovovací klíč';

  @override
  String get recreatePasswordBody =>
      'Aktuální zařízení není dostatečně výkonné, aby ověřilo vaše heslo, ale můžeme ho znovu vygenerovat tak, aby fungovalo na všech zařízeních.\n\nPřihlaste se pomocí svého obnovovacího klíče a znovu vygenerujte heslo (pokud chcete, můžete použít stejné heslo).';

  @override
  String get verifyPassword => 'Ověřit heslo';

  @override
  String get recoveryKey => 'Obnovovací klíč';

  @override
  String get recoveryKeyOnForgotPassword =>
      'Tento klíč je jedinou cestou pro obnovení Vašich dat, pokud zapomenete heslo.';

  @override
  String get recoveryKeySaveDescription =>
      'Tento 24-slovný klíč neuchováváme, uschovejte ho, prosím, na bezpečném místě.';

  @override
  String get doThisLater => 'Udělat později';

  @override
  String get saveKey => 'Uložit klíč';

  @override
  String get recoveryKeyCopiedToClipboard =>
      'Obnovovací klíč zkopírován do schránky';

  @override
  String get recoverAccount => 'Obnovit účet';

  @override
  String get recover => 'Obnovit';

  @override
  String dropSupportEmail({required String supportEmail}) {
    return 'Prosíme, napište e-mail na $supportEmail ze schránky, kterou jste použili k registraci';
  }

  @override
  String get twofactorSetup => 'Nastavení dvoufázového ověřování';

  @override
  String get enterCode => 'Zadat kód';

  @override
  String get scanCode => 'Skenovat kód';

  @override
  String get codeCopiedToClipboard => 'Kód zkopírován do schránky';

  @override
  String get copypasteThisCodentoYourAuthenticatorApp =>
      'Zkopírujte tento kód\ndo vaší ověřovací aplikace';

  @override
  String get tapToCopy => 'klepnutím zkopírovat';

  @override
  String get scanThisBarcodeWithnyourAuthenticatorApp =>
      'Naskenujte tento QR kód \ns vaší ověřovací aplikací';

  @override
  String get enterThe6digitCodeFromnyourAuthenticatorApp =>
      'Zadejte 6-místný kód\nz vaší ověřovací aplikace';

  @override
  String get confirm => 'Potvrdit';

  @override
  String get setupComplete => 'Nastavení dokončeno';

  @override
  String get saveYourRecoveryKeyIfYouHaventAlready =>
      'Uložte si svůj obnovovací klíč, pokud jste tak ještě neučinili';

  @override
  String get thisCanBeUsedToRecoverYourAccountIfYou =>
      'Toto lze použít k obnovení účtu, pokud ztratíte svůj přístup k ověřovací aplikaci';

  @override
  String get twofactorAuthenticationPageTitle => 'Dvoufázové ověření';

  @override
  String get lostDevice => 'Ztratili jste zařízení?';

  @override
  String get verifyingRecoveryKey => 'Ověřování obnovovacího klíče...';

  @override
  String get recoveryKeyVerified => 'Obnovovací klíč byl ověřen';

  @override
  String get recoveryKeySuccessBody =>
      'Skvělé! Váš obnovovací klíč je platný. Děkujeme vám za ověření.\n\nNezapomeňte mít váš obnovovací klíč bezpečně zálohován.';

  @override
  String get invalidRecoveryKey =>
      'Zadaný obnovovací klíč není platný. Ujistěte se, že obsahuje 24 slov, a zkontrolujte pravopis každého z nich.\n\nPokud jste zadali starší obnovovací kód, ujistěte se, že má 64 znaků, a zkontrolujte každý z nich.';

  @override
  String get invalidKey => 'Neplatný klíč';

  @override
  String get tryAgain => 'Zkusit znovu';

  @override
  String get viewRecoveryKey => 'Zobrazit obnovovací klíč';

  @override
  String get confirmRecoveryKey => 'Potvrdit obnovovací klíč';

  @override
  String get recoveryKeyVerifyReason =>
      'Váš obnovovací klíč je jediný způsob, jak obnovit vaše fotografie, pokud zapomenete heslo. Obnovovací klíč najdete v Nastavení > Účet.\n\nZadejte zde svůj obnovovací klíč, abyste ověřili, že jste jej správně uložili.';

  @override
  String get confirmYourRecoveryKey => 'Potvrďte svůj obnovovací klíč';

  @override
  String get addViewer => 'Přidat prohlížejícího';

  @override
  String get addCollaborator => 'Přidat spolupracovníka';

  @override
  String get addANewEmail => 'Přidejte nový email';

  @override
  String get orPickAnExistingOne => 'Nebo vyberte existující';

  @override
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum =>
      'Spolupracovníci mohou do sdíleného alba přidávat fotky a videa.';

  @override
  String get enterEmail => 'Zadejte email';

  @override
  String get albumOwner => 'Vlastník';

  @override
  String get you => 'Vy';

  @override
  String get collaborator => 'Spolupracovník';

  @override
  String get addMore => 'Přidat další';

  @override
  String get viewer => 'Prohlížející';

  @override
  String get remove => 'Odstranit';

  @override
  String get removeParticipant => 'Odebrat účastníka';

  @override
  String get manage => 'Spravovat';

  @override
  String get addedAs => 'Přidán jako';

  @override
  String get changePermissions => 'Změnit oprávnění?';

  @override
  String get yesConvertToViewer => 'Ano, převést na prohlížejícího';

  @override
  String cannotAddMorePhotosAfterBecomingViewer({required Object user}) {
    return '$user nebude moci přidat další fotky do tohoto alba\n\nBudou stále moci odebrat existující fotky, které přidali';
  }

  @override
  String get allowAddingPhotos => 'Povolit přidávání fotek';

  @override
  String get allowJoiningAlbum => 'Allow joining album';

  @override
  String get allowAddPhotosDescription =>
      'Umožnit lidem s odkazem přidávat fotky do sdíleného alba.';

  @override
  String get passwordLock => 'Zámek heslem';

  @override
  String get canNotOpenTitle => 'Nelze otevřít toto album';

  @override
  String get canNotOpenBody =>
      'Omlouváme se, ale toto album nelze otevřít v aplikaci.';

  @override
  String get disableDownloadWarningTitle => 'Upozornění';

  @override
  String get disableDownloadWarningBody =>
      'Prohlížející mohou stále pořizovat snímky obrazovky nebo ukládat kopii vašich fotografií pomocí externích nástrojů';

  @override
  String get allowDownloads => 'Povolit stahování';

  @override
  String get linkDeviceLimit => 'Limit zařízení';

  @override
  String get noDeviceLimit => 'Žádné';

  @override
  String get albumLayout => 'Album layout';

  @override
  String get layoutGrouped => 'Grouped';

  @override
  String get layoutContinuous => 'Continuous';

  @override
  String get layoutTrip => 'Trip';

  @override
  String get preview => 'Preview';

  @override
  String get linkExpiry => 'Platnost odkazu';

  @override
  String get linkExpired => 'Vypršel';

  @override
  String get linkEnabled => 'Povoleno';

  @override
  String get linkNeverExpires => 'Nikdy';

  @override
  String get expiredLinkInfo =>
      'Platnost odkazu vypršela. Zvolte prosím nový čas vypršení platnosti, nebo zakažte platnost odkazu.';

  @override
  String get setAPassword => 'Nastavit heslo';

  @override
  String get lockButtonLabel => 'Uzamknout';

  @override
  String get enterPassword => 'Zadejte heslo';

  @override
  String get removeLink => 'Odstranit odkaz';

  @override
  String get manageLink => 'Spravovat odkaz';

  @override
  String linkExpiresOn({required Object expiryTime}) {
    return 'Platnost odkazu vyprší $expiryTime';
  }

  @override
  String get albumUpdated => 'Album bylo aktualizováno';

  @override
  String get never => 'Nikdy';

  @override
  String get custom => 'Vlastní';

  @override
  String get after1Hour => 'Po 1 hodině';

  @override
  String get after1Day => 'Po 1 dni';

  @override
  String get after1Week => 'Po 1 týdnu';

  @override
  String get after1Month => 'Po 1 měsíci';

  @override
  String get after1Year => 'Po 1 roce';

  @override
  String get manageParticipants => 'Spravovat';

  @override
  String albumParticipantsCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Účastníků',
      one: '1 Účastník',
      zero: 'Žádní účastníci',
    );
    return '$_temp0';
  }

  @override
  String get collabLinkSectionDescription =>
      'Vytvořte odkaz, který umožní ostatním přidávat a prohlížet fotografie ve vašem sdíleném albu, aniž by potřebovali aplikaci Ente nebo účet. Skvělé pro shromažďování fotografií z akcí.';

  @override
  String get collectPhotos => 'Shromáždit fotografie';

  @override
  String get collaborativeLink => 'Odkaz na spolupráci';

  @override
  String get shareWithNonenteUsers => 'Sdílet s jinými uživateli';

  @override
  String get createPublicLink => 'Vytvořit veřejný odkaz';

  @override
  String get sendLink => 'Odeslat odkaz';

  @override
  String get qrCode => 'QR Code';

  @override
  String get sendQrCode => 'Send QR code';

  @override
  String get copyLink => 'Kopírovat odkaz';

  @override
  String get copyEmbedHtml => 'Copy embed HTML';

  @override
  String get linkHasExpired => 'Platnost odkazu vypršela';

  @override
  String get publicLinkEnabled => 'Veřejný odkaz povolen';

  @override
  String get shareALink => 'Sdílet odkaz';

  @override
  String get sharedAlbumSectionDescription =>
      'Vytvářejte sdílená a společná alba s ostatními uživateli Ente, včetně uživatelů s bezplatnými tarify.';

  @override
  String shareWithPeopleSectionTitle({required int numberOfPeople}) {
    String _temp0 = intl.Intl.pluralLogic(
      numberOfPeople,
      locale: localeName,
      other: 'Sdíleno s $numberOfPeople osobami',
      one: 'Sdíleno s 1 osobou',
      zero: 'Sdílet s konkrétními osobami',
    );
    return '$_temp0';
  }

  @override
  String get thisIsYourVerificationId => 'Toto je vaše ověřovací ID';

  @override
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId =>
      'Osoba, která s vámi sdílí alba, by měla na svém zařízení vidět stejné ID.';

  @override
  String get howToViewShareeVerificationID =>
      'Požádejte je, aby dlouze stiskli svou emailovou adresu na obrazovce nastavení a ověřili, zda se ID na obou zařízeních shodují.';

  @override
  String thisIsPersonVerificationId({required String email}) {
    return 'Toto je ověřovací ID pro $email';
  }

  @override
  String get verificationId => 'Ověřovací ID';

  @override
  String verifyEmailID({required Object email}) {
    return 'Ověřit $email';
  }

  @override
  String emailNoEnteAccount({required Object email}) {
    return '$email nemá účet Ente.\n\nPošlete jim pozvánku ke sdílení fotek.';
  }

  @override
  String shareMyVerificationID({required Object verificationID}) {
    return 'Zde je moje ověřovací ID: $verificationID pro ente.io.';
  }

  @override
  String shareTextConfirmOthersVerificationID({
    required Object verificationID,
  }) {
    return 'Ahoj, můžeš potvrdit, že toto je tvé ověřovací ID ente.io: $verificationID';
  }

  @override
  String get somethingWentWrong => 'Něco se pokazilo';

  @override
  String get sendInvite => 'Odeslat pozvánku';

  @override
  String get shareTextRecommendUsingEnte =>
      'Stáhněte si aplikaci Ente, abyste mohli snadno sdílet fotografie a videa v původní kvalitě\n\nhttps://ente.io';

  @override
  String get done => 'Hotovo';

  @override
  String get applyCodeTitle => 'Uplatnit kód';

  @override
  String get enterCodeDescription =>
      'Zadejte kód, který vám poskytl váš přítel, a získejte bezplatné úložiště pro vás oba';

  @override
  String get apply => 'Použít';

  @override
  String get failedToApplyCode => 'Nepodařilo se použít kód';

  @override
  String get enterReferralCode => 'Vložte referenční kód';

  @override
  String get codeAppliedPageTitle => 'Kód byl použit';

  @override
  String get changeYourReferralCode => 'Změňte svůj referenční kód';

  @override
  String get change => 'Změnit';

  @override
  String get unavailableReferralCode =>
      'Omlouváme se, tento kód je nedostupný.';

  @override
  String get codeChangeLimitReached =>
      'Omlouváme se, dosáhli jste limitu změn kódu.';

  @override
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail}) {
    return 'Pro změnu kódu prosím kontaktujte $familyAdminEmail.';
  }

  @override
  String storageInGB({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB';
  }

  @override
  String get claimed => 'Získáno';

  @override
  String get details => 'Detaily';

  @override
  String get claimMore => 'Získat více!';

  @override
  String theyAlsoGetXGb({required Object storageAmountInGB}) {
    return 'Získají také $storageAmountInGB GB';
  }

  @override
  String freeStorageOnReferralSuccess({required Object storageAmountInGB}) {
    return '$storageAmountInGB GB pokaždé, když se někdo zaregistruje do placeného tarifu a použije váš kód';
  }

  @override
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  }) {
    return 'Referenční kód Ente: $referralCode \n\nPoužijte jej v Nastavení → Obecné → Doporučení a získejte $referralStorageInGB GB zdarma po registraci k placenému tarifu.\n\nhttps://ente.io';
  }

  @override
  String get claimFreeStorage => 'Získat úložiště zdarma';

  @override
  String get inviteYourFriends => 'Pozvěte své přátele';

  @override
  String get failedToFetchReferralDetails =>
      'Nelze načíst podrobnosti o doporučení. Zkuste to prosím znovu později.';

  @override
  String get referralStep1 => '1. Dejte tento kód svým přátelům';

  @override
  String get referralStep2 => '2. Zaregistrují se k placenému tarifu';

  @override
  String referralStep3({required Object storageInGB}) {
    return '3. Oba získáte $storageInGB GB* zdarma';
  }

  @override
  String get referralsAreCurrentlyPaused =>
      'Doporučení jsou momentálně pozastavena';

  @override
  String get youCanAtMaxDoubleYourStorage =>
      '* Můžete maximálně zdvojnásobit své úložiště';

  @override
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  }) {
    String _temp0 = intl.Intl.selectLogic(isFamilyMember, {
      'true': 'Vaše rodina dosud získala $storageAmountInGb GB',
      'false': 'Dosud jste získali $storageAmountInGb GB',
      'other': 'Dosud jste získali $storageAmountInGb GB!',
    });
    return '$_temp0';
  }

  @override
  String get faq => 'Často kladené dotazy (FAQ)';

  @override
  String get help => 'Nápověda';

  @override
  String get oopsSomethingWentWrong => 'Jejda, něco se pokazilo';

  @override
  String get peopleUsingYourCode => 'Lidé, kteří používají váš kód';

  @override
  String get eligible => 'způsobilí';

  @override
  String get total => 'celkem';

  @override
  String get codeUsedByYou => 'Kód použitý vámi';

  @override
  String get freeStorageClaimed => 'Získané úložiště zdarma';

  @override
  String get freeStorageUsable => 'Bezplatné použitelné úložiště';

  @override
  String get usableReferralStorageInfo =>
      'Použitelná úložná kapacita je omezena vaším aktuálním tarifem. Překročená úložná kapacita se automaticky stane použitelnou, jakmile si tarif vylepšíte.';

  @override
  String get removeFromAlbumTitle => 'Odstranit z alba?';

  @override
  String get removeFromAlbum => 'Odstranit z alba';

  @override
  String get itemsWillBeRemovedFromAlbum =>
      'Vybrané položky budou odstraněny z tohoto alba';

  @override
  String get removeShareItemsWarning =>
      'Některé položky, které odstraňujete, byly přidány jinými lidmi a ztratíte k nim přístup';

  @override
  String get addingToFavorites => 'Přidávání k oblíbeným...';

  @override
  String get removingFromFavorites => 'Odstraňování z oblíbených...';

  @override
  String get sorryCouldNotAddToFavorites =>
      'Omlouváme se, nelze přidat k oblíbeným!';

  @override
  String get sorryCouldNotRemoveFromFavorites =>
      'Omlouváme se, nelze odebrat z oblíbených!';

  @override
  String get subscribeToEnableSharing =>
      'K povolení sdílení potřebujete aktivní placené předplatné.';

  @override
  String get subscribe => 'Odebírat';

  @override
  String get canOnlyRemoveFilesOwnedByYou =>
      'Můžete odstranit pouze vámi vlastněné soubory';

  @override
  String get deleteSharedAlbum => 'Smazat sdílené album?';

  @override
  String get deleteAlbum => 'Odstranit album';

  @override
  String get deleteAlbumDialog =>
      'Smazat také fotografie (a videa) obsažené v tomto albu ze <bold>všech</bold> ostatních alb, jejichž součástí jsou?';

  @override
  String get deleteSharedAlbumDialogBody =>
      'Album bude smazáno pro všechny\n\nZtratíte přístup ke sdíleným fotkám v tomto albu, které vlastní jiní uživatelé';

  @override
  String get yesRemove => 'Ano, odstranit';

  @override
  String get creatingLink => 'Vytváření odkazu...';

  @override
  String get removeWithQuestionMark => 'Odstranit?';

  @override
  String removeParticipantBody({required Object userEmail}) {
    return '$userEmail bude odebrán z tohoto sdíleného alba\n\nVšechny jimi přidané fotky budou také z alba odebrány';
  }

  @override
  String get keepPhotos => 'Ponechat fotky';

  @override
  String get deletePhotos => 'Smazat fotografie';

  @override
  String get inviteToEnte => 'Pozvat do Ente';

  @override
  String get removePublicLink => 'Odstranit veřejný odkaz';

  @override
  String disableLinkMessage({required Object albumName}) {
    return 'Toto odstraní veřejný odkaz pro přístup k \"$albumName\".';
  }

  @override
  String get sharing => 'Sdílení...';

  @override
  String get youCannotShareWithYourself => 'Nemůžete sdílet se sebou';

  @override
  String get archive => 'Archiv';

  @override
  String get createAlbumActionHint =>
      'Dlouhým stisknutím vyberte fotografie a kliknutím na + vytvořte album';

  @override
  String get importing => 'Importování....';

  @override
  String get failedToLoadAlbums => 'Nepodařilo se načíst alba';

  @override
  String get hidden => 'Skryté';

  @override
  String get authToViewYourHiddenFiles =>
      'Pro zobrazení skrytých souborů se prosím ověřte';

  @override
  String get authToViewTrashedFiles =>
      'Pro zobrazení smazaných souborů se prosím ověřte';

  @override
  String get trash => 'Koš';

  @override
  String get uncategorized => 'Nezařazené';

  @override
  String get videoSmallCase => 'Video';

  @override
  String get photoSmallCase => 'Fotka';

  @override
  String get singleFileDeleteHighlight => 'Bude odstraněn ze všech alb.';

  @override
  String singleFileInBothLocalAndRemote({required Object fileType}) {
    return '$fileType se nachází jak v Ente, tak ve vašem zařízení.';
  }

  @override
  String singleFileInRemoteOnly({required Object fileType}) {
    return 'Tento soubor bude vymazán z Ente.';
  }

  @override
  String singleFileDeleteFromDevice({required Object fileType}) {
    return 'Tento soubor bude vymazán z vašeho zařízení.';
  }

  @override
  String get deleteFromEnte => 'Odstranit z Ente';

  @override
  String get yesDelete => 'Ano, smazat';

  @override
  String get movedToTrash => 'Přesunuto do koše';

  @override
  String get deleteFromDevice => 'Odstranit ze zařízení';

  @override
  String get deleteFromBoth => 'Odstranit z obou';

  @override
  String get newAlbum => 'Nové album';

  @override
  String get albums => 'Alba';

  @override
  String memoryCount({required int count, required String formattedCount}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedCount vzpomínek',
      few: '$formattedCount vzpomínky',
      one: '$formattedCount vzpomínka',
      zero: 'žádné vzpomínky',
    );
    return '$_temp0';
  }

  @override
  String selectedPhotos({required int count}) {
    return 'Vybráno: $count';
  }

  @override
  String selectedPhotosWithYours({required int count, required int yourCount}) {
    return 'Vybráno: $count ($yourCount tvých)';
  }

  @override
  String get advancedSettings => 'Pokročilé';

  @override
  String get photoGridSize => 'Velikost mřížky fotografií';

  @override
  String get manageDeviceStorage => 'Spravovat mezipaměť zařízení';

  @override
  String get manageDeviceStorageDesc =>
      'Zkontrolovat a vymazat místní úložiště mezipaměti.';

  @override
  String get machineLearning => 'Strojové učení';

  @override
  String get mlConsent => 'Povolit strojové učení';

  @override
  String get mlConsentTitle => 'Povolit strojové učení?';

  @override
  String get mlConsentDescription =>
      'Pokud povolíte strojové učení, Ente bude extrahovat informace, jako je geometrie obličeje, ze souborů, včetně těch, které s vámi byly sdíleny.\n\nTo se bude dít na vašem zařízení a veškeré generované biometrické informace budou koncově šifrovány.';

  @override
  String get mlConsentPrivacy =>
      'Klikněte zde pro více informací o této funkci v našich zásadách ochrany osobních údajů';

  @override
  String get mlConsentConfirmation => 'Chápu a chci umožnit strojové učení';

  @override
  String get magicSearch => 'Magické vyhledávání';

  @override
  String get discover => 'Objevit';

  @override
  String get discover_identity => 'Identita';

  @override
  String get discover_screenshots => 'Snímky obrazovky';

  @override
  String get discover_receipts => 'Účtenky';

  @override
  String get discover_notes => 'Poznámky';

  @override
  String get discover_memes => 'Memy';

  @override
  String get discover_visiting_cards => 'Vizitky';

  @override
  String get discover_babies => 'Děti';

  @override
  String get discover_pets => 'Domácí mazlíčci';

  @override
  String get discover_selfies => 'Selfie';

  @override
  String get discover_wallpapers => 'Pozadí';

  @override
  String get discover_food => 'Jídlo';

  @override
  String get discover_celebrations => 'Oslavy';

  @override
  String get discover_sunset => 'Západ slunce';

  @override
  String get discover_hills => 'Kopce';

  @override
  String get discover_greenery => 'Zeleň';

  @override
  String get mlIndexingDescription =>
      'Vezměte prosím na vědomí, že strojové učení bude mít za následek vyšší využití sítě a baterie, dokud nebudou všechny položky zaindexovány. Pro rychlejší indexování zvažte použití desktopové aplikace, všechny výsledky budou synchronizovány automaticky.';

  @override
  String get loadingModel => 'Stahování modelů...';

  @override
  String get waitingForWifi => 'Čekání na WiFi...';

  @override
  String get status => 'Stav';

  @override
  String get indexedItems => 'Indexovaných položek';

  @override
  String get pendingItems => 'Čekající položky';

  @override
  String get clearIndexes => 'Smazat indexy';

  @override
  String get selectFoldersForBackup => 'Vyberte složky pro zálohování';

  @override
  String get selectedFoldersWillBeEncryptedAndBackedUp =>
      'Vybrané složky budou šifrovány a zálohovány';

  @override
  String get unselectAll => 'Zrušit výběr';

  @override
  String get selectAll => 'Vybrat vše';

  @override
  String get skip => 'Přeskočit';

  @override
  String get updatingFolderSelection => 'Aktualizuji výběr složek...';

  @override
  String itemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count položek',
      few: '$count položky',
      one: '$count položka',
    );
    return '$_temp0';
  }

  @override
  String deleteItemCount({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Smazat $count položek',
      few: 'Smazat $count položky',
      one: 'Smazat $count položku',
    );
    return '$_temp0';
  }

  @override
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  }) {
    return '$count souborů, $formattedSize každý';
  }

  @override
  String get showMemories => 'Zobrazit vzpomínky';

  @override
  String yearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Před $count lety',
      one: 'Před $count rokem',
    );
    return '$_temp0';
  }

  @override
  String get backupSettings => 'Nastavení zálohování';

  @override
  String get backupStatus => 'Stav zálohování';

  @override
  String get backupStatusDescription =>
      'Položky, které byly zálohovány, se zobrazí zde';

  @override
  String get backupOverMobileData => 'Zálohovat přes mobilní data';

  @override
  String get backupVideos => 'Zálohovat videa';

  @override
  String get disableAutoLock => 'Zakázat zámek obrazovky';

  @override
  String get deviceLockExplanation =>
      'Deaktivujte zámek obrazovky zařízení, když je Ente v popředí a probíhá zálohování. To obvykle není nutné, ale může to pomoci urychlit velké nahrávání a počáteční import velkých knihoven.';

  @override
  String get about => 'O aplikaci';

  @override
  String get weAreOpenSource => 'Jsme open source!';

  @override
  String get privacy => 'Soukromí';

  @override
  String get terms => 'Podmínky';

  @override
  String get checkForUpdates => 'Zkontrolovat aktualizace';

  @override
  String get checkStatus => 'Zkontrolovat stav';

  @override
  String get checking => 'Probíhá kontrola...';

  @override
  String get youAreOnTheLatestVersion => 'Máte nejnovější verzi';

  @override
  String get account => 'Účet';

  @override
  String get manageSubscription => 'Spravovat předplatné';

  @override
  String get authToChangeYourEmail =>
      'Pro změnu e-mailové adresy se prosím ověřte';

  @override
  String get changePassword => 'Změnit heslo';

  @override
  String get authToChangeYourPassword => 'Pro změnu hesla se prosím ověřte';

  @override
  String get emailVerificationToggle => 'Ověření pomocí e-mailu';

  @override
  String get authToChangeEmailVerificationSetting =>
      'Pro změnu ověření pomocí emailu se musíte ověřit';

  @override
  String get exportYourData => 'Exportujte svá data';

  @override
  String get logout => 'Odhlásit se';

  @override
  String get authToInitiateAccountDeletion =>
      'Pro zahájení smazání účtu se prosím ověřte';

  @override
  String get areYouSureYouWantToLogout => 'Opravdu se chcete odhlásit?';

  @override
  String get yesLogout => 'Ano, odhlásit se';

  @override
  String get aNewVersionOfEnteIsAvailable => 'Je dostupná nová verze Ente.';

  @override
  String get update => 'Aktualizovat';

  @override
  String get installManually => 'Instalovat manuálně';

  @override
  String get criticalUpdateAvailable => 'K dispozici je důležitá aktualizace';

  @override
  String get updateAvailable => 'Je k dispozici aktualizace';

  @override
  String get ignoreUpdate => 'Ignorovat';

  @override
  String get downloading => 'Stahuji...';

  @override
  String get cannotDeleteSharedFiles => 'Sdílené soubory nelze odstranit';

  @override
  String get theDownloadCouldNotBeCompleted =>
      'Stahování nebylo možné dokončit';

  @override
  String get retry => 'Opakovat';

  @override
  String get backedUpFolders => 'Zálohované složky';

  @override
  String get backup => 'Zálohovat';

  @override
  String get freeUpDeviceSpace => 'Uvolnit místo na zařízení';

  @override
  String get freeUpDeviceSpaceDesc =>
      'Uvolněte místo ve svém zařízení vymazáním souborů, které již byly zálohovány.';

  @override
  String get allClear => '✨ Vše v pořádku';

  @override
  String get noDeviceThatCanBeDeleted =>
      'Na tomto zařízení nemáte žádné soubory, které by mohly být odstraněny';

  @override
  String get removeDuplicates => 'Odstranit duplicity';

  @override
  String get removeDuplicatesDesc =>
      'Zkontrolujte a odstraňte soubory, které jsou přesnými duplikáty.';

  @override
  String get viewLargeFiles => 'Velké soubory';

  @override
  String get viewLargeFilesDesc =>
      'Zobrazit soubory, které zabírají nejvíce místa v úložišti.';

  @override
  String get noDuplicates => '✨ Žádné duplicity';

  @override
  String get youveNoDuplicateFilesThatCanBeCleared =>
      'Nemáte žádné duplicitní soubory, které by mohly být odstraněny';

  @override
  String get success => 'Úspěch';

  @override
  String get rateUs => 'Ohodnoť nás';

  @override
  String get remindToEmptyDeviceTrash =>
      'Vyprázdněte také složku \"Nedávno smazané\" v části \"Nastavení\" -> \"Úložiště\", abyste uvolnili místo';

  @override
  String youHaveSuccessfullyFreedUp({required String storageSaved}) {
    return 'Úspěšně jste uvolnili $storageSaved!';
  }

  @override
  String get remindToEmptyEnteTrash =>
      'Vyprázdněte také \"Koš\", abyste získali uvolněné místo';

  @override
  String get sparkleSuccess => '✨ Úspěch';

  @override
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count duplicitních souborů',
      few: '$count duplicitní soubory',
      one: '$count duplicitní soubor',
    );
    return 'Vyčistili jste $_temp0, a ušetřili jste $storageSaved!';
  }

  @override
  String get familyPlans => 'Rodinné tarify';

  @override
  String get referrals => 'Doporučení';

  @override
  String get notifications => 'Notifikace';

  @override
  String get sharedPhotoNotifications => 'Nové sdílené fotky';

  @override
  String get sharedPhotoNotificationsExplanation =>
      'Dostávejte oznámení, když někdo přidá fotografii do sdíleného alba, jehož jste členem';

  @override
  String get advanced => 'Pokročilé';

  @override
  String get general => 'Obecné';

  @override
  String get security => 'Zabezpečení';

  @override
  String get authToViewYourRecoveryKey =>
      'Pro zobrazení vašeho obnovovacího klíče se prosím ověřte';

  @override
  String get twofactor => 'Dvoufázové';

  @override
  String get authToConfigureTwofactorAuthentication =>
      'Pro konfiguraci dvoufázového ověřování se prosím ověřte';

  @override
  String get lockscreen => 'Zámek obrazovky';

  @override
  String get authToChangeLockscreenSetting =>
      'Pro změnu nastavení uzamčení obrazovky se prosím ověřte';

  @override
  String get viewActiveSessions => 'Zobrazit aktivní relace';

  @override
  String get authToViewYourActiveSessions =>
      'Pro zobrazení aktivních relací se prosím ověřte';

  @override
  String get disableTwofactor => 'Vypnout dvoufázové ověřování';

  @override
  String get confirm2FADisable =>
      'Opravdu chcete deaktivovat dvoufázové ověřování?';

  @override
  String get no => 'Ne';

  @override
  String get yes => 'Ano';

  @override
  String get social => 'Sociální sítě';

  @override
  String rateUsOnStore({required Object storeName}) {
    return 'Ohodnoťte nás na $storeName';
  }

  @override
  String get blog => 'Blog';

  @override
  String get merchandise => 'E-shop';

  @override
  String get twitter => 'Twitter';

  @override
  String get mastodon => 'Mastodon';

  @override
  String get matrix => 'Matrix';

  @override
  String get discord => 'Discord';

  @override
  String get reddit => 'Reddit';

  @override
  String get yourStorageDetailsCouldNotBeFetched =>
      'Vaše údaje o úložišti nelze načíst';

  @override
  String get reportABug => 'Nahlásit chybu';

  @override
  String get reportBug => 'Nahlásit chybu';

  @override
  String get suggestFeatures => 'Navrhnout funkce';

  @override
  String get support => 'Podpora';

  @override
  String get theme => 'Motiv';

  @override
  String get lightTheme => 'Světlý';

  @override
  String get darkTheme => 'Tmavý';

  @override
  String get systemTheme => 'Systém';

  @override
  String get freeTrial => 'Bezplatná zkušební verze';

  @override
  String get selectYourPlan => 'Vyberte svůj tarif';

  @override
  String get enteSubscriptionPitch =>
      'Ente uchovává vaše vzpomínky, takže jsou vám vždy k dispozici, i když ztratíte své zařízení.';

  @override
  String get enteSubscriptionShareWithFamily =>
      'Do vašeho tarifu lze přidat i vaši rodinu.';

  @override
  String get currentUsageIs => 'Aktuálně využíváte ';

  @override
  String get faqs => 'Často kladené dotazy';

  @override
  String renewsOn({required Object endDate}) {
    return 'Předplatné se obnoví $endDate';
  }

  @override
  String freeTrialValidTill({required Object endDate}) {
    return 'Bezplatná zkušební verze platná do $endDate';
  }

  @override
  String validTill({required Object endDate}) {
    return 'Platné do $endDate';
  }

  @override
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  }) {
    return 'Váš doplněk $storageAmount je platný do $endDate';
  }

  @override
  String playStoreFreeTrialValidTill({required Object endDate}) {
    return 'Bezplatná zkušební verze platná do $endDate.\nPoté si můžete vybrat placený tarif.';
  }

  @override
  String subWillBeCancelledOn({required Object endDate}) {
    return 'Vaše předplatné bude zrušeno dne $endDate';
  }

  @override
  String get subscription => 'Předplatné';

  @override
  String get paymentDetails => 'Platební údaje';

  @override
  String get manageFamily => 'Spravovat rodinu';

  @override
  String contactToManageSubscription({required Object provider}) {
    return 'Kontaktujte nás na adrese support@ente.io, abyste mohli spravovat své předplatné $provider.';
  }

  @override
  String get renewSubscription => 'Obnovit předplatné';

  @override
  String get cancelSubscription => 'Zrušit předplatné';

  @override
  String get areYouSureYouWantToRenew => 'Opravdu chcete obnovit?';

  @override
  String get yesRenew => 'Ano, obnovit';

  @override
  String get areYouSureYouWantToCancel => 'Opravdu chcete zrušit?';

  @override
  String get yesCancel => 'Ano, zrušit';

  @override
  String get failedToRenew => 'Nepodařilo se obnovit';

  @override
  String get failedToCancel => 'Zrušení se nezdařilo';

  @override
  String get twoMonthsFreeOnYearlyPlans =>
      'Získejte 2 měsíce zdarma při ročních plánech';

  @override
  String get monthly => 'Měsíčně';

  @override
  String get yearly => 'Ročně';

  @override
  String get confirmPlanChange => 'Potvrdit změnu tarifu';

  @override
  String get areYouSureYouWantToChangeYourPlan =>
      'Opravdu chcete změnit svůj tarif?';

  @override
  String get youCannotDowngradeToThisPlan =>
      'Na tento nižší tarif nelze přejít';

  @override
  String cancelOtherSubscription({required String paymentProvider}) {
    return 'Nejprve zrušte své stávající předplatné u $paymentProvider';
  }

  @override
  String get optionalAsShortAsYouLike => 'Volitelné, tak krátké, jak chcete...';

  @override
  String get send => 'Odeslat';

  @override
  String get askCancelReason =>
      'Vaše předplatné bylo zrušeno. Chcete sdělit důvod?';

  @override
  String get thankYouForSubscribing => 'Děkujeme za aktivaci předplatného!';

  @override
  String get yourPurchaseWasSuccessful => 'Váš nákup byl úspěšný';

  @override
  String get yourPlanWasSuccessfullyUpgraded =>
      'Váš tarif byl úspěšně změněn na vyšší';

  @override
  String get yourPlanWasSuccessfullyDowngraded =>
      'Váš tarif byl úspěšně změněn na nižší';

  @override
  String get yourSubscriptionWasUpdatedSuccessfully =>
      'Vaše předplatné bylo úspěšně aktualizováno';

  @override
  String get googlePlayId => 'Google Play ID';

  @override
  String get appleId => 'Apple ID';

  @override
  String get playstoreSubscription => 'Předplatné PlayStore';

  @override
  String get appstoreSubscription => 'Předplatné AppStore';

  @override
  String subAlreadyLinkedErrMessage({required Object id}) {
    return 'Vaše $id je již propojeno s jiným účtem Ente.\nPokud chcete použít své $id s tímto účtem, kontaktujte prosím naši podporu';
  }

  @override
  String get visitWebToManage =>
      'Pro správu předplatného navštivte web.ente.io';

  @override
  String get couldNotUpdateSubscription => 'Předplatné nelze aktualizovat';

  @override
  String get pleaseContactSupportAndWeWillBeHappyToHelp =>
      'Kontaktujte nás na adrese support@ente.io a rádi Vám pomůžeme!';

  @override
  String get paymentFailed => 'Platba se nezdařila';

  @override
  String paymentFailedTalkToProvider({required String providerName}) {
    return 'Pokud vám byla účtována platba, obraťte se na podporu $providerName';
  }

  @override
  String get continueOnFreeTrial => 'Pokračovat v bezplatné zkušební verzi';

  @override
  String get areYouSureYouWantToExit => 'Určitě chcete odejít?';

  @override
  String get thankYou => 'Děkujeme';

  @override
  String get failedToVerifyPaymentStatus => 'Nepodařilo se ověřit stav platby';

  @override
  String get pleaseWaitForSometimeBeforeRetrying =>
      'Počkejte prosím chvíli a zkuste to znovu';

  @override
  String get paymentFailedMessage =>
      'Vaše platba se bohužel nezdařila. Kontaktujte prosím podporu a my vám pomůžeme!';

  @override
  String get youAreOnAFamilyPlan => 'Máte rodinný tarif!';

  @override
  String contactFamilyAdmin({required Object familyAdminEmail}) {
    return 'Pro správu předplatného kontaktujte <green>$familyAdminEmail</green>';
  }

  @override
  String get leaveFamily => 'Opustit rodinu';

  @override
  String get areYouSureThatYouWantToLeaveTheFamily =>
      'Opravdu chcete opustit rodinný tarif?';

  @override
  String get leave => 'Odejít';

  @override
  String get rateTheApp => 'Ohodnotit aplikaci';

  @override
  String get startBackup => 'Spustit zálohování';

  @override
  String get noPhotosAreBeingBackedUpRightNow =>
      'Momentálně nejsou zálohovány žádné fotky';

  @override
  String get preserveMore => 'Zachovat více';

  @override
  String get grantFullAccessPrompt =>
      'Povolte přístup ke všem fotkám v aplikaci Nastavení';

  @override
  String get allowPermTitle => 'Povolit přístup k fotografiím';

  @override
  String get allowPermBody =>
      'Povolte v nastavení přístup k vašim fotkám, aby Ente mohl zobrazit a zálohovat vaši knihovnu.';

  @override
  String get openSettings => 'Otevřít Nastavení';

  @override
  String get selectMorePhotos => 'Vybrat více fotografií';

  @override
  String get existingUser => 'Existující uživatel';

  @override
  String get privateBackups => 'Soukromé zálohy';

  @override
  String get forYourMemories => 'pro vaše vzpomínky';

  @override
  String get endtoendEncryptedByDefault =>
      'Koncově šifrováno ve výchozím nastavení';

  @override
  String get safelyStored => 'Bezpečně uloženo';

  @override
  String get atAFalloutShelter => 'v protiatomovém krytu';

  @override
  String get designedToOutlive => 'Navrženo k přežití';

  @override
  String get available => 'Dostupné';

  @override
  String get everywhere => 'všude';

  @override
  String get androidIosWebDesktop => 'Android, iOS, Web, Desktop';

  @override
  String get mobileWebDesktop => 'Mobile, Web, Desktop';

  @override
  String get newToEnte => 'Nový uživatel Ente';

  @override
  String get pleaseLoginAgain => 'Prosím, přihlaste se znovu';

  @override
  String get autoLogoutMessage =>
      'Z důvodu technické poruchy jste byli odhlášeni. Omlouváme se za způsobené nepříjemnosti.';

  @override
  String get yourSubscriptionHasExpired => 'Vaše předplatné vypršelo';

  @override
  String get storageLimitExceeded => 'Překročen limit úložiště';

  @override
  String get upgrade => 'Upgradovat';

  @override
  String get raiseTicket => 'Vytvořit ticket';

  @override
  String get backupFailed => 'Záloha se nezdařila';

  @override
  String get sorryBackupFailedDesc =>
      'Omlouváme se, tento soubor nelze právě teď zálohovat. Zkusíme to znovu později.';

  @override
  String get couldNotBackUpTryLater =>
      'Vaše data se nepodařilo zálohovat.\nZkusíme to znovu později.';

  @override
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant =>
      'Ente může šifrovat a uchovávat soubory pouze v případě, že mu k nim udělíte přístup';

  @override
  String get pleaseGrantPermissions => 'Prosím, udělte oprávnění';

  @override
  String get grantPermission => 'Udělit oprávnění';

  @override
  String get privateSharing => 'Soukromé sdílení';

  @override
  String get shareOnlyWithThePeopleYouWant =>
      'Sdílejte pouze s lidmi, které chcete';

  @override
  String get usePublicLinksForPeopleNotOnEnte =>
      'Používejte veřejné odkazy pro osoby, které nejsou na Ente';

  @override
  String get allowPeopleToAddPhotos => 'Umožnit lidem přidávat fotografie';

  @override
  String get shareAnAlbumNow => 'Sdílejte album nyní';

  @override
  String get collectEventPhotos => 'Shromáždit fotografie z akce';

  @override
  String get sessionExpired => 'Relace vypršela';

  @override
  String get loggingOut => 'Odhlašování...';

  @override
  String get onDevice => 'V zařízení';

  @override
  String get onEnte => 'Na <branding>ente</branding>';

  @override
  String get name => 'Název';

  @override
  String get newest => 'Nejnovější';

  @override
  String get lastUpdated => 'Naposledy aktualizováno';

  @override
  String get deleteEmptyAlbums => 'Smazat prázdná alba';

  @override
  String get deleteEmptyAlbumsWithQuestionMark => 'Smazat prázdná alba?';

  @override
  String get deleteAlbumsDialogBody =>
      'Tím se odstraní všechna prázdná alba. To je užitečné, pokud chcete zredukovat nepořádek ve vašem seznamu alb.';

  @override
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  }) {
    return 'Mazání $currentlyDeleting / $totalCount';
  }

  @override
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  }) {
    return 'Zpracování $currentlyProcessing / $totalCount';
  }

  @override
  String get permanentlyDelete => 'Trvale odstranit';

  @override
  String get canOnlyCreateLinkForFilesOwnedByYou =>
      'Můžete vytvářet odkazy pouze na soubory, které vlastníte';

  @override
  String get publicLinkCreated => 'Veřejný odkaz vytvořen';

  @override
  String get youCanManageYourLinksInTheShareTab =>
      'Své odkazy můžete spravovat na kartě Sdílení.';

  @override
  String get linkCopiedToClipboard => 'Odkaz zkopírován do schránky';

  @override
  String get restore => 'Obnovit';

  @override
  String get moveToAlbum => 'Přesunout do alba';

  @override
  String get unhide => 'Odkrýt';

  @override
  String get unarchive => 'Zrušit archivaci';

  @override
  String get favorite => 'Oblíbené';

  @override
  String get removeFromFavorite => 'Odebrat z oblíbených';

  @override
  String get shareLink => 'Sdílet odkaz';

  @override
  String get createCollage => 'Vytvořit koláž';

  @override
  String get saveCollage => 'Uložit koláž';

  @override
  String get collageSaved => 'Koláž uložena do galerie';

  @override
  String get collageLayout => 'Rozvržení';

  @override
  String get addToEnte => 'Přidat do Ente';

  @override
  String get addToAlbum => 'Přidat do alba';

  @override
  String get delete => 'Smazat';

  @override
  String get hide => 'Skrýt';

  @override
  String get share => 'Sdílet';

  @override
  String get unhideToAlbum => 'Odkrýt do alba';

  @override
  String get restoreToAlbum => 'Obnovit do alba';

  @override
  String moveItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Přesunout položky',
      one: 'Přesunout položku',
    );
    return '$_temp0';
  }

  @override
  String addItem({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Přidat položky',
      one: 'Přidat položku',
    );
    return '$_temp0';
  }

  @override
  String get createOrSelectAlbum => 'Vytvořit nebo vybrat album';

  @override
  String get selectAlbum => 'Vybrat album';

  @override
  String get searchByAlbumNameHint => 'Název alba';

  @override
  String get albumTitle => 'Název alba';

  @override
  String get enterAlbumName => 'Zadejte název alba';

  @override
  String get restoringFiles => 'Obnovuji soubory...';

  @override
  String get movingFilesToAlbum => 'Přesouvání souborů do alba...';

  @override
  String get unhidingFilesToAlbum => 'Odkrývám soubory do alba';

  @override
  String get canNotUploadToAlbumsOwnedByOthers =>
      'Nelze nahrávat do alb, která vlastní jiní uživatelé';

  @override
  String get uploadingFilesToAlbum => 'Nahrávání souborů do alba...';

  @override
  String addedSuccessfullyTo({required Object albumName}) {
    return 'Úspěšně přidáno do $albumName';
  }

  @override
  String movedSuccessfullyTo({required Object albumName}) {
    return 'Úspěšně přesunuto do $albumName';
  }

  @override
  String get thisAlbumAlreadyHDACollaborativeLink =>
      'Toto album již má odkaz na spolupráci';

  @override
  String collaborativeLinkCreatedFor({required Object albumName}) {
    return 'Odkaz na spolupráci vytvořen pro $albumName';
  }

  @override
  String get askYourLovedOnesToShare => 'Požádejte své blízké o sdílení';

  @override
  String get invite => 'Pozvat';

  @override
  String get shareYourFirstAlbum => 'Sdílet své první album';

  @override
  String sharedWith({required Object emailIDs}) {
    return 'Sdíleno s $emailIDs';
  }

  @override
  String get sharedWithMe => 'Sdíleno se mnou';

  @override
  String get sharedByMe => 'Sdíleno mnou';

  @override
  String get doubleYourStorage => 'Zdvojnásobte své úložiště';

  @override
  String get referFriendsAnd2xYourPlan =>
      'Doporučte přátele a zdvojnásobte svůj tarif';

  @override
  String get shareAlbumHint =>
      'Otevřete album a klepněte na tlačítko sdílení v pravém horním rohu, abyste jej sdíleli.';

  @override
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion =>
      'Položky zobrazují počet dní zbývajících do trvalého smazání';

  @override
  String trashDaysLeft({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count dní',
      few: '$count dny',
      one: '1 den',
      zero: 'Brzy',
    );
    return '$_temp0';
  }

  @override
  String get deleteAll => 'Smazat vše';

  @override
  String get renameAlbum => 'Přejmenovat album';

  @override
  String get convertToAlbum => 'Převést na album';

  @override
  String get setCover => 'Nastavit úvodní fotku';

  @override
  String get sortAlbumsBy => 'Seřadit podle';

  @override
  String get sortNewestFirst => 'Od nejnovějších';

  @override
  String get sortOldestFirst => 'Od nejstarších';

  @override
  String get rename => 'Přejmenovat';

  @override
  String get leaveSharedAlbum => 'Opustit sdílené album?';

  @override
  String get leaveAlbum => 'Opustit album';

  @override
  String get photosAddedByYouWillBeRemovedFromTheAlbum =>
      'Fotografie, které jste přidali, budou z alba odstraněny';

  @override
  String get youveNoFilesInThisAlbumThatCanBeDeleted =>
      'V tomto albu nemáte žádné soubory, které lze smazat';

  @override
  String get youDontHaveAnyArchivedItems => 'Nemáte žádné archivované položky.';

  @override
  String get ignoredFolderUploadReason =>
      'Některé soubory v tomto albu jsou při nahrávání ignorovány, protože byly dříve odstraněny z Ente.';

  @override
  String get resetIgnoredFiles => 'Obnovit ignorované soubory';

  @override
  String get deviceFilesAutoUploading =>
      'Soubory přidané do tohoto alba zařízení se automaticky nahrají do Ente.';

  @override
  String get turnOnBackupForAutoUpload =>
      'Zapněte zálohování, aby se soubory přidané do této složky zařízení automaticky nahrávaly do Ente.';

  @override
  String get noHiddenPhotosOrVideos => 'Žádné skryté fotografie ani videa';

  @override
  String get toHideAPhotoOrVideo => 'Pro skrytí fotky nebo videa';

  @override
  String get openTheItem => '• Otevřete položku';

  @override
  String get clickOnTheOverflowMenu => '• Klikněte na rozbalovací nabídku';

  @override
  String get click => '• Klikněte';

  @override
  String get nothingToSeeHere => 'Tady není nic k vidění! 👀';

  @override
  String get unarchiveAlbum => 'Odarchivovat album';

  @override
  String get archiveAlbum => 'Archivovat album';

  @override
  String get calculating => 'Probíhá výpočet...';

  @override
  String get pleaseWaitDeletingAlbum => 'Čekejte prosím, mazání alba';

  @override
  String get searchByExamples =>
      '• Názvy alb (např. „Fotoaparát“)\n• Typy souborů (např. „Videa“, „.gif“)\n• Roky a měsíce (např. „2022“, „leden“)\n• Svátky (např. „Vánoce“)\n• Popisy fotografií (např. „#zábava“)';

  @override
  String get youCanTrySearchingForADifferentQuery =>
      'Můžete zkusit zadat jiný dotaz.';

  @override
  String get noResultsFound => 'Nebyly nalezeny žádné výsledky';

  @override
  String addedBy({required Object emailOrName}) {
    return 'Přidáno uživatelem $emailOrName';
  }

  @override
  String get loadingExifData => 'Načítání dat EXIF...';

  @override
  String get viewAllExifData => 'Zobrazit všechna data EXIF';

  @override
  String get noExifData => 'Žádná data EXIF';

  @override
  String get thisImageHasNoExifData => 'Tento obrázek nemá žádné údaje exif';

  @override
  String get exif => 'EXIF';

  @override
  String get noResults => 'Žádné výsledky';

  @override
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont =>
      'Zatím nepodporujeme úpravy fotografií a alb, která nevlastníte';

  @override
  String get failedToFetchOriginalForEdit =>
      'Nepodařilo se načíst originál pro úpravy';

  @override
  String get close => 'Zavřít';

  @override
  String get setAs => 'Nastavit jako';

  @override
  String get fileSavedToGallery => 'Soubor uložen do galerie';

  @override
  String get filesSavedToGallery => 'Soubory uloženy do galerie';

  @override
  String get fileFailedToSaveToGallery =>
      'Nepodařilo se uložit soubor do galerie';

  @override
  String get download => 'Stáhnout';

  @override
  String get pressAndHoldToPlayVideo =>
      'Stiskněte a podržte pro přehrání videa';

  @override
  String get pressAndHoldToPlayVideoDetailed =>
      'Stiskněte a podržte prst na obrázku, aby se spustilo přehrávání videa';

  @override
  String get downloadFailed => 'Stahování selhalo';

  @override
  String get deduplicateFiles => 'Duplicitní soubory';

  @override
  String get deselectAll => 'Zrušit výběr všech';

  @override
  String get reviewDeduplicateItems =>
      'Prosím, zkontrolujte a smažte položky, které považujete za duplicitní.';

  @override
  String get clubByCaptureTime => 'Seskupit podle doby zachycení';

  @override
  String get clubByFileName => 'Seskupit podle názvu souboru';

  @override
  String get count => 'Počet';

  @override
  String get totalSize => 'Celková velikost';

  @override
  String get longpressOnAnItemToViewInFullscreen =>
      'Dlouhým stiskem na položku zobrazíte v režimu celé obrazovky';

  @override
  String get decryptingVideo => 'Dešifrování videa...';

  @override
  String get authToViewYourMemories =>
      'Pro zobrazení svých vzpomínek se prosím ověřte';

  @override
  String get unlock => 'Odemknout';

  @override
  String get freeUpSpace => 'Uvolnit místo';

  @override
  String freeUpSpaceSaving({
    required num count,
    required Object formattedSize,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other:
          'Lze je odstranit ze zařízení, aby se uvolnilo $formattedSize místa',
      one:
          'Lze jej odstranit ze zařízení, aby se uvolnilo $formattedSize místa',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$formattedNumber souborů v tomto albu bylo bezpečně zálohováno',
      few: '$formattedNumber soubory v tomto albu byly bezpečně zálohovány',
      one: '1 soubor v tomto albu byl bezpečně zálohován',
    );
    return '$_temp0';
  }

  @override
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other:
          '$formattedNumber souborů na tomto zařízení bylo bezpečně zálohováno',
      few:
          '$formattedNumber soubory na tomto zařízení byly bezpečně zálohovány',
      one: '1 soubor na tomto zařízení byl bezpečně zálohován',
    );
    return '$_temp0';
  }

  @override
  String freeUpAccessPostDelete({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'nim',
      one: 'němu',
    );
    return 'Stále k $_temp0 máte přístup na Ente, pokud máte aktivní předplatné';
  }

  @override
  String freeUpAmount({required Object sizeInMBorGB}) {
    return 'Uvolnit $sizeInMBorGB';
  }

  @override
  String get thisEmailIsAlreadyInUse =>
      'Tato e-mailová adresa je již používána';

  @override
  String get incorrectCode => 'Nesprávný kód';

  @override
  String get authenticationFailedPleaseTryAgain =>
      'Přihlášení se nezdařilo, zkuste to znovu';

  @override
  String get verificationFailedPleaseTryAgain =>
      'Ověření se nezdařilo, zkuste to znovu';

  @override
  String get authenticating => 'Ověřování...';

  @override
  String get authenticationSuccessful => 'Ověření bylo úspěšné!';

  @override
  String get incorrectRecoveryKey => 'Nesprávný obnovovací klíč';

  @override
  String get theRecoveryKeyYouEnteredIsIncorrect =>
      'Vámi zadaný obnovovací klíč je nesprávný';

  @override
  String get twofactorAuthenticationSuccessfullyReset =>
      'Dvoufázové ověření bylo úspěšně obnoveno';

  @override
  String get pleaseVerifyTheCodeYouHaveEntered =>
      'Zkontrolujte prosím kód, který jste zadali';

  @override
  String get pleaseContactSupportIfTheProblemPersists =>
      'Pokud problém přetrvává, kontaktujte prosím podporu';

  @override
  String get twofactorAuthenticationHasBeenDisabled =>
      'Dvoufázové ověřování bylo deaktivováno';

  @override
  String get sorryTheCodeYouveEnteredIsIncorrect =>
      'Omlouváme se, zadaný kód je nesprávný';

  @override
  String get yourVerificationCodeHasExpired => 'Váš ověřovací kód vypršel';

  @override
  String emailChangedTo({required Object newEmail}) {
    return 'E-mail změněn na $newEmail';
  }

  @override
  String get verifying => 'Ověřování...';

  @override
  String get disablingTwofactorAuthentication =>
      'Vypínání dvoufázového ověřování...';

  @override
  String get allMemoriesPreserved => 'Všechny vzpomínky zachovány';

  @override
  String get loadingGallery => 'Načítání galerie...';

  @override
  String get syncing => 'Synchronizace...';

  @override
  String get encryptingBackup => 'Šifrování zálohy...';

  @override
  String get syncStopped => 'Synchronizace zastavena';

  @override
  String syncProgress({required String completed, required String total}) {
    return '$completed/$total vzpomínek zachováno';
  }

  @override
  String uploadingMultipleMemories({required String count}) {
    return 'Zachování $count vzpomínek...';
  }

  @override
  String get uploadingSingleMemory => 'Zachování 1 vzpomínky...';

  @override
  String get archiving => 'Archivování...';

  @override
  String get unarchiving => 'Probíhá odebírání z archivu...';

  @override
  String get successfullyArchived => 'Úspěšně archivováno';

  @override
  String get successfullyUnarchived => 'Úspěšně odebráno z archivu';

  @override
  String get renameFile => 'Přejmenovat soubor';

  @override
  String get enterFileName => 'Zadejte název souboru';

  @override
  String get filesDeleted => 'Soubory odstraněny';

  @override
  String get selectedFilesAreNotOnEnte => 'Vybrané soubory nejsou na Ente';

  @override
  String get thisActionCannotBeUndone => 'Tuto akci nelze vrátit zpět';

  @override
  String get emptyTrash => 'Vyprázdnit koš?';

  @override
  String get permDeleteWarning =>
      'Veškeré položky v koši budou trvale smazány\n\nTuto akci nelze vrátit zpět';

  @override
  String get empty => 'Vyprázdnit';

  @override
  String get couldNotFreeUpSpace => 'Nelze uvolnit místo';

  @override
  String get permanentlyDeleteFromDevice => 'Trvale smazat ze zařízení?';

  @override
  String get someOfTheFilesYouAreTryingToDeleteAre =>
      'Některé soubory, které se pokoušíte smazat, jsou dostupné pouze na vašem zařízení a po smazání je nelze obnovit';

  @override
  String get theyWillBeDeletedFromAllAlbums => 'Budou odstraněny ze všech alb.';

  @override
  String get someItemsAreInBothEnteAndYourDevice =>
      'Některé položky jsou jak v Ente, tak ve vašem zařízení.';

  @override
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved =>
      'Vybrané položky budou odstraněny ze všech alb a přesunuty do koše.';

  @override
  String get theseItemsWillBeDeletedFromYourDevice =>
      'Tyto položky budou z vašeho zařízení odstraněny.';

  @override
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome =>
      'Zdá se, že došlo k chybě. Zkuste to prosím znovu později. Pokud chyba přetrvává, kontaktujte prosím náš tým podpory.';

  @override
  String get error => 'Chyba';

  @override
  String get tempErrorContactSupportIfPersists =>
      'Zdá se, že došlo k chybě. Zkuste to prosím znovu později. Pokud chyba přetrvává, kontaktujte prosím náš tým podpory.';

  @override
  String get networkHostLookUpErr =>
      'Nelze se připojit k Ente. Zkontrolujte nastavení sítě a pokud chyba přetrvává, kontaktujte podporu.';

  @override
  String get networkConnectionRefusedErr =>
      'Nelze se připojit k Ente, zkuste to prosím znovu později. Pokud chyba přetrvává, kontaktujte prosím podporu.';

  @override
  String get cachedData => 'Data uložená v mezipaměti';

  @override
  String get clearCaches => 'Vymazat mezipaměť';

  @override
  String get remoteImages => 'Vzdálené obrázky';

  @override
  String get remoteVideos => 'Vzdálená videa';

  @override
  String get remoteThumbnails => 'Vzdálené miniatury';

  @override
  String get pendingSync => 'Čeká na synchronizaci';

  @override
  String get localGallery => 'Místní galerie';

  @override
  String get todaysLogs => 'Dnešní záznamy';

  @override
  String get viewLogs => 'Zobrazit záznamy';

  @override
  String get logsDialogBody =>
      'Tím se odešlou protokoly, které nám pomohou vyřešit váš problém. Upozorňujeme, že budou zahrnuty názvy souborů, aby bylo možné sledovat problémy s konkrétními soubory.';

  @override
  String get preparingLogs => 'Příprava záznamů...';

  @override
  String get emailYourLogs => 'Zašlete své protokoly e-mailem';

  @override
  String pleaseSendTheLogsTo({required Object toEmail}) {
    return 'Záznamy prosím zašlete na adresu \n$toEmail';
  }

  @override
  String get copyEmailAddress => 'Zkopírovat e-mailovou adresu';

  @override
  String get exportLogs => 'Exportovat logy';

  @override
  String pleaseEmailUsAt({required Object toEmail}) {
    return 'Prosím, pošlete nám e-mail na adresu $toEmail';
  }

  @override
  String get dismiss => 'Zrušit';

  @override
  String get didYouKnow => 'Věděli jste?';

  @override
  String get loadingMessage => 'Načítání vašich fotografií...';

  @override
  String get loadMessage1 => 'Své předplatné můžete sdílet se svou rodinou';

  @override
  String get loadMessage2 =>
      'Dosud jsme uchovali více než 200 milionů vzpomínek';

  @override
  String get loadMessage3 =>
      'Vaše data uchováváme ve 3 kopiích, z nichž jedna je uložena v podzemním protiatomovém krytu';

  @override
  String get loadMessage4 => 'Všechny naše aplikace jsou open source';

  @override
  String get loadMessage5 =>
      'Náš zdrojový kód a kryptografie byly podrobeny externímu auditu';

  @override
  String get loadMessage6 =>
      'Můžete sdílet odkazy na svá alba se svými blízkými';

  @override
  String get loadMessage7 =>
      'Naše mobilní aplikace běží na pozadí, šifruje a zálohuje všechny nové fotografie, které pořídíte';

  @override
  String get loadMessage8 =>
      'web.ente.io má šikovný nástroj pro nahrávání souborů';

  @override
  String get loadMessage9 =>
      'K bezpečnému šifrování vašich dat používáme Xchacha20Poly1305';

  @override
  String get photoDescriptions => 'Popisky fotografií';

  @override
  String get fileTypesAndNames => 'Typy a názvy souborů';

  @override
  String get location => 'Poloha';

  @override
  String get moments => 'Momenty';

  @override
  String get searchFaceEmptySection =>
      'Po dokončení indexování se zde zobrazí lidé';

  @override
  String get searchDatesEmptySection => 'Hledat podle data, měsíce nebo roku';

  @override
  String get searchLocationEmptySection =>
      'Seskupte fotografie pořízené v určitém okruhu od fotografie';

  @override
  String get searchPeopleEmptySection =>
      'Pozvěte kamarády a uvidíte všechny fotografie, které zde sdíleli';

  @override
  String get searchAlbumsEmptySection => 'Alba';

  @override
  String get searchFileTypesAndNamesEmptySection => 'Typy a názvy souborů';

  @override
  String get searchCaptionEmptySection =>
      'Přidejte do informací o fotografii popisky jako \"#výlet\", abyste je zde mohli rychle najít';

  @override
  String get language => 'Jazyk';

  @override
  String get selectLanguage => 'Vybrat jazyk';

  @override
  String get locationName => 'Název místa';

  @override
  String get addLocation => 'Přidat polohu';

  @override
  String get groupNearbyPhotos => 'Seskupit fotografie pořízené v okolí';

  @override
  String get kiloMeterUnit => 'km';

  @override
  String get addLocationButton => 'Přidat';

  @override
  String get radius => 'Rádius';

  @override
  String get locationTagFeatureDescription =>
      'Značka polohy seskupuje všechny fotografie, které byly pořízeny v určitém okruhu od fotografie';

  @override
  String get galleryMemoryLimitInfo =>
      'Až 1000 vzpomínek zobrazených v galerii';

  @override
  String get save => 'Uložit';

  @override
  String get centerPoint => 'Středový bod';

  @override
  String get pickCenterPoint => 'Vyberte středový bod';

  @override
  String get useSelectedPhoto => 'Použít vybranou fotografii';

  @override
  String get resetToDefault => 'Obnovit výchozí';

  @override
  String get edit => 'Upravit';

  @override
  String get deleteLocation => 'Odstranit polohu';

  @override
  String get rotateLeft => 'Otočit doleva';

  @override
  String get flip => 'Překlopit';

  @override
  String get rotateRight => 'Otočit doprava';

  @override
  String get saveCopy => 'Uložit kopii';

  @override
  String get light => 'Světlý';

  @override
  String get color => 'Barva';

  @override
  String get yesDiscardChanges => 'Ano, zahodit změny';

  @override
  String get doYouWantToDiscardTheEditsYouHaveMade =>
      'Chcete zrušit provedené úpravy?';

  @override
  String get saving => 'Ukládání...';

  @override
  String get editsSaved => 'Úpravy uloženy';

  @override
  String get oopsCouldNotSaveEdits => 'Jejda, nelze uložit úpravy';

  @override
  String get distanceInKMUnit => 'km';

  @override
  String get dayToday => 'Dnes';

  @override
  String get dayYesterday => 'Včera';

  @override
  String get storage => 'Úložiště';

  @override
  String get usedSpace => 'Využité místo';

  @override
  String get storageBreakupFamily => 'Rodina';

  @override
  String get storageBreakupYou => 'Vy';

  @override
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  }) {
    return '$usedAmount $usedStorageUnit z $totalAmount $totalStorageUnit použito';
  }

  @override
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  }) {
    return '$freeAmount $storageUnit volných';
  }

  @override
  String appVersion({required Object versionValue}) {
    return 'Verze: $versionValue';
  }

  @override
  String get verifyIDLabel => 'Ověřit';

  @override
  String get fileInfoAddDescHint => 'Přidat popis...';

  @override
  String get editLocationTagTitle => 'Upravit lokalitu';

  @override
  String get setLabel => 'Nastavit';

  @override
  String get setRadius => 'Nastavit poloměr';

  @override
  String get familyPlanPortalTitle => 'Rodina';

  @override
  String get familyPlanOverview =>
      'Přidejte 5 členů rodiny do svého stávajícího tarifu bez dalších poplatků.\n\nKaždý člen dostane svůj vlastní soukromý prostor a nemůže vidět soubory ostatních členů, pokud nejsou sdílené.\n\nRodinné tarify jsou k dispozici zákazníkům, kteří mají placené předplatné Ente.\n\nPřihlaste se k odběru a začněte hned teď!';

  @override
  String get androidBiometricHint => 'Ověřte svou identitu';

  @override
  String get androidBiometricNotRecognized => 'Nerozpoznáno. Zkuste znovu.';

  @override
  String get androidBiometricSuccess => 'Úspěch';

  @override
  String get androidCancelButton => 'Zrušit';

  @override
  String get androidSignInTitle => 'Je požadováno ověření';

  @override
  String get androidBiometricRequiredTitle =>
      'Je požadováno biometrické ověření';

  @override
  String get androidDeviceCredentialsRequiredTitle =>
      'Jsou vyžadovány přihlašovací údaje zařízení';

  @override
  String get androidDeviceCredentialsSetupDescription =>
      'Jsou vyžadovány přihlašovací údaje zařízení';

  @override
  String get goToSettings => 'Přejít do nastavení';

  @override
  String get androidGoToSettingsDescription =>
      'Biometrické ověřování není na vašem zařízení nastaveno. Přejděte do části \"Nastavení\" > \"Zabezpečení\" a přidejte biometrické ověřování.';

  @override
  String get iOSLockOut =>
      'Biometrické ověřování je deaktivováno. Chcete-li jej aktivovat, uzamkněte a odemkněte obrazovku.';

  @override
  String get iOSGoToSettingsDescription =>
      'Biometrické ověřování není na vašem zařízení nastaveno. Povolte prosím Touch ID nebo Face ID na svém telefonu.';

  @override
  String get iOSOkButton => 'OK';

  @override
  String get openstreetmapContributors => 'Přispěvatelé OpenStreetMap';

  @override
  String get hostedAtOsmFrance => 'Hostováno na OSM France';

  @override
  String get map => 'Mapa';

  @override
  String get maps => 'Mapy';

  @override
  String get mapsPrivacyNotice =>
      'Approximate coordinates will be sent to privacy conscious third parties like OpenStreetMap to show the map and location.';

  @override
  String get enableMaps => 'Povolit mapy';

  @override
  String get quickLinks => 'Rychlé odkazy';

  @override
  String get selectItemsToAdd => 'Vyberte položky, které chcete přidat';

  @override
  String get addSelected => 'Přidat vybrané';

  @override
  String get addFromDevice => 'Přidat ze zařízení';

  @override
  String get addPhotos => 'Přidat fotky';

  @override
  String get noPhotosFoundHere => 'Zde nebyly nalezeny žádné fotky';

  @override
  String get zoomOutToSeePhotos =>
      'Zmenšete zobrazení, abyste viděli fotografie';

  @override
  String get noImagesWithLocation => 'Žádné obrázky s polohou';

  @override
  String get unpinAlbum => 'Odepnout album';

  @override
  String get pinAlbum => 'Připnout album';

  @override
  String get pin => 'Pin';

  @override
  String get pinPerson => 'Pin person';

  @override
  String get pinToTop => 'Pin to top';

  @override
  String get unpin => 'Unpin';

  @override
  String get unpinPerson => 'Unpin person';

  @override
  String get visibility => 'Visibility';

  @override
  String get hideFromMemories => 'Hide from memories';

  @override
  String get showInMemories => 'Show in memories';

  @override
  String get create => 'Vytvořit';

  @override
  String get viewAll => 'Zobrazit vše';

  @override
  String get nothingSharedWithYouYet => 'Zatím s vámi nebylo nic sdíleno';

  @override
  String get noAlbumsSharedByYouYet => 'Zatím nemáte žádná sdílená alba';

  @override
  String get sharedWithYou => 'Sdíleno s vámi';

  @override
  String get sharedByYou => 'Sdíleno vámi';

  @override
  String get inviteYourFriendsToEnte => 'Pozvěte své přátelé do Ente';

  @override
  String get failedToDownloadVideo => 'Stahování videa se nezdařilo';

  @override
  String get hiding => 'Skrývání...';

  @override
  String get unhiding => 'Odkrývání...';

  @override
  String get successfullyHid => 'Úspěšně skryto';

  @override
  String get successfullyUnhid => 'Úspěšně odkryto';

  @override
  String get crashReporting => 'Hlášení o pádu';

  @override
  String get resumableUploads => 'Obnovitelné nahrávání';

  @override
  String get addToHiddenAlbum => 'Přidat do skrytého alba';

  @override
  String get moveToHiddenAlbum => 'Přesunout do skrytého alba';

  @override
  String get fileTypes => 'Typy souboru';

  @override
  String get deleteConfirmDialogBody =>
      'Tento účet je propojen s dalšími aplikacemi Ente, pokud je používáte. Vaše nahraná data ve všech aplikacích Ente budou naplánována k odstranění a váš účet bude trvale smazán.';

  @override
  String get hearUsWhereTitle =>
      'Jak jste se dozvěděli o společnosti Ente? (volitelné)';

  @override
  String get hearUsExplanation =>
      'Nesledujeme instalace aplikací. Pomohlo by, kdybyste nám řekli, kde jste nás našli!';

  @override
  String get viewAddOnButton => 'Zobrazit doplňky';

  @override
  String get addOns => 'Doplňky';

  @override
  String get addOnPageSubtitle => 'Podrobnosti o doplňcích';

  @override
  String get yourMap => 'Vaše mapa';

  @override
  String get modifyYourQueryOrTrySearchingFor =>
      'Upravte svůj dotaz nebo zkuste vyhledat';

  @override
  String get blackFridaySale => 'Slevy Black Friday';

  @override
  String get upto50OffUntil4thDec => 'Sleva až 50%, do 4. prosince.';

  @override
  String get photos => 'Fotky';

  @override
  String get videos => 'Videa';

  @override
  String get livePhotos => 'Živé fotky';

  @override
  String get searchHint1 => 'Rychlé vyhledávání přímo v zařízení';

  @override
  String get searchHint2 => 'Data fotografií, popisy';

  @override
  String get searchHint3 => 'Alba, názvy souborů a typy';

  @override
  String get searchHint4 => 'Poloha';

  @override
  String get searchHint5 => 'Již brzy: Kouzelné vyhledávání tváří ✨';

  @override
  String get addYourPhotosNow => 'Přidejte své fotografie nyní';

  @override
  String searchResultCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Nalezeno $count výsledků',
      few: 'Nalezeny $count výsledky',
      one: 'Nalezen $count výsledek',
    );
    return '$_temp0';
  }

  @override
  String get faces => 'Obličeje';

  @override
  String get people => 'Lidé';

  @override
  String get contents => 'Obsah';

  @override
  String get addNew => 'Přidat nový';

  @override
  String get contacts => 'Kontakty';

  @override
  String get noInternetConnection => 'Žádné připojení k internetu';

  @override
  String get pleaseCheckYourInternetConnectionAndTryAgain =>
      'Zkontrolujte prosím připojení k internetu a zkuste to znovu.';

  @override
  String get signOutFromOtherDevices => 'Odhlásit se z jiných zařízení';

  @override
  String get signOutOtherBody =>
      'Pokud se domníváte, že někdo zná vaše heslo, můžete vynutit odhlášení všech ostatních zařízení, která používají váš účet.';

  @override
  String get signOutOtherDevices => 'Odhlásit ostatní zařízení';

  @override
  String get doNotSignOut => 'Neodhlašovat';

  @override
  String get editLocation => 'Upravit polohu';

  @override
  String get selectALocation => 'Vybrat polohu';

  @override
  String get selectALocationFirst => 'Nejprve vyberte polohu';

  @override
  String get changeLocationOfSelectedItems =>
      'Změnit umístění vybraných položek?';

  @override
  String get editsToLocationWillOnlyBeSeenWithinEnte =>
      'Úpravy umístění budou viditelné pouze v rámci Ente';

  @override
  String get cleanUncategorized => 'Vyčistit Nezařazené';

  @override
  String get cleanUncategorizedDescription =>
      'Odeberte všechny soubory z alba Nezařazené, které se nacházejí v jiných albech';

  @override
  String get waitingForVerification => 'Čekání na ověření...';

  @override
  String get passkey => 'Přístupový klíč';

  @override
  String get passkeyAuthTitle => 'Ověření přístupového klíče';

  @override
  String get loginWithTOTP => 'Přihlášení pomocí TOTP';

  @override
  String get passKeyPendingVerification => 'Ověření stále probíhá';

  @override
  String get loginSessionExpired => 'Relace vypršela';

  @override
  String get loginSessionExpiredDetails =>
      'Vaše relace vypršela. Přihlaste se prosím znovu.';

  @override
  String get verifyPasskey => 'Ověřit přístupový klíč';

  @override
  String get playOnTv => 'Přehrát album na televizi';

  @override
  String get pair => 'Spárovat';

  @override
  String get deviceNotFound => 'Zařízení nebylo nalezeno';

  @override
  String get castInstruction =>
      'Navštivte stránku cast.ente.io na zařízení, které chcete spárovat.\n\nZadejte níže uvedený kód a album se přehraje na vaší televizi.';

  @override
  String get deviceCodeHint => 'Zadejte kód';

  @override
  String get joinDiscord => 'Připoj se na Discord';

  @override
  String get locations => 'Lokality';

  @override
  String get addAName => 'Přidat název';

  @override
  String get findThemQuickly => 'Najděte je rychle';

  @override
  String get findPeopleByName => 'Rychlé vyhledávání osob podle jména';

  @override
  String addViewers({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Přidat pozorovatele',
      one: 'Přidat pozorovatele',
      zero: 'Přidat pozorovatele',
    );
    return '$_temp0';
  }

  @override
  String addCollaborators({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Přidat spolupracovníky',
      one: 'Přidat spolupracovníka',
      zero: 'Přidat spolupracovníka',
    );
    return '$_temp0';
  }

  @override
  String get longPressAnEmailToVerifyEndToEndEncryption =>
      'Dlouhým stisknutím e-mailu ověříte koncové šifrování.';

  @override
  String get developerSettingsWarning =>
      'Opravdu chcete změnit nastavení pro vývojáře?';

  @override
  String get developerSettings => 'Nastavení pro vývojáře';

  @override
  String get serverEndpoint => 'Koncový bod serveru';

  @override
  String get invalidEndpoint => 'Neplatný koncový bod';

  @override
  String get invalidEndpointMessage =>
      'Omlouváme se, zadaný koncový bod je neplatný. Zadejte platný koncový bod a zkuste to znovu.';

  @override
  String get endpointUpdatedMessage => 'Koncový bod byl úspěšně aktualizován';

  @override
  String customEndpoint({required Object endpoint}) {
    return 'Připojeno k $endpoint';
  }

  @override
  String get createCollaborativeLink => 'Vytvořit odkaz pro spolupráci';

  @override
  String get search => 'Hledat';

  @override
  String get enterPersonName => 'Zadejte jméno osoby';

  @override
  String editEmailAlreadyLinked({required Object name}) {
    return 'Tento e-mail je již propojen s $name.';
  }

  @override
  String viewPersonToUnlink({required Object name}) {
    return 'Zobraz $name pro zrušení propojení';
  }

  @override
  String get enterName => 'Zadejte jméno';

  @override
  String get savePerson => 'Uložit osobu';

  @override
  String get editPerson => 'Upravit osobu';

  @override
  String get mergedPhotos => 'Sloučené fotografie';

  @override
  String get orMergeWithExistingPerson => 'Nebo sloučit se stávajícími';

  @override
  String get enterDateOfBirth => 'Narozeniny (volitelné)';

  @override
  String get birthday => 'Narozeniny';

  @override
  String get removePersonLabel => 'Odebrat označení osoby';

  @override
  String get autoPairDesc =>
      'Funkce automatického párování funguje pouze se zařízeními, která podporují Chromecast.';

  @override
  String get manualPairDesc =>
      'Funkce \"Párovat s PINem\" funguje s jakoukoli obrazovkou, na které si chcete prohlížet své album.';

  @override
  String get connectToDevice => 'Připojit k zařízení';

  @override
  String get autoCastDialogBody => 'Zde uvidíte dostupná zařízení pro přenos.';

  @override
  String get autoCastiOSPermission =>
      'V nastavení se ujistěte, že jsou pro aplikaci Ente Photos zapnutá oprávnění pro místní síť.';

  @override
  String get noDeviceFound => 'Nebylo nalezeno žádné zařízení';

  @override
  String get stopCastingTitle => 'Zastavit přenos';

  @override
  String get stopCastingBody => 'Chcete přestat odesílat?';

  @override
  String get castIPMismatchTitle => 'Nepodařilo se odeslat album';

  @override
  String get castIPMismatchBody =>
      'Ujistěte se, že jste připojeni ke stejné síti jako televizor.';

  @override
  String get pairingComplete => 'Párování dokončeno';

  @override
  String get savingEdits => 'Ukládání úprav...';

  @override
  String get autoPair => 'Automatické párování';

  @override
  String get pairWithPin => 'Párovat s PINem';

  @override
  String get faceRecognition => 'Rozpoznání tváře';

  @override
  String get foundFaces => 'Nalezené tváře';

  @override
  String get clusteringProgress => 'Průběh seskupování';

  @override
  String get trim => 'Oříznout';

  @override
  String get crop => 'Oříznout';

  @override
  String get rotate => 'Otočit';

  @override
  String get left => 'Doleva';

  @override
  String get right => 'Doprava';

  @override
  String get whatsNew => 'Co je nového';

  @override
  String get reviewSuggestions => 'Zkontrolovat návrhy';

  @override
  String get review => 'Zkontrolovat';

  @override
  String get useAsCover => 'Použít jako náhled';

  @override
  String notPersonLabel({required String name}) {
    return 'Není to $name?';
  }

  @override
  String get enable => 'Povolit';

  @override
  String get enabled => 'Zapnuto';

  @override
  String get moreDetails => 'Další podrobnosti';

  @override
  String get enableMLIndexingDesc =>
      'Ente podporuje strojové učení na zařízení pro rozpoznávání obličejů, magické vyhledávání a další pokročilé vyhledávací funkce';

  @override
  String get magicSearchHint =>
      'Magické vyhledávání umožňuje vyhledávat fotografie podle jejich obsahu, např. „květina“, „červené auto“, „doklady totožnosti“';

  @override
  String get panorama => 'Panorama';

  @override
  String get reenterPassword => 'Zadejte heslo znovu';

  @override
  String get reenterPin => 'Zadejte PIN znovu';

  @override
  String get deviceLock => 'Zámek zařízení';

  @override
  String get pinLock => 'Zámek PIN';

  @override
  String get next => 'Další';

  @override
  String get setNewPassword => 'Nastavit nové heslo';

  @override
  String get enterPin => 'Zadejte PIN';

  @override
  String get setNewPin => 'Nastavit nový PIN';

  @override
  String get appLock => 'Zámek aplikace';

  @override
  String get noSystemLockFound => 'Zámek systému nenalezen';

  @override
  String get tapToUnlock => 'Pro odemčení klepněte';

  @override
  String get tooManyIncorrectAttempts => 'Příliš mnoho neúspěšných pokusů';

  @override
  String get videoInfo => 'Informace o videu';

  @override
  String get autoLock => 'Automatické zamykání';

  @override
  String get immediately => 'Ihned';

  @override
  String get autoLockFeatureDescription =>
      'Čas, po kterém se aplikace zamkne po přesunutí na pozadí';

  @override
  String get hideContent => 'Skrýt obsah';

  @override
  String get hideContentDescriptionAndroid =>
      'Skrývá obsah aplikace v přepínači aplikací a zakazuje pořizování snímků obrazovky';

  @override
  String get hideContentDescriptionIos =>
      'Skrývá obsah aplikace v přepínači aplikací';

  @override
  String get passwordStrengthInfo =>
      'Síla hesla se počítá na základě délky hesla, použitých znaků a toho, zda se heslo objevuje v žebříčku 10 000 nejčastěji používaných hesel';

  @override
  String get noQuickLinksSelected => 'Nebyly vybrány žádné rychlé odkazy';

  @override
  String get pleaseSelectQuickLinksToRemove =>
      'Vyberte rychlé odkazy, které chcete odstranit';

  @override
  String get removePublicLinks => 'Odebrat veřejné odkazy';

  @override
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks =>
      'Tím se odstraní veřejné odkazy všech vybraných rychlých odkazů.';

  @override
  String get guestView => 'Zobrazení pro hosty';

  @override
  String get guestViewEnablePreSteps =>
      'Chcete-li povolit zobrazení pro hosty, nastavte v systémových nastaveních přístupový kód zařízení nebo zámek obrazovky.';

  @override
  String get nameTheAlbum => 'Pojmenujte album';

  @override
  String get collectPhotosDescription =>
      'Vytvořte odkaz, na který mohou vaši přátelé nahrávat fotografie v původní kvalitě.';

  @override
  String get collect => 'Sebrat';

  @override
  String get appLockDescriptions =>
      'Vyberte si mezi výchozí uzamčenou obrazovkou zařízení a vlastní uzamčenou obrazovkou s PIN kódem nebo heslem.';

  @override
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen =>
      'Chcete-li povolit zámek aplikace, nastavte v nastavení systému přístupový kód zařízení nebo zámek obrazovky.';

  @override
  String get authToViewPasskey =>
      'Pro zobrazení vašeho přístupového klíče se prosím ověřte';

  @override
  String get loopVideoOn => 'Disable looping';

  @override
  String get loopVideoOff => 'Enable looping';

  @override
  String get localSyncErrorMessage =>
      'Zdá se, že došlo k nějaké chybě, protože synchronizace místních fotografií trvá déle, než se očekávalo. Obraťte se prosím na náš tým podpory';

  @override
  String get showPerson => 'Zobrazit osobu';

  @override
  String get sort => 'Seřadit';

  @override
  String get mostRecent => 'Nejnovější';

  @override
  String get mostRelevant => 'Nejrelevantnější';

  @override
  String get loadingYourPhotos => 'Načítání vašich fotografií...';

  @override
  String processingImport({required Object folderName}) {
    return 'Zpracovávám $folderName...';
  }

  @override
  String get personName => 'Jméno osoby';

  @override
  String get addNewPerson => 'Přidat novou osobu';

  @override
  String get addNameOrMerge => 'Přidat jméno nebo sloučit';

  @override
  String get mergeWithExisting => 'Sloučit s existujícím';

  @override
  String get newPerson => 'Nová osoba';

  @override
  String get addName => 'Přidat název';

  @override
  String get add => 'Přidat';

  @override
  String extraPhotosFoundFor({required String text}) {
    return 'Další fotografie nalezené pro $text';
  }

  @override
  String get extraPhotosFound => 'Nalezeny další fotografie';

  @override
  String get configuration => 'Nastavení';

  @override
  String get localIndexing => 'Lokální indexování';

  @override
  String get processed => 'Zpracováno';

  @override
  String get resetPerson => 'Odstranit';

  @override
  String get areYouSureYouWantToResetThisPerson =>
      'Opravdu chcete tuto osobu zapomenout?';

  @override
  String get allPersonGroupingWillReset =>
      'Všechna seskupení pro tuto osobu budou zapomenuta a ztratíte všechny návrhy vytvořené pro tuto osobu';

  @override
  String get yesResetPerson => 'Ano, zapomenout osobu';

  @override
  String get onlyThem => 'Jen oni';

  @override
  String get checkingModels => 'Kontrola modelů...';

  @override
  String get enableMachineLearningBanner =>
      'Povolte strojové učení pro magické vyhledávání a rozpoznávání obličejů';

  @override
  String get searchDiscoverEmptySection =>
      'Obrázky se zde zobrazí po dokončení zpracování a synchronizace';

  @override
  String get searchPersonsEmptySection =>
      'Lidé se zde zobrazí po dokončení zpracování a synchronizace';

  @override
  String viewersSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Přidáno $count pozorovatelů',
      few: 'Přidáni $count pozorovatelé',
      one: 'Přidán 1 pozorovatel',
      zero: 'Přidáno 0 pozorovatelů',
    );
    return '$_temp0';
  }

  @override
  String collaboratorsSuccessfullyAdded({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Přidáno $count spolupracovníků',
      few: 'Přidáni $count spolupracovníci',
      one: 'Přidán 1 spolupracovník',
      zero: 'Přidáno 0 spolupracovníků',
    );
    return '$_temp0';
  }

  @override
  String get accountIsAlreadyConfigured => 'Účet je již nakonfigurován.';

  @override
  String get sessionIdMismatch => 'Neshoda ID relace';

  @override
  String get failedToFetchActiveSessions =>
      'Nepodařilo se načíst aktivní relace';

  @override
  String get failedToRefreshStripeSubscription =>
      'Obnovení předplatného se nezdařilo';

  @override
  String get failedToPlayVideo => 'Přehrávání videa se nezdařilo';

  @override
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason}) {
    return 'Nahrání bylo ignorováno z důvodu $ignoreReason';
  }

  @override
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  }) {
    return 'Typ galerie $galleryType není podporován pro přejmenování';
  }

  @override
  String tapToUploadIsIgnoredDue({required String ignoreReason}) {
    return 'Klepnutím nahrajte, nahrávání je momentálně ignorováno z důvodu $ignoreReason';
  }

  @override
  String get tapToUpload => 'Klepnutím nahrajte';

  @override
  String get info => 'Informace';

  @override
  String get addFiles => 'Přidat soubory';

  @override
  String get castAlbum => 'Přenášet album';

  @override
  String get imageNotAnalyzed => 'Obrázek nebyl analyzován';

  @override
  String get noFacesFound => 'Nebyly nalezeny žádné tváře';

  @override
  String get fileNotUploadedYet => 'Soubor ještě nebyl nahrán';

  @override
  String noSuggestionsForPerson({required String personName}) {
    return 'Žádné návrhy pro $personName';
  }

  @override
  String get month => 'měsíc';

  @override
  String get yearShort => 'rok';

  @override
  String get currentlyRunning => 'aktuálně běží';

  @override
  String get ignored => 'ignorováno';

  @override
  String photosCount({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count fotografií',
      few: '$count fotografie',
      one: '1 fotografie',
      zero: '0 fotografií',
    );
    return '$_temp0';
  }

  @override
  String get file => 'Soubor';

  @override
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  }) {
    return 'Nesoulad délky sekcí: $snapshotLength != $searchLength';
  }

  @override
  String get selectMailApp => 'Vyberte emailovou aplikace';

  @override
  String get selectAllShort => 'Vše';

  @override
  String get selectCoverPhoto => 'Vyberte úvodní fotografii';

  @override
  String get newLocation => 'Nové umístění';

  @override
  String get faceNotClusteredYet =>
      'Tvář ještě není seskupena, vraťte se prosím později';

  @override
  String get theLinkYouAreTryingToAccessHasExpired =>
      'Odkaz, na který se pokoušíte přistupovat, vypršel.';

  @override
  String get openFile => 'Otevřít soubor';

  @override
  String get backupFile => 'Zálohovat soubor';

  @override
  String get openAlbumInBrowser => 'Otevřít album v prohlížeči';

  @override
  String get openAlbumInBrowserTitle =>
      'K přidání fotografií do tohoto alba použijte webovou aplikaci';

  @override
  String get allow => 'Povolit';

  @override
  String get allowAppToOpenSharedAlbumLinks =>
      'Povolit aplikaci otevírat odkazy na sdílená alba';

  @override
  String get seePublicAlbumLinksInApp =>
      'Zobrazit odkazy na veřejná alba v aplikaci';

  @override
  String get emergencyContacts => 'Nouzové kontakty';

  @override
  String get acceptTrustInvite => 'Přijmout pozvání';

  @override
  String get declineTrustInvite => 'Odmítnout pozvání';

  @override
  String get removeYourselfAsTrustedContact =>
      'Odstranit sebe jako důvěryhodný kontakt';

  @override
  String get legacy => 'Dědictví';

  @override
  String get legacyPageDesc =>
      'Dědictví umožňuje důvěryhodným kontaktům přístup k vašemu účtu v době vaší nepřítomnosti.';

  @override
  String get legacyPageDesc2 =>
      'Důvěryhodné kontakty mohou zahájit obnovení účtu a pokud nebude do 30 dnů zablokováno, mohou resetovat vaše heslo a získat přístup k vašemu účtu.';

  @override
  String get legacyAccounts => 'Účty pro dědictví';

  @override
  String get trustedContacts => 'Důvěryhodné kontakty';

  @override
  String get addTrustedContact => 'Přidat důvěryhodný kontakt';

  @override
  String get removeInvite => 'Odstranit pozvání';

  @override
  String get recoveryWarning =>
      'Důvěryhodný kontakt se snaží získat přístup k vašemu účtu';

  @override
  String get rejectRecovery => 'Odmítnout obnovu';

  @override
  String get recoveryInitiated => 'Obnovení zahájeno';

  @override
  String recoveryInitiatedDesc({required int days, required String email}) {
    return 'K účtu budete mít přístup po $days dnech. Oznámení bude zasláno na adresu $email.';
  }

  @override
  String get cancelAccountRecovery => 'Zrušit obnovení';

  @override
  String get recoveryAccount => 'Obnovit účet';

  @override
  String get cancelAccountRecoveryBody => 'Opravdu chcete zrušit obnovení?';

  @override
  String get startAccountRecoveryTitle => 'Zahájit obnovení';

  @override
  String get whyAddTrustContact =>
      'Důvěryhodný kontakt vám může pomoci při obnově dat.';

  @override
  String recoveryReady({required String email}) {
    return 'Nyní můžete obnovit účet pro $email nastavením nového hesla.';
  }

  @override
  String recoveryWarningBody({required Object email}) {
    return '$email se pokouší obnovit váš účet.';
  }

  @override
  String trustedInviteBody({required Object email}) {
    return 'Byli jste pozváni, abyste se stali kontaktní osobou pro dědictví od $email.';
  }

  @override
  String get warning => 'Varování';

  @override
  String get proceed => 'Pokračovat';

  @override
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  }) {
    return 'Chystáte se přidat $email jako důvěryhodný kontakt. Ten bude moci obnovit váš účet, pokud budete $numOfDays dní nepřítomní.';
  }

  @override
  String legacyInvite({required Object email}) {
    return '$email vás pozval, abyste se stali důvěryhodným kontaktem';
  }

  @override
  String get authToManageLegacy =>
      'Pro správu důvěryhodných kontaktů se prosím ověřte';

  @override
  String get hideSharedItemsFromHomeGallery =>
      'Skrýt sdílené položky z domácí galerie';

  @override
  String get swipeToSelect => 'Swipe to select';

  @override
  String get gallery => 'Galerie';

  @override
  String get joinAlbum => 'Připojit se k albu';

  @override
  String get joinAlbumSubtext => 'pro prohlížení a přidávání vašich fotografií';

  @override
  String get joinAlbumSubtextViewer => 'pro přidání do sdílených alb';

  @override
  String get join => 'Připojit se';

  @override
  String get linkEmail => 'Propojit e-mail';

  @override
  String get link => 'Propojit';

  @override
  String get noEnteAccountExclamation => 'Toto není účet Ente!';

  @override
  String get orPickFromYourContacts => 'nebo vyberte z kontaktů';

  @override
  String emailDoesNotHaveEnteAccount({required String email}) {
    return '$email nemá účet Ente.';
  }

  @override
  String accountOwnerPersonAppbarTitle({required String title}) {
    return '$title (Já)';
  }

  @override
  String get reassignMe => 'Přeřadit „Já“';

  @override
  String get me => 'Já';

  @override
  String get linkEmailToContactBannerCaption => 'pro rychlejší sdílení';

  @override
  String get selectPersonToLink => 'Vyberte osobu, kterou chcete propojit';

  @override
  String linkPersonToEmail({required String email}) {
    return 'Propojit osobu s $email';
  }

  @override
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  }) {
    return 'Tímto se propojí $personName s $email';
  }

  @override
  String get selectYourFace => 'Vyberte svou tvář';

  @override
  String get reassigningLoading => 'Přeřazování...';

  @override
  String reassignedToName({required String name}) {
    return 'Přeřadili jsme vás k $name';
  }

  @override
  String get saveChangesBeforeLeavingQuestion => 'Před ukončením uložte změny';

  @override
  String get dontSave => 'Neukládat';

  @override
  String get thisIsMeExclamation => 'To jsem já!';

  @override
  String get linkPerson => 'Propojte osobu';

  @override
  String get linkPersonCaption => 'pro lepší zkušenosti se sdílením';

  @override
  String get videoStreaming => 'Videa pro streamování';

  @override
  String get processingVideos => 'Zpracování videí';

  @override
  String get streamDetails => 'Podrobnosti o streamu';

  @override
  String get processing => 'Zpracovává se';

  @override
  String get queued => 'Ve frontě';

  @override
  String get ineligible => 'Nesplňuje podmínky';

  @override
  String get failed => 'Selhalo';

  @override
  String get playStream => 'Přehrát stream';

  @override
  String get playOriginal => 'Přehrát původní';

  @override
  String get joinAlbumConfirmationDialogBody =>
      'Připojením se k albu bude váš e-mail viditelný pro jeho spolupracovníky.';

  @override
  String get pleaseWaitThisWillTakeAWhile =>
      'Počkejte prosím, bude to chvíli trvat.';

  @override
  String get editTime => 'Upravit čas';

  @override
  String get selectTime => 'Vybrat čas';

  @override
  String get selectDate => 'Vybrat datum';

  @override
  String get previous => 'Předchozí';

  @override
  String get selectOneDateAndTimeForAll =>
      'Vyberte jedno datum a čas pro všechny';

  @override
  String get selectStartOfRange => 'Vyberte začátek rozsahu';

  @override
  String get thisWillMakeTheDateAndTimeOfAllSelected =>
      'Tímto se datum a čas všech vybraných fotografií sjednotí.';

  @override
  String get allWillShiftRangeBasedOnFirst =>
      'Toto je první v této skupině. Ostatní vybrané fotografie se automaticky posunou podle tohoto nového data';

  @override
  String get newRange => 'Nový rozsah';

  @override
  String get selectOneDateAndTime => 'Vyberte jedno datum a čas';

  @override
  String get moveSelectedPhotosToOneDate =>
      'Přesunout vybrané fotografie do jednoho data';

  @override
  String get shiftDatesAndTime => 'Posunout datum a čas';

  @override
  String get photosKeepRelativeTimeDifference =>
      'Fotografie zachovávají relativní časový rozdíl';

  @override
  String photocountPhotos({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count fotografií',
      few: '$count fotografie',
      one: '1 fotografie',
      zero: 'Žádné fotografie',
    );
    return '$_temp0';
  }

  @override
  String get appIcon => 'Ikona aplikace';

  @override
  String get notThisPerson => 'Není to tato osoba?';

  @override
  String get selectedItemsWillBeRemovedFromThisPerson =>
      'Vybrané položky budou z této osoby odebrány, ale nebudou smazány z vaší knihovny.';

  @override
  String throughTheYears({required Object dateFormat}) {
    return '$dateFormat v průběhu let';
  }

  @override
  String get thisWeekThroughTheYears => 'Tento týden v průběhu let';

  @override
  String thisWeekXYearsAgo({required num count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Tento týden, $count let nazpět',
      few: 'Tento týden, $count roky nazpět',
      one: 'Tento týden, $count rok nazpět',
    );
    return '$_temp0';
  }

  @override
  String youAndThem({required Object name}) {
    return 'Vy a $name';
  }

  @override
  String admiringThem({required Object name}) {
    return 'Obdiv k $name';
  }

  @override
  String embracingThem({required Object name}) {
    return 'Objímání $name';
  }

  @override
  String partyWithThem({required Object name}) {
    return 'Párty s $name';
  }

  @override
  String hikingWithThem({required Object name}) {
    return 'Turistika s $name';
  }

  @override
  String feastingWithThem({required Object name}) {
    return 'Hodování s $name';
  }

  @override
  String selfiesWithThem({required Object name}) {
    return 'Selfie s $name';
  }

  @override
  String posingWithThem({required Object name}) {
    return 'Pózování s $name';
  }

  @override
  String backgroundWithThem({required Object name}) {
    return 'Krásný výhled s $name';
  }

  @override
  String sportsWithThem({required Object name}) {
    return 'Sporty s $name';
  }

  @override
  String roadtripWithThem({required Object name}) {
    return 'Výlet autem s $name';
  }

  @override
  String get spotlightOnYourself => 'Vaše nejdůležitější události';

  @override
  String spotlightOnThem({required Object name}) {
    return 'Nejdůležitější události s $name';
  }

  @override
  String personIsAge({required Object age, required Object name}) {
    return '$name má $age let!';
  }

  @override
  String personTurningAge({required Object age, required Object name}) {
    return '$name brzy oslaví $age let';
  }

  @override
  String lastTimeWithThem({required Object name}) {
    return 'Naposledy s $name';
  }

  @override
  String tripToLocation({required Object location}) {
    return 'Výlet do $location';
  }

  @override
  String tripInYear({required Object year}) {
    return 'Cesta v roce $year';
  }

  @override
  String get lastYearsTrip => 'Loňský výlet';

  @override
  String get sunrise => 'Na obzoru';

  @override
  String get mountains => 'Přes kopce';

  @override
  String get greenery => 'Zelený život';

  @override
  String get beach => 'Písek a moře';

  @override
  String get city => 'Ve městě';

  @override
  String get moon => 'V měsíčním svitu';

  @override
  String get onTheRoad => 'Zase na cestách';

  @override
  String get food => 'Kulinářský zážitek';

  @override
  String get pets => 'Chlupatí společníci';

  @override
  String get curatedMemories => 'Vybrané vzpomínky';

  @override
  String get widgets => 'Widgety';

  @override
  String get memories => 'Vzpomínky';

  @override
  String get peopleWidgetDesc =>
      'Vyberte osoby, které chcete vidět na domovské obrazovce.';

  @override
  String get albumsWidgetDesc =>
      'Vyberte alba, která chcete zobrazit na domovské obrazovce.';

  @override
  String get memoriesWidgetDesc =>
      'Vyberte typ vzpomínek, které chcete zobrazit na domovské obrazovce.';

  @override
  String get smartMemories => 'Chytré vzpomínky';

  @override
  String get pastYearsMemories => 'Vzpomínky na minulé roky';

  @override
  String deleteMultipleAlbumDialog({required Object count}) {
    return 'Smazat také fotografie (a videa) přítomné v těchto $count albech ze <bold>všech</bold> ostatních alb, jejichž součástí jsou?';
  }

  @override
  String get addParticipants => 'Přidat účastníky';

  @override
  String selectedAlbums({required Object count}) {
    return 'Vybráno: $count';
  }

  @override
  String get actionNotSupportedOnFavouritesAlbum =>
      'Akce není podporována v albu Oblíbené';

  @override
  String get onThisDayMemories => 'Vzpomínky v tento den';

  @override
  String get onThisDay => 'V tento den';

  @override
  String get lookBackOnYourMemories => 'Ohlédni se za svými vzpomínkami 🌄';

  @override
  String get newPhotosEmoji => ' nové 📸';

  @override
  String get sorryWeHadToPauseYourBackups =>
      'Omlouváme se, museli jsme pozastavit vaše zálohy';

  @override
  String get clickToInstallOurBestVersionYet =>
      'Klikněte pro instalaci naší dosud nejlepší verze';

  @override
  String get onThisDayNotificationExplanation =>
      'Dostávejte připomenutí vzpomínek z tohoto dne v předchozích letech.';

  @override
  String get addMemoriesWidgetPrompt =>
      'Přidejte widget vzpomínek na domovskou obrazovku a vraťte se sem, abyste jej přizpůsobili.';

  @override
  String get addAlbumWidgetPrompt =>
      'Přidejte widget alba na domovskou obrazovku a vraťte se sem, abyste jej přizpůsobili.';

  @override
  String get addPeopleWidgetPrompt =>
      'Přidejte widget lidí na domovskou obrazovku a vraťte se sem, abyste jej přizpůsobili.';

  @override
  String get birthdayNotifications => 'Oznámení o narozeninách';

  @override
  String get receiveRemindersOnBirthdays =>
      'Dostávejte připomenutí, když má někdo narozeniny. Klepnutím na oznámení se dostanete k fotkám oslavence.';

  @override
  String get happyBirthday => 'Všechno nejlepší k narozeninám! 🥳';

  @override
  String get birthdays => 'Narozeniny';

  @override
  String wishThemAHappyBirthday({required Object name}) {
    return 'Popřejte $name všechno nejlepší k narozeninám! 🎉';
  }

  @override
  String get areYouSureRemoveThisFaceFromPerson =>
      'Opravdu chcete odstranit tuto tvář z této osoby?';

  @override
  String get otherDetectedFaces => 'Další detekované tváře';

  @override
  String get areThey => 'Jsou to ';

  @override
  String get questionmark => '?';

  @override
  String get saveAsAnotherPerson => 'Uložit jako jinou osobu';

  @override
  String get showLessFaces => 'Zobrazit méně tváří';

  @override
  String get showMoreFaces => 'Zobrazit více tváří';

  @override
  String get ignore => 'Ignorovat';

  @override
  String get merge => 'Sloučit';

  @override
  String get reset => 'Obnovit';

  @override
  String get areYouSureYouWantToIgnoreThisPerson =>
      'Opravdu chcete tuto osobu ignorovat?';

  @override
  String get areYouSureYouWantToIgnoreThesePersons =>
      'Opravdu chcete tyto osoby ignorovat?';

  @override
  String get thePersonGroupsWillNotBeDisplayed =>
      'Skupiny osob se již nebudou zobrazovat v sekci „Lidé“. Fotografie zůstanou beze změny.';

  @override
  String get thePersonWillNotBeDisplayed =>
      'Tato osoba již nebude zobrazena v sekci „Lidé“. Fotografie zůstanou beze změny.';

  @override
  String get areYouSureYouWantToMergeThem => 'Opravdu je chcete sloučit?';

  @override
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson =>
      'Všechny nepojmenované skupiny budou sloučeny do vybrané osoby. Tuto akci lze stále vrátit zpět z přehledu historie návrhů dané osoby.';

  @override
  String get yesIgnore => 'Ano, ignorovat';

  @override
  String get same => 'Stejné';

  @override
  String get different => 'Odlišné';

  @override
  String get sameperson => 'Stejná osoba?';

  @override
  String get indexingPausedStatusDescription =>
      'Indexování je pozastaveno. Automaticky se obnoví, jakmile bude zařízení připraveno. Zařízení je považováno za připravené, pokud jsou úroveň nabití baterie, stav baterie a teplotní stav v normálním rozmezí.';

  @override
  String get thisWeek => 'Tento týden';

  @override
  String get lastWeek => 'Minulý týden';

  @override
  String get thisMonth => 'Tento měsíc';

  @override
  String get thisYear => 'Tento rok';

  @override
  String get groupBy => 'Seskupit podle';

  @override
  String get faceThumbnailGenerationFailed =>
      'Nelze vygenerovat miniatury obličejů';

  @override
  String get fileAnalysisFailed => 'Nelze analyzovat soubor';

  @override
  String get editAutoAddPeople => 'Upravit automatické přidávání osob';

  @override
  String get autoAddPeople => 'Automatické přidávání osob';

  @override
  String get autoAddToAlbum => 'Automaticky přidat do alba';

  @override
  String get shouldRemoveFilesSmartAlbumsDesc =>
      'Mají být soubory související s osobou, které byly dříve vybrány ve smart albech, odstraněny?';

  @override
  String get addingPhotos => 'Přidávání fotografií';

  @override
  String get gettingReady => 'Připravuji';

  @override
  String get addSomePhotosDesc1 => 'Přidejte nějaké fotografie nebo vyberte ';

  @override
  String get addSomePhotosDesc2 => 'známé tváře';

  @override
  String get addSomePhotosDesc3 => '\npro začátek';

  @override
  String get ignorePerson => 'Ignorovat osobu';

  @override
  String get mixedGrouping => 'Smíšené seskupení?';

  @override
  String get analysis => 'Analýza';

  @override
  String get doesGroupContainMultiplePeople =>
      'Obsahuje tato skupina více osob?';

  @override
  String get automaticallyAnalyzeAndSplitGrouping =>
      'Automaticky analyzujeme seskupení, abychom zjistili, zda je přítomno více osob, a opět je oddělíme. To může trvat několik sekund.';

  @override
  String get layout => 'Rozvržení';

  @override
  String get day => 'Den';

  @override
  String get undo => 'Vrátit zpět';

  @override
  String get redo => 'Opakovat akci';

  @override
  String get filter => 'Filtr';

  @override
  String get adjust => 'Upravit';

  @override
  String get draw => 'Kreslit';

  @override
  String get sticker => 'Nálepka';

  @override
  String get brushColor => 'Barva štětce';

  @override
  String get font => 'Písmo';

  @override
  String get background => 'Pozadí';

  @override
  String get align => 'Zarovnat';

  @override
  String addedToAlbums({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Úspěšně přidáno do $count alb',
      one: 'Úspěšně přidáno do 1 alba',
    );
    return '$_temp0';
  }

  @override
  String get videosProcessed => 'Zpracovaná videa';

  @override
  String get totalVideos => 'Celkový počet videí';

  @override
  String get skippedVideos => 'Přeskočená videa';

  @override
  String get videoStreamingDescriptionLine1 =>
      'Přehrávejte videa okamžitě na jakémkoli zařízení.';

  @override
  String get videoStreamingDescriptionLine2 =>
      'Povolte pro zpracování video streamů na tomto zařízení.';

  @override
  String get videoStreamingNote =>
      'Na tomto zařízení se zpracovávají pouze videa z posledních 60 dnů, která jsou kratší než 1 minuta. U starších/delších videí povolte streamování v desktopové aplikaci.';

  @override
  String get createStream => 'Vytvořit stream';

  @override
  String get recreateStream => 'Obnovit stream';

  @override
  String get addedToStreamCreationQueue =>
      'Přidáno do fronty pro vytvoření streamu';

  @override
  String get addedToStreamRecreationQueue =>
      'Přidáno do fronty pro obnovení streamu';

  @override
  String get videoPreviewAlreadyExists => 'Náhled videa již existuje';

  @override
  String get videoAlreadyInQueue => 'Video soubor již je ve frontě';

  @override
  String get videoExportFailed => 'Video creation failed. Please try again.';

  @override
  String videoExportSuccess({required String path}) {
    return 'Video successfully created at $path';
  }

  @override
  String get addedToQueue => 'Přidáno do fronty';

  @override
  String get creatingStream => 'Vytváření streamu';

  @override
  String get similarImages => 'Podobné obrázky';

  @override
  String get findSimilarImages => 'Najít podobné obrázky';

  @override
  String get noSimilarImagesFound => 'Nebyly nalezeny žádné podobné obrázky';

  @override
  String get yourPhotosLookUnique => 'Vaše fotografie vypadají jedinečně';

  @override
  String similarGroupsFound({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count skupin nalezeno',
      few: '$count skupiny nalezeny',
      one: '$count skupina nalezena',
    );
    return '$_temp0';
  }

  @override
  String get reviewAndRemoveSimilarImages =>
      'Zkontrolujte a odstraňte podobné obrázky';

  @override
  String deletePhotosWithSize({required String count, required String size}) {
    return 'Smazat $count fotek ($size)';
  }

  @override
  String get selectionOptions => 'Možnosti výběru';

  @override
  String selectExactWithCount({required int count}) {
    return 'Úplně stejné ($count)';
  }

  @override
  String get selectExact => 'Vybrat shodné';

  @override
  String selectSimilarWithCount({required int count}) {
    return 'Hodně podobné ($count)';
  }

  @override
  String get selectSimilar => 'Vyberte podobné';

  @override
  String selectAllWithCount({required int count}) {
    return 'Všechny podobnosti ($count)';
  }

  @override
  String get selectSimilarImagesTitle => 'Vyberte podobné obrázky';

  @override
  String get chooseSimilarImagesToSelect =>
      'Vyberte obrázky na základě jejich vizuální podobnosti';

  @override
  String get clearSelection => 'Vymazat výběr';

  @override
  String similarImagesCount({required int count}) {
    return '$count podobných obrázků';
  }

  @override
  String deleteWithCount({required int count}) {
    return 'Smazat ($count)';
  }

  @override
  String get deleteFiles => 'Smazat soubory';

  @override
  String get areYouSureDeleteFiles => 'Opravdu chcete tyto soubory smazat?';

  @override
  String get greatJob => 'Dobrá práce!';

  @override
  String cleanedUpSimilarImages({required String size}) {
    return 'Uvolnili jste $size místa';
  }

  @override
  String get size => 'Velikost';

  @override
  String get similarity => 'Podobnost';

  @override
  String get analyzingPhotosLocally => 'Analyzuji vaše fotografie lokálně...';

  @override
  String get lookingForVisualSimilarities => 'Hledání vizuálních podobností...';

  @override
  String get comparingImageDetails => 'Porovnávání detailů obrázku...';

  @override
  String get findingSimilarImages => 'Hledání podobných obrázků...';

  @override
  String get almostDone => 'Téměř hotovo...';

  @override
  String get processingLocally => 'Místní zpracování';

  @override
  String get useMLToFindSimilarImages =>
      'Zkontrolujte a odstraňte obrázky, které se navzájem podobají.';

  @override
  String get all => 'Vše';

  @override
  String get similar => 'Podobné';

  @override
  String get identical => 'Identické';

  @override
  String get nothingHereTryAnotherFilter =>
      'Tady nic není, zkuste jiný filtr! 👀';

  @override
  String get related => 'Související';

  @override
  String get hoorayyyy => 'Huráááá!';

  @override
  String get nothingToTidyUpHere => 'Tady není co uklízet';

  @override
  String get deletingDash => 'Mazání - ';

  @override
  String get cLTitle1 => 'Jump to date';

  @override
  String get cLDesc1 =>
      'See surrounding photos for any photo by selecting the jump to date option in the file\'s info pane.';

  @override
  String get cLTitle2 => 'Faster video editor';

  @override
  String get cLDesc2 =>
      'Video editor was revamped to both drastically improve its speed when editing larger videos, and also improve the UX.';

  @override
  String get cLTitle3 => 'New memories';

  @override
  String get cLDesc3 =>
      '\"Playful kids\", \"Winter adventures\", \"Neon nights\", and more.';

  @override
  String get cLTitle4 => 'Landscape gallery and more';

  @override
  String get cLDesc4 =>
      'Support for landscape layout in the app\'s main gallery. Show persons without any associated photos instead of filtering them out. Improve video aspect detection when shared from external apps.';

  @override
  String get closeBy => 'Close';

  @override
  String get peopleAutoAddDesc =>
      'Automatically add photos of the selected people to this album';

  @override
  String get festivities => 'Festive cheer';

  @override
  String get snowAdventures => 'Winter adventures';

  @override
  String get waterfalls => 'Chasing waterfalls';

  @override
  String get wildlife => 'Into the wild';

  @override
  String get flowers => 'Blooming beauties';

  @override
  String get nightLights => 'Neon nights';

  @override
  String get architecture => 'Design icons';

  @override
  String get autumnColors => 'Autumn splendor';

  @override
  String get desertDreams => 'Desert dreams';

  @override
  String get stargazing => 'Under the stars';

  @override
  String get lakeside => 'Lakeside calm';

  @override
  String get rainyDays => 'Rainy day feels';

  @override
  String get sportsAction => 'Game on';

  @override
  String get streetArt => 'Street art stories';

  @override
  String get familyMoments => 'Family time';

  @override
  String get fireworks => 'Firework finale';

  @override
  String get historicSites => 'Echoes of history';

  @override
  String get tropicalParadise => 'Tropical escapes';

  @override
  String get forestTrails => 'Forest strolls';

  @override
  String get citySunsets => 'City sunset glow';

  @override
  String get colorfulMarkets => 'Vibrant markets';

  @override
  String get cozyCafes => 'Cozy cafe corners';

  @override
  String get vintageVibes => 'Vintage vibes';

  @override
  String get aerialViews => 'Aerial perspectives';

  @override
  String get artisticPortraits => 'Artful portraits';

  @override
  String get streetFood => 'Street food bites';

  @override
  String get riverCruises => 'River cruise views';

  @override
  String get facesTimelineBannerTitle => 'Memory Lane';

  @override
  String facesTimelineBannerSubtitle({required String name}) {
    return 'See $name\'s photos across the years';
  }

  @override
  String get facesTimelineAppBarTitle => 'Memory lane';

  @override
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  }) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count years old',
      one: '$count year old',
    );
    return '$name was $_temp0';
  }

  @override
  String facesTimelineCaptionYearsAgo({required int count}) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '# years ago',
      one: '# year ago',
    );
    return '$_temp0';
  }

  @override
  String get facesTimelineShareComingSoon => 'Video sharing coming soon';

  @override
  String get facesTimelinePlaybackPrevious => 'Previous';

  @override
  String get facesTimelinePlaybackNext => 'Next';

  @override
  String get facesTimelinePlaybackPlay => 'Play';

  @override
  String get facesTimelinePlaybackPause => 'Pause';

  @override
  String get facesTimelineUnavailable => 'Faces timeline is preparing...';

  @override
  String get playfulKids => 'Playful kids';

  @override
  String get coastalCliffs => 'Cliffs by the sea';

  @override
  String get ritualsTitle => 'Rituals';

  @override
  String get ritualAddTooltip => 'Add ritual';

  @override
  String get ritualActivityHeading => 'Activity';

  @override
  String get ritualDefaultHeatmapTitle => 'Take a photo every day';

  @override
  String get ritualUntitled => 'Untitled ritual';

  @override
  String get ritualShareUnavailable =>
      'Unable to share right now. Please try again.';

  @override
  String get ritualNotificationMessage => 'Take a photo now';

  @override
  String get ritualCameraNotFound => 'No camera found on this device.';

  @override
  String get ritualCameraStartError =>
      'Unable to start camera. Please check permissions.';

  @override
  String get ritualCaptureError => 'Unable to capture photo. Please try again.';

  @override
  String ritualPhotoLimit({required int maxPhotos}) {
    String _temp0 = intl.Intl.pluralLogic(
      maxPhotos,
      locale: localeName,
      other: '# photos.',
      one: '# photo.',
    );
    return 'You can add up to $_temp0';
  }

  @override
  String get ritualCaptureAtLeastOne => 'Capture at least one photo first.';

  @override
  String get ritualAlbumMissing =>
      'Ritual album missing. Edit the ritual to set an album.';

  @override
  String get ritualAddedToAlbum => 'Added to album';

  @override
  String ritualAddedToAlbumWithName({required String albumName}) {
    return 'Added to $albumName';
  }

  @override
  String ritualAddToAlbumFailure({required String error}) {
    return 'Couldn\'t add photos to the album: $error';
  }

  @override
  String get ritualBackToList => 'Back to rituals';

  @override
  String get ritualNoPhotosYet => 'No photos yet';

  @override
  String get ritualSetAlbumToLaunchCamera =>
      'Set an album for this ritual to launch the camera.';

  @override
  String get ritualDefaultCameraTitle => 'Take a photo';

  @override
  String get ritualBadgeMessage7 =>
      '7 days down! Consistency looks good on you. Keep going!';

  @override
  String get ritualBadgeMessage14 =>
      '14 days in! Your ritual is becoming a habit. Incredible!';

  @override
  String get ritualBadgeMessage30 =>
      '30 days in a row! Legendary consistency. Take a bow!';

  @override
  String get ritualBadgeMessageDefault => 'You\'re on a roll!';

  @override
  String get ritualBadgeNewTitle => 'New achievement';

  @override
  String get ritualBadgePreparing => 'Preparing...';

  @override
  String get ritualStreaksLabel => 'Streaks';

  @override
  String get ritualCreateYourOwn => 'Create your own ritual';

  @override
  String get ritualGetDailyReminders => 'Get daily reminders';

  @override
  String get ritualAlbumNotSet => 'Album not set';

  @override
  String get ritualOpenCameraTooltip => 'Open ritual camera';

  @override
  String get ritualEditorLabel => 'Ritual editor';

  @override
  String get ritualNew => 'New ritual';

  @override
  String get ritualEdit => 'Edit ritual';

  @override
  String get ritualEnterPrompt => 'Enter your ritual';

  @override
  String get ritualEnterDescription => 'Please enter a description';

  @override
  String get ritualDayLabel => 'Day';

  @override
  String get ritualNotificationsOffHint =>
      'Notifications are off. Tap a day to turn them on.';

  @override
  String get ritualTimeLabel => 'Time';

  @override
  String get ritualAlbumLabel => 'Album';

  @override
  String get ritualSave => 'Save ritual';

  @override
  String get ritualUpdate => 'Update ritual';

  @override
  String get ritualSelectAlbumTitle => 'Select album';

  @override
  String get ritualSearchOrCreate => 'Search or create new';

  @override
  String get ritualNoAlbumsYet => 'No albums yet';

  @override
  String get ritualNoMatchingAlbums => 'No matching albums';

  @override
  String ritualCreateAlbumWithName({required String albumName}) {
    return 'Create \"$albumName\"';
  }

  @override
  String get ritualCreateNew => 'Create new';

  @override
  String get ritualAlbumSelectionPlaceholder => 'Select album';

  @override
  String get ritualPickEmojiTitle => 'Pick an emoji';

  @override
  String get ritualCustomKeyboardLabel => 'Custom (keyboard)';

  @override
  String get ritualEmojiKeyboardHint => 'Press to open emoji keyboard';

  @override
  String get ritualEmojiUseAction => 'Use';

  @override
  String get ritualSearchEmpty =>
      'Build a ritual to keep your photo habit going.';
}
