import 'dart:async';

import 'package:flutter/foundation.dart';
import 'package:flutter/widgets.dart';
import 'package:flutter_localizations/flutter_localizations.dart';
import 'package:intl/intl.dart' as intl;

import 'app_localizations_af.dart';
import 'app_localizations_ar.dart';
import 'app_localizations_be.dart';
import 'app_localizations_bg.dart';
import 'app_localizations_ca.dart';
import 'app_localizations_cs.dart';
import 'app_localizations_da.dart';
import 'app_localizations_de.dart';
import 'app_localizations_el.dart';
import 'app_localizations_en.dart';
import 'app_localizations_es.dart';
import 'app_localizations_et.dart';
import 'app_localizations_eu.dart';
import 'app_localizations_fa.dart';
import 'app_localizations_fr.dart';
import 'app_localizations_gu.dart';
import 'app_localizations_he.dart';
import 'app_localizations_hi.dart';
import 'app_localizations_hu.dart';
import 'app_localizations_id.dart';
import 'app_localizations_it.dart';
import 'app_localizations_ja.dart';
import 'app_localizations_km.dart';
import 'app_localizations_ko.dart';
import 'app_localizations_ku.dart';
import 'app_localizations_lt.dart';
import 'app_localizations_lv.dart';
import 'app_localizations_ml.dart';
import 'app_localizations_ms.dart';
import 'app_localizations_nl.dart';
import 'app_localizations_nn.dart';
import 'app_localizations_no.dart';
import 'app_localizations_or.dart';
import 'app_localizations_pl.dart';
import 'app_localizations_pt.dart';
import 'app_localizations_ro.dart';
import 'app_localizations_ru.dart';
import 'app_localizations_sk.dart';
import 'app_localizations_sl.dart';
import 'app_localizations_sr.dart';
import 'app_localizations_sv.dart';
import 'app_localizations_ta.dart';
import 'app_localizations_te.dart';
import 'app_localizations_th.dart';
import 'app_localizations_ti.dart';
import 'app_localizations_tr.dart';
import 'app_localizations_uk.dart';
import 'app_localizations_vi.dart';
import 'app_localizations_zh.dart';

// ignore_for_file: type=lint

/// Callers can lookup localized strings with an instance of AppLocalizations
/// returned by `AppLocalizations.of(context)`.
///
/// Applications need to include `AppLocalizations.delegate()` in their app's
/// `localizationDelegates` list, and the locales they support in the app's
/// `supportedLocales` list. For example:
///
/// ```dart
/// import 'intl/app_localizations.dart';
///
/// return MaterialApp(
///   localizationsDelegates: AppLocalizations.localizationsDelegates,
///   supportedLocales: AppLocalizations.supportedLocales,
///   home: MyApplicationHome(),
/// );
/// ```
///
/// ## Update pubspec.yaml
///
/// Please make sure to update your pubspec.yaml to include the following
/// packages:
///
/// ```yaml
/// dependencies:
///   # Internationalization support.
///   flutter_localizations:
///     sdk: flutter
///   intl: any # Use the pinned version from flutter_localizations
///
///   # Rest of dependencies
/// ```
///
/// ## iOS Applications
///
/// iOS applications define key application metadata, including supported
/// locales, in an Info.plist file that is built into the application bundle.
/// To configure the locales supported by your app, you’ll need to edit this
/// file.
///
/// First, open your project’s ios/Runner.xcworkspace Xcode workspace file.
/// Then, in the Project Navigator, open the Info.plist file under the Runner
/// project’s Runner folder.
///
/// Next, select the Information Property List item, select Add Item from the
/// Editor menu, then select Localizations from the pop-up menu.
///
/// Select and expand the newly-created Localizations item then, for each
/// locale your application supports, add a new item and select the locale
/// you wish to add from the pop-up menu in the Value field. This list should
/// be consistent with the languages listed in the AppLocalizations.supportedLocales
/// property.
abstract class AppLocalizations {
  AppLocalizations(String locale)
    : localeName = intl.Intl.canonicalizedLocale(locale.toString());

  final String localeName;

  static AppLocalizations of(BuildContext context) {
    return Localizations.of<AppLocalizations>(context, AppLocalizations)!;
  }

  static const LocalizationsDelegate<AppLocalizations> delegate =
      _AppLocalizationsDelegate();

  /// A list of this localizations delegate along with the default localizations
  /// delegates.
  ///
  /// Returns a list of localizations delegates containing this delegate along with
  /// GlobalMaterialLocalizations.delegate, GlobalCupertinoLocalizations.delegate,
  /// and GlobalWidgetsLocalizations.delegate.
  ///
  /// Additional delegates can be added by appending to this list in
  /// MaterialApp. This list does not have to be used at all if a custom list
  /// of delegates is preferred or required.
  static const List<LocalizationsDelegate<dynamic>> localizationsDelegates =
      <LocalizationsDelegate<dynamic>>[
        delegate,
        GlobalMaterialLocalizations.delegate,
        GlobalCupertinoLocalizations.delegate,
        GlobalWidgetsLocalizations.delegate,
      ];

  /// A list of this localizations delegate's supported locales.
  static const List<Locale> supportedLocales = <Locale>[
    Locale('af'),
    Locale('ar'),
    Locale('be'),
    Locale('bg'),
    Locale('ca'),
    Locale('cs'),
    Locale('da'),
    Locale('de'),
    Locale('el'),
    Locale('en'),
    Locale('es'),
    Locale('et'),
    Locale('eu'),
    Locale('fa'),
    Locale('fr'),
    Locale('gu'),
    Locale('he'),
    Locale('hi'),
    Locale('hu'),
    Locale('id'),
    Locale('it'),
    Locale('ja'),
    Locale('km'),
    Locale('ko'),
    Locale('ku'),
    Locale('lt'),
    Locale('lv'),
    Locale('ml'),
    Locale('ms'),
    Locale('nl'),
    Locale('nn'),
    Locale('no'),
    Locale('or'),
    Locale('pl'),
    Locale('pt'),
    Locale('pt', 'BR'),
    Locale('pt', 'PT'),
    Locale('ro'),
    Locale('ru'),
    Locale('sk'),
    Locale('sl'),
    Locale('sr'),
    Locale('sv'),
    Locale('ta'),
    Locale('te'),
    Locale('th'),
    Locale('ti'),
    Locale('tr'),
    Locale('uk'),
    Locale('vi'),
    Locale('zh'),
  ];

  /// No description provided for @enterYourEmailAddress.
  ///
  /// In en, this message translates to:
  /// **'Enter your email address'**
  String get enterYourEmailAddress;

  /// No description provided for @enterYourNewEmailAddress.
  ///
  /// In en, this message translates to:
  /// **'Enter your new email address'**
  String get enterYourNewEmailAddress;

  /// No description provided for @accountWelcomeBack.
  ///
  /// In en, this message translates to:
  /// **'Welcome back!'**
  String get accountWelcomeBack;

  /// No description provided for @emailAlreadyRegistered.
  ///
  /// In en, this message translates to:
  /// **'Email already registered.'**
  String get emailAlreadyRegistered;

  /// No description provided for @emailNotRegistered.
  ///
  /// In en, this message translates to:
  /// **'Email not registered.'**
  String get emailNotRegistered;

  /// No description provided for @email.
  ///
  /// In en, this message translates to:
  /// **'Email'**
  String get email;

  /// No description provided for @cancel.
  ///
  /// In en, this message translates to:
  /// **'Cancel'**
  String get cancel;

  /// No description provided for @verify.
  ///
  /// In en, this message translates to:
  /// **'Verify'**
  String get verify;

  /// No description provided for @invalidEmailAddress.
  ///
  /// In en, this message translates to:
  /// **'Invalid email address'**
  String get invalidEmailAddress;

  /// No description provided for @enterValidEmail.
  ///
  /// In en, this message translates to:
  /// **'Please enter a valid email address.'**
  String get enterValidEmail;

  /// No description provided for @deleteAccount.
  ///
  /// In en, this message translates to:
  /// **'Delete account'**
  String get deleteAccount;

  /// No description provided for @deleteAccountWarning.
  ///
  /// In en, this message translates to:
  /// **'This will delete your Ente Auth, Ente Photos and Ente Locker account.'**
  String get deleteAccountWarning;

  /// No description provided for @askDeleteReason.
  ///
  /// In en, this message translates to:
  /// **'What is the main reason you are deleting your account?'**
  String get askDeleteReason;

  /// No description provided for @deleteAccountFeedbackPrompt.
  ///
  /// In en, this message translates to:
  /// **'We are sorry to see you go. Please share your feedback to help us improve.'**
  String get deleteAccountFeedbackPrompt;

  /// No description provided for @feedback.
  ///
  /// In en, this message translates to:
  /// **'Feedback'**
  String get feedback;

  /// No description provided for @kindlyHelpUsWithThisInformation.
  ///
  /// In en, this message translates to:
  /// **'Kindly help us with this information'**
  String get kindlyHelpUsWithThisInformation;

  /// No description provided for @confirmDeletePrompt.
  ///
  /// In en, this message translates to:
  /// **'Yes, I want to permanently delete this account and its data across all apps.'**
  String get confirmDeletePrompt;

  /// No description provided for @confirmAccountDeletion.
  ///
  /// In en, this message translates to:
  /// **'Confirm Account Deletion'**
  String get confirmAccountDeletion;

  /// No description provided for @deleteAccountPermanentlyButton.
  ///
  /// In en, this message translates to:
  /// **'Delete Account Permanently'**
  String get deleteAccountPermanentlyButton;

  /// No description provided for @yourAccountHasBeenDeleted.
  ///
  /// In en, this message translates to:
  /// **'Your account has been deleted'**
  String get yourAccountHasBeenDeleted;

  /// No description provided for @selectReason.
  ///
  /// In en, this message translates to:
  /// **'Select reason'**
  String get selectReason;

  /// No description provided for @deleteReason1.
  ///
  /// In en, this message translates to:
  /// **'It’s missing a key feature that I need'**
  String get deleteReason1;

  /// No description provided for @deleteReason2.
  ///
  /// In en, this message translates to:
  /// **'The app or a certain feature does not behave as I think it should'**
  String get deleteReason2;

  /// No description provided for @deleteReason3.
  ///
  /// In en, this message translates to:
  /// **'I found another service that I like better'**
  String get deleteReason3;

  /// No description provided for @deleteReason4.
  ///
  /// In en, this message translates to:
  /// **'My reason isn’t listed'**
  String get deleteReason4;

  /// No description provided for @sendEmail.
  ///
  /// In en, this message translates to:
  /// **'Send email'**
  String get sendEmail;

  /// No description provided for @deleteRequestSLAText.
  ///
  /// In en, this message translates to:
  /// **'Your request will be processed within 72 hours.'**
  String get deleteRequestSLAText;

  /// No description provided for @deleteEmailRequest.
  ///
  /// In en, this message translates to:
  /// **'Please send an email to <warning>account-deletion@ente.io</warning> from your registered email address.'**
  String get deleteEmailRequest;

  /// No description provided for @entePhotosPerm.
  ///
  /// In en, this message translates to:
  /// **'Ente <i>needs permission to</i> preserve your photos'**
  String get entePhotosPerm;

  /// No description provided for @ok.
  ///
  /// In en, this message translates to:
  /// **'Ok'**
  String get ok;

  /// No description provided for @createAccount.
  ///
  /// In en, this message translates to:
  /// **'Create account'**
  String get createAccount;

  /// No description provided for @createNewAccount.
  ///
  /// In en, this message translates to:
  /// **'Create new account'**
  String get createNewAccount;

  /// No description provided for @password.
  ///
  /// In en, this message translates to:
  /// **'Password'**
  String get password;

  /// No description provided for @confirmPassword.
  ///
  /// In en, this message translates to:
  /// **'Confirm password'**
  String get confirmPassword;

  /// No description provided for @activeSessions.
  ///
  /// In en, this message translates to:
  /// **'Active sessions'**
  String get activeSessions;

  /// No description provided for @ocrProcessingOverlayMessage.
  ///
  /// In en, this message translates to:
  /// **'Detecting text...'**
  String get ocrProcessingOverlayMessage;

  /// No description provided for @ocrLoadingIndicatorLabel.
  ///
  /// In en, this message translates to:
  /// **'Detecting Text'**
  String get ocrLoadingIndicatorLabel;

  /// No description provided for @ocrSelectionHint.
  ///
  /// In en, this message translates to:
  /// **'Swipe or double tap to select just what you need'**
  String get ocrSelectionHint;

  /// No description provided for @ocrNoTextDetected.
  ///
  /// In en, this message translates to:
  /// **'No text detected'**
  String get ocrNoTextDetected;

  /// No description provided for @ocrRetryButtonLabel.
  ///
  /// In en, this message translates to:
  /// **'Retry'**
  String get ocrRetryButtonLabel;

  /// No description provided for @ocrModelsNetworkRequiredError.
  ///
  /// In en, this message translates to:
  /// **'Network connection required to download OCR models on first use'**
  String get ocrModelsNetworkRequiredError;

  /// No description provided for @ocrModelsPrepareFailed.
  ///
  /// In en, this message translates to:
  /// **'Could not prepare OCR models'**
  String get ocrModelsPrepareFailed;

  /// No description provided for @ocrImageNotFoundError.
  ///
  /// In en, this message translates to:
  /// **'Image file not found'**
  String get ocrImageNotFoundError;

  /// No description provided for @ocrImageDecodeFailedError.
  ///
  /// In en, this message translates to:
  /// **'Could not read image file'**
  String get ocrImageDecodeFailedError;

  /// No description provided for @ocrGenericDetectError.
  ///
  /// In en, this message translates to:
  /// **'Could not detect text in image'**
  String get ocrGenericDetectError;

  /// No description provided for @oops.
  ///
  /// In en, this message translates to:
  /// **'Oops'**
  String get oops;

  /// No description provided for @somethingWentWrongPleaseTryAgain.
  ///
  /// In en, this message translates to:
  /// **'Something went wrong, please try again'**
  String get somethingWentWrongPleaseTryAgain;

  /// No description provided for @thisWillLogYouOutOfThisDevice.
  ///
  /// In en, this message translates to:
  /// **'This will log you out of this device!'**
  String get thisWillLogYouOutOfThisDevice;

  /// No description provided for @thisWillLogYouOutOfTheFollowingDevice.
  ///
  /// In en, this message translates to:
  /// **'This will log you out of the following device:'**
  String get thisWillLogYouOutOfTheFollowingDevice;

  /// No description provided for @terminateSession.
  ///
  /// In en, this message translates to:
  /// **'Terminate session?'**
  String get terminateSession;

  /// No description provided for @terminate.
  ///
  /// In en, this message translates to:
  /// **'Terminate'**
  String get terminate;

  /// No description provided for @thisDevice.
  ///
  /// In en, this message translates to:
  /// **'This device'**
  String get thisDevice;

  /// No description provided for @recoverButton.
  ///
  /// In en, this message translates to:
  /// **'Recover'**
  String get recoverButton;

  /// No description provided for @recoverySuccessful.
  ///
  /// In en, this message translates to:
  /// **'Recovery successful!'**
  String get recoverySuccessful;

  /// No description provided for @decrypting.
  ///
  /// In en, this message translates to:
  /// **'Decrypting...'**
  String get decrypting;

  /// No description provided for @incorrectRecoveryKeyTitle.
  ///
  /// In en, this message translates to:
  /// **'Incorrect recovery key'**
  String get incorrectRecoveryKeyTitle;

  /// No description provided for @incorrectRecoveryKeyBody.
  ///
  /// In en, this message translates to:
  /// **'The recovery key you entered is incorrect'**
  String get incorrectRecoveryKeyBody;

  /// No description provided for @forgotPassword.
  ///
  /// In en, this message translates to:
  /// **'Forgot password'**
  String get forgotPassword;

  /// No description provided for @enterYourRecoveryKey.
  ///
  /// In en, this message translates to:
  /// **'Enter your recovery key'**
  String get enterYourRecoveryKey;

  /// No description provided for @noRecoveryKey.
  ///
  /// In en, this message translates to:
  /// **'No recovery key?'**
  String get noRecoveryKey;

  /// No description provided for @sorry.
  ///
  /// In en, this message translates to:
  /// **'Sorry'**
  String get sorry;

  /// No description provided for @noRecoveryKeyNoDecryption.
  ///
  /// In en, this message translates to:
  /// **'Due to the nature of our end-to-end encryption protocol, your data cannot be decrypted without your password or recovery key'**
  String get noRecoveryKeyNoDecryption;

  /// No description provided for @verifyEmail.
  ///
  /// In en, this message translates to:
  /// **'Verify email'**
  String get verifyEmail;

  /// No description provided for @toResetVerifyEmail.
  ///
  /// In en, this message translates to:
  /// **'To reset your password, please verify your email first.'**
  String get toResetVerifyEmail;

  /// No description provided for @checkInboxAndSpamFolder.
  ///
  /// In en, this message translates to:
  /// **'Please check your inbox (and spam) to complete verification'**
  String get checkInboxAndSpamFolder;

  /// No description provided for @tapToEnterCode.
  ///
  /// In en, this message translates to:
  /// **'Tap to enter code'**
  String get tapToEnterCode;

  /// No description provided for @resendEmail.
  ///
  /// In en, this message translates to:
  /// **'Resend email'**
  String get resendEmail;

  /// Text to indicate that we have sent a mail to the user
  ///
  /// In en, this message translates to:
  /// **'We have sent a mail to <green>{email}</green>'**
  String weHaveSendEmailTo({required String email});

  /// No description provided for @setPasswordTitle.
  ///
  /// In en, this message translates to:
  /// **'Set password'**
  String get setPasswordTitle;

  /// No description provided for @changePasswordTitle.
  ///
  /// In en, this message translates to:
  /// **'Change password'**
  String get changePasswordTitle;

  /// No description provided for @resetPasswordTitle.
  ///
  /// In en, this message translates to:
  /// **'Reset password'**
  String get resetPasswordTitle;

  /// No description provided for @encryptionKeys.
  ///
  /// In en, this message translates to:
  /// **'Encryption keys'**
  String get encryptionKeys;

  /// No description provided for @passwordWarning.
  ///
  /// In en, this message translates to:
  /// **'We don\'t store this password, so if you forget, <underline>we cannot decrypt your data</underline>'**
  String get passwordWarning;

  /// No description provided for @enterPasswordToEncrypt.
  ///
  /// In en, this message translates to:
  /// **'Enter a password we can use to encrypt your data'**
  String get enterPasswordToEncrypt;

  /// No description provided for @enterNewPasswordToEncrypt.
  ///
  /// In en, this message translates to:
  /// **'Enter a new password we can use to encrypt your data'**
  String get enterNewPasswordToEncrypt;

  /// No description provided for @weakStrength.
  ///
  /// In en, this message translates to:
  /// **'Weak'**
  String get weakStrength;

  /// No description provided for @strongStrength.
  ///
  /// In en, this message translates to:
  /// **'Strong'**
  String get strongStrength;

  /// No description provided for @moderateStrength.
  ///
  /// In en, this message translates to:
  /// **'Moderate'**
  String get moderateStrength;

  /// Text to indicate the password strength
  ///
  /// In en, this message translates to:
  /// **'Password strength: {passwordStrengthValue}'**
  String passwordStrength({required String passwordStrengthValue});

  /// No description provided for @passwordChangedSuccessfully.
  ///
  /// In en, this message translates to:
  /// **'Password changed successfully'**
  String get passwordChangedSuccessfully;

  /// No description provided for @generatingEncryptionKeys.
  ///
  /// In en, this message translates to:
  /// **'Generating encryption keys...'**
  String get generatingEncryptionKeys;

  /// No description provided for @pleaseWait.
  ///
  /// In en, this message translates to:
  /// **'Please wait...'**
  String get pleaseWait;

  /// No description provided for @continueLabel.
  ///
  /// In en, this message translates to:
  /// **'Continue'**
  String get continueLabel;

  /// No description provided for @insecureDevice.
  ///
  /// In en, this message translates to:
  /// **'Insecure device'**
  String get insecureDevice;

  /// No description provided for @sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease.
  ///
  /// In en, this message translates to:
  /// **'Sorry, we could not generate secure keys on this device.\n\nplease sign up from a different device.'**
  String get sorryWeCouldNotGenerateSecureKeysOnThisDevicennplease;

  /// No description provided for @howItWorks.
  ///
  /// In en, this message translates to:
  /// **'How it works'**
  String get howItWorks;

  /// No description provided for @encryption.
  ///
  /// In en, this message translates to:
  /// **'Encryption'**
  String get encryption;

  /// No description provided for @ackPasswordLostWarning.
  ///
  /// In en, this message translates to:
  /// **'I understand that if I lose my password, I may lose my data since my data is <underline>end-to-end encrypted</underline>.'**
  String get ackPasswordLostWarning;

  /// No description provided for @privacyPolicyTitle.
  ///
  /// In en, this message translates to:
  /// **'Privacy Policy'**
  String get privacyPolicyTitle;

  /// No description provided for @termsOfServicesTitle.
  ///
  /// In en, this message translates to:
  /// **'Terms'**
  String get termsOfServicesTitle;

  /// No description provided for @signUpTerms.
  ///
  /// In en, this message translates to:
  /// **'I agree to the <u-terms>terms of service</u-terms> and <u-policy>privacy policy</u-policy>'**
  String get signUpTerms;

  /// No description provided for @logInLabel.
  ///
  /// In en, this message translates to:
  /// **'Log in'**
  String get logInLabel;

  /// No description provided for @loginTerms.
  ///
  /// In en, this message translates to:
  /// **'By clicking log in, I agree to the <u-terms>terms of service</u-terms> and <u-policy>privacy policy</u-policy>'**
  String get loginTerms;

  /// No description provided for @changeEmail.
  ///
  /// In en, this message translates to:
  /// **'Change email'**
  String get changeEmail;

  /// No description provided for @enterYourPassword.
  ///
  /// In en, this message translates to:
  /// **'Enter your password'**
  String get enterYourPassword;

  /// No description provided for @welcomeBack.
  ///
  /// In en, this message translates to:
  /// **'Welcome back!'**
  String get welcomeBack;

  /// No description provided for @contactSupport.
  ///
  /// In en, this message translates to:
  /// **'Contact support'**
  String get contactSupport;

  /// Helper tip text shown in the location picker that refers to the photo info screen.
  ///
  /// In en, this message translates to:
  /// **'You can also add a location centered on a photo from the photo\'s info screen'**
  String get locationPickerTip;

  /// No description provided for @incorrectPasswordTitle.
  ///
  /// In en, this message translates to:
  /// **'Incorrect password'**
  String get incorrectPasswordTitle;

  /// No description provided for @pleaseTryAgain.
  ///
  /// In en, this message translates to:
  /// **'Please try again'**
  String get pleaseTryAgain;

  /// No description provided for @recreatePasswordTitle.
  ///
  /// In en, this message translates to:
  /// **'Recreate password'**
  String get recreatePasswordTitle;

  /// No description provided for @useRecoveryKey.
  ///
  /// In en, this message translates to:
  /// **'Use recovery key'**
  String get useRecoveryKey;

  /// No description provided for @recreatePasswordBody.
  ///
  /// In en, this message translates to:
  /// **'The current device is not powerful enough to verify your password, but we can regenerate in a way that works with all devices.\n\nPlease login using your recovery key and regenerate your password (you can use the same one again if you wish).'**
  String get recreatePasswordBody;

  /// No description provided for @verifyPassword.
  ///
  /// In en, this message translates to:
  /// **'Verify password'**
  String get verifyPassword;

  /// No description provided for @recoveryKey.
  ///
  /// In en, this message translates to:
  /// **'Recovery key'**
  String get recoveryKey;

  /// No description provided for @recoveryKeyOnForgotPassword.
  ///
  /// In en, this message translates to:
  /// **'If you forget your password, the only way you can recover your data is with this key.'**
  String get recoveryKeyOnForgotPassword;

  /// No description provided for @recoveryKeySaveDescription.
  ///
  /// In en, this message translates to:
  /// **'We don\'t store this key, please save this 24 word key in a safe place.'**
  String get recoveryKeySaveDescription;

  /// No description provided for @doThisLater.
  ///
  /// In en, this message translates to:
  /// **'Do this later'**
  String get doThisLater;

  /// No description provided for @saveKey.
  ///
  /// In en, this message translates to:
  /// **'Save key'**
  String get saveKey;

  /// No description provided for @recoveryKeyCopiedToClipboard.
  ///
  /// In en, this message translates to:
  /// **'Recovery key copied to clipboard'**
  String get recoveryKeyCopiedToClipboard;

  /// No description provided for @recoverAccount.
  ///
  /// In en, this message translates to:
  /// **'Recover account'**
  String get recoverAccount;

  /// No description provided for @recover.
  ///
  /// In en, this message translates to:
  /// **'Recover'**
  String get recover;

  /// No description provided for @dropSupportEmail.
  ///
  /// In en, this message translates to:
  /// **'Please drop an email to {supportEmail} from your registered email address'**
  String dropSupportEmail({required String supportEmail});

  /// No description provided for @twofactorSetup.
  ///
  /// In en, this message translates to:
  /// **'Two-factor setup'**
  String get twofactorSetup;

  /// No description provided for @enterCode.
  ///
  /// In en, this message translates to:
  /// **'Enter code'**
  String get enterCode;

  /// No description provided for @scanCode.
  ///
  /// In en, this message translates to:
  /// **'Scan code'**
  String get scanCode;

  /// No description provided for @codeCopiedToClipboard.
  ///
  /// In en, this message translates to:
  /// **'Code copied to clipboard'**
  String get codeCopiedToClipboard;

  /// No description provided for @copypasteThisCodentoYourAuthenticatorApp.
  ///
  /// In en, this message translates to:
  /// **'Copy-paste this code\nto your authenticator app'**
  String get copypasteThisCodentoYourAuthenticatorApp;

  /// No description provided for @tapToCopy.
  ///
  /// In en, this message translates to:
  /// **'tap to copy'**
  String get tapToCopy;

  /// No description provided for @scanThisBarcodeWithnyourAuthenticatorApp.
  ///
  /// In en, this message translates to:
  /// **'Scan this barcode with\nyour authenticator app'**
  String get scanThisBarcodeWithnyourAuthenticatorApp;

  /// No description provided for @enterThe6digitCodeFromnyourAuthenticatorApp.
  ///
  /// In en, this message translates to:
  /// **'Enter the 6-digit code from\nyour authenticator app'**
  String get enterThe6digitCodeFromnyourAuthenticatorApp;

  /// No description provided for @confirm.
  ///
  /// In en, this message translates to:
  /// **'Confirm'**
  String get confirm;

  /// No description provided for @setupComplete.
  ///
  /// In en, this message translates to:
  /// **'Setup complete'**
  String get setupComplete;

  /// No description provided for @saveYourRecoveryKeyIfYouHaventAlready.
  ///
  /// In en, this message translates to:
  /// **'Save your recovery key if you haven\'t already'**
  String get saveYourRecoveryKeyIfYouHaventAlready;

  /// No description provided for @thisCanBeUsedToRecoverYourAccountIfYou.
  ///
  /// In en, this message translates to:
  /// **'This can be used to recover your account if you lose your second factor'**
  String get thisCanBeUsedToRecoverYourAccountIfYou;

  /// No description provided for @twofactorAuthenticationPageTitle.
  ///
  /// In en, this message translates to:
  /// **'Two-factor authentication'**
  String get twofactorAuthenticationPageTitle;

  /// No description provided for @lostDevice.
  ///
  /// In en, this message translates to:
  /// **'Lost device?'**
  String get lostDevice;

  /// No description provided for @verifyingRecoveryKey.
  ///
  /// In en, this message translates to:
  /// **'Verifying recovery key...'**
  String get verifyingRecoveryKey;

  /// No description provided for @recoveryKeyVerified.
  ///
  /// In en, this message translates to:
  /// **'Recovery key verified'**
  String get recoveryKeyVerified;

  /// No description provided for @recoveryKeySuccessBody.
  ///
  /// In en, this message translates to:
  /// **'Great! Your recovery key is valid. Thank you for verifying.\n\nPlease remember to keep your recovery key safely backed up.'**
  String get recoveryKeySuccessBody;

  /// No description provided for @invalidRecoveryKey.
  ///
  /// In en, this message translates to:
  /// **'The recovery key you entered is not valid. Please make sure it contains 24 words, and check the spelling of each.\n\nIf you entered an older recovery code, make sure it is 64 characters long, and check each of them.'**
  String get invalidRecoveryKey;

  /// No description provided for @invalidKey.
  ///
  /// In en, this message translates to:
  /// **'Invalid key'**
  String get invalidKey;

  /// No description provided for @tryAgain.
  ///
  /// In en, this message translates to:
  /// **'Try again'**
  String get tryAgain;

  /// No description provided for @viewRecoveryKey.
  ///
  /// In en, this message translates to:
  /// **'View recovery key'**
  String get viewRecoveryKey;

  /// No description provided for @confirmRecoveryKey.
  ///
  /// In en, this message translates to:
  /// **'Confirm recovery key'**
  String get confirmRecoveryKey;

  /// No description provided for @recoveryKeyVerifyReason.
  ///
  /// In en, this message translates to:
  /// **'Your recovery key is the only way to recover your photos if you forget your password. You can find your recovery key in Settings > Account.\n\nPlease enter your recovery key here to verify that you have saved it correctly.'**
  String get recoveryKeyVerifyReason;

  /// No description provided for @confirmYourRecoveryKey.
  ///
  /// In en, this message translates to:
  /// **'Confirm your recovery key'**
  String get confirmYourRecoveryKey;

  /// No description provided for @addViewer.
  ///
  /// In en, this message translates to:
  /// **'Add viewer'**
  String get addViewer;

  /// No description provided for @addCollaborator.
  ///
  /// In en, this message translates to:
  /// **'Add collaborator'**
  String get addCollaborator;

  /// No description provided for @addANewEmail.
  ///
  /// In en, this message translates to:
  /// **'Add a new email'**
  String get addANewEmail;

  /// No description provided for @orPickAnExistingOne.
  ///
  /// In en, this message translates to:
  /// **'Or pick an existing one'**
  String get orPickAnExistingOne;

  /// No description provided for @collaboratorsCanAddPhotosAndVideosToTheSharedAlbum.
  ///
  /// In en, this message translates to:
  /// **'Collaborators can add photos and videos to the shared album.'**
  String get collaboratorsCanAddPhotosAndVideosToTheSharedAlbum;

  /// No description provided for @enterEmail.
  ///
  /// In en, this message translates to:
  /// **'Enter email'**
  String get enterEmail;

  /// Role of the album owner
  ///
  /// In en, this message translates to:
  /// **'Owner'**
  String get albumOwner;

  /// No description provided for @you.
  ///
  /// In en, this message translates to:
  /// **'You'**
  String get you;

  /// No description provided for @collaborator.
  ///
  /// In en, this message translates to:
  /// **'Collaborator'**
  String get collaborator;

  /// Button text to add more collaborators/viewers
  ///
  /// In en, this message translates to:
  /// **'Add more'**
  String get addMore;

  /// No description provided for @viewer.
  ///
  /// In en, this message translates to:
  /// **'Viewer'**
  String get viewer;

  /// No description provided for @remove.
  ///
  /// In en, this message translates to:
  /// **'Remove'**
  String get remove;

  /// menuSectionTitle for removing a participant
  ///
  /// In en, this message translates to:
  /// **'Remove participant'**
  String get removeParticipant;

  /// No description provided for @manage.
  ///
  /// In en, this message translates to:
  /// **'Manage'**
  String get manage;

  /// No description provided for @addedAs.
  ///
  /// In en, this message translates to:
  /// **'Added as'**
  String get addedAs;

  /// No description provided for @changePermissions.
  ///
  /// In en, this message translates to:
  /// **'Change permissions?'**
  String get changePermissions;

  /// No description provided for @yesConvertToViewer.
  ///
  /// In en, this message translates to:
  /// **'Yes, convert to viewer'**
  String get yesConvertToViewer;

  /// No description provided for @cannotAddMorePhotosAfterBecomingViewer.
  ///
  /// In en, this message translates to:
  /// **'{user} will not be able to add more photos to this album\n\nThey will still be able to remove existing photos added by them'**
  String cannotAddMorePhotosAfterBecomingViewer({required Object user});

  /// Switch button to enable uploading photos to a public link
  ///
  /// In en, this message translates to:
  /// **'Allow adding photos'**
  String get allowAddingPhotos;

  /// No description provided for @allowJoiningAlbum.
  ///
  /// In en, this message translates to:
  /// **'Allow joining album'**
  String get allowJoiningAlbum;

  /// No description provided for @allowAddPhotosDescription.
  ///
  /// In en, this message translates to:
  /// **'Allow people with the link to also add photos to the shared album.'**
  String get allowAddPhotosDescription;

  /// No description provided for @passwordLock.
  ///
  /// In en, this message translates to:
  /// **'Password lock'**
  String get passwordLock;

  /// No description provided for @canNotOpenTitle.
  ///
  /// In en, this message translates to:
  /// **'Cannot open this album'**
  String get canNotOpenTitle;

  /// No description provided for @canNotOpenBody.
  ///
  /// In en, this message translates to:
  /// **'Sorry, this album cannot be opened in the app.'**
  String get canNotOpenBody;

  /// No description provided for @disableDownloadWarningTitle.
  ///
  /// In en, this message translates to:
  /// **'Please note'**
  String get disableDownloadWarningTitle;

  /// No description provided for @disableDownloadWarningBody.
  ///
  /// In en, this message translates to:
  /// **'Viewers can still take screenshots or save a copy of your photos using external tools'**
  String get disableDownloadWarningBody;

  /// No description provided for @allowDownloads.
  ///
  /// In en, this message translates to:
  /// **'Allow downloads'**
  String get allowDownloads;

  /// No description provided for @linkDeviceLimit.
  ///
  /// In en, this message translates to:
  /// **'Device limit'**
  String get linkDeviceLimit;

  /// Text to indicate that there is limit on number of devices
  ///
  /// In en, this message translates to:
  /// **'None'**
  String get noDeviceLimit;

  /// No description provided for @albumLayout.
  ///
  /// In en, this message translates to:
  /// **'Album layout'**
  String get albumLayout;

  /// No description provided for @layoutGrouped.
  ///
  /// In en, this message translates to:
  /// **'Grouped'**
  String get layoutGrouped;

  /// No description provided for @layoutContinuous.
  ///
  /// In en, this message translates to:
  /// **'Continuous'**
  String get layoutContinuous;

  /// No description provided for @layoutTrip.
  ///
  /// In en, this message translates to:
  /// **'Trip'**
  String get layoutTrip;

  /// No description provided for @preview.
  ///
  /// In en, this message translates to:
  /// **'Preview'**
  String get preview;

  /// No description provided for @linkExpiry.
  ///
  /// In en, this message translates to:
  /// **'Link expiry'**
  String get linkExpiry;

  /// No description provided for @linkExpired.
  ///
  /// In en, this message translates to:
  /// **'Expired'**
  String get linkExpired;

  /// No description provided for @linkEnabled.
  ///
  /// In en, this message translates to:
  /// **'Enabled'**
  String get linkEnabled;

  /// No description provided for @linkNeverExpires.
  ///
  /// In en, this message translates to:
  /// **'Never'**
  String get linkNeverExpires;

  /// No description provided for @expiredLinkInfo.
  ///
  /// In en, this message translates to:
  /// **'This link has expired. Please select a new expiry time or disable link expiry.'**
  String get expiredLinkInfo;

  /// No description provided for @setAPassword.
  ///
  /// In en, this message translates to:
  /// **'Set a password'**
  String get setAPassword;

  /// No description provided for @lockButtonLabel.
  ///
  /// In en, this message translates to:
  /// **'Lock'**
  String get lockButtonLabel;

  /// No description provided for @enterPassword.
  ///
  /// In en, this message translates to:
  /// **'Enter password'**
  String get enterPassword;

  /// No description provided for @removeLink.
  ///
  /// In en, this message translates to:
  /// **'Remove link'**
  String get removeLink;

  /// No description provided for @manageLink.
  ///
  /// In en, this message translates to:
  /// **'Manage link'**
  String get manageLink;

  /// No description provided for @linkExpiresOn.
  ///
  /// In en, this message translates to:
  /// **'Link will expire on {expiryTime}'**
  String linkExpiresOn({required Object expiryTime});

  /// No description provided for @albumUpdated.
  ///
  /// In en, this message translates to:
  /// **'Album updated'**
  String get albumUpdated;

  /// No description provided for @never.
  ///
  /// In en, this message translates to:
  /// **'Never'**
  String get never;

  /// Label for setting custom value for link expiry
  ///
  /// In en, this message translates to:
  /// **'Custom'**
  String get custom;

  /// No description provided for @after1Hour.
  ///
  /// In en, this message translates to:
  /// **'After 1 hour'**
  String get after1Hour;

  /// No description provided for @after1Day.
  ///
  /// In en, this message translates to:
  /// **'After 1 day'**
  String get after1Day;

  /// No description provided for @after1Week.
  ///
  /// In en, this message translates to:
  /// **'After 1 week'**
  String get after1Week;

  /// No description provided for @after1Month.
  ///
  /// In en, this message translates to:
  /// **'After 1 month'**
  String get after1Month;

  /// No description provided for @after1Year.
  ///
  /// In en, this message translates to:
  /// **'After 1 year'**
  String get after1Year;

  /// No description provided for @manageParticipants.
  ///
  /// In en, this message translates to:
  /// **'Manage'**
  String get manageParticipants;

  /// Number of participants in an album, including the album owner.
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =0 {No Participants} =1 {1 Participant} other {{count} Participants}}'**
  String albumParticipantsCount({required int count});

  /// No description provided for @collabLinkSectionDescription.
  ///
  /// In en, this message translates to:
  /// **'Create a link to allow people to add and view photos in your shared album without needing an Ente app or account. Great for collecting event photos.'**
  String get collabLinkSectionDescription;

  /// No description provided for @collectPhotos.
  ///
  /// In en, this message translates to:
  /// **'Collect photos'**
  String get collectPhotos;

  /// No description provided for @collaborativeLink.
  ///
  /// In en, this message translates to:
  /// **'Collaborative link'**
  String get collaborativeLink;

  /// No description provided for @shareWithNonenteUsers.
  ///
  /// In en, this message translates to:
  /// **'Share with non-Ente users'**
  String get shareWithNonenteUsers;

  /// No description provided for @createPublicLink.
  ///
  /// In en, this message translates to:
  /// **'Create public link'**
  String get createPublicLink;

  /// No description provided for @sendLink.
  ///
  /// In en, this message translates to:
  /// **'Send link'**
  String get sendLink;

  /// No description provided for @qrCode.
  ///
  /// In en, this message translates to:
  /// **'QR Code'**
  String get qrCode;

  /// No description provided for @sendQrCode.
  ///
  /// In en, this message translates to:
  /// **'Send QR code'**
  String get sendQrCode;

  /// No description provided for @copyLink.
  ///
  /// In en, this message translates to:
  /// **'Copy link'**
  String get copyLink;

  /// No description provided for @copyEmbedHtml.
  ///
  /// In en, this message translates to:
  /// **'Copy embed HTML'**
  String get copyEmbedHtml;

  /// No description provided for @linkHasExpired.
  ///
  /// In en, this message translates to:
  /// **'Link has expired'**
  String get linkHasExpired;

  /// No description provided for @publicLinkEnabled.
  ///
  /// In en, this message translates to:
  /// **'Public link enabled'**
  String get publicLinkEnabled;

  /// No description provided for @shareALink.
  ///
  /// In en, this message translates to:
  /// **'Share a link'**
  String get shareALink;

  /// No description provided for @sharedAlbumSectionDescription.
  ///
  /// In en, this message translates to:
  /// **'Create shared and collaborative albums with other Ente users, including users on free plans.'**
  String get sharedAlbumSectionDescription;

  /// No description provided for @shareWithPeopleSectionTitle.
  ///
  /// In en, this message translates to:
  /// **'{numberOfPeople, plural, =0 {Share with specific people} =1 {Shared with 1 person} other {Shared with {numberOfPeople} people}}'**
  String shareWithPeopleSectionTitle({required int numberOfPeople});

  /// No description provided for @thisIsYourVerificationId.
  ///
  /// In en, this message translates to:
  /// **'This is your Verification ID'**
  String get thisIsYourVerificationId;

  /// No description provided for @someoneSharingAlbumsWithYouShouldSeeTheSameId.
  ///
  /// In en, this message translates to:
  /// **'Someone sharing albums with you should see the same ID on their device.'**
  String get someoneSharingAlbumsWithYouShouldSeeTheSameId;

  /// No description provided for @howToViewShareeVerificationID.
  ///
  /// In en, this message translates to:
  /// **'Please ask them to long-press their email address on the settings screen, and verify that the IDs on both devices match.'**
  String get howToViewShareeVerificationID;

  /// No description provided for @thisIsPersonVerificationId.
  ///
  /// In en, this message translates to:
  /// **'This is {email}\'s Verification ID'**
  String thisIsPersonVerificationId({required String email});

  /// No description provided for @verificationId.
  ///
  /// In en, this message translates to:
  /// **'Verification ID'**
  String get verificationId;

  /// No description provided for @verifyEmailID.
  ///
  /// In en, this message translates to:
  /// **'Verify {email}'**
  String verifyEmailID({required Object email});

  /// No description provided for @emailNoEnteAccount.
  ///
  /// In en, this message translates to:
  /// **'{email} does not have an Ente account.\n\nSend them an invite to share photos.'**
  String emailNoEnteAccount({required Object email});

  /// No description provided for @shareMyVerificationID.
  ///
  /// In en, this message translates to:
  /// **'Here\'s my verification ID: {verificationID} for ente.io.'**
  String shareMyVerificationID({required Object verificationID});

  /// No description provided for @shareTextConfirmOthersVerificationID.
  ///
  /// In en, this message translates to:
  /// **'Hey, can you confirm that this is your ente.io verification ID: {verificationID}'**
  String shareTextConfirmOthersVerificationID({required Object verificationID});

  /// No description provided for @somethingWentWrong.
  ///
  /// In en, this message translates to:
  /// **'Something went wrong'**
  String get somethingWentWrong;

  /// No description provided for @sendInvite.
  ///
  /// In en, this message translates to:
  /// **'Send invite'**
  String get sendInvite;

  /// No description provided for @shareTextRecommendUsingEnte.
  ///
  /// In en, this message translates to:
  /// **'Download Ente so we can easily share original quality photos and videos\n\nhttps://ente.io'**
  String get shareTextRecommendUsingEnte;

  /// No description provided for @done.
  ///
  /// In en, this message translates to:
  /// **'Done'**
  String get done;

  /// No description provided for @applyCodeTitle.
  ///
  /// In en, this message translates to:
  /// **'Apply code'**
  String get applyCodeTitle;

  /// No description provided for @enterCodeDescription.
  ///
  /// In en, this message translates to:
  /// **'Enter the code provided by your friend to claim free storage for both of you'**
  String get enterCodeDescription;

  /// No description provided for @apply.
  ///
  /// In en, this message translates to:
  /// **'Apply'**
  String get apply;

  /// No description provided for @failedToApplyCode.
  ///
  /// In en, this message translates to:
  /// **'Failed to apply code'**
  String get failedToApplyCode;

  /// No description provided for @enterReferralCode.
  ///
  /// In en, this message translates to:
  /// **'Enter referral code'**
  String get enterReferralCode;

  /// No description provided for @codeAppliedPageTitle.
  ///
  /// In en, this message translates to:
  /// **'Code applied'**
  String get codeAppliedPageTitle;

  /// No description provided for @changeYourReferralCode.
  ///
  /// In en, this message translates to:
  /// **'Change your referral code'**
  String get changeYourReferralCode;

  /// No description provided for @change.
  ///
  /// In en, this message translates to:
  /// **'Change'**
  String get change;

  /// No description provided for @unavailableReferralCode.
  ///
  /// In en, this message translates to:
  /// **'Sorry, this code is unavailable.'**
  String get unavailableReferralCode;

  /// No description provided for @codeChangeLimitReached.
  ///
  /// In en, this message translates to:
  /// **'Sorry, you\'ve reached the limit of code changes.'**
  String get codeChangeLimitReached;

  /// No description provided for @onlyFamilyAdminCanChangeCode.
  ///
  /// In en, this message translates to:
  /// **'Please contact {familyAdminEmail} to change your code.'**
  String onlyFamilyAdminCanChangeCode({required Object familyAdminEmail});

  /// No description provided for @storageInGB.
  ///
  /// In en, this message translates to:
  /// **'{storageAmountInGB} GB'**
  String storageInGB({required Object storageAmountInGB});

  /// Used to indicate storage claimed, like 10GB Claimed
  ///
  /// In en, this message translates to:
  /// **'Claimed'**
  String get claimed;

  /// No description provided for @details.
  ///
  /// In en, this message translates to:
  /// **'Details'**
  String get details;

  /// No description provided for @claimMore.
  ///
  /// In en, this message translates to:
  /// **'Claim more!'**
  String get claimMore;

  /// No description provided for @theyAlsoGetXGb.
  ///
  /// In en, this message translates to:
  /// **'They also get {storageAmountInGB} GB'**
  String theyAlsoGetXGb({required Object storageAmountInGB});

  /// No description provided for @freeStorageOnReferralSuccess.
  ///
  /// In en, this message translates to:
  /// **'{storageAmountInGB} GB each time someone signs up for a paid plan and applies your code'**
  String freeStorageOnReferralSuccess({required Object storageAmountInGB});

  /// No description provided for @shareTextReferralCode.
  ///
  /// In en, this message translates to:
  /// **'Ente referral code: {referralCode} \n\nApply it in Settings → General → Referrals to get {referralStorageInGB} GB free after you signup for a paid plan\n\nhttps://ente.io'**
  String shareTextReferralCode({
    required Object referralCode,
    required Object referralStorageInGB,
  });

  /// No description provided for @claimFreeStorage.
  ///
  /// In en, this message translates to:
  /// **'Claim free storage'**
  String get claimFreeStorage;

  /// No description provided for @inviteYourFriends.
  ///
  /// In en, this message translates to:
  /// **'Invite your friends'**
  String get inviteYourFriends;

  /// No description provided for @failedToFetchReferralDetails.
  ///
  /// In en, this message translates to:
  /// **'Unable to fetch referral details. Please try again later.'**
  String get failedToFetchReferralDetails;

  /// No description provided for @referralStep1.
  ///
  /// In en, this message translates to:
  /// **'1. Give this code to your friends'**
  String get referralStep1;

  /// No description provided for @referralStep2.
  ///
  /// In en, this message translates to:
  /// **'2. They sign up for a paid plan'**
  String get referralStep2;

  /// No description provided for @referralStep3.
  ///
  /// In en, this message translates to:
  /// **'3. Both of you get {storageInGB} GB* free'**
  String referralStep3({required Object storageInGB});

  /// No description provided for @referralsAreCurrentlyPaused.
  ///
  /// In en, this message translates to:
  /// **'Referrals are currently paused'**
  String get referralsAreCurrentlyPaused;

  /// No description provided for @youCanAtMaxDoubleYourStorage.
  ///
  /// In en, this message translates to:
  /// **'* You can at max double your storage'**
  String get youCanAtMaxDoubleYourStorage;

  /// No description provided for @claimedStorageSoFar.
  ///
  /// In en, this message translates to:
  /// **'{isFamilyMember, select, true {Your family has claimed {storageAmountInGb} GB so far} false {You have claimed {storageAmountInGb} GB so far} other {You have claimed {storageAmountInGb} GB so far!}}'**
  String claimedStorageSoFar({
    required String isFamilyMember,
    required int storageAmountInGb,
  });

  /// No description provided for @faq.
  ///
  /// In en, this message translates to:
  /// **'FAQ'**
  String get faq;

  /// No description provided for @help.
  ///
  /// In en, this message translates to:
  /// **'Help'**
  String get help;

  /// No description provided for @oopsSomethingWentWrong.
  ///
  /// In en, this message translates to:
  /// **'Oops, something went wrong'**
  String get oopsSomethingWentWrong;

  /// No description provided for @peopleUsingYourCode.
  ///
  /// In en, this message translates to:
  /// **'People using your code'**
  String get peopleUsingYourCode;

  /// No description provided for @eligible.
  ///
  /// In en, this message translates to:
  /// **'eligible'**
  String get eligible;

  /// No description provided for @total.
  ///
  /// In en, this message translates to:
  /// **'total'**
  String get total;

  /// No description provided for @codeUsedByYou.
  ///
  /// In en, this message translates to:
  /// **'Code used by you'**
  String get codeUsedByYou;

  /// No description provided for @freeStorageClaimed.
  ///
  /// In en, this message translates to:
  /// **'Free storage claimed'**
  String get freeStorageClaimed;

  /// No description provided for @freeStorageUsable.
  ///
  /// In en, this message translates to:
  /// **'Free storage usable'**
  String get freeStorageUsable;

  /// No description provided for @usableReferralStorageInfo.
  ///
  /// In en, this message translates to:
  /// **'Usable storage is limited by your current plan. Excess claimed storage will automatically become usable when you upgrade your plan.'**
  String get usableReferralStorageInfo;

  /// No description provided for @removeFromAlbumTitle.
  ///
  /// In en, this message translates to:
  /// **'Remove from album?'**
  String get removeFromAlbumTitle;

  /// No description provided for @removeFromAlbum.
  ///
  /// In en, this message translates to:
  /// **'Remove from album'**
  String get removeFromAlbum;

  /// No description provided for @itemsWillBeRemovedFromAlbum.
  ///
  /// In en, this message translates to:
  /// **'Selected items will be removed from this album'**
  String get itemsWillBeRemovedFromAlbum;

  /// No description provided for @removeShareItemsWarning.
  ///
  /// In en, this message translates to:
  /// **'Selected photos will not be accessible to any viewer of this album, except the photo owners.'**
  String get removeShareItemsWarning;

  /// No description provided for @addingToFavorites.
  ///
  /// In en, this message translates to:
  /// **'Adding to favorites...'**
  String get addingToFavorites;

  /// No description provided for @removingFromFavorites.
  ///
  /// In en, this message translates to:
  /// **'Removing from favorites...'**
  String get removingFromFavorites;

  /// No description provided for @sorryCouldNotAddToFavorites.
  ///
  /// In en, this message translates to:
  /// **'Sorry, could not add to favorites!'**
  String get sorryCouldNotAddToFavorites;

  /// No description provided for @sorryCouldNotRemoveFromFavorites.
  ///
  /// In en, this message translates to:
  /// **'Sorry, could not remove from favorites!'**
  String get sorryCouldNotRemoveFromFavorites;

  /// No description provided for @subscribeToEnableSharing.
  ///
  /// In en, this message translates to:
  /// **'You need an active paid subscription to enable sharing.'**
  String get subscribeToEnableSharing;

  /// No description provided for @subscribe.
  ///
  /// In en, this message translates to:
  /// **'Subscribe'**
  String get subscribe;

  /// No description provided for @canOnlyRemoveFilesOwnedByYou.
  ///
  /// In en, this message translates to:
  /// **'Can only remove files owned by you'**
  String get canOnlyRemoveFilesOwnedByYou;

  /// No description provided for @deleteSharedAlbum.
  ///
  /// In en, this message translates to:
  /// **'Delete shared album?'**
  String get deleteSharedAlbum;

  /// No description provided for @deleteAlbum.
  ///
  /// In en, this message translates to:
  /// **'Delete album'**
  String get deleteAlbum;

  /// No description provided for @deleteAlbumDialog.
  ///
  /// In en, this message translates to:
  /// **'Also delete the photos (and videos) present in this album from <bold>all</bold> other albums they are part of?'**
  String get deleteAlbumDialog;

  /// No description provided for @deleteSharedAlbumDialogBody.
  ///
  /// In en, this message translates to:
  /// **'The album will be deleted for everyone\n\nYou will lose access to shared photos in this album that are owned by others'**
  String get deleteSharedAlbumDialogBody;

  /// No description provided for @yesRemove.
  ///
  /// In en, this message translates to:
  /// **'Yes, remove'**
  String get yesRemove;

  /// No description provided for @creatingLink.
  ///
  /// In en, this message translates to:
  /// **'Creating link...'**
  String get creatingLink;

  /// No description provided for @removeWithQuestionMark.
  ///
  /// In en, this message translates to:
  /// **'Remove?'**
  String get removeWithQuestionMark;

  /// No description provided for @removeParticipantBody.
  ///
  /// In en, this message translates to:
  /// **'{userEmail} will be removed from this shared album\n\nAny photos added by them will also be removed from the album'**
  String removeParticipantBody({required Object userEmail});

  /// No description provided for @keepPhotos.
  ///
  /// In en, this message translates to:
  /// **'Keep Photos'**
  String get keepPhotos;

  /// No description provided for @deletePhotos.
  ///
  /// In en, this message translates to:
  /// **'Delete photos'**
  String get deletePhotos;

  /// No description provided for @inviteToEnte.
  ///
  /// In en, this message translates to:
  /// **'Invite to Ente'**
  String get inviteToEnte;

  /// No description provided for @removePublicLink.
  ///
  /// In en, this message translates to:
  /// **'Remove public link'**
  String get removePublicLink;

  /// No description provided for @disableLinkMessage.
  ///
  /// In en, this message translates to:
  /// **'This will remove the public link for accessing \"{albumName}\".'**
  String disableLinkMessage({required Object albumName});

  /// No description provided for @sharing.
  ///
  /// In en, this message translates to:
  /// **'Sharing...'**
  String get sharing;

  /// No description provided for @youCannotShareWithYourself.
  ///
  /// In en, this message translates to:
  /// **'You cannot share with yourself'**
  String get youCannotShareWithYourself;

  /// No description provided for @archive.
  ///
  /// In en, this message translates to:
  /// **'Archive'**
  String get archive;

  /// No description provided for @createAlbumActionHint.
  ///
  /// In en, this message translates to:
  /// **'Long press to select photos and click + to create an album'**
  String get createAlbumActionHint;

  /// No description provided for @importing.
  ///
  /// In en, this message translates to:
  /// **'Importing....'**
  String get importing;

  /// No description provided for @failedToLoadAlbums.
  ///
  /// In en, this message translates to:
  /// **'Failed to load albums'**
  String get failedToLoadAlbums;

  /// No description provided for @hidden.
  ///
  /// In en, this message translates to:
  /// **'Hidden'**
  String get hidden;

  /// No description provided for @authToViewYourHiddenFiles.
  ///
  /// In en, this message translates to:
  /// **'Please authenticate to view your hidden files'**
  String get authToViewYourHiddenFiles;

  /// No description provided for @authToViewTrashedFiles.
  ///
  /// In en, this message translates to:
  /// **'Please authenticate to view your trashed files'**
  String get authToViewTrashedFiles;

  /// No description provided for @trash.
  ///
  /// In en, this message translates to:
  /// **'Trash'**
  String get trash;

  /// No description provided for @uncategorized.
  ///
  /// In en, this message translates to:
  /// **'Uncategorized'**
  String get uncategorized;

  /// No description provided for @videoSmallCase.
  ///
  /// In en, this message translates to:
  /// **'video'**
  String get videoSmallCase;

  /// No description provided for @photoSmallCase.
  ///
  /// In en, this message translates to:
  /// **'photo'**
  String get photoSmallCase;

  /// No description provided for @singleFileDeleteHighlight.
  ///
  /// In en, this message translates to:
  /// **'It will be deleted from all albums.'**
  String get singleFileDeleteHighlight;

  /// No description provided for @singleFileInBothLocalAndRemote.
  ///
  /// In en, this message translates to:
  /// **'This {fileType} is in both Ente and your device.'**
  String singleFileInBothLocalAndRemote({required Object fileType});

  /// No description provided for @singleFileInRemoteOnly.
  ///
  /// In en, this message translates to:
  /// **'This {fileType} will be deleted from Ente.'**
  String singleFileInRemoteOnly({required Object fileType});

  /// No description provided for @singleFileDeleteFromDevice.
  ///
  /// In en, this message translates to:
  /// **'This {fileType} will be deleted from your device.'**
  String singleFileDeleteFromDevice({required Object fileType});

  /// No description provided for @deleteFromEnte.
  ///
  /// In en, this message translates to:
  /// **'Delete from Ente'**
  String get deleteFromEnte;

  /// No description provided for @yesDelete.
  ///
  /// In en, this message translates to:
  /// **'Yes, delete'**
  String get yesDelete;

  /// No description provided for @movedToTrash.
  ///
  /// In en, this message translates to:
  /// **'Moved to trash'**
  String get movedToTrash;

  /// No description provided for @deleteFromDevice.
  ///
  /// In en, this message translates to:
  /// **'Delete from device'**
  String get deleteFromDevice;

  /// No description provided for @deleteFromBoth.
  ///
  /// In en, this message translates to:
  /// **'Delete from both'**
  String get deleteFromBoth;

  /// No description provided for @newAlbum.
  ///
  /// In en, this message translates to:
  /// **'New album'**
  String get newAlbum;

  /// No description provided for @albums.
  ///
  /// In en, this message translates to:
  /// **'Albums'**
  String get albums;

  /// The text to display the number of memories
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =0{no memories} one{{formattedCount} memory} other{{formattedCount} memories}}'**
  String memoryCount({required int count, required String formattedCount});

  /// Display the number of selected photos
  ///
  /// In en, this message translates to:
  /// **'{count} selected'**
  String selectedPhotos({required int count});

  /// Display the number of selected photos, including the number of selected photos owned by the user
  ///
  /// In en, this message translates to:
  /// **'{count} selected ({yourCount} yours)'**
  String selectedPhotosWithYours({required int count, required int yourCount});

  /// The text to display in the advanced settings section
  ///
  /// In en, this message translates to:
  /// **'Advanced'**
  String get advancedSettings;

  /// No description provided for @photoGridSize.
  ///
  /// In en, this message translates to:
  /// **'Photo grid size'**
  String get photoGridSize;

  /// No description provided for @manageDeviceStorage.
  ///
  /// In en, this message translates to:
  /// **'Manage device cache'**
  String get manageDeviceStorage;

  /// No description provided for @manageDeviceStorageDesc.
  ///
  /// In en, this message translates to:
  /// **'Review and clear local cache storage.'**
  String get manageDeviceStorageDesc;

  /// No description provided for @machineLearning.
  ///
  /// In en, this message translates to:
  /// **'Machine learning'**
  String get machineLearning;

  /// No description provided for @mlConsent.
  ///
  /// In en, this message translates to:
  /// **'Enable machine learning'**
  String get mlConsent;

  /// No description provided for @mlConsentTitle.
  ///
  /// In en, this message translates to:
  /// **'Enable machine learning?'**
  String get mlConsentTitle;

  /// No description provided for @mlConsentDescription.
  ///
  /// In en, this message translates to:
  /// **'If you enable machine learning, Ente will extract information like face geometry from files, including those shared with you.\n\nThis will happen on your device, and any generated biometric information will be end-to-end encrypted.'**
  String get mlConsentDescription;

  /// No description provided for @mlConsentPrivacy.
  ///
  /// In en, this message translates to:
  /// **'Please click here for more details about this feature in our privacy policy'**
  String get mlConsentPrivacy;

  /// No description provided for @mlConsentConfirmation.
  ///
  /// In en, this message translates to:
  /// **'I understand, and wish to enable machine learning'**
  String get mlConsentConfirmation;

  /// No description provided for @magicSearch.
  ///
  /// In en, this message translates to:
  /// **'Magic search'**
  String get magicSearch;

  /// The text to display for the discover section under which we show receipts, screenshots, sunsets, greenery, etc.
  ///
  /// In en, this message translates to:
  /// **'Discover'**
  String get discover;

  /// No description provided for @discover_identity.
  ///
  /// In en, this message translates to:
  /// **'Identity'**
  String get discover_identity;

  /// No description provided for @discover_screenshots.
  ///
  /// In en, this message translates to:
  /// **'Screenshots'**
  String get discover_screenshots;

  /// No description provided for @discover_receipts.
  ///
  /// In en, this message translates to:
  /// **'Receipts'**
  String get discover_receipts;

  /// No description provided for @discover_notes.
  ///
  /// In en, this message translates to:
  /// **'Notes'**
  String get discover_notes;

  /// No description provided for @discover_memes.
  ///
  /// In en, this message translates to:
  /// **'Memes'**
  String get discover_memes;

  /// No description provided for @discover_visiting_cards.
  ///
  /// In en, this message translates to:
  /// **'Visiting Cards'**
  String get discover_visiting_cards;

  /// No description provided for @discover_babies.
  ///
  /// In en, this message translates to:
  /// **'Babies'**
  String get discover_babies;

  /// No description provided for @discover_pets.
  ///
  /// In en, this message translates to:
  /// **'Pets'**
  String get discover_pets;

  /// No description provided for @discover_selfies.
  ///
  /// In en, this message translates to:
  /// **'Selfies'**
  String get discover_selfies;

  /// No description provided for @discover_wallpapers.
  ///
  /// In en, this message translates to:
  /// **'Wallpapers'**
  String get discover_wallpapers;

  /// No description provided for @discover_food.
  ///
  /// In en, this message translates to:
  /// **'Food'**
  String get discover_food;

  /// No description provided for @discover_celebrations.
  ///
  /// In en, this message translates to:
  /// **'Celebrations'**
  String get discover_celebrations;

  /// No description provided for @discover_sunset.
  ///
  /// In en, this message translates to:
  /// **'Sunset'**
  String get discover_sunset;

  /// No description provided for @discover_hills.
  ///
  /// In en, this message translates to:
  /// **'Hills'**
  String get discover_hills;

  /// No description provided for @discover_greenery.
  ///
  /// In en, this message translates to:
  /// **'Greenery'**
  String get discover_greenery;

  /// No description provided for @mlIndexingDescription.
  ///
  /// In en, this message translates to:
  /// **'Please note that machine learning will result in a higher bandwidth and battery usage until all items are indexed. Consider using the desktop app for faster indexing, all results will be synced automatically.'**
  String get mlIndexingDescription;

  /// No description provided for @loadingModel.
  ///
  /// In en, this message translates to:
  /// **'Downloading models...'**
  String get loadingModel;

  /// No description provided for @waitingForWifi.
  ///
  /// In en, this message translates to:
  /// **'Waiting for WiFi...'**
  String get waitingForWifi;

  /// No description provided for @status.
  ///
  /// In en, this message translates to:
  /// **'Status'**
  String get status;

  /// No description provided for @indexedItems.
  ///
  /// In en, this message translates to:
  /// **'Indexed items'**
  String get indexedItems;

  /// No description provided for @pendingItems.
  ///
  /// In en, this message translates to:
  /// **'Pending items'**
  String get pendingItems;

  /// No description provided for @clearIndexes.
  ///
  /// In en, this message translates to:
  /// **'Clear indexes'**
  String get clearIndexes;

  /// No description provided for @selectFoldersForBackup.
  ///
  /// In en, this message translates to:
  /// **'Select folders for backup'**
  String get selectFoldersForBackup;

  /// No description provided for @selectedFoldersWillBeEncryptedAndBackedUp.
  ///
  /// In en, this message translates to:
  /// **'Selected folders will be encrypted and backed up'**
  String get selectedFoldersWillBeEncryptedAndBackedUp;

  /// No description provided for @unselectAll.
  ///
  /// In en, this message translates to:
  /// **'Unselect all'**
  String get unselectAll;

  /// No description provided for @selectAll.
  ///
  /// In en, this message translates to:
  /// **'Select all'**
  String get selectAll;

  /// No description provided for @skip.
  ///
  /// In en, this message translates to:
  /// **'Skip'**
  String get skip;

  /// No description provided for @updatingFolderSelection.
  ///
  /// In en, this message translates to:
  /// **'Updating folder selection...'**
  String get updatingFolderSelection;

  /// No description provided for @itemCount.
  ///
  /// In en, this message translates to:
  /// **'{count, plural, one{{count} item} other{{count} items}}'**
  String itemCount({required num count});

  /// No description provided for @deleteItemCount.
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =1 {Delete {count} item} other {Delete {count} items}}'**
  String deleteItemCount({required num count});

  /// Display the number of duplicate files and their size
  ///
  /// In en, this message translates to:
  /// **'{count} files, {formattedSize} each'**
  String duplicateItemsGroup({
    required int count,
    required String formattedSize,
  });

  /// No description provided for @showMemories.
  ///
  /// In en, this message translates to:
  /// **'Show memories'**
  String get showMemories;

  /// No description provided for @yearsAgo.
  ///
  /// In en, this message translates to:
  /// **'{count, plural, one{{count} year ago} other{{count} years ago}}'**
  String yearsAgo({required num count});

  /// No description provided for @backupSettings.
  ///
  /// In en, this message translates to:
  /// **'Backup settings'**
  String get backupSettings;

  /// No description provided for @backupStatus.
  ///
  /// In en, this message translates to:
  /// **'Backup status'**
  String get backupStatus;

  /// No description provided for @backupStatusDescription.
  ///
  /// In en, this message translates to:
  /// **'Items that have been backed up will show up here'**
  String get backupStatusDescription;

  /// No description provided for @backupOverMobileData.
  ///
  /// In en, this message translates to:
  /// **'Backup over mobile data'**
  String get backupOverMobileData;

  /// No description provided for @backupVideos.
  ///
  /// In en, this message translates to:
  /// **'Backup videos'**
  String get backupVideos;

  /// No description provided for @disableAutoLock.
  ///
  /// In en, this message translates to:
  /// **'Disable auto lock'**
  String get disableAutoLock;

  /// No description provided for @deviceLockExplanation.
  ///
  /// In en, this message translates to:
  /// **'Disable the device screen lock when Ente is in the foreground and there is a backup in progress. This is normally not needed, but may help big uploads and initial imports of large libraries complete faster.'**
  String get deviceLockExplanation;

  /// No description provided for @about.
  ///
  /// In en, this message translates to:
  /// **'About'**
  String get about;

  /// No description provided for @weAreOpenSource.
  ///
  /// In en, this message translates to:
  /// **'We are open source!'**
  String get weAreOpenSource;

  /// No description provided for @privacy.
  ///
  /// In en, this message translates to:
  /// **'Privacy'**
  String get privacy;

  /// No description provided for @terms.
  ///
  /// In en, this message translates to:
  /// **'Terms'**
  String get terms;

  /// No description provided for @checkForUpdates.
  ///
  /// In en, this message translates to:
  /// **'Check for updates'**
  String get checkForUpdates;

  /// No description provided for @checkStatus.
  ///
  /// In en, this message translates to:
  /// **'Check status'**
  String get checkStatus;

  /// No description provided for @checking.
  ///
  /// In en, this message translates to:
  /// **'Checking...'**
  String get checking;

  /// No description provided for @youAreOnTheLatestVersion.
  ///
  /// In en, this message translates to:
  /// **'You are on the latest version'**
  String get youAreOnTheLatestVersion;

  /// No description provided for @account.
  ///
  /// In en, this message translates to:
  /// **'Account'**
  String get account;

  /// No description provided for @manageSubscription.
  ///
  /// In en, this message translates to:
  /// **'Manage subscription'**
  String get manageSubscription;

  /// No description provided for @authToChangeYourEmail.
  ///
  /// In en, this message translates to:
  /// **'Please authenticate to change your email'**
  String get authToChangeYourEmail;

  /// No description provided for @changePassword.
  ///
  /// In en, this message translates to:
  /// **'Change password'**
  String get changePassword;

  /// No description provided for @authToChangeYourPassword.
  ///
  /// In en, this message translates to:
  /// **'Please authenticate to change your password'**
  String get authToChangeYourPassword;

  /// No description provided for @emailVerificationToggle.
  ///
  /// In en, this message translates to:
  /// **'Email verification'**
  String get emailVerificationToggle;

  /// No description provided for @authToChangeEmailVerificationSetting.
  ///
  /// In en, this message translates to:
  /// **'Please authenticate to change email verification'**
  String get authToChangeEmailVerificationSetting;

  /// No description provided for @exportYourData.
  ///
  /// In en, this message translates to:
  /// **'Export your data'**
  String get exportYourData;

  /// No description provided for @logout.
  ///
  /// In en, this message translates to:
  /// **'Logout'**
  String get logout;

  /// No description provided for @authToInitiateAccountDeletion.
  ///
  /// In en, this message translates to:
  /// **'Please authenticate to initiate account deletion'**
  String get authToInitiateAccountDeletion;

  /// No description provided for @areYouSureYouWantToLogout.
  ///
  /// In en, this message translates to:
  /// **'Are you sure you want to logout?'**
  String get areYouSureYouWantToLogout;

  /// No description provided for @yesLogout.
  ///
  /// In en, this message translates to:
  /// **'Yes, logout'**
  String get yesLogout;

  /// No description provided for @aNewVersionOfEnteIsAvailable.
  ///
  /// In en, this message translates to:
  /// **'A new version of Ente is available.'**
  String get aNewVersionOfEnteIsAvailable;

  /// No description provided for @update.
  ///
  /// In en, this message translates to:
  /// **'Update'**
  String get update;

  /// No description provided for @installManually.
  ///
  /// In en, this message translates to:
  /// **'Install manually'**
  String get installManually;

  /// No description provided for @criticalUpdateAvailable.
  ///
  /// In en, this message translates to:
  /// **'Critical update available'**
  String get criticalUpdateAvailable;

  /// No description provided for @updateAvailable.
  ///
  /// In en, this message translates to:
  /// **'Update available'**
  String get updateAvailable;

  /// No description provided for @ignoreUpdate.
  ///
  /// In en, this message translates to:
  /// **'Ignore'**
  String get ignoreUpdate;

  /// No description provided for @downloading.
  ///
  /// In en, this message translates to:
  /// **'Downloading...'**
  String get downloading;

  /// No description provided for @cannotDeleteSharedFiles.
  ///
  /// In en, this message translates to:
  /// **'Cannot delete shared files'**
  String get cannotDeleteSharedFiles;

  /// No description provided for @theDownloadCouldNotBeCompleted.
  ///
  /// In en, this message translates to:
  /// **'The download could not be completed'**
  String get theDownloadCouldNotBeCompleted;

  /// No description provided for @retry.
  ///
  /// In en, this message translates to:
  /// **'Retry'**
  String get retry;

  /// No description provided for @backedUpFolders.
  ///
  /// In en, this message translates to:
  /// **'Backed up folders'**
  String get backedUpFolders;

  /// No description provided for @backup.
  ///
  /// In en, this message translates to:
  /// **'Backup'**
  String get backup;

  /// No description provided for @freeUpDeviceSpace.
  ///
  /// In en, this message translates to:
  /// **'Free up device space'**
  String get freeUpDeviceSpace;

  /// No description provided for @freeUpDeviceSpaceDesc.
  ///
  /// In en, this message translates to:
  /// **'Save space on your device by clearing files that have been already backed up.'**
  String get freeUpDeviceSpaceDesc;

  /// No description provided for @allClear.
  ///
  /// In en, this message translates to:
  /// **'✨ All clear'**
  String get allClear;

  /// No description provided for @noDeviceThatCanBeDeleted.
  ///
  /// In en, this message translates to:
  /// **'You\'ve no files on this device that can be deleted'**
  String get noDeviceThatCanBeDeleted;

  /// No description provided for @removeDuplicates.
  ///
  /// In en, this message translates to:
  /// **'Remove duplicates'**
  String get removeDuplicates;

  /// No description provided for @removeDuplicatesDesc.
  ///
  /// In en, this message translates to:
  /// **'Review and remove files that are exact duplicates.'**
  String get removeDuplicatesDesc;

  /// No description provided for @viewLargeFiles.
  ///
  /// In en, this message translates to:
  /// **'Large files'**
  String get viewLargeFiles;

  /// No description provided for @viewLargeFilesDesc.
  ///
  /// In en, this message translates to:
  /// **'View files that are consuming the most amount of storage.'**
  String get viewLargeFilesDesc;

  /// No description provided for @noDuplicates.
  ///
  /// In en, this message translates to:
  /// **'✨ No duplicates'**
  String get noDuplicates;

  /// No description provided for @youveNoDuplicateFilesThatCanBeCleared.
  ///
  /// In en, this message translates to:
  /// **'You don\'t have any duplicate files that can be cleared'**
  String get youveNoDuplicateFilesThatCanBeCleared;

  /// No description provided for @success.
  ///
  /// In en, this message translates to:
  /// **'Success'**
  String get success;

  /// No description provided for @rateUs.
  ///
  /// In en, this message translates to:
  /// **'Rate us'**
  String get rateUs;

  /// No description provided for @remindToEmptyDeviceTrash.
  ///
  /// In en, this message translates to:
  /// **'Also empty \"Recently Deleted\" from \"Settings\" -> \"Storage\" to claim the freed space'**
  String get remindToEmptyDeviceTrash;

  /// The text to display when the user has successfully freed up storage
  ///
  /// In en, this message translates to:
  /// **'You have successfully freed up {storageSaved}!'**
  String youHaveSuccessfullyFreedUp({required String storageSaved});

  /// No description provided for @remindToEmptyEnteTrash.
  ///
  /// In en, this message translates to:
  /// **'Also empty your \"Trash\" to claim the freed up space'**
  String get remindToEmptyEnteTrash;

  /// No description provided for @sparkleSuccess.
  ///
  /// In en, this message translates to:
  /// **'✨ Success'**
  String get sparkleSuccess;

  /// The text to display when the user has successfully cleaned up duplicate files
  ///
  /// In en, this message translates to:
  /// **'You have cleaned up {count, plural, one{{count} duplicate file} other{{count} duplicate files}}, saving ({storageSaved}!)'**
  String duplicateFileCountWithStorageSaved({
    required int count,
    required String storageSaved,
  });

  /// No description provided for @familyPlans.
  ///
  /// In en, this message translates to:
  /// **'Family plans'**
  String get familyPlans;

  /// No description provided for @referrals.
  ///
  /// In en, this message translates to:
  /// **'Referrals'**
  String get referrals;

  /// No description provided for @notifications.
  ///
  /// In en, this message translates to:
  /// **'Notifications'**
  String get notifications;

  /// No description provided for @sharedPhotoNotifications.
  ///
  /// In en, this message translates to:
  /// **'New shared photos'**
  String get sharedPhotoNotifications;

  /// No description provided for @sharedPhotoNotificationsExplanation.
  ///
  /// In en, this message translates to:
  /// **'Receive notifications when someone adds a photo to a shared album that you\'re a part of'**
  String get sharedPhotoNotificationsExplanation;

  /// No description provided for @advanced.
  ///
  /// In en, this message translates to:
  /// **'Advanced'**
  String get advanced;

  /// No description provided for @general.
  ///
  /// In en, this message translates to:
  /// **'General'**
  String get general;

  /// No description provided for @security.
  ///
  /// In en, this message translates to:
  /// **'Security'**
  String get security;

  /// No description provided for @authToViewYourRecoveryKey.
  ///
  /// In en, this message translates to:
  /// **'Please authenticate to view your recovery key'**
  String get authToViewYourRecoveryKey;

  /// No description provided for @twofactor.
  ///
  /// In en, this message translates to:
  /// **'Two-factor'**
  String get twofactor;

  /// No description provided for @authToConfigureTwofactorAuthentication.
  ///
  /// In en, this message translates to:
  /// **'Please authenticate to configure two-factor authentication'**
  String get authToConfigureTwofactorAuthentication;

  /// No description provided for @lockscreen.
  ///
  /// In en, this message translates to:
  /// **'Lockscreen'**
  String get lockscreen;

  /// No description provided for @authToChangeLockscreenSetting.
  ///
  /// In en, this message translates to:
  /// **'Please authenticate to change lockscreen setting'**
  String get authToChangeLockscreenSetting;

  /// No description provided for @viewActiveSessions.
  ///
  /// In en, this message translates to:
  /// **'View active sessions'**
  String get viewActiveSessions;

  /// No description provided for @authToViewYourActiveSessions.
  ///
  /// In en, this message translates to:
  /// **'Please authenticate to view your active sessions'**
  String get authToViewYourActiveSessions;

  /// No description provided for @disableTwofactor.
  ///
  /// In en, this message translates to:
  /// **'Disable two-factor'**
  String get disableTwofactor;

  /// No description provided for @confirm2FADisable.
  ///
  /// In en, this message translates to:
  /// **'Are you sure you want to disable two-factor authentication?'**
  String get confirm2FADisable;

  /// No description provided for @no.
  ///
  /// In en, this message translates to:
  /// **'No'**
  String get no;

  /// No description provided for @yes.
  ///
  /// In en, this message translates to:
  /// **'Yes'**
  String get yes;

  /// No description provided for @social.
  ///
  /// In en, this message translates to:
  /// **'Social'**
  String get social;

  /// No description provided for @rateUsOnStore.
  ///
  /// In en, this message translates to:
  /// **'Rate us on {storeName}'**
  String rateUsOnStore({required Object storeName});

  /// No description provided for @blog.
  ///
  /// In en, this message translates to:
  /// **'Blog'**
  String get blog;

  /// No description provided for @merchandise.
  ///
  /// In en, this message translates to:
  /// **'Merchandise'**
  String get merchandise;

  /// No description provided for @twitter.
  ///
  /// In en, this message translates to:
  /// **'Twitter'**
  String get twitter;

  /// No description provided for @mastodon.
  ///
  /// In en, this message translates to:
  /// **'Mastodon'**
  String get mastodon;

  /// No description provided for @matrix.
  ///
  /// In en, this message translates to:
  /// **'Matrix'**
  String get matrix;

  /// No description provided for @discord.
  ///
  /// In en, this message translates to:
  /// **'Discord'**
  String get discord;

  /// No description provided for @reddit.
  ///
  /// In en, this message translates to:
  /// **'Reddit'**
  String get reddit;

  /// No description provided for @yourStorageDetailsCouldNotBeFetched.
  ///
  /// In en, this message translates to:
  /// **'Your storage details could not be fetched'**
  String get yourStorageDetailsCouldNotBeFetched;

  /// No description provided for @reportABug.
  ///
  /// In en, this message translates to:
  /// **'Report a bug'**
  String get reportABug;

  /// No description provided for @reportBug.
  ///
  /// In en, this message translates to:
  /// **'Report bug'**
  String get reportBug;

  /// No description provided for @suggestFeatures.
  ///
  /// In en, this message translates to:
  /// **'Suggest features'**
  String get suggestFeatures;

  /// No description provided for @support.
  ///
  /// In en, this message translates to:
  /// **'Support'**
  String get support;

  /// No description provided for @theme.
  ///
  /// In en, this message translates to:
  /// **'Theme'**
  String get theme;

  /// No description provided for @lightTheme.
  ///
  /// In en, this message translates to:
  /// **'Light'**
  String get lightTheme;

  /// No description provided for @darkTheme.
  ///
  /// In en, this message translates to:
  /// **'Dark'**
  String get darkTheme;

  /// No description provided for @systemTheme.
  ///
  /// In en, this message translates to:
  /// **'System'**
  String get systemTheme;

  /// No description provided for @freeTrial.
  ///
  /// In en, this message translates to:
  /// **'Free trial'**
  String get freeTrial;

  /// No description provided for @selectYourPlan.
  ///
  /// In en, this message translates to:
  /// **'Select your plan'**
  String get selectYourPlan;

  /// No description provided for @enteSubscriptionPitch.
  ///
  /// In en, this message translates to:
  /// **'Ente preserves your memories, so they\'re always available to you, even if you lose your device.'**
  String get enteSubscriptionPitch;

  /// No description provided for @enteSubscriptionShareWithFamily.
  ///
  /// In en, this message translates to:
  /// **'Your family can be added to your plan as well.'**
  String get enteSubscriptionShareWithFamily;

  /// This text is followed by storage usage
  ///
  /// In en, this message translates to:
  /// **'Current usage is '**
  String get currentUsageIs;

  /// No description provided for @faqs.
  ///
  /// In en, this message translates to:
  /// **'FAQs'**
  String get faqs;

  /// No description provided for @renewsOn.
  ///
  /// In en, this message translates to:
  /// **'Subscription renews on {endDate}'**
  String renewsOn({required Object endDate});

  /// No description provided for @freeTrialValidTill.
  ///
  /// In en, this message translates to:
  /// **'Free trial valid till {endDate}'**
  String freeTrialValidTill({required Object endDate});

  /// No description provided for @validTill.
  ///
  /// In en, this message translates to:
  /// **'Valid till {endDate}'**
  String validTill({required Object endDate});

  /// No description provided for @addOnValidTill.
  ///
  /// In en, this message translates to:
  /// **'Your {storageAmount} add-on is valid till {endDate}'**
  String addOnValidTill({
    required Object endDate,
    required Object storageAmount,
  });

  /// No description provided for @playStoreFreeTrialValidTill.
  ///
  /// In en, this message translates to:
  /// **'Free trial valid till {endDate}.\nYou can choose a paid plan afterwards.'**
  String playStoreFreeTrialValidTill({required Object endDate});

  /// No description provided for @subWillBeCancelledOn.
  ///
  /// In en, this message translates to:
  /// **'Your subscription will be cancelled on {endDate}'**
  String subWillBeCancelledOn({required Object endDate});

  /// No description provided for @subscription.
  ///
  /// In en, this message translates to:
  /// **'Subscription'**
  String get subscription;

  /// No description provided for @paymentDetails.
  ///
  /// In en, this message translates to:
  /// **'Payment details'**
  String get paymentDetails;

  /// No description provided for @manageFamily.
  ///
  /// In en, this message translates to:
  /// **'Manage Family'**
  String get manageFamily;

  /// No description provided for @contactToManageSubscription.
  ///
  /// In en, this message translates to:
  /// **'Please contact us at support@ente.io to manage your {provider} subscription.'**
  String contactToManageSubscription({required Object provider});

  /// No description provided for @renewSubscription.
  ///
  /// In en, this message translates to:
  /// **'Renew subscription'**
  String get renewSubscription;

  /// No description provided for @cancelSubscription.
  ///
  /// In en, this message translates to:
  /// **'Cancel subscription'**
  String get cancelSubscription;

  /// No description provided for @areYouSureYouWantToRenew.
  ///
  /// In en, this message translates to:
  /// **'Are you sure you want to renew?'**
  String get areYouSureYouWantToRenew;

  /// No description provided for @yesRenew.
  ///
  /// In en, this message translates to:
  /// **'Yes, Renew'**
  String get yesRenew;

  /// No description provided for @areYouSureYouWantToCancel.
  ///
  /// In en, this message translates to:
  /// **'Are you sure you want to cancel?'**
  String get areYouSureYouWantToCancel;

  /// No description provided for @yesCancel.
  ///
  /// In en, this message translates to:
  /// **'Yes, cancel'**
  String get yesCancel;

  /// No description provided for @failedToRenew.
  ///
  /// In en, this message translates to:
  /// **'Failed to renew'**
  String get failedToRenew;

  /// No description provided for @failedToCancel.
  ///
  /// In en, this message translates to:
  /// **'Failed to cancel'**
  String get failedToCancel;

  /// No description provided for @twoMonthsFreeOnYearlyPlans.
  ///
  /// In en, this message translates to:
  /// **'2 months free on yearly plans'**
  String get twoMonthsFreeOnYearlyPlans;

  /// The text to display for monthly plans
  ///
  /// In en, this message translates to:
  /// **'Monthly'**
  String get monthly;

  /// The text to display for yearly plans
  ///
  /// In en, this message translates to:
  /// **'Yearly'**
  String get yearly;

  /// No description provided for @confirmPlanChange.
  ///
  /// In en, this message translates to:
  /// **'Confirm plan change'**
  String get confirmPlanChange;

  /// No description provided for @areYouSureYouWantToChangeYourPlan.
  ///
  /// In en, this message translates to:
  /// **'Are you sure you want to change your plan?'**
  String get areYouSureYouWantToChangeYourPlan;

  /// No description provided for @youCannotDowngradeToThisPlan.
  ///
  /// In en, this message translates to:
  /// **'You cannot downgrade to this plan'**
  String get youCannotDowngradeToThisPlan;

  /// The text to display when the user has an existing subscription from a different payment provider
  ///
  /// In en, this message translates to:
  /// **'Please cancel your existing subscription from {paymentProvider} first'**
  String cancelOtherSubscription({required String paymentProvider});

  /// No description provided for @optionalAsShortAsYouLike.
  ///
  /// In en, this message translates to:
  /// **'Optional, as short as you like...'**
  String get optionalAsShortAsYouLike;

  /// No description provided for @send.
  ///
  /// In en, this message translates to:
  /// **'Send'**
  String get send;

  /// No description provided for @askCancelReason.
  ///
  /// In en, this message translates to:
  /// **'Your subscription was cancelled. Would you like to share the reason?'**
  String get askCancelReason;

  /// No description provided for @thankYouForSubscribing.
  ///
  /// In en, this message translates to:
  /// **'Thank you for subscribing!'**
  String get thankYouForSubscribing;

  /// No description provided for @yourPurchaseWasSuccessful.
  ///
  /// In en, this message translates to:
  /// **'Your purchase was successful'**
  String get yourPurchaseWasSuccessful;

  /// No description provided for @yourPlanWasSuccessfullyUpgraded.
  ///
  /// In en, this message translates to:
  /// **'Your plan was successfully upgraded'**
  String get yourPlanWasSuccessfullyUpgraded;

  /// No description provided for @yourPlanWasSuccessfullyDowngraded.
  ///
  /// In en, this message translates to:
  /// **'Your plan was successfully downgraded'**
  String get yourPlanWasSuccessfullyDowngraded;

  /// No description provided for @yourSubscriptionWasUpdatedSuccessfully.
  ///
  /// In en, this message translates to:
  /// **'Your subscription was updated successfully'**
  String get yourSubscriptionWasUpdatedSuccessfully;

  /// No description provided for @googlePlayId.
  ///
  /// In en, this message translates to:
  /// **'Google Play ID'**
  String get googlePlayId;

  /// No description provided for @appleId.
  ///
  /// In en, this message translates to:
  /// **'Apple ID'**
  String get appleId;

  /// No description provided for @playstoreSubscription.
  ///
  /// In en, this message translates to:
  /// **'PlayStore subscription'**
  String get playstoreSubscription;

  /// No description provided for @appstoreSubscription.
  ///
  /// In en, this message translates to:
  /// **'AppStore subscription'**
  String get appstoreSubscription;

  /// No description provided for @subAlreadyLinkedErrMessage.
  ///
  /// In en, this message translates to:
  /// **'Your {id} is already linked to another Ente account.\nIf you would like to use your {id} with this account, please contact our support\'\''**
  String subAlreadyLinkedErrMessage({required Object id});

  /// No description provided for @visitWebToManage.
  ///
  /// In en, this message translates to:
  /// **'Please visit web.ente.io to manage your subscription'**
  String get visitWebToManage;

  /// No description provided for @couldNotUpdateSubscription.
  ///
  /// In en, this message translates to:
  /// **'Could not update subscription'**
  String get couldNotUpdateSubscription;

  /// No description provided for @pleaseContactSupportAndWeWillBeHappyToHelp.
  ///
  /// In en, this message translates to:
  /// **'Please contact support@ente.io and we will be happy to help!'**
  String get pleaseContactSupportAndWeWillBeHappyToHelp;

  /// No description provided for @paymentFailed.
  ///
  /// In en, this message translates to:
  /// **'Payment failed'**
  String get paymentFailed;

  /// The text to display when the payment failed
  ///
  /// In en, this message translates to:
  /// **'Please talk to {providerName} support if you were charged'**
  String paymentFailedTalkToProvider({required String providerName});

  /// No description provided for @continueOnFreeTrial.
  ///
  /// In en, this message translates to:
  /// **'Continue on free trial'**
  String get continueOnFreeTrial;

  /// No description provided for @areYouSureYouWantToExit.
  ///
  /// In en, this message translates to:
  /// **'Are you sure you want to exit?'**
  String get areYouSureYouWantToExit;

  /// No description provided for @thankYou.
  ///
  /// In en, this message translates to:
  /// **'Thank you'**
  String get thankYou;

  /// No description provided for @failedToVerifyPaymentStatus.
  ///
  /// In en, this message translates to:
  /// **'Failed to verify payment status'**
  String get failedToVerifyPaymentStatus;

  /// No description provided for @pleaseWaitForSometimeBeforeRetrying.
  ///
  /// In en, this message translates to:
  /// **'Please wait for sometime before retrying'**
  String get pleaseWaitForSometimeBeforeRetrying;

  /// No description provided for @paymentFailedMessage.
  ///
  /// In en, this message translates to:
  /// **'Unfortunately your payment failed. Please contact support and we\'ll help you out!'**
  String get paymentFailedMessage;

  /// No description provided for @youAreOnAFamilyPlan.
  ///
  /// In en, this message translates to:
  /// **'You are on a family plan!'**
  String get youAreOnAFamilyPlan;

  /// No description provided for @contactFamilyAdmin.
  ///
  /// In en, this message translates to:
  /// **'Please contact <green>{familyAdminEmail}</green> to manage your subscription'**
  String contactFamilyAdmin({required Object familyAdminEmail});

  /// No description provided for @leaveFamily.
  ///
  /// In en, this message translates to:
  /// **'Leave family'**
  String get leaveFamily;

  /// No description provided for @areYouSureThatYouWantToLeaveTheFamily.
  ///
  /// In en, this message translates to:
  /// **'Are you sure that you want to leave the family plan?'**
  String get areYouSureThatYouWantToLeaveTheFamily;

  /// No description provided for @leave.
  ///
  /// In en, this message translates to:
  /// **'Leave'**
  String get leave;

  /// No description provided for @rateTheApp.
  ///
  /// In en, this message translates to:
  /// **'Rate the app'**
  String get rateTheApp;

  /// No description provided for @startBackup.
  ///
  /// In en, this message translates to:
  /// **'Start backup'**
  String get startBackup;

  /// No description provided for @noPhotosAreBeingBackedUpRightNow.
  ///
  /// In en, this message translates to:
  /// **'No photos are being backed up right now'**
  String get noPhotosAreBeingBackedUpRightNow;

  /// No description provided for @preserveMore.
  ///
  /// In en, this message translates to:
  /// **'Preserve more'**
  String get preserveMore;

  /// No description provided for @grantFullAccessPrompt.
  ///
  /// In en, this message translates to:
  /// **'Please allow access to all photos in the Settings app'**
  String get grantFullAccessPrompt;

  /// No description provided for @allowPermTitle.
  ///
  /// In en, this message translates to:
  /// **'Allow access to photos'**
  String get allowPermTitle;

  /// No description provided for @allowPermBody.
  ///
  /// In en, this message translates to:
  /// **'Please allow access to your photos from Settings so Ente can display and backup your library.'**
  String get allowPermBody;

  /// No description provided for @openSettings.
  ///
  /// In en, this message translates to:
  /// **'Open Settings'**
  String get openSettings;

  /// No description provided for @selectMorePhotos.
  ///
  /// In en, this message translates to:
  /// **'Select more photos'**
  String get selectMorePhotos;

  /// No description provided for @existingUser.
  ///
  /// In en, this message translates to:
  /// **'Existing user'**
  String get existingUser;

  /// No description provided for @privateBackups.
  ///
  /// In en, this message translates to:
  /// **'Private backups'**
  String get privateBackups;

  /// No description provided for @forYourMemories.
  ///
  /// In en, this message translates to:
  /// **'for your memories'**
  String get forYourMemories;

  /// No description provided for @endtoendEncryptedByDefault.
  ///
  /// In en, this message translates to:
  /// **'End-to-end encrypted by default'**
  String get endtoendEncryptedByDefault;

  /// No description provided for @safelyStored.
  ///
  /// In en, this message translates to:
  /// **'Safely stored'**
  String get safelyStored;

  /// No description provided for @atAFalloutShelter.
  ///
  /// In en, this message translates to:
  /// **'at a fallout shelter'**
  String get atAFalloutShelter;

  /// No description provided for @designedToOutlive.
  ///
  /// In en, this message translates to:
  /// **'Designed to outlive'**
  String get designedToOutlive;

  /// No description provided for @available.
  ///
  /// In en, this message translates to:
  /// **'Available'**
  String get available;

  /// No description provided for @everywhere.
  ///
  /// In en, this message translates to:
  /// **'everywhere'**
  String get everywhere;

  /// No description provided for @androidIosWebDesktop.
  ///
  /// In en, this message translates to:
  /// **'Android, iOS, Web, Desktop'**
  String get androidIosWebDesktop;

  /// No description provided for @mobileWebDesktop.
  ///
  /// In en, this message translates to:
  /// **'Mobile, Web, Desktop'**
  String get mobileWebDesktop;

  /// No description provided for @newToEnte.
  ///
  /// In en, this message translates to:
  /// **'New to Ente'**
  String get newToEnte;

  /// No description provided for @pleaseLoginAgain.
  ///
  /// In en, this message translates to:
  /// **'Please login again'**
  String get pleaseLoginAgain;

  /// No description provided for @autoLogoutMessage.
  ///
  /// In en, this message translates to:
  /// **'Due to technical glitch, you have been logged out. Our apologies for the inconvenience.'**
  String get autoLogoutMessage;

  /// No description provided for @yourSubscriptionHasExpired.
  ///
  /// In en, this message translates to:
  /// **'Your subscription has expired'**
  String get yourSubscriptionHasExpired;

  /// No description provided for @storageLimitExceeded.
  ///
  /// In en, this message translates to:
  /// **'Storage limit exceeded'**
  String get storageLimitExceeded;

  /// No description provided for @upgrade.
  ///
  /// In en, this message translates to:
  /// **'Upgrade'**
  String get upgrade;

  /// Button text for raising a support tickets in case of unhandled errors during backup
  ///
  /// In en, this message translates to:
  /// **'Raise ticket'**
  String get raiseTicket;

  /// No description provided for @backupFailed.
  ///
  /// In en, this message translates to:
  /// **'Backup failed'**
  String get backupFailed;

  /// No description provided for @sorryBackupFailedDesc.
  ///
  /// In en, this message translates to:
  /// **'Sorry, we could not backup this file right now, we will retry later.'**
  String get sorryBackupFailedDesc;

  /// No description provided for @couldNotBackUpTryLater.
  ///
  /// In en, this message translates to:
  /// **'We could not backup your data.\nWe will retry later.'**
  String get couldNotBackUpTryLater;

  /// No description provided for @enteCanEncryptAndPreserveFilesOnlyIfYouGrant.
  ///
  /// In en, this message translates to:
  /// **'Ente can encrypt and preserve files only if you grant access to them'**
  String get enteCanEncryptAndPreserveFilesOnlyIfYouGrant;

  /// No description provided for @pleaseGrantPermissions.
  ///
  /// In en, this message translates to:
  /// **'Please grant permissions'**
  String get pleaseGrantPermissions;

  /// No description provided for @grantPermission.
  ///
  /// In en, this message translates to:
  /// **'Grant permission'**
  String get grantPermission;

  /// No description provided for @privateSharing.
  ///
  /// In en, this message translates to:
  /// **'Private sharing'**
  String get privateSharing;

  /// No description provided for @shareOnlyWithThePeopleYouWant.
  ///
  /// In en, this message translates to:
  /// **'Share only with the people you want'**
  String get shareOnlyWithThePeopleYouWant;

  /// No description provided for @usePublicLinksForPeopleNotOnEnte.
  ///
  /// In en, this message translates to:
  /// **'Use public links for people not on Ente'**
  String get usePublicLinksForPeopleNotOnEnte;

  /// No description provided for @allowPeopleToAddPhotos.
  ///
  /// In en, this message translates to:
  /// **'Allow people to add photos'**
  String get allowPeopleToAddPhotos;

  /// No description provided for @shareAnAlbumNow.
  ///
  /// In en, this message translates to:
  /// **'Share an album now'**
  String get shareAnAlbumNow;

  /// No description provided for @collectEventPhotos.
  ///
  /// In en, this message translates to:
  /// **'Collect event photos'**
  String get collectEventPhotos;

  /// No description provided for @sessionExpired.
  ///
  /// In en, this message translates to:
  /// **'Session expired'**
  String get sessionExpired;

  /// No description provided for @loggingOut.
  ///
  /// In en, this message translates to:
  /// **'Logging out...'**
  String get loggingOut;

  /// The text displayed above folders/albums stored on device
  ///
  /// In en, this message translates to:
  /// **'On device'**
  String get onDevice;

  /// The text displayed above albums backed up to Ente
  ///
  /// In en, this message translates to:
  /// **'On <branding>ente</branding>'**
  String get onEnte;

  /// No description provided for @name.
  ///
  /// In en, this message translates to:
  /// **'Name'**
  String get name;

  /// No description provided for @newest.
  ///
  /// In en, this message translates to:
  /// **'Newest'**
  String get newest;

  /// No description provided for @lastUpdated.
  ///
  /// In en, this message translates to:
  /// **'Last updated'**
  String get lastUpdated;

  /// No description provided for @deleteEmptyAlbums.
  ///
  /// In en, this message translates to:
  /// **'Delete empty albums'**
  String get deleteEmptyAlbums;

  /// No description provided for @deleteEmptyAlbumsWithQuestionMark.
  ///
  /// In en, this message translates to:
  /// **'Delete empty albums?'**
  String get deleteEmptyAlbumsWithQuestionMark;

  /// No description provided for @deleteAlbumsDialogBody.
  ///
  /// In en, this message translates to:
  /// **'This will delete all empty albums. This is useful when you want to reduce the clutter in your album list.'**
  String get deleteAlbumsDialogBody;

  /// No description provided for @deleteProgress.
  ///
  /// In en, this message translates to:
  /// **'Deleting {currentlyDeleting} / {totalCount}'**
  String deleteProgress({
    required Object currentlyDeleting,
    required Object totalCount,
  });

  /// Generic progress text to display when processing multiple items
  ///
  /// In en, this message translates to:
  /// **'Processing {currentlyProcessing} / {totalCount}'**
  String genericProgress({
    required int currentlyProcessing,
    required int totalCount,
  });

  /// No description provided for @permanentlyDelete.
  ///
  /// In en, this message translates to:
  /// **'Permanently delete'**
  String get permanentlyDelete;

  /// No description provided for @canOnlyCreateLinkForFilesOwnedByYou.
  ///
  /// In en, this message translates to:
  /// **'Can only create link for files owned by you'**
  String get canOnlyCreateLinkForFilesOwnedByYou;

  /// No description provided for @publicLinkCreated.
  ///
  /// In en, this message translates to:
  /// **'Public link created'**
  String get publicLinkCreated;

  /// No description provided for @youCanManageYourLinksInTheShareTab.
  ///
  /// In en, this message translates to:
  /// **'You can manage your links in the share tab.'**
  String get youCanManageYourLinksInTheShareTab;

  /// No description provided for @linkCopiedToClipboard.
  ///
  /// In en, this message translates to:
  /// **'Link copied to clipboard'**
  String get linkCopiedToClipboard;

  /// Display text for an action which triggers a restore of item from trash
  ///
  /// In en, this message translates to:
  /// **'Restore'**
  String get restore;

  /// No description provided for @moveToAlbum.
  ///
  /// In en, this message translates to:
  /// **'Move to album'**
  String get moveToAlbum;

  /// No description provided for @unhide.
  ///
  /// In en, this message translates to:
  /// **'Unhide'**
  String get unhide;

  /// No description provided for @unarchive.
  ///
  /// In en, this message translates to:
  /// **'Unarchive'**
  String get unarchive;

  /// No description provided for @favorite.
  ///
  /// In en, this message translates to:
  /// **'Favorite'**
  String get favorite;

  /// No description provided for @removeFromFavorite.
  ///
  /// In en, this message translates to:
  /// **'Remove from favorites'**
  String get removeFromFavorite;

  /// No description provided for @shareLink.
  ///
  /// In en, this message translates to:
  /// **'Share link'**
  String get shareLink;

  /// No description provided for @createCollage.
  ///
  /// In en, this message translates to:
  /// **'Create collage'**
  String get createCollage;

  /// No description provided for @saveCollage.
  ///
  /// In en, this message translates to:
  /// **'Save collage'**
  String get saveCollage;

  /// No description provided for @collageSaved.
  ///
  /// In en, this message translates to:
  /// **'Collage saved to gallery'**
  String get collageSaved;

  /// No description provided for @collageLayout.
  ///
  /// In en, this message translates to:
  /// **'Layout'**
  String get collageLayout;

  /// No description provided for @addToEnte.
  ///
  /// In en, this message translates to:
  /// **'Add to Ente'**
  String get addToEnte;

  /// No description provided for @addToAlbum.
  ///
  /// In en, this message translates to:
  /// **'Add to album'**
  String get addToAlbum;

  /// No description provided for @delete.
  ///
  /// In en, this message translates to:
  /// **'Delete'**
  String get delete;

  /// No description provided for @hide.
  ///
  /// In en, this message translates to:
  /// **'Hide'**
  String get hide;

  /// No description provided for @share.
  ///
  /// In en, this message translates to:
  /// **'Share'**
  String get share;

  /// No description provided for @unhideToAlbum.
  ///
  /// In en, this message translates to:
  /// **'Unhide to album'**
  String get unhideToAlbum;

  /// No description provided for @restoreToAlbum.
  ///
  /// In en, this message translates to:
  /// **'Restore to album'**
  String get restoreToAlbum;

  /// Page title while moving one or more items to an album
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =1 {Move item} other {Move items}}'**
  String moveItem({required num count});

  /// Page title while adding one or more items to album
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =1 {Add item} other {Add items}}'**
  String addItem({required num count});

  /// No description provided for @createOrSelectAlbum.
  ///
  /// In en, this message translates to:
  /// **'Create or select album'**
  String get createOrSelectAlbum;

  /// No description provided for @selectAlbum.
  ///
  /// In en, this message translates to:
  /// **'Select album'**
  String get selectAlbum;

  /// No description provided for @searchByAlbumNameHint.
  ///
  /// In en, this message translates to:
  /// **'Album name'**
  String get searchByAlbumNameHint;

  /// No description provided for @albumTitle.
  ///
  /// In en, this message translates to:
  /// **'Album title'**
  String get albumTitle;

  /// No description provided for @enterAlbumName.
  ///
  /// In en, this message translates to:
  /// **'Enter album name'**
  String get enterAlbumName;

  /// No description provided for @restoringFiles.
  ///
  /// In en, this message translates to:
  /// **'Restoring files...'**
  String get restoringFiles;

  /// No description provided for @movingFilesToAlbum.
  ///
  /// In en, this message translates to:
  /// **'Moving files to album...'**
  String get movingFilesToAlbum;

  /// No description provided for @unhidingFilesToAlbum.
  ///
  /// In en, this message translates to:
  /// **'Unhiding files to album'**
  String get unhidingFilesToAlbum;

  /// No description provided for @canNotUploadToAlbumsOwnedByOthers.
  ///
  /// In en, this message translates to:
  /// **'Can not upload to albums owned by others'**
  String get canNotUploadToAlbumsOwnedByOthers;

  /// No description provided for @uploadingFilesToAlbum.
  ///
  /// In en, this message translates to:
  /// **'Uploading files to album...'**
  String get uploadingFilesToAlbum;

  /// No description provided for @addedSuccessfullyTo.
  ///
  /// In en, this message translates to:
  /// **'Added successfully to  {albumName}'**
  String addedSuccessfullyTo({required Object albumName});

  /// No description provided for @movedSuccessfullyTo.
  ///
  /// In en, this message translates to:
  /// **'Moved successfully to {albumName}'**
  String movedSuccessfullyTo({required Object albumName});

  /// No description provided for @thisAlbumAlreadyHDACollaborativeLink.
  ///
  /// In en, this message translates to:
  /// **'This album already has a collaborative link'**
  String get thisAlbumAlreadyHDACollaborativeLink;

  /// No description provided for @collaborativeLinkCreatedFor.
  ///
  /// In en, this message translates to:
  /// **'Collaborative link created for {albumName}'**
  String collaborativeLinkCreatedFor({required Object albumName});

  /// No description provided for @askYourLovedOnesToShare.
  ///
  /// In en, this message translates to:
  /// **'Ask your loved ones to share'**
  String get askYourLovedOnesToShare;

  /// No description provided for @invite.
  ///
  /// In en, this message translates to:
  /// **'Invite'**
  String get invite;

  /// No description provided for @shareYourFirstAlbum.
  ///
  /// In en, this message translates to:
  /// **'Share your first album'**
  String get shareYourFirstAlbum;

  /// No description provided for @sharedWith.
  ///
  /// In en, this message translates to:
  /// **'Shared with {emailIDs}'**
  String sharedWith({required Object emailIDs});

  /// No description provided for @sharedWithMe.
  ///
  /// In en, this message translates to:
  /// **'Shared with me'**
  String get sharedWithMe;

  /// No description provided for @sharedByMe.
  ///
  /// In en, this message translates to:
  /// **'Shared by me'**
  String get sharedByMe;

  /// No description provided for @doubleYourStorage.
  ///
  /// In en, this message translates to:
  /// **'Double your storage'**
  String get doubleYourStorage;

  /// No description provided for @referFriendsAnd2xYourPlan.
  ///
  /// In en, this message translates to:
  /// **'Refer friends and 2x your plan'**
  String get referFriendsAnd2xYourPlan;

  /// No description provided for @shareAlbumHint.
  ///
  /// In en, this message translates to:
  /// **'Open an album and tap the share button on the top right to share.'**
  String get shareAlbumHint;

  /// No description provided for @itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion.
  ///
  /// In en, this message translates to:
  /// **'Items show the number of days remaining before permanent deletion'**
  String get itemsShowTheNumberOfDaysRemainingBeforePermanentDeletion;

  /// Text to indicate number of days remaining before permanent deletion
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =0 {Soon} =1 {1 day} other {{count} days}}'**
  String trashDaysLeft({required int count});

  /// No description provided for @deleteAll.
  ///
  /// In en, this message translates to:
  /// **'Delete All'**
  String get deleteAll;

  /// No description provided for @renameAlbum.
  ///
  /// In en, this message translates to:
  /// **'Rename album'**
  String get renameAlbum;

  /// No description provided for @convertToAlbum.
  ///
  /// In en, this message translates to:
  /// **'Convert to album'**
  String get convertToAlbum;

  /// Text to set cover photo for an album
  ///
  /// In en, this message translates to:
  /// **'Set cover'**
  String get setCover;

  /// No description provided for @sortAlbumsBy.
  ///
  /// In en, this message translates to:
  /// **'Sort by'**
  String get sortAlbumsBy;

  /// No description provided for @sortNewestFirst.
  ///
  /// In en, this message translates to:
  /// **'Newest first'**
  String get sortNewestFirst;

  /// No description provided for @sortOldestFirst.
  ///
  /// In en, this message translates to:
  /// **'Oldest first'**
  String get sortOldestFirst;

  /// No description provided for @rename.
  ///
  /// In en, this message translates to:
  /// **'Rename'**
  String get rename;

  /// No description provided for @leaveSharedAlbum.
  ///
  /// In en, this message translates to:
  /// **'Leave shared album?'**
  String get leaveSharedAlbum;

  /// No description provided for @leaveAlbum.
  ///
  /// In en, this message translates to:
  /// **'Leave album'**
  String get leaveAlbum;

  /// No description provided for @photosAddedByYouWillBeRemovedFromTheAlbum.
  ///
  /// In en, this message translates to:
  /// **'Photos added by you will be removed from the album'**
  String get photosAddedByYouWillBeRemovedFromTheAlbum;

  /// No description provided for @youveNoFilesInThisAlbumThatCanBeDeleted.
  ///
  /// In en, this message translates to:
  /// **'You\'ve no files in this album that can be deleted'**
  String get youveNoFilesInThisAlbumThatCanBeDeleted;

  /// No description provided for @youDontHaveAnyArchivedItems.
  ///
  /// In en, this message translates to:
  /// **'You don\'t have any archived items.'**
  String get youDontHaveAnyArchivedItems;

  /// No description provided for @ignoredFolderUploadReason.
  ///
  /// In en, this message translates to:
  /// **'Some files in this album are ignored from upload because they had previously been deleted from Ente.'**
  String get ignoredFolderUploadReason;

  /// No description provided for @resetIgnoredFiles.
  ///
  /// In en, this message translates to:
  /// **'Reset ignored files'**
  String get resetIgnoredFiles;

  /// No description provided for @deviceFilesAutoUploading.
  ///
  /// In en, this message translates to:
  /// **'Files added to this device album will automatically get uploaded to Ente.'**
  String get deviceFilesAutoUploading;

  /// No description provided for @turnOnBackupForAutoUpload.
  ///
  /// In en, this message translates to:
  /// **'Turn on backup to automatically upload files added to this device folder to Ente.'**
  String get turnOnBackupForAutoUpload;

  /// No description provided for @noHiddenPhotosOrVideos.
  ///
  /// In en, this message translates to:
  /// **'No hidden photos or videos'**
  String get noHiddenPhotosOrVideos;

  /// No description provided for @toHideAPhotoOrVideo.
  ///
  /// In en, this message translates to:
  /// **'To hide a photo or video'**
  String get toHideAPhotoOrVideo;

  /// No description provided for @openTheItem.
  ///
  /// In en, this message translates to:
  /// **'• Open the item'**
  String get openTheItem;

  /// No description provided for @clickOnTheOverflowMenu.
  ///
  /// In en, this message translates to:
  /// **'• Click on the overflow menu'**
  String get clickOnTheOverflowMenu;

  /// No description provided for @click.
  ///
  /// In en, this message translates to:
  /// **'• Click'**
  String get click;

  /// No description provided for @nothingToSeeHere.
  ///
  /// In en, this message translates to:
  /// **'Nothing to see here! 👀'**
  String get nothingToSeeHere;

  /// No description provided for @unarchiveAlbum.
  ///
  /// In en, this message translates to:
  /// **'Unarchive album'**
  String get unarchiveAlbum;

  /// No description provided for @archiveAlbum.
  ///
  /// In en, this message translates to:
  /// **'Archive album'**
  String get archiveAlbum;

  /// No description provided for @calculating.
  ///
  /// In en, this message translates to:
  /// **'Calculating...'**
  String get calculating;

  /// No description provided for @pleaseWaitDeletingAlbum.
  ///
  /// In en, this message translates to:
  /// **'Please wait, deleting album'**
  String get pleaseWaitDeletingAlbum;

  /// No description provided for @searchByExamples.
  ///
  /// In en, this message translates to:
  /// **'• Album names (e.g. \"Camera\")\n• Types of files (e.g. \"Videos\", \".gif\")\n• Years and months (e.g. \"2022\", \"January\")\n• Holidays (e.g. \"Christmas\")\n• Photo descriptions (e.g. “#fun”)'**
  String get searchByExamples;

  /// No description provided for @youCanTrySearchingForADifferentQuery.
  ///
  /// In en, this message translates to:
  /// **'You can try searching for a different query.'**
  String get youCanTrySearchingForADifferentQuery;

  /// No description provided for @noResultsFound.
  ///
  /// In en, this message translates to:
  /// **'No results found'**
  String get noResultsFound;

  /// No description provided for @addedBy.
  ///
  /// In en, this message translates to:
  /// **'Added by {emailOrName}'**
  String addedBy({required Object emailOrName});

  /// No description provided for @loadingExifData.
  ///
  /// In en, this message translates to:
  /// **'Loading EXIF data...'**
  String get loadingExifData;

  /// No description provided for @viewAllExifData.
  ///
  /// In en, this message translates to:
  /// **'View all EXIF data'**
  String get viewAllExifData;

  /// No description provided for @noExifData.
  ///
  /// In en, this message translates to:
  /// **'No EXIF data'**
  String get noExifData;

  /// No description provided for @thisImageHasNoExifData.
  ///
  /// In en, this message translates to:
  /// **'This image has no exif data'**
  String get thisImageHasNoExifData;

  /// No description provided for @exif.
  ///
  /// In en, this message translates to:
  /// **'EXIF'**
  String get exif;

  /// No description provided for @noResults.
  ///
  /// In en, this message translates to:
  /// **'No results'**
  String get noResults;

  /// No description provided for @weDontSupportEditingPhotosAndAlbumsThatYouDont.
  ///
  /// In en, this message translates to:
  /// **'We don\'t support editing photos and albums that you don\'t own yet'**
  String get weDontSupportEditingPhotosAndAlbumsThatYouDont;

  /// No description provided for @failedToFetchOriginalForEdit.
  ///
  /// In en, this message translates to:
  /// **'Failed to fetch original for edit'**
  String get failedToFetchOriginalForEdit;

  /// No description provided for @close.
  ///
  /// In en, this message translates to:
  /// **'Close'**
  String get close;

  /// No description provided for @setAs.
  ///
  /// In en, this message translates to:
  /// **'Set as'**
  String get setAs;

  /// No description provided for @fileSavedToGallery.
  ///
  /// In en, this message translates to:
  /// **'File saved to gallery'**
  String get fileSavedToGallery;

  /// No description provided for @filesSavedToGallery.
  ///
  /// In en, this message translates to:
  /// **'Files saved to gallery'**
  String get filesSavedToGallery;

  /// No description provided for @fileFailedToSaveToGallery.
  ///
  /// In en, this message translates to:
  /// **'Failed to save file to gallery'**
  String get fileFailedToSaveToGallery;

  /// No description provided for @download.
  ///
  /// In en, this message translates to:
  /// **'Download'**
  String get download;

  /// No description provided for @pressAndHoldToPlayVideo.
  ///
  /// In en, this message translates to:
  /// **'Press and hold to play video'**
  String get pressAndHoldToPlayVideo;

  /// No description provided for @pressAndHoldToPlayVideoDetailed.
  ///
  /// In en, this message translates to:
  /// **'Press and hold on the image to  play video'**
  String get pressAndHoldToPlayVideoDetailed;

  /// No description provided for @downloadFailed.
  ///
  /// In en, this message translates to:
  /// **'Download failed'**
  String get downloadFailed;

  /// No description provided for @deduplicateFiles.
  ///
  /// In en, this message translates to:
  /// **'Deduplicate Files'**
  String get deduplicateFiles;

  /// No description provided for @deselectAll.
  ///
  /// In en, this message translates to:
  /// **'Deselect all'**
  String get deselectAll;

  /// No description provided for @reviewDeduplicateItems.
  ///
  /// In en, this message translates to:
  /// **'Please review and delete the items you believe are duplicates.'**
  String get reviewDeduplicateItems;

  /// No description provided for @clubByCaptureTime.
  ///
  /// In en, this message translates to:
  /// **'Club by capture time'**
  String get clubByCaptureTime;

  /// No description provided for @clubByFileName.
  ///
  /// In en, this message translates to:
  /// **'Club by file name'**
  String get clubByFileName;

  /// No description provided for @count.
  ///
  /// In en, this message translates to:
  /// **'Count'**
  String get count;

  /// No description provided for @totalSize.
  ///
  /// In en, this message translates to:
  /// **'Total size'**
  String get totalSize;

  /// No description provided for @longpressOnAnItemToViewInFullscreen.
  ///
  /// In en, this message translates to:
  /// **'Long-press on an item to view in full-screen'**
  String get longpressOnAnItemToViewInFullscreen;

  /// No description provided for @decryptingVideo.
  ///
  /// In en, this message translates to:
  /// **'Decrypting video...'**
  String get decryptingVideo;

  /// No description provided for @authToViewYourMemories.
  ///
  /// In en, this message translates to:
  /// **'Please authenticate to view your memories'**
  String get authToViewYourMemories;

  /// No description provided for @unlock.
  ///
  /// In en, this message translates to:
  /// **'Unlock'**
  String get unlock;

  /// No description provided for @freeUpSpace.
  ///
  /// In en, this message translates to:
  /// **'Free up space'**
  String get freeUpSpace;

  /// Text to tell user how much space they can free up by deleting items from the device
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =1 {It can be deleted from the device to free up {formattedSize}} other {They can be deleted from the device to free up {formattedSize}}}'**
  String freeUpSpaceSaving({required num count, required Object formattedSize});

  /// Text to tell user how many files have been backed up in the album
  ///
  /// In en, this message translates to:
  /// **'{count, plural, one {1 file} other {{formattedNumber} files}} in this album has been backed up safely'**
  String filesBackedUpInAlbum({
    required int count,
    required String formattedNumber,
  });

  /// Text to tell user how many files have been backed up from this device
  ///
  /// In en, this message translates to:
  /// **'{count, plural, one {1 file} other {{formattedNumber} files}} on this device have been backed up safely'**
  String filesBackedUpFromDevice({
    required int count,
    required String formattedNumber,
  });

  /// No description provided for @freeUpAccessPostDelete.
  ///
  /// In en, this message translates to:
  /// **'You can still access {count, plural, =1 {it} other {them}} on Ente as long as you have an active subscription'**
  String freeUpAccessPostDelete({required int count});

  /// No description provided for @freeUpAmount.
  ///
  /// In en, this message translates to:
  /// **'Free up {sizeInMBorGB}'**
  String freeUpAmount({required Object sizeInMBorGB});

  /// No description provided for @thisEmailIsAlreadyInUse.
  ///
  /// In en, this message translates to:
  /// **'This email is already in use'**
  String get thisEmailIsAlreadyInUse;

  /// No description provided for @incorrectCode.
  ///
  /// In en, this message translates to:
  /// **'Incorrect code'**
  String get incorrectCode;

  /// No description provided for @authenticationFailedPleaseTryAgain.
  ///
  /// In en, this message translates to:
  /// **'Authentication failed, please try again'**
  String get authenticationFailedPleaseTryAgain;

  /// No description provided for @verificationFailedPleaseTryAgain.
  ///
  /// In en, this message translates to:
  /// **'Verification failed, please try again'**
  String get verificationFailedPleaseTryAgain;

  /// No description provided for @authenticating.
  ///
  /// In en, this message translates to:
  /// **'Authenticating...'**
  String get authenticating;

  /// No description provided for @authenticationSuccessful.
  ///
  /// In en, this message translates to:
  /// **'Authentication successful!'**
  String get authenticationSuccessful;

  /// No description provided for @incorrectRecoveryKey.
  ///
  /// In en, this message translates to:
  /// **'Incorrect recovery key'**
  String get incorrectRecoveryKey;

  /// No description provided for @theRecoveryKeyYouEnteredIsIncorrect.
  ///
  /// In en, this message translates to:
  /// **'The recovery key you entered is incorrect'**
  String get theRecoveryKeyYouEnteredIsIncorrect;

  /// No description provided for @twofactorAuthenticationSuccessfullyReset.
  ///
  /// In en, this message translates to:
  /// **'Two-factor authentication successfully reset'**
  String get twofactorAuthenticationSuccessfullyReset;

  /// No description provided for @pleaseVerifyTheCodeYouHaveEntered.
  ///
  /// In en, this message translates to:
  /// **'Please verify the code you have entered'**
  String get pleaseVerifyTheCodeYouHaveEntered;

  /// No description provided for @pleaseContactSupportIfTheProblemPersists.
  ///
  /// In en, this message translates to:
  /// **'Please contact support if the problem persists'**
  String get pleaseContactSupportIfTheProblemPersists;

  /// No description provided for @twofactorAuthenticationHasBeenDisabled.
  ///
  /// In en, this message translates to:
  /// **'Two-factor authentication has been disabled'**
  String get twofactorAuthenticationHasBeenDisabled;

  /// No description provided for @sorryTheCodeYouveEnteredIsIncorrect.
  ///
  /// In en, this message translates to:
  /// **'Sorry, the code you\'ve entered is incorrect'**
  String get sorryTheCodeYouveEnteredIsIncorrect;

  /// No description provided for @yourVerificationCodeHasExpired.
  ///
  /// In en, this message translates to:
  /// **'Your verification code has expired'**
  String get yourVerificationCodeHasExpired;

  /// No description provided for @emailChangedTo.
  ///
  /// In en, this message translates to:
  /// **'Email changed to {newEmail}'**
  String emailChangedTo({required Object newEmail});

  /// No description provided for @verifying.
  ///
  /// In en, this message translates to:
  /// **'Verifying...'**
  String get verifying;

  /// No description provided for @disablingTwofactorAuthentication.
  ///
  /// In en, this message translates to:
  /// **'Disabling two-factor authentication...'**
  String get disablingTwofactorAuthentication;

  /// No description provided for @allMemoriesPreserved.
  ///
  /// In en, this message translates to:
  /// **'All memories preserved'**
  String get allMemoriesPreserved;

  /// No description provided for @loadingGallery.
  ///
  /// In en, this message translates to:
  /// **'Loading gallery...'**
  String get loadingGallery;

  /// No description provided for @syncing.
  ///
  /// In en, this message translates to:
  /// **'Syncing...'**
  String get syncing;

  /// No description provided for @encryptingBackup.
  ///
  /// In en, this message translates to:
  /// **'Encrypting backup...'**
  String get encryptingBackup;

  /// No description provided for @syncStopped.
  ///
  /// In en, this message translates to:
  /// **'Sync stopped'**
  String get syncStopped;

  /// Text to tell user how many memories have been preserved
  ///
  /// In en, this message translates to:
  /// **'{completed}/{total} memories preserved'**
  String syncProgress({required String completed, required String total});

  /// Text to tell user how many memories are being preserved
  ///
  /// In en, this message translates to:
  /// **'Preserving {count} memories...'**
  String uploadingMultipleMemories({required String count});

  /// No description provided for @uploadingSingleMemory.
  ///
  /// In en, this message translates to:
  /// **'Preserving 1 memory...'**
  String get uploadingSingleMemory;

  /// No description provided for @archiving.
  ///
  /// In en, this message translates to:
  /// **'Archiving...'**
  String get archiving;

  /// No description provided for @unarchiving.
  ///
  /// In en, this message translates to:
  /// **'Unarchiving...'**
  String get unarchiving;

  /// No description provided for @successfullyArchived.
  ///
  /// In en, this message translates to:
  /// **'Successfully archived'**
  String get successfullyArchived;

  /// No description provided for @successfullyUnarchived.
  ///
  /// In en, this message translates to:
  /// **'Successfully unarchived'**
  String get successfullyUnarchived;

  /// No description provided for @renameFile.
  ///
  /// In en, this message translates to:
  /// **'Rename file'**
  String get renameFile;

  /// No description provided for @enterFileName.
  ///
  /// In en, this message translates to:
  /// **'Enter file name'**
  String get enterFileName;

  /// No description provided for @filesDeleted.
  ///
  /// In en, this message translates to:
  /// **'Files deleted'**
  String get filesDeleted;

  /// No description provided for @selectedFilesAreNotOnEnte.
  ///
  /// In en, this message translates to:
  /// **'Selected files are not on Ente'**
  String get selectedFilesAreNotOnEnte;

  /// No description provided for @thisActionCannotBeUndone.
  ///
  /// In en, this message translates to:
  /// **'This action cannot be undone'**
  String get thisActionCannotBeUndone;

  /// No description provided for @emptyTrash.
  ///
  /// In en, this message translates to:
  /// **'Empty trash?'**
  String get emptyTrash;

  /// No description provided for @permDeleteWarning.
  ///
  /// In en, this message translates to:
  /// **'All items in trash will be permanently deleted\n\nThis action cannot be undone'**
  String get permDeleteWarning;

  /// No description provided for @empty.
  ///
  /// In en, this message translates to:
  /// **'Empty'**
  String get empty;

  /// No description provided for @couldNotFreeUpSpace.
  ///
  /// In en, this message translates to:
  /// **'Could not free up space'**
  String get couldNotFreeUpSpace;

  /// No description provided for @permanentlyDeleteFromDevice.
  ///
  /// In en, this message translates to:
  /// **'Permanently delete from device?'**
  String get permanentlyDeleteFromDevice;

  /// No description provided for @someOfTheFilesYouAreTryingToDeleteAre.
  ///
  /// In en, this message translates to:
  /// **'Some of the files you are trying to delete are only available on your device and cannot be recovered if deleted'**
  String get someOfTheFilesYouAreTryingToDeleteAre;

  /// No description provided for @theyWillBeDeletedFromAllAlbums.
  ///
  /// In en, this message translates to:
  /// **'They will be deleted from all albums.'**
  String get theyWillBeDeletedFromAllAlbums;

  /// No description provided for @someItemsAreInBothEnteAndYourDevice.
  ///
  /// In en, this message translates to:
  /// **'Some items are in both Ente and your device.'**
  String get someItemsAreInBothEnteAndYourDevice;

  /// No description provided for @selectedItemsWillBeDeletedFromAllAlbumsAndMoved.
  ///
  /// In en, this message translates to:
  /// **'Selected items will be deleted from all albums and moved to trash.'**
  String get selectedItemsWillBeDeletedFromAllAlbumsAndMoved;

  /// No description provided for @theseItemsWillBeDeletedFromYourDevice.
  ///
  /// In en, this message translates to:
  /// **'These items will be deleted from your device.'**
  String get theseItemsWillBeDeletedFromYourDevice;

  /// No description provided for @itLooksLikeSomethingWentWrongPleaseRetryAfterSome.
  ///
  /// In en, this message translates to:
  /// **'It looks like something went wrong. Please retry after some time. If the error persists, please contact our support team.'**
  String get itLooksLikeSomethingWentWrongPleaseRetryAfterSome;

  /// No description provided for @error.
  ///
  /// In en, this message translates to:
  /// **'Error'**
  String get error;

  /// No description provided for @tempErrorContactSupportIfPersists.
  ///
  /// In en, this message translates to:
  /// **'It looks like something went wrong. Please retry after some time. If the error persists, please contact our support team.'**
  String get tempErrorContactSupportIfPersists;

  /// No description provided for @networkHostLookUpErr.
  ///
  /// In en, this message translates to:
  /// **'Unable to connect to Ente, please check your network settings and contact support if the error persists.'**
  String get networkHostLookUpErr;

  /// No description provided for @networkConnectionRefusedErr.
  ///
  /// In en, this message translates to:
  /// **'Unable to connect to Ente, please retry after sometime. If the error persists, please contact support.'**
  String get networkConnectionRefusedErr;

  /// No description provided for @cachedData.
  ///
  /// In en, this message translates to:
  /// **'Cached data'**
  String get cachedData;

  /// No description provided for @clearCaches.
  ///
  /// In en, this message translates to:
  /// **'Clear caches'**
  String get clearCaches;

  /// No description provided for @remoteImages.
  ///
  /// In en, this message translates to:
  /// **'Remote images'**
  String get remoteImages;

  /// No description provided for @remoteVideos.
  ///
  /// In en, this message translates to:
  /// **'Remote videos'**
  String get remoteVideos;

  /// No description provided for @remoteThumbnails.
  ///
  /// In en, this message translates to:
  /// **'Remote thumbnails'**
  String get remoteThumbnails;

  /// No description provided for @pendingSync.
  ///
  /// In en, this message translates to:
  /// **'Pending sync'**
  String get pendingSync;

  /// No description provided for @localGallery.
  ///
  /// In en, this message translates to:
  /// **'Local gallery'**
  String get localGallery;

  /// No description provided for @todaysLogs.
  ///
  /// In en, this message translates to:
  /// **'Today\'s logs'**
  String get todaysLogs;

  /// No description provided for @viewLogs.
  ///
  /// In en, this message translates to:
  /// **'View logs'**
  String get viewLogs;

  /// No description provided for @logsDialogBody.
  ///
  /// In en, this message translates to:
  /// **'This will send across logs to help us debug your issue. Please note that file names will be included to help track issues with specific files.'**
  String get logsDialogBody;

  /// No description provided for @preparingLogs.
  ///
  /// In en, this message translates to:
  /// **'Preparing logs...'**
  String get preparingLogs;

  /// No description provided for @emailYourLogs.
  ///
  /// In en, this message translates to:
  /// **'Email your logs'**
  String get emailYourLogs;

  /// No description provided for @pleaseSendTheLogsTo.
  ///
  /// In en, this message translates to:
  /// **'Please send the logs to \n{toEmail}'**
  String pleaseSendTheLogsTo({required Object toEmail});

  /// No description provided for @copyEmailAddress.
  ///
  /// In en, this message translates to:
  /// **'Copy email address'**
  String get copyEmailAddress;

  /// No description provided for @exportLogs.
  ///
  /// In en, this message translates to:
  /// **'Export logs'**
  String get exportLogs;

  /// No description provided for @pleaseEmailUsAt.
  ///
  /// In en, this message translates to:
  /// **'Please email us at {toEmail}'**
  String pleaseEmailUsAt({required Object toEmail});

  /// No description provided for @dismiss.
  ///
  /// In en, this message translates to:
  /// **'Dismiss'**
  String get dismiss;

  /// No description provided for @didYouKnow.
  ///
  /// In en, this message translates to:
  /// **'Did you know?'**
  String get didYouKnow;

  /// No description provided for @loadingMessage.
  ///
  /// In en, this message translates to:
  /// **'Loading your photos...'**
  String get loadingMessage;

  /// No description provided for @loadMessage1.
  ///
  /// In en, this message translates to:
  /// **'You can share your subscription with your family'**
  String get loadMessage1;

  /// No description provided for @loadMessage2.
  ///
  /// In en, this message translates to:
  /// **'We have preserved over 200 million memories so far'**
  String get loadMessage2;

  /// No description provided for @loadMessage3.
  ///
  /// In en, this message translates to:
  /// **'We keep 3 copies of your data, one in an underground fallout shelter'**
  String get loadMessage3;

  /// No description provided for @loadMessage4.
  ///
  /// In en, this message translates to:
  /// **'All our apps are open source'**
  String get loadMessage4;

  /// No description provided for @loadMessage5.
  ///
  /// In en, this message translates to:
  /// **'Our source code and cryptography have been externally audited'**
  String get loadMessage5;

  /// No description provided for @loadMessage6.
  ///
  /// In en, this message translates to:
  /// **'You can share links to your albums with your loved ones'**
  String get loadMessage6;

  /// No description provided for @loadMessage7.
  ///
  /// In en, this message translates to:
  /// **'Our mobile apps run in the background to encrypt and backup any new photos you click'**
  String get loadMessage7;

  /// No description provided for @loadMessage8.
  ///
  /// In en, this message translates to:
  /// **'web.ente.io has a slick uploader'**
  String get loadMessage8;

  /// No description provided for @loadMessage9.
  ///
  /// In en, this message translates to:
  /// **'We use Xchacha20Poly1305 to safely encrypt your data'**
  String get loadMessage9;

  /// No description provided for @photoDescriptions.
  ///
  /// In en, this message translates to:
  /// **'Photo descriptions'**
  String get photoDescriptions;

  /// No description provided for @fileTypesAndNames.
  ///
  /// In en, this message translates to:
  /// **'File types and names'**
  String get fileTypesAndNames;

  /// No description provided for @location.
  ///
  /// In en, this message translates to:
  /// **'Location'**
  String get location;

  /// No description provided for @moments.
  ///
  /// In en, this message translates to:
  /// **'Moments'**
  String get moments;

  /// No description provided for @searchFaceEmptySection.
  ///
  /// In en, this message translates to:
  /// **'People will be shown here once indexing is done'**
  String get searchFaceEmptySection;

  /// No description provided for @searchDatesEmptySection.
  ///
  /// In en, this message translates to:
  /// **'Search by a date, month or year'**
  String get searchDatesEmptySection;

  /// No description provided for @searchLocationEmptySection.
  ///
  /// In en, this message translates to:
  /// **'Group photos that are taken within some radius of a photo'**
  String get searchLocationEmptySection;

  /// No description provided for @searchPeopleEmptySection.
  ///
  /// In en, this message translates to:
  /// **'Invite people, and you\'ll see all photos shared by them here'**
  String get searchPeopleEmptySection;

  /// No description provided for @searchAlbumsEmptySection.
  ///
  /// In en, this message translates to:
  /// **'Albums'**
  String get searchAlbumsEmptySection;

  /// No description provided for @searchFileTypesAndNamesEmptySection.
  ///
  /// In en, this message translates to:
  /// **'File types and names'**
  String get searchFileTypesAndNamesEmptySection;

  /// No description provided for @searchCaptionEmptySection.
  ///
  /// In en, this message translates to:
  /// **'Add descriptions like \"#trip\" in photo info to quickly find them here'**
  String get searchCaptionEmptySection;

  /// No description provided for @language.
  ///
  /// In en, this message translates to:
  /// **'Language'**
  String get language;

  /// No description provided for @selectLanguage.
  ///
  /// In en, this message translates to:
  /// **'Select Language'**
  String get selectLanguage;

  /// No description provided for @locationName.
  ///
  /// In en, this message translates to:
  /// **'Location name'**
  String get locationName;

  /// No description provided for @addLocation.
  ///
  /// In en, this message translates to:
  /// **'Add location'**
  String get addLocation;

  /// No description provided for @groupNearbyPhotos.
  ///
  /// In en, this message translates to:
  /// **'Group nearby photos'**
  String get groupNearbyPhotos;

  /// No description provided for @kiloMeterUnit.
  ///
  /// In en, this message translates to:
  /// **'km'**
  String get kiloMeterUnit;

  /// No description provided for @addLocationButton.
  ///
  /// In en, this message translates to:
  /// **'Add'**
  String get addLocationButton;

  /// No description provided for @radius.
  ///
  /// In en, this message translates to:
  /// **'Radius'**
  String get radius;

  /// No description provided for @locationTagFeatureDescription.
  ///
  /// In en, this message translates to:
  /// **'A location tag groups all photos that were taken within some radius of a photo'**
  String get locationTagFeatureDescription;

  /// No description provided for @galleryMemoryLimitInfo.
  ///
  /// In en, this message translates to:
  /// **'Up to 1000 memories shown in gallery'**
  String get galleryMemoryLimitInfo;

  /// No description provided for @save.
  ///
  /// In en, this message translates to:
  /// **'Save'**
  String get save;

  /// No description provided for @centerPoint.
  ///
  /// In en, this message translates to:
  /// **'Center point'**
  String get centerPoint;

  /// No description provided for @pickCenterPoint.
  ///
  /// In en, this message translates to:
  /// **'Pick center point'**
  String get pickCenterPoint;

  /// No description provided for @useSelectedPhoto.
  ///
  /// In en, this message translates to:
  /// **'Use selected photo'**
  String get useSelectedPhoto;

  /// Button text to reset cover photo to default
  ///
  /// In en, this message translates to:
  /// **'Reset to default'**
  String get resetToDefault;

  /// No description provided for @edit.
  ///
  /// In en, this message translates to:
  /// **'Edit'**
  String get edit;

  /// No description provided for @deleteLocation.
  ///
  /// In en, this message translates to:
  /// **'Delete location'**
  String get deleteLocation;

  /// No description provided for @rotateLeft.
  ///
  /// In en, this message translates to:
  /// **'Rotate left'**
  String get rotateLeft;

  /// No description provided for @flip.
  ///
  /// In en, this message translates to:
  /// **'Flip'**
  String get flip;

  /// No description provided for @rotateRight.
  ///
  /// In en, this message translates to:
  /// **'Rotate right'**
  String get rotateRight;

  /// No description provided for @saveCopy.
  ///
  /// In en, this message translates to:
  /// **'Save copy'**
  String get saveCopy;

  /// No description provided for @light.
  ///
  /// In en, this message translates to:
  /// **'Light'**
  String get light;

  /// No description provided for @color.
  ///
  /// In en, this message translates to:
  /// **'Color'**
  String get color;

  /// No description provided for @yesDiscardChanges.
  ///
  /// In en, this message translates to:
  /// **'Yes, discard changes'**
  String get yesDiscardChanges;

  /// No description provided for @doYouWantToDiscardTheEditsYouHaveMade.
  ///
  /// In en, this message translates to:
  /// **'Do you want to discard the edits you have made?'**
  String get doYouWantToDiscardTheEditsYouHaveMade;

  /// No description provided for @saving.
  ///
  /// In en, this message translates to:
  /// **'Saving...'**
  String get saving;

  /// No description provided for @editsSaved.
  ///
  /// In en, this message translates to:
  /// **'Edits saved'**
  String get editsSaved;

  /// No description provided for @oopsCouldNotSaveEdits.
  ///
  /// In en, this message translates to:
  /// **'Oops, could not save edits'**
  String get oopsCouldNotSaveEdits;

  /// Unit for distance in km
  ///
  /// In en, this message translates to:
  /// **'km'**
  String get distanceInKMUnit;

  /// No description provided for @dayToday.
  ///
  /// In en, this message translates to:
  /// **'Today'**
  String get dayToday;

  /// No description provided for @dayYesterday.
  ///
  /// In en, this message translates to:
  /// **'Yesterday'**
  String get dayYesterday;

  /// No description provided for @storage.
  ///
  /// In en, this message translates to:
  /// **'Storage'**
  String get storage;

  /// No description provided for @usedSpace.
  ///
  /// In en, this message translates to:
  /// **'Used space'**
  String get usedSpace;

  /// No description provided for @storageBreakupFamily.
  ///
  /// In en, this message translates to:
  /// **'Family'**
  String get storageBreakupFamily;

  /// Label to indicate how much storage you are using when you are part of a family plan
  ///
  /// In en, this message translates to:
  /// **'You'**
  String get storageBreakupYou;

  /// Example: 1.2 GB of 2 GB used or 100 GB or 2TB used
  ///
  /// In en, this message translates to:
  /// **'{usedAmount} {usedStorageUnit} of {totalAmount} {totalStorageUnit} used'**
  String storageUsageInfo({
    required Object totalAmount,
    required Object totalStorageUnit,
    required Object usedAmount,
    required Object usedStorageUnit,
  });

  /// No description provided for @availableStorageSpace.
  ///
  /// In en, this message translates to:
  /// **'{freeAmount} {storageUnit} free'**
  String availableStorageSpace({
    required Object freeAmount,
    required Object storageUnit,
  });

  /// No description provided for @appVersion.
  ///
  /// In en, this message translates to:
  /// **'Version: {versionValue}'**
  String appVersion({required Object versionValue});

  /// No description provided for @verifyIDLabel.
  ///
  /// In en, this message translates to:
  /// **'Verify'**
  String get verifyIDLabel;

  /// No description provided for @fileInfoAddDescHint.
  ///
  /// In en, this message translates to:
  /// **'Add a description...'**
  String get fileInfoAddDescHint;

  /// No description provided for @editLocationTagTitle.
  ///
  /// In en, this message translates to:
  /// **'Edit location'**
  String get editLocationTagTitle;

  /// Label of confirm button to add a new custom radius to the radius selector of a location tag
  ///
  /// In en, this message translates to:
  /// **'Set'**
  String get setLabel;

  /// No description provided for @setRadius.
  ///
  /// In en, this message translates to:
  /// **'Set radius'**
  String get setRadius;

  /// No description provided for @familyPlanPortalTitle.
  ///
  /// In en, this message translates to:
  /// **'Family'**
  String get familyPlanPortalTitle;

  /// No description provided for @familyPlanOverview.
  ///
  /// In en, this message translates to:
  /// **'Add 5 family members to your existing plan without paying extra.\n\nEach member gets their own private space, and cannot see each other\'s files unless they\'re shared.\n\nFamily plans are available to customers who have a paid Ente subscription.\n\nSubscribe now to get started!'**
  String get familyPlanOverview;

  /// Hint message advising the user how to authenticate with biometrics. It is used on Android side. Maximum 60 characters.
  ///
  /// In en, this message translates to:
  /// **'Verify identity'**
  String get androidBiometricHint;

  /// Message to let the user know that authentication was failed. It is used on Android side. Maximum 60 characters.
  ///
  /// In en, this message translates to:
  /// **'Not recognized. Try again.'**
  String get androidBiometricNotRecognized;

  /// Message to let the user know that authentication was successful. It is used on Android side. Maximum 60 characters.
  ///
  /// In en, this message translates to:
  /// **'Success'**
  String get androidBiometricSuccess;

  /// Message showed on a button that the user can click to leave the current dialog. It is used on Android side. Maximum 30 characters.
  ///
  /// In en, this message translates to:
  /// **'Cancel'**
  String get androidCancelButton;

  /// Message showed as a title in a dialog which indicates the user that they need to scan biometric to continue. It is used on Android side. Maximum 60 characters.
  ///
  /// In en, this message translates to:
  /// **'Authentication required'**
  String get androidSignInTitle;

  /// Message showed as a title in a dialog which indicates the user has not set up biometric authentication on their device. It is used on Android side. Maximum 60 characters.
  ///
  /// In en, this message translates to:
  /// **'Biometric required'**
  String get androidBiometricRequiredTitle;

  /// Message showed as a title in a dialog which indicates the user has not set up credentials authentication on their device. It is used on Android side. Maximum 60 characters.
  ///
  /// In en, this message translates to:
  /// **'Device credentials required'**
  String get androidDeviceCredentialsRequiredTitle;

  /// Message advising the user to go to the settings and configure device credentials on their device. It shows in a dialog on Android side.
  ///
  /// In en, this message translates to:
  /// **'Device credentials required'**
  String get androidDeviceCredentialsSetupDescription;

  /// Message showed on a button that the user can click to go to settings pages from the current dialog. It is used on both Android and iOS side. Maximum 30 characters.
  ///
  /// In en, this message translates to:
  /// **'Go to settings'**
  String get goToSettings;

  /// Message advising the user to go to the settings and configure biometric on their device. It shows in a dialog on Android side.
  ///
  /// In en, this message translates to:
  /// **'Biometric authentication is not set up on your device. Go to \'Settings > Security\' to add biometric authentication.'**
  String get androidGoToSettingsDescription;

  /// Message advising the user to re-enable biometrics on their device. It shows in a dialog on iOS side.
  ///
  /// In en, this message translates to:
  /// **'Biometric authentication is disabled. Please lock and unlock your screen to enable it.'**
  String get iOSLockOut;

  /// Message advising the user to go to the settings and configure Biometrics for their device. It shows in a dialog on iOS side.
  ///
  /// In en, this message translates to:
  /// **'Biometric authentication is not set up on your device. Please either enable Touch ID or Face ID on your phone.'**
  String get iOSGoToSettingsDescription;

  /// Message showed on a button that the user can click to leave the current dialog. It is used on iOS side. Maximum 30 characters.
  ///
  /// In en, this message translates to:
  /// **'OK'**
  String get iOSOkButton;

  /// No description provided for @openstreetmapContributors.
  ///
  /// In en, this message translates to:
  /// **'OpenStreetMap contributors'**
  String get openstreetmapContributors;

  /// No description provided for @hostedAtOsmFrance.
  ///
  /// In en, this message translates to:
  /// **'Hosted at OSM France'**
  String get hostedAtOsmFrance;

  /// Label for the map view
  ///
  /// In en, this message translates to:
  /// **'Map'**
  String get map;

  /// No description provided for @maps.
  ///
  /// In en, this message translates to:
  /// **'Maps'**
  String get maps;

  /// No description provided for @mapsPrivacyNotice.
  ///
  /// In en, this message translates to:
  /// **'Approximate coordinates will be sent to privacy conscious third parties like OpenStreetMap to show the map and location.'**
  String get mapsPrivacyNotice;

  /// No description provided for @enableMaps.
  ///
  /// In en, this message translates to:
  /// **'Enable Maps'**
  String get enableMaps;

  /// No description provided for @quickLinks.
  ///
  /// In en, this message translates to:
  /// **'Quick links'**
  String get quickLinks;

  /// No description provided for @selectItemsToAdd.
  ///
  /// In en, this message translates to:
  /// **'Select items to add'**
  String get selectItemsToAdd;

  /// No description provided for @addSelected.
  ///
  /// In en, this message translates to:
  /// **'Add selected'**
  String get addSelected;

  /// No description provided for @addFromDevice.
  ///
  /// In en, this message translates to:
  /// **'Add from device'**
  String get addFromDevice;

  /// No description provided for @addPhotos.
  ///
  /// In en, this message translates to:
  /// **'Add photos'**
  String get addPhotos;

  /// No description provided for @noPhotosFoundHere.
  ///
  /// In en, this message translates to:
  /// **'No photos found here'**
  String get noPhotosFoundHere;

  /// No description provided for @zoomOutToSeePhotos.
  ///
  /// In en, this message translates to:
  /// **'Zoom out to see photos'**
  String get zoomOutToSeePhotos;

  /// No description provided for @noImagesWithLocation.
  ///
  /// In en, this message translates to:
  /// **'No images with location'**
  String get noImagesWithLocation;

  /// No description provided for @unpinAlbum.
  ///
  /// In en, this message translates to:
  /// **'Unpin album'**
  String get unpinAlbum;

  /// No description provided for @pinAlbum.
  ///
  /// In en, this message translates to:
  /// **'Pin album'**
  String get pinAlbum;

  /// No description provided for @pin.
  ///
  /// In en, this message translates to:
  /// **'Pin'**
  String get pin;

  /// No description provided for @pinPerson.
  ///
  /// In en, this message translates to:
  /// **'Pin person'**
  String get pinPerson;

  /// No description provided for @pinToTop.
  ///
  /// In en, this message translates to:
  /// **'Pin to top'**
  String get pinToTop;

  /// No description provided for @unpin.
  ///
  /// In en, this message translates to:
  /// **'Unpin'**
  String get unpin;

  /// No description provided for @unpinPerson.
  ///
  /// In en, this message translates to:
  /// **'Unpin person'**
  String get unpinPerson;

  /// No description provided for @visibility.
  ///
  /// In en, this message translates to:
  /// **'Visibility'**
  String get visibility;

  /// No description provided for @hideFromMemories.
  ///
  /// In en, this message translates to:
  /// **'Hide from memories'**
  String get hideFromMemories;

  /// No description provided for @showInMemories.
  ///
  /// In en, this message translates to:
  /// **'Show in memories'**
  String get showInMemories;

  /// No description provided for @create.
  ///
  /// In en, this message translates to:
  /// **'Create'**
  String get create;

  /// No description provided for @viewAll.
  ///
  /// In en, this message translates to:
  /// **'View all'**
  String get viewAll;

  /// No description provided for @nothingSharedWithYouYet.
  ///
  /// In en, this message translates to:
  /// **'Nothing shared with you yet'**
  String get nothingSharedWithYouYet;

  /// No description provided for @noAlbumsSharedByYouYet.
  ///
  /// In en, this message translates to:
  /// **'No albums shared by you yet'**
  String get noAlbumsSharedByYouYet;

  /// No description provided for @sharedWithYou.
  ///
  /// In en, this message translates to:
  /// **'Shared with you'**
  String get sharedWithYou;

  /// No description provided for @sharedByYou.
  ///
  /// In en, this message translates to:
  /// **'Shared by you'**
  String get sharedByYou;

  /// No description provided for @inviteYourFriendsToEnte.
  ///
  /// In en, this message translates to:
  /// **'Invite your friends to Ente'**
  String get inviteYourFriendsToEnte;

  /// No description provided for @failedToDownloadVideo.
  ///
  /// In en, this message translates to:
  /// **'Failed to download video'**
  String get failedToDownloadVideo;

  /// No description provided for @hiding.
  ///
  /// In en, this message translates to:
  /// **'Hiding...'**
  String get hiding;

  /// No description provided for @unhiding.
  ///
  /// In en, this message translates to:
  /// **'Unhiding...'**
  String get unhiding;

  /// No description provided for @successfullyHid.
  ///
  /// In en, this message translates to:
  /// **'Successfully hid'**
  String get successfullyHid;

  /// No description provided for @successfullyUnhid.
  ///
  /// In en, this message translates to:
  /// **'Successfully unhid'**
  String get successfullyUnhid;

  /// No description provided for @crashReporting.
  ///
  /// In en, this message translates to:
  /// **'Crash reporting'**
  String get crashReporting;

  /// No description provided for @resumableUploads.
  ///
  /// In en, this message translates to:
  /// **'Resumable uploads'**
  String get resumableUploads;

  /// No description provided for @addToHiddenAlbum.
  ///
  /// In en, this message translates to:
  /// **'Add to hidden album'**
  String get addToHiddenAlbum;

  /// No description provided for @moveToHiddenAlbum.
  ///
  /// In en, this message translates to:
  /// **'Move to hidden album'**
  String get moveToHiddenAlbum;

  /// No description provided for @fileTypes.
  ///
  /// In en, this message translates to:
  /// **'File types'**
  String get fileTypes;

  /// No description provided for @deleteConfirmDialogBody.
  ///
  /// In en, this message translates to:
  /// **'This account is linked to other Ente apps, if you use any. Your uploaded data, across all Ente apps, will be scheduled for deletion, and your account will be permanently deleted.'**
  String get deleteConfirmDialogBody;

  /// No description provided for @hearUsWhereTitle.
  ///
  /// In en, this message translates to:
  /// **'How did you hear about Ente? (optional)'**
  String get hearUsWhereTitle;

  /// No description provided for @hearUsExplanation.
  ///
  /// In en, this message translates to:
  /// **'We don\'t track app installs. It\'d help if you told us where you found us!'**
  String get hearUsExplanation;

  /// No description provided for @viewAddOnButton.
  ///
  /// In en, this message translates to:
  /// **'View add-ons'**
  String get viewAddOnButton;

  /// No description provided for @addOns.
  ///
  /// In en, this message translates to:
  /// **'Add-ons'**
  String get addOns;

  /// No description provided for @addOnPageSubtitle.
  ///
  /// In en, this message translates to:
  /// **'Details of add-ons'**
  String get addOnPageSubtitle;

  /// No description provided for @yourMap.
  ///
  /// In en, this message translates to:
  /// **'Your map'**
  String get yourMap;

  /// No description provided for @modifyYourQueryOrTrySearchingFor.
  ///
  /// In en, this message translates to:
  /// **'Modify your query, or try searching for'**
  String get modifyYourQueryOrTrySearchingFor;

  /// No description provided for @blackFridaySale.
  ///
  /// In en, this message translates to:
  /// **'Black Friday Sale'**
  String get blackFridaySale;

  /// No description provided for @upto50OffUntil4thDec.
  ///
  /// In en, this message translates to:
  /// **'Upto 50% off, until 4th Dec.'**
  String get upto50OffUntil4thDec;

  /// No description provided for @photos.
  ///
  /// In en, this message translates to:
  /// **'Photos'**
  String get photos;

  /// No description provided for @videos.
  ///
  /// In en, this message translates to:
  /// **'Videos'**
  String get videos;

  /// No description provided for @livePhotos.
  ///
  /// In en, this message translates to:
  /// **'Live Photos'**
  String get livePhotos;

  /// No description provided for @searchHint1.
  ///
  /// In en, this message translates to:
  /// **'Fast, on-device search'**
  String get searchHint1;

  /// No description provided for @searchHint2.
  ///
  /// In en, this message translates to:
  /// **'Photo dates, descriptions'**
  String get searchHint2;

  /// No description provided for @searchHint3.
  ///
  /// In en, this message translates to:
  /// **'Albums, file names, and types'**
  String get searchHint3;

  /// No description provided for @searchHint4.
  ///
  /// In en, this message translates to:
  /// **'Location'**
  String get searchHint4;

  /// No description provided for @searchHint5.
  ///
  /// In en, this message translates to:
  /// **'Coming soon: Faces & magic search ✨'**
  String get searchHint5;

  /// No description provided for @addYourPhotosNow.
  ///
  /// In en, this message translates to:
  /// **'Add your photos now'**
  String get addYourPhotosNow;

  /// Text to tell user how many results were found for their search query
  ///
  /// In en, this message translates to:
  /// **'{count, plural, one{{count} result found} other{{count} results found}}'**
  String searchResultCount({required int count});

  /// No description provided for @faces.
  ///
  /// In en, this message translates to:
  /// **'Faces'**
  String get faces;

  /// No description provided for @people.
  ///
  /// In en, this message translates to:
  /// **'People'**
  String get people;

  /// No description provided for @contents.
  ///
  /// In en, this message translates to:
  /// **'Contents'**
  String get contents;

  /// Text to add a new item (location tag, album, caption etc)
  ///
  /// In en, this message translates to:
  /// **'Add new'**
  String get addNew;

  /// No description provided for @contacts.
  ///
  /// In en, this message translates to:
  /// **'Contacts'**
  String get contacts;

  /// No description provided for @noInternetConnection.
  ///
  /// In en, this message translates to:
  /// **'No internet connection'**
  String get noInternetConnection;

  /// No description provided for @pleaseCheckYourInternetConnectionAndTryAgain.
  ///
  /// In en, this message translates to:
  /// **'Please check your internet connection and try again.'**
  String get pleaseCheckYourInternetConnectionAndTryAgain;

  /// No description provided for @signOutFromOtherDevices.
  ///
  /// In en, this message translates to:
  /// **'Sign out from other devices'**
  String get signOutFromOtherDevices;

  /// No description provided for @signOutOtherBody.
  ///
  /// In en, this message translates to:
  /// **'If you think someone might know your password, you can force all other devices using your account to sign out.'**
  String get signOutOtherBody;

  /// No description provided for @signOutOtherDevices.
  ///
  /// In en, this message translates to:
  /// **'Sign out other devices'**
  String get signOutOtherDevices;

  /// No description provided for @doNotSignOut.
  ///
  /// In en, this message translates to:
  /// **'Do not sign out'**
  String get doNotSignOut;

  /// No description provided for @editLocation.
  ///
  /// In en, this message translates to:
  /// **'Edit location'**
  String get editLocation;

  /// No description provided for @selectALocation.
  ///
  /// In en, this message translates to:
  /// **'Select a location'**
  String get selectALocation;

  /// No description provided for @selectALocationFirst.
  ///
  /// In en, this message translates to:
  /// **'Select a location first'**
  String get selectALocationFirst;

  /// No description provided for @changeLocationOfSelectedItems.
  ///
  /// In en, this message translates to:
  /// **'Change location of selected items?'**
  String get changeLocationOfSelectedItems;

  /// No description provided for @editsToLocationWillOnlyBeSeenWithinEnte.
  ///
  /// In en, this message translates to:
  /// **'Edits to location will only be seen within Ente'**
  String get editsToLocationWillOnlyBeSeenWithinEnte;

  /// No description provided for @cleanUncategorized.
  ///
  /// In en, this message translates to:
  /// **'Clean Uncategorized'**
  String get cleanUncategorized;

  /// No description provided for @cleanUncategorizedDescription.
  ///
  /// In en, this message translates to:
  /// **'Remove all files from Uncategorized that are present in other albums'**
  String get cleanUncategorizedDescription;

  /// No description provided for @waitingForVerification.
  ///
  /// In en, this message translates to:
  /// **'Waiting for verification...'**
  String get waitingForVerification;

  /// No description provided for @passkey.
  ///
  /// In en, this message translates to:
  /// **'Passkey'**
  String get passkey;

  /// No description provided for @passkeyAuthTitle.
  ///
  /// In en, this message translates to:
  /// **'Passkey verification'**
  String get passkeyAuthTitle;

  /// No description provided for @loginWithTOTP.
  ///
  /// In en, this message translates to:
  /// **'Login with TOTP'**
  String get loginWithTOTP;

  /// No description provided for @passKeyPendingVerification.
  ///
  /// In en, this message translates to:
  /// **'Verification is still pending'**
  String get passKeyPendingVerification;

  /// No description provided for @loginSessionExpired.
  ///
  /// In en, this message translates to:
  /// **'Session expired'**
  String get loginSessionExpired;

  /// No description provided for @loginSessionExpiredDetails.
  ///
  /// In en, this message translates to:
  /// **'Your session has expired. Please login again.'**
  String get loginSessionExpiredDetails;

  /// No description provided for @verifyPasskey.
  ///
  /// In en, this message translates to:
  /// **'Verify passkey'**
  String get verifyPasskey;

  /// No description provided for @playOnTv.
  ///
  /// In en, this message translates to:
  /// **'Play album on TV'**
  String get playOnTv;

  /// No description provided for @pair.
  ///
  /// In en, this message translates to:
  /// **'Pair'**
  String get pair;

  /// No description provided for @deviceNotFound.
  ///
  /// In en, this message translates to:
  /// **'Device not found'**
  String get deviceNotFound;

  /// No description provided for @castInstruction.
  ///
  /// In en, this message translates to:
  /// **'Visit cast.ente.io on the device you want to pair.\n\nEnter the code below to play the album on your TV.'**
  String get castInstruction;

  /// No description provided for @deviceCodeHint.
  ///
  /// In en, this message translates to:
  /// **'Enter the code'**
  String get deviceCodeHint;

  /// No description provided for @joinDiscord.
  ///
  /// In en, this message translates to:
  /// **'Join Discord'**
  String get joinDiscord;

  /// No description provided for @locations.
  ///
  /// In en, this message translates to:
  /// **'Locations'**
  String get locations;

  /// No description provided for @addAName.
  ///
  /// In en, this message translates to:
  /// **'Add a name'**
  String get addAName;

  /// Subtitle to indicate that the user can find people quickly by name
  ///
  /// In en, this message translates to:
  /// **'Find them quickly'**
  String get findThemQuickly;

  /// No description provided for @findPeopleByName.
  ///
  /// In en, this message translates to:
  /// **'Find people quickly by name'**
  String get findPeopleByName;

  /// No description provided for @addViewers.
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =0 {Add viewer} =1 {Add viewer} other {Add viewers}}'**
  String addViewers({required num count});

  /// No description provided for @addCollaborators.
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =0 {Add collaborator} =1 {Add collaborator} other {Add collaborators}}'**
  String addCollaborators({required num count});

  /// No description provided for @longPressAnEmailToVerifyEndToEndEncryption.
  ///
  /// In en, this message translates to:
  /// **'Long press an email to verify end to end encryption.'**
  String get longPressAnEmailToVerifyEndToEndEncryption;

  /// No description provided for @developerSettingsWarning.
  ///
  /// In en, this message translates to:
  /// **'Are you sure that you want to modify Developer settings?'**
  String get developerSettingsWarning;

  /// No description provided for @developerSettings.
  ///
  /// In en, this message translates to:
  /// **'Developer settings'**
  String get developerSettings;

  /// No description provided for @serverEndpoint.
  ///
  /// In en, this message translates to:
  /// **'Server endpoint'**
  String get serverEndpoint;

  /// No description provided for @invalidEndpoint.
  ///
  /// In en, this message translates to:
  /// **'Invalid endpoint'**
  String get invalidEndpoint;

  /// No description provided for @invalidEndpointMessage.
  ///
  /// In en, this message translates to:
  /// **'Sorry, the endpoint you entered is invalid. Please enter a valid endpoint and try again.'**
  String get invalidEndpointMessage;

  /// No description provided for @endpointUpdatedMessage.
  ///
  /// In en, this message translates to:
  /// **'Endpoint updated successfully'**
  String get endpointUpdatedMessage;

  /// No description provided for @customEndpoint.
  ///
  /// In en, this message translates to:
  /// **'Connected to {endpoint}'**
  String customEndpoint({required Object endpoint});

  /// No description provided for @createCollaborativeLink.
  ///
  /// In en, this message translates to:
  /// **'Create collaborative link'**
  String get createCollaborativeLink;

  /// No description provided for @search.
  ///
  /// In en, this message translates to:
  /// **'Search'**
  String get search;

  /// No description provided for @enterPersonName.
  ///
  /// In en, this message translates to:
  /// **'Enter person name'**
  String get enterPersonName;

  /// No description provided for @editEmailAlreadyLinked.
  ///
  /// In en, this message translates to:
  /// **'This email is already linked to {name}.'**
  String editEmailAlreadyLinked({required Object name});

  /// No description provided for @viewPersonToUnlink.
  ///
  /// In en, this message translates to:
  /// **'View {name} to unlink'**
  String viewPersonToUnlink({required Object name});

  /// No description provided for @enterName.
  ///
  /// In en, this message translates to:
  /// **'Enter name'**
  String get enterName;

  /// No description provided for @savePerson.
  ///
  /// In en, this message translates to:
  /// **'Save person'**
  String get savePerson;

  /// No description provided for @editPerson.
  ///
  /// In en, this message translates to:
  /// **'Edit person'**
  String get editPerson;

  /// No description provided for @mergedPhotos.
  ///
  /// In en, this message translates to:
  /// **'Merged photos'**
  String get mergedPhotos;

  /// No description provided for @orMergeWithExistingPerson.
  ///
  /// In en, this message translates to:
  /// **'Or merge with existing'**
  String get orMergeWithExistingPerson;

  /// No description provided for @enterDateOfBirth.
  ///
  /// In en, this message translates to:
  /// **'Birthday (optional)'**
  String get enterDateOfBirth;

  /// No description provided for @birthday.
  ///
  /// In en, this message translates to:
  /// **'Birthday'**
  String get birthday;

  /// No description provided for @removePersonLabel.
  ///
  /// In en, this message translates to:
  /// **'Remove person label'**
  String get removePersonLabel;

  /// No description provided for @autoPairDesc.
  ///
  /// In en, this message translates to:
  /// **'Auto pair works only with devices that support Chromecast.'**
  String get autoPairDesc;

  /// No description provided for @manualPairDesc.
  ///
  /// In en, this message translates to:
  /// **'Pair with PIN works with any screen you wish to view your album on.'**
  String get manualPairDesc;

  /// No description provided for @connectToDevice.
  ///
  /// In en, this message translates to:
  /// **'Connect to device'**
  String get connectToDevice;

  /// No description provided for @autoCastDialogBody.
  ///
  /// In en, this message translates to:
  /// **'You\'ll see available Cast devices here.'**
  String get autoCastDialogBody;

  /// No description provided for @autoCastiOSPermission.
  ///
  /// In en, this message translates to:
  /// **'Make sure Local Network permissions are turned on for the Ente Photos app, in Settings.'**
  String get autoCastiOSPermission;

  /// No description provided for @noDeviceFound.
  ///
  /// In en, this message translates to:
  /// **'No device found'**
  String get noDeviceFound;

  /// No description provided for @stopCastingTitle.
  ///
  /// In en, this message translates to:
  /// **'Stop casting'**
  String get stopCastingTitle;

  /// No description provided for @stopCastingBody.
  ///
  /// In en, this message translates to:
  /// **'Do you want to stop casting?'**
  String get stopCastingBody;

  /// No description provided for @castIPMismatchTitle.
  ///
  /// In en, this message translates to:
  /// **'Failed to cast album'**
  String get castIPMismatchTitle;

  /// No description provided for @castIPMismatchBody.
  ///
  /// In en, this message translates to:
  /// **'Please make sure you are on the same network as the TV.'**
  String get castIPMismatchBody;

  /// No description provided for @pairingComplete.
  ///
  /// In en, this message translates to:
  /// **'Pairing complete'**
  String get pairingComplete;

  /// No description provided for @savingEdits.
  ///
  /// In en, this message translates to:
  /// **'Saving edits...'**
  String get savingEdits;

  /// No description provided for @autoPair.
  ///
  /// In en, this message translates to:
  /// **'Auto pair'**
  String get autoPair;

  /// No description provided for @pairWithPin.
  ///
  /// In en, this message translates to:
  /// **'Pair with PIN'**
  String get pairWithPin;

  /// No description provided for @faceRecognition.
  ///
  /// In en, this message translates to:
  /// **'Face recognition'**
  String get faceRecognition;

  /// No description provided for @foundFaces.
  ///
  /// In en, this message translates to:
  /// **'Found faces'**
  String get foundFaces;

  /// No description provided for @clusteringProgress.
  ///
  /// In en, this message translates to:
  /// **'Clustering progress'**
  String get clusteringProgress;

  /// No description provided for @trim.
  ///
  /// In en, this message translates to:
  /// **'Trim'**
  String get trim;

  /// No description provided for @crop.
  ///
  /// In en, this message translates to:
  /// **'Crop'**
  String get crop;

  /// No description provided for @rotate.
  ///
  /// In en, this message translates to:
  /// **'Rotate'**
  String get rotate;

  /// No description provided for @left.
  ///
  /// In en, this message translates to:
  /// **'Left'**
  String get left;

  /// No description provided for @right.
  ///
  /// In en, this message translates to:
  /// **'Right'**
  String get right;

  /// No description provided for @whatsNew.
  ///
  /// In en, this message translates to:
  /// **'What\'s new'**
  String get whatsNew;

  /// No description provided for @reviewSuggestions.
  ///
  /// In en, this message translates to:
  /// **'Review suggestions'**
  String get reviewSuggestions;

  /// No description provided for @review.
  ///
  /// In en, this message translates to:
  /// **'Review'**
  String get review;

  /// No description provided for @useAsCover.
  ///
  /// In en, this message translates to:
  /// **'Use as cover'**
  String get useAsCover;

  /// Label to indicate that the person in the photo is not the person whose name is mentioned
  ///
  /// In en, this message translates to:
  /// **'Not {name}?'**
  String notPersonLabel({required String name});

  /// No description provided for @enable.
  ///
  /// In en, this message translates to:
  /// **'Enable'**
  String get enable;

  /// No description provided for @enabled.
  ///
  /// In en, this message translates to:
  /// **'Enabled'**
  String get enabled;

  /// No description provided for @moreDetails.
  ///
  /// In en, this message translates to:
  /// **'More details'**
  String get moreDetails;

  /// No description provided for @enableMLIndexingDesc.
  ///
  /// In en, this message translates to:
  /// **'Ente supports on-device machine learning for face recognition, magic search and other advanced search features'**
  String get enableMLIndexingDesc;

  /// No description provided for @magicSearchHint.
  ///
  /// In en, this message translates to:
  /// **'Magic search allows to search photos by their contents, e.g. \'flower\', \'red car\', \'identity documents\''**
  String get magicSearchHint;

  /// No description provided for @panorama.
  ///
  /// In en, this message translates to:
  /// **'Panorama'**
  String get panorama;

  /// No description provided for @reenterPassword.
  ///
  /// In en, this message translates to:
  /// **'Re-enter password'**
  String get reenterPassword;

  /// No description provided for @reenterPin.
  ///
  /// In en, this message translates to:
  /// **'Re-enter PIN'**
  String get reenterPin;

  /// No description provided for @deviceLock.
  ///
  /// In en, this message translates to:
  /// **'Device lock'**
  String get deviceLock;

  /// No description provided for @pinLock.
  ///
  /// In en, this message translates to:
  /// **'PIN lock'**
  String get pinLock;

  /// No description provided for @next.
  ///
  /// In en, this message translates to:
  /// **'Next'**
  String get next;

  /// No description provided for @setNewPassword.
  ///
  /// In en, this message translates to:
  /// **'Set new password'**
  String get setNewPassword;

  /// No description provided for @enterPin.
  ///
  /// In en, this message translates to:
  /// **'Enter PIN'**
  String get enterPin;

  /// No description provided for @setNewPin.
  ///
  /// In en, this message translates to:
  /// **'Set new PIN'**
  String get setNewPin;

  /// No description provided for @appLock.
  ///
  /// In en, this message translates to:
  /// **'App lock'**
  String get appLock;

  /// No description provided for @noSystemLockFound.
  ///
  /// In en, this message translates to:
  /// **'No system lock found'**
  String get noSystemLockFound;

  /// No description provided for @tapToUnlock.
  ///
  /// In en, this message translates to:
  /// **'Tap to unlock'**
  String get tapToUnlock;

  /// No description provided for @tooManyIncorrectAttempts.
  ///
  /// In en, this message translates to:
  /// **'Too many incorrect attempts'**
  String get tooManyIncorrectAttempts;

  /// No description provided for @videoInfo.
  ///
  /// In en, this message translates to:
  /// **'Video Info'**
  String get videoInfo;

  /// No description provided for @autoLock.
  ///
  /// In en, this message translates to:
  /// **'Auto lock'**
  String get autoLock;

  /// No description provided for @immediately.
  ///
  /// In en, this message translates to:
  /// **'Immediately'**
  String get immediately;

  /// No description provided for @autoLockFeatureDescription.
  ///
  /// In en, this message translates to:
  /// **'Time after which the app locks after being put in the background'**
  String get autoLockFeatureDescription;

  /// No description provided for @hideContent.
  ///
  /// In en, this message translates to:
  /// **'Hide content'**
  String get hideContent;

  /// No description provided for @hideContentDescriptionAndroid.
  ///
  /// In en, this message translates to:
  /// **'Hides app content in the app switcher and disables screenshots'**
  String get hideContentDescriptionAndroid;

  /// No description provided for @hideContentDescriptionIos.
  ///
  /// In en, this message translates to:
  /// **'Hides app content in the app switcher'**
  String get hideContentDescriptionIos;

  /// No description provided for @passwordStrengthInfo.
  ///
  /// In en, this message translates to:
  /// **'Password strength is calculated considering the length of the password, used characters, and whether or not the password appears in the top 10,000 most used passwords'**
  String get passwordStrengthInfo;

  /// No description provided for @noQuickLinksSelected.
  ///
  /// In en, this message translates to:
  /// **'No quick links selected'**
  String get noQuickLinksSelected;

  /// No description provided for @pleaseSelectQuickLinksToRemove.
  ///
  /// In en, this message translates to:
  /// **'Please select quick links to remove'**
  String get pleaseSelectQuickLinksToRemove;

  /// No description provided for @removePublicLinks.
  ///
  /// In en, this message translates to:
  /// **'Remove public links'**
  String get removePublicLinks;

  /// No description provided for @thisWillRemovePublicLinksOfAllSelectedQuickLinks.
  ///
  /// In en, this message translates to:
  /// **'This will remove public links of all selected quick links.'**
  String get thisWillRemovePublicLinksOfAllSelectedQuickLinks;

  /// No description provided for @guestView.
  ///
  /// In en, this message translates to:
  /// **'Guest view'**
  String get guestView;

  /// No description provided for @guestViewEnablePreSteps.
  ///
  /// In en, this message translates to:
  /// **'To enable guest view, please setup device passcode or screen lock in your system settings.'**
  String get guestViewEnablePreSteps;

  /// No description provided for @nameTheAlbum.
  ///
  /// In en, this message translates to:
  /// **'Name the album'**
  String get nameTheAlbum;

  /// No description provided for @collectPhotosDescription.
  ///
  /// In en, this message translates to:
  /// **'Create a link where your friends can upload photos in original quality.'**
  String get collectPhotosDescription;

  /// No description provided for @collect.
  ///
  /// In en, this message translates to:
  /// **'Collect'**
  String get collect;

  /// No description provided for @appLockDescriptions.
  ///
  /// In en, this message translates to:
  /// **'Choose between your device\'s default lock screen and a custom lock screen with a PIN or password.'**
  String get appLockDescriptions;

  /// No description provided for @toEnableAppLockPleaseSetupDevicePasscodeOrScreen.
  ///
  /// In en, this message translates to:
  /// **'To enable app lock, please setup device passcode or screen lock in your system settings.'**
  String get toEnableAppLockPleaseSetupDevicePasscodeOrScreen;

  /// No description provided for @authToViewPasskey.
  ///
  /// In en, this message translates to:
  /// **'Please authenticate to view your passkey'**
  String get authToViewPasskey;

  /// No description provided for @loopVideoOn.
  ///
  /// In en, this message translates to:
  /// **'Disable looping'**
  String get loopVideoOn;

  /// No description provided for @loopVideoOff.
  ///
  /// In en, this message translates to:
  /// **'Enable looping'**
  String get loopVideoOff;

  /// No description provided for @localSyncErrorMessage.
  ///
  /// In en, this message translates to:
  /// **'Looks like something went wrong since local photos sync is taking more time than expected. Please reach out to our support team'**
  String get localSyncErrorMessage;

  /// No description provided for @showPerson.
  ///
  /// In en, this message translates to:
  /// **'Show person'**
  String get showPerson;

  /// No description provided for @sort.
  ///
  /// In en, this message translates to:
  /// **'Sort'**
  String get sort;

  /// No description provided for @mostRecent.
  ///
  /// In en, this message translates to:
  /// **'Most recent'**
  String get mostRecent;

  /// No description provided for @mostRelevant.
  ///
  /// In en, this message translates to:
  /// **'Most relevant'**
  String get mostRelevant;

  /// No description provided for @loadingYourPhotos.
  ///
  /// In en, this message translates to:
  /// **'Loading your photos...'**
  String get loadingYourPhotos;

  /// No description provided for @processingImport.
  ///
  /// In en, this message translates to:
  /// **'Processing {folderName}...'**
  String processingImport({required Object folderName});

  /// No description provided for @personName.
  ///
  /// In en, this message translates to:
  /// **'Person name'**
  String get personName;

  /// No description provided for @addNewPerson.
  ///
  /// In en, this message translates to:
  /// **'Add new person'**
  String get addNewPerson;

  /// No description provided for @addNameOrMerge.
  ///
  /// In en, this message translates to:
  /// **'Add name or merge'**
  String get addNameOrMerge;

  /// No description provided for @mergeWithExisting.
  ///
  /// In en, this message translates to:
  /// **'Merge with existing'**
  String get mergeWithExisting;

  /// No description provided for @newPerson.
  ///
  /// In en, this message translates to:
  /// **'New person'**
  String get newPerson;

  /// No description provided for @addName.
  ///
  /// In en, this message translates to:
  /// **'Add name'**
  String get addName;

  /// No description provided for @add.
  ///
  /// In en, this message translates to:
  /// **'Add'**
  String get add;

  /// No description provided for @extraPhotosFoundFor.
  ///
  /// In en, this message translates to:
  /// **'Extra photos found for {text}'**
  String extraPhotosFoundFor({required String text});

  /// No description provided for @extraPhotosFound.
  ///
  /// In en, this message translates to:
  /// **'Extra photos found'**
  String get extraPhotosFound;

  /// No description provided for @configuration.
  ///
  /// In en, this message translates to:
  /// **'Configuration'**
  String get configuration;

  /// No description provided for @localIndexing.
  ///
  /// In en, this message translates to:
  /// **'Local indexing'**
  String get localIndexing;

  /// No description provided for @processed.
  ///
  /// In en, this message translates to:
  /// **'Processed'**
  String get processed;

  /// No description provided for @resetPerson.
  ///
  /// In en, this message translates to:
  /// **'Remove'**
  String get resetPerson;

  /// No description provided for @areYouSureYouWantToResetThisPerson.
  ///
  /// In en, this message translates to:
  /// **'Are you sure you want to reset this person?'**
  String get areYouSureYouWantToResetThisPerson;

  /// No description provided for @allPersonGroupingWillReset.
  ///
  /// In en, this message translates to:
  /// **'All groupings for this person will be reset, and you will lose all suggestions made for this person'**
  String get allPersonGroupingWillReset;

  /// No description provided for @yesResetPerson.
  ///
  /// In en, this message translates to:
  /// **'Yes, reset person'**
  String get yesResetPerson;

  /// No description provided for @onlyThem.
  ///
  /// In en, this message translates to:
  /// **'Only them'**
  String get onlyThem;

  /// No description provided for @checkingModels.
  ///
  /// In en, this message translates to:
  /// **'Checking models...'**
  String get checkingModels;

  /// No description provided for @enableMachineLearningBanner.
  ///
  /// In en, this message translates to:
  /// **'Enable machine learning for magic search and face recognition'**
  String get enableMachineLearningBanner;

  /// No description provided for @searchDiscoverEmptySection.
  ///
  /// In en, this message translates to:
  /// **'Images will be shown here once processing and syncing is complete'**
  String get searchDiscoverEmptySection;

  /// No description provided for @searchPersonsEmptySection.
  ///
  /// In en, this message translates to:
  /// **'People will be shown here once processing and syncing is complete'**
  String get searchPersonsEmptySection;

  /// Number of viewers that were successfully added to an album.
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =0 {Added 0 viewers} =1 {Added 1 viewer} other {Added {count} viewers}}'**
  String viewersSuccessfullyAdded({required int count});

  /// Number of collaborators that were successfully added to an album.
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =0 {Added 0 collaborator} =1 {Added 1 collaborator} other {Added {count} collaborators}}'**
  String collaboratorsSuccessfullyAdded({required int count});

  /// No description provided for @accountIsAlreadyConfigured.
  ///
  /// In en, this message translates to:
  /// **'Account is already configured.'**
  String get accountIsAlreadyConfigured;

  /// In passkey page, deeplink is ignored because of session ID mismatch.
  ///
  /// In en, this message translates to:
  /// **'Session ID mismatch'**
  String get sessionIdMismatch;

  /// In session page, warn user (in toast) that active sessions could not be fetched.
  ///
  /// In en, this message translates to:
  /// **'Failed to fetch active sessions'**
  String get failedToFetchActiveSessions;

  /// No description provided for @failedToRefreshStripeSubscription.
  ///
  /// In en, this message translates to:
  /// **'Failed to refresh subscription'**
  String get failedToRefreshStripeSubscription;

  /// No description provided for @failedToPlayVideo.
  ///
  /// In en, this message translates to:
  /// **'Failed to play video'**
  String get failedToPlayVideo;

  /// No description provided for @uploadIsIgnoredDueToIgnorereason.
  ///
  /// In en, this message translates to:
  /// **'Upload is ignored due to {ignoreReason}'**
  String uploadIsIgnoredDueToIgnorereason({required String ignoreReason});

  /// No description provided for @typeOfGallerGallerytypeIsNotSupportedForRename.
  ///
  /// In en, this message translates to:
  /// **'Type of gallery {galleryType} is not supported for rename'**
  String typeOfGallerGallerytypeIsNotSupportedForRename({
    required String galleryType,
  });

  /// Shown in upload icon widet, inside a tooltip.
  ///
  /// In en, this message translates to:
  /// **'Tap to upload, upload is currently ignored due to {ignoreReason}'**
  String tapToUploadIsIgnoredDue({required String ignoreReason});

  /// Shown in upload icon widet, inside a tooltip.
  ///
  /// In en, this message translates to:
  /// **'Tap to upload'**
  String get tapToUpload;

  /// No description provided for @info.
  ///
  /// In en, this message translates to:
  /// **'Info'**
  String get info;

  /// No description provided for @addFiles.
  ///
  /// In en, this message translates to:
  /// **'Add Files'**
  String get addFiles;

  /// No description provided for @castAlbum.
  ///
  /// In en, this message translates to:
  /// **'Cast album'**
  String get castAlbum;

  /// No description provided for @imageNotAnalyzed.
  ///
  /// In en, this message translates to:
  /// **'Image not analyzed'**
  String get imageNotAnalyzed;

  /// No description provided for @noFacesFound.
  ///
  /// In en, this message translates to:
  /// **'No faces found'**
  String get noFacesFound;

  /// No description provided for @fileNotUploadedYet.
  ///
  /// In en, this message translates to:
  /// **'File not uploaded yet'**
  String get fileNotUploadedYet;

  /// No description provided for @noSuggestionsForPerson.
  ///
  /// In en, this message translates to:
  /// **'No suggestions for {personName}'**
  String noSuggestionsForPerson({required String personName});

  /// No description provided for @month.
  ///
  /// In en, this message translates to:
  /// **'month'**
  String get month;

  /// Appears in pricing page (/yr)
  ///
  /// In en, this message translates to:
  /// **'yr'**
  String get yearShort;

  /// No description provided for @currentlyRunning.
  ///
  /// In en, this message translates to:
  /// **'currently running'**
  String get currentlyRunning;

  /// No description provided for @ignored.
  ///
  /// In en, this message translates to:
  /// **'ignored'**
  String get ignored;

  /// No description provided for @photosCount.
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =0 {0 photos} =1 {1 photo} other {{count} photos}}'**
  String photosCount({required int count});

  /// No description provided for @file.
  ///
  /// In en, this message translates to:
  /// **'File'**
  String get file;

  /// Appears in search tab page
  ///
  /// In en, this message translates to:
  /// **'Sections length mismatch: {snapshotLength} != {searchLength}'**
  String searchSectionsLengthMismatch({
    required int snapshotLength,
    required int searchLength,
  });

  /// No description provided for @selectMailApp.
  ///
  /// In en, this message translates to:
  /// **'Select mail app'**
  String get selectMailApp;

  /// Text that appears in bottom right when you start to select multiple photos. When clicked, it selects all photos.
  ///
  /// In en, this message translates to:
  /// **'All'**
  String get selectAllShort;

  /// No description provided for @selectCoverPhoto.
  ///
  /// In en, this message translates to:
  /// **'Select cover photo'**
  String get selectCoverPhoto;

  /// No description provided for @newLocation.
  ///
  /// In en, this message translates to:
  /// **'New location'**
  String get newLocation;

  /// No description provided for @faceNotClusteredYet.
  ///
  /// In en, this message translates to:
  /// **'Face not clustered yet, please come back later'**
  String get faceNotClusteredYet;

  /// No description provided for @theLinkYouAreTryingToAccessHasExpired.
  ///
  /// In en, this message translates to:
  /// **'The link you are trying to access has expired.'**
  String get theLinkYouAreTryingToAccessHasExpired;

  /// No description provided for @openFile.
  ///
  /// In en, this message translates to:
  /// **'Open file'**
  String get openFile;

  /// No description provided for @backupFile.
  ///
  /// In en, this message translates to:
  /// **'Backup file'**
  String get backupFile;

  /// No description provided for @openAlbumInBrowser.
  ///
  /// In en, this message translates to:
  /// **'Open album in browser'**
  String get openAlbumInBrowser;

  /// No description provided for @openAlbumInBrowserTitle.
  ///
  /// In en, this message translates to:
  /// **'Please use the web app to add photos to this album'**
  String get openAlbumInBrowserTitle;

  /// No description provided for @allow.
  ///
  /// In en, this message translates to:
  /// **'Allow'**
  String get allow;

  /// No description provided for @allowAppToOpenSharedAlbumLinks.
  ///
  /// In en, this message translates to:
  /// **'Allow app to open shared album links'**
  String get allowAppToOpenSharedAlbumLinks;

  /// No description provided for @seePublicAlbumLinksInApp.
  ///
  /// In en, this message translates to:
  /// **'See public album links in app'**
  String get seePublicAlbumLinksInApp;

  /// No description provided for @emergencyContacts.
  ///
  /// In en, this message translates to:
  /// **'Emergency Contacts'**
  String get emergencyContacts;

  /// No description provided for @acceptTrustInvite.
  ///
  /// In en, this message translates to:
  /// **'Accept Invite'**
  String get acceptTrustInvite;

  /// No description provided for @declineTrustInvite.
  ///
  /// In en, this message translates to:
  /// **'Decline Invite'**
  String get declineTrustInvite;

  /// No description provided for @removeYourselfAsTrustedContact.
  ///
  /// In en, this message translates to:
  /// **'Remove yourself as trusted contact'**
  String get removeYourselfAsTrustedContact;

  /// No description provided for @legacy.
  ///
  /// In en, this message translates to:
  /// **'Legacy'**
  String get legacy;

  /// No description provided for @legacyPageDesc.
  ///
  /// In en, this message translates to:
  /// **'Legacy allows trusted contacts to access your account in your absence.'**
  String get legacyPageDesc;

  /// No description provided for @legacyPageDesc2.
  ///
  /// In en, this message translates to:
  /// **'Trusted contacts can initiate account recovery, and if not blocked within 30 days, reset your password and access your account.'**
  String get legacyPageDesc2;

  /// No description provided for @legacyAccounts.
  ///
  /// In en, this message translates to:
  /// **'Legacy accounts'**
  String get legacyAccounts;

  /// No description provided for @trustedContacts.
  ///
  /// In en, this message translates to:
  /// **'Trusted contacts'**
  String get trustedContacts;

  /// No description provided for @addTrustedContact.
  ///
  /// In en, this message translates to:
  /// **'Add Trusted Contact'**
  String get addTrustedContact;

  /// No description provided for @removeInvite.
  ///
  /// In en, this message translates to:
  /// **'Remove invite'**
  String get removeInvite;

  /// No description provided for @recoveryWarning.
  ///
  /// In en, this message translates to:
  /// **'A trusted contact is trying to access your account'**
  String get recoveryWarning;

  /// No description provided for @rejectRecovery.
  ///
  /// In en, this message translates to:
  /// **'Reject recovery'**
  String get rejectRecovery;

  /// No description provided for @recoveryInitiated.
  ///
  /// In en, this message translates to:
  /// **'Recovery initiated'**
  String get recoveryInitiated;

  /// No description provided for @recoveryInitiatedDesc.
  ///
  /// In en, this message translates to:
  /// **'You can access the account after {days} days. A notification will be sent to {email}.'**
  String recoveryInitiatedDesc({required int days, required String email});

  /// No description provided for @cancelAccountRecovery.
  ///
  /// In en, this message translates to:
  /// **'Cancel recovery'**
  String get cancelAccountRecovery;

  /// No description provided for @recoveryAccount.
  ///
  /// In en, this message translates to:
  /// **'Recover account'**
  String get recoveryAccount;

  /// No description provided for @cancelAccountRecoveryBody.
  ///
  /// In en, this message translates to:
  /// **'Are you sure you want to cancel recovery?'**
  String get cancelAccountRecoveryBody;

  /// No description provided for @startAccountRecoveryTitle.
  ///
  /// In en, this message translates to:
  /// **'Start recovery'**
  String get startAccountRecoveryTitle;

  /// No description provided for @whyAddTrustContact.
  ///
  /// In en, this message translates to:
  /// **'Trusted contact can help in recovering your data.'**
  String get whyAddTrustContact;

  /// No description provided for @recoveryReady.
  ///
  /// In en, this message translates to:
  /// **'You can now recover {email}\'s account by setting a new password.'**
  String recoveryReady({required String email});

  /// No description provided for @recoveryWarningBody.
  ///
  /// In en, this message translates to:
  /// **'{email} is trying to recover your account.'**
  String recoveryWarningBody({required Object email});

  /// No description provided for @trustedInviteBody.
  ///
  /// In en, this message translates to:
  /// **'You have been invited to be a legacy contact by {email}.'**
  String trustedInviteBody({required Object email});

  /// No description provided for @warning.
  ///
  /// In en, this message translates to:
  /// **'Warning'**
  String get warning;

  /// No description provided for @proceed.
  ///
  /// In en, this message translates to:
  /// **'Proceed'**
  String get proceed;

  /// No description provided for @confirmAddingTrustedContact.
  ///
  /// In en, this message translates to:
  /// **'You are about to add {email} as a trusted contact. They will be able to recover your account if you are absent for {numOfDays} days.'**
  String confirmAddingTrustedContact({
    required String email,
    required int numOfDays,
  });

  /// No description provided for @legacyInvite.
  ///
  /// In en, this message translates to:
  /// **'{email} has invited you to be a trusted contact'**
  String legacyInvite({required Object email});

  /// No description provided for @authToManageLegacy.
  ///
  /// In en, this message translates to:
  /// **'Please authenticate to manage your trusted contacts'**
  String get authToManageLegacy;

  /// No description provided for @hideSharedItemsFromHomeGallery.
  ///
  /// In en, this message translates to:
  /// **'Hide shared items from home gallery'**
  String get hideSharedItemsFromHomeGallery;

  /// No description provided for @swipeToSelect.
  ///
  /// In en, this message translates to:
  /// **'Swipe to select'**
  String get swipeToSelect;

  /// No description provided for @gallery.
  ///
  /// In en, this message translates to:
  /// **'Gallery'**
  String get gallery;

  /// No description provided for @joinAlbum.
  ///
  /// In en, this message translates to:
  /// **'Join album'**
  String get joinAlbum;

  /// No description provided for @joinAlbumSubtext.
  ///
  /// In en, this message translates to:
  /// **'to view and add your photos'**
  String get joinAlbumSubtext;

  /// No description provided for @joinAlbumSubtextViewer.
  ///
  /// In en, this message translates to:
  /// **'to add this to shared albums'**
  String get joinAlbumSubtextViewer;

  /// No description provided for @join.
  ///
  /// In en, this message translates to:
  /// **'Join'**
  String get join;

  /// No description provided for @linkEmail.
  ///
  /// In en, this message translates to:
  /// **'Link email'**
  String get linkEmail;

  /// No description provided for @link.
  ///
  /// In en, this message translates to:
  /// **'Link'**
  String get link;

  /// No description provided for @noEnteAccountExclamation.
  ///
  /// In en, this message translates to:
  /// **'No Ente account!'**
  String get noEnteAccountExclamation;

  /// No description provided for @orPickFromYourContacts.
  ///
  /// In en, this message translates to:
  /// **'or pick from your contacts'**
  String get orPickFromYourContacts;

  /// Shown when email doesn't have an Ente account
  ///
  /// In en, this message translates to:
  /// **'{email} does not have an Ente account.'**
  String emailDoesNotHaveEnteAccount({required String email});

  /// Title of appbar for account owner person
  ///
  /// In en, this message translates to:
  /// **'{title} (Me)'**
  String accountOwnerPersonAppbarTitle({required String title});

  /// No description provided for @reassignMe.
  ///
  /// In en, this message translates to:
  /// **'Reassign \"Me\"'**
  String get reassignMe;

  /// No description provided for @me.
  ///
  /// In en, this message translates to:
  /// **'Me'**
  String get me;

  /// Caption for the 'Link email' title. It should be a continuation of the 'Link email' title. Just like how 'Link email' + 'for faster sharing' forms a proper sentence in English, the combination of these two strings should also be a proper sentence in other languages.
  ///
  /// In en, this message translates to:
  /// **'for faster sharing'**
  String get linkEmailToContactBannerCaption;

  /// No description provided for @selectPersonToLink.
  ///
  /// In en, this message translates to:
  /// **'Select person to link'**
  String get selectPersonToLink;

  /// No description provided for @linkPersonToEmail.
  ///
  /// In en, this message translates to:
  /// **'Link person to {email}'**
  String linkPersonToEmail({required String email});

  /// Confirmation message when linking a person to an email
  ///
  /// In en, this message translates to:
  /// **'This will link {personName} to {email}'**
  String linkPersonToEmailConfirmation({
    required String personName,
    required String email,
  });

  /// No description provided for @selectYourFace.
  ///
  /// In en, this message translates to:
  /// **'Select your face'**
  String get selectYourFace;

  /// No description provided for @reassigningLoading.
  ///
  /// In en, this message translates to:
  /// **'Reassigning...'**
  String get reassigningLoading;

  /// No description provided for @reassignedToName.
  ///
  /// In en, this message translates to:
  /// **'Reassigned you to {name}'**
  String reassignedToName({required String name});

  /// No description provided for @saveChangesBeforeLeavingQuestion.
  ///
  /// In en, this message translates to:
  /// **'Save changes before leaving?'**
  String get saveChangesBeforeLeavingQuestion;

  /// No description provided for @dontSave.
  ///
  /// In en, this message translates to:
  /// **'Don\'t save'**
  String get dontSave;

  /// No description provided for @thisIsMeExclamation.
  ///
  /// In en, this message translates to:
  /// **'This is me!'**
  String get thisIsMeExclamation;

  /// No description provided for @linkPerson.
  ///
  /// In en, this message translates to:
  /// **'Link person'**
  String get linkPerson;

  /// Caption for the 'Link person' title. It should be a continuation of the 'Link person' title. Just like how 'Link person' + 'for better sharing experience' forms a proper sentence in English, the combination of these two strings should also be a proper sentence in other languages.
  ///
  /// In en, this message translates to:
  /// **'for better sharing experience'**
  String get linkPersonCaption;

  /// No description provided for @videoStreaming.
  ///
  /// In en, this message translates to:
  /// **'Streamable videos'**
  String get videoStreaming;

  /// No description provided for @processingVideos.
  ///
  /// In en, this message translates to:
  /// **'Processing videos'**
  String get processingVideos;

  /// No description provided for @streamDetails.
  ///
  /// In en, this message translates to:
  /// **'Stream details'**
  String get streamDetails;

  /// No description provided for @processing.
  ///
  /// In en, this message translates to:
  /// **'Processing'**
  String get processing;

  /// No description provided for @queued.
  ///
  /// In en, this message translates to:
  /// **'Queued'**
  String get queued;

  /// No description provided for @ineligible.
  ///
  /// In en, this message translates to:
  /// **'Ineligible'**
  String get ineligible;

  /// No description provided for @failed.
  ///
  /// In en, this message translates to:
  /// **'Failed'**
  String get failed;

  /// No description provided for @playStream.
  ///
  /// In en, this message translates to:
  /// **'Play stream'**
  String get playStream;

  /// No description provided for @playOriginal.
  ///
  /// In en, this message translates to:
  /// **'Play original'**
  String get playOriginal;

  /// No description provided for @joinAlbumConfirmationDialogBody.
  ///
  /// In en, this message translates to:
  /// **'Joining an album will make your email visible to its participants.'**
  String get joinAlbumConfirmationDialogBody;

  /// No description provided for @pleaseWaitThisWillTakeAWhile.
  ///
  /// In en, this message translates to:
  /// **'Please wait, this will take a while.'**
  String get pleaseWaitThisWillTakeAWhile;

  /// No description provided for @editTime.
  ///
  /// In en, this message translates to:
  /// **'Edit time'**
  String get editTime;

  /// No description provided for @selectTime.
  ///
  /// In en, this message translates to:
  /// **'Select time'**
  String get selectTime;

  /// No description provided for @selectDate.
  ///
  /// In en, this message translates to:
  /// **'Select date'**
  String get selectDate;

  /// No description provided for @previous.
  ///
  /// In en, this message translates to:
  /// **'Previous'**
  String get previous;

  /// No description provided for @selectOneDateAndTimeForAll.
  ///
  /// In en, this message translates to:
  /// **'Select one date and time for all'**
  String get selectOneDateAndTimeForAll;

  /// No description provided for @selectStartOfRange.
  ///
  /// In en, this message translates to:
  /// **'Select start of range'**
  String get selectStartOfRange;

  /// No description provided for @thisWillMakeTheDateAndTimeOfAllSelected.
  ///
  /// In en, this message translates to:
  /// **'This will make the date and time of all selected photos the same.'**
  String get thisWillMakeTheDateAndTimeOfAllSelected;

  /// No description provided for @allWillShiftRangeBasedOnFirst.
  ///
  /// In en, this message translates to:
  /// **'This is the first in the group. Other selected photos will automatically shift based on this new date'**
  String get allWillShiftRangeBasedOnFirst;

  /// No description provided for @newRange.
  ///
  /// In en, this message translates to:
  /// **'New range'**
  String get newRange;

  /// No description provided for @selectOneDateAndTime.
  ///
  /// In en, this message translates to:
  /// **'Select one date and time'**
  String get selectOneDateAndTime;

  /// No description provided for @moveSelectedPhotosToOneDate.
  ///
  /// In en, this message translates to:
  /// **'Move selected photos to one date'**
  String get moveSelectedPhotosToOneDate;

  /// No description provided for @shiftDatesAndTime.
  ///
  /// In en, this message translates to:
  /// **'Shift dates and time'**
  String get shiftDatesAndTime;

  /// No description provided for @photosKeepRelativeTimeDifference.
  ///
  /// In en, this message translates to:
  /// **'Photos keep relative time difference'**
  String get photosKeepRelativeTimeDifference;

  /// No description provided for @photocountPhotos.
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =0 {No photos} =1 {1 photo} other {{count} photos}}'**
  String photocountPhotos({required int count});

  /// No description provided for @appIcon.
  ///
  /// In en, this message translates to:
  /// **'App icon'**
  String get appIcon;

  /// No description provided for @notThisPerson.
  ///
  /// In en, this message translates to:
  /// **'Not this person?'**
  String get notThisPerson;

  /// No description provided for @selectedItemsWillBeRemovedFromThisPerson.
  ///
  /// In en, this message translates to:
  /// **'Selected items will be removed from this person, but not deleted from your library.'**
  String get selectedItemsWillBeRemovedFromThisPerson;

  /// No description provided for @throughTheYears.
  ///
  /// In en, this message translates to:
  /// **'{dateFormat} through the years'**
  String throughTheYears({required Object dateFormat});

  /// No description provided for @thisWeekThroughTheYears.
  ///
  /// In en, this message translates to:
  /// **'This week through the years'**
  String get thisWeekThroughTheYears;

  /// No description provided for @thisWeekXYearsAgo.
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =1 {This week, {count} year ago} other {This week, {count} years ago}}'**
  String thisWeekXYearsAgo({required num count});

  /// No description provided for @youAndThem.
  ///
  /// In en, this message translates to:
  /// **'You and {name}'**
  String youAndThem({required Object name});

  /// No description provided for @admiringThem.
  ///
  /// In en, this message translates to:
  /// **'Admiring {name}'**
  String admiringThem({required Object name});

  /// No description provided for @embracingThem.
  ///
  /// In en, this message translates to:
  /// **'Embracing {name}'**
  String embracingThem({required Object name});

  /// No description provided for @partyWithThem.
  ///
  /// In en, this message translates to:
  /// **'Party with {name}'**
  String partyWithThem({required Object name});

  /// No description provided for @hikingWithThem.
  ///
  /// In en, this message translates to:
  /// **'Hiking with {name}'**
  String hikingWithThem({required Object name});

  /// No description provided for @feastingWithThem.
  ///
  /// In en, this message translates to:
  /// **'Feasting with {name}'**
  String feastingWithThem({required Object name});

  /// No description provided for @selfiesWithThem.
  ///
  /// In en, this message translates to:
  /// **'Selfies with {name}'**
  String selfiesWithThem({required Object name});

  /// No description provided for @posingWithThem.
  ///
  /// In en, this message translates to:
  /// **'Posing with {name}'**
  String posingWithThem({required Object name});

  /// No description provided for @backgroundWithThem.
  ///
  /// In en, this message translates to:
  /// **'Beautiful views with {name}'**
  String backgroundWithThem({required Object name});

  /// No description provided for @sportsWithThem.
  ///
  /// In en, this message translates to:
  /// **'Sports with {name}'**
  String sportsWithThem({required Object name});

  /// No description provided for @roadtripWithThem.
  ///
  /// In en, this message translates to:
  /// **'Road trip with {name}'**
  String roadtripWithThem({required Object name});

  /// No description provided for @spotlightOnYourself.
  ///
  /// In en, this message translates to:
  /// **'Spotlight on yourself'**
  String get spotlightOnYourself;

  /// No description provided for @spotlightOnThem.
  ///
  /// In en, this message translates to:
  /// **'Spotlight on {name}'**
  String spotlightOnThem({required Object name});

  /// No description provided for @personIsAge.
  ///
  /// In en, this message translates to:
  /// **'{name} is {age}!'**
  String personIsAge({required Object age, required Object name});

  /// No description provided for @personTurningAge.
  ///
  /// In en, this message translates to:
  /// **'{name} turning {age} soon'**
  String personTurningAge({required Object age, required Object name});

  /// No description provided for @lastTimeWithThem.
  ///
  /// In en, this message translates to:
  /// **'Last time with {name}'**
  String lastTimeWithThem({required Object name});

  /// No description provided for @tripToLocation.
  ///
  /// In en, this message translates to:
  /// **'Trip to {location}'**
  String tripToLocation({required Object location});

  /// No description provided for @tripInYear.
  ///
  /// In en, this message translates to:
  /// **'Trip in {year}'**
  String tripInYear({required Object year});

  /// No description provided for @lastYearsTrip.
  ///
  /// In en, this message translates to:
  /// **'Last year\'s trip'**
  String get lastYearsTrip;

  /// No description provided for @sunrise.
  ///
  /// In en, this message translates to:
  /// **'On the horizon'**
  String get sunrise;

  /// No description provided for @mountains.
  ///
  /// In en, this message translates to:
  /// **'Over the hills'**
  String get mountains;

  /// No description provided for @greenery.
  ///
  /// In en, this message translates to:
  /// **'The green life'**
  String get greenery;

  /// No description provided for @beach.
  ///
  /// In en, this message translates to:
  /// **'Sand and sea'**
  String get beach;

  /// No description provided for @city.
  ///
  /// In en, this message translates to:
  /// **'In the city'**
  String get city;

  /// No description provided for @moon.
  ///
  /// In en, this message translates to:
  /// **'In the moonlight'**
  String get moon;

  /// No description provided for @onTheRoad.
  ///
  /// In en, this message translates to:
  /// **'On the road again'**
  String get onTheRoad;

  /// No description provided for @food.
  ///
  /// In en, this message translates to:
  /// **'Culinary delight'**
  String get food;

  /// No description provided for @pets.
  ///
  /// In en, this message translates to:
  /// **'Furry companions'**
  String get pets;

  /// No description provided for @curatedMemories.
  ///
  /// In en, this message translates to:
  /// **'Curated memories'**
  String get curatedMemories;

  /// No description provided for @widgets.
  ///
  /// In en, this message translates to:
  /// **'Widgets'**
  String get widgets;

  /// No description provided for @memories.
  ///
  /// In en, this message translates to:
  /// **'Memories'**
  String get memories;

  /// No description provided for @peopleWidgetDesc.
  ///
  /// In en, this message translates to:
  /// **'Select the people you wish to see on your homescreen.'**
  String get peopleWidgetDesc;

  /// No description provided for @albumsWidgetDesc.
  ///
  /// In en, this message translates to:
  /// **'Select the albums you wish to see on your homescreen.'**
  String get albumsWidgetDesc;

  /// No description provided for @memoriesWidgetDesc.
  ///
  /// In en, this message translates to:
  /// **'Select the kind of memories you wish to see on your homescreen.'**
  String get memoriesWidgetDesc;

  /// No description provided for @smartMemories.
  ///
  /// In en, this message translates to:
  /// **'Smart memories'**
  String get smartMemories;

  /// No description provided for @pastYearsMemories.
  ///
  /// In en, this message translates to:
  /// **'Past years\' memories'**
  String get pastYearsMemories;

  /// No description provided for @deleteMultipleAlbumDialog.
  ///
  /// In en, this message translates to:
  /// **'Also delete the photos (and videos) present in these {count} albums from <bold>all</bold> other albums they are part of?'**
  String deleteMultipleAlbumDialog({required Object count});

  /// No description provided for @addParticipants.
  ///
  /// In en, this message translates to:
  /// **'Add participants'**
  String get addParticipants;

  /// No description provided for @selectedAlbums.
  ///
  /// In en, this message translates to:
  /// **'{count} selected'**
  String selectedAlbums({required Object count});

  /// No description provided for @actionNotSupportedOnFavouritesAlbum.
  ///
  /// In en, this message translates to:
  /// **'Action not supported on Favourites album'**
  String get actionNotSupportedOnFavouritesAlbum;

  /// No description provided for @onThisDayMemories.
  ///
  /// In en, this message translates to:
  /// **'On this day memories'**
  String get onThisDayMemories;

  /// No description provided for @onThisDay.
  ///
  /// In en, this message translates to:
  /// **'On this day'**
  String get onThisDay;

  /// No description provided for @lookBackOnYourMemories.
  ///
  /// In en, this message translates to:
  /// **'Look back on your memories 🌄'**
  String get lookBackOnYourMemories;

  /// No description provided for @newPhotosEmoji.
  ///
  /// In en, this message translates to:
  /// **' new 📸'**
  String get newPhotosEmoji;

  /// No description provided for @sorryWeHadToPauseYourBackups.
  ///
  /// In en, this message translates to:
  /// **'Sorry, we had to pause your backups'**
  String get sorryWeHadToPauseYourBackups;

  /// No description provided for @clickToInstallOurBestVersionYet.
  ///
  /// In en, this message translates to:
  /// **'Click to install our best version yet'**
  String get clickToInstallOurBestVersionYet;

  /// No description provided for @onThisDayNotificationExplanation.
  ///
  /// In en, this message translates to:
  /// **'Receive reminders about memories from this day in previous years.'**
  String get onThisDayNotificationExplanation;

  /// No description provided for @addMemoriesWidgetPrompt.
  ///
  /// In en, this message translates to:
  /// **'Add a memories widget to your homescreen and come back here to customize.'**
  String get addMemoriesWidgetPrompt;

  /// No description provided for @addAlbumWidgetPrompt.
  ///
  /// In en, this message translates to:
  /// **'Add an album widget to your homescreen and come back here to customize.'**
  String get addAlbumWidgetPrompt;

  /// No description provided for @addPeopleWidgetPrompt.
  ///
  /// In en, this message translates to:
  /// **'Add a people widget to your homescreen and come back here to customize.'**
  String get addPeopleWidgetPrompt;

  /// No description provided for @birthdayNotifications.
  ///
  /// In en, this message translates to:
  /// **'Birthday notifications'**
  String get birthdayNotifications;

  /// No description provided for @receiveRemindersOnBirthdays.
  ///
  /// In en, this message translates to:
  /// **'Receive reminders when it\'s someone\'s birthday. Tapping on the notification will take you to photos of the birthday person.'**
  String get receiveRemindersOnBirthdays;

  /// No description provided for @happyBirthday.
  ///
  /// In en, this message translates to:
  /// **'Happy birthday! 🥳'**
  String get happyBirthday;

  /// No description provided for @birthdays.
  ///
  /// In en, this message translates to:
  /// **'Birthdays'**
  String get birthdays;

  /// No description provided for @wishThemAHappyBirthday.
  ///
  /// In en, this message translates to:
  /// **'Wish {name} a happy birthday! 🎉'**
  String wishThemAHappyBirthday({required Object name});

  /// No description provided for @areYouSureRemoveThisFaceFromPerson.
  ///
  /// In en, this message translates to:
  /// **'Are you sure you want to remove this face from this person?'**
  String get areYouSureRemoveThisFaceFromPerson;

  /// No description provided for @otherDetectedFaces.
  ///
  /// In en, this message translates to:
  /// **'Other detected faces'**
  String get otherDetectedFaces;

  /// No description provided for @areThey.
  ///
  /// In en, this message translates to:
  /// **'Are they '**
  String get areThey;

  /// No description provided for @questionmark.
  ///
  /// In en, this message translates to:
  /// **'?'**
  String get questionmark;

  /// No description provided for @saveAsAnotherPerson.
  ///
  /// In en, this message translates to:
  /// **'Save as another person'**
  String get saveAsAnotherPerson;

  /// No description provided for @showLessFaces.
  ///
  /// In en, this message translates to:
  /// **'Show less faces'**
  String get showLessFaces;

  /// No description provided for @showMoreFaces.
  ///
  /// In en, this message translates to:
  /// **'Show more faces'**
  String get showMoreFaces;

  /// No description provided for @ignore.
  ///
  /// In en, this message translates to:
  /// **'Ignore'**
  String get ignore;

  /// No description provided for @merge.
  ///
  /// In en, this message translates to:
  /// **'Merge'**
  String get merge;

  /// No description provided for @reset.
  ///
  /// In en, this message translates to:
  /// **'Reset'**
  String get reset;

  /// No description provided for @areYouSureYouWantToIgnoreThisPerson.
  ///
  /// In en, this message translates to:
  /// **'Are you sure you want to ignore this person?'**
  String get areYouSureYouWantToIgnoreThisPerson;

  /// No description provided for @areYouSureYouWantToIgnoreThesePersons.
  ///
  /// In en, this message translates to:
  /// **'Are you sure you want to ignore these persons?'**
  String get areYouSureYouWantToIgnoreThesePersons;

  /// No description provided for @thePersonGroupsWillNotBeDisplayed.
  ///
  /// In en, this message translates to:
  /// **'The person groups will not be displayed in the people section anymore. Photos will remain untouched.'**
  String get thePersonGroupsWillNotBeDisplayed;

  /// No description provided for @thePersonWillNotBeDisplayed.
  ///
  /// In en, this message translates to:
  /// **'The person will not be displayed in the people section anymore. Photos will remain untouched.'**
  String get thePersonWillNotBeDisplayed;

  /// No description provided for @areYouSureYouWantToMergeThem.
  ///
  /// In en, this message translates to:
  /// **'Are you sure you want to merge them?'**
  String get areYouSureYouWantToMergeThem;

  /// No description provided for @allUnnamedGroupsWillBeMergedIntoTheSelectedPerson.
  ///
  /// In en, this message translates to:
  /// **'All unnamed groups will be merged into the selected person. This can still be undone from the suggestions history overview of the person.'**
  String get allUnnamedGroupsWillBeMergedIntoTheSelectedPerson;

  /// No description provided for @yesIgnore.
  ///
  /// In en, this message translates to:
  /// **'Yes, ignore'**
  String get yesIgnore;

  /// No description provided for @same.
  ///
  /// In en, this message translates to:
  /// **'Same'**
  String get same;

  /// No description provided for @different.
  ///
  /// In en, this message translates to:
  /// **'Different'**
  String get different;

  /// No description provided for @sameperson.
  ///
  /// In en, this message translates to:
  /// **'Same person?'**
  String get sameperson;

  /// No description provided for @indexingPausedStatusDescription.
  ///
  /// In en, this message translates to:
  /// **'Indexing is paused. It will automatically resume when the device is ready. The device is considered ready when its battery level, battery health, and thermal status are within a healthy range.'**
  String get indexingPausedStatusDescription;

  /// No description provided for @thisWeek.
  ///
  /// In en, this message translates to:
  /// **'This week'**
  String get thisWeek;

  /// No description provided for @lastWeek.
  ///
  /// In en, this message translates to:
  /// **'Last week'**
  String get lastWeek;

  /// No description provided for @thisMonth.
  ///
  /// In en, this message translates to:
  /// **'This month'**
  String get thisMonth;

  /// No description provided for @thisYear.
  ///
  /// In en, this message translates to:
  /// **'This year'**
  String get thisYear;

  /// No description provided for @groupBy.
  ///
  /// In en, this message translates to:
  /// **'Group by'**
  String get groupBy;

  /// No description provided for @faceThumbnailGenerationFailed.
  ///
  /// In en, this message translates to:
  /// **'Unable to generate face thumbnails'**
  String get faceThumbnailGenerationFailed;

  /// No description provided for @fileAnalysisFailed.
  ///
  /// In en, this message translates to:
  /// **'Unable to analyze file'**
  String get fileAnalysisFailed;

  /// No description provided for @editAutoAddPeople.
  ///
  /// In en, this message translates to:
  /// **'Edit auto-add people'**
  String get editAutoAddPeople;

  /// No description provided for @autoAddPeople.
  ///
  /// In en, this message translates to:
  /// **'Auto-add people'**
  String get autoAddPeople;

  /// No description provided for @autoAddToAlbum.
  ///
  /// In en, this message translates to:
  /// **'Auto-add to album'**
  String get autoAddToAlbum;

  /// No description provided for @shouldRemoveFilesSmartAlbumsDesc.
  ///
  /// In en, this message translates to:
  /// **'Should the files related to the person that were previously selected in smart albums be removed?'**
  String get shouldRemoveFilesSmartAlbumsDesc;

  /// No description provided for @addingPhotos.
  ///
  /// In en, this message translates to:
  /// **'Adding photos'**
  String get addingPhotos;

  /// No description provided for @gettingReady.
  ///
  /// In en, this message translates to:
  /// **'Getting ready'**
  String get gettingReady;

  /// No description provided for @addSomePhotosDesc1.
  ///
  /// In en, this message translates to:
  /// **'Add some photos or pick '**
  String get addSomePhotosDesc1;

  /// No description provided for @addSomePhotosDesc2.
  ///
  /// In en, this message translates to:
  /// **'familiar faces'**
  String get addSomePhotosDesc2;

  /// No description provided for @addSomePhotosDesc3.
  ///
  /// In en, this message translates to:
  /// **'\nto begin with'**
  String get addSomePhotosDesc3;

  /// No description provided for @ignorePerson.
  ///
  /// In en, this message translates to:
  /// **'Ignore person'**
  String get ignorePerson;

  /// No description provided for @mixedGrouping.
  ///
  /// In en, this message translates to:
  /// **'Mixed grouping?'**
  String get mixedGrouping;

  /// No description provided for @analysis.
  ///
  /// In en, this message translates to:
  /// **'Analysis'**
  String get analysis;

  /// No description provided for @doesGroupContainMultiplePeople.
  ///
  /// In en, this message translates to:
  /// **'Does this grouping contain multiple people?'**
  String get doesGroupContainMultiplePeople;

  /// No description provided for @automaticallyAnalyzeAndSplitGrouping.
  ///
  /// In en, this message translates to:
  /// **'We will automatically analyze the grouping to determine if there are multiple people present, and separate them out again. This may take a few seconds.'**
  String get automaticallyAnalyzeAndSplitGrouping;

  /// No description provided for @layout.
  ///
  /// In en, this message translates to:
  /// **'Layout'**
  String get layout;

  /// No description provided for @day.
  ///
  /// In en, this message translates to:
  /// **'Day'**
  String get day;

  /// No description provided for @undo.
  ///
  /// In en, this message translates to:
  /// **'Undo'**
  String get undo;

  /// No description provided for @redo.
  ///
  /// In en, this message translates to:
  /// **'Redo'**
  String get redo;

  /// No description provided for @filter.
  ///
  /// In en, this message translates to:
  /// **'Filter'**
  String get filter;

  /// No description provided for @adjust.
  ///
  /// In en, this message translates to:
  /// **'Adjust'**
  String get adjust;

  /// No description provided for @draw.
  ///
  /// In en, this message translates to:
  /// **'Draw'**
  String get draw;

  /// No description provided for @sticker.
  ///
  /// In en, this message translates to:
  /// **'Sticker'**
  String get sticker;

  /// No description provided for @brushColor.
  ///
  /// In en, this message translates to:
  /// **'Brush Color'**
  String get brushColor;

  /// No description provided for @font.
  ///
  /// In en, this message translates to:
  /// **'Font'**
  String get font;

  /// No description provided for @background.
  ///
  /// In en, this message translates to:
  /// **'Background'**
  String get background;

  /// No description provided for @align.
  ///
  /// In en, this message translates to:
  /// **'Align'**
  String get align;

  /// Message shown when items are added to albums
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =1{Added successfully to 1 album} other{Added successfully to {count} albums}}'**
  String addedToAlbums({required int count});

  /// No description provided for @videosProcessed.
  ///
  /// In en, this message translates to:
  /// **'Videos processed'**
  String get videosProcessed;

  /// No description provided for @totalVideos.
  ///
  /// In en, this message translates to:
  /// **'Total videos'**
  String get totalVideos;

  /// No description provided for @skippedVideos.
  ///
  /// In en, this message translates to:
  /// **'Skipped videos'**
  String get skippedVideos;

  /// No description provided for @videoStreamingDescriptionLine1.
  ///
  /// In en, this message translates to:
  /// **'Play videos instantly on any device.'**
  String get videoStreamingDescriptionLine1;

  /// No description provided for @videoStreamingDescriptionLine2.
  ///
  /// In en, this message translates to:
  /// **'Enable to process video streams on this device.'**
  String get videoStreamingDescriptionLine2;

  /// No description provided for @videoStreamingNote.
  ///
  /// In en, this message translates to:
  /// **'Only videos from last 60 days and under 1 minute are processed on this device. For older/longer videos, enable streaming in the desktop app.'**
  String get videoStreamingNote;

  /// No description provided for @createStream.
  ///
  /// In en, this message translates to:
  /// **'Create stream'**
  String get createStream;

  /// No description provided for @recreateStream.
  ///
  /// In en, this message translates to:
  /// **'Recreate stream'**
  String get recreateStream;

  /// No description provided for @addedToStreamCreationQueue.
  ///
  /// In en, this message translates to:
  /// **'Added to stream creation queue'**
  String get addedToStreamCreationQueue;

  /// No description provided for @addedToStreamRecreationQueue.
  ///
  /// In en, this message translates to:
  /// **'Added to stream recreation queue'**
  String get addedToStreamRecreationQueue;

  /// No description provided for @videoPreviewAlreadyExists.
  ///
  /// In en, this message translates to:
  /// **'Video preview already exists'**
  String get videoPreviewAlreadyExists;

  /// No description provided for @videoAlreadyInQueue.
  ///
  /// In en, this message translates to:
  /// **'Video file already present in the queue'**
  String get videoAlreadyInQueue;

  /// No description provided for @videoExportFailed.
  ///
  /// In en, this message translates to:
  /// **'Video creation failed. Please try again.'**
  String get videoExportFailed;

  /// Toast shown when a video export completes, mentioning the filesystem path.
  ///
  /// In en, this message translates to:
  /// **'Video successfully created at {path}'**
  String videoExportSuccess({required String path});

  /// No description provided for @addedToQueue.
  ///
  /// In en, this message translates to:
  /// **'Added to queue'**
  String get addedToQueue;

  /// No description provided for @creatingStream.
  ///
  /// In en, this message translates to:
  /// **'Creating stream'**
  String get creatingStream;

  /// No description provided for @similarImages.
  ///
  /// In en, this message translates to:
  /// **'Similar images'**
  String get similarImages;

  /// No description provided for @findSimilarImages.
  ///
  /// In en, this message translates to:
  /// **'Find similar images'**
  String get findSimilarImages;

  /// No description provided for @noSimilarImagesFound.
  ///
  /// In en, this message translates to:
  /// **'No similar images found'**
  String get noSimilarImagesFound;

  /// No description provided for @yourPhotosLookUnique.
  ///
  /// In en, this message translates to:
  /// **'Your photos look unique'**
  String get yourPhotosLookUnique;

  /// No description provided for @similarGroupsFound.
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =1{{count} group found} other{{count} groups found}}'**
  String similarGroupsFound({required int count});

  /// No description provided for @reviewAndRemoveSimilarImages.
  ///
  /// In en, this message translates to:
  /// **'Review and remove similar images'**
  String get reviewAndRemoveSimilarImages;

  /// No description provided for @deletePhotosWithSize.
  ///
  /// In en, this message translates to:
  /// **'Delete {count} photos ({size})'**
  String deletePhotosWithSize({required String count, required String size});

  /// No description provided for @selectionOptions.
  ///
  /// In en, this message translates to:
  /// **'Selection options'**
  String get selectionOptions;

  /// No description provided for @selectExactWithCount.
  ///
  /// In en, this message translates to:
  /// **'Exactly similar ({count})'**
  String selectExactWithCount({required int count});

  /// No description provided for @selectExact.
  ///
  /// In en, this message translates to:
  /// **'Select exact'**
  String get selectExact;

  /// No description provided for @selectSimilarWithCount.
  ///
  /// In en, this message translates to:
  /// **'Mostly similar ({count})'**
  String selectSimilarWithCount({required int count});

  /// No description provided for @selectSimilar.
  ///
  /// In en, this message translates to:
  /// **'Select similar'**
  String get selectSimilar;

  /// No description provided for @selectAllWithCount.
  ///
  /// In en, this message translates to:
  /// **'All similarities ({count})'**
  String selectAllWithCount({required int count});

  /// No description provided for @selectSimilarImagesTitle.
  ///
  /// In en, this message translates to:
  /// **'Select similar images'**
  String get selectSimilarImagesTitle;

  /// No description provided for @chooseSimilarImagesToSelect.
  ///
  /// In en, this message translates to:
  /// **'Select images based on their visual similarity'**
  String get chooseSimilarImagesToSelect;

  /// No description provided for @clearSelection.
  ///
  /// In en, this message translates to:
  /// **'Clear selection'**
  String get clearSelection;

  /// No description provided for @similarImagesCount.
  ///
  /// In en, this message translates to:
  /// **'{count} similar images'**
  String similarImagesCount({required int count});

  /// No description provided for @deleteWithCount.
  ///
  /// In en, this message translates to:
  /// **'Delete ({count})'**
  String deleteWithCount({required int count});

  /// No description provided for @deleteFiles.
  ///
  /// In en, this message translates to:
  /// **'Delete files'**
  String get deleteFiles;

  /// No description provided for @areYouSureDeleteFiles.
  ///
  /// In en, this message translates to:
  /// **'Are you sure you want to delete these files?'**
  String get areYouSureDeleteFiles;

  /// No description provided for @greatJob.
  ///
  /// In en, this message translates to:
  /// **'Great job!'**
  String get greatJob;

  /// No description provided for @cleanedUpSimilarImages.
  ///
  /// In en, this message translates to:
  /// **'You freed up {size} of space'**
  String cleanedUpSimilarImages({required String size});

  /// No description provided for @size.
  ///
  /// In en, this message translates to:
  /// **'Size'**
  String get size;

  /// No description provided for @similarity.
  ///
  /// In en, this message translates to:
  /// **'Similarity'**
  String get similarity;

  /// No description provided for @analyzingPhotosLocally.
  ///
  /// In en, this message translates to:
  /// **'Analyzing your photos locally...'**
  String get analyzingPhotosLocally;

  /// No description provided for @lookingForVisualSimilarities.
  ///
  /// In en, this message translates to:
  /// **'Looking for visual similarities...'**
  String get lookingForVisualSimilarities;

  /// No description provided for @comparingImageDetails.
  ///
  /// In en, this message translates to:
  /// **'Comparing image details...'**
  String get comparingImageDetails;

  /// No description provided for @findingSimilarImages.
  ///
  /// In en, this message translates to:
  /// **'Finding similar images...'**
  String get findingSimilarImages;

  /// No description provided for @almostDone.
  ///
  /// In en, this message translates to:
  /// **'Almost done...'**
  String get almostDone;

  /// No description provided for @processingLocally.
  ///
  /// In en, this message translates to:
  /// **'Processing locally'**
  String get processingLocally;

  /// No description provided for @useMLToFindSimilarImages.
  ///
  /// In en, this message translates to:
  /// **'Review and remove images that look similar to each other.'**
  String get useMLToFindSimilarImages;

  /// No description provided for @all.
  ///
  /// In en, this message translates to:
  /// **'All'**
  String get all;

  /// No description provided for @similar.
  ///
  /// In en, this message translates to:
  /// **'Similar'**
  String get similar;

  /// No description provided for @identical.
  ///
  /// In en, this message translates to:
  /// **'Identical'**
  String get identical;

  /// No description provided for @nothingHereTryAnotherFilter.
  ///
  /// In en, this message translates to:
  /// **'Nothing here, try another filter! 👀'**
  String get nothingHereTryAnotherFilter;

  /// No description provided for @related.
  ///
  /// In en, this message translates to:
  /// **'Related'**
  String get related;

  /// No description provided for @hoorayyyy.
  ///
  /// In en, this message translates to:
  /// **'Hoorayyyy!'**
  String get hoorayyyy;

  /// No description provided for @nothingToTidyUpHere.
  ///
  /// In en, this message translates to:
  /// **'Nothing to tidy up here'**
  String get nothingToTidyUpHere;

  /// No description provided for @deletingDash.
  ///
  /// In en, this message translates to:
  /// **'Deleting - '**
  String get deletingDash;

  /// No description provided for @cLTitle1.
  ///
  /// In en, this message translates to:
  /// **'Jump to date'**
  String get cLTitle1;

  /// No description provided for @cLDesc1.
  ///
  /// In en, this message translates to:
  /// **'See surrounding photos for any photo by selecting the jump to date option in the file\'s info pane.'**
  String get cLDesc1;

  /// No description provided for @cLTitle2.
  ///
  /// In en, this message translates to:
  /// **'Faster video editor'**
  String get cLTitle2;

  /// No description provided for @cLDesc2.
  ///
  /// In en, this message translates to:
  /// **'Video editor was revamped to both drastically improve its speed when editing larger videos, and also improve the UX.'**
  String get cLDesc2;

  /// No description provided for @cLTitle3.
  ///
  /// In en, this message translates to:
  /// **'New memories'**
  String get cLTitle3;

  /// No description provided for @cLDesc3.
  ///
  /// In en, this message translates to:
  /// **'\"Playful kids\", \"Winter adventures\", \"Neon nights\", and more.'**
  String get cLDesc3;

  /// No description provided for @cLTitle4.
  ///
  /// In en, this message translates to:
  /// **'Landscape gallery and more'**
  String get cLTitle4;

  /// No description provided for @cLDesc4.
  ///
  /// In en, this message translates to:
  /// **'Support for landscape layout in the app\'s main gallery. Show persons without any associated photos instead of filtering them out. Improve video aspect detection when shared from external apps.'**
  String get cLDesc4;

  /// Appears in the similar images page, to indicate that the images are close in terms of appearance
  ///
  /// In en, this message translates to:
  /// **'Close'**
  String get closeBy;

  /// The message the copy should convey is that photos or videos containing the selected people's faces will be automatically added to this album
  ///
  /// In en, this message translates to:
  /// **'Automatically add photos of the selected people to this album'**
  String get peopleAutoAddDesc;

  /// No description provided for @festivities.
  ///
  /// In en, this message translates to:
  /// **'Festive cheer'**
  String get festivities;

  /// No description provided for @snowAdventures.
  ///
  /// In en, this message translates to:
  /// **'Winter adventures'**
  String get snowAdventures;

  /// No description provided for @waterfalls.
  ///
  /// In en, this message translates to:
  /// **'Chasing waterfalls'**
  String get waterfalls;

  /// No description provided for @wildlife.
  ///
  /// In en, this message translates to:
  /// **'Into the wild'**
  String get wildlife;

  /// No description provided for @flowers.
  ///
  /// In en, this message translates to:
  /// **'Blooming beauties'**
  String get flowers;

  /// No description provided for @nightLights.
  ///
  /// In en, this message translates to:
  /// **'Neon nights'**
  String get nightLights;

  /// No description provided for @architecture.
  ///
  /// In en, this message translates to:
  /// **'Design icons'**
  String get architecture;

  /// No description provided for @autumnColors.
  ///
  /// In en, this message translates to:
  /// **'Autumn splendor'**
  String get autumnColors;

  /// No description provided for @desertDreams.
  ///
  /// In en, this message translates to:
  /// **'Desert dreams'**
  String get desertDreams;

  /// No description provided for @stargazing.
  ///
  /// In en, this message translates to:
  /// **'Under the stars'**
  String get stargazing;

  /// No description provided for @lakeside.
  ///
  /// In en, this message translates to:
  /// **'Lakeside calm'**
  String get lakeside;

  /// No description provided for @rainyDays.
  ///
  /// In en, this message translates to:
  /// **'Rainy day feels'**
  String get rainyDays;

  /// No description provided for @sportsAction.
  ///
  /// In en, this message translates to:
  /// **'Game on'**
  String get sportsAction;

  /// No description provided for @streetArt.
  ///
  /// In en, this message translates to:
  /// **'Street art stories'**
  String get streetArt;

  /// No description provided for @familyMoments.
  ///
  /// In en, this message translates to:
  /// **'Family time'**
  String get familyMoments;

  /// No description provided for @fireworks.
  ///
  /// In en, this message translates to:
  /// **'Firework finale'**
  String get fireworks;

  /// No description provided for @historicSites.
  ///
  /// In en, this message translates to:
  /// **'Echoes of history'**
  String get historicSites;

  /// No description provided for @tropicalParadise.
  ///
  /// In en, this message translates to:
  /// **'Tropical escapes'**
  String get tropicalParadise;

  /// No description provided for @forestTrails.
  ///
  /// In en, this message translates to:
  /// **'Forest strolls'**
  String get forestTrails;

  /// No description provided for @citySunsets.
  ///
  /// In en, this message translates to:
  /// **'City sunset glow'**
  String get citySunsets;

  /// No description provided for @colorfulMarkets.
  ///
  /// In en, this message translates to:
  /// **'Vibrant markets'**
  String get colorfulMarkets;

  /// No description provided for @cozyCafes.
  ///
  /// In en, this message translates to:
  /// **'Cozy cafe corners'**
  String get cozyCafes;

  /// No description provided for @vintageVibes.
  ///
  /// In en, this message translates to:
  /// **'Vintage vibes'**
  String get vintageVibes;

  /// No description provided for @aerialViews.
  ///
  /// In en, this message translates to:
  /// **'Aerial perspectives'**
  String get aerialViews;

  /// No description provided for @artisticPortraits.
  ///
  /// In en, this message translates to:
  /// **'Artful portraits'**
  String get artisticPortraits;

  /// No description provided for @streetFood.
  ///
  /// In en, this message translates to:
  /// **'Street food bites'**
  String get streetFood;

  /// No description provided for @riverCruises.
  ///
  /// In en, this message translates to:
  /// **'River cruise views'**
  String get riverCruises;

  /// Title for the faces timeline suggestion banner shown on a person's page
  ///
  /// In en, this message translates to:
  /// **'Memory Lane'**
  String get facesTimelineBannerTitle;

  /// Subtitle for faces timeline banner describing the timeline for a person
  ///
  /// In en, this message translates to:
  /// **'See {name}\'s photos across the years'**
  String facesTimelineBannerSubtitle({required String name});

  /// Faces timeline page title shown in the app bar
  ///
  /// In en, this message translates to:
  /// **'Memory lane'**
  String get facesTimelineAppBarTitle;

  /// Caption for frames when birthdate is known, describing the person's age
  ///
  /// In en, this message translates to:
  /// **'{name} was {count, plural, one {{count} year old} other {{count} years old}}'**
  String facesTimelineCaptionYearsOld({
    required String name,
    required int count,
  });

  /// Caption for frames when birthdate is unknown, expressing time difference
  ///
  /// In en, this message translates to:
  /// **'{count, plural, one {# year ago} other {# years ago}}'**
  String facesTimelineCaptionYearsAgo({required int count});

  /// Message shown when the share action is not yet available
  ///
  /// In en, this message translates to:
  /// **'Video sharing coming soon'**
  String get facesTimelineShareComingSoon;

  /// Tooltip or semantics label for the previous frame control
  ///
  /// In en, this message translates to:
  /// **'Previous'**
  String get facesTimelinePlaybackPrevious;

  /// Tooltip or semantics label for the next frame control
  ///
  /// In en, this message translates to:
  /// **'Next'**
  String get facesTimelinePlaybackNext;

  /// Tooltip or semantics label for the play button
  ///
  /// In en, this message translates to:
  /// **'Play'**
  String get facesTimelinePlaybackPlay;

  /// Tooltip or semantics label for the pause button
  ///
  /// In en, this message translates to:
  /// **'Pause'**
  String get facesTimelinePlaybackPause;

  /// Fallback message when the faces timeline cannot be displayed yet
  ///
  /// In en, this message translates to:
  /// **'Faces timeline is preparing...'**
  String get facesTimelineUnavailable;

  /// No description provided for @playfulKids.
  ///
  /// In en, this message translates to:
  /// **'Playful kids'**
  String get playfulKids;

  /// No description provided for @coastalCliffs.
  ///
  /// In en, this message translates to:
  /// **'Cliffs by the sea'**
  String get coastalCliffs;

  /// No description provided for @ritualsTitle.
  ///
  /// In en, this message translates to:
  /// **'Rituals'**
  String get ritualsTitle;

  /// No description provided for @ritualAddTooltip.
  ///
  /// In en, this message translates to:
  /// **'Add ritual'**
  String get ritualAddTooltip;

  /// No description provided for @ritualActivityHeading.
  ///
  /// In en, this message translates to:
  /// **'Activity'**
  String get ritualActivityHeading;

  /// No description provided for @ritualDefaultHeatmapTitle.
  ///
  /// In en, this message translates to:
  /// **'Take a photo every day'**
  String get ritualDefaultHeatmapTitle;

  /// No description provided for @ritualUntitled.
  ///
  /// In en, this message translates to:
  /// **'Untitled ritual'**
  String get ritualUntitled;

  /// No description provided for @ritualShareUnavailable.
  ///
  /// In en, this message translates to:
  /// **'Unable to share right now. Please try again.'**
  String get ritualShareUnavailable;

  /// No description provided for @ritualNotificationMessage.
  ///
  /// In en, this message translates to:
  /// **'Take a photo now'**
  String get ritualNotificationMessage;

  /// No description provided for @ritualCameraNotFound.
  ///
  /// In en, this message translates to:
  /// **'No camera found on this device.'**
  String get ritualCameraNotFound;

  /// No description provided for @ritualCameraStartError.
  ///
  /// In en, this message translates to:
  /// **'Unable to start camera. Please check permissions.'**
  String get ritualCameraStartError;

  /// No description provided for @ritualCaptureError.
  ///
  /// In en, this message translates to:
  /// **'Unable to capture photo. Please try again.'**
  String get ritualCaptureError;

  /// No description provided for @ritualPhotoLimit.
  ///
  /// In en, this message translates to:
  /// **'You can add up to {maxPhotos, plural, one {# photo.} other {# photos.}}'**
  String ritualPhotoLimit({required int maxPhotos});

  /// No description provided for @ritualCaptureAtLeastOne.
  ///
  /// In en, this message translates to:
  /// **'Capture at least one photo first.'**
  String get ritualCaptureAtLeastOne;

  /// No description provided for @ritualAlbumMissing.
  ///
  /// In en, this message translates to:
  /// **'Ritual album missing. Edit the ritual to set an album.'**
  String get ritualAlbumMissing;

  /// No description provided for @ritualAddedToAlbum.
  ///
  /// In en, this message translates to:
  /// **'Added to album'**
  String get ritualAddedToAlbum;

  /// No description provided for @ritualAddedToAlbumWithName.
  ///
  /// In en, this message translates to:
  /// **'Added to {albumName}'**
  String ritualAddedToAlbumWithName({required String albumName});

  /// No description provided for @ritualAddToAlbumFailure.
  ///
  /// In en, this message translates to:
  /// **'Couldn\'t add photos to the album: {error}'**
  String ritualAddToAlbumFailure({required String error});

  /// No description provided for @ritualBackToList.
  ///
  /// In en, this message translates to:
  /// **'Back to rituals'**
  String get ritualBackToList;

  /// No description provided for @ritualNoPhotosYet.
  ///
  /// In en, this message translates to:
  /// **'No photos yet'**
  String get ritualNoPhotosYet;

  /// No description provided for @ritualSetAlbumToLaunchCamera.
  ///
  /// In en, this message translates to:
  /// **'Set an album for this ritual to launch the camera.'**
  String get ritualSetAlbumToLaunchCamera;

  /// No description provided for @ritualDefaultCameraTitle.
  ///
  /// In en, this message translates to:
  /// **'Take a photo'**
  String get ritualDefaultCameraTitle;

  /// No description provided for @ritualBadgeMessage7.
  ///
  /// In en, this message translates to:
  /// **'7 days down! Consistency looks good on you. Keep going!'**
  String get ritualBadgeMessage7;

  /// No description provided for @ritualBadgeMessage14.
  ///
  /// In en, this message translates to:
  /// **'14 days in! Your ritual is becoming a habit. Incredible!'**
  String get ritualBadgeMessage14;

  /// No description provided for @ritualBadgeMessage30.
  ///
  /// In en, this message translates to:
  /// **'30 days in a row! Legendary consistency. Take a bow!'**
  String get ritualBadgeMessage30;

  /// No description provided for @ritualBadgeMessageDefault.
  ///
  /// In en, this message translates to:
  /// **'You\'re on a roll!'**
  String get ritualBadgeMessageDefault;

  /// No description provided for @ritualBadgeNewTitle.
  ///
  /// In en, this message translates to:
  /// **'New achievement'**
  String get ritualBadgeNewTitle;

  /// No description provided for @ritualBadgePreparing.
  ///
  /// In en, this message translates to:
  /// **'Preparing...'**
  String get ritualBadgePreparing;

  /// No description provided for @ritualStreaksLabel.
  ///
  /// In en, this message translates to:
  /// **'Streaks'**
  String get ritualStreaksLabel;

  /// No description provided for @ritualCreateYourOwn.
  ///
  /// In en, this message translates to:
  /// **'Create your own ritual'**
  String get ritualCreateYourOwn;

  /// No description provided for @ritualGetDailyReminders.
  ///
  /// In en, this message translates to:
  /// **'Get daily reminders'**
  String get ritualGetDailyReminders;

  /// No description provided for @ritualAlbumNotSet.
  ///
  /// In en, this message translates to:
  /// **'Album not set'**
  String get ritualAlbumNotSet;

  /// No description provided for @ritualOpenCameraTooltip.
  ///
  /// In en, this message translates to:
  /// **'Open ritual camera'**
  String get ritualOpenCameraTooltip;

  /// No description provided for @ritualEditorLabel.
  ///
  /// In en, this message translates to:
  /// **'Ritual editor'**
  String get ritualEditorLabel;

  /// No description provided for @ritualNew.
  ///
  /// In en, this message translates to:
  /// **'New ritual'**
  String get ritualNew;

  /// No description provided for @ritualEdit.
  ///
  /// In en, this message translates to:
  /// **'Edit ritual'**
  String get ritualEdit;

  /// No description provided for @ritualEnterPrompt.
  ///
  /// In en, this message translates to:
  /// **'Enter your ritual'**
  String get ritualEnterPrompt;

  /// No description provided for @ritualEnterDescription.
  ///
  /// In en, this message translates to:
  /// **'Please enter a description'**
  String get ritualEnterDescription;

  /// No description provided for @ritualDayLabel.
  ///
  /// In en, this message translates to:
  /// **'Day'**
  String get ritualDayLabel;

  /// No description provided for @ritualNotificationsOffHint.
  ///
  /// In en, this message translates to:
  /// **'Notifications are off. Tap a day to turn them on.'**
  String get ritualNotificationsOffHint;

  /// No description provided for @ritualTimeLabel.
  ///
  /// In en, this message translates to:
  /// **'Time'**
  String get ritualTimeLabel;

  /// No description provided for @ritualAlbumLabel.
  ///
  /// In en, this message translates to:
  /// **'Album'**
  String get ritualAlbumLabel;

  /// No description provided for @ritualSave.
  ///
  /// In en, this message translates to:
  /// **'Save ritual'**
  String get ritualSave;

  /// No description provided for @ritualUpdate.
  ///
  /// In en, this message translates to:
  /// **'Update ritual'**
  String get ritualUpdate;

  /// No description provided for @ritualSelectAlbumTitle.
  ///
  /// In en, this message translates to:
  /// **'Select album'**
  String get ritualSelectAlbumTitle;

  /// No description provided for @ritualSearchOrCreate.
  ///
  /// In en, this message translates to:
  /// **'Search or create new'**
  String get ritualSearchOrCreate;

  /// No description provided for @ritualNoAlbumsYet.
  ///
  /// In en, this message translates to:
  /// **'No albums yet'**
  String get ritualNoAlbumsYet;

  /// No description provided for @ritualNoMatchingAlbums.
  ///
  /// In en, this message translates to:
  /// **'No matching albums'**
  String get ritualNoMatchingAlbums;

  /// No description provided for @ritualCreateAlbumWithName.
  ///
  /// In en, this message translates to:
  /// **'Create \"{albumName}\"'**
  String ritualCreateAlbumWithName({required String albumName});

  /// No description provided for @ritualCreateNew.
  ///
  /// In en, this message translates to:
  /// **'Create new'**
  String get ritualCreateNew;

  /// No description provided for @ritualAlbumSelectionPlaceholder.
  ///
  /// In en, this message translates to:
  /// **'Select album'**
  String get ritualAlbumSelectionPlaceholder;

  /// No description provided for @ritualPickEmojiTitle.
  ///
  /// In en, this message translates to:
  /// **'Pick an emoji'**
  String get ritualPickEmojiTitle;

  /// No description provided for @ritualCustomKeyboardLabel.
  ///
  /// In en, this message translates to:
  /// **'Custom (keyboard)'**
  String get ritualCustomKeyboardLabel;

  /// No description provided for @ritualEmojiKeyboardHint.
  ///
  /// In en, this message translates to:
  /// **'Press to open emoji keyboard'**
  String get ritualEmojiKeyboardHint;

  /// No description provided for @ritualEmojiUseAction.
  ///
  /// In en, this message translates to:
  /// **'Use'**
  String get ritualEmojiUseAction;

  /// No description provided for @ritualSearchEmpty.
  ///
  /// In en, this message translates to:
  /// **'Build a ritual to keep your photo habit going.'**
  String get ritualSearchEmpty;
}

class _AppLocalizationsDelegate
    extends LocalizationsDelegate<AppLocalizations> {
  const _AppLocalizationsDelegate();

  @override
  Future<AppLocalizations> load(Locale locale) {
    return SynchronousFuture<AppLocalizations>(lookupAppLocalizations(locale));
  }

  @override
  bool isSupported(Locale locale) => <String>[
    'af',
    'ar',
    'be',
    'bg',
    'ca',
    'cs',
    'da',
    'de',
    'el',
    'en',
    'es',
    'et',
    'eu',
    'fa',
    'fr',
    'gu',
    'he',
    'hi',
    'hu',
    'id',
    'it',
    'ja',
    'km',
    'ko',
    'ku',
    'lt',
    'lv',
    'ml',
    'ms',
    'nl',
    'nn',
    'no',
    'or',
    'pl',
    'pt',
    'ro',
    'ru',
    'sk',
    'sl',
    'sr',
    'sv',
    'ta',
    'te',
    'th',
    'ti',
    'tr',
    'uk',
    'vi',
    'zh',
  ].contains(locale.languageCode);

  @override
  bool shouldReload(_AppLocalizationsDelegate old) => false;
}

AppLocalizations lookupAppLocalizations(Locale locale) {
  // Lookup logic when language+country codes are specified.
  switch (locale.languageCode) {
    case 'pt':
      {
        switch (locale.countryCode) {
          case 'BR':
            return AppLocalizationsPtBr();
          case 'PT':
            return AppLocalizationsPtPt();
        }
        break;
      }
  }

  // Lookup logic when only language code is specified.
  switch (locale.languageCode) {
    case 'af':
      return AppLocalizationsAf();
    case 'ar':
      return AppLocalizationsAr();
    case 'be':
      return AppLocalizationsBe();
    case 'bg':
      return AppLocalizationsBg();
    case 'ca':
      return AppLocalizationsCa();
    case 'cs':
      return AppLocalizationsCs();
    case 'da':
      return AppLocalizationsDa();
    case 'de':
      return AppLocalizationsDe();
    case 'el':
      return AppLocalizationsEl();
    case 'en':
      return AppLocalizationsEn();
    case 'es':
      return AppLocalizationsEs();
    case 'et':
      return AppLocalizationsEt();
    case 'eu':
      return AppLocalizationsEu();
    case 'fa':
      return AppLocalizationsFa();
    case 'fr':
      return AppLocalizationsFr();
    case 'gu':
      return AppLocalizationsGu();
    case 'he':
      return AppLocalizationsHe();
    case 'hi':
      return AppLocalizationsHi();
    case 'hu':
      return AppLocalizationsHu();
    case 'id':
      return AppLocalizationsId();
    case 'it':
      return AppLocalizationsIt();
    case 'ja':
      return AppLocalizationsJa();
    case 'km':
      return AppLocalizationsKm();
    case 'ko':
      return AppLocalizationsKo();
    case 'ku':
      return AppLocalizationsKu();
    case 'lt':
      return AppLocalizationsLt();
    case 'lv':
      return AppLocalizationsLv();
    case 'ml':
      return AppLocalizationsMl();
    case 'ms':
      return AppLocalizationsMs();
    case 'nl':
      return AppLocalizationsNl();
    case 'nn':
      return AppLocalizationsNn();
    case 'no':
      return AppLocalizationsNo();
    case 'or':
      return AppLocalizationsOr();
    case 'pl':
      return AppLocalizationsPl();
    case 'pt':
      return AppLocalizationsPt();
    case 'ro':
      return AppLocalizationsRo();
    case 'ru':
      return AppLocalizationsRu();
    case 'sk':
      return AppLocalizationsSk();
    case 'sl':
      return AppLocalizationsSl();
    case 'sr':
      return AppLocalizationsSr();
    case 'sv':
      return AppLocalizationsSv();
    case 'ta':
      return AppLocalizationsTa();
    case 'te':
      return AppLocalizationsTe();
    case 'th':
      return AppLocalizationsTh();
    case 'ti':
      return AppLocalizationsTi();
    case 'tr':
      return AppLocalizationsTr();
    case 'uk':
      return AppLocalizationsUk();
    case 'vi':
      return AppLocalizationsVi();
    case 'zh':
      return AppLocalizationsZh();
  }

  throw FlutterError(
    'AppLocalizations.delegate failed to load unsupported locale "$locale". This is likely '
    'an issue with the localizations generation tool. Please file an issue '
    'on GitHub with a reproducible sample app and the gen-l10n configuration '
    'that was used.',
  );
}
