// // Copyright 2024 The Flutter Workmanager Authors. All rights reserved.
// // Use of this source code is governed by a MIT-style license that can be
// // found in the LICENSE file.
// Autogenerated from Pigeon (v26.0.1), do not edit directly.
// See also: https://pub.dev/packages/pigeon

import Foundation

#if os(iOS)
  import Flutter
#elseif os(macOS)
  import FlutterMacOS
#else
  #error("Unsupported platform.")
#endif

/// Error class for passing custom error details to Dart side.
final class PigeonError: Error {
  let code: String
  let message: String?
  let details: Sendable?

  init(code: String, message: String?, details: Sendable?) {
    self.code = code
    self.message = message
    self.details = details
  }

  var localizedDescription: String {
    return
      "PigeonError(code: \(code), message: \(message ?? "<nil>"), details: \(details ?? "<nil>")"
  }
}

private func wrapResult(_ result: Any?) -> [Any?] {
  return [result]
}

private func wrapError(_ error: Any) -> [Any?] {
  if let pigeonError = error as? PigeonError {
    return [
      pigeonError.code,
      pigeonError.message,
      pigeonError.details,
    ]
  }
  if let flutterError = error as? FlutterError {
    return [
      flutterError.code,
      flutterError.message,
      flutterError.details,
    ]
  }
  return [
    "\(error)",
    "\(type(of: error))",
    "Stacktrace: \(Thread.callStackSymbols)",
  ]
}

private func createConnectionError(withChannelName channelName: String) -> PigeonError {
  return PigeonError(code: "channel-error", message: "Unable to establish connection on channel: '\(channelName)'.", details: "")
}

private func isNullish(_ value: Any?) -> Bool {
  return value is NSNull || value == nil
}

private func nilOrValue<T>(_ value: Any?) -> T? {
  if value is NSNull { return nil }
  return value as! T?
}

func deepEqualsWorkmanagerApi(_ lhs: Any?, _ rhs: Any?) -> Bool {
  let cleanLhs = nilOrValue(lhs) as Any?
  let cleanRhs = nilOrValue(rhs) as Any?
  switch (cleanLhs, cleanRhs) {
  case (nil, nil):
    return true

  case (nil, _), (_, nil):
    return false

  case is (Void, Void):
    return true

  case let (cleanLhsHashable, cleanRhsHashable) as (AnyHashable, AnyHashable):
    return cleanLhsHashable == cleanRhsHashable

  case let (cleanLhsArray, cleanRhsArray) as ([Any?], [Any?]):
    guard cleanLhsArray.count == cleanRhsArray.count else { return false }
    for (index, element) in cleanLhsArray.enumerated() {
      if !deepEqualsWorkmanagerApi(element, cleanRhsArray[index]) {
        return false
      }
    }
    return true

  case let (cleanLhsDictionary, cleanRhsDictionary) as ([AnyHashable: Any?], [AnyHashable: Any?]):
    guard cleanLhsDictionary.count == cleanRhsDictionary.count else { return false }
    for (key, cleanLhsValue) in cleanLhsDictionary {
      guard cleanRhsDictionary.index(forKey: key) != nil else { return false }
      if !deepEqualsWorkmanagerApi(cleanLhsValue, cleanRhsDictionary[key]!) {
        return false
      }
    }
    return true

  default:
    // Any other type shouldn't be able to be used with pigeon. File an issue if you find this to be untrue.
    return false
  }
}

func deepHashWorkmanagerApi(value: Any?, hasher: inout Hasher) {
  if let valueList = value as? [AnyHashable] {
     for item in valueList { deepHashWorkmanagerApi(value: item, hasher: &hasher) }
     return
  }

  if let valueDict = value as? [AnyHashable: AnyHashable] {
    for key in valueDict.keys { 
      hasher.combine(key)
      deepHashWorkmanagerApi(value: valueDict[key]!, hasher: &hasher)
    }
    return
  }

  if let hashableValue = value as? AnyHashable {
    hasher.combine(hashableValue.hashValue)
  }

  return hasher.combine(String(describing: value))
}

    

/// Task status for debugging and monitoring.
enum TaskStatus: Int {
  /// Task has been scheduled
  case scheduled = 0
  /// Task has started execution
  case started = 1
  /// Task completed successfully
  case completed = 2
  /// Task failed
  case failed = 3
  /// Task was cancelled
  case cancelled = 4
  /// Task is being retried
  case retrying = 5
  /// Task was rescheduled for later execution
  case rescheduled = 6
}

/// An enumeration of various network types that can be used as Constraints for work.
///
/// Fully supported on Android.
///
/// On iOS, this enumeration is used to define whether a piece of work requires
/// internet connectivity, by checking for either [NetworkType.connected] or
/// [NetworkType.metered].
enum NetworkType: Int {
  /// Any working network connection is required for this work.
  case connected = 0
  /// A metered network connection is required for this work.
  case metered = 1
  /// Default value. A network is not required for this work.
  case notRequired = 2
  /// A non-roaming network connection is required for this work.
  case notRoaming = 3
  /// An unmetered network connection is required for this work.
  case unmetered = 4
  /// A temporarily unmetered Network. This capability will be set for
  /// networks that are generally metered, but are currently unmetered.
  ///
  /// Android API 30+
  case temporarilyUnmetered = 5
}

/// An enumeration of backoff policies when retrying work.
/// These policies are used when you have a return ListenableWorker.Result.retry() from a worker to determine the correct backoff time.
/// Backoff policies are set in WorkRequest.Builder.setBackoffCriteria(BackoffPolicy, long, TimeUnit) or one of its variants.
enum BackoffPolicy: Int {
  /// Used to indicate that WorkManager should increase the backoff time exponentially
  case exponential = 0
  /// Used to indicate that WorkManager should increase the backoff time linearly
  case linear = 1
}

/// An enumeration of the conflict resolution policies when registering one-off work with the same unique name.
///
/// This policy determines what happens when you register a one-off task with a unique name that already exists.
///
/// See: https://developer.android.com/reference/androidx/work/ExistingWorkPolicy
enum ExistingWorkPolicy: Int {
  /// If there is existing pending (uncompleted) work with the same unique name, append the newly-specified work as a child of all the leaves of that work sequence.
  case append = 0
  /// If there is existing pending (uncompleted) work with the same unique name, do nothing.
  /// The new work request is ignored and the existing work continues unchanged.
  case keep = 1
  /// If there is existing pending (uncompleted) work with the same unique name, cancel and delete it.
  /// The new work request replaces the existing one entirely.
  case replace = 2
  /// If there is existing pending (uncompleted) work with the same unique name, it will be updated with the new specification.
  /// Note: This maps to appendOrReplace in the native implementation.
  case update = 3
}

/// An enumeration of the conflict resolution policies when registering periodic work with the same unique name.
///
/// This policy determines what happens when you register a periodic task with a unique name that already exists.
/// This is especially important during development when you might register the same task multiple times
/// with different frequencies or configurations.
///
/// See: https://developer.android.com/reference/androidx/work/ExistingPeriodicWorkPolicy
enum ExistingPeriodicWorkPolicy: Int {
  /// If there is existing pending (uncompleted) work with the same unique name, do nothing.
  /// The new work request is ignored and the existing work continues unchanged.
  ///
  /// **Warning**: If you previously registered a periodic task with a short frequency
  /// (e.g., 15 minutes) and later register the same task with a longer frequency (e.g., 2 hours),
  /// the task will continue running at the original short frequency. This can cause confusion
  /// during development. Consider using [update] instead.
  case keep = 0
  /// If there is existing pending (uncompleted) work with the same unique name, cancel and delete it.
  /// The new work request replaces the existing one entirely.
  ///
  /// **Deprecated**: Android recommends using [update] instead for less disruptive updates.
  case replace = 1
  /// If there is existing pending (uncompleted) work with the same unique name, it will be updated with the new specification.
  ///
  /// **Recommended** - updates existing work without canceling running workers and preserves original timing.
  /// This is the default policy for periodic tasks to prevent frequency confusion.
  ///
  /// Available since WorkManager 2.8.0.
  case update = 2
}

/// An enumeration of policies that help determine out of quota behavior for expedited jobs.
///
/// Only supported on Android.
enum OutOfQuotaPolicy: Int {
  /// When the app does not have any expedited job quota, the expedited work request will
  /// fallback to a regular work request.
  case runAsNonExpeditedWorkRequest = 0
  /// When the app does not have any expedited job quota, the expedited work request will
  /// we dropped and no work requests are enqueued.
  case dropWorkRequest = 1
}

/// Generated class from Pigeon that represents data sent in messages.
struct Constraints: Hashable {
  var networkType: NetworkType? = nil
  var requiresBatteryNotLow: Bool? = nil
  var requiresCharging: Bool? = nil
  var requiresDeviceIdle: Bool? = nil
  var requiresStorageNotLow: Bool? = nil


  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> Constraints? {
    let networkType: NetworkType? = nilOrValue(pigeonVar_list[0])
    let requiresBatteryNotLow: Bool? = nilOrValue(pigeonVar_list[1])
    let requiresCharging: Bool? = nilOrValue(pigeonVar_list[2])
    let requiresDeviceIdle: Bool? = nilOrValue(pigeonVar_list[3])
    let requiresStorageNotLow: Bool? = nilOrValue(pigeonVar_list[4])

    return Constraints(
      networkType: networkType,
      requiresBatteryNotLow: requiresBatteryNotLow,
      requiresCharging: requiresCharging,
      requiresDeviceIdle: requiresDeviceIdle,
      requiresStorageNotLow: requiresStorageNotLow
    )
  }
  func toList() -> [Any?] {
    return [
      networkType,
      requiresBatteryNotLow,
      requiresCharging,
      requiresDeviceIdle,
      requiresStorageNotLow,
    ]
  }
  static func == (lhs: Constraints, rhs: Constraints) -> Bool {
    return deepEqualsWorkmanagerApi(lhs.toList(), rhs.toList())  }
  func hash(into hasher: inout Hasher) {
    deepHashWorkmanagerApi(value: toList(), hasher: &hasher)
  }
}

/// Generated class from Pigeon that represents data sent in messages.
struct BackoffPolicyConfig: Hashable {
  var backoffPolicy: BackoffPolicy? = nil
  var backoffDelayMillis: Int64? = nil


  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> BackoffPolicyConfig? {
    let backoffPolicy: BackoffPolicy? = nilOrValue(pigeonVar_list[0])
    let backoffDelayMillis: Int64? = nilOrValue(pigeonVar_list[1])

    return BackoffPolicyConfig(
      backoffPolicy: backoffPolicy,
      backoffDelayMillis: backoffDelayMillis
    )
  }
  func toList() -> [Any?] {
    return [
      backoffPolicy,
      backoffDelayMillis,
    ]
  }
  static func == (lhs: BackoffPolicyConfig, rhs: BackoffPolicyConfig) -> Bool {
    return deepEqualsWorkmanagerApi(lhs.toList(), rhs.toList())  }
  func hash(into hasher: inout Hasher) {
    deepHashWorkmanagerApi(value: toList(), hasher: &hasher)
  }
}

/// Generated class from Pigeon that represents data sent in messages.
struct InitializeRequest: Hashable {
  var callbackHandle: Int64


  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> InitializeRequest? {
    let callbackHandle = pigeonVar_list[0] as! Int64

    return InitializeRequest(
      callbackHandle: callbackHandle
    )
  }
  func toList() -> [Any?] {
    return [
      callbackHandle
    ]
  }
  static func == (lhs: InitializeRequest, rhs: InitializeRequest) -> Bool {
    return deepEqualsWorkmanagerApi(lhs.toList(), rhs.toList())  }
  func hash(into hasher: inout Hasher) {
    deepHashWorkmanagerApi(value: toList(), hasher: &hasher)
  }
}

/// Generated class from Pigeon that represents data sent in messages.
struct OneOffTaskRequest: Hashable {
  var uniqueName: String
  var taskName: String
  var inputData: [String?: Any?]? = nil
  var initialDelaySeconds: Int64? = nil
  var constraints: Constraints? = nil
  var backoffPolicy: BackoffPolicyConfig? = nil
  var tag: String? = nil
  var existingWorkPolicy: ExistingWorkPolicy? = nil
  var outOfQuotaPolicy: OutOfQuotaPolicy? = nil


  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> OneOffTaskRequest? {
    let uniqueName = pigeonVar_list[0] as! String
    let taskName = pigeonVar_list[1] as! String
    let inputData: [String?: Any?]? = nilOrValue(pigeonVar_list[2])
    let initialDelaySeconds: Int64? = nilOrValue(pigeonVar_list[3])
    let constraints: Constraints? = nilOrValue(pigeonVar_list[4])
    let backoffPolicy: BackoffPolicyConfig? = nilOrValue(pigeonVar_list[5])
    let tag: String? = nilOrValue(pigeonVar_list[6])
    let existingWorkPolicy: ExistingWorkPolicy? = nilOrValue(pigeonVar_list[7])
    let outOfQuotaPolicy: OutOfQuotaPolicy? = nilOrValue(pigeonVar_list[8])

    return OneOffTaskRequest(
      uniqueName: uniqueName,
      taskName: taskName,
      inputData: inputData,
      initialDelaySeconds: initialDelaySeconds,
      constraints: constraints,
      backoffPolicy: backoffPolicy,
      tag: tag,
      existingWorkPolicy: existingWorkPolicy,
      outOfQuotaPolicy: outOfQuotaPolicy
    )
  }
  func toList() -> [Any?] {
    return [
      uniqueName,
      taskName,
      inputData,
      initialDelaySeconds,
      constraints,
      backoffPolicy,
      tag,
      existingWorkPolicy,
      outOfQuotaPolicy,
    ]
  }
  static func == (lhs: OneOffTaskRequest, rhs: OneOffTaskRequest) -> Bool {
    return deepEqualsWorkmanagerApi(lhs.toList(), rhs.toList())  }
  func hash(into hasher: inout Hasher) {
    deepHashWorkmanagerApi(value: toList(), hasher: &hasher)
  }
}

/// Generated class from Pigeon that represents data sent in messages.
struct PeriodicTaskRequest: Hashable {
  var uniqueName: String
  var taskName: String
  var frequencySeconds: Int64
  var flexIntervalSeconds: Int64? = nil
  var inputData: [String?: Any?]? = nil
  var initialDelaySeconds: Int64? = nil
  var constraints: Constraints? = nil
  var backoffPolicy: BackoffPolicyConfig? = nil
  var tag: String? = nil
  var existingWorkPolicy: ExistingPeriodicWorkPolicy? = nil


  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> PeriodicTaskRequest? {
    let uniqueName = pigeonVar_list[0] as! String
    let taskName = pigeonVar_list[1] as! String
    let frequencySeconds = pigeonVar_list[2] as! Int64
    let flexIntervalSeconds: Int64? = nilOrValue(pigeonVar_list[3])
    let inputData: [String?: Any?]? = nilOrValue(pigeonVar_list[4])
    let initialDelaySeconds: Int64? = nilOrValue(pigeonVar_list[5])
    let constraints: Constraints? = nilOrValue(pigeonVar_list[6])
    let backoffPolicy: BackoffPolicyConfig? = nilOrValue(pigeonVar_list[7])
    let tag: String? = nilOrValue(pigeonVar_list[8])
    let existingWorkPolicy: ExistingPeriodicWorkPolicy? = nilOrValue(pigeonVar_list[9])

    return PeriodicTaskRequest(
      uniqueName: uniqueName,
      taskName: taskName,
      frequencySeconds: frequencySeconds,
      flexIntervalSeconds: flexIntervalSeconds,
      inputData: inputData,
      initialDelaySeconds: initialDelaySeconds,
      constraints: constraints,
      backoffPolicy: backoffPolicy,
      tag: tag,
      existingWorkPolicy: existingWorkPolicy
    )
  }
  func toList() -> [Any?] {
    return [
      uniqueName,
      taskName,
      frequencySeconds,
      flexIntervalSeconds,
      inputData,
      initialDelaySeconds,
      constraints,
      backoffPolicy,
      tag,
      existingWorkPolicy,
    ]
  }
  static func == (lhs: PeriodicTaskRequest, rhs: PeriodicTaskRequest) -> Bool {
    return deepEqualsWorkmanagerApi(lhs.toList(), rhs.toList())  }
  func hash(into hasher: inout Hasher) {
    deepHashWorkmanagerApi(value: toList(), hasher: &hasher)
  }
}

/// Generated class from Pigeon that represents data sent in messages.
struct ProcessingTaskRequest: Hashable {
  var uniqueName: String
  var taskName: String
  var inputData: [String?: Any?]? = nil
  var initialDelaySeconds: Int64? = nil
  var networkType: NetworkType? = nil
  var requiresCharging: Bool? = nil


  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> ProcessingTaskRequest? {
    let uniqueName = pigeonVar_list[0] as! String
    let taskName = pigeonVar_list[1] as! String
    let inputData: [String?: Any?]? = nilOrValue(pigeonVar_list[2])
    let initialDelaySeconds: Int64? = nilOrValue(pigeonVar_list[3])
    let networkType: NetworkType? = nilOrValue(pigeonVar_list[4])
    let requiresCharging: Bool? = nilOrValue(pigeonVar_list[5])

    return ProcessingTaskRequest(
      uniqueName: uniqueName,
      taskName: taskName,
      inputData: inputData,
      initialDelaySeconds: initialDelaySeconds,
      networkType: networkType,
      requiresCharging: requiresCharging
    )
  }
  func toList() -> [Any?] {
    return [
      uniqueName,
      taskName,
      inputData,
      initialDelaySeconds,
      networkType,
      requiresCharging,
    ]
  }
  static func == (lhs: ProcessingTaskRequest, rhs: ProcessingTaskRequest) -> Bool {
    return deepEqualsWorkmanagerApi(lhs.toList(), rhs.toList())  }
  func hash(into hasher: inout Hasher) {
    deepHashWorkmanagerApi(value: toList(), hasher: &hasher)
  }
}

private class WorkmanagerApiPigeonCodecReader: FlutterStandardReader {
  override func readValue(ofType type: UInt8) -> Any? {
    switch type {
    case 129:
      let enumResultAsInt: Int? = nilOrValue(self.readValue() as! Int?)
      if let enumResultAsInt = enumResultAsInt {
        return TaskStatus(rawValue: enumResultAsInt)
      }
      return nil
    case 130:
      let enumResultAsInt: Int? = nilOrValue(self.readValue() as! Int?)
      if let enumResultAsInt = enumResultAsInt {
        return NetworkType(rawValue: enumResultAsInt)
      }
      return nil
    case 131:
      let enumResultAsInt: Int? = nilOrValue(self.readValue() as! Int?)
      if let enumResultAsInt = enumResultAsInt {
        return BackoffPolicy(rawValue: enumResultAsInt)
      }
      return nil
    case 132:
      let enumResultAsInt: Int? = nilOrValue(self.readValue() as! Int?)
      if let enumResultAsInt = enumResultAsInt {
        return ExistingWorkPolicy(rawValue: enumResultAsInt)
      }
      return nil
    case 133:
      let enumResultAsInt: Int? = nilOrValue(self.readValue() as! Int?)
      if let enumResultAsInt = enumResultAsInt {
        return ExistingPeriodicWorkPolicy(rawValue: enumResultAsInt)
      }
      return nil
    case 134:
      let enumResultAsInt: Int? = nilOrValue(self.readValue() as! Int?)
      if let enumResultAsInt = enumResultAsInt {
        return OutOfQuotaPolicy(rawValue: enumResultAsInt)
      }
      return nil
    case 135:
      return Constraints.fromList(self.readValue() as! [Any?])
    case 136:
      return BackoffPolicyConfig.fromList(self.readValue() as! [Any?])
    case 137:
      return InitializeRequest.fromList(self.readValue() as! [Any?])
    case 138:
      return OneOffTaskRequest.fromList(self.readValue() as! [Any?])
    case 139:
      return PeriodicTaskRequest.fromList(self.readValue() as! [Any?])
    case 140:
      return ProcessingTaskRequest.fromList(self.readValue() as! [Any?])
    default:
      return super.readValue(ofType: type)
    }
  }
}

private class WorkmanagerApiPigeonCodecWriter: FlutterStandardWriter {
  override func writeValue(_ value: Any) {
    if let value = value as? TaskStatus {
      super.writeByte(129)
      super.writeValue(value.rawValue)
    } else if let value = value as? NetworkType {
      super.writeByte(130)
      super.writeValue(value.rawValue)
    } else if let value = value as? BackoffPolicy {
      super.writeByte(131)
      super.writeValue(value.rawValue)
    } else if let value = value as? ExistingWorkPolicy {
      super.writeByte(132)
      super.writeValue(value.rawValue)
    } else if let value = value as? ExistingPeriodicWorkPolicy {
      super.writeByte(133)
      super.writeValue(value.rawValue)
    } else if let value = value as? OutOfQuotaPolicy {
      super.writeByte(134)
      super.writeValue(value.rawValue)
    } else if let value = value as? Constraints {
      super.writeByte(135)
      super.writeValue(value.toList())
    } else if let value = value as? BackoffPolicyConfig {
      super.writeByte(136)
      super.writeValue(value.toList())
    } else if let value = value as? InitializeRequest {
      super.writeByte(137)
      super.writeValue(value.toList())
    } else if let value = value as? OneOffTaskRequest {
      super.writeByte(138)
      super.writeValue(value.toList())
    } else if let value = value as? PeriodicTaskRequest {
      super.writeByte(139)
      super.writeValue(value.toList())
    } else if let value = value as? ProcessingTaskRequest {
      super.writeByte(140)
      super.writeValue(value.toList())
    } else {
      super.writeValue(value)
    }
  }
}

private class WorkmanagerApiPigeonCodecReaderWriter: FlutterStandardReaderWriter {
  override func reader(with data: Data) -> FlutterStandardReader {
    return WorkmanagerApiPigeonCodecReader(data: data)
  }

  override func writer(with data: NSMutableData) -> FlutterStandardWriter {
    return WorkmanagerApiPigeonCodecWriter(data: data)
  }
}

class WorkmanagerApiPigeonCodec: FlutterStandardMessageCodec, @unchecked Sendable {
  static let shared = WorkmanagerApiPigeonCodec(readerWriter: WorkmanagerApiPigeonCodecReaderWriter())
}


/// Generated protocol from Pigeon that represents a handler of messages from Flutter.
protocol WorkmanagerHostApi {
  func initialize(request: InitializeRequest, completion: @escaping (Result<Void, Error>) -> Void)
  func registerOneOffTask(request: OneOffTaskRequest, completion: @escaping (Result<Void, Error>) -> Void)
  func registerPeriodicTask(request: PeriodicTaskRequest, completion: @escaping (Result<Void, Error>) -> Void)
  func registerProcessingTask(request: ProcessingTaskRequest, completion: @escaping (Result<Void, Error>) -> Void)
  func cancelByUniqueName(uniqueName: String, completion: @escaping (Result<Void, Error>) -> Void)
  func cancelByTag(tag: String, completion: @escaping (Result<Void, Error>) -> Void)
  func cancelAll(completion: @escaping (Result<Void, Error>) -> Void)
  func isScheduledByUniqueName(uniqueName: String, completion: @escaping (Result<Bool, Error>) -> Void)
  func printScheduledTasks(completion: @escaping (Result<String, Error>) -> Void)
}

/// Generated setup class from Pigeon to handle messages through the `binaryMessenger`.
class WorkmanagerHostApiSetup {
  static var codec: FlutterStandardMessageCodec { WorkmanagerApiPigeonCodec.shared }
  /// Sets up an instance of `WorkmanagerHostApi` to handle messages through the `binaryMessenger`.
  static func setUp(binaryMessenger: FlutterBinaryMessenger, api: WorkmanagerHostApi?, messageChannelSuffix: String = "") {
    let channelSuffix = messageChannelSuffix.count > 0 ? ".\(messageChannelSuffix)" : ""
    let initializeChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerHostApi.initialize\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      initializeChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let requestArg = args[0] as! InitializeRequest
        api.initialize(request: requestArg) { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      initializeChannel.setMessageHandler(nil)
    }
    let registerOneOffTaskChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerHostApi.registerOneOffTask\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      registerOneOffTaskChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let requestArg = args[0] as! OneOffTaskRequest
        api.registerOneOffTask(request: requestArg) { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      registerOneOffTaskChannel.setMessageHandler(nil)
    }
    let registerPeriodicTaskChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerHostApi.registerPeriodicTask\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      registerPeriodicTaskChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let requestArg = args[0] as! PeriodicTaskRequest
        api.registerPeriodicTask(request: requestArg) { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      registerPeriodicTaskChannel.setMessageHandler(nil)
    }
    let registerProcessingTaskChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerHostApi.registerProcessingTask\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      registerProcessingTaskChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let requestArg = args[0] as! ProcessingTaskRequest
        api.registerProcessingTask(request: requestArg) { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      registerProcessingTaskChannel.setMessageHandler(nil)
    }
    let cancelByUniqueNameChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerHostApi.cancelByUniqueName\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      cancelByUniqueNameChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let uniqueNameArg = args[0] as! String
        api.cancelByUniqueName(uniqueName: uniqueNameArg) { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      cancelByUniqueNameChannel.setMessageHandler(nil)
    }
    let cancelByTagChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerHostApi.cancelByTag\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      cancelByTagChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let tagArg = args[0] as! String
        api.cancelByTag(tag: tagArg) { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      cancelByTagChannel.setMessageHandler(nil)
    }
    let cancelAllChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerHostApi.cancelAll\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      cancelAllChannel.setMessageHandler { _, reply in
        api.cancelAll { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      cancelAllChannel.setMessageHandler(nil)
    }
    let isScheduledByUniqueNameChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerHostApi.isScheduledByUniqueName\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      isScheduledByUniqueNameChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let uniqueNameArg = args[0] as! String
        api.isScheduledByUniqueName(uniqueName: uniqueNameArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      isScheduledByUniqueNameChannel.setMessageHandler(nil)
    }
    let printScheduledTasksChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerHostApi.printScheduledTasks\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      printScheduledTasksChannel.setMessageHandler { _, reply in
        api.printScheduledTasks { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      printScheduledTasksChannel.setMessageHandler(nil)
    }
  }
}
/// Generated protocol from Pigeon that represents Flutter messages that can be called from Swift.
protocol WorkmanagerFlutterApiProtocol {
  func backgroundChannelInitialized(completion: @escaping (Result<Void, PigeonError>) -> Void)
  func executeTask(taskName taskNameArg: String, inputData inputDataArg: [String?: Any?]?, completion: @escaping (Result<Bool, PigeonError>) -> Void)
}
class WorkmanagerFlutterApi: WorkmanagerFlutterApiProtocol {
  private let binaryMessenger: FlutterBinaryMessenger
  private let messageChannelSuffix: String
  init(binaryMessenger: FlutterBinaryMessenger, messageChannelSuffix: String = "") {
    self.binaryMessenger = binaryMessenger
    self.messageChannelSuffix = messageChannelSuffix.count > 0 ? ".\(messageChannelSuffix)" : ""
  }
  var codec: WorkmanagerApiPigeonCodec {
    return WorkmanagerApiPigeonCodec.shared
  }
  func backgroundChannelInitialized(completion: @escaping (Result<Void, PigeonError>) -> Void) {
    let channelName: String = "dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerFlutterApi.backgroundChannelInitialized\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage(nil) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else {
        completion(.success(()))
      }
    }
  }
  func executeTask(taskName taskNameArg: String, inputData inputDataArg: [String?: Any?]?, completion: @escaping (Result<Bool, PigeonError>) -> Void) {
    let channelName: String = "dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerFlutterApi.executeTask\(messageChannelSuffix)"
    let channel = FlutterBasicMessageChannel(name: channelName, binaryMessenger: binaryMessenger, codec: codec)
    channel.sendMessage([taskNameArg, inputDataArg] as [Any?]) { response in
      guard let listResponse = response as? [Any?] else {
        completion(.failure(createConnectionError(withChannelName: channelName)))
        return
      }
      if listResponse.count > 1 {
        let code: String = listResponse[0] as! String
        let message: String? = nilOrValue(listResponse[1])
        let details: String? = nilOrValue(listResponse[2])
        completion(.failure(PigeonError(code: code, message: message, details: details)))
      } else if listResponse[0] == nil {
        completion(.failure(PigeonError(code: "null-error", message: "Flutter api returned null value for non-null return value.", details: "")))
      } else {
        let result = listResponse[0] as! Bool
        completion(.success(result))
      }
    }
  }
}
