// // Copyright 2024 The Flutter Workmanager Authors. All rights reserved.
// // Use of this source code is governed by a MIT-style license that can be
// // found in the LICENSE file.
// Autogenerated from Pigeon (v26.0.1), do not edit directly.
// See also: https://pub.dev/packages/pigeon
@file:Suppress("UNCHECKED_CAST", "ArrayInDataClass")

package dev.fluttercommunity.workmanager.pigeon

import android.util.Log
import io.flutter.plugin.common.BasicMessageChannel
import io.flutter.plugin.common.BinaryMessenger
import io.flutter.plugin.common.EventChannel
import io.flutter.plugin.common.MessageCodec
import io.flutter.plugin.common.StandardMethodCodec
import io.flutter.plugin.common.StandardMessageCodec
import java.io.ByteArrayOutputStream
import java.nio.ByteBuffer
private object WorkmanagerApiPigeonUtils {

  fun createConnectionError(channelName: String): FlutterError {
    return FlutterError("channel-error",  "Unable to establish connection on channel: '$channelName'.", "")  }

  fun wrapResult(result: Any?): List<Any?> {
    return listOf(result)
  }

  fun wrapError(exception: Throwable): List<Any?> {
    return if (exception is FlutterError) {
      listOf(
        exception.code,
        exception.message,
        exception.details
      )
    } else {
      listOf(
        exception.javaClass.simpleName,
        exception.toString(),
        "Cause: " + exception.cause + ", Stacktrace: " + Log.getStackTraceString(exception)
      )
    }
  }
  fun deepEquals(a: Any?, b: Any?): Boolean {
    if (a is ByteArray && b is ByteArray) {
        return a.contentEquals(b)
    }
    if (a is IntArray && b is IntArray) {
        return a.contentEquals(b)
    }
    if (a is LongArray && b is LongArray) {
        return a.contentEquals(b)
    }
    if (a is DoubleArray && b is DoubleArray) {
        return a.contentEquals(b)
    }
    if (a is Array<*> && b is Array<*>) {
      return a.size == b.size &&
          a.indices.all{ deepEquals(a[it], b[it]) }
    }
    if (a is List<*> && b is List<*>) {
      return a.size == b.size &&
          a.indices.all{ deepEquals(a[it], b[it]) }
    }
    if (a is Map<*, *> && b is Map<*, *>) {
      return a.size == b.size && a.all {
          (b as Map<Any?, Any?>).containsKey(it.key) &&
          deepEquals(it.value, b[it.key])
      }
    }
    return a == b
  }
      
}

/**
 * Error class for passing custom error details to Flutter via a thrown PlatformException.
 * @property code The error code.
 * @property message The error message.
 * @property details The error details. Must be a datatype supported by the api codec.
 */
class FlutterError (
  val code: String,
  override val message: String? = null,
  val details: Any? = null
) : Throwable()

/** Task status for debugging and monitoring. */
enum class TaskStatus(val raw: Int) {
  /** Task has been scheduled */
  SCHEDULED(0),
  /** Task has started execution */
  STARTED(1),
  /** Task completed successfully */
  COMPLETED(2),
  /** Task failed */
  FAILED(3),
  /** Task was cancelled */
  CANCELLED(4),
  /** Task is being retried */
  RETRYING(5),
  /** Task was rescheduled for later execution */
  RESCHEDULED(6);

  companion object {
    fun ofRaw(raw: Int): TaskStatus? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

/**
 * An enumeration of various network types that can be used as Constraints for work.
 *
 * Fully supported on Android.
 *
 * On iOS, this enumeration is used to define whether a piece of work requires
 * internet connectivity, by checking for either [NetworkType.connected] or
 * [NetworkType.metered].
 */
enum class NetworkType(val raw: Int) {
  /** Any working network connection is required for this work. */
  CONNECTED(0),
  /** A metered network connection is required for this work. */
  METERED(1),
  /** Default value. A network is not required for this work. */
  NOT_REQUIRED(2),
  /** A non-roaming network connection is required for this work. */
  NOT_ROAMING(3),
  /** An unmetered network connection is required for this work. */
  UNMETERED(4),
  /**
   * A temporarily unmetered Network. This capability will be set for
   * networks that are generally metered, but are currently unmetered.
   *
   * Android API 30+
   */
  TEMPORARILY_UNMETERED(5);

  companion object {
    fun ofRaw(raw: Int): NetworkType? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

/**
 * An enumeration of backoff policies when retrying work.
 * These policies are used when you have a return ListenableWorker.Result.retry() from a worker to determine the correct backoff time.
 * Backoff policies are set in WorkRequest.Builder.setBackoffCriteria(BackoffPolicy, long, TimeUnit) or one of its variants.
 */
enum class BackoffPolicy(val raw: Int) {
  /** Used to indicate that WorkManager should increase the backoff time exponentially */
  EXPONENTIAL(0),
  /** Used to indicate that WorkManager should increase the backoff time linearly */
  LINEAR(1);

  companion object {
    fun ofRaw(raw: Int): BackoffPolicy? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

/**
 * An enumeration of the conflict resolution policies when registering one-off work with the same unique name.
 *
 * This policy determines what happens when you register a one-off task with a unique name that already exists.
 *
 * See: https://developer.android.com/reference/androidx/work/ExistingWorkPolicy
 */
enum class ExistingWorkPolicy(val raw: Int) {
  /** If there is existing pending (uncompleted) work with the same unique name, append the newly-specified work as a child of all the leaves of that work sequence. */
  APPEND(0),
  /**
   * If there is existing pending (uncompleted) work with the same unique name, do nothing.
   * The new work request is ignored and the existing work continues unchanged.
   */
  KEEP(1),
  /**
   * If there is existing pending (uncompleted) work with the same unique name, cancel and delete it.
   * The new work request replaces the existing one entirely.
   */
  REPLACE(2),
  /**
   * If there is existing pending (uncompleted) work with the same unique name, it will be updated with the new specification.
   * Note: This maps to appendOrReplace in the native implementation.
   */
  UPDATE(3);

  companion object {
    fun ofRaw(raw: Int): ExistingWorkPolicy? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

/**
 * An enumeration of the conflict resolution policies when registering periodic work with the same unique name.
 *
 * This policy determines what happens when you register a periodic task with a unique name that already exists.
 * This is especially important during development when you might register the same task multiple times
 * with different frequencies or configurations.
 *
 * See: https://developer.android.com/reference/androidx/work/ExistingPeriodicWorkPolicy
 */
enum class ExistingPeriodicWorkPolicy(val raw: Int) {
  /**
   * If there is existing pending (uncompleted) work with the same unique name, do nothing.
   * The new work request is ignored and the existing work continues unchanged.
   *
   * **Warning**: If you previously registered a periodic task with a short frequency
   * (e.g., 15 minutes) and later register the same task with a longer frequency (e.g., 2 hours),
   * the task will continue running at the original short frequency. This can cause confusion
   * during development. Consider using [update] instead.
   */
  KEEP(0),
  /**
   * If there is existing pending (uncompleted) work with the same unique name, cancel and delete it.
   * The new work request replaces the existing one entirely.
   *
   * **Deprecated**: Android recommends using [update] instead for less disruptive updates.
   */
  REPLACE(1),
  /**
   * If there is existing pending (uncompleted) work with the same unique name, it will be updated with the new specification.
   *
   * **Recommended** - updates existing work without canceling running workers and preserves original timing.
   * This is the default policy for periodic tasks to prevent frequency confusion.
   *
   * Available since WorkManager 2.8.0.
   */
  UPDATE(2);

  companion object {
    fun ofRaw(raw: Int): ExistingPeriodicWorkPolicy? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

/**
 * An enumeration of policies that help determine out of quota behavior for expedited jobs.
 *
 * Only supported on Android.
 */
enum class OutOfQuotaPolicy(val raw: Int) {
  /**
   * When the app does not have any expedited job quota, the expedited work request will
   * fallback to a regular work request.
   */
  RUN_AS_NON_EXPEDITED_WORK_REQUEST(0),
  /**
   * When the app does not have any expedited job quota, the expedited work request will
   * we dropped and no work requests are enqueued.
   */
  DROP_WORK_REQUEST(1);

  companion object {
    fun ofRaw(raw: Int): OutOfQuotaPolicy? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

/** Generated class from Pigeon that represents data sent in messages. */
data class Constraints (
  val networkType: NetworkType? = null,
  val requiresBatteryNotLow: Boolean? = null,
  val requiresCharging: Boolean? = null,
  val requiresDeviceIdle: Boolean? = null,
  val requiresStorageNotLow: Boolean? = null
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): Constraints {
      val networkType = pigeonVar_list[0] as NetworkType?
      val requiresBatteryNotLow = pigeonVar_list[1] as Boolean?
      val requiresCharging = pigeonVar_list[2] as Boolean?
      val requiresDeviceIdle = pigeonVar_list[3] as Boolean?
      val requiresStorageNotLow = pigeonVar_list[4] as Boolean?
      return Constraints(networkType, requiresBatteryNotLow, requiresCharging, requiresDeviceIdle, requiresStorageNotLow)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      networkType,
      requiresBatteryNotLow,
      requiresCharging,
      requiresDeviceIdle,
      requiresStorageNotLow,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is Constraints) {
      return false
    }
    if (this === other) {
      return true
    }
    return WorkmanagerApiPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class BackoffPolicyConfig (
  val backoffPolicy: BackoffPolicy? = null,
  val backoffDelayMillis: Long? = null
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): BackoffPolicyConfig {
      val backoffPolicy = pigeonVar_list[0] as BackoffPolicy?
      val backoffDelayMillis = pigeonVar_list[1] as Long?
      return BackoffPolicyConfig(backoffPolicy, backoffDelayMillis)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      backoffPolicy,
      backoffDelayMillis,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is BackoffPolicyConfig) {
      return false
    }
    if (this === other) {
      return true
    }
    return WorkmanagerApiPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class InitializeRequest (
  val callbackHandle: Long
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): InitializeRequest {
      val callbackHandle = pigeonVar_list[0] as Long
      return InitializeRequest(callbackHandle)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      callbackHandle,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is InitializeRequest) {
      return false
    }
    if (this === other) {
      return true
    }
    return WorkmanagerApiPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class OneOffTaskRequest (
  val uniqueName: String,
  val taskName: String,
  val inputData: Map<String?, Any?>? = null,
  val initialDelaySeconds: Long? = null,
  val constraints: Constraints? = null,
  val backoffPolicy: BackoffPolicyConfig? = null,
  val tag: String? = null,
  val existingWorkPolicy: ExistingWorkPolicy? = null,
  val outOfQuotaPolicy: OutOfQuotaPolicy? = null
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): OneOffTaskRequest {
      val uniqueName = pigeonVar_list[0] as String
      val taskName = pigeonVar_list[1] as String
      val inputData = pigeonVar_list[2] as Map<String?, Any?>?
      val initialDelaySeconds = pigeonVar_list[3] as Long?
      val constraints = pigeonVar_list[4] as Constraints?
      val backoffPolicy = pigeonVar_list[5] as BackoffPolicyConfig?
      val tag = pigeonVar_list[6] as String?
      val existingWorkPolicy = pigeonVar_list[7] as ExistingWorkPolicy?
      val outOfQuotaPolicy = pigeonVar_list[8] as OutOfQuotaPolicy?
      return OneOffTaskRequest(uniqueName, taskName, inputData, initialDelaySeconds, constraints, backoffPolicy, tag, existingWorkPolicy, outOfQuotaPolicy)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      uniqueName,
      taskName,
      inputData,
      initialDelaySeconds,
      constraints,
      backoffPolicy,
      tag,
      existingWorkPolicy,
      outOfQuotaPolicy,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is OneOffTaskRequest) {
      return false
    }
    if (this === other) {
      return true
    }
    return WorkmanagerApiPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class PeriodicTaskRequest (
  val uniqueName: String,
  val taskName: String,
  val frequencySeconds: Long,
  val flexIntervalSeconds: Long? = null,
  val inputData: Map<String?, Any?>? = null,
  val initialDelaySeconds: Long? = null,
  val constraints: Constraints? = null,
  val backoffPolicy: BackoffPolicyConfig? = null,
  val tag: String? = null,
  val existingWorkPolicy: ExistingPeriodicWorkPolicy? = null
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): PeriodicTaskRequest {
      val uniqueName = pigeonVar_list[0] as String
      val taskName = pigeonVar_list[1] as String
      val frequencySeconds = pigeonVar_list[2] as Long
      val flexIntervalSeconds = pigeonVar_list[3] as Long?
      val inputData = pigeonVar_list[4] as Map<String?, Any?>?
      val initialDelaySeconds = pigeonVar_list[5] as Long?
      val constraints = pigeonVar_list[6] as Constraints?
      val backoffPolicy = pigeonVar_list[7] as BackoffPolicyConfig?
      val tag = pigeonVar_list[8] as String?
      val existingWorkPolicy = pigeonVar_list[9] as ExistingPeriodicWorkPolicy?
      return PeriodicTaskRequest(uniqueName, taskName, frequencySeconds, flexIntervalSeconds, inputData, initialDelaySeconds, constraints, backoffPolicy, tag, existingWorkPolicy)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      uniqueName,
      taskName,
      frequencySeconds,
      flexIntervalSeconds,
      inputData,
      initialDelaySeconds,
      constraints,
      backoffPolicy,
      tag,
      existingWorkPolicy,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is PeriodicTaskRequest) {
      return false
    }
    if (this === other) {
      return true
    }
    return WorkmanagerApiPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class ProcessingTaskRequest (
  val uniqueName: String,
  val taskName: String,
  val inputData: Map<String?, Any?>? = null,
  val initialDelaySeconds: Long? = null,
  val networkType: NetworkType? = null,
  val requiresCharging: Boolean? = null
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): ProcessingTaskRequest {
      val uniqueName = pigeonVar_list[0] as String
      val taskName = pigeonVar_list[1] as String
      val inputData = pigeonVar_list[2] as Map<String?, Any?>?
      val initialDelaySeconds = pigeonVar_list[3] as Long?
      val networkType = pigeonVar_list[4] as NetworkType?
      val requiresCharging = pigeonVar_list[5] as Boolean?
      return ProcessingTaskRequest(uniqueName, taskName, inputData, initialDelaySeconds, networkType, requiresCharging)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      uniqueName,
      taskName,
      inputData,
      initialDelaySeconds,
      networkType,
      requiresCharging,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is ProcessingTaskRequest) {
      return false
    }
    if (this === other) {
      return true
    }
    return WorkmanagerApiPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}
private open class WorkmanagerApiPigeonCodec : StandardMessageCodec() {
  override fun readValueOfType(type: Byte, buffer: ByteBuffer): Any? {
    return when (type) {
      129.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          TaskStatus.ofRaw(it.toInt())
        }
      }
      130.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          NetworkType.ofRaw(it.toInt())
        }
      }
      131.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          BackoffPolicy.ofRaw(it.toInt())
        }
      }
      132.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          ExistingWorkPolicy.ofRaw(it.toInt())
        }
      }
      133.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          ExistingPeriodicWorkPolicy.ofRaw(it.toInt())
        }
      }
      134.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          OutOfQuotaPolicy.ofRaw(it.toInt())
        }
      }
      135.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          Constraints.fromList(it)
        }
      }
      136.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          BackoffPolicyConfig.fromList(it)
        }
      }
      137.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          InitializeRequest.fromList(it)
        }
      }
      138.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          OneOffTaskRequest.fromList(it)
        }
      }
      139.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          PeriodicTaskRequest.fromList(it)
        }
      }
      140.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          ProcessingTaskRequest.fromList(it)
        }
      }
      else -> super.readValueOfType(type, buffer)
    }
  }
  override fun writeValue(stream: ByteArrayOutputStream, value: Any?)   {
    when (value) {
      is TaskStatus -> {
        stream.write(129)
        writeValue(stream, value.raw)
      }
      is NetworkType -> {
        stream.write(130)
        writeValue(stream, value.raw)
      }
      is BackoffPolicy -> {
        stream.write(131)
        writeValue(stream, value.raw)
      }
      is ExistingWorkPolicy -> {
        stream.write(132)
        writeValue(stream, value.raw)
      }
      is ExistingPeriodicWorkPolicy -> {
        stream.write(133)
        writeValue(stream, value.raw)
      }
      is OutOfQuotaPolicy -> {
        stream.write(134)
        writeValue(stream, value.raw)
      }
      is Constraints -> {
        stream.write(135)
        writeValue(stream, value.toList())
      }
      is BackoffPolicyConfig -> {
        stream.write(136)
        writeValue(stream, value.toList())
      }
      is InitializeRequest -> {
        stream.write(137)
        writeValue(stream, value.toList())
      }
      is OneOffTaskRequest -> {
        stream.write(138)
        writeValue(stream, value.toList())
      }
      is PeriodicTaskRequest -> {
        stream.write(139)
        writeValue(stream, value.toList())
      }
      is ProcessingTaskRequest -> {
        stream.write(140)
        writeValue(stream, value.toList())
      }
      else -> super.writeValue(stream, value)
    }
  }
}


/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface WorkmanagerHostApi {
  fun initialize(request: InitializeRequest, callback: (Result<Unit>) -> Unit)
  fun registerOneOffTask(request: OneOffTaskRequest, callback: (Result<Unit>) -> Unit)
  fun registerPeriodicTask(request: PeriodicTaskRequest, callback: (Result<Unit>) -> Unit)
  fun registerProcessingTask(request: ProcessingTaskRequest, callback: (Result<Unit>) -> Unit)
  fun cancelByUniqueName(uniqueName: String, callback: (Result<Unit>) -> Unit)
  fun cancelByTag(tag: String, callback: (Result<Unit>) -> Unit)
  fun cancelAll(callback: (Result<Unit>) -> Unit)
  fun isScheduledByUniqueName(uniqueName: String, callback: (Result<Boolean>) -> Unit)
  fun printScheduledTasks(callback: (Result<String>) -> Unit)

  companion object {
    /** The codec used by WorkmanagerHostApi. */
    val codec: MessageCodec<Any?> by lazy {
      WorkmanagerApiPigeonCodec()
    }
    /** Sets up an instance of `WorkmanagerHostApi` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(binaryMessenger: BinaryMessenger, api: WorkmanagerHostApi?, messageChannelSuffix: String = "") {
      val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerHostApi.initialize$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val requestArg = args[0] as InitializeRequest
            api.initialize(requestArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(WorkmanagerApiPigeonUtils.wrapError(error))
              } else {
                reply.reply(WorkmanagerApiPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerHostApi.registerOneOffTask$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val requestArg = args[0] as OneOffTaskRequest
            api.registerOneOffTask(requestArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(WorkmanagerApiPigeonUtils.wrapError(error))
              } else {
                reply.reply(WorkmanagerApiPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerHostApi.registerPeriodicTask$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val requestArg = args[0] as PeriodicTaskRequest
            api.registerPeriodicTask(requestArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(WorkmanagerApiPigeonUtils.wrapError(error))
              } else {
                reply.reply(WorkmanagerApiPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerHostApi.registerProcessingTask$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val requestArg = args[0] as ProcessingTaskRequest
            api.registerProcessingTask(requestArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(WorkmanagerApiPigeonUtils.wrapError(error))
              } else {
                reply.reply(WorkmanagerApiPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerHostApi.cancelByUniqueName$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val uniqueNameArg = args[0] as String
            api.cancelByUniqueName(uniqueNameArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(WorkmanagerApiPigeonUtils.wrapError(error))
              } else {
                reply.reply(WorkmanagerApiPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerHostApi.cancelByTag$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val tagArg = args[0] as String
            api.cancelByTag(tagArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(WorkmanagerApiPigeonUtils.wrapError(error))
              } else {
                reply.reply(WorkmanagerApiPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerHostApi.cancelAll$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.cancelAll{ result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(WorkmanagerApiPigeonUtils.wrapError(error))
              } else {
                reply.reply(WorkmanagerApiPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerHostApi.isScheduledByUniqueName$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val uniqueNameArg = args[0] as String
            api.isScheduledByUniqueName(uniqueNameArg) { result: Result<Boolean> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(WorkmanagerApiPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(WorkmanagerApiPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerHostApi.printScheduledTasks$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.printScheduledTasks{ result: Result<String> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(WorkmanagerApiPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(WorkmanagerApiPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
/** Generated class from Pigeon that represents Flutter messages that can be called from Kotlin. */
class WorkmanagerFlutterApi(private val binaryMessenger: BinaryMessenger, private val messageChannelSuffix: String = "") {
  companion object {
    /** The codec used by WorkmanagerFlutterApi. */
    val codec: MessageCodec<Any?> by lazy {
      WorkmanagerApiPigeonCodec()
    }
  }
  fun backgroundChannelInitialized(callback: (Result<Unit>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerFlutterApi.backgroundChannelInitialized$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(null) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else {
          callback(Result.success(Unit))
        }
      } else {
        callback(Result.failure(WorkmanagerApiPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
  fun executeTask(taskNameArg: String, inputDataArg: Map<String?, Any?>?, callback: (Result<Boolean>) -> Unit)
{
    val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
    val channelName = "dev.flutter.pigeon.workmanager_platform_interface.WorkmanagerFlutterApi.executeTask$separatedMessageChannelSuffix"
    val channel = BasicMessageChannel<Any?>(binaryMessenger, channelName, codec)
    channel.send(listOf(taskNameArg, inputDataArg)) {
      if (it is List<*>) {
        if (it.size > 1) {
          callback(Result.failure(FlutterError(it[0] as String, it[1] as String, it[2] as String?)))
        } else if (it[0] == null) {
          callback(Result.failure(FlutterError("null-error", "Flutter api returned null value for non-null return value.", "")))
        } else {
          val output = it[0] as Boolean
          callback(Result.success(output))
        }
      } else {
        callback(Result.failure(WorkmanagerApiPigeonUtils.createConnectionError(channelName)))
      } 
    }
  }
}
