// ignore_for_file: deprecated_member_use_from_same_package

import 'package:http/http.dart';
import 'package:sentry/sentry.dart';
import 'package:sentry/src/noop_client.dart';
import 'package:sentry/src/version.dart';
import 'package:test/test.dart';

import 'test_utils.dart';

void main() {
  test('$Client is NoOp', () {
    final options = defaultTestOptions();
    expect(NoOpClient(), options.httpClient);
  });

  test('$Client sets a custom client', () {
    final options = defaultTestOptions();

    final client = Client();
    options.httpClient = client;
    expect(client, options.httpClient);
  });

  test('maxBreadcrumbs is 100 by default', () {
    final options = defaultTestOptions();

    expect(100, options.maxBreadcrumbs);
  });

  test('maxBreadcrumbs sets custom maxBreadcrumbs', () {
    final options = defaultTestOptions();
    options.maxBreadcrumbs = 200;

    expect(200, options.maxBreadcrumbs);
  });

  test('SentryLogger sets a diagnostic logger', () {
    final options = defaultTestOptions();
    expect(options.logger, noOpLogger);
    options.logger = dartLogger;

    expect(options.logger, isNot(noOpLogger));
  });

  test('setting debug correctly sets logger', () {
    final options = defaultTestOptions();
    expect(options.logger, noOpLogger);
    expect(options.diagnosticLogger, isNull);
    options.debug = true;
    expect(options.logger, isNot(options.debugLogger));
    expect(options.diagnosticLogger!.logger, options.debugLogger);
    expect(options.logger, options.diagnosticLogger!.log);

    options.debug = false;
    expect(options.logger, isNot(noOpLogger));
    expect(options.diagnosticLogger!.logger, noOpLogger);
    expect(options.logger, options.diagnosticLogger!.log);

    options.debug = true;
    expect(options.logger, isNot(options.debugLogger));
    expect(options.diagnosticLogger!.logger, options.debugLogger);
    expect(options.logger, options.diagnosticLogger!.log);
  });

  test('tracesSampler is null by default', () {
    final options = defaultTestOptions();

    expect(options.tracesSampler, isNull);
  });

  test('tracesSampleRate is null by default', () {
    final options = defaultTestOptions();

    expect(options.tracesSampleRate, isNull);
  });

  test('isTracingEnabled is disabled', () {
    final options = defaultTestOptions();

    expect(options.isTracingEnabled(), false);
  });

  test('isTracingEnabled is enabled by theres rate', () {
    final options = defaultTestOptions();
    options.tracesSampleRate = 1.0;

    expect(options.isTracingEnabled(), true);
  });

  test('isTracingEnabled is enabled by theres sampler', () {
    final options = defaultTestOptions();

    double? sampler(SentrySamplingContext samplingContext) => 0.0;

    options.tracesSampler = sampler;

    expect(options.isTracingEnabled(), true);
  });

  test('SentryOptions empty inits the late var', () {
    final options = SentryOptions.empty();
    options.sdk.addPackage('test', '1.2.3');

    expect(
        options.sdk.packages
            .where((element) =>
                element.name == 'test' && element.version == '1.2.3')
            .isNotEmpty,
        true);
  });

  test('SentryOptions has all targets by default', () {
    final options = SentryOptions.empty();

    expect(options.tracePropagationTargets, ['.*']);
  });

  test('SentryOptions has sentryClientName set', () {
    final options = defaultTestOptions();

    expect(options.sentryClientName,
        '${sdkName(options.platformChecker.isWeb)}/$sdkVersion');
  });

  test('SentryOptions has default idleTimeout', () {
    final options = SentryOptions.empty();

    expect(options.idleTimeout?.inSeconds, Duration(seconds: 3).inSeconds);
  });

  test('when enableTracing is set to true tracing is considered enabled', () {
    final options = SentryOptions.empty();
    options.enableTracing = true;

    expect(options.isTracingEnabled(), true);
  });

  test('when enableTracing is set to false tracing is considered disabled', () {
    final options = SentryOptions.empty();
    options.enableTracing = false;
    options.tracesSampleRate = 1.0;
    options.tracesSampler = (_) {
      return 1.0;
    };

    expect(options.isTracingEnabled(), false);
  });

  test('Spotlight is disabled by default', () {
    final options = defaultTestOptions();

    expect(options.spotlight.enabled, false);
  });

  test('enableExceptionTypeIdentification is enabled by default', () {
    final options = defaultTestOptions();

    expect(options.enableExceptionTypeIdentification, true);
  });

  test('enablePureDartSymbolication is enabled by default', () {
    final options = defaultTestOptions();

    expect(options.enableDartSymbolication, true);
  });

  test('parsedDsn is correctly parsed and cached', () {
    final options = defaultTestOptions();

    // Access parsedDsn for the first time
    final parsedDsn1 = options.parsedDsn;

    // Access parsedDsn again
    final parsedDsn2 = options.parsedDsn;

    // Should return the same instance since it's cached
    expect(identical(parsedDsn1, parsedDsn2), isTrue);

    // Verify the parsed DSN fields
    final manuallyParsedDsn = Dsn.parse(options.dsn!);
    expect(parsedDsn1.publicKey, manuallyParsedDsn.publicKey);
    expect(parsedDsn1.postUri, manuallyParsedDsn.postUri);
    expect(parsedDsn1.secretKey, manuallyParsedDsn.secretKey);
    expect(parsedDsn1.projectId, manuallyParsedDsn.projectId);
    expect(parsedDsn1.uri, manuallyParsedDsn.uri);
  });

  test('parsedDsn throws when DSN is null', () {
    final options = defaultTestOptions()..dsn = null;

    expect(() => options.parsedDsn, throwsA(isA<StateError>()));
  });

  test('parsedDsn throws when DSN is empty', () {
    final options = defaultTestOptions()..dsn = '';

    expect(() => options.parsedDsn, throwsA(isA<StateError>()));
  });
}
