/// An enumeration representing different types of sub-editors available in the
/// image editor.
enum SubEditor {
  /// Represents the paint sub-editor.
  paint,

  /// Represents the text sub-editor.
  text,

  /// Represents the crop and rotate sub-editor.
  cropRotate,

  /// Represents the filter sub-editor.
  filter,

  /// Represents the blur sub-editor.
  blur,

  /// Represents the emoji sub-editor.
  emoji,

  /// Represents the sticker sub-editor.
  sticker,

  /// Represents an unknown sub-editor.
  unknown,
}
