/// An enumeration representing the direction of rotation for an image editor.
///
/// This enum defines the available directions for rotating an image, allowing
/// users to specify whether to rotate left or right.
enum RotateDirection {
  /// Rotate the image to the left.
  ///
  /// This direction specifies a counter-clockwise rotation, typically used
  /// when users want to rotate the image 90 degrees to the left.
  left,

  /// Rotate the image to the right.
  ///
  /// This direction specifies a clockwise rotation, typically used when users
  /// want to rotate the image 90 degrees to the right.
  right,
}
