library hugeicons_strokerounded;

/// StrokeRounded style icons for HugeIcons (Free).
///
/// This library contains all icons in the strokeRounded style using efficient JSON structure.
/// Import this file to access strokeRounded icons with tree-shaking support.
class HugeIconsStrokeRounded {
  const HugeIconsStrokeRounded();

  /// JSON structure for the 'strokeRounded0Circle' icon.
  static const List<List<dynamic>> strokeRounded0Circle = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M15 14V10C15 8.34315 13.6569 7 12 7C10.3431 7 9 8.34315 9 10V14C9 15.6569 10.3431 17 12 17C13.6569 17 15 15.6569 15 14Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded0Square' icon.
  static const List<List<dynamic>> strokeRounded0Square = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M15 14V10C15 8.34315 13.6569 7 12 7C10.3431 7 9 8.34315 9 10V14C9 15.6569 10.3431 17 12 17C13.6569 17 15 15.6569 15 14Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded1Circle' icon.
  static const List<List<dynamic>> strokeRounded1Circle = [
    [
      'path',
      {
        'key': '0',
        'd': 'M10.5 8.5L12.5 7V17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded1Square' icon.
  static const List<List<dynamic>> strokeRounded1Square = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M10.5 8.5L12.5 7V17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded1stBracket' icon.
  static const List<List<dynamic>> strokeRounded1stBracket = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6 3C3.58901 4.93486 2 8.24345 2 12C2 15.7565 3.58901 19.0651 6 21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18 3C20.411 4.93486 22 8.24345 22 12C22 15.7565 20.411 19.0651 18 21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded1stBracketCircle' icon.
  static const List<List<dynamic>> strokeRounded1stBracketCircle = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M9 8C7.7945 8.85994 7 10.3304 7 12C7 13.6696 7.7945 15.1401 9 16M15 8C16.2055 8.85994 17 10.3304 17 12C17 13.6696 16.2055 15.1401 15 16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'circle',
      {
        'key': '1',
        'cx': '12',
        'cy': '12',
        'r': '10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded1stBracketSquare' icon.
  static const List<List<dynamic>> strokeRounded1stBracketSquare = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M9 8C7.7945 8.85994 7 10.3304 7 12C7 13.6696 7.7945 15.1401 9 16M15 8C16.2055 8.85994 17 10.3304 17 12C17 13.6696 16.2055 15.1401 15 16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded1stBrecket' icon.
  static const List<List<dynamic>> strokeRounded1stBrecket = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6 3C3.58901 4.93486 2 8.24345 2 12C2 15.7565 3.58901 19.0651 6 21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18 3C20.411 4.93486 22 8.24345 22 12C22 15.7565 20.411 19.0651 18 21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded1stBrecketCircle' icon.
  static const List<List<dynamic>> strokeRounded1stBrecketCircle = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M9 8C7.7945 8.85994 7 10.3304 7 12C7 13.6696 7.7945 15.1401 9 16M15 8C16.2055 8.85994 17 10.3304 17 12C17 13.6696 16.2055 15.1401 15 16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'circle',
      {
        'key': '1',
        'cx': '12',
        'cy': '12',
        'r': '10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded1stBrecketSquare' icon.
  static const List<List<dynamic>> strokeRounded1stBrecketSquare = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M9 8C7.7945 8.85994 7 10.3304 7 12C7 13.6696 7.7945 15.1401 9 16M15 8C16.2055 8.85994 17 10.3304 17 12C17 13.6696 16.2055 15.1401 15 16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded2Circle' icon.
  static const List<List<dynamic>> strokeRounded2Circle = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M9 10C9 8.34315 10.3431 7 12 7C13.6569 7 15 8.34315 15 10C15 12.0786 12.1196 13.9172 10.3503 14.8505C9.54685 15.2743 9 16.0917 9 17H15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded2Square' icon.
  static const List<List<dynamic>> strokeRounded2Square = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M9 10C9 8.34315 10.3431 7 12 7C13.6569 7 15 8.34315 15 10C15 12.0786 12.1196 13.9172 10.3503 14.8505C9.54685 15.2743 9 16.0917 9 17H15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded2ndBracket' icon.
  static const List<List<dynamic>> strokeRounded2ndBracket = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M17.225 3C18.6145 3.15381 19.5498 3.50143 20.2479 4.28705C21.5 5.69617 21.5 7.96411 21.5 12.5C21.5 17.0359 21.5 19.3038 20.2479 20.713C19.5498 21.4986 18.6145 21.8462 17.225 22M6.77501 22C5.38551 21.8462 4.45021 21.4986 3.75212 20.713C2.5 19.3038 2.5 17.0359 2.5 12.5C2.5 7.96411 2.5 5.69617 3.75212 4.28705C4.45021 3.50143 5.38551 3.15381 6.77501 3',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded2ndBracketCircle' icon.
  static const List<List<dynamic>> strokeRounded2ndBracketCircle = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M15 8C15.6501 8.06476 16.0876 8.21113 16.4142 8.54192C17 9.13523 17 10.0902 17 12C17 13.9098 17 14.8648 16.4142 15.4581C16.0876 15.7889 15.6501 15.9352 15 16M9 16C8.34994 15.9352 7.91238 15.7889 7.58579 15.4581C7 14.8648 7 13.9098 7 12C7 10.0902 7 9.13523 7.58579 8.54192C7.91238 8.21113 8.34994 8.06476 9 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'circle',
      {
        'key': '1',
        'cx': '12',
        'cy': '12',
        'r': '10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded2ndBracketSquare' icon.
  static const List<List<dynamic>> strokeRounded2ndBracketSquare = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M15 8C15.6501 8.06476 16.0876 8.21113 16.4142 8.54192C17 9.13523 17 10.0902 17 12C17 13.9098 17 14.8648 16.4142 15.4581C16.0876 15.7889 15.6501 15.9352 15 16M9 16C8.34994 15.9352 7.91238 15.7889 7.58579 15.4581C7 14.8648 7 13.9098 7 12C7 10.0902 7 9.13523 7.58579 8.54192C7.91238 8.21113 8.34994 8.06476 9 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded2ndBrecket' icon.
  static const List<List<dynamic>> strokeRounded2ndBrecket = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M17.225 3C18.6145 3.15381 19.5498 3.50143 20.2479 4.28705C21.5 5.69617 21.5 7.96411 21.5 12.5C21.5 17.0359 21.5 19.3038 20.2479 20.713C19.5498 21.4986 18.6145 21.8462 17.225 22M6.77501 22C5.38551 21.8462 4.45021 21.4986 3.75212 20.713C2.5 19.3038 2.5 17.0359 2.5 12.5C2.5 7.96411 2.5 5.69617 3.75212 4.28705C4.45021 3.50143 5.38551 3.15381 6.77501 3',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded2ndBrecketCircle' icon.
  static const List<List<dynamic>> strokeRounded2ndBrecketCircle = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M15 8C15.6501 8.06476 16.0876 8.21113 16.4142 8.54192C17 9.13523 17 10.0902 17 12C17 13.9098 17 14.8648 16.4142 15.4581C16.0876 15.7889 15.6501 15.9352 15 16M9 16C8.34994 15.9352 7.91238 15.7889 7.58579 15.4581C7 14.8648 7 13.9098 7 12C7 10.0902 7 9.13523 7.58579 8.54192C7.91238 8.21113 8.34994 8.06476 9 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'circle',
      {
        'key': '1',
        'cx': '12',
        'cy': '12',
        'r': '10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded2ndBrecketSquare' icon.
  static const List<List<dynamic>> strokeRounded2ndBrecketSquare = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M15 8C15.6501 8.06476 16.0876 8.21113 16.4142 8.54192C17 9.13523 17 10.0902 17 12C17 13.9098 17 14.8648 16.4142 15.4581C16.0876 15.7889 15.6501 15.9352 15 16M9 16C8.34994 15.9352 7.91238 15.7889 7.58579 15.4581C7 14.8648 7 13.9098 7 12C7 10.0902 7 9.13523 7.58579 8.54192C7.91238 8.21113 8.34994 8.06476 9 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded3Circle' icon.
  static const List<List<dynamic>> strokeRounded3Circle = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12.5 12H11.5M12.5 12C13.8807 12 15 10.8807 15 9.5C15 8.11929 13.8807 7 12.5 7H11.5C10.1193 7 9 8.11929 9 9.5M12.5 12C13.8807 12 15 13.1193 15 14.5C15 15.8807 13.8807 17 12.5 17H11.5C10.1193 17 9 15.8807 9 14.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded3DMove' icon.
  static const List<List<dynamic>> strokeRounded3DMove = [
    [
      'path',
      {
        'key': '0',
        'd': 'M12 14L17.5 18.5M12 14L6.5 18.5M12 14V7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M10.3914 3.69046C11.1054 2.56349 11.4624 2 12 2C12.5376 2 12.8946 2.56349 13.6086 3.69046L14.1215 4.49995C14.8259 5.6118 15.1781 6.16772 14.9104 6.58386C14.6426 7 13.9327 7 12.5129 7H11.4871C10.0673 7 9.35739 7 9.08963 6.58386C8.82188 6.16772 9.17409 5.6118 9.87852 4.49995L10.3914 3.69046Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M21.2324 19.1408C21.8559 20.3502 22.1676 20.9548 21.9085 21.4249C21.6494 21.8949 20.9936 21.9144 19.6819 21.9536L18.7398 21.9817C17.4457 22.0203 16.7987 22.0396 16.5705 21.5895C16.3422 21.1393 16.6843 20.5186 17.3686 19.2773L17.8629 18.3805C18.5471 17.1391 18.8893 16.5184 19.3756 16.5004C19.8619 16.4824 20.1694 17.0789 20.7846 18.2721L21.2324 19.1408Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M2.76761 19.1408C2.14414 20.3502 1.8324 20.9548 2.09148 21.4249C2.35055 21.8949 3.00639 21.9144 4.31805 21.9536L5.26021 21.9817C6.55427 22.0203 7.20131 22.0396 7.42955 21.5895C7.65779 21.1393 7.31567 20.5186 6.63143 19.2773L6.13711 18.3805C5.45286 17.1391 5.11074 16.5184 4.62443 16.5004C4.13811 16.4824 3.83055 17.0789 3.21545 18.2721L2.76761 19.1408Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded3DRotate' icon.
  static const List<List<dynamic>> strokeRounded3DRotate = [
    [
      'circle',
      {
        'key': '0',
        'cx': '12',
        'cy': '12',
        'r': '10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M2 12C7.18491 16.8269 16.4642 16.3877 22 12.3556',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M11.5368 2C6.98945 6.5 6.48414 17 11.9941 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded3DScale' icon.
  static const List<List<dynamic>> strokeRounded3DScale = [
    [
      'path',
      {
        'key': '0',
        'd': 'M12 13L17 17.5M12 13L7 17.5M12 13V8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18.1915 16.4456C18.7081 16.1485 18.9664 16 19.25 16C19.5336 16 19.7919 16.1485 20.3085 16.4456L20.9415 16.8097C21.4581 17.1068 21.7164 17.2553 21.8582 17.5C22 17.7447 22 18.0418 22 18.6359V19.3641C22 19.9582 22 20.2553 21.8582 20.5C21.7164 20.7447 21.4581 20.8932 20.9415 21.1903L20.3085 21.5544C19.7919 21.8515 19.5336 22 19.25 22C18.9664 22 18.7081 21.8515 18.1915 21.5544L17.5585 21.1903C17.0419 20.8932 16.7836 20.7447 16.6418 20.5C16.5 20.2553 16.5 19.9582 16.5 19.3641V18.6359C16.5 18.0418 16.5 17.7447 16.6418 17.5C16.7836 17.2553 17.0419 17.1068 17.5585 16.8097L18.1915 16.4456Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M3.69152 16.4456C4.2081 16.1485 4.46638 16 4.75 16C5.03362 16 5.2919 16.1485 5.80848 16.4456L6.44152 16.8097C6.9581 17.1068 7.21638 17.2553 7.35819 17.5C7.5 17.7447 7.5 18.0418 7.5 18.6359V19.3641C7.5 19.9582 7.5 20.2553 7.35819 20.5C7.21638 20.7447 6.9581 20.8932 6.44152 21.1903L5.80848 21.5544C5.2919 21.8515 5.03362 22 4.75 22C4.46638 22 4.2081 21.8515 3.69152 21.5544L3.05848 21.1903C2.5419 20.8932 2.28362 20.7447 2.14181 20.5C2 20.2553 2 19.9582 2 19.3641V18.6359C2 18.0418 2 17.7447 2.14181 17.5C2.28362 17.2553 2.5419 17.1068 3.05848 16.8097L3.69152 16.4456Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M10.9415 2.44563C11.4581 2.14854 11.7164 2 12 2C12.2836 2 12.5419 2.14854 13.0585 2.44563L13.6915 2.8097C14.2081 3.10679 14.4664 3.25533 14.6082 3.5C14.75 3.74467 14.75 4.04175 14.75 4.63593V5.36407C14.75 5.95825 14.75 6.25533 14.6082 6.5C14.4664 6.74467 14.2081 6.89321 13.6915 7.1903L13.0585 7.55437C12.5419 7.85146 12.2836 8 12 8C11.7164 8 11.4581 7.85146 10.9415 7.55437L10.3085 7.1903C9.7919 6.89321 9.53362 6.74467 9.39181 6.5C9.25 6.25533 9.25 5.95825 9.25 5.36407V4.63593C9.25 4.04175 9.25 3.74467 9.39181 3.5C9.53362 3.25533 9.7919 3.10679 10.3085 2.8097L10.9415 2.44563Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded3DView' icon.
  static const List<List<dynamic>> strokeRounded3DView = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12 11.5C12.4955 11.5 12.9562 11.3015 13.8775 10.9045L14.5423 10.618C16.1808 9.91202 17 9.55902 17 9C17 8.44098 16.1808 8.08798 14.5423 7.38197L13.8775 7.09549C12.9562 6.6985 12.4955 6.5 12 6.5C11.5045 6.5 11.0438 6.6985 10.1225 7.09549L9.45768 7.38197C7.81923 8.08798 7 8.44098 7 9C7 9.55902 7.81923 9.91202 9.45768 10.618L10.1225 10.9045C11.0438 11.3015 11.5045 11.5 12 11.5ZM12 11.5V17.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M17 9V15C17 15.559 16.1808 15.912 14.5423 16.618L13.8775 16.9045C12.9562 17.3015 12.4955 17.5 12 17.5C11.5045 17.5 11.0438 17.3015 10.1225 16.9045L9.45768 16.618C7.81923 15.912 7 15.559 7 15V9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M9.14426 2.5C6.48724 2.56075 4.93529 2.81456 3.87493 3.87493C2.81456 4.93529 2.56075 6.48724 2.5 9.14426M14.8557 2.5C17.5128 2.56075 19.0647 2.81456 20.1251 3.87493C21.1854 4.93529 21.4392 6.48724 21.5 9.14426M14.8557 21.5C17.5128 21.4392 19.0647 21.1854 20.1251 20.1251C21.1854 19.0647 21.4392 17.5128 21.5 14.8557M9.14426 21.5C6.48724 21.4392 4.93529 21.1854 3.87493 20.1251C2.81456 19.0647 2.56075 17.5128 2.5 14.8557',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded3Square' icon.
  static const List<List<dynamic>> strokeRounded3Square = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12.5 12H11.5M12.5 12C13.8807 12 15 10.8807 15 9.5C15 8.11929 13.8807 7 12.5 7H11.5C10.1193 7 9 8.11929 9 9.5M12.5 12C13.8807 12 15 13.1193 15 14.5C15 15.8807 13.8807 17 12.5 17H11.5C10.1193 17 9 15.8807 9 14.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded3dMove' icon.
  static const List<List<dynamic>> strokeRounded3dMove = [
    [
      'path',
      {
        'key': '0',
        'd': 'M12 14L17.5 18.5M12 14L6.5 18.5M12 14V7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M10.3914 3.69046C11.1054 2.56349 11.4624 2 12 2C12.5376 2 12.8946 2.56349 13.6086 3.69046L14.1215 4.49995C14.8259 5.6118 15.1781 6.16772 14.9104 6.58386C14.6426 7 13.9327 7 12.5129 7H11.4871C10.0673 7 9.35739 7 9.08963 6.58386C8.82188 6.16772 9.17409 5.6118 9.87852 4.49995L10.3914 3.69046Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M21.2324 19.1408C21.8559 20.3502 22.1676 20.9548 21.9085 21.4249C21.6494 21.8949 20.9936 21.9144 19.6819 21.9536L18.7398 21.9817C17.4457 22.0203 16.7987 22.0396 16.5705 21.5895C16.3422 21.1393 16.6843 20.5186 17.3686 19.2773L17.8629 18.3805C18.5471 17.1391 18.8893 16.5184 19.3756 16.5004C19.8619 16.4824 20.1694 17.0789 20.7846 18.2721L21.2324 19.1408Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M2.76761 19.1408C2.14414 20.3502 1.8324 20.9548 2.09148 21.4249C2.35055 21.8949 3.00639 21.9144 4.31805 21.9536L5.26021 21.9817C6.55427 22.0203 7.20131 22.0396 7.42955 21.5895C7.65779 21.1393 7.31567 20.5186 6.63143 19.2773L6.13711 18.3805C5.45286 17.1391 5.11074 16.5184 4.62443 16.5004C4.13811 16.4824 3.83055 17.0789 3.21545 18.2721L2.76761 19.1408Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded3dPrinter' icon.
  static const List<List<dynamic>> strokeRounded3dPrinter = [
    [
      'path',
      {
        'key': '0',
        'd': 'M8 2H2V2.5C2 3.60457 2.89543 4.5 4 4.5H8V2Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M22 2H16V4.5H20C21.1046 4.5 22 3.60457 22 2.5V2Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M16 2H8V10H16V2Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M13.5 13H10.5L8 10H16L13.5 13Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M13.5 13H10.5V14.7574C10.5 15.553 10.8161 16.3161 11.3787 16.8787L12 17.5L12.6213 16.8787C13.1839 16.3161 13.5 15.553 13.5 14.7574V13Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M2 22H10C11.1046 22 12 21.1046 12 20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd': 'M14 5V5.01',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '7',
        'd': 'M14 7.5V7.51',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded3dRotate' icon.
  static const List<List<dynamic>> strokeRounded3dRotate = [
    [
      'circle',
      {
        'key': '0',
        'cx': '12',
        'cy': '12',
        'r': '10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M2 12C7.18491 16.8269 16.4642 16.3877 22 12.3556',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M11.5368 2C6.98939 6.5 6.48408 17 11.9941 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded3dScale' icon.
  static const List<List<dynamic>> strokeRounded3dScale = [
    [
      'path',
      {
        'key': '0',
        'd': 'M12 13L17 17.5M12 13L7 17.5M12 13V8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18.1915 16.4456C18.7081 16.1485 18.9664 16 19.25 16C19.5336 16 19.7919 16.1485 20.3085 16.4456L20.9415 16.8097C21.4581 17.1068 21.7164 17.2553 21.8582 17.5C22 17.7447 22 18.0418 22 18.6359V19.3641C22 19.9582 22 20.2553 21.8582 20.5C21.7164 20.7447 21.4581 20.8932 20.9415 21.1903L20.3085 21.5544C19.7919 21.8515 19.5336 22 19.25 22C18.9664 22 18.7081 21.8515 18.1915 21.5544L17.5585 21.1903C17.0419 20.8932 16.7836 20.7447 16.6418 20.5C16.5 20.2553 16.5 19.9582 16.5 19.3641V18.6359C16.5 18.0418 16.5 17.7447 16.6418 17.5C16.7836 17.2553 17.0419 17.1068 17.5585 16.8097L18.1915 16.4456Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M3.69152 16.4456C4.2081 16.1485 4.46638 16 4.75 16C5.03362 16 5.2919 16.1485 5.80848 16.4456L6.44152 16.8097C6.9581 17.1068 7.21638 17.2553 7.35819 17.5C7.5 17.7447 7.5 18.0418 7.5 18.6359V19.3641C7.5 19.9582 7.5 20.2553 7.35819 20.5C7.21638 20.7447 6.9581 20.8932 6.44152 21.1903L5.80848 21.5544C5.2919 21.8515 5.03362 22 4.75 22C4.46638 22 4.2081 21.8515 3.69152 21.5544L3.05848 21.1903C2.5419 20.8932 2.28362 20.7447 2.14181 20.5C2 20.2553 2 19.9582 2 19.3641V18.6359C2 18.0418 2 17.7447 2.14181 17.5C2.28362 17.2553 2.5419 17.1068 3.05848 16.8097L3.69152 16.4456Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M10.9415 2.44563C11.4581 2.14854 11.7164 2 12 2C12.2836 2 12.5419 2.14854 13.0585 2.44563L13.6915 2.8097C14.2081 3.10679 14.4664 3.25533 14.6082 3.5C14.75 3.74467 14.75 4.04175 14.75 4.63593V5.36407C14.75 5.95825 14.75 6.25533 14.6082 6.5C14.4664 6.74467 14.2081 6.89321 13.6915 7.1903L13.0585 7.55437C12.5419 7.85146 12.2836 8 12 8C11.7164 8 11.4581 7.85146 10.9415 7.55437L10.3085 7.1903C9.7919 6.89321 9.53362 6.74467 9.39181 6.5C9.25 6.25533 9.25 5.95825 9.25 5.36407V4.63593C9.25 4.04175 9.25 3.74467 9.39181 3.5C9.53362 3.25533 9.7919 3.10679 10.3085 2.8097L10.9415 2.44563Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded3rdBracket' icon.
  static const List<List<dynamic>> strokeRounded3rdBracket = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M18 21C19.2322 21 20.231 19.8487 20.231 18.4286C20.231 16.1808 20.1312 14.6865 21.6733 12.9091C22.1089 12.407 22.1089 11.593 21.6733 11.0909C20.1312 9.31354 20.231 7.81916 20.231 5.57143C20.231 4.15127 19.2322 3 18 3',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M6 21C4.76784 21 3.76897 19.8487 3.76897 18.4286C3.76897 16.1808 3.86877 14.6865 2.32673 12.9091C1.89109 12.407 1.89109 11.593 2.32673 11.0909C3.83496 9.35251 3.76897 7.83992 3.76897 5.57143C3.76897 4.15127 4.76784 3 6 3',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded3rdBracketCircle' icon.
  static const List<List<dynamic>> strokeRounded3rdBracketCircle = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M14 16C14.9241 16 15.6733 15.4883 15.6733 14.8571C15.6733 13.6365 15.6869 13.1336 16.755 12.4041C17.0817 12.1809 17.0817 11.8191 16.755 11.5959C15.6869 10.8664 15.6733 10.3635 15.6733 9.14286C15.6733 8.51167 14.9241 8 14 8M10 16C9.07588 16 8.32673 15.4883 8.32673 14.8571C8.32673 13.6365 8.31312 13.1336 7.24505 12.4041C6.91832 12.1809 6.91832 11.8191 7.24504 11.5959C8.31312 10.8664 8.32673 10.3635 8.32673 9.14286C8.32673 8.51167 9.07588 8 10 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'circle',
      {
        'key': '1',
        'cx': '12',
        'cy': '12',
        'r': '10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded3rdBracketSquare' icon.
  static const List<List<dynamic>> strokeRounded3rdBracketSquare = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M14 16C14.9241 16 15.6733 15.4883 15.6733 14.8571C15.6733 13.6365 15.6869 13.1336 16.755 12.4041C17.0817 12.1809 17.0817 11.8191 16.755 11.5959C15.6869 10.8664 15.6733 10.3635 15.6733 9.14286C15.6733 8.51167 14.9241 8 14 8M10 16C9.07588 16 8.32673 15.4883 8.32673 14.8571C8.32673 13.6365 8.31312 13.1336 7.24505 12.4041C6.91832 12.1809 6.91832 11.8191 7.24504 11.5959C8.31312 10.8664 8.32673 10.3635 8.32673 9.14286C8.32673 8.51167 9.07588 8 10 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded3rdBrecket' icon.
  static const List<List<dynamic>> strokeRounded3rdBrecket = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M18 21C19.2322 21 20.231 19.8487 20.231 18.4286C20.231 16.1808 20.1312 14.6865 21.6733 12.9091C22.1089 12.407 22.1089 11.593 21.6733 11.0909C20.1312 9.31354 20.231 7.81916 20.231 5.57143C20.231 4.15127 19.2322 3 18 3',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M6 21C4.76784 21 3.76897 19.8487 3.76897 18.4286C3.76897 16.1808 3.86877 14.6865 2.32673 12.9091C1.89109 12.407 1.89109 11.593 2.32673 11.0909C3.83496 9.35251 3.76897 7.83992 3.76897 5.57143C3.76897 4.15127 4.76784 3 6 3',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded3rdBrecketCircle' icon.
  static const List<List<dynamic>> strokeRounded3rdBrecketCircle = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M14 16C14.9241 16 15.6733 15.4883 15.6733 14.8571C15.6733 13.6365 15.6869 13.1336 16.755 12.4041C17.0817 12.1809 17.0817 11.8191 16.755 11.5959C15.6869 10.8664 15.6733 10.3635 15.6733 9.14286C15.6733 8.51167 14.9241 8 14 8M10 16C9.07588 16 8.32673 15.4883 8.32673 14.8571C8.32673 13.6365 8.31312 13.1336 7.24505 12.4041C6.91832 12.1809 6.91832 11.8191 7.24504 11.5959C8.31312 10.8664 8.32673 10.3635 8.32673 9.14286C8.32673 8.51167 9.07588 8 10 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'circle',
      {
        'key': '1',
        'cx': '12',
        'cy': '12',
        'r': '10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded3rdBrecketSquare' icon.
  static const List<List<dynamic>> strokeRounded3rdBrecketSquare = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M14 16C14.9241 16 15.6733 15.4883 15.6733 14.8571C15.6733 13.6365 15.6869 13.1336 16.755 12.4041C17.0817 12.1809 17.0817 11.8191 16.755 11.5959C15.6869 10.8664 15.6733 10.3635 15.6733 9.14286C15.6733 8.51167 14.9241 8 14 8M10 16C9.07588 16 8.32673 15.4883 8.32673 14.8571C8.32673 13.6365 8.31312 13.1336 7.24505 12.4041C6.91832 12.1809 6.91832 11.8191 7.24504 11.5959C8.31312 10.8664 8.32673 10.3635 8.32673 9.14286C8.32673 8.51167 9.07588 8 10 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded4Circle' icon.
  static const List<List<dynamic>> strokeRounded4Circle = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M15 7V12.5M15 12.5V17M15 12.5H9.43601C9.19521 12.5 9 12.3048 9 12.064C9 12.0216 9.00619 11.9794 9.01839 11.9387L10.5 7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded4K' icon.
  static const List<List<dynamic>> strokeRounded4K = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2 12C2 8.25027 2 6.3754 2.95491 5.06107C3.26331 4.6366 3.6366 4.26331 4.06107 3.95491C5.3754 3 7.25027 3 11 3H13C16.7497 3 18.6246 3 19.9389 3.95491C20.3634 4.26331 20.7367 4.6366 21.0451 5.06107C22 6.3754 22 8.25027 22 12C22 15.7497 22 17.6246 21.0451 18.9389C20.7367 19.3634 20.3634 19.7367 19.9389 20.0451C18.6246 21 16.7497 21 13 21H11C7.25027 21 5.3754 21 4.06107 20.0451C3.6366 19.7367 3.26331 19.3634 2.95491 18.9389C2 17.6246 2 15.7497 2 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M10.6364 9V12M10.6364 12V15M10.6364 12H8.81818C7.96108 12 7.53253 12 7.26627 11.7071C7 11.4142 7 10.9428 7 10V9M13.3636 15V12M13.3636 12V9M13.3636 12L17 9M13.3636 12L17 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded4Square' icon.
  static const List<List<dynamic>> strokeRounded4Square = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.99707 12C2.99707 7.52166 2.99707 5.28249 4.38831 3.89124C5.77956 2.5 8.01873 2.5 12.4971 2.5C16.9754 2.5 19.2146 2.5 20.6058 3.89124C21.9971 5.28249 21.9971 7.52166 21.9971 12C21.9971 16.4783 21.9971 18.7175 20.6058 20.1088C19.2146 21.5 16.9754 21.5 12.4971 21.5C8.01873 21.5 5.77956 21.5 4.38831 20.1088C2.99707 18.7175 2.99707 16.4783 2.99707 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M15.4971 7V12.5M15.4971 12.5V17M15.4971 12.5H9.93308C9.69228 12.5 9.49707 12.3048 9.49707 12.064C9.49707 12.0216 9.50327 11.9794 9.51546 11.9387L10.9971 7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded5Circle' icon.
  static const List<List<dynamic>> strokeRounded5Circle = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M9 15C9 15 9.5 17 12 17C13.6569 17 15 15.7949 15 14C15 12.2051 13.6569 11 12 11C10.3431 11 9 12 9 12L10 7H15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded5Square' icon.
  static const List<List<dynamic>> strokeRounded5Square = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.99707 12C2.99707 7.52166 2.99707 5.28249 4.38831 3.89124C5.77956 2.5 8.01873 2.5 12.4971 2.5C16.9754 2.5 19.2146 2.5 20.6058 3.89124C21.9971 5.28249 21.9971 7.52166 21.9971 12C21.9971 16.4783 21.9971 18.7175 20.6058 20.1088C19.2146 21.5 16.9754 21.5 12.4971 21.5C8.01873 21.5 5.77956 21.5 4.38831 20.1088C2.99707 18.7175 2.99707 16.4783 2.99707 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M9.49707 15C9.49707 15 9.99707 17 12.4971 17C14.1539 17 15.4971 15.7949 15.4971 14C15.4971 12.2051 14.1539 11 12.4971 11C10.8402 11 9.49707 12 9.49707 12L10.4971 7H15.4971',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded6Circle' icon.
  static const List<List<dynamic>> strokeRounded6Circle = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M11 12H13C14.1046 12 15 12.8954 15 14V15C15 16.1046 14.1046 17 13 17H11C9.89543 17 9 16.1046 9 15V14C9 12.8954 9.89543 12 11 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M9 14.5V9C9 7.89543 9.89543 7 11 7H13C14.1046 7 15 7.89543 15 9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded6Square' icon.
  static const List<List<dynamic>> strokeRounded6Square = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.99707 12C2.99707 7.52166 2.99707 5.28249 4.38831 3.89124C5.77956 2.5 8.01873 2.5 12.4971 2.5C16.9754 2.5 19.2146 2.5 20.6058 3.89124C21.9971 5.28249 21.9971 7.52166 21.9971 12C21.9971 16.4783 21.9971 18.7175 20.6058 20.1088C19.2146 21.5 16.9754 21.5 12.4971 21.5C8.01873 21.5 5.77956 21.5 4.38831 20.1088C2.99707 18.7175 2.99707 16.4783 2.99707 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M11.4971 12H13.4971C14.6016 12 15.4971 12.8954 15.4971 14V15C15.4971 16.1046 14.6016 17 13.4971 17H11.4971C10.3925 17 9.49707 16.1046 9.49707 15V14C9.49707 12.8954 10.3925 12 11.4971 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M9.49707 14.5V9C9.49707 7.89543 10.3925 7 11.4971 7H13.4971C14.6016 7 15.4971 7.89543 15.4971 9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded7Circle' icon.
  static const List<List<dynamic>> strokeRounded7Circle = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M9 7H14.584C14.8138 7 15 7.18625 15 7.41599C15 7.47144 14.9889 7.52632 14.9674 7.57742L11 17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded7Square' icon.
  static const List<List<dynamic>> strokeRounded7Square = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.99707 12C2.99707 7.52166 2.99707 5.28249 4.38831 3.89124C5.77956 2.5 8.01873 2.5 12.4971 2.5C16.9754 2.5 19.2146 2.5 20.6058 3.89124C21.9971 5.28249 21.9971 7.52166 21.9971 12C21.9971 16.4783 21.9971 18.7175 20.6058 20.1088C19.2146 21.5 16.9754 21.5 12.4971 21.5C8.01873 21.5 5.77956 21.5 4.38831 20.1088C2.99707 18.7175 2.99707 16.4783 2.99707 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M9.49707 7H15.0811C15.3108 7 15.4971 7.18625 15.4971 7.41599C15.4971 7.47144 15.486 7.52632 15.4645 7.57742L11.4971 17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded7z01' icon.
  static const List<List<dynamic>> strokeRounded7z01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M20 13V10.6569C20 9.83935 20 9.4306 19.8478 9.06306C19.6955 8.69552 19.4065 8.40649 18.8284 7.82843L14.0919 3.09188C13.593 2.593 13.3436 2.34355 13.0345 2.19575C12.9702 2.165 12.9044 2.13772 12.8372 2.11401C12.5141 2 12.1614 2 11.4558 2C8.21082 2 6.58831 2 5.48933 2.88607C5.26731 3.06508 5.06508 3.26731 4.88607 3.48933C4 4.58831 4 6.21082 4 9.45584V13M13 2.5V3C13 5.82843 13 7.24264 13.8787 8.12132C14.7574 9 16.1716 9 19 9H19.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M6 16H10L7 22M14 16H18L14 22H18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded7z02' icon.
  static const List<List<dynamic>> strokeRounded7z02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M20 11C20 10.1825 20 9.4306 19.8478 9.06306C19.6955 8.69552 19.4065 8.40649 18.8284 7.82843L14.0919 3.09188C13.593 2.593 13.3436 2.34355 13.0345 2.19575C12.9702 2.165 12.9044 2.13772 12.8372 2.11401C12.5141 2 12.1614 2 11.4558 2C8.21082 2 6.58831 2 5.48933 2.88607C5.26731 3.06508 5.06508 3.26731 4.88607 3.48933C4 4.58831 4 6.21082 4 9.45584V14C4 17.7712 4 19.6569 5.17157 20.8284C6.34315 22 8.22876 22 12 22H20M13 2.5V3C13 5.82843 13 7.24264 13.8787 8.12132C14.7574 9 16.1716 9 19 9H19.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M11 14H14L12 19M17 14H20L17 19H20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded8Circle' icon.
  static const List<List<dynamic>> strokeRounded8Circle = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12.5 12H11.5M12.5 12C13.8807 12 15 10.8807 15 9.5C15 8.11929 13.8807 7 12.5 7H11.5C10.1193 7 9 8.11929 9 9.5C9 10.8807 10.1193 12 11.5 12M12.5 12C13.8807 12 15 13.1193 15 14.5C15 15.8807 13.8807 17 12.5 17H11.5C10.1193 17 9 15.8807 9 14.5C9 13.1193 10.1193 12 11.5 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded8Square' icon.
  static const List<List<dynamic>> strokeRounded8Square = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.99707 12C2.99707 7.52166 2.99707 5.28249 4.38831 3.89124C5.77956 2.5 8.01873 2.5 12.4971 2.5C16.9754 2.5 19.2146 2.5 20.6058 3.89124C21.9971 5.28249 21.9971 7.52166 21.9971 12C21.9971 16.4783 21.9971 18.7175 20.6058 20.1088C19.2146 21.5 16.9754 21.5 12.4971 21.5C8.01873 21.5 5.77956 21.5 4.38831 20.1088C2.99707 18.7175 2.99707 16.4783 2.99707 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12.9971 12H11.9971M12.9971 12C14.3778 12 15.4971 10.8807 15.4971 9.5C15.4971 8.11929 14.3778 7 12.9971 7H11.9971C10.6164 7 9.49707 8.11929 9.49707 9.5C9.49707 10.8807 10.6164 12 11.9971 12M12.9971 12C14.3778 12 15.4971 13.1193 15.4971 14.5C15.4971 15.8807 14.3778 17 12.9971 17H11.9971C10.6164 17 9.49707 15.8807 9.49707 14.5C9.49707 13.1193 10.6164 12 11.9971 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded9Circle' icon.
  static const List<List<dynamic>> strokeRounded9Circle = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M11 12H13C14.1046 12 15 11.1046 15 10V9C15 7.89543 14.1046 7 13 7H11C9.89543 7 9 7.89543 9 9V10C9 11.1046 9.89543 12 11 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M15 9.5V15C15 16.1046 14.1046 17 13 17H11C9.89543 17 9 16.1046 9 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRounded9Square' icon.
  static const List<List<dynamic>> strokeRounded9Square = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.99707 12C2.99707 7.52166 2.99707 5.28249 4.38831 3.89124C5.77956 2.5 8.01873 2.5 12.4971 2.5C16.9754 2.5 19.2146 2.5 20.6058 3.89124C21.9971 5.28249 21.9971 7.52166 21.9971 12C21.9971 16.4783 21.9971 18.7175 20.6058 20.1088C19.2146 21.5 16.9754 21.5 12.4971 21.5C8.01873 21.5 5.77956 21.5 4.38831 20.1088C2.99707 18.7175 2.99707 16.4783 2.99707 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M11.4971 12H13.4971C14.6016 12 15.4971 11.1046 15.4971 10V9C15.4971 7.89543 14.6016 7 13.4971 7H11.4971C10.3925 7 9.49707 7.89543 9.49707 9V10C9.49707 11.1046 10.3925 12 11.4971 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M15.4971 9.5V15C15.4971 16.1046 14.6016 17 13.4971 17H11.4971C10.3925 17 9.49707 16.1046 9.49707 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// JSON structure for the 'strokeRoundedAbacus' icon.
  static const List<List<dynamic>> strokeRoundedAbacus = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M6 9H9.5M17 9H18M12 8V10M14.5 8V10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M18 15H12M7 15H6M9.5 14V16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAbacus' icon.
  static const List<List<dynamic>> abacus = strokeRoundedAbacus;

  /// JSON structure for the 'strokeRoundedAbsolute' icon.
  static const List<List<dynamic>> strokeRoundedAbsolute = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M17.725 2.5C19.1145 2.65381 20.0498 3.00143 20.7479 3.78705C22 5.19617 22 7.46411 22 12C22 16.5359 22 18.8038 20.7479 20.213C20.0498 20.9986 19.1145 21.3462 17.725 21.5M6.27501 21.5C4.88551 21.3462 3.95021 20.9986 3.25212 20.213C2 18.8038 2 16.5359 2 12C2 7.46411 2 5.19617 3.25212 3.78705C3.95021 3.00143 4.88551 2.65381 6.27501 2.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M7.56055 8.01026C9.09055 7.95026 10.0505 8.04027 10.6505 9.09026C11.2805 10.3503 12.8405 13.8603 13.2305 14.6703C13.6505 15.5403 14.1905 16.1403 16.4105 15.9903',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M16.9998 8C14.7998 7.98571 12.9998 10.7 11.9998 12C10.8998 13.5 9.00977 16.1 7.00977 16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAbsolute' icon.
  static const List<List<dynamic>> absolute = strokeRoundedAbsolute;

  /// JSON structure for the 'strokeRoundedAcceleration' icon.
  static const List<List<dynamic>> strokeRoundedAcceleration = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.49805 18.4138V11.1909C2.49805 9.86228 2.49805 9.19798 3.09674 9.03265C3.69542 8.86733 4.40002 9.33706 5.80922 10.2765L18.5832 18.7926C19.9924 19.732 20.697 20.2018 20.449 20.6009C20.201 21 19.2046 21 17.2117 21H6.37733C4.54862 21 3.63426 21 3.06616 20.6213C2.49805 20.2425 2.49805 19.633 2.49805 18.4138Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M8.49805 11C10.7072 11 12.498 9.20914 12.498 7C12.498 4.79086 10.7072 3 8.49805 3C6.28891 3 4.49805 4.79086 4.49805 7C4.49805 9.20914 6.28891 11 8.49805 11Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M15.502 9.996L21.4055 13.38M21.4055 13.38C21.7255 13.0406 21.1848 12.06 20.7283 10.728M21.4055 13.38C21.1848 13.62 20.4639 13.68 18.7639 13.998',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAcceleration' icon.
  static const List<List<dynamic>> acceleration = strokeRoundedAcceleration;

  /// JSON structure for the 'strokeRoundedAccess' icon.
  static const List<List<dynamic>> strokeRoundedAccess = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M7 2C4.23858 2 2 4.23858 2 7C2 8.85071 3.0055 10.4666 4.5 11.3311V17.8431C4.5 18.6606 4.5 19.0694 4.65224 19.4369C4.80448 19.8045 5.09351 20.0935 5.67157 20.6716L7 22L9.10819 19.8918C9.20542 19.7946 9.25407 19.7459 9.2944 19.6932C9.40031 19.5547 9.46816 19.3909 9.49122 19.218C9.5 19.1522 9.5 19.0834 9.5 18.9459C9.5 18.8346 9.5 18.779 9.4941 18.7249C9.47864 18.5831 9.43303 18.4463 9.36035 18.3236C9.33263 18.2768 9.29924 18.2323 9.23246 18.1433L8 16.5L8.7 15.5667C9.09649 15.038 9.29473 14.7737 9.39737 14.4658C9.5 14.1579 9.5 13.8275 9.5 13.1667V11.3311C10.9945 10.4666 12 8.85071 12 7C12 4.23858 9.76142 2 7 2Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M7 7H7.00898',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M13 14H19C19.9319 14 20.3978 14 20.7654 14.1522C21.2554 14.3552 21.6448 14.7446 21.8478 15.2346C22 15.6022 22 16.0681 22 17C22 17.9319 22 18.3978 21.8478 18.7654C21.6448 19.2554 21.2554 19.6448 20.7654 19.8478C20.3978 20 19.9319 20 19 20H13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M15 5H19C19.9319 5 20.3978 5 20.7654 5.15224C21.2554 5.35523 21.6448 5.74458 21.8478 6.23463C22 6.60218 22 7.06812 22 8C22 8.93188 22 9.39782 21.8478 9.76537C21.6448 10.2554 21.2554 10.6448 20.7654 10.8478C20.3978 11 19.9319 11 19 11H15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAccess' icon.
  static const List<List<dynamic>> access = strokeRoundedAccess;

  /// JSON structure for the 'strokeRoundedAccident' icon.
  static const List<List<dynamic>> strokeRoundedAccident = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M10.0079 9.99999L7.4303 7.95292C7.13015 7.70141 6.98007 7.57565 7.01465 7.44574C7.04923 7.31584 7.24172 7.28229 7.62668 7.21519L8.79963 7.01075C9.24694 6.93279 9.30287 6.81796 9.10361 6.41056L7.86097 3.86982C7.61457 3.36601 7.49137 3.1141 7.6041 3.00757C7.71682 2.90104 7.95921 3.04032 8.44398 3.31887L10.5351 4.52047C10.8954 4.72748 10.9314 4.71654 11.117 4.34334L11.9611 2.64566C12.1808 2.2038 12.2907 1.98288 12.4373 2.00102C12.5839 2.01917 12.6372 2.2603 12.7437 2.74254L13.4246 5.82349C13.5138 6.2273 13.6177 6.28275 13.9978 6.11892L16.2665 5.14122C16.6616 4.97094 16.8592 4.8858 16.9592 4.98397C17.0593 5.08214 16.9794 5.28281 16.8198 5.68416L15.0047 9.99999',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M12.4937 10L11.9937 8.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M6.74495 12.9996L2 12.9996M6.74495 12.9996C7.51333 13.5012 8.15661 13.5697 8.97523 13.986C9.99046 14.58 10.4726 15.5 10.4682 17C10.4682 18 10.598 19.02 10.2819 19.57C9.91993 20.2 7.69654 19.998 7.49669 19.998M6.74495 12.9996C5.72095 12.3312 5.15952 11.0869 4.5321 10.08C3.6602 8.58003 2.46581 8.10003 2.01194 8.00403M7.49669 19.998C7.49669 21.1 6.6905 22 5.49615 22C4.40133 22 3.50557 21.1 3.50557 19.998M7.49669 19.998C7.49669 18.95 6.6905 18 5.49615 18C4.40133 18 3.50557 18.9 3.50557 19.998M3.50557 19.998H2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M17.255 12.997L22 12.997M17.255 12.997C16.4867 13.4987 15.8434 13.5672 15.0247 13.9837C14.0095 14.5779 13.5274 15.4981 13.5318 16.9986C13.5318 17.9989 13.402 19.0191 13.718 19.5693C14.0801 20.1995 16.3034 19.9974 16.5033 19.9974M17.255 12.997C18.279 12.3284 18.8405 11.0837 19.4679 10.0766C20.3398 8.57616 21.5342 8.09603 21.988 8M16.5033 19.9974C16.5033 21.0997 17.3095 22 18.5038 22C19.5986 22 20.4944 21.0997 20.4944 19.9974M16.5033 19.9974C16.5033 18.9491 17.3095 17.9989 18.5038 17.9989C19.5986 17.9989 20.4944 18.8991 20.4944 19.9974M20.4944 19.9974H22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAccident' icon.
  static const List<List<dynamic>> accident = strokeRoundedAccident;

  /// JSON structure for the 'strokeRoundedAccountSetting01' icon.
  static const List<List<dynamic>> strokeRoundedAccountSetting01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M8.49994 16.5C9.19857 15.2923 10.5044 14.4797 11.9999 14.4797C13.4955 14.4797 14.8013 15.2923 15.4999 16.5M14 10C14 11.1046 13.1045 12 12 12C10.8954 12 9.99997 11.1046 9.99997 10C9.99997 8.89543 10.8954 8 12 8C13.1045 8 14 8.89543 14 10Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M22 13.9669V10.0332C19.1433 10.0332 17.2857 6.93041 18.732 4.46691L15.2679 2.5001C13.8038 4.99405 10.1978 4.99395 8.73363 2.5L5.26953 4.46681C6.71586 6.93035 4.85673 10.0332 2 10.0332V13.9669C4.85668 13.9669 6.71425 17.0697 5.26795 19.5332L8.73205 21.5C10.1969 19.0048 13.8046 19.0047 15.2695 21.4999L18.7336 19.5331C17.2874 17.0696 19.1434 13.9669 22 13.9669Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAccountSetting01' icon.
  static const List<List<dynamic>> accountSetting01 =
      strokeRoundedAccountSetting01;

  /// JSON structure for the 'strokeRoundedAccountSetting02' icon.
  static const List<List<dynamic>> strokeRoundedAccountSetting02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M21.3175 7.14139L20.8239 6.28479C20.4506 5.63696 20.264 5.31305 19.9464 5.18388C19.6288 5.05472 19.2696 5.15664 18.5513 5.36048L17.3311 5.70418C16.8725 5.80994 16.3913 5.74994 15.9726 5.53479L15.6357 5.34042C15.2766 5.11043 15.0004 4.77133 14.8475 4.37274L14.5136 3.37536C14.294 2.71534 14.1842 2.38533 13.9228 2.19657C13.6615 2.00781 13.3143 2.00781 12.6199 2.00781H11.5051C10.8108 2.00781 10.4636 2.00781 10.2022 2.19657C9.94085 2.38533 9.83106 2.71534 9.61149 3.37536L9.27753 4.37274C9.12465 4.77133 8.84845 5.11043 8.48937 5.34042L8.15249 5.53479C7.73374 5.74994 7.25259 5.80994 6.79398 5.70418L5.57375 5.36048C4.85541 5.15664 4.49625 5.05472 4.17867 5.18388C3.86109 5.31305 3.67445 5.63696 3.30115 6.28479L2.80757 7.14139C2.45766 7.74864 2.2827 8.05227 2.31666 8.37549C2.35061 8.69871 2.58483 8.95918 3.05326 9.48012L4.0843 10.6328C4.3363 10.9518 4.51521 11.5078 4.51521 12.0077C4.51521 12.5078 4.33636 13.0636 4.08433 13.3827L3.05326 14.5354C2.58483 15.0564 2.35062 15.3168 2.31666 15.6401C2.2827 15.9633 2.45766 16.2669 2.80757 16.8741L3.30114 17.7307C3.67443 18.3785 3.86109 18.7025 4.17867 18.8316C4.49625 18.9608 4.85542 18.8589 5.57377 18.655L6.79394 18.3113C7.25263 18.2055 7.73387 18.2656 8.15267 18.4808L8.4895 18.6752C8.84851 18.9052 9.12464 19.2442 9.2775 19.6428L9.61149 20.6403C9.83106 21.3003 9.94085 21.6303 10.2022 21.8191C10.4636 22.0078 10.8108 22.0078 11.5051 22.0078H12.6199C13.3143 22.0078 13.6615 22.0078 13.9228 21.8191C14.1842 21.6303 14.294 21.3003 14.5136 20.6403L14.8476 19.6428C15.0004 19.2442 15.2765 18.9052 15.6356 18.6752L15.9724 18.4808C16.3912 18.2656 16.8724 18.2055 17.3311 18.3113L18.5513 18.655C19.2696 18.8589 19.6288 18.9608 19.9464 18.8316C20.264 18.7025 20.4506 18.3785 20.8239 17.7307L21.3175 16.8741C21.6674 16.2669 21.8423 15.9633 21.8084 15.6401C21.7744 15.3168 21.5402 15.0564 21.0718 14.5354L20.0407 13.3827C19.7887 13.0636 19.6098 12.5078 19.6098 12.0077C19.6098 11.5078 19.7888 10.9518 20.0407 10.6328L21.0718 9.48012C21.5402 8.95918 21.7744 8.69871 21.8084 8.37549C21.8423 8.05227 21.6674 7.74864 21.3175 7.14139Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M8.49997 16C9.1986 14.7923 10.5044 13.9797 12 13.9797C13.4955 13.9797 14.8013 14.7923 15.5 16M14 9.50002C14 10.6046 13.1046 11.5 12 11.5C10.8954 11.5 10 10.6046 10 9.50002C10 8.39545 10.8954 7.50002 12 7.50002C13.1046 7.50002 14 8.39545 14 9.50002Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAccountSetting02' icon.
  static const List<List<dynamic>> accountSetting02 =
      strokeRoundedAccountSetting02;

  /// JSON structure for the 'strokeRoundedAccountSetting03' icon.
  static const List<List<dynamic>> strokeRoundedAccountSetting03 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M16.3083 4.38394C15.7173 4.38394 15.4217 4.38394 15.1525 4.28405C15.1151 4.27017 15.0783 4.25491 15.042 4.23828C14.781 4.11855 14.5721 3.90959 14.1541 3.49167C13.1922 2.52977 12.7113 2.04882 12.1195 2.00447C12.04 1.99851 11.96 1.99851 11.8805 2.00447C11.2887 2.04882 10.8077 2.52977 9.84585 3.49166C9.42793 3.90959 9.21897 4.11855 8.95797 4.23828C8.92172 4.25491 8.88486 4.27017 8.84747 4.28405C8.57825 4.38394 8.28273 4.38394 7.69171 4.38394H7.58269C6.07478 4.38394 5.32083 4.38394 4.85239 4.85239C4.38394 5.32083 4.38394 6.07478 4.38394 7.58269V7.69171C4.38394 8.28273 4.38394 8.57825 4.28405 8.84747C4.27017 8.88486 4.25491 8.92172 4.23828 8.95797C4.11855 9.21897 3.90959 9.42793 3.49166 9.84585C2.52977 10.8077 2.04882 11.2887 2.00447 11.8805C1.99851 11.96 1.99851 12.04 2.00447 12.1195C2.04882 12.7113 2.52977 13.1922 3.49166 14.1541C3.90959 14.5721 4.11855 14.781 4.23828 15.042C4.25491 15.0783 4.27017 15.1151 4.28405 15.1525C4.38394 15.4217 4.38394 15.7173 4.38394 16.3083V16.4173C4.38394 17.9252 4.38394 18.6792 4.85239 19.1476C5.32083 19.6161 6.07478 19.6161 7.58269 19.6161H7.69171C8.28273 19.6161 8.57825 19.6161 8.84747 19.7159C8.88486 19.7298 8.92172 19.7451 8.95797 19.7617C9.21897 19.8815 9.42793 20.0904 9.84585 20.5083C10.8077 21.4702 11.2887 21.9512 11.8805 21.9955C11.96 22.0015 12.04 22.0015 12.1195 21.9955C12.7113 21.9512 13.1922 21.4702 14.1541 20.5083C14.5721 20.0904 14.781 19.8815 15.042 19.7617C15.0783 19.7451 15.1151 19.7298 15.1525 19.7159C15.4217 19.6161 15.7173 19.6161 16.3083 19.6161H16.4173C17.9252 19.6161 18.6792 19.6161 19.1476 19.1476C19.6161 18.6792 19.6161 17.9252 19.6161 16.4173V16.3083C19.6161 15.7173 19.6161 15.4217 19.7159 15.1525C19.7298 15.1151 19.7451 15.0783 19.7617 15.042C19.8815 14.781 20.0904 14.5721 20.5083 14.1541C21.4702 13.1922 21.9512 12.7113 21.9955 12.1195C22.0015 12.04 22.0015 11.96 21.9955 11.8805C21.9512 11.2887 21.4702 10.8077 20.5083 9.84585C20.0904 9.42793 19.8815 9.21897 19.7617 8.95797C19.7451 8.92172 19.7298 8.88486 19.7159 8.84747C19.6161 8.57825 19.6161 8.28273 19.6161 7.69171V7.58269C19.6161 6.07478 19.6161 5.32083 19.1476 4.85239C18.6792 4.38394 17.9252 4.38394 16.4173 4.38394H16.3083Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M8.5 16.5C9.19863 15.2923 10.5044 14.4797 12 14.4797C13.4956 14.4797 14.8014 15.2923 15.5 16.5M14 10C14 11.1046 13.1046 12 12 12C10.8955 12 10 11.1046 10 10C10 8.89544 10.8955 8.00001 12 8.00001C13.1046 8.00001 14 8.89544 14 10Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAccountSetting03' icon.
  static const List<List<dynamic>> accountSetting03 =
      strokeRoundedAccountSetting03;

  /// JSON structure for the 'strokeRoundedActivity01' icon.
  static const List<List<dynamic>> strokeRoundedActivity01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4.31802 19.682C3 18.364 3 16.2426 3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M7 14L9.79289 11.2071C10.1834 10.8166 10.8166 10.8166 11.2071 11.2071L12.7929 12.7929C13.1834 13.1834 13.8166 13.1834 14.2071 12.7929L17 10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedActivity01' icon.
  static const List<List<dynamic>> activity01 = strokeRoundedActivity01;

  /// JSON structure for the 'strokeRoundedActivity02' icon.
  static const List<List<dynamic>> strokeRoundedActivity02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M21.5 4.5C21.5 5.60457 20.6046 6.5 19.5 6.5C18.3954 6.5 17.5 5.60457 17.5 4.5C17.5 3.39543 18.3954 2.5 19.5 2.5C20.6046 2.5 21.5 3.39543 21.5 4.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M20.4711 9.40577C20.5 10.2901 20.5 11.3119 20.5 12.5C20.5 16.7426 20.5 18.864 19.182 20.182C17.864 21.5 15.7426 21.5 11.5 21.5C7.25736 21.5 5.13604 21.5 3.81802 20.182C2.5 18.864 2.5 16.7426 2.5 12.5C2.5 8.25736 2.5 6.13604 3.81802 4.81802C5.13604 3.5 7.25736 3.5 11.5 3.5C12.6881 3.5 13.7099 3.5 14.5942 3.52895',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M6.5 14.5L9.29289 11.7071C9.68342 11.3166 10.3166 11.3166 10.7071 11.7071L12.2929 13.2929C12.6834 13.6834 13.3166 13.6834 13.7071 13.2929L16.5 10.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedActivity02' icon.
  static const List<List<dynamic>> activity02 = strokeRoundedActivity02;

  /// JSON structure for the 'strokeRoundedActivity03' icon.
  static const List<List<dynamic>> strokeRoundedActivity03 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4.31802 19.682C3 18.364 3 16.2426 3 12C3 7.75736 3 5.63604 4.31802 4.31802C5.63604 3 7.75736 3 12 3C16.2426 3 18.364 3 19.682 4.31802C21 5.63604 21 7.75736 21 12C21 16.2426 21 18.364 19.682 19.682C18.364 21 16.2426 21 12 21C7.75736 21 5.63604 21 4.31802 19.682Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M6 12H8.5L10.5 8L13.5 16L15.5 12H18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedActivity03' icon.
  static const List<List<dynamic>> activity03 = strokeRoundedActivity03;

  /// JSON structure for the 'strokeRoundedActivity04' icon.
  static const List<List<dynamic>> strokeRoundedActivity04 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M21.5 4.5C21.5 5.60457 20.6046 6.5 19.5 6.5C18.3954 6.5 17.5 5.60457 17.5 4.5C17.5 3.39543 18.3954 2.5 19.5 2.5C20.6046 2.5 21.5 3.39543 21.5 4.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M20.4711 9.40577C20.5 10.2901 20.5 11.3119 20.5 12.5C20.5 16.7426 20.5 18.864 19.182 20.182C17.864 21.5 15.7426 21.5 11.5 21.5C7.25736 21.5 5.13604 21.5 3.81802 20.182C2.5 18.864 2.5 16.7426 2.5 12.5C2.5 8.25736 2.5 6.13604 3.81802 4.81802C5.13604 3.5 7.25736 3.5 11.5 3.5C12.6881 3.5 13.7099 3.5 14.5942 3.52895',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M5.5 12.5H8L10 8.5L13 16.5L15 12.5H17.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedActivity04' icon.
  static const List<List<dynamic>> activity04 = strokeRoundedActivity04;

  /// JSON structure for the 'strokeRoundedAcute' icon.
  static const List<List<dynamic>> strokeRoundedAcute = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M10.5958 2.52324C11.3962 2.29824 13.2718 1.82324 13.7721 2.07324M13.7721 2.07324C14.2973 2.39824 14.3973 4.14824 14.5475 4.87324M13.7721 2.07324L3.81773 18.1732C3.81773 18.1732 3.29249 19.0232 3.59264 19.4982C3.81774 20.0232 5.11831 19.9982 5.11831 19.9982H20.5M20.5 19.9982C20.5 19.3982 18.6992 18.1982 18.5241 17.9982M20.5 19.9982C20.5 20.5982 19.0494 21.4482 18.5241 21.9982',
        'stroke': 'currentColor',
        'strokeWidth': '1.45',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M7.49414 12.498C9.36996 12.823 10.8049 13.723 11.6553 15.048C12.6057 16.398 12.7214 18.273 12.1462 19.798',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAcute' icon.
  static const List<List<dynamic>> acute = strokeRoundedAcute;

  /// JSON structure for the 'strokeRoundedAdd01' icon.
  static const List<List<dynamic>> strokeRoundedAdd01 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M12.001 5.00003V19.002',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M19.002 12.002L4.99998 12.002',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAdd01' icon.
  static const List<List<dynamic>> add01 = strokeRoundedAdd01;

  /// JSON structure for the 'strokeRoundedAdd02' icon.
  static const List<List<dynamic>> strokeRoundedAdd02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12.001 20.0088C12.8289 20.0088 13.5 19.3377 13.5 18.5098V13.5068H18.502C19.3295 13.5068 20.0004 12.8363 20.001 12.0088C20.0015 11.1805 19.3302 10.5088 18.502 10.5088H13.5V5.50684C13.5 4.67933 12.8295 4.00835 12.002 4.00781C11.1737 4.00727 10.502 4.67857 10.502 5.50684V10.5088H5.49902C4.67114 10.5088 4 11.1799 4 12.0078C4 12.8357 4.67114 13.5068 5.49902 13.5068H10.502V18.5098C10.502 19.3377 11.1731 20.0088 12.001 20.0088Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAdd02' icon.
  static const List<List<dynamic>> add02 = strokeRoundedAdd02;

  /// JSON structure for the 'strokeRoundedAddCircle' icon.
  static const List<List<dynamic>> strokeRoundedAddCircle = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22C17.5228 22 22 17.5228 22 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M12 8V16M16 12H8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAddCircle' icon.
  static const List<List<dynamic>> addCircle = strokeRoundedAddCircle;

  /// JSON structure for the 'strokeRoundedAddCircleHalfDot' icon.
  static const List<List<dynamic>> strokeRoundedAddCircleHalfDot = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12 2.00012C17.5228 2.00012 22 6.47727 22 12.0001C22 17.523 17.5228 22.0001 12 22.0001C6.47715 22.0001 2 17.523 2 12.0001M8.909 2.48699C7.9 2.8146 6.96135 3.29828 6.12153 3.90953M3.90943 6.12162C3.29806 6.9616 2.81432 7.90044 2.4867 8.90964',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M12 8.00012V16.0001M16 12.0001L8 12.0001',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAddCircleHalfDot' icon.
  static const List<List<dynamic>> addCircleHalfDot =
      strokeRoundedAddCircleHalfDot;

  /// JSON structure for the 'strokeRoundedAddFemale' icon.
  static const List<List<dynamic>> strokeRoundedAddFemale = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M13.5 16V13.845C14.7848 13.6822 15.9696 13.397 17 13.0161C16.6667 12.3602 16 10.4579 16 8.09655C16 5.14483 16 2.68499 13 3.17672C11.5 1.20912 6 1.20919 6 7.11264C6 10.5563 5.5 12.0322 5 13.0161C6.03039 13.397 7.21522 13.6822 8.5 13.845V16L4.78401 17.1177C3.39659 17.5423 2.36593 18.6553 2.02375 20.0099C1.88845 20.5456 2.35107 21 2.90639 21H13.0936',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M18.5 22L18.5 15M15 18.5H22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAddFemale' icon.
  static const List<List<dynamic>> addFemale = strokeRoundedAddFemale;

  /// JSON structure for the 'strokeRoundedAddInvoice' icon.
  static const List<List<dynamic>> strokeRoundedAddInvoice = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12.06 21.5124C11.5445 21.8375 11.2868 22 11 22C10.7132 22 10.4554 21.8374 9.94 21.5124L8.02913 20.3073C7.54415 20.0014 7.30166 19.8485 7.03253 19.8397C6.74172 19.8301 6.49493 19.9768 5.97087 20.3073C5.38395 20.6774 4.21687 21.6971 3.46195 21.2108C3 20.9133 3 20.1575 3 18.6458V8.00002C3 5.17158 3 3.75736 3.82699 2.87868C4.65399 2 5.98501 2 8.64706 2H13.3529C16.015 2 17.346 2 18.173 2.87868C19 3.75736 19 5.17158 19 8.00002V12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M11 11H7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M17 14V22M21 18L13 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M15 7L7 7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAddInvoice' icon.
  static const List<List<dynamic>> addInvoice = strokeRoundedAddInvoice;

  /// JSON structure for the 'strokeRoundedAddMale' icon.
  static const List<List<dynamic>> strokeRoundedAddMale = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M13.5 16.0001V14.0623C15.2808 12.6685 16.5 11 16.5 7.41681C16.5 5.09719 16.0769 3 13.5385 3C13.5385 3 12.6433 2 10.4923 2C7.45474 2 5.5 3.82696 5.5 7.41681C5.5 11 6.71916 12.6686 8.5 14.0623V16.0001L4.78401 17.1179C3.39659 17.5424 2.36593 18.6554 2.02375 20.0101C1.88845 20.5457 2.35107 21.0001 2.90639 21.0001H13.0936',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M18.5 22L18.5 15M15 18.5H22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAddMale' icon.
  static const List<List<dynamic>> addMale = strokeRoundedAddMale;

  /// JSON structure for the 'strokeRoundedAddMoneyCircle' icon.
  static const List<List<dynamic>> strokeRoundedAddMoneyCircle = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M11 9.5H12.5C13.3284 9.5 14 10.1716 14 11M11 9.5H9.5C8.67157 9.5 8 10.1716 8 11V11.5C8 12.3284 8.67157 13 9.5 13H12.5C13.3284 13 14 13.6716 14 14.5V15C14 15.8284 13.3284 16.5 12.5 16.5H11M11 9.5V8M11 16.5H9.5C8.67157 16.5 8 15.8284 8 15M11 16.5V18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12 4.05493C11.6717 4.01863 11.338 4 11 4C6.02944 4 2 8.02944 2 13C2 17.9705 6.02944 22 11 22C15.9705 22 20 17.9705 20 13C20 12.662 19.9814 12.3283 19.9451 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M18.5 2V9M22 5.5L15 5.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAddMoneyCircle' icon.
  static const List<List<dynamic>> addMoneyCircle = strokeRoundedAddMoneyCircle;

  /// JSON structure for the 'strokeRoundedAddSquare' icon.
  static const List<List<dynamic>> strokeRoundedAddSquare = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12.0001C2.5 7.52171 2.5 5.28254 3.89124 3.8913C5.28249 2.50005 7.52166 2.50005 12 2.50005C16.4783 2.50005 18.7175 2.50005 20.1088 3.8913C21.5 5.28254 21.5 7.52171 21.5 12.0001C21.5 16.4784 21.5 18.7176 20.1088 20.1088C18.7175 21.5001 16.4783 21.5001 12 21.5001C7.52166 21.5001 5.28249 21.5001 3.89124 20.1088C2.5 18.7176 2.5 16.4784 2.5 12.0001Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M12 8.00005V16.0001M16 12.0001L8 12.0001',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAddSquare' icon.
  static const List<List<dynamic>> addSquare = strokeRoundedAddSquare;

  /// JSON structure for the 'strokeRoundedAddTeam' icon.
  static const List<List<dynamic>> strokeRoundedAddTeam = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12 7.5C12 9.433 10.433 11 8.5 11C6.567 11 5 9.433 5 7.5C5 5.567 6.567 4 8.5 4C10.433 4 12 5.567 12 7.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M13.5 11C15.433 11 17 9.433 17 7.5C17 5.567 15.433 4 13.5 4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M13.1429 20H3.85714C2.83147 20 2 19.2325 2 18.2857C2 15.9188 4.07868 14 6.64286 14H10.3571C11.4023 14 12.3669 14.3188 13.1429 14.8568',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M19 14V20M22 17L16 17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAddTeam' icon.
  static const List<List<dynamic>> addTeam = strokeRoundedAddTeam;

  /// JSON structure for the 'strokeRoundedAddTeam02' icon.
  static const List<List<dynamic>> strokeRoundedAddTeam02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3 20V17.9704C3 16.7281 3.55927 15.5099 4.68968 14.9946C6.0685 14.3661 7.72212 14 9.5 14C10.7448 14 11.9287 14.1795 13 14.5028',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'circle',
      {
        'key': '1',
        'cx': '9.5',
        'cy': '7.5',
        'r': '3.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M14.5 4.14453C15.9457 4.57481 17 5.91408 17 7.49959C17 9.0851 15.9457 10.4244 14.5 10.8547',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M18 14V20M15 17H21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAddTeam02' icon.
  static const List<List<dynamic>> addTeam02 = strokeRoundedAddTeam02;

  /// JSON structure for the 'strokeRoundedAddToList' icon.
  static const List<List<dynamic>> strokeRoundedAddToList = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3.5 9V14C3.5 17.7712 3.5 19.6569 4.67157 20.8284C5.84315 22 7.72876 22 11.5 22H12.5C16.2712 22 18.1569 22 19.3284 20.8284C20.5 19.6569 20.5 17.7712 20.5 14V10C20.5 6.22876 20.5 4.34315 19.3284 3.17157C18.1569 2 16.2712 2 12.5 2H12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M13.5 17H17.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M13.5 7H17.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M13.5 12H17.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M6.5 16.5C6.5 16.5 7.46758 16.7672 8 18C8 18 9 15 11 14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd':
            'M10 5H3.5M10 5C10 4.15973 7.67332 2.58984 7.08333 2M10 5C10 5.84027 7.67331 7.41016 7.08333 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAddToList' icon.
  static const List<List<dynamic>> addToList = strokeRoundedAddToList;

  /// JSON structure for the 'strokeRoundedAddressBook' icon.
  static const List<List<dynamic>> strokeRoundedAddressBook = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4.5 10C4.5 6.22876 4.5 4.34315 5.67157 3.17157C6.84315 2 8.72876 2 12.5 2H14C17.7712 2 19.6569 2 20.8284 3.17157C22 4.34315 22 6.22876 22 10V14C22 17.7712 22 19.6569 20.8284 20.8284C19.6569 22 17.7712 22 14 22H12.5C8.72876 22 6.84315 22 5.67157 20.8284C4.5 19.6569 4.5 17.7712 4.5 14V10Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M15.25 10.0002V12.5002C15.25 13.3286 15.9216 14.0002 16.75 14.0002C17.5784 14.0002 18.25 13.3286 18.25 12.5002V12C18.25 9.23858 16.0114 7 13.25 7C10.4886 7 8.25 9.23858 8.25 12C8.25 14.7614 10.4886 17 13.25 17C14.3758 17 15.4147 16.6279 16.2505 16M15.25 12.0002C15.25 13.1048 14.3546 14.0002 13.25 14.0002C12.1454 14.0002 11.25 13.1048 11.25 12.0002C11.25 10.8956 12.1454 10.0002 13.25 10.0002C14.3546 10.0002 15.25 10.8956 15.25 12.0002Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M4.5 6L2 6M4.5 12L2 12M4.5 18H2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAddressBook' icon.
  static const List<List<dynamic>> addressBook = strokeRoundedAddressBook;

  /// JSON structure for the 'strokeRoundedAdobeAfterEffect' icon.
  static const List<List<dynamic>> strokeRoundedAdobeAfterEffect = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12 16L11.1339 13.2M6 16L6.86614 13.2M6.86614 13.2L7.59031 10.8589C8.17989 8.95298 8.47468 8 9 8C9.52532 8 9.82011 8.95298 10.4097 10.8589L11.1339 13.2M6.86614 13.2H11.1339',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M14 12.8696V14C14 15.1046 14.8954 16 16 16C16.7429 16 17.3912 15.5949 17.7361 14.9936M14 12.8696V12C14 10.8954 14.8954 10 16 10C17.1046 10 18 10.8954 18 12L18 12.8696H14Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAdobeAfterEffect' icon.
  static const List<List<dynamic>> adobeAfterEffect =
      strokeRoundedAdobeAfterEffect;

  /// JSON structure for the 'strokeRoundedAdobeIllustrator' icon.
  static const List<List<dynamic>> strokeRoundedAdobeIllustrator = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M13 16L12.1339 13.2M7 16L7.86614 13.2M7.86614 13.2L8.59031 10.8589C9.17989 8.95298 9.47468 8 10 8C10.5253 8 10.8201 8.95298 11.4097 10.8589L12.1339 13.2M7.86614 13.2H12.1339',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M16 16V11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M16 8.5V8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAdobeIllustrator' icon.
  static const List<List<dynamic>> adobeIllustrator =
      strokeRoundedAdobeIllustrator;

  /// JSON structure for the 'strokeRoundedAdobeIndesign' icon.
  static const List<List<dynamic>> strokeRoundedAdobeIndesign = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M15 11L15 15C15 16.1026 14.483 16 13.5 16C12.1193 16 11 14.8807 11 13.5C11 12.1193 12.1193 11 13.5 11H15ZM15 11V8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M8 8V16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAdobeIndesign' icon.
  static const List<List<dynamic>> adobeIndesign = strokeRoundedAdobeIndesign;

  /// JSON structure for the 'strokeRoundedAdobePhotoshop' icon.
  static const List<List<dynamic>> strokeRoundedAdobePhotoshop = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M6.5 16V12M6.5 12V9.125C6.5 9.00892 6.5 8.95087 6.50482 8.90198C6.55158 8.42721 6.92721 8.05158 7.40198 8.00482C7.45087 8 7.50892 8 7.625 8H9C10.1046 8 11 8.89543 11 10C11 11.1046 10.1046 12 9 12H6.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M17.4658 11.2225C17.2923 10.5267 16.4782 10 15.5 10C14.3954 10 13.5 10.6716 13.5 11.5C13.5 12.3284 14.3954 13 15.5 13C16.6046 13 17.5 13.6716 17.5 14.5C17.5 15.3284 16.6046 16 15.5 16C14.5183 16 13.7019 15.4696 13.5323 14.77',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAdobePhotoshop' icon.
  static const List<List<dynamic>> adobePhotoshop = strokeRoundedAdobePhotoshop;

  /// JSON structure for the 'strokeRoundedAdobePremier' icon.
  static const List<List<dynamic>> strokeRoundedAdobePremier = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M7 16V12M7 12V8.57143C7 8.21809 7.23449 8 7.57143 8H9C10.1046 8 11 8.89543 11 10C11 11.1046 10.1046 12 9 12H7Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M14 10.5V12.5M14 12.5V16M14 12.5C14.561 11.752 15.0832 10.8199 16 10.5663C16.1547 10.5235 16.3207 10.5 16.5 10.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAdobePremier' icon.
  static const List<List<dynamic>> adobePremier = strokeRoundedAdobePremier;

  /// JSON structure for the 'strokeRoundedAdobeXd' icon.
  static const List<List<dynamic>> strokeRoundedAdobeXd = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M6 8L12 16M6 16L12 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M18 11L18 15C18 16.1026 17.483 16 16.5 16C15.1193 16 14 14.8807 14 13.5C14 12.1193 15.1193 11 16.5 11H18ZM18 11V8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAdobeXd' icon.
  static const List<List<dynamic>> adobeXd = strokeRoundedAdobeXd;

  /// JSON structure for the 'strokeRoundedAdventure' icon.
  static const List<List<dynamic>> strokeRoundedAdventure = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6.56457 19.5607C5.97878 20.1464 5.02903 20.1464 4.44325 19.5607C3.85746 18.9749 3.85746 18.0251 4.44325 17.4393C5.02903 16.8536 5.97878 16.8536 6.56457 17.4393C7.15035 18.0251 7.15035 18.9749 6.56457 19.5607Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M6.00391 12H6.37548C6.90591 12 7.41462 12.2107 7.78969 12.5858L11.4181 16.2142C11.7932 16.5893 12.0039 17.098 12.0039 17.6284V18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M10.5103 15L18.5559 8.37415C18.8887 8.10007 19.1248 7.7264 19.2294 7.30812L19.9938 4.25039C20.0307 4.10291 19.8971 3.96933 19.7496 4.0062L16.6919 4.77063C16.2736 4.8752 15.8999 5.11126 15.6258 5.44407L9 13.4897',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M13.9091 2.89255C12.86 2.29753 12.3355 2.00001 12.0007 2C11.6659 1.99999 11.1413 2.29748 10.0921 2.89247C9.07711 3.46803 8.01375 3.82383 6.97637 4.04312C4.91674 4.47852 3.88691 4.69622 3.44345 5.23327C3 5.77032 3 6.61265 3 8.29731V9.96205M12.0006 22C12.3126 22 12.6246 21.9587 12.9276 21.8762C13.4183 21.7426 13.8799 21.4552 14.8031 20.8804C16.8654 19.5964 17.8965 18.9545 18.6779 18.13C19.643 17.1117 20.3379 15.8876 20.7044 14.5603C20.9539 13.6568 20.9937 12.6829 21 11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M6.5 17.5L9.5 14.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAdventure' icon.
  static const List<List<dynamic>> adventure = strokeRoundedAdventure;

  /// JSON structure for the 'strokeRoundedAdvertisement' icon.
  static const List<List<dynamic>> strokeRoundedAdvertisement = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5.50586 15.9916L8.03146 9.02875C8.49073 8.06222 9.19305 7.26286 9.99777 9.17999C10.7406 10.9497 11.8489 14.1903 12.5031 15.9954M6.65339 13.002H11.3215',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M3.46447 4.31802C2 5.63604 2 7.75736 2 12C2 16.2426 2 18.364 3.46447 19.682C4.92893 21 7.28596 21 12 21C16.714 21 19.0711 21 20.5355 19.682C22 18.364 22 16.2426 22 12C22 7.75736 22 5.63604 20.5355 4.31802C19.0711 3 16.714 3 12 3C7.28596 3 4.92893 3 3.46447 4.31802Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M18.4843 8.98682V11.9815M18.4843 11.9815V15.9252M18.4843 11.9815H16.466C16.2263 11.9815 15.9885 12.0261 15.7645 12.113C14.0707 12.7702 14.0707 15.2124 15.7645 15.8696C15.9885 15.9565 16.2263 16.0011 16.466 16.0011H18.4843',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAdvertisement' icon.
  static const List<List<dynamic>> advertisement = strokeRoundedAdvertisement;

  /// JSON structure for the 'strokeRoundedAdvertisiment' icon.
  static const List<List<dynamic>> strokeRoundedAdvertisiment = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5.50586 16.9916L8.03146 10.0288C8.49073 9.06222 9.19305 8.26286 9.99777 10.18C10.7406 11.9497 11.8489 15.1903 12.5031 16.9954M6.65339 14.002H11.3215',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M3.46447 5.31802C2 6.63604 2 8.75736 2 13C2 17.2426 2 19.364 3.46447 20.682C4.92893 22 7.28596 22 12 22C16.714 22 19.0711 22 20.5355 20.682C22 19.364 22 17.2426 22 13C22 8.75736 22 6.63604 20.5355 5.31802C19.0711 4 16.714 4 12 4C7.28596 4 4.92893 4 3.46447 5.31802Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M18.4843 9.98682V12.9815M18.4843 12.9815V16.9252M18.4843 12.9815H16.466C16.2263 12.9815 15.9885 13.0261 15.7645 13.113C14.0707 13.7702 14.0707 16.2124 15.7645 16.8696C15.9885 16.9565 16.2263 17.0011 16.466 17.0011H18.4843',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAdvertisiment' icon.
  static const List<List<dynamic>> advertisiment = strokeRoundedAdvertisiment;

  /// JSON structure for the 'strokeRoundedAdzan' icon.
  static const List<List<dynamic>> strokeRoundedAdzan = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6.59279 12C2.73603 6.28571 10.1661 4.5 11.9987 2C13.8316 4.5 21.2614 6.28571 17.4021 12H6.59279Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M12 16L12 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M6.5 12V16.2857C6.5 18.9795 6.5 20.3263 7.30546 21.1632C8.11091 22 9.40728 22 12 22C14.5927 22 15.8891 22 16.6945 21.1632C17.5 20.3263 17.5 18.9795 17.5 16.2857V12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M20 14L21 13.5M20 18L21 18.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M4 14L3 13.5M4 18L3 18.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAdzan' icon.
  static const List<List<dynamic>> adzan = strokeRoundedAdzan;

  /// JSON structure for the 'strokeRoundedAffiliate' icon.
  static const List<List<dynamic>> strokeRoundedAffiliate = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M21.9644 4.50615C21.9644 4.50615 22.1405 2.72142 21.7095 2.29048M21.7095 2.29048C21.276 1.85699 19.4941 2.0371 19.4941 2.0371M21.7095 2.29048L19 4.99997',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M21.9644 19.4938C21.9644 19.4938 22.1405 21.2785 21.7095 21.7095M21.7095 21.7095C21.276 22.143 19.4941 21.9629 19.4941 21.9629M21.7095 21.7095L19 19',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M2.29048 2.29047L5 4.99997M2.29048 2.29047C2.72397 1.85699 4.50593 2.0371 4.50593 2.0371M2.29048 2.29047C1.85953 2.72142 2.03561 4.50614 2.03561 4.50614',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M2.29048 21.7095L5 19M2.29048 21.7095C2.72397 22.143 4.50593 21.9629 4.50593 21.9629M2.29048 21.7095C1.85953 21.2786 2.03561 19.4939 2.03561 19.4939',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M19 12C19 15.866 15.866 19 12 19C8.13401 19 5 15.866 5 12C5 8.13401 8.13401 5 12 5C15.866 5 19 8.13401 19 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd':
            'M11.914 9.30127C10.8094 9.30127 10 9.94342 10 10.6887C10 11.4339 10.5219 11.8999 12 11.8999C13.6282 11.8999 14 12.6423 14 13.3875C14 14.1328 13.2883 14.7214 11.914 14.7214M11.914 9.30127C12.7848 9.30127 13.2451 9.60613 13.6086 10.0165M11.914 9.30127V8.45703M11.914 14.7214C11.0432 14.7214 10.7046 14.5494 10.225 14.1154M11.914 14.7214V15.5088',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAffiliate' icon.
  static const List<List<dynamic>> affiliate = strokeRoundedAffiliate;

  /// JSON structure for the 'strokeRoundedAgreement01' icon.
  static const List<List<dynamic>> strokeRoundedAgreement01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2 7H4.86503C5.59174 7 6.28868 6.64031 6.80255 6.00005C7.53643 5.08565 8.62195 4.76636 9.60655 5.17529L11 5.75402M2 15.9668H3.62068C4.78017 15.9668 5.35991 15.9668 5.90812 16.1213C5.93477 16.1288 5.96134 16.1366 5.98782 16.1446C6.53259 16.3101 7.01496 16.6209 7.97971 17.2427C9.86787 18.4596 10.812 19.0681 11.8407 18.994C11.8892 18.9905 11.9376 18.9858 11.9859 18.9801C13.0096 18.8577 13.8119 18.0821 15.4166 16.5308L17 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M22 7.23384H19.4832C18.4174 7.23384 17.6649 6.65468 16.9003 5.88258C16.4051 5.38247 15.7731 5.08772 15.1088 5.04713C14.366 5.00175 13.5053 4.93785 12.784 5.13601C11.9811 5.35656 11.451 5.96063 10.8902 6.59196L9.44309 8.22111C8.8523 8.88621 8.8523 9.96455 9.44309 10.6297C9.953 11.2037 10.7519 11.2928 11.3519 10.8424C11.7837 10.5184 12.2743 9.99506 12.7831 9.83025C13.3557 9.64476 13.7109 10.0615 14.0354 10.4999L16.3556 13.6344C17.2167 14.7976 17.6472 15.3793 18.2358 15.6896C18.8244 16 19.4969 16 20.842 16H22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAgreement01' icon.
  static const List<List<dynamic>> agreement01 = strokeRoundedAgreement01;

  /// JSON structure for the 'strokeRoundedAgreement02' icon.
  static const List<List<dynamic>> strokeRoundedAgreement02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M22 6.75003H19.2111C18.61 6.75003 18.3094 6.75003 18.026 6.66421C17.7426 6.5784 17.4925 6.41168 16.9923 6.07823C16.2421 5.57806 15.3862 5.00748 14.961 4.87875C14.5359 4.75003 14.085 4.75003 13.1833 4.75003C11.9571 4.75003 11.1667 4.75003 10.6154 4.97839C10.0641 5.20675 9.63056 5.6403 8.76347 6.50739L8.00039 7.27047C7.80498 7.46588 7.70727 7.56359 7.64695 7.66005C7.42335 8.01764 7.44813 8.47708 7.70889 8.80854C7.77924 8.89796 7.88689 8.98459 8.10218 9.15785C8.89796 9.79827 10.0452 9.73435 10.7658 9.00945L12 7.76789H13L19 13.8036C19.5523 14.3592 19.5523 15.2599 19 15.8155C18.4477 16.3711 17.5523 16.3711 17 15.8155L16.5 15.3125M13.5 12.2947L16.5 15.3125M16.5 15.3125C17.0523 15.8681 17.0523 16.7689 16.5 17.3244C15.9477 17.88 15.0523 17.88 14.5 17.3244L13.5 16.3185M13.5 16.3185C14.0523 16.874 14.0523 17.7748 13.5 18.3304C12.9477 18.8859 12.0523 18.8859 11.5 18.3304L10 16.8214M13.5 16.3185L11.5 14.3185M9.5 16.3185L10 16.8214M10 16.8214C10.5523 17.377 10.5523 18.2778 10 18.8334C9.44772 19.3889 8.55229 19.3889 8 18.8334L5.17637 15.9509C4.59615 15.3586 4.30604 15.0625 3.93435 14.9062C3.56266 14.75 3.14808 14.75 2.31894 14.75H2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M22 14.75H19.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M8.5 6.75003L2 6.75003',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAgreement02' icon.
  static const List<List<dynamic>> agreement02 = strokeRoundedAgreement02;

  /// JSON structure for the 'strokeRoundedAgreement03' icon.
  static const List<List<dynamic>> strokeRoundedAgreement03 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M9 22C9.35984 22 10.6908 21.3926 12.0494 20.1778M12.0494 20.1778C13.2078 19.1419 14.3863 17.6643 15 15.7452C16.3333 11.5753 8.33333 15.7452 11 19.2201C11.3281 19.6476 11.6815 19.9601 12.0494 20.1778ZM12.0494 20.1778C13.6521 21.1259 15.5311 20.274 16.8041 19.2944C17.1932 18.995 17.3877 18.8453 17.5038 18.8919C17.62 18.9385 17.6878 19.2064 17.8236 19.7422C18.2581 21.4569 19.5415 22.841 21 20.6105',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M20 13L20 7.89072C20 6.17637 20 5.31919 19.732 4.63459C19.3013 3.53399 18.3902 2.66585 17.2352 2.25535C16.5168 2 15.6173 2 13.8182 2C10.6698 2 9.09563 2 7.83836 2.44686C5.81714 3.16523 4.22281 4.68448 3.46894 6.61052C3 7.80859 3 9.30864 3 12.3088L3 14.8859C3 17.9936 3 19.5474 3.8477 20.6265C4.09058 20.9356 4.37862 21.2101 4.70307 21.4416C5.07016 21.7034 5.48961 21.8804 6 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M3 12C3 10.159 4.49238 8.66667 6.33333 8.66667C6.99912 8.66667 7.78404 8.78333 8.43137 8.60988C9.00652 8.45576 9.45576 8.00652 9.60988 7.43136C9.78333 6.78404 9.66667 5.99912 9.66667 5.33333C9.66667 3.49238 11.1591 2 13 2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAgreement03' icon.
  static const List<List<dynamic>> agreement03 = strokeRoundedAgreement03;

  /// JSON structure for the 'strokeRoundedAiAudio' icon.
  static const List<List<dynamic>> strokeRoundedAiAudio = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M11.5 6C7.02166 6 4.78249 6 3.39124 7.17157C2 8.34315 2 10.2288 2 14C2 17.7712 2 19.6569 3.39124 20.8284C4.78249 22 7.02166 22 11.5 22C15.9783 22 18.2175 22 19.6088 20.8284C21 19.6569 21 17.7712 21 14C21 12.8302 21 11.8419 20.9585 11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18.5 2L18.7579 2.69703C19.0961 3.61102 19.2652 4.06802 19.5986 4.40139C19.932 4.73477 20.389 4.90387 21.303 5.24208L22 5.5L21.303 5.75792C20.389 6.09613 19.932 6.26524 19.5986 6.59861C19.2652 6.93198 19.0961 7.38898 18.7579 8.30297L18.5 9L18.2421 8.30297C17.9039 7.38898 17.7348 6.93198 17.4014 6.59861C17.068 6.26524 16.611 6.09613 15.697 5.75792L15 5.5L15.697 5.24208C16.611 4.90387 17.068 4.73477 17.4014 4.40139C17.7348 4.06802 17.9039 3.61102 18.2421 2.69703L18.5 2Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 10V18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M9 12V16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M6 13V15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M15 12V16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd': 'M18 13V15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiAudio' icon.
  static const List<List<dynamic>> aiAudio = strokeRoundedAiAudio;

  /// JSON structure for the 'strokeRoundedAiBeautify' icon.
  static const List<List<dynamic>> strokeRoundedAiBeautify = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M14 12.6483L16.3708 10.2775C16.6636 9.98469 16.81 9.83827 16.8883 9.68032C17.0372 9.3798 17.0372 9.02696 16.8883 8.72644C16.81 8.56849 16.6636 8.42207 16.3708 8.12923C16.0779 7.83638 15.9315 7.68996 15.7736 7.61169C15.473 7.46277 15.1202 7.46277 14.8197 7.61169C14.6617 7.68996 14.5153 7.83638 14.2225 8.12923L11.8517 10.5M14 12.6483L5.77754 20.8708C5.4847 21.1636 5.33827 21.31 5.18032 21.3883C4.8798 21.5372 4.52696 21.5372 4.22644 21.3883C4.06849 21.31 3.92207 21.1636 3.62923 20.8708C3.33639 20.5779 3.18996 20.4315 3.11169 20.2736C2.96277 19.973 2.96277 19.6202 3.11169 19.3197C3.18996 19.1617 3.33639 19.0153 3.62923 18.7225L11.8517 10.5M14 12.6483L11.8517 10.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M19.5 2.5L19.3895 2.79873C19.2445 3.19044 19.172 3.38629 19.0292 3.52917C18.8863 3.67204 18.6904 3.74452 18.2987 3.88946L18 4L18.2987 4.11054C18.6904 4.25548 18.8863 4.32796 19.0292 4.47083C19.172 4.61371 19.2445 4.80956 19.3895 5.20127L19.5 5.5L19.6105 5.20127C19.7555 4.80956 19.828 4.61371 19.9708 4.47083C20.1137 4.32796 20.3096 4.25548 20.7013 4.11054L21 4L20.7013 3.88946C20.3096 3.74452 20.1137 3.67204 19.9708 3.52917C19.828 3.38629 19.7555 3.19044 19.6105 2.79873L19.5 2.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M19.5 12.5L19.3895 12.7987C19.2445 13.1904 19.172 13.3863 19.0292 13.5292C18.8863 13.672 18.6904 13.7445 18.2987 13.8895L18 14L18.2987 14.1105C18.6904 14.2555 18.8863 14.328 19.0292 14.4708C19.172 14.6137 19.2445 14.8096 19.3895 15.2013L19.5 15.5L19.6105 15.2013C19.7555 14.8096 19.828 14.6137 19.9708 14.4708C20.1137 14.328 20.3096 14.2555 20.7013 14.1105L21 14L20.7013 13.8895C20.3096 13.7445 20.1137 13.672 19.9708 13.5292C19.828 13.3863 19.7555 13.1904 19.6105 12.7987L19.5 12.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M10.5 2.5L10.3895 2.79873C10.2445 3.19044 10.172 3.38629 10.0292 3.52917C9.88629 3.67204 9.69044 3.74452 9.29873 3.88946L9 4L9.29873 4.11054C9.69044 4.25548 9.88629 4.32796 10.0292 4.47083C10.172 4.61371 10.2445 4.80956 10.3895 5.20127L10.5 5.5L10.6105 5.20127C10.7555 4.80956 10.828 4.61371 10.9708 4.47083C11.1137 4.32796 11.3096 4.25548 11.7013 4.11054L12 4L11.7013 3.88946C11.3096 3.74452 11.1137 3.67204 10.9708 3.52917C10.828 3.38629 10.7555 3.19044 10.6105 2.79873L10.5 2.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiBeautify' icon.
  static const List<List<dynamic>> aiBeautify = strokeRoundedAiBeautify;

  /// JSON structure for the 'strokeRoundedAiBook' icon.
  static const List<List<dynamic>> strokeRoundedAiBook = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M20.5 16.9286V10C20.5 6.22876 20.5 4.34315 19.3284 3.17157C18.1569 2 16.2712 2 12.5 2H11.5C7.72876 2 5.84315 2 4.67157 3.17157C3.5 4.34315 3.5 6.22876 3.5 10V19.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M20.5 17H6C4.61929 17 3.5 18.1193 3.5 19.5C3.5 20.8807 4.61929 22 6 22H20.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M20.5 22C19.1193 22 18 20.8807 18 19.5C18 18.1193 19.1193 17 20.5 17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M12.3077 12L10.847 7.47891C10.7552 7.19466 10.4734 7 10.1538 7C9.83425 7 9.55249 7.19466 9.46066 7.47891L8 12M15 7V12M8.53846 10.5H11.7692',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiBook' icon.
  static const List<List<dynamic>> aiBook = strokeRoundedAiBook;

  /// JSON structure for the 'strokeRoundedAiBrain01' icon.
  static const List<List<dynamic>> strokeRoundedAiBrain01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M7 4.5C5.34315 4.5 4 5.84315 4 7.5C4 8.06866 4.15822 8.60037 4.43304 9.0535C3.04727 9.31855 2 10.537 2 12C2 13.463 3.04727 14.6814 4.43304 14.9465M7 4.5C7 3.11929 8.11929 2 9.5 2C10.8807 2 12 3.11929 12 4.5V19.5C12 20.8807 10.8807 22 9.5 22C8.11929 22 7 20.8807 7 19.5C5.34315 19.5 4 18.1569 4 16.5C4 15.9313 4.15822 15.3996 4.43304 14.9465M7 4.5C7 5.31791 7.39278 6.04408 8 6.50018M4.43304 14.9465C4.78948 14.3588 5.34207 13.9032 6 13.6707',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M17 19.4999C18.6569 19.4999 20 18.1567 20 16.4999C20 15.9312 19.8418 15.3995 19.567 14.9464C20.9527 14.6813 22 13.4629 22 11.9999C22 10.5369 20.9527 9.31843 19.567 9.05338M17 19.4999C17 20.8806 15.8807 21.9999 14.5 21.9999C13.1193 21.9999 12 20.8806 12 19.4999L12 4.49988C12 3.11917 13.1193 1.99988 14.5 1.99988C15.8807 1.99988 17 3.11917 17 4.49988C18.6569 4.49988 20 5.84302 20 7.49988C20 8.06854 19.8418 8.60024 19.567 9.05338M17 19.4999C17 18.682 16.6072 17.9558 16 17.4997M19.567 9.05338C19.2105 9.64109 18.6579 10.0966 18 10.3292',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiBrain01' icon.
  static const List<List<dynamic>> aiBrain01 = strokeRoundedAiBrain01;

  /// JSON structure for the 'strokeRoundedAiBrain02' icon.
  static const List<List<dynamic>> strokeRoundedAiBrain02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12 4.49988C12 3.11917 10.8807 1.99988 9.5 1.99988C8.11929 1.99988 7 3.11917 7 4.49988C5.34315 4.49988 4 5.84303 4 7.49988C4 8.06854 4.15822 8.60025 4.43304 9.05338C3.04727 9.31843 2 10.5369 2 11.9999C2 13.4629 3.04727 14.6813 4.43304 14.9464C4.15822 15.3995 4 15.9312 4 16.4999C4 18.1568 5.34315 19.4999 7 19.4999C7 20.8806 8.11929 21.9999 9.5 21.9999C10.8807 21.9999 12 20.8806 12 19.4999',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12 19.4999C12 20.8806 13.1193 21.9999 14.5 21.9999C15.8807 21.9999 17 20.8806 17 19.4999C18.6569 19.4999 20 18.1568 20 16.4999C20 15.9312 19.8418 15.3995 19.567 14.9464C20.9527 14.6813 22 13.4629 22 11.9999C22 10.5369 20.9527 9.31843 19.567 9.05338C19.8418 8.60025 20 8.06854 20 7.49988C20 5.84303 18.6569 4.49988 17 4.49988C17 3.11917 15.8807 1.99988 14.5 1.99988C13.1193 1.99988 12 3.11917 12 4.49988',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M10.487 7.00085V8.97987M7 10.5012H9.05198M15.0231 10.5012H17.075M15.0231 13.4745H17.075M7 13.4745H9.05198M10.487 15.0201V16.9991M13.5125 15.0201V16.9991M13.5017 7.00085V8.97987M10.052 14.9684H14.0231C14.5753 14.9684 15.0231 14.5207 15.0231 13.9684V9.97987C15.0231 9.42759 14.5753 8.97987 14.0231 8.97987H10.052C9.49969 8.97987 9.05198 9.42759 9.05198 9.97987V13.9684C9.05198 14.5207 9.49969 14.9684 10.052 14.9684Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiBrain02' icon.
  static const List<List<dynamic>> aiBrain02 = strokeRoundedAiBrain02;

  /// JSON structure for the 'strokeRoundedAiBrain03' icon.
  static const List<List<dynamic>> strokeRoundedAiBrain03 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4 16.4999C4 18.1567 5.34315 19.4999 7 19.4999C7 20.8806 8.11929 21.9999 9.5 21.9999C10.8807 21.9999 12 20.8806 12 19.4999C12 20.8806 13.1193 21.9998 14.5 21.9998C15.8807 21.9998 17 20.8805 17 19.4998C18.6569 19.4998 20 18.1566 20 16.4998C20 15.9311 19.8418 15.3994 19.567 14.9463C20.9527 14.6812 22 13.4628 22 11.9998C22 10.5367 20.9527 9.31831 19.567 9.05325C19.8418 8.60012 20 8.06842 20 7.49976C20 5.8429 18.6569 4.49976 17 4.49976C17 3.11904 15.8807 1.99976 14.5 1.99976C13.1193 1.99976 12 3.11914 12 4.49985C12 3.11914 10.8807 1.99985 9.5 1.99985C8.11929 1.99985 7 3.11914 7 4.49985C5.34315 4.49985 4 5.843 4 7.49985C4 8.06851 4.15822 8.60022 4.43304 9.05335C3.04727 9.3184 2 10.5368 2 11.9999C2 13.4629 3.04727 14.6813 4.43304 14.9464C4.15822 15.3995 4 15.9312 4 16.4999Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M7.5 14.4999L9.34189 8.97422C9.43631 8.69095 9.7014 8.49988 10 8.49988C10.2986 8.49988 10.5637 8.69095 10.6581 8.97422L12.5 14.4999M15.5 8.49988V14.4999M8.5 12.4999H11.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiBrain03' icon.
  static const List<List<dynamic>> aiBrain03 = strokeRoundedAiBrain03;

  /// JSON structure for the 'strokeRoundedAiBrain04' icon.
  static const List<List<dynamic>> strokeRoundedAiBrain04 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M7 4.5C5.34315 4.5 4 5.84315 4 7.5C4 8.06866 4.15822 8.60037 4.43304 9.0535C3.04727 9.31855 2 10.537 2 12C2 13.463 3.04727 14.6814 4.43304 14.9465M7 4.5C7 3.11929 8.11929 2 9.5 2C10.8807 2 12 3.11929 12 4.5V19.5C12 20.8807 10.8807 22 9.5 22C8.11929 22 7 20.8807 7 19.5C5.34315 19.5 4 18.1569 4 16.5C4 15.9313 4.15822 15.3996 4.43304 14.9465M7 4.5C7 5.31791 7.39278 6.04408 8 6.50018M4.43304 14.9465C4.78948 14.3588 5.34207 13.9032 6 13.6707',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M19.25 4.74976L17 6.99976H15M18.5 4.74976C18.5 5.16397 18.8358 5.49976 19.25 5.49976C19.6642 5.49976 20 5.16397 20 4.74976C20 4.33554 19.6642 3.99976 19.25 3.99976C18.8358 3.99976 18.5 4.33554 18.5 4.74976Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M19.25 19.2498L17 16.9998H15M18.5 19.2498C18.5 18.8355 18.8358 18.4998 19.25 18.4998C19.6642 18.4998 20 18.8355 20 19.2498C20 19.664 19.6642 19.9998 19.25 19.9998C18.8358 19.9998 18.5 19.664 18.5 19.2498Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M19.25 11.9998H15M18.5 11.9998C18.5 12.414 18.8358 12.7498 19.25 12.7498C19.6642 12.7498 20 12.414 20 11.9998C20 11.5855 19.6642 11.2498 19.25 11.2498C18.8358 11.2498 18.5 11.5855 18.5 11.9998Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiBrain04' icon.
  static const List<List<dynamic>> aiBrain04 = strokeRoundedAiBrain04;

  /// JSON structure for the 'strokeRoundedAiBrain05' icon.
  static const List<List<dynamic>> strokeRoundedAiBrain05 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M7.5 4.50012C5.84315 4.50012 4.5 5.84327 4.5 7.50012C4.5 8.06878 4.65822 8.60049 4.93304 9.05362C3.54727 9.31868 2.5 10.5371 2.5 12.0001C2.5 13.4631 3.54727 14.6816 4.93304 14.9466M7.5 4.50012C7.5 3.11941 8.61929 2.00012 10 2.00012C11.3807 2.00012 12.5 3.11941 12.5 4.50012V6.00012M7.5 4.50012C7.5 5.31803 7.89278 6.0442 8.5 6.50031M4.93304 14.9466C4.65822 15.3998 4.5 15.9315 4.5 16.5001C4.5 18.157 5.84315 19.5001 7.5 19.5001C7.5 20.8808 8.61929 22.0001 10 22.0001C11.3807 22.0001 12.5 20.8808 12.5 19.5001V18.0001M4.93304 14.9466C5.28948 14.3589 5.84207 13.9034 6.5 13.6708',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M17.5 9H15.5C14.5572 9 14.0858 9 13.7929 9.29289C13.5 9.58579 13.5 10.0572 13.5 11V13C13.5 13.9428 13.5 14.4142 13.7929 14.7071C14.0858 15 14.5572 15 15.5 15H17.5C18.4428 15 18.9142 15 19.2071 14.7071C19.5 14.4142 19.5 13.9428 19.5 13V11C19.5 10.0572 19.5 9.58579 19.2071 9.29289C18.9142 9 18.4428 9 17.5 9Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M15 15V17M18 15V17M15 7V9M18 7V9M13.5 10.5H11.5M13.5 13.5H11.5M21.5 10.5H19.5M21.5 13.5H19.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiBrain05' icon.
  static const List<List<dynamic>> aiBrain05 = strokeRoundedAiBrain05;

  /// JSON structure for the 'strokeRoundedAiBrowser' icon.
  static const List<List<dynamic>> strokeRoundedAiBrowser = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M20.9977 13C21 12.5299 21 12.0307 21 11.5C21 7.02166 21 4.78249 19.6088 3.39124C18.2175 2 15.9783 2 11.5 2C7.02166 2 4.78249 2 3.39124 3.39124C2 4.78249 2 7.02166 2 11.5C2 15.9783 2 18.2175 3.39124 19.6088C4.78249 21 7.02166 21 11.5 21C12.0307 21 12.5299 21 13 20.9977',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18.5 15L18.7579 15.697C19.0961 16.611 19.2652 17.068 19.5986 17.4014C19.932 17.7348 20.389 17.9039 21.303 18.2421L22 18.5L21.303 18.7579C20.389 19.0961 19.932 19.2652 19.5986 19.5986C19.2652 19.932 19.0961 20.389 18.7579 21.303L18.5 22L18.2421 21.303C17.9039 20.389 17.7348 19.932 17.4014 19.5986C17.068 19.2652 16.611 19.0961 15.697 18.7579L15 18.5L15.697 18.2421C16.611 17.9039 17.068 17.7348 17.4014 17.4014C17.7348 17.068 17.9039 16.611 18.2421 15.697L18.5 15Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M2 9H21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M6.49981 5.5H6.50879',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M10.4998 5.5H10.5088',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiBrowser' icon.
  static const List<List<dynamic>> aiBrowser = strokeRoundedAiBrowser;

  /// JSON structure for the 'strokeRoundedAiChat01' icon.
  static const List<List<dynamic>> strokeRoundedAiChat01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M14.1706 20.8905C18.3536 20.6125 21.6856 17.2332 21.9598 12.9909C22.0134 12.1607 22.0134 11.3009 21.9598 10.4707C21.6856 6.22838 18.3536 2.84913 14.1706 2.57107C12.7435 2.47621 11.2536 2.47641 9.8294 2.57107C5.64639 2.84913 2.31441 6.22838 2.04024 10.4707C1.98659 11.3009 1.98659 12.1607 2.04024 12.9909C2.1401 14.536 2.82343 15.9666 3.62791 17.1746C4.09501 18.0203 3.78674 19.0758 3.30021 19.9978C2.94941 20.6626 2.77401 20.995 2.91484 21.2351C3.05568 21.4752 3.37026 21.4829 3.99943 21.4982C5.24367 21.5285 6.08268 21.1757 6.74868 20.6846C7.1264 20.4061 7.31527 20.2668 7.44544 20.2508C7.5756 20.2348 7.83177 20.3403 8.34401 20.5513C8.8044 20.7409 9.33896 20.8579 9.8294 20.8905C11.2536 20.9852 12.7435 20.9854 14.1706 20.8905Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M10.487 7.00098V8.98M7 10.5014H9.05198M15.0231 10.5014H17.075M15.0231 13.4746H17.075M7 13.4746H9.05198M10.487 15.0202V16.9992M13.5125 15.0202V16.9992M13.5017 7.00098V8.98M10.052 14.9685H14.0231C14.5753 14.9685 15.0231 14.5208 15.0231 13.9685V9.98C15.0231 9.42771 14.5753 8.98 14.0231 8.98H10.052C9.49969 8.98 9.05198 9.42771 9.05198 9.98V13.9685C9.05198 14.5208 9.49969 14.9685 10.052 14.9685Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiChat01' icon.
  static const List<List<dynamic>> aiChat01 = strokeRoundedAiChat01;

  /// JSON structure for the 'strokeRoundedAiChat02' icon.
  static const List<List<dynamic>> strokeRoundedAiChat02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M14.1706 20.8905C18.3536 20.6125 21.6856 17.2332 21.9598 12.9909C22.0134 12.1607 22.0134 11.3009 21.9598 10.4707C21.6856 6.22838 18.3536 2.84913 14.1706 2.57107C12.7435 2.47621 11.2536 2.47641 9.8294 2.57107C5.64639 2.84913 2.31441 6.22838 2.04024 10.4707C1.98659 11.3009 1.98659 12.1607 2.04024 12.9909C2.1401 14.536 2.82343 15.9666 3.62791 17.1746C4.09501 18.0203 3.78674 19.0758 3.30021 19.9978C2.94941 20.6626 2.77401 20.995 2.91484 21.2351C3.05568 21.4752 3.37026 21.4829 3.99943 21.4982C5.24367 21.5285 6.08268 21.1757 6.74868 20.6846C7.1264 20.4061 7.31527 20.2668 7.44544 20.2508C7.5756 20.2348 7.83177 20.3403 8.34401 20.5513C8.8044 20.7409 9.33896 20.8579 9.8294 20.8905C11.2536 20.9852 12.7435 20.9854 14.1706 20.8905Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M7.5 15L9.34189 9.47434C9.43631 9.19107 9.7014 9 10 9C10.2986 9 10.5637 9.19107 10.6581 9.47434L12.5 15M15.5 9V15M8.5 13H11.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiChat02' icon.
  static const List<List<dynamic>> aiChat02 = strokeRoundedAiChat02;

  /// JSON structure for the 'strokeRoundedAiChemistry01' icon.
  static const List<List<dynamic>> strokeRoundedAiChemistry01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M13.5 18C13.5 20.2091 11.7091 22 9.5 22C7.29086 22 5.5 20.2091 5.5 18V2H13.5V10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M16 10.5L15.7421 11.197C15.4039 12.111 15.2348 12.568 14.9014 12.9014C14.568 13.2348 14.111 13.4039 13.197 13.7421L12.5 14L13.197 14.2579C14.111 14.5961 14.568 14.7652 14.9014 15.0986C15.2348 15.432 15.4039 15.889 15.7421 16.803L16 17.5L16.2579 16.803C16.5961 15.889 16.7652 15.432 17.0986 15.0986C17.432 14.7652 17.889 14.5961 18.803 14.2579L19.5 14L18.803 13.7421C17.889 13.4039 17.432 13.2348 17.0986 12.9014C16.7652 12.568 16.5961 12.111 16.2579 11.197L16 10.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M4.5 2H14.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M5.5 8H13.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiChemistry01' icon.
  static const List<List<dynamic>> aiChemistry01 = strokeRoundedAiChemistry01;

  /// JSON structure for the 'strokeRoundedAiChemistry02' icon.
  static const List<List<dynamic>> strokeRoundedAiChemistry02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M14.9999 22H6.40749C5.0778 22 3.99988 20.9221 3.99988 19.5924C3.99988 19.2033 4.09419 18.8199 4.27475 18.4752L9.49988 8.5V2H14.4999V8.5L16.4999 12.3181',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M7.99994 2H15.9999',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M7.99994 11.5H15.9999',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M18.4999 15L18.242 15.697C17.9038 16.611 17.7347 17.068 17.4013 17.4014C17.068 17.7348 16.611 17.9039 15.697 18.2421L14.9999 18.5L15.697 18.7579C16.611 19.0961 17.068 19.2652 17.4013 19.5986C17.7347 19.932 17.9038 20.389 18.242 21.303L18.4999 22L18.7579 21.303C19.0961 20.389 19.2652 19.932 19.5985 19.5986C19.9319 19.2652 20.3889 19.0961 21.3029 18.7579L21.9999 18.5L21.3029 18.2421C20.3889 17.9039 19.9319 17.7348 19.5985 17.4014C19.2652 17.068 19.0961 16.611 18.7579 15.697L18.4999 15Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiChemistry02' icon.
  static const List<List<dynamic>> aiChemistry02 = strokeRoundedAiChemistry02;

  /// JSON structure for the 'strokeRoundedAiChemistry03' icon.
  static const List<List<dynamic>> strokeRoundedAiChemistry03 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M6.5 2H14.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M17.5 15L17.2421 15.697C16.9039 16.611 16.7348 17.068 16.4014 17.4014C16.068 17.7348 15.611 17.9039 14.697 18.2421L14 18.5L14.697 18.7579C15.611 19.0961 16.068 19.2652 16.4014 19.5986C16.7348 19.932 16.9039 20.389 17.2421 21.303L17.5 22L17.7579 21.303C18.0961 20.389 18.2652 19.932 18.5986 19.5986C18.932 19.2652 19.389 19.0961 20.303 18.7579L21 18.5L20.303 18.2421C19.389 17.9039 18.932 17.7348 18.5986 17.4014C18.2652 17.068 18.0961 16.611 17.7579 15.697L17.5 15Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M17.5 11.8018C16.7142 9.76446 15.0645 8.15647 13 7.42676V2H8V7.42676C5.08702 8.45636 3 11.2345 3 14.5C3 18.6421 6.35786 22 10.5 22C11.5667 22 12.5813 21.7773 13.5 21.3759',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M4 11H17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiChemistry03' icon.
  static const List<List<dynamic>> aiChemistry03 = strokeRoundedAiChemistry03;

  /// JSON structure for the 'strokeRoundedAiChip' icon.
  static const List<List<dynamic>> strokeRoundedAiChip = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M18.8284 18.8284C17.6569 20 15.7712 20 12 20C8.22876 20 6.34315 20 5.17157 18.8284C4 17.6569 4 15.7712 4 12C4 8.22876 4 6.34315 5.17157 5.17157C6.34315 4 8.22876 4 12 4C15.7712 4 17.6569 4 18.8284 5.17157C20 6.34315 20 8.22876 20 12C20 15.7712 20 17.6569 18.8284 18.8284Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M8 2V4M16 2V4M12 2V4M8 20V22M12 20V22M16 20V22M22 16H20M4 8H2M4 16H2M4 12H2M22 8H20M22 12H20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M11.4802 7.86193C11.6587 7.37936 12.3413 7.37936 12.5198 7.86193L13.3202 10.0248C13.4325 10.3283 13.6717 10.5675 13.9752 10.6798L16.1381 11.4802C16.6206 11.6587 16.6206 12.3413 16.1381 12.5198L13.9752 13.3202C13.6717 13.4325 13.4325 13.6717 13.3202 13.9752L12.5198 16.1381C12.3413 16.6206 11.6587 16.6206 11.4802 16.1381L10.6798 13.9752C10.5675 13.6717 10.3283 13.4325 10.0248 13.3202L7.86193 12.5198C7.37936 12.3413 7.37936 11.6587 7.86193 11.4802L10.0248 10.6798C10.3283 10.5675 10.5675 10.3283 10.6798 10.0248L11.4802 7.86193Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiChip' icon.
  static const List<List<dynamic>> aiChip = strokeRoundedAiChip;

  /// JSON structure for the 'strokeRoundedAiCloud' icon.
  static const List<List<dynamic>> strokeRoundedAiCloud = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M17.4776 9.00005C17.485 9.00002 17.4925 9 17.5 9C19.9853 9 22 11.0147 22 13.5C22 15.2415 21.0108 16.7519 19.5636 17.5M17.4776 9.00005C17.4924 8.83536 17.5 8.66856 17.5 8.5C17.5 5.46243 15.0376 3 12 3C9.12324 3 6.76233 5.20862 6.52042 8.0227M17.4776 9.00005C17.3753 10.1345 16.9286 11.1696 16.2428 12M6.52042 8.0227C3.98398 8.26407 2 10.4003 2 13C2 14.9791 3.14985 16.6896 4.81794 17.5M6.52042 8.0227C6.67826 8.00768 6.83823 8 7 8C8.12582 8 9.16474 8.37209 10.0005 9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12 14L12.2579 14.697C12.5961 15.611 12.7652 16.068 13.0986 16.4014C13.432 16.7348 13.889 16.9039 14.803 17.2421L15.5 17.5L14.803 17.7579C13.889 18.0961 13.432 18.2652 13.0986 18.5986C12.7652 18.932 12.5961 19.389 12.2579 20.303L12 21L11.7421 20.303C11.4039 19.389 11.2348 18.932 10.9014 18.5986C10.568 18.2652 10.111 18.0961 9.19703 17.7579L8.5 17.5L9.19703 17.2421C10.111 16.9039 10.568 16.7348 10.9014 16.4014C11.2348 16.068 11.4039 15.611 11.7421 14.697L12 14Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiCloud' icon.
  static const List<List<dynamic>> aiCloud = strokeRoundedAiCloud;

  /// JSON structure for the 'strokeRoundedAiCloud01' icon.
  static const List<List<dynamic>> strokeRoundedAiCloud01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M17.4776 8.00005C17.485 8.00002 17.4925 8 17.5 8C19.9853 8 22 10.0147 22 12.5C22 14.0602 21.206 15.435 20 16.2422M17.4776 8.00005C17.4924 7.83536 17.5 7.66856 17.5 7.5C17.5 4.46243 15.0376 2 12 2C9.12324 2 6.76233 4.20862 6.52042 7.0227M17.4776 8.00005C17.4131 8.71494 17.2119 9.39038 16.9003 10M6.52042 7.0227C3.98398 7.26407 2 9.40034 2 12C2 13.7891 2.93963 15.3587 4.35232 16.2422M6.52042 7.0227C6.67826 7.00768 6.83823 7 7 7C8.12582 7 9.16474 7.37209 10.0005 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M13 14H11C10.0572 14 9.58579 14 9.29289 14.2929C9 14.5858 9 15.0572 9 16V18C9 18.9428 9 19.4142 9.29289 19.7071C9.58579 20 10.0572 20 11 20H13C13.9428 20 14.4142 20 14.7071 19.7071C15 19.4142 15 18.9428 15 18V16C15 15.0572 15 14.5858 14.7071 14.2929C14.4142 14 13.9428 14 13 14Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M10.5 20V22M13.5 20V22M10.5 12V14M13.5 12V14M9 15.5H7M9 18.5H7M17 15.5H15M17 18.5H15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiCloud01' icon.
  static const List<List<dynamic>> aiCloud01 = strokeRoundedAiCloud01;

  /// JSON structure for the 'strokeRoundedAiCloud02' icon.
  static const List<List<dynamic>> strokeRoundedAiCloud02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M17.4776 8.00005C17.485 8.00002 17.4925 8 17.5 8C19.9853 8 22 10.0147 22 12.5C22 14.4593 20.7478 16.1262 19 16.7439M17.4776 8.00005C17.4924 7.83536 17.5 7.66856 17.5 7.5C17.5 4.46243 15.0376 2 12 2C9.12324 2 6.76233 4.20862 6.52042 7.0227M17.4776 8.00005C17.3753 9.1345 16.9286 10.1696 16.2428 11M6.52042 7.0227C3.98398 7.26407 2 9.40034 2 12C2 14.0503 3.2341 15.8124 5 16.584M6.52042 7.0227C6.67826 7.00768 6.83823 7 7 7C8.12582 7 9.16474 7.37209 10.0005 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18.25 21.25L16 19L16 17M18.25 20.5C17.8358 20.5 17.5 20.8358 17.5 21.25C17.5 21.6642 17.8358 22 18.25 22C18.6642 22 19 21.6642 19 21.25C19 20.8358 18.6642 20.5 18.25 20.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M5.75 21.25L8 19L8 17M5.75 20.5C6.16421 20.5 6.5 20.8358 6.5 21.25C6.5 21.6642 6.16421 22 5.75 22C5.33579 22 5 21.6642 5 21.25C5 20.8358 5.33579 20.5 5.75 20.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M12 21.25L12 17M12 20.5C11.5858 20.5 11.25 20.8358 11.25 21.25C11.25 21.6642 11.5858 22 12 22C12.4142 22 12.75 21.6642 12.75 21.25C12.75 20.8358 12.4142 20.5 12 20.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiCloud02' icon.
  static const List<List<dynamic>> aiCloud02 = strokeRoundedAiCloud02;

  /// JSON structure for the 'strokeRoundedAiComputer' icon.
  static const List<List<dynamic>> strokeRoundedAiComputer = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M10.014 2C6.23617 2 4.34725 2 3.17362 3.17157C2 4.34315 2 6.22876 2 10C2 13.7712 2 15.6569 3.17362 16.8284C4.34725 18 6.23617 18 10.014 18H14.021C17.7989 18 19.6878 18 20.8614 16.8284C21.671 16.0203 21.9221 14.8723 22 13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M12 18V22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M8 22H16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M11 15H13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M18 4H16C15.0572 4 14.5858 4 14.2929 4.29289C14 4.58579 14 5.05719 14 6V8C14 8.94281 14 9.41421 14.2929 9.70711C14.5858 10 15.0572 10 16 10H18C18.9428 10 19.4142 10 19.7071 9.70711C20 9.41421 20 8.94281 20 8V6C20 5.05719 20 4.58579 19.7071 4.29289C19.4142 4 18.9428 4 18 4Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd':
            'M15.5 10V12M18.5 10V12M15.5 2V4M18.5 2V4M14 5.5H12M14 8.5H12M22 5.5H20M22 8.5H20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiComputer' icon.
  static const List<List<dynamic>> aiComputer = strokeRoundedAiComputer;

  /// JSON structure for the 'strokeRoundedAiContentGenerator01' icon.
  static const List<List<dynamic>> strokeRoundedAiContentGenerator01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M11 21H10C6.22876 21 4.34315 21 3.17157 19.8284C2 18.6569 2 16.7712 2 13V10C2 6.22876 2 4.34315 3.17157 3.17157C4.34315 2 6.22876 2 10 2H12C15.7712 2 17.6569 2 18.8284 3.17157C20 4.34315 20 6.22876 20 10V10.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M17.4069 14.4036C17.6192 13.8655 18.3808 13.8655 18.5931 14.4036L18.6298 14.4969C19.1482 15.8113 20.1887 16.8518 21.5031 17.3702L21.5964 17.4069C22.1345 17.6192 22.1345 18.3808 21.5964 18.5931L21.5031 18.6298C20.1887 19.1482 19.1482 20.1887 18.6298 21.5031L18.5931 21.5964C18.3808 22.1345 17.6192 22.1345 17.4069 21.5964L17.3702 21.5031C16.8518 20.1887 15.8113 19.1482 14.4969 18.6298L14.4036 18.5931C13.8655 18.3808 13.8655 17.6192 14.4036 17.4069L14.4969 17.3702C15.8113 16.8518 16.8518 15.8113 17.3702 14.4969L17.4069 14.4036Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M7 7H15M7 11.5H15M7 16H11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiContentGenerator01' icon.
  static const List<List<dynamic>> aiContentGenerator01 =
      strokeRoundedAiContentGenerator01;

  /// JSON structure for the 'strokeRoundedAiContentGenerator02' icon.
  static const List<List<dynamic>> strokeRoundedAiContentGenerator02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M11 20C7.25027 20 5.3754 20 4.06107 19.0451C3.6366 18.7367 3.26331 18.3634 2.95491 17.9389C2 16.6246 2 14.7497 2 11C2 7.25027 2 5.3754 2.95491 4.06107C3.26331 3.6366 3.6366 3.26331 4.06107 2.95491C5.3754 2 7.25027 2 11 2H11.5C14.7734 2 16.4101 2 17.6125 2.7368C18.2853 3.14908 18.8509 3.71473 19.2632 4.38751C20 5.58985 20 7.22657 20 10.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M17.4069 14.4036C17.6192 13.8655 18.3808 13.8655 18.5931 14.4036L18.6298 14.4969C19.1482 15.8113 20.1887 16.8518 21.5031 17.3702L21.5964 17.4069C22.1345 17.6192 22.1345 18.3808 21.5964 18.5931L21.5031 18.6298C20.1887 19.1482 19.1482 20.1887 18.6298 21.5031L18.5931 21.5964C18.3808 22.1345 17.6192 22.1345 17.4069 21.5964L17.3702 21.5031C16.8518 20.1887 15.8113 19.1482 14.4969 18.6298L14.4036 18.5931C13.8655 18.3808 13.8655 17.6192 14.4036 17.4069L14.4969 17.3702C15.8113 16.8518 16.8518 15.8113 17.3702 14.4969L17.4069 14.4036Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M11 7H7V8M11 7H15V8M11 7V15M11 15H10M11 15H12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiContentGenerator02' icon.
  static const List<List<dynamic>> aiContentGenerator02 =
      strokeRoundedAiContentGenerator02;

  /// JSON structure for the 'strokeRoundedAiDna' icon.
  static const List<List<dynamic>> strokeRoundedAiDna = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M7.49115 14.0016C3.00095 11.6016 3.00095 10.4016 3.00095 10.0016C3.00095 9.60159 3.00095 8.40159 7.49115 6.00159M7.49115 14.0016C3.00095 16.4016 3.00008 17.2016 3.00008 18.0016M7.49115 14.0016C11.9805 11.6021 11.9805 10.4021 11.9805 10.0018C11.9805 9.60159 11.9805 8.40112 7.49115 6.00159M7.49115 6.00159C11.9814 3.60159 11.9814 2.80159 11.9814 2.00159M7.49115 6.00159L5.30789 4.74589C3.00065 3.28308 3.00008 2.64234 3.00008 2.00159',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M14.4119 12.0006V13.9796M10.9249 15.501H12.9769M18.9479 15.501H20.9999M18.9479 18.4742H20.9999M10.9249 18.4742H12.9769M14.4119 20.0198V21.9989M17.4374 20.0198V21.9989M17.4266 12.0006V13.9796M13.9769 19.9682H17.9479C18.5002 19.9682 18.9479 19.5205 18.9479 18.9682V14.9796C18.9479 14.4273 18.5002 13.9796 17.9479 13.9796H13.9769C13.4246 13.9796 12.9769 14.4273 12.9769 14.9796V18.9682C12.9769 19.5205 13.4246 19.9682 13.9769 19.9682Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiDna' icon.
  static const List<List<dynamic>> aiDna = strokeRoundedAiDna;

  /// JSON structure for the 'strokeRoundedAiEditing' icon.
  static const List<List<dynamic>> strokeRoundedAiEditing = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6.53792 2.32172C6.69664 1.89276 7.30336 1.89276 7.46208 2.32172L8.1735 4.2443C8.27331 4.51403 8.48597 4.72669 8.7557 4.8265L10.6783 5.53792C11.1072 5.69664 11.1072 6.30336 10.6783 6.46208L8.7557 7.1735C8.48597 7.27331 8.27331 7.48597 8.1735 7.7557L7.46208 9.67828C7.30336 10.1072 6.69665 10.1072 6.53792 9.67828L5.8265 7.7557C5.72669 7.48597 5.51403 7.27331 5.2443 7.1735L3.32172 6.46208C2.89276 6.30336 2.89276 5.69665 3.32172 5.53792L5.2443 4.8265C5.51403 4.72669 5.72669 4.51403 5.8265 4.2443L6.53792 2.32172Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M14.4039 9.64136L15.8869 11.1244M6 22H7.49759C8.70997 22 9.31617 22 9.86124 21.7742C10.4063 21.5484 10.835 21.1198 11.6923 20.2625L19.8417 12.1131C20.3808 11.574 20.6503 11.3045 20.7944 11.0137C21.0685 10.4605 21.0685 9.81094 20.7944 9.25772C20.6503 8.96695 20.3808 8.69741 19.8417 8.15832C19.3026 7.61924 19.0331 7.3497 18.7423 7.20561C18.1891 6.93146 17.5395 6.93146 16.9863 7.20561C16.6955 7.3497 16.426 7.61924 15.8869 8.15832L7.73749 16.3077C6.8802 17.165 6.45156 17.5937 6.22578 18.1388C6 18.6838 6 19.29 6 20.5024V22Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiEditing' icon.
  static const List<List<dynamic>> aiEditing = strokeRoundedAiEditing;

  /// JSON structure for the 'strokeRoundedAiEraser' icon.
  static const List<List<dynamic>> strokeRoundedAiEraser = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M9.73792 10.7802L5.84693 14.7574C4.67722 15.953 4.09236 16.5508 4.01263 17.2802C3.99579 17.4343 3.99579 17.5899 4.01263 17.744C4.09236 18.4733 4.67722 19.0711 5.84693 20.2668L5.99601 20.4191C6.62049 21.0575 6.93274 21.3766 7.30638 21.5911C7.5236 21.7157 7.75482 21.8134 7.99505 21.882C8.40827 22 8.85149 22 9.73792 22C10.6244 22 11.0676 22 11.4808 21.882C11.721 21.8134 11.9522 21.7157 12.1695 21.5911C12.5431 21.3766 12.8554 21.0575 13.4798 20.4191L16.3239 17.5121M9.73792 10.7802L13.3199 7.12313C14.7065 5.70754 15.3997 4.99974 16.2627 5C17.1256 5.00026 17.8185 5.70846 19.2042 7.12487L19.9473 7.8845C21.3159 9.28342 22.0002 9.98288 22 10.8501C21.9997 11.7173 21.315 12.4163 19.9456 13.8144L16.3239 17.5121M9.73792 10.7802L16.3239 17.5121',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M5.5 2L5.75792 2.69703C6.09613 3.61102 6.26524 4.06802 6.59861 4.40139C6.93198 4.73477 7.38898 4.90387 8.30297 5.24208L9 5.5L8.30297 5.75792C7.38898 6.09613 6.93198 6.26524 6.59861 6.59861C6.26524 6.93198 6.09613 7.38898 5.75792 8.30297L5.5 9L5.24208 8.30297C4.90387 7.38898 4.73476 6.93198 4.40139 6.59861C4.06802 6.26524 3.61102 6.09613 2.69703 5.75792L2 5.5L2.69703 5.24208C3.61102 4.90387 4.06802 4.73477 4.40139 4.40139C4.73477 4.06802 4.90387 3.61102 5.24208 2.69703L5.5 2Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiEraser' icon.
  static const List<List<dynamic>> aiEraser = strokeRoundedAiEraser;

  /// JSON structure for the 'strokeRoundedAiFile' icon.
  static const List<List<dynamic>> strokeRoundedAiFile = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M19 11.0032V10C19 6.22876 19 4.34315 17.8284 3.17157C16.6569 2 14.7712 2 11 2H10.0082L3 8.98648V14.0062C3 17.7714 3 19.654 4.16811 20.825L4.17504 20.8319C5.34602 22 7.2286 22 10.9938 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M3 9.00195H4C6.82843 9.00195 8.24264 9.00195 9.12132 8.12327C10 7.24459 10 5.83038 10 3.00195V2.00195',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M16.4069 21.5983C16.6192 22.1365 17.3808 22.1365 17.5931 21.5983L17.6298 21.5051C18.1482 20.1906 19.1887 19.1502 20.5031 18.6318L20.5964 18.595C21.1345 18.3828 21.1345 17.6211 20.5964 17.4089L20.5031 17.3721C19.1887 16.8537 18.1482 15.8133 17.6298 14.4989L17.5931 14.4056C17.3808 13.8674 16.6192 13.8674 16.4069 14.4056L16.3702 14.4989C15.8518 15.8133 14.8113 16.8537 13.4969 17.3721L13.4036 17.4089C12.8655 17.6211 12.8655 18.3828 13.4036 18.595L13.4969 18.6318C14.8113 19.1502 15.8518 20.1906 16.3702 21.5051L16.4069 21.5983Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiFile' icon.
  static const List<List<dynamic>> aiFile = strokeRoundedAiFile;

  /// JSON structure for the 'strokeRoundedAiFolder01' icon.
  static const List<List<dynamic>> strokeRoundedAiFolder01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M7 6H16.75C18.8567 6 19.91 6 20.6667 6.50559C20.9943 6.72447 21.2755 7.00572 21.4944 7.33329C22 8.08996 22 9.14331 22 11.25C22 14.7612 22 16.5167 21.1573 17.7779C20.975 18.0508 20.7666 18.3045 20.5355 18.5355M3.46447 18.5355C2 17.0711 2 14.714 2 10V6.94427C2 5.1278 2 4.21956 2.38032 3.53806C2.65142 3.05227 3.05227 2.65142 3.53806 2.38032C4.21956 2 5.1278 2 6.94427 2C8.10802 2 8.6899 2 9.19926 2.19101C10.3622 2.62712 10.8418 3.68358 11.3666 4.73313L12 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18.25 21.25L16 19L16 16M18.25 20.5C17.8358 20.5 17.5 20.8358 17.5 21.25C17.5 21.6642 17.8358 22 18.25 22C18.6642 22 19 21.6642 19 21.25C19 20.8358 18.6642 20.5 18.25 20.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M5.75 21.25L8 19L8 16M5.75 20.5C6.16421 20.5 6.5 20.8358 6.5 21.25C6.5 21.6642 6.16421 22 5.75 22C5.33579 22 5 21.6642 5 21.25C5 20.8358 5.33579 20.5 5.75 20.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M12 21.25L12 16M12 20.5C11.5858 20.5 11.25 20.8358 11.25 21.25C11.25 21.6642 11.5858 22 12 22C12.4142 22 12.75 21.6642 12.75 21.25C12.75 20.8358 12.4142 20.5 12 20.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiFolder01' icon.
  static const List<List<dynamic>> aiFolder01 = strokeRoundedAiFolder01;

  /// JSON structure for the 'strokeRoundedAiFolder02' icon.
  static const List<List<dynamic>> strokeRoundedAiFolder02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M7 6.00085H16.75C18.8567 6.00085 19.91 6.00085 20.6667 6.50644C20.9943 6.72532 21.2755 7.00657 21.4944 7.33414C22 8.09081 22 9.14416 22 11.2509C22 14.7621 22 16.5176 21.1573 17.7788C20.975 18.0517 20.7666 18.3054 20.5355 18.5364M3.46447 18.5364C2 17.072 2 14.7149 2 10.0009V6.94512C2 5.12865 2 4.22041 2.38032 3.53891C2.65142 3.05312 3.05227 2.65227 3.53806 2.38117C4.21956 2.00085 5.1278 2.00085 6.94427 2.00085C8.10802 2.00085 8.6899 2.00085 9.19926 2.19186C10.3622 2.62797 10.8418 3.68443 11.3666 4.73398L12 6.00085',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M10.4499 12.0009V13.9799M6.96289 15.5012H9.01487M14.986 15.5012H17.0379M14.986 18.4745H17.0379M6.96289 18.4745H9.01487M10.4499 20.0201V21.9991M13.4754 20.0201V21.9991M13.4646 12.0009V13.9799M10.0149 19.9684H13.986C14.5382 19.9684 14.986 19.5207 14.986 18.9684V14.9799C14.986 14.4276 14.5382 13.9799 13.986 13.9799H10.0149C9.46258 13.9799 9.01487 14.4276 9.01487 14.9799V18.9684C9.01487 19.5207 9.46258 19.9684 10.0149 19.9684Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiFolder02' icon.
  static const List<List<dynamic>> aiFolder02 = strokeRoundedAiFolder02;

  /// JSON structure for the 'strokeRoundedAiGame' icon.
  static const List<List<dynamic>> strokeRoundedAiGame = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6.00195 7.5C5.12645 7.64253 4.48184 7.90465 3.95937 8.3867C2.81421 9.44326 2.65433 11.1887 2.33456 14.6797L2.00778 18.2473C1.88378 20.0049 3.25864 21.5 4.99899 21.5H5.74567C6.97191 21.5 8.0746 20.7441 8.53002 19.5913L9.27241 17.7121C9.51592 17.0956 9.63768 16.7874 9.89165 16.6134C10.1456 16.4393 10.4736 16.4393 11.1295 16.4393H12.8705C13.5264 16.4393 13.8544 16.4393 14.1084 16.6134C14.3623 16.7874 14.4841 17.0956 14.7276 17.7121L15.47 19.5913C15.9254 20.7441 17.0281 21.5 18.2543 21.5H19.001C20.7414 21.5 22.1162 20.0049 21.9922 18.2473L21.6685 14.6855C21.351 11.192 21.1922 9.44521 20.0468 8.38767C19.5241 7.905 18.8789 7.64263 18.0024 7.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M16.9998 12.5H17.0088',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M6.99981 12.5H7.00879',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M11.998 2.5L12.256 3.19703C12.5942 4.11102 12.7633 4.56802 13.0967 4.90139C13.43 5.23477 13.887 5.40387 14.801 5.74208L15.498 6L14.801 6.25792C13.887 6.59613 13.43 6.76524 13.0967 7.09861C12.7633 7.43198 12.5942 7.88898 12.256 8.80297L11.998 9.5L11.7401 8.80297C11.4019 7.88898 11.2328 7.43198 10.8994 7.09861C10.5661 6.76523 10.1091 6.59613 9.19507 6.25792L8.49805 6L9.19507 5.74208C10.1091 5.40387 10.5661 5.23477 10.8994 4.90139C11.2328 4.56802 11.4019 4.11102 11.7401 3.19703L11.998 2.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiGame' icon.
  static const List<List<dynamic>> aiGame = strokeRoundedAiGame;

  /// JSON structure for the 'strokeRoundedAiGenerative' icon.
  static const List<List<dynamic>> strokeRoundedAiGenerative = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M10 6C6.22876 6 4.34315 6 3.17157 7.17157C2 8.34315 2 10.2288 2 14C2 17.7712 2 19.6569 3.17157 20.8284C4.34315 22 6.22876 22 10 22H14C17.7712 22 19.6569 22 20.8284 20.8284C22 19.6569 22 17.7712 22 14C22 12.8302 22 11.8419 21.965 11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18 2L18.2948 2.7966C18.6813 3.84117 18.8746 4.36345 19.2556 4.74445C19.6366 5.12545 20.1588 5.31871 21.2034 5.70523L22 6L21.2034 6.29477C20.1588 6.68129 19.6366 6.87455 19.2556 7.25555C18.8746 7.63655 18.6813 8.15883 18.2948 9.2034L18 10L17.7052 9.2034C17.3187 8.15883 17.1254 7.63655 16.7444 7.25555C16.3634 6.87455 15.8412 6.68129 14.7966 6.29477L14 6L14.7966 5.70523C15.8412 5.31871 16.3634 5.12545 16.7444 4.74445C17.1254 4.36345 17.3187 3.84117 17.7052 2.7966L18 2Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiGenerative' icon.
  static const List<List<dynamic>> aiGenerative = strokeRoundedAiGenerative;

  /// JSON structure for the 'strokeRoundedAiIdea' icon.
  static const List<List<dynamic>> strokeRoundedAiIdea = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M19 9.62069C19 12.1999 17.7302 14.1852 15.7983 15.4917C15.3483 15.796 15.1233 15.9482 15.0122 16.1212C14.9012 16.2942 14.8633 16.5214 14.7876 16.9757L14.7287 17.3288C14.5957 18.127 14.5292 18.526 14.2494 18.763C13.9697 19 13.5651 19 12.7559 19H10.1444C9.33528 19 8.93069 19 8.65095 18.763C8.3712 18.526 8.30469 18.127 8.17166 17.3288L8.11281 16.9757C8.03734 16.5229 7.99961 16.2965 7.88968 16.1243C7.77976 15.9521 7.55428 15.798 7.10332 15.4897C5.1919 14.1832 4 12.1986 4 9.62069C4 5.4119 7.35786 2 11.5 2C12.0137 2 12.5153 2.05248 13 2.15244',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M16.5 2L16.7579 2.69703C17.0961 3.61102 17.2652 4.06802 17.5986 4.40139C17.932 4.73477 18.389 4.90387 19.303 5.24208L20 5.5L19.303 5.75792C18.389 6.09613 17.932 6.26524 17.5986 6.59861C17.2652 6.93198 17.0961 7.38898 16.7579 8.30297L16.5 9L16.2421 8.30297C15.9039 7.38898 15.7348 6.93198 15.4014 6.59861C15.068 6.26524 14.611 6.09613 13.697 5.75792L13 5.5L13.697 5.24208C14.611 4.90387 15.068 4.73477 15.4014 4.40139C15.7348 4.06802 15.9039 3.61102 16.2421 2.69703L16.5 2Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M13.5 19V20C13.5 20.9428 13.5 21.4142 13.2071 21.7071C12.9142 22 12.4428 22 11.5 22C10.5572 22 10.0858 22 9.79289 21.7071C9.5 21.4142 9.5 20.9428 9.5 20V19',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiIdea' icon.
  static const List<List<dynamic>> aiIdea = strokeRoundedAiIdea;

  /// JSON structure for the 'strokeRoundedAiImage' icon.
  static const List<List<dynamic>> strokeRoundedAiImage = [
    [
      'circle',
      {
        'key': '0',
        'cx': '7',
        'cy': '8',
        'r': '1.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M20.9977 11C21 11.4701 21 11.9693 21 12.5C21 16.9783 21 19.2175 19.6088 20.6088C18.2175 22 15.9783 22 11.5 22C7.02166 22 4.78249 22 3.39124 20.6088C2 19.2175 2 16.9783 2 12.5C2 8.02166 2 5.78249 3.39124 4.39124C4.78249 3 7.02166 3 11.5 3C12.0307 3 12.5299 3 13 3.00231',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M18.5 2L18.7579 2.69703C19.0961 3.61102 19.2652 4.06802 19.5986 4.40139C19.932 4.73477 20.389 4.90387 21.303 5.24208L22 5.5L21.303 5.75792C20.389 6.09613 19.932 6.26524 19.5986 6.59861C19.2652 6.93198 19.0961 7.38898 18.7579 8.30297L18.5 9L18.2421 8.30297C17.9039 7.38898 17.7348 6.93198 17.4014 6.59861C17.068 6.26524 16.611 6.09613 15.697 5.75792L15 5.5L15.697 5.24208C16.611 4.90387 17.068 4.73477 17.4014 4.40139C17.7348 4.06802 17.9039 3.61102 18.2421 2.69703L18.5 2Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M4.5 21.5C8.87246 16.275 13.7741 9.38406 20.9975 14.0424',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiImage' icon.
  static const List<List<dynamic>> aiImage = strokeRoundedAiImage;

  /// JSON structure for the 'strokeRoundedAiInnovation01' icon.
  static const List<List<dynamic>> strokeRoundedAiInnovation01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M11 2C6.58172 2 3 5.54539 3 9.91886C3 11.4118 3.41735 12.8082 4.14286 14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M17 5H15C14.0572 5 13.5858 5 13.2929 5.29289C13 5.58579 13 6.05719 13 7V9C13 9.94281 13 10.4142 13.2929 10.7071C13.5858 11 14.0572 11 15 11H17C17.9428 11 18.4142 11 18.7071 10.7071C19 10.4142 19 9.94281 19 9V7C19 6.05719 19 5.58579 18.7071 5.29289C18.4142 5 17.9428 5 17 5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M14.5 11V13M17.5 11V13M14.5 3V5M17.5 3V5M13 6.5H11M13 9.5H11M21 6.5H19M21 9.5H19',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M6.38287 17.0982C6.291 16.8216 6.24507 16.6833 6.25042 16.5713C6.26174 16.3343 6.41114 16.1262 6.63157 16.0405C6.73579 16 6.88105 16 7.17157 16H14.8284C15.119 16 15.2642 16 15.3684 16.0405C15.5889 16.1262 15.7383 16.3343 15.7496 16.5713C15.7549 16.6833 15.709 16.8216 15.6171 17.0982C15.4473 17.6094 15.3624 17.8651 15.2315 18.072C14.9572 18.5056 14.5272 18.8167 14.0306 18.9408C13.7935 19 13.525 19 12.9881 19H9.01186C8.47495 19 8.2065 19 7.96944 18.9408C7.47283 18.8167 7.04281 18.5056 6.7685 18.072C6.63755 17.8651 6.55266 17.6094 6.38287 17.0982Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M14 19L13.8707 19.6466C13.7293 20.3537 13.6586 20.7072 13.5001 20.9866C13.2552 21.4185 12.8582 21.7439 12.3866 21.8994C12.0816 22 11.7211 22 11 22C10.2789 22 9.91842 22 9.61338 21.8994C9.14175 21.7439 8.74484 21.4185 8.49987 20.9866C8.34144 20.7072 8.27073 20.3537 8.12932 19.6466L8 19',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiInnovation01' icon.
  static const List<List<dynamic>> aiInnovation01 = strokeRoundedAiInnovation01;

  /// JSON structure for the 'strokeRoundedAiInnovation02' icon.
  static const List<List<dynamic>> strokeRoundedAiInnovation02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5.14286 14C4.41735 12.8082 4 11.4118 4 9.91886C4 5.54539 7.58172 2 12 2C16.4183 2 20 5.54539 20 9.91886C20 11.4118 19.5827 12.8082 18.8571 14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M7.38287 17.0982C7.291 16.8216 7.24507 16.6833 7.25042 16.5713C7.26174 16.3343 7.41114 16.1262 7.63157 16.0405C7.73579 16 7.88105 16 8.17157 16H15.8284C16.119 16 16.2642 16 16.3684 16.0405C16.5889 16.1262 16.7383 16.3343 16.7496 16.5713C16.7549 16.6833 16.709 16.8216 16.6171 17.0982C16.4473 17.6094 16.3624 17.8651 16.2315 18.072C15.9572 18.5056 15.5272 18.8167 15.0306 18.9408C14.7935 19 14.525 19 13.9881 19H10.0119C9.47495 19 9.2065 19 8.96944 18.9408C8.47283 18.8167 8.04281 18.5056 7.7685 18.072C7.63755 17.8651 7.55266 17.6094 7.38287 17.0982Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M15 19L14.8707 19.6466C14.7293 20.3537 14.6586 20.7072 14.5001 20.9866C14.2552 21.4185 13.8582 21.7439 13.3866 21.8994C13.0816 22 12.7211 22 12 22C11.2789 22 10.9184 22 10.6134 21.8994C10.1418 21.7439 9.74484 21.4185 9.49987 20.9866C9.34144 20.7072 9.27073 20.3537 9.12932 19.6466L9 19',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M12.3077 12L10.847 7.47891C10.7552 7.19466 10.4734 7 10.1538 7C9.83425 7 9.55249 7.19466 9.46066 7.47891L8 12M15 7V12M8.53846 10.5H11.7692',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiInnovation02' icon.
  static const List<List<dynamic>> aiInnovation02 = strokeRoundedAiInnovation02;

  /// JSON structure for the 'strokeRoundedAiInnovation03' icon.
  static const List<List<dynamic>> strokeRoundedAiInnovation03 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5.14286 14C4.41735 12.8082 4 11.4118 4 9.91886C4 5.54539 7.58172 2 12 2C16.4183 2 20 5.54539 20 9.91886C20 11.4118 19.5827 12.8082 18.8571 14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M7.38287 17.0982C7.291 16.8216 7.24507 16.6833 7.25042 16.5713C7.26174 16.3343 7.41114 16.1262 7.63157 16.0405C7.73579 16 7.88105 16 8.17157 16H15.8284C16.119 16 16.2642 16 16.3684 16.0405C16.5889 16.1262 16.7383 16.3343 16.7496 16.5713C16.7549 16.6833 16.709 16.8216 16.6171 17.0982C16.4473 17.6094 16.3624 17.8651 16.2315 18.072C15.9572 18.5056 15.5272 18.8167 15.0306 18.9408C14.7935 19 14.525 19 13.9881 19H10.0119C9.47495 19 9.2065 19 8.96944 18.9408C8.47283 18.8167 8.04281 18.5056 7.7685 18.072C7.63755 17.8651 7.55266 17.6094 7.38287 17.0982Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M15 19L14.8707 19.6466C14.7293 20.3537 14.6586 20.7072 14.5001 20.9866C14.2552 21.4185 13.8582 21.7439 13.3866 21.8994C13.0816 22 12.7211 22 12 22C11.2789 22 10.9184 22 10.6134 21.8994C10.1418 21.7439 9.74484 21.4185 9.49987 20.9866C9.34144 20.7072 9.27073 20.3537 9.12932 19.6466L9 19',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M8.25 9.75L10.5 12L10.5 16M8.25 10.5C8.66421 10.5 9 10.1642 9 9.75C9 9.33579 8.66421 9 8.25 9C7.83579 9 7.5 9.33579 7.5 9.75C7.5 10.1642 7.83579 10.5 8.25 10.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M15.75 9.75L13.5 12L13.5 16M15.75 10.5C15.3358 10.5 15 10.1642 15 9.75C15 9.33579 15.3358 9 15.75 9C16.1642 9 16.5 9.33579 16.5 9.75C16.5 10.1642 16.1642 10.5 15.75 10.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiInnovation03' icon.
  static const List<List<dynamic>> aiInnovation03 = strokeRoundedAiInnovation03;

  /// JSON structure for the 'strokeRoundedAiLaptop' icon.
  static const List<List<dynamic>> strokeRoundedAiLaptop = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3.9926 14.999V6.96505C3.9926 5.07142 3.9926 4.12461 4.5762 3.53633C4.90157 3.20835 5.33749 3.06323 5.98512 2.99902H10.9664',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M3.4921 16.0144L4.01206 14.999H19.8848L20.4332 16.0144C21.8707 18.676 22.2288 20.0067 21.6823 21.0029C21.136 21.999 19.6873 21.999 16.79 21.999H7.13543C4.2381 21.999 2.78942 21.999 2.24303 21.0029C1.69664 20.0067 2.05461 18.676 3.4921 16.0144Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M15.4367 2.00098V3.98M11.9627 5.50136H14.007M19.9558 5.50136H22.0001M19.9558 8.47458H22.0001M11.9627 8.47458H14.007M15.4367 10.0202V11.9992M18.4508 10.0202V11.9992M18.4401 2.00098V3.98M15.0033 9.96854H18.9595C19.5097 9.96854 19.9558 9.52082 19.9558 8.96854V4.98C19.9558 4.42771 19.5097 3.98 18.9595 3.98H15.0033C14.453 3.98 14.007 4.42771 14.007 4.98V8.96854C14.007 9.52082 14.453 9.96854 15.0033 9.96854Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiLaptop' icon.
  static const List<List<dynamic>> aiLaptop = strokeRoundedAiLaptop;

  /// JSON structure for the 'strokeRoundedAiLearning' icon.
  static const List<List<dynamic>> strokeRoundedAiLearning = [
    [
      'path',
      {
        'key': '0',
        'd': 'M12 15.5L12 20.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M5.98056 3.28544C4.2879 2.96315 3.44157 2.80201 2.72078 3.41964C2 4.03727 2 5.04022 2 7.04612V14.255C2 16.0891 2 17.0061 2.4626 17.5787C2.9252 18.1512 3.94365 18.3451 5.98056 18.733C7.79633 19.0787 9.21344 19.6295 10.2392 20.1831C11.2484 20.7277 11.753 21 12 21C12.247 21 12.7516 20.7277 13.7608 20.1831C14.7866 19.6295 16.2037 19.0787 18.0194 18.733C20.0564 18.3451 21.0748 18.1512 21.5374 17.5787C22 17.0061 22 16.0891 22 14.255V7.04612C22 5.04022 22 4.03727 21.2792 3.41964C20.5584 2.80201 19.7121 2.96315 18.0194 3.28544',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M9.29289 10.7071L9.82322 10.1768L9.82322 10.1768L9.29289 10.7071ZM14.7071 10.7071L14.1768 10.1768L14.1768 10.1768L14.7071 10.7071ZM14.7071 5.29289L14.1768 5.82322L14.1768 5.82322L14.7071 5.29289ZM11.25 11C11.25 10.5858 10.9142 10.25 10.5 10.25C10.0858 10.25 9.75 10.5858 9.75 11H11.25ZM9.75 13C9.75 13.4142 10.0858 13.75 10.5 13.75C10.9142 13.75 11.25 13.4142 11.25 13H9.75ZM14.25 11C14.25 10.5858 13.9142 10.25 13.5 10.25C13.0858 10.25 12.75 10.5858 12.75 11H14.25ZM12.75 13C12.75 13.4142 13.0858 13.75 13.5 13.75C13.9142 13.75 14.25 13.4142 14.25 13H12.75ZM11.25 3C11.25 2.58579 10.9142 2.25 10.5 2.25C10.0858 2.25 9.75 2.58579 9.75 3H11.25ZM9.75 5C9.75 5.41421 10.0858 5.75 10.5 5.75C10.9142 5.75 11.25 5.41421 11.25 5H9.75ZM14.25 3C14.25 2.58579 13.9142 2.25 13.5 2.25C13.0858 2.25 12.75 2.58579 12.75 3H14.25ZM12.75 5C12.75 5.41421 13.0858 5.75 13.5 5.75C13.9142 5.75 14.25 5.41421 14.25 5H12.75ZM9 7.25C9.41421 7.25 9.75 6.91421 9.75 6.5C9.75 6.08579 9.41421 5.75 9 5.75V7.25ZM7 5.75C6.58579 5.75 6.25 6.08579 6.25 6.5C6.25 6.91421 6.58579 7.25 7 7.25V5.75ZM9 10.25C9.41421 10.25 9.75 9.91421 9.75 9.5C9.75 9.08579 9.41421 8.75 9 8.75V10.25ZM7 8.75C6.58579 8.75 6.25 9.08579 6.25 9.5C6.25 9.91421 6.58579 10.25 7 10.25V8.75ZM17 7.25C17.4142 7.25 17.75 6.91421 17.75 6.5C17.75 6.08579 17.4142 5.75 17 5.75V7.25ZM15 5.75C14.5858 5.75 14.25 6.08579 14.25 6.5C14.25 6.91421 14.5858 7.25 15 7.25V5.75ZM17 10.25C17.4142 10.25 17.75 9.91421 17.75 9.5C17.75 9.08579 17.4142 8.75 17 8.75V10.25ZM15 8.75C14.5858 8.75 14.25 9.08579 14.25 9.5C14.25 9.91421 14.5858 10.25 15 10.25V8.75ZM11 5.75H13V4.25H11V5.75ZM14.25 7V9H15.75V7H14.25ZM13 10.25H11V11.75H13V10.25ZM9.75 9V7H8.25V9H9.75ZM11 10.25C10.5074 10.25 10.2134 10.2484 10.0027 10.2201C9.90611 10.2071 9.85774 10.1918 9.83596 10.1828C9.83092 10.1808 9.8276 10.1791 9.82567 10.1781C9.82376 10.1771 9.82292 10.1766 9.82283 10.1765C9.82277 10.1765 9.823 10.1766 9.82335 10.1769C9.8237 10.1772 9.82368 10.1772 9.82322 10.1768L8.76256 11.2374C9.07159 11.5465 9.44731 11.6589 9.80279 11.7067C10.1367 11.7516 10.5498 11.75 11 11.75V10.25ZM8.25 9C8.25 9.4502 8.24841 9.8633 8.2933 10.1972C8.34109 10.5527 8.45354 10.9284 8.76256 11.2374L9.82322 10.1768C9.82277 10.1763 9.82279 10.1763 9.82307 10.1766C9.82335 10.177 9.82351 10.1772 9.82347 10.1772C9.82341 10.1771 9.82286 10.1762 9.82186 10.1743C9.82085 10.1724 9.81923 10.1691 9.81716 10.164C9.8082 10.1423 9.79291 10.0939 9.77992 9.99734C9.75159 9.78661 9.75 9.49261 9.75 9H8.25ZM14.25 9C14.25 9.49261 14.2484 9.78661 14.2201 9.99734C14.2071 10.0939 14.1918 10.1423 14.1828 10.164C14.1808 10.1691 14.1791 10.1724 14.1781 10.1743C14.1771 10.1762 14.1766 10.1771 14.1765 10.1772C14.1765 10.1772 14.1766 10.177 14.1769 10.1766C14.1772 10.1763 14.1772 10.1763 14.1768 10.1768L15.2374 11.2374C15.5465 10.9284 15.6589 10.5527 15.7067 10.1972C15.7516 9.8633 15.75 9.4502 15.75 9H14.25ZM13 11.75C13.4502 11.75 13.8633 11.7516 14.1972 11.7067C14.5527 11.6589 14.9284 11.5465 15.2374 11.2374L14.1768 10.1768C14.1763 10.1772 14.1763 10.1772 14.1766 10.1769C14.177 10.1766 14.1772 10.1765 14.1772 10.1765C14.1771 10.1766 14.1762 10.1771 14.1743 10.1781C14.1724 10.1791 14.1691 10.1808 14.164 10.1828C14.1423 10.1918 14.0939 10.2071 13.9973 10.2201C13.7866 10.2484 13.4926 10.25 13 10.25V11.75ZM13 5.75C13.4926 5.75 13.7866 5.75159 13.9973 5.77992C14.0939 5.79291 14.1423 5.8082 14.164 5.81716C14.1691 5.81923 14.1724 5.82085 14.1743 5.82186C14.1762 5.82286 14.1771 5.82341 14.1772 5.82347C14.1772 5.82351 14.177 5.82335 14.1766 5.82307C14.1763 5.82279 14.1763 5.82277 14.1768 5.82322L15.2374 4.76256C14.9284 4.45354 14.5527 4.34109 14.1972 4.2933C13.8633 4.24841 13.4502 4.25 13 4.25V5.75ZM15.75 7C15.75 6.5498 15.7516 6.1367 15.7067 5.80279C15.6589 5.44731 15.5465 5.07159 15.2374 4.76256L14.1768 5.82322C14.1772 5.82368 14.1772 5.8237 14.1769 5.82335C14.1766 5.823 14.1765 5.82277 14.1765 5.82283C14.1766 5.82292 14.1771 5.82376 14.1781 5.82567C14.1791 5.8276 14.1808 5.83092 14.1828 5.83596C14.1918 5.85774 14.2071 5.90611 14.2201 6.00266C14.2484 6.21339 14.25 6.50739 14.25 7H15.75ZM11 4.25C10.5498 4.25 10.1367 4.24841 9.80279 4.2933C9.44731 4.34109 9.07159 4.45354 8.76256 4.76256L9.82322 5.82322C9.82368 5.82277 9.8237 5.82279 9.82335 5.82307C9.823 5.82335 9.82277 5.82351 9.82283 5.82347C9.82292 5.82341 9.82376 5.82286 9.82567 5.82186C9.8276 5.82085 9.83092 5.81923 9.83596 5.81716C9.85774 5.8082 9.90611 5.79291 10.0027 5.77992C10.2134 5.75159 10.5074 5.75 11 5.75V4.25ZM9.75 7C9.75 6.50739 9.75159 6.21339 9.77992 6.00266C9.79291 5.90611 9.8082 5.85774 9.81716 5.83596C9.81923 5.83092 9.82085 5.8276 9.82186 5.82567C9.82286 5.82376 9.82341 5.82292 9.82347 5.82283C9.82351 5.82277 9.82335 5.823 9.82307 5.82335C9.82279 5.8237 9.82277 5.82368 9.82322 5.82322L8.76256 4.76256C8.45354 5.07159 8.34109 5.44731 8.2933 5.80279C8.24841 6.1367 8.25 6.5498 8.25 7H9.75ZM9.75 11V13H11.25V11H9.75ZM12.75 11V13H14.25V11H12.75ZM9.75 3V5H11.25V3H9.75ZM12.75 3V5H14.25V3H12.75ZM9 5.75H7V7.25H9V5.75ZM9 8.75H7V10.25H9V8.75ZM17 5.75H15V7.25H17V5.75ZM17 8.75H15V10.25H17V8.75Z',
        'fill': 'currentColor'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiLearning' icon.
  static const List<List<dynamic>> aiLearning = strokeRoundedAiLearning;

  /// JSON structure for the 'strokeRoundedAiLock' icon.
  static const List<List<dynamic>> strokeRoundedAiLock = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12.3077 18L10.847 13.4789C10.7552 13.1947 10.4734 13 10.1538 13C9.83425 13 9.55249 13.1947 9.46066 13.4789L8 18M15 13V18M8.53846 16.5H11.7692',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M4.26781 18.8447C4.49269 20.515 5.87613 21.8235 7.55966 21.9009C8.97627 21.966 10.4153 22 12 22C13.5847 22 15.0237 21.966 16.4403 21.9009C18.1239 21.8235 19.5073 20.515 19.7322 18.8447C19.879 17.7547 20 16.6376 20 15.5C20 14.3624 19.879 13.2453 19.7322 12.1553C19.5073 10.485 18.1239 9.17649 16.4403 9.09909C15.0237 9.03397 13.5847 9 12 9C10.4153 9 8.97627 9.03397 7.55966 9.09909C5.87613 9.17649 4.49269 10.485 4.26781 12.1553C4.12104 13.2453 4 14.3624 4 15.5C4 16.6376 4.12104 17.7547 4.26781 18.8447Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M7.5 9V6.5C7.5 4.01472 9.51472 2 12 2C14.4853 2 16.5 4.01472 16.5 6.5V9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiLock' icon.
  static const List<List<dynamic>> aiLock = strokeRoundedAiLock;

  /// JSON structure for the 'strokeRoundedAiMagic' icon.
  static const List<List<dynamic>> strokeRoundedAiMagic = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M10 7L9.48415 8.39405C8.80774 10.222 8.46953 11.136 7.80278 11.8028C7.13603 12.4695 6.22204 12.8077 4.39405 13.4842L3 14L4.39405 14.5158C6.22204 15.1923 7.13603 15.5305 7.80278 16.1972C8.46953 16.864 8.80774 17.778 9.48415 19.6059L10 21L10.5158 19.6059C11.1923 17.778 11.5305 16.864 12.1972 16.1972C12.864 15.5305 13.778 15.1923 15.6059 14.5158L17 14L15.6059 13.4842C13.778 12.8077 12.864 12.4695 12.1972 11.8028C11.5305 11.136 11.1923 10.222 10.5158 8.39405L10 7Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18 3L17.7789 3.59745C17.489 4.38087 17.3441 4.77259 17.0583 5.05833C16.7726 5.34408 16.3809 5.48903 15.5975 5.77892L15 6L15.5975 6.22108C16.3809 6.51097 16.7726 6.65592 17.0583 6.94167C17.3441 7.22741 17.489 7.61913 17.7789 8.40255L18 9L18.2211 8.40255C18.511 7.61913 18.6559 7.22741 18.9417 6.94166C19.2274 6.65592 19.6191 6.51097 20.4025 6.22108L21 6L20.4025 5.77892C19.6191 5.48903 19.2274 5.34408 18.9417 5.05833C18.6559 4.77259 18.511 4.38087 18.2211 3.59745L18 3Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiMagic' icon.
  static const List<List<dynamic>> aiMagic = strokeRoundedAiMagic;

  /// JSON structure for the 'strokeRoundedAiMail' icon.
  static const List<List<dynamic>> strokeRoundedAiMail = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5.00035 7L3.78154 7.81253C2.90783 8.39501 2.47097 8.68625 2.23422 9.13041C1.99747 9.57457 1.99923 10.0966 2.00273 11.1406C2.00696 12.3975 2.01864 13.6782 2.05099 14.9741C2.12773 18.0487 2.16611 19.586 3.29651 20.7164C4.42691 21.8469 5.98497 21.8858 9.10108 21.9637C11.0397 22.0121 12.9611 22.0121 14.8996 21.9637C18.0158 21.8858 19.5738 21.8469 20.7042 20.7164C21.8346 19.586 21.873 18.0487 21.9497 14.9741C21.9821 13.6782 21.9937 12.3975 21.998 11.1406C22.0015 10.0966 22.0032 9.57456 21.7665 9.13041C21.5297 8.68625 21.0929 8.39501 20.2191 7.81253L19.0003 7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M2 10L8.91302 14.1478C10.417 15.0502 11.169 15.5014 12 15.5014C12.831 15.5014 13.583 15.0502 15.087 14.1478L22 10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M4.99998 12V6C4.99998 4.11438 4.99998 3.17157 5.58577 2.58579C6.17156 2 7.11437 2 8.99998 2H15C16.8856 2 17.8284 2 18.4142 2.58579C19 3.17157 19 4.11438 19 6V12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M8 10L9.61165 5.39528C9.69427 5.15922 9.92623 5 10.1875 5C10.4488 5 10.6807 5.15922 10.7633 5.39528L12.375 10M15 5V10M8.875 8.33333H11.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiMail' icon.
  static const List<List<dynamic>> aiMail = strokeRoundedAiMail;

  /// JSON structure for the 'strokeRoundedAiMail01' icon.
  static const List<List<dynamic>> strokeRoundedAiMail01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M7 8L9.94202 9.73943C11.6572 10.7535 12.3428 10.7535 14.058 9.73943L17 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M21.9842 12.9756C22.0053 11.9899 22.0053 11.0101 21.9842 10.0244C21.9189 6.95886 21.8862 5.42609 20.7551 4.29066C19.6239 3.15523 18.0497 3.11568 14.9012 3.03657C12.9607 2.98781 11.0393 2.98781 9.09882 3.03656C5.95033 3.11566 4.37608 3.15521 3.24495 4.29065C2.11382 5.42608 2.08114 6.95885 2.01576 10.0244C1.99474 11.0101 1.99475 11.9899 2.01577 12.9756C2.08114 16.0412 2.11383 17.5739 3.24496 18.7094C4.37608 19.8448 5.95033 19.8843 9.09883 19.9634C10.404 19.9962 11.7005 20.007 13 19.9957',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M18.5 14L18.7579 14.697C19.0961 15.611 19.2652 16.068 19.5986 16.4014C19.932 16.7348 20.389 16.9039 21.303 17.2421L22 17.5L21.303 17.7579C20.389 18.0961 19.932 18.2652 19.5986 18.5986C19.2652 18.932 19.0961 19.389 18.7579 20.303L18.5 21L18.2421 20.303C17.9039 19.389 17.7348 18.932 17.4014 18.5986C17.068 18.2652 16.611 18.0961 15.697 17.7579L15 17.5L15.697 17.2421C16.611 16.9039 17.068 16.7348 17.4014 16.4014C17.7348 16.068 17.9039 15.611 18.2421 14.697L18.5 14Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiMail01' icon.
  static const List<List<dynamic>> aiMail01 = strokeRoundedAiMail01;

  /// JSON structure for the 'strokeRoundedAiMail02' icon.
  static const List<List<dynamic>> strokeRoundedAiMail02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2 5.49998L8.91302 9.41695C11.4616 10.861 12.5384 10.861 15.087 9.41695L22 5.49998',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M21.9842 12.9756C22.0053 11.9899 22.0053 11.0101 21.9842 10.0244C21.9189 6.95885 21.8862 5.42608 20.7551 4.29065C19.6239 3.15522 18.0497 3.11566 14.9012 3.03655C12.9607 2.9878 11.0393 2.9878 9.09882 3.03655C5.95033 3.11565 4.37608 3.1552 3.24495 4.29063C2.11382 5.42606 2.08114 6.95883 2.01576 10.0244C1.99474 11.0101 1.99475 11.9899 2.01577 12.9756C2.08114 16.0411 2.11383 17.5739 3.24496 18.7093C4.37608 19.8448 5.95033 19.8843 9.09883 19.9634C10.404 19.9962 11.7005 20.007 13 19.9956',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M18.5 14L18.7579 14.697C19.0961 15.611 19.2652 16.068 19.5986 16.4014C19.932 16.7347 20.389 16.9039 21.303 17.2421L22 17.5L21.303 17.7579C20.389 18.0961 19.932 18.2652 19.5986 18.5986C19.2652 18.932 19.0961 19.389 18.7579 20.303L18.5 21L18.2421 20.303C17.9039 19.389 17.7348 18.932 17.4014 18.5986C17.068 18.2652 16.611 18.0961 15.697 17.7579L15 17.5L15.697 17.2421C16.611 16.9039 17.068 16.7347 17.4014 16.4014C17.7348 16.068 17.9039 15.611 18.2421 14.697L18.5 14Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiMail02' icon.
  static const List<List<dynamic>> aiMail02 = strokeRoundedAiMail02;

  /// JSON structure for the 'strokeRoundedAiMic' icon.
  static const List<List<dynamic>> strokeRoundedAiMic = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M17 11C17 13.7614 14.7614 16 12 16C9.23858 16 7 13.7614 7 11V7C7 4.23858 9.23858 2 12 2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M20 11C20 15.4183 16.4183 19 12 19M12 19C7.58172 19 4 15.4183 4 11M12 19V22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M14.3327 4.64612C15.5394 4.49594 16.4959 3.53944 16.6461 2.33267C16.6689 2.14999 16.8159 2 17 2C17.1841 2 17.3311 2.14999 17.3539 2.33267C17.5041 3.53944 18.4606 4.49594 19.6673 4.64612C19.85 4.66885 20 4.81591 20 5C20 5.1841 19.85 5.33115 19.6673 5.35388C18.4606 5.50406 17.5041 6.46056 17.3539 7.66733C17.3311 7.85001 17.1841 8 17 8C16.8159 8 16.6689 7.85001 16.6461 7.66733C16.4959 6.46056 15.5394 5.50406 14.3327 5.35388C14.15 5.33115 14 5.1841 14 5C14 4.81591 14.15 4.66885 14.3327 4.64612Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiMic' icon.
  static const List<List<dynamic>> aiMic = strokeRoundedAiMic;

  /// JSON structure for the 'strokeRoundedAiNetwork' icon.
  static const List<List<dynamic>> strokeRoundedAiNetwork = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M21.25 5.5C20.8358 5.5 20.5 5.16421 20.5 4.75C20.5 4.33579 20.8358 4 21.25 4C21.6642 4 22 4.33579 22 4.75C22 5.16421 21.6642 5.5 21.25 5.5ZM21.25 5.5V9.25C21.25 9.94778 21.25 10.2967 21.1639 10.5806C20.97 11.2198 20.4698 11.72 19.8306 11.9139C19.5467 12 19.1978 12 18.5 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M2.75 18.5C3.16421 18.5 3.5 18.8358 3.5 19.25C3.5 19.6642 3.16421 20 2.75 20C2.33579 20 2 19.6642 2 19.25C2 18.8358 2.33579 18.5 2.75 18.5ZM2.75 18.5L2.75 14.75C2.75 14.0522 2.75 13.7033 2.83612 13.4194C3.03002 12.7802 3.53023 12.28 4.16943 12.0861C4.45333 12 4.80222 12 5.5 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M5.5 2.75009C5.5 3.16431 5.16421 3.50009 4.75 3.50009C4.33579 3.50009 4 3.16431 4 2.75009C4 2.33588 4.33579 2.00009 4.75 2.00009C5.16421 2.00009 5.5 2.33588 5.5 2.75009ZM5.5 2.75009L9.25 2.75009C9.94778 2.75009 10.2967 2.75009 10.5806 2.83621C11.2198 3.03011 11.72 3.53032 11.9139 4.16952C12 4.45342 12 4.80231 12 5.50009',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M18.5 21.2501C18.5 20.8359 18.8358 20.5001 19.25 20.5001C19.6642 20.5001 20 20.8359 20 21.2501C20 21.6643 19.6642 22.0001 19.25 22.0001C18.8358 22.0001 18.5 21.6643 18.5 21.2501ZM18.5 21.2501L14.75 21.2501C14.0522 21.2501 13.7033 21.2501 13.4194 21.164C12.7802 20.9701 12.28 20.4699 12.0861 19.8307C12 19.5468 12 19.1979 12 18.5001',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M5.54883 11.9512C5.54883 8.88704 5.54883 7.35498 6.50073 6.40307C7.45263 5.45117 8.9847 5.45117 12.0488 5.45117C15.113 5.45117 16.645 5.45117 17.5969 6.40307C18.5488 7.35498 18.5488 8.88704 18.5488 11.9512C18.5488 15.0153 18.5488 16.5474 17.5969 17.4993C16.645 18.4512 15.113 18.4512 12.0488 18.4512C8.9847 18.4512 7.45263 18.4512 6.50073 17.4993C5.54883 16.5474 5.54883 15.0153 5.54883 11.9512Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd':
            'M12.499 14.5L11.0384 9.97891C10.9465 9.69466 10.6648 9.5 10.3452 9.5C10.0256 9.5 9.74382 9.69466 9.65199 9.97891L8.19133 14.5M14.9989 9.5V14.5M8.72979 13H11.9606',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiNetwork' icon.
  static const List<List<dynamic>> aiNetwork = strokeRoundedAiNetwork;

  /// JSON structure for the 'strokeRoundedAiPhone01' icon.
  static const List<List<dynamic>> strokeRoundedAiPhone01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M17 14.9996C17 18.2996 17 19.9496 16.0481 20.9748C15.0962 22 13.5641 22 10.5 22C7.43587 22 5.90381 22 4.9519 20.9748C4 19.9496 4 18.2996 4 14.9996V8.99919C4 5.69916 4 4.04914 4.9519 3.02395C5.80236 2.10801 7.11592 2.0104 9.57143 2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M16 4H14C13.0572 4 12.5858 4 12.2929 4.29289C12 4.58579 12 5.05719 12 6V8C12 8.94281 12 9.41421 12.2929 9.70711C12.5858 10 13.0572 10 14 10H16C16.9428 10 17.4142 10 17.7071 9.70711C18 9.41421 18 8.94281 18 8V6C18 5.05719 18 4.58579 17.7071 4.29289C17.4142 4 16.9428 4 16 4Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M13.5 10V12M16.5 10V12M13.5 2V4M16.5 2V4M12 5.5H10M12 8.5H10M20 5.5H18M20 8.5H18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M10.49 19H10.499',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiPhone01' icon.
  static const List<List<dynamic>> aiPhone01 = strokeRoundedAiPhone01;

  /// JSON structure for the 'strokeRoundedAiPhone02' icon.
  static const List<List<dynamic>> strokeRoundedAiPhone02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M20.25 6.75L18 9L16 9M19.5 6.75C19.5 7.16421 19.8358 7.5 20.25 7.5C20.6642 7.5 21 7.16421 21 6.75C21 6.33579 20.6642 6 20.25 6C19.8358 6 19.5 6.33579 19.5 6.75Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M20.25 17.25L18 15L16 15M19.5 17.25C19.5 16.8358 19.8358 16.5 20.25 16.5C20.6642 16.5 21 16.8358 21 17.25C21 17.6642 20.6642 18 20.25 18C19.8358 18 19.5 17.6642 19.5 17.25Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M20.25 12L12 12M19.5 12C19.5 12.4142 19.8358 12.75 20.25 12.75C20.6642 12.75 21 12.4142 21 12C21 11.5858 20.6642 11.25 20.25 11.25C19.8358 11.25 19.5 11.5858 19.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M9.5 19H9.50898',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M16 6C15.9194 4.58055 15.6981 3.67665 15.091 3.02513C14.1357 2 12.5981 2 9.52312 2C6.44809 2 4.91058 2 3.95529 3.02513C3 4.05025 3 5.70017 3 9V15C3 18.2998 3 19.9497 3.95529 20.9749C4.91058 22 6.44809 22 9.52312 22C12.5981 22 14.1357 22 15.091 20.9749C15.6981 20.3233 15.9194 19.4194 16 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiPhone02' icon.
  static const List<List<dynamic>> aiPhone02 = strokeRoundedAiPhone02;

  /// JSON structure for the 'strokeRoundedAiProgramming' icon.
  static const List<List<dynamic>> strokeRoundedAiProgramming = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M11.5 6C7.02166 6 4.78249 6 3.39124 7.17157C2 8.34315 2 10.2288 2 14C2 17.7712 2 19.6569 3.39124 20.8284C4.78249 22 7.02166 22 11.5 22C15.9783 22 18.2175 22 19.6088 20.8284C21 19.6569 21 17.7712 21 14C21 12.8302 21 11.8419 20.9585 11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18.5 2L18.7579 2.69703C19.0961 3.61102 19.2652 4.06802 19.5986 4.40139C19.932 4.73477 20.389 4.90387 21.303 5.24208L22 5.5L21.303 5.75792C20.389 6.09613 19.932 6.26524 19.5986 6.59861C19.2652 6.93198 19.0961 7.38898 18.7579 8.30297L18.5 9L18.2421 8.30297C17.9039 7.38898 17.7348 6.93198 17.4014 6.59861C17.068 6.26524 16.611 6.09613 15.697 5.75792L15 5.5L15.697 5.24208C16.611 4.90387 17.068 4.73477 17.4014 4.40139C17.7348 4.06802 17.9039 3.61102 18.2421 2.69703L18.5 2Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M15.5 12L16.7265 13.0572C17.2422 13.5016 17.5 13.7239 17.5 14C17.5 14.2761 17.2422 14.4984 16.7265 14.9428L15.5 16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M7.5 12L6.27346 13.0572C5.75782 13.5016 5.5 13.7239 5.5 14C5.5 14.2761 5.75782 14.4984 6.27346 14.9428L7.5 16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M12.5 11L10.5 17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiProgramming' icon.
  static const List<List<dynamic>> aiProgramming = strokeRoundedAiProgramming;

  /// JSON structure for the 'strokeRoundedAiScan' icon.
  static const List<List<dynamic>> strokeRoundedAiScan = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 16.5C2.5 17.4293 2.5 17.894 2.57686 18.2804C2.89249 19.8671 4.13288 21.1075 5.71964 21.4231C6.10603 21.5 6.57069 21.5 7.5 21.5M21.5 16.5C21.5 17.4293 21.5 17.894 21.4231 18.2804C21.1075 19.8671 19.8671 21.1075 18.2804 21.4231C17.894 21.5 17.4293 21.5 16.5 21.5M21.5 7.5C21.5 6.57069 21.5 6.10603 21.4231 5.71964C21.1075 4.13288 19.8671 2.89249 18.2804 2.57686C17.894 2.5 17.4293 2.5 16.5 2.5M2.5 7.5C2.5 6.57069 2.5 6.10603 2.57686 5.71964C2.89249 4.13288 4.13288 2.89249 5.71964 2.57686C6.10603 2.5 6.57069 2.5 7.5 2.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12 8.5V6.5M10 11.5V12M14 11.5V12M11 8.5H13C14.8856 8.5 15.8284 8.5 16.4142 9.08579C17 9.67157 17 10.6144 17 12.5V12.5C17 14.3856 17 15.3284 16.4142 15.9142C15.8284 16.5 14.8856 16.5 13 16.5H11C9.11438 16.5 8.17157 16.5 7.58579 15.9142C7 15.3284 7 14.3856 7 12.5V12.5C7 10.6144 7 9.67157 7.58579 9.08579C8.17157 8.5 9.11438 8.5 11 8.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiScan' icon.
  static const List<List<dynamic>> aiScan = strokeRoundedAiScan;

  /// JSON structure for the 'strokeRoundedAiScheduling' icon.
  static const List<List<dynamic>> strokeRoundedAiScheduling = [
    [
      'path',
      {
        'key': '0',
        'd': 'M18 2V5M6 2V5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M10.5 3.5H13.5C17.2712 3.5 19.1569 3.5 20.3284 4.67157C21.5 5.84315 21.5 7.72876 21.5 11.5V14C21.5 17.7712 21.5 19.6569 20.3284 20.8284C19.1569 22 17.2712 22 13.5 22H10.5C6.72876 22 4.84315 22 3.67157 20.8284C2.5 19.6569 2.5 17.7712 2.5 14V11.5C2.5 7.72876 2.5 5.84315 3.67157 4.67157C4.84315 3.5 6.72876 3.5 10.5 3.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M3 8H21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M8.44356 14.5282C10.0526 14.3279 11.3279 13.0526 11.5282 11.4436C11.5585 11.2 11.7545 11 12 11C12.2455 11 12.4415 11.2 12.4718 11.4436C12.6721 13.0526 13.9474 14.3279 15.5564 14.5282C15.8 14.5585 16 14.7545 16 15C16 15.2455 15.8 15.4415 15.5564 15.4718C13.9474 15.6721 12.6721 16.9474 12.4718 18.5564C12.4415 18.8 12.2455 19 12 19C11.7545 19 11.5585 18.8 11.5282 18.5564C11.3279 16.9474 10.0526 15.6721 8.44356 15.4718C8.19998 15.4415 8 15.2455 8 15C8 14.7545 8.19998 14.5585 8.44356 14.5282Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiScheduling' icon.
  static const List<List<dynamic>> aiScheduling = strokeRoundedAiScheduling;

  /// JSON structure for the 'strokeRoundedAiSearch' icon.
  static const List<List<dynamic>> strokeRoundedAiSearch = [
    [
      'path',
      {
        'key': '0',
        'd': 'M17.5 17.5L22 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M20 11C20 6.02944 15.9706 2 11 2C6.02944 2 2 6.02944 2 11C2 15.9706 6.02944 20 11 20C15.9706 20 20 15.9706 20 11Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M6.5 14L8.34189 8.47434C8.43631 8.19107 8.7014 8 9 8C9.2986 8 9.56369 8.19107 9.65811 8.47434L11.5 14M14.5 8V14M7.5 12H10.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiSearch' icon.
  static const List<List<dynamic>> aiSearch = strokeRoundedAiSearch;

  /// JSON structure for the 'strokeRoundedAiSearch02' icon.
  static const List<List<dynamic>> strokeRoundedAiSearch02 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M16.0001 16.5L20 20.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18 11.5C18 15.366 14.866 18.5 11 18.5C7.13401 18.5 4 15.366 4 11.5C4 7.63404 7.13401 4.50003 11 4.50003',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M15.5 3.50003L15.7579 4.19706C16.0961 5.11105 16.2652 5.56805 16.5986 5.90142C16.932 6.2348 17.389 6.4039 18.303 6.74211L19 7.00003L18.303 7.25795C17.389 7.59616 16.932 7.76527 16.5986 8.09864C16.2652 8.43201 16.0961 8.88901 15.7579 9.803L15.5 10.5L15.2421 9.803C14.9039 8.88901 14.7348 8.43201 14.4014 8.09864C14.068 7.76527 13.611 7.59616 12.697 7.25795L12 7.00003L12.697 6.74211C13.611 6.4039 14.068 6.2348 14.4014 5.90142C14.7348 5.56805 14.9039 5.11105 15.2421 4.19706L15.5 3.50003Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiSearch02' icon.
  static const List<List<dynamic>> aiSearch02 = strokeRoundedAiSearch02;

  /// JSON structure for the 'strokeRoundedAiSecurity01' icon.
  static const List<List<dynamic>> strokeRoundedAiSecurity01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M10.461 6.50098V8.48M6.99998 10.0014H9.03668M14.9633 10.0014H17M14.9633 12.9746H17M6.99998 12.9746H9.03668M10.461 14.5202V16.4992M13.464 14.5202V16.4992M13.4533 6.50098V8.48M10.0292 14.4685H13.9707C14.5189 14.4685 14.9633 14.0208 14.9633 13.4685V9.48C14.9633 8.92771 14.5189 8.48 13.9707 8.48H10.0292C9.48106 8.48 9.03668 8.92771 9.03668 9.48V13.4685C9.03668 14.0208 9.48106 14.4685 10.0292 14.4685Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M21 11.1833V8.28029C21 6.64029 21 5.82028 20.5959 5.28529C20.1918 4.75029 19.2781 4.49056 17.4507 3.9711C16.2021 3.6162 15.1016 3.18863 14.2223 2.79829C13.0234 2.2661 12.4239 2 12 2C11.576 2 10.9766 2.2661 9.7777 2.79829C8.89837 3.18863 7.79782 3.61619 6.54931 3.9711C4.72191 4.49056 3.80821 4.75029 3.4041 5.28529C2.99998 5.82028 2.99998 6.64029 2.99998 8.28029V11.1833C2.99998 16.8085 8.06276 20.1835 10.5939 21.5194C11.201 21.8398 11.5046 22 12 22C12.4954 22 12.7989 21.8398 13.406 21.5194C15.9372 20.1835 21 16.8085 21 11.1833Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiSecurity01' icon.
  static const List<List<dynamic>> aiSecurity01 = strokeRoundedAiSecurity01;

  /// JSON structure for the 'strokeRoundedAiSecurity02' icon.
  static const List<List<dynamic>> strokeRoundedAiSecurity02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M7.5 14.5L9.34189 8.97434C9.43631 8.69107 9.7014 8.5 10 8.5C10.2986 8.5 10.5637 8.69107 10.6581 8.97434L12.5 14.5M15.5 8.5V14.5M8.5 12.5H11.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M21 11.1832V8.28017C21 6.64016 21 5.82016 20.5959 5.28517C20.1918 4.75017 19.2781 4.49044 17.4507 3.97098C16.2022 3.61607 15.1016 3.18851 14.2223 2.79817C13.0234 2.26597 12.424 1.99988 12 1.99988C11.576 1.99988 10.9766 2.26597 9.77771 2.79817C8.89839 3.1885 7.79784 3.61607 6.54933 3.97098C4.72193 4.49044 3.80822 4.75017 3.40411 5.28517C3 5.82016 3 6.64016 3 8.28017V11.1832C3 16.8084 8.06277 20.1834 10.594 21.5193C11.2011 21.8397 11.5046 21.9999 12 21.9999C12.4954 21.9999 12.7989 21.8397 13.406 21.5193C15.9372 20.1834 21 16.8084 21 11.1832Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiSecurity02' icon.
  static const List<List<dynamic>> aiSecurity02 = strokeRoundedAiSecurity02;

  /// JSON structure for the 'strokeRoundedAiSecurity03' icon.
  static const List<List<dynamic>> strokeRoundedAiSecurity03 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M11.6769 8.67348C11.8274 8.43697 12.1726 8.43697 12.3231 8.67348L12.7586 9.35767C13.2401 10.1143 13.8818 10.756 14.6384 11.2375L15.3226 11.6729C15.5591 11.8235 15.5591 12.1687 15.3226 12.3192L14.6384 12.7547C13.8818 13.2362 13.2401 13.8779 12.7586 14.6345L12.3231 15.3187C12.1726 15.5552 11.8274 15.5552 11.6769 15.3187L11.2414 14.6345C10.7599 13.8779 10.1182 13.2362 9.36157 12.7547L8.67738 12.3192C8.44087 12.1687 8.44087 11.8235 8.67738 11.6729L9.36157 11.2375C10.1182 10.756 10.7599 10.1143 11.2414 9.35767L11.6769 8.67348Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M3.9068 5.28387C6.87149 5.4984 8.78311 2.49713 12.0262 2.49713C15.2208 2.43341 16.784 5.32395 20.059 5.32395C21.8147 14.2606 18.1622 19.8743 12.053 21.4961C6.38992 20.15 2.13481 14.4788 3.9068 5.28387Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiSecurity03' icon.
  static const List<List<dynamic>> aiSecurity03 = strokeRoundedAiSecurity03;

  /// JSON structure for the 'strokeRoundedAiSetting' icon.
  static const List<List<dynamic>> strokeRoundedAiSetting = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M15.5 11.5C15.5 13.433 13.933 15 12 15C10.067 15 8.5 13.433 8.5 11.5C8.5 9.567 10.067 8 12 8C13.933 8 15.5 9.567 15.5 11.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M21 13.5995C21.3155 13.5134 21.6503 13.4669 22 13.4669V9.53324C19.1433 9.53324 17.2857 6.43041 18.732 3.96691L15.2679 2.0001C13.8038 4.49405 10.1978 4.49395 8.73363 2L5.26953 3.96681C6.71586 6.43035 4.85673 9.53324 2 9.53324V13.4669C4.85668 13.4669 6.71425 16.5697 5.26795 19.0332L8.73205 21C9.46434 19.7527 10.7321 19.1289 12 19.1286',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M18.5 15L18.7579 15.697C19.0961 16.611 19.2652 17.068 19.5986 17.4014C19.932 17.7348 20.389 17.9039 21.303 18.2421L22 18.5L21.303 18.7579C20.389 19.0961 19.932 19.2652 19.5986 19.5986C19.2652 19.932 19.0961 20.389 18.7579 21.303L18.5 22L18.2421 21.303C17.9039 20.389 17.7348 19.932 17.4014 19.5986C17.068 19.2652 16.611 19.0961 15.697 18.7579L15 18.5L15.697 18.2421C16.611 17.9039 17.068 17.7348 17.4014 17.4014C17.7348 17.068 17.9039 16.611 18.2421 15.697L18.5 15Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiSetting' icon.
  static const List<List<dynamic>> aiSetting = strokeRoundedAiSetting;

  /// JSON structure for the 'strokeRoundedAiSheets' icon.
  static const List<List<dynamic>> strokeRoundedAiSheets = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12 21H10C6.22876 21 4.34315 21 3.17157 19.8284C2 18.6569 2 16.7712 2 13V11C2 7.22876 2 5.34315 3.17157 4.17157C4.34315 3 6.22876 3 10 3H14C17.7712 3 19.6569 3 20.8284 4.17157C22 5.34315 22 7.22876 22 11V12.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M2 9H22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M2 15H12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M17.5803 13.2673C17.7466 12.9109 18.2534 12.9109 18.4197 13.2673L19.0465 14.6104C19.3226 15.2019 19.7981 15.6774 20.3896 15.9535L21.7327 16.5803C22.0891 16.7466 22.0891 17.2534 21.7327 17.4197L20.3896 18.0465C19.7981 18.3226 19.3226 18.7981 19.0465 19.3896L18.4197 20.7327C18.2534 21.0891 17.7466 21.0891 17.5803 20.7327L16.9535 19.3896C16.6774 18.7981 16.2019 18.3226 15.6104 18.0465L14.2673 17.4197C13.9109 17.2534 13.9109 16.7466 14.2673 16.5803L15.6104 15.9535C16.2019 15.6774 16.6774 15.2019 16.9535 14.6104L17.5803 13.2673Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M8 3V21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiSheets' icon.
  static const List<List<dynamic>> aiSheets = strokeRoundedAiSheets;

  /// JSON structure for the 'strokeRoundedAiSmartwatch' icon.
  static const List<List<dynamic>> strokeRoundedAiSmartwatch = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M14.1213 17.1213C13.2426 18 11.8284 18 9 18C6.17157 18 4.75736 18 3.87868 17.1213C3 16.2426 3 14.8284 3 12C3 9.17157 3 7.75736 3.87868 6.87868C4.75736 6 6.17157 6 9 6C11.8284 6 13.2426 6 14.1213 6.87868',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M20.25 6.75L18 9L16 9M19.5 6.75C19.5 7.16421 19.8358 7.5 20.25 7.5C20.6642 7.5 21 7.16421 21 6.75C21 6.33579 20.6642 6 20.25 6C19.8358 6 19.5 6.33579 19.5 6.75Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M20.25 17.25L18 15L16 15M19.5 17.25C19.5 16.8358 19.8358 16.5 20.25 16.5C20.6642 16.5 21 16.8358 21 17.25C21 17.6642 20.6642 18 20.25 18C19.8358 18 19.5 17.6642 19.5 17.25Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M20.25 12L12 12M19.5 12C19.5 12.4142 19.8358 12.75 20.25 12.75C20.6642 12.75 21 12.4142 21 12C21 11.5858 20.6642 11.25 20.25 11.25C19.8358 11.25 19.5 11.5858 19.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M13 6L12.7276 4.91043C12.3931 3.5724 12.2258 2.90339 11.7499 2.49004C11.6973 2.44433 11.6423 2.40141 11.5852 2.36145C11.0688 2 10.3792 2 9 2C7.6208 2 6.93119 2 6.41476 2.36145C6.35765 2.40141 6.30268 2.44433 6.25006 2.49004C5.77415 2.90339 5.6069 3.5724 5.27239 4.91043L5 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd':
            'M5 18L5.27239 19.0896C5.6069 20.4276 5.77415 21.0966 6.25006 21.51C6.30268 21.5557 6.35765 21.5986 6.41476 21.6386C6.93119 22 7.6208 22 9 22C10.3792 22 11.0688 22 11.5852 21.6386C11.6423 21.5986 11.6973 21.5557 11.7499 21.51C12.2258 21.0966 12.3931 20.4276 12.7276 19.0896L13 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiSmartwatch' icon.
  static const List<List<dynamic>> aiSmartwatch = strokeRoundedAiSmartwatch;

  /// JSON structure for the 'strokeRoundedAiUser' icon.
  static const List<List<dynamic>> strokeRoundedAiUser = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M13 3.00231C12.5299 3 12.0307 3 11.5 3C7.02166 3 4.78249 3 3.39124 4.39124C2 5.78249 2 8.02166 2 12.5C2 16.9783 2 19.2175 3.39124 20.6088C4.78249 22 7.02166 22 11.5 22C15.9783 22 18.2175 22 19.6088 20.6088C21 19.2175 21 16.9783 21 12.5C21 11.9693 21 11.4701 20.9977 11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18.5 2L18.7579 2.69703C19.0961 3.61102 19.2652 4.06802 19.5986 4.40139C19.932 4.73477 20.389 4.90387 21.303 5.24208L22 5.5L21.303 5.75792C20.389 6.09613 19.932 6.26524 19.5986 6.59861C19.2652 6.93198 19.0961 7.38898 18.7579 8.30297L18.5 9L18.2421 8.30297C17.9039 7.38898 17.7348 6.93198 17.4014 6.59861C17.068 6.26524 16.611 6.09613 15.697 5.75792L15 5.5L15.697 5.24208C16.611 4.90387 17.068 4.73477 17.4014 4.40139C17.7348 4.06802 17.9039 3.61102 18.2421 2.69703L18.5 2Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M7 17.5C9.3317 15.0578 13.6432 14.9428 16 17.5M13.9951 10C13.9951 11.3807 12.8742 12.5 11.4915 12.5C10.1089 12.5 8.98797 11.3807 8.98797 10C8.98797 8.61929 10.1089 7.5 11.4915 7.5C12.8742 7.5 13.9951 8.61929 13.9951 10Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiUser' icon.
  static const List<List<dynamic>> aiUser = strokeRoundedAiUser;

  /// JSON structure for the 'strokeRoundedAiVideo' icon.
  static const List<List<dynamic>> strokeRoundedAiVideo = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M14.4531 12.8948C14.3016 13.5215 13.5857 13.9644 12.1539 14.8502C10.7697 15.7064 10.0777 16.1346 9.51993 15.9625C9.28934 15.8913 9.07925 15.7562 8.90982 15.57C8.5 15.1198 8.5 14.2465 8.5 12.5C8.5 10.7535 8.5 9.88018 8.90982 9.42995C9.07925 9.24381 9.28934 9.10868 9.51993 9.03753C10.0777 8.86544 10.7697 9.29357 12.1539 10.1498C13.5857 11.0356 14.3016 11.4785 14.4531 12.1052C14.5156 12.3639 14.5156 12.6361 14.4531 12.8948Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M20.9977 11C21 11.4701 21 11.9693 21 12.5C21 16.9783 21 19.2175 19.6088 20.6088C18.2175 22 15.9783 22 11.5 22C7.02166 22 4.78249 22 3.39124 20.6088C2 19.2175 2 16.9783 2 12.5C2 8.02166 2 5.78249 3.39124 4.39124C4.78249 3 7.02166 3 11.5 3C12.0307 3 12.5299 3 13 3.00231',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M18.5 2L18.7579 2.69703C19.0961 3.61102 19.2652 4.06802 19.5986 4.40139C19.932 4.73477 20.389 4.90387 21.303 5.24208L22 5.5L21.303 5.75792C20.389 6.09613 19.932 6.26524 19.5986 6.59861C19.2652 6.93198 19.0961 7.38898 18.7579 8.30297L18.5 9L18.2421 8.30297C17.9039 7.38898 17.7348 6.93198 17.4014 6.59861C17.068 6.26524 16.611 6.09613 15.697 5.75792L15 5.5L15.697 5.24208C16.611 4.90387 17.068 4.73477 17.4014 4.40139C17.7348 4.06802 17.9039 3.61102 18.2421 2.69703L18.5 2Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiVideo' icon.
  static const List<List<dynamic>> aiVideo = strokeRoundedAiVideo;

  /// JSON structure for the 'strokeRoundedAiView' icon.
  static const List<List<dynamic>> strokeRoundedAiView = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4.75 2.75L7 5L7 8M4.75 3.5C5.16421 3.5 5.5 3.16421 5.5 2.75C5.5 2.33579 5.16421 2 4.75 2C4.33579 2 4 2.33579 4 2.75C4 3.16421 4.33579 3.5 4.75 3.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M19.25 2.75L17 5L17 8M19.25 3.5C18.8358 3.5 18.5 3.16421 18.5 2.75C18.5 2.33579 18.8358 2 19.25 2C19.6642 2 20 2.33579 20 2.75C20 3.16421 19.6642 3.5 19.25 3.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M12 2.75L12 7M12 3.5C12.4142 3.5 12.75 3.16421 12.75 2.75C12.75 2.33579 12.4142 2 12 2C11.5858 2 11.25 2.33579 11.25 2.75C11.25 3.16421 11.5858 3.5 12 3.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M15 16C15 14.3431 13.6569 13 12 13C10.3431 13 9 14.3431 9 16C9 17.6569 10.3431 19 12 19C13.6569 19 15 17.6569 15 16Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M12 10C18 10 22 16 22 16C22 16 18 22 12 22C6 22 2 16 2 16C2 16 6 10 12 10Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiView' icon.
  static const List<List<dynamic>> aiView = strokeRoundedAiView;

  /// JSON structure for the 'strokeRoundedAiVisionRecognition' icon.
  static const List<List<dynamic>> strokeRoundedAiVisionRecognition = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M22 12C22 12 19 19 12 19C5 19 2 12 2 12C2 12 5 5 12 5C18.5 5 22 12 22 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M11.6769 8.67738C11.8274 8.44087 12.1726 8.44087 12.3231 8.67738L12.7586 9.36157C13.2401 10.1182 13.8818 10.7599 14.6384 11.2414L15.3226 11.6769C15.5591 11.8274 15.5591 12.1726 15.3226 12.3231L14.6384 12.7586C13.8818 13.2401 13.2401 13.8818 12.7586 14.6384L12.3231 15.3226C12.1726 15.5591 11.8274 15.5591 11.6769 15.3226L11.2414 14.6384C10.7599 13.8818 10.1182 13.2401 9.36157 12.7586L8.67738 12.3231C8.44087 12.1726 8.44087 11.8274 8.67738 11.6769L9.36157 11.2414C10.1182 10.7599 10.7599 10.1182 11.2414 9.36157L11.6769 8.67738Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiVisionRecognition' icon.
  static const List<List<dynamic>> aiVisionRecognition =
      strokeRoundedAiVisionRecognition;

  /// JSON structure for the 'strokeRoundedAiVoice' icon.
  static const List<List<dynamic>> strokeRoundedAiVoice = [
    [
      'path',
      {
        'key': '0',
        'd': 'M9 11V14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M11.5 3C7.27027 3 5.1554 3 3.75276 4.19797C3.55358 4.36808 3.36808 4.55358 3.19797 4.75276C2 6.1554 2 8.27027 2 12.5C2 16.7297 2 18.8446 3.19797 20.2472C3.36808 20.4464 3.55358 20.6319 3.75276 20.802C5.1554 22 7.27027 22 11.5 22C15.7297 22 17.8446 22 19.2472 20.802C19.4464 20.6319 19.6319 20.4464 19.802 20.2472C21 18.8446 21 16.7297 21 12.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 8V17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M15 10V15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M6 12V13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd':
            'M15.3881 5.08714C16.796 4.91193 17.9119 3.79602 18.0871 2.38812C18.1137 2.17498 18.2852 2 18.5 2C18.7148 2 18.8863 2.17498 18.9129 2.38812C19.0881 3.79602 20.204 4.91193 21.6119 5.08714C21.825 5.11366 22 5.28522 22 5.5C22 5.71478 21.825 5.88634 21.6119 5.91286C20.204 6.08807 19.0881 7.20398 18.9129 8.61188C18.8863 8.82502 18.7148 9 18.5 9C18.2852 9 18.1137 8.82502 18.0871 8.61188C17.9119 7.20398 16.796 6.08807 15.3881 5.91286C15.175 5.88634 15 5.71478 15 5.5C15 5.28522 15.175 5.11366 15.3881 5.08714Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiVoice' icon.
  static const List<List<dynamic>> aiVoice = strokeRoundedAiVoice;

  /// JSON structure for the 'strokeRoundedAiVoiceGenerator' icon.
  static const List<List<dynamic>> strokeRoundedAiVoiceGenerator = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M17.4069 13.4036C17.6192 12.8655 18.3808 12.8655 18.5931 13.4036L18.6298 13.4969C19.1482 14.8113 20.1887 15.8518 21.5031 16.3702L21.5964 16.4069C22.1345 16.6192 22.1345 17.3808 21.5964 17.5931L21.5031 17.6298C20.1887 18.1482 19.1482 19.1887 18.6298 20.5031L18.5931 20.5964C18.3808 21.1345 17.6192 21.1345 17.4069 20.5964L17.3702 20.5031C16.8518 19.1887 15.8113 18.1482 14.4969 17.6298L14.4036 17.5931C13.8655 17.3808 13.8655 16.6192 14.4036 16.4069L14.4969 16.3702C15.8113 15.8518 16.8518 14.8113 17.3702 13.4969L17.4069 13.4036Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M22 11V9C22 6.17157 22 4.75736 21.1213 3.87868C20.2426 3 18.8284 3 16 3H8C5.17157 3 3.75736 3 2.87868 3.87868C2 4.75736 2 6.17157 2 9C2 11.8284 2 13.2426 2.87868 14.1213C3.75736 15 5.17157 15 8 15H11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M6 8V10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M15 7V11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M12 8.5V9.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M18 8.5V9.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd': 'M9 7V11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiVoiceGenerator' icon.
  static const List<List<dynamic>> aiVoiceGenerator =
      strokeRoundedAiVoiceGenerator;

  /// JSON structure for the 'strokeRoundedAiWebBrowsing' icon.
  static const List<List<dynamic>> strokeRoundedAiWebBrowsing = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M11.5379 8.32172C11.6966 7.89276 12.3034 7.89276 12.4621 8.32172L13.1735 10.2443C13.2733 10.514 13.486 10.7267 13.7557 10.8265L15.6783 11.5379C16.1072 11.6966 16.1072 12.3034 15.6783 12.4621L13.7557 13.1735C13.486 13.2733 13.2733 13.486 13.1735 13.7557L12.4621 15.6783C12.3034 16.1072 11.6966 16.1072 11.5379 15.6783L10.8265 13.7557C10.7267 13.486 10.514 13.2733 10.2443 13.1735L8.32172 12.4621C7.89276 12.3034 7.89276 11.6966 8.32172 11.5379L10.2443 10.8265C10.514 10.7267 10.7267 10.514 10.8265 10.2443L11.5379 8.32172Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'circle',
      {
        'key': '1',
        'cx': '12',
        'cy': '12',
        'r': '10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M8 8C8.67327 4.46819 10.2109 2 12 2C13.7891 2 15.3267 4.46819 16 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M8 16C8.67327 19.5318 10.2109 22 12 22C13.7891 22 15.3267 19.5318 16 16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M2 12H4.5M22 12H19.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAiWebBrowsing' icon.
  static const List<List<dynamic>> aiWebBrowsing = strokeRoundedAiWebBrowsing;

  /// JSON structure for the 'strokeRoundedAids' icon.
  static const List<List<dynamic>> strokeRoundedAids = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12 2C9.92705 2 6.88247 2.5672 6.29 4.89186C5.7657 6.94903 5.88763 8.4198 7.1936 10.1667L14.8875 20.4583C15.6615 21.4936 16.0486 22.0113 16.5727 21.9998C17.0969 21.9883 17.4599 21.4542 18.186 20.3859L18.7147 19.608C19.6223 18.2725 20.0762 17.6047 19.9895 16.883C19.9029 16.1613 19.3034 15.6152 18.1043 14.523L6.79911 4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12 2C14.0729 2 17.1175 2.5672 17.71 4.89186C18.2343 6.94903 18.1124 8.4198 16.8064 10.1667L15.4358 12M17.2009 4L12 8.84105M12 16.5959L9.11248 20.4583C8.33845 21.4936 7.95143 22.0113 7.42726 21.9998C6.90309 21.9883 6.54007 21.4542 5.81402 20.3859L5.28533 19.608C4.37768 18.2725 3.92383 17.6047 4.01046 16.883C4.09709 16.1613 4.69663 15.6152 5.89571 14.523L8.60624 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAids' icon.
  static const List<List<dynamic>> aids = strokeRoundedAids;

  /// JSON structure for the 'strokeRoundedAirbnb' icon.
  static const List<List<dynamic>> strokeRoundedAirbnb = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12 18.7753C10.3443 16.7754 9 15.5355 9 13.5C9 11.4645 10.5033 10 12.0033 10C13.5033 10 15 11.4645 15 13.5C15 15.5355 13.6557 16.7754 12 18.7753ZM12 18.7753C10 21.3198 6.02071 21.4621 4.34969 20.302C2.67867 19.1419 2.65485 16.7398 3.75428 14.1954C4.85371 11.651 6.31925 8.5977 9.25143 4.52665C10.2123 3.45799 10.8973 3 11.9967 3M12 18.7753C14 21.3198 17.9793 21.4621 19.6503 20.302C21.3213 19.1419 21.3451 16.7398 20.2457 14.1954C19.1463 11.651 17.6807 8.5977 14.7486 4.52665C13.7877 3.45799 13.1027 3 12.0033 3',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAirbnb' icon.
  static const List<List<dynamic>> airbnb = strokeRoundedAirbnb;

  /// JSON structure for the 'strokeRoundedAircraftGame' icon.
  static const List<List<dynamic>> strokeRoundedAircraftGame = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5.43876 16.2353C5.43876 15.9728 5.43048 15.7223 5.41491 15.4832M5.41491 15.4832C5.27345 13.3108 4.53006 12.0839 3.9244 11.4706C2.87884 12.5294 0.464067 16.7647 3.41663 19.9412L8.18741 17.8235C8.28323 18.2095 8.39847 18.5927 8.53467 18.9717C8.84621 19.8385 9.00197 20.272 9.51962 20.636C10.0373 21 10.6089 21 11.7522 21H12.2478C13.3911 21 13.9627 21 14.4804 20.636C14.998 20.272 15.1538 19.8385 15.4653 18.9717C15.6015 18.5927 15.7168 18.2095 15.8126 17.8235L20.5834 19.9412C23.5359 16.7647 21.1212 12.5294 20.0756 11.4706C19.4699 12.0839 18.7265 13.3108 18.5851 15.4832M5.41491 15.4832L6.51316 15.0678C7.12169 14.8376 7.42596 14.7225 7.59991 14.4928C7.77386 14.2631 7.80478 13.9083 7.86661 13.1989C8.25599 8.73199 10.4257 4.62034 12 3C13.5743 4.62034 15.744 8.73199 16.1334 13.1989C16.1952 13.9083 16.2261 14.2631 16.4001 14.4928C16.574 14.7225 16.8783 14.8376 17.4868 15.0678L18.5851 15.4832M18.5612 16.2353C18.5612 15.9728 18.5695 15.7223 18.5851 15.4832',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M12 10L12 11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M20 8V7M20 4V3',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M4 8V7M4 4V3',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAircraftGame' icon.
  static const List<List<dynamic>> aircraftGame = strokeRoundedAircraftGame;

  /// JSON structure for the 'strokeRoundedAirdrop' icon.
  static const List<List<dynamic>> strokeRoundedAirdrop = [
    [
      'circle',
      {
        'key': '0',
        'cx': '12',
        'cy': '11',
        'r': '2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M4 17.001C2.74418 15.3295 2 13.2516 2 11C2 5.47715 6.47715 1 12 1C17.5228 1 22 5.47715 22 11C22 13.2516 21.2558 15.3295 20 17.001',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M7.52779 15C6.57771 13.9385 6 12.5367 6 11C6 7.68629 8.68629 5 12 5C15.3137 5 18 7.68629 18 11C18 12.5367 17.4223 13.9385 16.4722 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M9.95154 17.8759C10.7222 16.758 11.1076 16.199 11.6078 16.0553C11.8644 15.9816 12.1356 15.9816 12.3922 16.0553C12.8924 16.199 13.2778 16.758 14.0485 17.8759C15.074 19.3633 15.5867 20.1071 15.488 20.727C15.4379 21.0414 15.2938 21.3315 15.076 21.5565C14.6465 22 13.7643 22 12 22C10.2357 22 9.35352 22 8.92399 21.5565C8.70617 21.3315 8.56205 21.0414 8.512 20.727C8.4133 20.1071 8.92605 19.3633 9.95154 17.8759Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAirdrop' icon.
  static const List<List<dynamic>> airdrop = strokeRoundedAirdrop;

  /// JSON structure for the 'strokeRoundedAirplane01' icon.
  static const List<List<dynamic>> strokeRoundedAirplane01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M15.8667 3.7804C16.7931 3.03188 17.8307 2.98644 18.9644 3.00233C19.5508 3.01055 19.844 3.01467 20.0792 3.10588C20.4524 3.2506 20.7494 3.54764 20.8941 3.92081C20.9853 4.15601 20.9894 4.4492 20.9977 5.03557C21.0136 6.16926 20.9681 7.20686 20.2196 8.13326C19.5893 8.91337 18.5059 9.32101 17.9846 10.1821C17.5866 10.8395 17.772 11.5203 17.943 12.2209L19.2228 17.4662C19.4779 18.5115 19.2838 19.1815 18.5529 19.9124C18.164 20.3013 17.8405 20.2816 17.5251 19.779L13.6627 13.6249L11.8181 15.0911C11.1493 15.6228 10.8149 15.8886 10.6392 16.2627C10.2276 17.1388 10.4889 18.4547 10.5022 19.4046C10.5096 19.9296 10.0559 20.9644 9.41391 20.9993C9.01756 21.0209 8.88283 20.5468 8.75481 20.2558L7.52234 17.4544C7.2276 16.7845 7.21552 16.7724 6.54556 16.4777L3.74415 15.2452C3.45318 15.1172 2.97914 14.9824 3.00071 14.5861C3.03565 13.9441 4.07036 13.4904 4.59536 13.4978C5.54532 13.5111 6.86122 13.7724 7.73734 13.3608C8.11142 13.1851 8.37724 12.8507 8.90888 12.1819L10.3751 10.3373L4.22103 6.47489C3.71845 6.15946 3.69872 5.83597 4.08755 5.44715C4.8185 4.7162 5.48851 4.52214 6.53377 4.77718L11.7791 6.05703C12.4797 6.22798 13.1605 6.41343 13.8179 6.0154C14.679 5.49411 15.0866 4.41074 15.8667 3.7804Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAirplane01' icon.
  static const List<List<dynamic>> airplane01 = strokeRoundedAirplane01;

  /// JSON structure for the 'strokeRoundedAirplane02' icon.
  static const List<List<dynamic>> strokeRoundedAirplane02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M10 9.50003L5.27531 4.47565C4.85705 4.0245 4.92403 3.69496 5.41729 3.40965C6.34454 2.8733 7.06689 2.85873 8.04428 3.39511L12.949 6.08675C13.2982 6.27836 13.6406 6.47259 14 6.57855',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12.5 13.6632L14.6103 20.4697C14.7826 21.0255 15.086 21.1263 15.556 20.8568C16.4396 20.3501 16.7958 19.765 16.8197 18.7107L16.9395 13.4198C16.9555 12.7131 16.9526 12.0215 17.5 11.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M8.32846 10.9843L10.2154 9.60557L14.6377 6.38136L14.6416 6.37851L14.6491 6.37301C14.7535 6.29661 16.3094 5.16238 17.1919 4.77581C18.2765 4.30067 19.2869 4.52156 20.3739 4.82515C20.9362 4.98218 21.2173 5.06069 21.4202 5.20717C21.742 5.43958 21.9513 5.79728 21.9943 6.18852C22.0215 6.4351 21.9498 6.71459 21.8065 7.27356L21.8065 7.27358C21.5294 8.35431 21.2181 9.32819 20.2588 10.0175C19.4782 10.5784 17.7045 11.341 17.5856 11.3919L17.5771 11.3955L17.5726 11.3974L12.5317 13.5645L10.3782 14.4876L10.3782 14.4876C9.5974 14.8223 9.207 14.9896 8.94139 15.3002C8.31933 16.0275 8.23148 17.3438 7.99931 18.2494C7.87101 18.7498 7.16748 19.6171 6.54058 19.4869C6.15355 19.4065 6.14613 18.922 6.09796 18.6131L5.6342 15.6389C5.5233 14.9276 5.51479 14.9131 4.94599 14.4627L2.56757 12.5793C2.32053 12.3836 1.89903 12.135 2.022 11.7641C2.22119 11.1633 3.33408 10.9957 3.83747 11.1363C4.74834 11.3907 5.94747 11.9738 6.89684 11.8058C7.3022 11.7341 7.64428 11.4842 8.32844 10.9843L8.32846 10.9843Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAirplane02' icon.
  static const List<List<dynamic>> airplane02 = strokeRoundedAirplane02;

  /// JSON structure for the 'strokeRoundedAirplaneLanding01' icon.
  static const List<List<dynamic>> strokeRoundedAirplaneLanding01 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M6.00146 19.9982H22.0015',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M3.69749 4.0419C3.07958 4.21042 3.00748 4.9179 2.82748 5.5179C2.67702 6.08216 2.3591 7.33035 2.14285 8.1831C1.98148 8.9379 1.95988 9.2379 2.05588 9.7179C2.28148 10.6179 3.06148 10.9719 4.74148 11.4399C5.58616 11.6559 6.18148 11.8371 7.08148 12.0771C7.23596 12.1265 7.71601 12.2476 8.10148 12.3519C8.46148 12.4779 8.76148 12.4419 8.69428 12.7179C8.64746 12.8276 8.10388 13.4379 7.59988 13.9779C7.26148 14.3979 7.03348 14.4998 7.03348 14.8179C7.03348 14.8179 7.02148 15.2979 7.69425 15.3579C7.80148 15.4179 9.24148 15.7779 9.78148 15.9339C10.5015 16.1139 11.0415 15.8979 11.4855 15.5979L13.6815 14.1579C14.1615 13.9419 14.2815 14.0331 14.8215 14.1771L19.6215 15.4779C20.4615 15.7779 21.1815 15.0579 20.9703 14.2179C20.7015 12.7179 20.2215 11.8179 19.4415 10.8579C18.1815 9.3579 16.6453 8.7727 15.5415 8.5779C15.0378 8.48901 13.144 8.33923 11.3415 8.2059C9.49393 8.06924 7.74222 7.94901 7.68148 7.8579C6.36148 7.5579 6.76948 5.6199 6.20548 4.7739C5.98148 4.4379 5.58148 4.3779 4.98148 4.1979C4.47299 4.06773 4.09616 3.93317 3.69749 4.0419Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAirplaneLanding01' icon.
  static const List<List<dynamic>> airplaneLanding01 =
      strokeRoundedAirplaneLanding01;

  /// JSON structure for the 'strokeRoundedAirplaneLanding02' icon.
  static const List<List<dynamic>> strokeRoundedAirplaneLanding02 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M2.49811 20.0009H18.4981',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M20.0477 11.0413C21.2211 10.6013 21.3977 10.0013 21.4727 9.60128C21.5977 9.10128 21.2977 7.82628 21.0227 6.85128C20.968 6.6395 20.531 4.98369 20.4677 4.80128C20.2227 3.92628 19.6227 3.96628 19.1977 4.02628C19.0227 4.06378 17.7977 4.39628 17.5977 4.49628C16.9227 4.90128 16.9977 5.97628 16.7977 6.67628C16.5727 7.70128 16.0477 7.85128 15.4477 7.95128C13.3477 8.10128 8.69772 8.47628 8.69772 8.47628C4.72272 8.82628 2.79772 12.0013 2.51272 14.3263C2.37272 15.3013 3.27272 15.6513 3.74772 15.5263L8.97272 14.1013C9.37272 13.9513 9.69772 14.0763 9.92272 14.2263L12.2477 15.7513C12.7727 16.0263 13.2477 16.0513 13.6727 15.9513L15.8477 15.3563C16.2977 15.3063 16.3872 15.0921 16.4477 14.9263C16.5366 14.6828 16.3458 14.4595 16.1227 14.2513C15.9977 14.0763 15.5977 13.6483 15.4477 13.4833C15.2477 13.2263 14.7588 12.8013 14.7977 12.6263C14.4977 12.5013 15.5674 12.3127 17.3477 11.8263C18.3595 11.5498 19.5264 11.2368 20.0477 11.0413Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAirplaneLanding02' icon.
  static const List<List<dynamic>> airplaneLanding02 =
      strokeRoundedAirplaneLanding02;

  /// JSON structure for the 'strokeRoundedAirplaneMode' icon.
  static const List<List<dynamic>> strokeRoundedAirplaneMode = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4.41712 11.9183L7.73859 9.89656C8.29597 9.55783 8.57467 9.38846 8.76705 9.15616C9.59962 8.15082 8.86644 6.66595 8.99059 5.49686C9.1191 4.28671 10.2731 2.63158 11.4364 2.11845C11.7944 1.96052 12.2051 1.96052 12.5631 2.11845C13.7264 2.63158 14.8804 4.28671 15.0089 5.49686C15.1331 6.66595 14.3999 8.15082 15.2325 9.15616C15.4248 9.38846 15.7035 9.55783 16.2609 9.89656L19.5827 11.9182C20.5993 12.5369 20.9998 13.1973 20.9998 14.4395C20.9998 15.1156 20.7006 15.2968 20.0973 15.1588L14.2725 13.8261L14.0109 16.1149C13.9161 16.9448 13.8687 17.3598 14.0058 17.7398C14.327 18.63 15.4173 19.3591 16.0832 20.0066C16.4513 20.3644 16.8529 21.3934 16.4333 21.8613C16.1742 22.1503 15.7533 21.9157 15.4637 21.803L12.675 20.7184C12.3416 20.5887 12.1748 20.5239 11.9998 20.5239C11.8247 20.5239 11.6579 20.5887 11.3245 20.7184L8.53584 21.803C8.24619 21.9157 7.82534 22.1503 7.56625 21.8613C7.1466 21.3934 7.54825 20.3644 7.91628 20.0066C8.5822 19.3591 9.67255 18.63 9.9937 17.7398C10.1308 17.3598 10.0834 16.9448 9.98857 16.1149L9.72703 13.8261L3.90259 15.1587C3.29902 15.2968 2.99982 15.1155 3.00001 14.4391C3.00034 13.1971 3.4007 12.537 4.41712 11.9183Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAirplaneMode' icon.
  static const List<List<dynamic>> airplaneMode = strokeRoundedAirplaneMode;

  /// JSON structure for the 'strokeRoundedAirplaneModeOff' icon.
  static const List<List<dynamic>> strokeRoundedAirplaneModeOff = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M13.1795 13.8261L12.9201 16.1149C12.8261 16.9448 12.779 17.3598 12.915 17.7398C13.2335 18.63 14.3149 19.3591 14.9753 20.0066C15.3403 20.3644 15.7386 21.3934 15.3224 21.8613C15.0655 22.1503 14.6481 21.9157 14.3609 21.803L11.5952 20.7184C11.2645 20.5887 11.0991 20.5239 10.9255 20.5239C10.7519 20.5239 10.5865 20.5887 10.2558 20.7184L7.49016 21.803C7.20291 21.9157 6.78553 22.1503 6.52858 21.8613C6.11239 21.3934 6.51073 20.3644 6.87572 20.0066C7.53614 19.3591 8.61751 18.63 8.936 17.7398C9.07199 17.3598 9.02496 16.9448 8.93091 16.1149L8.67153 13.8261L2.89514 15.1587C2.29655 15.2968 1.99982 15.1155 2 14.4391C2.00033 13.1971 2.39739 12.537 3.40543 11.9183L6.6995 9.89656C7.25228 9.55783 7.52868 9.38846 7.71947 9.15616C7.99925 8.81552 8 8 8 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M8.50006 4C8.97205 3.18656 9.71858 2.43508 10.4364 2.11845C10.7944 1.96052 11.2051 1.96052 11.5631 2.11845C12.7264 2.63158 13.8804 4.28671 14.0089 5.49686C14.1331 6.66595 13.3999 8.15082 14.2325 9.15616C14.4248 9.38846 14.7035 9.55783 15.2609 9.89656L18.5827 11.9182C19.5993 12.5369 19.9998 13.1973 19.9998 14.4395C19.9998 14.9429 19.5001 15.5 19.5001 15.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M2 2L22 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAirplaneModeOff' icon.
  static const List<List<dynamic>> airplaneModeOff =
      strokeRoundedAirplaneModeOff;

  /// JSON structure for the 'strokeRoundedAirplaneSeat' icon.
  static const List<List<dynamic>> strokeRoundedAirplaneSeat = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M8.48169 18H17.9722C19.0921 18 20 17.1077 20 16.0071C20 14.5 17.9722 14.0141 17.9722 14.0141C17.9722 14.0141 14.2844 12.5964 10 14C10 14 9.86099 8.87274 7.70985 3.17067C7.28543 2.04566 5.90119 1.66155 4.88539 2.3271C4.21507 2.7663 3.8807 3.55966 4.0387 4.33605L6.49327 16.3979C6.68283 17.3295 7.51507 18 8.48169 18Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M12.5 10.5H18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M16 18L13 22M13 22H8M13 22H18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAirplaneSeat' icon.
  static const List<List<dynamic>> airplaneSeat = strokeRoundedAirplaneSeat;

  /// JSON structure for the 'strokeRoundedAirplaneSeat02' icon.
  static const List<List<dynamic>> strokeRoundedAirplaneSeat02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M19.5 7H4.5C5.08771 4.64917 7.19993 3 9.62311 3H14.3769C16.8001 3 18.9123 4.64917 19.5 7Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18 16.5V7H20C20.5523 7 21 7.44772 21 8V16.5C21 17.3284 20.3284 18 19.5 18C18.6716 18 18 17.3284 18 16.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M6 19V7H18V19C18 20.1046 17.1046 21 16 21H8C6.89543 21 6 20.1046 6 19Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M3 16.5V8C3 7.44772 3.44772 7 4 7H6V16.5C6 17.3284 5.32843 18 4.5 18C3.67157 18 3 17.3284 3 16.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAirplaneSeat02' icon.
  static const List<List<dynamic>> airplaneSeat02 = strokeRoundedAirplaneSeat02;

  /// JSON structure for the 'strokeRoundedAirplaneTakeOff01' icon.
  static const List<List<dynamic>> strokeRoundedAirplaneTakeOff01 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M2.00031 20H18.0003',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M3.82527 12.1661C3.55027 11.9661 3.30027 11.7161 3.00028 10.8411C2.91891 10.6241 2.61139 9.53619 2.35028 8.54109C2.13003 7.7017 1.93377 6.93555 2.02528 6.74109C2.10029 6.54109 2.20027 6.39109 2.52527 6.19109C2.72527 6.06802 3.75027 5.81609 3.95027 5.76609C4.15027 5.71609 4.42526 5.69109 4.65027 5.76609C5.07527 5.84109 5.95027 7.11609 6.17527 7.26609C6.27526 7.36609 6.60027 7.657 6.97527 7.69109C7.25027 7.71609 7.52527 7.64109 7.82528 7.51609C8.10027 7.40151 13.5253 4.76609 14.0253 4.54109C18.1003 2.84109 21.0603 5.63609 21.5103 6.23609C21.9753 6.81609 22.0753 6.99109 21.9503 7.49109C21.7887 8.01609 21.3503 8.11609 21.1003 8.19109C20.8503 8.26609 17.4003 9.19109 16.0503 9.56609C15.7554 9.6621 15.6114 9.85492 15.5753 9.89109C15.4003 10.1411 14.6053 11.8411 14.3803 12.2161C14.2253 12.6161 13.8003 13.1161 13.2503 13.3161C12.6753 13.5161 11.6753 13.7411 11.4503 13.8161C11.2253 13.8911 10.7003 14.0411 10.5253 13.9911C10.3003 13.9411 10.0853 13.7161 10.1853 13.3661C10.2853 13.0161 10.4753 12.0411 10.5003 11.8911C10.5253 11.7411 10.7753 11.1161 10.5003 11.0911C10.4503 11.0161 9.92527 11.2411 9.15027 11.4161C8.57449 11.5782 7.9715 11.7386 7.55027 11.8411C5.92527 12.3161 5.04521 12.4411 4.85027 12.4411C4.47527 12.4411 4.20027 12.3911 3.82527 12.1661Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAirplaneTakeOff01' icon.
  static const List<List<dynamic>> airplaneTakeOff01 =
      strokeRoundedAirplaneTakeOff01;

  /// JSON structure for the 'strokeRoundedAirplaneTakeOff02' icon.
  static const List<List<dynamic>> strokeRoundedAirplaneTakeOff02 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M6.01172 20H22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M20.8094 11.3002C21.2337 10.3002 21.7329 8.10024 21.9076 7.50024C21.9575 7.20024 22.0274 6.95024 21.9525 6.75024C21.9076 6.50024 21.7079 6.28524 21.2836 6.09524C21.1339 6.05024 19.7112 5.59024 19.4865 5.71524C19.3867 5.72524 19.0872 5.85024 18.8625 6.07524C18.563 6.37524 17.964 7.22524 17.5397 7.47524C17.3649 7.57818 17.0904 7.80024 16.5163 7.62524C16.1224 7.52294 14.3698 6.64589 13.7707 6.35024C13.2965 6.11618 10.7725 4.88526 10.4511 4.75024C9.55251 4.22524 6.28278 3.00024 3.12287 5.60524C2.7884 5.95024 1.79002 6.75024 2.03961 7.42524C2.28921 8.10024 2.68855 8.0932 3.31254 8.27524C3.93654 8.45728 7.03153 9.30024 7.50579 9.42524C7.98005 9.55024 8.10485 9.57524 8.35444 9.80024C8.55412 9.98024 8.67892 10.3252 8.95348 10.9002C9.15316 11.2252 9.48596 11.9669 9.60244 12.1752C9.71891 12.3836 9.82707 12.6252 10.0517 12.8502C10.2015 13.0002 10.4511 13.1628 10.6258 13.2502C10.9253 13.4002 12.7474 13.8502 13.3214 14.0002C13.621 14.0002 13.8306 13.7752 13.8306 13.5752C13.8456 13.3752 13.579 12.3752 13.5111 11.9502C13.4712 11.7002 13.3464 11.3252 13.3714 11.1752C13.4213 10.8752 14.3448 11.2808 14.5445 11.3252C14.7691 11.3752 17.939 12.2502 18.3633 12.3252C18.7876 12.4002 19.5614 12.5502 20.1355 12.1752C20.5099 11.9002 20.6596 11.6252 20.8094 11.3002Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAirplaneTakeOff02' icon.
  static const List<List<dynamic>> airplaneTakeOff02 =
      strokeRoundedAirplaneTakeOff02;

  /// JSON structure for the 'strokeRoundedAirplayLine' icon.
  static const List<List<dynamic>> strokeRoundedAirplayLine = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4.5 18C3.96555 17.8228 3.53433 17.5662 3.17157 17.1945C2 15.994 2 14.0618 2 10.1975C2 6.33316 2 4.40099 3.17157 3.2005C4.34315 2 6.22876 2 10 2H14C17.7712 2 19.6569 2 20.8284 3.2005C22 4.40099 22 6.33316 22 10.1975C22 14.0618 22 15.994 20.8284 17.1945C20.4657 17.5662 20.0345 17.8228 19.5 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M8.91499 16.7661C10.1081 15.0762 10.7046 14.2312 11.5143 14.0528C11.8336 13.9824 12.1664 13.9824 12.4857 14.0528C13.2954 14.2312 13.8919 15.0762 15.085 16.7661C16.4811 18.7436 17.1791 19.7324 16.9605 20.5425C16.875 20.8594 16.7031 21.151 16.4611 21.3897C15.8425 22 14.5617 22 12 22C9.43831 22 8.15747 22 7.5389 21.3897C7.29691 21.151 7.12502 20.8594 7.03949 20.5425C6.82085 19.7324 7.5189 18.7436 8.91499 16.7661Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAirplayLine' icon.
  static const List<List<dynamic>> airplayLine = strokeRoundedAirplayLine;

  /// JSON structure for the 'strokeRoundedAirpod01' icon.
  static const List<List<dynamic>> strokeRoundedAirpod01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M2.5 9H7.25M21.5 9H16.75',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'rect',
      {
        'key': '2',
        'x': '7',
        'y': '7',
        'width': '10',
        'height': '4',
        'rx': '2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAirpod01' icon.
  static const List<List<dynamic>> airpod01 = strokeRoundedAirpod01;

  /// JSON structure for the 'strokeRoundedAirpod02' icon.
  static const List<List<dynamic>> strokeRoundedAirpod02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M2.5 7H7.25M21.5 7H16.75',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M7 7H17V7.5C17 8.91421 17 9.62132 16.5607 10.0607C16.1213 10.5 15.4142 10.5 14 10.5H10C8.58579 10.5 7.87868 10.5 7.43934 10.0607C7 9.62132 7 8.91421 7 7.5V7Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M12 14H12.009',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAirpod02' icon.
  static const List<List<dynamic>> airpod02 = strokeRoundedAirpod02;

  /// JSON structure for the 'strokeRoundedAirpod03' icon.
  static const List<List<dynamic>> strokeRoundedAirpod03 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M7.32988 10.8464C6.49701 11.1966 5.56172 11.2999 4.66667 11.112C3.0702 10.7768 2 9.71696 2 8.05582V6.12853C2 4.12164 3.52567 2.97998 5.55556 3.00027C7.81057 3.0228 10.5 4.76372 10.5 7.50659V19.4167C10.5 19.961 10.5 20.2332 10.3969 20.4423C10.1069 21.0304 9.48561 21 8.91667 21C8.34772 21 7.72646 21.0304 7.43646 20.4423C7.33333 20.2332 7.33333 19.961 7.33333 19.4167V11.1048C7.33333 11.0161 7.33224 10.93 7.32988 10.8464ZM7.32988 10.8464L7.33333 10.845M7.32988 10.8464C7.29694 9.68177 7 8.50004 6 8.50004',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M16.6701 10.8464C17.503 11.1965 18.4383 11.2999 19.3333 11.112C20.9298 10.7768 22 9.71694 22 8.0558V6.12851C22 4.12356 20.3874 2.98083 18.4444 3.00024C16.1894 3.02278 13.5 4.7637 13.5 7.50656V19.4167C13.5 19.961 13.5 20.2332 13.6031 20.4423C13.8931 21.0304 14.5144 21 15.0833 21C15.6523 21 16.2735 21.0304 16.5635 20.4423C16.6667 20.2332 16.6667 19.961 16.6667 19.4167V11.1048C16.6667 11.0161 16.6678 10.93 16.6701 10.8464ZM16.6701 10.8464L16.6667 10.845M16.6701 10.8464C16.7031 9.68175 17 8.50002 18 8.50002',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAirpod03' icon.
  static const List<List<dynamic>> airpod03 = strokeRoundedAirpod03;

  /// JSON structure for the 'strokeRoundedAirport' icon.
  static const List<List<dynamic>> strokeRoundedAirport = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M10.0002 12H6.00024V19C6.00024 20.4142 6.00024 21.1213 6.43958 21.5607C6.87892 22 7.58603 22 9.00024 22H10.0002V12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18.0002 15H10.0002V22H18.0002C19.4145 22 20.1216 22 20.5609 21.5607C21.0002 21.1213 21.0002 20.4142 21.0002 19V18C21.0002 16.5858 21.0002 15.8787 20.5609 15.4393C20.1216 15 19.4145 15 18.0002 15Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M21 6L20 7M16.5 7H20M20 7L17 10H16M20 7V10.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M12.2686 10.1181C11.9025 11.0296 11.7195 11.4854 11.3388 11.7427C10.9582 12 10.4671 12 9.4848 12H6.51178C5.5295 12 5.03836 12 4.65773 11.7427C4.27711 11.4854 4.09405 11.0296 3.72794 10.1181L3.57717 9.74278C3.07804 8.50009 2.82847 7.87874 3.12717 7.43937C3.42587 7 4.09785 7 5.44182 7H10.5548C11.8987 7 12.5707 7 12.8694 7.43937C13.1681 7.87874 12.9185 8.50009 12.4194 9.74278L12.2686 10.1181Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M9.99616 7H6.00407C5.18904 5.73219 4.8491 5.09829 5.06258 4.59641C5.34685 4.13381 6.15056 4 7.61989 4H8.38063C9.84995 4 10.6537 4.13381 10.9379 4.59641C11.1514 5.09829 10.8112 5.73219 9.99616 7Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M8 4V2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAirport' icon.
  static const List<List<dynamic>> airport = strokeRoundedAirport;

  /// JSON structure for the 'strokeRoundedAlAqsaMosque' icon.
  static const List<List<dynamic>> strokeRoundedAlAqsaMosque = [
    [
      'rect',
      {
        'key': '0',
        'x': '6',
        'y': '12',
        'width': '12',
        'height': '10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M14 22V18C14 16.8954 13.1046 16 12 16C10.8954 16 10 16.8954 10 18V22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M18 12L20.7022 13.0133C21.7801 13.4175 22 13.7348 22 14.886V22H18V12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M2 14.886C2 13.7348 2.21988 13.4175 3.29775 13.0133L6 12V22H2V14.886Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M16.208 9.5C17.3133 6.36054 15.1439 3 12 3C8.85611 3 6.68666 6.36054 7.79198 9.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M12 3V2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd': 'M8 12V10M16 12V10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '7',
        'd': 'M7 9.5H17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlAqsaMosque' icon.
  static const List<List<dynamic>> alAqsaMosque = strokeRoundedAlAqsaMosque;

  /// JSON structure for the 'strokeRoundedAlarmClock' icon.
  static const List<List<dynamic>> strokeRoundedAlarmClock = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M20.5 12.5C20.5 17.1944 16.6944 21 12 21C7.30558 21 3.5 17.1944 3.5 12.5C3.5 7.80558 7.30558 4 12 4C16.6944 4 20.5 7.80558 20.5 12.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M5.88 18.7031L3.5 21.0031',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M18.14 18.668L20.5 20.998',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M5 3L2 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M22 6L19 3',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M12 8V12.5L14 14.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlarmClock' icon.
  static const List<List<dynamic>> alarmClock = strokeRoundedAlarmClock;

  /// JSON structure for the 'strokeRoundedAlbum01' icon.
  static const List<List<dynamic>> strokeRoundedAlbum01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6 17.9745C6.1287 19.2829 6.41956 20.1636 7.07691 20.8209C8.25596 22 10.1536 22 13.9489 22C17.7442 22 19.6419 22 20.8209 20.8209C22 19.6419 22 17.7442 22 13.9489C22 10.1536 22 8.25596 20.8209 7.07691C20.1636 6.41956 19.2829 6.1287 17.9745 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M2 10C2 6.22876 2 4.34315 3.17157 3.17157C4.34315 2 6.22876 2 10 2C13.7712 2 15.6569 2 16.8284 3.17157C18 4.34315 18 6.22876 18 10C18 13.7712 18 15.6569 16.8284 16.8284C15.6569 18 13.7712 18 10 18C6.22876 18 4.34315 18 3.17157 16.8284C2 15.6569 2 13.7712 2 10Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M5 18C8.42061 13.2487 12.2647 6.9475 18 11.6734',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlbum01' icon.
  static const List<List<dynamic>> album01 = strokeRoundedAlbum01;

  /// JSON structure for the 'strokeRoundedAlbum02' icon.
  static const List<List<dynamic>> strokeRoundedAlbum02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6 17.9745C6.1287 19.2829 6.41956 20.1636 7.07691 20.8209C8.25596 22 10.1536 22 13.9489 22C17.7442 22 19.6419 22 20.8209 20.8209C22 19.6419 22 17.7442 22 13.9489C22 10.1536 22 8.25596 20.8209 7.07691C20.1636 6.41956 19.2829 6.1287 17.9745 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M2 10C2 6.22876 2 4.34315 3.17157 3.17157C4.34315 2 6.22876 2 10 2C13.7712 2 15.6569 2 16.8284 3.17157C18 4.34315 18 6.22876 18 10C18 13.7712 18 15.6569 16.8284 16.8284C15.6569 18 13.7712 18 10 18C6.22876 18 4.34315 18 3.17157 16.8284C2 15.6569 2 13.7712 2 10Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M2 11.1185C2.61902 11.0398 3.24484 11.001 3.87171 11.0023C6.52365 10.9533 9.11064 11.6763 11.1711 13.0424C13.082 14.3094 14.4247 16.053 15 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M12.9998 7H13.0088',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlbum02' icon.
  static const List<List<dynamic>> album02 = strokeRoundedAlbum02;

  /// JSON structure for the 'strokeRoundedAlbumNotFound01' icon.
  static const List<List<dynamic>> strokeRoundedAlbumNotFound01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M20.8209 20.8209C19.6419 22 17.7442 22 13.9489 22C10.1536 22 8.25596 22 7.07691 20.8209C6.41956 20.1636 6.1287 19.2829 6 17.9745M17.9745 6C19.2829 6.1287 20.1636 6.41956 20.8209 7.07691C22 8.25596 22 10.1536 22 13.9489C22 15.382 22 16.5446 21.9365 17.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M16.8284 16.8284C15.6569 18 13.7712 18 10 18C6.22876 18 4.34315 18 3.17157 16.8284C2 15.6569 2 13.7712 2 10C2 6.22876 2 4.34315 3.17157 3.17157M6.5 2.0612C7.44397 2 8.59023 2 10 2C13.7712 2 15.6569 2 16.8284 3.17157C18 4.34315 18 6.22876 18 10C18 11.4098 18 12.556 17.9388 13.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M5 17C6.8176 14.6361 8.72306 12.4166 11 11M18 11.5443C16.7483 10.5786 15.5868 10.1046 14.5 10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M2 2L22 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlbumNotFound01' icon.
  static const List<List<dynamic>> albumNotFound01 =
      strokeRoundedAlbumNotFound01;

  /// JSON structure for the 'strokeRoundedAlbumNotFound02' icon.
  static const List<List<dynamic>> strokeRoundedAlbumNotFound02 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M13.9998 6H14.0088',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M2 11.1057C2.68839 11.0355 3.38435 11.0009 4.08148 11.0021C7.03063 10.9583 9.90754 11.6035 12.1989 12.8224C12.8633 13.1759 13.4659 13.5709 14 14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M20.8209 20.8209C19.6419 22 17.7442 22 13.9489 22C10.1536 22 8.25596 22 7.07691 20.8209C6.41956 20.1636 6.1287 19.2829 6 17.9745M17.9745 6C19.2829 6.1287 20.1636 6.41956 20.8209 7.07691C22 8.25596 22 10.1536 22 13.9489C22 15.382 22 16.5446 21.9365 17.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M16.8284 16.8284C15.6569 18 13.7712 18 10 18C6.22876 18 4.34315 18 3.17157 16.8284C2 15.6569 2 13.7712 2 10C2 6.22876 2 4.34315 3.17157 3.17157M6.5 2.0612C7.44397 2 8.59023 2 10 2C13.7712 2 15.6569 2 16.8284 3.17157C18 4.34315 18 6.22876 18 10C18 11.4098 18 12.556 17.9388 13.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M2 2L22 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlbumNotFound02' icon.
  static const List<List<dynamic>> albumNotFound02 =
      strokeRoundedAlbumNotFound02;

  /// JSON structure for the 'strokeRoundedAlert01' icon.
  static const List<List<dynamic>> strokeRoundedAlert01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M13.9248 21H10.0752C5.44476 21 3.12955 21 2.27636 19.4939C1.42317 17.9879 2.60736 15.9914 4.97574 11.9985L6.90057 8.75333C9.17559 4.91778 10.3131 3 12 3C13.6869 3 14.8244 4.91777 17.0994 8.75332L19.0243 11.9985C21.3926 15.9914 22.5768 17.9879 21.7236 19.4939C20.8704 21 18.5552 21 13.9248 21Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M12 17V12.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 8.99828V8.98828',
        'stroke': 'currentColor',
        'strokeWidth': '1.8',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlert01' icon.
  static const List<List<dynamic>> alert01 = strokeRoundedAlert01;

  /// JSON structure for the 'strokeRoundedAlert02' icon.
  static const List<List<dynamic>> strokeRoundedAlert02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M13.9248 21H10.0752C5.44476 21 3.12955 21 2.27636 19.4939C1.42317 17.9879 2.60736 15.9914 4.97574 11.9985L6.90057 8.75333C9.17559 4.91778 10.3131 3 12 3C13.6869 3 14.8244 4.91777 17.0994 8.75332L19.0243 11.9985C21.3926 15.9914 22.5768 17.9879 21.7236 19.4939C20.8704 21 18.5552 21 13.9248 21Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M12 9V13.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 16.9922V17.0022',
        'stroke': 'currentColor',
        'strokeWidth': '1.8',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlert02' icon.
  static const List<List<dynamic>> alert02 = strokeRoundedAlert02;

  /// JSON structure for the 'strokeRoundedAlertCircle' icon.
  static const List<List<dynamic>> strokeRoundedAlertCircle = [
    [
      'circle',
      {
        'key': '0',
        'cx': '12',
        'cy': '12',
        'r': '10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M12 8V12.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 15.9883V15.9983',
        'stroke': 'currentColor',
        'strokeWidth': '1.8',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlertCircle' icon.
  static const List<List<dynamic>> alertCircle = strokeRoundedAlertCircle;

  /// JSON structure for the 'strokeRoundedAlertDiamond' icon.
  static const List<List<dynamic>> strokeRoundedAlertDiamond = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M21.5 12.6863V11.3137C21.5 9.67871 21.5 8.8612 21.1955 8.12612C20.891 7.39104 20.313 6.81297 19.1569 5.65685L18.3431 4.84315C17.187 3.68702 16.609 3.10896 15.8739 2.80448C15.1388 2.5 14.3213 2.5 12.6863 2.5H11.3137C9.67871 2.5 8.8612 2.5 8.12612 2.80448C7.39104 3.10896 6.81297 3.68702 5.65685 4.84315L4.84315 5.65685C3.68702 6.81298 3.10896 7.39104 2.80448 8.12612C2.5 8.8612 2.5 9.67871 2.5 11.3137V12.6863C2.5 14.3213 2.5 15.1388 2.80448 15.8739C3.10896 16.609 3.68702 17.187 4.84315 18.3431L5.65685 19.1569C6.81297 20.313 7.39104 20.891 8.12612 21.1955C8.8612 21.5 9.67871 21.5 11.3137 21.5H12.6863C14.3213 21.5 15.1388 21.5 15.8739 21.1955C16.609 20.891 17.187 20.313 18.3431 19.1569L19.1569 18.3431C20.313 17.187 20.891 16.609 21.1955 15.8739C21.5 15.1388 21.5 14.3213 21.5 12.6863Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M12 8L12 12.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 15.9883V15.9983',
        'stroke': 'currentColor',
        'strokeWidth': '1.8',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlertDiamond' icon.
  static const List<List<dynamic>> alertDiamond = strokeRoundedAlertDiamond;

  /// JSON structure for the 'strokeRoundedAlertSquare' icon.
  static const List<List<dynamic>> strokeRoundedAlertSquare = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M12 8V12.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 15.9883V15.9983',
        'stroke': 'currentColor',
        'strokeWidth': '1.8',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlertSquare' icon.
  static const List<List<dynamic>> alertSquare = strokeRoundedAlertSquare;

  /// JSON structure for the 'strokeRoundedAlgorithm' icon.
  static const List<List<dynamic>> strokeRoundedAlgorithm = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M10.5 2V4M13.5 2V4M8 6.5H6M8 9.5H6M18 6.5H16M18 9.5H16M13.3333 4H10.6667C9.40959 4 8.78105 4 8.39052 4.39052C8 4.78105 8 5.40959 8 6.66667V9.33333C8 10.5904 8 11.219 8.39052 11.6095C8.78105 12 9.40959 12 10.6667 12H13.3333C14.5904 12 15.219 12 15.6095 11.6095C16 11.219 16 10.5904 16 9.33333V6.66667C16 5.40959 16 4.78105 15.6095 4.39052C15.219 4 14.5904 4 13.3333 4Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M3.61732 21.9239C3.80109 22 4.03406 22 4.5 22C4.96594 22 5.19891 22 5.38268 21.9239C5.62771 21.8224 5.82239 21.6277 5.92388 21.3827C6 21.1989 6 20.9659 6 20.5C6 20.0341 6 19.8011 5.92388 19.6173C5.82239 19.3723 5.62771 19.1776 5.38268 19.0761C5.19891 19 4.96594 19 4.5 19C4.03406 19 3.80109 19 3.61732 19.0761C3.37229 19.1776 3.17761 19.3723 3.07612 19.6173C3 19.8011 3 20.0341 3 20.5C3 20.9659 3 21.1989 3.07612 21.3827C3.17761 21.6277 3.37229 21.8224 3.61732 21.9239Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M11.1173 21.9239C11.3011 22 11.5341 22 12 22C12.4659 22 12.6989 22 12.8827 21.9239C13.1277 21.8224 13.3224 21.6277 13.4239 21.3827C13.5 21.1989 13.5 20.9659 13.5 20.5C13.5 20.0341 13.5 19.8011 13.4239 19.6173C13.3224 19.3723 13.1277 19.1776 12.8827 19.0761C12.6989 19 12.4659 19 12 19C11.5341 19 11.3011 19 11.1173 19.0761C10.8723 19.1776 10.6776 19.3723 10.5761 19.6173C10.5 19.8011 10.5 20.0341 10.5 20.5C10.5 20.9659 10.5 21.1989 10.5761 21.3827C10.6776 21.6277 10.8723 21.8224 11.1173 21.9239Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M12 19V12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M4.5 19C4.5 17.5955 4.5 16.8933 4.83706 16.3889C4.98298 16.1705 5.17048 15.983 5.38886 15.8371C5.89331 15.5 6.59554 15.5 8 15.5H16C17.4045 15.5 18.1067 15.5 18.6111 15.8371C18.8295 15.983 19.017 16.1705 19.1629 16.3889C19.5 16.8933 19.5 17.5955 19.5 19',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd':
            'M18.6173 21.9239C18.8011 22 19.0341 22 19.5 22C19.9659 22 20.1989 22 20.3827 21.9239C20.6277 21.8224 20.8224 21.6277 20.9239 21.3827C21 21.1989 21 20.9659 21 20.5C21 20.0341 21 19.8011 20.9239 19.6173C20.8224 19.3723 20.6277 19.1776 20.3827 19.0761C20.1989 19 19.9659 19 19.5 19C19.0341 19 18.8011 19 18.6173 19.0761C18.3723 19.1776 18.1776 19.3723 18.0761 19.6173C18 19.8011 18 20.0341 18 20.5C18 20.9659 18 21.1989 18.0761 21.3827C18.1776 21.6277 18.3723 21.8224 18.6173 21.9239Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlgorithm' icon.
  static const List<List<dynamic>> algorithm = strokeRoundedAlgorithm;

  /// JSON structure for the 'strokeRoundedAlien01' icon.
  static const List<List<dynamic>> strokeRoundedAlien01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M7.33333 10H6.5C6.22386 10 6 10.2239 6 10.5V11.3333C6 12.8061 7.19391 14 8.66667 14H9.5C9.77614 14 10 13.7761 10 13.5V12.6667C10 11.1939 8.80609 10 7.33333 10Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M16.6667 10H17C17.4714 10 17.7071 10 17.8536 10.1464C18 10.2929 18 10.5286 18 11V11.3333C18 12.8061 16.8061 14 15.3333 14H15C14.5286 14 14.2929 14 14.1464 13.8536C14 13.7071 14 13.4714 14 13V12.6667C14 11.1939 15.1939 10 16.6667 10Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M11 18H13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M21 11C21 16.5228 15 22 12 22C9 22 3 16.5228 3 11C3 5.47715 7.02944 2 12 2C16.9706 2 21 5.47715 21 11Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlien01' icon.
  static const List<List<dynamic>> alien01 = strokeRoundedAlien01;

  /// JSON structure for the 'strokeRoundedAlien02' icon.
  static const List<List<dynamic>> strokeRoundedAlien02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M15.0014 9.98894C15.0014 11.6432 13.6596 12.9841 12.0043 12.9841C10.349 12.9841 9.0072 11.6432 9.0072 9.98894C9.0072 8.33474 10.349 6.99374 12.0043 6.99374C13.6596 6.99374 15.0014 8.33474 15.0014 9.98894Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M11.9945 16.9777H12.0035',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M20.496 2.00174C20.3294 2.9003 19.497 4.75732 17.4989 4.99693',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M3.51257 2.00174C3.67908 2.9003 4.5116 4.75732 6.50965 4.99693',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M8.84021 3.69349C5.58633 5.14195 4.44413 8.62401 4.52092 10.4658C3.3979 10.389 2.0227 10.5148 2.00157 11.9509C1.98043 13.387 3.46509 13.6409 4.52092 13.4682V19.8759C4.53861 20.4063 4.58624 21.1002 5.13522 21.3436C6.41182 21.9095 7.48685 20.1925 8.6549 20.2712C9.56297 20.3324 10.8774 22.0907 12.0332 21.9945C13.3719 21.883 14.4022 20.2767 15.4258 20.2767C16.6397 20.2767 16.8523 21.2774 18.314 21.4367C19.4042 21.5556 19.515 20.516 19.515 19.9564V13.4802C21.4043 13.7145 22.1531 12.8775 21.9725 11.6986C21.7595 10.3074 20.1259 10.4067 19.4757 10.4956C19.5768 9.46112 19.1104 8.15549 18.909 7.64373C18.6122 6.73267 17.3925 4.57907 14.7721 3.51122C12.1516 2.44338 9.71367 3.23306 8.84021 3.69349Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlien02' icon.
  static const List<List<dynamic>> alien02 = strokeRoundedAlien02;

  /// JSON structure for the 'strokeRoundedAlignBottom' icon.
  static const List<List<dynamic>> strokeRoundedAlignBottom = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M16.502 10.0023C17.3458 10.0023 18.3198 9.91895 18.801 10.7523C19.002 11.1004 19.002 11.5677 19.002 12.5023V13.5023C19.002 14.4369 19.002 14.9042 18.801 15.2523C18.3198 16.0857 17.3458 16.0023 16.502 16.0023C15.6581 16.0023 14.6841 16.0857 14.2029 15.2523C14.002 14.9042 14.002 14.4369 14.002 13.5023L14.002 12.5023C14.002 11.5677 14.002 11.1004 14.2029 10.7523C14.6841 9.91895 15.6581 10.0023 16.502 10.0023Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M7.50195 4.00232C8.34585 4.00232 9.31984 3.91895 9.80099 4.75232C10.002 5.10039 10.002 5.5677 10.002 6.50232L10.002 13.5023C10.002 14.4369 10.002 14.9042 9.80099 15.2523C9.31984 16.0857 8.34585 16.0023 7.50195 16.0023C6.65806 16.0023 5.68406 16.0857 5.20292 15.2523C5.00195 14.9042 5.00195 14.4369 5.00195 13.5023L5.00195 6.50232C5.00195 5.5677 5.00195 5.10039 5.20292 4.75232C5.68406 3.91895 6.65806 4.00232 7.50195 4.00232Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M22 20L2 20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlignBottom' icon.
  static const List<List<dynamic>> alignBottom = strokeRoundedAlignBottom;

  /// JSON structure for the 'strokeRoundedAlignBoxBottomCenter' icon.
  static const List<List<dynamic>> strokeRoundedAlignBoxBottomCenter = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3 11C3 7.25027 3 5.3754 3.95491 4.06107C4.26331 3.6366 4.6366 3.26331 5.06107 2.95491C6.3754 2 8.25027 2 12 2C15.7497 2 17.6246 2 18.9389 2.95491C19.3634 3.26331 19.7367 3.6366 20.0451 4.06107C21 5.3754 21 7.25027 21 11V13C21 16.7497 21 18.6246 20.0451 19.9389C19.7367 20.3634 19.3634 20.7367 18.9389 21.0451C17.6246 22 15.7497 22 12 22C8.25027 22 6.3754 22 5.06107 21.0451C4.6366 20.7367 4.26331 20.3634 3.95491 19.9389C3 18.6246 3 16.7497 3 13V11Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M16 12H8M13.5 17H10.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlignBoxBottomCenter' icon.
  static const List<List<dynamic>> alignBoxBottomCenter =
      strokeRoundedAlignBoxBottomCenter;

  /// JSON structure for the 'strokeRoundedAlignBoxBottomLeft' icon.
  static const List<List<dynamic>> strokeRoundedAlignBoxBottomLeft = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3 11C3 7.25027 3 5.3754 3.95491 4.06107C4.26331 3.6366 4.6366 3.26331 5.06107 2.95491C6.3754 2 8.25027 2 12 2C15.7497 2 17.6246 2 18.9389 2.95491C19.3634 3.26331 19.7367 3.6366 20.0451 4.06107C21 5.3754 21 7.25027 21 11V13C21 16.7497 21 18.6246 20.0451 19.9389C19.7367 20.3634 19.3634 20.7367 18.9389 21.0451C17.6246 22 15.7497 22 12 22C8.25027 22 6.3754 22 5.06107 21.0451C4.6366 20.7367 4.26331 20.3634 3.95491 19.9389C3 18.6246 3 16.7497 3 13V11Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M15 12L7 12M10 17H7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlignBoxBottomLeft' icon.
  static const List<List<dynamic>> alignBoxBottomLeft =
      strokeRoundedAlignBoxBottomLeft;

  /// JSON structure for the 'strokeRoundedAlignBoxBottomRight' icon.
  static const List<List<dynamic>> strokeRoundedAlignBoxBottomRight = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3 11C3 7.25027 3 5.3754 3.95491 4.06107C4.26331 3.6366 4.6366 3.26331 5.06107 2.95491C6.3754 2 8.25027 2 12 2C15.7497 2 17.6246 2 18.9389 2.95491C19.3634 3.26331 19.7367 3.6366 20.0451 4.06107C21 5.3754 21 7.25027 21 11V13C21 16.7497 21 18.6246 20.0451 19.9389C19.7367 20.3634 19.3634 20.7367 18.9389 21.0451C17.6246 22 15.7497 22 12 22C8.25027 22 6.3754 22 5.06107 21.0451C4.6366 20.7367 4.26331 20.3634 3.95491 19.9389C3 18.6246 3 16.7497 3 13V11Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M17 12L9 12M17 17H14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlignBoxBottomRight' icon.
  static const List<List<dynamic>> alignBoxBottomRight =
      strokeRoundedAlignBoxBottomRight;

  /// JSON structure for the 'strokeRoundedAlignBoxMiddleCenter' icon.
  static const List<List<dynamic>> strokeRoundedAlignBoxMiddleCenter = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3 11C3 7.25027 3 5.3754 3.95491 4.06107C4.26331 3.6366 4.6366 3.26331 5.06107 2.95491C6.3754 2 8.25027 2 12 2C15.7497 2 17.6246 2 18.9389 2.95491C19.3634 3.26331 19.7367 3.6366 20.0451 4.06107C21 5.3754 21 7.25027 21 11V13C21 16.7497 21 18.6246 20.0451 19.9389C19.7367 20.3634 19.3634 20.7367 18.9389 21.0451C17.6246 22 15.7497 22 12 22C8.25027 22 6.3754 22 5.06107 21.0451C4.6366 20.7367 4.26331 20.3634 3.95491 19.9389C3 18.6246 3 16.7497 3 13V11Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M16 9.5L8 9.5M13.5 14.5H10.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlignBoxMiddleCenter' icon.
  static const List<List<dynamic>> alignBoxMiddleCenter =
      strokeRoundedAlignBoxMiddleCenter;

  /// JSON structure for the 'strokeRoundedAlignBoxMiddleLeft' icon.
  static const List<List<dynamic>> strokeRoundedAlignBoxMiddleLeft = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3 11C3 7.25027 3 5.3754 3.95491 4.06107C4.26331 3.6366 4.6366 3.26331 5.06107 2.95491C6.3754 2 8.25027 2 12 2C15.7497 2 17.6246 2 18.9389 2.95491C19.3634 3.26331 19.7367 3.6366 20.0451 4.06107C21 5.3754 21 7.25027 21 11V13C21 16.7497 21 18.6246 20.0451 19.9389C19.7367 20.3634 19.3634 20.7367 18.9389 21.0451C17.6246 22 15.7497 22 12 22C8.25027 22 6.3754 22 5.06107 21.0451C4.6366 20.7367 4.26331 20.3634 3.95491 19.9389C3 18.6246 3 16.7497 3 13V11Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M15 9.5L7 9.5M10 14.5H7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlignBoxMiddleLeft' icon.
  static const List<List<dynamic>> alignBoxMiddleLeft =
      strokeRoundedAlignBoxMiddleLeft;

  /// JSON structure for the 'strokeRoundedAlignBoxMiddleRight' icon.
  static const List<List<dynamic>> strokeRoundedAlignBoxMiddleRight = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3 11C3 7.25027 3 5.3754 3.95491 4.06107C4.26331 3.6366 4.6366 3.26331 5.06107 2.95491C6.3754 2 8.25027 2 12 2C15.7497 2 17.6246 2 18.9389 2.95491C19.3634 3.26331 19.7367 3.6366 20.0451 4.06107C21 5.3754 21 7.25027 21 11V13C21 16.7497 21 18.6246 20.0451 19.9389C19.7367 20.3634 19.3634 20.7367 18.9389 21.0451C17.6246 22 15.7497 22 12 22C8.25027 22 6.3754 22 5.06107 21.0451C4.6366 20.7367 4.26331 20.3634 3.95491 19.9389C3 18.6246 3 16.7497 3 13V11Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M17 9.5L9 9.5M17 14.5H14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlignBoxMiddleRight' icon.
  static const List<List<dynamic>> alignBoxMiddleRight =
      strokeRoundedAlignBoxMiddleRight;

  /// JSON structure for the 'strokeRoundedAlignBoxTopCenter' icon.
  static const List<List<dynamic>> strokeRoundedAlignBoxTopCenter = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3 11C3 7.25027 3 5.3754 3.95491 4.06107C4.26331 3.6366 4.6366 3.26331 5.06107 2.95491C6.3754 2 8.25027 2 12 2C15.7497 2 17.6246 2 18.9389 2.95491C19.3634 3.26331 19.7367 3.6366 20.0451 4.06107C21 5.3754 21 7.25027 21 11V13C21 16.7497 21 18.6246 20.0451 19.9389C19.7367 20.3634 19.3634 20.7367 18.9389 21.0451C17.6246 22 15.7497 22 12 22C8.25027 22 6.3754 22 5.06107 21.0451C4.6366 20.7367 4.26331 20.3634 3.95491 19.9389C3 18.6246 3 16.7497 3 13V11Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M16 7H8M13.5 12H10.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlignBoxTopCenter' icon.
  static const List<List<dynamic>> alignBoxTopCenter =
      strokeRoundedAlignBoxTopCenter;

  /// JSON structure for the 'strokeRoundedAlignBoxTopLeft' icon.
  static const List<List<dynamic>> strokeRoundedAlignBoxTopLeft = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3 11C3 7.25027 3 5.3754 3.95491 4.06107C4.26331 3.6366 4.6366 3.26331 5.06107 2.95491C6.3754 2 8.25027 2 12 2C15.7497 2 17.6246 2 18.9389 2.95491C19.3634 3.26331 19.7367 3.6366 20.0451 4.06107C21 5.3754 21 7.25027 21 11V13C21 16.7497 21 18.6246 20.0451 19.9389C19.7367 20.3634 19.3634 20.7367 18.9389 21.0451C17.6246 22 15.7497 22 12 22C8.25027 22 6.3754 22 5.06107 21.0451C4.6366 20.7367 4.26331 20.3634 3.95491 19.9389C3 18.6246 3 16.7497 3 13V11Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M15 7L7 7M10 12H7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlignBoxTopLeft' icon.
  static const List<List<dynamic>> alignBoxTopLeft =
      strokeRoundedAlignBoxTopLeft;

  /// JSON structure for the 'strokeRoundedAlignBoxTopRight' icon.
  static const List<List<dynamic>> strokeRoundedAlignBoxTopRight = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3 11C3 7.25027 3 5.3754 3.95491 4.06107C4.26331 3.6366 4.6366 3.26331 5.06107 2.95491C6.3754 2 8.25027 2 12 2C15.7497 2 17.6246 2 18.9389 2.95491C19.3634 3.26331 19.7367 3.6366 20.0451 4.06107C21 5.3754 21 7.25027 21 11V13C21 16.7497 21 18.6246 20.0451 19.9389C19.7367 20.3634 19.3634 20.7367 18.9389 21.0451C17.6246 22 15.7497 22 12 22C8.25027 22 6.3754 22 5.06107 21.0451C4.6366 20.7367 4.26331 20.3634 3.95491 19.9389C3 18.6246 3 16.7497 3 13V11Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M17 7L9 7M17 12H14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlignBoxTopRight' icon.
  static const List<List<dynamic>> alignBoxTopRight =
      strokeRoundedAlignBoxTopRight;

  /// JSON structure for the 'strokeRoundedAlignHorizontalCenter' icon.
  static const List<List<dynamic>> strokeRoundedAlignHorizontalCenter = [
    [
      'path',
      {
        'key': '0',
        'd': 'M12 19L12 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M12 10L12 14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 2L12 5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M8.00036 7.5C8.00036 6.65611 7.91699 5.68211 8.75036 5.20096C9.09844 5 9.56575 5 10.5004 5H13.5004C14.435 5 14.9023 5 15.2504 5.20096C16.0837 5.68211 16.0004 6.65611 16.0004 7.5C16.0004 8.34389 16.0837 9.31789 15.2504 9.79904C14.9023 10 14.435 10 13.5004 10H10.5004C9.56575 10 9.09844 10 8.75036 9.79904C7.91699 9.31789 8.00036 8.34389 8.00036 7.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M4.00036 16.5C4.00036 15.6561 3.91699 14.6821 4.75036 14.201C5.09844 14 5.56575 14 6.50036 14H17.5004C18.435 14 18.9023 14 19.2504 14.201C20.0837 14.6821 20.0004 15.6561 20.0004 16.5C20.0004 17.3439 20.0837 18.3179 19.2504 18.799C18.9023 19 18.435 19 17.5004 19H6.50036C5.56575 19 5.09844 19 4.75036 18.799C3.91699 18.3179 4.00036 17.3439 4.00036 16.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlignHorizontalCenter' icon.
  static const List<List<dynamic>> alignHorizontalCenter =
      strokeRoundedAlignHorizontalCenter;

  /// JSON structure for the 'strokeRoundedAlignKeyObject' icon.
  static const List<List<dynamic>> strokeRoundedAlignKeyObject = [
    [
      'path',
      {
        'key': '0',
        'd': 'M20 5.98971V11.9771M18 3.9939H6M10 19.9604H6M4 17.9646V5.98971',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M22 3.99386C22 5.09611 21.1046 5.98967 20 5.98967C18.8954 5.98967 18 5.09611 18 3.99386C18 2.8916 18.8954 1.99805 20 1.99805C21.1046 1.99805 22 2.8916 22 3.99386Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M6 3.99386C6 5.09611 5.10457 5.98967 4 5.98967C2.89543 5.98967 2 5.09611 2 3.99386C2 2.8916 2.89543 1.99805 4 1.99805C5.10457 1.99805 6 2.8916 6 3.99386Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M6 19.9604C6 21.0627 5.10457 21.9562 4 21.9562C2.89543 21.9562 2 21.0627 2 19.9604C2 18.8581 2.89543 17.9646 4 17.9646C5.10457 17.9646 6 18.8581 6 19.9604Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M15.5378 19.4119L17.9999 16.7963M17.9999 16.7963L19.4857 15.2075C19.668 15.0626 20.0617 14.8178 20.5935 15.3049C21.0741 15.7452 21.7048 16.4303 21.9883 16.7504M17.9999 16.7963L19.504 18.4327M15.9981 20.4863C15.9981 21.3231 15.3243 22.0014 14.4932 22.0014C13.6621 22.0014 12.9883 21.3231 12.9883 20.4863C12.9883 19.6495 13.6621 18.9712 14.4932 18.9712C15.3243 18.9712 15.9981 19.6495 15.9981 20.4863Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlignKeyObject' icon.
  static const List<List<dynamic>> alignKeyObject = strokeRoundedAlignKeyObject;

  /// JSON structure for the 'strokeRoundedAlignLeft' icon.
  static const List<List<dynamic>> strokeRoundedAlignLeft = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M8.00232 7.5C8.00232 6.65611 7.91895 5.68211 8.75232 5.20096C9.10039 5 9.5677 5 10.5023 5H11.5023C12.4369 5 12.9042 5 13.2523 5.20096C14.0857 5.68211 14.0023 6.65611 14.0023 7.5C14.0023 8.34389 14.0857 9.31789 13.2523 9.79904C12.9042 10 12.4369 10 11.5023 10H10.5023C9.5677 10 9.10039 10 8.75232 9.79904C7.91895 9.31789 8.00232 8.34389 8.00232 7.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M8.00232 16.5C8.00232 15.6561 7.91895 14.6821 8.75232 14.201C9.10039 14 9.5677 14 10.5023 14H17.5023C18.4369 14 18.9042 14 19.2523 14.201C20.0857 14.6821 20.0023 15.6561 20.0023 16.5C20.0023 17.3439 20.0857 18.3179 19.2523 18.799C18.9042 19 18.4369 19 17.5023 19H10.5023C9.5677 19 9.10039 19 8.75232 18.799C7.91895 18.3179 8.00232 17.3439 8.00232 16.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M4 2V22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlignLeft' icon.
  static const List<List<dynamic>> alignLeft = strokeRoundedAlignLeft;

  /// JSON structure for the 'strokeRoundedAlignRight' icon.
  static const List<List<dynamic>> strokeRoundedAlignRight = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M10.0004 7.5C10.0004 6.65611 9.91699 5.68211 10.7504 5.20096C11.0984 5 11.5657 5 12.5004 5H13.5004C14.435 5 14.9023 5 15.2504 5.20096C16.0837 5.68211 16.0004 6.65611 16.0004 7.5C16.0004 8.34389 16.0837 9.31789 15.2504 9.79904C14.9023 10 14.435 10 13.5004 10H12.5004C11.5657 10 11.0984 10 10.7504 9.79904C9.91699 9.31789 10.0004 8.34389 10.0004 7.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M4.00036 16.5C4.00036 15.6561 3.91699 14.6821 4.75036 14.201C5.09844 14 5.56575 14 6.50036 14H13.5004C14.435 14 14.9023 14 15.2504 14.201C16.0837 14.6821 16.0004 15.6561 16.0004 16.5C16.0004 17.3439 16.0837 18.3179 15.2504 18.799C14.9023 19 14.435 19 13.5004 19H6.50036C5.56575 19 5.09844 19 4.75036 18.799C3.91699 18.3179 4.00036 17.3439 4.00036 16.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M20 2V22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlignRight' icon.
  static const List<List<dynamic>> alignRight = strokeRoundedAlignRight;

  /// JSON structure for the 'strokeRoundedAlignSelection' icon.
  static const List<List<dynamic>> strokeRoundedAlignSelection = [
    [
      'path',
      {
        'key': '0',
        'd': 'M20 6V18M18 4H6M18 20H6M4 18V6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M22 4C22 5.10457 21.1046 6 20 6C18.8954 6 18 5.10457 18 4C18 2.89543 18.8954 2 20 2C21.1046 2 22 2.89543 22 4Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M6 4C6 5.10457 5.10457 6 4 6C2.89543 6 2 5.10457 2 4C2 2.89543 2.89543 2 4 2C5.10457 2 6 2.89543 6 4Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M22 20C22 21.1046 21.1046 22 20 22C18.8954 22 18 21.1046 18 20C18 18.8954 18.8954 18 20 18C21.1046 18 22 18.8954 22 20Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M6 20C6 21.1046 5.10457 22 4 22C2.89543 22 2 21.1046 2 20C2 18.8954 2.89543 18 4 18C5.10457 18 6 18.8954 6 20Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlignSelection' icon.
  static const List<List<dynamic>> alignSelection = strokeRoundedAlignSelection;

  /// JSON structure for the 'strokeRoundedAlignTop' icon.
  static const List<List<dynamic>> strokeRoundedAlignTop = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M16.502 7.99988C17.3458 7.99988 18.3198 7.9165 18.801 8.74988C19.002 9.09795 19.002 9.56526 19.002 10.4999V11.4999C19.002 12.4345 19.002 12.9018 18.801 13.2499C18.3198 14.0832 17.3458 13.9999 16.502 13.9999C15.6581 13.9999 14.6841 14.0832 14.2029 13.2499C14.002 12.9018 14.002 12.4345 14.002 11.4999L14.002 10.4999C14.002 9.56526 14.002 9.09795 14.2029 8.74988C14.6841 7.9165 15.6581 7.99988 16.502 7.99988Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M7.50195 7.99988C8.34585 7.99988 9.31984 7.9165 9.80099 8.74988C10.002 9.09795 10.002 9.56526 10.002 10.4999L10.002 17.4999C10.002 18.4345 10.002 18.9018 9.80099 19.2499C9.31984 20.0832 8.34585 19.9999 7.50195 19.9999C6.65806 19.9999 5.68406 20.0832 5.20292 19.2499C5.00195 18.9018 5.00195 18.4345 5.00195 17.4999L5.00195 10.4999C5.00195 9.56526 5.00195 9.09795 5.20292 8.74988C5.68406 7.9165 6.65806 7.99988 7.50195 7.99988Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M22 4L2 4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlignTop' icon.
  static const List<List<dynamic>> alignTop = strokeRoundedAlignTop;

  /// JSON structure for the 'strokeRoundedAlignVerticalCenter' icon.
  static const List<List<dynamic>> strokeRoundedAlignVerticalCenter = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M16.5 8.00232C17.3439 8.00232 18.3179 7.91895 18.799 8.75232C19 9.10039 19 9.5677 19 10.5023V13.5023C19 14.4369 19 14.9042 18.799 15.2523C18.3179 16.0857 17.3439 16.0023 16.5 16.0023C15.6561 16.0023 14.6821 16.0857 14.201 15.2523C14 14.9042 14 14.4369 14 13.5023L14 10.5023C14 9.5677 14 9.10039 14.201 8.75232C14.6821 7.91895 15.6561 8.00232 16.5 8.00232Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M7.5 4.00232C8.34389 4.00232 9.31789 3.91895 9.79904 4.75232C10 5.10039 10 5.5677 10 6.50232L10 17.5023C10 18.4369 10 18.9042 9.79904 19.2523C9.31789 20.0857 8.34389 20.0023 7.5 20.0023C6.65611 20.0023 5.68211 20.0857 5.20096 19.2523C5 18.9042 5 18.4369 5 17.5023L5 6.50232C5 5.5677 5 5.10039 5.20096 4.75232C5.68211 3.91895 6.65611 4.00232 7.5 4.00232Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M5 12H2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M14 12L10 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M22 12L19 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlignVerticalCenter' icon.
  static const List<List<dynamic>> alignVerticalCenter =
      strokeRoundedAlignVerticalCenter;

  /// JSON structure for the 'strokeRoundedAllBookmark' icon.
  static const List<List<dynamic>> strokeRoundedAllBookmark = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3 17.9808V12.7075C3 9.07416 3 7.25748 4.09835 6.12874C5.1967 5 6.96447 5 10.5 5C14.0355 5 15.8033 5 16.9017 6.12874C18 7.25748 18 9.07416 18 12.7075V17.9808C18 20.2867 18 21.4396 17.2755 21.8523C15.8724 22.6514 13.2405 19.9852 11.9906 19.1824C11.2657 18.7168 10.9033 18.484 10.5 18.484C10.0967 18.484 9.73425 18.7168 9.00938 19.1824C7.7595 19.9852 5.12763 22.6514 3.72454 21.8523C3 21.4396 3 20.2867 3 17.9808Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M9 2H11C15.714 2 18.0711 2 19.5355 3.46447C21 4.92893 21 7.28595 21 12V18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAllBookmark' icon.
  static const List<List<dynamic>> allBookmark = strokeRoundedAllBookmark;

  /// JSON structure for the 'strokeRoundedAllah' icon.
  static const List<List<dynamic>> strokeRoundedAllah = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M9.77907 3.35212C10.3428 2.74898 10.6246 2.44741 10.9257 2.27941C11.5935 1.90686 12.4065 1.90686 13.0743 2.27941C13.3754 2.44741 13.6572 2.74898 14.2209 3.35212C14.4749 3.62385 14.6019 3.75972 14.7431 3.8688C15.0532 4.10826 15.4214 4.26079 15.8099 4.31069C15.987 4.33343 16.1728 4.32715 16.5445 4.31459C17.3696 4.2867 17.7822 4.27276 18.1139 4.36689C18.8495 4.57561 19.4244 5.15054 19.6331 5.88612C19.7272 6.21784 19.7133 6.63038 19.6854 7.45546C19.6728 7.82718 19.6666 8.01305 19.6893 8.19006C19.7392 8.57861 19.8917 8.94684 20.1312 9.25688C20.2403 9.39812 20.3761 9.5251 20.6479 9.77907C21.251 10.3428 21.5526 10.6246 21.7206 10.9257C22.0931 11.5935 22.0931 12.4065 21.7206 13.0743C21.5526 13.3754 21.251 13.6572 20.6479 14.2209C20.3761 14.4749 20.2403 14.6019 20.1312 14.7431C19.8917 15.0532 19.7392 15.4214 19.6893 15.8099C19.6666 15.987 19.6728 16.1728 19.6854 16.5445C19.7133 17.3696 19.7272 17.7822 19.6331 18.1139C19.4244 18.8495 18.8495 19.4244 18.1139 19.6331C17.7822 19.7272 17.3696 19.7133 16.5445 19.6854C16.1728 19.6728 15.987 19.6666 15.8099 19.6893C15.4214 19.7392 15.0532 19.8917 14.7431 20.1312C14.6019 20.2403 14.4749 20.3761 14.2209 20.6479C13.6572 21.251 13.3754 21.5526 13.0743 21.7206C12.4065 22.0931 11.5935 22.0931 10.9257 21.7206C10.6246 21.5526 10.3428 21.251 9.77907 20.6479C9.5251 20.3761 9.39812 20.2403 9.25688 20.1312C8.94684 19.8917 8.57861 19.7392 8.19006 19.6893C8.01305 19.6666 7.82718 19.6728 7.45546 19.6854C6.63038 19.7133 6.21784 19.7272 5.88612 19.6331C5.15054 19.4244 4.57561 18.8495 4.36689 18.1139C4.27276 17.7822 4.2867 17.3696 4.31459 16.5445C4.32715 16.1728 4.33343 15.987 4.31069 15.8099C4.26079 15.4214 4.10826 15.0532 3.8688 14.7431C3.75972 14.6019 3.62385 14.4749 3.35212 14.2209C2.74898 13.6572 2.44741 13.3754 2.27941 13.0743C1.90686 12.4065 1.90686 11.5935 2.27941 10.9257C2.44741 10.6246 2.74898 10.3428 3.35212 9.77907C3.62385 9.5251 3.75972 9.39812 3.8688 9.25688C4.10826 8.94684 4.26079 8.5786 4.31069 8.19006C4.33343 8.01305 4.32715 7.82718 4.31459 7.45546C4.2867 6.63038 4.27276 6.21784 4.36689 5.88612C4.57561 5.15054 5.15054 4.57561 5.88612 4.36689C6.21784 4.27276 6.63038 4.2867 7.45546 4.31459C7.82718 4.32715 8.01305 4.33343 8.19006 4.31069C8.5786 4.26079 8.94684 4.10826 9.25688 3.8688C9.39812 3.75972 9.5251 3.62385 9.77907 3.35212Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M17 10V16M14.5 10V14.5C14.5 15.3284 13.8284 16 13 16C12.1716 16 11.5 15.3284 11.5 14.5M11.5 8V14.5M11.5 14.5V10M11.5 14.5C11.5 15.3284 10.8284 16 10 16C9.17157 16 8.5 15.3284 8.5 14.5V10C8.5 10 6 10.5 6 13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAllah' icon.
  static const List<List<dynamic>> allah = strokeRoundedAllah;

  /// JSON structure for the 'strokeRoundedAlms' icon.
  static const List<List<dynamic>> strokeRoundedAlms = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M13.4659 4.02249C15.9701 4.02249 18 6.03466 18 8.51679C18 10.9989 15.9701 13.0111 13.4659 13.0111C11.2439 13.0111 9.39528 11.4269 9.00684 9.33584',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M21.9977 14.0098H19.6047C19.3107 14.0098 19.0208 14.076 18.7579 14.2031L16.7176 15.1899C16.4547 15.317 16.1648 15.3831 15.8708 15.3831H14.829C13.8214 15.3831 13.0045 16.1732 13.0045 17.1478C13.0045 17.1871 13.0315 17.2218 13.0706 17.2326L15.6096 17.9343C16.0651 18.0601 16.5528 18.0163 16.9765 17.8113L19.1577 16.7566M13.0045 16.5066L8.41518 15.0973C7.6016 14.8439 6.72215 15.1443 6.21251 15.8497C5.84403 16.3597 5.99406 17.0901 6.53091 17.3997L14.0408 21.7305C14.5184 22.0059 15.082 22.0731 15.6073 21.9173L21.9977 20.022',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M2.00195 4.51949C3.52934 3.92195 5.70251 2.46384 6.89042 2.16491C9.52307 1.6363 10.9042 2.41478 14.0218 4.02331C12.7097 4.05111 10.9458 4.80193 10.0777 6.51752M10.0777 6.51752H8.29356M10.0777 6.51752H11.3866C11.7803 6.54612 12.6286 6.78321 12.9555 7.54417C13.0867 7.84956 13.1241 8.21249 12.8665 8.39585C12.5192 8.75413 12.0207 8.7401 11.5785 8.81847M11.5785 8.81847C11.071 8.90841 10.5821 9.00831 10.071 9.10773M11.5785 8.81847L10.071 9.10773M10.071 9.10773C9.95817 9.12968 9.84428 9.15159 9.72886 9.17338M10.071 9.10773L9.72886 9.17338M9.72886 9.17338C8.93219 9.26234 6.99002 10.1915 6.04417 10.4516C5.72222 10.6054 3.14121 11.1057 2.01609 11.0179',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlms' icon.
  static const List<List<dynamic>> alms = strokeRoundedAlms;

  /// JSON structure for the 'strokeRoundedAlpha' icon.
  static const List<List<dynamic>> strokeRoundedAlpha = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M17.3943 4C17.5941 5.85 17.3444 10 16.1706 13.275C14.7721 17.5 12.6743 19.35 11.0011 19.8C7.75452 20.6731 5.03241 18.45 3.88362 15.975C2.40994 12.8 2.80975 9.125 4.8576 6.475C6.90545 3.825 10.7763 2.675 13.6483 6.25C14.7471 7.925 15.2216 9.725 15.4464 11.175C15.8959 12.775 16.1206 16.775 17.2944 18.725C18.2184 20.175 19.6419 20.1 20.1664 19.875C20.516 19.7 21 19.32 21 18.22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlpha' icon.
  static const List<List<dynamic>> alpha = strokeRoundedAlpha;

  /// JSON structure for the 'strokeRoundedAlphaCircle' icon.
  static const List<List<dynamic>> strokeRoundedAlphaCircle = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M15.0011 8C15.1077 8.8641 15.0011 10.2323 14.6013 11.8284C14.2548 12.9686 13.1621 16.2569 10.3236 15.9809C7.87156 15.6569 6.84544 13.2566 7.01868 11.6844C7.08531 10.3643 8.07145 8.036 10.6967 8C13.0554 8.20402 13.6551 10.2082 13.9883 11.9004C14.3481 13.4606 14.3081 14.2287 14.9078 15.2968C15.2676 15.8849 15.9472 16.1009 16.4936 15.9569C16.9334 15.7769 17 15.3928 17 15.1048',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlphaCircle' icon.
  static const List<List<dynamic>> alphaCircle = strokeRoundedAlphaCircle;

  /// JSON structure for the 'strokeRoundedAlphaSquare' icon.
  static const List<List<dynamic>> strokeRoundedAlphaSquare = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M15.0011 8C15.1077 8.8641 15.0011 10.2323 14.6013 11.8284C14.2548 12.9686 13.1621 16.2569 10.3236 15.9809C7.87156 15.6569 6.84544 13.2566 7.01868 11.6844C7.08531 10.3643 8.07145 8.036 10.6967 8C13.0554 8.20402 13.6551 10.2082 13.9883 11.9004C14.3481 13.4606 14.3081 14.2287 14.9078 15.2968C15.2676 15.8849 15.9472 16.1009 16.4936 15.9569C16.9334 15.7769 17 15.3928 17 15.1048',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlphaSquare' icon.
  static const List<List<dynamic>> alphaSquare = strokeRoundedAlphaSquare;

  /// JSON structure for the 'strokeRoundedAlphabetArabic' icon.
  static const List<List<dynamic>> strokeRoundedAlphabetArabic = [
    [
      'path',
      {
        'key': '0',
        'd': 'M9 4L9 11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M13 14H20.743C21.4486 14 21.8015 14 21.9479 13.7401C22.0944 13.4803 21.9203 13.2157 21.5721 12.6867C20.4517 10.9841 18.7844 10 17.117 10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M13 4V17.6667C13 18.7666 13 19.3166 12.7071 19.6583C12.4142 20 11.9428 20 11 20H10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M5 4V17.6667C5 18.7666 5 19.3166 4.70711 19.6583C4.41421 20 3.94281 20 3 20H2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlphabetArabic' icon.
  static const List<List<dynamic>> alphabetArabic = strokeRoundedAlphabetArabic;

  /// JSON structure for the 'strokeRoundedAlphabetBangla' icon.
  static const List<List<dynamic>> strokeRoundedAlphabetBangla = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M14.7394 12.7799C15.773 12.7495 17.8505 14.1181 17.9964 19.8328M9.93274 10.7651C9.85184 10.0639 9.87585 8.55093 11.2281 7.80584C12.9955 6.83202 14.8132 8.46474 15.0206 10.2727C15.1223 11.1585 14.7652 13.992 13.2559 15.6892C12.6926 16.3227 12.1849 16.8767 11.2281 16.9748C10.3404 17.0659 9.61226 16.8283 8.76843 16.2714C7.41998 15.3814 6.01024 13.881 4.8146 11.8082C3.53743 9.59404 2.84713 8.08034 2.00195 5.02637',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M6.99609 6.36752C7.87394 5.41201 12.9902 1.68945 16.5947 6.13758C17.0314 6.67646 17.2497 6.9459 17.6229 7.99921C17.9961 9.05252 17.9961 9.78494 17.9961 11.2498V20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M17.9961 10C17.9961 7.72717 19.1961 4.62581 21.9961 5.03703',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlphabetBangla' icon.
  static const List<List<dynamic>> alphabetBangla = strokeRoundedAlphabetBangla;

  /// JSON structure for the 'strokeRoundedAlphabetChinese' icon.
  static const List<List<dynamic>> strokeRoundedAlphabetChinese = [
    [
      'path',
      {
        'key': '0',
        'd': 'M7.02344 14H18.0234',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M8.52344 9H14.7587C15.2218 9 15.4533 9 15.5109 9.1605C15.6967 9.67818 13.7549 11.4137 13.4567 11.7577C12.9682 12.3213 12.724 12.6031 12.5954 12.9615C12.4667 13.3198 12.4667 13.7184 12.4667 14.5154V18.075C12.4667 19.7377 11.5142 21 9.93177 21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M5.0157 7.99997C4.9404 7.25983 5.06511 5.86347 7.00907 5.99998H17.4743C18.1117 6.03692 19.1963 6.46024 18.9693 7.99997M10.9958 3C11.5968 3.31337 12.67 4.51459 12.9892 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlphabetChinese' icon.
  static const List<List<dynamic>> alphabetChinese =
      strokeRoundedAlphabetChinese;

  /// JSON structure for the 'strokeRoundedAlphabetGreek' icon.
  static const List<List<dynamic>> strokeRoundedAlphabetGreek = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2 19C2.02342 19.7767 2.11012 20.24 2.43105 20.5607C2.87077 21 3.57849 21 4.99393 21H7.965C8.74255 21 9.13132 21 9.17551 20.8603C9.2197 20.7206 8.88712 20.4868 8.22198 20.0192C5.86888 18.3648 3.99306 15.5091 3.99306 12.2636C3.99306 7.14744 7.57789 3 12 3C16.4221 3 20.0069 7.14744 20.0069 12.2636C20.0069 15.5091 18.1311 18.3648 15.778 20.0192C15.1129 20.4868 14.7803 20.7206 14.8245 20.8603C14.8687 21 15.2574 21 16.035 21H19.0061C20.4215 21 21.1292 21 21.5689 20.5607C21.8899 20.24 21.9766 19.7767 22 19',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlphabetGreek' icon.
  static const List<List<dynamic>> alphabetGreek = strokeRoundedAlphabetGreek;

  /// JSON structure for the 'strokeRoundedAlphabetHebrew' icon.
  static const List<List<dynamic>> strokeRoundedAlphabetHebrew = [
    [
      'path',
      {
        'key': '0',
        'd': 'M5 3C8.5 10.7143 14.9167 13.2857 19 21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M15 15C18.7587 12.75 19 8.78846 19 7C19 4.33333 18.3333 3 18.3333 3',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M5.72689 21C5.72689 21 5 19.6431 5 16.9292C5 15.1701 5.24577 11.3453 8.96186 9.02368',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlphabetHebrew' icon.
  static const List<List<dynamic>> alphabetHebrew = strokeRoundedAlphabetHebrew;

  /// JSON structure for the 'strokeRoundedAlphabetHindi' icon.
  static const List<List<dynamic>> strokeRoundedAlphabetHindi = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5.59988 5.65676C6.79984 4.48521 9.79974 3.3138 11.5997 4.48521C14.9486 6.66473 12.8 10.3431 9.20016 10.9288C10.8001 10.9288 14 11.6318 14 14.4435C14 18.7942 9.19988 21.1845 5.6 19.4092C2.00012 17.6339 2 14.7573 2 13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M19.0006 10C18.052 13.7503 14.9728 13.2464 13.1992 12.3941',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M19 5L19 20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M16 4C17.5 4.43301 19.5 4.86603 22 4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlphabetHindi' icon.
  static const List<List<dynamic>> alphabetHindi = strokeRoundedAlphabetHindi;

  /// JSON structure for the 'strokeRoundedAlphabetJapanese' icon.
  static const List<List<dynamic>> strokeRoundedAlphabetJapanese = [
    [
      'path',
      {
        'key': '0',
        'd': 'M11.0078 3C9.5913 7 7.06961 14 11.5 21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M3 5.31913C6.70588 6.19855 15.1765 6.63826 21 4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M16.0034 10C16.4981 13 12.5403 19.5 7.15287 19.9565C0.934783 20.4834 4.62421 11 12.0451 11.5C18.2926 11.921 22.0322 16.8261 15.7923 21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlphabetJapanese' icon.
  static const List<List<dynamic>> alphabetJapanese =
      strokeRoundedAlphabetJapanese;

  /// JSON structure for the 'strokeRoundedAlphabetKorean' icon.
  static const List<List<dynamic>> strokeRoundedAlphabetKorean = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5 6H11.1554C12.0231 6 12.4569 6 12.7534 6.31741C13.0498 6.63483 13.0234 7.02125 12.9707 7.79408C12.7255 11.3825 10.8793 17.0157 5 19',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M16 3V12M16 21V12M16 12H19',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlphabetKorean' icon.
  static const List<List<dynamic>> alphabetKorean = strokeRoundedAlphabetKorean;

  /// JSON structure for the 'strokeRoundedAlphabetThai' icon.
  static const List<List<dynamic>> strokeRoundedAlphabetThai = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6 21V14C6 13.371 6.24724 12.8125 6.74172 12.248C7.22967 11.671 8.25411 11.2708 9 11.0472C9.04786 11.0329 9.05246 10.9458 9.00628 10.9257C8.3551 10.6418 7.06568 10.2569 6.5674 9.59877C6.55409 9.58118 6.54743 9.57239 6.54632 9.57095C6.54521 9.5695 6.50377 9.5164 6.4209 9.41019C6 8.87077 6 7.80847 6 7.80847C6 5.93718 7.27312 4.43992 8.75497 3.69556C9.65563 3.23185 10.7241 3 11.9603 3C13.0375 3 14.0353 3.20161 14.9536 3.60484C16.9456 4.43574 18 6.43605 18 8.71573V21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAlphabetThai' icon.
  static const List<List<dynamic>> alphabetThai = strokeRoundedAlphabetThai;

  /// JSON structure for the 'strokeRoundedAmazon' icon.
  static const List<List<dynamic>> strokeRoundedAmazon = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M7 6L9.5 7C9.5 7 10 5 12 5C13.6 5 14.1664 6.86545 14 8.5C7.5 8.5 6.5 11.5 6.5 13C6.5 14.5 7.5 17 10.5 17C13 17 14.5 15 14.5 15L15.5 16.5L18 14.5C18 14.5 17 13.6667 17 12.5V9C17 9 17.6681 2.5 12 2.5C7.6 2.5 7 6 7 6Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M13.5 10.8555C13.5 12.3555 12.5805 14.3555 11.2014 14.3555C9.30586 14.3555 9.36245 10.8555 13.5 10.8555Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M2 17.5C2 17.5 10.5 23.5844 19 19.5281C19 19.5281 10.5 25.1056 2 17.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M21.99 17.7025C22.136 19.0999 20.6414 21 20.6414 21C20.6414 21 21.6208 19.4076 21.4245 17.7025C19.8212 17.0648 18 17.7895 18 17.7895C18 17.7895 19.5024 16.685 21.4245 17.0888C21.7265 17.1522 21.9579 17.3956 21.99 17.7025Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAmazon' icon.
  static const List<List<dynamic>> amazon = strokeRoundedAmazon;

  /// JSON structure for the 'strokeRoundedAmbulance' icon.
  static const List<List<dynamic>> strokeRoundedAmbulance = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M11 18H15M13.5 8H14.4429C15.7533 8 16.4086 8 16.9641 8.31452C17.5196 8.62904 17.89 9.20972 18.6308 10.3711C19.1502 11.1854 19.6955 11.7765 20.4622 12.3024C21.2341 12.8318 21.6012 13.0906 21.8049 13.506C22 13.9038 22 14.375 22 15.3173C22 16.5596 22 17.1808 21.651 17.5755C21.636 17.5925 21.6207 17.609 21.6049 17.625C21.2375 18 20.6594 18 19.503 18H19',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M5 18C3.58579 18 2.87868 18 2.43934 17.5607C2 17.1213 2 16.4142 2 15V8C2 6.58579 2 5.87868 2.43934 5.43934C2.87868 5 3.58579 5 5 5H10.5C11.9142 5 12.6213 5 13.0607 5.43934C13.5 5.87868 13.5 6.58579 13.5 8V18H9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M22 15H21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M8 9V13M10 11L6 11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'circle',
      {
        'key': '4',
        'cx': '17',
        'cy': '18',
        'r': '2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'circle',
      {
        'key': '5',
        'cx': '7',
        'cy': '18',
        'r': '2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAmbulance' icon.
  static const List<List<dynamic>> ambulance = strokeRoundedAmbulance;

  /// JSON structure for the 'strokeRoundedAmericanFootball' icon.
  static const List<List<dynamic>> strokeRoundedAmericanFootball = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M21.3006 6.05187C21.1484 5.22701 20.7411 4.45623 20.1372 3.85008C19.5309 3.24641 18.7599 2.83927 17.9348 2.68704C13.7379 1.98816 9.32857 3.26088 6.29895 6.28553C3.27 9.30951 1.9905 13.7155 2.68454 17.9122C2.83679 18.7371 3.24405 19.5079 3.84791 20.114C4.45425 20.7177 5.22527 21.1248 6.0504 21.2771C10.2213 22.0738 14.6996 20.7027 17.6917 17.6794C20.7496 14.6729 22.0291 10.2497 21.3006 6.05187Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M4 20L20 4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M9 12L12 15M12 9L15 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAmericanFootball' icon.
  static const List<List<dynamic>> americanFootball =
      strokeRoundedAmericanFootball;

  /// JSON structure for the 'strokeRoundedAmie' icon.
  static const List<List<dynamic>> strokeRoundedAmie = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3 8.5C3 9.82963 3.47182 11.0491 4.25716 12C3.47182 12.9509 3 14.1704 3 15.5C3 18.5376 5.46243 21 8.5 21C9.82963 21 11.0491 20.5282 12 19.7428C12.9509 20.5282 14.1704 21 15.5 21C18.5376 21 21 18.5376 21 15.5C21 14.1704 20.5282 12.9509 19.7428 12C20.5282 11.0491 21 9.82963 21 8.5C21 5.46243 18.5376 3 15.5 3C14.1704 3 12.9509 3.47182 12 4.25716C11.0491 3.47182 9.82963 3 8.5 3C5.46243 3 3 5.46243 3 8.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M10.5 9.5C10.5 8.67157 11.1716 8 12 8C12.8284 8 13.5 8.67157 13.5 9.5V14.5C13.5 15.3284 12.8284 16 12 16C11.1716 16 10.5 15.3284 10.5 14.5V9.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAmie' icon.
  static const List<List<dynamic>> amie = strokeRoundedAmie;

  /// JSON structure for the 'strokeRoundedAmmo' icon.
  static const List<List<dynamic>> strokeRoundedAmmo = [
    [
      'path',
      {
        'key': '0',
        'd': 'M9.5 8.5C9.5 5.5 8 2.5 8 2.5C8 2.5 6.5 5.5 6.5 8.5H9.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M10 11L9.5 8.5H6.5L6 11H10Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M10 11H6V18.5C6 19.0523 6.44772 19.5 7 19.5H9C9.55228 19.5 10 19.0523 10 18.5V11Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M10 22.5H6V20.5C6 19.9477 6.44772 19.5 7 19.5H9C9.55228 19.5 10 19.9477 10 20.5V22.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M17.5 8.5C17.5 5.5 16 2.5 16 2.5C16 2.5 14.5 5.5 14.5 8.5H17.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M18 11L17.5 8.5H14.5L14 11H18Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd':
            'M18 11H14V18.5C14 19.0523 14.4477 19.5 15 19.5H17C17.5523 19.5 18 19.0523 18 18.5V11Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '7',
        'd':
            'M18 22.5H14V20.5C14 19.9477 14.4477 19.5 15 19.5H17C17.5523 19.5 18 19.9477 18 20.5V22.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAmmo' icon.
  static const List<List<dynamic>> ammo = strokeRoundedAmmo;

  /// JSON structure for the 'strokeRoundedAmpoule' icon.
  static const List<List<dynamic>> strokeRoundedAmpoule = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5.44572 2.99906C5.12985 5.87904 3.57993 7.06862 4.93752 9.6052C5.02451 9.76774 5.06801 9.84901 5.08406 9.88583C5.26967 10.3116 5.19094 10.6954 4.8527 11.0137C4.82345 11.0412 4.77395 11.0808 4.67498 11.16C4.50514 11.2959 4.42021 11.3638 4.34268 11.4327C3.54255 12.1439 3.06086 13.1461 3.00538 14.2152C3 14.3188 3 14.4275 3 14.645V18.5C3 19.9045 3 20.6067 3.33706 21.1111C3.48298 21.3295 3.67048 21.517 3.88886 21.6629C4.39331 22 5.09554 22 6.5 22C7.90446 22 8.60669 22 9.11114 21.6629C9.32952 21.517 9.51702 21.3295 9.66294 21.1111C10 20.6067 10 19.9045 10 18.5V14.645C10 14.4275 10 14.3188 9.99462 14.2152C9.93913 13.1461 9.45745 12.1439 8.65732 11.4327C8.57978 11.3638 8.49486 11.2959 8.32502 11.16C8.22604 11.0808 8.17655 11.0412 8.1473 11.0137C7.80905 10.6954 7.73032 10.3116 7.91593 9.88584C7.93198 9.84902 7.97548 9.76774 8.06248 9.60519C9.42003 7.06859 7.86981 5.87902 7.55369 2.99897C7.49343 2.44999 7.05198 2 6.49971 2C5.9474 2 5.50594 2.45004 5.44572 2.99906Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M10 16H3',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M16.4457 2.99906C16.1298 5.87904 14.5799 7.06862 15.9375 9.6052C16.0245 9.76774 16.068 9.84901 16.0841 9.88583C16.2697 10.3116 16.1909 10.6954 15.8527 11.0137C15.8234 11.0412 15.774 11.0808 15.675 11.16C15.5051 11.2959 15.4202 11.3638 15.3427 11.4327C14.5425 12.1439 14.0609 13.1461 14.0054 14.2152C14 14.3188 14 14.4275 14 14.645V18.5C14 19.9045 14 20.6067 14.3371 21.1111C14.483 21.3295 14.6705 21.517 14.8889 21.6629C15.3933 22 16.0955 22 17.5 22C18.9045 22 19.6067 22 20.1111 21.6629C20.3295 21.517 20.517 21.3295 20.6629 21.1111C21 20.6067 21 19.9045 21 18.5V14.645C21 14.4275 21 14.3188 20.9946 14.2152C20.9391 13.1461 20.4574 12.1439 19.6573 11.4327C19.5798 11.3638 19.4949 11.2959 19.325 11.16C19.226 11.0808 19.1765 11.0412 19.1473 11.0137C18.8091 10.6954 18.7303 10.3116 18.9159 9.88584C18.932 9.84902 18.9755 9.76774 19.0625 9.60519C20.42 7.06859 18.8698 5.87902 18.5537 2.99897C18.4934 2.44999 18.052 2 17.4997 2C16.9474 2 16.5059 2.45004 16.4457 2.99906Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M21 16H14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAmpoule' icon.
  static const List<List<dynamic>> ampoule = strokeRoundedAmpoule;

  /// JSON structure for the 'strokeRoundedAnalysisTextLink' icon.
  static const List<List<dynamic>> strokeRoundedAnalysisTextLink = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M21 21H10C6.70017 21 5.05025 21 4.02513 19.9749C3 18.9497 3 17.2998 3 14V3',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M7 4H8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M7 7H11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M5 20C6.07093 18.053 7.52279 13.0189 10.3063 13.0189C12.2301 13.0189 12.7283 15.4717 14.6136 15.4717C17.8572 15.4717 17.387 10 21 10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAnalysisTextLink' icon.
  static const List<List<dynamic>> analysisTextLink =
      strokeRoundedAnalysisTextLink;

  /// JSON structure for the 'strokeRoundedAnalytics01' icon.
  static const List<List<dynamic>> strokeRoundedAnalytics01 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M7 17L7 13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M12 17L12 7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M17 17L17 11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAnalytics01' icon.
  static const List<List<dynamic>> analytics01 = strokeRoundedAnalytics01;

  /// JSON structure for the 'strokeRoundedAnalytics02' icon.
  static const List<List<dynamic>> strokeRoundedAnalytics02 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M6.5 17.5L6.5 14.5M11.5 17.5L11.5 8.5M16.5 17.5V13.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M21.5 5.5C21.5 7.15685 20.1569 8.5 18.5 8.5C16.8431 8.5 15.5 7.15685 15.5 5.5C15.5 3.84315 16.8431 2.5 18.5 2.5C20.1569 2.5 21.5 3.84315 21.5 5.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M21.4955 11C21.4955 11 21.5 11.3395 21.5 12C21.5 16.4784 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4784 2.5 12C2.5 7.52169 2.5 5.28252 3.89124 3.89127C5.28249 2.50003 7.52166 2.50003 12 2.50003L13 2.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAnalytics02' icon.
  static const List<List<dynamic>> analytics02 = strokeRoundedAnalytics02;

  /// JSON structure for the 'strokeRoundedAnalytics03' icon.
  static const List<List<dynamic>> strokeRoundedAnalytics03 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M4 9V20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M8 4V20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 11V20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M16 7V20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M20 14V20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAnalytics03' icon.
  static const List<List<dynamic>> analytics03 = strokeRoundedAnalytics03;

  /// JSON structure for the 'strokeRoundedAnalyticsDown' icon.
  static const List<List<dynamic>> strokeRoundedAnalyticsDown = [
    [
      'path',
      {
        'key': '0',
        'd': 'M17 18L17 16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M12 18L12 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M7 18L7 13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M6 7C9.19706 10.2683 13.2338 11.0813 17.1413 9.99185M15.6881 8.47133L17.7617 9.48839C18.0076 9.60901 18.074 9.88829 17.91 10.1122L16.5269 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAnalyticsDown' icon.
  static const List<List<dynamic>> analyticsDown = strokeRoundedAnalyticsDown;

  /// JSON structure for the 'strokeRoundedAnalyticsUp' icon.
  static const List<List<dynamic>> strokeRoundedAnalyticsUp = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M7 18V16M12 18V15M17 18V13M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M5.99219 11.4863C8.14729 11.5581 13.0341 11.2328 15.8137 6.82132M13.9923 6.28835L15.8678 5.98649C16.0964 5.95738 16.432 6.13785 16.5145 6.35298L17.0104 7.99142',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAnalyticsUp' icon.
  static const List<List<dynamic>> analyticsUp = strokeRoundedAnalyticsUp;

  /// JSON structure for the 'strokeRoundedAnchor' icon.
  static const List<List<dynamic>> strokeRoundedAnchor = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M14.5 5.5C14.5 6.88071 13.3807 8 12 8C10.6193 8 9.5 6.88071 9.5 5.5C9.5 4.11929 10.6193 3 12 3C13.3807 3 14.5 4.11929 14.5 5.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M12 8V21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M5 13L3 12C3 16.9706 7.02944 21 12 21C16.9706 21 21 16.9706 21 12L19 13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAnchor' icon.
  static const List<List<dynamic>> anchor = strokeRoundedAnchor;

  /// JSON structure for the 'strokeRoundedAnchorPoint' icon.
  static const List<List<dynamic>> strokeRoundedAnchorPoint = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M19 12C19 11.1716 19.6716 10.5 20.5 10.5C21.3284 10.5 22 11.1716 22 12C22 12.8284 21.3284 13.5 20.5 13.5C19.6716 13.5 19 12.8284 19 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M2 12C2 11.1716 2.67157 10.5 3.5 10.5C4.32843 10.5 5 11.1716 5 12C5 12.8284 4.32843 13.5 3.5 13.5C2.67157 13.5 2 12.8284 2 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M13.7071 10.2929C13.4142 10 12.9428 10 12 10C11.0572 10 10.5858 10 10.2929 10.2929M13.7071 10.2929C14 10.5858 14 11.0572 14 12C14 12.9428 14 13.4142 13.7071 13.7071M13.7071 10.2929C13.7071 10.2929 13.7071 10.2929 13.7071 10.2929ZM10.2929 10.2929C10 10.5858 10 11.0572 10 12C10 12.9428 10 13.4142 10.2929 13.7071M10.2929 10.2929C10.2929 10.2929 10.2929 10.2929 10.2929 10.2929ZM10.2929 13.7071C10.5858 14 11.0572 14 12 14C12.9428 14 13.4142 14 13.7071 13.7071M10.2929 13.7071C10.2929 13.7071 10.2929 13.7071 10.2929 13.7071ZM13.7071 13.7071C13.7071 13.7071 13.7071 13.7071 13.7071 13.7071Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M20.7071 2.29289C20.4142 2 19.9428 2 19 2C18.0572 2 17.5858 2 17.2929 2.29289M20.7071 2.29289C21 2.58579 21 3.05719 21 4C21 4.94281 21 5.41421 20.7071 5.70711M20.7071 2.29289C20.7071 2.29289 20.7071 2.29289 20.7071 2.29289ZM17.2929 2.29289C17 2.58579 17 3.05719 17 4C17 4.94281 17 5.41421 17.2929 5.70711M17.2929 2.29289C17.2929 2.29289 17.2929 2.29289 17.2929 2.29289ZM17.2929 5.70711C17.5858 6 18.0572 6 19 6C19.9428 6 20.4142 6 20.7071 5.70711M17.2929 5.70711C17.2929 5.70711 17.2929 5.70711 17.2929 5.70711ZM20.7071 5.70711C20.7071 5.70711 20.7071 5.70711 20.7071 5.70711Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M6.70711 18.2929C6.41421 18 5.94281 18 5 18C4.05719 18 3.58579 18 3.29289 18.2929M6.70711 18.2929C7 18.5858 7 19.0572 7 20C7 20.9428 7 21.4142 6.70711 21.7071M6.70711 18.2929C6.70711 18.2929 6.70711 18.2929 6.70711 18.2929ZM3.29289 18.2929C3 18.5858 3 19.0572 3 20C3 20.9428 3 21.4142 3.29289 21.7071M3.29289 18.2929C3.29289 18.2929 3.29289 18.2929 3.29289 18.2929ZM3.29289 21.7071C3.58579 22 4.05719 22 5 22C5.94281 22 6.41421 22 6.70711 21.7071M3.29289 21.7071C3.29289 21.7071 3.29289 21.7071 3.29289 21.7071ZM6.70711 21.7071C6.70711 21.7071 6.70711 21.7071 6.70711 21.7071Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M5 12H10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd': 'M14 12H19',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '7',
        'd': 'M12 10C12 8 12.8333 4 17 4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '8',
        'd': 'M12 14C12 16 11.1667 20 7 20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAnchorPoint' icon.
  static const List<List<dynamic>> anchorPoint = strokeRoundedAnchorPoint;

  /// JSON structure for the 'strokeRoundedAndroid' icon.
  static const List<List<dynamic>> strokeRoundedAndroid = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6.5 9.5C6.5 6.46243 8.96243 4 12 4C15.0376 4 17.5 6.46243 17.5 9.5V16C17.5 17.4142 17.5 18.1213 17.0607 18.5607C16.6213 19 15.9142 19 14.5 19H9.5C8.08579 19 7.37868 19 6.93934 18.5607C6.5 18.1213 6.5 17.4142 6.5 16V9.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M20 11V17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M15 19V22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M9 19V22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M4 11V17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M10 4L8.5 2M14 4L15.5 2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd': 'M6.5 10H17.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAndroid' icon.
  static const List<List<dynamic>> android = strokeRoundedAndroid;

  /// JSON structure for the 'strokeRoundedAngel' icon.
  static const List<List<dynamic>> strokeRoundedAngel = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3.07818 7.5C2.38865 8.85588 2 10.39 2 12.0148C2 17.5295 6.47715 22 12 22C17.5228 22 22 17.5295 22 12.0148C22 10.39 21.6114 8.85588 20.9218 7.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M8 15C8.91212 16.2144 10.3643 17 12 17C13.6357 17 15.0879 16.2144 16 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'ellipse',
      {
        'key': '2',
        'cx': '12',
        'cy': '4',
        'rx': '10',
        'ry': '2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M7 10.5C7 9.67154 7.67157 8.99997 8.5 8.99997C9.32843 8.99997 10 9.67154 10 10.5M14 10.4999C14 9.67151 14.6716 8.99994 15.5 8.99994C16.3284 8.99994 17 9.67151 17 10.4999',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAngel' icon.
  static const List<List<dynamic>> angel = strokeRoundedAngel;

  /// JSON structure for the 'strokeRoundedAngle' icon.
  static const List<List<dynamic>> strokeRoundedAngle = [
    [
      'path',
      {
        'key': '0',
        'd': 'M12 22V2M12 2L22 17M12 2L2 17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M16 8C14.8554 9.2634 13.4798 10 12 10C10.5202 10 9.14458 9.2634 8 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 14C9.78035 14 7.71687 13.2634 6 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAngle' icon.
  static const List<List<dynamic>> angle = strokeRoundedAngle;

  /// JSON structure for the 'strokeRoundedAngle01' icon.
  static const List<List<dynamic>> strokeRoundedAngle01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M21 20H6.47347C4.36707 20 3.31387 20 3.05177 19.3827C2.78966 18.7654 3.53439 18.0388 5.02384 16.5858L17.9249 4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M11 20C11 17.3517 9.77371 15.0655 8 14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAngle01' icon.
  static const List<List<dynamic>> angle01 = strokeRoundedAngle01;

  /// JSON structure for the 'strokeRoundedAngry' icon.
  static const List<List<dynamic>> strokeRoundedAngry = [
    [
      'circle',
      {
        'key': '0',
        'cx': '12',
        'cy': '12',
        'r': '10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M8 17C8.91212 15.7856 10.3643 15 12 15C13.6357 15 15.0879 15.7856 16 17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M7 9.01067C7 9.01067 8.40944 8.88341 9.19588 9.50798M9.19588 9.50798L8.93275 10.3427C8.82896 10.6719 9.10031 11 9.4764 11C9.87165 11 10.1327 10.6434 9.92918 10.3348C9.74877 10.0612 9.50309 9.75196 9.19588 9.50798ZM17 9.01067C17 9.01067 15.5906 8.88341 14.8041 9.50798M14.8041 9.50798L15.0672 10.3427C15.171 10.6719 14.8997 11 14.5236 11C14.1283 11 13.8673 10.6434 14.0708 10.3348C14.2512 10.0612 14.4969 9.75196 14.8041 9.50798Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAngry' icon.
  static const List<List<dynamic>> angry = strokeRoundedAngry;

  /// JSON structure for the 'strokeRoundedAngryBird' icon.
  static const List<List<dynamic>> strokeRoundedAngryBird = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M18.5 9.19028C16.9878 7.3721 14.7872 6 12.5 6C8.35786 6 4.5 10.5 4.5 14C4.5 18.1421 8.35786 21 12.5 21C13.0064 21 13.5086 20.9573 14 20.8747',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M13 8.5L17.7059 10L21 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M20.6089 16.1305H22L20.1374 14.5872C18.8302 13.5041 18.1766 12.9625 17.4061 13.002C16.6357 13.0415 16.0515 13.6466 14.8831 14.8567L14.7463 14.9984C14.2628 15.4993 14.021 15.7497 14.0017 16.0446C13.9983 16.0956 14 16.1467 14.0066 16.1974C14.0447 16.4908 14.302 16.7278 14.8167 17.2016C16.1158 18.3976 16.7654 18.9957 17.527 19C17.6567 19.0007 17.7862 18.9889 17.9133 18.9648C18.6592 18.823 19.1688 18.1193 20.1879 16.7119L20.6089 16.1305ZM20.6089 16.1305H17.8266',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M13.008 12L12.999 12',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M20.008 11.5L19.999 11.5',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M13 6C12.7333 5 11.56 3 9 3',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd': 'M11 6C10.5 5.47719 9 4.58841 7 5.21578',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '7',
        'd': 'M2 11L4 14L2 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAngryBird' icon.
  static const List<List<dynamic>> angryBird = strokeRoundedAngryBird;

  /// JSON structure for the 'strokeRoundedAnonymous' icon.
  static const List<List<dynamic>> strokeRoundedAnonymous = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M7 14.9999C5.34315 14.9999 4 16.343 4 17.9999C4 19.6567 5.34315 20.9999 7 20.9999C8.65685 20.9999 10 19.6567 10 17.9999C10 16.343 8.65685 14.9999 7 14.9999Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M17 14.9999C15.3431 14.9999 14 16.343 14 17.9999C14 19.6567 15.3431 20.9999 17 20.9999C18.6569 20.9999 20 19.6567 20 17.9999C20 16.343 18.6569 14.9999 17 14.9999Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M14 17H10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M22 12.9999C19.5434 11.7724 15.9734 10.9999 12 10.9999C8.02658 10.9999 4.45659 11.7724 2 12.9999',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M19 11.4999L17.9425 4.71233C17.7268 3.32807 16.2232 2.578 15.0093 3.24907L14.3943 3.58903C12.9019 4.414 11.0981 4.414 9.60574 3.58903L8.99074 3.24907C7.77676 2.578 6.27318 3.32808 6.05751 4.71233L5 11.4999',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAnonymous' icon.
  static const List<List<dynamic>> anonymous = strokeRoundedAnonymous;

  /// JSON structure for the 'strokeRoundedApi' icon.
  static const List<List<dynamic>> strokeRoundedApi = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M6 13.5L7.5 9L9.375 13.5M6 13.5L5.5 15M6 13.5H9.375M9.375 13.5L10 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M12.5 12V9.7C12.5 9.51387 12.5 9.42081 12.5245 9.34549C12.5739 9.19327 12.6933 9.07393 12.8455 9.02447C12.9208 9 13.0139 9 13.2 9H14.5C15.3284 9 16 9.67157 16 10.5C16 11.3284 15.3284 12 14.5 12H12.5ZM12.5 12V15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M18.5 9V15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedApi' icon.
  static const List<List<dynamic>> api = strokeRoundedApi;

  /// JSON structure for the 'strokeRoundedAppStore' icon.
  static const List<List<dynamic>> strokeRoundedAppStore = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M11 7L12 8.66667M17 17L13.4 11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M13 7L7 17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M6.5 14H12.5M17.5 14L15.5 14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAppStore' icon.
  static const List<List<dynamic>> appStore = strokeRoundedAppStore;

  /// JSON structure for the 'strokeRoundedApple' icon.
  static const List<List<dynamic>> strokeRoundedApple = [
    [
      'path',
      {
        'key': '0',
        'd': 'M12 5.75C12 3.75 13.5 1.75 15.5 1.75C15.5 3.75 14 5.75 12 5.75Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12.5 8.09001C11.9851 8.09001 11.5867 7.92646 11.1414 7.74368C10.5776 7.51225 9.93875 7.25 8.89334 7.25C7.02235 7.25 4 8.74945 4 12.7495C4 17.4016 7.10471 22.25 9.10471 22.25C9.77426 22.25 10.3775 21.9871 10.954 21.7359C11.4815 21.5059 11.9868 21.2857 12.5 21.2857C13.0132 21.2857 13.5185 21.5059 14.046 21.7359C14.6225 21.9871 15.2257 22.25 15.8953 22.25C17.2879 22.25 18.9573 19.8992 20 16.9008C18.3793 16.2202 17.338 14.618 17.338 12.75C17.338 11.121 18.2036 10.0398 19.5 9.25C18.5 7.75 17.0134 7.25 15.9447 7.25C14.8993 7.25 14.2604 7.51225 13.6966 7.74368C13.2514 7.92646 13.0149 8.09001 12.5 8.09001Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedApple' icon.
  static const List<List<dynamic>> apple = strokeRoundedApple;

  /// JSON structure for the 'strokeRoundedApple01' icon.
  static const List<List<dynamic>> strokeRoundedApple01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M8 5C5.23858 5 3 8.0139 3 11.0278C3 14.544 3.5 17.0556 5.5 20.0695C7.02044 22.1062 9.05026 22.6168 11.2139 21.1903C11.6757 20.8859 12.3243 20.8859 12.7861 21.1903C14.9497 22.6168 16.9796 22.1062 18.5 20.0695C20.5 17.0556 21 14.544 21 11.0278C21 8.0139 18.7614 5 16 5C14.5746 5 13.2885 5.7849 12.3777 6.63254C12.166 6.82949 11.834 6.82949 11.6223 6.63254C10.7115 5.7849 9.42542 5 8 5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M6 12C6 10.3665 6.82273 8.73298 8 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 6C12 4.66667 12.6 2 15 2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedApple01' icon.
  static const List<List<dynamic>> apple01 = strokeRoundedApple01;

  /// JSON structure for the 'strokeRoundedAppleFinder' icon.
  static const List<List<dynamic>> strokeRoundedAppleFinder = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M7 8V10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M17 8V10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M7 16.5C10.5 18.5 13.5 18.5 17 16.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M12.9896 2.5C12.1238 3.78525 10.5163 7.71349 10.0737 11.5798C9.98097 12.3899 9.9346 12.795 10.1905 13.1176C10.2151 13.1486 10.2474 13.1843 10.2757 13.212C10.5708 13.5 11.0149 13.5 11.9031 13.5C12.3889 13.5 12.6317 13.5 12.7766 13.6314C12.7923 13.6457 12.8051 13.6588 12.819 13.6748C12.9468 13.8225 12.9383 14.072 12.9212 14.5709C12.8685 16.1156 12.9401 19.0524 14 21.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAppleFinder' icon.
  static const List<List<dynamic>> appleFinder = strokeRoundedAppleFinder;

  /// JSON structure for the 'strokeRoundedAppleIntelligence' icon.
  static const List<List<dynamic>> strokeRoundedAppleIntelligence = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M17.3702 16.2713L20.465 15.2776C21.5834 14.9184 21.8652 13.4928 20.9647 12.749L18.5414 10.7472M17.3702 16.2713L15.6246 16.8319C14.8533 17.0796 14.1247 17.441 13.464 17.9038L12.1229 18.8432M17.3702 16.2713L17.4325 14.7768C17.4671 13.9453 17.636 13.1245 17.9329 12.345L18.5414 10.7472M17.3702 16.2713L17.2401 19.3942C17.193 20.5254 15.9184 21.1841 14.942 20.5819L12.1229 18.8432M12.1229 18.8432L9.43738 20.7242C8.50033 21.3805 7.19058 20.7997 7.07263 19.6754L6.74168 16.5208M12.1229 18.8432L10.5594 17.8788C9.87224 17.455 9.12342 17.1362 8.33865 16.9335L6.74168 16.5208M6.74168 16.5208L3.61989 15.7141C2.48271 15.4203 2.11569 14.0149 2.96854 13.22L5.2878 11.0584M6.74168 16.5208L6.43349 13.5832L5.2878 11.0584M5.2878 11.0584L4.00706 8.23589C3.53226 7.18955 4.40146 6.03466 5.55954 6.17312L8.85203 6.56678M5.2878 11.0584L6.58864 9.84595C7.1925 9.28313 7.70325 8.63126 8.10245 7.91385L8.85203 6.56678M8.85203 6.56678L10.4099 3.76716C10.9595 2.7795 12.3882 2.73674 12.998 3.68971L14.7505 6.42828M8.85203 6.56678L10.7141 6.78942C11.5126 6.88489 12.3213 6.86164 13.1127 6.72045L14.7505 6.42828M14.7505 6.42828L17.9828 5.85166C19.1288 5.64722 20.0649 6.74666 19.657 7.81789L18.5414 10.7472M14.7505 6.42828L15.6961 7.90606C16.1377 8.59606 16.6858 9.21445 17.3209 9.73905L18.5414 10.7472',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAppleIntelligence' icon.
  static const List<List<dynamic>> appleIntelligence =
      strokeRoundedAppleIntelligence;

  /// JSON structure for the 'strokeRoundedAppleNews' icon.
  static const List<List<dynamic>> strokeRoundedAppleNews = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 19.6581V15.0065C2.5 14.2973 2.5 13.9426 2.6313 13.9033C2.76259 13.8639 2.9637 14.1693 3.36592 14.7799C4.75816 16.8937 7.10621 19.2417 9.21998 20.634C9.83065 21.0362 10.136 21.2373 10.0966 21.3686C10.0573 21.4999 9.70263 21.4999 8.99336 21.4999H4.34177C3.47355 21.4999 3.03944 21.4999 2.76972 21.2302C2.5 20.9605 2.5 20.5264 2.5 19.6581Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M21.5004 4.34177V8.99336C21.5004 9.70263 21.5004 10.0573 21.3691 10.0966C21.2378 10.136 21.0367 9.83065 20.6345 9.21998C19.2422 7.10621 16.8942 4.75816 14.7804 3.36592C14.1697 2.9637 13.8644 2.76259 13.9038 2.6313C13.9431 2.5 14.2978 2.5 15.007 2.5H19.6586C20.5268 2.5 20.9609 2.5 21.2307 2.76972C21.5004 3.03944 21.5004 3.47355 21.5004 4.34177Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M2.5 4.4V6.62599C2.5 7.40261 2.5 7.79093 2.64463 8.14009C2.78926 8.48926 3.06384 8.76384 3.61299 9.31299L14.687 20.387C15.2362 20.9362 15.5107 21.2107 15.8599 21.3554C16.2091 21.5 16.5974 21.5 17.374 21.5H19.6C20.4957 21.5 20.9435 21.5 21.2218 21.2218C21.5 20.9435 21.5 20.4957 21.5 19.6V17.374C21.5 16.5974 21.5 16.2091 21.3554 15.8599C21.2107 15.5107 20.9362 15.2362 20.387 14.687L9.31299 3.61299C8.76384 3.06384 8.48926 2.78926 8.14009 2.64463C7.79093 2.5 7.40261 2.5 6.62599 2.5H4.4C3.50433 2.5 3.0565 2.5 2.77825 2.77825C2.5 3.0565 2.5 3.50433 2.5 4.4Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAppleNews' icon.
  static const List<List<dynamic>> appleNews = strokeRoundedAppleNews;

  /// JSON structure for the 'strokeRoundedApplePie' icon.
  static const List<List<dynamic>> strokeRoundedApplePie = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M16.5 7C18.6111 8.09821 20.1802 9.94542 20.7578 12.1376C21.5 12.1376 22 13.1645 22 14.0106C22 16.3424 18.5658 16.7405 18 14.5165C17.4968 16.4945 14.5032 16.4945 14 14.5165C13.4968 16.4945 10.5032 16.4945 10 14.5165C9.49677 16.4945 6.50323 16.4945 6 14.5165C5.43417 16.7405 2 16.3424 2 14.0106C2 13.1645 2.5 12.1376 3.24224 12.1376C3.81984 9.94542 5.38887 8.09821 7.5 7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12 4C13.1046 4 14 4.89543 14 6C14 7.10457 13.1046 8 12 8C10.8954 8 10 7.10457 10 6C10 4.89543 10.8954 4 12 4ZM12 4C12 3.5 12.4 2.4 14 2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M14.5 10.5L15 11.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M9.5 10.5L9 11.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M3.5 16L4.13246 17.8974C4.79247 19.8774 5.12248 20.8675 5.90815 21.4337C6.69381 22 7.73739 22 9.82456 22H14.1754C16.2626 22 17.3062 22 18.0919 21.4337C18.8775 20.8675 19.2075 19.8774 19.8675 17.8974L20.5 16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedApplePie' icon.
  static const List<List<dynamic>> applePie = strokeRoundedApplePie;

  /// JSON structure for the 'strokeRoundedAppleReminder' icon.
  static const List<List<dynamic>> strokeRoundedAppleReminder = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M11 7.5H17M8 7.5C8 7.77614 7.77614 8 7.5 8C7.22386 8 7 7.77614 7 7.5C7 7.22386 7.22386 7 7.5 7C7.77614 7 8 7.22386 8 7.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M11 12H17M8 12C8 12.2761 7.77614 12.5 7.5 12.5C7.22386 12.5 7 12.2761 7 12C7 11.7239 7.22386 11.5 7.5 11.5C7.77614 11.5 8 11.7239 8 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M11 16.5H17M8 16.5C8 16.7761 7.77614 17 7.5 17C7.22386 17 7 16.7761 7 16.5C7 16.2239 7.22386 16 7.5 16C7.77614 16 8 16.2239 8 16.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAppleReminder' icon.
  static const List<List<dynamic>> appleReminder = strokeRoundedAppleReminder;

  /// JSON structure for the 'strokeRoundedAppleStocks' icon.
  static const List<List<dynamic>> strokeRoundedAppleStocks = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M2.5 14.5H3.03875C3.51106 14.5 3.74721 14.5 3.95256 14.4013C4.15791 14.3026 4.30544 14.1182 4.60049 13.7494L6 12L7.5 14.5L9 11L11.5 16L15 9L17 12.5L18.5 11L19.9453 13.168C20.1973 13.546 20.3233 13.735 20.5074 13.8494C20.544 13.8721 20.582 13.8925 20.6212 13.9103C20.8185 14 21.0457 14 21.5 14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M15 2.5V5.5M15 21.5V14.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'circle',
      {
        'key': '3',
        'cx': '15',
        'cy': '9',
        'r': '1',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAppleStocks' icon.
  static const List<List<dynamic>> appleStocks = strokeRoundedAppleStocks;

  /// JSON structure for the 'strokeRoundedAppleVisionPro' icon.
  static const List<List<dynamic>> strokeRoundedAppleVisionPro = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6.5 17.5C4 17.5 1.99974 16 2 12.5C2.00029 8.5 5.00001 6.5 12 6.5C19 6.5 21.9997 8.5 22 12.5C22.0003 16 20 17.5 17.5 17.5C15 17.5 13.5 15 12 15C10.5 15 9 17.5 6.5 17.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAppleVisionPro' icon.
  static const List<List<dynamic>> appleVisionPro = strokeRoundedAppleVisionPro;

  /// JSON structure for the 'strokeRoundedAppointment01' icon.
  static const List<List<dynamic>> strokeRoundedAppointment01 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M16 2V6M8 2V6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M21 13V12C21 8.22876 21 6.34315 19.8284 5.17157C18.6569 4 16.7712 4 13 4H11C7.22876 4 5.34315 4 4.17157 5.17157C3 6.34315 3 8.22876 3 12V14C3 17.7712 3 19.6569 4.17157 20.8284C5.34315 22 7.22876 22 11 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M3 10H21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M13 19.5C13 19.5 14.3485 20.0067 15 22C15 22 18.1765 17 21 16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAppointment01' icon.
  static const List<List<dynamic>> appointment01 = strokeRoundedAppointment01;

  /// JSON structure for the 'strokeRoundedAppointment02' icon.
  static const List<List<dynamic>> strokeRoundedAppointment02 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M16 2V6M8 2V6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M13 4H11C7.22876 4 5.34315 4 4.17157 5.17157C3 6.34315 3 8.22876 3 12V14C3 17.7712 3 19.6569 4.17157 20.8284C5.34315 22 7.22876 22 11 22H13C16.7712 22 18.6569 22 19.8284 20.8284C21 19.6569 21 17.7712 21 14V12C21 8.22876 21 6.34315 19.8284 5.17157C18.6569 4 16.7712 4 13 4Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M3 10H21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M9 16.5C9 16.5 10.5 17 11 18.5C11 18.5 13.1765 14.5 16 13.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAppointment02' icon.
  static const List<List<dynamic>> appointment02 = strokeRoundedAppointment02;

  /// JSON structure for the 'strokeRoundedApproximatelyEqual' icon.
  static const List<List<dynamic>> strokeRoundedApproximatelyEqual = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4 7.927C6.66667 4.9281 9.33333 5.80578 12 8C14.6667 10.1942 17.3333 11.0719 20 8.073',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M4 15.927C6.66667 12.9281 9.33333 13.8058 12 16C14.6667 18.1942 17.3333 19.0719 20 16.073',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedApproximatelyEqual' icon.
  static const List<List<dynamic>> approximatelyEqual =
      strokeRoundedApproximatelyEqual;

  /// JSON structure for the 'strokeRoundedApproximatelyEqualCircle' icon.
  static const List<List<dynamic>> strokeRoundedApproximatelyEqualCircle = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M7 9.28466C8.66667 7.2854 10.3333 7.87052 12 9.33333C13.6667 10.7961 15.3333 11.3813 17 9.382M7 14.618C8.66667 12.6187 10.3333 13.2039 12 14.6667C13.6667 16.1295 15.3333 16.7146 17 14.7153',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'circle',
      {
        'key': '1',
        'cx': '12',
        'cy': '12',
        'r': '10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedApproximatelyEqualCircle' icon.
  static const List<List<dynamic>> approximatelyEqualCircle =
      strokeRoundedApproximatelyEqualCircle;

  /// JSON structure for the 'strokeRoundedApproximatelyEqualSquare' icon.
  static const List<List<dynamic>> strokeRoundedApproximatelyEqualSquare = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M7 9.28466C8.66667 7.2854 10.3333 7.87052 12 9.33333C13.6667 10.7961 15.3333 11.3813 17 9.382M7 14.618C8.66667 12.6187 10.3333 13.2039 12 14.6667C13.6667 16.1295 15.3333 16.7146 17 14.7153',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedApproximatelyEqualSquare' icon.
  static const List<List<dynamic>> approximatelyEqualSquare =
      strokeRoundedApproximatelyEqualSquare;

  /// JSON structure for the 'strokeRoundedApricot' icon.
  static const List<List<dynamic>> strokeRoundedApricot = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M10.201 20C11.3469 21.2447 12.852 22 14.5005 22C18.0903 22 21.0005 18.4183 21.0005 14C21.0005 9.58172 18.0903 6 14.5005 6C11.1858 6 8.39983 9.05369 8 13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12 21.3869C11.2304 21.7819 10.3859 22 9.5 22C5.91015 22 3 18.4183 3 14C3 9.58172 5.91015 6 9.5 6C10.3859 6 11.2304 6.21813 12 6.61312',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 6C12 4.66667 12.6 2 15 2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedApricot' icon.
  static const List<List<dynamic>> apricot = strokeRoundedApricot;

  /// JSON structure for the 'strokeRoundedApron' icon.
  static const List<List<dynamic>> strokeRoundedApron = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M19 11V16C19 18.8284 19 20.2426 18.1213 21.1213C17.2426 22 15.8284 22 13 22H11C8.17157 22 6.75736 22 5.87868 21.1213C5 20.2426 5 18.8284 5 16V11M8 8H16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12.5 13H11.5C10.5572 13 10.0858 13 9.79289 13.2929C9.5 13.5858 9.5 14.0572 9.5 15V16C9.5 16.9428 9.5 17.4142 9.79289 17.7071C10.0858 18 10.5572 18 11.5 18H12.5C13.4428 18 13.9142 18 14.2071 17.7071C14.5 17.4142 14.5 16.9428 14.5 16V15C14.5 14.0572 14.5 13.5858 14.2071 13.2929C13.9142 13 13.4428 13 12.5 13Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M20.0302 6.5C21.8897 7.89188 20.9043 11 18.5243 11C15.7119 11 16.015 7.9346 16.015 6C16.015 3.79086 14.2174 2 12 2C9.7826 2 7.98504 3.79086 7.98504 6C7.98504 7.9346 8.28808 11 5.47569 11C3.09553 11 2.11029 7.89156 3.97008 6.49982',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedApron' icon.
  static const List<List<dynamic>> apron = strokeRoundedApron;

  /// JSON structure for the 'strokeRoundedArcBrowser' icon.
  static const List<List<dynamic>> strokeRoundedArcBrowser = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M13.5061 13.6018C12.905 13.788 12.2654 13.8885 11.602 13.8885C9.12036 13.8885 6.96846 12.4842 5.93046 10.431C5.48592 9.55161 4.39999 9.19282 3.50496 9.62957C2.60993 10.0663 2.24474 11.1332 2.68928 12.0126C4.3146 15.2277 7.69305 17.444 11.602 17.444C12.8475 17.444 14.0394 17.2191 15.138 16.8084',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18.2384 14.9501C20.013 13.3865 21.2128 11.2053 21.4889 8.75026C21.5987 7.77436 20.8824 6.89583 19.8891 6.78801C18.8958 6.68019 18.0016 7.38391 17.8919 8.35981C17.7555 9.57212 17.2644 10.6794 16.5229 11.5793',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M11.5473 3.99976C12.2327 3.99976 12.8592 4.38021 13.1658 4.98249L19.4989 17.427C19.9458 18.3052 19.5835 19.373 18.6897 19.8121C17.7958 20.2512 16.7089 19.8953 16.262 19.0171L11.5473 9.75278L9.6037 13.5719C8.41018 13.1819 7.37371 12.4516 6.61386 11.4964L9.92887 4.98249C10.2354 4.38021 10.8619 3.99976 11.5473 3.99976Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M6.8326 19.0171C6.38568 19.8953 5.29878 20.2512 4.40494 19.8121C3.5111 19.373 3.1488 18.3052 3.59572 17.427L4.89047 14.8828C5.78379 15.686 6.82705 16.3313 7.97447 16.7733L6.8326 19.0171Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArcBrowser' icon.
  static const List<List<dynamic>> arcBrowser = strokeRoundedArcBrowser;

  /// JSON structure for the 'strokeRoundedArcher' icon.
  static const List<List<dynamic>> strokeRoundedArcher = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M11 17.0294L20 21C19.4444 20.4444 18.4898 18.6435 19.1158 15.8842C19.8982 12.4351 21.3667 8.96668 15.9368 7.06317C14.0333 1.63335 10.5649 3.10176 7.11578 3.88422C4.35649 4.51018 2.55556 3.55556 2 3L6 12.0741',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M5 18H2L5 15H8V18L5 21V18Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M8 15L20 3',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M17 3H19C19.4714 3 19.7071 3 19.8536 3.14645C20 3.29289 20 3.5286 20 4V6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArcher' icon.
  static const List<List<dynamic>> archer = strokeRoundedArcher;

  /// JSON structure for the 'strokeRoundedArchive' icon.
  static const List<List<dynamic>> strokeRoundedArchive = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M13 2H11C7.22876 2 5.34315 2 4.17157 3.17157C3 4.34315 3 6.22876 3 10V14C3 17.7712 3 19.6569 4.17157 20.8284C5.34315 22 7.22876 22 11 22H13C16.7712 22 18.6569 22 19.8284 20.8284C21 19.6569 21 17.7712 21 14V10C21 6.22876 21 4.34315 19.8284 3.17157C18.6569 2 16.7712 2 13 2Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M21 12H3',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M15 7H9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M15 17H9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArchive' icon.
  static const List<List<dynamic>> archive = strokeRoundedArchive;

  /// JSON structure for the 'strokeRoundedArchive01' icon.
  static const List<List<dynamic>> strokeRoundedArchive01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M10.0001 17V7C10.0001 5.11438 10.0001 4.17157 9.41427 3.58579C8.82849 3 7.88568 3 6.00005 3C4.11444 3 3.17163 3 2.58584 3.58578C2.00006 4.17157 2.00005 5.11437 2.00004 6.99998L2 17C1.99999 18.8856 1.99999 19.8284 2.58577 20.4142C3.17156 21 4.11438 21 6.00003 21C7.88567 21 8.82849 21 9.41427 20.4142C10.0001 19.8284 10.0001 18.8856 10.0001 17Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M21.4558 15.7091L19.0473 7.19224C18.572 5.51165 18.3343 4.67135 17.6838 4.2617C17.6312 4.22861 17.5772 4.19796 17.5218 4.16986C16.8358 3.82199 15.9877 4.04691 14.2916 4.49674C12.5529 4.95783 11.6836 5.18838 11.2632 5.84738C11.2293 5.90053 11.198 5.95524 11.1693 6.01134C10.8134 6.70684 11.057 7.5682 11.5442 9.2909L13.9527 17.8078C14.428 19.4884 14.6657 20.3287 15.3162 20.7383C15.3688 20.7714 15.4228 20.802 15.4782 20.8301C16.1642 21.178 17.0123 20.9531 18.7084 20.5033C20.4471 20.0422 21.3164 19.8116 21.7368 19.1526C21.7707 19.0995 21.802 19.0448 21.8307 18.9887C22.1866 18.2932 21.943 17.4318 21.4558 15.7091Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M6 17H6.00898',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M2 7H10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M17.9912 17.0034L17.9999 17.0011',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M12 9.00019L19 7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArchive01' icon.
  static const List<List<dynamic>> archive01 = strokeRoundedArchive01;

  /// JSON structure for the 'strokeRoundedArchive02' icon.
  static const List<List<dynamic>> strokeRoundedArchive02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M7 21H16.9999C19.3569 21 20.5354 21 21.2677 20.2678C21.9999 19.5355 21.9999 18.357 21.9999 16C21.9999 13.643 21.9999 12.4645 21.2677 11.7322C20.5354 11 19.3569 11 16.9999 11H7C4.64302 11 3.46453 11 2.7323 11.7322C2.00007 12.4644 2.00005 13.6429 2 15.9999C1.99995 18.357 1.99993 19.5355 2.73217 20.2677C3.4644 21 4.64294 21 7 21Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M4 11C4.00005 9.59977 4.00008 8.89966 4.27263 8.36485C4.5123 7.89455 4.89469 7.51218 5.365 7.27253C5.89981 7 6.59993 7 8.00015 7H16C17.4001 7 18.1002 7 18.635 7.27248C19.1054 7.51217 19.4878 7.89462 19.7275 8.36502C20 8.8998 20 9.59987 20 11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M6 7C6.00004 5.5998 6.00006 4.89969 6.27259 4.3649C6.51227 3.89457 6.89467 3.51218 7.36501 3.27252C7.89981 3 8.59991 3 10.0001 3H14C15.4001 3 16.1002 3 16.635 3.27248C17.1054 3.51217 17.4878 3.89462 17.7275 4.36502C18 4.8998 18 5.59987 18 7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M16 15L15.7 15.4C15.1111 16.1851 14.8167 16.5777 14.3944 16.7889C13.9721 17 13.4814 17 12.5 17H11.5C10.5186 17 10.0279 17 9.60557 16.7889C9.18328 16.5777 8.88885 16.1851 8.3 15.4L8 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArchive02' icon.
  static const List<List<dynamic>> archive02 = strokeRoundedArchive02;

  /// JSON structure for the 'strokeRoundedArchive03' icon.
  static const List<List<dynamic>> strokeRoundedArchive03 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M21 7H3V13C3 16.7712 3 18.6569 4.17157 19.8284C5.34315 21 7.22876 21 11 21H13C16.7712 21 18.6569 21 19.8284 19.8284C21 18.6569 21 16.7712 21 13V7Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M21 7H3L4.2 5.4C5.08328 4.22229 5.52492 3.63344 6.15836 3.31672C6.7918 3 7.52786 3 9 3H15C16.4721 3 17.2082 3 17.8416 3.31672C18.4751 3.63344 18.9167 4.22229 19.8 5.4L21 7Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M12 17L12 10.5M9 14.5C9.58984 15.1068 11.1597 17.5 12 17.5C12.8403 17.5 14.4102 15.1068 15 14.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArchive03' icon.
  static const List<List<dynamic>> archive03 = strokeRoundedArchive03;

  /// JSON structure for the 'strokeRoundedArmoredBoot' icon.
  static const List<List<dynamic>> strokeRoundedArmoredBoot = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M19.8629 22H9.05441C6.20033 22 4.7733 22 3.88665 21.119C3 20.238 3 18.82 3 15.984V7.11652C3 6.52911 3 6.23541 3.15915 5.85969C3.3183 5.48398 3.45975 5.34712 3.74267 5.07341C4.84945 4.00264 6.92721 2.70559 10.1018 2.18241C11.3888 1.9703 12.0324 1.86425 12.5615 2.31472C13.0907 2.7652 13.0907 3.49507 13.0907 4.9548V10.6189C13.0907 12.017 13.0907 12.716 13.3631 13.3102C13.8866 14.4519 15.079 14.9007 16.1548 15.3996C16.9152 15.7522 17.7114 16.0661 18.4427 16.4775C19.7311 17.2022 20.6341 18.4527 20.9125 19.8976C21.1005 20.8736 21.0814 22 19.8629 22Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M3 17C3 17 5.00702 16 5.9505 16.2939C7.07883 16.6454 7.96297 17.6232 9 16.2713C10.1316 14.9447 11.9915 14 14 14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M19.0586 17C18.0586 17.3333 16.0586 18.8 16.0586 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M3.05859 8.5H6.05859',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M3 12H5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M9.99981 6H10.0088',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd': 'M9.99981 10H10.0088',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArmoredBoot' icon.
  static const List<List<dynamic>> armoredBoot = strokeRoundedArmoredBoot;

  /// JSON structure for the 'strokeRoundedArrange' icon.
  static const List<List<dynamic>> strokeRoundedArrange = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3 4.5C3 3.67157 3.67157 3 4.5 3H6.5C7.32843 3 8 3.67157 8 4.5V6.5C8 7.32843 7.32843 8 6.5 8H4.5C3.67157 8 3 7.32843 3 6.5V4.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M3 17.5C3 16.6716 3.67157 16 4.5 16H6.5C7.32843 16 8 16.6716 8 17.5V19.5C8 20.3284 7.32843 21 6.5 21H4.5C3.67157 21 3 20.3284 3 19.5V17.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M8.00002 18.5H21M16 5.5H8.00002M16.3235 7.67649L7.64868 16.3513',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M16 4.5C16 3.67157 16.6716 3 17.5 3H19.5C20.3284 3 21 3.67157 21 4.5V6.5C21 7.32843 20.3284 8 19.5 8H17.5C16.6716 8 16 7.32843 16 6.5V4.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M18 21L19.3883 20.0537C20.4628 19.3213 21 18.9551 21 18.5C21 18.0449 20.4628 17.6787 19.3883 16.9463L18 16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrange' icon.
  static const List<List<dynamic>> arrange = strokeRoundedArrange;

  /// JSON structure for the 'strokeRoundedArrangeByLettersAZ' icon.
  static const List<List<dynamic>> strokeRoundedArrangeByLettersAZ = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4 14H8.42109C9.35119 14 9.81624 14 9.94012 14.2801C10.064 14.5603 9.74755 14.8963 9.11466 15.5684L5.47691 19.4316C4.84402 20.1037 4.52757 20.4397 4.65145 20.7199C4.77533 21 5.24038 21 6.17048 21H10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M4 9L6.10557 4.30527C6.49585 3.43509 6.69098 3 7 3C7.30902 3 7.50415 3.43509 7.89443 4.30527L10 9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M17.5 20V4M17.5 20C16.7998 20 15.4915 18.0057 15 17.5M17.5 20C18.2002 20 19.5085 18.0057 20 17.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrangeByLettersAZ' icon.
  static const List<List<dynamic>> arrangeByLettersAZ =
      strokeRoundedArrangeByLettersAZ;

  /// JSON structure for the 'strokeRoundedArrangeByLettersZA' icon.
  static const List<List<dynamic>> strokeRoundedArrangeByLettersZA = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4 3H8.42109C9.35119 3 9.81624 3 9.94012 3.28013C10.064 3.56026 9.74755 3.89632 9.11466 4.56842L5.47691 8.43158C4.84402 9.10368 4.52757 9.43974 4.65145 9.71987C4.77533 10 5.24038 10 6.17048 10H10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M4 21L6.10557 16.3053C6.49585 15.4351 6.69098 15 7 15C7.30902 15 7.50415 15.4351 7.89443 16.3053L10 21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M17.5 20V4M17.5 20C16.7998 20 15.4915 18.0057 15 17.5M17.5 20C18.2002 20 19.5085 18.0057 20 17.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrangeByLettersZA' icon.
  static const List<List<dynamic>> arrangeByLettersZA =
      strokeRoundedArrangeByLettersZA;

  /// JSON structure for the 'strokeRoundedArrangeByNumbers19' icon.
  static const List<List<dynamic>> strokeRoundedArrangeByNumbers19 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M7 10.0002V3.94897C7 3.37446 7 3.0872 6.76959 3.01571C6.26306 2.85855 5.5 3.99988 5.5 3.99988M7 10.0002H5.5M7 10.0002H8.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M9 17.5V15.75C9 14.925 9 14.5126 8.70711 14.2563C8.41421 14 7.94281 14 7 14C6.05719 14 5.58579 14 5.29289 14.2563C5 14.5126 5 14.925 5 15.75C5 16.575 5 16.9874 5.29289 17.2437C5.58579 17.5 6.05719 17.5 7 17.5H9ZM9 17.5V18.375C9 19.6124 9 20.2312 8.56066 20.6156C8.12132 21 7.41421 21 6 21H5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M16.5 20V4M16.5 20C15.7998 20 14.4915 18.0057 14 17.5M16.5 20C17.2002 20 18.5085 18.0057 19 17.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrangeByNumbers19' icon.
  static const List<List<dynamic>> arrangeByNumbers19 =
      strokeRoundedArrangeByNumbers19;

  /// JSON structure for the 'strokeRoundedArrangeByNumbers91' icon.
  static const List<List<dynamic>> strokeRoundedArrangeByNumbers91 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6.99988 21.0003V14.9491C6.99988 14.3746 6.99988 14.0873 6.76947 14.0158C6.26294 13.8587 5.49988 15 5.49988 15M6.99988 21.0003H5.49988M6.99988 21.0003H8.49988',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M8.99988 6.50098V4.75098C8.99988 3.92602 8.99988 3.51354 8.70698 3.25726C8.41409 3.00098 7.94269 3.00098 6.99988 3.00098C6.05707 3.00098 5.58566 3.00098 5.29277 3.25726C4.99988 3.51354 4.99988 3.92602 4.99988 4.75098C4.99988 5.57593 4.99988 5.98841 5.29277 6.2447C5.58566 6.50098 6.05707 6.50098 6.99988 6.50098H8.99988ZM8.99988 6.50098V7.37598C8.99988 8.61341 8.99988 9.23213 8.56054 9.61655C8.1212 10.001 7.41409 10.001 5.99988 10.001H4.99988',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M16.4999 20V4M16.4999 20C15.7997 20 14.4915 18.0057 13.9999 17.5M16.4999 20C17.2002 20 18.5084 18.0057 18.9999 17.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrangeByNumbers91' icon.
  static const List<List<dynamic>> arrangeByNumbers91 =
      strokeRoundedArrangeByNumbers91;

  /// JSON structure for the 'strokeRoundedArrowAllDirection' icon.
  static const List<List<dynamic>> strokeRoundedArrowAllDirection = [
    [
      'path',
      {
        'key': '0',
        'd': 'M11.9902 8.98595V3.31543',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M11.9902 20.6705V15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M20.6702 12.0001L14.9999 11.9482',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M9.00031 12.0001L3.33002 11.9482',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M14.9999 5.99998C14.9999 5.99998 12.7904 3.00001 11.9999 3C11.2093 2.99999 8.99995 6 8.99995 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd':
            'M5.99993 15C5.99993 15 2.99996 12.7905 2.99995 12C2.99994 11.2094 5.99995 9 5.99995 9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd':
            'M17.9999 9C17.9999 9 20.9999 11.2095 20.9999 12C20.9999 12.7906 17.9999 15 17.9999 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '7',
        'd':
            'M8.99995 18C8.99995 18 11.2094 21 11.9999 21C12.7905 21 14.9999 18 14.9999 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowAllDirection' icon.
  static const List<List<dynamic>> arrowAllDirection =
      strokeRoundedArrowAllDirection;

  /// JSON structure for the 'strokeRoundedArrowDataTransferDiagonal' icon.
  static const List<List<dynamic>> strokeRoundedArrowDataTransferDiagonal = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M9 19L18.1795 9.9942C18.9276 9.26025 19.3016 8.89327 19.6243 9.02718C19.9469 9.16108 19.9526 9.68566 19.964 10.7348L20 14.0459',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M15 5L5.82055 14.0058C5.07244 14.7398 4.69839 15.1067 4.37573 14.9728C4.05306 14.8389 4.04736 14.3143 4.03597 13.2652L4 9.95414',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowDataTransferDiagonal' icon.
  static const List<List<dynamic>> arrowDataTransferDiagonal =
      strokeRoundedArrowDataTransferDiagonal;

  /// JSON structure for the 'strokeRoundedArrowDataTransferHorizontal' icon.
  static const List<List<dynamic>> strokeRoundedArrowDataTransferHorizontal = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M19 9H6.65856C5.65277 9 5.14987 9 5.02472 8.69134C4.89957 8.38268 5.25517 8.01942 5.96637 7.29289L8.21091 5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M5 15H17.3414C18.3472 15 18.8501 15 18.9753 15.3087C19.1004 15.6173 18.7448 15.9806 18.0336 16.7071L15.7891 19',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowDataTransferHorizontal' icon.
  static const List<List<dynamic>> arrowDataTransferHorizontal =
      strokeRoundedArrowDataTransferHorizontal;

  /// JSON structure for the 'strokeRoundedArrowDataTransferVertical' icon.
  static const List<List<dynamic>> strokeRoundedArrowDataTransferVertical = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M15 19L15 6.65856C15 5.65277 15 5.14987 15.3087 5.02472C15.6173 4.89956 15.9806 5.25517 16.7071 5.96637L19 8.21091',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M9 5L9 17.3414C9 18.3472 9 18.8501 8.69134 18.9753C8.38268 19.1004 8.01942 18.7448 7.29289 18.0336L5 15.7891',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowDataTransferVertical' icon.
  static const List<List<dynamic>> arrowDataTransferVertical =
      strokeRoundedArrowDataTransferVertical;

  /// JSON structure for the 'strokeRoundedArrowDiagonal' icon.
  static const List<List<dynamic>> strokeRoundedArrowDiagonal = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M16.5001 3.26621C17.3445 3.25421 20.141 2.67328 20.7339 3.26621C21.3268 3.85913 20.7459 6.65559 20.7339 7.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M3.26631 16.5C3.25431 17.3444 2.67338 20.1409 3.26631 20.7338C3.85923 21.3267 6.65569 20.7458 7.5001 20.7338',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M3.89561 20.0577L20.1047 3.94238',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowDiagonal' icon.
  static const List<List<dynamic>> arrowDiagonal = strokeRoundedArrowDiagonal;

  /// JSON structure for the 'strokeRoundedArrowDown01' icon.
  static const List<List<dynamic>> strokeRoundedArrowDown01 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M18 9.00005C18 9.00005 13.5811 15 12 15C10.4188 15 6 9 6 9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowDown01' icon.
  static const List<List<dynamic>> arrowDown01 = strokeRoundedArrowDown01;

  /// JSON structure for the 'strokeRoundedArrowDown02' icon.
  static const List<List<dynamic>> strokeRoundedArrowDown02 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M12 20L12 4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M17 15C17 15 13.3175 20 11.9999 20C10.6823 20 6.99997 15 6.99997 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowDown02' icon.
  static const List<List<dynamic>> arrowDown02 = strokeRoundedArrowDown02;

  /// JSON structure for the 'strokeRoundedArrowDown03' icon.
  static const List<List<dynamic>> strokeRoundedArrowDown03 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M6 20L18 20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M12 16V4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M16 12C16 12 13.054 16 12 16C10.9459 16 8 12 8 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowDown03' icon.
  static const List<List<dynamic>> arrowDown03 = strokeRoundedArrowDown03;

  /// JSON structure for the 'strokeRoundedArrowDown04' icon.
  static const List<List<dynamic>> strokeRoundedArrowDown04 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M10.3974 18.5859L9.63609 17.6194C8.40261 16.0536 7.78587 15.2707 8.06718 14.6354C8.3485 14 9.31188 14 11.2386 14H12.7613C14.6881 14 15.6514 14 15.9328 14.6354C16.2141 15.2707 15.5973 16.0536 14.3638 17.6194L13.6025 18.5858C12.8598 19.5286 12.4885 20 12 20C11.5114 20 11.1401 19.5286 10.3974 18.5859Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M12 14L12 4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowDown04' icon.
  static const List<List<dynamic>> arrowDown04 = strokeRoundedArrowDown04;

  /// JSON structure for the 'strokeRoundedArrowDown05' icon.
  static const List<List<dynamic>> strokeRoundedArrowDown05 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M6 19.9985H17.9997',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M11.996 4.00195V11.53M14.5055 14.5899L15.9502 12.6384C16.2907 12.1784 15.9594 11.53 15.3839 11.53H8.67439C8.10419 11.53 7.77156 12.1679 8.10132 12.6291L9.50342 14.5899L11.444 16.9564C11.7237 17.2976 12.2484 17.2996 12.5307 16.9606L14.5055 14.5899Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowDown05' icon.
  static const List<List<dynamic>> arrowDown05 = strokeRoundedArrowDown05;

  /// JSON structure for the 'strokeRoundedArrowDownDouble' icon.
  static const List<List<dynamic>> strokeRoundedArrowDownDouble = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M17.9997 12.5C17.9997 12.5 13.5807 18.5 11.9996 18.5C10.4185 18.5 5.99966 12.5 5.99966 12.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M17.9997 5.50005C17.9997 5.50005 13.5807 11.5 11.9996 11.5C10.4185 11.5 5.99966 5.5 5.99966 5.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowDownDouble' icon.
  static const List<List<dynamic>> arrowDownDouble =
      strokeRoundedArrowDownDouble;

  /// JSON structure for the 'strokeRoundedArrowDownLeft01' icon.
  static const List<List<dynamic>> strokeRoundedArrowDownLeft01 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M6.99979 17L17.9998 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M6.13111 11C6.13111 11 5.65621 16.6335 6.51113 17.4885C7.36604 18.3434 12.9996 17.8684 12.9996 17.8684',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowDownLeft01' icon.
  static const List<List<dynamic>> arrowDownLeft01 =
      strokeRoundedArrowDownLeft01;

  /// JSON structure for the 'strokeRoundedArrowDownLeft02' icon.
  static const List<List<dynamic>> strokeRoundedArrowDownLeft02 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M10.9999 13L17.9999 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M8.45901 17.9172L9.70078 17.8043C11.7127 17.6214 12.7186 17.53 12.9553 16.8761C13.1921 16.2223 12.4778 15.508 11.0493 14.0795L9.92046 12.9507C8.49198 11.5222 7.77774 10.8079 7.12388 11.0447C6.47002 11.2814 6.37857 12.2873 6.19567 14.2992L6.08278 15.541C5.97266 16.7523 5.9176 17.358 6.27979 17.7202C6.64198 18.0824 7.24766 18.0273 8.45901 17.9172Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowDownLeft02' icon.
  static const List<List<dynamic>> arrowDownLeft02 =
      strokeRoundedArrowDownLeft02;

  /// JSON structure for the 'strokeRoundedArrowDownRight01' icon.
  static const List<List<dynamic>> strokeRoundedArrowDownRight01 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M16.9999 17L5.99988 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M10.9999 17.8685C10.9999 17.8685 16.6335 18.3434 17.4884 17.4885C18.3433 16.6336 17.8684 11 17.8684 11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowDownRight01' icon.
  static const List<List<dynamic>> arrowDownRight01 =
      strokeRoundedArrowDownRight01;

  /// JSON structure for the 'strokeRoundedArrowDownRight02' icon.
  static const List<List<dynamic>> strokeRoundedArrowDownRight02 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M13 13L6 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M15.541 17.9172L14.2992 17.8043C12.2873 17.6214 11.2814 17.53 11.0447 16.8761C10.8079 16.2223 11.5222 15.508 12.9507 14.0795L14.0795 12.9507C15.508 11.5222 16.2223 10.8079 16.8761 11.0447C17.53 11.2814 17.6214 12.2873 17.8043 14.2992L17.9172 15.541C18.0273 16.7523 18.0824 17.358 17.7202 17.7202C17.358 18.0824 16.7523 18.0273 15.541 17.9172Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowDownRight02' icon.
  static const List<List<dynamic>> arrowDownRight02 =
      strokeRoundedArrowDownRight02;

  /// JSON structure for the 'strokeRoundedArrowExpand' icon.
  static const List<List<dynamic>> strokeRoundedArrowExpand = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M8.00001 3.09779C8.00001 3.09779 4.03375 2.74194 3.38784 3.38785C2.74192 4.03375 3.09784 8 3.09784 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M8.00001 20.9022C8.00001 20.9022 4.03375 21.2581 3.38784 20.6122C2.74192 19.9662 3.09784 16 3.09784 16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M16 3.09779C16 3.09779 19.9663 2.74194 20.6122 3.38785C21.2581 4.03375 20.9022 8 20.9022 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M16 20.9022C16 20.9022 19.9663 21.2581 20.6122 20.6122C21.2581 19.9662 20.9022 16 20.9022 16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M14.0108 9.99847L20.0625 3.94678',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M9.99696 14.0024L3.63966 20.3807',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd': 'M9.99733 10.0024L3.84571 3.85889',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '7',
        'd': 'M13.9795 14.0024L20.5279 20.4983',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowExpand' icon.
  static const List<List<dynamic>> arrowExpand = strokeRoundedArrowExpand;

  /// JSON structure for the 'strokeRoundedArrowExpand01' icon.
  static const List<List<dynamic>> strokeRoundedArrowExpand01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M16.4999 3.26621C17.3443 3.25421 20.1408 2.67328 20.7337 3.26621C21.3266 3.85913 20.7457 6.65559 20.7337 7.5M20.5059 3.49097L13.5021 10.4961',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M3.26637 16.5001C3.25437 17.3445 2.67344 20.141 3.26637 20.7339C3.85929 21.3268 6.65575 20.7459 7.50016 20.7339M10.502 13.4976L3.49825 20.5027',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowExpand01' icon.
  static const List<List<dynamic>> arrowExpand01 = strokeRoundedArrowExpand01;

  /// JSON structure for the 'strokeRoundedArrowExpand02' icon.
  static const List<List<dynamic>> strokeRoundedArrowExpand02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M7.5 3.26621C6.6556 3.25421 3.8591 2.67328 3.2662 3.26621C2.6733 3.85913 3.2542 6.65559 3.2662 7.5M3.49401 3.49097L10.4978 10.4961M20.7338 16.5C20.7458 17.3444 21.3267 20.1409 20.7338 20.7338C20.1409 21.3267 17.3444 20.7458 16.5 20.7338M13.4981 13.4974L20.5019 20.5026',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowExpand02' icon.
  static const List<List<dynamic>> arrowExpand02 = strokeRoundedArrowExpand02;

  /// JSON structure for the 'strokeRoundedArrowExpandDiagonal01' icon.
  static const List<List<dynamic>> strokeRoundedArrowExpandDiagonal01 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M8 8L16 16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M17 3.23663C17.7506 3.22596 20.2363 2.70959 20.7634 3.23663C21.2904 3.76367 20.774 6.24941 20.7634 7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M3.23663 17C3.22596 17.7506 2.70959 20.2363 3.23663 20.7634C3.76367 21.2904 6.24941 20.774 7 20.7634',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M14.9981 9.00737L20.3838 3.62158',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M3.62598 20.3741L9.01172 14.9883',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowExpandDiagonal01' icon.
  static const List<List<dynamic>> arrowExpandDiagonal01 =
      strokeRoundedArrowExpandDiagonal01;

  /// JSON structure for the 'strokeRoundedArrowExpandDiagonal02' icon.
  static const List<List<dynamic>> strokeRoundedArrowExpandDiagonal02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M16 8L7.99999 16M6.99999 3.23663C6.24939 3.22596 3.7637 2.70959 3.2366 3.23663C2.7096 3.76367 3.226 6.24941 3.2366 7M20.7634 17C20.774 17.7506 21.2904 20.2363 20.7634 20.7634C20.2363 21.2904 17.7506 20.774 17 20.7634M9.00256 9.00714L3.61682 3.62135M20.374 20.374L14.9883 14.9882',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowExpandDiagonal02' icon.
  static const List<List<dynamic>> arrowExpandDiagonal02 =
      strokeRoundedArrowExpandDiagonal02;

  /// JSON structure for the 'strokeRoundedArrowHorizontal' icon.
  static const List<List<dynamic>> strokeRoundedArrowHorizontal = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5 9C4.39316 9.58984 2 11.1597 2 12C2 12.8403 4.39316 14.4102 5 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M19 9C19.6068 9.58984 22 11.1597 22 12C22 12.8403 19.6068 14.4102 19 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M2.42285 11.9795H21.868',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowHorizontal' icon.
  static const List<List<dynamic>> arrowHorizontal =
      strokeRoundedArrowHorizontal;

  /// JSON structure for the 'strokeRoundedArrowLeft01' icon.
  static const List<List<dynamic>> strokeRoundedArrowLeft01 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M15 6C15 6 9.00001 10.4189 9 12C8.99999 13.5812 15 18 15 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowLeft01' icon.
  static const List<List<dynamic>> arrowLeft01 = strokeRoundedArrowLeft01;

  /// JSON structure for the 'strokeRoundedArrowLeft02' icon.
  static const List<List<dynamic>> strokeRoundedArrowLeft02 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M3.99982 11.9998L19.9998 11.9998',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M8.99963 17C8.99963 17 3.99968 13.3176 3.99966 12C3.99965 10.6824 8.99966 7 8.99966 7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowLeft02' icon.
  static const List<List<dynamic>> arrowLeft02 = strokeRoundedArrowLeft02;

  /// JSON structure for the 'strokeRoundedArrowLeft03' icon.
  static const List<List<dynamic>> strokeRoundedArrowLeft03 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M4 6L4 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M8.00012 12.0005L20.0001 12.0005',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 8C12 8 8.00001 10.946 8 12C7.99999 13.0541 12 16 12 16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowLeft03' icon.
  static const List<List<dynamic>> arrowLeft03 = strokeRoundedArrowLeft03;

  /// JSON structure for the 'strokeRoundedArrowLeft04' icon.
  static const List<List<dynamic>> strokeRoundedArrowLeft04 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M10 12L20 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M5.41418 13.6026L6.38061 14.3639C7.94641 15.5974 8.72931 16.2141 9.36467 15.9328C10 15.6515 10 14.6881 10 12.7613V11.2387C10 9.31191 10 8.34853 9.36467 8.06721C8.72931 7.7859 7.94641 8.40264 6.38062 9.63612L5.41418 10.3974C4.47141 11.1401 4.00003 11.5115 4.00003 12C4.00003 12.4885 4.47141 12.8599 5.41418 13.6026Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowLeft04' icon.
  static const List<List<dynamic>> arrowLeft04 = strokeRoundedArrowLeft04;

  /// JSON structure for the 'strokeRoundedArrowLeft05' icon.
  static const List<List<dynamic>> strokeRoundedArrowLeft05 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M4.00002 5.99951L4.00005 18.0002',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12.4968 12.0109V12.3814C12.5374 15.3525 12.4024 16.3847 11.1519 15.9055L10.8438 15.7236L10.5952 15.5508L10.06 15.1378L9.0596 14.2685L8.03672 13.4047L7.53672 12.9516L7.31406 12.7251L7.05189 12.346L6.99807 12.0097L7.05189 11.6757L7.31406 11.2967L7.53672 11.0701L8.03672 10.617L9.0596 9.75323L10.06 8.8839L10.5952 8.47091L10.8438 8.29813L11.1519 8.11621C12.4024 7.63699 12.5374 8.66922 12.4968 11.6403V12.0109ZM12.4968 12.0109H19.9998',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowLeft05' icon.
  static const List<List<dynamic>> arrowLeft05 = strokeRoundedArrowLeft05;

  /// JSON structure for the 'strokeRoundedArrowLeftDouble' icon.
  static const List<List<dynamic>> strokeRoundedArrowLeftDouble = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M11.5 18C11.5 18 5.50001 13.5811 5.5 12C5.49999 10.4188 11.5 6 11.5 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M18.5 18C18.5 18 12.5 13.5811 12.5 12C12.5 10.4188 18.5 6 18.5 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowLeftDouble' icon.
  static const List<List<dynamic>> arrowLeftDouble =
      strokeRoundedArrowLeftDouble;

  /// JSON structure for the 'strokeRoundedArrowLeftRight' icon.
  static const List<List<dynamic>> strokeRoundedArrowLeftRight = [
    [
      'path',
      {
        'key': '0',
        'd': 'M19.9999 17L3.99994 17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M17 14C17 14 19.9999 16.2095 19.9999 17C19.9999 17.7906 16.9999 20 16.9999 20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M4.99994 7L19.9999 7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M6.99991 4C6.99991 4 3.99994 6.20947 3.99994 7.00002C3.99993 7.79058 6.99994 10 6.99994 10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowLeftRight' icon.
  static const List<List<dynamic>> arrowLeftRight = strokeRoundedArrowLeftRight;

  /// JSON structure for the 'strokeRoundedArrowMoveDownLeft' icon.
  static const List<List<dynamic>> strokeRoundedArrowMoveDownLeft = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M20 3V5.07692C20 7.07786 20 8.07833 19.8547 8.91545C19.0547 13.5235 15.0934 17.1376 10.0426 17.8674C9.12509 18 7.19318 18 5 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M7 21C6.39316 20.4102 4 18.8403 4 18C4 17.1597 6.39316 15.5898 7 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowMoveDownLeft' icon.
  static const List<List<dynamic>> arrowMoveDownLeft =
      strokeRoundedArrowMoveDownLeft;

  /// JSON structure for the 'strokeRoundedArrowMoveDownRight' icon.
  static const List<List<dynamic>> strokeRoundedArrowMoveDownRight = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4 3V5.07692C4 7.07786 4 8.07833 4.14533 8.91545C4.94529 13.5235 8.90656 17.1376 13.9574 17.8674C14.8749 18 16.8068 18 19 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M17 21C17.6068 20.4102 20 18.8403 20 18C20 17.1597 17.6068 15.5898 17 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowMoveDownRight' icon.
  static const List<List<dynamic>> arrowMoveDownRight =
      strokeRoundedArrowMoveDownRight;

  /// JSON structure for the 'strokeRoundedArrowMoveLeftDown' icon.
  static const List<List<dynamic>> strokeRoundedArrowMoveLeftDown = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3 5H4C10.5997 5 13.8995 5 15.9497 7.12067C18 9.24133 18 12.6545 18 19.4808V21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M6 2C5.39316 2.58984 3 4.15973 3 5C3 5.84027 5.39316 7.41016 6 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M15 19C15.5898 19.6068 17.1597 22 18 22C18.8403 22 20.4102 19.6068 21 19',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowMoveLeftDown' icon.
  static const List<List<dynamic>> arrowMoveLeftDown =
      strokeRoundedArrowMoveLeftDown;

  /// JSON structure for the 'strokeRoundedArrowMoveRightDown' icon.
  static const List<List<dynamic>> strokeRoundedArrowMoveRightDown = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M20 5H19.0667C12.907 5 9.82714 5 7.91357 7.12067C6 9.24133 6 12.6545 6 19.4808V21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18 2C18.6068 2.58984 21 4.15973 21 5C21 5.84027 18.6068 7.41016 18 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M9 19C8.41016 19.6068 6.84027 22 6 22C5.15973 22 3.58984 19.6068 3 19',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowMoveRightDown' icon.
  static const List<List<dynamic>> arrowMoveRightDown =
      strokeRoundedArrowMoveRightDown;

  /// JSON structure for the 'strokeRoundedArrowMoveUpLeft' icon.
  static const List<List<dynamic>> strokeRoundedArrowMoveUpLeft = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M20 21V18.9231C20 16.9221 20 15.9217 19.8547 15.0846C19.0547 10.4765 15.0934 6.86243 10.0426 6.13259C9.12509 6 7.19318 6 5 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M7 3C6.39316 3.58984 4 5.15973 4 6C4 6.84027 6.39316 8.41016 7 9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowMoveUpLeft' icon.
  static const List<List<dynamic>> arrowMoveUpLeft =
      strokeRoundedArrowMoveUpLeft;

  /// JSON structure for the 'strokeRoundedArrowMoveUpRight' icon.
  static const List<List<dynamic>> strokeRoundedArrowMoveUpRight = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4 21V18.9231C4 16.9221 4 15.9217 4.14533 15.0846C4.94529 10.4765 8.90656 6.86243 13.9574 6.13259C14.8749 6 16.8068 6 19 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M17 3C17.6068 3.58984 20 5.15973 20 6C20 6.84027 17.6068 8.41016 17 9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowMoveUpRight' icon.
  static const List<List<dynamic>> arrowMoveUpRight =
      strokeRoundedArrowMoveUpRight;

  /// JSON structure for the 'strokeRoundedArrowReloadHorizontal' icon.
  static const List<List<dynamic>> strokeRoundedArrowReloadHorizontal = [
    [
      'path',
      {
        'key': '0',
        'd': 'M20.5 5.5H9.5C5.78672 5.5 3 8.18503 3 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M3.5 18.5H14.5C18.2133 18.5 21 15.815 21 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M18.5 3C18.5 3 21 4.84122 21 5.50002C21 6.15882 18.5 8 18.5 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M5.49998 16C5.49998 16 3.00001 17.8412 3 18.5C2.99999 19.1588 5.5 21 5.5 21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowReloadHorizontal' icon.
  static const List<List<dynamic>> arrowReloadHorizontal =
      strokeRoundedArrowReloadHorizontal;

  /// JSON structure for the 'strokeRoundedArrowReloadVertical' icon.
  static const List<List<dynamic>> strokeRoundedArrowReloadVertical = [
    [
      'path',
      {
        'key': '0',
        'd': 'M5.5 3.5L5.5 14.5C5.5 18.2133 8.18503 21 12 21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M18.5 20.5L18.5 9.5C18.5 5.78672 15.815 3 12 3',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M21 18C21 18 19.1588 20.5 18.5 20.5C17.8412 20.5 16 18 16 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M8 5.50022C8 5.50022 6.15878 3.00025 5.49998 3.00024C4.84118 3.00024 3 5.50024 3 5.50024',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowReloadVertical' icon.
  static const List<List<dynamic>> arrowReloadVertical =
      strokeRoundedArrowReloadVertical;

  /// JSON structure for the 'strokeRoundedArrowRight01' icon.
  static const List<List<dynamic>> strokeRoundedArrowRight01 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M9.00005 6C9.00005 6 15 10.4189 15 12C15 13.5812 9 18 9 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowRight01' icon.
  static const List<List<dynamic>> arrowRight01 = strokeRoundedArrowRight01;

  /// JSON structure for the 'strokeRoundedArrowRight02' icon.
  static const List<List<dynamic>> strokeRoundedArrowRight02 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M20.0001 11.9998L4.00012 11.9998',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M15.0003 17C15.0003 17 20.0002 13.3176 20.0002 12C20.0002 10.6824 15.0002 7 15.0002 7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowRight02' icon.
  static const List<List<dynamic>> arrowRight02 = strokeRoundedArrowRight02;

  /// JSON structure for the 'strokeRoundedArrowRight03' icon.
  static const List<List<dynamic>> strokeRoundedArrowRight03 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M20.0001 18L20.0001 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M16.0001 11.9995L4.00012 11.9995',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M12.0002 8C12.0002 8 16.0001 10.946 16.0001 12C16.0001 13.0541 12.0001 16 12.0001 16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowRight03' icon.
  static const List<List<dynamic>> arrowRight03 = strokeRoundedArrowRight03;

  /// JSON structure for the 'strokeRoundedArrowRight04' icon.
  static const List<List<dynamic>> strokeRoundedArrowRight04 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M14 12L4 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18.5859 13.6026L17.6194 14.3639C16.0536 15.5974 15.2707 16.2141 14.6354 15.9328C14 15.6515 14 14.6881 14 12.7613L14 11.2387C14 9.31191 14 8.34853 14.6354 8.06721C15.2707 7.7859 16.0536 8.40264 17.6194 9.63612L18.5858 10.3974C19.5286 11.1401 20 11.5115 20 12C20 12.4885 19.5286 12.8599 18.5859 13.6026Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowRight04' icon.
  static const List<List<dynamic>> arrowRight04 = strokeRoundedArrowRight04;

  /// JSON structure for the 'strokeRoundedArrowRight05' icon.
  static const List<List<dynamic>> strokeRoundedArrowRight05 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M19.9999 6L19.9998 18.0007',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M11.5028 12.0113V12.3819C11.4622 15.353 11.5972 16.3852 12.8477 15.906L13.1558 15.7241L13.4044 15.5513L13.9396 15.1383L14.94 14.269L15.9629 13.4052L16.4629 12.9521L16.6855 12.7255L16.9477 12.3465L17.0015 12.0102L16.9477 11.6762L16.6855 11.2971L16.4629 11.0706L15.9629 10.6175L14.94 9.75372L13.9396 8.88439L13.4044 8.4714L13.1558 8.29862L12.8477 8.1167C11.5972 7.63748 11.4622 8.66971 11.5028 11.6408V12.0113ZM11.5028 12.0113H3.99983',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowRight05' icon.
  static const List<List<dynamic>> arrowRight05 = strokeRoundedArrowRight05;

  /// JSON structure for the 'strokeRoundedArrowRightDouble' icon.
  static const List<List<dynamic>> strokeRoundedArrowRightDouble = [
    [
      'path',
      {
        'key': '0',
        'd': 'M12.5 18C12.5 18 18.5 13.5811 18.5 12C18.5 10.4188 12.5 6 12.5 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M5.50005 18C5.50005 18 11.5 13.5811 11.5 12C11.5 10.4188 5.5 6 5.5 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowRightDouble' icon.
  static const List<List<dynamic>> arrowRightDouble =
      strokeRoundedArrowRightDouble;

  /// JSON structure for the 'strokeRoundedArrowShrink' icon.
  static const List<List<dynamic>> strokeRoundedArrowShrink = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M14.2297 17.9947C14.2192 17.2447 13.704 14.7612 14.2305 14.2347C14.7571 13.7083 17.2398 14.2247 17.9895 14.2355M20.9995 20.9981L14.6147 14.6146',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M9.76961 17.9944C9.78011 17.2445 10.2953 14.761 9.76881 14.2344C9.24228 13.708 6.75956 14.2245 6.00985 14.2352M2.99981 20.9978L9.38459 14.6144',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M6.00746 9.76133C6.75719 9.7709 9.24073 10.2832 9.76644 9.75585C10.2921 9.22853 9.77264 6.74581 9.76096 5.99592M9.37696 9.36743L3.00176 3.00244',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M17.9916 9.76133C17.2419 9.7709 14.7584 10.2832 14.2326 9.75585C13.707 9.22853 14.2264 6.74581 14.2381 5.99592M14.6221 9.36743L20.9973 3.00244',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowShrink' icon.
  static const List<List<dynamic>> arrowShrink = strokeRoundedArrowShrink;

  /// JSON structure for the 'strokeRoundedArrowShrink01' icon.
  static const List<List<dynamic>> strokeRoundedArrowShrink01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6.5023 10.7365C7.34671 10.7485 10.1432 11.3294 10.7361 10.7365C11.329 10.1436 10.7481 7.34708 10.7361 6.50267M13.2685 17.5027C13.2565 16.6583 12.6756 13.8618 13.2685 13.2689C13.8614 12.676 16.6579 13.2569 17.5023 13.2689M20.9991 21.001L13.6102 13.6188M10.3691 10.3763L2.99997 2.99902',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowShrink01' icon.
  static const List<List<dynamic>> arrowShrink01 = strokeRoundedArrowShrink01;

  /// JSON structure for the 'strokeRoundedArrowShrink02' icon.
  static const List<List<dynamic>> strokeRoundedArrowShrink02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6.50232 13.2635C7.34673 13.2515 10.1432 12.6706 10.7361 13.2635C11.329 13.8564 10.7481 16.6529 10.7361 17.4973M13.2685 6.49733C13.2565 7.34173 12.6756 10.1382 13.2685 10.7311C13.8614 11.324 16.6579 10.7431 17.5023 10.7311M20.9991 2.99902L13.6103 10.3812M10.3691 13.6237L3 21.001',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowShrink02' icon.
  static const List<List<dynamic>> arrowShrink02 = strokeRoundedArrowShrink02;

  /// JSON structure for the 'strokeRoundedArrowTurnBackward' icon.
  static const List<List<dynamic>> strokeRoundedArrowTurnBackward = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M11 6H15.5C17.9853 6 20 8.01472 20 10.5C20 12.9853 17.9853 15 15.5 15H4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M6.99998 12C6.99998 12 4.00001 14.2095 4 15C3.99999 15.7906 7 18 7 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowTurnBackward' icon.
  static const List<List<dynamic>> arrowTurnBackward =
      strokeRoundedArrowTurnBackward;

  /// JSON structure for the 'strokeRoundedArrowTurnDown' icon.
  static const List<List<dynamic>> strokeRoundedArrowTurnDown = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5.99994 13L5.99994 8.5C5.99994 6.01472 8.01466 4 10.4999 4C12.9852 4 14.9999 6.01472 14.9999 8.5V20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M11.9999 17C11.9999 17 14.2093 20 14.9999 20C15.7905 20 17.9999 17 17.9999 17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowTurnDown' icon.
  static const List<List<dynamic>> arrowTurnDown = strokeRoundedArrowTurnDown;

  /// JSON structure for the 'strokeRoundedArrowTurnForward' icon.
  static const List<List<dynamic>> strokeRoundedArrowTurnForward = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M13 6H8.5C6.01472 6 4 8.01472 4 10.5C4 12.9853 6.01472 15 8.5 15H20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M17 12C17 12 20 14.2095 20 15C20 15.7906 17 18 17 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowTurnForward' icon.
  static const List<List<dynamic>> arrowTurnForward =
      strokeRoundedArrowTurnForward;

  /// JSON structure for the 'strokeRoundedArrowTurnUp' icon.
  static const List<List<dynamic>> strokeRoundedArrowTurnUp = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6 11L6 15.5C6 17.9853 8.01472 20 10.5 20C12.9853 20 15 17.9853 15 15.5V4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18 6.99998C18 6.99998 15.7905 4.00001 15 4C14.2094 3.99999 12 7 12 7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowTurnUp' icon.
  static const List<List<dynamic>> arrowTurnUp = strokeRoundedArrowTurnUp;

  /// JSON structure for the 'strokeRoundedArrowUp01' icon.
  static const List<List<dynamic>> strokeRoundedArrowUp01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M17.9998 15C17.9998 15 13.5809 9.00001 11.9998 9C10.4187 8.99999 5.99985 15 5.99985 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowUp01' icon.
  static const List<List<dynamic>> arrowUp01 = strokeRoundedArrowUp01;

  /// JSON structure for the 'strokeRoundedArrowUp02' icon.
  static const List<List<dynamic>> strokeRoundedArrowUp02 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M12 4L12 20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M16.9998 8.99996C16.9998 8.99996 13.3174 4.00001 11.9998 4C10.6822 3.99999 6.99982 9 6.99982 9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowUp02' icon.
  static const List<List<dynamic>> arrowUp02 = strokeRoundedArrowUp02;

  /// JSON structure for the 'strokeRoundedArrowUp03' icon.
  static const List<List<dynamic>> strokeRoundedArrowUp03 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M18 4L5.99997 4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M12 8V20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M15.9999 12C15.9999 12 13.054 8.00001 11.9999 8C10.9458 7.99999 7.99994 12 7.99994 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowUp03' icon.
  static const List<List<dynamic>> arrowUp03 = strokeRoundedArrowUp03;

  /// JSON structure for the 'strokeRoundedArrowUp04' icon.
  static const List<List<dynamic>> strokeRoundedArrowUp04 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M12 10L12 20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M13.6026 5.41415L14.3639 6.38058C15.5974 7.94638 16.2141 8.72928 15.9328 9.36464C15.6515 10 14.6881 10 12.7613 10H11.2387C9.31191 10 8.34853 10 8.06721 9.36464C7.7859 8.72928 8.40264 7.94638 9.63612 6.38059L10.3974 5.41415C11.1401 4.47138 11.5115 4 12 4C12.4885 4 12.8599 4.47138 13.6026 5.41415Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowUp04' icon.
  static const List<List<dynamic>> arrowUp04 = strokeRoundedArrowUp04;

  /// JSON structure for the 'strokeRoundedArrowUp05' icon.
  static const List<List<dynamic>> strokeRoundedArrowUp05 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M6.00108 4.0127L17.9986 4.01272',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M11.9957 12.5105L12.3663 12.5081C15.3383 12.5289 16.3698 12.3871 15.8822 11.1398L15.6982 10.833L15.5237 10.5855L15.1071 10.0531L14.2309 9.05859L13.3602 8.04151L12.9037 7.54456L12.6756 7.32342L12.2948 7.06379L11.9581 7.01221L11.6243 7.06825L11.2469 7.33292L11.0218 7.55707L10.5719 8.06005L9.71483 9.08861L8.85198 10.0947L8.44248 10.6326L8.27132 10.8824L8.09141 11.1916C7.62041 12.4453 8.65374 12.5733 11.6252 12.513L11.9957 12.5105ZM11.9957 12.5105L12.0456 20.013',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowUp05' icon.
  static const List<List<dynamic>> arrowUp05 = strokeRoundedArrowUp05;

  /// JSON structure for the 'strokeRoundedArrowUpDouble' icon.
  static const List<List<dynamic>> strokeRoundedArrowUpDouble = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M18 11.5C18 11.5 13.5811 5.50001 12 5.5C10.4188 5.49999 6 11.5 6 11.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M18 18.5C18 18.5 13.5811 12.5 12 12.5C10.4188 12.5 6 18.5 6 18.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowUpDouble' icon.
  static const List<List<dynamic>> arrowUpDouble = strokeRoundedArrowUpDouble;

  /// JSON structure for the 'strokeRoundedArrowUpDown' icon.
  static const List<List<dynamic>> strokeRoundedArrowUpDown = [
    [
      'path',
      {
        'key': '0',
        'd': 'M7 4V20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M17 19L17 4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M10 6.99998C10 6.99998 7.79053 4.00001 6.99998 4C6.20942 3.99999 4 7 4 7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M20 17C20 17 17.7905 20 17 20C16.2094 20 14 17 14 17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowUpDown' icon.
  static const List<List<dynamic>> arrowUpDown = strokeRoundedArrowUpDown;

  /// JSON structure for the 'strokeRoundedArrowUpLeft01' icon.
  static const List<List<dynamic>> strokeRoundedArrowUpLeft01 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M6.99994 7L17.9999 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12.9999 6.13151C12.9999 6.13151 7.36639 5.65662 6.51147 6.51153C5.65655 7.36645 6.13151 13 6.13151 13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowUpLeft01' icon.
  static const List<List<dynamic>> arrowUpLeft01 = strokeRoundedArrowUpLeft01;

  /// JSON structure for the 'strokeRoundedArrowUpLeft02' icon.
  static const List<List<dynamic>> strokeRoundedArrowUpLeft02 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M11 11L18 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M8.45901 6.08278L9.70078 6.19567C11.7127 6.37857 12.7186 6.47002 12.9553 7.12388C13.1921 7.77774 12.4778 8.49198 11.0493 9.92046L9.92046 11.0493C8.49198 12.4778 7.77774 13.1921 7.12388 12.9553C6.47002 12.7186 6.37857 11.7127 6.19567 9.70078L6.08278 8.45902C5.97266 7.24766 5.9176 6.64198 6.27979 6.27979C6.64198 5.9176 7.24766 5.97266 8.45901 6.08278Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowUpLeft02' icon.
  static const List<List<dynamic>> arrowUpLeft02 = strokeRoundedArrowUpLeft02;

  /// JSON structure for the 'strokeRoundedArrowUpRight01' icon.
  static const List<List<dynamic>> strokeRoundedArrowUpRight01 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M17 7L6 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M11 6.13151C11 6.13151 16.6335 5.65662 17.4885 6.51153C18.3434 7.36645 17.8684 13 17.8684 13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowUpRight01' icon.
  static const List<List<dynamic>> arrowUpRight01 = strokeRoundedArrowUpRight01;

  /// JSON structure for the 'strokeRoundedArrowUpRight02' icon.
  static const List<List<dynamic>> strokeRoundedArrowUpRight02 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M12.9997 11L5.99969 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M15.5407 6.08278L14.2989 6.19567C12.287 6.37857 11.2811 6.47002 11.0444 7.12388C10.8076 7.77774 11.5219 8.49198 12.9504 9.92046L14.0792 11.0493C15.5077 12.4778 16.222 13.1921 16.8758 12.9553C17.5297 12.7186 17.6211 11.7127 17.804 9.70078L17.9169 8.45902C18.027 7.24766 18.0821 6.64198 17.7199 6.27979C17.3577 5.9176 16.752 5.97266 15.5407 6.08278Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowUpRight02' icon.
  static const List<List<dynamic>> arrowUpRight02 = strokeRoundedArrowUpRight02;

  /// JSON structure for the 'strokeRoundedArrowUpRight03' icon.
  static const List<List<dynamic>> strokeRoundedArrowUpRight03 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M16.5 7.5L6 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M8 6.18791C8 6.18791 16.0479 5.50949 17.2692 6.73079C18.4906 7.95209 17.812 16 17.812 16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowUpRight03' icon.
  static const List<List<dynamic>> arrowUpRight03 = strokeRoundedArrowUpRight03;

  /// JSON structure for the 'strokeRoundedArrowVertical' icon.
  static const List<List<dynamic>> strokeRoundedArrowVertical = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M9 5C9.58984 4.39316 11.1597 2 12 2C12.8403 2 14.4102 4.39316 15 5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M9 19C9.58984 19.6068 11.1597 22 12 22C12.8403 22 14.4102 19.6068 15 19',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 2.23145V21.769',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArrowVertical' icon.
  static const List<List<dynamic>> arrowVertical = strokeRoundedArrowVertical;

  /// JSON structure for the 'strokeRoundedArtboard' icon.
  static const List<List<dynamic>> strokeRoundedArtboard = [
    [
      'path',
      {
        'key': '0',
        'd': 'M8 4.5V3M16 4.5V3',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M19.5 8L21 8M19.5 16H21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M8 21V19.5M16 21V19.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M3 8L4.5 8M3 16H4.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M8 11C8 9.58579 8 8.87868 8.43934 8.43934C8.87868 8 9.58579 8 11 8H13C14.4142 8 15.1213 8 15.5607 8.43934C16 8.87868 16 9.58579 16 11V13C16 14.4142 16 15.1213 15.5607 15.5607C15.1213 16 14.4142 16 13 16H11C9.58579 16 8.87868 16 8.43934 15.5607C8 15.1213 8 14.4142 8 13V11Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArtboard' icon.
  static const List<List<dynamic>> artboard = strokeRoundedArtboard;

  /// JSON structure for the 'strokeRoundedArtboardTool' icon.
  static const List<List<dynamic>> strokeRoundedArtboardTool = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M9 7H15C18.2998 7 19.9497 7 20.9749 8.02513C22 9.05025 22 10.7002 22 14V15C22 18.2998 22 19.9497 20.9749 20.9749C19.9497 22 18.2998 22 15 22H14C10.7002 22 9.05025 22 8.02513 20.9749C7 19.9497 7 18.2998 7 15V9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M2 7L5 7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M7 5L7 2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArtboardTool' icon.
  static const List<List<dynamic>> artboardTool = strokeRoundedArtboardTool;

  /// JSON structure for the 'strokeRoundedArtificialIntelligence01' icon.
  static const List<List<dynamic>> strokeRoundedArtificialIntelligence01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M16 21.9995V21.4995C16 20.395 16.9321 19.5 17.9223 19.0106C18.8846 18.5349 19.6943 17.7507 19.7965 16.8308L20 14.9995L22 13.9995L19.5 10.2495C19.5 5.94601 16.2049 2.41209 12 2.03317M6.5 16.9957V21.9995M6.5 16.9957C5.46656 16.2668 4.60808 15.3063 4 14.1898M6.5 16.9957C7.25065 17.5253 8.09362 17.9326 9 18.189',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M8 4H6C5.05719 4 4.58579 4 4.29289 4.29289C4 4.58579 4 5.05719 4 6V8C4 8.94281 4 9.41421 4.29289 9.70711C4.58579 10 5.05719 10 6 10H8C8.94281 10 9.41421 10 9.70711 9.70711C10 9.41421 10 8.94281 10 8V6C10 5.05719 10 4.58579 9.70711 4.29289C9.41421 4 8.94281 4 8 4Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M5.5 9.99997V12M8.5 9.99997V12M5.5 1.99997V3.99997M8.5 1.99997V3.99997M4 5.49997H2M4 8.49997H2M12 5.49997H10M12 8.49997H10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArtificialIntelligence01' icon.
  static const List<List<dynamic>> artificialIntelligence01 =
      strokeRoundedArtificialIntelligence01;

  /// JSON structure for the 'strokeRoundedArtificialIntelligence02' icon.
  static const List<List<dynamic>> strokeRoundedArtificialIntelligence02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M15.5 22V21.5C15.5 20.3954 16.4321 19.5005 17.4223 19.011C18.3846 18.5354 19.1943 17.7511 19.2965 16.8313L19.5 15L21.5 14L19 10.25C19 5.69365 15.3063 2 10.75 2C6.19365 2 2.5 5.69365 2.5 10.25C2.5 13.0379 3.88283 15.5028 6 16.9962M6 16.9962V22M6 16.9962C6.75065 17.5257 7.59362 17.9331 8.5 18.1895',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M11.3077 12L9.84703 7.47891C9.7552 7.19466 9.47344 7 9.15385 7C8.83425 7 8.55249 7.19466 8.46066 7.47891L7 12M14 7V12M7.53846 10.5H10.7692',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArtificialIntelligence02' icon.
  static const List<List<dynamic>> artificialIntelligence02 =
      strokeRoundedArtificialIntelligence02;

  /// JSON structure for the 'strokeRoundedArtificialIntelligence03' icon.
  static const List<List<dynamic>> strokeRoundedArtificialIntelligence03 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M16 22V21.5C16 20.3954 16.9321 19.5005 17.9223 19.011C18.8846 18.5354 19.6943 17.7511 19.7965 16.8313L20 15L22 14L19.5 10.25C19.5 5.69365 15.8063 2 11.25 2C10.096 2 8.99733 2.23694 8 2.66482M6.5 16.9962V22M6.5 16.9962C5.13927 16.0364 4.08188 14.6752 3.5 13.085M6.5 16.9962C7.25065 17.5257 8.09362 17.9331 9 18.1895',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M2.75 3.25L6 5.5H10M3.5 3.25C3.5 3.66421 3.16421 4 2.75 4C2.33579 4 2 3.66421 2 3.25C2 2.83579 2.33579 2.5 2.75 2.5C3.16421 2.5 3.5 2.83579 3.5 3.25Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M2.75 8.75H10M3.5 8.75C3.5 9.16421 3.16421 9.5 2.75 9.5C2.33579 9.5 2 9.16421 2 8.75C2 8.33579 2.33579 8 2.75 8C3.16421 8 3.5 8.33579 3.5 8.75Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArtificialIntelligence03' icon.
  static const List<List<dynamic>> artificialIntelligence03 =
      strokeRoundedArtificialIntelligence03;

  /// JSON structure for the 'strokeRoundedArtificialIntelligence04' icon.
  static const List<List<dynamic>> strokeRoundedArtificialIntelligence04 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4 12C4 8.22876 4 6.34315 5.17157 5.17157C6.34315 4 8.22876 4 12 4C15.7712 4 17.6569 4 18.8284 5.17157C20 6.34315 20 8.22876 20 12C20 15.7712 20 17.6569 18.8284 18.8284C17.6569 20 15.7712 20 12 20C8.22876 20 6.34315 20 5.17157 18.8284C4 17.6569 4 15.7712 4 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M7.5 15L9.34189 9.47434C9.43631 9.19107 9.7014 9 10 9C10.2986 9 10.5637 9.19107 10.6581 9.47434L12.5 15M8.5 13H11.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M15.5 9V15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M8 2V4M16 2V4M12 2V4M8 20V22M12 20V22M16 20V22M22 16H20M4 8H2M4 16H2M4 12H2M22 8H20M22 12H20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArtificialIntelligence04' icon.
  static const List<List<dynamic>> artificialIntelligence04 =
      strokeRoundedArtificialIntelligence04;

  /// JSON structure for the 'strokeRoundedArtificialIntelligence05' icon.
  static const List<List<dynamic>> strokeRoundedArtificialIntelligence05 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M21.255 7.13359L20.7614 6.27699C20.3881 5.62916 20.2015 5.30525 19.8839 5.17608C19.1739 4.88734 17.9756 5.49725 17.2686 5.69638C16.6419 5.84091 16.1039 5.63881 15.5732 5.33262C15.2141 5.10263 14.9379 4.76353 14.785 4.36494C14.5708 3.72506 14.427 2.59797 13.8603 2.18877C13.599 2.00001 13.2518 2.00001 12.5574 2.00001H11.4426C10.7483 2.00001 10.4011 2.00001 10.1397 2.18877C9.57309 2.598 9.42928 3.72508 9.21503 4.36494C9.00249 4.91906 8.58201 5.24311 8.08999 5.52699C7.67124 5.74214 7.19009 5.80214 6.73148 5.69638C6.02454 5.49725 4.82615 4.88733 4.11617 5.17608C3.79859 5.30525 3.61195 5.62916 3.23865 6.27699L2.74507 7.13359C2.39516 7.74084 2.2202 8.04447 2.25416 8.36769C2.33849 9.1706 3.50758 10.0501 4.0218 10.625C4.2738 10.944 4.45271 11.5 4.45271 11.9999C4.45271 12.5 4.27386 13.0558 4.02183 13.3749C3.50757 13.9498 2.3385 14.8293 2.25416 15.6323C2.2202 15.9555 2.39516 16.2591 2.74507 16.8663L3.23864 17.7229C3.61193 18.3707 3.79859 18.6947 4.11617 18.8238C4.8261 19.1126 6.02453 18.5026 6.73144 18.3035C7.71336 18.077 8.85351 18.6924 9.215 19.635C9.42926 20.2749 9.57308 21.402 10.1397 21.8113C10.4011 22 10.7483 22 11.4426 22H12.5574C13.2518 22 13.599 22 13.8603 21.8113C14.1217 21.6225 14.2315 21.2925 14.4511 20.6325C14.6985 19.8935 14.8719 19.1165 15.5731 18.6674C16.1038 18.3611 16.6418 18.1589 17.2686 18.3035C17.9755 18.5026 19.1739 19.1126 19.8839 18.8238C20.2015 18.6947 20.3881 18.3707 20.7614 17.7229L21.255 16.8663C21.6049 16.2591 21.7798 15.9555 21.7459 15.6323C21.6614 14.8293 20.4925 13.9499 19.9782 13.3749C19.3955 12.6371 19.3956 11.3628 19.9782 10.625C20.4925 10.0501 21.6614 9.17068 21.7459 8.36769C21.7798 8.04447 21.6049 7.74084 21.255 7.13359Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M7.4375 14.9922L9.27939 9.46653C9.37381 9.18326 9.6389 8.99219 9.9375 8.99219C10.2361 8.99219 10.5012 9.18326 10.5956 9.46653L12.4375 14.9922M8.4375 12.9922H11.4375',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M15.4375 8.99219V14.9922',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArtificialIntelligence05' icon.
  static const List<List<dynamic>> artificialIntelligence05 =
      strokeRoundedArtificialIntelligence05;

  /// JSON structure for the 'strokeRoundedArtificialIntelligence06' icon.
  static const List<List<dynamic>> strokeRoundedArtificialIntelligence06 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M7.5 14.5L9.34189 8.97434C9.43631 8.69107 9.7014 8.5 10 8.5C10.2986 8.5 10.5637 8.69107 10.6581 8.97434L12.5 14.5M15.5 8.5V14.5M8.5 12.5H11.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M21.011 14.0965C21.5329 13.9558 21.7939 13.8854 21.8969 13.7508C22 13.6163 22 13.3998 22 12.9669V11.0332C22 10.6003 22 10.3838 21.8969 10.2493C21.7938 10.1147 21.5329 10.0443 21.011 9.90358C19.0606 9.37759 17.8399 7.33851 18.3433 5.40087C18.4817 4.86799 18.5509 4.60156 18.4848 4.44529C18.4187 4.28902 18.2291 4.18134 17.8497 3.96596L16.125 2.98673C15.7528 2.77539 15.5667 2.66972 15.3997 2.69222C15.2326 2.71472 15.0442 2.90273 14.6672 3.27873C13.208 4.73448 10.7936 4.73442 9.33434 3.27864C8.95743 2.90263 8.76898 2.71463 8.60193 2.69212C8.43489 2.66962 8.24877 2.77529 7.87653 2.98663L6.15184 3.96587C5.77253 4.18123 5.58287 4.28891 5.51678 4.44515C5.45068 4.6014 5.51987 4.86787 5.65825 5.4008C6.16137 7.3385 4.93972 9.37763 2.98902 9.9036C2.46712 10.0443 2.20617 10.1147 2.10308 10.2492C2 10.3838 2 10.6003 2 11.0332V12.9669C2 13.3998 2 13.6163 2.10308 13.7508C2.20615 13.8854 2.46711 13.9558 2.98902 14.0965C4.9394 14.6225 6.16008 16.6616 5.65672 18.5992C5.51829 19.1321 5.44907 19.3985 5.51516 19.5548C5.58126 19.7111 5.77092 19.8188 6.15025 20.0341L7.87495 21.0134C8.24721 21.2247 8.43334 21.3304 8.6004 21.3079C8.76746 21.2854 8.95588 21.0973 9.33271 20.7213C10.7927 19.2644 13.2088 19.2643 14.6689 20.7212C15.0457 21.0973 15.2341 21.2853 15.4012 21.3078C15.5682 21.3303 15.7544 21.2246 16.1266 21.0133L17.8513 20.034C18.2307 19.8187 18.4204 19.711 18.4864 19.5547C18.5525 19.3984 18.4833 19.132 18.3448 18.5991C17.8412 16.6616 19.0609 14.6226 21.011 14.0965Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArtificialIntelligence06' icon.
  static const List<List<dynamic>> artificialIntelligence06 =
      strokeRoundedArtificialIntelligence06;

  /// JSON structure for the 'strokeRoundedArtificialIntelligence07' icon.
  static const List<List<dynamic>> strokeRoundedArtificialIntelligence07 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12.9977 1.99994C12.2809 1.99994 11.4117 2.00008 11.1419 2.18891C10.8721 2.37774 10.7588 2.70788 10.5321 3.36815C10.2743 4.11438 10.0908 4.8889 9.37378 5.33396L9.02603 5.52841C8.14331 5.96794 7.24434 5.5943 6.36411 5.35403C5.90604 5.22806 5.46435 5.19031 5.19362 5.17985C5.02531 5.17336 4.87171 5.26428 4.78483 5.40859L3.14026 8.14044C3.05387 8.28394 3.04493 8.46113 3.12867 8.60619C3.25457 8.82431 3.4709 9.16117 3.76232 9.47524C4.45652 10.2274 5.27142 10.8941 5.27142 12.0037C5.27142 13.1136 4.45665 13.7802 3.76232 14.5324C3.47091 14.8465 3.25458 15.1834 3.12867 15.4015C3.04493 15.5466 3.05387 15.7238 3.14026 15.8673L4.78482 18.5991C4.8717 18.7434 5.02532 18.8343 5.19364 18.8278C5.46438 18.8174 5.90606 18.7796 6.36413 18.6536C7.24445 18.4133 8.14344 18.0397 9.02622 18.4793L9.37392 18.6738C10.0909 19.119 10.2743 19.8934 10.5321 20.6396C10.7588 21.2999 10.8721 21.63 11.1419 21.8188C11.4117 22.0077 12.2809 21.9999 12.9977 21.9999',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12.998 15.5C11.065 15.5 9.49805 13.933 9.49805 12C9.49805 10.067 11.065 8.49997 12.998 8.49997',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M20.248 4.74997L17.998 6.99997H15.998M19.498 4.74997C19.498 5.16418 19.8338 5.49997 20.248 5.49997C20.6622 5.49997 20.998 5.16418 20.998 4.74997C20.998 4.33576 20.6622 3.99997 20.248 3.99997C19.8338 3.99997 19.498 4.33576 19.498 4.74997Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M20.248 19.25L17.998 17H15.998M19.498 19.25C19.498 18.8358 19.8338 18.5 20.248 18.5C20.6622 18.5 20.998 18.8358 20.998 19.25C20.998 19.6642 20.6622 20 20.248 20C19.8338 20 19.498 19.6642 19.498 19.25Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M20.248 12H15.998M19.498 12C19.498 12.4142 19.8338 12.75 20.248 12.75C20.6622 12.75 20.998 12.4142 20.998 12C20.998 11.5858 20.6622 11.25 20.248 11.25C19.8338 11.25 19.498 11.5858 19.498 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArtificialIntelligence07' icon.
  static const List<List<dynamic>> artificialIntelligence07 =
      strokeRoundedArtificialIntelligence07;

  /// JSON structure for the 'strokeRoundedArtificialIntelligence08' icon.
  static const List<List<dynamic>> strokeRoundedArtificialIntelligence08 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M9.60059 6.11211C9.92247 5.29596 11.0775 5.29596 11.3994 6.11211L12.3103 8.4216C12.8999 9.91665 14.0833 11.1001 15.5784 11.6897L17.8879 12.6006C18.704 12.9225 18.704 14.0775 17.8879 14.3994L15.5784 15.3103C14.0833 15.8999 12.8999 17.0833 12.3103 18.5784L11.3994 20.8879C11.0775 21.704 9.92247 21.704 9.60059 20.8879L8.68974 18.5784C8.1001 17.0833 6.91665 15.8999 5.4216 15.3103L3.11211 14.3994C2.29596 14.0775 2.29596 12.9225 3.11211 12.6006L5.4216 11.6897C6.91665 11.1001 8.1001 9.91665 8.68974 8.4216L9.60059 6.11211Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18.1627 2.72954C18.2834 2.42349 18.7166 2.42349 18.8373 2.72954L19.1788 3.5956C19.4 4.15624 19.8438 4.60004 20.4044 4.82115L21.2705 5.16272C21.5765 5.28343 21.5765 5.71657 21.2705 5.83728L20.4044 6.17885C19.8438 6.39996 19.4 6.84376 19.1788 7.4044L18.8373 8.27046C18.7166 8.57651 18.2834 8.57651 18.1627 8.27046L17.8212 7.4044C17.6 6.84376 17.1562 6.39996 16.5956 6.17885L15.7295 5.83728C15.4235 5.71657 15.4235 5.28343 15.7295 5.16272L16.5956 4.82115C17.1562 4.60004 17.6 4.15624 17.8212 3.5956L18.1627 2.72954Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedArtificialIntelligence08' icon.
  static const List<List<dynamic>> artificialIntelligence08 =
      strokeRoundedArtificialIntelligence08;

  /// JSON structure for the 'strokeRoundedAspectRatio' icon.
  static const List<List<dynamic>> strokeRoundedAspectRatio = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2 12C2 7.75736 2 5.63604 3.17157 4.31802C4.34315 3 6.22876 3 10 3H14C17.7712 3 19.6569 3 20.8284 4.31802C22 5.63604 22 7.75736 22 12C22 16.2426 22 18.364 20.8284 19.682C19.6569 21 17.7712 21 14 21H10C6.22876 21 4.34315 21 3.17157 19.682C2 18.364 2 16.2426 2 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M2 9H10C12.8284 9 14.2426 9 15.1213 9.87868C16 10.7574 16 12.1716 16 15V21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M10 21L10 9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAspectRatio' icon.
  static const List<List<dynamic>> aspectRatio = strokeRoundedAspectRatio;

  /// JSON structure for the 'strokeRoundedAssignments' icon.
  static const List<List<dynamic>> strokeRoundedAssignments = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4 3H3C2.44772 3 2 3.44772 2 4V18L3.5 21L5 18V4C5 3.44772 4.55228 3 4 3Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M21 12.0013V8.00072C21 5.64336 21 4.46468 20.2678 3.73234C19.5355 3 18.357 3 16 3H13C10.643 3 9.46447 3 8.73223 3.73234C8 4.46468 8 5.64336 8 8.00072V16.0019C8 18.3592 8 19.5379 8.73223 20.2703C9.35264 20.8908 10.2934 20.9855 12 21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 7H17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M12 11H17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M14 19C14 19 15.5 19.5 16.5 21C16.5 21 18 17 22 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M2 7H5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAssignments' icon.
  static const List<List<dynamic>> assignments = strokeRoundedAssignments;

  /// JSON structure for the 'strokeRoundedAsterisk' icon.
  static const List<List<dynamic>> strokeRoundedAsterisk = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12 7.5V16.5M15.8971 9.75L8.10289 14.25M15.897 14.25L8.10275 9.75',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M6.47867 6.76926C2.20958 10.8137 1.22078 16.4342 4.27013 19.323C6.87609 21.7918 11.5879 21.4667 15.5675 18.7956L20 20.5L18.0841 16.6688C21.8721 12.6801 22.6403 7.43426 19.7299 4.67697C16.6805 1.78811 10.7478 2.72486 6.47867 6.76926Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAsterisk' icon.
  static const List<List<dynamic>> asterisk = strokeRoundedAsterisk;

  /// JSON structure for the 'strokeRoundedAsterisk02' icon.
  static const List<List<dynamic>> strokeRoundedAsterisk02 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M12.0001 4V20M19 8L5.00025 16M18.9997 16L5 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAsterisk02' icon.
  static const List<List<dynamic>> asterisk02 = strokeRoundedAsterisk02;

  /// JSON structure for the 'strokeRoundedAsteroid01' icon.
  static const List<List<dynamic>> strokeRoundedAsteroid01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.17739 12.9793L3.49456 8.58065C3.81646 7.50568 4.55249 6.61291 5.5315 6.10993L7.12731 5.29006C8.37528 4.6489 9.89325 5.10311 10.6111 6.33247L12.1043 8.88966C12.4728 9.52075 12.6571 9.8363 12.8935 9.99873C13.2261 10.2272 13.6436 10.2803 14.0199 10.142C14.2875 10.0437 14.5404 9.78383 15.0463 9.264C16.2378 8.03972 18.2215 8.24155 19.1562 9.68215L20.3273 11.4872C20.9791 12.4918 21.1687 13.7398 20.8459 14.9007L20.5037 16.1314C20.1952 17.2407 19.4479 18.1659 18.4437 18.6818L12.8309 21.5655C11.504 22.2472 9.91895 22.1195 8.71171 21.2334L3.67752 17.5386C2.27465 16.5089 1.67039 14.6724 2.17739 12.9793Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M15.9998 14H16.0088',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M11 15.5L9.5 17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M9 10.753C8.05719 10.1652 7.58579 9.87123 7.14645 10.0538C6.70711 10.2365 6.4714 10.8243 6 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M19.9559 2H18.2338C17.9628 2 17.8273 2 17.7012 2.01974C17.4003 2.06683 17.1242 2.19626 16.9126 2.38941C16.8239 2.47039 16.7487 2.56914 16.5984 2.76663C16.2751 3.19139 16.1134 3.40378 16.0517 3.60076C15.9024 4.07694 16.0828 4.58571 16.5138 4.90401C16.6921 5.03568 16.9627 5.13048 17.5038 5.32008L18.5185 5.67557C19.1652 5.90215 19.4886 6.01543 19.8119 5.99831C19.9487 5.99106 20.0837 5.96679 20.2128 5.92623C20.5177 5.83042 20.7639 5.61473 21.2564 5.18334L21.4013 5.05647C21.5737 4.90543 21.66 4.82991 21.7287 4.74608C21.8585 4.58767 21.9449 4.40513 21.9809 4.21269C22 4.11085 22 4.00405 22 3.79044C22 3.30232 22 3.05826 21.9242 2.86139C21.7799 2.48681 21.4442 2.19275 21.0166 2.06641C20.7918 2 20.5131 2 19.9559 2Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAsteroid01' icon.
  static const List<List<dynamic>> asteroid01 = strokeRoundedAsteroid01;

  /// JSON structure for the 'strokeRoundedAsteroid02' icon.
  static const List<List<dynamic>> strokeRoundedAsteroid02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M17 14.5C17 18.6421 13.6421 22 9.5 22C5.35786 22 2 18.6421 2 14.5C2 10.3579 5.35786 7 9.5 7C13.6421 7 17 10.3579 17 14.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M7 13L14.5 5.50003M18 2L16.5 3.5M22 6.00003L19 9M11 16L14 13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAsteroid02' icon.
  static const List<List<dynamic>> asteroid02 = strokeRoundedAsteroid02;

  /// JSON structure for the 'strokeRoundedAstronaut01' icon.
  static const List<List<dynamic>> strokeRoundedAstronaut01 = [
    [
      'circle',
      {
        'key': '0',
        'cx': '12',
        'cy': '11',
        'r': '3',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M17.6573 18C19.6963 16.35 21 13.8273 21 11C21 6.02944 16.9706 2 12 2C7.02944 2 3 6.02944 3 11V20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M18.4998 17.5L14.1211 13.1213M17.9998 5L14.1211 8.87868',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M18 18H5C4.05719 18 3.58579 18 3.29289 18.2929C3 18.5858 3 19.0572 3 20C3 20.9428 3 21.4142 3.29289 21.7071C3.58579 22 4.05719 22 5 22H20C20.5523 22 21 21.5523 21 21C21 19.3431 19.6569 18 18 18Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAstronaut01' icon.
  static const List<List<dynamic>> astronaut01 = strokeRoundedAstronaut01;

  /// JSON structure for the 'strokeRoundedAstronaut02' icon.
  static const List<List<dynamic>> strokeRoundedAstronaut02 = [
    [
      'circle',
      {
        'key': '0',
        'cx': '12',
        'cy': '10',
        'r': '7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'ellipse',
      {
        'key': '1',
        'cx': '12',
        'cy': '10',
        'rx': '4',
        'ry': '3',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M5 13C3.34315 13 2 11.6569 2 10C2 8.34315 2 7 5 7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M19 13C20.6569 13 22 11.6569 22 10C22 8.34315 22 7 19 7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M20.5 7V3',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd':
            'M18 21C18.5523 21 19 20.5523 19 20C19 18.3431 17.6569 17 16 17H8C6.34315 17 5 18.3431 5 20C5 20.5523 5.44772 21 6 21H18Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAstronaut02' icon.
  static const List<List<dynamic>> astronaut02 = strokeRoundedAstronaut02;

  /// JSON structure for the 'strokeRoundedAt' icon.
  static const List<List<dynamic>> strokeRoundedAt = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M15.6 8.40033V12.9003C15.6 14.3915 16.8088 15.6003 18.3 15.6003C19.7912 15.6003 21 14.3915 21 12.9003V12C21 7.02944 16.9706 3 12 3C7.02944 3 3 7.02944 3 12C3 16.9706 7.02944 21 12 21C14.0265 21 15.8965 20.3302 17.4009 19.2M15.6 12.0003C15.6 13.9886 13.9882 15.6003 12 15.6003C10.0118 15.6003 8.4 13.9886 8.4 12.0003C8.4 10.0121 10.0118 8.40033 12 8.40033C13.9882 8.40033 15.6 10.0121 15.6 12.0003Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAt' icon.
  static const List<List<dynamic>> at = strokeRoundedAt;

  /// JSON structure for the 'strokeRoundedAtm01' icon.
  static const List<List<dynamic>> strokeRoundedAtm01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M18.9349 13.9453L18.2646 10.2968C17.9751 8.72096 17.8303 7.93303 17.257 7.46651C16.6837 7 15.8602 7 14.2132 7H9.78685C8.1398 7 7.31628 7 6.74298 7.46651C6.16968 7.93303 6.02492 8.72096 5.73538 10.2968L5.06506 13.9453C4.46408 17.2162 4.16359 18.8517 5.08889 19.9259C6.01419 21 7.72355 21 11.1423 21H12.8577C16.2765 21 17.9858 21 18.9111 19.9259C19.8364 18.8517 19.5359 17.2162 18.9349 13.9453Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12 14C10.8954 14 10 13.1046 10 12C10 10.8954 10.8954 10 12 10C13.1046 10 14 10.8954 14 12C14 13.1046 13.1046 14 12 14Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 17.492L12 17.501',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M21 11C21.1568 10.9209 21.2931 10.8212 21.4142 10.6955C22 10.0875 22 9.10893 22 7.15176C22 5.1946 22 4.21602 21.4142 3.60801C20.8284 3 19.8856 3 18 3L6 3C4.11438 3 3.17157 3 2.58579 3.60801C2 4.21602 2 5.1946 2 7.15176C2 9.10893 2 10.0875 2.58579 10.6955C2.70688 10.8212 2.84322 10.9209 3 11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAtm01' icon.
  static const List<List<dynamic>> atm01 = strokeRoundedAtm01;

  /// JSON structure for the 'strokeRoundedAtm02' icon.
  static const List<List<dynamic>> strokeRoundedAtm02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M21 11C21.1568 10.9209 21.2931 10.8212 21.4142 10.6955C22 10.0875 22 9.10893 22 7.15176C22 5.1946 22 4.21602 21.4142 3.60801C20.8284 3 19.8856 3 18 3L6 3C4.11438 3 3.17157 3 2.58579 3.60801C2 4.21602 2 5.1946 2 7.15176C2 9.10893 2 10.0875 2.58579 10.6955C2.70688 10.8212 2.84322 10.9209 3 11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18.9349 13.9453L18.2646 10.2968C17.9751 8.72096 17.8303 7.93303 17.257 7.46651C16.6837 7 15.8602 7 14.2132 7H9.78685C8.1398 7 7.31628 7 6.74298 7.46651C6.16968 7.93303 6.02492 8.72096 5.73538 10.2968L5.06506 13.9453C4.46408 17.2162 4.16359 18.8517 5.08889 19.9259C6.01419 21 7.72355 21 11.1423 21H12.8577C16.2765 21 17.9858 21 18.9111 19.9259C19.8364 18.8517 19.5359 17.2162 18.9349 13.9453Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M11 7L9.5 21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M15 16L15 17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'stroke-miterlimit': '10',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAtm02' icon.
  static const List<List<dynamic>> atm02 = strokeRoundedAtm02;

  /// JSON structure for the 'strokeRoundedAtom01' icon.
  static const List<List<dynamic>> strokeRoundedAtom01 = [
    [
      'circle',
      {
        'key': '0',
        'cx': '12',
        'cy': '12',
        'r': '4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M22 9H21.99M2.00995 9H2M12.005 22H11.995',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M7.55556 21C4.47364 19.4999 2.37683 16.5285 2 13.1273M16.4444 21C19.5264 19.4999 21.6232 16.5285 22 13.1273M5.55555 4.25658C9.23956 1.24781 14.5382 1.24781 18.2222 4.25658',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAtom01' icon.
  static const List<List<dynamic>> atom01 = strokeRoundedAtom01;

  /// JSON structure for the 'strokeRoundedAtom02' icon.
  static const List<List<dynamic>> strokeRoundedAtom02 = [
    [
      'path',
      {
        'key': '0',
        'fillRule': 'evenodd',
        'clipRule': 'evenodd',
        'd':
            'M20.3541 3.64593C18.5085 1.8004 13.2722 4.04455 8.65837 8.65837C4.04455 13.2722 1.8004 18.5085 3.64593 20.3541C5.49146 22.1996 10.7278 19.9555 15.3416 15.3416C19.9555 10.7278 22.1996 5.49146 20.3541 3.64593Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'fillRule': 'evenodd',
        'clipRule': 'evenodd',
        'd':
            'M3.64593 3.64593C1.8004 5.49146 4.04455 10.7278 8.65837 15.3416C13.2722 19.9555 18.5085 22.1996 20.3541 20.3541C22.1996 18.5085 19.9555 13.2722 15.3416 8.65837C10.7278 4.04455 5.49146 1.8004 3.64593 3.64593Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12.009 12H12',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAtom02' icon.
  static const List<List<dynamic>> atom02 = strokeRoundedAtom02;

  /// JSON structure for the 'strokeRoundedAtomicPower' icon.
  static const List<List<dynamic>> strokeRoundedAtomicPower = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M20.663 8.85C21.2522 6.81022 21.0868 5.03955 20.0236 3.97636C17.7744 1.7271 12.3587 3.49602 7.92736 7.92736C7.45397 8.40074 7.01097 8.88536 6.6 9.37615M17.4 14.6238C16.989 15.1146 16.546 15.5993 16.0726 16.0726C11.6413 20.504 6.22562 22.2729 3.97636 20.0236C2.83569 18.883 2.72842 16.928 3.47772 14.7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12.6754 9.30005L10.9243 11.3704C10.7105 11.6476 10.6037 11.7862 10.6699 11.8931C10.7361 12 10.9288 12 11.3141 12H12.6867C13.072 12 13.2647 12 13.3309 12.107C13.3971 12.2139 13.2902 12.3525 13.0765 12.6297L11.3141 14.7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M9.75 17.7059C9.13145 17.2114 8.52058 16.6659 7.92736 16.0726C3.49602 11.6413 1.7271 6.22562 3.97636 3.97636C5.11702 2.83569 7.07202 2.72842 9.3 3.47772M14.25 20.3607C16.6631 21.2813 18.8068 21.2405 20.0236 20.0236C22.2729 17.7744 20.504 12.3587 16.0726 7.92736C15.4794 7.33413 14.8686 6.78862 14.25 6.29407',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAtomicPower' icon.
  static const List<List<dynamic>> atomicPower = strokeRoundedAtomicPower;

  /// JSON structure for the 'strokeRoundedAttachment' icon.
  static const List<List<dynamic>> strokeRoundedAttachment = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M19.5 12.0001V13.5001C19.5 17.6422 16.1421 21.0001 12 21.0001C7.85786 21.0001 4.5 17.6422 4.5 13.5001V8C4.5 5.23858 6.73858 3 9.5 3C12.2614 3 14.5 5.23858 14.5 8V13.5C14.5 14.8807 13.3807 16 12 16C10.6193 16 9.5 14.8807 9.5 13.5V9.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAttachment' icon.
  static const List<List<dynamic>> attachment = strokeRoundedAttachment;

  /// JSON structure for the 'strokeRoundedAttachment01' icon.
  static const List<List<dynamic>> strokeRoundedAttachment01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5.82338 12L4.27922 10.4558C2.57359 8.75022 2.57359 5.98485 4.27922 4.27922C5.98485 2.57359 8.75022 2.57359 10.4558 4.27922L19.7208 13.5442C21.4264 15.2498 21.4264 18.0152 19.7208 19.7208C18.0152 21.4264 15.2498 21.4264 13.5442 19.7208L10.0698 16.2464C9.00379 15.1804 9.00379 13.4521 10.0698 12.386C11.1358 11.32 12.8642 11.32 13.9302 12.386L15.8604 14.3162',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAttachment01' icon.
  static const List<List<dynamic>> attachment01 = strokeRoundedAttachment01;

  /// JSON structure for the 'strokeRoundedAttachment02' icon.
  static const List<List<dynamic>> strokeRoundedAttachment02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M8 8.00049V6.00049C8 3.79135 9.79086 2.00049 12 2.00049C14.2091 2.00049 16 3.79135 16 6.00049V18.0005C16 20.2096 14.2091 22.0005 12 22.0005C9.79086 22.0005 8 20.2096 8 18.0005V13.5005C8 12.1198 9.11929 11.0005 10.5 11.0005C11.8807 11.0005 13 12.1198 13 13.5005V16.0005',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAttachment02' icon.
  static const List<List<dynamic>> attachment02 = strokeRoundedAttachment02;

  /// JSON structure for the 'strokeRoundedAttachmentCircle' icon.
  static const List<List<dynamic>> strokeRoundedAttachmentCircle = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M8.56854 12L7.71068 11.1421C6.76311 10.1946 6.76311 8.65825 7.71068 7.71068C8.65825 6.76311 10.1946 6.76311 11.1421 7.71068L16.2893 12.8579C17.2369 13.8054 17.2369 15.3418 16.2893 16.2893C15.3418 17.2369 13.8054 17.2369 12.8579 16.2893L10.9277 14.3591C9.51688 12.9483 11.5463 11.0463 13 12.5L14 13.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'circle',
      {
        'key': '1',
        'cx': '12',
        'cy': '12',
        'r': '10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAttachmentCircle' icon.
  static const List<List<dynamic>> attachmentCircle =
      strokeRoundedAttachmentCircle;

  /// JSON structure for the 'strokeRoundedAttachmentSquare' icon.
  static const List<List<dynamic>> strokeRoundedAttachmentSquare = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M8.56854 12L7.71068 11.1421C6.76311 10.1946 6.76311 8.65825 7.71068 7.71068C8.65825 6.76311 10.1946 6.76311 11.1421 7.71068L16.2893 12.8579C17.2369 13.8054 17.2369 15.3418 16.2893 16.2893C15.3418 17.2369 13.8054 17.2369 12.8579 16.2893L10.9277 14.3591C9.51688 12.9483 11.5463 11.0463 13 12.5L14 13.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAttachmentSquare' icon.
  static const List<List<dynamic>> attachmentSquare =
      strokeRoundedAttachmentSquare;

  /// JSON structure for the 'strokeRoundedAuction' icon.
  static const List<List<dynamic>> strokeRoundedAuction = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12 14.0059L5.84373 21.2328C5.01764 22.2026 3.54001 22.2616 2.63922 21.3608C1.73843 20.46 1.79744 18.9824 2.7672 18.1563L9.99412 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M22 11.9048L15.9048 18M12.0952 2L6 8.09524M11.3334 2.76186L6.76195 7.33329C6.76195 7.33329 9.04766 10.3809 11.3334 12.6666C13.6191 14.9523 16.6667 17.2381 16.6667 17.2381L21.2381 12.6666C21.2381 12.6666 18.9524 9.61901 16.6667 7.33329C14.381 5.04758 11.3334 2.76186 11.3334 2.76186Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAuction' icon.
  static const List<List<dynamic>> auction = strokeRoundedAuction;

  /// JSON structure for the 'strokeRoundedAudioBook01' icon.
  static const List<List<dynamic>> strokeRoundedAudioBook01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M20 22H6C4.89543 22 4 21.1046 4 20M4 20C4 18.8954 4.89543 18 6 18H20V6C20 4.11438 20 3.17157 19.4142 2.58579C18.8284 2 17.8856 2 16 2H10C7.17157 2 5.75736 2 4.87868 2.87868C4 3.75736 4 5.17157 4 8V20Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M19.5 18C19.5 18 18.5 18.7628 18.5 20C18.5 21.2372 19.5 22 19.5 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M14.576 9.235L11.189 7.11812C11.0655 7.04093 10.9228 7 10.7771 7C10.3479 7 10 7.34793 10 7.77712V12.2229C10 12.6521 10.3479 13 10.7771 13C10.9228 13 11.0655 12.9591 11.189 12.8819L14.576 10.765C14.8398 10.6001 15 10.311 15 10C15 9.68896 14.8398 9.39985 14.576 9.235Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAudioBook01' icon.
  static const List<List<dynamic>> audioBook01 = strokeRoundedAudioBook01;

  /// JSON structure for the 'strokeRoundedAudioBook02' icon.
  static const List<List<dynamic>> strokeRoundedAudioBook02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M20 22H6C4.89543 22 4 21.1046 4 20M4 20C4 18.8954 4.89543 18 6 18H20V6C20 4.11438 20 3.17157 19.4142 2.58579C18.8284 2 17.8856 2 16 2H10C7.17157 2 5.75736 2 4.87868 2.87868C4 3.75736 4 5.17157 4 8V20Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M19.5 18C19.5 18 18.5 18.7628 18.5 20C18.5 21.2372 19.5 22 19.5 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M13.0008 12V6C13.0008 6 14.0008 8 15 8.5M13.0008 12C13.0008 13.1046 12.1046 14 11 14C9.89543 14 9 13.1046 9 12C9 10.8954 9.89543 10 11 10C12.1046 10 13.0008 10.8954 13.0008 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAudioBook02' icon.
  static const List<List<dynamic>> audioBook02 = strokeRoundedAudioBook02;

  /// JSON structure for the 'strokeRoundedAudioBook03' icon.
  static const List<List<dynamic>> strokeRoundedAudioBook03 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M20 22H6C4.89543 22 4 21.1046 4 20M4 20C4 18.8954 4.89543 18 6 18H20V6C20 4.11438 20 3.17157 19.4142 2.58579C18.8284 2 17.8856 2 16 2H10C7.17157 2 5.75736 2 4.87868 2.87868C4 3.75736 4 5.17157 4 8V20Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M19.5 18C19.5 18 18.5 18.7628 18.5 20C18.5 21.2372 19.5 22 19.5 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M11.5 8.55078H10.5C10.0341 8.55078 9.80109 8.55078 9.61732 8.6269C9.37229 8.7284 9.17761 8.92307 9.07612 9.1681C9 9.35187 9 9.58484 9 10.0508C9 10.5167 9 10.7497 9.07612 10.9335C9.17761 11.1785 9.37229 11.3732 9.61732 11.4747C9.80109 11.5508 10.0341 11.5508 10.5 11.5508H11.5L15 14V6L11.5 8.55078Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAudioBook03' icon.
  static const List<List<dynamic>> audioBook03 = strokeRoundedAudioBook03;

  /// JSON structure for the 'strokeRoundedAudioBook04' icon.
  static const List<List<dynamic>> strokeRoundedAudioBook04 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M20 22H6C4.89543 22 4 21.1046 4 20M4 20C4 18.8954 4.89543 18 6 18H20V6C20 4.11438 20 3.17157 19.4142 2.58579C18.8284 2 17.8856 2 16 2H10C7.17157 2 5.75736 2 4.87868 2.87868C4 3.75736 4 5.17157 4 8V20Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M19.5 18C19.5 18 18.5 18.7628 18.5 20C18.5 21.2372 19.5 22 19.5 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M7.5 11H9C9.55228 11 10 11.4477 10 12V13C10 13.5523 9.55228 14 9 14H8.5C7.94772 14 7.5 13.5523 7.5 13V11ZM7.5 11V10.5C7.5 8.01472 9.51472 6 12 6C14.4853 6 16.5 8.01472 16.5 10.5V11M16.5 11H15C14.4477 11 14 11.4477 14 12V13C14 13.5523 14.4477 14 15 14H15.5C16.0523 14 16.5 13.5523 16.5 13V11Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAudioBook04' icon.
  static const List<List<dynamic>> audioBook04 = strokeRoundedAudioBook04;

  /// JSON structure for the 'strokeRoundedAudioWave01' icon.
  static const List<List<dynamic>> strokeRoundedAudioWave01 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M9 3V21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M6 7V17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 6V18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M15 9L15 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M18 7L18 17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M21 11L21 13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd': 'M3 11L3 13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAudioWave01' icon.
  static const List<List<dynamic>> audioWave01 = strokeRoundedAudioWave01;

  /// JSON structure for the 'strokeRoundedAudioWave02' icon.
  static const List<List<dynamic>> strokeRoundedAudioWave02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3 14V9.5C3 8.67157 3.67157 8 4.5 8C5.32843 8 6 8.67157 6 9.5V16.5C6 17.3284 6.67157 18 7.5 18C8.32843 18 9 17.3284 9 16.5V4.5C9 3.67157 9.67157 3 10.5 3C11.3284 3 12 3.67157 12 4.5V19.5C12 20.3284 12.6716 21 13.5 21C14.3284 21 15 20.3284 15 19.5V8.5C15 7.67157 15.6716 7 16.5 7C17.3284 7 18 7.67157 18 8.5V15.5C18 16.3284 18.6716 17 19.5 17C20.3284 17 21 16.3284 21 15.5V12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAudioWave02' icon.
  static const List<List<dynamic>> audioWave02 = strokeRoundedAudioWave02;

  /// JSON structure for the 'strokeRoundedAudit01' icon.
  static const List<List<dynamic>> strokeRoundedAudit01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M19 10.5V10C19 6.22876 19 4.34315 17.8284 3.17157C16.6569 2 14.7712 2 11 2C7.22876 2 5.34315 2 4.17157 3.17157C3 4.34315 3 6.22876 3 10V16C3 17.8638 3 18.7956 3.30448 19.5307C3.71046 20.5108 4.48915 21.2895 5.46927 21.6955C6.20435 22 7.13623 22 9 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M7 7H15M7 11H11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M15.2825 19.0044C15.2235 18.1157 15.118 17.1658 14.6817 16.0917C14.3095 15.1756 14.4132 13.0205 16.5 13.0205C18.5868 13.0205 18.6664 15.1756 18.2942 16.0917C17.8578 17.1658 17.7765 18.1157 17.7175 19.0044M21 22H12V20.7543C12 20.3078 12.2664 19.9154 12.6528 19.7928L14.9076 19.077C15.0684 19.0259 15.2348 19 15.4021 19H17.5979C17.7652 19 17.9316 19.0259 18.0924 19.077L20.3472 19.7928C20.7336 19.9154 21 20.3078 21 20.7543V22Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAudit01' icon.
  static const List<List<dynamic>> audit01 = strokeRoundedAudit01;

  /// JSON structure for the 'strokeRoundedAudit02' icon.
  static const List<List<dynamic>> strokeRoundedAudit02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M19 11V10C19 6.22876 19 4.34315 17.8284 3.17157C16.6569 2 14.7712 2 11 2C7.22876 2 5.34315 2 4.17157 3.17157C3 4.34315 3 6.22876 3 10V14C3 17.7712 3 19.6569 4.17157 20.8284C5.34315 22 7.22876 22 11 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M21 22L19.2857 20.2857M19.8571 17.4286C19.8571 19.3221 18.3221 20.8571 16.4286 20.8571C14.535 20.8571 13 19.3221 13 17.4286C13 15.535 14.535 14 16.4286 14C18.3221 14 19.8571 15.535 19.8571 17.4286Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M7 7H15M7 11H11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAudit02' icon.
  static const List<List<dynamic>> audit02 = strokeRoundedAudit02;

  /// JSON structure for the 'strokeRoundedAugmentedRealityAr' icon.
  static const List<List<dynamic>> strokeRoundedAugmentedRealityAr = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M13 3H11C6.75736 3 4.63604 3 3.31802 4.31802C2 5.63604 2 7.75736 2 12C2 16.2426 2 18.364 3.31802 19.682C4.63604 21 6.75736 21 11 21H13C17.2426 21 19.364 21 20.682 19.682C22 18.364 22 16.2426 22 12C22 7.75736 22 5.63604 20.682 4.31802C19.364 3 17.2426 3 13 3Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M6 14L7.75464 10.0877C8.07987 9.36258 8.24249 9 8.5 9C8.75751 9 8.92013 9.36258 9.24536 10.0877L11 14M14 14V12M14 12V10.2C14 9.63431 14 9.35147 14.1757 9.17574C14.3515 9 14.6343 9 15.2 9H16.5C17.3284 9 18 9.67157 18 10.5C18 11.3284 17.3284 12 16.5 12M14 12H16.5M16.5 12L17.5 14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAugmentedRealityAr' icon.
  static const List<List<dynamic>> augmentedRealityAr =
      strokeRoundedAugmentedRealityAr;

  /// JSON structure for the 'strokeRoundedAuthorized' icon.
  static const List<List<dynamic>> strokeRoundedAuthorized = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4 17C4 19.2091 5.75326 21 7.91602 21C9.68999 21 11.1885 19.7951 11.6699 18.1429H15.8599C16.2819 18.1429 16.3075 18.169 16.3075 18.6V19.8571C16.3075 20.3959 16.3075 20.6653 16.4713 20.8326C16.6352 21 16.8989 21 17.4263 21H18.1874C18.6265 21 18.846 21 19.0007 20.8705C19.1554 20.741 19.1984 20.5211 19.2845 20.0813L19.2845 20.0813L19.5921 18.5103C19.661 18.1585 19.6797 18.1429 20.031 18.1429H20.7829C21.3104 18.1429 21.5741 18.1429 21.7379 17.9755C22.1045 17.6011 22.0698 15.7921 21.7379 15.4531C21.5741 15.2857 21.3104 15.2857 20.7829 15.2857H11.4552C10.8267 13.9343 9.47817 13 7.91602 13C5.75326 13 4 14.7909 4 17Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M8.00896 17H8',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M19 12.5V9C19 6.17157 19 4.75736 18.1213 3.87868C17.2426 3 15.8284 3 13 3H8C5.17157 3 3.75736 3 2.87868 3.87868C2 4.75736 2 6.17157 2 9V14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAuthorized' icon.
  static const List<List<dynamic>> authorized = strokeRoundedAuthorized;

  /// JSON structure for the 'strokeRoundedAutoConversations' icon.
  static const List<List<dynamic>> strokeRoundedAutoConversations = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4.94436 8.04069L10.8282 8.04069M2 18L7.49762 12.5862C7.70914 12.3779 8.03957 12.3544 8.27806 12.5308L12.5239 15.6712C12.774 15.8563 13.1229 15.8204 13.3306 15.5883L21.2849 6.70262M18.1084 6H20.9306C21.4785 6 21.9259 6.44077 21.9371 6.99179L22 10.0649',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAutoConversations' icon.
  static const List<List<dynamic>> autoConversations =
      strokeRoundedAutoConversations;

  /// JSON structure for the 'strokeRoundedAutomotiveBattery01' icon.
  static const List<List<dynamic>> strokeRoundedAutomotiveBattery01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M16 5.5H8C5.17157 5.5 3.75736 5.5 2.87868 6.37868C2 7.25736 2 8.67157 2 11.5V15C2 17.8284 2 19.2426 2.87868 20.1213C3.75736 21 5.17157 21 8 21H16C18.8284 21 20.2426 21 21.1213 20.1213C22 19.2426 22 17.8284 22 15V11.5C22 8.67157 22 7.25736 21.1213 6.37868C20.2426 5.5 18.8284 5.5 16 5.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M17 8.5V12.5M19 10.5H15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M9 10.5H5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M9 5.5V4.75C9 4.04777 9 3.69665 8.83147 3.44443C8.75851 3.33524 8.66476 3.24149 8.55557 3.16853C8.30335 3 7.95223 3 7.25 3C6.54777 3 6.19665 3 5.94443 3.16853C5.83524 3.24149 5.74149 3.33524 5.66853 3.44443C5.5 3.69665 5.5 4.04777 5.5 4.75V5.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M18.5 5.5V4.75C18.5 4.04777 18.5 3.69665 18.3315 3.44443C18.2585 3.33524 18.1648 3.24149 18.0556 3.16853C17.8033 3 17.4522 3 16.75 3C16.0478 3 15.6967 3 15.4444 3.16853C15.3352 3.24149 15.2415 3.33524 15.1685 3.44443C15 3.69665 15 4.04777 15 4.75V5.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAutomotiveBattery01' icon.
  static const List<List<dynamic>> automotiveBattery01 =
      strokeRoundedAutomotiveBattery01;

  /// JSON structure for the 'strokeRoundedAutomotiveBattery02' icon.
  static const List<List<dynamic>> strokeRoundedAutomotiveBattery02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M16 5.5H8C5.17157 5.5 3.75736 5.5 2.87868 6.37868C2 7.25736 2 8.67157 2 11.5V15C2 17.8284 2 19.2426 2.87868 20.1213C3.75736 21 5.17157 21 8 21H16C18.8284 21 20.2426 21 21.1213 20.1213C22 19.2426 22 17.8284 22 15V11.5C22 8.67157 22 7.25736 21.1213 6.37868C20.2426 5.5 18.8284 5.5 16 5.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M12.5 9L10 13H14L11.5 17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M9 5.5V4.75C9 4.04777 9 3.69665 8.83147 3.44443C8.75851 3.33524 8.66476 3.24149 8.55557 3.16853C8.30335 3 7.95223 3 7.25 3C6.54777 3 6.19665 3 5.94443 3.16853C5.83524 3.24149 5.74149 3.33524 5.66853 3.44443C5.5 3.69665 5.5 4.04777 5.5 4.75V5.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M18.5 5.5V4.75C18.5 4.04777 18.5 3.69665 18.3315 3.44443C18.2585 3.33524 18.1648 3.24149 18.0556 3.16853C17.8033 3 17.4522 3 16.75 3C16.0478 3 15.6967 3 15.4444 3.16853C15.3352 3.24149 15.2415 3.33524 15.1685 3.44443C15 3.69665 15 4.04777 15 4.75V5.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAutomotiveBattery02' icon.
  static const List<List<dynamic>> automotiveBattery02 =
      strokeRoundedAutomotiveBattery02;

  /// JSON structure for the 'strokeRoundedAvalanche' icon.
  static const List<List<dynamic>> strokeRoundedAvalanche = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2 21H11.6547C14.1755 21 15.4359 21 15.8711 20.1706C16.3063 19.3412 15.6107 18.2648 14.2196 16.112L6.93559 4.83965C6.13925 3.60728 5.74108 2.9911 5.17984 3.0001C3.95309 3.01976 2.5 6 2 7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M10 5C10.6024 6.2142 11.1505 7.01476 12 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M2 7C2.19944 7.58943 2.32706 8.50266 2.75554 8.96655C3.00648 9.23823 3.39002 9.34981 3.75053 9.25601C4.29307 9.11485 4.61512 8.53558 5.1267 8.33278C5.36623 8.23783 5.63377 8.23783 5.8733 8.33278C6.51536 8.5873 6.92764 9.39686 7.63967 9.49121C8.32392 9.58188 8.66629 8.9708 9 8.47768',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M18.7267 15.0452C18.6898 15.426 18.5912 15.7902 18.4401 16.1291M18.7267 15.0452C18.936 12.8817 17.0417 11 14.762 11C14.0531 11 12.8052 11.1754 12 11.763M18.7267 15.0452C20.5289 15.0371 22 16.3985 22 18.0791C22 19.4694 20.9961 20.6412 19.6267 21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAvalanche' icon.
  static const List<List<dynamic>> avalanche = strokeRoundedAvalanche;

  /// JSON structure for the 'strokeRoundedAvocado' icon.
  static const List<List<dynamic>> strokeRoundedAvocado = [
    [
      'path',
      {
        'key': '0',
        'd': 'M12 5C12 4 12.4 2 14 2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12 18.0412V13.9588C12 13.167 12.2189 12.8334 13.1525 13.0797C16.2825 13.9053 16.2825 18.0947 13.1525 18.9203C12.2189 19.1666 12 18.833 12 18.0412Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M11.9999 5C9.60664 5 7.66654 6.79086 7.66654 9C7.66654 10.2239 7.38884 11.5983 6.63817 12.6071C5.9201 13.5722 5.49988 14.7408 5.49988 16C5.49988 19.3137 8.41003 22 11.9999 22C15.5897 22 18.4999 19.3137 18.4999 16C18.4999 14.7408 18.0797 13.5722 17.3616 12.6071C16.6109 11.5983 16.3332 10.2239 16.3332 9C16.3332 6.79086 14.3931 5 11.9999 5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAvocado' icon.
  static const List<List<dynamic>> avocado = strokeRoundedAvocado;

  /// JSON structure for the 'strokeRoundedAward01' icon.
  static const List<List<dynamic>> strokeRoundedAward01 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M12 12V18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12 18C10.3264 18 8.86971 19.012 8.11766 20.505C7.75846 21.218 8.27389 22 8.95877 22H15.0412C15.7261 22 16.2415 21.218 15.8823 20.505C15.1303 19.012 13.6736 18 12 18Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M5 5H3.98471C2.99819 5 2.50493 5 2.20017 5.37053C1.89541 5.74106 1.98478 6.15597 2.16352 6.9858C2.50494 8.57086 3.24548 9.9634 4.2489 11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M19 5H20.0153C21.0018 5 21.4951 5 21.7998 5.37053C22.1046 5.74106 22.0152 6.15597 21.8365 6.9858C21.4951 8.57086 20.7545 9.9634 19.7511 11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M12 12C15.866 12 19 8.8831 19 5.03821C19 4.93739 18.9978 4.83707 18.9936 4.73729C18.9509 3.73806 18.9295 3.23845 18.2523 2.61922C17.5751 2 16.8247 2 15.324 2H8.67596C7.17526 2 6.42492 2 5.74772 2.61922C5.07051 3.23844 5.04915 3.73806 5.00642 4.73729C5.00215 4.83707 5 4.93739 5 5.03821C5 8.8831 8.13401 12 12 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAward01' icon.
  static const List<List<dynamic>> award01 = strokeRoundedAward01;

  /// JSON structure for the 'strokeRoundedAward02' icon.
  static const List<List<dynamic>> strokeRoundedAward02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M8 21C8 19.5858 8 18.8787 8.43934 18.4393C8.87868 18 9.58579 18 11 18H13C14.4142 18 15.1213 18 15.5607 18.4393C16 18.8787 16 19.5858 16 21V22H8V21Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M12 13L12 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M6 22H18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M13.0366 2.86651L14.0925 4.99573C14.2364 5.29212 14.6204 5.57642 14.9444 5.63086L16.8582 5.95145C18.082 6.15712 18.37 7.05236 17.4881 7.9355L16.0003 9.43563C15.7483 9.68968 15.6103 10.1796 15.6883 10.5305L16.1142 12.3875C16.4502 13.8574 15.6763 14.426 14.3864 13.6578L12.5926 12.5871C12.2687 12.3935 11.7347 12.3935 11.4048 12.5871L9.61096 13.6578C8.3271 14.426 7.54719 13.8513 7.88315 12.3875L8.3091 10.5305C8.3871 10.1796 8.24911 9.68968 7.99714 9.43563L6.5093 7.9355C5.6334 7.05236 5.91537 6.15712 7.13923 5.95145L9.05302 5.63086C9.37099 5.57642 9.75494 5.29212 9.89893 4.99573L10.9548 2.86651C11.5307 1.71116 12.4666 1.71116 13.0366 2.86651Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAward02' icon.
  static const List<List<dynamic>> award02 = strokeRoundedAward02;

  /// JSON structure for the 'strokeRoundedAward03' icon.
  static const List<List<dynamic>> strokeRoundedAward03 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M7.6801 12.9866C7.01748 9.62725 6.68617 7.9476 7.40306 6.58098C8.11994 5.21437 9.66067 4.58848 12.7421 3.3367L13.37 3.08163C15.698 2.13592 16.862 1.66307 17.5646 2.27374C18.2671 2.88442 18.0196 4.15398 17.5247 6.69309L15.3206 18H8.66899L7.6801 12.9866Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M6 21C6 19.5858 6 18.8787 6.43934 18.4393C6.87868 18 7.58579 18 9 18H15C16.4142 18 17.1213 18 17.5607 18.4393C18 18.8787 18 19.5858 18 21V22H6V21Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M4 22L20 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAward03' icon.
  static const List<List<dynamic>> award03 = strokeRoundedAward03;

  /// JSON structure for the 'strokeRoundedAward04' icon.
  static const List<List<dynamic>> strokeRoundedAward04 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M9.42613 3.06269C10.6836 2.35423 11.3124 2 12 2C12.6876 2 13.3164 2.35423 14.5739 3.06269L16.3239 4.04861C17.6292 4.78401 18.2819 5.15171 18.6409 5.76664C19 6.38157 19 7.13157 19 8.63158V10.3684C19 11.8684 19 12.6184 18.6409 13.2334C18.2819 13.8483 17.6292 14.216 16.3239 14.9514L14.5739 15.9373C13.3164 16.6458 12.6876 17 12 17C11.3124 17 10.6836 16.6458 9.42613 15.9373L7.67613 14.9514C6.37081 14.216 5.71815 13.8483 5.35908 13.2334C5 12.6184 5 11.8684 5 10.3684V8.63158C5 7.13157 5 6.38157 5.35908 5.76664C5.71815 5.15171 6.37081 4.78401 7.67613 4.04861L9.42613 3.06269Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M9 10.1667C9 10.1667 9.75 10.1667 10.5 11.5C10.5 11.5 12.8824 8.16667 15 7.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M16.8825 15L17.5527 18.2099C17.9833 20.2723 18.1986 21.3035 17.7563 21.7923C17.3141 22.281 16.546 21.8606 15.0099 21.0198L12.7364 19.7753C12.3734 19.5766 12.1919 19.4773 12 19.4773C11.8081 19.4773 11.6266 19.5766 11.2636 19.7753L8.99008 21.0198C7.45397 21.8606 6.68592 22.281 6.24365 21.7923C5.80139 21.3035 6.01669 20.2723 6.44731 18.2099L7.11752 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAward04' icon.
  static const List<List<dynamic>> award04 = strokeRoundedAward04;

  /// JSON structure for the 'strokeRoundedAward05' icon.
  static const List<List<dynamic>> strokeRoundedAward05 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4.5 9.5C4.5 13.6421 7.85786 17 12 17C16.1421 17 19.5 13.6421 19.5 9.5C19.5 5.35786 16.1421 2 12 2C7.85786 2 4.5 5.35786 4.5 9.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M9 10.1667C9 10.1667 9.75 10.1667 10.5 11.5C10.5 11.5 12.8824 8.16667 15 7.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M16.8825 15L17.5527 18.2099C17.9833 20.2723 18.1986 21.3035 17.7563 21.7923C17.3141 22.281 16.546 21.8606 15.0099 21.0198L12.7364 19.7753C12.3734 19.5766 12.1919 19.4773 12 19.4773C11.8081 19.4773 11.6266 19.5766 11.2636 19.7753L8.99008 21.0198C7.45397 21.8606 6.68592 22.281 6.24365 21.7923C5.80139 21.3035 6.01669 20.2723 6.44731 18.2099L7.11752 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedAward05' icon.
  static const List<List<dynamic>> award05 = strokeRoundedAward05;

  /// JSON structure for the 'strokeRoundedBaby01' icon.
  static const List<List<dynamic>> strokeRoundedBaby01 = [
    [
      'circle',
      {
        'key': '0',
        'cx': '12',
        'cy': '12',
        'r': '10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M14 16C13.4271 16.6318 12.7395 17 12 17C11.2605 17 10.5729 16.6318 10 16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M9 11.5C8.71357 11.1841 8.36974 11 8 11C7.63026 11 7.28643 11.1841 7 11.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M17 11.5C16.7136 11.1841 16.3697 11 16 11C15.6303 11 15.2864 11.1841 15 11.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M12 2C10.3431 2 9 3.34315 9 5C9 6.65685 10.3431 8 12 8C12.7684 8 13.4692 7.71115 14 7.23611',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBaby01' icon.
  static const List<List<dynamic>> baby01 = strokeRoundedBaby01;

  /// JSON structure for the 'strokeRoundedBaby02' icon.
  static const List<List<dynamic>> strokeRoundedBaby02 = [
    [
      'circle',
      {
        'key': '0',
        'cx': '12',
        'cy': '8',
        'r': '6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M16.874 12C17.5826 13.037 18 14.3093 18 15.6842C18 16.5017 17.8524 17.2829 17.5838 18M7.12605 12C6.41738 13.037 6 14.3093 6 15.6842C6 19.1723 8.68629 22 12 22C14.5371 22 16.7064 20.3424 17.5838 18M17.5838 18C14.8509 16.8 12.0559 14.8333 11 14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M12 2C11.0059 2 10.2 2.7835 10.2 3.75C10.2 4.7165 11.0059 5.5 12 5.5C12.461 5.5 12.8815 5.3315 13.2 5.0544',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M10 8H10.0081M14 8H14.0081',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBaby02' icon.
  static const List<List<dynamic>> baby02 = strokeRoundedBaby02;

  /// JSON structure for the 'strokeRoundedBabyBed01' icon.
  static const List<List<dynamic>> strokeRoundedBabyBed01 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M12 7L12 15M8 7L8 15M16 7L16 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M20 20V6C20 4.89543 20.8954 4 22 4M4 20V6C4 4.89543 3.10457 4 2 4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M4 7H20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M4 15H20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M4 18H20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBabyBed01' icon.
  static const List<List<dynamic>> babyBed01 = strokeRoundedBabyBed01;

  /// JSON structure for the 'strokeRoundedBabyBed02' icon.
  static const List<List<dynamic>> strokeRoundedBabyBed02 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M12 7L12 15M16 7L16 15M8 7L8 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M22 17C19.3349 18.8671 15.8341 20 12 20C8.16586 20 4.66508 18.8671 2 17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M20 18V6C20 4.89543 20.8954 4 22 4M4 18V6C4 4.89543 3.10457 4 2 4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M4 7H20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M4 15H20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBabyBed02' icon.
  static const List<List<dynamic>> babyBed02 = strokeRoundedBabyBed02;

  /// JSON structure for the 'strokeRoundedBabyBottle' icon.
  static const List<List<dynamic>> strokeRoundedBabyBottle = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M17 10.4999C17 10.4999 18 12.9999 18 16.2499C18 17.4211 17.8701 18.4948 17.704 19.3893C17.4952 20.5136 17.3908 21.0757 16.835 21.5378C16.2792 21.9999 15.6168 21.9999 14.2919 21.9999H9.70813C8.38323 21.9999 7.72079 21.9999 7.16499 21.5378C6.60919 21.0757 6.50478 20.5136 6.29598 19.3893C6.12986 18.4948 6 17.4211 6 16.2499C6 12.9999 7 10.4999 7 10.4999',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M7.00011 10.5109H17.0001C17.148 9.69502 16.9213 8.12207 14.9607 7.49988C14.4954 7.35226 13.95 7.07619 13.7045 6.61167C13.4872 6.20036 13.3855 5.64345 13.7112 5.02533C14.3134 3.88252 13.7323 2.48044 12.4822 2.08711C12.326 2.03794 12.1632 2.00167 12.0001 2.00006C11.826 1.99834 11.6517 2.03461 11.4849 2.08711C10.2348 2.48044 9.65373 3.88252 10.2559 5.02533C10.5816 5.64345 10.4799 6.20036 10.2626 6.61167C10.0247 7.06186 9.50673 7.46163 9.02371 7.61486C7.67057 8.04418 6.73858 9.06774 7.00011 10.5109Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M15 13.9999H17.5M15 17.9999H17.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBabyBottle' icon.
  static const List<List<dynamic>> babyBottle = strokeRoundedBabyBottle;

  /// JSON structure for the 'strokeRoundedBabyBoyDress' icon.
  static const List<List<dynamic>> strokeRoundedBabyBoyDress = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5.94724 9.003C5.94724 9.003 3.68265 11.252 3.01654 10.9766C2.07687 10.5882 1.67051 6.8204 2.30951 6.24512L4.76679 4.03287C5.90144 3.01137 5.93084 3 7.43853 3H8.95703C9.1835 4.3592 10.4956 5.99207 12 5.99207C13.5044 5.99207 14.8165 4.3592 15.043 3H16.5615C18.0692 3 18.0986 3.01136 19.2332 4.03287L21.6905 6.24512C22.3295 6.8204 21.9231 10.5882 20.9835 10.9766C20.3173 11.252 18.0489 9.003 18.0489 9.003',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M6 8V18.5267C6 19.2323 6.11985 19.6092 6.75491 19.9496C9.3676 21.3501 14.6324 21.3501 17.2451 19.9496C17.8802 19.6092 18 19.2323 18 18.5267L18 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M6 10C8 12.6667 16 12.6667 18 10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBabyBoyDress' icon.
  static const List<List<dynamic>> babyBoyDress = strokeRoundedBabyBoyDress;

  /// JSON structure for the 'strokeRoundedBabyGirlDress' icon.
  static const List<List<dynamic>> strokeRoundedBabyGirlDress = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M8.21182 9L4.27882 16.4753C2.45802 19.936 10.0782 21 12 21C13.9218 21 21.542 19.936 19.7212 16.4753L15.7882 9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M10.1344 12.2209C10.8048 11.8554 11.3899 12.0027 11.7414 12.2373C11.8855 12.3335 11.9576 12.3817 12 12.3817C12.0424 12.3817 12.1145 12.3335 12.2586 12.2373C12.6101 12.0027 13.1952 11.8554 13.8656 12.2209C14.7455 12.7007 14.9446 14.2833 12.9151 15.6185C12.5286 15.8728 12.3353 16 12 16C11.6647 16 11.4714 15.8728 11.0849 15.6185C9.05543 14.2833 9.25452 12.7007 10.1344 12.2209Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M6.99975 10.8144C5.00001 11.7912 1.47372 8.63145 2.06625 7.87321L5.5695 3.39027C5.76071 3.14559 6.07218 3 6.40442 3H8.50685C8.75549 3 8.96414 3.16269 9.04048 3.37578C9.42268 4.44252 10.762 5.72296 12 5.72301C13.238 5.72305 14.5774 4.4425 14.9596 3.37578C15.0359 3.16269 15.2446 3 15.4932 3H17.5956C17.9279 3 18.2393 3.14559 18.4305 3.39027L21.9338 7.87321C22.5263 8.63145 19 11.7912 17.0017 10.8144',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBabyGirlDress' icon.
  static const List<List<dynamic>> babyGirlDress = strokeRoundedBabyGirlDress;

  /// JSON structure for the 'strokeRoundedBackMuscleBody' icon.
  static const List<List<dynamic>> strokeRoundedBackMuscleBody = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M15.5 10C14.6716 10 14 9.32843 14 8.5M8.5 10C9.32843 10 10 9.32843 10 8.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M14 2V2.64298C14 3.22979 14 3.52319 14.0654 3.77255C14.223 4.37391 14.6513 4.86778 15.2244 5.10888C15.462 5.20885 15.7524 5.25035 16.3333 5.33333C17.4952 5.49931 18.0761 5.5823 18.5513 5.78224C19.6973 6.26445 20.554 7.25217 20.8693 8.4549C21 8.95361 21 9.54043 21 10.714V22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M10 2V2.64298C10 3.22979 10 3.52319 9.93463 3.77255C9.77699 4.37391 9.34867 4.86778 8.77564 5.10888C8.53804 5.20885 8.24758 5.25035 7.66667 5.33333C6.50484 5.49931 5.92393 5.5823 5.44871 5.78224C4.30266 6.26445 3.44601 7.25217 3.13073 8.4549C3 8.95361 3 9.54043 3 10.714V22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M12 13V22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M18 11.5C18 11.5 17.4549 14.3636 17.503 17.2273C17.535 19.1271 18 22 18 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd':
            'M6 11.5C6 11.5 6.54513 14.3636 6.49699 17.2273C6.46505 19.1271 6 22 6 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBackMuscleBody' icon.
  static const List<List<dynamic>> backMuscleBody = strokeRoundedBackMuscleBody;

  /// JSON structure for the 'strokeRoundedBackground' icon.
  static const List<List<dynamic>> strokeRoundedBackground = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4.25276 20.302C5.6554 21.5 7.77027 21.5 12 21.5C16.2297 21.5 18.3446 21.5 19.7472 20.302C19.9464 20.1319 20.1319 19.9464 20.302 19.7472C21.5 18.3446 21.5 16.2297 21.5 12C21.5 7.77027 21.5 5.6554 20.302 4.25276C20.1319 4.05358 19.9464 3.86808 19.7472 3.69797C18.3446 2.5 16.2297 2.5 12 2.5C7.77027 2.5 5.6554 2.5 4.25276 3.69797C4.05358 3.86808 3.86808 4.05358 3.69797 4.25276C2.5 5.6554 2.5 7.77027 2.5 12C2.5 16.2297 2.5 18.3446 3.69797 19.7472C3.86808 19.9464 4.05358 20.1319 4.25276 20.302Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M4 20L20 4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M2.69806 15.8021L15.8058 2.69434',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M21.3058 8.19434L8.19806 21.3021',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M13.5 21.5L21.5 13.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M2.5 10.5L10.5 2.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBackground' icon.
  static const List<List<dynamic>> background = strokeRoundedBackground;

  /// JSON structure for the 'strokeRoundedBackpack01' icon.
  static const List<List<dynamic>> strokeRoundedBackpack01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5 12C5 8.13401 8.13401 5 12 5C15.866 5 19 8.13401 19 12V16.3333C19 17.8847 19 18.6604 18.7877 19.2858C18.388 20.4633 17.4633 21.388 16.2858 21.7877C15.6604 22 14.8847 22 13.3333 22H10.6667C9.11529 22 8.3396 22 7.71424 21.7877C6.53668 21.388 5.61201 20.4633 5.21228 19.2858C5 18.6604 5 17.8847 5 16.3333V12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M5 17C6.64996 15.17 9.17273 14 12 14C14.8273 14 17.35 15.17 19 17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M11 10H13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M9 6V5C9 4.06812 9 3.60218 9.15224 3.23463C9.35523 2.74458 9.74458 2.35523 10.2346 2.15224C10.6022 2 11.0681 2 12 2C12.9319 2 13.3978 2 13.7654 2.15224C14.2554 2.35523 14.6448 2.74458 14.8478 3.23463C15 3.60218 15 4.06812 15 5V6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M5 19H3.71429C2.76751 19 2 18.2325 2 17.2857L2 16C2 14.3431 3.34315 13 5 13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd':
            'M19 19H20.2857C21.2325 19 22 18.2325 22 17.2857L22 16C22 14.3431 20.6569 13 19 13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBackpack01' icon.
  static const List<List<dynamic>> backpack01 = strokeRoundedBackpack01;

  /// JSON structure for the 'strokeRoundedBackpack02' icon.
  static const List<List<dynamic>> strokeRoundedBackpack02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M19 14H20.2389C21.3498 14 22.1831 15.0805 21.9652 16.2386L21.7003 17.6466C21.4429 19.015 20.3127 20 19 20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M5 14H3.76113C2.65015 14 1.81691 15.0805 2.03479 16.2386L2.29967 17.6466C2.55711 19.015 3.68731 20 5 20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M18.2696 10.5L18.7911 15.1967C19.071 18.379 19.211 19.9701 18.2696 20.985C17.3283 22 15.7125 22 12.481 22H11.519C8.2875 22 6.67174 22 5.73038 20.985C4.78901 19.9701 4.92899 18.379 5.20893 15.1967L5.73038 10.4999',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M15 5C15 3.34315 13.6569 2 12 2C10.3431 2 9 3.34315 9 5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M5.2617 8.86971C5.01152 7.45403 4.88643 6.74619 5.13559 6.20431C5.30195 5.84248 5.57803 5.53512 5.9291 5.32087C6.45489 5 7.21577 5 8.73753 5H15.2625C16.7842 5 17.5451 5 18.0709 5.32087C18.422 5.53512 18.698 5.84248 18.8644 6.20431C19.1136 6.74619 18.9885 7.45403 18.7383 8.86971L18.6872 9.15901C18.5902 9.70796 18.5417 9.98243 18.446 10.2349C18.2806 10.671 18.0104 11.0651 17.6565 11.3863C17.4517 11.5722 17.2062 11.7266 16.7153 12.0353C16.2537 12.3255 16.0229 12.4706 15.779 12.5845C15.3579 12.7812 14.905 12.9105 14.439 12.9672C14.169 13 13.8916 13 13.3369 13H10.6631C10.1084 13 9.831 13 9.56102 12.9672C9.09497 12.9105 8.64214 12.7812 8.22104 12.5845C7.9771 12.4706 7.74632 12.3255 7.28474 12.0353C6.79376 11.7266 6.54827 11.5722 6.34346 11.3863C5.98959 11.0651 5.7194 10.671 5.55404 10.2349C5.45833 9.98243 5.40983 9.70796 5.31282 9.15901L5.2617 8.86971Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M12 10.0024L12.0087 10.0001',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBackpack02' icon.
  static const List<List<dynamic>> backpack02 = strokeRoundedBackpack02;

  /// JSON structure for the 'strokeRoundedBackpack03' icon.
  static const List<List<dynamic>> strokeRoundedBackpack03 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5 7.66667C5 7.04669 5 6.73669 5.06815 6.48236C5.25308 5.79218 5.79218 5.25308 6.48236 5.06815C6.73669 5 7.04669 5 7.66667 5H16.3333C16.9533 5 17.2633 5 17.5176 5.06815C18.2078 5.25308 18.7469 5.79218 18.9319 6.48236C19 6.73669 19 7.04669 19 7.66667C19 8.90663 19 9.52661 18.8637 10.0353C18.4938 11.4156 17.4156 12.4938 16.0353 12.8637C15.5266 13 14.9066 13 13.6667 13H10.3333C9.09337 13 8.47339 13 7.96472 12.8637C6.58436 12.4938 5.50617 11.4156 5.1363 10.0353C5 9.52661 5 8.90663 5 7.66667Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18 11C18.3716 11.5839 18.5574 11.8759 18.689 12.1897C18.8062 12.4694 18.8913 12.7615 18.9425 13.0604C19 13.3959 19 13.7419 19 14.4341V16C19 18.8284 19 20.2426 18.1213 21.1213C17.2426 22 15.8284 22 13 22H11C8.17157 22 6.75736 22 5.87868 21.1213C5 20.2426 5 18.8284 5 16V14.4341C5 13.7419 5 13.3959 5.0575 13.0604C5.10874 12.7615 5.1938 12.4694 5.31105 12.1897C5.44263 11.8759 5.62842 11.5839 6 11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M5 20C4.32352 20 3.98528 20 3.70219 19.922C3.08287 19.7512 2.58068 19.3162 2.34157 18.7433C2.23227 18.4815 2.19862 18.1593 2.1313 17.515L2.06691 16.8986C1.98995 16.1619 1.95147 15.7936 2.1089 15.5209C2.46075 14.9115 3.25125 15.0052 3.85704 15.0052H5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M19 20C19.6765 20 20.0147 20 20.2978 19.9219C20.9171 19.751 21.4193 19.3155 21.6584 18.742C21.7677 18.4799 21.8014 18.1574 21.8687 17.5124L21.9331 16.8954C21.9955 16.2975 22.1529 15.5626 21.5709 15.1773C21.3031 15 20.9164 15 20.143 15H19',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M9 14.5L9 13.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M15 14.5L15 13.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd': 'M15 5C15 3.34315 13.6569 2 12 2C10.3431 2 9 3.34315 9 5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBackpack03' icon.
  static const List<List<dynamic>> backpack03 = strokeRoundedBackpack03;

  /// JSON structure for the 'strokeRoundedBackward01' icon.
  static const List<List<dynamic>> strokeRoundedBackward01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4.06492 12.6258C4.31931 13.8374 5.67295 14.7077 8.38024 16.4481C11.3247 18.3411 12.797 19.2876 13.9895 18.9229C14.3934 18.7994 14.7654 18.5823 15.0777 18.2876C16 17.4178 16 15.6118 16 12C16 8.38816 16 6.58224 15.0777 5.71235C14.7654 5.41773 14.3934 5.20057 13.9895 5.07707C12.797 4.71243 11.3247 5.6589 8.38024 7.55186C5.67295 9.29233 4.31931 10.1626 4.06492 11.3742C3.97836 11.7865 3.97836 12.2135 4.06492 12.6258Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M20 5V19',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBackward01' icon.
  static const List<List<dynamic>> backward01 = strokeRoundedBackward01;

  /// JSON structure for the 'strokeRoundedBackward02' icon.
  static const List<List<dynamic>> strokeRoundedBackward02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.16293 12.9178C2.4453 13.6884 3.29859 14.3047 5.00518 15.5372C7.33231 17.218 8.49587 18.0583 9.4688 17.9969C10.2118 17.9499 10.9024 17.6007 11.3777 17.0315C12 16.2863 12 14.8575 12 12C12 9.14246 12 7.71369 11.3777 6.96846C10.9024 6.39933 10.2118 6.0501 9.4688 6.00315C8.49587 5.94167 7.33231 6.78203 5.00518 8.46275C3.29859 9.6953 2.4453 10.3116 2.16293 11.0822C1.94569 11.675 1.94569 12.325 2.16293 12.9178Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12.1629 12.9178C12.4453 13.6884 13.2986 14.3047 15.0052 15.5372C17.3323 17.218 18.4959 18.0583 19.4688 17.9969C20.2118 17.9499 20.9024 17.6007 21.3777 17.0315C22 16.2863 22 14.8575 22 12C22 9.14246 22 7.71369 21.3777 6.96846C20.9024 6.39933 20.2118 6.0501 19.4688 6.00315C18.4959 5.94167 17.3323 6.78203 15.0052 8.46275C13.2986 9.6953 12.4453 10.3116 12.1629 11.0822C11.9457 11.675 11.9457 12.325 12.1629 12.9178Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBackward02' icon.
  static const List<List<dynamic>> backward02 = strokeRoundedBackward02;

  /// JSON structure for the 'strokeRoundedBacteria' icon.
  static const List<List<dynamic>> strokeRoundedBacteria = [
    [
      'circle',
      {
        'key': '0',
        'cx': '12',
        'cy': '12',
        'r': '10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'circle',
      {
        'key': '1',
        'cx': '15',
        'cy': '8',
        'r': '2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M6 12.5L6.20943 12.735C6.59836 13.1714 7.25402 13.052 7.5 12.5C7.74598 11.948 8.40164 11.8286 8.79057 12.265L9 12.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M15.8413 18L15.9521 17.6549C16.1579 17.014 15.6742 16.4273 15 16.5C14.3258 16.5727 13.8421 15.986 14.0479 15.3451L14.1587 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M19.009 13H19',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M9.00896 17H9',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd': 'M8.00896 8H8',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBacteria' icon.
  static const List<List<dynamic>> bacteria = strokeRoundedBacteria;

  /// JSON structure for the 'strokeRoundedBadminton' icon.
  static const List<List<dynamic>> strokeRoundedBadminton = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.39114 21.6387C1.81409 21.0816 1.8854 20.1398 2.53981 19.6752L6.17145 17.097C6.38333 16.9465 6.6739 16.9737 6.85404 17.1607C7.02764 17.3409 7.0488 17.6183 6.90454 17.8226L4.3387 21.4558C3.88384 22.0999 2.95883 22.1867 2.39114 21.6387Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M11.5 12.5L7 17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M19.4291 12.5774C17.534 14.4725 13.869 14.5529 11.6581 12.3419C9.44711 10.131 9.52748 6.46597 11.4226 4.57087C13.912 2.08144 18.5975 0.980641 20.8084 3.19159C23.0194 5.40254 21.9186 10.088 19.4291 12.5774Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBadminton' icon.
  static const List<List<dynamic>> badminton = strokeRoundedBadminton;

  /// JSON structure for the 'strokeRoundedBadmintonShuttle' icon.
  static const List<List<dynamic>> strokeRoundedBadmintonShuttle = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3.92723 4.37944C5.01307 3.80898 6.45414 3.52865 7.89521 4.2222C9.94761 1.25927 14.0524 1.25926 16.1048 4.2222C17.5458 3.52867 18.9868 3.80902 20.0727 4.37943C20.575 4.64333 20.8262 4.77528 20.9545 5.15246C21.0827 5.52964 20.9298 5.84896 20.6241 6.48759L16.2167 15.6944C16.0084 16.1294 15.9043 16.347 15.8558 16.5489C15.8073 16.7508 15.794 17.3092 15.7674 18.4261C15.7215 20.3525 14.4794 22 12 22C9.52061 22 8.27855 20.3525 8.23262 18.4261C8.20598 17.3092 8.19267 16.7508 8.14418 16.5489C8.0957 16.347 7.99157 16.1294 7.7833 15.6944L3.37585 6.48751C3.07015 5.84891 2.9173 5.52962 3.04553 5.15244C3.17377 4.77527 3.42492 4.64333 3.92723 4.37944Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M8 17H16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M8 4L11 17M16 4L13 17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M6 12C7.2 13.3333 8.8 13.3334 10 12C11.2 13.3333 12.8 13.3334 14 12C15.2 13.3333 16.8 13.3334 18 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBadmintonShuttle' icon.
  static const List<List<dynamic>> badmintonShuttle =
      strokeRoundedBadmintonShuttle;

  /// JSON structure for the 'strokeRoundedBalanceScale' icon.
  static const List<List<dynamic>> strokeRoundedBalanceScale = [
    [
      'circle',
      {
        'key': '0',
        'cx': '12',
        'cy': '5',
        'r': '2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M10 5H4M14 5H20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M17 21H7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M12 7V21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M22 14C22 15.6569 20.6569 17 19 17C17.3431 17 16 15.6569 16 14M22 14L19.5 8H18.5L16 14M22 14H16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd':
            'M8 14C8 15.6569 6.65685 17 5 17C3.34315 17 2 15.6569 2 14M8 14L5.5 8H4.5L2 14M8 14H2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBalanceScale' icon.
  static const List<List<dynamic>> balanceScale = strokeRoundedBalanceScale;

  /// JSON structure for the 'strokeRoundedBalloons' icon.
  static const List<List<dynamic>> strokeRoundedBalloons = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M15.5 6.5C15.5 8.98528 13.933 11 12 11C10.067 11 8.5 8.98528 8.5 6.5C8.5 4.01472 10.067 2 12 2C13.933 2 15.5 4.01472 15.5 6.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M22 15.5C22 17.9853 20.433 20 18.5 20C16.567 20 15 17.9853 15 15.5C15 13.0147 16.567 11 18.5 11C20.433 11 22 13.0147 22 15.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M11.9978 11C11.9978 11 12.6526 13 11.9985 15C10.4013 19.8831 12.0001 22 12.0001 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M18.5 20C18.5 20.5 18.4 21.6 18 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M2 15.5C2 17.9853 3.567 20 5.5 20C7.433 20 9 17.9853 9 15.5C9 13.0147 7.433 11 5.5 11C3.567 11 2 13.0147 2 15.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M5.5 20C5.5 20.5 5.6 21.6 6 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBalloons' icon.
  static const List<List<dynamic>> balloons = strokeRoundedBalloons;

  /// JSON structure for the 'strokeRoundedBanana' icon.
  static const List<List<dynamic>> strokeRoundedBanana = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M14 11.9171C16 10.9087 18.478 11.7529 19.5777 14.1858C21.2282 17.8369 17.7619 21.8826 14.0077 21.9975C13.8997 22.0008 13.7859 21.9824 13.6861 21.9409C10.9391 20.7977 17.4719 16.7411 15.3319 14.5481',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12.2591 13C12.753 11.1383 11.9705 9.25852 9.99515 9.72396C8.79898 10.0058 8.51642 10.8832 7.79305 10.9566C7.23113 11.0137 6.88441 10.372 7.03542 9.83562C8.1091 6.02216 15.5 6.03124 15.5 10.0073',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M14.0009 18.9084C11.807 19.9994 7.12675 20.6141 5.01867 19.0798C4.44082 18.6592 3.69853 18.7865 3.0238 18.7865C1.38828 18.7865 1.84992 15.5993 3.43752 16.2134C3.99904 16.4306 5.0201 16.7126 5.78158 16.281C10.6831 13.5034 15.9947 13.024 17.7464 5.71395C18.5261 2.46023 18.7506 2 20.0529 2C21.3553 2 22.9193 5.00117 21.3265 9.95847C20.9057 11.2678 20.4081 12.5772 19.6965 13.7991',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBanana' icon.
  static const List<List<dynamic>> banana = strokeRoundedBanana;

  /// JSON structure for the 'strokeRoundedBandage' icon.
  static const List<List<dynamic>> strokeRoundedBandage = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M13.9525 4.84083C15.1797 3.61361 15.7933 3 16.5558 3C17.3183 3 17.9319 3.61361 19.1592 4.84083C20.3864 6.06806 21 6.68167 21 7.44417C21 8.20667 20.3864 8.82028 19.1592 10.0475M10.0475 19.1592C8.82028 20.3864 8.20667 21 7.44417 21C6.68167 21 6.06806 20.3864 4.84084 19.1592C3.61361 17.9319 3 17.3183 3 16.5558C3 15.7933 3.61361 15.1797 4.84084 13.9525',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M6.79333 12L4.84084 10.0475C3.61361 8.82028 3 8.20667 3 7.44417C3 6.68167 3.61361 6.06806 4.84084 4.84083C6.06806 3.61361 6.68167 3 7.44417 3C8.20667 3 8.82028 3.61361 10.0475 4.84083L12 6.79333M6.79333 12L12 6.79333M6.79333 12L12 17.2067M12 6.79333L17.2067 12M17.2067 12L19.1592 13.9525C20.3864 15.1797 21 15.7933 21 16.5558C21 17.3183 20.3864 17.9319 19.1592 19.1592C17.9319 20.3864 17.3183 21 16.5558 21C15.7933 21 15.1797 20.3864 13.9525 19.1592L12 17.2067M17.2067 12L12 17.2067',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBandage' icon.
  static const List<List<dynamic>> bandage = strokeRoundedBandage;

  /// JSON structure for the 'strokeRoundedBank' icon.
  static const List<List<dynamic>> strokeRoundedBank = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2 8.56907C2 7.37289 2.48238 6.63982 3.48063 6.08428L7.58987 3.79744C9.7431 2.59915 10.8197 2 12 2C13.1803 2 14.2569 2.59915 16.4101 3.79744L20.5194 6.08428C21.5176 6.63982 22 7.3729 22 8.56907C22 8.89343 22 9.05561 21.9646 9.18894C21.7785 9.88945 21.1437 10 20.5307 10H3.46928C2.85627 10 2.22152 9.88944 2.03542 9.18894C2 9.05561 2 8.89343 2 8.56907Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M11.9959 7H12.0049',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M4 10V18.5M8 10V18.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M16 10V18.5M20 10V18.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M19 18.5H5C3.34315 18.5 2 19.8431 2 21.5C2 21.7761 2.22386 22 2.5 22H21.5C21.7761 22 22 21.7761 22 21.5C22 19.8431 20.6569 18.5 19 18.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBank' icon.
  static const List<List<dynamic>> bank = strokeRoundedBank;

  /// JSON structure for the 'strokeRoundedBarChart' icon.
  static const List<List<dynamic>> strokeRoundedBarChart = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M14 18V6C14 5.53501 14 5.30252 13.9489 5.11177C13.8102 4.59413 13.4059 4.18981 12.8882 4.05111C12.6975 4 12.465 4 12 4C11.535 4 11.3025 4 11.1118 4.05111C10.5941 4.18981 10.1898 4.59413 10.0511 5.11177C10 5.30252 10 5.53501 10 6V18C10 18.465 10 18.6975 10.0511 18.8882C10.1898 19.4059 10.5941 19.8102 11.1118 19.9489C11.3025 20 11.535 20 12 20C12.465 20 12.6975 20 12.8882 19.9489C13.4059 19.8102 13.8102 19.4059 13.9489 18.8882C14 18.6975 14 18.465 14 18Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M21 8V6C21 5.53501 21 5.30252 20.9489 5.11177C20.8102 4.59413 20.4059 4.18981 19.8882 4.05111C19.6975 4 19.465 4 19 4C18.535 4 18.3025 4 18.1118 4.05111C17.5941 4.18981 17.1898 4.59413 17.0511 5.11177C17 5.30252 17 5.53501 17 6V8C17 8.46499 17 8.69748 17.0511 8.88823C17.1898 9.40587 17.5941 9.81019 18.1118 9.94889C18.3025 10 18.535 10 19 10C19.465 10 19.6975 10 19.8882 9.94889C20.4059 9.81019 20.8102 9.40587 20.9489 8.88823C21 8.69748 21 8.46499 21 8Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M7 12V6C7 5.53501 7 5.30252 6.94889 5.11177C6.81019 4.59413 6.40587 4.18981 5.88823 4.05111C5.69748 4 5.46499 4 5 4C4.53501 4 4.30252 4 4.11177 4.05111C3.59413 4.18981 3.18981 4.59413 3.05111 5.11177C3 5.30252 3 5.53501 3 6V12C3 12.465 3 12.6975 3.05111 12.8882C3.18981 13.4059 3.59413 13.8102 4.11177 13.9489C4.30252 14 4.53501 14 5 14C5.46499 14 5.69748 14 5.88823 13.9489C6.40587 13.8102 6.81019 13.4059 6.94889 12.8882C7 12.6975 7 12.465 7 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBarChart' icon.
  static const List<List<dynamic>> barChart = strokeRoundedBarChart;

  /// JSON structure for the 'strokeRoundedBarChartHorizontal' icon.
  static const List<List<dynamic>> strokeRoundedBarChartHorizontal = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3 4V14C3 16.8284 3 18.2426 3.87868 19.1213C4.75736 20 6.17157 20 9 20H21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M7 16L16 16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M7 12L20 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M7 8L13 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBarChartHorizontal' icon.
  static const List<List<dynamic>> barChartHorizontal =
      strokeRoundedBarChartHorizontal;

  /// JSON structure for the 'strokeRoundedBarCode01' icon.
  static const List<List<dynamic>> strokeRoundedBarCode01 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M3 4V20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M7.5 4V17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 4V17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M16.5 4V17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M21 4V20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M7.49981 20H7.50879',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd': 'M11.9998 20H12.0088',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '7',
        'd': 'M16.4998 20H16.5088',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBarCode01' icon.
  static const List<List<dynamic>> barCode01 = strokeRoundedBarCode01;

  /// JSON structure for the 'strokeRoundedBarCode02' icon.
  static const List<List<dynamic>> strokeRoundedBarCode02 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M2 4V20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M5 4V20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M15 4V20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M8 18V6C8 5.05719 8 4.58579 8.29289 4.29289C8.58579 4 9.05719 4 10 4C10.9428 4 11.4142 4 11.7071 4.29289C12 4.58579 12 5.05719 12 6V18C12 18.9428 12 19.4142 11.7071 19.7071C11.4142 20 10.9428 20 10 20C9.05719 20 8.58579 20 8.29289 19.7071C8 19.4142 8 18.9428 8 18Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M18 18V6C18 5.05719 18 4.58579 18.2929 4.29289C18.5858 4 19.0572 4 20 4C20.9428 4 21.4142 4 21.7071 4.29289C22 4.58579 22 5.05719 22 6V18C22 18.9428 22 19.4142 21.7071 19.7071C21.4142 20 20.9428 20 20 20C19.0572 20 18.5858 20 18.2929 19.7071C18 19.4142 18 18.9428 18 18Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBarCode02' icon.
  static const List<List<dynamic>> barCode02 = strokeRoundedBarCode02;

  /// JSON structure for the 'strokeRoundedBarns' icon.
  static const List<List<dynamic>> strokeRoundedBarns = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4.36271 6.29582L3.34475 8.60655C3.17301 8.9964 3.08714 9.19133 3.04357 9.39845C3 9.60558 3 9.81889 3 10.2455V19.9823C3 20.9335 3 21.4091 3.29289 21.7046C3.58579 22.0001 4.05719 22.0001 5 22.0001H19C19.9428 22.0001 20.4142 22.0001 20.7071 21.7046C21 21.4091 21 20.9335 21 19.9823V9.83734C21 9.36317 21 9.12608 20.9465 8.89743C20.893 8.66878 20.7879 8.45672 20.5777 8.03261L19.6553 6.17136C19.3311 5.51721 19.169 5.19013 18.9108 4.94458C18.6527 4.69903 18.3196 4.55498 17.6532 4.26688L13.5757 2.50385C12.7989 2.16799 12.4105 2.00006 12 2.00006C11.5895 2.00006 11.2011 2.16799 10.4243 2.50385L6.44228 4.22558C5.72974 4.53367 5.37347 4.68771 5.10422 4.95575C4.83498 5.22378 4.67755 5.58113 4.36271 6.29582Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M7 22V13M17 13V22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M7 13L17 22M7 22L17 13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M3 13H21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M12 10C13.1046 10 14 9.10457 14 8C14 6.89543 13.1046 6 12 6C10.8954 6 10 6.89543 10 8C10 9.10457 10.8954 10 12 10Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBarns' icon.
  static const List<List<dynamic>> barns = strokeRoundedBarns;

  /// JSON structure for the 'strokeRoundedBaseball' icon.
  static const List<List<dynamic>> strokeRoundedBaseball = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12 22C12 21.8136 11.9949 21.6285 11.9848 21.4446M2 12C2.2062 12 2.41094 12.0062 2.61405 12.0185M5.34028 12.5715C5.67469 12.69 6.00092 12.8257 6.3179 12.9777M8.68574 14.5634C8.94563 14.7972 9.1932 15.0445 9.42736 15.304M11.0417 17.7227C11.181 18.0168 11.3065 18.3188 11.4172 18.6278',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M12 2C12 2.18635 12.0051 2.37152 12.0152 2.55535M22 12C21.7938 12 21.5891 11.9938 21.3859 11.9815M18.6597 11.4285C18.3253 11.31 17.9991 11.1743 17.6821 11.0223M15.3143 9.43657C15.0544 9.20277 14.8068 8.95554 14.5726 8.69597M12.9583 6.27732C12.819 5.98322 12.6935 5.68123 12.5828 5.3722',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBaseball' icon.
  static const List<List<dynamic>> baseball = strokeRoundedBaseball;

  /// JSON structure for the 'strokeRoundedBaseballBat' icon.
  static const List<List<dynamic>> strokeRoundedBaseballBat = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5.45946 20L20.5567 8.68934C22.3317 7.30882 22.495 4.68503 20.905 3.09501C19.315 1.50499 16.6912 1.66834 15.3107 3.4433L4 18.5405',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M5.57835 21.8426C7.08033 19.7713 4.24567 16.9109 2.15723 18.4251C1.96763 18.5625 1.94595 18.8368 2.11159 19.0023L5.00015 21.8884C5.16597 22.0541 5.44077 22.0323 5.57835 21.8426Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M10 17L7 14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'circle',
      {
        'key': '3',
        'cx': '2.5',
        'cy': '2.5',
        'r': '2.5',
        'transform': 'matrix(-1 0 0 1 21 16)',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBaseballBat' icon.
  static const List<List<dynamic>> baseballBat = strokeRoundedBaseballBat;

  /// JSON structure for the 'strokeRoundedBaseballHelmet' icon.
  static const List<List<dynamic>> strokeRoundedBaseballHelmet = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M19.5 8.5C18 5 14.9924 3 11.4046 3C6.21058 3 2 7.24151 2 12.4737C2 15.8912 3.79635 18.886 6.48977 20.5523C7.06928 20.9108 7.54664 21 8.22657 21H14.763C16.1727 21 17.3155 19.8807 17.3155 18.5C17.3155 17.1193 16.1727 16 14.763 16C14.3687 16 13.6311 16.1485 13.3534 15.8267C13.2038 15.6533 13.2359 15.4366 13.3 15.0031C13.7388 12.0363 16.2376 11.5 19.4564 11.5C20.2168 11.5 20.9772 10.655 21.5235 9.86188C21.9052 9.30765 22.096 9.03053 21.952 8.76527C21.808 8.5 21.4444 8.5 20.7171 8.5H19.5ZM19.5 8.5H15.0693',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M15.0078 18.5L14.9988 18.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBaseballHelmet' icon.
  static const List<List<dynamic>> baseballHelmet = strokeRoundedBaseballHelmet;

  /// JSON structure for the 'strokeRoundedBash' icon.
  static const List<List<dynamic>> strokeRoundedBash = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M7 7L8.22654 8.05719C8.74218 8.50163 9 8.72386 9 9C9 9.27614 8.74218 9.49836 8.22654 9.94281L7 11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M11 11H14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M12 21C15.7497 21 17.6246 21 18.9389 20.0451C19.3634 19.7367 19.7367 19.3634 20.0451 18.9389C21 17.6246 21 15.7497 21 12C21 8.25027 21 6.3754 20.0451 5.06107C19.7367 4.6366 19.3634 4.26331 18.9389 3.95491C17.6246 3 15.7497 3 12 3C8.25027 3 6.3754 3 5.06107 3.95491C4.6366 4.26331 4.26331 4.6366 3.95491 5.06107C3 6.3754 3 8.25027 3 12C3 15.7497 3 17.6246 3.95491 18.9389C4.26331 19.3634 4.6366 19.7367 5.06107 20.0451C6.3754 21 8.25027 21 12 21Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBash' icon.
  static const List<List<dynamic>> bash = strokeRoundedBash;

  /// JSON structure for the 'strokeRoundedBasketball01' icon.
  static const List<List<dynamic>> strokeRoundedBasketball01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M2 12.9506C8.14512 13.5607 13.5577 8.11477 12.9506 2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M11.0507 22.0012C10.4406 15.856 15.8866 10.4434 22.0013 11.0505',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M17 20C17 12.8203 11.1797 7 4 7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBasketball01' icon.
  static const List<List<dynamic>> basketball01 = strokeRoundedBasketball01;

  /// JSON structure for the 'strokeRoundedBasketball02' icon.
  static const List<List<dynamic>> strokeRoundedBasketball02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M2 12C4.28031 14.4289 7.91083 16 12 16C16.0892 16 19.7197 14.4289 22 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 2V22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M5.1556 5C4.77388 6.5 5.04007 9 6.56621 11C8.1708 13.1028 9.18243 16 5.36932 19',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M18.8444 5C19.2261 6.5 18.9599 9 17.4338 11C15.8292 13.1028 14.8176 16 18.6307 19',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBasketball02' icon.
  static const List<List<dynamic>> basketball02 = strokeRoundedBasketball02;

  /// JSON structure for the 'strokeRoundedBasketballHoop' icon.
  static const List<List<dynamic>> strokeRoundedBasketballHoop = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5 17C4.37188 16.8651 3.87905 16.6488 3.46243 16.3018C3.25989 16.1331 3.07418 15.9446 2.90796 15.7391C2 14.6163 2 12.9481 2 9.61164C2 6.27522 2 4.60701 2.90796 3.48419C3.07418 3.27864 3.25989 3.09016 3.46243 2.92147C4.56878 2 6.21252 2 9.5 2H14.5C17.7875 2 19.4312 2 20.5376 2.92147C20.7401 3.09016 20.9258 3.27864 21.092 3.48419C22 4.60701 22 6.27522 22 9.61164C22 12.9481 22 14.6163 21.092 15.7391C20.9258 15.9446 20.7401 16.1331 20.5376 16.3018C20.1209 16.6488 19.6281 16.8651 19 17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M6 13H7.33333M7.33333 13L8.5 22M7.33333 13H12M18 13H16.6667M16.6667 13L15.5 22M16.6667 13H12M12 13V22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M8 10C8.05893 8.04825 9.26181 8 10.9978 8H13.0022C14.7382 8 15.9411 8.04825 16 10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M8 16.5H16M8.44444 20H15.5556',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBasketballHoop' icon.
  static const List<List<dynamic>> basketballHoop = strokeRoundedBasketballHoop;

  /// JSON structure for the 'strokeRoundedBathtub01' icon.
  static const List<List<dynamic>> strokeRoundedBathtub01 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M6 20L5 21M18 20L19 21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M3 12V13C3 16.2998 3 17.9497 4.02513 18.9749C5.05025 20 6.70017 20 10 20H14C17.2998 20 18.9497 20 19.9749 18.9749C21 17.9497 21 16.2998 21 13V12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M2 12H22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M4 12V5.5234C4 4.12977 5.12977 3 6.5234 3C7.64166 3 8.62654 3.73598 8.94339 4.80841L9 5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M8 6L10.5 4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBathtub01' icon.
  static const List<List<dynamic>> bathtub01 = strokeRoundedBathtub01;

  /// JSON structure for the 'strokeRoundedBathtub02' icon.
  static const List<List<dynamic>> strokeRoundedBathtub02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M22 12H15C14.3509 12 13.7193 11.7895 13.2 11.4L10.8 9.6C10.2807 9.21053 9.64911 9 9 9H2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M3 9V11C3 14.7712 3 16.6569 4.17157 17.8284C5.34315 19 7.22876 19 11 19H14C16.8089 19 18.2134 19 19.2223 18.3259C19.659 18.034 20.034 17.659 20.3259 17.2223C21 16.2134 21 14.8089 21 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M18 19V21M6 19V21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M5 9V4.5C5 3.67157 5.67157 3 6.5 3C7.32843 3 8 3.67157 8 4.5V5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBathtub02' icon.
  static const List<List<dynamic>> bathtub02 = strokeRoundedBathtub02;

  /// JSON structure for the 'strokeRoundedBatteriesEnergy' icon.
  static const List<List<dynamic>> strokeRoundedBatteriesEnergy = [
    [
      'path',
      {
        'key': '0',
        'd': 'M12.5 2L10 6H14L11.5 10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M17 6C17.9428 6 18.4142 6 18.7071 6.29289C19 6.58579 19 7.05719 19 8V10.5M7 6C6.05719 6 5.58579 6 5.29289 6.29289C5 6.58579 5 7.05719 5 8L5 10.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M20 13H18C17.0572 13 16.5858 13 16.2929 13.2929C16 13.5858 16 14.0572 16 15V20C16 20.9428 16 21.4142 16.2929 21.7071C16.5858 22 17.0572 22 18 22H20C20.9428 22 21.4142 22 21.7071 21.7071C22 21.4142 22 20.9428 22 20V15C22 14.0572 22 13.5858 21.7071 13.2929C21.4142 13 20.9428 13 20 13Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M16 19H22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M16 16L22 16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd':
            'M6 13H4C3.05719 13 2.58579 13 2.29289 13.2929C2 13.5858 2 14.0572 2 15V20C2 20.9428 2 21.4142 2.29289 21.7071C2.58579 22 3.05719 22 4 22H6C6.94281 22 7.41421 22 7.70711 21.7071C8 21.4142 8 20.9428 8 20V15C8 14.0572 8 13.5858 7.70711 13.2929C7.41421 13 6.94281 13 6 13Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd': 'M2 19H8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '7',
        'd': 'M2 16L8 16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBatteriesEnergy' icon.
  static const List<List<dynamic>> batteriesEnergy =
      strokeRoundedBatteriesEnergy;

  /// JSON structure for the 'strokeRoundedBatteryCharging01' icon.
  static const List<List<dynamic>> strokeRoundedBatteryCharging01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2 12C2 9.17157 2 7.75736 2.87868 6.87868C3.75736 6 5.17157 6 8 6H13C15.8284 6 17.2426 6 18.1213 6.87868C19 7.75736 19 9.17157 19 12C19 14.8284 19 16.2426 18.1213 17.1213C17.2426 18 15.8284 18 13 18H8C5.17157 18 3.75736 18 2.87868 17.1213C2 16.2426 2 14.8284 2 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M10.8282 9L9.08572 11.1749C8.89899 11.4079 9.03283 11.7433 9.33733 11.8053L11.1627 12.1773C11.4873 12.2434 11.6111 12.6147 11.3842 12.8413L9.22216 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M19 9.5L20.0272 9.6712C20.7085 9.78475 21.0491 9.84152 21.3076 10.0067C21.5618 10.1691 21.7612 10.4044 21.8796 10.6819C22 10.964 22 11.3093 22 12C22 12.6907 22 13.036 21.8796 13.3181C21.7612 13.5956 21.5618 13.8309 21.3076 13.9933C21.0491 14.1585 20.7085 14.2153 20.0272 14.3288L19 14.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBatteryCharging01' icon.
  static const List<List<dynamic>> batteryCharging01 =
      strokeRoundedBatteryCharging01;

  /// JSON structure for the 'strokeRoundedBatteryCharging02' icon.
  static const List<List<dynamic>> strokeRoundedBatteryCharging02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M8 6C5.17157 6 3.75736 6 2.87868 6.87868C2 7.75736 2 9.17157 2 12C2 14.8284 2 16.2426 2.87868 17.1213C3.44798 17.6906 4.24209 17.8911 5.5 17.9616M12 17.9827L13 18C15.8284 18 17.2426 18 18.1213 17.1213C19 16.2426 19 14.8284 19 12C19 9.17157 19 7.75736 18.1213 6.87868C17.414 6.17137 16.3597 6.03342 14.5 6.00652',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M11.5623 6L8.59169 10.4367C8.13166 11.1237 7.90164 11.4673 8.03989 11.7336C8.17814 12 8.58645 12 9.40307 12H10.5969C11.4136 12 11.8219 12 11.9601 12.2664C12.0984 12.5327 11.8683 12.8763 11.4083 13.5633L8.43769 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M19 9.5L20.0272 9.6712C20.7085 9.78475 21.0491 9.84152 21.3076 10.0067C21.5618 10.1691 21.7612 10.4044 21.8796 10.6819C22 10.964 22 11.3093 22 12C22 12.6907 22 13.036 21.8796 13.3181C21.7612 13.5956 21.5618 13.8309 21.3076 13.9933C21.0491 14.1585 20.7085 14.2153 20.0272 14.3288L19 14.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBatteryCharging02' icon.
  static const List<List<dynamic>> batteryCharging02 =
      strokeRoundedBatteryCharging02;

  /// JSON structure for the 'strokeRoundedBatteryEcoCharging' icon.
  static const List<List<dynamic>> strokeRoundedBatteryEcoCharging = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M8 19H13C15.8284 19 17.2426 19 18.1213 18.1213C19 17.2426 19 15.8284 19 13C19 11.1366 19 9.887 18.7488 8.99997M5.5 7.0383C4.24209 7.10888 3.44798 7.30933 2.87868 7.87863C2 8.75731 2 10.1715 2 13C2 15.2437 2 16.5975 2.43866 17.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M19 10.5L20.0272 10.6712C20.7085 10.7847 21.0491 10.8415 21.3076 11.0066C21.5618 11.169 21.7612 11.4044 21.8796 11.6818C22 11.9639 22 12.3093 22 13C22 13.6906 22 14.036 21.8796 14.3181C21.7612 14.5955 21.5618 14.8309 21.3076 14.9933C21.0491 15.1584 20.7085 15.2152 20.0272 15.3287L19 15.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M5.03319 20C4.54502 14.6 9.00032 13.5 11.0002 11M11.0339 15.8353C13.5787 15.1243 15.2108 13.4224 15.8162 10.8483C16.502 7.93305 15.2725 3.96327 12.1026 4.00026C12.1026 4.00026 12.4253 5.25961 12.143 5.8764C11.1022 8.15057 7.50025 7.99259 6.3325 10.8769C5.63711 12.4908 6.05765 14.2938 7.36616 15.3279C8.18838 15.9778 9.81192 16.1767 11.0339 15.8353Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBatteryEcoCharging' icon.
  static const List<List<dynamic>> batteryEcoCharging =
      strokeRoundedBatteryEcoCharging;

  /// JSON structure for the 'strokeRoundedBatteryEmpty' icon.
  static const List<List<dynamic>> strokeRoundedBatteryEmpty = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2 12C2 9.17157 2 7.75736 2.87868 6.87868C3.75736 6 5.17157 6 8 6H13C15.8284 6 17.2426 6 18.1213 6.87868C19 7.75736 19 9.17157 19 12C19 14.8284 19 16.2426 18.1213 17.1213C17.2426 18 15.8284 18 13 18H8C5.17157 18 3.75736 18 2.87868 17.1213C2 16.2426 2 14.8284 2 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M19 9.5L20.0272 9.6712C20.7085 9.78475 21.0491 9.84152 21.3076 10.0067C21.5618 10.1691 21.7612 10.4044 21.8796 10.6819C22 10.964 22 11.3093 22 12C22 12.6907 22 13.036 21.8796 13.3181C21.7612 13.5956 21.5618 13.8309 21.3076 13.9933C21.0491 14.1585 20.7085 14.2153 20.0272 14.3288L19 14.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBatteryEmpty' icon.
  static const List<List<dynamic>> batteryEmpty = strokeRoundedBatteryEmpty;

  /// JSON structure for the 'strokeRoundedBatteryFull' icon.
  static const List<List<dynamic>> strokeRoundedBatteryFull = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2 12C2 9.17157 2 7.75736 2.87868 6.87868C3.75736 6 5.17157 6 8 6H13C15.8284 6 17.2426 6 18.1213 6.87868C19 7.75736 19 9.17157 19 12C19 14.8284 19 16.2426 18.1213 17.1213C17.2426 18 15.8284 18 13 18H8C5.17157 18 3.75736 18 2.87868 17.1213C2 16.2426 2 14.8284 2 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M19 9.5L20.0272 9.6712C20.7085 9.78475 21.0491 9.84152 21.3076 10.0067C21.5618 10.1691 21.7612 10.4044 21.8796 10.6819C22 10.964 22 11.3093 22 12C22 12.6907 22 13.036 21.8796 13.3181C21.7612 13.5956 21.5618 13.8309 21.3076 13.9933C21.0491 14.1585 20.7085 14.2153 20.0272 14.3288L19 14.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M6 10V14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M9 10V14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M12 10V14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M15 10V14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBatteryFull' icon.
  static const List<List<dynamic>> batteryFull = strokeRoundedBatteryFull;

  /// JSON structure for the 'strokeRoundedBatteryLow' icon.
  static const List<List<dynamic>> strokeRoundedBatteryLow = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2 12C2 9.17157 2 7.75736 2.87868 6.87868C3.75736 6 5.17157 6 8 6H13C15.8284 6 17.2426 6 18.1213 6.87868C19 7.75736 19 9.17157 19 12C19 14.8284 19 16.2426 18.1213 17.1213C17.2426 18 15.8284 18 13 18H8C5.17157 18 3.75736 18 2.87868 17.1213C2 16.2426 2 14.8284 2 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M19 9.5L20.0272 9.6712C20.7085 9.78475 21.0491 9.84152 21.3076 10.0067C21.5618 10.1691 21.7612 10.4044 21.8796 10.6819C22 10.964 22 11.3093 22 12C22 12.6907 22 13.036 21.8796 13.3181C21.7612 13.5956 21.5618 13.8309 21.3076 13.9933C21.0491 14.1585 20.7085 14.2153 20.0272 14.3288L19 14.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M6 10V14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBatteryLow' icon.
  static const List<List<dynamic>> batteryLow = strokeRoundedBatteryLow;

  /// JSON structure for the 'strokeRoundedBatteryMedium01' icon.
  static const List<List<dynamic>> strokeRoundedBatteryMedium01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2 12C2 9.17157 2 7.75736 2.87868 6.87868C3.75736 6 5.17157 6 8 6H13C15.8284 6 17.2426 6 18.1213 6.87868C19 7.75736 19 9.17157 19 12C19 14.8284 19 16.2426 18.1213 17.1213C17.2426 18 15.8284 18 13 18H8C5.17157 18 3.75736 18 2.87868 17.1213C2 16.2426 2 14.8284 2 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M19 9.5L20.0272 9.6712C20.7085 9.78475 21.0491 9.84152 21.3076 10.0067C21.5618 10.1691 21.7612 10.4044 21.8796 10.6819C22 10.964 22 11.3093 22 12C22 12.6907 22 13.036 21.8796 13.3181C21.7612 13.5956 21.5618 13.8309 21.3076 13.9933C21.0491 14.1585 20.7085 14.2153 20.0272 14.3288L19 14.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M6 10V14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M9 10V14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBatteryMedium01' icon.
  static const List<List<dynamic>> batteryMedium01 =
      strokeRoundedBatteryMedium01;

  /// JSON structure for the 'strokeRoundedBatteryMedium02' icon.
  static const List<List<dynamic>> strokeRoundedBatteryMedium02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2 12C2 9.17157 2 7.75736 2.87868 6.87868C3.75736 6 5.17157 6 8 6H13C15.8284 6 17.2426 6 18.1213 6.87868C19 7.75736 19 9.17157 19 12C19 14.8284 19 16.2426 18.1213 17.1213C17.2426 18 15.8284 18 13 18H8C5.17157 18 3.75736 18 2.87868 17.1213C2 16.2426 2 14.8284 2 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M19 9.5L20.0272 9.6712C20.7085 9.78475 21.0491 9.84152 21.3076 10.0067C21.5618 10.1691 21.7612 10.4044 21.8796 10.6819C22 10.964 22 11.3093 22 12C22 12.6907 22 13.036 21.8796 13.3181C21.7612 13.5956 21.5618 13.8309 21.3076 13.9933C21.0491 14.1585 20.7085 14.2153 20.0272 14.3288L19 14.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M6 10V14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M9 10V14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M12 10V14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBatteryMedium02' icon.
  static const List<List<dynamic>> batteryMedium02 =
      strokeRoundedBatteryMedium02;

  /// JSON structure for the 'strokeRoundedBbqGrill' icon.
  static const List<List<dynamic>> strokeRoundedBbqGrill = [
    [
      'path',
      {
        'key': '0',
        'd': 'M9 15L6 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M15 15L18 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 15L12 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M15.5556 6C16.1481 5.44772 16.1481 4.55228 15.5556 4C14.963 3.44772 14.963 2.55228 15.5556 2M12 6C12.5926 5.44772 12.5926 4.55228 12 4C11.4074 3.44772 11.4074 2.55228 12 2M8.44444 6C9.03704 5.44772 9.03704 4.55228 8.44444 4C7.85185 3.44772 7.85185 2.55228 8.44444 2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M7.5 19H16.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd':
            'M12 15C15.5371 15 18.4632 12.3908 18.9485 8.99703C19.0107 8.56215 19.0418 8.3447 18.8918 8.17235C18.7419 8 18.5001 8 18.0164 8H5.98359C5.49992 8 5.25809 8 5.10816 8.17235C4.95823 8.3447 4.98933 8.56215 5.05151 8.99703C5.53679 12.3908 8.46285 15 12 15Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd': 'M19 10H20M5 10H4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBbqGrill' icon.
  static const List<List<dynamic>> bbqGrill = strokeRoundedBbqGrill;

  /// JSON structure for the 'strokeRoundedBeach' icon.
  static const List<List<dynamic>> strokeRoundedBeach = [
    [
      'path',
      {
        'key': '0',
        'd': 'M2 15.7501C2 15.7501 3.79534 15 7 15C12 15 16 18 22 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M2 21H22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M12.594 3.22761C9.74838 4.04368 7.89871 6.85224 8.0043 9.87504C8.02623 10.5029 8.03719 10.8168 8.30546 10.9556C8.57373 11.0944 8.85218 10.8977 9.40908 10.5041L10.6506 9.6268C10.8371 9.49503 11.0585 9.43155 11.2815 9.44587L14.1977 9.63321L16.6357 7.91042C16.8222 7.77865 17.0435 7.71517 17.2666 7.7295L18.7879 7.82723C19.4407 7.86916 19.7671 7.89013 19.9291 7.63883C20.0912 7.38753 19.9594 7.11583 19.6959 6.57242C18.3856 3.86989 15.4553 2.40707 12.594 3.22761Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M14.5 9.5L16.5 17M12.2857 3L12 2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBeach' icon.
  static const List<List<dynamic>> beach = strokeRoundedBeach;

  /// JSON structure for the 'strokeRoundedBeach02' icon.
  static const List<List<dynamic>> strokeRoundedBeach02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M21 21C18.8012 19.7735 15.5841 19 12 19C8.41592 19 5.19883 19.7735 3 21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M9.5 6.45068C7.83333 6.11465 5 6.45068 3.5 9.48348M9.5 6.45068C10.5 6.95471 11.5 8.47764 11.5 12M9.5 6.45068C12 5.94657 15 7.47125 15 11.4968M9.5 6.45068C8.5 4.43502 6.5 2.94235 3 4.95391',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M9.5 6.5C8.5 8.33333 6.5 13.5 6.5 19.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'circle',
      {
        'key': '3',
        'cx': '19',
        'cy': '5',
        'r': '2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBeach02' icon.
  static const List<List<dynamic>> beach02 = strokeRoundedBeach02;

  /// JSON structure for the 'strokeRoundedBeater' icon.
  static const List<List<dynamic>> strokeRoundedBeater = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6.5 5H17.5C18.9045 5 19.6067 5 20.1111 5.33706C20.3295 5.48298 20.517 5.67048 20.6629 5.88886C21 6.39331 21 7.09554 21 8.5C21 9.90446 21 10.6067 20.6629 11.1111C20.517 11.3295 20.3295 11.517 20.1111 11.6629C19.6067 12 18.9045 12 17.5 12H6.5C5.09554 12 4.39331 12 3.88886 11.6629C3.67048 11.517 3.48298 11.3295 3.33706 11.1111C3 10.6067 3 9.90446 3 8.5C3 7.09554 3 6.39331 3.33706 5.88886C3.48298 5.67048 3.67048 5.48298 3.88886 5.33706C4.39331 5 5.09554 5 6.5 5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M17.5 16H15.5C14.6716 16 14 16.6716 14 17.5V19.5C14 20.3284 14.6716 21 15.5 21H17.5C18.3284 21 19 20.3284 19 19.5V17.5C19 16.6716 18.3284 16 17.5 16Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M16.5 22V21M16.5 12V16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M8 2H15C15.9319 2 16.3978 2 16.7654 2.15224C17.2554 2.35523 17.6448 2.74458 17.8478 3.23463C18 3.60218 18 4.06812 18 5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M17 8.5H16.991M13.009 8.5H13',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBeater' icon.
  static const List<List<dynamic>> beater = strokeRoundedBeater;

  /// JSON structure for the 'strokeRoundedBebo' icon.
  static const List<List<dynamic>> strokeRoundedBebo = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12 18C14.2091 18 16 16.2091 16 14C16 11.9 14.6758 10.5691 12.5661 10.1461C11.713 9.97507 11 9.29474 11 8.42476C11 7.11978 12.0676 6.03085 13.3523 6.26034C17.4783 6.99743 20 9.75593 20 14C20 18.4183 16.4183 22 12 22C7.58172 22 4 18.4183 4 14V4C4 2.89543 4.89543 2 6 2C7.10457 2 8 2.89543 8 4V14C8 16.2091 9.79086 18 12 18Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBebo' icon.
  static const List<List<dynamic>> bebo = strokeRoundedBebo;

  /// JSON structure for the 'strokeRoundedBed' icon.
  static const List<List<dynamic>> strokeRoundedBed = [
    [
      'path',
      {
        'key': '0',
        'd': 'M2 3.5V20.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M22 8.5L22 20.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M2 8.5L6 10.5H22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M2 15.5H6M22 15.5H19',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M6 10.5V16.5C6 18.1547 6.34533 18.5 8 18.5H17C18.6547 18.5 19 18.1547 19 16.5V10.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd':
            'M6.81362 10.5C6.89385 10.076 7.0202 9.63248 6.99567 9.19713C6.95941 8.5536 6.63697 7.96625 6.1264 7.61368C5.92478 7.47446 5.48 7.33239 5.01268 7.21093C4.3308 7.0337 3.98986 6.94508 3.59142 7.03644C3.30841 7.10133 3.06258 7.25187 2.71115 7.52079C2.67243 7.55042 2.65307 7.56523 2.62289 7.59026C2.3843 7.78812 2.17276 8.07424 2.05352 8.36034C2.03844 8.39653 2.02562 8.43102 2 8.5V8.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBed' icon.
  static const List<List<dynamic>> bed = strokeRoundedBed;

  /// JSON structure for the 'strokeRoundedBedBunk' icon.
  static const List<List<dynamic>> strokeRoundedBedBunk = [
    [
      'path',
      {
        'key': '0',
        'd': 'M2 11H17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M2 8H22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M6.5 5C5.8956 5 5.32433 5.1287 4.81768 5.35753C4.48573 5.50746 4.31975 5.58242 4.15988 5.83005C4 6.07769 4 6.32443 4 6.8179V8H9V6.8179C9 6.32443 9 6.07769 8.84013 5.83005C8.68025 5.58242 8.51427 5.50746 8.18232 5.35753C7.67567 5.1287 7.1044 5 6.5 5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M6.5 14C5.79893 14 5.14245 14.1732 4.57968 14.4749C4.47363 14.5317 4.4206 14.5602 4.33052 14.6414C4.20736 14.7524 4.06861 14.9842 4.02898 15.1452C4 15.2629 4 15.3595 4 15.5525C4 15.9692 4 16.1776 4.06113 16.3443C4.16232 16.6202 4.37978 16.8377 4.65572 16.9389C4.82243 17 5.03079 17 5.44751 17H7.55249C7.96921 17 8.17757 17 8.34428 16.9389C8.62022 16.8377 8.83768 16.6202 8.93887 16.3443C9 16.1776 9 15.9692 9 15.5525C9 15.3595 9 15.2629 8.97102 15.1452C8.93139 14.9842 8.79263 14.7524 8.66948 14.6414C8.5794 14.5602 8.52637 14.5317 8.42032 14.4749C7.85755 14.1732 7.20107 14 6.5 14Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M2 17H17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M2 20H22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd': 'M17 12L22 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '7',
        'd': 'M17 15L22 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '8',
        'd': 'M22 4L22 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '9',
        'd': 'M17 4L17 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '10',
        'd': 'M2 4L2 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBedBunk' icon.
  static const List<List<dynamic>> bedBunk = strokeRoundedBedBunk;

  /// JSON structure for the 'strokeRoundedBedDouble' icon.
  static const List<List<dynamic>> strokeRoundedBedDouble = [
    [
      'path',
      {
        'key': '0',
        'd': 'M22 17.5H2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M22 21V16C22 14.1144 22 13.1716 21.4142 12.5858C20.8284 12 19.8856 12 18 12H6C4.11438 12 3.17157 12 2.58579 12.5858C2 13.1716 2 14.1144 2 16V21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M11 12V10.2134C11 9.83272 10.9428 9.70541 10.6497 9.55538C10.0395 9.24292 9.29865 9 8.5 9C7.70135 9 6.96055 9.24292 6.35025 9.55538C6.05721 9.70541 6 9.83272 6 10.2134L6 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M18 12V10.2134C18 9.83272 17.9428 9.70541 17.6497 9.55538C17.0395 9.24292 16.2987 9 15.5 9C14.7013 9 13.9605 9.24292 13.3503 9.55538C13.0572 9.70541 13 9.83272 13 10.2134L13 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M21 12V7.36057C21 6.66893 21 6.32311 20.8079 5.99653C20.6157 5.66995 20.342 5.50091 19.7944 5.16283C17.5869 3.79978 14.8993 3 12 3C9.10067 3 6.41314 3.79978 4.20558 5.16283C3.65804 5.50091 3.38427 5.66995 3.19213 5.99653C3 6.32311 3 6.66893 3 7.36057V12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBedDouble' icon.
  static const List<List<dynamic>> bedDouble = strokeRoundedBedDouble;

  /// JSON structure for the 'strokeRoundedBedSingle01' icon.
  static const List<List<dynamic>> strokeRoundedBedSingle01 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M22 17.5H2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M22 21V16C22 14.1144 22 13.1716 21.4142 12.5858C20.8284 12 19.8856 12 18 12H6C4.11438 12 3.17157 12 2.58579 12.5858C2 13.1716 2 14.1144 2 16V21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M16 12V10.6178C16 10.1103 15.9085 9.94054 15.4396 9.7405C14.4631 9.32389 13.2778 9 12 9C10.7222 9 9.53688 9.32389 8.5604 9.7405C8.09154 9.94054 8 10.1103 8 10.6178L8 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M20 12V7.36057C20 6.66893 20 6.32311 19.8292 5.99653C19.6584 5.66995 19.4151 5.50091 18.9284 5.16283C16.9661 3.79978 14.5772 3 12 3C9.42282 3 7.03391 3.79978 5.07163 5.16283C4.58492 5.50091 4.34157 5.66995 4.17079 5.99653C4 6.32311 4 6.66893 4 7.36057V12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBedSingle01' icon.
  static const List<List<dynamic>> bedSingle01 = strokeRoundedBedSingle01;

  /// JSON structure for the 'strokeRoundedBedSingle02' icon.
  static const List<List<dynamic>> strokeRoundedBedSingle02 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M22 17.5H2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M22 21V16C22 14.1144 22 13.1716 21.4142 12.5858C20.8284 12 19.8856 12 18 12H6C4.11438 12 3.17157 12 2.58579 12.5858C2 13.1716 2 14.1144 2 16V21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M16 12V10.6178C16 10.1103 15.9085 9.94054 15.4396 9.7405C14.4631 9.32389 13.2778 9 12 9C10.7222 9 9.53688 9.32389 8.5604 9.7405C8.09154 9.94054 8 10.1103 8 10.6178L8 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M3 12V9C3 7.58579 3 6.87868 3.43934 6.43934C3.87868 6 4.58579 6 6 6C6.27475 6 6.65685 6.07272 6.90282 5.94012C7.0139 5.88025 7.11349 5.72888 7.31269 5.42616C8.26921 3.97247 10.2246 3 12 3C13.7754 3 15.7308 3.97247 16.6873 5.42616C16.8865 5.72888 16.9861 5.88025 17.0972 5.94012C17.3432 6.07272 17.7252 6 18 6C19.4142 6 20.1213 6 20.5607 6.43934C21 6.87868 21 7.58579 21 9V12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBedSingle02' icon.
  static const List<List<dynamic>> bedSingle02 = strokeRoundedBedSingle02;

  /// JSON structure for the 'strokeRoundedBedug01' icon.
  static const List<List<dynamic>> strokeRoundedBedug01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5 16C6.10457 16 7 12.866 7 9C7 5.13401 6.10457 2 5 2C3.89543 2 3 5.13401 3 9C3 12.866 3.89543 16 5 16Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M8.5 15.5L16 22M8 22L18 10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M5 2L16.1103 3.58719C19.1126 4.01608 21 5.73626 21 9C21 11.0222 20.065 13.3797 18 14.0512M5 16L14.0942 14.7008M8.83195 2.54742C9.56585 4.09552 10.123 6.18217 10.0113 9.56933C9.93575 11.2861 9.68691 13.6615 8.85527 15.4492',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBedug01' icon.
  static const List<List<dynamic>> bedug01 = strokeRoundedBedug01;

  /// JSON structure for the 'strokeRoundedBedug02' icon.
  static const List<List<dynamic>> strokeRoundedBedug02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M22 10C22 6.13401 20.5 4 18 3C16.5342 2.37764 14.6088 2 12.5 2C10.3912 2 8.46579 2.37764 7 3',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M7 3C8.46579 2.37764 10.3912 2 12.5 2C14.6088 2 16.5342 2.37764 18 3C20.5 4 22 6.13401 22 10C22 13.866 20.5 16 18 17C16.5342 17.6224 14.6088 18 12.5 18C10.3912 18 8.46579 17.6224 7 17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M9 22L18 13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M2 15L7 10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M3 10C3 6.13401 4.79086 3 7 3C9.20914 3 11 6.13401 11 10C11 13.866 9.20914 17 7 17C5.51321 17 4.21588 15.5804 3.52643 13.4736',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M6.99981 10H7.00879',
        'stroke': 'currentColor',
        'strokeWidth': '3',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd': 'M18 22L16 20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBedug02' icon.
  static const List<List<dynamic>> bedug02 = strokeRoundedBedug02;

  /// JSON structure for the 'strokeRoundedBehance01' icon.
  static const List<List<dynamic>> strokeRoundedBehance01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2 12H7.625M7.4 5H4C3.05719 5 2.58579 5 2.29289 5.29289C2 5.58579 2 6.05719 2 7V17C2 17.9428 2 18.4142 2.29289 18.7071C2.58579 19 3.05719 19 4 19H7.4C9.38823 19 11 17.433 11 15.5C11 13.567 9.38823 12 7.4 12C9.38823 12 11 10.433 11 8.5C11 6.567 9.38823 5 7.4 5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M20 7H16M14 14H22C22 11.9587 20.2091 10 18 10C15.7909 10 14 11.9587 14 14ZM14 14V15C14 17.2091 15.7909 19 18 19C19.4806 19 20.7733 18.1956 21.4649 17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBehance01' icon.
  static const List<List<dynamic>> behance01 = strokeRoundedBehance01;

  /// JSON structure for the 'strokeRoundedBehance02' icon.
  static const List<List<dynamic>> strokeRoundedBehance02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M6.75085 11.985V9.00492C6.75085 8.72282 6.9824 8.49414 7.26802 8.49414H9.24582C9.68571 8.49414 10.1378 8.56982 10.4656 8.8595C10.8163 9.16935 11.1564 9.64935 11.1395 10.2909C11.1199 11.0391 10.5736 11.9234 9.77316 11.985C8.97271 12.0466 8.22065 11.985 6.75085 11.985ZM6.75085 11.985V14.9675C6.75085 15.2496 6.98243 15.478 7.26804 15.4808C8.40871 15.4917 9.07239 15.5322 9.77316 15.4783C10.5736 15.4166 11.1199 14.5323 11.1395 13.7841C11.1564 13.1426 10.8163 12.6626 10.4656 12.3527C10.1378 12.063 9.68571 11.9873 9.24582 11.9873L6.75085 11.985ZM16.7954 14.9655C16.3572 15.3901 14.2227 16.2293 13.4537 14.0205C13.3738 13.8 13.3102 13.3244 13.3473 12.957M13.3473 12.957C13.4106 12.3314 13.6867 11.4539 14.7115 11.0958C16.1791 10.583 17.102 12.0065 17.341 12.957H13.3473ZM14.5888 9.00095H15.949',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBehance02' icon.
  static const List<List<dynamic>> behance02 = strokeRoundedBehance02;

  /// JSON structure for the 'strokeRoundedBelt' icon.
  static const List<List<dynamic>> strokeRoundedBelt = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M8.9751 17.9655C12.4619 17.5232 16 16.3318 16 12C16 7.66817 12.4619 6.47683 8.9751 6.0345C6.62063 5.73582 6 7.41975 6 9.41154V14.5885C6 16.5803 6.62063 18.2642 8.9751 17.9655Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M2 7.5H6M2 16.5H6M14 7.5H22M14 16.5L22 16.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M5 12H10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M19.9998 12H20.0088',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBelt' icon.
  static const List<List<dynamic>> belt = strokeRoundedBelt;

  /// JSON structure for the 'strokeRoundedBendTool' icon.
  static const List<List<dynamic>> strokeRoundedBendTool = [
    [
      'circle',
      {
        'key': '0',
        'cx': '19',
        'cy': '4',
        'r': '2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'circle',
      {
        'key': '1',
        'cx': '5',
        'cy': '20',
        'r': '2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M5 18C5 10 10 4 17 4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBendTool' icon.
  static const List<List<dynamic>> bendTool = strokeRoundedBendTool;

  /// JSON structure for the 'strokeRoundedBerlin' icon.
  static const List<List<dynamic>> strokeRoundedBerlin = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2 5.3H9M15 5.3H22M22 9.7H16.4396C15.3109 9.7 14.7465 9.7 14.4465 9.29739C14.1464 8.89478 14.2571 8.28603 14.4784 7.06855L14.5216 6.83145C14.7429 5.61397 14.8536 5.00522 14.5535 4.60261C14.2535 4.2 13.6891 4.2 12.5604 4.2H11.4396C10.3109 4.2 9.74652 4.2 9.44646 4.60261C9.1464 5.00522 9.25709 5.61397 9.47845 6.83145L9.52155 7.06855C9.74291 8.28603 9.8536 8.89478 9.55354 9.29739C9.25348 9.7 8.68912 9.7 7.56039 9.7H2M13.5 4.2C13.5 3.65 13.7 2.44 14.5 2M10.5 4.2C10.5 3.65 10.3 2.44 9.5 2M3 5.3V22M21 5.3V22M18 9.7V22M15 22V9.7H9V22M6 9.7V22M2 22H22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBerlin' icon.
  static const List<List<dynamic>> berlin = strokeRoundedBerlin;

  /// JSON structure for the 'strokeRoundedBerlinTower' icon.
  static const List<List<dynamic>> strokeRoundedBerlinTower = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M16 9C16 11.2091 14.2091 13 12 13C9.79086 13 8 11.2091 8 9C8 6.79086 9.79086 5 12 5C14.2091 5 16 6.79086 16 9Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M9.5 12.5C9.5 14.5 8 20 7 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M14.5 12.5C14.5 14.5 16 20 17 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M12 5L12 2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M9 16H15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBerlinTower' icon.
  static const List<List<dynamic>> berlinTower = strokeRoundedBerlinTower;

  /// JSON structure for the 'strokeRoundedBeta' icon.
  static const List<List<dynamic>> strokeRoundedBeta = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12.8831 10.2C15.1353 10.2 16.961 8.58822 16.961 6.6C16.961 4.61177 15.1353 3 12.8831 3C10.6309 3 8.80516 4.61177 8.80516 6.6V19.2C8.80516 20.1941 7.89228 21 6.76619 21C6.01148 21 5.35255 20.638 5 20.1M8.80516 14.7C8.80516 17.1853 11.0874 19.2 13.9026 19.2C16.7178 19.2 19 17.1853 19 14.7C19 12.2147 16.7178 10.0866 13.9026 10.0866',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBeta' icon.
  static const List<List<dynamic>> beta = strokeRoundedBeta;

  /// JSON structure for the 'strokeRoundedBicycle' icon.
  static const List<List<dynamic>> strokeRoundedBicycle = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6 19.9986C8.20914 19.9986 10 18.2112 10 16.0063C10 13.8014 8.20914 12.0139 6 12.0139C3.79086 12.0139 2 13.8014 2 16.0063C2 18.2112 3.79086 19.9986 6 19.9986Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18 19.9986C20.2091 19.9986 22 18.2112 22 16.0063C22 13.8014 20.2091 12.0139 18 12.0139C15.7909 12.0139 14 13.8014 14 16.0063C14 18.2112 15.7909 19.9986 18 19.9986Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M6 16.0062H10.3706C10.7302 16.0062 11.0622 15.8135 11.2399 15.5014L15.5 8.02148',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M12 13.012L7 7.02344M7 7.02344H5M7 7.02344H9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M18.0531 15.9709L14.8057 4.03097C16.2565 3.96037 19.3585 3.83085 19.9908 6.21002',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBicycle' icon.
  static const List<List<dynamic>> bicycle = strokeRoundedBicycle;

  /// JSON structure for the 'strokeRoundedBicycle01' icon.
  static const List<List<dynamic>> strokeRoundedBicycle01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6 20.0026C8.20914 20.0026 10 18.2118 10 16.0026C10 13.7935 8.20914 12.0026 6 12.0026C3.79086 12.0026 2 13.7935 2 16.0026C2 18.2118 3.79086 20.0026 6 20.0026Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18 20.0026C20.2091 20.0026 22 18.2118 22 16.0026C22 13.7935 20.2091 12.0026 18 12.0026C15.7909 12.0026 14 13.7935 14 16.0026C14 18.2118 15.7909 20.0026 18 20.0026Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M6 16.0026H10.3706C10.7302 16.0026 11.0622 15.8095 11.2399 15.4968L15.5 8.00262',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M12 13.0026L7 7.00262M7 7.00262H5M7 7.00262H9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M20.0039 6.21868C19.7999 5.64268 19.4399 4.74268 18.2399 4.32268C17.4599 4.02268 15.5399 3.90268 15.2999 4.08268C14.9527 4.16949 14.9399 4.56268 15.1079 5.10268C15.2444 5.68163 15.4559 6.42824 15.6479 7.14268C16.1399 8.97348 17.2199 12.9387 18.0239 15.9987',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBicycle01' icon.
  static const List<List<dynamic>> bicycle01 = strokeRoundedBicycle01;

  /// JSON structure for the 'strokeRoundedBilliard01' icon.
  static const List<List<dynamic>> strokeRoundedBilliard01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M8.07089 10C8.02417 9.6734 8 9.33952 8 9C8 5.13401 11.134 2 15 2C18.866 2 22 5.13401 22 9C22 12.866 18.866 16 15 16C14.7024 16 14.4091 15.9814 14.1212 15.9454',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M18.8684 10C19.2035 8.6899 18.8933 7.01849 18 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M2 19.0966L10.2253 11.5568M4.90338 22L12.6046 13.5987M12.6046 13.5987C12.6046 12.3221 11.677 11.3543 10.2253 11.5568M12.6046 13.5987L14.6243 11.3954C15.1414 10.8312 15.1225 9.95985 14.5813 9.41868C14.0402 8.87752 13.1688 8.85858 12.6046 9.37573L10.2253 11.5568',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBilliard01' icon.
  static const List<List<dynamic>> billiard01 = strokeRoundedBilliard01;

  /// JSON structure for the 'strokeRoundedBilliard02' icon.
  static const List<List<dynamic>> strokeRoundedBilliard02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12 12C11.1716 12 10.5 12.5596 10.5 13.25C10.5 13.9404 11.1716 14.5 12 14.5C12.8284 14.5 13.5 13.9404 13.5 13.25C13.5 12.5596 12.8284 12 12 12ZM12 12C12.8284 12 13.5 11.4404 13.5 10.75C13.5 10.0596 12.8284 9.5 12 9.5C11.1716 9.5 10.5 10.0596 10.5 10.75C10.5 11.4404 11.1716 12 12 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M19 12C19 15.866 15.866 19 12 19C8.13401 19 5 15.866 5 12C5 8.13401 8.13401 5 12 5C15.866 5 19 8.13401 19 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBilliard02' icon.
  static const List<List<dynamic>> billiard02 = strokeRoundedBilliard02;

  /// JSON structure for the 'strokeRoundedBinaryCode' icon.
  static const List<List<dynamic>> strokeRoundedBinaryCode = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2 6C2 5.05719 2 4.58579 2.29289 4.29289C2.58579 4 3.05719 4 4 4C4.94281 4 5.41421 4 5.70711 4.29289C6 4.58579 6 5.05719 6 6V8C6 8.94281 6 9.41421 5.70711 9.70711C5.41421 10 4.94281 10 4 10C3.05719 10 2.58579 10 2.29289 9.70711C2 9.41421 2 8.94281 2 8V6Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M6.5 16C6.5 15.0572 6.5 14.5858 6.79289 14.2929C7.08579 14 7.55719 14 8.5 14C9.44281 14 9.91421 14 10.2071 14.2929C10.5 14.5858 10.5 15.0572 10.5 16V18C10.5 18.9428 10.5 19.4142 10.2071 19.7071C9.91421 20 9.44281 20 8.5 20C7.55719 20 7.08579 20 6.79289 19.7071C6.5 19.4142 6.5 18.9428 6.5 18V16Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M13.5 6C13.5 5.05719 13.5 4.58579 13.7929 4.29289C14.0858 4 14.5572 4 15.5 4C16.4428 4 16.9142 4 17.2071 4.29289C17.5 4.58579 17.5 5.05719 17.5 6V8C17.5 8.94281 17.5 9.41421 17.2071 9.70711C16.9142 10 16.4428 10 15.5 10C14.5572 10 14.0858 10 13.7929 9.70711C13.5 9.41421 13.5 8.94281 13.5 8V6Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M13.5 16C13.5 15.0572 13.5 14.5858 13.7929 14.2929C14.0858 14 14.5572 14 15.5 14C16.4428 14 16.9142 14 17.2071 14.2929C17.5 14.5858 17.5 15.0572 17.5 16V18C17.5 18.9428 17.5 19.4142 17.2071 19.7071C16.9142 20 16.4428 20 15.5 20C14.5572 20 14.0858 20 13.7929 19.7071C13.5 19.4142 13.5 18.9428 13.5 18V16Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M9 5L10.5 4V10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M2 15L3.5 14V20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd': 'M20.5 5L22 4V10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '7',
        'd': 'M20.5 15L22 14V20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBinaryCode' icon.
  static const List<List<dynamic>> binaryCode = strokeRoundedBinaryCode;

  /// JSON structure for the 'strokeRoundedBing' icon.
  static const List<List<dynamic>> strokeRoundedBing = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4 18.4705V3.32143C4 2.57781 4 2.20599 4.23713 2.05571C4.47427 1.90543 4.79858 2.07171 5.44721 2.40427L7.44721 3.42969C7.71617 3.56759 7.85065 3.63654 7.92533 3.76044C8 3.88433 8 4.03851 8 4.34686V15.2766C8 16.0625 8 16.4554 8.24904 16.6036C8.49807 16.7518 8.83076 16.5568 9.49614 16.167L14.2232 13.3971C14.5572 13.2014 14.7242 13.1035 14.7114 12.9712C14.6986 12.8389 14.5162 12.7766 14.1513 12.6518L12.5208 12.0945C12.2661 12.0075 12.1388 11.9639 12.0516 11.8675C11.9645 11.771 11.932 11.6375 11.8669 11.3704L11.4164 9.5227C11.2311 8.7628 11.1385 8.38285 11.3443 8.17718C11.5502 7.97152 11.9182 8.07634 12.6542 8.28598L18.5353 9.96116C19.2399 10.1619 19.5923 10.2622 19.7961 10.5373C20 10.8123 20 11.1873 20 11.9372V13.8824C20 14.4602 20 14.7491 19.866 14.9871C19.7321 15.225 19.488 15.3695 19 15.6584L9.04083 21.5546C8.53376 21.8548 8.28022 22.0049 8.00292 21.9999C7.72561 21.9949 7.47735 21.8358 6.98083 21.5176L4.94 20.2096C4.48048 19.9151 4.25071 19.7679 4.12536 19.5359C4 19.304 4 19.0262 4 18.4705Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBing' icon.
  static const List<List<dynamic>> bing = strokeRoundedBing;

  /// JSON structure for the 'strokeRoundedBinoculars' icon.
  static const List<List<dynamic>> strokeRoundedBinoculars = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M21.8551 15.5L18.9298 5.60666C18.6485 4.65457 17.7646 4 16.7601 4C15.475 4 14.4485 5.05662 14.502 6.32437L15 16M22 16.5C22 18.433 20.433 20 18.5 20C16.567 20 15 18.433 15 16.5C15 14.567 16.567 13 18.5 13C20.433 13 22 14.567 22 16.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M10 8H14M9 16H15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M2.14494 15.5L5.07067 5.60666C5.35192 4.65457 6.23586 4 7.24034 4C8.52545 4 9.55194 5.05662 9.49844 6.32437L9.00044 16M9 16.5C9 18.433 7.433 20 5.5 20C3.567 20 2 18.433 2 16.5C2 14.567 3.567 13 5.5 13C7.433 13 9 14.567 9 16.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBinoculars' icon.
  static const List<List<dynamic>> binoculars = strokeRoundedBinoculars;

  /// JSON structure for the 'strokeRoundedBioEnergy' icon.
  static const List<List<dynamic>> strokeRoundedBioEnergy = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M7.51691 12H3.8974C3.46866 12 3.25429 12 3.12182 12.1371C2.98934 12.2742 2.99444 12.4858 3.00462 12.9091C3.01499 13.34 3.03966 13.7692 3.09832 14.1975C3.12255 14.3744 3.13466 14.4628 3.1927 14.5082C3.25075 14.5536 3.35607 14.5413 3.56672 14.5167C4.73441 14.3801 5.86167 15.3326 5.86167 16.5839C5.86167 17.2074 5.59266 17.767 5.16638 18.1489C5.01046 18.2885 4.9325 18.3584 4.92694 18.4317C4.92138 18.505 4.97764 18.5735 5.09015 18.7106C5.49816 19.2075 5.9569 19.6597 6.45825 20.059C6.57718 20.1537 6.63664 20.2011 6.70196 20.1992C6.76728 20.1973 6.83399 20.1376 6.96741 20.0183C7.32763 19.6962 7.79991 19.5009 8.317 19.5009C9.42587 19.5009 10.3136 20.4293 10.3606 21.5054C10.3684 21.684 10.3723 21.7732 10.4156 21.8217C10.4589 21.8703 10.533 21.8813 10.6812 21.9035C11.5421 22.0322 12.4579 22.0322 13.3188 21.9035C13.467 21.8813 13.5411 21.8703 13.5844 21.8217C13.6277 21.7732 13.6316 21.684 13.6394 21.5054C13.6864 20.4293 14.5741 19.5009 15.683 19.5009C16.2001 19.5009 16.6724 19.6962 17.0326 20.0183C17.166 20.1376 17.2327 20.1973 17.298 20.1992C17.3634 20.2011 17.4228 20.1537 17.5417 20.059C18.0431 19.6597 18.5018 19.2075 18.9098 18.7106C19.0224 18.5735 19.0786 18.505 19.0731 18.4317C19.0675 18.3584 18.9895 18.2885 18.8336 18.1489C18.4073 17.767 18.1383 17.2074 18.1383 16.5839C18.1383 15.3326 19.2656 14.3801 20.4333 14.5167C20.6439 14.5413 20.7493 14.5536 20.8073 14.5082C20.8653 14.4628 20.8775 14.3744 20.9017 14.1975C20.9603 13.7692 20.985 13.34 20.9954 12.9091C21.0056 12.4858 21.0107 12.2742 20.8782 12.1371C20.7457 12 20.5313 12 20.1026 12H16.4831C16.2763 14.3363 14.3481 16.1671 12 16.1671C9.65187 16.1671 7.72366 14.3363 7.51691 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M7 12H17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 12L12 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M11.7412 7.7412C12.2899 6.20331 11.9672 4.44278 10.7622 3.2378C9.55722 2.03282 7.79669 1.71006 6.2588 2.2588C5.71007 3.79669 6.03282 5.55722 7.2378 6.7622C8.44278 7.96718 10.2033 8.28993 11.7412 7.7412Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M12.2157 9.78433C11.7584 8.50276 12.0274 7.03565 13.0315 6.0315C14.0356 5.02735 15.5028 4.75839 16.7843 5.21567C17.2416 6.49725 16.9726 7.96435 15.9685 8.9685C14.9644 9.97265 13.4972 10.2416 12.2157 9.78433Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBioEnergy' icon.
  static const List<List<dynamic>> bioEnergy = strokeRoundedBioEnergy;

  /// JSON structure for the 'strokeRoundedBiomassEnergy' icon.
  static const List<List<dynamic>> strokeRoundedBiomassEnergy = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M20 14.4986C20 18.6415 16.4183 22 12 22C7.58172 22 4 18.6415 4 14.4986L4 14.2794C4 13.5451 4 13.178 4.25365 13.0433C4.80339 12.7515 6 14 6 14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M4 9.50139C4 5.35849 7.58172 2 12 2C16.4183 2 20 5.35849 20 9.50139V9.72063C20 10.4549 20 10.822 19.7463 10.9567C19.1966 11.2485 18 10 18 10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M11.9796 11.1605C11.2601 12.5841 10.7346 14.8928 11.5622 17.5M11.1431 15.0283C6.89727 12.0079 9.81401 8.53376 12.5599 6.78017C12.8913 6.56855 13.057 6.46274 13.2499 6.5119C13.4428 6.56106 13.5355 6.73406 13.7209 7.08005C15.2623 9.95702 16.3667 14.4893 11.1431 15.0283Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBiomassEnergy' icon.
  static const List<List<dynamic>> biomassEnergy = strokeRoundedBiomassEnergy;

  /// JSON structure for the 'strokeRoundedBiometricAccess' icon.
  static const List<List<dynamic>> strokeRoundedBiometricAccess = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4.26781 18.8447C4.49269 20.515 5.87613 21.8235 7.55966 21.9009C8.97627 21.966 10.4153 22 12 22C13.5847 22 15.0237 21.966 16.4403 21.9009C18.1239 21.8235 19.5073 20.515 19.7322 18.8447C19.879 17.7547 20 16.6376 20 15.5C20 14.3624 19.879 13.2453 19.7322 12.1553C19.5073 10.485 18.1239 9.17649 16.4403 9.09909C15.0237 9.03397 13.5847 9 12 9C10.4153 9 8.97627 9.03397 7.55966 9.09909C5.87613 9.17649 4.49269 10.485 4.26781 12.1553C4.12105 13.2453 4 14.3624 4 15.5C4 16.6376 4.12105 17.7547 4.26781 18.8447Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M7.5 9V6.5C7.5 4.01472 9.51472 2 12 2C14.4853 2 16.5 4.01472 16.5 6.5V9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M8 17.5V16C8 13.7909 9.79086 12 12 12C14.2091 12 16 13.7909 16 16V17.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M10.5 19V16C10.5 15.1716 11.1716 14.5 12 14.5C12.8284 14.5 13.5 15.1716 13.5 16M13.5 19V18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBiometricAccess' icon.
  static const List<List<dynamic>> biometricAccess =
      strokeRoundedBiometricAccess;

  /// JSON structure for the 'strokeRoundedBiometricDevice' icon.
  static const List<List<dynamic>> strokeRoundedBiometricDevice = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5 9C5 5.70017 5 4.05025 6.02513 3.02513C7.05025 2 8.70017 2 12 2C15.2998 2 16.9497 2 17.9749 3.02513C19 4.05025 19 5.70017 19 9V15C19 18.2998 19 19.9497 17.9749 20.9749C16.9497 22 15.2998 22 12 22C8.70017 22 7.05025 22 6.02513 20.9749C5 19.9497 5 18.2998 5 15V9Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M16 13V10.5C16 8.29086 14.2091 6.5 12 6.5C9.79086 6.5 8 8.29086 8 10.5V13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M13.5 11V10.5C13.5 9.67157 12.8284 9 12 9C11.1716 9 10.5 9.67157 10.5 10.5V14M13.5 13.5V15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M12 19V19.01',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBiometricDevice' icon.
  static const List<List<dynamic>> biometricDevice =
      strokeRoundedBiometricDevice;

  /// JSON structure for the 'strokeRoundedBirthdayCake' icon.
  static const List<List<dynamic>> strokeRoundedBirthdayCake = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M13.5 4.5C13.5 5.32843 12.8284 6 12 6C11.1716 6 10.5 5.32843 10.5 4.5C10.5 3.67157 12 2 12 2C12 2 13.5 3.67157 13.5 4.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M12 6V9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M17.6667 14C19.2315 14 20.5 12.8807 20.5 11.5C20.5 10.1193 19.2315 9 17.6667 9H6.33333C4.76853 9 3.5 10.1193 3.5 11.5C3.5 12.8807 4.76853 14 6.33333 14C7.70408 14 8.90415 13.1411 9.16667 12C9.42919 13.1411 10.6293 14 12 14C13.3707 14 14.5708 13.1411 14.8333 12C15.0959 13.1411 16.2959 14 17.6667 14Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M5 14L5.52089 16.5796C6.04532 19.1768 6.30754 20.4754 7.19608 21.2377C8.08462 22 9.33608 22 11.839 22H12.161C14.6639 22 15.9154 22 16.8039 21.2377C17.6925 20.4754 17.9547 19.1768 18.4791 16.5796L19 14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBirthdayCake' icon.
  static const List<List<dynamic>> birthdayCake = strokeRoundedBirthdayCake;

  /// JSON structure for the 'strokeRoundedBiscuit' icon.
  static const List<List<dynamic>> strokeRoundedBiscuit = [
    [
      'path',
      {
        'key': '0',
        'd': 'M14.0078 11L13.9988 11',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M8.00781 16L7.99883 16',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M6.24887 9.30307C5.79205 10.3381 5.98187 11.4892 6.67285 11.8741C7.36383 12.259 8.29431 11.7319 8.75113 10.6969C9.20795 9.66191 9.01813 8.51084 8.32715 8.12594C7.63617 7.74103 6.70569 8.26805 6.24887 9.30307Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M13.1766 15.8719C12.787 16.624 13.0636 17.5149 13.7945 17.8618C14.5254 18.2087 15.4338 17.8802 15.8234 17.1281C16.213 16.376 15.9364 15.4851 15.2055 15.1382C14.4746 14.7913 13.5662 15.1198 13.1766 15.8719Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C12.2417 2 12.3874 2.26355 12.2959 2.48729C12.1052 2.95395 12 3.4647 12 4C12 6.20914 13.7909 8 16 8C16.5478 8 17.0699 7.88988 17.5453 7.69056C17.7487 7.60533 18 7.77954 18 8C18 9.65685 19.3431 11 21 11C21.1138 11 21.2261 10.9937 21.3365 10.9813C21.6512 10.9462 21.9691 11.1463 21.9858 11.4625C21.9952 11.6405 22 11.8197 22 12C22 17.5228 17.5228 22 12 22Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBiscuit' icon.
  static const List<List<dynamic>> biscuit = strokeRoundedBiscuit;

  /// JSON structure for the 'strokeRoundedBitcoin' icon.
  static const List<List<dynamic>> strokeRoundedBitcoin = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6 4H14.4C16.3882 4 18 5.79086 18 8C18 10.2091 16.3882 12 14.4 12M14.4 12C16.3882 12 18 13.7909 18 16C18 18.2091 16.3882 20 14.4 20H6M14.4 12H7.2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M7 4V20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M9 2L9 4M14 2V4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M9 20L9 22M14 20V22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoin' icon.
  static const List<List<dynamic>> bitcoin = strokeRoundedBitcoin;

  /// JSON structure for the 'strokeRoundedBitcoin01' icon.
  static const List<List<dynamic>> strokeRoundedBitcoin01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12 2C6.47716 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12 5C8.13401 5 5 8.134 5 12C5 15.866 8.13401 19 12 19C15.866 19 19 15.866 19 12C19 8.13401 15.866 5 12 5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 2V5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M12 19V22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M3.33972 7L5.9378 8.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M18.0625 15.5L20.6606 17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd': 'M20.6603 7L18.0622 8.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '7',
        'd': 'M5.9375 15.5L3.33942 17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '8',
        'd':
            'M10.4375 14.6667L10.4375 9.33333M12 9.33333V8M12 16V14.6667M10.4375 12H13.5625M13.5625 12C14.0803 12 14.5 12.4477 14.5 13V13.6667C14.5 14.219 14.0803 14.6667 13.5625 14.6667H9.5M13.5625 12C14.0803 12 14.5 11.5523 14.5 11V10.3333C14.5 9.78105 14.0803 9.33333 13.5625 9.33333H9.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoin01' icon.
  static const List<List<dynamic>> bitcoin01 = strokeRoundedBitcoin01;

  /// JSON structure for the 'strokeRoundedBitcoin02' icon.
  static const List<List<dynamic>> strokeRoundedBitcoin02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12 7.99976C8.13401 7.99976 5 11.1338 5 14.9998C5 18.8657 8.13401 21.9998 12 21.9998C15.866 21.9998 19 18.8657 19 14.9998C19 11.1338 15.866 7.99976 12 7.99976Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12 2.74988V5.49988M11.25 2.74988C11.25 3.16409 11.5858 3.49988 12 3.49988C12.4142 3.49988 12.75 3.16409 12.75 2.74988C12.75 2.33566 12.4142 1.99988 12 1.99988C11.5858 1.99988 11.25 2.33566 11.25 2.74988Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M5.75 2.74988V5.49988L7 6.49988M5 2.74988C5 3.16409 5.33579 3.49988 5.75 3.49988C6.16421 3.49988 6.5 3.16409 6.5 2.74988C6.5 2.33566 6.16421 1.99988 5.75 1.99988C5.33579 1.99988 5 2.33566 5 2.74988Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M18.25 2.74988V5.49988L17 6.49988M19 2.74988C19 3.16409 18.6642 3.49988 18.25 3.49988C17.8358 3.49988 17.5 3.16409 17.5 2.74988C17.5 2.33566 17.8358 1.99988 18.25 1.99988C18.6642 1.99988 19 2.33566 19 2.74988Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M10.4375 17.6667L10.4375 12.3333M12 12.3333V11M12 19V17.6667M10.4375 15H13.5625M13.5625 15C14.0803 15 14.5 15.4477 14.5 16V16.6667C14.5 17.219 14.0803 17.6667 13.5625 17.6667H9.5M13.5625 15C14.0803 15 14.5 14.5523 14.5 14V13.3333C14.5 12.781 14.0803 12.3333 13.5625 12.3333H9.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoin02' icon.
  static const List<List<dynamic>> bitcoin02 = strokeRoundedBitcoin02;

  /// JSON structure for the 'strokeRoundedBitcoin03' icon.
  static const List<List<dynamic>> strokeRoundedBitcoin03 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M19.7453 13C20.5362 11.8662 21 10.4872 21 9C21 5.13401 17.866 2 14 2C10.134 2 7 5.134 7 9C7 10.0736 7.24169 11.0907 7.67363 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12.4375 11.6667L12.4375 6.33333M14 6.33333V5M14 13V11.6667M12.4375 9H15.5625M15.5625 9C16.0803 9 16.5 9.44772 16.5 10V10.6667C16.5 11.219 16.0803 11.6667 15.5625 11.6667H11.5M15.5625 9C16.0803 9 16.5 8.55228 16.5 8V7.33333C16.5 6.78105 16.0803 6.33333 15.5625 6.33333H11.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M3 14H5.39482C5.68897 14 5.97908 14.0663 6.24217 14.1936L8.28415 15.1816C8.54724 15.3089 8.83735 15.3751 9.1315 15.3751H10.1741C11.1825 15.3751 12 16.1662 12 17.142C12 17.1814 11.973 17.2161 11.9338 17.2269L9.39287 17.9295C8.93707 18.0555 8.449 18.0116 8.025 17.8064L5.84211 16.7503M12 16.5L16.5928 15.0889C17.407 14.8352 18.2871 15.136 18.7971 15.8423C19.1659 16.3529 19.0157 17.0842 18.4785 17.3942L10.9629 21.7305C10.4849 22.0063 9.92094 22.0736 9.39516 21.9176L3 20.0199',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoin03' icon.
  static const List<List<dynamic>> bitcoin03 = strokeRoundedBitcoin03;

  /// JSON structure for the 'strokeRoundedBitcoin04' icon.
  static const List<List<dynamic>> strokeRoundedBitcoin04 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M13.9447 18.1667V12.8333M15.5072 12.8333V11.5M15.5072 19.5V18.1667M13.9447 15.5H17.0697M17.0697 15.5C17.5875 15.5 18.0072 15.9477 18.0072 16.5V17.1667C18.0072 17.719 17.5875 18.1667 17.0697 18.1667H13.0072M17.0697 15.5C17.5875 15.5 18.0072 15.0523 18.0072 14.5V13.8333C18.0072 13.281 17.5875 12.8333 17.0697 12.8333H13.0072',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M15.5024 9C11.9139 9 9.00476 11.9101 9.00476 15.5C9.00476 19.0898 11.9139 22 15.5024 22C19.0909 22 22.0001 19.0899 22.0001 15.5C22.0001 11.9101 19.0909 9 15.5024 9Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M8.00503 6C11.3175 6 14.0029 5.10457 14.0029 4C14.0029 2.89543 11.3175 2 8.00503 2C4.69252 2 2.0072 2.89543 2.0072 4C2.0072 5.10457 4.69252 6 8.00503 6Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M1.99988 4V8.02171V12.0434C1.99988 12.7473 3.17893 13.6328 6.13218 14M2.10721 8.54768C3.31228 9.60965 5.46077 10.0602 7.75693 10.0602M13.9955 4.12134V6.13597',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoin04' icon.
  static const List<List<dynamic>> bitcoin04 = strokeRoundedBitcoin04;

  /// JSON structure for the 'strokeRoundedBitcoinBag' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinBag = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M20.9427 16.8354C20.2864 12.8866 18.2432 9.94613 16.467 8.219C15.9501 7.71642 15.6917 7.46513 15.1208 7.23257C14.5499 7 14.0592 7 13.0778 7H10.9222C9.94081 7 9.4501 7 8.87922 7.23257C8.30834 7.46513 8.04991 7.71642 7.53304 8.219C5.75682 9.94613 3.71361 12.8866 3.05727 16.8354C2.56893 19.7734 5.27927 22 8.30832 22H15.6917C18.7207 22 21.4311 19.7734 20.9427 16.8354Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M10.125 17.5L10.125 11.5M12 11.5V10M12 19V17.5M10.125 14.5H13.875M13.875 14.5C14.4963 14.5 15 15.0037 15 15.625V16.375C15 16.9963 14.4963 17.5 13.875 17.5H9M13.875 14.5C14.4963 14.5 15 13.9963 15 13.375V12.625C15 12.0037 14.4963 11.5 13.875 11.5H9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M7.25662 4.44287C7.05031 4.14258 6.75128 3.73499 7.36899 3.64205C8.00392 3.54651 8.66321 3.98114 9.30855 3.97221C9.89237 3.96413 10.1898 3.70519 10.5089 3.33548C10.8449 2.94617 11.3652 2 12 2C12.6348 2 13.1551 2.94617 13.4911 3.33548C13.8102 3.70519 14.1076 3.96413 14.6914 3.97221C15.3368 3.98114 15.9961 3.54651 16.631 3.64205C17.2487 3.73499 16.9497 4.14258 16.7434 4.44287L15.8105 5.80064C15.4115 6.38146 15.212 6.67187 14.7944 6.83594C14.3769 7 13.8373 7 12.7582 7H11.2418C10.1627 7 9.6231 7 9.20556 6.83594C8.78802 6.67187 8.5885 6.38146 8.18945 5.80064L7.25662 4.44287Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinBag' icon.
  static const List<List<dynamic>> bitcoinBag = strokeRoundedBitcoinBag;

  /// JSON structure for the 'strokeRoundedBitcoinCircle' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinCircle = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M9 12H13.2M9 12V9.2963C9 8.82489 9 8.58919 9.14645 8.44274C9.29289 8.2963 9.5286 8.2963 10 8.2963H13.2C14.1941 8.2963 15 9.1254 15 10.1481C15 11.1709 14.1941 12 13.2 12M9 12V14.7037C9 15.1751 9 15.4108 9.14645 15.5572C9.29289 15.7037 9.5286 15.7037 10 15.7037H13.2C14.1941 15.7037 15 14.8746 15 13.8518C15 12.8291 14.1941 12 13.2 12M10.4938 8.2963V7M10.4938 17V15.7037M12.8982 8.2963V7M12.8982 17V15.7037',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinCircle' icon.
  static const List<List<dynamic>> bitcoinCircle = strokeRoundedBitcoinCircle;

  /// JSON structure for the 'strokeRoundedBitcoinCloud' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinCloud = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M17.5 17.5C19.9853 17.5 22 15.4853 22 13C22 10.5147 19.9853 8.5 17.5 8.5C17.4925 8.5 17.485 8.50002 17.4776 8.50005M17.4776 8.50005C17.4924 8.33536 17.5 8.16856 17.5 8C17.5 4.96243 15.0376 2.5 12 2.5C9.12324 2.5 6.76233 4.70862 6.52042 7.5227M17.4776 8.50005C17.3753 9.6345 16.9286 10.6696 16.2428 11.5M6.52042 7.5227C3.98398 7.76407 2 9.90034 2 12.5C2 15.0997 3.98398 17.2359 6.52042 17.4773M6.52042 7.5227C6.67826 7.50768 6.83823 7.5 7 7.5C8.12582 7.5 9.16474 7.87209 10.0005 8.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M10.125 20L10.125 14M12 14V12.5M12 21.5V20M10.125 17H13.875M13.875 17C14.4963 17 15 17.5037 15 18.125V18.875C15 19.4963 14.4963 20 13.875 20H9M13.875 17C14.4963 17 15 16.4963 15 15.875V15.125C15 14.5037 14.4963 14 13.875 14H9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinCloud' icon.
  static const List<List<dynamic>> bitcoinCloud = strokeRoundedBitcoinCloud;

  /// JSON structure for the 'strokeRoundedBitcoinCpu' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinCpu = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4 12C4 8.22876 4 6.34315 5.17157 5.17157C6.34315 4 8.22876 4 12 4C15.7712 4 17.6569 4 18.8284 5.17157C20 6.34315 20 8.22876 20 12C20 15.7712 20 17.6569 18.8284 18.8284C17.6569 20 15.7712 20 12 20C8.22876 20 6.34315 20 5.17157 18.8284C4 17.6569 4 15.7712 4 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M10.125 15L10.125 9M12 9V7.5M12 16.5V15M10.125 12H13.875M13.875 12C14.4963 12 15 12.5037 15 13.125V13.875C15 14.4963 14.4963 15 13.875 15H9M13.875 12C14.4963 12 15 11.4963 15 10.875V10.125C15 9.50368 14.4963 9 13.875 9H9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M8 2V4M16 2V4M12 2V4M8 20V22M12 20V22M16 20V22M22 16H20M4 8H2M4 16H2M4 12H2M22 8H20M22 12H20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinCpu' icon.
  static const List<List<dynamic>> bitcoinCpu = strokeRoundedBitcoinCpu;

  /// JSON structure for the 'strokeRoundedBitcoinCreditCard' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinCreditCard = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M22 11C22 7.46252 22 5.69377 20.9472 4.5129C20.7788 4.32403 20.5932 4.14935 20.3925 3.99087C19.1379 3 17.2586 3 13.5 3H10.5C6.74142 3 4.86213 3 3.60746 3.99087C3.40678 4.14935 3.22119 4.32403 3.0528 4.5129C2 5.69377 2 7.46252 2 11C2 14.5375 2 16.3062 3.0528 17.4871C3.22119 17.676 3.40678 17.8506 3.60746 18.0091C4.86213 19 6.74142 19 10.5 19H12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M2 8H22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M16.125 19.5L16.125 13.5M18 13.5V12M18 21V19.5M16.125 16.5H19.875M19.875 16.5C20.4963 16.5 21 17.0037 21 17.625V18.375C21 18.9963 20.4963 19.5 19.875 19.5H15M19.875 16.5C20.4963 16.5 21 15.9963 21 15.375V14.625C21 14.0037 20.4963 13.5 19.875 13.5H15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinCreditCard' icon.
  static const List<List<dynamic>> bitcoinCreditCard =
      strokeRoundedBitcoinCreditCard;

  /// JSON structure for the 'strokeRoundedBitcoinDatabase' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinDatabase = [
    [
      'ellipse',
      {
        'key': '0',
        'cx': '12',
        'cy': '5',
        'rx': '8',
        'ry': '3',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M12 15C7.58172 15 4 13.6569 4 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M15.9375 20.6667L15.9375 15.3333M17.5 15.3333V14M17.5 22V20.6667M15.9375 18H19.0625M19.0625 18C19.5803 18 20 18.4477 20 19V19.6667C20 20.219 19.5803 20.6667 19.0625 20.6667H15M19.0625 18C19.5803 18 20 17.5523 20 17V16.3333C20 15.781 19.5803 15.3333 19.0625 15.3333H15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M20 12V5M12 22C7.58172 22 4 20.6569 4 19V5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinDatabase' icon.
  static const List<List<dynamic>> bitcoinDatabase =
      strokeRoundedBitcoinDatabase;

  /// JSON structure for the 'strokeRoundedBitcoinDown01' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinDown01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12 2C8.41015 2 5.5 4.91015 5.5 8.5C5.5 12.0898 8.41015 15 12 15C15.5898 15 18.5 12.0899 18.5 8.5C18.5 4.91015 15.5898 2 12 2Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M9.5 19.5C9.99153 20.0057 11.2998 22 12 22M14.5 19.5C14.0085 20.0057 12.7002 22 12 22M12 22V17.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M10.4375 11.1667L10.4375 5.83333M12 5.83333V4.5M12 12.5V11.1667M10.4375 8.5H13.5625M13.5625 8.5C14.0803 8.5 14.5 8.94772 14.5 9.5V10.1667C14.5 10.719 14.0803 11.1667 13.5625 11.1667H9.5M13.5625 8.5C14.0803 8.5 14.5 8.05228 14.5 7.5V6.83333C14.5 6.28105 14.0803 5.83333 13.5625 5.83333H9.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinDown01' icon.
  static const List<List<dynamic>> bitcoinDown01 = strokeRoundedBitcoinDown01;

  /// JSON structure for the 'strokeRoundedBitcoinDown02' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinDown02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M10.9999 8.99985C7.41009 8.99985 4.49994 11.91 4.49994 15.4998C4.49994 19.0897 7.41009 21.9998 10.9999 21.9998C14.5898 21.9998 17.4999 19.0897 17.4999 15.4998C17.4999 11.91 14.5898 8.99985 10.9999 8.99985Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M20 8.5L15.4116 4.29397C14.7437 3.68176 14.4098 3.37565 14.0084 3.38437C13.6069 3.3931 13.2866 3.71342 12.6459 4.35406L11.6803 5.31973C11.116 5.88402 10.8338 6.16617 10.4728 6.19872C10.1118 6.23127 9.78377 6.00415 9.12764 5.5499L4 2M20 8.5H16.5M20 8.5V5.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M9.43744 18.1665L9.43744 12.8332M10.9999 12.8332V11.4998M10.9999 19.4998V18.1665M9.43744 15.4998H12.5624M12.5624 15.4998C13.0802 15.4998 13.4999 15.9476 13.4999 16.4998V17.1665C13.4999 17.7188 13.0802 18.1665 12.5624 18.1665H8.49994M12.5624 15.4998C13.0802 15.4998 13.4999 15.0521 13.4999 14.4998V13.8332C13.4999 13.2809 13.0802 12.8332 12.5624 12.8332H8.49994',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinDown02' icon.
  static const List<List<dynamic>> bitcoinDown02 = strokeRoundedBitcoinDown02;

  /// JSON structure for the 'strokeRoundedBitcoinEllipse' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinEllipse = [
    [
      'circle',
      {
        'key': '0',
        'cx': '12',
        'cy': '12',
        'r': '10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M9.5 16L9.5 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M11 8V6M13.5 8V6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M11 18V16M13.5 18V16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M9.5 12H14.5C15.3284 12 16 12.6716 16 13.5V14.5C16 15.3284 15.3284 16 14.5 16H8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd':
            'M8 8L14.5 8C15.3284 8 16 8.67157 16 9.5V10.5C16 11.3284 15.3284 12 14.5 12H9.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinEllipse' icon.
  static const List<List<dynamic>> bitcoinEllipse = strokeRoundedBitcoinEllipse;

  /// JSON structure for the 'strokeRoundedBitcoinEye' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinEye = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4.75 2.75L7 5L7 7M19.25 2.75L17 5L17 7M12 2.75L12 6M4.75 3.5C5.16421 3.5 5.5 3.16421 5.5 2.75C5.5 2.33579 5.16421 2 4.75 2C4.33579 2 4 2.33579 4 2.75C4 3.16421 4.33579 3.5 4.75 3.5ZM19.25 3.5C18.8358 3.5 18.5 3.16421 18.5 2.75C18.5 2.33579 18.8358 2 19.25 2C19.6642 2 20 2.33579 20 2.75C20 3.16421 19.6642 3.5 19.25 3.5ZM12 3.5C12.4142 3.5 12.75 3.16421 12.75 2.75C12.75 2.33579 12.4142 2 12 2C11.5858 2 11.25 2.33579 11.25 2.75C11.25 3.16421 11.5858 3.5 12 3.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M10.4375 18.1667L10.4375 12.8333M12 12.8333V11.5M12 19.5V18.1667M10.4375 15.5H13.5625M13.5625 15.5C14.0803 15.5 14.5 15.9477 14.5 16.5V17.1667C14.5 17.719 14.0803 18.1667 13.5625 18.1667H9.5M13.5625 15.5C14.0803 15.5 14.5 15.0523 14.5 14.5V13.8333C14.5 13.281 14.0803 12.8333 13.5625 12.8333H9.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M12 9C18 9 22 15.5 22 15.5C22 15.5 18 22 12 22C6 22 2 15.5 2 15.5C2 15.5 6 9 12 9Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinEye' icon.
  static const List<List<dynamic>> bitcoinEye = strokeRoundedBitcoinEye;

  /// JSON structure for the 'strokeRoundedBitcoinFilter' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinFilter = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6.23433 7C4.60404 7 3.7889 7 3.32795 7.49503C2.86701 7.99006 2.96811 8.7569 3.17033 10.2906C3.22938 10.7385 3.3276 10.9928 3.62734 11.3402C4.59564 12.4627 6.36901 14.4592 8.85746 16.2744C9.08486 16.4402 9.23409 16.7113 9.25927 17.0112C9.34268 18.0054 9.42401 18.9059 9.5007 19.71C9.62524 21.0158 9.68751 21.6687 10.1633 21.9159C10.639 22.163 11.2333 21.8467 12.4219 21.2141L13.4884 20.6465C13.9287 20.4122 14.1489 20.295 14.2852 20.0974C14.4216 19.8998 14.4494 19.6615 14.5051 19.1851C14.577 18.5699 14.6529 17.8503 14.7307 17.0112C14.7583 16.714 14.907 16.446 15.1326 16.2816C17.6261 14.4642 19.403 12.4641 20.3726 11.3402C20.6724 10.9928 20.7706 10.7385 20.8297 10.2906C21.0319 8.7569 21.133 7.99006 20.672 7.49503C20.2111 7 19.396 7 17.7657 7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M9.625 9.5L9.625 3.5M11.5 3.5V2M11.5 11V9.5M9.625 6.5H13.375M13.375 6.5C13.9963 6.5 14.5 7.00368 14.5 7.625V8.375C14.5 8.99632 13.9963 9.5 13.375 9.5H8.5M13.375 6.5C13.9963 6.5 14.5 5.99632 14.5 5.375V4.625C14.5 4.00368 13.9963 3.5 13.375 3.5H8.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinFilter' icon.
  static const List<List<dynamic>> bitcoinFilter = strokeRoundedBitcoinFilter;

  /// JSON structure for the 'strokeRoundedBitcoinFlashdisk' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinFlashdisk = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M10.5088 22C9.57782 22 9.11235 22 8.72528 21.9231C7.13574 21.6075 5.89317 20.3671 5.57699 18.7804C5.5 18.394 5.5 17.9293 5.5 17V11.5C5.5 9.61438 5.5 8.67157 6.08681 8.08579C6.67362 7.5 7.61808 7.5 9.507 7.5H11.5105C13.3994 7.5 14.3439 7.5 14.9307 8.08579C15.3355 8.48987 15.4611 9.06385 15.5 10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M13.625 20.5L13.625 14.5M15.5 14.5V13M15.5 22V20.5M13.625 17.5H17.375M17.375 17.5C17.9963 17.5 18.5 18.0037 18.5 18.625V19.375C18.5 19.9963 17.9963 20.5 17.375 20.5H12.5M17.375 17.5C17.9963 17.5 18.5 16.9963 18.5 16.375V15.625C18.5 15.0037 17.9963 14.5 17.375 14.5H12.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M14 7.5V5.5C14 4.09554 14 3.39331 13.6629 2.88886C13.517 2.67048 13.3295 2.48298 13.1111 2.33706C12.6067 2 11.9045 2 10.5 2C9.09554 2 8.39331 2 7.88886 2.33706C7.67048 2.48298 7.48298 2.67048 7.33706 2.88886C7 3.39331 7 4.09554 7 5.5V7.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M10 4.5H11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinFlashdisk' icon.
  static const List<List<dynamic>> bitcoinFlashdisk =
      strokeRoundedBitcoinFlashdisk;

  /// JSON structure for the 'strokeRoundedBitcoinGraph' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinGraph = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M13.5 19.5V11.5C13.5 10.5572 13.5 10.0858 13.2071 9.79289C12.9142 9.5 12.4428 9.5 11.5 9.5C10.5572 9.5 10.0858 9.5 9.79289 9.79289C9.5 10.0858 9.5 10.5572 9.5 11.5V19.5C9.5 20.4428 9.5 20.9142 9.79289 21.2071C10.0858 21.5 10.5572 21.5 11.5 21.5C12.4428 21.5 12.9142 21.5 13.2071 21.2071C13.5 20.9142 13.5 20.4428 13.5 19.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M20.5 12.5V19.5C20.5 20.4428 20.5 20.9142 20.2071 21.2071C19.9142 21.5 19.4428 21.5 18.5 21.5C17.5572 21.5 17.0858 21.5 16.7929 21.2071C16.5 20.9142 16.5 20.4428 16.5 19.5V12.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M17.4375 9.16667L17.4375 3.83333M19 3.83333V2.5M19 10.5V9.16667M17.4375 6.5H20.5625M20.5625 6.5C21.0803 6.5 21.5 6.94772 21.5 7.5V8.16667C21.5 8.71895 21.0803 9.16667 20.5625 9.16667H16.5M20.5625 6.5C21.0803 6.5 21.5 6.05228 21.5 5.5V4.83333C21.5 4.28105 21.0803 3.83333 20.5625 3.83333H16.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M6.5 19.5V14.5C6.5 13.5572 6.5 13.0858 6.20711 12.7929C5.91421 12.5 5.44281 12.5 4.5 12.5C3.55719 12.5 3.08579 12.5 2.79289 12.7929C2.5 13.0858 2.5 13.5572 2.5 14.5V19.5C2.5 20.4428 2.5 20.9142 2.79289 21.2071C3.08579 21.5 3.55719 21.5 4.5 21.5C5.44281 21.5 5.91421 21.5 6.20711 21.2071C6.5 20.9142 6.5 20.4428 6.5 19.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinGraph' icon.
  static const List<List<dynamic>> bitcoinGraph = strokeRoundedBitcoinGraph;

  /// JSON structure for the 'strokeRoundedBitcoinInvoice' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinInvoice = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M20.016 2C18.9026 2 18 4.68629 18 8H20.016C20.9876 8 21.4734 8 21.7741 7.66455C22.0749 7.32909 22.0225 6.88733 21.9178 6.00381C21.6414 3.67143 20.8943 2 20.016 2Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18 8.05426V18.6458C18 20.1575 18 20.9133 17.538 21.2108C16.7831 21.6971 15.6161 20.6774 15.0291 20.3073C14.5441 20.0014 14.3017 19.8485 14.0325 19.8397C13.7417 19.8301 13.4949 19.9768 12.9709 20.3073L11.06 21.5124C10.5445 21.8374 10.2868 22 10 22C9.71321 22 9.45546 21.8374 8.94 21.5124L7.02913 20.3073C6.54415 20.0014 6.30166 19.8485 6.03253 19.8397C5.74172 19.8301 5.49493 19.9768 4.97087 20.3073C4.38395 20.6774 3.21687 21.6971 2.46195 21.2108C2 20.9133 2 20.1575 2 18.6458V8.05426C2 5.20025 2 3.77325 2.87868 2.88663C3.75736 2 5.17157 2 8 2H20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M8.125 13.5L8.125 7.5M10 7.5V6M10 15V13.5M8.125 10.5H11.875M11.875 10.5C12.4963 10.5 13 11.0037 13 11.625V12.375C13 12.9963 12.4963 13.5 11.875 13.5H7M11.875 10.5C12.4963 10.5 13 9.99632 13 9.375V8.625C13 8.00368 12.4963 7.5 11.875 7.5H7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinInvoice' icon.
  static const List<List<dynamic>> bitcoinInvoice = strokeRoundedBitcoinInvoice;

  /// JSON structure for the 'strokeRoundedBitcoinKey' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinKey = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M8.5 2C5.73858 2 3.5 4.23858 3.5 7C3.5 8.85071 4.5055 10.4666 6 11.3311V17.8431C6 18.6606 6 19.0694 6.15224 19.4369C6.30448 19.8045 6.59351 20.0935 7.17157 20.6716L8.5 22L10.6082 19.8918C10.7054 19.7946 10.7541 19.7459 10.7944 19.6932C10.9003 19.5547 10.9682 19.3909 10.9912 19.218C11 19.1522 11 19.0834 11 18.9459C11 18.8346 11 18.779 10.9941 18.7249C10.9786 18.5831 10.933 18.4463 10.8603 18.3236C10.8326 18.2768 10.7992 18.2323 10.7325 18.1433L9.5 16.5L10.2 15.5667C10.5965 15.038 10.7947 14.7737 10.8974 14.4658C11 14.1579 11 13.8275 11 13.1667V11.3311C12.4945 10.4666 13.5 8.85071 13.5 7C13.5 4.23858 11.2614 2 8.5 2Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M8.5 7H8.50898',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M15.625 19.5L15.625 13.5M17.5 13.5V12M17.5 21V19.5M15.625 16.5H19.375M19.375 16.5C19.9963 16.5 20.5 17.0037 20.5 17.625V18.375C20.5 18.9963 19.9963 19.5 19.375 19.5H14.5M19.375 16.5C19.9963 16.5 20.5 15.9963 20.5 15.375V14.625C20.5 14.0037 19.9963 13.5 19.375 13.5H14.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinKey' icon.
  static const List<List<dynamic>> bitcoinKey = strokeRoundedBitcoinKey;

  /// JSON structure for the 'strokeRoundedBitcoinLocation' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinLocation = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M18 18.2678C19.2447 18.6638 20 19.184 20 19.7537C20 20.9943 16.4183 22 12 22C7.58172 22 4 20.9943 4 19.7537C4 19.184 4.75527 18.6638 6 18.2678',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M10.4375 11.6667L10.4375 6.33333M12 6.33333V5M12 13V11.6667M10.4375 9H13.5625M13.5625 9C14.0803 9 14.5 9.44772 14.5 10V10.6667C14.5 11.219 14.0803 11.6667 13.5625 11.6667H9.5M13.5625 9C14.0803 9 14.5 8.55228 14.5 8V7.33333C14.5 6.78105 14.0803 6.33333 13.5625 6.33333H9.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M13.3471 18.4619C12.9858 18.8071 12.5028 19 12.0001 19C11.4974 19 11.0144 18.8071 10.653 18.4619C7.34382 15.2821 2.90906 11.7299 5.07176 6.57272C6.24111 3.78428 9.04808 2 12.0001 2C14.9521 2 17.7591 3.78428 18.9284 6.57272C21.0884 11.7234 16.6645 15.293 13.3471 18.4619Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinLocation' icon.
  static const List<List<dynamic>> bitcoinLocation =
      strokeRoundedBitcoinLocation;

  /// JSON structure for the 'strokeRoundedBitcoinLock' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinLock = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4.26781 18.8447C4.49269 20.515 5.87613 21.8235 7.55966 21.9009C8.97627 21.966 10.4153 22 12 22C13.5847 22 15.0237 21.966 16.4403 21.9009C18.1239 21.8235 19.5073 20.515 19.7322 18.8447C19.879 17.7547 20 16.6376 20 15.5C20 14.3624 19.879 13.2453 19.7322 12.1553C19.5073 10.485 18.1239 9.17649 16.4403 9.09909C15.0237 9.03397 13.5847 9 12 9C10.4153 9 8.97627 9.03397 7.55966 9.09909C5.87613 9.17649 4.49269 10.485 4.26781 12.1553C4.12104 13.2453 4 14.3624 4 15.5C4 16.6376 4.12104 17.7547 4.26781 18.8447Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M7.5 9V6.5C7.5 4.01472 9.51472 2 12 2C14.4853 2 16.5 4.01472 16.5 6.5V9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M10.4375 18.1667L10.4375 12.8333M12 12.8333V11.5M12 19.5V18.1667M10.4375 15.5H13.5625M13.5625 15.5C14.0803 15.5 14.5 15.9477 14.5 16.5V17.1667C14.5 17.719 14.0803 18.1667 13.5625 18.1667H9.5M13.5625 15.5C14.0803 15.5 14.5 15.0523 14.5 14.5V13.8333C14.5 13.281 14.0803 12.8333 13.5625 12.8333H9.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinLock' icon.
  static const List<List<dynamic>> bitcoinLock = strokeRoundedBitcoinLock;

  /// JSON structure for the 'strokeRoundedBitcoinMail' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinMail = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5.00035 7L3.78154 7.81253C2.90783 8.39501 2.47097 8.68625 2.23422 9.13041C1.99747 9.57457 1.99923 10.0966 2.00273 11.1406C2.00696 12.3975 2.01864 13.6782 2.05099 14.9741C2.12773 18.0487 2.16611 19.586 3.29651 20.7164C4.42691 21.8469 5.98497 21.8858 9.10108 21.9637C11.0397 22.0121 12.9611 22.0121 14.8996 21.9637C18.0158 21.8858 19.5738 21.8469 20.7042 20.7164C21.8346 19.586 21.873 18.0487 21.9497 14.9741C21.9821 13.6782 21.9937 12.3975 21.998 11.1406C22.0015 10.0966 22.0032 9.57456 21.7665 9.13041C21.5297 8.68625 21.0929 8.39501 20.2191 7.81253L19.0003 7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M2 10L8.91302 14.1478C10.417 15.0502 11.169 15.5014 12 15.5014C12.831 15.5014 13.583 15.0502 15.087 14.1478L22 10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M4.99997 12V6C4.99997 4.11438 4.99997 3.17157 5.58576 2.58579C6.17154 2 7.11435 2 8.99997 2H15C16.8856 2 17.8284 2 18.4142 2.58579C19 3.17157 19 4.11438 19 6V12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M10.4375 11.1667L10.4375 5.83333M12 5.83333V4.5M12 12.5V11.1667M10.4375 8.5H13.5625M13.5625 8.5C14.0803 8.5 14.5 8.94772 14.5 9.5V10.1667C14.5 10.719 14.0803 11.1667 13.5625 11.1667H9.5M13.5625 8.5C14.0803 8.5 14.5 8.05228 14.5 7.5V6.83333C14.5 6.28105 14.0803 5.83333 13.5625 5.83333H9.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinMail' icon.
  static const List<List<dynamic>> bitcoinMail = strokeRoundedBitcoinMail;

  /// JSON structure for the 'strokeRoundedBitcoinMind' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinMind = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M15.5 22V21.5C15.5 20.3954 16.4321 19.5005 17.4223 19.011C18.3846 18.5354 19.1943 17.7511 19.2965 16.8313L19.5 15L21.5 14L19 10.25C19 5.69365 15.3063 2 10.75 2C6.19365 2 2.5 5.69365 2.5 10.25C2.5 13.0379 3.88283 15.5028 6 16.9962M6 16.9962V22M6 16.9962C6.75065 17.5257 7.59362 17.9331 8.5 18.1895',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M8.9375 12.6667L8.9375 7.33333M10.5 7.33333V6M10.5 14V12.6667M8.9375 10H12.0625M12.0625 10C12.5803 10 13 10.4477 13 11V11.6667C13 12.219 12.5803 12.6667 12.0625 12.6667H8M12.0625 10C12.5803 10 13 9.55228 13 9V8.33333C13 7.78105 12.5803 7.33333 12.0625 7.33333H8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinMind' icon.
  static const List<List<dynamic>> bitcoinMind = strokeRoundedBitcoinMind;

  /// JSON structure for the 'strokeRoundedBitcoinMoney01' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinMoney01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M16 4H8C5.17157 4 3.75736 4 2.87868 4.93726C2 5.87452 2 7.38301 2 10.4V13.6C2 16.617 2 18.1255 2.87868 19.0627C3.75736 20 5.17157 20 8 20H16C18.8284 20 20.2426 20 21.1213 19.0627C22 18.1255 22 16.617 22 13.6V10.4C22 7.38301 22 5.87452 21.1213 4.93726C20.2426 4 18.8284 4 16 4Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M6.87398 4C6.95625 4.31962 7 4.6547 7 5C7 7.20914 5.20914 9 3 9C2.6547 9 2.31962 8.95625 2 8.87398',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M22 8.87398C21.6804 8.95625 21.3453 9 21 9C18.7909 9 17 7.20914 17 5C17 4.6547 17.0438 4.31962 17.126 4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M17.126 20C17.0438 19.6804 17 19.3453 17 19C17 16.7909 18.7909 15 21 15C21.3453 15 21.6804 15.0438 22 15.126',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M2 15.126C2.31962 15.0438 2.6547 15 3 15C5.20914 15 7 16.7909 7 19C7 19.3453 6.95625 19.6804 6.87398 20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd':
            'M10.4375 14.6667L10.4375 9.33333M12 9.33333V8M12 16V14.6667M10.4375 12H13.5625M13.5625 12C14.0803 12 14.5 12.4477 14.5 13V13.6667C14.5 14.219 14.0803 14.6667 13.5625 14.6667H9.5M13.5625 12C14.0803 12 14.5 11.5523 14.5 11V10.3333C14.5 9.78105 14.0803 9.33333 13.5625 9.33333H9.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinMoney01' icon.
  static const List<List<dynamic>> bitcoinMoney01 = strokeRoundedBitcoinMoney01;

  /// JSON structure for the 'strokeRoundedBitcoinMoney02' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinMoney02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M10.4375 14.6667L10.4375 9.33333M12 9.33333V8M12 16V14.6667M10.4375 12H13.5625M13.5625 12C14.0803 12 14.5 12.4477 14.5 13V13.6667C14.5 14.219 14.0803 14.6667 13.5625 14.6667H9.5M13.5625 12C14.0803 12 14.5 11.5523 14.5 11V10.3333C14.5 9.78105 14.0803 9.33333 13.5625 9.33333H9.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M19 11.142C18.6749 11.0949 18.341 11.0591 18 11.0352M6 12.9658C5.65897 12.942 5.32511 12.9061 5 12.859',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M12 19.5C10.6675 20.1224 8.91707 20.5 7 20.5C5.93408 20.5 4.91969 20.3833 4 20.1726C2.49957 19.8289 2 18.9264 2 17.386V6.61397C2 5.62914 3.04003 4.95273 4 5.1726C4.91969 5.38325 5.93408 5.5 7 5.5C8.91707 5.5 10.6675 5.12236 12 4.5C13.3325 3.87764 15.0829 3.5 17 3.5C18.0659 3.5 19.0803 3.61675 20 3.8274C21.5817 4.18968 22 5.12036 22 6.61397V17.386C22 18.3709 20.96 19.0473 20 18.8274C19.0803 18.6167 18.0659 18.5 17 18.5C15.0829 18.5 13.3325 18.8776 12 19.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinMoney02' icon.
  static const List<List<dynamic>> bitcoinMoney02 = strokeRoundedBitcoinMoney02;

  /// JSON structure for the 'strokeRoundedBitcoinPieChart' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinPieChart = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22C17.5228 22 22 17.5228 22 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M19 12C19 8.13401 15.866 5 12 5C8.13401 5 5 8.13401 5 12C5 15.866 8.13401 19 12 19C15.866 19 19 15.866 19 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 2V5M19 12H22M19 19L17 17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M10.4375 14.6667L10.4375 9.33333M12 9.33333V8M12 16V14.6667M10.4375 12H13.5625M13.5625 12C14.0803 12 14.5 12.4477 14.5 13V13.6667C14.5 14.219 14.0803 14.6667 13.5625 14.6667H9.5M13.5625 12C14.0803 12 14.5 11.5523 14.5 11V10.3333C14.5 9.78105 14.0803 9.33333 13.5625 9.33333H9.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinPieChart' icon.
  static const List<List<dynamic>> bitcoinPieChart =
      strokeRoundedBitcoinPieChart;

  /// JSON structure for the 'strokeRoundedBitcoinPiggyBank' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinPiggyBank = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M21.5 11.0288C21.8239 11.8026 22 12.6342 22 13.5C22 15.5586 21.0047 17.4235 19.3933 18.7788C19.1517 18.982 19 19.2762 19 19.5919V22H17L16.2062 20.8674C16.083 20.6916 15.8616 20.6153 15.6537 20.6687C13.9248 21.1132 12.0752 21.1132 10.3463 20.6687C10.1384 20.6153 9.91703 20.6916 9.79384 20.8674L9 22H7V19.6154C7 19.2866 6.83835 18.9788 6.56764 18.7922C5.49285 18.0511 2 16.6014 2 15.0582V13.5C2 12.9083 2.44771 12.4286 3 12.4286C3.60665 12.4286 4.10188 12.1929 4.30205 11.5661C5.06912 9.16411 7.23085 7.23604 10.0206 6.42073',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M14.125 9.5L14.125 3.5M16 3.5V2M16 11V9.5M14.125 6.5H17.875M17.875 6.5C18.4963 6.5 19 7.00368 19 7.625V8.375C19 8.99632 18.4963 9.5 17.875 9.5H13M17.875 6.5C18.4963 6.5 19 5.99632 19 5.375V4.625C19 4.00368 18.4963 3.5 17.875 3.5H13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M7.49981 12H7.50879',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinPiggyBank' icon.
  static const List<List<dynamic>> bitcoinPiggyBank =
      strokeRoundedBitcoinPiggyBank;

  /// JSON structure for the 'strokeRoundedBitcoinPresentation' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinPresentation = [
    [
      'path',
      {
        'key': '0',
        'd': 'M12 19L12 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M21 2H3C2.5286 2 2.29289 2 2.14645 2.14645C2 2.29289 2 2.5286 2 3V4C2 4.4714 2 4.70711 2.14645 4.85355C2.29289 5 2.5286 5 3 5H21C21.4714 5 21.7071 5 21.8536 4.85355C22 4.70711 22 4.4714 22 4V3C22 2.5286 22 2.29289 21.8536 2.14645C21.7071 2 21.4714 2 21 2Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M3 5V13C3 15.8284 3 17.2426 3.87868 18.1213C4.75736 19 6.17157 19 9 19H15C17.8284 19 19.2426 19 20.1213 18.1213C21 17.2426 21 15.8284 21 13V5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M14 10H16M14 14L18 14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M6.9375 14.6667L6.9375 9.33333M8.5 9.33333V8M8.5 16V14.6667M6.9375 12H10.0625M10.0625 12C10.5803 12 11 12.4477 11 13V13.6667C11 14.219 10.5803 14.6667 10.0625 14.6667H6M10.0625 12C10.5803 12 11 11.5523 11 11V10.3333C11 9.78105 10.5803 9.33333 10.0625 9.33333H6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinPresentation' icon.
  static const List<List<dynamic>> bitcoinPresentation =
      strokeRoundedBitcoinPresentation;

  /// JSON structure for the 'strokeRoundedBitcoinReceipt' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinReceipt = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M10.125 13.5L10.125 7.5M12 7.5V6M12 15V13.5M10.125 10.5H13.875M13.875 10.5C14.4963 10.5 15 11.0037 15 11.625V12.375C15 12.9963 14.4963 13.5 13.875 13.5H9M13.875 10.5C14.4963 10.5 15 9.99632 15 9.375V8.625C15 8.00368 14.4963 7.5 13.875 7.5H9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M10.94 21.5124L9.02913 20.3073C8.54415 20.0014 8.30166 19.8485 8.03253 19.8397C7.74172 19.8301 7.49493 19.9768 6.97087 20.3073C6.38395 20.6774 5.21687 21.6971 4.46195 21.2108C4 20.9133 4 20.1575 4 18.6458V8.00002C4 5.17158 4 3.75736 4.82699 2.87868C5.65399 2 6.98501 2 9.64706 2H14.3529C17.015 2 18.346 2 19.173 2.87868C20 3.75736 20 5.17158 20 8.00002V18.6458C20 20.1575 20 20.9133 19.538 21.2108C18.7831 21.6971 17.6161 20.6774 17.0291 20.3073C16.5441 20.0014 16.3017 19.8485 16.0325 19.8397C15.7417 19.8301 15.4949 19.9768 14.9709 20.3073L13.06 21.5124C12.5445 21.8374 12.2868 22 12 22C11.7132 22 11.4554 21.8374 10.94 21.5124Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinReceipt' icon.
  static const List<List<dynamic>> bitcoinReceipt = strokeRoundedBitcoinReceipt;

  /// JSON structure for the 'strokeRoundedBitcoinReceive' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinReceive = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2 4.8H9C10.6569 4.8 12 6.41177 12 8.4C12 10.3882 10.6569 12 9 12M9 12C10.6569 12 12 13.6118 12 15.6C12 17.5882 10.6569 19.2 9 19.2H2M9 12H3M2.83333 4.8V19.2M4.5 3V4.8M8.66667 3V4.8M4.5 19.2V21M8.66667 19.2V21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M14.5 12H22M14.5 12C14.5 12.7002 16.4943 14.0085 17 14.5M14.5 12C14.5 11.2998 16.4943 9.99153 17 9.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinReceive' icon.
  static const List<List<dynamic>> bitcoinReceive = strokeRoundedBitcoinReceive;

  /// JSON structure for the 'strokeRoundedBitcoinRectangle' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinRectangle = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M9.5 16L9.5 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M11 8V6M13.5 8V6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M11 18V16M13.5 18V16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M9.5 12L14.5 12C15.3284 12 16 12.6716 16 13.5V14.5C16 15.3284 15.3284 16 14.5 16H8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd':
            'M8 8L14.5 8C15.3284 8 16 8.67157 16 9.5V10.5C16 11.3284 15.3284 12 14.5 12H9.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinRectangle' icon.
  static const List<List<dynamic>> bitcoinRectangle =
      strokeRoundedBitcoinRectangle;

  /// JSON structure for the 'strokeRoundedBitcoinSafe' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinSafe = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M11 2H13C17.2426 2 19.364 2 20.682 3.31802C22 4.63604 22 6.75736 22 11C22 15.2426 22 17.364 20.682 18.682C19.364 20 17.2426 20 13 20H11C6.75736 20 4.63604 20 3.31802 18.682C2 17.364 2 15.2426 2 11C2 6.75736 2 4.63604 3.31802 3.31802C4.63604 2 6.75736 2 11 2Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M7 15C6 14.4692 6 13.6148 6 11.9062V10.0938C6 8.38516 6 7.53082 7 7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M18 22V20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M6 22V20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M12.9375 13.6667L12.9375 8.33333M14.5 8.33333V7M14.5 15V13.6667M12.9375 11H16.0625M16.0625 11C16.5803 11 17 11.4477 17 12V12.6667C17 13.219 16.5803 13.6667 16.0625 13.6667H12M16.0625 11C16.5803 11 17 10.5523 17 10V9.33333C17 8.78105 16.5803 8.33333 16.0625 8.33333H12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinSafe' icon.
  static const List<List<dynamic>> bitcoinSafe = strokeRoundedBitcoinSafe;

  /// JSON structure for the 'strokeRoundedBitcoinSearch' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinSearch = [
    [
      'path',
      {
        'key': '0',
        'd': 'M17.5 17.5L22 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M20 11C20 6.02944 15.9706 2 11 2C6.02944 2 2 6.02944 2 11C2 15.9706 6.02944 20 11 20C15.9706 20 20 15.9706 20 11Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M9.125 14L9.125 8M11 8V6.5M11 15.5V14M9.125 11H12.875M12.875 11C13.4963 11 14 11.5037 14 12.125V12.875C14 13.4963 13.4963 14 12.875 14H8M12.875 11C13.4963 11 14 10.4963 14 9.875V9.125C14 8.50368 13.4963 8 12.875 8H8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinSearch' icon.
  static const List<List<dynamic>> bitcoinSearch = strokeRoundedBitcoinSearch;

  /// JSON structure for the 'strokeRoundedBitcoinSend' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinSend = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2 4.8H9C10.6569 4.8 12 6.41177 12 8.4C12 10.3882 10.6569 12 9 12M9 12C10.6569 12 12 13.6118 12 15.6C12 17.5882 10.6569 19.2 9 19.2H2M9 12H3M2.83333 4.8V19.2M4.5 3V4.8M8.66667 3V4.8M4.5 19.2V21M8.66667 19.2V21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M22 12H14.5M22 12C22 12.7002 20.0057 14.0085 19.5 14.5M22 12C22 11.2998 20.0057 9.99153 19.5 9.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinSend' icon.
  static const List<List<dynamic>> bitcoinSend = strokeRoundedBitcoinSend;

  /// JSON structure for the 'strokeRoundedBitcoinSetting' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinSetting = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M10.125 15L10.125 9M12 9V7.5M12 16.5V15M10.125 12H13.875M13.875 12C14.4963 12 15 12.5037 15 13.125V13.875C15 14.4963 14.4963 15 13.875 15H9M13.875 12C14.4963 12 15 11.4963 15 10.875V10.125C15 9.50368 14.4963 9 13.875 9H9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M21.011 14.0968C21.5329 13.9561 21.7939 13.8857 21.8969 13.7511C22 13.6166 22 13.4001 22 12.9672V11.0335C22 10.6006 22 10.3841 21.8969 10.2496C21.7938 10.115 21.5329 10.0446 21.011 9.90389C19.0606 9.37789 17.8399 7.33882 18.3433 5.40118C18.4817 4.8683 18.5509 4.60186 18.4848 4.4456C18.4187 4.28933 18.2291 4.18164 17.8497 3.96627L16.125 2.98704C15.7528 2.7757 15.5667 2.67003 15.3997 2.69253C15.2326 2.71503 15.0442 2.90304 14.6672 3.27904C13.208 4.73479 10.7936 4.73473 9.33434 3.27895C8.95743 2.90294 8.76898 2.71494 8.60193 2.69243C8.43489 2.66993 8.24877 2.7756 7.87653 2.98694L6.15184 3.96617C5.77253 4.18154 5.58287 4.28922 5.51678 4.44546C5.45068 4.60171 5.51987 4.86818 5.65825 5.40111C6.16137 7.3388 4.93972 9.37794 2.98902 9.9039C2.46712 10.0446 2.20617 10.115 2.10308 10.2495C2 10.3841 2 10.6006 2 11.0335V12.9672C2 13.4001 2 13.6166 2.10308 13.7511C2.20615 13.8857 2.46711 13.9561 2.98902 14.0968C4.9394 14.6228 6.16008 16.6619 5.65672 18.5995C5.51829 19.1324 5.44907 19.3988 5.51516 19.5551C5.58126 19.7114 5.77092 19.8191 6.15025 20.0344L7.87495 21.0137C8.24721 21.225 8.43334 21.3307 8.6004 21.3082C8.76746 21.2857 8.95588 21.0977 9.33271 20.7216C10.7927 19.2647 13.2088 19.2646 14.6689 20.7215C15.0457 21.0976 15.2341 21.2856 15.4012 21.3081C15.5682 21.3306 15.7544 21.2249 16.1266 21.0136L17.8513 20.0343C18.2307 19.819 18.4204 19.7113 18.4864 19.555C18.5525 19.3987 18.4833 19.1323 18.3448 18.5995C17.8412 16.6619 19.0609 14.6229 21.011 14.0968Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinSetting' icon.
  static const List<List<dynamic>> bitcoinSetting = strokeRoundedBitcoinSetting;

  /// JSON structure for the 'strokeRoundedBitcoinShield' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinShield = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M10.125 14.5001L10.125 8.50012M12 8.50012V7.00012M12 16.0001V14.5001M10.125 11.5001H13.875M13.875 11.5001C14.4963 11.5001 15 12.0038 15 12.6251V13.3751C15 13.9964 14.4963 14.5001 13.875 14.5001H9M13.875 11.5001C14.4963 11.5001 15 10.9964 15 10.3751V9.62512C15 9.0038 14.4963 8.50012 13.875 8.50012H9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M21 11.1835V8.28047C21 6.64047 21 5.82047 20.5959 5.28547C20.1918 4.75048 19.2781 4.49075 17.4507 3.97128C16.2022 3.61638 15.1016 3.18881 14.2223 2.79847C13.0234 2.26628 12.424 2.00018 12 2.00018C11.576 2.00018 10.9766 2.26628 9.77771 2.79847C8.89839 3.18881 7.79784 3.61638 6.54933 3.97128C4.72193 4.49075 3.80822 4.75048 3.40411 5.28547C3 5.82047 3 6.64047 3 8.28047V11.1835C3 16.8087 8.06277 20.1837 10.594 21.5196C11.2011 21.84 11.5046 22.0002 12 22.0002C12.4954 22.0002 12.7989 21.84 13.406 21.5196C15.9372 20.1837 21 16.8087 21 11.1835Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinShield' icon.
  static const List<List<dynamic>> bitcoinShield = strokeRoundedBitcoinShield;

  /// JSON structure for the 'strokeRoundedBitcoinShopping' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinShopping = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4.30064 17.1912L3.16042 10.2591C2.98802 9.21103 2.90182 8.68698 3.17785 8.34349C3.45388 8 3.96121 8 4.97587 8H19.0241C20.0388 8 20.5461 8 20.8221 8.34349C21.0982 8.68698 21.012 9.21103 20.8396 10.2591L19.6994 17.1912C19.3214 19.4888 19.1325 20.6376 18.361 21.3188C17.5894 22 16.4773 22 14.253 22H9.74699C7.5227 22 6.41055 22 5.63904 21.3188C4.86752 20.6376 4.67856 19.4888 4.30064 17.1912Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M10.4375 17.6667L10.4375 12.3333M12 12.3333V11M12 19V17.6667M10.4375 15H13.5625M13.5625 15C14.0803 15 14.5 15.4477 14.5 16V16.6667C14.5 17.219 14.0803 17.6667 13.5625 17.6667H9.5M13.5625 15C14.0803 15 14.5 14.5523 14.5 14V13.3333C14.5 12.781 14.0803 12.3333 13.5625 12.3333H9.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M17 8C17 4.68629 15.5 2 12 2C8.5 2 7 4.68629 7 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinShopping' icon.
  static const List<List<dynamic>> bitcoinShopping =
      strokeRoundedBitcoinShopping;

  /// JSON structure for the 'strokeRoundedBitcoinSmartphone01' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinSmartphone01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M17.5988 5C17.4638 4.13105 17.2083 3.5086 16.7249 3.02513C15.6997 2 14.0498 2 10.75 2C7.45017 2 5.80025 2 4.77513 3.02513C3.75 4.05025 3.75 5.70017 3.75 9V15C3.75 18.2998 3.75 19.9497 4.77513 20.9749C5.80025 22 7.45017 22 10.75 22C14.0498 22 15.6997 22 16.7249 20.9749C17.2083 20.4914 17.4638 19.869 17.5988 19',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M16.1875 14.6667L16.1875 9.33333M17.75 9.33333V8M17.75 16V14.6667M16.1875 12H19.3125M19.3125 12C19.8303 12 20.25 12.4477 20.25 13V13.6667C20.25 14.219 19.8303 14.6667 19.3125 14.6667H15.25M19.3125 12C19.8303 12 20.25 11.5523 20.25 11V10.3333C20.25 9.78105 19.8303 9.33333 19.3125 9.33333H15.25',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M10.75 19H10.759',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M9.75 5H11.75',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinSmartphone01' icon.
  static const List<List<dynamic>> bitcoinSmartphone01 =
      strokeRoundedBitcoinSmartphone01;

  /// JSON structure for the 'strokeRoundedBitcoinSmartphone02' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinSmartphone02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5 9C5 5.70017 5 4.05025 6.02513 3.02513C7.05025 2 8.70017 2 12 2C15.2998 2 16.9497 2 17.9749 3.02513C19 4.05025 19 5.70017 19 9V15C19 18.2998 19 19.9497 17.9749 20.9749C16.9497 22 15.2998 22 12 22C8.70017 22 7.05025 22 6.02513 20.9749C5 19.9497 5 18.2998 5 15V9Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M10.4375 12.6667L10.4375 7.33333M12 7.33333V6M12 14V12.6667M10.4375 10H13.5625M13.5625 10C14.0803 10 14.5 10.4477 14.5 11V11.6667C14.5 12.219 14.0803 12.6667 13.5625 12.6667H9.5M13.5625 10C14.0803 10 14.5 9.55228 14.5 9V8.33333C14.5 7.78105 14.0803 7.33333 13.5625 7.33333H9.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 19H12.009',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinSmartphone02' icon.
  static const List<List<dynamic>> bitcoinSmartphone02 =
      strokeRoundedBitcoinSmartphone02;

  /// JSON structure for the 'strokeRoundedBitcoinSquare' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinSquare = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M9 12H13.2M9 12V9.2963C9 8.82489 9 8.58919 9.14645 8.44274C9.29289 8.2963 9.5286 8.2963 10 8.2963H13.2C14.1941 8.2963 15 9.1254 15 10.1481C15 11.1709 14.1941 12 13.2 12M9 12V14.7037C9 15.1751 9 15.4108 9.14645 15.5573C9.29289 15.7037 9.5286 15.7037 10 15.7037H13.2C14.1941 15.7037 15 14.8746 15 13.8519C15 12.8291 14.1941 12 13.2 12M10.4938 8.2963V7M10.4938 17V15.7037M12.8982 8.2963V7M12.8982 17V15.7037',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinSquare' icon.
  static const List<List<dynamic>> bitcoinSquare = strokeRoundedBitcoinSquare;

  /// JSON structure for the 'strokeRoundedBitcoinStore' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinStore = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6.26565 2H17.7343C18.3949 2.00003 19.4903 2.09768 19.8625 3.15228C20.084 3.78008 19.9965 4.48455 20.2378 5.105C20.4912 5.75665 20.8888 6.38647 21.2743 6.954C21.6564 7.51649 22.0964 8.12339 21.9814 8.79383C21.8516 9.54978 21.2457 10.2614 20.4449 10.6395C18.8055 11.4134 16.3808 10.9467 15.9953 8.14559C15.6715 9.04026 14.6798 10.9467 11.9606 10.9467C9.24145 10.9467 8.32846 9.04026 8.00472 8.14559C7.61921 10.9467 5.19448 11.4134 3.55511 10.6395C2.75431 10.2614 2.14841 9.54978 2.01864 8.79383C1.90356 8.12339 2.34357 7.51649 2.72568 6.954C3.11122 6.38647 3.50878 5.75665 3.76223 5.105C4.00354 4.48455 3.91599 3.78008 4.13753 3.15228C4.50968 2.09768 5.60507 2.00003 6.26565 2Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M16.9628 20.6646V15.3227M18.5259 15.3227V13.9873M18.5259 22V20.6646M16.9628 17.9937H20.089M20.089 17.9937C20.607 17.9937 21.0268 18.4421 21.0268 18.9953V19.663C21.0268 20.2162 20.607 20.6646 20.089 20.6646H16.0249M20.089 17.9937C20.607 17.9937 21.0268 17.5452 21.0268 16.9921V16.3243C21.0268 15.7711 20.607 15.3227 20.089 15.3227H16.0249',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M3.02002 10.4814V14.9886C3.02002 17.8215 3.02002 19.2379 3.89903 20.118C4.77805 20.9981 6.1928 20.9981 9.02231 20.9981H13.0238',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinStore' icon.
  static const List<List<dynamic>> bitcoinStore = strokeRoundedBitcoinStore;

  /// JSON structure for the 'strokeRoundedBitcoinTag' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinTag = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M17.5 5C18.3284 5 19 5.67157 19 6.5C19 7.32843 18.3284 8 17.5 8C16.6716 8 16 7.32843 16 6.5C16 5.67157 16.6716 5 17.5 5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M2.77424 11.1439C1.77109 12.2643 1.74951 13.9546 2.67017 15.1437C4.49712 17.5033 6.49675 19.5029 8.85634 21.3298C10.0454 22.2505 11.7357 22.2289 12.8561 21.2258C15.8979 18.5022 18.6835 15.6559 21.3719 12.5279C21.6377 12.2187 21.8039 11.8397 21.8412 11.4336C22.0062 9.63798 22.3452 4.46467 20.9403 3.05974C19.5353 1.65481 14.362 1.99377 12.5664 2.15876C12.1603 2.19608 11.7813 2.36233 11.472 2.62811C8.34413 5.31646 5.49782 8.10211 2.77424 11.1439Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M7.89552 13.4478L11.7165 9.62684M12.8358 10.7462L13.791 9.79104M8.05972 15.5224L9.01492 14.5672M9.80599 11.5373L12.0448 13.7761M12.0448 13.7761C12.4157 14.1471 12.3957 14.7685 12 15.1642L11.5224 15.6418C11.1267 16.0375 10.5053 16.0575 10.1343 15.6866L7.22388 12.7761M12.0448 13.7761C12.4157 14.1471 13.0372 14.127 13.4328 13.7313L13.9105 13.2537C14.3061 12.858 14.3262 12.2366 13.9552 11.8656L11.0448 8.9552',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinTag' icon.
  static const List<List<dynamic>> bitcoinTag = strokeRoundedBitcoinTag;

  /// JSON structure for the 'strokeRoundedBitcoinTarget' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinTarget = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M20.5 11.9998C20.5 7.3054 16.6944 3.49982 12 3.49982C7.30558 3.49982 3.5 7.3054 3.5 11.9998C3.5 16.6942 7.30558 20.4998 12 20.4998C16.6944 20.4998 20.5 16.6942 20.5 11.9998Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M12 2V5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M22 12L19 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M12 19L12 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M5 12H2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd':
            'M10.4375 14.6667L10.4375 9.33333M12 9.33333V8M12 16V14.6667M10.4375 12H13.5625M13.5625 12C14.0803 12 14.5 12.4477 14.5 13V13.6667C14.5 14.219 14.0803 14.6667 13.5625 14.6667H9.5M13.5625 12C14.0803 12 14.5 11.5523 14.5 11V10.3333C14.5 9.78105 14.0803 9.33333 13.5625 9.33333H9.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinTarget' icon.
  static const List<List<dynamic>> bitcoinTarget = strokeRoundedBitcoinTarget;

  /// JSON structure for the 'strokeRoundedBitcoinTransaction' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinTransaction = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M16.9767 19.5C19.4017 17.8876 21 15.1305 21 12C21 7.02944 16.9706 3 12 3C11.3126 3 10.6432 3.07706 10 3.22302M16.9767 19.5V16M16.9767 19.5H20.5M7 4.51555C4.58803 6.13007 3 8.87958 3 12C3 16.9706 7.02944 21 12 21C12.6874 21 13.3568 20.9229 14 20.777M7 4.51555V8M7 4.51555H3.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M10.4375 14.6667L10.4375 9.33333M12 9.33333V8M12 16V14.6667M10.4375 12H13.5625M13.5625 12C14.0803 12 14.5 12.4477 14.5 13V13.6667C14.5 14.219 14.0803 14.6667 13.5625 14.6667H9.5M13.5625 12C14.0803 12 14.5 11.5523 14.5 11V10.3333C14.5 9.78105 14.0803 9.33333 13.5625 9.33333H9.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinTransaction' icon.
  static const List<List<dynamic>> bitcoinTransaction =
      strokeRoundedBitcoinTransaction;

  /// JSON structure for the 'strokeRoundedBitcoinUp01' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinUp01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12 8.99988C8.41013 8.99988 5.49998 11.91 5.49998 15.4999C5.49998 19.0897 8.41013 21.9999 12 21.9999C15.5898 21.9999 18.5 19.0897 18.5 15.4999C18.5 11.91 15.5898 8.99988 12 8.99988Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M14.5 4.49988C14.0085 3.99418 12.7002 1.99988 12 1.99988M9.49999 4.49988C9.99152 3.99418 11.2998 1.99988 12 1.99988M12 1.99988L12 6.49988',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M10.4375 18.1667L10.4375 12.8333M12 12.8333V11.5M12 19.5V18.1667M10.4375 15.5H13.5625M13.5625 15.5C14.0803 15.5 14.5 15.9477 14.5 16.5V17.1667C14.5 17.719 14.0803 18.1667 13.5625 18.1667H9.49999M13.5625 15.5C14.0803 15.5 14.5 15.0523 14.5 14.5V13.8333C14.5 13.281 14.0803 12.8333 13.5625 12.8333H9.49999',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinUp01' icon.
  static const List<List<dynamic>> bitcoinUp01 = strokeRoundedBitcoinUp01;

  /// JSON structure for the 'strokeRoundedBitcoinUp02' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinUp02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M11.9999 8.99985C8.41007 8.99985 5.49992 11.91 5.49992 15.4998C5.49992 19.0897 8.41007 21.9998 11.9999 21.9998C15.5898 21.9998 18.4999 19.0897 18.4999 15.4998C18.4999 11.91 15.5898 8.99985 11.9999 8.99985Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M20 2L16.0237 5.6148C15.3073 6.26613 14.949 6.5918 14.527 6.56553C14.1051 6.53926 13.79 6.17167 13.1599 5.4365L12.6533 4.84557C12.1043 4.20505 11.8298 3.88479 11.4541 3.83296C11.0783 3.78112 10.7274 4.0151 10.0254 4.48305L4 8.5M20 2H16.5M20 2V5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M10.4374 18.1665L10.4374 12.8332M11.9999 12.8332V11.4998M11.9999 19.4998V18.1665M10.4374 15.4998H13.5624M13.5624 15.4998C14.0802 15.4998 14.4999 15.9476 14.4999 16.4998V17.1665C14.4999 17.7188 14.0802 18.1665 13.5624 18.1665H9.49993M13.5624 15.4998C14.0802 15.4998 14.4999 15.0521 14.4999 14.4998V13.8332C14.4999 13.2809 14.0802 12.8332 13.5624 12.8332H9.49993',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinUp02' icon.
  static const List<List<dynamic>> bitcoinUp02 = strokeRoundedBitcoinUp02;

  /// JSON structure for the 'strokeRoundedBitcoinWallet' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinWallet = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M16 13C16 13.8284 16.6716 14.5 17.5 14.5C18.3284 14.5 19 13.8284 19 13C19 12.1716 18.3284 11.5 17.5 11.5C16.6716 11.5 16 12.1716 16 13Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M11 19H16C18.8284 19 20.2426 19 21.1213 18.1213C22 17.2426 22 15.8284 22 13V12C22 9.17157 22 7.75736 21.1213 6.87868C20.48 6.23738 19.5534 6.06413 18 6.01732M10 6H16C16.7641 6 17.425 6 18 6.01732M2 10C2 6.22876 2 5.34315 3.17157 4.17157C4.34315 3 6.22876 3 10 3H14.9827C15.9308 3 16.4049 3 16.7779 3.15749C17.2579 3.36014 17.6399 3.7421 17.8425 4.22208C18 4.5951 18 5.06917 18 6.01732',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M3.125 19.5L3.125 13.5M5 13.5V12M5 21V19.5M3.125 16.5H6.875M6.875 16.5C7.49632 16.5 8 17.0037 8 17.625V18.375C8 18.9963 7.49632 19.5 6.875 19.5H2M6.875 16.5C7.49632 16.5 8 15.9963 8 15.375V14.625C8 14.0037 7.49632 13.5 6.875 13.5H2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinWallet' icon.
  static const List<List<dynamic>> bitcoinWallet = strokeRoundedBitcoinWallet;

  /// JSON structure for the 'strokeRoundedBitcoinWithdraw' icon.
  static const List<List<dynamic>> strokeRoundedBitcoinWithdraw = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M18.9349 13.9453L18.2646 10.2968C17.9751 8.72096 17.8303 7.93303 17.257 7.46651C16.6837 7 15.8602 7 14.2132 7H9.78685C8.1398 7 7.31628 7 6.74298 7.46651C6.16968 7.93303 6.02492 8.72096 5.73538 10.2968L5.06506 13.9453C4.46408 17.2162 4.16359 18.8517 5.08889 19.9259C6.01419 21 7.72355 21 11.1423 21H12.8577C16.2765 21 17.9858 21 18.9111 19.9259C19.8364 18.8517 19.5359 17.2162 18.9349 13.9453Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M10.4375 16.6667L10.4375 11.3333M12 11.3333V10M12 18V16.6667M10.4375 14H13.5625M13.5625 14C14.0803 14 14.5 14.4477 14.5 15V15.6667C14.5 16.219 14.0803 16.6667 13.5625 16.6667H9.5M13.5625 14C14.0803 14 14.5 13.5523 14.5 13V12.3333C14.5 11.781 14.0803 11.3333 13.5625 11.3333H9.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M21 11C21.1568 10.9209 21.2931 10.8212 21.4142 10.6955C22 10.0875 22 9.10893 22 7.15176C22 5.1946 22 4.21602 21.4142 3.60801C20.8284 3 19.8856 3 18 3L6 3C4.11438 3 3.17157 3 2.58579 3.60801C2 4.21602 2 5.1946 2 7.15176C2 9.10893 2 10.0875 2.58579 10.6955C2.70688 10.8212 2.84322 10.9209 3 11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBitcoinWithdraw' icon.
  static const List<List<dynamic>> bitcoinWithdraw =
      strokeRoundedBitcoinWithdraw;

  /// JSON structure for the 'strokeRoundedBlackHole' icon.
  static const List<List<dynamic>> strokeRoundedBlackHole = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M20.5 5C21.3284 5 22 4.32843 22 3.5C22 2.67157 21.3284 2 20.5 2C19.6716 2 19 2.67157 19 3.5C19 4.32843 19.6716 5 20.5 5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M3.5 22C4.32843 22 5 21.3284 5 20.5C5 19.6716 4.32843 19 3.5 19C2.67157 19 2 19.6716 2 20.5C2 21.3284 2.67157 22 3.5 22Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M21.0385 13.0623C21.6076 12.9268 22 12.4933 22 12C22 11.5067 21.6076 11.0732 21.0385 10.9377L16.5212 9.8622C15.7198 8.17022 13.9966 7 12 7C10.0034 7 8.28021 8.17023 7.47877 9.8622L2.96152 10.9377C2.39239 11.0732 2 11.5067 2 12C2 12.4933 2.39239 12.9268 2.96152 13.0623L7.47877 14.1378C8.28021 15.8298 10.0034 17 12 17C13.9966 17 15.7198 15.8298 16.5212 14.1378L21.0385 13.0623Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M12 14C13.1046 14 14 13.1046 14 12C14 10.8954 13.1046 10 12 10C10.8954 10 10 10.8954 10 12C10 13.1046 10.8954 14 12 14Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M15.0007 2.4578C14.0537 2.16035 13.0459 2 12.0007 2C8.7291 2 5.82441 3.57111 4 6M9.00073 21.5422C9.94777 21.8396 10.9555 22 12.0007 22C15.2719 22 18.1763 20.4293 20.0007 18.001',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBlackHole' icon.
  static const List<List<dynamic>> blackHole = strokeRoundedBlackHole;

  /// JSON structure for the 'strokeRoundedBlackHole01' icon.
  static const List<List<dynamic>> strokeRoundedBlackHole01 = [
    [
      'ellipse',
      {
        'key': '0',
        'cx': '12',
        'cy': '13',
        'rx': '10',
        'ry': '5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18.6017 12C17.6407 13.1652 15.0478 14 12 14C8.95216 14 6.35927 13.1652 5.39832 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M10.063 13.5C10.0219 13.3402 10 13.1726 10 13C10 11.8954 10.8954 11 12 11C13.1046 11 14 11.8954 14 13C14 13.1726 13.9781 13.3402 13.937 13.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M6 4L9 13.5M7 20L9 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M17 6L15 13.5M17 20L15 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M12 2V11M12 22V18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBlackHole01' icon.
  static const List<List<dynamic>> blackHole01 = strokeRoundedBlackHole01;

  /// JSON structure for the 'strokeRoundedBlend' icon.
  static const List<List<dynamic>> strokeRoundedBlend = [
    [
      'circle',
      {
        'key': '0',
        'cx': '17',
        'cy': '17',
        'r': '5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M7.5 13H6.4C4.32582 13 3.28873 13 2.64437 12.3556C2 11.7113 2 10.6742 2 8.6V6.4C2 4.32582 2 3.28873 2.64437 2.64437C3.28873 2 4.32582 2 6.4 2H8.6C10.6742 2 11.7113 2 12.3556 2.64437C13 3.28873 13 4.32582 13 6.4V7.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M12.0348 19C9.17734 18.5206 7 16.0355 7 13.0418C7 9.70499 9.70499 7 13.0418 7C16.0355 7 18.5206 9.17734 19 12.0348',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBlend' icon.
  static const List<List<dynamic>> blend = strokeRoundedBlend;

  /// JSON structure for the 'strokeRoundedBlender' icon.
  static const List<List<dynamic>> strokeRoundedBlender = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M18.4626 4H8.2133M18.4626 4L17.4377 17H9L8.72577 11M18.4626 4H20M8.2133 4H6.35619C5.09456 4 4.46374 4 4.15636 4.40307C3.84899 4.80614 4.03026 5.39566 4.39278 6.5747L4.66786 7.4693C4.90028 8.22521 5.0165 8.60316 5.26185 8.90436C5.5072 9.20555 5.85836 9.40133 6.56065 9.79288L8.72577 11M8.2133 4L8.72577 11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M15 2H12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M17.4668 17H9.05279C8.76014 17.9995 7.45643 20.7076 8.25559 21.634C8.57134 22 9.16523 22 10.353 22H16.5325C17.8279 22 18.4755 22 18.7911 21.5969C19.5834 20.5851 17.8973 17.9653 17.4668 17Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M18 8H15.5M17.5 11H15.5M17.5 14H15.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBlender' icon.
  static const List<List<dynamic>> blender = strokeRoundedBlender;

  /// JSON structure for the 'strokeRoundedBlockGame' icon.
  static const List<List<dynamic>> strokeRoundedBlockGame = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M22 18C22 19.4001 22 20.1002 21.7275 20.635C21.4878 21.1054 21.1054 21.4878 20.635 21.7275C20.1002 22 19.4001 22 18 22C16.5999 22 15.8998 22 15.365 21.7275C14.8946 21.4878 14.5122 21.1054 14.2725 20.635C14 20.1002 14 19.4001 14 18C14 16.5999 14 15.8998 14.2725 15.365C14.5122 14.8946 14.8946 14.5122 15.365 14.2725C15.8998 14 16.5999 14 18 14C19.4001 14 20.1002 14 20.635 14.2725C21.1054 14.5122 21.4878 14.8946 21.7275 15.365C22 15.8998 22 16.5999 22 18Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M22 10C22 11.4001 22 12.1002 21.7275 12.635C21.4878 13.1054 21.1054 13.4878 20.635 13.7275C20.1002 14 19.4001 14 18 14C16.5999 14 15.8998 14 15.365 13.7275C14.8946 13.4878 14.5122 13.1054 14.2725 12.635C14 12.1002 14 11.4001 14 10C14 8.59987 14 7.8998 14.2725 7.36502C14.5122 6.89462 14.8946 6.51217 15.365 6.27248C15.8998 6 16.5999 6 18 6C19.4001 6 20.1002 6 20.635 6.27248C21.1054 6.51217 21.4878 6.89462 21.7275 7.36502C22 7.8998 22 8.59987 22 10Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M14 18C14 19.4001 14 20.1002 13.7275 20.635C13.4878 21.1054 13.1054 21.4878 12.635 21.7275C12.1002 22 11.4001 22 10 22C8.59987 22 7.8998 22 7.36502 21.7275C6.89462 21.4878 6.51217 21.1054 6.27248 20.635C6 20.1002 6 19.4001 6 18C6 16.5999 6 15.8998 6.27248 15.365C6.51217 14.8946 6.89462 14.5122 7.36502 14.2725C7.8998 14 8.59987 14 10 14C11.4001 14 12.1002 14 12.635 14.2725C13.1054 14.5122 13.4878 14.8946 13.7275 15.365C14 15.8998 14 16.5999 14 18Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M10 6C10 7.40013 10 8.1002 9.72752 8.63497C9.48783 9.10538 9.10538 9.48783 8.63498 9.72752C8.1002 10 7.40013 10 6 10C4.59987 10 3.8998 10 3.36502 9.72751C2.89462 9.48783 2.51217 9.10538 2.27248 8.63497C2 8.10019 2 7.40013 2 6C2 4.59987 2 3.8998 2.27248 3.36502C2.51217 2.89462 2.89462 2.51217 3.36502 2.27248C3.8998 2 4.59987 2 6 2C7.40013 2 8.1002 2 8.63498 2.27248C9.10538 2.51217 9.48783 2.89462 9.72752 3.36502C10 3.8998 10 4.59987 10 6Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBlockGame' icon.
  static const List<List<dynamic>> blockGame = strokeRoundedBlockGame;

  /// JSON structure for the 'strokeRoundedBlockchain01' icon.
  static const List<List<dynamic>> strokeRoundedBlockchain01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12 21C12.2792 21 12.5388 20.8728 13.0579 20.6184L17.2304 18.5737C19.0768 17.6688 20 17.2164 20 16.5V7.5M12 21C11.7208 21 11.4612 20.8728 10.9421 20.6184L6.76956 18.5737C4.92319 17.6688 4 17.2164 4 16.5V7.5M12 21V12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M10.9421 3.38159C11.4612 3.1272 11.7208 3 12 3C12.2792 3 12.5388 3.1272 13.0579 3.38159L17.2304 5.42635C19.0768 6.33116 20 6.78357 20 7.5C20 8.21643 19.0768 8.66884 17.2304 9.57365L13.0579 11.6184C12.5388 11.8728 12.2792 12 12 12C11.7208 12 11.4612 11.8728 10.9421 11.6184L6.76956 9.57365C4.92319 8.66884 4 8.21643 4 7.5C4 6.78357 4.92319 6.33116 6.76956 5.42635L10.9421 3.38159Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBlockchain01' icon.
  static const List<List<dynamic>> blockchain01 = strokeRoundedBlockchain01;

  /// JSON structure for the 'strokeRoundedBlockchain02' icon.
  static const List<List<dynamic>> strokeRoundedBlockchain02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12 22C12.2443 22 12.4714 21.8869 12.9256 21.6608L16.5766 19.8432C18.1922 19.039 19 18.6368 19 18V10M12 22C11.7557 22 11.5286 21.8869 11.0744 21.6608L7.42337 19.8432C5.80779 19.039 5 18.6368 5 18V10M12 22V14M19 10C19 9.36317 18.1922 8.96103 16.5766 8.15675L12.9256 6.33919C12.4714 6.11306 12.2443 6 12 6C11.7557 6 11.5286 6.11306 11.0744 6.33919L7.42337 8.15675C5.80779 8.96103 5 9.36317 5 10M19 10C19 10.6368 18.1922 11.039 16.5766 11.8432L12.9256 13.6608C12.4714 13.8869 12.2443 14 12 14M5 10C5 10.6368 5.80779 11.039 7.42337 11.8432L11.0744 13.6608C11.5286 13.8869 11.7557 14 12 14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M22 21L19 18.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 2V6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M2 21L5 18.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBlockchain02' icon.
  static const List<List<dynamic>> blockchain02 = strokeRoundedBlockchain02;

  /// JSON structure for the 'strokeRoundedBlockchain03' icon.
  static const List<List<dynamic>> strokeRoundedBlockchain03 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12 19C12.2094 19 12.4041 18.9011 12.7934 18.7032L15.9228 17.1128C17.3076 16.4091 18 16.0572 18 15.5V8.5M12 19C11.7906 19 11.5959 18.9011 11.2066 18.7032L8.07717 17.1128C6.69239 16.4091 6 16.0572 6 15.5V8.5M12 19V12M18 8.5C18 7.94278 17.3076 7.59091 15.9228 6.88716L12.7934 5.29679C12.4041 5.09893 12.2094 5 12 5C11.7906 5 11.5959 5.09893 11.2066 5.29679L8.07717 6.88716C6.69239 7.59091 6 7.94278 6 8.5M18 8.5C18 9.05722 17.3076 9.40909 15.9228 10.1128L12.7934 11.7032C12.4041 11.9011 12.2094 12 12 12M6 8.5C6 9.05722 6.69239 9.40909 8.07717 10.1128L11.2066 11.7032C11.5959 11.9011 11.7906 12 12 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M13.1901 21.576L17.8842 19.3041C19.9614 18.2987 21 17.796 21 17V7C21 6.20397 19.9614 5.70129 17.8842 4.69594L13.1901 2.42399L13.1901 2.42398C12.6061 2.14133 12.3141 2 12 2C11.6859 2 11.3939 2.14133 10.8099 2.42399L6.11576 4.69594C4.03859 5.70129 3 6.20397 3 7V17C3 17.796 4.03858 18.2987 6.11572 19.304L6.11576 19.3041L10.8099 21.576C11.3939 21.8587 11.6859 22 12 22C12.3141 22 12.6061 21.8587 13.1901 21.576Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBlockchain03' icon.
  static const List<List<dynamic>> blockchain03 = strokeRoundedBlockchain03;

  /// JSON structure for the 'strokeRoundedBlockchain04' icon.
  static const List<List<dynamic>> strokeRoundedBlockchain04 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3.43934 8.56066C3.87868 9 4.58579 9 6 9C7.41421 9 8.12132 9 8.56066 8.56066C9 8.12132 9 7.41421 9 6C9 4.58579 9 3.87868 8.56066 3.43934C8.12132 3 7.41421 3 6 3C4.58579 3 3.87868 3 3.43934 3.43934C3 3.87868 3 4.58579 3 6C3 7.41421 3 8.12132 3.43934 8.56066Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M15.4393 8.56066C15.8787 9 16.5858 9 18 9C19.4142 9 20.1213 9 20.5607 8.56066C21 8.12132 21 7.41421 21 6C21 4.58579 21 3.87868 20.5607 3.43934C20.1213 3 19.4142 3 18 3C16.5858 3 15.8787 3 15.4393 3.43934C15 3.87868 15 4.58579 15 6C15 7.41421 15 8.12132 15.4393 8.56066Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M15.4393 20.5607C15.8787 21 16.5858 21 18 21C19.4142 21 20.1213 21 20.5607 20.5607C21 20.1213 21 19.4142 21 18C21 16.5858 21 15.8787 20.5607 15.4393C20.1213 15 19.4142 15 18 15C16.5858 15 15.8787 15 15.4393 15.4393C15 15.8787 15 16.5858 15 18C15 19.4142 15 20.1213 15.4393 20.5607Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M3.43934 20.5607C3.87868 21 4.58579 21 6 21C7.41421 21 8.12132 21 8.56066 20.5607C9 20.1213 9 19.4142 9 18C9 16.5858 9 15.8787 8.56066 15.4393C8.12132 15 7.41421 15 6 15C4.58579 15 3.87868 15 3.43934 15.4393C3 15.8787 3 16.5858 3 18C3 19.4142 3 20.1213 3.43934 20.5607Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M12 6H9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M15 18H12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd': 'M18 12L18 9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '7',
        'd': 'M6 15L6 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBlockchain04' icon.
  static const List<List<dynamic>> blockchain04 = strokeRoundedBlockchain04;

  /// JSON structure for the 'strokeRoundedBlockchain05' icon.
  static const List<List<dynamic>> strokeRoundedBlockchain05 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12 17C12.2269 17 12.4378 16.894 12.8595 16.682L16.2497 14.978C17.7499 14.224 18.5 13.847 18.5 13.25V5.75M12 17C11.7731 17 11.5623 16.894 11.1405 16.682L7.75027 14.978C6.25009 14.224 5.5 13.847 5.5 13.25V5.75M12 17V9.5M18.5 5.75C18.5 5.15298 17.7499 4.77597 16.2497 4.02196L12.8595 2.31799C12.4377 2.106 12.2269 2 12 2C11.7731 2 11.5623 2.106 11.1405 2.31799L7.75027 4.02196C6.25009 4.77597 5.5 5.15298 5.5 5.75M18.5 5.75C18.5 6.34702 17.7499 6.72403 16.2497 7.47804L12.8595 9.18201C12.4377 9.394 12.2269 9.5 12 9.5M5.5 5.75C5.5 6.34702 6.25009 6.72403 7.75027 7.47804L11.1405 9.18201C11.5623 9.394 11.7731 9.5 12 9.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M10 20.75C10 20.0596 10.5596 19.5 11.25 19.5H12.75C13.4404 19.5 14 20.0596 14 20.75M10 20.75C10 21.4404 10.5596 22 11.25 22H12.75C13.4404 22 14 21.4404 14 20.75M10 20.75H5M14 20.75H19',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBlockchain05' icon.
  static const List<List<dynamic>> blockchain05 = strokeRoundedBlockchain05;

  /// JSON structure for the 'strokeRoundedBlockchain06' icon.
  static const List<List<dynamic>> strokeRoundedBlockchain06 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5.5 10C5.62215 10 5.73571 9.94347 5.96282 9.83041L7.78832 8.92162C8.59611 8.51948 9 8.31841 9 8V4M5.5 10C5.37785 10 5.26429 9.94347 5.03718 9.83041L3.21168 8.92162C2.4039 8.51948 2 8.31841 2 8V4M5.5 10V6M9 4C9 3.68159 8.59611 3.48052 7.78832 3.07838L5.96282 2.16959C5.73571 2.05653 5.62215 2 5.5 2C5.37785 2 5.26429 2.05653 5.03718 2.16959L3.21168 3.07838C2.40389 3.48052 2 3.68159 2 4M9 4C9 4.31841 8.59611 4.51948 7.78832 4.92162L5.96282 5.83041C5.73571 5.94347 5.62215 6 5.5 6M2 4C2 4.31841 2.40389 4.51948 3.21168 4.92162L5.03718 5.83041C5.26429 5.94347 5.37785 6 5.5 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18.5 10C18.6222 10 18.7357 9.94347 18.9628 9.83041L20.7883 8.92162C21.5961 8.51948 22 8.31841 22 8V4M18.5 10C18.3778 10 18.2643 9.94347 18.0372 9.83041L16.2117 8.92162C15.4039 8.51948 15 8.31841 15 8V4M18.5 10V6M22 4C22 3.68159 21.5961 3.48052 20.7883 3.07838L18.9628 2.16959C18.7357 2.05653 18.6222 2 18.5 2C18.3778 2 18.2643 2.05653 18.0372 2.16959L16.2117 3.07838C15.4039 3.48052 15 3.68159 15 4M22 4C22 4.31841 21.5961 4.51948 20.7883 4.92162L18.9628 5.83041C18.7357 5.94347 18.6222 6 18.5 6M15 4C15 4.31841 15.4039 4.51948 16.2117 4.92162L18.0372 5.83041C18.2643 5.94347 18.3778 6 18.5 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M11.5 6H12.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M2 12V15.5C2 16.9045 2 17.6067 2.33706 18.1111C2.48298 18.3295 2.67048 18.517 2.88886 18.6629C3.39331 19 4.09554 19 5.5 19',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M22 12V15.5C22 16.9045 22 17.6067 21.6629 18.1111C21.517 18.3295 21.3295 18.517 21.1111 18.6629C20.6067 19 19.9045 19 18.5 19',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd':
            'M12 22C12.1222 22 12.2357 21.9435 12.4628 21.8304L14.2883 20.9216C15.0961 20.5195 15.5 20.3184 15.5 20V16M12 22C11.8778 22 11.7643 21.9435 11.5372 21.8304L9.71168 20.9216C8.9039 20.5195 8.5 20.3184 8.5 20V16M12 22V18M15.5 16C15.5 15.6816 15.0961 15.4805 14.2883 15.0784L12.4628 14.1696C12.2357 14.0565 12.1222 14 12 14C11.8778 14 11.7643 14.0565 11.5372 14.1696L9.71168 15.0784C8.90389 15.4805 8.5 15.6816 8.5 16M15.5 16C15.5 16.3184 15.0961 16.5195 14.2883 16.9216L12.4628 17.8304C12.2357 17.9435 12.1222 18 12 18M8.5 16C8.5 16.3184 8.90389 16.5195 9.71168 16.9216L11.5372 17.8304C11.7643 17.9435 11.8778 18 12 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBlockchain06' icon.
  static const List<List<dynamic>> blockchain06 = strokeRoundedBlockchain06;

  /// JSON structure for the 'strokeRoundedBlockchain07' icon.
  static const List<List<dynamic>> strokeRoundedBlockchain07 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5.49993 10.5C5.62208 10.5 5.73564 10.4435 5.96275 10.3304L7.78824 9.42162C8.59603 9.01948 8.99993 8.81841 8.99993 8.5V4.5M5.49993 10.5C5.37777 10.5 5.26422 10.4435 5.03711 10.3304L3.21161 9.42162C2.40382 9.01948 1.99993 8.81841 1.99993 8.5V4.5M5.49993 10.5V6.5M8.99993 4.5C8.99993 4.18159 8.59603 3.98052 7.78824 3.57838L5.96275 2.66959C5.73564 2.55653 5.62208 2.5 5.49993 2.5C5.37777 2.5 5.26422 2.55653 5.03711 2.66959L3.21161 3.57838C2.40382 3.98052 1.99993 4.18159 1.99993 4.5M8.99993 4.5C8.99993 4.81841 8.59603 5.01948 7.78824 5.42162L5.96275 6.33041C5.73564 6.44347 5.62208 6.5 5.49993 6.5M1.99993 4.5C1.99993 4.81841 2.40382 5.01948 3.21161 5.42162L5.03711 6.33041C5.26422 6.44347 5.37777 6.5 5.49993 6.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18.4999 10.5C18.6221 10.5 18.7356 10.4435 18.9627 10.3304L20.7882 9.42162C21.596 9.01948 21.9999 8.81841 21.9999 8.5V4.5M18.4999 10.5C18.3778 10.5 18.2642 10.4435 18.0371 10.3304L16.2116 9.42162C15.4038 9.01948 14.9999 8.81841 14.9999 8.5V4.5M18.4999 10.5V6.5M21.9999 4.5C21.9999 4.18159 21.596 3.98052 20.7882 3.57838L18.9627 2.66959C18.7356 2.55653 18.6221 2.5 18.4999 2.5C18.3778 2.5 18.2642 2.55653 18.0371 2.66959L16.2116 3.57838C15.4038 3.98052 14.9999 4.18159 14.9999 4.5M21.9999 4.5C21.9999 4.81841 21.596 5.01948 20.7882 5.42162L18.9627 6.33041C18.7356 6.44347 18.6221 6.5 18.4999 6.5M14.9999 4.5C14.9999 4.81841 15.4038 5.01948 16.2116 5.42162L18.0371 6.33041C18.2642 6.44347 18.3778 6.5 18.4999 6.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M11.4999 6.5H12.4999',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M1.99993 12.5V16C1.99993 17.4045 1.99993 18.1067 2.33699 18.6111C2.48291 18.8295 2.67041 19.017 2.88879 19.1629C3.39323 19.5 4.09547 19.5 5.49993 19.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M22.0001 12.5V16C22.0001 17.4045 22.0001 18.1067 21.663 18.6111C21.5171 18.8295 21.3296 19.017 21.1112 19.1629C20.6068 19.5 19.9044 19.5 18.4999 19.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd':
            'M10.2499 16.9311C10.4251 16.9286 10.6187 16.9286 10.8333 16.9286H13.1666C13.3811 16.9286 13.5747 16.9286 13.7499 16.9311M10.2499 16.9311C9.52672 16.9413 9.1167 16.9939 8.84164 17.2633C8.49993 17.598 8.49993 18.1368 8.49993 19.2143C8.49993 20.2918 8.49993 20.8305 8.84164 21.1653C9.18335 21.5 9.73332 21.5 10.8333 21.5H13.1666C14.2665 21.5 14.8165 21.5 15.1582 21.1653C15.4999 20.8305 15.4999 20.2918 15.4999 19.2143C15.4999 18.1368 15.4999 17.598 15.1582 17.2633C14.8832 16.9939 14.4731 16.9413 13.7499 16.9311M10.2499 16.9311V15.2143C10.2499 14.2675 11.0334 13.5 11.9999 13.5C12.9664 13.5 13.7499 14.2675 13.7499 15.2143V16.9311',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBlockchain07' icon.
  static const List<List<dynamic>> blockchain07 = strokeRoundedBlockchain07;

  /// JSON structure for the 'strokeRoundedBlocked' icon.
  static const List<List<dynamic>> strokeRoundedBlocked = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M18.7088 3.49534C16.8165 2.55382 14.5009 2 12 2C9.4991 2 7.1835 2.55382 5.29116 3.49534C4.36318 3.95706 3.89919 4.18792 3.4496 4.91378C3 5.63965 3 6.34248 3 7.74814V11.2371C3 16.9205 7.54236 20.0804 10.173 21.4338C10.9067 21.8113 11.2735 22 12 22C12.7265 22 13.0933 21.8113 13.8269 21.4338C16.4576 20.0804 21 16.9205 21 11.2371L21 7.74814C21 6.34249 21 5.63966 20.5504 4.91378C20.1008 4.18791 19.6368 3.95706 18.7088 3.49534Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M9.52514 13.4744C10.1585 14.1078 11.0335 14.4995 12 14.4995C13.933 14.4995 15.5 12.9324 15.5 10.9995C15.5 10.033 15.1083 9.15801 14.4749 8.52464M9.52514 13.4744C8.89175 12.841 8.5 11.966 8.5 10.9995C8.5 9.06651 10.067 7.49951 12 7.49951C12.9665 7.49951 13.8415 7.89126 14.4749 8.52464M9.52514 13.4744L14.4749 8.52464',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBlocked' icon.
  static const List<List<dynamic>> blocked = strokeRoundedBlocked;

  /// JSON structure for the 'strokeRoundedBlogger' icon.
  static const List<List<dynamic>> strokeRoundedBlogger = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M10 10H11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M10 15H14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M14.9577 11.4622V10.5088C14.9577 8.63614 14.9577 7.69981 14.4825 7.04341C13.5821 5.79972 11.833 6.01409 10.4788 6.01409C9.12474 6.01409 7.37562 5.79972 6.47521 7.04341C6 7.69981 6 8.63614 6 10.5088V13.0059C6 15.3601 6 16.5373 6.72879 17.2686C7.45758 18 8.63055 18 10.9765 18H14.6862C17.285 18 18.3239 16.1725 17.913 13.5687C17.6684 12.0195 16.3315 11.4622 14.9577 11.4622Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBlogger' icon.
  static const List<List<dynamic>> blogger = strokeRoundedBlogger;

  /// JSON structure for the 'strokeRoundedBlood' icon.
  static const List<List<dynamic>> strokeRoundedBlood = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5.5 15.5C3.28795 14.6166 2 12.4328 2 10.1746C2 7.24571 4.31698 4.35135 5.94326 2.68056C6.82649 1.77315 8.17351 1.77315 9.05674 2.68056C9.54874 3.18602 9.96485 3.80348 10.5 4.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M8 14.9263C8 11.3698 10.9489 7.85521 13.0187 5.82639C14.1428 4.72454 15.8572 4.72454 16.9813 5.82639C19.0511 7.85521 22 11.3698 22 14.9263C22 18.4134 19.3492 22 15 22C10.6508 22 8 18.4134 8 14.9263Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M18.5 15.5C18.5 17.7091 17 18.5 15.5 18.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBlood' icon.
  static const List<List<dynamic>> blood = strokeRoundedBlood;

  /// JSON structure for the 'strokeRoundedBloodBag' icon.
  static const List<List<dynamic>> strokeRoundedBloodBag = [
    [
      'path',
      {
        'key': '0',
        'd': 'M5 7.37225C13 3.24278 11.5 10.0046 19 7.37228',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M5 9C5 6.19108 5 4.78661 5.67412 3.77772C5.96596 3.34096 6.34096 2.96596 6.77772 2.67412C7.78661 2 9.19108 2 12 2C14.8089 2 16.2134 2 17.2223 2.67412C17.659 2.96596 18.034 3.34096 18.3259 3.77772C19 4.78661 19 6.19108 19 9V11C19 13.8089 19 15.2134 18.3259 16.2223C18.034 16.659 17.659 17.034 17.2223 17.3259C16.2134 18 14.8089 18 12 18C9.19108 18 7.78661 18 6.77772 17.3259C6.34096 17.034 5.96596 16.659 5.67412 16.2223C5 15.2134 5 13.8089 5 11V9Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M12.0142 10L10.5736 11.4876C9.79996 12.3003 9.81331 13.6088 10.587 14.4077C11.3739 15.2066 12.6411 15.1928 13.4148 14.3939C14.2017 13.5812 14.1884 12.2727 13.4148 11.4738L12.0142 10Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M8 22C10.2091 22 12 20.2091 12 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBloodBag' icon.
  static const List<List<dynamic>> bloodBag = strokeRoundedBloodBag;

  /// JSON structure for the 'strokeRoundedBloodBottle' icon.
  static const List<List<dynamic>> strokeRoundedBloodBottle = [
    [
      'path',
      {
        'key': '0',
        'd': 'M14 5V2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M17 2H9C6.64298 2 5.46447 2 4.73223 2.73223C4 3.46447 4 4.64298 4 7V22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M8 11.125C8 8.66719 8 7.43829 8.57782 6.5555C8.82796 6.17334 9.14939 5.84521 9.52376 5.58986C10.3885 5 11.5924 5 14 5C16.4076 5 17.6115 5 18.4762 5.58986C18.8506 5.84521 19.172 6.17334 19.4222 6.5555C20 7.43829 20 8.66719 20 11.125V12.875C20 15.3328 20 16.5617 19.4222 17.4445C19.172 17.8267 18.8506 18.1548 18.4762 18.4101C17.6115 19 16.4076 19 14 19C11.5924 19 10.3885 19 9.52376 18.4101C9.14939 18.1548 8.82796 17.8267 8.57782 17.4445C8 16.5617 8 15.3328 8 12.875V11.125Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M8 10.3722C14.8571 6.24278 13.5714 13.0046 20 10.3723',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M11 22C12.6569 22 14 20.6569 14 19',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBloodBottle' icon.
  static const List<List<dynamic>> bloodBottle = strokeRoundedBloodBottle;

  /// JSON structure for the 'strokeRoundedBloodPressure' icon.
  static const List<List<dynamic>> strokeRoundedBloodPressure = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M9 13H9.80031C10.4304 13 10.7454 13 10.9985 13.1493C11.2517 13.2987 11.3926 13.5677 11.6743 14.1056L13.1905 17L15.2857 11L16.8018 13.8944C17.0836 14.4323 17.2245 14.7013 17.4777 14.8507C17.7308 15 18.0458 15 18.6759 15H20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M20.5 12C19.732 8.4154 16.7237 5.03871 14.5241 2.97222C13.1443 1.67593 11.04 1.67593 9.66019 2.97222C7.11961 5.35907 3.5 9.49387 3.5 13.678C3.5 17.7804 6.75366 22 12.0921 22C15.4851 22 18.0359 20.2955 19.4444 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBloodPressure' icon.
  static const List<List<dynamic>> bloodPressure = strokeRoundedBloodPressure;

  /// JSON structure for the 'strokeRoundedBloodType' icon.
  static const List<List<dynamic>> strokeRoundedBloodType = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3.5 13.678C3.5 9.49387 7.08079 5.35907 9.59413 2.97222C10.9591 1.67593 13.0409 1.67593 14.4059 2.97222C16.9192 5.35907 20.5 9.49387 20.5 13.678C20.5 17.7804 17.2812 22 12 22C6.71878 22 3.5 17.7804 3.5 13.678Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M9 15C9 15 9.3648 14.2616 9.84 13.3029M15 15C15 15 14.6352 14.2616 14.16 13.3029M9.84 13.3029C10.7194 11.5287 11.9768 9 12 9C12.0232 9 13.2806 11.5287 14.16 13.3029M9.84 13.3029H14.16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBloodType' icon.
  static const List<List<dynamic>> bloodType = strokeRoundedBloodType;

  /// JSON structure for the 'strokeRoundedBluesky' icon.
  static const List<List<dynamic>> strokeRoundedBluesky = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12 11.4963C11.8936 11.2963 7.45492 3 3.50417 3C1.33647 3 2.00456 8 2.50443 10.5C2.70653 11.5108 3.50417 14.5 8.003 14C8.003 14 4.00404 14.5 4.00404 17C4.00404 18.5 6.50339 21 8.50287 21C10.4606 21 11.9391 16.6859 12 16.5058C12.0609 16.6859 13.5394 21 15.4971 21C17.4966 21 19.996 18.5 19.996 17C19.996 14.5 15.997 14 15.997 14C20.4958 14.5 21.2935 11.5108 21.4956 10.5C21.9954 8 22.6635 3 20.4958 3C16.5451 3 12.1064 11.2963 12 11.4963Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBluesky' icon.
  static const List<List<dynamic>> bluesky = strokeRoundedBluesky;

  /// JSON structure for the 'strokeRoundedBluetooth' icon.
  static const List<List<dynamic>> strokeRoundedBluetooth = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M11.9994 12V6.66586C11.9994 4.80386 11.9994 3.87286 12.5847 3.578C13.17 3.28313 13.9092 3.84173 15.3877 4.95893L16.0935 5.49234C17.1288 6.27468 17.6465 6.66586 17.6465 7.19927C17.6465 7.73268 17.1288 8.12386 16.0935 8.9062L11.9994 12ZM11.9994 12V17.3341C11.9994 19.1961 11.9994 20.1271 12.5847 20.422C13.17 20.7169 13.9092 20.1583 15.3877 19.0411L16.0935 18.5077C17.1288 17.7253 17.6465 17.3341 17.6465 16.8007C17.6465 16.2673 17.1288 15.8761 16.0935 15.0938L11.9994 12ZM11.9994 12L5.64648 7.19927M11.9994 12L5.64648 16.8007',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M18.9998 12H19.0088',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M4.99981 12H5.00879',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBluetooth' icon.
  static const List<List<dynamic>> bluetooth = strokeRoundedBluetooth;

  /// JSON structure for the 'strokeRoundedBluetoothCircle' icon.
  static const List<List<dynamic>> strokeRoundedBluetoothCircle = [
    [
      'circle',
      {
        'key': '0',
        'cx': '12',
        'cy': '12',
        'r': '10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M11.5953 12V8.61228C11.5953 7.66908 11.5953 7.19748 11.8894 7.0428C12.1835 6.88812 12.559 7.16224 13.31 7.71046L14.1553 8.32755C14.7184 8.73866 15 8.94421 15 9.22937C15 9.51453 14.7184 9.72009 14.1553 10.1312L11.5953 12ZM11.5953 12V15.3877C11.5953 16.3309 11.5953 16.8025 11.8894 16.9572C12.1835 17.1119 12.559 16.8378 13.31 16.2895L14.1553 15.6725C14.7184 15.2613 15 15.0558 15 14.7706C15 14.4855 14.7184 14.2799 14.1553 13.8688L11.5953 12ZM11.5953 12L9 9.77778M11.5953 12L9 14.2222',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBluetoothCircle' icon.
  static const List<List<dynamic>> bluetoothCircle =
      strokeRoundedBluetoothCircle;

  /// JSON structure for the 'strokeRoundedBluetoothNotConnected' icon.
  static const List<List<dynamic>> strokeRoundedBluetoothNotConnected = [
    [
      'path',
      {
        'key': '0',
        'd': 'M4 3.99304L20 20.0137',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12.0094 7.97976C12.0094 6.85151 11.8211 4.37371 12.4988 3.62154C13.3394 2.88737 16.666 5.70138 18.2835 7.05515C17.4525 7.90736 17.0866 8.72598 14.6659 10.5223',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M17.5002 17.5094C14.6596 19.5714 13.4835 20.7985 12.6288 20.4349C12.5439 20.3988 12.4741 20.3348 12.427 20.2554C11.9013 19.3692 12.0095 17.0485 12.0095 15.9707V11.9932L4.97754 16.7063',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBluetoothNotConnected' icon.
  static const List<List<dynamic>> bluetoothNotConnected =
      strokeRoundedBluetoothNotConnected;

  /// JSON structure for the 'strokeRoundedBluetoothSearch' icon.
  static const List<List<dynamic>> strokeRoundedBluetoothSearch = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M8.77349 11.5C8.8749 7.08726 8.48911 3.78672 9.15201 3.18692C9.21537 3.12959 9.28932 3.08325 9.36678 3.04779C10.2369 2.64938 12.688 4.83294 14.2923 6.22156C14.5558 6.44968 14.5742 6.85339 14.3152 7.08672C13.1694 8.11876 10.8318 9.95773 8.77349 11.5ZM8.77349 11.5L2.51051 16.2903M8.77349 11.5C8.8749 15.9127 8.48911 19.2133 9.15201 19.8131C9.21537 19.8704 9.28942 19.9168 9.36688 19.9523C9.74875 20.127 10.435 19.8046 11.2205 19.2705M2.5 6.72564L11.4146 13.5528',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M19.6322 19.1589L21.5 21M20.7074 16.5964C20.7074 18.5826 19.094 20.1928 17.1037 20.1928C15.1134 20.1928 13.5 18.5826 13.5 16.5964C13.5 14.6102 15.1134 13 17.1037 13C19.094 13 20.7074 14.6102 20.7074 16.5964Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBluetoothSearch' icon.
  static const List<List<dynamic>> bluetoothSearch =
      strokeRoundedBluetoothSearch;

  /// JSON structure for the 'strokeRoundedBluetoothSquare' icon.
  static const List<List<dynamic>> strokeRoundedBluetoothSquare = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M11.5953 12V8.61228C11.5953 7.66908 11.5953 7.19748 11.8894 7.0428C12.1835 6.88812 12.559 7.16224 13.31 7.71046L14.1553 8.32755C14.7184 8.73866 15 8.94421 15 9.22937C15 9.51453 14.7184 9.72009 14.1553 10.1312L11.5953 12ZM11.5953 12V15.3877C11.5953 16.3309 11.5953 16.8025 11.8894 16.9572C12.1835 17.1119 12.559 16.8378 13.31 16.2895L14.1553 15.6725C14.7184 15.2613 15 15.0558 15 14.7706C15 14.4855 14.7184 14.2799 14.1553 13.8688L11.5953 12ZM11.5953 12L9 9.77778M11.5953 12L9 14.2222',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBluetoothSquare' icon.
  static const List<List<dynamic>> bluetoothSquare =
      strokeRoundedBluetoothSquare;

  /// JSON structure for the 'strokeRoundedBlur' icon.
  static const List<List<dynamic>> strokeRoundedBlur = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12.5926 2.21C12.2371 1.93 11.7433 1.93 11.3877 2.21C9.51122 3.66 3.97049 8.39 4.00012 13.9C4.00012 18.36 7.58531 22 12.0001 22C16.4149 22 20 18.37 20 13.91C20.0099 8.48 14.4593 3.67 12.5926 2.21Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'stroke-miterlimit': '10'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M12 2V22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 19L20 15M12 14.1806L19 10.5M12 9.36145L16.5727 7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBlur' icon.
  static const List<List<dynamic>> blur = strokeRoundedBlur;

  /// JSON structure for the 'strokeRoundedBlushBrush01' icon.
  static const List<List<dynamic>> strokeRoundedBlushBrush01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M8.06505 11.0322L2.8836 12.8234C0.435955 13.7381 3.73502 17.9574 4.82985 19.0466C5.92467 20.1359 10.3317 23.5832 11.2511 21.1481L12.9942 15.9361M3.23407 16.49L5.93576 15.1122M7.63912 20.4976L8.89322 18.0545',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12.6264 8.24924L13.6286 7.25217C14.0229 6.85992 14.7109 6.93348 15.1052 7.32572L16.6694 8.8819C17.0636 9.27415 17.0636 9.9101 16.6694 10.3023L15.6671 11.2994C15.3716 11.5934 15.1751 11.9714 15.1046 12.3812L14.6101 15.2579C14.472 16.0612 13.4804 16.3751 12.9011 15.7988L8.36308 11.0114C7.78382 10.4351 7.88891 9.51181 8.69639 9.37441L11.5878 8.88241C11.9998 8.81232 12.3309 8.54324 12.6264 8.24924Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M16.9446 9.00217L21.5271 4.26023C22.8841 2.91024 21.0186 1.16009 19.7192 2.45293L14.9254 6.99335',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBlushBrush01' icon.
  static const List<List<dynamic>> blushBrush01 = strokeRoundedBlushBrush01;

  /// JSON structure for the 'strokeRoundedBlushBrush02' icon.
  static const List<List<dynamic>> strokeRoundedBlushBrush02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12 13L15 15M12 13C7.52052 15.7458 4.88172 14.7808 3 13.8508C3 15.9297 3.68122 17.6692 4.69609 19M12 13L15 8.41396M15 15C14.781 17.0373 13.4267 21.1851 10.1556 22C8.34064 22 6.16762 20.9296 4.69609 19M15 15L17.5978 10M17.5978 10L20.876 3.69028C21.1655 3.1134 20.9308 2.41193 20.3519 2.12349C19.7937 1.84536 19.1147 2.05196 18.8076 2.59338L15 8.41396M17.5978 10L15 8.41396M4.69609 19C5.73446 19.1667 8.28008 19.2 10.1556 18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M6 4L6.22108 4.59745C6.51097 5.38087 6.65592 5.77259 6.94167 6.05834C7.22741 6.34408 7.61913 6.48903 8.40255 6.77892L9 7L8.40255 7.22108C7.61913 7.51097 7.22741 7.65592 6.94167 7.94167C6.65592 8.22741 6.51097 8.61913 6.22108 9.40255L6 10L5.77892 9.40255C5.48903 8.61913 5.34408 8.22741 5.05833 7.94167C4.77259 7.65592 4.38087 7.51097 3.59745 7.22108L3 7L3.59745 6.77892C4.38087 6.48903 4.77259 6.34408 5.05833 6.05833C5.34408 5.77259 5.48903 5.38087 5.77892 4.59745L6 4Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBlushBrush02' icon.
  static const List<List<dynamic>> blushBrush02 = strokeRoundedBlushBrush02;

  /// JSON structure for the 'strokeRoundedBoardMath' icon.
  static const List<List<dynamic>> strokeRoundedBoardMath = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3 10C3 6.22876 3 4.34315 4.17157 3.17157C5.34315 2 7.22876 2 11 2H13C16.7712 2 18.6569 2 19.8284 3.17157C21 4.34315 21 6.22876 21 10V16H3V10Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M2 16H22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M4 22L7 16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M20 22L17 16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M13 9H11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M8 11L8 7L7 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd': 'M17 11L17 7L16 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '7',
        'd': 'M12 20L12 16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBoardMath' icon.
  static const List<List<dynamic>> boardMath = strokeRoundedBoardMath;

  /// JSON structure for the 'strokeRoundedBoat' icon.
  static const List<List<dynamic>> strokeRoundedBoat = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2 21.1932C2.68524 22.2443 3.57104 22.2443 4.27299 21.1932C6.52985 17.7408 8.67954 23.6764 10.273 21.2321C12.703 17.5694 14.4508 23.9218 16.273 21.1932C18.6492 17.5582 20.1295 23.5776 22 21.5842',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M3.57228 17L2.07481 12.6457C1.80373 11.8574 2.30283 11 3.03273 11H20.8582C23.9522 11 19.9943 17 17.9966 17',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M18 11L15.201 7.50122C14.4419 6.55236 13.2926 6 12.0775 6H8C6.89543 6 6 6.89543 6 8V11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M10 6V3C10 2.44772 9.55228 2 9 2H8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBoat' icon.
  static const List<List<dynamic>> boat = strokeRoundedBoat;

  /// JSON structure for the 'strokeRoundedBodyArmor' icon.
  static const List<List<dynamic>> strokeRoundedBodyArmor = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M13.5042 2.63763L13.2523 2.84528C12.6518 3.34018 12.3516 3.58763 12 3.58763C11.6484 3.58763 11.3482 3.34018 10.7477 2.84528L10.4958 2.63763C10.0093 2.23667 9.76608 2.03618 9.4745 2.00436C9.18293 1.97253 8.90431 2.11606 8.34708 2.40311L8.04374 2.55937C7.76658 2.70214 7.62799 2.77353 7.55282 2.91883C7.47764 3.06412 7.49496 3.20316 7.52961 3.48123C7.80639 5.70292 9.49137 7.79731 11.6105 8.4264C11.7758 8.47547 11.8585 8.5 12 8.5C12.1415 8.5 12.2242 8.47547 12.3895 8.4264C14.5086 7.79731 16.1936 5.70292 16.4704 3.48123C16.505 3.20316 16.5224 3.06412 16.4472 2.91883C16.372 2.77353 16.2334 2.70214 15.9563 2.55937L15.6529 2.40311C15.0957 2.11606 14.8171 1.97253 14.5255 2.00436C14.2339 2.03618 13.9907 2.23667 13.5042 2.63763Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M7.47845 4C5.39181 4.40673 3.99587 5.15004 2.71906 6.22994C2.34598 6.54548 2.15944 6.70325 2.07149 6.95405C1.78191 7.77982 2.41507 10.6215 3.1969 10.9489C3.68378 11.1528 4.36534 10.7348 5.72847 9.89886C6.96545 9.14023 8.48273 8.35455 10 7.93205',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M16.5215 4C18.6082 4.40673 20.0041 5.15004 21.2809 6.22994C21.654 6.54548 21.8406 6.70325 21.9285 6.95405C22.2181 7.77982 21.5849 10.6215 20.8031 10.9489C20.3162 11.1528 19.6347 10.7348 18.2715 9.89886C17.0345 9.14023 15.5173 8.35455 14 7.93205',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M18 10L17.3954 15.4417C17.2073 17.1343 17.1133 17.9805 16.5438 18.4903C15.9742 19 15.1228 19 13.4198 19H10.5802C8.87723 19 8.02576 19 7.45624 18.4903C6.88672 17.9805 6.79269 17.1343 6.60464 15.4417L6 10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M15.3851 19H8.61489C8.36045 19 8.23323 19 8.11238 19.0141C7.67638 19.065 7.26868 19.2517 6.94957 19.5465C6.86112 19.6282 6.77968 19.7238 6.61679 19.9149C6.29629 20.2908 6.13605 20.4788 6.07619 20.6222C5.85054 21.1628 6.14463 21.7765 6.7139 21.9532C6.8649 22 7.11522 22 7.61584 22H16.3842C16.8848 22 17.1351 22 17.2861 21.9532C17.8554 21.7765 18.1495 21.1628 17.9238 20.6222C17.864 20.4788 17.7037 20.2908 17.3832 19.9149C17.2203 19.7238 17.1389 19.6282 17.0504 19.5465C16.7313 19.2517 16.3236 19.065 15.8876 19.0141C15.7668 19 15.6396 19 15.3851 19Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBodyArmor' icon.
  static const List<List<dynamic>> bodyArmor = strokeRoundedBodyArmor;

  /// JSON structure for the 'strokeRoundedBodyPartLeg' icon.
  static const List<List<dynamic>> strokeRoundedBodyPartLeg = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5.00183 2C7.69316 2.31359 13.8994 3.89572 16.6428 7.74552C16.9785 8.21643 17.3319 8.54976 17.9113 8.69637C18.6361 8.87638 19.2359 9.36245 19.4537 10.0961C19.6856 10.8944 20.1138 11.7364 19.9778 12.5901C19.9257 12.9169 19.7657 13.218 19.4457 13.82L15.0988 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M4.00183 12C5.00183 13.7264 8.16622 14.5959 12.0018 13.7264C11.4156 14.0677 10.4146 14.6835 9.31712 15.9511C8.75814 16.5968 8.51959 17.4954 8.48067 18.4026C8.42865 19.615 8.24879 20.9338 7.62683 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M5.00183 7C5.00183 7 6.9608 7.28919 8.50183 8.5C9.50183 9.28571 11.4185 9.80952 12.0018 10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBodyPartLeg' icon.
  static const List<List<dynamic>> bodyPartLeg = strokeRoundedBodyPartLeg;

  /// JSON structure for the 'strokeRoundedBodyPartMuscle' icon.
  static const List<List<dynamic>> strokeRoundedBodyPartMuscle = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.01792 20.3051C3.14656 21.9196 8.05942 23.1871 10.3797 20.1645C12.8894 21.3649 17.0289 20.9928 20.3991 19.1134C20.8678 18.8521 21.3112 18.5222 21.5827 18.0593C22.1957 17.0143 22.2102 15.5644 21.0919 13.4251C19.2274 8.77072 15.874 4.68513 14.5201 3.04212C14.2421 2.78865 12.4687 2.42868 11.3872 2.08279C10.9095 1.93477 10.02 1.83664 8.95612 3.23862C8.45176 3.90329 6.16059 5.5357 9.06767 6.63346C9.51805 6.74806 9.84912 6.95939 11.9038 6.58404C12.1714 6.53761 12.8395 6.58404 13.3103 7.41041L14.2936 8.81662C14.3851 8.94752 14.4445 9.09813 14.4627 9.25682C14.635 10.7557 14.6294 12.6323 15.4651 13.5826C14.1743 12.6492 10.8011 11.5406 8.2595 14.6951M2.00189 12.94C3.21009 11.791 6.71197 9.97592 10.4179 12.5216',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBodyPartMuscle' icon.
  static const List<List<dynamic>> bodyPartMuscle = strokeRoundedBodyPartMuscle;

  /// JSON structure for the 'strokeRoundedBodyPartSixPack' icon.
  static const List<List<dynamic>> strokeRoundedBodyPartSixPack = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M22 4V4.58579C22 4.7544 22 4.83871 21.9956 4.91994C21.9585 5.60243 21.6896 6.25181 21.2332 6.7606C21.1788 6.82116 21.1192 6.88077 21 7C20.8808 7.11923 20.8212 7.17884 20.7606 7.23317C20.2518 7.68957 19.6024 7.95855 18.9199 7.99559C18.8387 8 18.7544 8 18.5858 8H16.4142C16.2456 8 16.1613 8 16.0801 7.99559C15.3976 7.95855 14.7482 7.68957 14.2394 7.23317C14.1788 7.17884 14.1192 7.11923 14 7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M20.5 7.5L20 10L19.3078 12.4227C19.1036 13.1374 19 13.8771 19 14.6204V14.9315C19 15.31 19.0269 15.6881 19.0804 16.0628L19.5 20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M3.5 7.5L4 10L4.69219 12.4227C4.8964 13.1374 5 13.8771 5 14.6204V14.9315C5 15.31 4.97313 15.6881 4.9196 16.0628L4.5 20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M2 4V4.58579C2 4.7544 2 4.83871 2.00441 4.91994C2.04145 5.60243 2.31043 6.25181 2.76683 6.7606C2.82116 6.82116 2.88077 6.88077 3 7C3.11923 7.11923 3.17884 7.17884 3.2394 7.23317C3.74819 7.68957 4.39757 7.95855 5.08006 7.99559C5.16129 8 5.2456 8 5.41421 8H7.58579C7.7544 8 7.83871 8 7.91994 7.99559C8.60243 7.95855 9.25181 7.68957 9.7606 7.23317C9.82116 7.17884 9.88077 7.11923 10 7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M15 13H14C12.8954 13 12 12.1046 12 11C12 12.1046 11.1046 13 10 13H9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd':
            'M15 18H14C12.8954 18 12 17.1046 12 16C12 17.1046 11.1046 18 10 18H9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBodyPartSixPack' icon.
  static const List<List<dynamic>> bodyPartSixPack =
      strokeRoundedBodyPartSixPack;

  /// JSON structure for the 'strokeRoundedBodySoap' icon.
  static const List<List<dynamic>> strokeRoundedBodySoap = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4.5 13C4.5 10.2386 6.73858 8 9.5 8C12.2614 8 14.5 10.2386 14.5 13V18C14.5 19.8856 14.5 20.8284 13.9142 21.4142C13.3284 22 12.3856 22 10.5 22H8.5C6.61438 22 5.67157 22 5.08579 21.4142C4.5 20.8284 4.5 19.8856 4.5 18V13Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M14.5 13.1122C10.8607 9.83944 8.89093 14.9405 4.5 13.8418',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M7.5 8V7C7.5 6.05719 7.5 5.58579 7.79289 5.29289C8.08579 5 8.55719 5 9.5 5C10.4428 5 10.9142 5 11.2071 5.29289C11.5 5.58579 11.5 6.05719 11.5 7V8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M9.5 5V2M9.5 2H7.5M9.5 2H12.9229C13.9117 2 14.7493 2.39009 15.5 3',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M19.4414 8.97336C19.671 9.84608 19.2059 10.7313 18.4026 10.9505C17.5994 11.1697 16.7621 10.64 16.5325 9.76726C16.303 8.89454 17.3634 7 17.3634 7C17.3634 7 19.2118 8.10063 19.4414 8.97336Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBodySoap' icon.
  static const List<List<dynamic>> bodySoap = strokeRoundedBodySoap;

  /// JSON structure for the 'strokeRoundedBodyWeight' icon.
  static const List<List<dynamic>> strokeRoundedBodyWeight = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12.0018 14.0034V12.3621M12.0018 14.0034C10.3356 14.0034 8.66938 13.821 7.0032 13.4565M12.0018 14.0034C13.6684 14.0034 15.3351 13.8212 17.0018 13.4565M7.0032 13.4565C5.72831 13.1776 4.45343 12.7918 3.17854 12.2995C2.66898 12.1026 2.4142 12.0042 2.23938 11.7788C1.94932 11.4049 2.00174 10.8841 2.00174 10.4387C2.00174 9.20572 2.00174 7.58804 2.30254 7.26609C2.872 6.65661 3.95909 7.21761 4.59137 7.42272C9.53162 9.02529 14.4719 9.02529 19.4122 7.42272C20.0444 7.21761 21.1315 6.65661 21.701 7.26609C22.0018 7.58804 22.0018 9.20572 22.0018 10.4387C22.0018 11.0571 22.0018 11.3663 21.8658 11.6217C21.6568 12.0141 21.2154 12.1487 20.825 12.2995C19.5506 12.7916 18.2762 13.1776 17.0018 13.4565M7.0032 13.4565L7.00174 11.8149M17.0018 13.4565V11.8149',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M19.002 19.0096C14.3353 20.3458 9.66862 20.3458 5.00195 19.0096',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M19.191 2.99805C18.6141 4.30938 18.0839 6.55739 18.0839 7.58772M4.81544 2.99805C5.39237 4.30938 5.92253 6.55739 5.92253 7.58772M5.39913 15.5107C4.96029 16.8915 3.80051 19.6218 4.00426 21.0026M18.6142 15.5107C19.0531 16.8915 20.2129 19.6218 20.0091 21.0026',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBodyWeight' icon.
  static const List<List<dynamic>> bodyWeight = strokeRoundedBodyWeight;

  /// JSON structure for the 'strokeRoundedBomb' icon.
  static const List<List<dynamic>> strokeRoundedBomb = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M16 15C16 18.866 12.866 22 9 22C5.13401 22 2 18.866 2 15C2 11.134 5.13401 8 9 8C12.866 8 16 11.134 16 15Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12 8.5L11.4685 7.17126C11.3094 6.77352 11.2299 6.57465 11.1227 6.40981C10.8287 5.95761 10.3645 5.64333 9.83543 5.53829C9.64256 5.5 9.42838 5.5 9 5.5C8.57162 5.5 8.35744 5.5 8.16457 5.53829C7.63553 5.64333 7.17133 5.95761 6.87732 6.40981C6.77014 6.57465 6.69059 6.77352 6.5315 7.17126L6 8.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M22 7.5L20.5 6M20.5 6L19 4.5M20.5 6L19 7.5M20.5 6L22 4.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M17 5.99993C14 5.99993 14.4095 3.43983 11.8598 2.26722C9.61977 1.23706 8.77077 3.40757 9.05199 5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBomb' icon.
  static const List<List<dynamic>> bomb = strokeRoundedBomb;

  /// JSON structure for the 'strokeRoundedBone01' icon.
  static const List<List<dynamic>> strokeRoundedBone01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M17.3997 5.83806C17.8288 5.40901 18.3665 5.15489 18.9243 5.07568M18.9243 5.07568C19.7347 4.96061 20.5874 5.21474 21.2107 5.83806C22.2631 6.89044 22.2631 8.59667 21.2107 9.64905C20.3628 10.497 19.0904 10.6617 18.0775 10.1432C17.6635 9.93132 17.1331 9.91564 16.8043 10.2445L10.2445 16.8043C9.91564 17.1331 9.93132 17.6635 10.1432 18.0775C10.6617 19.0904 10.497 20.3628 9.64904 21.2107C8.59667 22.2631 6.89044 22.2631 5.83806 21.2107C5.21474 20.5874 4.96061 19.7347 5.07568 18.9243M18.9243 5.07568C19.0394 4.26531 18.7853 3.41261 18.1619 2.78928C17.1096 1.73691 15.4033 1.73691 14.351 2.78928C13.503 3.6372 13.3383 4.90961 13.8568 5.92247C14.0687 6.33646 14.0844 6.86686 13.7555 7.19572L7.19572 13.7555C6.86686 14.0844 6.33646 14.0687 5.92247 13.8568C4.90961 13.3383 3.6372 13.503 2.78928 14.351C1.73691 15.4033 1.73691 17.1096 2.78928 18.1619C3.4126 18.7853 4.26532 19.0394 5.07568 18.9243M6.60026 18.1619C6.17121 18.591 5.63348 18.8451 5.07568 18.9243',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBone01' icon.
  static const List<List<dynamic>> bone01 = strokeRoundedBone01;

  /// JSON structure for the 'strokeRoundedBone02' icon.
  static const List<List<dynamic>> strokeRoundedBone02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M8.85977 14.4543C9.24591 14.0681 9.72987 13.8394 10.2319 13.7681M10.2319 13.7681C10.9612 13.6646 11.7287 13.8933 12.2896 14.4543C13.2368 15.4014 13.2368 16.937 12.2896 17.8841C11.537 18.6368 10.4127 18.7913 9.50745 18.3478C9.11069 18.1534 8.6065 18.1374 8.29408 18.4498L4.74391 22M10.2319 13.7681C10.2319 13.768 10.2319 13.7682 10.2319 13.7681ZM10.2319 13.7681C10.3354 13.0388 10.1067 12.2713 9.54574 11.7104C8.59861 10.7632 7.06299 10.7632 6.11586 11.7104C5.3632 12.463 5.20866 13.5873 5.65222 14.4925C5.84662 14.8893 5.86259 15.3935 5.55017 15.7059L2 19.2561',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M15.1402 9.54574C14.7541 9.93189 14.2701 10.1606 13.7681 10.2319M13.7681 10.2319C13.0388 10.3354 12.2713 10.1067 11.7104 9.54574C10.7632 8.59861 10.7632 7.063 11.7104 6.11586C12.463 5.3632 13.5873 5.20866 14.4925 5.65222C14.8893 5.84662 15.3935 5.86259 15.7059 5.55017L19.2561 2M13.7681 10.2319C13.6646 10.9612 13.8933 11.7287 14.4543 12.2896C15.4014 13.2368 16.937 13.2368 17.8841 12.2896C18.6368 11.537 18.7913 10.4127 18.3478 9.50745C18.1534 9.11069 18.1374 8.6065 18.4498 8.29408L22 4.74391',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M16 18V20M18 16H20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M8 6V4M6 8H4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBone02' icon.
  static const List<List<dynamic>> bone02 = strokeRoundedBone02;

  /// JSON structure for the 'strokeRoundedBook01' icon.
  static const List<List<dynamic>> strokeRoundedBook01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M20 22H6C4.89543 22 4 21.1046 4 20M4 20C4 18.8954 4.89543 18 6 18H18C19.1046 18 20 17.1046 20 16V2C20 3.10457 19.1046 4 18 4L10 4C7.17157 4 5.75736 4 4.87868 4.87868C4 5.75736 4 7.17157 4 10V20Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18.5 18C18.5 18 17.5 18.7628 17.5 20C17.5 21.2372 18.5 22 18.5 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M9 4V8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBook01' icon.
  static const List<List<dynamic>> book01 = strokeRoundedBook01;

  /// JSON structure for the 'strokeRoundedBook02' icon.
  static const List<List<dynamic>> strokeRoundedBook02 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M15.5 7H8.5M12.499 11H8.49902',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M20 22H6C4.89543 22 4 21.1046 4 20M4 20C4 18.8954 4.89543 18 6 18H20V6C20 4.11438 20 3.17157 19.4142 2.58579C18.8284 2 17.8856 2 16 2H10C7.17157 2 5.75736 2 4.87868 2.87868C4 3.75736 4 5.17157 4 8V20Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M19.5 18C19.5 18 18.5 18.7628 18.5 20C18.5 21.2372 19.5 22 19.5 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBook02' icon.
  static const List<List<dynamic>> book02 = strokeRoundedBook02;

  /// JSON structure for the 'strokeRoundedBook03' icon.
  static const List<List<dynamic>> strokeRoundedBook03 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M8 2V18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M20 22H6C4.89543 22 4 21.1046 4 20M4 20C4 18.8954 4.89543 18 6 18H20V6C20 4.11438 20 3.17157 19.4142 2.58579C18.8284 2 17.8856 2 16 2H10C7.17157 2 5.75736 2 4.87868 2.87868C4 3.75736 4 5.17157 4 8V20Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M19.5 18C19.5 18 18.5 18.7628 18.5 20C18.5 21.2372 19.5 22 19.5 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBook03' icon.
  static const List<List<dynamic>> book03 = strokeRoundedBook03;

  /// JSON structure for the 'strokeRoundedBook04' icon.
  static const List<List<dynamic>> strokeRoundedBook04 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M19.543 2H6.5C5.11929 2 4 3.11929 4 4.5C4 4.5454 4.00121 4.59053 4.0036 4.63533M6.5 4.5H16C16.9428 4.5 17.4142 4.5 17.7071 4.79289C18 5.08579 18 5.55719 18 6.5M4.0036 4.63533C4.0739 5.95312 5.16469 7 6.5 7H16C17.8856 7 18.8284 7 19.4142 7.58579C20 8.17157 20 9.11438 20 11L20 18C20 19.8856 20 20.8284 19.4142 21.4142C18.8284 22 17.8856 22 16 22H10.0036C7.17517 22 5.76096 22 4.88228 21.1213C4.0036 20.2426 4.0036 18.8284 4.0036 16V4.63533ZM4.0036 4.63533V4.50127',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M15.5 12.5H8.5M12.5 16.5H8.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBook04' icon.
  static const List<List<dynamic>> book04 = strokeRoundedBook04;

  /// JSON structure for the 'strokeRoundedBookBookmark01' icon.
  static const List<List<dynamic>> strokeRoundedBookBookmark01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M20 22H6C4.89543 22 4 21.1046 4 20M4 20C4 18.8954 4.89543 18 6 18H18C19.1046 18 20 17.1046 20 16V2C20 3.10457 19.1046 4 18 4L10 4C7.17157 4 5.75736 4 4.87868 4.87868C4 5.75736 4 7.17157 4 10V20Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M9 4V12L12 9L15 12V4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M18.5 18C18.5 18 17.5 18.7628 17.5 20C17.5 21.2372 18.5 22 18.5 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBookBookmark01' icon.
  static const List<List<dynamic>> bookBookmark01 = strokeRoundedBookBookmark01;

  /// JSON structure for the 'strokeRoundedBookBookmark02' icon.
  static const List<List<dynamic>> strokeRoundedBookBookmark02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M20 22H6C4.89543 22 4 21.1046 4 20M4 20C4 18.8954 4.89543 18 6 18H20V6C20 4.11438 20 3.17157 19.4142 2.58579C18.8284 2 17.8856 2 16 2H10C7.17157 2 5.75736 2 4.87868 2.87868C4 3.75736 4 5.17157 4 8V20Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M19.5 18C19.5 18 18.5 18.7628 18.5 20C18.5 21.2372 19.5 22 19.5 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M9 2V10L12 7L15 10V2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBookBookmark02' icon.
  static const List<List<dynamic>> bookBookmark02 = strokeRoundedBookBookmark02;

  /// JSON structure for the 'strokeRoundedBookDownload' icon.
  static const List<List<dynamic>> strokeRoundedBookDownload = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M20 22H6C4.89543 22 4 21.1046 4 20M4 20C4 18.8954 4.89543 18 6 18H20V6C20 4.11438 20 3.17157 19.4142 2.58579C18.8284 2 17.8856 2 16 2H10C7.17157 2 5.75736 2 4.87868 2.87868C4 3.75736 4 5.17157 4 8V20Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M19.5 18C19.5 18 18.5 18.7628 18.5 20C18.5 21.2372 19.5 22 19.5 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M9 10C9 10 11.2095 13 12 13C12.7906 13 15 10 15 10M12 12.5V7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBookDownload' icon.
  static const List<List<dynamic>> bookDownload = strokeRoundedBookDownload;

  /// JSON structure for the 'strokeRoundedBookEdit' icon.
  static const List<List<dynamic>> strokeRoundedBookEdit = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5.33333 3.00001C7.79379 2.99657 10.1685 3.88709 12 5.5V21C10.1685 19.3871 7.79379 18.4966 5.33333 18.5C3.77132 18.5 2.99032 18.5 2.64526 18.2792C2.4381 18.1466 2.35346 18.0619 2.22086 17.8547C2 17.5097 2 16.8941 2 15.6629V6.40322C2 4.97543 2 4.26154 2.54874 3.68286C3.09748 3.10418 3.65923 3.07432 4.78272 3.0146C4.965 3.00491 5.14858 3.00001 5.33333 3.00001Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12 21V5.5C13.8315 3.88709 16.2062 2.99657 18.6667 3.00001C18.8514 3.00001 19.035 3.00491 19.2173 3.0146C20.3408 3.07432 20.9025 3.10418 21.4513 3.68286C22 4.26154 22 4.97543 22 6.40322V11.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M21.6887 14.9339L21.0661 14.3113C20.651 13.8962 19.978 13.8962 19.5629 14.3113L16.2141 17.6601C15.769 18.1052 15.4656 18.6722 15.3421 19.2895L15 21L16.7105 20.6579C17.3278 20.5344 17.8948 20.231 18.3399 19.7859L21.6887 16.4371C22.1038 16.022 22.1038 15.349 21.6887 14.9339Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBookEdit' icon.
  static const List<List<dynamic>> bookEdit = strokeRoundedBookEdit;

  /// JSON structure for the 'strokeRoundedBookOpen01' icon.
  static const List<List<dynamic>> strokeRoundedBookOpen01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5.33333 3.00001C7.79379 2.99657 10.1685 3.88709 12 5.5V21C10.1685 19.3871 7.79379 18.4966 5.33333 18.5C3.77132 18.5 2.99032 18.5 2.64526 18.2792C2.4381 18.1466 2.35346 18.0619 2.22086 17.8547C2 17.5097 2 16.8941 2 15.6629V6.40322C2 4.97543 2 4.26154 2.54874 3.68286C3.09748 3.10418 3.65923 3.07432 4.78272 3.0146C4.965 3.00491 5.14858 3.00001 5.33333 3.00001Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18.6667 3.00001C16.2062 2.99657 13.8315 3.88709 12 5.5V21C13.8315 19.3871 16.2062 18.4966 18.6667 18.5C20.2287 18.5 21.0097 18.5 21.3547 18.2792C21.5619 18.1466 21.6465 18.0619 21.7791 17.8547C22 17.5097 22 16.8941 22 15.6629V6.40322C22 4.97543 22 4.26154 21.4513 3.68286C20.9025 3.10418 20.3408 3.07432 19.2173 3.0146C19.035 3.00491 18.8514 3.00001 18.6667 3.00001Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBookOpen01' icon.
  static const List<List<dynamic>> bookOpen01 = strokeRoundedBookOpen01;

  /// JSON structure for the 'strokeRoundedBookOpen02' icon.
  static const List<List<dynamic>> strokeRoundedBookOpen02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M17.5055 2.01874C12.8289 2.83455 12 7.5 12 7.5V22C12 22 12.8867 17.1272 18.0004 16.5588C18.5493 16.4978 19 16.0576 19 15.5058V3.39309C19 2.5654 18.3216 1.87638 17.5055 2.01874Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M5.33333 5.00001C7.79379 4.99657 10.1685 5.88709 12 7.5V22C10.1685 20.3871 7.79379 19.4966 5.33333 19.5C3.77132 19.5 2.99032 19.5 2.64526 19.2792C2.4381 19.1466 2.35346 19.0619 2.22086 18.8547C2 18.5097 2 17.8941 2 16.6629V8.40322C2 6.97543 2 6.26154 2.54874 5.68286C3.09748 5.10418 3.65923 5.07432 4.78272 5.0146C4.965 5.00491 5.14858 5.00001 5.33333 5.00001Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M12 22.001C13.8315 20.3881 16.2062 19.4976 18.6667 19.501C20.2287 19.501 21.0097 19.501 21.3547 19.2802C21.5619 19.1476 21.6465 19.0629 21.7791 18.8558C22 18.5107 22 17.8951 22 16.6639V8.40424C22 6.97645 22 6.26256 21.4513 5.68388C20.9025 5.1052 20.1235 5.05972 19 5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBookOpen02' icon.
  static const List<List<dynamic>> bookOpen02 = strokeRoundedBookOpen02;

  /// JSON structure for the 'strokeRoundedBookUpload' icon.
  static const List<List<dynamic>> strokeRoundedBookUpload = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M20 22H6C4.89543 22 4 21.1046 4 20M4 20C4 18.8954 4.89543 18 6 18H20V6C20 4.11438 20 3.17157 19.4142 2.58579C18.8284 2 17.8856 2 16 2H10C7.17157 2 5.75736 2 4.87868 2.87868C4 3.75736 4 5.17157 4 8V20Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M19.5 18C19.5 18 18.5 18.7628 18.5 20C18.5 21.2372 19.5 22 19.5 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M9 9.99998C9 9.99998 11.2095 7.00001 12 7C12.7906 6.99999 15 10 15 10M12 7.5V13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBookUpload' icon.
  static const List<List<dynamic>> bookUpload = strokeRoundedBookUpload;

  /// JSON structure for the 'strokeRoundedBookmark01' icon.
  static const List<List<dynamic>> strokeRoundedBookmark01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4 17.9808V9.70753C4 6.07416 4 4.25748 5.17157 3.12874C6.34315 2 8.22876 2 12 2C15.7712 2 17.6569 2 18.8284 3.12874C20 4.25748 20 6.07416 20 9.70753V17.9808C20 20.2867 20 21.4396 19.2272 21.8523C17.7305 22.6514 14.9232 19.9852 13.59 19.1824C12.8168 18.7168 12.4302 18.484 12 18.484C11.5698 18.484 11.1832 18.7168 10.41 19.1824C9.0768 19.9852 6.26947 22.6514 4.77285 21.8523C4 21.4396 4 20.2867 4 17.9808Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M4 7H20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBookmark01' icon.
  static const List<List<dynamic>> bookmark01 = strokeRoundedBookmark01;

  /// JSON structure for the 'strokeRoundedBookmark02' icon.
  static const List<List<dynamic>> strokeRoundedBookmark02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4 17.9808V9.70753C4 6.07416 4 4.25748 5.17157 3.12874C6.34315 2 8.22876 2 12 2C15.7712 2 17.6569 2 18.8284 3.12874C20 4.25748 20 6.07416 20 9.70753V17.9808C20 20.2867 20 21.4396 19.2272 21.8523C17.7305 22.6514 14.9232 19.9852 13.59 19.1824C12.8168 18.7168 12.4302 18.484 12 18.484C11.5698 18.484 11.1832 18.7168 10.41 19.1824C9.0768 19.9852 6.26947 22.6514 4.77285 21.8523C4 21.4396 4 20.2867 4 17.9808Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBookmark02' icon.
  static const List<List<dynamic>> bookmark02 = strokeRoundedBookmark02;

  /// JSON structure for the 'strokeRoundedBookmark03' icon.
  static const List<List<dynamic>> strokeRoundedBookmark03 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12 22.0002C7.75736 22.0002 5.63604 22.0002 4.31802 20.5358C3 19.0713 3 16.7143 3 12.0002C3 7.28617 3 4.92915 4.31802 3.46468C5.63604 2.00022 7.75736 2.00022 12 2.00022C16.2426 2.00022 18.364 2.00022 19.682 3.46468C21 4.92915 21 7.28617 21 12.0002C21 16.7143 21 19.0713 19.682 20.5358C18.364 22.0002 16.2426 22.0002 12 22.0002Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M8 2.5V9.82621C8 11.0733 8 11.6969 8.38642 11.9201C9.13473 12.3523 10.5384 10.9103 11.205 10.4761C11.5916 10.2243 11.7849 10.0984 12 10.0984C12.2151 10.0984 12.4084 10.2243 12.795 10.4761C13.4616 10.9103 14.8653 12.3523 15.6136 11.9201C16 11.6969 16 11.0733 16 9.82621V2.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBookmark03' icon.
  static const List<List<dynamic>> bookmark03 = strokeRoundedBookmark03;

  /// JSON structure for the 'strokeRoundedBookmarkAdd01' icon.
  static const List<List<dynamic>> strokeRoundedBookmarkAdd01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M11 2C7.22876 2 5.34315 2 4.17157 3.12874C3 4.25748 3 6.07416 3 9.70753V17.9808C3 20.2867 3 21.4396 3.77285 21.8523C5.26947 22.6514 8.0768 19.9852 9.41 19.1824C10.1832 18.7168 10.5698 18.484 11 18.484C11.4302 18.484 11.8168 18.7168 12.59 19.1824C13.9232 19.9852 16.7305 22.6514 18.2272 21.8523C19 21.4396 19 20.2867 19 17.9808V12.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M3.5 7.00005H10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M17 10L17 2M13 6H21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBookmarkAdd01' icon.
  static const List<List<dynamic>> bookmarkAdd01 = strokeRoundedBookmarkAdd01;

  /// JSON structure for the 'strokeRoundedBookmarkAdd02' icon.
  static const List<List<dynamic>> strokeRoundedBookmarkAdd02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M11 2C7.22876 2 5.34315 2 4.17157 3.12874C3 4.25748 3 6.07416 3 9.70753V17.9808C3 20.2867 3 21.4396 3.77285 21.8523C5.26947 22.6514 8.0768 19.9852 9.41 19.1824C10.1832 18.7168 10.5698 18.484 11 18.484C11.4302 18.484 11.8168 18.7168 12.59 19.1824C13.9232 19.9852 16.7305 22.6514 18.2272 21.8523C19 21.4396 19 20.2867 19 17.9808V13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M17 10L17 2M13 6H21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBookmarkAdd02' icon.
  static const List<List<dynamic>> bookmarkAdd02 = strokeRoundedBookmarkAdd02;

  /// JSON structure for the 'strokeRoundedBookmarkBlock01' icon.
  static const List<List<dynamic>> strokeRoundedBookmarkBlock01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M14.1667 7.83333L18.8333 3.16667M20 5.5C20 7.433 18.433 9 16.5 9C14.567 9 13 7.433 13 5.5C13 3.567 14.567 2 16.5 2C18.433 2 20 3.567 20 5.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M19 11.5V17.9808C19 20.2867 19 21.4396 18.2272 21.8523C16.7305 22.6514 13.9232 19.9852 12.59 19.1824C11.8168 18.7168 11.4302 18.484 11 18.484C10.5698 18.484 10.1832 18.7168 9.41 19.1824C8.0768 19.9852 5.26947 22.6514 3.77285 21.8523C3 21.4396 3 20.2867 3 17.9808V9.70753C3 6.07416 3 4.25748 4.17157 3.12874C5.29018 2.05103 7.05974 2.00231 10.5 2.0001',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M3.5 7H10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBookmarkBlock01' icon.
  static const List<List<dynamic>> bookmarkBlock01 =
      strokeRoundedBookmarkBlock01;

  /// JSON structure for the 'strokeRoundedBookmarkBlock02' icon.
  static const List<List<dynamic>> strokeRoundedBookmarkBlock02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M19 12.5V17.9808C19 20.2867 19 21.4396 18.2272 21.8523C16.7305 22.6515 13.9232 19.9852 12.59 19.1824C11.8168 18.7168 11.4302 18.484 11 18.484C10.5698 18.484 10.1832 18.7168 9.41 19.1824C8.0768 19.9852 5.26947 22.6515 3.77285 21.8523C3 21.4396 3 20.2867 3 17.9808V9.70753C3 6.07417 3 4.25749 4.17157 3.12875C5.23467 2.10452 6.8857 2.00968 10 2.0009',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M13.2 3.2L18.8 8.8M20 6C20 3.79086 18.2091 2 16 2C13.7909 2 12 3.79086 12 6C12 8.20914 13.7909 10 16 10C18.2091 10 20 8.20914 20 6Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBookmarkBlock02' icon.
  static const List<List<dynamic>> bookmarkBlock02 =
      strokeRoundedBookmarkBlock02;

  /// JSON structure for the 'strokeRoundedBookmarkCheck01' icon.
  static const List<List<dynamic>> strokeRoundedBookmarkCheck01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4 17.9808V9.70753C4 6.07416 4 4.25748 5.17157 3.12874C6.34315 2 8.22876 2 12 2C15.7712 2 17.6569 2 18.8284 3.12874C20 4.25748 20 6.07416 20 9.70753V17.9808C20 20.2867 20 21.4396 19.2272 21.8523C17.7305 22.6514 14.9232 19.9852 13.59 19.1824C12.8168 18.7168 12.4302 18.484 12 18.484C11.5698 18.484 11.1832 18.7168 10.41 19.1824C9.0768 19.9852 6.26947 22.6514 4.77285 21.8523C4 21.4396 4 20.2867 4 17.9808Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M10 13.7143C10 13.7143 11 14.2357 11.5 15C11.5 15 13 12 15 11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M4 7H20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBookmarkCheck01' icon.
  static const List<List<dynamic>> bookmarkCheck01 =
      strokeRoundedBookmarkCheck01;

  /// JSON structure for the 'strokeRoundedBookmarkCheck02' icon.
  static const List<List<dynamic>> strokeRoundedBookmarkCheck02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4 17.9808V9.70753C4 6.07416 4 4.25748 5.17157 3.12874C6.34315 2 8.22876 2 12 2C15.7712 2 17.6569 2 18.8284 3.12874C20 4.25748 20 6.07416 20 9.70753V17.9808C20 20.2867 20 21.4396 19.2272 21.8523C17.7305 22.6514 14.9232 19.9852 13.59 19.1824C12.8168 18.7168 12.4302 18.484 12 18.484C11.5698 18.484 11.1832 18.7168 10.41 19.1824C9.0768 19.9852 6.26947 22.6514 4.77285 21.8523C4 21.4396 4 20.2867 4 17.9808Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M9 11.3333C9 11.3333 9.875 11.3333 10.75 13C10.75 13 13.5294 8.83333 16 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBookmarkCheck02' icon.
  static const List<List<dynamic>> bookmarkCheck02 =
      strokeRoundedBookmarkCheck02;

  /// JSON structure for the 'strokeRoundedBookmarkMinus01' icon.
  static const List<List<dynamic>> strokeRoundedBookmarkMinus01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M11 2C7.22876 2 5.34315 2 4.17157 3.12874C3 4.25748 3 6.07416 3 9.70753V17.9808C3 20.2867 3 21.4396 3.77285 21.8523C5.26947 22.6514 8.0768 19.9852 9.41 19.1824C10.1832 18.7168 10.5698 18.484 11 18.484C11.4302 18.484 11.8168 18.7168 12.59 19.1824C13.9232 19.9852 16.7305 22.6514 18.2272 21.8523C19 21.4396 19 20.2867 19 17.9808V12.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M3.5 7H10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M13 5H21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBookmarkMinus01' icon.
  static const List<List<dynamic>> bookmarkMinus01 =
      strokeRoundedBookmarkMinus01;

  /// JSON structure for the 'strokeRoundedBookmarkMinus02' icon.
  static const List<List<dynamic>> strokeRoundedBookmarkMinus02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M11 2C7.22876 2 5.34315 2 4.17157 3.12874C3 4.25748 3 6.07416 3 9.70753V17.9808C3 20.2867 3 21.4396 3.77285 21.8523C5.26947 22.6514 8.0768 19.9852 9.41 19.1824C10.1832 18.7168 10.5698 18.484 11 18.484C11.4302 18.484 11.8168 18.7168 12.59 19.1824C13.9232 19.9852 16.7305 22.6514 18.2272 21.8523C19 21.4396 19 20.2867 19 17.9808V11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M13 6L21 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBookmarkMinus02' icon.
  static const List<List<dynamic>> bookmarkMinus02 =
      strokeRoundedBookmarkMinus02;

  /// JSON structure for the 'strokeRoundedBookmarkOff01' icon.
  static const List<List<dynamic>> strokeRoundedBookmarkOff01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M20 19.9429C19.9381 20.9761 19.7617 21.5725 19.259 21.8481C17.7592 22.6701 14.946 19.9276 13.61 19.1019C12.8352 18.623 12.4478 18.3836 12.0167 18.3836C11.5856 18.3836 11.1982 18.623 10.4234 19.1019C9.08741 19.9276 6.27421 22.6701 4.77446 21.8481C4 21.4236 4 20.2377 4 17.866V9.35632C4 7.18055 4 5.63815 4.23168 4.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M20 16V9.70753C20 6.07416 20 4.25748 18.8284 3.12874C17.6569 2 15.7712 2 12 2C9.39647 2 7.69163 2 6.5 2.37139',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M11 7L19.5 7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M2 2L22 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBookmarkOff01' icon.
  static const List<List<dynamic>> bookmarkOff01 = strokeRoundedBookmarkOff01;

  /// JSON structure for the 'strokeRoundedBookmarkOff02' icon.
  static const List<List<dynamic>> strokeRoundedBookmarkOff02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M20 19.9429C19.9381 20.9761 19.7617 21.5725 19.259 21.8481C17.7592 22.6701 14.946 19.9276 13.61 19.1019C12.8352 18.623 12.4478 18.3836 12.0167 18.3836C11.5856 18.3836 11.1982 18.623 10.4234 19.1019C9.08741 19.9276 6.27421 22.6701 4.77446 21.8481C4 21.4236 4 20.2377 4 17.866V9.35632C4 7.18055 4 5.63815 4.23168 4.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M20 16V9.70753C20 6.07416 20 4.25748 18.8284 3.12874C17.6569 2 15.7712 2 12 2C9.39647 2 7.69163 2 6.5 2.37139',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M2 2L22 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBookmarkOff02' icon.
  static const List<List<dynamic>> bookmarkOff02 = strokeRoundedBookmarkOff02;

  /// JSON structure for the 'strokeRoundedBookmarkRemove01' icon.
  static const List<List<dynamic>> strokeRoundedBookmarkRemove01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M11 2C7.22876 2 5.34315 2 4.17157 3.12874C3 4.25748 3 6.07416 3 9.70753V17.9808C3 20.2867 3 21.4396 3.77285 21.8523C5.26947 22.6514 8.0768 19.9852 9.41 19.1824C10.1832 18.7168 10.5698 18.484 11 18.484C11.4302 18.484 11.8168 18.7168 12.59 19.1824C13.9232 19.9852 16.7305 22.6514 18.2272 21.8523C19 21.4396 19 20.2867 19 17.9808V11.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M3.5 7H11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M21 2L14 8.99954M21 9L14 2.00046',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBookmarkRemove01' icon.
  static const List<List<dynamic>> bookmarkRemove01 =
      strokeRoundedBookmarkRemove01;

  /// JSON structure for the 'strokeRoundedBookmarkRemove02' icon.
  static const List<List<dynamic>> strokeRoundedBookmarkRemove02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M11 2C7.22876 2 5.34315 2 4.17157 3.12874C3 4.25748 3 6.07416 3 9.70753V17.9808C3 20.2867 3 21.4396 3.77285 21.8523C5.26947 22.6514 8.0768 19.9852 9.41 19.1824C10.1832 18.7168 10.5698 18.484 11 18.484C11.4302 18.484 11.8168 18.7168 12.59 19.1824C13.9232 19.9852 16.7305 22.6514 18.2272 21.8523C19 21.4396 19 20.2867 19 17.9808V12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M21 2L14 8.99954M21 9L14 2.00046',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBookmarkRemove02' icon.
  static const List<List<dynamic>> bookmarkRemove02 =
      strokeRoundedBookmarkRemove02;

  /// JSON structure for the 'strokeRoundedBooks01' icon.
  static const List<List<dynamic>> strokeRoundedBooks01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2 15H15C15.9319 15 16.3978 15 16.7654 15.1522C17.2554 15.3552 17.6448 15.7446 17.8478 16.2346C18 16.6022 18 17.0681 18 18C18 18.9319 18 19.3978 17.8478 19.7654C17.6448 20.2554 17.2554 20.6448 16.7654 20.8478C16.3978 21 15.9319 21 15 21H2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M2 3H15C15.9319 3 16.3978 3 16.7654 3.15224C17.2554 3.35523 17.6448 3.74458 17.8478 4.23463C18 4.60218 18 5.06812 18 6C18 6.93188 18 7.39782 17.8478 7.76537C17.6448 8.25542 17.2554 8.64477 16.7654 8.84776C16.3978 9 15.9319 9 15 9H2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M22 9H9C8.06812 9 7.60218 9 7.23463 9.15224C6.74458 9.35523 6.35523 9.74458 6.15224 10.2346C6 10.6022 6 11.0681 6 12C6 12.9319 6 13.3978 6.15224 13.7654C6.35523 14.2554 6.74458 14.6448 7.23463 14.8478C7.60218 15 8.06812 15 9 15H22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M21 15C19.8954 15 19 13.6569 19 12C19 10.3431 19.8954 9 21 9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M3 3C4.10457 3 5 4.34315 5 6C5 7.65685 4.10457 9 3 9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M3 15C4.10457 15 5 16.3431 5 18C5 19.6569 4.10457 21 3 21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBooks01' icon.
  static const List<List<dynamic>> books01 = strokeRoundedBooks01;

  /// JSON structure for the 'strokeRoundedBooks02' icon.
  static const List<List<dynamic>> strokeRoundedBooks02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3 9H18C18.9319 9 19.3978 9 19.7654 9.15224C20.2554 9.35523 20.6448 9.74458 20.8478 10.2346C21 10.6022 21 11.0681 21 12C21 12.9319 21 13.3978 20.8478 13.7654C20.6448 14.2554 20.2554 14.6448 19.7654 14.8478C19.3978 15 18.9319 15 18 15H13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M6 15H3',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M13 15H15C15.9319 15 16.3978 15 16.7654 15.1522C17.2554 15.3552 17.6448 15.7446 17.8478 16.2346C18 16.6022 18 17.0681 18 18C18 18.9319 18 19.3978 17.8478 19.7654C17.6448 20.2554 17.2554 20.6448 16.7654 20.8478C16.3978 21 15.9319 21 15 21H3',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M3 3H14C14.9319 3 15.3978 3 15.7654 3.15224C16.2554 3.35523 16.6448 3.74458 16.8478 4.23463C17 4.60218 17 5.06812 17 6C17 6.93188 17 7.39782 16.8478 7.76537C16.6448 8.25542 16.2554 8.64477 15.7654 8.84776C15.3978 9 14.9319 9 14 9H3',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M13 9L13 15.1905C13 16.3045 13 16.8616 12.6735 16.9803C12.3469 17.0991 11.9782 16.6761 11.2407 15.8303L10.7593 15.278C10.4064 14.8733 10.23 14.6709 10 14.6709C9.77003 14.6709 9.5936 14.8733 9.24074 15.278L8.75926 15.8303C8.02179 16.6761 7.65305 17.0991 7.32653 16.9803C7 16.8616 7 16.3045 7 15.1905L7 9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBooks02' icon.
  static const List<List<dynamic>> books02 = strokeRoundedBooks02;

  /// JSON structure for the 'strokeRoundedBookshelf01' icon.
  static const List<List<dynamic>> strokeRoundedBookshelf01 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M5.5 20V22M19.5 20V22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M3 11L21 11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M3 14V8C3 5.17157 3 3.75736 3.93037 2.87868C4.86073 2 6.35814 2 9.35294 2H14.6471C17.6419 2 19.1393 2 20.0696 2.87868C21 3.75736 21 5.17157 21 8V14C21 16.8284 21 18.2426 20.0696 19.1213C19.1393 20 17.6419 20 14.6471 20H9.35294C6.35814 20 4.86073 20 3.93037 19.1213C3 18.2426 3 16.8284 3 14Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M13.5 11L11.5 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M7 11V6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M8 19.5V15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd': 'M12 20V15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '7',
        'd': 'M17 11V6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '8',
        'd': 'M16 20L17 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBookshelf01' icon.
  static const List<List<dynamic>> bookshelf01 = strokeRoundedBookshelf01;

  /// JSON structure for the 'strokeRoundedBookshelf02' icon.
  static const List<List<dynamic>> strokeRoundedBookshelf02 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M3 11H21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M3 14V8C3 5.17157 3 3.75736 3.93037 2.87868C4.86073 2 6.35814 2 9.35294 2H14.6471C17.6419 2 19.1393 2 20.0696 2.87868C21 3.75736 21 5.17157 21 8V14C21 16.8284 21 18.2426 20.0696 19.1213C19.1393 20 17.6419 20 14.6471 20H9.35294C6.35814 20 4.86073 20 3.93037 19.1213C3 18.2426 3 16.8284 3 14Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M11.5 11L9.5 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M18 11L17 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M7 11V6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M14 11V6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd': 'M11 16L13 16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '7',
        'd': 'M5 20V22M19 20V22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBookshelf02' icon.
  static const List<List<dynamic>> bookshelf02 = strokeRoundedBookshelf02;

  /// JSON structure for the 'strokeRoundedBookshelf03' icon.
  static const List<List<dynamic>> strokeRoundedBookshelf03 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M3 16H21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M2 22L22 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M3 9H21',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M3 22V8C3 5.17157 3 3.75736 3.93037 2.87868C4.86073 2 6.35814 2 9.35294 2H14.6471C17.6419 2 19.1393 2 20.0696 2.87868C21 3.75736 21 5.17157 21 8V22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M11 19H13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M10 9L9 5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd': 'M6.5 9V5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '7',
        'd': 'M14 16V12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '8',
        'd': 'M12 9V5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '9',
        'd': 'M16 16L17 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '10',
        'd': 'M19 16V12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBookshelf03' icon.
  static const List<List<dynamic>> bookshelf03 = strokeRoundedBookshelf03;

  /// JSON structure for the 'strokeRoundedBootstrap' icon.
  static const List<List<dynamic>> strokeRoundedBootstrap = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12.8824 12C14.0519 12 15 12.8954 15 14C15 15.1046 14.0519 16 12.8824 16H10.6C9.84575 16 9.46863 16 9.23431 15.7657C9 15.5314 9 15.1542 9 14.4V12M12.8824 12C14.0519 12 15 11.1046 15 10C15 8.89543 14.0519 8 12.8824 8H10.6C9.84575 8 9.46863 8 9.23431 8.23431C9 8.46863 9 8.84575 9 9.6V12M12.8824 12H9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M22 12C20.8954 12 20 11.1046 20 10V8C20 4.69067 19.3093 4 16 4H8C4.69067 4 4 4.69067 4 8V10C4 11.1046 3.10457 12 2 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M2 12C3.10457 12 4 12.8954 4 14L4 16C4 19.3093 4.69067 20 8 20H16C19.3093 20 20 19.3093 20 16V14C20 12.8954 20.8954 12 22 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBootstrap' icon.
  static const List<List<dynamic>> bootstrap = strokeRoundedBootstrap;

  /// JSON structure for the 'strokeRoundedBorderAll01' icon.
  static const List<List<dynamic>> strokeRoundedBorderAll01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12 2.5V4.4M12 19.6V21.5M9.15 12H14.85M19.6 12H21.5M2.5 12H4.4M12 9.14999V14.85',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBorderAll01' icon.
  static const List<List<dynamic>> borderAll01 = strokeRoundedBorderAll01;

  /// JSON structure for the 'strokeRoundedBorderAll02' icon.
  static const List<List<dynamic>> strokeRoundedBorderAll02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBorderAll02' icon.
  static const List<List<dynamic>> borderAll02 = strokeRoundedBorderAll02;

  /// JSON structure for the 'strokeRoundedBorderBottom01' icon.
  static const List<List<dynamic>> strokeRoundedBorderBottom01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 17.5C2.69854 18.594 3.04969 19.3991 3.6708 20.0356C5.09987 21.5 7.39991 21.5 12 21.5C16.6001 21.5 18.9001 21.5 20.3292 20.0356C20.9503 19.3991 21.3015 18.594 21.5 17.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M2.75143 6.31038C2.94471 5.26831 3.28657 4.50138 3.89124 3.89506C4.49591 3.28875 5.26076 2.94595 6.3 2.75214M2.50496 14C2.5 13.414 2.5 12.7117 2.5 12.0259C2.5 11.3401 2.5 10.5751 2.50496 9.98913M10.1 2.505C10.6844 2.50003 11.3161 2.50003 12 2.50003C12.6839 2.50003 13.3156 2.50003 13.9001 2.505M17.7 2.75214C18.7392 2.94595 19.5041 3.28874 20.1088 3.89506C20.7134 4.50138 21.0553 5.26831 21.2486 6.31038M21.495 14C21.5 13.414 21.5 12.7117 21.5 12.0259C21.5 11.3402 21.5 10.5751 21.495 9.98913',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M2.5 12L4 12M20 12L21.5 12M12 15L12 9.00003M12 4.46878L12 3.00003M9 12L15 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBorderBottom01' icon.
  static const List<List<dynamic>> borderBottom01 = strokeRoundedBorderBottom01;

  /// JSON structure for the 'strokeRoundedBorderBottom02' icon.
  static const List<List<dynamic>> strokeRoundedBorderBottom02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M21.2486 6.33333C21.0553 5.28498 20.7134 4.51342 20.1088 3.90345C19.5041 3.29347 18.7392 2.94861 17.7 2.75363M21.495 14C21.5 13.4105 21.5 12.7732 21.5 12.0833C21.5 11.3934 21.5 10.7562 21.495 10.1666M13.9 2.505C13.3156 2.5 12.6839 2.5 12 2.5C11.3161 2.5 10.6844 2.5 10.0999 2.505M6.3 2.75363C5.26076 2.94861 4.49591 3.29347 3.89124 3.90345C3.28657 4.51342 2.94471 5.28497 2.75143 6.33333M2.50495 14C2.5 13.4107 2.5 12.7729 2.5 12.0833C2.5 11.3935 2.5 10.7563 2.50495 10.1668',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M21.5 17.5C21.3015 18.5939 20.9503 19.399 20.3292 20.0355C18.9001 21.5 16.6001 21.5 12 21.5C7.39991 21.5 5.09987 21.5 3.6708 20.0355C3.04969 19.399 2.69854 18.5939 2.5 17.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBorderBottom02' icon.
  static const List<List<dynamic>> borderBottom02 = strokeRoundedBorderBottom02;

  /// JSON structure for the 'strokeRoundedBorderFull' icon.
  static const List<List<dynamic>> strokeRoundedBorderFull = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3 11C3 7.25027 3 5.3754 3.95491 4.06107C4.26331 3.6366 4.6366 3.26331 5.06107 2.95491C6.3754 2 8.25027 2 12 2C15.7497 2 17.6246 2 18.9389 2.95491C19.3634 3.26331 19.7367 3.6366 20.0451 4.06107C21 5.3754 21 7.25027 21 11V13C21 16.7497 21 18.6246 20.0451 19.9389C19.7367 20.3634 19.3634 20.7367 18.9389 21.0451C17.6246 22 15.7497 22 12 22C8.25027 22 6.3754 22 5.06107 21.0451C4.6366 20.7367 4.26331 20.3634 3.95491 19.9389C3 18.6246 3 16.7497 3 13V11Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M15 9.5L7 9.5M10 14.5H7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBorderFull' icon.
  static const List<List<dynamic>> borderFull = strokeRoundedBorderFull;

  /// JSON structure for the 'strokeRoundedBorderHorizontal' icon.
  static const List<List<dynamic>> strokeRoundedBorderHorizontal = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6.3 2.75143C5.26076 2.94471 4.49591 3.28657 3.89124 3.89124C3.28657 4.49591 2.94471 5.26076 2.75143 6.3M17.7 2.75143C18.7392 2.94471 19.5041 3.28657 20.1088 3.89124C20.7134 4.49591 21.0553 5.26076 21.2486 6.3M13.9 2.50495C13.3156 2.5 12.6839 2.5 12 2.5C11.3161 2.5 10.6844 2.5 10.1 2.50495M21.495 10.1C21.5 10.6844 21.5 11.3161 21.5 12C21.5 12.6839 21.5 13.3156 21.495 13.9001M2.50495 10.1C2.5 10.6844 2.5 11.3161 2.5 12C2.5 12.6839 2.5 13.3156 2.50496 13.9001M2.75143 17.7C2.94471 18.7392 3.28657 19.5041 3.89124 20.1088C4.49591 20.7134 5.26076 21.0553 6.3 21.2486M21.2486 17.7C21.0553 18.7392 20.7134 19.5041 20.1088 20.1088C19.5041 20.7134 18.7392 21.0553 17.7 21.2486M13.9 21.495C13.3156 21.5 12.6839 21.5 12 21.5C11.3162 21.5 10.6845 21.5 10.1002 21.495',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M2.5 12H21.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 2.5L12 4.4M12 19.6L12 21.5M12 9.15L12 14.85',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBorderHorizontal' icon.
  static const List<List<dynamic>> borderHorizontal =
      strokeRoundedBorderHorizontal;

  /// JSON structure for the 'strokeRoundedBorderInner' icon.
  static const List<List<dynamic>> strokeRoundedBorderInner = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6.3 2.75143C5.26076 2.94471 4.49591 3.28657 3.89124 3.89124C3.28657 4.49591 2.94471 5.26076 2.75143 6.3M17.7 2.75143C18.7392 2.94471 19.5041 3.28657 20.1088 3.89124C20.7134 4.49591 21.0553 5.26076 21.2486 6.3M13.9 2.50495C13.3156 2.5 12.6839 2.5 12 2.5C11.3161 2.5 10.6844 2.5 10.1 2.50495M21.495 10.1C21.5 10.6844 21.5 11.3161 21.5 12C21.5 12.6839 21.5 13.3156 21.495 13.9001M2.50495 10.1C2.5 10.6844 2.5 11.3161 2.5 12C2.5 12.6839 2.5 13.3156 2.50496 13.9001M2.75143 17.7C2.94471 18.7392 3.28657 19.5041 3.89124 20.1088C4.49591 20.7134 5.26076 21.0553 6.3 21.2486M21.2486 17.7C21.0553 18.7392 20.7134 19.5041 20.1088 20.1088C19.5041 20.7134 18.7392 21.0553 17.7 21.2486M13.9 21.495C13.3156 21.5 12.6839 21.5 12 21.5C11.3162 21.5 10.6845 21.5 10.1002 21.495',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M2.5 12H21.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 2.5L12 21.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBorderInner' icon.
  static const List<List<dynamic>> borderInner = strokeRoundedBorderInner;

  /// JSON structure for the 'strokeRoundedBorderLeft01' icon.
  static const List<List<dynamic>> strokeRoundedBorderLeft01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6.5 2.5C5.40606 2.69854 4.60096 3.04969 3.96447 3.6708C2.5 5.09987 2.5 7.39991 2.5 12C2.5 16.6001 2.5 18.9001 3.96447 20.3292C4.60096 20.9503 5.40606 21.3015 6.5 21.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M17.6896 2.75143C18.7317 2.94471 19.4986 3.28657 20.105 3.89124C20.7113 4.49591 21.0541 5.26076 21.2479 6.3M10 2.50495C10.586 2.5 11.2883 2.5 11.9741 2.5C12.6599 2.5 13.4249 2.5 14.0109 2.50495M21.495 10.1C21.5 10.6844 21.5 11.3161 21.5 12C21.5 12.6839 21.5 13.3156 21.495 13.9001M21.2479 17.7C21.0541 18.7392 20.7113 19.5041 20.105 20.1088C19.4986 20.7134 18.7317 21.0553 17.6896 21.2486M10 21.495C10.586 21.5 11.2883 21.5 11.9741 21.5C12.6598 21.5 13.4249 21.5 14.0109 21.495',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 2.5V4M12 20V21.5M9 12H15M19.5312 12H21M12 9L12 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBorderLeft01' icon.
  static const List<List<dynamic>> borderLeft01 = strokeRoundedBorderLeft01;

  /// JSON structure for the 'strokeRoundedBorderLeft02' icon.
  static const List<List<dynamic>> strokeRoundedBorderLeft02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M17.6668 21.2482C18.7151 21.0549 19.4867 20.713 20.0967 20.1084C20.7066 19.5037 21.0515 18.7388 21.2465 17.6996M10.0001 21.4946C10.5897 21.4996 11.2269 21.4996 11.9168 21.4996C12.6067 21.4996 13.2439 21.4996 13.8335 21.4946M21.4951 13.8996C21.5001 13.3152 21.5001 12.6835 21.5001 11.9996C21.5001 11.3157 21.5001 10.684 21.4951 10.0995M21.2465 6.2996C21.0515 5.26036 20.7066 4.49552 20.0967 3.89085C19.4867 3.28618 18.7151 2.94431 17.6668 2.75103M10.0001 2.50456C10.5894 2.4996 11.2272 2.4996 11.9168 2.4996C12.6066 2.4996 13.2438 2.4996 13.8333 2.50456',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M6.50012 21.4996C5.40618 21.3011 4.60108 20.9499 3.96459 20.3288C2.50012 18.8997 2.50012 16.5997 2.50012 11.9996C2.50012 7.39951 2.50012 5.09947 3.96459 3.67041C4.60108 3.0493 5.40618 2.69814 6.50012 2.4996',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBorderLeft02' icon.
  static const List<List<dynamic>> borderLeft02 = strokeRoundedBorderLeft02;

  /// JSON structure for the 'strokeRoundedBorderNone01' icon.
  static const List<List<dynamic>> strokeRoundedBorderNone01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6.3 2.75143C5.26076 2.94471 4.49591 3.28657 3.89124 3.89124C3.28657 4.49591 2.94471 5.26076 2.75143 6.3M17.7 2.75143C18.7392 2.94471 19.5041 3.28657 20.1088 3.89124C20.7134 4.49591 21.0553 5.26076 21.2486 6.3M13.9 2.50495C13.3156 2.5 12.6839 2.5 12 2.5C11.3161 2.5 10.6844 2.5 10.1 2.50495M21.495 10.1C21.5 10.6844 21.5 11.3161 21.5 12C21.5 12.6839 21.5 13.3156 21.495 13.9001M2.50495 10.1C2.5 10.6844 2.5 11.3161 2.5 12C2.5 12.6839 2.5 13.3156 2.50496 13.9001M2.75143 17.7C2.94471 18.7392 3.28657 19.5041 3.89124 20.1088C4.49591 20.7134 5.26076 21.0553 6.3 21.2486M21.2486 17.7C21.0553 18.7392 20.7134 19.5041 20.1088 20.1088C19.5041 20.7134 18.7392 21.0553 17.7 21.2486M13.9 21.495C13.3156 21.5 12.6839 21.5 12 21.5C11.3162 21.5 10.6845 21.5 10.1002 21.495',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M9.15 12H14.85M19.6 12H21.5M2.5 12H4.4M12 9.15V14.85M12 2.5V4.4M12 19.6V21.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBorderNone01' icon.
  static const List<List<dynamic>> borderNone01 = strokeRoundedBorderNone01;

  /// JSON structure for the 'strokeRoundedBorderNone02' icon.
  static const List<List<dynamic>> strokeRoundedBorderNone02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6.3 2.75143C5.26076 2.94471 4.49591 3.28657 3.89124 3.89124C3.28657 4.49591 2.94471 5.26076 2.75143 6.3M17.7 2.75143C18.7392 2.94471 19.5041 3.28657 20.1088 3.89124C20.7134 4.49591 21.0553 5.26076 21.2486 6.3M13.9 2.50495C13.3156 2.5 12.6839 2.5 12 2.5C11.3161 2.5 10.6844 2.5 10.1 2.50495M21.495 10.1C21.5 10.6844 21.5 11.3161 21.5 12C21.5 12.6839 21.5 13.3156 21.495 13.9001M2.50495 10.1C2.5 10.6844 2.5 11.3161 2.5 12C2.5 12.6839 2.5 13.3156 2.50496 13.9001M2.75143 17.7C2.94471 18.7392 3.28657 19.5041 3.89124 20.1088C4.49591 20.7134 5.26076 21.0553 6.3 21.2486M21.2486 17.7C21.0553 18.7392 20.7134 19.5041 20.1088 20.1088C19.5041 20.7134 18.7392 21.0553 17.7 21.2486M13.9 21.495C13.3156 21.5 12.6839 21.5 12 21.5C11.3162 21.5 10.6845 21.5 10.1002 21.495',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBorderNone02' icon.
  static const List<List<dynamic>> borderNone02 = strokeRoundedBorderNone02;

  /// JSON structure for the 'strokeRoundedBorderRight01' icon.
  static const List<List<dynamic>> strokeRoundedBorderRight01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M17.5 2.5C18.5939 2.69854 19.399 3.04969 20.0355 3.6708C21.5 5.09987 21.5 7.39991 21.5 12C21.5 16.6001 21.5 18.9001 20.0355 20.3292C19.399 20.9503 18.5939 21.3015 17.5 21.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M6.31035 2.75143C5.26828 2.94471 4.50135 3.28657 3.89503 3.89124C3.28872 4.49591 2.94592 5.26076 2.75211 6.3M14 2.50495C13.414 2.5 12.7117 2.5 12.0259 2.5C11.3401 2.5 10.5751 2.5 9.9891 2.50495M2.50497 10.1C2.5 10.6844 2.5 11.3161 2.5 12C2.5 12.6839 2.5 13.3156 2.50497 13.9001M2.75211 17.7C2.94592 18.7392 3.28871 19.5041 3.89503 20.1088C4.50135 20.7134 5.26828 21.0553 6.31035 21.2486M14 21.495C13.414 21.5 12.7117 21.5 12.0259 21.5C11.3402 21.5 10.5751 21.5 9.9891 21.495',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 2.5V4M12 20V21.5M15 12H9M4.46875 12H3M12 9L12 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBorderRight01' icon.
  static const List<List<dynamic>> borderRight01 = strokeRoundedBorderRight01;

  /// JSON structure for the 'strokeRoundedBorderRight02' icon.
  static const List<List<dynamic>> strokeRoundedBorderRight02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6.33333 2.75143C5.28498 2.94471 4.51342 3.28657 3.90345 3.89124C3.29347 4.49591 2.94861 5.26076 2.75363 6.3M14 2.50496C13.4105 2.5 12.7732 2.5 12.0833 2.5C11.3934 2.5 10.7562 2.5 10.1666 2.50496M2.505 10.1C2.5 10.6844 2.5 11.3161 2.5 12C2.5 12.6839 2.5 13.3156 2.505 13.9001M2.75363 17.7C2.94861 18.7392 3.29347 19.5041 3.90345 20.1088C4.51342 20.7134 5.28498 21.0553 6.33333 21.2486M14 21.495C13.4107 21.5 12.7729 21.5 12.0833 21.5C11.3935 21.5 10.7563 21.5 10.1668 21.495',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M17.5 2.5C18.5939 2.69854 19.399 3.04969 20.0355 3.6708C21.5 5.09987 21.5 7.39991 21.5 12C21.5 16.6001 21.5 18.9001 20.0355 20.3292C19.399 20.9503 18.5939 21.3015 17.5 21.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBorderRight02' icon.
  static const List<List<dynamic>> borderRight02 = strokeRoundedBorderRight02;

  /// JSON structure for the 'strokeRoundedBorderTop01' icon.
  static const List<List<dynamic>> strokeRoundedBorderTop01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M21.5001 6.50006C21.3015 5.40612 20.9504 4.60102 20.3293 3.96453C18.9002 2.50006 16.6001 2.50006 12.0001 2.50006C7.39997 2.50006 5.09993 2.50006 3.67086 3.96453C3.04975 4.60102 2.6986 5.40612 2.50006 6.50006',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M21.2486 17.6897C21.0554 18.7318 20.7135 19.4987 20.1088 20.105C19.5041 20.7113 18.7393 21.0541 17.7001 21.248M21.4951 10.0001C21.5001 10.5861 21.5001 11.2884 21.5001 11.9742C21.5001 12.6599 21.5001 13.4249 21.4951 14.011M13.9001 21.4951C13.3156 21.5001 12.684 21.5001 12.0001 21.5001C11.3161 21.5001 10.6844 21.5001 10.1 21.4951M6.30006 21.2479C5.26082 21.0541 4.49598 20.7113 3.8913 20.105C3.28663 19.4987 2.94477 18.7318 2.75149 17.6897M2.50501 10.0001C2.50006 10.5861 2.50006 11.2884 2.50006 11.9742C2.50006 12.6599 2.50006 13.425 2.50501 14.011',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M21.5001 12.0001L20.0001 12.0001M4.00006 12.0001L2.50006 12.0001M12.0001 9.00006L12.0001 15.0001M12.0001 19.5313L12.0001 21.0001M15.0001 12.0001L9.00006 12.0001',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBorderTop01' icon.
  static const List<List<dynamic>> borderTop01 = strokeRoundedBorderTop01;

  /// JSON structure for the 'strokeRoundedBorderTop02' icon.
  static const List<List<dynamic>> strokeRoundedBorderTop02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.75313 17.6664C2.94642 18.7148 3.28828 19.4863 3.89295 20.0963C4.49762 20.7063 5.26247 21.0511 6.30171 21.2461M2.50666 9.99976C2.50171 10.5893 2.50171 11.2265 2.50171 11.9164C2.50171 12.6063 2.50171 13.2436 2.50666 13.8331M10.1017 21.4948C10.6861 21.4998 11.3178 21.4998 12.0017 21.4998C12.6856 21.4998 13.3173 21.4998 13.9018 21.4948M17.7017 21.2461C18.7409 21.0511 19.5058 20.7063 20.1105 20.0963C20.7151 19.4863 21.057 18.7148 21.2503 17.6664M21.4968 9.99976C21.5017 10.5891 21.5017 11.2268 21.5017 11.9164C21.5017 12.6063 21.5017 13.2434 21.4968 13.8329',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M2.49976 6.49988C2.69829 5.40594 3.04945 4.60084 3.67056 3.96434C5.09962 2.49988 7.39967 2.49988 11.9998 2.49988C16.5998 2.49988 18.8999 2.49988 20.329 3.96435C20.9501 4.60084 21.3012 5.40594 21.4998 6.49988',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBorderTop02' icon.
  static const List<List<dynamic>> borderTop02 = strokeRoundedBorderTop02;

  /// JSON structure for the 'strokeRoundedBorderVertical' icon.
  static const List<List<dynamic>> strokeRoundedBorderVertical = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6.3 2.75143C5.26076 2.94471 4.49591 3.28657 3.89124 3.89124C3.28657 4.49591 2.94471 5.26076 2.75143 6.3M17.7 2.75143C18.7392 2.94471 19.5041 3.28657 20.1088 3.89124C20.7134 4.49591 21.0553 5.26076 21.2486 6.3M13.9 2.50495C13.3156 2.5 12.6839 2.5 12 2.5C11.3161 2.5 10.6844 2.5 10.1 2.50495M21.495 10.1C21.5 10.6844 21.5 11.3161 21.5 12C21.5 12.6839 21.5 13.3156 21.495 13.9001M2.50495 10.1C2.5 10.6844 2.5 11.3161 2.5 12C2.5 12.6839 2.5 13.3156 2.50496 13.9001M2.75143 17.7C2.94471 18.7392 3.28657 19.5041 3.89124 20.1088C4.49591 20.7134 5.26076 21.0553 6.3 21.2486M21.2486 17.7C21.0553 18.7392 20.7134 19.5041 20.1088 20.1088C19.5041 20.7134 18.7392 21.0553 17.7 21.2486M13.9 21.495C13.3156 21.5 12.6839 21.5 12 21.5C11.3162 21.5 10.6845 21.5 10.1002 21.495',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M9.15 12H14.85M19.6 12L21.5 12M2.5 12H4.4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12 2.5L12 21.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBorderVertical' icon.
  static const List<List<dynamic>> borderVertical = strokeRoundedBorderVertical;

  /// JSON structure for the 'strokeRoundedBorobudur' icon.
  static const List<List<dynamic>> strokeRoundedBorobudur = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M8 9L8.26176 7.62577C8.51935 6.27341 8.84975 6 10.2264 6H13.7736C15.1502 6 15.4806 6.27341 15.7382 7.62578L16 9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M17.8377 19H6.16228C4.855 19 4.20136 19 3.66635 19.2728C2.62687 19.8028 2.34358 20.9693 2 22H22C21.6564 20.9693 21.3731 19.8028 20.3337 19.2728C19.7986 19 19.145 19 17.8377 19Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M9 12.5V13.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M15 12.5V13.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M12 15V16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd':
            'M10 6L10.8106 2.75746C10.9682 2.12724 11.1312 2 11.7808 2H12.2192C12.8688 2 13.0318 2.12724 13.1894 2.75746L14 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd':
            'M4 19C4.58059 18.2259 4.93646 16.8525 5.1479 15.3437C5.60299 12.0963 5.83053 10.4725 6.67717 9.73626C7.5238 9 8.92945 9 11.7407 9H12.2593C15.0706 9 16.4762 9 17.3228 9.73626C18.1695 10.4725 18.397 12.0963 18.8521 15.3437C19.0635 16.8525 19.4194 18.2259 20 19',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBorobudur' icon.
  static const List<List<dynamic>> borobudur = strokeRoundedBorobudur;

  /// JSON structure for the 'strokeRoundedBot' icon.
  static const List<List<dynamic>> strokeRoundedBot = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4 15.5C2.89543 15.5 2 14.6046 2 13.5C2 12.3954 2.89543 11.5 4 11.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M20 15.5C21.1046 15.5 22 14.6046 22 13.5C22 12.3954 21.1046 11.5 20 11.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M7 7L7 4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M17 7L17 4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'circle',
      {
        'key': '4',
        'cx': '7',
        'cy': '3',
        'r': '1',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'circle',
      {
        'key': '5',
        'cx': '17',
        'cy': '3',
        'r': '1',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '6',
        'd':
            'M13.5 7H10.5C7.67157 7 6.25736 7 5.37868 7.90898C4.5 8.81796 4.5 10.2809 4.5 13.2069C4.5 16.1329 4.5 17.5958 5.37868 18.5048C6.25736 19.4138 7.67157 19.4138 10.5 19.4138H11.5253C12.3169 19.4138 12.5962 19.5773 13.1417 20.1713C13.745 20.8283 14.6791 21.705 15.5242 21.9091C16.7254 22.1994 16.8599 21.7979 16.5919 20.6531C16.5156 20.327 16.3252 19.8056 16.526 19.5018C16.6385 19.3316 16.8259 19.2898 17.2008 19.2061C17.7922 19.074 18.2798 18.8581 18.6213 18.5048C19.5 17.5958 19.5 16.1329 19.5 13.2069C19.5 10.2809 19.5 8.81796 18.6213 7.90898C17.7426 7 16.3284 7 13.5 7Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '7',
        'd':
            'M9.5 15C10.0701 15.6072 10.9777 16 12 16C13.0223 16 13.9299 15.6072 14.5 15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '8',
        'd': 'M9.00896 11H9',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '9',
        'd': 'M15.009 11H15',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBot' icon.
  static const List<List<dynamic>> bot = strokeRoundedBot;

  /// JSON structure for the 'strokeRoundedBounceLeft' icon.
  static const List<List<dynamic>> strokeRoundedBounceLeft = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M9 10C11.1153 13.01 12.1055 17.1528 12.752 20.086C12.8835 20.6824 12.9492 20.9806 13.0872 20.9991C13.2252 21.0177 13.3662 20.7339 13.6482 20.1662C14.9939 17.4579 17.7827 15.062 20 17.1079',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'circle',
      {
        'key': '1',
        'cx': '2',
        'cy': '2',
        'r': '2',
        'transform': 'matrix(-1 0 0 1 8 3)',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBounceLeft' icon.
  static const List<List<dynamic>> bounceLeft = strokeRoundedBounceLeft;

  /// JSON structure for the 'strokeRoundedBounceRight' icon.
  static const List<List<dynamic>> strokeRoundedBounceRight = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M15 10C12.8847 13.01 11.8945 17.1528 11.248 20.086C11.1165 20.6824 11.0508 20.9806 10.9128 20.9991C10.7748 21.0177 10.6338 20.7339 10.3518 20.1662C9.00614 17.4579 6.21729 15.062 4 17.1079',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'circle',
      {
        'key': '1',
        'cx': '18',
        'cy': '5',
        'r': '2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBounceRight' icon.
  static const List<List<dynamic>> bounceRight = strokeRoundedBounceRight;

  /// JSON structure for the 'strokeRoundedBoundingBox' icon.
  static const List<List<dynamic>> strokeRoundedBoundingBox = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6 4H10M4 10V6M12 6V10M6 12H10M14 12H18M20 14V18M12 14V18M14 20H18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'circle',
      {
        'key': '1',
        'cx': '4',
        'cy': '4',
        'r': '2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'circle',
      {
        'key': '2',
        'cx': '4',
        'cy': '12',
        'r': '2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'circle',
      {
        'key': '3',
        'cx': '12',
        'cy': '4',
        'r': '2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'circle',
      {
        'key': '4',
        'cx': '12',
        'cy': '12',
        'r': '2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'circle',
      {
        'key': '5',
        'cx': '20',
        'cy': '12',
        'r': '2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'circle',
      {
        'key': '6',
        'cx': '12',
        'cy': '20',
        'r': '2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'circle',
      {
        'key': '7',
        'cx': '20',
        'cy': '20',
        'r': '2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBoundingBox' icon.
  static const List<List<dynamic>> boundingBox = strokeRoundedBoundingBox;

  /// JSON structure for the 'strokeRoundedBowTie' icon.
  static const List<List<dynamic>> strokeRoundedBowTie = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M10 9.5022C9 8.50179 6.02143 5.77926 4.66065 6.01432C1.11312 6.62711 1.11312 17.3771 4.66065 17.9899C6.02143 18.2249 9 15.5025 10 14.5021',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M14 9.5022C15 8.50179 17.9786 5.77926 19.3393 6.01432C22.8869 6.62711 22.8869 17.3771 19.3393 17.9899C17.9786 18.2249 15 15.5025 14 14.5022',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M9.5 12.002C9.5 9.90315 10.1219 9.00195 12 9.00195C13.749 9.00195 14.5 9.74822 14.5 12.002C14.5 14.1008 13.8781 15.002 12 15.002C10.1219 15.002 9.5 14.1008 9.5 12.002Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M9 12.002H8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M16 12.002H15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBowTie' icon.
  static const List<List<dynamic>> bowTie = strokeRoundedBowTie;

  /// JSON structure for the 'strokeRoundedBowling' icon.
  static const List<List<dynamic>> strokeRoundedBowling = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M10.5638 6.56062L10.1822 4.45142C9.95278 3.18322 10.8302 2 12 2C13.1698 2 14.0472 3.18322 13.8178 4.45142L13.4362 6.56062C12.8624 9.73293 14.4246 11.6357 15.5111 14.2704C15.9844 15.4182 16.1184 16.7017 15.8941 17.9385C15.702 18.998 15.3996 20.6686 14.7603 21.4829C14.3324 22.0281 13.7247 21.9997 13.1202 21.9997H10.8798C10.2753 21.9997 9.66764 22.0281 9.2397 21.4829C8.60041 20.6686 8.29796 18.998 8.10586 17.9385C7.88161 16.7017 8.01565 15.4182 8.48894 14.2704C9.57541 11.6357 11.1376 9.73293 10.5638 6.56062Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M11 8H13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M18 19.9998H19.2945C19.8625 19.9998 20.4333 20.0225 20.8354 19.5863C21.4354 18.9354 21.7196 17.6008 21.9001 16.7531L21.9005 16.7508C22.1112 15.7614 21.9853 14.7346 21.5407 13.8164C20.52 11.7085 19.0523 10.1863 19.5914 7.64849L19.9499 5.96114C20.1654 4.94657 19.3412 4 18.2422 4C17.1432 4 16.3189 4.94657 16.5344 5.96114L16.8929 7.64849C17.0992 8.6198 17.0116 9.44233 16.7676 10.2059M16.9677 9.33333H19.5176',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M6 19.9998H4.70545C4.13752 19.9998 3.56668 20.0225 3.16465 19.5863C2.56461 18.9354 2.28044 17.6008 2.09994 16.7531L2.09945 16.7508C1.88877 15.7614 2.0147 14.7346 2.45934 13.8164C3.48003 11.7085 4.94769 10.1863 4.40855 7.64849L4.05009 5.96114C3.83456 4.94657 4.65883 4 5.75784 4C6.85685 4 7.68112 4.94657 7.46559 5.96114L7.10713 7.64849C6.90078 8.6198 6.98839 9.44233 7.2324 10.2059M7.03228 9.33333H4.48242',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBowling' icon.
  static const List<List<dynamic>> bowling = strokeRoundedBowling;

  /// JSON structure for the 'strokeRoundedBowlingBall' icon.
  static const List<List<dynamic>> strokeRoundedBowlingBall = [
    [
      'circle',
      {
        'key': '0',
        'cx': '12',
        'cy': '12',
        'r': '10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M15 6V6.01',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M18 9V9.01',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M14 10V10.01',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBowlingBall' icon.
  static const List<List<dynamic>> bowlingBall = strokeRoundedBowlingBall;

  /// JSON structure for the 'strokeRoundedBowlingPins' icon.
  static const List<List<dynamic>> strokeRoundedBowlingPins = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12.5 10.544C13.2611 10.1947 14.1078 10 15 10C18.3137 10 21 12.6863 21 16C21 19.3137 18.3137 22 15 22C14.4821 22 13.9794 21.9344 13.5 21.811',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M17.991 15H18M15 15H15.009M16.4955 13L16.5045 13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M5.88423 6.56062L5.45498 4.45142C5.19688 3.18322 6.18394 2 7.5 2C8.81606 2 9.80312 3.18322 9.54502 4.45142L9.11577 6.56062C8.47015 9.73293 10.2277 11.6357 11.4499 14.2704C11.9824 15.4182 12.1332 16.7017 11.8809 17.9385C11.6648 18.998 11.3245 20.6686 10.6053 21.4829C10.1239 22.0281 9.44033 21.9997 8.76023 21.9997H6.23977C5.55967 21.9997 4.87609 22.0281 4.39466 21.4829C3.67546 20.6686 3.33521 18.998 3.11909 17.9385C2.86681 16.7017 3.01761 15.4182 3.55006 14.2704C4.77234 11.6357 6.52985 9.73293 5.88423 6.56062Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M6 9H9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBowlingPins' icon.
  static const List<List<dynamic>> bowlingPins = strokeRoundedBowlingPins;

  /// JSON structure for the 'strokeRoundedBoxer' icon.
  static const List<List<dynamic>> strokeRoundedBoxer = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4.82004 3H19.18C19.7167 3 19.9851 3 20.1838 3.0927C20.4487 3.21631 20.6461 3.451 20.7237 3.73439C20.7818 3.94693 20.7377 4.21349 20.6495 4.7466C20.584 5.14188 20.5513 5.33952 20.4642 5.49389C20.3481 5.69972 20.1632 5.8574 19.9425 5.93889C19.777 6 19.578 6 19.18 6H4.82003C4.42204 6 4.22304 6 4.05749 5.93889C3.83676 5.8574 3.65189 5.69972 3.53577 5.49389C3.44869 5.33952 3.41597 5.14188 3.35054 4.7466C3.2623 4.21349 3.21817 3.94693 3.27633 3.73439C3.35388 3.451 3.55133 3.21631 3.81621 3.0927C4.01487 3 4.28326 3 4.82004 3Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M4 6C2.80083 8.35175 2 10.0659 2 12.7001V17.7669C2 19.1536 2 19.847 2.43934 20.2778C3.35803 21.1786 8.51722 21.3009 9.56066 20.2778C10.6442 19.2153 9.60514 17.1627 10.1522 15.8675C10.488 15.0728 11.3875 14.4452 12 13.8446M12 13.8446L10.5 12.3737M12 13.8446C12.6125 14.4452 13.512 15.0728 13.8478 15.8675C14.3949 17.1627 13.3558 19.2153 14.4393 20.2778C15.358 21.1786 20.5172 21.3009 21.5607 20.2778C22 19.847 22 19.1536 22 17.7669V12.7001C22 10.0659 21.1992 8.35174 20 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M10 8.77778L12 6L15 11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBoxer' icon.
  static const List<List<dynamic>> boxer = strokeRoundedBoxer;

  /// JSON structure for the 'strokeRoundedBoxingBag' icon.
  static const List<List<dynamic>> strokeRoundedBoxingBag = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M18 17.5C14 18.8333 10 18.8333 6 17.5M18 10.5C14 9.16667 10 9.16667 6 10.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M16 6.5L13.4948 3.68167C12.7977 2.89736 12.4491 2.5052 12 2.5052C11.5509 2.5052 11.2023 2.89736 10.5052 3.68167L8 6.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M18 2L6 2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M9.1114 21.7682C11.0371 22.0773 12.9629 22.0773 14.8886 21.7682C17.517 21.3464 18 20.4678 18 18.2919V9.70813C18 7.53225 17.517 6.65357 14.8886 6.23178C12.9629 5.92274 11.0371 5.92274 9.1114 6.23178C6.48303 6.65357 6 7.53225 6 9.70813V18.2919C6 20.4678 6.48303 21.3464 9.1114 21.7682Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBoxingBag' icon.
  static const List<List<dynamic>> boxingBag = strokeRoundedBoxingBag;

  /// JSON structure for the 'strokeRoundedBoxingGlove' icon.
  static const List<List<dynamic>> strokeRoundedBoxingGlove = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M16.5841 6.05737C18.9187 6.05737 19.5461 9.24441 18.5423 11.3422C18.0933 12.2806 17.3165 13.1051 16.6946 13.9357C16.0982 14.7322 15.8 15.1304 15.408 15.4091C14.5339 16.0304 13.522 16 12.4897 16H11.4583C8.91929 16 7.64977 16 6.81095 15.2904C5.97214 14.5809 5.76679 13.3596 5.3561 10.917C5.13029 9.57401 4.97133 8.23222 5.00434 6.93135C5.06478 4.54904 6.8888 2.54273 9.35241 2.14874C10.526 1.96106 11.9711 1.94251 13.1454 2.14182C15.2422 2.49775 16.7207 4.30419 16.5741 6.33112C16.4847 7.56721 15.9831 8.83974 15.67 10.0344',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M7.00391 15.5V18C7.00391 19.8856 7.00391 20.8284 7.58969 21.4142C8.17548 22 9.11829 22 11.0039 22H12.0039C13.8895 22 14.8323 22 15.4181 21.4142C16.0039 20.8284 16.0039 19.8856 16.0039 18V15',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M7.00391 19H10.0039',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBoxingGlove' icon.
  static const List<List<dynamic>> boxingGlove = strokeRoundedBoxingGlove;

  /// JSON structure for the 'strokeRoundedBoxingGlove01' icon.
  static const List<List<dynamic>> strokeRoundedBoxingGlove01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5.98148 11.2453C5.89446 13.9678 9.10256 17.3235 12.1105 18.3784M5.98148 11.2453C5.67692 11.768 2.56612 14.2618 2.51173 15.3182C2.24816 17.416 5.81222 21.357 8.56025 21.4915C9.58647 21.6371 11.0099 19.9102 12.4528 18.6272C13.2475 17.9205 14.3928 17.7571 18.9772 16.6194C20.6408 16.3303 22.6394 13.4607 19.6766 11.0283M5.98148 11.2453C6.9097 9.04414 8.51438 4.78884 11.6614 3.10843C12.9394 2.3823 16.2588 1.71372 19.5114 4.80592C20.6304 5.74702 22.5701 7.80848 20.7647 10.1836C19.561 11.5864 17.741 11.1803 17.5642 13.6064',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBoxingGlove01' icon.
  static const List<List<dynamic>> boxingGlove01 = strokeRoundedBoxingGlove01;

  /// JSON structure for the 'strokeRoundedBrain' icon.
  static const List<List<dynamic>> strokeRoundedBrain = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M16.998 7.12652C17.3182 7.04393 17.654 7 18 7C20.2091 7 22 8.79086 22 11C22 13.2091 20.2091 15 18 15C17.6451 15 17.3009 14.9538 16.9733 14.867M16.998 7.12652C16.9993 7.08451 17 7.04233 17 7C17 4.79086 15.2091 3 13 3C11.0824 3 9.47994 4.34939 9.09041 6.15043M16.998 7.12652C16.9769 7.80763 16.7854 8.44584 16.4649 9M16.9733 14.867C16.9909 14.7472 17 14.6247 17 14.5C17 13.2905 16.1411 12.2816 15 12.05M16.9733 14.867C16.7957 16.0737 15.756 17 14.5 17H14C11.7909 17 10 18.7909 10 21M9.09041 6.15043C8.74377 6.05243 8.37801 6 8 6C5.79086 6 4 7.79086 4 10C4 10.3886 4.05542 10.7643 4.15878 11.1195M9.09041 6.15043C10.1015 6.43625 10.9498 7.10965 11.4649 8M4.15878 11.1195C2.9114 11.4832 2 12.6352 2 14C2 15.6569 3.34315 17 5 17C6.30622 17 7.41746 16.1652 7.82929 15M4.15878 11.1195C4.24921 11.4303 4.37632 11.7255 4.53513 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M11.8361 11.7435C11.3257 12.2353 10.453 12.3202 9.70713 11.9008C8.9612 11.4814 8.58031 10.6917 8.73535 10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBrain' icon.
  static const List<List<dynamic>> brain = strokeRoundedBrain;

  /// JSON structure for the 'strokeRoundedBrain01' icon.
  static const List<List<dynamic>> strokeRoundedBrain01 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M15 8.5C13.3431 8.5 12 7.15685 12 5.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M12 5V19.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M20 16.5C20 14.8431 18.6569 13.5 17 13.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M4 16.5C4 14.8431 5.34315 13.5 7 13.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd':
            'M16 19.5C16 20.6046 15.1046 21.5 14 21.5C12.8954 21.5 12 20.6046 12 19.5C12 20.6046 11.1046 21.5 10 21.5C8.89543 21.5 8 20.6046 8 19.5C8 19.4404 8.00466 19.3815 8.00977 19.3232C7.694 19.4362 7.35459 19.5 7 19.5C5.34315 19.5 4 18.1569 4 16.5C4 15.9246 4.16545 15.3892 4.44629 14.9326C3.28052 14.2336 2.5 12.9582 2.5 11.5C2.5 10.5452 2.8353 9.66916 3.39355 8.98145C3.14445 8.54412 3 8.03929 3 7.5C3 5.84315 4.34315 4.5 6 4.5C6.35951 4.5 6.70301 4.56666 7.02246 4.68262C7.17854 3.45191 8.22691 2.5 9.5 2.5C10.8807 2.5 12 3.61929 12 5C12 3.61929 13.1193 2.5 14.5 2.5C15.7731 2.5 16.8215 3.45191 16.9775 4.68262C17.297 4.56666 17.6405 4.5 18 4.5C19.6569 4.5 21 5.84315 21 7.5C21 8.03929 20.8555 8.54412 20.6064 8.98145C21.1647 9.66916 21.5 10.5452 21.5 11.5C21.5 12.9582 20.7195 14.2336 19.5537 14.9326C19.8346 15.3892 20 15.9246 20 16.5C20 18.1569 18.6569 19.5 17 19.5C16.6454 19.5 16.306 19.4362 15.9902 19.3232C15.9953 19.3815 16 19.4404 16 19.5Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBrain01' icon.
  static const List<List<dynamic>> brain01 = strokeRoundedBrain01;

  /// JSON structure for the 'strokeRoundedBrain02' icon.
  static const List<List<dynamic>> strokeRoundedBrain02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4.22222 21.9948V18.4451C4.22222 17.1737 3.88927 16.5128 3.23482 15.4078C2.4503 14.0833 2 12.5375 2 10.8866C2 5.97866 5.97969 2 10.8889 2C15.7981 2 19.7778 5.97866 19.7778 10.8866C19.7778 11.4663 19.7778 11.7562 19.802 11.9187C19.8598 12.3072 20.0411 12.6414 20.2194 12.9873L22 16.4407L20.6006 17.1402C20.195 17.3429 19.9923 17.4443 19.851 17.6314C19.7097 17.8184 19.67 18.0296 19.5904 18.4519L19.5826 18.4931C19.4004 19.4606 19.1993 20.5286 18.6329 21.2024C18.4329 21.4403 18.1853 21.6336 17.9059 21.7699C17.4447 21.9948 16.8777 21.9948 15.7437 21.9948C15.219 21.9948 14.6928 22.0069 14.1682 21.9942C12.9247 21.9639 12 20.9184 12 19.7044',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M14.388 10.5315C13.9617 10.5315 13.5729 10.3702 13.2784 10.1048M14.388 10.5315C14.388 11.6774 13.7241 12.7658 12.4461 12.7658C11.1681 12.7658 10.5043 13.8541 10.5043 15M14.388 10.5315C16.5373 10.5315 16.5373 7.18017 14.388 7.18017C14.1927 7.18017 14.0053 7.21403 13.8312 7.27624C13.9362 4.77819 10.3349 4.1 9.51923 6.44018M10.5043 8.29729C10.5043 7.52323 10.1133 6.8411 9.51923 6.44018M9.51923 6.44018C7.66742 5.19034 5.19883 7.4331 6.37324 9.43277C4.40226 9.72827 4.61299 12.7658 6.6205 12.7658C7.18344 12.7658 7.68111 12.4844 7.98234 12.0538',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBrain02' icon.
  static const List<List<dynamic>> brain02 = strokeRoundedBrain02;

  /// JSON structure for the 'strokeRoundedBrain03' icon.
  static const List<List<dynamic>> strokeRoundedBrain03 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12 19V5C12 3.34315 10.6569 2 9 2C7.34315 2 6 3.34315 6 5C6 5.55228 5.55228 6 5 6C3.34315 6 2 7.34315 2 9C2 10.6569 3.34315 12 5 12C3.34315 12 2 13.3431 2 15C2 16.6569 3.34315 18 5 18C5.55228 18 6 18.4477 6 19C6 20.6569 7.34315 22 9 22C10.6569 22 12 20.6569 12 19Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M12 19V5C12 3.34315 13.3431 2 15 2C16.6569 2 18 3.34315 18 5C18 5.55228 18.4477 6 19 6C20.6569 6 22 7.34315 22 9C22 10.6569 20.6569 12 19 12C20.6569 12 22 13.3431 22 15C22 16.6569 20.6569 18 19 18C18.4477 18 18 18.4477 18 19C18 20.6569 16.6569 22 15 22C13.3431 22 12 20.6569 12 19Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBrain03' icon.
  static const List<List<dynamic>> brain03 = strokeRoundedBrain03;

  /// JSON structure for the 'strokeRoundedBrandfetch' icon.
  static const List<List<dynamic>> strokeRoundedBrandfetch = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M5 6.85746C10.5 2.42557 19 3.53936 19 7.52832C19 10.5665 11.5 12 11.5 12C11.5 12 17.5 11.6935 17.5 14.451C17.5 19.0482 8 17.8628 8 17.8628',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M9 8.5C8.33333 11.1667 7 16 7 20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBrandfetch' icon.
  static const List<List<dynamic>> brandfetch = strokeRoundedBrandfetch;

  /// JSON structure for the 'strokeRoundedBread01' icon.
  static const List<List<dynamic>> strokeRoundedBread01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3.19405 14.077C1.94563 15.3082 1.84437 17.6176 2.13655 19.7508C2.40166 21.6864 4.57937 22.5986 6.21199 21.5763C9.1986 19.7061 12.3179 17.2421 15.3067 14.2947C18.3772 11.2666 20.0596 8.96143 21.5435 6.36753C22.4433 4.79463 22.0218 2.69734 20.1997 2.23223C18.2048 1.72304 15.6191 1.93195 13.3375 4.0775M3.19405 14.077C2.36031 10.337 5.29027 5.93188 12.1656 9.7943M3.19405 14.077C3.81736 14.0897 5.21758 14.3717 6.5544 15.3245M6.84592 8.19547C6.90898 6.25487 8.82259 3.00486 13.3375 4.0775M13.3375 4.0775C14.304 4.30712 15.3897 4.73482 16.602 5.41585',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBread01' icon.
  static const List<List<dynamic>> bread01 = strokeRoundedBread01;

  /// JSON structure for the 'strokeRoundedBread02' icon.
  static const List<List<dynamic>> strokeRoundedBread02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12 14C12 17 9.76142 17 7 17C4.23858 17 2 17 2 14C2 11 4.23858 7 7 7C9.76142 7 12 11 12 14Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M7 7H17C19.7614 7 22 11 22 14C22 17 19.7614 17 17 17H7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M5.86019 17C7.4363 17 9 16.1 9 14C9 11.9 8.14239 10 6.6451 10C5.14782 10 4.31835 13.97 5.7172 14.5C7.03693 15 7.04538 13 7.04538 13',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBread02' icon.
  static const List<List<dynamic>> bread02 = strokeRoundedBread02;

  /// JSON structure for the 'strokeRoundedBread03' icon.
  static const List<List<dynamic>> strokeRoundedBread03 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M15 11C15 8.23858 13.1011 6 10.7588 6C9.1261 6 7.5 7 7 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M19 11C19 8.79086 17.4818 7 15.609 7C15.0267 7 14.4787 7.1731 14 7.47806',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M22 12C22 15.3137 17.5228 18 12 18C6.47715 18 2 15.3137 2 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M8.88973 11C8.5012 9.27477 7.13086 8 5.5 8C3.567 8 2 9.79086 2 12C2 13.6569 6.47715 15 12 15C17.5228 15 22 13.6569 22 12C22 11.0054 20.4499 9.02165 18.5314 9.00018',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBread03' icon.
  static const List<List<dynamic>> bread03 = strokeRoundedBread03;

  /// JSON structure for the 'strokeRoundedBread04' icon.
  static const List<List<dynamic>> strokeRoundedBread04 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M8.5 4C5.04311 4 2 5.59321 2 7.55853C2 8.92302 3.6427 9.93848 3.43338 11.2206L3.18919 15.7778C3.08307 17.7584 3.03001 18.7487 3.59988 19.3744C4.16975 20 5.12486 20 7.0351 20H9.9649C11.8751 20 12.8303 20 13.4001 19.3744C13.97 18.7487 13.9169 17.7584 13.8108 15.7778L13.5666 11.2206C13.3573 9.93848 15 8.92302 15 7.55853C15 5.59321 11.9569 4 8.5 4Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M11 20H17.1838C19.011 20 19.9246 20 20.4697 19.3744C21.0148 18.7487 20.964 17.7584 20.8625 15.7778L20.629 11.2206C20.4287 9.93848 22 8.92302 22 7.55853C22 5.59321 19.0892 4 15.7826 4H8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBread04' icon.
  static const List<List<dynamic>> bread04 = strokeRoundedBread04;

  /// JSON structure for the 'strokeRoundedBreastPump' icon.
  static const List<List<dynamic>> strokeRoundedBreastPump = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M11.2143 22H13.7857C15.3951 22 16.1998 22 16.747 21.5637C16.8641 21.4703 16.9703 21.3641 17.0637 21.247C17.5 20.6998 17.5 19.8951 17.5 18.2857V14C17.5 11.2386 15.2614 9 12.5 9C9.73858 9 7.5 11.2386 7.5 14V18.2857C7.5 19.8951 7.5 20.6998 7.93634 21.247C8.02971 21.3641 8.13594 21.4703 8.25302 21.5637C8.80017 22 9.60488 22 11.2143 22Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M15 14H17.5M15 18H17.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M12.5 9V6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M15 6H9C8.51194 6 8.26792 6 8.03739 6.02684C7.10692 6.13518 6.24399 6.56665 5.59904 7.24602C5.43925 7.41433 5.29283 7.60956 5 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'circle',
      {
        'key': '4',
        'cx': '4.5',
        'cy': '9.5',
        'r': '1.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd':
            'M15 5.99954C16.0195 5.49103 17.5998 4.17647 18.3402 3.29011C18.8693 2.6567 19.5 2 21 2V10C19.5 10 18.8693 9.34284 18.3402 8.70943C17.5998 7.82307 16.0195 6.50805 15 5.99954Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBreastPump' icon.
  static const List<List<dynamic>> breastPump = strokeRoundedBreastPump;

  /// JSON structure for the 'strokeRoundedBridge' icon.
  static const List<List<dynamic>> strokeRoundedBridge = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M3 7C3.5 7 5 6.5 6 5C7 6.5 9 9 12 9C15 9 17 6.5 18 5C19 6.5 20.5 7 21 7',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M6 4V20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M2 16H22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M18 4V20',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M10 9V16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '5',
        'd': 'M14 9V16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBridge' icon.
  static const List<List<dynamic>> bridge = strokeRoundedBridge;

  /// JSON structure for the 'strokeRoundedBriefcase01' icon.
  static const List<List<dynamic>> strokeRoundedBriefcase01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.00127 8.5L1.99911 13.997C1.99782 17.2979 1.99717 18.9484 3.02235 19.974C4.04754 20.9996 5.69801 20.9996 8.99895 20.9997L15 20.9998C18.2994 20.9999 19.949 21 20.9741 19.9751C21.9992 18.9502 21.9996 17.3005 22.0002 14.0012L22.0013 8.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M8.49857 6.5C8.49857 5.09554 8.49857 4.39331 8.83563 3.88886C8.98154 3.67048 9.16904 3.48298 9.38743 3.33706C9.89187 3 10.5941 3 11.9986 3C13.403 3 14.1053 3 14.6097 3.33706C14.8281 3.48298 15.0156 3.67048 15.1615 3.88886C15.4986 4.39331 15.4986 5.09554 15.4986 6.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M19.998 6.50016L3.99885 6.5C2.8944 6.50007 1.99876 7.39568 1.99866 8.50013C1.99876 10.7091 3.79005 12.5004 5.99901 12.5006H17.9978C20.2068 12.5005 21.998 10.7093 21.9981 8.5003C21.998 7.39582 21.1024 6.50023 19.998 6.50016Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M9.99857 12.5V13.5C9.99857 13.965 9.99857 14.1975 10.0497 14.3882C10.1884 14.9059 10.5927 15.3102 11.1103 15.4489C11.3011 15.5 11.5336 15.5 11.9986 15.5C12.4636 15.5 12.696 15.5 12.8868 15.4489C13.4044 15.3102 13.8088 14.9059 13.9475 14.3882C13.9986 14.1975 13.9986 13.965 13.9986 13.5V12.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBriefcase01' icon.
  static const List<List<dynamic>> briefcase01 = strokeRoundedBriefcase01;

  /// JSON structure for the 'strokeRoundedBriefcase02' icon.
  static const List<List<dynamic>> strokeRoundedBriefcase02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M8.49869 6.50012C8.49869 5.09566 8.49869 4.39343 8.83575 3.88898C8.98167 3.6706 9.16917 3.4831 9.38755 3.33718C9.89199 3.00012 10.5942 3.00012 11.9987 3.00012C13.4032 3.00012 14.1054 3.00012 14.6098 3.33718C14.8282 3.4831 15.0157 3.6706 15.1616 3.88898C15.4987 4.39343 15.4987 5.09566 15.4987 6.50012',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M19.9981 6.50028L3.99901 6.50012C2.89455 6.50019 1.99891 7.3958 1.99881 8.50025C1.99891 10.7092 3.7902 12.5005 5.99916 12.5007H17.998C20.2069 12.5006 21.9981 10.7094 21.9982 8.50042C21.9982 7.39594 21.1026 6.50036 19.9981 6.50028Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M7.49869 11.0001V14.0001M16.4987 14.0001V11.0001',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M2.00114 8.50012L1.99899 13.9971C1.9977 17.298 1.99705 18.9485 3.02223 19.9741C4.04741 20.9997 5.69789 20.9998 8.99883 20.9998L14.9999 21C18.2992 21 19.9489 21.0001 20.974 19.9752C21.9991 18.9503 21.9994 17.3006 22.0001 14.0013L22.0011 8.50012',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBriefcase02' icon.
  static const List<List<dynamic>> briefcase02 = strokeRoundedBriefcase02;

  /// JSON structure for the 'strokeRoundedBriefcase03' icon.
  static const List<List<dynamic>> strokeRoundedBriefcase03 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M8.5 6.5C8.5 5.09554 8.5 4.39331 8.83706 3.88886C8.98298 3.67048 9.17048 3.48298 9.38886 3.33706C9.89331 3 10.5955 3 12 3C13.4045 3 14.1067 3 14.6111 3.33706C14.8295 3.48298 15.017 3.67048 15.1629 3.88886C15.5 4.39331 15.5 5.09554 15.5 6.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M22 14V13.5C22 10.2002 22 8.55025 20.9749 7.52513C19.9497 6.5 18.2998 6.5 15 6.5H9C5.70017 6.5 4.05025 6.5 3.02513 7.52513C2 8.55025 2 10.2002 2 13.5V14C2 17.2998 2 18.9497 3.02513 19.9749C4.05025 21 5.70017 21 9 21H15C18.2998 21 19.9497 21 20.9749 19.9749C22 18.9497 22 17.2998 22 14Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M2 12.5H22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M10 12.5V13.5C10 13.965 10 14.1975 10.0511 14.3882C10.1898 14.9059 10.5941 15.3102 11.1118 15.4489C11.3025 15.5 11.535 15.5 12 15.5C12.465 15.5 12.6975 15.5 12.8882 15.4489C13.4059 15.3102 13.8102 14.9059 13.9489 14.3882C14 14.1975 14 13.965 14 13.5V12.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBriefcase03' icon.
  static const List<List<dynamic>> briefcase03 = strokeRoundedBriefcase03;

  /// JSON structure for the 'strokeRoundedBriefcase04' icon.
  static const List<List<dynamic>> strokeRoundedBriefcase04 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M8.5 6.5C8.5 5.09554 8.5 4.39331 8.83706 3.88886C8.98298 3.67048 9.17048 3.48298 9.38886 3.33706C9.89331 3 10.5955 3 12 3C13.4045 3 14.1067 3 14.6111 3.33706C14.8295 3.48298 15.017 3.67048 15.1629 3.88886C15.5 4.39331 15.5 5.09554 15.5 6.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M22 14V13.5C22 10.2002 22 8.55025 20.9749 7.52513C19.9497 6.5 18.2998 6.5 15 6.5H9C5.70017 6.5 4.05025 6.5 3.02513 7.52513C2 8.55025 2 10.2002 2 13.5V14C2 17.2998 2 18.9497 3.02513 19.9749C4.05025 21 5.70017 21 9 21H15C18.2998 21 19.9497 21 20.9749 19.9749C22 18.9497 22 17.2998 22 14Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M13.5 14C19.5735 13.5094 21.75 10 21.75 10M2.25 10C2.25 10 4.42655 13.5094 10.5 14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M10.5 14V13C10.5 12.7239 10.7239 12.5 11 12.5H13C13.2761 12.5 13.5 12.7239 13.5 13V14C13.5 14.8284 12.8284 15.5 12 15.5C11.1716 15.5 10.5 14.8284 10.5 14Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBriefcase04' icon.
  static const List<List<dynamic>> briefcase04 = strokeRoundedBriefcase04;

  /// JSON structure for the 'strokeRoundedBriefcase05' icon.
  static const List<List<dynamic>> strokeRoundedBriefcase05 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M8.5 6.5C8.5 5.09554 8.5 4.39331 8.83706 3.88886C8.98298 3.67048 9.17048 3.48298 9.38886 3.33706C9.89331 3 10.5955 3 12 3C13.4045 3 14.1067 3 14.6111 3.33706C14.8295 3.48298 15.017 3.67048 15.1629 3.88886C15.5 4.39331 15.5 5.09554 15.5 6.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M22 14V13.5C22 10.2002 22 8.55025 20.9749 7.52513C19.9497 6.5 18.2998 6.5 15 6.5H9C5.70017 6.5 4.05025 6.5 3.02513 7.52513C2 8.55025 2 10.2002 2 13.5V14C2 17.2998 2 18.9497 3.02513 19.9749C4.05025 21 5.70017 21 9 21H15C18.2998 21 19.9497 21 20.9749 19.9749C22 18.9497 22 17.2998 22 14Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M2 10C2 10 4.63158 14 12 14C19.3684 14 22 10 22 10',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M12 14V16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBriefcase05' icon.
  static const List<List<dynamic>> briefcase05 = strokeRoundedBriefcase05;

  /// JSON structure for the 'strokeRoundedBriefcase06' icon.
  static const List<List<dynamic>> strokeRoundedBriefcase06 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M8.5 6.5C8.5 5.09554 8.5 4.39331 8.83706 3.88886C8.98298 3.67048 9.17048 3.48298 9.38886 3.33706C9.89331 3 10.5955 3 12 3C13.4045 3 14.1067 3 14.6111 3.33706C14.8295 3.48298 15.017 3.67048 15.1629 3.88886C15.5 4.39331 15.5 5.09554 15.5 6.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M22 14V13.5C22 10.2002 22 8.55025 20.9749 7.52513C19.9497 6.5 18.2998 6.5 15 6.5H9C5.70017 6.5 4.05025 6.5 3.02513 7.52513C2 8.55025 2 10.2002 2 13.5V14C2 17.2998 2 18.9497 3.02513 19.9749C4.05025 21 5.70017 21 9 21H15C18.2998 21 19.9497 21 20.9749 19.9749C22 18.9497 22 17.2998 22 14Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M2 11C2 11 4.63158 15 12 15C19.3684 15 22 11 22 11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M12 12H12.009',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBriefcase06' icon.
  static const List<List<dynamic>> briefcase06 = strokeRoundedBriefcase06;

  /// JSON structure for the 'strokeRoundedBriefcase07' icon.
  static const List<List<dynamic>> strokeRoundedBriefcase07 = [
    [
      'path',
      {
        'key': '0',
        'd': 'M1.99934 12.4999H21.9993',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M7.49934 10.9999V13.9999M16.4993 13.9999V10.9999',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M1.99934 14L1.99935 13.4999C1.99935 10.2 1.99936 8.55012 3.02448 7.525C4.04961 6.49988 5.69952 6.49988 8.99935 6.49988H15.0005C18.2999 6.49988 19.9495 6.49988 20.9746 7.5248C21.9997 8.54971 22 10.1994 22.0005 13.4987L22.0006 13.999C22.0012 17.2994 22.0015 18.9496 20.9763 19.9749C19.9511 21.0003 18.3009 21.0002 15.0005 21.0002L8.99919 21C5.69941 21 4.04953 20.9999 3.02443 19.9748C1.99933 18.9497 1.99934 17.2998 1.99934 14Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd':
            'M8.49934 6.49988C8.49934 5.09542 8.49934 4.39318 8.8364 3.88874C8.98232 3.67036 9.16982 3.48286 9.3882 3.33694C9.89265 2.99988 10.5949 2.99988 11.9993 2.99988C13.4038 2.99988 14.106 2.99988 14.6105 3.33694C14.8289 3.48286 15.0164 3.67036 15.1623 3.88874C15.4993 4.39318 15.4993 5.09542 15.4993 6.49988',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBriefcase07' icon.
  static const List<List<dynamic>> briefcase07 = strokeRoundedBriefcase07;

  /// JSON structure for the 'strokeRoundedBriefcase08' icon.
  static const List<List<dynamic>> strokeRoundedBriefcase08 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M1.99934 14L1.99935 13.4999C1.99935 10.2 1.99936 8.55012 3.02448 7.525C4.04961 6.49988 5.69952 6.49988 8.99935 6.49988H15.0005C18.2999 6.49988 19.9495 6.49988 20.9746 7.5248C21.9997 8.54971 22 10.1994 22.0005 13.4987L22.0006 13.999C22.0012 17.2994 22.0015 18.9496 20.9763 19.9749C19.9511 21.0003 18.3009 21.0002 15.0005 21.0002L8.99919 21C5.69941 21 4.04953 20.9999 3.02443 19.9748C1.99933 18.9497 1.99934 17.2998 1.99934 14Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M8.49934 6.49988C8.49934 5.09542 8.49934 4.39318 8.8364 3.88874C8.98232 3.67036 9.16982 3.48286 9.3882 3.33694C9.89265 2.99988 10.5949 2.99988 11.9993 2.99988C13.4038 2.99988 14.106 2.99988 14.6105 3.33694C14.8289 3.48286 15.0164 3.67036 15.1623 3.88874C15.4993 4.39318 15.4993 5.09542 15.4993 6.49988',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M5.99924 10.4999H17.9992',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBriefcase08' icon.
  static const List<List<dynamic>> briefcase08 = strokeRoundedBriefcase08;

  /// JSON structure for the 'strokeRoundedBriefcase09' icon.
  static const List<List<dynamic>> strokeRoundedBriefcase09 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M1.99934 14L1.99935 13.4999C1.99935 10.2 1.99936 8.55012 3.02448 7.525C4.04961 6.49988 5.69952 6.49988 8.99935 6.49988H15.0005C18.2999 6.49988 19.9495 6.49988 20.9746 7.5248C21.9997 8.54971 22 10.1994 22.0005 13.4987L22.0006 13.999C22.0012 17.2994 22.0015 18.9496 20.9763 19.9749C19.9511 21.0003 18.3009 21.0002 15.0005 21.0002L8.99919 21C5.69941 21 4.04953 20.9999 3.02443 19.9748C1.99933 18.9497 1.99934 17.2998 1.99934 14Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M8.49934 6.49988C8.49934 5.09542 8.49934 4.39318 8.8364 3.88874C8.98232 3.67036 9.16982 3.48286 9.3882 3.33694C9.89265 2.99988 10.5949 2.99988 11.9993 2.99988C13.4038 2.99988 14.106 2.99988 14.6105 3.33694C14.8289 3.48286 15.0164 3.67036 15.1623 3.88874C15.4993 4.39318 15.4993 5.09542 15.4993 6.49988',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M6.99934 6.49988V20.9999M16.9993 6.49988V20.9999',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBriefcase09' icon.
  static const List<List<dynamic>> briefcase09 = strokeRoundedBriefcase09;

  /// JSON structure for the 'strokeRoundedBriefcaseDollar' icon.
  static const List<List<dynamic>> strokeRoundedBriefcaseDollar = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2 14C2 10.4934 2 8.74003 2.90796 7.55992C3.07418 7.34388 3.25989 7.14579 3.46243 6.96849C4.56878 6 6.21252 6 9.5 6H14.5C17.7875 6 19.4312 6 20.5376 6.96849C20.7401 7.14579 20.9258 7.34388 21.092 7.55992C22 8.74003 22 10.4934 22 14C22 17.5066 22 19.26 21.092 20.4401C20.9258 20.6561 20.7401 20.8542 20.5376 21.0315C19.4312 22 17.7875 22 14.5 22H9.5C6.21252 22 4.56878 22 3.46243 21.0315C3.25989 20.8542 3.07418 20.6561 2.90796 20.4401C2 19.26 2 17.5066 2 14Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M16 6C16 4.11438 16 3.17157 15.4142 2.58579C14.8284 2 13.8856 2 12 2C10.1144 2 9.17157 2 8.58579 2.58579C8 3.17157 8 4.11438 8 6',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M12 11C10.8954 11 10 11.6716 10 12.5C10 13.3284 10.8954 14 12 14C13.1046 14 14 14.6716 14 15.5C14 16.3284 13.1046 17 12 17M12 11C12.8708 11 13.6116 11.4174 13.8862 12M12 11V10M12 17C11.1292 17 10.3884 16.5826 10.1138 16M12 17V18',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M6 12H2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '4',
        'd': 'M22 12L18 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBriefcaseDollar' icon.
  static const List<List<dynamic>> briefcaseDollar =
      strokeRoundedBriefcaseDollar;

  /// JSON structure for the 'strokeRoundedBroccoli' icon.
  static const List<List<dynamic>> strokeRoundedBroccoli = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M4.05205 8.46154C1.87672 10.4706 3.25798 14 6.51566 14C8.14654 14 9.52414 13.0186 9.96671 11.6727M5.93747 10.3077C2.32316 8.8909 4.24626 4.36129 7.95209 4.79869C7.95209 3.26929 9.30506 2 10.974 2C12.643 2 13.996 3.02188 13.996 4.55129C14.5306 4.11279 15.2366 3.84615 16.0106 3.84615C17.6795 3.84615 19.0325 5.08598 19.0325 6.61538C19.0325 8.14479 17.6795 9.38462 16.0106 9.38462M18.8605 7.53846C22.3504 8.80845 21.3348 14 17.5215 14C15.5744 14 13.996 12.5041 13.996 10.6588C12.9886 12.1538 11.4777 12.6154 9.96671 11.6923',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M7 14C7.88632 14.4415 9.41287 16.5365 9.5 21C9.51288 21.66 11.2845 22 12 22C12.7155 22 14.4871 21.66 14.5 21C14.5871 16.5365 16.1137 14.4415 17 14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBroccoli' icon.
  static const List<List<dynamic>> broccoli = strokeRoundedBroccoli;

  /// JSON structure for the 'strokeRoundedBrochure' icon.
  static const List<List<dynamic>> strokeRoundedBrochure = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M18.5 17V7C18.5 5.11438 18.5 4.17157 17.9142 3.58579C17.3284 3 16.3856 3 14.5 3H9.5C7.61438 3 6.67157 3 6.08579 3.58579C5.5 4.17157 5.5 5.11438 5.5 7V17C5.5 18.8856 5.5 19.8284 6.08579 20.4142C6.67157 21 7.61438 21 9.5 21H14.5C16.3856 21 17.3284 21 17.9142 20.4142C18.5 19.8284 18.5 18.8856 18.5 17Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18.5 6H19C20.4142 6 21.1213 6 21.5607 6.43934C22 6.87868 22 7.58579 22 9V16C22 17.4142 22 18.1213 21.5607 18.5607C21.1213 19 20.4142 19 19 19H18.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M5.5 6H5C3.58579 6 2.87868 6 2.43934 6.43934C2 6.87868 2 7.58579 2 9V16C2 17.4142 2 18.1213 2.43934 18.5607C2.87868 19 3.58579 19 5 19H5.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M14.5 8L9.5 8M14.5 12L9.5 12M14.5 16H9.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBrochure' icon.
  static const List<List<dynamic>> brochure = strokeRoundedBrochure;

  /// JSON structure for the 'strokeRoundedBrokenBone' icon.
  static const List<List<dynamic>> strokeRoundedBrokenBone = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M6.28272 19.233C6.11917 19.7294 5.81349 20.1328 5.43094 20.4088M5.43094 20.4088C4.87517 20.8099 4.15714 20.9424 3.47692 20.7015C2.32849 20.2948 1.72271 18.978 2.12388 17.7603C2.43203 16.8249 3.24468 16.2201 4.12547 16.1742C4.57361 16.1509 5.04518 15.9411 5.18559 15.5149L6.67298 11L8.00006 13L10.0001 12L8.49208 16.7315C8.36092 17.1431 8.59538 17.575 8.92477 17.8544C9.6212 18.4451 9.92365 19.4585 9.6098 20.4111C9.20863 21.6289 7.95243 22.2863 6.804 21.8797C6.12378 21.6388 5.63394 21.0786 5.43094 20.4088Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18.5436 5.32421C18.9979 5.07331 19.502 4.98221 19.9822 5.03295M19.9822 5.03295C20.68 5.10666 21.3278 5.47972 21.7004 6.09705C22.3294 7.13929 21.936 8.48309 20.8217 9.0985C19.9518 9.57893 18.8997 9.47344 18.1807 8.90821C17.8389 8.63947 17.3636 8.49844 16.9864 8.7147L13.0001 11V9L11.0001 7.98057L15.1148 5.70815C15.5121 5.48872 15.6281 4.97807 15.5636 4.52878C15.4402 3.66842 15.8707 2.77446 16.7212 2.30477C17.8355 1.68936 19.2488 2.03537 19.8779 3.07761C20.2505 3.69494 20.2644 4.41805 19.9822 5.03295Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M7.00006 8L5.00006 8M9.00006 6L9.00006 4',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M13.0001 16L13.0001 18M15.0001 14L17.0001 14',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBrokenBone' icon.
  static const List<List<dynamic>> brokenBone = strokeRoundedBrokenBone;

  /// JSON structure for the 'strokeRoundedBrowser' icon.
  static const List<List<dynamic>> strokeRoundedBrowser = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M2.5 12C2.5 7.52166 2.5 5.28249 3.89124 3.89124C5.28249 2.5 7.52166 2.5 12 2.5C16.4783 2.5 18.7175 2.5 20.1088 3.89124C21.5 5.28249 21.5 7.52166 21.5 12C21.5 16.4783 21.5 18.7175 20.1088 20.1088C18.7175 21.5 16.4783 21.5 12 21.5C7.52166 21.5 5.28249 21.5 3.89124 20.1088C2.5 18.7175 2.5 16.4783 2.5 12Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M2.5 9H21.5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M6.99981 6H7.00879',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '3',
        'd': 'M10.9998 6H11.0088',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBrowser' icon.
  static const List<List<dynamic>> browser = strokeRoundedBrowser;

  /// JSON structure for the 'strokeRoundedBrush' icon.
  static const List<List<dynamic>> strokeRoundedBrush = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M7.49478 13.753C10.5833 10.1644 17.5788 3.15478 20.5387 3.00445C22.3699 2.82906 18.7218 9.32547 10.0785 16.4339M11.4581 10.0449L13.7157 12.3249M3 20.8546C3.70948 18.3472 3.26187 19.5794 3.50407 16.6919C3.63306 16.2644 3.89258 14.9377 5.51358 14.2765C7.35618 13.5249 8.70698 14.6611 9.05612 15.195C10.0847 16.3102 10.2039 17.6952 9.05612 19.2774C7.9083 20.8596 4.50352 21.2527 3 20.8546Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBrush' icon.
  static const List<List<dynamic>> brush = strokeRoundedBrush;

  /// JSON structure for the 'strokeRoundedBubbleChat' icon.
  static const List<List<dynamic>> strokeRoundedBubbleChat = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M22 11.5667C22 16.8499 17.5222 21.1334 12 21.1334C11.3507 21.1343 10.7032 21.0742 10.0654 20.9545C9.60633 20.8682 9.37678 20.8251 9.21653 20.8496C9.05627 20.8741 8.82918 20.9948 8.37499 21.2364C7.09014 21.9197 5.59195 22.161 4.15111 21.893C4.69874 21.2194 5.07275 20.4112 5.23778 19.5448C5.33778 19.0148 5.09 18.5 4.71889 18.1231C3.03333 16.4115 2 14.1051 2 11.5667C2 6.28357 6.47778 2 12 2C17.5222 2 22 6.28357 22 11.5667Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M11.9955 12H12.0045M15.991 12H16M8 12H8.00897',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBubbleChat' icon.
  static const List<List<dynamic>> bubbleChat = strokeRoundedBubbleChat;

  /// JSON structure for the 'strokeRoundedBubbleChatAdd' icon.
  static const List<List<dynamic>> strokeRoundedBubbleChatAdd = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12.5 2.01175C12.3344 2.00395 12.1677 2 12 2C6.47778 2 2 6.28357 2 11.5667C2 14.1051 3.03333 16.4115 4.71889 18.1231C5.09 18.5 5.33778 19.0148 5.23778 19.5448C5.07275 20.4112 4.69874 21.2194 4.15111 21.893C5.59195 22.161 7.09014 21.9197 8.37499 21.2364C8.82918 20.9949 9.05627 20.8741 9.21653 20.8496C9.37678 20.8251 9.60633 20.8682 10.0654 20.9545C10.7032 21.0742 11.3507 21.1343 12 21.1334C17.5222 21.1334 22 16.8499 22 11.5667C22 11.3765 21.9942 11.1875 21.9827 11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M15 5.5H22M18.5 2L18.5 9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M11.9955 12H12.0045M15.991 12H16M8 12H8.00897',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBubbleChatAdd' icon.
  static const List<List<dynamic>> bubbleChatAdd = strokeRoundedBubbleChatAdd;

  /// JSON structure for the 'strokeRoundedBubbleChatBlocked' icon.
  static const List<List<dynamic>> strokeRoundedBubbleChatBlocked = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M18.5 18.8349C16.7519 20.2676 14.4814 21.133 12 21.133C11.3507 21.1338 10.7032 21.0737 10.0654 20.9539C9.60633 20.8676 9.37678 20.8245 9.21653 20.849C9.05627 20.8735 8.82918 20.9943 8.37499 21.236C7.09014 21.9196 5.59195 22.1611 4.15111 21.8929C4.69874 21.219 5.07275 20.4103 5.23778 19.5434C5.33778 19.0132 5.09 18.498 4.71889 18.1209C3.03333 16.4084 2 14.1007 2 11.5609C2 9.0218 3.03313 6.71344 4.71889 5',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M7.5 3.02125C8.85265 2.36798 10.3815 2 12 2C17.5222 2 22 6.28357 22 11.5667C22 13.1665 21.5894 14.6747 20.8635 16',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M2 2L22 22',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBubbleChatBlocked' icon.
  static const List<List<dynamic>> bubbleChatBlocked =
      strokeRoundedBubbleChatBlocked;

  /// JSON structure for the 'strokeRoundedBubbleChatCancel' icon.
  static const List<List<dynamic>> strokeRoundedBubbleChatCancel = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12.5 2.01175C12.3344 2.00395 12.1677 2 12 2C6.47778 2 2 6.28357 2 11.5667C2 14.1051 3.03333 16.4115 4.71889 18.1231C5.09 18.5 5.33778 19.0148 5.23778 19.5448C5.07275 20.4112 4.69874 21.2194 4.15111 21.893C5.59195 22.161 7.09014 21.9197 8.37499 21.2364C8.82918 20.9949 9.05627 20.8741 9.21653 20.8496C9.37678 20.8251 9.60633 20.8682 10.0654 20.9545C10.7032 21.0742 11.3507 21.1343 12 21.1334C17.5222 21.1334 22 16.8499 22 11.5667C22 11.3765 21.9942 11.1875 21.9827 11',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M16 2L19 5M19 5L22 8M19 5L22 2M19 5L16 8',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M11.9955 12H12.0045M15.991 12H16M8 12H8.00897',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBubbleChatCancel' icon.
  static const List<List<dynamic>> bubbleChatCancel =
      strokeRoundedBubbleChatCancel;

  /// JSON structure for the 'strokeRoundedBubbleChatDelay' icon.
  static const List<List<dynamic>> strokeRoundedBubbleChatDelay = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M22 11.5667C22 16.8499 17.5222 21.1334 12 21.1334C11.3507 21.1343 10.7032 21.0742 10.0654 20.9545C9.60633 20.8682 9.37678 20.8251 9.21653 20.8496C9.05627 20.8741 8.82918 20.9949 8.37499 21.2364C7.09014 21.9197 5.59195 22.161 4.15111 21.893C4.69874 21.2194 5.07275 20.4112 5.23778 19.5448C5.33778 19.0148 5.09 18.5 4.71889 18.1231C3.03333 16.4115 2 14.1051 2 11.5667C2 6.28357 6.47778 2 12 2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M18 6L19 5M22 6C22 8.20914 20.2091 10 18 10C15.7909 10 14 8.20914 14 6C14 3.79086 15.7909 2 18 2C20.2091 2 22 3.79086 22 6Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M11.9955 12H12.0045M8 12H8.00897',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBubbleChatDelay' icon.
  static const List<List<dynamic>> bubbleChatDelay =
      strokeRoundedBubbleChatDelay;

  /// JSON structure for the 'strokeRoundedBubbleChatDone' icon.
  static const List<List<dynamic>> strokeRoundedBubbleChatDone = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12 2C6.47778 2 2 6.28357 2 11.5667C2 14.1051 3.03333 16.4115 4.71889 18.1231C5.09 18.5 5.33778 19.0148 5.23778 19.5448C5.07275 20.4112 4.69874 21.2194 4.15111 21.893C5.59195 22.161 7.09014 21.9197 8.37499 21.2364C8.82918 20.9949 9.05627 20.8741 9.21653 20.8496C9.37678 20.8251 9.60633 20.8682 10.0654 20.9545C10.7032 21.0742 11.3507 21.1343 12 21.1334C17.5222 21.1334 22 16.8499 22 11.5667C22 10.6776 21.8732 9.81683 21.6359 9',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M14 6C14 6 15 6 16 8C16 8 19.1765 3 22 2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M11.9955 12H12.0045M15.991 12H16M8 12H8.00897',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBubbleChatDone' icon.
  static const List<List<dynamic>> bubbleChatDone = strokeRoundedBubbleChatDone;

  /// JSON structure for the 'strokeRoundedBubbleChatDownload01' icon.
  static const List<List<dynamic>> strokeRoundedBubbleChatDownload01 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M14.006 2.19142C13.3595 2.0659 12.6903 2 12.005 2C6.48004 2 2 6.28357 2 11.5667C2 14.1051 3.03385 16.4115 4.72026 18.1231C5.09156 18.5 5.33946 19.0148 5.23941 19.5448C5.07429 20.4112 4.7001 21.2194 4.1522 21.893C5.59376 22.161 7.0927 21.9197 8.3782 21.2364C8.83262 20.9949 9.05983 20.8741 9.22017 20.8496C9.3805 20.8251 9.61016 20.8682 10.0695 20.9545C10.7076 21.0742 11.3554 21.1343 12.005 21.1334C17.3782 21.1334 21.763 17.0821 22 12',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M16 7.5C16.4915 8.0057 17.7998 10 18.5 10M21 7.5C20.5085 8.0057 19.2002 10 18.5 10M18.5 10V2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M11.9955 12H12.0045M8 12H8.00897',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBubbleChatDownload01' icon.
  static const List<List<dynamic>> bubbleChatDownload01 =
      strokeRoundedBubbleChatDownload01;

  /// JSON structure for the 'strokeRoundedBubbleChatDownload02' icon.
  static const List<List<dynamic>> strokeRoundedBubbleChatDownload02 = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M22 12C21.763 17.0821 17.3782 21.1334 12.005 21.1334C11.3554 21.1343 10.7076 21.0742 10.0695 20.9545C9.61016 20.8682 9.3805 20.8251 9.22017 20.8496C9.05983 20.8741 8.83262 20.9949 8.3782 21.2364C7.0927 21.9197 5.59376 22.161 4.1522 21.893C4.7001 21.2194 5.07429 20.4112 5.23941 19.5448C5.33946 19.0148 5.09156 18.5 4.72026 18.1231C3.03385 16.4115 2 14.1051 2 11.5667C2 6.28357 6.48004 2 12.005 2C12.5131 2 13.0123 2.03622 13.5 2.10611',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M16 7.5C16.4915 8.0057 17.7998 10 18.5 10M21 7.5C20.5085 8.0057 19.2002 10 18.5 10M18.5 10V2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M11.9955 12H12.0045M8 12H8.00897',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBubbleChatDownload02' icon.
  static const List<List<dynamic>> bubbleChatDownload02 =
      strokeRoundedBubbleChatDownload02;

  /// JSON structure for the 'strokeRoundedBubbleChatEdit' icon.
  static const List<List<dynamic>> strokeRoundedBubbleChatEdit = [
    [
      'path',
      {
        'key': '0',
        'd': 'M11.9955 12H12.0045M8 12H8.00897',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M22 11.5667C22 16.8499 17.5222 21.1334 12 21.1334C11.3507 21.1343 10.7032 21.0742 10.0654 20.9545C9.60633 20.8682 9.37678 20.8251 9.21653 20.8496C9.05627 20.8741 8.82918 20.9949 8.37499 21.2364C7.09014 21.9197 5.59195 22.161 4.15111 21.893C4.69874 21.2194 5.07275 20.4112 5.23778 19.5448C5.33778 19.0148 5.09 18.5 4.71889 18.1231C3.03333 16.4115 2 14.1051 2 11.5667C2 6.28357 6.47778 2 12 2C12.6849 2 13.3538 2.0659 14 2.19142',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M20.8386 2.47645L21.5309 3.16882C22.1167 3.7546 22.1167 4.70435 21.5309 5.29013L17.9035 8.9858C17.6182 9.27115 17.2532 9.46351 16.8565 9.53759L14.6084 10.0256C14.2534 10.1027 13.9373 9.78753 14.0134 9.43236L14.4919 7.19703C14.566 6.80035 14.7583 6.43535 15.0437 6.15L18.7173 2.47645C19.303 1.89066 20.2528 1.89066 20.8386 2.47645Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBubbleChatEdit' icon.
  static const List<List<dynamic>> bubbleChatEdit = strokeRoundedBubbleChatEdit;

  /// JSON structure for the 'strokeRoundedBubbleChatFavourite' icon.
  static const List<List<dynamic>> strokeRoundedBubbleChatFavourite = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M11.5 2C6.21 2.24942 2 6.43482 2 11.5606C2 14.1004 3.03333 16.4082 4.71889 18.1208C5.09 18.4979 5.33778 19.0131 5.23778 19.5433C5.07275 20.4103 4.69874 21.2189 4.15111 21.8929C5.59195 22.1611 7.09014 21.9196 8.37499 21.2359C8.82918 20.9943 9.05627 20.8734 9.21653 20.8489C9.37678 20.8244 9.60633 20.8676 10.0654 20.9538C10.7032 21.0737 11.3507 21.1337 12 21.1329C17.5222 21.1329 22 16.8468 22 11.5606C22 11.3702 21.9942 11.1812 21.9827 10.9935',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M15.015 2.38661C16.0876 1.74692 17.0238 2.00471 17.5863 2.41534C17.8169 2.58371 17.9322 2.66789 18 2.66789C18.0678 2.66789 18.1831 2.58371 18.4137 2.41534C18.9762 2.00471 19.9124 1.74692 20.985 2.38661C22.3928 3.22614 22.7113 5.99577 19.4642 8.33241C18.8457 8.77747 18.5365 9 18 9C17.4635 9 17.1543 8.77747 16.5358 8.33241C13.2887 5.99577 13.6072 3.22614 15.015 2.38661Z',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M11.9955 12H12.0045M15.991 12H16M8 12H8.00897',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBubbleChatFavourite' icon.
  static const List<List<dynamic>> bubbleChatFavourite =
      strokeRoundedBubbleChatFavourite;

  /// JSON structure for the 'strokeRoundedBubbleChatIncome' icon.
  static const List<List<dynamic>> strokeRoundedBubbleChatIncome = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M21.766 9.49265C21.9192 10.1586 22 10.8506 22 11.5606C22 16.8468 17.5222 21.1329 12 21.1329C11.3507 21.1337 10.7032 21.0737 10.0654 20.9538C9.60633 20.8676 9.37678 20.8244 9.21653 20.8489C9.05627 20.8734 8.82918 20.9943 8.37499 21.2359C7.09014 21.9196 5.59195 22.1611 4.15111 21.8929C4.69874 21.2189 5.07275 20.4103 5.23778 19.5433C5.33778 19.0131 5.09 18.4979 4.71889 18.1208C3.03333 16.4082 2 14.1004 2 11.5606C2 6.43482 6.21 2.24942 11.5 2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd':
            'M14 4.5L22 4.5M14 4.5C14 5.20023 15.9943 6.50847 16.5 7M14 4.5C14 3.79977 15.9943 2.49153 16.5 2',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd': 'M11.9955 12H12.0045M15.991 12H16M8 12H8.00897',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
  ];

  /// Alias for 'strokeRoundedBubbleChatIncome' icon.
  static const List<List<dynamic>> bubbleChatIncome =
      strokeRoundedBubbleChatIncome;

  /// JSON structure for the 'strokeRoundedBubbleChatLock' icon.
  static const List<List<dynamic>> strokeRoundedBubbleChatLock = [
    [
      'path',
      {
        'key': '0',
        'd':
            'M12.9999 2.0492C12.671 2.01795 12.3374 2.00195 11.9999 2.00195C6.47772 2.00195 1.99994 6.28552 1.99994 11.5687C1.99994 14.1071 3.03327 16.4135 4.71883 18.1251C5.08994 18.502 5.33772 19.0168 5.23772 19.5468C5.07269 20.4132 4.69868 21.2214 4.15105 21.895C5.59189 22.163 7.09008 21.9217 8.37493 21.2384C8.82912 20.9969 9.05621 20.8761 9.21647 20.8516C9.37672 20.8271 9.60627 20.8702 10.0653 20.9565C10.7031 21.0762 11.3506 21.1363 11.9999 21.1354C16.8299 21.1354 21.0652 17.8585 21.9999 13.502',
        'stroke': 'currentColor',
        'strokeWidth': '1.5',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '1',
        'd': 'M11.9954 12.002H12.0044M7.99994 12.002H8.00891',
        'stroke': 'currentColor',
        'strokeWidth': '2',
        'strokeLinecap': 'round',
        'strokeLinejoin': 'round'
      }
    ],
    [
      'path',
      {
        'key': '2',
        'd':
            'M16.7541 5.16996L16.7541 3.78081C16.7541 3.57562 16.7626 3.36788 16.836 3.17627C17.0314 2