# Security Policy

Ente believes that working with security researchers across the globe is crucial
to keeping our users safe. If you believe you've found a security issue in our
product or service, we encourage you to notify us by email at security@ente.io
or by
[filling out this form](https://github.com/ente-io/ente/security/advisories/new).
We welcome working with you to resolve the issue promptly. Thanks in advance!

## Disclosure Policy

-   Let us know as soon as possible upon discovery of a potential security
    issue, and we'll make every effort to quickly resolve the issue.
-   Provide us with a reasonable amount of time to resolve the issue before any
    disclosure to the public or a third party. We may publicly disclose the
    issue before resolving it if appropriate.
-   Make a good faith effort to avoid privacy violations, destruction of data,
    and interruption or degradation of our service. Only interact with accounts
    you own or with the explicit permission of the account holder.
-   If you would like to encrypt your report, please use the PGP key with long
    ID `E273695C0403F34F74171932DF6DDDE98EBD2394` (available in the public
    keyserver pool).

## In-scope

-   Security issues in any current release of Ente's services. Product downloads
    are available at [https://ente.io](https://ente.io). Source code is
    available at [https://github.com/ente-io](https://github.com/ente-io).

## Exclusions

The following bug classes are out of scope:

-   Bugs that are already reported on any of
    [Ente's issue trackers](https://github.com/ente-io) or that we already know
    of (note that some of our issue tracking is private).
-   Issues in an upstream software dependency (e.g., Flutter, Next.js, etc.)
    that are already reported to the upstream maintainer.
-   Attacks requiring physical access to a user's device.
-   Self-XSS.
-   Issues related to software or protocols not under Ente's control.
-   Vulnerabilities in outdated versions of Ente.
-   Missing security best practices that do not directly lead to a
    vulnerability.
-   Issues that do not have any impact on the general public.

While researching, we'd like to ask you to refrain from:

-   Denial of service
-   Spamming
-   Social engineering (including phishing) of Ente staff or contractors
-   Any physical attempts against Ente property or data centers

Thank you for helping keep Ente and our users safe!
