/*
 * Copyright (c) 2025 Element Creations Ltd.
 * Copyright 2025 New Vector Ltd.
 *
 * SPDX-License-Identifier: AGPL-3.0-only OR LicenseRef-Element-Commercial.
 * Please see LICENSE files in the repository root for full details.
 */

package io.element.android.libraries.featureflag.impl

import dev.zacsweers.metro.AppScope
import dev.zacsweers.metro.ContributesBinding
import io.element.android.libraries.featureflag.api.Feature
import io.element.android.libraries.featureflag.api.FeatureFlags

fun interface FeaturesProvider {
    fun provide(): List<Feature>
}

@ContributesBinding(AppScope::class)
class DefaultFeaturesProvider : FeaturesProvider {
    override fun provide(): List<Feature> = FeatureFlags.entries
}
