/*
 * Copyright 2025 New Vector Ltd.
 *
 * SPDX-License-Identifier: AGPL-3.0-only OR LicenseRef-Element-Commercial
 * Please see LICENSE files in the repository root for full details.
 */

import extension.setupDependencyInjection

plugins {
    id("io.element.android-compose-library")
    id("kotlin-parcelize")
}

android {
    namespace = "io.element.android.libraries.recentemojis.impl"
}

setupDependencyInjection()

dependencies {
    api(projects.libraries.recentemojis.api)
    implementation(projects.libraries.matrix.api)
    implementation(libs.kotlinx.collections.immutable)
    implementation(libs.matrix.emojibase.bindings)

    testImplementation(projects.libraries.recentemojis.test)
    testImplementation(libs.test.junit)
    testImplementation(libs.coroutines.test)
    testImplementation(libs.molecule.runtime)
    testImplementation(libs.test.truth)
    testImplementation(libs.test.turbine)
    testImplementation(projects.libraries.matrix.test)
    testImplementation(projects.tests.testutils)
}
