/*
 * Copyright 2025 New Vector Ltd.
 *
 * SPDX-License-Identifier: AGPL-3.0-only OR LicenseRef-Element-Commercial
 * Please see LICENSE files in the repository root for full details.
 */

package io.element.android.features.startchat.impl

import com.bumble.appyx.core.modality.BuildContext
import com.bumble.appyx.core.node.Node
import dev.zacsweers.metro.AppScope
import dev.zacsweers.metro.ContributesBinding
import io.element.android.features.startchat.api.StartChatEntryPoint
import io.element.android.libraries.architecture.createNode

@ContributesBinding(AppScope::class)
class DefaultStartChatEntryPoint : StartChatEntryPoint {
    override fun createNode(
        parentNode: Node,
        buildContext: BuildContext,
        callback: StartChatEntryPoint.Callback,
    ): Node {
        return parentNode.createNode<StartChatFlowNode>(buildContext, listOf(callback))
    }
}
