/*
 * Copyright 2023, 2024 New Vector Ltd.
 *
 * SPDX-License-Identifier: AGPL-3.0-only OR LicenseRef-Element-Commercial
 * Please see LICENSE files in the repository root for full details.
 */

package io.element.android.features.poll.impl.create

import com.bumble.appyx.core.modality.BuildContext
import com.bumble.appyx.core.node.Node
import dev.zacsweers.metro.AppScope
import dev.zacsweers.metro.ContributesBinding
import io.element.android.features.poll.api.create.CreatePollEntryPoint
import io.element.android.libraries.architecture.createNode

@ContributesBinding(AppScope::class)
class DefaultCreatePollEntryPoint : CreatePollEntryPoint {
    override fun createNode(
        parentNode: Node,
        buildContext: BuildContext,
        params: CreatePollEntryPoint.Params,
    ): Node {
        return parentNode.createNode<CreatePollNode>(
            buildContext = buildContext,
            plugins = listOf(CreatePollNode.Inputs(timelineMode = params.timelineMode, mode = params.mode))
        )
    }
}
