/*
 * Copyright (C) 2018 Tim Cadogan-Cowper.
 *
 * This file is part of Fabularium.
 *
 * Fabularium is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Fabularium; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package com.luxlunae.glk.model.html;

import android.support.annotation.NonNull;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class CharRef {
    @NonNull
    static final Map<String, String> CREFS;
    static final int MAX_CREF_LENGTH = 25;

    static {
        // See https://www.w3.org/TR/html5/syntax.html#named-character-references
        // Note the char refs TADS defined in addition to HTML3.2 are all present
        // in the HTML5 list, which is below, so we don't need to add anything else.
        Map<String, String> map = new HashMap<>();
        map.put("Aacute;", "\u00C1");
        map.put("Aacute", "\u00C1");
        map.put("aacute;", "\u00E1");
        map.put("aacute", "\u00E1");
        map.put("Abreve;", "\u0102");
        map.put("abreve;", "\u0103");
        map.put("ac;", "\u223E");
        map.put("acd;", "\u223F");
        map.put("acE;", "\u223E\u0333");
        map.put("Acirc;", "\u00C2");
        map.put("Acirc", "\u00C2");
        map.put("acirc;", "\u00E2");
        map.put("acirc", "\u00E2");
        map.put("acute;", "\u00B4");
        map.put("acute", "\u00B4");
        map.put("Acy;", "\u0410");
        map.put("acy;", "\u0430");
        map.put("AElig;", "\u00C6");
        map.put("AElig", "\u00C6");
        map.put("aelig;", "\u00E6");
        map.put("aelig", "\u00E6");
        map.put("af;", "\u2061");
        map.put("Afr;", "\uD504");
        map.put("afr;", "\uD51E");
        map.put("Agrave;", "\u00C0");
        map.put("Agrave", "\u00C0");
        map.put("agrave;", "\u00E0");
        map.put("agrave", "\u00E0");
        map.put("alefsym;", "\u2135");
        map.put("aleph;", "\u2135");
        map.put("Alpha;", "\u0391");
        map.put("alpha;", "\u03B1");
        map.put("Amacr;", "\u0100");
        map.put("amacr;", "\u0101");
        map.put("amalg;", "\u2A3F");
        map.put("AMP;", "\u0026");
        map.put("AMP", "\u0026");
        map.put("amp;", "\u0026");
        map.put("amp", "\u0026");
        map.put("And;", "\u2A53");
        map.put("and;", "\u2227");
        map.put("andand;", "\u2A55");
        map.put("andd;", "\u2A5C");
        map.put("andslope;", "\u2A58");
        map.put("andv;", "\u2A5A");
        map.put("ang;", "\u2220");
        map.put("ange;", "\u29A4");
        map.put("angle;", "\u2220");
        map.put("angmsd;", "\u2221");
        map.put("angmsdaa;", "\u29A8");
        map.put("angmsdab;", "\u29A9");
        map.put("angmsdac;", "\u29AA");
        map.put("angmsdad;", "\u29AB");
        map.put("angmsdae;", "\u29AC");
        map.put("angmsdaf;", "\u29AD");
        map.put("angmsdag;", "\u29AE");
        map.put("angmsdah;", "\u29AF");
        map.put("angrt;", "\u221F");
        map.put("angrtvb;", "\u22BE");
        map.put("angrtvbd;", "\u299D");
        map.put("angsph;", "\u2222");
        map.put("angst;", "\u00C5");
        map.put("angzarr;", "\u237C");
        map.put("Aogon;", "\u0104");
        map.put("aogon;", "\u0105");
        map.put("Aopf;", "\uD538");
        map.put("aopf;", "\uD552");
        map.put("ap;", "\u2248");
        map.put("apacir;", "\u2A6F");
        map.put("apE;", "\u2A70");
        map.put("ape;", "\u224A");
        map.put("apid;", "\u224B");
        map.put("apos;", "\u0027");
        map.put("ApplyFunction;", "\u2061");
        map.put("approx;", "\u2248");
        map.put("approxeq;", "\u224A");
        map.put("Aring;", "\u00C5");
        map.put("Aring", "\u00C5");
        map.put("aring;", "\u00E5");
        map.put("aring", "\u00E5");
        map.put("Ascr;", "\uD49C");
        map.put("ascr;", "\uD4B6");
        map.put("Assign;", "\u2254");
        map.put("ast;", "\u002A");
        map.put("asymp;", "\u2248");
        map.put("asympeq;", "\u224D");
        map.put("Atilde;", "\u00C3");
        map.put("Atilde", "\u00C3");
        map.put("atilde;", "\u00E3");
        map.put("atilde", "\u00E3");
        map.put("Auml;", "\u00C4");
        map.put("Auml", "\u00C4");
        map.put("auml;", "\u00E4");
        map.put("auml", "\u00E4");
        map.put("awconint;", "\u2233");
        map.put("awint;", "\u2A11");
        map.put("backcong;", "\u224C");
        map.put("backepsilon;", "\u03F6");
        map.put("backprime;", "\u2035");
        map.put("backsim;", "\u223D");
        map.put("backsimeq;", "\u22CD");
        map.put("Backslash;", "\u2216");
        map.put("Barv;", "\u2AE7");
        map.put("barvee;", "\u22BD");
        map.put("Barwed;", "\u2306");
        map.put("barwed;", "\u2305");
        map.put("barwedge;", "\u2305");
        map.put("bbrk;", "\u23B5");
        map.put("bbrktbrk;", "\u23B6");
        map.put("bcong;", "\u224C");
        map.put("Bcy;", "\u0411");
        map.put("bcy;", "\u0431");
        map.put("bdquo;", "\u201E");
        map.put("becaus;", "\u2235");
        map.put("Because;", "\u2235");
        map.put("because;", "\u2235");
        map.put("bemptyv;", "\u29B0");
        map.put("bepsi;", "\u03F6");
        map.put("bernou;", "\u212C");
        map.put("Bernoullis;", "\u212C");
        map.put("Beta;", "\u0392");
        map.put("beta;", "\u03B2");
        map.put("beth;", "\u2136");
        map.put("between;", "\u226C");
        map.put("Bfr;", "\uD505");
        map.put("bfr;", "\uD51F");
        map.put("bigcap;", "\u22C2");
        map.put("bigcirc;", "\u25EF");
        map.put("bigcup;", "\u22C3");
        map.put("bigodot;", "\u2A00");
        map.put("bigoplus;", "\u2A01");
        map.put("bigotimes;", "\u2A02");
        map.put("bigsqcup;", "\u2A06");
        map.put("bigstar;", "\u2605");
        map.put("bigtriangledown;", "\u25BD");
        map.put("bigtriangleup;", "\u25B3");
        map.put("biguplus;", "\u2A04");
        map.put("bigvee;", "\u22C1");
        map.put("bigwedge;", "\u22C0");
        map.put("bkarow;", "\u290D");
        map.put("blacklozenge;", "\u29EB");
        map.put("blacksquare;", "\u25AA");
        map.put("blacktriangle;", "\u25B4");
        map.put("blacktriangledown;", "\u25BE");
        map.put("blacktriangleleft;", "\u25C2");
        map.put("blacktriangleright;", "\u25B8");
        map.put("blank;", "\u2423");
        map.put("blk12;", "\u2592");
        map.put("blk14;", "\u2591");
        map.put("blk34;", "\u2593");
        map.put("block;", "\u2588");
        map.put("bne;", "\u003D\u20E5");
        map.put("bnequiv;", "\u2261\u20E5");
        map.put("bNot;", "\u2AED");
        map.put("bnot;", "\u2310");
        map.put("Bopf;", "\uD539");
        map.put("bopf;", "\uD553");
        map.put("bot;", "\u22A5");
        map.put("bottom;", "\u22A5");
        map.put("bowtie;", "\u22C8");
        map.put("boxbox;", "\u29C9");
        map.put("boxDL;", "\u2557");
        map.put("boxDl;", "\u2556");
        map.put("boxdL;", "\u2555");
        map.put("boxdl;", "\u2510");
        map.put("boxDR;", "\u2554");
        map.put("boxDr;", "\u2553");
        map.put("boxdR;", "\u2552");
        map.put("boxdr;", "\u250C");
        map.put("boxH;", "\u2550");
        map.put("boxh;", "\u2500");
        map.put("boxHD;", "\u2566");
        map.put("boxHd;", "\u2564");
        map.put("boxhD;", "\u2565");
        map.put("boxhd;", "\u252C");
        map.put("boxHU;", "\u2569");
        map.put("boxHu;", "\u2567");
        map.put("boxhU;", "\u2568");
        map.put("boxhu;", "\u2534");
        map.put("boxminus;", "\u229F");
        map.put("boxplus;", "\u229E");
        map.put("boxtimes;", "\u22A0");
        map.put("boxUL;", "\u255D");
        map.put("boxUl;", "\u255C");
        map.put("boxuL;", "\u255B");
        map.put("boxul;", "\u2518");
        map.put("boxUR;", "\u255A");
        map.put("boxUr;", "\u2559");
        map.put("boxuR;", "\u2558");
        map.put("boxur;", "\u2514");
        map.put("boxV;", "\u2551");
        map.put("boxv;", "\u2502");
        map.put("boxVH;", "\u256C");
        map.put("boxVh;", "\u256B");
        map.put("boxvH;", "\u256A");
        map.put("boxvh;", "\u253C");
        map.put("boxVL;", "\u2563");
        map.put("boxVl;", "\u2562");
        map.put("boxvL;", "\u2561");
        map.put("boxvl;", "\u2524");
        map.put("boxVR;", "\u2560");
        map.put("boxVr;", "\u255F");
        map.put("boxvR;", "\u255E");
        map.put("boxvr;", "\u251C");
        map.put("bprime;", "\u2035");
        map.put("Breve;", "\u02D8");
        map.put("breve;", "\u02D8");
        map.put("brvbar;", "\u00A6");
        map.put("Bscr;", "\u212C");
        map.put("bscr;", "\uD4B7");
        map.put("bsemi;", "\u204F");
        map.put("bsim;", "\u223D");
        map.put("bsime;", "\u22CD");
        map.put("bsol;", "\\u005C");
        map.put("bsolb;", "\u29C5");
        map.put("bsolhsub;", "\u27C8");
        map.put("bull;", "\u2022");
        map.put("bullet;", "\u2022");
        map.put("bump;", "\u224E");
        map.put("bumpE;", "\u2AAE");
        map.put("bumpe;", "\u224F");
        map.put("Bumpeq;", "\u224E");
        map.put("bumpeq;", "\u224F");
        map.put("Cacute;", "\u0106");
        map.put("cacute;", "\u0107");
        map.put("Cap;", "\u22D2");
        map.put("cap;", "\u2229");
        map.put("capand;", "\u2A44");
        map.put("capbrcup;", "\u2A49");
        map.put("capcap;", "\u2A4B");
        map.put("capcup;", "\u2A47");
        map.put("capdot;", "\u2A40");
        map.put("CapitalDifferentialD;", "\u2145");
        map.put("caps;", "\u2229\uFE00");
        map.put("caret;", "\u2041");
        map.put("caron;", "\u02C7");
        map.put("Cayleys;", "\u212D");
        map.put("ccaps;", "\u2A4D");
        map.put("Ccaron;", "\u010C");
        map.put("ccaron;", "\u010D");
        map.put("Ccedil;", "\u00C7");
        map.put("Ccedil", "\u00C7");
        map.put("ccedil;", "\u00E7");
        map.put("ccedil", "\u00E7");
        map.put("Ccirc;", "\u0108");
        map.put("ccirc;", "\u0109");
        map.put("Cconint;", "\u2230");
        map.put("ccups;", "\u2A4C");
        map.put("ccupssm;", "\u2A50");
        map.put("Cdot;", "\u010A");
        map.put("cdot;", "\u010B");
        map.put("cedil;", "\u00B8");
        map.put("cedil", "\u00B8");
        map.put("Cedilla;", "\u00B8");
        map.put("cemptyv;", "\u29B2");
        map.put("cent;", "\u00A2");
        map.put("cent", "\u00A2");
        map.put("CenterDot;", "\u00B7");
        map.put("centerdot;", "\u00B7");
        map.put("Cfr;", "\u212D");
        map.put("cfr;", "\uD520");
        map.put("CHcy;", "\u0427");
        map.put("chcy;", "\u0447");
        map.put("check;", "\u2713");
        map.put("checkmark;", "\u2713");
        map.put("Chi;", "\u03A7");
        map.put("chi;", "\u03C7");
        map.put("cir;", "\u25CB");
        map.put("circ;", "\u02C6");
        map.put("circeq;", "\u2257");
        map.put("circlearrowleft;", "\u21BA");
        map.put("circlearrowright;", "\u21BB");
        map.put("circledast;", "\u229B");
        map.put("circledcirc;", "\u229A");
        map.put("circleddash;", "\u229D");
        map.put("CircleDot;", "\u2299");
        map.put("circledR;", "\u00AE");
        map.put("circledS;", "\u24C8");
        map.put("CircleMinus;", "\u2296");
        map.put("CirclePlus;", "\u2295");
        map.put("CircleTimes;", "\u2297");
        map.put("cirE;", "\u29C3");
        map.put("cire;", "\u2257");
        map.put("cirfnint;", "\u2A10");
        map.put("cirmid;", "\u2AEF");
        map.put("cirscir;", "\u29C2");
        map.put("ClockwiseContourIntegral;", "\u2232");
        map.put("CloseCurlyDoubleQuote;", "\u201D");
        map.put("CloseCurlyQuote;", "\u2019");
        map.put("clubs;", "\u2663");
        map.put("clubsuit;", "\u2663");
        map.put("Colon;", "\u2237");
        map.put("colon;", "\u003A");
        map.put("Colone;", "\u2A74");
        map.put("colone;", "\u2254");
        map.put("coloneq;", "\u2254");
        map.put("comma;", "\u002C");
        map.put("commat;", "\u0040");
        map.put("comp;", "\u2201");
        map.put("compfn;", "\u2218");
        map.put("complement;", "\u2201");
        map.put("complexes;", "\u2102");
        map.put("cong;", "\u2245");
        map.put("congdot;", "\u2A6D");
        map.put("Congruent;", "\u2261");
        map.put("Conint;", "\u222F");
        map.put("conint;", "\u222E");
        map.put("ContourIntegral;", "\u222E");
        map.put("Copf;", "\u2102");
        map.put("copf;", "\uD554");
        map.put("coprod;", "\u2210");
        map.put("Coproduct;", "\u2210");
        map.put("COPY;", "\u00A9");
        map.put("COPY", "\u00A9");
        map.put("copy;", "\u00A9");
        map.put("copy", "\u00A9");
        map.put("copysr;", "\u2117");
        map.put("CounterClockwiseContourIntegral;", "\u2233");
        map.put("crarr;", "\u21B5");
        map.put("Cross;", "\u2A2F");
        map.put("cross;", "\u2717");
        map.put("Cscr;", "\uD49E");
        map.put("cscr;", "\uD4B8");
        map.put("csub;", "\u2ACF");
        map.put("csube;", "\u2AD1");
        map.put("csup;", "\u2AD0");
        map.put("csupe;", "\u2AD2");
        map.put("ctdot;", "\u22EF");
        map.put("cudarrl;", "\u2938");
        map.put("cudarrr;", "\u2935");
        map.put("cuepr;", "\u22DE");
        map.put("cuesc;", "\u22DF");
        map.put("cularr;", "\u21B6");
        map.put("cularrp;", "\u293D");
        map.put("Cup;", "\u22D3");
        map.put("cup;", "\u222A");
        map.put("cupbrcap;", "\u2A48");
        map.put("CupCap;", "\u224D");
        map.put("cupcap;", "\u2A46");
        map.put("cupcup;", "\u2A4A");
        map.put("cupdot;", "\u228D");
        map.put("cupor;", "\u2A45");
        map.put("cups;", "\u222A\uFE00");
        map.put("curarr;", "\u21B7");
        map.put("curarrm;", "\u293C");
        map.put("curlyeqprec;", "\u22DE");
        map.put("curlyeqsucc;", "\u22DF");
        map.put("curlyvee;", "\u22CE");
        map.put("curlywedge;", "\u22CF");
        map.put("curren;", "\u00A4");
        map.put("curren", "\u00A4");
        map.put("curvearrowleft;", "\u21B6");
        map.put("curvearrowright;", "\u21B7");
        map.put("cuvee;", "\u22CE");
        map.put("cuwed;", "\u22CF");
        map.put("cwconint;", "\u2232");
        map.put("cwint;", "\u2231");
        map.put("cylcty;", "\u232D");
        map.put("Dagger;", "\u2021");
        map.put("dagger;", "\u2020");
        map.put("daleth;", "\u2138");
        map.put("Darr;", "\u21A1");
        map.put("dArr;", "\u21D3");
        map.put("darr;", "\u2193");
        map.put("dash;", "\u2010");
        map.put("Dashv;", "\u2AE4");
        map.put("dashv;", "\u22A3");
        map.put("dbkarow;", "\u290F");
        map.put("dblac;", "\u02DD");
        map.put("Dcaron;", "\u010E");
        map.put("dcaron;", "\u010F");
        map.put("Dcy;", "\u0414");
        map.put("dcy;", "\u0434");
        map.put("DD;", "\u2145");
        map.put("dd;", "\u2146");
        map.put("ddagger;", "\u2021");
        map.put("ddarr;", "\u21CA");
        map.put("DDotrahd;", "\u2911");
        map.put("ddotseq;", "\u2A77");
        map.put("deg;", "\u00B0");
        map.put("deg", "\u00B0");
        map.put("Del;", "\u2207");
        map.put("Delta;", "\u0394");
        map.put("delta;", "\u03B4");
        map.put("demptyv;", "\u29B1");
        map.put("dfisht;", "\u297F");
        map.put("Dfr;", "\uD507");
        map.put("dfr;", "\uD521");
        map.put("dHar;", "\u2965");
        map.put("dharl;", "\u21C3");
        map.put("dharr;", "\u21C2");
        map.put("DiacriticalAcute;", "\u00B4");
        map.put("DiacriticalDot;", "\u02D9");
        map.put("DiacriticalDoubleAcute;", "\u02DD");
        map.put("DiacriticalGrave;", "\u0060");
        map.put("DiacriticalTilde;", "\u02DC");
        map.put("diam;", "\u22C4");
        map.put("Diamond;", "\u22C4");
        map.put("diamond;", "\u22C4");
        map.put("diamondsuit;", "\u2666");
        map.put("diams;", "\u2666");
        map.put("die;", "\u00A8");
        map.put("DifferentialD;", "\u2146");
        map.put("digamma;", "\u03DD");
        map.put("disin;", "\u22F2");
        map.put("div;", "\u00F7");
        map.put("divide;", "\u00F7");
        map.put("divide", "\u00F7");
        map.put("divideontimes;", "\u22C7");
        map.put("divonx;", "\u22C7");
        map.put("DJcy;", "\u0402");
        map.put("djcy;", "\u0452");
        map.put("dlcorn;", "\u231E");
        map.put("dlcrop;", "\u230D");
        map.put("dollar;", "\u0024");
        map.put("Dopf;", "\uD53B");
        map.put("dopf;", "\uD555");
        map.put("Dot;", "\u00A8");
        map.put("dot;", "\u02D9");
        map.put("DotDot;", "\u20DC");
        map.put("doteq;", "\u2250");
        map.put("doteqdot;", "\u2251");
        map.put("DotEqual;", "\u2250");
        map.put("dotminus;", "\u2238");
        map.put("dotplus;", "\u2214");
        map.put("dotsquare;", "\u22A1");
        map.put("doublebarwedge;", "\u2306");
        map.put("DoubleContourIntegral;", "\u222F");
        map.put("DoubleDot;", "\u00A8");
        map.put("DoubleDownArrow;", "\u21D3");
        map.put("DoubleLeftArrow;", "\u21D0");
        map.put("DoubleLeftRightArrow;", "\u21D4");
        map.put("DoubleLeftTee;", "\u2AE4");
        map.put("DoubleLongLeftArrow;", "\u27F8");
        map.put("DoubleLongLeftRightArrow;", "\u27FA");
        map.put("DoubleLongRightArrow;", "\u27F9");
        map.put("DoubleRightArrow;", "\u21D2");
        map.put("DoubleRightTee;", "\u22A8");
        map.put("DoubleUpArrow;", "\u21D1");
        map.put("DoubleUpDownArrow;", "\u21D5");
        map.put("DoubleVerticalBar;", "\u2225");
        map.put("DownArrow;", "\u2193");
        map.put("Downarrow;", "\u21D3");
        map.put("downarrow;", "\u2193");
        map.put("DownArrowBar;", "\u2913");
        map.put("DownArrowUpArrow;", "\u21F5");
        map.put("DownBreve;", "\u0311");
        map.put("downdownarrows;", "\u21CA");
        map.put("downharpoonleft;", "\u21C3");
        map.put("downharpoonright;", "\u21C2");
        map.put("DownLeftRightVector;", "\u2950");
        map.put("DownLeftTeeVector;", "\u295E");
        map.put("DownLeftVector;", "\u21BD");
        map.put("DownLeftVectorBar;", "\u2956");
        map.put("DownRightTeeVector;", "\u295F");
        map.put("DownRightVector;", "\u21C1");
        map.put("DownRightVectorBar;", "\u2957");
        map.put("DownTee;", "\u22A4");
        map.put("DownTeeArrow;", "\u21A7");
        map.put("drbkarow;", "\u2910");
        map.put("drcorn;", "\u231F");
        map.put("drcrop;", "\u230C");
        map.put("Dscr;", "\uD49F");
        map.put("dscr;", "\uD4B9");
        map.put("DScy;", "\u0405");
        map.put("dscy;", "\u0455");
        map.put("dsol;", "\u29F6");
        map.put("Dstrok;", "\u0110");
        map.put("dstrok;", "\u0111");
        map.put("dtdot;", "\u22F1");
        map.put("dtri;", "\u25BF");
        map.put("dtrif;", "\u25BE");
        map.put("duarr;", "\u21F5");
        map.put("duhar;", "\u296F");
        map.put("dwangle;", "\u29A6");
        map.put("DZcy;", "\u040F");
        map.put("dzcy;", "\u045F");
        map.put("dzigrarr;", "\u27FF");
        map.put("Eacute;", "\u00C9");
        map.put("Eacute", "\u00C9");
        map.put("eacute;", "\u00E9");
        map.put("eacute", "\u00E9");
        map.put("easter;", "\u2A6E");
        map.put("Ecaron;", "\u011A");
        map.put("ecaron;", "\u011B");
        map.put("ecir;", "\u2256");
        map.put("Ecirc;", "\u00CA");
        map.put("Ecirc", "\u00CA");
        map.put("ecirc;", "\u00EA");
        map.put("ecirc", "\u00EA");
        map.put("ecolon;", "\u2255");
        map.put("Ecy;", "\u042D");
        map.put("ecy;", "\u044D");
        map.put("eDDot;", "\u2A77");
        map.put("Edot;", "\u0116");
        map.put("eDot;", "\u2251");
        map.put("edot;", "\u0117");
        map.put("ee;", "\u2147");
        map.put("efDot;", "\u2252");
        map.put("Efr;", "\uD508");
        map.put("efr;", "\uD522");
        map.put("eg;", "\u2A9A");
        map.put("Egrave;", "\u00C8");
        map.put("Egrave", "\u00C8");
        map.put("egrave;", "\u00E8");
        map.put("egrave", "\u00E8");
        map.put("egs;", "\u2A96");
        map.put("egsdot;", "\u2A98");
        map.put("el;", "\u2A99");
        map.put("Element;", "\u2208");
        map.put("elinters;", "\u23E7");
        map.put("ell;", "\u2113");
        map.put("els;", "\u2A95");
        map.put("elsdot;", "\u2A97");
        map.put("Emacr;", "\u0112");
        map.put("emacr;", "\u0113");
        map.put("empty;", "\u2205");
        map.put("emptyset;", "\u2205");
        map.put("EmptySmallSquare;", "\u25FB");
        map.put("emptyv;", "\u2205");
        map.put("EmptyVerySmallSquare;", "\u25AB");
        map.put("emsp;", "\u2003");
        map.put("emsp13;", "\u2004");
        map.put("emsp14;", "\u2005");
        map.put("ENG;", "\u014A");
        map.put("eng;", "\u014B");
        map.put("ensp;", "\u2002");
        map.put("Eogon;", "\u0118");
        map.put("eogon;", "\u0119");
        map.put("Eopf;", "\uD53C");
        map.put("eopf;", "\uD556");
        map.put("epar;", "\u22D5");
        map.put("eparsl;", "\u29E3");
        map.put("eplus;", "\u2A71");
        map.put("epsi;", "\u03B5");
        map.put("Epsilon;", "\u0395");
        map.put("epsilon;", "\u03B5");
        map.put("epsiv;", "\u03F5");
        map.put("eqcirc;", "\u2256");
        map.put("eqcolon;", "\u2255");
        map.put("eqsim;", "\u2242");
        map.put("eqslantgtr;", "\u2A96");
        map.put("eqslantless;", "\u2A95");
        map.put("Equal;", "\u2A75");
        map.put("equals;", "\u003D");
        map.put("EqualTilde;", "\u2242");
        map.put("equest;", "\u225F");
        map.put("Equilibrium;", "\u21CC");
        map.put("equiv;", "\u2261");
        map.put("equivDD;", "\u2A78");
        map.put("eqvparsl;", "\u29E5");
        map.put("erarr;", "\u2971");
        map.put("erDot;", "\u2253");
        map.put("Escr;", "\u2130");
        map.put("escr;", "\u212F");
        map.put("esdot;", "\u2250");
        map.put("Esim;", "\u2A73");
        map.put("esim;", "\u2242");
        map.put("Eta;", "\u0397");
        map.put("eta;", "\u03B7");
        map.put("ETH;", "\u00D0");
        map.put("ETH", "\u00D0");
        map.put("eth;", "\u00F0");
        map.put("eth", "\u00F0");
        map.put("Euml;", "\u00CB");
        map.put("Euml", "\u00CB");
        map.put("euml;", "\u00EB");
        map.put("euml", "\u00EB");
        map.put("euro;", "\u20AC");
        map.put("excl;", "\u0021");
        map.put("exist;", "\u2203");
        map.put("Exists;", "\u2203");
        map.put("expectation;", "\u2130");
        map.put("ExponentialE;", "\u2147");
        map.put("exponentiale;", "\u2147");
        map.put("fallingdotseq;", "\u2252");
        map.put("Fcy;", "\u0424");
        map.put("fcy;", "\u0444");
        map.put("female;", "\u2640");
        map.put("ffilig;", "\uFB03");
        map.put("fflig;", "\uFB00");
        map.put("ffllig;", "\uFB04");
        map.put("Ffr;", "\uD509");
        map.put("ffr;", "\uD523");
        map.put("filig;", "\uFB01");
        map.put("FilledSmallSquare;", "\u25FC");
        map.put("FilledVerySmallSquare;", "\u25AA");
        map.put("fjlig;", "\u0066\u006A");
        map.put("flat;", "\u266D");
        map.put("fllig;", "\uFB02");
        map.put("fltns;", "\u25B1");
        map.put("fnof;", "\u0192");
        map.put("Fopf;", "\uD53D");
        map.put("fopf;", "\uD557");
        map.put("ForAll;", "\u2200");
        map.put("forall;", "\u2200");
        map.put("fork;", "\u22D4");
        map.put("forkv;", "\u2AD9");
        map.put("Fouriertrf;", "\u2131");
        map.put("fpartint;", "\u2A0D");
        map.put("frac12;", "\u00BD");
        map.put("frac12", "\u00BD");
        map.put("frac13;", "\u2153");
        map.put("frac14;", "\u00BC");
        map.put("frac14", "\u00BC");
        map.put("frac15;", "\u2155");
        map.put("frac16;", "\u2159");
        map.put("frac18;", "\u215B");
        map.put("frac23;", "\u2154");
        map.put("frac25;", "\u2156");
        map.put("frac34;", "\u00BE");
        map.put("frac34", "\u00BE");
        map.put("frac35;", "\u2157");
        map.put("frac38;", "\u215C");
        map.put("frac45;", "\u2158");
        map.put("frac56;", "\u215A");
        map.put("frac58;", "\u215D");
        map.put("frac78;", "\u215E");
        map.put("frasl;", "\u2044");
        map.put("frown;", "\u2322");
        map.put("Fscr;", "\u2131");
        map.put("fscr;", "\uD4BB");
        map.put("gacute;", "\u01F5");
        map.put("Gamma;", "\u0393");
        map.put("gamma;", "\u03B3");
        map.put("Gammad;", "\u03DC");
        map.put("gammad;", "\u03DD");
        map.put("gap;", "\u2A86");
        map.put("Gbreve;", "\u011E");
        map.put("gbreve;", "\u011F");
        map.put("Gcedil;", "\u0122");
        map.put("Gcirc;", "\u011C");
        map.put("gcirc;", "\u011D");
        map.put("Gcy;", "\u0413");
        map.put("gcy;", "\u0433");
        map.put("Gdot;", "\u0120");
        map.put("gdot;", "\u0121");
        map.put("gE;", "\u2267");
        map.put("ge;", "\u2265");
        map.put("gEl;", "\u2A8C");
        map.put("gel;", "\u22DB");
        map.put("geq;", "\u2265");
        map.put("geqq;", "\u2267");
        map.put("geqslant;", "\u2A7E");
        map.put("ges;", "\u2A7E");
        map.put("gescc;", "\u2AA9");
        map.put("gesdot;", "\u2A80");
        map.put("gesdoto;", "\u2A82");
        map.put("gesdotol;", "\u2A84");
        map.put("gesl;", "\u22DB\uFE00");
        map.put("gesles;", "\u2A94");
        map.put("Gfr;", "\uD50A");
        map.put("gfr;", "\uD524");
        map.put("Gg;", "\u22D9");
        map.put("gg;", "\u226B");
        map.put("ggg;", "\u22D9");
        map.put("gimel;", "\u2137");
        map.put("GJcy;", "\u0403");
        map.put("gjcy;", "\u0453");
        map.put("gl;", "\u2277");
        map.put("gla;", "\u2AA5");
        map.put("glE;", "\u2A92");
        map.put("glj;", "\u2AA4");
        map.put("gnap;", "\u2A8A");
        map.put("gnapprox;", "\u2A8A");
        map.put("gnE;", "\u2269");
        map.put("gne;", "\u2A88");
        map.put("gneq;", "\u2A88");
        map.put("gneqq;", "\u2269");
        map.put("gnsim;", "\u22E7");
        map.put("Gopf;", "\uD53E");
        map.put("gopf;", "\uD558");
        map.put("grave;", "\u0060");
        map.put("GreaterEqual;", "\u2265");
        map.put("GreaterEqualLess;", "\u22DB");
        map.put("GreaterFullEqual;", "\u2267");
        map.put("GreaterGreater;", "\u2AA2");
        map.put("GreaterLess;", "\u2277");
        map.put("GreaterSlantEqual;", "\u2A7E");
        map.put("GreaterTilde;", "\u2273");
        map.put("Gscr;", "\uD4A2");
        map.put("gscr;", "\u210A");
        map.put("gsim;", "\u2273");
        map.put("gsime;", "\u2A8E");
        map.put("gsiml;", "\u2A90");
        map.put("GT;", "\u003E");
        map.put("GT", "\u003E");
        map.put("Gt;", "\u226B");
        map.put("gt;", "\u003E");
        map.put("gt", "\u003E");
        map.put("gtcc;", "\u2AA7");
        map.put("gtcir;", "\u2A7A");
        map.put("gtdot;", "\u22D7");
        map.put("gtlPar;", "\u2995");
        map.put("gtquest;", "\u2A7C");
        map.put("gtrapprox;", "\u2A86");
        map.put("gtrarr;", "\u2978");
        map.put("gtrdot;", "\u22D7");
        map.put("gtreqless;", "\u22DB");
        map.put("gtreqqless;", "\u2A8C");
        map.put("gtrless;", "\u2277");
        map.put("gtrsim;", "\u2273");
        map.put("gvertneqq;", "\u2269\uFE00");
        map.put("gvnE;", "\u2269\uFE00");
        map.put("Hacek;", "\u02C7");
        map.put("hairsp;", "\u200A");
        map.put("half;", "\u00BD");
        map.put("hamilt;", "\u210B");
        map.put("HARDcy;", "\u042A");
        map.put("hardcy;", "\u044A");
        map.put("hArr;", "\u21D4");
        map.put("harr;", "\u2194");
        map.put("harrcir;", "\u2948");
        map.put("harrw;", "\u21AD");
        map.put("Hat;", "\u005E");
        map.put("hbar;", "\u210F");
        map.put("Hcirc;", "\u0124");
        map.put("hcirc;", "\u0125");
        map.put("hearts;", "\u2665");
        map.put("heartsuit;", "\u2665");
        map.put("hellip;", "\u2026");
        map.put("hercon;", "\u22B9");
        map.put("Hfr;", "\u210C");
        map.put("hfr;", "\uD525");
        map.put("HilbertSpace;", "\u210B");
        map.put("hksearow;", "\u2925");
        map.put("hkswarow;", "\u2926");
        map.put("hoarr;", "\u21FF");
        map.put("homtht;", "\u223B");
        map.put("hookleftarrow;", "\u21A9");
        map.put("hookrightarrow;", "\u21AA");
        map.put("Hopf;", "\u210D");
        map.put("hopf;", "\uD559");
        map.put("horbar;", "\u2015");
        map.put("HorizontalLine;", "\u2500");
        map.put("Hscr;", "\u210B");
        map.put("hscr;", "\uD4BD");
        map.put("hslash;", "\u210F");
        map.put("Hstrok;", "\u0126");
        map.put("hstrok;", "\u0127");
        map.put("HumpDownHump;", "\u224E");
        map.put("HumpEqual;", "\u224F");
        map.put("hybull;", "\u2043");
        map.put("hyphen;", "\u2010");
        map.put("Iacute;", "\u00CD");
        map.put("Iacute", "\u00CD");
        map.put("iacute;", "\u00ED");
        map.put("iacute", "\u00ED");
        map.put("ic;", "\u2063");
        map.put("Icirc;", "\u00CE");
        map.put("Icirc", "\u00CE");
        map.put("icirc;", "\u00EE");
        map.put("icirc", "\u00EE");
        map.put("Icy;", "\u0418");
        map.put("icy;", "\u0438");
        map.put("Idot;", "\u0130");
        map.put("IEcy;", "\u0415");
        map.put("iecy;", "\u0435");
        map.put("iexcl;", "\u00A1");
        map.put("iexcl", "\u00A1");
        map.put("iff;", "\u21D4");
        map.put("Ifr;", "\u2111");
        map.put("ifr;", "\uD526");
        map.put("Igrave;", "\u00CC");
        map.put("Igrave", "\u00CC");
        map.put("igrave;", "\u00EC");
        map.put("igrave", "\u00EC");
        map.put("ii;", "\u2148");
        map.put("iiiint;", "\u2A0C");
        map.put("iiint;", "\u222D");
        map.put("iinfin;", "\u29DC");
        map.put("iiota;", "\u2129");
        map.put("IJlig;", "\u0132");
        map.put("ijlig;", "\u0133");
        map.put("Im;", "\u2111");
        map.put("Imacr;", "\u012A");
        map.put("imacr;", "\u012B");
        map.put("image;", "\u2111");
        map.put("ImaginaryI;", "\u2148");
        map.put("imagline;", "\u2110");
        map.put("imagpart;", "\u2111");
        map.put("imath;", "\u0131");
        map.put("imof;", "\u22B7");
        map.put("imped;", "\u01B5");
        map.put("Implies;", "\u21D2");
        map.put("in;", "\u2208");
        map.put("incare;", "\u2105");
        map.put("infin;", "\u221E");
        map.put("infintie;", "\u29DD");
        map.put("inodot;", "\u0131");
        map.put("Int;", "\u222C");
        map.put("int;", "\u222B");
        map.put("intcal;", "\u22BA");
        map.put("integers;", "\u2124");
        map.put("Integral;", "\u222B");
        map.put("intercal;", "\u22BA");
        map.put("Intersection;", "\u22C2");
        map.put("intlarhk;", "\u2A17");
        map.put("intprod;", "\u2A3C");
        map.put("InvisibleComma;", "\u2063");
        map.put("InvisibleTimes;", "\u2062");
        map.put("IOcy;", "\u0401");
        map.put("iocy;", "\u0451");
        map.put("Iogon;", "\u012E");
        map.put("iogon;", "\u012F");
        map.put("Iopf;", "\uD540");
        map.put("iopf;", "\uD55A");
        map.put("Iota;", "\u0399");
        map.put("iota;", "\u03B9");
        map.put("iprod;", "\u2A3C");
        map.put("iquest;", "\u00BF");
        map.put("iquest", "\u00BF");
        map.put("Iscr;", "\u2110");
        map.put("iscr;", "\uD4BE");
        map.put("isin;", "\u2208");
        map.put("isindot;", "\u22F5");
        map.put("isinE;", "\u22F9");
        map.put("isins;", "\u22F4");
        map.put("isinsv;", "\u22F3");
        map.put("isinv;", "\u2208");
        map.put("it;", "\u2062");
        map.put("Itilde;", "\u0128");
        map.put("itilde;", "\u0129");
        map.put("Iukcy;", "\u0406");
        map.put("iukcy;", "\u0456");
        map.put("Iuml;", "\u00CF");
        map.put("Iuml", "\u00CF");
        map.put("iuml;", "\u00EF");
        map.put("iuml", "\u00EF");
        map.put("Jcirc;", "\u0134");
        map.put("jcirc;", "\u0135");
        map.put("Jcy;", "\u0419");
        map.put("jcy;", "\u0439");
        map.put("Jfr;", "\uD50D");
        map.put("jfr;", "\uD527");
        map.put("jmath;", "\u0237");
        map.put("Jopf;", "\uD541");
        map.put("jopf;", "\uD55B");
        map.put("Jscr;", "\uD4A5");
        map.put("jscr;", "\uD4BF");
        map.put("Jsercy;", "\u0408");
        map.put("jsercy;", "\u0458");
        map.put("Jukcy;", "\u0404");
        map.put("jukcy;", "\u0454");
        map.put("Kappa;", "\u039A");
        map.put("kappa;", "\u03BA");
        map.put("kappav;", "\u03F0");
        map.put("Kcedil;", "\u0136");
        map.put("kcedil;", "\u0137");
        map.put("Kcy;", "\u041A");
        map.put("kcy;", "\u043A");
        map.put("Kfr;", "\uD50E");
        map.put("kfr;", "\uD528");
        map.put("kgreen;", "\u0138");
        map.put("KHcy;", "\u0425");
        map.put("khcy;", "\u0445");
        map.put("KJcy;", "\u040C");
        map.put("kjcy;", "\u045C");
        map.put("Kopf;", "\uD542");
        map.put("kopf;", "\uD55C");
        map.put("Kscr;", "\uD4A6");
        map.put("kscr;", "\uD4C0");
        map.put("lAarr;", "\u21DA");
        map.put("Lacute;", "\u0139");
        map.put("lacute;", "\u013A");
        map.put("laemptyv;", "\u29B4");
        map.put("lagran;", "\u2112");
        map.put("Lambda;", "\u039B");
        map.put("lambda;", "\u03BB");
        map.put("Lang;", "\u27EA");
        map.put("lang;", "\u27E8");
        map.put("langd;", "\u2991");
        map.put("langle;", "\u27E8");
        map.put("lap;", "\u2A85");
        map.put("Laplacetrf;", "\u2112");
        map.put("laquo;", "\u00AB");
        map.put("laquo", "\u00AB");
        map.put("Larr;", "\u219E");
        map.put("lArr;", "\u21D0");
        map.put("larr;", "\u2190");
        map.put("larrb;", "\u21E4");
        map.put("larrbfs;", "\u291F");
        map.put("larrfs;", "\u291D");
        map.put("larrhk;", "\u21A9");
        map.put("larrlp;", "\u21AB");
        map.put("larrpl;", "\u2939");
        map.put("larrsim;", "\u2973");
        map.put("larrtl;", "\u21A2");
        map.put("lat;", "\u2AAB");
        map.put("lAtail;", "\u291B");
        map.put("latail;", "\u2919");
        map.put("late;", "\u2AAD");
        map.put("lates;", "\u2AAD\uFE00");
        map.put("lBarr;", "\u290E");
        map.put("lbarr;", "\u290C");
        map.put("lbbrk;", "\u2772");
        map.put("lbrace;", "\u007B");
        map.put("lbrack;", "\u005B");
        map.put("lbrke;", "\u298B");
        map.put("lbrksld;", "\u298F");
        map.put("lbrkslu;", "\u298D");
        map.put("Lcaron;", "\u013D");
        map.put("lcaron;", "\u013E");
        map.put("Lcedil;", "\u013B");
        map.put("lcedil;", "\u013C");
        map.put("lceil;", "\u2308");
        map.put("lcub;", "\u007B");
        map.put("Lcy;", "\u041B");
        map.put("lcy;", "\u043B");
        map.put("ldca;", "\u2936");
        map.put("ldquo;", "\u201C");
        map.put("ldquor;", "\u201E");
        map.put("ldrdhar;", "\u2967");
        map.put("ldrushar;", "\u294B");
        map.put("ldsh;", "\u21B2");
        map.put("lE;", "\u2266");
        map.put("le;", "\u2264");
        map.put("LeftAngleBracket;", "\u27E8");
        map.put("LeftArrow;", "\u2190");
        map.put("Leftarrow;", "\u21D0");
        map.put("leftarrow;", "\u2190");
        map.put("LeftArrowBar;", "\u21E4");
        map.put("LeftArrowRightArrow;", "\u21C6");
        map.put("leftarrowtail;", "\u21A2");
        map.put("LeftCeiling;", "\u2308");
        map.put("LeftDoubleBracket;", "\u27E6");
        map.put("LeftDownTeeVector;", "\u2961");
        map.put("LeftDownVector;", "\u21C3");
        map.put("LeftDownVectorBar;", "\u2959");
        map.put("LeftFloor;", "\u230A");
        map.put("leftharpoondown;", "\u21BD");
        map.put("leftharpoonup;", "\u21BC");
        map.put("leftleftarrows;", "\u21C7");
        map.put("LeftRightArrow;", "\u2194");
        map.put("Leftrightarrow;", "\u21D4");
        map.put("leftrightarrow;", "\u2194");
        map.put("leftrightarrows;", "\u21C6");
        map.put("leftrightharpoons;", "\u21CB");
        map.put("leftrightsquigarrow;", "\u21AD");
        map.put("LeftRightVector;", "\u294E");
        map.put("LeftTee;", "\u22A3");
        map.put("LeftTeeArrow;", "\u21A4");
        map.put("LeftTeeVector;", "\u295A");
        map.put("leftthreetimes;", "\u22CB");
        map.put("LeftTriangle;", "\u22B2");
        map.put("LeftTriangleBar;", "\u29CF");
        map.put("LeftTriangleEqual;", "\u22B4");
        map.put("LeftUpDownVector;", "\u2951");
        map.put("LeftUpTeeVector;", "\u2960");
        map.put("LeftUpVector;", "\u21BF");
        map.put("LeftUpVectorBar;", "\u2958");
        map.put("LeftVector;", "\u21BC");
        map.put("LeftVectorBar;", "\u2952");
        map.put("lEg;", "\u2A8B");
        map.put("leg;", "\u22DA");
        map.put("leq;", "\u2264");
        map.put("leqq;", "\u2266");
        map.put("leqslant;", "\u2A7D");
        map.put("les;", "\u2A7D");
        map.put("lescc;", "\u2AA8");
        map.put("lesdot;", "\u2A7F");
        map.put("lesdoto;", "\u2A81");
        map.put("lesdotor;", "\u2A83");
        map.put("lesg;", "\u22DA\uFE00");
        map.put("lesges;", "\u2A93");
        map.put("lessapprox;", "\u2A85");
        map.put("lessdot;", "\u22D6");
        map.put("lesseqgtr;", "\u22DA");
        map.put("lesseqqgtr;", "\u2A8B");
        map.put("LessEqualGreater;", "\u22DA");
        map.put("LessFullEqual;", "\u2266");
        map.put("LessGreater;", "\u2276");
        map.put("lessgtr;", "\u2276");
        map.put("LessLess;", "\u2AA1");
        map.put("lesssim;", "\u2272");
        map.put("LessSlantEqual;", "\u2A7D");
        map.put("LessTilde;", "\u2272");
        map.put("lfisht;", "\u297C");
        map.put("lfloor;", "\u230A");
        map.put("Lfr;", "\uD50F");
        map.put("lfr;", "\uD529");
        map.put("lg;", "\u2276");
        map.put("lgE;", "\u2A91");
        map.put("lHar;", "\u2962");
        map.put("lhard;", "\u21BD");
        map.put("lharu;", "\u21BC");
        map.put("lharul;", "\u296A");
        map.put("lhblk;", "\u2584");
        map.put("LJcy;", "\u0409");
        map.put("ljcy;", "\u0459");
        map.put("Ll;", "\u22D8");
        map.put("ll;", "\u226A");
        map.put("llarr;", "\u21C7");
        map.put("llcorner;", "\u231E");
        map.put("Lleftarrow;", "\u21DA");
        map.put("llhard;", "\u296B");
        map.put("lltri;", "\u25FA");
        map.put("Lmidot;", "\u013F");
        map.put("lmidot;", "\u0140");
        map.put("lmoust;", "\u23B0");
        map.put("lmoustache;", "\u23B0");
        map.put("lnap;", "\u2A89");
        map.put("lnapprox;", "\u2A89");
        map.put("lnE;", "\u2268");
        map.put("lne;", "\u2A87");
        map.put("lneq;", "\u2A87");
        map.put("lneqq;", "\u2268");
        map.put("lnsim;", "\u22E6");
        map.put("loang;", "\u27EC");
        map.put("loarr;", "\u21FD");
        map.put("lobrk;", "\u27E6");
        map.put("LongLeftArrow;", "\u27F5");
        map.put("Longleftarrow;", "\u27F8");
        map.put("longleftarrow;", "\u27F5");
        map.put("LongLeftRightArrow;", "\u27F7");
        map.put("Longleftrightarrow;", "\u27FA");
        map.put("longleftrightarrow;", "\u27F7");
        map.put("longmapsto;", "\u27FC");
        map.put("LongRightArrow;", "\u27F6");
        map.put("Longrightarrow;", "\u27F9");
        map.put("longrightarrow;", "\u27F6");
        map.put("looparrowleft;", "\u21AB");
        map.put("looparrowright;", "\u21AC");
        map.put("lopar;", "\u2985");
        map.put("Lopf;", "\uD543");
        map.put("lopf;", "\uD55D");
        map.put("loplus;", "\u2A2D");
        map.put("lotimes;", "\u2A34");
        map.put("lowast;", "\u2217");
        map.put("lowbar;", "\u005F");
        map.put("LowerLeftArrow;", "\u2199");
        map.put("LowerRightArrow;", "\u2198");
        map.put("loz;", "\u25CA");
        map.put("lozenge;", "\u25CA");
        map.put("lozf;", "\u29EB");
        map.put("lpar;", "\u0028");
        map.put("lparlt;", "\u2993");
        map.put("lrarr;", "\u21C6");
        map.put("lrcorner;", "\u231F");
        map.put("lrhar;", "\u21CB");
        map.put("lrhard;", "\u296D");
        map.put("lrm;", "\u200E");
        map.put("lrtri;", "\u22BF");
        map.put("lsaquo;", "\u2039");
        map.put("Lscr;", "\u2112");
        map.put("lscr;", "\uD4C1");
        map.put("Lsh;", "\u21B0");
        map.put("lsh;", "\u21B0");
        map.put("lsim;", "\u2272");
        map.put("lsime;", "\u2A8D");
        map.put("lsimg;", "\u2A8F");
        map.put("lsqb;", "\u005B");
        map.put("lsquo;", "\u2018");
        map.put("lsquor;", "\u201A");
        map.put("Lstrok;", "\u0141");
        map.put("lstrok;", "\u0142");
        map.put("LT;", "\u003C");
        map.put("LT", "\u003C");
        map.put("Lt;", "\u226A");
        map.put("lt;", "\u003C");
        map.put("lt", "\u003C");
        map.put("ltcc;", "\u2AA6");
        map.put("ltcir;", "\u2A79");
        map.put("ltdot;", "\u22D6");
        map.put("lthree;", "\u22CB");
        map.put("ltimes;", "\u22C9");
        map.put("ltlarr;", "\u2976");
        map.put("ltquest;", "\u2A7B");
        map.put("ltri;", "\u25C3");
        map.put("ltrie;", "\u22B4");
        map.put("ltrif;", "\u25C2");
        map.put("ltrPar;", "\u2996");
        map.put("lurdshar;", "\u294A");
        map.put("luruhar;", "\u2966");
        map.put("lvertneqq;", "\u2268\uFE00");
        map.put("lvnE;", "\u2268\uFE00");
        map.put("macr;", "\u00AF");
        map.put("macr", "\u00AF");
        map.put("male;", "\u2642");
        map.put("malt;", "\u2720");
        map.put("maltese;", "\u2720");
        map.put("Map;", "\u2905");
        map.put("map;", "\u21A6");
        map.put("mapsto;", "\u21A6");
        map.put("mapstodown;", "\u21A7");
        map.put("mapstoleft;", "\u21A4");
        map.put("mapstoup;", "\u21A5");
        map.put("marker;", "\u25AE");
        map.put("mcomma;", "\u2A29");
        map.put("Mcy;", "\u041C");
        map.put("mcy;", "\u043C");
        map.put("mdash;", "\u2014");
        map.put("mDDot;", "\u223A");
        map.put("measuredangle;", "\u2221");
        map.put("MediumSpace;", "\u205F");
        map.put("Mellintrf;", "\u2133");
        map.put("Mfr;", "\uD510");
        map.put("mfr;", "\uD52A");
        map.put("mho;", "\u2127");
        map.put("micro;", "\u00B5");
        map.put("micro", "\u00B5");
        map.put("mid;", "\u2223");
        map.put("midast;", "\u002A");
        map.put("midcir;", "\u2AF0");
        map.put("middot;", "\u00B7");
        map.put("middot", "\u00B7");
        map.put("minus;", "\u2212");
        map.put("minusb;", "\u229F");
        map.put("minusd;", "\u2238");
        map.put("minusdu;", "\u2A2A");
        map.put("MinusPlus;", "\u2213");
        map.put("mlcp;", "\u2ADB");
        map.put("mldr;", "\u2026");
        map.put("mnplus;", "\u2213");
        map.put("models;", "\u22A7");
        map.put("Mopf;", "\uD544");
        map.put("mopf;", "\uD55E");
        map.put("mp;", "\u2213");
        map.put("Mscr;", "\u2133");
        map.put("mscr;", "\uD4C2");
        map.put("mstpos;", "\u223E");
        map.put("Mu;", "\u039C");
        map.put("mu;", "\u03BC");
        map.put("multimap;", "\u22B8");
        map.put("mumap;", "\u22B8");
        map.put("nabla;", "\u2207");
        map.put("Nacute;", "\u0143");
        map.put("nacute;", "\u0144");
        map.put("nang;", "\u2220\u20D2");
        map.put("nap;", "\u2249");
        map.put("napE;", "\u2A70\u0338");
        map.put("napid;", "\u224B\u0338");
        map.put("napos;", "\u0149");
        map.put("napprox;", "\u2249");
        map.put("natur;", "\u266E");
        map.put("natural;", "\u266E");
        map.put("naturals;", "\u2115");
        map.put("nbsp;", "\u00A0");
        map.put("nbsp", "\u00A0");
        map.put("nbump;", "\u224E\u0338");
        map.put("nbumpe;", "\u224F\u0338");
        map.put("ncap;", "\u2A43");
        map.put("Ncaron;", "\u0147");
        map.put("ncaron;", "\u0148");
        map.put("Ncedil;", "\u0145");
        map.put("ncedil;", "\u0146");
        map.put("ncong;", "\u2247");
        map.put("ncongdot;", "\u2A6D\u0338");
        map.put("ncup;", "\u2A42");
        map.put("Ncy;", "\u041D");
        map.put("ncy;", "\u043D");
        map.put("ndash;", "\u2013");
        map.put("endash;", "\u2013");  // other TADS-specific addition that some games use
        map.put("ne;", "\u2260");
        map.put("nearhk;", "\u2924");
        map.put("neArr;", "\u21D7");
        map.put("nearr;", "\u2197");
        map.put("nearrow;", "\u2197");
        map.put("nedot;", "\u2250\u0338");
        map.put("NegativeMediumSpace;", "\u200B");
        map.put("NegativeThickSpace;", "\u200B");
        map.put("NegativeThinSpace;", "\u200B");
        map.put("NegativeVeryThinSpace;", "\u200B");
        map.put("nequiv;", "\u2262");
        map.put("nesear;", "\u2928");
        map.put("nesim;", "\u2242\u0338");
        map.put("NestedGreaterGreater;", "\u226B");
        map.put("NestedLessLess;", "\u226A");
        map.put("NewLine;", "\n");
        map.put("nexist;", "\u2204");
        map.put("nexists;", "\u2204");
        map.put("Nfr;", "\uD511");
        map.put("nfr;", "\uD52B");
        map.put("ngE;", "\u2267\u0338");
        map.put("nge;", "\u2271");
        map.put("ngeq;", "\u2271");
        map.put("ngeqq;", "\u2267\u0338");
        map.put("ngeqslant;", "\u2A7E\u0338");
        map.put("nges;", "\u2A7E\u0338");
        map.put("nGg;", "\u22D9\u0338");
        map.put("ngsim;", "\u2275");
        map.put("nGt;", "\u226B\u20D2");
        map.put("ngt;", "\u226F");
        map.put("ngtr;", "\u226F");
        map.put("nGtv;", "\u226B\u0338");
        map.put("nhArr;", "\u21CE");
        map.put("nharr;", "\u21AE");
        map.put("nhpar;", "\u2AF2");
        map.put("ni;", "\u220B");
        map.put("nis;", "\u22FC");
        map.put("nisd;", "\u22FA");
        map.put("niv;", "\u220B");
        map.put("NJcy;", "\u040A");
        map.put("njcy;", "\u045A");
        map.put("nlArr;", "\u21CD");
        map.put("nlarr;", "\u219A");
        map.put("nldr;", "\u2025");
        map.put("nlE;", "\u2266\u0338");
        map.put("nle;", "\u2270");
        map.put("nLeftarrow;", "\u21CD");
        map.put("nleftarrow;", "\u219A");
        map.put("nLeftrightarrow;", "\u21CE");
        map.put("nleftrightarrow;", "\u21AE");
        map.put("nleq;", "\u2270");
        map.put("nleqq;", "\u2266\u0338");
        map.put("nleqslant;", "\u2A7D\u0338");
        map.put("nles;", "\u2A7D\u0338");
        map.put("nless;", "\u226E");
        map.put("nLl;", "\u22D8\u0338");
        map.put("nlsim;", "\u2274");
        map.put("nLt;", "\u226A\u20D2");
        map.put("nlt;", "\u226E");
        map.put("nltri;", "\u22EA");
        map.put("nltrie;", "\u22EC");
        map.put("nLtv;", "\u226A\u0338");
        map.put("nmid;", "\u2224");
        map.put("NoBreak;", "\u2060");
        map.put("NonBreakingSpace;", "\u00A0");
        map.put("Nopf;", "\u2115");
        map.put("nopf;", "\uD55F");
        map.put("Not;", "\u2AEC");
        map.put("not;", "\u00AC");
        map.put("not", "\u00AC");
        map.put("NotCongruent;", "\u2262");
        map.put("NotCupCap;", "\u226D");
        map.put("NotDoubleVerticalBar;", "\u2226");
        map.put("NotElement;", "\u2209");
        map.put("NotEqual;", "\u2260");
        map.put("NotEqualTilde;", "\u2242\u0338");
        map.put("NotExists;", "\u2204");
        map.put("NotGreater;", "\u226F");
        map.put("NotGreaterEqual;", "\u2271");
        map.put("NotGreaterFullEqual;", "\u2267\u0338");
        map.put("NotGreaterGreater;", "\u226B\u0338");
        map.put("NotGreaterLess;", "\u2279");
        map.put("NotGreaterSlantEqual;", "\u2A7E\u0338");
        map.put("NotGreaterTilde;", "\u2275");
        map.put("NotHumpDownHump;", "\u224E\u0338");
        map.put("NotHumpEqual;", "\u224F\u0338");
        map.put("notin;", "\u2209");
        map.put("notindot;", "\u22F5\u0338");
        map.put("notinE;", "\u22F9\u0338");
        map.put("notinva;", "\u2209");
        map.put("notinvb;", "\u22F7");
        map.put("notinvc;", "\u22F6");
        map.put("NotLeftTriangle;", "\u22EA");
        map.put("NotLeftTriangleBar;", "\u29CF\u0338");
        map.put("NotLeftTriangleEqual;", "\u22EC");
        map.put("NotLess;", "\u226E");
        map.put("NotLessEqual;", "\u2270");
        map.put("NotLessGreater;", "\u2278");
        map.put("NotLessLess;", "\u226A\u0338");
        map.put("NotLessSlantEqual;", "\u2A7D\u0338");
        map.put("NotLessTilde;", "\u2274");
        map.put("NotNestedGreaterGreater;", "\u2AA2\u0338");
        map.put("NotNestedLessLess;", "\u2AA1\u0338");
        map.put("notni;", "\u220C");
        map.put("notniva;", "\u220C");
        map.put("notnivb;", "\u22FE");
        map.put("notnivc;", "\u22FD");
        map.put("NotPrecedes;", "\u2280");
        map.put("NotPrecedesEqual;", "\u2AAF\u0338");
        map.put("NotPrecedesSlantEqual;", "\u22E0");
        map.put("NotReverseElement;", "\u220C");
        map.put("NotRightTriangle;", "\u22EB");
        map.put("NotRightTriangleBar;", "\u29D0\u0338");
        map.put("NotRightTriangleEqual;", "\u22ED");
        map.put("NotSquareSubset;", "\u228F\u0338");
        map.put("NotSquareSubsetEqual;", "\u22E2");
        map.put("NotSquareSuperset;", "\u2290\u0338");
        map.put("NotSquareSupersetEqual;", "\u22E3");
        map.put("NotSubset;", "\u2282\u20D2");
        map.put("NotSubsetEqual;", "\u2288");
        map.put("NotSucceeds;", "\u2281");
        map.put("NotSucceedsEqual;", "\u2AB0\u0338");
        map.put("NotSucceedsSlantEqual;", "\u22E1");
        map.put("NotSucceedsTilde;", "\u227F\u0338");
        map.put("NotSuperset;", "\u2283\u20D2");
        map.put("NotSupersetEqual;", "\u2289");
        map.put("NotTilde;", "\u2241");
        map.put("NotTildeEqual;", "\u2244");
        map.put("NotTildeFullEqual;", "\u2247");
        map.put("NotTildeTilde;", "\u2249");
        map.put("NotVerticalBar;", "\u2224");
        map.put("npar;", "\u2226");
        map.put("nparallel;", "\u2226");
        map.put("nparsl;", "\u2AFD\u20E5");
        map.put("npart;", "\u2202\u0338");
        map.put("npolint;", "\u2A14");
        map.put("npr;", "\u2280");
        map.put("nprcue;", "\u22E0");
        map.put("npre;", "\u2AAF\u0338");
        map.put("nprec;", "\u2280");
        map.put("npreceq;", "\u2AAF\u0338");
        map.put("nrArr;", "\u21CF");
        map.put("nrarr;", "\u219B");
        map.put("nrarrc;", "\u2933\u0338");
        map.put("nrarrw;", "\u219D\u0338");
        map.put("nRightarrow;", "\u21CF");
        map.put("nrightarrow;", "\u219B");
        map.put("nrtri;", "\u22EB");
        map.put("nrtrie;", "\u22ED");
        map.put("nsc;", "\u2281");
        map.put("nsccue;", "\u22E1");
        map.put("nsce;", "\u2AB0\u0338");
        map.put("Nscr;", "\uD4A9");
        map.put("nscr;", "\uD4C3");
        map.put("nshortmid;", "\u2224");
        map.put("nshortparallel;", "\u2226");
        map.put("nsim;", "\u2241");
        map.put("nsime;", "\u2244");
        map.put("nsimeq;", "\u2244");
        map.put("nsmid;", "\u2224");
        map.put("nspar;", "\u2226");
        map.put("nsqsube;", "\u22E2");
        map.put("nsqsupe;", "\u22E3");
        map.put("nsub;", "\u2284");
        map.put("nsubE;", "\u2AC5\u0338");
        map.put("nsube;", "\u2288");
        map.put("nsubset;", "\u2282\u20D2");
        map.put("nsubseteq;", "\u2288");
        map.put("nsubseteqq;", "\u2AC5\u0338");
        map.put("nsucc;", "\u2281");
        map.put("nsucceq;", "\u2AB0\u0338");
        map.put("nsup;", "\u2285");
        map.put("nsupE;", "\u2AC6\u0338");
        map.put("nsupe;", "\u2289");
        map.put("nsupset;", "\u2283\u20D2");
        map.put("nsupseteq;", "\u2289");
        map.put("nsupseteqq;", "\u2AC6\u0338");
        map.put("ntgl;", "\u2279");
        map.put("Ntilde;", "\u00D1");
        map.put("Ntilde", "\u00D1");
        map.put("ntilde;", "\u00F1");
        map.put("ntilde", "\u00F1");
        map.put("ntlg;", "\u2278");
        map.put("ntriangleleft;", "\u22EA");
        map.put("ntrianglelefteq;", "\u22EC");
        map.put("ntriangleright;", "\u22EB");
        map.put("ntrianglerighteq;", "\u22ED");
        map.put("Nu;", "\u039D");
        map.put("nu;", "\u03BD");
        map.put("num;", "\u0023");
        map.put("numero;", "\u2116");
        map.put("numsp;", "\u2007");
        map.put("nvap;", "\u224D\u20D2");
        map.put("nVDash;", "\u22AF");
        map.put("nVdash;", "\u22AE");
        map.put("nvDash;", "\u22AD");
        map.put("nvdash;", "\u22AC");
        map.put("nvge;", "\u2265\u20D2");
        map.put("nvgt;", "\u003E\u20D2");
        map.put("nvHarr;", "\u2904");
        map.put("nvinfin;", "\u29DE");
        map.put("nvlArr;", "\u2902");
        map.put("nvle;", "\u2264\u20D2");
        map.put("nvlt;", "\u003C\u20D2");
        map.put("nvltrie;", "\u22B4\u20D2");
        map.put("nvrArr;", "\u2903");
        map.put("nvrtrie;", "\u22B5\u20D2");
        map.put("nvsim;", "\u223C\u20D2");
        map.put("nwarhk;", "\u2923");
        map.put("nwArr;", "\u21D6");
        map.put("nwarr;", "\u2196");
        map.put("nwarrow;", "\u2196");
        map.put("nwnear;", "\u2927");
        map.put("Oacute;", "\u00D3");
        map.put("Oacute", "\u00D3");
        map.put("oacute;", "\u00F3");
        map.put("oacute", "\u00F3");
        map.put("oast;", "\u229B");
        map.put("ocir;", "\u229A");
        map.put("Ocirc;", "\u00D4");
        map.put("Ocirc", "\u00D4");
        map.put("ocirc;", "\u00F4");
        map.put("ocirc", "\u00F4");
        map.put("Ocy;", "\u041E");
        map.put("ocy;", "\u043E");
        map.put("odash;", "\u229D");
        map.put("Odblac;", "\u0150");
        map.put("odblac;", "\u0151");
        map.put("odiv;", "\u2A38");
        map.put("odot;", "\u2299");
        map.put("odsold;", "\u29BC");
        map.put("OElig;", "\u0152");
        map.put("oelig;", "\u0153");
        map.put("ofcir;", "\u29BF");
        map.put("Ofr;", "\uD512");
        map.put("ofr;", "\uD52C");
        map.put("ogon;", "\u02DB");
        map.put("Ograve;", "\u00D2");
        map.put("Ograve", "\u00D2");
        map.put("ograve;", "\u00F2");
        map.put("ograve", "\u00F2");
        map.put("ogt;", "\u29C1");
        map.put("ohbar;", "\u29B5");
        map.put("ohm;", "\u03A9");
        map.put("oint;", "\u222E");
        map.put("olarr;", "\u21BA");
        map.put("olcir;", "\u29BE");
        map.put("olcross;", "\u29BB");
        map.put("oline;", "\u203E");
        map.put("olt;", "\u29C0");
        map.put("Omacr;", "\u014C");
        map.put("omacr;", "\u014D");
        map.put("Omega;", "\u03A9");
        map.put("omega;", "\u03C9");
        map.put("Omicron;", "\u039F");
        map.put("omicron;", "\u03BF");
        map.put("omid;", "\u29B6");
        map.put("ominus;", "\u2296");
        map.put("Oopf;", "\uD546");
        map.put("oopf;", "\uD560");
        map.put("opar;", "\u29B7");
        map.put("OpenCurlyDoubleQuote;", "\u201C");
        map.put("OpenCurlyQuote;", "\u2018");
        map.put("operp;", "\u29B9");
        map.put("oplus;", "\u2295");
        map.put("Or;", "\u2A54");
        map.put("or;", "\u2228");
        map.put("orarr;", "\u21BB");
        map.put("ord;", "\u2A5D");
        map.put("order;", "\u2134");
        map.put("orderof;", "\u2134");
        map.put("ordf;", "\u00AA");
        map.put("ordf", "\u00AA");
        map.put("ordm;", "\u00BA");
        map.put("ordm", "\u00BA");
        map.put("origof;", "\u22B6");
        map.put("oror;", "\u2A56");
        map.put("orslope;", "\u2A57");
        map.put("orv;", "\u2A5B");
        map.put("oS;", "\u24C8");
        map.put("Oscr;", "\uD4AA");
        map.put("oscr;", "\u2134");
        map.put("Oslash;", "\u00D8");
        map.put("Oslash", "\u00D8");
        map.put("oslash;", "\u00F8");
        map.put("oslash", "\u00F8");
        map.put("osol;", "\u2298");
        map.put("Otilde;", "\u00D5");
        map.put("Otilde", "\u00D5");
        map.put("otilde;", "\u00F5");
        map.put("otilde", "\u00F5");
        map.put("Otimes;", "\u2A37");
        map.put("otimes;", "\u2297");
        map.put("otimesas;", "\u2A36");
        map.put("Ouml;", "\u00D6");
        map.put("Ouml", "\u00D6");
        map.put("ouml;", "\u00F6");
        map.put("ouml", "\u00F6");
        map.put("ovbar;", "\u233D");
        map.put("OverBar;", "\u203E");
        map.put("OverBrace;", "\u23DE");
        map.put("OverBracket;", "\u23B4");
        map.put("OverParenthesis;", "\u23DC");
        map.put("par;", "\u2225");
        map.put("para;", "\u00B6");
        map.put("para", "\u00B6");
        map.put("parallel;", "\u2225");
        map.put("parsim;", "\u2AF3");
        map.put("parsl;", "\u2AFD");
        map.put("part;", "\u2202");
        map.put("PartialD;", "\u2202");
        map.put("Pcy;", "\u041F");
        map.put("pcy;", "\u043F");
        map.put("percnt;", "\u0025");
        map.put("period;", "\u002E");
        map.put("permil;", "\u2030");
        map.put("perp;", "\u22A5");
        map.put("pertenk;", "\u2031");
        map.put("Pfr;", "\uD513");
        map.put("pfr;", "\uD52D");
        map.put("Phi;", "\u03A6");
        map.put("phi;", "\u03C6");
        map.put("phiv;", "\u03D5");
        map.put("phmmat;", "\u2133");
        map.put("phone;", "\u260E");
        map.put("Pi;", "\u03A0");
        map.put("pi;", "\u03C0");
        map.put("pitchfork;", "\u22D4");
        map.put("piv;", "\u03D6");
        map.put("planck;", "\u210F");
        map.put("planckh;", "\u210E");
        map.put("plankv;", "\u210F");
        map.put("plus;", "\u002B");
        map.put("plusacir;", "\u2A23");
        map.put("plusb;", "\u229E");
        map.put("pluscir;", "\u2A22");
        map.put("plusdo;", "\u2214");
        map.put("plusdu;", "\u2A25");
        map.put("pluse;", "\u2A72");
        map.put("PlusMinus;", "\u00B1");
        map.put("plusmn;", "\u00B1");
        map.put("plusmn", "\u00B1");
        map.put("plussim;", "\u2A26");
        map.put("plustwo;", "\u2A27");
        map.put("pm;", "\u00B1");
        map.put("Poincareplane;", "\u210C");
        map.put("pointint;", "\u2A15");
        map.put("Popf;", "\u2119");
        map.put("popf;", "\uD561");
        map.put("pound;", "\u00A3");
        map.put("pound", "\u00A3");
        map.put("Pr;", "\u2ABB");
        map.put("pr;", "\u227A");
        map.put("prap;", "\u2AB7");
        map.put("prcue;", "\u227C");
        map.put("prE;", "\u2AB3");
        map.put("pre;", "\u2AAF");
        map.put("prec;", "\u227A");
        map.put("precapprox;", "\u2AB7");
        map.put("preccurlyeq;", "\u227C");
        map.put("Precedes;", "\u227A");
        map.put("PrecedesEqual;", "\u2AAF");
        map.put("PrecedesSlantEqual;", "\u227C");
        map.put("PrecedesTilde;", "\u227E");
        map.put("preceq;", "\u2AAF");
        map.put("precnapprox;", "\u2AB9");
        map.put("precneqq;", "\u2AB5");
        map.put("precnsim;", "\u22E8");
        map.put("precsim;", "\u227E");
        map.put("Prime;", "\u2033");
        map.put("prime;", "\u2032");
        map.put("primes;", "\u2119");
        map.put("prnap;", "\u2AB9");
        map.put("prnE;", "\u2AB5");
        map.put("prnsim;", "\u22E8");
        map.put("prod;", "\u220F");
        map.put("Product;", "\u220F");
        map.put("profalar;", "\u232E");
        map.put("profline;", "\u2312");
        map.put("profsurf;", "\u2313");
        map.put("prop;", "\u221D");
        map.put("Proportion;", "\u2237");
        map.put("Proportional;", "\u221D");
        map.put("propto;", "\u221D");
        map.put("prsim;", "\u227E");
        map.put("prurel;", "\u22B0");
        map.put("Pscr;", "\uD4AB");
        map.put("pscr;", "\uD4C5");
        map.put("Psi;", "\u03A8");
        map.put("psi;", "\u03C8");
        map.put("puncsp;", "\u2008");
        map.put("Qfr;", "\uD514");
        map.put("qfr;", "\uD52E");
        map.put("qint;", "\u2A0C");
        map.put("Qopf;", "\u211A");
        map.put("qopf;", "\uD562");
        map.put("qprime;", "\u2057");
        map.put("Qscr;", "\uD4AC");
        map.put("qscr;", "\uD4C6");
        map.put("quaternions;", "\u210D");
        map.put("quatint;", "\u2A16");
        map.put("quest;", "\u003F");
        map.put("questeq;", "\u225F");
        map.put("QUOT;", "\\u0022");
        map.put("QUOT", "\\u0022");
        map.put("quot;", "\\u0022");
        map.put("quot", "\\u0022");
        map.put("rAarr;", "\u21DB");
        map.put("race;", "\u223D\u0331");
        map.put("Racute;", "\u0154");
        map.put("racute;", "\u0155");
        map.put("radic;", "\u221A");
        map.put("raemptyv;", "\u29B3");
        map.put("Rang;", "\u27EB");
        map.put("rang;", "\u27E9");
        map.put("rangd;", "\u2992");
        map.put("range;", "\u29A5");
        map.put("rangle;", "\u27E9");
        map.put("raquo;", "\u00BB");
        map.put("raquo", "\u00BB");
        map.put("Rarr;", "\u21A0");
        map.put("rArr;", "\u21D2");
        map.put("rarr;", "\u2192");
        map.put("rarrap;", "\u2975");
        map.put("rarrb;", "\u21E5");
        map.put("rarrbfs;", "\u2920");
        map.put("rarrc;", "\u2933");
        map.put("rarrfs;", "\u291E");
        map.put("rarrhk;", "\u21AA");
        map.put("rarrlp;", "\u21AC");
        map.put("rarrpl;", "\u2945");
        map.put("rarrsim;", "\u2974");
        map.put("Rarrtl;", "\u2916");
        map.put("rarrtl;", "\u21A3");
        map.put("rarrw;", "\u219D");
        map.put("rAtail;", "\u291C");
        map.put("ratail;", "\u291A");
        map.put("ratio;", "\u2236");
        map.put("rationals;", "\u211A");
        map.put("RBarr;", "\u2910");
        map.put("rBarr;", "\u290F");
        map.put("rbarr;", "\u290D");
        map.put("rbbrk;", "\u2773");
        map.put("rbrace;", "\u007D");
        map.put("rbrack;", "\u005D");
        map.put("rbrke;", "\u298C");
        map.put("rbrksld;", "\u298E");
        map.put("rbrkslu;", "\u2990");
        map.put("Rcaron;", "\u0158");
        map.put("rcaron;", "\u0159");
        map.put("Rcedil;", "\u0156");
        map.put("rcedil;", "\u0157");
        map.put("rceil;", "\u2309");
        map.put("rcub;", "\u007D");
        map.put("Rcy;", "\u0420");
        map.put("rcy;", "\u0440");
        map.put("rdca;", "\u2937");
        map.put("rdldhar;", "\u2969");
        map.put("rdquo;", "\u201D");
        map.put("rdquor;", "\u201D");
        map.put("rdsh;", "\u21B3");
        map.put("Re;", "\u211C");
        map.put("real;", "\u211C");
        map.put("realine;", "\u211B");
        map.put("realpart;", "\u211C");
        map.put("reals;", "\u211D");
        map.put("rect;", "\u25AD");
        map.put("REG;", "\u00AE");
        map.put("REG", "\u00AE");
        map.put("reg;", "\u00AE");
        map.put("reg", "\u00AE");
        map.put("ReverseElement;", "\u220B");
        map.put("ReverseEquilibrium;", "\u21CB");
        map.put("ReverseUpEquilibrium;", "\u296F");
        map.put("rfisht;", "\u297D");
        map.put("rfloor;", "\u230B");
        map.put("Rfr;", "\u211C");
        map.put("rfr;", "\uD52F");
        map.put("rHar;", "\u2964");
        map.put("rhard;", "\u21C1");
        map.put("rharu;", "\u21C0");
        map.put("rharul;", "\u296C");
        map.put("Rho;", "\u03A1");
        map.put("rho;", "\u03C1");
        map.put("rhov;", "\u03F1");
        map.put("RightAngleBracket;", "\u27E9");
        map.put("RightArrow;", "\u2192");
        map.put("Rightarrow;", "\u21D2");
        map.put("rightarrow;", "\u2192");
        map.put("RightArrowBar;", "\u21E5");
        map.put("RightArrowLeftArrow;", "\u21C4");
        map.put("rightarrowtail;", "\u21A3");
        map.put("RightCeiling;", "\u2309");
        map.put("RightDoubleBracket;", "\u27E7");
        map.put("RightDownTeeVector;", "\u295D");
        map.put("RightDownVector;", "\u21C2");
        map.put("RightDownVectorBar;", "\u2955");
        map.put("RightFloor;", "\u230B");
        map.put("rightharpoondown;", "\u21C1");
        map.put("rightharpoonup;", "\u21C0");
        map.put("rightleftarrows;", "\u21C4");
        map.put("rightleftharpoons;", "\u21CC");
        map.put("rightrightarrows;", "\u21C9");
        map.put("rightsquigarrow;", "\u219D");
        map.put("RightTee;", "\u22A2");
        map.put("RightTeeArrow;", "\u21A6");
        map.put("RightTeeVector;", "\u295B");
        map.put("rightthreetimes;", "\u22CC");
        map.put("RightTriangle;", "\u22B3");
        map.put("RightTriangleBar;", "\u29D0");
        map.put("RightTriangleEqual;", "\u22B5");
        map.put("RightUpDownVector;", "\u294F");
        map.put("RightUpTeeVector;", "\u295C");
        map.put("RightUpVector;", "\u21BE");
        map.put("RightUpVectorBar;", "\u2954");
        map.put("RightVector;", "\u21C0");
        map.put("RightVectorBar;", "\u2953");
        map.put("ring;", "\u02DA");
        map.put("risingdotseq;", "\u2253");
        map.put("rlarr;", "\u21C4");
        map.put("rlhar;", "\u21CC");
        map.put("rlm;", "\u200F");
        map.put("rmoust;", "\u23B1");
        map.put("rmoustache;", "\u23B1");
        map.put("rnmid;", "\u2AEE");
        map.put("roang;", "\u27ED");
        map.put("roarr;", "\u21FE");
        map.put("robrk;", "\u27E7");
        map.put("ropar;", "\u2986");
        map.put("Ropf;", "\u211D");
        map.put("ropf;", "\uD563");
        map.put("roplus;", "\u2A2E");
        map.put("rotimes;", "\u2A35");
        map.put("RoundImplies;", "\u2970");
        map.put("rpar;", "\u0029");
        map.put("rpargt;", "\u2994");
        map.put("rppolint;", "\u2A12");
        map.put("rrarr;", "\u21C9");
        map.put("Rrightarrow;", "\u21DB");
        map.put("rsaquo;", "\u203A");
        map.put("Rscr;", "\u211B");
        map.put("rscr;", "\uD4C7");
        map.put("Rsh;", "\u21B1");
        map.put("rsh;", "\u21B1");
        map.put("rsqb;", "\u005D");
        map.put("rsquo;", "\u2019");
        map.put("rsquor;", "\u2019");
        map.put("rthree;", "\u22CC");
        map.put("rtimes;", "\u22CA");
        map.put("rtri;", "\u25B9");
        map.put("rtrie;", "\u22B5");
        map.put("rtrif;", "\u25B8");
        map.put("rtriltri;", "\u29CE");
        map.put("RuleDelayed;", "\u29F4");
        map.put("ruluhar;", "\u2968");
        map.put("rx;", "\u211E");
        map.put("Sacute;", "\u015A");
        map.put("sacute;", "\u015B");
        map.put("sbquo;", "\u201A");
        map.put("Sc;", "\u2ABC");
        map.put("sc;", "\u227B");
        map.put("scap;", "\u2AB8");
        map.put("Scaron;", "\u0160");
        map.put("scaron;", "\u0161");
        map.put("sccue;", "\u227D");
        map.put("scE;", "\u2AB4");
        map.put("sce;", "\u2AB0");
        map.put("Scedil;", "\u015E");
        map.put("scedil;", "\u015F");
        map.put("Scirc;", "\u015C");
        map.put("scirc;", "\u015D");
        map.put("scnap;", "\u2ABA");
        map.put("scnE;", "\u2AB6");
        map.put("scnsim;", "\u22E9");
        map.put("scpolint;", "\u2A13");
        map.put("scsim;", "\u227F");
        map.put("Scy;", "\u0421");
        map.put("scy;", "\u0441");
        map.put("sdot;", "\u22C5");
        map.put("sdotb;", "\u22A1");
        map.put("sdote;", "\u2A66");
        map.put("searhk;", "\u2925");
        map.put("seArr;", "\u21D8");
        map.put("searr;", "\u2198");
        map.put("searrow;", "\u2198");
        map.put("sect;", "\u00A7");
        map.put("sect", "\u00A7");
        map.put("semi;", "\u003B");
        map.put("seswar;", "\u2929");
        map.put("setminus;", "\u2216");
        map.put("setmn;", "\u2216");
        map.put("sext;", "\u2736");
        map.put("Sfr;", "\uD516");
        map.put("sfr;", "\uD530");
        map.put("sfrown;", "\u2322");
        map.put("sharp;", "\u266F");
        map.put("SHCHcy;", "\u0429");
        map.put("shchcy;", "\u0449");
        map.put("SHcy;", "\u0428");
        map.put("shcy;", "\u0448");
        map.put("ShortDownArrow;", "\u2193");
        map.put("ShortLeftArrow;", "\u2190");
        map.put("shortmid;", "\u2223");
        map.put("shortparallel;", "\u2225");
        map.put("ShortRightArrow;", "\u2192");
        map.put("ShortUpArrow;", "\u2191");
        map.put("shy;", "\u00AD");
        map.put("shy", "\u00AD");
        map.put("Sigma;", "\u03A3");
        map.put("sigma;", "\u03C3");
        map.put("sigmaf;", "\u03C2");
        map.put("sigmav;", "\u03C2");
        map.put("sim;", "\u223C");
        map.put("simdot;", "\u2A6A");
        map.put("sime;", "\u2243");
        map.put("simeq;", "\u2243");
        map.put("simg;", "\u2A9E");
        map.put("simgE;", "\u2AA0");
        map.put("siml;", "\u2A9D");
        map.put("simlE;", "\u2A9F");
        map.put("simne;", "\u2246");
        map.put("simplus;", "\u2A24");
        map.put("simrarr;", "\u2972");
        map.put("slarr;", "\u2190");
        map.put("SmallCircle;", "\u2218");
        map.put("smallsetminus;", "\u2216");
        map.put("smashp;", "\u2A33");
        map.put("smeparsl;", "\u29E4");
        map.put("smid;", "\u2223");
        map.put("smile;", "\u2323");
        map.put("smt;", "\u2AAA");
        map.put("smte;", "\u2AAC");
        map.put("smtes;", "\u2AAC\uFE00");
        map.put("SOFTcy;", "\u042C");
        map.put("softcy;", "\u044C");
        map.put("sol;", "\u002F");
        map.put("solb;", "\u29C4");
        map.put("solbar;", "\u233F");
        map.put("Sopf;", "\uD54A");
        map.put("sopf;", "\uD564");
        map.put("spades;", "\u2660");
        map.put("spadesuit;", "\u2660");
        map.put("spar;", "\u2225");
        map.put("sqcap;", "\u2293");
        map.put("sqcaps;", "\u2293\uFE00");
        map.put("sqcup;", "\u2294");
        map.put("sqcups;", "\u2294\uFE00");
        map.put("Sqrt;", "\u221A");
        map.put("sqsub;", "\u228F");
        map.put("sqsube;", "\u2291");
        map.put("sqsubset;", "\u228F");
        map.put("sqsubseteq;", "\u2291");
        map.put("sqsup;", "\u2290");
        map.put("sqsupe;", "\u2292");
        map.put("sqsupset;", "\u2290");
        map.put("sqsupseteq;", "\u2292");
        map.put("squ;", "\u25A1");
        map.put("Square;", "\u25A1");
        map.put("square;", "\u25A1");
        map.put("SquareIntersection;", "\u2293");
        map.put("SquareSubset;", "\u228F");
        map.put("SquareSubsetEqual;", "\u2291");
        map.put("SquareSuperset;", "\u2290");
        map.put("SquareSupersetEqual;", "\u2292");
        map.put("SquareUnion;", "\u2294");
        map.put("squarf;", "\u25AA");
        map.put("squf;", "\u25AA");
        map.put("srarr;", "\u2192");
        map.put("Sscr;", "\uD4AE");
        map.put("sscr;", "\uD4C8");
        map.put("ssetmn;", "\u2216");
        map.put("ssmile;", "\u2323");
        map.put("sstarf;", "\u22C6");
        map.put("Star;", "\u22C6");
        map.put("star;", "\u2606");
        map.put("starf;", "\u2605");
        map.put("straightepsilon;", "\u03F5");
        map.put("straightphi;", "\u03D5");
        map.put("strns;", "\u00AF");
        map.put("Sub;", "\u22D0");
        map.put("sub;", "\u2282");
        map.put("subdot;", "\u2ABD");
        map.put("subE;", "\u2AC5");
        map.put("sube;", "\u2286");
        map.put("subedot;", "\u2AC3");
        map.put("submult;", "\u2AC1");
        map.put("subnE;", "\u2ACB");
        map.put("subne;", "\u228A");
        map.put("subplus;", "\u2ABF");
        map.put("subrarr;", "\u2979");
        map.put("Subset;", "\u22D0");
        map.put("subset;", "\u2282");
        map.put("subseteq;", "\u2286");
        map.put("subseteqq;", "\u2AC5");
        map.put("SubsetEqual;", "\u2286");
        map.put("subsetneq;", "\u228A");
        map.put("subsetneqq;", "\u2ACB");
        map.put("subsim;", "\u2AC7");
        map.put("subsub;", "\u2AD5");
        map.put("subsup;", "\u2AD3");
        map.put("succ;", "\u227B");
        map.put("succapprox;", "\u2AB8");
        map.put("succcurlyeq;", "\u227D");
        map.put("Succeeds;", "\u227B");
        map.put("SucceedsEqual;", "\u2AB0");
        map.put("SucceedsSlantEqual;", "\u227D");
        map.put("SucceedsTilde;", "\u227F");
        map.put("succeq;", "\u2AB0");
        map.put("succnapprox;", "\u2ABA");
        map.put("succneqq;", "\u2AB6");
        map.put("succnsim;", "\u22E9");
        map.put("succsim;", "\u227F");
        map.put("SuchThat;", "\u220B");
        map.put("Sum;", "\u2211");
        map.put("sum;", "\u2211");
        map.put("sung;", "\u266A");
        map.put("Sup;", "\u22D1");
        map.put("sup;", "\u2283");
        map.put("sup1;", "\u00B9");
        map.put("sup1", "\u00B9");
        map.put("sup2;", "\u00B2");
        map.put("sup2", "\u00B2");
        map.put("sup3;", "\u00B3");
        map.put("sup3", "\u00B3");
        map.put("supdot;", "\u2ABE");
        map.put("supdsub;", "\u2AD8");
        map.put("supE;", "\u2AC6");
        map.put("supe;", "\u2287");
        map.put("supedot;", "\u2AC4");
        map.put("Superset;", "\u2283");
        map.put("SupersetEqual;", "\u2287");
        map.put("suphsol;", "\u27C9");
        map.put("suphsub;", "\u2AD7");
        map.put("suplarr;", "\u297B");
        map.put("supmult;", "\u2AC2");
        map.put("supnE;", "\u2ACC");
        map.put("supne;", "\u228B");
        map.put("supplus;", "\u2AC0");
        map.put("Supset;", "\u22D1");
        map.put("supset;", "\u2283");
        map.put("supseteq;", "\u2287");
        map.put("supseteqq;", "\u2AC6");
        map.put("supsetneq;", "\u228B");
        map.put("supsetneqq;", "\u2ACC");
        map.put("supsim;", "\u2AC8");
        map.put("supsub;", "\u2AD4");
        map.put("supsup;", "\u2AD6");
        map.put("swarhk;", "\u2926");
        map.put("swArr;", "\u21D9");
        map.put("swarr;", "\u2199");
        map.put("swarrow;", "\u2199");
        map.put("swnwar;", "\u292A");
        map.put("szlig;", "\u00DF");
        map.put("szlig", "\u00DF");
        map.put("Tab;", "\u0009");
        map.put("target;", "\u2316");
        map.put("Tau;", "\u03A4");
        map.put("tau;", "\u03C4");
        map.put("tbrk;", "\u23B4");
        map.put("Tcaron;", "\u0164");
        map.put("tcaron;", "\u0165");
        map.put("Tcedil;", "\u0162");
        map.put("tcedil;", "\u0163");
        map.put("Tcy;", "\u0422");
        map.put("tcy;", "\u0442");
        map.put("tdot;", "\u20DB");
        map.put("telrec;", "\u2315");
        map.put("Tfr;", "\uD517");
        map.put("tfr;", "\uD531");
        map.put("there4;", "\u2234");
        map.put("Therefore;", "\u2234");
        map.put("therefore;", "\u2234");
        map.put("Theta;", "\u0398");
        map.put("theta;", "\u03B8");
        map.put("thetasym;", "\u03D1");
        map.put("thetav;", "\u03D1");
        map.put("thickapprox;", "\u2248");
        map.put("thicksim;", "\u223C");
        map.put("ThickSpace;", "\u205F\u200A");
        map.put("thinsp;", "\u2009");
        map.put("ThinSpace;", "\u2009");
        map.put("thkap;", "\u2248");
        map.put("thksim;", "\u223C");
        map.put("THORN;", "\u00DE");
        map.put("THORN", "\u00DE");
        map.put("thorn;", "\u00FE");
        map.put("thorn", "\u00FE");
        map.put("Tilde;", "\u223C");
        map.put("tilde;", "\u02DC");
        map.put("TildeEqual;", "\u2243");
        map.put("TildeFullEqual;", "\u2245");
        map.put("TildeTilde;", "\u2248");
        map.put("times;", "\u00D7");
        map.put("times", "\u00D7");
        map.put("timesb;", "\u22A0");
        map.put("timesbar;", "\u2A31");
        map.put("timesd;", "\u2A30");
        map.put("tint;", "\u222D");
        map.put("toea;", "\u2928");
        map.put("top;", "\u22A4");
        map.put("topbot;", "\u2336");
        map.put("topcir;", "\u2AF1");
        map.put("Topf;", "\uD54B");
        map.put("topf;", "\uD565");
        map.put("topfork;", "\u2ADA");
        map.put("tosa;", "\u2929");
        map.put("tprime;", "\u2034");
        map.put("TRADE;", "\u2122");
        map.put("trade;", "\u2122");
        map.put("triangle;", "\u25B5");
        map.put("triangledown;", "\u25BF");
        map.put("triangleleft;", "\u25C3");
        map.put("trianglelefteq;", "\u22B4");
        map.put("triangleq;", "\u225C");
        map.put("triangleright;", "\u25B9");
        map.put("trianglerighteq;", "\u22B5");
        map.put("tridot;", "\u25EC");
        map.put("trie;", "\u225C");
        map.put("triminus;", "\u2A3A");
        map.put("TripleDot;", "\u20DB");
        map.put("triplus;", "\u2A39");
        map.put("trisb;", "\u29CD");
        map.put("tritime;", "\u2A3B");
        map.put("trpezium;", "\u23E2");
        map.put("Tscr;", "\uD4AF");
        map.put("tscr;", "\uD4C9");
        map.put("TScy;", "\u0426");
        map.put("tscy;", "\u0446");
        map.put("TSHcy;", "\u040B");
        map.put("tshcy;", "\u045B");
        map.put("Tstrok;", "\u0166");
        map.put("tstrok;", "\u0167");
        map.put("twixt;", "\u226C");
        map.put("twoheadleftarrow;", "\u219E");
        map.put("twoheadrightarrow;", "\u21A0");
        map.put("Uacute;", "\u00DA");
        map.put("Uacute", "\u00DA");
        map.put("uacute;", "\u00FA");
        map.put("uacute", "\u00FA");
        map.put("Uarr;", "\u219F");
        map.put("uArr;", "\u21D1");
        map.put("uarr;", "\u2191");
        map.put("Uarrocir;", "\u2949");
        map.put("Ubrcy;", "\u040E");
        map.put("ubrcy;", "\u045E");
        map.put("Ubreve;", "\u016C");
        map.put("ubreve;", "\u016D");
        map.put("Ucirc;", "\u00DB");
        map.put("Ucirc", "\u00DB");
        map.put("ucirc;", "\u00FB");
        map.put("ucirc", "\u00FB");
        map.put("Ucy;", "\u0423");
        map.put("ucy;", "\u0443");
        map.put("udarr;", "\u21C5");
        map.put("Udblac;", "\u0170");
        map.put("udblac;", "\u0171");
        map.put("udhar;", "\u296E");
        map.put("ufisht;", "\u297E");
        map.put("Ufr;", "\uD518");
        map.put("ufr;", "\uD532");
        map.put("Ugrave;", "\u00D9");
        map.put("Ugrave", "\u00D9");
        map.put("ugrave;", "\u00F9");
        map.put("ugrave", "\u00F9");
        map.put("uHar;", "\u2963");
        map.put("uharl;", "\u21BF");
        map.put("uharr;", "\u21BE");
        map.put("uhblk;", "\u2580");
        map.put("ulcorn;", "\u231C");
        map.put("ulcorner;", "\u231C");
        map.put("ulcrop;", "\u230F");
        map.put("ultri;", "\u25F8");
        map.put("Umacr;", "\u016A");
        map.put("umacr;", "\u016B");
        map.put("uml;", "\u00A8");
        map.put("uml", "\u00A8");
        map.put("UnderBar;", "\u005F");
        map.put("UnderBrace;", "\u23DF");
        map.put("UnderBracket;", "\u23B5");
        map.put("UnderParenthesis;", "\u23DD");
        map.put("Union;", "\u22C3");
        map.put("UnionPlus;", "\u228E");
        map.put("Uogon;", "\u0172");
        map.put("uogon;", "\u0173");
        map.put("Uopf;", "\uD54C");
        map.put("uopf;", "\uD566");
        map.put("UpArrow;", "\u2191");
        map.put("Uparrow;", "\u21D1");
        map.put("uparrow;", "\u2191");
        map.put("UpArrowBar;", "\u2912");
        map.put("UpArrowDownArrow;", "\u21C5");
        map.put("UpDownArrow;", "\u2195");
        map.put("Updownarrow;", "\u21D5");
        map.put("updownarrow;", "\u2195");
        map.put("UpEquilibrium;", "\u296E");
        map.put("upharpoonleft;", "\u21BF");
        map.put("upharpoonright;", "\u21BE");
        map.put("uplus;", "\u228E");
        map.put("UpperLeftArrow;", "\u2196");
        map.put("UpperRightArrow;", "\u2197");
        map.put("Upsi;", "\u03D2");
        map.put("upsi;", "\u03C5");
        map.put("upsih;", "\u03D2");
        map.put("Upsilon;", "\u03A5");
        map.put("upsilon;", "\u03C5");
        map.put("UpTee;", "\u22A5");
        map.put("UpTeeArrow;", "\u21A5");
        map.put("upuparrows;", "\u21C8");
        map.put("urcorn;", "\u231D");
        map.put("urcorner;", "\u231D");
        map.put("urcrop;", "\u230E");
        map.put("Uring;", "\u016E");
        map.put("uring;", "\u016F");
        map.put("urtri;", "\u25F9");
        map.put("Uscr;", "\uD4B0");
        map.put("uscr;", "\uD4CA");
        map.put("utdot;", "\u22F0");
        map.put("Utilde;", "\u0168");
        map.put("utilde;", "\u0169");
        map.put("utri;", "\u25B5");
        map.put("utrif;", "\u25B4");
        map.put("uuarr;", "\u21C8");
        map.put("Uuml;", "\u00DC");
        map.put("Uuml", "\u00DC");
        map.put("uuml;", "\u00FC");
        map.put("uuml", "\u00FC");
        map.put("uwangle;", "\u29A7");
        map.put("vangrt;", "\u299C");
        map.put("varepsilon;", "\u03F5");
        map.put("varkappa;", "\u03F0");
        map.put("varnothing;", "\u2205");
        map.put("varphi;", "\u03D5");
        map.put("varpi;", "\u03D6");
        map.put("varpropto;", "\u221D");
        map.put("vArr;", "\u21D5");
        map.put("varr;", "\u2195");
        map.put("varrho;", "\u03F1");
        map.put("varsigma;", "\u03C2");
        map.put("varsubsetneq;", "\u228A\uFE00");
        map.put("varsubsetneqq;", "\u2ACB\uFE00");
        map.put("varsupsetneq;", "\u228B\uFE00");
        map.put("varsupsetneqq;", "\u2ACC\uFE00");
        map.put("vartheta;", "\u03D1");
        map.put("vartriangleleft;", "\u22B2");
        map.put("vartriangleright;", "\u22B3");
        map.put("Vbar;", "\u2AEB");
        map.put("vBar;", "\u2AE8");
        map.put("vBarv;", "\u2AE9");
        map.put("Vcy;", "\u0412");
        map.put("vcy;", "\u0432");
        map.put("VDash;", "\u22AB");
        map.put("Vdash;", "\u22A9");
        map.put("vDash;", "\u22A8");
        map.put("vdash;", "\u22A2");
        map.put("Vdashl;", "\u2AE6");
        map.put("Vee;", "\u22C1");
        map.put("vee;", "\u2228");
        map.put("veebar;", "\u22BB");
        map.put("veeeq;", "\u225A");
        map.put("vellip;", "\u22EE");
        map.put("Verbar;", "\u2016");
        map.put("verbar;", "\u007C");
        map.put("Vert;", "\u2016");
        map.put("vert;", "\u007C");
        map.put("VerticalBar;", "\u2223");
        map.put("VerticalLine;", "\u007C");
        map.put("VerticalSeparator;", "\u2758");
        map.put("VerticalTilde;", "\u2240");
        map.put("VeryThinSpace;", "\u200A");
        map.put("Vfr;", "\uD519");
        map.put("vfr;", "\uD533");
        map.put("vltri;", "\u22B2");
        map.put("vnsub;", "\u2282\u20D2");
        map.put("vnsup;", "\u2283\u20D2");
        map.put("Vopf;", "\uD54D");
        map.put("vopf;", "\uD567");
        map.put("vprop;", "\u221D");
        map.put("vrtri;", "\u22B3");
        map.put("Vscr;", "\uD4B1");
        map.put("vscr;", "\uD4CB");
        map.put("vsubnE;", "\u2ACB\uFE00");
        map.put("vsubne;", "\u228A\uFE00");
        map.put("vsupnE;", "\u2ACC\uFE00");
        map.put("vsupne;", "\u228B\uFE00");
        map.put("Vvdash;", "\u22AA");
        map.put("vzigzag;", "\u299A");
        map.put("Wcirc;", "\u0174");
        map.put("wcirc;", "\u0175");
        map.put("wedbar;", "\u2A5F");
        map.put("Wedge;", "\u22C0");
        map.put("wedge;", "\u2227");
        map.put("wedgeq;", "\u2259");
        map.put("weierp;", "\u2118");
        map.put("Wfr;", "\uD51A");
        map.put("wfr;", "\uD534");
        map.put("Wopf;", "\uD54E");
        map.put("wopf;", "\uD568");
        map.put("wp;", "\u2118");
        map.put("wr;", "\u2240");
        map.put("wreath;", "\u2240");
        map.put("Wscr;", "\uD4B2");
        map.put("wscr;", "\uD4CC");
        map.put("xcap;", "\u22C2");
        map.put("xcirc;", "\u25EF");
        map.put("xcup;", "\u22C3");
        map.put("xdtri;", "\u25BD");
        map.put("Xfr;", "\uD51B");
        map.put("xfr;", "\uD535");
        map.put("xhArr;", "\u27FA");
        map.put("xharr;", "\u27F7");
        map.put("Xi;", "\u039E");
        map.put("xi;", "\u03BE");
        map.put("xlArr;", "\u27F8");
        map.put("xlarr;", "\u27F5");
        map.put("xmap;", "\u27FC");
        map.put("xnis;", "\u22FB");
        map.put("xodot;", "\u2A00");
        map.put("Xopf;", "\uD54F");
        map.put("xopf;", "\uD569");
        map.put("xoplus;", "\u2A01");
        map.put("xotime;", "\u2A02");
        map.put("xrArr;", "\u27F9");
        map.put("xrarr;", "\u27F6");
        map.put("Xscr;", "\uD4B3");
        map.put("xscr;", "\uD4CD");
        map.put("xsqcup;", "\u2A06");
        map.put("xuplus;", "\u2A04");
        map.put("xutri;", "\u25B3");
        map.put("xvee;", "\u22C1");
        map.put("xwedge;", "\u22C0");
        map.put("Yacute;", "\u00DD");
        map.put("Yacute", "\u00DD");
        map.put("yacute;", "\u00FD");
        map.put("yacute", "\u00FD");
        map.put("YAcy;", "\u042F");
        map.put("yacy;", "\u044F");
        map.put("Ycirc;", "\u0176");
        map.put("ycirc;", "\u0177");
        map.put("Ycy;", "\u042B");
        map.put("ycy;", "\u044B");
        map.put("yen;", "\u00A5");
        map.put("yen", "\u00A5");
        map.put("Yfr;", "\uD51C");
        map.put("yfr;", "\uD536");
        map.put("YIcy;", "\u0407");
        map.put("yicy;", "\u0457");
        map.put("Yopf;", "\uD550");
        map.put("yopf;", "\uD56A");
        map.put("Yscr;", "\uD4B4");
        map.put("yscr;", "\uD4CE");
        map.put("YUcy;", "\u042E");
        map.put("yucy;", "\u044E");
        map.put("Yuml;", "\u0178");
        map.put("yuml;", "\u00FF");
        map.put("yuml", "\u00FF");
        map.put("Zacute;", "\u0179");
        map.put("zacute;", "\u017A");
        map.put("Zcaron;", "\u017D");
        map.put("zcaron;", "\u017E");
        map.put("Zcy;", "\u0417");
        map.put("zcy;", "\u0437");
        map.put("Zdot;", "\u017B");
        map.put("zdot;", "\u017C");
        map.put("zeetrf;", "\u2128");
        map.put("ZeroWidthSpace;", "\u200B");
        map.put("Zeta;", "\u0396");
        map.put("zeta;", "\u03B6");
        map.put("Zfr;", "\u2128");
        map.put("zfr;", "\uD537");
        map.put("ZHcy;", "\u0416");
        map.put("zhcy;", "\u0436");
        map.put("zigrarr;", "\u21DD");
        map.put("Zopf;", "\u2124");
        map.put("zopf;", "\uD56B");
        map.put("Zscr;", "\uD4B5");
        map.put("zscr;", "\uD4CF");
        map.put("zwj;", "\u200D");
        map.put("zwnj;", "\u200C");

        // non-standard TADS references
        map.put("emdash;", "\u2014");
        map.put("lsq;", "\u2018");
        map.put("rsq;", "\u2019");
        map.put("ldq;", "\u201C");
        map.put("rdq;", "\u201D");

        CREFS = Collections.unmodifiableMap(map);
    }

    private CharRef() {
        // don't allow instantiation
    }
}
