# Pull request template

* Please make sure you read and fill this template out entirely
* PRs that don't have the template filled out will be ignored

## Description

- Please include a summary of the change and which issue is fixed
- Please also include relevant motivation and context (Why is this change required? What problem does it solve?)
- List any dependencies that are required for this change
- If it fixes an open issue, plase link to the issue here

Fixes #(issue)

## Screenshots (if appropriate):

## Type of change

Please tick the relevant option by putting an X inside the bracket

- [ ] Bug fix (non-breaking change which fixes an issue)
- [ ] New feature (non-breaking change which adds functionality)
- [ ] Breaking change (fix or feature that would cause existing functionality to not work as expected)
- [ ] This change requires a documentation update

## Checklist:

- [ ] My code follows the guidelines of this project
- [ ] I have performed a self-review of my own code
- [ ] I have commented my code, particularly in hard-to-understand areas
- [ ] I have made corresponding changes to the documentation
- [ ] My changes generate no new warnings
- [ ] All current GitHub actions pass
- [ ] Any dependent changes have been merged and published in downstream modules
- [ ] I have checked my code and corrected any misspellings
- [ ] I have read the [CONTRIBUTING](../CONTRIBUTING.md) document
