// test lyapunov equation solver
import assert from 'assert'

import math from '../../../../src/defaultInstance.js'

describe('lyap', function () {
  it('should solve lyapunov equation of order 5 with Matrices', function () {
    assert.ok(math.norm(math.subtract(math.lyap(math.matrix([
      [-5.3, -1.4, -0.2, 0.7, 1.0],
      [-0.4, -1.0, -0.1, -1.2, 0.7],
      [0.3, 0.7, -2.5, 0.7, -0.3],
      [3.6, -0.1, 1.4, -2.4, 0.3],
      [2.8, 0.7, 1.4, 0.5, -4.8]
    ]), math.matrix([
      [-2, 0, 0, 0, 0],
      [0, -2, 0, 0, 0],
      [0, 0, -2, 0, 0],
      [0, 0, 0, -2, 0],
      [0, 0, 0, 0, -2]
    ])), math.matrix([
      [-0.8567032819332775, 1.6675327139319873, 0.05193348368861031, -1.2336381488442063, -0.3320481938129234],
      [1.6675327139319864, -4.577292046354884, -0.24491693525451969, 2.7566635155267862, 0.533179377606574],
      [0.05193348368861139, -0.24491693525452285, -0.4786127989547805, -0.10398529391846956, -0.10706505975853312],
      [-1.233638148844205, 2.7566635155267827, -0.10398529391847175, -2.5199807906596963, -0.6187026623519729],
      [-0.33204819381292294, 0.5331793776065724, -0.10706505975853345, -0.6187026623519725, -0.4199482902478158]
    ])), 'fro') < 1e-3)
  })

  it('should solve lyapunov equation of order 5 with Arrays', function () {
    assert.ok(math.norm(math.subtract(math.lyap([
      [-5.3, -1.4, -0.2, 0.7, 1.0],
      [-0.4, -1.0, -0.1, -1.2, 0.7],
      [0.3, 0.7, -2.5, 0.7, -0.3],
      [3.6, -0.1, 1.4, -2.4, 0.3],
      [2.8, 0.7, 1.4, 0.5, -4.8]
    ], [
      [-2, 0, 0, 0, 0],
      [0, -2, 0, 0, 0],
      [0, 0, -2, 0, 0],
      [0, 0, 0, -2, 0],
      [0, 0, 0, 0, -2]
    ]), [
      [-0.8567032819332775, 1.6675327139319873, 0.05193348368861031, -1.2336381488442063, -0.3320481938129234],
      [1.6675327139319864, -4.577292046354884, -0.24491693525451969, 2.7566635155267862, 0.533179377606574],
      [0.05193348368861139, -0.24491693525452285, -0.4786127989547805, -0.10398529391846956, -0.10706505975853312],
      [-1.233638148844205, 2.7566635155267827, -0.10398529391847175, -2.5199807906596963, -0.6187026623519729],
      [-0.33204819381292294, 0.5331793776065724, -0.10706505975853345, -0.6187026623519725, -0.4199482902478158]
    ]), 'fro') < 1e-3)
  })
})
