// test schur decomposition
import assert from 'assert'

import math from '../../../../../src/defaultInstance.js'

describe('schur', function () {
  it('should calculate schur decomposition of order 5 Array with numbers', function () {
    assert.ok(math.norm(math.subtract(math.schur([
      [-5.3, -1.4, -0.2, 0.7, 1.0],
      [-0.4, -1.0, -0.1, -1.2, 0.7],
      [0.3, 0.7, -2.5, 0.7, -0.3],
      [3.6, -0.1, 1.4, -2.4, 0.3],
      [2.8, 0.7, 1.4, 0.5, -4.8]
    ]).T, [
      [-6.97747746169558, 0.5046853036888738, -0.5269551218982134, 2.9902479419087253, -2.2914719859941908],
      [7.686296479877504e-28, -3.667202530573731, -1.3776362163231233, 0.4680921120934126, -0.374760141366345],
      [-4.92421882171775e-28, 0.0859443307361262, -3.798852922420336, 0.6595326982269121, 0.38704916773017245],
      [-1.8971150504442668e-71, -1.3481560449785515e-44, -8.960727665382592e-44, -1.3867791434503591, 0.5989746088924175],
      [5.3038070596554604e-164, -7.015716167009369e-138, 1.0415178925287816e-136, 3.3306222609902884e-93, -0.16968794185997693]
    ])) < 1e-3)
    assert.ok(math.norm(math.subtract(math.schur([
      [-5.3, -1.4, -0.2, 0.7, 1.0],
      [-0.4, -1.0, -0.1, -1.2, 0.7],
      [0.3, 0.7, -2.5, 0.7, -0.3],
      [3.6, -0.1, 1.4, -2.4, 0.3],
      [2.8, 0.7, 1.4, 0.5, -4.8]
    ]).U, [
      [0.6039524392527362, -0.11955248228665324, 0.5309978859071411, -0.3239619623824945, 0.48377530651243317],
      [0.034196874004165004, -0.3407725193032822, -0.05878741847605931, -0.7490924342670748, -0.5640117270489927],
      [-0.024973926752867345, 0.6355774530247909, -0.45835474572889245, -0.5151114453511857, 0.3463938944685342],
      [-0.42238909820980175, -0.6350073886392834, -0.26854304887535935, -0.13970317163522103, 0.5715948922294664],
      [-0.6745633977804205, 0.24977632323107185, 0.6575567219332444, -0.22147775183161147, 0.03380493473031572]
    ])) < 1e-3)
  })

  it('should calculate schur decomposition of order 5 Matrix with numbers', function () {
    assert.ok(math.norm(math.subtract(math.schur(math.matrix([
      [-5.3, -1.4, -0.2, 0.7, 1.0],
      [-0.4, -1.0, -0.1, -1.2, 0.7],
      [0.3, 0.7, -2.5, 0.7, -0.3],
      [3.6, -0.1, 1.4, -2.4, 0.3],
      [2.8, 0.7, 1.4, 0.5, -4.8]
    ])).T, math.matrix([
      [-6.97747746169558, 0.5046853036888738, -0.5269551218982134, 2.9902479419087253, -2.2914719859941908],
      [7.686296479877504e-28, -3.667202530573731, -1.3776362163231233, 0.4680921120934126, -0.374760141366345],
      [-4.92421882171775e-28, 0.0859443307361262, -3.798852922420336, 0.6595326982269121, 0.38704916773017245],
      [-1.8971150504442668e-71, -1.3481560449785515e-44, -8.960727665382592e-44, -1.3867791434503591, 0.5989746088924175],
      [5.3038070596554604e-164, -7.015716167009369e-138, 1.0415178925287816e-136, 3.3306222609902884e-93, -0.16968794185997693]
    ]))) < 1e-3)
    assert.ok(math.norm(math.subtract(math.schur(math.matrix([
      [-5.3, -1.4, -0.2, 0.7, 1.0],
      [-0.4, -1.0, -0.1, -1.2, 0.7],
      [0.3, 0.7, -2.5, 0.7, -0.3],
      [3.6, -0.1, 1.4, -2.4, 0.3],
      [2.8, 0.7, 1.4, 0.5, -4.8]
    ])).U, math.matrix([
      [0.6039524392527362, -0.11955248228665324, 0.5309978859071411, -0.3239619623824945, 0.48377530651243317],
      [0.034196874004165004, -0.3407725193032822, -0.05878741847605931, -0.7490924342670748, -0.5640117270489927],
      [-0.024973926752867345, 0.6355774530247909, -0.45835474572889245, -0.5151114453511857, 0.3463938944685342],
      [-0.42238909820980175, -0.6350073886392834, -0.26854304887535935, -0.13970317163522103, 0.5715948922294664],
      [-0.6745633977804205, 0.24977632323107185, 0.6575567219332444, -0.22147775183161147, 0.03380493473031572]
    ]))) < 1e-3)
  })
})
