/* Sinon.JS 21.0.0, 2025-06-13, @license BSD-3 */(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define([],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.sinon = f()}})(function(){var define,module,exports;return (function(){function r(e,n,t){function o(i,f){if(!n[i]){if(!e[i]){var c="function"==typeof require&&require;if(!f&&c)return c(i,!0);if(u)return u(i,!0);var a=new Error("Cannot find module '"+i+"'");throw a.code="MODULE_NOT_FOUND",a}var p=n[i]={exports:{}};e[i][0].call(p.exports,function(r){var n=e[i][1][r];return o(n||r)},p,p.exports,r,e,n,t)}return n[i].exports}for(var u="function"==typeof require&&require,i=0;i<t.length;i++)o(t[i]);return o}return r})()({1:[function(require,module,exports){
"use strict";

const behavior = require("./sinon/behavior");
const createSandbox = require("./sinon/create-sandbox");
const extend = require("./sinon/util/core/extend");
const fakeTimers = require("./sinon/util/fake-timers");
const Sandbox = require("./sinon/sandbox");
const stub = require("./sinon/stub");
const promise = require("./sinon/promise");

/**
 * @returns {object} a configured sandbox
 */
module.exports = function createApi() {
    const apiMethods = {
        createSandbox: createSandbox,
        match: require("@sinonjs/samsam").createMatcher,
        restoreObject: require("./sinon/restore-object"),

        expectation: require("./sinon/mock-expectation"),

        // fake timers
        timers: fakeTimers.timers,

        addBehavior: function (name, fn) {
            behavior.addBehavior(stub, name, fn);
        },

        // fake promise
        promise: promise,
    };

    const sandbox = new Sandbox();
    return extend(sandbox, apiMethods);
};

},{"./sinon/behavior":4,"./sinon/create-sandbox":7,"./sinon/mock-expectation":11,"./sinon/promise":13,"./sinon/restore-object":18,"./sinon/sandbox":19,"./sinon/stub":22,"./sinon/util/core/extend":25,"./sinon/util/fake-timers":39,"@sinonjs/samsam":86}],2:[function(require,module,exports){
"use strict";

const createApi = require("./create-sinon-api");

module.exports = createApi();

},{"./create-sinon-api":1}],3:[function(require,module,exports){
"use strict";
/** @module */

const arrayProto = require("@sinonjs/commons").prototypes.array;
const calledInOrder = require("@sinonjs/commons").calledInOrder;
const createMatcher = require("@sinonjs/samsam").createMatcher;
const orderByFirstCall = require("@sinonjs/commons").orderByFirstCall;
const timesInWords = require("./util/core/times-in-words");
const inspect = require("util").inspect;
const stringSlice = require("@sinonjs/commons").prototypes.string.slice;
const globalObject = require("@sinonjs/commons").global;

const arraySlice = arrayProto.slice;
const concat = arrayProto.concat;
const forEach = arrayProto.forEach;
const join = arrayProto.join;
const splice = arrayProto.splice;

function applyDefaults(obj, defaults) {
    for (const key of Object.keys(defaults)) {
        const val = obj[key];
        if (val === null || typeof val === "undefined") {
            obj[key] = defaults[key];
        }
    }
}

/**
 * @typedef {object} CreateAssertOptions
 * @global
 *
 * @property {boolean} [shouldLimitAssertionLogs] default is false
 * @property {number}  [assertionLogLimit] default is 10K
 */

/**
 * Create an assertion object that exposes several methods to invoke
 *
 * @param {CreateAssertOptions}  [opts] options bag
 * @returns {object} object with multiple assertion methods
 */
function createAssertObject(opts) {
    const cleanedAssertOptions = opts || {};
    applyDefaults(cleanedAssertOptions, {
        shouldLimitAssertionLogs: false,
        assertionLogLimit: 1e4,
    });

    const assert = {
        fail: function fail(message) {
            let msg = message;
            if (cleanedAssertOptions.shouldLimitAssertionLogs) {
                msg = message.substring(
                    0,
                    cleanedAssertOptions.assertionLogLimit,
                );
            }
            const error = new Error(msg);
            error.name = "AssertError";

            throw error;
        },

        pass: function pass() {
            return;
        },

        callOrder: function assertCallOrder() {
            verifyIsStub.apply(null, arguments);
            let expected = "";
            let actual = "";

            if (!calledInOrder(arguments)) {
                try {
                    expected = join(arguments, ", ");
                    const calls = arraySlice(arguments);
                    let i = calls.length;
                    while (i) {
                        if (!calls[--i].called) {
                            splice(calls, i, 1);
                        }
                    }
                    actual = join(orderByFirstCall(calls), ", ");
                } catch (e) {
                    // If this fails, we'll just fall back to the blank string
                }

                failAssertion(
                    this,
                    `expected ${expected} to be called in order but were called as ${actual}`,
                );
            } else {
                assert.pass("callOrder");
            }
        },

        callCount: function assertCallCount(method, count) {
            verifyIsStub(method);

            let msg;
            if (typeof count !== "number") {
                msg =
                    `expected ${inspect(count)} to be a number ` +
                    `but was of type ${typeof count}`;
                failAssertion(this, msg);
            } else if (method.callCount !== count) {
                msg =
                    `expected %n to be called ${timesInWords(count)} ` +
                    `but was called %c%C`;
                failAssertion(this, method.printf(msg));
            } else {
                assert.pass("callCount");
            }
        },

        expose: function expose(target, options) {
            if (!target) {
                throw new TypeError("target is null or undefined");
            }

            const o = options || {};
            const prefix =
                (typeof o.prefix === "undefined" && "assert") || o.prefix;
            const includeFail =
                typeof o.includeFail === "undefined" || Boolean(o.includeFail);
            const instance = this;

            forEach(Object.keys(instance), function (method) {
                if (
                    method !== "expose" &&
                    (includeFail || !/^(fail)/.test(method))
                ) {
                    target[exposedName(prefix, method)] = instance[method];
                }
            });

            return target;
        },

        match: function match(actual, expectation) {
            const matcher = createMatcher(expectation);
            if (matcher.test(actual)) {
                assert.pass("match");
            } else {
                const formatted = [
                    "expected value to match",
                    `    expected = ${inspect(expectation)}`,
                    `    actual = ${inspect(actual)}`,
                ];

                failAssertion(this, join(formatted, "\n"));
            }
        },
    };

    function verifyIsStub() {
        const args = arraySlice(arguments);

        forEach(args, function (method) {
            if (!method) {
                assert.fail("fake is not a spy");
            }

            if (method.proxy && method.proxy.isSinonProxy) {
                verifyIsStub(method.proxy);
            } else {
                if (typeof method !== "function") {
                    assert.fail(`${method} is not a function`);
                }

                if (typeof method.getCall !== "function") {
                    assert.fail(`${method} is not stubbed`);
                }
            }
        });
    }

    function verifyIsValidAssertion(assertionMethod, assertionArgs) {
        switch (assertionMethod) {
            case "notCalled":
            case "called":
            case "calledOnce":
            case "calledTwice":
            case "calledThrice":
                if (assertionArgs.length !== 0) {
                    assert.fail(
                        `${assertionMethod} takes 1 argument but was called with ${
                            assertionArgs.length + 1
                        } arguments`,
                    );
                }
                break;
            default:
                break;
        }
    }

    function failAssertion(object, msg) {
        const obj = object || globalObject;
        const failMethod = obj.fail || assert.fail;
        failMethod.call(obj, msg);
    }

    function mirrorPropAsAssertion(name, method, message) {
        let msg = message;
        let meth = method;
        if (arguments.length === 2) {
            msg = method;
            meth = name;
        }

        assert[name] = function (fake) {
            verifyIsStub(fake);

            const args = arraySlice(arguments, 1);
            let failed = false;

            verifyIsValidAssertion(name, args);

            if (typeof meth === "function") {
                failed = !meth(fake);
            } else {
                failed =
                    typeof fake[meth] === "function"
                        ? !fake[meth].apply(fake, args)
                        : !fake[meth];
            }

            if (failed) {
                failAssertion(
                    this,
                    (fake.printf || fake.proxy.printf).apply(
                        fake,
                        concat([msg], args),
                    ),
                );
            } else {
                assert.pass(name);
            }
        };
    }

    function exposedName(prefix, prop) {
        return !prefix || /^fail/.test(prop)
            ? prop
            : prefix +
                  stringSlice(prop, 0, 1).toUpperCase() +
                  stringSlice(prop, 1);
    }

    mirrorPropAsAssertion(
        "called",
        "expected %n to have been called at least once but was never called",
    );
    mirrorPropAsAssertion(
        "notCalled",
        function (spy) {
            return !spy.called;
        },
        "expected %n to not have been called but was called %c%C",
    );
    mirrorPropAsAssertion(
        "calledOnce",
        "expected %n to be called once but was called %c%C",
    );
    mirrorPropAsAssertion(
        "calledTwice",
        "expected %n to be called twice but was called %c%C",
    );
    mirrorPropAsAssertion(
        "calledThrice",
        "expected %n to be called thrice but was called %c%C",
    );
    mirrorPropAsAssertion(
        "calledOn",
        "expected %n to be called with %1 as this but was called with %t",
    );
    mirrorPropAsAssertion(
        "alwaysCalledOn",
        "expected %n to always be called with %1 as this but was called with %t",
    );
    mirrorPropAsAssertion("calledWithNew", "expected %n to be called with new");
    mirrorPropAsAssertion(
        "alwaysCalledWithNew",
        "expected %n to always be called with new",
    );
    mirrorPropAsAssertion(
        "calledWith",
        "expected %n to be called with arguments %D",
    );
    mirrorPropAsAssertion(
        "calledWithMatch",
        "expected %n to be called with match %D",
    );
    mirrorPropAsAssertion(
        "alwaysCalledWith",
        "expected %n to always be called with arguments %D",
    );
    mirrorPropAsAssertion(
        "alwaysCalledWithMatch",
        "expected %n to always be called with match %D",
    );
    mirrorPropAsAssertion(
        "calledWithExactly",
        "expected %n to be called with exact arguments %D",
    );
    mirrorPropAsAssertion(
        "calledOnceWithExactly",
        "expected %n to be called once and with exact arguments %D",
    );
    mirrorPropAsAssertion(
        "calledOnceWithMatch",
        "expected %n to be called once and with match %D",
    );
    mirrorPropAsAssertion(
        "alwaysCalledWithExactly",
        "expected %n to always be called with exact arguments %D",
    );
    mirrorPropAsAssertion(
        "neverCalledWith",
        "expected %n to never be called with arguments %*%C",
    );
    mirrorPropAsAssertion(
        "neverCalledWithMatch",
        "expected %n to never be called with match %*%C",
    );
    mirrorPropAsAssertion("threw", "%n did not throw exception%C");
    mirrorPropAsAssertion("alwaysThrew", "%n did not always throw exception%C");

    return assert;
}

module.exports = createAssertObject();
module.exports.createAssertObject = createAssertObject;

},{"./util/core/times-in-words":35,"@sinonjs/commons":46,"@sinonjs/samsam":86,"util":90}],4:[function(require,module,exports){
"use strict";

const arrayProto = require("@sinonjs/commons").prototypes.array;
const extend = require("./util/core/extend");
const functionName = require("@sinonjs/commons").functionName;
const nextTick = require("./util/core/next-tick");
const valueToString = require("@sinonjs/commons").valueToString;
const exportAsyncBehaviors = require("./util/core/export-async-behaviors");

const concat = arrayProto.concat;
const join = arrayProto.join;
const reverse = arrayProto.reverse;
const slice = arrayProto.slice;

const useLeftMostCallback = -1;
const useRightMostCallback = -2;

function getCallback(behavior, args) {
    const callArgAt = behavior.callArgAt;

    if (callArgAt >= 0) {
        return args[callArgAt];
    }

    let argumentList;

    if (callArgAt === useLeftMostCallback) {
        argumentList = args;
    }

    if (callArgAt === useRightMostCallback) {
        argumentList = reverse(slice(args));
    }

    const callArgProp = behavior.callArgProp;

    for (let i = 0, l = argumentList.length; i < l; ++i) {
        if (!callArgProp && typeof argumentList[i] === "function") {
            return argumentList[i];
        }

        if (
            callArgProp &&
            argumentList[i] &&
            typeof argumentList[i][callArgProp] === "function"
        ) {
            return argumentList[i][callArgProp];
        }
    }

    return null;
}

function getCallbackError(behavior, func, args) {
    if (behavior.callArgAt < 0) {
        let msg;

        if (behavior.callArgProp) {
            msg = `${functionName(
                behavior.stub,
            )} expected to yield to '${valueToString(
                behavior.callArgProp,
            )}', but no object with such a property was passed.`;
        } else {
            msg = `${functionName(
                behavior.stub,
            )} expected to yield, but no callback was passed.`;
        }

        if (args.length > 0) {
            msg += ` Received [${join(args, ", ")}]`;
        }

        return msg;
    }

    return `argument at index ${behavior.callArgAt} is not a function: ${func}`;
}

function ensureArgs(name, behavior, args) {
    // map function name to internal property
    //   callsArg => callArgAt
    const property = name.replace(/sArg/, "ArgAt");
    const index = behavior[property];

    if (index >= args.length) {
        throw new TypeError(
            `${name} failed: ${index + 1} arguments required but only ${
                args.length
            } present`,
        );
    }
}

function callCallback(behavior, args) {
    if (typeof behavior.callArgAt === "number") {
        ensureArgs("callsArg", behavior, args);
        const func = getCallback(behavior, args);

        if (typeof func !== "function") {
            throw new TypeError(getCallbackError(behavior, func, args));
        }

        if (behavior.callbackAsync) {
            nextTick(function () {
                func.apply(
                    behavior.callbackContext,
                    behavior.callbackArguments,
                );
            });
        } else {
            return func.apply(
                behavior.callbackContext,
                behavior.callbackArguments,
            );
        }
    }

    return undefined;
}

const proto = {
    create: function create(stub) {
        const behavior = extend({}, proto);
        delete behavior.create;
        delete behavior.addBehavior;
        delete behavior.createBehavior;
        behavior.stub = stub;

        if (stub.defaultBehavior && stub.defaultBehavior.promiseLibrary) {
            behavior.promiseLibrary = stub.defaultBehavior.promiseLibrary;
        }

        return behavior;
    },

    isPresent: function isPresent() {
        return (
            typeof this.callArgAt === "number" ||
            this.exception ||
            this.exceptionCreator ||
            typeof this.returnArgAt === "number" ||
            this.returnThis ||
            typeof this.resolveArgAt === "number" ||
            this.resolveThis ||
            typeof this.throwArgAt === "number" ||
            this.fakeFn ||
            this.returnValueDefined
        );
    },

    /*eslint complexity: ["error", 20]*/
    invoke: function invoke(context, args) {
        /*
         * callCallback (conditionally) calls ensureArgs
         *
         * Note: callCallback intentionally happens before
         * everything else and cannot be moved lower
         */
        const returnValue = callCallback(this, args);

        if (this.exception) {
            throw this.exception;
        } else if (this.exceptionCreator) {
            this.exception = this.exceptionCreator();
            this.exceptionCreator = undefined;
            throw this.exception;
        } else if (typeof this.returnArgAt === "number") {
            ensureArgs("returnsArg", this, args);
            return args[this.returnArgAt];
        } else if (this.returnThis) {
            return context;
        } else if (typeof this.throwArgAt === "number") {
            ensureArgs("throwsArg", this, args);
            throw args[this.throwArgAt];
        } else if (this.fakeFn) {
            return this.fakeFn.apply(context, args);
        } else if (typeof this.resolveArgAt === "number") {
            ensureArgs("resolvesArg", this, args);
            return (this.promiseLibrary || Promise).resolve(
                args[this.resolveArgAt],
            );
        } else if (this.resolveThis) {
            return (this.promiseLibrary || Promise).resolve(context);
        } else if (this.resolve) {
            return (this.promiseLibrary || Promise).resolve(this.returnValue);
        } else if (this.reject) {
            return (this.promiseLibrary || Promise).reject(this.returnValue);
        } else if (this.callsThrough) {
            const wrappedMethod = this.effectiveWrappedMethod();

            return wrappedMethod.apply(context, args);
        } else if (this.callsThroughWithNew) {
            // Get the original method (assumed to be a constructor in this case)
            const WrappedClass = this.effectiveWrappedMethod();
            // Turn the arguments object into a normal array
            const argsArray = slice(args);
            // Call the constructor
            const F = WrappedClass.bind.apply(
                WrappedClass,
                concat([null], argsArray),
            );
            return new F();
        } else if (typeof this.returnValue !== "undefined") {
            return this.returnValue;
        } else if (typeof this.callArgAt === "number") {
            return returnValue;
        }

        return this.returnValue;
    },

    effectiveWrappedMethod: function effectiveWrappedMethod() {
        for (let stubb = this.stub; stubb; stubb = stubb.parent) {
            if (stubb.wrappedMethod) {
                return stubb.wrappedMethod;
            }
        }
        throw new Error("Unable to find wrapped method");
    },

    onCall: function onCall(index) {
        return this.stub.onCall(index);
    },

    onFirstCall: function onFirstCall() {
        return this.stub.onFirstCall();
    },

    onSecondCall: function onSecondCall() {
        return this.stub.onSecondCall();
    },

    onThirdCall: function onThirdCall() {
        return this.stub.onThirdCall();
    },

    withArgs: function withArgs(/* arguments */) {
        throw new Error(
            'Defining a stub by invoking "stub.onCall(...).withArgs(...)" ' +
                'is not supported. Use "stub.withArgs(...).onCall(...)" ' +
                "to define sequential behavior for calls with certain arguments.",
        );
    },
};

function createBehavior(behaviorMethod) {
    return function () {
        this.defaultBehavior = this.defaultBehavior || proto.create(this);
        this.defaultBehavior[behaviorMethod].apply(
            this.defaultBehavior,
            arguments,
        );
        return this;
    };
}

function addBehavior(stub, name, fn) {
    proto[name] = function () {
        fn.apply(this, concat([this], slice(arguments)));
        return this.stub || this;
    };

    stub[name] = createBehavior(name);
}

proto.addBehavior = addBehavior;
proto.createBehavior = createBehavior;

const asyncBehaviors = exportAsyncBehaviors(proto);

module.exports = extend.nonEnum({}, proto, asyncBehaviors);

},{"./util/core/export-async-behaviors":24,"./util/core/extend":25,"./util/core/next-tick":33,"@sinonjs/commons":46}],5:[function(require,module,exports){
"use strict";

const walk = require("./util/core/walk");
const getPropertyDescriptor = require("./util/core/get-property-descriptor");
const hasOwnProperty =
    require("@sinonjs/commons").prototypes.object.hasOwnProperty;
const push = require("@sinonjs/commons").prototypes.array.push;

function collectMethod(methods, object, prop, propOwner) {
    if (
        typeof getPropertyDescriptor(propOwner, prop).value === "function" &&
        hasOwnProperty(object, prop)
    ) {
        push(methods, object[prop]);
    }
}

// This function returns an array of all the own methods on the passed object
function collectOwnMethods(object) {
    const methods = [];

    walk(object, collectMethod.bind(null, methods, object));

    return methods;
}

module.exports = collectOwnMethods;

},{"./util/core/get-property-descriptor":28,"./util/core/walk":37,"@sinonjs/commons":46}],6:[function(require,module,exports){
"use strict";

module.exports = class Colorizer {
    constructor(supportsColor = require("supports-color")) {
        this.supportsColor = supportsColor;
    }

    /**
     * Should be renamed to true #privateField
     * when we can ensure ES2022 support
     *
     * @private
     */
    colorize(str, color) {
        if (this.supportsColor.stdout === false) {
            return str;
        }

        return `\x1b[${color}m${str}\x1b[0m`;
    }

    red(str) {
        return this.colorize(str, 31);
    }

    green(str) {
        return this.colorize(str, 32);
    }

    cyan(str) {
        return this.colorize(str, 96);
    }

    white(str) {
        return this.colorize(str, 39);
    }

    bold(str) {
        return this.colorize(str, 1);
    }
};

},{"supports-color":93}],7:[function(require,module,exports){
"use strict";

const arrayProto = require("@sinonjs/commons").prototypes.array;
const Sandbox = require("./sandbox");

const forEach = arrayProto.forEach;
const push = arrayProto.push;

function prepareSandboxFromConfig(config) {
    const sandbox = new Sandbox({ assertOptions: config.assertOptions });

    if (config.useFakeTimers) {
        if (typeof config.useFakeTimers === "object") {
            sandbox.useFakeTimers(config.useFakeTimers);
        } else {
            sandbox.useFakeTimers();
        }
    }

    return sandbox;
}

function exposeValue(sandbox, config, key, value) {
    if (!value) {
        return;
    }

    if (config.injectInto && !(key in config.injectInto)) {
        config.injectInto[key] = value;
        push(sandbox.injectedKeys, key);
    } else {
        push(sandbox.args, value);
    }
}

/**
 * Options to customize a sandbox
 *
 * The sandbox's methods can be injected into another object for
 * convenience. The `injectInto` configuration option can name an
 * object to add properties to.
 *
 * @typedef {object} SandboxConfig
 * @property {string[]} properties The properties of the API to expose on the sandbox. Examples: ['spy', 'fake', 'restore']
 * @property {object} injectInto an object in which to inject properties from the sandbox (a facade). This is mostly an integration feature (sinon-test being one).
 * @property {boolean} useFakeTimers  whether timers are faked by default
 * @property {object} [assertOptions] see CreateAssertOptions in ./assert
 *
 * This type def is really suffering from JSDoc not having standardized
 * how to reference types defined in other modules :(
 */

/**
 * A configured sinon sandbox (private type)
 *
 * @typedef {object} ConfiguredSinonSandboxType
 * @private
 * @augments Sandbox
 * @property {string[]} injectedKeys the keys that have been injected (from config.injectInto)
 * @property {*[]} args the arguments for the sandbox
 */

/**
 * Create a sandbox
 *
 * As of Sinon 5 the `sinon` instance itself is a Sandbox, so you
 * hardly ever need to create additional instances for the sake of testing
 *
 * @param config {SandboxConfig}
 * @returns {Sandbox}
 */
function createSandbox(config) {
    if (!config) {
        return new Sandbox();
    }

    const configuredSandbox = prepareSandboxFromConfig(config);
    configuredSandbox.args = configuredSandbox.args || [];
    configuredSandbox.injectedKeys = [];
    configuredSandbox.injectInto = config.injectInto;
    const exposed = configuredSandbox.inject({});

    if (config.properties) {
        forEach(config.properties, function (prop) {
            const value =
                exposed[prop] || (prop === "sandbox" && configuredSandbox);
            exposeValue(configuredSandbox, config, prop, value);
        });
    } else {
        exposeValue(configuredSandbox, config, "sandbox");
    }

    return configuredSandbox;
}

module.exports = createSandbox;

},{"./sandbox":19,"@sinonjs/commons":46}],8:[function(require,module,exports){
"use strict";

const stub = require("./stub");
const sinonType = require("./util/core/sinon-type");
const forEach = require("@sinonjs/commons").prototypes.array.forEach;

function isStub(value) {
    return sinonType.get(value) === "stub";
}

module.exports = function createStubInstance(constructor, overrides) {
    if (typeof constructor !== "function") {
        throw new TypeError("The constructor should be a function.");
    }

    const stubInstance = Object.create(constructor.prototype);
    sinonType.set(stubInstance, "stub-instance");

    const stubbedObject = stub(stubInstance);

    forEach(Object.keys(overrides || {}), function (propertyName) {
        if (propertyName in stubbedObject) {
            const value = overrides[propertyName];
            if (isStub(value)) {
                stubbedObject[propertyName] = value;
            } else {
                stubbedObject[propertyName].returns(value);
            }
        } else {
            throw new Error(
                `Cannot stub ${propertyName}. Property does not exist!`,
            );
        }
    });
    return stubbedObject;
};

},{"./stub":22,"./util/core/sinon-type":34,"@sinonjs/commons":46}],9:[function(require,module,exports){
"use strict";

const arrayProto = require("@sinonjs/commons").prototypes.array;
const isPropertyConfigurable = require("./util/core/is-property-configurable");
const exportAsyncBehaviors = require("./util/core/export-async-behaviors");
const extend = require("./util/core/extend");

const slice = arrayProto.slice;

const useLeftMostCallback = -1;
const useRightMostCallback = -2;

function throwsException(fake, error, message) {
    if (typeof error === "function") {
        fake.exceptionCreator = error;
    } else if (typeof error === "string") {
        fake.exceptionCreator = function () {
            const newException = new Error(
                message || `Sinon-provided ${error}`,
            );
            newException.name = error;
            return newException;
        };
    } else if (!error) {
        fake.exceptionCreator = function () {
            return new Error("Error");
        };
    } else {
        fake.exception = error;
    }
}

const defaultBehaviors = {
    callsFake: function callsFake(fake, fn) {
        fake.fakeFn = fn;
        fake.exception = undefined;
        fake.exceptionCreator = undefined;
        fake.callsThrough = false;
    },

    callsArg: function callsArg(fake, index) {
        if (typeof index !== "number") {
            throw new TypeError("argument index is not number");
        }

        fake.callArgAt = index;
        fake.callbackArguments = [];
        fake.callbackContext = undefined;
        fake.callArgProp = undefined;
        fake.callbackAsync = false;
        fake.callsThrough = false;
    },

    callsArgOn: function callsArgOn(fake, index, context) {
        if (typeof index !== "number") {
            throw new TypeError("argument index is not number");
        }

        fake.callArgAt = index;
        fake.callbackArguments = [];
        fake.callbackContext = context;
        fake.callArgProp = undefined;
        fake.callbackAsync = false;
        fake.callsThrough = false;
    },

    callsArgWith: function callsArgWith(fake, index) {
        if (typeof index !== "number") {
            throw new TypeError("argument index is not number");
        }

        fake.callArgAt = index;
        fake.callbackArguments = slice(arguments, 2);
        fake.callbackContext = undefined;
        fake.callArgProp = undefined;
        fake.callbackAsync = false;
        fake.callsThrough = false;
    },

    callsArgOnWith: function callsArgWith(fake, index, context) {
        if (typeof index !== "number") {
            throw new TypeError("argument index is not number");
        }

        fake.callArgAt = index;
        fake.callbackArguments = slice(arguments, 3);
        fake.callbackContext = context;
        fake.callArgProp = undefined;
        fake.callbackAsync = false;
        fake.callsThrough = false;
    },

    yields: function (fake) {
        fake.callArgAt = useLeftMostCallback;
        fake.callbackArguments = slice(arguments, 1);
        fake.callbackContext = undefined;
        fake.callArgProp = undefined;
        fake.callbackAsync = false;
        fake.fakeFn = undefined;
        fake.callsThrough = false;
    },

    yieldsRight: function (fake) {
        fake.callArgAt = useRightMostCallback;
        fake.callbackArguments = slice(arguments, 1);
        fake.callbackContext = undefined;
        fake.callArgProp = undefined;
        fake.callbackAsync = false;
        fake.callsThrough = false;
        fake.fakeFn = undefined;
    },

    yieldsOn: function (fake, context) {
        fake.callArgAt = useLeftMostCallback;
        fake.callbackArguments = slice(arguments, 2);
        fake.callbackContext = context;
        fake.callArgProp = undefined;
        fake.callbackAsync = false;
        fake.callsThrough = false;
        fake.fakeFn = undefined;
    },

    yieldsTo: function (fake, prop) {
        fake.callArgAt = useLeftMostCallback;
        fake.callbackArguments = slice(arguments, 2);
        fake.callbackContext = undefined;
        fake.callArgProp = prop;
        fake.callbackAsync = false;
        fake.callsThrough = false;
        fake.fakeFn = undefined;
    },

    yieldsToOn: function (fake, prop, context) {
        fake.callArgAt = useLeftMostCallback;
        fake.callbackArguments = slice(arguments, 3);
        fake.callbackContext = context;
        fake.callArgProp = prop;
        fake.callbackAsync = false;
        fake.fakeFn = undefined;
    },

    throws: throwsException,
    throwsException: throwsException,

    returns: function returns(fake, value) {
        fake.callsThrough = false;
        fake.returnValue = value;
        fake.resolve = false;
        fake.reject = false;
        fake.returnValueDefined = true;
        fake.exception = undefined;
        fake.exceptionCreator = undefined;
        fake.fakeFn = undefined;
    },

    returnsArg: function returnsArg(fake, index) {
        if (typeof index !== "number") {
            throw new TypeError("argument index is not number");
        }
        fake.callsThrough = false;

        fake.returnArgAt = index;
    },

    throwsArg: function throwsArg(fake, index) {
        if (typeof index !== "number") {
            throw new TypeError("argument index is not number");
        }
        fake.callsThrough = false;

        fake.throwArgAt = index;
    },

    returnsThis: function returnsThis(fake) {
        fake.returnThis = true;
        fake.callsThrough = false;
    },

    resolves: function resolves(fake, value) {
        fake.returnValue = value;
        fake.resolve = true;
        fake.resolveThis = false;
        fake.reject = false;
        fake.returnValueDefined = true;
        fake.exception = undefined;
        fake.exceptionCreator = undefined;
        fake.fakeFn = undefined;
        fake.callsThrough = false;
    },

    resolvesArg: function resolvesArg(fake, index) {
        if (typeof index !== "number") {
            throw new TypeError("argument index is not number");
        }
        fake.resolveArgAt = index;
        fake.returnValue = undefined;
        fake.resolve = true;
        fake.resolveThis = false;
        fake.reject = false;
        fake.returnValueDefined = false;
        fake.exception = undefined;
        fake.exceptionCreator = undefined;
        fake.fakeFn = undefined;
        fake.callsThrough = false;
    },

    rejects: function rejects(fake, error, message) {
        let reason;
        if (typeof error === "string") {
            reason = new Error(message || "");
            reason.name = error;
        } else if (!error) {
            reason = new Error("Error");
        } else {
            reason = error;
        }
        fake.returnValue = reason;
        fake.resolve = false;
        fake.resolveThis = false;
        fake.reject = true;
        fake.returnValueDefined = true;
        fake.exception = undefined;
        fake.exceptionCreator = undefined;
        fake.fakeFn = undefined;
        fake.callsThrough = false;

        return fake;
    },

    resolvesThis: function resolvesThis(fake) {
        fake.returnValue = undefined;
        fake.resolve = false;
        fake.resolveThis = true;
        fake.reject = false;
        fake.returnValueDefined = false;
        fake.exception = undefined;
        fake.exceptionCreator = undefined;
        fake.fakeFn = undefined;
        fake.callsThrough = false;
    },

    callThrough: function callThrough(fake) {
        fake.callsThrough = true;
    },

    callThroughWithNew: function callThroughWithNew(fake) {
        fake.callsThroughWithNew = true;
    },

    get: function get(fake, getterFunction) {
        const rootStub = fake.stub || fake;

        Object.defineProperty(rootStub.rootObj, rootStub.propName, {
            get: getterFunction,
            configurable: isPropertyConfigurable(
                rootStub.rootObj,
                rootStub.propName,
            ),
        });

        return fake;
    },

    set: function set(fake, setterFunction) {
        const rootStub = fake.stub || fake;

        Object.defineProperty(
            rootStub.rootObj,
            rootStub.propName,
            // eslint-disable-next-line accessor-pairs
            {
                set: setterFunction,
                configurable: isPropertyConfigurable(
                    rootStub.rootObj,
                    rootStub.propName,
                ),
            },
        );

        return fake;
    },

    value: function value(fake, newVal) {
        const rootStub = fake.stub || fake;

        Object.defineProperty(rootStub.rootObj, rootStub.propName, {
            value: newVal,
            enumerable: true,
            writable: true,
            configurable:
                rootStub.shadowsPropOnPrototype ||
                isPropertyConfigurable(rootStub.rootObj, rootStub.propName),
        });

        return fake;
    },
};

const asyncBehaviors = exportAsyncBehaviors(defaultBehaviors);

module.exports = extend({}, defaultBehaviors, asyncBehaviors);

},{"./util/core/export-async-behaviors":24,"./util/core/extend":25,"./util/core/is-property-configurable":31,"@sinonjs/commons":46}],10:[function(require,module,exports){
"use strict";

const arrayProto = require("@sinonjs/commons").prototypes.array;
const createProxy = require("./proxy");
const nextTick = require("./util/core/next-tick");

const slice = arrayProto.slice;

module.exports = fake;

/**
 * Returns a `fake` that records all calls, arguments and return values.
 *
 * When an `f` argument is supplied, this implementation will be used.
 *
 * @example
 * // create an empty fake
 * var f1 = sinon.fake();
 *
 * f1();
 *
 * f1.calledOnce()
 * // true
 *
 * @example
 * function greet(greeting) {
 *   console.log(`Hello ${greeting}`);
 * }
 *
 * // create a fake with implementation
 * var f2 = sinon.fake(greet);
 *
 * // Hello world
 * f2("world");
 *
 * f2.calledWith("world");
 * // true
 *
 * @param {Function|undefined} f
 * @returns {Function}
 * @namespace
 */
function fake(f) {
    if (arguments.length > 0 && typeof f !== "function") {
        throw new TypeError("Expected f argument to be a Function");
    }

    return wrapFunc(f);
}

/**
 * Creates a `fake` that returns the provided `value`, as well as recording all
 * calls, arguments and return values.
 *
 * @example
 * var f1 = sinon.fake.returns(42);
 *
 * f1();
 * // 42
 *
 * @memberof fake
 * @param {*} value
 * @returns {Function}
 */
fake.returns = function returns(value) {
    // eslint-disable-next-line jsdoc/require-jsdoc
    function f() {
        return value;
    }

    return wrapFunc(f);
};

/**
 * Creates a `fake` that throws an Error.
 * If the `value` argument does not have Error in its prototype chain, it will
 * be used for creating a new error.
 *
 * @example
 * var f1 = sinon.fake.throws("hello");
 *
 * f1();
 * // Uncaught Error: hello
 *
 * @example
 * var f2 = sinon.fake.throws(new TypeError("Invalid argument"));
 *
 * f2();
 * // Uncaught TypeError: Invalid argument
 *
 * @memberof fake
 * @param {*|Error} value
 * @returns {Function}
 */
fake.throws = function throws(value) {
    // eslint-disable-next-line jsdoc/require-jsdoc
    function f() {
        throw getError(value);
    }

    return wrapFunc(f);
};

/**
 * Creates a `fake` that returns a promise that resolves to the passed `value`
 * argument.
 *
 * @example
 * var f1 = sinon.fake.resolves("apple pie");
 *
 * await f1();
 * // "apple pie"
 *
 * @memberof fake
 * @param {*} value
 * @returns {Function}
 */
fake.resolves = function resolves(value) {
    // eslint-disable-next-line jsdoc/require-jsdoc
    function f() {
        return Promise.resolve(value);
    }

    return wrapFunc(f);
};

/**
 * Creates a `fake` that returns a promise that rejects to the passed `value`
 * argument. When `value` does not have Error in its prototype chain, it will be
 * wrapped in an Error.
 *
 * @example
 * var f1 = sinon.fake.rejects(":(");
 *
 * try {
 *   await f1();
 * } catch (error) {
 *   console.log(error);
 *   // ":("
 * }
 *
 * @memberof fake
 * @param {*} value
 * @returns {Function}
 */
fake.rejects = function rejects(value) {
    // eslint-disable-next-line jsdoc/require-jsdoc
    function f() {
        return Promise.reject(getError(value));
    }

    return wrapFunc(f);
};

/**
 * Returns a `fake` that calls the callback with the defined arguments.
 *
 * @example
 * function callback() {
 *   console.log(arguments.join("*"));
 * }
 *
 * const f1 = sinon.fake.yields("apple", "pie");
 *
 * f1(callback);
 * // "apple*pie"
 *
 * @memberof fake
 * @returns {Function}
 */
fake.yields = function yields() {
    const values = slice(arguments);

    // eslint-disable-next-line jsdoc/require-jsdoc
    function f() {
        const callback = arguments[arguments.length - 1];
        if (typeof callback !== "function") {
            throw new TypeError("Expected last argument to be a function");
        }

        callback.apply(null, values);
    }

    return wrapFunc(f);
};

/**
 * Returns a `fake` that calls the callback **asynchronously** with the
 * defined arguments.
 *
 * @example
 * function callback() {
 *   console.log(arguments.join("*"));
 * }
 *
 * const f1 = sinon.fake.yields("apple", "pie");
 *
 * f1(callback);
 *
 * setTimeout(() => {
 *   // "apple*pie"
 * });
 *
 * @memberof fake
 * @returns {Function}
 */
fake.yieldsAsync = function yieldsAsync() {
    const values = slice(arguments);

    // eslint-disable-next-line jsdoc/require-jsdoc
    function f() {
        const callback = arguments[arguments.length - 1];
        if (typeof callback !== "function") {
            throw new TypeError("Expected last argument to be a function");
        }
        nextTick(function () {
            callback.apply(null, values);
        });
    }

    return wrapFunc(f);
};

let uuid = 0;
/**
 * Creates a proxy (sinon concept) from the passed function.
 *
 * @private
 * @param  {Function} f
 * @returns {Function}
 */
function wrapFunc(f) {
    const fakeInstance = function () {
        let firstArg, lastArg;

        if (arguments.length > 0) {
            firstArg = arguments[0];
            lastArg = arguments[arguments.length - 1];
        }

        const callback =
            lastArg && typeof lastArg === "function" ? lastArg : undefined;

        /* eslint-disable no-use-before-define */
        proxy.firstArg = firstArg;
        proxy.lastArg = lastArg;
        proxy.callback = callback;

        return f && f.apply(this, arguments);
    };
    const proxy = createProxy(fakeInstance, f || fakeInstance);

    proxy.displayName = "fake";
    proxy.id = `fake#${uuid++}`;

    return proxy;
}

/**
 * Returns an Error instance from the passed value, if the value is not
 * already an Error instance.
 *
 * @private
 * @param  {*} value [description]
 * @returns {Error}       [description]
 */
function getError(value) {
    return value instanceof Error ? value : new Error(value);
}

},{"./proxy":17,"./util/core/next-tick":33,"@sinonjs/commons":46}],11:[function(require,module,exports){
"use strict";

const arrayProto = require("@sinonjs/commons").prototypes.array;
const proxyInvoke = require("./proxy-invoke");
const proxyCallToString = require("./proxy-call").toString;
const timesInWords = require("./util/core/times-in-words");
const extend = require("./util/core/extend");
const match = require("@sinonjs/samsam").createMatcher;
const stub = require("./stub");
const assert = require("./assert");
const deepEqual = require("@sinonjs/samsam").deepEqual;
const inspect = require("util").inspect;
const valueToString = require("@sinonjs/commons").valueToString;

const every = arrayProto.every;
const forEach = arrayProto.forEach;
const push = arrayProto.push;
const slice = arrayProto.slice;

function callCountInWords(callCount) {
    if (callCount === 0) {
        return "never called";
    }

    return `called ${timesInWords(callCount)}`;
}

function expectedCallCountInWords(expectation) {
    const min = expectation.minCalls;
    const max = expectation.maxCalls;

    if (typeof min === "number" && typeof max === "number") {
        let str = timesInWords(min);

        if (min !== max) {
            str = `at least ${str} and at most ${timesInWords(max)}`;
        }

        return str;
    }

    if (typeof min === "number") {
        return `at least ${timesInWords(min)}`;
    }

    return `at most ${timesInWords(max)}`;
}

function receivedMinCalls(expectation) {
    const hasMinLimit = typeof expectation.minCalls === "number";
    return !hasMinLimit || expectation.callCount >= expectation.minCalls;
}

function receivedMaxCalls(expectation) {
    if (typeof expectation.maxCalls !== "number") {
        return false;
    }

    return expectation.callCount === expectation.maxCalls;
}

function verifyMatcher(possibleMatcher, arg) {
    const isMatcher = match.isMatcher(possibleMatcher);

    return (isMatcher && possibleMatcher.test(arg)) || true;
}

const mockExpectation = {
    minCalls: 1,
    maxCalls: 1,

    create: function create(methodName) {
        const expectation = extend.nonEnum(stub(), mockExpectation);
        delete expectation.create;
        expectation.method = methodName;

        return expectation;
    },

    invoke: function invoke(func, thisValue, args) {
        this.verifyCallAllowed(thisValue, args);

        return proxyInvoke.apply(this, arguments);
    },

    atLeast: function atLeast(num) {
        if (typeof num !== "number") {
            throw new TypeError(`'${valueToString(num)}' is not number`);
        }

        if (!this.limitsSet) {
            this.maxCalls = null;
            this.limitsSet = true;
        }

        this.minCalls = num;

        return this;
    },

    atMost: function atMost(num) {
        if (typeof num !== "number") {
            throw new TypeError(`'${valueToString(num)}' is not number`);
        }

        if (!this.limitsSet) {
            this.minCalls = null;
            this.limitsSet = true;
        }

        this.maxCalls = num;

        return this;
    },

    never: function never() {
        return this.exactly(0);
    },

    once: function once() {
        return this.exactly(1);
    },

    twice: function twice() {
        return this.exactly(2);
    },

    thrice: function thrice() {
        return this.exactly(3);
    },

    exactly: function exactly(num) {
        if (typeof num !== "number") {
            throw new TypeError(`'${valueToString(num)}' is not a number`);
        }

        this.atLeast(num);
        return this.atMost(num);
    },

    met: function met() {
        return !this.failed && receivedMinCalls(this);
    },

    verifyCallAllowed: function verifyCallAllowed(thisValue, args) {
        const expectedArguments = this.expectedArguments;

        if (receivedMaxCalls(this)) {
            this.failed = true;
            mockExpectation.fail(
                `${this.method} already called ${timesInWords(this.maxCalls)}`,
            );
        }

        if ("expectedThis" in this && this.expectedThis !== thisValue) {
            mockExpectation.fail(
                `${this.method} called with ${valueToString(
                    thisValue,
                )} as thisValue, expected ${valueToString(this.expectedThis)}`,
            );
        }

        if (!("expectedArguments" in this)) {
            return;
        }

        if (!args) {
            mockExpectation.fail(
                `${this.method} received no arguments, expected ${inspect(
                    expectedArguments,
                )}`,
            );
        }

        if (args.length < expectedArguments.length) {
            mockExpectation.fail(
                `${this.method} received too few arguments (${inspect(
                    args,
                )}), expected ${inspect(expectedArguments)}`,
            );
        }

        if (
            this.expectsExactArgCount &&
            args.length !== expectedArguments.length
        ) {
            mockExpectation.fail(
                `${this.method} received too many arguments (${inspect(
                    args,
                )}), expected ${inspect(expectedArguments)}`,
            );
        }

        forEach(
            expectedArguments,
            function (expectedArgument, i) {
                if (!verifyMatcher(expectedArgument, args[i])) {
                    mockExpectation.fail(
                        `${this.method} received wrong arguments ${inspect(
                            args,
                        )}, didn't match ${String(expectedArguments)}`,
                    );
                }

                if (!deepEqual(args[i], expectedArgument)) {
                    mockExpectation.fail(
                        `${this.method} received wrong arguments ${inspect(
                            args,
                        )}, expected ${inspect(expectedArguments)}`,
                    );
                }
            },
            this,
        );
    },

    allowsCall: function allowsCall(thisValue, args) {
        const expectedArguments = this.expectedArguments;

        if (this.met() && receivedMaxCalls(this)) {
            return false;
        }

        if ("expectedThis" in this && this.expectedThis !== thisValue) {
            return false;
        }

        if (!("expectedArguments" in this)) {
            return true;
        }

        // eslint-disable-next-line no-underscore-dangle
        const _args = args || [];

        if (_args.length < expectedArguments.length) {
            return false;
        }

        if (
            this.expectsExactArgCount &&
            _args.length !== expectedArguments.length
        ) {
            return false;
        }

        return every(expectedArguments, function (expectedArgument, i) {
            if (!verifyMatcher(expectedArgument, _args[i])) {
                return false;
            }

            if (!deepEqual(_args[i], expectedArgument)) {
                return false;
            }

            return true;
        });
    },

    withArgs: function withArgs() {
        this.expectedArguments = slice(arguments);
        return this;
    },

    withExactArgs: function withExactArgs() {
        this.withArgs.apply(this, arguments);
        this.expectsExactArgCount = true;
        return this;
    },

    on: function on(thisValue) {
        this.expectedThis = thisValue;
        return this;
    },

    toString: function () {
        const args = slice(this.expectedArguments || []);

        if (!this.expectsExactArgCount) {
            push(args, "[...]");
        }

        const callStr = proxyCallToString.call({
            proxy: this.method || "anonymous mock expectation",
            args: args,
        });

        const message = `${callStr.replace(
            ", [...",
            "[, ...",
        )} ${expectedCallCountInWords(this)}`;

        if (this.met()) {
            return `Expectation met: ${message}`;
        }

        return `Expected ${message} (${callCountInWords(this.callCount)})`;
    },

    verify: function verify() {
        if (!this.met()) {
            mockExpectation.fail(String(this));
        } else {
            mockExpectation.pass(String(this));
        }

        return true;
    },

    pass: function pass(message) {
        assert.pass(message);
    },

    fail: function fail(message) {
        const exception = new Error(message);
        exception.name = "ExpectationError";

        throw exception;
    },
};

module.exports = mockExpectation;

},{"./assert":3,"./proxy-call":15,"./proxy-invoke":16,"./stub":22,"./util/core/extend":25,"./util/core/times-in-words":35,"@sinonjs/commons":46,"@sinonjs/samsam":86,"util":90}],12:[function(require,module,exports){
"use strict";

const arrayProto = require("@sinonjs/commons").prototypes.array;
const mockExpectation = require("./mock-expectation");
const proxyCallToString = require("./proxy-call").toString;
const extend = require("./util/core/extend");
const deepEqual = require("@sinonjs/samsam").deepEqual;
const wrapMethod = require("./util/core/wrap-method");

const concat = arrayProto.concat;
const filter = arrayProto.filter;
const forEach = arrayProto.forEach;
const every = arrayProto.every;
const join = arrayProto.join;
const push = arrayProto.push;
const slice = arrayProto.slice;
const unshift = arrayProto.unshift;

function mock(object) {
    if (!object || typeof object === "string") {
        return mockExpectation.create(object ? object : "Anonymous mock");
    }

    return mock.create(object);
}

function each(collection, callback) {
    const col = collection || [];

    forEach(col, callback);
}

function arrayEquals(arr1, arr2, compareLength) {
    if (compareLength && arr1.length !== arr2.length) {
        return false;
    }

    return every(arr1, function (element, i) {
        return deepEqual(arr2[i], element);
    });
}

extend(mock, {
    create: function create(object) {
        if (!object) {
            throw new TypeError("object is null");
        }

        const mockObject = extend.nonEnum({}, mock, { object: object });
        delete mockObject.create;

        return mockObject;
    },

    expects: function expects(method) {
        if (!method) {
            throw new TypeError("method is falsy");
        }

        if (!this.expectations) {
            this.expectations = {};
            this.proxies = [];
            this.failures = [];
        }

        if (!this.expectations[method]) {
            this.expectations[method] = [];
            const mockObject = this;

            wrapMethod(this.object, method, function () {
                return mockObject.invokeMethod(method, this, arguments);
            });

            push(this.proxies, method);
        }

        const expectation = mockExpectation.create(method);
        expectation.wrappedMethod = this.object[method].wrappedMethod;
        push(this.expectations[method], expectation);

        return expectation;
    },

    restore: function restore() {
        const object = this.object;

        each(this.proxies, function (proxy) {
            if (typeof object[proxy].restore === "function") {
                object[proxy].restore();
            }
        });
    },

    verify: function verify() {
        const expectations = this.expectations || {};
        const messages = this.failures ? slice(this.failures) : [];
        const met = [];

        each(this.proxies, function (proxy) {
            each(expectations[proxy], function (expectation) {
                if (!expectation.met()) {
                    push(messages, String(expectation));
                } else {
                    push(met, String(expectation));
                }
            });
        });

        this.restore();

        if (messages.length > 0) {
            mockExpectation.fail(join(concat(messages, met), "\n"));
        } else if (met.length > 0) {
            mockExpectation.pass(join(concat(messages, met), "\n"));
        }

        return true;
    },

    invokeMethod: function invokeMethod(method, thisValue, args) {
        /* if we cannot find any matching files we will explicitly call mockExpection#fail with error messages */
        /* eslint consistent-return: "off" */
        const expectations =
            this.expectations && this.expectations[method]
                ? this.expectations[method]
                : [];
        const currentArgs = args || [];
        let available;

        const expectationsWithMatchingArgs = filter(
            expectations,
            function (expectation) {
                const expectedArgs = expectation.expectedArguments || [];

                return arrayEquals(
                    expectedArgs,
                    currentArgs,
                    expectation.expectsExactArgCount,
                );
            },
        );

        const expectationsToApply = filter(
            expectationsWithMatchingArgs,
            function (expectation) {
                return (
                    !expectation.met() &&
                    expectation.allowsCall(thisValue, args)
                );
            },
        );

        if (expectationsToApply.length > 0) {
            return expectationsToApply[0].apply(thisValue, args);
        }

        const messages = [];
        let exhausted = 0;

        forEach(expectationsWithMatchingArgs, function (expectation) {
            if (expectation.allowsCall(thisValue, args)) {
                available = available || expectation;
            } else {
                exhausted += 1;
            }
        });

        if (available && exhausted === 0) {
            return available.apply(thisValue, args);
        }

        forEach(expectations, function (expectation) {
            push(messages, `    ${String(expectation)}`);
        });

        unshift(
            messages,
            `Unexpected call: ${proxyCallToString.call({
                proxy: method,
                args: args,
            })}`,
        );

        const err = new Error();
        if (!err.stack) {
            // PhantomJS does not serialize the stack trace until the error has been thrown
            try {
                throw err;
            } catch (e) {
                /* empty */
            }
        }
        push(
            this.failures,
            `Unexpected call: ${proxyCallToString.call({
                proxy: method,
                args: args,
                stack: err.stack,
            })}`,
        );

        mockExpectation.fail(join(messages, "\n"));
    },
});

module.exports = mock;

},{"./mock-expectation":11,"./proxy-call":15,"./util/core/extend":25,"./util/core/wrap-method":38,"@sinonjs/commons":46,"@sinonjs/samsam":86}],13:[function(require,module,exports){
"use strict";

const fake = require("./fake");
const isRestorable = require("./util/core/is-restorable");

const STATUS_PENDING = "pending";
const STATUS_RESOLVED = "resolved";
const STATUS_REJECTED = "rejected";

/**
 * Returns a fake for a given function or undefined. If no function is given, a
 * new fake is returned. If the given function is already a fake, it is
 * returned as is. Otherwise the given function is wrapped in a new fake.
 *
 * @param {Function} [executor] The optional executor function.
 * @returns {Function}
 */
function getFakeExecutor(executor) {
    if (isRestorable(executor)) {
        return executor;
    }
    if (executor) {
        return fake(executor);
    }
    return fake();
}

/**
 * Returns a new promise that exposes it's internal `status`, `resolvedValue`
 * and `rejectedValue` and can be resolved or rejected from the outside by
 * calling `resolve(value)` or `reject(reason)`.
 *
 * @param {Function} [executor] The optional executor function.
 * @returns {Promise}
 */
function promise(executor) {
    const fakeExecutor = getFakeExecutor(executor);
    const sinonPromise = new Promise(fakeExecutor);

    sinonPromise.status = STATUS_PENDING;
    sinonPromise
        .then(function (value) {
            sinonPromise.status = STATUS_RESOLVED;
            sinonPromise.resolvedValue = value;
        })
        .catch(function (reason) {
            sinonPromise.status = STATUS_REJECTED;
            sinonPromise.rejectedValue = reason;
        });

    /**
     * Resolves or rejects the promise with the given status and value.
     *
     * @param {string} status
     * @param {*} value
     * @param {Function} callback
     */
    function finalize(status, value, callback) {
        if (sinonPromise.status !== STATUS_PENDING) {
            throw new Error(`Promise already ${sinonPromise.status}`);
        }

        sinonPromise.status = status;
        callback(value);
    }

    sinonPromise.resolve = function (value) {
        finalize(STATUS_RESOLVED, value, fakeExecutor.firstCall.args[0]);
        // Return the promise so that callers can await it:
        return sinonPromise;
    };
    sinonPromise.reject = function (reason) {
        finalize(STATUS_REJECTED, reason, fakeExecutor.firstCall.args[1]);
        // Return a new promise that resolves when the sinon promise was
        // rejected, so that callers can await it:
        return new Promise(function (resolve) {
            sinonPromise.catch(() => resolve());
        });
    };

    return sinonPromise;
}

module.exports = promise;

},{"./fake":10,"./util/core/is-restorable":32}],14:[function(require,module,exports){
"use strict";

const push = require("@sinonjs/commons").prototypes.array.push;

exports.incrementCallCount = function incrementCallCount(proxy) {
    proxy.called = true;
    proxy.callCount += 1;
    proxy.notCalled = false;
    proxy.calledOnce = proxy.callCount === 1;
    proxy.calledTwice = proxy.callCount === 2;
    proxy.calledThrice = proxy.callCount === 3;
};

exports.createCallProperties = function createCallProperties(proxy) {
    proxy.firstCall = proxy.getCall(0);
    proxy.secondCall = proxy.getCall(1);
    proxy.thirdCall = proxy.getCall(2);
    proxy.lastCall = proxy.getCall(proxy.callCount - 1);
};

exports.delegateToCalls = function delegateToCalls(
    proxy,
    method,
    matchAny,
    actual,
    returnsValues,
    notCalled,
    totalCallCount,
) {
    proxy[method] = function () {
        if (!this.called) {
            if (notCalled) {
                return notCalled.apply(this, arguments);
            }
            return false;
        }

        if (totalCallCount !== undefined && this.callCount !== totalCallCount) {
            return false;
        }

        let currentCall;
        let matches = 0;
        const returnValues = [];

        for (let i = 0, l = this.callCount; i < l; i += 1) {
            currentCall = this.getCall(i);
            const returnValue = currentCall[actual || method].apply(
                currentCall,
                arguments,
            );
            push(returnValues, returnValue);
            if (returnValue) {
                matches += 1;

                if (matchAny) {
                    return true;
                }
            }
        }

        if (returnsValues) {
            return returnValues;
        }
        return matches === this.callCount;
    };
};

},{"@sinonjs/commons":46}],15:[function(require,module,exports){
"use strict";

const arrayProto = require("@sinonjs/commons").prototypes.array;
const match = require("@sinonjs/samsam").createMatcher;
const deepEqual = require("@sinonjs/samsam").deepEqual;
const functionName = require("@sinonjs/commons").functionName;
const inspect = require("util").inspect;
const valueToString = require("@sinonjs/commons").valueToString;

const concat = arrayProto.concat;
const filter = arrayProto.filter;
const join = arrayProto.join;
const map = arrayProto.map;
const reduce = arrayProto.reduce;
const slice = arrayProto.slice;

/**
 * @param proxy
 * @param text
 * @param args
 */
function throwYieldError(proxy, text, args) {
    let msg = functionName(proxy) + text;
    if (args.length) {
        msg += ` Received [${join(slice(args), ", ")}]`;
    }
    throw new Error(msg);
}

const callProto = {
    calledOn: function calledOn(thisValue) {
        if (match.isMatcher(thisValue)) {
            return thisValue.test(this.thisValue);
        }
        return this.thisValue === thisValue;
    },

    calledWith: function calledWith() {
        const self = this;
        const calledWithArgs = slice(arguments);

        if (calledWithArgs.length > self.args.length) {
            return false;
        }

        return reduce(
            calledWithArgs,
            function (prev, arg, i) {
                return prev && deepEqual(self.args[i], arg);
            },
            true,
        );
    },

    calledWithMatch: function calledWithMatch() {
        const self = this;
        const calledWithMatchArgs = slice(arguments);

        if (calledWithMatchArgs.length > self.args.length) {
            return false;
        }

        return reduce(
            calledWithMatchArgs,
            function (prev, expectation, i) {
                const actual = self.args[i];

                return prev && match(expectation).test(actual);
            },
            true,
        );
    },

    calledWithExactly: function calledWithExactly() {
        return (
            arguments.length === this.args.length &&
            this.calledWith.apply(this, arguments)
        );
    },

    notCalledWith: function notCalledWith() {
        return !this.calledWith.apply(this, arguments);
    },

    notCalledWithMatch: function notCalledWithMatch() {
        return !this.calledWithMatch.apply(this, arguments);
    },

    returned: function returned(value) {
        return deepEqual(this.returnValue, value);
    },

    threw: function threw(error) {
        if (typeof error === "undefined" || !this.exception) {
            return Boolean(this.exception);
        }

        return this.exception === error || this.exception.name === error;
    },

    calledWithNew: function calledWithNew() {
        return this.proxy.prototype && this.thisValue instanceof this.proxy;
    },

    calledBefore: function (other) {
        return this.callId < other.callId;
    },

    calledAfter: function (other) {
        return this.callId > other.callId;
    },

    calledImmediatelyBefore: function (other) {
        return this.callId === other.callId - 1;
    },

    calledImmediatelyAfter: function (other) {
        return this.callId === other.callId + 1;
    },

    callArg: function (pos) {
        this.ensureArgIsAFunction(pos);
        return this.args[pos]();
    },

    callArgOn: function (pos, thisValue) {
        this.ensureArgIsAFunction(pos);
        return this.args[pos].apply(thisValue);
    },

    callArgWith: function (pos) {
        return this.callArgOnWith.apply(
            this,
            concat([pos, null], slice(arguments, 1)),
        );
    },

    callArgOnWith: function (pos, thisValue) {
        this.ensureArgIsAFunction(pos);
        const args = slice(arguments, 2);
        return this.args[pos].apply(thisValue, args);
    },

    throwArg: function (pos) {
        if (pos > this.args.length) {
            throw new TypeError(
                `Not enough arguments: ${pos} required but only ${this.args.length} present`,
            );
        }

        throw this.args[pos];
    },

    yield: function () {
        return this.yieldOn.apply(this, concat([null], slice(arguments, 0)));
    },

    yieldOn: function (thisValue) {
        const args = slice(this.args);
        const yieldFn = filter(args, function (arg) {
            return typeof arg === "function";
        })[0];

        if (!yieldFn) {
            throwYieldError(
                this.proxy,
                " cannot yield since no callback was passed.",
                args,
            );
        }

        return yieldFn.apply(thisValue, slice(arguments, 1));
    },

    yieldTo: function (prop) {
        return this.yieldToOn.apply(
            this,
            concat([prop, null], slice(arguments, 1)),
        );
    },

    yieldToOn: function (prop, thisValue) {
        const args = slice(this.args);
        const yieldArg = filter(args, function (arg) {
            return arg && typeof arg[prop] === "function";
        })[0];
        const yieldFn = yieldArg && yieldArg[prop];

        if (!yieldFn) {
            throwYieldError(
                this.proxy,
                ` cannot yield to '${valueToString(
                    prop,
                )}' since no callback was passed.`,
                args,
            );
        }

        return yieldFn.apply(thisValue, slice(arguments, 2));
    },

    toString: function () {
        if (!this.args) {
            return ":(";
        }

        let callStr = this.proxy ? `${String(this.proxy)}(` : "";
        const formattedArgs = map(this.args, function (arg) {
            return inspect(arg);
        });

        callStr = `${callStr + join(formattedArgs, ", ")})`;

        if (typeof this.returnValue !== "undefined") {
            callStr += ` => ${inspect(this.returnValue)}`;
        }

        if (this.exception) {
            callStr += ` !${this.exception.name}`;

            if (this.exception.message) {
                callStr += `(${this.exception.message})`;
            }
        }
        if (this.stack) {
            // If we have a stack, add the first frame that's in end-user code
            // Skip the first two frames because they will refer to Sinon code
            callStr += (this.stack.split("\n")[3] || "unknown").replace(
                /^\s*(?:at\s+|@)?/,
                " at ",
            );
        }

        return callStr;
    },

    ensureArgIsAFunction: function (pos) {
        if (typeof this.args[pos] !== "function") {
            throw new TypeError(
                `Expected argument at position ${pos} to be a Function, but was ${typeof this
                    .args[pos]}`,
            );
        }
    },
};
Object.defineProperty(callProto, "stack", {
    enumerable: true,
    configurable: true,
    get: function () {
        return (this.errorWithCallStack && this.errorWithCallStack.stack) || "";
    },
});

callProto.invokeCallback = callProto.yield;

/**
 * @param proxy
 * @param thisValue
 * @param args
 * @param returnValue
 * @param exception
 * @param id
 * @param errorWithCallStack
 *
 * @returns {object} proxyCall
 */
function createProxyCall(
    proxy,
    thisValue,
    args,
    returnValue,
    exception,
    id,
    errorWithCallStack,
) {
    if (typeof id !== "number") {
        throw new TypeError("Call id is not a number");
    }

    let firstArg, lastArg;

    if (args.length > 0) {
        firstArg = args[0];
        lastArg = args[args.length - 1];
    }

    const proxyCall = Object.create(callProto);
    const callback =
        lastArg && typeof lastArg === "function" ? lastArg : undefined;

    proxyCall.proxy = proxy;
    proxyCall.thisValue = thisValue;
    proxyCall.args = args;
    proxyCall.firstArg = firstArg;
    proxyCall.lastArg = lastArg;
    proxyCall.callback = callback;
    proxyCall.returnValue = returnValue;
    proxyCall.exception = exception;
    proxyCall.callId = id;
    proxyCall.errorWithCallStack = errorWithCallStack;

    return proxyCall;
}
createProxyCall.toString = callProto.toString; // used by mocks

module.exports = createProxyCall;

},{"@sinonjs/commons":46,"@sinonjs/samsam":86,"util":90}],16:[function(require,module,exports){
"use strict";

const arrayProto = require("@sinonjs/commons").prototypes.array;
const proxyCallUtil = require("./proxy-call-util");

const push = arrayProto.push;
const forEach = arrayProto.forEach;
const concat = arrayProto.concat;
const ErrorConstructor = Error.prototype.constructor;
const bind = Function.prototype.bind;

let callId = 0;

module.exports = function invoke(func, thisValue, args) {
    const matchings = this.matchingFakes(args);
    const currentCallId = callId++;
    let exception, returnValue;

    proxyCallUtil.incrementCallCount(this);
    push(this.thisValues, thisValue);
    push(this.args, args);
    push(this.callIds, currentCallId);
    forEach(matchings, function (matching) {
        proxyCallUtil.incrementCallCount(matching);
        push(matching.thisValues, thisValue);
        push(matching.args, args);
        push(matching.callIds, currentCallId);
    });

    // Make call properties available from within the spied function:
    proxyCallUtil.createCallProperties(this);
    forEach(matchings, proxyCallUtil.createCallProperties);

    try {
        this.invoking = true;

        const thisCall = this.getCall(this.callCount - 1);

        if (thisCall.calledWithNew()) {
            // Call through with `new`
            returnValue = new (bind.apply(
                this.func || func,
                concat([thisValue], args),
            ))();

            if (
                typeof returnValue !== "object" &&
                typeof returnValue !== "function"
            ) {
                returnValue = thisValue;
            }
        } else {
            returnValue = (this.func || func).apply(thisValue, args);
        }
    } catch (e) {
        exception = e;
    } finally {
        delete this.invoking;
    }

    push(this.exceptions, exception);
    push(this.returnValues, returnValue);
    forEach(matchings, function (matching) {
        push(matching.exceptions, exception);
        push(matching.returnValues, returnValue);
    });

    const err = new ErrorConstructor();
    // 1. Please do not get stack at this point. It may be so very slow, and not actually used
    // 2. PhantomJS does not serialize the stack trace until the error has been thrown:
    // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Error/Stack
    try {
        throw err;
    } catch (e) {
        /* empty */
    }
    push(this.errorsWithCallStack, err);
    forEach(matchings, function (matching) {
        push(matching.errorsWithCallStack, err);
    });

    // Make return value and exception available in the calls:
    proxyCallUtil.createCallProperties(this);
    forEach(matchings, proxyCallUtil.createCallProperties);

    if (exception !== undefined) {
        throw exception;
    }

    return returnValue;
};

},{"./proxy-call-util":14,"@sinonjs/commons":46}],17:[function(require,module,exports){
"use strict";

const arrayProto = require("@sinonjs/commons").prototypes.array;
const extend = require("./util/core/extend");
const functionToString = require("./util/core/function-to-string");
const proxyCall = require("./proxy-call");
const proxyCallUtil = require("./proxy-call-util");
const proxyInvoke = require("./proxy-invoke");
const inspect = require("util").inspect;

const push = arrayProto.push;
const forEach = arrayProto.forEach;
const slice = arrayProto.slice;

const emptyFakes = Object.freeze([]);

// Public API
const proxyApi = {
    toString: functionToString,

    named: function named(name) {
        this.displayName = name;
        const nameDescriptor = Object.getOwnPropertyDescriptor(this, "name");
        if (nameDescriptor && nameDescriptor.configurable) {
            // IE 11 functions don't have a name.
            // Safari 9 has names that are not configurable.
            nameDescriptor.value = name;
            Object.defineProperty(this, "name", nameDescriptor);
        }
        return this;
    },

    invoke: proxyInvoke,

    /*
     * Hook for derived implementation to return fake instances matching the
     * given arguments.
     */
    matchingFakes: function (/*args, strict*/) {
        return emptyFakes;
    },

    getCall: function getCall(index) {
        let i = index;
        if (i < 0) {
            // Negative indices means counting backwards from the last call
            i += this.callCount;
        }
        if (i < 0 || i >= this.callCount) {
            return null;
        }

        return proxyCall(
            this,
            this.thisValues[i],
            this.args[i],
            this.returnValues[i],
            this.exceptions[i],
            this.callIds[i],
            this.errorsWithCallStack[i],
        );
    },

    getCalls: function () {
        const calls = [];
        let i;

        for (i = 0; i < this.callCount; i++) {
            push(calls, this.getCall(i));
        }

        return calls;
    },

    calledBefore: function calledBefore(proxy) {
        if (!this.called) {
            return false;
        }

        if (!proxy.called) {
            return true;
        }

        return this.callIds[0] < proxy.callIds[proxy.callIds.length - 1];
    },

    calledAfter: function calledAfter(proxy) {
        if (!this.called || !proxy.called) {
            return false;
        }

        return this.callIds[this.callCount - 1] > proxy.callIds[0];
    },

    calledImmediatelyBefore: function calledImmediatelyBefore(proxy) {
        if (!this.called || !proxy.called) {
            return false;
        }

        return (
            this.callIds[this.callCount - 1] ===
            proxy.callIds[proxy.callCount - 1] - 1
        );
    },

    calledImmediatelyAfter: function calledImmediatelyAfter(proxy) {
        if (!this.called || !proxy.called) {
            return false;
        }

        return (
            this.callIds[this.callCount - 1] ===
            proxy.callIds[proxy.callCount - 1] + 1
        );
    },

    formatters: require("./spy-formatters"),
    printf: function (format) {
        const spyInstance = this;
        const args = slice(arguments, 1);
        let formatter;

        return (format || "").replace(/%(.)/g, function (match, specifier) {
            formatter = proxyApi.formatters[specifier];

            if (typeof formatter === "function") {
                return String(formatter(spyInstance, args));
            } else if (!isNaN(parseInt(specifier, 10))) {
                return inspect(args[specifier - 1]);
            }

            return `%${specifier}`;
        });
    },

    resetHistory: function () {
        if (this.invoking) {
            const err = new Error(
                "Cannot reset Sinon function while invoking it. " +
                    "Move the call to .resetHistory outside of the callback.",
            );
            err.name = "InvalidResetException";
            throw err;
        }

        this.called = false;
        this.notCalled = true;
        this.calledOnce = false;
        this.calledTwice = false;
        this.calledThrice = false;
        this.callCount = 0;
        this.firstCall = null;
        this.secondCall = null;
        this.thirdCall = null;
        this.lastCall = null;
        this.args = [];
        this.firstArg = null;
        this.lastArg = null;
        this.returnValues = [];
        this.thisValues = [];
        this.exceptions = [];
        this.callIds = [];
        this.errorsWithCallStack = [];

        if (this.fakes) {
            forEach(this.fakes, function (fake) {
                fake.resetHistory();
            });
        }

        return this;
    },
};

const delegateToCalls = proxyCallUtil.delegateToCalls;
delegateToCalls(proxyApi, "calledOn", true);
delegateToCalls(proxyApi, "alwaysCalledOn", false, "calledOn");
delegateToCalls(proxyApi, "calledWith", true);
delegateToCalls(
    proxyApi,
    "calledOnceWith",
    true,
    "calledWith",
    false,
    undefined,
    1,
);
delegateToCalls(proxyApi, "calledWithMatch", true);
delegateToCalls(proxyApi, "alwaysCalledWith", false, "calledWith");
delegateToCalls(proxyApi, "alwaysCalledWithMatch", false, "calledWithMatch");
delegateToCalls(proxyApi, "calledWithExactly", true);
delegateToCalls(
    proxyApi,
    "calledOnceWithExactly",
    true,
    "calledWithExactly",
    false,
    undefined,
    1,
);
delegateToCalls(
    proxyApi,
    "calledOnceWithMatch",
    true,
    "calledWithMatch",
    false,
    undefined,
    1,
);
delegateToCalls(
    proxyApi,
    "alwaysCalledWithExactly",
    false,
    "calledWithExactly",
);
delegateToCalls(
    proxyApi,
    "neverCalledWith",
    false,
    "notCalledWith",
    false,
    function () {
        return true;
    },
);
delegateToCalls(
    proxyApi,
    "neverCalledWithMatch",
    false,
    "notCalledWithMatch",
    false,
    function () {
        return true;
    },
);
delegateToCalls(proxyApi, "threw", true);
delegateToCalls(proxyApi, "alwaysThrew", false, "threw");
delegateToCalls(proxyApi, "returned", true);
delegateToCalls(proxyApi, "alwaysReturned", false, "returned");
delegateToCalls(proxyApi, "calledWithNew", true);
delegateToCalls(proxyApi, "alwaysCalledWithNew", false, "calledWithNew");

function createProxy(func, originalFunc) {
    const proxy = wrapFunction(func, originalFunc);

    // Inherit function properties:
    extend(proxy, func);

    proxy.prototype = func.prototype;

    extend.nonEnum(proxy, proxyApi);

    return proxy;
}

function wrapFunction(func, originalFunc) {
    const arity = originalFunc.length;
    let p;
    // Do not change this to use an eval. Projects that depend on sinon block the use of eval.
    // ref: https://github.com/sinonjs/sinon/issues/710
    switch (arity) {
        /*eslint-disable no-unused-vars, max-len*/
        case 0:
            p = function proxy() {
                return p.invoke(func, this, slice(arguments));
            };
            break;
        case 1:
            p = function proxy(a) {
                return p.invoke(func, this, slice(arguments));
            };
            break;
        case 2:
            p = function proxy(a, b) {
                return p.invoke(func, this, slice(arguments));
            };
            break;
        case 3:
            p = function proxy(a, b, c) {
                return p.invoke(func, this, slice(arguments));
            };
            break;
        case 4:
            p = function proxy(a, b, c, d) {
                return p.invoke(func, this, slice(arguments));
            };
            break;
        case 5:
            p = function proxy(a, b, c, d, e) {
                return p.invoke(func, this, slice(arguments));
            };
            break;
        case 6:
            p = function proxy(a, b, c, d, e, f) {
                return p.invoke(func, this, slice(arguments));
            };
            break;
        case 7:
            p = function proxy(a, b, c, d, e, f, g) {
                return p.invoke(func, this, slice(arguments));
            };
            break;
        case 8:
            p = function proxy(a, b, c, d, e, f, g, h) {
                return p.invoke(func, this, slice(arguments));
            };
            break;
        case 9:
            p = function proxy(a, b, c, d, e, f, g, h, i) {
                return p.invoke(func, this, slice(arguments));
            };
            break;
        case 10:
            p = function proxy(a, b, c, d, e, f, g, h, i, j) {
                return p.invoke(func, this, slice(arguments));
            };
            break;
        case 11:
            p = function proxy(a, b, c, d, e, f, g, h, i, j, k) {
                return p.invoke(func, this, slice(arguments));
            };
            break;
        case 12:
            p = function proxy(a, b, c, d, e, f, g, h, i, j, k, l) {
                return p.invoke(func, this, slice(arguments));
            };
            break;
        default:
            p = function proxy() {
                return p.invoke(func, this, slice(arguments));
            };
            break;
        /*eslint-enable*/
    }
    const nameDescriptor = Object.getOwnPropertyDescriptor(
        originalFunc,
        "name",
    );
    if (nameDescriptor && nameDescriptor.configurable) {
        // IE 11 functions don't have a name.
        // Safari 9 has names that are not configurable.
        Object.defineProperty(p, "name", nameDescriptor);
    }
    extend.nonEnum(p, {
        isSinonProxy: true,

        called: false,
        notCalled: true,
        calledOnce: false,
        calledTwice: false,
        calledThrice: false,
        callCount: 0,
        firstCall: null,
        firstArg: null,
        secondCall: null,
        thirdCall: null,
        lastCall: null,
        lastArg: null,
        args: [],
        returnValues: [],
        thisValues: [],
        exceptions: [],
        callIds: [],
        errorsWithCallStack: [],
    });
    return p;
}

module.exports = createProxy;

},{"./proxy-call":15,"./proxy-call-util":14,"./proxy-invoke":16,"./spy-formatters":20,"./util/core/extend":25,"./util/core/function-to-string":26,"@sinonjs/commons":46,"util":90}],18:[function(require,module,exports){
"use strict";

const walkObject = require("./util/core/walk-object");

function filter(object, property) {
    return object[property].restore && object[property].restore.sinon;
}

function restore(object, property) {
    object[property].restore();
}

function restoreObject(object) {
    return walkObject(restore, object, filter);
}

module.exports = restoreObject;

},{"./util/core/walk-object":36}],19:[function(require,module,exports){
"use strict";

const arrayProto = require("@sinonjs/commons").prototypes.array;
const logger = require("@sinonjs/commons").deprecated;
const collectOwnMethods = require("./collect-own-methods");
const getPropertyDescriptor = require("./util/core/get-property-descriptor");
const isPropertyConfigurable = require("./util/core/is-property-configurable");
const match = require("@sinonjs/samsam").createMatcher;
const sinonAssert = require("./assert");
const sinonClock = require("./util/fake-timers");
const sinonMock = require("./mock");
const sinonSpy = require("./spy");
const sinonStub = require("./stub");
const sinonCreateStubInstance = require("./create-stub-instance");
const sinonFake = require("./fake");
const valueToString = require("@sinonjs/commons").valueToString;

const DEFAULT_LEAK_THRESHOLD = 10000;

const filter = arrayProto.filter;
const forEach = arrayProto.forEach;
const push = arrayProto.push;
const reverse = arrayProto.reverse;

function applyOnEach(fakes, method) {
    const matchingFakes = filter(fakes, function (fake) {
        return typeof fake[method] === "function";
    });

    forEach(matchingFakes, function (fake) {
        fake[method]();
    });
}

function throwOnAccessors(descriptor) {
    if (typeof descriptor.get === "function") {
        throw new Error("Use sandbox.replaceGetter for replacing getters");
    }

    if (typeof descriptor.set === "function") {
        throw new Error("Use sandbox.replaceSetter for replacing setters");
    }
}

function verifySameType(object, property, replacement) {
    if (typeof object[property] !== typeof replacement) {
        throw new TypeError(
            `Cannot replace ${typeof object[
                property
            ]} with ${typeof replacement}`,
        );
    }
}

function checkForValidArguments(descriptor, property, replacement) {
    if (typeof descriptor === "undefined") {
        throw new TypeError(
            `Cannot replace non-existent property ${valueToString(
                property,
            )}. Perhaps you meant sandbox.define()?`,
        );
    }

    if (typeof replacement === "undefined") {
        throw new TypeError("Expected replacement argument to be defined");
    }
}

/**
 * A sinon sandbox
 *
 * @param opts
 * @param {object} [opts.assertOptions] see the CreateAssertOptions in ./assert
 * @class
 */
function Sandbox(opts = {}) {
    const sandbox = this;
    const assertOptions = opts.assertOptions || {};
    let fakeRestorers = [];

    let collection = [];
    let loggedLeakWarning = false;
    sandbox.leakThreshold = DEFAULT_LEAK_THRESHOLD;

    function addToCollection(object) {
        if (
            push(collection, object) > sandbox.leakThreshold &&
            !loggedLeakWarning
        ) {
            // eslint-disable-next-line no-console
            logger.printWarning(
                "Potential memory leak detected; be sure to call restore() to clean up your sandbox. To suppress this warning, modify the leakThreshold property of your sandbox.",
            );
            loggedLeakWarning = true;
        }
    }

    sandbox.assert = sinonAssert.createAssertObject(assertOptions);

    // this is for testing only
    sandbox.getFakes = function getFakes() {
        return collection;
    };

    sandbox.createStubInstance = function createStubInstance() {
        const stubbed = sinonCreateStubInstance.apply(null, arguments);

        const ownMethods = collectOwnMethods(stubbed);

        forEach(ownMethods, function (method) {
            addToCollection(method);
        });

        return stubbed;
    };

    sandbox.inject = function inject(obj) {
        obj.spy = function () {
            return sandbox.spy.apply(null, arguments);
        };

        obj.stub = function () {
            return sandbox.stub.apply(null, arguments);
        };

        obj.mock = function () {
            return sandbox.mock.apply(null, arguments);
        };

        obj.createStubInstance = function () {
            return sandbox.createStubInstance.apply(sandbox, arguments);
        };

        obj.fake = function () {
            return sandbox.fake.apply(null, arguments);
        };

        obj.define = function () {
            return sandbox.define.apply(null, arguments);
        };

        obj.replace = function () {
            return sandbox.replace.apply(null, arguments);
        };

        obj.replaceSetter = function () {
            return sandbox.replaceSetter.apply(null, arguments);
        };

        obj.replaceGetter = function () {
            return sandbox.replaceGetter.apply(null, arguments);
        };

        if (sandbox.clock) {
            obj.clock = sandbox.clock;
        }

        obj.match = match;

        return obj;
    };

    sandbox.mock = function mock() {
        const m = sinonMock.apply(null, arguments);

        addToCollection(m);

        return m;
    };

    sandbox.reset = function reset() {
        applyOnEach(collection, "reset");
        applyOnEach(collection, "resetHistory");
    };

    sandbox.resetBehavior = function resetBehavior() {
        applyOnEach(collection, "resetBehavior");
    };

    sandbox.resetHistory = function resetHistory() {
        function privateResetHistory(f) {
            const method = f.resetHistory || f.reset;
            if (method) {
                method.call(f);
            }
        }

        forEach(collection, privateResetHistory);
    };

    sandbox.restore = function restore() {
        if (arguments.length) {
            throw new Error(
                "sandbox.restore() does not take any parameters. Perhaps you meant stub.restore()",
            );
        }

        reverse(collection);
        applyOnEach(collection, "restore");
        collection = [];

        forEach(fakeRestorers, function (restorer) {
            restorer();
        });
        fakeRestorers = [];

        sandbox.restoreContext();
    };

    sandbox.restoreContext = function restoreContext() {
        if (!sandbox.injectedKeys) {
            return;
        }

        forEach(sandbox.injectedKeys, function (injectedKey) {
            delete sandbox.injectInto[injectedKey];
        });

        sandbox.injectedKeys.length = 0;
    };

    /**
     * Creates a restorer function for the property
     *
     * @param {object|Function} object
     * @param {string} property
     * @param {boolean} forceAssignment
     * @returns {Function} restorer function
     */
    function getFakeRestorer(object, property, forceAssignment = false) {
        const descriptor = getPropertyDescriptor(object, property);
        const value = forceAssignment && object[property];

        function restorer() {
            if (forceAssignment) {
                object[property] = value;
            } else if (descriptor?.isOwn) {
                Object.defineProperty(object, property, descriptor);
            } else {
                delete object[property];
            }
        }

        restorer.object = object;
        restorer.property = property;
        return restorer;
    }

    function verifyNotReplaced(object, property) {
        forEach(fakeRestorers, function (fakeRestorer) {
            if (
                fakeRestorer.object === object &&
                fakeRestorer.property === property
            ) {
                throw new TypeError(
                    `Attempted to replace ${property} which is already replaced`,
                );
            }
        });
    }

    /**
     * Replace an existing property
     *
     * @param {object|Function} object
     * @param {string} property
     * @param {*} replacement a fake, stub, spy or any other value
     * @returns {*}
     */
    sandbox.replace = function replace(object, property, replacement) {
        const descriptor = getPropertyDescriptor(object, property);
        checkForValidArguments(descriptor, property, replacement);
        throwOnAccessors(descriptor);
        verifySameType(object, property, replacement);

        verifyNotReplaced(object, property);

        // store a function for restoring the replaced property
        push(fakeRestorers, getFakeRestorer(object, property));

        object[property] = replacement;

        return replacement;
    };

    sandbox.replace.usingAccessor = function replaceUsingAccessor(
        object,
        property,
        replacement,
    ) {
        const descriptor = getPropertyDescriptor(object, property);
        checkForValidArguments(descriptor, property, replacement);
        verifySameType(object, property, replacement);

        verifyNotReplaced(object, property);

        // store a function for restoring the replaced property
        push(fakeRestorers, getFakeRestorer(object, property, true));

        object[property] = replacement;

        return replacement;
    };

    sandbox.define = function define(object, property, value) {
        const descriptor = getPropertyDescriptor(object, property);

        if (descriptor) {
            throw new TypeError(
                `Cannot define the already existing property ${valueToString(
                    property,
                )}. Perhaps you meant sandbox.replace()?`,
            );
        }

        if (typeof value === "undefined") {
            throw new TypeError("Expected value argument to be defined");
        }

        verifyNotReplaced(object, property);

        // store a function for restoring the defined property
        push(fakeRestorers, getFakeRestorer(object, property));

        object[property] = value;

        return value;
    };

    sandbox.replaceGetter = function replaceGetter(
        object,
        property,
        replacement,
    ) {
        const descriptor = getPropertyDescriptor(object, property);

        if (typeof descriptor === "undefined") {
            throw new TypeError(
                `Cannot replace non-existent property ${valueToString(
                    property,
                )}`,
            );
        }

        if (typeof replacement !== "function") {
            throw new TypeError(
                "Expected replacement argument to be a function",
            );
        }

        if (typeof descriptor.get !== "function") {
            throw new Error("`object.property` is not a getter");
        }

        verifyNotReplaced(object, property);

        // store a function for restoring the replaced property
        push(fakeRestorers, getFakeRestorer(object, property));

        Object.defineProperty(object, property, {
            get: replacement,
            configurable: isPropertyConfigurable(object, property),
        });

        return replacement;
    };

    sandbox.replaceSetter = function replaceSetter(
        object,
        property,
        replacement,
    ) {
        const descriptor = getPropertyDescriptor(object, property);

        if (typeof descriptor === "undefined") {
            throw new TypeError(
                `Cannot replace non-existent property ${valueToString(
                    property,
                )}`,
            );
        }

        if (typeof replacement !== "function") {
            throw new TypeError(
                "Expected replacement argument to be a function",
            );
        }

        if (typeof descriptor.set !== "function") {
            throw new Error("`object.property` is not a setter");
        }

        verifyNotReplaced(object, property);

        // store a function for restoring the replaced property
        push(fakeRestorers, getFakeRestorer(object, property));

        // eslint-disable-next-line accessor-pairs
        Object.defineProperty(object, property, {
            set: replacement,
            configurable: isPropertyConfigurable(object, property),
        });

        return replacement;
    };

    function commonPostInitSetup(args, spy) {
        const [object, property, types] = args;

        const isSpyingOnEntireObject =
            typeof property === "undefined" && typeof object === "object";

        if (isSpyingOnEntireObject) {
            const ownMethods = collectOwnMethods(spy);

            forEach(ownMethods, function (method) {
                addToCollection(method);
            });
        } else if (Array.isArray(types)) {
            for (const accessorType of types) {
                addToCollection(spy[accessorType]);
            }
        } else {
            addToCollection(spy);
        }

        return spy;
    }

    sandbox.spy = function spy() {
        const createdSpy = sinonSpy.apply(sinonSpy, arguments);
        return commonPostInitSetup(arguments, createdSpy);
    };

    sandbox.stub = function stub() {
        const createdStub = sinonStub.apply(sinonStub, arguments);
        return commonPostInitSetup(arguments, createdStub);
    };

    // eslint-disable-next-line no-unused-vars
    sandbox.fake = function fake(f) {
        const s = sinonFake.apply(sinonFake, arguments);

        addToCollection(s);

        return s;
    };

    forEach(Object.keys(sinonFake), function (key) {
        const fakeBehavior = sinonFake[key];
        if (typeof fakeBehavior === "function") {
            sandbox.fake[key] = function () {
                const s = fakeBehavior.apply(fakeBehavior, arguments);

                addToCollection(s);

                return s;
            };
        }
    });

    sandbox.useFakeTimers = function useFakeTimers(args) {
        const clock = sinonClock.useFakeTimers.call(null, args);

        sandbox.clock = clock;
        addToCollection(clock);

        return clock;
    };

    sandbox.verify = function verify() {
        applyOnEach(collection, "verify");
    };

    sandbox.verifyAndRestore = function verifyAndRestore() {
        let exception;

        try {
            sandbox.verify();
        } catch (e) {
            exception = e;
        }

        sandbox.restore();

        if (exception) {
            throw exception;
        }
    };
}

Sandbox.prototype.match = match;

module.exports = Sandbox;

},{"./assert":3,"./collect-own-methods":5,"./create-stub-instance":8,"./fake":10,"./mock":12,"./spy":21,"./stub":22,"./util/core/get-property-descriptor":28,"./util/core/is-property-configurable":31,"./util/fake-timers":39,"@sinonjs/commons":46,"@sinonjs/samsam":86}],20:[function(require,module,exports){
"use strict";

const arrayProto = require("@sinonjs/commons").prototypes.array;
const Colorizer = require("./colorizer");
const colororizer = new Colorizer();
const match = require("@sinonjs/samsam").createMatcher;
const timesInWords = require("./util/core/times-in-words");
const inspect = require("util").inspect;
const jsDiff = require("diff");

const join = arrayProto.join;
const map = arrayProto.map;
const push = arrayProto.push;
const slice = arrayProto.slice;

/**
 *
 * @param matcher
 * @param calledArg
 * @param calledArgMessage
 *
 * @returns {string} the colored text
 */
function colorSinonMatchText(matcher, calledArg, calledArgMessage) {
    let calledArgumentMessage = calledArgMessage;
    let matcherMessage = matcher.message;
    if (!matcher.test(calledArg)) {
        matcherMessage = colororizer.red(matcher.message);
        if (calledArgumentMessage) {
            calledArgumentMessage = colororizer.green(calledArgumentMessage);
        }
    }
    return `${calledArgumentMessage} ${matcherMessage}`;
}

/**
 * @param diff
 *
 * @returns {string} the colored diff
 */
function colorDiffText(diff) {
    const objects = map(diff, function (part) {
        let text = part.value;
        if (part.added) {
            text = colororizer.green(text);
        } else if (part.removed) {
            text = colororizer.red(text);
        }
        if (diff.length === 2) {
            text += " "; // format simple diffs
        }
        return text;
    });
    return join(objects, "");
}

/**
 *
 * @param value
 * @returns {string} a quoted string
 */
function quoteStringValue(value) {
    if (typeof value === "string") {
        return JSON.stringify(value);
    }
    return value;
}

module.exports = {
    c: function (spyInstance) {
        return timesInWords(spyInstance.callCount);
    },

    n: function (spyInstance) {
        // eslint-disable-next-line @sinonjs/no-prototype-methods/no-prototype-methods
        return spyInstance.toString();
    },

    D: function (spyInstance, args) {
        let message = "";

        for (let i = 0, l = spyInstance.callCount; i < l; ++i) {
            // describe multiple calls
            if (l > 1) {
                message += `\nCall ${i + 1}:`;
            }
            const calledArgs = spyInstance.getCall(i).args;
            const expectedArgs = slice(args);

            for (
                let j = 0;
                j < calledArgs.length || j < expectedArgs.length;
                ++j
            ) {
                let calledArg = calledArgs[j];
                let expectedArg = expectedArgs[j];
                if (calledArg) {
                    calledArg = quoteStringValue(calledArg);
                }

                if (expectedArg) {
                    expectedArg = quoteStringValue(expectedArg);
                }

                message += "\n";

                const calledArgMessage =
                    j < calledArgs.length ? inspect(calledArg) : "";
                if (match.isMatcher(expectedArg)) {
                    message += colorSinonMatchText(
                        expectedArg,
                        calledArg,
                        calledArgMessage,
                    );
                } else {
                    const expectedArgMessage =
                        j < expectedArgs.length ? inspect(expectedArg) : "";
                    const diff = jsDiff.diffJson(
                        calledArgMessage,
                        expectedArgMessage,
                    );
                    message += colorDiffText(diff);
                }
            }
        }

        return message;
    },

    C: function (spyInstance) {
        const calls = [];

        for (let i = 0, l = spyInstance.callCount; i < l; ++i) {
            // eslint-disable-next-line @sinonjs/no-prototype-methods/no-prototype-methods
            let stringifiedCall = `    ${spyInstance.getCall(i).toString()}`;
            if (/\n/.test(calls[i - 1])) {
                stringifiedCall = `\n${stringifiedCall}`;
            }
            push(calls, stringifiedCall);
        }

        return calls.length > 0 ? `\n${join(calls, "\n")}` : "";
    },

    t: function (spyInstance) {
        const objects = [];

        for (let i = 0, l = spyInstance.callCount; i < l; ++i) {
            push(objects, inspect(spyInstance.thisValues[i]));
        }

        return join(objects, ", ");
    },

    "*": function (spyInstance, args) {
        return join(
            map(args, function (arg) {
                return inspect(arg);
            }),
            ", ",
        );
    },
};

},{"./colorizer":6,"./util/core/times-in-words":35,"@sinonjs/commons":46,"@sinonjs/samsam":86,"diff":91,"util":90}],21:[function(require,module,exports){
"use strict";

const arrayProto = require("@sinonjs/commons").prototypes.array;
const createProxy = require("./proxy");
const extend = require("./util/core/extend");
const functionName = require("@sinonjs/commons").functionName;
const getPropertyDescriptor = require("./util/core/get-property-descriptor");
const deepEqual = require("@sinonjs/samsam").deepEqual;
const isEsModule = require("./util/core/is-es-module");
const proxyCallUtil = require("./proxy-call-util");
const walkObject = require("./util/core/walk-object");
const wrapMethod = require("./util/core/wrap-method");
const valueToString = require("@sinonjs/commons").valueToString;

/* cache references to library methods so that they also can be stubbed without problems */
const forEach = arrayProto.forEach;
const pop = arrayProto.pop;
const push = arrayProto.push;
const slice = arrayProto.slice;
const filter = Array.prototype.filter;

let uuid = 0;

function matches(fake, args, strict) {
    const margs = fake.matchingArguments;
    if (
        margs.length <= args.length &&
        deepEqual(slice(args, 0, margs.length), margs)
    ) {
        return !strict || margs.length === args.length;
    }
    return false;
}

// Public API
const spyApi = {
    withArgs: function () {
        const args = slice(arguments);
        const matching = pop(this.matchingFakes(args, true));
        if (matching) {
            return matching;
        }

        const original = this;
        const fake = this.instantiateFake();
        fake.matchingArguments = args;
        fake.parent = this;
        push(this.fakes, fake);

        fake.withArgs = function () {
            return original.withArgs.apply(original, arguments);
        };

        forEach(original.args, function (arg, i) {
            if (!matches(fake, arg)) {
                return;
            }

            proxyCallUtil.incrementCallCount(fake);
            push(fake.thisValues, original.thisValues[i]);
            push(fake.args, arg);
            push(fake.returnValues, original.returnValues[i]);
            push(fake.exceptions, original.exceptions[i]);
            push(fake.callIds, original.callIds[i]);
        });

        proxyCallUtil.createCallProperties(fake);

        return fake;
    },

    // Override proxy default implementation
    matchingFakes: function (args, strict) {
        return filter.call(this.fakes, function (fake) {
            return matches(fake, args, strict);
        });
    },
};

/* eslint-disable @sinonjs/no-prototype-methods/no-prototype-methods */
const delegateToCalls = proxyCallUtil.delegateToCalls;
delegateToCalls(spyApi, "callArg", false, "callArgWith", true, function () {
    throw new Error(
        `${this.toString()} cannot call arg since it was not yet invoked.`,
    );
});
spyApi.callArgWith = spyApi.callArg;
delegateToCalls(spyApi, "callArgOn", false, "callArgOnWith", true, function () {
    throw new Error(
        `${this.toString()} cannot call arg since it was not yet invoked.`,
    );
});
spyApi.callArgOnWith = spyApi.callArgOn;
delegateToCalls(spyApi, "throwArg", false, "throwArg", false, function () {
    throw new Error(
        `${this.toString()} cannot throw arg since it was not yet invoked.`,
    );
});
delegateToCalls(spyApi, "yield", false, "yield", true, function () {
    throw new Error(
        `${this.toString()} cannot yield since it was not yet invoked.`,
    );
});
// "invokeCallback" is an alias for "yield" since "yield" is invalid in strict mode.
spyApi.invokeCallback = spyApi.yield;
delegateToCalls(spyApi, "yieldOn", false, "yieldOn", true, function () {
    throw new Error(
        `${this.toString()} cannot yield since it was not yet invoked.`,
    );
});
delegateToCalls(spyApi, "yieldTo", false, "yieldTo", true, function (property) {
    throw new Error(
        `${this.toString()} cannot yield to '${valueToString(
            property,
        )}' since it was not yet invoked.`,
    );
});
delegateToCalls(
    spyApi,
    "yieldToOn",
    false,
    "yieldToOn",
    true,
    function (property) {
        throw new Error(
            `${this.toString()} cannot yield to '${valueToString(
                property,
            )}' since it was not yet invoked.`,
        );
    },
);

function createSpy(func) {
    let name;
    let funk = func;

    if (typeof funk !== "function") {
        funk = function () {
            return;
        };
    } else {
        name = functionName(funk);
    }

    const proxy = createProxy(funk, funk);

    // Inherit spy API:
    extend.nonEnum(proxy, spyApi);
    extend.nonEnum(proxy, {
        displayName: name || "spy",
        fakes: [],
        instantiateFake: createSpy,
        id: `spy#${uuid++}`,
    });
    return proxy;
}

function spy(object, property, types) {
    if (isEsModule(object)) {
        throw new TypeError("ES Modules cannot be spied");
    }

    if (!property && typeof object === "function") {
        return createSpy(object);
    }

    if (!property && typeof object === "object") {
        return walkObject(spy, object);
    }

    if (!object && !property) {
        return createSpy(function () {
            return;
        });
    }

    if (!types) {
        return wrapMethod(object, property, createSpy(object[property]));
    }

    const descriptor = {};
    const methodDesc = getPropertyDescriptor(object, property);

    forEach(types, function (type) {
        descriptor[type] = createSpy(methodDesc[type]);
    });

    return wrapMethod(object, property, descriptor);
}

extend(spy, spyApi);
module.exports = spy;

},{"./proxy":17,"./proxy-call-util":14,"./util/core/extend":25,"./util/core/get-property-descriptor":28,"./util/core/is-es-module":29,"./util/core/walk-object":36,"./util/core/wrap-method":38,"@sinonjs/commons":46,"@sinonjs/samsam":86}],22:[function(require,module,exports){
"use strict";

const arrayProto = require("@sinonjs/commons").prototypes.array;
const behavior = require("./behavior");
const behaviors = require("./default-behaviors");
const createProxy = require("./proxy");
const functionName = require("@sinonjs/commons").functionName;
const hasOwnProperty =
    require("@sinonjs/commons").prototypes.object.hasOwnProperty;
const isNonExistentProperty = require("./util/core/is-non-existent-property");
const spy = require("./spy");
const extend = require("./util/core/extend");
const getPropertyDescriptor = require("./util/core/get-property-descriptor");
const isEsModule = require("./util/core/is-es-module");
const sinonType = require("./util/core/sinon-type");
const wrapMethod = require("./util/core/wrap-method");
const throwOnFalsyObject = require("./throw-on-falsy-object");
const valueToString = require("@sinonjs/commons").valueToString;
const walkObject = require("./util/core/walk-object");

const forEach = arrayProto.forEach;
const pop = arrayProto.pop;
const slice = arrayProto.slice;
const sort = arrayProto.sort;

let uuid = 0;

function createStub(originalFunc) {
    // eslint-disable-next-line prefer-const
    let proxy;

    function functionStub() {
        const args = slice(arguments);
        const matchings = proxy.matchingFakes(args);

        const fnStub =
            pop(
                sort(matchings, function (a, b) {
                    return (
                        a.matchingArguments.length - b.matchingArguments.length
                    );
                }),
            ) || proxy;
        return getCurrentBehavior(fnStub).invoke(this, arguments);
    }

    proxy = createProxy(functionStub, originalFunc || functionStub);
    // Inherit spy API:
    extend.nonEnum(proxy, spy);
    // Inherit stub API:
    extend.nonEnum(proxy, stub);

    const name = originalFunc ? functionName(originalFunc) : null;
    extend.nonEnum(proxy, {
        fakes: [],
        instantiateFake: createStub,
        displayName: name || "stub",
        defaultBehavior: null,
        behaviors: [],
        id: `stub#${uuid++}`,
    });

    sinonType.set(proxy, "stub");

    return proxy;
}

function stub(object, property) {
    if (arguments.length > 2) {
        throw new TypeError(
            "stub(obj, 'meth', fn) has been removed, see documentation",
        );
    }

    if (isEsModule(object)) {
        throw new TypeError("ES Modules cannot be stubbed");
    }

    throwOnFalsyObject.apply(null, arguments);

    if (isNonExistentProperty(object, property)) {
        throw new TypeError(
            `Cannot stub non-existent property ${valueToString(property)}`,
        );
    }

    const actualDescriptor = getPropertyDescriptor(object, property);

    assertValidPropertyDescriptor(actualDescriptor, property);

    const isObjectOrFunction =
        typeof object === "object" || typeof object === "function";
    const isStubbingEntireObject =
        typeof property === "undefined" && isObjectOrFunction;
    const isCreatingNewStub = !object && typeof property === "undefined";
    const isStubbingNonFuncProperty =
        isObjectOrFunction &&
        typeof property !== "undefined" &&
        (typeof actualDescriptor === "undefined" ||
            typeof actualDescriptor.value !== "function");

    if (isStubbingEntireObject) {
        return walkObject(stub, object);
    }

    if (isCreatingNewStub) {
        return createStub();
    }

    const func =
        typeof actualDescriptor.value === "function"
            ? actualDescriptor.value
            : null;
    const s = createStub(func);

    extend.nonEnum(s, {
        rootObj: object,
        propName: property,
        shadowsPropOnPrototype: !actualDescriptor.isOwn,
        restore: function restore() {
            if (actualDescriptor !== undefined && actualDescriptor.isOwn) {
                Object.defineProperty(object, property, actualDescriptor);
                return;
            }

            delete object[property];
        },
    });

    return isStubbingNonFuncProperty ? s : wrapMethod(object, property, s);
}

function assertValidPropertyDescriptor(descriptor, property) {
    if (!descriptor || !property) {
        return;
    }
    if (descriptor.isOwn && !descriptor.configurable && !descriptor.writable) {
        throw new TypeError(
            `Descriptor for property ${property} is non-configurable and non-writable`,
        );
    }
    if ((descriptor.get || descriptor.set) && !descriptor.configurable) {
        throw new TypeError(
            `Descriptor for accessor property ${property} is non-configurable`,
        );
    }
    if (isDataDescriptor(descriptor) && !descriptor.writable) {
        throw new TypeError(
            `Descriptor for data property ${property} is non-writable`,
        );
    }
}

function isDataDescriptor(descriptor) {
    return (
        !descriptor.value &&
        !descriptor.writable &&
        !descriptor.set &&
        !descriptor.get
    );
}

/*eslint-disable no-use-before-define*/
function getParentBehaviour(stubInstance) {
    return stubInstance.parent && getCurrentBehavior(stubInstance.parent);
}

function getDefaultBehavior(stubInstance) {
    return (
        stubInstance.defaultBehavior ||
        getParentBehaviour(stubInstance) ||
        behavior.create(stubInstance)
    );
}

function getCurrentBehavior(stubInstance) {
    const currentBehavior = stubInstance.behaviors[stubInstance.callCount - 1];
    return currentBehavior && currentBehavior.isPresent()
        ? currentBehavior
        : getDefaultBehavior(stubInstance);
}
/*eslint-enable no-use-before-define*/

const proto = {
    resetBehavior: function () {
        this.defaultBehavior = null;
        this.behaviors = [];

        delete this.returnValue;
        delete this.returnArgAt;
        delete this.throwArgAt;
        delete this.resolveArgAt;
        delete this.fakeFn;
        this.returnThis = false;
        this.resolveThis = false;

        forEach(this.fakes, function (fake) {
            fake.resetBehavior();
        });
    },

    reset: function () {
        this.resetHistory();
        this.resetBehavior();
    },

    onCall: function onCall(index) {
        if (!this.behaviors[index]) {
            this.behaviors[index] = behavior.create(this);
        }

        return this.behaviors[index];
    },

    onFirstCall: function onFirstCall() {
        return this.onCall(0);
    },

    onSecondCall: function onSecondCall() {
        return this.onCall(1);
    },

    onThirdCall: function onThirdCall() {
        return this.onCall(2);
    },

    withArgs: function withArgs() {
        const fake = spy.withArgs.apply(this, arguments);
        if (this.defaultBehavior && this.defaultBehavior.promiseLibrary) {
            fake.defaultBehavior =
                fake.defaultBehavior || behavior.create(fake);
            fake.defaultBehavior.promiseLibrary =
                this.defaultBehavior.promiseLibrary;
        }
        return fake;
    },
};

forEach(Object.keys(behavior), function (method) {
    if (
        hasOwnProperty(behavior, method) &&
        !hasOwnProperty(proto, method) &&
        method !== "create" &&
        method !== "invoke"
    ) {
        proto[method] = behavior.createBehavior(method);
    }
});

forEach(Object.keys(behaviors), function (method) {
    if (hasOwnProperty(behaviors, method) && !hasOwnProperty(proto, method)) {
        behavior.addBehavior(stub, method, behaviors[method]);
    }
});

extend(stub, proto);
module.exports = stub;

},{"./behavior":4,"./default-behaviors":9,"./proxy":17,"./spy":21,"./throw-on-falsy-object":23,"./util/core/extend":25,"./util/core/get-property-descriptor":28,"./util/core/is-es-module":29,"./util/core/is-non-existent-property":30,"./util/core/sinon-type":34,"./util/core/walk-object":36,"./util/core/wrap-method":38,"@sinonjs/commons":46}],23:[function(require,module,exports){
"use strict";
const valueToString = require("@sinonjs/commons").valueToString;

function throwOnFalsyObject(object, property) {
    if (property && !object) {
        const type = object === null ? "null" : "undefined";
        throw new Error(
            `Trying to stub property '${valueToString(property)}' of ${type}`,
        );
    }
}

module.exports = throwOnFalsyObject;

},{"@sinonjs/commons":46}],24:[function(require,module,exports){
"use strict";

const arrayProto = require("@sinonjs/commons").prototypes.array;
const reduce = arrayProto.reduce;

module.exports = function exportAsyncBehaviors(behaviorMethods) {
    return reduce(
        Object.keys(behaviorMethods),
        function (acc, method) {
            // need to avoid creating another async versions of the newly added async methods
            if (method.match(/^(callsArg|yields)/) && !method.match(/Async/)) {
                acc[`${method}Async`] = function () {
                    const result = behaviorMethods[method].apply(
                        this,
                        arguments,
                    );
                    this.callbackAsync = true;
                    return result;
                };
            }
            return acc;
        },
        {},
    );
};

},{"@sinonjs/commons":46}],25:[function(require,module,exports){
"use strict";

const arrayProto = require("@sinonjs/commons").prototypes.array;
const hasOwnProperty =
    require("@sinonjs/commons").prototypes.object.hasOwnProperty;

const join = arrayProto.join;
const push = arrayProto.push;

// Adapted from https://developer.mozilla.org/en/docs/ECMAScript_DontEnum_attribute#JScript_DontEnum_Bug
const hasDontEnumBug = (function () {
    const obj = {
        constructor: function () {
            return "0";
        },
        toString: function () {
            return "1";
        },
        valueOf: function () {
            return "2";
        },
        toLocaleString: function () {
            return "3";
        },
        prototype: function () {
            return "4";
        },
        isPrototypeOf: function () {
            return "5";
        },
        propertyIsEnumerable: function () {
            return "6";
        },
        hasOwnProperty: function () {
            return "7";
        },
        length: function () {
            return "8";
        },
        unique: function () {
            return "9";
        },
    };

    const result = [];
    for (const prop in obj) {
        if (hasOwnProperty(obj, prop)) {
            push(result, obj[prop]());
        }
    }
    return join(result, "") !== "0123456789";
})();

/**
 *
 * @param target
 * @param sources
 * @param doCopy
 * @returns {*} target
 */
function extendCommon(target, sources, doCopy) {
    let source, i, prop;

    for (i = 0; i < sources.length; i++) {
        source = sources[i];

        for (prop in source) {
            if (hasOwnProperty(source, prop)) {
                doCopy(target, source, prop);
            }
        }

        // Make sure we copy (own) toString method even when in JScript with DontEnum bug
        // See https://developer.mozilla.org/en/docs/ECMAScript_DontEnum_attribute#JScript_DontEnum_Bug
        if (
            hasDontEnumBug &&
            hasOwnProperty(source, "toString") &&
            source.toString !== target.toString
        ) {
            target.toString = source.toString;
        }
    }

    return target;
}

/**
 * Public: Extend target in place with all (own) properties, except 'name' when [[writable]] is false,
 *         from sources in-order. Thus, last source will override properties in previous sources.
 *
 * @param {object} target - The Object to extend
 * @param {object[]} sources - Objects to copy properties from.
 * @returns {object} the extended target
 */
module.exports = function extend(target, ...sources) {
    return extendCommon(
        target,
        sources,
        function copyValue(dest, source, prop) {
            const destOwnPropertyDescriptor = Object.getOwnPropertyDescriptor(
                dest,
                prop,
            );
            const sourceOwnPropertyDescriptor = Object.getOwnPropertyDescriptor(
                source,
                prop,
            );

            if (prop === "name" && !destOwnPropertyDescriptor.writable) {
                return;
            }
            const descriptors = {
                configurable: sourceOwnPropertyDescriptor.configurable,
                enumerable: sourceOwnPropertyDescriptor.enumerable,
            };
            /*
                if the source has an Accessor property copy over the accessor functions (get and set)
                data properties has writable attribute where as accessor property don't
                REF: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Data_structures#properties
            */

            if (hasOwnProperty(sourceOwnPropertyDescriptor, "writable")) {
                descriptors.writable = sourceOwnPropertyDescriptor.writable;
                descriptors.value = sourceOwnPropertyDescriptor.value;
            } else {
                if (sourceOwnPropertyDescriptor.get) {
                    descriptors.get =
                        sourceOwnPropertyDescriptor.get.bind(dest);
                }
                if (sourceOwnPropertyDescriptor.set) {
                    descriptors.set =
                        sourceOwnPropertyDescriptor.set.bind(dest);
                }
            }
            Object.defineProperty(dest, prop, descriptors);
        },
    );
};

/**
 * Public: Extend target in place with all (own) properties from sources in-order. Thus, last source will
 *         override properties in previous sources. Define the properties as non enumerable.
 *
 * @param {object} target - The Object to extend
 * @param {object[]} sources - Objects to copy properties from.
 * @returns {object} the extended target
 */
module.exports.nonEnum = function extendNonEnum(target, ...sources) {
    return extendCommon(
        target,
        sources,
        function copyProperty(dest, source, prop) {
            Object.defineProperty(dest, prop, {
                value: source[prop],
                enumerable: false,
                configurable: true,
                writable: true,
            });
        },
    );
};

},{"@sinonjs/commons":46}],26:[function(require,module,exports){
"use strict";

module.exports = function toString() {
    let i, prop, thisValue;
    if (this.getCall && this.callCount) {
        i = this.callCount;

        while (i--) {
            thisValue = this.getCall(i).thisValue;

            // eslint-disable-next-line guard-for-in
            for (prop in thisValue) {
                try {
                    if (thisValue[prop] === this) {
                        return prop;
                    }
                } catch (e) {
                    // no-op - accessing props can throw an error, nothing to do here
                }
            }
        }
    }

    return this.displayName || "sinon fake";
};

},{}],27:[function(require,module,exports){
"use strict";

/* istanbul ignore next : not testing that setTimeout works */
function nextTick(callback) {
    setTimeout(callback, 0);
}

module.exports = function getNextTick(process, setImmediate) {
    if (typeof process === "object" && typeof process.nextTick === "function") {
        return process.nextTick;
    }

    if (typeof setImmediate === "function") {
        return setImmediate;
    }

    return nextTick;
};

},{}],28:[function(require,module,exports){
"use strict";

/**
 * @typedef {object} PropertyDescriptor
 * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/defineProperty#description
 * @property {boolean} configurable defaults to false
 * @property {boolean} enumerable   defaults to false
 * @property {boolean} writable     defaults to false
 * @property {*} value defaults to undefined
 * @property {Function} get defaults to undefined
 * @property {Function} set defaults to undefined
 */

/*
 * The following type def is strictly speaking illegal in JSDoc, but the expression forms a
 * legal Typescript union type and is understood by Visual Studio and the IntelliJ
 * family of editors. The "TS" flavor of JSDoc is becoming the de-facto standard these
 * days for that reason (and the fact that JSDoc is essentially unmaintained)
 */

/**
 * @typedef {{isOwn: boolean} & PropertyDescriptor} SinonPropertyDescriptor
 * a slightly enriched property descriptor
 * @property {boolean} isOwn true if the descriptor is owned by this object, false if it comes from the prototype
 */

/**
 * Returns a slightly modified property descriptor that one can tell is from the object or the prototype
 *
 * @param {*} object
 * @param {string} property
 * @returns {SinonPropertyDescriptor}
 */
function getPropertyDescriptor(object, property) {
    let proto = object;
    let descriptor;
    const isOwn = Boolean(
        object && Object.getOwnPropertyDescriptor(object, property),
    );

    while (
        proto &&
        !(descriptor = Object.getOwnPropertyDescriptor(proto, property))
    ) {
        proto = Object.getPrototypeOf(proto);
    }

    if (descriptor) {
        descriptor.isOwn = isOwn;
    }

    return descriptor;
}

module.exports = getPropertyDescriptor;

},{}],29:[function(require,module,exports){
"use strict";

/**
 * Verify if an object is a ECMAScript Module
 *
 * As the exports from a module is immutable we cannot alter the exports
 * using spies or stubs. Let the consumer know this to avoid bug reports
 * on weird error messages.
 *
 * @param {object} object The object to examine
 * @returns {boolean} true when the object is a module
 */
module.exports = function (object) {
    return (
        object &&
        typeof Symbol !== "undefined" &&
        object[Symbol.toStringTag] === "Module" &&
        Object.isSealed(object)
    );
};

},{}],30:[function(require,module,exports){
"use strict";

/**
 * @param {*} object
 * @param {string} property
 * @returns {boolean} whether a prop exists in the prototype chain
 */
function isNonExistentProperty(object, property) {
    return Boolean(
        object && typeof property !== "undefined" && !(property in object),
    );
}

module.exports = isNonExistentProperty;

},{}],31:[function(require,module,exports){
"use strict";

const getPropertyDescriptor = require("./get-property-descriptor");

function isPropertyConfigurable(obj, propName) {
    const propertyDescriptor = getPropertyDescriptor(obj, propName);

    return propertyDescriptor ? propertyDescriptor.configurable : true;
}

module.exports = isPropertyConfigurable;

},{"./get-property-descriptor":28}],32:[function(require,module,exports){
"use strict";

function isRestorable(obj) {
    return (
        typeof obj === "function" &&
        typeof obj.restore === "function" &&
        obj.restore.sinon
    );
}

module.exports = isRestorable;

},{}],33:[function(require,module,exports){
"use strict";

const globalObject = require("@sinonjs/commons").global;
const getNextTick = require("./get-next-tick");

module.exports = getNextTick(globalObject.process, globalObject.setImmediate);

},{"./get-next-tick":27,"@sinonjs/commons":46}],34:[function(require,module,exports){
"use strict";

const sinonTypeSymbolProperty = Symbol("SinonType");

module.exports = {
    /**
     * Set the type of a Sinon object to make it possible to identify it later at runtime
     *
     * @param {object|Function} object  object/function to set the type on
     * @param {string} type the named type of the object/function
     */
    set(object, type) {
        Object.defineProperty(object, sinonTypeSymbolProperty, {
            value: type,
            configurable: false,
            enumerable: false,
        });
    },
    get(object) {
        return object && object[sinonTypeSymbolProperty];
    },
};

},{}],35:[function(require,module,exports){
"use strict";

const array = [null, "once", "twice", "thrice"];

module.exports = function timesInWords(count) {
    return array[count] || `${count || 0} times`;
};

},{}],36:[function(require,module,exports){
"use strict";

const functionName = require("@sinonjs/commons").functionName;

const getPropertyDescriptor = require("./get-property-descriptor");
const walk = require("./walk");

/**
 * A utility that allows traversing an object, applying mutating functions on the properties
 *
 * @param {Function} mutator called on each property
 * @param {object} object the object we are walking over
 * @param {Function} filter a predicate (boolean function) that will decide whether or not to apply the mutator to the current property
 * @returns {void} nothing
 */
function walkObject(mutator, object, filter) {
    let called = false;
    const name = functionName(mutator);

    if (!object) {
        throw new Error(
            `Trying to ${name} object but received ${String(object)}`,
        );
    }

    walk(object, function (prop, propOwner) {
        // we don't want to stub things like toString(), valueOf(), etc. so we only stub if the object
        // is not Object.prototype
        if (
            propOwner !== Object.prototype &&
            prop !== "constructor" &&
            typeof getPropertyDescriptor(propOwner, prop).value === "function"
        ) {
            if (filter) {
                if (filter(object, prop)) {
                    called = true;
                    mutator(object, prop);
                }
            } else {
                called = true;
                mutator(object, prop);
            }
        }
    });

    if (!called) {
        throw new Error(
            `Found no methods on object to which we could apply mutations`,
        );
    }

    return object;
}

module.exports = walkObject;

},{"./get-property-descriptor":28,"./walk":37,"@sinonjs/commons":46}],37:[function(require,module,exports){
"use strict";

const forEach = require("@sinonjs/commons").prototypes.array.forEach;

function walkInternal(obj, iterator, context, originalObj, seen) {
    let prop;
    const proto = Object.getPrototypeOf(obj);

    if (typeof Object.getOwnPropertyNames !== "function") {
        // We explicitly want to enumerate through all of the prototype's properties
        // in this case, therefore we deliberately leave out an own property check.
        /* eslint-disable-next-line guard-for-in */
        for (prop in obj) {
            iterator.call(context, obj[prop], prop, obj);
        }

        return;
    }

    forEach(Object.getOwnPropertyNames(obj), function (k) {
        if (seen[k] !== true) {
            seen[k] = true;
            const target =
                typeof Object.getOwnPropertyDescriptor(obj, k).get ===
                "function"
                    ? originalObj
                    : obj;
            iterator.call(context, k, target);
        }
    });

    if (proto) {
        walkInternal(proto, iterator, context, originalObj, seen);
    }
}

/* Walks the prototype chain of an object and iterates over every own property
 * name encountered. The iterator is called in the same fashion that Array.prototype.forEach
 * works, where it is passed the value, key, and own object as the 1st, 2nd, and 3rd positional
 * argument, respectively. In cases where Object.getOwnPropertyNames is not available, walk will
 * default to using a simple for..in loop.
 *
 * obj - The object to walk the prototype chain for.
 * iterator - The function to be called on each pass of the walk.
 * context - (Optional) When given, the iterator will be called with this object as the receiver.
 */
module.exports = function walk(obj, iterator, context) {
    return walkInternal(obj, iterator, context, obj, {});
};

},{"@sinonjs/commons":46}],38:[function(require,module,exports){
"use strict";

// eslint-disable-next-line no-empty-function
const noop = () => {};
const getPropertyDescriptor = require("./get-property-descriptor");
const extend = require("./extend");
const sinonType = require("./sinon-type");
const hasOwnProperty =
    require("@sinonjs/commons").prototypes.object.hasOwnProperty;
const valueToString = require("@sinonjs/commons").valueToString;
const push = require("@sinonjs/commons").prototypes.array.push;

function isFunction(obj) {
    return (
        typeof obj === "function" ||
        Boolean(obj && obj.constructor && obj.call && obj.apply)
    );
}

function mirrorProperties(target, source) {
    for (const prop in source) {
        if (!hasOwnProperty(target, prop)) {
            target[prop] = source[prop];
        }
    }
}

function getAccessor(object, property, method) {
    const accessors = ["get", "set"];
    const descriptor = getPropertyDescriptor(object, property);

    for (let i = 0; i < accessors.length; i++) {
        if (
            descriptor[accessors[i]] &&
            descriptor[accessors[i]].name === method.name
        ) {
            return accessors[i];
        }
    }
    return null;
}

// Cheap way to detect if we have ES5 support.
const hasES5Support = "keys" in Object;

module.exports = function wrapMethod(object, property, method) {
    if (!object) {
        throw new TypeError("Should wrap property of object");
    }

    if (typeof method !== "function" && typeof method !== "object") {
        throw new TypeError(
            "Method wrapper should be a function or a property descriptor",
        );
    }

    function checkWrappedMethod(wrappedMethod) {
        let error;

        if (!isFunction(wrappedMethod)) {
            error = new TypeError(
                `Attempted to wrap ${typeof wrappedMethod} property ${valueToString(
                    property,
                )} as function`,
            );
        } else if (wrappedMethod.restore && wrappedMethod.restore.sinon) {
            error = new TypeError(
                `Attempted to wrap ${valueToString(
                    property,
                )} which is already wrapped`,
            );
        } else if (wrappedMethod.calledBefore) {
            const verb = wrappedMethod.returns ? "stubbed" : "spied on";
            error = new TypeError(
                `Attempted to wrap ${valueToString(
                    property,
                )} which is already ${verb}`,
            );
        }

        if (error) {
            if (wrappedMethod && wrappedMethod.stackTraceError) {
                error.stack += `\n--------------\n${wrappedMethod.stackTraceError.stack}`;
            }
            throw error;
        }
    }

    let error, wrappedMethod, i, wrappedMethodDesc, target, accessor;

    const wrappedMethods = [];

    function simplePropertyAssignment() {
        wrappedMethod = object[property];
        checkWrappedMethod(wrappedMethod);
        object[property] = method;
        method.displayName = property;
    }

    // Firefox has a problem when using hasOwn.call on objects from other frames.
    const owned = object.hasOwnProperty
        ? object.hasOwnProperty(property) // eslint-disable-line @sinonjs/no-prototype-methods/no-prototype-methods
        : hasOwnProperty(object, property);

    if (hasES5Support) {
        const methodDesc =
            typeof method === "function" ? { value: method } : method;
        wrappedMethodDesc = getPropertyDescriptor(object, property);

        if (!wrappedMethodDesc) {
            error = new TypeError(
                `Attempted to wrap ${typeof wrappedMethod} property ${property} as function`,
            );
        } else if (
            wrappedMethodDesc.restore &&
            wrappedMethodDesc.restore.sinon
        ) {
            error = new TypeError(
                `Attempted to wrap ${property} which is already wrapped`,
            );
        }
        if (error) {
            if (wrappedMethodDesc && wrappedMethodDesc.stackTraceError) {
                error.stack += `\n--------------\n${wrappedMethodDesc.stackTraceError.stack}`;
            }
            throw error;
        }

        const types = Object.keys(methodDesc);
        for (i = 0; i < types.length; i++) {
            wrappedMethod = wrappedMethodDesc[types[i]];
            checkWrappedMethod(wrappedMethod);
            push(wrappedMethods, wrappedMethod);
        }

        mirrorProperties(methodDesc, wrappedMethodDesc);
        for (i = 0; i < types.length; i++) {
            mirrorProperties(methodDesc[types[i]], wrappedMethodDesc[types[i]]);
        }

        // you are not allowed to flip the configurable prop on an
        // existing descriptor to anything but false (#2514)
        if (!owned) {
            methodDesc.configurable = true;
        }

        Object.defineProperty(object, property, methodDesc);

        // catch failing assignment
        // this is the converse of the check in `.restore` below
        if (typeof method === "function" && object[property] !== method) {
            // correct any wrongdoings caused by the defineProperty call above,
            // such as adding new items (if object was a Storage object)
            delete object[property];
            simplePropertyAssignment();
        }
    } else {
        simplePropertyAssignment();
    }

    extendObjectWithWrappedMethods();

    function extendObjectWithWrappedMethods() {
        for (i = 0; i < wrappedMethods.length; i++) {
            accessor = getAccessor(object, property, wrappedMethods[i]);
            target = accessor ? method[accessor] : method;
            extend.nonEnum(target, {
                displayName: property,
                wrappedMethod: wrappedMethods[i],

                // Set up an Error object for a stack trace which can be used later to find what line of
                // code the original method was created on.
                stackTraceError: new Error("Stack Trace for original"),

                restore: restore,
            });

            target.restore.sinon = true;
            if (!hasES5Support) {
                mirrorProperties(target, wrappedMethod);
            }
        }
    }

    function restore() {
        accessor = getAccessor(object, property, this.wrappedMethod);
        let descriptor;
        // For prototype properties try to reset by delete first.
        // If this fails (ex: localStorage on mobile safari) then force a reset
        // via direct assignment.
        if (accessor) {
            if (!owned) {
                try {
                    // In some cases `delete` may throw an error
                    delete object[property][accessor];
                } catch (e) {} // eslint-disable-line no-empty
                // For native code functions `delete` fails without throwing an error
                // on Chrome < 43, PhantomJS, etc.
            } else if (hasES5Support) {
                descriptor = getPropertyDescriptor(object, property);
                descriptor[accessor] = wrappedMethodDesc[accessor];
                Object.defineProperty(object, property, descriptor);
            }

            if (hasES5Support) {
                descriptor = getPropertyDescriptor(object, property);
                if (descriptor && descriptor.value === target) {
                    object[property][accessor] = this.wrappedMethod;
                }
            } else {
                // Use strict equality comparison to check failures then force a reset
                // via direct assignment.
                if (object[property][accessor] === target) {
                    object[property][accessor] = this.wrappedMethod;
                }
            }
        } else {
            if (!owned) {
                try {
                    delete object[property];
                } catch (e) {} // eslint-disable-line no-empty
            } else if (hasES5Support) {
                Object.defineProperty(object, property, wrappedMethodDesc);
            }

            if (hasES5Support) {
                descriptor = getPropertyDescriptor(object, property);
                if (descriptor && descriptor.value === target) {
                    object[property] = this.wrappedMethod;
                }
            } else {
                if (object[property] === target) {
                    object[property] = this.wrappedMethod;
                }
            }
        }
        if (sinonType.get(object) === "stub-instance") {
            // this is simply to avoid errors after restoring if something should
            // traverse the object in a cleanup phase, ref #2477
            object[property] = noop;
        }
    }

    return method;
};

},{"./extend":25,"./get-property-descriptor":28,"./sinon-type":34,"@sinonjs/commons":46}],39:[function(require,module,exports){
"use strict";

const extend = require("./core/extend");
const FakeTimers = require("@sinonjs/fake-timers");
const globalObject = require("@sinonjs/commons").global;

/**
 *
 * @param config
 * @param globalCtx
 *
 * @returns {object} the clock, after installing it on the global context, if given
 */
function createClock(config, globalCtx) {
    let FakeTimersCtx = FakeTimers;
    if (globalCtx !== null && typeof globalCtx === "object") {
        FakeTimersCtx = FakeTimers.withGlobal(globalCtx);
    }
    const clock = FakeTimersCtx.install(config);
    clock.restore = clock.uninstall;
    return clock;
}

/**
 *
 * @param obj
 * @param globalPropName
 */
function addIfDefined(obj, globalPropName) {
    const globalProp = globalObject[globalPropName];
    if (typeof globalProp !== "undefined") {
        obj[globalPropName] = globalProp;
    }
}

/**
 * @param {number|Date|object} dateOrConfig The unix epoch value to install with (default 0)
 * @returns {object} Returns a lolex clock instance
 */
exports.useFakeTimers = function (dateOrConfig) {
    const hasArguments = typeof dateOrConfig !== "undefined";
    const argumentIsDateLike =
        (typeof dateOrConfig === "number" || dateOrConfig instanceof Date) &&
        arguments.length === 1;
    const argumentIsObject =
        dateOrConfig !== null &&
        typeof dateOrConfig === "object" &&
        arguments.length === 1;

    if (!hasArguments) {
        return createClock({
            now: 0,
        });
    }

    if (argumentIsDateLike) {
        return createClock({
            now: dateOrConfig,
        });
    }

    if (argumentIsObject) {
        const config = extend.nonEnum({}, dateOrConfig);
        const globalCtx = config.global;
        delete config.global;
        return createClock(config, globalCtx);
    }

    throw new TypeError(
        "useFakeTimers expected epoch or config object. See https://github.com/sinonjs/sinon",
    );
};

exports.clock = {
    create: function (now) {
        return FakeTimers.createClock(now);
    },
};

const timers = {
    setTimeout: setTimeout,
    clearTimeout: clearTimeout,
    setInterval: setInterval,
    clearInterval: clearInterval,
    Date: Date,
};
addIfDefined(timers, "setImmediate");
addIfDefined(timers, "clearImmediate");

exports.timers = timers;

},{"./core/extend":25,"@sinonjs/commons":46,"@sinonjs/fake-timers":59}],40:[function(require,module,exports){
"use strict";

var every = require("./prototypes/array").every;

/**
 * @private
 */
function hasCallsLeft(callMap, spy) {
    if (callMap[spy.id] === undefined) {
        callMap[spy.id] = 0;
    }

    return callMap[spy.id] < spy.callCount;
}

/**
 * @private
 */
function checkAdjacentCalls(callMap, spy, index, spies) {
    var calledBeforeNext = true;

    if (index !== spies.length - 1) {
        calledBeforeNext = spy.calledBefore(spies[index + 1]);
    }

    if (hasCallsLeft(callMap, spy) && calledBeforeNext) {
        callMap[spy.id] += 1;
        return true;
    }

    return false;
}

/**
 * A Sinon proxy object (fake, spy, stub)
 * @typedef {object} SinonProxy
 * @property {Function} calledBefore - A method that determines if this proxy was called before another one
 * @property {string} id - Some id
 * @property {number} callCount - Number of times this proxy has been called
 */

/**
 * Returns true when the spies have been called in the order they were supplied in
 * @param  {SinonProxy[] | SinonProxy} spies An array of proxies, or several proxies as arguments
 * @returns {boolean} true when spies are called in order, false otherwise
 */
function calledInOrder(spies) {
    var callMap = {};
    // eslint-disable-next-line no-underscore-dangle
    var _spies = arguments.length > 1 ? arguments : spies;

    return every(_spies, checkAdjacentCalls.bind(null, callMap));
}

module.exports = calledInOrder;

},{"./prototypes/array":48}],41:[function(require,module,exports){
"use strict";

/**
 * Returns a display name for a value from a constructor
 * @param  {object} value A value to examine
 * @returns {(string|null)} A string or null
 */
function className(value) {
    const name = value.constructor && value.constructor.name;
    return name || null;
}

module.exports = className;

},{}],42:[function(require,module,exports){
/* eslint-disable no-console */
"use strict";

/**
 * Returns a function that will invoke the supplied function and print a
 * deprecation warning to the console each time it is called.
 * @param  {Function} func
 * @param  {string} msg
 * @returns {Function}
 */
exports.wrap = function (func, msg) {
    var wrapped = function () {
        exports.printWarning(msg);
        return func.apply(this, arguments);
    };
    if (func.prototype) {
        wrapped.prototype = func.prototype;
    }
    return wrapped;
};

/**
 * Returns a string which can be supplied to `wrap()` to notify the user that a
 * particular part of the sinon API has been deprecated.
 * @param  {string} packageName
 * @param  {string} funcName
 * @returns {string}
 */
exports.defaultMsg = function (packageName, funcName) {
    return `${packageName}.${funcName} is deprecated and will be removed from the public API in a future version of ${packageName}.`;
};

/**
 * Prints a warning on the console, when it exists
 * @param  {string} msg
 * @returns {undefined}
 */
exports.printWarning = function (msg) {
    /* istanbul ignore next */
    if (typeof process === "object" && process.emitWarning) {
        // Emit Warnings in Node
        process.emitWarning(msg);
    } else if (console.info) {
        console.info(msg);
    } else {
        console.log(msg);
    }
};

},{}],43:[function(require,module,exports){
"use strict";

/**
 * Returns true when fn returns true for all members of obj.
 * This is an every implementation that works for all iterables
 * @param  {object}   obj
 * @param  {Function} fn
 * @returns {boolean}
 */
module.exports = function every(obj, fn) {
    var pass = true;

    try {
        // eslint-disable-next-line @sinonjs/no-prototype-methods/no-prototype-methods
        obj.forEach(function () {
            if (!fn.apply(this, arguments)) {
                // Throwing an error is the only way to break `forEach`
                throw new Error();
            }
        });
    } catch (e) {
        pass = false;
    }

    return pass;
};

},{}],44:[function(require,module,exports){
"use strict";

/**
 * Returns a display name for a function
 * @param  {Function} func
 * @returns {string}
 */
module.exports = function functionName(func) {
    if (!func) {
        return "";
    }

    try {
        return (
            func.displayName ||
            func.name ||
            // Use function decomposition as a last resort to get function
            // name. Does not rely on function decomposition to work - if it
            // doesn't debugging will be slightly less informative
            // (i.e. toString will say 'spy' rather than 'myFunc').
            (String(func).match(/function ([^\s(]+)/) || [])[1]
        );
    } catch (e) {
        // Stringify may fail and we might get an exception, as a last-last
        // resort fall back to empty string.
        return "";
    }
};

},{}],45:[function(require,module,exports){
"use strict";

/**
 * A reference to the global object
 * @type {object} globalObject
 */
var globalObject;

/* istanbul ignore else */
if (typeof global !== "undefined") {
    // Node
    globalObject = global;
} else if (typeof window !== "undefined") {
    // Browser
    globalObject = window;
} else {
    // WebWorker
    globalObject = self;
}

module.exports = globalObject;

},{}],46:[function(require,module,exports){
"use strict";

module.exports = {
    global: require("./global"),
    calledInOrder: require("./called-in-order"),
    className: require("./class-name"),
    deprecated: require("./deprecated"),
    every: require("./every"),
    functionName: require("./function-name"),
    orderByFirstCall: require("./order-by-first-call"),
    prototypes: require("./prototypes"),
    typeOf: require("./type-of"),
    valueToString: require("./value-to-string"),
};

},{"./called-in-order":40,"./class-name":41,"./deprecated":42,"./every":43,"./function-name":44,"./global":45,"./order-by-first-call":47,"./prototypes":51,"./type-of":57,"./value-to-string":58}],47:[function(require,module,exports){
"use strict";

var sort = require("./prototypes/array").sort;
var slice = require("./prototypes/array").slice;

/**
 * @private
 */
function comparator(a, b) {
    // uuid, won't ever be equal
    var aCall = a.getCall(0);
    var bCall = b.getCall(0);
    var aId = (aCall && aCall.callId) || -1;
    var bId = (bCall && bCall.callId) || -1;

    return aId < bId ? -1 : 1;
}

/**
 * A Sinon proxy object (fake, spy, stub)
 * @typedef {object} SinonProxy
 * @property {Function} getCall - A method that can return the first call
 */

/**
 * Sorts an array of SinonProxy instances (fake, spy, stub) by their first call
 * @param  {SinonProxy[] | SinonProxy} spies
 * @returns {SinonProxy[]}
 */
function orderByFirstCall(spies) {
    return sort(slice(spies), comparator);
}

module.exports = orderByFirstCall;

},{"./prototypes/array":48}],48:[function(require,module,exports){
"use strict";

var copyPrototype = require("./copy-prototype-methods");

module.exports = copyPrototype(Array.prototype);

},{"./copy-prototype-methods":49}],49:[function(require,module,exports){
"use strict";

var call = Function.call;
var throwsOnProto = require("./throws-on-proto");

var disallowedProperties = [
    // ignore size because it throws from Map
    "size",
    "caller",
    "callee",
    "arguments",
];

// This branch is covered when tests are run with `--disable-proto=throw`,
// however we can test both branches at the same time, so this is ignored
/* istanbul ignore next */
if (throwsOnProto) {
    disallowedProperties.push("__proto__");
}

module.exports = function copyPrototypeMethods(prototype) {
    // eslint-disable-next-line @sinonjs/no-prototype-methods/no-prototype-methods
    return Object.getOwnPropertyNames(prototype).reduce(function (
        result,
        name
    ) {
        if (disallowedProperties.includes(name)) {
            return result;
        }

        if (typeof prototype[name] !== "function") {
            return result;
        }

        result[name] = call.bind(prototype[name]);

        return result;
    },
    Object.create(null));
};

},{"./throws-on-proto":56}],50:[function(require,module,exports){
"use strict";

var copyPrototype = require("./copy-prototype-methods");

module.exports = copyPrototype(Function.prototype);

},{"./copy-prototype-methods":49}],51:[function(require,module,exports){
"use strict";

module.exports = {
    array: require("./array"),
    function: require("./function"),
    map: require("./map"),
    object: require("./object"),
    set: require("./set"),
    string: require("./string"),
};

},{"./array":48,"./function":50,"./map":52,"./object":53,"./set":54,"./string":55}],52:[function(require,module,exports){
"use strict";

var copyPrototype = require("./copy-prototype-methods");

module.exports = copyPrototype(Map.prototype);

},{"./copy-prototype-methods":49}],53:[function(require,module,exports){
"use strict";

var copyPrototype = require("./copy-prototype-methods");

module.exports = copyPrototype(Object.prototype);

},{"./copy-prototype-methods":49}],54:[function(require,module,exports){
"use strict";

var copyPrototype = require("./copy-prototype-methods");

module.exports = copyPrototype(Set.prototype);

},{"./copy-prototype-methods":49}],55:[function(require,module,exports){
"use strict";

var copyPrototype = require("./copy-prototype-methods");

module.exports = copyPrototype(String.prototype);

},{"./copy-prototype-methods":49}],56:[function(require,module,exports){
"use strict";

/**
 * Is true when the environment causes an error to be thrown for accessing the
 * __proto__ property.
 * This is necessary in order to support `node --disable-proto=throw`.
 *
 * See https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/proto
 * @type {boolean}
 */
let throwsOnProto;
try {
    const object = {};
    // eslint-disable-next-line no-proto, no-unused-expressions
    object.__proto__;
    throwsOnProto = false;
} catch (_) {
    // This branch is covered when tests are run with `--disable-proto=throw`,
    // however we can test both branches at the same time, so this is ignored
    /* istanbul ignore next */
    throwsOnProto = true;
}

module.exports = throwsOnProto;

},{}],57:[function(require,module,exports){
"use strict";

var type = require("type-detect");

/**
 * Returns the lower-case result of running type from type-detect on the value
 * @param  {*} value
 * @returns {string}
 */
module.exports = function typeOf(value) {
    return type(value).toLowerCase();
};

},{"type-detect":94}],58:[function(require,module,exports){
"use strict";

/**
 * Returns a string representation of the value
 * @param  {*} value
 * @returns {string}
 */
function valueToString(value) {
    if (value && value.toString) {
        // eslint-disable-next-line @sinonjs/no-prototype-methods/no-prototype-methods
        return value.toString();
    }
    return String(value);
}

module.exports = valueToString;

},{}],59:[function(require,module,exports){
"use strict";

const globalObject = require("@sinonjs/commons").global;
let timersModule, timersPromisesModule;
if (typeof require === "function" && typeof module === "object") {
    try {
        timersModule = require("timers");
    } catch (e) {
        // ignored
    }
    try {
        timersPromisesModule = require("timers/promises");
    } catch (e) {
        // ignored
    }
}

/**
 * @typedef {object} IdleDeadline
 * @property {boolean} didTimeout - whether or not the callback was called before reaching the optional timeout
 * @property {function():number} timeRemaining - a floating-point value providing an estimate of the number of milliseconds remaining in the current idle period
 */

/**
 * Queues a function to be called during a browser's idle periods
 *
 * @callback RequestIdleCallback
 * @param {function(IdleDeadline)} callback
 * @param {{timeout: number}} options - an options object
 * @returns {number} the id
 */

/**
 * @callback NextTick
 * @param {VoidVarArgsFunc} callback - the callback to run
 * @param {...*} args - optional arguments to call the callback with
 * @returns {void}
 */

/**
 * @callback SetImmediate
 * @param {VoidVarArgsFunc} callback - the callback to run
 * @param {...*} args - optional arguments to call the callback with
 * @returns {NodeImmediate}
 */

/**
 * @callback VoidVarArgsFunc
 * @param {...*} callback - the callback to run
 * @returns {void}
 */

/**
 * @typedef RequestAnimationFrame
 * @property {function(number):void} requestAnimationFrame
 * @returns {number} - the id
 */

/**
 * @typedef Performance
 * @property {function(): number} now
 */

/* eslint-disable jsdoc/require-property-description */
/**
 * @typedef {object} Clock
 * @property {number} now - the current time
 * @property {Date} Date - the Date constructor
 * @property {number} loopLimit - the maximum number of timers before assuming an infinite loop
 * @property {RequestIdleCallback} requestIdleCallback
 * @property {function(number):void} cancelIdleCallback
 * @property {setTimeout} setTimeout
 * @property {clearTimeout} clearTimeout
 * @property {NextTick} nextTick
 * @property {queueMicrotask} queueMicrotask
 * @property {setInterval} setInterval
 * @property {clearInterval} clearInterval
 * @property {SetImmediate} setImmediate
 * @property {function(NodeImmediate):void} clearImmediate
 * @property {function():number} countTimers
 * @property {RequestAnimationFrame} requestAnimationFrame
 * @property {function(number):void} cancelAnimationFrame
 * @property {function():void} runMicrotasks
 * @property {function(string | number): number} tick
 * @property {function(string | number): Promise<number>} tickAsync
 * @property {function(): number} next
 * @property {function(): Promise<number>} nextAsync
 * @property {function(): number} runAll
 * @property {function(): number} runToFrame
 * @property {function(): Promise<number>} runAllAsync
 * @property {function(): number} runToLast
 * @property {function(): Promise<number>} runToLastAsync
 * @property {function(): void} reset
 * @property {function(number | Date): void} setSystemTime
 * @property {function(number): void} jump
 * @property {Performance} performance
 * @property {function(number[]): number[]} hrtime - process.hrtime (legacy)
 * @property {function(): void} uninstall Uninstall the clock.
 * @property {Function[]} methods - the methods that are faked
 * @property {boolean} [shouldClearNativeTimers] inherited from config
 * @property {{methodName:string, original:any}[] | undefined} timersModuleMethods
 * @property {{methodName:string, original:any}[] | undefined} timersPromisesModuleMethods
 * @property {Map<function(): void, AbortSignal>} abortListenerMap
 */
/* eslint-enable jsdoc/require-property-description */

/**
 * Configuration object for the `install` method.
 *
 * @typedef {object} Config
 * @property {number|Date} [now] a number (in milliseconds) or a Date object (default epoch)
 * @property {string[]} [toFake] names of the methods that should be faked.
 * @property {number} [loopLimit] the maximum number of timers that will be run when calling runAll()
 * @property {boolean} [shouldAdvanceTime] tells FakeTimers to increment mocked time automatically (default false)
 * @property {number} [advanceTimeDelta] increment mocked time every <<advanceTimeDelta>> ms (default: 20ms)
 * @property {boolean} [shouldClearNativeTimers] forwards clear timer calls to native functions if they are not fakes (default: false)
 * @property {boolean} [ignoreMissingTimers] default is false, meaning asking to fake timers that are not present will throw an error
 */

/* eslint-disable jsdoc/require-property-description */
/**
 * The internal structure to describe a scheduled fake timer
 *
 * @typedef {object} Timer
 * @property {Function} func
 * @property {*[]} args
 * @property {number} delay
 * @property {number} callAt
 * @property {number} createdAt
 * @property {boolean} immediate
 * @property {number} id
 * @property {Error} [error]
 */

/**
 * A Node timer
 *
 * @typedef {object} NodeImmediate
 * @property {function(): boolean} hasRef
 * @property {function(): NodeImmediate} ref
 * @property {function(): NodeImmediate} unref
 */
/* eslint-enable jsdoc/require-property-description */

/* eslint-disable complexity */

/**
 * Mocks available features in the specified global namespace.
 *
 * @param {*} _global Namespace to mock (e.g. `window`)
 * @returns {FakeTimers}
 */
function withGlobal(_global) {
    const maxTimeout = Math.pow(2, 31) - 1; //see https://heycam.github.io/webidl/#abstract-opdef-converttoint
    const idCounterStart = 1e12; // arbitrarily large number to avoid collisions with native timer IDs
    const NOOP = function () {
        return undefined;
    };
    const NOOP_ARRAY = function () {
        return [];
    };
    const isPresent = {};
    let timeoutResult,
        addTimerReturnsObject = false;

    if (_global.setTimeout) {
        isPresent.setTimeout = true;
        timeoutResult = _global.setTimeout(NOOP, 0);
        addTimerReturnsObject = typeof timeoutResult === "object";
    }
    isPresent.clearTimeout = Boolean(_global.clearTimeout);
    isPresent.setInterval = Boolean(_global.setInterval);
    isPresent.clearInterval = Boolean(_global.clearInterval);
    isPresent.hrtime =
        _global.process && typeof _global.process.hrtime === "function";
    isPresent.hrtimeBigint =
        isPresent.hrtime && typeof _global.process.hrtime.bigint === "function";
    isPresent.nextTick =
        _global.process && typeof _global.process.nextTick === "function";
    const utilPromisify = _global.process && require("util").promisify;
    isPresent.performance =
        _global.performance && typeof _global.performance.now === "function";
    const hasPerformancePrototype =
        _global.Performance &&
        (typeof _global.Performance).match(/^(function|object)$/);
    const hasPerformanceConstructorPrototype =
        _global.performance &&
        _global.performance.constructor &&
        _global.performance.constructor.prototype;
    isPresent.queueMicrotask = _global.hasOwnProperty("queueMicrotask");
    isPresent.requestAnimationFrame =
        _global.requestAnimationFrame &&
        typeof _global.requestAnimationFrame === "function";
    isPresent.cancelAnimationFrame =
        _global.cancelAnimationFrame &&
        typeof _global.cancelAnimationFrame === "function";
    isPresent.requestIdleCallback =
        _global.requestIdleCallback &&
        typeof _global.requestIdleCallback === "function";
    isPresent.cancelIdleCallbackPresent =
        _global.cancelIdleCallback &&
        typeof _global.cancelIdleCallback === "function";
    isPresent.setImmediate =
        _global.setImmediate && typeof _global.setImmediate === "function";
    isPresent.clearImmediate =
        _global.clearImmediate && typeof _global.clearImmediate === "function";
    isPresent.Intl = _global.Intl && typeof _global.Intl === "object";

    if (_global.clearTimeout) {
        _global.clearTimeout(timeoutResult);
    }

    const NativeDate = _global.Date;
    const NativeIntl = _global.Intl;
    let uniqueTimerId = idCounterStart;

    if (NativeDate === undefined) {
        throw new Error(
            "The global scope doesn't have a `Date` object" +
                " (see https://github.com/sinonjs/sinon/issues/1852#issuecomment-419622780)",
        );
    }
    isPresent.Date = true;

    /**
     * The PerformanceEntry object encapsulates a single performance metric
     * that is part of the browser's performance timeline.
     *
     * This is an object returned by the `mark` and `measure` methods on the Performance prototype
     */
    class FakePerformanceEntry {
        constructor(name, entryType, startTime, duration) {
            this.name = name;
            this.entryType = entryType;
            this.startTime = startTime;
            this.duration = duration;
        }

        toJSON() {
            return JSON.stringify({ ...this });
        }
    }

    /**
     * @param {number} num
     * @returns {boolean}
     */
    function isNumberFinite(num) {
        if (Number.isFinite) {
            return Number.isFinite(num);
        }

        return isFinite(num);
    }

    let isNearInfiniteLimit = false;

    /**
     * @param {Clock} clock
     * @param {number} i
     */
    function checkIsNearInfiniteLimit(clock, i) {
        if (clock.loopLimit && i === clock.loopLimit - 1) {
            isNearInfiniteLimit = true;
        }
    }

    /**
     *
     */
    function resetIsNearInfiniteLimit() {
        isNearInfiniteLimit = false;
    }

    /**
     * Parse strings like "01:10:00" (meaning 1 hour, 10 minutes, 0 seconds) into
     * number of milliseconds. This is used to support human-readable strings passed
     * to clock.tick()
     *
     * @param {string} str
     * @returns {number}
     */
    function parseTime(str) {
        if (!str) {
            return 0;
        }

        const strings = str.split(":");
        const l = strings.length;
        let i = l;
        let ms = 0;
        let parsed;

        if (l > 3 || !/^(\d\d:){0,2}\d\d?$/.test(str)) {
            throw new Error(
                "tick only understands numbers, 'm:s' and 'h:m:s'. Each part must be two digits",
            );
        }

        while (i--) {
            parsed = parseInt(strings[i], 10);

            if (parsed >= 60) {
                throw new Error(`Invalid time ${str}`);
            }

            ms += parsed * Math.pow(60, l - i - 1);
        }

        return ms * 1000;
    }

    /**
     * Get the decimal part of the millisecond value as nanoseconds
     *
     * @param {number} msFloat the number of milliseconds
     * @returns {number} an integer number of nanoseconds in the range [0,1e6)
     *
     * Example: nanoRemainer(123.456789) -> 456789
     */
    function nanoRemainder(msFloat) {
        const modulo = 1e6;
        const remainder = (msFloat * 1e6) % modulo;
        const positiveRemainder =
            remainder < 0 ? remainder + modulo : remainder;

        return Math.floor(positiveRemainder);
    }

    /**
     * Used to grok the `now` parameter to createClock.
     *
     * @param {Date|number} epoch the system time
     * @returns {number}
     */
    function getEpoch(epoch) {
        if (!epoch) {
            return 0;
        }
        if (typeof epoch.getTime === "function") {
            return epoch.getTime();
        }
        if (typeof epoch === "number") {
            return epoch;
        }
        throw new TypeError("now should be milliseconds since UNIX epoch");
    }

    /**
     * @param {number} from
     * @param {number} to
     * @param {Timer} timer
     * @returns {boolean}
     */
    function inRange(from, to, timer) {
        return timer && timer.callAt >= from && timer.callAt <= to;
    }

    /**
     * @param {Clock} clock
     * @param {Timer} job
     */
    function getInfiniteLoopError(clock, job) {
        const infiniteLoopError = new Error(
            `Aborting after running ${clock.loopLimit} timers, assuming an infinite loop!`,
        );

        if (!job.error) {
            return infiniteLoopError;
        }

        // pattern never matched in Node
        const computedTargetPattern = /target\.*[<|(|[].*?[>|\]|)]\s*/;
        let clockMethodPattern = new RegExp(
            String(Object.keys(clock).join("|")),
        );

        if (addTimerReturnsObject) {
            // node.js environment
            clockMethodPattern = new RegExp(
                `\\s+at (Object\\.)?(?:${Object.keys(clock).join("|")})\\s+`,
            );
        }

        let matchedLineIndex = -1;
        job.error.stack.split("\n").some(function (line, i) {
            // If we've matched a computed target line (e.g. setTimeout) then we
            // don't need to look any further. Return true to stop iterating.
            const matchedComputedTarget = line.match(computedTargetPattern);
            /* istanbul ignore if */
            if (matchedComputedTarget) {
                matchedLineIndex = i;
                return true;
            }

            // If we've matched a clock method line, then there may still be
            // others further down the trace. Return false to keep iterating.
            const matchedClockMethod = line.match(clockMethodPattern);
            if (matchedClockMethod) {
                matchedLineIndex = i;
                return false;
            }

            // If we haven't matched anything on this line, but we matched
            // previously and set the matched line index, then we can stop.
            // If we haven't matched previously, then we should keep iterating.
            return matchedLineIndex >= 0;
        });

        const stack = `${infiniteLoopError}\n${job.type || "Microtask"} - ${
            job.func.name || "anonymous"
        }\n${job.error.stack
            .split("\n")
            .slice(matchedLineIndex + 1)
            .join("\n")}`;

        try {
            Object.defineProperty(infiniteLoopError, "stack", {
                value: stack,
            });
        } catch (e) {
            // noop
        }

        return infiniteLoopError;
    }

    //eslint-disable-next-line jsdoc/require-jsdoc
    function createDate() {
        class ClockDate extends NativeDate {
            /**
             * @param {number} year
             * @param {number} month
             * @param {number} date
             * @param {number} hour
             * @param {number} minute
             * @param {number} second
             * @param {number} ms
             * @returns void
             */
            // eslint-disable-next-line no-unused-vars
            constructor(year, month, date, hour, minute, second, ms) {
                // Defensive and verbose to avoid potential harm in passing
                // explicit undefined when user does not pass argument
                if (arguments.length === 0) {
                    super(ClockDate.clock.now);
                } else {
                    super(...arguments);
                }

                // ensures identity checks using the constructor prop still works
                // this should have no other functional effect
                Object.defineProperty(this, "constructor", {
                    value: NativeDate,
                    enumerable: false,
                });
            }

            static [Symbol.hasInstance](instance) {
                return instance instanceof NativeDate;
            }
        }

        ClockDate.isFake = true;

        if (NativeDate.now) {
            ClockDate.now = function now() {
                return ClockDate.clock.now;
            };
        }

        if (NativeDate.toSource) {
            ClockDate.toSource = function toSource() {
                return NativeDate.toSource();
            };
        }

        ClockDate.toString = function toString() {
            return NativeDate.toString();
        };

        // noinspection UnnecessaryLocalVariableJS
        /**
         * A normal Class constructor cannot be called without `new`, but Date can, so we need
         * to wrap it in a Proxy in order to ensure this functionality of Date is kept intact
         *
         * @type {ClockDate}
         */
        const ClockDateProxy = new Proxy(ClockDate, {
            // handler for [[Call]] invocations (i.e. not using `new`)
            apply() {
                // the Date constructor called as a function, ref Ecma-262 Edition 5.1, section 15.9.2.
                // This remains so in the 10th edition of 2019 as well.
                if (this instanceof ClockDate) {
                    throw new TypeError(
                        "A Proxy should only capture `new` calls with the `construct` handler. This is not supposed to be possible, so check the logic.",
                    );
                }

                return new NativeDate(ClockDate.clock.now).toString();
            },
        });

        return ClockDateProxy;
    }

    /**
     * Mirror Intl by default on our fake implementation
     *
     * Most of the properties are the original native ones,
     * but we need to take control of those that have a
     * dependency on the current clock.
     *
     * @returns {object} the partly fake Intl implementation
     */
    function createIntl() {
        const ClockIntl = {};
        /*
         * All properties of Intl are non-enumerable, so we need
         * to do a bit of work to get them out.
         */
        Object.getOwnPropertyNames(NativeIntl).forEach(
            (property) => (ClockIntl[property] = NativeIntl[property]),
        );

        ClockIntl.DateTimeFormat = function (...args) {
            const realFormatter = new NativeIntl.DateTimeFormat(...args);
            const formatter = {};

            ["formatRange", "formatRangeToParts", "resolvedOptions"].forEach(
                (method) => {
                    formatter[method] =
                        realFormatter[method].bind(realFormatter);
                },
            );

            ["format", "formatToParts"].forEach((method) => {
                formatter[method] = function (date) {
                    return realFormatter[method](date || ClockIntl.clock.now);
                };
            });

            return formatter;
        };

        ClockIntl.DateTimeFormat.prototype = Object.create(
            NativeIntl.DateTimeFormat.prototype,
        );

        ClockIntl.DateTimeFormat.supportedLocalesOf =
            NativeIntl.DateTimeFormat.supportedLocalesOf;

        return ClockIntl;
    }

    //eslint-disable-next-line jsdoc/require-jsdoc
    function enqueueJob(clock, job) {
        // enqueues a microtick-deferred task - ecma262/#sec-enqueuejob
        if (!clock.jobs) {
            clock.jobs = [];
        }
        clock.jobs.push(job);
    }

    //eslint-disable-next-line jsdoc/require-jsdoc
    function runJobs(clock) {
        // runs all microtick-deferred tasks - ecma262/#sec-runjobs
        if (!clock.jobs) {
            return;
        }
        for (let i = 0; i < clock.jobs.length; i++) {
            const job = clock.jobs[i];
            job.func.apply(null, job.args);

            checkIsNearInfiniteLimit(clock, i);
            if (clock.loopLimit && i > clock.loopLimit) {
                throw getInfiniteLoopError(clock, job);
            }
        }
        resetIsNearInfiniteLimit();
        clock.jobs = [];
    }

    /**
     * @param {Clock} clock
     * @param {Timer} timer
     * @returns {number} id of the created timer
     */
    function addTimer(clock, timer) {
        if (timer.func === undefined) {
            throw new Error("Callback must be provided to timer calls");
        }

        if (addTimerReturnsObject) {
            // Node.js environment
            if (typeof timer.func !== "function") {
                throw new TypeError(
                    `[ERR_INVALID_CALLBACK]: Callback must be a function. Received ${
                        timer.func
                    } of type ${typeof timer.func}`,
                );
            }
        }

        if (isNearInfiniteLimit) {
            timer.error = new Error();
        }

        timer.type = timer.immediate ? "Immediate" : "Timeout";

        if (timer.hasOwnProperty("delay")) {
            if (typeof timer.delay !== "number") {
                timer.delay = parseInt(timer.delay, 10);
            }

            if (!isNumberFinite(timer.delay)) {
                timer.delay = 0;
            }
            timer.delay = timer.delay > maxTimeout ? 1 : timer.delay;
            timer.delay = Math.max(0, timer.delay);
        }

        if (timer.hasOwnProperty("interval")) {
            timer.type = "Interval";
            timer.interval = timer.interval > maxTimeout ? 1 : timer.interval;
        }

        if (timer.hasOwnProperty("animation")) {
            timer.type = "AnimationFrame";
            timer.animation = true;
        }

        if (timer.hasOwnProperty("idleCallback")) {
            timer.type = "IdleCallback";
            timer.idleCallback = true;
        }

        if (!clock.timers) {
            clock.timers = {};
        }

        timer.id = uniqueTimerId++;
        timer.createdAt = clock.now;
        timer.callAt =
            clock.now + (parseInt(timer.delay) || (clock.duringTick ? 1 : 0));

        clock.timers[timer.id] = timer;

        if (addTimerReturnsObject) {
            const res = {
                refed: true,
                ref: function () {
                    this.refed = true;
                    return res;
                },
                unref: function () {
                    this.refed = false;
                    return res;
                },
                hasRef: function () {
                    return this.refed;
                },
                refresh: function () {
                    timer.callAt =
                        clock.now +
                        (parseInt(timer.delay) || (clock.duringTick ? 1 : 0));

                    // it _might_ have been removed, but if not the assignment is perfectly fine
                    clock.timers[timer.id] = timer;

                    return res;
                },
                [Symbol.toPrimitive]: function () {
                    return timer.id;
                },
            };
            return res;
        }

        return timer.id;
    }

    /* eslint consistent-return: "off" */
    /**
     * Timer comparitor
     *
     * @param {Timer} a
     * @param {Timer} b
     * @returns {number}
     */
    function compareTimers(a, b) {
        // Sort first by absolute timing
        if (a.callAt < b.callAt) {
            return -1;
        }
        if (a.callAt > b.callAt) {
            return 1;
        }

        // Sort next by immediate, immediate timers take precedence
        if (a.immediate && !b.immediate) {
            return -1;
        }
        if (!a.immediate && b.immediate) {
            return 1;
        }

        // Sort next by creation time, earlier-created timers take precedence
        if (a.createdAt < b.createdAt) {
            return -1;
        }
        if (a.createdAt > b.createdAt) {
            return 1;
        }

        // Sort next by id, lower-id timers take precedence
        if (a.id < b.id) {
            return -1;
        }
        if (a.id > b.id) {
            return 1;
        }

        // As timer ids are unique, no fallback `0` is necessary
    }

    /**
     * @param {Clock} clock
     * @param {number} from
     * @param {number} to
     * @returns {Timer}
     */
    function firstTimerInRange(clock, from, to) {
        const timers = clock.timers;
        let timer = null;
        let id, isInRange;

        for (id in timers) {
            if (timers.hasOwnProperty(id)) {
                isInRange = inRange(from, to, timers[id]);

                if (
                    isInRange &&
                    (!timer || compareTimers(timer, timers[id]) === 1)
                ) {
                    timer = timers[id];
                }
            }
        }

        return timer;
    }

    /**
     * @param {Clock} clock
     * @returns {Timer}
     */
    function firstTimer(clock) {
        const timers = clock.timers;
        let timer = null;
        let id;

        for (id in timers) {
            if (timers.hasOwnProperty(id)) {
                if (!timer || compareTimers(timer, timers[id]) === 1) {
                    timer = timers[id];
                }
            }
        }

        return timer;
    }

    /**
     * @param {Clock} clock
     * @returns {Timer}
     */
    function lastTimer(clock) {
        const timers = clock.timers;
        let timer = null;
        let id;

        for (id in timers) {
            if (timers.hasOwnProperty(id)) {
                if (!timer || compareTimers(timer, timers[id]) === -1) {
                    timer = timers[id];
                }
            }
        }

        return timer;
    }

    /**
     * @param {Clock} clock
     * @param {Timer} timer
     */
    function callTimer(clock, timer) {
        if (typeof timer.interval === "number") {
            clock.timers[timer.id].callAt += timer.interval;
        } else {
            delete clock.timers[timer.id];
        }

        if (typeof timer.func === "function") {
            timer.func.apply(null, timer.args);
        } else {
            /* eslint no-eval: "off" */
            const eval2 = eval;
            (function () {
                eval2(timer.func);
            })();
        }
    }

    /**
     * Gets clear handler name for a given timer type
     *
     * @param {string} ttype
     */
    function getClearHandler(ttype) {
        if (ttype === "IdleCallback" || ttype === "AnimationFrame") {
            return `cancel${ttype}`;
        }
        return `clear${ttype}`;
    }

    /**
     * Gets schedule handler name for a given timer type
     *
     * @param {string} ttype
     */
    function getScheduleHandler(ttype) {
        if (ttype === "IdleCallback" || ttype === "AnimationFrame") {
            return `request${ttype}`;
        }
        return `set${ttype}`;
    }

    /**
     * Creates an anonymous function to warn only once
     */
    function createWarnOnce() {
        let calls = 0;
        return function (msg) {
            // eslint-disable-next-line
            !calls++ && console.warn(msg);
        };
    }
    const warnOnce = createWarnOnce();

    /**
     * @param {Clock} clock
     * @param {number} timerId
     * @param {string} ttype
     */
    function clearTimer(clock, timerId, ttype) {
        if (!timerId) {
            // null appears to be allowed in most browsers, and appears to be
            // relied upon by some libraries, like Bootstrap carousel
            return;
        }

        if (!clock.timers) {
            clock.timers = {};
        }

        // in Node, the ID is stored as the primitive value for `Timeout` objects
        // for `Immediate` objects, no ID exists, so it gets coerced to NaN
        const id = Number(timerId);

        if (Number.isNaN(id) || id < idCounterStart) {
            const handlerName = getClearHandler(ttype);

            if (clock.shouldClearNativeTimers === true) {
                const nativeHandler = clock[`_${handlerName}`];
                return typeof nativeHandler === "function"
                    ? nativeHandler(timerId)
                    : undefined;
            }
            warnOnce(
                `FakeTimers: ${handlerName} was invoked to clear a native timer instead of one created by this library.` +
                    "\nTo automatically clean-up native timers, use `shouldClearNativeTimers`.",
            );
        }

        if (clock.timers.hasOwnProperty(id)) {
            // check that the ID matches a timer of the correct type
            const timer = clock.timers[id];
            if (
                timer.type === ttype ||
                (timer.type === "Timeout" && ttype === "Interval") ||
                (timer.type === "Interval" && ttype === "Timeout")
            ) {
                delete clock.timers[id];
            } else {
                const clear = getClearHandler(ttype);
                const schedule = getScheduleHandler(timer.type);
                throw new Error(
                    `Cannot clear timer: timer created with ${schedule}() but cleared with ${clear}()`,
                );
            }
        }
    }

    /**
     * @param {Clock} clock
     * @param {Config} config
     * @returns {Timer[]}
     */
    function uninstall(clock, config) {
        let method, i, l;
        const installedHrTime = "_hrtime";
        const installedNextTick = "_nextTick";

        for (i = 0, l = clock.methods.length; i < l; i++) {
            method = clock.methods[i];
            if (method === "hrtime" && _global.process) {
                _global.process.hrtime = clock[installedHrTime];
            } else if (method === "nextTick" && _global.process) {
                _global.process.nextTick = clock[installedNextTick];
            } else if (method === "performance") {
                const originalPerfDescriptor = Object.getOwnPropertyDescriptor(
                    clock,
                    `_${method}`,
                );
                if (
                    originalPerfDescriptor &&
                    originalPerfDescriptor.get &&
                    !originalPerfDescriptor.set
                ) {
                    Object.defineProperty(
                        _global,
                        method,
                        originalPerfDescriptor,
                    );
                } else if (originalPerfDescriptor.configurable) {
                    _global[method] = clock[`_${method}`];
                }
            } else {
                if (_global[method] && _global[method].hadOwnProperty) {
                    _global[method] = clock[`_${method}`];
                } else {
                    try {
                        delete _global[method];
                    } catch (ignore) {
                        /* eslint no-empty: "off" */
                    }
                }
            }
            if (clock.timersModuleMethods !== undefined) {
                for (let j = 0; j < clock.timersModuleMethods.length; j++) {
                    const entry = clock.timersModuleMethods[j];
                    timersModule[entry.methodName] = entry.original;
                }
            }
            if (clock.timersPromisesModuleMethods !== undefined) {
                for (
                    let j = 0;
                    j < clock.timersPromisesModuleMethods.length;
                    j++
                ) {
                    const entry = clock.timersPromisesModuleMethods[j];
                    timersPromisesModule[entry.methodName] = entry.original;
                }
            }
        }

        if (config.shouldAdvanceTime === true) {
            _global.clearInterval(clock.attachedInterval);
        }

        // Prevent multiple executions which will completely remove these props
        clock.methods = [];

        for (const [listener, signal] of clock.abortListenerMap.entries()) {
            signal.removeEventListener("abort", listener);
            clock.abortListenerMap.delete(listener);
        }

        // return pending timers, to enable checking what timers remained on uninstall
        if (!clock.timers) {
            return [];
        }
        return Object.keys(clock.timers).map(function mapper(key) {
            return clock.timers[key];
        });
    }

    /**
     * @param {object} target the target containing the method to replace
     * @param {string} method the keyname of the method on the target
     * @param {Clock} clock
     */
    function hijackMethod(target, method, clock) {
        clock[method].hadOwnProperty = Object.prototype.hasOwnProperty.call(
            target,
            method,
        );
        clock[`_${method}`] = target[method];

        if (method === "Date") {
            target[method] = clock[method];
        } else if (method === "Intl") {
            target[method] = clock[method];
        } else if (method === "performance") {
            const originalPerfDescriptor = Object.getOwnPropertyDescriptor(
                target,
                method,
            );
            // JSDOM has a read only performance field so we have to save/copy it differently
            if (
                originalPerfDescriptor &&
                originalPerfDescriptor.get &&
                !originalPerfDescriptor.set
            ) {
                Object.defineProperty(
                    clock,
                    `_${method}`,
                    originalPerfDescriptor,
                );

                const perfDescriptor = Object.getOwnPropertyDescriptor(
                    clock,
                    method,
                );
                Object.defineProperty(target, method, perfDescriptor);
            } else {
                target[method] = clock[method];
            }
        } else {
            target[method] = function () {
                return clock[method].apply(clock, arguments);
            };

            Object.defineProperties(
                target[method],
                Object.getOwnPropertyDescriptors(clock[method]),
            );
        }

        target[method].clock = clock;
    }

    /**
     * @param {Clock} clock
     * @param {number} advanceTimeDelta
     */
    function doIntervalTick(clock, advanceTimeDelta) {
        clock.tick(advanceTimeDelta);
    }

    /**
     * @typedef {object} Timers
     * @property {setTimeout} setTimeout
     * @property {clearTimeout} clearTimeout
     * @property {setInterval} setInterval
     * @property {clearInterval} clearInterval
     * @property {Date} Date
     * @property {Intl} Intl
     * @property {SetImmediate=} setImmediate
     * @property {function(NodeImmediate): void=} clearImmediate
     * @property {function(number[]):number[]=} hrtime
     * @property {NextTick=} nextTick
     * @property {Performance=} performance
     * @property {RequestAnimationFrame=} requestAnimationFrame
     * @property {boolean=} queueMicrotask
     * @property {function(number): void=} cancelAnimationFrame
     * @property {RequestIdleCallback=} requestIdleCallback
     * @property {function(number): void=} cancelIdleCallback
     */

    /** @type {Timers} */
    const timers = {
        setTimeout: _global.setTimeout,
        clearTimeout: _global.clearTimeout,
        setInterval: _global.setInterval,
        clearInterval: _global.clearInterval,
        Date: _global.Date,
    };

    if (isPresent.setImmediate) {
        timers.setImmediate = _global.setImmediate;
    }

    if (isPresent.clearImmediate) {
        timers.clearImmediate = _global.clearImmediate;
    }

    if (isPresent.hrtime) {
        timers.hrtime = _global.process.hrtime;
    }

    if (isPresent.nextTick) {
        timers.nextTick = _global.process.nextTick;
    }

    if (isPresent.performance) {
        timers.performance = _global.performance;
    }

    if (isPresent.requestAnimationFrame) {
        timers.requestAnimationFrame = _global.requestAnimationFrame;
    }

    if (isPresent.queueMicrotask) {
        timers.queueMicrotask = _global.queueMicrotask;
    }

    if (isPresent.cancelAnimationFrame) {
        timers.cancelAnimationFrame = _global.cancelAnimationFrame;
    }

    if (isPresent.requestIdleCallback) {
        timers.requestIdleCallback = _global.requestIdleCallback;
    }

    if (isPresent.cancelIdleCallback) {
        timers.cancelIdleCallback = _global.cancelIdleCallback;
    }

    if (isPresent.Intl) {
        timers.Intl = _global.Intl;
    }

    const originalSetTimeout = _global.setImmediate || _global.setTimeout;

    /**
     * @param {Date|number} [start] the system time - non-integer values are floored
     * @param {number} [loopLimit] maximum number of timers that will be run when calling runAll()
     * @returns {Clock}
     */
    function createClock(start, loopLimit) {
        // eslint-disable-next-line no-param-reassign
        start = Math.floor(getEpoch(start));
        // eslint-disable-next-line no-param-reassign
        loopLimit = loopLimit || 1000;
        let nanos = 0;
        const adjustedSystemTime = [0, 0]; // [millis, nanoremainder]

        const clock = {
            now: start,
            Date: createDate(),
            loopLimit: loopLimit,
        };

        clock.Date.clock = clock;

        //eslint-disable-next-line jsdoc/require-jsdoc
        function getTimeToNextFrame() {
            return 16 - ((clock.now - start) % 16);
        }

        //eslint-disable-next-line jsdoc/require-jsdoc
        function hrtime(prev) {
            const millisSinceStart = clock.now - adjustedSystemTime[0] - start;
            const secsSinceStart = Math.floor(millisSinceStart / 1000);
            const remainderInNanos =
                (millisSinceStart - secsSinceStart * 1e3) * 1e6 +
                nanos -
                adjustedSystemTime[1];

            if (Array.isArray(prev)) {
                if (prev[1] > 1e9) {
                    throw new TypeError(
                        "Number of nanoseconds can't exceed a billion",
                    );
                }

                const oldSecs = prev[0];
                let nanoDiff = remainderInNanos - prev[1];
                let secDiff = secsSinceStart - oldSecs;

                if (nanoDiff < 0) {
                    nanoDiff += 1e9;
                    secDiff -= 1;
                }

                return [secDiff, nanoDiff];
            }
            return [secsSinceStart, remainderInNanos];
        }

        /**
         * A high resolution timestamp in milliseconds.
         *
         * @typedef {number} DOMHighResTimeStamp
         */

        /**
         * performance.now()
         *
         * @returns {DOMHighResTimeStamp}
         */
        function fakePerformanceNow() {
            const hrt = hrtime();
            const millis = hrt[0] * 1000 + hrt[1] / 1e6;
            return millis;
        }

        if (isPresent.hrtimeBigint) {
            hrtime.bigint = function () {
                const parts = hrtime();
                return BigInt(parts[0]) * BigInt(1e9) + BigInt(parts[1]); // eslint-disable-line
            };
        }

        if (isPresent.Intl) {
            clock.Intl = createIntl();
            clock.Intl.clock = clock;
        }

        clock.requestIdleCallback = function requestIdleCallback(
            func,
            timeout,
        ) {
            let timeToNextIdlePeriod = 0;

            if (clock.countTimers() > 0) {
                timeToNextIdlePeriod = 50; // const for now
            }

            const result = addTimer(clock, {
                func: func,
                args: Array.prototype.slice.call(arguments, 2),
                delay:
                    typeof timeout === "undefined"
                        ? timeToNextIdlePeriod
                        : Math.min(timeout, timeToNextIdlePeriod),
                idleCallback: true,
            });

            return Number(result);
        };

        clock.cancelIdleCallback = function cancelIdleCallback(timerId) {
            return clearTimer(clock, timerId, "IdleCallback");
        };

        clock.setTimeout = function setTimeout(func, timeout) {
            return addTimer(clock, {
                func: func,
                args: Array.prototype.slice.call(arguments, 2),
                delay: timeout,
            });
        };
        if (typeof _global.Promise !== "undefined" && utilPromisify) {
            clock.setTimeout[utilPromisify.custom] =
                function promisifiedSetTimeout(timeout, arg) {
                    return new _global.Promise(function setTimeoutExecutor(
                        resolve,
                    ) {
                        addTimer(clock, {
                            func: resolve,
                            args: [arg],
                            delay: timeout,
                        });
                    });
                };
        }

        clock.clearTimeout = function clearTimeout(timerId) {
            return clearTimer(clock, timerId, "Timeout");
        };

        clock.nextTick = function nextTick(func) {
            return enqueueJob(clock, {
                func: func,
                args: Array.prototype.slice.call(arguments, 1),
                error: isNearInfiniteLimit ? new Error() : null,
            });
        };

        clock.queueMicrotask = function queueMicrotask(func) {
            return clock.nextTick(func); // explicitly drop additional arguments
        };

        clock.setInterval = function setInterval(func, timeout) {
            // eslint-disable-next-line no-param-reassign
            timeout = parseInt(timeout, 10);
            return addTimer(clock, {
                func: func,
                args: Array.prototype.slice.call(arguments, 2),
                delay: timeout,
                interval: timeout,
            });
        };

        clock.clearInterval = function clearInterval(timerId) {
            return clearTimer(clock, timerId, "Interval");
        };

        if (isPresent.setImmediate) {
            clock.setImmediate = function setImmediate(func) {
                return addTimer(clock, {
                    func: func,
                    args: Array.prototype.slice.call(arguments, 1),
                    immediate: true,
                });
            };

            if (typeof _global.Promise !== "undefined" && utilPromisify) {
                clock.setImmediate[utilPromisify.custom] =
                    function promisifiedSetImmediate(arg) {
                        return new _global.Promise(
                            function setImmediateExecutor(resolve) {
                                addTimer(clock, {
                                    func: resolve,
                                    args: [arg],
                                    immediate: true,
                                });
                            },
                        );
                    };
            }

            clock.clearImmediate = function clearImmediate(timerId) {
                return clearTimer(clock, timerId, "Immediate");
            };
        }

        clock.countTimers = function countTimers() {
            return (
                Object.keys(clock.timers || {}).length +
                (clock.jobs || []).length
            );
        };

        clock.requestAnimationFrame = function requestAnimationFrame(func) {
            const result = addTimer(clock, {
                func: func,
                delay: getTimeToNextFrame(),
                get args() {
                    return [fakePerformanceNow()];
                },
                animation: true,
            });

            return Number(result);
        };

        clock.cancelAnimationFrame = function cancelAnimationFrame(timerId) {
            return clearTimer(clock, timerId, "AnimationFrame");
        };

        clock.runMicrotasks = function runMicrotasks() {
            runJobs(clock);
        };

        /**
         * @param {number|string} tickValue milliseconds or a string parseable by parseTime
         * @param {boolean} isAsync
         * @param {Function} resolve
         * @param {Function} reject
         * @returns {number|undefined} will return the new `now` value or nothing for async
         */
        function doTick(tickValue, isAsync, resolve, reject) {
            const msFloat =
                typeof tickValue === "number"
                    ? tickValue
                    : parseTime(tickValue);
            const ms = Math.floor(msFloat);
            const remainder = nanoRemainder(msFloat);
            let nanosTotal = nanos + remainder;
            let tickTo = clock.now + ms;

            if (msFloat < 0) {
                throw new TypeError("Negative ticks are not supported");
            }

            // adjust for positive overflow
            if (nanosTotal >= 1e6) {
                tickTo += 1;
                nanosTotal -= 1e6;
            }

            nanos = nanosTotal;
            let tickFrom = clock.now;
            let previous = clock.now;
            // ESLint fails to detect this correctly
            /* eslint-disable prefer-const */
            let timer,
                firstException,
                oldNow,
                nextPromiseTick,
                compensationCheck,
                postTimerCall;
            /* eslint-enable prefer-const */

            clock.duringTick = true;

            // perform microtasks
            oldNow = clock.now;
            runJobs(clock);
            if (oldNow !== clock.now) {
                // compensate for any setSystemTime() call during microtask callback
                tickFrom += clock.now - oldNow;
                tickTo += clock.now - oldNow;
            }

            //eslint-disable-next-line jsdoc/require-jsdoc
            function doTickInner() {
                // perform each timer in the requested range
                timer = firstTimerInRange(clock, tickFrom, tickTo);
                // eslint-disable-next-line no-unmodified-loop-condition
                while (timer && tickFrom <= tickTo) {
                    if (clock.timers[timer.id]) {
                        tickFrom = timer.callAt;
                        clock.now = timer.callAt;
                        oldNow = clock.now;
                        try {
                            runJobs(clock);
                            callTimer(clock, timer);
                        } catch (e) {
                            firstException = firstException || e;
                        }

                        if (isAsync) {
                            // finish up after native setImmediate callback to allow
                            // all native es6 promises to process their callbacks after
                            // each timer fires.
                            originalSetTimeout(nextPromiseTick);
                            return;
                        }

                        compensationCheck();
                    }

                    postTimerCall();
                }

                // perform process.nextTick()s again
                oldNow = clock.now;
                runJobs(clock);
                if (oldNow !== clock.now) {
                    // compensate for any setSystemTime() call during process.nextTick() callback
                    tickFrom += clock.now - oldNow;
                    tickTo += clock.now - oldNow;
                }
                clock.duringTick = false;

                // corner case: during runJobs new timers were scheduled which could be in the range [clock.now, tickTo]
                timer = firstTimerInRange(clock, tickFrom, tickTo);
                if (timer) {
                    try {
                        clock.tick(tickTo - clock.now); // do it all again - for the remainder of the requested range
                    } catch (e) {
                        firstException = firstException || e;
                    }
                } else {
                    // no timers remaining in the requested range: move the clock all the way to the end
                    clock.now = tickTo;

                    // update nanos
                    nanos = nanosTotal;
                }
                if (firstException) {
                    throw firstException;
                }

                if (isAsync) {
                    resolve(clock.now);
                } else {
                    return clock.now;
                }
            }

            nextPromiseTick =
                isAsync &&
                function () {
                    try {
                        compensationCheck();
                        postTimerCall();
                        doTickInner();
                    } catch (e) {
                        reject(e);
                    }
                };

            compensationCheck = function () {
                // compensate for any setSystemTime() call during timer callback
                if (oldNow !== clock.now) {
                    tickFrom += clock.now - oldNow;
                    tickTo += clock.now - oldNow;
                    previous += clock.now - oldNow;
                }
            };

            postTimerCall = function () {
                timer = firstTimerInRange(clock, previous, tickTo);
                previous = tickFrom;
            };

            return doTickInner();
        }

        /**
         * @param {string|number} tickValue number of milliseconds or a human-readable value like "01:11:15"
         * @returns {number} will return the new `now` value
         */
        clock.tick = function tick(tickValue) {
            return doTick(tickValue, false);
        };

        if (typeof _global.Promise !== "undefined") {
            /**
             * @param {string|number} tickValue number of milliseconds or a human-readable value like "01:11:15"
             * @returns {Promise}
             */
            clock.tickAsync = function tickAsync(tickValue) {
                return new _global.Promise(function (resolve, reject) {
                    originalSetTimeout(function () {
                        try {
                            doTick(tickValue, true, resolve, reject);
                        } catch (e) {
                            reject(e);
                        }
                    });
                });
            };
        }

        clock.next = function next() {
            runJobs(clock);
            const timer = firstTimer(clock);
            if (!timer) {
                return clock.now;
            }

            clock.duringTick = true;
            try {
                clock.now = timer.callAt;
                callTimer(clock, timer);
                runJobs(clock);
                return clock.now;
            } finally {
                clock.duringTick = false;
            }
        };

        if (typeof _global.Promise !== "undefined") {
            clock.nextAsync = function nextAsync() {
                return new _global.Promise(function (resolve, reject) {
                    originalSetTimeout(function () {
                        try {
                            const timer = firstTimer(clock);
                            if (!timer) {
                                resolve(clock.now);
                                return;
                            }

                            let err;
                            clock.duringTick = true;
                            clock.now = timer.callAt;
                            try {
                                callTimer(clock, timer);
                            } catch (e) {
                                err = e;
                            }
                            clock.duringTick = false;

                            originalSetTimeout(function () {
                                if (err) {
                                    reject(err);
                                } else {
                                    resolve(clock.now);
                                }
                            });
                        } catch (e) {
                            reject(e);
                        }
                    });
                });
            };
        }

        clock.runAll = function runAll() {
            let numTimers, i;
            runJobs(clock);
            for (i = 0; i < clock.loopLimit; i++) {
                if (!clock.timers) {
                    resetIsNearInfiniteLimit();
                    return clock.now;
                }

                numTimers = Object.keys(clock.timers).length;
                if (numTimers === 0) {
                    resetIsNearInfiniteLimit();
                    return clock.now;
                }

                clock.next();
                checkIsNearInfiniteLimit(clock, i);
            }

            const excessJob = firstTimer(clock);
            throw getInfiniteLoopError(clock, excessJob);
        };

        clock.runToFrame = function runToFrame() {
            return clock.tick(getTimeToNextFrame());
        };

        if (typeof _global.Promise !== "undefined") {
            clock.runAllAsync = function runAllAsync() {
                return new _global.Promise(function (resolve, reject) {
                    let i = 0;
                    /**
                     *
                     */
                    function doRun() {
                        originalSetTimeout(function () {
                            try {
                                runJobs(clock);

                                let numTimers;
                                if (i < clock.loopLimit) {
                                    if (!clock.timers) {
                                        resetIsNearInfiniteLimit();
                                        resolve(clock.now);
                                        return;
                                    }

                                    numTimers = Object.keys(
                                        clock.timers,
                                    ).length;
                                    if (numTimers === 0) {
                                        resetIsNearInfiniteLimit();
                                        resolve(clock.now);
                                        return;
                                    }

                                    clock.next();

                                    i++;

                                    doRun();
                                    checkIsNearInfiniteLimit(clock, i);
                                    return;
                                }

                                const excessJob = firstTimer(clock);
                                reject(getInfiniteLoopError(clock, excessJob));
                            } catch (e) {
                                reject(e);
                            }
                        });
                    }
                    doRun();
                });
            };
        }

        clock.runToLast = function runToLast() {
            const timer = lastTimer(clock);
            if (!timer) {
                runJobs(clock);
                return clock.now;
            }

            return clock.tick(timer.callAt - clock.now);
        };

        if (typeof _global.Promise !== "undefined") {
            clock.runToLastAsync = function runToLastAsync() {
                return new _global.Promise(function (resolve, reject) {
                    originalSetTimeout(function () {
                        try {
                            const timer = lastTimer(clock);
                            if (!timer) {
                                runJobs(clock);
                                resolve(clock.now);
                            }

                            resolve(clock.tickAsync(timer.callAt - clock.now));
                        } catch (e) {
                            reject(e);
                        }
                    });
                });
            };
        }

        clock.reset = function reset() {
            nanos = 0;
            clock.timers = {};
            clock.jobs = [];
            clock.now = start;
        };

        clock.setSystemTime = function setSystemTime(systemTime) {
            // determine time difference
            const newNow = getEpoch(systemTime);
            const difference = newNow - clock.now;
            let id, timer;

            adjustedSystemTime[0] = adjustedSystemTime[0] + difference;
            adjustedSystemTime[1] = adjustedSystemTime[1] + nanos;
            // update 'system clock'
            clock.now = newNow;
            nanos = 0;

            // update timers and intervals to keep them stable
            for (id in clock.timers) {
                if (clock.timers.hasOwnProperty(id)) {
                    timer = clock.timers[id];
                    timer.createdAt += difference;
                    timer.callAt += difference;
                }
            }
        };

        /**
         * @param {string|number} tickValue number of milliseconds or a human-readable value like "01:11:15"
         * @returns {number} will return the new `now` value
         */
        clock.jump = function jump(tickValue) {
            const msFloat =
                typeof tickValue === "number"
                    ? tickValue
                    : parseTime(tickValue);
            const ms = Math.floor(msFloat);

            for (const timer of Object.values(clock.timers)) {
                if (clock.now + ms > timer.callAt) {
                    timer.callAt = clock.now + ms;
                }
            }
            clock.tick(ms);
        };

        if (isPresent.performance) {
            clock.performance = Object.create(null);
            clock.performance.now = fakePerformanceNow;
        }

        if (isPresent.hrtime) {
            clock.hrtime = hrtime;
        }

        return clock;
    }

    /* eslint-disable complexity */

    /**
     * @param {Config=} [config] Optional config
     * @returns {Clock}
     */
    function install(config) {
        if (
            arguments.length > 1 ||
            config instanceof Date ||
            Array.isArray(config) ||
            typeof config === "number"
        ) {
            throw new TypeError(
                `FakeTimers.install called with ${String(
                    config,
                )} install requires an object parameter`,
            );
        }

        if (_global.Date.isFake === true) {
            // Timers are already faked; this is a problem.
            // Make the user reset timers before continuing.
            throw new TypeError(
                "Can't install fake timers twice on the same global object.",
            );
        }

        // eslint-disable-next-line no-param-reassign
        config = typeof config !== "undefined" ? config : {};
        config.shouldAdvanceTime = config.shouldAdvanceTime || false;
        config.advanceTimeDelta = config.advanceTimeDelta || 20;
        config.shouldClearNativeTimers =
            config.shouldClearNativeTimers || false;

        if (config.target) {
            throw new TypeError(
                "config.target is no longer supported. Use `withGlobal(target)` instead.",
            );
        }

        /**
         * @param {string} timer/object the name of the thing that is not present
         * @param timer
         */
        function handleMissingTimer(timer) {
            if (config.ignoreMissingTimers) {
                return;
            }

            throw new ReferenceError(
                `non-existent timers and/or objects cannot be faked: '${timer}'`,
            );
        }

        let i, l;
        const clock = createClock(config.now, config.loopLimit);
        clock.shouldClearNativeTimers = config.shouldClearNativeTimers;

        clock.uninstall = function () {
            return uninstall(clock, config);
        };

        clock.abortListenerMap = new Map();

        clock.methods = config.toFake || [];

        if (clock.methods.length === 0) {
            clock.methods = Object.keys(timers);
        }

        if (config.shouldAdvanceTime === true) {
            const intervalTick = doIntervalTick.bind(
                null,
                clock,
                config.advanceTimeDelta,
            );
            const intervalId = _global.setInterval(
                intervalTick,
                config.advanceTimeDelta,
            );
            clock.attachedInterval = intervalId;
        }

        if (clock.methods.includes("performance")) {
            const proto = (() => {
                if (hasPerformanceConstructorPrototype) {
                    return _global.performance.constructor.prototype;
                }
                if (hasPerformancePrototype) {
                    return _global.Performance.prototype;
                }
            })();
            if (proto) {
                Object.getOwnPropertyNames(proto).forEach(function (name) {
                    if (name !== "now") {
                        clock.performance[name] =
                            name.indexOf("getEntries") === 0
                                ? NOOP_ARRAY
                                : NOOP;
                    }
                });
                // ensure `mark` returns a value that is valid
                clock.performance.mark = (name) =>
                    new FakePerformanceEntry(name, "mark", 0, 0);
                clock.performance.measure = (name) =>
                    new FakePerformanceEntry(name, "measure", 0, 100);
            } else if ((config.toFake || []).includes("performance")) {
                return handleMissingTimer("performance");
            }
        }
        if (_global === globalObject && timersModule) {
            clock.timersModuleMethods = [];
        }
        if (_global === globalObject && timersPromisesModule) {
            clock.timersPromisesModuleMethods = [];
        }
        for (i = 0, l = clock.methods.length; i < l; i++) {
            const nameOfMethodToReplace = clock.methods[i];

            if (!isPresent[nameOfMethodToReplace]) {
                handleMissingTimer(nameOfMethodToReplace);
                // eslint-disable-next-line
                continue;
            }

            if (nameOfMethodToReplace === "hrtime") {
                if (
                    _global.process &&
                    typeof _global.process.hrtime === "function"
                ) {
                    hijackMethod(_global.process, nameOfMethodToReplace, clock);
                }
            } else if (nameOfMethodToReplace === "nextTick") {
                if (
                    _global.process &&
                    typeof _global.process.nextTick === "function"
                ) {
                    hijackMethod(_global.process, nameOfMethodToReplace, clock);
                }
            } else {
                hijackMethod(_global, nameOfMethodToReplace, clock);
            }
            if (
                clock.timersModuleMethods !== undefined &&
                timersModule[nameOfMethodToReplace]
            ) {
                const original = timersModule[nameOfMethodToReplace];
                clock.timersModuleMethods.push({
                    methodName: nameOfMethodToReplace,
                    original: original,
                });
                timersModule[nameOfMethodToReplace] =
                    _global[nameOfMethodToReplace];
            }
            if (clock.timersPromisesModuleMethods !== undefined) {
                if (nameOfMethodToReplace === "setTimeout") {
                    clock.timersPromisesModuleMethods.push({
                        methodName: "setTimeout",
                        original: timersPromisesModule.setTimeout,
                    });

                    timersPromisesModule.setTimeout = (
                        delay,
                        value,
                        options = {},
                    ) =>
                        new Promise((resolve, reject) => {
                            const abort = () => {
                                options.signal.removeEventListener(
                                    "abort",
                                    abort,
                                );
                                clock.abortListenerMap.delete(abort);

                                // This is safe, there is no code path that leads to this function
                                // being invoked before handle has been assigned.
                                // eslint-disable-next-line no-use-before-define
                                clock.clearTimeout(handle);
                                reject(options.signal.reason);
                            };

                            const handle = clock.setTimeout(() => {
                                if (options.signal) {
                                    options.signal.removeEventListener(
                                        "abort",
                                        abort,
                                    );
                                    clock.abortListenerMap.delete(abort);
                                }

                                resolve(value);
                            }, delay);

                            if (options.signal) {
                                if (options.signal.aborted) {
                                    abort();
                                } else {
                                    options.signal.addEventListener(
                                        "abort",
                                        abort,
                                    );
                                    clock.abortListenerMap.set(
                                        abort,
                                        options.signal,
                                    );
                                }
                            }
                        });
                } else if (nameOfMethodToReplace === "setImmediate") {
                    clock.timersPromisesModuleMethods.push({
                        methodName: "setImmediate",
                        original: timersPromisesModule.setImmediate,
                    });

                    timersPromisesModule.setImmediate = (value, options = {}) =>
                        new Promise((resolve, reject) => {
                            const abort = () => {
                                options.signal.removeEventListener(
                                    "abort",
                                    abort,
                                );
                                clock.abortListenerMap.delete(abort);

                                // This is safe, there is no code path that leads to this function
                                // being invoked before handle has been assigned.
                                // eslint-disable-next-line no-use-before-define
                                clock.clearImmediate(handle);
                                reject(options.signal.reason);
                            };

                            const handle = clock.setImmediate(() => {
                                if (options.signal) {
                                    options.signal.removeEventListener(
                                        "abort",
                                        abort,
                                    );
                                    clock.abortListenerMap.delete(abort);
                                }

                                resolve(value);
                            });

                            if (options.signal) {
                                if (options.signal.aborted) {
                                    abort();
                                } else {
                                    options.signal.addEventListener(
                                        "abort",
                                        abort,
                                    );
                                    clock.abortListenerMap.set(
                                        abort,
                                        options.signal,
                                    );
                                }
                            }
                        });
                } else if (nameOfMethodToReplace === "setInterval") {
                    clock.timersPromisesModuleMethods.push({
                        methodName: "setInterval",
                        original: timersPromisesModule.setInterval,
                    });

                    timersPromisesModule.setInterval = (
                        delay,
                        value,
                        options = {},
                    ) => ({
                        [Symbol.asyncIterator]: () => {
                            const createResolvable = () => {
                                let resolve, reject;
                                const promise = new Promise((res, rej) => {
                                    resolve = res;
                                    reject = rej;
                                });
                                promise.resolve = resolve;
                                promise.reject = reject;
                                return promise;
                            };

                            let done = false;
                            let hasThrown = false;
                            let returnCall;
                            let nextAvailable = 0;
                            const nextQueue = [];

                            const handle = clock.setInterval(() => {
                                if (nextQueue.length > 0) {
                                    nextQueue.shift().resolve();
                                } else {
                                    nextAvailable++;
                                }
                            }, delay);

                            const abort = () => {
                                options.signal.removeEventListener(
                                    "abort",
                                    abort,
                                );
                                clock.abortListenerMap.delete(abort);

                                clock.clearInterval(handle);
                                done = true;
                                for (const resolvable of nextQueue) {
                                    resolvable.resolve();
                                }
                            };

                            if (options.signal) {
                                if (options.signal.aborted) {
                                    done = true;
                                } else {
                                    options.signal.addEventListener(
                                        "abort",
                                        abort,
                                    );
                                    clock.abortListenerMap.set(
                                        abort,
                                        options.signal,
                                    );
                                }
                            }

                            return {
                                next: async () => {
                                    if (options.signal?.aborted && !hasThrown) {
                                        hasThrown = true;
                                        throw options.signal.reason;
                                    }

                                    if (done) {
                                        return { done: true, value: undefined };
                                    }

                                    if (nextAvailable > 0) {
                                        nextAvailable--;
                                        return { done: false, value: value };
                                    }

                                    const resolvable = createResolvable();
                                    nextQueue.push(resolvable);

                                    await resolvable;

                                    if (returnCall && nextQueue.length === 0) {
                                        returnCall.resolve();
                                    }

                                    if (options.signal?.aborted && !hasThrown) {
                                        hasThrown = true;
                                        throw options.signal.reason;
                                    }

                                    if (done) {
                                        return { done: true, value: undefined };
                                    }

                                    return { done: false, value: value };
                                },
                                return: async () => {
                                    if (done) {
                                        return { done: true, value: undefined };
                                    }

                                    if (nextQueue.length > 0) {
                                        returnCall = createResolvable();
                                        await returnCall;
                                    }

                                    clock.clearInterval(handle);
                                    done = true;

                                    if (options.signal) {
                                        options.signal.removeEventListener(
                                            "abort",
                                            abort,
                                        );
                                        clock.abortListenerMap.delete(abort);
                                    }

                                    return { done: true, value: undefined };
                                },
                            };
                        },
                    });
                }
            }
        }

        return clock;
    }

    /* eslint-enable complexity */

    return {
        timers: timers,
        createClock: createClock,
        install: install,
        withGlobal: withGlobal,
    };
}

/**
 * @typedef {object} FakeTimers
 * @property {Timers} timers
 * @property {createClock} createClock
 * @property {Function} install
 * @property {withGlobal} withGlobal
 */

/* eslint-enable complexity */

/** @type {FakeTimers} */
const defaultImplementation = withGlobal(globalObject);

exports.timers = defaultImplementation.timers;
exports.createClock = defaultImplementation.createClock;
exports.install = defaultImplementation.install;
exports.withGlobal = withGlobal;

},{"@sinonjs/commons":46,"timers":undefined,"timers/promises":undefined,"util":90}],60:[function(require,module,exports){
"use strict";

var ARRAY_TYPES = [
    Array,
    Int8Array,
    Uint8Array,
    Uint8ClampedArray,
    Int16Array,
    Uint16Array,
    Int32Array,
    Uint32Array,
    Float32Array,
    Float64Array,
];

module.exports = ARRAY_TYPES;

},{}],61:[function(require,module,exports){
"use strict";

var arrayProto = require("@sinonjs/commons").prototypes.array;
var deepEqual = require("./deep-equal").use(createMatcher); // eslint-disable-line no-use-before-define
var every = require("@sinonjs/commons").every;
var functionName = require("@sinonjs/commons").functionName;
var get = require("lodash.get");
var iterableToString = require("./iterable-to-string");
var objectProto = require("@sinonjs/commons").prototypes.object;
var typeOf = require("@sinonjs/commons").typeOf;
var valueToString = require("@sinonjs/commons").valueToString;

var assertMatcher = require("./create-matcher/assert-matcher");
var assertMethodExists = require("./create-matcher/assert-method-exists");
var assertType = require("./create-matcher/assert-type");
var isIterable = require("./create-matcher/is-iterable");
var isMatcher = require("./create-matcher/is-matcher");

var matcherPrototype = require("./create-matcher/matcher-prototype");

var arrayIndexOf = arrayProto.indexOf;
var some = arrayProto.some;

var hasOwnProperty = objectProto.hasOwnProperty;
var objectToString = objectProto.toString;

var TYPE_MAP = require("./create-matcher/type-map")(createMatcher); // eslint-disable-line no-use-before-define

/**
 * Creates a matcher object for the passed expectation
 *
 * @alias module:samsam.createMatcher
 * @param {*} expectation An expecttation
 * @param {string} message A message for the expectation
 * @returns {object} A matcher object
 */
function createMatcher(expectation, message) {
    var m = Object.create(matcherPrototype);
    var type = typeOf(expectation);

    if (message !== undefined && typeof message !== "string") {
        throw new TypeError("Message should be a string");
    }

    if (arguments.length > 2) {
        throw new TypeError(
            `Expected 1 or 2 arguments, received ${arguments.length}`,
        );
    }

    if (type in TYPE_MAP) {
        TYPE_MAP[type](m, expectation, message);
    } else {
        m.test = function (actual) {
            return deepEqual(actual, expectation);
        };
    }

    if (!m.message) {
        m.message = `match(${valueToString(expectation)})`;
    }

    // ensure that nothing mutates the exported message value, ref https://github.com/sinonjs/sinon/issues/2502
    Object.defineProperty(m, "message", {
        configurable: false,
        writable: false,
        value: m.message,
    });

    return m;
}

createMatcher.isMatcher = isMatcher;

createMatcher.any = createMatcher(function () {
    return true;
}, "any");

createMatcher.defined = createMatcher(function (actual) {
    return actual !== null && actual !== undefined;
}, "defined");

createMatcher.truthy = createMatcher(function (actual) {
    return Boolean(actual);
}, "truthy");

createMatcher.falsy = createMatcher(function (actual) {
    return !actual;
}, "falsy");

createMatcher.same = function (expectation) {
    return createMatcher(
        function (actual) {
            return expectation === actual;
        },
        `same(${valueToString(expectation)})`,
    );
};

createMatcher.in = function (arrayOfExpectations) {
    if (typeOf(arrayOfExpectations) !== "array") {
        throw new TypeError("array expected");
    }

    return createMatcher(
        function (actual) {
            return some(arrayOfExpectations, function (expectation) {
                return expectation === actual;
            });
        },
        `in(${valueToString(arrayOfExpectations)})`,
    );
};

createMatcher.typeOf = function (type) {
    assertType(type, "string", "type");
    return createMatcher(function (actual) {
        return typeOf(actual) === type;
    }, `typeOf("${type}")`);
};

createMatcher.instanceOf = function (type) {
    /* istanbul ignore if */
    if (
        typeof Symbol === "undefined" ||
        typeof Symbol.hasInstance === "undefined"
    ) {
        assertType(type, "function", "type");
    } else {
        assertMethodExists(
            type,
            Symbol.hasInstance,
            "type",
            "[Symbol.hasInstance]",
        );
    }
    return createMatcher(
        function (actual) {
            return actual instanceof type;
        },
        `instanceOf(${functionName(type) || objectToString(type)})`,
    );
};

/**
 * Creates a property matcher
 *
 * @private
 * @param {Function} propertyTest A function to test the property against a value
 * @param {string} messagePrefix A prefix to use for messages generated by the matcher
 * @returns {object} A matcher
 */
function createPropertyMatcher(propertyTest, messagePrefix) {
    return function (property, value) {
        assertType(property, "string", "property");
        var onlyProperty = arguments.length === 1;
        var message = `${messagePrefix}("${property}"`;
        if (!onlyProperty) {
            message += `, ${valueToString(value)}`;
        }
        message += ")";
        return createMatcher(function (actual) {
            if (
                actual === undefined ||
                actual === null ||
                !propertyTest(actual, property)
            ) {
                return false;
            }
            return onlyProperty || deepEqual(actual[property], value);
        }, message);
    };
}

createMatcher.has = createPropertyMatcher(function (actual, property) {
    if (typeof actual === "object") {
        return property in actual;
    }
    return actual[property] !== undefined;
}, "has");

createMatcher.hasOwn = createPropertyMatcher(function (actual, property) {
    return hasOwnProperty(actual, property);
}, "hasOwn");

createMatcher.hasNested = function (property, value) {
    assertType(property, "string", "property");
    var onlyProperty = arguments.length === 1;
    var message = `hasNested("${property}"`;
    if (!onlyProperty) {
        message += `, ${valueToString(value)}`;
    }
    message += ")";
    return createMatcher(function (actual) {
        if (
            actual === undefined ||
            actual === null ||
            get(actual, property) === undefined
        ) {
            return false;
        }
        return onlyProperty || deepEqual(get(actual, property), value);
    }, message);
};

var jsonParseResultTypes = {
    null: true,
    boolean: true,
    number: true,
    string: true,
    object: true,
    array: true,
};
createMatcher.json = function (value) {
    if (!jsonParseResultTypes[typeOf(value)]) {
        throw new TypeError("Value cannot be the result of JSON.parse");
    }
    var message = `json(${JSON.stringify(value, null, "  ")})`;
    return createMatcher(function (actual) {
        var parsed;
        try {
            parsed = JSON.parse(actual);
        } catch (e) {
            return false;
        }
        return deepEqual(parsed, value);
    }, message);
};

createMatcher.every = function (predicate) {
    assertMatcher(predicate);

    return createMatcher(function (actual) {
        if (typeOf(actual) === "object") {
            return every(Object.keys(actual), function (key) {
                return predicate.test(actual[key]);
            });
        }

        return (
            isIterable(actual) &&
            every(actual, function (element) {
                return predicate.test(element);
            })
        );
    }, `every(${predicate.message})`);
};

createMatcher.some = function (predicate) {
    assertMatcher(predicate);

    return createMatcher(function (actual) {
        if (typeOf(actual) === "object") {
            return !every(Object.keys(actual), function (key) {
                return !predicate.test(actual[key]);
            });
        }

        return (
            isIterable(actual) &&
            !every(actual, function (element) {
                return !predicate.test(element);
            })
        );
    }, `some(${predicate.message})`);
};

createMatcher.array = createMatcher.typeOf("array");

createMatcher.array.deepEquals = function (expectation) {
    return createMatcher(
        function (actual) {
            // Comparing lengths is the fastest way to spot a difference before iterating through every item
            var sameLength = actual.length === expectation.length;
            return (
                typeOf(actual) === "array" &&
                sameLength &&
                every(actual, function (element, index) {
                    var expected = expectation[index];
                    return typeOf(expected) === "array" &&
                        typeOf(element) === "array"
                        ? createMatcher.array.deepEquals(expected).test(element)
                        : deepEqual(expected, element);
                })
            );
        },
        `deepEquals([${iterableToString(expectation)}])`,
    );
};

createMatcher.array.startsWith = function (expectation) {
    return createMatcher(
        function (actual) {
            return (
                typeOf(actual) === "array" &&
                every(expectation, function (expectedElement, index) {
                    return actual[index] === expectedElement;
                })
            );
        },
        `startsWith([${iterableToString(expectation)}])`,
    );
};

createMatcher.array.endsWith = function (expectation) {
    return createMatcher(
        function (actual) {
            // This indicates the index in which we should start matching
            var offset = actual.length - expectation.length;

            return (
                typeOf(actual) === "array" &&
                every(expectation, function (expectedElement, index) {
                    return actual[offset + index] === expectedElement;
                })
            );
        },
        `endsWith([${iterableToString(expectation)}])`,
    );
};

createMatcher.array.contains = function (expectation) {
    return createMatcher(
        function (actual) {
            return (
                typeOf(actual) === "array" &&
                every(expectation, function (expectedElement) {
                    return arrayIndexOf(actual, expectedElement) !== -1;
                })
            );
        },
        `contains([${iterableToString(expectation)}])`,
    );
};

createMatcher.map = createMatcher.typeOf("map");

createMatcher.map.deepEquals = function mapDeepEquals(expectation) {
    return createMatcher(
        function (actual) {
            // Comparing lengths is the fastest way to spot a difference before iterating through every item
            var sameLength = actual.size === expectation.size;
            return (
                typeOf(actual) === "map" &&
                sameLength &&
                every(actual, function (element, key) {
                    return (
                        expectation.has(key) && expectation.get(key) === element
                    );
                })
            );
        },
        `deepEquals(Map[${iterableToString(expectation)}])`,
    );
};

createMatcher.map.contains = function mapContains(expectation) {
    return createMatcher(
        function (actual) {
            return (
                typeOf(actual) === "map" &&
                every(expectation, function (element, key) {
                    return actual.has(key) && actual.get(key) === element;
                })
            );
        },
        `contains(Map[${iterableToString(expectation)}])`,
    );
};

createMatcher.set = createMatcher.typeOf("set");

createMatcher.set.deepEquals = function setDeepEquals(expectation) {
    return createMatcher(
        function (actual) {
            // Comparing lengths is the fastest way to spot a difference before iterating through every item
            var sameLength = actual.size === expectation.size;
            return (
                typeOf(actual) === "set" &&
                sameLength &&
                every(actual, function (element) {
                    return expectation.has(element);
                })
            );
        },
        `deepEquals(Set[${iterableToString(expectation)}])`,
    );
};

createMatcher.set.contains = function setContains(expectation) {
    return createMatcher(
        function (actual) {
            return (
                typeOf(actual) === "set" &&
                every(expectation, function (element) {
                    return actual.has(element);
                })
            );
        },
        `contains(Set[${iterableToString(expectation)}])`,
    );
};

createMatcher.bool = createMatcher.typeOf("boolean");
createMatcher.number = createMatcher.typeOf("number");
createMatcher.string = createMatcher.typeOf("string");
createMatcher.object = createMatcher.typeOf("object");
createMatcher.func = createMatcher.typeOf("function");
createMatcher.regexp = createMatcher.typeOf("regexp");
createMatcher.date = createMatcher.typeOf("date");
createMatcher.symbol = createMatcher.typeOf("symbol");

module.exports = createMatcher;

},{"./create-matcher/assert-matcher":62,"./create-matcher/assert-method-exists":63,"./create-matcher/assert-type":64,"./create-matcher/is-iterable":65,"./create-matcher/is-matcher":66,"./create-matcher/matcher-prototype":68,"./create-matcher/type-map":69,"./deep-equal":70,"./iterable-to-string":84,"@sinonjs/commons":46,"lodash.get":92}],62:[function(require,module,exports){
"use strict";

var isMatcher = require("./is-matcher");

/**
 * Throws a TypeError when `value` is not a matcher
 *
 * @private
 * @param {*} value The value to examine
 */
function assertMatcher(value) {
    if (!isMatcher(value)) {
        throw new TypeError("Matcher expected");
    }
}

module.exports = assertMatcher;

},{"./is-matcher":66}],63:[function(require,module,exports){
"use strict";

/**
 * Throws a TypeError when expected method doesn't exist
 *
 * @private
 * @param {*} value A value to examine
 * @param {string} method The name of the method to look for
 * @param {name} name A name to use for the error message
 * @param {string} methodPath The name of the method to use for error messages
 * @throws {TypeError} When the method doesn't exist
 */
function assertMethodExists(value, method, name, methodPath) {
    if (value[method] === null || value[method] === undefined) {
        throw new TypeError(`Expected ${name} to have method ${methodPath}`);
    }
}

module.exports = assertMethodExists;

},{}],64:[function(require,module,exports){
"use strict";

var typeOf = require("@sinonjs/commons").typeOf;

/**
 * Ensures that value is of type
 *
 * @private
 * @param {*} value A value to examine
 * @param {string} type A basic JavaScript type to compare to, e.g. "object", "string"
 * @param {string} name A string to use for the error message
 * @throws {TypeError} If value is not of the expected type
 * @returns {undefined}
 */
function assertType(value, type, name) {
    var actual = typeOf(value);
    if (actual !== type) {
        throw new TypeError(
            `Expected type of ${name} to be ${type}, but was ${actual}`,
        );
    }
}

module.exports = assertType;

},{"@sinonjs/commons":46}],65:[function(require,module,exports){
"use strict";

var typeOf = require("@sinonjs/commons").typeOf;

/**
 * Returns `true` for iterables
 *
 * @private
 * @param {*} value A value to examine
 * @returns {boolean} Returns `true` when `value` looks like an iterable
 */
function isIterable(value) {
    return Boolean(value) && typeOf(value.forEach) === "function";
}

module.exports = isIterable;

},{"@sinonjs/commons":46}],66:[function(require,module,exports){
"use strict";

var isPrototypeOf = require("@sinonjs/commons").prototypes.object.isPrototypeOf;

var matcherPrototype = require("./matcher-prototype");

/**
 * Returns `true` when `object` is a matcher
 *
 * @private
 * @param {*} object A value to examine
 * @returns {boolean} Returns `true` when `object` is a matcher
 */
function isMatcher(object) {
    return isPrototypeOf(matcherPrototype, object);
}

module.exports = isMatcher;

},{"./matcher-prototype":68,"@sinonjs/commons":46}],67:[function(require,module,exports){
"use strict";

var every = require("@sinonjs/commons").prototypes.array.every;
var concat = require("@sinonjs/commons").prototypes.array.concat;
var typeOf = require("@sinonjs/commons").typeOf;

var deepEqualFactory = require("../deep-equal").use;

var identical = require("../identical");
var isMatcher = require("./is-matcher");

var keys = Object.keys;
var getOwnPropertySymbols = Object.getOwnPropertySymbols;

/**
 * Matches `actual` with `expectation`
 *
 * @private
 * @param {*} actual A value to examine
 * @param {object} expectation An object with properties to match on
 * @param {object} matcher A matcher to use for comparison
 * @returns {boolean} Returns true when `actual` matches all properties in `expectation`
 */
function matchObject(actual, expectation, matcher) {
    var deepEqual = deepEqualFactory(matcher);
    if (actual === null || actual === undefined) {
        return false;
    }

    var expectedKeys = keys(expectation);
    /* istanbul ignore else: cannot collect coverage for engine that doesn't support Symbol */
    if (typeOf(getOwnPropertySymbols) === "function") {
        expectedKeys = concat(expectedKeys, getOwnPropertySymbols(expectation));
    }

    return every(expectedKeys, function (key) {
        var exp = expectation[key];
        var act = actual[key];

        if (isMatcher(exp)) {
            if (!exp.test(act)) {
                return false;
            }
        } else if (typeOf(exp) === "object") {
            if (identical(exp, act)) {
                return true;
            }
            if (!matchObject(act, exp, matcher)) {
                return false;
            }
        } else if (!deepEqual(act, exp)) {
            return false;
        }

        return true;
    });
}

module.exports = matchObject;

},{"../deep-equal":70,"../identical":72,"./is-matcher":66,"@sinonjs/commons":46}],68:[function(require,module,exports){
"use strict";

var matcherPrototype = {
    toString: function () {
        return this.message;
    },
};

matcherPrototype.or = function (valueOrMatcher) {
    var createMatcher = require("../create-matcher");
    var isMatcher = createMatcher.isMatcher;

    if (!arguments.length) {
        throw new TypeError("Matcher expected");
    }

    var m2 = isMatcher(valueOrMatcher)
        ? valueOrMatcher
        : createMatcher(valueOrMatcher);
    var m1 = this;
    var or = Object.create(matcherPrototype);
    or.test = function (actual) {
        return m1.test(actual) || m2.test(actual);
    };
    or.message = `${m1.message}.or(${m2.message})`;
    return or;
};

matcherPrototype.and = function (valueOrMatcher) {
    var createMatcher = require("../create-matcher");
    var isMatcher = createMatcher.isMatcher;

    if (!arguments.length) {
        throw new TypeError("Matcher expected");
    }

    var m2 = isMatcher(valueOrMatcher)
        ? valueOrMatcher
        : createMatcher(valueOrMatcher);
    var m1 = this;
    var and = Object.create(matcherPrototype);
    and.test = function (actual) {
        return m1.test(actual) && m2.test(actual);
    };
    and.message = `${m1.message}.and(${m2.message})`;
    return and;
};

module.exports = matcherPrototype;

},{"../create-matcher":61}],69:[function(require,module,exports){
"use strict";

var functionName = require("@sinonjs/commons").functionName;
var join = require("@sinonjs/commons").prototypes.array.join;
var map = require("@sinonjs/commons").prototypes.array.map;
var stringIndexOf = require("@sinonjs/commons").prototypes.string.indexOf;
var valueToString = require("@sinonjs/commons").valueToString;

var matchObject = require("./match-object");

var createTypeMap = function (match) {
    return {
        function: function (m, expectation, message) {
            m.test = expectation;
            m.message = message || `match(${functionName(expectation)})`;
        },
        number: function (m, expectation) {
            m.test = function (actual) {
                // we need type coercion here
                return expectation == actual; // eslint-disable-line eqeqeq
            };
        },
        object: function (m, expectation) {
            var array = [];

            if (typeof expectation.test === "function") {
                m.test = function (actual) {
                    return expectation.test(actual) === true;
                };
                m.message = `match(${functionName(expectation.test)})`;
                return m;
            }

            array = map(Object.keys(expectation), function (key) {
                return `${key}: ${valueToString(expectation[key])}`;
            });

            m.test = function (actual) {
                return matchObject(actual, expectation, match);
            };
            m.message = `match(${join(array, ", ")})`;

            return m;
        },
        regexp: function (m, expectation) {
            m.test = function (actual) {
                return typeof actual === "string" && expectation.test(actual);
            };
        },
        string: function (m, expectation) {
            m.test = function (actual) {
                return (
                    typeof actual === "string" &&
                    stringIndexOf(actual, expectation) !== -1
                );
            };
            m.message = `match("${expectation}")`;
        },
    };
};

module.exports = createTypeMap;

},{"./match-object":67,"@sinonjs/commons":46}],70:[function(require,module,exports){
"use strict";

var valueToString = require("@sinonjs/commons").valueToString;
var className = require("@sinonjs/commons").className;
var typeOf = require("@sinonjs/commons").typeOf;
var arrayProto = require("@sinonjs/commons").prototypes.array;
var objectProto = require("@sinonjs/commons").prototypes.object;
var mapForEach = require("@sinonjs/commons").prototypes.map.forEach;

var getClass = require("./get-class");
var identical = require("./identical");
var isArguments = require("./is-arguments");
var isArrayType = require("./is-array-type");
var isDate = require("./is-date");
var isElement = require("./is-element");
var isIterable = require("./is-iterable");
var isMap = require("./is-map");
var isNaN = require("./is-nan");
var isObject = require("./is-object");
var isSet = require("./is-set");
var isSubset = require("./is-subset");

var concat = arrayProto.concat;
var every = arrayProto.every;
var push = arrayProto.push;

var getTime = Date.prototype.getTime;
var hasOwnProperty = objectProto.hasOwnProperty;
var indexOf = arrayProto.indexOf;
var keys = Object.keys;
var getOwnPropertySymbols = Object.getOwnPropertySymbols;

/**
 * Deep equal comparison. Two values are "deep equal" when:
 *
 *   - They are equal, according to samsam.identical
 *   - They are both date objects representing the same time
 *   - They are both arrays containing elements that are all deepEqual
 *   - They are objects with the same set of properties, and each property
 *     in ``actual`` is deepEqual to the corresponding property in ``expectation``
 *
 * Supports cyclic objects.
 *
 * @alias module:samsam.deepEqual
 * @param {*} actual The object to examine
 * @param {*} expectation The object actual is expected to be equal to
 * @param {object} match A value to match on
 * @returns {boolean} Returns true when actual and expectation are considered equal
 */
function deepEqualCyclic(actual, expectation, match) {
    // used for cyclic comparison
    // contain already visited objects
    var actualObjects = [];
    var expectationObjects = [];
    // contain pathes (position in the object structure)
    // of the already visited objects
    // indexes same as in objects arrays
    var actualPaths = [];
    var expectationPaths = [];
    // contains combinations of already compared objects
    // in the manner: { "$1['ref']$2['ref']": true }
    var compared = {};

    // does the recursion for the deep equal check
    // eslint-disable-next-line complexity
    return (function deepEqual(
        actualObj,
        expectationObj,
        actualPath,
        expectationPath,
    ) {
        // If both are matchers they must be the same instance in order to be
        // considered equal If we didn't do that we would end up running one
        // matcher against the other
        if (match && match.isMatcher(expectationObj)) {
            if (match.isMatcher(actualObj)) {
                return actualObj === expectationObj;
            }
            return expectationObj.test(actualObj);
        }

        var actualType = typeof actualObj;
        var expectationType = typeof expectationObj;

        if (
            actualObj === expectationObj ||
            isNaN(actualObj) ||
            isNaN(expectationObj) ||
            actualObj === null ||
            expectationObj === null ||
            actualObj === undefined ||
            expectationObj === undefined ||
            actualType !== "object" ||
            expectationType !== "object"
        ) {
            return identical(actualObj, expectationObj);
        }

        // Elements are only equal if identical(expected, actual)
        if (isElement(actualObj) || isElement(expectationObj)) {
            return false;
        }

        var isActualDate = isDate(actualObj);
        var isExpectationDate = isDate(expectationObj);
        if (isActualDate || isExpectationDate) {
            if (
                !isActualDate ||
                !isExpectationDate ||
                getTime.call(actualObj) !== getTime.call(expectationObj)
            ) {
                return false;
            }
        }

        if (actualObj instanceof RegExp && expectationObj instanceof RegExp) {
            if (valueToString(actualObj) !== valueToString(expectationObj)) {
                return false;
            }
        }

        if (actualObj instanceof Promise && expectationObj instanceof Promise) {
            return actualObj === expectationObj;
        }

        if (actualObj instanceof Error && expectationObj instanceof Error) {
            return actualObj === expectationObj;
        }

        var actualClass = getClass(actualObj);
        var expectationClass = getClass(expectationObj);
        var actualKeys = keys(actualObj);
        var expectationKeys = keys(expectationObj);
        var actualName = className(actualObj);
        var expectationName = className(expectationObj);
        var expectationSymbols =
            typeOf(getOwnPropertySymbols) === "function"
                ? getOwnPropertySymbols(expectationObj)
                : /* istanbul ignore next: cannot collect coverage for engine that doesn't support Symbol */
                  [];
        var expectationKeysAndSymbols = concat(
            expectationKeys,
            expectationSymbols,
        );

        if (isArguments(actualObj) || isArguments(expectationObj)) {
            if (actualObj.length !== expectationObj.length) {
                return false;
            }
        } else {
            if (
                actualType !== expectationType ||
                actualClass !== expectationClass ||
                actualKeys.length !== expectationKeys.length ||
                (actualName &&
                    expectationName &&
                    actualName !== expectationName)
            ) {
                return false;
            }
        }

        if (isSet(actualObj) || isSet(expectationObj)) {
            if (
                !isSet(actualObj) ||
                !isSet(expectationObj) ||
                actualObj.size !== expectationObj.size
            ) {
                return false;
            }

            return isSubset(actualObj, expectationObj, deepEqual);
        }

        if (isMap(actualObj) || isMap(expectationObj)) {
            if (
                !isMap(actualObj) ||
                !isMap(expectationObj) ||
                actualObj.size !== expectationObj.size
            ) {
                return false;
            }

            var mapsDeeplyEqual = true;
            mapForEach(actualObj, function (value, key) {
                mapsDeeplyEqual =
                    mapsDeeplyEqual &&
                    deepEqualCyclic(value, expectationObj.get(key));
            });

            return mapsDeeplyEqual;
        }

        // jQuery objects have iteration protocols
        // see: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols
        // But, they don't work well with the implementation concerning iterables below,
        // so we will detect them and use jQuery's own equality function
        /* istanbul ignore next -- this can only be tested in the `test-headless` script */
        if (
            actualObj.constructor &&
            actualObj.constructor.name === "jQuery" &&
            typeof actualObj.is === "function"
        ) {
            return actualObj.is(expectationObj);
        }

        var isActualNonArrayIterable =
            isIterable(actualObj) &&
            !isArrayType(actualObj) &&
            !isArguments(actualObj);
        var isExpectationNonArrayIterable =
            isIterable(expectationObj) &&
            !isArrayType(expectationObj) &&
            !isArguments(expectationObj);
        if (isActualNonArrayIterable || isExpectationNonArrayIterable) {
            var actualArray = Array.from(actualObj);
            var expectationArray = Array.from(expectationObj);
            if (actualArray.length !== expectationArray.length) {
                return false;
            }

            var arrayDeeplyEquals = true;
            every(actualArray, function (key) {
                arrayDeeplyEquals =
                    arrayDeeplyEquals &&
                    deepEqualCyclic(actualArray[key], expectationArray[key]);
            });

            return arrayDeeplyEquals;
        }

        return every(expectationKeysAndSymbols, function (key) {
            if (!hasOwnProperty(actualObj, key)) {
                return false;
            }

            var actualValue = actualObj[key];
            var expectationValue = expectationObj[key];
            var actualObject = isObject(actualValue);
            var expectationObject = isObject(expectationValue);
            // determines, if the objects were already visited
            // (it's faster to check for isObject first, than to
            // get -1 from getIndex for non objects)
            var actualIndex = actualObject
                ? indexOf(actualObjects, actualValue)
                : -1;
            var expectationIndex = expectationObject
                ? indexOf(expectationObjects, expectationValue)
                : -1;
            // determines the new paths of the objects
            // - for non cyclic objects the current path will be extended
            //   by current property name
            // - for cyclic objects the stored path is taken
            var newActualPath =
                actualIndex !== -1
                    ? actualPaths[actualIndex]
                    : `${actualPath}[${JSON.stringify(key)}]`;
            var newExpectationPath =
                expectationIndex !== -1
                    ? expectationPaths[expectationIndex]
                    : `${expectationPath}[${JSON.stringify(key)}]`;
            var combinedPath = newActualPath + newExpectationPath;

            // stop recursion if current objects are already compared
            if (compared[combinedPath]) {
                return true;
            }

            // remember the current objects and their paths
            if (actualIndex === -1 && actualObject) {
                push(actualObjects, actualValue);
                push(actualPaths, newActualPath);
            }
            if (expectationIndex === -1 && expectationObject) {
                push(expectationObjects, expectationValue);
                push(expectationPaths, newExpectationPath);
            }

            // remember that the current objects are already compared
            if (actualObject && expectationObject) {
                compared[combinedPath] = true;
            }

            // End of cyclic logic

            // neither actualValue nor expectationValue is a cycle
            // continue with next level
            return deepEqual(
                actualValue,
                expectationValue,
                newActualPath,
                newExpectationPath,
            );
        });
    })(actual, expectation, "$1", "$2");
}

deepEqualCyclic.use = function (match) {
    return function deepEqual(a, b) {
        return deepEqualCyclic(a, b, match);
    };
};

module.exports = deepEqualCyclic;

},{"./get-class":71,"./identical":72,"./is-arguments":73,"./is-array-type":74,"./is-date":75,"./is-element":76,"./is-iterable":77,"./is-map":78,"./is-nan":79,"./is-object":81,"./is-set":82,"./is-subset":83,"@sinonjs/commons":46}],71:[function(require,module,exports){
"use strict";

var toString = require("@sinonjs/commons").prototypes.object.toString;

/**
 * Returns the internal `Class` by calling `Object.prototype.toString`
 * with the provided value as `this`. Return value is a `String`, naming the
 * internal class, e.g. "Array"
 *
 * @private
 * @param  {*} value - Any value
 * @returns {string} - A string representation of the `Class` of `value`
 */
function getClass(value) {
    return toString(value).split(/[ \]]/)[1];
}

module.exports = getClass;

},{"@sinonjs/commons":46}],72:[function(require,module,exports){
"use strict";

var isNaN = require("./is-nan");
var isNegZero = require("./is-neg-zero");

/**
 * Strict equality check according to EcmaScript Harmony's `egal`.
 *
 * **From the Harmony wiki:**
 * > An `egal` function simply makes available the internal `SameValue` function
 * > from section 9.12 of the ES5 spec. If two values are egal, then they are not
 * > observably distinguishable.
 *
 * `identical` returns `true` when `===` is `true`, except for `-0` and
 * `+0`, where it returns `false`. Additionally, it returns `true` when
 * `NaN` is compared to itself.
 *
 * @alias module:samsam.identical
 * @param {*} obj1 The first value to compare
 * @param {*} obj2 The second value to compare
 * @returns {boolean} Returns `true` when the objects are *egal*, `false` otherwise
 */
function identical(obj1, obj2) {
    if (obj1 === obj2 || (isNaN(obj1) && isNaN(obj2))) {
        return obj1 !== 0 || isNegZero(obj1) === isNegZero(obj2);
    }

    return false;
}

module.exports = identical;

},{"./is-nan":79,"./is-neg-zero":80}],73:[function(require,module,exports){
"use strict";

var getClass = require("./get-class");

/**
 * Returns `true` when `object` is an `arguments` object, `false` otherwise
 *
 * @alias module:samsam.isArguments
 * @param  {*}  object - The object to examine
 * @returns {boolean} `true` when `object` is an `arguments` object
 */
function isArguments(object) {
    return getClass(object) === "Arguments";
}

module.exports = isArguments;

},{"./get-class":71}],74:[function(require,module,exports){
"use strict";

var functionName = require("@sinonjs/commons").functionName;
var indexOf = require("@sinonjs/commons").prototypes.array.indexOf;
var map = require("@sinonjs/commons").prototypes.array.map;
var ARRAY_TYPES = require("./array-types");
var type = require("type-detect");

/**
 * Returns `true` when `object` is an array type, `false` otherwise
 *
 * @param  {*}  object - The object to examine
 * @returns {boolean} `true` when `object` is an array type
 * @private
 */
function isArrayType(object) {
    return indexOf(map(ARRAY_TYPES, functionName), type(object)) !== -1;
}

module.exports = isArrayType;

},{"./array-types":60,"@sinonjs/commons":46,"type-detect":87}],75:[function(require,module,exports){
"use strict";

/**
 * Returns `true` when `value` is an instance of Date
 *
 * @private
 * @param  {Date}  value The value to examine
 * @returns {boolean}     `true` when `value` is an instance of Date
 */
function isDate(value) {
    return value instanceof Date;
}

module.exports = isDate;

},{}],76:[function(require,module,exports){
"use strict";

var div = typeof document !== "undefined" && document.createElement("div");

/**
 * Returns `true` when `object` is a DOM element node.
 *
 * Unlike Underscore.js/lodash, this function will return `false` if `object`
 * is an *element-like* object, i.e. a regular object with a `nodeType`
 * property that holds the value `1`.
 *
 * @alias module:samsam.isElement
 * @param {object} object The object to examine
 * @returns {boolean} Returns `true` for DOM element nodes
 */
function isElement(object) {
    if (!object || object.nodeType !== 1 || !div) {
        return false;
    }
    try {
        object.appendChild(div);
        object.removeChild(div);
    } catch (e) {
        return false;
    }
    return true;
}

module.exports = isElement;

},{}],77:[function(require,module,exports){
"use strict";

/**
 * Returns `true` when the argument is an iterable, `false` otherwise
 *
 * @alias module:samsam.isIterable
 * @param  {*}  val - A value to examine
 * @returns {boolean} Returns `true` when the argument is an iterable, `false` otherwise
 */
function isIterable(val) {
    // checks for null and undefined
    if (typeof val !== "object") {
        return false;
    }
    return typeof val[Symbol.iterator] === "function";
}

module.exports = isIterable;

},{}],78:[function(require,module,exports){
"use strict";

/**
 * Returns `true` when `value` is a Map
 *
 * @param {*} value A value to examine
 * @returns {boolean} `true` when `value` is an instance of `Map`, `false` otherwise
 * @private
 */
function isMap(value) {
    return typeof Map !== "undefined" && value instanceof Map;
}

module.exports = isMap;

},{}],79:[function(require,module,exports){
"use strict";

/**
 * Compares a `value` to `NaN`
 *
 * @private
 * @param {*} value A value to examine
 * @returns {boolean} Returns `true` when `value` is `NaN`
 */
function isNaN(value) {
    // Unlike global `isNaN`, this function avoids type coercion
    // `typeof` check avoids IE host object issues, hat tip to
    // lodash

    // eslint-disable-next-line no-self-compare
    return typeof value === "number" && value !== value;
}

module.exports = isNaN;

},{}],80:[function(require,module,exports){
"use strict";

/**
 * Returns `true` when `value` is `-0`
 *
 * @alias module:samsam.isNegZero
 * @param {*} value A value to examine
 * @returns {boolean} Returns `true` when `value` is `-0`
 */
function isNegZero(value) {
    return value === 0 && 1 / value === -Infinity;
}

module.exports = isNegZero;

},{}],81:[function(require,module,exports){
"use strict";

/**
 * Returns `true` when the value is a regular Object and not a specialized Object
 *
 * This helps speed up deepEqual cyclic checks
 *
 * The premise is that only Objects are stored in the visited array.
 * So if this function returns false, we don't have to do the
 * expensive operation of searching for the value in the the array of already
 * visited objects
 *
 * @private
 * @param  {object}   value The object to examine
 * @returns {boolean}       `true` when the object is a non-specialised object
 */
function isObject(value) {
    return (
        typeof value === "object" &&
        value !== null &&
        // none of these are collection objects, so we can return false
        !(value instanceof Boolean) &&
        !(value instanceof Date) &&
        !(value instanceof Error) &&
        !(value instanceof Number) &&
        !(value instanceof RegExp) &&
        !(value instanceof String)
    );
}

module.exports = isObject;

},{}],82:[function(require,module,exports){
"use strict";

/**
 * Returns `true` when the argument is an instance of Set, `false` otherwise
 *
 * @alias module:samsam.isSet
 * @param  {*}  val - A value to examine
 * @returns {boolean} Returns `true` when the argument is an instance of Set, `false` otherwise
 */
function isSet(val) {
    return (typeof Set !== "undefined" && val instanceof Set) || false;
}

module.exports = isSet;

},{}],83:[function(require,module,exports){
"use strict";

var forEach = require("@sinonjs/commons").prototypes.set.forEach;

/**
 * Returns `true` when `s1` is a subset of `s2`, `false` otherwise
 *
 * @private
 * @param  {Array|Set}  s1      The target value
 * @param  {Array|Set}  s2      The containing value
 * @param  {Function}  compare A comparison function, should return `true` when
 *                             values are considered equal
 * @returns {boolean} Returns `true` when `s1` is a subset of `s2`, `false`` otherwise
 */
function isSubset(s1, s2, compare) {
    var allContained = true;
    forEach(s1, function (v1) {
        var includes = false;
        forEach(s2, function (v2) {
            if (compare(v2, v1)) {
                includes = true;
            }
        });
        allContained = allContained && includes;
    });

    return allContained;
}

module.exports = isSubset;

},{"@sinonjs/commons":46}],84:[function(require,module,exports){
"use strict";

var slice = require("@sinonjs/commons").prototypes.string.slice;
var typeOf = require("@sinonjs/commons").typeOf;
var valueToString = require("@sinonjs/commons").valueToString;

/**
 * Creates a string represenation of an iterable object
 *
 * @private
 * @param   {object} obj The iterable object to stringify
 * @returns {string}     A string representation
 */
function iterableToString(obj) {
    if (typeOf(obj) === "map") {
        return mapToString(obj);
    }

    return genericIterableToString(obj);
}

/**
 * Creates a string representation of a Map
 *
 * @private
 * @param   {Map} map    The map to stringify
 * @returns {string}     A string representation
 */
function mapToString(map) {
    var representation = "";

    // eslint-disable-next-line @sinonjs/no-prototype-methods/no-prototype-methods
    map.forEach(function (value, key) {
        representation += `[${stringify(key)},${stringify(value)}],`;
    });

    representation = slice(representation, 0, -1);
    return representation;
}

/**
 * Create a string represenation for an iterable
 *
 * @private
 * @param   {object} iterable The iterable to stringify
 * @returns {string}          A string representation
 */
function genericIterableToString(iterable) {
    var representation = "";

    // eslint-disable-next-line @sinonjs/no-prototype-methods/no-prototype-methods
    iterable.forEach(function (value) {
        representation += `${stringify(value)},`;
    });

    representation = slice(representation, 0, -1);
    return representation;
}

/**
 * Creates a string representation of the passed `item`
 *
 * @private
 * @param  {object} item The item to stringify
 * @returns {string}      A string representation of `item`
 */
function stringify(item) {
    return typeof item === "string" ? `'${item}'` : valueToString(item);
}

module.exports = iterableToString;

},{"@sinonjs/commons":46}],85:[function(require,module,exports){
"use strict";

var valueToString = require("@sinonjs/commons").valueToString;
var indexOf = require("@sinonjs/commons").prototypes.string.indexOf;
var forEach = require("@sinonjs/commons").prototypes.array.forEach;
var type = require("type-detect");

var engineCanCompareMaps = typeof Array.from === "function";
var deepEqual = require("./deep-equal").use(match); // eslint-disable-line no-use-before-define
var isArrayType = require("./is-array-type");
var isSubset = require("./is-subset");
var createMatcher = require("./create-matcher");

/**
 * Returns true when `array` contains all of `subset` as defined by the `compare`
 * argument
 *
 * @param  {Array} array   An array to search for a subset
 * @param  {Array} subset  The subset to find in the array
 * @param  {Function} compare A comparison function
 * @returns {boolean}         [description]
 * @private
 */
function arrayContains(array, subset, compare) {
    if (subset.length === 0) {
        return true;
    }
    var i, l, j, k;
    for (i = 0, l = array.length; i < l; ++i) {
        if (compare(array[i], subset[0])) {
            for (j = 0, k = subset.length; j < k; ++j) {
                if (i + j >= l) {
                    return false;
                }
                if (!compare(array[i + j], subset[j])) {
                    return false;
                }
            }
            return true;
        }
    }
    return false;
}

/* eslint-disable complexity */
/**
 * Matches an object with a matcher (or value)
 *
 * @alias module:samsam.match
 * @param {object} object The object candidate to match
 * @param {object} matcherOrValue A matcher or value to match against
 * @returns {boolean} true when `object` matches `matcherOrValue`
 */
function match(object, matcherOrValue) {
    if (matcherOrValue && typeof matcherOrValue.test === "function") {
        return matcherOrValue.test(object);
    }

    switch (type(matcherOrValue)) {
        case "bigint":
        case "boolean":
        case "number":
        case "symbol":
            return matcherOrValue === object;
        case "function":
            return matcherOrValue(object) === true;
        case "string":
            var notNull = typeof object === "string" || Boolean(object);
            return (
                notNull &&
                indexOf(
                    valueToString(object).toLowerCase(),
                    matcherOrValue.toLowerCase(),
                ) >= 0
            );
        case "null":
            return object === null;
        case "undefined":
            return typeof object === "undefined";
        case "Date":
            /* istanbul ignore else */
            if (type(object) === "Date") {
                return object.getTime() === matcherOrValue.getTime();
            }
            /* istanbul ignore next: this is basically the rest of the function, which is covered */
            break;
        case "Array":
        case "Int8Array":
        case "Uint8Array":
        case "Uint8ClampedArray":
        case "Int16Array":
        case "Uint16Array":
        case "Int32Array":
        case "Uint32Array":
        case "Float32Array":
        case "Float64Array":
            return (
                isArrayType(matcherOrValue) &&
                arrayContains(object, matcherOrValue, match)
            );
        case "Map":
            /* istanbul ignore next: this is covered by a test, that is only run in IE, but we collect coverage information in node*/
            if (!engineCanCompareMaps) {
                throw new Error(
                    "The JavaScript engine does not support Array.from and cannot reliably do value comparison of Map instances",
                );
            }

            return (
                type(object) === "Map" &&
                arrayContains(
                    Array.from(object),
                    Array.from(matcherOrValue),
                    match,
                )
            );
        default:
            break;
    }

    switch (type(object)) {
        case "null":
            return false;
        case "Set":
            return isSubset(matcherOrValue, object, match);
        default:
            break;
    }

    /* istanbul ignore else */
    if (matcherOrValue && typeof matcherOrValue === "object") {
        if (matcherOrValue === object) {
            return true;
        }
        if (typeof object !== "object") {
            return false;
        }
        var prop;
        // eslint-disable-next-line guard-for-in
        for (prop in matcherOrValue) {
            var value = object[prop];
            if (
                typeof value === "undefined" &&
                typeof object.getAttribute === "function"
            ) {
                value = object.getAttribute(prop);
            }
            if (
                matcherOrValue[prop] === null ||
                typeof matcherOrValue[prop] === "undefined"
            ) {
                if (value !== matcherOrValue[prop]) {
                    return false;
                }
            } else if (
                typeof value === "undefined" ||
                !deepEqual(value, matcherOrValue[prop])
            ) {
                return false;
            }
        }
        return true;
    }

    /* istanbul ignore next */
    throw new Error("Matcher was an unknown or unsupported type");
}
/* eslint-enable complexity */

forEach(Object.keys(createMatcher), function (key) {
    match[key] = createMatcher[key];
});

module.exports = match;

},{"./create-matcher":61,"./deep-equal":70,"./is-array-type":74,"./is-subset":83,"@sinonjs/commons":46,"type-detect":87}],86:[function(require,module,exports){
"use strict";

/**
 * @module samsam
 */
var identical = require("./identical");
var isArguments = require("./is-arguments");
var isElement = require("./is-element");
var isNegZero = require("./is-neg-zero");
var isSet = require("./is-set");
var isMap = require("./is-map");
var match = require("./match");
var deepEqualCyclic = require("./deep-equal").use(match);
var createMatcher = require("./create-matcher");

module.exports = {
    createMatcher: createMatcher,
    deepEqual: deepEqualCyclic,
    identical: identical,
    isArguments: isArguments,
    isElement: isElement,
    isMap: isMap,
    isNegZero: isNegZero,
    isSet: isSet,
    match: match,
};

},{"./create-matcher":61,"./deep-equal":70,"./identical":72,"./is-arguments":73,"./is-element":76,"./is-map":78,"./is-neg-zero":80,"./is-set":82,"./match":85}],87:[function(require,module,exports){
(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
    typeof define === 'function' && define.amd ? define(factory) :
    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.typeDetect = factory());
})(this, (function () { 'use strict';

    var promiseExists = typeof Promise === 'function';
    var globalObject = (function (Obj) {
        if (typeof globalThis === 'object') {
            return globalThis;
        }
        Object.defineProperty(Obj, 'typeDetectGlobalObject', {
            get: function get() {
                return this;
            },
            configurable: true,
        });
        var global = typeDetectGlobalObject;
        delete Obj.typeDetectGlobalObject;
        return global;
    })(Object.prototype);
    var symbolExists = typeof Symbol !== 'undefined';
    var mapExists = typeof Map !== 'undefined';
    var setExists = typeof Set !== 'undefined';
    var weakMapExists = typeof WeakMap !== 'undefined';
    var weakSetExists = typeof WeakSet !== 'undefined';
    var dataViewExists = typeof DataView !== 'undefined';
    var symbolIteratorExists = symbolExists && typeof Symbol.iterator !== 'undefined';
    var symbolToStringTagExists = symbolExists && typeof Symbol.toStringTag !== 'undefined';
    var setEntriesExists = setExists && typeof Set.prototype.entries === 'function';
    var mapEntriesExists = mapExists && typeof Map.prototype.entries === 'function';
    var setIteratorPrototype = setEntriesExists && Object.getPrototypeOf(new Set().entries());
    var mapIteratorPrototype = mapEntriesExists && Object.getPrototypeOf(new Map().entries());
    var arrayIteratorExists = symbolIteratorExists && typeof Array.prototype[Symbol.iterator] === 'function';
    var arrayIteratorPrototype = arrayIteratorExists && Object.getPrototypeOf([][Symbol.iterator]());
    var stringIteratorExists = symbolIteratorExists && typeof String.prototype[Symbol.iterator] === 'function';
    var stringIteratorPrototype = stringIteratorExists && Object.getPrototypeOf(''[Symbol.iterator]());
    var toStringLeftSliceLength = 8;
    var toStringRightSliceLength = -1;
    function typeDetect(obj) {
        var typeofObj = typeof obj;
        if (typeofObj !== 'object') {
            return typeofObj;
        }
        if (obj === null) {
            return 'null';
        }
        if (obj === globalObject) {
            return 'global';
        }
        if (Array.isArray(obj) &&
            (symbolToStringTagExists === false || !(Symbol.toStringTag in obj))) {
            return 'Array';
        }
        if (typeof window === 'object' && window !== null) {
            if (typeof window.location === 'object' && obj === window.location) {
                return 'Location';
            }
            if (typeof window.document === 'object' && obj === window.document) {
                return 'Document';
            }
            if (typeof window.navigator === 'object') {
                if (typeof window.navigator.mimeTypes === 'object' &&
                    obj === window.navigator.mimeTypes) {
                    return 'MimeTypeArray';
                }
                if (typeof window.navigator.plugins === 'object' &&
                    obj === window.navigator.plugins) {
                    return 'PluginArray';
                }
            }
            if ((typeof window.HTMLElement === 'function' ||
                typeof window.HTMLElement === 'object') &&
                obj instanceof window.HTMLElement) {
                if (obj.tagName === 'BLOCKQUOTE') {
                    return 'HTMLQuoteElement';
                }
                if (obj.tagName === 'TD') {
                    return 'HTMLTableDataCellElement';
                }
                if (obj.tagName === 'TH') {
                    return 'HTMLTableHeaderCellElement';
                }
            }
        }
        var stringTag = (symbolToStringTagExists && obj[Symbol.toStringTag]);
        if (typeof stringTag === 'string') {
            return stringTag;
        }
        var objPrototype = Object.getPrototypeOf(obj);
        if (objPrototype === RegExp.prototype) {
            return 'RegExp';
        }
        if (objPrototype === Date.prototype) {
            return 'Date';
        }
        if (promiseExists && objPrototype === Promise.prototype) {
            return 'Promise';
        }
        if (setExists && objPrototype === Set.prototype) {
            return 'Set';
        }
        if (mapExists && objPrototype === Map.prototype) {
            return 'Map';
        }
        if (weakSetExists && objPrototype === WeakSet.prototype) {
            return 'WeakSet';
        }
        if (weakMapExists && objPrototype === WeakMap.prototype) {
            return 'WeakMap';
        }
        if (dataViewExists && objPrototype === DataView.prototype) {
            return 'DataView';
        }
        if (mapExists && objPrototype === mapIteratorPrototype) {
            return 'Map Iterator';
        }
        if (setExists && objPrototype === setIteratorPrototype) {
            return 'Set Iterator';
        }
        if (arrayIteratorExists && objPrototype === arrayIteratorPrototype) {
            return 'Array Iterator';
        }
        if (stringIteratorExists && objPrototype === stringIteratorPrototype) {
            return 'String Iterator';
        }
        if (objPrototype === null) {
            return 'Object';
        }
        return Object
            .prototype
            .toString
            .call(obj)
            .slice(toStringLeftSliceLength, toStringRightSliceLength);
    }

    return typeDetect;

}));

},{}],88:[function(require,module,exports){
if (typeof Object.create === 'function') {
  // implementation from standard node.js 'util' module
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    ctor.prototype = Object.create(superCtor.prototype, {
      constructor: {
        value: ctor,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
  };
} else {
  // old school shim for old browsers
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    var TempCtor = function () {}
    TempCtor.prototype = superCtor.prototype
    ctor.prototype = new TempCtor()
    ctor.prototype.constructor = ctor
  }
}

},{}],89:[function(require,module,exports){
module.exports = function isBuffer(arg) {
  return arg && typeof arg === 'object'
    && typeof arg.copy === 'function'
    && typeof arg.fill === 'function'
    && typeof arg.readUInt8 === 'function';
}
},{}],90:[function(require,module,exports){
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

var formatRegExp = /%[sdj%]/g;
exports.format = function(f) {
  if (!isString(f)) {
    var objects = [];
    for (var i = 0; i < arguments.length; i++) {
      objects.push(inspect(arguments[i]));
    }
    return objects.join(' ');
  }

  var i = 1;
  var args = arguments;
  var len = args.length;
  var str = String(f).replace(formatRegExp, function(x) {
    if (x === '%%') return '%';
    if (i >= len) return x;
    switch (x) {
      case '%s': return String(args[i++]);
      case '%d': return Number(args[i++]);
      case '%j':
        try {
          return JSON.stringify(args[i++]);
        } catch (_) {
          return '[Circular]';
        }
      default:
        return x;
    }
  });
  for (var x = args[i]; i < len; x = args[++i]) {
    if (isNull(x) || !isObject(x)) {
      str += ' ' + x;
    } else {
      str += ' ' + inspect(x);
    }
  }
  return str;
};


// Mark that a method should not be used.
// Returns a modified function which warns once by default.
// If --no-deprecation is set, then it is a no-op.
exports.deprecate = function(fn, msg) {
  // Allow for deprecating things in the process of starting up.
  if (isUndefined(global.process)) {
    return function() {
      return exports.deprecate(fn, msg).apply(this, arguments);
    };
  }

  if (process.noDeprecation === true) {
    return fn;
  }

  var warned = false;
  function deprecated() {
    if (!warned) {
      if (process.throwDeprecation) {
        throw new Error(msg);
      } else if (process.traceDeprecation) {
        console.trace(msg);
      } else {
        console.error(msg);
      }
      warned = true;
    }
    return fn.apply(this, arguments);
  }

  return deprecated;
};


var debugs = {};
var debugEnviron;
exports.debuglog = function(set) {
  if (isUndefined(debugEnviron))
    debugEnviron = process.env.NODE_DEBUG || '';
  set = set.toUpperCase();
  if (!debugs[set]) {
    if (new RegExp('\\b' + set + '\\b', 'i').test(debugEnviron)) {
      var pid = process.pid;
      debugs[set] = function() {
        var msg = exports.format.apply(exports, arguments);
        console.error('%s %d: %s', set, pid, msg);
      };
    } else {
      debugs[set] = function() {};
    }
  }
  return debugs[set];
};


/**
 * Echos the value of a value. Trys to print the value out
 * in the best way possible given the different types.
 *
 * @param {Object} obj The object to print out.
 * @param {Object} opts Optional options object that alters the output.
 */
/* legacy: obj, showHidden, depth, colors*/
function inspect(obj, opts) {
  // default options
  var ctx = {
    seen: [],
    stylize: stylizeNoColor
  };
  // legacy...
  if (arguments.length >= 3) ctx.depth = arguments[2];
  if (arguments.length >= 4) ctx.colors = arguments[3];
  if (isBoolean(opts)) {
    // legacy...
    ctx.showHidden = opts;
  } else if (opts) {
    // got an "options" object
    exports._extend(ctx, opts);
  }
  // set default options
  if (isUndefined(ctx.showHidden)) ctx.showHidden = false;
  if (isUndefined(ctx.depth)) ctx.depth = 2;
  if (isUndefined(ctx.colors)) ctx.colors = false;
  if (isUndefined(ctx.customInspect)) ctx.customInspect = true;
  if (ctx.colors) ctx.stylize = stylizeWithColor;
  return formatValue(ctx, obj, ctx.depth);
}
exports.inspect = inspect;


// http://en.wikipedia.org/wiki/ANSI_escape_code#graphics
inspect.colors = {
  'bold' : [1, 22],
  'italic' : [3, 23],
  'underline' : [4, 24],
  'inverse' : [7, 27],
  'white' : [37, 39],
  'grey' : [90, 39],
  'black' : [30, 39],
  'blue' : [34, 39],
  'cyan' : [36, 39],
  'green' : [32, 39],
  'magenta' : [35, 39],
  'red' : [31, 39],
  'yellow' : [33, 39]
};

// Don't use 'blue' not visible on cmd.exe
inspect.styles = {
  'special': 'cyan',
  'number': 'yellow',
  'boolean': 'yellow',
  'undefined': 'grey',
  'null': 'bold',
  'string': 'green',
  'date': 'magenta',
  // "name": intentionally not styling
  'regexp': 'red'
};


function stylizeWithColor(str, styleType) {
  var style = inspect.styles[styleType];

  if (style) {
    return '\u001b[' + inspect.colors[style][0] + 'm' + str +
           '\u001b[' + inspect.colors[style][1] + 'm';
  } else {
    return str;
  }
}


function stylizeNoColor(str, styleType) {
  return str;
}


function arrayToHash(array) {
  var hash = {};

  array.forEach(function(val, idx) {
    hash[val] = true;
  });

  return hash;
}


function formatValue(ctx, value, recurseTimes) {
  // Provide a hook for user-specified inspect functions.
  // Check that value is an object with an inspect function on it
  if (ctx.customInspect &&
      value &&
      isFunction(value.inspect) &&
      // Filter out the util module, it's inspect function is special
      value.inspect !== exports.inspect &&
      // Also filter out any prototype objects using the circular check.
      !(value.constructor && value.constructor.prototype === value)) {
    var ret = value.inspect(recurseTimes, ctx);
    if (!isString(ret)) {
      ret = formatValue(ctx, ret, recurseTimes);
    }
    return ret;
  }

  // Primitive types cannot have properties
  var primitive = formatPrimitive(ctx, value);
  if (primitive) {
    return primitive;
  }

  // Look up the keys of the object.
  var keys = Object.keys(value);
  var visibleKeys = arrayToHash(keys);

  if (ctx.showHidden) {
    keys = Object.getOwnPropertyNames(value);
  }

  // IE doesn't make error fields non-enumerable
  // http://msdn.microsoft.com/en-us/library/ie/dww52sbt(v=vs.94).aspx
  if (isError(value)
      && (keys.indexOf('message') >= 0 || keys.indexOf('description') >= 0)) {
    return formatError(value);
  }

  // Some type of object without properties can be shortcutted.
  if (keys.length === 0) {
    if (isFunction(value)) {
      var name = value.name ? ': ' + value.name : '';
      return ctx.stylize('[Function' + name + ']', 'special');
    }
    if (isRegExp(value)) {
      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
    }
    if (isDate(value)) {
      return ctx.stylize(Date.prototype.toString.call(value), 'date');
    }
    if (isError(value)) {
      return formatError(value);
    }
  }

  var base = '', array = false, braces = ['{', '}'];

  // Make Array say that they are Array
  if (isArray(value)) {
    array = true;
    braces = ['[', ']'];
  }

  // Make functions say that they are functions
  if (isFunction(value)) {
    var n = value.name ? ': ' + value.name : '';
    base = ' [Function' + n + ']';
  }

  // Make RegExps say that they are RegExps
  if (isRegExp(value)) {
    base = ' ' + RegExp.prototype.toString.call(value);
  }

  // Make dates with properties first say the date
  if (isDate(value)) {
    base = ' ' + Date.prototype.toUTCString.call(value);
  }

  // Make error with message first say the error
  if (isError(value)) {
    base = ' ' + formatError(value);
  }

  if (keys.length === 0 && (!array || value.length == 0)) {
    return braces[0] + base + braces[1];
  }

  if (recurseTimes < 0) {
    if (isRegExp(value)) {
      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
    } else {
      return ctx.stylize('[Object]', 'special');
    }
  }

  ctx.seen.push(value);

  var output;
  if (array) {
    output = formatArray(ctx, value, recurseTimes, visibleKeys, keys);
  } else {
    output = keys.map(function(key) {
      return formatProperty(ctx, value, recurseTimes, visibleKeys, key, array);
    });
  }

  ctx.seen.pop();

  return reduceToSingleString(output, base, braces);
}


function formatPrimitive(ctx, value) {
  if (isUndefined(value))
    return ctx.stylize('undefined', 'undefined');
  if (isString(value)) {
    var simple = '\'' + JSON.stringify(value).replace(/^"|"$/g, '')
                                             .replace(/'/g, "\\'")
                                             .replace(/\\"/g, '"') + '\'';
    return ctx.stylize(simple, 'string');
  }
  if (isNumber(value))
    return ctx.stylize('' + value, 'number');
  if (isBoolean(value))
    return ctx.stylize('' + value, 'boolean');
  // For some reason typeof null is "object", so special case here.
  if (isNull(value))
    return ctx.stylize('null', 'null');
}


function formatError(value) {
  return '[' + Error.prototype.toString.call(value) + ']';
}


function formatArray(ctx, value, recurseTimes, visibleKeys, keys) {
  var output = [];
  for (var i = 0, l = value.length; i < l; ++i) {
    if (hasOwnProperty(value, String(i))) {
      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
          String(i), true));
    } else {
      output.push('');
    }
  }
  keys.forEach(function(key) {
    if (!key.match(/^\d+$/)) {
      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
          key, true));
    }
  });
  return output;
}


function formatProperty(ctx, value, recurseTimes, visibleKeys, key, array) {
  var name, str, desc;
  desc = Object.getOwnPropertyDescriptor(value, key) || { value: value[key] };
  if (desc.get) {
    if (desc.set) {
      str = ctx.stylize('[Getter/Setter]', 'special');
    } else {
      str = ctx.stylize('[Getter]', 'special');
    }
  } else {
    if (desc.set) {
      str = ctx.stylize('[Setter]', 'special');
    }
  }
  if (!hasOwnProperty(visibleKeys, key)) {
    name = '[' + key + ']';
  }
  if (!str) {
    if (ctx.seen.indexOf(desc.value) < 0) {
      if (isNull(recurseTimes)) {
        str = formatValue(ctx, desc.value, null);
      } else {
        str = formatValue(ctx, desc.value, recurseTimes - 1);
      }
      if (str.indexOf('\n') > -1) {
        if (array) {
          str = str.split('\n').map(function(line) {
            return '  ' + line;
          }).join('\n').substr(2);
        } else {
          str = '\n' + str.split('\n').map(function(line) {
            return '   ' + line;
          }).join('\n');
        }
      }
    } else {
      str = ctx.stylize('[Circular]', 'special');
    }
  }
  if (isUndefined(name)) {
    if (array && key.match(/^\d+$/)) {
      return str;
    }
    name = JSON.stringify('' + key);
    if (name.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)) {
      name = name.substr(1, name.length - 2);
      name = ctx.stylize(name, 'name');
    } else {
      name = name.replace(/'/g, "\\'")
                 .replace(/\\"/g, '"')
                 .replace(/(^"|"$)/g, "'");
      name = ctx.stylize(name, 'string');
    }
  }

  return name + ': ' + str;
}


function reduceToSingleString(output, base, braces) {
  var numLinesEst = 0;
  var length = output.reduce(function(prev, cur) {
    numLinesEst++;
    if (cur.indexOf('\n') >= 0) numLinesEst++;
    return prev + cur.replace(/\u001b\[\d\d?m/g, '').length + 1;
  }, 0);

  if (length > 60) {
    return braces[0] +
           (base === '' ? '' : base + '\n ') +
           ' ' +
           output.join(',\n  ') +
           ' ' +
           braces[1];
  }

  return braces[0] + base + ' ' + output.join(', ') + ' ' + braces[1];
}


// NOTE: These type checking functions intentionally don't use `instanceof`
// because it is fragile and can be easily faked with `Object.create()`.
function isArray(ar) {
  return Array.isArray(ar);
}
exports.isArray = isArray;

function isBoolean(arg) {
  return typeof arg === 'boolean';
}
exports.isBoolean = isBoolean;

function isNull(arg) {
  return arg === null;
}
exports.isNull = isNull;

function isNullOrUndefined(arg) {
  return arg == null;
}
exports.isNullOrUndefined = isNullOrUndefined;

function isNumber(arg) {
  return typeof arg === 'number';
}
exports.isNumber = isNumber;

function isString(arg) {
  return typeof arg === 'string';
}
exports.isString = isString;

function isSymbol(arg) {
  return typeof arg === 'symbol';
}
exports.isSymbol = isSymbol;

function isUndefined(arg) {
  return arg === void 0;
}
exports.isUndefined = isUndefined;

function isRegExp(re) {
  return isObject(re) && objectToString(re) === '[object RegExp]';
}
exports.isRegExp = isRegExp;

function isObject(arg) {
  return typeof arg === 'object' && arg !== null;
}
exports.isObject = isObject;

function isDate(d) {
  return isObject(d) && objectToString(d) === '[object Date]';
}
exports.isDate = isDate;

function isError(e) {
  return isObject(e) &&
      (objectToString(e) === '[object Error]' || e instanceof Error);
}
exports.isError = isError;

function isFunction(arg) {
  return typeof arg === 'function';
}
exports.isFunction = isFunction;

function isPrimitive(arg) {
  return arg === null ||
         typeof arg === 'boolean' ||
         typeof arg === 'number' ||
         typeof arg === 'string' ||
         typeof arg === 'symbol' ||  // ES6 symbol
         typeof arg === 'undefined';
}
exports.isPrimitive = isPrimitive;

exports.isBuffer = require('./support/isBuffer');

function objectToString(o) {
  return Object.prototype.toString.call(o);
}


function pad(n) {
  return n < 10 ? '0' + n.toString(10) : n.toString(10);
}


var months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
              'Oct', 'Nov', 'Dec'];

// 26 Feb 16:19:34
function timestamp() {
  var d = new Date();
  var time = [pad(d.getHours()),
              pad(d.getMinutes()),
              pad(d.getSeconds())].join(':');
  return [d.getDate(), months[d.getMonth()], time].join(' ');
}


// log is just a thin wrapper to console.log that prepends a timestamp
exports.log = function() {
  console.log('%s - %s', timestamp(), exports.format.apply(exports, arguments));
};


/**
 * Inherit the prototype methods from one constructor into another.
 *
 * The Function.prototype.inherits from lang.js rewritten as a standalone
 * function (not on Function.prototype). NOTE: If this file is to be loaded
 * during bootstrapping this function needs to be rewritten using some native
 * functions as prototype setup using normal JavaScript does not work as
 * expected during bootstrapping (see mirror.js in r114903).
 *
 * @param {function} ctor Constructor function which needs to inherit the
 *     prototype.
 * @param {function} superCtor Constructor function to inherit prototype from.
 */
exports.inherits = require('inherits');

exports._extend = function(origin, add) {
  // Don't do anything if add isn't an object
  if (!add || !isObject(add)) return origin;

  var keys = Object.keys(add);
  var i = keys.length;
  while (i--) {
    origin[keys[i]] = add[keys[i]];
  }
  return origin;
};

function hasOwnProperty(obj, prop) {
  return Object.prototype.hasOwnProperty.call(obj, prop);
}

},{"./support/isBuffer":89,"inherits":88}],91:[function(require,module,exports){
/*!

 diff v7.0.0

BSD 3-Clause License

Copyright (c) 2009-2015, Kevin Decker <kpdecker@gmail.com>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its
   contributors may be used to endorse or promote products derived from
   this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

@license
*/
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
  typeof define === 'function' && define.amd ? define(['exports'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.Diff = {}));
})(this, (function (exports) { 'use strict';

  function Diff() {}
  Diff.prototype = {
    diff: function diff(oldString, newString) {
      var _options$timeout;
      var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      var callback = options.callback;
      if (typeof options === 'function') {
        callback = options;
        options = {};
      }
      var self = this;
      function done(value) {
        value = self.postProcess(value, options);
        if (callback) {
          setTimeout(function () {
            callback(value);
          }, 0);
          return true;
        } else {
          return value;
        }
      }

      // Allow subclasses to massage the input prior to running
      oldString = this.castInput(oldString, options);
      newString = this.castInput(newString, options);
      oldString = this.removeEmpty(this.tokenize(oldString, options));
      newString = this.removeEmpty(this.tokenize(newString, options));
      var newLen = newString.length,
        oldLen = oldString.length;
      var editLength = 1;
      var maxEditLength = newLen + oldLen;
      if (options.maxEditLength != null) {
        maxEditLength = Math.min(maxEditLength, options.maxEditLength);
      }
      var maxExecutionTime = (_options$timeout = options.timeout) !== null && _options$timeout !== void 0 ? _options$timeout : Infinity;
      var abortAfterTimestamp = Date.now() + maxExecutionTime;
      var bestPath = [{
        oldPos: -1,
        lastComponent: undefined
      }];

      // Seed editLength = 0, i.e. the content starts with the same values
      var newPos = this.extractCommon(bestPath[0], newString, oldString, 0, options);
      if (bestPath[0].oldPos + 1 >= oldLen && newPos + 1 >= newLen) {
        // Identity per the equality and tokenizer
        return done(buildValues(self, bestPath[0].lastComponent, newString, oldString, self.useLongestToken));
      }

      // Once we hit the right edge of the edit graph on some diagonal k, we can
      // definitely reach the end of the edit graph in no more than k edits, so
      // there's no point in considering any moves to diagonal k+1 any more (from
      // which we're guaranteed to need at least k+1 more edits).
      // Similarly, once we've reached the bottom of the edit graph, there's no
      // point considering moves to lower diagonals.
      // We record this fact by setting minDiagonalToConsider and
      // maxDiagonalToConsider to some finite value once we've hit the edge of
      // the edit graph.
      // This optimization is not faithful to the original algorithm presented in
      // Myers's paper, which instead pointlessly extends D-paths off the end of
      // the edit graph - see page 7 of Myers's paper which notes this point
      // explicitly and illustrates it with a diagram. This has major performance
      // implications for some common scenarios. For instance, to compute a diff
      // where the new text simply appends d characters on the end of the
      // original text of length n, the true Myers algorithm will take O(n+d^2)
      // time while this optimization needs only O(n+d) time.
      var minDiagonalToConsider = -Infinity,
        maxDiagonalToConsider = Infinity;

      // Main worker method. checks all permutations of a given edit length for acceptance.
      function execEditLength() {
        for (var diagonalPath = Math.max(minDiagonalToConsider, -editLength); diagonalPath <= Math.min(maxDiagonalToConsider, editLength); diagonalPath += 2) {
          var basePath = void 0;
          var removePath = bestPath[diagonalPath - 1],
            addPath = bestPath[diagonalPath + 1];
          if (removePath) {
            // No one else is going to attempt to use this value, clear it
            bestPath[diagonalPath - 1] = undefined;
          }
          var canAdd = false;
          if (addPath) {
            // what newPos will be after we do an insertion:
            var addPathNewPos = addPath.oldPos - diagonalPath;
            canAdd = addPath && 0 <= addPathNewPos && addPathNewPos < newLen;
          }
          var canRemove = removePath && removePath.oldPos + 1 < oldLen;
          if (!canAdd && !canRemove) {
            // If this path is a terminal then prune
            bestPath[diagonalPath] = undefined;
            continue;
          }

          // Select the diagonal that we want to branch from. We select the prior
          // path whose position in the old string is the farthest from the origin
          // and does not pass the bounds of the diff graph
          if (!canRemove || canAdd && removePath.oldPos < addPath.oldPos) {
            basePath = self.addToPath(addPath, true, false, 0, options);
          } else {
            basePath = self.addToPath(removePath, false, true, 1, options);
          }
          newPos = self.extractCommon(basePath, newString, oldString, diagonalPath, options);
          if (basePath.oldPos + 1 >= oldLen && newPos + 1 >= newLen) {
            // If we have hit the end of both strings, then we are done
            return done(buildValues(self, basePath.lastComponent, newString, oldString, self.useLongestToken));
          } else {
            bestPath[diagonalPath] = basePath;
            if (basePath.oldPos + 1 >= oldLen) {
              maxDiagonalToConsider = Math.min(maxDiagonalToConsider, diagonalPath - 1);
            }
            if (newPos + 1 >= newLen) {
              minDiagonalToConsider = Math.max(minDiagonalToConsider, diagonalPath + 1);
            }
          }
        }
        editLength++;
      }

      // Performs the length of edit iteration. Is a bit fugly as this has to support the
      // sync and async mode which is never fun. Loops over execEditLength until a value
      // is produced, or until the edit length exceeds options.maxEditLength (if given),
      // in which case it will return undefined.
      if (callback) {
        (function exec() {
          setTimeout(function () {
            if (editLength > maxEditLength || Date.now() > abortAfterTimestamp) {
              return callback();
            }
            if (!execEditLength()) {
              exec();
            }
          }, 0);
        })();
      } else {
        while (editLength <= maxEditLength && Date.now() <= abortAfterTimestamp) {
          var ret = execEditLength();
          if (ret) {
            return ret;
          }
        }
      }
    },
    addToPath: function addToPath(path, added, removed, oldPosInc, options) {
      var last = path.lastComponent;
      if (last && !options.oneChangePerToken && last.added === added && last.removed === removed) {
        return {
          oldPos: path.oldPos + oldPosInc,
          lastComponent: {
            count: last.count + 1,
            added: added,
            removed: removed,
            previousComponent: last.previousComponent
          }
        };
      } else {
        return {
          oldPos: path.oldPos + oldPosInc,
          lastComponent: {
            count: 1,
            added: added,
            removed: removed,
            previousComponent: last
          }
        };
      }
    },
    extractCommon: function extractCommon(basePath, newString, oldString, diagonalPath, options) {
      var newLen = newString.length,
        oldLen = oldString.length,
        oldPos = basePath.oldPos,
        newPos = oldPos - diagonalPath,
        commonCount = 0;
      while (newPos + 1 < newLen && oldPos + 1 < oldLen && this.equals(oldString[oldPos + 1], newString[newPos + 1], options)) {
        newPos++;
        oldPos++;
        commonCount++;
        if (options.oneChangePerToken) {
          basePath.lastComponent = {
            count: 1,
            previousComponent: basePath.lastComponent,
            added: false,
            removed: false
          };
        }
      }
      if (commonCount && !options.oneChangePerToken) {
        basePath.lastComponent = {
          count: commonCount,
          previousComponent: basePath.lastComponent,
          added: false,
          removed: false
        };
      }
      basePath.oldPos = oldPos;
      return newPos;
    },
    equals: function equals(left, right, options) {
      if (options.comparator) {
        return options.comparator(left, right);
      } else {
        return left === right || options.ignoreCase && left.toLowerCase() === right.toLowerCase();
      }
    },
    removeEmpty: function removeEmpty(array) {
      var ret = [];
      for (var i = 0; i < array.length; i++) {
        if (array[i]) {
          ret.push(array[i]);
        }
      }
      return ret;
    },
    castInput: function castInput(value) {
      return value;
    },
    tokenize: function tokenize(value) {
      return Array.from(value);
    },
    join: function join(chars) {
      return chars.join('');
    },
    postProcess: function postProcess(changeObjects) {
      return changeObjects;
    }
  };
  function buildValues(diff, lastComponent, newString, oldString, useLongestToken) {
    // First we convert our linked list of components in reverse order to an
    // array in the right order:
    var components = [];
    var nextComponent;
    while (lastComponent) {
      components.push(lastComponent);
      nextComponent = lastComponent.previousComponent;
      delete lastComponent.previousComponent;
      lastComponent = nextComponent;
    }
    components.reverse();
    var componentPos = 0,
      componentLen = components.length,
      newPos = 0,
      oldPos = 0;
    for (; componentPos < componentLen; componentPos++) {
      var component = components[componentPos];
      if (!component.removed) {
        if (!component.added && useLongestToken) {
          var value = newString.slice(newPos, newPos + component.count);
          value = value.map(function (value, i) {
            var oldValue = oldString[oldPos + i];
            return oldValue.length > value.length ? oldValue : value;
          });
          component.value = diff.join(value);
        } else {
          component.value = diff.join(newString.slice(newPos, newPos + component.count));
        }
        newPos += component.count;

        // Common case
        if (!component.added) {
          oldPos += component.count;
        }
      } else {
        component.value = diff.join(oldString.slice(oldPos, oldPos + component.count));
        oldPos += component.count;
      }
    }
    return components;
  }

  var characterDiff = new Diff();
  function diffChars(oldStr, newStr, options) {
    return characterDiff.diff(oldStr, newStr, options);
  }

  function longestCommonPrefix(str1, str2) {
    var i;
    for (i = 0; i < str1.length && i < str2.length; i++) {
      if (str1[i] != str2[i]) {
        return str1.slice(0, i);
      }
    }
    return str1.slice(0, i);
  }
  function longestCommonSuffix(str1, str2) {
    var i;

    // Unlike longestCommonPrefix, we need a special case to handle all scenarios
    // where we return the empty string since str1.slice(-0) will return the
    // entire string.
    if (!str1 || !str2 || str1[str1.length - 1] != str2[str2.length - 1]) {
      return '';
    }
    for (i = 0; i < str1.length && i < str2.length; i++) {
      if (str1[str1.length - (i + 1)] != str2[str2.length - (i + 1)]) {
        return str1.slice(-i);
      }
    }
    return str1.slice(-i);
  }
  function replacePrefix(string, oldPrefix, newPrefix) {
    if (string.slice(0, oldPrefix.length) != oldPrefix) {
      throw Error("string ".concat(JSON.stringify(string), " doesn't start with prefix ").concat(JSON.stringify(oldPrefix), "; this is a bug"));
    }
    return newPrefix + string.slice(oldPrefix.length);
  }
  function replaceSuffix(string, oldSuffix, newSuffix) {
    if (!oldSuffix) {
      return string + newSuffix;
    }
    if (string.slice(-oldSuffix.length) != oldSuffix) {
      throw Error("string ".concat(JSON.stringify(string), " doesn't end with suffix ").concat(JSON.stringify(oldSuffix), "; this is a bug"));
    }
    return string.slice(0, -oldSuffix.length) + newSuffix;
  }
  function removePrefix(string, oldPrefix) {
    return replacePrefix(string, oldPrefix, '');
  }
  function removeSuffix(string, oldSuffix) {
    return replaceSuffix(string, oldSuffix, '');
  }
  function maximumOverlap(string1, string2) {
    return string2.slice(0, overlapCount(string1, string2));
  }

  // Nicked from https://stackoverflow.com/a/60422853/1709587
  function overlapCount(a, b) {
    // Deal with cases where the strings differ in length
    var startA = 0;
    if (a.length > b.length) {
      startA = a.length - b.length;
    }
    var endB = b.length;
    if (a.length < b.length) {
      endB = a.length;
    }
    // Create a back-reference for each index
    //   that should be followed in case of a mismatch.
    //   We only need B to make these references:
    var map = Array(endB);
    var k = 0; // Index that lags behind j
    map[0] = 0;
    for (var j = 1; j < endB; j++) {
      if (b[j] == b[k]) {
        map[j] = map[k]; // skip over the same character (optional optimisation)
      } else {
        map[j] = k;
      }
      while (k > 0 && b[j] != b[k]) {
        k = map[k];
      }
      if (b[j] == b[k]) {
        k++;
      }
    }
    // Phase 2: use these references while iterating over A
    k = 0;
    for (var i = startA; i < a.length; i++) {
      while (k > 0 && a[i] != b[k]) {
        k = map[k];
      }
      if (a[i] == b[k]) {
        k++;
      }
    }
    return k;
  }

  /**
   * Returns true if the string consistently uses Windows line endings.
   */
  function hasOnlyWinLineEndings(string) {
    return string.includes('\r\n') && !string.startsWith('\n') && !string.match(/[^\r]\n/);
  }

  /**
   * Returns true if the string consistently uses Unix line endings.
   */
  function hasOnlyUnixLineEndings(string) {
    return !string.includes('\r\n') && string.includes('\n');
  }

  // Based on https://en.wikipedia.org/wiki/Latin_script_in_Unicode
  //
  // Ranges and exceptions:
  // Latin-1 Supplement, 0080–00FF
  //  - U+00D7  × Multiplication sign
  //  - U+00F7  ÷ Division sign
  // Latin Extended-A, 0100–017F
  // Latin Extended-B, 0180–024F
  // IPA Extensions, 0250–02AF
  // Spacing Modifier Letters, 02B0–02FF
  //  - U+02C7  ˇ &#711;  Caron
  //  - U+02D8  ˘ &#728;  Breve
  //  - U+02D9  ˙ &#729;  Dot Above
  //  - U+02DA  ˚ &#730;  Ring Above
  //  - U+02DB  ˛ &#731;  Ogonek
  //  - U+02DC  ˜ &#732;  Small Tilde
  //  - U+02DD  ˝ &#733;  Double Acute Accent
  // Latin Extended Additional, 1E00–1EFF
  var extendedWordChars = "a-zA-Z0-9_\\u{C0}-\\u{FF}\\u{D8}-\\u{F6}\\u{F8}-\\u{2C6}\\u{2C8}-\\u{2D7}\\u{2DE}-\\u{2FF}\\u{1E00}-\\u{1EFF}";

  // Each token is one of the following:
  // - A punctuation mark plus the surrounding whitespace
  // - A word plus the surrounding whitespace
  // - Pure whitespace (but only in the special case where this the entire text
  //   is just whitespace)
  //
  // We have to include surrounding whitespace in the tokens because the two
  // alternative approaches produce horribly broken results:
  // * If we just discard the whitespace, we can't fully reproduce the original
  //   text from the sequence of tokens and any attempt to render the diff will
  //   get the whitespace wrong.
  // * If we have separate tokens for whitespace, then in a typical text every
  //   second token will be a single space character. But this often results in
  //   the optimal diff between two texts being a perverse one that preserves
  //   the spaces between words but deletes and reinserts actual common words.
  //   See https://github.com/kpdecker/jsdiff/issues/160#issuecomment-1866099640
  //   for an example.
  //
  // Keeping the surrounding whitespace of course has implications for .equals
  // and .join, not just .tokenize.

  // This regex does NOT fully implement the tokenization rules described above.
  // Instead, it gives runs of whitespace their own "token". The tokenize method
  // then handles stitching whitespace tokens onto adjacent word or punctuation
  // tokens.
  var tokenizeIncludingWhitespace = new RegExp("[".concat(extendedWordChars, "]+|\\s+|[^").concat(extendedWordChars, "]"), 'ug');
  var wordDiff = new Diff();
  wordDiff.equals = function (left, right, options) {
    if (options.ignoreCase) {
      left = left.toLowerCase();
      right = right.toLowerCase();
    }
    return left.trim() === right.trim();
  };
  wordDiff.tokenize = function (value) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var parts;
    if (options.intlSegmenter) {
      if (options.intlSegmenter.resolvedOptions().granularity != 'word') {
        throw new Error('The segmenter passed must have a granularity of "word"');
      }
      parts = Array.from(options.intlSegmenter.segment(value), function (segment) {
        return segment.segment;
      });
    } else {
      parts = value.match(tokenizeIncludingWhitespace) || [];
    }
    var tokens = [];
    var prevPart = null;
    parts.forEach(function (part) {
      if (/\s/.test(part)) {
        if (prevPart == null) {
          tokens.push(part);
        } else {
          tokens.push(tokens.pop() + part);
        }
      } else if (/\s/.test(prevPart)) {
        if (tokens[tokens.length - 1] == prevPart) {
          tokens.push(tokens.pop() + part);
        } else {
          tokens.push(prevPart + part);
        }
      } else {
        tokens.push(part);
      }
      prevPart = part;
    });
    return tokens;
  };
  wordDiff.join = function (tokens) {
    // Tokens being joined here will always have appeared consecutively in the
    // same text, so we can simply strip off the leading whitespace from all the
    // tokens except the first (and except any whitespace-only tokens - but such
    // a token will always be the first and only token anyway) and then join them
    // and the whitespace around words and punctuation will end up correct.
    return tokens.map(function (token, i) {
      if (i == 0) {
        return token;
      } else {
        return token.replace(/^\s+/, '');
      }
    }).join('');
  };
  wordDiff.postProcess = function (changes, options) {
    if (!changes || options.oneChangePerToken) {
      return changes;
    }
    var lastKeep = null;
    // Change objects representing any insertion or deletion since the last
    // "keep" change object. There can be at most one of each.
    var insertion = null;
    var deletion = null;
    changes.forEach(function (change) {
      if (change.added) {
        insertion = change;
      } else if (change.removed) {
        deletion = change;
      } else {
        if (insertion || deletion) {
          // May be false at start of text
          dedupeWhitespaceInChangeObjects(lastKeep, deletion, insertion, change);
        }
        lastKeep = change;
        insertion = null;
        deletion = null;
      }
    });
    if (insertion || deletion) {
      dedupeWhitespaceInChangeObjects(lastKeep, deletion, insertion, null);
    }
    return changes;
  };
  function diffWords(oldStr, newStr, options) {
    // This option has never been documented and never will be (it's clearer to
    // just call `diffWordsWithSpace` directly if you need that behavior), but
    // has existed in jsdiff for a long time, so we retain support for it here
    // for the sake of backwards compatibility.
    if ((options === null || options === void 0 ? void 0 : options.ignoreWhitespace) != null && !options.ignoreWhitespace) {
      return diffWordsWithSpace(oldStr, newStr, options);
    }
    return wordDiff.diff(oldStr, newStr, options);
  }
  function dedupeWhitespaceInChangeObjects(startKeep, deletion, insertion, endKeep) {
    // Before returning, we tidy up the leading and trailing whitespace of the
    // change objects to eliminate cases where trailing whitespace in one object
    // is repeated as leading whitespace in the next.
    // Below are examples of the outcomes we want here to explain the code.
    // I=insert, K=keep, D=delete
    // 1. diffing 'foo bar baz' vs 'foo baz'
    //    Prior to cleanup, we have K:'foo ' D:' bar ' K:' baz'
    //    After cleanup, we want:   K:'foo ' D:'bar ' K:'baz'
    //
    // 2. Diffing 'foo bar baz' vs 'foo qux baz'
    //    Prior to cleanup, we have K:'foo ' D:' bar ' I:' qux ' K:' baz'
    //    After cleanup, we want K:'foo ' D:'bar' I:'qux' K:' baz'
    //
    // 3. Diffing 'foo\nbar baz' vs 'foo baz'
    //    Prior to cleanup, we have K:'foo ' D:'\nbar ' K:' baz'
    //    After cleanup, we want K'foo' D:'\nbar' K:' baz'
    //
    // 4. Diffing 'foo baz' vs 'foo\nbar baz'
    //    Prior to cleanup, we have K:'foo\n' I:'\nbar ' K:' baz'
    //    After cleanup, we ideally want K'foo' I:'\nbar' K:' baz'
    //    but don't actually manage this currently (the pre-cleanup change
    //    objects don't contain enough information to make it possible).
    //
    // 5. Diffing 'foo   bar baz' vs 'foo  baz'
    //    Prior to cleanup, we have K:'foo  ' D:'   bar ' K:'  baz'
    //    After cleanup, we want K:'foo  ' D:' bar ' K:'baz'
    //
    // Our handling is unavoidably imperfect in the case where there's a single
    // indel between keeps and the whitespace has changed. For instance, consider
    // diffing 'foo\tbar\nbaz' vs 'foo baz'. Unless we create an extra change
    // object to represent the insertion of the space character (which isn't even
    // a token), we have no way to avoid losing information about the texts'
    // original whitespace in the result we return. Still, we do our best to
    // output something that will look sensible if we e.g. print it with
    // insertions in green and deletions in red.

    // Between two "keep" change objects (or before the first or after the last
    // change object), we can have either:
    // * A "delete" followed by an "insert"
    // * Just an "insert"
    // * Just a "delete"
    // We handle the three cases separately.
    if (deletion && insertion) {
      var oldWsPrefix = deletion.value.match(/^\s*/)[0];
      var oldWsSuffix = deletion.value.match(/\s*$/)[0];
      var newWsPrefix = insertion.value.match(/^\s*/)[0];
      var newWsSuffix = insertion.value.match(/\s*$/)[0];
      if (startKeep) {
        var commonWsPrefix = longestCommonPrefix(oldWsPrefix, newWsPrefix);
        startKeep.value = replaceSuffix(startKeep.value, newWsPrefix, commonWsPrefix);
        deletion.value = removePrefix(deletion.value, commonWsPrefix);
        insertion.value = removePrefix(insertion.value, commonWsPrefix);
      }
      if (endKeep) {
        var commonWsSuffix = longestCommonSuffix(oldWsSuffix, newWsSuffix);
        endKeep.value = replacePrefix(endKeep.value, newWsSuffix, commonWsSuffix);
        deletion.value = removeSuffix(deletion.value, commonWsSuffix);
        insertion.value = removeSuffix(insertion.value, commonWsSuffix);
      }
    } else if (insertion) {
      // The whitespaces all reflect what was in the new text rather than
      // the old, so we essentially have no information about whitespace
      // insertion or deletion. We just want to dedupe the whitespace.
      // We do that by having each change object keep its trailing
      // whitespace and deleting duplicate leading whitespace where
      // present.
      if (startKeep) {
        insertion.value = insertion.value.replace(/^\s*/, '');
      }
      if (endKeep) {
        endKeep.value = endKeep.value.replace(/^\s*/, '');
      }
      // otherwise we've got a deletion and no insertion
    } else if (startKeep && endKeep) {
      var newWsFull = endKeep.value.match(/^\s*/)[0],
        delWsStart = deletion.value.match(/^\s*/)[0],
        delWsEnd = deletion.value.match(/\s*$/)[0];

      // Any whitespace that comes straight after startKeep in both the old and
      // new texts, assign to startKeep and remove from the deletion.
      var newWsStart = longestCommonPrefix(newWsFull, delWsStart);
      deletion.value = removePrefix(deletion.value, newWsStart);

      // Any whitespace that comes straight before endKeep in both the old and
      // new texts, and hasn't already been assigned to startKeep, assign to
      // endKeep and remove from the deletion.
      var newWsEnd = longestCommonSuffix(removePrefix(newWsFull, newWsStart), delWsEnd);
      deletion.value = removeSuffix(deletion.value, newWsEnd);
      endKeep.value = replacePrefix(endKeep.value, newWsFull, newWsEnd);

      // If there's any whitespace from the new text that HASN'T already been
      // assigned, assign it to the start:
      startKeep.value = replaceSuffix(startKeep.value, newWsFull, newWsFull.slice(0, newWsFull.length - newWsEnd.length));
    } else if (endKeep) {
      // We are at the start of the text. Preserve all the whitespace on
      // endKeep, and just remove whitespace from the end of deletion to the
      // extent that it overlaps with the start of endKeep.
      var endKeepWsPrefix = endKeep.value.match(/^\s*/)[0];
      var deletionWsSuffix = deletion.value.match(/\s*$/)[0];
      var overlap = maximumOverlap(deletionWsSuffix, endKeepWsPrefix);
      deletion.value = removeSuffix(deletion.value, overlap);
    } else if (startKeep) {
      // We are at the END of the text. Preserve all the whitespace on
      // startKeep, and just remove whitespace from the start of deletion to
      // the extent that it overlaps with the end of startKeep.
      var startKeepWsSuffix = startKeep.value.match(/\s*$/)[0];
      var deletionWsPrefix = deletion.value.match(/^\s*/)[0];
      var _overlap = maximumOverlap(startKeepWsSuffix, deletionWsPrefix);
      deletion.value = removePrefix(deletion.value, _overlap);
    }
  }
  var wordWithSpaceDiff = new Diff();
  wordWithSpaceDiff.tokenize = function (value) {
    // Slightly different to the tokenizeIncludingWhitespace regex used above in
    // that this one treats each individual newline as a distinct tokens, rather
    // than merging them into other surrounding whitespace. This was requested
    // in https://github.com/kpdecker/jsdiff/issues/180 &
    //    https://github.com/kpdecker/jsdiff/issues/211
    var regex = new RegExp("(\\r?\\n)|[".concat(extendedWordChars, "]+|[^\\S\\n\\r]+|[^").concat(extendedWordChars, "]"), 'ug');
    return value.match(regex) || [];
  };
  function diffWordsWithSpace(oldStr, newStr, options) {
    return wordWithSpaceDiff.diff(oldStr, newStr, options);
  }

  function generateOptions(options, defaults) {
    if (typeof options === 'function') {
      defaults.callback = options;
    } else if (options) {
      for (var name in options) {
        /* istanbul ignore else */
        if (options.hasOwnProperty(name)) {
          defaults[name] = options[name];
        }
      }
    }
    return defaults;
  }

  var lineDiff = new Diff();
  lineDiff.tokenize = function (value, options) {
    if (options.stripTrailingCr) {
      // remove one \r before \n to match GNU diff's --strip-trailing-cr behavior
      value = value.replace(/\r\n/g, '\n');
    }
    var retLines = [],
      linesAndNewlines = value.split(/(\n|\r\n)/);

    // Ignore the final empty token that occurs if the string ends with a new line
    if (!linesAndNewlines[linesAndNewlines.length - 1]) {
      linesAndNewlines.pop();
    }

    // Merge the content and line separators into single tokens
    for (var i = 0; i < linesAndNewlines.length; i++) {
      var line = linesAndNewlines[i];
      if (i % 2 && !options.newlineIsToken) {
        retLines[retLines.length - 1] += line;
      } else {
        retLines.push(line);
      }
    }
    return retLines;
  };
  lineDiff.equals = function (left, right, options) {
    // If we're ignoring whitespace, we need to normalise lines by stripping
    // whitespace before checking equality. (This has an annoying interaction
    // with newlineIsToken that requires special handling: if newlines get their
    // own token, then we DON'T want to trim the *newline* tokens down to empty
    // strings, since this would cause us to treat whitespace-only line content
    // as equal to a separator between lines, which would be weird and
    // inconsistent with the documented behavior of the options.)
    if (options.ignoreWhitespace) {
      if (!options.newlineIsToken || !left.includes('\n')) {
        left = left.trim();
      }
      if (!options.newlineIsToken || !right.includes('\n')) {
        right = right.trim();
      }
    } else if (options.ignoreNewlineAtEof && !options.newlineIsToken) {
      if (left.endsWith('\n')) {
        left = left.slice(0, -1);
      }
      if (right.endsWith('\n')) {
        right = right.slice(0, -1);
      }
    }
    return Diff.prototype.equals.call(this, left, right, options);
  };
  function diffLines(oldStr, newStr, callback) {
    return lineDiff.diff(oldStr, newStr, callback);
  }

  // Kept for backwards compatibility. This is a rather arbitrary wrapper method
  // that just calls `diffLines` with `ignoreWhitespace: true`. It's confusing to
  // have two ways to do exactly the same thing in the API, so we no longer
  // document this one (library users should explicitly use `diffLines` with
  // `ignoreWhitespace: true` instead) but we keep it around to maintain
  // compatibility with code that used old versions.
  function diffTrimmedLines(oldStr, newStr, callback) {
    var options = generateOptions(callback, {
      ignoreWhitespace: true
    });
    return lineDiff.diff(oldStr, newStr, options);
  }

  var sentenceDiff = new Diff();
  sentenceDiff.tokenize = function (value) {
    return value.split(/(\S.+?[.!?])(?=\s+|$)/);
  };
  function diffSentences(oldStr, newStr, callback) {
    return sentenceDiff.diff(oldStr, newStr, callback);
  }

  var cssDiff = new Diff();
  cssDiff.tokenize = function (value) {
    return value.split(/([{}:;,]|\s+)/);
  };
  function diffCss(oldStr, newStr, callback) {
    return cssDiff.diff(oldStr, newStr, callback);
  }

  function ownKeys(e, r) {
    var t = Object.keys(e);
    if (Object.getOwnPropertySymbols) {
      var o = Object.getOwnPropertySymbols(e);
      r && (o = o.filter(function (r) {
        return Object.getOwnPropertyDescriptor(e, r).enumerable;
      })), t.push.apply(t, o);
    }
    return t;
  }
  function _objectSpread2(e) {
    for (var r = 1; r < arguments.length; r++) {
      var t = null != arguments[r] ? arguments[r] : {};
      r % 2 ? ownKeys(Object(t), !0).forEach(function (r) {
        _defineProperty(e, r, t[r]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) {
        Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r));
      });
    }
    return e;
  }
  function _toPrimitive(t, r) {
    if ("object" != typeof t || !t) return t;
    var e = t[Symbol.toPrimitive];
    if (void 0 !== e) {
      var i = e.call(t, r || "default");
      if ("object" != typeof i) return i;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return ("string" === r ? String : Number)(t);
  }
  function _toPropertyKey(t) {
    var i = _toPrimitive(t, "string");
    return "symbol" == typeof i ? i : i + "";
  }
  function _typeof(o) {
    "@babel/helpers - typeof";

    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) {
      return typeof o;
    } : function (o) {
      return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o;
    }, _typeof(o);
  }
  function _defineProperty(obj, key, value) {
    key = _toPropertyKey(key);
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }
    return obj;
  }
  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
  }
  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) return _arrayLikeToArray(arr);
  }
  function _iterableToArray(iter) {
    if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
  }
  function _unsupportedIterableToArray(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
  }
  function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) len = arr.length;
    for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];
    return arr2;
  }
  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  var jsonDiff = new Diff();
  // Discriminate between two lines of pretty-printed, serialized JSON where one of them has a
  // dangling comma and the other doesn't. Turns out including the dangling comma yields the nicest output:
  jsonDiff.useLongestToken = true;
  jsonDiff.tokenize = lineDiff.tokenize;
  jsonDiff.castInput = function (value, options) {
    var undefinedReplacement = options.undefinedReplacement,
      _options$stringifyRep = options.stringifyReplacer,
      stringifyReplacer = _options$stringifyRep === void 0 ? function (k, v) {
        return typeof v === 'undefined' ? undefinedReplacement : v;
      } : _options$stringifyRep;
    return typeof value === 'string' ? value : JSON.stringify(canonicalize(value, null, null, stringifyReplacer), stringifyReplacer, '  ');
  };
  jsonDiff.equals = function (left, right, options) {
    return Diff.prototype.equals.call(jsonDiff, left.replace(/,([\r\n])/g, '$1'), right.replace(/,([\r\n])/g, '$1'), options);
  };
  function diffJson(oldObj, newObj, options) {
    return jsonDiff.diff(oldObj, newObj, options);
  }

  // This function handles the presence of circular references by bailing out when encountering an
  // object that is already on the "stack" of items being processed. Accepts an optional replacer
  function canonicalize(obj, stack, replacementStack, replacer, key) {
    stack = stack || [];
    replacementStack = replacementStack || [];
    if (replacer) {
      obj = replacer(key, obj);
    }
    var i;
    for (i = 0; i < stack.length; i += 1) {
      if (stack[i] === obj) {
        return replacementStack[i];
      }
    }
    var canonicalizedObj;
    if ('[object Array]' === Object.prototype.toString.call(obj)) {
      stack.push(obj);
      canonicalizedObj = new Array(obj.length);
      replacementStack.push(canonicalizedObj);
      for (i = 0; i < obj.length; i += 1) {
        canonicalizedObj[i] = canonicalize(obj[i], stack, replacementStack, replacer, key);
      }
      stack.pop();
      replacementStack.pop();
      return canonicalizedObj;
    }
    if (obj && obj.toJSON) {
      obj = obj.toJSON();
    }
    if (_typeof(obj) === 'object' && obj !== null) {
      stack.push(obj);
      canonicalizedObj = {};
      replacementStack.push(canonicalizedObj);
      var sortedKeys = [],
        _key;
      for (_key in obj) {
        /* istanbul ignore else */
        if (Object.prototype.hasOwnProperty.call(obj, _key)) {
          sortedKeys.push(_key);
        }
      }
      sortedKeys.sort();
      for (i = 0; i < sortedKeys.length; i += 1) {
        _key = sortedKeys[i];
        canonicalizedObj[_key] = canonicalize(obj[_key], stack, replacementStack, replacer, _key);
      }
      stack.pop();
      replacementStack.pop();
    } else {
      canonicalizedObj = obj;
    }
    return canonicalizedObj;
  }

  var arrayDiff = new Diff();
  arrayDiff.tokenize = function (value) {
    return value.slice();
  };
  arrayDiff.join = arrayDiff.removeEmpty = function (value) {
    return value;
  };
  function diffArrays(oldArr, newArr, callback) {
    return arrayDiff.diff(oldArr, newArr, callback);
  }

  function unixToWin(patch) {
    if (Array.isArray(patch)) {
      return patch.map(unixToWin);
    }
    return _objectSpread2(_objectSpread2({}, patch), {}, {
      hunks: patch.hunks.map(function (hunk) {
        return _objectSpread2(_objectSpread2({}, hunk), {}, {
          lines: hunk.lines.map(function (line, i) {
            var _hunk$lines;
            return line.startsWith('\\') || line.endsWith('\r') || (_hunk$lines = hunk.lines[i + 1]) !== null && _hunk$lines !== void 0 && _hunk$lines.startsWith('\\') ? line : line + '\r';
          })
        });
      })
    });
  }
  function winToUnix(patch) {
    if (Array.isArray(patch)) {
      return patch.map(winToUnix);
    }
    return _objectSpread2(_objectSpread2({}, patch), {}, {
      hunks: patch.hunks.map(function (hunk) {
        return _objectSpread2(_objectSpread2({}, hunk), {}, {
          lines: hunk.lines.map(function (line) {
            return line.endsWith('\r') ? line.substring(0, line.length - 1) : line;
          })
        });
      })
    });
  }

  /**
   * Returns true if the patch consistently uses Unix line endings (or only involves one line and has
   * no line endings).
   */
  function isUnix(patch) {
    if (!Array.isArray(patch)) {
      patch = [patch];
    }
    return !patch.some(function (index) {
      return index.hunks.some(function (hunk) {
        return hunk.lines.some(function (line) {
          return !line.startsWith('\\') && line.endsWith('\r');
        });
      });
    });
  }

  /**
   * Returns true if the patch uses Windows line endings and only Windows line endings.
   */
  function isWin(patch) {
    if (!Array.isArray(patch)) {
      patch = [patch];
    }
    return patch.some(function (index) {
      return index.hunks.some(function (hunk) {
        return hunk.lines.some(function (line) {
          return line.endsWith('\r');
        });
      });
    }) && patch.every(function (index) {
      return index.hunks.every(function (hunk) {
        return hunk.lines.every(function (line, i) {
          var _hunk$lines2;
          return line.startsWith('\\') || line.endsWith('\r') || ((_hunk$lines2 = hunk.lines[i + 1]) === null || _hunk$lines2 === void 0 ? void 0 : _hunk$lines2.startsWith('\\'));
        });
      });
    });
  }

  function parsePatch(uniDiff) {
    var diffstr = uniDiff.split(/\n/),
      list = [],
      i = 0;
    function parseIndex() {
      var index = {};
      list.push(index);

      // Parse diff metadata
      while (i < diffstr.length) {
        var line = diffstr[i];

        // File header found, end parsing diff metadata
        if (/^(\-\-\-|\+\+\+|@@)\s/.test(line)) {
          break;
        }

        // Diff index
        var header = /^(?:Index:|diff(?: -r \w+)+)\s+(.+?)\s*$/.exec(line);
        if (header) {
          index.index = header[1];
        }
        i++;
      }

      // Parse file headers if they are defined. Unified diff requires them, but
      // there's no technical issues to have an isolated hunk without file header
      parseFileHeader(index);
      parseFileHeader(index);

      // Parse hunks
      index.hunks = [];
      while (i < diffstr.length) {
        var _line = diffstr[i];
        if (/^(Index:\s|diff\s|\-\-\-\s|\+\+\+\s|===================================================================)/.test(_line)) {
          break;
        } else if (/^@@/.test(_line)) {
          index.hunks.push(parseHunk());
        } else if (_line) {
          throw new Error('Unknown line ' + (i + 1) + ' ' + JSON.stringify(_line));
        } else {
          i++;
        }
      }
    }

    // Parses the --- and +++ headers, if none are found, no lines
    // are consumed.
    function parseFileHeader(index) {
      var fileHeader = /^(---|\+\+\+)\s+(.*)\r?$/.exec(diffstr[i]);
      if (fileHeader) {
        var keyPrefix = fileHeader[1] === '---' ? 'old' : 'new';
        var data = fileHeader[2].split('\t', 2);
        var fileName = data[0].replace(/\\\\/g, '\\');
        if (/^".*"$/.test(fileName)) {
          fileName = fileName.substr(1, fileName.length - 2);
        }
        index[keyPrefix + 'FileName'] = fileName;
        index[keyPrefix + 'Header'] = (data[1] || '').trim();
        i++;
      }
    }

    // Parses a hunk
    // This assumes that we are at the start of a hunk.
    function parseHunk() {
      var chunkHeaderIndex = i,
        chunkHeaderLine = diffstr[i++],
        chunkHeader = chunkHeaderLine.split(/@@ -(\d+)(?:,(\d+))? \+(\d+)(?:,(\d+))? @@/);
      var hunk = {
        oldStart: +chunkHeader[1],
        oldLines: typeof chunkHeader[2] === 'undefined' ? 1 : +chunkHeader[2],
        newStart: +chunkHeader[3],
        newLines: typeof chunkHeader[4] === 'undefined' ? 1 : +chunkHeader[4],
        lines: []
      };

      // Unified Diff Format quirk: If the chunk size is 0,
      // the first number is one lower than one would expect.
      // https://www.artima.com/weblogs/viewpost.jsp?thread=164293
      if (hunk.oldLines === 0) {
        hunk.oldStart += 1;
      }
      if (hunk.newLines === 0) {
        hunk.newStart += 1;
      }
      var addCount = 0,
        removeCount = 0;
      for (; i < diffstr.length && (removeCount < hunk.oldLines || addCount < hunk.newLines || (_diffstr$i = diffstr[i]) !== null && _diffstr$i !== void 0 && _diffstr$i.startsWith('\\')); i++) {
        var _diffstr$i;
        var operation = diffstr[i].length == 0 && i != diffstr.length - 1 ? ' ' : diffstr[i][0];
        if (operation === '+' || operation === '-' || operation === ' ' || operation === '\\') {
          hunk.lines.push(diffstr[i]);
          if (operation === '+') {
            addCount++;
          } else if (operation === '-') {
            removeCount++;
          } else if (operation === ' ') {
            addCount++;
            removeCount++;
          }
        } else {
          throw new Error("Hunk at line ".concat(chunkHeaderIndex + 1, " contained invalid line ").concat(diffstr[i]));
        }
      }

      // Handle the empty block count case
      if (!addCount && hunk.newLines === 1) {
        hunk.newLines = 0;
      }
      if (!removeCount && hunk.oldLines === 1) {
        hunk.oldLines = 0;
      }

      // Perform sanity checking
      if (addCount !== hunk.newLines) {
        throw new Error('Added line count did not match for hunk at line ' + (chunkHeaderIndex + 1));
      }
      if (removeCount !== hunk.oldLines) {
        throw new Error('Removed line count did not match for hunk at line ' + (chunkHeaderIndex + 1));
      }
      return hunk;
    }
    while (i < diffstr.length) {
      parseIndex();
    }
    return list;
  }

  // Iterator that traverses in the range of [min, max], stepping
  // by distance from a given start position. I.e. for [0, 4], with
  // start of 2, this will iterate 2, 3, 1, 4, 0.
  function distanceIterator (start, minLine, maxLine) {
    var wantForward = true,
      backwardExhausted = false,
      forwardExhausted = false,
      localOffset = 1;
    return function iterator() {
      if (wantForward && !forwardExhausted) {
        if (backwardExhausted) {
          localOffset++;
        } else {
          wantForward = false;
        }

        // Check if trying to fit beyond text length, and if not, check it fits
        // after offset location (or desired location on first iteration)
        if (start + localOffset <= maxLine) {
          return start + localOffset;
        }
        forwardExhausted = true;
      }
      if (!backwardExhausted) {
        if (!forwardExhausted) {
          wantForward = true;
        }

        // Check if trying to fit before text beginning, and if not, check it fits
        // before offset location
        if (minLine <= start - localOffset) {
          return start - localOffset++;
        }
        backwardExhausted = true;
        return iterator();
      }

      // We tried to fit hunk before text beginning and beyond text length, then
      // hunk can't fit on the text. Return undefined
    };
  }

  function applyPatch(source, uniDiff) {
    var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    if (typeof uniDiff === 'string') {
      uniDiff = parsePatch(uniDiff);
    }
    if (Array.isArray(uniDiff)) {
      if (uniDiff.length > 1) {
        throw new Error('applyPatch only works with a single input.');
      }
      uniDiff = uniDiff[0];
    }
    if (options.autoConvertLineEndings || options.autoConvertLineEndings == null) {
      if (hasOnlyWinLineEndings(source) && isUnix(uniDiff)) {
        uniDiff = unixToWin(uniDiff);
      } else if (hasOnlyUnixLineEndings(source) && isWin(uniDiff)) {
        uniDiff = winToUnix(uniDiff);
      }
    }

    // Apply the diff to the input
    var lines = source.split('\n'),
      hunks = uniDiff.hunks,
      compareLine = options.compareLine || function (lineNumber, line, operation, patchContent) {
        return line === patchContent;
      },
      fuzzFactor = options.fuzzFactor || 0,
      minLine = 0;
    if (fuzzFactor < 0 || !Number.isInteger(fuzzFactor)) {
      throw new Error('fuzzFactor must be a non-negative integer');
    }

    // Special case for empty patch.
    if (!hunks.length) {
      return source;
    }

    // Before anything else, handle EOFNL insertion/removal. If the patch tells us to make a change
    // to the EOFNL that is redundant/impossible - i.e. to remove a newline that's not there, or add a
    // newline that already exists - then we either return false and fail to apply the patch (if
    // fuzzFactor is 0) or simply ignore the problem and do nothing (if fuzzFactor is >0).
    // If we do need to remove/add a newline at EOF, this will always be in the final hunk:
    var prevLine = '',
      removeEOFNL = false,
      addEOFNL = false;
    for (var i = 0; i < hunks[hunks.length - 1].lines.length; i++) {
      var line = hunks[hunks.length - 1].lines[i];
      if (line[0] == '\\') {
        if (prevLine[0] == '+') {
          removeEOFNL = true;
        } else if (prevLine[0] == '-') {
          addEOFNL = true;
        }
      }
      prevLine = line;
    }
    if (removeEOFNL) {
      if (addEOFNL) {
        // This means the final line gets changed but doesn't have a trailing newline in either the
        // original or patched version. In that case, we do nothing if fuzzFactor > 0, and if
        // fuzzFactor is 0, we simply validate that the source file has no trailing newline.
        if (!fuzzFactor && lines[lines.length - 1] == '') {
          return false;
        }
      } else if (lines[lines.length - 1] == '') {
        lines.pop();
      } else if (!fuzzFactor) {
        return false;
      }
    } else if (addEOFNL) {
      if (lines[lines.length - 1] != '') {
        lines.push('');
      } else if (!fuzzFactor) {
        return false;
      }
    }

    /**
     * Checks if the hunk can be made to fit at the provided location with at most `maxErrors`
     * insertions, substitutions, or deletions, while ensuring also that:
     * - lines deleted in the hunk match exactly, and
     * - wherever an insertion operation or block of insertion operations appears in the hunk, the
     *   immediately preceding and following lines of context match exactly
     *
     * `toPos` should be set such that lines[toPos] is meant to match hunkLines[0].
     *
     * If the hunk can be applied, returns an object with properties `oldLineLastI` and
     * `replacementLines`. Otherwise, returns null.
     */
    function applyHunk(hunkLines, toPos, maxErrors) {
      var hunkLinesI = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
      var lastContextLineMatched = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : true;
      var patchedLines = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : [];
      var patchedLinesLength = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : 0;
      var nConsecutiveOldContextLines = 0;
      var nextContextLineMustMatch = false;
      for (; hunkLinesI < hunkLines.length; hunkLinesI++) {
        var hunkLine = hunkLines[hunkLinesI],
          operation = hunkLine.length > 0 ? hunkLine[0] : ' ',
          content = hunkLine.length > 0 ? hunkLine.substr(1) : hunkLine;
        if (operation === '-') {
          if (compareLine(toPos + 1, lines[toPos], operation, content)) {
            toPos++;
            nConsecutiveOldContextLines = 0;
          } else {
            if (!maxErrors || lines[toPos] == null) {
              return null;
            }
            patchedLines[patchedLinesLength] = lines[toPos];
            return applyHunk(hunkLines, toPos + 1, maxErrors - 1, hunkLinesI, false, patchedLines, patchedLinesLength + 1);
          }
        }
        if (operation === '+') {
          if (!lastContextLineMatched) {
            return null;
          }
          patchedLines[patchedLinesLength] = content;
          patchedLinesLength++;
          nConsecutiveOldContextLines = 0;
          nextContextLineMustMatch = true;
        }
        if (operation === ' ') {
          nConsecutiveOldContextLines++;
          patchedLines[patchedLinesLength] = lines[toPos];
          if (compareLine(toPos + 1, lines[toPos], operation, content)) {
            patchedLinesLength++;
            lastContextLineMatched = true;
            nextContextLineMustMatch = false;
            toPos++;
          } else {
            if (nextContextLineMustMatch || !maxErrors) {
              return null;
            }

            // Consider 3 possibilities in sequence:
            // 1. lines contains a *substitution* not included in the patch context, or
            // 2. lines contains an *insertion* not included in the patch context, or
            // 3. lines contains a *deletion* not included in the patch context
            // The first two options are of course only possible if the line from lines is non-null -
            // i.e. only option 3 is possible if we've overrun the end of the old file.
            return lines[toPos] && (applyHunk(hunkLines, toPos + 1, maxErrors - 1, hunkLinesI + 1, false, patchedLines, patchedLinesLength + 1) || applyHunk(hunkLines, toPos + 1, maxErrors - 1, hunkLinesI, false, patchedLines, patchedLinesLength + 1)) || applyHunk(hunkLines, toPos, maxErrors - 1, hunkLinesI + 1, false, patchedLines, patchedLinesLength);
          }
        }
      }

      // Before returning, trim any unmodified context lines off the end of patchedLines and reduce
      // toPos (and thus oldLineLastI) accordingly. This allows later hunks to be applied to a region
      // that starts in this hunk's trailing context.
      patchedLinesLength -= nConsecutiveOldContextLines;
      toPos -= nConsecutiveOldContextLines;
      patchedLines.length = patchedLinesLength;
      return {
        patchedLines: patchedLines,
        oldLineLastI: toPos - 1
      };
    }
    var resultLines = [];

    // Search best fit offsets for each hunk based on the previous ones
    var prevHunkOffset = 0;
    for (var _i = 0; _i < hunks.length; _i++) {
      var hunk = hunks[_i];
      var hunkResult = void 0;
      var maxLine = lines.length - hunk.oldLines + fuzzFactor;
      var toPos = void 0;
      for (var maxErrors = 0; maxErrors <= fuzzFactor; maxErrors++) {
        toPos = hunk.oldStart + prevHunkOffset - 1;
        var iterator = distanceIterator(toPos, minLine, maxLine);
        for (; toPos !== undefined; toPos = iterator()) {
          hunkResult = applyHunk(hunk.lines, toPos, maxErrors);
          if (hunkResult) {
            break;
          }
        }
        if (hunkResult) {
          break;
        }
      }
      if (!hunkResult) {
        return false;
      }

      // Copy everything from the end of where we applied the last hunk to the start of this hunk
      for (var _i2 = minLine; _i2 < toPos; _i2++) {
        resultLines.push(lines[_i2]);
      }

      // Add the lines produced by applying the hunk:
      for (var _i3 = 0; _i3 < hunkResult.patchedLines.length; _i3++) {
        var _line = hunkResult.patchedLines[_i3];
        resultLines.push(_line);
      }

      // Set lower text limit to end of the current hunk, so next ones don't try
      // to fit over already patched text
      minLine = hunkResult.oldLineLastI + 1;

      // Note the offset between where the patch said the hunk should've applied and where we
      // applied it, so we can adjust future hunks accordingly:
      prevHunkOffset = toPos + 1 - hunk.oldStart;
    }

    // Copy over the rest of the lines from the old text
    for (var _i4 = minLine; _i4 < lines.length; _i4++) {
      resultLines.push(lines[_i4]);
    }
    return resultLines.join('\n');
  }

  // Wrapper that supports multiple file patches via callbacks.
  function applyPatches(uniDiff, options) {
    if (typeof uniDiff === 'string') {
      uniDiff = parsePatch(uniDiff);
    }
    var currentIndex = 0;
    function processIndex() {
      var index = uniDiff[currentIndex++];
      if (!index) {
        return options.complete();
      }
      options.loadFile(index, function (err, data) {
        if (err) {
          return options.complete(err);
        }
        var updatedContent = applyPatch(data, index, options);
        options.patched(index, updatedContent, function (err) {
          if (err) {
            return options.complete(err);
          }
          processIndex();
        });
      });
    }
    processIndex();
  }

  function structuredPatch(oldFileName, newFileName, oldStr, newStr, oldHeader, newHeader, options) {
    if (!options) {
      options = {};
    }
    if (typeof options === 'function') {
      options = {
        callback: options
      };
    }
    if (typeof options.context === 'undefined') {
      options.context = 4;
    }
    if (options.newlineIsToken) {
      throw new Error('newlineIsToken may not be used with patch-generation functions, only with diffing functions');
    }
    if (!options.callback) {
      return diffLinesResultToPatch(diffLines(oldStr, newStr, options));
    } else {
      var _options = options,
        _callback = _options.callback;
      diffLines(oldStr, newStr, _objectSpread2(_objectSpread2({}, options), {}, {
        callback: function callback(diff) {
          var patch = diffLinesResultToPatch(diff);
          _callback(patch);
        }
      }));
    }
    function diffLinesResultToPatch(diff) {
      // STEP 1: Build up the patch with no "\ No newline at end of file" lines and with the arrays
      //         of lines containing trailing newline characters. We'll tidy up later...

      if (!diff) {
        return;
      }
      diff.push({
        value: '',
        lines: []
      }); // Append an empty value to make cleanup easier

      function contextLines(lines) {
        return lines.map(function (entry) {
          return ' ' + entry;
        });
      }
      var hunks = [];
      var oldRangeStart = 0,
        newRangeStart = 0,
        curRange = [],
        oldLine = 1,
        newLine = 1;
      var _loop = function _loop() {
        var current = diff[i],
          lines = current.lines || splitLines(current.value);
        current.lines = lines;
        if (current.added || current.removed) {
          var _curRange;
          // If we have previous context, start with that
          if (!oldRangeStart) {
            var prev = diff[i - 1];
            oldRangeStart = oldLine;
            newRangeStart = newLine;
            if (prev) {
              curRange = options.context > 0 ? contextLines(prev.lines.slice(-options.context)) : [];
              oldRangeStart -= curRange.length;
              newRangeStart -= curRange.length;
            }
          }

          // Output our changes
          (_curRange = curRange).push.apply(_curRange, _toConsumableArray(lines.map(function (entry) {
            return (current.added ? '+' : '-') + entry;
          })));

          // Track the updated file position
          if (current.added) {
            newLine += lines.length;
          } else {
            oldLine += lines.length;
          }
        } else {
          // Identical context lines. Track line changes
          if (oldRangeStart) {
            // Close out any changes that have been output (or join overlapping)
            if (lines.length <= options.context * 2 && i < diff.length - 2) {
              var _curRange2;
              // Overlapping
              (_curRange2 = curRange).push.apply(_curRange2, _toConsumableArray(contextLines(lines)));
            } else {
              var _curRange3;
              // end the range and output
              var contextSize = Math.min(lines.length, options.context);
              (_curRange3 = curRange).push.apply(_curRange3, _toConsumableArray(contextLines(lines.slice(0, contextSize))));
              var _hunk = {
                oldStart: oldRangeStart,
                oldLines: oldLine - oldRangeStart + contextSize,
                newStart: newRangeStart,
                newLines: newLine - newRangeStart + contextSize,
                lines: curRange
              };
              hunks.push(_hunk);
              oldRangeStart = 0;
              newRangeStart = 0;
              curRange = [];
            }
          }
          oldLine += lines.length;
          newLine += lines.length;
        }
      };
      for (var i = 0; i < diff.length; i++) {
        _loop();
      }

      // Step 2: eliminate the trailing `\n` from each line of each hunk, and, where needed, add
      //         "\ No newline at end of file".
      for (var _i = 0, _hunks = hunks; _i < _hunks.length; _i++) {
        var hunk = _hunks[_i];
        for (var _i2 = 0; _i2 < hunk.lines.length; _i2++) {
          if (hunk.lines[_i2].endsWith('\n')) {
            hunk.lines[_i2] = hunk.lines[_i2].slice(0, -1);
          } else {
            hunk.lines.splice(_i2 + 1, 0, '\\ No newline at end of file');
            _i2++; // Skip the line we just added, then continue iterating
          }
        }
      }
      return {
        oldFileName: oldFileName,
        newFileName: newFileName,
        oldHeader: oldHeader,
        newHeader: newHeader,
        hunks: hunks
      };
    }
  }
  function formatPatch(diff) {
    if (Array.isArray(diff)) {
      return diff.map(formatPatch).join('\n');
    }
    var ret = [];
    if (diff.oldFileName == diff.newFileName) {
      ret.push('Index: ' + diff.oldFileName);
    }
    ret.push('===================================================================');
    ret.push('--- ' + diff.oldFileName + (typeof diff.oldHeader === 'undefined' ? '' : '\t' + diff.oldHeader));
    ret.push('+++ ' + diff.newFileName + (typeof diff.newHeader === 'undefined' ? '' : '\t' + diff.newHeader));
    for (var i = 0; i < diff.hunks.length; i++) {
      var hunk = diff.hunks[i];
      // Unified Diff Format quirk: If the chunk size is 0,
      // the first number is one lower than one would expect.
      // https://www.artima.com/weblogs/viewpost.jsp?thread=164293
      if (hunk.oldLines === 0) {
        hunk.oldStart -= 1;
      }
      if (hunk.newLines === 0) {
        hunk.newStart -= 1;
      }
      ret.push('@@ -' + hunk.oldStart + ',' + hunk.oldLines + ' +' + hunk.newStart + ',' + hunk.newLines + ' @@');
      ret.push.apply(ret, hunk.lines);
    }
    return ret.join('\n') + '\n';
  }
  function createTwoFilesPatch(oldFileName, newFileName, oldStr, newStr, oldHeader, newHeader, options) {
    var _options2;
    if (typeof options === 'function') {
      options = {
        callback: options
      };
    }
    if (!((_options2 = options) !== null && _options2 !== void 0 && _options2.callback)) {
      var patchObj = structuredPatch(oldFileName, newFileName, oldStr, newStr, oldHeader, newHeader, options);
      if (!patchObj) {
        return;
      }
      return formatPatch(patchObj);
    } else {
      var _options3 = options,
        _callback2 = _options3.callback;
      structuredPatch(oldFileName, newFileName, oldStr, newStr, oldHeader, newHeader, _objectSpread2(_objectSpread2({}, options), {}, {
        callback: function callback(patchObj) {
          if (!patchObj) {
            _callback2();
          } else {
            _callback2(formatPatch(patchObj));
          }
        }
      }));
    }
  }
  function createPatch(fileName, oldStr, newStr, oldHeader, newHeader, options) {
    return createTwoFilesPatch(fileName, fileName, oldStr, newStr, oldHeader, newHeader, options);
  }

  /**
   * Split `text` into an array of lines, including the trailing newline character (where present)
   */
  function splitLines(text) {
    var hasTrailingNl = text.endsWith('\n');
    var result = text.split('\n').map(function (line) {
      return line + '\n';
    });
    if (hasTrailingNl) {
      result.pop();
    } else {
      result.push(result.pop().slice(0, -1));
    }
    return result;
  }

  function arrayEqual(a, b) {
    if (a.length !== b.length) {
      return false;
    }
    return arrayStartsWith(a, b);
  }
  function arrayStartsWith(array, start) {
    if (start.length > array.length) {
      return false;
    }
    for (var i = 0; i < start.length; i++) {
      if (start[i] !== array[i]) {
        return false;
      }
    }
    return true;
  }

  function calcLineCount(hunk) {
    var _calcOldNewLineCount = calcOldNewLineCount(hunk.lines),
      oldLines = _calcOldNewLineCount.oldLines,
      newLines = _calcOldNewLineCount.newLines;
    if (oldLines !== undefined) {
      hunk.oldLines = oldLines;
    } else {
      delete hunk.oldLines;
    }
    if (newLines !== undefined) {
      hunk.newLines = newLines;
    } else {
      delete hunk.newLines;
    }
  }
  function merge(mine, theirs, base) {
    mine = loadPatch(mine, base);
    theirs = loadPatch(theirs, base);
    var ret = {};

    // For index we just let it pass through as it doesn't have any necessary meaning.
    // Leaving sanity checks on this to the API consumer that may know more about the
    // meaning in their own context.
    if (mine.index || theirs.index) {
      ret.index = mine.index || theirs.index;
    }
    if (mine.newFileName || theirs.newFileName) {
      if (!fileNameChanged(mine)) {
        // No header or no change in ours, use theirs (and ours if theirs does not exist)
        ret.oldFileName = theirs.oldFileName || mine.oldFileName;
        ret.newFileName = theirs.newFileName || mine.newFileName;
        ret.oldHeader = theirs.oldHeader || mine.oldHeader;
        ret.newHeader = theirs.newHeader || mine.newHeader;
      } else if (!fileNameChanged(theirs)) {
        // No header or no change in theirs, use ours
        ret.oldFileName = mine.oldFileName;
        ret.newFileName = mine.newFileName;
        ret.oldHeader = mine.oldHeader;
        ret.newHeader = mine.newHeader;
      } else {
        // Both changed... figure it out
        ret.oldFileName = selectField(ret, mine.oldFileName, theirs.oldFileName);
        ret.newFileName = selectField(ret, mine.newFileName, theirs.newFileName);
        ret.oldHeader = selectField(ret, mine.oldHeader, theirs.oldHeader);
        ret.newHeader = selectField(ret, mine.newHeader, theirs.newHeader);
      }
    }
    ret.hunks = [];
    var mineIndex = 0,
      theirsIndex = 0,
      mineOffset = 0,
      theirsOffset = 0;
    while (mineIndex < mine.hunks.length || theirsIndex < theirs.hunks.length) {
      var mineCurrent = mine.hunks[mineIndex] || {
          oldStart: Infinity
        },
        theirsCurrent = theirs.hunks[theirsIndex] || {
          oldStart: Infinity
        };
      if (hunkBefore(mineCurrent, theirsCurrent)) {
        // This patch does not overlap with any of the others, yay.
        ret.hunks.push(cloneHunk(mineCurrent, mineOffset));
        mineIndex++;
        theirsOffset += mineCurrent.newLines - mineCurrent.oldLines;
      } else if (hunkBefore(theirsCurrent, mineCurrent)) {
        // This patch does not overlap with any of the others, yay.
        ret.hunks.push(cloneHunk(theirsCurrent, theirsOffset));
        theirsIndex++;
        mineOffset += theirsCurrent.newLines - theirsCurrent.oldLines;
      } else {
        // Overlap, merge as best we can
        var mergedHunk = {
          oldStart: Math.min(mineCurrent.oldStart, theirsCurrent.oldStart),
          oldLines: 0,
          newStart: Math.min(mineCurrent.newStart + mineOffset, theirsCurrent.oldStart + theirsOffset),
          newLines: 0,
          lines: []
        };
        mergeLines(mergedHunk, mineCurrent.oldStart, mineCurrent.lines, theirsCurrent.oldStart, theirsCurrent.lines);
        theirsIndex++;
        mineIndex++;
        ret.hunks.push(mergedHunk);
      }
    }
    return ret;
  }
  function loadPatch(param, base) {
    if (typeof param === 'string') {
      if (/^@@/m.test(param) || /^Index:/m.test(param)) {
        return parsePatch(param)[0];
      }
      if (!base) {
        throw new Error('Must provide a base reference or pass in a patch');
      }
      return structuredPatch(undefined, undefined, base, param);
    }
    return param;
  }
  function fileNameChanged(patch) {
    return patch.newFileName && patch.newFileName !== patch.oldFileName;
  }
  function selectField(index, mine, theirs) {
    if (mine === theirs) {
      return mine;
    } else {
      index.conflict = true;
      return {
        mine: mine,
        theirs: theirs
      };
    }
  }
  function hunkBefore(test, check) {
    return test.oldStart < check.oldStart && test.oldStart + test.oldLines < check.oldStart;
  }
  function cloneHunk(hunk, offset) {
    return {
      oldStart: hunk.oldStart,
      oldLines: hunk.oldLines,
      newStart: hunk.newStart + offset,
      newLines: hunk.newLines,
      lines: hunk.lines
    };
  }
  function mergeLines(hunk, mineOffset, mineLines, theirOffset, theirLines) {
    // This will generally result in a conflicted hunk, but there are cases where the context
    // is the only overlap where we can successfully merge the content here.
    var mine = {
        offset: mineOffset,
        lines: mineLines,
        index: 0
      },
      their = {
        offset: theirOffset,
        lines: theirLines,
        index: 0
      };

    // Handle any leading content
    insertLeading(hunk, mine, their);
    insertLeading(hunk, their, mine);

    // Now in the overlap content. Scan through and select the best changes from each.
    while (mine.index < mine.lines.length && their.index < their.lines.length) {
      var mineCurrent = mine.lines[mine.index],
        theirCurrent = their.lines[their.index];
      if ((mineCurrent[0] === '-' || mineCurrent[0] === '+') && (theirCurrent[0] === '-' || theirCurrent[0] === '+')) {
        // Both modified ...
        mutualChange(hunk, mine, their);
      } else if (mineCurrent[0] === '+' && theirCurrent[0] === ' ') {
        var _hunk$lines;
        // Mine inserted
        (_hunk$lines = hunk.lines).push.apply(_hunk$lines, _toConsumableArray(collectChange(mine)));
      } else if (theirCurrent[0] === '+' && mineCurrent[0] === ' ') {
        var _hunk$lines2;
        // Theirs inserted
        (_hunk$lines2 = hunk.lines).push.apply(_hunk$lines2, _toConsumableArray(collectChange(their)));
      } else if (mineCurrent[0] === '-' && theirCurrent[0] === ' ') {
        // Mine removed or edited
        removal(hunk, mine, their);
      } else if (theirCurrent[0] === '-' && mineCurrent[0] === ' ') {
        // Their removed or edited
        removal(hunk, their, mine, true);
      } else if (mineCurrent === theirCurrent) {
        // Context identity
        hunk.lines.push(mineCurrent);
        mine.index++;
        their.index++;
      } else {
        // Context mismatch
        conflict(hunk, collectChange(mine), collectChange(their));
      }
    }

    // Now push anything that may be remaining
    insertTrailing(hunk, mine);
    insertTrailing(hunk, their);
    calcLineCount(hunk);
  }
  function mutualChange(hunk, mine, their) {
    var myChanges = collectChange(mine),
      theirChanges = collectChange(their);
    if (allRemoves(myChanges) && allRemoves(theirChanges)) {
      // Special case for remove changes that are supersets of one another
      if (arrayStartsWith(myChanges, theirChanges) && skipRemoveSuperset(their, myChanges, myChanges.length - theirChanges.length)) {
        var _hunk$lines3;
        (_hunk$lines3 = hunk.lines).push.apply(_hunk$lines3, _toConsumableArray(myChanges));
        return;
      } else if (arrayStartsWith(theirChanges, myChanges) && skipRemoveSuperset(mine, theirChanges, theirChanges.length - myChanges.length)) {
        var _hunk$lines4;
        (_hunk$lines4 = hunk.lines).push.apply(_hunk$lines4, _toConsumableArray(theirChanges));
        return;
      }
    } else if (arrayEqual(myChanges, theirChanges)) {
      var _hunk$lines5;
      (_hunk$lines5 = hunk.lines).push.apply(_hunk$lines5, _toConsumableArray(myChanges));
      return;
    }
    conflict(hunk, myChanges, theirChanges);
  }
  function removal(hunk, mine, their, swap) {
    var myChanges = collectChange(mine),
      theirChanges = collectContext(their, myChanges);
    if (theirChanges.merged) {
      var _hunk$lines6;
      (_hunk$lines6 = hunk.lines).push.apply(_hunk$lines6, _toConsumableArray(theirChanges.merged));
    } else {
      conflict(hunk, swap ? theirChanges : myChanges, swap ? myChanges : theirChanges);
    }
  }
  function conflict(hunk, mine, their) {
    hunk.conflict = true;
    hunk.lines.push({
      conflict: true,
      mine: mine,
      theirs: their
    });
  }
  function insertLeading(hunk, insert, their) {
    while (insert.offset < their.offset && insert.index < insert.lines.length) {
      var line = insert.lines[insert.index++];
      hunk.lines.push(line);
      insert.offset++;
    }
  }
  function insertTrailing(hunk, insert) {
    while (insert.index < insert.lines.length) {
      var line = insert.lines[insert.index++];
      hunk.lines.push(line);
    }
  }
  function collectChange(state) {
    var ret = [],
      operation = state.lines[state.index][0];
    while (state.index < state.lines.length) {
      var line = state.lines[state.index];

      // Group additions that are immediately after subtractions and treat them as one "atomic" modify change.
      if (operation === '-' && line[0] === '+') {
        operation = '+';
      }
      if (operation === line[0]) {
        ret.push(line);
        state.index++;
      } else {
        break;
      }
    }
    return ret;
  }
  function collectContext(state, matchChanges) {
    var changes = [],
      merged = [],
      matchIndex = 0,
      contextChanges = false,
      conflicted = false;
    while (matchIndex < matchChanges.length && state.index < state.lines.length) {
      var change = state.lines[state.index],
        match = matchChanges[matchIndex];

      // Once we've hit our add, then we are done
      if (match[0] === '+') {
        break;
      }
      contextChanges = contextChanges || change[0] !== ' ';
      merged.push(match);
      matchIndex++;

      // Consume any additions in the other block as a conflict to attempt
      // to pull in the remaining context after this
      if (change[0] === '+') {
        conflicted = true;
        while (change[0] === '+') {
          changes.push(change);
          change = state.lines[++state.index];
        }
      }
      if (match.substr(1) === change.substr(1)) {
        changes.push(change);
        state.index++;
      } else {
        conflicted = true;
      }
    }
    if ((matchChanges[matchIndex] || '')[0] === '+' && contextChanges) {
      conflicted = true;
    }
    if (conflicted) {
      return changes;
    }
    while (matchIndex < matchChanges.length) {
      merged.push(matchChanges[matchIndex++]);
    }
    return {
      merged: merged,
      changes: changes
    };
  }
  function allRemoves(changes) {
    return changes.reduce(function (prev, change) {
      return prev && change[0] === '-';
    }, true);
  }
  function skipRemoveSuperset(state, removeChanges, delta) {
    for (var i = 0; i < delta; i++) {
      var changeContent = removeChanges[removeChanges.length - delta + i].substr(1);
      if (state.lines[state.index + i] !== ' ' + changeContent) {
        return false;
      }
    }
    state.index += delta;
    return true;
  }
  function calcOldNewLineCount(lines) {
    var oldLines = 0;
    var newLines = 0;
    lines.forEach(function (line) {
      if (typeof line !== 'string') {
        var myCount = calcOldNewLineCount(line.mine);
        var theirCount = calcOldNewLineCount(line.theirs);
        if (oldLines !== undefined) {
          if (myCount.oldLines === theirCount.oldLines) {
            oldLines += myCount.oldLines;
          } else {
            oldLines = undefined;
          }
        }
        if (newLines !== undefined) {
          if (myCount.newLines === theirCount.newLines) {
            newLines += myCount.newLines;
          } else {
            newLines = undefined;
          }
        }
      } else {
        if (newLines !== undefined && (line[0] === '+' || line[0] === ' ')) {
          newLines++;
        }
        if (oldLines !== undefined && (line[0] === '-' || line[0] === ' ')) {
          oldLines++;
        }
      }
    });
    return {
      oldLines: oldLines,
      newLines: newLines
    };
  }

  function reversePatch(structuredPatch) {
    if (Array.isArray(structuredPatch)) {
      return structuredPatch.map(reversePatch).reverse();
    }
    return _objectSpread2(_objectSpread2({}, structuredPatch), {}, {
      oldFileName: structuredPatch.newFileName,
      oldHeader: structuredPatch.newHeader,
      newFileName: structuredPatch.oldFileName,
      newHeader: structuredPatch.oldHeader,
      hunks: structuredPatch.hunks.map(function (hunk) {
        return {
          oldLines: hunk.newLines,
          oldStart: hunk.newStart,
          newLines: hunk.oldLines,
          newStart: hunk.oldStart,
          lines: hunk.lines.map(function (l) {
            if (l.startsWith('-')) {
              return "+".concat(l.slice(1));
            }
            if (l.startsWith('+')) {
              return "-".concat(l.slice(1));
            }
            return l;
          })
        };
      })
    });
  }

  // See: http://code.google.com/p/google-diff-match-patch/wiki/API
  function convertChangesToDMP(changes) {
    var ret = [],
      change,
      operation;
    for (var i = 0; i < changes.length; i++) {
      change = changes[i];
      if (change.added) {
        operation = 1;
      } else if (change.removed) {
        operation = -1;
      } else {
        operation = 0;
      }
      ret.push([operation, change.value]);
    }
    return ret;
  }

  function convertChangesToXML(changes) {
    var ret = [];
    for (var i = 0; i < changes.length; i++) {
      var change = changes[i];
      if (change.added) {
        ret.push('<ins>');
      } else if (change.removed) {
        ret.push('<del>');
      }
      ret.push(escapeHTML(change.value));
      if (change.added) {
        ret.push('</ins>');
      } else if (change.removed) {
        ret.push('</del>');
      }
    }
    return ret.join('');
  }
  function escapeHTML(s) {
    var n = s;
    n = n.replace(/&/g, '&amp;');
    n = n.replace(/</g, '&lt;');
    n = n.replace(/>/g, '&gt;');
    n = n.replace(/"/g, '&quot;');
    return n;
  }

  exports.Diff = Diff;
  exports.applyPatch = applyPatch;
  exports.applyPatches = applyPatches;
  exports.canonicalize = canonicalize;
  exports.convertChangesToDMP = convertChangesToDMP;
  exports.convertChangesToXML = convertChangesToXML;
  exports.createPatch = createPatch;
  exports.createTwoFilesPatch = createTwoFilesPatch;
  exports.diffArrays = diffArrays;
  exports.diffChars = diffChars;
  exports.diffCss = diffCss;
  exports.diffJson = diffJson;
  exports.diffLines = diffLines;
  exports.diffSentences = diffSentences;
  exports.diffTrimmedLines = diffTrimmedLines;
  exports.diffWords = diffWords;
  exports.diffWordsWithSpace = diffWordsWithSpace;
  exports.formatPatch = formatPatch;
  exports.merge = merge;
  exports.parsePatch = parsePatch;
  exports.reversePatch = reversePatch;
  exports.structuredPatch = structuredPatch;

}));

},{}],92:[function(require,module,exports){
/**
 * lodash (Custom Build) <https://lodash.com/>
 * Build: `lodash modularize exports="npm" -o ./`
 * Copyright jQuery Foundation and other contributors <https://jquery.org/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 */

/** Used as the `TypeError` message for "Functions" methods. */
var FUNC_ERROR_TEXT = 'Expected a function';

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0;

/** `Object#toString` result references. */
var funcTag = '[object Function]',
    genTag = '[object GeneratorFunction]',
    symbolTag = '[object Symbol]';

/** Used to match property names within property paths. */
var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,
    reIsPlainProp = /^\w*$/,
    reLeadingDot = /^\./,
    rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;

/**
 * Used to match `RegExp`
 * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
 */
var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

/** Used to match backslashes in property paths. */
var reEscapeChar = /\\(\\)?/g;

/** Used to detect host constructors (Safari). */
var reIsHostCtor = /^\[object .+?Constructor\]$/;

/** Detect free variable `global` from Node.js. */
var freeGlobal = typeof global == 'object' && global && global.Object === Object && global;

/** Detect free variable `self`. */
var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

/** Used as a reference to the global object. */
var root = freeGlobal || freeSelf || Function('return this')();

/**
 * Gets the value at `key` of `object`.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {string} key The key of the property to get.
 * @returns {*} Returns the property value.
 */
function getValue(object, key) {
  return object == null ? undefined : object[key];
}

/**
 * Checks if `value` is a host object in IE < 9.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a host object, else `false`.
 */
function isHostObject(value) {
  // Many host objects are `Object` objects that can coerce to strings
  // despite having improperly defined `toString` methods.
  var result = false;
  if (value != null && typeof value.toString != 'function') {
    try {
      result = !!(value + '');
    } catch (e) {}
  }
  return result;
}

/** Used for built-in method references. */
var arrayProto = Array.prototype,
    funcProto = Function.prototype,
    objectProto = Object.prototype;

/** Used to detect overreaching core-js shims. */
var coreJsData = root['__core-js_shared__'];

/** Used to detect methods masquerading as native. */
var maskSrcKey = (function() {
  var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
  return uid ? ('Symbol(src)_1.' + uid) : '';
}());

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var objectToString = objectProto.toString;

/** Used to detect if a method is native. */
var reIsNative = RegExp('^' +
  funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&')
  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
);

/** Built-in value references. */
var Symbol = root.Symbol,
    splice = arrayProto.splice;

/* Built-in method references that are verified to be native. */
var Map = getNative(root, 'Map'),
    nativeCreate = getNative(Object, 'create');

/** Used to convert symbols to primitives and strings. */
var symbolProto = Symbol ? Symbol.prototype : undefined,
    symbolToString = symbolProto ? symbolProto.toString : undefined;

/**
 * Creates a hash object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Hash(entries) {
  var index = -1,
      length = entries ? entries.length : 0;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

/**
 * Removes all key-value entries from the hash.
 *
 * @private
 * @name clear
 * @memberOf Hash
 */
function hashClear() {
  this.__data__ = nativeCreate ? nativeCreate(null) : {};
}

/**
 * Removes `key` and its value from the hash.
 *
 * @private
 * @name delete
 * @memberOf Hash
 * @param {Object} hash The hash to modify.
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function hashDelete(key) {
  return this.has(key) && delete this.__data__[key];
}

/**
 * Gets the hash value for `key`.
 *
 * @private
 * @name get
 * @memberOf Hash
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function hashGet(key) {
  var data = this.__data__;
  if (nativeCreate) {
    var result = data[key];
    return result === HASH_UNDEFINED ? undefined : result;
  }
  return hasOwnProperty.call(data, key) ? data[key] : undefined;
}

/**
 * Checks if a hash value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Hash
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function hashHas(key) {
  var data = this.__data__;
  return nativeCreate ? data[key] !== undefined : hasOwnProperty.call(data, key);
}

/**
 * Sets the hash `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Hash
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the hash instance.
 */
function hashSet(key, value) {
  var data = this.__data__;
  data[key] = (nativeCreate && value === undefined) ? HASH_UNDEFINED : value;
  return this;
}

// Add methods to `Hash`.
Hash.prototype.clear = hashClear;
Hash.prototype['delete'] = hashDelete;
Hash.prototype.get = hashGet;
Hash.prototype.has = hashHas;
Hash.prototype.set = hashSet;

/**
 * Creates an list cache object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function ListCache(entries) {
  var index = -1,
      length = entries ? entries.length : 0;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

/**
 * Removes all key-value entries from the list cache.
 *
 * @private
 * @name clear
 * @memberOf ListCache
 */
function listCacheClear() {
  this.__data__ = [];
}

/**
 * Removes `key` and its value from the list cache.
 *
 * @private
 * @name delete
 * @memberOf ListCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function listCacheDelete(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    return false;
  }
  var lastIndex = data.length - 1;
  if (index == lastIndex) {
    data.pop();
  } else {
    splice.call(data, index, 1);
  }
  return true;
}

/**
 * Gets the list cache value for `key`.
 *
 * @private
 * @name get
 * @memberOf ListCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function listCacheGet(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  return index < 0 ? undefined : data[index][1];
}

/**
 * Checks if a list cache value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf ListCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function listCacheHas(key) {
  return assocIndexOf(this.__data__, key) > -1;
}

/**
 * Sets the list cache `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf ListCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the list cache instance.
 */
function listCacheSet(key, value) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    data.push([key, value]);
  } else {
    data[index][1] = value;
  }
  return this;
}

// Add methods to `ListCache`.
ListCache.prototype.clear = listCacheClear;
ListCache.prototype['delete'] = listCacheDelete;
ListCache.prototype.get = listCacheGet;
ListCache.prototype.has = listCacheHas;
ListCache.prototype.set = listCacheSet;

/**
 * Creates a map cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function MapCache(entries) {
  var index = -1,
      length = entries ? entries.length : 0;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

/**
 * Removes all key-value entries from the map.
 *
 * @private
 * @name clear
 * @memberOf MapCache
 */
function mapCacheClear() {
  this.__data__ = {
    'hash': new Hash,
    'map': new (Map || ListCache),
    'string': new Hash
  };
}

/**
 * Removes `key` and its value from the map.
 *
 * @private
 * @name delete
 * @memberOf MapCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function mapCacheDelete(key) {
  return getMapData(this, key)['delete'](key);
}

/**
 * Gets the map value for `key`.
 *
 * @private
 * @name get
 * @memberOf MapCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function mapCacheGet(key) {
  return getMapData(this, key).get(key);
}

/**
 * Checks if a map value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf MapCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function mapCacheHas(key) {
  return getMapData(this, key).has(key);
}

/**
 * Sets the map `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf MapCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the map cache instance.
 */
function mapCacheSet(key, value) {
  getMapData(this, key).set(key, value);
  return this;
}

// Add methods to `MapCache`.
MapCache.prototype.clear = mapCacheClear;
MapCache.prototype['delete'] = mapCacheDelete;
MapCache.prototype.get = mapCacheGet;
MapCache.prototype.has = mapCacheHas;
MapCache.prototype.set = mapCacheSet;

/**
 * Gets the index at which the `key` is found in `array` of key-value pairs.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} key The key to search for.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function assocIndexOf(array, key) {
  var length = array.length;
  while (length--) {
    if (eq(array[length][0], key)) {
      return length;
    }
  }
  return -1;
}

/**
 * The base implementation of `_.get` without support for default values.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array|string} path The path of the property to get.
 * @returns {*} Returns the resolved value.
 */
function baseGet(object, path) {
  path = isKey(path, object) ? [path] : castPath(path);

  var index = 0,
      length = path.length;

  while (object != null && index < length) {
    object = object[toKey(path[index++])];
  }
  return (index && index == length) ? object : undefined;
}

/**
 * The base implementation of `_.isNative` without bad shim checks.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a native function,
 *  else `false`.
 */
function baseIsNative(value) {
  if (!isObject(value) || isMasked(value)) {
    return false;
  }
  var pattern = (isFunction(value) || isHostObject(value)) ? reIsNative : reIsHostCtor;
  return pattern.test(toSource(value));
}

/**
 * The base implementation of `_.toString` which doesn't convert nullish
 * values to empty strings.
 *
 * @private
 * @param {*} value The value to process.
 * @returns {string} Returns the string.
 */
function baseToString(value) {
  // Exit early for strings to avoid a performance hit in some environments.
  if (typeof value == 'string') {
    return value;
  }
  if (isSymbol(value)) {
    return symbolToString ? symbolToString.call(value) : '';
  }
  var result = (value + '');
  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
}

/**
 * Casts `value` to a path array if it's not one.
 *
 * @private
 * @param {*} value The value to inspect.
 * @returns {Array} Returns the cast property path array.
 */
function castPath(value) {
  return isArray(value) ? value : stringToPath(value);
}

/**
 * Gets the data for `map`.
 *
 * @private
 * @param {Object} map The map to query.
 * @param {string} key The reference key.
 * @returns {*} Returns the map data.
 */
function getMapData(map, key) {
  var data = map.__data__;
  return isKeyable(key)
    ? data[typeof key == 'string' ? 'string' : 'hash']
    : data.map;
}

/**
 * Gets the native function at `key` of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the method to get.
 * @returns {*} Returns the function if it's native, else `undefined`.
 */
function getNative(object, key) {
  var value = getValue(object, key);
  return baseIsNative(value) ? value : undefined;
}

/**
 * Checks if `value` is a property name and not a property path.
 *
 * @private
 * @param {*} value The value to check.
 * @param {Object} [object] The object to query keys on.
 * @returns {boolean} Returns `true` if `value` is a property name, else `false`.
 */
function isKey(value, object) {
  if (isArray(value)) {
    return false;
  }
  var type = typeof value;
  if (type == 'number' || type == 'symbol' || type == 'boolean' ||
      value == null || isSymbol(value)) {
    return true;
  }
  return reIsPlainProp.test(value) || !reIsDeepProp.test(value) ||
    (object != null && value in Object(object));
}

/**
 * Checks if `value` is suitable for use as unique object key.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
 */
function isKeyable(value) {
  var type = typeof value;
  return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
    ? (value !== '__proto__')
    : (value === null);
}

/**
 * Checks if `func` has its source masked.
 *
 * @private
 * @param {Function} func The function to check.
 * @returns {boolean} Returns `true` if `func` is masked, else `false`.
 */
function isMasked(func) {
  return !!maskSrcKey && (maskSrcKey in func);
}

/**
 * Converts `string` to a property path array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the property path array.
 */
var stringToPath = memoize(function(string) {
  string = toString(string);

  var result = [];
  if (reLeadingDot.test(string)) {
    result.push('');
  }
  string.replace(rePropName, function(match, number, quote, string) {
    result.push(quote ? string.replace(reEscapeChar, '$1') : (number || match));
  });
  return result;
});

/**
 * Converts `value` to a string key if it's not a string or symbol.
 *
 * @private
 * @param {*} value The value to inspect.
 * @returns {string|symbol} Returns the key.
 */
function toKey(value) {
  if (typeof value == 'string' || isSymbol(value)) {
    return value;
  }
  var result = (value + '');
  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
}

/**
 * Converts `func` to its source code.
 *
 * @private
 * @param {Function} func The function to process.
 * @returns {string} Returns the source code.
 */
function toSource(func) {
  if (func != null) {
    try {
      return funcToString.call(func);
    } catch (e) {}
    try {
      return (func + '');
    } catch (e) {}
  }
  return '';
}

/**
 * Creates a function that memoizes the result of `func`. If `resolver` is
 * provided, it determines the cache key for storing the result based on the
 * arguments provided to the memoized function. By default, the first argument
 * provided to the memoized function is used as the map cache key. The `func`
 * is invoked with the `this` binding of the memoized function.
 *
 * **Note:** The cache is exposed as the `cache` property on the memoized
 * function. Its creation may be customized by replacing the `_.memoize.Cache`
 * constructor with one whose instances implement the
 * [`Map`](http://ecma-international.org/ecma-262/7.0/#sec-properties-of-the-map-prototype-object)
 * method interface of `delete`, `get`, `has`, and `set`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Function
 * @param {Function} func The function to have its output memoized.
 * @param {Function} [resolver] The function to resolve the cache key.
 * @returns {Function} Returns the new memoized function.
 * @example
 *
 * var object = { 'a': 1, 'b': 2 };
 * var other = { 'c': 3, 'd': 4 };
 *
 * var values = _.memoize(_.values);
 * values(object);
 * // => [1, 2]
 *
 * values(other);
 * // => [3, 4]
 *
 * object.a = 2;
 * values(object);
 * // => [1, 2]
 *
 * // Modify the result cache.
 * values.cache.set(object, ['a', 'b']);
 * values(object);
 * // => ['a', 'b']
 *
 * // Replace `_.memoize.Cache`.
 * _.memoize.Cache = WeakMap;
 */
function memoize(func, resolver) {
  if (typeof func != 'function' || (resolver && typeof resolver != 'function')) {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  var memoized = function() {
    var args = arguments,
        key = resolver ? resolver.apply(this, args) : args[0],
        cache = memoized.cache;

    if (cache.has(key)) {
      return cache.get(key);
    }
    var result = func.apply(this, args);
    memoized.cache = cache.set(key, result);
    return result;
  };
  memoized.cache = new (memoize.Cache || MapCache);
  return memoized;
}

// Assign cache to `_.memoize`.
memoize.Cache = MapCache;

/**
 * Performs a
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * comparison between two values to determine if they are equivalent.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.eq(object, object);
 * // => true
 *
 * _.eq(object, other);
 * // => false
 *
 * _.eq('a', 'a');
 * // => true
 *
 * _.eq('a', Object('a'));
 * // => false
 *
 * _.eq(NaN, NaN);
 * // => true
 */
function eq(value, other) {
  return value === other || (value !== value && other !== other);
}

/**
 * Checks if `value` is classified as an `Array` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
 * @example
 *
 * _.isArray([1, 2, 3]);
 * // => true
 *
 * _.isArray(document.body.children);
 * // => false
 *
 * _.isArray('abc');
 * // => false
 *
 * _.isArray(_.noop);
 * // => false
 */
var isArray = Array.isArray;

/**
 * Checks if `value` is classified as a `Function` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
 * @example
 *
 * _.isFunction(_);
 * // => true
 *
 * _.isFunction(/abc/);
 * // => false
 */
function isFunction(value) {
  // The use of `Object#toString` avoids issues with the `typeof` operator
  // in Safari 8-9 which returns 'object' for typed array and other constructors.
  var tag = isObject(value) ? objectToString.call(value) : '';
  return tag == funcTag || tag == genTag;
}

/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject(value) {
  var type = typeof value;
  return !!value && (type == 'object' || type == 'function');
}

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return !!value && typeof value == 'object';
}

/**
 * Checks if `value` is classified as a `Symbol` primitive or object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
 * @example
 *
 * _.isSymbol(Symbol.iterator);
 * // => true
 *
 * _.isSymbol('abc');
 * // => false
 */
function isSymbol(value) {
  return typeof value == 'symbol' ||
    (isObjectLike(value) && objectToString.call(value) == symbolTag);
}

/**
 * Converts `value` to a string. An empty string is returned for `null`
 * and `undefined` values. The sign of `-0` is preserved.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to process.
 * @returns {string} Returns the string.
 * @example
 *
 * _.toString(null);
 * // => ''
 *
 * _.toString(-0);
 * // => '-0'
 *
 * _.toString([1, 2, 3]);
 * // => '1,2,3'
 */
function toString(value) {
  return value == null ? '' : baseToString(value);
}

/**
 * Gets the value at `path` of `object`. If the resolved value is
 * `undefined`, the `defaultValue` is returned in its place.
 *
 * @static
 * @memberOf _
 * @since 3.7.0
 * @category Object
 * @param {Object} object The object to query.
 * @param {Array|string} path The path of the property to get.
 * @param {*} [defaultValue] The value returned for `undefined` resolved values.
 * @returns {*} Returns the resolved value.
 * @example
 *
 * var object = { 'a': [{ 'b': { 'c': 3 } }] };
 *
 * _.get(object, 'a[0].b.c');
 * // => 3
 *
 * _.get(object, ['a', '0', 'b', 'c']);
 * // => 3
 *
 * _.get(object, 'a.b.c', 'default');
 * // => 'default'
 */
function get(object, path, defaultValue) {
  var result = object == null ? undefined : baseGet(object, path);
  return result === undefined ? defaultValue : result;
}

module.exports = get;

},{}],93:[function(require,module,exports){
'use strict';
module.exports = {
	stdout: false,
	stderr: false
};

},{}],94:[function(require,module,exports){
(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
	typeof define === 'function' && define.amd ? define(factory) :
	(global.typeDetect = factory());
}(this, (function () { 'use strict';

/* !
 * type-detect
 * Copyright(c) 2013 jake luer <jake@alogicalparadox.com>
 * MIT Licensed
 */
var promiseExists = typeof Promise === 'function';

/* eslint-disable no-undef */
var globalObject = typeof self === 'object' ? self : global; // eslint-disable-line id-blacklist

var symbolExists = typeof Symbol !== 'undefined';
var mapExists = typeof Map !== 'undefined';
var setExists = typeof Set !== 'undefined';
var weakMapExists = typeof WeakMap !== 'undefined';
var weakSetExists = typeof WeakSet !== 'undefined';
var dataViewExists = typeof DataView !== 'undefined';
var symbolIteratorExists = symbolExists && typeof Symbol.iterator !== 'undefined';
var symbolToStringTagExists = symbolExists && typeof Symbol.toStringTag !== 'undefined';
var setEntriesExists = setExists && typeof Set.prototype.entries === 'function';
var mapEntriesExists = mapExists && typeof Map.prototype.entries === 'function';
var setIteratorPrototype = setEntriesExists && Object.getPrototypeOf(new Set().entries());
var mapIteratorPrototype = mapEntriesExists && Object.getPrototypeOf(new Map().entries());
var arrayIteratorExists = symbolIteratorExists && typeof Array.prototype[Symbol.iterator] === 'function';
var arrayIteratorPrototype = arrayIteratorExists && Object.getPrototypeOf([][Symbol.iterator]());
var stringIteratorExists = symbolIteratorExists && typeof String.prototype[Symbol.iterator] === 'function';
var stringIteratorPrototype = stringIteratorExists && Object.getPrototypeOf(''[Symbol.iterator]());
var toStringLeftSliceLength = 8;
var toStringRightSliceLength = -1;
/**
 * ### typeOf (obj)
 *
 * Uses `Object.prototype.toString` to determine the type of an object,
 * normalising behaviour across engine versions & well optimised.
 *
 * @param {Mixed} object
 * @return {String} object type
 * @api public
 */
function typeDetect(obj) {
  /* ! Speed optimisation
   * Pre:
   *   string literal     x 3,039,035 ops/sec ±1.62% (78 runs sampled)
   *   boolean literal    x 1,424,138 ops/sec ±4.54% (75 runs sampled)
   *   number literal     x 1,653,153 ops/sec ±1.91% (82 runs sampled)
   *   undefined          x 9,978,660 ops/sec ±1.92% (75 runs sampled)
   *   function           x 2,556,769 ops/sec ±1.73% (77 runs sampled)
   * Post:
   *   string literal     x 38,564,796 ops/sec ±1.15% (79 runs sampled)
   *   boolean literal    x 31,148,940 ops/sec ±1.10% (79 runs sampled)
   *   number literal     x 32,679,330 ops/sec ±1.90% (78 runs sampled)
   *   undefined          x 32,363,368 ops/sec ±1.07% (82 runs sampled)
   *   function           x 31,296,870 ops/sec ±0.96% (83 runs sampled)
   */
  var typeofObj = typeof obj;
  if (typeofObj !== 'object') {
    return typeofObj;
  }

  /* ! Speed optimisation
   * Pre:
   *   null               x 28,645,765 ops/sec ±1.17% (82 runs sampled)
   * Post:
   *   null               x 36,428,962 ops/sec ±1.37% (84 runs sampled)
   */
  if (obj === null) {
    return 'null';
  }

  /* ! Spec Conformance
   * Test: `Object.prototype.toString.call(window)``
   *  - Node === "[object global]"
   *  - Chrome === "[object global]"
   *  - Firefox === "[object Window]"
   *  - PhantomJS === "[object Window]"
   *  - Safari === "[object Window]"
   *  - IE 11 === "[object Window]"
   *  - IE Edge === "[object Window]"
   * Test: `Object.prototype.toString.call(this)``
   *  - Chrome Worker === "[object global]"
   *  - Firefox Worker === "[object DedicatedWorkerGlobalScope]"
   *  - Safari Worker === "[object DedicatedWorkerGlobalScope]"
   *  - IE 11 Worker === "[object WorkerGlobalScope]"
   *  - IE Edge Worker === "[object WorkerGlobalScope]"
   */
  if (obj === globalObject) {
    return 'global';
  }

  /* ! Speed optimisation
   * Pre:
   *   array literal      x 2,888,352 ops/sec ±0.67% (82 runs sampled)
   * Post:
   *   array literal      x 22,479,650 ops/sec ±0.96% (81 runs sampled)
   */
  if (
    Array.isArray(obj) &&
    (symbolToStringTagExists === false || !(Symbol.toStringTag in obj))
  ) {
    return 'Array';
  }

  // Not caching existence of `window` and related properties due to potential
  // for `window` to be unset before tests in quasi-browser environments.
  if (typeof window === 'object' && window !== null) {
    /* ! Spec Conformance
     * (https://html.spec.whatwg.org/multipage/browsers.html#location)
     * WhatWG HTML$7.7.3 - The `Location` interface
     * Test: `Object.prototype.toString.call(window.location)``
     *  - IE <=11 === "[object Object]"
     *  - IE Edge <=13 === "[object Object]"
     */
    if (typeof window.location === 'object' && obj === window.location) {
      return 'Location';
    }

    /* ! Spec Conformance
     * (https://html.spec.whatwg.org/#document)
     * WhatWG HTML$3.1.1 - The `Document` object
     * Note: Most browsers currently adher to the W3C DOM Level 2 spec
     *       (https://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-26809268)
     *       which suggests that browsers should use HTMLTableCellElement for
     *       both TD and TH elements. WhatWG separates these.
     *       WhatWG HTML states:
     *         > For historical reasons, Window objects must also have a
     *         > writable, configurable, non-enumerable property named
     *         > HTMLDocument whose value is the Document interface object.
     * Test: `Object.prototype.toString.call(document)``
     *  - Chrome === "[object HTMLDocument]"
     *  - Firefox === "[object HTMLDocument]"
     *  - Safari === "[object HTMLDocument]"
     *  - IE <=10 === "[object Document]"
     *  - IE 11 === "[object HTMLDocument]"
     *  - IE Edge <=13 === "[object HTMLDocument]"
     */
    if (typeof window.document === 'object' && obj === window.document) {
      return 'Document';
    }

    if (typeof window.navigator === 'object') {
      /* ! Spec Conformance
       * (https://html.spec.whatwg.org/multipage/webappapis.html#mimetypearray)
       * WhatWG HTML$8.6.1.5 - Plugins - Interface MimeTypeArray
       * Test: `Object.prototype.toString.call(navigator.mimeTypes)``
       *  - IE <=10 === "[object MSMimeTypesCollection]"
       */
      if (typeof window.navigator.mimeTypes === 'object' &&
          obj === window.navigator.mimeTypes) {
        return 'MimeTypeArray';
      }

      /* ! Spec Conformance
       * (https://html.spec.whatwg.org/multipage/webappapis.html#pluginarray)
       * WhatWG HTML$8.6.1.5 - Plugins - Interface PluginArray
       * Test: `Object.prototype.toString.call(navigator.plugins)``
       *  - IE <=10 === "[object MSPluginsCollection]"
       */
      if (typeof window.navigator.plugins === 'object' &&
          obj === window.navigator.plugins) {
        return 'PluginArray';
      }
    }

    if ((typeof window.HTMLElement === 'function' ||
        typeof window.HTMLElement === 'object') &&
        obj instanceof window.HTMLElement) {
      /* ! Spec Conformance
      * (https://html.spec.whatwg.org/multipage/webappapis.html#pluginarray)
      * WhatWG HTML$4.4.4 - The `blockquote` element - Interface `HTMLQuoteElement`
      * Test: `Object.prototype.toString.call(document.createElement('blockquote'))``
      *  - IE <=10 === "[object HTMLBlockElement]"
      */
      if (obj.tagName === 'BLOCKQUOTE') {
        return 'HTMLQuoteElement';
      }

      /* ! Spec Conformance
       * (https://html.spec.whatwg.org/#htmltabledatacellelement)
       * WhatWG HTML$4.9.9 - The `td` element - Interface `HTMLTableDataCellElement`
       * Note: Most browsers currently adher to the W3C DOM Level 2 spec
       *       (https://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-82915075)
       *       which suggests that browsers should use HTMLTableCellElement for
       *       both TD and TH elements. WhatWG separates these.
       * Test: Object.prototype.toString.call(document.createElement('td'))
       *  - Chrome === "[object HTMLTableCellElement]"
       *  - Firefox === "[object HTMLTableCellElement]"
       *  - Safari === "[object HTMLTableCellElement]"
       */
      if (obj.tagName === 'TD') {
        return 'HTMLTableDataCellElement';
      }

      /* ! Spec Conformance
       * (https://html.spec.whatwg.org/#htmltableheadercellelement)
       * WhatWG HTML$4.9.9 - The `td` element - Interface `HTMLTableHeaderCellElement`
       * Note: Most browsers currently adher to the W3C DOM Level 2 spec
       *       (https://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-82915075)
       *       which suggests that browsers should use HTMLTableCellElement for
       *       both TD and TH elements. WhatWG separates these.
       * Test: Object.prototype.toString.call(document.createElement('th'))
       *  - Chrome === "[object HTMLTableCellElement]"
       *  - Firefox === "[object HTMLTableCellElement]"
       *  - Safari === "[object HTMLTableCellElement]"
       */
      if (obj.tagName === 'TH') {
        return 'HTMLTableHeaderCellElement';
      }
    }
  }

  /* ! Speed optimisation
  * Pre:
  *   Float64Array       x 625,644 ops/sec ±1.58% (80 runs sampled)
  *   Float32Array       x 1,279,852 ops/sec ±2.91% (77 runs sampled)
  *   Uint32Array        x 1,178,185 ops/sec ±1.95% (83 runs sampled)
  *   Uint16Array        x 1,008,380 ops/sec ±2.25% (80 runs sampled)
  *   Uint8Array         x 1,128,040 ops/sec ±2.11% (81 runs sampled)
  *   Int32Array         x 1,170,119 ops/sec ±2.88% (80 runs sampled)
  *   Int16Array         x 1,176,348 ops/sec ±5.79% (86 runs sampled)
  *   Int8Array          x 1,058,707 ops/sec ±4.94% (77 runs sampled)
  *   Uint8ClampedArray  x 1,110,633 ops/sec ±4.20% (80 runs sampled)
  * Post:
  *   Float64Array       x 7,105,671 ops/sec ±13.47% (64 runs sampled)
  *   Float32Array       x 5,887,912 ops/sec ±1.46% (82 runs sampled)
  *   Uint32Array        x 6,491,661 ops/sec ±1.76% (79 runs sampled)
  *   Uint16Array        x 6,559,795 ops/sec ±1.67% (82 runs sampled)
  *   Uint8Array         x 6,463,966 ops/sec ±1.43% (85 runs sampled)
  *   Int32Array         x 5,641,841 ops/sec ±3.49% (81 runs sampled)
  *   Int16Array         x 6,583,511 ops/sec ±1.98% (80 runs sampled)
  *   Int8Array          x 6,606,078 ops/sec ±1.74% (81 runs sampled)
  *   Uint8ClampedArray  x 6,602,224 ops/sec ±1.77% (83 runs sampled)
  */
  var stringTag = (symbolToStringTagExists && obj[Symbol.toStringTag]);
  if (typeof stringTag === 'string') {
    return stringTag;
  }

  var objPrototype = Object.getPrototypeOf(obj);
  /* ! Speed optimisation
  * Pre:
  *   regex literal      x 1,772,385 ops/sec ±1.85% (77 runs sampled)
  *   regex constructor  x 2,143,634 ops/sec ±2.46% (78 runs sampled)
  * Post:
  *   regex literal      x 3,928,009 ops/sec ±0.65% (78 runs sampled)
  *   regex constructor  x 3,931,108 ops/sec ±0.58% (84 runs sampled)
  */
  if (objPrototype === RegExp.prototype) {
    return 'RegExp';
  }

  /* ! Speed optimisation
  * Pre:
  *   date               x 2,130,074 ops/sec ±4.42% (68 runs sampled)
  * Post:
  *   date               x 3,953,779 ops/sec ±1.35% (77 runs sampled)
  */
  if (objPrototype === Date.prototype) {
    return 'Date';
  }

  /* ! Spec Conformance
   * (http://www.ecma-international.org/ecma-262/6.0/index.html#sec-promise.prototype-@@tostringtag)
   * ES6$25.4.5.4 - Promise.prototype[@@toStringTag] should be "Promise":
   * Test: `Object.prototype.toString.call(Promise.resolve())``
   *  - Chrome <=47 === "[object Object]"
   *  - Edge <=20 === "[object Object]"
   *  - Firefox 29-Latest === "[object Promise]"
   *  - Safari 7.1-Latest === "[object Promise]"
   */
  if (promiseExists && objPrototype === Promise.prototype) {
    return 'Promise';
  }

  /* ! Speed optimisation
  * Pre:
  *   set                x 2,222,186 ops/sec ±1.31% (82 runs sampled)
  * Post:
  *   set                x 4,545,879 ops/sec ±1.13% (83 runs sampled)
  */
  if (setExists && objPrototype === Set.prototype) {
    return 'Set';
  }

  /* ! Speed optimisation
  * Pre:
  *   map                x 2,396,842 ops/sec ±1.59% (81 runs sampled)
  * Post:
  *   map                x 4,183,945 ops/sec ±6.59% (82 runs sampled)
  */
  if (mapExists && objPrototype === Map.prototype) {
    return 'Map';
  }

  /* ! Speed optimisation
  * Pre:
  *   weakset            x 1,323,220 ops/sec ±2.17% (76 runs sampled)
  * Post:
  *   weakset            x 4,237,510 ops/sec ±2.01% (77 runs sampled)
  */
  if (weakSetExists && objPrototype === WeakSet.prototype) {
    return 'WeakSet';
  }

  /* ! Speed optimisation
  * Pre:
  *   weakmap            x 1,500,260 ops/sec ±2.02% (78 runs sampled)
  * Post:
  *   weakmap            x 3,881,384 ops/sec ±1.45% (82 runs sampled)
  */
  if (weakMapExists && objPrototype === WeakMap.prototype) {
    return 'WeakMap';
  }

  /* ! Spec Conformance
   * (http://www.ecma-international.org/ecma-262/6.0/index.html#sec-dataview.prototype-@@tostringtag)
   * ES6$24.2.4.21 - DataView.prototype[@@toStringTag] should be "DataView":
   * Test: `Object.prototype.toString.call(new DataView(new ArrayBuffer(1)))``
   *  - Edge <=13 === "[object Object]"
   */
  if (dataViewExists && objPrototype === DataView.prototype) {
    return 'DataView';
  }

  /* ! Spec Conformance
   * (http://www.ecma-international.org/ecma-262/6.0/index.html#sec-%mapiteratorprototype%-@@tostringtag)
   * ES6$23.1.5.2.2 - %MapIteratorPrototype%[@@toStringTag] should be "Map Iterator":
   * Test: `Object.prototype.toString.call(new Map().entries())``
   *  - Edge <=13 === "[object Object]"
   */
  if (mapExists && objPrototype === mapIteratorPrototype) {
    return 'Map Iterator';
  }

  /* ! Spec Conformance
   * (http://www.ecma-international.org/ecma-262/6.0/index.html#sec-%setiteratorprototype%-@@tostringtag)
   * ES6$23.2.5.2.2 - %SetIteratorPrototype%[@@toStringTag] should be "Set Iterator":
   * Test: `Object.prototype.toString.call(new Set().entries())``
   *  - Edge <=13 === "[object Object]"
   */
  if (setExists && objPrototype === setIteratorPrototype) {
    return 'Set Iterator';
  }

  /* ! Spec Conformance
   * (http://www.ecma-international.org/ecma-262/6.0/index.html#sec-%arrayiteratorprototype%-@@tostringtag)
   * ES6$22.1.5.2.2 - %ArrayIteratorPrototype%[@@toStringTag] should be "Array Iterator":
   * Test: `Object.prototype.toString.call([][Symbol.iterator]())``
   *  - Edge <=13 === "[object Object]"
   */
  if (arrayIteratorExists && objPrototype === arrayIteratorPrototype) {
    return 'Array Iterator';
  }

  /* ! Spec Conformance
   * (http://www.ecma-international.org/ecma-262/6.0/index.html#sec-%stringiteratorprototype%-@@tostringtag)
   * ES6$21.1.5.2.2 - %StringIteratorPrototype%[@@toStringTag] should be "String Iterator":
   * Test: `Object.prototype.toString.call(''[Symbol.iterator]())``
   *  - Edge <=13 === "[object Object]"
   */
  if (stringIteratorExists && objPrototype === stringIteratorPrototype) {
    return 'String Iterator';
  }

  /* ! Speed optimisation
  * Pre:
  *   object from null   x 2,424,320 ops/sec ±1.67% (76 runs sampled)
  * Post:
  *   object from null   x 5,838,000 ops/sec ±0.99% (84 runs sampled)
  */
  if (objPrototype === null) {
    return 'Object';
  }

  return Object
    .prototype
    .toString
    .call(obj)
    .slice(toStringLeftSliceLength, toStringRightSliceLength);
}

return typeDetect;

})));

},{}]},{},[2])(2)
});

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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