package info.plateaukao.einkbro.util


enum class TranslationLanguage(val value: String, val language: String) {
    ZH_TW("zh-TW", "Chinese (Traditional)"),
    ZH_CN("zh-CN", "Chinese (Simplified)"),
    JA("ja", "Japanese"),
    KO("ko", "Korean"),
    EN("en", "English"),
    FR("fr", "French"),
    SQ("sq", "Albanian"),
    AM("am", "Amharic"),
    AR("ar", "Arabic"),
    HY("hy", "Armenian"),
    AZ("az", "Azerbaijani"),
    EU("eu", "Basque"),
    BE("be", "Belarusian"),
    BN("bn", "Bengali"),
    BS("bs", "Bosnian"),
    BG("bg", "Bulgarian"),
    CA("ca", "Catalan"),
    CEB("ceb", "Cebuano"),
    NY("ny", "Chichewa"),
    CO("co", "Corsican"),
    HR("hr", "Croatian"),
    CS("cs", "Czech"),
    DA("da", "Danish"),
    NL("nl", "Dutch"),
    EO("eo", "Esperanto"),
    ET("et", "Estonian"),
    TL("tl", "Filipino"),
    FI("fi", "Finnish"),
    FY("fy", "Frisian"),
    GL("gl", "Galician"),
    KA("ka", "Georgian"),
    DE("de", "German"),
    EL("el", "Greek"),
    GU("gu", "Gujarati"),
    HT("ht", "Haitian Creole"),
    HA("ha", "Hausa"),
    HAW("haw", "Hawaiian"),
    IW("iw", "Hebrew"),
    HI("hi", "Hindi"),
    HMN("hmn", "Hmong"),
    HU("hu", "Hungarian"),
    IS("is", "Icelandic"),
    IG("ig", "Igbo"),
    ID("id", "Indonesian"),
    GA("ga", "Irish"),
    IT("it", "Italian"),
    JW("jw", "Javanese"),
    KN("kn", "Kannada"),
    KK("kk", "Kazakh"),
    KM("km", "Khmer"),
    RW("rw", "Kinyarwanda"),
    KU("ku", "Kurdish (Kurmanji)"),
    KY("ky", "Kyrgyz"),
    LO("lo", "Lao"),
    LA("la", "Latin"),
    LV("lv", "Latvian"),
    LT("lt", "Lithuanian"),
    LB("lb", "Luxembourgish"),
    MK("mk", "Macedonian"),
    MG("mg", "Malagasy"),
    MS("ms", "Malay"),
    ML("ml", "Malayalam"),
    MT("mt", "Maltese"),
    MI("mi", "Maori"),
    MR("mr", "Marathi"),
    MN("mn", "Mongolian"),
    MY("my", "Myanmar (Burmese)"),
    NE("ne", "Nepali"),
    NO("no", "Norwegian"),
    OR("or", "Odia (Oriya)"),
    PS("ps", "Pashto"),
    FA("fa", "Persian"),
    PL("pl", "Polish"),
    PT("pt", "Portuguese"),
    PA("pa", "Punjabi"),
    RO("ro", "Romanian"),
    RU("ru", "Russian"),
    SM("sm", "Samoan"),
    GD("gd", "Scots Gaelic"),
    SR("sr", "Serbian"),
    ST("st", "Sesotho"),
    SN("sn", "Shona"),
    SD("sd", "Sindhi"),
    SI("si", "Sinhala"),
    SK("sk", "Slovak"),
    SL("sl", "Slovenian"),
    SO("so", "Somali"),
    ES("es", "Spanish"),
    SU("su", "Sundanese"),
    SW("sw", "Swahili"),
    SV("sv", "Swedish"),
    TG("tg", "Tajik"),
    TA("ta", "Tamil"),
    TT("tt", "Tatar"),
    TE("te", "Telugu"),
    TH("th", "Thai"),
    TR("tr", "Turkish"),
    TK("tk", "Turkmen"),
    UK("uk", "Ukrainian"),
    UR("ur", "Urdu"),
    UG("ug", "Uyghur"),
    UZ("uz", "Uzbek"),
    VI("vi", "Vietnamese"),
    CY("cy", "Welsh"),
    XH("xh", "Xhosa"),
    YI("yi", "Yiddish"),
    YO("yo", "Yoruba"),
    ZU("zu", "Zulu");

    companion object {
        fun findByLanguage(lan: String): TranslationLanguage {
            values().forEach {
                if (it.language.equals(lan, ignoreCase = true)) {
                    return it
                }
            }
            return ZH_TW
        }
    }

    val languageCode get() = if (value == "zh-TW") "zh-Hant" else if (value == "zh-CN") "zh-Hans" else value
}