FOSS browser contributors guide.


# FOSS Browser. Contributor's guidelines


# How to contribute

Great! FOSS Browser continues to improve from the contributions of its users. This could include code contributions, feature requests, and bug fixes for [FOSS Browser](https://github.com/scoute-dich/browser). 
Thank you for your interest in contributing to FOSS Browser. I appreciate all help with finding and fixing bugs, making performance improvements, and other tasks. Every contribution is helpful and I thank you for your effort. To ensure the process of contributing is as smooth as possible, here are a few guidelines for you to follow.

- Remember to Create an Issue before submitting any major changes like a new feature or UI changes etc. Changes like the addition of new language or spelling mistakes don't require issue creation.
---


# Creating an issue

There are several reasons to create a new issue. As always, make sure you search through open and **closed** 
issues before opening a new one.
There's a good chance that whatever reason you might be opening an issue for might already have been opened or closed by another user.

## Missing language support?

Your language isn't supported yet? You want to translate FOSS Browser? Or make improvements to existing translations? Feel free to use [crowdin](https://crowdin.com/project/foss-browser).

## New ideas, enhancements and feature requests

Great! The developer loves new ideas and welcome opportunities for improvement.


### I'm not a developer

Great. Feel free to open a new issue. Please describe the enhancement or feature you like and then be patient. The developer would certainly work on the request as soon as possible. Help can also be gotten from the opensource community. 

In order to help the developer understand the feature request;

- Title of the issue should be explicit, giving insight into the content of the issue.
- The area of the project where your feature would be applied or implemented should be properly stated. Add screenshots of mockup if possible.
- It would be great if a detailed use case is included in your request.

When submitting a feature request, please make a single issue for each feature request (i.e. don't submit an issue that contains a list of features). Such issues are hard to keep track of and often get lost.


### I'm a developer (Code Contributions).

Fantastic. It's very rare for us to deny pull requests. Open a ticket to let other's know what you are working on along with a description. Fork the repository which in this case is [FOSS Browser](https://github.com/scoute-dich/browser), make your desired changes, and send a pull request.

Please refrain from reformatting or rearranging the code. It makes it very hard to identify changes
in pull requests. 
If you're adding a new feature or function, please either incorporate a test or a sample that shows
how your new function can be used. Oh, and please make sure it works.

## Commit Guidelines

The developer encourages more small commits over one large commit. Small, focused commits make the review process easier and are more likely to be accepted. It is also important to summarise the changes made with brief commit messages. If the commit fixes a specific issue, it is also good to note that in the commit message.

The commit message should start with a single line that briefly describes the changes. That should be followed by a blank line and then a more detailed explanation. As a good practice, use commands when writing the message (instead of "I added ..." or "Adding ...", use "Add ...").

Before committing check for unnecessary whitespace with `git diff --check`.

For further recommendations, see [Pro Git Commit Guidelines](https://git-scm.com/book/en/v2/Distributed-Git-Contributing-to-a-Project#Commit-Guidelines "Pro Git Commit Guidelines").

## Submitting Changes

### Pull Request Guidelines

The following guidelines can increase the likelihood that your pull request will get accepted:

* Work on topic branches.
* Follow the commit guidelines.
* Keep the patches on topic, focused, and atomic.
* Try to avoid unnecessary formatting and clean-up where reasonable.

A pull request should contain the following:

* At least one commit (all of which should follow the Commit Guidelines)
* Title that summarises the issue
* Description that briefly summarises the changes

After submitting a pull request, you should get a response within the next 7 days. If you do not, don't hesitate to ping the thread.

## Creating a pull request

If you don't know how to create a pull request, this section will help you to get started. 

Here's a detailed content on how to [Create a pull request](https://help.github.com/articles/creating-a-pull-request)

Simply put, the way to create a Pull request is first to; 

1. Fork the repository of the project which in this case is [FOSS Browser](https://github.com/scoute-dich/browser)
2. Commit modifications and changes to your fork
3. Send a [pull request](https://help.github.com/articles/creating-a-pull-request) to the original repository you forked your repository from in step 1

## Bug Reports

Sorry to hear about your troubles. I try to make the app free of bugs and errors but, the app is not 100% bug proof. That's why bug reports are useful for this project when you encounter them. Before filing a bug report; check the issue tracker if the bug hasn't been reported by other users. If it has been reported before, it is likely to be in [opened issues](https://github.com/scoute-dich/browser/issues?q=is%3Aopen+is%3Aissue).  You can also check out [closed issues](https://github.com/scoute-dich/browser/issues?q=is%3Aissue+is%3Aclosed).
 

So, if it's a new issue; please include the following:

 * Steps to reproduce and/or sample code to recreate the problem.
 * I'll also need to know what version of FOSS browser you're using and,
 * The version of Android in the device in question. Sometimes the manufacturer is helpful too. Since there can be variants of Android that may affect 
   things (such as x86).

Finally, please be patient. The developer has a lot of things to do. But, be assured that the bug report will receive adequate attention, and will consequently be fixed. If you are a
developer,  you can fork FOSS Browser and fix it yourself. 


## Contact.

For further inquiries, you can contact the developer by opening an issue on the repository.

You can also check out the developer's profile [here](https://github.com/scoute-dich).


***Thank you for your interest in contributing to FOSS Browser. I appreciate all the help with finding and fixing bugs, making performance improvements, and other tasks. Every contribution is helpful and I thank you for your effort.***

