# EinkBro: Small Android Browser made for Eink devices 

EinkBro is designed to fit Eink devices' needs; no unnecessary UI transitions and animations, clear B&W icons, useful features for eink reading experience. It's originated from [FOSS Browser](https://codeberg.org/Gaukler_Faun/FOSS_Browser), which is fully free/libre (as in freedom) Android app. 

[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png"
     alt="Get it on F-Droid"
     height="60">](https://f-droid.org/packages/info.plateaukao.einkbro/)

[<img src="https://badgen.net/github/release/plateaukao/einkbro">](https://github.com/plateaukao/einkbro/releases)   [<img src="https://badgen.net/badge/download/snapshot_zip/green">](https://nightly.link/plateaukao/einkbro/workflows/buid-app-workflow.yaml/main/app-arm64-v8a-release.apk.zip)   

## EinkBro has a book about how it was developed!
[<img width=200 src="https://github.com/user-attachments/assets/19c07714-a093-4960-b33e-bebb2ecf4501">](https://play.google.com/store/books/details/%E9%AB%98%E8%8C%82%E5%8E%9F_Daniel_Kao_Android%E9%96%8B%E6%BA%90%E5%B0%88%E6%A1%88_%E7%9C%9F_%E5%AF%A6%E6%88%B0%E5%95%9F%E8%88%AA?id=aOniEAAAQBAJ)


## Screenshots

|Main Screen|Menu Items|Toolbar Configuration|
|----|----|----|
|<img src="https://user-images.githubusercontent.com/4084738/216380150-dbac589a-175e-4ae6-9776-7cd0b219ae43.png" width="200"/>|<img src="https://user-images.githubusercontent.com/4084738/216380448-9b226f37-c30c-49fd-8242-3291bf82eaab.png" width="200"/>|<img src="https://user-images.githubusercontent.com/4084738/216380769-b2461e9b-a78a-43a0-8317-43882a683d13.png" width="200"/>|
|Touch Setting|Settings|Vertical Read|
|<img src="https://user-images.githubusercontent.com/4084738/216380971-7e021ba9-e6f6-4f69-8323-1faf10f9e06b.png" width="200"/>|<img src="https://user-images.githubusercontent.com/4084738/216381202-e8103082-2866-48d9-92b1-96d3cc8106dd.png" width="200"/>|<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/7.png" width="200"/>|

## E-Ink specific features

- **tap on screen left/right area for pageUp/Down**
- **use physical volume keys for pageUp/pageDown**
- **reader mode**
- **vertical reading mode** (for Chinese/Japanese content)
- **export web content to epub files**
- pageUp / pageDown button on toolbar
- all icons in high contrast colors
- tab count in bottom function bar
- font size configuration in first layer setting.
- custom font with local font files

## Customizable Toolbar Icons
<img width="800" alt="image" src="https://user-images.githubusercontent.com/4084738/122229339-39f62080-ceeb-11eb-8c46-2f6ea270b486.png">

* web title
* web tab count
* bookmarks
* refresh
* go backward
* go forward
* bold font
* increase font size
* decrease font size
* text size configuration dialog
* touch screen area to turn page buton
* page up
* page down
* reader mode
* vertical reader mode
* fulltext translation
* setting
* toolbar configuration dialog
* rotate screen
* fullscreen

## Basic UI/Handling:

- optimized for one hand handling (toolbar at bottom)
- tab control
- fullscreen browsing
- floating button in fullscreen mode
- fast toggle for most important settings
- gesture control for floating navigation button
- multi-touch gesture support

## Some nice extra features:

- small size
- search on site
- open links in background
- Websearch (from marked text context menu)
- screenshots of the whole website
- share/save as PDF
- open links in other apps (for example YouTube)

## Development environment supported by JetBrains
[<img src="https://resources.jetbrains.com/storage/products/company/brand/logos/IntelliJ_IDEA_icon.png"
     alt="IDE supported by JetBrains"
     height="80">](https://jb.gg/OpenSourceSupport)   
     
<div>App icon is made by <a href="https://www.flaticon.com/authors/turkkub" title="turkkub">turkkub</a> from <a href="https://www.flaticon.com/" title="Flaticon">www.flaticon.com</a></div>
<a href="https://www.flaticon.com/free-icons/language" title="language icons">Language icons created by Those Icons - Flaticon</a>
<a href="https://www.flaticon.com/free-icons/split-screen" title="split screen icons">Split screen icons created by Fajrul Fitrianto - Flaticon</a>
