# FOSS Browser FAQs

This is a compilation of Frequently Asked Questions for FOSS Browser. This document will aid prospective and existing end-users of the software as a self-service guide in cases where the developer can't be reached. This document is subject to change and modifications at any time. Thus, it will be updated from time to time consequently to suit any new changes to the software as new developments would be implemented. These new developments might cause a discrepancy with this current document.

---


### What is FOSS browser? 

FOSS Browser is fully free/libre (as in freedom) Android app. The source code is public. The app also does not need any unnecessary permissions. It's a simple Android browser based on webview. The intention is to provide a simple and lightweight but a powerful browser with a nice looking user interface.

---

### What are the features of FOSS browser?

FOSS browser is laced with a variety of rich features that makes it an amazing and outstanding browser. Some of FOSS Browser features are these;

- Full material design
- AdBlocker
- Anti-tracking
- Data Saving
- Advanced gesture control for toolbar and navigation button
- Search on site
- Screenshots of the whole website
- Share/save a webpage as PDF

Aside from the features above, FOSS Browser is designed with all the basic features of a browser. 

---

### Can I customise the browser's UI?

Yes, you can customize the app's UI. But, in terms of how the app looks, you can only switch between light and dark themes. You can also adjust font size. 

To customize the app's UI;

1. Go to the app's settings. To access the settings page;
2. Click on the 3 dots beside the navigation bar at the bottom part of the app. This would open the options menu.
3. On the options menu, there are different sections represented by different icons. 
4. Click on the last icon ie; the 3 dots. When you click that icon, you will find the settings option.
5. Click on settings to open the settings page.
6. Scroll to Behaviour/UI and click on it. On this page, you can perform whatever kind of customization is available. 

---

### How do I bookmark a webpage, or add it to home?

Bookmarking a webpage on FOSS Browser is quite simple. First;

- Be on the webpage you wish to add to bookmarks or homepage. 
- Access the options menu by clicking the 3 dots beside the navigation bar
- Click on the save icon on the options menu. The save icon is the third icon on the options menu.
- On the page, you will see; save at Home and save as a bookmark. 
- Click on the option you wish to perform. 

---

### Can I import bookmarks from another browser?

No, you can't import bookmarks from other browsers. 

---

### Where can I access saved bookmarks?

To access your saved bookmarks;

- Click on the icon at the left side of the navigation bar. The button is naturally to display opened tabs. But, just beneath the tabs, you will find other menus there.
- You can open a new tab from there by clicking the plus (+) icon.
- The next icon is that for the home screen. Any page you add to home is displayed there.
- The next icon is for bookmarks. Saved bookmarks go there.
- The last icon is your browsing history. 


---


### Can I browse securely? Does FOSS browser support encrypted connections?

Yes. In all recent versions, information sent between your phone and the websites you visit is encrypted if the site has correctly implemented [HTTPS protocol](http://en.wikipedia.org/wiki/HTTP_Secure).

---

### What about security? How does FOSS browser protect my privacy?

Your privacy is somewhat secured when you use FOSS Browser. The term somewhat is used because; no method of transmission over the internet or electronic storage is 100% secure, therefore the developer doesn't guarantee its absolute security.

You can read FOSS Browser [Privacy Policy](https://github.com/scoute-dich/browser/blob/master/PRIVACY.md)

---


### Can I save a page for offline use?

No, you cannot save a page for offline use. But, if you screen a page, it can act as though you have saved the page and can look at it later on. 

---


### Can I download media files?

Yes, you can download any file on FOSS Browser. But, the browser would use your device's downloader. 

---


### Why is my browsing speed is so slow?

The reasons for slow Internet speed may be:
1. Your local network condition. When there are too many users online, the network can get overloaded and that would make your Internet speed slow. 
2. If the slow speed is only for some sites, you can use your phone's built-in browser to visit these sites to see if the situation is the same. If yes, then it is that web site's issue. If no, and you can visit these sites without any problem with your built-in browser, please report this problem to the developer.


---

### My data gets exhausted very fast. Does the browser have a data saving option?

FOSS browser does have data saving. Although indirectly. One of the ways to save data while surfing the internet is to disable images from loading. Images on a website consume quite a reasonable amount of data. If you are surfing on a web page where images aren't of importance to you, you can disable images from loading and consequently save your data. Disabling this option also gives you a faster browsing experience. 

Read how to get into the app's settings [here](https://hackmd.io/t0WLk9GXRziQENXkPqJf5w?both#Can-I-customise-the-browser%E2%80%99s-UI). Read up to step 5. 

- When on the settings menu, click on start control.
- When the page opens up, you will see the first option there, which is images.
- Click the checkbox to enable or disable the option. 

---

### I found a bug in FOSS browser. How can I report it?

Firstly, apologies for any inconvenience this issue may have caused you. The developer is working to ensure that the app is bug-free. You can help speed up that process by making a report to when you encounter an error, or when the app crashes. 

You can report a bug by opening an issue [here](https://github.com/scoute-dich/browser/issues/new)

Filing a great bug report helps the developer pinpoint the cause of the bug and effectively work on a fix.

---

### My question isn't on this list. Where can I find out more?

If there are other questions you think should be added to this FAQs document, feel free to open an issue or add the question(s) to this document and make a pull request.

For further inquiries, you can contact the developer by opening an issue [here](https://github.com/scoute-dich/browser/issues/new)
