package info.dvkr.screenstream.ui.tabs

import androidx.annotation.StringRes
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector
import info.dvkr.screenstream.R

internal enum class AppTabs(
    internal val icon: ImageVector,
    internal val iconSelected: ImageVector,
    @field:StringRes internal val label: Int
) {
    STREAM(Icon_Stream, Icon_Stream, R.string.app_tab_stream),
    SETTINGS(Icon_Settings, Icons_Settings_Filled, R.string.app_tab_settings),
    ABOUT(Icon_Info, Icon_Info_Filled, R.string.app_tab_about),
    EXIT(Icons_Filled_Close, Icons_Filled_Close, R.string.app_tab_exit)
}

private val Icon_Stream: ImageVector = materialIcon(name = "Filled.Stream") {
    materialPath {
        moveTo(20.0f, 12.0f)
        moveToRelative(-2.0f, 0.0f)
        arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
        arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
    }
    materialPath {
        moveTo(4.0f, 12.0f)
        moveToRelative(-2.0f, 0.0f)
        arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
        arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
    }
    materialPath {
        moveTo(12.0f, 20.0f)
        moveToRelative(-2.0f, 0.0f)
        arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
        arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
    }
    materialPath {
        moveTo(10.05f, 8.59f)
        lineTo(6.03f, 4.55f)
        horizontalLineToRelative(-0.01f)
        lineToRelative(-0.31f, -0.32f)
        lineToRelative(-1.42f, 1.41f)
        lineToRelative(4.02f, 4.05f)
        lineToRelative(0.01f, -0.01f)
        lineToRelative(0.31f, 0.32f)
        close()
        moveTo(13.943f, 8.617f)
        lineToRelative(4.405f, -4.392f)
        lineTo(19.76f, 5.64f)
        lineToRelative(-4.405f, 4.393f)
        close()
        moveTo(10.01f, 15.36f)
        lineToRelative(-1.42f, -1.41f)
        lineToRelative(-4.03f, 4.01f)
        lineToRelative(-0.32f, 0.33f)
        lineToRelative(1.41f, 1.41f)
        lineToRelative(4.03f, -4.02f)
        close()
        moveTo(19.76f, 18.3f)
        lineToRelative(-3.99f, -4.01f)
        lineToRelative(-0.36f, -0.35f)
        lineTo(14.0f, 15.35f)
        lineToRelative(3.99f, 4.01f)
        lineToRelative(0.35f, 0.35f)
        close()
    }
    materialPath {
        moveTo(12.0f, 4.0f)
        moveToRelative(-2.0f, 0.0f)
        arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
        arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
    }
}

private val Icon_Settings: ImageVector = materialIcon(name = "Outlined.Settings") {
    materialPath {
        moveTo(19.43f, 12.98f)
        curveToRelative(0.04f, -0.32f, 0.07f, -0.64f, 0.07f, -0.98f)
        curveToRelative(0.0f, -0.34f, -0.03f, -0.66f, -0.07f, -0.98f)
        lineToRelative(2.11f, -1.65f)
        curveToRelative(0.19f, -0.15f, 0.24f, -0.42f, 0.12f, -0.64f)
        lineToRelative(-2.0f, -3.46f)
        curveToRelative(-0.09f, -0.16f, -0.26f, -0.25f, -0.44f, -0.25f)
        curveToRelative(-0.06f, 0.0f, -0.12f, 0.01f, -0.17f, 0.03f)
        lineToRelative(-2.49f, 1.0f)
        curveToRelative(-0.52f, -0.4f, -1.08f, -0.73f, -1.69f, -0.98f)
        lineToRelative(-0.38f, -2.65f)
        curveTo(14.46f, 2.18f, 14.25f, 2.0f, 14.0f, 2.0f)
        horizontalLineToRelative(-4.0f)
        curveToRelative(-0.25f, 0.0f, -0.46f, 0.18f, -0.49f, 0.42f)
        lineToRelative(-0.38f, 2.65f)
        curveToRelative(-0.61f, 0.25f, -1.17f, 0.59f, -1.69f, 0.98f)
        lineToRelative(-2.49f, -1.0f)
        curveToRelative(-0.06f, -0.02f, -0.12f, -0.03f, -0.18f, -0.03f)
        curveToRelative(-0.17f, 0.0f, -0.34f, 0.09f, -0.43f, 0.25f)
        lineToRelative(-2.0f, 3.46f)
        curveToRelative(-0.13f, 0.22f, -0.07f, 0.49f, 0.12f, 0.64f)
        lineToRelative(2.11f, 1.65f)
        curveToRelative(-0.04f, 0.32f, -0.07f, 0.65f, -0.07f, 0.98f)
        curveToRelative(0.0f, 0.33f, 0.03f, 0.66f, 0.07f, 0.98f)
        lineToRelative(-2.11f, 1.65f)
        curveToRelative(-0.19f, 0.15f, -0.24f, 0.42f, -0.12f, 0.64f)
        lineToRelative(2.0f, 3.46f)
        curveToRelative(0.09f, 0.16f, 0.26f, 0.25f, 0.44f, 0.25f)
        curveToRelative(0.06f, 0.0f, 0.12f, -0.01f, 0.17f, -0.03f)
        lineToRelative(2.49f, -1.0f)
        curveToRelative(0.52f, 0.4f, 1.08f, 0.73f, 1.69f, 0.98f)
        lineToRelative(0.38f, 2.65f)
        curveToRelative(0.03f, 0.24f, 0.24f, 0.42f, 0.49f, 0.42f)
        horizontalLineToRelative(4.0f)
        curveToRelative(0.25f, 0.0f, 0.46f, -0.18f, 0.49f, -0.42f)
        lineToRelative(0.38f, -2.65f)
        curveToRelative(0.61f, -0.25f, 1.17f, -0.59f, 1.69f, -0.98f)
        lineToRelative(2.49f, 1.0f)
        curveToRelative(0.06f, 0.02f, 0.12f, 0.03f, 0.18f, 0.03f)
        curveToRelative(0.17f, 0.0f, 0.34f, -0.09f, 0.43f, -0.25f)
        lineToRelative(2.0f, -3.46f)
        curveToRelative(0.12f, -0.22f, 0.07f, -0.49f, -0.12f, -0.64f)
        lineToRelative(-2.11f, -1.65f)
        close()
        moveTo(17.45f, 11.27f)
        curveToRelative(0.04f, 0.31f, 0.05f, 0.52f, 0.05f, 0.73f)
        curveToRelative(0.0f, 0.21f, -0.02f, 0.43f, -0.05f, 0.73f)
        lineToRelative(-0.14f, 1.13f)
        lineToRelative(0.89f, 0.7f)
        lineToRelative(1.08f, 0.84f)
        lineToRelative(-0.7f, 1.21f)
        lineToRelative(-1.27f, -0.51f)
        lineToRelative(-1.04f, -0.42f)
        lineToRelative(-0.9f, 0.68f)
        curveToRelative(-0.43f, 0.32f, -0.84f, 0.56f, -1.25f, 0.73f)
        lineToRelative(-1.06f, 0.43f)
        lineToRelative(-0.16f, 1.13f)
        lineToRelative(-0.2f, 1.35f)
        horizontalLineToRelative(-1.4f)
        lineToRelative(-0.19f, -1.35f)
        lineToRelative(-0.16f, -1.13f)
        lineToRelative(-1.06f, -0.43f)
        curveToRelative(-0.43f, -0.18f, -0.83f, -0.41f, -1.23f, -0.71f)
        lineToRelative(-0.91f, -0.7f)
        lineToRelative(-1.06f, 0.43f)
        lineToRelative(-1.27f, 0.51f)
        lineToRelative(-0.7f, -1.21f)
        lineToRelative(1.08f, -0.84f)
        lineToRelative(0.89f, -0.7f)
        lineToRelative(-0.14f, -1.13f)
        curveToRelative(-0.03f, -0.31f, -0.05f, -0.54f, -0.05f, -0.74f)
        reflectiveCurveToRelative(0.02f, -0.43f, 0.05f, -0.73f)
        lineToRelative(0.14f, -1.13f)
        lineToRelative(-0.89f, -0.7f)
        lineToRelative(-1.08f, -0.84f)
        lineToRelative(0.7f, -1.21f)
        lineToRelative(1.27f, 0.51f)
        lineToRelative(1.04f, 0.42f)
        lineToRelative(0.9f, -0.68f)
        curveToRelative(0.43f, -0.32f, 0.84f, -0.56f, 1.25f, -0.73f)
        lineToRelative(1.06f, -0.43f)
        lineToRelative(0.16f, -1.13f)
        lineToRelative(0.2f, -1.35f)
        horizontalLineToRelative(1.39f)
        lineToRelative(0.19f, 1.35f)
        lineToRelative(0.16f, 1.13f)
        lineToRelative(1.06f, 0.43f)
        curveToRelative(0.43f, 0.18f, 0.83f, 0.41f, 1.23f, 0.71f)
        lineToRelative(0.91f, 0.7f)
        lineToRelative(1.06f, -0.43f)
        lineToRelative(1.27f, -0.51f)
        lineToRelative(0.7f, 1.21f)
        lineToRelative(-1.07f, 0.85f)
        lineToRelative(-0.89f, 0.7f)
        lineToRelative(0.14f, 1.13f)
        close()
        moveTo(12.0f, 8.0f)
        curveToRelative(-2.21f, 0.0f, -4.0f, 1.79f, -4.0f, 4.0f)
        reflectiveCurveToRelative(1.79f, 4.0f, 4.0f, 4.0f)
        reflectiveCurveToRelative(4.0f, -1.79f, 4.0f, -4.0f)
        reflectiveCurveToRelative(-1.79f, -4.0f, -4.0f, -4.0f)
        close()
        moveTo(12.0f, 14.0f)
        curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
        reflectiveCurveToRelative(0.9f, -2.0f, 2.0f, -2.0f)
        reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
        reflectiveCurveToRelative(-0.9f, 2.0f, -2.0f, 2.0f)
        close()
    }
}

private val Icons_Settings_Filled: ImageVector = materialIcon(name = "Filled.Settings") {
    materialPath {
        moveTo(19.14f, 12.94f)
        curveToRelative(0.04f, -0.3f, 0.06f, -0.61f, 0.06f, -0.94f)
        curveToRelative(0.0f, -0.32f, -0.02f, -0.64f, -0.07f, -0.94f)
        lineToRelative(2.03f, -1.58f)
        curveToRelative(0.18f, -0.14f, 0.23f, -0.41f, 0.12f, -0.61f)
        lineToRelative(-1.92f, -3.32f)
        curveToRelative(-0.12f, -0.22f, -0.37f, -0.29f, -0.59f, -0.22f)
        lineToRelative(-2.39f, 0.96f)
        curveToRelative(-0.5f, -0.38f, -1.03f, -0.7f, -1.62f, -0.94f)
        lineTo(14.4f, 2.81f)
        curveToRelative(-0.04f, -0.24f, -0.24f, -0.41f, -0.48f, -0.41f)
        horizontalLineToRelative(-3.84f)
        curveToRelative(-0.24f, 0.0f, -0.43f, 0.17f, -0.47f, 0.41f)
        lineTo(9.25f, 5.35f)
        curveTo(8.66f, 5.59f, 8.12f, 5.92f, 7.63f, 6.29f)
        lineTo(5.24f, 5.33f)
        curveToRelative(-0.22f, -0.08f, -0.47f, 0.0f, -0.59f, 0.22f)
        lineTo(2.74f, 8.87f)
        curveTo(2.62f, 9.08f, 2.66f, 9.34f, 2.86f, 9.48f)
        lineToRelative(2.03f, 1.58f)
        curveTo(4.84f, 11.36f, 4.8f, 11.69f, 4.8f, 12.0f)
        reflectiveCurveToRelative(0.02f, 0.64f, 0.07f, 0.94f)
        lineToRelative(-2.03f, 1.58f)
        curveToRelative(-0.18f, 0.14f, -0.23f, 0.41f, -0.12f, 0.61f)
        lineToRelative(1.92f, 3.32f)
        curveToRelative(0.12f, 0.22f, 0.37f, 0.29f, 0.59f, 0.22f)
        lineToRelative(2.39f, -0.96f)
        curveToRelative(0.5f, 0.38f, 1.03f, 0.7f, 1.62f, 0.94f)
        lineToRelative(0.36f, 2.54f)
        curveToRelative(0.05f, 0.24f, 0.24f, 0.41f, 0.48f, 0.41f)
        horizontalLineToRelative(3.84f)
        curveToRelative(0.24f, 0.0f, 0.44f, -0.17f, 0.47f, -0.41f)
        lineToRelative(0.36f, -2.54f)
        curveToRelative(0.59f, -0.24f, 1.13f, -0.56f, 1.62f, -0.94f)
        lineToRelative(2.39f, 0.96f)
        curveToRelative(0.22f, 0.08f, 0.47f, 0.0f, 0.59f, -0.22f)
        lineToRelative(1.92f, -3.32f)
        curveToRelative(0.12f, -0.22f, 0.07f, -0.47f, -0.12f, -0.61f)
        lineTo(19.14f, 12.94f)
        close()
        moveTo(12.0f, 15.6f)
        curveToRelative(-1.98f, 0.0f, -3.6f, -1.62f, -3.6f, -3.6f)
        reflectiveCurveToRelative(1.62f, -3.6f, 3.6f, -3.6f)
        reflectiveCurveToRelative(3.6f, 1.62f, 3.6f, 3.6f)
        reflectiveCurveTo(13.98f, 15.6f, 12.0f, 15.6f)
        close()
    }
}

private val Icon_Info: ImageVector = materialIcon(name = "Outlined.Info") {
    materialPath {
        moveTo(11.0f, 7.0f)
        horizontalLineToRelative(2.0f)
        verticalLineToRelative(2.0f)
        horizontalLineToRelative(-2.0f)
        close()
        moveTo(11.0f, 11.0f)
        horizontalLineToRelative(2.0f)
        verticalLineToRelative(6.0f)
        horizontalLineToRelative(-2.0f)
        close()
        moveTo(12.0f, 2.0f)
        curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
        reflectiveCurveToRelative(4.48f, 10.0f, 10.0f, 10.0f)
        reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
        reflectiveCurveTo(17.52f, 2.0f, 12.0f, 2.0f)
        close()
        moveTo(12.0f, 20.0f)
        curveToRelative(-4.41f, 0.0f, -8.0f, -3.59f, -8.0f, -8.0f)
        reflectiveCurveToRelative(3.59f, -8.0f, 8.0f, -8.0f)
        reflectiveCurveToRelative(8.0f, 3.59f, 8.0f, 8.0f)
        reflectiveCurveToRelative(-3.59f, 8.0f, -8.0f, 8.0f)
        close()
    }
}

private val Icon_Info_Filled: ImageVector = materialIcon(name = "Filled.Info") {
    materialPath {
        moveTo(12.0f, 2.0f)
        curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
        reflectiveCurveToRelative(4.48f, 10.0f, 10.0f, 10.0f)
        reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
        reflectiveCurveTo(17.52f, 2.0f, 12.0f, 2.0f)
        close()
        moveTo(13.0f, 17.0f)
        horizontalLineToRelative(-2.0f)
        verticalLineToRelative(-6.0f)
        horizontalLineToRelative(2.0f)
        verticalLineToRelative(6.0f)
        close()
        moveTo(13.0f, 9.0f)
        horizontalLineToRelative(-2.0f)
        lineTo(11.0f, 7.0f)
        horizontalLineToRelative(2.0f)
        verticalLineToRelative(2.0f)
        close()
    }
}

private val Icons_Filled_Close: ImageVector = materialIcon(name = "Filled.Close") {
    materialPath {
        moveTo(19.0f, 6.41f)
        lineTo(17.59f, 5.0f)
        lineTo(12.0f, 10.59f)
        lineTo(6.41f, 5.0f)
        lineTo(5.0f, 6.41f)
        lineTo(10.59f, 12.0f)
        lineTo(5.0f, 17.59f)
        lineTo(6.41f, 19.0f)
        lineTo(12.0f, 13.41f)
        lineTo(17.59f, 19.0f)
        lineTo(19.0f, 17.59f)
        lineTo(13.41f, 12.0f)
        close()
    }
}