package in.sunilpaulmathew.izzyondroid.utils;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;

import java.io.File;

import in.sunilpaulmathew.izzyondroid.BuildConfig;
import in.sunilpaulmathew.izzyondroid.services.UserService;
import in.sunilpaulmathew.sCommon.CommonUtils.sCommonUtils;
import rikka.shizuku.Shizuku;
import sunilpaulmathew.izzyondroid.IUserService;

/*
 * Created by sunilpaulmathew <sunil.kde@gmail.com> on October 31, 2022
 */
public class ShizukuInstaller {

    private static IUserService mUserService = null;

    public static boolean isShizukuSupported() {
        return Shizuku.pingBinder() && Shizuku.getVersion() >= 11 && !Shizuku.isPreV11();
    }

    public static void ensureUserService(Runnable runnable) {
        if (mUserService != null && runnable != null) {
            runnable.run();
            return;
        }

        Shizuku.UserServiceArgs args = new Shizuku.UserServiceArgs(
                new ComponentName(BuildConfig.APPLICATION_ID, UserService.class.getName()))
                .daemon(false)
                .processNameSuffix("service")
                .debuggable(BuildConfig.DEBUG)
                .version(BuildConfig.VERSION_CODE);

        Shizuku.bindUserService(args, new ServiceConnection() {
            @Override
            public void onServiceConnected(ComponentName name, IBinder binder) {
                if (binder == null || !binder.pingBinder()) return;

                mUserService = UserService.Stub.asInterface(binder);

                if (runnable != null) {
                    new Handler(Looper.getMainLooper()).post(runnable);
                }
            }

            @Override
            public void onServiceDisconnected(ComponentName name) {
                mUserService = null;
            }
        });
    }

    public static String runCommand(String command) {
        if (mUserService != null) {
            try {
                return mUserService.executeShellCommand(command);
            } catch (RemoteException ignored) {
            }
        }
        return "";
    }

    public static void installAPK(File apkFile, Context context) {
        runCommand("cp " + apkFile.getAbsolutePath() + " /data/local/tmp/APK.apk");
        sCommonUtils.saveString("installationStatus", runCommand("pm install /data/local/tmp/APK.apk"), context);
        runCommand("rm -r /data/local/tmp/APK.apk");
    }

}