package in.sunilpaulmathew.izzyondroid.fragments;

import static android.view.View.VISIBLE;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;

import androidx.activity.OnBackPressedCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageButton;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.button.MaterialButton;
import com.google.android.material.card.MaterialCardView;
import com.google.android.material.switchmaterial.SwitchMaterial;
import com.google.android.material.textview.MaterialTextView;
import com.squareup.picasso.Picasso;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import in.sunilpaulmathew.izzyondroid.BuildConfig;
import in.sunilpaulmathew.izzyondroid.R;
import in.sunilpaulmathew.izzyondroid.activities.DeveloperActivity;
import in.sunilpaulmathew.izzyondroid.activities.PackageSearchingActivity;
import in.sunilpaulmathew.izzyondroid.adapters.DetailsAdapter;
import in.sunilpaulmathew.izzyondroid.adapters.ScreenshotsAdapter;
import in.sunilpaulmathew.izzyondroid.utils.Common;
import in.sunilpaulmathew.izzyondroid.utils.PackageData;
import in.sunilpaulmathew.izzyondroid.utils.ShizukuInstaller;
import in.sunilpaulmathew.izzyondroid.utils.tasks.APKDownloadingTask;
import in.sunilpaulmathew.sCommon.APKUtils.sAPKUtils;
import in.sunilpaulmathew.sCommon.CommonUtils.sCommonUtils;
import in.sunilpaulmathew.sCommon.CommonUtils.sExecutor;
import in.sunilpaulmathew.sCommon.CommonUtils.sSerializableItems;
import in.sunilpaulmathew.sCommon.FileUtils.sFileUtils;
import in.sunilpaulmathew.sCommon.PackageUtils.sPackageUtils;
import in.sunilpaulmathew.sCommon.ThemeUtils.sThemeUtils;
import rikka.shizuku.Shizuku;

/*
 * Created by sunilpaulmathew <sunil.kde@gmail.com> on August 19, 2021
 */
public class PackageViewFragment extends Fragment {

    private LinearLayoutCompat mButtonsLayout;

    @SuppressLint("SetTextI18n")
    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View mRootView = inflater.inflate(R.layout.fragment_package_view, container, false);

        AppCompatImageButton mBack = mRootView.findViewById(R.id.back);
        AppCompatImageButton mMinimizeDescription = mRootView.findViewById(R.id.minimize_description);
        AppCompatImageButton mMinimizeScreenshot = mRootView.findViewById(R.id.minimize_screenshot);
        AppCompatImageButton mMinimizeWhatsNew = mRootView.findViewById(R.id.minimize_whatsnew);
        AppCompatImageButton mSearch = mRootView.findViewById(R.id.search);
        AppCompatImageButton mShare = mRootView.findViewById(R.id.share);
        AppCompatImageView mAppImage = mRootView.findViewById(R.id.app_image);
        FrameLayout mAboutFrame = mRootView.findViewById(R.id.about_frame);
        FrameLayout mWhatsNewFrame = mRootView.findViewById(R.id.whatsnew_frame);
        FrameLayout mScreenshotFrame = mRootView.findViewById(R.id.screenshot_frame);
        LinearLayoutCompat mDeveloperPage = mRootView.findViewById(R.id.developer_page);
        LinearLayoutCompat mProgressLayout = mRootView.findViewById(R.id.progress_layout);
        mButtonsLayout = mRootView.findViewById(R.id.button_layout);
        MaterialButton mButtonOne = mRootView.findViewById(R.id.button_one);
        MaterialButton mButtonTwo = mRootView.findViewById(R.id.button_two);
        MaterialButton mSourceWarning = mRootView.findViewById(R.id.source_warning);
        MaterialCardView mWhatsNewCard = mRootView.findViewById(R.id.card_whatsnew);
        MaterialCardView mDescriptionCard = mRootView.findViewById(R.id.card_description);
        MaterialTextView mAppTitle = mRootView.findViewById(R.id.app_title);
        MaterialTextView mAuthorName = mRootView.findViewById(R.id.author_name);
        MaterialTextView mDownloadStatus = mRootView.findViewById(R.id.download_status);
        MaterialTextView mAppDescription = mRootView.findViewById(R.id.app_description);
        MaterialTextView mWhatsNew = mRootView.findViewById(R.id.whats_new);
        MaterialTextView mCancel = mRootView.findViewById(R.id.cancel);
        ProgressBar mProgress = mRootView.findViewById(R.id.progress);
        RecyclerView mRecyclerView = mRootView.findViewById(R.id.recycler_view);
        RecyclerView mRecyclerViewDetails = mRootView.findViewById(R.id.recycler_view_details);
        SwitchMaterial mUpdates = mRootView.findViewById(R.id.updates);

        mRecyclerView.setLayoutManager(new LinearLayoutManager(requireActivity(), LinearLayoutManager.HORIZONTAL, false));
        ScreenshotsAdapter mRecycleViewAdapter = new ScreenshotsAdapter(Common.getScreenshots());
        mRecyclerView.setAdapter(mRecycleViewAdapter);

        mRecyclerViewDetails.setLayoutManager(new LinearLayoutManager(requireActivity()));
        DetailsAdapter mDetailsAdapter = new DetailsAdapter(getDetails());
        mRecyclerViewDetails.setAdapter(mDetailsAdapter);

        File mIgnoreFile = new File(requireActivity().getExternalFilesDir("ignoreList"), Common.getPackageName());

        mAppTitle.setText(Common.getAppName());
        try {
            mAppDescription.setText(Common.getAppSummary().toUpperCase() + "\n\n" + fromHtml(Common.getAppDescription()));
        } catch (NullPointerException ignored) {}
        Picasso.get()
                .load(Common.getAppIconURL())
                .placeholder(R.drawable.ic_android)
                .into(mAppImage);
        mAuthorName.setText(Common.getAuthorName());
        mUpdates.setChecked(sFileUtils.exist(mIgnoreFile));

        if (Common.getAppSummary() == null && Common.getAppDescription() == null) {
            mDescriptionCard.setVisibility(View.GONE);
        }

        if (Common.getChangeLogs() != null) {
            mWhatsNew.setText(Common.getChangeLogs());
        } else {
            mWhatsNewCard.setVisibility(View.GONE);
        }

        if (sPackageUtils.isPackageInstalled(Common.getPackageName(), requireActivity())) {
            if (PackageData.fromProprietarySource(Common.getPackageName(), requireActivity())) {
                mSourceWarning.setVisibility(VISIBLE);
            }
            mUpdates.setVisibility(VISIBLE);
            if (sAPKUtils.getVersionCode(sPackageUtils.getSourceDir(Common.getPackageName(), requireActivity()), requireActivity()) < Integer.parseInt(Common.getVersionCode())) {
                mButtonOne.setText(R.string.update);
            } else {
                mButtonOne.setText(R.string.open);
                mButtonOne.setTextColor(sCommonUtils.getColor(sThemeUtils.isDarkTheme(requireActivity()) ?
                        R.color.colorGreen : R.color.colorBrown, requireActivity()));
            }
            mButtonTwo.setText(R.string.uninstall);
            mButtonTwo.setTextColor(sCommonUtils.getColor(sThemeUtils.isDarkTheme(requireActivity()) ?
                    R.color.colorRed : R.color.colorBrown, requireActivity()));
            mButtonOne.setVisibility(VISIBLE);
            mButtonTwo.setVisibility(VISIBLE);

            mButtonOne.setOnClickListener(v -> {
                if (sAPKUtils.getVersionCode(sPackageUtils.getSourceDir(Common.getPackageName(), requireActivity()), requireActivity()) < Integer.parseInt(Common.getVersionCode())) {
                    if (Common.isDownloading()) {
                        return;
                    }
                    new APKDownloadingTask(mProgressLayout, mButtonsLayout, mProgress, mDownloadStatus, "https://apt.izzysoft.de/fdroid/repo/" +
                            Common.getPackageName() + "_" + Common.getVersionCode() + ".apk", new File(requireActivity().getExternalCacheDir(),
                            "tmp.apk"), requireActivity()).execute();
                } else {
                    Intent launchIntent = requireActivity().getPackageManager().getLaunchIntentForPackage(Common.getPackageName());
                    if (launchIntent != null) {
                        startActivity(launchIntent);
                        requireActivity().finish();
                    }
                }
            });

            mButtonTwo.setOnClickListener(v -> {
                if (ShizukuInstaller.isShizukuSupported() && Shizuku.checkSelfPermission() == PackageManager.PERMISSION_GRANTED) {
                    new sExecutor() {

                        @Override
                        public void onPreExecute() {
                            mButtonsLayout.setVisibility(View.GONE);
                            mProgressLayout.setVisibility(VISIBLE);
                            mProgress.setIndeterminate(true);
                        }

                        @Override
                        public void doInBackground() {
                            ShizukuInstaller.ensureUserService(() -> ShizukuInstaller.runCommand("pm uninstall " + Common.getPackageName()));
                        }

                        @Override
                        public void onPostExecute() {
                            mProgressLayout.setVisibility(View.GONE);
                            mButtonsLayout.setVisibility(VISIBLE);
                            mProgress.setIndeterminate(false);
                            requireActivity().recreate();
                        }
                    }.execute();
                } else {
                    Intent remove = new Intent(Intent.ACTION_DELETE);
                    remove.putExtra(Intent.EXTRA_RETURN_RESULT, true);
                    remove.setData(Uri.parse("package:" + Common.getPackageName()));
                    removeApp.launch(remove);
                }
            });

            mUpdates.setOnClickListener(v -> {
                if (sFileUtils.exist(mIgnoreFile)) {
                    sFileUtils.delete(mIgnoreFile);
                } else {
                    sFileUtils.create(Common.getPackageName(), mIgnoreFile);
                }
            });
        } else {
            mButtonOne.setText(R.string.install);
            mButtonOne.setTextColor(sCommonUtils.getColor(sThemeUtils.isDarkTheme(requireActivity()) ?
                    R.color.colorGreen : R.color.colorTeal, requireActivity()));
            mButtonOne.setVisibility(VISIBLE);

            mButtonOne.setOnClickListener(v -> {
                if (Common.isDownloading()) {
                    return;
                }
                new APKDownloadingTask(mProgressLayout, mButtonsLayout, mProgress, mDownloadStatus,
                        "https://apt.izzysoft.de/fdroid/repo/" + Common.getPackageName() + "_" + Common.getVersionCode() + ".apk", new File(
                        requireActivity().getExternalCacheDir(), "tmp.apk"), requireActivity()).execute();
            });
        }

        mSearch.setOnClickListener(v -> {
            Intent searching = new Intent(requireActivity(), PackageSearchingActivity.class);
            startActivity(searching);
            requireActivity().finish();
        });

        mShare.setOnClickListener(v -> {
            Intent share_app = new Intent();
            share_app.setAction(Intent.ACTION_SEND);
            share_app.putExtra(Intent.EXTRA_SUBJECT, Common.getAppName());
            share_app.putExtra(Intent.EXTRA_TEXT, "https://apt.izzysoft.de/fdroid/index/apk/" + Common.getPackageName()
                    + "\n\n" + getString(R.string.share_message, BuildConfig.VERSION_NAME));
            share_app.setType("text/plain");
            Intent shareIntent = Intent.createChooser(share_app, getString(R.string.share_with));
            startActivity(shareIntent);
        });

        mWhatsNewFrame.setOnClickListener(v -> {
            if (mWhatsNew.getVisibility() == View.GONE) {
                mWhatsNew.setVisibility(VISIBLE);
                mMinimizeWhatsNew.setRotation(180);
            } else {
                mWhatsNew.setVisibility(View.GONE);
                mMinimizeWhatsNew.setRotation(0);
            }
        });

        mAboutFrame.setOnClickListener(v -> {
            if (mAppDescription.getVisibility() == View.GONE) {
                mAppDescription.setVisibility(VISIBLE);
                mMinimizeDescription.setRotation(180);
            } else {
                mAppDescription.setVisibility(View.GONE);
                mMinimizeDescription.setRotation(0);
            }
        });

        mScreenshotFrame.setOnClickListener(v -> {
            if (mRecyclerView.getVisibility() == View.GONE) {
                mRecyclerView.setVisibility(VISIBLE);
                mMinimizeScreenshot.setRotation(180);
            } else {
                mRecyclerView.setVisibility(View.GONE);
                mMinimizeScreenshot.setRotation(0);
            }
        });

        mDeveloperPage.setOnClickListener(v -> {
            Intent developerPage = new Intent(requireActivity(), DeveloperActivity.class);
            startActivity(developerPage);
            requireActivity().finish();
        });

        mBack.setOnClickListener(v -> requireActivity().finish());

        mCancel.setOnClickListener(v -> requireActivity().finish());

        requireActivity().getOnBackPressedDispatcher().addCallback(new OnBackPressedCallback(true) {
            @Override
            public void handleOnBackPressed() {
                requireActivity().finish();
            }
        });

        return mRootView;
    }

    public List<sSerializableItems> getDetails() {
        List<sSerializableItems> mDetails = new ArrayList<>();
        mDetails.add(new sSerializableItems(null, getString(R.string.package_name), Common.getPackageName(), null));
        if (Common.getAuthorWeb() != null) {
            mDetails.add(new sSerializableItems(null, getString(R.string.author_web), Common.getAuthorWeb(), Common.getAuthorWeb()));
        }
        if (Common.getAuthorEmail() != null) {
            mDetails.add(new sSerializableItems(null, getString(R.string.author_email), Common.getAuthorEmail(), "mailto:" + Common.getAuthorEmail()));
        }
        mDetails.add(new sSerializableItems(null, getString(R.string.source_code), Common.getAppSource(requireActivity()), Common.getAppSourceUrl()));
        mDetails.add(new sSerializableItems(null, getString(R.string.released), Common.getAddedTime(), null));
        mDetails.add(new sSerializableItems(null, getString(R.string.updated), Common.getLastUpdated(), null));
        mDetails.add(new sSerializableItems(null, getString(R.string.licence), Common.getLicence(), null));
        if (Common.getDonationLink() != null) {
            mDetails.add(new sSerializableItems(null, getString(R.string.donations), getString(R.string.donations_Summary), Common.getDonationLink()));
        }
        return mDetails;
    }

    private static CharSequence fromHtml(String text) {
        return Html.fromHtml(text, Html.FROM_HTML_MODE_LEGACY);
    }

    ActivityResultLauncher<Intent> removeApp = registerForActivityResult(
            new ActivityResultContracts.StartActivityForResult(),
            result -> {
                if (result.getResultCode() == Activity.RESULT_OK) {
                    requireActivity().recreate();
                }
            }
    );

}